<?php
// This file was auto-generated from sdk-root/src/data/bedrock-runtime/2023-09-30/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Describes the API operations for running inference using Amazon Bedrock models.</p>', 'operations' => [ 'ApplyGuardrail' => '<p>The action to apply a guardrail.</p>', 'Converse' => '<p>Sends messages to the specified Amazon Bedrock model. <code>Converse</code> provides a consistent interface that works with all models that support messages. This allows you to write code once and use it with different models. Should a model have unique inference parameters, you can also pass those unique parameters to the model.</p> <p>For information about the Converse API, see <i>Use the Converse API</i> in the <i>Amazon Bedrock User Guide</i>. To use a guardrail, see <i>Use a guardrail with the Converse API</i> in the <i>Amazon Bedrock User Guide</i>. To use a tool with a model, see <i>Tool use (Function calling)</i> in the <i>Amazon Bedrock User Guide</i> </p> <p>For example code, see <i>Converse API examples</i> in the <i>Amazon Bedrock User Guide</i>. </p> <p>This operation requires permission for the <code>bedrock:InvokeModel</code> action. </p>', 'ConverseStream' => '<p>Sends messages to the specified Amazon Bedrock model and returns the response in a stream. <code>ConverseStream</code> provides a consistent API that works with all Amazon Bedrock models that support messages. This allows you to write code once and use it with different models. Should a model have unique inference parameters, you can also pass those unique parameters to the model. </p> <p>To find out if a model supports streaming, call <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetFoundationModel.html">GetFoundationModel</a> and check the <code>responseStreamingSupported</code> field in the response.</p> <p>For information about the Converse API, see <i>Use the Converse API</i> in the <i>Amazon Bedrock User Guide</i>. To use a guardrail, see <i>Use a guardrail with the Converse API</i> in the <i>Amazon Bedrock User Guide</i>. To use a tool with a model, see <i>Tool use (Function calling)</i> in the <i>Amazon Bedrock User Guide</i> </p> <p>For example code, see <i>Conversation streaming example</i> in the <i>Amazon Bedrock User Guide</i>. </p> <p>This operation requires permission for the <code>bedrock:InvokeModelWithResponseStream</code> action.</p>', 'InvokeModel' => '<p>Invokes the specified Amazon Bedrock model to run inference using the prompt and inference parameters provided in the request body. You use model inference to generate text, images, and embeddings.</p> <p>For example code, see <i>Invoke model code examples</i> in the <i>Amazon Bedrock User Guide</i>. </p> <p>This operation requires permission for the <code>bedrock:InvokeModel</code> action.</p>', 'InvokeModelWithResponseStream' => '<p>Invoke the specified Amazon Bedrock model to run inference using the prompt and inference parameters provided in the request body. The response is returned in a stream.</p> <p>To see if a model supports streaming, call <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetFoundationModel.html">GetFoundationModel</a> and check the <code>responseStreamingSupported</code> field in the response.</p> <note> <p>The CLI doesn\'t support <code>InvokeModelWithResponseStream</code>.</p> </note> <p>For example code, see <i>Invoke model with streaming code example</i> in the <i>Amazon Bedrock User Guide</i>. </p> <p>This operation requires permissions to perform the <code>bedrock:InvokeModelWithResponseStream</code> action. </p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>The request is denied because of missing access permissions.</p>', 'refs' => [], ], 'AnyToolChoice' => [ 'base' => '<p>The model must request at least one tool (no text is generated). For example, <code>{"any" : {}}</code>.</p>', 'refs' => [ 'ToolChoice$any' => '<p>The model must request at least one tool (no text is generated).</p>', ], ], 'ApplyGuardrailRequest' => [ 'base' => NULL, 'refs' => [], ], 'ApplyGuardrailResponse' => [ 'base' => NULL, 'refs' => [], ], 'AutoToolChoice' => [ 'base' => '<p>The Model automatically decides if a tool should be called or whether to generate text instead. For example, <code>{"auto" : {}}</code>.</p>', 'refs' => [ 'ToolChoice$auto' => '<p>(Default). The Model automatically decides if a tool should be called or whether to generate text instead. </p>', ], ], 'Body' => [ 'base' => NULL, 'refs' => [ 'InvokeModelRequest$body' => '<p>The prompt and inference parameters in the format specified in the <code>contentType</code> in the header. You must provide the body in JSON format. To see the format and content of the request and response bodies for different models, refer to <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters</a>. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/api-methods-run.html">Run inference</a> in the Bedrock User Guide.</p>', 'InvokeModelResponse$body' => '<p>Inference response from the model in the format specified in the <code>contentType</code> header. To see the format and content of the request and response bodies for different models, refer to <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters</a>.</p>', 'InvokeModelWithResponseStreamRequest$body' => '<p>The prompt and inference parameters in the format specified in the <code>contentType</code> in the header. You must provide the body in JSON format. To see the format and content of the request and response bodies for different models, refer to <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters</a>. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/api-methods-run.html">Run inference</a> in the Bedrock User Guide.</p>', ], ], 'ContentBlock' => [ 'base' => '<p>A block of content for a message that you pass to, or receive from, a model with the <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html">Converse</a> or <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_ConverseStream.html">ConverseStream</a> API operations.</p>', 'refs' => [ 'ContentBlocks$member' => NULL, ], ], 'ContentBlockDelta' => [ 'base' => '<p>A bock of content in a streaming response.</p>', 'refs' => [ 'ContentBlockDeltaEvent$delta' => '<p>The delta for a content block delta event.</p>', ], ], 'ContentBlockDeltaEvent' => [ 'base' => '<p>The content block delta event.</p>', 'refs' => [ 'ConverseStreamOutput$contentBlockDelta' => '<p>The messages output content block delta.</p>', ], ], 'ContentBlockStart' => [ 'base' => '<p>Content block start information.</p>', 'refs' => [ 'ContentBlockStartEvent$start' => '<p>Start information about a content block start event. </p>', ], ], 'ContentBlockStartEvent' => [ 'base' => '<p>Content block start event.</p>', 'refs' => [ 'ConverseStreamOutput$contentBlockStart' => '<p>Start information for a content block.</p>', ], ], 'ContentBlockStopEvent' => [ 'base' => '<p>A content block stop event.</p>', 'refs' => [ 'ConverseStreamOutput$contentBlockStop' => '<p>Stop information for a content block.</p>', ], ], 'ContentBlocks' => [ 'base' => NULL, 'refs' => [ 'Message$content' => '<p>The message content. Note the following restrictions:</p> <ul> <li> <p>You can include up to 20 images. Each image\'s size, height, and width must be no more than 3.75 MB, 8000 px, and 8000 px, respectively.</p> </li> <li> <p>You can include up to five documents. Each document\'s size must be no more than 4.5 MB.</p> </li> <li> <p>If you include a <code>ContentBlock</code> with a <code>document</code> field in the array, you must also include a <code>ContentBlock</code> with a <code>text</code> field.</p> </li> <li> <p>You can only include images and documents if the <code>role</code> is <code>user</code>.</p> </li> </ul>', ], ], 'ConversationRole' => [ 'base' => NULL, 'refs' => [ 'Message$role' => '<p>The role that the message plays in the message.</p>', 'MessageStartEvent$role' => '<p>The role for the message.</p>', ], ], 'ConversationalModelId' => [ 'base' => NULL, 'refs' => [ 'ConverseRequest$modelId' => '<p>The identifier for the model that you want to call.</p> <p>The <code>modelId</code> to provide depends on the type of model that you use:</p> <ul> <li> <p>If you use a base model, specify the model ID or its ARN. For a list of model IDs for base models, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-ids.html#model-ids-arns">Amazon Bedrock base model IDs (on-demand throughput)</a> in the Amazon Bedrock User Guide.</p> </li> <li> <p>If you use a provisioned model, specify the ARN of the Provisioned Throughput. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/prov-thru-use.html">Run inference using a Provisioned Throughput</a> in the Amazon Bedrock User Guide.</p> </li> <li> <p>If you use a custom model, first purchase Provisioned Throughput for it. Then specify the ARN of the resulting provisioned model. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-use.html">Use a custom model in Amazon Bedrock</a> in the Amazon Bedrock User Guide.</p> </li> </ul>', 'ConverseStreamRequest$modelId' => '<p>The ID for the model.</p> <p>The <code>modelId</code> to provide depends on the type of model that you use:</p> <ul> <li> <p>If you use a base model, specify the model ID or its ARN. For a list of model IDs for base models, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-ids.html#model-ids-arns">Amazon Bedrock base model IDs (on-demand throughput)</a> in the Amazon Bedrock User Guide.</p> </li> <li> <p>If you use a provisioned model, specify the ARN of the Provisioned Throughput. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/prov-thru-use.html">Run inference using a Provisioned Throughput</a> in the Amazon Bedrock User Guide.</p> </li> <li> <p>If you use a custom model, first purchase Provisioned Throughput for it. Then specify the ARN of the resulting provisioned model. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-use.html">Use a custom model in Amazon Bedrock</a> in the Amazon Bedrock User Guide.</p> </li> </ul>', ], ], 'ConverseMetrics' => [ 'base' => '<p>Metrics for a call to <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html">Converse</a>.</p>', 'refs' => [ 'ConverseResponse$metrics' => '<p>Metrics for the call to <code>Converse</code>.</p>', ], ], 'ConverseOutput' => [ 'base' => '<p>The output from a call to <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html">Converse</a>.</p>', 'refs' => [ 'ConverseResponse$output' => '<p>The result from the call to <code>Converse</code>.</p>', ], ], 'ConverseRequest' => [ 'base' => NULL, 'refs' => [], ], 'ConverseRequestAdditionalModelResponseFieldPathsList' => [ 'base' => NULL, 'refs' => [ 'ConverseRequest$additionalModelResponseFieldPaths' => '<p>Additional model parameters field paths to return in the response. <code>Converse</code> returns the requested fields as a JSON Pointer object in the <code>additionalModelResponseFields</code> field. The following is example JSON for <code>additionalModelResponseFieldPaths</code>.</p> <p> <code>[ "/stop_sequence" ]</code> </p> <p>For information about the JSON Pointer syntax, see the <a href="https://datatracker.ietf.org/doc/html/rfc6901">Internet Engineering Task Force (IETF)</a> documentation.</p> <p> <code>Converse</code> rejects an empty JSON Pointer or incorrectly structured JSON Pointer with a <code>400</code> error code. if the JSON Pointer is valid, but the requested field is not in the model response, it is ignored by <code>Converse</code>.</p>', ], ], 'ConverseRequestAdditionalModelResponseFieldPathsListMemberString' => [ 'base' => NULL, 'refs' => [ 'ConverseRequestAdditionalModelResponseFieldPathsList$member' => NULL, ], ], 'ConverseResponse' => [ 'base' => NULL, 'refs' => [], ], 'ConverseStreamMetadataEvent' => [ 'base' => '<p>A conversation stream metadata event.</p>', 'refs' => [ 'ConverseStreamOutput$metadata' => '<p>Metadata for the converse output stream.</p>', ], ], 'ConverseStreamMetrics' => [ 'base' => '<p>Metrics for the stream.</p>', 'refs' => [ 'ConverseStreamMetadataEvent$metrics' => '<p>The metrics for the conversation stream metadata event.</p>', ], ], 'ConverseStreamOutput' => [ 'base' => '<p>The messages output stream</p>', 'refs' => [ 'ConverseStreamResponse$stream' => '<p>The output stream that the model generated.</p>', ], ], 'ConverseStreamRequest' => [ 'base' => NULL, 'refs' => [], ], 'ConverseStreamRequestAdditionalModelResponseFieldPathsList' => [ 'base' => NULL, 'refs' => [ 'ConverseStreamRequest$additionalModelResponseFieldPaths' => '<p>Additional model parameters field paths to return in the response. <code>ConverseStream</code> returns the requested fields as a JSON Pointer object in the <code>additionalModelResponseFields</code> field. The following is example JSON for <code>additionalModelResponseFieldPaths</code>.</p> <p> <code>[ "/stop_sequence" ]</code> </p> <p>For information about the JSON Pointer syntax, see the <a href="https://datatracker.ietf.org/doc/html/rfc6901">Internet Engineering Task Force (IETF)</a> documentation.</p> <p> <code>ConverseStream</code> rejects an empty JSON Pointer or incorrectly structured JSON Pointer with a <code>400</code> error code. if the JSON Pointer is valid, but the requested field is not in the model response, it is ignored by <code>ConverseStream</code>.</p>', ], ], 'ConverseStreamRequestAdditionalModelResponseFieldPathsListMemberString' => [ 'base' => NULL, 'refs' => [ 'ConverseStreamRequestAdditionalModelResponseFieldPathsList$member' => NULL, ], ], 'ConverseStreamResponse' => [ 'base' => NULL, 'refs' => [], ], 'ConverseStreamTrace' => [ 'base' => '<p>The trace object in a response from <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_ConverseStream.html">ConverseStream</a>. Currently, you can only trace guardrails.</p>', 'refs' => [ 'ConverseStreamMetadataEvent$trace' => '<p>The trace object in the response from <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_ConverseStream.html">ConverseStream</a> that contains information about the guardrail behavior.</p>', ], ], 'ConverseTrace' => [ 'base' => '<p>The trace object in a response from <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html">Converse</a>. Currently, you can only trace guardrails.</p>', 'refs' => [ 'ConverseResponse$trace' => '<p>A trace object that contains information about the Guardrail behavior.</p>', ], ], 'Document' => [ 'base' => NULL, 'refs' => [ 'ConverseRequest$additionalModelRequestFields' => '<p>Additional inference parameters that the model supports, beyond the base set of inference parameters that <code>Converse</code> supports in the <code>inferenceConfig</code> field. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Model parameters</a>.</p>', 'ConverseResponse$additionalModelResponseFields' => '<p>Additional fields in the response that are unique to the model. </p>', 'ConverseStreamRequest$additionalModelRequestFields' => '<p>Additional inference parameters that the model supports, beyond the base set of inference parameters that <code>ConverseStream</code> supports in the <code>inferenceConfig</code> field.</p>', 'MessageStopEvent$additionalModelResponseFields' => '<p>The additional model response fields.</p>', 'ToolInputSchema$json' => '<p>The JSON schema for the tool. For more information, see <a href="https://json-schema.org/understanding-json-schema/reference">JSON Schema Reference</a>.</p>', 'ToolResultContentBlock$json' => '<p>A tool result that is JSON format data.</p>', 'ToolUseBlock$input' => '<p>The input to pass to the tool. </p>', ], ], 'DocumentBlock' => [ 'base' => '<p>A document to include in a message.</p>', 'refs' => [ 'ContentBlock$document' => '<p>A document to include in the message.</p>', 'ToolResultContentBlock$document' => '<p>A tool result that is a document.</p>', ], ], 'DocumentBlockNameString' => [ 'base' => NULL, 'refs' => [ 'DocumentBlock$name' => '<p>A name for the document. The name can only contain the following characters:</p> <ul> <li> <p>Alphanumeric characters</p> </li> <li> <p>Whitespace characters (no more than one in a row)</p> </li> <li> <p>Hyphens</p> </li> <li> <p>Parentheses</p> </li> <li> <p>Square brackets</p> </li> </ul> <note> <p>This field is vulnerable to prompt injections, because the model might inadvertently interpret it as instructions. Therefore, we recommend that you specify a neutral name.</p> </note>', ], ], 'DocumentFormat' => [ 'base' => NULL, 'refs' => [ 'DocumentBlock$format' => '<p>The format of a document, or its extension.</p>', ], ], 'DocumentSource' => [ 'base' => '<p>Contains the content of a document.</p>', 'refs' => [ 'DocumentBlock$source' => '<p>Contains the content of the document.</p>', ], ], 'DocumentSourceBytesBlob' => [ 'base' => NULL, 'refs' => [ 'DocumentSource$bytes' => '<p>The raw bytes for the document. If you use an Amazon Web Services SDK, you don\'t need to encode the bytes in base64.</p>', ], ], 'GuardrailAction' => [ 'base' => NULL, 'refs' => [ 'ApplyGuardrailResponse$action' => '<p>The action taken in the response from the guardrail.</p>', ], ], 'GuardrailAssessment' => [ 'base' => '<p>A behavior assessment of the guardrail policies used in a call to the Converse API. </p>', 'refs' => [ 'GuardrailAssessmentList$member' => NULL, 'GuardrailAssessmentMap$value' => NULL, ], ], 'GuardrailAssessmentList' => [ 'base' => NULL, 'refs' => [ 'ApplyGuardrailResponse$assessments' => '<p>The assessment details in the response from the guardrail.</p>', 'GuardrailAssessmentListMap$value' => NULL, ], ], 'GuardrailAssessmentListMap' => [ 'base' => NULL, 'refs' => [ 'GuardrailTraceAssessment$outputAssessments' => '<p>the output assessments.</p>', ], ], 'GuardrailAssessmentMap' => [ 'base' => NULL, 'refs' => [ 'GuardrailTraceAssessment$inputAssessment' => '<p>The input assessment.</p>', ], ], 'GuardrailConfiguration' => [ 'base' => '<p>Configuration information for a guardrail that you use with the <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html">Converse</a> operation.</p>', 'refs' => [ 'ConverseRequest$guardrailConfig' => '<p>Configuration information for a guardrail that you want to use in the request. </p>', ], ], 'GuardrailContentBlock' => [ 'base' => '<p>The content block to be evaluated by the guardrail.</p>', 'refs' => [ 'GuardrailContentBlockList$member' => NULL, ], ], 'GuardrailContentBlockList' => [ 'base' => NULL, 'refs' => [ 'ApplyGuardrailRequest$content' => '<p>The content details used in the request to apply the guardrail.</p>', ], ], 'GuardrailContentFilter' => [ 'base' => '<p>The content filter for a guardrail.</p>', 'refs' => [ 'GuardrailContentFilterList$member' => NULL, ], ], 'GuardrailContentFilterConfidence' => [ 'base' => NULL, 'refs' => [ 'GuardrailContentFilter$confidence' => '<p>The guardrail confidence.</p>', ], ], 'GuardrailContentFilterList' => [ 'base' => NULL, 'refs' => [ 'GuardrailContentPolicyAssessment$filters' => '<p>The content policy filters.</p>', ], ], 'GuardrailContentFilterType' => [ 'base' => NULL, 'refs' => [ 'GuardrailContentFilter$type' => '<p>The guardrail type.</p>', ], ], 'GuardrailContentPolicyAction' => [ 'base' => NULL, 'refs' => [ 'GuardrailContentFilter$action' => '<p>The guardrail action.</p>', ], ], 'GuardrailContentPolicyAssessment' => [ 'base' => '<p>An assessment of a content policy for a guardrail.</p>', 'refs' => [ 'GuardrailAssessment$contentPolicy' => '<p>The content policy.</p>', ], ], 'GuardrailContentPolicyUnitsProcessed' => [ 'base' => NULL, 'refs' => [ 'GuardrailUsage$contentPolicyUnits' => '<p>The content policy units processed by the guardrail.</p>', ], ], 'GuardrailContentQualifier' => [ 'base' => NULL, 'refs' => [ 'GuardrailContentQualifierList$member' => NULL, ], ], 'GuardrailContentQualifierList' => [ 'base' => NULL, 'refs' => [ 'GuardrailTextBlock$qualifiers' => '<p>The qualifiers describing the text block.</p>', ], ], 'GuardrailContentSource' => [ 'base' => NULL, 'refs' => [ 'ApplyGuardrailRequest$source' => '<p>The source of data used in the request to apply the guardrail.</p>', ], ], 'GuardrailContextualGroundingFilter' => [ 'base' => '<p>The details for the guardrails contextual grounding filter.</p>', 'refs' => [ 'GuardrailContextualGroundingFilters$member' => NULL, ], ], 'GuardrailContextualGroundingFilterScoreDouble' => [ 'base' => NULL, 'refs' => [ 'GuardrailContextualGroundingFilter$score' => '<p>The score generated by contextual grounding filter.</p>', ], ], 'GuardrailContextualGroundingFilterThresholdDouble' => [ 'base' => NULL, 'refs' => [ 'GuardrailContextualGroundingFilter$threshold' => '<p>The threshold used by contextual grounding filter to determine whether the content is grounded or not.</p>', ], ], 'GuardrailContextualGroundingFilterType' => [ 'base' => NULL, 'refs' => [ 'GuardrailContextualGroundingFilter$type' => '<p>The contextual grounding filter type.</p>', ], ], 'GuardrailContextualGroundingFilters' => [ 'base' => NULL, 'refs' => [ 'GuardrailContextualGroundingPolicyAssessment$filters' => '<p>The filter details for the guardrails contextual grounding filter.</p>', ], ], 'GuardrailContextualGroundingPolicyAction' => [ 'base' => NULL, 'refs' => [ 'GuardrailContextualGroundingFilter$action' => '<p>The action performed by the guardrails contextual grounding filter.</p>', ], ], 'GuardrailContextualGroundingPolicyAssessment' => [ 'base' => '<p>The policy assessment details for the guardrails contextual grounding filter.</p>', 'refs' => [ 'GuardrailAssessment$contextualGroundingPolicy' => '<p>The contextual grounding policy used for the guardrail assessment.</p>', ], ], 'GuardrailContextualGroundingPolicyUnitsProcessed' => [ 'base' => NULL, 'refs' => [ 'GuardrailUsage$contextualGroundingPolicyUnits' => '<p>The contextual grounding policy units processed by the guardrail.</p>', ], ], 'GuardrailConverseContentBlock' => [ 'base' => '<p/> <p>A content block for selective guarding with the <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html">Converse</a> or <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_ConverseStream.html">ConverseStream</a> API operations. </p>', 'refs' => [ 'ContentBlock$guardContent' => '<p>Contains the content to assess with the guardrail. If you don\'t specify <code>guardContent</code> in a call to the Converse API, the guardrail (if passed in the Converse API) assesses the entire message.</p> <p>For more information, see <i>Use a guardrail with the Converse API</i> in the <i>Amazon Bedrock User Guide</i>. <pre><code> &lt;/p&gt; </code></pre>', 'SystemContentBlock$guardContent' => '<p>A content block to assess with the guardrail. Use with the <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html">Converse</a> or <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_ConverseStream.html">ConverseStream</a> API operations. </p> <p>For more information, see <i>Use a guardrail with the Converse API</i> in the <i>Amazon Bedrock User Guide</i>.</p>', ], ], 'GuardrailConverseContentQualifier' => [ 'base' => NULL, 'refs' => [ 'GuardrailConverseContentQualifierList$member' => NULL, ], ], 'GuardrailConverseContentQualifierList' => [ 'base' => NULL, 'refs' => [ 'GuardrailConverseTextBlock$qualifiers' => '<p>The qualifier details for the guardrails contextual grounding filter.</p>', ], ], 'GuardrailConverseTextBlock' => [ 'base' => '<p>A text block that contains text that you want to assess with a guardrail. For more information, see <a>GuardrailConverseContentBlock</a>.</p>', 'refs' => [ 'GuardrailConverseContentBlock$text' => '<p>The text to guard.</p>', ], ], 'GuardrailCustomWord' => [ 'base' => '<p>A custom word configured in a guardrail.</p>', 'refs' => [ 'GuardrailCustomWordList$member' => NULL, ], ], 'GuardrailCustomWordList' => [ 'base' => NULL, 'refs' => [ 'GuardrailWordPolicyAssessment$customWords' => '<p>Custom words in the assessment.</p>', ], ], 'GuardrailIdentifier' => [ 'base' => NULL, 'refs' => [ 'ApplyGuardrailRequest$guardrailIdentifier' => '<p>The guardrail identifier used in the request to apply the guardrail.</p>', 'GuardrailConfiguration$guardrailIdentifier' => '<p>The identifier for the guardrail.</p>', 'GuardrailStreamConfiguration$guardrailIdentifier' => '<p>The identifier for the guardrail.</p>', 'InvokeModelRequest$guardrailIdentifier' => '<p>The unique identifier of the guardrail that you want to use. If you don\'t provide a value, no guardrail is applied to the invocation.</p> <p>An error will be thrown in the following situations.</p> <ul> <li> <p>You don\'t provide a guardrail identifier but you specify the <code>amazon-bedrock-guardrailConfig</code> field in the request body.</p> </li> <li> <p>You enable the guardrail but the <code>contentType</code> isn\'t <code>application/json</code>.</p> </li> <li> <p>You provide a guardrail identifier, but <code>guardrailVersion</code> isn\'t specified.</p> </li> </ul>', 'InvokeModelWithResponseStreamRequest$guardrailIdentifier' => '<p>The unique identifier of the guardrail that you want to use. If you don\'t provide a value, no guardrail is applied to the invocation.</p> <p>An error is thrown in the following situations.</p> <ul> <li> <p>You don\'t provide a guardrail identifier but you specify the <code>amazon-bedrock-guardrailConfig</code> field in the request body.</p> </li> <li> <p>You enable the guardrail but the <code>contentType</code> isn\'t <code>application/json</code>.</p> </li> <li> <p>You provide a guardrail identifier, but <code>guardrailVersion</code> isn\'t specified.</p> </li> </ul>', ], ], 'GuardrailManagedWord' => [ 'base' => '<p>A managed word configured in a guardrail.</p>', 'refs' => [ 'GuardrailManagedWordList$member' => NULL, ], ], 'GuardrailManagedWordList' => [ 'base' => NULL, 'refs' => [ 'GuardrailWordPolicyAssessment$managedWordLists' => '<p>Managed word lists in the assessment.</p>', ], ], 'GuardrailManagedWordType' => [ 'base' => NULL, 'refs' => [ 'GuardrailManagedWord$type' => '<p>The type for the managed word.</p>', ], ], 'GuardrailOutputContent' => [ 'base' => '<p>The output content produced by the guardrail.</p>', 'refs' => [ 'GuardrailOutputContentList$member' => NULL, ], ], 'GuardrailOutputContentList' => [ 'base' => NULL, 'refs' => [ 'ApplyGuardrailResponse$outputs' => '<p>The output details in the response from the guardrail.</p>', ], ], 'GuardrailOutputText' => [ 'base' => NULL, 'refs' => [ 'GuardrailOutputContent$text' => '<p>The specific text for the output content produced by the guardrail.</p>', 'ModelOutputs$member' => NULL, ], ], 'GuardrailPiiEntityFilter' => [ 'base' => '<p>A Personally Identifiable Information (PII) entity configured in a guardrail.</p>', 'refs' => [ 'GuardrailPiiEntityFilterList$member' => NULL, ], ], 'GuardrailPiiEntityFilterList' => [ 'base' => NULL, 'refs' => [ 'GuardrailSensitiveInformationPolicyAssessment$piiEntities' => '<p>The PII entities in the assessment.</p>', ], ], 'GuardrailPiiEntityType' => [ 'base' => NULL, 'refs' => [ 'GuardrailPiiEntityFilter$type' => '<p>The PII entity filter type.</p>', ], ], 'GuardrailRegexFilter' => [ 'base' => '<p>A Regex filter configured in a guardrail.</p>', 'refs' => [ 'GuardrailRegexFilterList$member' => NULL, ], ], 'GuardrailRegexFilterList' => [ 'base' => NULL, 'refs' => [ 'GuardrailSensitiveInformationPolicyAssessment$regexes' => '<p>The regex queries in the assessment.</p>', ], ], 'GuardrailSensitiveInformationPolicyAction' => [ 'base' => NULL, 'refs' => [ 'GuardrailPiiEntityFilter$action' => '<p>The PII entity filter action.</p>', 'GuardrailRegexFilter$action' => '<p>The region filter action.</p>', ], ], 'GuardrailSensitiveInformationPolicyAssessment' => [ 'base' => '<p>The assessment for aPersonally Identifiable Information (PII) policy. </p>', 'refs' => [ 'GuardrailAssessment$sensitiveInformationPolicy' => '<p>The sensitive information policy.</p>', ], ], 'GuardrailSensitiveInformationPolicyFreeUnitsProcessed' => [ 'base' => NULL, 'refs' => [ 'GuardrailUsage$sensitiveInformationPolicyFreeUnits' => '<p>The sensitive information policy free units processed by the guardrail.</p>', ], ], 'GuardrailSensitiveInformationPolicyUnitsProcessed' => [ 'base' => NULL, 'refs' => [ 'GuardrailUsage$sensitiveInformationPolicyUnits' => '<p>The sensitive information policy units processed by the guardrail.</p>', ], ], 'GuardrailStreamConfiguration' => [ 'base' => '<p>Configuration information for a guardrail that you use with the <a>ConverseStream</a> action. </p>', 'refs' => [ 'ConverseStreamRequest$guardrailConfig' => '<p>Configuration information for a guardrail that you want to use in the request. </p>', ], ], 'GuardrailStreamProcessingMode' => [ 'base' => NULL, 'refs' => [ 'GuardrailStreamConfiguration$streamProcessingMode' => '<p>The processing mode. </p> <p>The processing mode. For more information, see <i>Configure streaming response behavior</i> in the <i>Amazon Bedrock User Guide</i>. </p>', ], ], 'GuardrailTextBlock' => [ 'base' => '<p>The text block to be evaluated by the guardrail.</p>', 'refs' => [ 'GuardrailContentBlock$text' => '<p>Text within content block to be evaluated by the guardrail.</p>', ], ], 'GuardrailTopic' => [ 'base' => '<p>Information about a topic guardrail.</p>', 'refs' => [ 'GuardrailTopicList$member' => NULL, ], ], 'GuardrailTopicList' => [ 'base' => NULL, 'refs' => [ 'GuardrailTopicPolicyAssessment$topics' => '<p>The topics in the assessment.</p>', ], ], 'GuardrailTopicPolicyAction' => [ 'base' => NULL, 'refs' => [ 'GuardrailTopic$action' => '<p>The action the guardrail should take when it intervenes on a topic.</p>', ], ], 'GuardrailTopicPolicyAssessment' => [ 'base' => '<p>A behavior assessment of a topic policy.</p>', 'refs' => [ 'GuardrailAssessment$topicPolicy' => '<p>The topic policy.</p>', ], ], 'GuardrailTopicPolicyUnitsProcessed' => [ 'base' => NULL, 'refs' => [ 'GuardrailUsage$topicPolicyUnits' => '<p>The topic policy units processed by the guardrail.</p>', ], ], 'GuardrailTopicType' => [ 'base' => NULL, 'refs' => [ 'GuardrailTopic$type' => '<p>The type behavior that the guardrail should perform when the model detects the topic.</p>', ], ], 'GuardrailTrace' => [ 'base' => NULL, 'refs' => [ 'GuardrailConfiguration$trace' => '<p>The trace behavior for the guardrail.</p>', 'GuardrailStreamConfiguration$trace' => '<p>The trace behavior for the guardrail.</p>', ], ], 'GuardrailTraceAssessment' => [ 'base' => '<p>A Top level guardrail trace object. For more information, see <a>ConverseTrace</a>.</p>', 'refs' => [ 'ConverseStreamTrace$guardrail' => '<p>The guardrail trace object. </p>', 'ConverseTrace$guardrail' => '<p>The guardrail trace object. </p>', ], ], 'GuardrailUsage' => [ 'base' => '<p>The details on the use of the guardrail.</p>', 'refs' => [ 'ApplyGuardrailResponse$usage' => '<p>The usage details in the response from the guardrail.</p>', ], ], 'GuardrailVersion' => [ 'base' => NULL, 'refs' => [ 'ApplyGuardrailRequest$guardrailVersion' => '<p>The guardrail version used in the request to apply the guardrail.</p>', 'GuardrailConfiguration$guardrailVersion' => '<p>The version of the guardrail.</p>', 'GuardrailStreamConfiguration$guardrailVersion' => '<p>The version of the guardrail.</p>', 'InvokeModelRequest$guardrailVersion' => '<p>The version number for the guardrail. The value can also be <code>DRAFT</code>.</p>', 'InvokeModelWithResponseStreamRequest$guardrailVersion' => '<p>The version number for the guardrail. The value can also be <code>DRAFT</code>.</p>', ], ], 'GuardrailWordPolicyAction' => [ 'base' => NULL, 'refs' => [ 'GuardrailCustomWord$action' => '<p>The action for the custom word.</p>', 'GuardrailManagedWord$action' => '<p>The action for the managed word.</p>', ], ], 'GuardrailWordPolicyAssessment' => [ 'base' => '<p>The word policy assessment.</p>', 'refs' => [ 'GuardrailAssessment$wordPolicy' => '<p>The word policy.</p>', ], ], 'GuardrailWordPolicyUnitsProcessed' => [ 'base' => NULL, 'refs' => [ 'GuardrailUsage$wordPolicyUnits' => '<p>The word policy units processed by the guardrail.</p>', ], ], 'ImageBlock' => [ 'base' => '<p>Image content for a message.</p>', 'refs' => [ 'ContentBlock$image' => '<p>Image to include in the message. </p> <note> <p>This field is only supported by Anthropic Claude 3 models.</p> </note>', 'ToolResultContentBlock$image' => '<p>A tool result that is an image.</p> <note> <p>This field is only supported by Anthropic Claude 3 models.</p> </note>', ], ], 'ImageFormat' => [ 'base' => NULL, 'refs' => [ 'ImageBlock$format' => '<p>The format of the image.</p>', ], ], 'ImageSource' => [ 'base' => '<p>The source for an image.</p>', 'refs' => [ 'ImageBlock$source' => '<p>The source for the image.</p>', ], ], 'ImageSourceBytesBlob' => [ 'base' => NULL, 'refs' => [ 'ImageSource$bytes' => '<p>The raw image bytes for the image. If you use an AWS SDK, you don\'t need to encode the image bytes in base64.</p>', ], ], 'InferenceConfiguration' => [ 'base' => '<p>Base inference parameters to pass to a model in a call to <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html">Converse</a> or <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_ConverseStream.html">ConverseStream</a>. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters for foundation models</a>.</p> <p>If you need to pass additional parameters that the model supports, use the <code>additionalModelRequestFields</code> request field in the call to <code>Converse</code> or <code>ConverseStream</code>. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Model parameters</a>.</p>', 'refs' => [ 'ConverseRequest$inferenceConfig' => '<p>Inference parameters to pass to the model. <code>Converse</code> supports a base set of inference parameters. If you need to pass additional parameters that the model supports, use the <code>additionalModelRequestFields</code> request field.</p>', 'ConverseStreamRequest$inferenceConfig' => '<p>Inference parameters to pass to the model. <code>ConverseStream</code> supports a base set of inference parameters. If you need to pass additional parameters that the model supports, use the <code>additionalModelRequestFields</code> request field.</p>', ], ], 'InferenceConfigurationMaxTokensInteger' => [ 'base' => NULL, 'refs' => [ 'InferenceConfiguration$maxTokens' => '<p>The maximum number of tokens to allow in the generated response. The default value is the maximum allowed value for the model that you are using. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters for foundation models</a>. </p>', ], ], 'InferenceConfigurationStopSequencesList' => [ 'base' => NULL, 'refs' => [ 'InferenceConfiguration$stopSequences' => '<p>A list of stop sequences. A stop sequence is a sequence of characters that causes the model to stop generating the response. </p>', ], ], 'InferenceConfigurationTemperatureFloat' => [ 'base' => NULL, 'refs' => [ 'InferenceConfiguration$temperature' => '<p>The likelihood of the model selecting higher-probability options while generating a response. A lower value makes the model more likely to choose higher-probability options, while a higher value makes the model more likely to choose lower-probability options.</p> <p>The default value is the default value for the model that you are using. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters for foundation models</a>. </p>', ], ], 'InferenceConfigurationTopPFloat' => [ 'base' => NULL, 'refs' => [ 'InferenceConfiguration$topP' => '<p>The percentage of most-likely candidates that the model considers for the next token. For example, if you choose a value of 0.8 for <code>topP</code>, the model selects from the top 80% of the probability distribution of tokens that could be next in the sequence.</p> <p>The default value is the default value for the model that you are using. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters for foundation models</a>. </p>', ], ], 'InternalServerException' => [ 'base' => '<p>An internal server error occurred. Retry your request.</p>', 'refs' => [ 'ConverseStreamOutput$internalServerException' => '<p>An internal server error occurred. Retry your request.</p>', 'ResponseStream$internalServerException' => '<p>An internal server error occurred. Retry your request.</p>', ], ], 'InvokeModelIdentifier' => [ 'base' => NULL, 'refs' => [ 'InvokeModelRequest$modelId' => '<p>The unique identifier of the model to invoke to run inference.</p> <p>The <code>modelId</code> to provide depends on the type of model that you use:</p> <ul> <li> <p>If you use a base model, specify the model ID or its ARN. For a list of model IDs for base models, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-ids.html#model-ids-arns">Amazon Bedrock base model IDs (on-demand throughput)</a> in the Amazon Bedrock User Guide.</p> </li> <li> <p>If you use a provisioned model, specify the ARN of the Provisioned Throughput. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/prov-thru-use.html">Run inference using a Provisioned Throughput</a> in the Amazon Bedrock User Guide.</p> </li> <li> <p>If you use a custom model, first purchase Provisioned Throughput for it. Then specify the ARN of the resulting provisioned model. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-use.html">Use a custom model in Amazon Bedrock</a> in the Amazon Bedrock User Guide.</p> </li> </ul>', 'InvokeModelWithResponseStreamRequest$modelId' => '<p>The unique identifier of the model to invoke to run inference.</p> <p>The <code>modelId</code> to provide depends on the type of model that you use:</p> <ul> <li> <p>If you use a base model, specify the model ID or its ARN. For a list of model IDs for base models, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-ids.html#model-ids-arns">Amazon Bedrock base model IDs (on-demand throughput)</a> in the Amazon Bedrock User Guide.</p> </li> <li> <p>If you use a provisioned model, specify the ARN of the Provisioned Throughput. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/prov-thru-use.html">Run inference using a Provisioned Throughput</a> in the Amazon Bedrock User Guide.</p> </li> <li> <p>If you use a custom model, first purchase Provisioned Throughput for it. Then specify the ARN of the resulting provisioned model. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-use.html">Use a custom model in Amazon Bedrock</a> in the Amazon Bedrock User Guide.</p> </li> </ul>', ], ], 'InvokeModelRequest' => [ 'base' => NULL, 'refs' => [], ], 'InvokeModelResponse' => [ 'base' => NULL, 'refs' => [], ], 'InvokeModelWithResponseStreamRequest' => [ 'base' => NULL, 'refs' => [], ], 'InvokeModelWithResponseStreamResponse' => [ 'base' => NULL, 'refs' => [], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'ConverseMetrics$latencyMs' => '<p>The latency of the call to <code>Converse</code>, in milliseconds. </p>', 'ConverseStreamMetrics$latencyMs' => '<p>The latency for the streaming request, in milliseconds.</p>', ], ], 'Message' => [ 'base' => '<p>A message input, or returned from, a call to <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html">Converse</a> or <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_ConverseStream.html">ConverseStream</a>.</p>', 'refs' => [ 'ConverseOutput$message' => '<p>The message that the model generates.</p>', 'Messages$member' => NULL, ], ], 'MessageStartEvent' => [ 'base' => '<p>The start of a message.</p>', 'refs' => [ 'ConverseStreamOutput$messageStart' => '<p>Message start information.</p>', ], ], 'MessageStopEvent' => [ 'base' => '<p>The stop event for a message.</p>', 'refs' => [ 'ConverseStreamOutput$messageStop' => '<p>Message stop information.</p>', ], ], 'Messages' => [ 'base' => NULL, 'refs' => [ 'ConverseRequest$messages' => '<p>The messages that you want to send to the model.</p>', 'ConverseStreamRequest$messages' => '<p>The messages that you want to send to the model.</p>', ], ], 'MimeType' => [ 'base' => NULL, 'refs' => [ 'InvokeModelRequest$contentType' => '<p>The MIME type of the input data in the request. You must specify <code>application/json</code>.</p>', 'InvokeModelRequest$accept' => '<p>The desired MIME type of the inference body in the response. The default value is <code>application/json</code>.</p>', 'InvokeModelResponse$contentType' => '<p>The MIME type of the inference result.</p>', 'InvokeModelWithResponseStreamRequest$contentType' => '<p>The MIME type of the input data in the request. You must specify <code>application/json</code>.</p>', 'InvokeModelWithResponseStreamRequest$accept' => '<p>The desired MIME type of the inference body in the response. The default value is <code>application/json</code>.</p>', 'InvokeModelWithResponseStreamResponse$contentType' => '<p>The MIME type of the inference result.</p>', ], ], 'ModelErrorException' => [ 'base' => '<p>The request failed due to an error while processing the model.</p>', 'refs' => [], ], 'ModelNotReadyException' => [ 'base' => '<p>The model specified in the request is not ready to serve inference requests.</p>', 'refs' => [], ], 'ModelOutputs' => [ 'base' => NULL, 'refs' => [ 'GuardrailTraceAssessment$modelOutput' => '<p>The output from the model.</p>', ], ], 'ModelStreamErrorException' => [ 'base' => '<p>An error occurred while streaming the response. Retry your request.</p>', 'refs' => [ 'ConverseStreamOutput$modelStreamErrorException' => '<p>A streaming error occurred. Retry your request.</p>', 'ResponseStream$modelStreamErrorException' => '<p>An error occurred while streaming the response. Retry your request.</p>', ], ], 'ModelTimeoutException' => [ 'base' => '<p>The request took too long to process. Processing time exceeded the model timeout length.</p>', 'refs' => [ 'ResponseStream$modelTimeoutException' => '<p>The request took too long to process. Processing time exceeded the model timeout length.</p>', ], ], 'NonBlankString' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'InternalServerException$message' => NULL, 'ModelErrorException$message' => NULL, 'ModelErrorException$resourceName' => '<p>The resource name.</p>', 'ModelNotReadyException$message' => NULL, 'ModelStreamErrorException$message' => NULL, 'ModelStreamErrorException$originalMessage' => '<p>The original message.</p>', 'ModelTimeoutException$message' => NULL, 'ResourceNotFoundException$message' => NULL, 'ServiceQuotaExceededException$message' => NULL, 'ThrottlingException$message' => NULL, 'ValidationException$message' => NULL, ], ], 'NonEmptyString' => [ 'base' => NULL, 'refs' => [ 'InferenceConfigurationStopSequencesList$member' => NULL, 'SystemContentBlock$text' => '<p>A system prompt for the model. </p>', 'ToolSpecification$description' => '<p>The description for the tool.</p>', ], ], 'NonNegativeInteger' => [ 'base' => NULL, 'refs' => [ 'ContentBlockDeltaEvent$contentBlockIndex' => '<p>The block index for a content block delta event. </p>', 'ContentBlockStartEvent$contentBlockIndex' => '<p>The index for a content block start event.</p>', 'ContentBlockStopEvent$contentBlockIndex' => '<p>The index for a content block.</p>', ], ], 'PartBody' => [ 'base' => NULL, 'refs' => [ 'PayloadPart$bytes' => '<p>Base64-encoded bytes of payload data.</p>', ], ], 'PayloadPart' => [ 'base' => '<p>Payload content included in the response.</p>', 'refs' => [ 'ResponseStream$chunk' => '<p>Content included in the response.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The specified resource ARN was not found. Check the ARN and try your request again.</p>', 'refs' => [], ], 'ResponseStream' => [ 'base' => '<p>Definition of content in the response stream.</p>', 'refs' => [ 'InvokeModelWithResponseStreamResponse$body' => '<p>Inference response from the model in the format specified by the <code>contentType</code> header. To see the format and content of this field for different models, refer to <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters</a>.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>The number of requests exceeds the service quota. Resubmit your request later.</p>', 'refs' => [], ], 'SpecificToolChoice' => [ 'base' => '<p>The model must request a specific tool. For example, <code>{"tool" : {"name" : "Your tool name"}}</code>.</p> <note> <p>This field is only supported by Anthropic Claude 3 models.</p> </note>', 'refs' => [ 'ToolChoice$tool' => '<p>The Model must request the specified tool. Only supported by Anthropic Claude 3 models. </p>', ], ], 'StatusCode' => [ 'base' => NULL, 'refs' => [ 'ModelErrorException$originalStatusCode' => '<p>The original status code.</p>', 'ModelStreamErrorException$originalStatusCode' => '<p>The original status code.</p>', ], ], 'StopReason' => [ 'base' => NULL, 'refs' => [ 'ConverseResponse$stopReason' => '<p>The reason why the model stopped generating output.</p>', 'MessageStopEvent$stopReason' => '<p>The reason why the model stopped generating output.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'ContentBlock$text' => '<p>Text to include in the message.</p>', 'ContentBlockDelta$text' => '<p>The content text.</p>', 'GuardrailAssessmentListMap$key' => NULL, 'GuardrailAssessmentMap$key' => NULL, 'GuardrailConverseTextBlock$text' => '<p>The text that you want to guard.</p>', 'GuardrailCustomWord$match' => '<p>The match for the custom word.</p>', 'GuardrailManagedWord$match' => '<p>The match for the managed word.</p>', 'GuardrailPiiEntityFilter$match' => '<p>The PII entity filter match.</p>', 'GuardrailRegexFilter$name' => '<p>The regex filter name.</p>', 'GuardrailRegexFilter$match' => '<p>The regesx filter match.</p>', 'GuardrailRegexFilter$regex' => '<p>The regex query.</p>', 'GuardrailTextBlock$text' => '<p>The input text details to be evaluated by the guardrail.</p>', 'GuardrailTopic$name' => '<p>The name for the guardrail.</p>', 'ToolResultContentBlock$text' => '<p>A tool result that is text.</p>', 'ToolUseBlockDelta$input' => '<p>The input for a requested tool.</p>', ], ], 'SystemContentBlock' => [ 'base' => '<p>A system content block.</p>', 'refs' => [ 'SystemContentBlocks$member' => NULL, ], ], 'SystemContentBlocks' => [ 'base' => NULL, 'refs' => [ 'ConverseRequest$system' => '<p>A system prompt to pass to the model.</p>', 'ConverseStreamRequest$system' => '<p>A system prompt to send to the model.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The number of requests exceeds the limit. Resubmit your request later.</p>', 'refs' => [ 'ConverseStreamOutput$throttlingException' => '<p>The number of requests exceeds the limit. Resubmit your request later.</p>', 'ResponseStream$throttlingException' => '<p>The number or frequency of requests exceeds the limit. Resubmit your request later.</p>', ], ], 'TokenUsage' => [ 'base' => '<p>The tokens used in a message API inference call. </p>', 'refs' => [ 'ConverseResponse$usage' => '<p>The total number of tokens used in the call to <code>Converse</code>. The total includes the tokens input to the model and the tokens generated by the model.</p>', 'ConverseStreamMetadataEvent$usage' => '<p>Usage information for the conversation stream event.</p>', ], ], 'TokenUsageInputTokensInteger' => [ 'base' => NULL, 'refs' => [ 'TokenUsage$inputTokens' => '<p>The number of tokens sent in the request to the model.</p>', ], ], 'TokenUsageOutputTokensInteger' => [ 'base' => NULL, 'refs' => [ 'TokenUsage$outputTokens' => '<p>The number of tokens that the model generated for the request.</p>', ], ], 'TokenUsageTotalTokensInteger' => [ 'base' => NULL, 'refs' => [ 'TokenUsage$totalTokens' => '<p>The total of input tokens and tokens generated by the model.</p>', ], ], 'Tool' => [ 'base' => '<p>Information about a tool that you can use with the Converse API. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/tool-use.html">Tool use (function calling)</a> in the Amazon Bedrock User Guide.</p>', 'refs' => [ 'ToolConfigurationToolsList$member' => NULL, ], ], 'ToolChoice' => [ 'base' => '<p>Determines which tools the model should request in a call to <code>Converse</code> or <code>ConverseStream</code>. <code>ToolChoice</code> is only supported by Anthropic Claude 3 models and by Mistral AI Mistral Large.</p>', 'refs' => [ 'ToolConfiguration$toolChoice' => '<p>If supported by model, forces the model to request a tool.</p>', ], ], 'ToolConfiguration' => [ 'base' => '<p>Configuration information for the tools that you pass to a model. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/tool-use.html">Tool use (function calling)</a> in the Amazon Bedrock User Guide.</p> <note> <p>This field is only supported by Anthropic Claude 3, Cohere Command R, Cohere Command R+, and Mistral Large models.</p> </note>', 'refs' => [ 'ConverseRequest$toolConfig' => '<p>Configuration information for the tools that the model can use when generating a response. </p> <note> <p>This field is only supported by Anthropic Claude 3, Cohere Command R, Cohere Command R+, and Mistral Large models.</p> </note>', 'ConverseStreamRequest$toolConfig' => '<p>Configuration information for the tools that the model can use when generating a response.</p> <note> <p>This field is only supported by Anthropic Claude 3 models.</p> </note>', ], ], 'ToolConfigurationToolsList' => [ 'base' => NULL, 'refs' => [ 'ToolConfiguration$tools' => '<p>An array of tools that you want to pass to a model.</p>', ], ], 'ToolInputSchema' => [ 'base' => '<p>The schema for the tool. The top level schema type must be <code>object</code>. </p>', 'refs' => [ 'ToolSpecification$inputSchema' => '<p>The input schema for the tool in JSON format.</p>', ], ], 'ToolName' => [ 'base' => NULL, 'refs' => [ 'SpecificToolChoice$name' => '<p>The name of the tool that the model must request. </p>', 'ToolSpecification$name' => '<p>The name for the tool.</p>', 'ToolUseBlock$name' => '<p>The name of the tool that the model wants to use.</p>', 'ToolUseBlockStart$name' => '<p>The name of the tool that the model is requesting to use.</p>', ], ], 'ToolResultBlock' => [ 'base' => '<p>A tool result block that contains the results for a tool request that the model previously made.</p>', 'refs' => [ 'ContentBlock$toolResult' => '<p>The result for a tool request that a model makes.</p>', ], ], 'ToolResultContentBlock' => [ 'base' => '<p>The tool result content block.</p>', 'refs' => [ 'ToolResultContentBlocks$member' => NULL, ], ], 'ToolResultContentBlocks' => [ 'base' => NULL, 'refs' => [ 'ToolResultBlock$content' => '<p>The content for tool result content block.</p>', ], ], 'ToolResultStatus' => [ 'base' => NULL, 'refs' => [ 'ToolResultBlock$status' => '<p>The status for the tool result content block.</p> <note> <p>This field is only supported Anthropic Claude 3 models.</p> </note>', ], ], 'ToolSpecification' => [ 'base' => '<p>The specification for the tool.</p>', 'refs' => [ 'Tool$toolSpec' => '<p>The specfication for the tool.</p>', ], ], 'ToolUseBlock' => [ 'base' => '<p>A tool use content block. Contains information about a tool that the model is requesting be run., The model uses the result from the tool to generate a response. </p>', 'refs' => [ 'ContentBlock$toolUse' => '<p>Information about a tool use request from a model.</p>', ], ], 'ToolUseBlockDelta' => [ 'base' => '<p>The delta for a tool use block.</p>', 'refs' => [ 'ContentBlockDelta$toolUse' => '<p>Information about a tool that the model is requesting to use.</p>', ], ], 'ToolUseBlockStart' => [ 'base' => '<p>The start of a tool use block.</p>', 'refs' => [ 'ContentBlockStart$toolUse' => '<p>Information about a tool that the model is requesting to use.</p>', ], ], 'ToolUseId' => [ 'base' => NULL, 'refs' => [ 'ToolResultBlock$toolUseId' => '<p>The ID of the tool request that this is the result for.</p>', 'ToolUseBlock$toolUseId' => '<p>The ID for the tool request.</p>', 'ToolUseBlockStart$toolUseId' => '<p>The ID for the tool request.</p>', ], ], 'Trace' => [ 'base' => NULL, 'refs' => [ 'InvokeModelRequest$trace' => '<p>Specifies whether to enable or disable the Bedrock trace. If enabled, you can see the full Bedrock trace.</p>', 'InvokeModelWithResponseStreamRequest$trace' => '<p>Specifies whether to enable or disable the Bedrock trace. If enabled, you can see the full Bedrock trace.</p>', ], ], 'ValidationException' => [ 'base' => '<p>Input validation failed. Check your request parameters and retry the request.</p>', 'refs' => [ 'ConverseStreamOutput$validationException' => '<p>Input validation failed. Check your request parameters and retry the request.</p>', 'ResponseStream$validationException' => '<p>Input validation failed. Check your request parameters and retry the request.</p>', ], ], ],];
