<?php
// This file was auto-generated from sdk-root/src/data/codeartifact/2018-09-22/docs-2.json
return [ 'version' => '2.0', 'service' => '<p> CodeArtifact is a fully managed artifact repository compatible with language-native package managers and build tools such as npm, Apache Maven, pip, and dotnet. You can use CodeArtifact to share packages with development teams and pull packages. Packages can be pulled from both public and CodeArtifact repositories. You can also create an upstream relationship between a CodeArtifact repository and another repository, which effectively merges their contents from the point of view of a package manager client. </p> <p> <b>CodeArtifact concepts</b> </p> <ul> <li> <p> <b>Repository</b>: A CodeArtifact repository contains a set of <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/welcome.html#welcome-concepts-package-version">package versions</a>, each of which maps to a set of assets, or files. Repositories are polyglot, so a single repository can contain packages of any supported type. Each repository exposes endpoints for fetching and publishing packages using tools such as the <b> <code>npm</code> </b> CLI or the Maven CLI (<b> <code>mvn</code> </b>). For a list of supported package managers, see the <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/welcome.html">CodeArtifact User Guide</a>.</p> </li> <li> <p> <b>Domain</b>: Repositories are aggregated into a higher-level entity known as a <i>domain</i>. All package assets and metadata are stored in the domain, but are consumed through repositories. A given package asset, such as a Maven JAR file, is stored once per domain, no matter how many repositories it\'s present in. All of the assets and metadata in a domain are encrypted with the same customer master key (CMK) stored in Key Management Service (KMS).</p> <p>Each repository is a member of a single domain and can\'t be moved to a different domain.</p> <p>The domain allows organizational policy to be applied across multiple repositories, such as which accounts can access repositories in the domain, and which public repositories can be used as sources of packages.</p> <p>Although an organization can have multiple domains, we recommend a single production domain that contains all published artifacts so that teams can find and share packages across their organization.</p> </li> <li> <p> <b>Package</b>: A <i>package</i> is a bundle of software and the metadata required to resolve dependencies and install the software. CodeArtifact supports npm, PyPI, Maven, NuGet, Swift, Ruby, Cargo, and generic package formats. For more information about the supported package formats and how to use CodeArtifact with them, see the <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/welcome.html">CodeArtifact User Guide</a>.</p> <p>In CodeArtifact, a package consists of:</p> <ul> <li> <p>A <i>name</i> (for example, <code>webpack</code> is the name of a popular npm package)</p> </li> <li> <p>An optional namespace (for example, <code>@types</code> in <code>@types/node</code>)</p> </li> <li> <p>A set of versions (for example, <code>1.0.0</code>, <code>1.0.1</code>, <code>1.0.2</code>, etc.)</p> </li> <li> <p> Package-level metadata (for example, npm tags)</p> </li> </ul> </li> <li> <p> <b>Package group</b>: A group of packages that match a specified definition. Package groups can be used to apply configuration to multiple packages that match a defined pattern using package format, package namespace, and package name. You can use package groups to more conveniently configure package origin controls for multiple packages. Package origin controls are used to block or allow ingestion or publishing of new package versions, which protects users from malicious actions known as dependency substitution attacks.</p> </li> <li> <p> <b>Package version</b>: A version of a package, such as <code>@types/node 12.6.9</code>. The version number format and semantics vary for different package formats. For example, npm package versions must conform to the <a href="https://semver.org/">Semantic Versioning specification</a>. In CodeArtifact, a package version consists of the version identifier, metadata at the package version level, and a set of assets.</p> </li> <li> <p> <b>Upstream repository</b>: One repository is <i>upstream</i> of another when the package versions in it can be accessed from the repository endpoint of the downstream repository, effectively merging the contents of the two repositories from the point of view of a client. CodeArtifact allows creating an upstream relationship between two repositories.</p> </li> <li> <p> <b>Asset</b>: An individual file stored in CodeArtifact associated with a package version, such as an npm <code>.tgz</code> file or Maven POM and JAR files.</p> </li> </ul> <p> <b>CodeArtifact supported API operations</b> </p> <ul> <li> <p> <code>AssociateExternalConnection</code>: Adds an existing external connection to a repository. </p> </li> <li> <p> <code>CopyPackageVersions</code>: Copies package versions from one repository to another repository in the same domain.</p> </li> <li> <p> <code>CreateDomain</code>: Creates a domain.</p> </li> <li> <p> <code>CreatePackageGroup</code>: Creates a package group.</p> </li> <li> <p> <code>CreateRepository</code>: Creates a CodeArtifact repository in a domain. </p> </li> <li> <p> <code>DeleteDomain</code>: Deletes a domain. You cannot delete a domain that contains repositories. </p> </li> <li> <p> <code>DeleteDomainPermissionsPolicy</code>: Deletes the resource policy that is set on a domain.</p> </li> <li> <p> <code>DeletePackage</code>: Deletes a package and all associated package versions.</p> </li> <li> <p> <code>DeletePackageGroup</code>: Deletes a package group. Does not delete packages or package versions that are associated with a package group.</p> </li> <li> <p> <code>DeletePackageVersions</code>: Deletes versions of a package. After a package has been deleted, it can be republished, but its assets and metadata cannot be restored because they have been permanently removed from storage.</p> </li> <li> <p> <code>DeleteRepository</code>: Deletes a repository. </p> </li> <li> <p> <code>DeleteRepositoryPermissionsPolicy</code>: Deletes the resource policy that is set on a repository.</p> </li> <li> <p> <code>DescribeDomain</code>: Returns a <code>DomainDescription</code> object that contains information about the requested domain.</p> </li> <li> <p> <code>DescribePackage</code>: Returns a <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageDescription.html">PackageDescription</a> object that contains details about a package. </p> </li> <li> <p> <code>DescribePackageGroup</code>: Returns a <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageGroup.html">PackageGroup</a> object that contains details about a package group. </p> </li> <li> <p> <code>DescribePackageVersion</code>: Returns a <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionDescription.html">PackageVersionDescription</a> object that contains details about a package version. </p> </li> <li> <p> <code>DescribeRepository</code>: Returns a <code>RepositoryDescription</code> object that contains detailed information about the requested repository. </p> </li> <li> <p> <code>DisposePackageVersions</code>: Disposes versions of a package. A package version with the status <code>Disposed</code> cannot be restored because they have been permanently removed from storage.</p> </li> <li> <p> <code>DisassociateExternalConnection</code>: Removes an existing external connection from a repository. </p> </li> <li> <p> <code>GetAssociatedPackageGroup</code>: Returns the most closely associated package group to the specified package.</p> </li> <li> <p> <code>GetAuthorizationToken</code>: Generates a temporary authorization token for accessing repositories in the domain. The token expires the authorization period has passed. The default authorization period is 12 hours and can be customized to any length with a maximum of 12 hours.</p> </li> <li> <p> <code>GetDomainPermissionsPolicy</code>: Returns the policy of a resource that is attached to the specified domain. </p> </li> <li> <p> <code>GetPackageVersionAsset</code>: Returns the contents of an asset that is in a package version. </p> </li> <li> <p> <code>GetPackageVersionReadme</code>: Gets the readme file or descriptive text for a package version.</p> </li> <li> <p> <code>GetRepositoryEndpoint</code>: Returns the endpoint of a repository for a specific package format. A repository has one endpoint for each package format: </p> <ul> <li> <p> <code>cargo</code> </p> </li> <li> <p> <code>generic</code> </p> </li> <li> <p> <code>maven</code> </p> </li> <li> <p> <code>npm</code> </p> </li> <li> <p> <code>nuget</code> </p> </li> <li> <p> <code>pypi</code> </p> </li> <li> <p> <code>ruby</code> </p> </li> <li> <p> <code>swift</code> </p> </li> </ul> </li> <li> <p> <code>GetRepositoryPermissionsPolicy</code>: Returns the resource policy that is set on a repository. </p> </li> <li> <p> <code>ListAllowedRepositoriesForGroup</code>: Lists the allowed repositories for a package group that has origin configuration set to <code>ALLOW_SPECIFIC_REPOSITORIES</code>.</p> </li> <li> <p> <code>ListAssociatedPackages</code>: Returns a list of packages associated with the requested package group.</p> </li> <li> <p> <code>ListDomains</code>: Returns a list of <code>DomainSummary</code> objects. Each returned <code>DomainSummary</code> object contains information about a domain.</p> </li> <li> <p> <code>ListPackages</code>: Lists the packages in a repository.</p> </li> <li> <p> <code>ListPackageGroups</code>: Returns a list of package groups in the requested domain.</p> </li> <li> <p> <code>ListPackageVersionAssets</code>: Lists the assets for a given package version.</p> </li> <li> <p> <code>ListPackageVersionDependencies</code>: Returns a list of the direct dependencies for a package version. </p> </li> <li> <p> <code>ListPackageVersions</code>: Returns a list of package versions for a specified package in a repository.</p> </li> <li> <p> <code>ListRepositories</code>: Returns a list of repositories owned by the Amazon Web Services account that called this method.</p> </li> <li> <p> <code>ListRepositoriesInDomain</code>: Returns a list of the repositories in a domain.</p> </li> <li> <p> <code>ListSubPackageGroups</code>: Returns a list of direct children of the specified package group.</p> </li> <li> <p> <code>PublishPackageVersion</code>: Creates a new package version containing one or more assets.</p> </li> <li> <p> <code>PutDomainPermissionsPolicy</code>: Attaches a resource policy to a domain.</p> </li> <li> <p> <code>PutPackageOriginConfiguration</code>: Sets the package origin configuration for a package, which determine how new versions of the package can be added to a specific repository.</p> </li> <li> <p> <code>PutRepositoryPermissionsPolicy</code>: Sets the resource policy on a repository that specifies permissions to access it. </p> </li> <li> <p> <code>UpdatePackageGroup</code>: Updates a package group. This API cannot be used to update a package group\'s origin configuration or pattern.</p> </li> <li> <p> <code>UpdatePackageGroupOriginConfiguration</code>: Updates the package origin configuration for a package group.</p> </li> <li> <p> <code>UpdatePackageVersionsStatus</code>: Updates the status of one or more versions of a package.</p> </li> <li> <p> <code>UpdateRepository</code>: Updates the properties of a repository.</p> </li> </ul>', 'operations' => [ 'AssociateExternalConnection' => '<p>Adds an existing external connection to a repository. One external connection is allowed per repository.</p> <note> <p>A repository can have one or more upstream repositories, or an external connection.</p> </note>', 'CopyPackageVersions' => '<p> Copies package versions from one repository to another repository in the same domain. </p> <note> <p> You must specify <code>versions</code> or <code>versionRevisions</code>. You cannot specify both. </p> </note>', 'CreateDomain' => '<p> Creates a domain. CodeArtifact <i>domains</i> make it easier to manage multiple repositories across an organization. You can use a domain to apply permissions across many repositories owned by different Amazon Web Services accounts. An asset is stored only once in a domain, even if it\'s in multiple repositories. </p> <p>Although you can have multiple domains, we recommend a single production domain that contains all published artifacts so that your development teams can find and share packages. You can use a second pre-production domain to test changes to the production domain configuration. </p>', 'CreatePackageGroup' => '<p> Creates a package group. For more information about creating package groups, including example CLI commands, see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/create-package-group.html">Create a package group</a> in the <i>CodeArtifact User Guide</i>. </p>', 'CreateRepository' => '<p> Creates a repository. </p>', 'DeleteDomain' => '<p> Deletes a domain. You cannot delete a domain that contains repositories. If you want to delete a domain with repositories, first delete its repositories. </p>', 'DeleteDomainPermissionsPolicy' => '<p> Deletes the resource policy set on a domain. </p>', 'DeletePackage' => '<p>Deletes a package and all associated package versions. A deleted package cannot be restored. To delete one or more package versions, use the <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DeletePackageVersions.html">DeletePackageVersions</a> API.</p>', 'DeletePackageGroup' => '<p>Deletes a package group. Deleting a package group does not delete packages or package versions associated with the package group. When a package group is deleted, the direct child package groups will become children of the package group\'s direct parent package group. Therefore, if any of the child groups are inheriting any settings from the parent, those settings could change.</p>', 'DeletePackageVersions' => '<p> Deletes one or more versions of a package. A deleted package version cannot be restored in your repository. If you want to remove a package version from your repository and be able to restore it later, set its status to <code>Archived</code>. Archived packages cannot be downloaded from a repository and don\'t show up with list package APIs (for example, <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListPackageVersions.html">ListPackageVersions</a>), but you can restore them using <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_UpdatePackageVersionsStatus.html">UpdatePackageVersionsStatus</a>. </p>', 'DeleteRepository' => '<p> Deletes a repository. </p>', 'DeleteRepositoryPermissionsPolicy' => '<p> Deletes the resource policy that is set on a repository. After a resource policy is deleted, the permissions allowed and denied by the deleted policy are removed. The effect of deleting a resource policy might not be immediate. </p> <important> <p> Use <code>DeleteRepositoryPermissionsPolicy</code> with caution. After a policy is deleted, Amazon Web Services users, roles, and accounts lose permissions to perform the repository actions granted by the deleted policy. </p> </important>', 'DescribeDomain' => '<p> Returns a <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DomainDescription.html">DomainDescription</a> object that contains information about the requested domain. </p>', 'DescribePackage' => '<p> Returns a <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageDescription.html">PackageDescription</a> object that contains information about the requested package.</p>', 'DescribePackageGroup' => '<p>Returns a <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageGroupDescription.html">PackageGroupDescription</a> object that contains information about the requested package group.</p>', 'DescribePackageVersion' => '<p> Returns a <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionDescription.html">PackageVersionDescription</a> object that contains information about the requested package version. </p>', 'DescribeRepository' => '<p> Returns a <code>RepositoryDescription</code> object that contains detailed information about the requested repository. </p>', 'DisassociateExternalConnection' => '<p> Removes an existing external connection from a repository. </p>', 'DisposePackageVersions' => '<p> Deletes the assets in package versions and sets the package versions\' status to <code>Disposed</code>. A disposed package version cannot be restored in your repository because its assets are deleted. </p> <p> To view all disposed package versions in a repository, use <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListPackageVersions.html">ListPackageVersions</a> and set the <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListPackageVersions.html#API_ListPackageVersions_RequestSyntax">status</a> parameter to <code>Disposed</code>. </p> <p> To view information about a disposed package version, use <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DescribePackageVersion.html">DescribePackageVersion</a>. </p>', 'GetAssociatedPackageGroup' => '<p>Returns the most closely associated package group to the specified package. This API does not require that the package exist in any repository in the domain. As such, <code>GetAssociatedPackageGroup</code> can be used to see which package group\'s origin configuration applies to a package before that package is in a repository. This can be helpful to check if public packages are blocked without ingesting them.</p> <p>For information package group association and matching, see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/package-group-definition-syntax-matching-behavior.html">Package group definition syntax and matching behavior</a> in the <i>CodeArtifact User Guide</i>.</p>', 'GetAuthorizationToken' => '<p> Generates a temporary authorization token for accessing repositories in the domain. This API requires the <code>codeartifact:GetAuthorizationToken</code> and <code>sts:GetServiceBearerToken</code> permissions. For more information about authorization tokens, see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/tokens-authentication.html">CodeArtifact authentication and tokens</a>. </p> <note> <p>CodeArtifact authorization tokens are valid for a period of 12 hours when created with the <code>login</code> command. You can call <code>login</code> periodically to refresh the token. When you create an authorization token with the <code>GetAuthorizationToken</code> API, you can set a custom authorization period, up to a maximum of 12 hours, with the <code>durationSeconds</code> parameter.</p> <p>The authorization period begins after <code>login</code> or <code>GetAuthorizationToken</code> is called. If <code>login</code> or <code>GetAuthorizationToken</code> is called while assuming a role, the token lifetime is independent of the maximum session duration of the role. For example, if you call <code>sts assume-role</code> and specify a session duration of 15 minutes, then generate a CodeArtifact authorization token, the token will be valid for the full authorization period even though this is longer than the 15-minute session duration.</p> <p>See <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html">Using IAM Roles</a> for more information on controlling session duration. </p> </note>', 'GetDomainPermissionsPolicy' => '<p> Returns the resource policy attached to the specified domain. </p> <note> <p> The policy is a resource-based policy, not an identity-based policy. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_identity-vs-resource.html">Identity-based policies and resource-based policies </a> in the <i>IAM User Guide</i>. </p> </note>', 'GetPackageVersionAsset' => '<p> Returns an asset (or file) that is in a package. For example, for a Maven package version, use <code>GetPackageVersionAsset</code> to download a <code>JAR</code> file, a <code>POM</code> file, or any other assets in the package version. </p>', 'GetPackageVersionReadme' => '<p> Gets the readme file or descriptive text for a package version. </p> <p> The returned text might contain formatting. For example, it might contain formatting for Markdown or reStructuredText. </p>', 'GetRepositoryEndpoint' => '<p> Returns the endpoint of a repository for a specific package format. A repository has one endpoint for each package format: </p> <ul> <li> <p> <code>cargo</code> </p> </li> <li> <p> <code>generic</code> </p> </li> <li> <p> <code>maven</code> </p> </li> <li> <p> <code>npm</code> </p> </li> <li> <p> <code>nuget</code> </p> </li> <li> <p> <code>pypi</code> </p> </li> <li> <p> <code>ruby</code> </p> </li> <li> <p> <code>swift</code> </p> </li> </ul>', 'GetRepositoryPermissionsPolicy' => '<p> Returns the resource policy that is set on a repository. </p>', 'ListAllowedRepositoriesForGroup' => '<p>Lists the repositories in the added repositories list of the specified restriction type for a package group. For more information about restriction types and added repository lists, see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/package-group-origin-controls.html">Package group origin controls</a> in the <i>CodeArtifact User Guide</i>. </p>', 'ListAssociatedPackages' => '<p>Returns a list of packages associated with the requested package group. For information package group association and matching, see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/package-group-definition-syntax-matching-behavior.html">Package group definition syntax and matching behavior</a> in the <i>CodeArtifact User Guide</i>.</p>', 'ListDomains' => '<p> Returns a list of <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionDescription.html">DomainSummary</a> objects for all domains owned by the Amazon Web Services account that makes this call. Each returned <code>DomainSummary</code> object contains information about a domain. </p>', 'ListPackageGroups' => '<p>Returns a list of package groups in the requested domain.</p>', 'ListPackageVersionAssets' => '<p> Returns a list of <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_AssetSummary.html">AssetSummary</a> objects for assets in a package version. </p>', 'ListPackageVersionDependencies' => '<p> Returns the direct dependencies for a package version. The dependencies are returned as <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageDependency.html">PackageDependency</a> objects. CodeArtifact extracts the dependencies for a package version from the metadata file for the package format (for example, the <code>package.json</code> file for npm packages and the <code>pom.xml</code> file for Maven). Any package version dependencies that are not listed in the configuration file are not returned. </p>', 'ListPackageVersions' => '<p> Returns a list of <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionSummary.html">PackageVersionSummary</a> objects for package versions in a repository that match the request parameters. Package versions of all statuses will be returned by default when calling <code>list-package-versions</code> with no <code>--status</code> parameter. </p>', 'ListPackages' => '<p> Returns a list of <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageSummary.html">PackageSummary</a> objects for packages in a repository that match the request parameters. </p>', 'ListRepositories' => '<p> Returns a list of <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_RepositorySummary.html">RepositorySummary</a> objects. Each <code>RepositorySummary</code> contains information about a repository in the specified Amazon Web Services account and that matches the input parameters. </p>', 'ListRepositoriesInDomain' => '<p> Returns a list of <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_RepositorySummary.html">RepositorySummary</a> objects. Each <code>RepositorySummary</code> contains information about a repository in the specified domain and that matches the input parameters. </p>', 'ListSubPackageGroups' => '<p>Returns a list of direct children of the specified package group.</p> <p>For information package group hierarchy, see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/package-group-definition-syntax-matching-behavior.html">Package group definition syntax and matching behavior</a> in the <i>CodeArtifact User Guide</i>.</p>', 'ListTagsForResource' => '<p>Gets information about Amazon Web Services tags for a specified Amazon Resource Name (ARN) in CodeArtifact.</p>', 'PublishPackageVersion' => '<p>Creates a new package version containing one or more assets (or files).</p> <p>The <code>unfinished</code> flag can be used to keep the package version in the <code>Unfinished</code> state until all of its assets have been uploaded (see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/packages-overview.html#package-version-status.html#package-version-status">Package version status</a> in the <i>CodeArtifact user guide</i>). To set the package version’s status to <code>Published</code>, omit the <code>unfinished</code> flag when uploading the final asset, or set the status using <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_UpdatePackageVersionsStatus.html">UpdatePackageVersionStatus</a>. Once a package version’s status is set to <code>Published</code>, it cannot change back to <code>Unfinished</code>.</p> <note> <p>Only generic packages can be published using this API. For more information, see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/using-generic.html">Using generic packages</a> in the <i>CodeArtifact User Guide</i>.</p> </note>', 'PutDomainPermissionsPolicy' => '<p> Sets a resource policy on a domain that specifies permissions to access it. </p> <p> When you call <code>PutDomainPermissionsPolicy</code>, the resource policy on the domain is ignored when evaluting permissions. This ensures that the owner of a domain cannot lock themselves out of the domain, which would prevent them from being able to update the resource policy. </p>', 'PutPackageOriginConfiguration' => '<p>Sets the package origin configuration for a package.</p> <p>The package origin configuration determines how new versions of a package can be added to a repository. You can allow or block direct publishing of new package versions, or ingestion and retaining of new package versions from an external connection or upstream source. For more information about package origin controls and configuration, see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/package-origin-controls.html">Editing package origin controls</a> in the <i>CodeArtifact User Guide</i>.</p> <p> <code>PutPackageOriginConfiguration</code> can be called on a package that doesn\'t yet exist in the repository. When called on a package that does not exist, a package is created in the repository with no versions and the requested restrictions are set on the package. This can be used to preemptively block ingesting or retaining any versions from external connections or upstream repositories, or to block publishing any versions of the package into the repository before connecting any package managers or publishers to the repository.</p>', 'PutRepositoryPermissionsPolicy' => '<p> Sets the resource policy on a repository that specifies permissions to access it. </p> <p> When you call <code>PutRepositoryPermissionsPolicy</code>, the resource policy on the repository is ignored when evaluting permissions. This ensures that the owner of a repository cannot lock themselves out of the repository, which would prevent them from being able to update the resource policy. </p>', 'TagResource' => '<p>Adds or updates tags for a resource in CodeArtifact.</p>', 'UntagResource' => '<p>Removes tags from a resource in CodeArtifact.</p>', 'UpdatePackageGroup' => '<p>Updates a package group. This API cannot be used to update a package group\'s origin configuration or pattern. To update a package group\'s origin configuration, use <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_UpdatePackageGroupOriginConfiguration.html">UpdatePackageGroupOriginConfiguration</a>.</p>', 'UpdatePackageGroupOriginConfiguration' => '<p>Updates the package origin configuration for a package group.</p> <p>The package origin configuration determines how new versions of a package can be added to a repository. You can allow or block direct publishing of new package versions, or ingestion and retaining of new package versions from an external connection or upstream source. For more information about package group origin controls and configuration, see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/package-group-origin-controls.html">Package group origin controls</a> in the <i>CodeArtifact User Guide</i>.</p>', 'UpdatePackageVersionsStatus' => '<p> Updates the status of one or more versions of a package. Using <code>UpdatePackageVersionsStatus</code>, you can update the status of package versions to <code>Archived</code>, <code>Published</code>, or <code>Unlisted</code>. To set the status of a package version to <code>Disposed</code>, use <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DisposePackageVersions.html">DisposePackageVersions</a>. </p>', 'UpdateRepository' => '<p> Update the properties of a repository. </p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p> The operation did not succeed because of an unauthorized access attempt. </p>', 'refs' => [], ], 'AccountId' => [ 'base' => NULL, 'refs' => [ 'AssociateExternalConnectionRequest$domainOwner' => '<p> The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces. </p>', 'CopyPackageVersionsRequest$domainOwner' => '<p> The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces. </p>', 'CreatePackageGroupRequest$domainOwner' => '<p> The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces. </p>', 'CreateRepositoryRequest$domainOwner' => '<p> The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces. </p>', 'DeleteDomainPermissionsPolicyRequest$domainOwner' => '<p> The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces. </p>', 'DeleteDomainRequest$domainOwner' => '<p> The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces. </p>', 'DeletePackageGroupRequest$domainOwner' => '<p> The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces. </p>', 'DeletePackageRequest$domainOwner' => '<p> The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces. </p>', 'DeletePackageVersionsRequest$domainOwner' => '<p> The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces. </p>', 'DeleteRepositoryPermissionsPolicyRequest$domainOwner' => '<p> The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces. </p>', 'DeleteRepositoryRequest$domainOwner' => '<p> The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces. </p>', 'DescribeDomainRequest$domainOwner' => '<p> The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces. </p>', 'DescribePackageGroupRequest$domainOwner' => '<p> The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces. </p>', 'DescribePackageRequest$domainOwner' => '<p> The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces. </p>', 'DescribePackageVersionRequest$domainOwner' => '<p> The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces. </p>', 'DescribeRepositoryRequest$domainOwner' => '<p> The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces. </p>', 'DisassociateExternalConnectionRequest$domainOwner' => '<p> The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces. </p>', 'DisposePackageVersionsRequest$domainOwner' => '<p> The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces. </p>', 'DomainDescription$owner' => '<p> The Amazon Web Services account ID that owns the domain. </p>', 'DomainSummary$owner' => '<p> The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces. </p>', 'GetAssociatedPackageGroupRequest$domainOwner' => '<p> The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces. </p>', 'GetAuthorizationTokenRequest$domainOwner' => '<p> The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces. </p>', 'GetDomainPermissionsPolicyRequest$domainOwner' => '<p> The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces. </p>', 'GetPackageVersionAssetRequest$domainOwner' => '<p> The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces. </p>', 'GetPackageVersionReadmeRequest$domainOwner' => '<p> The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces. </p>', 'GetRepositoryEndpointRequest$domainOwner' => '<p> The 12-digit account number of the Amazon Web Services account that owns the domain that contains the repository. It does not include dashes or spaces. </p>', 'GetRepositoryPermissionsPolicyRequest$domainOwner' => '<p> The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces. </p>', 'ListAllowedRepositoriesForGroupRequest$domainOwner' => '<p> The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces. </p>', 'ListAssociatedPackagesRequest$domainOwner' => '<p> The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces. </p>', 'ListPackageGroupsRequest$domainOwner' => '<p> The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces. </p>', 'ListPackageVersionAssetsRequest$domainOwner' => '<p> The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces. </p>', 'ListPackageVersionDependenciesRequest$domainOwner' => '<p> The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces. </p>', 'ListPackageVersionsRequest$domainOwner' => '<p> The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces. </p>', 'ListPackagesRequest$domainOwner' => '<p> The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces. </p>', 'ListRepositoriesInDomainRequest$domainOwner' => '<p> The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces. </p>', 'ListRepositoriesInDomainRequest$administratorAccount' => '<p> Filter the list of repositories to only include those that are managed by the Amazon Web Services account ID. </p>', 'ListSubPackageGroupsRequest$domainOwner' => '<p> The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces. </p>', 'PackageGroupDescription$domainOwner' => '<p> The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces. </p>', 'PackageGroupSummary$domainOwner' => '<p> The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces. </p>', 'PublishPackageVersionRequest$domainOwner' => '<p>The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces.</p>', 'PutDomainPermissionsPolicyRequest$domainOwner' => '<p> The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces. </p>', 'PutPackageOriginConfigurationRequest$domainOwner' => '<p> The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces. </p>', 'PutRepositoryPermissionsPolicyRequest$domainOwner' => '<p> The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces. </p>', 'RepositoryDescription$administratorAccount' => '<p> The 12-digit account number of the Amazon Web Services account that manages the repository. </p>', 'RepositoryDescription$domainOwner' => '<p> The 12-digit account number of the Amazon Web Services account that owns the domain that contains the repository. It does not include dashes or spaces. </p>', 'RepositorySummary$administratorAccount' => '<p> The Amazon Web Services account ID that manages the repository. </p>', 'RepositorySummary$domainOwner' => '<p> The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces. </p>', 'UpdatePackageGroupOriginConfigurationRequest$domainOwner' => '<p> The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces. </p>', 'UpdatePackageGroupRequest$domainOwner' => '<p> The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces. </p>', 'UpdatePackageVersionsStatusRequest$domainOwner' => '<p> The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces. </p>', 'UpdateRepositoryRequest$domainOwner' => '<p> The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces. </p>', ], ], 'AllowPublish' => [ 'base' => NULL, 'refs' => [ 'ListPackagesRequest$publish' => '<p>The value of the <code>Publish</code> package origin control restriction used to filter requested packages. Only packages with the provided restriction are returned. For more information, see <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageOriginRestrictions.html">PackageOriginRestrictions</a>.</p>', 'PackageOriginRestrictions$publish' => '<p>The package origin configuration that determines if new versions of the package can be published directly to the repository.</p>', ], ], 'AllowUpstream' => [ 'base' => NULL, 'refs' => [ 'ListPackagesRequest$upstream' => '<p>The value of the <code>Upstream</code> package origin control restriction used to filter requested packages. Only packages with the provided restriction are returned. For more information, see <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageOriginRestrictions.html">PackageOriginRestrictions</a>.</p>', 'PackageOriginRestrictions$upstream' => '<p>The package origin configuration that determines if new versions of the package can be added to the repository from an external connection or upstream source.</p>', ], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'CreateDomainRequest$encryptionKey' => '<p> The encryption key for the domain. This is used to encrypt content stored in a domain. An encryption key can be a key ID, a key Amazon Resource Name (ARN), a key alias, or a key alias ARN. To specify an <code>encryptionKey</code>, your IAM role must have <code>kms:DescribeKey</code> and <code>kms:CreateGrant</code> permissions on the encryption key that is used. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestSyntax">DescribeKey</a> in the <i>Key Management Service API Reference</i> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">Key Management Service API Permissions Reference</a> in the <i>Key Management Service Developer Guide</i>. </p> <important> <p> CodeArtifact supports only symmetric CMKs. Do not associate an asymmetric CMK with your domain. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric and asymmetric keys</a> in the <i>Key Management Service Developer Guide</i>. </p> </important>', 'DomainDescription$arn' => '<p> The Amazon Resource Name (ARN) of the domain. </p>', 'DomainDescription$encryptionKey' => '<p> The ARN of an Key Management Service (KMS) key associated with a domain. </p>', 'DomainDescription$s3BucketArn' => '<p>The Amazon Resource Name (ARN) of the Amazon S3 bucket that is used to store package assets in the domain.</p>', 'DomainSummary$arn' => '<p> The ARN of the domain. </p>', 'DomainSummary$encryptionKey' => '<p> The key used to encrypt the domain. </p>', 'ListTagsForResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource to get tags for.</p>', 'PackageGroupDescription$arn' => '<p> The ARN of the package group. </p>', 'PackageGroupReference$arn' => '<p> The ARN of the package group. </p>', 'PackageGroupSummary$arn' => '<p> The ARN of the package group. </p>', 'RepositoryDescription$arn' => '<p> The Amazon Resource Name (ARN) of the repository. </p>', 'RepositorySummary$arn' => '<p> The ARN of the repository. </p>', 'ResourcePolicy$resourceArn' => '<p> The ARN of the resource associated with the resource policy </p>', 'TagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource that you want to add or update tags for.</p>', 'UntagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource that you want to remove tags from.</p>', ], ], 'Asset' => [ 'base' => NULL, 'refs' => [ 'GetPackageVersionAssetResult$asset' => '<p> The binary file, or asset, that is downloaded.</p>', 'PublishPackageVersionRequest$assetContent' => '<p>The content of the asset to publish.</p>', ], ], 'AssetHashes' => [ 'base' => NULL, 'refs' => [ 'AssetSummary$hashes' => '<p> The hashes of the asset. </p>', ], ], 'AssetName' => [ 'base' => NULL, 'refs' => [ 'AssetSummary$name' => '<p> The name of the asset. </p>', 'GetPackageVersionAssetRequest$asset' => '<p> The name of the requested asset. </p>', 'GetPackageVersionAssetResult$assetName' => '<p> The name of the asset that is downloaded. </p>', 'PublishPackageVersionRequest$assetName' => '<p>The name of the asset to publish. Asset names can include Unicode letters and numbers, and the following special characters: <code>~ ! @ ^ &amp; ( ) - ` _ + [ ] { } ; , . `</code> </p>', ], ], 'AssetSummary' => [ 'base' => '<p> Contains details about a package version asset. </p>', 'refs' => [ 'AssetSummaryList$member' => NULL, 'PublishPackageVersionResult$asset' => '<p>An <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_AssetSummary.html">AssetSummary</a> for the published asset.</p>', ], ], 'AssetSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListPackageVersionAssetsResult$assets' => '<p> The returned list of <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_AssetSummary.html">AssetSummary</a> objects. </p>', ], ], 'AssociateExternalConnectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateExternalConnectionResult' => [ 'base' => NULL, 'refs' => [], ], 'AssociatedPackage' => [ 'base' => '<p> A package associated with a package group. </p>', 'refs' => [ 'AssociatedPackageList$member' => NULL, ], ], 'AssociatedPackageList' => [ 'base' => NULL, 'refs' => [ 'ListAssociatedPackagesResult$packages' => '<p> The list of packages associated with the requested package group. </p>', ], ], 'AuthorizationTokenDurationSeconds' => [ 'base' => NULL, 'refs' => [ 'GetAuthorizationTokenRequest$durationSeconds' => '<p>The time, in seconds, that the generated authorization token is valid. Valid values are <code>0</code> and any number between <code>900</code> (15 minutes) and <code>43200</code> (12 hours). A value of <code>0</code> will set the expiration of the authorization token to the same expiration of the user\'s role\'s temporary credentials.</p>', ], ], 'BooleanOptional' => [ 'base' => NULL, 'refs' => [ 'CopyPackageVersionsRequest$allowOverwrite' => '<p> Set to true to overwrite a package version that already exists in the destination repository. If set to false and the package version already exists in the destination repository, the package version is returned in the <code>failedVersions</code> field of the response with an <code>ALREADY_EXISTS</code> error code. </p>', 'CopyPackageVersionsRequest$includeFromUpstream' => '<p> Set to true to copy packages from repositories that are upstream from the source repository to the destination repository. The default setting is false. For more information, see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working with upstream repositories</a>. </p>', 'ListAssociatedPackagesRequest$preview' => '<p> When this flag is included, <code>ListAssociatedPackages</code> will return a list of packages that would be associated with a package group, even if it does not exist. </p>', 'PublishPackageVersionRequest$unfinished' => '<p>Specifies whether the package version should remain in the <code>unfinished</code> state. If omitted, the package version status will be set to <code>Published</code> (see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/packages-overview.html#package-version-status">Package version status</a> in the <i>CodeArtifact User Guide</i>).</p> <p>Valid values: <code>unfinished</code> </p>', ], ], 'ConflictException' => [ 'base' => '<p> The operation did not succeed because prerequisites are not met. </p>', 'refs' => [], ], 'CopyPackageVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'CopyPackageVersionsResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateDomainRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDomainResult' => [ 'base' => NULL, 'refs' => [], ], 'CreatePackageGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreatePackageGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateRepositoryRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateRepositoryResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDomainPermissionsPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDomainPermissionsPolicyResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDomainRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDomainResult' => [ 'base' => NULL, 'refs' => [], ], 'DeletePackageGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePackageGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'DeletePackageRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePackageResult' => [ 'base' => NULL, 'refs' => [], ], 'DeletePackageVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePackageVersionsResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRepositoryPermissionsPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRepositoryPermissionsPolicyResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRepositoryRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRepositoryResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDomainRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDomainResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribePackageGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePackageGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribePackageRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePackageResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribePackageVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePackageVersionResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRepositoryRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRepositoryResult' => [ 'base' => NULL, 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'CreatePackageGroupRequest$description' => '<p> A description of the package group. </p>', 'CreateRepositoryRequest$description' => '<p> A description of the created repository. </p>', 'PackageGroupDescription$description' => '<p> The description of the package group. </p>', 'PackageGroupSummary$description' => '<p> The description of the package group. </p>', 'RepositoryDescription$description' => '<p> A text description of the repository. </p>', 'RepositorySummary$description' => '<p> The description of the repository. </p>', 'UpdatePackageGroupRequest$description' => '<p> The description you want to update the requested package group with. </p>', 'UpdateRepositoryRequest$description' => '<p> An updated repository description. </p>', ], ], 'DisassociateExternalConnectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateExternalConnectionResult' => [ 'base' => NULL, 'refs' => [], ], 'DisposePackageVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisposePackageVersionsResult' => [ 'base' => NULL, 'refs' => [], ], 'DomainDescription' => [ 'base' => '<p> Information about a domain. A domain is a container for repositories. When you create a domain, it is empty until you add one or more repositories. </p>', 'refs' => [ 'CreateDomainResult$domain' => '<p> Contains information about the created domain after processing the request. </p>', 'DeleteDomainResult$domain' => '<p> Contains information about the deleted domain after processing the request. </p>', 'DescribeDomainResult$domain' => NULL, ], ], 'DomainEntryPoint' => [ 'base' => '<p>Information about how a package originally entered the CodeArtifact domain. For packages published directly to CodeArtifact, the entry point is the repository it was published to. For packages ingested from an external repository, the entry point is the external connection that it was ingested from. An external connection is a CodeArtifact repository that is connected to an external repository such as the npm registry or NuGet gallery.</p> <note> <p>If a package version exists in a repository and is updated, for example if a package of the same version is added with additional assets, the package version\'s <code>DomainEntryPoint</code> will not change from the original package version\'s value.</p> </note>', 'refs' => [ 'PackageVersionOrigin$domainEntryPoint' => '<p>A <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DomainEntryPoint.html">DomainEntryPoint</a> object that contains information about from which repository or external connection the package version was added to the domain.</p>', ], ], 'DomainName' => [ 'base' => NULL, 'refs' => [ 'AssociateExternalConnectionRequest$domain' => '<p>The name of the domain that contains the repository.</p>', 'CopyPackageVersionsRequest$domain' => '<p> The name of the domain that contains the source and destination repositories. </p>', 'CreateDomainRequest$domain' => '<p> The name of the domain to create. All domain names in an Amazon Web Services Region that are in the same Amazon Web Services account must be unique. The domain name is used as the prefix in DNS hostnames. Do not use sensitive information in a domain name because it is publicly discoverable. </p>', 'CreatePackageGroupRequest$domain' => '<p> The name of the domain in which you want to create a package group. </p>', 'CreateRepositoryRequest$domain' => '<p> The name of the domain that contains the created repository. </p>', 'DeleteDomainPermissionsPolicyRequest$domain' => '<p> The name of the domain associated with the resource policy to be deleted. </p>', 'DeleteDomainRequest$domain' => '<p> The name of the domain to delete. </p>', 'DeletePackageGroupRequest$domain' => '<p> The domain that contains the package group to be deleted. </p>', 'DeletePackageRequest$domain' => '<p>The name of the domain that contains the package to delete.</p>', 'DeletePackageVersionsRequest$domain' => '<p> The name of the domain that contains the package to delete. </p>', 'DeleteRepositoryPermissionsPolicyRequest$domain' => '<p> The name of the domain that contains the repository associated with the resource policy to be deleted. </p>', 'DeleteRepositoryRequest$domain' => '<p> The name of the domain that contains the repository to delete. </p>', 'DescribeDomainRequest$domain' => '<p> A string that specifies the name of the requested domain. </p>', 'DescribePackageGroupRequest$domain' => '<p> The name of the domain that contains the package group. </p>', 'DescribePackageRequest$domain' => '<p>The name of the domain that contains the repository that contains the package.</p>', 'DescribePackageVersionRequest$domain' => '<p> The name of the domain that contains the repository that contains the package version. </p>', 'DescribeRepositoryRequest$domain' => '<p> The name of the domain that contains the repository to describe. </p>', 'DisassociateExternalConnectionRequest$domain' => '<p>The name of the domain that contains the repository from which to remove the external repository. </p>', 'DisposePackageVersionsRequest$domain' => '<p> The name of the domain that contains the repository you want to dispose. </p>', 'DomainDescription$name' => '<p> The name of the domain. </p>', 'DomainSummary$name' => '<p> The name of the domain. </p>', 'GetAssociatedPackageGroupRequest$domain' => '<p> The name of the domain that contains the package from which to get the associated package group. </p>', 'GetAuthorizationTokenRequest$domain' => '<p> The name of the domain that is in scope for the generated authorization token. </p>', 'GetDomainPermissionsPolicyRequest$domain' => '<p> The name of the domain to which the resource policy is attached. </p>', 'GetPackageVersionAssetRequest$domain' => '<p> The name of the domain that contains the repository that contains the package version with the requested asset. </p>', 'GetPackageVersionReadmeRequest$domain' => '<p> The name of the domain that contains the repository that contains the package version with the requested readme file. </p>', 'GetRepositoryEndpointRequest$domain' => '<p> The name of the domain that contains the repository. </p>', 'GetRepositoryPermissionsPolicyRequest$domain' => '<p> The name of the domain containing the repository whose associated resource policy is to be retrieved. </p>', 'ListAllowedRepositoriesForGroupRequest$domain' => '<p> The name of the domain that contains the package group from which to list allowed repositories. </p>', 'ListAssociatedPackagesRequest$domain' => '<p> The name of the domain that contains the package group from which to list associated packages. </p>', 'ListPackageGroupsRequest$domain' => '<p> The domain for which you want to list package groups. </p>', 'ListPackageVersionAssetsRequest$domain' => '<p> The name of the domain that contains the repository associated with the package version assets. </p>', 'ListPackageVersionDependenciesRequest$domain' => '<p> The name of the domain that contains the repository that contains the requested package version dependencies. </p>', 'ListPackageVersionsRequest$domain' => '<p> The name of the domain that contains the repository that contains the requested package versions. </p>', 'ListPackagesRequest$domain' => '<p> The name of the domain that contains the repository that contains the requested packages. </p>', 'ListRepositoriesInDomainRequest$domain' => '<p> The name of the domain that contains the returned list of repositories. </p>', 'ListSubPackageGroupsRequest$domain' => '<p> The name of the domain which contains the package group from which to list sub package groups. </p>', 'PackageGroupDescription$domainName' => '<p> The name of the domain that contains the package group. </p>', 'PackageGroupSummary$domainName' => '<p> The domain that contains the package group. </p>', 'PublishPackageVersionRequest$domain' => '<p>The name of the domain that contains the repository that contains the package version to publish.</p>', 'PutDomainPermissionsPolicyRequest$domain' => '<p> The name of the domain on which to set the resource policy. </p>', 'PutPackageOriginConfigurationRequest$domain' => '<p>The name of the domain that contains the repository that contains the package.</p>', 'PutRepositoryPermissionsPolicyRequest$domain' => '<p> The name of the domain containing the repository to set the resource policy on. </p>', 'RepositoryDescription$domainName' => '<p> The name of the domain that contains the repository. </p>', 'RepositorySummary$domainName' => '<p> The name of the domain that contains the repository. </p>', 'UpdatePackageGroupOriginConfigurationRequest$domain' => '<p> The name of the domain which contains the package group for which to update the origin configuration. </p>', 'UpdatePackageGroupRequest$domain' => '<p> The name of the domain which contains the package group to be updated. </p>', 'UpdatePackageVersionsStatusRequest$domain' => '<p> The name of the domain that contains the repository that contains the package versions with a status to be updated. </p>', 'UpdateRepositoryRequest$domain' => '<p> The name of the domain associated with the repository to update. </p>', ], ], 'DomainStatus' => [ 'base' => NULL, 'refs' => [ 'DomainDescription$status' => '<p> The current status of a domain. </p>', 'DomainSummary$status' => '<p> A string that contains the status of the domain. </p>', ], ], 'DomainSummary' => [ 'base' => '<p> Information about a domain, including its name, Amazon Resource Name (ARN), and status. The <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListDomains.html">ListDomains</a> operation returns a list of <code>DomainSummary</code> objects. </p>', 'refs' => [ 'DomainSummaryList$member' => NULL, ], ], 'DomainSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListDomainsResult$domains' => '<p> The returned list of <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DomainSummary.html">DomainSummary</a> objects. </p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'PackageVersionError$errorMessage' => '<p> The error message associated with the error. </p>', ], ], 'ExternalConnectionName' => [ 'base' => NULL, 'refs' => [ 'AssociateExternalConnectionRequest$externalConnection' => '<p> The name of the external connection to add to the repository. The following values are supported: </p> <ul> <li> <p> <code>public:npmjs</code> - for the npm public repository. </p> </li> <li> <p> <code>public:nuget-org</code> - for the NuGet Gallery. </p> </li> <li> <p> <code>public:pypi</code> - for the Python Package Index. </p> </li> <li> <p> <code>public:maven-central</code> - for Maven Central. </p> </li> <li> <p> <code>public:maven-googleandroid</code> - for the Google Android repository. </p> </li> <li> <p> <code>public:maven-gradleplugins</code> - for the Gradle plugins repository. </p> </li> <li> <p> <code>public:maven-commonsware</code> - for the CommonsWare Android repository. </p> </li> <li> <p> <code>public:maven-clojars</code> - for the Clojars repository. </p> </li> <li> <p> <code>public:ruby-gems-org</code> - for RubyGems.org. </p> </li> <li> <p> <code>public:crates-io</code> - for Crates.io. </p> </li> </ul>', 'DisassociateExternalConnectionRequest$externalConnection' => '<p>The name of the external connection to be removed from the repository. </p>', 'DomainEntryPoint$externalConnectionName' => '<p>The name of the external connection that a package was ingested from.</p>', 'RepositoryExternalConnectionInfo$externalConnectionName' => '<p> The name of the external connection associated with a repository. </p>', ], ], 'ExternalConnectionStatus' => [ 'base' => NULL, 'refs' => [ 'RepositoryExternalConnectionInfo$status' => '<p> The status of the external connection of a repository. There is one valid value, <code>Available</code>. </p>', ], ], 'GetAssociatedPackageGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAssociatedPackageGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'GetAuthorizationTokenRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAuthorizationTokenResult' => [ 'base' => NULL, 'refs' => [], ], 'GetDomainPermissionsPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDomainPermissionsPolicyResult' => [ 'base' => NULL, 'refs' => [], ], 'GetPackageVersionAssetRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPackageVersionAssetResult' => [ 'base' => NULL, 'refs' => [], ], 'GetPackageVersionReadmeRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPackageVersionReadmeResult' => [ 'base' => NULL, 'refs' => [], ], 'GetRepositoryEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRepositoryEndpointResult' => [ 'base' => NULL, 'refs' => [], ], 'GetRepositoryPermissionsPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRepositoryPermissionsPolicyResult' => [ 'base' => NULL, 'refs' => [], ], 'HashAlgorithm' => [ 'base' => NULL, 'refs' => [ 'AssetHashes$key' => NULL, ], ], 'HashValue' => [ 'base' => NULL, 'refs' => [ 'AssetHashes$value' => NULL, ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'DomainDescription$repositoryCount' => '<p> The number of repositories in the domain. </p>', ], ], 'InternalServerException' => [ 'base' => '<p> The operation did not succeed because of an error that occurred inside CodeArtifact. </p>', 'refs' => [], ], 'LicenseInfo' => [ 'base' => '<p> Details of the license data. </p>', 'refs' => [ 'LicenseInfoList$member' => NULL, ], ], 'LicenseInfoList' => [ 'base' => NULL, 'refs' => [ 'PackageVersionDescription$licenses' => '<p> Information about licenses associated with the package version. </p>', ], ], 'ListAllowedRepositoriesForGroupMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListAllowedRepositoriesForGroupRequest$maxResults' => '<p> The maximum number of results to return per page. </p>', ], ], 'ListAllowedRepositoriesForGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAllowedRepositoriesForGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'ListAssociatedPackagesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAssociatedPackagesResult' => [ 'base' => NULL, 'refs' => [], ], 'ListDomainsMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListDomainsRequest$maxResults' => '<p> The maximum number of results to return per page. </p>', ], ], 'ListDomainsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDomainsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListPackageGroupsMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListPackageGroupsRequest$maxResults' => '<p> The maximum number of results to return per page. </p>', 'ListSubPackageGroupsRequest$maxResults' => '<p> The maximum number of results to return per page. </p>', ], ], 'ListPackageGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPackageGroupsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListPackageVersionAssetsMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListPackageVersionAssetsRequest$maxResults' => '<p> The maximum number of results to return per page. </p>', ], ], 'ListPackageVersionAssetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPackageVersionAssetsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListPackageVersionDependenciesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPackageVersionDependenciesResult' => [ 'base' => NULL, 'refs' => [], ], 'ListPackageVersionsMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListPackageVersionsRequest$maxResults' => '<p> The maximum number of results to return per page. </p>', ], ], 'ListPackageVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPackageVersionsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListPackagesMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListAssociatedPackagesRequest$maxResults' => '<p> The maximum number of results to return per page. </p>', 'ListPackagesRequest$maxResults' => '<p> The maximum number of results to return per page. </p>', ], ], 'ListPackagesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPackagesResult' => [ 'base' => NULL, 'refs' => [], ], 'ListRepositoriesInDomainMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListRepositoriesInDomainRequest$maxResults' => '<p> The maximum number of results to return per page. </p>', ], ], 'ListRepositoriesInDomainRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRepositoriesInDomainResult' => [ 'base' => NULL, 'refs' => [], ], 'ListRepositoriesMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListRepositoriesRequest$maxResults' => '<p> The maximum number of results to return per page. </p>', ], ], 'ListRepositoriesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRepositoriesResult' => [ 'base' => NULL, 'refs' => [], ], 'ListSubPackageGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSubPackageGroupsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResult' => [ 'base' => NULL, 'refs' => [], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'DomainDescription$assetSizeBytes' => '<p> The total size of all assets in the domain. </p>', ], ], 'LongOptional' => [ 'base' => NULL, 'refs' => [ 'AssetSummary$size' => '<p> The size of the asset. </p>', 'PackageGroupOriginRestriction$repositoriesCount' => '<p>The number of repositories in the allowed repository list.</p>', ], ], 'OriginRestrictions' => [ 'base' => NULL, 'refs' => [ 'UpdatePackageGroupOriginConfigurationRequest$restrictions' => '<p> The origin configuration settings that determine how package versions can enter repositories. </p>', ], ], 'PackageDependency' => [ 'base' => '<p> Details about a package dependency. </p>', 'refs' => [ 'PackageDependencyList$member' => NULL, ], ], 'PackageDependencyList' => [ 'base' => NULL, 'refs' => [ 'ListPackageVersionDependenciesResult$dependencies' => '<p> The returned list of <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageDependency.html">PackageDependency</a> objects. </p>', ], ], 'PackageDescription' => [ 'base' => '<p>Details about a package.</p>', 'refs' => [ 'DescribePackageResult$package' => '<p>A <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageDescription.html">PackageDescription</a> object that contains information about the requested package.</p>', ], ], 'PackageFormat' => [ 'base' => NULL, 'refs' => [ 'AssociatedPackage$format' => '<p>A format that specifies the type of the associated package.</p>', 'CopyPackageVersionsRequest$format' => '<p> The format of the package versions to be copied. </p>', 'DeletePackageRequest$format' => '<p>The format of the requested package to delete.</p>', 'DeletePackageVersionsRequest$format' => '<p> The format of the package versions to delete. </p>', 'DescribePackageRequest$format' => '<p>A format that specifies the type of the requested package.</p>', 'DescribePackageVersionRequest$format' => '<p> A format that specifies the type of the requested package version. </p>', 'DisposePackageVersionsRequest$format' => '<p> A format that specifies the type of package versions you want to dispose. </p>', 'GetAssociatedPackageGroupRequest$format' => '<p> The format of the package from which to get the associated package group. </p>', 'GetPackageVersionAssetRequest$format' => '<p> A format that specifies the type of the package version with the requested asset file. </p>', 'GetPackageVersionReadmeRequest$format' => '<p> A format that specifies the type of the package version with the requested readme file. </p>', 'GetPackageVersionReadmeResult$format' => '<p> The format of the package with the requested readme file. </p>', 'GetRepositoryEndpointRequest$format' => '<p> Returns which endpoint of a repository to return. A repository has one endpoint for each package format. </p>', 'ListPackageVersionAssetsRequest$format' => '<p> The format of the package that contains the requested package version assets. </p>', 'ListPackageVersionAssetsResult$format' => '<p> The format of the package that contains the requested package version assets. </p>', 'ListPackageVersionDependenciesRequest$format' => '<p> The format of the package with the requested dependencies. </p>', 'ListPackageVersionDependenciesResult$format' => '<p> A format that specifies the type of the package that contains the returned dependencies. </p>', 'ListPackageVersionsRequest$format' => '<p> The format of the package versions you want to list. </p>', 'ListPackageVersionsResult$format' => '<p> A format of the package. </p>', 'ListPackagesRequest$format' => '<p>The format used to filter requested packages. Only packages from the provided format will be returned.</p>', 'PackageDescription$format' => '<p>A format that specifies the type of the package.</p>', 'PackageSummary$format' => '<p> The format of the package. </p>', 'PackageVersionDescription$format' => '<p> The format of the package version. </p>', 'PublishPackageVersionRequest$format' => '<p>A format that specifies the type of the package version with the requested asset file.</p> <p>The only supported value is <code>generic</code>.</p>', 'PublishPackageVersionResult$format' => '<p>The format of the package version.</p>', 'PutPackageOriginConfigurationRequest$format' => '<p>A format that specifies the type of the package to be updated.</p>', 'RepositoryExternalConnectionInfo$packageFormat' => '<p> The package format associated with a repository\'s external connection. The valid package formats are: </p> <ul> <li> <p> <code>npm</code>: A Node Package Manager (npm) package. </p> </li> <li> <p> <code>pypi</code>: A Python Package Index (PyPI) package. </p> </li> <li> <p> <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file. </p> </li> <li> <p> <code>nuget</code>: A NuGet package. </p> </li> </ul>', 'UpdatePackageVersionsStatusRequest$format' => '<p> A format that specifies the type of the package with the statuses to update. </p>', ], ], 'PackageGroupAllowedRepository' => [ 'base' => '<p> Details about an allowed repository for a package group, including its name and origin configuration. </p>', 'refs' => [ 'PackageGroupAllowedRepositoryList$member' => NULL, ], ], 'PackageGroupAllowedRepositoryList' => [ 'base' => NULL, 'refs' => [ 'UpdatePackageGroupOriginConfigurationRequest$addAllowedRepositories' => '<p>The repository name and restrictions to add to the allowed repository list of the specified package group.</p>', 'UpdatePackageGroupOriginConfigurationRequest$removeAllowedRepositories' => '<p>The repository name and restrictions to remove from the allowed repository list of the specified package group.</p>', ], ], 'PackageGroupAllowedRepositoryUpdate' => [ 'base' => NULL, 'refs' => [ 'PackageGroupAllowedRepositoryUpdates$value' => NULL, ], ], 'PackageGroupAllowedRepositoryUpdateType' => [ 'base' => NULL, 'refs' => [ 'PackageGroupAllowedRepositoryUpdate$key' => NULL, ], ], 'PackageGroupAllowedRepositoryUpdates' => [ 'base' => NULL, 'refs' => [ 'UpdatePackageGroupOriginConfigurationResult$allowedRepositoryUpdates' => '<p>Information about the updated allowed repositories after processing the request.</p>', ], ], 'PackageGroupAssociationType' => [ 'base' => NULL, 'refs' => [ 'AssociatedPackage$associationType' => '<p>Describes the strength of the association between the package and package group. A strong match can be thought of as an exact match, and a weak match can be thought of as a variation match, for example, the package name matches a variation of the package group pattern. For more information about package group pattern matching, including strong and weak matches, see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/package-group-definition-syntax-matching-behavior.html">Package group definition syntax and matching behavior</a> in the <i>CodeArtifact User Guide</i>.</p>', 'GetAssociatedPackageGroupResult$associationType' => '<p>Describes the strength of the association between the package and package group. A strong match is also known as an exact match, and a weak match is known as a relative match.</p>', ], ], 'PackageGroupContactInfo' => [ 'base' => NULL, 'refs' => [ 'CreatePackageGroupRequest$contactInfo' => '<p> The contact information for the created package group. </p>', 'PackageGroupDescription$contactInfo' => '<p> The contact information of the package group. </p>', 'PackageGroupSummary$contactInfo' => '<p> The contact information of the package group. </p>', 'UpdatePackageGroupRequest$contactInfo' => '<p> Contact information which you want to update the requested package group with. </p>', ], ], 'PackageGroupDescription' => [ 'base' => '<p> The description of the package group. </p>', 'refs' => [ 'CreatePackageGroupResult$packageGroup' => '<p> Information about the created package group after processing the request. </p>', 'DeletePackageGroupResult$packageGroup' => '<p> Information about the deleted package group after processing the request. </p>', 'DescribePackageGroupResult$packageGroup' => '<p>A <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageGroupDescription.html">PackageGroupDescription</a> object that contains information about the requested package group.</p>', 'GetAssociatedPackageGroupResult$packageGroup' => '<p>The package group that is associated with the requested package.</p>', 'UpdatePackageGroupOriginConfigurationResult$packageGroup' => '<p> The package group and information about it after processing the request. </p>', 'UpdatePackageGroupResult$packageGroup' => '<p> The package group and information about it after the request has been processed. </p>', ], ], 'PackageGroupOriginConfiguration' => [ 'base' => '<p>The package group origin configuration that determines how package versions can enter repositories.</p>', 'refs' => [ 'PackageGroupDescription$originConfiguration' => '<p>The package group origin configuration that determines how package versions can enter repositories.</p>', 'PackageGroupSummary$originConfiguration' => '<p>Details about the package origin configuration of a package group.</p>', ], ], 'PackageGroupOriginRestriction' => [ 'base' => '<p>Contains information about the configured restrictions of the origin controls of a package group.</p>', 'refs' => [ 'PackageGroupOriginRestrictions$value' => NULL, ], ], 'PackageGroupOriginRestrictionMode' => [ 'base' => NULL, 'refs' => [ 'OriginRestrictions$value' => NULL, 'PackageGroupOriginRestriction$mode' => '<p>The package group origin restriction setting. If the value of <code>mode</code> is <code>ALLOW</code>, <code>ALLOW_SPECIFIC_REPOSITORIES</code>, or <code>BLOCK</code>, then the value of <code>effectiveMode</code> is the same. Otherwise, when the value is <code>INHERIT</code>, then the value of <code>effectiveMode</code> is the value of <code>mode</code> of the first parent group which does not have a value of <code>INHERIT</code>.</p>', 'PackageGroupOriginRestriction$effectiveMode' => '<p>The effective package group origin restriction setting. If the value of <code>mode</code> is <code>ALLOW</code>, <code>ALLOW_SPECIFIC_REPOSITORIES</code>, or <code>BLOCK</code>, then the value of <code>effectiveMode</code> is the same. Otherwise, when the value of <code>mode</code> is <code>INHERIT</code>, then the value of <code>effectiveMode</code> is the value of <code>mode</code> of the first parent group which does not have a value of <code>INHERIT</code>.</p>', ], ], 'PackageGroupOriginRestrictionType' => [ 'base' => NULL, 'refs' => [ 'ListAllowedRepositoriesForGroupRequest$originRestrictionType' => '<p>The origin configuration restriction type of which to list allowed repositories.</p>', 'OriginRestrictions$key' => NULL, 'PackageGroupAllowedRepository$originRestrictionType' => '<p>The origin configuration restriction type of the allowed repository.</p>', 'PackageGroupAllowedRepositoryUpdates$key' => NULL, 'PackageGroupOriginRestrictions$key' => NULL, ], ], 'PackageGroupOriginRestrictions' => [ 'base' => NULL, 'refs' => [ 'PackageGroupOriginConfiguration$restrictions' => '<p>The origin configuration settings that determine how package versions can enter repositories.</p>', ], ], 'PackageGroupPattern' => [ 'base' => NULL, 'refs' => [ 'CreatePackageGroupRequest$packageGroup' => '<p>The pattern of the package group to create. The pattern is also the identifier of the package group. </p>', 'DescribePackageGroupRequest$packageGroup' => '<p>The pattern of the requested package group.</p>', 'ListAllowedRepositoriesForGroupRequest$packageGroup' => '<p>The pattern of the package group from which to list allowed repositories.</p>', 'ListAssociatedPackagesRequest$packageGroup' => '<p> The pattern of the package group from which to list associated packages. </p>', 'ListSubPackageGroupsRequest$packageGroup' => '<p> The pattern of the package group from which to list sub package groups. </p>', 'PackageGroupDescription$pattern' => '<p> The pattern of the package group. The pattern determines which packages are associated with the package group. </p>', 'PackageGroupReference$pattern' => '<p> The pattern of the package group. The pattern determines which packages are associated with the package group, and is also the identifier of the package group. </p>', 'PackageGroupSummary$pattern' => '<p> The pattern of the package group. The pattern determines which packages are associated with the package group. </p>', 'UpdatePackageGroupOriginConfigurationRequest$packageGroup' => '<p> The pattern of the package group for which to update the origin configuration. </p>', 'UpdatePackageGroupRequest$packageGroup' => '<p> The pattern of the package group to be updated. </p>', ], ], 'PackageGroupPatternPrefix' => [ 'base' => NULL, 'refs' => [ 'ListPackageGroupsRequest$prefix' => '<p> A prefix for which to search package groups. When included, <code>ListPackageGroups</code> will return only package groups with patterns that match the prefix. </p>', ], ], 'PackageGroupReference' => [ 'base' => '<p>Information about the identifiers of a package group.</p>', 'refs' => [ 'PackageGroupDescription$parent' => '<p> The direct parent package group of the package group. </p>', 'PackageGroupOriginRestriction$inheritedFrom' => '<p>The parent package group that the package group origin restrictions are inherited from.</p>', 'PackageGroupSummary$parent' => '<p> The direct parent package group of the package group. </p>', ], ], 'PackageGroupSummary' => [ 'base' => '<p>Details about a package group.</p>', 'refs' => [ 'PackageGroupSummaryList$member' => NULL, ], ], 'PackageGroupSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListPackageGroupsResult$packageGroups' => '<p> The list of package groups in the requested domain. </p>', 'ListSubPackageGroupsResult$packageGroups' => '<p> A list of sub package groups for the requested package group. </p>', ], ], 'PackageName' => [ 'base' => NULL, 'refs' => [ 'AssociatedPackage$package' => '<p> The name of the associated package. </p>', 'CopyPackageVersionsRequest$package' => '<p> The name of the package that contains the versions to be copied. </p>', 'DeletePackageRequest$package' => '<p>The name of the package to delete.</p>', 'DeletePackageVersionsRequest$package' => '<p> The name of the package with the versions to delete. </p>', 'DescribePackageRequest$package' => '<p>The name of the requested package.</p>', 'DescribePackageVersionRequest$package' => '<p> The name of the requested package version. </p>', 'DisposePackageVersionsRequest$package' => '<p> The name of the package with the versions you want to dispose. </p>', 'GetAssociatedPackageGroupRequest$package' => '<p> The package from which to get the associated package group. </p>', 'GetPackageVersionAssetRequest$package' => '<p> The name of the package that contains the requested asset. </p>', 'GetPackageVersionReadmeRequest$package' => '<p> The name of the package version that contains the requested readme file. </p>', 'GetPackageVersionReadmeResult$package' => '<p> The name of the package that contains the returned readme file. </p>', 'ListPackageVersionAssetsRequest$package' => '<p> The name of the package that contains the requested package version assets. </p>', 'ListPackageVersionAssetsResult$package' => '<p> The name of the package that contains the requested package version assets. </p>', 'ListPackageVersionDependenciesRequest$package' => '<p> The name of the package versions\' package. </p>', 'ListPackageVersionDependenciesResult$package' => '<p> The name of the package that contains the returned package versions dependencies. </p>', 'ListPackageVersionsRequest$package' => '<p> The name of the package for which you want to request package versions. </p>', 'ListPackageVersionsResult$package' => '<p> The name of the package. </p>', 'ListPackagesRequest$packagePrefix' => '<p> A prefix used to filter requested packages. Only packages with names that start with <code>packagePrefix</code> are returned. </p>', 'PackageDependency$package' => '<p> The name of the package that this package depends on. </p>', 'PackageDescription$name' => '<p>The name of the package.</p>', 'PackageSummary$package' => '<p> The name of the package. </p>', 'PackageVersionDescription$packageName' => '<p> The name of the requested package. </p>', 'PublishPackageVersionRequest$package' => '<p>The name of the package version to publish.</p>', 'PublishPackageVersionResult$package' => '<p>The name of the package.</p>', 'PutPackageOriginConfigurationRequest$package' => '<p>The name of the package to be updated.</p>', 'UpdatePackageVersionsStatusRequest$package' => '<p> The name of the package with the version statuses to update. </p>', ], ], 'PackageNamespace' => [ 'base' => NULL, 'refs' => [ 'AssociatedPackage$namespace' => '<p>The namespace of the associated package. The package component that specifies its namespace depends on its type. For example:</p> <ul> <li> <p> The namespace of a Maven package version is its <code>groupId</code>. </p> </li> <li> <p> The namespace of an npm or Swift package version is its <code>scope</code>. </p> </li> <li> <p>The namespace of a generic package is its <code>namespace</code>.</p> </li> <li> <p> Python, NuGet, Ruby, and Cargo package versions do not contain a corresponding component, package versions of those formats do not have a namespace. </p> </li> </ul>', 'CopyPackageVersionsRequest$namespace' => '<p>The namespace of the package versions to be copied. The package component that specifies its namespace depends on its type. For example:</p> <note> <p>The namespace is required when copying package versions of the following formats:</p> <ul> <li> <p>Maven</p> </li> <li> <p>Swift</p> </li> <li> <p>generic</p> </li> </ul> </note> <ul> <li> <p> The namespace of a Maven package version is its <code>groupId</code>. </p> </li> <li> <p> The namespace of an npm or Swift package version is its <code>scope</code>. </p> </li> <li> <p>The namespace of a generic package is its <code>namespace</code>.</p> </li> <li> <p> Python, NuGet, Ruby, and Cargo package versions do not contain a corresponding component, package versions of those formats do not have a namespace. </p> </li> </ul>', 'DeletePackageRequest$namespace' => '<p>The namespace of the package to delete. The package component that specifies its namespace depends on its type. For example:</p> <note> <p>The namespace is required when deleting packages of the following formats:</p> <ul> <li> <p>Maven</p> </li> <li> <p>Swift</p> </li> <li> <p>generic</p> </li> </ul> </note> <ul> <li> <p> The namespace of a Maven package version is its <code>groupId</code>. </p> </li> <li> <p> The namespace of an npm or Swift package version is its <code>scope</code>. </p> </li> <li> <p>The namespace of a generic package is its <code>namespace</code>.</p> </li> <li> <p> Python, NuGet, Ruby, and Cargo package versions do not contain a corresponding component, package versions of those formats do not have a namespace. </p> </li> </ul>', 'DeletePackageVersionsRequest$namespace' => '<p>The namespace of the package versions to be deleted. The package component that specifies its namespace depends on its type. For example:</p> <note> <p>The namespace is required when deleting package versions of the following formats:</p> <ul> <li> <p>Maven</p> </li> <li> <p>Swift</p> </li> <li> <p>generic</p> </li> </ul> </note> <ul> <li> <p> The namespace of a Maven package version is its <code>groupId</code>. </p> </li> <li> <p> The namespace of an npm or Swift package version is its <code>scope</code>. </p> </li> <li> <p>The namespace of a generic package is its <code>namespace</code>.</p> </li> <li> <p> Python, NuGet, Ruby, and Cargo package versions do not contain a corresponding component, package versions of those formats do not have a namespace. </p> </li> </ul>', 'DescribePackageRequest$namespace' => '<p>The namespace of the requested package. The package component that specifies its namespace depends on its type. For example:</p> <note> <p>The namespace is required when requesting packages of the following formats:</p> <ul> <li> <p>Maven</p> </li> <li> <p>Swift</p> </li> <li> <p>generic</p> </li> </ul> </note> <ul> <li> <p> The namespace of a Maven package version is its <code>groupId</code>. </p> </li> <li> <p> The namespace of an npm or Swift package version is its <code>scope</code>. </p> </li> <li> <p>The namespace of a generic package is its <code>namespace</code>.</p> </li> <li> <p> Python, NuGet, Ruby, and Cargo package versions do not contain a corresponding component, package versions of those formats do not have a namespace. </p> </li> </ul>', 'DescribePackageVersionRequest$namespace' => '<p>The namespace of the requested package version. The package component that specifies its namespace depends on its type. For example:</p> <note> <p>The namespace is required when requesting package versions of the following formats:</p> <ul> <li> <p>Maven</p> </li> <li> <p>Swift</p> </li> <li> <p>generic</p> </li> </ul> </note> <ul> <li> <p> The namespace of a Maven package version is its <code>groupId</code>. </p> </li> <li> <p> The namespace of an npm or Swift package version is its <code>scope</code>. </p> </li> <li> <p>The namespace of a generic package is its <code>namespace</code>.</p> </li> <li> <p> Python, NuGet, Ruby, and Cargo package versions do not contain a corresponding component, package versions of those formats do not have a namespace. </p> </li> </ul>', 'DisposePackageVersionsRequest$namespace' => '<p>The namespace of the package versions to be disposed. The package component that specifies its namespace depends on its type. For example:</p> <note> <p>The namespace is required when disposing package versions of the following formats:</p> <ul> <li> <p>Maven</p> </li> <li> <p>Swift</p> </li> <li> <p>generic</p> </li> </ul> </note> <ul> <li> <p> The namespace of a Maven package version is its <code>groupId</code>. </p> </li> <li> <p> The namespace of an npm or Swift package version is its <code>scope</code>. </p> </li> <li> <p>The namespace of a generic package is its <code>namespace</code>.</p> </li> <li> <p> Python, NuGet, Ruby, and Cargo package versions do not contain a corresponding component, package versions of those formats do not have a namespace. </p> </li> </ul>', 'GetAssociatedPackageGroupRequest$namespace' => '<p>The namespace of the package from which to get the associated package group. The package component that specifies its namespace depends on its type. For example:</p> <note> <p>The namespace is required when getting associated package groups from packages of the following formats:</p> <ul> <li> <p>Maven</p> </li> <li> <p>Swift</p> </li> <li> <p>generic</p> </li> </ul> </note> <ul> <li> <p> The namespace of a Maven package version is its <code>groupId</code>. </p> </li> <li> <p> The namespace of an npm or Swift package version is its <code>scope</code>. </p> </li> <li> <p>The namespace of a generic package is its <code>namespace</code>.</p> </li> <li> <p> Python, NuGet, Ruby, and Cargo package versions do not contain a corresponding component, package versions of those formats do not have a namespace. </p> </li> </ul>', 'GetPackageVersionAssetRequest$namespace' => '<p>The namespace of the package version with the requested asset file. The package component that specifies its namespace depends on its type. For example:</p> <note> <p>The namespace is required when requesting assets from package versions of the following formats:</p> <ul> <li> <p>Maven</p> </li> <li> <p>Swift</p> </li> <li> <p>generic</p> </li> </ul> </note> <ul> <li> <p> The namespace of a Maven package version is its <code>groupId</code>. </p> </li> <li> <p> The namespace of an npm or Swift package version is its <code>scope</code>. </p> </li> <li> <p>The namespace of a generic package is its <code>namespace</code>.</p> </li> <li> <p> Python, NuGet, Ruby, and Cargo package versions do not contain a corresponding component, package versions of those formats do not have a namespace. </p> </li> </ul>', 'GetPackageVersionReadmeRequest$namespace' => '<p>The namespace of the package version with the requested readme file. The package component that specifies its namespace depends on its type. For example:</p> <note> <p>The namespace is required when requesting the readme from package versions of the following formats:</p> <ul> <li> <p>Maven</p> </li> <li> <p>Swift</p> </li> <li> <p>generic</p> </li> </ul> </note> <ul> <li> <p> The namespace of a Maven package version is its <code>groupId</code>. </p> </li> <li> <p> The namespace of an npm or Swift package version is its <code>scope</code>. </p> </li> <li> <p>The namespace of a generic package is its <code>namespace</code>.</p> </li> <li> <p> Python, NuGet, Ruby, and Cargo package versions do not contain a corresponding component, package versions of those formats do not have a namespace. </p> </li> </ul>', 'GetPackageVersionReadmeResult$namespace' => '<p>The namespace of the package version with the requested readme file. The package component that specifies its namespace depends on its type. For example:</p> <ul> <li> <p> The namespace of a Maven package version is its <code>groupId</code>. </p> </li> <li> <p> The namespace of an npm or Swift package version is its <code>scope</code>. </p> </li> <li> <p>The namespace of a generic package is its <code>namespace</code>.</p> </li> <li> <p> Python, NuGet, Ruby, and Cargo package versions do not contain a corresponding component, package versions of those formats do not have a namespace. </p> </li> </ul>', 'ListPackageVersionAssetsRequest$namespace' => '<p>The namespace of the package version that contains the requested package version assets. The package component that specifies its namespace depends on its type. For example:</p> <note> <p>The namespace is required requesting assets from package versions of the following formats:</p> <ul> <li> <p>Maven</p> </li> <li> <p>Swift</p> </li> <li> <p>generic</p> </li> </ul> </note> <ul> <li> <p> The namespace of a Maven package version is its <code>groupId</code>. </p> </li> <li> <p> The namespace of an npm or Swift package version is its <code>scope</code>. </p> </li> <li> <p>The namespace of a generic package is its <code>namespace</code>.</p> </li> <li> <p> Python, NuGet, Ruby, and Cargo package versions do not contain a corresponding component, package versions of those formats do not have a namespace. </p> </li> </ul>', 'ListPackageVersionAssetsResult$namespace' => '<p>The namespace of the package version that contains the requested package version assets. The package component that specifies its namespace depends on its type. For example:</p> <ul> <li> <p> The namespace of a Maven package version is its <code>groupId</code>. </p> </li> <li> <p> The namespace of an npm or Swift package version is its <code>scope</code>. </p> </li> <li> <p>The namespace of a generic package is its <code>namespace</code>.</p> </li> <li> <p> Python, NuGet, Ruby, and Cargo package versions do not contain a corresponding component, package versions of those formats do not have a namespace. </p> </li> </ul>', 'ListPackageVersionDependenciesRequest$namespace' => '<p>The namespace of the package version with the requested dependencies. The package component that specifies its namespace depends on its type. For example:</p> <note> <p>The namespace is required when listing dependencies from package versions of the following formats:</p> <ul> <li> <p>Maven</p> </li> </ul> </note> <ul> <li> <p> The namespace of a Maven package version is its <code>groupId</code>. </p> </li> <li> <p> The namespace of an npm package version is its <code>scope</code>. </p> </li> <li> <p> Python and NuGet package versions do not contain a corresponding component, package versions of those formats do not have a namespace. </p> </li> </ul>', 'ListPackageVersionDependenciesResult$namespace' => '<p>The namespace of the package version that contains the returned dependencies. The package component that specifies its namespace depends on its type. For example:</p> <note> <p>The namespace is required when listing dependencies from package versions of the following formats:</p> <ul> <li> <p>Maven</p> </li> </ul> </note> <ul> <li> <p> The namespace of a Maven package version is its <code>groupId</code>. </p> </li> <li> <p> The namespace of an npm package version is its <code>scope</code>. </p> </li> <li> <p> Python and NuGet package versions do not contain a corresponding component, package versions of those formats do not have a namespace. </p> </li> </ul>', 'ListPackageVersionsRequest$namespace' => '<p>The namespace of the package that contains the requested package versions. The package component that specifies its namespace depends on its type. For example:</p> <note> <p>The namespace is required when deleting package versions of the following formats:</p> <ul> <li> <p>Maven</p> </li> <li> <p>Swift</p> </li> <li> <p>generic</p> </li> </ul> </note> <ul> <li> <p> The namespace of a Maven package version is its <code>groupId</code>. </p> </li> <li> <p> The namespace of an npm or Swift package version is its <code>scope</code>. </p> </li> <li> <p>The namespace of a generic package is its <code>namespace</code>.</p> </li> <li> <p> Python, NuGet, Ruby, and Cargo package versions do not contain a corresponding component, package versions of those formats do not have a namespace. </p> </li> </ul>', 'ListPackageVersionsResult$namespace' => '<p>The namespace of the package that contains the requested package versions. The package component that specifies its namespace depends on its type. For example:</p> <ul> <li> <p> The namespace of a Maven package version is its <code>groupId</code>. </p> </li> <li> <p> The namespace of an npm or Swift package version is its <code>scope</code>. </p> </li> <li> <p>The namespace of a generic package is its <code>namespace</code>.</p> </li> <li> <p> Python, NuGet, Ruby, and Cargo package versions do not contain a corresponding component, package versions of those formats do not have a namespace. </p> </li> </ul>', 'ListPackagesRequest$namespace' => '<p>The namespace prefix used to filter requested packages. Only packages with a namespace that starts with the provided string value are returned. Note that although this option is called <code>--namespace</code> and not <code>--namespace-prefix</code>, it has prefix-matching behavior.</p> <p>Each package format uses namespace as follows:</p> <ul> <li> <p> The namespace of a Maven package version is its <code>groupId</code>. </p> </li> <li> <p> The namespace of an npm or Swift package version is its <code>scope</code>. </p> </li> <li> <p>The namespace of a generic package is its <code>namespace</code>.</p> </li> <li> <p> Python, NuGet, Ruby, and Cargo package versions do not contain a corresponding component, package versions of those formats do not have a namespace. </p> </li> </ul>', 'PackageDependency$namespace' => '<p>The namespace of the package that this package depends on. The package component that specifies its namespace depends on its type. For example:</p> <ul> <li> <p> The namespace of a Maven package version is its <code>groupId</code>. </p> </li> <li> <p> The namespace of an npm or Swift package version is its <code>scope</code>. </p> </li> <li> <p>The namespace of a generic package is its <code>namespace</code>.</p> </li> <li> <p> Python, NuGet, Ruby, and Cargo package versions do not contain a corresponding component, package versions of those formats do not have a namespace. </p> </li> </ul>', 'PackageDescription$namespace' => '<p>The namespace of the package. The package component that specifies its namespace depends on its type. For example:</p> <ul> <li> <p> The namespace of a Maven package version is its <code>groupId</code>. </p> </li> <li> <p> The namespace of an npm or Swift package version is its <code>scope</code>. </p> </li> <li> <p>The namespace of a generic package is its <code>namespace</code>.</p> </li> <li> <p> Python, NuGet, Ruby, and Cargo package versions do not contain a corresponding component, package versions of those formats do not have a namespace. </p> </li> </ul>', 'PackageSummary$namespace' => '<p>The namespace of the package. The package component that specifies its namespace depends on its type. For example:</p> <ul> <li> <p> The namespace of a Maven package version is its <code>groupId</code>. </p> </li> <li> <p> The namespace of an npm or Swift package version is its <code>scope</code>. </p> </li> <li> <p>The namespace of a generic package is its <code>namespace</code>.</p> </li> <li> <p> Python, NuGet, Ruby, and Cargo package versions do not contain a corresponding component, package versions of those formats do not have a namespace. </p> </li> </ul>', 'PackageVersionDescription$namespace' => '<p>The namespace of the package version. The package component that specifies its namespace depends on its type. For example:</p> <ul> <li> <p> The namespace of a Maven package version is its <code>groupId</code>. </p> </li> <li> <p> The namespace of an npm or Swift package version is its <code>scope</code>. </p> </li> <li> <p>The namespace of a generic package is its <code>namespace</code>.</p> </li> <li> <p> Python, NuGet, Ruby, and Cargo package versions do not contain a corresponding component, package versions of those formats do not have a namespace. </p> </li> </ul>', 'PublishPackageVersionRequest$namespace' => '<p>The namespace of the package version to publish.</p>', 'PublishPackageVersionResult$namespace' => '<p>The namespace of the package version.</p>', 'PutPackageOriginConfigurationRequest$namespace' => '<p>The namespace of the package to be updated. The package component that specifies its namespace depends on its type. For example:</p> <ul> <li> <p> The namespace of a Maven package version is its <code>groupId</code>. </p> </li> <li> <p> The namespace of an npm or Swift package version is its <code>scope</code>. </p> </li> <li> <p>The namespace of a generic package is its <code>namespace</code>.</p> </li> <li> <p> Python, NuGet, Ruby, and Cargo package versions do not contain a corresponding component, package versions of those formats do not have a namespace. </p> </li> </ul>', 'UpdatePackageVersionsStatusRequest$namespace' => '<p>The namespace of the package version to be updated. The package component that specifies its namespace depends on its type. For example:</p> <ul> <li> <p> The namespace of a Maven package version is its <code>groupId</code>. </p> </li> <li> <p> The namespace of an npm or Swift package version is its <code>scope</code>. </p> </li> <li> <p>The namespace of a generic package is its <code>namespace</code>.</p> </li> <li> <p> Python, NuGet, Ruby, and Cargo package versions do not contain a corresponding component, package versions of those formats do not have a namespace. </p> </li> </ul>', ], ], 'PackageOriginConfiguration' => [ 'base' => '<p>Details about the package origin configuration of a package.</p>', 'refs' => [ 'PackageDescription$originConfiguration' => '<p>The package origin configuration for the package.</p>', 'PackageSummary$originConfiguration' => '<p>A <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageOriginConfiguration.html">PackageOriginConfiguration</a> object that contains a <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageOriginRestrictions.html">PackageOriginRestrictions</a> object that contains information about the upstream and publish package origin restrictions.</p>', 'PutPackageOriginConfigurationResult$originConfiguration' => '<p>A <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageOriginConfiguration.html">PackageOriginConfiguration</a> object that describes the origin configuration set for the package. It contains a <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageOriginRestrictions.html">PackageOriginRestrictions</a> object that describes how new versions of the package can be introduced to the repository.</p>', ], ], 'PackageOriginRestrictions' => [ 'base' => '<p>Details about the origin restrictions set on the package. The package origin restrictions determine how new versions of a package can be added to a specific repository.</p>', 'refs' => [ 'PackageOriginConfiguration$restrictions' => '<p>A <code>PackageOriginRestrictions</code> object that contains information about the upstream and publish package origin configuration for the package.</p>', 'PutPackageOriginConfigurationRequest$restrictions' => '<p>A <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageOriginRestrictions.html">PackageOriginRestrictions</a> object that contains information about the <code>upstream</code> and <code>publish</code> package origin restrictions. The <code>upstream</code> restriction determines if new package versions can be ingested or retained from external connections or upstream repositories. The <code>publish</code> restriction determines if new package versions can be published directly to the repository.</p> <p>You must include both the desired <code>upstream</code> and <code>publish</code> restrictions.</p>', ], ], 'PackageSummary' => [ 'base' => '<p> Details about a package, including its format, namespace, and name. </p>', 'refs' => [ 'DeletePackageResult$deletedPackage' => NULL, 'PackageSummaryList$member' => NULL, ], ], 'PackageSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListPackagesResult$packages' => '<p> The list of returned <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageSummary.html">PackageSummary</a> objects. </p>', ], ], 'PackageVersion' => [ 'base' => NULL, 'refs' => [ 'DescribePackageVersionRequest$packageVersion' => '<p> A string that contains the package version (for example, <code>3.5.2</code>). </p>', 'GetPackageVersionAssetRequest$packageVersion' => '<p> A string that contains the package version (for example, <code>3.5.2</code>). </p>', 'GetPackageVersionAssetResult$packageVersion' => '<p> A string that contains the package version (for example, <code>3.5.2</code>). </p>', 'GetPackageVersionReadmeRequest$packageVersion' => '<p> A string that contains the package version (for example, <code>3.5.2</code>). </p>', 'GetPackageVersionReadmeResult$version' => '<p> The version of the package with the requested readme file. </p>', 'ListPackageVersionAssetsRequest$packageVersion' => '<p> A string that contains the package version (for example, <code>3.5.2</code>). </p>', 'ListPackageVersionAssetsResult$version' => '<p> The version of the package associated with the requested assets. </p>', 'ListPackageVersionDependenciesRequest$packageVersion' => '<p> A string that contains the package version (for example, <code>3.5.2</code>). </p>', 'ListPackageVersionDependenciesResult$version' => '<p> The version of the package that is specified in the request. </p>', 'ListPackageVersionsResult$defaultDisplayVersion' => '<p> The default package version to display. This depends on the package format: </p> <ul> <li> <p> For Maven and PyPI packages, it\'s the most recently published package version. </p> </li> <li> <p> For npm packages, it\'s the version referenced by the <code>latest</code> tag. If the <code>latest</code> tag is not set, it\'s the most recently published package version. </p> </li> </ul>', 'PackageVersionDescription$version' => '<p> The version of the package. </p>', 'PackageVersionErrorMap$key' => NULL, 'PackageVersionList$member' => NULL, 'PackageVersionRevisionMap$key' => NULL, 'PackageVersionSummary$version' => '<p> Information about a package version. </p>', 'PublishPackageVersionRequest$packageVersion' => '<p>The package version to publish (for example, <code>3.5.2</code>).</p>', 'PublishPackageVersionResult$version' => '<p>The version of the package.</p>', 'SuccessfulPackageVersionInfoMap$key' => NULL, ], ], 'PackageVersionDescription' => [ 'base' => '<p> Details about a package version. </p>', 'refs' => [ 'DescribePackageVersionResult$packageVersion' => '<p> A <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionDescription.html">PackageVersionDescription</a> object that contains information about the requested package version. </p>', ], ], 'PackageVersionError' => [ 'base' => '<p>l An error associated with package. </p>', 'refs' => [ 'PackageVersionErrorMap$value' => NULL, ], ], 'PackageVersionErrorCode' => [ 'base' => NULL, 'refs' => [ 'PackageVersionError$errorCode' => '<p> The error code associated with the error. Valid error codes are: </p> <ul> <li> <p> <code>ALREADY_EXISTS</code> </p> </li> <li> <p> <code>MISMATCHED_REVISION</code> </p> </li> <li> <p> <code>MISMATCHED_STATUS</code> </p> </li> <li> <p> <code>NOT_ALLOWED</code> </p> </li> <li> <p> <code>NOT_FOUND</code> </p> </li> <li> <p> <code>SKIPPED</code> </p> </li> </ul>', ], ], 'PackageVersionErrorMap' => [ 'base' => NULL, 'refs' => [ 'CopyPackageVersionsResult$failedVersions' => '<p> A map of package versions that failed to copy and their error codes. The possible error codes are in the <code>PackageVersionError</code> data type. They are: </p> <ul> <li> <p> <code>ALREADY_EXISTS</code> </p> </li> <li> <p> <code>MISMATCHED_REVISION</code> </p> </li> <li> <p> <code>MISMATCHED_STATUS</code> </p> </li> <li> <p> <code>NOT_ALLOWED</code> </p> </li> <li> <p> <code>NOT_FOUND</code> </p> </li> <li> <p> <code>SKIPPED</code> </p> </li> </ul>', 'DeletePackageVersionsResult$failedVersions' => '<p> A <code>PackageVersionError</code> object that contains a map of errors codes for the deleted package that failed. The possible error codes are: </p> <ul> <li> <p> <code>ALREADY_EXISTS</code> </p> </li> <li> <p> <code>MISMATCHED_REVISION</code> </p> </li> <li> <p> <code>MISMATCHED_STATUS</code> </p> </li> <li> <p> <code>NOT_ALLOWED</code> </p> </li> <li> <p> <code>NOT_FOUND</code> </p> </li> <li> <p> <code>SKIPPED</code> </p> </li> </ul>', 'DisposePackageVersionsResult$failedVersions' => '<p> A <code>PackageVersionError</code> object that contains a map of errors codes for the disposed package versions that failed. The possible error codes are: </p> <ul> <li> <p> <code>ALREADY_EXISTS</code> </p> </li> <li> <p> <code>MISMATCHED_REVISION</code> </p> </li> <li> <p> <code>MISMATCHED_STATUS</code> </p> </li> <li> <p> <code>NOT_ALLOWED</code> </p> </li> <li> <p> <code>NOT_FOUND</code> </p> </li> <li> <p> <code>SKIPPED</code> </p> </li> </ul>', 'UpdatePackageVersionsStatusResult$failedVersions' => '<p> A list of <code>SuccessfulPackageVersionInfo</code> objects, one for each package version with a status that successfully updated. </p>', ], ], 'PackageVersionList' => [ 'base' => NULL, 'refs' => [ 'CopyPackageVersionsRequest$versions' => '<p> The versions of the package to be copied. </p> <note> <p> You must specify <code>versions</code> or <code>versionRevisions</code>. You cannot specify both. </p> </note>', 'DeletePackageVersionsRequest$versions' => '<p> An array of strings that specify the versions of the package to delete. </p>', 'DisposePackageVersionsRequest$versions' => '<p> The versions of the package you want to dispose. </p>', 'UpdatePackageVersionsStatusRequest$versions' => '<p> An array of strings that specify the versions of the package with the statuses to update. </p>', ], ], 'PackageVersionOrigin' => [ 'base' => '<p>Information about how a package version was added to a repository.</p>', 'refs' => [ 'PackageVersionDescription$origin' => '<p>A <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionOrigin.html">PackageVersionOrigin</a> object that contains information about how the package version was added to the repository.</p>', 'PackageVersionSummary$origin' => '<p>A <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionOrigin.html">PackageVersionOrigin</a> object that contains information about how the package version was added to the repository.</p>', ], ], 'PackageVersionOriginType' => [ 'base' => NULL, 'refs' => [ 'ListPackageVersionsRequest$originType' => '<p>The <code>originType</code> used to filter package versions. Only package versions with the provided <code>originType</code> will be returned.</p>', 'PackageVersionOrigin$originType' => '<p>Describes how the package version was originally added to the domain. An <code>INTERNAL</code> origin type means the package version was published directly to a repository in the domain. An <code>EXTERNAL</code> origin type means the package version was ingested from an external connection.</p>', ], ], 'PackageVersionRevision' => [ 'base' => NULL, 'refs' => [ 'GetPackageVersionAssetRequest$packageVersionRevision' => '<p> The name of the package version revision that contains the requested asset. </p>', 'GetPackageVersionAssetResult$packageVersionRevision' => '<p> The name of the package version revision that contains the downloaded asset. </p>', 'GetPackageVersionReadmeResult$versionRevision' => '<p> The current revision associated with the package version. </p>', 'ListPackageVersionAssetsResult$versionRevision' => '<p> The current revision associated with the package version. </p>', 'ListPackageVersionDependenciesResult$versionRevision' => '<p> The current revision associated with the package version. </p>', 'PackageVersionDescription$revision' => '<p> The revision of the package version. </p>', 'PackageVersionRevisionMap$value' => NULL, 'PackageVersionSummary$revision' => '<p> The revision associated with a package version. </p>', 'PublishPackageVersionResult$versionRevision' => '<p>The revision of the package version.</p>', ], ], 'PackageVersionRevisionMap' => [ 'base' => NULL, 'refs' => [ 'CopyPackageVersionsRequest$versionRevisions' => '<p> A list of key-value pairs. The keys are package versions and the values are package version revisions. A <code>CopyPackageVersion</code> operation succeeds if the specified versions in the source repository match the specified package version revision. </p> <note> <p> You must specify <code>versions</code> or <code>versionRevisions</code>. You cannot specify both. </p> </note>', 'DisposePackageVersionsRequest$versionRevisions' => '<p> The revisions of the package versions you want to dispose. </p>', 'UpdatePackageVersionsStatusRequest$versionRevisions' => '<p> A map of package versions and package version revisions. The map <code>key</code> is the package version (for example, <code>3.5.2</code>), and the map <code>value</code> is the package version revision. </p>', ], ], 'PackageVersionSortType' => [ 'base' => NULL, 'refs' => [ 'ListPackageVersionsRequest$sortBy' => '<p> How to sort the requested list of package versions. </p>', ], ], 'PackageVersionStatus' => [ 'base' => NULL, 'refs' => [ 'DeletePackageVersionsRequest$expectedStatus' => '<p> The expected status of the package version to delete. </p>', 'DisposePackageVersionsRequest$expectedStatus' => '<p> The expected status of the package version to dispose. </p>', 'ListPackageVersionsRequest$status' => '<p> A string that filters the requested package versions by status. </p>', 'PackageVersionDescription$status' => '<p> A string that contains the status of the package version. </p>', 'PackageVersionSummary$status' => '<p> A string that contains the status of the package version. It can be one of the following: </p>', 'PublishPackageVersionResult$status' => '<p>A string that contains the status of the package version. For more information, see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/packages-overview.html#package-version-status.html#package-version-status">Package version status</a> in the <i>CodeArtifact User Guide</i>.</p>', 'SuccessfulPackageVersionInfo$status' => '<p> The status of a package version. </p>', 'UpdatePackageVersionsStatusRequest$expectedStatus' => '<p> The package version’s expected status before it is updated. If <code>expectedStatus</code> is provided, the package version\'s status is updated only if its status at the time <code>UpdatePackageVersionsStatus</code> is called matches <code>expectedStatus</code>. </p>', 'UpdatePackageVersionsStatusRequest$targetStatus' => '<p> The status you want to change the package version status to. </p>', ], ], 'PackageVersionSummary' => [ 'base' => '<p> Details about a package version, including its status, version, and revision. The <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListPackageVersions.html">ListPackageVersions</a> operation returns a list of <code>PackageVersionSummary</code> objects. </p>', 'refs' => [ 'PackageVersionSummaryList$member' => NULL, ], ], 'PackageVersionSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListPackageVersionsResult$versions' => '<p> The returned list of <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionSummary.html">PackageVersionSummary</a> objects. </p>', ], ], 'PaginationToken' => [ 'base' => NULL, 'refs' => [ 'ListAllowedRepositoriesForGroupRequest$nextToken' => '<p> The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. </p>', 'ListAllowedRepositoriesForGroupResult$nextToken' => '<p> The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. </p>', 'ListAssociatedPackagesRequest$nextToken' => '<p> The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. </p>', 'ListAssociatedPackagesResult$nextToken' => '<p> The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. </p>', 'ListDomainsRequest$nextToken' => '<p> The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. </p>', 'ListDomainsResult$nextToken' => '<p> The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. </p>', 'ListPackageGroupsRequest$nextToken' => '<p> The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. </p>', 'ListPackageGroupsResult$nextToken' => '<p> The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. </p>', 'ListPackageVersionAssetsRequest$nextToken' => '<p> The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. </p>', 'ListPackageVersionAssetsResult$nextToken' => '<p> If there are additional results, this is the token for the next set of results. </p>', 'ListPackageVersionDependenciesRequest$nextToken' => '<p> The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. </p>', 'ListPackageVersionDependenciesResult$nextToken' => '<p> The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. </p>', 'ListPackageVersionsRequest$nextToken' => '<p> The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. </p>', 'ListPackageVersionsResult$nextToken' => '<p> If there are additional results, this is the token for the next set of results. </p>', 'ListPackagesRequest$nextToken' => '<p> The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. </p>', 'ListPackagesResult$nextToken' => '<p> If there are additional results, this is the token for the next set of results. </p>', 'ListRepositoriesInDomainRequest$nextToken' => '<p> The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. </p>', 'ListRepositoriesInDomainResult$nextToken' => '<p> If there are additional results, this is the token for the next set of results. </p>', 'ListRepositoriesRequest$nextToken' => '<p> The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. </p>', 'ListRepositoriesResult$nextToken' => '<p> If there are additional results, this is the token for the next set of results. </p>', 'ListSubPackageGroupsRequest$nextToken' => '<p> The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. </p>', 'ListSubPackageGroupsResult$nextToken' => '<p> If there are additional results, this is the token for the next set of results. </p>', ], ], 'PolicyDocument' => [ 'base' => NULL, 'refs' => [ 'PutDomainPermissionsPolicyRequest$policyDocument' => '<p> A valid displayable JSON Aspen policy string to be set as the access control resource policy on the provided domain. </p>', 'PutRepositoryPermissionsPolicyRequest$policyDocument' => '<p> A valid displayable JSON Aspen policy string to be set as the access control resource policy on the provided repository. </p>', 'ResourcePolicy$document' => '<p> The resource policy formatted in JSON. </p>', ], ], 'PolicyRevision' => [ 'base' => NULL, 'refs' => [ 'DeleteDomainPermissionsPolicyRequest$policyRevision' => '<p> The current revision of the resource policy to be deleted. This revision is used for optimistic locking, which prevents others from overwriting your changes to the domain\'s resource policy. </p>', 'DeleteRepositoryPermissionsPolicyRequest$policyRevision' => '<p> The revision of the repository\'s resource policy to be deleted. This revision is used for optimistic locking, which prevents others from accidentally overwriting your changes to the repository\'s resource policy. </p>', 'PutDomainPermissionsPolicyRequest$policyRevision' => '<p> The current revision of the resource policy to be set. This revision is used for optimistic locking, which prevents others from overwriting your changes to the domain\'s resource policy. </p>', 'PutRepositoryPermissionsPolicyRequest$policyRevision' => '<p> Sets the revision of the resource policy that specifies permissions to access the repository. This revision is used for optimistic locking, which prevents others from overwriting your changes to the repository\'s resource policy. </p>', 'ResourcePolicy$revision' => '<p> The current revision of the resource policy. </p>', ], ], 'PublishPackageVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'PublishPackageVersionResult' => [ 'base' => NULL, 'refs' => [], ], 'PutDomainPermissionsPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutDomainPermissionsPolicyResult' => [ 'base' => NULL, 'refs' => [], ], 'PutPackageOriginConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutPackageOriginConfigurationResult' => [ 'base' => NULL, 'refs' => [], ], 'PutRepositoryPermissionsPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutRepositoryPermissionsPolicyResult' => [ 'base' => NULL, 'refs' => [], ], 'RepositoryDescription' => [ 'base' => '<p> The details of a repository stored in CodeArtifact. A CodeArtifact repository contains a set of package versions, each of which maps to a set of assets. Repositories are polyglot—a single repository can contain packages of any supported type. Each repository exposes endpoints for fetching and publishing packages using tools like the <code>npm</code> CLI, the Maven CLI (<code>mvn</code>), and <code>pip</code>. You can create up to 100 repositories per Amazon Web Services account. </p>', 'refs' => [ 'AssociateExternalConnectionResult$repository' => '<p> Information about the connected repository after processing the request. </p>', 'CreateRepositoryResult$repository' => '<p> Information about the created repository after processing the request. </p>', 'DeleteRepositoryResult$repository' => '<p> Information about the deleted repository after processing the request. </p>', 'DescribeRepositoryResult$repository' => '<p> A <code>RepositoryDescription</code> object that contains the requested repository information. </p>', 'DisassociateExternalConnectionResult$repository' => '<p> The repository associated with the removed external connection. </p>', 'UpdateRepositoryResult$repository' => '<p> The updated repository. </p>', ], ], 'RepositoryExternalConnectionInfo' => [ 'base' => '<p> Contains information about the external connection of a repository. </p>', 'refs' => [ 'RepositoryExternalConnectionInfoList$member' => NULL, ], ], 'RepositoryExternalConnectionInfoList' => [ 'base' => NULL, 'refs' => [ 'RepositoryDescription$externalConnections' => '<p> An array of external connections associated with the repository. </p>', ], ], 'RepositoryName' => [ 'base' => NULL, 'refs' => [ 'AssociateExternalConnectionRequest$repository' => '<p> The name of the repository to which the external connection is added. </p>', 'CopyPackageVersionsRequest$sourceRepository' => '<p> The name of the repository that contains the package versions to be copied. </p>', 'CopyPackageVersionsRequest$destinationRepository' => '<p> The name of the repository into which package versions are copied. </p>', 'CreateRepositoryRequest$repository' => '<p>The name of the repository to create. </p>', 'DeletePackageRequest$repository' => '<p>The name of the repository that contains the package to delete.</p>', 'DeletePackageVersionsRequest$repository' => '<p> The name of the repository that contains the package versions to delete. </p>', 'DeleteRepositoryPermissionsPolicyRequest$repository' => '<p> The name of the repository that is associated with the resource policy to be deleted </p>', 'DeleteRepositoryRequest$repository' => '<p> The name of the repository to delete. </p>', 'DescribePackageRequest$repository' => '<p>The name of the repository that contains the requested package. </p>', 'DescribePackageVersionRequest$repository' => '<p> The name of the repository that contains the package version. </p>', 'DescribeRepositoryRequest$repository' => '<p> A string that specifies the name of the requested repository. </p>', 'DisassociateExternalConnectionRequest$repository' => '<p>The name of the repository from which the external connection will be removed. </p>', 'DisposePackageVersionsRequest$repository' => '<p> The name of the repository that contains the package versions you want to dispose. </p>', 'DomainEntryPoint$repositoryName' => '<p>The name of the repository that a package was originally published to.</p>', 'GetPackageVersionAssetRequest$repository' => '<p> The repository that contains the package version with the requested asset. </p>', 'GetPackageVersionReadmeRequest$repository' => '<p> The repository that contains the package with the requested readme file. </p>', 'GetRepositoryEndpointRequest$repository' => '<p> The name of the repository. </p>', 'GetRepositoryPermissionsPolicyRequest$repository' => '<p> The name of the repository whose associated resource policy is to be retrieved. </p>', 'ListPackageVersionAssetsRequest$repository' => '<p> The name of the repository that contains the package that contains the requested package version assets. </p>', 'ListPackageVersionDependenciesRequest$repository' => '<p> The name of the repository that contains the requested package version. </p>', 'ListPackageVersionsRequest$repository' => '<p> The name of the repository that contains the requested package versions. </p>', 'ListPackagesRequest$repository' => '<p> The name of the repository that contains the requested packages. </p>', 'ListRepositoriesInDomainRequest$repositoryPrefix' => '<p> A prefix used to filter returned repositories. Only repositories with names that start with <code>repositoryPrefix</code> are returned. </p>', 'ListRepositoriesRequest$repositoryPrefix' => '<p> A prefix used to filter returned repositories. Only repositories with names that start with <code>repositoryPrefix</code> are returned.</p>', 'PackageGroupAllowedRepository$repositoryName' => '<p> The name of the allowed repository. </p>', 'PublishPackageVersionRequest$repository' => '<p>The name of the repository that the package version will be published to.</p>', 'PutPackageOriginConfigurationRequest$repository' => '<p>The name of the repository that contains the package.</p>', 'PutRepositoryPermissionsPolicyRequest$repository' => '<p> The name of the repository to set the resource policy on. </p>', 'RepositoryDescription$name' => '<p> The name of the repository. </p>', 'RepositoryNameList$member' => NULL, 'RepositorySummary$name' => '<p> The name of the repository. </p>', 'UpdatePackageVersionsStatusRequest$repository' => '<p> The repository that contains the package versions with the status you want to update. </p>', 'UpdateRepositoryRequest$repository' => '<p> The name of the repository to update. </p>', 'UpstreamRepository$repositoryName' => '<p> The name of an upstream repository. </p>', 'UpstreamRepositoryInfo$repositoryName' => '<p> The name of an upstream repository. </p>', ], ], 'RepositoryNameList' => [ 'base' => NULL, 'refs' => [ 'ListAllowedRepositoriesForGroupResult$allowedRepositories' => '<p>The list of allowed repositories for the package group and origin configuration restriction type.</p>', 'PackageGroupAllowedRepositoryUpdate$value' => NULL, ], ], 'RepositorySummary' => [ 'base' => '<p> Details about a repository, including its Amazon Resource Name (ARN), description, and domain information. The <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListRepositories.html">ListRepositories</a> operation returns a list of <code>RepositorySummary</code> objects. </p>', 'refs' => [ 'RepositorySummaryList$member' => NULL, ], ], 'RepositorySummaryList' => [ 'base' => NULL, 'refs' => [ 'ListRepositoriesInDomainResult$repositories' => '<p> The returned list of repositories. </p>', 'ListRepositoriesResult$repositories' => '<p> The returned list of <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_RepositorySummary.html">RepositorySummary</a> objects. </p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p> The operation did not succeed because the resource requested is not found in the service. </p>', 'refs' => [], ], 'ResourcePolicy' => [ 'base' => '<p> An CodeArtifact resource policy that contains a resource ARN, document details, and a revision. </p>', 'refs' => [ 'DeleteDomainPermissionsPolicyResult$policy' => '<p> Information about the deleted resource policy after processing the request. </p>', 'DeleteRepositoryPermissionsPolicyResult$policy' => '<p> Information about the deleted policy after processing the request. </p>', 'GetDomainPermissionsPolicyResult$policy' => '<p> The returned resource policy. </p>', 'GetRepositoryPermissionsPolicyResult$policy' => '<p> The returned resource policy. </p>', 'PutDomainPermissionsPolicyResult$policy' => '<p> The resource policy that was set after processing the request. </p>', 'PutRepositoryPermissionsPolicyResult$policy' => '<p> The resource policy that was set after processing the request. </p>', ], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'ConflictException$resourceType' => '<p> The type of Amazon Web Services resource. </p>', 'ResourceNotFoundException$resourceType' => '<p> The type of Amazon Web Services resource. </p>', 'ServiceQuotaExceededException$resourceType' => '<p> The type of Amazon Web Services resource. </p>', ], ], 'RetryAfterSeconds' => [ 'base' => NULL, 'refs' => [ 'ThrottlingException$retryAfterSeconds' => '<p> The time period, in seconds, to wait before retrying the request. </p>', ], ], 'SHA256' => [ 'base' => NULL, 'refs' => [ 'PublishPackageVersionRequest$assetSHA256' => '<p>The SHA256 hash of the <code>assetContent</code> to publish. This value must be calculated by the caller and provided with the request (see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/using-generic.html#publishing-generic-packages">Publishing a generic package</a> in the <i>CodeArtifact User Guide</i>).</p> <p>This value is used as an integrity check to verify that the <code>assetContent</code> has not changed after it was originally sent.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p> The operation did not succeed because it would have exceeded a service limit for your account. </p>', 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'ConflictException$message' => NULL, 'ConflictException$resourceId' => '<p> The ID of the resource. </p>', 'DeletePackageGroupRequest$packageGroup' => '<p>The pattern of the package group to be deleted.</p>', 'GetAuthorizationTokenResult$authorizationToken' => '<p> The returned authentication token. </p>', 'GetPackageVersionReadmeResult$readme' => '<p> The text of the returned readme file. </p>', 'GetRepositoryEndpointResult$repositoryEndpoint' => '<p> A string that specifies the URL of the returned endpoint. </p>', 'InternalServerException$message' => NULL, 'LicenseInfo$name' => '<p> Name of the license. </p>', 'LicenseInfo$url' => '<p> The URL for license data. </p>', 'PackageDependency$dependencyType' => '<p> The type of a package dependency. The possible values depend on the package type.</p> <ul> <li> <p>npm: <code>regular</code>, <code>dev</code>, <code>peer</code>, <code>optional</code> </p> </li> <li> <p>maven: <code>optional</code>, <code>parent</code>, <code>compile</code>, <code>runtime</code>, <code>test</code>, <code>system</code>, <code>provided</code>.</p> <note> <p>Note that <code>parent</code> is not a regular Maven dependency type; instead this is extracted from the <code>&lt;parent&gt;</code> element if one is defined in the package version\'s POM file.</p> </note> </li> <li> <p>nuget: The <code>dependencyType</code> field is never set for NuGet packages.</p> </li> <li> <p>pypi: <code>Requires-Dist</code> </p> </li> </ul>', 'PackageDependency$versionRequirement' => '<p> The required version, or version range, of the package that this package depends on. The version format is specific to the package type. For example, the following are possible valid required versions: <code>1.2.3</code>, <code>^2.3.4</code>, or <code>4.x</code>. </p>', 'PackageVersionDescription$summary' => '<p> A summary of the package version. The summary is extracted from the package. The information in and detail level of the summary depends on the package version\'s format. </p>', 'PackageVersionDescription$homePage' => '<p> The homepage associated with the package. </p>', 'PackageVersionDescription$sourceCodeRepository' => '<p> The repository for the source code in the package version, or the source code used to build it. </p>', 'ResourceNotFoundException$message' => NULL, 'ResourceNotFoundException$resourceId' => '<p> The ID of the resource. </p>', 'ServiceQuotaExceededException$message' => NULL, 'ServiceQuotaExceededException$resourceId' => '<p> The ID of the resource. </p>', 'SuccessfulPackageVersionInfo$revision' => '<p> The revision of a package version. </p>', 'ThrottlingException$message' => NULL, 'ValidationException$message' => NULL, ], ], 'String255' => [ 'base' => NULL, 'refs' => [ 'PackageVersionDescription$displayName' => '<p> The name of the package that is displayed. The <code>displayName</code> varies depending on the package version\'s format. For example, if an npm package is named <code>ui</code>, is in the namespace <code>vue</code>, and has the format <code>npm</code>, then the <code>displayName</code> is <code>@vue/ui</code>. </p>', ], ], 'SuccessfulPackageVersionInfo' => [ 'base' => '<p> Contains the revision and status of a package version. </p>', 'refs' => [ 'SuccessfulPackageVersionInfoMap$value' => NULL, ], ], 'SuccessfulPackageVersionInfoMap' => [ 'base' => NULL, 'refs' => [ 'CopyPackageVersionsResult$successfulVersions' => '<p> A list of the package versions that were successfully copied to your repository. </p>', 'DeletePackageVersionsResult$successfulVersions' => '<p> A list of the package versions that were successfully deleted. The status of every successful version will be <code>Deleted</code>. </p>', 'DisposePackageVersionsResult$successfulVersions' => '<p> A list of the package versions that were successfully disposed. </p>', 'UpdatePackageVersionsStatusResult$successfulVersions' => '<p> A list of <code>PackageVersionError</code> objects, one for each package version with a status that failed to update. </p>', ], ], 'Tag' => [ 'base' => '<p>A tag is a key-value pair that can be used to manage, search for, or filter resources in CodeArtifact.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$key' => '<p>The tag key.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>The tag key for each tag that you want to remove from the resource.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateDomainRequest$tags' => '<p>One or more tag key-value pairs for the domain.</p>', 'CreatePackageGroupRequest$tags' => '<p>One or more tag key-value pairs for the package group.</p>', 'CreateRepositoryRequest$tags' => '<p>One or more tag key-value pairs for the repository.</p>', 'ListTagsForResourceResult$tags' => '<p>A list of tag key and value pairs associated with the specified resource.</p>', 'TagResourceRequest$tags' => '<p>The tags you want to modify or add to the resource.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResult' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$value' => '<p>The tag value.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p> The operation did not succeed because too many requests are sent to the service. </p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'DomainDescription$createdTime' => '<p> A timestamp that represents the date and time the domain was created. </p>', 'DomainSummary$createdTime' => '<p> A timestamp that contains the date and time the domain was created. </p>', 'GetAuthorizationTokenResult$expiration' => '<p> A timestamp that specifies the date and time the authorization token expires. </p>', 'PackageGroupDescription$createdTime' => '<p>A timestamp that represents the date and time the package group was created.</p>', 'PackageGroupSummary$createdTime' => '<p>A timestamp that represents the date and time the repository was created.</p>', 'PackageVersionDescription$publishedTime' => '<p> A timestamp that contains the date and time the package version was published. </p>', 'RepositoryDescription$createdTime' => '<p>A timestamp that represents the date and time the repository was created.</p>', 'RepositorySummary$createdTime' => '<p>A timestamp that represents the date and time the repository was created.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePackageGroupOriginConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePackageGroupOriginConfigurationResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePackageGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePackageGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePackageVersionsStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePackageVersionsStatusResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRepositoryRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRepositoryResult' => [ 'base' => NULL, 'refs' => [], ], 'UpstreamRepository' => [ 'base' => '<p> Information about an upstream repository. A list of <code>UpstreamRepository</code> objects is an input parameter to <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_CreateRepository.html">CreateRepository</a> and <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_UpdateRepository.html">UpdateRepository</a>. </p>', 'refs' => [ 'UpstreamRepositoryList$member' => NULL, ], ], 'UpstreamRepositoryInfo' => [ 'base' => '<p> Information about an upstream repository. </p>', 'refs' => [ 'UpstreamRepositoryInfoList$member' => NULL, ], ], 'UpstreamRepositoryInfoList' => [ 'base' => NULL, 'refs' => [ 'RepositoryDescription$upstreams' => '<p> A list of upstream repositories to associate with the repository. The order of the upstream repositories in the list determines their priority order when CodeArtifact looks for a requested package version. For more information, see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working with upstream repositories</a>. </p>', ], ], 'UpstreamRepositoryList' => [ 'base' => NULL, 'refs' => [ 'CreateRepositoryRequest$upstreams' => '<p> A list of upstream repositories to associate with the repository. The order of the upstream repositories in the list determines their priority order when CodeArtifact looks for a requested package version. For more information, see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working with upstream repositories</a>. </p>', 'UpdateRepositoryRequest$upstreams' => '<p> A list of upstream repositories to associate with the repository. The order of the upstream repositories in the list determines their priority order when CodeArtifact looks for a requested package version. For more information, see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working with upstream repositories</a>. </p>', ], ], 'ValidationException' => [ 'base' => '<p> The operation did not succeed because a parameter in the request was sent with an invalid value. </p>', 'refs' => [], ], 'ValidationExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ValidationException$reason' => '<p> </p>', ], ], ],];
