<?php
// This file was auto-generated from sdk-root/src/data/cognito-idp/2016-04-18/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>With the Amazon Cognito user pools API, you can configure user pools and authenticate users. To authenticate users from third-party identity providers (IdPs) in this API, you can <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-identity-federation-consolidate-users.html">link IdP users to native user profiles</a>. Learn more about the authentication and authorization of federated users at <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-identity-federation.html">Adding user pool sign-in through a third party</a> and in the <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-userpools-server-contract-reference.html">User pool federation endpoints and hosted UI reference</a>.</p> <p>This API reference provides detailed information about API operations and object types in Amazon Cognito.</p> <p>Along with resource management operations, the Amazon Cognito user pools API includes classes of operations and authorization models for client-side and server-side authentication of users. You can interact with operations in the Amazon Cognito user pools API as any of the following subjects.</p> <ol> <li> <p>An administrator who wants to configure user pools, app clients, users, groups, or other user pool functions.</p> </li> <li> <p>A server-side app, like a web application, that wants to use its Amazon Web Services privileges to manage, authenticate, or authorize a user.</p> </li> <li> <p>A client-side app, like a mobile app, that wants to make unauthenticated requests to manage, authenticate, or authorize a user.</p> </li> </ol> <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <p>With your Amazon Web Services SDK, you can build the logic to support operational flows in every use case for this API. You can also make direct REST API requests to <a href="https://docs.aws.amazon.com/general/latest/gr/cognito_identity.html#cognito_identity_your_user_pools_region">Amazon Cognito user pools service endpoints</a>. The following links can get you started with the <code>CognitoIdentityProvider</code> client in other supported Amazon Web Services SDKs.</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/cli/latest/reference/cognito-idp/index.html#cli-aws-cognito-idp">Amazon Web Services Command Line Interface</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/sdkfornet/v3/apidocs/items/CognitoIdentityProvider/TCognitoIdentityProviderClient.html">Amazon Web Services SDK for .NET</a> </p> </li> <li> <p> <a href="https://sdk.amazonaws.com/cpp/api/LATEST/aws-cpp-sdk-cognito-idp/html/class_aws_1_1_cognito_identity_provider_1_1_cognito_identity_provider_client.html">Amazon Web Services SDK for C++</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/sdk-for-go/api/service/cognitoidentityprovider/#CognitoIdentityProvider">Amazon Web Services SDK for Go</a> </p> </li> <li> <p> <a href="https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/services/cognitoidentityprovider/CognitoIdentityProviderClient.html">Amazon Web Services SDK for Java V2</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/CognitoIdentityServiceProvider.html">Amazon Web Services SDK for JavaScript</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/aws-sdk-php/v3/api/api-cognito-idp-2016-04-18.html">Amazon Web Services SDK for PHP V3</a> </p> </li> <li> <p> <a href="https://boto3.amazonaws.com/v1/documentation/api/latest/reference/services/cognito-idp.html">Amazon Web Services SDK for Python</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/sdk-for-ruby/v3/api/Aws/CognitoIdentityProvider/Client.html">Amazon Web Services SDK for Ruby V3</a> </p> </li> </ul> <p>To get started with an Amazon Web Services SDK, see <a href="http://aws.amazon.com/developer/tools/">Tools to Build on Amazon Web Services</a>. For example actions and scenarios, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/service_code_examples_cognito-identity-provider.html">Code examples for Amazon Cognito Identity Provider using Amazon Web Services SDKs</a>.</p>', 'operations' => [ 'AddCustomAttributes' => '<p>Adds additional user attributes to the user pool schema.</p> <note> <p>Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.</p> <p class="title"> <b>Learn more</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services API Requests</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a> </p> </li> </ul> </note>', 'AdminAddUserToGroup' => '<p>Adds a user to a group. A user who is in a group can present a preferred-role claim to an identity pool, and populates a <code>cognito:groups</code> claim to their access and identity tokens.</p> <note> <p>Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.</p> <p class="title"> <b>Learn more</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services API Requests</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a> </p> </li> </ul> </note>', 'AdminConfirmSignUp' => '<p>This IAM-authenticated API operation provides a code that Amazon Cognito sent to your user when they signed up in your user pool. After your user enters their code, they confirm ownership of the email address or phone number that they provided, and their user account becomes active. Depending on your user pool configuration, your users will receive their confirmation code in an email or SMS message.</p> <p>Local users who signed up in your user pool are the only type of user who can confirm sign-up with a code. Users who federate through an external identity provider (IdP) have already been confirmed by their IdP. Administrator-created users confirm their accounts when they respond to their invitation email message and choose a password.</p> <note> <p>Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.</p> <p class="title"> <b>Learn more</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services API Requests</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a> </p> </li> </ul> </note>', 'AdminCreateUser' => '<p>Creates a new user in the specified user pool.</p> <p>If <code>MessageAction</code> isn\'t set, the default is to send a welcome message via email or phone (SMS).</p> <note> <p>This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with <a href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.</p> <p>If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In <i> <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.</p> </note> <p>This message is based on a template that you configured in your call to create or update a user pool. This template includes your custom sign-up instructions and placeholders for user name and temporary password.</p> <p>Alternatively, you can call <code>AdminCreateUser</code> with <code>SUPPRESS</code> for the <code>MessageAction</code> parameter, and Amazon Cognito won\'t send any email. </p> <p>In either case, the user will be in the <code>FORCE_CHANGE_PASSWORD</code> state until they sign in and change their password.</p> <note> <p>Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.</p> <p class="title"> <b>Learn more</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services API Requests</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a> </p> </li> </ul> </note>', 'AdminDeleteUser' => '<p>Deletes a user as an administrator. Works on any user.</p> <note> <p>Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.</p> <p class="title"> <b>Learn more</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services API Requests</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a> </p> </li> </ul> </note>', 'AdminDeleteUserAttributes' => '<p>Deletes the user attributes in a user pool as an administrator. Works on any user.</p> <note> <p>Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.</p> <p class="title"> <b>Learn more</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services API Requests</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a> </p> </li> </ul> </note>', 'AdminDisableProviderForUser' => '<p>Prevents the user from signing in with the specified external (SAML or social) identity provider (IdP). If the user that you want to deactivate is a Amazon Cognito user pools native username + password user, they can\'t use their password to sign in. If the user to deactivate is a linked external IdP user, any link between that user and an existing user is removed. When the external user signs in again, and the user is no longer attached to the previously linked <code>DestinationUser</code>, the user must create a new user account. See <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminLinkProviderForUser.html">AdminLinkProviderForUser</a>.</p> <p>The <code>ProviderName</code> must match the value specified when creating an IdP for the pool. </p> <p>To deactivate a native username + password user, the <code>ProviderName</code> value must be <code>Cognito</code> and the <code>ProviderAttributeName</code> must be <code>Cognito_Subject</code>. The <code>ProviderAttributeValue</code> must be the name that is used in the user pool for the user.</p> <p>The <code>ProviderAttributeName</code> must always be <code>Cognito_Subject</code> for social IdPs. The <code>ProviderAttributeValue</code> must always be the exact subject that was used when the user was originally linked as a source user.</p> <p>For de-linking a SAML identity, there are two scenarios. If the linked identity has not yet been used to sign in, the <code>ProviderAttributeName</code> and <code>ProviderAttributeValue</code> must be the same values that were used for the <code>SourceUser</code> when the identities were originally linked using <code> AdminLinkProviderForUser</code> call. (If the linking was done with <code>ProviderAttributeName</code> set to <code>Cognito_Subject</code>, the same applies here). However, if the user has already signed in, the <code>ProviderAttributeName</code> must be <code>Cognito_Subject</code> and <code>ProviderAttributeValue</code> must be the subject of the SAML assertion.</p> <note> <p>Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.</p> <p class="title"> <b>Learn more</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services API Requests</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a> </p> </li> </ul> </note>', 'AdminDisableUser' => '<p>Deactivates a user and revokes all access tokens for the user. A deactivated user can\'t sign in, but still appears in the responses to <code>GetUser</code> and <code>ListUsers</code> API requests.</p> <note> <p>Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.</p> <p class="title"> <b>Learn more</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services API Requests</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a> </p> </li> </ul> </note>', 'AdminEnableUser' => '<p>Enables the specified user as an administrator. Works on any user.</p> <note> <p>Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.</p> <p class="title"> <b>Learn more</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services API Requests</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a> </p> </li> </ul> </note>', 'AdminForgetDevice' => '<p>Forgets the device, as an administrator.</p> <note> <p>Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.</p> <p class="title"> <b>Learn more</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services API Requests</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a> </p> </li> </ul> </note>', 'AdminGetDevice' => '<p>Gets the device, as an administrator.</p> <note> <p>Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.</p> <p class="title"> <b>Learn more</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services API Requests</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a> </p> </li> </ul> </note>', 'AdminGetUser' => '<p>Gets the specified user by user name in a user pool as an administrator. Works on any user.</p> <note> <p>Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.</p> <p class="title"> <b>Learn more</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services API Requests</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a> </p> </li> </ul> </note>', 'AdminInitiateAuth' => '<p>Initiates the authentication flow, as an administrator.</p> <note> <p>This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with <a href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.</p> <p>If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In <i> <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.</p> </note> <note> <p>Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.</p> <p class="title"> <b>Learn more</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services API Requests</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a> </p> </li> </ul> </note>', 'AdminLinkProviderForUser' => '<p>Links an existing user account in a user pool (<code>DestinationUser</code>) to an identity from an external IdP (<code>SourceUser</code>) based on a specified attribute name and value from the external IdP. This allows you to create a link from the existing user account to an external federated user identity that has not yet been used to sign in. You can then use the federated user identity to sign in as the existing user account. </p> <p> For example, if there is an existing user with a username and password, this API links that user to a federated user identity. When the user signs in with a federated user identity, they sign in as the existing user account.</p> <note> <p>The maximum number of federated identities linked to a user is five.</p> </note> <important> <p>Because this API allows a user with an external federated identity to sign in as an existing user in the user pool, it is critical that it only be used with external IdPs and provider attributes that have been trusted by the application owner.</p> </important> <note> <p>Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.</p> <p class="title"> <b>Learn more</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services API Requests</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a> </p> </li> </ul> </note>', 'AdminListDevices' => '<p>Lists devices, as an administrator.</p> <note> <p>Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.</p> <p class="title"> <b>Learn more</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services API Requests</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a> </p> </li> </ul> </note>', 'AdminListGroupsForUser' => '<p>Lists the groups that a user belongs to.</p> <note> <p>Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.</p> <p class="title"> <b>Learn more</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services API Requests</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a> </p> </li> </ul> </note>', 'AdminListUserAuthEvents' => '<p>A history of user activity and any risks detected as part of Amazon Cognito advanced security.</p> <note> <p>Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.</p> <p class="title"> <b>Learn more</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services API Requests</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a> </p> </li> </ul> </note>', 'AdminRemoveUserFromGroup' => '<p>Removes the specified user from the specified group.</p> <note> <p>Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.</p> <p class="title"> <b>Learn more</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services API Requests</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a> </p> </li> </ul> </note>', 'AdminResetUserPassword' => '<p>Resets the specified user\'s password in a user pool as an administrator. Works on any user.</p> <p>To use this API operation, your user pool must have self-service account recovery configured. Use <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminSetUserPassword.html">AdminSetUserPassword</a> if you manage passwords as an administrator.</p> <note> <p>This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with <a href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.</p> <p>If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In <i> <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.</p> </note> <p>Deactivates a user\'s password, requiring them to change it. If a user tries to sign in after the API is called, Amazon Cognito responds with a <code>PasswordResetRequiredException</code> error. Your app must then perform the actions that reset your user\'s password: the forgot-password flow. In addition, if the user pool has phone verification selected and a verified phone number exists for the user, or if email verification is selected and a verified email exists for the user, calling this API will also result in sending a message to the end user with the code to change their password.</p> <note> <p>Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.</p> <p class="title"> <b>Learn more</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services API Requests</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a> </p> </li> </ul> </note>', 'AdminRespondToAuthChallenge' => '<p>Some API operations in a user pool generate a challenge, like a prompt for an MFA code, for device authentication that bypasses MFA, or for a custom authentication challenge. An <code>AdminRespondToAuthChallenge</code> API request provides the answer to that challenge, like a code or a secure remote password (SRP). The parameters of a response to an authentication challenge vary with the type of challenge.</p> <p>For more information about custom authentication challenges, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-challenge.html">Custom authentication challenge Lambda triggers</a>.</p> <note> <p>This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with <a href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.</p> <p>If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In <i> <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.</p> </note> <note> <p>Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.</p> <p class="title"> <b>Learn more</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services API Requests</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a> </p> </li> </ul> </note>', 'AdminSetUserMFAPreference' => '<p>The user\'s multi-factor authentication (MFA) preference, including which MFA options are activated, and if any are preferred. Only one factor can be set as preferred. The preferred MFA factor will be used to authenticate a user if multiple factors are activated. If multiple options are activated and no preference is set, a challenge to choose an MFA option will be returned during sign-in.</p> <note> <p>Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.</p> <p class="title"> <b>Learn more</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services API Requests</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a> </p> </li> </ul> </note>', 'AdminSetUserPassword' => '<p>Sets the specified user\'s password in a user pool as an administrator. Works on any user. </p> <p>The password can be temporary or permanent. If it is temporary, the user status enters the <code>FORCE_CHANGE_PASSWORD</code> state. When the user next tries to sign in, the InitiateAuth/AdminInitiateAuth response will contain the <code>NEW_PASSWORD_REQUIRED</code> challenge. If the user doesn\'t sign in before it expires, the user won\'t be able to sign in, and an administrator must reset their password. </p> <p>Once the user has set a new password, or the password is permanent, the user status is set to <code>Confirmed</code>.</p> <p> <code>AdminSetUserPassword</code> can set a password for the user profile that Amazon Cognito creates for third-party federated users. When you set a password, the federated user\'s status changes from <code>EXTERNAL_PROVIDER</code> to <code>CONFIRMED</code>. A user in this state can sign in as a federated user, and initiate authentication flows in the API like a linked native user. They can also modify their password and attributes in token-authenticated API requests like <code>ChangePassword</code> and <code>UpdateUserAttributes</code>. As a best security practice and to keep users in sync with your external IdP, don\'t set passwords on federated user profiles. To set up a federated user for native sign-in with a linked native user, refer to <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-identity-federation-consolidate-users.html">Linking federated users to an existing user profile</a>.</p> <note> <p>Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.</p> <p class="title"> <b>Learn more</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services API Requests</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a> </p> </li> </ul> </note>', 'AdminSetUserSettings' => '<p> <i>This action is no longer supported.</i> You can use it to configure only SMS MFA. You can\'t use it to configure time-based one-time password (TOTP) software token MFA. To configure either type of MFA, use <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminSetUserMFAPreference.html">AdminSetUserMFAPreference</a> instead.</p> <note> <p>Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.</p> <p class="title"> <b>Learn more</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services API Requests</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a> </p> </li> </ul> </note>', 'AdminUpdateAuthEventFeedback' => '<p>Provides feedback for an authentication event indicating if it was from a valid user. This feedback is used for improving the risk evaluation decision for the user pool as part of Amazon Cognito advanced security.</p> <note> <p>Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.</p> <p class="title"> <b>Learn more</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services API Requests</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a> </p> </li> </ul> </note>', 'AdminUpdateDeviceStatus' => '<p>Updates the device status as an administrator.</p> <note> <p>Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.</p> <p class="title"> <b>Learn more</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services API Requests</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a> </p> </li> </ul> </note>', 'AdminUpdateUserAttributes' => '<note> <p>This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with <a href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.</p> <p>If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In <i> <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.</p> </note> <p>Updates the specified user\'s attributes, including developer attributes, as an administrator. Works on any user. To delete an attribute from your user, submit the attribute in your API request with a blank value.</p> <p>For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.</p> <p>In addition to updating user attributes, this API can also be used to mark phone and email as verified.</p> <note> <p>Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.</p> <p class="title"> <b>Learn more</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services API Requests</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a> </p> </li> </ul> </note>', 'AdminUserGlobalSignOut' => '<p>Invalidates the identity, access, and refresh tokens that Amazon Cognito issued to a user. Call this operation with your administrative credentials when your user signs out of your app. This results in the following behavior. </p> <ul> <li> <p>Amazon Cognito no longer accepts <i>token-authorized</i> user operations that you authorize with a signed-out user\'s access tokens. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a>.</p> <p>Amazon Cognito returns an <code>Access Token has been revoked</code> error when your app attempts to authorize a user pools API request with a revoked access token that contains the scope <code>aws.cognito.signin.user.admin</code>.</p> </li> <li> <p>Amazon Cognito no longer accepts a signed-out user\'s ID token in a <a href="https://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_GetId.html">GetId </a> request to an identity pool with <code>ServerSideTokenCheck</code> enabled for its user pool IdP configuration in <a href="https://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_CognitoIdentityProvider.html">CognitoIdentityProvider</a>.</p> </li> <li> <p>Amazon Cognito no longer accepts a signed-out user\'s refresh tokens in refresh requests.</p> </li> </ul> <p>Other requests might be valid until your user\'s token expires.</p> <note> <p>Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.</p> <p class="title"> <b>Learn more</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services API Requests</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a> </p> </li> </ul> </note>', 'AssociateSoftwareToken' => '<p>Begins setup of time-based one-time password (TOTP) multi-factor authentication (MFA) for a user, with a unique private key that Amazon Cognito generates and returns in the API response. You can authorize an <code>AssociateSoftwareToken</code> request with either the user\'s access token, or a session string from a challenge response that you received from Amazon Cognito.</p> <note> <p>Amazon Cognito disassociates an existing software token when you verify the new token in a <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerifySoftwareToken.html"> VerifySoftwareToken</a> API request. If you don\'t verify the software token and your user pool doesn\'t require MFA, the user can then authenticate with user name and password credentials alone. If your user pool requires TOTP MFA, Amazon Cognito generates an <code>MFA_SETUP</code> or <code>SOFTWARE_TOKEN_SETUP</code> challenge each time your user signs. Complete setup with <code>AssociateSoftwareToken</code> and <code>VerifySoftwareToken</code>.</p> <p>After you set up software token MFA for your user, Amazon Cognito generates a <code>SOFTWARE_TOKEN_MFA</code> challenge when they authenticate. Respond to this challenge with your user\'s TOTP.</p> </note> <note> <p>Amazon Cognito doesn\'t evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can\'t use IAM credentials to authorize requests, and you can\'t grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a>.</p> </note>', 'ChangePassword' => '<p>Changes the password for a specified user in a user pool.</p> <p>Authorize this action with a signed-in user\'s access token. It must include the scope <code>aws.cognito.signin.user.admin</code>.</p> <note> <p>Amazon Cognito doesn\'t evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can\'t use IAM credentials to authorize requests, and you can\'t grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a>.</p> </note>', 'ConfirmDevice' => '<p>Confirms tracking of the device. This API call is the call that begins device tracking. For more information about device authentication, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html">Working with user devices in your user pool</a>.</p> <p>Authorize this action with a signed-in user\'s access token. It must include the scope <code>aws.cognito.signin.user.admin</code>.</p> <note> <p>Amazon Cognito doesn\'t evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can\'t use IAM credentials to authorize requests, and you can\'t grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a>.</p> </note>', 'ConfirmForgotPassword' => '<p>Allows a user to enter a confirmation code to reset a forgotten password.</p> <note> <p>Amazon Cognito doesn\'t evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can\'t use IAM credentials to authorize requests, and you can\'t grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a>.</p> </note>', 'ConfirmSignUp' => '<p>This public API operation provides a code that Amazon Cognito sent to your user when they signed up in your user pool via the <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SignUp.html">SignUp</a> API operation. After your user enters their code, they confirm ownership of the email address or phone number that they provided, and their user account becomes active. Depending on your user pool configuration, your users will receive their confirmation code in an email or SMS message.</p> <p>Local users who signed up in your user pool are the only type of user who can confirm sign-up with a code. Users who federate through an external identity provider (IdP) have already been confirmed by their IdP. Administrator-created users, users created with the <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminCreateUser.html">AdminCreateUser</a> API operation, confirm their accounts when they respond to their invitation email message and choose a password. They do not receive a confirmation code. Instead, they receive a temporary password.</p> <note> <p>Amazon Cognito doesn\'t evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can\'t use IAM credentials to authorize requests, and you can\'t grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a>.</p> </note>', 'CreateGroup' => '<p>Creates a new group in the specified user pool.</p> <note> <p>Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.</p> <p class="title"> <b>Learn more</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services API Requests</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a> </p> </li> </ul> </note>', 'CreateIdentityProvider' => '<p>Adds a configuration and trust relationship between a third-party identity provider (IdP) and a user pool.</p> <note> <p>Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.</p> <p class="title"> <b>Learn more</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services API Requests</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a> </p> </li> </ul> </note>', 'CreateResourceServer' => '<p>Creates a new OAuth2.0 resource server and defines custom scopes within it.</p> <note> <p>Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.</p> <p class="title"> <b>Learn more</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services API Requests</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a> </p> </li> </ul> </note>', 'CreateUserImportJob' => '<p>Creates a user import job.</p> <note> <p>Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.</p> <p class="title"> <b>Learn more</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services API Requests</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a> </p> </li> </ul> </note>', 'CreateUserPool' => '<note> <p>This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with <a href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.</p> <p>If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In <i> <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.</p> </note> <p>Creates a new Amazon Cognito user pool and sets the password policy for the pool.</p> <important> <p>If you don\'t provide a value for an attribute, Amazon Cognito sets it to its default value.</p> </important> <note> <p>Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.</p> <p class="title"> <b>Learn more</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services API Requests</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a> </p> </li> </ul> </note>', 'CreateUserPoolClient' => '<p>Creates the user pool client.</p> <p>When you create a new user pool client, token revocation is automatically activated. For more information about revoking tokens, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html">RevokeToken</a>.</p> <important> <p>If you don\'t provide a value for an attribute, Amazon Cognito sets it to its default value.</p> </important> <note> <p>Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.</p> <p class="title"> <b>Learn more</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services API Requests</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a> </p> </li> </ul> </note>', 'CreateUserPoolDomain' => '<p>Creates a new domain for a user pool.</p> <note> <p>Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.</p> <p class="title"> <b>Learn more</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services API Requests</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a> </p> </li> </ul> </note>', 'DeleteGroup' => '<p>Deletes a group.</p> <p>Calling this action requires developer credentials.</p>', 'DeleteIdentityProvider' => '<p>Deletes an IdP for a user pool.</p>', 'DeleteResourceServer' => '<p>Deletes a resource server.</p>', 'DeleteUser' => '<p>Allows a user to delete their own user profile.</p> <p>Authorize this action with a signed-in user\'s access token. It must include the scope <code>aws.cognito.signin.user.admin</code>.</p> <note> <p>Amazon Cognito doesn\'t evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can\'t use IAM credentials to authorize requests, and you can\'t grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a>.</p> </note>', 'DeleteUserAttributes' => '<p>Deletes the attributes for a user.</p> <p>Authorize this action with a signed-in user\'s access token. It must include the scope <code>aws.cognito.signin.user.admin</code>.</p> <note> <p>Amazon Cognito doesn\'t evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can\'t use IAM credentials to authorize requests, and you can\'t grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a>.</p> </note>', 'DeleteUserPool' => '<p>Deletes the specified Amazon Cognito user pool.</p>', 'DeleteUserPoolClient' => '<p>Allows the developer to delete the user pool client.</p>', 'DeleteUserPoolDomain' => '<p>Deletes a domain for a user pool.</p>', 'DescribeIdentityProvider' => '<p>Gets information about a specific IdP.</p>', 'DescribeResourceServer' => '<p>Describes a resource server.</p>', 'DescribeRiskConfiguration' => '<p>Describes the risk configuration.</p>', 'DescribeUserImportJob' => '<p>Describes the user import job.</p>', 'DescribeUserPool' => '<p>Returns the configuration information and metadata of the specified user pool.</p> <note> <p>Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.</p> <p class="title"> <b>Learn more</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services API Requests</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a> </p> </li> </ul> </note>', 'DescribeUserPoolClient' => '<p>Client method for returning the configuration information and metadata of the specified user pool app client.</p> <note> <p>Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.</p> <p class="title"> <b>Learn more</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services API Requests</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a> </p> </li> </ul> </note>', 'DescribeUserPoolDomain' => '<p>Gets information about a domain.</p>', 'ForgetDevice' => '<p>Forgets the specified device. For more information about device authentication, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html">Working with user devices in your user pool</a>.</p> <p>Authorize this action with a signed-in user\'s access token. It must include the scope <code>aws.cognito.signin.user.admin</code>.</p> <note> <p>Amazon Cognito doesn\'t evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can\'t use IAM credentials to authorize requests, and you can\'t grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a>.</p> </note>', 'ForgotPassword' => '<p>Calling this API causes a message to be sent to the end user with a confirmation code that is required to change the user\'s password. For the <code>Username</code> parameter, you can use the username or user alias. The method used to send the confirmation code is sent according to the specified AccountRecoverySetting. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/how-to-recover-a-user-account.html">Recovering User Accounts</a> in the <i>Amazon Cognito Developer Guide</i>. To use the confirmation code for resetting the password, call <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ConfirmForgotPassword.html">ConfirmForgotPassword</a>. </p> <p>If neither a verified phone number nor a verified email exists, this API returns <code>InvalidParameterException</code>. If your app client has a client secret and you don\'t provide a <code>SECRET_HASH</code> parameter, this API returns <code>NotAuthorizedException</code>.</p> <p>To use this API operation, your user pool must have self-service account recovery configured. Use <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminSetUserPassword.html">AdminSetUserPassword</a> if you manage passwords as an administrator.</p> <note> <p>Amazon Cognito doesn\'t evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can\'t use IAM credentials to authorize requests, and you can\'t grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a>.</p> </note> <note> <p>This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with <a href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.</p> <p>If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In <i> <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.</p> </note>', 'GetCSVHeader' => '<p>Gets the header information for the comma-separated value (CSV) file to be used as input for the user import job.</p>', 'GetDevice' => '<p>Gets the device. For more information about device authentication, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html">Working with user devices in your user pool</a>.</p> <p>Authorize this action with a signed-in user\'s access token. It must include the scope <code>aws.cognito.signin.user.admin</code>.</p> <note> <p>Amazon Cognito doesn\'t evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can\'t use IAM credentials to authorize requests, and you can\'t grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a>.</p> </note>', 'GetGroup' => '<p>Gets a group.</p> <p>Calling this action requires developer credentials.</p>', 'GetIdentityProviderByIdentifier' => '<p>Gets the specified IdP.</p>', 'GetLogDeliveryConfiguration' => '<p>Gets the detailed activity logging configuration for a user pool.</p>', 'GetSigningCertificate' => '<p>This method takes a user pool ID, and returns the signing certificate. The issued certificate is valid for 10 years from the date of issue.</p> <p>Amazon Cognito issues and assigns a new signing certificate annually. This process returns a new value in the response to <code>GetSigningCertificate</code>, but doesn\'t invalidate the original certificate.</p>', 'GetUICustomization' => '<p>Gets the user interface (UI) Customization information for a particular app client\'s app UI, if any such information exists for the client. If nothing is set for the particular client, but there is an existing pool level customization (the app <code>clientId</code> is <code>ALL</code>), then that information is returned. If nothing is present, then an empty shape is returned.</p>', 'GetUser' => '<p>Gets the user attributes and metadata for a user.</p> <p>Authorize this action with a signed-in user\'s access token. It must include the scope <code>aws.cognito.signin.user.admin</code>.</p> <note> <p>Amazon Cognito doesn\'t evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can\'t use IAM credentials to authorize requests, and you can\'t grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a>.</p> </note>', 'GetUserAttributeVerificationCode' => '<p>Generates a user attribute verification code for the specified attribute name. Sends a message to a user with a code that they must return in a VerifyUserAttribute request.</p> <p>Authorize this action with a signed-in user\'s access token. It must include the scope <code>aws.cognito.signin.user.admin</code>.</p> <note> <p>Amazon Cognito doesn\'t evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can\'t use IAM credentials to authorize requests, and you can\'t grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a>.</p> </note> <note> <p>This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with <a href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.</p> <p>If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In <i> <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.</p> </note>', 'GetUserPoolMfaConfig' => '<p>Gets the user pool multi-factor authentication (MFA) configuration.</p>', 'GlobalSignOut' => '<p>Invalidates the identity, access, and refresh tokens that Amazon Cognito issued to a user. Call this operation when your user signs out of your app. This results in the following behavior. </p> <ul> <li> <p>Amazon Cognito no longer accepts <i>token-authorized</i> user operations that you authorize with a signed-out user\'s access tokens. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a>.</p> <p>Amazon Cognito returns an <code>Access Token has been revoked</code> error when your app attempts to authorize a user pools API request with a revoked access token that contains the scope <code>aws.cognito.signin.user.admin</code>.</p> </li> <li> <p>Amazon Cognito no longer accepts a signed-out user\'s ID token in a <a href="https://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_GetId.html">GetId </a> request to an identity pool with <code>ServerSideTokenCheck</code> enabled for its user pool IdP configuration in <a href="https://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_CognitoIdentityProvider.html">CognitoIdentityProvider</a>.</p> </li> <li> <p>Amazon Cognito no longer accepts a signed-out user\'s refresh tokens in refresh requests.</p> </li> </ul> <p>Other requests might be valid until your user\'s token expires.</p> <p>Authorize this action with a signed-in user\'s access token. It must include the scope <code>aws.cognito.signin.user.admin</code>.</p> <note> <p>Amazon Cognito doesn\'t evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can\'t use IAM credentials to authorize requests, and you can\'t grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a>.</p> </note>', 'InitiateAuth' => '<p>Initiates sign-in for a user in the Amazon Cognito user directory. You can\'t sign in a user with a federated IdP with <code>InitiateAuth</code>. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-identity-federation.html"> Adding user pool sign-in through a third party</a>.</p> <note> <p>Amazon Cognito doesn\'t evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can\'t use IAM credentials to authorize requests, and you can\'t grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a>.</p> </note> <note> <p>This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with <a href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.</p> <p>If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In <i> <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.</p> </note>', 'ListDevices' => '<p>Lists the sign-in devices that Amazon Cognito has registered to the current user. For more information about device authentication, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html">Working with user devices in your user pool</a>.</p> <p>Authorize this action with a signed-in user\'s access token. It must include the scope <code>aws.cognito.signin.user.admin</code>.</p> <note> <p>Amazon Cognito doesn\'t evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can\'t use IAM credentials to authorize requests, and you can\'t grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a>.</p> </note>', 'ListGroups' => '<p>Lists the groups associated with a user pool.</p> <note> <p>Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.</p> <p class="title"> <b>Learn more</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services API Requests</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a> </p> </li> </ul> </note>', 'ListIdentityProviders' => '<p>Lists information about all IdPs for a user pool.</p> <note> <p>Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.</p> <p class="title"> <b>Learn more</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services API Requests</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a> </p> </li> </ul> </note>', 'ListResourceServers' => '<p>Lists the resource servers for a user pool.</p> <note> <p>Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.</p> <p class="title"> <b>Learn more</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services API Requests</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a> </p> </li> </ul> </note>', 'ListTagsForResource' => '<p>Lists the tags that are assigned to an Amazon Cognito user pool.</p> <p>A tag is a label that you can apply to user pools to categorize and manage them in different ways, such as by purpose, owner, environment, or other criteria.</p> <p>You can use this action up to 10 times per second, per account.</p>', 'ListUserImportJobs' => '<p>Lists user import jobs for a user pool.</p> <note> <p>Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.</p> <p class="title"> <b>Learn more</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services API Requests</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a> </p> </li> </ul> </note>', 'ListUserPoolClients' => '<p>Lists the clients that have been created for the specified user pool.</p> <note> <p>Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.</p> <p class="title"> <b>Learn more</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services API Requests</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a> </p> </li> </ul> </note>', 'ListUserPools' => '<p>Lists the user pools associated with an Amazon Web Services account.</p> <note> <p>Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.</p> <p class="title"> <b>Learn more</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services API Requests</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a> </p> </li> </ul> </note>', 'ListUsers' => '<p>Lists users and their basic details in a user pool.</p> <note> <p>Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.</p> <p class="title"> <b>Learn more</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services API Requests</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a> </p> </li> </ul> </note>', 'ListUsersInGroup' => '<p>Lists the users in the specified group.</p> <note> <p>Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.</p> <p class="title"> <b>Learn more</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services API Requests</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a> </p> </li> </ul> </note>', 'ResendConfirmationCode' => '<p>Resends the confirmation (for confirmation of registration) to a specific user in the user pool.</p> <note> <p>Amazon Cognito doesn\'t evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can\'t use IAM credentials to authorize requests, and you can\'t grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a>.</p> </note> <note> <p>This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with <a href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.</p> <p>If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In <i> <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.</p> </note>', 'RespondToAuthChallenge' => '<p>Some API operations in a user pool generate a challenge, like a prompt for an MFA code, for device authentication that bypasses MFA, or for a custom authentication challenge. A <code>RespondToAuthChallenge</code> API request provides the answer to that challenge, like a code or a secure remote password (SRP). The parameters of a response to an authentication challenge vary with the type of challenge.</p> <p>For more information about custom authentication challenges, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-challenge.html">Custom authentication challenge Lambda triggers</a>.</p> <note> <p>Amazon Cognito doesn\'t evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can\'t use IAM credentials to authorize requests, and you can\'t grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a>.</p> </note> <note> <p>This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with <a href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.</p> <p>If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In <i> <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.</p> </note>', 'RevokeToken' => '<p>Revokes all of the access tokens generated by, and at the same time as, the specified refresh token. After a token is revoked, you can\'t use the revoked token to access Amazon Cognito user APIs, or to authorize access to your resource server.</p> <note> <p>Amazon Cognito doesn\'t evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can\'t use IAM credentials to authorize requests, and you can\'t grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a>.</p> </note>', 'SetLogDeliveryConfiguration' => '<p>Sets up or modifies the detailed activity logging configuration of a user pool.</p>', 'SetRiskConfiguration' => '<p>Configures actions on detected risks. To delete the risk configuration for <code>UserPoolId</code> or <code>ClientId</code>, pass null values for all four configuration types.</p> <p>To activate Amazon Cognito advanced security features, update the user pool to include the <code>UserPoolAddOns</code> key<code>AdvancedSecurityMode</code>.</p>', 'SetUICustomization' => '<p>Sets the user interface (UI) customization information for a user pool\'s built-in app UI.</p> <p>You can specify app UI customization settings for a single client (with a specific <code>clientId</code>) or for all clients (by setting the <code>clientId</code> to <code>ALL</code>). If you specify <code>ALL</code>, the default configuration is used for every client that has no previously set UI customization. If you specify UI customization settings for a particular client, it will no longer return to the <code>ALL</code> configuration.</p> <note> <p>To use this API, your user pool must have a domain associated with it. Otherwise, there is no place to host the app\'s pages, and the service will throw an error.</p> </note>', 'SetUserMFAPreference' => '<p>Set the user\'s multi-factor authentication (MFA) method preference, including which MFA factors are activated and if any are preferred. Only one factor can be set as preferred. The preferred MFA factor will be used to authenticate a user if multiple factors are activated. If multiple options are activated and no preference is set, a challenge to choose an MFA option will be returned during sign-in. If an MFA type is activated for a user, the user will be prompted for MFA during all sign-in attempts unless device tracking is turned on and the device has been trusted. If you want MFA to be applied selectively based on the assessed risk level of sign-in attempts, deactivate MFA for users and turn on Adaptive Authentication for the user pool.</p> <p>Authorize this action with a signed-in user\'s access token. It must include the scope <code>aws.cognito.signin.user.admin</code>.</p> <note> <p>Amazon Cognito doesn\'t evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can\'t use IAM credentials to authorize requests, and you can\'t grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a>.</p> </note>', 'SetUserPoolMfaConfig' => '<p>Sets the user pool multi-factor authentication (MFA) configuration.</p> <note> <p>This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with <a href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.</p> <p>If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In <i> <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.</p> </note>', 'SetUserSettings' => '<p> <i>This action is no longer supported.</i> You can use it to configure only SMS MFA. You can\'t use it to configure time-based one-time password (TOTP) software token MFA. To configure either type of MFA, use <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SetUserMFAPreference.html">SetUserMFAPreference</a> instead.</p> <p>Authorize this action with a signed-in user\'s access token. It must include the scope <code>aws.cognito.signin.user.admin</code>.</p> <note> <p>Amazon Cognito doesn\'t evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can\'t use IAM credentials to authorize requests, and you can\'t grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a>.</p> </note>', 'SignUp' => '<p>Registers the user in the specified user pool and creates a user name, password, and user attributes.</p> <note> <p>Amazon Cognito doesn\'t evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can\'t use IAM credentials to authorize requests, and you can\'t grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a>.</p> </note> <note> <p>This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with <a href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.</p> <p>If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In <i> <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.</p> </note>', 'StartUserImportJob' => '<p>Starts the user import.</p>', 'StopUserImportJob' => '<p>Stops the user import job.</p>', 'TagResource' => '<p>Assigns a set of tags to an Amazon Cognito user pool. A tag is a label that you can use to categorize and manage user pools in different ways, such as by purpose, owner, environment, or other criteria.</p> <p>Each tag consists of a key and value, both of which you define. A key is a general category for more specific values. For example, if you have two versions of a user pool, one for testing and another for production, you might assign an <code>Environment</code> tag key to both user pools. The value of this key might be <code>Test</code> for one user pool, and <code>Production</code> for the other.</p> <p>Tags are useful for cost tracking and access control. You can activate your tags so that they appear on the Billing and Cost Management console, where you can track the costs associated with your user pools. In an Identity and Access Management policy, you can constrain permissions for user pools based on specific tags or tag values.</p> <p>You can use this action up to 5 times per second, per account. A user pool can have as many as 50 tags.</p>', 'UntagResource' => '<p>Removes the specified tags from an Amazon Cognito user pool. You can use this action up to 5 times per second, per account.</p>', 'UpdateAuthEventFeedback' => '<p>Provides the feedback for an authentication event, whether it was from a valid user or not. This feedback is used for improving the risk evaluation decision for the user pool as part of Amazon Cognito advanced security.</p> <note> <p>Amazon Cognito doesn\'t evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can\'t use IAM credentials to authorize requests, and you can\'t grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a>.</p> </note>', 'UpdateDeviceStatus' => '<p>Updates the device status. For more information about device authentication, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html">Working with user devices in your user pool</a>.</p> <p>Authorize this action with a signed-in user\'s access token. It must include the scope <code>aws.cognito.signin.user.admin</code>.</p> <note> <p>Amazon Cognito doesn\'t evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can\'t use IAM credentials to authorize requests, and you can\'t grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a>.</p> </note>', 'UpdateGroup' => '<p>Updates the specified group with the specified attributes.</p> <note> <p>Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.</p> <p class="title"> <b>Learn more</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services API Requests</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a> </p> </li> </ul> </note>', 'UpdateIdentityProvider' => '<p>Updates IdP information for a user pool.</p> <note> <p>Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.</p> <p class="title"> <b>Learn more</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services API Requests</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a> </p> </li> </ul> </note>', 'UpdateResourceServer' => '<p>Updates the name and scopes of resource server. All other fields are read-only.</p> <important> <p>If you don\'t provide a value for an attribute, it is set to the default value.</p> </important> <note> <p>Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.</p> <p class="title"> <b>Learn more</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services API Requests</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a> </p> </li> </ul> </note>', 'UpdateUserAttributes' => '<p>With this operation, your users can update one or more of their attributes with their own credentials. You authorize this API request with the user\'s access token. To delete an attribute from your user, submit the attribute in your API request with a blank value. Custom attribute values in this request must include the <code>custom:</code> prefix.</p> <p>Authorize this action with a signed-in user\'s access token. It must include the scope <code>aws.cognito.signin.user.admin</code>.</p> <note> <p>Amazon Cognito doesn\'t evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can\'t use IAM credentials to authorize requests, and you can\'t grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a>.</p> </note> <note> <p>This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with <a href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.</p> <p>If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In <i> <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.</p> </note>', 'UpdateUserPool' => '<note> <p>This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with <a href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.</p> <p>If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In <i> <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.</p> </note> <p>Updates the specified user pool with the specified attributes. You can get a list of the current user pool settings using <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserPool.html">DescribeUserPool</a>.</p> <important> <p>If you don\'t provide a value for an attribute, Amazon Cognito sets it to its default value.</p> </important> <note> <p>Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.</p> <p class="title"> <b>Learn more</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services API Requests</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a> </p> </li> </ul> </note>', 'UpdateUserPoolClient' => '<p>Updates the specified user pool app client with the specified attributes. You can get a list of the current user pool app client settings using <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserPoolClient.html">DescribeUserPoolClient</a>.</p> <important> <p>If you don\'t provide a value for an attribute, Amazon Cognito sets it to its default value.</p> </important> <p>You can also use this operation to enable token revocation for user pool clients. For more information about revoking tokens, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html">RevokeToken</a>.</p> <note> <p>Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.</p> <p class="title"> <b>Learn more</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services API Requests</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a> </p> </li> </ul> </note>', 'UpdateUserPoolDomain' => '<p>Updates the Secure Sockets Layer (SSL) certificate for the custom domain for your user pool.</p> <p>You can use this operation to provide the Amazon Resource Name (ARN) of a new certificate to Amazon Cognito. You can\'t use it to change the domain for a user pool.</p> <p>A custom domain is used to host the Amazon Cognito hosted UI, which provides sign-up and sign-in pages for your application. When you set up a custom domain, you provide a certificate that you manage with Certificate Manager (ACM). When necessary, you can use this operation to change the certificate that you applied to your custom domain.</p> <p>Usually, this is unnecessary following routine certificate renewal with ACM. When you renew your existing certificate in ACM, the ARN for your certificate remains the same, and your custom domain uses the new certificate automatically.</p> <p>However, if you replace your existing certificate with a new one, ACM gives the new certificate a new ARN. To apply the new certificate to your custom domain, you must provide this ARN to Amazon Cognito.</p> <p>When you add your new certificate in ACM, you must choose US East (N. Virginia) as the Amazon Web Services Region.</p> <p>After you submit your request, Amazon Cognito requires up to 1 hour to distribute your new certificate to your custom domain.</p> <p>For more information about adding a custom domain to your user pool, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-add-custom-domain.html">Using Your Own Domain for the Hosted UI</a>.</p> <note> <p>Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.</p> <p class="title"> <b>Learn more</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services API Requests</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a> </p> </li> </ul> </note>', 'VerifySoftwareToken' => '<p>Use this API to register a user\'s entered time-based one-time password (TOTP) code and mark the user\'s software token MFA status as "verified" if successful. The request takes an access token or a session string, but not both.</p> <note> <p>Amazon Cognito doesn\'t evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can\'t use IAM credentials to authorize requests, and you can\'t grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a>.</p> </note>', 'VerifyUserAttribute' => '<p>Verifies the specified user attributes in the user pool.</p> <p> If your user pool requires verification before Amazon Cognito updates the attribute value, VerifyUserAttribute updates the affected attribute to its pending value. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UserAttributeUpdateSettingsType.html"> UserAttributeUpdateSettingsType</a>. </p> <p>Authorize this action with a signed-in user\'s access token. It must include the scope <code>aws.cognito.signin.user.admin</code>.</p> <note> <p>Amazon Cognito doesn\'t evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can\'t use IAM credentials to authorize requests, and you can\'t grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon Cognito user pools API and user pool endpoints</a>.</p> </note>', ], 'shapes' => [ 'AWSAccountIdType' => [ 'base' => NULL, 'refs' => [ 'DomainDescriptionType$AWSAccountId' => '<p>The Amazon Web Services ID for the user pool owner.</p>', ], ], 'AccessTokenValidityType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolClientRequest$AccessTokenValidity' => '<p>The access token time limit. After this limit expires, your user can\'t use their access token. To specify the time unit for <code>AccessTokenValidity</code> as <code>seconds</code>, <code>minutes</code>, <code>hours</code>, or <code>days</code>, set a <code>TokenValidityUnits</code> value in your API request.</p> <p>For example, when you set <code>AccessTokenValidity</code> to <code>10</code> and <code>TokenValidityUnits</code> to <code>hours</code>, your user can authorize access with their access token for 10 hours.</p> <p>The default time unit for <code>AccessTokenValidity</code> in an API request is hours. <i>Valid range</i> is displayed below in seconds.</p> <p>If you don\'t specify otherwise in the configuration of your app client, your access tokens are valid for one hour.</p>', 'UpdateUserPoolClientRequest$AccessTokenValidity' => '<p>The access token time limit. After this limit expires, your user can\'t use their access token. To specify the time unit for <code>AccessTokenValidity</code> as <code>seconds</code>, <code>minutes</code>, <code>hours</code>, or <code>days</code>, set a <code>TokenValidityUnits</code> value in your API request.</p> <p>For example, when you set <code>AccessTokenValidity</code> to <code>10</code> and <code>TokenValidityUnits</code> to <code>hours</code>, your user can authorize access with their access token for 10 hours.</p> <p>The default time unit for <code>AccessTokenValidity</code> in an API request is hours. <i>Valid range</i> is displayed below in seconds.</p> <p>If you don\'t specify otherwise in the configuration of your app client, your access tokens are valid for one hour.</p>', 'UserPoolClientType$AccessTokenValidity' => '<p>The access token time limit. After this limit expires, your user can\'t use their access token. To specify the time unit for <code>AccessTokenValidity</code> as <code>seconds</code>, <code>minutes</code>, <code>hours</code>, or <code>days</code>, set a <code>TokenValidityUnits</code> value in your API request.</p> <p>For example, when you set <code>AccessTokenValidity</code> to <code>10</code> and <code>TokenValidityUnits</code> to <code>hours</code>, your user can authorize access with their access token for 10 hours.</p> <p>The default time unit for <code>AccessTokenValidity</code> in an API request is hours. <i>Valid range</i> is displayed below in seconds.</p> <p>If you don\'t specify otherwise in the configuration of your app client, your access tokens are valid for one hour.</p>', ], ], 'AccountRecoverySettingType' => [ 'base' => '<p>The data type for <code>AccountRecoverySetting</code>.</p>', 'refs' => [ 'CreateUserPoolRequest$AccountRecoverySetting' => '<p>The available verified method a user can use to recover their password when they call <code>ForgotPassword</code>. You can use this setting to define a preferred method when a user has more than one method available. With this setting, SMS doesn\'t qualify for a valid password recovery mechanism if the user also has SMS multi-factor authentication (MFA) activated. In the absence of this setting, Amazon Cognito uses the legacy behavior to determine the recovery method where SMS is preferred through email.</p>', 'UpdateUserPoolRequest$AccountRecoverySetting' => '<p>The available verified method a user can use to recover their password when they call <code>ForgotPassword</code>. You can use this setting to define a preferred method when a user has more than one method available. With this setting, SMS doesn\'t qualify for a valid password recovery mechanism if the user also has SMS multi-factor authentication (MFA) activated. In the absence of this setting, Amazon Cognito uses the legacy behavior to determine the recovery method where SMS is preferred through email.</p>', 'UserPoolType$AccountRecoverySetting' => '<p>The available verified method a user can use to recover their password when they call <code>ForgotPassword</code>. You can use this setting to define a preferred method when a user has more than one method available. With this setting, SMS doesn\'t qualify for a valid password recovery mechanism if the user also has SMS multi-factor authentication (MFA) activated. In the absence of this setting, Amazon Cognito uses the legacy behavior to determine the recovery method where SMS is preferred through email.</p>', ], ], 'AccountTakeoverActionNotifyType' => [ 'base' => NULL, 'refs' => [ 'AccountTakeoverActionType$Notify' => '<p>Flag specifying whether to send a notification.</p>', ], ], 'AccountTakeoverActionType' => [ 'base' => '<p>Account takeover action type.</p>', 'refs' => [ 'AccountTakeoverActionsType$LowAction' => '<p>Action to take for a low risk.</p>', 'AccountTakeoverActionsType$MediumAction' => '<p>Action to take for a medium risk.</p>', 'AccountTakeoverActionsType$HighAction' => '<p>Action to take for a high risk.</p>', ], ], 'AccountTakeoverActionsType' => [ 'base' => '<p>Account takeover actions type.</p>', 'refs' => [ 'AccountTakeoverRiskConfigurationType$Actions' => '<p>Account takeover risk configuration actions.</p>', ], ], 'AccountTakeoverEventActionType' => [ 'base' => NULL, 'refs' => [ 'AccountTakeoverActionType$EventAction' => '<p>The action to take in response to the account takeover action. Valid values are as follows:</p> <ul> <li> <p> <code>BLOCK</code> Choosing this action will block the request.</p> </li> <li> <p> <code>MFA_IF_CONFIGURED</code> Present an MFA challenge if user has configured it, else allow the request.</p> </li> <li> <p> <code>MFA_REQUIRED</code> Present an MFA challenge if user has configured it, else block the request.</p> </li> <li> <p> <code>NO_ACTION</code> Allow the user to sign in.</p> </li> </ul>', ], ], 'AccountTakeoverRiskConfigurationType' => [ 'base' => '<p>Configuration for mitigation actions and notification for different levels of risk detected for a potential account takeover.</p>', 'refs' => [ 'RiskConfigurationType$AccountTakeoverRiskConfiguration' => '<p>The account takeover risk configuration object, including the <code>NotifyConfiguration</code> object and <code>Actions</code> to take if there is an account takeover.</p>', 'SetRiskConfigurationRequest$AccountTakeoverRiskConfiguration' => '<p>The account takeover risk configuration.</p>', ], ], 'AddCustomAttributesRequest' => [ 'base' => '<p>Represents the request to add custom attributes.</p>', 'refs' => [], ], 'AddCustomAttributesResponse' => [ 'base' => '<p>Represents the response from the server for the request to add custom attributes.</p>', 'refs' => [], ], 'AdminAddUserToGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'AdminConfirmSignUpRequest' => [ 'base' => '<p>Confirm a user\'s registration as a user pool administrator.</p>', 'refs' => [], ], 'AdminConfirmSignUpResponse' => [ 'base' => '<p>Represents the response from the server for the request to confirm registration.</p>', 'refs' => [], ], 'AdminCreateUserConfigType' => [ 'base' => '<p>The configuration for creating a new user profile.</p>', 'refs' => [ 'CreateUserPoolRequest$AdminCreateUserConfig' => '<p>The configuration for <code>AdminCreateUser</code> requests.</p>', 'UpdateUserPoolRequest$AdminCreateUserConfig' => '<p>The configuration for <code>AdminCreateUser</code> requests.</p>', 'UserPoolType$AdminCreateUserConfig' => '<p>The configuration for <code>AdminCreateUser</code> requests.</p>', ], ], 'AdminCreateUserRequest' => [ 'base' => '<p>Represents the request to create a user in the specified user pool.</p>', 'refs' => [], ], 'AdminCreateUserResponse' => [ 'base' => '<p>Represents the response from the server to the request to create the user.</p>', 'refs' => [], ], 'AdminCreateUserUnusedAccountValidityDaysType' => [ 'base' => NULL, 'refs' => [ 'AdminCreateUserConfigType$UnusedAccountValidityDays' => '<p>The user account expiration limit, in days, after which a new account that hasn\'t signed in is no longer usable. To reset the account after that time limit, you must call <code>AdminCreateUser</code> again, specifying <code>"RESEND"</code> for the <code>MessageAction</code> parameter. The default value for this parameter is 7.</p> <note> <p>If you set a value for <code>TemporaryPasswordValidityDays</code> in <code>PasswordPolicy</code>, that value will be used, and <code>UnusedAccountValidityDays</code> will be no longer be an available parameter for that user pool.</p> </note>', ], ], 'AdminDeleteUserAttributesRequest' => [ 'base' => '<p>Represents the request to delete user attributes as an administrator.</p>', 'refs' => [], ], 'AdminDeleteUserAttributesResponse' => [ 'base' => '<p>Represents the response received from the server for a request to delete user attributes.</p>', 'refs' => [], ], 'AdminDeleteUserRequest' => [ 'base' => '<p>Represents the request to delete a user as an administrator.</p>', 'refs' => [], ], 'AdminDisableProviderForUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'AdminDisableProviderForUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'AdminDisableUserRequest' => [ 'base' => '<p>Represents the request to disable the user as an administrator.</p>', 'refs' => [], ], 'AdminDisableUserResponse' => [ 'base' => '<p>Represents the response received from the server to disable the user as an administrator.</p>', 'refs' => [], ], 'AdminEnableUserRequest' => [ 'base' => '<p>Represents the request that enables the user as an administrator.</p>', 'refs' => [], ], 'AdminEnableUserResponse' => [ 'base' => '<p>Represents the response from the server for the request to enable a user as an administrator.</p>', 'refs' => [], ], 'AdminForgetDeviceRequest' => [ 'base' => '<p>Sends the forgot device request, as an administrator.</p>', 'refs' => [], ], 'AdminGetDeviceRequest' => [ 'base' => '<p>Represents the request to get the device, as an administrator.</p>', 'refs' => [], ], 'AdminGetDeviceResponse' => [ 'base' => '<p>Gets the device response, as an administrator.</p>', 'refs' => [], ], 'AdminGetUserRequest' => [ 'base' => '<p>Represents the request to get the specified user as an administrator.</p>', 'refs' => [], ], 'AdminGetUserResponse' => [ 'base' => '<p>Represents the response from the server from the request to get the specified user as an administrator.</p>', 'refs' => [], ], 'AdminInitiateAuthRequest' => [ 'base' => '<p>Initiates the authorization request, as an administrator.</p>', 'refs' => [], ], 'AdminInitiateAuthResponse' => [ 'base' => '<p>Initiates the authentication response, as an administrator.</p>', 'refs' => [], ], 'AdminLinkProviderForUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'AdminLinkProviderForUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'AdminListDevicesRequest' => [ 'base' => '<p>Represents the request to list devices, as an administrator.</p>', 'refs' => [], ], 'AdminListDevicesResponse' => [ 'base' => '<p>Lists the device\'s response, as an administrator.</p>', 'refs' => [], ], 'AdminListGroupsForUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'AdminListGroupsForUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'AdminListUserAuthEventsRequest' => [ 'base' => NULL, 'refs' => [], ], 'AdminListUserAuthEventsResponse' => [ 'base' => NULL, 'refs' => [], ], 'AdminRemoveUserFromGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'AdminResetUserPasswordRequest' => [ 'base' => '<p>Represents the request to reset a user\'s password as an administrator.</p>', 'refs' => [], ], 'AdminResetUserPasswordResponse' => [ 'base' => '<p>Represents the response from the server to reset a user password as an administrator.</p>', 'refs' => [], ], 'AdminRespondToAuthChallengeRequest' => [ 'base' => '<p>The request to respond to the authentication challenge, as an administrator.</p>', 'refs' => [], ], 'AdminRespondToAuthChallengeResponse' => [ 'base' => '<p>Responds to the authentication challenge, as an administrator.</p>', 'refs' => [], ], 'AdminSetUserMFAPreferenceRequest' => [ 'base' => NULL, 'refs' => [], ], 'AdminSetUserMFAPreferenceResponse' => [ 'base' => NULL, 'refs' => [], ], 'AdminSetUserPasswordRequest' => [ 'base' => NULL, 'refs' => [], ], 'AdminSetUserPasswordResponse' => [ 'base' => NULL, 'refs' => [], ], 'AdminSetUserSettingsRequest' => [ 'base' => '<p>You can use this parameter to set an MFA configuration that uses the SMS delivery medium.</p>', 'refs' => [], ], 'AdminSetUserSettingsResponse' => [ 'base' => '<p>Represents the response from the server to set user settings as an administrator.</p>', 'refs' => [], ], 'AdminUpdateAuthEventFeedbackRequest' => [ 'base' => NULL, 'refs' => [], ], 'AdminUpdateAuthEventFeedbackResponse' => [ 'base' => NULL, 'refs' => [], ], 'AdminUpdateDeviceStatusRequest' => [ 'base' => '<p>The request to update the device status, as an administrator.</p>', 'refs' => [], ], 'AdminUpdateDeviceStatusResponse' => [ 'base' => '<p>The status response to the request to update the device, as an administrator.</p>', 'refs' => [], ], 'AdminUpdateUserAttributesRequest' => [ 'base' => '<p>Represents the request to update the user\'s attributes as an administrator.</p>', 'refs' => [], ], 'AdminUpdateUserAttributesResponse' => [ 'base' => '<p>Represents the response from the server for the request to update user attributes as an administrator.</p>', 'refs' => [], ], 'AdminUserGlobalSignOutRequest' => [ 'base' => '<p>The request to sign out of all devices, as an administrator.</p>', 'refs' => [], ], 'AdminUserGlobalSignOutResponse' => [ 'base' => '<p>The global sign-out response, as an administrator.</p>', 'refs' => [], ], 'AdvancedSecurityModeType' => [ 'base' => NULL, 'refs' => [ 'UserPoolAddOnsType$AdvancedSecurityMode' => '<p>The operating mode of advanced security features in your user pool.</p>', ], ], 'AliasAttributeType' => [ 'base' => NULL, 'refs' => [ 'AliasAttributesListType$member' => NULL, ], ], 'AliasAttributesListType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolRequest$AliasAttributes' => '<p>Attributes supported as an alias for this user pool. Possible values: <b>phone_number</b>, <b>email</b>, or <b>preferred_username</b>.</p>', 'UserPoolType$AliasAttributes' => '<p>The attributes that are aliased in a user pool.</p>', ], ], 'AliasExistsException' => [ 'base' => '<p>This exception is thrown when a user tries to confirm the account with an email address or phone number that has already been supplied as an alias for a different user profile. This exception indicates that an account with this email address or phone already exists in a user pool that you\'ve configured to use email address or phone number as a sign-in alias.</p>', 'refs' => [], ], 'AnalyticsConfigurationType' => [ 'base' => '<p>The Amazon Pinpoint analytics configuration necessary to collect metrics for a user pool.</p> <note> <p>In Regions where Amazon Pinpoint isn\'t available, user pools only support sending events to Amazon Pinpoint projects in us-east-1. In Regions where Amazon Pinpoint is available, user pools support sending events to Amazon Pinpoint projects within that same Region.</p> </note>', 'refs' => [ 'CreateUserPoolClientRequest$AnalyticsConfiguration' => '<p>The user pool analytics configuration for collecting metrics and sending them to your Amazon Pinpoint campaign.</p> <note> <p>In Amazon Web Services Regions where Amazon Pinpoint isn\'t available, user pools only support sending events to Amazon Pinpoint projects in Amazon Web Services Region us-east-1. In Regions where Amazon Pinpoint is available, user pools support sending events to Amazon Pinpoint projects within that same Region.</p> </note>', 'UpdateUserPoolClientRequest$AnalyticsConfiguration' => '<p>The Amazon Pinpoint analytics configuration necessary to collect metrics for this user pool.</p> <note> <p>In Amazon Web Services Regions where Amazon Pinpoint isn\'t available, user pools only support sending events to Amazon Pinpoint projects in us-east-1. In Regions where Amazon Pinpoint is available, user pools support sending events to Amazon Pinpoint projects within that same Region.</p> </note>', 'UserPoolClientType$AnalyticsConfiguration' => '<p>The Amazon Pinpoint analytics configuration for the user pool client.</p> <note> <p>Amazon Cognito user pools only support sending events to Amazon Pinpoint projects in the US East (N. Virginia) us-east-1 Region, regardless of the Region where the user pool resides.</p> </note>', ], ], 'AnalyticsMetadataType' => [ 'base' => '<p>An Amazon Pinpoint analytics endpoint.</p> <p>An endpoint uniquely identifies a mobile device, email address, or phone number that can receive messages from Amazon Pinpoint analytics. For more information about Amazon Web Services Regions that can contain Amazon Pinpoint resources for use with Amazon Cognito user pools, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-pinpoint-integration.html">Using Amazon Pinpoint analytics with Amazon Cognito user pools</a>.</p>', 'refs' => [ 'AdminInitiateAuthRequest$AnalyticsMetadata' => '<p>The analytics metadata for collecting Amazon Pinpoint metrics for <code>AdminInitiateAuth</code> calls.</p>', 'AdminRespondToAuthChallengeRequest$AnalyticsMetadata' => '<p>The analytics metadata for collecting Amazon Pinpoint metrics for <code>AdminRespondToAuthChallenge</code> calls.</p>', 'ConfirmForgotPasswordRequest$AnalyticsMetadata' => '<p>The Amazon Pinpoint analytics metadata for collecting metrics for <code>ConfirmForgotPassword</code> calls.</p>', 'ConfirmSignUpRequest$AnalyticsMetadata' => '<p>The Amazon Pinpoint analytics metadata for collecting metrics for <code>ConfirmSignUp</code> calls.</p>', 'ForgotPasswordRequest$AnalyticsMetadata' => '<p>The Amazon Pinpoint analytics metadata that contributes to your metrics for <code>ForgotPassword</code> calls.</p>', 'InitiateAuthRequest$AnalyticsMetadata' => '<p>The Amazon Pinpoint analytics metadata that contributes to your metrics for <code>InitiateAuth</code> calls.</p>', 'ResendConfirmationCodeRequest$AnalyticsMetadata' => '<p>The Amazon Pinpoint analytics metadata that contributes to your metrics for <code>ResendConfirmationCode</code> calls.</p>', 'RespondToAuthChallengeRequest$AnalyticsMetadata' => '<p>The Amazon Pinpoint analytics metadata that contributes to your metrics for <code>RespondToAuthChallenge</code> calls.</p>', 'SignUpRequest$AnalyticsMetadata' => '<p>The Amazon Pinpoint analytics metadata that contributes to your metrics for <code>SignUp</code> calls.</p>', ], ], 'ArnType' => [ 'base' => NULL, 'refs' => [ 'AnalyticsConfigurationType$ApplicationArn' => '<p>The Amazon Resource Name (ARN) of an Amazon Pinpoint project. You can use the Amazon Pinpoint project to integrate with the chosen user pool Client. Amazon Cognito publishes events to the Amazon Pinpoint project that the app ARN declares.</p>', 'AnalyticsConfigurationType$RoleArn' => '<p>The ARN of an Identity and Access Management role that authorizes Amazon Cognito to publish events to Amazon Pinpoint analytics.</p>', 'CloudWatchLogsConfigurationType$LogGroupArn' => '<p>The Amazon Resource Name (arn) of a CloudWatch Logs log group where your user pool sends logs. The log group must not be encrypted with Key Management Service and must be in the same Amazon Web Services account as your user pool.</p> <p>To send logs to log groups with a resource policy of a size greater than 5120 characters, configure a log group with a path that starts with <code>/aws/vendedlogs</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AWS-logs-and-resource-policy.html">Enabling logging from certain Amazon Web Services services</a>.</p>', 'CreateGroupRequest$RoleArn' => '<p>The role Amazon Resource Name (ARN) for the group.</p>', 'CreateUserImportJobRequest$CloudWatchLogsRoleArn' => '<p>The role ARN for the Amazon CloudWatch Logs Logging role for the user import job.</p>', 'CustomDomainConfigType$CertificateArn' => '<p>The Amazon Resource Name (ARN) of an Certificate Manager SSL certificate. You use this certificate for the subdomain of your custom domain.</p>', 'CustomEmailLambdaVersionConfigType$LambdaArn' => '<p>The Amazon Resource Name (ARN) of the function that you want to assign to your Lambda trigger.</p>', 'CustomSMSLambdaVersionConfigType$LambdaArn' => '<p>The Amazon Resource Name (ARN) of the function that you want to assign to your Lambda trigger.</p>', 'EmailConfigurationType$SourceArn' => '<p>The ARN of a verified email address or an address from a verified domain in Amazon SES. You can set a <code>SourceArn</code> email from a verified domain only with an API request. You can set a verified email address, but not an address in a verified domain, in the Amazon Cognito console. Amazon Cognito uses the email address that you provide in one of the following ways, depending on the value that you specify for the <code>EmailSendingAccount</code> parameter:</p> <ul> <li> <p>If you specify <code>COGNITO_DEFAULT</code>, Amazon Cognito uses this address as the custom FROM address when it emails your users using its built-in email account.</p> </li> <li> <p>If you specify <code>DEVELOPER</code>, Amazon Cognito emails your users with this address by calling Amazon SES on your behalf.</p> </li> </ul> <p>The Region value of the <code>SourceArn</code> parameter must indicate a supported Amazon Web Services Region of your user pool. Typically, the Region in the <code>SourceArn</code> and the user pool Region are the same. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-email.html#user-pool-email-developer-region-mapping">Amazon SES email configuration regions</a> in the <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html">Amazon Cognito Developer Guide</a>.</p>', 'GroupType$RoleArn' => '<p>The role Amazon Resource Name (ARN) for the group.</p>', 'LambdaConfigType$PreSignUp' => '<p>A pre-registration Lambda trigger.</p>', 'LambdaConfigType$CustomMessage' => '<p>A custom Message Lambda trigger.</p>', 'LambdaConfigType$PostConfirmation' => '<p>A post-confirmation Lambda trigger.</p>', 'LambdaConfigType$PreAuthentication' => '<p>A pre-authentication Lambda trigger.</p>', 'LambdaConfigType$PostAuthentication' => '<p>A post-authentication Lambda trigger.</p>', 'LambdaConfigType$DefineAuthChallenge' => '<p>Defines the authentication challenge.</p>', 'LambdaConfigType$CreateAuthChallenge' => '<p>Creates an authentication challenge.</p>', 'LambdaConfigType$VerifyAuthChallengeResponse' => '<p>Verifies the authentication challenge response.</p>', 'LambdaConfigType$PreTokenGeneration' => '<p>The Amazon Resource Name (ARN) of the function that you want to assign to your Lambda trigger.</p> <p>Set this parameter for legacy purposes. If you also set an ARN in <code>PreTokenGenerationConfig</code>, its value must be identical to <code>PreTokenGeneration</code>. For new instances of pre token generation triggers, set the <code>LambdaArn</code> of <code>PreTokenGenerationConfig</code>.</p> <p>You can set <code/> </p>', 'LambdaConfigType$UserMigration' => '<p>The user migration Lambda config type.</p>', 'LambdaConfigType$KMSKeyID' => '<p>The Amazon Resource Name (ARN) of an <a href="/kms/latest/developerguide/concepts.html#master_keys">KMS key</a>. Amazon Cognito uses the key to encrypt codes and temporary passwords sent to <code>CustomEmailSender</code> and <code>CustomSMSSender</code>.</p>', 'ListTagsForResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the user pool that the tags are assigned to.</p>', 'NotifyConfigurationType$SourceArn' => '<p>The Amazon Resource Name (ARN) of the identity that is associated with the sending authorization policy. This identity permits Amazon Cognito to send for the email address specified in the <code>From</code> parameter.</p>', 'PreTokenGenerationVersionConfigType$LambdaArn' => '<p>The Amazon Resource Name (ARN) of the function that you want to assign to your Lambda trigger.</p> <p>This parameter and the <code>PreTokenGeneration</code> property of <code>LambdaConfig</code> have the same value. For new instances of pre token generation triggers, set <code>LambdaArn</code>.</p>', 'SmsConfigurationType$SnsCallerArn' => '<p>The Amazon Resource Name (ARN) of the Amazon SNS caller. This is the ARN of the IAM role in your Amazon Web Services account that Amazon Cognito will use to send SMS messages. SMS messages are subject to a <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html">spending limit</a>. </p>', 'TagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the user pool to assign the tags to.</p>', 'UntagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the user pool that the tags are assigned to.</p>', 'UpdateGroupRequest$RoleArn' => '<p>The new role Amazon Resource Name (ARN) for the group. This is used for setting the <code>cognito:roles</code> and <code>cognito:preferred_role</code> claims in the token.</p>', 'UserImportJobType$CloudWatchLogsRoleArn' => '<p>The role Amazon Resource Name (ARN) for the Amazon CloudWatch Logging role for the user import job. For more information, see "Creating the CloudWatch Logs IAM Role" in the Amazon Cognito Developer Guide.</p>', 'UserPoolType$Arn' => '<p>The Amazon Resource Name (ARN) for the user pool.</p>', ], ], 'AssociateSoftwareTokenRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateSoftwareTokenResponse' => [ 'base' => NULL, 'refs' => [], ], 'AttributeDataType' => [ 'base' => NULL, 'refs' => [ 'SchemaAttributeType$AttributeDataType' => '<p>The data format of the values for your attribute. When you choose an <code>AttributeDataType</code>, Amazon Cognito validates the input against the data type. A custom attribute value in your user\'s ID token is always a string, for example <code>"custom:isMember" : "true"</code> or <code>"custom:YearsAsMember" : "12"</code>. </p>', ], ], 'AttributeListType' => [ 'base' => NULL, 'refs' => [ 'AdminCreateUserRequest$UserAttributes' => '<p>An array of name-value pairs that contain user attributes and attribute values to be set for the user to be created. You can create a user without specifying any attributes other than <code>Username</code>. However, any attributes that you specify as required (when creating a user pool or in the <b>Attributes</b> tab of the console) either you should supply (in your call to <code>AdminCreateUser</code>) or the user should supply (when they sign up in response to your welcome message).</p> <p>For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.</p> <p>To send a message inviting the user to sign up, you must specify the user\'s email address or phone number. You can do this in your call to AdminCreateUser or in the <b>Users</b> tab of the Amazon Cognito console for managing your user pools.</p> <p>In your call to <code>AdminCreateUser</code>, you can set the <code>email_verified</code> attribute to <code>True</code>, and you can set the <code>phone_number_verified</code> attribute to <code>True</code>. You can also do this by calling <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminUpdateUserAttributes.html">AdminUpdateUserAttributes</a>.</p> <ul> <li> <p> <b>email</b>: The email address of the user to whom the message that contains the code and username will be sent. Required if the <code>email_verified</code> attribute is set to <code>True</code>, or if <code>"EMAIL"</code> is specified in the <code>DesiredDeliveryMediums</code> parameter.</p> </li> <li> <p> <b>phone_number</b>: The phone number of the user to whom the message that contains the code and username will be sent. Required if the <code>phone_number_verified</code> attribute is set to <code>True</code>, or if <code>"SMS"</code> is specified in the <code>DesiredDeliveryMediums</code> parameter.</p> </li> </ul>', 'AdminCreateUserRequest$ValidationData' => '<p>Temporary user attributes that contribute to the outcomes of your pre sign-up Lambda trigger. This set of key-value pairs are for custom validation of information that you collect from your users but don\'t need to retain.</p> <p>Your Lambda function can analyze this additional data and act on it. Your function might perform external API operations like logging user attributes and validation data to Amazon CloudWatch Logs. Validation data might also affect the response that your function returns to Amazon Cognito, like automatically confirming the user if they sign up from within your network.</p> <p>For more information about the pre sign-up Lambda trigger, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-pre-sign-up.html">Pre sign-up Lambda trigger</a>.</p>', 'AdminGetUserResponse$UserAttributes' => '<p>An array of name-value pairs representing user attributes.</p>', 'AdminUpdateUserAttributesRequest$UserAttributes' => '<p>An array of name-value pairs representing user attributes.</p> <p>For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.</p> <p>If your user pool requires verification before Amazon Cognito updates an attribute value that you specify in this request, Amazon Cognito doesn’t immediately update the value of that attribute. After your user receives and responds to a verification message to verify the new value, Amazon Cognito updates the attribute value. Your user can sign in and receive messages with the original attribute value until they verify the new value.</p> <p>To update the value of an attribute that requires verification in the same API request, include the <code>email_verified</code> or <code>phone_number_verified</code> attribute, with a value of <code>true</code>. If you set the <code>email_verified</code> or <code>phone_number_verified</code> value for an <code>email</code> or <code>phone_number</code> attribute that requires verification to <code>true</code>, Amazon Cognito doesn’t send a verification message to your user.</p>', 'DeviceType$DeviceAttributes' => '<p>The device attributes.</p>', 'GetUserResponse$UserAttributes' => '<p>An array of name-value pairs representing user attributes.</p> <p>For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.</p>', 'SignUpRequest$UserAttributes' => '<p>An array of name-value pairs representing user attributes.</p> <p>For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.</p>', 'SignUpRequest$ValidationData' => '<p>Temporary user attributes that contribute to the outcomes of your pre sign-up Lambda trigger. This set of key-value pairs are for custom validation of information that you collect from your users but don\'t need to retain.</p> <p>Your Lambda function can analyze this additional data and act on it. Your function might perform external API operations like logging user attributes and validation data to Amazon CloudWatch Logs. Validation data might also affect the response that your function returns to Amazon Cognito, like automatically confirming the user if they sign up from within your network.</p> <p>For more information about the pre sign-up Lambda trigger, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-pre-sign-up.html">Pre sign-up Lambda trigger</a>.</p>', 'UpdateUserAttributesRequest$UserAttributes' => '<p>An array of name-value pairs representing user attributes.</p> <p>For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.</p> <p>If you have set an attribute to require verification before Amazon Cognito updates its value, this request doesn’t immediately update the value of that attribute. After your user receives and responds to a verification message to verify the new value, Amazon Cognito updates the attribute value. Your user can sign in and receive messages with the original attribute value until they verify the new value.</p>', 'UserType$Attributes' => '<p>A container with information about the user type attributes.</p>', ], ], 'AttributeMappingKeyType' => [ 'base' => NULL, 'refs' => [ 'AttributeMappingType$key' => NULL, ], ], 'AttributeMappingType' => [ 'base' => NULL, 'refs' => [ 'CreateIdentityProviderRequest$AttributeMapping' => '<p>A mapping of IdP attributes to standard and custom user pool attributes.</p>', 'IdentityProviderType$AttributeMapping' => '<p>A mapping of IdP attributes to standard and custom user pool attributes.</p>', 'UpdateIdentityProviderRequest$AttributeMapping' => '<p>The IdP attribute mapping to be changed.</p>', ], ], 'AttributeNameListType' => [ 'base' => NULL, 'refs' => [ 'AdminDeleteUserAttributesRequest$UserAttributeNames' => '<p>An array of strings representing the user attribute names you want to delete.</p> <p>For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.</p>', 'DeleteUserAttributesRequest$UserAttributeNames' => '<p>An array of strings representing the user attribute names you want to delete.</p> <p>For custom attributes, you must prependattach the <code>custom:</code> prefix to the front of the attribute name.</p>', ], ], 'AttributeNameType' => [ 'base' => NULL, 'refs' => [ 'AttributeNameListType$member' => NULL, 'AttributeType$Name' => '<p>The name of the attribute.</p>', 'CodeDeliveryDetailsType$AttributeName' => '<p>The name of the attribute that Amazon Cognito verifies with the code.</p>', 'GetUserAttributeVerificationCodeRequest$AttributeName' => '<p>The attribute name returned by the server response to get the user attribute verification code.</p>', 'MFAOptionType$AttributeName' => '<p>The attribute name of the MFA option type. The only valid value is <code>phone_number</code>.</p>', 'SearchedAttributeNamesListType$member' => NULL, 'VerifyUserAttributeRequest$AttributeName' => '<p>The attribute name in the request to verify user attributes.</p>', ], ], 'AttributeType' => [ 'base' => '<p>Specifies whether the attribute is standard or custom.</p>', 'refs' => [ 'AttributeListType$member' => NULL, ], ], 'AttributeValueType' => [ 'base' => NULL, 'refs' => [ 'AttributeType$Value' => '<p>The value of the attribute.</p>', ], ], 'AttributesRequireVerificationBeforeUpdateType' => [ 'base' => NULL, 'refs' => [ 'UserAttributeUpdateSettingsType$AttributesRequireVerificationBeforeUpdate' => '<p>Requires that your user verifies their email address, phone number, or both before Amazon Cognito updates the value of that attribute. When you update a user attribute that has this option activated, Amazon Cognito sends a verification message to the new phone number or email address. Amazon Cognito doesn’t change the value of the attribute until your user responds to the verification message and confirms the new value.</p> <p>You can verify an updated email address or phone number with a <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerifyUserAttribute.html">VerifyUserAttribute</a> API request. You can also call the <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminUpdateUserAttributes.html">AdminUpdateUserAttributes</a> API and set <code>email_verified</code> or <code>phone_number_verified</code> to true.</p> <p>When <code>AttributesRequireVerificationBeforeUpdate</code> is false, your user pool doesn\'t require that your users verify attribute changes before Amazon Cognito updates them. In a user pool where <code>AttributesRequireVerificationBeforeUpdate</code> is false, API operations that change attribute values can immediately update a user’s <code>email</code> or <code>phone_number</code> attribute.</p>', ], ], 'AuthEventType' => [ 'base' => '<p>The authentication event type.</p>', 'refs' => [ 'AuthEventsType$member' => NULL, ], ], 'AuthEventsType' => [ 'base' => NULL, 'refs' => [ 'AdminListUserAuthEventsResponse$AuthEvents' => '<p>The response object. It includes the <code>EventID</code>, <code>EventType</code>, <code>CreationDate</code>, <code>EventRisk</code>, and <code>EventResponse</code>.</p>', ], ], 'AuthFlowType' => [ 'base' => NULL, 'refs' => [ 'AdminInitiateAuthRequest$AuthFlow' => '<p>The authentication flow for this call to run. The API action will depend on this value. For example:</p> <ul> <li> <p> <code>REFRESH_TOKEN_AUTH</code> will take in a valid refresh token and return new tokens.</p> </li> <li> <p> <code>USER_SRP_AUTH</code> will take in <code>USERNAME</code> and <code>SRP_A</code> and return the Secure Remote Password (SRP) protocol variables to be used for next challenge execution.</p> </li> <li> <p> <code>ADMIN_USER_PASSWORD_AUTH</code> will take in <code>USERNAME</code> and <code>PASSWORD</code> and return the next challenge or tokens.</p> </li> </ul> <p>Valid values include:</p> <ul> <li> <p> <code>USER_SRP_AUTH</code>: Authentication flow for the Secure Remote Password (SRP) protocol.</p> </li> <li> <p> <code>REFRESH_TOKEN_AUTH</code>/<code>REFRESH_TOKEN</code>: Authentication flow for refreshing the access token and ID token by supplying a valid refresh token.</p> </li> <li> <p> <code>CUSTOM_AUTH</code>: Custom authentication flow.</p> </li> <li> <p> <code>ADMIN_NO_SRP_AUTH</code>: Non-SRP authentication flow; you can pass in the USERNAME and PASSWORD directly if the flow is enabled for calling the app client.</p> </li> <li> <p> <code>ADMIN_USER_PASSWORD_AUTH</code>: Admin-based user password authentication. This replaces the <code>ADMIN_NO_SRP_AUTH</code> authentication flow. In this flow, Amazon Cognito receives the password in the request instead of using the SRP process to verify passwords.</p> </li> </ul>', 'InitiateAuthRequest$AuthFlow' => '<p>The authentication flow for this call to run. The API action will depend on this value. For example:</p> <ul> <li> <p> <code>REFRESH_TOKEN_AUTH</code> takes in a valid refresh token and returns new tokens.</p> </li> <li> <p> <code>USER_SRP_AUTH</code> takes in <code>USERNAME</code> and <code>SRP_A</code> and returns the SRP variables to be used for next challenge execution.</p> </li> <li> <p> <code>USER_PASSWORD_AUTH</code> takes in <code>USERNAME</code> and <code>PASSWORD</code> and returns the next challenge or tokens.</p> </li> </ul> <p>Valid values include:</p> <ul> <li> <p> <code>USER_SRP_AUTH</code>: Authentication flow for the Secure Remote Password (SRP) protocol.</p> </li> <li> <p> <code>REFRESH_TOKEN_AUTH</code>/<code>REFRESH_TOKEN</code>: Authentication flow for refreshing the access token and ID token by supplying a valid refresh token.</p> </li> <li> <p> <code>CUSTOM_AUTH</code>: Custom authentication flow.</p> </li> <li> <p> <code>USER_PASSWORD_AUTH</code>: Non-SRP authentication flow; user name and password are passed directly. If a user migration Lambda trigger is set, this flow will invoke the user migration Lambda if it doesn\'t find the user name in the user pool. </p> </li> </ul> <p> <code>ADMIN_NO_SRP_AUTH</code> isn\'t a valid value.</p>', ], ], 'AuthParametersType' => [ 'base' => NULL, 'refs' => [ 'AdminInitiateAuthRequest$AuthParameters' => '<p>The authentication parameters. These are inputs corresponding to the <code>AuthFlow</code> that you\'re invoking. The required values depend on the value of <code>AuthFlow</code>:</p> <ul> <li> <p>For <code>USER_SRP_AUTH</code>: <code>USERNAME</code> (required), <code>SRP_A</code> (required), <code>SECRET_HASH</code> (required if the app client is configured with a client secret), <code>DEVICE_KEY</code>.</p> </li> <li> <p>For <code>ADMIN_USER_PASSWORD_AUTH</code>: <code>USERNAME</code> (required), <code>PASSWORD</code> (required), <code>SECRET_HASH</code> (required if the app client is configured with a client secret), <code>DEVICE_KEY</code>.</p> </li> <li> <p>For <code>REFRESH_TOKEN_AUTH/REFRESH_TOKEN</code>: <code>REFRESH_TOKEN</code> (required), <code>SECRET_HASH</code> (required if the app client is configured with a client secret), <code>DEVICE_KEY</code>.</p> </li> <li> <p>For <code>CUSTOM_AUTH</code>: <code>USERNAME</code> (required), <code>SECRET_HASH</code> (if app client is configured with client secret), <code>DEVICE_KEY</code>. To start the authentication flow with password verification, include <code>ChallengeName: SRP_A</code> and <code>SRP_A: (The SRP_A Value)</code>.</p> </li> </ul> <p>For more information about <code>SECRET_HASH</code>, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/signing-up-users-in-your-app.html#cognito-user-pools-computing-secret-hash">Computing secret hash values</a>. For information about <code>DEVICE_KEY</code>, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html">Working with user devices in your user pool</a>.</p>', 'InitiateAuthRequest$AuthParameters' => '<p>The authentication parameters. These are inputs corresponding to the <code>AuthFlow</code> that you\'re invoking. The required values depend on the value of <code>AuthFlow</code>:</p> <ul> <li> <p>For <code>USER_SRP_AUTH</code>: <code>USERNAME</code> (required), <code>SRP_A</code> (required), <code>SECRET_HASH</code> (required if the app client is configured with a client secret), <code>DEVICE_KEY</code>.</p> </li> <li> <p>For <code>USER_PASSWORD_AUTH</code>: <code>USERNAME</code> (required), <code>PASSWORD</code> (required), <code>SECRET_HASH</code> (required if the app client is configured with a client secret), <code>DEVICE_KEY</code>.</p> </li> <li> <p>For <code>REFRESH_TOKEN_AUTH/REFRESH_TOKEN</code>: <code>REFRESH_TOKEN</code> (required), <code>SECRET_HASH</code> (required if the app client is configured with a client secret), <code>DEVICE_KEY</code>.</p> </li> <li> <p>For <code>CUSTOM_AUTH</code>: <code>USERNAME</code> (required), <code>SECRET_HASH</code> (if app client is configured with client secret), <code>DEVICE_KEY</code>. To start the authentication flow with password verification, include <code>ChallengeName: SRP_A</code> and <code>SRP_A: (The SRP_A Value)</code>.</p> </li> </ul> <p>For more information about <code>SECRET_HASH</code>, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/signing-up-users-in-your-app.html#cognito-user-pools-computing-secret-hash">Computing secret hash values</a>. For information about <code>DEVICE_KEY</code>, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html">Working with user devices in your user pool</a>.</p>', ], ], 'AuthSessionValidityType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolClientRequest$AuthSessionValidity' => '<p>Amazon Cognito creates a session token for each API request in an authentication flow. <code>AuthSessionValidity</code> is the duration, in minutes, of that session token. Your user pool native user must respond to each authentication challenge before the session expires.</p>', 'UpdateUserPoolClientRequest$AuthSessionValidity' => '<p>Amazon Cognito creates a session token for each API request in an authentication flow. <code>AuthSessionValidity</code> is the duration, in minutes, of that session token. Your user pool native user must respond to each authentication challenge before the session expires.</p>', 'UserPoolClientType$AuthSessionValidity' => '<p>Amazon Cognito creates a session token for each API request in an authentication flow. <code>AuthSessionValidity</code> is the duration, in minutes, of that session token. Your user pool native user must respond to each authentication challenge before the session expires.</p>', ], ], 'AuthenticationResultType' => [ 'base' => '<p>The authentication result.</p>', 'refs' => [ 'AdminInitiateAuthResponse$AuthenticationResult' => '<p>The result of the authentication response. This is only returned if the caller doesn\'t need to pass another challenge. If the caller does need to pass another challenge before it gets tokens, <code>ChallengeName</code>, <code>ChallengeParameters</code>, and <code>Session</code> are returned.</p>', 'AdminRespondToAuthChallengeResponse$AuthenticationResult' => '<p>The result returned by the server in response to the authentication request.</p>', 'InitiateAuthResponse$AuthenticationResult' => '<p>The result of the authentication response. This result is only returned if the caller doesn\'t need to pass another challenge. If the caller does need to pass another challenge before it gets tokens, <code>ChallengeName</code>, <code>ChallengeParameters</code>, and <code>Session</code> are returned.</p>', 'RespondToAuthChallengeResponse$AuthenticationResult' => '<p>The result returned by the server in response to the request to respond to the authentication challenge.</p>', ], ], 'BlockedIPRangeListType' => [ 'base' => NULL, 'refs' => [ 'RiskExceptionConfigurationType$BlockedIPRangeList' => '<p>Overrides the risk decision to always block the pre-authentication requests. The IP range is in CIDR notation, a compact representation of an IP address and its routing prefix.</p>', ], ], 'BooleanType' => [ 'base' => NULL, 'refs' => [ 'AdminCreateUserConfigType$AllowAdminCreateUserOnly' => '<p>Set to <code>True</code> if only the administrator is allowed to create user profiles. Set to <code>False</code> if users can sign themselves up via an app.</p>', 'AdminGetUserResponse$Enabled' => '<p>Indicates that the status is <code>enabled</code>.</p>', 'AdminSetUserPasswordRequest$Permanent' => '<p> <code>True</code> if the password is permanent, <code>False</code> if it is temporary.</p>', 'AnalyticsConfigurationType$UserDataShared' => '<p>If <code>UserDataShared</code> is <code>true</code>, Amazon Cognito includes user data in the events that it publishes to Amazon Pinpoint analytics.</p>', 'ConfirmDeviceResponse$UserConfirmationNecessary' => '<p>Indicates whether the user confirmation must confirm the device response.</p>', 'CreateUserPoolClientRequest$AllowedOAuthFlowsUserPoolClient' => '<p>Set to <code>true</code> to use OAuth 2.0 features in your user pool app client.</p> <p> <code>AllowedOAuthFlowsUserPoolClient</code> must be <code>true</code> before you can configure the following features in your app client.</p> <ul> <li> <p> <code>CallBackURLs</code>: Callback URLs.</p> </li> <li> <p> <code>LogoutURLs</code>: Sign-out redirect URLs.</p> </li> <li> <p> <code>AllowedOAuthScopes</code>: OAuth 2.0 scopes.</p> </li> <li> <p> <code>AllowedOAuthFlows</code>: Support for authorization code, implicit, and client credentials OAuth 2.0 grants.</p> </li> </ul> <p>To use OAuth 2.0 features, configure one of these features in the Amazon Cognito console or set <code>AllowedOAuthFlowsUserPoolClient</code> to <code>true</code> in a <code>CreateUserPoolClient</code> or <code>UpdateUserPoolClient</code> API request. If you don\'t set a value for <code>AllowedOAuthFlowsUserPoolClient</code> in a request with the CLI or SDKs, it defaults to <code>false</code>.</p>', 'DeviceConfigurationType$ChallengeRequiredOnNewDevice' => '<p>When true, a remembered device can sign in with device authentication instead of SMS and time-based one-time password (TOTP) factors for multi-factor authentication (MFA).</p> <note> <p>Whether or not <code>ChallengeRequiredOnNewDevice</code> is true, users who sign in with devices that have not been confirmed or remembered must still provide a second factor in a user pool that requires MFA.</p> </note>', 'DeviceConfigurationType$DeviceOnlyRememberedOnUserPrompt' => '<p>When true, Amazon Cognito doesn\'t automatically remember a user\'s device when your app sends a <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ConfirmDevice.html"> ConfirmDevice</a> API request. In your app, create a prompt for your user to choose whether they want to remember their device. Return the user\'s choice in an <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateDeviceStatus.html"> UpdateDeviceStatus</a> API request.</p> <p>When <code>DeviceOnlyRememberedOnUserPrompt</code> is <code>false</code>, Amazon Cognito immediately remembers devices that you register in a <code>ConfirmDevice</code> API request.</p>', 'PasswordPolicyType$RequireUppercase' => '<p>In the password policy that you have set, refers to whether you have required users to use at least one uppercase letter in their password.</p>', 'PasswordPolicyType$RequireLowercase' => '<p>In the password policy that you have set, refers to whether you have required users to use at least one lowercase letter in their password.</p>', 'PasswordPolicyType$RequireNumbers' => '<p>In the password policy that you have set, refers to whether you have required users to use at least one number in their password.</p>', 'PasswordPolicyType$RequireSymbols' => '<p>In the password policy that you have set, refers to whether you have required users to use at least one symbol in their password.</p>', 'SMSMfaSettingsType$Enabled' => '<p>Specifies whether SMS text message MFA is activated. If an MFA type is activated for a user, the user will be prompted for MFA during all sign-in attempts, unless device tracking is turned on and the device has been trusted.</p>', 'SMSMfaSettingsType$PreferredMfa' => '<p>Specifies whether SMS is the preferred MFA method.</p>', 'SchemaAttributeType$DeveloperOnlyAttribute' => '<note> <p>You should use <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UserPoolClientType.html#CognitoUserPools-Type-UserPoolClientType-WriteAttributes">WriteAttributes</a> in the user pool client to control how attributes can be mutated for new use cases instead of using <code>DeveloperOnlyAttribute</code>.</p> </note> <p>Specifies whether the attribute type is developer only. This attribute can only be modified by an administrator. Users won\'t be able to modify this attribute using their access token. For example, <code>DeveloperOnlyAttribute</code> can be modified using AdminUpdateUserAttributes but can\'t be updated using UpdateUserAttributes.</p>', 'SchemaAttributeType$Mutable' => '<p>Specifies whether the value of the attribute can be changed.</p> <p>Any user pool attribute whose value you map from an IdP attribute must be mutable, with a parameter value of <code>true</code>. Amazon Cognito updates mapped attributes when users sign in to your application through an IdP. If an attribute is immutable, Amazon Cognito throws an error when it attempts to update the attribute. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-specifying-attribute-mapping.html">Specifying Identity Provider Attribute Mappings for Your User Pool</a>.</p>', 'SchemaAttributeType$Required' => '<p>Specifies whether a user pool attribute is required. If the attribute is required and the user doesn\'t provide a value, registration or sign-in will fail.</p>', 'SignUpResponse$UserConfirmed' => '<p>A response from the server indicating that a user registration has been confirmed.</p>', 'SoftwareTokenMfaConfigType$Enabled' => '<p>Specifies whether software token MFA is activated.</p>', 'SoftwareTokenMfaSettingsType$Enabled' => '<p>Specifies whether software token MFA is activated. If an MFA type is activated for a user, the user will be prompted for MFA during all sign-in attempts, unless device tracking is turned on and the device has been trusted.</p>', 'SoftwareTokenMfaSettingsType$PreferredMfa' => '<p>Specifies whether software token MFA is the preferred MFA method.</p>', 'UpdateUserPoolClientRequest$AllowedOAuthFlowsUserPoolClient' => '<p>Set to <code>true</code> to use OAuth 2.0 features in your user pool app client.</p> <p> <code>AllowedOAuthFlowsUserPoolClient</code> must be <code>true</code> before you can configure the following features in your app client.</p> <ul> <li> <p> <code>CallBackURLs</code>: Callback URLs.</p> </li> <li> <p> <code>LogoutURLs</code>: Sign-out redirect URLs.</p> </li> <li> <p> <code>AllowedOAuthScopes</code>: OAuth 2.0 scopes.</p> </li> <li> <p> <code>AllowedOAuthFlows</code>: Support for authorization code, implicit, and client credentials OAuth 2.0 grants.</p> </li> </ul> <p>To use OAuth 2.0 features, configure one of these features in the Amazon Cognito console or set <code>AllowedOAuthFlowsUserPoolClient</code> to <code>true</code> in a <code>CreateUserPoolClient</code> or <code>UpdateUserPoolClient</code> API request. If you don\'t set a value for <code>AllowedOAuthFlowsUserPoolClient</code> in a request with the CLI or SDKs, it defaults to <code>false</code>.</p>', 'UserPoolClientType$AllowedOAuthFlowsUserPoolClient' => '<p>Set to <code>true</code> to use OAuth 2.0 features in your user pool app client.</p> <p> <code>AllowedOAuthFlowsUserPoolClient</code> must be <code>true</code> before you can configure the following features in your app client.</p> <ul> <li> <p> <code>CallBackURLs</code>: Callback URLs.</p> </li> <li> <p> <code>LogoutURLs</code>: Sign-out redirect URLs.</p> </li> <li> <p> <code>AllowedOAuthScopes</code>: OAuth 2.0 scopes.</p> </li> <li> <p> <code>AllowedOAuthFlows</code>: Support for authorization code, implicit, and client credentials OAuth 2.0 grants.</p> </li> </ul> <p>To use OAuth 2.0 features, configure one of these features in the Amazon Cognito console or set <code>AllowedOAuthFlowsUserPoolClient</code> to <code>true</code> in a <code>CreateUserPoolClient</code> or <code>UpdateUserPoolClient</code> API request. If you don\'t set a value for <code>AllowedOAuthFlowsUserPoolClient</code> in a request with the CLI or SDKs, it defaults to <code>false</code>.</p>', 'UserType$Enabled' => '<p>Specifies whether the user is enabled.</p>', ], ], 'CSSType' => [ 'base' => NULL, 'refs' => [ 'SetUICustomizationRequest$CSS' => '<p>The CSS values in the UI customization.</p>', 'UICustomizationType$CSS' => '<p>The CSS values in the UI customization.</p>', ], ], 'CSSVersionType' => [ 'base' => NULL, 'refs' => [ 'UICustomizationType$CSSVersion' => '<p>The CSS version number.</p>', ], ], 'CallbackURLsListType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolClientRequest$CallbackURLs' => '<p>A list of allowed redirect (callback) URLs for the IdPs.</p> <p>A redirect URI must:</p> <ul> <li> <p>Be an absolute URI.</p> </li> <li> <p>Be registered with the authorization server.</p> </li> <li> <p>Not include a fragment component.</p> </li> </ul> <p>See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.</p> <p>Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.</p> <p>App callback URLs such as myapp://example are also supported.</p>', 'UpdateUserPoolClientRequest$CallbackURLs' => '<p>A list of allowed redirect (callback) URLs for the IdPs.</p> <p>A redirect URI must:</p> <ul> <li> <p>Be an absolute URI.</p> </li> <li> <p>Be registered with the authorization server.</p> </li> <li> <p>Not include a fragment component.</p> </li> </ul> <p>See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.</p> <p>Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.</p> <p>App callback URLs such as <code>myapp://example</code> are also supported.</p>', 'UserPoolClientType$CallbackURLs' => '<p>A list of allowed redirect (callback) URLs for the IdPs.</p> <p>A redirect URI must:</p> <ul> <li> <p>Be an absolute URI.</p> </li> <li> <p>Be registered with the authorization server.</p> </li> <li> <p>Not include a fragment component.</p> </li> </ul> <p>See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.</p> <p>Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.</p> <p>App callback URLs such as myapp://example are also supported.</p>', ], ], 'ChallengeName' => [ 'base' => NULL, 'refs' => [ 'ChallengeResponseType$ChallengeName' => '<p>The challenge name.</p>', ], ], 'ChallengeNameType' => [ 'base' => NULL, 'refs' => [ 'AdminInitiateAuthResponse$ChallengeName' => '<p>The name of the challenge that you\'re responding to with this call. This is returned in the <code>AdminInitiateAuth</code> response if you must pass another challenge.</p> <ul> <li> <p> <code>MFA_SETUP</code>: If MFA is required, users who don\'t have at least one of the MFA methods set up are presented with an <code>MFA_SETUP</code> challenge. The user must set up at least one MFA type to continue to authenticate.</p> </li> <li> <p> <code>SELECT_MFA_TYPE</code>: Selects the MFA type. Valid MFA options are <code>SMS_MFA</code> for text SMS MFA, and <code>SOFTWARE_TOKEN_MFA</code> for time-based one-time password (TOTP) software token MFA.</p> </li> <li> <p> <code>SMS_MFA</code>: Next challenge is to supply an <code>SMS_MFA_CODE</code>, delivered via SMS.</p> </li> <li> <p> <code>PASSWORD_VERIFIER</code>: Next challenge is to supply <code>PASSWORD_CLAIM_SIGNATURE</code>, <code>PASSWORD_CLAIM_SECRET_BLOCK</code>, and <code>TIMESTAMP</code> after the client-side SRP calculations.</p> </li> <li> <p> <code>CUSTOM_CHALLENGE</code>: This is returned if your custom authentication flow determines that the user should pass another challenge before tokens are issued.</p> </li> <li> <p> <code>DEVICE_SRP_AUTH</code>: If device tracking was activated in your user pool and the previous challenges were passed, this challenge is returned so that Amazon Cognito can start tracking this device.</p> </li> <li> <p> <code>DEVICE_PASSWORD_VERIFIER</code>: Similar to <code>PASSWORD_VERIFIER</code>, but for devices only.</p> </li> <li> <p> <code>ADMIN_NO_SRP_AUTH</code>: This is returned if you must authenticate with <code>USERNAME</code> and <code>PASSWORD</code> directly. An app client must be enabled to use this flow.</p> </li> <li> <p> <code>NEW_PASSWORD_REQUIRED</code>: For users who are required to change their passwords after successful first login. Respond to this challenge with <code>NEW_PASSWORD</code> and any required attributes that Amazon Cognito returned in the <code>requiredAttributes</code> parameter. You can also set values for attributes that aren\'t required by your user pool and that your app client can write. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminRespondToAuthChallenge.html">AdminRespondToAuthChallenge</a>.</p> <note> <p>In a <code>NEW_PASSWORD_REQUIRED</code> challenge response, you can\'t modify a required attribute that already has a value. In <code>AdminRespondToAuthChallenge</code>, set a value for any keys that Amazon Cognito returned in the <code>requiredAttributes</code> parameter, then use the <code>AdminUpdateUserAttributes</code> API operation to modify the value of any additional attributes.</p> </note> </li> <li> <p> <code>MFA_SETUP</code>: For users who are required to set up an MFA factor before they can sign in. The MFA types activated for the user pool will be listed in the challenge parameters <code>MFAS_CAN_SETUP</code> value. </p> <p> To set up software token MFA, use the session returned here from <code>InitiateAuth</code> as an input to <code>AssociateSoftwareToken</code>, and use the session returned by <code>VerifySoftwareToken</code> as an input to <code>RespondToAuthChallenge</code> with challenge name <code>MFA_SETUP</code> to complete sign-in. To set up SMS MFA, users will need help from an administrator to add a phone number to their account and then call <code>InitiateAuth</code> again to restart sign-in.</p> </li> </ul>', 'AdminRespondToAuthChallengeRequest$ChallengeName' => '<p>The challenge name. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminInitiateAuth.html">AdminInitiateAuth</a>.</p>', 'AdminRespondToAuthChallengeResponse$ChallengeName' => '<p>The name of the challenge. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminInitiateAuth.html">AdminInitiateAuth</a>.</p>', 'InitiateAuthResponse$ChallengeName' => '<p>The name of the challenge that you\'re responding to with this call. This name is returned in the <code>InitiateAuth</code> response if you must pass another challenge.</p> <p>Valid values include the following:</p> <note> <p>All of the following challenges require <code>USERNAME</code> and <code>SECRET_HASH</code> (if applicable) in the parameters.</p> </note> <ul> <li> <p> <code>SMS_MFA</code>: Next challenge is to supply an <code>SMS_MFA_CODE</code>, delivered via SMS.</p> </li> <li> <p> <code>PASSWORD_VERIFIER</code>: Next challenge is to supply <code>PASSWORD_CLAIM_SIGNATURE</code>, <code>PASSWORD_CLAIM_SECRET_BLOCK</code>, and <code>TIMESTAMP</code> after the client-side SRP calculations.</p> </li> <li> <p> <code>CUSTOM_CHALLENGE</code>: This is returned if your custom authentication flow determines that the user should pass another challenge before tokens are issued.</p> </li> <li> <p> <code>DEVICE_SRP_AUTH</code>: If device tracking was activated on your user pool and the previous challenges were passed, this challenge is returned so that Amazon Cognito can start tracking this device.</p> </li> <li> <p> <code>DEVICE_PASSWORD_VERIFIER</code>: Similar to <code>PASSWORD_VERIFIER</code>, but for devices only.</p> </li> <li> <p> <code>NEW_PASSWORD_REQUIRED</code>: For users who are required to change their passwords after successful first login. </p> <p>Respond to this challenge with <code>NEW_PASSWORD</code> and any required attributes that Amazon Cognito returned in the <code>requiredAttributes</code> parameter. You can also set values for attributes that aren\'t required by your user pool and that your app client can write. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RespondToAuthChallenge.html">RespondToAuthChallenge</a>.</p> <note> <p>In a <code>NEW_PASSWORD_REQUIRED</code> challenge response, you can\'t modify a required attribute that already has a value. In <code>RespondToAuthChallenge</code>, set a value for any keys that Amazon Cognito returned in the <code>requiredAttributes</code> parameter, then use the <code>UpdateUserAttributes</code> API operation to modify the value of any additional attributes.</p> </note> </li> <li> <p> <code>MFA_SETUP</code>: For users who are required to setup an MFA factor before they can sign in. The MFA types activated for the user pool will be listed in the challenge parameters <code>MFAS_CAN_SETUP</code> value. </p> <p> To set up software token MFA, use the session returned here from <code>InitiateAuth</code> as an input to <code>AssociateSoftwareToken</code>. Use the session returned by <code>VerifySoftwareToken</code> as an input to <code>RespondToAuthChallenge</code> with challenge name <code>MFA_SETUP</code> to complete sign-in. To set up SMS MFA, an administrator should help the user to add a phone number to their account, and then the user should call <code>InitiateAuth</code> again to restart sign-in.</p> </li> </ul>', 'RespondToAuthChallengeRequest$ChallengeName' => '<p>The challenge name. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_InitiateAuth.html">InitiateAuth</a>.</p> <p> <code>ADMIN_NO_SRP_AUTH</code> isn\'t a valid value.</p>', 'RespondToAuthChallengeResponse$ChallengeName' => '<p>The challenge name. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_InitiateAuth.html">InitiateAuth</a>.</p>', ], ], 'ChallengeParametersType' => [ 'base' => NULL, 'refs' => [ 'AdminInitiateAuthResponse$ChallengeParameters' => '<p>The challenge parameters. These are returned to you in the <code>AdminInitiateAuth</code> response if you must pass another challenge. The responses in this parameter should be used to compute inputs to the next call (<code>AdminRespondToAuthChallenge</code>).</p> <p>All challenges require <code>USERNAME</code> and <code>SECRET_HASH</code> (if applicable).</p> <p>The value of the <code>USER_ID_FOR_SRP</code> attribute is the user\'s actual username, not an alias (such as email address or phone number), even if you specified an alias in your call to <code>AdminInitiateAuth</code>. This happens because, in the <code>AdminRespondToAuthChallenge</code> API <code>ChallengeResponses</code>, the <code>USERNAME</code> attribute can\'t be an alias.</p>', 'AdminRespondToAuthChallengeResponse$ChallengeParameters' => '<p>The challenge parameters. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminInitiateAuth.html">AdminInitiateAuth</a>.</p>', 'InitiateAuthResponse$ChallengeParameters' => '<p>The challenge parameters. These are returned in the <code>InitiateAuth</code> response if you must pass another challenge. The responses in this parameter should be used to compute inputs to the next call (<code>RespondToAuthChallenge</code>). </p> <p>All challenges require <code>USERNAME</code> and <code>SECRET_HASH</code> (if applicable).</p>', 'RespondToAuthChallengeResponse$ChallengeParameters' => '<p>The challenge parameters. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_InitiateAuth.html">InitiateAuth</a>.</p>', ], ], 'ChallengeResponse' => [ 'base' => NULL, 'refs' => [ 'ChallengeResponseType$ChallengeResponse' => '<p>The challenge response.</p>', ], ], 'ChallengeResponseListType' => [ 'base' => NULL, 'refs' => [ 'AuthEventType$ChallengeResponses' => '<p>The challenge responses.</p>', ], ], 'ChallengeResponseType' => [ 'base' => '<p>The challenge response type.</p>', 'refs' => [ 'ChallengeResponseListType$member' => NULL, ], ], 'ChallengeResponsesType' => [ 'base' => NULL, 'refs' => [ 'AdminRespondToAuthChallengeRequest$ChallengeResponses' => '<p>The responses to the challenge that you received in the previous request. Each challenge has its own required response parameters. The following examples are partial JSON request bodies that highlight challenge-response parameters.</p> <important> <p>You must provide a SECRET_HASH parameter in all challenge responses to an app client that has a client secret.</p> </important> <dl> <dt>SMS_MFA</dt> <dd> <p> <code>"ChallengeName": "SMS_MFA", "ChallengeResponses": {"SMS_MFA_CODE": "[SMS_code]", "USERNAME": "[username]"}</code> </p> </dd> <dt>PASSWORD_VERIFIER</dt> <dd> <p> <code>"ChallengeName": "PASSWORD_VERIFIER", "ChallengeResponses": {"PASSWORD_CLAIM_SIGNATURE": "[claim_signature]", "PASSWORD_CLAIM_SECRET_BLOCK": "[secret_block]", "TIMESTAMP": [timestamp], "USERNAME": "[username]"}</code> </p> <p>Add <code>"DEVICE_KEY"</code> when you sign in with a remembered device.</p> </dd> <dt>CUSTOM_CHALLENGE</dt> <dd> <p> <code>"ChallengeName": "CUSTOM_CHALLENGE", "ChallengeResponses": {"USERNAME": "[username]", "ANSWER": "[challenge_answer]"}</code> </p> <p>Add <code>"DEVICE_KEY"</code> when you sign in with a remembered device.</p> </dd> <dt>NEW_PASSWORD_REQUIRED</dt> <dd> <p> <code>"ChallengeName": "NEW_PASSWORD_REQUIRED", "ChallengeResponses": {"NEW_PASSWORD": "[new_password]", "USERNAME": "[username]"}</code> </p> <p>To set any required attributes that <code>InitiateAuth</code> returned in an <code>requiredAttributes</code> parameter, add <code>"userAttributes.[attribute_name]": "[attribute_value]"</code>. This parameter can also set values for writable attributes that aren\'t required by your user pool.</p> <note> <p>In a <code>NEW_PASSWORD_REQUIRED</code> challenge response, you can\'t modify a required attribute that already has a value. In <code>RespondToAuthChallenge</code>, set a value for any keys that Amazon Cognito returned in the <code>requiredAttributes</code> parameter, then use the <code>UpdateUserAttributes</code> API operation to modify the value of any additional attributes.</p> </note> </dd> <dt>SOFTWARE_TOKEN_MFA</dt> <dd> <p> <code>"ChallengeName": "SOFTWARE_TOKEN_MFA", "ChallengeResponses": {"USERNAME": "[username]", "SOFTWARE_TOKEN_MFA_CODE": [authenticator_code]}</code> </p> </dd> <dt>DEVICE_SRP_AUTH</dt> <dd> <p> <code>"ChallengeName": "DEVICE_SRP_AUTH", "ChallengeResponses": {"USERNAME": "[username]", "DEVICE_KEY": "[device_key]", "SRP_A": "[srp_a]"}</code> </p> </dd> <dt>DEVICE_PASSWORD_VERIFIER</dt> <dd> <p> <code>"ChallengeName": "DEVICE_PASSWORD_VERIFIER", "ChallengeResponses": {"DEVICE_KEY": "[device_key]", "PASSWORD_CLAIM_SIGNATURE": "[claim_signature]", "PASSWORD_CLAIM_SECRET_BLOCK": "[secret_block]", "TIMESTAMP": [timestamp], "USERNAME": "[username]"}</code> </p> </dd> <dt>MFA_SETUP</dt> <dd> <p> <code>"ChallengeName": "MFA_SETUP", "ChallengeResponses": {"USERNAME": "[username]"}, "SESSION": "[Session ID from VerifySoftwareToken]"</code> </p> </dd> <dt>SELECT_MFA_TYPE</dt> <dd> <p> <code>"ChallengeName": "SELECT_MFA_TYPE", "ChallengeResponses": {"USERNAME": "[username]", "ANSWER": "[SMS_MFA or SOFTWARE_TOKEN_MFA]"}</code> </p> </dd> </dl> <p>For more information about <code>SECRET_HASH</code>, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/signing-up-users-in-your-app.html#cognito-user-pools-computing-secret-hash">Computing secret hash values</a>. For information about <code>DEVICE_KEY</code>, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html">Working with user devices in your user pool</a>.</p>', 'RespondToAuthChallengeRequest$ChallengeResponses' => '<p>The responses to the challenge that you received in the previous request. Each challenge has its own required response parameters. The following examples are partial JSON request bodies that highlight challenge-response parameters.</p> <important> <p>You must provide a SECRET_HASH parameter in all challenge responses to an app client that has a client secret.</p> </important> <dl> <dt>SMS_MFA</dt> <dd> <p> <code>"ChallengeName": "SMS_MFA", "ChallengeResponses": {"SMS_MFA_CODE": "[SMS_code]", "USERNAME": "[username]"}</code> </p> </dd> <dt>PASSWORD_VERIFIER</dt> <dd> <p> <code>"ChallengeName": "PASSWORD_VERIFIER", "ChallengeResponses": {"PASSWORD_CLAIM_SIGNATURE": "[claim_signature]", "PASSWORD_CLAIM_SECRET_BLOCK": "[secret_block]", "TIMESTAMP": [timestamp], "USERNAME": "[username]"}</code> </p> <p>Add <code>"DEVICE_KEY"</code> when you sign in with a remembered device.</p> </dd> <dt>CUSTOM_CHALLENGE</dt> <dd> <p> <code>"ChallengeName": "CUSTOM_CHALLENGE", "ChallengeResponses": {"USERNAME": "[username]", "ANSWER": "[challenge_answer]"}</code> </p> <p>Add <code>"DEVICE_KEY"</code> when you sign in with a remembered device.</p> </dd> <dt>NEW_PASSWORD_REQUIRED</dt> <dd> <p> <code>"ChallengeName": "NEW_PASSWORD_REQUIRED", "ChallengeResponses": {"NEW_PASSWORD": "[new_password]", "USERNAME": "[username]"}</code> </p> <p>To set any required attributes that <code>InitiateAuth</code> returned in an <code>requiredAttributes</code> parameter, add <code>"userAttributes.[attribute_name]": "[attribute_value]"</code>. This parameter can also set values for writable attributes that aren\'t required by your user pool.</p> <note> <p>In a <code>NEW_PASSWORD_REQUIRED</code> challenge response, you can\'t modify a required attribute that already has a value. In <code>RespondToAuthChallenge</code>, set a value for any keys that Amazon Cognito returned in the <code>requiredAttributes</code> parameter, then use the <code>UpdateUserAttributes</code> API operation to modify the value of any additional attributes.</p> </note> </dd> <dt>SOFTWARE_TOKEN_MFA</dt> <dd> <p> <code>"ChallengeName": "SOFTWARE_TOKEN_MFA", "ChallengeResponses": {"USERNAME": "[username]", "SOFTWARE_TOKEN_MFA_CODE": [authenticator_code]}</code> </p> </dd> <dt>DEVICE_SRP_AUTH</dt> <dd> <p> <code>"ChallengeName": "DEVICE_SRP_AUTH", "ChallengeResponses": {"USERNAME": "[username]", "DEVICE_KEY": "[device_key]", "SRP_A": "[srp_a]"}</code> </p> </dd> <dt>DEVICE_PASSWORD_VERIFIER</dt> <dd> <p> <code>"ChallengeName": "DEVICE_PASSWORD_VERIFIER", "ChallengeResponses": {"DEVICE_KEY": "[device_key]", "PASSWORD_CLAIM_SIGNATURE": "[claim_signature]", "PASSWORD_CLAIM_SECRET_BLOCK": "[secret_block]", "TIMESTAMP": [timestamp], "USERNAME": "[username]"}</code> </p> </dd> <dt>MFA_SETUP</dt> <dd> <p> <code>"ChallengeName": "MFA_SETUP", "ChallengeResponses": {"USERNAME": "[username]"}, "SESSION": "[Session ID from VerifySoftwareToken]"</code> </p> </dd> <dt>SELECT_MFA_TYPE</dt> <dd> <p> <code>"ChallengeName": "SELECT_MFA_TYPE", "ChallengeResponses": {"USERNAME": "[username]", "ANSWER": "[SMS_MFA or SOFTWARE_TOKEN_MFA]"}</code> </p> </dd> </dl> <p>For more information about <code>SECRET_HASH</code>, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/signing-up-users-in-your-app.html#cognito-user-pools-computing-secret-hash">Computing secret hash values</a>. For information about <code>DEVICE_KEY</code>, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html">Working with user devices in your user pool</a>.</p>', ], ], 'ChangePasswordRequest' => [ 'base' => '<p>Represents the request to change a user password.</p>', 'refs' => [], ], 'ChangePasswordResponse' => [ 'base' => '<p>The response from the server to the change password request.</p>', 'refs' => [], ], 'ClientIdType' => [ 'base' => NULL, 'refs' => [ 'AdminInitiateAuthRequest$ClientId' => '<p>The app client ID.</p>', 'AdminRespondToAuthChallengeRequest$ClientId' => '<p>The app client ID.</p>', 'ConfirmForgotPasswordRequest$ClientId' => '<p>The app client ID of the app associated with the user pool.</p>', 'ConfirmSignUpRequest$ClientId' => '<p>The ID of the app client associated with the user pool.</p>', 'DeleteUserPoolClientRequest$ClientId' => '<p>The app client ID of the app associated with the user pool.</p>', 'DescribeRiskConfigurationRequest$ClientId' => '<p>The app client ID.</p>', 'DescribeUserPoolClientRequest$ClientId' => '<p>The app client ID of the app associated with the user pool.</p>', 'ForgotPasswordRequest$ClientId' => '<p>The ID of the client associated with the user pool.</p>', 'GetUICustomizationRequest$ClientId' => '<p>The client ID for the client app.</p>', 'InitiateAuthRequest$ClientId' => '<p>The app client ID.</p>', 'ResendConfirmationCodeRequest$ClientId' => '<p>The ID of the client associated with the user pool.</p>', 'RespondToAuthChallengeRequest$ClientId' => '<p>The app client ID.</p>', 'RevokeTokenRequest$ClientId' => '<p>The client ID for the token that you want to revoke.</p>', 'RiskConfigurationType$ClientId' => '<p>The app client ID.</p>', 'SetRiskConfigurationRequest$ClientId' => '<p>The app client ID. If <code>ClientId</code> is null, then the risk configuration is mapped to <code>userPoolId</code>. When the client ID is null, the same risk configuration is applied to all the clients in the userPool.</p> <p>Otherwise, <code>ClientId</code> is mapped to the client. When the client ID isn\'t null, the user pool configuration is overridden and the risk configuration for the client is used instead.</p>', 'SetUICustomizationRequest$ClientId' => '<p>The client ID for the client app.</p>', 'SignUpRequest$ClientId' => '<p>The ID of the client associated with the user pool.</p>', 'UICustomizationType$ClientId' => '<p>The client ID for the client app.</p>', 'UpdateUserPoolClientRequest$ClientId' => '<p>The ID of the client associated with the user pool.</p>', 'UserPoolClientDescription$ClientId' => '<p>The ID of the client associated with the user pool.</p>', 'UserPoolClientType$ClientId' => '<p>The ID of the client associated with the user pool.</p>', ], ], 'ClientMetadataType' => [ 'base' => NULL, 'refs' => [ 'AdminConfirmSignUpRequest$ClientMetadata' => '<p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.</p> <p>If your user pool configuration includes triggers, the AdminConfirmSignUp API action invokes the Lambda function that is specified for the <i>post confirmation</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. In this payload, the <code>clientMetadata</code> attribute provides the data that you assigned to the ClientMetadata parameter in your AdminConfirmSignUp request. In your function code in Lambda, you can process the ClientMetadata value to enhance your workflow for your specific needs.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html"> Customizing user pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note> <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won\'t do the following:</p> <ul> <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn\'t include triggers, the ClientMetadata parameter serves no purpose.</p> </li> <li> <p>Validate the ClientMetadata value.</p> </li> <li> <p>Encrypt the ClientMetadata value. Don\'t use Amazon Cognito to provide sensitive information.</p> </li> </ul> </note>', 'AdminCreateUserRequest$ClientMetadata' => '<p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.</p> <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the AdminCreateUser API action, Amazon Cognito invokes the function that is assigned to the <i>pre sign-up</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your AdminCreateUser request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html"> Customizing user pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note> <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won\'t do the following:</p> <ul> <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn\'t include triggers, the ClientMetadata parameter serves no purpose.</p> </li> <li> <p>Validate the ClientMetadata value.</p> </li> <li> <p>Encrypt the ClientMetadata value. Don\'t use Amazon Cognito to provide sensitive information.</p> </li> </ul> </note>', 'AdminInitiateAuthRequest$ClientMetadata' => '<p>A map of custom key-value pairs that you can provide as input for certain custom workflows that this action triggers.</p> <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the AdminInitiateAuth API action, Amazon Cognito invokes the Lambda functions that are specified for various triggers. The ClientMetadata value is passed as input to the functions for only the following triggers:</p> <ul> <li> <p>Pre signup</p> </li> <li> <p>Pre authentication</p> </li> <li> <p>User migration</p> </li> </ul> <p>When Amazon Cognito invokes the functions for these triggers, it passes a JSON payload, which the function receives as input. This payload contains a <code>validationData</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your AdminInitiateAuth request. In your function code in Lambda, you can process the <code>validationData</code> value to enhance your workflow for your specific needs.</p> <p>When you use the AdminInitiateAuth API action, Amazon Cognito also invokes the functions for the following triggers, but it doesn\'t provide the ClientMetadata value as input:</p> <ul> <li> <p>Post authentication</p> </li> <li> <p>Custom message</p> </li> <li> <p>Pre token generation</p> </li> <li> <p>Create auth challenge</p> </li> <li> <p>Define auth challenge</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html"> Customizing user pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note> <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won\'t do the following:</p> <ul> <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn\'t include triggers, the ClientMetadata parameter serves no purpose.</p> </li> <li> <p>Validate the ClientMetadata value.</p> </li> <li> <p>Encrypt the ClientMetadata value. Don\'t use Amazon Cognito to provide sensitive information.</p> </li> </ul> </note>', 'AdminResetUserPasswordRequest$ClientMetadata' => '<p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.</p> <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the AdminResetUserPassword API action, Amazon Cognito invokes the function that is assigned to the <i>custom message</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your AdminResetUserPassword request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs. </p> <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html"> Customizing user pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note> <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won\'t do the following:</p> <ul> <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn\'t include triggers, the ClientMetadata parameter serves no purpose.</p> </li> <li> <p>Validate the ClientMetadata value.</p> </li> <li> <p>Encrypt the ClientMetadata value. Don\'t use Amazon Cognito to provide sensitive information.</p> </li> </ul> </note>', 'AdminRespondToAuthChallengeRequest$ClientMetadata' => '<p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.</p> <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the AdminRespondToAuthChallenge API action, Amazon Cognito invokes any functions that you have assigned to the following triggers: </p> <ul> <li> <p>pre sign-up</p> </li> <li> <p>custom message</p> </li> <li> <p>post authentication</p> </li> <li> <p>user migration</p> </li> <li> <p>pre token generation</p> </li> <li> <p>define auth challenge</p> </li> <li> <p>create auth challenge</p> </li> <li> <p>verify auth challenge response</p> </li> </ul> <p>When Amazon Cognito invokes any of these functions, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute that provides the data that you assigned to the ClientMetadata parameter in your AdminRespondToAuthChallenge request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html"> Customizing user pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note> <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won\'t do the following:</p> <ul> <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn\'t include triggers, the ClientMetadata parameter serves no purpose.</p> </li> <li> <p>Validate the ClientMetadata value.</p> </li> <li> <p>Encrypt the ClientMetadata value. Don\'t use Amazon Cognito to provide sensitive information.</p> </li> </ul> </note>', 'AdminUpdateUserAttributesRequest$ClientMetadata' => '<p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.</p> <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the AdminUpdateUserAttributes API action, Amazon Cognito invokes the function that is assigned to the <i>custom message</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your AdminUpdateUserAttributes request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html"> Customizing user pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note> <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won\'t do the following:</p> <ul> <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn\'t include triggers, the ClientMetadata parameter serves no purpose.</p> </li> <li> <p>Validate the ClientMetadata value.</p> </li> <li> <p>Encrypt the ClientMetadata value. Don\'t use Amazon Cognito to provide sensitive information.</p> </li> </ul> </note>', 'ConfirmForgotPasswordRequest$ClientMetadata' => '<p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.</p> <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the ConfirmForgotPassword API action, Amazon Cognito invokes the function that is assigned to the <i>post confirmation</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your ConfirmForgotPassword request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html"> Customizing user pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note> <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won\'t do the following:</p> <ul> <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn\'t include triggers, the ClientMetadata parameter serves no purpose.</p> </li> <li> <p>Validate the ClientMetadata value.</p> </li> <li> <p>Encrypt the ClientMetadata value. Don\'t use Amazon Cognito to provide sensitive information.</p> </li> </ul> </note>', 'ConfirmSignUpRequest$ClientMetadata' => '<p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.</p> <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the ConfirmSignUp API action, Amazon Cognito invokes the function that is assigned to the <i>post confirmation</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your ConfirmSignUp request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html"> Customizing user pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note> <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won\'t do the following:</p> <ul> <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn\'t include triggers, the ClientMetadata parameter serves no purpose.</p> </li> <li> <p>Validate the ClientMetadata value.</p> </li> <li> <p>Encrypt the ClientMetadata value. Don\'t use Amazon Cognito to provide sensitive information.</p> </li> </ul> </note>', 'ForgotPasswordRequest$ClientMetadata' => '<p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.</p> <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the ForgotPassword API action, Amazon Cognito invokes any functions that are assigned to the following triggers: <i>pre sign-up</i>, <i>custom message</i>, and <i>user migration</i>. When Amazon Cognito invokes any of these functions, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your ForgotPassword request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html"> Customizing user pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note> <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won\'t do the following:</p> <ul> <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn\'t include triggers, the ClientMetadata parameter serves no purpose.</p> </li> <li> <p>Validate the ClientMetadata value.</p> </li> <li> <p>Encrypt the ClientMetadata value. Don\'t use Amazon Cognito to provide sensitive information.</p> </li> </ul> </note>', 'GetUserAttributeVerificationCodeRequest$ClientMetadata' => '<p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.</p> <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the GetUserAttributeVerificationCode API action, Amazon Cognito invokes the function that is assigned to the <i>custom message</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your GetUserAttributeVerificationCode request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html"> Customizing user pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note> <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won\'t do the following:</p> <ul> <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn\'t include triggers, the ClientMetadata parameter serves no purpose.</p> </li> <li> <p>Validate the ClientMetadata value.</p> </li> <li> <p>Encrypt the ClientMetadata value. Don\'t use Amazon Cognito to provide sensitive information.</p> </li> </ul> </note>', 'InitiateAuthRequest$ClientMetadata' => '<p>A map of custom key-value pairs that you can provide as input for certain custom workflows that this action triggers.</p> <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the InitiateAuth API action, Amazon Cognito invokes the Lambda functions that are specified for various triggers. The ClientMetadata value is passed as input to the functions for only the following triggers:</p> <ul> <li> <p>Pre signup</p> </li> <li> <p>Pre authentication</p> </li> <li> <p>User migration</p> </li> </ul> <p>When Amazon Cognito invokes the functions for these triggers, it passes a JSON payload, which the function receives as input. This payload contains a <code>validationData</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your InitiateAuth request. In your function code in Lambda, you can process the <code>validationData</code> value to enhance your workflow for your specific needs.</p> <p>When you use the InitiateAuth API action, Amazon Cognito also invokes the functions for the following triggers, but it doesn\'t provide the ClientMetadata value as input:</p> <ul> <li> <p>Post authentication</p> </li> <li> <p>Custom message</p> </li> <li> <p>Pre token generation</p> </li> <li> <p>Create auth challenge</p> </li> <li> <p>Define auth challenge</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html"> Customizing user pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note> <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won\'t do the following:</p> <ul> <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn\'t include triggers, the ClientMetadata parameter serves no purpose.</p> </li> <li> <p>Validate the ClientMetadata value.</p> </li> <li> <p>Encrypt the ClientMetadata value. Don\'t use Amazon Cognito to provide sensitive information.</p> </li> </ul> </note>', 'ResendConfirmationCodeRequest$ClientMetadata' => '<p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.</p> <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the ResendConfirmationCode API action, Amazon Cognito invokes the function that is assigned to the <i>custom message</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your ResendConfirmationCode request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html"> Customizing user pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note> <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won\'t do the following:</p> <ul> <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn\'t include triggers, the ClientMetadata parameter serves no purpose.</p> </li> <li> <p>Validate the ClientMetadata value.</p> </li> <li> <p>Encrypt the ClientMetadata value. Don\'t use Amazon Cognito to provide sensitive information.</p> </li> </ul> </note>', 'RespondToAuthChallengeRequest$ClientMetadata' => '<p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.</p> <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the RespondToAuthChallenge API action, Amazon Cognito invokes any functions that are assigned to the following triggers: <i>post authentication</i>, <i>pre token generation</i>, <i>define auth challenge</i>, <i>create auth challenge</i>, and <i>verify auth challenge</i>. When Amazon Cognito invokes any of these functions, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your RespondToAuthChallenge request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html"> Customizing user pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note> <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won\'t do the following:</p> <ul> <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn\'t include triggers, the ClientMetadata parameter serves no purpose.</p> </li> <li> <p>Validate the ClientMetadata value.</p> </li> <li> <p>Encrypt the ClientMetadata value. Don\'t use Amazon Cognito to provide sensitive information.</p> </li> </ul> </note>', 'SignUpRequest$ClientMetadata' => '<p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.</p> <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the SignUp API action, Amazon Cognito invokes any functions that are assigned to the following triggers: <i>pre sign-up</i>, <i>custom message</i>, and <i>post confirmation</i>. When Amazon Cognito invokes any of these functions, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your SignUp request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html"> Customizing user pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note> <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won\'t do the following:</p> <ul> <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn\'t include triggers, the ClientMetadata parameter serves no purpose.</p> </li> <li> <p>Validate the ClientMetadata value.</p> </li> <li> <p>Encrypt the ClientMetadata value. Don\'t use Amazon Cognito to provide sensitive information.</p> </li> </ul> </note>', 'UpdateUserAttributesRequest$ClientMetadata' => '<p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action initiates. </p> <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the UpdateUserAttributes API action, Amazon Cognito invokes the function that is assigned to the <i>custom message</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your UpdateUserAttributes request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html"> Customizing user pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note> <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won\'t do the following:</p> <ul> <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn\'t include triggers, the ClientMetadata parameter serves no purpose.</p> </li> <li> <p>Validate the ClientMetadata value.</p> </li> <li> <p>Encrypt the ClientMetadata value. Don\'t use Amazon Cognito to provide sensitive information.</p> </li> </ul> </note>', ], ], 'ClientNameType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolClientRequest$ClientName' => '<p>The client name for the user pool client you would like to create.</p>', 'UpdateUserPoolClientRequest$ClientName' => '<p>The client name from the update user pool client request.</p>', 'UserPoolClientDescription$ClientName' => '<p>The client name from the user pool client description.</p>', 'UserPoolClientType$ClientName' => '<p>The client name from the user pool request of the client type.</p>', ], ], 'ClientPermissionListType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolClientRequest$ReadAttributes' => '<p>The list of user attributes that you want your app client to have read-only access to. After your user authenticates in your app, their access token authorizes them to read their own attribute value for any attribute in this list. An example of this kind of activity is when your user selects a link to view their profile information. Your app makes a <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_GetUser.html">GetUser</a> API request to retrieve and display your user\'s profile data.</p> <p>When you don\'t specify the <code>ReadAttributes</code> for your app client, your app can read the values of <code>email_verified</code>, <code>phone_number_verified</code>, and the Standard attributes of your user pool. When your user pool has read access to these default attributes, <code>ReadAttributes</code> doesn\'t return any information. Amazon Cognito only populates <code>ReadAttributes</code> in the API response if you have specified your own custom set of read attributes.</p>', 'CreateUserPoolClientRequest$WriteAttributes' => '<p>The list of user attributes that you want your app client to have write access to. After your user authenticates in your app, their access token authorizes them to set or modify their own attribute value for any attribute in this list. An example of this kind of activity is when you present your user with a form to update their profile information and they change their last name. Your app then makes an <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateUserAttributes.html">UpdateUserAttributes</a> API request and sets <code>family_name</code> to the new value. </p> <p>When you don\'t specify the <code>WriteAttributes</code> for your app client, your app can write the values of the Standard attributes of your user pool. When your user pool has write access to these default attributes, <code>WriteAttributes</code> doesn\'t return any information. Amazon Cognito only populates <code>WriteAttributes</code> in the API response if you have specified your own custom set of write attributes.</p> <p>If your app client allows users to sign in through an IdP, this array must include all attributes that you have mapped to IdP attributes. Amazon Cognito updates mapped attributes when users sign in to your application through an IdP. If your app client does not have write access to a mapped attribute, Amazon Cognito throws an error when it tries to update the attribute. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-specifying-attribute-mapping.html">Specifying IdP Attribute Mappings for Your user pool</a>.</p>', 'UpdateUserPoolClientRequest$ReadAttributes' => '<p>The list of user attributes that you want your app client to have read-only access to. After your user authenticates in your app, their access token authorizes them to read their own attribute value for any attribute in this list. An example of this kind of activity is when your user selects a link to view their profile information. Your app makes a <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_GetUser.html">GetUser</a> API request to retrieve and display your user\'s profile data.</p> <p>When you don\'t specify the <code>ReadAttributes</code> for your app client, your app can read the values of <code>email_verified</code>, <code>phone_number_verified</code>, and the Standard attributes of your user pool. When your user pool has read access to these default attributes, <code>ReadAttributes</code> doesn\'t return any information. Amazon Cognito only populates <code>ReadAttributes</code> in the API response if you have specified your own custom set of read attributes.</p>', 'UpdateUserPoolClientRequest$WriteAttributes' => '<p>The list of user attributes that you want your app client to have write access to. After your user authenticates in your app, their access token authorizes them to set or modify their own attribute value for any attribute in this list. An example of this kind of activity is when you present your user with a form to update their profile information and they change their last name. Your app then makes an <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateUserAttributes.html">UpdateUserAttributes</a> API request and sets <code>family_name</code> to the new value. </p> <p>When you don\'t specify the <code>WriteAttributes</code> for your app client, your app can write the values of the Standard attributes of your user pool. When your user pool has write access to these default attributes, <code>WriteAttributes</code> doesn\'t return any information. Amazon Cognito only populates <code>WriteAttributes</code> in the API response if you have specified your own custom set of write attributes.</p> <p>If your app client allows users to sign in through an IdP, this array must include all attributes that you have mapped to IdP attributes. Amazon Cognito updates mapped attributes when users sign in to your application through an IdP. If your app client does not have write access to a mapped attribute, Amazon Cognito throws an error when it tries to update the attribute. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-specifying-attribute-mapping.html">Specifying IdP Attribute Mappings for Your user pool</a>.</p>', 'UserPoolClientType$ReadAttributes' => '<p>The list of user attributes that you want your app client to have read-only access to. After your user authenticates in your app, their access token authorizes them to read their own attribute value for any attribute in this list. An example of this kind of activity is when your user selects a link to view their profile information. Your app makes a <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_GetUser.html">GetUser</a> API request to retrieve and display your user\'s profile data.</p> <p>When you don\'t specify the <code>ReadAttributes</code> for your app client, your app can read the values of <code>email_verified</code>, <code>phone_number_verified</code>, and the Standard attributes of your user pool. When your user pool has read access to these default attributes, <code>ReadAttributes</code> doesn\'t return any information. Amazon Cognito only populates <code>ReadAttributes</code> in the API response if you have specified your own custom set of read attributes.</p>', 'UserPoolClientType$WriteAttributes' => '<p>The list of user attributes that you want your app client to have write access to. After your user authenticates in your app, their access token authorizes them to set or modify their own attribute value for any attribute in this list. An example of this kind of activity is when you present your user with a form to update their profile information and they change their last name. Your app then makes an <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateUserAttributes.html">UpdateUserAttributes</a> API request and sets <code>family_name</code> to the new value. </p> <p>When you don\'t specify the <code>WriteAttributes</code> for your app client, your app can write the values of the Standard attributes of your user pool. When your user pool has write access to these default attributes, <code>WriteAttributes</code> doesn\'t return any information. Amazon Cognito only populates <code>WriteAttributes</code> in the API response if you have specified your own custom set of write attributes.</p> <p>If your app client allows users to sign in through an IdP, this array must include all attributes that you have mapped to IdP attributes. Amazon Cognito updates mapped attributes when users sign in to your application through an IdP. If your app client does not have write access to a mapped attribute, Amazon Cognito throws an error when it tries to update the attribute. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-specifying-attribute-mapping.html">Specifying IdP Attribute Mappings for Your user pool</a>.</p>', ], ], 'ClientPermissionType' => [ 'base' => NULL, 'refs' => [ 'ClientPermissionListType$member' => NULL, ], ], 'ClientSecretType' => [ 'base' => NULL, 'refs' => [ 'RevokeTokenRequest$ClientSecret' => '<p>The secret for the client ID. This is required only if the client ID has a secret.</p>', 'UserPoolClientType$ClientSecret' => '<p>The client secret from the user pool request of the client type.</p>', ], ], 'CloudWatchLogsConfigurationType' => [ 'base' => '<p>The CloudWatch logging destination of a user pool detailed activity logging configuration.</p>', 'refs' => [ 'LogConfigurationType$CloudWatchLogsConfiguration' => '<p>The CloudWatch logging destination of a user pool.</p>', ], ], 'CodeDeliveryDetailsListType' => [ 'base' => NULL, 'refs' => [ 'UpdateUserAttributesResponse$CodeDeliveryDetailsList' => '<p>The code delivery details list from the server for the request to update user attributes.</p>', ], ], 'CodeDeliveryDetailsType' => [ 'base' => '<p>The delivery details for an email or SMS message that Amazon Cognito sent for authentication or verification.</p>', 'refs' => [ 'CodeDeliveryDetailsListType$member' => NULL, 'ForgotPasswordResponse$CodeDeliveryDetails' => '<p>The code delivery details returned by the server in response to the request to reset a password.</p>', 'GetUserAttributeVerificationCodeResponse$CodeDeliveryDetails' => '<p>The code delivery details returned by the server in response to the request to get the user attribute verification code.</p>', 'ResendConfirmationCodeResponse$CodeDeliveryDetails' => '<p>The code delivery details returned by the server in response to the request to resend the confirmation code.</p>', 'SignUpResponse$CodeDeliveryDetails' => '<p>The code delivery details returned by the server response to the user registration request.</p>', ], ], 'CodeDeliveryFailureException' => [ 'base' => '<p>This exception is thrown when a verification code fails to deliver successfully.</p>', 'refs' => [], ], 'CodeMismatchException' => [ 'base' => '<p>This exception is thrown if the provided code doesn\'t match what the server was expecting.</p>', 'refs' => [], ], 'CompletionMessageType' => [ 'base' => NULL, 'refs' => [ 'UserImportJobType$CompletionMessage' => '<p>The message returned when the user import job is completed.</p>', ], ], 'CompromisedCredentialsActionsType' => [ 'base' => '<p>The compromised credentials actions type.</p>', 'refs' => [ 'CompromisedCredentialsRiskConfigurationType$Actions' => '<p>The compromised credentials risk configuration actions.</p>', ], ], 'CompromisedCredentialsEventActionType' => [ 'base' => NULL, 'refs' => [ 'CompromisedCredentialsActionsType$EventAction' => '<p>The event action.</p>', ], ], 'CompromisedCredentialsRiskConfigurationType' => [ 'base' => '<p>The compromised credentials risk configuration type.</p>', 'refs' => [ 'RiskConfigurationType$CompromisedCredentialsRiskConfiguration' => '<p>The compromised credentials risk configuration object, including the <code>EventFilter</code> and the <code>EventAction</code>.</p>', 'SetRiskConfigurationRequest$CompromisedCredentialsRiskConfiguration' => '<p>The compromised credentials risk configuration.</p>', ], ], 'ConcurrentModificationException' => [ 'base' => '<p>This exception is thrown if two or more modifications are happening concurrently.</p>', 'refs' => [], ], 'ConfirmDeviceRequest' => [ 'base' => '<p>Confirms the device request.</p>', 'refs' => [], ], 'ConfirmDeviceResponse' => [ 'base' => '<p>Confirms the device response.</p>', 'refs' => [], ], 'ConfirmForgotPasswordRequest' => [ 'base' => '<p>The request representing the confirmation for a password reset.</p>', 'refs' => [], ], 'ConfirmForgotPasswordResponse' => [ 'base' => '<p>The response from the server that results from a user\'s request to retrieve a forgotten password.</p>', 'refs' => [], ], 'ConfirmSignUpRequest' => [ 'base' => '<p>Represents the request to confirm registration of a user.</p>', 'refs' => [], ], 'ConfirmSignUpResponse' => [ 'base' => '<p>Represents the response from the server for the registration confirmation.</p>', 'refs' => [], ], 'ConfirmationCodeType' => [ 'base' => NULL, 'refs' => [ 'ConfirmForgotPasswordRequest$ConfirmationCode' => '<p>The confirmation code from your user\'s request to reset their password. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ForgotPassword.html">ForgotPassword</a>.</p>', 'ConfirmSignUpRequest$ConfirmationCode' => '<p>The confirmation code sent by a user\'s request to confirm registration.</p>', 'VerifyUserAttributeRequest$Code' => '<p>The verification code in the request to verify user attributes.</p>', ], ], 'ContextDataType' => [ 'base' => '<p>Contextual user data type used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>', 'refs' => [ 'AdminInitiateAuthRequest$ContextData' => '<p>Contextual data about your user session, such as the device fingerprint, IP address, or location. Amazon Cognito advanced security evaluates the risk of an authentication event based on the context that your app generates and passes to Amazon Cognito when it makes API requests.</p>', 'AdminRespondToAuthChallengeRequest$ContextData' => '<p>Contextual data about your user session, such as the device fingerprint, IP address, or location. Amazon Cognito advanced security evaluates the risk of an authentication event based on the context that your app generates and passes to Amazon Cognito when it makes API requests.</p>', ], ], 'CreateGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateIdentityProviderRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateIdentityProviderResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateResourceServerRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateResourceServerResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateUserImportJobRequest' => [ 'base' => '<p>Represents the request to create the user import job.</p>', 'refs' => [], ], 'CreateUserImportJobResponse' => [ 'base' => '<p>Represents the response from the server to the request to create the user import job.</p>', 'refs' => [], ], 'CreateUserPoolClientRequest' => [ 'base' => '<p>Represents the request to create a user pool client.</p>', 'refs' => [], ], 'CreateUserPoolClientResponse' => [ 'base' => '<p>Represents the response from the server to create a user pool client.</p>', 'refs' => [], ], 'CreateUserPoolDomainRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateUserPoolDomainResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateUserPoolRequest' => [ 'base' => '<p>Represents the request to create a user pool.</p>', 'refs' => [], ], 'CreateUserPoolResponse' => [ 'base' => '<p>Represents the response from the server for the request to create a user pool.</p>', 'refs' => [], ], 'CustomAttributeNameType' => [ 'base' => NULL, 'refs' => [ 'SchemaAttributeType$Name' => '<p>The name of your user pool attribute. When you create or update a user pool, adding a schema attribute creates a custom or developer-only attribute. When you add an attribute with a <code>Name</code> value of <code>MyAttribute</code>, Amazon Cognito creates the custom attribute <code>custom:MyAttribute</code>. When <code>DeveloperOnlyAttribute</code> is <code>true</code>, Amazon Cognito creates your attribute as <code>dev:MyAttribute</code>. In an operation that describes a user pool, Amazon Cognito returns this value as <code>value</code> for standard attributes, <code>custom:value</code> for custom attributes, and <code>dev:value</code> for developer-only attributes..</p>', ], ], 'CustomAttributesListType' => [ 'base' => NULL, 'refs' => [ 'AddCustomAttributesRequest$CustomAttributes' => '<p>An array of custom attributes, such as Mutable and Name.</p>', ], ], 'CustomDomainConfigType' => [ 'base' => '<p>The configuration for a custom domain that hosts the sign-up and sign-in webpages for your application.</p>', 'refs' => [ 'CreateUserPoolDomainRequest$CustomDomainConfig' => '<p>The configuration for a custom domain that hosts the sign-up and sign-in webpages for your application.</p> <p>Provide this parameter only if you want to use a custom domain for your user pool. Otherwise, you can exclude this parameter and use the Amazon Cognito hosted domain instead.</p> <p>For more information about the hosted domain and custom domains, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-assign-domain.html">Configuring a User Pool Domain</a>.</p>', 'DomainDescriptionType$CustomDomainConfig' => '<p>The configuration for a custom domain that hosts the sign-up and sign-in webpages for your application.</p>', 'UpdateUserPoolDomainRequest$CustomDomainConfig' => '<p>The configuration for a custom domain that hosts the sign-up and sign-in pages for your application. Use this object to specify an SSL certificate that is managed by ACM.</p>', ], ], 'CustomEmailLambdaVersionConfigType' => [ 'base' => '<p>The properties of a custom email sender Lambda trigger.</p>', 'refs' => [ 'LambdaConfigType$CustomEmailSender' => '<p>A custom email sender Lambda trigger.</p>', ], ], 'CustomEmailSenderLambdaVersionType' => [ 'base' => NULL, 'refs' => [ 'CustomEmailLambdaVersionConfigType$LambdaVersion' => '<p>The user pool trigger version of the request that Amazon Cognito sends to your Lambda function. Higher-numbered versions add fields that support new features.</p> <p>You must use a <code>LambdaVersion</code> of <code>V1_0</code> with a custom sender function.</p>', ], ], 'CustomSMSLambdaVersionConfigType' => [ 'base' => '<p>The properties of a custom SMS sender Lambda trigger.</p>', 'refs' => [ 'LambdaConfigType$CustomSMSSender' => '<p>A custom SMS sender Lambda trigger.</p>', ], ], 'CustomSMSSenderLambdaVersionType' => [ 'base' => NULL, 'refs' => [ 'CustomSMSLambdaVersionConfigType$LambdaVersion' => '<p>The user pool trigger version of the request that Amazon Cognito sends to your Lambda function. Higher-numbered versions add fields that support new features.</p> <p>You must use a <code>LambdaVersion</code> of <code>V1_0</code> with a custom sender function.</p>', ], ], 'DateType' => [ 'base' => NULL, 'refs' => [ 'AdminGetUserResponse$UserCreateDate' => '<p>The date the user was created.</p>', 'AdminGetUserResponse$UserLastModifiedDate' => '<p>The date and time when the item was modified. Amazon Cognito returns this timestamp in UNIX epoch time format. Your SDK might render the output in a human-readable format like ISO 8601 or a Java <code>Date</code> object.</p>', 'AuthEventType$CreationDate' => '<p>The date and time when the item was created. Amazon Cognito returns this timestamp in UNIX epoch time format. Your SDK might render the output in a human-readable format like ISO 8601 or a Java <code>Date</code> object.</p>', 'DeviceType$DeviceCreateDate' => '<p>The creation date of the device.</p>', 'DeviceType$DeviceLastModifiedDate' => '<p>The date and time when the item was modified. Amazon Cognito returns this timestamp in UNIX epoch time format. Your SDK might render the output in a human-readable format like ISO 8601 or a Java <code>Date</code> object.</p>', 'DeviceType$DeviceLastAuthenticatedDate' => '<p>The date when the device was last authenticated.</p>', 'EventFeedbackType$FeedbackDate' => '<p>The event feedback date.</p>', 'GroupType$LastModifiedDate' => '<p>The date and time when the item was modified. Amazon Cognito returns this timestamp in UNIX epoch time format. Your SDK might render the output in a human-readable format like ISO 8601 or a Java <code>Date</code> object.</p>', 'GroupType$CreationDate' => '<p>The date and time when the item was created. Amazon Cognito returns this timestamp in UNIX epoch time format. Your SDK might render the output in a human-readable format like ISO 8601 or a Java <code>Date</code> object.</p>', 'IdentityProviderType$LastModifiedDate' => '<p>The date and time when the item was modified. Amazon Cognito returns this timestamp in UNIX epoch time format. Your SDK might render the output in a human-readable format like ISO 8601 or a Java <code>Date</code> object.</p>', 'IdentityProviderType$CreationDate' => '<p>The date and time when the item was created. Amazon Cognito returns this timestamp in UNIX epoch time format. Your SDK might render the output in a human-readable format like ISO 8601 or a Java <code>Date</code> object.</p>', 'ProviderDescription$LastModifiedDate' => '<p>The date the provider was last modified.</p>', 'ProviderDescription$CreationDate' => '<p>The date and time when the item was created. Amazon Cognito returns this timestamp in UNIX epoch time format. Your SDK might render the output in a human-readable format like ISO 8601 or a Java <code>Date</code> object.</p>', 'RiskConfigurationType$LastModifiedDate' => '<p>The date and time when the item was modified. Amazon Cognito returns this timestamp in UNIX epoch time format. Your SDK might render the output in a human-readable format like ISO 8601 or a Java <code>Date</code> object.</p>', 'UICustomizationType$LastModifiedDate' => '<p>The date and time when the item was modified. Amazon Cognito returns this timestamp in UNIX epoch time format. Your SDK might render the output in a human-readable format like ISO 8601 or a Java <code>Date</code> object.</p>', 'UICustomizationType$CreationDate' => '<p>The date and time when the item was created. Amazon Cognito returns this timestamp in UNIX epoch time format. Your SDK might render the output in a human-readable format like ISO 8601 or a Java <code>Date</code> object.</p>', 'UserImportJobType$CreationDate' => '<p>The date and time when the item was created. Amazon Cognito returns this timestamp in UNIX epoch time format. Your SDK might render the output in a human-readable format like ISO 8601 or a Java <code>Date</code> object.</p>', 'UserImportJobType$StartDate' => '<p>The date when the user import job was started.</p>', 'UserImportJobType$CompletionDate' => '<p>The date when the user import job was completed.</p>', 'UserPoolClientType$LastModifiedDate' => '<p>The date and time when the item was modified. Amazon Cognito returns this timestamp in UNIX epoch time format. Your SDK might render the output in a human-readable format like ISO 8601 or a Java <code>Date</code> object.</p>', 'UserPoolClientType$CreationDate' => '<p>The date and time when the item was created. Amazon Cognito returns this timestamp in UNIX epoch time format. Your SDK might render the output in a human-readable format like ISO 8601 or a Java <code>Date</code> object.</p>', 'UserPoolDescriptionType$LastModifiedDate' => '<p>The date and time when the item was modified. Amazon Cognito returns this timestamp in UNIX epoch time format. Your SDK might render the output in a human-readable format like ISO 8601 or a Java <code>Date</code> object.</p>', 'UserPoolDescriptionType$CreationDate' => '<p>The date and time when the item was created. Amazon Cognito returns this timestamp in UNIX epoch time format. Your SDK might render the output in a human-readable format like ISO 8601 or a Java <code>Date</code> object.</p>', 'UserPoolType$LastModifiedDate' => '<p>The date and time when the item was modified. Amazon Cognito returns this timestamp in UNIX epoch time format. Your SDK might render the output in a human-readable format like ISO 8601 or a Java <code>Date</code> object.</p>', 'UserPoolType$CreationDate' => '<p>The date and time when the item was created. Amazon Cognito returns this timestamp in UNIX epoch time format. Your SDK might render the output in a human-readable format like ISO 8601 or a Java <code>Date</code> object.</p>', 'UserType$UserCreateDate' => '<p>The creation date of the user.</p>', 'UserType$UserLastModifiedDate' => '<p>The date and time when the item was modified. Amazon Cognito returns this timestamp in UNIX epoch time format. Your SDK might render the output in a human-readable format like ISO 8601 or a Java <code>Date</code> object.</p>', ], ], 'DefaultEmailOptionType' => [ 'base' => NULL, 'refs' => [ 'VerificationMessageTemplateType$DefaultEmailOption' => '<p>The default email option.</p>', ], ], 'DeleteGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteIdentityProviderRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResourceServerRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUserAttributesRequest' => [ 'base' => '<p>Represents the request to delete user attributes.</p>', 'refs' => [], ], 'DeleteUserAttributesResponse' => [ 'base' => '<p>Represents the response from the server to delete user attributes.</p>', 'refs' => [], ], 'DeleteUserPoolClientRequest' => [ 'base' => '<p>Represents the request to delete a user pool client.</p>', 'refs' => [], ], 'DeleteUserPoolDomainRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUserPoolDomainResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUserPoolRequest' => [ 'base' => '<p>Represents the request to delete a user pool.</p>', 'refs' => [], ], 'DeleteUserRequest' => [ 'base' => '<p>Represents the request to delete a user.</p>', 'refs' => [], ], 'DeletionProtectionType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolRequest$DeletionProtection' => '<p>When active, <code>DeletionProtection</code> prevents accidental deletion of your user pool. Before you can delete a user pool that you have protected against deletion, you must deactivate this feature.</p> <p>When you try to delete a protected user pool in a <code>DeleteUserPool</code> API request, Amazon Cognito returns an <code>InvalidParameterException</code> error. To delete a protected user pool, send a new <code>DeleteUserPool</code> request after you deactivate deletion protection in an <code>UpdateUserPool</code> API request.</p>', 'UpdateUserPoolRequest$DeletionProtection' => '<p>When active, <code>DeletionProtection</code> prevents accidental deletion of your user pool. Before you can delete a user pool that you have protected against deletion, you must deactivate this feature.</p> <p>When you try to delete a protected user pool in a <code>DeleteUserPool</code> API request, Amazon Cognito returns an <code>InvalidParameterException</code> error. To delete a protected user pool, send a new <code>DeleteUserPool</code> request after you deactivate deletion protection in an <code>UpdateUserPool</code> API request.</p>', 'UserPoolType$DeletionProtection' => '<p>When active, <code>DeletionProtection</code> prevents accidental deletion of your user pool. Before you can delete a user pool that you have protected against deletion, you must deactivate this feature.</p> <p>When you try to delete a protected user pool in a <code>DeleteUserPool</code> API request, Amazon Cognito returns an <code>InvalidParameterException</code> error. To delete a protected user pool, send a new <code>DeleteUserPool</code> request after you deactivate deletion protection in an <code>UpdateUserPool</code> API request.</p>', ], ], 'DeliveryMediumListType' => [ 'base' => NULL, 'refs' => [ 'AdminCreateUserRequest$DesiredDeliveryMediums' => '<p>Specify <code>"EMAIL"</code> if email will be used to send the welcome message. Specify <code>"SMS"</code> if the phone number will be used. The default value is <code>"SMS"</code>. You can specify more than one value.</p>', ], ], 'DeliveryMediumType' => [ 'base' => NULL, 'refs' => [ 'CodeDeliveryDetailsType$DeliveryMedium' => '<p>The method that Amazon Cognito used to send the code.</p>', 'DeliveryMediumListType$member' => NULL, 'MFAOptionType$DeliveryMedium' => '<p>The delivery medium to send the MFA code. You can use this parameter to set only the <code>SMS</code> delivery medium value.</p>', ], ], 'DescribeIdentityProviderRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIdentityProviderResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeResourceServerRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeResourceServerResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRiskConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRiskConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUserImportJobRequest' => [ 'base' => '<p>Represents the request to describe the user import job.</p>', 'refs' => [], ], 'DescribeUserImportJobResponse' => [ 'base' => '<p>Represents the response from the server to the request to describe the user import job.</p>', 'refs' => [], ], 'DescribeUserPoolClientRequest' => [ 'base' => '<p>Represents the request to describe a user pool client.</p>', 'refs' => [], ], 'DescribeUserPoolClientResponse' => [ 'base' => '<p>Represents the response from the server from a request to describe the user pool client.</p>', 'refs' => [], ], 'DescribeUserPoolDomainRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUserPoolDomainResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUserPoolRequest' => [ 'base' => '<p>Represents the request to describe the user pool.</p>', 'refs' => [], ], 'DescribeUserPoolResponse' => [ 'base' => '<p>Represents the response to describe the user pool.</p>', 'refs' => [], ], 'DescriptionType' => [ 'base' => NULL, 'refs' => [ 'CreateGroupRequest$Description' => '<p>A string containing the description of the group.</p>', 'GroupType$Description' => '<p>A string containing the description of the group.</p>', 'UpdateGroupRequest$Description' => '<p>A string containing the new description of the group.</p>', ], ], 'DeviceConfigurationType' => [ 'base' => '<p>The device-remembering configuration for a user pool. A <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserPool.html"> DescribeUserPool</a> request returns a null value for this object when the user pool isn\'t configured to remember devices. When device remembering is active, you can remember a user\'s device with a <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ConfirmDevice.html">ConfirmDevice</a> API request. Additionally. when the property <code>DeviceOnlyRememberedOnUserPrompt</code> is <code>true</code>, you must follow <code>ConfirmDevice</code> with an <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateDeviceStatus.html">UpdateDeviceStatus</a> API request that sets the user\'s device to <code>remembered</code> or <code>not_remembered</code>.</p> <p>To sign in with a remembered device, include <code>DEVICE_KEY</code> in the authentication parameters in your user\'s <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_InitiateAuth.html"> InitiateAuth</a> request. If your app doesn\'t include a <code>DEVICE_KEY</code> parameter, the <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_InitiateAuth.html#API_InitiateAuth_ResponseSyntax">response</a> from Amazon Cognito includes newly-generated <code>DEVICE_KEY</code> and <code>DEVICE_GROUP_KEY</code> values under <code>NewDeviceMetadata</code>. Store these values to use in future device-authentication requests.</p> <note> <p>When you provide a value for any property of <code>DeviceConfiguration</code>, you activate the device remembering for the user pool.</p> </note>', 'refs' => [ 'CreateUserPoolRequest$DeviceConfiguration' => '<p>The device-remembering configuration for a user pool. A null value indicates that you have deactivated device remembering in your user pool.</p> <note> <p>When you provide a value for any <code>DeviceConfiguration</code> field, you activate the Amazon Cognito device-remembering feature.</p> </note>', 'UpdateUserPoolRequest$DeviceConfiguration' => '<p>The device-remembering configuration for a user pool. A null value indicates that you have deactivated device remembering in your user pool.</p> <note> <p>When you provide a value for any <code>DeviceConfiguration</code> field, you activate the Amazon Cognito device-remembering feature.</p> </note>', 'UserPoolType$DeviceConfiguration' => '<p>The device-remembering configuration for a user pool. A null value indicates that you have deactivated device remembering in your user pool.</p> <note> <p>When you provide a value for any <code>DeviceConfiguration</code> field, you activate the Amazon Cognito device-remembering feature.</p> </note>', ], ], 'DeviceKeyType' => [ 'base' => NULL, 'refs' => [ 'AdminForgetDeviceRequest$DeviceKey' => '<p>The device key.</p>', 'AdminGetDeviceRequest$DeviceKey' => '<p>The device key.</p>', 'AdminUpdateDeviceStatusRequest$DeviceKey' => '<p>The device key.</p>', 'ConfirmDeviceRequest$DeviceKey' => '<p>The device key.</p>', 'DeviceType$DeviceKey' => '<p>The device key.</p>', 'ForgetDeviceRequest$DeviceKey' => '<p>The device key.</p>', 'GetDeviceRequest$DeviceKey' => '<p>The device key.</p>', 'NewDeviceMetadataType$DeviceKey' => '<p>The device key.</p>', 'UpdateDeviceStatusRequest$DeviceKey' => '<p>The device key.</p>', ], ], 'DeviceListType' => [ 'base' => NULL, 'refs' => [ 'AdminListDevicesResponse$Devices' => '<p>The devices in the list of devices response.</p>', 'ListDevicesResponse$Devices' => '<p>The devices returned in the list devices response.</p>', ], ], 'DeviceNameType' => [ 'base' => NULL, 'refs' => [ 'ConfirmDeviceRequest$DeviceName' => '<p>The device name.</p>', ], ], 'DeviceRememberedStatusType' => [ 'base' => NULL, 'refs' => [ 'AdminUpdateDeviceStatusRequest$DeviceRememberedStatus' => '<p>The status indicating whether a device has been remembered or not.</p>', 'UpdateDeviceStatusRequest$DeviceRememberedStatus' => '<p>The status of whether a device is remembered.</p>', ], ], 'DeviceSecretVerifierConfigType' => [ 'base' => '<p>The device verifier against which it is authenticated.</p>', 'refs' => [ 'ConfirmDeviceRequest$DeviceSecretVerifierConfig' => '<p>The configuration of the device secret verifier.</p>', ], ], 'DeviceType' => [ 'base' => '<p>The device type.</p>', 'refs' => [ 'AdminGetDeviceResponse$Device' => '<p>The device.</p>', 'DeviceListType$member' => NULL, 'GetDeviceResponse$Device' => '<p>The device.</p>', ], ], 'DomainDescriptionType' => [ 'base' => '<p>A container for information about a domain.</p>', 'refs' => [ 'DescribeUserPoolDomainResponse$DomainDescription' => '<p>A domain description object containing information about the domain.</p>', ], ], 'DomainStatusType' => [ 'base' => NULL, 'refs' => [ 'DomainDescriptionType$Status' => '<p>The domain status.</p>', ], ], 'DomainType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolDomainRequest$Domain' => '<p>The domain string. For custom domains, this is the fully-qualified domain name, such as <code>auth.example.com</code>. For Amazon Cognito prefix domains, this is the prefix alone, such as <code>auth</code>.</p>', 'CreateUserPoolDomainResponse$CloudFrontDomain' => '<p>The Amazon CloudFront endpoint that you use as the target of the alias that you set up with your Domain Name Service (DNS) provider. Amazon Cognito returns this value if you set a custom domain with <code>CustomDomainConfig</code>. If you set an Amazon Cognito prefix domain, this operation returns a blank response.</p>', 'DeleteUserPoolDomainRequest$Domain' => '<p>The domain string. For custom domains, this is the fully-qualified domain name, such as <code>auth.example.com</code>. For Amazon Cognito prefix domains, this is the prefix alone, such as <code>auth</code>.</p>', 'DescribeUserPoolDomainRequest$Domain' => '<p>The domain string. For custom domains, this is the fully-qualified domain name, such as <code>auth.example.com</code>. For Amazon Cognito prefix domains, this is the prefix alone, such as <code>auth</code>.</p>', 'DomainDescriptionType$Domain' => '<p>The domain string. For custom domains, this is the fully-qualified domain name, such as <code>auth.example.com</code>. For Amazon Cognito prefix domains, this is the prefix alone, such as <code>auth</code>.</p>', 'UpdateUserPoolDomainRequest$Domain' => '<p>The domain name for the custom domain that hosts the sign-up and sign-in pages for your application. One example might be <code>auth.example.com</code>. </p> <p>This string can include only lowercase letters, numbers, and hyphens. Don\'t use a hyphen for the first or last character. Use periods to separate subdomain names.</p>', 'UpdateUserPoolDomainResponse$CloudFrontDomain' => '<p>The Amazon CloudFront endpoint that Amazon Cognito set up when you added the custom domain to your user pool.</p>', 'UserPoolType$Domain' => '<p>The domain prefix, if the user pool has a domain associated with it.</p>', 'UserPoolType$CustomDomain' => '<p>A custom domain name that you provide to Amazon Cognito. This parameter applies only if you use a custom domain to host the sign-up and sign-in pages for your application. An example of a custom domain name might be <code>auth.example.com</code>.</p> <p>For more information about adding a custom domain to your user pool, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-add-custom-domain.html">Using Your Own Domain for the Hosted UI</a>.</p>', ], ], 'DomainVersionType' => [ 'base' => NULL, 'refs' => [ 'DomainDescriptionType$Version' => '<p>The app version.</p>', ], ], 'DuplicateProviderException' => [ 'base' => '<p>This exception is thrown when the provider is already supported by the user pool.</p>', 'refs' => [], ], 'EmailAddressType' => [ 'base' => NULL, 'refs' => [ 'EmailConfigurationType$ReplyToEmailAddress' => '<p>The destination to which the receiver of the email should reply.</p>', ], ], 'EmailConfigurationType' => [ 'base' => '<p>The email configuration of your user pool. The email configuration type sets your preferred sending method, Amazon Web Services Region, and sender for messages from your user pool.</p> <note> <p>Amazon Cognito can send email messages with Amazon Simple Email Service resources in the Amazon Web Services Region where you created your user pool, and in alternate Regions in some cases. For more information on the supported Regions, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-email.html">Email settings for Amazon Cognito user pools</a>.</p> </note>', 'refs' => [ 'CreateUserPoolRequest$EmailConfiguration' => '<p>The email configuration of your user pool. The email configuration type sets your preferred sending method, Amazon Web Services Region, and sender for messages from your user pool.</p>', 'UpdateUserPoolRequest$EmailConfiguration' => '<p>The email configuration of your user pool. The email configuration type sets your preferred sending method, Amazon Web Services Region, and sender for email invitation and verification messages from your user pool.</p>', 'UserPoolType$EmailConfiguration' => '<p>The email configuration of your user pool. The email configuration type sets your preferred sending method, Amazon Web Services Region, and sender for messages from your user pool.</p>', ], ], 'EmailNotificationBodyType' => [ 'base' => NULL, 'refs' => [ 'NotifyEmailType$HtmlBody' => '<p>The email HTML body.</p>', 'NotifyEmailType$TextBody' => '<p>The email text body.</p>', ], ], 'EmailNotificationSubjectType' => [ 'base' => NULL, 'refs' => [ 'NotifyEmailType$Subject' => '<p>The email subject.</p>', ], ], 'EmailSendingAccountType' => [ 'base' => NULL, 'refs' => [ 'EmailConfigurationType$EmailSendingAccount' => '<p>Specifies whether Amazon Cognito uses its built-in functionality to send your users email messages, or uses your Amazon Simple Email Service email configuration. Specify one of the following values:</p> <dl> <dt>COGNITO_DEFAULT</dt> <dd> <p>When Amazon Cognito emails your users, it uses its built-in email functionality. When you use the default option, Amazon Cognito allows only a limited number of emails each day for your user pool. For typical production environments, the default email limit is less than the required delivery volume. To achieve a higher delivery volume, specify DEVELOPER to use your Amazon SES email configuration.</p> <p>To look up the email delivery limit for the default option, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/limits.html">Limits</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <p>The default FROM address is <code>no-reply@verificationemail.com</code>. To customize the FROM address, provide the Amazon Resource Name (ARN) of an Amazon SES verified email address for the <code>SourceArn</code> parameter.</p> </dd> <dt>DEVELOPER</dt> <dd> <p>When Amazon Cognito emails your users, it uses your Amazon SES configuration. Amazon Cognito calls Amazon SES on your behalf to send email from your verified email address. When you use this option, the email delivery limits are the same limits that apply to your Amazon SES verified email address in your Amazon Web Services account.</p> <p>If you use this option, provide the ARN of an Amazon SES verified email address for the <code>SourceArn</code> parameter.</p> <p>Before Amazon Cognito can email your users, it requires additional permissions to call Amazon SES on your behalf. When you update your user pool with this option, Amazon Cognito creates a <i>service-linked role</i>, which is a type of role in your Amazon Web Services account. This role contains the permissions that allow you to access Amazon SES and send email messages from your email address. For more information about the service-linked role that Amazon Cognito creates, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/using-service-linked-roles.html">Using Service-Linked Roles for Amazon Cognito</a> in the <i>Amazon Cognito Developer Guide</i>.</p> </dd> </dl>', ], ], 'EmailVerificationMessageByLinkType' => [ 'base' => NULL, 'refs' => [ 'VerificationMessageTemplateType$EmailMessageByLink' => '<p>The email message template for sending a confirmation link to the user. You can set an <code>EmailMessageByLink</code> template only if the value of <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount"> EmailSendingAccount</a> is <code>DEVELOPER</code>. When your <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount">EmailSendingAccount</a> is <code>DEVELOPER</code>, your user pool sends email messages with your own Amazon SES configuration.</p>', ], ], 'EmailVerificationMessageType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolRequest$EmailVerificationMessage' => '<p>This parameter is no longer used. See <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html">VerificationMessageTemplateType</a>.</p>', 'MessageTemplateType$EmailMessage' => '<p>The message template for email messages. EmailMessage is allowed only if <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount">EmailSendingAccount</a> is DEVELOPER. </p>', 'UpdateUserPoolRequest$EmailVerificationMessage' => '<p>This parameter is no longer used. See <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html">VerificationMessageTemplateType</a>.</p>', 'UserPoolType$EmailVerificationMessage' => '<p>This parameter is no longer used. See <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html">VerificationMessageTemplateType</a>.</p>', 'VerificationMessageTemplateType$EmailMessage' => '<p>The template for email messages that Amazon Cognito sends to your users. You can set an <code>EmailMessage</code> template only if the value of <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount"> EmailSendingAccount</a> is <code>DEVELOPER</code>. When your <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount">EmailSendingAccount</a> is <code>DEVELOPER</code>, your user pool sends email messages with your own Amazon SES configuration.</p>', ], ], 'EmailVerificationSubjectByLinkType' => [ 'base' => NULL, 'refs' => [ 'VerificationMessageTemplateType$EmailSubjectByLink' => '<p>The subject line for the email message template for sending a confirmation link to the user. You can set an <code>EmailSubjectByLink</code> template only if the value of <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount"> EmailSendingAccount</a> is <code>DEVELOPER</code>. When your <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount">EmailSendingAccount</a> is <code>DEVELOPER</code>, your user pool sends email messages with your own Amazon SES configuration.</p>', ], ], 'EmailVerificationSubjectType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolRequest$EmailVerificationSubject' => '<p>This parameter is no longer used. See <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html">VerificationMessageTemplateType</a>.</p>', 'MessageTemplateType$EmailSubject' => '<p>The subject line for email messages. EmailSubject is allowed only if <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount">EmailSendingAccount</a> is DEVELOPER. </p>', 'UpdateUserPoolRequest$EmailVerificationSubject' => '<p>This parameter is no longer used. See <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html">VerificationMessageTemplateType</a>.</p>', 'UserPoolType$EmailVerificationSubject' => '<p>This parameter is no longer used. See <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html">VerificationMessageTemplateType</a>.</p>', 'VerificationMessageTemplateType$EmailSubject' => '<p>The subject line for the email message template. You can set an <code>EmailSubject</code> template only if the value of <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount"> EmailSendingAccount</a> is <code>DEVELOPER</code>. When your <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount">EmailSendingAccount</a> is <code>DEVELOPER</code>, your user pool sends email messages with your own Amazon SES configuration.</p>', ], ], 'EnableSoftwareTokenMFAException' => [ 'base' => '<p>This exception is thrown when there is a code mismatch and the service fails to configure the software token TOTP multi-factor authentication (MFA).</p>', 'refs' => [], ], 'EventContextDataType' => [ 'base' => '<p>Specifies the user context data captured at the time of an event request.</p>', 'refs' => [ 'AuthEventType$EventContextData' => '<p>The user context data captured at the time of an event request. This value provides additional information about the client from which event the request is received.</p>', ], ], 'EventFeedbackType' => [ 'base' => '<p>Specifies the event feedback type.</p>', 'refs' => [ 'AuthEventType$EventFeedback' => '<p>A flag specifying the user feedback captured at the time of an event request is good or bad. </p>', ], ], 'EventFilterType' => [ 'base' => NULL, 'refs' => [ 'EventFiltersType$member' => NULL, ], ], 'EventFiltersType' => [ 'base' => NULL, 'refs' => [ 'CompromisedCredentialsRiskConfigurationType$EventFilter' => '<p>Perform the action for these events. The default is to perform all events if no event filter is specified.</p>', ], ], 'EventIdType' => [ 'base' => NULL, 'refs' => [ 'AdminUpdateAuthEventFeedbackRequest$EventId' => '<p>The authentication event ID.</p>', 'UpdateAuthEventFeedbackRequest$EventId' => '<p>The event ID.</p>', ], ], 'EventResponseType' => [ 'base' => NULL, 'refs' => [ 'AuthEventType$EventResponse' => '<p>The event response.</p>', ], ], 'EventRiskType' => [ 'base' => '<p>The event risk type.</p>', 'refs' => [ 'AuthEventType$EventRisk' => '<p>The event risk.</p>', ], ], 'EventSourceName' => [ 'base' => NULL, 'refs' => [ 'LogConfigurationType$EventSource' => '<p>The source of events that your user pool sends for detailed activity logging.</p>', ], ], 'EventType' => [ 'base' => NULL, 'refs' => [ 'AuthEventType$EventType' => '<p>The event type.</p>', ], ], 'ExpiredCodeException' => [ 'base' => '<p>This exception is thrown if a code has expired.</p>', 'refs' => [], ], 'ExplicitAuthFlowsListType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolClientRequest$ExplicitAuthFlows' => '<p>The authentication flows that you want your user pool client to support. For each app client in your user pool, you can sign in your users with any combination of one or more flows, including with a user name and Secure Remote Password (SRP), a user name and password, or a custom authentication process that you define with Lambda functions.</p> <note> <p>If you don\'t specify a value for <code>ExplicitAuthFlows</code>, your user client supports <code>ALLOW_REFRESH_TOKEN_AUTH</code>, <code>ALLOW_USER_SRP_AUTH</code>, and <code>ALLOW_CUSTOM_AUTH</code>.</p> </note> <p>Valid values include:</p> <ul> <li> <p> <code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code>: Enable admin based user password authentication flow <code>ADMIN_USER_PASSWORD_AUTH</code>. This setting replaces the <code>ADMIN_NO_SRP_AUTH</code> setting. With this authentication flow, your app passes a user name and password to Amazon Cognito in the request, instead of using the Secure Remote Password (SRP) protocol to securely transmit the password.</p> </li> <li> <p> <code>ALLOW_CUSTOM_AUTH</code>: Enable Lambda trigger based authentication.</p> </li> <li> <p> <code>ALLOW_USER_PASSWORD_AUTH</code>: Enable user password-based authentication. In this flow, Amazon Cognito receives the password in the request instead of using the SRP protocol to verify passwords.</p> </li> <li> <p> <code>ALLOW_USER_SRP_AUTH</code>: Enable SRP-based authentication.</p> </li> <li> <p> <code>ALLOW_REFRESH_TOKEN_AUTH</code>: Enable authflow to refresh tokens.</p> </li> </ul> <p>In some environments, you will see the values <code>ADMIN_NO_SRP_AUTH</code>, <code>CUSTOM_AUTH_FLOW_ONLY</code>, or <code>USER_PASSWORD_AUTH</code>. You can\'t assign these legacy <code>ExplicitAuthFlows</code> values to user pool clients at the same time as values that begin with <code>ALLOW_</code>, like <code>ALLOW_USER_SRP_AUTH</code>.</p>', 'UpdateUserPoolClientRequest$ExplicitAuthFlows' => '<p>The authentication flows that you want your user pool client to support. For each app client in your user pool, you can sign in your users with any combination of one or more flows, including with a user name and Secure Remote Password (SRP), a user name and password, or a custom authentication process that you define with Lambda functions.</p> <note> <p>If you don\'t specify a value for <code>ExplicitAuthFlows</code>, your user client supports <code>ALLOW_REFRESH_TOKEN_AUTH</code>, <code>ALLOW_USER_SRP_AUTH</code>, and <code>ALLOW_CUSTOM_AUTH</code>.</p> </note> <p>Valid values include:</p> <ul> <li> <p> <code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code>: Enable admin based user password authentication flow <code>ADMIN_USER_PASSWORD_AUTH</code>. This setting replaces the <code>ADMIN_NO_SRP_AUTH</code> setting. With this authentication flow, your app passes a user name and password to Amazon Cognito in the request, instead of using the Secure Remote Password (SRP) protocol to securely transmit the password.</p> </li> <li> <p> <code>ALLOW_CUSTOM_AUTH</code>: Enable Lambda trigger based authentication.</p> </li> <li> <p> <code>ALLOW_USER_PASSWORD_AUTH</code>: Enable user password-based authentication. In this flow, Amazon Cognito receives the password in the request instead of using the SRP protocol to verify passwords.</p> </li> <li> <p> <code>ALLOW_USER_SRP_AUTH</code>: Enable SRP-based authentication.</p> </li> <li> <p> <code>ALLOW_REFRESH_TOKEN_AUTH</code>: Enable authflow to refresh tokens.</p> </li> </ul> <p>In some environments, you will see the values <code>ADMIN_NO_SRP_AUTH</code>, <code>CUSTOM_AUTH_FLOW_ONLY</code>, or <code>USER_PASSWORD_AUTH</code>. You can\'t assign these legacy <code>ExplicitAuthFlows</code> values to user pool clients at the same time as values that begin with <code>ALLOW_</code>, like <code>ALLOW_USER_SRP_AUTH</code>.</p>', 'UserPoolClientType$ExplicitAuthFlows' => '<p>The authentication flows that you want your user pool client to support. For each app client in your user pool, you can sign in your users with any combination of one or more flows, including with a user name and Secure Remote Password (SRP), a user name and password, or a custom authentication process that you define with Lambda functions.</p> <note> <p>If you don\'t specify a value for <code>ExplicitAuthFlows</code>, your user client supports <code>ALLOW_REFRESH_TOKEN_AUTH</code>, <code>ALLOW_USER_SRP_AUTH</code>, and <code>ALLOW_CUSTOM_AUTH</code>.</p> </note> <p>Valid values include:</p> <ul> <li> <p> <code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code>: Enable admin based user password authentication flow <code>ADMIN_USER_PASSWORD_AUTH</code>. This setting replaces the <code>ADMIN_NO_SRP_AUTH</code> setting. With this authentication flow, your app passes a user name and password to Amazon Cognito in the request, instead of using the Secure Remote Password (SRP) protocol to securely transmit the password.</p> </li> <li> <p> <code>ALLOW_CUSTOM_AUTH</code>: Enable Lambda trigger based authentication.</p> </li> <li> <p> <code>ALLOW_USER_PASSWORD_AUTH</code>: Enable user password-based authentication. In this flow, Amazon Cognito receives the password in the request instead of using the SRP protocol to verify passwords.</p> </li> <li> <p> <code>ALLOW_USER_SRP_AUTH</code>: Enable SRP-based authentication.</p> </li> <li> <p> <code>ALLOW_REFRESH_TOKEN_AUTH</code>: Enable authflow to refresh tokens.</p> </li> </ul> <p>In some environments, you will see the values <code>ADMIN_NO_SRP_AUTH</code>, <code>CUSTOM_AUTH_FLOW_ONLY</code>, or <code>USER_PASSWORD_AUTH</code>. You can\'t assign these legacy <code>ExplicitAuthFlows</code> values to user pool clients at the same time as values that begin with <code>ALLOW_</code>, like <code>ALLOW_USER_SRP_AUTH</code>.</p>', ], ], 'ExplicitAuthFlowsType' => [ 'base' => NULL, 'refs' => [ 'ExplicitAuthFlowsListType$member' => NULL, ], ], 'FeedbackValueType' => [ 'base' => NULL, 'refs' => [ 'AdminUpdateAuthEventFeedbackRequest$FeedbackValue' => '<p>The authentication event feedback value. When you provide a <code>FeedbackValue</code> value of <code>valid</code>, you tell Amazon Cognito that you trust a user session where Amazon Cognito has evaluated some level of risk. When you provide a <code>FeedbackValue</code> value of <code>invalid</code>, you tell Amazon Cognito that you don\'t trust a user session, or you don\'t believe that Amazon Cognito evaluated a high-enough risk level.</p>', 'EventFeedbackType$FeedbackValue' => '<p>The authentication event feedback value. When you provide a <code>FeedbackValue</code> value of <code>valid</code>, you tell Amazon Cognito that you trust a user session where Amazon Cognito has evaluated some level of risk. When you provide a <code>FeedbackValue</code> value of <code>invalid</code>, you tell Amazon Cognito that you don\'t trust a user session, or you don\'t believe that Amazon Cognito evaluated a high-enough risk level.</p>', 'UpdateAuthEventFeedbackRequest$FeedbackValue' => '<p>The authentication event feedback value. When you provide a <code>FeedbackValue</code> value of <code>valid</code>, you tell Amazon Cognito that you trust a user session where Amazon Cognito has evaluated some level of risk. When you provide a <code>FeedbackValue</code> value of <code>invalid</code>, you tell Amazon Cognito that you don\'t trust a user session, or you don\'t believe that Amazon Cognito evaluated a high-enough risk level.</p>', ], ], 'ForbiddenException' => [ 'base' => '<p>This exception is thrown when WAF doesn\'t allow your request based on a web ACL that\'s associated with your user pool.</p>', 'refs' => [], ], 'ForceAliasCreation' => [ 'base' => NULL, 'refs' => [ 'AdminCreateUserRequest$ForceAliasCreation' => '<p>This parameter is used only if the <code>phone_number_verified</code> or <code>email_verified</code> attribute is set to <code>True</code>. Otherwise, it is ignored.</p> <p>If this parameter is set to <code>True</code> and the phone number or email address specified in the UserAttributes parameter already exists as an alias with a different user, the API call will migrate the alias from the previous user to the newly created user. The previous user will no longer be able to log in using that alias.</p> <p>If this parameter is set to <code>False</code>, the API throws an <code>AliasExistsException</code> error if the alias already exists. The default value is <code>False</code>.</p>', 'ConfirmSignUpRequest$ForceAliasCreation' => '<p>Boolean to be specified to force user confirmation irrespective of existing alias. By default set to <code>False</code>. If this parameter is set to <code>True</code> and the phone number/email used for sign up confirmation already exists as an alias with a different user, the API call will migrate the alias from the previous user to the newly created user being confirmed. If set to <code>False</code>, the API will throw an <b>AliasExistsException</b> error.</p>', ], ], 'ForgetDeviceRequest' => [ 'base' => '<p>Represents the request to forget the device.</p>', 'refs' => [], ], 'ForgotPasswordRequest' => [ 'base' => '<p>Represents the request to reset a user\'s password.</p>', 'refs' => [], ], 'ForgotPasswordResponse' => [ 'base' => '<p>The response from Amazon Cognito to a request to reset a password.</p>', 'refs' => [], ], 'GenerateSecret' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolClientRequest$GenerateSecret' => '<p>Boolean to specify whether you want to generate a secret for the user pool client being created.</p>', ], ], 'GetCSVHeaderRequest' => [ 'base' => '<p>Represents the request to get the header information of the CSV file for the user import job.</p>', 'refs' => [], ], 'GetCSVHeaderResponse' => [ 'base' => '<p>Represents the response from the server to the request to get the header information of the CSV file for the user import job.</p>', 'refs' => [], ], 'GetDeviceRequest' => [ 'base' => '<p>Represents the request to get the device.</p>', 'refs' => [], ], 'GetDeviceResponse' => [ 'base' => '<p>Gets the device response.</p>', 'refs' => [], ], 'GetGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetIdentityProviderByIdentifierRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetIdentityProviderByIdentifierResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetLogDeliveryConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetLogDeliveryConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetSigningCertificateRequest' => [ 'base' => '<p>Request to get a signing certificate from Amazon Cognito.</p>', 'refs' => [], ], 'GetSigningCertificateResponse' => [ 'base' => '<p>Response from Amazon Cognito for a signing certificate request.</p>', 'refs' => [], ], 'GetUICustomizationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetUICustomizationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetUserAttributeVerificationCodeRequest' => [ 'base' => '<p>Represents the request to get user attribute verification.</p>', 'refs' => [], ], 'GetUserAttributeVerificationCodeResponse' => [ 'base' => '<p>The verification code response returned by the server response to get the user attribute verification code.</p>', 'refs' => [], ], 'GetUserPoolMfaConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetUserPoolMfaConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetUserRequest' => [ 'base' => '<p>Represents the request to get information about the user.</p>', 'refs' => [], ], 'GetUserResponse' => [ 'base' => '<p>Represents the response from the server from the request to get information about the user.</p>', 'refs' => [], ], 'GlobalSignOutRequest' => [ 'base' => '<p>Represents the request to sign out all devices.</p>', 'refs' => [], ], 'GlobalSignOutResponse' => [ 'base' => '<p>The response to the request to sign out all devices.</p>', 'refs' => [], ], 'GroupExistsException' => [ 'base' => '<p>This exception is thrown when Amazon Cognito encounters a group that already exists in the user pool.</p>', 'refs' => [], ], 'GroupListType' => [ 'base' => NULL, 'refs' => [ 'AdminListGroupsForUserResponse$Groups' => '<p>The groups that the user belongs to.</p>', 'ListGroupsResponse$Groups' => '<p>The group objects for the groups.</p>', ], ], 'GroupNameType' => [ 'base' => NULL, 'refs' => [ 'AdminAddUserToGroupRequest$GroupName' => '<p>The name of the group that you want to add your user to.</p>', 'AdminRemoveUserFromGroupRequest$GroupName' => '<p>The group name.</p>', 'CreateGroupRequest$GroupName' => '<p>The name of the group. Must be unique.</p>', 'DeleteGroupRequest$GroupName' => '<p>The name of the group.</p>', 'GetGroupRequest$GroupName' => '<p>The name of the group.</p>', 'GroupType$GroupName' => '<p>The name of the group.</p>', 'ListUsersInGroupRequest$GroupName' => '<p>The name of the group.</p>', 'UpdateGroupRequest$GroupName' => '<p>The name of the group.</p>', ], ], 'GroupType' => [ 'base' => '<p>The group type.</p>', 'refs' => [ 'CreateGroupResponse$Group' => '<p>The group object for the group.</p>', 'GetGroupResponse$Group' => '<p>The group object for the group.</p>', 'GroupListType$member' => NULL, 'UpdateGroupResponse$Group' => '<p>The group object for the group.</p>', ], ], 'HexStringType' => [ 'base' => NULL, 'refs' => [ 'AnalyticsConfigurationType$ApplicationId' => '<p>The application ID for an Amazon Pinpoint application.</p>', ], ], 'HttpHeader' => [ 'base' => '<p>The HTTP header.</p>', 'refs' => [ 'HttpHeaderList$member' => NULL, ], ], 'HttpHeaderList' => [ 'base' => NULL, 'refs' => [ 'ContextDataType$HttpHeaders' => '<p>HttpHeaders received on your server in same order.</p>', ], ], 'IdTokenValidityType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolClientRequest$IdTokenValidity' => '<p>The ID token time limit. After this limit expires, your user can\'t use their ID token. To specify the time unit for <code>IdTokenValidity</code> as <code>seconds</code>, <code>minutes</code>, <code>hours</code>, or <code>days</code>, set a <code>TokenValidityUnits</code> value in your API request.</p> <p>For example, when you set <code>IdTokenValidity</code> as <code>10</code> and <code>TokenValidityUnits</code> as <code>hours</code>, your user can authenticate their session with their ID token for 10 hours.</p> <p>The default time unit for <code>IdTokenValidity</code> in an API request is hours. <i>Valid range</i> is displayed below in seconds.</p> <p>If you don\'t specify otherwise in the configuration of your app client, your ID tokens are valid for one hour.</p>', 'UpdateUserPoolClientRequest$IdTokenValidity' => '<p>The ID token time limit. After this limit expires, your user can\'t use their ID token. To specify the time unit for <code>IdTokenValidity</code> as <code>seconds</code>, <code>minutes</code>, <code>hours</code>, or <code>days</code>, set a <code>TokenValidityUnits</code> value in your API request.</p> <p>For example, when you set <code>IdTokenValidity</code> as <code>10</code> and <code>TokenValidityUnits</code> as <code>hours</code>, your user can authenticate their session with their ID token for 10 hours.</p> <p>The default time unit for <code>IdTokenValidity</code> in an API request is hours. <i>Valid range</i> is displayed below in seconds.</p> <p>If you don\'t specify otherwise in the configuration of your app client, your ID tokens are valid for one hour.</p>', 'UserPoolClientType$IdTokenValidity' => '<p>The ID token time limit. After this limit expires, your user can\'t use their ID token. To specify the time unit for <code>IdTokenValidity</code> as <code>seconds</code>, <code>minutes</code>, <code>hours</code>, or <code>days</code>, set a <code>TokenValidityUnits</code> value in your API request.</p> <p>For example, when you set <code>IdTokenValidity</code> as <code>10</code> and <code>TokenValidityUnits</code> as <code>hours</code>, your user can authenticate their session with their ID token for 10 hours.</p> <p>The default time unit for <code>IdTokenValidity</code> in an API request is hours. <i>Valid range</i> is displayed below in seconds.</p> <p>If you don\'t specify otherwise in the configuration of your app client, your ID tokens are valid for one hour.</p>', ], ], 'IdentityProviderType' => [ 'base' => '<p>A container for information about an IdP.</p>', 'refs' => [ 'CreateIdentityProviderResponse$IdentityProvider' => '<p>The newly created IdP object.</p>', 'DescribeIdentityProviderResponse$IdentityProvider' => '<p>The identity provider details.</p>', 'GetIdentityProviderByIdentifierResponse$IdentityProvider' => '<p>The identity provider details.</p>', 'UpdateIdentityProviderResponse$IdentityProvider' => '<p>The identity provider details.</p>', ], ], 'IdentityProviderTypeType' => [ 'base' => NULL, 'refs' => [ 'CreateIdentityProviderRequest$ProviderType' => '<p>The IdP type.</p>', 'IdentityProviderType$ProviderType' => '<p>The IdP type.</p>', 'ProviderDescription$ProviderType' => '<p>The IdP type.</p>', ], ], 'IdpIdentifierType' => [ 'base' => NULL, 'refs' => [ 'GetIdentityProviderByIdentifierRequest$IdpIdentifier' => '<p>The IdP identifier.</p>', 'IdpIdentifiersListType$member' => NULL, ], ], 'IdpIdentifiersListType' => [ 'base' => NULL, 'refs' => [ 'CreateIdentityProviderRequest$IdpIdentifiers' => '<p>A list of IdP identifiers.</p>', 'IdentityProviderType$IdpIdentifiers' => '<p>A list of IdP identifiers.</p>', 'UpdateIdentityProviderRequest$IdpIdentifiers' => '<p>A list of IdP identifiers.</p>', ], ], 'ImageFileType' => [ 'base' => NULL, 'refs' => [ 'SetUICustomizationRequest$ImageFile' => '<p>The uploaded logo image for the UI customization.</p>', ], ], 'ImageUrlType' => [ 'base' => NULL, 'refs' => [ 'UICustomizationType$ImageUrl' => '<p>The logo image for the UI customization.</p>', ], ], 'InitiateAuthRequest' => [ 'base' => '<p>Initiates the authentication request.</p>', 'refs' => [], ], 'InitiateAuthResponse' => [ 'base' => '<p>Initiates the authentication response.</p>', 'refs' => [], ], 'IntegerType' => [ 'base' => NULL, 'refs' => [ 'AuthenticationResultType$ExpiresIn' => '<p>The expiration period of the authentication result in seconds.</p>', 'UserPoolType$EstimatedNumberOfUsers' => '<p>A number estimating the size of the user pool.</p>', ], ], 'InternalErrorException' => [ 'base' => '<p>This exception is thrown when Amazon Cognito encounters an internal error.</p>', 'refs' => [], ], 'InvalidEmailRoleAccessPolicyException' => [ 'base' => '<p>This exception is thrown when Amazon Cognito isn\'t allowed to use your email identity. HTTP status code: 400.</p>', 'refs' => [], ], 'InvalidLambdaResponseException' => [ 'base' => '<p>This exception is thrown when Amazon Cognito encounters an invalid Lambda response.</p>', 'refs' => [], ], 'InvalidOAuthFlowException' => [ 'base' => '<p>This exception is thrown when the specified OAuth flow is not valid.</p>', 'refs' => [], ], 'InvalidParameterException' => [ 'base' => '<p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>', 'refs' => [], ], 'InvalidPasswordException' => [ 'base' => '<p>This exception is thrown when Amazon Cognito encounters an invalid password.</p>', 'refs' => [], ], 'InvalidSmsRoleAccessPolicyException' => [ 'base' => '<p>This exception is returned when the role provided for SMS configuration doesn\'t have permission to publish using Amazon SNS.</p>', 'refs' => [], ], 'InvalidSmsRoleTrustRelationshipException' => [ 'base' => '<p>This exception is thrown when the trust relationship is not valid for the role provided for SMS configuration. This can happen if you don\'t trust <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is provided in the SMS configuration for the user pool.</p>', 'refs' => [], ], 'InvalidUserPoolConfigurationException' => [ 'base' => '<p>This exception is thrown when the user pool configuration is not valid.</p>', 'refs' => [], ], 'LambdaConfigType' => [ 'base' => '<p>Specifies the configuration for Lambda triggers.</p>', 'refs' => [ 'CreateUserPoolRequest$LambdaConfig' => '<p>The Lambda trigger configuration information for the new user pool.</p> <note> <p>In a push model, event sources (such as Amazon S3 and custom applications) need permission to invoke a function. So you must make an extra call to add permission for these event sources to invoke your Lambda function.</p> <p/> <p>For more information on using the Lambda API to add permission, see<a href="https://docs.aws.amazon.com/lambda/latest/dg/API_AddPermission.html"> AddPermission </a>. </p> <p>For adding permission using the CLI, see<a href="https://docs.aws.amazon.com/cli/latest/reference/lambda/add-permission.html"> add-permission </a>.</p> </note>', 'UpdateUserPoolRequest$LambdaConfig' => '<p>The Lambda configuration information from the request to update the user pool.</p>', 'UserPoolDescriptionType$LambdaConfig' => '<p>The Lambda configuration information in a user pool description.</p>', 'UserPoolType$LambdaConfig' => '<p>The Lambda triggers associated with the user pool.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>This exception is thrown when a user exceeds the limit for a requested Amazon Web Services resource.</p>', 'refs' => [], ], 'ListDevicesRequest' => [ 'base' => '<p>Represents the request to list the devices.</p>', 'refs' => [], ], 'ListDevicesResponse' => [ 'base' => '<p>Represents the response to list devices.</p>', 'refs' => [], ], 'ListGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListIdentityProvidersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListIdentityProvidersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListOfStringTypes' => [ 'base' => NULL, 'refs' => [ 'GetCSVHeaderResponse$CSVHeader' => '<p>The header information of the CSV file for the user import job.</p>', ], ], 'ListProvidersLimitType' => [ 'base' => NULL, 'refs' => [ 'ListIdentityProvidersRequest$MaxResults' => '<p>The maximum number of IdPs to return.</p>', ], ], 'ListResourceServersLimitType' => [ 'base' => NULL, 'refs' => [ 'ListResourceServersRequest$MaxResults' => '<p>The maximum number of resource servers to return.</p>', ], ], 'ListResourceServersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListResourceServersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListUserImportJobsRequest' => [ 'base' => '<p>Represents the request to list the user import jobs.</p>', 'refs' => [], ], 'ListUserImportJobsResponse' => [ 'base' => '<p>Represents the response from the server to the request to list the user import jobs.</p>', 'refs' => [], ], 'ListUserPoolClientsRequest' => [ 'base' => '<p>Represents the request to list the user pool clients.</p>', 'refs' => [], ], 'ListUserPoolClientsResponse' => [ 'base' => '<p>Represents the response from the server that lists user pool clients.</p>', 'refs' => [], ], 'ListUserPoolsRequest' => [ 'base' => '<p>Represents the request to list user pools.</p>', 'refs' => [], ], 'ListUserPoolsResponse' => [ 'base' => '<p>Represents the response to list user pools.</p>', 'refs' => [], ], 'ListUsersInGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListUsersInGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListUsersRequest' => [ 'base' => '<p>Represents the request to list users.</p>', 'refs' => [], ], 'ListUsersResponse' => [ 'base' => '<p>The response from the request to list users.</p>', 'refs' => [], ], 'LogConfigurationListType' => [ 'base' => NULL, 'refs' => [ 'LogDeliveryConfigurationType$LogConfigurations' => '<p>The detailed activity logging destination of a user pool.</p>', 'SetLogDeliveryConfigurationRequest$LogConfigurations' => '<p>A collection of all of the detailed activity logging configurations for a user pool.</p>', ], ], 'LogConfigurationType' => [ 'base' => '<p>The logging parameters of a user pool.</p>', 'refs' => [ 'LogConfigurationListType$member' => NULL, ], ], 'LogDeliveryConfigurationType' => [ 'base' => '<p>The logging parameters of a user pool.</p>', 'refs' => [ 'GetLogDeliveryConfigurationResponse$LogDeliveryConfiguration' => '<p>The detailed activity logging configuration of the requested user pool.</p>', 'SetLogDeliveryConfigurationResponse$LogDeliveryConfiguration' => '<p>The detailed activity logging configuration that you applied to the requested user pool.</p>', ], ], 'LogLevel' => [ 'base' => NULL, 'refs' => [ 'LogConfigurationType$LogLevel' => '<p>The <code>errorlevel</code> selection of logs that a user pool sends for detailed activity logging.</p>', ], ], 'LogoutURLsListType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolClientRequest$LogoutURLs' => '<p>A list of allowed logout URLs for the IdPs.</p>', 'UpdateUserPoolClientRequest$LogoutURLs' => '<p>A list of allowed logout URLs for the IdPs.</p>', 'UserPoolClientType$LogoutURLs' => '<p>A list of allowed logout URLs for the IdPs.</p>', ], ], 'LongType' => [ 'base' => NULL, 'refs' => [ 'UserImportJobType$ImportedUsers' => '<p>The number of users that were successfully imported.</p>', 'UserImportJobType$SkippedUsers' => '<p>The number of users that were skipped.</p>', 'UserImportJobType$FailedUsers' => '<p>The number of users that couldn\'t be imported.</p>', ], ], 'MFAMethodNotFoundException' => [ 'base' => '<p>This exception is thrown when Amazon Cognito can\'t find a multi-factor authentication (MFA) method.</p>', 'refs' => [], ], 'MFAOptionListType' => [ 'base' => NULL, 'refs' => [ 'AdminGetUserResponse$MFAOptions' => '<p> <i>This response parameter is no longer supported.</i> It provides information only about SMS MFA configurations. It doesn\'t provide information about time-based one-time password (TOTP) software token MFA configurations. To look up information about either type of MFA configuration, use UserMFASettingList instead.</p>', 'AdminSetUserSettingsRequest$MFAOptions' => '<p>You can use this parameter only to set an SMS configuration that uses SMS for delivery.</p>', 'GetUserResponse$MFAOptions' => '<p> <i>This response parameter is no longer supported.</i> It provides information only about SMS MFA configurations. It doesn\'t provide information about time-based one-time password (TOTP) software token MFA configurations. To look up information about either type of MFA configuration, use UserMFASettingList instead.</p>', 'SetUserSettingsRequest$MFAOptions' => '<p>You can use this parameter only to set an SMS configuration that uses SMS for delivery.</p>', 'UserType$MFAOptions' => '<p>The MFA options for the user.</p>', ], ], 'MFAOptionType' => [ 'base' => '<p> <i>This data type is no longer supported.</i> Applies only to SMS multi-factor authentication (MFA) configurations. Does not apply to time-based one-time password (TOTP) software token MFA configurations.</p>', 'refs' => [ 'MFAOptionListType$member' => NULL, ], ], 'MessageActionType' => [ 'base' => NULL, 'refs' => [ 'AdminCreateUserRequest$MessageAction' => '<p>Set to <code>RESEND</code> to resend the invitation message to a user that already exists and reset the expiration limit on the user\'s account. Set to <code>SUPPRESS</code> to suppress sending the message. You can specify only one value.</p>', ], ], 'MessageTemplateType' => [ 'base' => '<p>The message template structure.</p>', 'refs' => [ 'AdminCreateUserConfigType$InviteMessageTemplate' => '<p>The message template to be used for the welcome message to new users.</p> <p>See also <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-message-customizations.html#cognito-user-pool-settings-user-invitation-message-customization">Customizing User Invitation Messages</a>.</p>', ], ], 'MessageType' => [ 'base' => NULL, 'refs' => [ 'AliasExistsException$message' => '<p>The message that Amazon Cognito sends to the user when the value of an alias attribute is already linked to another user profile.</p>', 'CodeDeliveryFailureException$message' => '<p>The message sent when a verification code fails to deliver successfully.</p>', 'CodeMismatchException$message' => '<p>The message provided when the code mismatch exception is thrown.</p>', 'ConcurrentModificationException$message' => '<p>The message provided when the concurrent exception is thrown.</p>', 'DuplicateProviderException$message' => NULL, 'EnableSoftwareTokenMFAException$message' => NULL, 'ExpiredCodeException$message' => '<p>The message returned when the expired code exception is thrown.</p>', 'ForbiddenException$message' => '<p>The message returned when WAF doesn\'t allow your request based on a web ACL that\'s associated with your user pool.</p>', 'GroupExistsException$message' => NULL, 'InternalErrorException$message' => '<p>The message returned when Amazon Cognito throws an internal error exception.</p>', 'InvalidEmailRoleAccessPolicyException$message' => '<p>The message returned when you have an unverified email address or the identity policy isn\'t set on an email address that Amazon Cognito can access.</p>', 'InvalidLambdaResponseException$message' => '<p>The message returned when Amazon Cognito throws an invalid Lambda response exception.</p>', 'InvalidOAuthFlowException$message' => NULL, 'InvalidParameterException$message' => '<p>The message returned when the Amazon Cognito service throws an invalid parameter exception.</p>', 'InvalidPasswordException$message' => '<p>The message returned when Amazon Cognito throws an invalid user password exception.</p>', 'InvalidSmsRoleAccessPolicyException$message' => '<p>The message returned when the invalid SMS role access policy exception is thrown.</p>', 'InvalidSmsRoleTrustRelationshipException$message' => '<p>The message returned when the role trust relationship for the SMS message is not valid.</p>', 'InvalidUserPoolConfigurationException$message' => '<p>The message returned when the user pool configuration is not valid.</p>', 'LimitExceededException$message' => '<p>The message returned when Amazon Cognito throws a limit exceeded exception.</p>', 'MFAMethodNotFoundException$message' => '<p>The message returned when Amazon Cognito throws an MFA method not found exception.</p>', 'NotAuthorizedException$message' => '<p>The message returned when the Amazon Cognito service returns a not authorized exception.</p>', 'PasswordResetRequiredException$message' => '<p>The message returned when a password reset is required.</p>', 'PreconditionNotMetException$message' => '<p>The message returned when a precondition is not met.</p>', 'ResourceNotFoundException$message' => '<p>The message returned when the Amazon Cognito service returns a resource not found exception.</p>', 'ScopeDoesNotExistException$message' => NULL, 'SoftwareTokenMFANotFoundException$message' => NULL, 'TooManyFailedAttemptsException$message' => '<p>The message returned when Amazon Cognito returns a <code>TooManyFailedAttempts</code> exception.</p>', 'TooManyRequestsException$message' => '<p>The message returned when the Amazon Cognito service returns a too many requests exception.</p>', 'UnauthorizedException$message' => NULL, 'UnexpectedLambdaException$message' => '<p>The message returned when Amazon Cognito returns an unexpected Lambda exception.</p>', 'UnsupportedIdentityProviderException$message' => NULL, 'UnsupportedOperationException$message' => NULL, 'UnsupportedTokenTypeException$message' => NULL, 'UnsupportedUserStateException$message' => '<p>The message returned when the user is in an unsupported state.</p>', 'UserImportInProgressException$message' => '<p>The message returned when the user pool has an import job running.</p>', 'UserLambdaValidationException$message' => '<p>The message returned when the Amazon Cognito service returns a user validation exception with the Lambda service.</p>', 'UserNotConfirmedException$message' => '<p>The message returned when a user isn\'t confirmed successfully.</p>', 'UserNotFoundException$message' => '<p>The message returned when a user isn\'t found.</p>', 'UserPoolAddOnNotEnabledException$message' => NULL, 'UserPoolTaggingException$message' => NULL, 'UsernameExistsException$message' => '<p>The message returned when Amazon Cognito throws a user name exists exception.</p>', ], ], 'NewDeviceMetadataType' => [ 'base' => '<p>The new device metadata type.</p>', 'refs' => [ 'AuthenticationResultType$NewDeviceMetadata' => '<p>The new device metadata from an authentication result.</p>', ], ], 'NotAuthorizedException' => [ 'base' => '<p>This exception is thrown when a user isn\'t authorized.</p>', 'refs' => [], ], 'NotifyConfigurationType' => [ 'base' => '<p>The notify configuration type.</p>', 'refs' => [ 'AccountTakeoverRiskConfigurationType$NotifyConfiguration' => '<p>The notify configuration used to construct email notifications.</p>', ], ], 'NotifyEmailType' => [ 'base' => '<p>The notify email type.</p>', 'refs' => [ 'NotifyConfigurationType$BlockEmail' => '<p>Email template used when a detected risk event is blocked.</p>', 'NotifyConfigurationType$NoActionEmail' => '<p>The email template used when a detected risk event is allowed.</p>', 'NotifyConfigurationType$MfaEmail' => '<p>The multi-factor authentication (MFA) email template used when MFA is challenged as part of a detected risk.</p>', ], ], 'NumberAttributeConstraintsType' => [ 'base' => '<p>The minimum and maximum values of an attribute that is of the number data type.</p>', 'refs' => [ 'SchemaAttributeType$NumberAttributeConstraints' => '<p>Specifies the constraints for an attribute of the number type.</p>', ], ], 'OAuthFlowType' => [ 'base' => NULL, 'refs' => [ 'OAuthFlowsType$member' => NULL, ], ], 'OAuthFlowsType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolClientRequest$AllowedOAuthFlows' => '<p>The OAuth grant types that you want your app client to generate. To create an app client that generates client credentials grants, you must add <code>client_credentials</code> as the only allowed OAuth flow.</p> <dl> <dt>code</dt> <dd> <p>Use a code grant flow, which provides an authorization code as the response. This code can be exchanged for access tokens with the <code>/oauth2/token</code> endpoint.</p> </dd> <dt>implicit</dt> <dd> <p>Issue the access token (and, optionally, ID token, based on scopes) directly to your user.</p> </dd> <dt>client_credentials</dt> <dd> <p>Issue the access token from the <code>/oauth2/token</code> endpoint directly to a non-person user using a combination of the client ID and client secret.</p> </dd> </dl>', 'UpdateUserPoolClientRequest$AllowedOAuthFlows' => '<p>The allowed OAuth flows.</p> <dl> <dt>code</dt> <dd> <p>Use a code grant flow, which provides an authorization code as the response. This code can be exchanged for access tokens with the <code>/oauth2/token</code> endpoint.</p> </dd> <dt>implicit</dt> <dd> <p>Issue the access token (and, optionally, ID token, based on scopes) directly to your user.</p> </dd> <dt>client_credentials</dt> <dd> <p>Issue the access token from the <code>/oauth2/token</code> endpoint directly to a non-person user using a combination of the client ID and client secret.</p> </dd> </dl>', 'UserPoolClientType$AllowedOAuthFlows' => '<p>The allowed OAuth flows.</p> <dl> <dt>code</dt> <dd> <p>Use a code grant flow, which provides an authorization code as the response. This code can be exchanged for access tokens with the <code>/oauth2/token</code> endpoint.</p> </dd> <dt>implicit</dt> <dd> <p>Issue the access token (and, optionally, ID token, based on scopes) directly to your user.</p> </dd> <dt>client_credentials</dt> <dd> <p>Issue the access token from the <code>/oauth2/token</code> endpoint directly to a non-person user using a combination of the client ID and client secret.</p> </dd> </dl>', ], ], 'PaginationKey' => [ 'base' => NULL, 'refs' => [ 'AdminListGroupsForUserRequest$NextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'AdminListGroupsForUserResponse$NextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'AdminListUserAuthEventsRequest$NextToken' => '<p>A pagination token.</p>', 'AdminListUserAuthEventsResponse$NextToken' => '<p>A pagination token.</p>', 'ListGroupsRequest$NextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'ListGroupsResponse$NextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'ListUserPoolClientsRequest$NextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'ListUserPoolClientsResponse$NextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'ListUsersInGroupRequest$NextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'ListUsersInGroupResponse$NextToken' => '<p>An identifier that you can use in a later request to return the next set of items in the list.</p>', ], ], 'PaginationKeyType' => [ 'base' => NULL, 'refs' => [ 'ListIdentityProvidersRequest$NextToken' => '<p>A pagination token.</p>', 'ListIdentityProvidersResponse$NextToken' => '<p>A pagination token.</p>', 'ListResourceServersRequest$NextToken' => '<p>A pagination token.</p>', 'ListResourceServersResponse$NextToken' => '<p>A pagination token.</p>', 'ListUserImportJobsRequest$PaginationToken' => '<p>This API operation returns a limited number of results. The pagination token is an identifier that you can present in an additional API request with the same parameters. When you include the pagination token, Amazon Cognito returns the next set of items after the current list. Subsequent requests return a new pagination token. By use of this token, you can paginate through the full list of items.</p>', 'ListUserImportJobsResponse$PaginationToken' => '<p>The identifier that Amazon Cognito returned with the previous request to this operation. When you include a pagination token in your request, Amazon Cognito returns the next set of items in the list. By use of this token, you can paginate through the full list of items.</p>', 'ListUserPoolsRequest$NextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'ListUserPoolsResponse$NextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', ], ], 'PasswordPolicyMinLengthType' => [ 'base' => NULL, 'refs' => [ 'PasswordPolicyType$MinimumLength' => '<p>The minimum length of the password in the policy that you have set. This value can\'t be less than 6.</p>', ], ], 'PasswordPolicyType' => [ 'base' => '<p>The password policy type.</p>', 'refs' => [ 'UserPoolPolicyType$PasswordPolicy' => '<p>The password policy.</p>', ], ], 'PasswordResetRequiredException' => [ 'base' => '<p>This exception is thrown when a password reset is required.</p>', 'refs' => [], ], 'PasswordType' => [ 'base' => NULL, 'refs' => [ 'AdminCreateUserRequest$TemporaryPassword' => '<p>The user\'s temporary password. This password must conform to the password policy that you specified when you created the user pool.</p> <p>The temporary password is valid only once. To complete the Admin Create User flow, the user must enter the temporary password in the sign-in page, along with a new password to be used in all future sign-ins.</p> <p>This parameter isn\'t required. If you don\'t specify a value, Amazon Cognito generates one for you.</p> <p>The temporary password can only be used until the user account expiration limit that you set for your user pool. To reset the account after that time limit, you must call <code>AdminCreateUser</code> again and specify <code>RESEND</code> for the <code>MessageAction</code> parameter.</p>', 'AdminSetUserPasswordRequest$Password' => '<p>The password for the user.</p>', 'ChangePasswordRequest$PreviousPassword' => '<p>The old password.</p>', 'ChangePasswordRequest$ProposedPassword' => '<p>The new password.</p>', 'ConfirmForgotPasswordRequest$Password' => '<p>The new password that your user wants to set.</p>', 'SignUpRequest$Password' => '<p>The password of the user you want to register.</p>', ], ], 'PoolQueryLimitType' => [ 'base' => NULL, 'refs' => [ 'ListUserImportJobsRequest$MaxResults' => '<p>The maximum number of import jobs you want the request to return.</p>', 'ListUserPoolsRequest$MaxResults' => '<p>The maximum number of results you want the request to return when listing the user pools.</p>', ], ], 'PreSignedUrlType' => [ 'base' => NULL, 'refs' => [ 'UserImportJobType$PreSignedUrl' => '<p>The pre-signed URL to be used to upload the <code>.csv</code> file.</p>', ], ], 'PreTokenGenerationLambdaVersionType' => [ 'base' => NULL, 'refs' => [ 'PreTokenGenerationVersionConfigType$LambdaVersion' => '<p>The user pool trigger version of the request that Amazon Cognito sends to your Lambda function. Higher-numbered versions add fields that support new features.</p>', ], ], 'PreTokenGenerationVersionConfigType' => [ 'base' => '<p>The properties of a pre token generation Lambda trigger.</p>', 'refs' => [ 'LambdaConfigType$PreTokenGenerationConfig' => '<p>The detailed configuration of a pre token generation trigger. If you also set an ARN in <code>PreTokenGeneration</code>, its value must be identical to <code>PreTokenGenerationConfig</code>.</p>', ], ], 'PrecedenceType' => [ 'base' => NULL, 'refs' => [ 'CreateGroupRequest$Precedence' => '<p>A non-negative integer value that specifies the precedence of this group relative to the other groups that a user can belong to in the user pool. Zero is the highest precedence value. Groups with lower <code>Precedence</code> values take precedence over groups with higher or null <code>Precedence</code> values. If a user belongs to two or more groups, it is the group with the lowest precedence value whose role ARN is given in the user\'s tokens for the <code>cognito:roles</code> and <code>cognito:preferred_role</code> claims.</p> <p>Two groups can have the same <code>Precedence</code> value. If this happens, neither group takes precedence over the other. If two groups with the same <code>Precedence</code> have the same role ARN, that role is used in the <code>cognito:preferred_role</code> claim in tokens for users in each group. If the two groups have different role ARNs, the <code>cognito:preferred_role</code> claim isn\'t set in users\' tokens.</p> <p>The default <code>Precedence</code> value is null. The maximum <code>Precedence</code> value is <code>2^31-1</code>.</p>', 'GroupType$Precedence' => '<p>A non-negative integer value that specifies the precedence of this group relative to the other groups that a user can belong to in the user pool. Zero is the highest precedence value. Groups with lower <code>Precedence</code> values take precedence over groups with higher ornull <code>Precedence</code> values. If a user belongs to two or more groups, it is the group with the lowest precedence value whose role ARN is given in the user\'s tokens for the <code>cognito:roles</code> and <code>cognito:preferred_role</code> claims.</p> <p>Two groups can have the same <code>Precedence</code> value. If this happens, neither group takes precedence over the other. If two groups with the same <code>Precedence</code> have the same role ARN, that role is used in the <code>cognito:preferred_role</code> claim in tokens for users in each group. If the two groups have different role ARNs, the <code>cognito:preferred_role</code> claim isn\'t set in users\' tokens.</p> <p>The default <code>Precedence</code> value is null.</p>', 'UpdateGroupRequest$Precedence' => '<p>The new precedence value for the group. For more information about this parameter, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateGroup.html">CreateGroup</a>.</p>', ], ], 'PreconditionNotMetException' => [ 'base' => '<p>This exception is thrown when a precondition is not met.</p>', 'refs' => [], ], 'PreventUserExistenceErrorTypes' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolClientRequest$PreventUserExistenceErrors' => '<p>Errors and responses that you want Amazon Cognito APIs to return during authentication, account confirmation, and password recovery when the user doesn\'t exist in the user pool. When set to <code>ENABLED</code> and the user doesn\'t exist, authentication returns an error indicating either the username or password was incorrect. Account confirmation and password recovery return a response indicating a code was sent to a simulated destination. When set to <code>LEGACY</code>, those APIs return a <code>UserNotFoundException</code> exception if the user doesn\'t exist in the user pool.</p> <p>Valid values include:</p> <ul> <li> <p> <code>ENABLED</code> - This prevents user existence-related errors.</p> </li> <li> <p> <code>LEGACY</code> - This represents the early behavior of Amazon Cognito where user existence related errors aren\'t prevented.</p> </li> </ul>', 'UpdateUserPoolClientRequest$PreventUserExistenceErrors' => '<p>Errors and responses that you want Amazon Cognito APIs to return during authentication, account confirmation, and password recovery when the user doesn\'t exist in the user pool. When set to <code>ENABLED</code> and the user doesn\'t exist, authentication returns an error indicating either the username or password was incorrect. Account confirmation and password recovery return a response indicating a code was sent to a simulated destination. When set to <code>LEGACY</code>, those APIs return a <code>UserNotFoundException</code> exception if the user doesn\'t exist in the user pool.</p> <p>Valid values include:</p> <ul> <li> <p> <code>ENABLED</code> - This prevents user existence-related errors.</p> </li> <li> <p> <code>LEGACY</code> - This represents the early behavior of Amazon Cognito where user existence related errors aren\'t prevented.</p> </li> </ul>', 'UserPoolClientType$PreventUserExistenceErrors' => '<p>Errors and responses that you want Amazon Cognito APIs to return during authentication, account confirmation, and password recovery when the user doesn\'t exist in the user pool. When set to <code>ENABLED</code> and the user doesn\'t exist, authentication returns an error indicating either the username or password was incorrect. Account confirmation and password recovery return a response indicating a code was sent to a simulated destination. When set to <code>LEGACY</code>, those APIs return a <code>UserNotFoundException</code> exception if the user doesn\'t exist in the user pool.</p> <p>Valid values include:</p> <ul> <li> <p> <code>ENABLED</code> - This prevents user existence-related errors.</p> </li> <li> <p> <code>LEGACY</code> - This represents the old behavior of Amazon Cognito where user existence related errors aren\'t prevented.</p> </li> </ul>', ], ], 'PriorityType' => [ 'base' => NULL, 'refs' => [ 'RecoveryOptionType$Priority' => '<p>A positive integer specifying priority of a method with 1 being the highest priority.</p>', ], ], 'ProviderDescription' => [ 'base' => '<p>A container for IdP details.</p>', 'refs' => [ 'ProvidersListType$member' => NULL, ], ], 'ProviderDetailsType' => [ 'base' => NULL, 'refs' => [ 'CreateIdentityProviderRequest$ProviderDetails' => '<p>The scopes, URLs, and identifiers for your external identity provider. The following examples describe the provider detail keys for each IdP type. These values and their schema are subject to change. Social IdP <code>authorize_scopes</code> values must match the values listed here.</p> <dl> <dt>OpenID Connect (OIDC)</dt> <dd> <p>Amazon Cognito accepts the following elements when it can\'t discover endpoint URLs from <code>oidc_issuer</code>: <code>attributes_url</code>, <code>authorize_url</code>, <code>jwks_uri</code>, <code>token_url</code>.</p> <p>Create or update request: <code>"ProviderDetails": { "attributes_request_method": "GET", "attributes_url": "https://auth.example.com/userInfo", "authorize_scopes": "openid profile email", "authorize_url": "https://auth.example.com/authorize", "client_id": "1example23456789", "client_secret": "provider-app-client-secret", "jwks_uri": "https://auth.example.com/.well-known/jwks.json", "oidc_issuer": "https://auth.example.com", "token_url": "https://example.com/token" }</code> </p> <p>Describe response: <code>"ProviderDetails": { "attributes_request_method": "GET", "attributes_url": "https://auth.example.com/userInfo", "attributes_url_add_attributes": "false", "authorize_scopes": "openid profile email", "authorize_url": "https://auth.example.com/authorize", "client_id": "1example23456789", "client_secret": "provider-app-client-secret", "jwks_uri": "https://auth.example.com/.well-known/jwks.json", "oidc_issuer": "https://auth.example.com", "token_url": "https://example.com/token" }</code> </p> </dd> <dt>SAML</dt> <dd> <p>Create or update request with Metadata URL: <code>"ProviderDetails": { "IDPInit": "true", "IDPSignout": "true", "EncryptedResponses" : "true", "MetadataURL": "https://auth.example.com/sso/saml/metadata", "RequestSigningAlgorithm": "rsa-sha256" }</code> </p> <p>Create or update request with Metadata file: <code>"ProviderDetails": { "IDPInit": "true", "IDPSignout": "true", "EncryptedResponses" : "true", "MetadataFile": "[metadata XML]", "RequestSigningAlgorithm": "rsa-sha256" }</code> </p> <p>The value of <code>MetadataFile</code> must be the plaintext metadata document with all quote (") characters escaped by backslashes.</p> <p>Describe response: <code>"ProviderDetails": { "IDPInit": "true", "IDPSignout": "true", "EncryptedResponses" : "true", "ActiveEncryptionCertificate": "[certificate]", "MetadataURL": "https://auth.example.com/sso/saml/metadata", "RequestSigningAlgorithm": "rsa-sha256", "SLORedirectBindingURI": "https://auth.example.com/slo/saml", "SSORedirectBindingURI": "https://auth.example.com/sso/saml" }</code> </p> </dd> <dt>LoginWithAmazon</dt> <dd> <p>Create or update request: <code>"ProviderDetails": { "authorize_scopes": "profile postal_code", "client_id": "amzn1.application-oa2-client.1example23456789", "client_secret": "provider-app-client-secret"</code> </p> <p>Describe response: <code>"ProviderDetails": { "attributes_url": "https://api.amazon.com/user/profile", "attributes_url_add_attributes": "false", "authorize_scopes": "profile postal_code", "authorize_url": "https://www.amazon.com/ap/oa", "client_id": "amzn1.application-oa2-client.1example23456789", "client_secret": "provider-app-client-secret", "token_request_method": "POST", "token_url": "https://api.amazon.com/auth/o2/token" }</code> </p> </dd> <dt>Google</dt> <dd> <p>Create or update request: <code>"ProviderDetails": { "authorize_scopes": "email profile openid", "client_id": "1example23456789.apps.googleusercontent.com", "client_secret": "provider-app-client-secret" }</code> </p> <p>Describe response: <code>"ProviderDetails": { "attributes_url": "https://people.googleapis.com/v1/people/me?personFields=", "attributes_url_add_attributes": "true", "authorize_scopes": "email profile openid", "authorize_url": "https://accounts.google.com/o/oauth2/v2/auth", "client_id": "1example23456789.apps.googleusercontent.com", "client_secret": "provider-app-client-secret", "oidc_issuer": "https://accounts.google.com", "token_request_method": "POST", "token_url": "https://www.googleapis.com/oauth2/v4/token" }</code> </p> </dd> <dt>SignInWithApple</dt> <dd> <p>Create or update request: <code>"ProviderDetails": { "authorize_scopes": "email name", "client_id": "com.example.cognito", "private_key": "1EXAMPLE", "key_id": "2EXAMPLE", "team_id": "3EXAMPLE" }</code> </p> <p>Describe response: <code>"ProviderDetails": { "attributes_url_add_attributes": "false", "authorize_scopes": "email name", "authorize_url": "https://appleid.apple.com/auth/authorize", "client_id": "com.example.cognito", "key_id": "1EXAMPLE", "oidc_issuer": "https://appleid.apple.com", "team_id": "2EXAMPLE", "token_request_method": "POST", "token_url": "https://appleid.apple.com/auth/token" }</code> </p> </dd> <dt>Facebook</dt> <dd> <p>Create or update request: <code>"ProviderDetails": { "api_version": "v17.0", "authorize_scopes": "public_profile, email", "client_id": "1example23456789", "client_secret": "provider-app-client-secret" }</code> </p> <p>Describe response: <code>"ProviderDetails": { "api_version": "v17.0", "attributes_url": "https://graph.facebook.com/v17.0/me?fields=", "attributes_url_add_attributes": "true", "authorize_scopes": "public_profile, email", "authorize_url": "https://www.facebook.com/v17.0/dialog/oauth", "client_id": "1example23456789", "client_secret": "provider-app-client-secret", "token_request_method": "GET", "token_url": "https://graph.facebook.com/v17.0/oauth/access_token" }</code> </p> </dd> </dl>', 'IdentityProviderType$ProviderDetails' => '<p>The scopes, URLs, and identifiers for your external identity provider. The following examples describe the provider detail keys for each IdP type. These values and their schema are subject to change. Social IdP <code>authorize_scopes</code> values must match the values listed here.</p> <dl> <dt>OpenID Connect (OIDC)</dt> <dd> <p>Amazon Cognito accepts the following elements when it can\'t discover endpoint URLs from <code>oidc_issuer</code>: <code>attributes_url</code>, <code>authorize_url</code>, <code>jwks_uri</code>, <code>token_url</code>.</p> <p>Create or update request: <code>"ProviderDetails": { "attributes_request_method": "GET", "attributes_url": "https://auth.example.com/userInfo", "authorize_scopes": "openid profile email", "authorize_url": "https://auth.example.com/authorize", "client_id": "1example23456789", "client_secret": "provider-app-client-secret", "jwks_uri": "https://auth.example.com/.well-known/jwks.json", "oidc_issuer": "https://auth.example.com", "token_url": "https://example.com/token" }</code> </p> <p>Describe response: <code>"ProviderDetails": { "attributes_request_method": "GET", "attributes_url": "https://auth.example.com/userInfo", "attributes_url_add_attributes": "false", "authorize_scopes": "openid profile email", "authorize_url": "https://auth.example.com/authorize", "client_id": "1example23456789", "client_secret": "provider-app-client-secret", "jwks_uri": "https://auth.example.com/.well-known/jwks.json", "oidc_issuer": "https://auth.example.com", "token_url": "https://example.com/token" }</code> </p> </dd> <dt>SAML</dt> <dd> <p>Create or update request with Metadata URL: <code>"ProviderDetails": { "IDPInit": "true", "IDPSignout": "true", "EncryptedResponses" : "true", "MetadataURL": "https://auth.example.com/sso/saml/metadata", "RequestSigningAlgorithm": "rsa-sha256" }</code> </p> <p>Create or update request with Metadata file: <code>"ProviderDetails": { "IDPInit": "true", "IDPSignout": "true", "EncryptedResponses" : "true", "MetadataFile": "[metadata XML]", "RequestSigningAlgorithm": "rsa-sha256" }</code> </p> <p>The value of <code>MetadataFile</code> must be the plaintext metadata document with all quote (") characters escaped by backslashes.</p> <p>Describe response: <code>"ProviderDetails": { "IDPInit": "true", "IDPSignout": "true", "EncryptedResponses" : "true", "ActiveEncryptionCertificate": "[certificate]", "MetadataURL": "https://auth.example.com/sso/saml/metadata", "RequestSigningAlgorithm": "rsa-sha256", "SLORedirectBindingURI": "https://auth.example.com/slo/saml", "SSORedirectBindingURI": "https://auth.example.com/sso/saml" }</code> </p> </dd> <dt>LoginWithAmazon</dt> <dd> <p>Create or update request: <code>"ProviderDetails": { "authorize_scopes": "profile postal_code", "client_id": "amzn1.application-oa2-client.1example23456789", "client_secret": "provider-app-client-secret"</code> </p> <p>Describe response: <code>"ProviderDetails": { "attributes_url": "https://api.amazon.com/user/profile", "attributes_url_add_attributes": "false", "authorize_scopes": "profile postal_code", "authorize_url": "https://www.amazon.com/ap/oa", "client_id": "amzn1.application-oa2-client.1example23456789", "client_secret": "provider-app-client-secret", "token_request_method": "POST", "token_url": "https://api.amazon.com/auth/o2/token" }</code> </p> </dd> <dt>Google</dt> <dd> <p>Create or update request: <code>"ProviderDetails": { "authorize_scopes": "email profile openid", "client_id": "1example23456789.apps.googleusercontent.com", "client_secret": "provider-app-client-secret" }</code> </p> <p>Describe response: <code>"ProviderDetails": { "attributes_url": "https://people.googleapis.com/v1/people/me?personFields=", "attributes_url_add_attributes": "true", "authorize_scopes": "email profile openid", "authorize_url": "https://accounts.google.com/o/oauth2/v2/auth", "client_id": "1example23456789.apps.googleusercontent.com", "client_secret": "provider-app-client-secret", "oidc_issuer": "https://accounts.google.com", "token_request_method": "POST", "token_url": "https://www.googleapis.com/oauth2/v4/token" }</code> </p> </dd> <dt>SignInWithApple</dt> <dd> <p>Create or update request: <code>"ProviderDetails": { "authorize_scopes": "email name", "client_id": "com.example.cognito", "private_key": "1EXAMPLE", "key_id": "2EXAMPLE", "team_id": "3EXAMPLE" }</code> </p> <p>Describe response: <code>"ProviderDetails": { "attributes_url_add_attributes": "false", "authorize_scopes": "email name", "authorize_url": "https://appleid.apple.com/auth/authorize", "client_id": "com.example.cognito", "key_id": "1EXAMPLE", "oidc_issuer": "https://appleid.apple.com", "team_id": "2EXAMPLE", "token_request_method": "POST", "token_url": "https://appleid.apple.com/auth/token" }</code> </p> </dd> <dt>Facebook</dt> <dd> <p>Create or update request: <code>"ProviderDetails": { "api_version": "v17.0", "authorize_scopes": "public_profile, email", "client_id": "1example23456789", "client_secret": "provider-app-client-secret" }</code> </p> <p>Describe response: <code>"ProviderDetails": { "api_version": "v17.0", "attributes_url": "https://graph.facebook.com/v17.0/me?fields=", "attributes_url_add_attributes": "true", "authorize_scopes": "public_profile, email", "authorize_url": "https://www.facebook.com/v17.0/dialog/oauth", "client_id": "1example23456789", "client_secret": "provider-app-client-secret", "token_request_method": "GET", "token_url": "https://graph.facebook.com/v17.0/oauth/access_token" }</code> </p> </dd> </dl>', 'UpdateIdentityProviderRequest$ProviderDetails' => '<p>The scopes, URLs, and identifiers for your external identity provider. The following examples describe the provider detail keys for each IdP type. These values and their schema are subject to change. Social IdP <code>authorize_scopes</code> values must match the values listed here.</p> <dl> <dt>OpenID Connect (OIDC)</dt> <dd> <p>Amazon Cognito accepts the following elements when it can\'t discover endpoint URLs from <code>oidc_issuer</code>: <code>attributes_url</code>, <code>authorize_url</code>, <code>jwks_uri</code>, <code>token_url</code>.</p> <p>Create or update request: <code>"ProviderDetails": { "attributes_request_method": "GET", "attributes_url": "https://auth.example.com/userInfo", "authorize_scopes": "openid profile email", "authorize_url": "https://auth.example.com/authorize", "client_id": "1example23456789", "client_secret": "provider-app-client-secret", "jwks_uri": "https://auth.example.com/.well-known/jwks.json", "oidc_issuer": "https://auth.example.com", "token_url": "https://example.com/token" }</code> </p> <p>Describe response: <code>"ProviderDetails": { "attributes_request_method": "GET", "attributes_url": "https://auth.example.com/userInfo", "attributes_url_add_attributes": "false", "authorize_scopes": "openid profile email", "authorize_url": "https://auth.example.com/authorize", "client_id": "1example23456789", "client_secret": "provider-app-client-secret", "jwks_uri": "https://auth.example.com/.well-known/jwks.json", "oidc_issuer": "https://auth.example.com", "token_url": "https://example.com/token" }</code> </p> </dd> <dt>SAML</dt> <dd> <p>Create or update request with Metadata URL: <code>"ProviderDetails": { "IDPInit": "true", "IDPSignout": "true", "EncryptedResponses" : "true", "MetadataURL": "https://auth.example.com/sso/saml/metadata", "RequestSigningAlgorithm": "rsa-sha256" }</code> </p> <p>Create or update request with Metadata file: <code>"ProviderDetails": { "IDPInit": "true", "IDPSignout": "true", "EncryptedResponses" : "true", "MetadataFile": "[metadata XML]", "RequestSigningAlgorithm": "rsa-sha256" }</code> </p> <p>The value of <code>MetadataFile</code> must be the plaintext metadata document with all quote (") characters escaped by backslashes.</p> <p>Describe response: <code>"ProviderDetails": { "IDPInit": "true", "IDPSignout": "true", "EncryptedResponses" : "true", "ActiveEncryptionCertificate": "[certificate]", "MetadataURL": "https://auth.example.com/sso/saml/metadata", "RequestSigningAlgorithm": "rsa-sha256", "SLORedirectBindingURI": "https://auth.example.com/slo/saml", "SSORedirectBindingURI": "https://auth.example.com/sso/saml" }</code> </p> </dd> <dt>LoginWithAmazon</dt> <dd> <p>Create or update request: <code>"ProviderDetails": { "authorize_scopes": "profile postal_code", "client_id": "amzn1.application-oa2-client.1example23456789", "client_secret": "provider-app-client-secret"</code> </p> <p>Describe response: <code>"ProviderDetails": { "attributes_url": "https://api.amazon.com/user/profile", "attributes_url_add_attributes": "false", "authorize_scopes": "profile postal_code", "authorize_url": "https://www.amazon.com/ap/oa", "client_id": "amzn1.application-oa2-client.1example23456789", "client_secret": "provider-app-client-secret", "token_request_method": "POST", "token_url": "https://api.amazon.com/auth/o2/token" }</code> </p> </dd> <dt>Google</dt> <dd> <p>Create or update request: <code>"ProviderDetails": { "authorize_scopes": "email profile openid", "client_id": "1example23456789.apps.googleusercontent.com", "client_secret": "provider-app-client-secret" }</code> </p> <p>Describe response: <code>"ProviderDetails": { "attributes_url": "https://people.googleapis.com/v1/people/me?personFields=", "attributes_url_add_attributes": "true", "authorize_scopes": "email profile openid", "authorize_url": "https://accounts.google.com/o/oauth2/v2/auth", "client_id": "1example23456789.apps.googleusercontent.com", "client_secret": "provider-app-client-secret", "oidc_issuer": "https://accounts.google.com", "token_request_method": "POST", "token_url": "https://www.googleapis.com/oauth2/v4/token" }</code> </p> </dd> <dt>SignInWithApple</dt> <dd> <p>Create or update request: <code>"ProviderDetails": { "authorize_scopes": "email name", "client_id": "com.example.cognito", "private_key": "1EXAMPLE", "key_id": "2EXAMPLE", "team_id": "3EXAMPLE" }</code> </p> <p>Describe response: <code>"ProviderDetails": { "attributes_url_add_attributes": "false", "authorize_scopes": "email name", "authorize_url": "https://appleid.apple.com/auth/authorize", "client_id": "com.example.cognito", "key_id": "1EXAMPLE", "oidc_issuer": "https://appleid.apple.com", "team_id": "2EXAMPLE", "token_request_method": "POST", "token_url": "https://appleid.apple.com/auth/token" }</code> </p> </dd> <dt>Facebook</dt> <dd> <p>Create or update request: <code>"ProviderDetails": { "api_version": "v17.0", "authorize_scopes": "public_profile, email", "client_id": "1example23456789", "client_secret": "provider-app-client-secret" }</code> </p> <p>Describe response: <code>"ProviderDetails": { "api_version": "v17.0", "attributes_url": "https://graph.facebook.com/v17.0/me?fields=", "attributes_url_add_attributes": "true", "authorize_scopes": "public_profile, email", "authorize_url": "https://www.facebook.com/v17.0/dialog/oauth", "client_id": "1example23456789", "client_secret": "provider-app-client-secret", "token_request_method": "GET", "token_url": "https://graph.facebook.com/v17.0/oauth/access_token" }</code> </p> </dd> </dl>', ], ], 'ProviderNameType' => [ 'base' => NULL, 'refs' => [ 'DeleteIdentityProviderRequest$ProviderName' => '<p>The IdP name.</p>', 'DescribeIdentityProviderRequest$ProviderName' => '<p>The IdP name.</p>', 'IdentityProviderType$ProviderName' => '<p>The IdP name.</p>', 'ProviderDescription$ProviderName' => '<p>The IdP name.</p>', 'ProviderUserIdentifierType$ProviderName' => '<p>The name of the provider, such as Facebook, Google, or Login with Amazon.</p>', 'SupportedIdentityProvidersListType$member' => NULL, 'UpdateIdentityProviderRequest$ProviderName' => '<p>The IdP name.</p>', ], ], 'ProviderNameTypeV2' => [ 'base' => NULL, 'refs' => [ 'CreateIdentityProviderRequest$ProviderName' => '<p>The IdP name.</p>', ], ], 'ProviderUserIdentifierType' => [ 'base' => '<p>A container for information about an IdP for a user pool.</p>', 'refs' => [ 'AdminDisableProviderForUserRequest$User' => '<p>The user to be disabled.</p>', 'AdminLinkProviderForUserRequest$DestinationUser' => '<p>The existing user in the user pool that you want to assign to the external IdP user account. This user can be a local (Username + Password) Amazon Cognito user pools user or a federated user (for example, a SAML or Facebook user). If the user doesn\'t exist, Amazon Cognito generates an exception. Amazon Cognito returns this user when the new user (with the linked IdP attribute) signs in.</p> <p>For a native username + password user, the <code>ProviderAttributeValue</code> for the <code>DestinationUser</code> should be the username in the user pool. For a federated user, it should be the provider-specific <code>user_id</code>.</p> <p>The <code>ProviderAttributeName</code> of the <code>DestinationUser</code> is ignored.</p> <p>The <code>ProviderName</code> should be set to <code>Cognito</code> for users in Cognito user pools.</p> <important> <p>All attributes in the DestinationUser profile must be mutable. If you have assigned the user any immutable custom attributes, the operation won\'t succeed.</p> </important>', 'AdminLinkProviderForUserRequest$SourceUser' => '<p>An external IdP account for a user who doesn\'t exist yet in the user pool. This user must be a federated user (for example, a SAML or Facebook user), not another native user.</p> <p>If the <code>SourceUser</code> is using a federated social IdP, such as Facebook, Google, or Login with Amazon, you must set the <code>ProviderAttributeName</code> to <code>Cognito_Subject</code>. For social IdPs, the <code>ProviderName</code> will be <code>Facebook</code>, <code>Google</code>, or <code>LoginWithAmazon</code>, and Amazon Cognito will automatically parse the Facebook, Google, and Login with Amazon tokens for <code>id</code>, <code>sub</code>, and <code>user_id</code>, respectively. The <code>ProviderAttributeValue</code> for the user must be the same value as the <code>id</code>, <code>sub</code>, or <code>user_id</code> value found in the social IdP token.</p> <p/> <p>For OIDC, the <code>ProviderAttributeName</code> can be any value that matches a claim in the ID token, or that your app retrieves from the <code>userInfo</code> endpoint. You must map the claim to a user pool attribute in your IdP configuration, and set the user pool attribute name as the value of <code>ProviderAttributeName</code> in your <code>AdminLinkProviderForUser</code> request.</p> <p>For SAML, the <code>ProviderAttributeName</code> can be any value that matches a claim in the SAML assertion. To link SAML users based on the subject of the SAML assertion, map the subject to a claim through the SAML IdP and set that claim name as the value of <code>ProviderAttributeName</code> in your <code>AdminLinkProviderForUser</code> request.</p> <p>For both OIDC and SAML users, when you set <code>ProviderAttributeName</code> to <code>Cognito_Subject</code>, Amazon Cognito will automatically parse the default unique identifier found in the subject from the IdP token.</p>', ], ], 'ProvidersListType' => [ 'base' => NULL, 'refs' => [ 'ListIdentityProvidersResponse$Providers' => '<p>A list of IdP objects.</p>', ], ], 'QueryLimit' => [ 'base' => NULL, 'refs' => [ 'ListUserPoolClientsRequest$MaxResults' => '<p>The maximum number of results you want the request to return when listing the user pool clients.</p>', ], ], 'QueryLimitType' => [ 'base' => NULL, 'refs' => [ 'AdminListDevicesRequest$Limit' => '<p>The limit of the devices request.</p>', 'AdminListGroupsForUserRequest$Limit' => '<p>The limit of the request to list groups.</p>', 'AdminListUserAuthEventsRequest$MaxResults' => '<p>The maximum number of authentication events to return. Returns 60 events if you set <code>MaxResults</code> to 0, or if you don\'t include a <code>MaxResults</code> parameter.</p>', 'ListDevicesRequest$Limit' => '<p>The limit of the device request.</p>', 'ListGroupsRequest$Limit' => '<p>The limit of the request to list groups.</p>', 'ListUsersInGroupRequest$Limit' => '<p>The maximum number of users that you want to retrieve before pagination.</p>', 'ListUsersRequest$Limit' => '<p>Maximum number of users to be returned.</p>', ], ], 'RecoveryMechanismsType' => [ 'base' => NULL, 'refs' => [ 'AccountRecoverySettingType$RecoveryMechanisms' => '<p>The list of <code>RecoveryOptionTypes</code>.</p>', ], ], 'RecoveryOptionNameType' => [ 'base' => NULL, 'refs' => [ 'RecoveryOptionType$Name' => '<p>The recovery method for a user.</p>', ], ], 'RecoveryOptionType' => [ 'base' => '<p>A map containing a priority as a key, and recovery method name as a value.</p>', 'refs' => [ 'RecoveryMechanismsType$member' => NULL, ], ], 'RedirectUrlType' => [ 'base' => NULL, 'refs' => [ 'CallbackURLsListType$member' => NULL, 'CreateUserPoolClientRequest$DefaultRedirectURI' => '<p>The default redirect URI. In app clients with one assigned IdP, replaces <code>redirect_uri</code> in authentication requests. Must be in the <code>CallbackURLs</code> list.</p> <p>A redirect URI must:</p> <ul> <li> <p>Be an absolute URI.</p> </li> <li> <p>Be registered with the authorization server.</p> </li> <li> <p>Not include a fragment component.</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-client-apps.html#cognito-user-pools-app-idp-settings-about">Default redirect URI</a>.</p> <p>Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.</p> <p>App callback URLs such as myapp://example are also supported.</p>', 'LogoutURLsListType$member' => NULL, 'UpdateUserPoolClientRequest$DefaultRedirectURI' => '<p>The default redirect URI. Must be in the <code>CallbackURLs</code> list.</p> <p>A redirect URI must:</p> <ul> <li> <p>Be an absolute URI.</p> </li> <li> <p>Be registered with the authorization server.</p> </li> <li> <p>Not include a fragment component.</p> </li> </ul> <p>See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.</p> <p>Amazon Cognito requires HTTPS over HTTP except for <code>http://localhost</code> for testing purposes only.</p> <p>App callback URLs such as <code>myapp://example</code> are also supported.</p>', 'UserPoolClientType$DefaultRedirectURI' => '<p>The default redirect URI. Must be in the <code>CallbackURLs</code> list.</p> <p>A redirect URI must:</p> <ul> <li> <p>Be an absolute URI.</p> </li> <li> <p>Be registered with the authorization server.</p> </li> <li> <p>Not include a fragment component.</p> </li> </ul> <p>See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.</p> <p>Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.</p> <p>App callback URLs such as myapp://example are also supported.</p>', ], ], 'RefreshTokenValidityType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolClientRequest$RefreshTokenValidity' => '<p>The refresh token time limit. After this limit expires, your user can\'t use their refresh token. To specify the time unit for <code>RefreshTokenValidity</code> as <code>seconds</code>, <code>minutes</code>, <code>hours</code>, or <code>days</code>, set a <code>TokenValidityUnits</code> value in your API request.</p> <p>For example, when you set <code>RefreshTokenValidity</code> as <code>10</code> and <code>TokenValidityUnits</code> as <code>days</code>, your user can refresh their session and retrieve new access and ID tokens for 10 days.</p> <p>The default time unit for <code>RefreshTokenValidity</code> in an API request is days. You can\'t set <code>RefreshTokenValidity</code> to 0. If you do, Amazon Cognito overrides the value with the default value of 30 days. <i>Valid range</i> is displayed below in seconds.</p> <p>If you don\'t specify otherwise in the configuration of your app client, your refresh tokens are valid for 30 days.</p>', 'UpdateUserPoolClientRequest$RefreshTokenValidity' => '<p>The refresh token time limit. After this limit expires, your user can\'t use their refresh token. To specify the time unit for <code>RefreshTokenValidity</code> as <code>seconds</code>, <code>minutes</code>, <code>hours</code>, or <code>days</code>, set a <code>TokenValidityUnits</code> value in your API request.</p> <p>For example, when you set <code>RefreshTokenValidity</code> as <code>10</code> and <code>TokenValidityUnits</code> as <code>days</code>, your user can refresh their session and retrieve new access and ID tokens for 10 days.</p> <p>The default time unit for <code>RefreshTokenValidity</code> in an API request is days. You can\'t set <code>RefreshTokenValidity</code> to 0. If you do, Amazon Cognito overrides the value with the default value of 30 days. <i>Valid range</i> is displayed below in seconds.</p> <p>If you don\'t specify otherwise in the configuration of your app client, your refresh tokens are valid for 30 days.</p>', 'UserPoolClientType$RefreshTokenValidity' => '<p>The refresh token time limit. After this limit expires, your user can\'t use their refresh token. To specify the time unit for <code>RefreshTokenValidity</code> as <code>seconds</code>, <code>minutes</code>, <code>hours</code>, or <code>days</code>, set a <code>TokenValidityUnits</code> value in your API request.</p> <p>For example, when you set <code>RefreshTokenValidity</code> as <code>10</code> and <code>TokenValidityUnits</code> as <code>days</code>, your user can refresh their session and retrieve new access and ID tokens for 10 days.</p> <p>The default time unit for <code>RefreshTokenValidity</code> in an API request is days. You can\'t set <code>RefreshTokenValidity</code> to 0. If you do, Amazon Cognito overrides the value with the default value of 30 days. <i>Valid range</i> is displayed below in seconds.</p> <p>If you don\'t specify otherwise in the configuration of your app client, your refresh tokens are valid for 30 days.</p>', ], ], 'RegionCodeType' => [ 'base' => NULL, 'refs' => [ 'SmsConfigurationType$SnsRegion' => '<p>The Amazon Web Services Region to use with Amazon SNS integration. You can choose the same Region as your user pool, or a supported <b>Legacy Amazon SNS alternate Region</b>. </p> <p> Amazon Cognito resources in the Asia Pacific (Seoul) Amazon Web Services Region must use your Amazon SNS configuration in the Asia Pacific (Tokyo) Region. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html">SMS message settings for Amazon Cognito user pools</a>.</p>', ], ], 'ResendConfirmationCodeRequest' => [ 'base' => '<p>Represents the request to resend the confirmation code.</p>', 'refs' => [], ], 'ResendConfirmationCodeResponse' => [ 'base' => '<p>The response from the server when Amazon Cognito makes the request to resend a confirmation code.</p>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>This exception is thrown when the Amazon Cognito service can\'t find the requested resource.</p>', 'refs' => [], ], 'ResourceServerIdentifierType' => [ 'base' => NULL, 'refs' => [ 'CreateResourceServerRequest$Identifier' => '<p>A unique resource server identifier for the resource server. The identifier can be an API friendly name like <code>solar-system-data</code>. You can also set an API URL like <code>https://solar-system-data-api.example.com</code> as your identifier.</p> <p>Amazon Cognito represents scopes in the access token in the format <code>$resource-server-identifier/$scope</code>. Longer scope-identifier strings increase the size of your access tokens.</p>', 'DeleteResourceServerRequest$Identifier' => '<p>The identifier for the resource server.</p>', 'DescribeResourceServerRequest$Identifier' => '<p>A unique resource server identifier for the resource server. The identifier can be an API friendly name like <code>solar-system-data</code>. You can also set an API URL like <code>https://solar-system-data-api.example.com</code> as your identifier.</p> <p>Amazon Cognito represents scopes in the access token in the format <code>$resource-server-identifier/$scope</code>. Longer scope-identifier strings increase the size of your access tokens.</p>', 'ResourceServerType$Identifier' => '<p>A unique resource server identifier for the resource server. The identifier can be an API friendly name like <code>solar-system-data</code>. You can also set an API URL like <code>https://solar-system-data-api.example.com</code> as your identifier.</p> <p>Amazon Cognito represents scopes in the access token in the format <code>$resource-server-identifier/$scope</code>. Longer scope-identifier strings increase the size of your access tokens.</p>', 'UpdateResourceServerRequest$Identifier' => '<p>A unique resource server identifier for the resource server. The identifier can be an API friendly name like <code>solar-system-data</code>. You can also set an API URL like <code>https://solar-system-data-api.example.com</code> as your identifier.</p> <p>Amazon Cognito represents scopes in the access token in the format <code>$resource-server-identifier/$scope</code>. Longer scope-identifier strings increase the size of your access tokens.</p>', ], ], 'ResourceServerNameType' => [ 'base' => NULL, 'refs' => [ 'CreateResourceServerRequest$Name' => '<p>A friendly name for the resource server.</p>', 'ResourceServerType$Name' => '<p>The name of the resource server.</p>', 'UpdateResourceServerRequest$Name' => '<p>The name of the resource server.</p>', ], ], 'ResourceServerScopeDescriptionType' => [ 'base' => NULL, 'refs' => [ 'ResourceServerScopeType$ScopeDescription' => '<p>A description of the scope.</p>', ], ], 'ResourceServerScopeListType' => [ 'base' => NULL, 'refs' => [ 'CreateResourceServerRequest$Scopes' => '<p>A list of scopes. Each scope is a key-value map with the keys <code>name</code> and <code>description</code>.</p>', 'ResourceServerType$Scopes' => '<p>A list of scopes that are defined for the resource server.</p>', 'UpdateResourceServerRequest$Scopes' => '<p>The scope values to be set for the resource server.</p>', ], ], 'ResourceServerScopeNameType' => [ 'base' => NULL, 'refs' => [ 'ResourceServerScopeType$ScopeName' => '<p>The name of the scope.</p>', ], ], 'ResourceServerScopeType' => [ 'base' => '<p>A resource server scope.</p>', 'refs' => [ 'ResourceServerScopeListType$member' => NULL, ], ], 'ResourceServerType' => [ 'base' => '<p>A container for information about a resource server for a user pool.</p>', 'refs' => [ 'CreateResourceServerResponse$ResourceServer' => '<p>The newly created resource server.</p>', 'DescribeResourceServerResponse$ResourceServer' => '<p>The resource server.</p>', 'ResourceServersListType$member' => NULL, 'UpdateResourceServerResponse$ResourceServer' => '<p>The resource server.</p>', ], ], 'ResourceServersListType' => [ 'base' => NULL, 'refs' => [ 'ListResourceServersResponse$ResourceServers' => '<p>The resource servers.</p>', ], ], 'RespondToAuthChallengeRequest' => [ 'base' => '<p>The request to respond to an authentication challenge.</p>', 'refs' => [], ], 'RespondToAuthChallengeResponse' => [ 'base' => '<p>The response to respond to the authentication challenge.</p>', 'refs' => [], ], 'RevokeTokenRequest' => [ 'base' => NULL, 'refs' => [], ], 'RevokeTokenResponse' => [ 'base' => NULL, 'refs' => [], ], 'RiskConfigurationType' => [ 'base' => '<p>The risk configuration type.</p>', 'refs' => [ 'DescribeRiskConfigurationResponse$RiskConfiguration' => '<p>The risk configuration.</p>', 'SetRiskConfigurationResponse$RiskConfiguration' => '<p>The risk configuration.</p>', ], ], 'RiskDecisionType' => [ 'base' => NULL, 'refs' => [ 'EventRiskType$RiskDecision' => '<p>The risk decision.</p>', ], ], 'RiskExceptionConfigurationType' => [ 'base' => '<p>The type of the configuration to override the risk decision.</p>', 'refs' => [ 'RiskConfigurationType$RiskExceptionConfiguration' => '<p>The configuration to override the risk decision.</p>', 'SetRiskConfigurationRequest$RiskExceptionConfiguration' => '<p>The configuration to override the risk decision.</p>', ], ], 'RiskLevelType' => [ 'base' => NULL, 'refs' => [ 'EventRiskType$RiskLevel' => '<p>The risk level.</p>', ], ], 'S3BucketType' => [ 'base' => NULL, 'refs' => [ 'DomainDescriptionType$S3Bucket' => '<p>The Amazon S3 bucket where the static files for this domain are stored.</p>', ], ], 'SESConfigurationSet' => [ 'base' => NULL, 'refs' => [ 'EmailConfigurationType$ConfigurationSet' => '<p>The set of configuration rules that can be applied to emails sent using Amazon Simple Email Service. A configuration set is applied to an email by including a reference to the configuration set in the headers of the email. Once applied, all of the rules in that configuration set are applied to the email. Configuration sets can be used to apply the following types of rules to emails: </p> <dl> <dt>Event publishing</dt> <dd> <p>Amazon Simple Email Service can track the number of send, delivery, open, click, bounce, and complaint events for each email sent. Use event publishing to send information about these events to other Amazon Web Services services such as and Amazon CloudWatch</p> </dd> <dt>IP pool management</dt> <dd> <p>When leasing dedicated IP addresses with Amazon Simple Email Service, you can create groups of IP addresses, called dedicated IP pools. You can then associate the dedicated IP pools with configuration sets.</p> </dd> </dl>', ], ], 'SMSMfaSettingsType' => [ 'base' => '<p>The type used for enabling SMS multi-factor authentication (MFA) at the user level. Phone numbers don\'t need to be verified to be used for SMS MFA. If an MFA type is activated for a user, the user will be prompted for MFA during all sign-in attempts, unless device tracking is turned on and the device has been trusted. If you would like MFA to be applied selectively based on the assessed risk level of sign-in attempts, deactivate MFA for users and turn on Adaptive Authentication for the user pool.</p>', 'refs' => [ 'AdminSetUserMFAPreferenceRequest$SMSMfaSettings' => '<p>The SMS text message MFA settings.</p>', 'SetUserMFAPreferenceRequest$SMSMfaSettings' => '<p>The SMS text message multi-factor authentication (MFA) settings.</p>', ], ], 'SchemaAttributeType' => [ 'base' => '<p>A list of the user attributes and their properties in your user pool. The attribute schema contains standard attributes, custom attributes with a <code>custom:</code> prefix, and developer attributes with a <code>dev:</code> prefix. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html">User pool attributes</a>.</p> <p>Developer-only attributes are a legacy feature of user pools, are read-only to all app clients. You can create and update developer-only attributes only with IAM-authenticated API operations. Use app client read/write permissions instead.</p>', 'refs' => [ 'CustomAttributesListType$member' => NULL, 'SchemaAttributesListType$member' => NULL, ], ], 'SchemaAttributesListType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolRequest$Schema' => '<p>An array of schema attributes for the new user pool. These attributes can be standard or custom attributes.</p>', 'UserPoolType$SchemaAttributes' => '<p>A list of the user attributes and their properties in your user pool. The attribute schema contains standard attributes, custom attributes with a <code>custom:</code> prefix, and developer attributes with a <code>dev:</code> prefix. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html">User pool attributes</a>.</p> <p>Developer-only attributes are a legacy feature of user pools, are read-only to all app clients. You can create and update developer-only attributes only with IAM-authenticated API operations. Use app client read/write permissions instead.</p>', ], ], 'ScopeDoesNotExistException' => [ 'base' => '<p>This exception is thrown when the specified scope doesn\'t exist.</p>', 'refs' => [], ], 'ScopeListType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolClientRequest$AllowedOAuthScopes' => '<p>The allowed OAuth scopes. Possible values provided by OAuth are <code>phone</code>, <code>email</code>, <code>openid</code>, and <code>profile</code>. Possible values provided by Amazon Web Services are <code>aws.cognito.signin.user.admin</code>. Custom scopes created in Resource Servers are also supported.</p>', 'UpdateUserPoolClientRequest$AllowedOAuthScopes' => '<p>The allowed OAuth scopes. Possible values provided by OAuth are <code>phone</code>, <code>email</code>, <code>openid</code>, and <code>profile</code>. Possible values provided by Amazon Web Services are <code>aws.cognito.signin.user.admin</code>. Custom scopes created in Resource Servers are also supported.</p>', 'UserPoolClientType$AllowedOAuthScopes' => '<p>The OAuth scopes that your app client supports. Possible values that OAuth provides are <code>phone</code>, <code>email</code>, <code>openid</code>, and <code>profile</code>. Possible values that Amazon Web Services provides are <code>aws.cognito.signin.user.admin</code>. Amazon Cognito also supports custom scopes that you create in Resource Servers.</p>', ], ], 'ScopeType' => [ 'base' => NULL, 'refs' => [ 'ScopeListType$member' => NULL, ], ], 'SearchPaginationTokenType' => [ 'base' => NULL, 'refs' => [ 'AdminListDevicesRequest$PaginationToken' => '<p>This API operation returns a limited number of results. The pagination token is an identifier that you can present in an additional API request with the same parameters. When you include the pagination token, Amazon Cognito returns the next set of items after the current list. Subsequent requests return a new pagination token. By use of this token, you can paginate through the full list of items.</p>', 'AdminListDevicesResponse$PaginationToken' => '<p>The identifier that Amazon Cognito returned with the previous request to this operation. When you include a pagination token in your request, Amazon Cognito returns the next set of items in the list. By use of this token, you can paginate through the full list of items.</p>', 'ListDevicesRequest$PaginationToken' => '<p>This API operation returns a limited number of results. The pagination token is an identifier that you can present in an additional API request with the same parameters. When you include the pagination token, Amazon Cognito returns the next set of items after the current list. Subsequent requests return a new pagination token. By use of this token, you can paginate through the full list of items.</p>', 'ListDevicesResponse$PaginationToken' => '<p>The identifier that Amazon Cognito returned with the previous request to this operation. When you include a pagination token in your request, Amazon Cognito returns the next set of items in the list. By use of this token, you can paginate through the full list of items.</p>', 'ListUsersRequest$PaginationToken' => '<p>This API operation returns a limited number of results. The pagination token is an identifier that you can present in an additional API request with the same parameters. When you include the pagination token, Amazon Cognito returns the next set of items after the current list. Subsequent requests return a new pagination token. By use of this token, you can paginate through the full list of items.</p>', 'ListUsersResponse$PaginationToken' => '<p>The identifier that Amazon Cognito returned with the previous request to this operation. When you include a pagination token in your request, Amazon Cognito returns the next set of items in the list. By use of this token, you can paginate through the full list of items.</p>', ], ], 'SearchedAttributeNamesListType' => [ 'base' => NULL, 'refs' => [ 'ListUsersRequest$AttributesToGet' => '<p>A JSON array of user attribute names, for example <code>given_name</code>, that you want Amazon Cognito to include in the response for each user. When you don\'t provide an <code>AttributesToGet</code> parameter, Amazon Cognito returns all attributes for each user.</p> <p>Use <code>AttributesToGet</code> with required attributes in your user pool, or in conjunction with <code>Filter</code>. Amazon Cognito returns an error if not all users in the results have set a value for the attribute you request. Attributes that you can\'t filter on, including custom attributes, must have a value set in every user profile before an <code>AttributesToGet</code> parameter returns results.</p>', ], ], 'SecretCodeType' => [ 'base' => NULL, 'refs' => [ 'AssociateSoftwareTokenResponse$SecretCode' => '<p>A unique generated shared secret code that is used in the TOTP algorithm to generate a one-time code.</p>', ], ], 'SecretHashType' => [ 'base' => NULL, 'refs' => [ 'ConfirmForgotPasswordRequest$SecretHash' => '<p>A keyed-hash message authentication code (HMAC) calculated using the secret key of a user pool client and username plus the client ID in the message. For more information about <code>SecretHash</code>, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/signing-up-users-in-your-app.html#cognito-user-pools-computing-secret-hash">Computing secret hash values</a>.</p>', 'ConfirmSignUpRequest$SecretHash' => '<p>A keyed-hash message authentication code (HMAC) calculated using the secret key of a user pool client and username plus the client ID in the message.</p>', 'ForgotPasswordRequest$SecretHash' => '<p>A keyed-hash message authentication code (HMAC) calculated using the secret key of a user pool client and username plus the client ID in the message.</p>', 'ResendConfirmationCodeRequest$SecretHash' => '<p>A keyed-hash message authentication code (HMAC) calculated using the secret key of a user pool client and username plus the client ID in the message.</p>', 'SignUpRequest$SecretHash' => '<p>A keyed-hash message authentication code (HMAC) calculated using the secret key of a user pool client and username plus the client ID in the message.</p>', ], ], 'SessionType' => [ 'base' => NULL, 'refs' => [ 'AdminInitiateAuthResponse$Session' => '<p>The session that should be passed both ways in challenge-response calls to the service. If <code>AdminInitiateAuth</code> or <code>AdminRespondToAuthChallenge</code> API call determines that the caller must pass another challenge, they return a session with other challenge parameters. This session should be passed as it is to the next <code>AdminRespondToAuthChallenge</code> API call.</p>', 'AdminRespondToAuthChallengeRequest$Session' => '<p>The session that should be passed both ways in challenge-response calls to the service. If an <code>InitiateAuth</code> or <code>RespondToAuthChallenge</code> API call determines that the caller must pass another challenge, it returns a session with other challenge parameters. This session should be passed as it is to the next <code>RespondToAuthChallenge</code> API call.</p>', 'AdminRespondToAuthChallengeResponse$Session' => '<p>The session that should be passed both ways in challenge-response calls to the service. If the caller must pass another challenge, they return a session with other challenge parameters. This session should be passed as it is to the next <code>RespondToAuthChallenge</code> API call.</p>', 'AssociateSoftwareTokenRequest$Session' => '<p>The session that should be passed both ways in challenge-response calls to the service. This allows authentication of the user as part of the MFA setup process.</p>', 'AssociateSoftwareTokenResponse$Session' => '<p>The session that should be passed both ways in challenge-response calls to the service. This allows authentication of the user as part of the MFA setup process.</p>', 'InitiateAuthResponse$Session' => '<p>The session that should pass both ways in challenge-response calls to the service. If the caller must pass another challenge, they return a session with other challenge parameters. This session should be passed as it is to the next <code>RespondToAuthChallenge</code> API call.</p>', 'RespondToAuthChallengeRequest$Session' => '<p>The session that should be passed both ways in challenge-response calls to the service. If <code>InitiateAuth</code> or <code>RespondToAuthChallenge</code> API call determines that the caller must pass another challenge, they return a session with other challenge parameters. This session should be passed as it is to the next <code>RespondToAuthChallenge</code> API call.</p>', 'RespondToAuthChallengeResponse$Session' => '<p>The session that should be passed both ways in challenge-response calls to the service. If the caller must pass another challenge, they return a session with other challenge parameters. This session should be passed as it is to the next <code>RespondToAuthChallenge</code> API call.</p>', 'VerifySoftwareTokenRequest$Session' => '<p>The session that should be passed both ways in challenge-response calls to the service.</p>', 'VerifySoftwareTokenResponse$Session' => '<p>The session that should be passed both ways in challenge-response calls to the service.</p>', ], ], 'SetLogDeliveryConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'SetLogDeliveryConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'SetRiskConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'SetRiskConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'SetUICustomizationRequest' => [ 'base' => NULL, 'refs' => [], ], 'SetUICustomizationResponse' => [ 'base' => NULL, 'refs' => [], ], 'SetUserMFAPreferenceRequest' => [ 'base' => NULL, 'refs' => [], ], 'SetUserMFAPreferenceResponse' => [ 'base' => NULL, 'refs' => [], ], 'SetUserPoolMfaConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'SetUserPoolMfaConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'SetUserSettingsRequest' => [ 'base' => '<p>Represents the request to set user settings.</p>', 'refs' => [], ], 'SetUserSettingsResponse' => [ 'base' => '<p>The response from the server for a set user settings request.</p>', 'refs' => [], ], 'SignUpRequest' => [ 'base' => '<p>Represents the request to register a user.</p>', 'refs' => [], ], 'SignUpResponse' => [ 'base' => '<p>The response from the server for a registration request.</p>', 'refs' => [], ], 'SkippedIPRangeListType' => [ 'base' => NULL, 'refs' => [ 'RiskExceptionConfigurationType$SkippedIPRangeList' => '<p>Risk detection isn\'t performed on the IP addresses in this range list. The IP range is in CIDR notation.</p>', ], ], 'SmsConfigurationType' => [ 'base' => '<p>The SMS configuration type is the settings that your Amazon Cognito user pool must use to send an SMS message from your Amazon Web Services account through Amazon Simple Notification Service. To send SMS messages with Amazon SNS in the Amazon Web Services Region that you want, the Amazon Cognito user pool uses an Identity and Access Management (IAM) role in your Amazon Web Services account.</p>', 'refs' => [ 'CreateUserPoolRequest$SmsConfiguration' => '<p>The SMS configuration with the settings that your Amazon Cognito user pool must use to send an SMS message from your Amazon Web Services account through Amazon Simple Notification Service. To send SMS messages with Amazon SNS in the Amazon Web Services Region that you want, the Amazon Cognito user pool uses an Identity and Access Management (IAM) role in your Amazon Web Services account.</p>', 'SmsMfaConfigType$SmsConfiguration' => '<p>The SMS configuration with the settings that your Amazon Cognito user pool must use to send an SMS message from your Amazon Web Services account through Amazon Simple Notification Service. To request Amazon SNS in the Amazon Web Services Region that you want, the Amazon Cognito user pool uses an Identity and Access Management (IAM) role that you provide for your Amazon Web Services account.</p>', 'UpdateUserPoolRequest$SmsConfiguration' => '<p>The SMS configuration with the settings that your Amazon Cognito user pool must use to send an SMS message from your Amazon Web Services account through Amazon Simple Notification Service. To send SMS messages with Amazon SNS in the Amazon Web Services Region that you want, the Amazon Cognito user pool uses an Identity and Access Management (IAM) role in your Amazon Web Services account.</p>', 'UserPoolType$SmsConfiguration' => '<p>The SMS configuration with the settings that your Amazon Cognito user pool must use to send an SMS message from your Amazon Web Services account through Amazon Simple Notification Service. To send SMS messages with Amazon SNS in the Amazon Web Services Region that you want, the Amazon Cognito user pool uses an Identity and Access Management (IAM) role in your Amazon Web Services account.</p>', ], ], 'SmsMfaConfigType' => [ 'base' => '<p>The SMS text message multi-factor authentication (MFA) configuration type.</p>', 'refs' => [ 'GetUserPoolMfaConfigResponse$SmsMfaConfiguration' => '<p>The SMS text message multi-factor authentication (MFA) configuration.</p>', 'SetUserPoolMfaConfigRequest$SmsMfaConfiguration' => '<p>The SMS text message MFA configuration.</p>', 'SetUserPoolMfaConfigResponse$SmsMfaConfiguration' => '<p>The SMS text message MFA configuration.</p>', ], ], 'SmsVerificationMessageType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolRequest$SmsVerificationMessage' => '<p>This parameter is no longer used. See <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html">VerificationMessageTemplateType</a>.</p>', 'CreateUserPoolRequest$SmsAuthenticationMessage' => '<p>A string representing the SMS authentication message.</p>', 'MessageTemplateType$SMSMessage' => '<p>The message template for SMS messages.</p>', 'SmsMfaConfigType$SmsAuthenticationMessage' => '<p>The SMS authentication message that will be sent to users with the code they must sign in. The message must contain the ‘{####}’ placeholder, which is replaced with the code. If the message isn\'t included, and default message will be used.</p>', 'UpdateUserPoolRequest$SmsVerificationMessage' => '<p>This parameter is no longer used. See <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html">VerificationMessageTemplateType</a>.</p>', 'UpdateUserPoolRequest$SmsAuthenticationMessage' => '<p>The contents of the SMS authentication message.</p>', 'UserPoolType$SmsVerificationMessage' => '<p>This parameter is no longer used. See <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html">VerificationMessageTemplateType</a>.</p>', 'UserPoolType$SmsAuthenticationMessage' => '<p>The contents of the SMS authentication message.</p>', 'VerificationMessageTemplateType$SmsMessage' => '<p>The template for SMS messages that Amazon Cognito sends to your users.</p>', ], ], 'SoftwareTokenMFANotFoundException' => [ 'base' => '<p>This exception is thrown when the software token time-based one-time password (TOTP) multi-factor authentication (MFA) isn\'t activated for the user pool.</p>', 'refs' => [], ], 'SoftwareTokenMFAUserCodeType' => [ 'base' => NULL, 'refs' => [ 'VerifySoftwareTokenRequest$UserCode' => '<p>The one- time password computed using the secret code returned by <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AssociateSoftwareToken.html">AssociateSoftwareToken</a>.</p>', ], ], 'SoftwareTokenMfaConfigType' => [ 'base' => '<p>The type used for enabling software token MFA at the user pool level.</p>', 'refs' => [ 'GetUserPoolMfaConfigResponse$SoftwareTokenMfaConfiguration' => '<p>The software token multi-factor authentication (MFA) configuration.</p>', 'SetUserPoolMfaConfigRequest$SoftwareTokenMfaConfiguration' => '<p>The software token MFA configuration.</p>', 'SetUserPoolMfaConfigResponse$SoftwareTokenMfaConfiguration' => '<p>The software token MFA configuration.</p>', ], ], 'SoftwareTokenMfaSettingsType' => [ 'base' => '<p>The type used for enabling software token MFA at the user level. If an MFA type is activated for a user, the user will be prompted for MFA during all sign-in attempts, unless device tracking is turned on and the device has been trusted. If you want MFA to be applied selectively based on the assessed risk level of sign-in attempts, deactivate MFA for users and turn on Adaptive Authentication for the user pool.</p>', 'refs' => [ 'AdminSetUserMFAPreferenceRequest$SoftwareTokenMfaSettings' => '<p>The time-based one-time password software token MFA settings.</p>', 'SetUserMFAPreferenceRequest$SoftwareTokenMfaSettings' => '<p>The time-based one-time password (TOTP) software token MFA settings.</p>', ], ], 'StartUserImportJobRequest' => [ 'base' => '<p>Represents the request to start the user import job.</p>', 'refs' => [], ], 'StartUserImportJobResponse' => [ 'base' => '<p>Represents the response from the server to the request to start the user import job.</p>', 'refs' => [], ], 'StatusType' => [ 'base' => NULL, 'refs' => [ 'UserPoolDescriptionType$Status' => '<p>The user pool status in a user pool description.</p>', 'UserPoolType$Status' => '<p>This parameter is no longer used.</p>', ], ], 'StopUserImportJobRequest' => [ 'base' => '<p>Represents the request to stop the user import job.</p>', 'refs' => [], ], 'StopUserImportJobResponse' => [ 'base' => '<p>Represents the response from the server to the request to stop the user import job.</p>', 'refs' => [], ], 'StringAttributeConstraintsType' => [ 'base' => '<p>The constraints associated with a string attribute.</p>', 'refs' => [ 'SchemaAttributeType$StringAttributeConstraints' => '<p>Specifies the constraints for an attribute of the string type.</p>', ], ], 'StringType' => [ 'base' => NULL, 'refs' => [ 'AdminDisableProviderForUserRequest$UserPoolId' => '<p>The user pool ID for the user pool.</p>', 'AdminGetUserResponse$PreferredMfaSetting' => '<p>The user\'s preferred MFA setting.</p>', 'AdminLinkProviderForUserRequest$UserPoolId' => '<p>The user pool ID for the user pool.</p>', 'AnalyticsConfigurationType$ExternalId' => '<p>The external ID.</p>', 'AnalyticsMetadataType$AnalyticsEndpointId' => '<p>The endpoint ID.</p>', 'AttributeMappingType$value' => NULL, 'AuthEventType$EventId' => '<p>The event ID.</p>', 'AuthParametersType$key' => NULL, 'AuthParametersType$value' => NULL, 'AuthenticationResultType$TokenType' => '<p>The token type.</p>', 'BlockedIPRangeListType$member' => NULL, 'ChallengeParametersType$key' => NULL, 'ChallengeParametersType$value' => NULL, 'ChallengeResponsesType$key' => NULL, 'ChallengeResponsesType$value' => NULL, 'ClientMetadataType$key' => NULL, 'ClientMetadataType$value' => NULL, 'CodeDeliveryDetailsType$Destination' => '<p>The email address or phone number destination where Amazon Cognito sent the code.</p>', 'ContextDataType$IpAddress' => '<p>The source IP address of your user\'s device.</p>', 'ContextDataType$ServerName' => '<p>Your server endpoint where this API is invoked.</p>', 'ContextDataType$ServerPath' => '<p>Your server path where this API is invoked.</p>', 'ContextDataType$EncodedData' => '<p>Encoded device-fingerprint details that your app collected with the Amazon Cognito context data collection library. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-adaptive-authentication.html#user-pool-settings-adaptive-authentication-device-fingerprint">Adding user device and session data to API requests</a>.</p>', 'DeviceSecretVerifierConfigType$PasswordVerifier' => '<p>The password verifier.</p>', 'DeviceSecretVerifierConfigType$Salt' => '<p>The <a href="https://en.wikipedia.org/wiki/Salt_(cryptography)">salt</a> </p>', 'DomainDescriptionType$CloudFrontDistribution' => '<p>The Amazon CloudFront endpoint that you use as the target of the alias that you set up with your Domain Name Service (DNS) provider.</p>', 'EmailConfigurationType$From' => '<p>Either the sender’s email address or the sender’s name with their email address. For example, <code>testuser@example.com</code> or <code>Test User &lt;testuser@example.com&gt;</code>. This address appears before the body of the email.</p>', 'EventContextDataType$IpAddress' => '<p>The source IP address of your user\'s device.</p>', 'EventContextDataType$DeviceName' => '<p>The user\'s device name.</p>', 'EventContextDataType$Timezone' => '<p>The user\'s time zone.</p>', 'EventContextDataType$City' => '<p>The user\'s city.</p>', 'EventContextDataType$Country' => '<p>The user\'s country.</p>', 'EventFeedbackType$Provider' => '<p>The provider.</p>', 'GetSigningCertificateResponse$Certificate' => '<p>The signing certificate.</p>', 'GetUserResponse$PreferredMfaSetting' => '<p>The user\'s preferred MFA setting.</p>', 'HttpHeader$headerName' => '<p>The header name.</p>', 'HttpHeader$headerValue' => '<p>The header value.</p>', 'ListOfStringTypes$member' => NULL, 'NewDeviceMetadataType$DeviceGroupKey' => '<p>The device group key.</p>', 'NotifyConfigurationType$From' => '<p>The email address that is sending the email. The address must be either individually verified with Amazon Simple Email Service, or from a domain that has been verified with Amazon SES.</p>', 'NotifyConfigurationType$ReplyTo' => '<p>The destination to which the receiver of an email should reply to.</p>', 'NumberAttributeConstraintsType$MinValue' => '<p>The minimum value of an attribute that is of the number data type.</p>', 'NumberAttributeConstraintsType$MaxValue' => '<p>The maximum length of a number attribute value. Must be a number less than or equal to <code>2^1023</code>, represented as a string with a length of 131072 characters or fewer.</p>', 'ProviderDetailsType$key' => NULL, 'ProviderDetailsType$value' => NULL, 'ProviderUserIdentifierType$ProviderAttributeName' => '<p>The name of the provider attribute to link to, such as <code>NameID</code>.</p>', 'ProviderUserIdentifierType$ProviderAttributeValue' => '<p>The value of the provider attribute to link to, such as <code>xxxxx_account</code>.</p>', 'SignUpResponse$UserSub' => '<p>The UUID of the authenticated user. This isn\'t the same as <code>username</code>.</p>', 'SkippedIPRangeListType$member' => NULL, 'SmsConfigurationType$ExternalId' => '<p>The external ID provides additional security for your IAM role. You can use an <code>ExternalId</code> with the IAM role that you use with Amazon SNS to send SMS messages for your user pool. If you provide an <code>ExternalId</code>, your Amazon Cognito user pool includes it in the request to assume your IAM role. You can configure the role trust policy to require that Amazon Cognito, and any principal, provide the <code>ExternalID</code>. If you use the Amazon Cognito Management Console to create a role for SMS multi-factor authentication (MFA), Amazon Cognito creates a role with the required permissions and a trust policy that demonstrates use of the <code>ExternalId</code>.</p> <p>For more information about the <code>ExternalId</code> of a role, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html">How to use an external ID when granting access to your Amazon Web Services resources to a third party</a> </p>', 'StringAttributeConstraintsType$MinLength' => '<p>The minimum length.</p>', 'StringAttributeConstraintsType$MaxLength' => '<p>The maximum length of a string attribute value. Must be a number less than or equal to <code>2^1023</code>, represented as a string with a length of 131072 characters or fewer.</p>', 'UserContextDataType$IpAddress' => '<p>The source IP address of your user\'s device.</p>', 'UserContextDataType$EncodedData' => '<p>Encoded device-fingerprint details that your app collected with the Amazon Cognito context data collection library. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-adaptive-authentication.html#user-pool-settings-adaptive-authentication-device-fingerprint">Adding user device and session data to API requests</a>.</p>', 'UserMFASettingListType$member' => NULL, 'UserPoolType$SmsConfigurationFailure' => '<p>The reason why the SMS configuration can\'t send the messages to your users.</p> <p>This message might include comma-separated values to describe why your SMS configuration can\'t send messages to user pool end users.</p> <dl> <dt>InvalidSmsRoleAccessPolicyException</dt> <dd> <p>The Identity and Access Management role that Amazon Cognito uses to send SMS messages isn\'t properly configured. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SmsConfigurationType.html">SmsConfigurationType</a>.</p> </dd> <dt>SNSSandbox</dt> <dd> <p>The Amazon Web Services account is in the SNS SMS Sandbox and messages will only reach verified end users. This parameter won’t get populated with SNSSandbox if the user creating the user pool doesn’t have SNS permissions. To learn how to move your Amazon Web Services account out of the sandbox, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox-moving-to-production.html">Moving out of the SMS sandbox</a>.</p> </dd> </dl>', 'UserPoolType$EmailConfigurationFailure' => '<p>Deprecated. Review error codes from API requests with <code>EventSource:cognito-idp.amazonaws.com</code> in CloudTrail for information about problems with user pool email configuration.</p>', 'VerifySoftwareTokenRequest$FriendlyDeviceName' => '<p>The friendly device name.</p>', ], ], 'SupportedIdentityProvidersListType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolClientRequest$SupportedIdentityProviders' => '<p>A list of provider names for the identity providers (IdPs) that are supported on this client. The following are supported: <code>COGNITO</code>, <code>Facebook</code>, <code>Google</code>, <code>SignInWithApple</code>, and <code>LoginWithAmazon</code>. You can also specify the names that you configured for the SAML and OIDC IdPs in your user pool, for example <code>MySAMLIdP</code> or <code>MyOIDCIdP</code>.</p>', 'UpdateUserPoolClientRequest$SupportedIdentityProviders' => '<p>A list of provider names for the IdPs that this client supports. The following are supported: <code>COGNITO</code>, <code>Facebook</code>, <code>Google</code>, <code>SignInWithApple</code>, <code>LoginWithAmazon</code>, and the names of your own SAML and OIDC providers.</p>', 'UserPoolClientType$SupportedIdentityProviders' => '<p>A list of provider names for the IdPs that this client supports. The following are supported: <code>COGNITO</code>, <code>Facebook</code>, <code>Google</code>, <code>SignInWithApple</code>, <code>LoginWithAmazon</code>, and the names of your own SAML and OIDC providers.</p>', ], ], 'TagKeysType' => [ 'base' => NULL, 'refs' => [ 'UserPoolTagsListType$member' => NULL, 'UserPoolTagsType$key' => NULL, ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValueType' => [ 'base' => NULL, 'refs' => [ 'UserPoolTagsType$value' => NULL, ], ], 'TemporaryPasswordValidityDaysType' => [ 'base' => NULL, 'refs' => [ 'PasswordPolicyType$TemporaryPasswordValidityDays' => '<p>The number of days a temporary password is valid in the password policy. If the user doesn\'t sign in during this time, an administrator must reset their password. Defaults to <code>7</code>. If you submit a value of <code>0</code>, Amazon Cognito treats it as a null value and sets <code>TemporaryPasswordValidityDays</code> to its default value.</p> <note> <p>When you set <code>TemporaryPasswordValidityDays</code> for a user pool, you can no longer set a value for the legacy <code>UnusedAccountValidityDays</code> parameter in that user pool.</p> </note>', ], ], 'TimeUnitsType' => [ 'base' => NULL, 'refs' => [ 'TokenValidityUnitsType$AccessToken' => '<p> A time unit of <code>seconds</code>, <code>minutes</code>, <code>hours</code>, or <code>days</code> for the value that you set in the <code>AccessTokenValidity</code> parameter. The default <code>AccessTokenValidity</code> time unit is hours. <code>AccessTokenValidity</code> duration can range from five minutes to one day.</p>', 'TokenValidityUnitsType$IdToken' => '<p>A time unit of <code>seconds</code>, <code>minutes</code>, <code>hours</code>, or <code>days</code> for the value that you set in the <code>IdTokenValidity</code> parameter. The default <code>IdTokenValidity</code> time unit is hours. <code>IdTokenValidity</code> duration can range from five minutes to one day.</p>', 'TokenValidityUnitsType$RefreshToken' => '<p>A time unit of <code>seconds</code>, <code>minutes</code>, <code>hours</code>, or <code>days</code> for the value that you set in the <code>RefreshTokenValidity</code> parameter. The default <code>RefreshTokenValidity</code> time unit is days. <code>RefreshTokenValidity</code> duration can range from 60 minutes to 10 years.</p>', ], ], 'TokenModelType' => [ 'base' => NULL, 'refs' => [ 'AssociateSoftwareTokenRequest$AccessToken' => '<p>A valid access token that Amazon Cognito issued to the user whose software token you want to generate.</p>', 'AuthenticationResultType$AccessToken' => '<p>A valid access token that Amazon Cognito issued to the user who you want to authenticate.</p>', 'AuthenticationResultType$RefreshToken' => '<p>The refresh token.</p>', 'AuthenticationResultType$IdToken' => '<p>The ID token.</p>', 'ChangePasswordRequest$AccessToken' => '<p>A valid access token that Amazon Cognito issued to the user whose password you want to change.</p>', 'ConfirmDeviceRequest$AccessToken' => '<p>A valid access token that Amazon Cognito issued to the user whose device you want to confirm.</p>', 'DeleteUserAttributesRequest$AccessToken' => '<p>A valid access token that Amazon Cognito issued to the user whose attributes you want to delete.</p>', 'DeleteUserRequest$AccessToken' => '<p>A valid access token that Amazon Cognito issued to the user whose user profile you want to delete.</p>', 'ForgetDeviceRequest$AccessToken' => '<p>A valid access token that Amazon Cognito issued to the user whose registered device you want to forget.</p>', 'GetDeviceRequest$AccessToken' => '<p>A valid access token that Amazon Cognito issued to the user whose device information you want to request.</p>', 'GetUserAttributeVerificationCodeRequest$AccessToken' => '<p>A non-expired access token for the user whose attribute verification code you want to generate.</p>', 'GetUserRequest$AccessToken' => '<p>A non-expired access token for the user whose information you want to query.</p>', 'GlobalSignOutRequest$AccessToken' => '<p>A valid access token that Amazon Cognito issued to the user who you want to sign out.</p>', 'ListDevicesRequest$AccessToken' => '<p>A valid access token that Amazon Cognito issued to the user whose list of devices you want to view.</p>', 'RevokeTokenRequest$Token' => '<p>The refresh token that you want to revoke.</p>', 'SetUserMFAPreferenceRequest$AccessToken' => '<p>A valid access token that Amazon Cognito issued to the user whose MFA preference you want to set.</p>', 'SetUserSettingsRequest$AccessToken' => '<p>A valid access token that Amazon Cognito issued to the user whose user settings you want to configure.</p>', 'UpdateAuthEventFeedbackRequest$FeedbackToken' => '<p>The feedback token.</p>', 'UpdateDeviceStatusRequest$AccessToken' => '<p>A valid access token that Amazon Cognito issued to the user whose device status you want to update.</p>', 'UpdateUserAttributesRequest$AccessToken' => '<p>A valid access token that Amazon Cognito issued to the user whose user attributes you want to update.</p>', 'VerifySoftwareTokenRequest$AccessToken' => '<p>A valid access token that Amazon Cognito issued to the user whose software token you want to verify.</p>', 'VerifyUserAttributeRequest$AccessToken' => '<p>A valid access token that Amazon Cognito issued to the user whose user attributes you want to verify.</p>', ], ], 'TokenValidityUnitsType' => [ 'base' => '<p>The data type TokenValidityUnits specifies the time units you use when you set the duration of ID, access, and refresh tokens.</p>', 'refs' => [ 'CreateUserPoolClientRequest$TokenValidityUnits' => '<p>The units in which the validity times are represented. The default unit for RefreshToken is days, and default for ID and access tokens are hours.</p>', 'UpdateUserPoolClientRequest$TokenValidityUnits' => '<p>The time units you use when you set the duration of ID, access, and refresh tokens. The default unit for RefreshToken is days, and the default for ID and access tokens is hours.</p>', 'UserPoolClientType$TokenValidityUnits' => '<p>The time units used to specify the token validity times of each token type: ID, access, and refresh.</p>', ], ], 'TooManyFailedAttemptsException' => [ 'base' => '<p>This exception is thrown when the user has made too many failed attempts for a given action, such as sign-in.</p>', 'refs' => [], ], 'TooManyRequestsException' => [ 'base' => '<p>This exception is thrown when the user has made too many requests for a given operation.</p>', 'refs' => [], ], 'UICustomizationType' => [ 'base' => '<p>A container for the UI customization information for a user pool\'s built-in app UI.</p>', 'refs' => [ 'GetUICustomizationResponse$UICustomization' => '<p>The UI customization information.</p>', 'SetUICustomizationResponse$UICustomization' => '<p>The UI customization information.</p>', ], ], 'UnauthorizedException' => [ 'base' => '<p>Exception that is thrown when the request isn\'t authorized. This can happen due to an invalid access token in the request.</p>', 'refs' => [], ], 'UnexpectedLambdaException' => [ 'base' => '<p>This exception is thrown when Amazon Cognito encounters an unexpected exception with Lambda.</p>', 'refs' => [], ], 'UnsupportedIdentityProviderException' => [ 'base' => '<p>This exception is thrown when the specified identifier isn\'t supported.</p>', 'refs' => [], ], 'UnsupportedOperationException' => [ 'base' => '<p>Exception that is thrown when you attempt to perform an operation that isn\'t enabled for the user pool client.</p>', 'refs' => [], ], 'UnsupportedTokenTypeException' => [ 'base' => '<p>Exception that is thrown when an unsupported token is passed to an operation.</p>', 'refs' => [], ], 'UnsupportedUserStateException' => [ 'base' => '<p>The request failed because the user is in an unsupported state.</p>', 'refs' => [], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAuthEventFeedbackRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAuthEventFeedbackResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDeviceStatusRequest' => [ 'base' => '<p>Represents the request to update the device status.</p>', 'refs' => [], ], 'UpdateDeviceStatusResponse' => [ 'base' => '<p>The response to the request to update the device status.</p>', 'refs' => [], ], 'UpdateGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateIdentityProviderRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateIdentityProviderResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateResourceServerRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateResourceServerResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserAttributesRequest' => [ 'base' => '<p>Represents the request to update user attributes.</p>', 'refs' => [], ], 'UpdateUserAttributesResponse' => [ 'base' => '<p>Represents the response from the server for the request to update user attributes.</p>', 'refs' => [], ], 'UpdateUserPoolClientRequest' => [ 'base' => '<p>Represents the request to update the user pool client.</p>', 'refs' => [], ], 'UpdateUserPoolClientResponse' => [ 'base' => '<p>Represents the response from the server to the request to update the user pool client.</p>', 'refs' => [], ], 'UpdateUserPoolDomainRequest' => [ 'base' => '<p>The UpdateUserPoolDomain request input.</p>', 'refs' => [], ], 'UpdateUserPoolDomainResponse' => [ 'base' => '<p>The UpdateUserPoolDomain response output.</p>', 'refs' => [], ], 'UpdateUserPoolRequest' => [ 'base' => '<p>Represents the request to update the user pool.</p>', 'refs' => [], ], 'UpdateUserPoolResponse' => [ 'base' => '<p>Represents the response from the server when you make a request to update the user pool.</p>', 'refs' => [], ], 'UserAttributeUpdateSettingsType' => [ 'base' => '<p>The settings for updates to user attributes. These settings include the property <code>AttributesRequireVerificationBeforeUpdate</code>, a user-pool setting that tells Amazon Cognito how to handle changes to the value of your users\' email address and phone number attributes. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html#user-pool-settings-verifications-verify-attribute-updates"> Verifying updates to email addresses and phone numbers</a>.</p>', 'refs' => [ 'CreateUserPoolRequest$UserAttributeUpdateSettings' => '<p>The settings for updates to user attributes. These settings include the property <code>AttributesRequireVerificationBeforeUpdate</code>, a user-pool setting that tells Amazon Cognito how to handle changes to the value of your users\' email address and phone number attributes. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html#user-pool-settings-verifications-verify-attribute-updates"> Verifying updates to email addresses and phone numbers</a>.</p>', 'UpdateUserPoolRequest$UserAttributeUpdateSettings' => '<p>The settings for updates to user attributes. These settings include the property <code>AttributesRequireVerificationBeforeUpdate</code>, a user-pool setting that tells Amazon Cognito how to handle changes to the value of your users\' email address and phone number attributes. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html#user-pool-settings-verifications-verify-attribute-updates"> Verifying updates to email addresses and phone numbers</a>.</p>', 'UserPoolType$UserAttributeUpdateSettings' => '<p>The settings for updates to user attributes. These settings include the property <code>AttributesRequireVerificationBeforeUpdate</code>, a user-pool setting that tells Amazon Cognito how to handle changes to the value of your users\' email address and phone number attributes. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html#user-pool-settings-verifications-verify-attribute-updates"> Verifying updates to email addresses and phone numbers</a>.</p>', ], ], 'UserContextDataType' => [ 'base' => '<p>Contextual data, such as the user\'s device fingerprint, IP address, or location, used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>', 'refs' => [ 'ConfirmForgotPasswordRequest$UserContextData' => '<p>Contextual data about your user session, such as the device fingerprint, IP address, or location. Amazon Cognito advanced security evaluates the risk of an authentication event based on the context that your app generates and passes to Amazon Cognito when it makes API requests.</p>', 'ConfirmSignUpRequest$UserContextData' => '<p>Contextual data about your user session, such as the device fingerprint, IP address, or location. Amazon Cognito advanced security evaluates the risk of an authentication event based on the context that your app generates and passes to Amazon Cognito when it makes API requests.</p>', 'ForgotPasswordRequest$UserContextData' => '<p>Contextual data about your user session, such as the device fingerprint, IP address, or location. Amazon Cognito advanced security evaluates the risk of an authentication event based on the context that your app generates and passes to Amazon Cognito when it makes API requests.</p>', 'InitiateAuthRequest$UserContextData' => '<p>Contextual data about your user session, such as the device fingerprint, IP address, or location. Amazon Cognito advanced security evaluates the risk of an authentication event based on the context that your app generates and passes to Amazon Cognito when it makes API requests.</p>', 'ResendConfirmationCodeRequest$UserContextData' => '<p>Contextual data about your user session, such as the device fingerprint, IP address, or location. Amazon Cognito advanced security evaluates the risk of an authentication event based on the context that your app generates and passes to Amazon Cognito when it makes API requests.</p>', 'RespondToAuthChallengeRequest$UserContextData' => '<p>Contextual data about your user session, such as the device fingerprint, IP address, or location. Amazon Cognito advanced security evaluates the risk of an authentication event based on the context that your app generates and passes to Amazon Cognito when it makes API requests.</p>', 'SignUpRequest$UserContextData' => '<p>Contextual data about your user session, such as the device fingerprint, IP address, or location. Amazon Cognito advanced security evaluates the risk of an authentication event based on the context that your app generates and passes to Amazon Cognito when it makes API requests.</p>', ], ], 'UserFilterType' => [ 'base' => NULL, 'refs' => [ 'ListUsersRequest$Filter' => '<p>A filter string of the form "<i>AttributeName</i> <i>Filter-Type</i> "<i>AttributeValue</i>"". Quotation marks within the filter string must be escaped using the backslash (<code>\\</code>) character. For example, <code>"family_name = \\"Reddy\\""</code>.</p> <ul> <li> <p> <i>AttributeName</i>: The name of the attribute to search for. You can only search for one attribute at a time.</p> </li> <li> <p> <i>Filter-Type</i>: For an exact match, use <code>=</code>, for example, "<code>given_name = \\"Jon\\"</code>". For a prefix ("starts with") match, use <code>^=</code>, for example, "<code>given_name ^= \\"Jon\\"</code>". </p> </li> <li> <p> <i>AttributeValue</i>: The attribute value that must be matched for each user.</p> </li> </ul> <p>If the filter string is empty, <code>ListUsers</code> returns all users in the user pool.</p> <p>You can only search for the following standard attributes:</p> <ul> <li> <p> <code>username</code> (case-sensitive)</p> </li> <li> <p> <code>email</code> </p> </li> <li> <p> <code>phone_number</code> </p> </li> <li> <p> <code>name</code> </p> </li> <li> <p> <code>given_name</code> </p> </li> <li> <p> <code>family_name</code> </p> </li> <li> <p> <code>preferred_username</code> </p> </li> <li> <p> <code>cognito:user_status</code> (called <b>Status</b> in the Console) (case-insensitive)</p> </li> <li> <p> <code>status (called <b>Enabled</b> in the Console) (case-sensitive)</code> </p> </li> <li> <p> <code>sub</code> </p> </li> </ul> <p>Custom attributes aren\'t searchable.</p> <note> <p>You can also list users with a client-side filter. The server-side filter matches no more than one attribute. For an advanced search, use a client-side filter with the <code>--query</code> parameter of the <code>list-users</code> action in the CLI. When you use a client-side filter, ListUsers returns a paginated list of zero or more users. You can receive multiple pages in a row with zero results. Repeat the query with each pagination token that is returned until you receive a null pagination token value, and then review the combined result. </p> <p>For more information about server-side and client-side filtering, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-filter.html">FilteringCLI output</a> in the <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-filter.html">Command Line Interface User Guide</a>. </p> </note> <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/how-to-manage-user-accounts.html#cognito-user-pools-searching-for-users-using-listusers-api">Searching for Users Using the ListUsers API</a> and <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/how-to-manage-user-accounts.html#cognito-user-pools-searching-for-users-listusers-api-examples">Examples of Using the ListUsers API</a> in the <i>Amazon Cognito Developer Guide</i>.</p>', ], ], 'UserImportInProgressException' => [ 'base' => '<p>This exception is thrown when you\'re trying to modify a user pool while a user import job is in progress for that pool.</p>', 'refs' => [], ], 'UserImportJobIdType' => [ 'base' => NULL, 'refs' => [ 'DescribeUserImportJobRequest$JobId' => '<p>The job ID for the user import job.</p>', 'StartUserImportJobRequest$JobId' => '<p>The job ID for the user import job.</p>', 'StopUserImportJobRequest$JobId' => '<p>The job ID for the user import job.</p>', 'UserImportJobType$JobId' => '<p>The job ID for the user import job.</p>', ], ], 'UserImportJobNameType' => [ 'base' => NULL, 'refs' => [ 'CreateUserImportJobRequest$JobName' => '<p>The job name for the user import job.</p>', 'UserImportJobType$JobName' => '<p>The job name for the user import job.</p>', ], ], 'UserImportJobStatusType' => [ 'base' => NULL, 'refs' => [ 'UserImportJobType$Status' => '<p>The status of the user import job. One of the following:</p> <ul> <li> <p> <code>Created</code> - The job was created but not started.</p> </li> <li> <p> <code>Pending</code> - A transition state. You have started the job, but it has not begun importing users yet.</p> </li> <li> <p> <code>InProgress</code> - The job has started, and users are being imported.</p> </li> <li> <p> <code>Stopping</code> - You have stopped the job, but the job has not stopped importing users yet.</p> </li> <li> <p> <code>Stopped</code> - You have stopped the job, and the job has stopped importing users.</p> </li> <li> <p> <code>Succeeded</code> - The job has completed successfully.</p> </li> <li> <p> <code>Failed</code> - The job has stopped due to an error.</p> </li> <li> <p> <code>Expired</code> - You created a job, but did not start the job within 24-48 hours. All data associated with the job was deleted, and the job can\'t be started.</p> </li> </ul>', ], ], 'UserImportJobType' => [ 'base' => '<p>The user import job type.</p>', 'refs' => [ 'CreateUserImportJobResponse$UserImportJob' => '<p>The job object that represents the user import job.</p>', 'DescribeUserImportJobResponse$UserImportJob' => '<p>The job object that represents the user import job.</p>', 'StartUserImportJobResponse$UserImportJob' => '<p>The job object that represents the user import job.</p>', 'StopUserImportJobResponse$UserImportJob' => '<p>The job object that represents the user import job.</p>', 'UserImportJobsListType$member' => NULL, ], ], 'UserImportJobsListType' => [ 'base' => NULL, 'refs' => [ 'ListUserImportJobsResponse$UserImportJobs' => '<p>The user import jobs.</p>', ], ], 'UserLambdaValidationException' => [ 'base' => '<p>This exception is thrown when the Amazon Cognito service encounters a user validation exception with the Lambda service.</p>', 'refs' => [], ], 'UserMFASettingListType' => [ 'base' => NULL, 'refs' => [ 'AdminGetUserResponse$UserMFASettingList' => '<p>The MFA options that are activated for the user. The possible values in this list are <code>SMS_MFA</code> and <code>SOFTWARE_TOKEN_MFA</code>.</p>', 'GetUserResponse$UserMFASettingList' => '<p>The MFA options that are activated for the user. The possible values in this list are <code>SMS_MFA</code> and <code>SOFTWARE_TOKEN_MFA</code>.</p>', ], ], 'UserNotConfirmedException' => [ 'base' => '<p>This exception is thrown when a user isn\'t confirmed successfully.</p>', 'refs' => [], ], 'UserNotFoundException' => [ 'base' => '<p>This exception is thrown when a user isn\'t found.</p>', 'refs' => [], ], 'UserPoolAddOnNotEnabledException' => [ 'base' => '<p>This exception is thrown when user pool add-ons aren\'t enabled.</p>', 'refs' => [], ], 'UserPoolAddOnsType' => [ 'base' => '<p>User pool add-ons. Contains settings for activation of advanced security features. To log user security information but take no action, set to <code>AUDIT</code>. To configure automatic security responses to risky traffic to your user pool, set to <code>ENFORCED</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-advanced-security.html">Adding advanced security to a user pool</a>.</p>', 'refs' => [ 'CreateUserPoolRequest$UserPoolAddOns' => '<p>User pool add-ons. Contains settings for activation of advanced security features. To log user security information but take no action, set to <code>AUDIT</code>. To configure automatic security responses to risky traffic to your user pool, set to <code>ENFORCED</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-advanced-security.html">Adding advanced security to a user pool</a>.</p>', 'UpdateUserPoolRequest$UserPoolAddOns' => '<p>User pool add-ons. Contains settings for activation of advanced security features. To log user security information but take no action, set to <code>AUDIT</code>. To configure automatic security responses to risky traffic to your user pool, set to <code>ENFORCED</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-advanced-security.html">Adding advanced security to a user pool</a>.</p>', 'UserPoolType$UserPoolAddOns' => '<p>User pool add-ons. Contains settings for activation of advanced security features. To log user security information but take no action, set to <code>AUDIT</code>. To configure automatic security responses to risky traffic to your user pool, set to <code>ENFORCED</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-advanced-security.html">Adding advanced security to a user pool</a>.</p>', ], ], 'UserPoolClientDescription' => [ 'base' => '<p>The description of the user pool client.</p>', 'refs' => [ 'UserPoolClientListType$member' => NULL, ], ], 'UserPoolClientListType' => [ 'base' => NULL, 'refs' => [ 'ListUserPoolClientsResponse$UserPoolClients' => '<p>The user pool clients in the response that lists user pool clients.</p>', ], ], 'UserPoolClientType' => [ 'base' => '<p>Contains information about a user pool client.</p>', 'refs' => [ 'CreateUserPoolClientResponse$UserPoolClient' => '<p>The user pool client that was just created.</p>', 'DescribeUserPoolClientResponse$UserPoolClient' => '<p>The user pool client from a server response to describe the user pool client.</p>', 'UpdateUserPoolClientResponse$UserPoolClient' => '<p>The user pool client value from the response from the server when you request to update the user pool client.</p>', ], ], 'UserPoolDescriptionType' => [ 'base' => '<p>A user pool description.</p>', 'refs' => [ 'UserPoolListType$member' => NULL, ], ], 'UserPoolIdType' => [ 'base' => NULL, 'refs' => [ 'AddCustomAttributesRequest$UserPoolId' => '<p>The user pool ID for the user pool where you want to add custom attributes.</p>', 'AdminAddUserToGroupRequest$UserPoolId' => '<p>The user pool ID for the user pool.</p>', 'AdminConfirmSignUpRequest$UserPoolId' => '<p>The user pool ID for which you want to confirm user registration.</p>', 'AdminCreateUserRequest$UserPoolId' => '<p>The user pool ID for the user pool where the user will be created.</p>', 'AdminDeleteUserAttributesRequest$UserPoolId' => '<p>The user pool ID for the user pool where you want to delete user attributes.</p>', 'AdminDeleteUserRequest$UserPoolId' => '<p>The user pool ID for the user pool where you want to delete the user.</p>', 'AdminDisableUserRequest$UserPoolId' => '<p>The user pool ID for the user pool where you want to disable the user.</p>', 'AdminEnableUserRequest$UserPoolId' => '<p>The user pool ID for the user pool where you want to enable the user.</p>', 'AdminForgetDeviceRequest$UserPoolId' => '<p>The user pool ID.</p>', 'AdminGetDeviceRequest$UserPoolId' => '<p>The user pool ID.</p>', 'AdminGetUserRequest$UserPoolId' => '<p>The user pool ID for the user pool where you want to get information about the user.</p>', 'AdminInitiateAuthRequest$UserPoolId' => '<p>The ID of the Amazon Cognito user pool.</p>', 'AdminListDevicesRequest$UserPoolId' => '<p>The user pool ID.</p>', 'AdminListGroupsForUserRequest$UserPoolId' => '<p>The user pool ID for the user pool.</p>', 'AdminListUserAuthEventsRequest$UserPoolId' => '<p>The user pool ID.</p>', 'AdminRemoveUserFromGroupRequest$UserPoolId' => '<p>The user pool ID for the user pool.</p>', 'AdminResetUserPasswordRequest$UserPoolId' => '<p>The user pool ID for the user pool where you want to reset the user\'s password.</p>', 'AdminRespondToAuthChallengeRequest$UserPoolId' => '<p>The ID of the Amazon Cognito user pool.</p>', 'AdminSetUserMFAPreferenceRequest$UserPoolId' => '<p>The user pool ID.</p>', 'AdminSetUserPasswordRequest$UserPoolId' => '<p>The user pool ID for the user pool where you want to set the user\'s password.</p>', 'AdminSetUserSettingsRequest$UserPoolId' => '<p>The ID of the user pool that contains the user whose options you\'re setting.</p>', 'AdminUpdateAuthEventFeedbackRequest$UserPoolId' => '<p>The user pool ID.</p>', 'AdminUpdateDeviceStatusRequest$UserPoolId' => '<p>The user pool ID.</p>', 'AdminUpdateUserAttributesRequest$UserPoolId' => '<p>The user pool ID for the user pool where you want to update user attributes.</p>', 'AdminUserGlobalSignOutRequest$UserPoolId' => '<p>The user pool ID.</p>', 'CreateGroupRequest$UserPoolId' => '<p>The user pool ID for the user pool.</p>', 'CreateIdentityProviderRequest$UserPoolId' => '<p>The user pool ID.</p>', 'CreateResourceServerRequest$UserPoolId' => '<p>The user pool ID for the user pool.</p>', 'CreateUserImportJobRequest$UserPoolId' => '<p>The user pool ID for the user pool that the users are being imported into.</p>', 'CreateUserPoolClientRequest$UserPoolId' => '<p>The user pool ID for the user pool where you want to create a user pool client.</p>', 'CreateUserPoolDomainRequest$UserPoolId' => '<p>The user pool ID.</p>', 'DeleteGroupRequest$UserPoolId' => '<p>The user pool ID for the user pool.</p>', 'DeleteIdentityProviderRequest$UserPoolId' => '<p>The user pool ID.</p>', 'DeleteResourceServerRequest$UserPoolId' => '<p>The user pool ID for the user pool that hosts the resource server.</p>', 'DeleteUserPoolClientRequest$UserPoolId' => '<p>The user pool ID for the user pool where you want to delete the client.</p>', 'DeleteUserPoolDomainRequest$UserPoolId' => '<p>The user pool ID.</p>', 'DeleteUserPoolRequest$UserPoolId' => '<p>The user pool ID for the user pool you want to delete.</p>', 'DescribeIdentityProviderRequest$UserPoolId' => '<p>The user pool ID.</p>', 'DescribeResourceServerRequest$UserPoolId' => '<p>The user pool ID for the user pool that hosts the resource server.</p>', 'DescribeRiskConfigurationRequest$UserPoolId' => '<p>The user pool ID.</p>', 'DescribeUserImportJobRequest$UserPoolId' => '<p>The user pool ID for the user pool that the users are being imported into.</p>', 'DescribeUserPoolClientRequest$UserPoolId' => '<p>The user pool ID for the user pool you want to describe.</p>', 'DescribeUserPoolRequest$UserPoolId' => '<p>The user pool ID for the user pool you want to describe.</p>', 'DomainDescriptionType$UserPoolId' => '<p>The user pool ID.</p>', 'GetCSVHeaderRequest$UserPoolId' => '<p>The user pool ID for the user pool that the users are to be imported into.</p>', 'GetCSVHeaderResponse$UserPoolId' => '<p>The user pool ID for the user pool that the users are to be imported into.</p>', 'GetGroupRequest$UserPoolId' => '<p>The user pool ID for the user pool.</p>', 'GetIdentityProviderByIdentifierRequest$UserPoolId' => '<p>The user pool ID.</p>', 'GetLogDeliveryConfigurationRequest$UserPoolId' => '<p>The ID of the user pool where you want to view detailed activity logging configuration.</p>', 'GetSigningCertificateRequest$UserPoolId' => '<p>The user pool ID.</p>', 'GetUICustomizationRequest$UserPoolId' => '<p>The user pool ID for the user pool.</p>', 'GetUserPoolMfaConfigRequest$UserPoolId' => '<p>The user pool ID.</p>', 'GroupType$UserPoolId' => '<p>The user pool ID for the user pool.</p>', 'IdentityProviderType$UserPoolId' => '<p>The user pool ID.</p>', 'ListGroupsRequest$UserPoolId' => '<p>The user pool ID for the user pool.</p>', 'ListIdentityProvidersRequest$UserPoolId' => '<p>The user pool ID.</p>', 'ListResourceServersRequest$UserPoolId' => '<p>The user pool ID for the user pool.</p>', 'ListUserImportJobsRequest$UserPoolId' => '<p>The user pool ID for the user pool that the users are being imported into.</p>', 'ListUserPoolClientsRequest$UserPoolId' => '<p>The user pool ID for the user pool where you want to list user pool clients.</p>', 'ListUsersInGroupRequest$UserPoolId' => '<p>The user pool ID for the user pool.</p>', 'ListUsersRequest$UserPoolId' => '<p>The user pool ID for the user pool on which the search should be performed.</p>', 'LogDeliveryConfigurationType$UserPoolId' => '<p>The ID of the user pool where you configured detailed activity logging.</p>', 'ResourceServerType$UserPoolId' => '<p>The user pool ID for the user pool that hosts the resource server.</p>', 'RiskConfigurationType$UserPoolId' => '<p>The user pool ID.</p>', 'SetLogDeliveryConfigurationRequest$UserPoolId' => '<p>The ID of the user pool where you want to configure detailed activity logging .</p>', 'SetRiskConfigurationRequest$UserPoolId' => '<p>The user pool ID. </p>', 'SetUICustomizationRequest$UserPoolId' => '<p>The user pool ID for the user pool.</p>', 'SetUserPoolMfaConfigRequest$UserPoolId' => '<p>The user pool ID.</p>', 'StartUserImportJobRequest$UserPoolId' => '<p>The user pool ID for the user pool that the users are being imported into.</p>', 'StopUserImportJobRequest$UserPoolId' => '<p>The user pool ID for the user pool that the users are being imported into.</p>', 'UICustomizationType$UserPoolId' => '<p>The user pool ID for the user pool.</p>', 'UpdateAuthEventFeedbackRequest$UserPoolId' => '<p>The user pool ID.</p>', 'UpdateGroupRequest$UserPoolId' => '<p>The user pool ID for the user pool.</p>', 'UpdateIdentityProviderRequest$UserPoolId' => '<p>The user pool ID.</p>', 'UpdateResourceServerRequest$UserPoolId' => '<p>The user pool ID for the user pool.</p>', 'UpdateUserPoolClientRequest$UserPoolId' => '<p>The user pool ID for the user pool where you want to update the user pool client.</p>', 'UpdateUserPoolDomainRequest$UserPoolId' => '<p>The ID of the user pool that is associated with the custom domain whose certificate you\'re updating.</p>', 'UpdateUserPoolRequest$UserPoolId' => '<p>The user pool ID for the user pool you want to update.</p>', 'UserImportJobType$UserPoolId' => '<p>The user pool ID for the user pool that the users are being imported into.</p>', 'UserPoolClientDescription$UserPoolId' => '<p>The user pool ID for the user pool where you want to describe the user pool client.</p>', 'UserPoolClientType$UserPoolId' => '<p>The user pool ID for the user pool client.</p>', 'UserPoolDescriptionType$Id' => '<p>The ID in a user pool description.</p>', 'UserPoolType$Id' => '<p>The ID of the user pool.</p>', ], ], 'UserPoolListType' => [ 'base' => NULL, 'refs' => [ 'ListUserPoolsResponse$UserPools' => '<p>The user pools from the response to list users.</p>', ], ], 'UserPoolMfaType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolRequest$MfaConfiguration' => '<p>Specifies MFA configuration details.</p>', 'GetUserPoolMfaConfigResponse$MfaConfiguration' => '<p>The multi-factor authentication (MFA) configuration. Valid values include:</p> <ul> <li> <p> <code>OFF</code> MFA won\'t be used for any users.</p> </li> <li> <p> <code>ON</code> MFA is required for all users to sign in.</p> </li> <li> <p> <code>OPTIONAL</code> MFA will be required only for individual users who have an MFA factor activated.</p> </li> </ul>', 'SetUserPoolMfaConfigRequest$MfaConfiguration' => '<p>The MFA configuration. If you set the MfaConfiguration value to ‘ON’, only users who have set up an MFA factor can sign in. To learn more, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-mfa.html">Adding Multi-Factor Authentication (MFA) to a user pool</a>. Valid values include:</p> <ul> <li> <p> <code>OFF</code> MFA won\'t be used for any users.</p> </li> <li> <p> <code>ON</code> MFA is required for all users to sign in.</p> </li> <li> <p> <code>OPTIONAL</code> MFA will be required only for individual users who have an MFA factor activated.</p> </li> </ul>', 'SetUserPoolMfaConfigResponse$MfaConfiguration' => '<p>The MFA configuration. Valid values include:</p> <ul> <li> <p> <code>OFF</code> MFA won\'t be used for any users.</p> </li> <li> <p> <code>ON</code> MFA is required for all users to sign in.</p> </li> <li> <p> <code>OPTIONAL</code> MFA will be required only for individual users who have an MFA factor enabled.</p> </li> </ul>', 'UpdateUserPoolRequest$MfaConfiguration' => '<p>Possible values include:</p> <ul> <li> <p> <code>OFF</code> - MFA tokens aren\'t required and can\'t be specified during user registration.</p> </li> <li> <p> <code>ON</code> - MFA tokens are required for all user registrations. You can only specify ON when you\'re initially creating a user pool. You can use the <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SetUserPoolMfaConfig.html">SetUserPoolMfaConfig</a> API operation to turn MFA "ON" for existing user pools. </p> </li> <li> <p> <code>OPTIONAL</code> - Users have the option when registering to create an MFA token.</p> </li> </ul>', 'UserPoolType$MfaConfiguration' => '<p>Can be one of the following values:</p> <ul> <li> <p> <code>OFF</code> - MFA tokens aren\'t required and can\'t be specified during user registration.</p> </li> <li> <p> <code>ON</code> - MFA tokens are required for all user registrations. You can only specify required when you\'re initially creating a user pool.</p> </li> <li> <p> <code>OPTIONAL</code> - Users have the option when registering to create an MFA token.</p> </li> </ul>', ], ], 'UserPoolNameType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolRequest$PoolName' => '<p>A string used to name the user pool.</p>', 'UserPoolDescriptionType$Name' => '<p>The name in a user pool description.</p>', 'UserPoolType$Name' => '<p>The name of the user pool.</p>', ], ], 'UserPoolPolicyType' => [ 'base' => '<p>The policy associated with a user pool.</p>', 'refs' => [ 'CreateUserPoolRequest$Policies' => '<p>The policies associated with the new user pool.</p>', 'UpdateUserPoolRequest$Policies' => '<p>A container with the policies you want to update in a user pool.</p>', 'UserPoolType$Policies' => '<p>The policies associated with the user pool.</p>', ], ], 'UserPoolTaggingException' => [ 'base' => '<p>This exception is thrown when a user pool tag can\'t be set or updated.</p>', 'refs' => [], ], 'UserPoolTagsListType' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>The keys of the tags to remove from the user pool.</p>', ], ], 'UserPoolTagsType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolRequest$UserPoolTags' => '<p>The tag keys and values to assign to the user pool. A tag is a label that you can use to categorize and manage user pools in different ways, such as by purpose, owner, environment, or other criteria.</p>', 'ListTagsForResourceResponse$Tags' => '<p>The tags that are assigned to the user pool.</p>', 'TagResourceRequest$Tags' => '<p>The tags to assign to the user pool.</p>', 'UpdateUserPoolRequest$UserPoolTags' => '<p>The tag keys and values to assign to the user pool. A tag is a label that you can use to categorize and manage user pools in different ways, such as by purpose, owner, environment, or other criteria.</p>', 'UserPoolType$UserPoolTags' => '<p>The tags that are assigned to the user pool. A tag is a label that you can apply to user pools to categorize and manage them in different ways, such as by purpose, owner, environment, or other criteria.</p>', ], ], 'UserPoolType' => [ 'base' => '<p>A container for information about the user pool.</p>', 'refs' => [ 'CreateUserPoolResponse$UserPool' => '<p>A container for the user pool details.</p>', 'DescribeUserPoolResponse$UserPool' => '<p>The container of metadata returned by the server to describe the pool.</p>', ], ], 'UserStatusType' => [ 'base' => NULL, 'refs' => [ 'AdminGetUserResponse$UserStatus' => '<p>The user status. Can be one of the following:</p> <ul> <li> <p>UNCONFIRMED - User has been created but not confirmed.</p> </li> <li> <p>CONFIRMED - User has been confirmed.</p> </li> <li> <p>UNKNOWN - User status isn\'t known.</p> </li> <li> <p>RESET_REQUIRED - User is confirmed, but the user must request a code and reset their password before they can sign in.</p> </li> <li> <p>FORCE_CHANGE_PASSWORD - The user is confirmed and the user can sign in using a temporary password, but on first sign-in, the user must change their password to a new value before doing anything else. </p> </li> </ul>', 'UserType$UserStatus' => '<p>The user status. This can be one of the following:</p> <ul> <li> <p>UNCONFIRMED - User has been created but not confirmed.</p> </li> <li> <p>CONFIRMED - User has been confirmed.</p> </li> <li> <p>EXTERNAL_PROVIDER - User signed in with a third-party IdP.</p> </li> <li> <p>UNKNOWN - User status isn\'t known.</p> </li> <li> <p>RESET_REQUIRED - User is confirmed, but the user must request a code and reset their password before they can sign in.</p> </li> <li> <p>FORCE_CHANGE_PASSWORD - The user is confirmed and the user can sign in using a temporary password, but on first sign-in, the user must change their password to a new value before doing anything else. </p> </li> </ul>', ], ], 'UserType' => [ 'base' => '<p>A user profile in a Amazon Cognito user pool.</p>', 'refs' => [ 'AdminCreateUserResponse$User' => '<p>The newly created user.</p>', 'UsersListType$member' => NULL, ], ], 'UsernameAttributeType' => [ 'base' => NULL, 'refs' => [ 'UsernameAttributesListType$member' => NULL, ], ], 'UsernameAttributesListType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolRequest$UsernameAttributes' => '<p>Specifies whether a user can use an email address or phone number as a username when they sign up.</p>', 'UserPoolType$UsernameAttributes' => '<p>Specifies whether a user can use an email address or phone number as a username when they sign up.</p>', ], ], 'UsernameConfigurationType' => [ 'base' => '<p>The username configuration type. </p>', 'refs' => [ 'CreateUserPoolRequest$UsernameConfiguration' => '<p>Case sensitivity on the username input for the selected sign-in option. When case sensitivity is set to <code>False</code> (case insensitive), users can sign in with any combination of capital and lowercase letters. For example, <code>username</code>, <code>USERNAME</code>, or <code>UserName</code>, or for email, <code>email@example.com</code> or <code>EMaiL@eXamplE.Com</code>. For most use cases, set case sensitivity to <code>False</code> (case insensitive) as a best practice. When usernames and email addresses are case insensitive, Amazon Cognito treats any variation in case as the same user, and prevents a case variation from being assigned to the same attribute for a different user.</p> <p>This configuration is immutable after you set it. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UsernameConfigurationType.html">UsernameConfigurationType</a>.</p>', 'UserPoolType$UsernameConfiguration' => '<p>Case sensitivity of the username input for the selected sign-in option. For example, when case sensitivity is set to <code>False</code>, users can sign in using either "username" or "Username". This configuration is immutable once it has been set. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UsernameConfigurationType.html">UsernameConfigurationType</a>.</p>', ], ], 'UsernameExistsException' => [ 'base' => '<p>This exception is thrown when Amazon Cognito encounters a user name that already exists in the user pool.</p>', 'refs' => [], ], 'UsernameType' => [ 'base' => NULL, 'refs' => [ 'AdminAddUserToGroupRequest$Username' => '<p>The username of the user that you want to query or modify. The value of this parameter is typically your user\'s username, but it can be any of their alias attributes. If <code>username</code> isn\'t an alias attribute in your user pool, this value must be the <code>sub</code> of a local user or the username of a user from a third-party IdP.</p>', 'AdminConfirmSignUpRequest$Username' => '<p>The username of the user that you want to query or modify. The value of this parameter is typically your user\'s username, but it can be any of their alias attributes. If <code>username</code> isn\'t an alias attribute in your user pool, this value must be the <code>sub</code> of a local user or the username of a user from a third-party IdP.</p>', 'AdminCreateUserRequest$Username' => '<p>The value that you want to set as the username sign-in attribute. The following conditions apply to the username parameter.</p> <ul> <li> <p>The username can\'t be a duplicate of another username in the same user pool.</p> </li> <li> <p>You can\'t change the value of a username after you create it.</p> </li> <li> <p>You can only provide a value if usernames are a valid sign-in attribute for your user pool. If your user pool only supports phone numbers or email addresses as sign-in attributes, Amazon Cognito automatically generates a username value. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#user-pool-settings-aliases">Customizing sign-in attributes</a>.</p> </li> </ul>', 'AdminDeleteUserAttributesRequest$Username' => '<p>The username of the user that you want to query or modify. The value of this parameter is typically your user\'s username, but it can be any of their alias attributes. If <code>username</code> isn\'t an alias attribute in your user pool, this value must be the <code>sub</code> of a local user or the username of a user from a third-party IdP.</p>', 'AdminDeleteUserRequest$Username' => '<p>The username of the user that you want to query or modify. The value of this parameter is typically your user\'s username, but it can be any of their alias attributes. If <code>username</code> isn\'t an alias attribute in your user pool, this value must be the <code>sub</code> of a local user or the username of a user from a third-party IdP.</p>', 'AdminDisableUserRequest$Username' => '<p>The username of the user that you want to query or modify. The value of this parameter is typically your user\'s username, but it can be any of their alias attributes. If <code>username</code> isn\'t an alias attribute in your user pool, this value must be the <code>sub</code> of a local user or the username of a user from a third-party IdP.</p>', 'AdminEnableUserRequest$Username' => '<p>The username of the user that you want to query or modify. The value of this parameter is typically your user\'s username, but it can be any of their alias attributes. If <code>username</code> isn\'t an alias attribute in your user pool, this value must be the <code>sub</code> of a local user or the username of a user from a third-party IdP.</p>', 'AdminForgetDeviceRequest$Username' => '<p>The username of the user that you want to query or modify. The value of this parameter is typically your user\'s username, but it can be any of their alias attributes. If <code>username</code> isn\'t an alias attribute in your user pool, this value must be the <code>sub</code> of a local user or the username of a user from a third-party IdP.</p>', 'AdminGetDeviceRequest$Username' => '<p>The username of the user that you want to query or modify. The value of this parameter is typically your user\'s username, but it can be any of their alias attributes. If <code>username</code> isn\'t an alias attribute in your user pool, this value must be the <code>sub</code> of a local user or the username of a user from a third-party IdP.</p>', 'AdminGetUserRequest$Username' => '<p>The username of the user that you want to query or modify. The value of this parameter is typically your user\'s username, but it can be any of their alias attributes. If <code>username</code> isn\'t an alias attribute in your user pool, this value must be the <code>sub</code> of a local user or the username of a user from a third-party IdP.</p>', 'AdminGetUserResponse$Username' => '<p>The username of the user that you requested.</p>', 'AdminListDevicesRequest$Username' => '<p>The username of the user that you want to query or modify. The value of this parameter is typically your user\'s username, but it can be any of their alias attributes. If <code>username</code> isn\'t an alias attribute in your user pool, this value must be the <code>sub</code> of a local user or the username of a user from a third-party IdP.</p>', 'AdminListGroupsForUserRequest$Username' => '<p>The username of the user that you want to query or modify. The value of this parameter is typically your user\'s username, but it can be any of their alias attributes. If <code>username</code> isn\'t an alias attribute in your user pool, this value must be the <code>sub</code> of a local user or the username of a user from a third-party IdP.</p>', 'AdminListUserAuthEventsRequest$Username' => '<p>The username of the user that you want to query or modify. The value of this parameter is typically your user\'s username, but it can be any of their alias attributes. If <code>username</code> isn\'t an alias attribute in your user pool, this value must be the <code>sub</code> of a local user or the username of a user from a third-party IdP.</p>', 'AdminRemoveUserFromGroupRequest$Username' => '<p>The username of the user that you want to query or modify. The value of this parameter is typically your user\'s username, but it can be any of their alias attributes. If <code>username</code> isn\'t an alias attribute in your user pool, this value must be the <code>sub</code> of a local user or the username of a user from a third-party IdP.</p>', 'AdminResetUserPasswordRequest$Username' => '<p>The username of the user that you want to query or modify. The value of this parameter is typically your user\'s username, but it can be any of their alias attributes. If <code>username</code> isn\'t an alias attribute in your user pool, this value must be the <code>sub</code> of a local user or the username of a user from a third-party IdP.</p>', 'AdminSetUserMFAPreferenceRequest$Username' => '<p>The username of the user that you want to query or modify. The value of this parameter is typically your user\'s username, but it can be any of their alias attributes. If <code>username</code> isn\'t an alias attribute in your user pool, this value must be the <code>sub</code> of a local user or the username of a user from a third-party IdP.</p>', 'AdminSetUserPasswordRequest$Username' => '<p>The username of the user that you want to query or modify. The value of this parameter is typically your user\'s username, but it can be any of their alias attributes. If <code>username</code> isn\'t an alias attribute in your user pool, this value must be the <code>sub</code> of a local user or the username of a user from a third-party IdP.</p>', 'AdminSetUserSettingsRequest$Username' => '<p>The username of the user that you want to query or modify. The value of this parameter is typically your user\'s username, but it can be any of their alias attributes. If <code>username</code> isn\'t an alias attribute in your user pool, this value must be the <code>sub</code> of a local user or the username of a user from a third-party IdP.</p>', 'AdminUpdateAuthEventFeedbackRequest$Username' => '<p>The username of the user that you want to query or modify. The value of this parameter is typically your user\'s username, but it can be any of their alias attributes. If <code>username</code> isn\'t an alias attribute in your user pool, this value must be the <code>sub</code> of a local user or the username of a user from a third-party IdP.</p>', 'AdminUpdateDeviceStatusRequest$Username' => '<p>The username of the user that you want to query or modify. The value of this parameter is typically your user\'s username, but it can be any of their alias attributes. If <code>username</code> isn\'t an alias attribute in your user pool, this value must be the <code>sub</code> of a local user or the username of a user from a third-party IdP.</p>', 'AdminUpdateUserAttributesRequest$Username' => '<p>The username of the user that you want to query or modify. The value of this parameter is typically your user\'s username, but it can be any of their alias attributes. If <code>username</code> isn\'t an alias attribute in your user pool, this value must be the <code>sub</code> of a local user or the username of a user from a third-party IdP.</p>', 'AdminUserGlobalSignOutRequest$Username' => '<p>The username of the user that you want to query or modify. The value of this parameter is typically your user\'s username, but it can be any of their alias attributes. If <code>username</code> isn\'t an alias attribute in your user pool, this value must be the <code>sub</code> of a local user or the username of a user from a third-party IdP.</p>', 'ConfirmForgotPasswordRequest$Username' => '<p>The username of the user that you want to query or modify. The value of this parameter is typically your user\'s username, but it can be any of their alias attributes. If <code>username</code> isn\'t an alias attribute in your user pool, this value must be the <code>sub</code> of a local user or the username of a user from a third-party IdP.</p>', 'ConfirmSignUpRequest$Username' => '<p>The username of the user that you want to query or modify. The value of this parameter is typically your user\'s username, but it can be any of their alias attributes. If <code>username</code> isn\'t an alias attribute in your user pool, this value must be the <code>sub</code> of a local user or the username of a user from a third-party IdP.</p>', 'ForgotPasswordRequest$Username' => '<p>The username of the user that you want to query or modify. The value of this parameter is typically your user\'s username, but it can be any of their alias attributes. If <code>username</code> isn\'t an alias attribute in your user pool, this value must be the <code>sub</code> of a local user or the username of a user from a third-party IdP.</p>', 'GetUserResponse$Username' => '<p>The username of the user that you requested.</p>', 'ResendConfirmationCodeRequest$Username' => '<p>The username of the user that you want to query or modify. The value of this parameter is typically your user\'s username, but it can be any of their alias attributes. If <code>username</code> isn\'t an alias attribute in your user pool, this value must be the <code>sub</code> of a local user or the username of a user from a third-party IdP.</p>', 'SignUpRequest$Username' => '<p>The username of the user that you want to sign up. The value of this parameter is typically a username, but can be any alias attribute in your user pool.</p>', 'UpdateAuthEventFeedbackRequest$Username' => '<p>The username of the user that you want to query or modify. The value of this parameter is typically your user\'s username, but it can be any of their alias attributes. If <code>username</code> isn\'t an alias attribute in your user pool, this value must be the <code>sub</code> of a local user or the username of a user from a third-party IdP.</p>', 'UserType$Username' => '<p>The user name of the user you want to describe.</p>', ], ], 'UsersListType' => [ 'base' => NULL, 'refs' => [ 'ListUsersInGroupResponse$Users' => '<p>A list of users in the group, and their attributes.</p>', 'ListUsersResponse$Users' => '<p>A list of the user pool users, and their attributes, that match your query.</p> <note> <p>Amazon Cognito creates a profile in your user pool for each native user in your user pool, and each unique user ID from your third-party identity providers (IdPs). When you link users with the <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminLinkProviderForUser.html">AdminLinkProviderForUser</a> API operation, the output of <code>ListUsers</code> displays both the IdP user and the native user that you linked. You can identify IdP users in the <code>Users</code> object of this API response by the IdP prefix that Amazon Cognito appends to <code>Username</code>.</p> </note>', ], ], 'VerificationMessageTemplateType' => [ 'base' => '<p>The template for verification messages.</p>', 'refs' => [ 'CreateUserPoolRequest$VerificationMessageTemplate' => '<p>The template for the verification message that the user sees when the app requests permission to access the user\'s information.</p>', 'UpdateUserPoolRequest$VerificationMessageTemplate' => '<p>The template for verification messages.</p>', 'UserPoolType$VerificationMessageTemplate' => '<p>The template for verification messages.</p>', ], ], 'VerifiedAttributeType' => [ 'base' => NULL, 'refs' => [ 'AttributesRequireVerificationBeforeUpdateType$member' => NULL, 'VerifiedAttributesListType$member' => NULL, ], ], 'VerifiedAttributesListType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolRequest$AutoVerifiedAttributes' => '<p>The attributes to be auto-verified. Possible values: <b>email</b>, <b>phone_number</b>.</p>', 'UpdateUserPoolRequest$AutoVerifiedAttributes' => '<p>The attributes that are automatically verified when Amazon Cognito requests to update user pools.</p>', 'UserPoolType$AutoVerifiedAttributes' => '<p>The attributes that are auto-verified in a user pool.</p>', ], ], 'VerifySoftwareTokenRequest' => [ 'base' => NULL, 'refs' => [], ], 'VerifySoftwareTokenResponse' => [ 'base' => NULL, 'refs' => [], ], 'VerifySoftwareTokenResponseType' => [ 'base' => NULL, 'refs' => [ 'VerifySoftwareTokenResponse$Status' => '<p>The status of the verify software token.</p>', ], ], 'VerifyUserAttributeRequest' => [ 'base' => '<p>Represents the request to verify user attributes.</p>', 'refs' => [], ], 'VerifyUserAttributeResponse' => [ 'base' => '<p>A container representing the response from the server from the request to verify user attributes.</p>', 'refs' => [], ], 'WrappedBooleanType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolClientRequest$EnableTokenRevocation' => '<p>Activates or deactivates token revocation. For more information about revoking tokens, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html">RevokeToken</a>.</p> <p>If you don\'t include this parameter, token revocation is automatically activated for the new user pool client.</p>', 'CreateUserPoolClientRequest$EnablePropagateAdditionalUserContextData' => '<p>Activates the propagation of additional user context data. For more information about propagation of user context data, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-advanced-security.html"> Adding advanced security to a user pool</a>. If you don’t include this parameter, you can\'t send device fingerprint information, including source IP address, to Amazon Cognito advanced security. You can only activate <code>EnablePropagateAdditionalUserContextData</code> in an app client that has a client secret.</p>', 'EventRiskType$CompromisedCredentialsDetected' => '<p>Indicates whether compromised credentials were detected during an authentication event.</p>', 'UpdateUserPoolClientRequest$EnableTokenRevocation' => '<p>Activates or deactivates token revocation. For more information about revoking tokens, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html">RevokeToken</a>.</p>', 'UpdateUserPoolClientRequest$EnablePropagateAdditionalUserContextData' => '<p>Activates the propagation of additional user context data. For more information about propagation of user context data, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-advanced-security.html"> Adding advanced security to a user pool</a>. If you don’t include this parameter, you can\'t send device fingerprint information, including source IP address, to Amazon Cognito advanced security. You can only activate <code>EnablePropagateAdditionalUserContextData</code> in an app client that has a client secret.</p>', 'UserPoolClientType$EnableTokenRevocation' => '<p>Indicates whether token revocation is activated for the user pool client. When you create a new user pool client, token revocation is activated by default. For more information about revoking tokens, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html">RevokeToken</a>.</p>', 'UserPoolClientType$EnablePropagateAdditionalUserContextData' => '<p>When <code>EnablePropagateAdditionalUserContextData</code> is true, Amazon Cognito accepts an <code>IpAddress</code> value that you send in the <code>UserContextData</code> parameter. The <code>UserContextData</code> parameter sends information to Amazon Cognito advanced security for risk analysis. You can send <code>UserContextData</code> when you sign in Amazon Cognito native users with the <code>InitiateAuth</code> and <code>RespondToAuthChallenge</code> API operations.</p> <p>When <code>EnablePropagateAdditionalUserContextData</code> is false, you can\'t send your user\'s source IP address to Amazon Cognito advanced security with unauthenticated API operations. <code>EnablePropagateAdditionalUserContextData</code> doesn\'t affect whether you can send a source IP address in a <code>ContextData</code> parameter with the authenticated API operations <code>AdminInitiateAuth</code> and <code>AdminRespondToAuthChallenge</code>.</p> <p>You can only activate <code>EnablePropagateAdditionalUserContextData</code> in an app client that has a client secret. For more information about propagation of user context data, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-adaptive-authentication.html#user-pool-settings-adaptive-authentication-device-fingerprint">Adding user device and session data to API requests</a>.</p>', 'UsernameConfigurationType$CaseSensitive' => '<p>Specifies whether user name case sensitivity will be applied for all users in the user pool through Amazon Cognito APIs. For most use cases, set case sensitivity to <code>False</code> (case insensitive) as a best practice. When usernames and email addresses are case insensitive, users can sign in as the same user when they enter a different capitalization of their user name.</p> <p>Valid values include:</p> <dl> <dt>True</dt> <dd> <p>Enables case sensitivity for all username input. When this option is set to <code>True</code>, users must sign in using the exact capitalization of their given username, such as “UserName”. This is the default value.</p> </dd> <dt>False</dt> <dd> <p>Enables case insensitivity for all username input. For example, when this option is set to <code>False</code>, users can sign in using <code>username</code>, <code>USERNAME</code>, or <code>UserName</code>. This option also enables both <code>preferred_username</code> and <code>email</code> alias to be case insensitive, in addition to the <code>username</code> attribute.</p> </dd> </dl>', ], ], ],];
