<?php
// This file was auto-generated from sdk-root/src/data/dataexchange/2017-07-25/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>AWS Data Exchange is a service that makes it easy for AWS customers to exchange data in the cloud. You can use the AWS Data Exchange APIs to create, update, manage, and access file-based data set in the AWS Cloud.</p> <p>As a subscriber, you can view and access the data sets that you have an entitlement to through a subscription. You can use the APIs to download or copy your entitled data sets to Amazon Simple Storage Service (Amazon S3) for use across a variety of AWS analytics and machine learning services.</p> <p>As a provider, you can create and manage your data sets that you would like to publish to a product. Being able to package and provide your data sets into products requires a few steps to determine eligibility. For more information, visit the <i>AWS Data Exchange User Guide</i>.</p> <p>A data set is a collection of data that can be changed or updated over time. Data sets can be updated using revisions, which represent a new version or incremental change to a data set. A revision contains one or more assets. An asset in AWS Data Exchange is a piece of data that can be stored as an Amazon S3 object, Redshift datashare, API Gateway API, AWS Lake Formation data permission, or Amazon S3 data access. The asset can be a structured data file, an image file, or some other data file. Jobs are asynchronous import or export operations used to create or copy assets.</p>', 'operations' => [ 'CancelJob' => '<p>This operation cancels a job. Jobs can be cancelled only when they are in the WAITING state.</p>', 'CreateDataSet' => '<p>This operation creates a data set.</p>', 'CreateEventAction' => '<p>This operation creates an event action.</p>', 'CreateJob' => '<p>This operation creates a job.</p>', 'CreateRevision' => '<p>This operation creates a revision for a data set.</p>', 'DeleteAsset' => '<p>This operation deletes an asset.</p>', 'DeleteDataSet' => '<p>This operation deletes a data set.</p>', 'DeleteEventAction' => '<p>This operation deletes the event action.</p>', 'DeleteRevision' => '<p>This operation deletes a revision.</p>', 'GetAsset' => '<p>This operation returns information about an asset.</p>', 'GetDataSet' => '<p>This operation returns information about a data set.</p>', 'GetEventAction' => '<p>This operation retrieves information about an event action.</p>', 'GetJob' => '<p>This operation returns information about a job.</p>', 'GetRevision' => '<p>This operation returns information about a revision.</p>', 'ListDataSetRevisions' => '<p>This operation lists a data set\'s revisions sorted by CreatedAt in descending order.</p>', 'ListDataSets' => '<p>This operation lists your data sets. When listing by origin OWNED, results are sorted by CreatedAt in descending order. When listing by origin ENTITLED, there is no order and the maxResults parameter is ignored.</p>', 'ListEventActions' => '<p>This operation lists your event actions.</p>', 'ListJobs' => '<p>This operation lists your jobs sorted by CreatedAt in descending order.</p>', 'ListRevisionAssets' => '<p>This operation lists a revision\'s assets sorted alphabetically in descending order.</p>', 'ListTagsForResource' => '<p>This operation lists the tags on the resource.</p>', 'RevokeRevision' => '<p>This operation revokes subscribers\' access to a revision.</p>', 'SendApiAsset' => '<p>This operation invokes an API Gateway API asset. The request is proxied to the provider’s API Gateway API.</p>', 'SendDataSetNotification' => '<p>The type of event associated with the data set.</p>', 'StartJob' => '<p>This operation starts a job.</p>', 'TagResource' => '<p>This operation tags a resource.</p>', 'UntagResource' => '<p>This operation removes one or more tags from a resource.</p>', 'UpdateAsset' => '<p>This operation updates an asset.</p>', 'UpdateDataSet' => '<p>This operation updates a data set.</p>', 'UpdateEventAction' => '<p>This operation updates the event action.</p>', 'UpdateRevision' => '<p>This operation updates a revision.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>Access to the resource is denied.</p>', 'refs' => [], ], 'Action' => [ 'base' => '<p>What occurs after a certain event.</p>', 'refs' => [ 'CreateEventActionRequest$Action' => '<p>What occurs after a certain event.</p>', 'CreateEventActionResponse$Action' => '<p>What occurs after a certain event.</p>', 'EventActionEntry$Action' => '<p>What occurs after a certain event.</p>', 'GetEventActionResponse$Action' => '<p>What occurs after a certain event.</p>', 'UpdateEventActionRequest$Action' => '<p>What occurs after a certain event.</p>', 'UpdateEventActionResponse$Action' => '<p>What occurs after a certain event.</p>', ], ], 'ApiDescription' => [ 'base' => NULL, 'refs' => [ 'ApiGatewayApiAsset$ApiDescription' => '<p>The API description of the API asset.</p>', 'ImportAssetFromApiGatewayApiRequestDetails$ApiDescription' => '<p>The API description. Markdown supported.</p>', 'ImportAssetFromApiGatewayApiResponseDetails$ApiDescription' => '<p>The API description.</p>', ], ], 'ApiGatewayApiAsset' => [ 'base' => '<p>The API Gateway API that is the asset.</p>', 'refs' => [ 'AssetDetails$ApiGatewayApiAsset' => '<p>Information about the API Gateway API asset.</p>', ], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'AssetEntry$Arn' => '<p>The ARN for the asset.</p>', 'CreateDataSetResponse$Arn' => '<p>The ARN for the data set.</p>', 'CreateEventActionResponse$Arn' => '<p>The ARN for the event action.</p>', 'CreateJobResponse$Arn' => '<p>The ARN for the job.</p>', 'CreateRevisionResponse$Arn' => '<p>The ARN for the revision.</p>', 'DataSetEntry$Arn' => '<p>The ARN for the data set.</p>', 'EventActionEntry$Arn' => '<p>The Amazon Resource Name (ARN) for the event action.</p>', 'GetAssetResponse$Arn' => '<p>The ARN for the asset.</p>', 'GetDataSetResponse$Arn' => '<p>The ARN for the data set.</p>', 'GetEventActionResponse$Arn' => '<p>The ARN for the event action.</p>', 'GetJobResponse$Arn' => '<p>The ARN for the job.</p>', 'GetRevisionResponse$Arn' => '<p>The ARN for the revision.</p>', 'JobEntry$Arn' => '<p>The ARN for the job.</p>', 'RevisionEntry$Arn' => '<p>The ARN for the revision.</p>', 'RevokeRevisionResponse$Arn' => '<p>The ARN for the revision.</p>', 'UpdateAssetResponse$Arn' => '<p>The ARN for the asset.</p>', 'UpdateDataSetResponse$Arn' => '<p>The ARN for the data set.</p>', 'UpdateEventActionResponse$Arn' => '<p>The ARN for the event action.</p>', 'UpdateRevisionResponse$Arn' => '<p>The ARN for the revision.</p>', ], ], 'AssetDestinationEntry' => [ 'base' => '<p>The destination for the asset.</p>', 'refs' => [ 'ListOfAssetDestinationEntry$member' => NULL, ], ], 'AssetDetails' => [ 'base' => '<p>Details about the asset.</p>', 'refs' => [ 'AssetEntry$AssetDetails' => '<p>Details about the asset.</p>', 'GetAssetResponse$AssetDetails' => '<p>Details about the asset.</p>', 'UpdateAssetResponse$AssetDetails' => '<p>Details about the asset.</p>', ], ], 'AssetEntry' => [ 'base' => '<p>An asset in AWS Data Exchange is a piece of data (Amazon S3 object) or a means of fulfilling data (Amazon Redshift datashare or Amazon API Gateway API, AWS Lake Formation data permission, or Amazon S3 data access). The asset can be a structured data file, an image file, or some other data file that can be stored as an Amazon S3 object, an Amazon API Gateway API, or an Amazon Redshift datashare, an AWS Lake Formation data permission, or an Amazon S3 data access. When you create an import job for your files, API Gateway APIs, Amazon Redshift datashares, AWS Lake Formation data permission, or Amazon S3 data access, you create an asset in AWS Data Exchange.</p>', 'refs' => [ 'ListOfAssetEntry$member' => NULL, ], ], 'AssetName' => [ 'base' => NULL, 'refs' => [ 'AssetEntry$Name' => '<p>The name of the asset. When importing from Amazon S3, the Amazon S3 object key is used as the asset name. When exporting to Amazon S3, the asset name is used as default target Amazon S3 object key. When importing from Amazon API Gateway API, the API name is used as the asset name. When importing from Amazon Redshift, the datashare name is used as the asset name. When importing from AWS Lake Formation, the static values of "Database(s) included in LF-tag policy" or "Table(s) included in LF-tag policy" are used as the asset name.</p>', 'GetAssetResponse$Name' => '<p>The name of the asset. When importing from Amazon S3, the Amazon S3 object key is used as the asset name. When exporting to Amazon S3, the asset name is used as default target Amazon S3 object key. When importing from Amazon API Gateway API, the API name is used as the asset name. When importing from Amazon Redshift, the datashare name is used as the asset name. When importing from AWS Lake Formation, the static values of "Database(s) included in the LF-tag policy" or "Table(s) included in the LF-tag policy" are used as the asset name.</p>', 'ImportAssetFromSignedUrlJobErrorDetails$AssetName' => '<p>Details about the job error.</p>', 'ImportAssetFromSignedUrlRequestDetails$AssetName' => '<p>The name of the asset. When importing from Amazon S3, the Amazon S3 object key is used as the asset name.</p>', 'ImportAssetFromSignedUrlResponseDetails$AssetName' => '<p>The name for the asset associated with this import job.</p>', 'UpdateAssetRequest$Name' => '<p>The name of the asset. When importing from Amazon S3, the Amazon S3 object key is used as the asset name. When exporting to Amazon S3, the asset name is used as default target Amazon S3 object key. When importing from Amazon API Gateway API, the API name is used as the asset name. When importing from Amazon Redshift, the datashare name is used as the asset name. When importing from AWS Lake Formation, the static values of "Database(s) included in the LF-tag policy" or "Table(s) included in LF-tag policy" are used as the name.</p>', 'UpdateAssetResponse$Name' => '<p>The name of the asset. When importing from Amazon S3, the Amazon S3 object key is used as the asset name. When exporting to Amazon S3, the asset name is used as default target Amazon S3 object key. When importing from Amazon API Gateway API, the API name is used as the asset name. When importing from Amazon Redshift, the datashare name is used as the asset name. When importing from AWS Lake Formation, the static values of "Database(s) included in the LF-tag policy"- or "Table(s) included in LF-tag policy" are used as the asset name.</p>', ], ], 'AssetSourceEntry' => [ 'base' => '<p>The source of the assets.</p>', 'refs' => [ 'ListOfAssetSourceEntry$member' => NULL, ], ], 'AssetType' => [ 'base' => NULL, 'refs' => [ 'AssetEntry$AssetType' => '<p>The type of asset that is added to a data set.</p>', 'CreateDataSetRequest$AssetType' => '<p>The type of asset that is added to a data set.</p>', 'CreateDataSetResponse$AssetType' => '<p>The type of asset that is added to a data set.</p>', 'DataSetEntry$AssetType' => '<p>The type of asset that is added to a data set.</p>', 'GetAssetResponse$AssetType' => '<p>The type of asset that is added to a data set.</p>', 'GetDataSetResponse$AssetType' => '<p>The type of asset that is added to a data set.</p>', 'UpdateAssetResponse$AssetType' => '<p>The type of asset that is added to a data set.</p>', 'UpdateDataSetResponse$AssetType' => '<p>The type of asset that is added to a data set.</p>', ], ], 'AutoExportRevisionDestinationEntry' => [ 'base' => '<p>A revision destination is the Amazon S3 bucket folder destination to where the export will be sent.</p>', 'refs' => [ 'AutoExportRevisionToS3RequestDetails$RevisionDestination' => '<p>A revision destination is the Amazon S3 bucket folder destination to where the export will be sent.</p>', ], ], 'AutoExportRevisionToS3RequestDetails' => [ 'base' => '<p>Details of the operation to be performed by the job.</p>', 'refs' => [ 'Action$ExportRevisionToS3' => '<p>Details for the export revision to Amazon S3 action.</p>', ], ], 'AwsAccountId' => [ 'base' => NULL, 'refs' => [ 'ImportAssetsFromLakeFormationTagPolicyRequestDetails$CatalogId' => '<p>The identifier for the AWS Glue Data Catalog.</p>', 'ImportAssetsFromLakeFormationTagPolicyResponseDetails$CatalogId' => '<p>The identifier for the AWS Glue Data Catalog.</p>', 'LFTagPolicyDetails$CatalogId' => '<p>The identifier for the AWS Glue Data Catalog.</p>', ], ], 'CancelJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'SendDataSetNotificationRequest$ClientToken' => '<p>Idempotency key for the notification, this key allows us to deduplicate notifications that are sent in quick succession erroneously.</p>', ], ], 'Code' => [ 'base' => NULL, 'refs' => [ 'JobError$Code' => '<p>The code for the job error.</p>', ], ], 'ConflictException' => [ 'base' => '<p>The request couldn\'t be completed because it conflicted with the current state of the resource.</p>', 'refs' => [], ], 'CreateDataSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDataSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateEventActionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateEventActionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateRevisionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateRevisionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateS3DataAccessFromS3BucketRequestDetails' => [ 'base' => '<p>Details of the operation to create an Amazon S3 data access from an S3 bucket.</p>', 'refs' => [ 'RequestDetails$CreateS3DataAccessFromS3Bucket' => '<p>Details of the request to create S3 data access from the Amazon S3 bucket.</p>', ], ], 'CreateS3DataAccessFromS3BucketResponseDetails' => [ 'base' => '<p>Details about the response of the operation to create an S3 data access from an S3 bucket.</p>', 'refs' => [ 'ResponseDetails$CreateS3DataAccessFromS3Bucket' => '<p>Response details from the CreateS3DataAccessFromS3Bucket job.</p>', ], ], 'DataSetEntry' => [ 'base' => '<p>A data set is an AWS resource with one or more revisions.</p>', 'refs' => [ 'ListOfDataSetEntry$member' => NULL, ], ], 'DataUpdateRequestDetails' => [ 'base' => '<p>Extra details specific to a data update type notification.</p>', 'refs' => [ 'NotificationDetails$DataUpdate' => '<p>Extra details specific to a data update type notification.</p>', ], ], 'DatabaseLFTagPolicy' => [ 'base' => '<p>The LF-tag policy for database resources.</p>', 'refs' => [ 'LFResourceDetails$Database' => '<p>Details about the database resource included in the AWS Lake Formation data permission.</p>', ], ], 'DatabaseLFTagPolicyAndPermissions' => [ 'base' => '<p>The LF-tag policy and permissions for database resources.</p>', 'refs' => [ 'ImportAssetsFromLakeFormationTagPolicyRequestDetails$Database' => '<p>A structure for the database object.</p>', 'ImportAssetsFromLakeFormationTagPolicyResponseDetails$Database' => '<p>A structure for the database object.</p>', ], ], 'DatabaseLFTagPolicyPermission' => [ 'base' => NULL, 'refs' => [ 'ListOfDatabaseLFTagPolicyPermissions$member' => NULL, ], ], 'DeleteAssetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDataSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEventActionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRevisionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeprecationRequestDetails' => [ 'base' => '<p>Extra details specific to a deprecation type notification.</p>', 'refs' => [ 'NotificationDetails$Deprecation' => '<p>Extra details specific to a deprecation type notification.</p>', ], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'CreateDataSetRequest$Description' => '<p>A description for the data set. This value can be up to 16,348 characters long.</p>', 'CreateDataSetResponse$Description' => '<p>The description for the data set.</p>', 'DataSetEntry$Description' => '<p>The description for the data set.</p>', 'GetDataSetResponse$Description' => '<p>The description for the data set.</p>', 'UpdateDataSetRequest$Description' => '<p>The description for the data set.</p>', 'UpdateDataSetResponse$Description' => '<p>The description for the data set.</p>', ], ], 'Details' => [ 'base' => '<p>Information about the job error.</p>', 'refs' => [ 'JobError$Details' => '<p>The details about the job error.</p>', ], ], 'Event' => [ 'base' => '<p>What occurs to start an action.</p>', 'refs' => [ 'CreateEventActionRequest$Event' => '<p>What occurs to start an action.</p>', 'CreateEventActionResponse$Event' => '<p>What occurs to start an action.</p>', 'EventActionEntry$Event' => '<p>What occurs to start an action.</p>', 'GetEventActionResponse$Event' => '<p>What occurs to start an action.</p>', 'UpdateEventActionResponse$Event' => '<p>What occurs to start an action.</p>', ], ], 'EventActionEntry' => [ 'base' => '<p>An event action is an object that defines the relationship between a specific event and an automated action that will be taken on behalf of the customer.</p>', 'refs' => [ 'ListOfEventActionEntry$member' => NULL, ], ], 'ExceptionCause' => [ 'base' => NULL, 'refs' => [ 'ValidationException$ExceptionCause' => '<p>The unique identifier for the resource that couldn\'t be found.</p>', ], ], 'ExportAssetToSignedUrlRequestDetails' => [ 'base' => '<p>Details of the operation to be performed by the job.</p>', 'refs' => [ 'RequestDetails$ExportAssetToSignedUrl' => '<p>Details about the export to signed URL request.</p>', ], ], 'ExportAssetToSignedUrlResponseDetails' => [ 'base' => '<p>The details of the export to signed URL response.</p>', 'refs' => [ 'ResponseDetails$ExportAssetToSignedUrl' => '<p>Details for the export to signed URL response.</p>', ], ], 'ExportAssetsToS3RequestDetails' => [ 'base' => '<p>Details of the operation to be performed by the job.</p>', 'refs' => [ 'RequestDetails$ExportAssetsToS3' => '<p>Details about the export to Amazon S3 request.</p>', ], ], 'ExportAssetsToS3ResponseDetails' => [ 'base' => '<p>Details about the export to Amazon S3 response.</p>', 'refs' => [ 'ResponseDetails$ExportAssetsToS3' => '<p>Details for the export to Amazon S3 response.</p>', ], ], 'ExportRevisionsToS3RequestDetails' => [ 'base' => '<p>Details of the operation to be performed by the job.</p>', 'refs' => [ 'RequestDetails$ExportRevisionsToS3' => '<p>Details about the export to Amazon S3 request.</p>', ], ], 'ExportRevisionsToS3ResponseDetails' => [ 'base' => '<p>Details about the export revisions to Amazon S3 response.</p>', 'refs' => [ 'ResponseDetails$ExportRevisionsToS3' => '<p>Details for the export revisions to Amazon S3 response.</p>', ], ], 'ExportServerSideEncryption' => [ 'base' => '<p>Encryption configuration of the export job. Includes the encryption type in addition to the AWS KMS key. The KMS key is only necessary if you chose the KMS encryption type.</p>', 'refs' => [ 'AutoExportRevisionToS3RequestDetails$Encryption' => '<p>Encryption configuration for the auto export job.</p>', 'ExportAssetsToS3RequestDetails$Encryption' => '<p>Encryption configuration for the export job.</p>', 'ExportAssetsToS3ResponseDetails$Encryption' => '<p>Encryption configuration of the export job.</p>', 'ExportRevisionsToS3RequestDetails$Encryption' => '<p>Encryption configuration for the export job.</p>', 'ExportRevisionsToS3ResponseDetails$Encryption' => '<p>Encryption configuration of the export job.</p>', ], ], 'GetAssetRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAssetResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetDataSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDataSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetEventActionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetEventActionResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetRevisionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRevisionResponse' => [ 'base' => NULL, 'refs' => [], ], 'Id' => [ 'base' => NULL, 'refs' => [ 'AssetDestinationEntry$AssetId' => '<p>The unique identifier for the asset.</p>', 'AssetEntry$DataSetId' => '<p>The unique identifier for the data set associated with this asset.</p>', 'AssetEntry$Id' => '<p>The unique identifier for the asset.</p>', 'AssetEntry$RevisionId' => '<p>The unique identifier for the revision associated with this asset.</p>', 'AssetEntry$SourceId' => '<p>The asset ID of the owned asset corresponding to the entitled asset being viewed. This parameter is returned when an asset owner is viewing the entitled copy of its owned asset.</p>', 'CreateDataSetResponse$Id' => '<p>The unique identifier for the data set.</p>', 'CreateDataSetResponse$SourceId' => '<p>The data set ID of the owned data set corresponding to the entitled data set being viewed. This parameter is returned when a data set owner is viewing the entitled copy of its owned data set.</p>', 'CreateEventActionResponse$Id' => '<p>The unique identifier for the event action.</p>', 'CreateJobResponse$Id' => '<p>The unique identifier for the job.</p>', 'CreateRevisionResponse$DataSetId' => '<p>The unique identifier for the data set associated with the data set revision.</p>', 'CreateRevisionResponse$Id' => '<p>The unique identifier for the revision.</p>', 'CreateRevisionResponse$SourceId' => '<p>The revision ID of the owned revision corresponding to the entitled revision being viewed. This parameter is returned when a revision owner is viewing the entitled copy of its owned revision.</p>', 'CreateS3DataAccessFromS3BucketRequestDetails$DataSetId' => '<p>The unique identifier for the data set associated with the creation of this Amazon S3 data access.</p>', 'CreateS3DataAccessFromS3BucketRequestDetails$RevisionId' => '<p>The unique identifier for a revision.</p>', 'CreateS3DataAccessFromS3BucketResponseDetails$DataSetId' => '<p>The unique identifier for this data set.</p>', 'CreateS3DataAccessFromS3BucketResponseDetails$RevisionId' => '<p>The unique identifier for the revision.</p>', 'DataSetEntry$Id' => '<p>The unique identifier for the data set.</p>', 'DataSetEntry$SourceId' => '<p>The data set ID of the owned data set corresponding to the entitled data set being viewed. This parameter is returned when a data set owner is viewing the entitled copy of its owned data set.</p>', 'EventActionEntry$Id' => '<p>The unique identifier for the event action.</p>', 'ExportAssetToSignedUrlRequestDetails$AssetId' => '<p>The unique identifier for the asset that is exported to a signed URL.</p>', 'ExportAssetToSignedUrlRequestDetails$DataSetId' => '<p>The unique identifier for the data set associated with this export job.</p>', 'ExportAssetToSignedUrlRequestDetails$RevisionId' => '<p>The unique identifier for the revision associated with this export request.</p>', 'ExportAssetToSignedUrlResponseDetails$AssetId' => '<p>The unique identifier for the asset associated with this export job.</p>', 'ExportAssetToSignedUrlResponseDetails$DataSetId' => '<p>The unique identifier for the data set associated with this export job.</p>', 'ExportAssetToSignedUrlResponseDetails$RevisionId' => '<p>The unique identifier for the revision associated with this export response.</p>', 'ExportAssetsToS3RequestDetails$DataSetId' => '<p>The unique identifier for the data set associated with this export job.</p>', 'ExportAssetsToS3RequestDetails$RevisionId' => '<p>The unique identifier for the revision associated with this export request.</p>', 'ExportAssetsToS3ResponseDetails$DataSetId' => '<p>The unique identifier for the data set associated with this export job.</p>', 'ExportAssetsToS3ResponseDetails$RevisionId' => '<p>The unique identifier for the revision associated with this export response.</p>', 'ExportRevisionsToS3RequestDetails$DataSetId' => '<p>The unique identifier for the data set associated with this export job.</p>', 'ExportRevisionsToS3ResponseDetails$DataSetId' => '<p>The unique identifier for the data set associated with this export job.</p>', 'GetAssetResponse$DataSetId' => '<p>The unique identifier for the data set associated with this asset.</p>', 'GetAssetResponse$Id' => '<p>The unique identifier for the asset.</p>', 'GetAssetResponse$RevisionId' => '<p>The unique identifier for the revision associated with this asset.</p>', 'GetAssetResponse$SourceId' => '<p>The asset ID of the owned asset corresponding to the entitled asset being viewed. This parameter is returned when an asset owner is viewing the entitled copy of its owned asset.</p>', 'GetDataSetResponse$Id' => '<p>The unique identifier for the data set.</p>', 'GetDataSetResponse$SourceId' => '<p>The data set ID of the owned data set corresponding to the entitled data set being viewed. This parameter is returned when a data set owner is viewing the entitled copy of its owned data set.</p>', 'GetEventActionResponse$Id' => '<p>The unique identifier for the event action.</p>', 'GetJobResponse$Id' => '<p>The unique identifier for the job.</p>', 'GetRevisionResponse$DataSetId' => '<p>The unique identifier for the data set associated with the data set revision.</p>', 'GetRevisionResponse$Id' => '<p>The unique identifier for the revision.</p>', 'GetRevisionResponse$SourceId' => '<p>The revision ID of the owned revision corresponding to the entitled revision being viewed. This parameter is returned when a revision owner is viewing the entitled copy of its owned revision.</p>', 'ImportAssetFromApiGatewayApiRequestDetails$DataSetId' => '<p>The data set ID.</p>', 'ImportAssetFromApiGatewayApiRequestDetails$RevisionId' => '<p>The revision ID.</p>', 'ImportAssetFromApiGatewayApiResponseDetails$DataSetId' => '<p>The data set ID.</p>', 'ImportAssetFromApiGatewayApiResponseDetails$RevisionId' => '<p>The revision ID.</p>', 'ImportAssetFromSignedUrlRequestDetails$DataSetId' => '<p>The unique identifier for the data set associated with this import job.</p>', 'ImportAssetFromSignedUrlRequestDetails$RevisionId' => '<p>The unique identifier for the revision associated with this import request.</p>', 'ImportAssetFromSignedUrlResponseDetails$DataSetId' => '<p>The unique identifier for the data set associated with this import job.</p>', 'ImportAssetFromSignedUrlResponseDetails$RevisionId' => '<p>The unique identifier for the revision associated with this import response.</p>', 'ImportAssetsFromLakeFormationTagPolicyRequestDetails$DataSetId' => '<p>The unique identifier for the data set associated with this import job.</p>', 'ImportAssetsFromLakeFormationTagPolicyRequestDetails$RevisionId' => '<p>The unique identifier for the revision associated with this import job.</p>', 'ImportAssetsFromLakeFormationTagPolicyResponseDetails$DataSetId' => '<p>The unique identifier for the data set associated with this import job.</p>', 'ImportAssetsFromLakeFormationTagPolicyResponseDetails$RevisionId' => '<p>The unique identifier for the revision associated with this import job.</p>', 'ImportAssetsFromRedshiftDataSharesRequestDetails$DataSetId' => '<p>The unique identifier for the data set associated with this import job.</p>', 'ImportAssetsFromRedshiftDataSharesRequestDetails$RevisionId' => '<p>The unique identifier for the revision associated with this import job.</p>', 'ImportAssetsFromRedshiftDataSharesResponseDetails$DataSetId' => '<p>The unique identifier for the data set associated with this import job.</p>', 'ImportAssetsFromRedshiftDataSharesResponseDetails$RevisionId' => '<p>The unique identifier for the revision associated with this import job.</p>', 'ImportAssetsFromS3RequestDetails$DataSetId' => '<p>The unique identifier for the data set associated with this import job.</p>', 'ImportAssetsFromS3RequestDetails$RevisionId' => '<p>The unique identifier for the revision associated with this import request.</p>', 'ImportAssetsFromS3ResponseDetails$DataSetId' => '<p>The unique identifier for the data set associated with this import job.</p>', 'ImportAssetsFromS3ResponseDetails$RevisionId' => '<p>The unique identifier for the revision associated with this import response.</p>', 'JobEntry$Id' => '<p>The unique identifier for the job.</p>', 'RevisionDestinationEntry$RevisionId' => '<p>The unique identifier for the revision.</p>', 'RevisionEntry$DataSetId' => '<p>The unique identifier for the data set associated with the data set revision.</p>', 'RevisionEntry$Id' => '<p>The unique identifier for the revision.</p>', 'RevisionEntry$SourceId' => '<p>The revision ID of the owned revision corresponding to the entitled revision being viewed. This parameter is returned when a revision owner is viewing the entitled copy of its owned revision.</p>', 'RevisionPublished$DataSetId' => '<p>The data set ID of the published revision.</p>', 'RevokeRevisionResponse$DataSetId' => '<p>The unique identifier for the data set associated with the data set revision.</p>', 'RevokeRevisionResponse$Id' => '<p>The unique identifier for the revision.</p>', 'RevokeRevisionResponse$SourceId' => '<p>The revision ID of the owned revision corresponding to the entitled revision being viewed. This parameter is returned when a revision owner is viewing the entitled copy of its owned revision.</p>', 'UpdateAssetResponse$DataSetId' => '<p>The unique identifier for the data set associated with this asset.</p>', 'UpdateAssetResponse$Id' => '<p>The unique identifier for the asset.</p>', 'UpdateAssetResponse$RevisionId' => '<p>The unique identifier for the revision associated with this asset.</p>', 'UpdateAssetResponse$SourceId' => '<p>The asset ID of the owned asset corresponding to the entitled asset being viewed. This parameter is returned when an asset owner is viewing the entitled copy of its owned asset.</p>', 'UpdateDataSetResponse$Id' => '<p>The unique identifier for the data set.</p>', 'UpdateDataSetResponse$SourceId' => '<p>The data set ID of the owned data set corresponding to the entitled data set being viewed. This parameter is returned when a data set owner is viewing the entitled copy of its owned data set.</p>', 'UpdateEventActionResponse$Id' => '<p>The unique identifier for the event action.</p>', 'UpdateRevisionResponse$DataSetId' => '<p>The unique identifier for the data set associated with the data set revision.</p>', 'UpdateRevisionResponse$Id' => '<p>The unique identifier for the revision.</p>', 'UpdateRevisionResponse$SourceId' => '<p>The revision ID of the owned revision corresponding to the entitled revision being viewed. This parameter is returned when a revision owner is viewing the entitled copy of its owned revision.</p>', ], ], 'ImportAssetFromApiGatewayApiRequestDetails' => [ 'base' => '<p>The request details.</p>', 'refs' => [ 'RequestDetails$ImportAssetFromApiGatewayApi' => '<p>Details about the import from signed URL request.</p>', ], ], 'ImportAssetFromApiGatewayApiResponseDetails' => [ 'base' => '<p>The response details.</p>', 'refs' => [ 'ResponseDetails$ImportAssetFromApiGatewayApi' => '<p>The response details.</p>', ], ], 'ImportAssetFromSignedUrlJobErrorDetails' => [ 'base' => '<p>Details about the job error.</p>', 'refs' => [ 'Details$ImportAssetFromSignedUrlJobErrorDetails' => '<p>Information about the job error.</p>', ], ], 'ImportAssetFromSignedUrlRequestDetails' => [ 'base' => '<p>Details of the operation to be performed by the job.</p>', 'refs' => [ 'RequestDetails$ImportAssetFromSignedUrl' => '<p>Details about the import from Amazon S3 request.</p>', ], ], 'ImportAssetFromSignedUrlResponseDetails' => [ 'base' => '<p>The details in the response for an import request, including the signed URL and other information.</p>', 'refs' => [ 'ResponseDetails$ImportAssetFromSignedUrl' => '<p>Details for the import from signed URL response.</p>', ], ], 'ImportAssetsFromLakeFormationTagPolicyRequestDetails' => [ 'base' => '<p>Details about the assets imported from an AWS Lake Formation tag policy request.</p>', 'refs' => [ 'RequestDetails$ImportAssetsFromLakeFormationTagPolicy' => '<p>Request details for the ImportAssetsFromLakeFormationTagPolicy job.</p>', ], ], 'ImportAssetsFromLakeFormationTagPolicyResponseDetails' => [ 'base' => '<p>Details from an import AWS Lake Formation tag policy job response.</p>', 'refs' => [ 'ResponseDetails$ImportAssetsFromLakeFormationTagPolicy' => '<p>Response details from the ImportAssetsFromLakeFormationTagPolicy job.</p>', ], ], 'ImportAssetsFromRedshiftDataSharesRequestDetails' => [ 'base' => '<p>Details from an import from Amazon Redshift datashare request.</p>', 'refs' => [ 'RequestDetails$ImportAssetsFromRedshiftDataShares' => '<p>Details from an import from Amazon Redshift datashare request.</p>', ], ], 'ImportAssetsFromRedshiftDataSharesResponseDetails' => [ 'base' => '<p>Details from an import from Amazon Redshift datashare response.</p>', 'refs' => [ 'ResponseDetails$ImportAssetsFromRedshiftDataShares' => '<p>Details from an import from Amazon Redshift datashare response.</p>', ], ], 'ImportAssetsFromS3RequestDetails' => [ 'base' => '<p>Details of the operation to be performed by the job.</p>', 'refs' => [ 'RequestDetails$ImportAssetsFromS3' => '<p>Details about the import asset from API Gateway API request.</p>', ], ], 'ImportAssetsFromS3ResponseDetails' => [ 'base' => '<p>Details from an import from Amazon S3 response.</p>', 'refs' => [ 'ResponseDetails$ImportAssetsFromS3' => '<p>Details for the import from Amazon S3 response.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>An exception occurred with the service.</p>', 'refs' => [], ], 'JobEntry' => [ 'base' => '<p>AWS Data Exchange Jobs are asynchronous import or export operations used to create or copy assets. A data set owner can both import and export as they see fit. Someone with an entitlement to a data set can only export. Jobs are deleted 90 days after they are created.</p>', 'refs' => [ 'ListOfJobEntry$member' => NULL, ], ], 'JobError' => [ 'base' => '<p>An error that occurred with the job request.</p>', 'refs' => [ 'ListOfJobError$member' => NULL, ], ], 'JobErrorLimitName' => [ 'base' => NULL, 'refs' => [ 'JobError$LimitName' => '<p>The name of the limit that was reached.</p>', ], ], 'JobErrorResourceTypes' => [ 'base' => NULL, 'refs' => [ 'JobError$ResourceType' => '<p>The type of resource related to the error.</p>', ], ], 'KmsKeyArn' => [ 'base' => NULL, 'refs' => [ 'KmsKeyToGrant$KmsKeyArn' => '<p>The AWS KMS CMK (Key Management System Customer Managed Key) used to encrypt S3 objects in the shared S3 Bucket. AWS Data exchange will create a KMS grant for each subscriber to allow them to access and decrypt their entitled data that is encrypted using this KMS key specified.</p>', ], ], 'KmsKeyToGrant' => [ 'base' => '<p>The Amazon Resource Name (ARN) of the AWS KMS key used to encrypt the shared S3 objects.</p>', 'refs' => [ 'ListOfKmsKeysToGrant$member' => NULL, ], ], 'LFPermission' => [ 'base' => NULL, 'refs' => [ 'ListOfLFPermissions$member' => NULL, ], ], 'LFResourceDetails' => [ 'base' => '<p>Details about the AWS Lake Formation resource (Table or Database) included in the AWS Lake Formation data permission.</p>', 'refs' => [ 'LFTagPolicyDetails$ResourceDetails' => '<p>Details for the Lake Formation Resources included in the LF-tag policy.</p>', ], ], 'LFResourceType' => [ 'base' => NULL, 'refs' => [ 'LFTagPolicyDetails$ResourceType' => '<p>The resource type for which the LF-tag policy applies.</p>', ], ], 'LFTag' => [ 'base' => '<p>A structure that allows an LF-admin to grant permissions on certain conditions.</p>', 'refs' => [ 'ListOfLFTags$member' => NULL, ], ], 'LFTagPolicyDetails' => [ 'base' => '<p>Details about the LF-tag policy.</p>', 'refs' => [ 'LakeFormationDataPermissionDetails$LFTagPolicy' => '<p>Details about the LF-tag policy.</p>', ], ], 'LakeFormationDataPermissionAsset' => [ 'base' => '<p>The AWS Lake Formation data permission asset.</p>', 'refs' => [ 'AssetDetails$LakeFormationDataPermissionAsset' => '<p>The AWS Lake Formation data permission that is the asset.</p>', ], ], 'LakeFormationDataPermissionDetails' => [ 'base' => '<p>Details about the AWS Lake Formation data permission.</p>', 'refs' => [ 'LakeFormationDataPermissionAsset$LakeFormationDataPermissionDetails' => '<p>Details about the AWS Lake Formation data permission.</p>', ], ], 'LakeFormationDataPermissionType' => [ 'base' => NULL, 'refs' => [ 'LakeFormationDataPermissionAsset$LakeFormationDataPermissionType' => '<p>The data permission type.</p>', ], ], 'LakeFormationTagPolicyDetails' => [ 'base' => '<p>Extra details specific to the affected scope in this LF data set.</p>', 'refs' => [ 'ListOfLakeFormationTagPolicies$member' => NULL, ], ], 'LimitName' => [ 'base' => NULL, 'refs' => [ 'ServiceLimitExceededException$LimitName' => '<p>The name of the limit that was reached.</p>', ], ], 'ListDataSetRevisionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDataSetRevisionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDataSetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDataSetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListEventActionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListEventActionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListOfAssetDestinationEntry' => [ 'base' => NULL, 'refs' => [ 'ExportAssetsToS3RequestDetails$AssetDestinations' => '<p>The destination for the asset.</p>', 'ExportAssetsToS3ResponseDetails$AssetDestinations' => '<p>The destination in Amazon S3 where the asset is exported.</p>', ], ], 'ListOfAssetEntry' => [ 'base' => NULL, 'refs' => [ 'ListRevisionAssetsResponse$Assets' => '<p>The asset objects listed by the request.</p>', ], ], 'ListOfAssetSourceEntry' => [ 'base' => NULL, 'refs' => [ 'Details$ImportAssetsFromS3JobErrorDetails' => '<p>Details about the job error.</p>', 'ImportAssetsFromS3RequestDetails$AssetSources' => '<p>Is a list of Amazon S3 bucket and object key pairs.</p>', 'ImportAssetsFromS3ResponseDetails$AssetSources' => '<p>Is a list of Amazon S3 bucket and object key pairs.</p>', ], ], 'ListOfDataSetEntry' => [ 'base' => NULL, 'refs' => [ 'ListDataSetsResponse$DataSets' => '<p>The data set objects listed by the request.</p>', ], ], 'ListOfDatabaseLFTagPolicyPermissions' => [ 'base' => NULL, 'refs' => [ 'DatabaseLFTagPolicyAndPermissions$Permissions' => '<p>The permissions granted to subscribers on database resources.</p>', ], ], 'ListOfEventActionEntry' => [ 'base' => NULL, 'refs' => [ 'ListEventActionsResponse$EventActions' => '<p>The event action objects listed by the request.</p>', ], ], 'ListOfJobEntry' => [ 'base' => NULL, 'refs' => [ 'ListJobsResponse$Jobs' => '<p>The jobs listed by the request.</p>', ], ], 'ListOfJobError' => [ 'base' => NULL, 'refs' => [ 'CreateJobResponse$Errors' => '<p>The errors associated with jobs.</p>', 'GetJobResponse$Errors' => '<p>The errors associated with jobs.</p>', 'JobEntry$Errors' => '<p>Errors for jobs.</p>', ], ], 'ListOfKmsKeysToGrant' => [ 'base' => NULL, 'refs' => [ 'S3DataAccessAsset$KmsKeysToGrant' => '<p> List of AWS KMS CMKs (Key Management System Customer Managed Keys) and ARNs used to encrypt S3 objects being shared in this S3 Data Access asset. Providers must include all AWS KMS keys used to encrypt these shared S3 objects.</p>', 'S3DataAccessAssetSourceEntry$KmsKeysToGrant' => '<p>List of AWS KMS CMKs (Key Management System Customer Managed Keys) and ARNs used to encrypt S3 objects being shared in this S3 Data Access asset.</p>', ], ], 'ListOfLFPermissions' => [ 'base' => NULL, 'refs' => [ 'LakeFormationDataPermissionAsset$Permissions' => '<p>The permissions granted to the subscribers on the resource.</p>', ], ], 'ListOfLFTagValues' => [ 'base' => NULL, 'refs' => [ 'LFTag$TagValues' => '<p>A list of LF-tag values.</p>', ], ], 'ListOfLFTags' => [ 'base' => NULL, 'refs' => [ 'DatabaseLFTagPolicy$Expression' => '<p>A list of LF-tag conditions that apply to database resources.</p>', 'DatabaseLFTagPolicyAndPermissions$Expression' => '<p>A list of LF-tag conditions that apply to database resources.</p>', 'TableLFTagPolicy$Expression' => '<p>A list of LF-tag conditions that apply to table resources.</p>', 'TableLFTagPolicyAndPermissions$Expression' => '<p>A list of LF-tag conditions that apply to table resources.</p>', ], ], 'ListOfLakeFormationTagPolicies' => [ 'base' => NULL, 'refs' => [ 'ScopeDetails$LakeFormationTagPolicies' => '<p>Underlying LF resources that will be affected by this notification.</p>', ], ], 'ListOfRedshiftDataShareAssetSourceEntry' => [ 'base' => NULL, 'refs' => [ 'ImportAssetsFromRedshiftDataSharesRequestDetails$AssetSources' => '<p>A list of Amazon Redshift datashare assets.</p>', 'ImportAssetsFromRedshiftDataSharesResponseDetails$AssetSources' => '<p>A list of Amazon Redshift datashare asset sources.</p>', ], ], 'ListOfRedshiftDataShares' => [ 'base' => NULL, 'refs' => [ 'ScopeDetails$RedshiftDataShares' => '<p>Underlying Redshift resources that will be affected by this notification.</p>', ], ], 'ListOfRevisionDestinationEntry' => [ 'base' => NULL, 'refs' => [ 'ExportRevisionsToS3RequestDetails$RevisionDestinations' => '<p>The destination for the revision.</p>', 'ExportRevisionsToS3ResponseDetails$RevisionDestinations' => '<p>The destination in Amazon S3 where the revision is exported.</p>', ], ], 'ListOfRevisionEntry' => [ 'base' => NULL, 'refs' => [ 'ListDataSetRevisionsResponse$Revisions' => '<p>The asset objects listed by the request.</p>', ], ], 'ListOfS3DataAccesses' => [ 'base' => NULL, 'refs' => [ 'ScopeDetails$S3DataAccesses' => '<p>Underlying S3 resources that will be affected by this notification.</p>', ], ], 'ListOfSchemaChangeDetails' => [ 'base' => NULL, 'refs' => [ 'SchemaChangeRequestDetails$Changes' => '<p>List of schema changes happening in the scope of this notification. This can have up to 100 entries.</p>', ], ], 'ListOfTableTagPolicyLFPermissions' => [ 'base' => NULL, 'refs' => [ 'TableLFTagPolicyAndPermissions$Permissions' => '<p>The permissions granted to subscribers on table resources.</p>', ], ], 'ListOf__string' => [ 'base' => NULL, 'refs' => [ 'S3DataAccessAsset$KeyPrefixes' => '<p>The Amazon S3 bucket used for hosting shared data in the Amazon S3 data access.</p>', 'S3DataAccessAsset$Keys' => '<p>S3 keys made available using this asset.</p>', 'S3DataAccessAssetSourceEntry$KeyPrefixes' => '<p>Organizes Amazon S3 asset key prefixes stored in an Amazon S3 bucket.</p>', 'S3DataAccessAssetSourceEntry$Keys' => '<p>The keys used to create the Amazon S3 data access.</p>', 'S3DataAccessDetails$KeyPrefixes' => '<p>A list of the key prefixes affected by this notification. This can have up to 50 entries.</p>', 'S3DataAccessDetails$Keys' => '<p>A list of the keys affected by this notification. This can have up to 50 entries.</p>', 'UntagResourceRequest$TagKeys' => '<p>The key tags.</p>', ], ], 'ListRevisionAssetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRevisionAssetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'MapOf__string' => [ 'base' => NULL, 'refs' => [ 'CreateDataSetRequest$Tags' => '<p>A data set tag is an optional label that you can assign to a data set when you create it. Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to these data sets and revisions.</p>', 'CreateDataSetResponse$Tags' => '<p>The tags for the data set.</p>', 'CreateRevisionRequest$Tags' => '<p>A revision tag is an optional label that you can assign to a revision when you create it. Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to these data sets and revisions.</p>', 'CreateRevisionResponse$Tags' => '<p>The tags for the revision.</p>', 'GetDataSetResponse$Tags' => '<p>The tags for the data set.</p>', 'GetRevisionResponse$Tags' => '<p>The tags for the revision.</p>', 'ListTagsForResourceResponse$Tags' => '<p>A label that consists of a customer-defined key and an optional value.</p>', 'SendApiAssetRequest$QueryStringParameters' => '<p>Attach query string parameters to the end of the URI (for example, /v1/examplePath?exampleParam=exampleValue).</p>', 'SendApiAssetRequest$RequestHeaders' => '<p>Any header value prefixed with x-amzn-dataexchange-header- will have that stripped before sending the Asset API request. Use this when you want to override a header that AWS Data Exchange uses. Alternatively, you can use the header without a prefix to the HTTP request.</p>', 'SendApiAssetResponse$ResponseHeaders' => '<p>The response headers from the underlying API tracked by the API asset.</p>', 'TagResourceRequest$Tags' => '<p>A label that consists of a customer-defined key and an optional value.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListDataSetRevisionsRequest$MaxResults' => '<p>The maximum number of results returned by a single call.</p>', 'ListDataSetsRequest$MaxResults' => '<p>The maximum number of results returned by a single call.</p>', 'ListEventActionsRequest$MaxResults' => '<p>The maximum number of results returned by a single call.</p>', 'ListJobsRequest$MaxResults' => '<p>The maximum number of results returned by a single call.</p>', 'ListRevisionAssetsRequest$MaxResults' => '<p>The maximum number of results returned by a single call.</p>', ], ], 'Name' => [ 'base' => NULL, 'refs' => [ 'CreateDataSetRequest$Name' => '<p>The name of the data set.</p>', 'CreateDataSetResponse$Name' => '<p>The name of the data set.</p>', 'DataSetEntry$Name' => '<p>The name of the data set.</p>', 'GetDataSetResponse$Name' => '<p>The name of the data set.</p>', 'UpdateDataSetRequest$Name' => '<p>The name of the data set.</p>', 'UpdateDataSetResponse$Name' => '<p>The name of the data set.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListDataSetRevisionsResponse$NextToken' => '<p>The token value retrieved from a previous call to access the next page of results.</p>', 'ListDataSetsResponse$NextToken' => '<p>The token value retrieved from a previous call to access the next page of results.</p>', 'ListEventActionsResponse$NextToken' => '<p>The token value retrieved from a previous call to access the next page of results.</p>', 'ListJobsResponse$NextToken' => '<p>The token value retrieved from a previous call to access the next page of results.</p>', 'ListRevisionAssetsResponse$NextToken' => '<p>The token value retrieved from a previous call to access the next page of results.</p>', ], ], 'NotificationDetails' => [ 'base' => '<p>Extra details specific to this notification.</p>', 'refs' => [ 'SendDataSetNotificationRequest$Details' => '<p>Extra details specific to this notification type.</p>', ], ], 'NotificationType' => [ 'base' => NULL, 'refs' => [ 'SendDataSetNotificationRequest$Type' => '<p>The type of the notification. Describing the kind of event the notification is alerting you to.</p>', ], ], 'Origin' => [ 'base' => NULL, 'refs' => [ 'CreateDataSetResponse$Origin' => '<p>A property that defines the data set as OWNED by the account (for providers) or ENTITLED to the account (for subscribers).</p>', 'DataSetEntry$Origin' => '<p>A property that defines the data set as OWNED by the account (for providers) or ENTITLED to the account (for subscribers).</p>', 'GetDataSetResponse$Origin' => '<p>A property that defines the data set as OWNED by the account (for providers) or ENTITLED to the account (for subscribers).</p>', 'UpdateDataSetResponse$Origin' => '<p>A property that defines the data set as OWNED by the account (for providers) or ENTITLED to the account (for subscribers).</p>', ], ], 'OriginDetails' => [ 'base' => '<p>Details about the origin of the data set.</p>', 'refs' => [ 'CreateDataSetResponse$OriginDetails' => '<p>If the origin of this data set is ENTITLED, includes the details for the product on AWS Marketplace.</p>', 'DataSetEntry$OriginDetails' => '<p>If the origin of this data set is ENTITLED, includes the details for the product on AWS Marketplace.</p>', 'GetDataSetResponse$OriginDetails' => '<p>If the origin of this data set is ENTITLED, includes the details for the product on AWS Marketplace.</p>', 'UpdateDataSetResponse$OriginDetails' => '<p>If the origin of this data set is ENTITLED, includes the details for the product on AWS Marketplace.</p>', ], ], 'ProtocolType' => [ 'base' => NULL, 'refs' => [ 'ApiGatewayApiAsset$ProtocolType' => '<p>The protocol type of the API asset.</p>', 'ImportAssetFromApiGatewayApiRequestDetails$ProtocolType' => '<p>The protocol type.</p>', 'ImportAssetFromApiGatewayApiResponseDetails$ProtocolType' => '<p>The protocol type.</p>', ], ], 'RedshiftDataShareAsset' => [ 'base' => '<p>The Amazon Redshift datashare asset.</p>', 'refs' => [ 'AssetDetails$RedshiftDataShareAsset' => '<p>The Amazon Redshift datashare that is the asset.</p>', ], ], 'RedshiftDataShareAssetSourceEntry' => [ 'base' => '<p>The source of the Amazon Redshift datashare asset.</p>', 'refs' => [ 'ListOfRedshiftDataShareAssetSourceEntry$member' => NULL, ], ], 'RedshiftDataShareDetails' => [ 'base' => '<p>Extra details specific to the affected scope in this Redshift data set.</p>', 'refs' => [ 'ListOfRedshiftDataShares$member' => NULL, ], ], 'RequestDetails' => [ 'base' => '<p>The details for the request.</p>', 'refs' => [ 'CreateJobRequest$Details' => '<p>The details for the CreateJob request.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The resource couldn\'t be found.</p>', 'refs' => [], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'ConflictException$ResourceType' => '<p>The type of the resource with the conflict.</p>', 'ResourceNotFoundException$ResourceType' => '<p>The type of resource that couldn\'t be found.</p>', ], ], 'ResponseDetails' => [ 'base' => '<p>Details for the response.</p>', 'refs' => [ 'CreateJobResponse$Details' => '<p>Details about the job.</p>', 'GetJobResponse$Details' => '<p>Details about the job.</p>', 'JobEntry$Details' => '<p>Details of the operation to be performed by the job, such as export destination details or import source details.</p>', ], ], 'RevisionDestinationEntry' => [ 'base' => '<p>The destination where the assets in the revision will be exported.</p>', 'refs' => [ 'ListOfRevisionDestinationEntry$member' => NULL, ], ], 'RevisionEntry' => [ 'base' => '<p>A revision is a container for one or more assets.</p>', 'refs' => [ 'ListOfRevisionEntry$member' => NULL, ], ], 'RevisionPublished' => [ 'base' => '<p>Information about the published revision.</p>', 'refs' => [ 'Event$RevisionPublished' => '<p>What occurs to start the revision publish action.</p>', ], ], 'RevokeRevisionRequest' => [ 'base' => NULL, 'refs' => [], ], 'RevokeRevisionResponse' => [ 'base' => NULL, 'refs' => [], ], 'RoleArn' => [ 'base' => NULL, 'refs' => [ 'ImportAssetsFromLakeFormationTagPolicyRequestDetails$RoleArn' => '<p>The IAM role\'s ARN that allows AWS Data Exchange to assume the role and grant and revoke permissions of subscribers to AWS Lake Formation data permissions.</p>', 'ImportAssetsFromLakeFormationTagPolicyResponseDetails$RoleArn' => '<p>The IAM role\'s ARN that allows AWS Data Exchange to assume the role and grant and revoke permissions to AWS Lake Formation data permissions.</p>', 'LakeFormationDataPermissionAsset$RoleArn' => '<p>The IAM role\'s ARN that allows AWS Data Exchange to assume the role and grant and revoke permissions to AWS Lake Formation data permissions.</p>', ], ], 'S3DataAccessAsset' => [ 'base' => '<p>The Amazon S3 data access that is the asset.</p>', 'refs' => [ 'AssetDetails$S3DataAccessAsset' => '<p>The Amazon S3 data access that is the asset.</p>', ], ], 'S3DataAccessAssetSourceEntry' => [ 'base' => '<p>Source details for an Amazon S3 data access asset.</p>', 'refs' => [ 'CreateS3DataAccessFromS3BucketRequestDetails$AssetSource' => '<p>Details about the S3 data access source asset.</p>', 'CreateS3DataAccessFromS3BucketResponseDetails$AssetSource' => '<p>Details about the asset source from an Amazon S3 bucket.</p>', ], ], 'S3DataAccessDetails' => [ 'base' => '<p>Extra details specific to the affected scope in this S3 Data Access data set.</p>', 'refs' => [ 'ListOfS3DataAccesses$member' => NULL, ], ], 'S3SnapshotAsset' => [ 'base' => '<p>The Amazon S3 object that is the asset.</p>', 'refs' => [ 'AssetDetails$S3SnapshotAsset' => '<p>The Amazon S3 object that is the asset.</p>', ], ], 'SchemaChangeDetails' => [ 'base' => '<p>Object encompassing information about a schema change to a single, particular field, a notification can have up to 100 of these.</p>', 'refs' => [ 'ListOfSchemaChangeDetails$member' => NULL, ], ], 'SchemaChangeRequestDetails' => [ 'base' => '<p>Extra details specific to this schema change type notification.</p>', 'refs' => [ 'NotificationDetails$SchemaChange' => '<p>Extra details specific to a schema change type notification.</p>', ], ], 'SchemaChangeType' => [ 'base' => NULL, 'refs' => [ 'SchemaChangeDetails$Type' => '<p>Is the field being added, removed, or modified?</p>', ], ], 'ScopeDetails' => [ 'base' => '<p>Details about the scope of the notifications such as the affected resources.</p>', 'refs' => [ 'SendDataSetNotificationRequest$Scope' => '<p>Affected scope of this notification such as the underlying resources affected by the notification event.</p>', ], ], 'SendApiAssetRequest' => [ 'base' => NULL, 'refs' => [], ], 'SendApiAssetResponse' => [ 'base' => NULL, 'refs' => [], ], 'SendDataSetNotificationRequest' => [ 'base' => NULL, 'refs' => [], ], 'SendDataSetNotificationResponse' => [ 'base' => NULL, 'refs' => [], ], 'ServerSideEncryptionTypes' => [ 'base' => NULL, 'refs' => [ 'ExportServerSideEncryption$Type' => '<p>The type of server side encryption used for encrypting the objects in Amazon S3.</p>', ], ], 'ServiceLimitExceededException' => [ 'base' => '<p>The request has exceeded the quotas imposed by the service.</p>', 'refs' => [], ], 'StartJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'State' => [ 'base' => NULL, 'refs' => [ 'CreateJobResponse$State' => '<p>The state of the job.</p>', 'GetJobResponse$State' => '<p>The state of the job.</p>', 'JobEntry$State' => '<p>The state of the job.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'LFTag$TagKey' => '<p>The key name for the LF-tag.</p>', 'ListOfLFTagValues$member' => NULL, ], ], 'TableLFTagPolicy' => [ 'base' => '<p>The LF-tag policy for a table resource.</p>', 'refs' => [ 'LFResourceDetails$Table' => '<p>Details about the table resource included in the AWS Lake Formation data permission.</p>', ], ], 'TableLFTagPolicyAndPermissions' => [ 'base' => '<p>The LF-tag policy and permissions that apply to table resources.</p>', 'refs' => [ 'ImportAssetsFromLakeFormationTagPolicyRequestDetails$Table' => '<p>A structure for the table object.</p>', 'ImportAssetsFromLakeFormationTagPolicyResponseDetails$Table' => '<p>A structure for the table object.</p>', ], ], 'TableTagPolicyLFPermission' => [ 'base' => NULL, 'refs' => [ 'ListOfTableTagPolicyLFPermissions$member' => NULL, ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ThrottlingException' => [ 'base' => '<p>The limit on the number of requests per second was exceeded.</p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'ApiGatewayApiAsset$ApiSpecificationDownloadUrlExpiresAt' => '<p>The date and time that the upload URL expires, in ISO 8601 format.</p>', 'AssetEntry$CreatedAt' => '<p>The date and time that the asset was created, in ISO 8601 format.</p>', 'AssetEntry$UpdatedAt' => '<p>The date and time that the asset was last updated, in ISO 8601 format.</p>', 'CreateDataSetResponse$CreatedAt' => '<p>The date and time that the data set was created, in ISO 8601 format.</p>', 'CreateDataSetResponse$UpdatedAt' => '<p>The date and time that the data set was last updated, in ISO 8601 format.</p>', 'CreateEventActionResponse$CreatedAt' => '<p>The date and time that the event action was created, in ISO 8601 format.</p>', 'CreateEventActionResponse$UpdatedAt' => '<p>The date and time that the event action was last updated, in ISO 8601 format.</p>', 'CreateJobResponse$CreatedAt' => '<p>The date and time that the job was created, in ISO 8601 format.</p>', 'CreateJobResponse$UpdatedAt' => '<p>The date and time that the job was last updated, in ISO 8601 format.</p>', 'CreateRevisionResponse$CreatedAt' => '<p>The date and time that the revision was created, in ISO 8601 format.</p>', 'CreateRevisionResponse$UpdatedAt' => '<p>The date and time that the revision was last updated, in ISO 8601 format.</p>', 'CreateRevisionResponse$RevokedAt' => '<p>The date and time that the revision was revoked, in ISO 8601 format.</p>', 'DataSetEntry$CreatedAt' => '<p>The date and time that the data set was created, in ISO 8601 format.</p>', 'DataSetEntry$UpdatedAt' => '<p>The date and time that the data set was last updated, in ISO 8601 format.</p>', 'DataUpdateRequestDetails$DataUpdatedAt' => '<p>A datetime in the past when the data was updated. This typically means that the underlying resource supporting the data set was updated.</p>', 'DeprecationRequestDetails$DeprecationAt' => '<p>A datetime in the future when the data set will be deprecated.</p>', 'EventActionEntry$CreatedAt' => '<p>The date and time that the event action was created, in ISO 8601 format.</p>', 'EventActionEntry$UpdatedAt' => '<p>The date and time that the event action was last updated, in ISO 8601 format.</p>', 'ExportAssetToSignedUrlResponseDetails$SignedUrlExpiresAt' => '<p>The date and time that the signed URL expires, in ISO 8601 format.</p>', 'GetAssetResponse$CreatedAt' => '<p>The date and time that the asset was created, in ISO 8601 format.</p>', 'GetAssetResponse$UpdatedAt' => '<p>The date and time that the asset was last updated, in ISO 8601 format.</p>', 'GetDataSetResponse$CreatedAt' => '<p>The date and time that the data set was created, in ISO 8601 format.</p>', 'GetDataSetResponse$UpdatedAt' => '<p>The date and time that the data set was last updated, in ISO 8601 format.</p>', 'GetEventActionResponse$CreatedAt' => '<p>The date and time that the event action was created, in ISO 8601 format.</p>', 'GetEventActionResponse$UpdatedAt' => '<p>The date and time that the event action was last updated, in ISO 8601 format.</p>', 'GetJobResponse$CreatedAt' => '<p>The date and time that the job was created, in ISO 8601 format.</p>', 'GetJobResponse$UpdatedAt' => '<p>The date and time that the job was last updated, in ISO 8601 format.</p>', 'GetRevisionResponse$CreatedAt' => '<p>The date and time that the revision was created, in ISO 8601 format.</p>', 'GetRevisionResponse$UpdatedAt' => '<p>The date and time that the revision was last updated, in ISO 8601 format.</p>', 'GetRevisionResponse$RevokedAt' => '<p>The date and time that the revision was revoked, in ISO 8601 format.</p>', 'ImportAssetFromApiGatewayApiResponseDetails$ApiSpecificationUploadUrlExpiresAt' => '<p>The date and time that the upload URL expires, in ISO 8601 format.</p>', 'ImportAssetFromSignedUrlResponseDetails$SignedUrlExpiresAt' => '<p>The time and date at which the signed URL expires, in ISO 8601 format.</p>', 'JobEntry$CreatedAt' => '<p>The date and time that the job was created, in ISO 8601 format.</p>', 'JobEntry$UpdatedAt' => '<p>The date and time that the job was last updated, in ISO 8601 format.</p>', 'RevisionEntry$CreatedAt' => '<p>The date and time that the revision was created, in ISO 8601 format.</p>', 'RevisionEntry$UpdatedAt' => '<p>The date and time that the revision was last updated, in ISO 8601 format.</p>', 'RevisionEntry$RevokedAt' => '<p>The date and time that the revision was revoked, in ISO 8601 format.</p>', 'RevokeRevisionResponse$CreatedAt' => '<p>The date and time that the revision was created, in ISO 8601 format.</p>', 'RevokeRevisionResponse$UpdatedAt' => '<p>The date and time that the revision was last updated, in ISO 8601 format.</p>', 'RevokeRevisionResponse$RevokedAt' => '<p>The date and time that the revision was revoked, in ISO 8601 format.</p>', 'SchemaChangeRequestDetails$SchemaChangeAt' => '<p>A date in the future when the schema change is taking effect.</p>', 'UpdateAssetResponse$CreatedAt' => '<p>The date and time that the asset was created, in ISO 8601 format.</p>', 'UpdateAssetResponse$UpdatedAt' => '<p>The date and time that the asset was last updated, in ISO 8601 format.</p>', 'UpdateDataSetResponse$CreatedAt' => '<p>The date and time that the data set was created, in ISO 8601 format.</p>', 'UpdateDataSetResponse$UpdatedAt' => '<p>The date and time that the data set was last updated, in ISO 8601 format.</p>', 'UpdateEventActionResponse$CreatedAt' => '<p>The date and time that the event action was created, in ISO 8601 format.</p>', 'UpdateEventActionResponse$UpdatedAt' => '<p>The date and time that the event action was last updated, in ISO 8601 format.</p>', 'UpdateRevisionResponse$CreatedAt' => '<p>The date and time that the revision was created, in ISO 8601 format.</p>', 'UpdateRevisionResponse$UpdatedAt' => '<p>The date and time that the revision was last updated, in ISO 8601 format.</p>', 'UpdateRevisionResponse$RevokedAt' => '<p>The date and time that the revision was revoked, in ISO 8601 format.</p>', ], ], 'Type' => [ 'base' => NULL, 'refs' => [ 'CreateJobRequest$Type' => '<p>The type of job to be created.</p>', 'CreateJobResponse$Type' => '<p>The job type.</p>', 'GetJobResponse$Type' => '<p>The job type.</p>', 'JobEntry$Type' => '<p>The job type.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAssetRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAssetResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDataSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDataSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEventActionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEventActionResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRevisionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRevisionResponse' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>The request was invalid.</p>', 'refs' => [], ], '__boolean' => [ 'base' => NULL, 'refs' => [ 'CreateRevisionResponse$Finalized' => '<p>To publish a revision to a data set in a product, the revision must first be finalized. Finalizing a revision tells AWS Data Exchange that your changes to the assets in the revision are complete. After it\'s in this read-only state, you can publish the revision to your products. Finalized revisions can be published through the AWS Data Exchange console or the AWS Marketplace Catalog API, using the StartChangeSet AWS Marketplace Catalog API action. When using the API, revisions are uniquely identified by their ARN.</p>', 'CreateRevisionResponse$Revoked' => '<p>A status indicating that subscribers\' access to the revision was revoked.</p>', 'GetRevisionResponse$Finalized' => '<p>To publish a revision to a data set in a product, the revision must first be finalized. Finalizing a revision tells AWS Data Exchange that your changes to the assets in the revision are complete. After it\'s in this read-only state, you can publish the revision to your products. Finalized revisions can be published through the AWS Data Exchange console or the AWS Marketplace Catalog API, using the StartChangeSet AWS Marketplace Catalog API action. When using the API, revisions are uniquely identified by their ARN.</p>', 'GetRevisionResponse$Revoked' => '<p>A status indicating that subscribers\' access to the revision was revoked.</p>', 'RevisionEntry$Finalized' => '<p>To publish a revision to a data set in a product, the revision must first be finalized. Finalizing a revision tells AWS Data Exchange that your changes to the assets in the revision are complete. After it\'s in this read-only state, you can publish the revision to your products. Finalized revisions can be published through the AWS Data Exchange console or the AWS Marketplace Catalog API, using the StartChangeSet AWS Marketplace Catalog API action. When using the API, revisions are uniquely identified by their ARN.</p>', 'RevisionEntry$Revoked' => '<p>A status indicating that subscribers\' access to the revision was revoked.</p>', 'RevokeRevisionResponse$Finalized' => '<p>To publish a revision to a data set in a product, the revision must first be finalized. Finalizing a revision tells AWS Data Exchange that changes to the assets in the revision are complete. After it\'s in this read-only state, you can publish the revision to your products. Finalized revisions can be published through the AWS Data Exchange console or the AWS Marketplace Catalog API, using the StartChangeSet AWS Marketplace Catalog API action. When using the API, revisions are uniquely identified by their ARN.</p>', 'RevokeRevisionResponse$Revoked' => '<p>A status indicating that subscribers\' access to the revision was revoked.</p>', 'UpdateRevisionRequest$Finalized' => '<p>Finalizing a revision tells AWS Data Exchange that your changes to the assets in the revision are complete. After it\'s in this read-only state, you can publish the revision to your products.</p>', 'UpdateRevisionResponse$Finalized' => '<p>To publish a revision to a data set in a product, the revision must first be finalized. Finalizing a revision tells AWS Data Exchange that changes to the assets in the revision are complete. After it\'s in this read-only state, you can publish the revision to your products. Finalized revisions can be published through the AWS Data Exchange console or the AWS Marketplace Catalog API, using the StartChangeSet AWS Marketplace Catalog API action. When using the API, revisions are uniquely identified by their ARN.</p>', 'UpdateRevisionResponse$Revoked' => '<p>A status indicating that subscribers\' access to the revision was revoked.</p>', ], ], '__double' => [ 'base' => NULL, 'refs' => [ 'JobError$LimitValue' => '<p>The value of the exceeded limit.</p>', 'ServiceLimitExceededException$LimitValue' => '<p>The value of the exceeded limit.</p>', ], ], '__doubleMin0' => [ 'base' => NULL, 'refs' => [ 'S3SnapshotAsset$Size' => '<p>The size of the Amazon S3 object that is the object.</p>', ], ], '__string' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => '<p>Access to the resource is denied.</p>', 'ApiGatewayApiAsset$ApiEndpoint' => '<p>The API endpoint of the API asset.</p>', 'ApiGatewayApiAsset$ApiId' => '<p>The unique identifier of the API asset.</p>', 'ApiGatewayApiAsset$ApiKey' => '<p>The API key of the API asset.</p>', 'ApiGatewayApiAsset$ApiName' => '<p>The API name of the API asset.</p>', 'ApiGatewayApiAsset$ApiSpecificationDownloadUrl' => '<p>The download URL of the API specification of the API asset.</p>', 'ApiGatewayApiAsset$Stage' => '<p>The stage of the API asset.</p>', 'AssetDestinationEntry$Bucket' => '<p>The Amazon S3 bucket that is the destination for the asset.</p>', 'AssetDestinationEntry$Key' => '<p>The name of the object in Amazon S3 for the asset.</p>', 'AssetSourceEntry$Bucket' => '<p>The Amazon S3 bucket that\'s part of the source of the asset.</p>', 'AssetSourceEntry$Key' => '<p>The name of the object in Amazon S3 for the asset.</p>', 'AutoExportRevisionDestinationEntry$Bucket' => '<p>The Amazon S3 bucket that is the destination for the event action.</p>', 'AutoExportRevisionDestinationEntry$KeyPattern' => '<p>A string representing the pattern for generated names of the individual assets in the revision. For more information about key patterns, see <a href="https://docs.aws.amazon.com/data-exchange/latest/userguide/jobs.html#revision-export-keypatterns">Key patterns when exporting revisions</a>.</p>', 'CancelJobRequest$JobId' => '<p>The unique identifier for a job.</p>', 'ConflictException$Message' => '<p>The request couldn\'t be completed because it conflicted with the current state of the resource.</p>', 'ConflictException$ResourceId' => '<p>The unique identifier for the resource with the conflict.</p>', 'CreateRevisionRequest$DataSetId' => '<p>The unique identifier for a data set.</p>', 'DeleteAssetRequest$AssetId' => '<p>The unique identifier for an asset.</p>', 'DeleteAssetRequest$DataSetId' => '<p>The unique identifier for a data set.</p>', 'DeleteAssetRequest$RevisionId' => '<p>The unique identifier for a revision.</p>', 'DeleteDataSetRequest$DataSetId' => '<p>The unique identifier for a data set.</p>', 'DeleteEventActionRequest$EventActionId' => '<p>The unique identifier for the event action.</p>', 'DeleteRevisionRequest$DataSetId' => '<p>The unique identifier for a data set.</p>', 'DeleteRevisionRequest$RevisionId' => '<p>The unique identifier for a revision.</p>', 'ExportAssetToSignedUrlResponseDetails$SignedUrl' => '<p>The signed URL for the export request.</p>', 'ExportRevisionsToS3ResponseDetails$EventActionArn' => '<p>The Amazon Resource Name (ARN) of the event action.</p>', 'ExportServerSideEncryption$KmsKeyArn' => '<p>The Amazon Resource Name (ARN) of the AWS KMS key you want to use to encrypt the Amazon S3 objects. This parameter is required if you choose aws:kms as an encryption type.</p>', 'GetAssetRequest$AssetId' => '<p>The unique identifier for an asset.</p>', 'GetAssetRequest$DataSetId' => '<p>The unique identifier for a data set.</p>', 'GetAssetRequest$RevisionId' => '<p>The unique identifier for a revision.</p>', 'GetDataSetRequest$DataSetId' => '<p>The unique identifier for a data set.</p>', 'GetEventActionRequest$EventActionId' => '<p>The unique identifier for the event action.</p>', 'GetJobRequest$JobId' => '<p>The unique identifier for a job.</p>', 'GetRevisionRequest$DataSetId' => '<p>The unique identifier for a data set.</p>', 'GetRevisionRequest$RevisionId' => '<p>The unique identifier for a revision.</p>', 'ImportAssetFromApiGatewayApiRequestDetails$ApiId' => '<p>The API Gateway API ID.</p>', 'ImportAssetFromApiGatewayApiRequestDetails$ApiKey' => '<p>The API Gateway API key.</p>', 'ImportAssetFromApiGatewayApiRequestDetails$ApiName' => '<p>The API name.</p>', 'ImportAssetFromApiGatewayApiRequestDetails$Stage' => '<p>The API stage.</p>', 'ImportAssetFromApiGatewayApiResponseDetails$ApiId' => '<p>The API ID.</p>', 'ImportAssetFromApiGatewayApiResponseDetails$ApiKey' => '<p>The API key.</p>', 'ImportAssetFromApiGatewayApiResponseDetails$ApiName' => '<p>The API name.</p>', 'ImportAssetFromApiGatewayApiResponseDetails$ApiSpecificationUploadUrl' => '<p>The upload URL of the API specification.</p>', 'ImportAssetFromApiGatewayApiResponseDetails$Stage' => '<p>The API stage.</p>', 'ImportAssetFromSignedUrlResponseDetails$SignedUrl' => '<p>The signed URL.</p>', 'InternalServerException$Message' => '<p>The message identifying the service exception that occurred.</p>', 'JobError$Message' => '<p>The message related to the job error.</p>', 'JobError$ResourceId' => '<p>The unique identifier for the resource related to the error.</p>', 'LakeFormationTagPolicyDetails$Database' => '<p>The underlying Glue database that the notification is referring to.</p>', 'LakeFormationTagPolicyDetails$Table' => '<p>The underlying Glue table that the notification is referring to.</p>', 'ListDataSetRevisionsRequest$DataSetId' => '<p>The unique identifier for a data set.</p>', 'ListDataSetRevisionsRequest$NextToken' => '<p>The token value retrieved from a previous call to access the next page of results.</p>', 'ListDataSetsRequest$NextToken' => '<p>The token value retrieved from a previous call to access the next page of results.</p>', 'ListDataSetsRequest$Origin' => '<p>A property that defines the data set as OWNED by the account (for providers) or ENTITLED to the account (for subscribers).</p>', 'ListEventActionsRequest$EventSourceId' => '<p>The unique identifier for the event source.</p>', 'ListEventActionsRequest$NextToken' => '<p>The token value retrieved from a previous call to access the next page of results.</p>', 'ListJobsRequest$DataSetId' => '<p>The unique identifier for a data set.</p>', 'ListJobsRequest$NextToken' => '<p>The token value retrieved from a previous call to access the next page of results.</p>', 'ListJobsRequest$RevisionId' => '<p>The unique identifier for a revision.</p>', 'ListOf__string$member' => NULL, 'ListRevisionAssetsRequest$DataSetId' => '<p>The unique identifier for a data set.</p>', 'ListRevisionAssetsRequest$NextToken' => '<p>The token value retrieved from a previous call to access the next page of results.</p>', 'ListRevisionAssetsRequest$RevisionId' => '<p>The unique identifier for a revision.</p>', 'ListTagsForResourceRequest$ResourceArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies an AWS resource.</p>', 'MapOf__string$key' => NULL, 'MapOf__string$value' => NULL, 'OriginDetails$ProductId' => '<p>The product ID of the origin of the data set.</p>', 'RedshiftDataShareAsset$Arn' => '<p>The Amazon Resource Name (ARN) of the datashare asset.</p>', 'RedshiftDataShareAssetSourceEntry$DataShareArn' => '<p>The Amazon Resource Name (ARN) of the datashare asset.</p>', 'RedshiftDataShareDetails$Arn' => '<p>The ARN of the underlying Redshift data share that is being affected by this notification.</p>', 'RedshiftDataShareDetails$Database' => '<p>The database name in the Redshift data share that is being affected by this notification.</p>', 'RedshiftDataShareDetails$Function' => '<p>A function name in the Redshift database that is being affected by this notification.</p>', 'RedshiftDataShareDetails$Table' => '<p>A table name in the Redshift database that is being affected by this notification.</p>', 'RedshiftDataShareDetails$Schema' => '<p>A schema name in the Redshift database that is being affected by this notification.</p>', 'RedshiftDataShareDetails$View' => '<p>A view name in the Redshift database that is being affected by this notification.</p>', 'ResourceNotFoundException$Message' => '<p>The resource couldn\'t be found.</p>', 'ResourceNotFoundException$ResourceId' => '<p>The unique identifier for the resource that couldn\'t be found.</p>', 'RevisionDestinationEntry$Bucket' => '<p>The Amazon S3 bucket that is the destination for the assets in the revision.</p>', 'RevisionDestinationEntry$KeyPattern' => '<p>A string representing the pattern for generated names of the individual assets in the revision. For more information about key patterns, see <a href="https://docs.aws.amazon.com/data-exchange/latest/userguide/jobs.html#revision-export-keypatterns">Key patterns when exporting revisions</a>.</p>', 'RevokeRevisionRequest$DataSetId' => '<p>The unique identifier for a data set.</p>', 'RevokeRevisionRequest$RevisionId' => '<p>The unique identifier for a revision.</p>', 'S3DataAccessAsset$Bucket' => '<p>The Amazon S3 bucket hosting data to be shared in the S3 data access.</p>', 'S3DataAccessAsset$S3AccessPointAlias' => '<p>The automatically-generated bucket-style alias for your Amazon S3 Access Point. Customers can access their entitled data using the S3 Access Point alias.</p>', 'S3DataAccessAsset$S3AccessPointArn' => '<p>The ARN for your Amazon S3 Access Point. Customers can also access their entitled data using the S3 Access Point ARN.</p>', 'S3DataAccessAssetSourceEntry$Bucket' => '<p>The Amazon S3 bucket used for hosting shared data in the Amazon S3 data access.</p>', 'SchemaChangeDetails$Name' => '<p>Name of the changing field. This value can be up to 255 characters long.</p>', 'SchemaChangeDetails$Description' => '<p>Description of what\'s changing about this field. This value can be up to 512 characters long.</p>', 'SendApiAssetRequest$Body' => '<p>The request body.</p>', 'SendApiAssetRequest$AssetId' => '<p>Asset ID value for the API request.</p>', 'SendApiAssetRequest$DataSetId' => '<p>Data set ID value for the API request.</p>', 'SendApiAssetRequest$Method' => '<p>HTTP method value for the API request. Alternatively, you can use the appropriate verb in your request.</p>', 'SendApiAssetRequest$Path' => '<p>URI path value for the API request. Alternatively, you can set the URI path directly by invoking /v1/{pathValue}.</p>', 'SendApiAssetRequest$RevisionId' => '<p>Revision ID value for the API request.</p>', 'SendApiAssetResponse$Body' => '<p>The response body from the underlying API tracked by the API asset.</p>', 'SendDataSetNotificationRequest$DataSetId' => '<p>Affected data set of the notification.</p>', 'ServiceLimitExceededException$Message' => '<p>The request has exceeded the quotas imposed by the service.</p>', 'StartJobRequest$JobId' => '<p>The unique identifier for a job.</p>', 'TagResourceRequest$ResourceArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies an AWS resource.</p>', 'ThrottlingException$Message' => '<p>The limit on the number of requests per second was exceeded.</p>', 'UntagResourceRequest$ResourceArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies an AWS resource.</p>', 'UpdateAssetRequest$AssetId' => '<p>The unique identifier for an asset.</p>', 'UpdateAssetRequest$DataSetId' => '<p>The unique identifier for a data set.</p>', 'UpdateAssetRequest$RevisionId' => '<p>The unique identifier for a revision.</p>', 'UpdateDataSetRequest$DataSetId' => '<p>The unique identifier for a data set.</p>', 'UpdateEventActionRequest$EventActionId' => '<p>The unique identifier for the event action.</p>', 'UpdateRevisionRequest$DataSetId' => '<p>The unique identifier for a data set.</p>', 'UpdateRevisionRequest$RevisionId' => '<p>The unique identifier for a revision.</p>', 'ValidationException$Message' => '<p>The message that informs you about what was invalid about the request.</p>', ], ], '__stringMin0Max16384' => [ 'base' => NULL, 'refs' => [ 'CreateRevisionRequest$Comment' => '<p>An optional comment about the revision.</p>', 'CreateRevisionResponse$Comment' => '<p>An optional comment about the revision.</p>', 'GetRevisionResponse$Comment' => '<p>An optional comment about the revision.</p>', 'RevisionEntry$Comment' => '<p>An optional comment about the revision.</p>', 'RevokeRevisionResponse$Comment' => '<p>An optional comment about the revision.</p>', 'UpdateRevisionRequest$Comment' => '<p>An optional comment about the revision.</p>', 'UpdateRevisionResponse$Comment' => '<p>An optional comment about the revision.</p>', ], ], '__stringMin0Max4096' => [ 'base' => NULL, 'refs' => [ 'SendDataSetNotificationRequest$Comment' => '<p>Free-form text field for providers to add information about their notifications.</p>', ], ], '__stringMin10Max512' => [ 'base' => NULL, 'refs' => [ 'CreateRevisionResponse$RevocationComment' => '<p>A required comment to inform subscribers of the reason their access to the revision was revoked.</p>', 'GetRevisionResponse$RevocationComment' => '<p>A required comment to inform subscribers of the reason their access to the revision was revoked.</p>', 'RevisionEntry$RevocationComment' => '<p>A required comment to inform subscribers of the reason their access to the revision was revoked.</p>', 'RevokeRevisionRequest$RevocationComment' => '<p>A required comment to inform subscribers of the reason their access to the revision was revoked.</p>', 'RevokeRevisionResponse$RevocationComment' => '<p>A required comment to inform subscribers of the reason their access to the revision was revoked.</p>', 'UpdateRevisionResponse$RevocationComment' => '<p>A required comment to inform subscribers of the reason their access to the revision was revoked.</p>', ], ], '__stringMin24Max24PatternAZaZ094AZaZ092AZaZ093' => [ 'base' => NULL, 'refs' => [ 'ImportAssetFromApiGatewayApiRequestDetails$ApiSpecificationMd5Hash' => '<p>The Base64-encoded MD5 hash of the OpenAPI 3.0 JSON API specification file. It is used to ensure the integrity of the file.</p>', 'ImportAssetFromApiGatewayApiResponseDetails$ApiSpecificationMd5Hash' => '<p>The Base64-encoded Md5 hash for the API asset, used to ensure the integrity of the API at that location.</p>', 'ImportAssetFromSignedUrlRequestDetails$Md5Hash' => '<p>The Base64-encoded Md5 hash for the asset, used to ensure the integrity of the file at that location.</p>', 'ImportAssetFromSignedUrlResponseDetails$Md5Hash' => '<p>The Base64-encoded Md5 hash for the asset, used to ensure the integrity of the file at that location.</p>', ], ], ],];
