<?php
// This file was auto-generated from sdk-root/src/data/deadline/2023-10-12/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>The Amazon Web Services Deadline Cloud API provides infrastructure and centralized management for your projects. Use the Deadline Cloud API to onboard users, assign projects, and attach permissions specific to their job function.</p> <p>With Deadline Cloud, content production teams can deploy resources for their workforce securely in the cloud, reducing the costs of added physical infrastructure. Keep your content production operations secure, while allowing your contributors to access the tools they need, such as scalable high-speed storage, licenses, and cost management services.</p>', 'operations' => [ 'AssociateMemberToFarm' => '<p>Assigns a farm membership level to a member.</p>', 'AssociateMemberToFleet' => '<p>Assigns a fleet membership level to a member.</p>', 'AssociateMemberToJob' => '<p>Assigns a job membership level to a member</p>', 'AssociateMemberToQueue' => '<p>Assigns a queue membership level to a member</p>', 'AssumeFleetRoleForRead' => '<p>Get Amazon Web Services credentials from the fleet role. The IAM permissions of the credentials are scoped down to have read-only access.</p>', 'AssumeFleetRoleForWorker' => '<p>Get credentials from the fleet role for a worker.</p>', 'AssumeQueueRoleForRead' => '<p>Gets Amazon Web Services credentials from the queue role. The IAM permissions of the credentials are scoped down to have read-only access.</p>', 'AssumeQueueRoleForUser' => '<p>Allows a user to assume a role for a queue.</p>', 'AssumeQueueRoleForWorker' => '<p>Allows a worker to assume a queue role.</p>', 'BatchGetJobEntity' => '<p>Get batched job details for a worker.</p>', 'CopyJobTemplate' => '<p>Copies a job template to an Amazon S3 bucket.</p>', 'CreateBudget' => '<p>Creates a budget to set spending thresholds for your rendering activity.</p>', 'CreateFarm' => '<p>Creates a farm to allow space for queues and fleets. Farms are the space where the components of your renders gather and are pieced together in the cloud. Farms contain budgets and allow you to enforce permissions. Deadline Cloud farms are a useful container for large projects.</p>', 'CreateFleet' => '<p>Creates a fleet. Fleets gather information relating to compute, or capacity, for renders within your farms. You can choose to manage your own capacity or opt to have fleets fully managed by Deadline Cloud.</p>', 'CreateJob' => '<p>Creates a job. A job is a render submission submitted by a user. It contains specific job properties outlined as steps and tasks.</p>', 'CreateLicenseEndpoint' => '<p>Creates a license endpoint to integrate your various licensed software used for rendering on Deadline Cloud.</p>', 'CreateMonitor' => '<p>Creates an Amazon Web Services Deadline Cloud monitor that you can use to view your farms, queues, and fleets. After you submit a job, you can track the progress of the tasks and steps that make up the job, and then download the job\'s results. </p>', 'CreateQueue' => '<p>Creates a queue to coordinate the order in which jobs run on a farm. A queue can also specify where to pull resources and indicate where to output completed jobs.</p>', 'CreateQueueEnvironment' => '<p>Creates an environment for a queue that defines how jobs in the queue run.</p>', 'CreateQueueFleetAssociation' => '<p>Creates an association between a queue and a fleet.</p>', 'CreateStorageProfile' => '<p>Creates a storage profile that specifies the operating system, file type, and file location of resources used on a farm.</p>', 'CreateWorker' => '<p>Creates a worker. A worker tells your instance how much processing power (vCPU), and memory (GiB) you’ll need to assemble the digital assets held within a particular instance. You can specify certain instance types to use, or let the worker know which instances types to exclude.</p>', 'DeleteBudget' => '<p>Deletes a budget.</p>', 'DeleteFarm' => '<p>Deletes a farm.</p>', 'DeleteFleet' => '<p>Deletes a fleet.</p>', 'DeleteLicenseEndpoint' => '<p>Deletes a license endpoint.</p>', 'DeleteMeteredProduct' => '<p>Deletes a metered product.</p>', 'DeleteMonitor' => '<p>Removes a Deadline Cloud monitor. After you delete a monitor, you can create a new one and attach farms to the monitor.</p>', 'DeleteQueue' => '<p>Deletes a queue.</p>', 'DeleteQueueEnvironment' => '<p>Deletes a queue environment.</p>', 'DeleteQueueFleetAssociation' => '<p>Deletes a queue-fleet association.</p>', 'DeleteStorageProfile' => '<p>Deletes a storage profile.</p>', 'DeleteWorker' => '<p>Deletes a worker.</p>', 'DisassociateMemberFromFarm' => '<p>Disassociates a member from a farm.</p>', 'DisassociateMemberFromFleet' => '<p>Disassociates a member from a fleet.</p>', 'DisassociateMemberFromJob' => '<p>Disassociates a member from a job.</p>', 'DisassociateMemberFromQueue' => '<p>Disassociates a member from a queue.</p>', 'GetBudget' => '<p>Get a budget.</p>', 'GetFarm' => '<p>Get a farm.</p>', 'GetFleet' => '<p>Get a fleet.</p>', 'GetJob' => '<p>Gets a Deadline Cloud job.</p>', 'GetLicenseEndpoint' => '<p>Gets a licence endpoint.</p>', 'GetMonitor' => '<p>Gets information about the specified monitor.</p>', 'GetQueue' => '<p>Gets a queue.</p>', 'GetQueueEnvironment' => '<p>Gets a queue environment.</p>', 'GetQueueFleetAssociation' => '<p>Gets a queue-fleet association.</p>', 'GetSession' => '<p>Gets a session.</p>', 'GetSessionAction' => '<p>Gets a session action for the job.</p>', 'GetSessionsStatisticsAggregation' => '<p>Gets a set of statistics for queues or farms. Before you can call the <code>GetSessionStatisticsAggregation</code> operation, you must first call the <code>StartSessionsStatisticsAggregation</code> operation. Statistics are available for 1 hour after you call the <code>StartSessionsStatisticsAggregation</code> operation.</p>', 'GetStep' => '<p>Gets a step.</p>', 'GetStorageProfile' => '<p>Gets a storage profile.</p>', 'GetStorageProfileForQueue' => '<p>Gets a storage profile for a queue.</p>', 'GetTask' => '<p>Gets a task.</p>', 'GetWorker' => '<p>Gets a worker.</p>', 'ListAvailableMeteredProducts' => '<p>A list of the available metered products.</p>', 'ListBudgets' => '<p>A list of budgets in a farm.</p>', 'ListFarmMembers' => '<p>Lists the members of a farm.</p>', 'ListFarms' => '<p>Lists farms.</p>', 'ListFleetMembers' => '<p>Lists fleet members.</p>', 'ListFleets' => '<p>Lists fleets.</p>', 'ListJobMembers' => '<p>Lists members on a job.</p>', 'ListJobs' => '<p>Lists jobs.</p>', 'ListLicenseEndpoints' => '<p>Lists license endpoints.</p>', 'ListMeteredProducts' => '<p>Lists metered products.</p>', 'ListMonitors' => '<p>Gets a list of your monitors in Deadline Cloud.</p>', 'ListQueueEnvironments' => '<p>Lists queue environments.</p>', 'ListQueueFleetAssociations' => '<p>Lists queue-fleet associations.</p>', 'ListQueueMembers' => '<p>Lists the members in a queue.</p>', 'ListQueues' => '<p>Lists queues.</p>', 'ListSessionActions' => '<p>Lists session actions.</p>', 'ListSessions' => '<p>Lists sessions.</p>', 'ListSessionsForWorker' => '<p>Lists sessions for a worker.</p>', 'ListStepConsumers' => '<p>Lists step consumers.</p>', 'ListStepDependencies' => '<p>Lists the dependencies for a step.</p>', 'ListSteps' => '<p>Lists steps for a job.</p>', 'ListStorageProfiles' => '<p>Lists storage profiles.</p>', 'ListStorageProfilesForQueue' => '<p>Lists storage profiles for a queue.</p>', 'ListTagsForResource' => '<p>Lists tags for a resource.</p>', 'ListTasks' => '<p>Lists tasks for a job.</p>', 'ListWorkers' => '<p>Lists workers.</p>', 'PutMeteredProduct' => '<p>Adds a metered product.</p>', 'SearchJobs' => '<p>Searches for jobs.</p>', 'SearchSteps' => '<p>Searches for steps.</p>', 'SearchTasks' => '<p>Searches for tasks.</p>', 'SearchWorkers' => '<p>Searches for workers.</p>', 'StartSessionsStatisticsAggregation' => '<p>Starts an asynchronous request for getting aggregated statistics about queues and farms. Get the statistics using the <code>GetSessionsStatisticsAggregation</code> operation. Statistics are available for 1 hour after you call the <code>StartSessionsStatisticsAggregation</code> operation.</p>', 'TagResource' => '<p>Tags a resource using the resource\'s ARN and desired tags.</p>', 'UntagResource' => '<p>Removes a tag from a resource using the resource\'s ARN and tag to remove.</p>', 'UpdateBudget' => '<p>Updates a budget that sets spending thresholds for rendering activity.</p>', 'UpdateFarm' => '<p>Updates a farm.</p>', 'UpdateFleet' => '<p>Updates a fleet.</p>', 'UpdateJob' => '<p>Updates a job.</p>', 'UpdateMonitor' => '<p>Modifies the settings for a Deadline Cloud monitor. You can modify one or all of the settings when you call <code>UpdateMonitor</code>.</p>', 'UpdateQueue' => '<p>Updates a queue.</p>', 'UpdateQueueEnvironment' => '<p>Updates the queue environment.</p>', 'UpdateQueueFleetAssociation' => '<p>Updates a queue-fleet association.</p>', 'UpdateSession' => '<p>Updates a session.</p>', 'UpdateStep' => '<p>Updates a step.</p>', 'UpdateStorageProfile' => '<p>Updates a storage profile.</p>', 'UpdateTask' => '<p>Updates a task.</p>', 'UpdateWorker' => '<p>Updates a worker.</p>', 'UpdateWorkerSchedule' => '<p>Updates the schedule for a worker.</p>', ], 'shapes' => [ 'AcceleratorCountRange' => [ 'base' => '<p>The range for the GPU fleet acceleration.</p>', 'refs' => [ 'CustomerManagedWorkerCapabilities$acceleratorCount' => '<p>The range of the accelerator.</p>', ], ], 'AcceleratorTotalMemoryMiBRange' => [ 'base' => '<p>The range for memory, in MiB, to use for the accelerator.</p>', 'refs' => [ 'CustomerManagedWorkerCapabilities$acceleratorTotalMemoryMiB' => '<p>The total memory (MiB) for the customer managed worker capabilities.</p>', ], ], 'AcceleratorType' => [ 'base' => NULL, 'refs' => [ 'AcceleratorTypes$member' => NULL, ], ], 'AcceleratorTypes' => [ 'base' => NULL, 'refs' => [ 'CustomerManagedWorkerCapabilities$acceleratorTypes' => '<p>The accelerator types for the customer managed worker capabilities.</p>', ], ], 'AccessDeniedException' => [ 'base' => '<p>You don\'t have permission to perform the action.</p>', 'refs' => [], ], 'AccessKeyId' => [ 'base' => NULL, 'refs' => [ 'AwsCredentials$accessKeyId' => '<p>The IAM access key ID.</p>', ], ], 'AggregationId' => [ 'base' => NULL, 'refs' => [ 'GetSessionsStatisticsAggregationRequest$aggregationId' => '<p>The identifier returned by the <code>StartSessionsStatisticsAggregation</code> operation that identifies the aggregated statistics.</p>', 'StartSessionsStatisticsAggregationResponse$aggregationId' => '<p>A unique identifier for the aggregated statistics. Use this identifier with the <code>GetAggregatedStatisticsForSessions</code> operation to return the statistics.</p>', ], ], 'AllowedStorageProfileIds' => [ 'base' => NULL, 'refs' => [ 'CreateQueueRequest$allowedStorageProfileIds' => '<p>The storage profile IDs to include in the queue.</p>', 'GetQueueResponse$allowedStorageProfileIds' => '<p>The storage profile IDs for the queue.</p>', 'UpdateQueueRequest$allowedStorageProfileIdsToAdd' => '<p>The storage profile IDs to add.</p>', 'UpdateQueueRequest$allowedStorageProfileIdsToRemove' => '<p>The storage profile ID to remove.</p>', ], ], 'AmountCapabilityName' => [ 'base' => NULL, 'refs' => [ 'FleetAmountCapability$name' => '<p>The name of the fleet capability.</p>', 'StepAmountCapability$name' => '<p>The name of the step.</p>', 'WorkerAmountCapability$name' => '<p>The name of the worker amount capability.</p>', ], ], 'AssignedEnvironmentEnterSessionActionDefinition' => [ 'base' => '<p>The assigned starting environment for a worker during session.</p>', 'refs' => [ 'AssignedSessionActionDefinition$envEnter' => '<p>The environment a session starts on.</p>', ], ], 'AssignedEnvironmentExitSessionActionDefinition' => [ 'base' => '<p>The assigned environment when a worker exits a session.</p>', 'refs' => [ 'AssignedSessionActionDefinition$envExit' => '<p>The environment a session exits from.</p>', ], ], 'AssignedSession' => [ 'base' => '<p>The assigned session for the worker.</p>', 'refs' => [ 'AssignedSessions$value' => NULL, ], ], 'AssignedSessionAction' => [ 'base' => '<p>The action for a session defined by the session action ID.</p>', 'refs' => [ 'AssignedSessionActions$member' => NULL, ], ], 'AssignedSessionActionDefinition' => [ 'base' => '<p>The definition of the assigned session action.</p>', 'refs' => [ 'AssignedSessionAction$definition' => '<p>The definition of the assigned session action.</p>', ], ], 'AssignedSessionActions' => [ 'base' => NULL, 'refs' => [ 'AssignedSession$sessionActions' => '<p>The session actions to apply to the assigned session.</p>', ], ], 'AssignedSessions' => [ 'base' => NULL, 'refs' => [ 'UpdateWorkerScheduleResponse$assignedSessions' => '<p>The assigned sessions to update.</p>', ], ], 'AssignedSyncInputJobAttachmentsSessionActionDefinition' => [ 'base' => '<p>The details for an assigned session action as it relates to a job attachment.</p>', 'refs' => [ 'AssignedSessionActionDefinition$syncInputJobAttachments' => '<p>The job attachment to sync with an assigned session action.</p>', ], ], 'AssignedTaskRunSessionActionDefinition' => [ 'base' => '<p>The specific task, step, and parameters to include.</p>', 'refs' => [ 'AssignedSessionActionDefinition$taskRun' => '<p>The task run.</p>', ], ], 'AssociateMemberToFarmRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateMemberToFarmResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociateMemberToFleetRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateMemberToFleetResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociateMemberToJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateMemberToJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociateMemberToQueueRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateMemberToQueueResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssumeFleetRoleForReadRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssumeFleetRoleForReadResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssumeFleetRoleForWorkerRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssumeFleetRoleForWorkerResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssumeQueueRoleForReadRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssumeQueueRoleForReadResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssumeQueueRoleForUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssumeQueueRoleForUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssumeQueueRoleForWorkerRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssumeQueueRoleForWorkerResponse' => [ 'base' => NULL, 'refs' => [], ], 'Attachments' => [ 'base' => '<p>The attachments for jobs.</p>', 'refs' => [ 'CreateJobRequest$attachments' => '<p>The attachments for the job. Attach files required for the job to run to a render job.</p>', 'GetJobResponse$attachments' => '<p>The attachments for the job.</p>', 'JobAttachmentDetailsEntity$attachments' => '<p>The job attachments.</p>', ], ], 'AttributeCapabilityName' => [ 'base' => NULL, 'refs' => [ 'FleetAttributeCapability$name' => '<p>The name of the fleet attribute capability for the worker.</p>', 'StepAttributeCapability$name' => '<p>The name of the step attribute.</p>', 'WorkerAttributeCapability$name' => '<p>The name of the worker attribute capability.</p>', ], ], 'AttributeCapabilityValue' => [ 'base' => NULL, 'refs' => [ 'AttributeCapabilityValuesList$member' => NULL, 'ListAttributeCapabilityValue$member' => NULL, ], ], 'AttributeCapabilityValuesList' => [ 'base' => NULL, 'refs' => [ 'FleetAttributeCapability$values' => '<p>The number of fleet attribute capabilities.</p>', 'WorkerAttributeCapability$values' => '<p>The values of the worker amount capability.</p>', ], ], 'AutoScalingMode' => [ 'base' => NULL, 'refs' => [ 'CustomerManagedFleetConfiguration$mode' => '<p>The Auto Scaling mode for the customer managed fleet configuration.</p>', ], ], 'AutoScalingStatus' => [ 'base' => NULL, 'refs' => [ 'FleetSummary$autoScalingStatus' => '<p>The Auto Scaling status of a fleet.</p>', 'GetFleetResponse$autoScalingStatus' => '<p>The Auto Scaling status of the fleet. Either <code>GROWING</code>, <code>STEADY</code>, or <code>SHRINKING</code>.</p>', ], ], 'AwsCredentials' => [ 'base' => '<p>The Identity and Access Management credentials.</p>', 'refs' => [ 'AssumeFleetRoleForReadResponse$credentials' => '<p>The credentials for the fleet role.</p>', 'AssumeFleetRoleForWorkerResponse$credentials' => '<p>The credentials for the worker.</p>', 'AssumeQueueRoleForReadResponse$credentials' => '<p>The credentials for the queue role.</p>', 'AssumeQueueRoleForUserResponse$credentials' => '<p>The credentials for the queue role that a user has access to.</p>', 'AssumeQueueRoleForWorkerResponse$credentials' => '<p>The Amazon Web Services credentials for the role that the worker is assuming.</p>', ], ], 'BatchGetJobEntityErrors' => [ 'base' => NULL, 'refs' => [ 'BatchGetJobEntityResponse$errors' => '<p>A list of errors from the job error logs for the batch.</p>', ], ], 'BatchGetJobEntityList' => [ 'base' => NULL, 'refs' => [ 'BatchGetJobEntityResponse$entities' => '<p>A list of the job entities, or details, in the batch.</p>', ], ], 'BatchGetJobEntityRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetJobEntityResponse' => [ 'base' => NULL, 'refs' => [], ], 'BoundedString' => [ 'base' => NULL, 'refs' => [ 'MeteredProductSummary$family' => '<p>The family to which the metered product belongs.</p>', 'MeteredProductSummary$vendor' => '<p>The vendor.</p>', ], ], 'BudgetActionToAdd' => [ 'base' => '<p>The budget action to add.</p>', 'refs' => [ 'BudgetActionsToAdd$member' => NULL, ], ], 'BudgetActionToRemove' => [ 'base' => '<p>The budget action to remove.</p>', 'refs' => [ 'BudgetActionsToRemove$member' => NULL, ], ], 'BudgetActionType' => [ 'base' => NULL, 'refs' => [ 'BudgetActionToAdd$type' => '<p>The type of budget action to add.</p>', 'BudgetActionToRemove$type' => '<p>The type of budget action to remove.</p>', 'ResponseBudgetAction$type' => '<p>The action taken on the budget once scheduling stops.</p>', ], ], 'BudgetActionsToAdd' => [ 'base' => NULL, 'refs' => [ 'CreateBudgetRequest$actions' => '<p>The budget actions to specify what happens when the budget runs out.</p>', 'UpdateBudgetRequest$actionsToAdd' => '<p>The budget actions to add. Budget actions specify what happens when the budget runs out.</p>', ], ], 'BudgetActionsToRemove' => [ 'base' => NULL, 'refs' => [ 'UpdateBudgetRequest$actionsToRemove' => '<p>The budget actions to remove from the budget.</p>', ], ], 'BudgetId' => [ 'base' => NULL, 'refs' => [ 'BudgetSummary$budgetId' => '<p>The budget ID.</p>', 'CreateBudgetResponse$budgetId' => '<p>The budget ID.</p>', 'DeleteBudgetRequest$budgetId' => '<p>The budget ID of the budget to delete.</p>', 'GetBudgetRequest$budgetId' => '<p>The budget ID.</p>', 'GetBudgetResponse$budgetId' => '<p>The budget ID.</p>', 'UpdateBudgetRequest$budgetId' => '<p>The budget ID to update.</p>', ], ], 'BudgetSchedule' => [ 'base' => '<p>The start and end time of the budget.</p>', 'refs' => [ 'CreateBudgetRequest$schedule' => '<p>The schedule to associate with this budget.</p>', 'GetBudgetResponse$schedule' => '<p>The budget schedule.</p>', 'UpdateBudgetRequest$schedule' => '<p>The schedule to update.</p>', ], ], 'BudgetStatus' => [ 'base' => NULL, 'refs' => [ 'BudgetSummary$status' => '<p>The status of the budget.</p> <ul> <li> <p> <code>ACTIVE</code>–The budget is being evaluated.</p> </li> <li> <p> <code>INACTIVE</code>–The budget is inactive. This can include Expired, Canceled, or deleted Deleted statuses.</p> </li> </ul>', 'GetBudgetResponse$status' => '<p>The status of the budget.</p> <ul> <li> <p> <code>ACTIVE</code>–Get a budget being evaluated.</p> </li> <li> <p> <code>INACTIVE</code>–Get an inactive budget. This can include expired, canceled, or deleted statuses.</p> </li> </ul>', 'ListBudgetsRequest$status' => '<p>The status to list for the budgets.</p>', 'UpdateBudgetRequest$status' => '<p>Updates the status of the budget.</p> <ul> <li> <p> <code>ACTIVE</code>–The budget is being evaluated.</p> </li> <li> <p> <code>INACTIVE</code>–The budget is inactive. This can include Expired, Canceled, or deleted Deleted statuses.</p> </li> </ul>', ], ], 'BudgetSummaries' => [ 'base' => NULL, 'refs' => [ 'ListBudgetsResponse$budgets' => '<p>The budgets to include on the list.</p>', ], ], 'BudgetSummary' => [ 'base' => '<p>The budget summary.</p>', 'refs' => [ 'BudgetSummaries$member' => NULL, ], ], 'CancelSessionActions' => [ 'base' => NULL, 'refs' => [ 'UpdateWorkerScheduleResponse$cancelSessionActions' => '<p>The session actions associated with the worker schedule to cancel.</p>', ], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'CreateBudgetRequest$clientToken' => '<p>The unique token which the server uses to recognize retries of the same request.</p>', 'CreateFarmRequest$clientToken' => '<p>The unique token which the server uses to recognize retries of the same request.</p>', 'CreateFleetRequest$clientToken' => '<p>The unique token which the server uses to recognize retries of the same request.</p>', 'CreateJobRequest$clientToken' => '<p>The unique token which the server uses to recognize retries of the same request.</p>', 'CreateLicenseEndpointRequest$clientToken' => '<p>The unique token which the server uses to recognize retries of the same request.</p>', 'CreateMonitorRequest$clientToken' => '<p>The unique token which the server uses to recognize retries of the same request.</p>', 'CreateQueueEnvironmentRequest$clientToken' => '<p>The unique token which the server uses to recognize retries of the same request.</p>', 'CreateQueueRequest$clientToken' => '<p>The unique token which the server uses to recognize retries of the same request.</p>', 'CreateStorageProfileRequest$clientToken' => '<p>The unique token which the server uses to recognize retries of the same request.</p>', 'CreateWorkerRequest$clientToken' => '<p>The unique token which the server uses to recognize retries of the same request.</p>', 'DeleteFleetRequest$clientToken' => '<p>The unique token which the server uses to recognize retries of the same request.</p>', 'UpdateBudgetRequest$clientToken' => '<p>The unique token which the server uses to recognize retries of the same request.</p>', 'UpdateFleetRequest$clientToken' => '<p>The unique token which the server uses to recognize retries of the same request.</p>', 'UpdateJobRequest$clientToken' => '<p>The unique token which the server uses to recognize retries of the same request.</p>', 'UpdateQueueEnvironmentRequest$clientToken' => '<p>The unique token which the server uses to recognize retries of the same request.</p>', 'UpdateQueueRequest$clientToken' => '<p>The idempotency token to update in the queue.</p>', 'UpdateSessionRequest$clientToken' => '<p>The unique token which the server uses to recognize retries of the same request.</p>', 'UpdateStepRequest$clientToken' => '<p>The unique token which the server uses to recognize retries of the same request.</p>', 'UpdateStorageProfileRequest$clientToken' => '<p>The unique token which the server uses to recognize retries of the same request.</p>', 'UpdateTaskRequest$clientToken' => '<p>The unique token which the server uses to recognize retries of the same request.</p>', ], ], 'CombinationExpression' => [ 'base' => NULL, 'refs' => [ 'ParameterSpace$combination' => '<p>The combination expression to use in the search.</p>', ], ], 'ComparisonOperator' => [ 'base' => NULL, 'refs' => [ 'DateTimeFilterExpression$operator' => '<p>The type of comparison to use to filter the results.</p>', 'ParameterFilterExpression$operator' => '<p>The type of comparison to use to filter results.</p>', 'StringFilterExpression$operator' => '<p>The type of comparison to use for this search.</p>', ], ], 'CompletedStatus' => [ 'base' => NULL, 'refs' => [ 'UpdatedSessionActionInfo$completedStatus' => '<p>The status of the session upon completion.</p>', ], ], 'ConflictException' => [ 'base' => '<p>Your request has conflicting operations. This can occur if you\'re trying to perform more than one operation on the same resource at the same time.</p>', 'refs' => [], ], 'ConflictExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ConflictException$reason' => '<p>A description of the error.</p>', ], ], 'ConsumedUsageLimit' => [ 'base' => NULL, 'refs' => [ 'BudgetSummary$approximateDollarLimit' => '<p>The approximate dollar limit of the budget.</p>', 'CreateBudgetRequest$approximateDollarLimit' => '<p>The dollar limit based on consumed usage.</p>', 'GetBudgetResponse$approximateDollarLimit' => '<p>The consumed usage limit for the budget.</p>', 'UpdateBudgetRequest$approximateDollarLimit' => '<p>The dollar limit to update on the budget. Based on consumed usage.</p>', ], ], 'ConsumedUsages' => [ 'base' => '<p>The consumed usage for the resource.</p>', 'refs' => [ 'BudgetSummary$usages' => '<p>The consumed usage for the budget.</p>', 'GetBudgetResponse$usages' => '<p>The usages of the budget.</p>', ], ], 'CopyJobTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'CopyJobTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'CpuArchitectureType' => [ 'base' => NULL, 'refs' => [ 'CustomerManagedWorkerCapabilities$cpuArchitectureType' => '<p>The CPU architecture type for the customer managed worker capabilities.</p>', 'ServiceManagedEc2InstanceCapabilities$cpuArchitectureType' => '<p>The CPU architecture type.</p>', ], ], 'CreateBudgetRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateBudgetResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateFarmRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateFarmResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateFleetRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateFleetResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateJobTargetTaskRunStatus' => [ 'base' => NULL, 'refs' => [ 'CreateJobRequest$targetTaskRunStatus' => '<p>The initial status of the job\'s tasks when they are created. Tasks that are created with a <code>SUSPENDED</code> status will not run until you update their status.</p>', ], ], 'CreateLicenseEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateLicenseEndpointRequestSecurityGroupIdsList' => [ 'base' => NULL, 'refs' => [ 'CreateLicenseEndpointRequest$securityGroupIds' => '<p>The security group IDs.</p>', ], ], 'CreateLicenseEndpointRequestSubnetIdsList' => [ 'base' => NULL, 'refs' => [ 'CreateLicenseEndpointRequest$subnetIds' => '<p>The subnet IDs.</p>', ], ], 'CreateLicenseEndpointResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateMonitorRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateMonitorResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateQueueEnvironmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateQueueEnvironmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateQueueFleetAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateQueueFleetAssociationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateQueueRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateQueueResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateStorageProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateStorageProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateWorkerRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateWorkerResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreatedAt' => [ 'base' => NULL, 'refs' => [ 'BudgetSummary$createdAt' => '<p>The date and time the resource was created.</p>', 'FarmSummary$createdAt' => '<p>The date and time the resource was created.</p>', 'FleetSummary$createdAt' => '<p>The date and time the resource was created.</p>', 'GetBudgetResponse$createdAt' => '<p>The date and time the resource was created.</p>', 'GetFarmResponse$createdAt' => '<p>The date and time the resource was created.</p>', 'GetFleetResponse$createdAt' => '<p>The date and time the resource was created.</p>', 'GetJobResponse$createdAt' => '<p>The date and time the resource was created.</p>', 'GetMonitorResponse$createdAt' => '<p>The UNIX timestamp of the date and time that the monitor was created.</p>', 'GetQueueEnvironmentResponse$createdAt' => '<p>The date and time the resource was created.</p>', 'GetQueueFleetAssociationResponse$createdAt' => '<p>The date and time the resource was created.</p>', 'GetQueueResponse$createdAt' => '<p>The date and time the resource was created.</p>', 'GetStepResponse$createdAt' => '<p>The date and time the resource was created.</p>', 'GetStorageProfileResponse$createdAt' => '<p>The date and time the resource was created.</p>', 'GetTaskResponse$createdAt' => '<p>The date and time the resource was created.</p>', 'GetWorkerResponse$createdAt' => '<p>The date and time the resource was created.</p>', 'JobSearchSummary$createdAt' => '<p>The date and time the resource was created.</p>', 'JobSummary$createdAt' => '<p>The date and time the resource was created.</p>', 'MonitorSummary$createdAt' => '<p>The UNIX timestamp of the date and time that the monitor was created.</p>', 'QueueFleetAssociationSummary$createdAt' => '<p>The date and time the resource was created.</p>', 'QueueSummary$createdAt' => '<p>The date and time the resource was created.</p>', 'StepSearchSummary$createdAt' => '<p>The date and time the resource was created.</p>', 'StepSummary$createdAt' => '<p>The date and time the resource was created.</p>', 'TaskSummary$createdAt' => '<p>The date and time the resource was created.</p>', 'WorkerSearchSummary$createdAt' => '<p>The date and time the resource was created.</p>', 'WorkerSummary$createdAt' => '<p>The date and time the resource was created.</p>', ], ], 'CreatedBy' => [ 'base' => NULL, 'refs' => [ 'BudgetSummary$createdBy' => '<p>The user or system that created this resource.</p>', 'FarmSummary$createdBy' => '<p>The user or system that created this resource.</p>', 'FleetSummary$createdBy' => '<p>The user or system that created this resource.</p>', 'GetBudgetResponse$createdBy' => '<p>The user or system that created this resource.</p>', 'GetFarmResponse$createdBy' => '<p>The user or system that created this resource.</p>', 'GetFleetResponse$createdBy' => '<p>The user or system that created this resource.</p>', 'GetJobResponse$createdBy' => '<p>The user or system that created this resource.</p>', 'GetMonitorResponse$createdBy' => '<p>The user name of the person that created the monitor.</p>', 'GetQueueEnvironmentResponse$createdBy' => '<p>The user or system that created this resource.&gt;</p>', 'GetQueueFleetAssociationResponse$createdBy' => '<p>The user or system that created this resource.</p>', 'GetQueueResponse$createdBy' => '<p>The user or system that created this resource.</p>', 'GetStepResponse$createdBy' => '<p>The user or system that created this resource.</p>', 'GetStorageProfileResponse$createdBy' => '<p>The user or system that created this resource.</p>', 'GetTaskResponse$createdBy' => '<p>The user or system that created this resource.</p>', 'GetWorkerResponse$createdBy' => '<p>The user or system that created this resource.</p>', 'JobSearchSummary$createdBy' => '<p>The user or system that created this resource.</p>', 'JobSummary$createdBy' => '<p>The user or system that created this resource.</p>', 'MonitorSummary$createdBy' => '<p>The user name of the person that created the monitor.</p>', 'QueueFleetAssociationSummary$createdBy' => '<p>The user or system that created this resource.</p>', 'QueueSummary$createdBy' => '<p>The user or system that created this resource.</p>', 'StepSummary$createdBy' => '<p>The user or system that created this resource.</p>', 'TaskSummary$createdBy' => '<p>The user or system that created this resource.</p>', 'WorkerSearchSummary$createdBy' => '<p>The user or system that created this resource.</p>', 'WorkerSummary$createdBy' => '<p>The user or system that created this resource.</p>', ], ], 'CustomFleetAmountCapabilities' => [ 'base' => NULL, 'refs' => [ 'CustomerManagedWorkerCapabilities$customAmounts' => '<p>Custom requirement ranges for customer managed worker capabilities.</p>', 'ServiceManagedEc2InstanceCapabilities$customAmounts' => '<p>The custom capability amounts to require for instances in this fleet.</p>', ], ], 'CustomFleetAttributeCapabilities' => [ 'base' => NULL, 'refs' => [ 'CustomerManagedWorkerCapabilities$customAttributes' => '<p>Custom attributes for the customer manged worker capabilities.</p>', 'ServiceManagedEc2InstanceCapabilities$customAttributes' => '<p>The custom capability attributes to require for instances in this fleet.</p>', ], ], 'CustomerManagedFleetConfiguration' => [ 'base' => '<p>The details of a customer managed fleet configuration.</p>', 'refs' => [ 'FleetConfiguration$customerManaged' => '<p>The customer managed fleets within a fleet configuration.</p>', ], ], 'CustomerManagedFleetOperatingSystemFamily' => [ 'base' => NULL, 'refs' => [ 'CustomerManagedWorkerCapabilities$osFamily' => '<p>The operating system (OS) family.</p>', ], ], 'CustomerManagedWorkerCapabilities' => [ 'base' => '<p>The worker capabilities for a customer managed workflow.</p>', 'refs' => [ 'CustomerManagedFleetConfiguration$workerCapabilities' => '<p>The worker capabilities for a customer managed fleet configuration.</p>', ], ], 'DateTimeFilterExpression' => [ 'base' => '<p>The time stamp in date-time format.</p>', 'refs' => [ 'SearchFilterExpression$dateTimeFilter' => '<p>Filters based on date and time.</p>', ], ], 'DefaultQueueBudgetAction' => [ 'base' => NULL, 'refs' => [ 'CreateQueueRequest$defaultBudgetAction' => '<p>The default action to take on a queue if a budget isn\'t configured.</p>', 'GetQueueResponse$defaultBudgetAction' => '<p>The default action taken on a queue if a budget wasn\'t configured.</p>', 'QueueSummary$defaultBudgetAction' => '<p>The default action taken on a queue summary if a budget wasn\'t configured.</p>', 'UpdateQueueRequest$defaultBudgetAction' => '<p>The default action to take for a queue update if a budget isn\'t configured.</p>', ], ], 'DeleteBudgetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBudgetResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFarmRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFarmResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFleetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFleetResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLicenseEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLicenseEndpointResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMeteredProductRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMeteredProductResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMonitorRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMonitorResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteQueueEnvironmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteQueueEnvironmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteQueueFleetAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteQueueFleetAssociationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteQueueRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteQueueResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStorageProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStorageProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWorkerRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWorkerResponse' => [ 'base' => NULL, 'refs' => [], ], 'DependenciesList' => [ 'base' => NULL, 'refs' => [ 'StepDetailsEntity$dependencies' => '<p>The dependencies for a step.</p>', ], ], 'DependencyConsumerResolutionStatus' => [ 'base' => NULL, 'refs' => [ 'StepConsumer$status' => '<p>The step consumer status.</p>', 'StepDependency$status' => '<p>The step dependency status.</p>', ], ], 'DependencyCounts' => [ 'base' => '<p>The number of dependencies for the consumer.</p>', 'refs' => [ 'GetStepResponse$dependencyCounts' => '<p>The number of dependencies in the step.</p>', 'StepSummary$dependencyCounts' => '<p>The number of dependencies for the step.</p>', ], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'BudgetActionToAdd$description' => '<p>A description for the budget action to add.</p>', 'BudgetSummary$description' => '<p>The description of the budget summary.</p>', 'CreateBudgetRequest$description' => '<p>The description of the budget.</p>', 'CreateFarmRequest$description' => '<p>The description of the farm.</p>', 'CreateFleetRequest$description' => '<p>The description of the fleet.</p>', 'CreateQueueRequest$description' => '<p>The description of the queue.</p>', 'GetBudgetResponse$description' => '<p>The description of the budget.</p>', 'GetFarmResponse$description' => '<p>The description of the farm.</p>', 'GetFleetResponse$description' => '<p>The description of the fleet.</p>', 'GetQueueResponse$description' => '<p>The description of the queue.</p>', 'ResponseBudgetAction$description' => '<p>The budget action description.</p>', 'UpdateBudgetRequest$description' => '<p>The description of the budget to update.</p>', 'UpdateFarmRequest$description' => '<p>The description of the farm to update.</p>', 'UpdateFleetRequest$description' => '<p>The description of the fleet to update.</p>', 'UpdateQueueRequest$description' => '<p>The description of the queue to update.</p>', ], ], 'DesiredWorkerStatus' => [ 'base' => NULL, 'refs' => [ 'UpdateWorkerScheduleResponse$desiredWorkerStatus' => '<p>The status to update the worker to.</p>', ], ], 'DisassociateMemberFromFarmRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateMemberFromFarmResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateMemberFromFleetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateMemberFromFleetResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateMemberFromJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateMemberFromJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateMemberFromQueueRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateMemberFromQueueResponse' => [ 'base' => NULL, 'refs' => [], ], 'DnsName' => [ 'base' => NULL, 'refs' => [ 'GetLicenseEndpointResponse$dnsName' => '<p>The DNS name.</p>', ], ], 'Document' => [ 'base' => NULL, 'refs' => [ 'EnvironmentDetailsEntity$template' => '<p>The template used for the environment.</p>', 'StepDetailsEntity$template' => '<p>The template for a step.</p>', ], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'Stats$avg' => '<p>The average of the usage statistics.</p>', 'Stats$max' => '<p>The maximum among the usage statistics.</p>', 'Stats$min' => '<p>The minimum of the usage statistics.</p>', 'Stats$sum' => '<p>The sum of the usage statistics.</p>', 'StepAmountCapability$max' => '<p>The maximum amount.</p>', 'StepAmountCapability$min' => '<p>The minimum amount.</p>', 'StepAmountCapability$value' => '<p>The amount value.</p>', ], ], 'EbsIops' => [ 'base' => NULL, 'refs' => [ 'Ec2EbsVolume$iops' => '<p>The IOPS per volume.</p>', ], ], 'EbsThroughputMiB' => [ 'base' => NULL, 'refs' => [ 'Ec2EbsVolume$throughputMiB' => '<p>The throughput per volume in MiB.</p>', ], ], 'Ec2EbsVolume' => [ 'base' => '<p>Specifies the EBS volume.</p>', 'refs' => [ 'ServiceManagedEc2InstanceCapabilities$rootEbsVolume' => '<p>The root EBS volume.</p>', ], ], 'Ec2MarketType' => [ 'base' => NULL, 'refs' => [ 'ServiceManagedEc2InstanceMarketOptions$type' => '<p>The Amazon EC2 instance type.</p>', ], ], 'EndedAt' => [ 'base' => NULL, 'refs' => [ 'GetJobResponse$endedAt' => '<p>The date and time the resource ended running.</p>', 'GetSessionActionResponse$endedAt' => '<p>The date and time the resource ended running.</p>', 'GetSessionResponse$endedAt' => '<p>The date and time the resource ended running.</p>', 'GetStepResponse$endedAt' => '<p>The date and time the resource ended running.</p>', 'GetTaskResponse$endedAt' => '<p>The date and time the resource ended running.</p>', 'JobSearchSummary$endedAt' => '<p>The date and time the resource ended running.</p>', 'JobSummary$endedAt' => '<p>The date and time the resource ended running.</p>', 'SessionActionSummary$endedAt' => '<p>The date and time the resource ended running.</p>', 'SessionSummary$endedAt' => '<p>The date and time the resource ended running.</p>', 'StepSearchSummary$endedAt' => '<p>The date and time the resource ended running.</p>', 'StepSummary$endedAt' => '<p>The date and time the resource ended running.</p>', 'TaskSearchSummary$endedAt' => '<p>The date and time the resource ended running.</p>', 'TaskSummary$endedAt' => '<p>The date and time the resource ended running.</p>', 'WorkerSessionSummary$endedAt' => '<p>The date and time the resource ended running.</p>', ], ], 'EndsAt' => [ 'base' => NULL, 'refs' => [ 'FixedBudgetSchedule$endTime' => '<p>When the budget ends.</p>', ], ], 'EnvironmentDetailsEntity' => [ 'base' => '<p>The details of a specified environment.</p>', 'refs' => [ 'JobEntity$environmentDetails' => '<p>The environment details for the job entity.</p>', ], ], 'EnvironmentDetailsError' => [ 'base' => '<p>The error details for the environment.</p>', 'refs' => [ 'GetJobEntityError$environmentDetails' => '<p>The environment details for the failed job entity.</p>', ], ], 'EnvironmentDetailsIdentifiers' => [ 'base' => '<p>The IDs of the job and environment.</p>', 'refs' => [ 'JobEntityIdentifiersUnion$environmentDetails' => '<p>The environment details.</p>', ], ], 'EnvironmentEnterSessionActionDefinition' => [ 'base' => '<p>The environment ID to use to enter a session action.</p>', 'refs' => [ 'SessionActionDefinition$envEnter' => '<p>The environment to enter into.</p>', ], ], 'EnvironmentEnterSessionActionDefinitionSummary' => [ 'base' => '<p>Defines the environment a session action enters in.</p>', 'refs' => [ 'SessionActionDefinitionSummary$envEnter' => '<p>The environment to enter into.</p>', ], ], 'EnvironmentExitSessionActionDefinition' => [ 'base' => '<p>Defines the environment a session action exits from.</p>', 'refs' => [ 'SessionActionDefinition$envExit' => '<p>The environment to exit from.</p>', ], ], 'EnvironmentExitSessionActionDefinitionSummary' => [ 'base' => '<p>A summary of the environment details for which a session action to exits.</p>', 'refs' => [ 'SessionActionDefinitionSummary$envExit' => '<p>The environment to exit from.</p>', ], ], 'EnvironmentId' => [ 'base' => NULL, 'refs' => [ 'AssignedEnvironmentEnterSessionActionDefinition$environmentId' => '<p>The environment ID of the assigned environment at the start of a session.</p>', 'AssignedEnvironmentExitSessionActionDefinition$environmentId' => '<p>The environment ID of the assigned environment when exiting a session.</p>', 'EnvironmentDetailsEntity$environmentId' => '<p>The environment ID.</p>', 'EnvironmentDetailsError$environmentId' => '<p>The environment ID.</p>', 'EnvironmentDetailsIdentifiers$environmentId' => '<p>The environment ID.</p>', 'EnvironmentEnterSessionActionDefinition$environmentId' => '<p>The environment ID.</p>', 'EnvironmentEnterSessionActionDefinitionSummary$environmentId' => '<p>The environment ID.</p>', 'EnvironmentExitSessionActionDefinition$environmentId' => '<p>The environment ID.</p>', 'EnvironmentExitSessionActionDefinitionSummary$environmentId' => '<p>The environment ID.</p>', ], ], 'EnvironmentName' => [ 'base' => NULL, 'refs' => [ 'GetQueueEnvironmentResponse$name' => '<p>The name of the queue environment.</p>', 'QueueEnvironmentSummary$name' => '<p>The name of the queue environment.</p>', ], ], 'EnvironmentTemplate' => [ 'base' => NULL, 'refs' => [ 'CreateQueueEnvironmentRequest$template' => '<p>The environment template to use in the queue.</p>', 'GetQueueEnvironmentResponse$template' => '<p>The template for the queue environment.</p>', 'UpdateQueueEnvironmentRequest$template' => '<p>The template to update.</p>', ], ], 'EnvironmentTemplateType' => [ 'base' => NULL, 'refs' => [ 'CreateQueueEnvironmentRequest$templateType' => '<p>The template\'s file type, <code>JSON</code> or <code>YAML</code>.</p>', 'GetQueueEnvironmentResponse$templateType' => '<p>The type of template for the queue environment.</p>', 'UpdateQueueEnvironmentRequest$templateType' => '<p>The template type to update.</p>', ], ], 'ExceptionContext' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$context' => '<p>Information about the resources in use when the exception was thrown.</p>', 'ConflictException$context' => '<p>Information about the resources in use when the exception was thrown.</p>', 'ResourceNotFoundException$context' => '<p>Information about the resources in use when the exception was thrown.</p>', 'ServiceQuotaExceededException$context' => '<p>Information about the resources in use when the exception was thrown.</p>', 'ThrottlingException$context' => '<p>Information about the resources in use when the exception was thrown.</p>', 'ValidationException$context' => '<p>Information about the resources in use when the exception was thrown.</p>', ], ], 'FarmId' => [ 'base' => NULL, 'refs' => [ 'AssociateMemberToFarmRequest$farmId' => '<p>The ID of the farm to associate with the member.</p>', 'AssociateMemberToFleetRequest$farmId' => '<p>The farm ID of the fleet to associate with the member.</p>', 'AssociateMemberToJobRequest$farmId' => '<p>The farm ID of the job to associate with the member.</p>', 'AssociateMemberToQueueRequest$farmId' => '<p>The farm ID of the queue to associate with the member.</p>', 'AssumeFleetRoleForReadRequest$farmId' => '<p>The farm ID for the fleet\'s farm.</p>', 'AssumeFleetRoleForWorkerRequest$farmId' => '<p>The farm ID for the fleet\'s farm.</p>', 'AssumeQueueRoleForReadRequest$farmId' => '<p>The farm ID of the farm containing the queue.</p>', 'AssumeQueueRoleForUserRequest$farmId' => '<p>The farm ID of the queue that the user assumes the role for.</p>', 'AssumeQueueRoleForWorkerRequest$farmId' => '<p>The farm ID of the worker assuming the queue role.</p>', 'BatchGetJobEntityRequest$farmId' => '<p>The farm ID of the worker that\'s fetching job details. The worker must have an assignment on a job to fetch job details.</p>', 'CopyJobTemplateRequest$farmId' => '<p>The farm ID to copy.</p>', 'CreateBudgetRequest$farmId' => '<p>The farm ID to include in this budget.</p>', 'CreateFarmResponse$farmId' => '<p>The farm ID.</p>', 'CreateFleetRequest$farmId' => '<p>The farm ID of the farm to connect to the fleet.</p>', 'CreateJobRequest$farmId' => '<p>The farm ID of the farm to connect to the job.</p>', 'CreateQueueEnvironmentRequest$farmId' => '<p>The farm ID of the farm to connect to the environment.</p>', 'CreateQueueFleetAssociationRequest$farmId' => '<p>The ID of the farm that the queue and fleet belong to.</p>', 'CreateQueueRequest$farmId' => '<p>The farm ID of the farm to connect to the queue.</p>', 'CreateStorageProfileRequest$farmId' => '<p>The farm ID of the farm to connect to the storage profile.</p>', 'CreateWorkerRequest$farmId' => '<p>The farm ID of the farm to connect to the worker.</p>', 'DeleteBudgetRequest$farmId' => '<p>The farm ID of the farm to remove from the budget.</p>', 'DeleteFarmRequest$farmId' => '<p>The farm ID of the farm to delete.</p>', 'DeleteFleetRequest$farmId' => '<p>The farm ID of the farm to remove from the fleet.</p>', 'DeleteQueueEnvironmentRequest$farmId' => '<p>The farm ID of the farm from which to remove the queue environment.</p>', 'DeleteQueueFleetAssociationRequest$farmId' => '<p>The farm ID of the farm that holds the queue-fleet association.</p>', 'DeleteQueueRequest$farmId' => '<p>The ID of the farm from which to remove the queue.</p>', 'DeleteStorageProfileRequest$farmId' => '<p>The farm ID of the farm from which to remove the storage profile.</p>', 'DeleteWorkerRequest$farmId' => '<p>The farm ID of the worker to delete.</p>', 'DisassociateMemberFromFarmRequest$farmId' => '<p>The farm ID of the farm to disassociate from the member.</p>', 'DisassociateMemberFromFleetRequest$farmId' => '<p>The farm ID of the fleet to disassociate a member from.</p>', 'DisassociateMemberFromJobRequest$farmId' => '<p>The farm ID for the job to disassociate from the member.</p>', 'DisassociateMemberFromQueueRequest$farmId' => '<p>The farm ID for the queue to disassociate from a member.</p>', 'FarmMember$farmId' => '<p>The farm ID of the farm member.</p>', 'FarmSummary$farmId' => '<p>The farm ID.</p>', 'FleetMember$farmId' => '<p>The farm ID.</p>', 'FleetSummary$farmId' => '<p>The farm ID.</p>', 'GetBudgetRequest$farmId' => '<p>The farm ID of the farm connected to the budget.</p>', 'GetFarmRequest$farmId' => '<p>The farm ID of the farm.</p>', 'GetFarmResponse$farmId' => '<p>The farm ID of the farm to get.</p>', 'GetFleetRequest$farmId' => '<p>The farm ID of the farm in the fleet.</p>', 'GetFleetResponse$farmId' => '<p>The farm ID of the farm in the fleet.</p>', 'GetJobRequest$farmId' => '<p>The farm ID of the farm in the job.</p>', 'GetQueueEnvironmentRequest$farmId' => '<p>The farm ID for the queue environment.</p>', 'GetQueueFleetAssociationRequest$farmId' => '<p>The farm ID of the farm that contains the queue-fleet association.</p>', 'GetQueueRequest$farmId' => '<p>The farm ID of the farm in the queue.</p>', 'GetQueueResponse$farmId' => '<p>The farm ID for the queue.</p>', 'GetSessionActionRequest$farmId' => '<p>The farm ID for the session action.</p>', 'GetSessionRequest$farmId' => '<p>The farm ID for the session.</p>', 'GetSessionsStatisticsAggregationRequest$farmId' => '<p>The identifier of the farm to include in the statistics. This should be the same as the farm ID used in the call to the <code>StartSessionsStatisticsAggregation</code> operation.</p>', 'GetStepRequest$farmId' => '<p>The farm ID for the step.</p>', 'GetStorageProfileForQueueRequest$farmId' => '<p>The farm ID for the queue in storage profile.</p>', 'GetStorageProfileRequest$farmId' => '<p>The farm ID for the storage profile.</p>', 'GetTaskRequest$farmId' => '<p>The farm ID of the farm connected to the task.</p>', 'GetWorkerRequest$farmId' => '<p>The farm ID for the worker.</p>', 'GetWorkerResponse$farmId' => '<p>The farm ID.</p>', 'JobMember$farmId' => '<p>The farm ID.</p>', 'ListBudgetsRequest$farmId' => '<p>The farm ID associated with the budgets.</p>', 'ListFarmMembersRequest$farmId' => '<p>The farm ID.</p>', 'ListFleetMembersRequest$farmId' => '<p>The farm ID of the fleet.</p>', 'ListFleetsRequest$farmId' => '<p>The farm ID of the fleets.</p>', 'ListJobMembersRequest$farmId' => '<p>The farm ID of the job to list.</p>', 'ListJobsRequest$farmId' => '<p>The farm ID for the jobs.</p>', 'ListQueueEnvironmentsRequest$farmId' => '<p>The farm ID for the queue environment list.</p>', 'ListQueueFleetAssociationsRequest$farmId' => '<p>The farm ID for the queue-fleet association list.</p>', 'ListQueueMembersRequest$farmId' => '<p>The farm ID for the queue.</p>', 'ListQueuesRequest$farmId' => '<p>The farm ID of the queue.</p>', 'ListSessionActionsRequest$farmId' => '<p>The farm ID for the session actions list.</p>', 'ListSessionsForWorkerRequest$farmId' => '<p>The farm ID for the session.</p>', 'ListSessionsRequest$farmId' => '<p>The farm ID for the list of sessions.</p>', 'ListStepConsumersRequest$farmId' => '<p>The farm ID for the list of step consumers.</p>', 'ListStepDependenciesRequest$farmId' => '<p>The farm ID for the step dependencies list.</p>', 'ListStepsRequest$farmId' => '<p>The farm ID to include on the list of steps.</p>', 'ListStorageProfilesForQueueRequest$farmId' => '<p>The farm ID of the queue\'s storage profile.</p>', 'ListStorageProfilesRequest$farmId' => '<p>The farm ID of the storage profile.</p>', 'ListTasksRequest$farmId' => '<p>The farm ID connected to the tasks.</p>', 'ListWorkersRequest$farmId' => '<p>The farm ID connected to the workers.</p>', 'QueueMember$farmId' => '<p>The farm ID.</p>', 'QueueSummary$farmId' => '<p>The farm ID.</p>', 'SearchJobsRequest$farmId' => '<p>The farm ID of the job.</p>', 'SearchStepsRequest$farmId' => '<p>The farm ID to use for the step search.</p>', 'SearchTasksRequest$farmId' => '<p>The farm ID of the task.</p>', 'SearchWorkersRequest$farmId' => '<p>The farm ID in the workers search.</p>', 'StartSessionsStatisticsAggregationRequest$farmId' => '<p>The identifier of the farm that contains queues or fleets to return statistics for.</p>', 'UpdateBudgetRequest$farmId' => '<p>The farm ID of the budget to update.</p>', 'UpdateFarmRequest$farmId' => '<p>The farm ID to update.</p>', 'UpdateFleetRequest$farmId' => '<p>The farm ID to update.</p>', 'UpdateJobRequest$farmId' => '<p>The farm ID of the job to update.</p>', 'UpdateQueueEnvironmentRequest$farmId' => '<p>The farm ID of the queue environment to update.</p>', 'UpdateQueueFleetAssociationRequest$farmId' => '<p>The farm ID to update.</p>', 'UpdateQueueRequest$farmId' => '<p>The farm ID to update in the queue.</p>', 'UpdateSessionRequest$farmId' => '<p>The farm ID to update in the session.</p>', 'UpdateStepRequest$farmId' => '<p>The farm ID to update.</p>', 'UpdateStorageProfileRequest$farmId' => '<p>The farm ID to update.</p>', 'UpdateTaskRequest$farmId' => '<p>The farm ID to update.</p>', 'UpdateWorkerRequest$farmId' => '<p>The farm ID to update.</p>', 'UpdateWorkerScheduleRequest$farmId' => '<p>The farm ID to update.</p>', 'WorkerSummary$farmId' => '<p>The farm ID.</p>', ], ], 'FarmMember' => [ 'base' => '<p>The member of a farm.</p>', 'refs' => [ 'FarmMembers$member' => NULL, ], ], 'FarmMembers' => [ 'base' => NULL, 'refs' => [ 'ListFarmMembersResponse$members' => '<p>The members on the list.</p>', ], ], 'FarmSummaries' => [ 'base' => NULL, 'refs' => [ 'ListFarmsResponse$farms' => '<p>Farms on the list.</p>', ], ], 'FarmSummary' => [ 'base' => '<p>The summary of details for a farm.</p>', 'refs' => [ 'FarmSummaries$member' => NULL, ], ], 'FieldSortExpression' => [ 'base' => '<p>The field sorting order and name of the field.</p>', 'refs' => [ 'SearchSortExpression$fieldSort' => '<p>Options for sorting by a field.</p>', ], ], 'FileSystemLocation' => [ 'base' => '<p>The details of the file system location for the resource.</p>', 'refs' => [ 'FileSystemLocationsList$member' => NULL, ], ], 'FileSystemLocationName' => [ 'base' => NULL, 'refs' => [ 'FileSystemLocation$name' => '<p>The location name.</p>', 'ManifestProperties$fileSystemLocationName' => '<p>The file system location name.</p>', 'RequiredFileSystemLocationNames$member' => NULL, ], ], 'FileSystemLocationType' => [ 'base' => NULL, 'refs' => [ 'FileSystemLocation$type' => '<p>The type of file.</p>', ], ], 'FileSystemLocationsList' => [ 'base' => NULL, 'refs' => [ 'CreateStorageProfileRequest$fileSystemLocations' => '<p>File system paths to include in the storage profile.</p>', 'GetStorageProfileForQueueResponse$fileSystemLocations' => '<p>The location of the files for the storage profile within the queue.</p>', 'GetStorageProfileResponse$fileSystemLocations' => '<p>The location of the files for the storage profile.</p>', 'UpdateStorageProfileRequest$fileSystemLocationsToAdd' => '<p>The file system location names to add.</p>', 'UpdateStorageProfileRequest$fileSystemLocationsToRemove' => '<p>The file system location names to remove.</p>', ], ], 'FixedBudgetSchedule' => [ 'base' => '<p>The details of a fixed budget schedule.</p>', 'refs' => [ 'BudgetSchedule$fixed' => '<p>The fixed start and end time of the budget\'s schedule.</p>', ], ], 'FleetAmountCapabilities' => [ 'base' => NULL, 'refs' => [ 'FleetCapabilities$amounts' => '<p>Amount capabilities of the fleet.</p>', ], ], 'FleetAmountCapability' => [ 'base' => '<p>The fleet amount and attribute capabilities.</p>', 'refs' => [ 'CustomFleetAmountCapabilities$member' => NULL, 'FleetAmountCapabilities$member' => NULL, ], ], 'FleetAttributeCapabilities' => [ 'base' => NULL, 'refs' => [ 'FleetCapabilities$attributes' => '<p>Attribute capabilities of the fleet.</p>', ], ], 'FleetAttributeCapability' => [ 'base' => '<p>Defines the fleet\'s capability name, minimum, and maximum.</p>', 'refs' => [ 'CustomFleetAttributeCapabilities$member' => NULL, 'FleetAttributeCapabilities$member' => NULL, ], ], 'FleetCapabilities' => [ 'base' => '<p>The amounts and attributes of fleets.</p>', 'refs' => [ 'GetFleetResponse$capabilities' => '<p>Outlines what the fleet is capable of for minimums, maximums, and naming, in addition to attribute names and values.</p>', ], ], 'FleetConfiguration' => [ 'base' => '<p>Fleet configuration details.</p>', 'refs' => [ 'CreateFleetRequest$configuration' => '<p>The configuration settings for the fleet. Customer managed fleets are self-managed. Service managed Amazon EC2 fleets are managed by Deadline Cloud.</p>', 'FleetSummary$configuration' => '<p>The configuration details for the fleet.</p>', 'GetFleetResponse$configuration' => '<p>The configuration setting for the fleet.</p>', 'UpdateFleetRequest$configuration' => '<p>The fleet configuration to update.</p>', ], ], 'FleetId' => [ 'base' => NULL, 'refs' => [ 'AssociateMemberToFleetRequest$fleetId' => '<p>The ID of the fleet to associate with a member.</p>', 'AssumeFleetRoleForReadRequest$fleetId' => '<p>The fleet ID.</p>', 'AssumeFleetRoleForWorkerRequest$fleetId' => '<p>The fleet ID that contains the worker.</p>', 'AssumeQueueRoleForWorkerRequest$fleetId' => '<p>The fleet ID of the worker assuming the queue role.</p>', 'BatchGetJobEntityRequest$fleetId' => '<p>The fleet ID of the worker that\'s fetching job details. The worker must have an assignment on a job to fetch job details.</p>', 'CreateFleetResponse$fleetId' => '<p>The fleet ID.</p>', 'CreateQueueFleetAssociationRequest$fleetId' => '<p>The fleet ID.</p>', 'CreateWorkerRequest$fleetId' => '<p>The fleet ID to connect to the worker.</p>', 'DeleteFleetRequest$fleetId' => '<p>The fleet ID of the fleet to delete.</p>', 'DeleteQueueFleetAssociationRequest$fleetId' => '<p>The fleet ID of the queue-fleet association.</p>', 'DeleteWorkerRequest$fleetId' => '<p>The fleet ID of the worker to delete.</p>', 'DisassociateMemberFromFleetRequest$fleetId' => '<p>The fleet ID of the fleet to from which to disassociate a member.</p>', 'FleetMember$fleetId' => '<p>The fleet ID.</p>', 'FleetSummary$fleetId' => '<p>The fleet ID.</p>', 'GetFleetRequest$fleetId' => '<p>The fleet ID of the fleet to get.</p>', 'GetFleetResponse$fleetId' => '<p>The fleet ID.</p>', 'GetQueueFleetAssociationRequest$fleetId' => '<p>The fleet ID for the queue-fleet association.</p>', 'GetQueueFleetAssociationResponse$fleetId' => '<p>The fleet ID for the queue-fleet association.</p>', 'GetSessionResponse$fleetId' => '<p>The fleet ID for the session.</p>', 'GetWorkerRequest$fleetId' => '<p>The fleet ID of the worker.</p>', 'GetWorkerResponse$fleetId' => '<p>The fleet ID.</p>', 'ListFleetMembersRequest$fleetId' => '<p>The fleet ID to include on the list.</p>', 'ListQueueFleetAssociationsRequest$fleetId' => '<p>The fleet ID for the queue-fleet association list.</p>', 'ListSessionsForWorkerRequest$fleetId' => '<p>The fleet ID for the session.</p>', 'ListWorkersRequest$fleetId' => '<p>The fleet ID of the workers.</p>', 'QueueFleetAssociationSummary$fleetId' => '<p>The fleet ID.</p>', 'SearchWorkersRequestFleetIdsList$member' => NULL, 'SessionSummary$fleetId' => '<p>The fleet ID.</p>', 'SessionsStatisticsResourcesFleetIdsList$member' => NULL, 'Statistics$fleetId' => '<p>The fleet ID.</p>', 'UpdateFleetRequest$fleetId' => '<p>The fleet ID to update.</p>', 'UpdateQueueFleetAssociationRequest$fleetId' => '<p>The fleet ID to update.</p>', 'UpdateWorkerRequest$fleetId' => '<p>The fleet ID to update.</p>', 'UpdateWorkerScheduleRequest$fleetId' => '<p>The fleet ID to update.</p>', 'WorkerSearchSummary$fleetId' => '<p>The fleet ID.</p>', 'WorkerSummary$fleetId' => '<p>The fleet ID.</p>', ], ], 'FleetMember' => [ 'base' => '<p>The fleet member.</p>', 'refs' => [ 'FleetMembers$member' => NULL, ], ], 'FleetMembers' => [ 'base' => NULL, 'refs' => [ 'ListFleetMembersResponse$members' => '<p>The members on the list.</p>', ], ], 'FleetStatus' => [ 'base' => NULL, 'refs' => [ 'FleetSummary$status' => '<p>The status of the fleet.</p>', 'GetFleetResponse$status' => '<p>The Auto Scaling status of the fleet.</p>', 'ListFleetsRequest$status' => '<p>The status of the fleet.</p>', ], ], 'FleetSummaries' => [ 'base' => NULL, 'refs' => [ 'ListFleetsResponse$fleets' => '<p>The fleets on the list.</p>', ], ], 'FleetSummary' => [ 'base' => '<p>The details of a fleet.</p>', 'refs' => [ 'FleetSummaries$member' => NULL, ], ], 'Float' => [ 'base' => NULL, 'refs' => [ 'ConsumedUsages$approximateDollarUsage' => '<p>The amount of the budget consumed.</p>', 'FleetAmountCapability$max' => '<p>The maximum amount of the fleet worker capability.</p>', 'FleetAmountCapability$min' => '<p>The minimum amount of fleet worker capability.</p>', 'WorkerAmountCapability$value' => '<p>The value of the worker amount capability.</p>', ], ], 'FloatString' => [ 'base' => NULL, 'refs' => [ 'JobParameter$float' => '<p>A double precision IEEE-754 floating point number represented as a string.</p>', 'TaskParameterValue$float' => '<p>A double precision IEEE-754 floating point number represented as a string.</p>', ], ], 'GetBudgetRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetBudgetResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetFarmRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetFarmResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetFleetRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetFleetResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetJobEntityError' => [ 'base' => '<p>The error for the job entity.</p>', 'refs' => [ 'BatchGetJobEntityErrors$member' => NULL, ], ], 'GetJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetLicenseEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetLicenseEndpointResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetLicenseEndpointResponseSecurityGroupIdsList' => [ 'base' => NULL, 'refs' => [ 'GetLicenseEndpointResponse$securityGroupIds' => '<p>The security group IDs for the license endpoint.</p>', ], ], 'GetLicenseEndpointResponseSubnetIdsList' => [ 'base' => NULL, 'refs' => [ 'GetLicenseEndpointResponse$subnetIds' => '<p>The subnet IDs.</p>', ], ], 'GetMonitorRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMonitorResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetQueueEnvironmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetQueueEnvironmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetQueueFleetAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetQueueFleetAssociationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetQueueRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetQueueResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetSessionActionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSessionActionResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetSessionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSessionResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetSessionsStatisticsAggregationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSessionsStatisticsAggregationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetStepRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetStepResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetStorageProfileForQueueRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetStorageProfileForQueueResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetStorageProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetStorageProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTaskResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetWorkerRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetWorkerResponse' => [ 'base' => NULL, 'refs' => [], ], 'HostName' => [ 'base' => NULL, 'refs' => [ 'HostPropertiesRequest$hostName' => '<p>The host name.</p>', 'HostPropertiesResponse$hostName' => '<p>The host name.</p>', ], ], 'HostPropertiesRequest' => [ 'base' => '<p>The host property details.</p>', 'refs' => [ 'CreateWorkerRequest$hostProperties' => '<p>The IP address and host name of the worker.</p>', 'UpdateWorkerRequest$hostProperties' => '<p>The host properties to update.</p>', ], ], 'HostPropertiesResponse' => [ 'base' => '<p>The host property details.</p>', 'refs' => [ 'GetSessionResponse$hostProperties' => '<p>Provides the Amazon EC2 properties of the host.</p>', 'GetWorkerResponse$hostProperties' => '<p>The host properties for the worker.</p>', 'WorkerSearchSummary$hostProperties' => '<p>Provides the Amazon EC2 instance properties of the worker host.</p>', 'WorkerSummary$hostProperties' => '<p>The host properties of the worker.</p>', ], ], 'IamRoleArn' => [ 'base' => NULL, 'refs' => [ 'CreateFleetRequest$roleArn' => '<p>The IAM role ARN for the role that the fleet\'s workers will use.</p>', 'CreateMonitorRequest$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that the monitor uses to connect to Deadline Cloud. Every user that signs in to the monitor using IAM Identity Center uses this role to access Deadline Cloud resources.</p>', 'CreateQueueRequest$roleArn' => '<p>The IAM role ARN that workers will use while running jobs for this queue.</p>', 'GetFleetResponse$roleArn' => '<p>The IAM role ARN.</p>', 'GetMonitorResponse$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role for the monitor. Users of the monitor use this role to access Deadline Cloud resources.</p>', 'GetQueueResponse$roleArn' => '<p>The IAM role ARN.</p>', 'JobDetailsEntity$queueRoleArn' => '<p>The queue role ARN.</p>', 'MonitorSummary$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role for the monitor. Users of the monitor use this role to access Deadline Cloud resources.</p>', 'UpdateFleetRequest$roleArn' => '<p>The IAM role ARN that the fleet\'s workers assume while running jobs.</p>', 'UpdateMonitorRequest$roleArn' => '<p>The Amazon Resource Name (ARN) of the new IAM role to use with the monitor.</p>', 'UpdateQueueRequest$roleArn' => '<p>The IAM role ARN that\'s used to run jobs from this queue.</p>', ], ], 'IdentityCenterApplicationArn' => [ 'base' => NULL, 'refs' => [ 'CreateMonitorResponse$identityCenterApplicationArn' => '<p>The Amazon Resource Name (ARN) that IAM Identity Center assigns to the monitor.</p>', 'GetMonitorResponse$identityCenterApplicationArn' => '<p>The Amazon Resource Name (ARN) that the IAM Identity Center assigned to the monitor when it was created.</p>', 'MonitorSummary$identityCenterApplicationArn' => '<p>The Amazon Resource Name (ARN) that the IAM Identity Center assigned to the monitor when it was created.</p>', ], ], 'IdentityCenterInstanceArn' => [ 'base' => NULL, 'refs' => [ 'CreateMonitorRequest$identityCenterInstanceArn' => '<p>The Amazon Resource Name (ARN) of the IAM Identity Center instance that authenticates monitor users.</p>', 'GetMonitorResponse$identityCenterInstanceArn' => '<p>The Amazon Resource Name (ARN) of the IAM Identity Center instance responsible for authenticating monitor users.</p>', 'MonitorSummary$identityCenterInstanceArn' => '<p>The Amazon Resource Name (ARN) of the IAM Identity Center instance responsible for authenticating monitor users.</p>', ], ], 'IdentityCenterPrincipalId' => [ 'base' => NULL, 'refs' => [ 'AssociateMemberToFarmRequest$principalId' => '<p>The member\'s principal ID to associate with the farm.</p>', 'AssociateMemberToFleetRequest$principalId' => '<p>The member\'s principal ID to associate with a fleet.</p>', 'AssociateMemberToJobRequest$principalId' => '<p>The member\'s principal ID to associate with the job.</p>', 'AssociateMemberToQueueRequest$principalId' => '<p>The member\'s principal ID to associate with the queue.</p>', 'DisassociateMemberFromFarmRequest$principalId' => '<p>A member\'s principal ID to disassociate from a farm.</p>', 'DisassociateMemberFromFleetRequest$principalId' => '<p>A member\'s principal ID to disassociate from a fleet.</p>', 'DisassociateMemberFromJobRequest$principalId' => '<p>A member\'s principal ID to disassociate from a job.</p>', 'DisassociateMemberFromQueueRequest$principalId' => '<p>A member\'s principal ID to disassociate from a queue.</p>', 'FarmMember$principalId' => '<p>The principal ID of the farm member.</p>', 'FleetMember$principalId' => '<p>The principal ID of the fleet member.</p>', 'JobMember$principalId' => '<p>The principal ID of the job member.</p>', 'ListFarmsRequest$principalId' => '<p>The principal ID of the member to list on the farm.</p>', 'ListFleetsRequest$principalId' => '<p>The principal ID of the members to include in the fleet.</p>', 'ListJobsRequest$principalId' => '<p>The principal ID of the members on the jobs.</p>', 'ListQueuesRequest$principalId' => '<p>The principal ID. This filter is only valid when using Nimble Studio credentials and should match the user ID in the credentials of the caller.</p>', 'QueueMember$principalId' => '<p>The principal ID of the queue member.</p>', ], ], 'IdentityStoreId' => [ 'base' => NULL, 'refs' => [ 'AssociateMemberToFarmRequest$identityStoreId' => '<p>The identity store ID of the member to associate with the farm.</p>', 'AssociateMemberToFleetRequest$identityStoreId' => '<p>The member\'s identity store ID to associate with the fleet.</p>', 'AssociateMemberToJobRequest$identityStoreId' => '<p>The member\'s identity store ID to associate with the job.</p>', 'AssociateMemberToQueueRequest$identityStoreId' => '<p>The member\'s identity store ID to associate with the queue.</p>', 'FarmMember$identityStoreId' => '<p>The identity store ID of the farm member.</p>', 'FleetMember$identityStoreId' => '<p>The identity store ID.</p>', 'JobMember$identityStoreId' => '<p>The identity store ID.</p>', 'QueueMember$identityStoreId' => '<p>The identity store ID.</p>', ], ], 'InstanceType' => [ 'base' => NULL, 'refs' => [ 'HostPropertiesResponse$ec2InstanceType' => '<p>The instance type of the host EC2 instance.</p>', 'InstanceTypes$member' => NULL, 'Statistics$instanceType' => '<p>The type of instance.</p>', ], ], 'InstanceTypes' => [ 'base' => NULL, 'refs' => [ 'ServiceManagedEc2InstanceCapabilities$allowedInstanceTypes' => '<p>The allowable Amazon EC2 instance types.</p>', 'ServiceManagedEc2InstanceCapabilities$excludedInstanceTypes' => '<p>The instance types to exclude from the fleet.</p>', ], ], 'IntString' => [ 'base' => NULL, 'refs' => [ 'JobParameter$int' => '<p>A signed integer represented as a string.</p>', 'TaskParameterValue$int' => '<p>A signed integer represented as a string.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'DependencyCounts$consumersResolved' => '<p>The number of consumers resolved.</p>', 'DependencyCounts$consumersUnresolved' => '<p>The number of unresolved consumers.</p>', 'DependencyCounts$dependenciesResolved' => '<p>The number of resolved dependencies.</p>', 'DependencyCounts$dependenciesUnresolved' => '<p>The number of unresolved dependencies.</p>', 'Ec2EbsVolume$sizeGiB' => '<p>The EBS volume size in GiB.</p>', 'FleetSummary$targetWorkerCount' => '<p>The target number of workers in a fleet.</p>', 'FleetSummary$workerCount' => '<p>The number of workers in the fleet summary.</p>', 'GetFleetResponse$targetWorkerCount' => '<p>The number of target workers in the fleet.</p>', 'GetFleetResponse$workerCount' => '<p>The number of workers in the fleet.</p>', 'InternalServerErrorException$retryAfterSeconds' => '<p>The number of seconds a client should wait before retrying the request.</p>', 'Statistics$count' => '<p>The number of instances in a list of statistics.</p>', 'TaskRunStatusCounts$value' => NULL, 'ThrottlingException$retryAfterSeconds' => '<p>The number of seconds a client should wait before retrying the request.</p>', ], ], 'InternalServerErrorException' => [ 'base' => '<p>Deadline Cloud can\'t process your request right now. Try again later.</p>', 'refs' => [], ], 'IpAddresses' => [ 'base' => '<p>The IP addresses for a host.</p>', 'refs' => [ 'HostPropertiesRequest$ipAddresses' => '<p>The IP address of the host.</p>', 'HostPropertiesResponse$ipAddresses' => '<p>The IP address of the host.</p>', ], ], 'IpV4Address' => [ 'base' => NULL, 'refs' => [ 'IpV4Addresses$member' => NULL, ], ], 'IpV4Addresses' => [ 'base' => NULL, 'refs' => [ 'IpAddresses$ipV4Addresses' => '<p>The IpV4 address of the network.</p>', ], ], 'IpV6Address' => [ 'base' => NULL, 'refs' => [ 'IpV6Addresses$member' => NULL, ], ], 'IpV6Addresses' => [ 'base' => NULL, 'refs' => [ 'IpAddresses$ipV6Addresses' => '<p>The IpV6 address for the network and node component.</p>', ], ], 'JobAttachmentDetailsEntity' => [ 'base' => '<p>The job attachments.</p>', 'refs' => [ 'JobEntity$jobAttachmentDetails' => '<p>The job attachment details.</p>', ], ], 'JobAttachmentDetailsError' => [ 'base' => '<p>The error details for job attachments.</p>', 'refs' => [ 'GetJobEntityError$jobAttachmentDetails' => '<p>The job attachment details for the failed job entity.</p>', ], ], 'JobAttachmentDetailsIdentifiers' => [ 'base' => '<p>Identifier details for job attachments.</p>', 'refs' => [ 'JobEntityIdentifiersUnion$jobAttachmentDetails' => '<p>The job attachment details.</p>', ], ], 'JobAttachmentSettings' => [ 'base' => '<p>The job attachment settings. These are the Amazon S3 bucket name and the Amazon S3 prefix.</p>', 'refs' => [ 'CreateQueueRequest$jobAttachmentSettings' => '<p>The job attachment settings for the queue. These are the Amazon S3 bucket name and the Amazon S3 prefix.</p>', 'GetQueueResponse$jobAttachmentSettings' => '<p>The job attachment settings for the queue.</p>', 'JobDetailsEntity$jobAttachmentSettings' => '<p>The job attachment settings.</p>', 'UpdateQueueRequest$jobAttachmentSettings' => '<p>The job attachment settings to update for the queue.</p>', ], ], 'JobAttachmentsFileSystem' => [ 'base' => NULL, 'refs' => [ 'Attachments$fileSystem' => '<p>The file system.</p>', ], ], 'JobDescription' => [ 'base' => NULL, 'refs' => [ 'GetJobResponse$description' => '<p>The description of the job.</p>', ], ], 'JobDetailsEntity' => [ 'base' => '<p>The job details for a specific job.</p>', 'refs' => [ 'JobEntity$jobDetails' => '<p>The job details.</p>', ], ], 'JobDetailsError' => [ 'base' => '<p>The details of a job error.</p>', 'refs' => [ 'GetJobEntityError$jobDetails' => '<p>The job details for the failed job entity.</p>', ], ], 'JobDetailsIdentifiers' => [ 'base' => '<p>The identifiers for a job.</p>', 'refs' => [ 'JobEntityIdentifiersUnion$jobDetails' => '<p>The job details.</p>', ], ], 'JobEntity' => [ 'base' => '<p>The details of a job entity.</p>', 'refs' => [ 'BatchGetJobEntityList$member' => NULL, ], ], 'JobEntityErrorCode' => [ 'base' => NULL, 'refs' => [ 'EnvironmentDetailsError$code' => '<p>The error code.</p>', 'JobAttachmentDetailsError$code' => '<p>The error code.</p>', 'JobDetailsError$code' => '<p>The error code.</p>', 'StepDetailsError$code' => '<p>The error code.</p>', ], ], 'JobEntityIdentifiers' => [ 'base' => NULL, 'refs' => [ 'BatchGetJobEntityRequest$identifiers' => '<p>The job identifiers to include within the job entity batch details.</p>', ], ], 'JobEntityIdentifiersUnion' => [ 'base' => '<p>The details of a job entity identifier.</p>', 'refs' => [ 'JobEntityIdentifiers$member' => NULL, ], ], 'JobId' => [ 'base' => NULL, 'refs' => [ 'AssignedSession$jobId' => '<p>The job ID for the assigned session.</p>', 'AssociateMemberToJobRequest$jobId' => '<p>The job ID to associate with the member.</p>', 'CopyJobTemplateRequest$jobId' => '<p>The job ID to copy.</p>', 'CreateJobResponse$jobId' => '<p>The job ID.</p>', 'DisassociateMemberFromJobRequest$jobId' => '<p>The job ID to disassociate from a member in a job.</p>', 'EnvironmentDetailsEntity$jobId' => '<p>The job ID.</p>', 'EnvironmentDetailsError$jobId' => '<p>The job ID.</p>', 'EnvironmentDetailsIdentifiers$jobId' => '<p>The job ID.</p>', 'GetJobRequest$jobId' => '<p>The job ID.</p>', 'GetJobResponse$jobId' => '<p>The job ID.</p>', 'GetSessionActionRequest$jobId' => '<p>The job ID for the session.</p>', 'GetSessionRequest$jobId' => '<p>The job ID for the session.</p>', 'GetStepRequest$jobId' => '<p>The job ID for the step.</p>', 'GetTaskRequest$jobId' => '<p>The job ID of the job connected to the task.</p>', 'JobAttachmentDetailsEntity$jobId' => '<p>The job ID.</p>', 'JobAttachmentDetailsError$jobId' => '<p>The job ID.</p>', 'JobAttachmentDetailsIdentifiers$jobId' => '<p>The job ID.</p>', 'JobDetailsEntity$jobId' => '<p>The job ID.</p>', 'JobDetailsError$jobId' => '<p>The job ID.</p>', 'JobDetailsIdentifiers$jobId' => '<p>The job ID.</p>', 'JobMember$jobId' => '<p>The job ID.</p>', 'JobSearchSummary$jobId' => '<p>The job ID.</p>', 'JobSummary$jobId' => '<p>The job ID.</p>', 'ListJobMembersRequest$jobId' => '<p>The job ID to include on the list.</p>', 'ListSessionActionsRequest$jobId' => '<p>The job ID for the session actions list.</p>', 'ListSessionsRequest$jobId' => '<p>The job ID for the list of sessions.</p>', 'ListStepConsumersRequest$jobId' => '<p>The job ID for the step consumer.</p>', 'ListStepDependenciesRequest$jobId' => '<p>The job ID for the step dependencies list.</p>', 'ListStepsRequest$jobId' => '<p>The job ID to include on the list of steps.</p>', 'ListTasksRequest$jobId' => '<p>The job ID for the tasks.</p>', 'SearchStepsRequest$jobId' => '<p>The job ID to use in the step search.</p>', 'SearchTasksRequest$jobId' => '<p>The job ID for the task search.</p>', 'Statistics$jobId' => '<p>The job ID.</p>', 'StepDetailsEntity$jobId' => '<p>The job ID.</p>', 'StepDetailsError$jobId' => '<p>The job ID.</p>', 'StepDetailsIdentifiers$jobId' => '<p>The job ID.</p>', 'StepSearchSummary$jobId' => '<p>The job ID.</p>', 'TaskSearchSummary$jobId' => '<p>The job ID.</p>', 'UpdateJobRequest$jobId' => '<p>The job ID to update.</p>', 'UpdateSessionRequest$jobId' => '<p>The job ID to update in the session.</p>', 'UpdateStepRequest$jobId' => '<p>The job ID to update.</p>', 'UpdateTaskRequest$jobId' => '<p>The job ID to update.</p>', 'WorkerSessionSummary$jobId' => '<p>The job ID for the job associated with the worker\'s session.</p>', ], ], 'JobLifecycleStatus' => [ 'base' => NULL, 'refs' => [ 'GetJobResponse$lifecycleStatus' => '<p>The life cycle status for the job.</p>', 'JobSearchSummary$lifecycleStatus' => '<p>The life cycle status.</p>', 'JobSummary$lifecycleStatus' => '<p>The life cycle status.</p>', ], ], 'JobMember' => [ 'base' => '<p>The details for a job member.</p>', 'refs' => [ 'JobMembers$member' => NULL, ], ], 'JobMembers' => [ 'base' => NULL, 'refs' => [ 'ListJobMembersResponse$members' => '<p>The members on the list.</p>', ], ], 'JobName' => [ 'base' => NULL, 'refs' => [ 'GetJobResponse$name' => '<p>The name of the job.</p>', 'JobSearchSummary$name' => '<p>The job name.</p>', 'JobSummary$name' => '<p>The job name.</p>', 'Statistics$jobName' => '<p>The job name.</p>', ], ], 'JobParameter' => [ 'base' => '<p>The details of job parameters.</p>', 'refs' => [ 'JobParameters$value' => NULL, ], ], 'JobParameters' => [ 'base' => NULL, 'refs' => [ 'CreateJobRequest$parameters' => '<p>The parameters for the job.</p>', 'GetJobResponse$parameters' => '<p>The parameters for the job.</p>', 'JobDetailsEntity$parameters' => '<p>The parameters.</p>', 'JobSearchSummary$jobParameters' => '<p>The job parameters.</p>', ], ], 'JobPriority' => [ 'base' => NULL, 'refs' => [ 'CreateJobRequest$priority' => '<p>The priority of the job on a scale of 1 to 100. The highest priority is 1.</p>', 'GetJobResponse$priority' => '<p>The job priority.</p>', 'JobSearchSummary$priority' => '<p>The job priority.</p>', 'JobSummary$priority' => '<p>The job priority.</p>', 'UpdateJobRequest$priority' => '<p>The job priority to update.</p>', ], ], 'JobRunAsUser' => [ 'base' => '<p>Identifies the user for a job.</p>', 'refs' => [ 'CreateQueueRequest$jobRunAsUser' => '<p>The jobs in the queue run as the specified POSIX user.</p>', 'GetQueueResponse$jobRunAsUser' => '<p>The jobs in the queue ran as this specified POSIX user.</p>', 'JobDetailsEntity$jobRunAsUser' => '<p>The user name and group that the job uses when run.</p>', 'UpdateQueueRequest$jobRunAsUser' => '<p>Update the jobs in the queue to run as a specified POSIX user.</p>', ], ], 'JobSearchSummaries' => [ 'base' => NULL, 'refs' => [ 'SearchJobsResponse$jobs' => '<p>The jobs in the search.</p>', ], ], 'JobSearchSummary' => [ 'base' => '<p>The details of a job search.</p>', 'refs' => [ 'JobSearchSummaries$member' => NULL, ], ], 'JobSummaries' => [ 'base' => NULL, 'refs' => [ 'ListJobsResponse$jobs' => '<p>The jobs on the list.</p>', ], ], 'JobSummary' => [ 'base' => '<p>A summary of job details.</p>', 'refs' => [ 'JobSummaries$member' => NULL, ], ], 'JobTargetTaskRunStatus' => [ 'base' => NULL, 'refs' => [ 'GetJobResponse$targetTaskRunStatus' => '<p>The task status with which the job started.</p>', 'JobSearchSummary$targetTaskRunStatus' => '<p>The task status to start with on the job.</p>', 'JobSummary$targetTaskRunStatus' => '<p>The task status to start with on the job.</p>', 'UpdateJobRequest$targetTaskRunStatus' => '<p>The task status to update the job\'s tasks to.</p>', ], ], 'JobTemplate' => [ 'base' => NULL, 'refs' => [ 'CreateJobRequest$template' => '<p>The job template to use for this job.</p>', ], ], 'JobTemplateType' => [ 'base' => NULL, 'refs' => [ 'CopyJobTemplateResponse$templateType' => '<p>The format of the job template, either <code>JSON</code> or <code>YAML</code>.</p>', 'CreateJobRequest$templateType' => '<p>The file type for the job template.</p>', ], ], 'KmsKeyArn' => [ 'base' => NULL, 'refs' => [ 'CreateFarmRequest$kmsKeyArn' => '<p>The ARN of the KMS key to use on the farm.</p>', 'FarmSummary$kmsKeyArn' => '<p>The ARN for the KMS key.</p>', 'GetFarmResponse$kmsKeyArn' => '<p>The ARN of the KMS key used on the farm.</p>', ], ], 'LicenseEndpointId' => [ 'base' => NULL, 'refs' => [ 'CreateLicenseEndpointResponse$licenseEndpointId' => '<p>The license endpoint ID.</p>', 'DeleteLicenseEndpointRequest$licenseEndpointId' => '<p>The license endpoint ID of the license endpoint to delete.</p>', 'DeleteMeteredProductRequest$licenseEndpointId' => '<p>The ID of the license endpoint from which to remove the metered product.</p>', 'GetLicenseEndpointRequest$licenseEndpointId' => '<p>The license endpoint ID.</p>', 'GetLicenseEndpointResponse$licenseEndpointId' => '<p>The license endpoint ID.</p>', 'LicenseEndpointSummary$licenseEndpointId' => '<p>The license endpoint ID.</p>', 'ListMeteredProductsRequest$licenseEndpointId' => '<p>The license endpoint ID to include on the list of metered products.</p>', 'PutMeteredProductRequest$licenseEndpointId' => '<p>The license endpoint ID to add to the metered product.</p>', ], ], 'LicenseEndpointStatus' => [ 'base' => NULL, 'refs' => [ 'GetLicenseEndpointResponse$status' => '<p>The status of the license endpoint.</p>', 'LicenseEndpointSummary$status' => '<p>The status of the license endpoint.</p>', ], ], 'LicenseEndpointSummaries' => [ 'base' => NULL, 'refs' => [ 'ListLicenseEndpointsResponse$licenseEndpoints' => '<p>The license endpoints.</p>', ], ], 'LicenseEndpointSummary' => [ 'base' => '<p>The details for a license endpoint.</p>', 'refs' => [ 'LicenseEndpointSummaries$member' => NULL, ], ], 'LicenseProduct' => [ 'base' => NULL, 'refs' => [ 'Statistics$licenseProduct' => '<p>The licensed product.</p>', ], ], 'ListAttributeCapabilityValue' => [ 'base' => NULL, 'refs' => [ 'StepAttributeCapability$allOf' => '<p>Requires all of the step attribute values.</p>', 'StepAttributeCapability$anyOf' => '<p>Requires any of the step attributes in a given list.</p>', ], ], 'ListAvailableMeteredProductsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAvailableMeteredProductsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListBudgetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListBudgetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFarmMembersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFarmMembersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFarmsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFarmsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFleetMembersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFleetMembersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFleetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFleetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListJobMembersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListJobMembersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListLicenseEndpointsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListLicenseEndpointsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListMeteredProductsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListMeteredProductsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListMonitorsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListMonitorsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListQueueEnvironmentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListQueueEnvironmentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListQueueFleetAssociationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListQueueFleetAssociationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListQueueMembersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListQueueMembersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListQueuesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListQueuesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSessionActionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSessionActionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSessionsForWorkerRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSessionsForWorkerResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSessionsForWorkerSummaries' => [ 'base' => NULL, 'refs' => [ 'ListSessionsForWorkerResponse$sessions' => '<p>The sessions in the response.</p>', ], ], 'ListSessionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSessionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListStepConsumersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListStepConsumersRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListStepConsumersRequest$maxResults' => '<p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>', ], ], 'ListStepConsumersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListStepDependenciesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListStepDependenciesRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListStepDependenciesRequest$maxResults' => '<p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>', ], ], 'ListStepDependenciesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListStepsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListStepsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListStorageProfilesForQueueRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListStorageProfilesForQueueResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListStorageProfilesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListStorageProfilesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTasksRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTasksResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkersResponse' => [ 'base' => NULL, 'refs' => [], ], 'LogConfiguration' => [ 'base' => '<p>Log configuration details.</p>', 'refs' => [ 'AssignedSession$logConfiguration' => '<p>The log configuration for the worker\'s assigned session.</p>', 'GetSessionResponse$log' => '<p>The session log.</p>', 'GetSessionResponse$workerLog' => '<p>The worker log for the session.</p>', 'GetWorkerResponse$log' => '<p>The logs for the associated worker.</p>', 'UpdateWorkerResponse$log' => '<p>The worker log to update.</p>', 'WorkerSummary$log' => '<p>The log configuration for the worker.</p>', ], ], 'LogDriver' => [ 'base' => NULL, 'refs' => [ 'LogConfiguration$logDriver' => '<p>The log drivers for worker related logs.</p>', ], ], 'LogError' => [ 'base' => NULL, 'refs' => [ 'LogConfiguration$error' => '<p>The log configuration error details.</p>', ], ], 'LogOptions' => [ 'base' => NULL, 'refs' => [ 'LogConfiguration$options' => '<p>The options for a log driver.</p>', ], ], 'LogParameters' => [ 'base' => NULL, 'refs' => [ 'LogConfiguration$parameters' => '<p>The parameters for the log configuration.</p>', ], ], 'LogicalOperator' => [ 'base' => NULL, 'refs' => [ 'SearchGroupedFilterExpressions$operator' => '<p>The operators to include in the search.</p>', ], ], 'ManifestProperties' => [ 'base' => '<p>The details of the manifest that links a job\'s source information.</p>', 'refs' => [ 'ManifestPropertiesList$member' => NULL, ], ], 'ManifestPropertiesInputManifestHashString' => [ 'base' => NULL, 'refs' => [ 'ManifestProperties$inputManifestHash' => '<p>The has value of the file.</p>', ], ], 'ManifestPropertiesInputManifestPathString' => [ 'base' => NULL, 'refs' => [ 'ManifestProperties$inputManifestPath' => '<p>The file path.</p>', ], ], 'ManifestPropertiesList' => [ 'base' => NULL, 'refs' => [ 'Attachments$manifests' => '<p>A list of manifests which describe job attachment configurations.</p>', ], ], 'ManifestPropertiesRootPathString' => [ 'base' => NULL, 'refs' => [ 'ManifestProperties$rootPath' => '<p>The file\'s root path.</p>', ], ], 'MaxFailedTasksCount' => [ 'base' => NULL, 'refs' => [ 'CreateJobRequest$maxFailedTasksCount' => '<p>The number of task failures before the job stops running and is marked as <code>FAILED</code>.</p>', 'GetJobResponse$maxFailedTasksCount' => '<p>The number of task failures before the job stops running and is marked as <code>FAILED</code>.</p>', 'JobSearchSummary$maxFailedTasksCount' => '<p>The number of task failures before the job stops running and is marked as <code>FAILED</code>.</p>', 'JobSummary$maxFailedTasksCount' => '<p>The number of task failures before the job stops running and is marked as <code>FAILED</code>.</p>', 'UpdateJobRequest$maxFailedTasksCount' => '<p>The number of task failures before the job stops running and is marked as <code>FAILED</code>.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'GetSessionsStatisticsAggregationRequest$maxResults' => '<p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>', 'ListAvailableMeteredProductsRequest$maxResults' => '<p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>', 'ListBudgetsRequest$maxResults' => '<p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>', 'ListFarmMembersRequest$maxResults' => '<p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>', 'ListFarmsRequest$maxResults' => '<p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>', 'ListFleetMembersRequest$maxResults' => '<p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>', 'ListFleetsRequest$maxResults' => '<p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>', 'ListJobMembersRequest$maxResults' => '<p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>', 'ListJobsRequest$maxResults' => '<p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>', 'ListLicenseEndpointsRequest$maxResults' => '<p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>', 'ListMeteredProductsRequest$maxResults' => '<p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>', 'ListMonitorsRequest$maxResults' => '<p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>', 'ListQueueEnvironmentsRequest$maxResults' => '<p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>', 'ListQueueFleetAssociationsRequest$maxResults' => '<p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>', 'ListQueueMembersRequest$maxResults' => '<p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>', 'ListQueuesRequest$maxResults' => '<p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>', 'ListSessionActionsRequest$maxResults' => '<p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>', 'ListSessionsForWorkerRequest$maxResults' => '<p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>', 'ListSessionsRequest$maxResults' => '<p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>', 'ListStepsRequest$maxResults' => '<p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>', 'ListStorageProfilesForQueueRequest$maxResults' => '<p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>', 'ListStorageProfilesRequest$maxResults' => '<p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>', 'ListTasksRequest$maxResults' => '<p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>', 'ListWorkersRequest$maxResults' => '<p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>', ], ], 'MaxRetriesPerTask' => [ 'base' => NULL, 'refs' => [ 'CreateJobRequest$maxRetriesPerTask' => '<p>The maximum number of retries for a job.</p>', 'GetJobResponse$maxRetriesPerTask' => '<p>The maximum number of retries per failed tasks.</p>', 'JobSearchSummary$maxRetriesPerTask' => '<p>The maximum number of retries for a job.</p>', 'JobSummary$maxRetriesPerTask' => '<p>The maximum number of retries for a job.</p>', 'UpdateJobRequest$maxRetriesPerTask' => '<p>The maximum number of retries for a job.</p>', ], ], 'MembershipLevel' => [ 'base' => NULL, 'refs' => [ 'AssociateMemberToFarmRequest$membershipLevel' => '<p>The principal\'s membership level for the associated farm.</p>', 'AssociateMemberToFleetRequest$membershipLevel' => '<p>The principal\'s membership level for the associated fleet.</p>', 'AssociateMemberToJobRequest$membershipLevel' => '<p>The principal\'s membership level for the associated job.</p>', 'AssociateMemberToQueueRequest$membershipLevel' => '<p>The principal\'s membership level for the associated queue.</p>', 'FarmMember$membershipLevel' => '<p>The farm member\'s membership level.</p>', 'FleetMember$membershipLevel' => '<p>The fleet member\'s membership level.</p>', 'JobMember$membershipLevel' => '<p>The job member\'s membership level.</p>', 'QueueMember$membershipLevel' => '<p>The queue member\'s membership level.</p>', ], ], 'MemoryAmountMiB' => [ 'base' => NULL, 'refs' => [ 'MemoryMiBRange$max' => '<p>The maximum amount of memory (in MiB).</p>', 'MemoryMiBRange$min' => '<p>The minimum amount of memory (in MiB).</p>', ], ], 'MemoryMiBRange' => [ 'base' => '<p>The range of memory in MiB.</p>', 'refs' => [ 'CustomerManagedWorkerCapabilities$memoryMiB' => '<p>The memory (MiB).</p>', 'ServiceManagedEc2InstanceCapabilities$memoryMiB' => '<p>The memory, as MiB, for the Amazon EC2 instance type.</p>', ], ], 'MeteredProductId' => [ 'base' => NULL, 'refs' => [ 'DeleteMeteredProductRequest$productId' => '<p>The product ID to remove from the license endpoint.</p>', 'MeteredProductSummary$productId' => '<p>The product ID.</p>', 'PutMeteredProductRequest$productId' => '<p>The product ID to add to the metered product.</p>', ], ], 'MeteredProductSummary' => [ 'base' => '<p>The details of a metered product.</p>', 'refs' => [ 'MeteredProductSummaryList$member' => NULL, ], ], 'MeteredProductSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListAvailableMeteredProductsResponse$meteredProducts' => '<p>The metered products.</p>', 'ListMeteredProductsResponse$meteredProducts' => '<p>The metered products to list.</p>', ], ], 'MinOneMaxTenThousand' => [ 'base' => NULL, 'refs' => [ 'VCpuCountRange$max' => '<p>The maximum amount of vCPU.</p>', 'VCpuCountRange$min' => '<p>The minimum amount of vCPU.</p>', ], ], 'MinZeroMaxInteger' => [ 'base' => NULL, 'refs' => [ 'AcceleratorCountRange$max' => '<p>The maximum GPU for the accelerator.</p>', 'AcceleratorCountRange$min' => '<p>The minimum GPU for the accelerator.</p>', 'AcceleratorTotalMemoryMiBRange$max' => '<p>The maximum amount of memory to use for the accelerator, measured in MiB.</p>', 'AcceleratorTotalMemoryMiBRange$min' => '<p>The minimum amount of memory to use for the accelerator, measured in MiB.</p>', 'CreateFleetRequest$maxWorkerCount' => '<p>The maximum number of workers for the fleet.</p>', 'CreateFleetRequest$minWorkerCount' => '<p>The minimum number of workers for the fleet.</p>', 'FleetSummary$maxWorkerCount' => '<p>The maximum number of workers specified in the fleet.</p>', 'FleetSummary$minWorkerCount' => '<p>The minimum number of workers in the fleet.</p>', 'GetFleetResponse$maxWorkerCount' => '<p>The maximum number of workers specified in the fleet.</p>', 'GetFleetResponse$minWorkerCount' => '<p>The minimum number of workers specified in the fleet.</p>', 'UpdateFleetRequest$maxWorkerCount' => '<p>The maximum number of workers in the fleet.</p>', 'UpdateFleetRequest$minWorkerCount' => '<p>The minimum number of workers in the fleet.</p>', ], ], 'MonitorId' => [ 'base' => NULL, 'refs' => [ 'CreateMonitorResponse$monitorId' => '<p>The unique identifier of the monitor.</p>', 'DeleteMonitorRequest$monitorId' => '<p>The unique identifier of the monitor to delete. This ID is returned by the <code>CreateMonitor</code> operation, and is included in the response to the <code>GetMonitor</code> operation.</p>', 'GetMonitorRequest$monitorId' => '<p>The unique identifier for the monitor. This ID is returned by the <code>CreateMonitor</code> operation.</p>', 'GetMonitorResponse$monitorId' => '<p>The unique identifier for the monitor.</p>', 'MonitorSummary$monitorId' => '<p>The unique identifier for the monitor.</p>', 'UpdateMonitorRequest$monitorId' => '<p>The unique identifier of the monitor to update.</p>', ], ], 'MonitorSummaries' => [ 'base' => NULL, 'refs' => [ 'ListMonitorsResponse$monitors' => '<p>A list of <code>MonitorSummary</code> objects that describe your monitors in the Deadline Cloud.</p>', ], ], 'MonitorSummary' => [ 'base' => '<p>Provides information about a monitor in Deadline Cloud.</p>', 'refs' => [ 'MonitorSummaries$member' => NULL, ], ], 'NextItemOffset' => [ 'base' => NULL, 'refs' => [ 'SearchJobsResponse$nextItemOffset' => '<p>The next incremental starting point after the defined <code>itemOffset</code>.</p>', 'SearchStepsResponse$nextItemOffset' => '<p>The next incremental starting point after the defined <code>itemOffset</code>.</p>', 'SearchTasksResponse$nextItemOffset' => '<p>The next incremental starting point after the defined <code>itemOffset</code>.</p>', 'SearchWorkersResponse$nextItemOffset' => '<p>The next incremental starting point after the defined <code>itemOffset</code>.</p>', ], ], 'OutputRelativeDirectoriesList' => [ 'base' => NULL, 'refs' => [ 'ManifestProperties$outputRelativeDirectories' => '<p>The file path relative to the directory.</p>', ], ], 'OutputRelativeDirectoriesListMemberString' => [ 'base' => NULL, 'refs' => [ 'OutputRelativeDirectoriesList$member' => NULL, ], ], 'ParameterFilterExpression' => [ 'base' => '<p>The details of a filtered search for parameters.</p>', 'refs' => [ 'SearchFilterExpression$parameterFilter' => '<p>Filters by parameter.</p>', ], ], 'ParameterSortExpression' => [ 'base' => '<p>Organizes parameters according to your specifications.</p>', 'refs' => [ 'SearchSortExpression$parameterSort' => '<p>Options for sorting by a parameter.</p>', ], ], 'ParameterSpace' => [ 'base' => '<p>The details of a search for two or more step parameters.</p>', 'refs' => [ 'GetStepResponse$parameterSpace' => '<p>A list of step parameters and the combination expression for the step.</p>', 'StepSearchSummary$parameterSpace' => '<p>The parameters and combination expressions for the search.</p>', ], ], 'ParameterString' => [ 'base' => NULL, 'refs' => [ 'JobParameter$string' => '<p>A UTF-8 string.</p>', 'TaskParameterValue$string' => '<p>A UTF-8 string.</p>', ], ], 'ParameterValue' => [ 'base' => NULL, 'refs' => [ 'ParameterFilterExpression$value' => '<p>The parameter\'s value.</p>', ], ], 'PathFormat' => [ 'base' => NULL, 'refs' => [ 'ManifestProperties$rootPathFormat' => '<p>The format of the root path.</p>', 'PathMappingRule$sourcePathFormat' => '<p>The source path format.</p>', ], ], 'PathMappingRule' => [ 'base' => '<p>The details of a source and destination path.</p>', 'refs' => [ 'PathMappingRules$member' => NULL, ], ], 'PathMappingRules' => [ 'base' => NULL, 'refs' => [ 'JobDetailsEntity$pathMappingRules' => '<p>The path mapping rules.</p>', ], ], 'PathString' => [ 'base' => NULL, 'refs' => [ 'FileSystemLocation$path' => '<p>The file path.</p>', 'JobParameter$path' => '<p>A file system path represented as a string.</p>', 'TaskParameterValue$path' => '<p>A file system path represented as a string.</p>', ], ], 'Period' => [ 'base' => NULL, 'refs' => [ 'StartSessionsStatisticsAggregationRequest$period' => '<p>The period to aggregate the statistics.</p>', ], ], 'PortNumber' => [ 'base' => NULL, 'refs' => [ 'MeteredProductSummary$port' => '<p>The port on which the metered product should run.</p>', ], ], 'PosixUser' => [ 'base' => '<p>The POSIX user.</p>', 'refs' => [ 'JobRunAsUser$posix' => '<p>The user and group that the jobs in the queue run as.</p>', ], ], 'PosixUserGroupString' => [ 'base' => NULL, 'refs' => [ 'PosixUser$group' => '<p>The name of the POSIX user\'s group.</p>', ], ], 'PosixUserUserString' => [ 'base' => NULL, 'refs' => [ 'PosixUser$user' => '<p>The name of the POSIX user.</p>', ], ], 'PrincipalType' => [ 'base' => NULL, 'refs' => [ 'AssociateMemberToFarmRequest$principalType' => '<p>The principal type of the member to associate with the farm.</p>', 'AssociateMemberToFleetRequest$principalType' => '<p>The member\'s principal type to associate with the fleet.</p>', 'AssociateMemberToJobRequest$principalType' => '<p>The member\'s principal type to associate with the job.</p>', 'AssociateMemberToQueueRequest$principalType' => '<p>The member\'s principal type to associate with the queue.</p>', 'FarmMember$principalType' => '<p>The principal type of the farm member.</p>', 'FleetMember$principalType' => '<p>The principal type of the fleet member.</p>', 'JobMember$principalType' => '<p>The principal type of the job member.</p>', 'QueueMember$principalType' => '<p>The principal type of the queue member.</p>', ], ], 'Priority' => [ 'base' => NULL, 'refs' => [ 'CreateQueueEnvironmentRequest$priority' => '<p>Sets the priority of the environments in the queue from 0 to 10,000, where 0 is the highest priority. If two environments share the same priority value, the environment created first takes higher priority.</p>', 'GetQueueEnvironmentResponse$priority' => '<p>The priority of the queue environment.</p>', 'QueueEnvironmentSummary$priority' => '<p>The queue environment\'s priority.</p>', 'UpdateQueueEnvironmentRequest$priority' => '<p>The priority to update.</p>', ], ], 'ProcessExitCode' => [ 'base' => NULL, 'refs' => [ 'GetSessionActionResponse$processExitCode' => '<p>The exit code to exit the session.</p>', 'UpdatedSessionActionInfo$processExitCode' => '<p>The process exit code.</p>', ], ], 'PutMeteredProductRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutMeteredProductResponse' => [ 'base' => NULL, 'refs' => [], ], 'QueueBlockedReason' => [ 'base' => NULL, 'refs' => [ 'GetQueueResponse$blockedReason' => '<p>The reason the queue was blocked.</p>', 'QueueSummary$blockedReason' => '<p>The reason the queue is blocked, if applicable.</p>', ], ], 'QueueEnvironmentId' => [ 'base' => NULL, 'refs' => [ 'CreateQueueEnvironmentResponse$queueEnvironmentId' => '<p>The queue environment ID.</p>', 'DeleteQueueEnvironmentRequest$queueEnvironmentId' => '<p>The queue environment ID of the queue environment to delete.</p>', 'GetQueueEnvironmentRequest$queueEnvironmentId' => '<p>The queue environment ID.</p>', 'GetQueueEnvironmentResponse$queueEnvironmentId' => '<p>The queue environment ID.</p>', 'QueueEnvironmentSummary$queueEnvironmentId' => '<p>The queue environment ID.</p>', 'UpdateQueueEnvironmentRequest$queueEnvironmentId' => '<p>The queue environment ID to update.</p>', ], ], 'QueueEnvironmentSummaries' => [ 'base' => NULL, 'refs' => [ 'ListQueueEnvironmentsResponse$environments' => '<p>The environments to include in the queue environments list.</p>', ], ], 'QueueEnvironmentSummary' => [ 'base' => '<p>The summary of a queue environment.</p>', 'refs' => [ 'QueueEnvironmentSummaries$member' => NULL, ], ], 'QueueFleetAssociationStatus' => [ 'base' => NULL, 'refs' => [ 'GetQueueFleetAssociationResponse$status' => '<p>The status of the queue-fleet association.</p>', 'QueueFleetAssociationSummary$status' => '<p>The status of task scheduling in the queue-fleet association.</p> <ul> <li> <p> <code>ACTIVE</code>–Association is active.</p> </li> <li> <p> <code>STOP_SCHEDULING_AND_COMPLETE_TASKS</code>–Association has stopped scheduling new tasks and is completing current tasks.</p> </li> <li> <p> <code>STOP_SCHEDULING_AND_CANCEL_TASKS</code>–Association has stopped scheduling new tasks and is canceling current tasks.</p> </li> <li> <p> <code>STOPPED</code>–Association has been stopped.</p> </li> </ul>', ], ], 'QueueFleetAssociationSummaries' => [ 'base' => NULL, 'refs' => [ 'ListQueueFleetAssociationsResponse$queueFleetAssociations' => '<p>The queue-fleet associations on the list.</p>', ], ], 'QueueFleetAssociationSummary' => [ 'base' => '<p>The details of a queue-fleet association.</p>', 'refs' => [ 'QueueFleetAssociationSummaries$member' => NULL, ], ], 'QueueId' => [ 'base' => NULL, 'refs' => [ 'AssignedSession$queueId' => '<p>The queue ID of the assigned session.</p>', 'AssociateMemberToJobRequest$queueId' => '<p>The queue ID to associate to the member.</p>', 'AssociateMemberToQueueRequest$queueId' => '<p>The ID of the queue to associate to the member.</p>', 'AssumeQueueRoleForReadRequest$queueId' => '<p>The queue ID.</p>', 'AssumeQueueRoleForUserRequest$queueId' => '<p>The queue ID of the queue that the user assumes the role for.</p>', 'AssumeQueueRoleForWorkerRequest$queueId' => '<p>The queue ID of the worker assuming the queue role.</p>', 'CopyJobTemplateRequest$queueId' => '<p>The queue ID to copy.</p>', 'CreateJobRequest$queueId' => '<p>The ID of the queue that the job is submitted to.</p>', 'CreateQueueEnvironmentRequest$queueId' => '<p>The queue ID to connect the queue and environment.</p>', 'CreateQueueFleetAssociationRequest$queueId' => '<p>The queue ID.</p>', 'CreateQueueResponse$queueId' => '<p>The queue ID.</p>', 'DeleteQueueEnvironmentRequest$queueId' => '<p>The queue ID of the queue environment to delete.</p>', 'DeleteQueueFleetAssociationRequest$queueId' => '<p>The queue ID of the queue-fleet association.</p>', 'DeleteQueueRequest$queueId' => '<p>The queue ID of the queue to delete.</p>', 'DisassociateMemberFromJobRequest$queueId' => '<p>The queue ID connected to a job for which you\'re disassociating a member.</p>', 'DisassociateMemberFromQueueRequest$queueId' => '<p>The queue ID of the queue in which you\'re disassociating from a member.</p>', 'GetJobRequest$queueId' => '<p>The queue ID associated with the job.</p>', 'GetQueueEnvironmentRequest$queueId' => '<p>The queue ID for the queue environment.</p>', 'GetQueueFleetAssociationRequest$queueId' => '<p>The queue ID for the queue-fleet association.</p>', 'GetQueueFleetAssociationResponse$queueId' => '<p>The queue ID for the queue-fleet association.</p>', 'GetQueueRequest$queueId' => '<p>The queue ID for the queue to retrieve.</p>', 'GetQueueResponse$queueId' => '<p>The queue ID.</p>', 'GetSessionActionRequest$queueId' => '<p>The queue ID for the session action.</p>', 'GetSessionRequest$queueId' => '<p>The queue ID for the session.</p>', 'GetStepRequest$queueId' => '<p>The queue ID for the step.</p>', 'GetStorageProfileForQueueRequest$queueId' => '<p>The queue ID the queue in the storage profile.</p>', 'GetTaskRequest$queueId' => '<p>The queue ID for the queue connected to the task.</p>', 'JobMember$queueId' => '<p>The queue ID.</p>', 'JobSearchSummary$queueId' => '<p>The queue ID.</p>', 'ListJobMembersRequest$queueId' => '<p>The queue ID to include on the list.</p>', 'ListJobsRequest$queueId' => '<p>The queue ID for the job.</p>', 'ListQueueEnvironmentsRequest$queueId' => '<p>The queue ID for the queue environment list.</p>', 'ListQueueFleetAssociationsRequest$queueId' => '<p>The queue ID for the queue-fleet association list.</p>', 'ListQueueMembersRequest$queueId' => '<p>The queue ID to include on the list.</p>', 'ListSessionActionsRequest$queueId' => '<p>The queue ID for the session actions list.</p>', 'ListSessionsRequest$queueId' => '<p>The queue ID for the list of sessions</p>', 'ListStepConsumersRequest$queueId' => '<p>The queue ID for the step consumer.</p>', 'ListStepDependenciesRequest$queueId' => '<p>The queue ID for the step dependencies list.</p>', 'ListStepsRequest$queueId' => '<p>The queue ID to include on the list of steps.</p>', 'ListStorageProfilesForQueueRequest$queueId' => '<p>The queue ID for the storage profile.</p>', 'ListTasksRequest$queueId' => '<p>The queue ID connected to the tasks.</p>', 'QueueFleetAssociationSummary$queueId' => '<p>The queue ID.</p>', 'QueueMember$queueId' => '<p>The queue ID.</p>', 'QueueSummary$queueId' => '<p>The queue ID.</p>', 'SearchJobsRequestQueueIdsList$member' => NULL, 'SearchStepsRequestQueueIdsList$member' => NULL, 'SearchTasksRequestQueueIdsList$member' => NULL, 'SessionsStatisticsResourcesQueueIdsList$member' => NULL, 'Statistics$queueId' => '<p>The queue ID.</p>', 'StepSearchSummary$queueId' => '<p>The queue ID.</p>', 'TaskSearchSummary$queueId' => '<p>The queue ID.</p>', 'UpdateJobRequest$queueId' => '<p>The queue ID of the job to update.</p>', 'UpdateQueueEnvironmentRequest$queueId' => '<p>The queue ID of the queue environment to update.</p>', 'UpdateQueueFleetAssociationRequest$queueId' => '<p>The queue ID to update.</p>', 'UpdateQueueRequest$queueId' => '<p>The queue ID to update.</p>', 'UpdateSessionRequest$queueId' => '<p>The queue ID to update in the session.</p>', 'UpdateStepRequest$queueId' => '<p>The queue ID to update.</p>', 'UpdateTaskRequest$queueId' => '<p>The queue ID to update.</p>', 'UsageTrackingResource$queueId' => '<p>The queue ID.</p>', 'WorkerSessionSummary$queueId' => '<p>The queue ID for the queue associated to the worker.</p>', ], ], 'QueueMember' => [ 'base' => '<p>The details of a queue member.</p>', 'refs' => [ 'QueueMemberList$member' => NULL, ], ], 'QueueMemberList' => [ 'base' => NULL, 'refs' => [ 'ListQueueMembersResponse$members' => '<p>The members on the list.</p>', ], ], 'QueueStatus' => [ 'base' => NULL, 'refs' => [ 'GetQueueResponse$status' => '<p>The status of the queue.</p> <ul> <li> <p> <code>ACTIVE</code>–The queue is active.</p> </li> <li> <p> <code>SCHEDULING</code>–The queue is scheduling.</p> </li> <li> <p> <code>SCHEDULING_BLOCKED</code>–The queue scheduling is blocked. See the provided reason.</p> </li> </ul>', 'ListQueuesRequest$status' => '<p>The status of the queues listed.</p> <ul> <li> <p> <code>ACTIVE</code>–The queues are active.</p> </li> <li> <p> <code>SCHEDULING</code>–The queues are scheduling.</p> </li> <li> <p> <code>SCHEDULING_BLOCKED</code>–The queue scheduling is blocked for these queues.</p> </li> </ul>', 'QueueSummary$status' => '<p>That status of the queue.</p>', ], ], 'QueueSummaries' => [ 'base' => NULL, 'refs' => [ 'ListQueuesResponse$queues' => '<p>The queues on the list.</p>', ], ], 'QueueSummary' => [ 'base' => '<p>The details of a queue summary.</p>', 'refs' => [ 'QueueSummaries$member' => NULL, ], ], 'RequiredFileSystemLocationNames' => [ 'base' => NULL, 'refs' => [ 'CreateQueueRequest$requiredFileSystemLocationNames' => '<p>The file system location name to include in the queue.</p>', 'GetQueueResponse$requiredFileSystemLocationNames' => '<p>A list of the required file system location names in the queue.</p>', 'UpdateQueueRequest$requiredFileSystemLocationNamesToAdd' => '<p>The required file system location names to add to the queue.</p>', 'UpdateQueueRequest$requiredFileSystemLocationNamesToRemove' => '<p>The required file system location names to remove from the queue.</p>', ], ], 'ResourceName' => [ 'base' => NULL, 'refs' => [ 'BudgetSummary$displayName' => '<p>The display name of the budget summary to update.</p>', 'CreateBudgetRequest$displayName' => '<p>The display name of the budget.</p>', 'CreateFarmRequest$displayName' => '<p>The display name of the farm.</p>', 'CreateFleetRequest$displayName' => '<p>The display name of the fleet.</p>', 'CreateMonitorRequest$displayName' => '<p>The name that you give the monitor that is displayed in the Deadline Cloud console.</p>', 'CreateQueueRequest$displayName' => '<p>The display name of the queue.</p>', 'CreateStorageProfileRequest$displayName' => '<p>The display name of the storage profile.</p>', 'FarmSummary$displayName' => '<p>The display name of the farm.</p>', 'FleetSummary$displayName' => '<p>The display name of the fleet summary to update.</p>', 'GetBudgetResponse$displayName' => '<p>The display name of the budget.</p>', 'GetFarmResponse$displayName' => '<p>The display name of the farm.</p>', 'GetFleetResponse$displayName' => '<p>The display name of the fleet.</p>', 'GetMonitorResponse$displayName' => '<p>The name used to identify the monitor on the Deadline Cloud console.</p>', 'GetQueueResponse$displayName' => '<p>The display name of the queue.</p>', 'GetStorageProfileForQueueResponse$displayName' => '<p>The display name of the storage profile connected to a queue.</p>', 'GetStorageProfileResponse$displayName' => '<p>The display name of the storage profile.</p>', 'ListFleetsRequest$displayName' => '<p>The display names of a list of fleets.</p>', 'MonitorSummary$displayName' => '<p>The name of the monitor that displays on the Deadline Cloud console.</p>', 'QueueSummary$displayName' => '<p>The display name of the queue summary to update.</p>', 'StorageProfileSummary$displayName' => '<p>The display name of the storage profile summary to update.</p>', 'UpdateBudgetRequest$displayName' => '<p>The display name of the budget to update.</p>', 'UpdateFarmRequest$displayName' => '<p>The display name of the farm to update.</p>', 'UpdateFleetRequest$displayName' => '<p>The display name of the fleet to update.</p>', 'UpdateMonitorRequest$displayName' => '<p>The new value to use for the monitor\'s display name.</p>', 'UpdateQueueRequest$displayName' => '<p>The display name of the queue to update.</p>', 'UpdateStorageProfileRequest$displayName' => '<p>The display name of the storage profile to update.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The requested resource can\'t be found.</p>', 'refs' => [], ], 'ResponseBudgetAction' => [ 'base' => '<p>The details of a budget action.</p>', 'refs' => [ 'ResponseBudgetActionList$member' => NULL, ], ], 'ResponseBudgetActionList' => [ 'base' => NULL, 'refs' => [ 'GetBudgetResponse$actions' => '<p>The budget actions for the budget.</p>', ], ], 'RunAs' => [ 'base' => NULL, 'refs' => [ 'JobRunAsUser$runAs' => '<p>Specifies whether the job should run using the queue\'s system user or if the job should run using the worker agent system user.</p>', ], ], 'S3BucketName' => [ 'base' => NULL, 'refs' => [ 'JobAttachmentSettings$s3BucketName' => '<p>The Amazon S3 bucket name.</p>', 'S3Location$bucketName' => '<p>The name of the Amazon S3 bucket.</p>', ], ], 'S3Key' => [ 'base' => NULL, 'refs' => [ 'S3Location$key' => '<p>The Amazon S3 object key that uniquely identifies the Amazon S3 bucket.</p>', ], ], 'S3Location' => [ 'base' => '<p>The Amazon S3 location information.</p>', 'refs' => [ 'CopyJobTemplateRequest$targetS3Location' => '<p>The Amazon S3 bucket name and key where you would like to add a copy of the job template.</p>', ], ], 'S3Prefix' => [ 'base' => NULL, 'refs' => [ 'JobAttachmentSettings$rootPrefix' => '<p>The root prefix.</p>', ], ], 'SearchFilterExpression' => [ 'base' => '<p>The type of search filter to apply.</p>', 'refs' => [ 'SearchFilterExpressions$member' => NULL, ], ], 'SearchFilterExpressions' => [ 'base' => NULL, 'refs' => [ 'SearchGroupedFilterExpressions$filters' => '<p>The filters to use for the search.</p>', ], ], 'SearchGroupedFilterExpressions' => [ 'base' => '<p>The filter expression, <code>AND</code> or <code>OR</code>, to use when searching among a group of search strings in a resource. <p>You can use two groupings per search each within parenthesis <code>()</code>.</p></p>', 'refs' => [ 'SearchFilterExpression$groupFilter' => '<p>Filters by group.</p>', 'SearchJobsRequest$filterExpressions' => '<p>The filter expression, <code>AND</code> or <code>OR</code>, to use when searching among a group of search strings in a resource. <p>You can use two groupings per search each within parenthesis <code>()</code>.</p></p>', 'SearchStepsRequest$filterExpressions' => '<p>The filter expression, <code>AND</code> or <code>OR</code>, to use when searching among a group of search strings in a resource. <p>You can use two groupings per search each within parenthesis <code>()</code>.</p></p>', 'SearchTasksRequest$filterExpressions' => '<p>The filter expression, <code>AND</code> or <code>OR</code>, to use when searching among a group of search strings in a resource. <p>You can use two groupings per search each within parenthesis <code>()</code>.</p></p>', 'SearchWorkersRequest$filterExpressions' => '<p>The filter expression, <code>AND</code> or <code>OR</code>, to use when searching among a group of search strings in a resource. <p>You can use two groupings per search each within parenthesis <code>()</code>.</p></p>', ], ], 'SearchJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchJobsRequestItemOffsetInteger' => [ 'base' => NULL, 'refs' => [ 'SearchJobsRequest$itemOffset' => '<p>Defines how far into the scrollable list to start the return of results.</p>', ], ], 'SearchJobsRequestPageSizeInteger' => [ 'base' => NULL, 'refs' => [ 'SearchJobsRequest$pageSize' => '<p>Specifies the number of items per page for the resource.</p>', ], ], 'SearchJobsRequestQueueIdsList' => [ 'base' => NULL, 'refs' => [ 'SearchJobsRequest$queueIds' => '<p>The queue ID to use in the job search.</p>', ], ], 'SearchJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'SearchSortExpression' => [ 'base' => '<p>The resources to search.</p>', 'refs' => [ 'SearchSortExpressions$member' => NULL, ], ], 'SearchSortExpressions' => [ 'base' => NULL, 'refs' => [ 'SearchJobsRequest$sortExpressions' => '<p>The search terms for a resource.</p>', 'SearchStepsRequest$sortExpressions' => '<p>The search terms for a resource.</p>', 'SearchTasksRequest$sortExpressions' => '<p>The search terms for a resource.</p>', 'SearchWorkersRequest$sortExpressions' => '<p>The search terms for a resource.</p>', ], ], 'SearchStepsRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchStepsRequestItemOffsetInteger' => [ 'base' => NULL, 'refs' => [ 'SearchStepsRequest$itemOffset' => '<p>Defines how far into the scrollable list to start the return of results.</p>', ], ], 'SearchStepsRequestPageSizeInteger' => [ 'base' => NULL, 'refs' => [ 'SearchStepsRequest$pageSize' => '<p>Specifies the number of items per page for the resource.</p>', ], ], 'SearchStepsRequestQueueIdsList' => [ 'base' => NULL, 'refs' => [ 'SearchStepsRequest$queueIds' => '<p>The queue IDs in the step search.</p>', ], ], 'SearchStepsResponse' => [ 'base' => NULL, 'refs' => [], ], 'SearchTasksRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchTasksRequestItemOffsetInteger' => [ 'base' => NULL, 'refs' => [ 'SearchTasksRequest$itemOffset' => '<p>Defines how far into the scrollable list to start the return of results.</p>', ], ], 'SearchTasksRequestPageSizeInteger' => [ 'base' => NULL, 'refs' => [ 'SearchTasksRequest$pageSize' => '<p>Specifies the number of items per page for the resource.</p>', ], ], 'SearchTasksRequestQueueIdsList' => [ 'base' => NULL, 'refs' => [ 'SearchTasksRequest$queueIds' => '<p>The queue IDs to include in the search.</p>', ], ], 'SearchTasksResponse' => [ 'base' => NULL, 'refs' => [], ], 'SearchTerm' => [ 'base' => NULL, 'refs' => [ 'SearchTermFilterExpression$searchTerm' => '<p>The term to search for.</p>', ], ], 'SearchTermFilterExpression' => [ 'base' => '<p>Searches for a particular search term.</p>', 'refs' => [ 'SearchFilterExpression$searchTermFilter' => '<p>Filters by a specified search term.</p>', ], ], 'SearchWorkersRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchWorkersRequestFleetIdsList' => [ 'base' => NULL, 'refs' => [ 'SearchWorkersRequest$fleetIds' => '<p>The fleet ID of the workers to search for.</p>', ], ], 'SearchWorkersRequestItemOffsetInteger' => [ 'base' => NULL, 'refs' => [ 'SearchWorkersRequest$itemOffset' => '<p>Defines how far into the scrollable list to start the return of results.</p>', ], ], 'SearchWorkersRequestPageSizeInteger' => [ 'base' => NULL, 'refs' => [ 'SearchWorkersRequest$pageSize' => '<p>Specifies the number of items per page for the resource.</p>', ], ], 'SearchWorkersResponse' => [ 'base' => NULL, 'refs' => [], ], 'SecretAccessKey' => [ 'base' => NULL, 'refs' => [ 'AwsCredentials$secretAccessKey' => '<p>The IAM secret access key.</p>', ], ], 'SecurityGroupId' => [ 'base' => NULL, 'refs' => [ 'CreateLicenseEndpointRequestSecurityGroupIdsList$member' => NULL, 'GetLicenseEndpointResponseSecurityGroupIdsList$member' => NULL, ], ], 'ServiceManagedEc2FleetConfiguration' => [ 'base' => '<p>The configuration details for a service managed Amazon EC2 fleet.</p>', 'refs' => [ 'FleetConfiguration$serviceManagedEc2' => '<p>The service managed Amazon EC2 instances for a fleet configuration.</p>', ], ], 'ServiceManagedEc2InstanceCapabilities' => [ 'base' => '<p>The Amazon EC2 instance capabilities.</p>', 'refs' => [ 'ServiceManagedEc2FleetConfiguration$instanceCapabilities' => '<p>The Amazon EC2 instance capabilities.</p>', ], ], 'ServiceManagedEc2InstanceMarketOptions' => [ 'base' => '<p>The details of the Amazon EC2 instance market options for a service managed fleet.</p>', 'refs' => [ 'ServiceManagedEc2FleetConfiguration$instanceMarketOptions' => '<p>The Amazon EC2 market type.</p>', ], ], 'ServiceManagedFleetOperatingSystemFamily' => [ 'base' => NULL, 'refs' => [ 'ServiceManagedEc2InstanceCapabilities$osFamily' => '<p>The operating system (OS) family.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of service resources or operations for your Amazon Web Services account.</p>', 'refs' => [], ], 'ServiceQuotaExceededExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ServiceQuotaExceededException$reason' => '<p>A string that describes the reason the quota was exceeded.</p>', ], ], 'SessionActionDefinition' => [ 'base' => '<p>The definition of the session action.</p>', 'refs' => [ 'GetSessionActionResponse$definition' => '<p>The session action definition.</p>', ], ], 'SessionActionDefinitionSummary' => [ 'base' => '<p>The details of a session action definition.</p>', 'refs' => [ 'SessionActionSummary$definition' => '<p>The session action definition.</p>', ], ], 'SessionActionId' => [ 'base' => NULL, 'refs' => [ 'AssignedSessionAction$sessionActionId' => '<p>The session action ID for the assigned session.</p>', 'GetSessionActionRequest$sessionActionId' => '<p>The session action ID for the session.</p>', 'GetSessionActionResponse$sessionActionId' => '<p>The session action ID.</p>', 'GetTaskResponse$latestSessionActionId' => '<p>The latest session ID for the task.</p>', 'SessionActionIdList$member' => NULL, 'SessionActionSummary$sessionActionId' => '<p>The session action ID.</p>', 'TaskSummary$latestSessionActionId' => '<p>The latest session action for the task.</p>', 'UpdatedSessionActions$key' => NULL, ], ], 'SessionActionIdList' => [ 'base' => NULL, 'refs' => [ 'CancelSessionActions$value' => NULL, ], ], 'SessionActionProgressMessage' => [ 'base' => NULL, 'refs' => [ 'GetSessionActionResponse$progressMessage' => '<p>The message that communicates the progress of the session action.</p>', 'UpdatedSessionActionInfo$progressMessage' => '<p>A message to indicate the progress of the updated session action.</p>', ], ], 'SessionActionProgressPercent' => [ 'base' => NULL, 'refs' => [ 'GetSessionActionResponse$progressPercent' => '<p>The percentage completed for a session action.</p>', 'SessionActionSummary$progressPercent' => '<p>The completion percentage for the session action.</p>', 'UpdatedSessionActionInfo$progressPercent' => '<p>The percentage completed.</p>', ], ], 'SessionActionStatus' => [ 'base' => NULL, 'refs' => [ 'GetSessionActionResponse$status' => '<p>The status of the session action.</p>', 'SessionActionSummary$status' => '<p>The status of the session action.</p>', ], ], 'SessionActionSummaries' => [ 'base' => NULL, 'refs' => [ 'ListSessionActionsResponse$sessionActions' => '<p>The session actions.</p>', ], ], 'SessionActionSummary' => [ 'base' => '<p>The details of a session action.</p>', 'refs' => [ 'SessionActionSummaries$member' => NULL, ], ], 'SessionId' => [ 'base' => NULL, 'refs' => [ 'AssignedSessions$key' => NULL, 'CancelSessionActions$key' => NULL, 'GetSessionActionResponse$sessionId' => '<p>The session ID for the session action.</p>', 'GetSessionRequest$sessionId' => '<p>The session ID.</p>', 'GetSessionResponse$sessionId' => '<p>The session ID.</p>', 'ListSessionActionsRequest$sessionId' => '<p>The session ID to include on the sessions action list.</p>', 'SessionSummary$sessionId' => '<p>The session ID.</p>', 'UpdateSessionRequest$sessionId' => '<p>The session ID to update.</p>', 'WorkerSessionSummary$sessionId' => '<p>The session ID for the session action.</p>', ], ], 'SessionLifecycleStatus' => [ 'base' => NULL, 'refs' => [ 'GetSessionResponse$lifecycleStatus' => '<p>The life cycle status of the session.</p>', 'SessionSummary$lifecycleStatus' => '<p>The life cycle status for the session.</p>', 'WorkerSessionSummary$lifecycleStatus' => '<p>The life cycle status for the worker\'s session.</p>', ], ], 'SessionLifecycleTargetStatus' => [ 'base' => NULL, 'refs' => [ 'GetSessionResponse$targetLifecycleStatus' => '<p>The life cycle status with which the session started.</p>', 'SessionSummary$targetLifecycleStatus' => '<p>The target life cycle status for the session.</p>', 'UpdateSessionRequest$targetLifecycleStatus' => '<p>The life cycle status to update in the session.</p>', 'WorkerSessionSummary$targetLifecycleStatus' => '<p>The life cycle status </p>', ], ], 'SessionSummaries' => [ 'base' => NULL, 'refs' => [ 'ListSessionsResponse$sessions' => '<p>The sessions on the list.</p>', ], ], 'SessionSummary' => [ 'base' => '<p>The summary of a session.</p>', 'refs' => [ 'SessionSummaries$member' => NULL, ], ], 'SessionToken' => [ 'base' => NULL, 'refs' => [ 'AwsCredentials$sessionToken' => '<p>The IAM session token</p>', ], ], 'SessionsStatisticsAggregationStatus' => [ 'base' => NULL, 'refs' => [ 'GetSessionsStatisticsAggregationResponse$status' => '<p>The status of the aggregated results.</p>', ], ], 'SessionsStatisticsResources' => [ 'base' => '<p>Specifies the fleet IDs or queue IDs to return statistics. You can specify only fleet IDs or queue IDS, not both.</p>', 'refs' => [ 'StartSessionsStatisticsAggregationRequest$resourceIds' => '<p>A list of fleet IDs or queue IDs to gather statistics for.</p>', ], ], 'SessionsStatisticsResourcesFleetIdsList' => [ 'base' => NULL, 'refs' => [ 'SessionsStatisticsResources$fleetIds' => '<p>One to 10 fleet IDs that specify the fleets to return statistics for. If you specify the <code>fleetIds</code> field, you can\'t specify the <code>queueIds</code> field.</p>', ], ], 'SessionsStatisticsResourcesQueueIdsList' => [ 'base' => NULL, 'refs' => [ 'SessionsStatisticsResources$queueIds' => '<p>One to 10 queue IDs that specify the queues to return statistics for. If you specify the <code>queueIds</code> field, you can\'t specify the <code>fleetIds</code> field.</p>', ], ], 'SortOrder' => [ 'base' => NULL, 'refs' => [ 'FieldSortExpression$sortOrder' => '<p>The sort order for the field.</p>', 'ParameterSortExpression$sortOrder' => '<p>The sort order for the parameter.</p>', ], ], 'StartSessionsStatisticsAggregationRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartSessionsStatisticsAggregationResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartedAt' => [ 'base' => NULL, 'refs' => [ 'GetJobResponse$startedAt' => '<p>The date and time the resource started running.</p>', 'GetSessionActionResponse$startedAt' => '<p>The date and time the resource started running.</p>', 'GetSessionResponse$startedAt' => '<p>The date and time the resource started running.</p>', 'GetStepResponse$startedAt' => '<p>The date and time the resource started running.</p>', 'GetTaskResponse$startedAt' => '<p>The date and time the resource started running.</p>', 'JobSearchSummary$startedAt' => '<p>The date and time the resource started running.</p>', 'JobSummary$startedAt' => '<p>The date and time the resource started running.</p>', 'SessionActionSummary$startedAt' => '<p>The date and time the resource started running.</p>', 'SessionSummary$startedAt' => '<p>The date and time the resource started running.</p>', 'StepSearchSummary$startedAt' => '<p>The date and time the resource started running.</p>', 'StepSummary$startedAt' => '<p>The date and time the resource started running.</p>', 'TaskSearchSummary$startedAt' => '<p>The date and time the resource started running.</p>', 'TaskSummary$startedAt' => '<p>The date and time the resource started running.</p>', 'WorkerSessionSummary$startedAt' => '<p>The date and time the resource started running.</p>', ], ], 'StartsAt' => [ 'base' => NULL, 'refs' => [ 'FixedBudgetSchedule$startTime' => '<p>When the budget starts.</p>', ], ], 'Statistics' => [ 'base' => '<p>A list of statistics for a session.</p>', 'refs' => [ 'StatisticsList$member' => NULL, ], ], 'StatisticsList' => [ 'base' => NULL, 'refs' => [ 'GetSessionsStatisticsAggregationResponse$statistics' => '<p>The statistics for the specified fleets or queues.</p>', ], ], 'Stats' => [ 'base' => '<p>The minimum, maximum, average, and sum.</p>', 'refs' => [ 'Statistics$costInUsd' => '<p>How the statistics should appear in USD. Options include: minimum, maximum, average or sum.</p>', 'Statistics$runtimeInSeconds' => '<p>The total aggregated runtime.</p>', ], ], 'StatusMessage' => [ 'base' => NULL, 'refs' => [ 'GetLicenseEndpointResponse$statusMessage' => '<p>The status message of the license endpoint.</p>', 'LicenseEndpointSummary$statusMessage' => '<p>The status message of the license endpoint.</p>', ], ], 'StepAmountCapabilities' => [ 'base' => NULL, 'refs' => [ 'StepRequiredCapabilities$amounts' => '<p>The capability amounts that the step requires.</p>', ], ], 'StepAmountCapability' => [ 'base' => '<p>The details outlining the minimum and maximum capability of a step.</p>', 'refs' => [ 'StepAmountCapabilities$member' => NULL, ], ], 'StepAttributeCapabilities' => [ 'base' => NULL, 'refs' => [ 'StepRequiredCapabilities$attributes' => '<p>The capability attributes that the step requires.</p>', ], ], 'StepAttributeCapability' => [ 'base' => '<p>The list of step attributes.</p>', 'refs' => [ 'StepAttributeCapabilities$member' => NULL, ], ], 'StepConsumer' => [ 'base' => '<p>The details of a step consumer.</p>', 'refs' => [ 'StepConsumers$member' => NULL, ], ], 'StepConsumers' => [ 'base' => NULL, 'refs' => [ 'ListStepConsumersResponse$consumers' => '<p>The consumers on the list.</p>', ], ], 'StepDependencies' => [ 'base' => NULL, 'refs' => [ 'ListStepDependenciesResponse$dependencies' => '<p>The dependencies on the list.</p>', ], ], 'StepDependency' => [ 'base' => '<p>The details of step dependency.</p>', 'refs' => [ 'StepDependencies$member' => NULL, ], ], 'StepDescription' => [ 'base' => NULL, 'refs' => [ 'GetStepResponse$description' => '<p>The description of the step.</p>', ], ], 'StepDetailsEntity' => [ 'base' => '<p>The details of a step entity.</p>', 'refs' => [ 'JobEntity$stepDetails' => '<p>The step details.</p>', ], ], 'StepDetailsError' => [ 'base' => '<p>The details of the step error.</p>', 'refs' => [ 'GetJobEntityError$stepDetails' => '<p>The step details for the failed job entity.</p>', ], ], 'StepDetailsIdentifiers' => [ 'base' => '<p>The details of identifiers for a step.</p>', 'refs' => [ 'JobEntityIdentifiersUnion$stepDetails' => '<p>The step details.</p>', ], ], 'StepId' => [ 'base' => NULL, 'refs' => [ 'AssignedSyncInputJobAttachmentsSessionActionDefinition$stepId' => '<p>The step ID.</p>', 'AssignedTaskRunSessionActionDefinition$stepId' => '<p>The step ID.</p>', 'DependenciesList$member' => NULL, 'GetStepRequest$stepId' => '<p>The step ID.</p>', 'GetStepResponse$stepId' => '<p>The step ID.</p>', 'GetTaskRequest$stepId' => '<p>The step ID for the step connected to the task.</p>', 'ListStepConsumersRequest$stepId' => '<p>The step ID to include on the list.</p>', 'ListStepDependenciesRequest$stepId' => '<p>The step ID to include on the list.</p>', 'ListTasksRequest$stepId' => '<p>The step ID for the tasks.</p>', 'StepConsumer$stepId' => '<p>The step ID.</p>', 'StepDependency$stepId' => '<p>The step ID.</p>', 'StepDetailsEntity$stepId' => '<p>The step ID.</p>', 'StepDetailsError$stepId' => '<p>The step ID.</p>', 'StepDetailsIdentifiers$stepId' => '<p>The step ID.</p>', 'StepSearchSummary$stepId' => '<p>The step ID.</p>', 'StepSummary$stepId' => '<p>The step ID.</p>', 'SyncInputJobAttachmentsSessionActionDefinition$stepId' => '<p>The step ID for the step in the job attachment.</p>', 'SyncInputJobAttachmentsSessionActionDefinitionSummary$stepId' => '<p>The step ID of the step in the job attachment.</p>', 'TaskRunSessionActionDefinition$stepId' => '<p>The step ID.</p>', 'TaskRunSessionActionDefinitionSummary$stepId' => '<p>The step ID.</p>', 'TaskSearchSummary$stepId' => '<p>The step ID.</p>', 'UpdateStepRequest$stepId' => '<p>The step ID to update.</p>', 'UpdateTaskRequest$stepId' => '<p>The step ID to update.</p>', ], ], 'StepLifecycleStatus' => [ 'base' => NULL, 'refs' => [ 'GetStepResponse$lifecycleStatus' => '<p>The life cycle status of the step.</p>', 'StepSearchSummary$lifecycleStatus' => '<p>The life cycle status.</p>', 'StepSummary$lifecycleStatus' => '<p>The life cycle status.</p>', ], ], 'StepName' => [ 'base' => NULL, 'refs' => [ 'GetStepResponse$name' => '<p>The name of the step.</p>', 'StepSearchSummary$name' => '<p>The step name.</p>', 'StepSummary$name' => '<p>The name of the step.</p>', ], ], 'StepParameter' => [ 'base' => '<p>The details of a step parameter.</p>', 'refs' => [ 'StepParameterList$member' => NULL, ], ], 'StepParameterList' => [ 'base' => NULL, 'refs' => [ 'ParameterSpace$parameters' => '<p>The parameters to search for.</p>', ], ], 'StepParameterName' => [ 'base' => NULL, 'refs' => [ 'StepParameter$name' => '<p>The name of the parameter.</p>', ], ], 'StepParameterType' => [ 'base' => NULL, 'refs' => [ 'StepParameter$type' => '<p>The data type of the parameter.</p>', ], ], 'StepRequiredCapabilities' => [ 'base' => '<p>The details of required step capabilities.</p>', 'refs' => [ 'GetStepResponse$requiredCapabilities' => '<p>The required capabilities of the step.</p>', ], ], 'StepSearchSummaries' => [ 'base' => NULL, 'refs' => [ 'SearchStepsResponse$steps' => '<p>The steps in the search.</p>', ], ], 'StepSearchSummary' => [ 'base' => '<p>The details of a step search.</p>', 'refs' => [ 'StepSearchSummaries$member' => NULL, ], ], 'StepSummaries' => [ 'base' => NULL, 'refs' => [ 'ListStepsResponse$steps' => '<p>The steps on the list.</p>', ], ], 'StepSummary' => [ 'base' => '<p>The details for a step.</p>', 'refs' => [ 'StepSummaries$member' => NULL, ], ], 'StepTargetTaskRunStatus' => [ 'base' => NULL, 'refs' => [ 'GetStepResponse$targetTaskRunStatus' => '<p>The task status with which the job started.</p>', 'StepSearchSummary$targetTaskRunStatus' => '<p>The task status to start with on the job.</p>', 'StepSummary$targetTaskRunStatus' => '<p>The task status to start with on the job.</p>', 'UpdateStepRequest$targetTaskRunStatus' => '<p>The task status to update the step\'s tasks to.</p>', ], ], 'StorageProfileId' => [ 'base' => NULL, 'refs' => [ 'AllowedStorageProfileIds$member' => NULL, 'CreateJobRequest$storageProfileId' => '<p>The storage profile ID for the storage profile to connect to the job.</p>', 'CreateStorageProfileResponse$storageProfileId' => '<p>The storage profile ID.</p>', 'CustomerManagedFleetConfiguration$storageProfileId' => '<p>The storage profile ID.</p>', 'DeleteStorageProfileRequest$storageProfileId' => '<p>The storage profile ID of the storage profile to delete.</p>', 'GetJobResponse$storageProfileId' => '<p>The storage profile ID associated with the job.</p>', 'GetStorageProfileForQueueRequest$storageProfileId' => '<p>The storage profile ID for the storage profile in the queue.</p>', 'GetStorageProfileForQueueResponse$storageProfileId' => '<p>The storage profile ID.</p>', 'GetStorageProfileRequest$storageProfileId' => '<p>The storage profile ID.</p>', 'GetStorageProfileResponse$storageProfileId' => '<p>The storage profile ID.</p>', 'StorageProfileSummary$storageProfileId' => '<p>The storage profile ID.</p>', 'UpdateStorageProfileRequest$storageProfileId' => '<p>The storage profile ID to update.</p>', ], ], 'StorageProfileOperatingSystemFamily' => [ 'base' => NULL, 'refs' => [ 'CreateStorageProfileRequest$osFamily' => '<p>The type of operating system (OS) for the storage profile.</p>', 'GetStorageProfileForQueueResponse$osFamily' => '<p>The operating system of the storage profile in the queue.</p>', 'GetStorageProfileResponse$osFamily' => '<p>The operating system (OS) for the storage profile.</p>', 'StorageProfileSummary$osFamily' => '<p>The operating system (OS) family.</p>', 'UpdateStorageProfileRequest$osFamily' => '<p>The OS system to update.</p>', ], ], 'StorageProfileSummaries' => [ 'base' => NULL, 'refs' => [ 'ListStorageProfilesForQueueResponse$storageProfiles' => '<p>The storage profiles in the queue.</p>', 'ListStorageProfilesResponse$storageProfiles' => '<p>The storage profiles.</p>', ], ], 'StorageProfileSummary' => [ 'base' => '<p>The details of a storage profile.</p>', 'refs' => [ 'StorageProfileSummaries$member' => NULL, ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'ConflictException$message' => NULL, 'ConflictException$resourceId' => '<p>The identifier of the resource in use.</p>', 'ConflictException$resourceType' => '<p>The type of the resource in use.</p>', 'DateTimeFilterExpression$name' => '<p>The name of the date-time field to filter on.</p>', 'EnvironmentDetailsEntity$schemaVersion' => '<p>The schema version in the environment.</p>', 'EnvironmentDetailsError$message' => '<p>The error message detailing the error\'s cause.</p>', 'ExceptionContext$key' => NULL, 'ExceptionContext$value' => NULL, 'FieldSortExpression$name' => '<p>The name of the field.</p>', 'GetJobResponse$lifecycleStatusMessage' => '<p>A message that communicates the status of the life cycle for the job.</p>', 'GetSessionsStatisticsAggregationRequest$nextToken' => '<p>The token for the next set of results, or <code>null</code> to start from the beginning.</p>', 'GetSessionsStatisticsAggregationResponse$nextToken' => '<p>If Deadline Cloud returns <code>nextToken</code>, then there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the operation again using the returned token. Keep all other arguments unchanged. If no results remain, then <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours. If you provide a token that isn\'t valid, then you receive an HTTP 400 <code>ValidationException</code> error.</p>', 'GetSessionsStatisticsAggregationResponse$statusMessage' => '<p>A message that describes the status.</p>', 'GetStepResponse$lifecycleStatusMessage' => '<p>A message that describes the lifecycle status of the step.</p>', 'HostPropertiesResponse$ec2InstanceArn' => '<p>The ARN of the host EC2 instance.</p>', 'InternalServerErrorException$message' => NULL, 'JobAttachmentDetailsError$message' => '<p>The error message detailing the error\'s cause.</p>', 'JobDetailsEntity$logGroupName' => '<p>The log group name.</p>', 'JobDetailsEntity$schemaVersion' => '<p>The schema version.</p>', 'JobDetailsError$message' => '<p>The error message detailing the error\'s cause.</p>', 'JobParameters$key' => NULL, 'JobSearchSummary$lifecycleStatusMessage' => '<p>The life cycle status message.</p>', 'JobSummary$lifecycleStatusMessage' => '<p>The life cycle status message.</p>', 'ListAvailableMeteredProductsRequest$nextToken' => '<p>The token for the next set of results, or <code>null</code> to start from the beginning.</p>', 'ListAvailableMeteredProductsResponse$nextToken' => '<p>If Deadline Cloud returns <code>nextToken</code>, then there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the operation again using the returned token. Keep all other arguments unchanged. If no results remain, then <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours. If you provide a token that isn\'t valid, then you receive an HTTP 400 <code>ValidationException</code> error.</p>', 'ListBudgetsRequest$nextToken' => '<p>The token for the next set of results, or <code>null</code> to start from the beginning.</p>', 'ListBudgetsResponse$nextToken' => '<p>If Deadline Cloud returns <code>nextToken</code>, then there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the operation again using the returned token. Keep all other arguments unchanged. If no results remain, then <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours. If you provide a token that isn\'t valid, then you receive an HTTP 400 <code>ValidationException</code> error.</p>', 'ListFarmMembersRequest$nextToken' => '<p>The token for the next set of results, or <code>null</code> to start from the beginning.</p>', 'ListFarmMembersResponse$nextToken' => '<p>If Deadline Cloud returns <code>nextToken</code>, then there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the operation again using the returned token. Keep all other arguments unchanged. If no results remain, then <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours. If you provide a token that isn\'t valid, then you receive an HTTP 400 <code>ValidationException</code> error.</p>', 'ListFarmsRequest$nextToken' => '<p>The token for the next set of results, or <code>null</code> to start from the beginning.</p>', 'ListFarmsResponse$nextToken' => '<p>If Deadline Cloud returns <code>nextToken</code>, then there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the operation again using the returned token. Keep all other arguments unchanged. If no results remain, then <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours. If you provide a token that isn\'t valid, then you receive an HTTP 400 <code>ValidationException</code> error.</p>', 'ListFleetMembersRequest$nextToken' => '<p>The token for the next set of results, or <code>null</code> to start from the beginning.</p>', 'ListFleetMembersResponse$nextToken' => '<p>If Deadline Cloud returns <code>nextToken</code>, then there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the operation again using the returned token. Keep all other arguments unchanged. If no results remain, then <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours. If you provide a token that isn\'t valid, then you receive an HTTP 400 <code>ValidationException</code> error.</p>', 'ListFleetsRequest$nextToken' => '<p>The token for the next set of results, or <code>null</code> to start from the beginning.</p>', 'ListFleetsResponse$nextToken' => '<p>If Deadline Cloud returns <code>nextToken</code>, then there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the operation again using the returned token. Keep all other arguments unchanged. If no results remain, then <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours. If you provide a token that isn\'t valid, then you receive an HTTP 400 <code>ValidationException</code> error.</p>', 'ListJobMembersRequest$nextToken' => '<p>The token for the next set of results, or <code>null</code> to start from the beginning.</p>', 'ListJobMembersResponse$nextToken' => '<p>If Deadline Cloud returns <code>nextToken</code>, then there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the operation again using the returned token. Keep all other arguments unchanged. If no results remain, then <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours. If you provide a token that isn\'t valid, then you receive an HTTP 400 <code>ValidationException</code> error.</p>', 'ListJobsRequest$nextToken' => '<p>The token for the next set of results, or <code>null</code> to start from the beginning.</p>', 'ListJobsResponse$nextToken' => '<p>If Deadline Cloud returns <code>nextToken</code>, then there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the operation again using the returned token. Keep all other arguments unchanged. If no results remain, then <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours. If you provide a token that isn\'t valid, then you receive an HTTP 400 <code>ValidationException</code> error.</p>', 'ListLicenseEndpointsRequest$nextToken' => '<p>The token for the next set of results, or <code>null</code> to start from the beginning.</p>', 'ListLicenseEndpointsResponse$nextToken' => '<p>If Deadline Cloud returns <code>nextToken</code>, then there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the operation again using the returned token. Keep all other arguments unchanged. If no results remain, then <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours. If you provide a token that isn\'t valid, then you receive an HTTP 400 <code>ValidationException</code> error.</p>', 'ListMeteredProductsRequest$nextToken' => '<p>The token for the next set of results, or <code>null</code> to start from the beginning.</p>', 'ListMeteredProductsResponse$nextToken' => '<p>If Deadline Cloud returns <code>nextToken</code>, then there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the operation again using the returned token. Keep all other arguments unchanged. If no results remain, then <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours. If you provide a token that isn\'t valid, then you receive an HTTP 400 <code>ValidationException</code> error.</p>', 'ListMonitorsRequest$nextToken' => '<p>The token for the next set of results, or <code>null</code> to start from the beginning.</p>', 'ListMonitorsResponse$nextToken' => '<p>If Deadline Cloud returns <code>nextToken</code>, then there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the operation again using the returned token. Keep all other arguments unchanged. If no results remain, then <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours. If you provide a token that isn\'t valid, then you receive an HTTP 400 <code>ValidationException</code> error.</p>', 'ListQueueEnvironmentsRequest$nextToken' => '<p>The token for the next set of results, or <code>null</code> to start from the beginning.</p>', 'ListQueueEnvironmentsResponse$nextToken' => '<p>If Deadline Cloud returns <code>nextToken</code>, then there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the operation again using the returned token. Keep all other arguments unchanged. If no results remain, then <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours. If you provide a token that isn\'t valid, then you receive an HTTP 400 <code>ValidationException</code> error.</p>', 'ListQueueFleetAssociationsRequest$nextToken' => '<p>The token for the next set of results, or <code>null</code> to start from the beginning.</p>', 'ListQueueFleetAssociationsResponse$nextToken' => '<p>If Deadline Cloud returns <code>nextToken</code>, then there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the operation again using the returned token. Keep all other arguments unchanged. If no results remain, then <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours. If you provide a token that isn\'t valid, then you receive an HTTP 400 <code>ValidationException</code> error.</p>', 'ListQueueMembersRequest$nextToken' => '<p>The token for the next set of results, or <code>null</code> to start from the beginning.</p>', 'ListQueueMembersResponse$nextToken' => '<p>If Deadline Cloud returns <code>nextToken</code>, then there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the operation again using the returned token. Keep all other arguments unchanged. If no results remain, then <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours. If you provide a token that isn\'t valid, then you receive an HTTP 400 <code>ValidationException</code> error.</p>', 'ListQueuesRequest$nextToken' => '<p>The token for the next set of results, or <code>null</code> to start from the beginning.</p>', 'ListQueuesResponse$nextToken' => '<p>If Deadline Cloud returns <code>nextToken</code>, then there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the operation again using the returned token. Keep all other arguments unchanged. If no results remain, then <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours. If you provide a token that isn\'t valid, then you receive an HTTP 400 <code>ValidationException</code> error.</p>', 'ListSessionActionsRequest$nextToken' => '<p>The token for the next set of results, or <code>null</code> to start from the beginning.</p>', 'ListSessionActionsResponse$nextToken' => '<p>If Deadline Cloud returns <code>nextToken</code>, then there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the operation again using the returned token. Keep all other arguments unchanged. If no results remain, then <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours. If you provide a token that isn\'t valid, then you receive an HTTP 400 <code>ValidationException</code> error.</p>', 'ListSessionsForWorkerRequest$nextToken' => '<p>The token for the next set of results, or <code>null</code> to start from the beginning.</p>', 'ListSessionsForWorkerResponse$nextToken' => '<p>The token for the next set of results, or <code>null</code> to start from the beginning.</p>', 'ListSessionsRequest$nextToken' => '<p>The token for the next set of results, or <code>null</code> to start from the beginning.</p>', 'ListSessionsResponse$nextToken' => '<p>If Deadline Cloud returns <code>nextToken</code>, then there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the operation again using the returned token. Keep all other arguments unchanged. If no results remain, then <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours. If you provide a token that isn\'t valid, then you receive an HTTP 400 <code>ValidationException</code> error.</p>', 'ListStepConsumersRequest$nextToken' => '<p>The token for the next set of results, or <code>null</code> to start from the beginning.</p>', 'ListStepConsumersResponse$nextToken' => '<p>If Deadline Cloud returns <code>nextToken</code>, then there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the operation again using the returned token. Keep all other arguments unchanged. If no results remain, then <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours. If you provide a token that isn\'t valid, then you receive an HTTP 400 <code>ValidationException</code> error.</p>', 'ListStepDependenciesRequest$nextToken' => '<p>The token for the next set of results, or <code>null</code> to start from the beginning.</p>', 'ListStepDependenciesResponse$nextToken' => '<p>If Deadline Cloud returns <code>nextToken</code>, then there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the operation again using the returned token. Keep all other arguments unchanged. If no results remain, then <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours. If you provide a token that isn\'t valid, then you receive an HTTP 400 <code>ValidationException</code> error.</p>', 'ListStepsRequest$nextToken' => '<p>The token for the next set of results, or <code>null</code> to start from the beginning.</p>', 'ListStepsResponse$nextToken' => '<p>If Deadline Cloud returns <code>nextToken</code>, then there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the operation again using the returned token. Keep all other arguments unchanged. If no results remain, then <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours. If you provide a token that isn\'t valid, then you receive an HTTP 400 <code>ValidationException</code> error.</p>', 'ListStorageProfilesForQueueRequest$nextToken' => '<p>The token for the next set of results, or <code>null</code> to start from the beginning.</p>', 'ListStorageProfilesForQueueResponse$nextToken' => '<p>If Deadline Cloud returns <code>nextToken</code>, then there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the operation again using the returned token. Keep all other arguments unchanged. If no results remain, then <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours. If you provide a token that isn\'t valid, then you receive an HTTP 400 <code>ValidationException</code> error.</p>', 'ListStorageProfilesRequest$nextToken' => '<p>The token for the next set of results, or <code>null</code> to start from the beginning.</p>', 'ListStorageProfilesResponse$nextToken' => '<p>If Deadline Cloud returns <code>nextToken</code>, then there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the operation again using the returned token. Keep all other arguments unchanged. If no results remain, then <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours. If you provide a token that isn\'t valid, then you receive an HTTP 400 <code>ValidationException</code> error.</p>', 'ListTagsForResourceRequest$resourceArn' => '<p>The resource ARN to list tags for.</p>', 'ListTasksRequest$nextToken' => '<p>The token for the next set of results, or <code>null</code> to start from the beginning.</p>', 'ListTasksResponse$nextToken' => '<p>If Deadline Cloud returns <code>nextToken</code>, then there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the operation again using the returned token. Keep all other arguments unchanged. If no results remain, then <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours. If you provide a token that isn\'t valid, then you receive an HTTP 400 <code>ValidationException</code> error.</p>', 'ListWorkersRequest$nextToken' => '<p>The token for the next set of results, or <code>null</code> to start from the beginning.</p>', 'ListWorkersResponse$nextToken' => '<p>If Deadline Cloud returns <code>nextToken</code>, then there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the operation again using the returned token. Keep all other arguments unchanged. If no results remain, then <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours. If you provide a token that isn\'t valid, then you receive an HTTP 400 <code>ValidationException</code> error.</p>', 'LogOptions$key' => NULL, 'LogOptions$value' => NULL, 'LogParameters$key' => NULL, 'LogParameters$value' => NULL, 'ParameterFilterExpression$name' => '<p>The name of the parameter to filter on.</p>', 'ParameterSortExpression$name' => '<p>The parameter name to sort by.</p>', 'PathMappingRule$destinationPath' => '<p>The destination path.</p>', 'PathMappingRule$sourcePath' => '<p>The source path.</p>', 'ResourceNotFoundException$message' => NULL, 'ResourceNotFoundException$resourceId' => '<p>The identifier of the resource that couldn\'t be found.</p>', 'ResourceNotFoundException$resourceType' => '<p>The type of the resource that couldn\'t be found.</p>', 'ServiceQuotaExceededException$message' => NULL, 'ServiceQuotaExceededException$quotaCode' => '<p>Identifies the quota that has been exceeded.</p>', 'ServiceQuotaExceededException$resourceId' => '<p>The identifier of the affected resource.</p>', 'ServiceQuotaExceededException$resourceType' => '<p>The type of the affected resource</p>', 'ServiceQuotaExceededException$serviceCode' => '<p>Identifies the service that exceeded the quota.</p>', 'StepDetailsEntity$schemaVersion' => '<p>The schema version for a step template.</p>', 'StepDetailsError$message' => '<p>The error message detailing the error\'s cause.</p>', 'StepSearchSummary$lifecycleStatusMessage' => '<p>The life cycle status message.</p>', 'StepSummary$lifecycleStatusMessage' => '<p>A message that describes the lifecycle of the step.</p>', 'StringFilterExpression$name' => '<p>The field name to search.</p>', 'StringList$member' => NULL, 'TagResourceRequest$resourceArn' => '<p>The ARN of the resource to apply tags to.</p>', 'Tags$key' => NULL, 'Tags$value' => NULL, 'TaskParameters$key' => NULL, 'ThrottlingException$message' => NULL, 'ThrottlingException$quotaCode' => '<p>Identifies the quota that is being throttled.</p>', 'ThrottlingException$serviceCode' => '<p>Identifies the service that is being throttled.</p>', 'UntagResourceRequest$resourceArn' => '<p>The ARN of the resource to remove the tag from.</p>', 'UserJobsFirst$userIdentityId' => '<p>The user\'s ID.</p>', 'ValidationException$message' => NULL, 'ValidationExceptionField$message' => '<p>The error message for the validation exception.</p>', 'ValidationExceptionField$name' => '<p>The name of the validation exception.</p>', ], ], 'StringFilter' => [ 'base' => NULL, 'refs' => [ 'StringFilterExpression$value' => '<p>The string to search for.</p>', ], ], 'StringFilterExpression' => [ 'base' => '<p>Searches for a particular string.</p>', 'refs' => [ 'SearchFilterExpression$stringFilter' => '<p>Filters by a string.</p>', ], ], 'StringList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>They keys of the tag.</p>', ], ], 'Subdomain' => [ 'base' => NULL, 'refs' => [ 'CreateMonitorRequest$subdomain' => '<p>The subdomain to use when creating the monitor URL. The full URL of the monitor is subdomain.Region.deadlinecloud.amazonaws.com.</p>', 'GetMonitorResponse$subdomain' => '<p>The subdomain used for the monitor URL. The full URL of the monitor is subdomain.Region.deadlinecloud.amazonaws.com.</p>', 'MonitorSummary$subdomain' => '<p>The subdomain used for the monitor URL. The full URL of the monitor is subdomain.Region.deadlinecloud.amazonaws.com.</p>', 'UpdateMonitorRequest$subdomain' => '<p>The new value of the subdomain to use when forming the monitor URL.</p>', ], ], 'SubnetId' => [ 'base' => NULL, 'refs' => [ 'CreateLicenseEndpointRequestSubnetIdsList$member' => NULL, 'GetLicenseEndpointResponseSubnetIdsList$member' => NULL, ], ], 'SyncInputJobAttachmentsSessionActionDefinition' => [ 'base' => '<p>The job attachment in a session action to sync.</p>', 'refs' => [ 'SessionActionDefinition$syncInputJobAttachments' => '<p>The job attachments to sync with a session action.</p>', ], ], 'SyncInputJobAttachmentsSessionActionDefinitionSummary' => [ 'base' => '<p>The details of a synced job attachment.</p>', 'refs' => [ 'SessionActionDefinitionSummary$syncInputJobAttachments' => '<p>The job attachments to sync with the session action definition.</p>', ], ], 'SyntheticTimestamp_date_time' => [ 'base' => NULL, 'refs' => [ 'AwsCredentials$expiration' => '<p>The expiration date and time of the IAM credentials.</p>', 'DateTimeFilterExpression$dateTime' => '<p>The date and time.</p>', 'StartSessionsStatisticsAggregationRequest$endTime' => '<p>The Linux timestamp of the date and time that the statistics end.</p>', 'StartSessionsStatisticsAggregationRequest$startTime' => '<p>The Linux timestamp of the date and time that the statistics start.</p>', 'Statistics$aggregationEndTime' => '<p>The end time for the aggregation.</p>', 'Statistics$aggregationStartTime' => '<p>The start time for the aggregation.</p>', 'UpdatedSessionActionInfo$endedAt' => '<p>The date and time the resource ended running.</p>', 'UpdatedSessionActionInfo$startedAt' => '<p>The date and time the resource started running.</p>', 'UpdatedSessionActionInfo$updatedAt' => '<p>The updated time.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'Tags' => [ 'base' => NULL, 'refs' => [ 'CreateFarmRequest$tags' => '<p>The tags to add to your farm. Each tag consists of a tag key and a tag value. Tag keys and values are both required, but tag values can be empty strings.</p>', 'CreateFleetRequest$tags' => '<p>Each tag consists of a tag key and a tag value. Tag keys and values are both required, but tag values can be empty strings.</p>', 'CreateLicenseEndpointRequest$tags' => '<p>Each tag consists of a tag key and a tag value. Tag keys and values are both required, but tag values can be empty strings.</p>', 'CreateQueueRequest$tags' => '<p>Each tag consists of a tag key and a tag value. Tag keys and values are both required, but tag values can be empty strings.</p>', 'ListTagsForResourceResponse$tags' => '<p>Each tag consists of a tag key and a tag value. Tag keys and values are both required, but tag values can be empty strings.</p>', 'TagResourceRequest$tags' => '<p>Each tag consists of a tag key and a tag value. Tag keys and values are both required, but tag values can be empty strings.</p>', ], ], 'TaskId' => [ 'base' => NULL, 'refs' => [ 'AssignedTaskRunSessionActionDefinition$taskId' => '<p>The task ID.</p>', 'GetTaskRequest$taskId' => '<p>The task ID.</p>', 'GetTaskResponse$taskId' => '<p>The task ID.</p>', 'ListSessionActionsRequest$taskId' => '<p>The task ID for the session actions list.</p>', 'TaskRunSessionActionDefinition$taskId' => '<p>The task ID.</p>', 'TaskRunSessionActionDefinitionSummary$taskId' => '<p>The task ID.</p>', 'TaskSearchSummary$taskId' => '<p>The task ID.</p>', 'TaskSummary$taskId' => '<p>The task ID.</p>', 'UpdateTaskRequest$taskId' => '<p>The task ID to update.</p>', ], ], 'TaskParameterValue' => [ 'base' => '<p>The data types for the task parameters.</p>', 'refs' => [ 'TaskParameters$value' => NULL, ], ], 'TaskParameters' => [ 'base' => NULL, 'refs' => [ 'AssignedTaskRunSessionActionDefinition$parameters' => '<p>The parameters to include.</p>', 'GetTaskResponse$parameters' => '<p>The parameters for the task.</p>', 'TaskRunSessionActionDefinition$parameters' => '<p>The task parameters.</p>', 'TaskSearchSummary$parameters' => '<p>The parameters to search for.</p>', 'TaskSummary$parameters' => '<p>The task parameters.</p>', ], ], 'TaskRetryCount' => [ 'base' => NULL, 'refs' => [ 'GetTaskResponse$failureRetryCount' => '<p>The number of times that the task failed and was retried.</p>', 'TaskSearchSummary$failureRetryCount' => '<p>The number of times that the task failed and was retried.</p>', 'TaskSummary$failureRetryCount' => '<p>The number of times that the task failed and was retried.</p>', ], ], 'TaskRunSessionActionDefinition' => [ 'base' => '<p>The task, step, and parameters for the task run in the session action.</p>', 'refs' => [ 'SessionActionDefinition$taskRun' => '<p>The task run in the session.</p>', ], ], 'TaskRunSessionActionDefinitionSummary' => [ 'base' => '<p>The details of a task run in a session action.</p>', 'refs' => [ 'SessionActionDefinitionSummary$taskRun' => '<p>The task run.</p>', ], ], 'TaskRunStatus' => [ 'base' => NULL, 'refs' => [ 'GetJobResponse$taskRunStatus' => '<p>The task run status for the job.</p>', 'GetStepResponse$taskRunStatus' => '<p>The task run status for the job.</p>', 'GetTaskResponse$runStatus' => '<p>The run status for the task.</p>', 'JobSearchSummary$taskRunStatus' => '<p>task run status for the job.</p> <ul> <li> <p> <code>PENDING</code>–pending and waiting for resources.</p> </li> <li> <p> <code>READY</code>–ready to be processed.</p> </li> <li> <p> <code>ASSIGNED</code>–assigned and will run next on a worker.</p> </li> <li> <p> <code>SCHEDULED</code>–scheduled to be run on a worker.</p> </li> <li> <p> <code>INTERRUPTING</code>–being interrupted.</p> </li> <li> <p> <code>RUNNING</code>–running on a worker.</p> </li> <li> <p> <code>SUSPENDED</code>–the task is suspended.</p> </li> <li> <p> <code>CANCELED</code>–the task has been canceled.</p> </li> <li> <p> <code>FAILED</code>–the task has failed.</p> </li> <li> <p> <code>SUCCEEDED</code>–the task has succeeded.</p> </li> </ul>', 'JobSummary$taskRunStatus' => '<p>The task run status for the job.</p> <ul> <li> <p> <code>PENDING</code>–pending and waiting for resources.</p> </li> <li> <p> <code>READY</code>–ready to be processed.</p> </li> <li> <p> <code>ASSIGNED</code>–assigned and will run next on a worker.</p> </li> <li> <p> <code>SCHEDULED</code>–scheduled to be run on a worker.</p> </li> <li> <p> <code>INTERRUPTING</code>–being interrupted.</p> </li> <li> <p> <code>RUNNING</code>–running on a worker.</p> </li> <li> <p> <code>SUSPENDED</code>–the task is suspended.</p> </li> <li> <p> <code>CANCELED</code>–the task has been canceled.</p> </li> <li> <p> <code>FAILED</code>–the task has failed.</p> </li> <li> <p> <code>SUCCEEDED</code>–the task has succeeded.</p> </li> </ul>', 'StepSearchSummary$taskRunStatus' => '<p>The task run status for the job.</p> <ul> <li> <p> <code>PENDING</code>–pending and waiting for resources.</p> </li> <li> <p> <code>READY</code>–ready to be processed.</p> </li> <li> <p> <code>ASSIGNED</code>–assigned and will run next on a worker.</p> </li> <li> <p> <code>SCHEDULED</code>–scheduled to be run on a worker.</p> </li> <li> <p> <code>INTERRUPTING</code>–being interrupted.</p> </li> <li> <p> <code>RUNNING</code>–running on a worker.</p> </li> <li> <p> <code>SUSPENDED</code>–the task is suspended.</p> </li> <li> <p> <code>CANCELED</code>–the task has been canceled.</p> </li> <li> <p> <code>FAILED</code>–the task has failed.</p> </li> <li> <p> <code>SUCCEEDED</code>–the task has succeeded.</p> </li> </ul>', 'StepSummary$taskRunStatus' => '<p>The task run status for the job.</p> <ul> <li> <p> <code>PENDING</code>–pending and waiting for resources.</p> </li> <li> <p> <code>READY</code>–ready to process.</p> </li> <li> <p> <code>ASSIGNED</code>–assigned and will run next on a worker.</p> </li> <li> <p> <code>SCHEDULED</code>–scheduled to run on a worker.</p> </li> <li> <p> <code>INTERRUPTING</code>–being interrupted.</p> </li> <li> <p> <code>RUNNING</code>–running on a worker.</p> </li> <li> <p> <code>SUSPENDED</code>–the task is suspended.</p> </li> <li> <p> <code>CANCELED</code>–the task has been canceled.</p> </li> <li> <p> <code>FAILED</code>–the task has failed.</p> </li> <li> <p> <code>SUCCEEDED</code>–the task has succeeded.</p> </li> </ul>', 'TaskRunStatusCounts$key' => NULL, 'TaskSearchSummary$runStatus' => '<p>The run status of the task.</p>', 'TaskSummary$runStatus' => '<p>The run status of the task.</p>', ], ], 'TaskRunStatusCounts' => [ 'base' => NULL, 'refs' => [ 'GetJobResponse$taskRunStatusCounts' => '<p>The number of tasks running on the job.</p>', 'GetStepResponse$taskRunStatusCounts' => '<p>The number of tasks running on the job.</p>', 'JobSearchSummary$taskRunStatusCounts' => '<p>The number of tasks running on the job.</p>', 'JobSummary$taskRunStatusCounts' => '<p>The number of tasks running on the job.</p>', 'StepSearchSummary$taskRunStatusCounts' => '<p>The number of tasks running on the job.</p>', 'StepSummary$taskRunStatusCounts' => '<p>The number of tasks running on the job.</p>', ], ], 'TaskSearchSummaries' => [ 'base' => NULL, 'refs' => [ 'SearchTasksResponse$tasks' => '<p>Tasks in the search.</p>', ], ], 'TaskSearchSummary' => [ 'base' => '<p>The details of a task search.</p>', 'refs' => [ 'TaskSearchSummaries$member' => NULL, ], ], 'TaskSummaries' => [ 'base' => NULL, 'refs' => [ 'ListTasksResponse$tasks' => '<p>Tasks for the job.</p>', ], ], 'TaskSummary' => [ 'base' => '<p>The details of a task.</p>', 'refs' => [ 'TaskSummaries$member' => NULL, ], ], 'TaskTargetRunStatus' => [ 'base' => NULL, 'refs' => [ 'GetTaskResponse$targetRunStatus' => '<p>The run status with which to start the task.</p>', 'TaskSearchSummary$targetRunStatus' => '<p>The run status that the task is being updated to.</p>', 'TaskSummary$targetRunStatus' => '<p>The run status on which the started.</p>', 'UpdateTaskRequest$targetRunStatus' => '<p>The run status with which to start the task.</p>', ], ], 'ThresholdPercentage' => [ 'base' => NULL, 'refs' => [ 'BudgetActionToAdd$thresholdPercentage' => '<p>The percentage threshold for the budget action to add.</p>', 'BudgetActionToRemove$thresholdPercentage' => '<p>The percentage threshold for the budget action to remove.</p>', 'ResponseBudgetAction$thresholdPercentage' => '<p>The percentage threshold for the budget.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>Your request exceeded a request rate quota.</p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'GetSessionActionResponse$workerUpdatedAt' => '<p>The Linux timestamp of the date and time the session action was last updated.</p>', 'SessionActionSummary$workerUpdatedAt' => '<p>The Linux timestamp of the last date and time that the session action was updated.</p>', ], ], 'Timezone' => [ 'base' => NULL, 'refs' => [ 'StartSessionsStatisticsAggregationRequest$timezone' => '<p>The timezone to use for the statistics. Use UTC notation such as "UTC+8."</p>', ], ], 'TotalResults' => [ 'base' => NULL, 'refs' => [ 'SearchJobsResponse$totalResults' => '<p>The total number of results in the search.</p>', 'SearchStepsResponse$totalResults' => '<p>The total number of results in the search.</p>', 'SearchTasksResponse$totalResults' => '<p>The total number of results in the search.</p>', 'SearchWorkersResponse$totalResults' => '<p>The total number of results in the search.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateBudgetRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateBudgetResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFarmRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFarmResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFleetRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFleetResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateJobLifecycleStatus' => [ 'base' => NULL, 'refs' => [ 'UpdateJobRequest$lifecycleStatus' => '<p>The status of a job in its lifecycle.</p>', ], ], 'UpdateJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMonitorRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMonitorResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateQueueEnvironmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateQueueEnvironmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateQueueFleetAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateQueueFleetAssociationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateQueueFleetAssociationStatus' => [ 'base' => NULL, 'refs' => [ 'UpdateQueueFleetAssociationRequest$status' => '<p>The status to update.</p>', ], ], 'UpdateQueueRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateQueueResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSessionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSessionResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateStepRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateStepResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateStorageProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateStorageProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTaskResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWorkerRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWorkerResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWorkerScheduleInterval' => [ 'base' => NULL, 'refs' => [ 'UpdateWorkerScheduleResponse$updateIntervalSeconds' => '<p>Updates the time interval (in seconds) for the schedule.</p>', ], ], 'UpdateWorkerScheduleRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWorkerScheduleResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdatedAt' => [ 'base' => NULL, 'refs' => [ 'BudgetSummary$updatedAt' => '<p>The date and time the resource was updated.</p>', 'FarmSummary$updatedAt' => '<p>The date and time the resource was updated.</p>', 'FleetSummary$updatedAt' => '<p>The date and time the resource was updated.</p>', 'GetBudgetResponse$queueStoppedAt' => '<p>The date and time the queue stopped.</p>', 'GetBudgetResponse$updatedAt' => '<p>The date and time the resource was updated.</p>', 'GetFarmResponse$updatedAt' => '<p>The date and time the resource was updated.</p>', 'GetFleetResponse$updatedAt' => '<p>The date and time the resource was updated.</p>', 'GetJobResponse$updatedAt' => '<p>The date and time the resource was updated.</p>', 'GetMonitorResponse$updatedAt' => '<p>The UNIX timestamp of the last date and time that the monitor was updated.</p>', 'GetQueueEnvironmentResponse$updatedAt' => '<p>The date and time the resource was updated.</p>', 'GetQueueFleetAssociationResponse$updatedAt' => '<p>The date and time the resource was updated.</p>', 'GetQueueResponse$updatedAt' => '<p>The date and time the resource was updated.</p>', 'GetSessionResponse$updatedAt' => '<p>The date and time the resource was updated.</p>', 'GetStepResponse$updatedAt' => '<p>The date and time the resource was updated.</p>', 'GetStorageProfileResponse$updatedAt' => '<p>The date and time the resource was updated.</p>', 'GetTaskResponse$updatedAt' => '<p>The date and time the resource was updated.</p>', 'GetWorkerResponse$updatedAt' => '<p>The date and time the resource was updated.</p>', 'JobSummary$updatedAt' => '<p>The date and time the resource was updated.</p>', 'MonitorSummary$updatedAt' => '<p>The UNIX timestamp of the date and time that the monitor was last updated.</p>', 'QueueFleetAssociationSummary$updatedAt' => '<p>The date and time the resource was updated.</p>', 'QueueSummary$updatedAt' => '<p>The date and time the resource was updated.</p>', 'SessionSummary$updatedAt' => '<p>The date and time the resource was updated.</p>', 'StepSummary$updatedAt' => '<p>The date and time the resource was updated.</p>', 'TaskSummary$updatedAt' => '<p>The date and time the resource was updated.</p>', 'WorkerSearchSummary$updatedAt' => '<p>The date and time the resource was updated.</p>', 'WorkerSummary$updatedAt' => '<p>The date and time the resource was updated.</p>', ], ], 'UpdatedBy' => [ 'base' => NULL, 'refs' => [ 'BudgetSummary$updatedBy' => '<p>The user or system that updated this resource.</p>', 'FarmSummary$updatedBy' => '<p>The user or system that updated this resource.</p>', 'FleetSummary$updatedBy' => '<p>The user or system that updated this resource.</p>', 'GetBudgetResponse$updatedBy' => '<p>The user or system that updated this resource.</p>', 'GetFarmResponse$updatedBy' => '<p>The user or system that updated this resource.</p>', 'GetFleetResponse$updatedBy' => '<p>The user or system that updated this resource.</p>', 'GetJobResponse$updatedBy' => '<p>The user or system that updated this resource.</p>', 'GetMonitorResponse$updatedBy' => '<p>The user name of the person that last updated the monitor.</p>', 'GetQueueEnvironmentResponse$updatedBy' => '<p>The user or system that updated this resource.</p>', 'GetQueueFleetAssociationResponse$updatedBy' => '<p>The user or system that updated this resource.</p>', 'GetQueueResponse$updatedBy' => '<p>The user or system that updated this resource.</p>', 'GetSessionResponse$updatedBy' => '<p>The user or system that updated this resource.</p>', 'GetStepResponse$updatedBy' => '<p>The user or system that updated this resource.</p>', 'GetStorageProfileResponse$updatedBy' => '<p>The user or system that updated this resource.</p>', 'GetTaskResponse$updatedBy' => '<p>The user or system that updated this resource.</p>', 'GetWorkerResponse$updatedBy' => '<p>The user or system that updated this resource.</p>', 'JobSummary$updatedBy' => '<p>The user or system that updated this resource.</p>', 'MonitorSummary$updatedBy' => '<p>The user name of the person that last updated the monitor.</p>', 'QueueFleetAssociationSummary$updatedBy' => '<p>The user or system that updated this resource.</p>', 'QueueSummary$updatedBy' => '<p>The user or system that updated this resource.</p>', 'SessionSummary$updatedBy' => '<p>The user or system that updated this resource.</p>', 'StepSummary$updatedBy' => '<p>The user or system that updated this resource.</p>', 'TaskSummary$updatedBy' => '<p>The user or system that updated this resource.</p>', 'WorkerSearchSummary$updatedBy' => '<p>The user or system that updated this resource.</p>', 'WorkerSummary$updatedBy' => '<p>The user or system that updated this resource.</p>', ], ], 'UpdatedSessionActionInfo' => [ 'base' => '<p>The updated session action information as it relates to completion and progress of the session.</p>', 'refs' => [ 'UpdatedSessionActions$value' => NULL, ], ], 'UpdatedSessionActions' => [ 'base' => NULL, 'refs' => [ 'UpdateWorkerScheduleRequest$updatedSessionActions' => '<p>The session actions associated with the worker schedule to update.</p>', ], ], 'UpdatedWorkerStatus' => [ 'base' => NULL, 'refs' => [ 'UpdateWorkerRequest$status' => '<p>The worker status to update.</p>', ], ], 'Url' => [ 'base' => NULL, 'refs' => [ 'GetMonitorResponse$url' => '<p>The complete URL of the monitor. The full URL of the monitor is subdomain.Region.deadlinecloud.amazonaws.com.</p>', 'MonitorSummary$url' => '<p>The complete URL of the monitor. The full URL of the monitor is subdomain.Region.deadlinecloud.amazonaws.com.</p>', ], ], 'UsageGroupBy' => [ 'base' => NULL, 'refs' => [ 'StartSessionsStatisticsAggregationRequest$groupBy' => '<p>The field to use to group the statistics.</p>', ], ], 'UsageGroupByField' => [ 'base' => NULL, 'refs' => [ 'UsageGroupBy$member' => NULL, ], ], 'UsageStatistic' => [ 'base' => NULL, 'refs' => [ 'UsageStatistics$member' => NULL, ], ], 'UsageStatistics' => [ 'base' => NULL, 'refs' => [ 'StartSessionsStatisticsAggregationRequest$statistics' => '<p>One to four statistics to return.</p>', ], ], 'UsageTrackingResource' => [ 'base' => '<p>The usage details of the allotted budget.</p>', 'refs' => [ 'BudgetSummary$usageTrackingResource' => '<p>The resource used to track expenditure in the budget.</p>', 'CreateBudgetRequest$usageTrackingResource' => '<p>The queue ID provided to this budget to track usage.</p>', 'GetBudgetResponse$usageTrackingResource' => '<p>The resource that the budget is tracking usage for.</p>', ], ], 'UsageType' => [ 'base' => NULL, 'refs' => [ 'Statistics$usageType' => '<p>The type of usage for the statistics.</p>', ], ], 'UserId' => [ 'base' => NULL, 'refs' => [ 'Statistics$userId' => '<p>The user ID.</p>', ], ], 'UserJobsFirst' => [ 'base' => '<p>Allows setting a specific user\'s job to run first.</p>', 'refs' => [ 'SearchSortExpression$userJobsFirst' => '<p>Options for sorting a particular user\'s jobs first.</p>', ], ], 'VCpuCountRange' => [ 'base' => '<p>The allowable range of vCPU processing power for the fleet.</p>', 'refs' => [ 'CustomerManagedWorkerCapabilities$vCpuCount' => '<p>The vCPU count for the customer manged worker capabilities.</p>', 'ServiceManagedEc2InstanceCapabilities$vCpuCount' => '<p>The amount of vCPU to require for instances in this fleet.</p>', ], ], 'ValidationException' => [ 'base' => '<p>The request isn\'t valid. This can occur if your request contains malformed JSON or unsupported characters.</p>', 'refs' => [], ], 'ValidationExceptionField' => [ 'base' => '<p>The details of a validation exception.</p>', 'refs' => [ 'ValidationExceptionFieldList$member' => NULL, ], ], 'ValidationExceptionFieldList' => [ 'base' => NULL, 'refs' => [ 'ValidationException$fieldList' => '<p>A list of fields that failed validation.</p>', ], ], 'ValidationExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ValidationException$reason' => '<p>The reason that the request failed validation.</p>', ], ], 'VpcId' => [ 'base' => NULL, 'refs' => [ 'CreateLicenseEndpointRequest$vpcId' => '<p>The VPC (virtual private cloud) ID to use with the license endpoint.</p>', 'GetLicenseEndpointResponse$vpcId' => '<p>The VCP(virtual private cloud) ID associated with the license endpoint.</p>', 'LicenseEndpointSummary$vpcId' => '<p>The VCP(virtual private cloud) ID associated with the license endpoint.</p>', ], ], 'WindowsUser' => [ 'base' => '<p>The Windows user details.</p>', 'refs' => [ 'JobRunAsUser$windows' => '<p>Identifies a Microsoft Windows user.</p>', ], ], 'WindowsUserPasswordArnString' => [ 'base' => NULL, 'refs' => [ 'WindowsUser$passwordArn' => '<p>The password ARN for the Windows user.</p>', ], ], 'WindowsUserUserString' => [ 'base' => NULL, 'refs' => [ 'WindowsUser$user' => '<p>The user.</p>', ], ], 'WorkerAmountCapability' => [ 'base' => '<p>The details of the worker amount capability.</p>', 'refs' => [ 'WorkerAmountCapabilityList$member' => NULL, ], ], 'WorkerAmountCapabilityList' => [ 'base' => NULL, 'refs' => [ 'WorkerCapabilities$amounts' => '<p>The worker capabilities amounts on a list of worker capabilities.</p>', ], ], 'WorkerAttributeCapability' => [ 'base' => '<p>The details of the worker attribute capability.</p>', 'refs' => [ 'WorkerAttributeCapabilityList$member' => NULL, ], ], 'WorkerAttributeCapabilityList' => [ 'base' => NULL, 'refs' => [ 'WorkerCapabilities$attributes' => '<p>The worker attribute capabilities in the list of attribute capabilities.</p>', ], ], 'WorkerCapabilities' => [ 'base' => '<p>The details for worker capabilities.</p>', 'refs' => [ 'UpdateWorkerRequest$capabilities' => '<p>The worker capabilities to update.</p>', ], ], 'WorkerId' => [ 'base' => NULL, 'refs' => [ 'AssumeFleetRoleForWorkerRequest$workerId' => '<p>The ID of the worker assuming the fleet role.</p>', 'AssumeQueueRoleForWorkerRequest$workerId' => '<p>The worker ID of the worker assuming the queue role.</p>', 'BatchGetJobEntityRequest$workerId' => '<p>The worker ID of the worker containing the job details to get.</p>', 'CreateWorkerResponse$workerId' => '<p>The worker ID.</p>', 'DeleteWorkerRequest$workerId' => '<p>The worker ID of the worker to delete.</p>', 'GetSessionResponse$workerId' => '<p>The worker ID for the session.</p>', 'GetWorkerRequest$workerId' => '<p>The worker ID.</p>', 'GetWorkerResponse$workerId' => '<p>The worker ID.</p>', 'ListSessionsForWorkerRequest$workerId' => '<p>The worker ID for the session.</p>', 'SessionSummary$workerId' => '<p>The worker ID.</p>', 'UpdateWorkerRequest$workerId' => '<p>The worker ID to update.</p>', 'UpdateWorkerScheduleRequest$workerId' => '<p>The worker ID to update.</p>', 'WorkerSearchSummary$workerId' => '<p>The worker ID.</p>', 'WorkerSummary$workerId' => '<p>The worker ID.</p>', ], ], 'WorkerSearchSummaries' => [ 'base' => NULL, 'refs' => [ 'SearchWorkersResponse$workers' => '<p>The workers for the search.</p>', ], ], 'WorkerSearchSummary' => [ 'base' => '<p>The details of a worker search.</p>', 'refs' => [ 'WorkerSearchSummaries$member' => NULL, ], ], 'WorkerSessionSummary' => [ 'base' => '<p>Summarizes the session for a particular worker.</p>', 'refs' => [ 'ListSessionsForWorkerSummaries$member' => NULL, ], ], 'WorkerStatus' => [ 'base' => NULL, 'refs' => [ 'GetWorkerResponse$status' => '<p>The status of the worker.</p>', 'WorkerSearchSummary$status' => '<p>The status of the worker search.</p>', 'WorkerSummary$status' => '<p>The status of the worker.</p>', ], ], 'WorkerSummaries' => [ 'base' => NULL, 'refs' => [ 'ListWorkersResponse$workers' => '<p>The workers on the list.</p>', ], ], 'WorkerSummary' => [ 'base' => '<p>The summary of details for a worker.</p>', 'refs' => [ 'WorkerSummaries$member' => NULL, ], ], ],];
