<?php
// This file was auto-generated from sdk-root/src/data/detective/2018-10-26/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Detective uses machine learning and purpose-built visualizations to help you to analyze and investigate security issues across your Amazon Web Services (Amazon Web Services) workloads. Detective automatically extracts time-based events such as login attempts, API calls, and network traffic from CloudTrail and Amazon Virtual Private Cloud (Amazon VPC) flow logs. It also extracts findings detected by Amazon GuardDuty.</p> <p>The Detective API primarily supports the creation and management of behavior graphs. A behavior graph contains the extracted data from a set of member accounts, and is created and managed by an administrator account.</p> <p>To add a member account to the behavior graph, the administrator account sends an invitation to the account. When the account accepts the invitation, it becomes a member account in the behavior graph.</p> <p>Detective is also integrated with Organizations. The organization management account designates the Detective administrator account for the organization. That account becomes the administrator account for the organization behavior graph. The Detective administrator account is also the delegated administrator account for Detective in Organizations.</p> <p>The Detective administrator account can enable any organization account as a member account in the organization behavior graph. The organization accounts do not receive invitations. The Detective administrator account can also invite other accounts to the organization behavior graph.</p> <p>Every behavior graph is specific to a Region. You can only use the API to manage behavior graphs that belong to the Region that is associated with the currently selected endpoint.</p> <p>The administrator account for a behavior graph can use the Detective API to do the following:</p> <ul> <li> <p>Enable and disable Detective. Enabling Detective creates a new behavior graph.</p> </li> <li> <p>View the list of member accounts in a behavior graph.</p> </li> <li> <p>Add member accounts to a behavior graph.</p> </li> <li> <p>Remove member accounts from a behavior graph.</p> </li> <li> <p>Apply tags to a behavior graph.</p> </li> </ul> <p>The organization management account can use the Detective API to select the delegated administrator for Detective.</p> <p>The Detective administrator account for an organization can use the Detective API to do the following:</p> <ul> <li> <p>Perform all of the functions of an administrator account.</p> </li> <li> <p>Determine whether to automatically enable new organization accounts as member accounts in the organization behavior graph.</p> </li> </ul> <p>An invited member account can use the Detective API to do the following:</p> <ul> <li> <p>View the list of behavior graphs that they are invited to.</p> </li> <li> <p>Accept an invitation to contribute to a behavior graph.</p> </li> <li> <p>Decline an invitation to contribute to a behavior graph.</p> </li> <li> <p>Remove their account from a behavior graph.</p> </li> </ul> <p>All API actions are logged as CloudTrail events. See <a href="https://docs.aws.amazon.com/detective/latest/adminguide/logging-using-cloudtrail.html">Logging Detective API Calls with CloudTrail</a>.</p> <note> <p>We replaced the term "master account" with the term "administrator account". An administrator account is used to centrally manage multiple accounts. In the case of Detective, the administrator account manages the accounts in their behavior graph.</p> </note>', 'operations' => [ 'AcceptInvitation' => '<p>Accepts an invitation for the member account to contribute data to a behavior graph. This operation can only be called by an invited member account. </p> <p>The request provides the ARN of behavior graph.</p> <p>The member account status in the graph must be <code>INVITED</code>.</p>', 'BatchGetGraphMemberDatasources' => '<p>Gets data source package information for the behavior graph.</p>', 'BatchGetMembershipDatasources' => '<p>Gets information on the data source package history for an account.</p>', 'CreateGraph' => '<p>Creates a new behavior graph for the calling account, and sets that account as the administrator account. This operation is called by the account that is enabling Detective.</p> <p>The operation also enables Detective for the calling account in the currently selected Region. It returns the ARN of the new behavior graph.</p> <p> <code>CreateGraph</code> triggers a process to create the corresponding data tables for the new behavior graph.</p> <p>An account can only be the administrator account for one behavior graph within a Region. If the same account calls <code>CreateGraph</code> with the same administrator account, it always returns the same behavior graph ARN. It does not create a new behavior graph.</p>', 'CreateMembers' => '<p> <code>CreateMembers</code> is used to send invitations to accounts. For the organization behavior graph, the Detective administrator account uses <code>CreateMembers</code> to enable organization accounts as member accounts.</p> <p>For invited accounts, <code>CreateMembers</code> sends a request to invite the specified Amazon Web Services accounts to be member accounts in the behavior graph. This operation can only be called by the administrator account for a behavior graph. </p> <p> <code>CreateMembers</code> verifies the accounts and then invites the verified accounts. The administrator can optionally specify to not send invitation emails to the member accounts. This would be used when the administrator manages their member accounts centrally.</p> <p>For organization accounts in the organization behavior graph, <code>CreateMembers</code> attempts to enable the accounts. The organization accounts do not receive invitations.</p> <p>The request provides the behavior graph ARN and the list of accounts to invite or to enable.</p> <p>The response separates the requested accounts into two lists:</p> <ul> <li> <p>The accounts that <code>CreateMembers</code> was able to process. For invited accounts, includes member accounts that are being verified, that have passed verification and are to be invited, and that have failed verification. For organization accounts in the organization behavior graph, includes accounts that can be enabled and that cannot be enabled.</p> </li> <li> <p>The accounts that <code>CreateMembers</code> was unable to process. This list includes accounts that were already invited to be member accounts in the behavior graph.</p> </li> </ul>', 'DeleteGraph' => '<p>Disables the specified behavior graph and queues it to be deleted. This operation removes the behavior graph from each member account\'s list of behavior graphs.</p> <p> <code>DeleteGraph</code> can only be called by the administrator account for a behavior graph.</p>', 'DeleteMembers' => '<p>Removes the specified member accounts from the behavior graph. The removed accounts no longer contribute data to the behavior graph. This operation can only be called by the administrator account for the behavior graph.</p> <p>For invited accounts, the removed accounts are deleted from the list of accounts in the behavior graph. To restore the account, the administrator account must send another invitation.</p> <p>For organization accounts in the organization behavior graph, the Detective administrator account can always enable the organization account again. Organization accounts that are not enabled as member accounts are not included in the <code>ListMembers</code> results for the organization behavior graph.</p> <p>An administrator account cannot use <code>DeleteMembers</code> to remove their own account from the behavior graph. To disable a behavior graph, the administrator account uses the <code>DeleteGraph</code> API method.</p>', 'DescribeOrganizationConfiguration' => '<p>Returns information about the configuration for the organization behavior graph. Currently indicates whether to automatically enable new organization accounts as member accounts.</p> <p>Can only be called by the Detective administrator account for the organization. </p>', 'DisableOrganizationAdminAccount' => '<p>Removes the Detective administrator account in the current Region. Deletes the organization behavior graph.</p> <p>Can only be called by the organization management account.</p> <p>Removing the Detective administrator account does not affect the delegated administrator account for Detective in Organizations.</p> <p>To remove the delegated administrator account in Organizations, use the Organizations API. Removing the delegated administrator account also removes the Detective administrator account in all Regions, except for Regions where the Detective administrator account is the organization management account.</p>', 'DisassociateMembership' => '<p>Removes the member account from the specified behavior graph. This operation can only be called by an invited member account that has the <code>ENABLED</code> status.</p> <p> <code>DisassociateMembership</code> cannot be called by an organization account in the organization behavior graph. For the organization behavior graph, the Detective administrator account determines which organization accounts to enable or disable as member accounts.</p>', 'EnableOrganizationAdminAccount' => '<p>Designates the Detective administrator account for the organization in the current Region.</p> <p>If the account does not have Detective enabled, then enables Detective for that account and creates a new behavior graph.</p> <p>Can only be called by the organization management account.</p> <p>If the organization has a delegated administrator account in Organizations, then the Detective administrator account must be either the delegated administrator account or the organization management account.</p> <p>If the organization does not have a delegated administrator account in Organizations, then you can choose any account in the organization. If you choose an account other than the organization management account, Detective calls Organizations to make that account the delegated administrator account for Detective. The organization management account cannot be the delegated administrator account.</p>', 'GetInvestigation' => '<p>Detective investigations lets you investigate IAM users and IAM roles using indicators of compromise. An indicator of compromise (IOC) is an artifact observed in or on a network, system, or environment that can (with a high level of confidence) identify malicious activity or a security incident. <code>GetInvestigation</code> returns the investigation results of an investigation for a behavior graph. </p>', 'GetMembers' => '<p>Returns the membership details for specified member accounts for a behavior graph.</p>', 'ListDatasourcePackages' => '<p>Lists data source packages in the behavior graph.</p>', 'ListGraphs' => '<p>Returns the list of behavior graphs that the calling account is an administrator account of. This operation can only be called by an administrator account.</p> <p>Because an account can currently only be the administrator of one behavior graph within a Region, the results always contain a single behavior graph.</p>', 'ListIndicators' => '<p>Gets the indicators from an investigation. You can use the information from the indicators to determine if an IAM user and/or IAM role is involved in an unusual activity that could indicate malicious behavior and its impact.</p>', 'ListInvestigations' => '<p>Detective investigations lets you investigate IAM users and IAM roles using indicators of compromise. An indicator of compromise (IOC) is an artifact observed in or on a network, system, or environment that can (with a high level of confidence) identify malicious activity or a security incident. <code>ListInvestigations</code> lists all active Detective investigations.</p>', 'ListInvitations' => '<p>Retrieves the list of open and accepted behavior graph invitations for the member account. This operation can only be called by an invited member account.</p> <p>Open invitations are invitations that the member account has not responded to.</p> <p>The results do not include behavior graphs for which the member account declined the invitation. The results also do not include behavior graphs that the member account resigned from or was removed from.</p>', 'ListMembers' => '<p>Retrieves the list of member accounts for a behavior graph.</p> <p>For invited accounts, the results do not include member accounts that were removed from the behavior graph.</p> <p>For the organization behavior graph, the results do not include organization accounts that the Detective administrator account has not enabled as member accounts.</p>', 'ListOrganizationAdminAccounts' => '<p>Returns information about the Detective administrator account for an organization. Can only be called by the organization management account.</p>', 'ListTagsForResource' => '<p>Returns the tag values that are assigned to a behavior graph.</p>', 'RejectInvitation' => '<p>Rejects an invitation to contribute the account data to a behavior graph. This operation must be called by an invited member account that has the <code>INVITED</code> status.</p> <p> <code>RejectInvitation</code> cannot be called by an organization account in the organization behavior graph. In the organization behavior graph, organization accounts do not receive an invitation.</p>', 'StartInvestigation' => '<p>Detective investigations lets you investigate IAM users and IAM roles using indicators of compromise. An indicator of compromise (IOC) is an artifact observed in or on a network, system, or environment that can (with a high level of confidence) identify malicious activity or a security incident. <code>StartInvestigation</code> initiates an investigation on an entity in a behavior graph. </p>', 'StartMonitoringMember' => '<p>Sends a request to enable data ingest for a member account that has a status of <code>ACCEPTED_BUT_DISABLED</code>.</p> <p>For valid member accounts, the status is updated as follows.</p> <ul> <li> <p>If Detective enabled the member account, then the new status is <code>ENABLED</code>.</p> </li> <li> <p>If Detective cannot enable the member account, the status remains <code>ACCEPTED_BUT_DISABLED</code>. </p> </li> </ul>', 'TagResource' => '<p>Applies tag values to a behavior graph.</p>', 'UntagResource' => '<p>Removes tags from a behavior graph.</p>', 'UpdateDatasourcePackages' => '<p>Starts a data source packages for the behavior graph.</p>', 'UpdateInvestigationState' => '<p>Updates the state of an investigation.</p>', 'UpdateOrganizationConfiguration' => '<p>Updates the configuration for the Organizations integration in the current Region. Can only be called by the Detective administrator account for the organization.</p>', ], 'shapes' => [ 'APIFailureCount' => [ 'base' => NULL, 'refs' => [ 'TTPsObservedDetail$APIFailureCount' => '<p>The total number of failed API requests.</p>', ], ], 'APIName' => [ 'base' => NULL, 'refs' => [ 'TTPsObservedDetail$APIName' => '<p>The name of the API where the tactics, techniques, and procedure (TTP) was observed.</p>', ], ], 'APISuccessCount' => [ 'base' => NULL, 'refs' => [ 'TTPsObservedDetail$APISuccessCount' => '<p>The total number of successful API requests.</p>', ], ], 'AcceptInvitationRequest' => [ 'base' => NULL, 'refs' => [], ], 'AccessDeniedException' => [ 'base' => '<p>The request issuer does not have permission to access this resource or perform this operation.</p>', 'refs' => [], ], 'Account' => [ 'base' => '<p>An Amazon Web Services account that is the administrator account of or a member of a behavior graph.</p>', 'refs' => [ 'AccountList$member' => NULL, ], ], 'AccountId' => [ 'base' => NULL, 'refs' => [ 'Account$AccountId' => '<p>The account identifier of the Amazon Web Services account.</p>', 'AccountIdExtendedList$member' => NULL, 'AccountIdList$member' => NULL, 'Administrator$AccountId' => '<p>The Amazon Web Services account identifier of the Detective administrator account for the organization.</p>', 'EnableOrganizationAdminAccountRequest$AccountId' => '<p>The Amazon Web Services account identifier of the account to designate as the Detective administrator account for the organization.</p>', 'MemberDetail$AccountId' => '<p>The Amazon Web Services account identifier for the member account.</p>', 'MemberDetail$MasterId' => '<p>The Amazon Web Services account identifier of the administrator account for the behavior graph.</p>', 'MemberDetail$AdministratorId' => '<p>The Amazon Web Services account identifier of the administrator account for the behavior graph.</p>', 'MembershipDatasources$AccountId' => '<p>The account identifier of the Amazon Web Services account.</p>', 'StartMonitoringMemberRequest$AccountId' => '<p>The account ID of the member account to try to enable.</p> <p>The account must be an invited member account with a status of <code>ACCEPTED_BUT_DISABLED</code>. </p>', 'UnprocessedAccount$AccountId' => '<p>The Amazon Web Services account identifier of the member account that was not processed.</p>', ], ], 'AccountIdExtendedList' => [ 'base' => NULL, 'refs' => [ 'BatchGetGraphMemberDatasourcesRequest$AccountIds' => '<p>The list of Amazon Web Services accounts to get data source package information on.</p>', ], ], 'AccountIdList' => [ 'base' => NULL, 'refs' => [ 'DeleteMembersRequest$AccountIds' => '<p>The list of Amazon Web Services account identifiers for the member accounts to remove from the behavior graph. You can remove up to 50 member accounts at a time.</p>', 'DeleteMembersResponse$AccountIds' => '<p>The list of Amazon Web Services account identifiers for the member accounts that Detective successfully removed from the behavior graph.</p>', 'GetMembersRequest$AccountIds' => '<p>The list of Amazon Web Services account identifiers for the member account for which to return member details. You can request details for up to 50 member accounts at a time.</p> <p>You cannot use <code>GetMembers</code> to retrieve information about member accounts that were removed from the behavior graph.</p>', ], ], 'AccountList' => [ 'base' => NULL, 'refs' => [ 'CreateMembersRequest$Accounts' => '<p>The list of Amazon Web Services accounts to invite or to enable. You can invite or enable up to 50 accounts at a time. For each invited account, the account list contains the account identifier and the Amazon Web Services account root user email address. For organization accounts in the organization behavior graph, the email address is not required.</p>', ], ], 'Administrator' => [ 'base' => '<p>Information about the Detective administrator account for an organization.</p>', 'refs' => [ 'AdministratorList$member' => NULL, ], ], 'AdministratorList' => [ 'base' => NULL, 'refs' => [ 'ListOrganizationAdminAccountsResponse$Administrators' => '<p>The list of Detective administrator accounts.</p>', ], ], 'AiPaginationToken' => [ 'base' => NULL, 'refs' => [ 'ListIndicatorsRequest$NextToken' => '<p>Lists if there are more results available. The value of nextToken is a unique pagination token for each page. Repeat the call using the returned token to retrieve the next page. Keep all other arguments unchanged.</p> <p>Each pagination token expires after 24 hours. Using an expired pagination token will return a Validation Exception error.</p>', 'ListIndicatorsResponse$NextToken' => '<p>Lists if there are more results available. The value of nextToken is a unique pagination token for each page. Repeat the call using the returned token to retrieve the next page. Keep all other arguments unchanged.</p> <p>Each pagination token expires after 24 hours. Using an expired pagination token will return a Validation Exception error.</p>', 'ListInvestigationsRequest$NextToken' => '<p>Lists if there are more results available. The value of nextToken is a unique pagination token for each page. Repeat the call using the returned token to retrieve the next page. Keep all other arguments unchanged.</p> <p>Each pagination token expires after 24 hours. Using an expired pagination token will return a Validation Exception error.</p>', 'ListInvestigationsResponse$NextToken' => '<p>Lists if there are more results available. The value of nextToken is a unique pagination token for each page. Repeat the call using the returned token to retrieve the next page. Keep all other arguments unchanged.</p> <p>Each pagination token expires after 24 hours. </p>', ], ], 'Aso' => [ 'base' => NULL, 'refs' => [ 'NewAsoDetail$Aso' => '<p>Details about the new Autonomous System Organization (ASO).</p>', ], ], 'BatchGetGraphMemberDatasourcesRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetGraphMemberDatasourcesResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetMembershipDatasourcesRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetMembershipDatasourcesResponse' => [ 'base' => NULL, 'refs' => [], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'CreateMembersRequest$DisableEmailNotification' => '<p>if set to <code>true</code>, then the invited accounts do not receive email notifications. By default, this is set to <code>false</code>, and the invited accounts receive email notifications.</p> <p>Organization accounts in the organization behavior graph do not receive email notifications.</p>', 'DescribeOrganizationConfigurationResponse$AutoEnable' => '<p>Indicates whether to automatically enable new organization accounts as member accounts in the organization behavior graph.</p>', 'UpdateOrganizationConfigurationRequest$AutoEnable' => '<p>Indicates whether to automatically enable new organization accounts as member accounts in the organization behavior graph.</p>', ], ], 'ByteValue' => [ 'base' => NULL, 'refs' => [ 'DatasourcePackageUsageInfo$VolumeUsageInBytes' => '<p>Total volume of data in bytes per day ingested for a given data source package.</p>', 'MemberDetail$VolumeUsageInBytes' => '<p>The data volume in bytes per day for the member account.</p>', ], ], 'ConflictException' => [ 'base' => '<p>The request attempted an invalid action.</p>', 'refs' => [], ], 'CreateGraphRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateGraphResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateMembersRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateMembersResponse' => [ 'base' => NULL, 'refs' => [], ], 'DatasourcePackage' => [ 'base' => NULL, 'refs' => [ 'DatasourcePackageIngestDetails$key' => NULL, 'DatasourcePackageIngestHistory$key' => NULL, 'DatasourcePackageIngestStates$key' => NULL, 'DatasourcePackageList$member' => NULL, 'VolumeUsageByDatasourcePackage$key' => NULL, ], ], 'DatasourcePackageIngestDetail' => [ 'base' => '<p>Details about the data source packages ingested by your behavior graph.</p>', 'refs' => [ 'DatasourcePackageIngestDetails$value' => NULL, ], ], 'DatasourcePackageIngestDetails' => [ 'base' => NULL, 'refs' => [ 'ListDatasourcePackagesResponse$DatasourcePackages' => '<p>Details on the data source packages active in the behavior graph.</p>', ], ], 'DatasourcePackageIngestHistory' => [ 'base' => NULL, 'refs' => [ 'MembershipDatasources$DatasourcePackageIngestHistory' => '<p>Details on when a data source package was added to a behavior graph.</p>', ], ], 'DatasourcePackageIngestState' => [ 'base' => NULL, 'refs' => [ 'DatasourcePackageIngestDetail$DatasourcePackageIngestState' => '<p>Details on which data source packages are ingested for a member account.</p>', 'DatasourcePackageIngestStates$value' => NULL, 'LastIngestStateChangeDates$key' => NULL, ], ], 'DatasourcePackageIngestStates' => [ 'base' => NULL, 'refs' => [ 'MemberDetail$DatasourcePackageIngestStates' => '<p>The state of a data source package for the behavior graph.</p>', ], ], 'DatasourcePackageList' => [ 'base' => NULL, 'refs' => [ 'UpdateDatasourcePackagesRequest$DatasourcePackages' => '<p>The data source package start for the behavior graph.</p>', ], ], 'DatasourcePackageUsageInfo' => [ 'base' => '<p>Information on the usage of a data source package in the behavior graph.</p>', 'refs' => [ 'VolumeUsageByDatasourcePackage$value' => NULL, ], ], 'DateFilter' => [ 'base' => '<p>Contains details on the time range used to filter data.</p>', 'refs' => [ 'FilterCriteria$CreatedTime' => '<p>Filter the investigation results based on when the investigation was created.</p>', ], ], 'DeleteGraphRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMembersRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMembersResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeOrganizationConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeOrganizationConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateMembershipRequest' => [ 'base' => NULL, 'refs' => [], ], 'EmailAddress' => [ 'base' => NULL, 'refs' => [ 'Account$EmailAddress' => '<p>The Amazon Web Services account root user email address for the Amazon Web Services account.</p>', 'MemberDetail$EmailAddress' => '<p>The Amazon Web Services account root user email address for the member account.</p>', ], ], 'EmailMessage' => [ 'base' => NULL, 'refs' => [ 'CreateMembersRequest$Message' => '<p>Customized message text to include in the invitation email message to the invited member accounts.</p>', ], ], 'EnableOrganizationAdminAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'EntityArn' => [ 'base' => NULL, 'refs' => [ 'GetInvestigationResponse$EntityArn' => '<p>The unique Amazon Resource Name (ARN). Detective supports IAM user ARNs and IAM role ARNs.</p>', 'InvestigationDetail$EntityArn' => '<p>The unique Amazon Resource Name (ARN) of the IAM user and IAM role.</p>', 'RelatedFindingDetail$Arn' => '<p>The Amazon Resource Name (ARN) of the related finding.</p>', 'StartInvestigationRequest$EntityArn' => '<p>The unique Amazon Resource Name (ARN) of the IAM user and IAM role.</p>', ], ], 'EntityType' => [ 'base' => NULL, 'refs' => [ 'GetInvestigationResponse$EntityType' => '<p>Type of entity. For example, Amazon Web Services accounts, such as an IAM user and/or IAM role.</p>', 'InvestigationDetail$EntityType' => '<p>Type of entity. For example, Amazon Web Services accounts, such as IAM user and role.</p>', ], ], 'ErrorCode' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$ErrorCode' => '<p>The SDK default error code associated with the access denied exception.</p>', 'AccessDeniedException$SubErrorCode' => '<p>The error code associated with the access denied exception.</p>', 'ValidationException$ErrorCode' => '<p>The error code associated with the validation failure.</p>', ], ], 'ErrorCodeReason' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$ErrorCodeReason' => '<p>The SDK default explanation of why access was denied.</p>', 'AccessDeniedException$SubErrorCodeReason' => '<p> An explanation of why access was denied.</p>', 'ValidationException$ErrorCodeReason' => '<p> An explanation of why validation failed.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => NULL, 'ConflictException$Message' => NULL, 'InternalServerException$Message' => NULL, 'ResourceNotFoundException$Message' => NULL, 'ServiceQuotaExceededException$Message' => NULL, 'TooManyRequestsException$Message' => NULL, 'ValidationException$Message' => NULL, ], ], 'Field' => [ 'base' => NULL, 'refs' => [ 'SortCriteria$Field' => '<p>Represents the <code>Field</code> attribute to sort investigations.</p>', ], ], 'FilterCriteria' => [ 'base' => '<p>Details on the criteria used to define the filter for investigation results.</p>', 'refs' => [ 'ListInvestigationsRequest$FilterCriteria' => '<p>Filters the investigation results based on a criteria.</p>', ], ], 'FlaggedIpAddressDetail' => [ 'base' => '<p>Contains information on suspicious IP addresses identified as indicators of compromise. This indicator is derived from Amazon Web Services threat intelligence.</p>', 'refs' => [ 'IndicatorDetail$FlaggedIpAddressDetail' => '<p>Suspicious IP addresses that are flagged, which indicates critical or severe threats based on threat intelligence by Detective. This indicator is derived from Amazon Web Services threat intelligence.</p>', ], ], 'GetInvestigationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetInvestigationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetMembersRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMembersResponse' => [ 'base' => NULL, 'refs' => [], ], 'Graph' => [ 'base' => '<p>A behavior graph in Detective.</p>', 'refs' => [ 'GraphList$member' => NULL, ], ], 'GraphArn' => [ 'base' => NULL, 'refs' => [ 'AcceptInvitationRequest$GraphArn' => '<p>The ARN of the behavior graph that the member account is accepting the invitation for.</p> <p>The member account status in the behavior graph must be <code>INVITED</code>.</p>', 'Administrator$GraphArn' => '<p>The ARN of the organization behavior graph.</p>', 'BatchGetGraphMemberDatasourcesRequest$GraphArn' => '<p>The ARN of the behavior graph.</p>', 'CreateGraphResponse$GraphArn' => '<p>The ARN of the new behavior graph.</p>', 'CreateMembersRequest$GraphArn' => '<p>The ARN of the behavior graph.</p>', 'DeleteGraphRequest$GraphArn' => '<p>The ARN of the behavior graph to disable.</p>', 'DeleteMembersRequest$GraphArn' => '<p>The ARN of the behavior graph to remove members from.</p>', 'DescribeOrganizationConfigurationRequest$GraphArn' => '<p>The ARN of the organization behavior graph.</p>', 'DisassociateMembershipRequest$GraphArn' => '<p>The ARN of the behavior graph to remove the member account from.</p> <p>The member account\'s member status in the behavior graph must be <code>ENABLED</code>.</p>', 'GetInvestigationRequest$GraphArn' => '<p>The Amazon Resource Name (ARN) of the behavior graph.</p>', 'GetInvestigationResponse$GraphArn' => '<p>The Amazon Resource Name (ARN) of the behavior graph.</p>', 'GetMembersRequest$GraphArn' => '<p>The ARN of the behavior graph for which to request the member details.</p>', 'Graph$Arn' => '<p>The ARN of the behavior graph.</p>', 'GraphArnList$member' => NULL, 'ListDatasourcePackagesRequest$GraphArn' => '<p>The ARN of the behavior graph.</p>', 'ListIndicatorsRequest$GraphArn' => '<p>The Amazon Resource Name (ARN) of the behavior graph.</p>', 'ListIndicatorsResponse$GraphArn' => '<p>The Amazon Resource Name (ARN) of the behavior graph.</p>', 'ListInvestigationsRequest$GraphArn' => '<p>The Amazon Resource Name (ARN) of the behavior graph.</p>', 'ListMembersRequest$GraphArn' => '<p>The ARN of the behavior graph for which to retrieve the list of member accounts.</p>', 'ListTagsForResourceRequest$ResourceArn' => '<p>The ARN of the behavior graph for which to retrieve the tag values.</p>', 'MemberDetail$GraphArn' => '<p>The ARN of the behavior graph.</p>', 'MembershipDatasources$GraphArn' => '<p>The ARN of the organization behavior graph.</p>', 'RejectInvitationRequest$GraphArn' => '<p>The ARN of the behavior graph to reject the invitation to.</p> <p>The member account\'s current member status in the behavior graph must be <code>INVITED</code>.</p>', 'StartInvestigationRequest$GraphArn' => '<p>The Amazon Resource Name (ARN) of the behavior graph.</p>', 'StartMonitoringMemberRequest$GraphArn' => '<p>The ARN of the behavior graph.</p>', 'TagResourceRequest$ResourceArn' => '<p>The ARN of the behavior graph to assign the tags to.</p>', 'UnprocessedGraph$GraphArn' => '<p>The ARN of the organization behavior graph.</p>', 'UntagResourceRequest$ResourceArn' => '<p>The ARN of the behavior graph to remove the tags from.</p>', 'UpdateDatasourcePackagesRequest$GraphArn' => '<p>The ARN of the behavior graph.</p>', 'UpdateInvestigationStateRequest$GraphArn' => '<p>The Amazon Resource Name (ARN) of the behavior graph.</p>', 'UpdateOrganizationConfigurationRequest$GraphArn' => '<p>The ARN of the organization behavior graph.</p>', ], ], 'GraphArnList' => [ 'base' => NULL, 'refs' => [ 'BatchGetMembershipDatasourcesRequest$GraphArns' => '<p>The ARN of the behavior graph.</p>', ], ], 'GraphList' => [ 'base' => NULL, 'refs' => [ 'ListGraphsResponse$GraphList' => '<p>A list of behavior graphs that the account is an administrator account for.</p>', ], ], 'HourlyTimeDelta' => [ 'base' => NULL, 'refs' => [ 'ImpossibleTravelDetail$HourlyTimeDelta' => '<p>Returns the time difference between the first and last timestamp the resource was used.</p>', ], ], 'Id' => [ 'base' => NULL, 'refs' => [ 'RelatedFindingGroupDetail$Id' => '<p>The unique identifier for the finding group.</p>', ], ], 'ImpossibleTravelDetail' => [ 'base' => '<p>Contains information on unusual and impossible travel in an account.</p>', 'refs' => [ 'IndicatorDetail$ImpossibleTravelDetail' => '<p>Identifies unusual and impossible user activity for an account. </p>', ], ], 'Indicator' => [ 'base' => '<p>Detective investigations triages indicators of compromises such as a finding and surfaces only the most critical and suspicious issues, so you can focus on high-level investigations. An <code>Indicator</code> lets you determine if an Amazon Web Services resource is involved in unusual activity that could indicate malicious behavior and its impact.</p>', 'refs' => [ 'Indicators$member' => NULL, ], ], 'IndicatorDetail' => [ 'base' => '<p>Details about the indicators of compromise which are used to determine if a resource is involved in a security incident. An indicator of compromise (IOC) is an artifact observed in or on a network, system, or environment that can (with a high level of confidence) identify malicious activity or a security incident. For the list of indicators of compromise that are generated by Detective investigations, see <a href="https://docs.aws.amazon.com/detective/latest/userguide/detective-investigations.html">Detective investigations</a>.</p>', 'refs' => [ 'Indicator$IndicatorDetail' => '<p>Details about the indicators of compromise that are used to determine if a resource is involved in a security incident. An indicator of compromise (IOC) is an artifact observed in or on a network, system, or environment that can (with a high level of confidence) identify malicious activity or a security incident.</p>', ], ], 'IndicatorType' => [ 'base' => NULL, 'refs' => [ 'Indicator$IndicatorType' => '<p>The type of indicator. </p>', 'ListIndicatorsRequest$IndicatorType' => '<p>For the list of indicators of compromise that are generated by Detective investigations, see <a href="https://docs.aws.amazon.com/detective/latest/userguide/detective-investigations.html">Detective investigations</a>.</p>', ], ], 'Indicators' => [ 'base' => NULL, 'refs' => [ 'ListIndicatorsResponse$Indicators' => '<p>Lists the indicators of compromise.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>The request was valid but failed because of a problem with the service.</p>', 'refs' => [], ], 'InvestigationDetail' => [ 'base' => '<p>Details about the investigation related to a potential security event identified by Detective.</p>', 'refs' => [ 'InvestigationDetails$member' => NULL, ], ], 'InvestigationDetails' => [ 'base' => NULL, 'refs' => [ 'ListInvestigationsResponse$InvestigationDetails' => '<p>Lists the summary of uncommon behavior or malicious activity which indicates a compromise.</p>', ], ], 'InvestigationId' => [ 'base' => NULL, 'refs' => [ 'GetInvestigationRequest$InvestigationId' => '<p>The investigation ID of the investigation report.</p>', 'GetInvestigationResponse$InvestigationId' => '<p>The investigation ID of the investigation report.</p>', 'InvestigationDetail$InvestigationId' => '<p>The investigation ID of the investigation report.</p>', 'ListIndicatorsRequest$InvestigationId' => '<p>The investigation ID of the investigation report.</p>', 'ListIndicatorsResponse$InvestigationId' => '<p>The investigation ID of the investigation report.</p>', 'StartInvestigationResponse$InvestigationId' => '<p>The investigation ID of the investigation report.</p>', 'UpdateInvestigationStateRequest$InvestigationId' => '<p>The investigation ID of the investigation report.</p>', ], ], 'InvitationType' => [ 'base' => NULL, 'refs' => [ 'MemberDetail$InvitationType' => '<p>The type of behavior graph membership.</p> <p>For an organization account in the organization behavior graph, the type is <code>ORGANIZATION</code>.</p> <p>For an account that was invited to a behavior graph, the type is <code>INVITATION</code>. </p>', ], ], 'IpAddress' => [ 'base' => NULL, 'refs' => [ 'FlaggedIpAddressDetail$IpAddress' => '<p>IP address of the suspicious entity.</p>', 'ImpossibleTravelDetail$StartingIpAddress' => '<p>IP address where the resource was first used in the impossible travel.</p>', 'ImpossibleTravelDetail$EndingIpAddress' => '<p>IP address where the resource was last used in the impossible travel.</p>', 'NewGeolocationDetail$IpAddress' => '<p>IP address using which the resource was accessed.</p>', 'RelatedFindingDetail$IpAddress' => '<p>The IP address of the finding.</p>', 'TTPsObservedDetail$IpAddress' => '<p>The IP address where the tactics, techniques, and procedure (TTP) was observed.</p>', ], ], 'IsNewForEntireAccount' => [ 'base' => NULL, 'refs' => [ 'NewAsoDetail$IsNewForEntireAccount' => '<p>Checks if the Autonomous System Organization (ASO) is new for the entire account.</p>', 'NewGeolocationDetail$IsNewForEntireAccount' => '<p>Checks if the geolocation is new for the entire account.</p>', 'NewUserAgentDetail$IsNewForEntireAccount' => '<p>Checks if the user agent is new for the entire account.</p>', ], ], 'LastIngestStateChangeDates' => [ 'base' => NULL, 'refs' => [ 'DatasourcePackageIngestDetail$LastIngestStateChange' => '<p>The date a data source package was enabled for this account</p>', 'DatasourcePackageIngestHistory$value' => NULL, ], ], 'ListDatasourcePackagesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDatasourcePackagesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListGraphsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListGraphsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListIndicatorsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListIndicatorsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListInvestigationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListInvestigationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListInvitationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListInvitationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListMembersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListMembersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListOrganizationAdminAccountsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListOrganizationAdminAccountsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'Location' => [ 'base' => NULL, 'refs' => [ 'ImpossibleTravelDetail$StartingLocation' => '<p>Location where the resource was first used in the impossible travel.</p>', 'ImpossibleTravelDetail$EndingLocation' => '<p>Location where the resource was last used in the impossible travel.</p>', 'NewGeolocationDetail$Location' => '<p>Location where the resource was accessed.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListIndicatorsRequest$MaxResults' => '<p>Lists the maximum number of indicators in a page.</p>', 'ListInvestigationsRequest$MaxResults' => '<p>Lists the maximum number of investigations in a page.</p>', ], ], 'MemberDetail' => [ 'base' => '<p>Details about a member account in a behavior graph.</p>', 'refs' => [ 'MemberDetailList$member' => NULL, ], ], 'MemberDetailList' => [ 'base' => NULL, 'refs' => [ 'CreateMembersResponse$Members' => '<p>The set of member account invitation or enablement requests that Detective was able to process. This includes accounts that are being verified, that failed verification, and that passed verification and are being sent an invitation or are being enabled.</p>', 'GetMembersResponse$MemberDetails' => '<p>The member account details that Detective is returning in response to the request.</p>', 'ListInvitationsResponse$Invitations' => '<p>The list of behavior graphs for which the member account has open or accepted invitations.</p>', 'ListMembersResponse$MemberDetails' => '<p>The list of member accounts in the behavior graph.</p> <p>For invited accounts, the results include member accounts that did not pass verification and member accounts that have not yet accepted the invitation to the behavior graph. The results do not include member accounts that were removed from the behavior graph.</p> <p>For the organization behavior graph, the results do not include organization accounts that the Detective administrator account has not enabled as member accounts.</p>', ], ], 'MemberDisabledReason' => [ 'base' => NULL, 'refs' => [ 'MemberDetail$DisabledReason' => '<p>For member accounts with a status of <code>ACCEPTED_BUT_DISABLED</code>, the reason that the member account is not enabled.</p> <p>The reason can have one of the following values:</p> <ul> <li> <p> <code>VOLUME_TOO_HIGH</code> - Indicates that adding the member account would cause the data volume for the behavior graph to be too high.</p> </li> <li> <p> <code>VOLUME_UNKNOWN</code> - Indicates that Detective is unable to verify the data volume for the member account. This is usually because the member account is not enrolled in Amazon GuardDuty. </p> </li> </ul>', ], ], 'MemberResultsLimit' => [ 'base' => NULL, 'refs' => [ 'ListDatasourcePackagesRequest$MaxResults' => '<p>The maximum number of results to return.</p>', 'ListGraphsRequest$MaxResults' => '<p>The maximum number of graphs to return at a time. The total must be less than the overall limit on the number of results to return, which is currently 200.</p>', 'ListInvitationsRequest$MaxResults' => '<p>The maximum number of behavior graph invitations to return in the response. The total must be less than the overall limit on the number of results to return, which is currently 200.</p>', 'ListMembersRequest$MaxResults' => '<p>The maximum number of member accounts to include in the response. The total must be less than the overall limit on the number of results to return, which is currently 200.</p>', 'ListOrganizationAdminAccountsRequest$MaxResults' => '<p>The maximum number of results to return.</p>', ], ], 'MemberStatus' => [ 'base' => NULL, 'refs' => [ 'MemberDetail$Status' => '<p>The current membership status of the member account. The status can have one of the following values:</p> <ul> <li> <p> <code>INVITED</code> - For invited accounts only. Indicates that the member was sent an invitation but has not yet responded.</p> </li> <li> <p> <code>VERIFICATION_IN_PROGRESS</code> - For invited accounts only, indicates that Detective is verifying that the account identifier and email address provided for the member account match. If they do match, then Detective sends the invitation. If the email address and account identifier don\'t match, then the member cannot be added to the behavior graph.</p> <p>For organization accounts in the organization behavior graph, indicates that Detective is verifying that the account belongs to the organization.</p> </li> <li> <p> <code>VERIFICATION_FAILED</code> - For invited accounts only. Indicates that the account and email address provided for the member account do not match, and Detective did not send an invitation to the account.</p> </li> <li> <p> <code>ENABLED</code> - Indicates that the member account currently contributes data to the behavior graph. For invited accounts, the member account accepted the invitation. For organization accounts in the organization behavior graph, the Detective administrator account enabled the organization account as a member account.</p> </li> <li> <p> <code>ACCEPTED_BUT_DISABLED</code> - The account accepted the invitation, or was enabled by the Detective administrator account, but is prevented from contributing data to the behavior graph. <code>DisabledReason</code> provides the reason why the member account is not enabled.</p> </li> </ul> <p>Invited accounts that declined an invitation or that were removed from the behavior graph are not included. In the organization behavior graph, organization accounts that the Detective administrator account did not enable are not included.</p>', ], ], 'MembershipDatasources' => [ 'base' => '<p>Details on data source packages for members of the behavior graph.</p>', 'refs' => [ 'MembershipDatasourcesList$member' => NULL, ], ], 'MembershipDatasourcesList' => [ 'base' => NULL, 'refs' => [ 'BatchGetGraphMemberDatasourcesResponse$MemberDatasources' => '<p>Details on the status of data source packages for members of the behavior graph.</p>', 'BatchGetMembershipDatasourcesResponse$MembershipDatasources' => '<p>Details on the data source package history for an member of the behavior graph.</p>', ], ], 'NewAsoDetail' => [ 'base' => '<p>Details new Autonomous System Organizations (ASOs) used either at the resource or account level. </p>', 'refs' => [ 'IndicatorDetail$NewAsoDetail' => '<p>Contains details about the new Autonomous System Organization (ASO).</p>', ], ], 'NewGeolocationDetail' => [ 'base' => '<p>Details new geolocations used either at the resource or account level. For example, lists an observed geolocation that is an infrequent or unused location based on previous user activity.</p>', 'refs' => [ 'IndicatorDetail$NewGeolocationDetail' => '<p>Contains details about the new geographic location.</p>', ], ], 'NewUserAgentDetail' => [ 'base' => '<p>Details new user agents used either at the resource or account level.</p>', 'refs' => [ 'IndicatorDetail$NewUserAgentDetail' => '<p>Contains details about the new user agent.</p>', ], ], 'PaginationToken' => [ 'base' => NULL, 'refs' => [ 'ListDatasourcePackagesRequest$NextToken' => '<p>For requests to get the next page of results, the pagination token that was returned with the previous set of results. The initial request does not include a pagination token.</p>', 'ListDatasourcePackagesResponse$NextToken' => '<p>For requests to get the next page of results, the pagination token that was returned with the previous set of results. The initial request does not include a pagination token.</p>', 'ListGraphsRequest$NextToken' => '<p>For requests to get the next page of results, the pagination token that was returned with the previous set of results. The initial request does not include a pagination token.</p>', 'ListGraphsResponse$NextToken' => '<p>If there are more behavior graphs remaining in the results, then this is the pagination token to use to request the next page of behavior graphs.</p>', 'ListInvitationsRequest$NextToken' => '<p>For requests to retrieve the next page of results, the pagination token that was returned with the previous page of results. The initial request does not include a pagination token.</p>', 'ListInvitationsResponse$NextToken' => '<p>If there are more behavior graphs remaining in the results, then this is the pagination token to use to request the next page of behavior graphs.</p>', 'ListMembersRequest$NextToken' => '<p>For requests to retrieve the next page of member account results, the pagination token that was returned with the previous page of results. The initial request does not include a pagination token.</p>', 'ListMembersResponse$NextToken' => '<p>If there are more member accounts remaining in the results, then use this pagination token to request the next page of member accounts.</p>', 'ListOrganizationAdminAccountsRequest$NextToken' => '<p>For requests to get the next page of results, the pagination token that was returned with the previous set of results. The initial request does not include a pagination token.</p>', 'ListOrganizationAdminAccountsResponse$NextToken' => '<p>If there are more accounts remaining in the results, then this is the pagination token to use to request the next page of accounts.</p>', ], ], 'Percentage' => [ 'base' => NULL, 'refs' => [ 'MemberDetail$PercentOfGraphUtilization' => '<p>The member account data volume as a percentage of the maximum allowed data volume. 0 indicates 0 percent, and 100 indicates 100 percent.</p> <p>Note that this is not the percentage of the behavior graph data volume.</p> <p>For example, the data volume for the behavior graph is 80 GB per day. The maximum data volume is 160 GB per day. If the data volume for the member account is 40 GB per day, then <code>PercentOfGraphUtilization</code> is 25. It represents 25% of the maximum allowed data volume. </p>', ], ], 'Procedure' => [ 'base' => NULL, 'refs' => [ 'TTPsObservedDetail$Procedure' => '<p>The procedure used, identified by the investigation.</p>', ], ], 'Reason' => [ 'base' => NULL, 'refs' => [ 'FlaggedIpAddressDetail$Reason' => '<p>Details the reason the IP address was flagged as suspicious.</p>', ], ], 'RejectInvitationRequest' => [ 'base' => NULL, 'refs' => [], ], 'RelatedFindingDetail' => [ 'base' => '<p>Details related activities associated with a potential security event. Lists all distinct categories of evidence that are connected to the resource or the finding group.</p>', 'refs' => [ 'IndicatorDetail$RelatedFindingDetail' => '<p>Contains details about related findings.</p>', ], ], 'RelatedFindingGroupDetail' => [ 'base' => '<p>Details multiple activities as they related to a potential security event. Detective uses graph analysis technique that infers relationships between findings and entities, and groups them together as a finding group.</p>', 'refs' => [ 'IndicatorDetail$RelatedFindingGroupDetail' => '<p>Contains details about related finding groups.</p>', ], ], 'Resource' => [ 'base' => NULL, 'refs' => [ 'ResourceList$member' => NULL, ], ], 'ResourceList' => [ 'base' => NULL, 'refs' => [ 'ServiceQuotaExceededException$Resources' => '<p>The type of resource that has exceeded the service quota.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The request refers to a nonexistent resource.</p>', 'refs' => [], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>This request cannot be completed for one of the following reasons.</p> <ul> <li> <p>This request cannot be completed if it would cause the number of member accounts in the behavior graph to exceed the maximum allowed. A behavior graph cannot have more than 1,200 member accounts.</p> </li> <li> <p>This request cannot be completed if the current volume ingested is above the limit of 10 TB per day. Detective will not allow you to add additional member accounts.</p> </li> </ul>', 'refs' => [], ], 'Severity' => [ 'base' => NULL, 'refs' => [ 'GetInvestigationResponse$Severity' => '<p>The severity assigned is based on the likelihood and impact of the indicators of compromise discovered in the investigation.</p>', 'InvestigationDetail$Severity' => '<p>Severity based on the likelihood and impact of the indicators of compromise discovered in the investigation.</p>', ], ], 'SortCriteria' => [ 'base' => '<p>Details about the criteria used for sorting investigations.</p>', 'refs' => [ 'ListInvestigationsRequest$SortCriteria' => '<p>Sorts the investigation results based on a criteria.</p>', ], ], 'SortOrder' => [ 'base' => NULL, 'refs' => [ 'SortCriteria$SortOrder' => '<p>The order by which the sorted findings are displayed.</p>', ], ], 'StartInvestigationRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartInvestigationResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartMonitoringMemberRequest' => [ 'base' => NULL, 'refs' => [], ], 'State' => [ 'base' => NULL, 'refs' => [ 'GetInvestigationResponse$State' => '<p>The current state of the investigation. An archived investigation indicates that you have completed reviewing the investigation.</p>', 'InvestigationDetail$State' => '<p>The current state of the investigation. An archived investigation indicates you have completed reviewing the investigation.</p>', 'UpdateInvestigationStateRequest$State' => '<p>The current state of the investigation. An archived investigation indicates you have completed reviewing the investigation.</p>', ], ], 'Status' => [ 'base' => NULL, 'refs' => [ 'GetInvestigationResponse$Status' => '<p>The status based on the completion status of the investigation.</p>', 'InvestigationDetail$Status' => '<p>Status based on the completion status of the investigation.</p>', ], ], 'StringFilter' => [ 'base' => '<p>A string for filtering Detective investigations.</p>', 'refs' => [ 'FilterCriteria$Severity' => '<p>Filter the investigation results based on the severity.</p>', 'FilterCriteria$Status' => '<p>Filter the investigation results based on the status.</p>', 'FilterCriteria$State' => '<p>Filter the investigation results based on the state.</p>', 'FilterCriteria$EntityArn' => '<p>Filter the investigation results based on the Amazon Resource Name (ARN) of the entity.</p>', ], ], 'TTPsObservedDetail' => [ 'base' => '<p>Details tactics, techniques, and procedures (TTPs) used in a potential security event. Tactics are based on <a href="https://attack.mitre.org/matrices/enterprise/">MITRE ATT&amp;CK Matrix for Enterprise</a>. </p>', 'refs' => [ 'IndicatorDetail$TTPsObservedDetail' => '<p>Details about the indicator of compromise.</p>', ], ], 'Tactic' => [ 'base' => NULL, 'refs' => [ 'TTPsObservedDetail$Tactic' => '<p>The tactic used, identified by the investigation.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'TagMap$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>The tag keys of the tags to remove from the behavior graph. You can remove up to 50 tags at a time.</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'CreateGraphRequest$Tags' => '<p>The tags to assign to the new behavior graph. You can add up to 50 tags. For each tag, you provide the tag key and the tag value. Each tag key can contain up to 128 characters. Each tag value can contain up to 256 characters.</p>', 'ListTagsForResourceResponse$Tags' => '<p>The tag values that are assigned to the behavior graph. The request returns up to 50 tag values.</p>', 'TagResourceRequest$Tags' => '<p>The tags to assign to the behavior graph. You can add up to 50 tags. For each tag, you provide the tag key and the tag value. Each tag key can contain up to 128 characters. Each tag value can contain up to 256 characters.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagMap$value' => NULL, ], ], 'Technique' => [ 'base' => NULL, 'refs' => [ 'TTPsObservedDetail$Technique' => '<p>The technique used, identified by the investigation. </p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'Administrator$DelegationTime' => '<p>The date and time when the Detective administrator account was enabled. The value is an ISO8601 formatted string. For example, <code>2021-08-18T16:35:56.284Z</code>.</p>', 'DatasourcePackageUsageInfo$VolumeUsageUpdateTime' => '<p>The data and time when the member account data volume was last updated. The value is an ISO8601 formatted string. For example, <code>2021-08-18T16:35:56.284Z</code>.</p>', 'DateFilter$StartInclusive' => '<p>A timestamp representing the start of the time period from when data is filtered, including the start date.</p>', 'DateFilter$EndInclusive' => '<p>A timestamp representing the end date of the time period until when data is filtered, including the end date.</p>', 'GetInvestigationResponse$CreatedTime' => '<p>The creation time of the investigation report in UTC time stamp format.</p>', 'GetInvestigationResponse$ScopeStartTime' => '<p>The start date and time used to set the scope time within which you want to generate the investigation report. The value is an UTC ISO8601 formatted string. For example, <code>2021-08-18T16:35:56.284Z</code>.</p>', 'GetInvestigationResponse$ScopeEndTime' => '<p>The data and time when the investigation began. The value is an UTC ISO8601 formatted string. For example, <code>2021-08-18T16:35:56.284Z</code>.</p>', 'Graph$CreatedTime' => '<p>The date and time that the behavior graph was created. The value is an ISO8601 formatted string. For example, <code>2021-08-18T16:35:56.284Z</code>.</p>', 'InvestigationDetail$CreatedTime' => '<p>The time stamp of the creation time of the investigation report. The value is an UTC ISO8601 formatted string. For example, <code>2021-08-18T16:35:56.284Z</code>.</p>', 'MemberDetail$InvitedTime' => '<p>For invited accounts, the date and time that Detective sent the invitation to the account. The value is an ISO8601 formatted string. For example, <code>2021-08-18T16:35:56.284Z</code>.</p>', 'MemberDetail$UpdatedTime' => '<p>The date and time that the member account was last updated. The value is an ISO8601 formatted string. For example, <code>2021-08-18T16:35:56.284Z</code>.</p>', 'MemberDetail$VolumeUsageUpdatedTime' => '<p>The data and time when the member account data volume was last updated. The value is an ISO8601 formatted string. For example, <code>2021-08-18T16:35:56.284Z</code>.</p>', 'MemberDetail$PercentOfGraphUtilizationUpdatedTime' => '<p>The date and time when the graph utilization percentage was last updated. The value is an ISO8601 formatted string. For example, <code>2021-08-18T16:35:56.284Z</code>.</p>', 'StartInvestigationRequest$ScopeStartTime' => '<p>The data and time when the investigation began. The value is an UTC ISO8601 formatted string. For example, <code>2021-08-18T16:35:56.284Z</code>.</p>', 'StartInvestigationRequest$ScopeEndTime' => '<p>The data and time when the investigation ended. The value is an UTC ISO8601 formatted string. For example, <code>2021-08-18T16:35:56.284Z</code>.</p>', 'TimestampForCollection$Timestamp' => '<p>The data and time when data collection began for a source package. The value is an ISO8601 formatted string. For example, <code>2021-08-18T16:35:56.284Z</code>.</p>', ], ], 'TimestampForCollection' => [ 'base' => '<p>Details on when data collection began for a source package.</p>', 'refs' => [ 'LastIngestStateChangeDates$value' => NULL, ], ], 'TooManyRequestsException' => [ 'base' => '<p>The request cannot be completed because too many other requests are occurring at the same time.</p>', 'refs' => [], ], 'Type' => [ 'base' => NULL, 'refs' => [ 'RelatedFindingDetail$Type' => '<p>The type of finding.</p>', ], ], 'UnprocessedAccount' => [ 'base' => '<p>A member account that was included in a request but for which the request could not be processed.</p>', 'refs' => [ 'UnprocessedAccountList$member' => NULL, ], ], 'UnprocessedAccountList' => [ 'base' => NULL, 'refs' => [ 'BatchGetGraphMemberDatasourcesResponse$UnprocessedAccounts' => '<p>Accounts that data source package information could not be retrieved for.</p>', 'CreateMembersResponse$UnprocessedAccounts' => '<p>The list of accounts for which Detective was unable to process the invitation or enablement request. For each account, the list provides the reason why the request could not be processed. The list includes accounts that are already member accounts in the behavior graph.</p>', 'DeleteMembersResponse$UnprocessedAccounts' => '<p>The list of member accounts that Detective was not able to remove from the behavior graph. For each member account, provides the reason that the deletion could not be processed.</p>', 'GetMembersResponse$UnprocessedAccounts' => '<p>The requested member accounts for which Detective was unable to return member details.</p> <p>For each account, provides the reason why the request could not be processed.</p>', ], ], 'UnprocessedGraph' => [ 'base' => '<p>Behavior graphs that could not be processed in the request.</p>', 'refs' => [ 'UnprocessedGraphList$member' => NULL, ], ], 'UnprocessedGraphList' => [ 'base' => NULL, 'refs' => [ 'BatchGetMembershipDatasourcesResponse$UnprocessedGraphs' => '<p>Graphs that data source package information could not be retrieved for.</p>', ], ], 'UnprocessedReason' => [ 'base' => NULL, 'refs' => [ 'UnprocessedAccount$Reason' => '<p>The reason that the member account request could not be processed.</p>', 'UnprocessedGraph$Reason' => '<p>The reason data source package information could not be processed for a behavior graph.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDatasourcePackagesRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateInvestigationStateRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateOrganizationConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UserAgent' => [ 'base' => NULL, 'refs' => [ 'NewUserAgentDetail$UserAgent' => '<p>New user agent which accessed the resource.</p>', ], ], 'ValidationException' => [ 'base' => '<p>The request parameters are invalid.</p>', 'refs' => [], ], 'Value' => [ 'base' => NULL, 'refs' => [ 'StringFilter$Value' => '<p>The string filter value.</p>', ], ], 'VolumeUsageByDatasourcePackage' => [ 'base' => NULL, 'refs' => [ 'MemberDetail$VolumeUsageByDatasourcePackage' => '<p>Details on the volume of usage for each data source package in a behavior graph.</p>', ], ], ],];
