<?php
// This file was auto-generated from sdk-root/src/data/dlm/2018-01-12/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Amazon Data Lifecycle Manager</fullname> <p>With Amazon Data Lifecycle Manager, you can manage the lifecycle of your Amazon Web Services resources. You create lifecycle policies, which are used to automate operations on the specified resources.</p> <p>Amazon Data Lifecycle Manager supports Amazon EBS volumes and snapshots. For information about using Amazon Data Lifecycle Manager with Amazon EBS, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshot-lifecycle.html"> Amazon Data Lifecycle Manager</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'operations' => [ 'CreateLifecyclePolicy' => '<p>Creates an Amazon Data Lifecycle Manager lifecycle policy. Amazon Data Lifecycle Manager supports the following policy types:</p> <ul> <li> <p>Custom EBS snapshot policy</p> </li> <li> <p>Custom EBS-backed AMI policy</p> </li> <li> <p>Cross-account copy event policy</p> </li> <li> <p>Default policy for EBS snapshots</p> </li> <li> <p>Default policy for EBS-backed AMIs</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/policy-differences.html"> Default policies vs custom policies</a>.</p> <important> <p>If you create a default policy, you can specify the request parameters either in the request body, or in the PolicyDetails request structure, but not both.</p> </important>', 'DeleteLifecyclePolicy' => '<p>Deletes the specified lifecycle policy and halts the automated operations that the policy specified.</p> <p>For more information about deleting a policy, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/view-modify-delete.html#delete">Delete lifecycle policies</a>.</p>', 'GetLifecyclePolicies' => '<p>Gets summary information about all or the specified data lifecycle policies.</p> <p>To get complete information about a policy, use <a href="https://docs.aws.amazon.com/dlm/latest/APIReference/API_GetLifecyclePolicy.html">GetLifecyclePolicy</a>.</p>', 'GetLifecyclePolicy' => '<p>Gets detailed information about the specified lifecycle policy.</p>', 'ListTagsForResource' => '<p>Lists the tags for the specified resource.</p>', 'TagResource' => '<p>Adds the specified tags to the specified resource.</p>', 'UntagResource' => '<p>Removes the specified tags from the specified resource.</p>', 'UpdateLifecyclePolicy' => '<p>Updates the specified lifecycle policy.</p> <p>For more information about updating a policy, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/view-modify-delete.html#modify">Modify lifecycle policies</a>.</p>', ], 'shapes' => [ 'Action' => [ 'base' => '<p> <b>[Event-based policies only]</b> Specifies an action for an event-based policy.</p>', 'refs' => [ 'ActionList$member' => NULL, ], ], 'ActionList' => [ 'base' => NULL, 'refs' => [ 'PolicyDetails$Actions' => '<p> <b>[Event-based policies only]</b> The actions to be performed when the event-based policy is activated. You can specify only one action per policy.</p>', ], ], 'ActionName' => [ 'base' => NULL, 'refs' => [ 'Action$Name' => '<p>A descriptive name for the action.</p>', ], ], 'ArchiveRetainRule' => [ 'base' => '<p> <b>[Custom snapshot policies only]</b> Specifies information about the archive storage tier retention period.</p>', 'refs' => [ 'ArchiveRule$RetainRule' => '<p>Information about the retention period for the snapshot archiving rule.</p>', ], ], 'ArchiveRule' => [ 'base' => '<p> <b>[Custom snapshot policies only]</b> Specifies a snapshot archiving rule for a schedule.</p>', 'refs' => [ 'Schedule$ArchiveRule' => '<p> <b>[Custom snapshot policies that target volumes only]</b> The snapshot archiving rule for the schedule. When you specify an archiving rule, snapshots are automatically moved from the standard tier to the archive tier once the schedule\'s retention threshold is met. Snapshots are then retained in the archive tier for the archive retention period that you specify. </p> <p>For more information about using snapshot archiving, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshot-ami-policy.html#dlm-archive">Considerations for snapshot lifecycle policies</a>.</p>', ], ], 'AvailabilityZone' => [ 'base' => NULL, 'refs' => [ 'AvailabilityZoneList$member' => NULL, ], ], 'AvailabilityZoneList' => [ 'base' => NULL, 'refs' => [ 'FastRestoreRule$AvailabilityZones' => '<p>The Availability Zones in which to enable fast snapshot restore.</p>', ], ], 'AwsAccountId' => [ 'base' => NULL, 'refs' => [ 'ShareTargetAccountList$member' => NULL, 'SnapshotOwnerList$member' => NULL, ], ], 'CmkArn' => [ 'base' => NULL, 'refs' => [ 'CrossRegionCopyRule$CmkArn' => '<p>The Amazon Resource Name (ARN) of the KMS key to use for EBS encryption. If this parameter is not specified, the default KMS key for the account is used.</p>', 'EncryptionConfiguration$CmkArn' => '<p>The Amazon Resource Name (ARN) of the KMS key to use for EBS encryption. If this parameter is not specified, the default KMS key for the account is used.</p>', ], ], 'CopyTags' => [ 'base' => NULL, 'refs' => [ 'Schedule$CopyTags' => '<p>Copy all user-defined tags on a source volume to snapshots of the volume created by this policy.</p>', ], ], 'CopyTagsNullable' => [ 'base' => NULL, 'refs' => [ 'CreateLifecyclePolicyRequest$CopyTags' => '<p> <b>[Default policies only]</b> Indicates whether the policy should copy tags from the source resource to the snapshot or AMI. If you do not specify a value, the default is <code>false</code>.</p> <p>Default: false</p>', 'CrossRegionCopyRule$CopyTags' => '<p>Indicates whether to copy all user-defined tags from the source snapshot or AMI to the cross-Region copy.</p>', 'PolicyDetails$CopyTags' => '<p> <b>[Default policies only]</b> Indicates whether the policy should copy tags from the source resource to the snapshot or AMI. If you do not specify a value, the default is <code>false</code>.</p> <p>Default: false</p>', 'UpdateLifecyclePolicyRequest$CopyTags' => '<p> <b>[Default policies only]</b> Indicates whether the policy should copy tags from the source resource to the snapshot or AMI.</p>', ], ], 'Count' => [ 'base' => NULL, 'refs' => [ 'DeprecateRule$Count' => '<p>If the schedule has a count-based retention rule, this parameter specifies the number of oldest AMIs to deprecate. The count must be less than or equal to the schedule\'s retention count, and it can\'t be greater than 1000.</p>', 'FastRestoreRule$Count' => '<p>The number of snapshots to be enabled with fast snapshot restore.</p>', 'RetentionArchiveTier$Count' => '<p>The maximum number of snapshots to retain in the archive storage tier for each volume. The count must ensure that each snapshot remains in the archive tier for at least 90 days. For example, if the schedule creates snapshots every 30 days, you must specify a count of 3 or more to ensure that each snapshot is archived for at least 90 days.</p>', ], ], 'CreateInterval' => [ 'base' => NULL, 'refs' => [ 'CreateLifecyclePolicyRequest$CreateInterval' => '<p> <b>[Default policies only]</b> Specifies how often the policy should run and create snapshots or AMIs. The creation frequency can range from 1 to 7 days. If you do not specify a value, the default is 1.</p> <p>Default: 1</p>', 'PolicyDetails$CreateInterval' => '<p> <b>[Default policies only]</b> Specifies how often the policy should run and create snapshots or AMIs. The creation frequency can range from 1 to 7 days. If you do not specify a value, the default is 1.</p> <p>Default: 1</p>', 'UpdateLifecyclePolicyRequest$CreateInterval' => '<p> <b>[Default policies only]</b> Specifies how often the policy should run and create snapshots or AMIs. The creation frequency can range from 1 to 7 days.</p>', ], ], 'CreateLifecyclePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateLifecyclePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateRule' => [ 'base' => '<p> <b>[Custom snapshot and AMI policies only]</b> Specifies when the policy should create snapshots or AMIs.</p> <note> <ul> <li> <p>You must specify either <b>CronExpression</b>, or <b>Interval</b>, <b>IntervalUnit</b>, and <b>Times</b>.</p> </li> <li> <p>If you need to specify an <a href="https://docs.aws.amazon.com/dlm/latest/APIReference/API_ArchiveRule.html">ArchiveRule</a> for the schedule, then you must specify a creation frequency of at least 28 days.</p> </li> </ul> </note>', 'refs' => [ 'Schedule$CreateRule' => '<p>The creation rule.</p>', ], ], 'CronExpression' => [ 'base' => NULL, 'refs' => [ 'CreateRule$CronExpression' => '<p>The schedule, as a Cron expression. The schedule interval must be between 1 hour and 1 year. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions">Cron expressions</a> in the <i>Amazon CloudWatch User Guide</i>.</p>', ], ], 'CrossRegionCopyAction' => [ 'base' => '<p> <b>[Event-based policies only]</b> Specifies a cross-Region copy action for event-based policies.</p> <note> <p>To specify a cross-Region copy rule for snapshot and AMI policies, use <a href="https://docs.aws.amazon.com/dlm/latest/APIReference/API_CrossRegionCopyRule.html">CrossRegionCopyRule</a>.</p> </note>', 'refs' => [ 'CrossRegionCopyActionList$member' => NULL, ], ], 'CrossRegionCopyActionList' => [ 'base' => NULL, 'refs' => [ 'Action$CrossRegionCopy' => '<p>The rule for copying shared snapshots across Regions.</p>', ], ], 'CrossRegionCopyDeprecateRule' => [ 'base' => '<p> <b>[Custom AMI policies only]</b> Specifies an AMI deprecation rule for cross-Region AMI copies created by an AMI policy.</p>', 'refs' => [ 'CrossRegionCopyRule$DeprecateRule' => '<p> <b>[Custom AMI policies only]</b> The AMI deprecation rule for cross-Region AMI copies created by the rule.</p>', ], ], 'CrossRegionCopyRetainRule' => [ 'base' => '<p>Specifies a retention rule for cross-Region snapshot copies created by snapshot or event-based policies, or cross-Region AMI copies created by AMI policies. After the retention period expires, the cross-Region copy is deleted.</p>', 'refs' => [ 'CrossRegionCopyAction$RetainRule' => NULL, 'CrossRegionCopyRule$RetainRule' => '<p>The retention rule that indicates how long the cross-Region snapshot or AMI copies are to be retained in the destination Region.</p>', ], ], 'CrossRegionCopyRule' => [ 'base' => '<p> <b>[Custom snapshot and AMI policies only]</b> Specifies a cross-Region copy rule for a snapshot and AMI policies.</p> <note> <p>To specify a cross-Region copy action for event-based polices, use <a href="https://docs.aws.amazon.com/dlm/latest/APIReference/API_CrossRegionCopyAction.html">CrossRegionCopyAction</a>.</p> </note>', 'refs' => [ 'CrossRegionCopyRules$member' => NULL, ], ], 'CrossRegionCopyRules' => [ 'base' => NULL, 'refs' => [ 'Schedule$CrossRegionCopyRules' => '<p>Specifies a rule for copying snapshots or AMIs across regions.</p> <note> <p>You can\'t specify cross-Region copy rules for policies that create snapshots on an Outpost. If the policy creates snapshots in a Region, then snapshots can be copied to up to three Regions or Outposts.</p> </note>', ], ], 'CrossRegionCopyTarget' => [ 'base' => '<p> <b>[Default policies only]</b> Specifies a destination Region for cross-Region copy actions.</p>', 'refs' => [ 'CrossRegionCopyTargetList$member' => NULL, ], ], 'CrossRegionCopyTargetList' => [ 'base' => NULL, 'refs' => [ 'CreateLifecyclePolicyRequest$CrossRegionCopyTargets' => '<p> <b>[Default policies only]</b> Specifies destination Regions for snapshot or AMI copies. You can specify up to 3 destination Regions. If you do not want to create cross-Region copies, omit this parameter.</p>', 'PolicyDetails$CrossRegionCopyTargets' => '<p> <b>[Default policies only]</b> Specifies destination Regions for snapshot or AMI copies. You can specify up to 3 destination Regions. If you do not want to create cross-Region copies, omit this parameter.</p>', 'UpdateLifecyclePolicyRequest$CrossRegionCopyTargets' => '<p> <b>[Default policies only]</b> Specifies destination Regions for snapshot or AMI copies. You can specify up to 3 destination Regions. If you do not want to create cross-Region copies, omit this parameter.</p>', ], ], 'DefaultPoliciesTypeValues' => [ 'base' => NULL, 'refs' => [ 'GetLifecyclePoliciesRequest$DefaultPolicyType' => '<p> <b>[Default policies only]</b> Specifies the type of default policy to get. Specify one of the following:</p> <ul> <li> <p> <code>VOLUME</code> - To get only the default policy for EBS snapshots</p> </li> <li> <p> <code>INSTANCE</code> - To get only the default policy for EBS-backed AMIs</p> </li> <li> <p> <code>ALL</code> - To get all default policies</p> </li> </ul>', ], ], 'DefaultPolicy' => [ 'base' => NULL, 'refs' => [ 'LifecyclePolicy$DefaultPolicy' => '<p> <b>[Default policies only]</b> The type of default policy. Values include:</p> <ul> <li> <p> <code>VOLUME</code> - Default policy for EBS snapshots</p> </li> <li> <p> <code>INSTANCE</code> - Default policy for EBS-backed AMIs</p> </li> </ul>', 'LifecyclePolicySummary$DefaultPolicy' => '<p> <b>[Default policies only]</b> The type of default policy. Values include:</p> <ul> <li> <p> <code>VOLUME</code> - Default policy for EBS snapshots</p> </li> <li> <p> <code>INSTANCE</code> - Default policy for EBS-backed AMIs</p> </li> </ul>', ], ], 'DefaultPolicyTypeValues' => [ 'base' => NULL, 'refs' => [ 'CreateLifecyclePolicyRequest$DefaultPolicy' => '<p> <b>[Default policies only]</b> Specify the type of default policy to create.</p> <ul> <li> <p>To create a default policy for EBS snapshots, that creates snapshots of all volumes in the Region that do not have recent backups, specify <code>VOLUME</code>.</p> </li> <li> <p>To create a default policy for EBS-backed AMIs, that creates EBS-backed AMIs from all instances in the Region that do not have recent backups, specify <code>INSTANCE</code>.</p> </li> </ul>', ], ], 'DeleteLifecyclePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLifecyclePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeprecateRule' => [ 'base' => '<p> <b>[Custom AMI policies only]</b> Specifies an AMI deprecation rule for AMIs created by an AMI lifecycle policy.</p> <p>For age-based schedules, you must specify <b>Interval</b> and <b>IntervalUnit</b>. For count-based schedules, you must specify <b>Count</b>.</p>', 'refs' => [ 'Schedule$DeprecateRule' => '<p> <b>[Custom AMI policies only]</b> The AMI deprecation rule for the schedule.</p>', ], ], 'DescriptionRegex' => [ 'base' => NULL, 'refs' => [ 'EventParameters$DescriptionRegex' => '<p>The snapshot description that can trigger the policy. The description pattern is specified using a regular expression. The policy runs only if a snapshot with a description that matches the specified pattern is shared with your account.</p> <p>For example, specifying <code>^.*Created for policy: policy-1234567890abcdef0.*$</code> configures the policy to run only if snapshots created by policy <code>policy-1234567890abcdef0</code> are shared with your account.</p>', ], ], 'Encrypted' => [ 'base' => NULL, 'refs' => [ 'CrossRegionCopyRule$Encrypted' => '<p>To encrypt a copy of an unencrypted snapshot if encryption by default is not enabled, enable encryption using this parameter. Copies of encrypted snapshots are encrypted, even if this parameter is false or if encryption by default is not enabled.</p>', 'EncryptionConfiguration$Encrypted' => '<p>To encrypt a copy of an unencrypted snapshot when encryption by default is not enabled, enable encryption using this parameter. Copies of encrypted snapshots are encrypted, even if this parameter is false or when encryption by default is not enabled.</p>', ], ], 'EncryptionConfiguration' => [ 'base' => '<p> <b>[Event-based policies only]</b> Specifies the encryption settings for cross-Region snapshot copies created by event-based policies.</p>', 'refs' => [ 'CrossRegionCopyAction$EncryptionConfiguration' => '<p>The encryption settings for the copied snapshot.</p>', ], ], 'ErrorCode' => [ 'base' => NULL, 'refs' => [ 'InternalServerException$Code' => NULL, 'InvalidRequestException$Code' => NULL, 'LimitExceededException$Code' => NULL, 'ResourceNotFoundException$Code' => NULL, ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'InternalServerException$Message' => NULL, 'InvalidRequestException$Message' => NULL, 'LimitExceededException$Message' => NULL, 'ResourceNotFoundException$Message' => NULL, ], ], 'EventParameters' => [ 'base' => '<p> <b>[Event-based policies only]</b> Specifies an event that activates an event-based policy.</p>', 'refs' => [ 'EventSource$Parameters' => '<p>Information about the event.</p>', ], ], 'EventSource' => [ 'base' => '<p> <b>[Event-based policies only]</b> Specifies an event that activates an event-based policy.</p>', 'refs' => [ 'PolicyDetails$EventSource' => '<p> <b>[Event-based policies only]</b> The event that activates the event-based policy.</p>', ], ], 'EventSourceValues' => [ 'base' => NULL, 'refs' => [ 'EventSource$Type' => '<p>The source of the event. Currently only managed CloudWatch Events rules are supported.</p>', ], ], 'EventTypeValues' => [ 'base' => NULL, 'refs' => [ 'EventParameters$EventType' => '<p>The type of event. Currently, only snapshot sharing events are supported.</p>', ], ], 'ExcludeBootVolume' => [ 'base' => NULL, 'refs' => [ 'Parameters$ExcludeBootVolume' => '<p> <b>[Custom snapshot policies that target instances only]</b> Indicates whether to exclude the root volume from multi-volume snapshot sets. The default is <code>false</code>. If you specify <code>true</code>, then the root volumes attached to targeted instances will be excluded from the multi-volume snapshot sets created by the policy.</p>', ], ], 'ExcludeBootVolumes' => [ 'base' => NULL, 'refs' => [ 'Exclusions$ExcludeBootVolumes' => '<p> <b>[Default policies for EBS snapshots only]</b> Indicates whether to exclude volumes that are attached to instances as the boot volume. If you exclude boot volumes, only volumes attached as data (non-boot) volumes will be backed up by the policy. To exclude boot volumes, specify <code>true</code>.</p>', ], ], 'ExcludeDataVolumeTagList' => [ 'base' => NULL, 'refs' => [ 'Parameters$ExcludeDataVolumeTags' => '<p> <b>[Custom snapshot policies that target instances only]</b> The tags used to identify data (non-root) volumes to exclude from multi-volume snapshot sets.</p> <p>If you create a snapshot lifecycle policy that targets instances and you specify tags for this parameter, then data volumes with the specified tags that are attached to targeted instances will be excluded from the multi-volume snapshot sets created by the policy.</p>', ], ], 'ExcludeTagsList' => [ 'base' => NULL, 'refs' => [ 'Exclusions$ExcludeTags' => '<p> <b>[Default policies for EBS-backed AMIs only]</b> Specifies whether to exclude volumes that have specific tags. </p>', ], ], 'ExcludeVolumeTypesList' => [ 'base' => NULL, 'refs' => [ 'Exclusions$ExcludeVolumeTypes' => '<p> <b>[Default policies for EBS snapshots only]</b> Specifies the volume types to exclude. Volumes of the specified types will not be targeted by the policy.</p>', ], ], 'Exclusions' => [ 'base' => '<p> <b>[Default policies only]</b> Specifies exclusion parameters for volumes or instances for which you do not want to create snapshots or AMIs. The policy will not create snapshots or AMIs for target resources that match any of the specified exclusion parameters.</p>', 'refs' => [ 'CreateLifecyclePolicyRequest$Exclusions' => '<p> <b>[Default policies only]</b> Specifies exclusion parameters for volumes or instances for which you do not want to create snapshots or AMIs. The policy will not create snapshots or AMIs for target resources that match any of the specified exclusion parameters.</p>', 'PolicyDetails$Exclusions' => '<p> <b>[Default policies only]</b> Specifies exclusion parameters for volumes or instances for which you do not want to create snapshots or AMIs. The policy will not create snapshots or AMIs for target resources that match any of the specified exclusion parameters.</p>', 'UpdateLifecyclePolicyRequest$Exclusions' => '<p> <b>[Default policies only]</b> Specifies exclusion parameters for volumes or instances for which you do not want to create snapshots or AMIs. The policy will not create snapshots or AMIs for target resources that match any of the specified exclusion parameters.</p>', ], ], 'ExecuteOperationOnScriptFailure' => [ 'base' => NULL, 'refs' => [ 'Script$ExecuteOperationOnScriptFailure' => '<p>Indicates whether Amazon Data Lifecycle Manager should default to crash-consistent snapshots if the pre script fails.</p> <ul> <li> <p>To default to crash consistent snapshot if the pre script fails, specify <code>true</code>.</p> </li> <li> <p>To skip the instance for snapshot creation if the pre script fails, specify <code>false</code>.</p> </li> </ul> <p>This parameter is supported only if you run a pre script. If you run a post script only, omit this parameter.</p> <p>Default: true</p>', ], ], 'ExecutionHandler' => [ 'base' => NULL, 'refs' => [ 'Script$ExecutionHandler' => '<p>The SSM document that includes the pre and/or post scripts to run.</p> <ul> <li> <p>If you are automating VSS backups, specify <code>AWS_VSS_BACKUP</code>. In this case, Amazon Data Lifecycle Manager automatically uses the <code>AWSEC2-CreateVssSnapshot</code> SSM document.</p> </li> <li> <p>If you are automating application-consistent snapshots for SAP HANA workloads, specify <code>AWSSystemsManagerSAP-CreateDLMSnapshotForSAPHANA</code>.</p> </li> <li> <p>If you are using a custom SSM document that you own, specify either the name or ARN of the SSM document. If you are using a custom SSM document that is shared with you, specify the ARN of the SSM document.</p> </li> </ul>', ], ], 'ExecutionHandlerServiceValues' => [ 'base' => NULL, 'refs' => [ 'Script$ExecutionHandlerService' => '<p>Indicates the service used to execute the pre and/or post scripts.</p> <ul> <li> <p>If you are using custom SSM documents or automating application-consistent snapshots of SAP HANA workloads, specify <code>AWS_SYSTEMS_MANAGER</code>.</p> </li> <li> <p>If you are automating VSS Backups, omit this parameter.</p> </li> </ul> <p>Default: AWS_SYSTEMS_MANAGER</p>', ], ], 'ExecutionRoleArn' => [ 'base' => NULL, 'refs' => [ 'CreateLifecyclePolicyRequest$ExecutionRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role used to run the operations specified by the lifecycle policy.</p>', 'LifecyclePolicy$ExecutionRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role used to run the operations specified by the lifecycle policy.</p>', 'UpdateLifecyclePolicyRequest$ExecutionRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role used to run the operations specified by the lifecycle policy.</p>', ], ], 'ExtendDeletion' => [ 'base' => NULL, 'refs' => [ 'CreateLifecyclePolicyRequest$ExtendDeletion' => '<p> <b>[Default policies only]</b> Defines the snapshot or AMI retention behavior for the policy if the source volume or instance is deleted, or if the policy enters the error, disabled, or deleted state.</p> <p>By default (<b>ExtendDeletion=false</b>):</p> <ul> <li> <p>If a source resource is deleted, Amazon Data Lifecycle Manager will continue to delete previously created snapshots or AMIs, up to but not including the last one, based on the specified retention period. If you want Amazon Data Lifecycle Manager to delete all snapshots or AMIs, including the last one, specify <code>true</code>.</p> </li> <li> <p>If a policy enters the error, disabled, or deleted state, Amazon Data Lifecycle Manager stops deleting snapshots and AMIs. If you want Amazon Data Lifecycle Manager to continue deleting snapshots or AMIs, including the last one, if the policy enters one of these states, specify <code>true</code>.</p> </li> </ul> <p>If you enable extended deletion (<b>ExtendDeletion=true</b>), you override both default behaviors simultaneously.</p> <p>If you do not specify a value, the default is <code>false</code>.</p> <p>Default: false</p>', 'PolicyDetails$ExtendDeletion' => '<p> <b>[Default policies only]</b> Defines the snapshot or AMI retention behavior for the policy if the source volume or instance is deleted, or if the policy enters the error, disabled, or deleted state.</p> <p>By default (<b>ExtendDeletion=false</b>):</p> <ul> <li> <p>If a source resource is deleted, Amazon Data Lifecycle Manager will continue to delete previously created snapshots or AMIs, up to but not including the last one, based on the specified retention period. If you want Amazon Data Lifecycle Manager to delete all snapshots or AMIs, including the last one, specify <code>true</code>.</p> </li> <li> <p>If a policy enters the error, disabled, or deleted state, Amazon Data Lifecycle Manager stops deleting snapshots and AMIs. If you want Amazon Data Lifecycle Manager to continue deleting snapshots or AMIs, including the last one, if the policy enters one of these states, specify <code>true</code>.</p> </li> </ul> <p>If you enable extended deletion (<b>ExtendDeletion=true</b>), you override both default behaviors simultaneously.</p> <p>If you do not specify a value, the default is <code>false</code>.</p> <p>Default: false</p>', 'UpdateLifecyclePolicyRequest$ExtendDeletion' => '<p> <b>[Default policies only]</b> Defines the snapshot or AMI retention behavior for the policy if the source volume or instance is deleted, or if the policy enters the error, disabled, or deleted state.</p> <p>By default (<b>ExtendDeletion=false</b>):</p> <ul> <li> <p>If a source resource is deleted, Amazon Data Lifecycle Manager will continue to delete previously created snapshots or AMIs, up to but not including the last one, based on the specified retention period. If you want Amazon Data Lifecycle Manager to delete all snapshots or AMIs, including the last one, specify <code>true</code>.</p> </li> <li> <p>If a policy enters the error, disabled, or deleted state, Amazon Data Lifecycle Manager stops deleting snapshots and AMIs. If you want Amazon Data Lifecycle Manager to continue deleting snapshots or AMIs, including the last one, if the policy enters one of these states, specify <code>true</code>.</p> </li> </ul> <p>If you enable extended deletion (<b>ExtendDeletion=true</b>), you override both default behaviors simultaneously.</p> <p>Default: false</p>', ], ], 'FastRestoreRule' => [ 'base' => '<p> <b>[Custom snapshot policies only]</b> Specifies a rule for enabling fast snapshot restore for snapshots created by snapshot policies. You can enable fast snapshot restore based on either a count or a time interval.</p>', 'refs' => [ 'Schedule$FastRestoreRule' => '<p> <b>[Custom snapshot policies only]</b> The rule for enabling fast snapshot restore.</p>', ], ], 'GetLifecyclePoliciesRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetLifecyclePoliciesResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetLifecyclePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetLifecyclePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'GettablePolicyStateValues' => [ 'base' => NULL, 'refs' => [ 'GetLifecyclePoliciesRequest$State' => '<p>The activation state.</p>', 'LifecyclePolicy$State' => '<p>The activation state of the lifecycle policy.</p>', 'LifecyclePolicySummary$State' => '<p>The activation state of the lifecycle policy.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>The service failed in an unexpected way.</p>', 'refs' => [], ], 'Interval' => [ 'base' => NULL, 'refs' => [ 'CreateRule$Interval' => '<p>The interval between snapshots. The supported values are 1, 2, 3, 4, 6, 8, 12, and 24.</p>', 'CrossRegionCopyDeprecateRule$Interval' => '<p>The period after which to deprecate the cross-Region AMI copies. The period must be less than or equal to the cross-Region AMI copy retention period, and it can\'t be greater than 10 years. This is equivalent to 120 months, 520 weeks, or 3650 days.</p>', 'CrossRegionCopyRetainRule$Interval' => '<p>The amount of time to retain a cross-Region snapshot or AMI copy. The maximum is 100 years. This is equivalent to 1200 months, 5200 weeks, or 36500 days.</p>', 'DeprecateRule$Interval' => '<p>If the schedule has an age-based retention rule, this parameter specifies the period after which to deprecate AMIs created by the schedule. The period must be less than or equal to the schedule\'s retention period, and it can\'t be greater than 10 years. This is equivalent to 120 months, 520 weeks, or 3650 days.</p>', 'FastRestoreRule$Interval' => '<p>The amount of time to enable fast snapshot restore. The maximum is 100 years. This is equivalent to 1200 months, 5200 weeks, or 36500 days.</p>', 'RetentionArchiveTier$Interval' => '<p>Specifies the period of time to retain snapshots in the archive tier. After this period expires, the snapshot is permanently deleted.</p>', 'ShareRule$UnshareInterval' => '<p>The period after which snapshots that are shared with other Amazon Web Services accounts are automatically unshared.</p>', ], ], 'IntervalUnitValues' => [ 'base' => NULL, 'refs' => [ 'CreateRule$IntervalUnit' => '<p>The interval unit.</p>', ], ], 'InvalidRequestException' => [ 'base' => '<p>Bad request. The request is missing required parameters or has invalid parameters.</p>', 'refs' => [], ], 'LifecyclePolicy' => [ 'base' => '<p> <b>[Custom policies only]</b> Detailed information about a snapshot, AMI, or event-based lifecycle policy.</p>', 'refs' => [ 'GetLifecyclePolicyResponse$Policy' => '<p>Detailed information about the lifecycle policy.</p>', ], ], 'LifecyclePolicySummary' => [ 'base' => '<p>Summary information about a lifecycle policy.</p>', 'refs' => [ 'LifecyclePolicySummaryList$member' => NULL, ], ], 'LifecyclePolicySummaryList' => [ 'base' => NULL, 'refs' => [ 'GetLifecyclePoliciesResponse$Policies' => '<p>Summary information about the lifecycle policies.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>The request failed because a limit was exceeded.</p>', 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'LocationValues' => [ 'base' => NULL, 'refs' => [ 'CreateRule$Location' => '<p> <b>[Custom snapshot policies only]</b> Specifies the destination for snapshots created by the policy. To create snapshots in the same Region as the source resource, specify <code>CLOUD</code>. To create snapshots on the same Outpost as the source resource, specify <code>OUTPOST_LOCAL</code>. If you omit this parameter, <code>CLOUD</code> is used by default.</p> <p>If the policy targets resources in an Amazon Web Services Region, then you must create snapshots in the same Region as the source resource. If the policy targets resources on an Outpost, then you can create snapshots on the same Outpost as the source resource, or in the Region of that Outpost.</p>', ], ], 'NoReboot' => [ 'base' => NULL, 'refs' => [ 'Parameters$NoReboot' => '<p> <b>[Custom AMI policies only]</b> Indicates whether targeted instances are rebooted when the lifecycle policy runs. <code>true</code> indicates that targeted instances are not rebooted when the policy runs. <code>false</code> indicates that target instances are rebooted when the policy runs. The default is <code>true</code> (instances are not rebooted).</p>', ], ], 'Parameter' => [ 'base' => NULL, 'refs' => [ 'ParameterList$member' => NULL, ], ], 'ParameterList' => [ 'base' => NULL, 'refs' => [ 'InvalidRequestException$RequiredParameters' => '<p>The request omitted one or more required parameters.</p>', 'InvalidRequestException$MutuallyExclusiveParameters' => '<p>The request included parameters that cannot be provided together.</p>', ], ], 'Parameters' => [ 'base' => '<p> <b>[Custom snapshot and AMI policies only]</b> Specifies optional parameters for snapshot and AMI policies. The set of valid parameters depends on the combination of policy type and target resource type.</p> <p>If you choose to exclude boot volumes and you specify tags that consequently exclude all of the additional data volumes attached to an instance, then Amazon Data Lifecycle Manager will not create any snapshots for the affected instance, and it will emit a <code>SnapshotsCreateFailed</code> Amazon CloudWatch metric. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitor-dlm-cw-metrics.html">Monitor your policies using Amazon CloudWatch</a>.</p>', 'refs' => [ 'PolicyDetails$Parameters' => '<p> <b>[Custom snapshot and AMI policies only]</b> A set of optional parameters for snapshot and AMI lifecycle policies. </p> <note> <p>If you are modifying a policy that was created or previously modified using the Amazon Data Lifecycle Manager console, then you must include this parameter and specify either the default values or the new values that you require. You can\'t omit this parameter or set its values to null.</p> </note>', ], ], 'PolicyArn' => [ 'base' => NULL, 'refs' => [ 'LifecyclePolicy$PolicyArn' => '<p>The Amazon Resource Name (ARN) of the policy.</p>', 'ListTagsForResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'TagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'UntagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', ], ], 'PolicyDescription' => [ 'base' => NULL, 'refs' => [ 'CreateLifecyclePolicyRequest$Description' => '<p>A description of the lifecycle policy. The characters ^[0-9A-Za-z _-]+$ are supported.</p>', 'LifecyclePolicy$Description' => '<p>The description of the lifecycle policy.</p>', 'LifecyclePolicySummary$Description' => '<p>The description of the lifecycle policy.</p>', 'UpdateLifecyclePolicyRequest$Description' => '<p>A description of the lifecycle policy.</p>', ], ], 'PolicyDetails' => [ 'base' => '<p>Specifies the configuration of a lifecycle policy.</p>', 'refs' => [ 'CreateLifecyclePolicyRequest$PolicyDetails' => '<p>The configuration details of the lifecycle policy.</p> <important> <p>If you create a default policy, you can specify the request parameters either in the request body, or in the PolicyDetails request structure, but not both.</p> </important>', 'LifecyclePolicy$PolicyDetails' => '<p>The configuration of the lifecycle policy</p>', 'UpdateLifecyclePolicyRequest$PolicyDetails' => '<p>The configuration of the lifecycle policy. You cannot update the policy type or the resource type.</p>', ], ], 'PolicyId' => [ 'base' => NULL, 'refs' => [ 'CreateLifecyclePolicyResponse$PolicyId' => '<p>The identifier of the lifecycle policy.</p>', 'DeleteLifecyclePolicyRequest$PolicyId' => '<p>The identifier of the lifecycle policy.</p>', 'GetLifecyclePolicyRequest$PolicyId' => '<p>The identifier of the lifecycle policy.</p>', 'LifecyclePolicy$PolicyId' => '<p>The identifier of the lifecycle policy.</p>', 'LifecyclePolicySummary$PolicyId' => '<p>The identifier of the lifecycle policy.</p>', 'PolicyIdList$member' => NULL, 'UpdateLifecyclePolicyRequest$PolicyId' => '<p>The identifier of the lifecycle policy.</p>', ], ], 'PolicyIdList' => [ 'base' => NULL, 'refs' => [ 'GetLifecyclePoliciesRequest$PolicyIds' => '<p>The identifiers of the data lifecycle policies.</p>', 'ResourceNotFoundException$ResourceIds' => '<p>Value is a list of resource IDs that were not found.</p>', ], ], 'PolicyLanguageValues' => [ 'base' => NULL, 'refs' => [ 'PolicyDetails$PolicyLanguage' => '<p>The type of policy to create. Specify one of the following:</p> <ul> <li> <p> <code>SIMPLIFIED</code> To create a default policy.</p> </li> <li> <p> <code>STANDARD</code> To create a custom policy.</p> </li> </ul>', ], ], 'PolicyTypeValues' => [ 'base' => NULL, 'refs' => [ 'LifecyclePolicySummary$PolicyType' => '<p>The type of policy. <code>EBS_SNAPSHOT_MANAGEMENT</code> indicates that the policy manages the lifecycle of Amazon EBS snapshots. <code>IMAGE_MANAGEMENT</code> indicates that the policy manages the lifecycle of EBS-backed AMIs. <code>EVENT_BASED_POLICY</code> indicates that the policy automates cross-account snapshot copies for snapshots that are shared with your account.</p>', 'PolicyDetails$PolicyType' => '<p> <b>[Custom policies only]</b> The valid target resource types and actions a policy can manage. Specify <code>EBS_SNAPSHOT_MANAGEMENT</code> to create a lifecycle policy that manages the lifecycle of Amazon EBS snapshots. Specify <code>IMAGE_MANAGEMENT</code> to create a lifecycle policy that manages the lifecycle of EBS-backed AMIs. Specify <code>EVENT_BASED_POLICY </code> to create an event-based policy that performs specific actions when a defined event occurs in your Amazon Web Services account.</p> <p>The default is <code>EBS_SNAPSHOT_MANAGEMENT</code>.</p>', ], ], 'ResourceLocationList' => [ 'base' => NULL, 'refs' => [ 'PolicyDetails$ResourceLocations' => '<p> <b>[Custom snapshot and AMI policies only]</b> The location of the resources to backup. If the source resources are located in an Amazon Web Services Region, specify <code>CLOUD</code>. If the source resources are located on an Outpost in your account, specify <code>OUTPOST</code>.</p> <p>If you specify <code>OUTPOST</code>, Amazon Data Lifecycle Manager backs up all resources of the specified type with matching target tags across all of the Outposts in your account.</p>', ], ], 'ResourceLocationValues' => [ 'base' => NULL, 'refs' => [ 'ResourceLocationList$member' => NULL, ], ], 'ResourceNotFoundException' => [ 'base' => '<p>A requested resource was not found.</p>', 'refs' => [], ], 'ResourceTypeValues' => [ 'base' => NULL, 'refs' => [ 'PolicyDetails$ResourceType' => '<p> <b>[Default policies only]</b> Specify the type of default policy to create.</p> <ul> <li> <p>To create a default policy for EBS snapshots, that creates snapshots of all volumes in the Region that do not have recent backups, specify <code>VOLUME</code>.</p> </li> <li> <p>To create a default policy for EBS-backed AMIs, that creates EBS-backed AMIs from all instances in the Region that do not have recent backups, specify <code>INSTANCE</code>.</p> </li> </ul>', 'ResourceTypeValuesList$member' => NULL, ], ], 'ResourceTypeValuesList' => [ 'base' => NULL, 'refs' => [ 'GetLifecyclePoliciesRequest$ResourceTypes' => '<p>The resource type.</p>', 'PolicyDetails$ResourceTypes' => '<p> <b>[Custom snapshot policies only]</b> The target resource type for snapshot and AMI lifecycle policies. Use <code>VOLUME </code>to create snapshots of individual volumes or use <code>INSTANCE</code> to create multi-volume snapshots from the volumes for an instance.</p>', ], ], 'RetainInterval' => [ 'base' => NULL, 'refs' => [ 'CreateLifecyclePolicyRequest$RetainInterval' => '<p> <b>[Default policies only]</b> Specifies how long the policy should retain snapshots or AMIs before deleting them. The retention period can range from 2 to 14 days, but it must be greater than the creation frequency to ensure that the policy retains at least 1 snapshot or AMI at any given time. If you do not specify a value, the default is 7.</p> <p>Default: 7</p>', 'PolicyDetails$RetainInterval' => '<p> <b>[Default policies only]</b> Specifies how long the policy should retain snapshots or AMIs before deleting them. The retention period can range from 2 to 14 days, but it must be greater than the creation frequency to ensure that the policy retains at least 1 snapshot or AMI at any given time. If you do not specify a value, the default is 7.</p> <p>Default: 7</p>', 'UpdateLifecyclePolicyRequest$RetainInterval' => '<p> <b>[Default policies only]</b> Specifies how long the policy should retain snapshots or AMIs before deleting them. The retention period can range from 2 to 14 days, but it must be greater than the creation frequency to ensure that the policy retains at least 1 snapshot or AMI at any given time.</p>', ], ], 'RetainRule' => [ 'base' => '<p> <b>[Custom snapshot and AMI policies only]</b> Specifies a retention rule for snapshots created by snapshot policies, or for AMIs created by AMI policies.</p> <note> <p>For snapshot policies that have an <a href="https://docs.aws.amazon.com/dlm/latest/APIReference/API_ArchiveRule.html">ArchiveRule</a>, this retention rule applies to standard tier retention. When the retention threshold is met, snapshots are moved from the standard to the archive tier.</p> <p>For snapshot policies that do not have an <b>ArchiveRule</b>, snapshots are permanently deleted when this retention threshold is met.</p> </note> <p>You can retain snapshots based on either a count or a time interval.</p> <ul> <li> <p> <b>Count-based retention</b> </p> <p>You must specify <b>Count</b>. If you specify an <a href="https://docs.aws.amazon.com/dlm/latest/APIReference/API_ArchiveRule.html">ArchiveRule</a> for the schedule, then you can specify a retention count of <code>0</code> to archive snapshots immediately after creation. If you specify a <a href="https://docs.aws.amazon.com/dlm/latest/APIReference/API_FastRestoreRule.html">FastRestoreRule</a>, <a href="https://docs.aws.amazon.com/dlm/latest/APIReference/API_ShareRule.html">ShareRule</a>, or a <a href="https://docs.aws.amazon.com/dlm/latest/APIReference/API_CrossRegionCopyRule.html">CrossRegionCopyRule</a>, then you must specify a retention count of <code>1</code> or more.</p> </li> <li> <p> <b>Age-based retention</b> </p> <p>You must specify <b>Interval</b> and <b>IntervalUnit</b>. If you specify an <a href="https://docs.aws.amazon.com/dlm/latest/APIReference/API_ArchiveRule.html">ArchiveRule</a> for the schedule, then you can specify a retention interval of <code>0</code> days to archive snapshots immediately after creation. If you specify a <a href="https://docs.aws.amazon.com/dlm/latest/APIReference/API_FastRestoreRule.html">FastRestoreRule</a>, <a href="https://docs.aws.amazon.com/dlm/latest/APIReference/API_ShareRule.html">ShareRule</a>, or a <a href="https://docs.aws.amazon.com/dlm/latest/APIReference/API_CrossRegionCopyRule.html">CrossRegionCopyRule</a>, then you must specify a retention interval of <code>1</code> day or more.</p> </li> </ul>', 'refs' => [ 'Schedule$RetainRule' => '<p>The retention rule for snapshots or AMIs created by the policy.</p>', ], ], 'RetentionArchiveTier' => [ 'base' => '<p> <b>[Custom snapshot policies only]</b> Describes the retention rule for archived snapshots. Once the archive retention threshold is met, the snapshots are permanently deleted from the archive tier.</p> <note> <p>The archive retention rule must retain snapshots in the archive tier for a minimum of 90 days.</p> </note> <p>For <b>count-based schedules</b>, you must specify <b>Count</b>. For <b>age-based schedules</b>, you must specify <b>Interval</b> and <b> IntervalUnit</b>.</p> <p>For more information about using snapshot archiving, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshot-ami-policy.html#dlm-archive">Considerations for snapshot lifecycle policies</a>.</p>', 'refs' => [ 'ArchiveRetainRule$RetentionArchiveTier' => '<p>Information about retention period in the Amazon EBS Snapshots Archive. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/snapshot-archive.html">Archive Amazon EBS snapshots</a>.</p>', ], ], 'RetentionIntervalUnitValues' => [ 'base' => NULL, 'refs' => [ 'CrossRegionCopyDeprecateRule$IntervalUnit' => '<p>The unit of time in which to measure the <b>Interval</b>. For example, to deprecate a cross-Region AMI copy after 3 months, specify <code>Interval=3</code> and <code>IntervalUnit=MONTHS</code>.</p>', 'CrossRegionCopyRetainRule$IntervalUnit' => '<p>The unit of time for time-based retention. For example, to retain a cross-Region copy for 3 months, specify <code>Interval=3</code> and <code>IntervalUnit=MONTHS</code>.</p>', 'DeprecateRule$IntervalUnit' => '<p>The unit of time in which to measure the <b>Interval</b>.</p>', 'FastRestoreRule$IntervalUnit' => '<p>The unit of time for enabling fast snapshot restore.</p>', 'RetainRule$IntervalUnit' => '<p>The unit of time for time-based retention. For example, to retain snapshots for 3 months, specify <code>Interval=3</code> and <code>IntervalUnit=MONTHS</code>. Once the snapshot has been retained for 3 months, it is deleted, or it is moved to the archive tier if you have specified an <a href="https://docs.aws.amazon.com/dlm/latest/APIReference/API_ArchiveRule.html">ArchiveRule</a>.</p>', 'RetentionArchiveTier$IntervalUnit' => '<p>The unit of time in which to measure the <b>Interval</b>. For example, to retain a snapshots in the archive tier for 6 months, specify <code>Interval=6</code> and <code>IntervalUnit=MONTHS</code>.</p>', 'ShareRule$UnshareIntervalUnit' => '<p>The unit of time for the automatic unsharing interval.</p>', ], ], 'Schedule' => [ 'base' => '<p> <b>[Custom snapshot and AMI policies only]</b> Specifies a schedule for a snapshot or AMI lifecycle policy.</p>', 'refs' => [ 'ScheduleList$member' => NULL, ], ], 'ScheduleList' => [ 'base' => NULL, 'refs' => [ 'PolicyDetails$Schedules' => '<p> <b>[Custom snapshot and AMI policies only]</b> The schedules of policy-defined actions for snapshot and AMI lifecycle policies. A policy can have up to four schedules—one mandatory schedule and up to three optional schedules.</p>', ], ], 'ScheduleName' => [ 'base' => NULL, 'refs' => [ 'Schedule$Name' => '<p>The name of the schedule.</p>', ], ], 'Script' => [ 'base' => '<p> <b>[Custom snapshot policies that target instances only]</b> Information about pre and/or post scripts for a snapshot lifecycle policy that targets instances. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/automate-app-consistent-backups.html"> Automating application-consistent snapshots with pre and post scripts</a>.</p>', 'refs' => [ 'ScriptsList$member' => NULL, ], ], 'ScriptExecutionTimeout' => [ 'base' => NULL, 'refs' => [ 'Script$ExecutionTimeout' => '<p>Specifies a timeout period, in seconds, after which Amazon Data Lifecycle Manager fails the script run attempt if it has not completed. If a script does not complete within its timeout period, Amazon Data Lifecycle Manager fails the attempt. The timeout period applies to the pre and post scripts individually. </p> <p>If you are automating VSS Backups, omit this parameter.</p> <p>Default: 10</p>', ], ], 'ScriptMaximumRetryCount' => [ 'base' => NULL, 'refs' => [ 'Script$MaximumRetryCount' => '<p>Specifies the number of times Amazon Data Lifecycle Manager should retry scripts that fail.</p> <ul> <li> <p>If the pre script fails, Amazon Data Lifecycle Manager retries the entire snapshot creation process, including running the pre and post scripts.</p> </li> <li> <p>If the post script fails, Amazon Data Lifecycle Manager retries the post script only; in this case, the pre script will have completed and the snapshot might have been created.</p> </li> </ul> <p>If you do not want Amazon Data Lifecycle Manager to retry failed scripts, specify <code>0</code>.</p> <p>Default: 0</p>', ], ], 'ScriptsList' => [ 'base' => NULL, 'refs' => [ 'CreateRule$Scripts' => '<p> <b>[Custom snapshot policies that target instances only]</b> Specifies pre and/or post scripts for a snapshot lifecycle policy that targets instances. This is useful for creating application-consistent snapshots, or for performing specific administrative tasks before or after Amazon Data Lifecycle Manager initiates snapshot creation.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/automate-app-consistent-backups.html">Automating application-consistent snapshots with pre and post scripts</a>.</p>', ], ], 'SettablePolicyStateValues' => [ 'base' => NULL, 'refs' => [ 'CreateLifecyclePolicyRequest$State' => '<p>The activation state of the lifecycle policy after creation.</p>', 'UpdateLifecyclePolicyRequest$State' => '<p>The desired activation state of the lifecycle policy after creation.</p>', ], ], 'ShareRule' => [ 'base' => '<p> <b>[Custom snapshot policies only]</b> Specifies a rule for sharing snapshots across Amazon Web Services accounts.</p>', 'refs' => [ 'ShareRules$member' => NULL, ], ], 'ShareRules' => [ 'base' => NULL, 'refs' => [ 'Schedule$ShareRules' => '<p> <b>[Custom snapshot policies only]</b> The rule for sharing snapshots with other Amazon Web Services accounts.</p>', ], ], 'ShareTargetAccountList' => [ 'base' => NULL, 'refs' => [ 'ShareRule$TargetAccounts' => '<p>The IDs of the Amazon Web Services accounts with which to share the snapshots.</p>', ], ], 'SnapshotOwnerList' => [ 'base' => NULL, 'refs' => [ 'EventParameters$SnapshotOwner' => '<p>The IDs of the Amazon Web Services accounts that can trigger policy by sharing snapshots with your account. The policy only runs if one of the specified Amazon Web Services accounts shares a snapshot with your account.</p>', ], ], 'StageValues' => [ 'base' => NULL, 'refs' => [ 'StagesList$member' => NULL, ], ], 'StagesList' => [ 'base' => NULL, 'refs' => [ 'Script$Stages' => '<p>Indicate which scripts Amazon Data Lifecycle Manager should run on target instances. Pre scripts run before Amazon Data Lifecycle Manager initiates snapshot creation. Post scripts run after Amazon Data Lifecycle Manager initiates snapshot creation.</p> <ul> <li> <p>To run a pre script only, specify <code>PRE</code>. In this case, Amazon Data Lifecycle Manager calls the SSM document with the <code>pre-script</code> parameter before initiating snapshot creation.</p> </li> <li> <p>To run a post script only, specify <code>POST</code>. In this case, Amazon Data Lifecycle Manager calls the SSM document with the <code>post-script</code> parameter after initiating snapshot creation.</p> </li> <li> <p>To run both pre and post scripts, specify both <code>PRE</code> and <code>POST</code>. In this case, Amazon Data Lifecycle Manager calls the SSM document with the <code>pre-script</code> parameter before initiating snapshot creation, and then it calls the SSM document again with the <code>post-script</code> parameter after initiating snapshot creation.</p> </li> </ul> <p>If you are automating VSS Backups, omit this parameter.</p> <p>Default: PRE and POST</p>', ], ], 'StandardTierRetainRuleCount' => [ 'base' => NULL, 'refs' => [ 'RetainRule$Count' => '<p>The number of snapshots to retain for each volume, up to a maximum of 1000. For example if you want to retain a maximum of three snapshots, specify <code>3</code>. When the fourth snapshot is created, the oldest retained snapshot is deleted, or it is moved to the archive tier if you have specified an <a href="https://docs.aws.amazon.com/dlm/latest/APIReference/API_ArchiveRule.html">ArchiveRule</a>.</p>', ], ], 'StandardTierRetainRuleInterval' => [ 'base' => NULL, 'refs' => [ 'RetainRule$Interval' => '<p>The amount of time to retain each snapshot. The maximum is 100 years. This is equivalent to 1200 months, 5200 weeks, or 36500 days.</p>', ], ], 'StatusMessage' => [ 'base' => NULL, 'refs' => [ 'LifecyclePolicy$StatusMessage' => '<p>The description of the status.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'LimitExceededException$ResourceType' => '<p>Value is the type of resource for which a limit was exceeded.</p>', 'ResourceNotFoundException$ResourceType' => '<p>Value is the type of resource that was not found.</p>', 'Tag$Key' => '<p>The tag key.</p>', 'Tag$Value' => '<p>The tag value.</p>', ], ], 'Tag' => [ 'base' => '<p>Specifies a tag for a resource.</p>', 'refs' => [ 'ExcludeDataVolumeTagList$member' => NULL, 'ExcludeTagsList$member' => NULL, 'TagsToAddList$member' => NULL, 'TargetTagList$member' => NULL, 'VariableTagsList$member' => NULL, ], ], 'TagFilter' => [ 'base' => NULL, 'refs' => [ 'TagsToAddFilterList$member' => NULL, 'TargetTagsFilterList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'TagMap$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>The tag keys.</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'CreateLifecyclePolicyRequest$Tags' => '<p>The tags to apply to the lifecycle policy during creation.</p>', 'LifecyclePolicy$Tags' => '<p>The tags.</p>', 'LifecyclePolicySummary$Tags' => '<p>The tags.</p>', 'ListTagsForResourceResponse$Tags' => '<p>Information about the tags.</p>', 'TagResourceRequest$Tags' => '<p>One or more tags.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagMap$value' => NULL, ], ], 'TagsToAddFilterList' => [ 'base' => NULL, 'refs' => [ 'GetLifecyclePoliciesRequest$TagsToAdd' => '<p>The tags to add to objects created by the policy.</p> <p>Tags are strings in the format <code>key=value</code>.</p> <p>These user-defined tags are added in addition to the Amazon Web Services-added lifecycle tags.</p>', ], ], 'TagsToAddList' => [ 'base' => NULL, 'refs' => [ 'Schedule$TagsToAdd' => '<p>The tags to apply to policy-created resources. These user-defined tags are in addition to the Amazon Web Services-added lifecycle tags.</p>', ], ], 'Target' => [ 'base' => NULL, 'refs' => [ 'CrossRegionCopyAction$Target' => '<p>The target Region.</p>', 'CrossRegionCopyRule$Target' => '<note> <p>Use this parameter for snapshot policies only. For AMI policies, use <b>TargetRegion</b> instead.</p> </note> <p> <b>[Custom snapshot policies only]</b> The target Region or the Amazon Resource Name (ARN) of the target Outpost for the snapshot copies.</p>', ], ], 'TargetRegion' => [ 'base' => NULL, 'refs' => [ 'CrossRegionCopyRule$TargetRegion' => '<note> <p>Use this parameter for AMI policies only. For snapshot policies, use <b>Target</b> instead. For snapshot policies created before the <b>Target</b> parameter was introduced, this parameter indicates the target Region for snapshot copies.</p> <p/> </note> <p> <b>[Custom AMI policies only]</b> The target Region or the Amazon Resource Name (ARN) of the target Outpost for the snapshot copies.</p>', 'CrossRegionCopyTarget$TargetRegion' => '<p>The target Region, for example <code>us-east-1</code>.</p>', ], ], 'TargetTagList' => [ 'base' => NULL, 'refs' => [ 'PolicyDetails$TargetTags' => '<p> <b>[Custom snapshot and AMI policies only]</b> The single tag that identifies targeted resources for this policy.</p>', ], ], 'TargetTagsFilterList' => [ 'base' => NULL, 'refs' => [ 'GetLifecyclePoliciesRequest$TargetTags' => '<p>The target tag for a policy.</p> <p>Tags are strings in the format <code>key=value</code>.</p>', ], ], 'Time' => [ 'base' => NULL, 'refs' => [ 'TimesList$member' => NULL, ], ], 'TimesList' => [ 'base' => NULL, 'refs' => [ 'CreateRule$Times' => '<p>The time, in UTC, to start the operation. The supported format is hh:mm.</p> <p>The operation occurs within a one-hour window following the specified time. If you do not specify a time, Amazon Data Lifecycle Manager selects a time within the next 24 hours.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'LifecyclePolicy$DateCreated' => '<p>The local date and time when the lifecycle policy was created.</p>', 'LifecyclePolicy$DateModified' => '<p>The local date and time when the lifecycle policy was last modified.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLifecyclePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLifecyclePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'VariableTagsList' => [ 'base' => NULL, 'refs' => [ 'Schedule$VariableTags' => '<p> <b>[AMI policies and snapshot policies that target instances only]</b> A collection of key/value pairs with values determined dynamically when the policy is executed. Keys may be any valid Amazon EC2 tag key. Values must be in one of the two following formats: <code>$(instance-id)</code> or <code>$(timestamp)</code>. Variable tags are only valid for EBS Snapshot Management – Instance policies.</p>', ], ], 'VolumeTypeValues' => [ 'base' => NULL, 'refs' => [ 'ExcludeVolumeTypesList$member' => NULL, ], ], ],];
