<?php
// This file was auto-generated from sdk-root/src/data/ecr-public/2020-10-30/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Amazon Elastic Container Registry Public</fullname> <p>Amazon Elastic Container Registry Public (Amazon ECR Public) is a managed container image registry service. Amazon ECR provides both public and private registries to host your container images. You can use the Docker CLI or your preferred client to push, pull, and manage images. Amazon ECR provides a secure, scalable, and reliable registry for your Docker or Open Container Initiative (OCI) images. Amazon ECR supports public repositories with this API. For information about the Amazon ECR API for private repositories, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/APIReference/Welcome.html">Amazon Elastic Container Registry API Reference</a>.</p>', 'operations' => [ 'BatchCheckLayerAvailability' => '<p>Checks the availability of one or more image layers that are within a repository in a public registry. When an image is pushed to a repository, each image layer is checked to verify if it has been uploaded before. If it has been uploaded, then the image layer is skipped.</p> <note> <p>This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.</p> </note>', 'BatchDeleteImage' => '<p>Deletes a list of specified images that are within a repository in a public registry. Images are specified with either an <code>imageTag</code> or <code>imageDigest</code>.</p> <p>You can remove a tag from an image by specifying the image\'s tag in your request. When you remove the last tag from an image, the image is deleted from your repository.</p> <p>You can completely delete an image (and all of its tags) by specifying the digest of the image in your request.</p>', 'CompleteLayerUpload' => '<p>Informs Amazon ECR that the image layer upload is complete for a specified public registry, repository name, and upload ID. You can optionally provide a <code>sha256</code> digest of the image layer for data validation purposes.</p> <p>When an image is pushed, the CompleteLayerUpload API is called once for each new image layer to verify that the upload is complete.</p> <note> <p>This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.</p> </note>', 'CreateRepository' => '<p>Creates a repository in a public registry. For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/Repositories.html">Amazon ECR repositories</a> in the <i>Amazon Elastic Container Registry User Guide</i>.</p>', 'DeleteRepository' => '<p>Deletes a repository in a public registry. If the repository contains images, you must either manually delete all images in the repository or use the <code>force</code> option. This option deletes all images on your behalf before deleting the repository.</p>', 'DeleteRepositoryPolicy' => '<p>Deletes the repository policy that\'s associated with the specified repository.</p>', 'DescribeImageTags' => '<p>Returns the image tag details for a repository in a public registry.</p>', 'DescribeImages' => '<p>Returns metadata that\'s related to the images in a repository in a public registry.</p> <note> <p>Beginning with Docker version 1.9, the Docker client compresses image layers before pushing them to a V2 Docker registry. The output of the <code>docker images</code> command shows the uncompressed image size. Therefore, it might return a larger image size than the image sizes that are returned by <a>DescribeImages</a>.</p> </note>', 'DescribeRegistries' => '<p>Returns details for a public registry.</p>', 'DescribeRepositories' => '<p>Describes repositories that are in a public registry.</p>', 'GetAuthorizationToken' => '<p>Retrieves an authorization token. An authorization token represents your IAM authentication credentials. You can use it to access any Amazon ECR registry that your IAM principal has access to. The authorization token is valid for 12 hours. This API requires the <code>ecr-public:GetAuthorizationToken</code> and <code>sts:GetServiceBearerToken</code> permissions.</p>', 'GetRegistryCatalogData' => '<p>Retrieves catalog metadata for a public registry.</p>', 'GetRepositoryCatalogData' => '<p>Retrieve catalog metadata for a repository in a public registry. This metadata is displayed publicly in the Amazon ECR Public Gallery.</p>', 'GetRepositoryPolicy' => '<p>Retrieves the repository policy for the specified repository.</p>', 'InitiateLayerUpload' => '<p>Notifies Amazon ECR that you intend to upload an image layer.</p> <p>When an image is pushed, the InitiateLayerUpload API is called once for each image layer that hasn\'t already been uploaded. Whether an image layer uploads is determined by the BatchCheckLayerAvailability API action.</p> <note> <p>This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.</p> </note>', 'ListTagsForResource' => '<p>List the tags for an Amazon ECR Public resource.</p>', 'PutImage' => '<p>Creates or updates the image manifest and tags that are associated with an image.</p> <p>When an image is pushed and all new image layers have been uploaded, the PutImage API is called once to create or update the image manifest and the tags that are associated with the image.</p> <note> <p>This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.</p> </note>', 'PutRegistryCatalogData' => '<p>Create or update the catalog data for a public registry.</p>', 'PutRepositoryCatalogData' => '<p>Creates or updates the catalog data for a repository in a public registry.</p>', 'SetRepositoryPolicy' => '<p>Applies a repository policy to the specified public repository to control access permissions. For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-policies.html">Amazon ECR Repository Policies</a> in the <i>Amazon Elastic Container Registry User Guide</i>.</p>', 'TagResource' => '<p>Associates the specified tags to a resource with the specified <code>resourceArn</code>. If existing tags on a resource aren\'t specified in the request parameters, they aren\'t changed. When a resource is deleted, the tags associated with that resource are also deleted.</p>', 'UntagResource' => '<p>Deletes specified tags from a resource.</p>', 'UploadLayerPart' => '<p>Uploads an image layer part to Amazon ECR.</p> <p>When an image is pushed, each new image layer is uploaded in parts. The maximum size of each image layer part can be 20971520 bytes (about 20MB). The UploadLayerPart API is called once for each new image layer part.</p> <note> <p>This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.</p> </note>', ], 'shapes' => [ 'AboutText' => [ 'base' => NULL, 'refs' => [ 'RepositoryCatalogData$aboutText' => '<p>The longform description of the contents of the repository. This text appears in the repository details on the Amazon ECR Public Gallery.</p>', 'RepositoryCatalogDataInput$aboutText' => '<p>A detailed description of the contents of the repository. It\'s publicly visible in the Amazon ECR Public Gallery. The text must be in markdown format.</p>', ], ], 'Architecture' => [ 'base' => NULL, 'refs' => [ 'ArchitectureList$member' => NULL, ], ], 'ArchitectureList' => [ 'base' => NULL, 'refs' => [ 'RepositoryCatalogData$architectures' => '<p>The architecture tags that are associated with the repository.</p> <note> <p>Only supported operating system tags appear publicly in the Amazon ECR Public Gallery. For more information, see <a>RepositoryCatalogDataInput</a>.</p> </note>', 'RepositoryCatalogDataInput$architectures' => '<p>The system architecture that the images in the repository are compatible with. On the Amazon ECR Public Gallery, the following supported architectures appear as badges on the repository and are used as search filters.</p> <note> <p>If an unsupported tag is added to your repository catalog data, it\'s associated with the repository and can be retrieved using the API but isn\'t discoverable in the Amazon ECR Public Gallery.</p> </note> <ul> <li> <p> <code>ARM</code> </p> </li> <li> <p> <code>ARM 64</code> </p> </li> <li> <p> <code>x86</code> </p> </li> <li> <p> <code>x86-64</code> </p> </li> </ul>', ], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) that identifies the resource to list the tags for. Currently, the supported resource is an Amazon ECR Public repository.</p>', 'Registry$registryArn' => '<p>The Amazon Resource Name (ARN) of the public registry.</p>', 'Repository$repositoryArn' => '<p>The Amazon Resource Name (ARN) that identifies the repository. The ARN contains the <code>arn:aws:ecr</code> namespace, followed by the region of the repository, Amazon Web Services account ID of the repository owner, repository namespace, and repository name. For example, <code>arn:aws:ecr:region:012345678910:repository/test</code>.</p>', 'TagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource to add tags to. Currently, the supported resource is an Amazon ECR Public repository.</p>', 'UntagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource to delete tags from. Currently, the supported resource is an Amazon ECR Public repository.</p>', ], ], 'AuthorizationData' => [ 'base' => '<p>An authorization token data object that corresponds to a public registry.</p>', 'refs' => [ 'GetAuthorizationTokenResponse$authorizationData' => '<p>An authorization token data object that corresponds to a public registry.</p>', ], ], 'Base64' => [ 'base' => NULL, 'refs' => [ 'AuthorizationData$authorizationToken' => '<p>A base64-encoded string that contains authorization data for a public Amazon ECR registry. When the string is decoded, it\'s presented in the format <code>user:password</code> for public registry authentication using <code>docker login</code>.</p>', ], ], 'BatchCheckLayerAvailabilityRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchCheckLayerAvailabilityResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchDeleteImageRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchDeleteImageResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchedOperationLayerDigest' => [ 'base' => NULL, 'refs' => [ 'BatchedOperationLayerDigestList$member' => NULL, 'LayerFailure$layerDigest' => '<p>The layer digest that\'s associated with the failure.</p>', ], ], 'BatchedOperationLayerDigestList' => [ 'base' => NULL, 'refs' => [ 'BatchCheckLayerAvailabilityRequest$layerDigests' => '<p>The digests of the image layers to check.</p>', ], ], 'CompleteLayerUploadRequest' => [ 'base' => NULL, 'refs' => [], ], 'CompleteLayerUploadResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateRepositoryRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateRepositoryResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreationTimestamp' => [ 'base' => NULL, 'refs' => [ 'ImageTagDetail$createdAt' => '<p>The time stamp that indicates when the image tag was created.</p>', 'Repository$createdAt' => '<p>The date and time, in JavaScript date format, when the repository was created.</p>', ], ], 'DefaultRegistryAliasFlag' => [ 'base' => NULL, 'refs' => [ 'RegistryAlias$defaultRegistryAlias' => '<p>Indicates whether the registry alias is the default alias for the registry. When the first public repository is created, your public registry is assigned a default registry alias.</p>', ], ], 'DeleteRepositoryPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRepositoryPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRepositoryRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRepositoryResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeImageTagsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeImageTagsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeImagesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeImagesResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRegistriesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRegistriesResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRepositoriesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRepositoriesResponse' => [ 'base' => NULL, 'refs' => [], ], 'EmptyUploadException' => [ 'base' => '<p>The specified layer upload doesn\'t contain any layer parts.</p>', 'refs' => [], ], 'ExceptionMessage' => [ 'base' => NULL, 'refs' => [ 'EmptyUploadException$message' => NULL, 'ImageAlreadyExistsException$message' => NULL, 'ImageDigestDoesNotMatchException$message' => NULL, 'ImageNotFoundException$message' => NULL, 'ImageTagAlreadyExistsException$message' => NULL, 'InvalidLayerException$message' => NULL, 'InvalidLayerPartException$message' => NULL, 'InvalidParameterException$message' => NULL, 'InvalidTagParameterException$message' => NULL, 'LayerAlreadyExistsException$message' => NULL, 'LayerPartTooSmallException$message' => NULL, 'LayersNotFoundException$message' => NULL, 'LimitExceededException$message' => NULL, 'ReferencedImagesNotFoundException$message' => NULL, 'RegistryNotFoundException$message' => NULL, 'RepositoryAlreadyExistsException$message' => NULL, 'RepositoryCatalogDataNotFoundException$message' => NULL, 'RepositoryNotEmptyException$message' => NULL, 'RepositoryNotFoundException$message' => NULL, 'RepositoryPolicyNotFoundException$message' => NULL, 'ServerException$message' => NULL, 'TooManyTagsException$message' => NULL, 'UnsupportedCommandException$message' => NULL, 'UploadNotFoundException$message' => NULL, ], ], 'ExpirationTimestamp' => [ 'base' => NULL, 'refs' => [ 'AuthorizationData$expiresAt' => '<p>The Unix time in seconds and milliseconds when the authorization token expires. Authorization tokens are valid for 12 hours.</p>', ], ], 'ForceFlag' => [ 'base' => NULL, 'refs' => [ 'DeleteRepositoryRequest$force' => '<p> The force option can be used to delete a repository that contains images. If the force option is not used, the repository must be empty prior to deletion.</p>', 'SetRepositoryPolicyRequest$force' => '<p>If the policy that you want to set on a repository policy would prevent you from setting another policy in the future, you must force the <a>SetRepositoryPolicy</a> operation. This prevents accidental repository lockouts.</p>', ], ], 'GetAuthorizationTokenRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAuthorizationTokenResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetRegistryCatalogDataRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRegistryCatalogDataResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetRepositoryCatalogDataRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRepositoryCatalogDataResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetRepositoryPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRepositoryPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'Image' => [ 'base' => '<p>An object that represents an Amazon ECR image.</p>', 'refs' => [ 'PutImageResponse$image' => '<p>Details of the image uploaded.</p>', ], ], 'ImageAlreadyExistsException' => [ 'base' => '<p>The specified image has already been pushed, and there were no changes to the manifest or image tag after the last push.</p>', 'refs' => [], ], 'ImageDetail' => [ 'base' => '<p>An object that describes an image that\'s returned by a <a>DescribeImages</a> operation.</p>', 'refs' => [ 'ImageDetailList$member' => NULL, ], ], 'ImageDetailList' => [ 'base' => NULL, 'refs' => [ 'DescribeImagesResponse$imageDetails' => '<p>A list of <a>ImageDetail</a> objects that contain data about the image.</p>', ], ], 'ImageDigest' => [ 'base' => NULL, 'refs' => [ 'ImageDetail$imageDigest' => '<p>The <code>sha256</code> digest of the image manifest.</p>', 'ImageIdentifier$imageDigest' => '<p>The <code>sha256</code> digest of the image manifest.</p>', 'PutImageRequest$imageDigest' => '<p>The image digest of the image manifest that corresponds to the image.</p>', 'ReferencedImageDetail$imageDigest' => '<p>The <code>sha256</code> digest of the image manifest.</p>', ], ], 'ImageDigestDoesNotMatchException' => [ 'base' => '<p>The specified image digest doesn\'t match the digest that Amazon ECR calculated for the image.</p>', 'refs' => [], ], 'ImageFailure' => [ 'base' => '<p>An object that represents an Amazon ECR image failure.</p>', 'refs' => [ 'ImageFailureList$member' => NULL, ], ], 'ImageFailureCode' => [ 'base' => NULL, 'refs' => [ 'ImageFailure$failureCode' => '<p>The code that\'s associated with the failure.</p>', ], ], 'ImageFailureList' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteImageResponse$failures' => '<p>Any failures associated with the call.</p>', ], ], 'ImageFailureReason' => [ 'base' => NULL, 'refs' => [ 'ImageFailure$failureReason' => '<p>The reason for the failure.</p>', ], ], 'ImageIdentifier' => [ 'base' => '<p>An object with identifying information for an Amazon ECR image.</p>', 'refs' => [ 'Image$imageId' => '<p>An object that contains the image tag and image digest associated with an image.</p>', 'ImageFailure$imageId' => '<p>The image ID that\'s associated with the failure.</p>', 'ImageIdentifierList$member' => NULL, ], ], 'ImageIdentifierList' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteImageRequest$imageIds' => '<p>A list of image ID references that correspond to images to delete. The format of the <code>imageIds</code> reference is <code>imageTag=tag</code> or <code>imageDigest=digest</code>.</p>', 'BatchDeleteImageResponse$imageIds' => '<p>The image IDs of the deleted images.</p>', 'DescribeImagesRequest$imageIds' => '<p>The list of image IDs for the requested repository.</p>', ], ], 'ImageManifest' => [ 'base' => NULL, 'refs' => [ 'Image$imageManifest' => '<p>The image manifest that\'s associated with the image.</p>', 'PutImageRequest$imageManifest' => '<p>The image manifest that corresponds to the image to be uploaded.</p>', ], ], 'ImageNotFoundException' => [ 'base' => '<p>The image requested doesn\'t exist in the specified repository.</p>', 'refs' => [], ], 'ImageSizeInBytes' => [ 'base' => NULL, 'refs' => [ 'ImageDetail$imageSizeInBytes' => '<p>The size, in bytes, of the image in the repository.</p> <p>If the image is a manifest list, this is the max size of all manifests in the list.</p> <note> <p>Beginning with Docker version 1.9, the Docker client compresses image layers before pushing them to a V2 Docker registry. The output of the <code>docker images</code> command shows the uncompressed image size, so it might return a larger image size than the image sizes that are returned by <a>DescribeImages</a>.</p> </note>', 'ReferencedImageDetail$imageSizeInBytes' => '<p>The size, in bytes, of the image in the repository.</p> <p>If the image is a manifest list, this is the max size of all manifests in the list.</p> <note> <p>Beginning with Docker version 1.9, the Docker client compresses image layers before pushing them to a V2 Docker registry. The output of the <code>docker images</code> command shows the uncompressed image size, so it might return a larger image size than the image sizes that are returned by <a>DescribeImages</a>.</p> </note>', ], ], 'ImageTag' => [ 'base' => NULL, 'refs' => [ 'ImageIdentifier$imageTag' => '<p>The tag that\'s used for the image.</p>', 'ImageTagDetail$imageTag' => '<p>The tag that\'s associated with the image.</p>', 'ImageTagList$member' => NULL, 'PutImageRequest$imageTag' => '<p>The tag to associate with the image. This parameter is required for images that use the Docker Image Manifest V2 Schema 2 or Open Container Initiative (OCI) formats.</p>', ], ], 'ImageTagAlreadyExistsException' => [ 'base' => '<p>The specified image is tagged with a tag that already exists. The repository is configured for tag immutability.</p>', 'refs' => [], ], 'ImageTagDetail' => [ 'base' => '<p>An object that represents the image tag details for an image.</p>', 'refs' => [ 'ImageTagDetailList$member' => NULL, ], ], 'ImageTagDetailList' => [ 'base' => NULL, 'refs' => [ 'DescribeImageTagsResponse$imageTagDetails' => '<p>The image tag details for the images in the requested repository.</p>', ], ], 'ImageTagList' => [ 'base' => NULL, 'refs' => [ 'ImageDetail$imageTags' => '<p>The list of tags that\'s associated with this image.</p>', ], ], 'InitiateLayerUploadRequest' => [ 'base' => NULL, 'refs' => [], ], 'InitiateLayerUploadResponse' => [ 'base' => NULL, 'refs' => [], ], 'InvalidLayerException' => [ 'base' => '<p>The layer digest calculation performed by Amazon ECR when the image layer doesn\'t match the digest specified.</p>', 'refs' => [], ], 'InvalidLayerPartException' => [ 'base' => '<p>The layer part size isn\'t valid, or the first byte specified isn\'t consecutive to the last byte of a previous layer part upload.</p>', 'refs' => [], ], 'InvalidParameterException' => [ 'base' => '<p>The specified parameter is invalid. Review the available parameters for the API request.</p>', 'refs' => [], ], 'InvalidTagParameterException' => [ 'base' => '<p>An invalid parameter has been specified. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>', 'refs' => [], ], 'Layer' => [ 'base' => '<p>An object that represents an Amazon ECR image layer.</p>', 'refs' => [ 'LayerList$member' => NULL, ], ], 'LayerAlreadyExistsException' => [ 'base' => '<p>The image layer already exists in the associated repository.</p>', 'refs' => [], ], 'LayerAvailability' => [ 'base' => NULL, 'refs' => [ 'Layer$layerAvailability' => '<p>The availability status of the image layer.</p>', ], ], 'LayerDigest' => [ 'base' => NULL, 'refs' => [ 'CompleteLayerUploadResponse$layerDigest' => '<p>The <code>sha256</code> digest of the image layer.</p>', 'Layer$layerDigest' => '<p>The <code>sha256</code> digest of the image layer.</p>', 'LayerDigestList$member' => NULL, ], ], 'LayerDigestList' => [ 'base' => NULL, 'refs' => [ 'CompleteLayerUploadRequest$layerDigests' => '<p>The <code>sha256</code> digest of the image layer.</p>', ], ], 'LayerFailure' => [ 'base' => '<p>An object that represents an Amazon ECR image layer failure.</p>', 'refs' => [ 'LayerFailureList$member' => NULL, ], ], 'LayerFailureCode' => [ 'base' => NULL, 'refs' => [ 'LayerFailure$failureCode' => '<p>The failure code that\'s associated with the failure.</p>', ], ], 'LayerFailureList' => [ 'base' => NULL, 'refs' => [ 'BatchCheckLayerAvailabilityResponse$failures' => '<p>Any failures associated with the call.</p>', ], ], 'LayerFailureReason' => [ 'base' => NULL, 'refs' => [ 'LayerFailure$failureReason' => '<p>The reason for the failure.</p>', ], ], 'LayerList' => [ 'base' => NULL, 'refs' => [ 'BatchCheckLayerAvailabilityResponse$layers' => '<p>A list of image layer objects that correspond to the image layer references in the request.</p>', ], ], 'LayerPartBlob' => [ 'base' => NULL, 'refs' => [ 'UploadLayerPartRequest$layerPartBlob' => '<p>The base64-encoded layer part payload.</p>', ], ], 'LayerPartTooSmallException' => [ 'base' => '<p>Layer parts must be at least 5 MiB in size.</p>', 'refs' => [], ], 'LayerSizeInBytes' => [ 'base' => NULL, 'refs' => [ 'Layer$layerSize' => '<p>The size, in bytes, of the image layer.</p>', ], ], 'LayersNotFoundException' => [ 'base' => '<p>The specified layers can\'t be found, or the specified layer isn\'t valid for this repository.</p>', 'refs' => [], ], 'LimitExceededException' => [ 'base' => '<p>The operation didn\'t succeed because it would have exceeded a service limit for your account. For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/service-quotas.html">Amazon ECR Service Quotas</a> in the Amazon Elastic Container Registry User Guide.</p>', 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'LogoImageBlob' => [ 'base' => NULL, 'refs' => [ 'RepositoryCatalogDataInput$logoImageBlob' => '<p>The base64-encoded repository logo payload.</p> <note> <p>The repository logo is only publicly visible in the Amazon ECR Public Gallery for verified accounts.</p> </note>', ], ], 'MarketplaceCertified' => [ 'base' => NULL, 'refs' => [ 'RepositoryCatalogData$marketplaceCertified' => '<p>Indicates whether the repository is certified by Amazon Web Services Marketplace.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeImageTagsRequest$maxResults' => '<p>The maximum number of repository results that\'s returned by <code>DescribeImageTags</code> in paginated output. When this parameter is used, <code>DescribeImageTags</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>DescribeImageTags</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 1000. If this parameter isn\'t used, then <code>DescribeImageTags</code> returns up to 100 results and a <code>nextToken</code> value, if applicable. If you specify images with <code>imageIds</code>, you can\'t use this option.</p>', 'DescribeImagesRequest$maxResults' => '<p>The maximum number of repository results that\'s returned by <code>DescribeImages</code> in paginated output. When this parameter is used, <code>DescribeImages</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>DescribeImages</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 1000. If this parameter isn\'t used, then <code>DescribeImages</code> returns up to 100 results and a <code>nextToken</code> value, if applicable. If you specify images with <code>imageIds</code>, you can\'t use this option.</p>', 'DescribeRegistriesRequest$maxResults' => '<p>The maximum number of repository results that\'s returned by <code>DescribeRegistries</code> in paginated output. When this parameter is used, <code>DescribeRegistries</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>DescribeRegistries</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 1000. If this parameter isn\'t used, then <code>DescribeRegistries</code> returns up to 100 results and a <code>nextToken</code> value, if applicable.</p>', 'DescribeRepositoriesRequest$maxResults' => '<p>The maximum number of repository results that\'s returned by <code>DescribeRepositories</code> in paginated output. When this parameter is used, <code>DescribeRepositories</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>DescribeRepositories</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 1000. If this parameter isn\'t used, then <code>DescribeRepositories</code> returns up to 100 results and a <code>nextToken</code> value, if applicable. If you specify repositories with <code>repositoryNames</code>, you can\'t use this option.</p>', ], ], 'MediaType' => [ 'base' => NULL, 'refs' => [ 'Image$imageManifestMediaType' => '<p>The manifest media type of the image.</p>', 'ImageDetail$imageManifestMediaType' => '<p>The media type of the image manifest.</p>', 'ImageDetail$artifactMediaType' => '<p>The artifact media type of the image.</p>', 'Layer$mediaType' => '<p>The media type of the layer, such as <code>application/vnd.docker.image.rootfs.diff.tar.gzip</code> or <code>application/vnd.oci.image.layer.v1.tar+gzip</code>.</p>', 'PutImageRequest$imageManifestMediaType' => '<p>The media type of the image manifest. If you push an image manifest that doesn\'t contain the <code>mediaType</code> field, you must specify the <code>imageManifestMediaType</code> in the request.</p>', 'ReferencedImageDetail$imageManifestMediaType' => '<p>The media type of the image manifest.</p>', 'ReferencedImageDetail$artifactMediaType' => '<p>The artifact media type of the image.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'DescribeImageTagsRequest$nextToken' => '<p>The <code>nextToken</code> value that\'s returned from a previous paginated <code>DescribeImageTags</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. If there are no more results to return, this value is <code>null</code>. If you specify images with <code>imageIds</code>, you can\'t use this option.</p>', 'DescribeImageTagsResponse$nextToken' => '<p>The <code>nextToken</code> value to include in a future <code>DescribeImageTags</code> request. When the results of a <code>DescribeImageTags</code> request exceed <code>maxResults</code>, you can use this value to retrieve the next page of results. If there are no more results to return, this value is <code>null</code>.</p>', 'DescribeImagesRequest$nextToken' => '<p>The <code>nextToken</code> value that\'s returned from a previous paginated <code>DescribeImages</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. If there are no more results to return, this value is <code>null</code>. If you specify images with <code>imageIds</code>, you can\'t use this option.</p>', 'DescribeImagesResponse$nextToken' => '<p>The <code>nextToken</code> value to include in a future <code>DescribeImages</code> request. When the results of a <code>DescribeImages</code> request exceed <code>maxResults</code>, you can use this value to retrieve the next page of results. If there are no more results to return, this value is <code>null</code>.</p>', 'DescribeRegistriesRequest$nextToken' => '<p>The <code>nextToken</code> value that\'s returned from a previous paginated <code>DescribeRegistries</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. If there are no more results to return, this value is <code>null</code>.</p> <note> <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p> </note>', 'DescribeRegistriesResponse$nextToken' => '<p>The <code>nextToken</code> value to include in a future <code>DescribeRepositories</code> request. If the results of a <code>DescribeRepositories</code> request exceed <code>maxResults</code>, you can use this value to retrieve the next page of results. If there are no more results, this value is <code>null</code>.</p>', 'DescribeRepositoriesRequest$nextToken' => '<p>The <code>nextToken</code> value that\'s returned from a previous paginated <code>DescribeRepositories</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. If there are no more results to return, this value is <code>null</code>. If you specify repositories with <code>repositoryNames</code>, you can\'t use this option.</p> <note> <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p> </note>', 'DescribeRepositoriesResponse$nextToken' => '<p>The <code>nextToken</code> value to include in a future <code>DescribeRepositories</code> request. When the results of a <code>DescribeRepositories</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. If there are no more results to return, this value is <code>null</code>.</p>', ], ], 'OperatingSystem' => [ 'base' => NULL, 'refs' => [ 'OperatingSystemList$member' => NULL, ], ], 'OperatingSystemList' => [ 'base' => NULL, 'refs' => [ 'RepositoryCatalogData$operatingSystems' => '<p>The operating system tags that are associated with the repository.</p> <note> <p>Only supported operating system tags appear publicly in the Amazon ECR Public Gallery. For more information, see <a>RepositoryCatalogDataInput</a>.</p> </note>', 'RepositoryCatalogDataInput$operatingSystems' => '<p>The operating systems that the images in the repository are compatible with. On the Amazon ECR Public Gallery, the following supported operating systems appear as badges on the repository and are used as search filters.</p> <note> <p>If an unsupported tag is added to your repository catalog data, it\'s associated with the repository and can be retrieved using the API but isn\'t discoverable in the Amazon ECR Public Gallery.</p> </note> <ul> <li> <p> <code>Linux</code> </p> </li> <li> <p> <code>Windows</code> </p> </li> </ul>', ], ], 'PartSize' => [ 'base' => NULL, 'refs' => [ 'InitiateLayerUploadResponse$partSize' => '<p>The size, in bytes, that Amazon ECR expects future layer part uploads to be.</p>', 'InvalidLayerPartException$lastValidByteReceived' => '<p>The position of the last byte of the layer part.</p>', 'UploadLayerPartRequest$partFirstByte' => '<p>The position of the first byte of the layer part witin the overall image layer.</p>', 'UploadLayerPartRequest$partLastByte' => '<p>The position of the last byte of the layer part within the overall image layer.</p>', 'UploadLayerPartResponse$lastByteReceived' => '<p>The integer value of the last byte that\'s received in the request.</p>', ], ], 'PrimaryRegistryAliasFlag' => [ 'base' => NULL, 'refs' => [ 'RegistryAlias$primaryRegistryAlias' => '<p>Indicates whether the registry alias is the primary alias for the registry. If true, the alias is the primary registry alias and is displayed in both the repository URL and the image URI used in the <code>docker pull</code> commands on the Amazon ECR Public Gallery.</p> <note> <p>A registry alias that isn\'t the primary registry alias can be used in the repository URI in a <code>docker pull</code> command.</p> </note>', ], ], 'PushTimestamp' => [ 'base' => NULL, 'refs' => [ 'ImageDetail$imagePushedAt' => '<p>The date and time, expressed in standard JavaScript date format, that the current image was pushed to the repository at. </p>', 'ReferencedImageDetail$imagePushedAt' => '<p>The date and time, expressed in standard JavaScript date format, which the current image tag was pushed to the repository at.</p>', ], ], 'PutImageRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutImageResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutRegistryCatalogDataRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutRegistryCatalogDataResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutRepositoryCatalogDataRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutRepositoryCatalogDataResponse' => [ 'base' => NULL, 'refs' => [], ], 'ReferencedImageDetail' => [ 'base' => '<p>An object that describes the image tag details that are returned by a <a>DescribeImageTags</a> action.</p>', 'refs' => [ 'ImageTagDetail$imageDetail' => '<p>An object that describes the details of an image.</p>', ], ], 'ReferencedImagesNotFoundException' => [ 'base' => '<p>The manifest list is referencing an image that doesn\'t exist.</p>', 'refs' => [], ], 'Registry' => [ 'base' => '<p>The details of a public registry.</p>', 'refs' => [ 'RegistryList$member' => NULL, ], ], 'RegistryAlias' => [ 'base' => '<p>An object representing the aliases for a public registry. A public registry is given an alias when it\'s created. However, a custom alias can be set using the Amazon ECR console. For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/Registries.html">Registries</a> in the <i>Amazon Elastic Container Registry User Guide</i>.</p>', 'refs' => [ 'RegistryAliasList$member' => NULL, ], ], 'RegistryAliasList' => [ 'base' => NULL, 'refs' => [ 'Registry$aliases' => '<p>An array of objects that represents the aliases for a public registry.</p>', ], ], 'RegistryAliasName' => [ 'base' => NULL, 'refs' => [ 'RegistryAlias$name' => '<p>The name of the registry alias.</p>', ], ], 'RegistryAliasStatus' => [ 'base' => NULL, 'refs' => [ 'RegistryAlias$status' => '<p>The status of the registry alias.</p>', ], ], 'RegistryCatalogData' => [ 'base' => '<p>The metadata for a public registry.</p>', 'refs' => [ 'GetRegistryCatalogDataResponse$registryCatalogData' => '<p>The catalog metadata for the public registry.</p>', 'PutRegistryCatalogDataResponse$registryCatalogData' => '<p>The catalog data for the public registry.</p>', ], ], 'RegistryDisplayName' => [ 'base' => NULL, 'refs' => [ 'PutRegistryCatalogDataRequest$displayName' => '<p>The display name for a public registry. The display name is shown as the repository author in the Amazon ECR Public Gallery.</p> <note> <p>The registry display name is only publicly visible in the Amazon ECR Public Gallery for verified accounts.</p> </note>', 'RegistryCatalogData$displayName' => '<p>The display name for a public registry. This appears on the Amazon ECR Public Gallery.</p> <important> <p>Only accounts that have the verified account badge can have a registry display name.</p> </important>', ], ], 'RegistryId' => [ 'base' => NULL, 'refs' => [ 'CompleteLayerUploadResponse$registryId' => '<p>The public registry ID that\'s associated with the request.</p>', 'DeleteRepositoryPolicyRequest$registryId' => '<p>The Amazon Web Services account ID that\'s associated with the public registry that contains the repository policy to delete. If you do not specify a registry, the default public registry is assumed.</p>', 'DeleteRepositoryPolicyResponse$registryId' => '<p>The registry ID that\'s associated with the request.</p>', 'DeleteRepositoryRequest$registryId' => '<p>The Amazon Web Services account ID that\'s associated with the public registry that contains the repository to delete. If you do not specify a registry, the default public registry is assumed.</p>', 'DescribeImageTagsRequest$registryId' => '<p>The Amazon Web Services account ID that\'s associated with the public registry that contains the repository where images are described. If you do not specify a registry, the default public registry is assumed.</p>', 'DescribeImagesRequest$registryId' => '<p>The Amazon Web Services account ID that\'s associated with the public registry that contains the repository where images are described. If you do not specify a registry, the default public registry is assumed.</p>', 'DescribeRepositoriesRequest$registryId' => '<p>The Amazon Web Services account ID that\'s associated with the registry that contains the repositories to be described. If you do not specify a registry, the default public registry is assumed.</p>', 'GetRepositoryCatalogDataRequest$registryId' => '<p>The Amazon Web Services account ID that\'s associated with the registry that contains the repositories to be described. If you do not specify a registry, the default public registry is assumed.</p>', 'GetRepositoryPolicyRequest$registryId' => '<p>The Amazon Web Services account ID that\'s associated with the public registry that contains the repository. If you do not specify a registry, the default public registry is assumed.</p>', 'GetRepositoryPolicyResponse$registryId' => '<p>The registry ID that\'s associated with the request.</p>', 'ImageDetail$registryId' => '<p>The Amazon Web Services account ID that\'s associated with the public registry where this image belongs.</p>', 'InvalidLayerPartException$registryId' => '<p>The Amazon Web Services account ID that\'s associated with the layer part.</p>', 'PutRepositoryCatalogDataRequest$registryId' => '<p>The Amazon Web Services account ID that\'s associated with the public registry the repository is in. If you do not specify a registry, the default public registry is assumed.</p>', 'Registry$registryId' => '<p>The Amazon Web Services account ID that\'s associated with the registry. If you do not specify a registry, the default public registry is assumed.</p>', 'Repository$registryId' => '<p>The Amazon Web Services account ID that\'s associated with the public registry that contains the repository.</p>', 'SetRepositoryPolicyRequest$registryId' => '<p>The Amazon Web Services account ID that\'s associated with the registry that contains the repository. If you do not specify a registry, the default public registry is assumed.</p>', 'SetRepositoryPolicyResponse$registryId' => '<p>The registry ID that\'s associated with the request.</p>', 'UploadLayerPartResponse$registryId' => '<p>The registry ID that\'s associated with the request.</p>', ], ], 'RegistryIdOrAlias' => [ 'base' => NULL, 'refs' => [ 'BatchCheckLayerAvailabilityRequest$registryId' => '<p>The Amazon Web Services account ID, or registry alias, associated with the public registry that contains the image layers to check. If you do not specify a registry, the default public registry is assumed.</p>', 'BatchDeleteImageRequest$registryId' => '<p>The Amazon Web Services account ID, or registry alias, that\'s associated with the registry that contains the image to delete. If you do not specify a registry, the default public registry is assumed.</p>', 'CompleteLayerUploadRequest$registryId' => '<p>The Amazon Web Services account ID, or registry alias, associated with the registry where layers are uploaded. If you do not specify a registry, the default public registry is assumed.</p>', 'Image$registryId' => '<p>The Amazon Web Services account ID that\'s associated with the registry containing the image.</p>', 'InitiateLayerUploadRequest$registryId' => '<p>The Amazon Web Services account ID, or registry alias, that\'s associated with the registry to which you intend to upload layers. If you do not specify a registry, the default public registry is assumed.</p>', 'PutImageRequest$registryId' => '<p>The Amazon Web Services account ID, or registry alias, that\'s associated with the public registry that contains the repository where the image is put. If you do not specify a registry, the default public registry is assumed.</p>', 'UploadLayerPartRequest$registryId' => '<p>The Amazon Web Services account ID, or registry alias, that\'s associated with the registry that you\'re uploading layer parts to. If you do not specify a registry, the default public registry is assumed.</p>', ], ], 'RegistryList' => [ 'base' => NULL, 'refs' => [ 'DescribeRegistriesResponse$registries' => '<p>An object that contains the details for a public registry.</p>', ], ], 'RegistryNotFoundException' => [ 'base' => '<p>The registry doesn\'t exist.</p>', 'refs' => [], ], 'RegistryVerified' => [ 'base' => NULL, 'refs' => [ 'Registry$verified' => '<p>Indicates whether the account is a verified Amazon Web Services Marketplace vendor. If an account is verified, each public repository receives a verified account badge on the Amazon ECR Public Gallery.</p>', ], ], 'Repository' => [ 'base' => '<p>An object representing a repository.</p>', 'refs' => [ 'CreateRepositoryResponse$repository' => '<p>The repository that was created.</p>', 'DeleteRepositoryResponse$repository' => '<p>The repository that was deleted.</p>', 'RepositoryList$member' => NULL, ], ], 'RepositoryAlreadyExistsException' => [ 'base' => '<p>The specified repository already exists in the specified registry.</p>', 'refs' => [], ], 'RepositoryCatalogData' => [ 'base' => '<p>The catalog data for a repository. This data is publicly visible in the Amazon ECR Public Gallery.</p>', 'refs' => [ 'CreateRepositoryResponse$catalogData' => NULL, 'GetRepositoryCatalogDataResponse$catalogData' => '<p>The catalog metadata for the repository.</p>', 'PutRepositoryCatalogDataResponse$catalogData' => '<p>The catalog data for the repository.</p>', ], ], 'RepositoryCatalogDataInput' => [ 'base' => '<p>An object that contains the catalog data for a repository. This data is publicly visible in the Amazon ECR Public Gallery.</p>', 'refs' => [ 'CreateRepositoryRequest$catalogData' => '<p>The details about the repository that are publicly visible in the Amazon ECR Public Gallery.</p>', 'PutRepositoryCatalogDataRequest$catalogData' => '<p>An object containing the catalog data for a repository. This data is publicly visible in the Amazon ECR Public Gallery.</p>', ], ], 'RepositoryCatalogDataNotFoundException' => [ 'base' => '<p>The repository catalog data doesn\'t exist.</p>', 'refs' => [], ], 'RepositoryDescription' => [ 'base' => NULL, 'refs' => [ 'RepositoryCatalogData$description' => '<p>The short description of the repository.</p>', 'RepositoryCatalogDataInput$description' => '<p>A short description of the contents of the repository. This text appears in both the image details and also when searching for repositories on the Amazon ECR Public Gallery.</p>', ], ], 'RepositoryList' => [ 'base' => NULL, 'refs' => [ 'DescribeRepositoriesResponse$repositories' => '<p>A list of repository objects corresponding to valid repositories.</p>', ], ], 'RepositoryName' => [ 'base' => NULL, 'refs' => [ 'BatchCheckLayerAvailabilityRequest$repositoryName' => '<p>The name of the repository that\'s associated with the image layers to check.</p>', 'BatchDeleteImageRequest$repositoryName' => '<p>The repository in a public registry that contains the image to delete.</p>', 'CompleteLayerUploadRequest$repositoryName' => '<p>The name of the repository in a public registry to associate with the image layer.</p>', 'CompleteLayerUploadResponse$repositoryName' => '<p>The repository name that\'s associated with the request.</p>', 'CreateRepositoryRequest$repositoryName' => '<p>The name to use for the repository. This appears publicly in the Amazon ECR Public Gallery. The repository name can be specified on its own (for example <code>nginx-web-app</code>) or prepended with a namespace to group the repository into a category (for example <code>project-a/nginx-web-app</code>).</p>', 'DeleteRepositoryPolicyRequest$repositoryName' => '<p>The name of the repository that\'s associated with the repository policy to delete.</p>', 'DeleteRepositoryPolicyResponse$repositoryName' => '<p>The repository name that\'s associated with the request.</p>', 'DeleteRepositoryRequest$repositoryName' => '<p>The name of the repository to delete.</p>', 'DescribeImageTagsRequest$repositoryName' => '<p>The name of the repository that contains the image tag details to describe.</p>', 'DescribeImagesRequest$repositoryName' => '<p>The repository that contains the images to describe.</p>', 'GetRepositoryCatalogDataRequest$repositoryName' => '<p>The name of the repository to retrieve the catalog metadata for.</p>', 'GetRepositoryPolicyRequest$repositoryName' => '<p>The name of the repository with the policy to retrieve.</p>', 'GetRepositoryPolicyResponse$repositoryName' => '<p>The repository name that\'s associated with the request.</p>', 'Image$repositoryName' => '<p>The name of the repository that\'s associated with the image.</p>', 'ImageDetail$repositoryName' => '<p>The name of the repository where this image belongs.</p>', 'InitiateLayerUploadRequest$repositoryName' => '<p>The name of the repository that you want to upload layers to.</p>', 'InvalidLayerPartException$repositoryName' => '<p>The name of the repository.</p>', 'PutImageRequest$repositoryName' => '<p>The name of the repository where the image is put.</p>', 'PutRepositoryCatalogDataRequest$repositoryName' => '<p>The name of the repository to create or update the catalog data for.</p>', 'Repository$repositoryName' => '<p>The name of the repository.</p>', 'RepositoryNameList$member' => NULL, 'SetRepositoryPolicyRequest$repositoryName' => '<p>The name of the repository to receive the policy.</p>', 'SetRepositoryPolicyResponse$repositoryName' => '<p>The repository name that\'s associated with the request.</p>', 'UploadLayerPartRequest$repositoryName' => '<p>The name of the repository that you\'re uploading layer parts to.</p>', 'UploadLayerPartResponse$repositoryName' => '<p>The repository name that\'s associated with the request.</p>', ], ], 'RepositoryNameList' => [ 'base' => NULL, 'refs' => [ 'DescribeRepositoriesRequest$repositoryNames' => '<p>A list of repositories to describe. If this parameter is omitted, then all repositories in a registry are described.</p>', ], ], 'RepositoryNotEmptyException' => [ 'base' => '<p>The specified repository contains images. To delete a repository that contains images, you must force the deletion with the <code>force</code> parameter.</p>', 'refs' => [], ], 'RepositoryNotFoundException' => [ 'base' => '<p>The specified repository can\'t be found. Check the spelling of the specified repository and ensure that you\'re performing operations on the correct registry.</p>', 'refs' => [], ], 'RepositoryPolicyNotFoundException' => [ 'base' => '<p>The specified repository and registry combination doesn\'t have an associated repository policy.</p>', 'refs' => [], ], 'RepositoryPolicyText' => [ 'base' => NULL, 'refs' => [ 'DeleteRepositoryPolicyResponse$policyText' => '<p>The JSON repository policy that was deleted from the repository.</p>', 'GetRepositoryPolicyResponse$policyText' => '<p>The repository policy text that\'s associated with the repository. The policy text will be in JSON format.</p>', 'SetRepositoryPolicyRequest$policyText' => '<p>The JSON repository policy text to apply to the repository. For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-policy-examples.html">Amazon ECR Repository Policies</a> in the <i>Amazon Elastic Container Registry User Guide</i>.</p>', 'SetRepositoryPolicyResponse$policyText' => '<p>The JSON repository policy text that\'s applied to the repository.</p>', ], ], 'ResourceUrl' => [ 'base' => NULL, 'refs' => [ 'RepositoryCatalogData$logoUrl' => '<p>The URL that contains the logo that\'s associated with the repository.</p>', ], ], 'ServerException' => [ 'base' => '<p>These errors are usually caused by a server-side issue.</p>', 'refs' => [], ], 'SetRepositoryPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'SetRepositoryPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'Tag' => [ 'base' => '<p>The metadata that you apply to a resource to help you categorize and organize them. Each tag consists of a key and an optional value. You define both. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>One part of a key-value pair that make up a tag. A <code>key</code> is a general label that acts like a category for more specific tag values.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>The keys of the tags to be removed.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateRepositoryRequest$tags' => '<p>The metadata that you apply to each repository to help categorize and organize your repositories. Each tag consists of a key and an optional value. You define both of them. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>', 'ListTagsForResourceResponse$tags' => '<p>The tags for the resource.</p>', 'TagResourceRequest$tags' => '<p>The tags to add to the resource. A tag is an array of key-value pairs. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The optional part of a key-value pair that make up a tag. A <code>value</code> acts as a descriptor within a tag category (key).</p>', ], ], 'TooManyTagsException' => [ 'base' => '<p>The list of tags on the repository is over the limit. The maximum number of tags that can be applied to a repository is 50.</p>', 'refs' => [], ], 'UnsupportedCommandException' => [ 'base' => '<p>The action isn\'t supported in this Region.</p>', 'refs' => [], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UploadId' => [ 'base' => NULL, 'refs' => [ 'CompleteLayerUploadRequest$uploadId' => '<p>The upload ID from a previous <a>InitiateLayerUpload</a> operation to associate with the image layer.</p>', 'CompleteLayerUploadResponse$uploadId' => '<p>The upload ID that\'s associated with the layer.</p>', 'InitiateLayerUploadResponse$uploadId' => '<p>The upload ID for the layer upload. This parameter is passed to further <a>UploadLayerPart</a> and <a>CompleteLayerUpload</a> operations.</p>', 'InvalidLayerPartException$uploadId' => '<p>The upload ID that\'s associated with the layer part.</p>', 'UploadLayerPartRequest$uploadId' => '<p>The upload ID from a previous <a>InitiateLayerUpload</a> operation to associate with the layer part upload.</p>', 'UploadLayerPartResponse$uploadId' => '<p>The upload ID that\'s associated with the request.</p>', ], ], 'UploadLayerPartRequest' => [ 'base' => NULL, 'refs' => [], ], 'UploadLayerPartResponse' => [ 'base' => NULL, 'refs' => [], ], 'UploadNotFoundException' => [ 'base' => '<p>The upload can\'t be found, or the specified upload ID isn\'t valid for this repository.</p>', 'refs' => [], ], 'Url' => [ 'base' => NULL, 'refs' => [ 'Registry$registryUri' => '<p>The URI of a public registry. The URI contains a universal prefix and the registry alias.</p>', 'Repository$repositoryUri' => '<p>The URI for the repository. You can use this URI for container image <code>push</code> and <code>pull</code> operations.</p>', ], ], 'UsageText' => [ 'base' => NULL, 'refs' => [ 'RepositoryCatalogData$usageText' => '<p>The longform usage details of the contents of the repository. The usage text provides context for users of the repository.</p>', 'RepositoryCatalogDataInput$usageText' => '<p>Detailed information about how to use the contents of the repository. It\'s publicly visible in the Amazon ECR Public Gallery. The usage text provides context, support information, and additional usage details for users of the repository. The text must be in markdown format.</p>', ], ], ],];
