<?php
// This file was auto-generated from sdk-root/src/data/fms/2018-01-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>This is the <i>Firewall Manager API Reference</i>. This guide is for developers who need detailed information about the Firewall Manager API actions, data types, and errors. For detailed information about Firewall Manager features, see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/fms-chapter.html">Firewall Manager Developer Guide</a>.</p> <p>Some API actions require explicit resource permissions. For information, see the developer guide topic <a href="https://docs.aws.amazon.com/waf/latest/developerguide/fms-security_iam_service-with-iam.html#fms-security_iam_service-with-iam-roles-service">Service roles for Firewall Manager</a>. </p>', 'operations' => [ 'AssociateAdminAccount' => '<p>Sets a Firewall Manager default administrator account. The Firewall Manager default administrator account can manage third-party firewalls and has full administrative scope that allows administration of all policy types, accounts, organizational units, and Regions. This account must be a member account of the organization in Organizations whose resources you want to protect.</p> <p>For information about working with Firewall Manager administrator accounts, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/fms-administrators.html">Managing Firewall Manager administrators</a> in the <i>Firewall Manager Developer Guide</i>.</p>', 'AssociateThirdPartyFirewall' => '<p>Sets the Firewall Manager policy administrator as a tenant administrator of a third-party firewall service. A tenant is an instance of the third-party firewall service that\'s associated with your Amazon Web Services customer account.</p>', 'BatchAssociateResource' => '<p>Associate resources to a Firewall Manager resource set.</p>', 'BatchDisassociateResource' => '<p>Disassociates resources from a Firewall Manager resource set.</p>', 'DeleteAppsList' => '<p>Permanently deletes an Firewall Manager applications list.</p>', 'DeleteNotificationChannel' => '<p>Deletes an Firewall Manager association with the IAM role and the Amazon Simple Notification Service (SNS) topic that is used to record Firewall Manager SNS logs.</p>', 'DeletePolicy' => '<p>Permanently deletes an Firewall Manager policy. </p>', 'DeleteProtocolsList' => '<p>Permanently deletes an Firewall Manager protocols list.</p>', 'DeleteResourceSet' => '<p>Deletes the specified <a>ResourceSet</a>.</p>', 'DisassociateAdminAccount' => '<p>Disassociates an Firewall Manager administrator account. To set a different account as an Firewall Manager administrator, submit a <a>PutAdminAccount</a> request. To set an account as a default administrator account, you must submit an <a>AssociateAdminAccount</a> request.</p> <p>Disassociation of the default administrator account follows the first in, last out principle. If you are the default administrator, all Firewall Manager administrators within the organization must first disassociate their accounts before you can disassociate your account.</p>', 'DisassociateThirdPartyFirewall' => '<p>Disassociates a Firewall Manager policy administrator from a third-party firewall tenant. When you call <code>DisassociateThirdPartyFirewall</code>, the third-party firewall vendor deletes all of the firewalls that are associated with the account.</p>', 'GetAdminAccount' => '<p>Returns the Organizations account that is associated with Firewall Manager as the Firewall Manager default administrator.</p>', 'GetAdminScope' => '<p>Returns information about the specified account\'s administrative scope. The administrative scope defines the resources that an Firewall Manager administrator can manage.</p>', 'GetAppsList' => '<p>Returns information about the specified Firewall Manager applications list.</p>', 'GetComplianceDetail' => '<p>Returns detailed compliance information about the specified member account. Details include resources that are in and out of compliance with the specified policy. </p> <p>The reasons for resources being considered compliant depend on the Firewall Manager policy type. </p>', 'GetNotificationChannel' => '<p>Information about the Amazon Simple Notification Service (SNS) topic that is used to record Firewall Manager SNS logs.</p>', 'GetPolicy' => '<p>Returns information about the specified Firewall Manager policy.</p>', 'GetProtectionStatus' => '<p>If you created a Shield Advanced policy, returns policy-level attack summary information in the event of a potential DDoS attack. Other policy types are currently unsupported.</p>', 'GetProtocolsList' => '<p>Returns information about the specified Firewall Manager protocols list.</p>', 'GetResourceSet' => '<p>Gets information about a specific resource set.</p>', 'GetThirdPartyFirewallAssociationStatus' => '<p>The onboarding status of a Firewall Manager admin account to third-party firewall vendor tenant.</p>', 'GetViolationDetails' => '<p>Retrieves violations for a resource based on the specified Firewall Manager policy and Amazon Web Services account.</p>', 'ListAdminAccountsForOrganization' => '<p>Returns a <code>AdminAccounts</code> object that lists the Firewall Manager administrators within the organization that are onboarded to Firewall Manager by <a>AssociateAdminAccount</a>.</p> <p>This operation can be called only from the organization\'s management account.</p>', 'ListAdminsManagingAccount' => '<p>Lists the accounts that are managing the specified Organizations member account. This is useful for any member account so that they can view the accounts who are managing their account. This operation only returns the managing administrators that have the requested account within their <a>AdminScope</a>.</p>', 'ListAppsLists' => '<p>Returns an array of <code>AppsListDataSummary</code> objects.</p>', 'ListComplianceStatus' => '<p>Returns an array of <code>PolicyComplianceStatus</code> objects. Use <code>PolicyComplianceStatus</code> to get a summary of which member accounts are protected by the specified policy. </p>', 'ListDiscoveredResources' => '<p>Returns an array of resources in the organization\'s accounts that are available to be associated with a resource set.</p>', 'ListMemberAccounts' => '<p>Returns a <code>MemberAccounts</code> object that lists the member accounts in the administrator\'s Amazon Web Services organization.</p> <p>Either an Firewall Manager administrator or the organization\'s management account can make this request.</p>', 'ListPolicies' => '<p>Returns an array of <code>PolicySummary</code> objects.</p>', 'ListProtocolsLists' => '<p>Returns an array of <code>ProtocolsListDataSummary</code> objects.</p>', 'ListResourceSetResources' => '<p>Returns an array of resources that are currently associated to a resource set.</p>', 'ListResourceSets' => '<p>Returns an array of <code>ResourceSetSummary</code> objects.</p>', 'ListTagsForResource' => '<p>Retrieves the list of tags for the specified Amazon Web Services resource. </p>', 'ListThirdPartyFirewallFirewallPolicies' => '<p>Retrieves a list of all of the third-party firewall policies that are associated with the third-party firewall administrator\'s account.</p>', 'PutAdminAccount' => '<p>Creates or updates an Firewall Manager administrator account. The account must be a member of the organization that was onboarded to Firewall Manager by <a>AssociateAdminAccount</a>. Only the organization\'s management account can create an Firewall Manager administrator account. When you create an Firewall Manager administrator account, the service checks to see if the account is already a delegated administrator within Organizations. If the account isn\'t a delegated administrator, Firewall Manager calls Organizations to delegate the account within Organizations. For more information about administrator accounts within Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts.html">Managing the Amazon Web Services Accounts in Your Organization</a>.</p>', 'PutAppsList' => '<p>Creates an Firewall Manager applications list.</p>', 'PutNotificationChannel' => '<p>Designates the IAM role and Amazon Simple Notification Service (SNS) topic that Firewall Manager uses to record SNS logs.</p> <p>To perform this action outside of the console, you must first configure the SNS topic\'s access policy to allow the <code>SnsRoleName</code> to publish SNS logs. If the <code>SnsRoleName</code> provided is a role other than the <code>AWSServiceRoleForFMS</code> service-linked role, this role must have a trust relationship configured to allow the Firewall Manager service principal <code>fms.amazonaws.com</code> to assume this role. For information about configuring an SNS access policy, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/fms-security_iam_service-with-iam.html#fms-security_iam_service-with-iam-roles-service">Service roles for Firewall Manager</a> in the <i>Firewall Manager Developer Guide</i>.</p>', 'PutPolicy' => '<p>Creates an Firewall Manager policy.</p> <p>A Firewall Manager policy is specific to the individual policy type. If you want to enforce multiple policy types across accounts, you can create multiple policies. You can create more than one policy for each type. </p> <p>If you add a new account to an organization that you created with Organizations, Firewall Manager automatically applies the policy to the resources in that account that are within scope of the policy. </p> <p>Firewall Manager provides the following types of policies: </p> <ul> <li> <p> <b>WAF policy</b> - This policy applies WAF web ACL protections to specified accounts and resources. </p> </li> <li> <p> <b>Shield Advanced policy</b> - This policy applies Shield Advanced protection to specified accounts and resources. </p> </li> <li> <p> <b>Security Groups policy</b> - This type of policy gives you control over security groups that are in use throughout your organization in Organizations and lets you enforce a baseline set of rules across your organization. </p> </li> <li> <p> <b>Network ACL policy</b> - This type of policy gives you control over the network ACLs that are in use throughout your organization in Organizations and lets you enforce a baseline set of first and last network ACL rules across your organization. </p> </li> <li> <p> <b>Network Firewall policy</b> - This policy applies Network Firewall protection to your organization\'s VPCs. </p> </li> <li> <p> <b>DNS Firewall policy</b> - This policy applies Amazon Route 53 Resolver DNS Firewall protections to your organization\'s VPCs. </p> </li> <li> <p> <b>Third-party firewall policy</b> - This policy applies third-party firewall protections. Third-party firewalls are available by subscription through the Amazon Web Services Marketplace console at <a href="http://aws.amazon.com/marketplace">Amazon Web Services Marketplace</a>.</p> <ul> <li> <p> <b>Palo Alto Networks Cloud NGFW policy</b> - This policy applies Palo Alto Networks Cloud Next Generation Firewall (NGFW) protections and Palo Alto Networks Cloud NGFW rulestacks to your organization\'s VPCs.</p> </li> <li> <p> <b>Fortigate CNF policy</b> - This policy applies Fortigate Cloud Native Firewall (CNF) protections. Fortigate CNF is a cloud-centered solution that blocks Zero-Day threats and secures cloud infrastructures with industry-leading advanced threat prevention, smart web application firewalls (WAF), and API protection.</p> </li> </ul> </li> </ul>', 'PutProtocolsList' => '<p>Creates an Firewall Manager protocols list.</p>', 'PutResourceSet' => '<p>Creates the resource set.</p> <p>An Firewall Manager resource set defines the resources to import into an Firewall Manager policy from another Amazon Web Services service.</p>', 'TagResource' => '<p>Adds one or more tags to an Amazon Web Services resource.</p>', 'UntagResource' => '<p>Removes one or more tags from an Amazon Web Services resource.</p>', ], 'shapes' => [ 'AWSAccountId' => [ 'base' => NULL, 'refs' => [ 'AWSAccountIdList$member' => NULL, 'AccountIdList$member' => NULL, 'AdminAccountSummary$AdminAccount' => '<p>The Amazon Web Services account ID of the Firewall Manager administrator\'s account.</p>', 'AssociateAdminAccountRequest$AdminAccount' => '<p>The Amazon Web Services account ID to associate with Firewall Manager as the Firewall Manager default administrator account. This account must be a member account of the organization in Organizations whose resources you want to protect. For more information about Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts.html">Managing the Amazon Web Services Accounts in Your Organization</a>. </p>', 'DiscoveredResource$AccountId' => '<p>The Amazon Web Services account ID associated with the discovered resource.</p>', 'GetAdminAccountResponse$AdminAccount' => '<p>The account that is set as the Firewall Manager default administrator.</p>', 'GetAdminScopeRequest$AdminAccount' => '<p>The administrator account that you want to get the details for.</p>', 'GetComplianceDetailRequest$MemberAccount' => '<p>The Amazon Web Services account that owns the resources that you want to get the details for.</p>', 'GetProtectionStatusRequest$MemberAccountId' => '<p>The Amazon Web Services account that is in scope of the policy that you want to get the details for.</p>', 'GetProtectionStatusResponse$AdminAccountId' => '<p>The ID of the Firewall Manager administrator account for this policy.</p>', 'GetViolationDetailsRequest$MemberAccount' => '<p>The Amazon Web Services account ID that you want the details for.</p>', 'MemberAccounts$member' => NULL, 'PolicyComplianceDetail$PolicyOwner' => '<p>The Amazon Web Services account that created the Firewall Manager policy.</p>', 'PolicyComplianceDetail$MemberAccount' => '<p>The Amazon Web Services account ID.</p>', 'PolicyComplianceStatus$PolicyOwner' => '<p>The Amazon Web Services account that created the Firewall Manager policy.</p>', 'PolicyComplianceStatus$MemberAccount' => '<p>The member account ID.</p>', 'PutAdminAccountRequest$AdminAccount' => '<p>The Amazon Web Services account ID to add as an Firewall Manager administrator account. The account must be a member of the organization that was onboarded to Firewall Manager by <a>AssociateAdminAccount</a>. For more information about Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts.html">Managing the Amazon Web Services Accounts in Your Organization</a>.</p>', 'Resource$AccountId' => '<p>The Amazon Web Services account ID that the associated resource belongs to.</p>', 'ViolationDetail$MemberAccount' => '<p>The Amazon Web Services account that the violation details were requested for.</p>', ], ], 'AWSAccountIdList' => [ 'base' => NULL, 'refs' => [ 'ListDiscoveredResourcesRequest$MemberAccountIds' => '<p>The Amazon Web Services account IDs to discover resources in. Only one account is supported per request. The account must be a member of your organization.</p>', ], ], 'AWSRegion' => [ 'base' => NULL, 'refs' => [ 'AWSRegionList$member' => NULL, ], ], 'AWSRegionList' => [ 'base' => NULL, 'refs' => [ 'RegionScope$Regions' => '<p>The Amazon Web Services Regions that the specified Firewall Manager administrator can perform actions in.</p>', ], ], 'AccountIdList' => [ 'base' => NULL, 'refs' => [ 'AccountScope$Accounts' => '<p>The list of accounts within the organization that the specified Firewall Manager administrator either can or cannot apply policies to, based on the value of <code>ExcludeSpecifiedAccounts</code>. If <code>ExcludeSpecifiedAccounts</code> is set to <code>true</code>, then the Firewall Manager administrator can apply policies to all members of the organization except for the accounts in this list. If <code>ExcludeSpecifiedAccounts</code> is set to <code>false</code>, then the Firewall Manager administrator can only apply policies to the accounts in this list.</p>', 'ListAdminsManagingAccountResponse$AdminAccounts' => '<p>The list of accounts who manage member accounts within their <a>AdminScope</a>.</p>', ], ], 'AccountRoleStatus' => [ 'base' => NULL, 'refs' => [ 'GetAdminAccountResponse$RoleStatus' => '<p>The status of the account that you set as the Firewall Manager default administrator.</p>', ], ], 'AccountScope' => [ 'base' => '<p>Configures the accounts within the administrator\'s Organizations organization that the specified Firewall Manager administrator can apply policies to.</p>', 'refs' => [ 'AdminScope$AccountScope' => '<p>Defines the accounts that the specified Firewall Manager administrator can apply policies to.</p>', ], ], 'ActionTarget' => [ 'base' => '<p>Describes a remediation action target.</p>', 'refs' => [ 'CreateNetworkAclAction$Vpc' => '<p>The VPC that\'s associated with the remediation action.</p>', 'CreateNetworkAclEntriesAction$NetworkAclId' => '<p>The network ACL that\'s associated with the remediation action.</p>', 'DeleteNetworkAclEntriesAction$NetworkAclId' => '<p>The network ACL that\'s associated with the remediation action.</p>', 'EC2AssociateRouteTableAction$RouteTableId' => '<p>The ID of the EC2 route table that is associated with the remediation action.</p>', 'EC2AssociateRouteTableAction$SubnetId' => '<p>The ID of the subnet for the EC2 route table that is associated with the remediation action.</p>', 'EC2AssociateRouteTableAction$GatewayId' => '<p>The ID of the gateway to be used with the EC2 route table that is associated with the remediation action.</p>', 'EC2CopyRouteTableAction$VpcId' => '<p>The VPC ID of the copied EC2 route table that is associated with the remediation action.</p>', 'EC2CopyRouteTableAction$RouteTableId' => '<p>The ID of the copied EC2 route table that is associated with the remediation action.</p>', 'EC2CreateRouteAction$VpcEndpointId' => '<p>Information about the ID of a VPC endpoint. Supported for Gateway Load Balancer endpoints only.</p>', 'EC2CreateRouteAction$GatewayId' => '<p>Information about the ID of an internet gateway or virtual private gateway attached to your VPC.</p>', 'EC2CreateRouteAction$RouteTableId' => '<p>Information about the ID of the route table for the route.</p>', 'EC2CreateRouteTableAction$VpcId' => '<p>Information about the ID of a VPC.</p>', 'EC2DeleteRouteAction$RouteTableId' => '<p>Information about the ID of the route table.</p>', 'EC2ReplaceRouteAction$GatewayId' => '<p>Information about the ID of an internet gateway or virtual private gateway.</p>', 'EC2ReplaceRouteAction$RouteTableId' => '<p>Information about the ID of the route table.</p>', 'EC2ReplaceRouteTableAssociationAction$AssociationId' => '<p>Information about the association ID.</p>', 'EC2ReplaceRouteTableAssociationAction$RouteTableId' => '<p>Information about the ID of the new route table to associate with the subnet.</p>', 'ReplaceNetworkAclAssociationAction$AssociationId' => NULL, 'ReplaceNetworkAclAssociationAction$NetworkAclId' => '<p>The network ACL that\'s associated with the remediation action.</p>', ], ], 'AdminAccountSummary' => [ 'base' => '<p>Contains high level information about the Firewall Manager administrator account.</p>', 'refs' => [ 'AdminAccountSummaryList$member' => NULL, ], ], 'AdminAccountSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListAdminAccountsForOrganizationResponse$AdminAccounts' => '<p>A list of Firewall Manager administrator accounts within the organization that were onboarded as administrators by <a>AssociateAdminAccount</a> or <a>PutAdminAccount</a>.</p>', ], ], 'AdminScope' => [ 'base' => '<p>Defines the resources that the Firewall Manager administrator can manage. For more information about administrative scope, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/fms-administrators.html">Managing Firewall Manager administrators</a> in the <i>Firewall Manager Developer Guide</i>.</p>', 'refs' => [ 'GetAdminScopeResponse$AdminScope' => '<p>Contains details about the administrative scope of the requested account.</p>', 'PutAdminAccountRequest$AdminScope' => '<p>Configures the resources that the specified Firewall Manager administrator can manage. As a best practice, set the administrative scope according to the principles of least privilege. Only grant the administrator the specific resources or permissions that they need to perform the duties of their role.</p>', ], ], 'App' => [ 'base' => '<p>An individual Firewall Manager application.</p>', 'refs' => [ 'AppsList$member' => NULL, ], ], 'AppsList' => [ 'base' => NULL, 'refs' => [ 'AppsListData$AppsList' => '<p>An array of applications in the Firewall Manager applications list.</p>', 'AppsListDataSummary$AppsList' => '<p>An array of <code>App</code> objects in the Firewall Manager applications list.</p>', 'PreviousAppsList$value' => NULL, ], ], 'AppsListData' => [ 'base' => '<p>An Firewall Manager applications list.</p>', 'refs' => [ 'GetAppsListResponse$AppsList' => '<p>Information about the specified Firewall Manager applications list.</p>', 'PutAppsListRequest$AppsList' => '<p>The details of the Firewall Manager applications list to be created.</p>', 'PutAppsListResponse$AppsList' => '<p>The details of the Firewall Manager applications list.</p>', ], ], 'AppsListDataSummary' => [ 'base' => '<p>Details of the Firewall Manager applications list.</p>', 'refs' => [ 'AppsListsData$member' => NULL, ], ], 'AppsListsData' => [ 'base' => NULL, 'refs' => [ 'ListAppsListsResponse$AppsLists' => '<p>An array of <code>AppsListDataSummary</code> objects.</p>', ], ], 'AssociateAdminAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateThirdPartyFirewallRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateThirdPartyFirewallResponse' => [ 'base' => NULL, 'refs' => [], ], 'AwsEc2InstanceViolation' => [ 'base' => '<p>Violation detail for an EC2 instance resource.</p>', 'refs' => [ 'ResourceViolation$AwsEc2InstanceViolation' => '<p>Violation detail for an EC2 instance.</p>', ], ], 'AwsEc2NetworkInterfaceViolation' => [ 'base' => '<p>Violation detail for network interfaces associated with an EC2 instance.</p>', 'refs' => [ 'AwsEc2NetworkInterfaceViolations$member' => NULL, 'ResourceViolation$AwsEc2NetworkInterfaceViolation' => '<p>Violation detail for a network interface.</p>', ], ], 'AwsEc2NetworkInterfaceViolations' => [ 'base' => NULL, 'refs' => [ 'AwsEc2InstanceViolation$AwsEc2NetworkInterfaceViolations' => '<p>Violation detail for network interfaces associated with the EC2 instance.</p>', ], ], 'AwsVPCSecurityGroupViolation' => [ 'base' => '<p>Violation detail for the rule violation in a security group when compared to the primary security group of the Firewall Manager policy.</p>', 'refs' => [ 'ResourceViolation$AwsVPCSecurityGroupViolation' => '<p>Violation detail for security groups.</p>', ], ], 'Base62Id' => [ 'base' => NULL, 'refs' => [ 'DeleteResourceSetRequest$Identifier' => '<p>A unique identifier for the resource set, used in a request to refer to the resource set.</p>', 'GetResourceSetRequest$Identifier' => '<p>A unique identifier for the resource set, used in a request to refer to the resource set.</p>', 'ResourceSet$Id' => '<p>A unique identifier for the resource set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>', 'ResourceSetIds$member' => NULL, 'ResourceSetSummary$Id' => '<p>A unique identifier for the resource set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>', ], ], 'BasicInteger' => [ 'base' => NULL, 'refs' => [ 'DnsRuleGroupLimitExceededViolation$NumberOfRuleGroupsAlreadyAssociated' => '<p>The number of rule groups currently associated with the VPC. </p>', 'RemediationActionWithOrder$Order' => '<p>The order of the remediation actions in the list.</p>', ], ], 'BatchAssociateResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchAssociateResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchDisassociateResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchDisassociateResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'AccountScope$AllAccountsEnabled' => '<p>A boolean value that indicates if the administrator can apply policies to all accounts within an organization. If true, the administrator can apply policies to all accounts within the organization. You can either enable management of all accounts through this operation, or you can specify a list of accounts to manage in <code>AccountScope$Accounts</code>. You cannot specify both.</p>', 'AccountScope$ExcludeSpecifiedAccounts' => '<p>A boolean value that excludes the accounts in <code>AccountScope$Accounts</code> from the administrator\'s scope. If true, the Firewall Manager administrator can apply policies to all members of the organization except for the accounts listed in <code>AccountScope$Accounts</code>. You can either specify a list of accounts to exclude by <code>AccountScope$Accounts</code>, or you can enable management of all accounts by <code>AccountScope$AllAccountsEnabled</code>. You cannot specify both.</p>', 'AdminAccountSummary$DefaultAdmin' => '<p>A boolean value that indicates if the administrator is the default administrator. If true, then this is the default administrator account. The default administrator can manage third-party firewalls and has full administrative scope. There is only one default administrator account per organization. For information about Firewall Manager default administrator accounts, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/fms-administrators.html">Managing Firewall Manager administrators</a> in the <i>Firewall Manager Developer Guide</i>.</p>', 'CreateNetworkAclAction$FMSCanRemediate' => '<p>Indicates whether it is possible for Firewall Manager to perform this remediation action. A false value indicates that auto remediation is disabled or Firewall Manager is unable to perform the action due to a conflict of some kind.</p>', 'CreateNetworkAclEntriesAction$FMSCanRemediate' => '<p>Indicates whether it is possible for Firewall Manager to perform this remediation action. A false value indicates that auto remediation is disabled or Firewall Manager is unable to perform the action due to a conflict of some kind.</p>', 'DeleteNetworkAclEntriesAction$FMSCanRemediate' => '<p>Indicates whether it is possible for Firewall Manager to perform this remediation action. A false value indicates that auto remediation is disabled or Firewall Manager is unable to perform the action due to a conflict of some kind.</p>', 'DeletePolicyRequest$DeleteAllPolicyResources' => '<p>If <code>True</code>, the request performs cleanup according to the policy type. </p> <p>For WAF and Shield Advanced policies, the cleanup does the following:</p> <ul> <li> <p>Deletes rule groups created by Firewall Manager</p> </li> <li> <p>Removes web ACLs from in-scope resources</p> </li> <li> <p>Deletes web ACLs that contain no rules or rule groups</p> </li> </ul> <p>For security group policies, the cleanup does the following for each security group in the policy:</p> <ul> <li> <p>Disassociates the security group from in-scope resources </p> </li> <li> <p>Deletes the security group if it was created through Firewall Manager and if it\'s no longer associated with any resources through another policy</p> </li> </ul> <note> <p>For security group common policies, even if set to <code>False</code>, Firewall Manager deletes all security groups created by Firewall Manager that aren\'t associated with any other resources through another policy.</p> </note> <p>After the cleanup, in-scope resources are no longer protected by web ACLs in this policy. Protection of out-of-scope resources remains unchanged. Scope is determined by tags that you create and accounts that you associate with the policy. When creating the policy, if you specify that only resources in specific accounts or with specific tags are in scope of the policy, those accounts and resources are handled by the policy. All others are out of scope. If you don\'t specify tags or accounts, all resources are in scope. </p>', 'EvaluationResult$EvaluationLimitExceeded' => '<p>Indicates that over 100 resources are noncompliant with the Firewall Manager policy.</p>', 'GetAppsListRequest$DefaultList' => '<p>Specifies whether the list to retrieve is a default list owned by Firewall Manager.</p>', 'GetProtocolsListRequest$DefaultList' => '<p>Specifies whether the list to retrieve is a default list owned by Firewall Manager.</p>', 'ListAppsListsRequest$DefaultLists' => '<p>Specifies whether the lists to retrieve are default lists owned by Firewall Manager.</p>', 'ListProtocolsListsRequest$DefaultLists' => '<p>Specifies whether the lists to retrieve are default lists owned by Firewall Manager.</p>', 'NetworkFirewallInternetTrafficNotInspectedViolation$IsRouteTableUsedInDifferentAZ' => '<p>Information about whether the route table is used in another Availability Zone.</p>', 'NetworkFirewallInvalidRouteConfigurationViolation$IsRouteTableUsedInDifferentAZ' => '<p>Information about whether the route table is used in another Availability Zone.</p>', 'OrganizationalUnitScope$AllOrganizationalUnitsEnabled' => '<p>A boolean value that indicates if the administrator can apply policies to all OUs within an organization. If true, the administrator can manage all OUs within the organization. You can either enable management of all OUs through this operation, or you can specify OUs to manage in <code>OrganizationalUnitScope$OrganizationalUnits</code>. You cannot specify both.</p>', 'OrganizationalUnitScope$ExcludeSpecifiedOrganizationalUnits' => '<p>A boolean value that excludes the OUs in <code>OrganizationalUnitScope$OrganizationalUnits</code> from the administrator\'s scope. If true, the Firewall Manager administrator can apply policies to all OUs in the organization except for the OUs listed in <code>OrganizationalUnitScope$OrganizationalUnits</code>. You can either specify a list of OUs to exclude by <code>OrganizationalUnitScope$OrganizationalUnits</code>, or you can enable management of all OUs by <code>OrganizationalUnitScope$AllOrganizationalUnitsEnabled</code>. You cannot specify both.</p>', 'Policy$ExcludeResourceTags' => '<p>If set to <code>True</code>, resources with the tags that are specified in the <code>ResourceTag</code> array are not in scope of the policy. If set to <code>False</code>, and the <code>ResourceTag</code> array is not null, only resources with the specified tags are in scope of the policy.</p>', 'Policy$RemediationEnabled' => '<p>Indicates if the policy should be automatically applied to new resources.</p>', 'Policy$DeleteUnusedFMManagedResources' => '<p>Indicates whether Firewall Manager should automatically remove protections from resources that leave the policy scope and clean up resources that Firewall Manager is managing for accounts when those accounts leave policy scope. For example, Firewall Manager will disassociate a Firewall Manager managed web ACL from a protected customer resource when the customer resource leaves policy scope. </p> <p>By default, Firewall Manager doesn\'t remove protections or delete Firewall Manager managed resources. </p> <p>This option is not available for Shield Advanced or WAF Classic policies.</p>', 'PolicyComplianceDetail$EvaluationLimitExceeded' => '<p>Indicates if over 100 resources are noncompliant with the Firewall Manager policy.</p>', 'PolicySummary$RemediationEnabled' => '<p>Indicates if the policy should be automatically applied to new resources.</p>', 'PolicySummary$DeleteUnusedFMManagedResources' => '<p>Indicates whether Firewall Manager should automatically remove protections from resources that leave the policy scope and clean up resources that Firewall Manager is managing for accounts when those accounts leave policy scope. For example, Firewall Manager will disassociate a Firewall Manager managed web ACL from a protected customer resource when the customer resource leaves policy scope. </p> <p>By default, Firewall Manager doesn\'t remove protections or delete Firewall Manager managed resources. </p> <p>This option is not available for Shield Advanced or WAF Classic policies.</p>', 'PolicyTypeScope$AllPolicyTypesEnabled' => '<p>Allows the specified Firewall Manager administrator to manage all Firewall Manager policy types, except for third-party policy types. Third-party policy types can only be managed by the Firewall Manager default administrator.</p>', 'PossibleRemediationAction$IsDefaultAction' => '<p>Information about whether an action is taken by default.</p>', 'RegionScope$AllRegionsEnabled' => '<p>Allows the specified Firewall Manager administrator to manage all Amazon Web Services Regions.</p>', 'ReplaceNetworkAclAssociationAction$FMSCanRemediate' => '<p>Indicates whether it is possible for Firewall Manager to perform this remediation action. A false value indicates that auto remediation is disabled or Firewall Manager is unable to perform the action due to a conflict of some kind.</p>', 'SecurityGroupRemediationAction$IsDefaultAction' => '<p>Indicates if the current action is the default action.</p>', ], ], 'BooleanObject' => [ 'base' => NULL, 'refs' => [ 'NetworkAclEntry$Egress' => '<p>Indicates whether the rule is an egress, or outbound, rule (applied to traffic leaving the subnet). If it\'s not an egress rule, then it\'s an ingress, or inbound, rule.</p>', 'NetworkAclEntrySet$ForceRemediateForFirstEntries' => '<p>Applies only when remediation is enabled for the policy as a whole. Firewall Manager uses this setting when it finds policy violations that involve conflicts between the custom entries and the policy entries. </p> <p>If forced remediation is disabled, Firewall Manager marks the network ACL as noncompliant and does not try to remediate. For more information about the remediation behavior, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/network-acl-policies.html#network-acls-remediation">Remediation for managed network ACLs</a> in the <i>Firewall Manager Developer Guide</i>.</p>', 'NetworkAclEntrySet$ForceRemediateForLastEntries' => '<p>Applies only when remediation is enabled for the policy as a whole. Firewall Manager uses this setting when it finds policy violations that involve conflicts between the custom entries and the policy entries. </p> <p>If forced remediation is disabled, Firewall Manager marks the network ACL as noncompliant and does not try to remediate. For more information about the remediation behavior, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/network-acl-policies.html#network-acls-remediation">Remediation for managed network ACLs</a> in the <i>Firewall Manager Developer Guide</i>.</p>', ], ], 'CIDR' => [ 'base' => NULL, 'refs' => [ 'EC2CreateRouteAction$DestinationCidrBlock' => '<p>Information about the IPv4 CIDR address block used for the destination match.</p>', 'EC2CreateRouteAction$DestinationIpv6CidrBlock' => '<p>Information about the IPv6 CIDR block destination.</p>', 'EC2DeleteRouteAction$DestinationCidrBlock' => '<p>Information about the IPv4 CIDR range for the route. The value you specify must match the CIDR for the route exactly.</p>', 'EC2DeleteRouteAction$DestinationIpv6CidrBlock' => '<p>Information about the IPv6 CIDR range for the route. The value you specify must match the CIDR for the route exactly.</p>', 'EC2ReplaceRouteAction$DestinationCidrBlock' => '<p>Information about the IPv4 CIDR address block used for the destination match. The value that you provide must match the CIDR of an existing route in the table.</p>', 'EC2ReplaceRouteAction$DestinationIpv6CidrBlock' => '<p>Information about the IPv6 CIDR address block used for the destination match. The value that you provide must match the CIDR of an existing route in the table.</p>', 'ExpectedRoute$IpV4Cidr' => '<p>Information about the IPv4 CIDR block.</p>', 'ExpectedRoute$PrefixListId' => '<p>Information about the ID of the prefix list for the route.</p>', 'ExpectedRoute$IpV6Cidr' => '<p>Information about the IPv6 CIDR block.</p>', 'SecurityGroupRuleDescription$IPV4Range' => '<p>The IPv4 ranges for the security group rule.</p>', 'SecurityGroupRuleDescription$IPV6Range' => '<p>The IPv6 ranges for the security group rule.</p>', ], ], 'ComplianceViolator' => [ 'base' => '<p>Details of the resource that is not protected by the policy.</p>', 'refs' => [ 'ComplianceViolators$member' => NULL, ], ], 'ComplianceViolatorMetadata' => [ 'base' => NULL, 'refs' => [ 'ComplianceViolator$Metadata' => '<p>Metadata about the resource that doesn\'t comply with the policy scope.</p>', ], ], 'ComplianceViolators' => [ 'base' => NULL, 'refs' => [ 'PolicyComplianceDetail$Violators' => '<p>An array of resources that aren\'t protected by the WAF or Shield Advanced policy or that aren\'t in compliance with the security group policy.</p>', ], ], 'CreateNetworkAclAction' => [ 'base' => '<p>Information about the <code>CreateNetworkAcl</code> action in Amazon EC2. This is a remediation option in <code>RemediationAction</code>.</p>', 'refs' => [ 'RemediationAction$CreateNetworkAclAction' => '<p>Information about the <code>CreateNetworkAcl</code> action in Amazon EC2.</p>', ], ], 'CreateNetworkAclEntriesAction' => [ 'base' => '<p>Information about the <code>CreateNetworkAclEntries</code> action in Amazon EC2. This is a remediation option in <code>RemediationAction</code>.</p>', 'refs' => [ 'RemediationAction$CreateNetworkAclEntriesAction' => '<p>Information about the <code>CreateNetworkAclEntries</code> action in Amazon EC2.</p>', ], ], 'CustomerPolicyScopeId' => [ 'base' => NULL, 'refs' => [ 'CustomerPolicyScopeIdList$member' => NULL, ], ], 'CustomerPolicyScopeIdList' => [ 'base' => NULL, 'refs' => [ 'CustomerPolicyScopeMap$value' => NULL, ], ], 'CustomerPolicyScopeIdType' => [ 'base' => NULL, 'refs' => [ 'CustomerPolicyScopeMap$key' => NULL, ], ], 'CustomerPolicyScopeMap' => [ 'base' => NULL, 'refs' => [ 'Policy$IncludeMap' => '<p>Specifies the Amazon Web Services account IDs and Organizations organizational units (OUs) to include in the policy. Specifying an OU is the equivalent of specifying all accounts in the OU and in any of its child OUs, including any child OUs and accounts that are added at a later time.</p> <p>You can specify inclusions or exclusions, but not both. If you specify an <code>IncludeMap</code>, Firewall Manager applies the policy to all accounts specified by the <code>IncludeMap</code>, and does not evaluate any <code>ExcludeMap</code> specifications. If you do not specify an <code>IncludeMap</code>, then Firewall Manager applies the policy to all accounts except for those specified by the <code>ExcludeMap</code>.</p> <p>You can specify account IDs, OUs, or a combination: </p> <ul> <li> <p>Specify account IDs by setting the key to <code>ACCOUNT</code>. For example, the following is a valid map: <code>{“ACCOUNT” : [“accountID1”, “accountID2”]}</code>.</p> </li> <li> <p>Specify OUs by setting the key to <code>ORG_UNIT</code>. For example, the following is a valid map: <code>{“ORG_UNIT” : [“ouid111”, “ouid112”]}</code>.</p> </li> <li> <p>Specify accounts and OUs together in a single map, separated with a comma. For example, the following is a valid map: <code>{“ACCOUNT” : [“accountID1”, “accountID2”], “ORG_UNIT” : [“ouid111”, “ouid112”]}</code>.</p> </li> </ul>', 'Policy$ExcludeMap' => '<p>Specifies the Amazon Web Services account IDs and Organizations organizational units (OUs) to exclude from the policy. Specifying an OU is the equivalent of specifying all accounts in the OU and in any of its child OUs, including any child OUs and accounts that are added at a later time.</p> <p>You can specify inclusions or exclusions, but not both. If you specify an <code>IncludeMap</code>, Firewall Manager applies the policy to all accounts specified by the <code>IncludeMap</code>, and does not evaluate any <code>ExcludeMap</code> specifications. If you do not specify an <code>IncludeMap</code>, then Firewall Manager applies the policy to all accounts except for those specified by the <code>ExcludeMap</code>.</p> <p>You can specify account IDs, OUs, or a combination: </p> <ul> <li> <p>Specify account IDs by setting the key to <code>ACCOUNT</code>. For example, the following is a valid map: <code>{“ACCOUNT” : [“accountID1”, “accountID2”]}</code>.</p> </li> <li> <p>Specify OUs by setting the key to <code>ORG_UNIT</code>. For example, the following is a valid map: <code>{“ORG_UNIT” : [“ouid111”, “ouid112”]}</code>.</p> </li> <li> <p>Specify accounts and OUs together in a single map, separated with a comma. For example, the following is a valid map: <code>{“ACCOUNT” : [“accountID1”, “accountID2”], “ORG_UNIT” : [“ouid111”, “ouid112”]}</code>.</p> </li> </ul>', ], ], 'CustomerPolicyStatus' => [ 'base' => NULL, 'refs' => [ 'Policy$PolicyStatus' => '<p>Indicates whether the policy is in or out of an admin\'s policy or Region scope.</p> <ul> <li> <p> <code>ACTIVE</code> - The administrator can manage and delete the policy.</p> </li> <li> <p> <code>OUT_OF_ADMIN_SCOPE</code> - The administrator can view the policy, but they can\'t edit or delete the policy. Existing policy protections stay in place. Any new resources that come into scope of the policy won\'t be protected.</p> </li> </ul>', 'PolicySummary$PolicyStatus' => '<p>Indicates whether the policy is in or out of an admin\'s policy or Region scope.</p> <ul> <li> <p> <code>ACTIVE</code> - The administrator can manage and delete the policy.</p> </li> <li> <p> <code>OUT_OF_ADMIN_SCOPE</code> - The administrator can view the policy, but they can\'t edit or delete the policy. Existing policy protections stay in place. Any new resources that come into scope of the policy won\'t be protected.</p> </li> </ul>', ], ], 'DeleteAppsListRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteNetworkAclEntriesAction' => [ 'base' => '<p>Information about the <code>DeleteNetworkAclEntries</code> action in Amazon EC2. This is a remediation option in <code>RemediationAction</code>. </p>', 'refs' => [ 'RemediationAction$DeleteNetworkAclEntriesAction' => '<p>Information about the <code>DeleteNetworkAclEntries</code> action in Amazon EC2.</p>', ], ], 'DeleteNotificationChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteProtocolsListRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResourceSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DependentServiceName' => [ 'base' => NULL, 'refs' => [ 'IssueInfoMap$key' => NULL, ], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'ResourceSet$Description' => '<p>A description of the resource set.</p>', 'ResourceSetSummary$Description' => '<p>A description of the resource set.</p>', ], ], 'DestinationType' => [ 'base' => NULL, 'refs' => [ 'Route$DestinationType' => '<p>The type of destination for the route.</p>', ], ], 'DetailedInfo' => [ 'base' => NULL, 'refs' => [ 'IssueInfoMap$value' => NULL, ], ], 'DisassociateAdminAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateThirdPartyFirewallRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateThirdPartyFirewallResponse' => [ 'base' => NULL, 'refs' => [], ], 'DiscoveredResource' => [ 'base' => '<p>A resource in the organization that\'s available to be associated with a Firewall Manager resource set.</p>', 'refs' => [ 'DiscoveredResourceList$member' => NULL, ], ], 'DiscoveredResourceList' => [ 'base' => NULL, 'refs' => [ 'ListDiscoveredResourcesResponse$Items' => '<p>Details of the resources that were discovered.</p>', ], ], 'DnsDuplicateRuleGroupViolation' => [ 'base' => '<p>A DNS Firewall rule group that Firewall Manager tried to associate with a VPC is already associated with the VPC and can\'t be associated again. </p>', 'refs' => [ 'ResourceViolation$DnsDuplicateRuleGroupViolation' => '<p>Violation detail for a DNS Firewall policy that indicates that a rule group that Firewall Manager tried to associate with a VPC is already associated with the VPC and can\'t be associated again. </p>', ], ], 'DnsRuleGroupLimitExceededViolation' => [ 'base' => '<p>The VPC that Firewall Manager was applying a DNS Fireall policy to reached the limit for associated DNS Firewall rule groups. Firewall Manager tried to associate another rule group with the VPC and failed due to the limit. </p>', 'refs' => [ 'ResourceViolation$DnsRuleGroupLimitExceededViolation' => '<p>Violation detail for a DNS Firewall policy that indicates that the VPC reached the limit for associated DNS Firewall rule groups. Firewall Manager tried to associate another rule group with the VPC and failed. </p>', ], ], 'DnsRuleGroupPriorities' => [ 'base' => NULL, 'refs' => [ 'DnsRuleGroupPriorityConflictViolation$UnavailablePriorities' => '<p>The priorities of rule groups that are already associated with the VPC. To retry your operation, choose priority settings that aren\'t in this list for the rule groups in your new DNS Firewall policy. </p>', ], ], 'DnsRuleGroupPriority' => [ 'base' => NULL, 'refs' => [ 'DnsRuleGroupPriorities$member' => NULL, 'DnsRuleGroupPriorityConflictViolation$ConflictingPriority' => '<p>The priority setting of the two conflicting rule groups.</p>', ], ], 'DnsRuleGroupPriorityConflictViolation' => [ 'base' => '<p>A rule group that Firewall Manager tried to associate with a VPC has the same priority as a rule group that\'s already associated. </p>', 'refs' => [ 'ResourceViolation$DnsRuleGroupPriorityConflictViolation' => '<p>Violation detail for a DNS Firewall policy that indicates that a rule group that Firewall Manager tried to associate with a VPC has the same priority as a rule group that\'s already associated. </p>', ], ], 'EC2AssociateRouteTableAction' => [ 'base' => '<p>The action of associating an EC2 resource, such as a subnet or internet gateway, with a route table.</p>', 'refs' => [ 'RemediationAction$EC2AssociateRouteTableAction' => '<p>Information about the AssociateRouteTable action in the Amazon EC2 API.</p>', ], ], 'EC2CopyRouteTableAction' => [ 'base' => '<p>An action that copies the EC2 route table for use in remediation.</p>', 'refs' => [ 'RemediationAction$EC2CopyRouteTableAction' => '<p>Information about the CopyRouteTable action in the Amazon EC2 API.</p>', ], ], 'EC2CreateRouteAction' => [ 'base' => '<p>Information about the CreateRoute action in Amazon EC2.</p>', 'refs' => [ 'RemediationAction$EC2CreateRouteAction' => '<p>Information about the CreateRoute action in the Amazon EC2 API.</p>', ], ], 'EC2CreateRouteTableAction' => [ 'base' => '<p>Information about the CreateRouteTable action in Amazon EC2.</p>', 'refs' => [ 'RemediationAction$EC2CreateRouteTableAction' => '<p>Information about the CreateRouteTable action in the Amazon EC2 API.</p>', ], ], 'EC2DeleteRouteAction' => [ 'base' => '<p>Information about the DeleteRoute action in Amazon EC2.</p>', 'refs' => [ 'RemediationAction$EC2DeleteRouteAction' => '<p>Information about the DeleteRoute action in the Amazon EC2 API.</p>', ], ], 'EC2ReplaceRouteAction' => [ 'base' => '<p>Information about the ReplaceRoute action in Amazon EC2.</p>', 'refs' => [ 'RemediationAction$EC2ReplaceRouteAction' => '<p>Information about the ReplaceRoute action in the Amazon EC2 API.</p>', ], ], 'EC2ReplaceRouteTableAssociationAction' => [ 'base' => '<p>Information about the ReplaceRouteTableAssociation action in Amazon EC2.</p>', 'refs' => [ 'RemediationAction$EC2ReplaceRouteTableAssociationAction' => '<p>Information about the ReplaceRouteTableAssociation action in the Amazon EC2 API.</p>', ], ], 'EntriesDescription' => [ 'base' => NULL, 'refs' => [ 'CreateNetworkAclEntriesAction$NetworkAclEntriesToBeCreated' => '<p>Lists the entries that the remediation action would create.</p>', 'DeleteNetworkAclEntriesAction$NetworkAclEntriesToBeDeleted' => '<p>Lists the entries that the remediation action would delete.</p>', ], ], 'EntriesWithConflicts' => [ 'base' => NULL, 'refs' => [ 'EntryViolation$EntriesWithConflicts' => '<p>The list of entries that are in conflict with <code>ExpectedEntry</code>. </p>', ], ], 'EntryDescription' => [ 'base' => '<p>Describes a single rule in a network ACL.</p>', 'refs' => [ 'EntriesDescription$member' => NULL, 'EntriesWithConflicts$member' => NULL, 'EntryViolation$ExpectedEntry' => '<p>The Firewall Manager-managed network ACL entry that is involved in the entry violation. </p>', 'EntryViolation$EntryAtExpectedEvaluationOrder' => '<p>The entry that\'s currently in the <code>ExpectedEvaluationOrder</code> location, in place of the expected entry. </p>', ], ], 'EntryType' => [ 'base' => NULL, 'refs' => [ 'EntryDescription$EntryType' => '<p>Specifies whether the entry is managed by Firewall Manager or by a user, and, for Firewall Manager-managed entries, specifies whether the entry is among those that run first in the network ACL or those that run last. </p>', ], ], 'EntryViolation' => [ 'base' => '<p>Detailed information about an entry violation in a network ACL. The violation is against the network ACL specification inside the Firewall Manager network ACL policy. This data object is part of <code>InvalidNetworkAclEntriesViolation</code>.</p>', 'refs' => [ 'EntryViolations$member' => NULL, ], ], 'EntryViolationReason' => [ 'base' => NULL, 'refs' => [ 'EntryViolationReasons$member' => NULL, ], ], 'EntryViolationReasons' => [ 'base' => NULL, 'refs' => [ 'EntryViolation$EntryViolationReasons' => '<p>Descriptions of the violations that Firewall Manager found for these entries. </p>', ], ], 'EntryViolations' => [ 'base' => NULL, 'refs' => [ 'InvalidNetworkAclEntriesViolation$EntryViolations' => '<p>Detailed information about the entry violations in the network ACL. </p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'InternalErrorException$Message' => NULL, 'InvalidInputException$Message' => NULL, 'InvalidOperationException$Message' => NULL, 'InvalidTypeException$Message' => NULL, 'LimitExceededException$Message' => NULL, 'ResourceNotFoundException$Message' => NULL, ], ], 'EvaluationResult' => [ 'base' => '<p>Describes the compliance status for the account. An account is considered noncompliant if it includes resources that are not protected by the specified policy or that don\'t comply with the policy.</p>', 'refs' => [ 'EvaluationResults$member' => NULL, ], ], 'EvaluationResults' => [ 'base' => NULL, 'refs' => [ 'PolicyComplianceStatus$EvaluationResults' => '<p>An array of <code>EvaluationResult</code> objects.</p>', ], ], 'ExpectedRoute' => [ 'base' => '<p>Information about the expected route in the route table.</p>', 'refs' => [ 'ExpectedRoutes$member' => NULL, ], ], 'ExpectedRoutes' => [ 'base' => NULL, 'refs' => [ 'NetworkFirewallInternetTrafficNotInspectedViolation$ExpectedFirewallSubnetRoutes' => '<p>The firewall subnet routes that are expected.</p>', 'NetworkFirewallInternetTrafficNotInspectedViolation$ExpectedInternetGatewayRoutes' => '<p>The internet gateway routes that are expected.</p>', 'NetworkFirewallInvalidRouteConfigurationViolation$ExpectedFirewallSubnetRoutes' => '<p>The firewall subnet routes that are expected.</p>', 'NetworkFirewallInvalidRouteConfigurationViolation$ExpectedInternetGatewayRoutes' => '<p>The expected routes for the internet gateway.</p>', 'NetworkFirewallMissingExpectedRoutesViolation$ExpectedRoutes' => '<p>The expected routes.</p>', ], ], 'FMSPolicyUpdateFirewallCreationConfigAction' => [ 'base' => '<p>Contains information about the actions that you can take to remediate scope violations caused by your policy\'s <code>FirewallCreationConfig</code>. <code>FirewallCreationConfig</code> is an optional configuration that you can use to choose which Availability Zones Firewall Manager creates Network Firewall endpoints in.</p>', 'refs' => [ 'RemediationAction$FMSPolicyUpdateFirewallCreationConfigAction' => '<p>The remedial action to take when updating a firewall configuration.</p>', ], ], 'FailedItem' => [ 'base' => '<p>Details of a resource that failed when trying to update it\'s association to a resource set.</p>', 'refs' => [ 'FailedItemList$member' => NULL, ], ], 'FailedItemList' => [ 'base' => NULL, 'refs' => [ 'BatchAssociateResourceResponse$FailedItems' => '<p>The resources that failed to associate to the resource set.</p>', 'BatchDisassociateResourceResponse$FailedItems' => '<p>The resources that failed to disassociate from the resource set.</p>', ], ], 'FailedItemReason' => [ 'base' => NULL, 'refs' => [ 'FailedItem$Reason' => '<p>The reason the resource\'s association could not be updated.</p>', ], ], 'FirewallDeploymentModel' => [ 'base' => NULL, 'refs' => [ 'NetworkFirewallPolicy$FirewallDeploymentModel' => '<p>Defines the deployment model to use for the firewall policy. To use a distributed model, set <a href="https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_PolicyOption.html">PolicyOption</a> to <code>NULL</code>.</p>', 'ThirdPartyFirewallPolicy$FirewallDeploymentModel' => '<p>Defines the deployment model to use for the third-party firewall policy.</p>', ], ], 'FirewallPolicyId' => [ 'base' => NULL, 'refs' => [ 'ThirdPartyFirewallFirewallPolicy$FirewallPolicyId' => '<p>The ID of the specified firewall policy.</p>', ], ], 'FirewallPolicyName' => [ 'base' => NULL, 'refs' => [ 'ThirdPartyFirewallFirewallPolicy$FirewallPolicyName' => '<p>The name of the specified firewall policy.</p>', ], ], 'FirewallSubnetIsOutOfScopeViolation' => [ 'base' => '<p>Contains details about the firewall subnet that violates the policy scope.</p>', 'refs' => [ 'ResourceViolation$FirewallSubnetIsOutOfScopeViolation' => '<p>Contains details about the firewall subnet that violates the policy scope.</p>', ], ], 'FirewallSubnetMissingVPCEndpointViolation' => [ 'base' => '<p>The violation details for a firewall subnet\'s VPC endpoint that\'s deleted or missing.</p>', 'refs' => [ 'ResourceViolation$FirewallSubnetMissingVPCEndpointViolation' => '<p>The violation details for a third-party firewall\'s VPC endpoint subnet that was deleted.</p>', ], ], 'GetAdminAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAdminAccountResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetAdminScopeRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAdminScopeResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetAppsListRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAppsListResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetComplianceDetailRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetComplianceDetailResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetNotificationChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetNotificationChannelResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetProtectionStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetProtectionStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetProtocolsListRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetProtocolsListResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetResourceSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetResourceSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetThirdPartyFirewallAssociationStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetThirdPartyFirewallAssociationStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetViolationDetailsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetViolationDetailsResponse' => [ 'base' => NULL, 'refs' => [], ], 'IPPortNumber' => [ 'base' => NULL, 'refs' => [ 'App$Port' => '<p>The application\'s port number, for example <code>80</code>.</p>', 'SecurityGroupRuleDescription$FromPort' => '<p>The start of the port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type number. A value of <code>-1</code> indicates all ICMP/ICMPv6 types.</p>', 'SecurityGroupRuleDescription$ToPort' => '<p>The end of the port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code. A value of <code>-1</code> indicates all ICMP/ICMPv6 codes.</p>', ], ], 'IPPortNumberInteger' => [ 'base' => NULL, 'refs' => [ 'NetworkAclPortRange$From' => '<p>The beginning port number of the range. </p>', 'NetworkAclPortRange$To' => '<p>The ending port number of the range. </p>', ], ], 'Identifier' => [ 'base' => NULL, 'refs' => [ 'BatchAssociateResourceRequest$ResourceSetIdentifier' => '<p>A unique identifier for the resource set, used in a request to refer to the resource set.</p>', 'BatchAssociateResourceResponse$ResourceSetIdentifier' => '<p>A unique identifier for the resource set, used in a request to refer to the resource set.</p>', 'BatchDisassociateResourceRequest$ResourceSetIdentifier' => '<p>A unique identifier for the resource set, used in a request to refer to the resource set.</p>', 'BatchDisassociateResourceResponse$ResourceSetIdentifier' => '<p>A unique identifier for the resource set, used in a request to refer to the resource set.</p>', 'DiscoveredResource$URI' => '<p>The universal resource identifier (URI) of the discovered resource.</p>', 'FailedItem$URI' => '<p>The univeral resource indicator (URI) of the resource that failed.</p>', 'IdentifierList$member' => NULL, 'Resource$URI' => '<p>The resource\'s universal resource indicator (URI).</p>', ], ], 'IdentifierList' => [ 'base' => NULL, 'refs' => [ 'BatchAssociateResourceRequest$Items' => '<p>The uniform resource identifiers (URIs) of resources that should be associated to the resource set. The URIs must be Amazon Resource Names (ARNs).</p>', 'BatchDisassociateResourceRequest$Items' => '<p>The uniform resource identifiers (URI) of resources that should be disassociated from the resource set. The URIs must be Amazon Resource Names (ARNs).</p>', ], ], 'IntegerObject' => [ 'base' => NULL, 'refs' => [ 'NetworkAclIcmpTypeCode$Code' => '<p>ICMP code. </p>', 'NetworkAclIcmpTypeCode$Type' => '<p>ICMP type. </p>', ], ], 'IntegerObjectMinimum0' => [ 'base' => NULL, 'refs' => [ 'EntryDescription$EntryRuleNumber' => '<p>The rule number for the entry. ACL entries are processed in ascending order by rule number. In a Firewall Manager network ACL policy, Firewall Manager assigns rule numbers. </p>', ], ], 'InternalErrorException' => [ 'base' => '<p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>', 'refs' => [], ], 'InvalidInputException' => [ 'base' => '<p>The parameters of the request were invalid.</p>', 'refs' => [], ], 'InvalidNetworkAclEntriesViolation' => [ 'base' => '<p>Violation detail for the entries in a network ACL resource.</p>', 'refs' => [ 'ResourceViolation$InvalidNetworkAclEntriesViolation' => '<p>Violation detail for the entries in a network ACL resource.</p>', ], ], 'InvalidOperationException' => [ 'base' => '<p>The operation failed because there was nothing to do or the operation wasn\'t possible. For example, you might have submitted an <code>AssociateAdminAccount</code> request for an account ID that was already set as the Firewall Manager administrator. Or you might have tried to access a Region that\'s disabled by default, and that you need to enable for the Firewall Manager administrator account and for Organizations before you can access it.</p>', 'refs' => [], ], 'InvalidTypeException' => [ 'base' => '<p>The value of the <code>Type</code> parameter is invalid.</p>', 'refs' => [], ], 'IssueInfoMap' => [ 'base' => NULL, 'refs' => [ 'PolicyComplianceDetail$IssueInfoMap' => '<p>Details about problems with dependent services, such as WAF or Config, and the error message received that indicates the problem with the service.</p>', 'PolicyComplianceStatus$IssueInfoMap' => '<p>Details about problems with dependent services, such as WAF or Config, and the error message received that indicates the problem with the service.</p>', ], ], 'LengthBoundedNonEmptyString' => [ 'base' => NULL, 'refs' => [ 'NetworkAclEntry$CidrBlock' => '<p>The IPv4 network range to allow or deny, in CIDR notation.</p>', 'NetworkAclEntry$Ipv6CidrBlock' => '<p>The IPv6 network range to allow or deny, in CIDR notation.</p>', ], ], 'LengthBoundedString' => [ 'base' => NULL, 'refs' => [ 'ActionTarget$Description' => '<p>A description of the remediation action target.</p>', 'AwsVPCSecurityGroupViolation$ViolationTargetDescription' => '<p>A description of the security group that violates the policy.</p>', 'ComplianceViolatorMetadata$key' => NULL, 'ComplianceViolatorMetadata$value' => NULL, 'CreateNetworkAclAction$Description' => '<p>Brief description of this remediation action. </p>', 'CreateNetworkAclEntriesAction$Description' => '<p>Brief description of this remediation action. </p>', 'DeleteNetworkAclEntriesAction$Description' => '<p>Brief description of this remediation action. </p>', 'DnsDuplicateRuleGroupViolation$ViolationTargetDescription' => '<p>A description of the violation that specifies the rule group and VPC.</p>', 'DnsRuleGroupLimitExceededViolation$ViolationTargetDescription' => '<p>A description of the violation that specifies the rule group and VPC.</p>', 'DnsRuleGroupPriorityConflictViolation$ViolationTargetDescription' => '<p>A description of the violation that specifies the VPC and the rule group that\'s already associated with it.</p>', 'EC2AssociateRouteTableAction$Description' => '<p>A description of the EC2 route table that is associated with the remediation action.</p>', 'EC2CopyRouteTableAction$Description' => '<p>A description of the copied EC2 route table that is associated with the remediation action.</p>', 'EC2CreateRouteAction$Description' => '<p>A description of CreateRoute action in Amazon EC2.</p>', 'EC2CreateRouteTableAction$Description' => '<p>A description of the CreateRouteTable action.</p>', 'EC2DeleteRouteAction$Description' => '<p>A description of the DeleteRoute action.</p>', 'EC2ReplaceRouteAction$Description' => '<p>A description of the ReplaceRoute action in Amazon EC2.</p>', 'EC2ReplaceRouteTableAssociationAction$Description' => '<p>A description of the ReplaceRouteTableAssociation action in Amazon EC2.</p>', 'EntryViolation$ExpectedEvaluationOrder' => '<p>The evaluation location within the ordered list of entries where the <code>ExpectedEntry</code> should be, according to the network ACL policy specifications. </p>', 'EntryViolation$ActualEvaluationOrder' => '<p>The evaluation location within the ordered list of entries where the <code>ExpectedEntry</code> is currently located. </p>', 'FMSPolicyUpdateFirewallCreationConfigAction$Description' => '<p>Describes the remedial action.</p>', 'FirewallSubnetIsOutOfScopeViolation$SubnetAvailabilityZone' => '<p>The Availability Zone of the firewall subnet that violates the policy scope.</p>', 'FirewallSubnetIsOutOfScopeViolation$SubnetAvailabilityZoneId' => '<p>The Availability Zone ID of the firewall subnet that violates the policy scope.</p>', 'FirewallSubnetMissingVPCEndpointViolation$SubnetAvailabilityZone' => '<p>The name of the Availability Zone of the deleted VPC subnet.</p>', 'FirewallSubnetMissingVPCEndpointViolation$SubnetAvailabilityZoneId' => '<p>The ID of the Availability Zone of the deleted VPC subnet.</p>', 'InvalidNetworkAclEntriesViolation$SubnetAvailabilityZone' => '<p>The Availability Zone where the network ACL is in use. </p>', 'LengthBoundedStringList$member' => NULL, 'NetworkAclEntry$Protocol' => '<p>The protocol number. A value of "-1" means all protocols. </p>', 'NetworkFirewallInternetTrafficNotInspectedViolation$SubnetAvailabilityZone' => '<p>The subnet Availability Zone.</p>', 'NetworkFirewallMissingExpectedRTViolation$AvailabilityZone' => '<p>The Availability Zone of a violating subnet. </p>', 'NetworkFirewallMissingFirewallViolation$AvailabilityZone' => '<p>The Availability Zone of a violating subnet. </p>', 'NetworkFirewallMissingSubnetViolation$AvailabilityZone' => '<p>The Availability Zone of a violating subnet. </p>', 'PossibleRemediationAction$Description' => '<p>A description of the list of remediation actions.</p>', 'PossibleRemediationActions$Description' => '<p>A description of the possible remediation actions list.</p>', 'RemediationAction$Description' => '<p>A description of a remediation action.</p>', 'ReplaceNetworkAclAssociationAction$Description' => '<p>Brief description of this remediation action. </p>', 'Route$Destination' => '<p>The destination of the route.</p>', 'Route$Target' => '<p>The route\'s target.</p>', 'RouteHasOutOfScopeEndpointViolation$SubnetAvailabilityZone' => '<p>The subnet\'s Availability Zone.</p>', 'RouteHasOutOfScopeEndpointViolation$SubnetAvailabilityZoneId' => '<p>The ID of the subnet\'s Availability Zone.</p>', 'SecurityGroupRuleDescription$Protocol' => '<p>The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>, <code>icmpv6</code>) or number.</p>', 'ThirdPartyFirewallMissingExpectedRouteTableViolation$AvailabilityZone' => '<p>The Availability Zone of the firewall subnet that\'s causing the violation.</p>', 'ThirdPartyFirewallMissingFirewallViolation$AvailabilityZone' => '<p>The Availability Zone of the third-party firewall that\'s causing the violation.</p>', 'ThirdPartyFirewallMissingSubnetViolation$AvailabilityZone' => '<p>The Availability Zone of a subnet that\'s causing the violation.</p>', 'ViolationDetail$ResourceDescription' => '<p>Brief description for the requested resource.</p>', ], ], 'LengthBoundedStringList' => [ 'base' => NULL, 'refs' => [ 'ExpectedRoute$AllowedTargets' => '<p>Information about the allowed targets.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>The operation exceeds a resource limit, for example, the maximum number of <code>policy</code> objects that you can create for an Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/fms-limits.html">Firewall Manager Limits</a> in the <i>WAF Developer Guide</i>.</p>', 'refs' => [], ], 'ListAdminAccountsForOrganizationRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAdminAccountsForOrganizationResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAdminsManagingAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAdminsManagingAccountResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAppsListsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAppsListsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListComplianceStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListComplianceStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDiscoveredResourcesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDiscoveredResourcesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListId' => [ 'base' => NULL, 'refs' => [ 'AppsListData$ListId' => '<p>The ID of the Firewall Manager applications list.</p>', 'AppsListDataSummary$ListId' => '<p>The ID of the applications list.</p>', 'DeleteAppsListRequest$ListId' => '<p>The ID of the applications list that you want to delete. You can retrieve this ID from <code>PutAppsList</code>, <code>ListAppsLists</code>, and <code>GetAppsList</code>.</p>', 'DeleteProtocolsListRequest$ListId' => '<p>The ID of the protocols list that you want to delete. You can retrieve this ID from <code>PutProtocolsList</code>, <code>ListProtocolsLists</code>, and <code>GetProtocolsLost</code>.</p>', 'GetAppsListRequest$ListId' => '<p>The ID of the Firewall Manager applications list that you want the details for.</p>', 'GetProtocolsListRequest$ListId' => '<p>The ID of the Firewall Manager protocols list that you want the details for.</p>', 'ProtocolsListData$ListId' => '<p>The ID of the Firewall Manager protocols list.</p>', 'ProtocolsListDataSummary$ListId' => '<p>The ID of the specified protocols list.</p>', ], ], 'ListMemberAccountsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListMemberAccountsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPoliciesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPoliciesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListProtocolsListsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListProtocolsListsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListResourceSetResourcesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListResourceSetResourcesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListResourceSetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListResourceSetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListThirdPartyFirewallFirewallPoliciesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListThirdPartyFirewallFirewallPoliciesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ManagedServiceData' => [ 'base' => NULL, 'refs' => [ 'FMSPolicyUpdateFirewallCreationConfigAction$FirewallCreationConfig' => '<p>A <code>FirewallCreationConfig</code> that you can copy into your current policy\'s <a href="https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_SecurityServicePolicyData.html">SecurityServiceData</a> in order to remedy scope violations.</p>', 'SecurityServicePolicyData$ManagedServiceData' => '<p>Details about the service that are specific to the service type, in JSON format. </p> <ul> <li> <p>Example: <code>DNS_FIREWALL</code> </p> <p> <code>"{\\"type\\":\\"DNS_FIREWALL\\",\\"preProcessRuleGroups\\":[{\\"ruleGroupId\\":\\"rslvr-frg-1\\",\\"priority\\":10}],\\"postProcessRuleGroups\\":[{\\"ruleGroupId\\":\\"rslvr-frg-2\\",\\"priority\\":9911}]}"</code> </p> <note> <p>Valid values for <code>preProcessRuleGroups</code> are between 1 and 99. Valid values for <code>postProcessRuleGroups</code> are between 9901 and 10000.</p> </note> </li> <li> <p>Example: <code>IMPORT_NETWORK_FIREWALL</code> </p> <p> <code>"{\\"type\\":\\"IMPORT_NETWORK_FIREWALL\\",\\"awsNetworkFirewallConfig\\":{\\"networkFirewallStatelessRuleGroupReferences\\":[{\\"resourceARN\\":\\"arn:aws:network-firewall:us-west-2:000000000000:stateless-rulegroup\\/rg1\\",\\"priority\\":1}],\\"networkFirewallStatelessDefaultActions\\":[\\"aws:drop\\"],\\"networkFirewallStatelessFragmentDefaultActions\\":[\\"aws:pass\\"],\\"networkFirewallStatelessCustomActions\\":[],\\"networkFirewallStatefulRuleGroupReferences\\":[{\\"resourceARN\\":\\"arn:aws:network-firewall:us-west-2:aws-managed:stateful-rulegroup\\/ThreatSignaturesEmergingEventsStrictOrder\\",\\"priority\\":8}],\\"networkFirewallStatefulEngineOptions\\":{\\"ruleOrder\\":\\"STRICT_ORDER\\"},\\"networkFirewallStatefulDefaultActions\\":[\\"aws:drop_strict\\"]}}"</code> </p> <p> <code>"{\\"type\\":\\"DNS_FIREWALL\\",\\"preProcessRuleGroups\\":[{\\"ruleGroupId\\":\\"rslvr-frg-1\\",\\"priority\\":10}],\\"postProcessRuleGroups\\":[{\\"ruleGroupId\\":\\"rslvr-frg-2\\",\\"priority\\":9911}]}"</code> </p> <note> <p>Valid values for <code>preProcessRuleGroups</code> are between 1 and 99. Valid values for <code>postProcessRuleGroups</code> are between 9901 and 10000.</p> </note> </li> <li> <p>Example: <code>NETWORK_FIREWALL</code> - Centralized deployment model</p> <p> <code>"{\\"type\\":\\"NETWORK_FIREWALL\\",\\"awsNetworkFirewallConfig\\":{\\"networkFirewallStatelessRuleGroupReferences\\":[{\\"resourceARN\\":\\"arn:aws:network-firewall:us-east-1:123456789011:stateless-rulegroup/test\\",\\"priority\\":1}],\\"networkFirewallStatelessDefaultActions\\":[\\"aws:forward_to_sfe\\",\\"customActionName\\"],\\"networkFirewallStatelessFragmentDefaultActions\\":[\\"aws:forward_to_sfe\\",\\"customActionName\\"],\\"networkFirewallStatelessCustomActions\\":[{\\"actionName\\":\\"customActionName\\",\\"actionDefinition\\":{\\"publishMetricAction\\":{\\"dimensions\\":[{\\"value\\":\\"metricdimensionvalue\\"}]}}}],\\"networkFirewallStatefulRuleGroupReferences\\":[{\\"resourceARN\\":\\"arn:aws:network-firewall:us-east-1:123456789011:stateful-rulegroup/test\\"}],\\"networkFirewallLoggingConfiguration\\":{\\"logDestinationConfigs\\":[{\\"logDestinationType\\":\\"S3\\",\\"logType\\":\\"ALERT\\",\\"logDestination\\":{\\"bucketName\\":\\"s3-bucket-name\\"}},{\\"logDestinationType\\":\\"S3\\",\\"logType\\":\\"FLOW\\",\\"logDestination\\":{\\"bucketName\\":\\"s3-bucket-name\\"}}],\\"overrideExistingConfig\\":true}},\\"firewallDeploymentModel\\":{\\"centralizedFirewallDeploymentModel\\":{\\"centralizedFirewallOrchestrationConfig\\":{\\"inspectionVpcIds\\":[{\\"resourceId\\":\\"vpc-1234\\",\\"accountId\\":\\"123456789011\\"}],\\"firewallCreationConfig\\":{\\"endpointLocation\\":{\\"availabilityZoneConfigList\\":[{\\"availabilityZoneId\\":null,\\"availabilityZoneName\\":\\"us-east-1a\\",\\"allowedIPV4CidrList\\":[\\"10.0.0.0/28\\"]}]}},\\"allowedIPV4CidrList\\":[]}}}}"</code> </p> <p> To use the centralized deployment model, you must set <a href="https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_PolicyOption.html">PolicyOption</a> to <code>CENTRALIZED</code>. </p> </li> <li> <p>Example: <code>NETWORK_FIREWALL</code> - Distributed deployment model with automatic Availability Zone configuration</p> <p> <code> "{\\"type\\":\\"NETWORK_FIREWALL\\",\\"networkFirewallStatelessRuleGroupReferences\\":[{\\"resourceARN\\":\\"arn:aws:network-firewall:us-east-1:123456789011:stateless-rulegroup/test\\",\\"priority\\":1}],\\"networkFirewallStatelessDefaultActions\\":[\\"aws:forward_to_sfe\\",\\"customActionName\\"],\\"networkFirewallStatelessFragmentDefaultActions\\":[\\"aws:forward_to_sfe\\",\\"customActionName\\"],\\"networkFirewallStatelessCustomActions\\":[{\\"actionName\\":\\"customActionName\\",\\"actionDefinition\\":{\\"publishMetricAction\\":{\\"dimensions\\":[{\\"value\\":\\"metricdimensionvalue\\"}]}}}],\\"networkFirewallStatefulRuleGroupReferences\\":[{\\"resourceARN\\":\\"arn:aws:network-firewall:us-east-1:123456789011:stateful-rulegroup/test\\"}],\\"networkFirewallOrchestrationConfig\\":{\\"singleFirewallEndpointPerVPC\\":false,\\"allowedIPV4CidrList\\":[\\"10.0.0.0/28\\",\\"192.168.0.0/28\\"],\\"routeManagementAction\\":\\"OFF\\"},\\"networkFirewallLoggingConfiguration\\":{\\"logDestinationConfigs\\":[{\\"logDestinationType\\":\\"S3\\",\\"logType\\":\\"ALERT\\",\\"logDestination\\":{\\"bucketName\\":\\"s3-bucket-name\\"}},{\\"logDestinationType\\":\\"S3\\",\\"logType\\":\\"FLOW\\",\\"logDestination\\":{\\"bucketName\\":\\"s3-bucket-name\\"}}],\\"overrideExistingConfig\\":true}}" </code> </p> <p> With automatic Availbility Zone configuration, Firewall Manager chooses which Availability Zones to create the endpoints in. To use the distributed deployment model, you must set <a href="https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_PolicyOption.html">PolicyOption</a> to <code>NULL</code>. </p> </li> <li> <p>Example: <code>NETWORK_FIREWALL</code> - Distributed deployment model with automatic Availability Zone configuration and route management</p> <p> <code> "{\\"type\\":\\"NETWORK_FIREWALL\\",\\"networkFirewallStatelessRuleGroupReferences\\":[{\\"resourceARN\\":\\"arn:aws:network-firewall:us-east-1:123456789011:stateless-rulegroup/test\\",\\"priority\\":1}],\\"networkFirewallStatelessDefaultActions\\":[\\"aws:forward_to_sfe\\",\\"customActionName\\"],\\"networkFirewallStatelessFragmentDefaultActions\\":[\\"aws:forward_to_sfe\\",\\"customActionName\\"],\\"networkFirewallStatelessCustomActions\\":[{\\"actionName\\":\\"customActionName\\",\\"actionDefinition\\":{\\"publishMetricAction\\":{\\"dimensions\\":[{\\"value\\":\\"metricdimensionvalue\\"}]}}}],\\"networkFirewallStatefulRuleGroupReferences\\":[{\\"resourceARN\\":\\"arn:aws:network-firewall:us-east-1:123456789011:stateful-rulegroup/test\\"}],\\"networkFirewallOrchestrationConfig\\":{\\"singleFirewallEndpointPerVPC\\":false,\\"allowedIPV4CidrList\\":[\\"10.0.0.0/28\\",\\"192.168.0.0/28\\"],\\"routeManagementAction\\":\\"MONITOR\\",\\"routeManagementTargetTypes\\":[\\"InternetGateway\\"]},\\"networkFirewallLoggingConfiguration\\":{\\"logDestinationConfigs\\":[{\\"logDestinationType\\":\\"S3\\",\\"logType\\":\\"ALERT\\",\\"logDestination\\":{\\"bucketName\\":\\"s3-bucket-name\\"}},{\\"logDestinationType\\":\\"S3\\",\\"logType\\": \\"FLOW\\",\\"logDestination\\":{\\"bucketName\\":\\"s3-bucket-name\\"}}],\\"overrideExistingConfig\\":true}}" </code> </p> <p>To use the distributed deployment model, you must set <a href="https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_PolicyOption.html">PolicyOption</a> to <code>NULL</code>. </p> </li> <li> <p>Example: <code>NETWORK_FIREWALL</code> - Distributed deployment model with custom Availability Zone configuration</p> <p> <code>"{\\"type\\":\\"NETWORK_FIREWALL\\",\\"networkFirewallStatelessRuleGroupReferences\\":[{\\"resourceARN\\":\\"arn:aws:network-firewall:us-east-1:123456789011:stateless-rulegroup/test\\",\\"priority\\":1}],\\"networkFirewallStatelessDefaultActions\\":[\\"aws:forward_to_sfe\\",\\"customActionName\\"],\\"networkFirewallStatelessFragmentDefaultActions\\":[\\"aws:forward_to_sfe\\",\\"fragmentcustomactionname\\"],\\"networkFirewallStatelessCustomActions\\":[{\\"actionName\\":\\"customActionName\\", \\"actionDefinition\\":{\\"publishMetricAction\\":{\\"dimensions\\":[{\\"value\\":\\"metricdimensionvalue\\"}]}}},{\\"actionName\\":\\"fragmentcustomactionname\\",\\"actionDefinition\\":{\\"publishMetricAction\\":{\\"dimensions\\":[{\\"value\\":\\"fragmentmetricdimensionvalue\\"}]}}}],\\"networkFirewallStatefulRuleGroupReferences\\":[{\\"resourceARN\\":\\"arn:aws:network-firewall:us-east-1:123456789011:stateful-rulegroup/test\\"}],\\"networkFirewallOrchestrationConfig\\":{\\"firewallCreationConfig\\":{ \\"endpointLocation\\":{\\"availabilityZoneConfigList\\":[{\\"availabilityZoneName\\":\\"us-east-1a\\",\\"allowedIPV4CidrList\\":[\\"10.0.0.0/28\\"]},{\\"availabilityZoneName\\":\\"us-east-1b\\",\\"allowedIPV4CidrList\\":[ \\"10.0.0.0/28\\"]}]} },\\"singleFirewallEndpointPerVPC\\":false,\\"allowedIPV4CidrList\\":null,\\"routeManagementAction\\":\\"OFF\\",\\"networkFirewallLoggingConfiguration\\":{\\"logDestinationConfigs\\":[{\\"logDestinationType\\":\\"S3\\",\\"logType\\":\\"ALERT\\",\\"logDestination\\":{\\"bucketName\\":\\"s3-bucket-name\\"}},{\\"logDestinationType\\":\\"S3\\",\\"logType\\":\\"FLOW\\",\\"logDestination\\":{\\"bucketName\\":\\"s3-bucket-name\\"}}],\\"overrideExistingConfig\\":boolean}}" </code> </p> <p> With custom Availability Zone configuration, you define which specific Availability Zones to create endpoints in by configuring <code>firewallCreationConfig</code>. To configure the Availability Zones in <code>firewallCreationConfig</code>, specify either the <code>availabilityZoneName</code> or <code>availabilityZoneId</code> parameter, not both parameters. </p> <p>To use the distributed deployment model, you must set <a href="https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_PolicyOption.html">PolicyOption</a> to <code>NULL</code>. </p> </li> <li> <p>Example: <code>NETWORK_FIREWALL</code> - Distributed deployment model with custom Availability Zone configuration and route management</p> <p> <code>"{\\"type\\":\\"NETWORK_FIREWALL\\",\\"networkFirewallStatelessRuleGroupReferences\\":[{\\"resourceARN\\":\\"arn:aws:network-firewall:us-east-1:123456789011:stateless-rulegroup/test\\",\\"priority\\":1}],\\"networkFirewallStatelessDefaultActions\\":[\\"aws:forward_to_sfe\\",\\"customActionName\\"],\\"networkFirewallStatelessFragmentDefaultActions\\":[\\"aws:forward_to_sfe\\",\\"fragmentcustomactionname\\"],\\"networkFirewallStatelessCustomActions\\":[{\\"actionName\\":\\"customActionName\\",\\"actionDefinition\\":{\\"publishMetricAction\\":{\\"dimensions\\":[{\\"value\\":\\"metricdimensionvalue\\"}]}}},{\\"actionName\\":\\"fragmentcustomactionname\\",\\"actionDefinition\\":{\\"publishMetricAction\\":{\\"dimensions\\":[{\\"value\\":\\"fragmentmetricdimensionvalue\\"}]}}}],\\"networkFirewallStatefulRuleGroupReferences\\":[{\\"resourceARN\\":\\"arn:aws:network-firewall:us-east-1:123456789011:stateful-rulegroup/test\\"}],\\"networkFirewallOrchestrationConfig\\":{\\"firewallCreationConfig\\":{\\"endpointLocation\\":{\\"availabilityZoneConfigList\\":[{\\"availabilityZoneName\\":\\"us-east-1a\\",\\"allowedIPV4CidrList\\":[\\"10.0.0.0/28\\"]},{\\"availabilityZoneName\\":\\"us-east-1b\\",\\"allowedIPV4CidrList\\":[\\"10.0.0.0/28\\"]}]}},\\"singleFirewallEndpointPerVPC\\":false,\\"allowedIPV4CidrList\\":null,\\"routeManagementAction\\":\\"MONITOR\\",\\"routeManagementTargetTypes\\":[\\"InternetGateway\\"],\\"routeManagementConfig\\":{\\"allowCrossAZTrafficIfNoEndpoint\\":true}},\\"networkFirewallLoggingConfiguration\\":{\\"logDestinationConfigs\\":[{\\"logDestinationType\\":\\"S3\\",\\"logType\\":\\"ALERT\\",\\"logDestination\\":{\\"bucketName\\":\\"s3-bucket-name\\"}},{\\"logDestinationType\\":\\"S3\\",\\"logType\\":\\"FLOW\\",\\"logDestination\\":{\\"bucketName\\":\\"s3-bucket-name\\"}}],\\"overrideExistingConfig\\":boolean}}" </code> </p> <p>To use the distributed deployment model, you must set <a href="https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_PolicyOption.html">PolicyOption</a> to <code>NULL</code>. </p> </li> <li> <p>Example: <code>SECURITY_GROUPS_COMMON</code> </p> <p> <code>"{\\"type\\":\\"SECURITY_GROUPS_COMMON\\",\\"revertManualSecurityGroupChanges\\":false,\\"exclusiveResourceSecurityGroupManagement\\":false, \\"applyToAllEC2InstanceENIs\\":false,\\"securityGroups\\":[{\\"id\\":\\" sg-000e55995d61a06bd\\"}]}"</code> </p> </li> <li> <p>Example: <code>SECURITY_GROUPS_COMMON</code> - Security group tag distribution </p> <p> <code>""{\\"type\\":\\"SECURITY_GROUPS_COMMON\\",\\"securityGroups\\":[{\\"id\\":\\"sg-000e55995d61a06bd\\"}],\\"revertManualSecurityGroupChanges\\":true,\\"exclusiveResourceSecurityGroupManagement\\":false,\\"applyToAllEC2InstanceENIs\\":false,\\"includeSharedVPC\\":false,\\"enableTagDistribution\\":true}""</code> </p> <p> Firewall Manager automatically distributes tags from the primary group to the security groups created by this policy. To use security group tag distribution, you must also set <code>revertManualSecurityGroupChanges</code> to <code>true</code>, otherwise Firewall Manager won\'t be able to create the policy. When you enable <code>revertManualSecurityGroupChanges</code>, Firewall Manager identifies and reports when the security groups created by this policy become non-compliant. </p> <p> Firewall Manager won\'t distribute system tags added by Amazon Web Services services into the replica security groups. System tags begin with the <code>aws:</code> prefix. </p> </li> <li> <p>Example: Shared VPCs. Apply the preceding policy to resources in shared VPCs as well as to those in VPCs that the account owns </p> <p> <code>"{\\"type\\":\\"SECURITY_GROUPS_COMMON\\",\\"revertManualSecurityGroupChanges\\":false,\\"exclusiveResourceSecurityGroupManagement\\":false, \\"applyToAllEC2InstanceENIs\\":false,\\"includeSharedVPC\\":true,\\"securityGroups\\":[{\\"id\\":\\" sg-000e55995d61a06bd\\"}]}"</code> </p> </li> <li> <p>Example: <code>SECURITY_GROUPS_CONTENT_AUDIT</code> </p> <p> <code>"{\\"type\\":\\"SECURITY_GROUPS_CONTENT_AUDIT\\",\\"securityGroups\\":[{\\"id\\":\\"sg-000e55995d61a06bd\\"}],\\"securityGroupAction\\":{\\"type\\":\\"ALLOW\\"}}"</code> </p> <p>The security group action for content audit can be <code>ALLOW</code> or <code>DENY</code>. For <code>ALLOW</code>, all in-scope security group rules must be within the allowed range of the policy\'s security group rules. For <code>DENY</code>, all in-scope security group rules must not contain a value or a range that matches a rule value or range in the policy security group.</p> </li> <li> <p>Example: <code>SECURITY_GROUPS_USAGE_AUDIT</code> </p> <p> <code>"{\\"type\\":\\"SECURITY_GROUPS_USAGE_AUDIT\\",\\"deleteUnusedSecurityGroups\\":true,\\"coalesceRedundantSecurityGroups\\":true}"</code> </p> </li> <li> <p>Example: <code>SHIELD_ADVANCED</code> with web ACL management</p> <p> <code>"{\\"type\\":\\"SHIELD_ADVANCED\\",\\"optimizeUnassociatedWebACL\\":true}"</code> </p> <p>If you set <code>optimizeUnassociatedWebACL</code> to <code>true</code>, Firewall Manager creates web ACLs in accounts within the policy scope if the web ACLs will be used by at least one resource. Firewall Manager creates web ACLs in the accounts within policy scope only if the web ACLs will be used by at least one resource. If at any time an account comes into policy scope, Firewall Manager automatically creates a web ACL in the account if at least one resource will use the web ACL.</p> <p>Upon enablement, Firewall Manager performs a one-time cleanup of unused web ACLs in your account. The cleanup process can take several hours. If a resource leaves policy scope after Firewall Manager creates a web ACL, Firewall Manager doesn\'t disassociate the resource from the web ACL. If you want Firewall Manager to clean up the web ACL, you must first manually disassociate the resources from the web ACL, and then enable the manage unused web ACLs option in your policy.</p> <p>If you set <code>optimizeUnassociatedWebACL</code> to <code>false</code>, and Firewall Manager automatically creates an empty web ACL in each account that\'s within policy scope.</p> </li> <li> <p>Specification for <code>SHIELD_ADVANCED</code> for Amazon CloudFront distributions </p> <p> <code>"{\\"type\\":\\"SHIELD_ADVANCED\\",\\"automaticResponseConfiguration\\": {\\"automaticResponseStatus\\":\\"ENABLED|IGNORED|DISABLED\\", \\"automaticResponseAction\\":\\"BLOCK|COUNT\\"}, \\"overrideCustomerWebaclClassic\\":true|false, \\"optimizeUnassociatedWebACL\\":true|false}"</code> </p> <p>For example: <code>"{\\"type\\":\\"SHIELD_ADVANCED\\",\\"automaticResponseConfiguration\\": {\\"automaticResponseStatus\\":\\"ENABLED\\", \\"automaticResponseAction\\":\\"COUNT\\"}}"</code> </p> <p>The default value for <code>automaticResponseStatus</code> is <code>IGNORED</code>. The value for <code>automaticResponseAction</code> is only required when <code>automaticResponseStatus</code> is set to <code>ENABLED</code>. The default value for <code>overrideCustomerWebaclClassic</code> is <code>false</code>.</p> <p>For other resource types that you can protect with a Shield Advanced policy, this <code>ManagedServiceData</code> configuration is an empty string.</p> </li> <li> <p>Example: <code>THIRD_PARTY_FIREWALL</code> </p> <p>Replace <code>THIRD_PARTY_FIREWALL_NAME</code> with the name of the third-party firewall.</p> <p> <code>"{ "type":"THIRD_PARTY_FIREWALL", "thirdPartyFirewall":"THIRD_PARTY_FIREWALL_NAME", "thirdPartyFirewallConfig":{ "thirdPartyFirewallPolicyList":["global-1"] }, "firewallDeploymentModel":{ "distributedFirewallDeploymentModel":{ "distributedFirewallOrchestrationConfig":{ "firewallCreationConfig":{ "endpointLocation":{ "availabilityZoneConfigList":[ { "availabilityZoneName":"${AvailabilityZone}" } ] } }, "allowedIPV4CidrList":[ ] } } } }"</code> </p> </li> <li> <p>Example: <code>WAFV2</code> - Account takeover prevention, Bot Control managed rule groups, optimize unassociated web ACL, and rule action override </p> <p> <code>"{\\"type\\":\\"WAFV2\\",\\"preProcessRuleGroups\\":[{\\"ruleGroupArn\\":null,\\"overrideAction\\":{\\"type\\":\\"NONE\\"},\\"managedRuleGroupIdentifier\\":{\\"versionEnabled\\":null,\\"version\\":null,\\"vendorName\\":\\"AWS\\",\\"managedRuleGroupName\\":\\"AWSManagedRulesATPRuleSet\\",\\"managedRuleGroupConfigs\\":[{\\"awsmanagedRulesATPRuleSet\\":{\\"loginPath\\":\\"/loginpath\\",\\"requestInspection\\":{\\"payloadType\\":\\"FORM_ENCODED|JSON\\",\\"usernameField\\":{\\"identifier\\":\\"/form/username\\"},\\"passwordField\\":{\\"identifier\\":\\"/form/password\\"}}}}]},\\"ruleGroupType\\":\\"ManagedRuleGroup\\",\\"excludeRules\\":[],\\"sampledRequestsEnabled\\":true},{\\"ruleGroupArn\\":null,\\"overrideAction\\":{\\"type\\":\\"NONE\\"},\\"managedRuleGroupIdentifier\\":{\\"versionEnabled\\":null,\\"version\\":null,\\"vendorName\\":\\"AWS\\",\\"managedRuleGroupName\\":\\"AWSManagedRulesBotControlRuleSet\\",\\"managedRuleGroupConfigs\\":[{\\"awsmanagedRulesBotControlRuleSet\\":{\\"inspectionLevel\\":\\"TARGETED|COMMON\\"}}]},\\"ruleGroupType\\":\\"ManagedRuleGroup\\",\\"excludeRules\\":[],\\"sampledRequestsEnabled\\":true,\\"ruleActionOverrides\\":[{\\"name\\":\\"Rule1\\",\\"actionToUse\\":{\\"allow|block|count|captcha|challenge\\":{}}},{\\"name\\":\\"Rule2\\",\\"actionToUse\\":{\\"allow|block|count|captcha|challenge\\":{}}}]}],\\"postProcessRuleGroups\\":[],\\"defaultAction\\":{\\"type\\":\\"ALLOW\\"},\\"customRequestHandling\\":null,\\"customResponse\\":null,\\"overrideCustomerWebACLAssociation\\":false,\\"loggingConfiguration\\":null,\\"sampledRequestsEnabledForDefaultActions\\":true,\\"optimizeUnassociatedWebACL\\":true}"</code> </p> <ul> <li> <p>Bot Control - For information about <code>AWSManagedRulesBotControlRuleSet</code> managed rule groups, see <a href="https://docs.aws.amazon.com/waf/latest/APIReference/API_AWSManagedRulesBotControlRuleSet.html">AWSManagedRulesBotControlRuleSet</a> in the <i>WAF API Reference</i>.</p> </li> <li> <p>Fraud Control account takeover prevention (ATP) - For information about the properties available for <code>AWSManagedRulesATPRuleSet</code> managed rule groups, see <a href="https://docs.aws.amazon.com/waf/latest/APIReference/API_AWSManagedRulesATPRuleSet.html">AWSManagedRulesATPRuleSet</a> in the <i>WAF API Reference</i>.</p> </li> <li> <p>Optimize unassociated web ACL - If you set <code>optimizeUnassociatedWebACL</code> to <code>true</code>, Firewall Manager creates web ACLs in accounts within the policy scope if the web ACLs will be used by at least one resource. Firewall Manager creates web ACLs in the accounts within policy scope only if the web ACLs will be used by at least one resource. If at any time an account comes into policy scope, Firewall Manager automatically creates a web ACL in the account if at least one resource will use the web ACL.</p> <p>Upon enablement, Firewall Manager performs a one-time cleanup of unused web ACLs in your account. The cleanup process can take several hours. If a resource leaves policy scope after Firewall Manager creates a web ACL, Firewall Manager disassociates the resource from the web ACL, but won\'t clean up the unused web ACL. Firewall Manager only cleans up unused web ACLs when you first enable management of unused web ACLs in a policy.</p> <p>If you set <code>optimizeUnassociatedWebACL</code> to <code>false</code> Firewall Manager doesn\'t manage unused web ACLs, and Firewall Manager automatically creates an empty web ACL in each account that\'s within policy scope.</p> </li> <li> <p>Rule action overrides - Firewall Manager supports rule action overrides only for managed rule groups. To configure a <code>RuleActionOverrides</code> add the <code>Name</code> of the rule to override, and <code>ActionToUse</code>, which is the new action to use for the rule. For information about using rule action override, see <a href="https://docs.aws.amazon.com/waf/latest/APIReference/API_RuleActionOverride.html">RuleActionOverride</a> in the <i>WAF API Reference</i>.</p> </li> </ul> </li> <li> <p>Example: <code>WAFV2</code> - <code>CAPTCHA</code> and <code>Challenge</code> configs </p> <p> <code>"{\\"type\\":\\"WAFV2\\",\\"preProcessRuleGroups\\":[{\\"ruleGroupArn\\":null,\\"overrideAction\\":{\\"type\\":\\"NONE\\"},\\"managedRuleGroupIdentifier\\":{\\"versionEnabled\\":null,\\"version\\":null,\\"vendorName\\":\\"AWS\\",\\"managedRuleGroupName\\":\\"AWSManagedRulesAdminProtectionRuleSet\\"},\\"ruleGroupType\\":\\"ManagedRuleGroup\\",\\"excludeRules\\":[],\\"sampledRequestsEnabled\\":true}],\\"postProcessRuleGroups\\":[],\\"defaultAction\\":{\\"type\\":\\"ALLOW\\"},\\"customRequestHandling\\":null,\\"customResponse\\":null,\\"overrideCustomerWebACLAssociation\\":false,\\"loggingConfiguration\\":null,\\"sampledRequestsEnabledForDefaultActions\\":true,\\"captchaConfig\\":{\\"immunityTimeProperty\\":{\\"immunityTime\\":500}},\\"challengeConfig\\":{\\"immunityTimeProperty\\":{\\"immunityTime\\":800}},\\"tokenDomains\\":[\\"google.com\\",\\"amazon.com\\"],\\"associationConfig\\":{\\"requestBody\\":{\\"CLOUDFRONT\\":{\\"defaultSizeInspectionLimit\\":\\"KB_16\\"}}}}"</code> </p> <ul> <li> <p> <code>CAPTCHA</code> and <code>Challenge</code> configs - If you update the policy\'s values for <code>associationConfig</code>, <code>captchaConfig</code>, <code>challengeConfig</code>, or <code>tokenDomains</code>, Firewall Manager will overwrite your local web ACLs to contain the new value(s). However, if you don\'t update the policy\'s <code>associationConfig</code>, <code>captchaConfig</code>, <code>challengeConfig</code>, or <code>tokenDomains</code> values, the values in your local web ACLs will remain unchanged. For information about association configs, see <a href="https://docs.aws.amazon.com/waf/latest/APIReference/API_AssociationConfig.html">AssociationConfig</a>. For information about CAPTCHA and Challenge configs, see <a href="https://docs.aws.amazon.com/waf/latest/APIReference/API_CaptchaConfig.html">CaptchaConfig</a> and <a href="https://docs.aws.amazon.com/waf/latest/APIReference/API_ChallengeConfig.html">ChallengeConfig</a> in the <i>WAF API Reference</i>.</p> </li> <li> <p> <code>defaultSizeInspectionLimit</code> - Specifies the maximum size of the web request body component that an associated Amazon CloudFront distribution should send to WAF for inspection. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/APIReference/API_RequestBodyAssociatedResourceTypeConfig.html#WAF-Type-RequestBodyAssociatedResourceTypeConfig-DefaultSizeInspectionLimit">DefaultSizeInspectionLimit</a> in the <i>WAF API Reference</i>.</p> </li> </ul> </li> <li> <p>Example: <code>WAFV2</code> - Firewall Manager support for WAF managed rule group versioning </p> <p> <code>"{\\"type\\":\\"WAFV2\\",\\"preProcessRuleGroups\\":[{\\"ruleGroupArn\\":null,\\"overrideAction\\":{\\"type\\":\\"NONE\\"},\\"managedRuleGroupIdentifier\\":{\\"versionEnabled\\":true,\\"version\\":\\"Version_2.0\\",\\"vendorName\\":\\"AWS\\",\\"managedRuleGroupName\\":\\"AWSManagedRulesCommonRuleSet\\"},\\"ruleGroupType\\":\\"ManagedRuleGroup\\",\\"excludeRules\\":[{\\"name\\":\\"NoUserAgent_HEADER\\"}]}],\\"postProcessRuleGroups\\":[],\\"defaultAction\\":{\\"type\\":\\"ALLOW\\"},\\"overrideCustomerWebACLAssociation\\":false,\\"loggingConfiguration\\":{\\"logDestinationConfigs\\":[\\"arn:aws:firehose:us-west-2:12345678912:deliverystream/aws-waf-logs-fms-admin-destination\\"],\\"redactedFields\\":[{\\"redactedFieldType\\":\\"SingleHeader\\",\\"redactedFieldValue\\":\\"Cookies\\"},{\\"redactedFieldType\\":\\"Method\\"}]}}"</code> </p> <p> To use a specific version of a WAF managed rule group in your Firewall Manager policy, you must set <code>versionEnabled</code> to <code>true</code>, and set <code>version</code> to the version you\'d like to use. If you don\'t set <code>versionEnabled</code> to <code>true</code>, or if you omit <code>versionEnabled</code>, then Firewall Manager uses the default version of the WAF managed rule group. </p> </li> <li> <p>Example: <code>WAFV2</code> - Logging configurations </p> <p> <code>"{\\"type\\":\\"WAFV2\\",\\"preProcessRuleGroups\\":[{\\"ruleGroupArn\\":null, \\"overrideAction\\":{\\"type\\":\\"NONE\\"},\\"managedRuleGroupIdentifier\\": {\\"versionEnabled\\":null,\\"version\\":null,\\"vendorName\\":\\"AWS\\", \\"managedRuleGroupName\\":\\"AWSManagedRulesAdminProtectionRuleSet\\"} ,\\"ruleGroupType\\":\\"ManagedRuleGroup\\",\\"excludeRules\\":[], \\"sampledRequestsEnabled\\":true}],\\"postProcessRuleGroups\\":[], \\"defaultAction\\":{\\"type\\":\\"ALLOW\\"},\\"customRequestHandling\\" :null,\\"customResponse\\":null,\\"overrideCustomerWebACLAssociation\\" :false,\\"loggingConfiguration\\":{\\"logDestinationConfigs\\": [\\"arn:aws:s3:::aws-waf-logs-example-bucket\\"] ,\\"redactedFields\\":[],\\"loggingFilterConfigs\\":{\\"defaultBehavior\\":\\"KEEP\\", \\"filters\\":[{\\"behavior\\":\\"KEEP\\",\\"requirement\\":\\"MEETS_ALL\\", \\"conditions\\":[{\\"actionCondition\\":\\"CAPTCHA\\"},{\\"actionCondition\\": \\"CHALLENGE\\"}, {\\"actionCondition\\":\\"EXCLUDED_AS_COUNT\\"}]}]}},\\"sampledRequestsEnabledForDefaultActions\\":true}"</code> </p> <p>Firewall Manager supports Amazon Kinesis Data Firehose and Amazon S3 as the <code>logDestinationConfigs</code> in your <code>loggingConfiguration</code>. For information about WAF logging configurations, see <a href="https://docs.aws.amazon.com/waf/latest/APIReference/API_LoggingConfiguration.html">LoggingConfiguration</a> in the <i>WAF API Reference</i> </p> <p>In the <code>loggingConfiguration</code>, you can specify one <code>logDestinationConfigs</code>. Optionally provide as many as 20 <code>redactedFields</code>. The <code>RedactedFieldType</code> must be one of <code>URI</code>, <code>QUERY_STRING</code>, <code>HEADER</code>, or <code>METHOD</code>.</p> </li> <li> <p>Example: <code>WAF Classic</code> </p> <p> <code>"{\\"type\\": \\"WAF\\", \\"ruleGroups\\": [{\\"id\\":\\"12345678-1bcd-9012-efga-0987654321ab\\", \\"overrideAction\\" : {\\"type\\": \\"COUNT\\"}}], \\"defaultAction\\": {\\"type\\": \\"BLOCK\\"}}"</code> </p> </li> </ul>', ], ], 'MarketplaceSubscriptionOnboardingStatus' => [ 'base' => NULL, 'refs' => [ 'GetThirdPartyFirewallAssociationStatusResponse$MarketplaceOnboardingStatus' => '<p>The status for subscribing to the third-party firewall vendor in the Amazon Web Services Marketplace.</p> <ul> <li> <p> <code>NO_SUBSCRIPTION</code> - The Firewall Manager policy administrator isn\'t subscribed to the third-party firewall service in the Amazon Web Services Marketplace.</p> </li> <li> <p> <code>NOT_COMPLETE</code> - The Firewall Manager policy administrator is in the process of subscribing to the third-party firewall service in the Amazon Web Services Marketplace, but doesn\'t yet have an active subscription.</p> </li> <li> <p> <code>COMPLETE</code> - The Firewall Manager policy administrator has an active subscription to the third-party firewall service in the Amazon Web Services Marketplace.</p> </li> </ul>', ], ], 'MemberAccounts' => [ 'base' => NULL, 'refs' => [ 'ListMemberAccountsResponse$MemberAccounts' => '<p>An array of account IDs.</p>', ], ], 'Name' => [ 'base' => NULL, 'refs' => [ 'ResourceSet$Name' => '<p>The descriptive name of the resource set. You can\'t change the name of a resource set after you create it.</p>', 'ResourceSetSummary$Name' => '<p>The descriptive name of the resource set. You can\'t change the name of a resource set after you create it.</p>', ], ], 'NetworkAclCommonPolicy' => [ 'base' => '<p>Defines a Firewall Manager network ACL policy. This is used in the <code>PolicyOption</code> of a <code>SecurityServicePolicyData</code> for a <code>Policy</code>, when the <code>SecurityServicePolicyData</code> type is set to <code>NETWORK_ACL_COMMON</code>. </p> <p>For information about network ACLs, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-network-acls.html">Control traffic to subnets using network ACLs</a> in the <i>Amazon Virtual Private Cloud User Guide</i>. </p>', 'refs' => [ 'PolicyOption$NetworkAclCommonPolicy' => '<p>Defines a Firewall Manager network ACL policy. </p>', ], ], 'NetworkAclEntries' => [ 'base' => NULL, 'refs' => [ 'NetworkAclEntrySet$FirstEntries' => '<p>The rules that you want to run first in the Firewall Manager managed network ACLs. </p> <note> <p>Provide these in the order in which you want them to run. Firewall Manager will assign the specific rule numbers for you, in the network ACLs that it creates. </p> </note> <p>You must specify at least one first entry or one last entry in any network ACL policy. </p>', 'NetworkAclEntrySet$LastEntries' => '<p>The rules that you want to run last in the Firewall Manager managed network ACLs. </p> <note> <p>Provide these in the order in which you want them to run. Firewall Manager will assign the specific rule numbers for you, in the network ACLs that it creates. </p> </note> <p>You must specify at least one first entry or one last entry in any network ACL policy. </p>', ], ], 'NetworkAclEntry' => [ 'base' => '<p>Describes a rule in a network ACL.</p> <p>Each network ACL has a set of numbered ingress rules and a separate set of numbered egress rules. When determining whether a packet should be allowed in or out of a subnet associated with the network ACL, Amazon Web Services processes the entries in the network ACL according to the rule numbers, in ascending order. </p> <p>When you manage an individual network ACL, you explicitly specify the rule numbers. When you specify the network ACL rules in a Firewall Manager policy, you provide the rules to run first, in the order that you want them to run, and the rules to run last, in the order that you want them to run. Firewall Manager assigns the rule numbers for you when you save the network ACL policy specification.</p>', 'refs' => [ 'EntryDescription$EntryDetail' => '<p>Describes a rule in a network ACL.</p> <p>Each network ACL has a set of numbered ingress rules and a separate set of numbered egress rules. When determining whether a packet should be allowed in or out of a subnet associated with the network ACL, Amazon Web Services processes the entries in the network ACL according to the rule numbers, in ascending order. </p> <p>When you manage an individual network ACL, you explicitly specify the rule numbers. When you specify the network ACL rules in a Firewall Manager policy, you provide the rules to run first, in the order that you want them to run, and the rules to run last, in the order that you want them to run. Firewall Manager assigns the rule numbers for you when you save the network ACL policy specification.</p>', 'NetworkAclEntries$member' => NULL, ], ], 'NetworkAclEntrySet' => [ 'base' => '<p>The configuration of the first and last rules for the network ACL policy, and the remediation settings for each. </p>', 'refs' => [ 'NetworkAclCommonPolicy$NetworkAclEntrySet' => '<p>The definition of the first and last rules for the network ACL policy. </p>', ], ], 'NetworkAclIcmpTypeCode' => [ 'base' => '<p>ICMP protocol: The ICMP type and code.</p>', 'refs' => [ 'NetworkAclEntry$IcmpTypeCode' => '<p>ICMP protocol: The ICMP type and code.</p>', ], ], 'NetworkAclPortRange' => [ 'base' => '<p>TCP or UDP protocols: The range of ports the rule applies to.</p>', 'refs' => [ 'NetworkAclEntry$PortRange' => '<p>TCP or UDP protocols: The range of ports the rule applies to.</p>', ], ], 'NetworkAclRuleAction' => [ 'base' => NULL, 'refs' => [ 'NetworkAclEntry$RuleAction' => '<p>Indicates whether to allow or deny the traffic that matches the rule.</p>', ], ], 'NetworkFirewallAction' => [ 'base' => NULL, 'refs' => [ 'NetworkFirewallActionList$member' => NULL, ], ], 'NetworkFirewallActionList' => [ 'base' => NULL, 'refs' => [ 'NetworkFirewallPolicyDescription$StatelessDefaultActions' => '<p>The actions to take on packets that don\'t match any of the stateless rule groups. </p>', 'NetworkFirewallPolicyDescription$StatelessFragmentDefaultActions' => '<p>The actions to take on packet fragments that don\'t match any of the stateless rule groups. </p>', 'NetworkFirewallPolicyDescription$StatelessCustomActions' => '<p>Names of custom actions that are available for use in the stateless default actions settings.</p>', 'NetworkFirewallPolicyDescription$StatefulDefaultActions' => '<p>The default actions to take on a packet that doesn\'t match any stateful rules. The stateful default action is optional, and is only valid when using the strict rule order.</p> <p> Valid values of the stateful default action: </p> <ul> <li> <p>aws:drop_strict</p> </li> <li> <p>aws:drop_established</p> </li> <li> <p>aws:alert_strict</p> </li> <li> <p>aws:alert_established</p> </li> </ul>', ], ], 'NetworkFirewallBlackHoleRouteDetectedViolation' => [ 'base' => '<p>Violation detail for an internet gateway route with an inactive state in the customer subnet route table or Network Firewall subnet route table.</p>', 'refs' => [ 'ResourceViolation$NetworkFirewallBlackHoleRouteDetectedViolation' => NULL, ], ], 'NetworkFirewallInternetTrafficNotInspectedViolation' => [ 'base' => '<p>Violation detail for the subnet for which internet traffic that hasn\'t been inspected.</p>', 'refs' => [ 'ResourceViolation$NetworkFirewallInternetTrafficNotInspectedViolation' => '<p>Violation detail for the subnet for which internet traffic hasn\'t been inspected.</p>', ], ], 'NetworkFirewallInvalidRouteConfigurationViolation' => [ 'base' => '<p>Violation detail for the improperly configured subnet route. It\'s possible there is a missing route table route, or a configuration that causes traffic to cross an Availability Zone boundary.</p>', 'refs' => [ 'ResourceViolation$NetworkFirewallInvalidRouteConfigurationViolation' => '<p>The route configuration is invalid.</p>', ], ], 'NetworkFirewallMissingExpectedRTViolation' => [ 'base' => '<p>Violation detail for Network Firewall for a subnet that\'s not associated to the expected Firewall Manager managed route table.</p>', 'refs' => [ 'ResourceViolation$NetworkFirewallMissingExpectedRTViolation' => '<p>Violation detail for an Network Firewall policy that indicates that a subnet is not associated with the expected Firewall Manager managed route table. </p>', ], ], 'NetworkFirewallMissingExpectedRoutesViolation' => [ 'base' => '<p>Violation detail for an expected route missing in Network Firewall.</p>', 'refs' => [ 'ResourceViolation$NetworkFirewallMissingExpectedRoutesViolation' => '<p>Expected routes are missing from Network Firewall.</p>', ], ], 'NetworkFirewallMissingFirewallViolation' => [ 'base' => '<p>Violation detail for Network Firewall for a subnet that doesn\'t have a Firewall Manager managed firewall in its VPC. </p>', 'refs' => [ 'ResourceViolation$NetworkFirewallMissingFirewallViolation' => '<p>Violation detail for an Network Firewall policy that indicates that a subnet has no Firewall Manager managed firewall in its VPC. </p>', ], ], 'NetworkFirewallMissingSubnetViolation' => [ 'base' => '<p>Violation detail for Network Firewall for an Availability Zone that\'s missing the expected Firewall Manager managed subnet.</p>', 'refs' => [ 'ResourceViolation$NetworkFirewallMissingSubnetViolation' => '<p>Violation detail for an Network Firewall policy that indicates that an Availability Zone is missing the expected Firewall Manager managed subnet.</p>', ], ], 'NetworkFirewallOverrideAction' => [ 'base' => NULL, 'refs' => [ 'NetworkFirewallStatefulRuleGroupOverride$Action' => '<p>The action that changes the rule group from <code>DROP</code> to <code>ALERT</code>. This only applies to managed rule groups.</p>', ], ], 'NetworkFirewallPolicy' => [ 'base' => '<p>Configures the firewall policy deployment model of Network Firewall. For information about Network Firewall deployment models, see <a href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/architectures.html">Network Firewall example architectures with routing</a> in the <i>Network Firewall Developer Guide</i>.</p>', 'refs' => [ 'PolicyOption$NetworkFirewallPolicy' => '<p>Defines the deployment model to use for the firewall policy.</p>', ], ], 'NetworkFirewallPolicyDescription' => [ 'base' => '<p>The definition of the Network Firewall firewall policy.</p>', 'refs' => [ 'NetworkFirewallPolicyModifiedViolation$CurrentPolicyDescription' => '<p>The policy that\'s currently in use in the individual account. </p>', 'NetworkFirewallPolicyModifiedViolation$ExpectedPolicyDescription' => '<p>The policy that should be in use in the individual account in order to be compliant. </p>', ], ], 'NetworkFirewallPolicyModifiedViolation' => [ 'base' => '<p>Violation detail for Network Firewall for a firewall policy that has a different <a>NetworkFirewallPolicyDescription</a> than is required by the Firewall Manager policy. </p>', 'refs' => [ 'ResourceViolation$NetworkFirewallPolicyModifiedViolation' => '<p>Violation detail for an Network Firewall policy that indicates that a firewall policy in an individual account has been modified in a way that makes it noncompliant. For example, the individual account owner might have deleted a rule group, changed the priority of a stateless rule group, or changed a policy default action.</p>', ], ], 'NetworkFirewallResourceName' => [ 'base' => NULL, 'refs' => [ 'StatefulRuleGroup$RuleGroupName' => '<p>The name of the rule group.</p>', 'StatelessRuleGroup$RuleGroupName' => '<p>The name of the rule group.</p>', ], ], 'NetworkFirewallStatefulRuleGroupOverride' => [ 'base' => '<p>The setting that allows the policy owner to change the behavior of the rule group within a policy.</p>', 'refs' => [ 'StatefulRuleGroup$Override' => '<p>The action that allows the policy owner to override the behavior of the rule group within a policy.</p>', ], ], 'NetworkFirewallUnexpectedFirewallRoutesViolation' => [ 'base' => '<p>Violation detail for an unexpected route that\'s present in a route table.</p>', 'refs' => [ 'ResourceViolation$NetworkFirewallUnexpectedFirewallRoutesViolation' => '<p>There\'s an unexpected firewall route.</p>', ], ], 'NetworkFirewallUnexpectedGatewayRoutesViolation' => [ 'base' => '<p>Violation detail for an unexpected gateway route that’s present in a route table.</p>', 'refs' => [ 'ResourceViolation$NetworkFirewallUnexpectedGatewayRoutesViolation' => '<p>There\'s an unexpected gateway route.</p>', ], ], 'OrderedRemediationActions' => [ 'base' => NULL, 'refs' => [ 'PossibleRemediationAction$OrderedRemediationActions' => '<p>The ordered list of remediation actions.</p>', ], ], 'OrganizationStatus' => [ 'base' => NULL, 'refs' => [ 'AdminAccountSummary$Status' => '<p>The current status of the request to onboard a member account as an Firewall Manager administrator.</p> <ul> <li> <p> <code>ONBOARDING</code> - The account is onboarding to Firewall Manager as an administrator.</p> </li> <li> <p> <code>ONBOARDING_COMPLETE</code> - Firewall Manager The account is onboarded to Firewall Manager as an administrator, and can perform actions on the resources defined in their <a>AdminScope</a>.</p> </li> <li> <p> <code>OFFBOARDING</code> - The account is being removed as an Firewall Manager administrator.</p> </li> <li> <p> <code>OFFBOARDING_COMPLETE</code> - The account has been removed as an Firewall Manager administrator.</p> </li> </ul>', 'GetAdminScopeResponse$Status' => '<p>The current status of the request to onboard a member account as an Firewall Manager administrator.</p> <ul> <li> <p> <code>ONBOARDING</code> - The account is onboarding to Firewall Manager as an administrator.</p> </li> <li> <p> <code>ONBOARDING_COMPLETE</code> - Firewall Manager The account is onboarded to Firewall Manager as an administrator, and can perform actions on the resources defined in their <a>AdminScope</a>.</p> </li> <li> <p> <code>OFFBOARDING</code> - The account is being removed as an Firewall Manager administrator.</p> </li> <li> <p> <code>OFFBOARDING_COMPLETE</code> - The account has been removed as an Firewall Manager administrator.</p> </li> </ul>', ], ], 'OrganizationalUnitId' => [ 'base' => NULL, 'refs' => [ 'OrganizationalUnitIdList$member' => NULL, ], ], 'OrganizationalUnitIdList' => [ 'base' => NULL, 'refs' => [ 'OrganizationalUnitScope$OrganizationalUnits' => '<p>The list of OUs within the organization that the specified Firewall Manager administrator either can or cannot apply policies to, based on the value of <code>OrganizationalUnitScope$ExcludeSpecifiedOrganizationalUnits</code>. If <code>OrganizationalUnitScope$ExcludeSpecifiedOrganizationalUnits</code> is set to <code>true</code>, then the Firewall Manager administrator can apply policies to all OUs in the organization except for the OUs in this list. If <code>OrganizationalUnitScope$ExcludeSpecifiedOrganizationalUnits</code> is set to <code>false</code>, then the Firewall Manager administrator can only apply policies to the OUs in this list.</p>', ], ], 'OrganizationalUnitScope' => [ 'base' => '<p>Defines the Organizations organizational units (OUs) that the specified Firewall Manager administrator can apply policies to. For more information about OUs in Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_ous.html">Managing organizational units (OUs) </a> in the <i>Organizations User Guide</i>.</p>', 'refs' => [ 'AdminScope$OrganizationalUnitScope' => '<p>Defines the Organizations organizational units that the specified Firewall Manager administrator can apply policies to. For more information about OUs in Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_ous.html">Managing organizational units (OUs) </a> in the <i>Organizations User Guide</i>.</p>', ], ], 'PaginationMaxResults' => [ 'base' => NULL, 'refs' => [ 'GetProtectionStatusRequest$MaxResults' => '<p>Specifies the number of objects that you want Firewall Manager to return for this request. If you have more objects than the number that you specify for <code>MaxResults</code>, the response includes a <code>NextToken</code> value that you can use to get another batch of objects.</p>', 'ListAdminAccountsForOrganizationRequest$MaxResults' => '<p>The maximum number of objects that you want Firewall Manager to return for this request. If more objects are available, in the response, Firewall Manager provides a <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>', 'ListAdminsManagingAccountRequest$MaxResults' => '<p>The maximum number of objects that you want Firewall Manager to return for this request. If more objects are available, in the response, Firewall Manager provides a <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>', 'ListAppsListsRequest$MaxResults' => '<p>The maximum number of objects that you want Firewall Manager to return for this request. If more objects are available, in the response, Firewall Manager provides a <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p> <p>If you don\'t specify this, Firewall Manager returns all available objects.</p>', 'ListComplianceStatusRequest$MaxResults' => '<p>Specifies the number of <code>PolicyComplianceStatus</code> objects that you want Firewall Manager to return for this request. If you have more <code>PolicyComplianceStatus</code> objects than the number that you specify for <code>MaxResults</code>, the response includes a <code>NextToken</code> value that you can use to get another batch of <code>PolicyComplianceStatus</code> objects.</p>', 'ListDiscoveredResourcesRequest$MaxResults' => '<p>The maximum number of objects that you want Firewall Manager to return for this request. If more objects are available, in the response, Firewall Manager provides a <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>', 'ListMemberAccountsRequest$MaxResults' => '<p>Specifies the number of member account IDs that you want Firewall Manager to return for this request. If you have more IDs than the number that you specify for <code>MaxResults</code>, the response includes a <code>NextToken</code> value that you can use to get another batch of member account IDs.</p>', 'ListPoliciesRequest$MaxResults' => '<p>Specifies the number of <code>PolicySummary</code> objects that you want Firewall Manager to return for this request. If you have more <code>PolicySummary</code> objects than the number that you specify for <code>MaxResults</code>, the response includes a <code>NextToken</code> value that you can use to get another batch of <code>PolicySummary</code> objects.</p>', 'ListProtocolsListsRequest$MaxResults' => '<p>The maximum number of objects that you want Firewall Manager to return for this request. If more objects are available, in the response, Firewall Manager provides a <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p> <p>If you don\'t specify this, Firewall Manager returns all available objects.</p>', 'ListResourceSetResourcesRequest$MaxResults' => '<p>The maximum number of objects that you want Firewall Manager to return for this request. If more objects are available, in the response, Firewall Manager provides a <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>', 'ListResourceSetsRequest$MaxResults' => '<p>The maximum number of objects that you want Firewall Manager to return for this request. If more objects are available, in the response, Firewall Manager provides a <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>', 'ListThirdPartyFirewallFirewallPoliciesRequest$MaxResults' => '<p>The maximum number of third-party firewall policies that you want Firewall Manager to return. If the specified third-party firewall vendor is associated with more than <code>MaxResults</code> firewall policies, the response includes a <code>NextToken</code> element. <code>NextToken</code> contains an encrypted token that identifies the first third-party firewall policies that Firewall Manager will return if you submit another request.</p>', ], ], 'PaginationToken' => [ 'base' => NULL, 'refs' => [ 'GetProtectionStatusRequest$NextToken' => '<p>If you specify a value for <code>MaxResults</code> and you have more objects than the number that you specify for <code>MaxResults</code>, Firewall Manager returns a <code>NextToken</code> value in the response, which you can use to retrieve another group of objects. For the second and subsequent <code>GetProtectionStatus</code> requests, specify the value of <code>NextToken</code> from the previous response to get information about another batch of objects.</p>', 'GetProtectionStatusResponse$NextToken' => '<p>If you have more objects than the number that you specified for <code>MaxResults</code> in the request, the response includes a <code>NextToken</code> value. To list more objects, submit another <code>GetProtectionStatus</code> request, and specify the <code>NextToken</code> value from the response in the <code>NextToken</code> value in the next request.</p> <p>Amazon Web Services SDKs provide auto-pagination that identify <code>NextToken</code> in a response and make subsequent request calls automatically on your behalf. However, this feature is not supported by <code>GetProtectionStatus</code>. You must submit subsequent requests with <code>NextToken</code> using your own processes. </p>', 'ListAdminAccountsForOrganizationRequest$NextToken' => '<p>When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are still available for retrieval exceeds the maximum you requested, Firewall Manager returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.</p>', 'ListAdminAccountsForOrganizationResponse$NextToken' => '<p>When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are still available for retrieval exceeds the maximum you requested, Firewall Manager returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.</p>', 'ListAdminsManagingAccountRequest$NextToken' => '<p>When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are still available for retrieval exceeds the maximum you requested, Firewall Manager returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.</p>', 'ListAdminsManagingAccountResponse$NextToken' => '<p>When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are still available for retrieval exceeds the maximum you requested, Firewall Manager returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.</p>', 'ListAppsListsRequest$NextToken' => '<p>If you specify a value for <code>MaxResults</code> in your list request, and you have more objects than the maximum, Firewall Manager returns this token in the response. For all but the first request, you provide the token returned by the prior request in the request parameters, to retrieve the next batch of objects.</p>', 'ListAppsListsResponse$NextToken' => '<p>If you specify a value for <code>MaxResults</code> in your list request, and you have more objects than the maximum, Firewall Manager returns this token in the response. You can use this token in subsequent requests to retrieve the next batch of objects.</p>', 'ListComplianceStatusRequest$NextToken' => '<p>If you specify a value for <code>MaxResults</code> and you have more <code>PolicyComplianceStatus</code> objects than the number that you specify for <code>MaxResults</code>, Firewall Manager returns a <code>NextToken</code> value in the response that allows you to list another group of <code>PolicyComplianceStatus</code> objects. For the second and subsequent <code>ListComplianceStatus</code> requests, specify the value of <code>NextToken</code> from the previous response to get information about another batch of <code>PolicyComplianceStatus</code> objects.</p>', 'ListComplianceStatusResponse$NextToken' => '<p>If you have more <code>PolicyComplianceStatus</code> objects than the number that you specified for <code>MaxResults</code> in the request, the response includes a <code>NextToken</code> value. To list more <code>PolicyComplianceStatus</code> objects, submit another <code>ListComplianceStatus</code> request, and specify the <code>NextToken</code> value from the response in the <code>NextToken</code> value in the next request.</p>', 'ListDiscoveredResourcesRequest$NextToken' => '<p>When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are still available for retrieval exceeds the maximum you requested, Firewall Manager returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.</p>', 'ListDiscoveredResourcesResponse$NextToken' => '<p>When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are still available for retrieval exceeds the maximum you requested, Firewall Manager returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.</p>', 'ListMemberAccountsRequest$NextToken' => '<p>If you specify a value for <code>MaxResults</code> and you have more account IDs than the number that you specify for <code>MaxResults</code>, Firewall Manager returns a <code>NextToken</code> value in the response that allows you to list another group of IDs. For the second and subsequent <code>ListMemberAccountsRequest</code> requests, specify the value of <code>NextToken</code> from the previous response to get information about another batch of member account IDs.</p>', 'ListMemberAccountsResponse$NextToken' => '<p>If you have more member account IDs than the number that you specified for <code>MaxResults</code> in the request, the response includes a <code>NextToken</code> value. To list more IDs, submit another <code>ListMemberAccounts</code> request, and specify the <code>NextToken</code> value from the response in the <code>NextToken</code> value in the next request.</p>', 'ListPoliciesRequest$NextToken' => '<p>If you specify a value for <code>MaxResults</code> and you have more <code>PolicySummary</code> objects than the number that you specify for <code>MaxResults</code>, Firewall Manager returns a <code>NextToken</code> value in the response that allows you to list another group of <code>PolicySummary</code> objects. For the second and subsequent <code>ListPolicies</code> requests, specify the value of <code>NextToken</code> from the previous response to get information about another batch of <code>PolicySummary</code> objects.</p>', 'ListPoliciesResponse$NextToken' => '<p>If you have more <code>PolicySummary</code> objects than the number that you specified for <code>MaxResults</code> in the request, the response includes a <code>NextToken</code> value. To list more <code>PolicySummary</code> objects, submit another <code>ListPolicies</code> request, and specify the <code>NextToken</code> value from the response in the <code>NextToken</code> value in the next request.</p>', 'ListProtocolsListsRequest$NextToken' => '<p>If you specify a value for <code>MaxResults</code> in your list request, and you have more objects than the maximum, Firewall Manager returns this token in the response. For all but the first request, you provide the token returned by the prior request in the request parameters, to retrieve the next batch of objects.</p>', 'ListProtocolsListsResponse$NextToken' => '<p>If you specify a value for <code>MaxResults</code> in your list request, and you have more objects than the maximum, Firewall Manager returns this token in the response. You can use this token in subsequent requests to retrieve the next batch of objects.</p>', 'ListResourceSetResourcesRequest$NextToken' => '<p>When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are still available for retrieval exceeds the maximum you requested, Firewall Manager returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.</p>', 'ListResourceSetResourcesResponse$NextToken' => '<p>When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are still available for retrieval exceeds the maximum you requested, Firewall Manager returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.</p>', 'ListResourceSetsRequest$NextToken' => '<p>When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are still available for retrieval exceeds the maximum you requested, Firewall Manager returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.</p>', 'ListResourceSetsResponse$NextToken' => '<p>When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are still available for retrieval exceeds the maximum you requested, Firewall Manager returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.</p>', 'ListThirdPartyFirewallFirewallPoliciesRequest$NextToken' => '<p>If the previous response included a <code>NextToken</code> element, the specified third-party firewall vendor is associated with more third-party firewall policies. To get more third-party firewall policies, submit another <code>ListThirdPartyFirewallFirewallPoliciesRequest</code> request.</p> <p> For the value of <code>NextToken</code>, specify the value of <code>NextToken</code> from the previous response. If the previous response didn\'t include a <code>NextToken</code> element, there are no more third-party firewall policies to get. </p>', 'ListThirdPartyFirewallFirewallPoliciesResponse$NextToken' => '<p>The value that you will use for <code>NextToken</code> in the next <code>ListThirdPartyFirewallFirewallPolicies</code> request.</p>', ], ], 'PartialMatch' => [ 'base' => '<p>The reference rule that partially matches the <code>ViolationTarget</code> rule and violation reason.</p>', 'refs' => [ 'PartialMatches$member' => NULL, ], ], 'PartialMatches' => [ 'base' => NULL, 'refs' => [ 'AwsVPCSecurityGroupViolation$PartialMatches' => '<p>List of rules specified in the security group of the Firewall Manager policy that partially match the <code>ViolationTarget</code> rule.</p>', ], ], 'Policy' => [ 'base' => '<p>An Firewall Manager policy.</p>', 'refs' => [ 'GetPolicyResponse$Policy' => '<p>Information about the specified Firewall Manager policy.</p>', 'PutPolicyRequest$Policy' => '<p>The details of the Firewall Manager policy to be created.</p>', 'PutPolicyResponse$Policy' => '<p>The details of the Firewall Manager policy.</p>', ], ], 'PolicyComplianceDetail' => [ 'base' => '<p>Describes the noncompliant resources in a member account for a specific Firewall Manager policy. A maximum of 100 entries are displayed. If more than 100 resources are noncompliant, <code>EvaluationLimitExceeded</code> is set to <code>True</code>.</p>', 'refs' => [ 'GetComplianceDetailResponse$PolicyComplianceDetail' => '<p>Information about the resources and the policy that you specified in the <code>GetComplianceDetail</code> request.</p>', ], ], 'PolicyComplianceStatus' => [ 'base' => '<p>Indicates whether the account is compliant with the specified policy. An account is considered noncompliant if it includes resources that are not protected by the policy, for WAF and Shield Advanced policies, or that are noncompliant with the policy, for security group policies.</p>', 'refs' => [ 'PolicyComplianceStatusList$member' => NULL, ], ], 'PolicyComplianceStatusList' => [ 'base' => NULL, 'refs' => [ 'ListComplianceStatusResponse$PolicyComplianceStatusList' => '<p>An array of <code>PolicyComplianceStatus</code> objects.</p>', ], ], 'PolicyComplianceStatusType' => [ 'base' => NULL, 'refs' => [ 'EvaluationResult$ComplianceStatus' => '<p>Describes an Amazon Web Services account\'s compliance with the Firewall Manager policy.</p>', ], ], 'PolicyId' => [ 'base' => NULL, 'refs' => [ 'DeletePolicyRequest$PolicyId' => '<p>The ID of the policy that you want to delete. You can retrieve this ID from <code>PutPolicy</code> and <code>ListPolicies</code>.</p>', 'DnsRuleGroupPriorityConflictViolation$ConflictingPolicyId' => '<p>The ID of the Firewall Manager DNS Firewall policy that was already applied to the VPC. This policy contains the rule group that\'s already associated with the VPC. </p>', 'GetComplianceDetailRequest$PolicyId' => '<p>The ID of the policy that you want to get the details for. <code>PolicyId</code> is returned by <code>PutPolicy</code> and by <code>ListPolicies</code>.</p>', 'GetPolicyRequest$PolicyId' => '<p>The ID of the Firewall Manager policy that you want the details for.</p>', 'GetProtectionStatusRequest$PolicyId' => '<p>The ID of the policy for which you want to get the attack information.</p>', 'GetViolationDetailsRequest$PolicyId' => '<p>The ID of the Firewall Manager policy that you want the details for. You can get violation details for the following policy types:</p> <ul> <li> <p>DNS Firewall</p> </li> <li> <p>Imported Network Firewall</p> </li> <li> <p>Network Firewall</p> </li> <li> <p>Security group content audit</p> </li> <li> <p>Network ACL</p> </li> <li> <p>Third-party firewall</p> </li> </ul>', 'ListComplianceStatusRequest$PolicyId' => '<p>The ID of the Firewall Manager policy that you want the details for.</p>', 'Policy$PolicyId' => '<p>The ID of the Firewall Manager policy.</p>', 'PolicyComplianceDetail$PolicyId' => '<p>The ID of the Firewall Manager policy.</p>', 'PolicyComplianceStatus$PolicyId' => '<p>The ID of the Firewall Manager policy.</p>', 'PolicySummary$PolicyId' => '<p>The ID of the specified policy.</p>', 'ViolationDetail$PolicyId' => '<p>The ID of the Firewall Manager policy that the violation details were requested for.</p>', ], ], 'PolicyOption' => [ 'base' => '<p>Contains the settings to configure a network ACL policy, a Network Firewall firewall policy deployment model, or a third-party firewall policy.</p>', 'refs' => [ 'SecurityServicePolicyData$PolicyOption' => '<p>Contains the settings to configure a network ACL policy, a Network Firewall firewall policy deployment model, or a third-party firewall policy.</p>', ], ], 'PolicySummary' => [ 'base' => '<p>Details of the Firewall Manager policy. </p>', 'refs' => [ 'PolicySummaryList$member' => NULL, ], ], 'PolicySummaryList' => [ 'base' => NULL, 'refs' => [ 'ListPoliciesResponse$PolicyList' => '<p>An array of <code>PolicySummary</code> objects.</p>', ], ], 'PolicyTypeScope' => [ 'base' => '<p>Defines the policy types that the specified Firewall Manager administrator can manage.</p>', 'refs' => [ 'AdminScope$PolicyTypeScope' => '<p>Defines the Firewall Manager policy types that the specified Firewall Manager administrator can create and manage.</p>', ], ], 'PolicyUpdateToken' => [ 'base' => NULL, 'refs' => [ 'Policy$PolicyUpdateToken' => '<p>A unique identifier for each update to the policy. When issuing a <code>PutPolicy</code> request, the <code>PolicyUpdateToken</code> in the request must match the <code>PolicyUpdateToken</code> of the current policy version. To get the <code>PolicyUpdateToken</code> of the current policy version, use a <code>GetPolicy</code> request.</p>', ], ], 'PossibleRemediationAction' => [ 'base' => '<p>A list of remediation actions.</p>', 'refs' => [ 'PossibleRemediationActionList$member' => NULL, ], ], 'PossibleRemediationActionList' => [ 'base' => NULL, 'refs' => [ 'PossibleRemediationActions$Actions' => '<p>Information about the actions.</p>', ], ], 'PossibleRemediationActions' => [ 'base' => '<p>A list of possible remediation action lists. Each individual possible remediation action is a list of individual remediation actions.</p>', 'refs' => [ 'ResourceViolation$PossibleRemediationActions' => '<p>A list of possible remediation action lists. Each individual possible remediation action is a list of individual remediation actions.</p>', ], ], 'PreviousAppsList' => [ 'base' => NULL, 'refs' => [ 'AppsListData$PreviousAppsList' => '<p>A map of previous version numbers to their corresponding <code>App</code> object arrays.</p>', ], ], 'PreviousListVersion' => [ 'base' => NULL, 'refs' => [ 'PreviousAppsList$key' => NULL, 'PreviousProtocolsList$key' => NULL, ], ], 'PreviousProtocolsList' => [ 'base' => NULL, 'refs' => [ 'ProtocolsListData$PreviousProtocolsList' => '<p>A map of previous version numbers to their corresponding protocol arrays.</p>', ], ], 'PriorityNumber' => [ 'base' => NULL, 'refs' => [ 'StatefulRuleGroup$Priority' => '<p>An integer setting that indicates the order in which to run the stateful rule groups in a single Network Firewall firewall policy. This setting only applies to firewall policies that specify the <code>STRICT_ORDER</code> rule order in the stateful engine options settings.</p> <p> Network Firewall evalutes each stateful rule group against a packet starting with the group that has the lowest priority setting. You must ensure that the priority settings are unique within each policy. For information about </p> <p> You can change the priority settings of your rule groups at any time. To make it easier to insert rule groups later, number them so there\'s a wide range in between, for example use 100, 200, and so on. </p>', ], ], 'ProtectionData' => [ 'base' => NULL, 'refs' => [ 'GetProtectionStatusResponse$Data' => '<p>Details about the attack, including the following:</p> <ul> <li> <p>Attack type</p> </li> <li> <p>Account ID</p> </li> <li> <p>ARN of the resource attacked</p> </li> <li> <p>Start time of the attack</p> </li> <li> <p>End time of the attack (ongoing attacks will not have an end time)</p> </li> </ul> <p>The details are in JSON format. </p>', ], ], 'Protocol' => [ 'base' => NULL, 'refs' => [ 'App$Protocol' => '<p>The IP protocol name or number. The name can be one of <code>tcp</code>, <code>udp</code>, or <code>icmp</code>. For information on possible numbers, see <a href="https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a>.</p>', 'ProtocolsList$member' => NULL, ], ], 'ProtocolsList' => [ 'base' => NULL, 'refs' => [ 'PreviousProtocolsList$value' => NULL, 'ProtocolsListData$ProtocolsList' => '<p>An array of protocols in the Firewall Manager protocols list.</p>', 'ProtocolsListDataSummary$ProtocolsList' => '<p>An array of protocols in the Firewall Manager protocols list.</p>', ], ], 'ProtocolsListData' => [ 'base' => '<p>An Firewall Manager protocols list.</p>', 'refs' => [ 'GetProtocolsListResponse$ProtocolsList' => '<p>Information about the specified Firewall Manager protocols list.</p>', 'PutProtocolsListRequest$ProtocolsList' => '<p>The details of the Firewall Manager protocols list to be created.</p>', 'PutProtocolsListResponse$ProtocolsList' => '<p>The details of the Firewall Manager protocols list.</p>', ], ], 'ProtocolsListDataSummary' => [ 'base' => '<p>Details of the Firewall Manager protocols list.</p>', 'refs' => [ 'ProtocolsListsData$member' => NULL, ], ], 'ProtocolsListsData' => [ 'base' => NULL, 'refs' => [ 'ListProtocolsListsResponse$ProtocolsLists' => '<p>An array of <code>ProtocolsListDataSummary</code> objects.</p>', ], ], 'PutAdminAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutAppsListRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutAppsListResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutNotificationChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutProtocolsListRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutProtocolsListResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutResourceSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutResourceSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'ReferenceRule' => [ 'base' => NULL, 'refs' => [ 'PartialMatch$Reference' => '<p>The reference rule from the primary security group of the Firewall Manager policy.</p>', ], ], 'RegionScope' => [ 'base' => '<p>Defines the Amazon Web Services Regions that the specified Firewall Manager administrator can manage.</p>', 'refs' => [ 'AdminScope$RegionScope' => '<p>Defines the Amazon Web Services Regions that the specified Firewall Manager administrator can perform actions in.</p>', ], ], 'RemediationAction' => [ 'base' => '<p>Information about an individual action you can take to remediate a violation.</p>', 'refs' => [ 'RemediationActionWithOrder$RemediationAction' => '<p>Information about an action you can take to remediate a violation.</p>', ], ], 'RemediationActionDescription' => [ 'base' => NULL, 'refs' => [ 'SecurityGroupRemediationAction$Description' => '<p>Brief description of the action that will be performed.</p>', ], ], 'RemediationActionType' => [ 'base' => NULL, 'refs' => [ 'SecurityGroupRemediationAction$RemediationActionType' => '<p>The remediation action that will be performed.</p>', ], ], 'RemediationActionWithOrder' => [ 'base' => '<p>An ordered list of actions you can take to remediate a violation.</p>', 'refs' => [ 'OrderedRemediationActions$member' => NULL, ], ], 'ReplaceNetworkAclAssociationAction' => [ 'base' => '<p>Information about the <code>ReplaceNetworkAclAssociation</code> action in Amazon EC2. This is a remediation option in <code>RemediationAction</code>.</p>', 'refs' => [ 'RemediationAction$ReplaceNetworkAclAssociationAction' => '<p>Information about the <code>ReplaceNetworkAclAssociation</code> action in Amazon EC2. </p>', ], ], 'Resource' => [ 'base' => '<p>Details of a resource that is associated to an Firewall Manager resource set.</p>', 'refs' => [ 'ResourceList$member' => NULL, ], ], 'ResourceArn' => [ 'base' => NULL, 'refs' => [ 'AppsListDataSummary$ListArn' => '<p>The Amazon Resource Name (ARN) of the applications list.</p>', 'GetAppsListResponse$AppsListArn' => '<p>The Amazon Resource Name (ARN) of the applications list.</p>', 'GetNotificationChannelResponse$SnsTopicArn' => '<p>The SNS topic that records Firewall Manager activity. </p>', 'GetNotificationChannelResponse$SnsRoleName' => '<p>The IAM role that is used by Firewall Manager to record activity to SNS.</p>', 'GetPolicyResponse$PolicyArn' => '<p>The Amazon Resource Name (ARN) of the specified policy.</p>', 'GetProtocolsListResponse$ProtocolsListArn' => '<p>The Amazon Resource Name (ARN) of the specified protocols list.</p>', 'GetResourceSetResponse$ResourceSetArn' => '<p>The Amazon Resource Name (ARN) of the resource set.</p>', 'ListTagsForResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource to return tags for. The Firewall Manager resources that support tagging are policies, applications lists, and protocols lists. </p>', 'PolicySummary$PolicyArn' => '<p>The Amazon Resource Name (ARN) of the specified policy.</p>', 'ProtocolsListDataSummary$ListArn' => '<p>The Amazon Resource Name (ARN) of the specified protocols list.</p>', 'PutAppsListResponse$AppsListArn' => '<p>The Amazon Resource Name (ARN) of the applications list.</p>', 'PutNotificationChannelRequest$SnsTopicArn' => '<p>The Amazon Resource Name (ARN) of the SNS topic that collects notifications from Firewall Manager.</p>', 'PutNotificationChannelRequest$SnsRoleName' => '<p>The Amazon Resource Name (ARN) of the IAM role that allows Amazon SNS to record Firewall Manager activity. </p>', 'PutPolicyResponse$PolicyArn' => '<p>The Amazon Resource Name (ARN) of the policy.</p>', 'PutProtocolsListResponse$ProtocolsListArn' => '<p>The Amazon Resource Name (ARN) of the protocols list.</p>', 'PutResourceSetResponse$ResourceSetArn' => '<p>The Amazon Resource Name (ARN) of the resource set.</p>', 'TagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource to return tags for. The Firewall Manager resources that support tagging are policies, applications lists, and protocols lists. </p>', 'UntagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource to return tags for. The Firewall Manager resources that support tagging are policies, applications lists, and protocols lists. </p>', ], ], 'ResourceCount' => [ 'base' => NULL, 'refs' => [ 'EvaluationResult$ViolatorCount' => '<p>The number of resources that are noncompliant with the specified policy. For WAF and Shield Advanced policies, a resource is considered noncompliant if it is not associated with the policy. For security group policies, a resource is considered noncompliant if it doesn\'t comply with the rules of the policy and remediation is disabled or not possible.</p>', ], ], 'ResourceDescription' => [ 'base' => NULL, 'refs' => [ 'Policy$PolicyDescription' => '<p>Your description of the Firewall Manager policy.</p>', ], ], 'ResourceId' => [ 'base' => NULL, 'refs' => [ 'ActionTarget$ResourceId' => '<p>The ID of the remediation target.</p>', 'ComplianceViolator$ResourceId' => '<p>The resource ID.</p>', 'EC2CreateRouteAction$DestinationPrefixListId' => '<p>Information about the ID of a prefix list used for the destination match.</p>', 'EC2DeleteRouteAction$DestinationPrefixListId' => '<p>Information about the ID of the prefix list for the route.</p>', 'EC2ReplaceRouteAction$DestinationPrefixListId' => '<p>Information about the ID of the prefix list for the route.</p>', 'ExpectedRoute$RouteTableId' => '<p>Information about the route table ID.</p>', 'FirewallSubnetIsOutOfScopeViolation$FirewallSubnetId' => '<p>The ID of the firewall subnet that violates the policy scope.</p>', 'FirewallSubnetIsOutOfScopeViolation$VpcId' => '<p>The VPC ID of the firewall subnet that violates the policy scope.</p>', 'FirewallSubnetIsOutOfScopeViolation$VpcEndpointId' => '<p>The VPC endpoint ID of the firewall subnet that violates the policy scope.</p>', 'FirewallSubnetMissingVPCEndpointViolation$FirewallSubnetId' => '<p>The ID of the firewall that this VPC endpoint is associated with.</p>', 'FirewallSubnetMissingVPCEndpointViolation$VpcId' => '<p>The resource ID of the VPC associated with the deleted VPC subnet.</p>', 'GetViolationDetailsRequest$ResourceId' => '<p>The ID of the resource that has violations.</p>', 'InvalidNetworkAclEntriesViolation$Vpc' => '<p>The VPC where the violation was found. </p>', 'InvalidNetworkAclEntriesViolation$Subnet' => '<p>The subnet that\'s associated with the network ACL.</p>', 'InvalidNetworkAclEntriesViolation$CurrentAssociatedNetworkAcl' => '<p>The network ACL containing the entry violations. </p>', 'ListResourceSetResourcesRequest$Identifier' => '<p>A unique identifier for the resource set, used in a request to refer to the resource set.</p>', 'NetworkFirewallBlackHoleRouteDetectedViolation$RouteTableId' => '<p>Information about the route table ID.</p>', 'NetworkFirewallBlackHoleRouteDetectedViolation$VpcId' => '<p>Information about the VPC ID.</p>', 'NetworkFirewallInternetTrafficNotInspectedViolation$SubnetId' => '<p>The subnet ID.</p>', 'NetworkFirewallInternetTrafficNotInspectedViolation$RouteTableId' => '<p>Information about the route table ID.</p>', 'NetworkFirewallInternetTrafficNotInspectedViolation$CurrentFirewallSubnetRouteTable' => '<p>Information about the subnet route table for the current firewall.</p>', 'NetworkFirewallInternetTrafficNotInspectedViolation$ExpectedFirewallEndpoint' => '<p>The expected endpoint for the current firewall.</p>', 'NetworkFirewallInternetTrafficNotInspectedViolation$FirewallSubnetId' => '<p>The firewall subnet ID.</p>', 'NetworkFirewallInternetTrafficNotInspectedViolation$InternetGatewayId' => '<p>The internet gateway ID.</p>', 'NetworkFirewallInternetTrafficNotInspectedViolation$CurrentInternetGatewayRouteTable' => '<p>The current route table for the internet gateway.</p>', 'NetworkFirewallInternetTrafficNotInspectedViolation$VpcId' => '<p>Information about the VPC ID.</p>', 'NetworkFirewallInvalidRouteConfigurationViolation$RouteTableId' => '<p>The route table ID.</p>', 'NetworkFirewallInvalidRouteConfigurationViolation$CurrentFirewallSubnetRouteTable' => '<p>The subnet route table for the current firewall.</p>', 'NetworkFirewallInvalidRouteConfigurationViolation$ExpectedFirewallEndpoint' => '<p>The firewall endpoint that\'s expected.</p>', 'NetworkFirewallInvalidRouteConfigurationViolation$ActualFirewallEndpoint' => '<p>The actual firewall endpoint.</p>', 'NetworkFirewallInvalidRouteConfigurationViolation$ExpectedFirewallSubnetId' => '<p>The expected subnet ID for the firewall.</p>', 'NetworkFirewallInvalidRouteConfigurationViolation$ActualFirewallSubnetId' => '<p>The actual subnet ID for the firewall.</p>', 'NetworkFirewallInvalidRouteConfigurationViolation$InternetGatewayId' => '<p>The internet gateway ID.</p>', 'NetworkFirewallInvalidRouteConfigurationViolation$CurrentInternetGatewayRouteTable' => '<p>The route table for the current internet gateway.</p>', 'NetworkFirewallInvalidRouteConfigurationViolation$VpcId' => '<p>Information about the VPC ID.</p>', 'NetworkFirewallMissingExpectedRTViolation$VPC' => '<p>The resource ID of the VPC associated with a violating subnet.</p>', 'NetworkFirewallMissingExpectedRTViolation$CurrentRouteTable' => '<p>The resource ID of the current route table that\'s associated with the subnet, if one is available.</p>', 'NetworkFirewallMissingExpectedRTViolation$ExpectedRouteTable' => '<p>The resource ID of the route table that should be associated with the subnet.</p>', 'NetworkFirewallMissingExpectedRoutesViolation$VpcId' => '<p>Information about the VPC ID.</p>', 'NetworkFirewallMissingFirewallViolation$VPC' => '<p>The resource ID of the VPC associated with a violating subnet.</p>', 'NetworkFirewallMissingSubnetViolation$VPC' => '<p>The resource ID of the VPC associated with a violating subnet.</p>', 'NetworkFirewallUnexpectedFirewallRoutesViolation$FirewallSubnetId' => '<p>The subnet ID for the firewall.</p>', 'NetworkFirewallUnexpectedFirewallRoutesViolation$RouteTableId' => '<p>The ID of the route table.</p>', 'NetworkFirewallUnexpectedFirewallRoutesViolation$FirewallEndpoint' => '<p>The endpoint of the firewall.</p>', 'NetworkFirewallUnexpectedFirewallRoutesViolation$VpcId' => '<p>Information about the VPC ID.</p>', 'NetworkFirewallUnexpectedGatewayRoutesViolation$GatewayId' => '<p>Information about the gateway ID.</p>', 'NetworkFirewallUnexpectedGatewayRoutesViolation$RouteTableId' => '<p>Information about the route table.</p>', 'NetworkFirewallUnexpectedGatewayRoutesViolation$VpcId' => '<p>Information about the VPC ID.</p>', 'ResourceIdList$member' => NULL, 'RouteHasOutOfScopeEndpointViolation$SubnetId' => '<p>The ID of the subnet associated with the route that violates the policy scope.</p>', 'RouteHasOutOfScopeEndpointViolation$VpcId' => '<p>The VPC ID of the route that violates the policy scope.</p>', 'RouteHasOutOfScopeEndpointViolation$RouteTableId' => '<p>The ID of the route table.</p>', 'RouteHasOutOfScopeEndpointViolation$CurrentFirewallSubnetRouteTable' => '<p>The route table associated with the current firewall subnet.</p>', 'RouteHasOutOfScopeEndpointViolation$FirewallSubnetId' => '<p>The ID of the firewall subnet.</p>', 'RouteHasOutOfScopeEndpointViolation$InternetGatewayId' => '<p>The ID of the Internet Gateway.</p>', 'RouteHasOutOfScopeEndpointViolation$CurrentInternetGatewayRouteTable' => '<p>The current route table associated with the Internet Gateway.</p>', 'SecurityGroupRuleDescription$PrefixListId' => '<p>The ID of the prefix list for the security group rule.</p>', 'StatefulRuleGroup$ResourceId' => '<p>The resource ID of the rule group.</p>', 'StatelessRuleGroup$ResourceId' => '<p>The resource ID of the rule group.</p>', 'ThirdPartyFirewallMissingExpectedRouteTableViolation$VPC' => '<p>The resource ID of the VPC associated with a fireawll subnet that\'s causing the violation.</p>', 'ThirdPartyFirewallMissingExpectedRouteTableViolation$CurrentRouteTable' => '<p>The resource ID of the current route table that\'s associated with the subnet, if one is available.</p>', 'ThirdPartyFirewallMissingExpectedRouteTableViolation$ExpectedRouteTable' => '<p>The resource ID of the route table that should be associated with the subnet.</p>', 'ThirdPartyFirewallMissingFirewallViolation$VPC' => '<p>The resource ID of the VPC associated with a third-party firewall.</p>', 'ThirdPartyFirewallMissingSubnetViolation$VPC' => '<p>The resource ID of the VPC associated with a subnet that\'s causing the violation.</p>', 'ViolationDetail$ResourceId' => '<p>The resource ID that the violation details were requested for.</p>', ], ], 'ResourceIdList' => [ 'base' => NULL, 'refs' => [ 'AwsEc2NetworkInterfaceViolation$ViolatingSecurityGroups' => '<p>List of security groups that violate the rules specified in the primary security group of the Firewall Manager policy.</p>', 'ExpectedRoute$ContributingSubnets' => '<p>Information about the contributing subnets.</p>', 'NetworkFirewallInvalidRouteConfigurationViolation$AffectedSubnets' => '<p>The subnets that are affected.</p>', ], ], 'ResourceList' => [ 'base' => NULL, 'refs' => [ 'ListResourceSetResourcesResponse$Items' => '<p>An array of the associated resources\' uniform resource identifiers (URI).</p>', ], ], 'ResourceName' => [ 'base' => NULL, 'refs' => [ 'App$AppName' => '<p>The application\'s name.</p>', 'AppsListData$ListName' => '<p>The name of the Firewall Manager applications list.</p>', 'AppsListDataSummary$ListName' => '<p>The name of the applications list.</p>', 'DiscoveredResource$Name' => '<p>The name of the discovered resource.</p>', 'Policy$PolicyName' => '<p>The name of the Firewall Manager policy.</p>', 'PolicyComplianceStatus$PolicyName' => '<p>The name of the Firewall Manager policy.</p>', 'PolicySummary$PolicyName' => '<p>The name of the specified policy.</p>', 'ProtocolsListData$ListName' => '<p>The name of the Firewall Manager protocols list.</p>', 'ProtocolsListDataSummary$ListName' => '<p>The name of the specified protocols list.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The specified resource was not found.</p>', 'refs' => [], ], 'ResourceSet' => [ 'base' => '<p>A set of resources to include in a policy.</p>', 'refs' => [ 'GetResourceSetResponse$ResourceSet' => '<p>Information about the specified resource set.</p>', 'PutResourceSetRequest$ResourceSet' => '<p>Details about the resource set to be created or updated.&gt;</p>', 'PutResourceSetResponse$ResourceSet' => '<p>Details about the resource set.</p>', ], ], 'ResourceSetIds' => [ 'base' => NULL, 'refs' => [ 'Policy$ResourceSetIds' => '<p>The unique identifiers of the resource sets used by the policy.</p>', ], ], 'ResourceSetStatus' => [ 'base' => NULL, 'refs' => [ 'ResourceSet$ResourceSetStatus' => '<p>Indicates whether the resource set is in or out of an admin\'s Region scope.</p> <ul> <li> <p> <code>ACTIVE</code> - The administrator can manage and delete the resource set.</p> </li> <li> <p> <code>OUT_OF_ADMIN_SCOPE</code> - The administrator can view the resource set, but they can\'t edit or delete the resource set. Existing protections stay in place. Any new resource that come into scope of the resource set won\'t be protected.</p> </li> </ul>', 'ResourceSetSummary$ResourceSetStatus' => '<p>Indicates whether the resource set is in or out of an admin\'s Region scope.</p> <ul> <li> <p> <code>ACTIVE</code> - The administrator can manage and delete the resource set.</p> </li> <li> <p> <code>OUT_OF_ADMIN_SCOPE</code> - The administrator can view the resource set, but they can\'t edit or delete the resource set. Existing protections stay in place. Any new resource that come into scope of the resource set won\'t be protected.</p> </li> </ul>', ], ], 'ResourceSetSummary' => [ 'base' => '<p>Summarizes the resource sets used in a policy.</p>', 'refs' => [ 'ResourceSetSummaryList$member' => NULL, ], ], 'ResourceSetSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListResourceSetsResponse$ResourceSets' => '<p>An array of <code>ResourceSetSummary</code> objects.</p>', ], ], 'ResourceTag' => [ 'base' => '<p>The resource tags that Firewall Manager uses to determine if a particular resource should be included or excluded from the Firewall Manager policy. Tags enable you to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. Each tag consists of a key and an optional value. Firewall Manager combines the tags with "AND" so that, if you add more than one tag to a policy scope, a resource must have all the specified tags to be included or excluded. For more information, see <a href="https://docs.aws.amazon.com/awsconsolehelpdocs/latest/gsg/tag-editor.html">Working with Tag Editor</a>.</p> <p>Every resource tag must have a string value, either a non-empty string or an empty string. If you don\'t provide a value for a resource tag, Firewall Manager saves the value as an empty string: "". When Firewall Manager compares tags, it only matches two tags if they have the same key and the same value. A tag with an empty string value only matches with tags that also have an empty string value. </p>', 'refs' => [ 'ResourceTags$member' => NULL, ], ], 'ResourceTagKey' => [ 'base' => NULL, 'refs' => [ 'ResourceTag$Key' => '<p>The resource tag key.</p>', ], ], 'ResourceTagValue' => [ 'base' => NULL, 'refs' => [ 'ResourceTag$Value' => '<p>The resource tag value. To specify an empty string value, either don\'t provide this or specify it as "". </p>', ], ], 'ResourceTags' => [ 'base' => NULL, 'refs' => [ 'Policy$ResourceTags' => '<p>An array of <code>ResourceTag</code> objects.</p>', ], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'ComplianceViolator$ResourceType' => '<p>The resource type. This is in the format shown in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services Resource Types Reference</a>. For example: <code>AWS::ElasticLoadBalancingV2::LoadBalancer</code>, <code>AWS::CloudFront::Distribution</code>, or <code>AWS::NetworkFirewall::FirewallPolicy</code>.</p>', 'DiscoveredResource$Type' => '<p>The type of the discovered resource.</p>', 'GetViolationDetailsRequest$ResourceType' => '<p>The resource type. This is in the format shown in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services Resource Types Reference</a>. Supported resource types are: <code>AWS::EC2::Instance</code>, <code>AWS::EC2::NetworkInterface</code>, <code>AWS::EC2::SecurityGroup</code>, <code>AWS::NetworkFirewall::FirewallPolicy</code>, and <code>AWS::EC2::Subnet</code>. </p>', 'ListDiscoveredResourcesRequest$ResourceType' => '<p>The type of resources to discover.</p>', 'Policy$ResourceType' => '<p>The type of resource protected by or in scope of the policy. This is in the format shown in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services Resource Types Reference</a>. To apply this policy to multiple resource types, specify a resource type of <code>ResourceTypeList</code> and then specify the resource types in a <code>ResourceTypeList</code>.</p> <p>The following are valid resource types for each Firewall Manager policy type:</p> <ul> <li> <p>Amazon Web Services WAF Classic - <code>AWS::ApiGateway::Stage</code>, <code>AWS::CloudFront::Distribution</code>, and <code>AWS::ElasticLoadBalancingV2::LoadBalancer</code>.</p> </li> <li> <p>WAF - <code>AWS::ApiGateway::Stage</code>, <code>AWS::ElasticLoadBalancingV2::LoadBalancer</code>, and <code>AWS::CloudFront::Distribution</code>.</p> </li> <li> <p>Shield Advanced - <code>AWS::ElasticLoadBalancingV2::LoadBalancer</code>, <code>AWS::ElasticLoadBalancing::LoadBalancer</code>, <code>AWS::EC2::EIP</code>, and <code>AWS::CloudFront::Distribution</code>.</p> </li> <li> <p>Network ACL - <code>AWS::EC2::Subnet</code>.</p> </li> <li> <p>Security group usage audit - <code>AWS::EC2::SecurityGroup</code>.</p> </li> <li> <p>Security group content audit - <code>AWS::EC2::SecurityGroup</code>, <code>AWS::EC2::NetworkInterface</code>, and <code>AWS::EC2::Instance</code>.</p> </li> <li> <p>DNS Firewall, Network Firewall, and third-party firewall - <code>AWS::EC2::VPC</code>.</p> </li> </ul>', 'PolicySummary$ResourceType' => '<p>The type of resource protected by or in scope of the policy. This is in the format shown in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services Resource Types Reference</a>. </p>', 'ResourceTypeList$member' => NULL, 'ViolationDetail$ResourceType' => '<p>The resource type that the violation details were requested for.</p>', ], ], 'ResourceTypeList' => [ 'base' => NULL, 'refs' => [ 'Policy$ResourceTypeList' => '<p>An array of <code>ResourceType</code> objects. Use this only to specify multiple resource types. To specify a single resource type, use <code>ResourceType</code>.</p>', 'ResourceSet$ResourceTypeList' => '<p>Determines the resources that can be associated to the resource set. Depending on your setting for max results and the number of resource sets, a single call might not return the full list.</p>', ], ], 'ResourceViolation' => [ 'base' => '<p>Violation detail based on resource type.</p>', 'refs' => [ 'ResourceViolations$member' => NULL, ], ], 'ResourceViolations' => [ 'base' => NULL, 'refs' => [ 'ViolationDetail$ResourceViolations' => '<p>List of violations for the requested resource.</p>', ], ], 'Route' => [ 'base' => '<p>Describes a route in a route table.</p>', 'refs' => [ 'NetworkFirewallInvalidRouteConfigurationViolation$ViolatingRoute' => '<p>The route that\'s in violation.</p>', 'Routes$member' => NULL, ], ], 'RouteHasOutOfScopeEndpointViolation' => [ 'base' => '<p>Contains details about the route endpoint that violates the policy scope.</p>', 'refs' => [ 'ResourceViolation$RouteHasOutOfScopeEndpointViolation' => '<p>Contains details about the route endpoint that violates the policy scope.</p>', ], ], 'Routes' => [ 'base' => NULL, 'refs' => [ 'NetworkFirewallBlackHoleRouteDetectedViolation$ViolatingRoutes' => '<p>Information about the route or routes that are in violation.</p>', 'NetworkFirewallInternetTrafficNotInspectedViolation$ViolatingRoutes' => '<p>The route or routes that are in violation.</p>', 'NetworkFirewallInternetTrafficNotInspectedViolation$ActualFirewallSubnetRoutes' => '<p>The actual firewall subnet routes.</p>', 'NetworkFirewallInternetTrafficNotInspectedViolation$ActualInternetGatewayRoutes' => '<p>The actual internet gateway routes.</p>', 'NetworkFirewallInvalidRouteConfigurationViolation$ActualFirewallSubnetRoutes' => '<p>The actual firewall subnet routes that are expected.</p>', 'NetworkFirewallInvalidRouteConfigurationViolation$ActualInternetGatewayRoutes' => '<p>The actual internet gateway routes.</p>', 'NetworkFirewallUnexpectedFirewallRoutesViolation$ViolatingRoutes' => '<p>The routes that are in violation.</p>', 'NetworkFirewallUnexpectedGatewayRoutesViolation$ViolatingRoutes' => '<p>The routes that are in violation.</p>', 'RouteHasOutOfScopeEndpointViolation$ViolatingRoutes' => '<p>The list of routes that violate the route table.</p>', 'RouteHasOutOfScopeEndpointViolation$FirewallSubnetRoutes' => '<p>The list of firewall subnet routes.</p>', 'RouteHasOutOfScopeEndpointViolation$InternetGatewayRoutes' => '<p>The routes in the route table associated with the Internet Gateway.</p>', ], ], 'RuleOrder' => [ 'base' => NULL, 'refs' => [ 'StatefulEngineOptions$RuleOrder' => '<p>Indicates how to manage the order of stateful rule evaluation for the policy. Stateful rules are provided to the rule engine as Suricata compatible strings, and Suricata evaluates them based on certain settings. For more information, see <a href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html">Evaluation order for stateful rules</a> in the <i>Network Firewall Developer Guide</i>.</p> <p>Default: <code>DEFAULT_ACTION_ORDER</code> </p>', ], ], 'SecurityGroupRemediationAction' => [ 'base' => '<p>Remediation option for the rule specified in the <code>ViolationTarget</code>.</p>', 'refs' => [ 'SecurityGroupRemediationActions$member' => NULL, ], ], 'SecurityGroupRemediationActions' => [ 'base' => NULL, 'refs' => [ 'AwsVPCSecurityGroupViolation$PossibleSecurityGroupRemediationActions' => '<p>Remediation options for the rule specified in the <code>ViolationTarget</code>.</p>', ], ], 'SecurityGroupRuleDescription' => [ 'base' => '<p>Describes a set of permissions for a security group rule.</p>', 'refs' => [ 'SecurityGroupRemediationAction$RemediationResult' => '<p>The final state of the rule specified in the <code>ViolationTarget</code> after it is remediated.</p>', ], ], 'SecurityServicePolicyData' => [ 'base' => '<p>Details about the security service that is being used to protect the resources.</p>', 'refs' => [ 'Policy$SecurityServicePolicyData' => '<p>Details about the security service that is being used to protect the resources.</p>', ], ], 'SecurityServiceType' => [ 'base' => NULL, 'refs' => [ 'GetProtectionStatusResponse$ServiceType' => '<p>The service type that is protected by the policy. Currently, this is always <code>SHIELD_ADVANCED</code>.</p>', 'PolicySummary$SecurityServiceType' => '<p>The service that the policy is using to protect the resources. This specifies the type of policy that is created, either an WAF policy, a Shield Advanced policy, or a security group policy.</p>', 'SecurityServicePolicyData$Type' => '<p>The service that the policy is using to protect the resources. This specifies the type of policy that is created, either an WAF policy, a Shield Advanced policy, or a security group policy. For security group policies, Firewall Manager supports one security group for each common policy and for each content audit policy. This is an adjustable limit that you can increase by contacting Amazon Web Services Support.</p>', 'SecurityServiceTypeList$member' => NULL, ], ], 'SecurityServiceTypeList' => [ 'base' => NULL, 'refs' => [ 'PolicyTypeScope$PolicyTypes' => '<p>The list of policy types that the specified Firewall Manager administrator can manage.</p>', ], ], 'StatefulEngineOptions' => [ 'base' => '<p>Configuration settings for the handling of the stateful rule groups in a Network Firewall firewall policy.</p>', 'refs' => [ 'NetworkFirewallPolicyDescription$StatefulEngineOptions' => '<p>Additional options governing how Network Firewall handles stateful rules. The stateful rule groups that you use in your policy must have stateful rule options settings that are compatible with these settings.</p>', ], ], 'StatefulRuleGroup' => [ 'base' => '<p>Network Firewall stateful rule group, used in a <a>NetworkFirewallPolicyDescription</a>. </p>', 'refs' => [ 'StatefulRuleGroupList$member' => NULL, ], ], 'StatefulRuleGroupList' => [ 'base' => NULL, 'refs' => [ 'NetworkFirewallPolicyDescription$StatefulRuleGroups' => '<p>The stateful rule groups that are used in the Network Firewall firewall policy. </p>', ], ], 'StatelessRuleGroup' => [ 'base' => '<p>Network Firewall stateless rule group, used in a <a>NetworkFirewallPolicyDescription</a>. </p>', 'refs' => [ 'StatelessRuleGroupList$member' => NULL, ], ], 'StatelessRuleGroupList' => [ 'base' => NULL, 'refs' => [ 'NetworkFirewallPolicyDescription$StatelessRuleGroups' => '<p>The stateless rule groups that are used in the Network Firewall firewall policy. </p>', ], ], 'StatelessRuleGroupPriority' => [ 'base' => NULL, 'refs' => [ 'StatelessRuleGroup$Priority' => '<p>The priority of the rule group. Network Firewall evaluates the stateless rule groups in a firewall policy starting from the lowest priority setting. </p>', ], ], 'StreamExceptionPolicy' => [ 'base' => NULL, 'refs' => [ 'StatefulEngineOptions$StreamExceptionPolicy' => '<p>Indicates how Network Firewall should handle traffic when a network connection breaks midstream.</p> <ul> <li> <p> <code>DROP</code> - Fail closed and drop all subsequent traffic going to the firewall.</p> </li> <li> <p> <code>CONTINUE</code> - Continue to apply rules to subsequent traffic without context from traffic before the break. This impacts the behavior of rules that depend on context. For example, with a stateful rule that drops HTTP traffic, Network Firewall won\'t match subsequent traffic because the it won\'t have the context from session initialization, which defines the application layer protocol as HTTP. However, a TCP-layer rule using a <code>flow:stateless</code> rule would still match, and so would the <code>aws:drop_strict</code> default action. </p> </li> <li> <p> <code>REJECT</code> - Fail closed and drop all subsequent traffic going to the firewall. With this option, Network Firewall also sends a TCP reject packet back to the client so the client can immediately establish a new session. With the new session, Network Firewall will have context and will apply rules appropriately.</p> <p>For applications that are reliant on long-lived TCP connections that trigger Gateway Load Balancer idle timeouts, this is the recommended setting. </p> </li> <li> <p> <code>FMS_IGNORE</code> - Firewall Manager doesn\'t monitor or modify the Network Firewall stream exception policy settings. </p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/stream-exception-policy.html">Stream exception policy in your firewall policy</a> in the <i>Network Firewall Developer Guide</i>.</p> <p>Default: <code>FMS_IGNORE</code> </p>', ], ], 'Tag' => [ 'base' => '<p>A collection of key:value pairs associated with an Amazon Web Services resource. The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each Amazon Web Services resource. </p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>Part of the key:value pair that defines a tag. You can use a tag key to describe a category of information, such as "customer." Tag keys are case-sensitive.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>The keys of the tags to remove from the resource. </p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceResponse$TagList' => '<p>The tags associated with the resource.</p>', 'PutAppsListRequest$TagList' => '<p>The tags associated with the resource.</p>', 'PutPolicyRequest$TagList' => '<p>The tags to add to the Amazon Web Services resource.</p>', 'PutProtocolsListRequest$TagList' => '<p>The tags associated with the resource.</p>', 'PutResourceSetRequest$TagList' => '<p>Retrieves the tags associated with the specified resource set. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource, up to 50 tags for a resource.</p>', 'TagResourceRequest$TagList' => '<p>The tags to add to the resource.</p>', 'ViolationDetail$ResourceTags' => '<p>The <code>ResourceTag</code> objects associated with the resource.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>Part of the key:value pair that defines a tag. You can use a tag value to describe a specific value within a category, such as "companyA" or "companyB." Tag values are case-sensitive. </p>', ], ], 'TargetType' => [ 'base' => NULL, 'refs' => [ 'Route$TargetType' => '<p>The type of target for the route.</p>', ], ], 'TargetViolationReason' => [ 'base' => NULL, 'refs' => [ 'NetworkFirewallMissingFirewallViolation$TargetViolationReason' => '<p>The reason the resource has this violation, if one is available. </p>', 'NetworkFirewallMissingSubnetViolation$TargetViolationReason' => '<p>The reason the resource has this violation, if one is available. </p>', 'TargetViolationReasons$member' => NULL, 'ThirdPartyFirewallMissingFirewallViolation$TargetViolationReason' => '<p>The reason the resource is causing this violation, if a reason is available.</p>', 'ThirdPartyFirewallMissingSubnetViolation$TargetViolationReason' => '<p>The reason the resource is causing the violation, if a reason is available.</p>', ], ], 'TargetViolationReasons' => [ 'base' => NULL, 'refs' => [ 'PartialMatch$TargetViolationReasons' => '<p>The violation reason.</p>', ], ], 'ThirdPartyFirewall' => [ 'base' => NULL, 'refs' => [ 'AssociateThirdPartyFirewallRequest$ThirdPartyFirewall' => '<p>The name of the third-party firewall vendor.</p>', 'DisassociateThirdPartyFirewallRequest$ThirdPartyFirewall' => '<p>The name of the third-party firewall vendor.</p>', 'GetThirdPartyFirewallAssociationStatusRequest$ThirdPartyFirewall' => '<p>The name of the third-party firewall vendor.</p>', 'ListThirdPartyFirewallFirewallPoliciesRequest$ThirdPartyFirewall' => '<p>The name of the third-party firewall vendor.</p>', ], ], 'ThirdPartyFirewallAssociationStatus' => [ 'base' => NULL, 'refs' => [ 'AssociateThirdPartyFirewallResponse$ThirdPartyFirewallStatus' => '<p>The current status for setting a Firewall Manager policy administrator\'s account as an administrator of the third-party firewall tenant.</p> <ul> <li> <p> <code>ONBOARDING</code> - The Firewall Manager policy administrator is being designated as a tenant administrator.</p> </li> <li> <p> <code>ONBOARD_COMPLETE</code> - The Firewall Manager policy administrator is designated as a tenant administrator.</p> </li> <li> <p> <code>OFFBOARDING</code> - The Firewall Manager policy administrator is being removed as a tenant administrator.</p> </li> <li> <p> <code>OFFBOARD_COMPLETE</code> - The Firewall Manager policy administrator has been removed as a tenant administrator.</p> </li> <li> <p> <code>NOT_EXIST</code> - The Firewall Manager policy administrator doesn\'t exist as a tenant administrator.</p> </li> </ul>', 'DisassociateThirdPartyFirewallResponse$ThirdPartyFirewallStatus' => '<p>The current status for the disassociation of a Firewall Manager administrators account with a third-party firewall.</p>', 'GetThirdPartyFirewallAssociationStatusResponse$ThirdPartyFirewallStatus' => '<p>The current status for setting a Firewall Manager policy administrators account as an administrator of the third-party firewall tenant.</p> <ul> <li> <p> <code>ONBOARDING</code> - The Firewall Manager policy administrator is being designated as a tenant administrator.</p> </li> <li> <p> <code>ONBOARD_COMPLETE</code> - The Firewall Manager policy administrator is designated as a tenant administrator.</p> </li> <li> <p> <code>OFFBOARDING</code> - The Firewall Manager policy administrator is being removed as a tenant administrator.</p> </li> <li> <p> <code>OFFBOARD_COMPLETE</code> - The Firewall Manager policy administrator has been removed as a tenant administrator.</p> </li> <li> <p> <code>NOT_EXIST</code> - The Firewall Manager policy administrator doesn\'t exist as a tenant administrator.</p> </li> </ul>', ], ], 'ThirdPartyFirewallFirewallPolicies' => [ 'base' => NULL, 'refs' => [ 'ListThirdPartyFirewallFirewallPoliciesResponse$ThirdPartyFirewallFirewallPolicies' => '<p>A list that contains one <code>ThirdPartyFirewallFirewallPolicies</code> element for each third-party firewall policies that the specified third-party firewall vendor is associated with. Each <code>ThirdPartyFirewallFirewallPolicies</code> element contains the firewall policy name and ID.</p>', ], ], 'ThirdPartyFirewallFirewallPolicy' => [ 'base' => '<p>Configures the third-party firewall\'s firewall policy.</p>', 'refs' => [ 'ThirdPartyFirewallFirewallPolicies$member' => NULL, ], ], 'ThirdPartyFirewallMissingExpectedRouteTableViolation' => [ 'base' => '<p>The violation details for a third-party firewall that\'s not associated with an Firewall Manager managed route table.</p>', 'refs' => [ 'ResourceViolation$ThirdPartyFirewallMissingExpectedRouteTableViolation' => '<p>The violation details for a third-party firewall that has the Firewall Manager managed route table that was associated with the third-party firewall has been deleted.</p>', ], ], 'ThirdPartyFirewallMissingFirewallViolation' => [ 'base' => '<p>The violation details about a third-party firewall\'s subnet that doesn\'t have a Firewall Manager managed firewall in its VPC.</p>', 'refs' => [ 'ResourceViolation$ThirdPartyFirewallMissingFirewallViolation' => '<p>The violation details for a third-party firewall that\'s been deleted.</p>', ], ], 'ThirdPartyFirewallMissingSubnetViolation' => [ 'base' => '<p>The violation details for a third-party firewall for an Availability Zone that\'s missing the Firewall Manager managed subnet.</p>', 'refs' => [ 'ResourceViolation$ThirdPartyFirewallMissingSubnetViolation' => '<p>The violation details for a third-party firewall\'s subnet that\'s been deleted.</p>', ], ], 'ThirdPartyFirewallPolicy' => [ 'base' => '<p>Configures the deployment model for the third-party firewall.</p>', 'refs' => [ 'PolicyOption$ThirdPartyFirewallPolicy' => '<p>Defines the policy options for a third-party firewall policy.</p>', ], ], 'TimeStamp' => [ 'base' => NULL, 'refs' => [ 'AppsListData$CreateTime' => '<p>The time that the Firewall Manager applications list was created.</p>', 'AppsListData$LastUpdateTime' => '<p>The time that the Firewall Manager applications list was last updated.</p>', 'GetProtectionStatusRequest$StartTime' => '<p>The start of the time period to query for the attacks. This is a <code>timestamp</code> type. The request syntax listing indicates a <code>number</code> type because the default used by Firewall Manager is Unix time in seconds. However, any valid <code>timestamp</code> format is allowed.</p>', 'GetProtectionStatusRequest$EndTime' => '<p>The end of the time period to query for the attacks. This is a <code>timestamp</code> type. The request syntax listing indicates a <code>number</code> type because the default used by Firewall Manager is Unix time in seconds. However, any valid <code>timestamp</code> format is allowed.</p>', 'PolicyComplianceDetail$ExpiredAt' => '<p>A timestamp that indicates when the returned information should be considered out of date.</p>', 'PolicyComplianceStatus$LastUpdated' => '<p>Timestamp of the last update to the <code>EvaluationResult</code> objects.</p>', 'ProtocolsListData$CreateTime' => '<p>The time that the Firewall Manager protocols list was created.</p>', 'ProtocolsListData$LastUpdateTime' => '<p>The time that the Firewall Manager protocols list was last updated.</p>', 'ResourceSet$LastUpdateTime' => '<p>The last time that the resource set was changed.</p>', 'ResourceSetSummary$LastUpdateTime' => '<p>The last time that the resource set was changed.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateToken' => [ 'base' => NULL, 'refs' => [ 'AppsListData$ListUpdateToken' => '<p>A unique identifier for each update to the list. When you update the list, the update token must match the token of the current version of the application list. You can retrieve the update token by getting the list. </p>', 'ProtocolsListData$ListUpdateToken' => '<p>A unique identifier for each update to the list. When you update the list, the update token must match the token of the current version of the application list. You can retrieve the update token by getting the list. </p>', 'ResourceSet$UpdateToken' => '<p>An optional token that you can use for optimistic locking. Firewall Manager returns a token to your requests that access the resource set. The token marks the state of the resource set resource at the time of the request. Update tokens are not allowed when creating a resource set. After creation, each subsequent update call to the resource set requires the update token. </p> <p>To make an unconditional change to the resource set, omit the token in your update request. Without the token, Firewall Manager performs your updates regardless of whether the resource set has changed since you last retrieved it.</p> <p>To make a conditional change to the resource set, provide the token in your update request. Firewall Manager uses the token to ensure that the resource set hasn\'t changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the resource set again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>', ], ], 'ViolationDetail' => [ 'base' => '<p>Violations for a resource based on the specified Firewall Manager policy and Amazon Web Services account.</p>', 'refs' => [ 'GetViolationDetailsResponse$ViolationDetail' => '<p>Violation detail for a resource.</p>', ], ], 'ViolationReason' => [ 'base' => NULL, 'refs' => [ 'ComplianceViolator$ViolationReason' => '<p>The reason that the resource is not protected by the policy.</p>', ], ], 'ViolationTarget' => [ 'base' => NULL, 'refs' => [ 'AwsEc2InstanceViolation$ViolationTarget' => '<p>The resource ID of the EC2 instance.</p>', 'AwsEc2NetworkInterfaceViolation$ViolationTarget' => '<p>The resource ID of the network interface.</p>', 'AwsVPCSecurityGroupViolation$ViolationTarget' => '<p>The security group rule that is being evaluated.</p>', 'DnsDuplicateRuleGroupViolation$ViolationTarget' => '<p>Information about the VPC ID. </p>', 'DnsRuleGroupLimitExceededViolation$ViolationTarget' => '<p>Information about the VPC ID. </p>', 'DnsRuleGroupPriorityConflictViolation$ViolationTarget' => '<p>Information about the VPC ID. </p>', 'NetworkFirewallBlackHoleRouteDetectedViolation$ViolationTarget' => '<p>The subnet that has an inactive state.</p>', 'NetworkFirewallMissingExpectedRTViolation$ViolationTarget' => '<p>The ID of the Network Firewall or VPC resource that\'s in violation.</p>', 'NetworkFirewallMissingExpectedRoutesViolation$ViolationTarget' => '<p>The target of the violation.</p>', 'NetworkFirewallMissingFirewallViolation$ViolationTarget' => '<p>The ID of the Network Firewall or VPC resource that\'s in violation.</p>', 'NetworkFirewallMissingSubnetViolation$ViolationTarget' => '<p>The ID of the Network Firewall or VPC resource that\'s in violation.</p>', 'NetworkFirewallPolicyModifiedViolation$ViolationTarget' => '<p>The ID of the Network Firewall or VPC resource that\'s in violation.</p>', 'ThirdPartyFirewallMissingExpectedRouteTableViolation$ViolationTarget' => '<p>The ID of the third-party firewall or VPC resource that\'s causing the violation.</p>', 'ThirdPartyFirewallMissingFirewallViolation$ViolationTarget' => '<p>The ID of the third-party firewall that\'s causing the violation.</p>', 'ThirdPartyFirewallMissingSubnetViolation$ViolationTarget' => '<p>The ID of the third-party firewall or VPC resource that\'s causing the violation.</p>', ], ], ],];
