<?php
// This file was auto-generated from sdk-root/src/data/freetier/2023-09-07/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>You can use the Amazon Web Services Free Tier API to query programmatically your Free Tier usage data.</p> <p>Free Tier tracks your monthly usage data for all free tier offers that are associated with your Amazon Web Services account. You can use the Free Tier API to filter and show only the data that you want.</p> <p>Service endpoint</p> <p>The Free Tier API provides the following endpoint:</p> <ul> <li> <p>https://freetier.us-east-1.api.aws</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-free-tier.html">Using the Amazon Web Services Free Tier</a> in the <i>Billing User Guide</i>.</p>', 'operations' => [ 'GetFreeTierUsage' => '<p>Returns a list of all Free Tier usage objects that match your filters.</p>', ], 'shapes' => [ 'Dimension' => [ 'base' => NULL, 'refs' => [ 'DimensionValues$Key' => '<p>The name of the dimension that you want to filter on.</p>', ], ], 'DimensionValues' => [ 'base' => '<p>Contains the specifications for the filters to use for your request.</p>', 'refs' => [ 'Expression$Dimensions' => '<p>The specific dimension, values, and match type to filter objects with.</p>', ], ], 'Expression' => [ 'base' => '<p>Use <code>Expression</code> to filter in the <code>GetFreeTierUsage</code> API operation.</p> <p>You can use the following patterns:</p> <ul> <li> <p>Simple dimension values (<code>Dimensions</code> root operator)</p> </li> <li> <p>Complex expressions with logical operators (<code>AND</code>, <code>NOT</code>, and <code>OR</code> root operators).</p> </li> </ul> <p>For <i>simple dimension values</i>, you can set the dimension name, values, and match type for the filters that you plan to use.</p> <p> <b>Example for simple dimension values</b> </p> <p>You can filter to match exactly for <code>REGION==us-east-1 OR REGION==us-west-1</code>.</p> <p>The corresponding <code>Expression</code> appears like the following: <code>{ "Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ], "MatchOptions": ["EQUALS"] } }</code> </p> <p>As shown in the previous example, lists of dimension values are combined with <code>OR</code> when you apply the filter.</p> <p>For <i>complex expressions with logical operators</i>, you can have nested expressions to use the logical operators and specify advanced filtering.</p> <p> <b>Example for complex expressions with logical operators</b> </p> <p>You can filter by <code>((REGION == us-east-1 OR REGION == us-west-1) OR (SERVICE CONTAINS AWSLambda)) AND (USAGE_TYPE !CONTAINS DataTransfer)</code>.</p> <p>The corresponding <code>Expression</code> appears like the following: <code>{ "And": [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ], "MatchOptions": ["EQUALS"] }}, {"Dimensions": { "Key": "SERVICE", "Values": ["AWSLambda"], "MatchOptions": ["CONTAINS"] } } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"], "MatchOptions": ["CONTAINS"] }}} ] }</code> </p> <p>In the following <b>Contents</b>, you must specify exactly one of the following root operators.</p>', 'refs' => [ 'Expression$Not' => '<p>Return results that don’t match the <code>Expression</code> that you specified.</p>', 'Expressions$member' => NULL, 'GetFreeTierUsageRequest$filter' => '<p>An expression that specifies the conditions that you want each <code>FreeTierUsage</code> object to meet.</p>', ], ], 'Expressions' => [ 'base' => NULL, 'refs' => [ 'Expression$And' => '<p>Return results that match all <code>Expressions</code> that you specified in the array.</p>', 'Expression$Or' => '<p>Return results that match any of the <code>Expressions</code> that you specified. in the array.</p>', ], ], 'FreeTierUsage' => [ 'base' => '<p>Consists of a Amazon Web Services Free Tier offer’s metadata and your data usage for the offer.</p>', 'refs' => [ 'FreeTierUsages$member' => NULL, ], ], 'FreeTierUsages' => [ 'base' => NULL, 'refs' => [ 'GetFreeTierUsageResponse$freeTierUsages' => '<p>The list of Free Tier usage objects that meet your filter expression.</p>', ], ], 'GenericDouble' => [ 'base' => NULL, 'refs' => [ 'FreeTierUsage$actualUsageAmount' => '<p>Describes the actual usage accrued month-to-day (MTD) that you\'ve used so far.</p>', 'FreeTierUsage$forecastedUsageAmount' => '<p>Describes the forecasted usage by the month that you\'re expected to use.</p>', 'FreeTierUsage$limit' => '<p>Describes the maximum usage allowed in Free Tier.</p>', ], ], 'GenericString' => [ 'base' => NULL, 'refs' => [ 'FreeTierUsage$description' => '<p>The description of the Free Tier offer.</p>', 'FreeTierUsage$freeTierType' => '<p>Describes the type of the Free Tier offer. For example, the offer can be <code>"12 Months Free"</code>, <code>"Always Free"</code>, and <code>"Free Trial"</code>.</p>', 'FreeTierUsage$operation' => '<p>Describes <code>usageType</code> more granularly with the specific Amazon Web Service API operation. For example, this can be the <code>RunInstances</code> API operation for Amazon Elastic Compute Cloud.</p>', 'FreeTierUsage$region' => '<p>Describes the Amazon Web Services Region for which this offer is applicable</p>', 'FreeTierUsage$service' => '<p>The name of the Amazon Web Service providing the Free Tier offer. For example, this can be Amazon Elastic Compute Cloud.</p>', 'FreeTierUsage$unit' => '<p>Describes the unit of the <code>usageType</code>, such as <code>Hrs</code>.</p>', 'FreeTierUsage$usageType' => '<p>Describes the usage details of the offer. For example, this might be <code>Global-BoxUsage:freetrial</code>.</p>', 'InternalServerException$message' => NULL, 'ThrottlingException$message' => NULL, 'ValidationException$message' => NULL, ], ], 'GetFreeTierUsageRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetFreeTierUsageResponse' => [ 'base' => NULL, 'refs' => [], ], 'InternalServerException' => [ 'base' => '<p>An unexpected error occurred during the processing of your request.</p>', 'refs' => [], ], 'MatchOption' => [ 'base' => NULL, 'refs' => [ 'MatchOptions$member' => NULL, ], ], 'MatchOptions' => [ 'base' => NULL, 'refs' => [ 'DimensionValues$MatchOptions' => '<p>The match options that you can use to filter your results. You can specify only one of these values in the array.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'GetFreeTierUsageRequest$maxResults' => '<p>The maximum number of results to return in the response. <code>MaxResults</code> means that there can be up to the specified number of values, but there might be fewer results based on your filters.</p>', ], ], 'NextPageToken' => [ 'base' => NULL, 'refs' => [ 'GetFreeTierUsageRequest$nextToken' => '<p>The pagination token that indicates the next set of results to retrieve.</p>', 'GetFreeTierUsageResponse$nextToken' => '<p>The pagination token that indicates the next set of results to retrieve.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The request was denied due to request throttling.</p>', 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>The input fails to satisfy the constraints specified by an Amazon Web Service.</p>', 'refs' => [], ], 'Value' => [ 'base' => NULL, 'refs' => [ 'Values$member' => NULL, ], ], 'Values' => [ 'base' => NULL, 'refs' => [ 'DimensionValues$Values' => '<p>The metadata values you can specify to filter upon, so that the results all match at least one of the specified values.</p>', ], ], ],];
