<?php
// This file was auto-generated from sdk-root/src/data/grafana/2020-08-18/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon Managed Grafana is a fully managed and secure data visualization service that you can use to instantly query, correlate, and visualize operational metrics, logs, and traces from multiple sources. Amazon Managed Grafana makes it easy to deploy, operate, and scale Grafana, a widely deployed data visualization tool that is popular for its extensible data support.</p> <p>With Amazon Managed Grafana, you create logically isolated Grafana servers called <i>workspaces</i>. In a workspace, you can create Grafana dashboards and visualizations to analyze your metrics, logs, and traces without having to build, package, or deploy any hardware to run Grafana servers. </p>', 'operations' => [ 'AssociateLicense' => '<p>Assigns a Grafana Enterprise license to a workspace. To upgrade, you must use <code>ENTERPRISE</code> for the <code>licenseType</code>, and pass in a valid Grafana Labs token for the <code>grafanaToken</code>. Upgrading to Grafana Enterprise incurs additional fees. For more information, see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/upgrade-to-Grafana-Enterprise.html">Upgrade a workspace to Grafana Enterprise</a>.</p>', 'CreateWorkspace' => '<p>Creates a <i>workspace</i>. In a workspace, you can create Grafana dashboards and visualizations to analyze your metrics, logs, and traces. You don\'t have to build, package, or deploy any hardware to run the Grafana server.</p> <p>Don\'t use <code>CreateWorkspace</code> to modify an existing workspace. Instead, use <a href="https://docs.aws.amazon.com/grafana/latest/APIReference/API_UpdateWorkspace.html">UpdateWorkspace</a>.</p>', 'CreateWorkspaceApiKey' => '<p>Creates a Grafana API key for the workspace. This key can be used to authenticate requests sent to the workspace\'s HTTP API. See <a href="https://docs.aws.amazon.com/grafana/latest/userguide/Using-Grafana-APIs.html">https://docs.aws.amazon.com/grafana/latest/userguide/Using-Grafana-APIs.html</a> for available APIs and example requests.</p> <note> <p>In workspaces compatible with Grafana version 9 or above, use workspace service accounts instead of API keys. API keys will be removed in a future release.</p> </note>', 'CreateWorkspaceServiceAccount' => '<p>Creates a service account for the workspace. A service account can be used to call Grafana HTTP APIs, and run automated workloads. After creating the service account with the correct <code>GrafanaRole</code> for your use case, use <code>CreateWorkspaceServiceAccountToken</code> to create a token that can be used to authenticate and authorize Grafana HTTP API calls.</p> <p>You can only create service accounts for workspaces that are compatible with Grafana version 9 and above.</p> <note> <p>For more information about service accounts, see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/service-accounts.html">Service accounts</a> in the <i>Amazon Managed Grafana User Guide</i>.</p> <p>For more information about the Grafana HTTP APIs, see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/Using-Grafana-APIs.html">Using Grafana HTTP APIs</a> in the <i>Amazon Managed Grafana User Guide</i>.</p> </note>', 'CreateWorkspaceServiceAccountToken' => '<p>Creates a token that can be used to authenticate and authorize Grafana HTTP API operations for the given <a href="https://docs.aws.amazon.com/grafana/latest/userguide/service-accounts.html">workspace service account</a>. The service account acts as a user for the API operations, and defines the permissions that are used by the API.</p> <important> <p>When you create the service account token, you will receive a key that is used when calling Grafana APIs. Do not lose this key, as it will not be retrievable again.</p> <p>If you do lose the key, you can delete the token and recreate it to receive a new key. This will disable the initial key.</p> </important> <p>Service accounts are only available for workspaces that are compatible with Grafana version 9 and above.</p>', 'DeleteWorkspace' => '<p>Deletes an Amazon Managed Grafana workspace.</p>', 'DeleteWorkspaceApiKey' => '<p>Deletes a Grafana API key for the workspace.</p> <note> <p>In workspaces compatible with Grafana version 9 or above, use workspace service accounts instead of API keys. API keys will be removed in a future release.</p> </note>', 'DeleteWorkspaceServiceAccount' => '<p>Deletes a workspace service account from the workspace.</p> <p>This will delete any tokens created for the service account, as well. If the tokens are currently in use, the will fail to authenticate / authorize after they are deleted.</p> <p>Service accounts are only available for workspaces that are compatible with Grafana version 9 and above.</p>', 'DeleteWorkspaceServiceAccountToken' => '<p>Deletes a token for the workspace service account.</p> <p>This will disable the key associated with the token. If any automation is currently using the key, it will no longer be authenticated or authorized to perform actions with the Grafana HTTP APIs.</p> <p>Service accounts are only available for workspaces that are compatible with Grafana version 9 and above.</p>', 'DescribeWorkspace' => '<p>Displays information about one Amazon Managed Grafana workspace.</p>', 'DescribeWorkspaceAuthentication' => '<p>Displays information about the authentication methods used in one Amazon Managed Grafana workspace.</p>', 'DescribeWorkspaceConfiguration' => '<p>Gets the current configuration string for the given workspace.</p>', 'DisassociateLicense' => '<p>Removes the Grafana Enterprise license from a workspace.</p>', 'ListPermissions' => '<p>Lists the users and groups who have the Grafana <code>Admin</code> and <code>Editor</code> roles in this workspace. If you use this operation without specifying <code>userId</code> or <code>groupId</code>, the operation returns the roles of all users and groups. If you specify a <code>userId</code> or a <code>groupId</code>, only the roles for that user or group are returned. If you do this, you can specify only one <code>userId</code> or one <code>groupId</code>.</p>', 'ListTagsForResource' => '<p>The <code>ListTagsForResource</code> operation returns the tags that are associated with the Amazon Managed Service for Grafana resource specified by the <code>resourceArn</code>. Currently, the only resource that can be tagged is a workspace. </p>', 'ListVersions' => '<p>Lists available versions of Grafana. These are available when calling <code>CreateWorkspace</code>. Optionally, include a workspace to list the versions to which it can be upgraded.</p>', 'ListWorkspaceServiceAccountTokens' => '<p>Returns a list of tokens for a workspace service account.</p> <note> <p>This does not return the key for each token. You cannot access keys after they are created. To create a new key, delete the token and recreate it.</p> </note> <p>Service accounts are only available for workspaces that are compatible with Grafana version 9 and above.</p>', 'ListWorkspaceServiceAccounts' => '<p>Returns a list of service accounts for a workspace.</p> <p>Service accounts are only available for workspaces that are compatible with Grafana version 9 and above.</p>', 'ListWorkspaces' => '<p>Returns a list of Amazon Managed Grafana workspaces in the account, with some information about each workspace. For more complete information about one workspace, use <a href="https://docs.aws.amazon.com/AAMG/latest/APIReference/API_DescribeWorkspace.html">DescribeWorkspace</a>.</p>', 'TagResource' => '<p>The <code>TagResource</code> operation associates tags with an Amazon Managed Grafana resource. Currently, the only resource that can be tagged is workspaces. </p> <p>If you specify a new tag key for the resource, this tag is appended to the list of tags associated with the resource. If you specify a tag key that is already associated with the resource, the new tag value that you specify replaces the previous value for that tag.</p>', 'UntagResource' => '<p>The <code>UntagResource</code> operation removes the association of the tag with the Amazon Managed Grafana resource. </p>', 'UpdatePermissions' => '<p>Updates which users in a workspace have the Grafana <code>Admin</code> or <code>Editor</code> roles.</p>', 'UpdateWorkspace' => '<p>Modifies an existing Amazon Managed Grafana workspace. If you use this operation and omit any optional parameters, the existing values of those parameters are not changed.</p> <p>To modify the user authentication methods that the workspace uses, such as SAML or IAM Identity Center, use <a href="https://docs.aws.amazon.com/grafana/latest/APIReference/API_UpdateWorkspaceAuthentication.html">UpdateWorkspaceAuthentication</a>.</p> <p>To modify which users in the workspace have the <code>Admin</code> and <code>Editor</code> Grafana roles, use <a href="https://docs.aws.amazon.com/grafana/latest/APIReference/API_UpdatePermissions.html">UpdatePermissions</a>.</p>', 'UpdateWorkspaceAuthentication' => '<p>Use this operation to define the identity provider (IdP) that this workspace authenticates users from, using SAML. You can also map SAML assertion attributes to workspace user information and define which groups in the assertion attribute are to have the <code>Admin</code> and <code>Editor</code> roles in the workspace.</p> <note> <p>Changes to the authentication method for a workspace may take a few minutes to take effect.</p> </note>', 'UpdateWorkspaceConfiguration' => '<p>Updates the configuration string for the given workspace</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You do not have sufficient permissions to perform this action. </p>', 'refs' => [], ], 'AccountAccessType' => [ 'base' => NULL, 'refs' => [ 'CreateWorkspaceRequest$accountAccessType' => '<p>Specifies whether the workspace can access Amazon Web Services resources in this Amazon Web Services account only, or whether it can also access Amazon Web Services resources in other accounts in the same organization. If you specify <code>ORGANIZATION</code>, you must specify which organizational units the workspace can access in the <code>workspaceOrganizationalUnits</code> parameter.</p>', 'UpdateWorkspaceRequest$accountAccessType' => '<p>Specifies whether the workspace can access Amazon Web Services resources in this Amazon Web Services account only, or whether it can also access Amazon Web Services resources in other accounts in the same organization. If you specify <code>ORGANIZATION</code>, you must specify which organizational units the workspace can access in the <code>workspaceOrganizationalUnits</code> parameter.</p>', 'WorkspaceDescription$accountAccessType' => '<p>Specifies whether the workspace can access Amazon Web Services resources in this Amazon Web Services account only, or whether it can also access Amazon Web Services resources in other accounts in the same organization. If this is <code>ORGANIZATION</code>, the <code>workspaceOrganizationalUnits</code> parameter specifies which organizational units the workspace can access.</p>', ], ], 'AllowedOrganization' => [ 'base' => NULL, 'refs' => [ 'AllowedOrganizations$member' => NULL, ], ], 'AllowedOrganizations' => [ 'base' => NULL, 'refs' => [ 'SamlConfiguration$allowedOrganizations' => '<p>Lists which organizations defined in the SAML assertion are allowed to use the Amazon Managed Grafana workspace. If this is empty, all organizations in the assertion attribute have access.</p>', ], ], 'ApiKeyName' => [ 'base' => NULL, 'refs' => [ 'CreateWorkspaceApiKeyRequest$keyName' => '<p>Specifies the name of the key. Keynames must be unique to the workspace.</p>', 'CreateWorkspaceApiKeyResponse$keyName' => '<p>The name of the key that was created.</p>', 'DeleteWorkspaceApiKeyRequest$keyName' => '<p>The name of the API key to delete.</p>', 'DeleteWorkspaceApiKeyResponse$keyName' => '<p>The name of the key that was deleted.</p>', ], ], 'ApiKeyToken' => [ 'base' => NULL, 'refs' => [ 'CreateWorkspaceApiKeyResponse$key' => '<p>The key token. Use this value as a bearer token to authenticate HTTP requests to the workspace.</p>', ], ], 'AssertionAttribute' => [ 'base' => NULL, 'refs' => [ 'AssertionAttributes$email' => '<p>The name of the attribute within the SAML assertion to use as the email names for SAML users.</p>', 'AssertionAttributes$groups' => '<p>The name of the attribute within the SAML assertion to use as the user full "friendly" names for user groups.</p>', 'AssertionAttributes$login' => '<p>The name of the attribute within the SAML assertion to use as the login names for SAML users.</p>', 'AssertionAttributes$name' => '<p>The name of the attribute within the SAML assertion to use as the user full "friendly" names for SAML users.</p>', 'AssertionAttributes$org' => '<p>The name of the attribute within the SAML assertion to use as the user full "friendly" names for the users\' organizations.</p>', 'AssertionAttributes$role' => '<p>The name of the attribute within the SAML assertion to use as the user roles.</p>', ], ], 'AssertionAttributes' => [ 'base' => '<p>A structure that defines which attributes in the IdP assertion are to be used to define information about the users authenticated by the IdP to use the workspace.</p>', 'refs' => [ 'SamlConfiguration$assertionAttributes' => '<p>A structure that defines which attributes in the SAML assertion are to be used to define information about the users authenticated by that IdP to use the workspace.</p>', ], ], 'AssociateLicenseRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateLicenseResponse' => [ 'base' => NULL, 'refs' => [], ], 'AuthenticationDescription' => [ 'base' => '<p>A structure containing information about the user authentication methods used by the workspace.</p>', 'refs' => [ 'DescribeWorkspaceAuthenticationResponse$authentication' => '<p>A structure containing information about the authentication methods used in the workspace.</p>', 'UpdateWorkspaceAuthenticationResponse$authentication' => '<p>A structure that describes the user authentication for this workspace after the update is made.</p>', ], ], 'AuthenticationProviderTypes' => [ 'base' => NULL, 'refs' => [ 'AuthenticationProviders$member' => NULL, ], ], 'AuthenticationProviders' => [ 'base' => NULL, 'refs' => [ 'AuthenticationDescription$providers' => '<p>Specifies whether this workspace uses IAM Identity Center, SAML, or both methods to authenticate users to use the Grafana console in the Amazon Managed Grafana workspace.</p>', 'AuthenticationSummary$providers' => '<p>Specifies whether the workspace uses SAML, IAM Identity Center, or both methods for user authentication.</p>', 'CreateWorkspaceRequest$authenticationProviders' => '<p>Specifies whether this workspace uses SAML 2.0, IAM Identity Center, or both to authenticate users for using the Grafana console within a workspace. For more information, see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html">User authentication in Amazon Managed Grafana</a>.</p>', 'UpdateWorkspaceAuthenticationRequest$authenticationProviders' => '<p>Specifies whether this workspace uses SAML 2.0, IAM Identity Center, or both to authenticate users for using the Grafana console within a workspace. For more information, see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html">User authentication in Amazon Managed Grafana</a>.</p>', ], ], 'AuthenticationSummary' => [ 'base' => '<p>A structure that describes whether the workspace uses SAML, IAM Identity Center, or both methods for user authentication, and whether that authentication is fully configured.</p>', 'refs' => [ 'WorkspaceDescription$authentication' => '<p>A structure that describes whether the workspace uses SAML, IAM Identity Center, or both methods for user authentication.</p>', 'WorkspaceSummary$authentication' => '<p>A structure containing information about the authentication methods used in the workspace.</p>', ], ], 'AwsSsoAuthentication' => [ 'base' => '<p>A structure containing information about how this workspace works with IAM Identity Center. </p>', 'refs' => [ 'AuthenticationDescription$awsSso' => '<p>A structure containing information about how this workspace works with IAM Identity Center. </p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'UpdateWorkspaceRequest$removeNetworkAccessConfiguration' => '<p>Whether to remove the network access configuration from the workspace.</p> <p>Setting this to <code>true</code> and providing a <code>networkAccessControl</code> to set will return an error.</p> <p>If you remove this configuration by setting this to <code>true</code>, then all IP addresses and VPC endpoints will be allowed. Standard Grafana authentication and authorization will still be required.</p>', 'UpdateWorkspaceRequest$removeVpcConfiguration' => '<p>Whether to remove the VPC configuration from the workspace.</p> <p>Setting this to <code>true</code> and providing a <code>vpcConfiguration</code> to set will return an error.</p>', 'WorkspaceDescription$freeTrialConsumed' => '<p>Specifies whether this workspace has already fully used its free trial for Grafana Enterprise.</p> <note> <p>Amazon Managed Grafana workspaces no longer support Grafana Enterprise free trials.</p> </note>', ], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'CreateWorkspaceRequest$clientToken' => '<p>A unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.</p>', ], ], 'ConflictException' => [ 'base' => '<p>A resource was in an inconsistent state during an update or a deletion.</p>', 'refs' => [], ], 'CreateWorkspaceApiKeyRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateWorkspaceApiKeyRequestSecondsToLiveInteger' => [ 'base' => NULL, 'refs' => [ 'CreateWorkspaceApiKeyRequest$secondsToLive' => '<p>Specifies the time in seconds until the key expires. Keys can be valid for up to 30 days.</p>', ], ], 'CreateWorkspaceApiKeyResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateWorkspaceRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateWorkspaceResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateWorkspaceServiceAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateWorkspaceServiceAccountResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateWorkspaceServiceAccountTokenRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateWorkspaceServiceAccountTokenRequestSecondsToLiveInteger' => [ 'base' => NULL, 'refs' => [ 'CreateWorkspaceServiceAccountTokenRequest$secondsToLive' => '<p>Sets how long the token will be valid, in seconds. You can set the time up to 30 days in the future.</p>', ], ], 'CreateWorkspaceServiceAccountTokenResponse' => [ 'base' => NULL, 'refs' => [], ], 'DataSourceType' => [ 'base' => NULL, 'refs' => [ 'DataSourceTypesList$member' => NULL, ], ], 'DataSourceTypesList' => [ 'base' => NULL, 'refs' => [ 'CreateWorkspaceRequest$workspaceDataSources' => '<p>This parameter is for internal use only, and should not be used.</p>', 'UpdateWorkspaceRequest$workspaceDataSources' => '<p>This parameter is for internal use only, and should not be used.</p>', 'WorkspaceDescription$dataSources' => '<p>Specifies the Amazon Web Services data sources that have been configured to have IAM roles and permissions created to allow Amazon Managed Grafana to read data from these sources.</p> <p>This list is only used when the workspace was created through the Amazon Web Services console, and the <code>permissionType</code> is <code>SERVICE_MANAGED</code>.</p>', ], ], 'DeleteWorkspaceApiKeyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWorkspaceApiKeyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWorkspaceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWorkspaceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWorkspaceServiceAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWorkspaceServiceAccountResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWorkspaceServiceAccountTokenRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWorkspaceServiceAccountTokenResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeWorkspaceAuthenticationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeWorkspaceAuthenticationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeWorkspaceConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeWorkspaceConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeWorkspaceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeWorkspaceResponse' => [ 'base' => NULL, 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'CreateWorkspaceRequest$workspaceDescription' => '<p>A description for the workspace. This is used only to help you identify this workspace.</p> <p>Pattern: <code>^[\\\\p{L}\\\\p{Z}\\\\p{N}\\\\p{P}]{0,2048}$</code> </p>', 'UpdateWorkspaceRequest$workspaceDescription' => '<p>A description for the workspace. This is used only to help you identify this workspace.</p>', 'WorkspaceDescription$description' => '<p>The user-defined description of the workspace.</p>', 'WorkspaceSummary$description' => '<p>The customer-entered description of the workspace.</p>', ], ], 'DisassociateLicenseRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateLicenseResponse' => [ 'base' => NULL, 'refs' => [], ], 'Endpoint' => [ 'base' => NULL, 'refs' => [ 'WorkspaceDescription$endpoint' => '<p>The URL that users can use to access the Grafana console in the workspace.</p>', 'WorkspaceSummary$endpoint' => '<p>The URL endpoint to use to access the Grafana console in the workspace.</p>', ], ], 'GrafanaToken' => [ 'base' => NULL, 'refs' => [ 'AssociateLicenseRequest$grafanaToken' => '<p>A token from Grafana Labs that ties your Amazon Web Services account with a Grafana Labs account. For more information, see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/upgrade-to-Grafana-Enterprise.html#AMG-workspace-register-enterprise">Link your account with Grafana Labs</a>.</p>', 'WorkspaceDescription$grafanaToken' => '<p>The token that ties this workspace to a Grafana Labs account. For more information, see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/upgrade-to-Grafana-Enterprise.html#AMG-workspace-register-enterprise">Link your account with Grafana Labs</a>.</p>', 'WorkspaceSummary$grafanaToken' => '<p>The token that ties this workspace to a Grafana Labs account. For more information, see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/upgrade-to-Grafana-Enterprise.html#AMG-workspace-register-enterprise">Link your account with Grafana Labs</a>.</p>', ], ], 'GrafanaVersion' => [ 'base' => NULL, 'refs' => [ 'CreateWorkspaceRequest$grafanaVersion' => '<p>Specifies the version of Grafana to support in the new workspace. If not specified, defaults to the latest version (for example, 10.4).</p> <p>To get a list of supported versions, use the <code>ListVersions</code> operation.</p>', 'DescribeWorkspaceConfigurationResponse$grafanaVersion' => '<p>The supported Grafana version for the workspace.</p>', 'GrafanaVersionList$member' => NULL, 'UpdateWorkspaceConfigurationRequest$grafanaVersion' => '<p>Specifies the version of Grafana to support in the workspace. If not specified, keeps the current version of the workspace.</p> <p>Can only be used to upgrade (for example, from 8.4 to 9.4), not downgrade (for example, from 9.4 to 8.4).</p> <p>To know what versions are available to upgrade to for a specific workspace, see the <a href="https://docs.aws.amazon.com/grafana/latest/APIReference/API_ListVersions.html">ListVersions</a> operation.</p>', 'WorkspaceDescription$grafanaVersion' => '<p>The version of Grafana supported in this workspace.</p>', 'WorkspaceSummary$grafanaVersion' => '<p>The Grafana version that the workspace is running.</p>', ], ], 'GrafanaVersionList' => [ 'base' => NULL, 'refs' => [ 'ListVersionsResponse$grafanaVersions' => '<p>The Grafana versions available to create. If a workspace ID is included in the request, the Grafana versions to which this workspace can be upgraded.</p>', ], ], 'IamRoleArn' => [ 'base' => NULL, 'refs' => [ 'CreateWorkspaceRequest$workspaceRoleArn' => '<p>Specified the IAM role that grants permissions to the Amazon Web Services resources that the workspace will view data from, including both data sources and notification channels. You are responsible for managing the permissions for this role as new data sources or notification channels are added. </p>', 'UpdateWorkspaceRequest$workspaceRoleArn' => '<p>Specifies an IAM role that grants permissions to Amazon Web Services resources that the workspace accesses, such as data sources and notification channels. If this workspace has <code>permissionType</code> <code>CUSTOMER_MANAGED</code>, then this role is required.</p>', 'WorkspaceDescription$workspaceRoleArn' => '<p>The IAM role that grants permissions to the Amazon Web Services resources that the workspace will view data from. This role must already exist.</p>', ], ], 'IdpMetadata' => [ 'base' => '<p>A structure containing the identity provider (IdP) metadata used to integrate the identity provider with this workspace. You can specify the metadata either by providing a URL to its location in the <code>url</code> parameter, or by specifying the full metadata in XML format in the <code>xml</code> parameter. Specifying both will cause an error.</p>', 'refs' => [ 'SamlConfiguration$idpMetadata' => '<p>A structure containing the identity provider (IdP) metadata used to integrate the identity provider with this workspace.</p>', ], ], 'IdpMetadataUrl' => [ 'base' => NULL, 'refs' => [ 'IdpMetadata$url' => '<p>The URL of the location containing the IdP metadata.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'InternalServerException$retryAfterSeconds' => '<p>How long to wait before you retry this operation.</p>', 'ThrottlingException$retryAfterSeconds' => '<p>The value of a parameter in the request caused an error.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>Unexpected error while processing the request. Retry the request.</p>', 'refs' => [], ], 'LicenseType' => [ 'base' => NULL, 'refs' => [ 'AssociateLicenseRequest$licenseType' => '<p>The type of license to associate with the workspace.</p> <note> <p>Amazon Managed Grafana workspaces no longer support Grafana Enterprise free trials.</p> </note>', 'DisassociateLicenseRequest$licenseType' => '<p>The type of license to remove from the workspace.</p>', 'WorkspaceDescription$licenseType' => '<p>Specifies whether this workspace has a full Grafana Enterprise license.</p> <note> <p>Amazon Managed Grafana workspaces no longer support Grafana Enterprise free trials.</p> </note>', 'WorkspaceSummary$licenseType' => '<p>Specifies whether this workspace has a full Grafana Enterprise license.</p> <note> <p>Amazon Managed Grafana workspaces no longer support Grafana Enterprise free trials.</p> </note>', ], ], 'ListPermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPermissionsRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListPermissionsRequest$maxResults' => '<p>The maximum number of results to include in the response.</p>', ], ], 'ListPermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListVersionsRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListVersionsRequest$maxResults' => '<p>The maximum number of results to include in the response.</p>', ], ], 'ListVersionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkspaceServiceAccountTokensRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkspaceServiceAccountTokensRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListWorkspaceServiceAccountTokensRequest$maxResults' => '<p>The maximum number of tokens to include in the results.</p>', ], ], 'ListWorkspaceServiceAccountTokensResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkspaceServiceAccountsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkspaceServiceAccountsRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListWorkspaceServiceAccountsRequest$maxResults' => '<p>The maximum number of service accounts to include in the results.</p>', ], ], 'ListWorkspaceServiceAccountsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkspacesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkspacesRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListWorkspacesRequest$maxResults' => '<p>The maximum number of workspaces to include in the results.</p>', ], ], 'ListWorkspacesResponse' => [ 'base' => NULL, 'refs' => [], ], 'LoginValidityDuration' => [ 'base' => NULL, 'refs' => [ 'SamlConfiguration$loginValidityDuration' => '<p>How long a sign-on session by a SAML user is valid, before the user has to sign on again.</p>', ], ], 'NetworkAccessConfiguration' => [ 'base' => '<p>The configuration settings for in-bound network access to your workspace.</p> <p>When this is configured, only listed IP addresses and VPC endpoints will be able to access your workspace. Standard Grafana authentication and authorization are still required.</p> <p>Access is granted to a caller that is in either the IP address list or the VPC endpoint list - they do not need to be in both.</p> <p>If this is not configured, or is removed, then all IP addresses and VPC endpoints are allowed. Standard Grafana authentication and authorization are still required.</p> <note> <p>While both <code>prefixListIds</code> and <code>vpceIds</code> are required, you can pass in an empty array of strings for either parameter if you do not want to allow any of that type.</p> <p>If both are passed as empty arrays, no traffic is allowed to the workspace, because only <i>explicitly</i> allowed connections are accepted.</p> </note>', 'refs' => [ 'CreateWorkspaceRequest$networkAccessControl' => '<p>Configuration for network access to your workspace.</p> <p>When this is configured, only listed IP addresses and VPC endpoints will be able to access your workspace. Standard Grafana authentication and authorization will still be required.</p> <p>If this is not configured, or is removed, then all IP addresses and VPC endpoints will be allowed. Standard Grafana authentication and authorization will still be required.</p>', 'UpdateWorkspaceRequest$networkAccessControl' => '<p>The configuration settings for network access to your workspace.</p> <p>When this is configured, only listed IP addresses and VPC endpoints will be able to access your workspace. Standard Grafana authentication and authorization will still be required.</p> <p>If this is not configured, or is removed, then all IP addresses and VPC endpoints will be allowed. Standard Grafana authentication and authorization will still be required.</p>', 'WorkspaceDescription$networkAccessControl' => '<p>The configuration settings for network access to your workspace.</p>', ], ], 'NotificationDestinationType' => [ 'base' => NULL, 'refs' => [ 'NotificationDestinationsList$member' => NULL, ], ], 'NotificationDestinationsList' => [ 'base' => NULL, 'refs' => [ 'CreateWorkspaceRequest$workspaceNotificationDestinations' => '<p>Specify the Amazon Web Services notification channels that you plan to use in this workspace. Specifying these data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow Amazon Managed Grafana to use these channels.</p>', 'UpdateWorkspaceRequest$workspaceNotificationDestinations' => '<p>Specify the Amazon Web Services notification channels that you plan to use in this workspace. Specifying these data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow Amazon Managed Grafana to use these channels.</p>', 'WorkspaceDescription$notificationDestinations' => '<p>The Amazon Web Services notification channels that Amazon Managed Grafana can automatically create IAM roles and permissions for, to allow Amazon Managed Grafana to use these channels.</p>', 'WorkspaceSummary$notificationDestinations' => '<p>The Amazon Web Services notification channels that Amazon Managed Grafana can automatically create IAM roles and permissions for, which allows Amazon Managed Grafana to use these channels.</p>', ], ], 'OrganizationRoleName' => [ 'base' => NULL, 'refs' => [ 'CreateWorkspaceRequest$organizationRoleName' => '<p>The name of an IAM role that already exists to use with Organizations to access Amazon Web Services data sources and notification channels in other accounts in an organization.</p>', 'UpdateWorkspaceRequest$organizationRoleName' => '<p>The name of an IAM role that already exists to use to access resources through Organizations. This can only be used with a workspace that has the <code>permissionType</code> set to <code>CUSTOMER_MANAGED</code>.</p>', 'WorkspaceDescription$organizationRoleName' => '<p>The name of the IAM role that is used to access resources through Organizations.</p>', ], ], 'OrganizationalUnit' => [ 'base' => NULL, 'refs' => [ 'OrganizationalUnitList$member' => NULL, ], ], 'OrganizationalUnitList' => [ 'base' => NULL, 'refs' => [ 'CreateWorkspaceRequest$workspaceOrganizationalUnits' => '<p>Specifies the organizational units that this workspace is allowed to use data sources from, if this workspace is in an account that is part of an organization.</p>', 'UpdateWorkspaceRequest$workspaceOrganizationalUnits' => '<p>Specifies the organizational units that this workspace is allowed to use data sources from, if this workspace is in an account that is part of an organization.</p>', 'WorkspaceDescription$organizationalUnits' => '<p>Specifies the organizational units that this workspace is allowed to use data sources from, if this workspace is in an account that is part of an organization.</p>', ], ], 'OverridableConfigurationJson' => [ 'base' => NULL, 'refs' => [ 'CreateWorkspaceRequest$configuration' => '<p>The configuration string for the workspace that you create. For more information about the format and configuration options available, see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/AMG-configure-workspace.html">Working in your Grafana workspace</a>.</p>', 'DescribeWorkspaceConfigurationResponse$configuration' => '<p>The configuration string for the workspace that you requested. For more information about the format and configuration options available, see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/AMG-configure-workspace.html">Working in your Grafana workspace</a>.</p>', 'UpdateWorkspaceConfigurationRequest$configuration' => '<p>The new configuration string for the workspace. For more information about the format and configuration options available, see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/AMG-configure-workspace.html">Working in your Grafana workspace</a>.</p>', ], ], 'PaginationToken' => [ 'base' => NULL, 'refs' => [ 'ListPermissionsRequest$nextToken' => '<p>The token to use when requesting the next set of results. You received this token from a previous <code>ListPermissions</code> operation.</p>', 'ListPermissionsResponse$nextToken' => '<p>The token to use in a subsequent <code>ListPermissions</code> operation to return the next set of results.</p>', 'ListVersionsRequest$nextToken' => '<p>The token to use when requesting the next set of results. You receive this token from a previous <code>ListVersions</code> operation.</p>', 'ListVersionsResponse$nextToken' => '<p>The token to use in a subsequent <code>ListVersions</code> operation to return the next set of results.</p>', 'ListWorkspaceServiceAccountTokensRequest$nextToken' => '<p>The token for the next set of service accounts to return. (You receive this token from a previous <code>ListWorkspaceServiceAccountTokens</code> operation.)</p>', 'ListWorkspaceServiceAccountTokensResponse$nextToken' => '<p>The token to use when requesting the next set of service accounts.</p>', 'ListWorkspaceServiceAccountsRequest$nextToken' => '<p>The token for the next set of service accounts to return. (You receive this token from a previous <code>ListWorkspaceServiceAccounts</code> operation.)</p>', 'ListWorkspaceServiceAccountsResponse$nextToken' => '<p>The token to use when requesting the next set of service accounts.</p>', 'ListWorkspacesRequest$nextToken' => '<p>The token for the next set of workspaces to return. (You receive this token from a previous <code>ListWorkspaces</code> operation.)</p>', 'ListWorkspacesResponse$nextToken' => '<p>The token to use when requesting the next set of workspaces.</p>', ], ], 'PermissionEntry' => [ 'base' => '<p>A structure containing the identity of one user or group and the <code>Admin</code>, <code>Editor</code>, or <code>Viewer</code> role that they have.</p>', 'refs' => [ 'PermissionEntryList$member' => NULL, ], ], 'PermissionEntryList' => [ 'base' => NULL, 'refs' => [ 'ListPermissionsResponse$permissions' => '<p>The permissions returned by the operation.</p>', ], ], 'PermissionType' => [ 'base' => NULL, 'refs' => [ 'CreateWorkspaceRequest$permissionType' => '<p>When creating a workspace through the Amazon Web Services API, CLI or Amazon Web Services CloudFormation, you must manage IAM roles and provision the permissions that the workspace needs to use Amazon Web Services data sources and notification channels.</p> <p>You must also specify a <code>workspaceRoleArn</code> for a role that you will manage for the workspace to use when accessing those datasources and notification channels.</p> <p>The ability for Amazon Managed Grafana to create and update IAM roles on behalf of the user is supported only in the Amazon Managed Grafana console, where this value may be set to <code>SERVICE_MANAGED</code>.</p> <note> <p>Use only the <code>CUSTOMER_MANAGED</code> permission type when creating a workspace with the API, CLI or Amazon Web Services CloudFormation. </p> </note> <p>For more information, see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html">Amazon Managed Grafana permissions and policies for Amazon Web Services data sources and notification channels</a>.</p>', 'UpdateWorkspaceRequest$permissionType' => '<p>Use this parameter if you want to change a workspace from <code>SERVICE_MANAGED</code> to <code>CUSTOMER_MANAGED</code>. This allows you to manage the permissions that the workspace uses to access datasources and notification channels. If the workspace is in a member Amazon Web Services account of an organization, and that account is not a delegated administrator account, and you want the workspace to access data sources in other Amazon Web Services accounts in the organization, you must choose <code>CUSTOMER_MANAGED</code>.</p> <p>If you specify this as <code>CUSTOMER_MANAGED</code>, you must also specify a <code>workspaceRoleArn</code> that the workspace will use for accessing Amazon Web Services resources.</p> <p>For more information on the role and permissions needed, see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html">Amazon Managed Grafana permissions and policies for Amazon Web Services data sources and notification channels</a> </p> <note> <p>Do not use this to convert a <code>CUSTOMER_MANAGED</code> workspace to <code>SERVICE_MANAGED</code>. Do not include this parameter if you want to leave the workspace as <code>SERVICE_MANAGED</code>.</p> <p>You can convert a <code>CUSTOMER_MANAGED</code> workspace to <code>SERVICE_MANAGED</code> using the Amazon Managed Grafana console. For more information, see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/AMG-datasource-and-notification.html">Managing permissions for data sources and notification channels</a>.</p> </note>', 'WorkspaceDescription$permissionType' => '<p>If this is <code>SERVICE_MANAGED</code>, and the workplace was created through the Amazon Managed Grafana console, then Amazon Managed Grafana automatically creates the IAM roles and provisions the permissions that the workspace needs to use Amazon Web Services data sources and notification channels.</p> <p>If this is <code>CUSTOMER_MANAGED</code>, you must manage those roles and permissions yourself.</p> <p>If you are working with a workspace in a member account of an organization and that account is not a delegated administrator account, and you want the workspace to access data sources in other Amazon Web Services accounts in the organization, this parameter must be set to <code>CUSTOMER_MANAGED</code>.</p> <p>For more information about converting between customer and service managed, see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/AMG-datasource-and-notification.html">Managing permissions for data sources and notification channels</a>. For more information about the roles and permissions that must be managed for customer managed workspaces, see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html">Amazon Managed Grafana permissions and policies for Amazon Web Services data sources and notification channels</a> </p>', ], ], 'PrefixListId' => [ 'base' => NULL, 'refs' => [ 'PrefixListIds$member' => NULL, ], ], 'PrefixListIds' => [ 'base' => NULL, 'refs' => [ 'NetworkAccessConfiguration$prefixListIds' => '<p>An array of prefix list IDs. A prefix list is a list of CIDR ranges of IP addresses. The IP addresses specified are allowed to access your workspace. If the list is not included in the configuration (passed an empty array) then no IP addresses are allowed to access the workspace. You create a prefix list using the Amazon VPC console.</p> <p>Prefix list IDs have the format <code>pl-<i>1a2b3c4d</i> </code>.</p> <p>For more information about prefix lists, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/managed-prefix-lists.html">Group CIDR blocks using managed prefix lists</a>in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The request references a resource that does not exist.</p>', 'refs' => [], ], 'Role' => [ 'base' => NULL, 'refs' => [ 'CreateWorkspaceServiceAccountRequest$grafanaRole' => '<p>The permission level to use for this service account.</p> <note> <p>For more information about the roles and the permissions each has, see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/Grafana-user-roles.html">User roles</a> in the <i>Amazon Managed Grafana User Guide</i>.</p> </note>', 'CreateWorkspaceServiceAccountResponse$grafanaRole' => '<p>The permission level given to the service account.</p>', 'PermissionEntry$role' => '<p>Specifies whether the user or group has the <code>Admin</code>, <code>Editor</code>, or <code>Viewer</code> role.</p>', 'ServiceAccountSummary$grafanaRole' => '<p>The role of the service account, which sets the permission level used when calling Grafana APIs.</p>', 'UpdateInstruction$role' => '<p>The role to add or revoke for the user or the group specified in <code>users</code>.</p>', ], ], 'RoleValue' => [ 'base' => NULL, 'refs' => [ 'RoleValueList$member' => NULL, ], ], 'RoleValueList' => [ 'base' => NULL, 'refs' => [ 'RoleValues$admin' => '<p>A list of groups from the SAML assertion attribute to grant the Grafana <code>Admin</code> role to.</p>', 'RoleValues$editor' => '<p>A list of groups from the SAML assertion attribute to grant the Grafana <code>Editor</code> role to.</p>', ], ], 'RoleValues' => [ 'base' => '<p>This structure defines which groups defined in the SAML assertion attribute are to be mapped to the Grafana <code>Admin</code> and <code>Editor</code> roles in the workspace. SAML authenticated users not part of <code>Admin</code> or <code>Editor</code> role groups have <code>Viewer</code> permission over the workspace.</p>', 'refs' => [ 'SamlConfiguration$roleValues' => '<p>A structure containing arrays that map group names in the SAML assertion to the Grafana <code>Admin</code> and <code>Editor</code> roles in the workspace.</p>', ], ], 'SSOClientId' => [ 'base' => NULL, 'refs' => [ 'AwsSsoAuthentication$ssoClientId' => '<p>The ID of the IAM Identity Center-managed application that is created by Amazon Managed Grafana.</p>', ], ], 'SamlAuthentication' => [ 'base' => '<p>A structure containing information about how this workspace works with SAML. </p>', 'refs' => [ 'AuthenticationDescription$saml' => '<p>A structure containing information about how this workspace works with SAML, including what attributes within the assertion are to be mapped to user information in the workspace. </p>', ], ], 'SamlConfiguration' => [ 'base' => '<p>A structure containing information about how this workspace works with SAML. </p>', 'refs' => [ 'SamlAuthentication$configuration' => '<p>A structure containing details about how this workspace works with SAML. </p>', 'UpdateWorkspaceAuthenticationRequest$samlConfiguration' => '<p>If the workspace uses SAML, use this structure to map SAML assertion attributes to workspace user information and define which groups in the assertion attribute are to have the <code>Admin</code> and <code>Editor</code> roles in the workspace.</p>', ], ], 'SamlConfigurationStatus' => [ 'base' => NULL, 'refs' => [ 'AuthenticationSummary$samlConfigurationStatus' => '<p>Specifies whether the workplace\'s user authentication method is fully configured.</p>', 'SamlAuthentication$status' => '<p>Specifies whether the workspace\'s SAML configuration is complete.</p>', ], ], 'SecurityGroupId' => [ 'base' => NULL, 'refs' => [ 'SecurityGroupIds$member' => NULL, ], ], 'SecurityGroupIds' => [ 'base' => NULL, 'refs' => [ 'VpcConfiguration$securityGroupIds' => '<p>The list of Amazon EC2 security group IDs attached to the Amazon VPC for your Grafana workspace to connect. Duplicates not allowed.</p>', ], ], 'ServiceAccountList' => [ 'base' => NULL, 'refs' => [ 'ListWorkspaceServiceAccountsResponse$serviceAccounts' => '<p>An array of structures containing information about the service accounts.</p>', ], ], 'ServiceAccountName' => [ 'base' => NULL, 'refs' => [ 'CreateWorkspaceServiceAccountRequest$name' => '<p>A name for the service account. The name must be unique within the workspace, as it determines the ID associated with the service account.</p>', ], ], 'ServiceAccountSummary' => [ 'base' => '<p>A structure that contains the information about one service account.</p>', 'refs' => [ 'ServiceAccountList$member' => NULL, ], ], 'ServiceAccountTokenKey' => [ 'base' => NULL, 'refs' => [ 'ServiceAccountTokenSummaryWithKey$key' => '<p>The key for the service account token. Used when making calls to the Grafana HTTP APIs to authenticate and authorize the requests.</p>', ], ], 'ServiceAccountTokenList' => [ 'base' => NULL, 'refs' => [ 'ListWorkspaceServiceAccountTokensResponse$serviceAccountTokens' => '<p>An array of structures containing information about the tokens.</p>', ], ], 'ServiceAccountTokenName' => [ 'base' => NULL, 'refs' => [ 'CreateWorkspaceServiceAccountTokenRequest$name' => '<p>A name for the token to create.</p>', ], ], 'ServiceAccountTokenSummary' => [ 'base' => '<p>A structure that contains the information about a service account token.</p>', 'refs' => [ 'ServiceAccountTokenList$member' => NULL, ], ], 'ServiceAccountTokenSummaryWithKey' => [ 'base' => '<p>A structure that contains the information about a service account token.</p> <p>This structure is returned when creating the token. It is important to store the <code>key</code> that is returned, as it is not retrievable at a later time.</p> <p>If you lose the key, you can delete and recreate the token, which will create a new key.</p>', 'refs' => [ 'CreateWorkspaceServiceAccountTokenResponse$serviceAccountToken' => '<p>Information about the created token, including the key. Be sure to store the key securely.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>The request would cause a service quota to be exceeded.</p>', 'refs' => [], ], 'SsoId' => [ 'base' => NULL, 'refs' => [ 'ListPermissionsRequest$groupId' => '<p>(Optional) Limits the results to only the group that matches this ID.</p>', 'ListPermissionsRequest$userId' => '<p>(Optional) Limits the results to only the user that matches this ID.</p>', 'User$id' => '<p>The ID of the user or group.</p> <p>Pattern: <code>^([0-9a-fA-F]{10}-|)[A-Fa-f0-9]{8}-[A-Fa-f0-9]{4}-[A-Fa-f0-9]{4}-[A-Fa-f0-9]{4}-[A-Fa-f0-9]{12}$</code> </p>', ], ], 'StackSetName' => [ 'base' => NULL, 'refs' => [ 'CreateWorkspaceRequest$stackSetName' => '<p>The name of the CloudFormation stack set to use to generate IAM roles to be used for this workspace.</p>', 'UpdateWorkspaceRequest$stackSetName' => '<p>The name of the CloudFormation stack set to use to generate IAM roles to be used for this workspace.</p>', 'WorkspaceDescription$stackSetName' => '<p>The name of the CloudFormation stack set that is used to generate IAM roles to be used for this workspace.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'ConflictException$message' => '<p>A description of the error.</p>', 'ConflictException$resourceId' => '<p>The ID of the resource that is associated with the error.</p>', 'ConflictException$resourceType' => '<p>The type of the resource that is associated with the error.</p>', 'CreateWorkspaceApiKeyRequest$keyRole' => '<p>Specifies the permission level of the key.</p> <p> Valid values: <code>ADMIN</code>|<code>EDITOR</code>|<code>VIEWER</code> </p>', 'CreateWorkspaceServiceAccountResponse$id' => '<p>The ID of the service account.</p>', 'CreateWorkspaceServiceAccountResponse$name' => '<p>The name of the service account.</p>', 'CreateWorkspaceServiceAccountTokenRequest$serviceAccountId' => '<p>The ID of the service account for which to create a token.</p>', 'CreateWorkspaceServiceAccountTokenResponse$serviceAccountId' => '<p>The ID of the service account where the token was created.</p>', 'DeleteWorkspaceServiceAccountRequest$serviceAccountId' => '<p>The ID of the service account to delete.</p>', 'DeleteWorkspaceServiceAccountResponse$serviceAccountId' => '<p>The ID of the service account deleted.</p>', 'DeleteWorkspaceServiceAccountTokenRequest$serviceAccountId' => '<p>The ID of the service account from which to delete the token.</p>', 'DeleteWorkspaceServiceAccountTokenRequest$tokenId' => '<p>The ID of the token to delete.</p>', 'DeleteWorkspaceServiceAccountTokenResponse$serviceAccountId' => '<p>The ID of the service account where the token was deleted.</p>', 'DeleteWorkspaceServiceAccountTokenResponse$tokenId' => '<p>The ID of the token that was deleted.</p>', 'IdpMetadata$xml' => '<p>The full IdP metadata, in XML format.</p>', 'InternalServerException$message' => '<p>A description of the error.</p>', 'ListTagsForResourceRequest$resourceArn' => '<p>The ARN of the resource the list of tags are associated with.</p>', 'ListWorkspaceServiceAccountTokensRequest$serviceAccountId' => '<p>The ID of the service account for which to return tokens.</p>', 'ListWorkspaceServiceAccountTokensResponse$serviceAccountId' => '<p>The ID of the service account where the tokens reside.</p>', 'ResourceNotFoundException$message' => '<p>The value of a parameter in the request caused an error.</p>', 'ResourceNotFoundException$resourceId' => '<p>The ID of the resource that is associated with the error.</p>', 'ResourceNotFoundException$resourceType' => '<p>The type of the resource that is associated with the error.</p>', 'ServiceAccountSummary$id' => '<p>The unique ID of the service account.</p>', 'ServiceAccountSummary$isDisabled' => '<p>Returns true if the service account is disabled. Service accounts can be disabled and enabled in the Amazon Managed Grafana console.</p>', 'ServiceAccountSummary$name' => '<p>The name of the service account.</p>', 'ServiceAccountTokenSummary$id' => '<p>The unique ID of the service account token.</p>', 'ServiceAccountTokenSummary$name' => '<p>The name of the service account token.</p>', 'ServiceAccountTokenSummaryWithKey$id' => '<p>The unique ID of the service account token.</p>', 'ServiceAccountTokenSummaryWithKey$name' => '<p>The name of the service account token.</p>', 'ServiceQuotaExceededException$message' => '<p>A description of the error.</p>', 'ServiceQuotaExceededException$quotaCode' => '<p>The ID of the service quota that was exceeded.</p>', 'ServiceQuotaExceededException$resourceId' => '<p>The ID of the resource that is associated with the error.</p>', 'ServiceQuotaExceededException$resourceType' => '<p>The type of the resource that is associated with the error.</p>', 'ServiceQuotaExceededException$serviceCode' => '<p>The value of a parameter in the request caused an error.</p>', 'TagResourceRequest$resourceArn' => '<p>The ARN of the resource the tag is associated with.</p>', 'ThrottlingException$message' => '<p>A description of the error.</p>', 'ThrottlingException$quotaCode' => '<p>The ID of the service quota that was exceeded.</p>', 'ThrottlingException$serviceCode' => '<p>The ID of the service that is associated with the error.</p>', 'UntagResourceRequest$resourceArn' => '<p>The ARN of the resource the tag association is removed from. </p>', 'UpdateError$message' => '<p>The message for this error.</p>', 'ValidationException$message' => '<p>A description of the error.</p>', 'ValidationExceptionField$message' => '<p>A message describing why this field couldn\'t be validated.</p>', 'ValidationExceptionField$name' => '<p>The name of the field that caused the validation error.</p>', ], ], 'SubnetId' => [ 'base' => NULL, 'refs' => [ 'SubnetIds$member' => NULL, ], ], 'SubnetIds' => [ 'base' => NULL, 'refs' => [ 'VpcConfiguration$subnetIds' => '<p>The list of Amazon EC2 subnet IDs created in the Amazon VPC for your Grafana workspace to connect. Duplicates not allowed.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeys$member' => NULL, 'TagMap$key' => NULL, ], ], 'TagKeys' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>The key values of the tag to be removed from the resource.</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'CreateWorkspaceRequest$tags' => '<p>The list of tags associated with the workspace.</p>', 'ListTagsForResourceResponse$tags' => '<p>The list of tags that are associated with the resource.</p>', 'TagResourceRequest$tags' => '<p>The list of tag keys and values to associate with the resource. You can associate tag keys only, tags (key and values) only or a combination of tag keys and tags.</p>', 'WorkspaceDescription$tags' => '<p>The list of tags associated with the workspace.</p>', 'WorkspaceSummary$tags' => '<p>The list of tags associated with the workspace.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagMap$value' => NULL, ], ], 'ThrottlingException' => [ 'base' => '<p>The request was denied because of request throttling. Retry the request.</p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'ServiceAccountTokenSummary$createdAt' => '<p>When the service account token was created.</p>', 'ServiceAccountTokenSummary$expiresAt' => '<p>When the service account token will expire.</p>', 'ServiceAccountTokenSummary$lastUsedAt' => '<p>The last time the token was used to authorize a Grafana HTTP API.</p>', 'WorkspaceDescription$created' => '<p>The date that the workspace was created.</p>', 'WorkspaceDescription$freeTrialExpiration' => '<p>If this workspace is currently in the free trial period for Grafana Enterprise, this value specifies when that free trial ends.</p> <note> <p>Amazon Managed Grafana workspaces no longer support Grafana Enterprise free trials.</p> </note>', 'WorkspaceDescription$licenseExpiration' => '<p>If this workspace has a full Grafana Enterprise license purchased through Amazon Web Services Marketplace, this specifies when the license ends and will need to be renewed. Purchasing the Enterprise plugins option through Amazon Managed Grafana does not have an expiration. It is valid until the license is removed.</p>', 'WorkspaceDescription$modified' => '<p>The most recent date that the workspace was modified.</p>', 'WorkspaceSummary$created' => '<p>The date that the workspace was created.</p>', 'WorkspaceSummary$modified' => '<p>The most recent date that the workspace was modified.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAction' => [ 'base' => NULL, 'refs' => [ 'UpdateInstruction$action' => '<p>Specifies whether this update is to add or revoke role permissions.</p>', ], ], 'UpdateError' => [ 'base' => '<p>A structure containing information about one error encountered while performing an <a href="https://docs.aws.amazon.com/grafana/latest/APIReference/API_UpdatePermissions.html">UpdatePermissions</a> operation.</p>', 'refs' => [ 'UpdateErrorList$member' => NULL, ], ], 'UpdateErrorCodeInteger' => [ 'base' => NULL, 'refs' => [ 'UpdateError$code' => '<p>The error code.</p>', ], ], 'UpdateErrorList' => [ 'base' => NULL, 'refs' => [ 'UpdatePermissionsResponse$errors' => '<p>An array of structures that contain the errors from the operation, if any.</p>', ], ], 'UpdateInstruction' => [ 'base' => '<p>Contains the instructions for one Grafana role permission update in a <a href="https://docs.aws.amazon.com/grafana/latest/APIReference/API_UpdatePermissions.html">UpdatePermissions</a> operation.</p>', 'refs' => [ 'UpdateError$causedBy' => '<p>Specifies which permission update caused the error.</p>', 'UpdateInstructionBatch$member' => NULL, ], ], 'UpdateInstructionBatch' => [ 'base' => NULL, 'refs' => [ 'UpdatePermissionsRequest$updateInstructionBatch' => '<p>An array of structures that contain the permission updates to make.</p>', ], ], 'UpdatePermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWorkspaceAuthenticationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWorkspaceAuthenticationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWorkspaceConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWorkspaceConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWorkspaceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWorkspaceResponse' => [ 'base' => NULL, 'refs' => [], ], 'User' => [ 'base' => '<p>A structure that specifies one user or group in the workspace.</p>', 'refs' => [ 'PermissionEntry$user' => '<p>A structure with the ID of the user or group with this role.</p>', 'UserList$member' => NULL, ], ], 'UserList' => [ 'base' => NULL, 'refs' => [ 'UpdateInstruction$users' => '<p>A structure that specifies the user or group to add or revoke the role for.</p>', ], ], 'UserType' => [ 'base' => NULL, 'refs' => [ 'ListPermissionsRequest$userType' => '<p>(Optional) If you specify <code>SSO_USER</code>, then only the permissions of IAM Identity Center users are returned. If you specify <code>SSO_GROUP</code>, only the permissions of IAM Identity Center groups are returned.</p>', 'User$type' => '<p>Specifies whether this is a single user or a group.</p>', ], ], 'ValidationException' => [ 'base' => '<p>The value of a parameter in the request caused an error.</p>', 'refs' => [], ], 'ValidationExceptionField' => [ 'base' => '<p>A structure that contains information about a request parameter that caused an error.</p>', 'refs' => [ 'ValidationExceptionFieldList$member' => NULL, ], ], 'ValidationExceptionFieldList' => [ 'base' => NULL, 'refs' => [ 'ValidationException$fieldList' => '<p>A list of fields that might be associated with the error.</p>', ], ], 'ValidationExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ValidationException$reason' => '<p>The reason that the operation failed.</p>', ], ], 'VpcConfiguration' => [ 'base' => '<p>The configuration settings for an Amazon VPC that contains data sources for your Grafana workspace to connect to.</p> <note> <p>Provided <code>securityGroupIds</code> and <code>subnetIds</code> must be part of the same VPC.</p> <p>Connecting to a private VPC is not yet available in the Asia Pacific (Seoul) Region (ap-northeast-2).</p> </note>', 'refs' => [ 'CreateWorkspaceRequest$vpcConfiguration' => '<p>The configuration settings for an Amazon VPC that contains data sources for your Grafana workspace to connect to.</p> <note> <p>Connecting to a private VPC is not yet available in the Asia Pacific (Seoul) Region (ap-northeast-2).</p> </note>', 'UpdateWorkspaceRequest$vpcConfiguration' => '<p>The configuration settings for an Amazon VPC that contains data sources for your Grafana workspace to connect to.</p>', 'WorkspaceDescription$vpcConfiguration' => '<p>The configuration for connecting to data sources in a private VPC (Amazon Virtual Private Cloud).</p>', ], ], 'VpceId' => [ 'base' => NULL, 'refs' => [ 'VpceIds$member' => NULL, ], ], 'VpceIds' => [ 'base' => NULL, 'refs' => [ 'NetworkAccessConfiguration$vpceIds' => '<p>An array of Amazon VPC endpoint IDs for the workspace. You can create VPC endpoints to your Amazon Managed Grafana workspace for access from within a VPC. If a <code>NetworkAccessConfiguration</code> is specified then only VPC endpoints specified here are allowed to access the workspace. If you pass in an empty array of strings, then no VPCs are allowed to access the workspace.</p> <p>VPC endpoint IDs have the format <code>vpce-<i>1a2b3c4d</i> </code>.</p> <p>For more information about creating an interface VPC endpoint, see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/VPC-endpoints">Interface VPC endpoints</a> in the <i>Amazon Managed Grafana User Guide</i>.</p> <note> <p>The only VPC endpoints that can be specified here are interface VPC endpoints for Grafana workspaces (using the <code>com.amazonaws.[region].grafana-workspace</code> service endpoint). Other VPC endpoints are ignored.</p> </note>', ], ], 'WorkspaceDescription' => [ 'base' => '<p>A structure containing information about an Amazon Managed Grafana workspace in your account.</p>', 'refs' => [ 'AssociateLicenseResponse$workspace' => '<p>A structure containing data about the workspace.</p>', 'CreateWorkspaceResponse$workspace' => '<p>A structure containing data about the workspace that was created.</p>', 'DeleteWorkspaceResponse$workspace' => '<p>A structure containing information about the workspace that was deleted.</p>', 'DescribeWorkspaceResponse$workspace' => '<p>A structure containing information about the workspace.</p>', 'DisassociateLicenseResponse$workspace' => '<p>A structure containing information about the workspace.</p>', 'UpdateWorkspaceResponse$workspace' => '<p>A structure containing data about the workspace that was created.</p>', ], ], 'WorkspaceId' => [ 'base' => NULL, 'refs' => [ 'AssociateLicenseRequest$workspaceId' => '<p>The ID of the workspace to associate the license with.</p>', 'CreateWorkspaceApiKeyRequest$workspaceId' => '<p>The ID of the workspace to create an API key.</p>', 'CreateWorkspaceApiKeyResponse$workspaceId' => '<p>The ID of the workspace that the key is valid for.</p>', 'CreateWorkspaceServiceAccountRequest$workspaceId' => '<p>The ID of the workspace within which to create the service account.</p>', 'CreateWorkspaceServiceAccountResponse$workspaceId' => '<p>The workspace with which the service account is associated.</p>', 'CreateWorkspaceServiceAccountTokenRequest$workspaceId' => '<p>The ID of the workspace the service account resides within.</p>', 'CreateWorkspaceServiceAccountTokenResponse$workspaceId' => '<p>The ID of the workspace where the token was created.</p>', 'DeleteWorkspaceApiKeyRequest$workspaceId' => '<p>The ID of the workspace to delete.</p>', 'DeleteWorkspaceApiKeyResponse$workspaceId' => '<p>The ID of the workspace where the key was deleted.</p>', 'DeleteWorkspaceRequest$workspaceId' => '<p>The ID of the workspace to delete.</p>', 'DeleteWorkspaceServiceAccountRequest$workspaceId' => '<p>The ID of the workspace where the service account resides.</p>', 'DeleteWorkspaceServiceAccountResponse$workspaceId' => '<p>The ID of the workspace where the service account was deleted.</p>', 'DeleteWorkspaceServiceAccountTokenRequest$workspaceId' => '<p>The ID of the workspace from which to delete the token.</p>', 'DeleteWorkspaceServiceAccountTokenResponse$workspaceId' => '<p>The ID of the workspace where the token was deleted.</p>', 'DescribeWorkspaceAuthenticationRequest$workspaceId' => '<p>The ID of the workspace to return authentication information about.</p>', 'DescribeWorkspaceConfigurationRequest$workspaceId' => '<p>The ID of the workspace to get configuration information for.</p>', 'DescribeWorkspaceRequest$workspaceId' => '<p>The ID of the workspace to display information about.</p>', 'DisassociateLicenseRequest$workspaceId' => '<p>The ID of the workspace to remove the Grafana Enterprise license from.</p>', 'ListPermissionsRequest$workspaceId' => '<p>The ID of the workspace to list permissions for. This parameter is required.</p>', 'ListVersionsRequest$workspaceId' => '<p>The ID of the workspace to list the available upgrade versions. If not included, lists all versions of Grafana that are supported for <code>CreateWorkspace</code>.</p>', 'ListWorkspaceServiceAccountTokensRequest$workspaceId' => '<p>The ID of the workspace for which to return tokens.</p>', 'ListWorkspaceServiceAccountTokensResponse$workspaceId' => '<p>The ID of the workspace where the tokens reside.</p>', 'ListWorkspaceServiceAccountsRequest$workspaceId' => '<p>The workspace for which to list service accounts.</p>', 'ListWorkspaceServiceAccountsResponse$workspaceId' => '<p>The workspace to which the service accounts are associated.</p>', 'UpdatePermissionsRequest$workspaceId' => '<p>The ID of the workspace to update.</p>', 'UpdateWorkspaceAuthenticationRequest$workspaceId' => '<p>The ID of the workspace to update the authentication for.</p>', 'UpdateWorkspaceConfigurationRequest$workspaceId' => '<p>The ID of the workspace to update.</p>', 'UpdateWorkspaceRequest$workspaceId' => '<p>The ID of the workspace to update.</p>', 'WorkspaceDescription$id' => '<p>The unique ID of this workspace.</p>', 'WorkspaceSummary$id' => '<p>The unique ID of the workspace.</p>', ], ], 'WorkspaceList' => [ 'base' => NULL, 'refs' => [ 'ListWorkspacesResponse$workspaces' => '<p>An array of structures that contain some information about the workspaces in the account.</p>', ], ], 'WorkspaceName' => [ 'base' => NULL, 'refs' => [ 'CreateWorkspaceRequest$workspaceName' => '<p>The name for the workspace. It does not have to be unique.</p>', 'UpdateWorkspaceRequest$workspaceName' => '<p>A new name for the workspace to update.</p>', 'WorkspaceDescription$name' => '<p>The name of the workspace.</p>', 'WorkspaceSummary$name' => '<p>The name of the workspace.</p>', ], ], 'WorkspaceStatus' => [ 'base' => NULL, 'refs' => [ 'WorkspaceDescription$status' => '<p>The current status of the workspace.</p>', 'WorkspaceSummary$status' => '<p>The current status of the workspace.</p>', ], ], 'WorkspaceSummary' => [ 'base' => '<p>A structure that contains some information about one workspace in the account.</p>', 'refs' => [ 'WorkspaceList$member' => NULL, ], ], ],];
