<?php
// This file was auto-generated from sdk-root/src/data/guardduty/2017-11-28/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon GuardDuty is a continuous security monitoring service that analyzes and processes the following foundational data sources - VPC flow logs, Amazon Web Services CloudTrail management event logs, CloudTrail S3 data event logs, EKS audit logs, DNS logs, Amazon EBS volume data, runtime activity belonging to container workloads, such as Amazon EKS, Amazon ECS (including Amazon Web Services Fargate), and Amazon EC2 instances. It uses threat intelligence feeds, such as lists of malicious IPs and domains, and machine learning to identify unexpected, potentially unauthorized, and malicious activity within your Amazon Web Services environment. This can include issues like escalations of privileges, uses of exposed credentials, or communication with malicious IPs, domains, or presence of malware on your Amazon EC2 instances and container workloads. For example, GuardDuty can detect compromised EC2 instances and container workloads serving malware, or mining bitcoin. </p> <p>GuardDuty also monitors Amazon Web Services account access behavior for signs of compromise, such as unauthorized infrastructure deployments like EC2 instances deployed in a Region that has never been used, or unusual API calls like a password policy change to reduce password strength. </p> <p>GuardDuty informs you about the status of your Amazon Web Services environment by producing security findings that you can view in the GuardDuty console or through Amazon EventBridge. For more information, see the <i> <a href="https://docs.aws.amazon.com/guardduty/latest/ug/what-is-guardduty.html">Amazon GuardDuty User Guide</a> </i>. </p>', 'operations' => [ 'AcceptAdministratorInvitation' => '<p>Accepts the invitation to be a member account and get monitored by a GuardDuty administrator account that sent the invitation.</p>', 'AcceptInvitation' => '<p>Accepts the invitation to be monitored by a GuardDuty administrator account.</p>', 'ArchiveFindings' => '<p>Archives GuardDuty findings that are specified by the list of finding IDs.</p> <note> <p>Only the administrator account can archive findings. Member accounts don\'t have permission to archive findings from their accounts.</p> </note>', 'CreateDetector' => '<p>Creates a single GuardDuty detector. A detector is a resource that represents the GuardDuty service. To start using GuardDuty, you must create a detector in each Region where you enable the service. You can have only one detector per account per Region. All data sources are enabled in a new detector by default.</p> <ul> <li> <p>When you don\'t specify any <code>features</code>, with an exception to <code>RUNTIME_MONITORING</code>, all the optional features are enabled by default.</p> </li> <li> <p>When you specify some of the <code>features</code>, any feature that is not specified in the API call gets enabled by default, with an exception to <code>RUNTIME_MONITORING</code>. </p> </li> </ul> <p>Specifying both EKS Runtime Monitoring (<code>EKS_RUNTIME_MONITORING</code>) and Runtime Monitoring (<code>RUNTIME_MONITORING</code>) will cause an error. You can add only one of these two features because Runtime Monitoring already includes the threat detection for Amazon EKS resources. For more information, see <a href="https://docs.aws.amazon.com/guardduty/latest/ug/runtime-monitoring.html">Runtime Monitoring</a>.</p> <p>There might be regional differences because some data sources might not be available in all the Amazon Web Services Regions where GuardDuty is presently supported. For more information, see <a href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.</p>', 'CreateFilter' => '<p>Creates a filter using the specified finding criteria. The maximum number of saved filters per Amazon Web Services account per Region is 100. For more information, see <a href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_limits.html">Quotas for GuardDuty</a>.</p>', 'CreateIPSet' => '<p>Creates a new IPSet, which is called a trusted IP list in the console user interface. An IPSet is a list of IP addresses that are trusted for secure communication with Amazon Web Services infrastructure and applications. GuardDuty doesn\'t generate findings for IP addresses that are included in IPSets. Only users from the administrator account can use this operation.</p>', 'CreateMalwareProtectionPlan' => '<p>Creates a new Malware Protection plan for the protected resource.</p> <p>When you create a Malware Protection plan, the Amazon Web Services service terms for GuardDuty Malware Protection apply. For more information, see <a href="http://aws.amazon.com/service-terms/#87._Amazon_GuardDuty">Amazon Web Services service terms for GuardDuty Malware Protection</a>.</p>', 'CreateMembers' => '<p>Creates member accounts of the current Amazon Web Services account by specifying a list of Amazon Web Services account IDs. This step is a prerequisite for managing the associated member accounts either by invitation or through an organization.</p> <p>As a delegated administrator, using <code>CreateMembers</code> will enable GuardDuty in the added member accounts, with the exception of the organization delegated administrator account. A delegated administrator must enable GuardDuty prior to being added as a member.</p> <p>When you use CreateMembers as an Organizations delegated administrator, GuardDuty applies your organization\'s auto-enable settings to the member accounts in this request, irrespective of the accounts being new or existing members. For more information about the existing auto-enable settings for your organization, see <a href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_DescribeOrganizationConfiguration.html">DescribeOrganizationConfiguration</a>.</p> <p>If you disassociate a member account that was added by invitation, the member account details obtained from this API, including the associated email addresses, will be retained. This is done so that the delegated administrator can invoke the <a href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_InviteMembers.html">InviteMembers</a> API without the need to invoke the CreateMembers API again. To remove the details associated with a member account, the delegated administrator must invoke the <a href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_DeleteMembers.html">DeleteMembers</a> API. </p> <p>When the member accounts added through Organizations are later disassociated, you (administrator) can\'t invite them by calling the InviteMembers API. You can create an association with these member accounts again only by calling the CreateMembers API.</p>', 'CreatePublishingDestination' => '<p>Creates a publishing destination to export findings to. The resource to export findings to must exist before you use this operation.</p>', 'CreateSampleFindings' => '<p>Generates sample findings of types specified by the list of finding types. If \'NULL\' is specified for <code>findingTypes</code>, the API generates sample findings of all supported finding types.</p>', 'CreateThreatIntelSet' => '<p>Creates a new ThreatIntelSet. ThreatIntelSets consist of known malicious IP addresses. GuardDuty generates findings based on ThreatIntelSets. Only users of the administrator account can use this operation.</p>', 'DeclineInvitations' => '<p>Declines invitations sent to the current member account by Amazon Web Services accounts specified by their account IDs.</p>', 'DeleteDetector' => '<p>Deletes an Amazon GuardDuty detector that is specified by the detector ID.</p>', 'DeleteFilter' => '<p>Deletes the filter specified by the filter name.</p>', 'DeleteIPSet' => '<p>Deletes the IPSet specified by the <code>ipSetId</code>. IPSets are called trusted IP lists in the console user interface.</p>', 'DeleteInvitations' => '<p>Deletes invitations sent to the current member account by Amazon Web Services accounts specified by their account IDs.</p>', 'DeleteMalwareProtectionPlan' => '<p>Deletes the Malware Protection plan ID associated with the Malware Protection plan resource. Use this API only when you no longer want to protect the resource associated with this Malware Protection plan ID.</p>', 'DeleteMembers' => '<p>Deletes GuardDuty member accounts (to the current GuardDuty administrator account) specified by the account IDs.</p> <p>With <code>autoEnableOrganizationMembers</code> configuration for your organization set to <code>ALL</code>, you\'ll receive an error if you attempt to disable GuardDuty for a member account in your organization.</p>', 'DeletePublishingDestination' => '<p>Deletes the publishing definition with the specified <code>destinationId</code>.</p>', 'DeleteThreatIntelSet' => '<p>Deletes the ThreatIntelSet specified by the ThreatIntelSet ID.</p>', 'DescribeMalwareScans' => '<p>Returns a list of malware scans. Each member account can view the malware scans for their own accounts. An administrator can view the malware scans for all the member accounts.</p> <p>There might be regional differences because some data sources might not be available in all the Amazon Web Services Regions where GuardDuty is presently supported. For more information, see <a href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.</p>', 'DescribeOrganizationConfiguration' => '<p>Returns information about the account selected as the delegated administrator for GuardDuty.</p> <p>There might be regional differences because some data sources might not be available in all the Amazon Web Services Regions where GuardDuty is presently supported. For more information, see <a href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.</p>', 'DescribePublishingDestination' => '<p>Returns information about the publishing destination specified by the provided <code>destinationId</code>.</p>', 'DisableOrganizationAdminAccount' => '<p>Removes the existing GuardDuty delegated administrator of the organization. Only the organization\'s management account can run this API operation.</p>', 'DisassociateFromAdministratorAccount' => '<p>Disassociates the current GuardDuty member account from its administrator account.</p> <p>When you disassociate an invited member from a GuardDuty delegated administrator, the member account details obtained from the <a href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_CreateMembers.html">CreateMembers</a> API, including the associated email addresses, are retained. This is done so that the delegated administrator can invoke the <a href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_InviteMembers.html">InviteMembers</a> API without the need to invoke the CreateMembers API again. To remove the details associated with a member account, the delegated administrator must invoke the <a href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_DeleteMembers.html">DeleteMembers</a> API. </p> <p>With <code>autoEnableOrganizationMembers</code> configuration for your organization set to <code>ALL</code>, you\'ll receive an error if you attempt to disable GuardDuty in a member account.</p>', 'DisassociateFromMasterAccount' => '<p>Disassociates the current GuardDuty member account from its administrator account.</p> <p>When you disassociate an invited member from a GuardDuty delegated administrator, the member account details obtained from the <a href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_CreateMembers.html">CreateMembers</a> API, including the associated email addresses, are retained. This is done so that the delegated administrator can invoke the <a href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_InviteMembers.html">InviteMembers</a> API without the need to invoke the CreateMembers API again. To remove the details associated with a member account, the delegated administrator must invoke the <a href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_DeleteMembers.html">DeleteMembers</a> API.</p>', 'DisassociateMembers' => '<p>Disassociates GuardDuty member accounts (from the current administrator account) specified by the account IDs.</p> <p>When you disassociate an invited member from a GuardDuty delegated administrator, the member account details obtained from the <a href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_CreateMembers.html">CreateMembers</a> API, including the associated email addresses, are retained. This is done so that the delegated administrator can invoke the <a href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_InviteMembers.html">InviteMembers</a> API without the need to invoke the CreateMembers API again. To remove the details associated with a member account, the delegated administrator must invoke the <a href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_DeleteMembers.html">DeleteMembers</a> API. </p> <p>With <code>autoEnableOrganizationMembers</code> configuration for your organization set to <code>ALL</code>, you\'ll receive an error if you attempt to disassociate a member account before removing them from your organization.</p> <p>If you disassociate a member account that was added by invitation, the member account details obtained from this API, including the associated email addresses, will be retained. This is done so that the delegated administrator can invoke the <a href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_InviteMembers.html">InviteMembers</a> API without the need to invoke the CreateMembers API again. To remove the details associated with a member account, the delegated administrator must invoke the <a href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_DeleteMembers.html">DeleteMembers</a> API. </p> <p>When the member accounts added through Organizations are later disassociated, you (administrator) can\'t invite them by calling the InviteMembers API. You can create an association with these member accounts again only by calling the CreateMembers API.</p>', 'EnableOrganizationAdminAccount' => '<p>Designates an Amazon Web Services account within the organization as your GuardDuty delegated administrator. Only the organization\'s management account can run this API operation.</p>', 'GetAdministratorAccount' => '<p>Provides the details of the GuardDuty administrator account associated with the current GuardDuty member account.</p> <note> <p>If the organization\'s management account or a delegated administrator runs this API, it will return success (<code>HTTP 200</code>) but no content.</p> </note>', 'GetCoverageStatistics' => '<p>Retrieves aggregated statistics for your account. If you are a GuardDuty administrator, you can retrieve the statistics for all the resources associated with the active member accounts in your organization who have enabled Runtime Monitoring and have the GuardDuty security agent running on their resources.</p>', 'GetDetector' => '<p>Retrieves an Amazon GuardDuty detector specified by the detectorId.</p> <p>There might be regional differences because some data sources might not be available in all the Amazon Web Services Regions where GuardDuty is presently supported. For more information, see <a href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.</p>', 'GetFilter' => '<p>Returns the details of the filter specified by the filter name.</p>', 'GetFindings' => '<p>Describes Amazon GuardDuty findings specified by finding IDs.</p>', 'GetFindingsStatistics' => '<p>Lists Amazon GuardDuty findings statistics for the specified detector ID.</p> <p>There might be regional differences because some flags might not be available in all the Regions where GuardDuty is currently supported. For more information, see <a href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.</p>', 'GetIPSet' => '<p>Retrieves the IPSet specified by the <code>ipSetId</code>.</p>', 'GetInvitationsCount' => '<p>Returns the count of all GuardDuty membership invitations that were sent to the current member account except the currently accepted invitation.</p>', 'GetMalwareProtectionPlan' => '<p>Retrieves the Malware Protection plan details associated with a Malware Protection plan ID.</p>', 'GetMalwareScanSettings' => '<p>Returns the details of the malware scan settings.</p> <p>There might be regional differences because some data sources might not be available in all the Amazon Web Services Regions where GuardDuty is presently supported. For more information, see <a href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.</p>', 'GetMasterAccount' => '<p>Provides the details for the GuardDuty administrator account associated with the current GuardDuty member account.</p>', 'GetMemberDetectors' => '<p>Describes which data sources are enabled for the member account\'s detector.</p> <p>There might be regional differences because some data sources might not be available in all the Amazon Web Services Regions where GuardDuty is presently supported. For more information, see <a href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.</p>', 'GetMembers' => '<p>Retrieves GuardDuty member accounts (of the current GuardDuty administrator account) specified by the account IDs.</p>', 'GetOrganizationStatistics' => '<p>Retrieves how many active member accounts have each feature enabled within GuardDuty. Only a delegated GuardDuty administrator of an organization can run this API.</p> <p>When you create a new organization, it might take up to 24 hours to generate the statistics for the entire organization.</p>', 'GetRemainingFreeTrialDays' => '<p>Provides the number of days left for each data source used in the free trial period.</p>', 'GetThreatIntelSet' => '<p>Retrieves the ThreatIntelSet that is specified by the ThreatIntelSet ID.</p>', 'GetUsageStatistics' => '<p>Lists Amazon GuardDuty usage statistics over the last 30 days for the specified detector ID. For newly enabled detectors or data sources, the cost returned will include only the usage so far under 30 days. This may differ from the cost metrics in the console, which project usage over 30 days to provide a monthly cost estimate. For more information, see <a href="https://docs.aws.amazon.com/guardduty/latest/ug/monitoring_costs.html#usage-calculations">Understanding How Usage Costs are Calculated</a>.</p>', 'InviteMembers' => '<p>Invites Amazon Web Services accounts to become members of an organization administered by the Amazon Web Services account that invokes this API. If you are using Amazon Web Services Organizations to manage your GuardDuty environment, this step is not needed. For more information, see <a href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_organizations.html">Managing accounts with organizations</a>.</p> <p>To invite Amazon Web Services accounts, the first step is to ensure that GuardDuty has been enabled in the potential member accounts. You can now invoke this API to add accounts by invitation. The invited accounts can either accept or decline the invitation from their GuardDuty accounts. Each invited Amazon Web Services account can choose to accept the invitation from only one Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_invitations.html">Managing GuardDuty accounts by invitation</a>.</p> <p>After the invite has been accepted and you choose to disassociate a member account (by using <a href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_DisassociateMembers.html">DisassociateMembers</a>) from your account, the details of the member account obtained by invoking <a href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_CreateMembers.html">CreateMembers</a>, including the associated email addresses, will be retained. This is done so that you can invoke InviteMembers without the need to invoke <a href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_CreateMembers.html">CreateMembers</a> again. To remove the details associated with a member account, you must also invoke <a href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_DeleteMembers.html">DeleteMembers</a>. </p> <p>If you disassociate a member account that was added by invitation, the member account details obtained from this API, including the associated email addresses, will be retained. This is done so that the delegated administrator can invoke the <a href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_InviteMembers.html">InviteMembers</a> API without the need to invoke the CreateMembers API again. To remove the details associated with a member account, the delegated administrator must invoke the <a href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_DeleteMembers.html">DeleteMembers</a> API. </p> <p>When the member accounts added through Organizations are later disassociated, you (administrator) can\'t invite them by calling the InviteMembers API. You can create an association with these member accounts again only by calling the CreateMembers API.</p>', 'ListCoverage' => '<p>Lists coverage details for your GuardDuty account. If you\'re a GuardDuty administrator, you can retrieve all resources associated with the active member accounts in your organization.</p> <p>Make sure the accounts have Runtime Monitoring enabled and GuardDuty agent running on their resources.</p>', 'ListDetectors' => '<p>Lists detectorIds of all the existing Amazon GuardDuty detector resources.</p>', 'ListFilters' => '<p>Returns a paginated list of the current filters.</p>', 'ListFindings' => '<p>Lists GuardDuty findings for the specified detector ID.</p> <p>There might be regional differences because some flags might not be available in all the Regions where GuardDuty is currently supported. For more information, see <a href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.</p>', 'ListIPSets' => '<p>Lists the IPSets of the GuardDuty service specified by the detector ID. If you use this operation from a member account, the IPSets returned are the IPSets from the associated administrator account.</p>', 'ListInvitations' => '<p>Lists all GuardDuty membership invitations that were sent to the current Amazon Web Services account.</p>', 'ListMalwareProtectionPlans' => '<p>Lists the Malware Protection plan IDs associated with the protected resources in your Amazon Web Services account.</p>', 'ListMembers' => '<p>Lists details about all member accounts for the current GuardDuty administrator account.</p>', 'ListOrganizationAdminAccounts' => '<p>Lists the accounts designated as GuardDuty delegated administrators. Only the organization\'s management account can run this API operation.</p>', 'ListPublishingDestinations' => '<p>Returns a list of publishing destinations associated with the specified <code>detectorId</code>.</p>', 'ListTagsForResource' => '<p>Lists tags for a resource. Tagging is currently supported for detectors, finding filters, IP sets, threat intel sets, and publishing destination, with a limit of 50 tags per resource. When invoked, this operation returns all assigned tags for a given resource.</p>', 'ListThreatIntelSets' => '<p>Lists the ThreatIntelSets of the GuardDuty service specified by the detector ID. If you use this operation from a member account, the ThreatIntelSets associated with the administrator account are returned.</p>', 'StartMalwareScan' => '<p>Initiates the malware scan. Invoking this API will automatically create the <a href="https://docs.aws.amazon.com/guardduty/latest/ug/slr-permissions-malware-protection.html">Service-linked role</a> in the corresponding account.</p> <p>When the malware scan starts, you can use the associated scan ID to track the status of the scan. For more information, see <a href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_DescribeMalwareScans.html">DescribeMalwareScans</a>.</p>', 'StartMonitoringMembers' => '<p>Turns on GuardDuty monitoring of the specified member accounts. Use this operation to restart monitoring of accounts that you stopped monitoring with the <a href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_StopMonitoringMembers.html">StopMonitoringMembers</a> operation.</p>', 'StopMonitoringMembers' => '<p>Stops GuardDuty monitoring for the specified member accounts. Use the <code>StartMonitoringMembers</code> operation to restart monitoring for those accounts.</p> <p>With <code>autoEnableOrganizationMembers</code> configuration for your organization set to <code>ALL</code>, you\'ll receive an error if you attempt to stop monitoring the member accounts in your organization.</p>', 'TagResource' => '<p>Adds tags to a resource.</p>', 'UnarchiveFindings' => '<p>Unarchives GuardDuty findings specified by the <code>findingIds</code>.</p>', 'UntagResource' => '<p>Removes tags from a resource.</p>', 'UpdateDetector' => '<p>Updates the GuardDuty detector specified by the detector ID.</p> <p>Specifying both EKS Runtime Monitoring (<code>EKS_RUNTIME_MONITORING</code>) and Runtime Monitoring (<code>RUNTIME_MONITORING</code>) will cause an error. You can add only one of these two features because Runtime Monitoring already includes the threat detection for Amazon EKS resources. For more information, see <a href="https://docs.aws.amazon.com/guardduty/latest/ug/runtime-monitoring.html">Runtime Monitoring</a>.</p> <p>There might be regional differences because some data sources might not be available in all the Amazon Web Services Regions where GuardDuty is presently supported. For more information, see <a href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.</p>', 'UpdateFilter' => '<p>Updates the filter specified by the filter name.</p>', 'UpdateFindingsFeedback' => '<p>Marks the specified GuardDuty findings as useful or not useful.</p>', 'UpdateIPSet' => '<p>Updates the IPSet specified by the IPSet ID.</p>', 'UpdateMalwareProtectionPlan' => '<p>Updates an existing Malware Protection plan resource.</p>', 'UpdateMalwareScanSettings' => '<p>Updates the malware scan settings.</p> <p>There might be regional differences because some data sources might not be available in all the Amazon Web Services Regions where GuardDuty is presently supported. For more information, see <a href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.</p>', 'UpdateMemberDetectors' => '<p>Contains information on member accounts to be updated.</p> <p>Specifying both EKS Runtime Monitoring (<code>EKS_RUNTIME_MONITORING</code>) and Runtime Monitoring (<code>RUNTIME_MONITORING</code>) will cause an error. You can add only one of these two features because Runtime Monitoring already includes the threat detection for Amazon EKS resources. For more information, see <a href="https://docs.aws.amazon.com/guardduty/latest/ug/runtime-monitoring.html">Runtime Monitoring</a>.</p> <p>There might be regional differences because some data sources might not be available in all the Amazon Web Services Regions where GuardDuty is presently supported. For more information, see <a href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.</p>', 'UpdateOrganizationConfiguration' => '<p>Configures the delegated administrator account with the provided values. You must provide a value for either <code>autoEnableOrganizationMembers</code> or <code>autoEnable</code>, but not both. </p> <p>Specifying both EKS Runtime Monitoring (<code>EKS_RUNTIME_MONITORING</code>) and Runtime Monitoring (<code>RUNTIME_MONITORING</code>) will cause an error. You can add only one of these two features because Runtime Monitoring already includes the threat detection for Amazon EKS resources. For more information, see <a href="https://docs.aws.amazon.com/guardduty/latest/ug/runtime-monitoring.html">Runtime Monitoring</a>.</p> <p>There might be regional differences because some data sources might not be available in all the Amazon Web Services Regions where GuardDuty is presently supported. For more information, see <a href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.</p>', 'UpdatePublishingDestination' => '<p>Updates information about the publishing destination specified by the <code>destinationId</code>.</p>', 'UpdateThreatIntelSet' => '<p>Updates the ThreatIntelSet specified by the ThreatIntelSet ID.</p>', ], 'shapes' => [ 'AcceptAdministratorInvitationRequest' => [ 'base' => NULL, 'refs' => [], ], 'AcceptAdministratorInvitationResponse' => [ 'base' => NULL, 'refs' => [], ], 'AcceptInvitationRequest' => [ 'base' => NULL, 'refs' => [], ], 'AcceptInvitationResponse' => [ 'base' => NULL, 'refs' => [], ], 'AccessControlList' => [ 'base' => '<p>Contains information on the current access control policies for the bucket.</p>', 'refs' => [ 'BucketLevelPermissions$AccessControlList' => '<p>Contains information on how Access Control Policies are applied to the bucket.</p>', ], ], 'AccessDeniedException' => [ 'base' => '<p>An access denied exception object.</p>', 'refs' => [], ], 'AccessKeyDetails' => [ 'base' => '<p>Contains information about the access keys.</p>', 'refs' => [ 'Resource$AccessKeyDetails' => '<p>The IAM access key details (user information) of a user that engaged in the activity that prompted GuardDuty to generate a finding.</p>', ], ], 'AccountDetail' => [ 'base' => '<p>Contains information about the account.</p>', 'refs' => [ 'AccountDetails$member' => NULL, ], ], 'AccountDetails' => [ 'base' => NULL, 'refs' => [ 'CreateMembersRequest$AccountDetails' => '<p>A list of account ID and email address pairs of the accounts that you want to associate with the GuardDuty administrator account.</p>', ], ], 'AccountFreeTrialInfo' => [ 'base' => '<p>Provides details of the GuardDuty member account that uses a free trial service.</p>', 'refs' => [ 'AccountFreeTrialInfos$member' => NULL, ], ], 'AccountFreeTrialInfos' => [ 'base' => NULL, 'refs' => [ 'GetRemainingFreeTrialDaysResponse$Accounts' => '<p>The member accounts which were included in a request and were processed successfully.</p>', ], ], 'AccountId' => [ 'base' => NULL, 'refs' => [ 'AccountDetail$AccountId' => '<p>The member account ID.</p>', 'AccountIds$member' => NULL, 'Administrator$AccountId' => '<p>The ID of the account used as the administrator account.</p>', 'CoverageResource$AccountId' => '<p>The unique ID of the Amazon Web Services account.</p>', 'Invitation$AccountId' => '<p>The ID of the account that the invitation was sent from.</p>', 'Master$AccountId' => '<p>The ID of the account used as the administrator account.</p>', 'Member$AccountId' => '<p>The ID of the member account.</p>', 'MemberDataSourceConfiguration$AccountId' => '<p>The account ID for the member account.</p>', 'Scan$AccountId' => '<p>The ID for the account that belongs to the scan.</p>', 'UnprocessedAccount$AccountId' => '<p>The Amazon Web Services account ID.</p>', 'UsageAccountResult$AccountId' => '<p>The Account ID that generated usage.</p>', 'UsageTopAccountResult$AccountId' => '<p>The unique account ID.</p>', ], ], 'AccountIds' => [ 'base' => NULL, 'refs' => [ 'DeclineInvitationsRequest$AccountIds' => '<p>A list of account IDs of the Amazon Web Services accounts that sent invitations to the current member account that you want to decline invitations from.</p>', 'DeleteInvitationsRequest$AccountIds' => '<p>A list of account IDs of the Amazon Web Services accounts that sent invitations to the current member account that you want to delete invitations from.</p>', 'DeleteMembersRequest$AccountIds' => '<p>A list of account IDs of the GuardDuty member accounts that you want to delete.</p>', 'DisassociateMembersRequest$AccountIds' => '<p>A list of account IDs of the GuardDuty member accounts that you want to disassociate from the administrator account.</p>', 'GetMemberDetectorsRequest$AccountIds' => '<p>The account ID of the member account.</p>', 'GetMembersRequest$AccountIds' => '<p>A list of account IDs of the GuardDuty member accounts that you want to describe.</p>', 'GetRemainingFreeTrialDaysRequest$AccountIds' => '<p>A list of account identifiers of the GuardDuty member account.</p>', 'InviteMembersRequest$AccountIds' => '<p>A list of account IDs of the accounts that you want to invite to GuardDuty as members.</p>', 'StartMonitoringMembersRequest$AccountIds' => '<p>A list of account IDs of the GuardDuty member accounts to start monitoring.</p>', 'StopMonitoringMembersRequest$AccountIds' => '<p>A list of account IDs for the member accounts to stop monitoring.</p>', 'UpdateMemberDetectorsRequest$AccountIds' => '<p>A list of member account IDs to be updated.</p>', 'UsageCriteria$AccountIds' => '<p>The account IDs to aggregate usage statistics from.</p>', ], ], 'AccountLevelPermissions' => [ 'base' => '<p>Contains information about the account level permissions on the S3 bucket.</p>', 'refs' => [ 'PermissionConfiguration$AccountLevelPermissions' => '<p>Contains information about the account level permissions on the S3 bucket.</p>', ], ], 'Action' => [ 'base' => '<p>Contains information about actions.</p>', 'refs' => [ 'Service$Action' => '<p>Information about the activity that is described in a finding.</p>', ], ], 'AddonDetails' => [ 'base' => '<p>Information about the installed EKS add-on (GuardDuty security agent).</p>', 'refs' => [ 'CoverageEksClusterDetails$AddonDetails' => '<p>Information about the installed EKS add-on.</p>', ], ], 'AdminAccount' => [ 'base' => '<p>The account within the organization specified as the GuardDuty delegated administrator.</p>', 'refs' => [ 'AdminAccounts$member' => NULL, ], ], 'AdminAccounts' => [ 'base' => NULL, 'refs' => [ 'ListOrganizationAdminAccountsResponse$AdminAccounts' => '<p>A list of accounts configured as GuardDuty delegated administrators.</p>', ], ], 'AdminStatus' => [ 'base' => NULL, 'refs' => [ 'AdminAccount$AdminStatus' => '<p>Indicates whether the account is enabled as the delegated administrator.</p>', ], ], 'Administrator' => [ 'base' => '<p>Contains information about the administrator account and invitation.</p>', 'refs' => [ 'GetAdministratorAccountResponse$Administrator' => '<p>The administrator account details.</p>', ], ], 'AffectedResources' => [ 'base' => NULL, 'refs' => [ 'AwsApiCallAction$AffectedResources' => '<p>The details of the Amazon Web Services account that made the API call. This field identifies the resources that were affected by this API call.</p>', ], ], 'AgentDetails' => [ 'base' => '<p>Information about the installed GuardDuty security agent.</p>', 'refs' => [ 'CoverageEc2InstanceDetails$AgentDetails' => '<p>Information about the installed security agent.</p>', ], ], 'Anomaly' => [ 'base' => '<p>Contains information about the anomalies.</p>', 'refs' => [ 'Detection$Anomaly' => '<p>The details about the anomalous activity that caused GuardDuty to generate the finding.</p>', ], ], 'AnomalyObject' => [ 'base' => '<p>Contains information about the unusual anomalies.</p>', 'refs' => [ 'AnomalyProfileFeatureObjects$member' => NULL, 'AnomalyUnusualBehaviorFeature$value' => NULL, ], ], 'AnomalyProfileFeatureObjects' => [ 'base' => NULL, 'refs' => [ 'AnomalyProfileFeatures$value' => NULL, ], ], 'AnomalyProfileFeatures' => [ 'base' => NULL, 'refs' => [ 'AnomalyProfiles$value' => NULL, ], ], 'AnomalyProfiles' => [ 'base' => NULL, 'refs' => [ 'Anomaly$Profiles' => '<p>Information about the types of profiles.</p>', ], ], 'AnomalyUnusual' => [ 'base' => '<p>Contains information about the behavior of the anomaly that is new to GuardDuty.</p>', 'refs' => [ 'Anomaly$Unusual' => '<p>Information about the behavior of the anomalies.</p>', ], ], 'AnomalyUnusualBehaviorFeature' => [ 'base' => NULL, 'refs' => [ 'Behavior$value' => NULL, ], ], 'ArchiveFindingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ArchiveFindingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'AutoEnableMembers' => [ 'base' => NULL, 'refs' => [ 'DescribeOrganizationConfigurationResponse$AutoEnableOrganizationMembers' => '<p>Indicates the auto-enablement configuration of GuardDuty or any of the corresponding protection plans for the member accounts in the organization.</p> <ul> <li> <p> <code>NEW</code>: Indicates that when a new account joins the organization, they will have GuardDuty or any of the corresponding protection plans enabled automatically. </p> </li> <li> <p> <code>ALL</code>: Indicates that all accounts in the organization have GuardDuty and any of the corresponding protection plans enabled automatically. This includes <code>NEW</code> accounts that join the organization and accounts that may have been suspended or removed from the organization in GuardDuty.</p> </li> <li> <p> <code>NONE</code>: Indicates that GuardDuty or any of the corresponding protection plans will not be automatically enabled for any account in the organization. The administrator must manage GuardDuty for each account in the organization individually.</p> <p>When you update the auto-enable setting from <code>ALL</code> or <code>NEW</code> to <code>NONE</code>, this action doesn\'t disable the corresponding option for your existing accounts. This configuration will apply to the new accounts that join the organization. After you update the auto-enable settings, no new account will have the corresponding option as enabled.</p> </li> </ul>', 'UpdateOrganizationConfigurationRequest$AutoEnableOrganizationMembers' => '<p>Indicates the auto-enablement configuration of GuardDuty for the member accounts in the organization. You must provide a value for either <code>autoEnableOrganizationMembers</code> or <code>autoEnable</code>. </p> <p>Use one of the following configuration values for <code>autoEnableOrganizationMembers</code>:</p> <ul> <li> <p> <code>NEW</code>: Indicates that when a new account joins the organization, they will have GuardDuty enabled automatically. </p> </li> <li> <p> <code>ALL</code>: Indicates that all accounts in the organization have GuardDuty enabled automatically. This includes <code>NEW</code> accounts that join the organization and accounts that may have been suspended or removed from the organization in GuardDuty.</p> <p>It may take up to 24 hours to update the configuration for all the member accounts.</p> </li> <li> <p> <code>NONE</code>: Indicates that GuardDuty will not be automatically enabled for any account in the organization. The administrator must manage GuardDuty for each account in the organization individually.</p> <p>When you update the auto-enable setting from <code>ALL</code> or <code>NEW</code> to <code>NONE</code>, this action doesn\'t disable the corresponding option for your existing accounts. This configuration will apply to the new accounts that join the organization. After you update the auto-enable settings, no new account will have the corresponding option as enabled.</p> </li> </ul>', ], ], 'AwsApiCallAction' => [ 'base' => '<p>Contains information about the API action.</p>', 'refs' => [ 'Action$AwsApiCallAction' => '<p>Information about the AWS_API_CALL action described in this finding.</p>', ], ], 'BadRequestException' => [ 'base' => '<p>A bad request exception object.</p>', 'refs' => [], ], 'Behavior' => [ 'base' => NULL, 'refs' => [ 'AnomalyUnusual$Behavior' => '<p>The behavior of the anomalous activity that caused GuardDuty to generate the finding.</p>', ], ], 'BlockPublicAccess' => [ 'base' => '<p>Contains information on how the bucker owner\'s S3 Block Public Access settings are being applied to the S3 bucket. See <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html">S3 Block Public Access</a> for more information. </p>', 'refs' => [ 'AccountLevelPermissions$BlockPublicAccess' => '<p>Describes the S3 Block Public Access settings of the bucket\'s parent account.</p>', 'BucketLevelPermissions$BlockPublicAccess' => '<p>Contains information on which account level S3 Block Public Access settings are applied to the S3 bucket.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'AccessControlList$AllowsPublicReadAccess' => '<p>A value that indicates whether public read access for the bucket is enabled through an Access Control List (ACL).</p>', 'AccessControlList$AllowsPublicWriteAccess' => '<p>A value that indicates whether public write access for the bucket is enabled through an Access Control List (ACL).</p>', 'BlockPublicAccess$IgnorePublicAcls' => '<p>Indicates if S3 Block Public Access is set to <code>IgnorePublicAcls</code>.</p>', 'BlockPublicAccess$RestrictPublicBuckets' => '<p>Indicates if S3 Block Public Access is set to <code>RestrictPublicBuckets</code>.</p>', 'BlockPublicAccess$BlockPublicAcls' => '<p>Indicates if S3 Block Public Access is set to <code>BlockPublicAcls</code>.</p>', 'BlockPublicAccess$BlockPublicPolicy' => '<p>Indicates if S3 Block Public Access is set to <code>BlockPublicPolicy</code>.</p>', 'BucketPolicy$AllowsPublicReadAccess' => '<p>A value that indicates whether public read access for the bucket is enabled through a bucket policy.</p>', 'BucketPolicy$AllowsPublicWriteAccess' => '<p>A value that indicates whether public write access for the bucket is enabled through a bucket policy.</p>', 'CreateDetectorRequest$Enable' => '<p>A Boolean value that specifies whether the detector is to be enabled.</p>', 'CreateIPSetRequest$Activate' => '<p>A Boolean value that indicates whether GuardDuty is to start using the uploaded IPSet.</p>', 'CreateThreatIntelSetRequest$Activate' => '<p>A Boolean value that indicates whether GuardDuty is to start using the uploaded ThreatIntelSet.</p>', 'DescribeOrganizationConfigurationResponse$AutoEnable' => '<p>Indicates whether GuardDuty is automatically enabled for accounts added to the organization.</p> <p>Even though this is still supported, we recommend using <code>AutoEnableOrganizationMembers</code> to achieve the similar results.</p>', 'DescribeOrganizationConfigurationResponse$MemberAccountLimitReached' => '<p>Indicates whether the maximum number of allowed member accounts are already associated with the delegated administrator account for your organization.</p>', 'DnsRequestAction$Blocked' => '<p>Indicates whether the targeted port is blocked.</p>', 'InviteMembersRequest$DisableEmailNotification' => '<p>A Boolean value that specifies whether you want to disable email notification to the accounts that you are inviting to GuardDuty as members.</p>', 'KubernetesAuditLogsConfiguration$Enable' => '<p>The status of Kubernetes audit logs as a data source.</p>', 'KubernetesPermissionCheckedDetails$Allowed' => '<p>Information whether the user has the permission to call the Kubernetes API.</p>', 'KubernetesWorkloadDetails$HostNetwork' => '<p>Whether the hostNetwork flag is enabled for the pods included in the workload.</p>', 'KubernetesWorkloadDetails$HostIPC' => '<p>Whether the host IPC flag is enabled for the pods in the workload.</p>', 'KubernetesWorkloadDetails$HostPID' => '<p>Whether the host PID flag is enabled for the pods in the workload. </p>', 'NetworkConnectionAction$Blocked' => '<p>Indicates whether EC2 blocked the network connection to your instance.</p>', 'OrganizationEbsVolumes$AutoEnable' => '<p>Whether scanning EBS volumes should be auto-enabled for new members joining the organization.</p>', 'OrganizationEbsVolumesResult$AutoEnable' => '<p>An object that contains the status of whether scanning EBS volumes should be auto-enabled for new members joining the organization.</p>', 'OrganizationKubernetesAuditLogsConfiguration$AutoEnable' => '<p>A value that contains information on whether Kubernetes audit logs should be enabled automatically as a data source for the organization.</p>', 'OrganizationKubernetesAuditLogsConfigurationResult$AutoEnable' => '<p>Whether Kubernetes audit logs data source should be auto-enabled for new members joining the organization.</p>', 'OrganizationS3LogsConfiguration$AutoEnable' => '<p>A value that contains information on whether S3 data event logs will be enabled automatically as a data source for the organization.</p>', 'OrganizationS3LogsConfigurationResult$AutoEnable' => '<p>A value that describes whether S3 data event logs are automatically enabled for new members of the organization.</p>', 'PortProbeAction$Blocked' => '<p>Indicates whether EC2 blocked the port probe to the instance, such as with an ACL.</p>', 'RemoteAccountDetails$Affiliated' => '<p>Details on whether the Amazon Web Services account of the remote API caller is related to your GuardDuty environment. If this value is <code>True</code> the API caller is affiliated to your account in some way. If it is <code>False</code> the API caller is from outside your environment.</p>', 'S3LogsConfiguration$Enable' => '<p> The status of S3 data event logs as a data source.</p>', 'ScanEc2InstanceWithFindings$EbsVolumes' => '<p>Describes the configuration for scanning EBS volumes as data source.</p>', 'SecurityContext$Privileged' => '<p>Whether the container is privileged.</p>', 'SecurityContext$AllowPrivilegeEscalation' => '<p>Whether or not a container or a Kubernetes pod is allowed to gain more privileges than its parent process.</p>', 'Service$Archived' => '<p>Indicates whether this finding is archived.</p>', 'ThreatDetectedByName$Shortened' => '<p>Flag to determine if the finding contains every single infected file-path and/or every threat.</p>', 'UpdateDetectorRequest$Enable' => '<p>Specifies whether the detector is enabled or not enabled.</p>', 'UpdateIPSetRequest$Activate' => '<p>The updated Boolean value that specifies whether the IPSet is active or not.</p>', 'UpdateOrganizationConfigurationRequest$AutoEnable' => '<p>Represents whether or not to automatically enable member accounts in the organization.</p> <p>Even though this is still supported, we recommend using <code>AutoEnableOrganizationMembers</code> to achieve the similar results. You must provide a value for either <code>autoEnableOrganizationMembers</code> or <code>autoEnable</code>.</p>', 'UpdateThreatIntelSetRequest$Activate' => '<p>The updated Boolean value that specifies whether the ThreateIntelSet is active or not.</p>', ], ], 'BucketLevelPermissions' => [ 'base' => '<p>Contains information about the bucket level permissions for the S3 bucket.</p>', 'refs' => [ 'PermissionConfiguration$BucketLevelPermissions' => '<p>Contains information about the bucket level permissions for the S3 bucket.</p>', ], ], 'BucketPolicy' => [ 'base' => '<p>Contains information on the current bucket policies for the S3 bucket.</p>', 'refs' => [ 'BucketLevelPermissions$BucketPolicy' => '<p>Contains information on the bucket policies for the S3 bucket.</p>', ], ], 'City' => [ 'base' => '<p>Contains information about the city associated with the IP address.</p>', 'refs' => [ 'RemoteIpDetails$City' => '<p>The city information of the remote IP address.</p>', ], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'CreateDetectorRequest$ClientToken' => '<p>The idempotency token for the create request.</p>', 'CreateFilterRequest$ClientToken' => '<p>The idempotency token for the create request.</p>', 'CreateIPSetRequest$ClientToken' => '<p>The idempotency token for the create request.</p>', 'CreateMalwareProtectionPlanRequest$ClientToken' => '<p>The idempotency token for the create request.</p>', 'CreatePublishingDestinationRequest$ClientToken' => '<p>The idempotency token for the request.</p>', 'CreateThreatIntelSetRequest$ClientToken' => '<p>The idempotency token for the create request.</p>', ], ], 'CloudTrailConfigurationResult' => [ 'base' => '<p>Contains information on the status of CloudTrail as a data source for the detector.</p>', 'refs' => [ 'DataSourceConfigurationsResult$CloudTrail' => '<p>An object that contains information on the status of CloudTrail as a data source.</p>', ], ], 'Condition' => [ 'base' => '<p>Contains information about the condition.</p>', 'refs' => [ 'Criterion$value' => NULL, ], ], 'ConflictException' => [ 'base' => '<p>A request conflict exception object.</p>', 'refs' => [], ], 'Container' => [ 'base' => '<p>Details of a container.</p>', 'refs' => [ 'Containers$member' => NULL, 'Resource$ContainerDetails' => NULL, ], ], 'ContainerInstanceDetails' => [ 'base' => '<p>Contains information about the Amazon EC2 instance that is running the Amazon ECS container.</p>', 'refs' => [ 'CoverageEcsClusterDetails$ContainerInstanceDetails' => '<p>Information about the Amazon ECS container running on Amazon EC2 instance.</p>', ], ], 'Containers' => [ 'base' => NULL, 'refs' => [ 'EcsTaskDetails$Containers' => '<p>The containers that\'s associated with the task.</p>', 'KubernetesWorkloadDetails$Containers' => '<p>Containers running as part of the Kubernetes workload.</p>', ], ], 'CountByCoverageStatus' => [ 'base' => NULL, 'refs' => [ 'CoverageStatistics$CountByCoverageStatus' => '<p>Represents coverage statistics for EKS clusters aggregated by coverage status.</p>', ], ], 'CountByResourceType' => [ 'base' => NULL, 'refs' => [ 'CoverageStatistics$CountByResourceType' => '<p>Represents coverage statistics for EKS clusters aggregated by resource type.</p>', ], ], 'CountBySeverity' => [ 'base' => NULL, 'refs' => [ 'FindingStatistics$CountBySeverity' => '<p>Represents a map of severity to count statistics for a set of findings.</p>', ], ], 'Country' => [ 'base' => '<p>Contains information about the country where the remote IP address is located.</p>', 'refs' => [ 'RemoteIpDetails$Country' => '<p>The country code of the remote IP address.</p>', ], ], 'CoverageEc2InstanceDetails' => [ 'base' => '<p>Contains information about the Amazon EC2 instance runtime coverage details.</p>', 'refs' => [ 'CoverageResourceDetails$Ec2InstanceDetails' => '<p>Information about the Amazon EC2 instance assessed for runtime coverage.</p>', ], ], 'CoverageEcsClusterDetails' => [ 'base' => '<p>Contains information about Amazon ECS cluster runtime coverage details.</p>', 'refs' => [ 'CoverageResourceDetails$EcsClusterDetails' => '<p>Information about the Amazon ECS cluster that is assessed for runtime coverage.</p>', ], ], 'CoverageEksClusterDetails' => [ 'base' => '<p>Information about the EKS cluster that has a coverage status.</p>', 'refs' => [ 'CoverageResourceDetails$EksClusterDetails' => '<p>EKS cluster details involved in the coverage statistics.</p>', ], ], 'CoverageFilterCondition' => [ 'base' => '<p>Represents a condition that when matched will be added to the response of the operation.</p>', 'refs' => [ 'CoverageFilterCriterion$FilterCondition' => '<p>Contains information about the condition.</p>', ], ], 'CoverageFilterCriteria' => [ 'base' => '<p>Represents the criteria used in the filter.</p>', 'refs' => [ 'GetCoverageStatisticsRequest$FilterCriteria' => '<p>Represents the criteria used to filter the coverage statistics</p>', 'ListCoverageRequest$FilterCriteria' => '<p>Represents the criteria used to filter the coverage details.</p>', ], ], 'CoverageFilterCriterion' => [ 'base' => '<p>Represents a condition that when matched will be added to the response of the operation.</p>', 'refs' => [ 'CoverageFilterCriterionList$member' => NULL, ], ], 'CoverageFilterCriterionKey' => [ 'base' => NULL, 'refs' => [ 'CoverageFilterCriterion$CriterionKey' => '<p>An enum value representing possible filter fields.</p> <note> <p>Replace the enum value <code>CLUSTER_NAME</code> with <code>EKS_CLUSTER_NAME</code>. <code>CLUSTER_NAME</code> has been deprecated.</p> </note>', ], ], 'CoverageFilterCriterionList' => [ 'base' => NULL, 'refs' => [ 'CoverageFilterCriteria$FilterCriterion' => '<p>Represents a condition that when matched will be added to the response of the operation.</p>', ], ], 'CoverageResource' => [ 'base' => '<p>Information about the resource of the GuardDuty account.</p>', 'refs' => [ 'CoverageResources$member' => NULL, ], ], 'CoverageResourceDetails' => [ 'base' => '<p>Information about the resource for each individual EKS cluster.</p>', 'refs' => [ 'CoverageResource$ResourceDetails' => '<p>Information about the resource for which the coverage statistics are retrieved.</p>', ], ], 'CoverageResources' => [ 'base' => NULL, 'refs' => [ 'ListCoverageResponse$Resources' => '<p>A list of resources and their attributes providing cluster details.</p>', ], ], 'CoverageSortCriteria' => [ 'base' => '<p>Information about the sorting criteria used in the coverage statistics.</p>', 'refs' => [ 'ListCoverageRequest$SortCriteria' => '<p>Represents the criteria used to sort the coverage details.</p>', ], ], 'CoverageSortKey' => [ 'base' => NULL, 'refs' => [ 'CoverageSortCriteria$AttributeName' => '<p>Represents the field name used to sort the coverage details.</p> <note> <p>Replace the enum value <code>CLUSTER_NAME</code> with <code>EKS_CLUSTER_NAME</code>. <code>CLUSTER_NAME</code> has been deprecated.</p> </note>', ], ], 'CoverageStatistics' => [ 'base' => '<p>Information about the coverage statistics for a resource.</p>', 'refs' => [ 'GetCoverageStatisticsResponse$CoverageStatistics' => '<p>Represents the count aggregated by the <code>statusCode</code> and <code>resourceType</code>.</p>', ], ], 'CoverageStatisticsType' => [ 'base' => NULL, 'refs' => [ 'CoverageStatisticsTypeList$member' => NULL, ], ], 'CoverageStatisticsTypeList' => [ 'base' => NULL, 'refs' => [ 'GetCoverageStatisticsRequest$StatisticsType' => '<p>Represents the statistics type used to aggregate the coverage details.</p>', ], ], 'CoverageStatus' => [ 'base' => NULL, 'refs' => [ 'CountByCoverageStatus$key' => NULL, 'CoverageResource$CoverageStatus' => '<p>Represents the status of the EKS cluster coverage.</p>', ], ], 'CreateDetectorRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDetectorResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateFilterRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateFilterResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateIPSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateIPSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateMalwareProtectionPlanRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateMalwareProtectionPlanResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateMembersRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateMembersResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateProtectedResource' => [ 'base' => '<p>Information about the protected resource that is associated with the created Malware Protection plan. Presently, <code>S3Bucket</code> is the only supported protected resource.</p>', 'refs' => [ 'CreateMalwareProtectionPlanRequest$ProtectedResource' => '<p>Information about the protected resource that is associated with the created Malware Protection plan. Presently, <code>S3Bucket</code> is the only supported protected resource.</p>', 'GetMalwareProtectionPlanResponse$ProtectedResource' => '<p>Information about the protected resource that is associated with the created Malware Protection plan. Presently, <code>S3Bucket</code> is the only supported protected resource.</p>', ], ], 'CreatePublishingDestinationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreatePublishingDestinationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateS3BucketResource' => [ 'base' => '<p>Information about the protected S3 bucket resource.</p>', 'refs' => [ 'CreateProtectedResource$S3Bucket' => '<p>Information about the protected S3 bucket resource.</p>', ], ], 'CreateSampleFindingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSampleFindingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateThreatIntelSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateThreatIntelSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'Criterion' => [ 'base' => NULL, 'refs' => [ 'FindingCriteria$Criterion' => '<p>Represents a map of finding properties that match specified conditions and values when querying findings.</p>', ], ], 'CriterionKey' => [ 'base' => NULL, 'refs' => [ 'FilterCriterion$CriterionKey' => '<p>An enum value representing possible scan properties to match with given scan entries.</p> <note> <p>Replace the enum value <code>CLUSTER_NAME</code> with <code>EKS_CLUSTER_NAME</code>. <code>CLUSTER_NAME</code> has been deprecated.</p> </note>', ], ], 'DNSLogsConfigurationResult' => [ 'base' => '<p>Contains information on the status of DNS logs as a data source.</p>', 'refs' => [ 'DataSourceConfigurationsResult$DNSLogs' => '<p>An object that contains information on the status of DNS logs as a data source.</p>', ], ], 'DataSource' => [ 'base' => NULL, 'refs' => [ 'DataSourceList$member' => NULL, 'UsageDataSourceResult$DataSource' => '<p>The data source type that generated usage.</p>', ], ], 'DataSourceConfigurations' => [ 'base' => '<p>Contains information about which data sources are enabled.</p>', 'refs' => [ 'CreateDetectorRequest$DataSources' => '<p>Describes which data sources will be enabled for the detector.</p> <p>There might be regional differences because some data sources might not be available in all the Amazon Web Services Regions where GuardDuty is presently supported. For more information, see <a href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.</p>', 'UpdateDetectorRequest$DataSources' => '<p>Describes which data sources will be updated.</p> <p>There might be regional differences because some data sources might not be available in all the Amazon Web Services Regions where GuardDuty is presently supported. For more information, see <a href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.</p>', 'UpdateMemberDetectorsRequest$DataSources' => '<p>Describes which data sources will be updated.</p>', ], ], 'DataSourceConfigurationsResult' => [ 'base' => '<p>Contains information on the status of data sources for the detector.</p>', 'refs' => [ 'GetDetectorResponse$DataSources' => '<p>Describes which data sources are enabled for the detector.</p>', 'MemberDataSourceConfiguration$DataSources' => '<p>Contains information on the status of data sources for the account.</p>', ], ], 'DataSourceFreeTrial' => [ 'base' => '<p>Contains information about which data sources are enabled for the GuardDuty member account.</p>', 'refs' => [ 'DataSourcesFreeTrial$CloudTrail' => '<p>Describes whether any Amazon Web Services CloudTrail management event logs are enabled as data sources.</p>', 'DataSourcesFreeTrial$DnsLogs' => '<p>Describes whether any DNS logs are enabled as data sources.</p>', 'DataSourcesFreeTrial$FlowLogs' => '<p>Describes whether any VPC Flow logs are enabled as data sources.</p>', 'DataSourcesFreeTrial$S3Logs' => '<p>Describes whether any S3 data event logs are enabled as data sources.</p>', 'KubernetesDataSourceFreeTrial$AuditLogs' => '<p>Describes whether Kubernetes audit logs are enabled as a data source.</p>', 'MalwareProtectionDataSourceFreeTrial$ScanEc2InstanceWithFindings' => '<p>Describes whether Malware Protection for EC2 instances with findings is enabled as a data source.</p>', ], ], 'DataSourceList' => [ 'base' => NULL, 'refs' => [ 'UsageCriteria$DataSources' => '<p>The data sources to aggregate usage statistics from.</p>', ], ], 'DataSourceStatus' => [ 'base' => NULL, 'refs' => [ 'CloudTrailConfigurationResult$Status' => '<p>Describes whether CloudTrail is enabled as a data source for the detector.</p>', 'DNSLogsConfigurationResult$Status' => '<p>Denotes whether DNS logs is enabled as a data source.</p>', 'EbsVolumesResult$Status' => '<p>Describes whether scanning EBS volumes is enabled as a data source.</p>', 'FlowLogsConfigurationResult$Status' => '<p>Denotes whether VPC flow logs is enabled as a data source.</p>', 'KubernetesAuditLogsConfigurationResult$Status' => '<p>A value that describes whether Kubernetes audit logs are enabled as a data source.</p>', 'S3LogsConfigurationResult$Status' => '<p>A value that describes whether S3 data event logs are automatically enabled for new members of the organization.</p>', ], ], 'DataSourcesFreeTrial' => [ 'base' => '<p>Contains information about which data sources are enabled for the GuardDuty member account.</p>', 'refs' => [ 'AccountFreeTrialInfo$DataSources' => '<p>Describes the data source enabled for the GuardDuty member account.</p>', ], ], 'DeclineInvitationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeclineInvitationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DefaultServerSideEncryption' => [ 'base' => '<p>Contains information on the server side encryption method used in the S3 bucket. See <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/serv-side-encryption.html">S3 Server-Side Encryption</a> for more information.</p>', 'refs' => [ 'S3BucketDetail$DefaultServerSideEncryption' => '<p>Describes the server side encryption method used in the S3 bucket.</p>', ], ], 'DeleteDetectorRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDetectorResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFilterRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFilterResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteIPSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteIPSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteInvitationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteInvitationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMalwareProtectionPlanRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMembersRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMembersResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeletePublishingDestinationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePublishingDestinationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteThreatIntelSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteThreatIntelSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMalwareScansRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMalwareScansResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeOrganizationConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeOrganizationConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribePublishingDestinationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePublishingDestinationResponse' => [ 'base' => NULL, 'refs' => [], ], 'Destination' => [ 'base' => '<p>Contains information about the publishing destination, including the ID, type, and status.</p>', 'refs' => [ 'Destinations$member' => NULL, ], ], 'DestinationProperties' => [ 'base' => '<p>Contains the Amazon Resource Name (ARN) of the resource to publish to, such as an S3 bucket, and the ARN of the KMS key to use to encrypt published findings.</p>', 'refs' => [ 'CreatePublishingDestinationRequest$DestinationProperties' => '<p>The properties of the publishing destination, including the ARNs for the destination and the KMS key used for encryption.</p>', 'DescribePublishingDestinationResponse$DestinationProperties' => '<p>A <code>DestinationProperties</code> object that includes the <code>DestinationArn</code> and <code>KmsKeyArn</code> of the publishing destination.</p>', 'UpdatePublishingDestinationRequest$DestinationProperties' => '<p>A <code>DestinationProperties</code> object that includes the <code>DestinationArn</code> and <code>KmsKeyArn</code> of the publishing destination.</p>', ], ], 'DestinationType' => [ 'base' => NULL, 'refs' => [ 'CreatePublishingDestinationRequest$DestinationType' => '<p>The type of resource for the publishing destination. Currently only Amazon S3 buckets are supported.</p>', 'DescribePublishingDestinationResponse$DestinationType' => '<p>The type of publishing destination. Currently, only Amazon S3 buckets are supported.</p>', 'Destination$DestinationType' => '<p>The type of resource used for the publishing destination. Currently, only Amazon S3 buckets are supported.</p>', ], ], 'Destinations' => [ 'base' => NULL, 'refs' => [ 'ListPublishingDestinationsResponse$Destinations' => '<p>A <code>Destinations</code> object that includes information about each publishing destination returned.</p>', ], ], 'Detection' => [ 'base' => '<p>Contains information about the detected behavior.</p>', 'refs' => [ 'Service$Detection' => '<p>Contains information about the detected unusual behavior.</p>', ], ], 'DetectorAdditionalConfiguration' => [ 'base' => '<p>Information about the additional configuration for a feature in your GuardDuty account.</p>', 'refs' => [ 'DetectorAdditionalConfigurations$member' => NULL, ], ], 'DetectorAdditionalConfigurationResult' => [ 'base' => '<p>Information about the additional configuration.</p>', 'refs' => [ 'DetectorAdditionalConfigurationResults$member' => NULL, ], ], 'DetectorAdditionalConfigurationResults' => [ 'base' => NULL, 'refs' => [ 'DetectorFeatureConfigurationResult$AdditionalConfiguration' => '<p>Additional configuration for a resource.</p>', ], ], 'DetectorAdditionalConfigurations' => [ 'base' => NULL, 'refs' => [ 'DetectorFeatureConfiguration$AdditionalConfiguration' => '<p>Additional configuration for a resource.</p>', ], ], 'DetectorFeature' => [ 'base' => NULL, 'refs' => [ 'DetectorFeatureConfiguration$Name' => '<p>The name of the feature.</p>', ], ], 'DetectorFeatureConfiguration' => [ 'base' => '<p>Contains information about a GuardDuty feature.</p> <p>Specifying both EKS Runtime Monitoring (<code>EKS_RUNTIME_MONITORING</code>) and Runtime Monitoring (<code>RUNTIME_MONITORING</code>) will cause an error. You can add only one of these two features because Runtime Monitoring already includes the threat detection for Amazon EKS resources. For more information, see <a href="https://docs.aws.amazon.com/guardduty/latest/ug/runtime-monitoring.html">Runtime Monitoring</a>.</p>', 'refs' => [ 'DetectorFeatureConfigurations$member' => NULL, ], ], 'DetectorFeatureConfigurationResult' => [ 'base' => '<p>Contains information about a GuardDuty feature.</p> <p>Specifying both EKS Runtime Monitoring (<code>EKS_RUNTIME_MONITORING</code>) and Runtime Monitoring (<code>RUNTIME_MONITORING</code>) will cause an error. You can add only one of these two features because Runtime Monitoring already includes the threat detection for Amazon EKS resources. For more information, see <a href="https://docs.aws.amazon.com/guardduty/latest/ug/runtime-monitoring.html">Runtime Monitoring</a>.</p>', 'refs' => [ 'DetectorFeatureConfigurationsResults$member' => NULL, ], ], 'DetectorFeatureConfigurations' => [ 'base' => NULL, 'refs' => [ 'CreateDetectorRequest$Features' => '<p>A list of features that will be configured for the detector.</p>', 'UpdateDetectorRequest$Features' => '<p>Provides the features that will be updated for the detector.</p>', ], ], 'DetectorFeatureConfigurationsResults' => [ 'base' => NULL, 'refs' => [ 'GetDetectorResponse$Features' => '<p>Describes the features that have been enabled for the detector.</p>', ], ], 'DetectorFeatureResult' => [ 'base' => NULL, 'refs' => [ 'DetectorFeatureConfigurationResult$Name' => '<p>Indicates the name of the feature that can be enabled for the detector.</p>', ], ], 'DetectorId' => [ 'base' => NULL, 'refs' => [ 'AcceptAdministratorInvitationRequest$DetectorId' => '<p>The unique ID of the detector of the GuardDuty member account.</p>', 'AcceptInvitationRequest$DetectorId' => '<p>The unique ID of the detector of the GuardDuty member account.</p>', 'ArchiveFindingsRequest$DetectorId' => '<p>The ID of the detector that specifies the GuardDuty service whose findings you want to archive.</p>', 'CoverageResource$DetectorId' => '<p>The unique ID of the GuardDuty detector associated with the resource.</p>', 'CreateDetectorResponse$DetectorId' => '<p>The unique ID of the created detector.</p>', 'CreateFilterRequest$DetectorId' => '<p>The ID of the detector belonging to the GuardDuty account that you want to create a filter for.</p>', 'CreateIPSetRequest$DetectorId' => '<p>The unique ID of the detector of the GuardDuty account that you want to create an IPSet for.</p>', 'CreateMembersRequest$DetectorId' => '<p>The unique ID of the detector of the GuardDuty account that you want to associate member accounts with.</p>', 'CreatePublishingDestinationRequest$DetectorId' => '<p>The ID of the GuardDuty detector associated with the publishing destination.</p>', 'CreateSampleFindingsRequest$DetectorId' => '<p>The ID of the detector to create sample findings for.</p>', 'CreateThreatIntelSetRequest$DetectorId' => '<p>The unique ID of the detector of the GuardDuty account that you want to create a threatIntelSet for.</p>', 'DeleteDetectorRequest$DetectorId' => '<p>The unique ID of the detector that you want to delete.</p>', 'DeleteFilterRequest$DetectorId' => '<p>The unique ID of the detector that the filter is associated with.</p>', 'DeleteIPSetRequest$DetectorId' => '<p>The unique ID of the detector associated with the IPSet.</p>', 'DeleteMembersRequest$DetectorId' => '<p>The unique ID of the detector of the GuardDuty account whose members you want to delete.</p>', 'DeletePublishingDestinationRequest$DetectorId' => '<p>The unique ID of the detector associated with the publishing destination to delete.</p>', 'DeleteThreatIntelSetRequest$DetectorId' => '<p>The unique ID of the detector that the threatIntelSet is associated with.</p>', 'DescribeMalwareScansRequest$DetectorId' => '<p>The unique ID of the detector that the request is associated with.</p>', 'DescribeOrganizationConfigurationRequest$DetectorId' => '<p>The ID of the detector to retrieve information about the delegated administrator from.</p>', 'DescribePublishingDestinationRequest$DetectorId' => '<p>The unique ID of the detector associated with the publishing destination to retrieve.</p>', 'DetectorIds$member' => NULL, 'DisassociateFromAdministratorAccountRequest$DetectorId' => '<p>The unique ID of the detector of the GuardDuty member account.</p>', 'DisassociateFromMasterAccountRequest$DetectorId' => '<p>The unique ID of the detector of the GuardDuty member account.</p>', 'DisassociateMembersRequest$DetectorId' => '<p>The unique ID of the detector of the GuardDuty account whose members you want to disassociate from the administrator account.</p>', 'GetAdministratorAccountRequest$DetectorId' => '<p>The unique ID of the detector of the GuardDuty member account.</p>', 'GetCoverageStatisticsRequest$DetectorId' => '<p>The unique ID of the GuardDuty detector associated to the coverage statistics.</p>', 'GetDetectorRequest$DetectorId' => '<p>The unique ID of the detector that you want to get.</p>', 'GetFilterRequest$DetectorId' => '<p>The unique ID of the detector that the filter is associated with.</p>', 'GetFindingsRequest$DetectorId' => '<p>The ID of the detector that specifies the GuardDuty service whose findings you want to retrieve.</p>', 'GetFindingsStatisticsRequest$DetectorId' => '<p>The ID of the detector that specifies the GuardDuty service whose findings\' statistics you want to retrieve.</p>', 'GetIPSetRequest$DetectorId' => '<p>The unique ID of the detector that the IPSet is associated with.</p>', 'GetMalwareScanSettingsRequest$DetectorId' => '<p>The unique ID of the detector that the scan setting is associated with.</p>', 'GetMasterAccountRequest$DetectorId' => '<p>The unique ID of the detector of the GuardDuty member account.</p>', 'GetMemberDetectorsRequest$DetectorId' => '<p>The detector ID for the administrator account.</p>', 'GetMembersRequest$DetectorId' => '<p>The unique ID of the detector of the GuardDuty account whose members you want to retrieve.</p>', 'GetRemainingFreeTrialDaysRequest$DetectorId' => '<p>The unique ID of the detector of the GuardDuty member account.</p>', 'GetThreatIntelSetRequest$DetectorId' => '<p>The unique ID of the detector that the threatIntelSet is associated with.</p>', 'GetUsageStatisticsRequest$DetectorId' => '<p>The ID of the detector that specifies the GuardDuty service whose usage statistics you want to retrieve.</p>', 'InviteMembersRequest$DetectorId' => '<p>The unique ID of the detector of the GuardDuty account that you want to invite members with.</p>', 'ListCoverageRequest$DetectorId' => '<p>The unique ID of the detector whose coverage details you want to retrieve.</p>', 'ListFiltersRequest$DetectorId' => '<p>The unique ID of the detector that the filter is associated with.</p>', 'ListFindingsRequest$DetectorId' => '<p>The ID of the detector that specifies the GuardDuty service whose findings you want to list.</p>', 'ListIPSetsRequest$DetectorId' => '<p>The unique ID of the detector that the IPSet is associated with.</p>', 'ListMembersRequest$DetectorId' => '<p>The unique ID of the detector the member is associated with.</p>', 'ListPublishingDestinationsRequest$DetectorId' => '<p>The ID of the detector to retrieve publishing destinations for.</p>', 'ListThreatIntelSetsRequest$DetectorId' => '<p>The unique ID of the detector that the threatIntelSet is associated with.</p>', 'Member$DetectorId' => '<p>The detector ID of the member account.</p>', 'Scan$DetectorId' => '<p>The unique ID of the detector that the request is associated with.</p>', 'Scan$AdminDetectorId' => '<p>The unique detector ID of the administrator account that the request is associated with. Note that this value will be the same as the one used for <code>DetectorId</code> if the account is an administrator.</p>', 'Service$DetectorId' => '<p>The detector ID for the GuardDuty service.</p>', 'StartMonitoringMembersRequest$DetectorId' => '<p>The unique ID of the detector of the GuardDuty administrator account associated with the member accounts to monitor.</p>', 'StopMonitoringMembersRequest$DetectorId' => '<p>The unique ID of the detector associated with the GuardDuty administrator account that is monitoring member accounts.</p>', 'UnarchiveFindingsRequest$DetectorId' => '<p>The ID of the detector associated with the findings to unarchive.</p>', 'UpdateDetectorRequest$DetectorId' => '<p>The unique ID of the detector to update.</p>', 'UpdateFilterRequest$DetectorId' => '<p>The unique ID of the detector that specifies the GuardDuty service where you want to update a filter.</p>', 'UpdateFindingsFeedbackRequest$DetectorId' => '<p>The ID of the detector associated with the findings to update feedback for.</p>', 'UpdateIPSetRequest$DetectorId' => '<p>The detectorID that specifies the GuardDuty service whose IPSet you want to update.</p>', 'UpdateMalwareScanSettingsRequest$DetectorId' => '<p>The unique ID of the detector that specifies the GuardDuty service where you want to update scan settings.</p>', 'UpdateMemberDetectorsRequest$DetectorId' => '<p>The detector ID of the administrator account.</p>', 'UpdateOrganizationConfigurationRequest$DetectorId' => '<p>The ID of the detector that configures the delegated administrator.</p>', 'UpdatePublishingDestinationRequest$DetectorId' => '<p>The ID of the detector associated with the publishing destinations to update.</p>', 'UpdateThreatIntelSetRequest$DetectorId' => '<p>The detectorID that specifies the GuardDuty service whose ThreatIntelSet you want to update.</p>', ], ], 'DetectorIds' => [ 'base' => NULL, 'refs' => [ 'ListDetectorsResponse$DetectorIds' => '<p>A list of detector IDs.</p>', ], ], 'DetectorStatus' => [ 'base' => NULL, 'refs' => [ 'GetDetectorResponse$Status' => '<p>The detector status.</p>', ], ], 'DisableOrganizationAdminAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisableOrganizationAdminAccountResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateFromAdministratorAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateFromAdministratorAccountResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateFromMasterAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateFromMasterAccountResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateMembersRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateMembersResponse' => [ 'base' => NULL, 'refs' => [], ], 'DnsRequestAction' => [ 'base' => '<p>Contains information about the DNS_REQUEST action described in this finding.</p>', 'refs' => [ 'Action$DnsRequestAction' => '<p>Information about the DNS_REQUEST action described in this finding.</p>', ], ], 'DomainDetails' => [ 'base' => '<p>Contains information about the domain.</p>', 'refs' => [ 'AwsApiCallAction$DomainDetails' => '<p>The domain information for the Amazon Web Services API call.</p>', ], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'Finding$Confidence' => '<p>The confidence score for the finding.</p>', 'Finding$Severity' => '<p>The severity of the finding.</p>', 'GeoLocation$Lat' => '<p>The latitude information of the remote IP address.</p>', 'GeoLocation$Lon' => '<p>The longitude information of the remote IP address.</p>', ], ], 'EbsSnapshotPreservation' => [ 'base' => NULL, 'refs' => [ 'GetMalwareScanSettingsResponse$EbsSnapshotPreservation' => '<p>An enum value representing possible snapshot preservation settings.</p>', 'UpdateMalwareScanSettingsRequest$EbsSnapshotPreservation' => '<p>An enum value representing possible snapshot preservation settings.</p>', ], ], 'EbsVolumeDetails' => [ 'base' => '<p>Contains list of scanned and skipped EBS volumes with details.</p>', 'refs' => [ 'Resource$EbsVolumeDetails' => '<p>Contains list of scanned and skipped EBS volumes with details.</p>', ], ], 'EbsVolumeScanDetails' => [ 'base' => '<p>Contains details from the malware scan that created a finding.</p>', 'refs' => [ 'Service$EbsVolumeScanDetails' => '<p>Returns details from the malware scan that created a finding.</p>', ], ], 'EbsVolumesResult' => [ 'base' => '<p>Describes the configuration of scanning EBS volumes as a data source.</p>', 'refs' => [ 'ScanEc2InstanceWithFindingsResult$EbsVolumes' => '<p>Describes the configuration of scanning EBS volumes as a data source.</p>', ], ], 'EcsClusterDetails' => [ 'base' => '<p>Contains information about the details of the ECS Cluster.</p>', 'refs' => [ 'Resource$EcsClusterDetails' => '<p>Contains information about the details of the ECS Cluster.</p>', ], ], 'EcsTaskDetails' => [ 'base' => '<p>Contains information about the task in an ECS cluster.</p>', 'refs' => [ 'EcsClusterDetails$TaskDetails' => '<p>Contains information about the details of the ECS Task.</p>', ], ], 'EksClusterDetails' => [ 'base' => '<p>Details about the EKS cluster involved in a Kubernetes finding.</p>', 'refs' => [ 'Resource$EksClusterDetails' => '<p>Details about the EKS cluster involved in a Kubernetes finding.</p>', ], ], 'Email' => [ 'base' => NULL, 'refs' => [ 'AccountDetail$Email' => '<p>The email address of the member account.</p>', 'Member$Email' => '<p>The email address of the member account.</p>', ], ], 'EnableOrganizationAdminAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'EnableOrganizationAdminAccountResponse' => [ 'base' => NULL, 'refs' => [], ], 'Eq' => [ 'base' => NULL, 'refs' => [ 'Condition$Eq' => '<p>Represents the <i>equal</i> condition to be applied to a single field when querying for findings.</p>', ], ], 'Equals' => [ 'base' => NULL, 'refs' => [ 'Condition$Equals' => '<p>Represents an <i>equal</i> <b/> condition to be applied to a single field when querying for findings.</p>', 'CoverageFilterCondition$Equals' => '<p>Represents an equal condition that is applied to a single field while retrieving the coverage details.</p>', ], ], 'Evidence' => [ 'base' => '<p>Contains information about the reason that the finding was generated.</p>', 'refs' => [ 'Service$Evidence' => '<p>An evidence object associated with the service.</p>', ], ], 'FargateDetails' => [ 'base' => '<p>Contains information about Amazon Web Services Fargate details associated with an Amazon ECS cluster.</p>', 'refs' => [ 'CoverageEcsClusterDetails$FargateDetails' => '<p>Information about the Fargate details associated with the Amazon ECS cluster.</p>', ], ], 'FeatureAdditionalConfiguration' => [ 'base' => NULL, 'refs' => [ 'DetectorAdditionalConfiguration$Name' => '<p>Name of the additional configuration.</p>', 'DetectorAdditionalConfigurationResult$Name' => '<p>Name of the additional configuration.</p>', ], ], 'FeatureStatus' => [ 'base' => NULL, 'refs' => [ 'DetectorAdditionalConfiguration$Status' => '<p>Status of the additional configuration.</p>', 'DetectorAdditionalConfigurationResult$Status' => '<p>Status of the additional configuration.</p>', 'DetectorFeatureConfiguration$Status' => '<p>The status of the feature.</p>', 'DetectorFeatureConfigurationResult$Status' => '<p>Indicates the status of the feature that is enabled for the detector.</p>', 'MemberAdditionalConfiguration$Status' => '<p>Status of the additional configuration.</p>', 'MemberAdditionalConfigurationResult$Status' => '<p>Indicates the status of the additional configuration that is set for the member account.</p>', 'MemberFeaturesConfiguration$Status' => '<p>The status of the feature.</p>', 'MemberFeaturesConfigurationResult$Status' => '<p>Indicates the status of the feature that is enabled for the detector.</p>', ], ], 'Feedback' => [ 'base' => NULL, 'refs' => [ 'UpdateFindingsFeedbackRequest$Feedback' => '<p>The feedback for the finding.</p>', ], ], 'FilePaths' => [ 'base' => NULL, 'refs' => [ 'ScanThreatName$FilePaths' => '<p>List of infected files in EBS volume with details.</p>', ], ], 'FilterAction' => [ 'base' => NULL, 'refs' => [ 'CreateFilterRequest$Action' => '<p>Specifies the action that is to be applied to the findings that match the filter.</p>', 'GetFilterResponse$Action' => '<p>Specifies the action that is to be applied to the findings that match the filter.</p>', 'UpdateFilterRequest$Action' => '<p>Specifies the action that is to be applied to the findings that match the filter.</p>', ], ], 'FilterCondition' => [ 'base' => '<p>Contains information about the condition.</p>', 'refs' => [ 'FilterCriterion$FilterCondition' => '<p>Contains information about the condition.</p>', ], ], 'FilterCriteria' => [ 'base' => '<p>Represents the criteria to be used in the filter for describing scan entries.</p>', 'refs' => [ 'DescribeMalwareScansRequest$FilterCriteria' => '<p>Represents the criteria to be used in the filter for describing scan entries.</p>', ], ], 'FilterCriterion' => [ 'base' => '<p>Represents a condition that when matched will be added to the response of the operation. Irrespective of using any filter criteria, an administrator account can view the scan entries for all of its member accounts. However, each member account can view the scan entries only for their own account.</p>', 'refs' => [ 'FilterCriterionList$member' => NULL, ], ], 'FilterCriterionList' => [ 'base' => NULL, 'refs' => [ 'FilterCriteria$FilterCriterion' => '<p>Represents a condition that when matched will be added to the response of the operation.</p>', ], ], 'FilterDescription' => [ 'base' => NULL, 'refs' => [ 'CreateFilterRequest$Description' => '<p>The description of the filter. Valid characters include alphanumeric characters, and special characters such as hyphen, period, colon, underscore, parentheses (<code>{ }</code>, <code>[ ]</code>, and <code>( )</code>), forward slash, horizontal tab, vertical tab, newline, form feed, return, and whitespace.</p>', 'GetFilterResponse$Description' => '<p>The description of the filter.</p>', 'UpdateFilterRequest$Description' => '<p>The description of the filter. Valid characters include alphanumeric characters, and special characters such as hyphen, period, colon, underscore, parentheses (<code>{ }</code>, <code>[ ]</code>, and <code>( )</code>), forward slash, horizontal tab, vertical tab, newline, form feed, return, and whitespace.</p>', ], ], 'FilterName' => [ 'base' => NULL, 'refs' => [ 'CreateFilterRequest$Name' => '<p>The name of the filter. Valid characters include period (.), underscore (_), dash (-), and alphanumeric characters. A whitespace is considered to be an invalid character.</p>', 'CreateFilterResponse$Name' => '<p>The name of the successfully created filter.</p>', 'FilterNames$member' => NULL, 'GetFilterResponse$Name' => '<p>The name of the filter.</p>', 'UpdateFilterResponse$Name' => '<p>The name of the filter.</p>', ], ], 'FilterNames' => [ 'base' => NULL, 'refs' => [ 'ListFiltersResponse$FilterNames' => '<p>A list of filter names.</p>', ], ], 'FilterRank' => [ 'base' => NULL, 'refs' => [ 'CreateFilterRequest$Rank' => '<p>Specifies the position of the filter in the list of current filters. Also specifies the order in which this filter is applied to the findings.</p>', 'GetFilterResponse$Rank' => '<p>Specifies the position of the filter in the list of current filters. Also specifies the order in which this filter is applied to the findings.</p>', 'UpdateFilterRequest$Rank' => '<p>Specifies the position of the filter in the list of current filters. Also specifies the order in which this filter is applied to the findings.</p>', ], ], 'Finding' => [ 'base' => '<p>Contains information about the finding that is generated when abnormal or suspicious activity is detected.</p>', 'refs' => [ 'Findings$member' => NULL, ], ], 'FindingCriteria' => [ 'base' => '<p>Contains information about the criteria used for querying findings.</p>', 'refs' => [ 'CreateFilterRequest$FindingCriteria' => '<p>Represents the criteria to be used in the filter for querying findings.</p> <p>You can only use the following attributes to query findings:</p> <ul> <li> <p>accountId</p> </li> <li> <p>id</p> </li> <li> <p>region</p> </li> <li> <p>severity</p> <p>To filter on the basis of severity, the API and CLI use the following input list for the <a href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_FindingCriteria.html">FindingCriteria</a> condition:</p> <ul> <li> <p> <b>Low</b>: <code>["1", "2", "3"]</code> </p> </li> <li> <p> <b>Medium</b>: <code>["4", "5", "6"]</code> </p> </li> <li> <p> <b>High</b>: <code>["7", "8", "9"]</code> </p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_findings.html#guardduty_findings-severity">Severity levels for GuardDuty findings</a>.</p> </li> <li> <p>type</p> </li> <li> <p>updatedAt</p> <p>Type: ISO 8601 string format: YYYY-MM-DDTHH:MM:SS.SSSZ or YYYY-MM-DDTHH:MM:SSZ depending on whether the value contains milliseconds.</p> </li> <li> <p>resource.accessKeyDetails.accessKeyId</p> </li> <li> <p>resource.accessKeyDetails.principalId</p> </li> <li> <p>resource.accessKeyDetails.userName</p> </li> <li> <p>resource.accessKeyDetails.userType</p> </li> <li> <p>resource.instanceDetails.iamInstanceProfile.id</p> </li> <li> <p>resource.instanceDetails.imageId</p> </li> <li> <p>resource.instanceDetails.instanceId</p> </li> <li> <p>resource.instanceDetails.tags.key</p> </li> <li> <p>resource.instanceDetails.tags.value</p> </li> <li> <p>resource.instanceDetails.networkInterfaces.ipv6Addresses</p> </li> <li> <p>resource.instanceDetails.networkInterfaces.privateIpAddresses.privateIpAddress</p> </li> <li> <p>resource.instanceDetails.networkInterfaces.publicDnsName</p> </li> <li> <p>resource.instanceDetails.networkInterfaces.publicIp</p> </li> <li> <p>resource.instanceDetails.networkInterfaces.securityGroups.groupId</p> </li> <li> <p>resource.instanceDetails.networkInterfaces.securityGroups.groupName</p> </li> <li> <p>resource.instanceDetails.networkInterfaces.subnetId</p> </li> <li> <p>resource.instanceDetails.networkInterfaces.vpcId</p> </li> <li> <p>resource.instanceDetails.outpostArn</p> </li> <li> <p>resource.resourceType</p> </li> <li> <p>resource.s3BucketDetails.publicAccess.effectivePermissions</p> </li> <li> <p>resource.s3BucketDetails.name</p> </li> <li> <p>resource.s3BucketDetails.tags.key</p> </li> <li> <p>resource.s3BucketDetails.tags.value</p> </li> <li> <p>resource.s3BucketDetails.type</p> </li> <li> <p>service.action.actionType</p> </li> <li> <p>service.action.awsApiCallAction.api</p> </li> <li> <p>service.action.awsApiCallAction.callerType</p> </li> <li> <p>service.action.awsApiCallAction.errorCode</p> </li> <li> <p>service.action.awsApiCallAction.remoteIpDetails.city.cityName</p> </li> <li> <p>service.action.awsApiCallAction.remoteIpDetails.country.countryName</p> </li> <li> <p>service.action.awsApiCallAction.remoteIpDetails.ipAddressV4</p> </li> <li> <p>service.action.awsApiCallAction.remoteIpDetails.ipAddressV6</p> </li> <li> <p>service.action.awsApiCallAction.remoteIpDetails.organization.asn</p> </li> <li> <p>service.action.awsApiCallAction.remoteIpDetails.organization.asnOrg</p> </li> <li> <p>service.action.awsApiCallAction.serviceName</p> </li> <li> <p>service.action.dnsRequestAction.domain</p> </li> <li> <p>service.action.dnsRequestAction.domainWithSuffix</p> </li> <li> <p>service.action.networkConnectionAction.blocked</p> </li> <li> <p>service.action.networkConnectionAction.connectionDirection</p> </li> <li> <p>service.action.networkConnectionAction.localPortDetails.port</p> </li> <li> <p>service.action.networkConnectionAction.protocol</p> </li> <li> <p>service.action.networkConnectionAction.remoteIpDetails.city.cityName</p> </li> <li> <p>service.action.networkConnectionAction.remoteIpDetails.country.countryName</p> </li> <li> <p>service.action.networkConnectionAction.remoteIpDetails.ipAddressV4</p> </li> <li> <p>service.action.networkConnectionAction.remoteIpDetails.ipAddressV6</p> </li> <li> <p>service.action.networkConnectionAction.remoteIpDetails.organization.asn</p> </li> <li> <p>service.action.networkConnectionAction.remoteIpDetails.organization.asnOrg</p> </li> <li> <p>service.action.networkConnectionAction.remotePortDetails.port</p> </li> <li> <p>service.action.awsApiCallAction.remoteAccountDetails.affiliated</p> </li> <li> <p>service.action.kubernetesApiCallAction.remoteIpDetails.ipAddressV4</p> </li> <li> <p>service.action.kubernetesApiCallAction.remoteIpDetails.ipAddressV6</p> </li> <li> <p>service.action.kubernetesApiCallAction.namespace</p> </li> <li> <p>service.action.kubernetesApiCallAction.remoteIpDetails.organization.asn</p> </li> <li> <p>service.action.kubernetesApiCallAction.requestUri</p> </li> <li> <p>service.action.kubernetesApiCallAction.statusCode</p> </li> <li> <p>service.action.networkConnectionAction.localIpDetails.ipAddressV4</p> </li> <li> <p>service.action.networkConnectionAction.localIpDetails.ipAddressV6</p> </li> <li> <p>service.action.networkConnectionAction.protocol</p> </li> <li> <p>service.action.awsApiCallAction.serviceName</p> </li> <li> <p>service.action.awsApiCallAction.remoteAccountDetails.accountId</p> </li> <li> <p>service.additionalInfo.threatListName</p> </li> <li> <p>service.resourceRole</p> </li> <li> <p>resource.eksClusterDetails.name</p> </li> <li> <p>resource.kubernetesDetails.kubernetesWorkloadDetails.name</p> </li> <li> <p>resource.kubernetesDetails.kubernetesWorkloadDetails.namespace</p> </li> <li> <p>resource.kubernetesDetails.kubernetesUserDetails.username</p> </li> <li> <p>resource.kubernetesDetails.kubernetesWorkloadDetails.containers.image</p> </li> <li> <p>resource.kubernetesDetails.kubernetesWorkloadDetails.containers.imagePrefix</p> </li> <li> <p>service.ebsVolumeScanDetails.scanId</p> </li> <li> <p>service.ebsVolumeScanDetails.scanDetections.threatDetectedByName.threatNames.name</p> </li> <li> <p>service.ebsVolumeScanDetails.scanDetections.threatDetectedByName.threatNames.severity</p> </li> <li> <p>service.ebsVolumeScanDetails.scanDetections.threatDetectedByName.threatNames.filePaths.hash</p> </li> <li> <p>resource.ecsClusterDetails.name</p> </li> <li> <p>resource.ecsClusterDetails.taskDetails.containers.image</p> </li> <li> <p>resource.ecsClusterDetails.taskDetails.definitionArn</p> </li> <li> <p>resource.containerDetails.image</p> </li> <li> <p>resource.rdsDbInstanceDetails.dbInstanceIdentifier</p> </li> <li> <p>resource.rdsDbInstanceDetails.dbClusterIdentifier</p> </li> <li> <p>resource.rdsDbInstanceDetails.engine</p> </li> <li> <p>resource.rdsDbUserDetails.user</p> </li> <li> <p>resource.rdsDbInstanceDetails.tags.key</p> </li> <li> <p>resource.rdsDbInstanceDetails.tags.value</p> </li> <li> <p>service.runtimeDetails.process.executableSha256</p> </li> <li> <p>service.runtimeDetails.process.name</p> </li> <li> <p>service.runtimeDetails.process.name</p> </li> <li> <p>resource.lambdaDetails.functionName</p> </li> <li> <p>resource.lambdaDetails.functionArn</p> </li> <li> <p>resource.lambdaDetails.tags.key</p> </li> <li> <p>resource.lambdaDetails.tags.value</p> </li> </ul>', 'GetFilterResponse$FindingCriteria' => '<p>Represents the criteria to be used in the filter for querying findings.</p>', 'GetFindingsStatisticsRequest$FindingCriteria' => '<p>Represents the criteria that is used for querying findings.</p>', 'ListFindingsRequest$FindingCriteria' => '<p>Represents the criteria used for querying findings. Valid values include:</p> <ul> <li> <p>JSON field name</p> </li> <li> <p>accountId</p> </li> <li> <p>region</p> </li> <li> <p>confidence</p> </li> <li> <p>id</p> </li> <li> <p>resource.accessKeyDetails.accessKeyId</p> </li> <li> <p>resource.accessKeyDetails.principalId</p> </li> <li> <p>resource.accessKeyDetails.userName</p> </li> <li> <p>resource.accessKeyDetails.userType</p> </li> <li> <p>resource.instanceDetails.iamInstanceProfile.id</p> </li> <li> <p>resource.instanceDetails.imageId</p> </li> <li> <p>resource.instanceDetails.instanceId</p> </li> <li> <p>resource.instanceDetails.networkInterfaces.ipv6Addresses</p> </li> <li> <p>resource.instanceDetails.networkInterfaces.privateIpAddresses.privateIpAddress</p> </li> <li> <p>resource.instanceDetails.networkInterfaces.publicDnsName</p> </li> <li> <p>resource.instanceDetails.networkInterfaces.publicIp</p> </li> <li> <p>resource.instanceDetails.networkInterfaces.securityGroups.groupId</p> </li> <li> <p>resource.instanceDetails.networkInterfaces.securityGroups.groupName</p> </li> <li> <p>resource.instanceDetails.networkInterfaces.subnetId</p> </li> <li> <p>resource.instanceDetails.networkInterfaces.vpcId</p> </li> <li> <p>resource.instanceDetails.tags.key</p> </li> <li> <p>resource.instanceDetails.tags.value</p> </li> <li> <p>resource.resourceType</p> </li> <li> <p>service.action.actionType</p> </li> <li> <p>service.action.awsApiCallAction.api</p> </li> <li> <p>service.action.awsApiCallAction.callerType</p> </li> <li> <p>service.action.awsApiCallAction.remoteIpDetails.city.cityName</p> </li> <li> <p>service.action.awsApiCallAction.remoteIpDetails.country.countryName</p> </li> <li> <p>service.action.awsApiCallAction.remoteIpDetails.ipAddressV4</p> </li> <li> <p>service.action.awsApiCallAction.remoteIpDetails.organization.asn</p> </li> <li> <p>service.action.awsApiCallAction.remoteIpDetails.organization.asnOrg</p> </li> <li> <p>service.action.awsApiCallAction.serviceName</p> </li> <li> <p>service.action.dnsRequestAction.domain</p> </li> <li> <p>service.action.dnsRequestAction.domainWithSuffix</p> </li> <li> <p>service.action.networkConnectionAction.blocked</p> </li> <li> <p>service.action.networkConnectionAction.connectionDirection</p> </li> <li> <p>service.action.networkConnectionAction.localPortDetails.port</p> </li> <li> <p>service.action.networkConnectionAction.protocol</p> </li> <li> <p>service.action.networkConnectionAction.remoteIpDetails.country.countryName</p> </li> <li> <p>service.action.networkConnectionAction.remoteIpDetails.ipAddressV4</p> </li> <li> <p>service.action.networkConnectionAction.remoteIpDetails.organization.asn</p> </li> <li> <p>service.action.networkConnectionAction.remoteIpDetails.organization.asnOrg</p> </li> <li> <p>service.action.networkConnectionAction.remotePortDetails.port</p> </li> <li> <p>service.additionalInfo.threatListName</p> </li> <li> <p>service.archived</p> <p>When this attribute is set to \'true\', only archived findings are listed. When it\'s set to \'false\', only unarchived findings are listed. When this attribute is not set, all existing findings are listed.</p> </li> <li> <p>service.resourceRole</p> </li> <li> <p>severity</p> </li> <li> <p>type</p> </li> <li> <p>updatedAt</p> <p>Type: Timestamp in Unix Epoch millisecond format: 1486685375000</p> </li> </ul>', 'UpdateFilterRequest$FindingCriteria' => '<p>Represents the criteria to be used in the filter for querying findings.</p>', ], ], 'FindingId' => [ 'base' => NULL, 'refs' => [ 'FindingIds$member' => NULL, ], ], 'FindingIds' => [ 'base' => NULL, 'refs' => [ 'ArchiveFindingsRequest$FindingIds' => '<p>The IDs of the findings that you want to archive.</p>', 'GetFindingsRequest$FindingIds' => '<p>The IDs of the findings that you want to retrieve.</p>', 'ListFindingsResponse$FindingIds' => '<p>The IDs of the findings that you\'re listing.</p>', 'UnarchiveFindingsRequest$FindingIds' => '<p>The IDs of the findings to unarchive.</p>', 'UpdateFindingsFeedbackRequest$FindingIds' => '<p>The IDs of the findings that you want to mark as useful or not useful.</p>', ], ], 'FindingPublishingFrequency' => [ 'base' => NULL, 'refs' => [ 'CreateDetectorRequest$FindingPublishingFrequency' => '<p>A value that specifies how frequently updated findings are exported.</p>', 'GetDetectorResponse$FindingPublishingFrequency' => '<p>The publishing frequency of the finding.</p>', 'UpdateDetectorRequest$FindingPublishingFrequency' => '<p>An enum value that specifies how frequently findings are exported, such as to CloudWatch Events.</p>', ], ], 'FindingStatisticType' => [ 'base' => NULL, 'refs' => [ 'FindingStatisticTypes$member' => NULL, ], ], 'FindingStatisticTypes' => [ 'base' => NULL, 'refs' => [ 'GetFindingsStatisticsRequest$FindingStatisticTypes' => '<p>The types of finding statistics to retrieve.</p>', ], ], 'FindingStatistics' => [ 'base' => '<p>Contains information about finding statistics.</p>', 'refs' => [ 'GetFindingsStatisticsResponse$FindingStatistics' => '<p>The finding statistics object.</p>', ], ], 'FindingType' => [ 'base' => NULL, 'refs' => [ 'Finding$Type' => '<p>The type of finding.</p>', 'FindingTypes$member' => NULL, ], ], 'FindingTypes' => [ 'base' => NULL, 'refs' => [ 'CreateSampleFindingsRequest$FindingTypes' => '<p>The types of sample findings to generate.</p>', ], ], 'Findings' => [ 'base' => NULL, 'refs' => [ 'GetFindingsResponse$Findings' => '<p>A list of findings.</p>', ], ], 'FlagsList' => [ 'base' => NULL, 'refs' => [ 'RuntimeContext$Flags' => '<p>Represents options that control the behavior of a runtime operation or action. For example, a filesystem mount operation may contain a read-only flag.</p>', ], ], 'FlowLogsConfigurationResult' => [ 'base' => '<p>Contains information on the status of VPC flow logs as a data source.</p>', 'refs' => [ 'DataSourceConfigurationsResult$FlowLogs' => '<p>An object that contains information on the status of VPC flow logs as a data source.</p>', ], ], 'FreeTrialFeatureConfigurationResult' => [ 'base' => '<p>Contains information about the free trial period for a feature.</p>', 'refs' => [ 'FreeTrialFeatureConfigurationsResults$member' => NULL, ], ], 'FreeTrialFeatureConfigurationsResults' => [ 'base' => NULL, 'refs' => [ 'AccountFreeTrialInfo$Features' => '<p>A list of features enabled for the GuardDuty account.</p>', ], ], 'FreeTrialFeatureResult' => [ 'base' => NULL, 'refs' => [ 'FreeTrialFeatureConfigurationResult$Name' => '<p>The name of the feature for which the free trial is configured.</p>', ], ], 'GeoLocation' => [ 'base' => '<p>Contains information about the location of the remote IP address.</p>', 'refs' => [ 'RemoteIpDetails$GeoLocation' => '<p>The location information of the remote IP address.</p>', ], ], 'GetAdministratorAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAdministratorAccountResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetCoverageStatisticsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCoverageStatisticsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetDetectorRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDetectorResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetFilterRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetFilterResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetFindingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetFindingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetFindingsStatisticsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetFindingsStatisticsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetIPSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetIPSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetInvitationsCountRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetInvitationsCountResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetMalwareProtectionPlanRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMalwareProtectionPlanResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetMalwareScanSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMalwareScanSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetMasterAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMasterAccountResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetMemberDetectorsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMemberDetectorsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetMembersRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMembersResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetOrganizationStatisticsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetRemainingFreeTrialDaysRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRemainingFreeTrialDaysResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetThreatIntelSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetThreatIntelSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetUsageStatisticsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetUsageStatisticsResponse' => [ 'base' => NULL, 'refs' => [], ], 'Groups' => [ 'base' => NULL, 'refs' => [ 'ImpersonatedUser$Groups' => '<p>The <code>group</code> to which the user name belongs.</p>', 'KubernetesUserDetails$Groups' => '<p>The groups that include the user who called the Kubernetes API.</p>', ], ], 'GuardDutyArn' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) for the given GuardDuty resource. </p>', 'TagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) for the GuardDuty resource to apply a tag to.</p>', 'UntagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) for the resource to remove tags from.</p>', ], ], 'HighestSeverityThreatDetails' => [ 'base' => '<p>Contains details of the highest severity threat detected during scan and number of infected files.</p>', 'refs' => [ 'ScanDetections$HighestSeverityThreatDetails' => '<p>Details of the highest severity threat detected during malware scan and number of infected files.</p>', ], ], 'HostPath' => [ 'base' => '<p>Represents a pre-existing file or directory on the host machine that the volume maps to.</p>', 'refs' => [ 'Volume$HostPath' => '<p>Represents a pre-existing file or directory on the host machine that the volume maps to.</p>', ], ], 'IamInstanceProfile' => [ 'base' => '<p>Contains information about the EC2 instance profile.</p>', 'refs' => [ 'InstanceDetails$IamInstanceProfile' => '<p>The profile information of the EC2 instance.</p>', ], ], 'ImpersonatedUser' => [ 'base' => '<p>Contains information about the impersonated user.</p>', 'refs' => [ 'KubernetesUserDetails$ImpersonatedUser' => '<p>Information about the impersonated user.</p>', ], ], 'InstanceArn' => [ 'base' => NULL, 'refs' => [ 'ResourceDetails$InstanceArn' => '<p>Instance ARN that was scanned in the scan entry.</p>', ], ], 'InstanceDetails' => [ 'base' => '<p>Contains information about the details of an instance.</p>', 'refs' => [ 'Resource$InstanceDetails' => '<p>The information about the EC2 instance associated with the activity that prompted GuardDuty to generate a finding.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'Condition$Gt' => '<p>Represents a <i>greater than</i> condition to be applied to a single field when querying for findings.</p>', 'Condition$Gte' => '<p>Represents a <i>greater than or equal</i> condition to be applied to a single field when querying for findings.</p>', 'Condition$Lt' => '<p>Represents a <i>less than</i> condition to be applied to a single field when querying for findings.</p>', 'Condition$Lte' => '<p>Represents a <i>less than or equal</i> condition to be applied to a single field when querying for findings.</p>', 'CountBySeverity$value' => NULL, 'DataSourceFreeTrial$FreeTrialDaysRemaining' => '<p>A value that specifies the number of days left to use each enabled data source.</p>', 'EcsClusterDetails$ActiveServicesCount' => '<p>The number of services that are running on the cluster in an ACTIVE state.</p>', 'EcsClusterDetails$RegisteredContainerInstancesCount' => '<p>The number of container instances registered into the cluster.</p>', 'EcsClusterDetails$RunningTasksCount' => '<p>The number of tasks in the cluster that are in the RUNNING state.</p>', 'FreeTrialFeatureConfigurationResult$FreeTrialDaysRemaining' => '<p>The number of the remaining free trial days for the feature.</p>', 'GetInvitationsCountResponse$InvitationsCount' => '<p>The number of received invitations.</p>', 'HighestSeverityThreatDetails$Count' => '<p>Total number of infected files with the highest severity threat detected.</p>', 'KubernetesApiCallAction$StatusCode' => '<p>The resulting HTTP response code of the Kubernetes API call action.</p>', 'LineageObject$NamespacePid' => '<p>The process ID of the child process.</p>', 'LineageObject$UserId' => '<p>The user ID of the user that executed the process.</p>', 'LineageObject$Pid' => '<p>The ID of the process.</p>', 'LineageObject$Euid' => '<p>The effective user ID that was used to execute the process.</p>', 'LocalPortDetails$Port' => '<p>The port number of the local connection.</p>', 'LoginAttribute$FailedLoginAttempts' => '<p>Represents the sum of failed (unsuccessful) login attempts made to establish a connection to the database instance.</p>', 'LoginAttribute$SuccessfulLoginAttempts' => '<p>Represents the sum of successful connections (a correct combination of login attributes) made to the database instance by the actor.</p>', 'OrganizationFeatureStatistics$EnabledAccountsCount' => '<p>Total number of accounts that have enabled a specific feature.</p>', 'OrganizationFeatureStatisticsAdditionalConfiguration$EnabledAccountsCount' => '<p>Total number of accounts that have enabled the additional configuration.</p>', 'OrganizationStatistics$TotalAccountsCount' => '<p>Total number of accounts in your Amazon Web Services organization.</p>', 'OrganizationStatistics$MemberAccountsCount' => '<p>Total number of accounts in your Amazon Web Services organization that are associated with GuardDuty.</p>', 'OrganizationStatistics$ActiveAccountsCount' => '<p>Total number of active accounts in your Amazon Web Services organization that are associated with GuardDuty.</p>', 'OrganizationStatistics$EnabledAccountsCount' => '<p>Total number of accounts that have enabled GuardDuty.</p>', 'ProcessDetails$NamespacePid' => '<p>The ID of the child process.</p>', 'ProcessDetails$Pid' => '<p>The ID of the process.</p>', 'ProcessDetails$UserId' => '<p>The unique ID of the user that executed the process.</p>', 'ProcessDetails$Euid' => '<p>The effective user ID of the user that executed the process.</p>', 'RemotePortDetails$Port' => '<p>The port number of the remote connection.</p>', 'RuntimeContext$IanaProtocolNumber' => '<p>Specifies a particular protocol within the address family. Usually there is a single protocol in address families. For example, the address family <code>AF_INET</code> only has the IP protocol.</p>', 'ScanThreatName$ItemCount' => '<p>Total number of files infected with given threat.</p>', 'ScannedItemCount$TotalGb' => '<p>Total GB of files scanned for malware.</p>', 'ScannedItemCount$Files' => '<p>Number of files scanned.</p>', 'ScannedItemCount$Volumes' => '<p>Total number of scanned volumes.</p>', 'Service$Count' => '<p>The total count of the occurrences of this finding type.</p>', 'ThreatDetectedByName$ItemCount' => '<p>Total number of infected files identified.</p>', 'ThreatDetectedByName$UniqueThreatNameCount' => '<p>Total number of unique threats by name identified, as part of the malware scan.</p>', 'ThreatsDetectedItemCount$Files' => '<p>Total number of infected files.</p>', 'VolumeDetail$VolumeSizeInGB' => '<p>EBS volume size in GB.</p>', ], ], 'IntegerValueWithMax' => [ 'base' => NULL, 'refs' => [ 'DescribeMalwareScansRequest$MaxResults' => '<p>You can use this parameter to indicate the maximum number of items that you want in the response. The default value is 50. The maximum value is 50.</p>', ], ], 'InternalServerErrorException' => [ 'base' => '<p>An internal server error exception object.</p>', 'refs' => [], ], 'Invitation' => [ 'base' => '<p>Contains information about the invitation to become a member account.</p>', 'refs' => [ 'Invitations$member' => NULL, ], ], 'Invitations' => [ 'base' => NULL, 'refs' => [ 'ListInvitationsResponse$Invitations' => '<p>A list of invitation descriptions.</p>', ], ], 'InviteMembersRequest' => [ 'base' => NULL, 'refs' => [], ], 'InviteMembersResponse' => [ 'base' => NULL, 'refs' => [], ], 'IpSetFormat' => [ 'base' => NULL, 'refs' => [ 'CreateIPSetRequest$Format' => '<p>The format of the file that contains the IPSet.</p>', 'GetIPSetResponse$Format' => '<p>The format of the file that contains the IPSet.</p>', ], ], 'IpSetIds' => [ 'base' => NULL, 'refs' => [ 'ListIPSetsResponse$IpSetIds' => '<p>The IDs of the IPSet resources.</p>', ], ], 'IpSetStatus' => [ 'base' => NULL, 'refs' => [ 'GetIPSetResponse$Status' => '<p>The status of IPSet file that was uploaded.</p>', ], ], 'Ipv6Addresses' => [ 'base' => NULL, 'refs' => [ 'NetworkInterface$Ipv6Addresses' => '<p>A list of IPv6 addresses for the EC2 instance.</p>', ], ], 'Issues' => [ 'base' => NULL, 'refs' => [ 'FargateDetails$Issues' => '<p>Runtime coverage issues identified for the resource running on Amazon Web Services Fargate.</p>', ], ], 'ItemPath' => [ 'base' => '<p>Information about the nested item path and hash of the protected resource.</p>', 'refs' => [ 'ItemPaths$member' => NULL, ], ], 'ItemPaths' => [ 'base' => NULL, 'refs' => [ 'Threat$ItemPaths' => '<p>Information about the nested item path and hash of the protected resource.</p>', ], ], 'KubernetesApiCallAction' => [ 'base' => '<p>Information about the Kubernetes API call action described in this finding.</p>', 'refs' => [ 'Action$KubernetesApiCallAction' => '<p>Information about the Kubernetes API call action described in this finding.</p>', ], ], 'KubernetesAuditLogsConfiguration' => [ 'base' => '<p>Describes whether Kubernetes audit logs are enabled as a data source.</p>', 'refs' => [ 'KubernetesConfiguration$AuditLogs' => '<p>The status of Kubernetes audit logs as a data source.</p>', ], ], 'KubernetesAuditLogsConfigurationResult' => [ 'base' => '<p>Describes whether Kubernetes audit logs are enabled as a data source.</p>', 'refs' => [ 'KubernetesConfigurationResult$AuditLogs' => '<p>Describes whether Kubernetes audit logs are enabled as a data source.</p>', ], ], 'KubernetesConfiguration' => [ 'base' => '<p>Describes whether any Kubernetes data sources are enabled.</p>', 'refs' => [ 'DataSourceConfigurations$Kubernetes' => '<p>Describes whether any Kubernetes logs are enabled as data sources.</p>', ], ], 'KubernetesConfigurationResult' => [ 'base' => '<p>Describes whether any Kubernetes logs will be enabled as a data source.</p>', 'refs' => [ 'DataSourceConfigurationsResult$Kubernetes' => '<p>An object that contains information on the status of all Kubernetes data sources.</p>', ], ], 'KubernetesDataSourceFreeTrial' => [ 'base' => '<p>Provides details about the Kubernetes resources when it is enabled as a data source.</p>', 'refs' => [ 'DataSourcesFreeTrial$Kubernetes' => '<p>Describes whether any Kubernetes logs are enabled as data sources.</p>', ], ], 'KubernetesDetails' => [ 'base' => '<p>Details about Kubernetes resources such as a Kubernetes user or workload resource involved in a Kubernetes finding.</p>', 'refs' => [ 'Resource$KubernetesDetails' => '<p>Details about the Kubernetes user and workload involved in a Kubernetes finding.</p>', ], ], 'KubernetesPermissionCheckedDetails' => [ 'base' => '<p>Information about the Kubernetes API for which you check if you have permission to call.</p>', 'refs' => [ 'Action$KubernetesPermissionCheckedDetails' => '<p>Information whether the user has the permission to use a specific Kubernetes API.</p>', ], ], 'KubernetesRoleBindingDetails' => [ 'base' => '<p>Contains information about the role binding that grants the permission defined in a Kubernetes role.</p>', 'refs' => [ 'Action$KubernetesRoleBindingDetails' => '<p>Information about the role binding that grants the permission defined in a Kubernetes role.</p>', ], ], 'KubernetesRoleDetails' => [ 'base' => '<p>Information about the Kubernetes role name and role type.</p>', 'refs' => [ 'Action$KubernetesRoleDetails' => '<p>Information about the Kubernetes role name and role type.</p>', ], ], 'KubernetesUserDetails' => [ 'base' => '<p>Details about the Kubernetes user involved in a Kubernetes finding.</p>', 'refs' => [ 'KubernetesDetails$KubernetesUserDetails' => '<p>Details about the Kubernetes user involved in a Kubernetes finding.</p>', ], ], 'KubernetesWorkloadDetails' => [ 'base' => '<p>Details about the Kubernetes workload involved in a Kubernetes finding.</p>', 'refs' => [ 'KubernetesDetails$KubernetesWorkloadDetails' => '<p>Details about the Kubernetes workload involved in a Kubernetes finding.</p>', ], ], 'LambdaDetails' => [ 'base' => '<p>Information about the Lambda function involved in the finding.</p>', 'refs' => [ 'Resource$LambdaDetails' => '<p>Contains information about the Lambda function that was involved in a finding.</p>', ], ], 'Lineage' => [ 'base' => NULL, 'refs' => [ 'ProcessDetails$Lineage' => '<p>Information about the process\'s lineage.</p>', ], ], 'LineageObject' => [ 'base' => '<p>Information about the runtime process details.</p>', 'refs' => [ 'Lineage$member' => NULL, ], ], 'ListCoverageRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCoverageResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDetectorsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDetectorsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFiltersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFiltersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFindingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFindingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListIPSetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListIPSetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListInvitationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListInvitationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListMalwareProtectionPlansRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListMalwareProtectionPlansResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListMembersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListMembersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListOrganizationAdminAccountsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListOrganizationAdminAccountsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPublishingDestinationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPublishingDestinationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListThreatIntelSetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListThreatIntelSetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'LocalIpDetails' => [ 'base' => '<p>Contains information about the local IP address of the connection.</p>', 'refs' => [ 'NetworkConnectionAction$LocalIpDetails' => '<p>The local IP information of the connection.</p>', 'PortProbeDetail$LocalIpDetails' => '<p>The local IP information of the connection.</p>', ], ], 'LocalPortDetails' => [ 'base' => '<p>Contains information about the port for the local connection.</p>', 'refs' => [ 'NetworkConnectionAction$LocalPortDetails' => '<p>The local port information of the connection.</p>', 'PortProbeDetail$LocalPortDetails' => '<p>The local port information of the connection.</p>', ], ], 'Location' => [ 'base' => NULL, 'refs' => [ 'CreateIPSetRequest$Location' => '<p>The URI of the file that contains the IPSet. </p>', 'CreateThreatIntelSetRequest$Location' => '<p>The URI of the file that contains the ThreatIntelSet. </p>', 'GetIPSetResponse$Location' => '<p>The URI of the file that contains the IPSet.</p>', 'GetThreatIntelSetResponse$Location' => '<p>The URI of the file that contains the ThreatIntelSet. </p>', 'UpdateIPSetRequest$Location' => '<p>The updated URI of the file that contains the IPSet. </p>', 'UpdateThreatIntelSetRequest$Location' => '<p>The updated URI of the file that contains the ThreateIntelSet.</p>', ], ], 'LoginAttribute' => [ 'base' => '<p>Information about the login attempts.</p>', 'refs' => [ 'LoginAttributes$member' => NULL, ], ], 'LoginAttributes' => [ 'base' => NULL, 'refs' => [ 'RdsLoginAttemptAction$LoginAttributes' => '<p>Indicates the login attributes used in the login attempt.</p>', ], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'Condition$GreaterThan' => '<p>Represents a <i>greater than</i> condition to be applied to a single field when querying for findings.</p>', 'Condition$GreaterThanOrEqual' => '<p>Represents a <i>greater than or equal</i> condition to be applied to a single field when querying for findings.</p>', 'Condition$LessThan' => '<p>Represents a <i>less than</i> condition to be applied to a single field when querying for findings.</p>', 'Condition$LessThanOrEqual' => '<p>Represents a <i>less than or equal</i> condition to be applied to a single field when querying for findings.</p>', 'ContainerInstanceDetails$CoveredContainerInstances' => '<p>Represents the nodes in the Amazon ECS cluster that has a <code>HEALTHY</code> coverage status.</p>', 'ContainerInstanceDetails$CompatibleContainerInstances' => '<p>Represents total number of nodes in the Amazon ECS cluster.</p>', 'CountByCoverageStatus$value' => NULL, 'CountByResourceType$value' => NULL, 'CoverageEksClusterDetails$CoveredNodes' => '<p>Represents the nodes within the EKS cluster that have a <code>HEALTHY</code> coverage status.</p>', 'CoverageEksClusterDetails$CompatibleNodes' => '<p>Represents all the nodes within the EKS cluster in your account.</p>', 'DescribePublishingDestinationResponse$PublishingFailureStartTimestamp' => '<p>The time, in epoch millisecond format, at which GuardDuty was first unable to publish findings to the destination.</p>', ], ], 'LongValue' => [ 'base' => NULL, 'refs' => [ 'FilterCondition$GreaterThan' => '<p>Represents a <i>greater than</i> condition to be applied to a single field when querying for scan entries.</p>', 'FilterCondition$LessThan' => '<p>Represents a <i>less than</i> condition to be applied to a single field when querying for scan entries.</p>', ], ], 'MalwareProtectionConfiguration' => [ 'base' => '<p>Describes whether Malware Protection will be enabled as a data source.</p>', 'refs' => [ 'DataSourceConfigurations$MalwareProtection' => '<p>Describes whether Malware Protection is enabled as a data source.</p>', ], ], 'MalwareProtectionConfigurationResult' => [ 'base' => '<p>An object that contains information on the status of all Malware Protection data sources.</p>', 'refs' => [ 'DataSourceConfigurationsResult$MalwareProtection' => '<p>Describes the configuration of Malware Protection data sources.</p>', 'UnprocessedDataSourcesResult$MalwareProtection' => NULL, ], ], 'MalwareProtectionDataSourceFreeTrial' => [ 'base' => '<p>Provides details about Malware Protection when it is enabled as a data source.</p>', 'refs' => [ 'DataSourcesFreeTrial$MalwareProtection' => '<p>Describes whether Malware Protection is enabled as a data source.</p>', ], ], 'MalwareProtectionPlanActions' => [ 'base' => '<p>Information about whether the tags will be added to the S3 object after scanning.</p>', 'refs' => [ 'CreateMalwareProtectionPlanRequest$Actions' => '<p>Information about whether the tags will be added to the S3 object after scanning.</p>', 'GetMalwareProtectionPlanResponse$Actions' => '<p>Information about whether the tags will be added to the S3 object after scanning.</p>', 'UpdateMalwareProtectionPlanRequest$Actions' => '<p>Information about whether the tags will be added to the S3 object after scanning.</p>', ], ], 'MalwareProtectionPlanObjectPrefixesList' => [ 'base' => NULL, 'refs' => [ 'CreateS3BucketResource$ObjectPrefixes' => '<p>Information about the specified object prefixes. The S3 object will be scanned only if it belongs to any of the specified object prefixes.</p>', 'UpdateS3BucketResource$ObjectPrefixes' => '<p>Information about the specified object prefixes. The S3 object will be scanned only if it belongs to any of the specified object prefixes.</p>', ], ], 'MalwareProtectionPlanStatus' => [ 'base' => NULL, 'refs' => [ 'GetMalwareProtectionPlanResponse$Status' => '<p>Malware Protection plan status.</p>', ], ], 'MalwareProtectionPlanStatusReason' => [ 'base' => '<p>Information about the issue code and message associated to the status of your Malware Protection plan.</p>', 'refs' => [ 'MalwareProtectionPlanStatusReasonsList$member' => NULL, ], ], 'MalwareProtectionPlanStatusReasonsList' => [ 'base' => NULL, 'refs' => [ 'GetMalwareProtectionPlanResponse$StatusReasons' => '<p>Information about the issue code and message associated to the status of your Malware Protection plan.</p>', ], ], 'MalwareProtectionPlanSummary' => [ 'base' => '<p>Information about the Malware Protection plan resource.</p>', 'refs' => [ 'MalwareProtectionPlansSummary$member' => NULL, ], ], 'MalwareProtectionPlanTaggingAction' => [ 'base' => '<p>Information about adding tags to the scanned S3 object after the scan result.</p>', 'refs' => [ 'MalwareProtectionPlanActions$Tagging' => '<p>Indicates whether the scanned S3 object will have tags about the scan result.</p>', ], ], 'MalwareProtectionPlanTaggingActionStatus' => [ 'base' => NULL, 'refs' => [ 'MalwareProtectionPlanTaggingAction$Status' => '<p>Indicates whether or not the tags will added.</p>', ], ], 'MalwareProtectionPlansSummary' => [ 'base' => NULL, 'refs' => [ 'ListMalwareProtectionPlansResponse$MalwareProtectionPlans' => '<p>A list of unique identifiers associated with each Malware Protection plan.</p>', ], ], 'MalwareScanDetails' => [ 'base' => '<p>Information about the malware scan that generated a GuardDuty finding.</p>', 'refs' => [ 'Service$MalwareScanDetails' => '<p>Returns details from the malware scan that generated a GuardDuty finding.</p>', ], ], 'ManagementType' => [ 'base' => NULL, 'refs' => [ 'CoverageEc2InstanceDetails$ManagementType' => '<p>Indicates how the GuardDuty security agent is managed for this resource.</p> <ul> <li> <p> <code>AUTO_MANAGED</code> indicates that GuardDuty deploys and manages updates for this resource.</p> </li> <li> <p> <code>MANUAL</code> indicates that you are responsible to deploy, update, and manage the GuardDuty security agent updates for this resource.</p> </li> </ul> <note> <p>The <code>DISABLED</code> status doesn\'t apply to Amazon EC2 instances and Amazon EKS clusters.</p> </note>', 'CoverageEksClusterDetails$ManagementType' => '<p>Indicates how the Amazon EKS add-on GuardDuty agent is managed for this EKS cluster.</p> <p> <code>AUTO_MANAGED</code> indicates GuardDuty deploys and manages updates for this resource.</p> <p> <code>MANUAL</code> indicates that you are responsible to deploy, update, and manage the Amazon EKS add-on GuardDuty agent for this resource.</p>', 'FargateDetails$ManagementType' => '<p>Indicates how the GuardDuty security agent is managed for this resource.</p> <ul> <li> <p> <code>AUTO_MANAGED</code> indicates that GuardDuty deploys and manages updates for this resource.</p> </li> <li> <p> <code>DISABLED</code> indicates that the deployment of the GuardDuty security agent is disabled for this resource.</p> </li> </ul> <note> <p>The <code>MANUAL</code> status doesn\'t apply to the Amazon Web Services Fargate (Amazon ECS only) woprkloads.</p> </note>', ], ], 'MapEquals' => [ 'base' => NULL, 'refs' => [ 'ScanCondition$MapEquals' => '<p>Represents an <i>mapEqual</i> <b/> condition to be applied to a single field when triggering for malware scan.</p>', ], ], 'Master' => [ 'base' => '<p>Contains information about the administrator account and invitation.</p>', 'refs' => [ 'GetMasterAccountResponse$Master' => '<p>The administrator account details.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeOrganizationConfigurationRequest$MaxResults' => '<p>You can use this parameter to indicate the maximum number of items that you want in the response.</p>', 'GetUsageStatisticsRequest$MaxResults' => '<p>The maximum number of results to return in the response.</p>', 'ListCoverageRequest$MaxResults' => '<p>The maximum number of results to return in the response.</p>', 'ListDetectorsRequest$MaxResults' => '<p>You can use this parameter to indicate the maximum number of items that you want in the response. The default value is 50. The maximum value is 50.</p>', 'ListFiltersRequest$MaxResults' => '<p>You can use this parameter to indicate the maximum number of items that you want in the response. The default value is 50. The maximum value is 50.</p>', 'ListFindingsRequest$MaxResults' => '<p>You can use this parameter to indicate the maximum number of items you want in the response. The default value is 50. The maximum value is 50.</p>', 'ListIPSetsRequest$MaxResults' => '<p>You can use this parameter to indicate the maximum number of items you want in the response. The default value is 50. The maximum value is 50.</p>', 'ListInvitationsRequest$MaxResults' => '<p>You can use this parameter to indicate the maximum number of items that you want in the response. The default value is 50. The maximum value is 50.</p>', 'ListMembersRequest$MaxResults' => '<p>You can use this parameter to indicate the maximum number of items you want in the response. The default value is 50. The maximum value is 50.</p>', 'ListOrganizationAdminAccountsRequest$MaxResults' => '<p>The maximum number of results to return in the response.</p>', 'ListPublishingDestinationsRequest$MaxResults' => '<p>The maximum number of results to return in the response.</p>', 'ListThreatIntelSetsRequest$MaxResults' => '<p>You can use this parameter to indicate the maximum number of items that you want in the response. The default value is 50. The maximum value is 50.</p>', ], ], 'Member' => [ 'base' => '<p>Contains information about the member account. </p>', 'refs' => [ 'Members$member' => NULL, ], ], 'MemberAdditionalConfiguration' => [ 'base' => '<p>Information about the additional configuration for the member account.</p>', 'refs' => [ 'MemberAdditionalConfigurations$member' => NULL, ], ], 'MemberAdditionalConfigurationResult' => [ 'base' => '<p>Information about the additional configuration for the member account.</p>', 'refs' => [ 'MemberAdditionalConfigurationResults$member' => NULL, ], ], 'MemberAdditionalConfigurationResults' => [ 'base' => NULL, 'refs' => [ 'MemberFeaturesConfigurationResult$AdditionalConfiguration' => '<p>Indicates the additional configuration of the feature that is configured for the member account.</p>', ], ], 'MemberAdditionalConfigurations' => [ 'base' => NULL, 'refs' => [ 'MemberFeaturesConfiguration$AdditionalConfiguration' => '<p>Additional configuration of the feature for the member account.</p>', ], ], 'MemberDataSourceConfiguration' => [ 'base' => '<p>Contains information on which data sources are enabled for a member account.</p>', 'refs' => [ 'MemberDataSourceConfigurations$member' => NULL, ], ], 'MemberDataSourceConfigurations' => [ 'base' => NULL, 'refs' => [ 'GetMemberDetectorsResponse$MemberDataSourceConfigurations' => '<p>An object that describes which data sources are enabled for a member account.</p>', ], ], 'MemberFeaturesConfiguration' => [ 'base' => '<p>Contains information about the features for the member account.</p>', 'refs' => [ 'MemberFeaturesConfigurations$member' => NULL, ], ], 'MemberFeaturesConfigurationResult' => [ 'base' => '<p>Contains information about the features for the member account.</p>', 'refs' => [ 'MemberFeaturesConfigurationsResults$member' => NULL, ], ], 'MemberFeaturesConfigurations' => [ 'base' => NULL, 'refs' => [ 'UpdateMemberDetectorsRequest$Features' => '<p>A list of features that will be updated for the specified member accounts.</p>', ], ], 'MemberFeaturesConfigurationsResults' => [ 'base' => NULL, 'refs' => [ 'MemberDataSourceConfiguration$Features' => '<p>Contains information about the status of the features for the member account.</p>', ], ], 'Members' => [ 'base' => NULL, 'refs' => [ 'GetMembersResponse$Members' => '<p>A list of members.</p>', 'ListMembersResponse$Members' => '<p>A list of members.</p> <note> <p>The values for <code>email</code> and <code>invitedAt</code> are available only if the member accounts are added by invitation.</p> </note>', ], ], 'MemoryRegionsList' => [ 'base' => NULL, 'refs' => [ 'RuntimeContext$MemoryRegions' => '<p>Specifies the Region of a process\'s address space such as stack and heap.</p>', ], ], 'Name' => [ 'base' => NULL, 'refs' => [ 'CreateIPSetRequest$Name' => '<p>The user-friendly name to identify the IPSet.</p> <p> Allowed characters are alphanumeric, whitespace, dash (-), and underscores (_).</p>', 'CreateThreatIntelSetRequest$Name' => '<p>A user-friendly ThreatIntelSet name displayed in all findings that are generated by activity that involves IP addresses included in this ThreatIntelSet.</p>', 'GetIPSetResponse$Name' => '<p>The user-friendly name for the IPSet.</p>', 'GetThreatIntelSetResponse$Name' => '<p>A user-friendly ThreatIntelSet name displayed in all findings that are generated by activity that involves IP addresses included in this ThreatIntelSet.</p>', 'UpdateIPSetRequest$Name' => '<p>The unique ID that specifies the IPSet that you want to update.</p>', 'UpdateThreatIntelSetRequest$Name' => '<p>The unique ID that specifies the ThreatIntelSet that you want to update.</p>', ], ], 'Neq' => [ 'base' => NULL, 'refs' => [ 'Condition$Neq' => '<p>Represents the <i>not equal</i> condition to be applied to a single field when querying for findings.</p>', ], ], 'NetworkConnectionAction' => [ 'base' => '<p>Contains information about the NETWORK_CONNECTION action described in the finding.</p>', 'refs' => [ 'Action$NetworkConnectionAction' => '<p>Information about the NETWORK_CONNECTION action described in this finding.</p>', ], ], 'NetworkInterface' => [ 'base' => '<p>Contains information about the elastic network interface of the EC2 instance.</p>', 'refs' => [ 'NetworkInterfaces$member' => NULL, ], ], 'NetworkInterfaces' => [ 'base' => NULL, 'refs' => [ 'InstanceDetails$NetworkInterfaces' => '<p>The elastic network interface information of the EC2 instance.</p>', ], ], 'NonEmptyString' => [ 'base' => NULL, 'refs' => [ 'FilterCondition$EqualsValue' => '<p>Represents an <i>equal</i> <b/> condition to be applied to a single field when querying for scan entries.</p>', 'Scan$ScanId' => '<p>The unique scan ID associated with a scan entry.</p>', 'Scan$FailureReason' => '<p>Represents the reason for FAILED scan status.</p>', 'StartMalwareScanResponse$ScanId' => '<p>A unique identifier that gets generated when you invoke the API without any error. Each malware scan has a corresponding scan ID. Using this scan ID, you can monitor the status of your malware scan.</p>', 'TriggerDetails$GuardDutyFindingId' => '<p>The ID of the GuardDuty finding that triggered the malware scan.</p>', 'TriggerDetails$Description' => '<p>The description of the scan trigger.</p>', ], ], 'NotEquals' => [ 'base' => NULL, 'refs' => [ 'Condition$NotEquals' => '<p>Represents a <i>not equal</i> <b/> condition to be applied to a single field when querying for findings.</p>', 'CoverageFilterCondition$NotEquals' => '<p>Represents a not equal condition that is applied to a single field while retrieving the coverage details.</p>', ], ], 'ObservationTexts' => [ 'base' => NULL, 'refs' => [ 'Observations$Text' => '<p>The text that was unusual.</p>', ], ], 'Observations' => [ 'base' => '<p>Contains information about the observed behavior.</p>', 'refs' => [ 'AnomalyObject$Observations' => '<p>The recorded value.</p>', ], ], 'OrderBy' => [ 'base' => NULL, 'refs' => [ 'CoverageSortCriteria$OrderBy' => '<p>The order in which the sorted findings are to be displayed.</p>', 'SortCriteria$OrderBy' => '<p>The order by which the sorted findings are to be displayed.</p>', ], ], 'OrgFeature' => [ 'base' => NULL, 'refs' => [ 'MemberFeaturesConfiguration$Name' => '<p>The name of the feature.</p>', 'MemberFeaturesConfigurationResult$Name' => '<p>Indicates the name of the feature that is enabled for the detector.</p>', 'OrganizationFeatureConfiguration$Name' => '<p>The name of the feature that will be configured for the organization.</p>', 'OrganizationFeatureConfigurationResult$Name' => '<p>The name of the feature that is configured for the member accounts within the organization.</p>', 'OrganizationFeatureStatistics$Name' => '<p>Name of the feature.</p>', ], ], 'OrgFeatureAdditionalConfiguration' => [ 'base' => NULL, 'refs' => [ 'MemberAdditionalConfiguration$Name' => '<p>Name of the additional configuration.</p>', 'MemberAdditionalConfigurationResult$Name' => '<p>Indicates the name of the additional configuration that is set for the member account.</p>', 'OrganizationAdditionalConfiguration$Name' => '<p>The name of the additional configuration that will be configured for the organization.</p>', 'OrganizationAdditionalConfigurationResult$Name' => '<p>The name of the additional configuration that is configured for the member accounts within the organization.</p>', 'OrganizationFeatureStatisticsAdditionalConfiguration$Name' => '<p>Name of the additional configuration within a feature.</p>', ], ], 'OrgFeatureStatus' => [ 'base' => NULL, 'refs' => [ 'OrganizationAdditionalConfiguration$AutoEnable' => '<p>The status of the additional configuration that will be configured for the organization. Use one of the following values to configure the feature status for the entire organization:</p> <ul> <li> <p> <code>NEW</code>: Indicates that when a new account joins the organization, they will have the additional configuration enabled automatically. </p> </li> <li> <p> <code>ALL</code>: Indicates that all accounts in the organization have the additional configuration enabled automatically. This includes <code>NEW</code> accounts that join the organization and accounts that may have been suspended or removed from the organization in GuardDuty.</p> <p>It may take up to 24 hours to update the configuration for all the member accounts.</p> </li> <li> <p> <code>NONE</code>: Indicates that the additional configuration will not be automatically enabled for any account in the organization. The administrator must manage the additional configuration for each account individually.</p> </li> </ul>', 'OrganizationAdditionalConfigurationResult$AutoEnable' => '<p>Describes the status of the additional configuration that is configured for the member accounts within the organization. One of the following values is the status for the entire organization:</p> <ul> <li> <p> <code>NEW</code>: Indicates that when a new account joins the organization, they will have the additional configuration enabled automatically. </p> </li> <li> <p> <code>ALL</code>: Indicates that all accounts in the organization have the additional configuration enabled automatically. This includes <code>NEW</code> accounts that join the organization and accounts that may have been suspended or removed from the organization in GuardDuty.</p> <p>It may take up to 24 hours to update the configuration for all the member accounts.</p> </li> <li> <p> <code>NONE</code>: Indicates that the additional configuration will not be automatically enabled for any account in the organization. The administrator must manage the additional configuration for each account individually.</p> </li> </ul>', 'OrganizationFeatureConfiguration$AutoEnable' => '<p>Describes the status of the feature that is configured for the member accounts within the organization. One of the following values is the status for the entire organization:</p> <ul> <li> <p> <code>NEW</code>: Indicates that when a new account joins the organization, they will have the feature enabled automatically. </p> </li> <li> <p> <code>ALL</code>: Indicates that all accounts in the organization have the feature enabled automatically. This includes <code>NEW</code> accounts that join the organization and accounts that may have been suspended or removed from the organization in GuardDuty.</p> <p>It may take up to 24 hours to update the configuration for all the member accounts.</p> </li> <li> <p> <code>NONE</code>: Indicates that the feature will not be automatically enabled for any account in the organization. The administrator must manage the feature for each account individually.</p> </li> </ul>', 'OrganizationFeatureConfigurationResult$AutoEnable' => '<p>Describes the status of the feature that is configured for the member accounts within the organization.</p> <ul> <li> <p> <code>NEW</code>: Indicates that when a new account joins the organization, they will have the feature enabled automatically. </p> </li> <li> <p> <code>ALL</code>: Indicates that all accounts in the organization have the feature enabled automatically. This includes <code>NEW</code> accounts that join the organization and accounts that may have been suspended or removed from the organization in GuardDuty.</p> </li> <li> <p> <code>NONE</code>: Indicates that the feature will not be automatically enabled for any account in the organization. In this case, each account will be managed individually by the administrator.</p> </li> </ul>', ], ], 'Organization' => [ 'base' => '<p>Contains information about the ISP organization of the remote IP address.</p>', 'refs' => [ 'RemoteIpDetails$Organization' => '<p>The ISP organization information of the remote IP address.</p>', ], ], 'OrganizationAdditionalConfiguration' => [ 'base' => '<p>A list of additional configurations which will be configured for the organization. </p>', 'refs' => [ 'OrganizationAdditionalConfigurations$member' => NULL, ], ], 'OrganizationAdditionalConfigurationResult' => [ 'base' => '<p>A list of additional configuration which will be configured for the organization.</p>', 'refs' => [ 'OrganizationAdditionalConfigurationResults$member' => NULL, ], ], 'OrganizationAdditionalConfigurationResults' => [ 'base' => NULL, 'refs' => [ 'OrganizationFeatureConfigurationResult$AdditionalConfiguration' => '<p>The additional configuration that is configured for the member accounts within the organization.</p>', ], ], 'OrganizationAdditionalConfigurations' => [ 'base' => NULL, 'refs' => [ 'OrganizationFeatureConfiguration$AdditionalConfiguration' => '<p>The additional information that will be configured for the organization.</p>', ], ], 'OrganizationDataSourceConfigurations' => [ 'base' => '<p>An object that contains information on which data sources will be configured to be automatically enabled for new members within the organization.</p>', 'refs' => [ 'UpdateOrganizationConfigurationRequest$DataSources' => '<p>Describes which data sources will be updated.</p>', ], ], 'OrganizationDataSourceConfigurationsResult' => [ 'base' => '<p>An object that contains information on which data sources are automatically enabled for new members within the organization.</p>', 'refs' => [ 'DescribeOrganizationConfigurationResponse$DataSources' => '<p>Describes which data sources are enabled automatically for member accounts.</p>', ], ], 'OrganizationDetails' => [ 'base' => '<p>Information about GuardDuty coverage statistics for members in your Amazon Web Services organization.</p>', 'refs' => [ 'GetOrganizationStatisticsResponse$OrganizationDetails' => '<p>Information about the statistics report for your organization.</p>', ], ], 'OrganizationEbsVolumes' => [ 'base' => '<p>Organization-wide EBS volumes scan configuration.</p>', 'refs' => [ 'OrganizationScanEc2InstanceWithFindings$EbsVolumes' => '<p>Whether scanning EBS volumes should be auto-enabled for new members joining the organization.</p>', ], ], 'OrganizationEbsVolumesResult' => [ 'base' => '<p>An object that contains information on the status of whether EBS volumes scanning will be enabled as a data source for an organization.</p>', 'refs' => [ 'OrganizationScanEc2InstanceWithFindingsResult$EbsVolumes' => '<p>Describes the configuration for scanning EBS volumes for an organization.</p>', ], ], 'OrganizationFeatureConfiguration' => [ 'base' => '<p>A list of features which will be configured for the organization.</p>', 'refs' => [ 'OrganizationFeaturesConfigurations$member' => NULL, ], ], 'OrganizationFeatureConfigurationResult' => [ 'base' => '<p>A list of features which will be configured for the organization.</p>', 'refs' => [ 'OrganizationFeaturesConfigurationsResults$member' => NULL, ], ], 'OrganizationFeatureStatistics' => [ 'base' => '<p>Information about the number of accounts that have enabled a specific feature.</p>', 'refs' => [ 'OrganizationFeatureStatisticsResults$member' => NULL, ], ], 'OrganizationFeatureStatisticsAdditionalConfiguration' => [ 'base' => '<p>Information about the coverage statistic for the additional configuration of the feature.</p>', 'refs' => [ 'OrganizationFeatureStatisticsAdditionalConfigurations$member' => NULL, ], ], 'OrganizationFeatureStatisticsAdditionalConfigurations' => [ 'base' => NULL, 'refs' => [ 'OrganizationFeatureStatistics$AdditionalConfiguration' => '<p>Name of the additional configuration.</p>', ], ], 'OrganizationFeatureStatisticsResults' => [ 'base' => NULL, 'refs' => [ 'OrganizationStatistics$CountByFeature' => '<p>Retrieves the coverage statistics for each feature.</p>', ], ], 'OrganizationFeaturesConfigurations' => [ 'base' => NULL, 'refs' => [ 'UpdateOrganizationConfigurationRequest$Features' => '<p>A list of features that will be configured for the organization.</p>', ], ], 'OrganizationFeaturesConfigurationsResults' => [ 'base' => NULL, 'refs' => [ 'DescribeOrganizationConfigurationResponse$Features' => '<p>A list of features that are configured for this organization.</p>', ], ], 'OrganizationKubernetesAuditLogsConfiguration' => [ 'base' => '<p>Organization-wide Kubernetes audit logs configuration.</p>', 'refs' => [ 'OrganizationKubernetesConfiguration$AuditLogs' => '<p>Whether Kubernetes audit logs data source should be auto-enabled for new members joining the organization.</p>', ], ], 'OrganizationKubernetesAuditLogsConfigurationResult' => [ 'base' => '<p>The current configuration of Kubernetes audit logs as a data source for the organization.</p>', 'refs' => [ 'OrganizationKubernetesConfigurationResult$AuditLogs' => '<p>The current configuration of Kubernetes audit logs as a data source for the organization.</p>', ], ], 'OrganizationKubernetesConfiguration' => [ 'base' => '<p>Organization-wide Kubernetes data sources configurations.</p>', 'refs' => [ 'OrganizationDataSourceConfigurations$Kubernetes' => '<p>Describes the configuration of Kubernetes data sources for new members of the organization.</p>', ], ], 'OrganizationKubernetesConfigurationResult' => [ 'base' => '<p>The current configuration of all Kubernetes data sources for the organization.</p>', 'refs' => [ 'OrganizationDataSourceConfigurationsResult$Kubernetes' => '<p>Describes the configuration of Kubernetes data sources.</p>', ], ], 'OrganizationMalwareProtectionConfiguration' => [ 'base' => '<p>Organization-wide Malware Protection configurations.</p>', 'refs' => [ 'OrganizationDataSourceConfigurations$MalwareProtection' => '<p>Describes the configuration of Malware Protection for new members of the organization.</p>', ], ], 'OrganizationMalwareProtectionConfigurationResult' => [ 'base' => '<p>An object that contains information on the status of all Malware Protection data source for an organization.</p>', 'refs' => [ 'OrganizationDataSourceConfigurationsResult$MalwareProtection' => '<p>Describes the configuration of Malware Protection data source for an organization.</p>', ], ], 'OrganizationS3LogsConfiguration' => [ 'base' => '<p>Describes whether S3 data event logs will be automatically enabled for new members of the organization.</p>', 'refs' => [ 'OrganizationDataSourceConfigurations$S3Logs' => '<p>Describes whether S3 data event logs are enabled for new members of the organization.</p>', ], ], 'OrganizationS3LogsConfigurationResult' => [ 'base' => '<p>The current configuration of S3 data event logs as a data source for the organization.</p>', 'refs' => [ 'OrganizationDataSourceConfigurationsResult$S3Logs' => '<p>Describes whether S3 data event logs are enabled as a data source.</p>', ], ], 'OrganizationScanEc2InstanceWithFindings' => [ 'base' => '<p>Organization-wide EC2 instances with findings scan configuration.</p>', 'refs' => [ 'OrganizationMalwareProtectionConfiguration$ScanEc2InstanceWithFindings' => '<p>Whether Malware Protection for EC2 instances with findings should be auto-enabled for new members joining the organization.</p>', ], ], 'OrganizationScanEc2InstanceWithFindingsResult' => [ 'base' => '<p>An object that contains information on the status of scanning EC2 instances with findings for an organization.</p>', 'refs' => [ 'OrganizationMalwareProtectionConfigurationResult$ScanEc2InstanceWithFindings' => '<p>Describes the configuration for scanning EC2 instances with findings for an organization.</p>', ], ], 'OrganizationStatistics' => [ 'base' => '<p>Information about the coverage statistics of the features for the entire Amazon Web Services organization.</p> <p>When you create a new Amazon Web Services organization, it might take up to 24 hours to generate the statistics summary for this organization.</p>', 'refs' => [ 'OrganizationDetails$OrganizationStatistics' => '<p>Information about the GuardDuty coverage statistics for members in your Amazon Web Services organization.</p>', ], ], 'Owner' => [ 'base' => '<p>Contains information on the owner of the bucket.</p>', 'refs' => [ 'S3BucketDetail$Owner' => '<p>The owner of the S3 bucket.</p>', ], ], 'PermissionConfiguration' => [ 'base' => '<p>Contains information about how permissions are configured for the S3 bucket.</p>', 'refs' => [ 'PublicAccess$PermissionConfiguration' => '<p>Contains information about how permissions are configured for the S3 bucket.</p>', ], ], 'PortProbeAction' => [ 'base' => '<p>Contains information about the PORT_PROBE action described in the finding.</p>', 'refs' => [ 'Action$PortProbeAction' => '<p>Information about the PORT_PROBE action described in this finding.</p>', ], ], 'PortProbeDetail' => [ 'base' => '<p>Contains information about the port probe details.</p>', 'refs' => [ 'PortProbeDetails$member' => NULL, ], ], 'PortProbeDetails' => [ 'base' => NULL, 'refs' => [ 'PortProbeAction$PortProbeDetails' => '<p>A list of objects related to port probe details.</p>', ], ], 'PositiveLong' => [ 'base' => NULL, 'refs' => [ 'Scan$TotalBytes' => '<p>Represents total bytes that were scanned.</p>', 'Scan$FileCount' => '<p>Represents the number of files that were scanned.</p>', ], ], 'PrivateIpAddressDetails' => [ 'base' => '<p>Contains other private IP address information of the EC2 instance.</p>', 'refs' => [ 'PrivateIpAddresses$member' => NULL, ], ], 'PrivateIpAddresses' => [ 'base' => NULL, 'refs' => [ 'NetworkInterface$PrivateIpAddresses' => '<p>Other private IP address information of the EC2 instance.</p>', ], ], 'ProcessDetails' => [ 'base' => '<p>Information about the observed process.</p>', 'refs' => [ 'RuntimeContext$ModifyingProcess' => '<p>Information about the process that modified the current process. This is available for multiple finding types.</p>', 'RuntimeContext$TargetProcess' => '<p>Information about the process that had its memory overwritten by the current process.</p>', 'RuntimeDetails$Process' => '<p>Information about the observed process.</p>', ], ], 'ProductCode' => [ 'base' => '<p>Contains information about the product code for the EC2 instance.</p>', 'refs' => [ 'ProductCodes$member' => NULL, ], ], 'ProductCodes' => [ 'base' => NULL, 'refs' => [ 'InstanceDetails$ProductCodes' => '<p>The product code of the EC2 instance.</p>', ], ], 'ProfileSubtype' => [ 'base' => NULL, 'refs' => [ 'AnomalyObject$ProfileSubtype' => '<p>The frequency of the anomaly.</p>', ], ], 'ProfileType' => [ 'base' => NULL, 'refs' => [ 'AnomalyObject$ProfileType' => '<p>The type of behavior of the profile.</p>', ], ], 'PublicAccess' => [ 'base' => '<p>Describes the public access policies that apply to the S3 bucket.</p>', 'refs' => [ 'S3BucketDetail$PublicAccess' => '<p>Describes the public access policies that apply to the S3 bucket.</p>', ], ], 'PublishingStatus' => [ 'base' => NULL, 'refs' => [ 'DescribePublishingDestinationResponse$Status' => '<p>The status of the publishing destination.</p>', 'Destination$Status' => '<p>The status of the publishing destination.</p>', ], ], 'RdsDbInstanceDetails' => [ 'base' => '<p>Contains information about the resource type <code>RDSDBInstance</code> involved in a GuardDuty finding.</p>', 'refs' => [ 'Resource$RdsDbInstanceDetails' => '<p>Contains information about the database instance to which an anomalous login attempt was made.</p>', ], ], 'RdsDbUserDetails' => [ 'base' => '<p>Contains information about the user and authentication details for a database instance involved in the finding.</p>', 'refs' => [ 'Resource$RdsDbUserDetails' => '<p>Contains information about the user details through which anomalous login attempt was made.</p>', ], ], 'RdsLoginAttemptAction' => [ 'base' => '<p>Indicates that a login attempt was made to the potentially compromised database from a remote IP address.</p>', 'refs' => [ 'Action$RdsLoginAttemptAction' => '<p>Information about <code>RDS_LOGIN_ATTEMPT</code> action described in this finding.</p>', ], ], 'RemoteAccountDetails' => [ 'base' => '<p>Contains details about the remote Amazon Web Services account that made the API call.</p>', 'refs' => [ 'AwsApiCallAction$RemoteAccountDetails' => '<p>The details of the Amazon Web Services account that made the API call. This field appears if the call was made from outside your account.</p>', ], ], 'RemoteIpDetails' => [ 'base' => '<p>Contains information about the remote IP address of the connection.</p>', 'refs' => [ 'AwsApiCallAction$RemoteIpDetails' => '<p>The remote IP information of the connection that initiated the Amazon Web Services API call.</p>', 'KubernetesApiCallAction$RemoteIpDetails' => NULL, 'NetworkConnectionAction$RemoteIpDetails' => '<p>The remote IP information of the connection.</p>', 'PortProbeDetail$RemoteIpDetails' => '<p>The remote IP information of the connection.</p>', 'RdsLoginAttemptAction$RemoteIpDetails' => NULL, ], ], 'RemotePortDetails' => [ 'base' => '<p>Contains information about the remote port.</p>', 'refs' => [ 'NetworkConnectionAction$RemotePortDetails' => '<p>The remote port information of the connection.</p>', ], ], 'Resource' => [ 'base' => '<p>Contains information about the Amazon Web Services resource associated with the activity that prompted GuardDuty to generate a finding.</p>', 'refs' => [ 'Finding$Resource' => NULL, ], ], 'ResourceArn' => [ 'base' => NULL, 'refs' => [ 'StartMalwareScanRequest$ResourceArn' => '<p>Amazon Resource Name (ARN) of the resource for which you invoked the API.</p>', ], ], 'ResourceDetails' => [ 'base' => '<p>Represents the resources that were scanned in the scan entry.</p>', 'refs' => [ 'Scan$ResourceDetails' => '<p>Represents the resources that were scanned in the scan entry.</p>', ], ], 'ResourceList' => [ 'base' => NULL, 'refs' => [ 'UsageCriteria$Resources' => '<p>The resources to aggregate usage statistics from. Only accepts exact resource names.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The requested resource can\'t be found.</p>', 'refs' => [], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'CountByResourceType$key' => NULL, 'CoverageResourceDetails$ResourceType' => '<p>The type of Amazon Web Services resource.</p>', ], ], 'RuntimeContext' => [ 'base' => '<p>Additional information about the suspicious activity.</p>', 'refs' => [ 'RuntimeDetails$Context' => '<p>Additional information about the suspicious activity.</p>', ], ], 'RuntimeDetails' => [ 'base' => '<p>Information about the process and any required context values for a specific finding.</p>', 'refs' => [ 'Service$RuntimeDetails' => '<p>Information about the process and any required context values for a specific finding</p>', ], ], 'S3BucketDetail' => [ 'base' => '<p>Contains information on the S3 bucket.</p>', 'refs' => [ 'S3BucketDetails$member' => NULL, ], ], 'S3BucketDetails' => [ 'base' => NULL, 'refs' => [ 'Resource$S3BucketDetails' => '<p>Contains information on the S3 bucket.</p>', ], ], 'S3LogsConfiguration' => [ 'base' => '<p>Describes whether S3 data event logs will be enabled as a data source.</p>', 'refs' => [ 'DataSourceConfigurations$S3Logs' => '<p>Describes whether S3 data event logs are enabled as a data source.</p>', ], ], 'S3LogsConfigurationResult' => [ 'base' => '<p>Describes whether S3 data event logs will be enabled as a data source.</p>', 'refs' => [ 'DataSourceConfigurationsResult$S3Logs' => '<p>An object that contains information on the status of S3 Data event logs as a data source.</p>', ], ], 'S3ObjectDetail' => [ 'base' => '<p>Information about the S3 object that was scanned</p>', 'refs' => [ 'S3ObjectDetails$member' => NULL, ], ], 'S3ObjectDetails' => [ 'base' => NULL, 'refs' => [ 'S3BucketDetail$S3ObjectDetails' => '<p>Information about the S3 object that was scanned.</p>', ], ], 'Scan' => [ 'base' => '<p>Contains information about a malware scan.</p>', 'refs' => [ 'Scans$member' => NULL, ], ], 'ScanCondition' => [ 'base' => '<p>Contains information about the condition.</p>', 'refs' => [ 'ScanCriterion$value' => NULL, ], ], 'ScanConditionPair' => [ 'base' => '<p>Represents the <code>key:value</code> pair to be matched against given resource property.</p>', 'refs' => [ 'MapEquals$member' => NULL, ], ], 'ScanCriterion' => [ 'base' => '<p>Represents a map of resource properties that match specified conditions and values when triggering malware scans.</p>', 'refs' => [ 'ScanResourceCriteria$Include' => '<p>Represents condition that when matched will allow a malware scan for a certain resource.</p>', 'ScanResourceCriteria$Exclude' => '<p>Represents condition that when matched will prevent a malware scan for a certain resource.</p>', ], ], 'ScanCriterionKey' => [ 'base' => '<p>An enum value representing possible resource properties to match with given scan condition.</p>', 'refs' => [ 'ScanCriterion$key' => NULL, ], ], 'ScanDetections' => [ 'base' => '<p>Contains a complete view providing malware scan result details.</p>', 'refs' => [ 'EbsVolumeScanDetails$ScanDetections' => '<p>Contains a complete view providing malware scan result details.</p>', ], ], 'ScanEc2InstanceWithFindings' => [ 'base' => '<p>Describes whether Malware Protection for EC2 instances with findings will be enabled as a data source.</p>', 'refs' => [ 'MalwareProtectionConfiguration$ScanEc2InstanceWithFindings' => '<p>Describes the configuration of Malware Protection for EC2 instances with findings.</p>', ], ], 'ScanEc2InstanceWithFindingsResult' => [ 'base' => '<p>An object that contains information on the status of whether Malware Protection for EC2 instances with findings will be enabled as a data source.</p>', 'refs' => [ 'MalwareProtectionConfigurationResult$ScanEc2InstanceWithFindings' => '<p>Describes the configuration of Malware Protection for EC2 instances with findings.</p>', ], ], 'ScanFilePath' => [ 'base' => '<p>Contains details of infected file including name, file path and hash.</p>', 'refs' => [ 'FilePaths$member' => NULL, ], ], 'ScanResourceCriteria' => [ 'base' => '<p>Contains information about criteria used to filter resources before triggering malware scan.</p>', 'refs' => [ 'GetMalwareScanSettingsResponse$ScanResourceCriteria' => '<p>Represents the criteria to be used in the filter for scanning resources.</p>', 'UpdateMalwareScanSettingsRequest$ScanResourceCriteria' => '<p>Represents the criteria to be used in the filter for selecting resources to scan.</p>', ], ], 'ScanResult' => [ 'base' => NULL, 'refs' => [ 'ScanResultDetails$ScanResult' => '<p>An enum value representing possible scan results.</p>', ], ], 'ScanResultDetails' => [ 'base' => '<p>Represents the result of the scan.</p>', 'refs' => [ 'Scan$ScanResultDetails' => '<p>Represents the result of the scan.</p>', ], ], 'ScanStatus' => [ 'base' => NULL, 'refs' => [ 'Scan$ScanStatus' => '<p>An enum value representing possible scan statuses.</p>', ], ], 'ScanThreatName' => [ 'base' => '<p>Contains files infected with the given threat providing details of malware name and severity.</p>', 'refs' => [ 'ScanThreatNames$member' => NULL, ], ], 'ScanThreatNames' => [ 'base' => NULL, 'refs' => [ 'ThreatDetectedByName$ThreatNames' => '<p>List of identified threats with details, organized by threat name.</p>', ], ], 'ScanType' => [ 'base' => NULL, 'refs' => [ 'EbsVolumeScanDetails$ScanType' => '<p>Specifies the scan type that invoked the malware scan.</p>', 'Scan$ScanType' => '<p>Specifies the scan type that invoked the malware scan.</p>', ], ], 'ScannedItemCount' => [ 'base' => '<p>Total number of scanned files.</p>', 'refs' => [ 'ScanDetections$ScannedItemCount' => '<p>Total number of scanned files.</p>', ], ], 'Scans' => [ 'base' => NULL, 'refs' => [ 'DescribeMalwareScansResponse$Scans' => '<p>Contains information about malware scans.</p>', ], ], 'SecurityContext' => [ 'base' => '<p>Container security context.</p>', 'refs' => [ 'Container$SecurityContext' => '<p>Container security context.</p>', ], ], 'SecurityGroup' => [ 'base' => '<p>Contains information about the security groups associated with the EC2 instance.</p>', 'refs' => [ 'SecurityGroups$member' => NULL, ], ], 'SecurityGroups' => [ 'base' => NULL, 'refs' => [ 'NetworkInterface$SecurityGroups' => '<p>The security groups associated with the EC2 instance.</p>', 'VpcConfig$SecurityGroups' => '<p>The identifier of the security group attached to the Lambda function.</p>', ], ], 'SensitiveString' => [ 'base' => NULL, 'refs' => [ 'LocalIpDetails$IpAddressV4' => '<p>The IPv4 local address of the connection.</p>', 'LocalIpDetails$IpAddressV6' => '<p>The IPv6 local address of the connection.</p>', 'NetworkInterface$PrivateIpAddress' => '<p>The private IP address of the EC2 instance.</p>', 'PrivateIpAddressDetails$PrivateIpAddress' => '<p>The private IP address of the EC2 instance.</p>', 'RemoteIpDetails$IpAddressV4' => '<p>The IPv4 remote address of the connection.</p>', 'RemoteIpDetails$IpAddressV6' => '<p>The IPv6 remote address of the connection.</p>', ], ], 'Service' => [ 'base' => '<p>Contains additional information about the generated finding.</p>', 'refs' => [ 'Finding$Service' => NULL, ], ], 'ServiceAdditionalInfo' => [ 'base' => '<p>Additional information about the generated finding.</p>', 'refs' => [ 'Service$AdditionalInfo' => '<p>Contains additional information about the generated finding.</p>', ], ], 'SessionNameList' => [ 'base' => NULL, 'refs' => [ 'KubernetesUserDetails$SessionName' => '<p>Entity that assumes the IAM role when Kubernetes RBAC permissions are assigned to that role.</p>', ], ], 'SortCriteria' => [ 'base' => '<p>Contains information about the criteria used for sorting findings.</p>', 'refs' => [ 'DescribeMalwareScansRequest$SortCriteria' => '<p>Represents the criteria used for sorting scan entries. The <a href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_SortCriteria.html#guardduty-Type-SortCriteria-attributeName"> <code>attributeName</code> </a> is required and it must be <code>scanStartTime</code>.</p>', 'GetFindingsRequest$SortCriteria' => '<p>Represents the criteria used for sorting findings.</p>', 'ListFindingsRequest$SortCriteria' => '<p>Represents the criteria used for sorting findings.</p>', ], ], 'SourceIps' => [ 'base' => NULL, 'refs' => [ 'KubernetesApiCallAction$SourceIps' => '<p>The IP of the Kubernetes API caller and the IPs of any proxies or load balancers between the caller and the API endpoint.</p>', ], ], 'Sources' => [ 'base' => NULL, 'refs' => [ 'EbsVolumeScanDetails$Sources' => '<p>Contains list of threat intelligence sources used to detect threats.</p>', ], ], 'StartMalwareScanRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartMalwareScanResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartMonitoringMembersRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartMonitoringMembersResponse' => [ 'base' => NULL, 'refs' => [], ], 'StopMonitoringMembersRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopMonitoringMembersResponse' => [ 'base' => NULL, 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AcceptAdministratorInvitationRequest$AdministratorId' => '<p>The account ID of the GuardDuty administrator account whose invitation you\'re accepting.</p>', 'AcceptAdministratorInvitationRequest$InvitationId' => '<p>The value that is used to validate the administrator account to the member account.</p>', 'AcceptInvitationRequest$MasterId' => '<p>The account ID of the GuardDuty administrator account whose invitation you\'re accepting.</p>', 'AcceptInvitationRequest$InvitationId' => '<p>The value that is used to validate the administrator account to the member account.</p>', 'AccessDeniedException$Message' => '<p>The error message.</p>', 'AccessDeniedException$Type' => '<p>The error type.</p>', 'AccessKeyDetails$AccessKeyId' => '<p>The access key ID of the user.</p>', 'AccessKeyDetails$PrincipalId' => '<p>The principal ID of the user.</p>', 'AccessKeyDetails$UserName' => '<p>The name of the user.</p>', 'AccessKeyDetails$UserType' => '<p>The type of the user.</p>', 'AccountFreeTrialInfo$AccountId' => '<p>The account identifier of the GuardDuty member account.</p>', 'Action$ActionType' => '<p>The GuardDuty finding activity type.</p>', 'AddonDetails$AddonVersion' => '<p>Version of the installed EKS add-on.</p>', 'AddonDetails$AddonStatus' => '<p>Status of the installed EKS add-on.</p>', 'AdminAccount$AdminAccountId' => '<p>The Amazon Web Services account ID for the account.</p>', 'Administrator$InvitationId' => '<p>The value that is used to validate the administrator account to the member account.</p>', 'Administrator$RelationshipStatus' => '<p>The status of the relationship between the administrator and member accounts.</p>', 'Administrator$InvitedAt' => '<p>The timestamp when the invitation was sent.</p>', 'AffectedResources$key' => NULL, 'AffectedResources$value' => NULL, 'AgentDetails$Version' => '<p>Version of the installed GuardDuty security agent.</p>', 'AnomalyProfileFeatures$key' => NULL, 'AnomalyProfiles$key' => NULL, 'AnomalyUnusualBehaviorFeature$key' => NULL, 'AwsApiCallAction$Api' => '<p>The Amazon Web Services API name.</p>', 'AwsApiCallAction$CallerType' => '<p>The Amazon Web Services API caller type.</p>', 'AwsApiCallAction$ErrorCode' => '<p>The error code of the failed Amazon Web Services API action.</p>', 'AwsApiCallAction$UserAgent' => '<p>The agent through which the API request was made.</p>', 'AwsApiCallAction$ServiceName' => '<p>The Amazon Web Services service name whose API was invoked.</p>', 'BadRequestException$Message' => '<p>The error message.</p>', 'BadRequestException$Type' => '<p>The error type.</p>', 'Behavior$key' => NULL, 'City$CityName' => '<p>The city name of the remote IP address.</p>', 'ConflictException$Message' => '<p>The error message.</p>', 'ConflictException$Type' => '<p>The error type.</p>', 'Container$ContainerRuntime' => '<p>The container runtime (such as, Docker or containerd) used to run the container.</p>', 'Container$Id' => '<p>Container ID.</p>', 'Container$Name' => '<p>Container name.</p>', 'Container$Image' => '<p>Container image.</p>', 'Container$ImagePrefix' => '<p>Part of the image name before the last slash. For example, imagePrefix for public.ecr.aws/amazonlinux/amazonlinux:latest would be public.ecr.aws/amazonlinux. If the image name is relative and does not have a slash, this field is empty.</p>', 'CountBySeverity$key' => NULL, 'Country$CountryCode' => '<p>The country code of the remote IP address.</p>', 'Country$CountryName' => '<p>The country name of the remote IP address.</p>', 'CoverageEc2InstanceDetails$InstanceId' => '<p>The Amazon EC2 instance ID.</p>', 'CoverageEc2InstanceDetails$InstanceType' => '<p>The instance type of the Amazon EC2 instance.</p>', 'CoverageEc2InstanceDetails$ClusterArn' => '<p>The cluster ARN of the Amazon ECS cluster running on the Amazon EC2 instance.</p>', 'CoverageEcsClusterDetails$ClusterName' => '<p>The name of the Amazon ECS cluster.</p>', 'CoverageEksClusterDetails$ClusterName' => '<p>Name of the EKS cluster.</p>', 'CoverageResource$ResourceId' => '<p>The unique ID of the resource.</p>', 'CoverageResource$Issue' => '<p>Represents the reason why a coverage status was <code>UNHEALTHY</code> for the EKS cluster.</p>', 'CreateIPSetResponse$IpSetId' => '<p>The ID of the IPSet resource.</p>', 'CreateMalwareProtectionPlanRequest$Role' => '<p>IAM role with permissions required to scan and add tags to the associated protected resource.</p>', 'CreateMalwareProtectionPlanResponse$MalwareProtectionPlanId' => '<p>A unique identifier associated with the Malware Protection plan resource.</p>', 'CreatePublishingDestinationResponse$DestinationId' => '<p>The ID of the publishing destination that is created.</p>', 'CreateS3BucketResource$BucketName' => '<p>Name of the S3 bucket.</p>', 'CreateThreatIntelSetResponse$ThreatIntelSetId' => '<p>The ID of the ThreatIntelSet resource.</p>', 'Criterion$key' => NULL, 'DefaultServerSideEncryption$EncryptionType' => '<p>The type of encryption used for objects within the S3 bucket.</p>', 'DefaultServerSideEncryption$KmsMasterKeyArn' => '<p>The Amazon Resource Name (ARN) of the KMS encryption key. Only available if the bucket <code>EncryptionType</code> is <code>aws:kms</code>.</p>', 'DeleteFilterRequest$FilterName' => '<p>The name of the filter that you want to delete.</p>', 'DeleteIPSetRequest$IpSetId' => '<p>The unique ID of the IPSet to delete.</p>', 'DeleteMalwareProtectionPlanRequest$MalwareProtectionPlanId' => '<p>A unique identifier associated with Malware Protection plan resource.</p>', 'DeletePublishingDestinationRequest$DestinationId' => '<p>The ID of the publishing destination to delete.</p>', 'DeleteThreatIntelSetRequest$ThreatIntelSetId' => '<p>The unique ID of the threatIntelSet that you want to delete.</p>', 'DescribeMalwareScansRequest$NextToken' => '<p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the list action. For subsequent calls to the action, fill nextToken in the request with the value of NextToken from the previous response to continue listing data.</p>', 'DescribeMalwareScansResponse$NextToken' => '<p>The pagination parameter to be used on the next list operation to retrieve more items.</p>', 'DescribeOrganizationConfigurationRequest$NextToken' => '<p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the list action. For subsequent calls to the action, fill <code>nextToken</code> in the request with the value of <code>NextToken</code> from the previous response to continue listing data.</p>', 'DescribeOrganizationConfigurationResponse$NextToken' => '<p>The pagination parameter to be used on the next list operation to retrieve more items.</p>', 'DescribePublishingDestinationRequest$DestinationId' => '<p>The ID of the publishing destination to retrieve.</p>', 'DescribePublishingDestinationResponse$DestinationId' => '<p>The ID of the publishing destination.</p>', 'Destination$DestinationId' => '<p>The unique ID of the publishing destination.</p>', 'DestinationProperties$DestinationArn' => '<p>The ARN of the resource to publish to.</p> <p>To specify an S3 bucket folder use the following format: <code>arn:aws:s3:::DOC-EXAMPLE-BUCKET/myFolder/</code> </p>', 'DestinationProperties$KmsKeyArn' => '<p>The ARN of the KMS key to use for encryption.</p>', 'DisableOrganizationAdminAccountRequest$AdminAccountId' => '<p>The Amazon Web Services Account ID for the organizations account to be disabled as a GuardDuty delegated administrator.</p>', 'DnsRequestAction$Domain' => '<p>The domain information for the DNS query.</p>', 'DnsRequestAction$Protocol' => '<p>The network connection protocol observed in the activity that prompted GuardDuty to generate the finding.</p>', 'DnsRequestAction$DomainWithSuffix' => '<p>The second and top level domain involved in the activity that potentially prompted GuardDuty to generate this finding. For a list of top-level and second-level domains, see <a href="https://publicsuffix.org/">public suffix list</a>.</p>', 'DomainDetails$Domain' => '<p>The domain information for the Amazon Web Services API call.</p>', 'EbsVolumeScanDetails$ScanId' => '<p>Unique Id of the malware scan that generated the finding.</p>', 'EbsVolumeScanDetails$TriggerFindingId' => '<p>GuardDuty finding ID that triggered a malware scan.</p>', 'EbsVolumesResult$Reason' => '<p>Specifies the reason why scanning EBS volumes (Malware Protection) was not enabled as a data source.</p>', 'EcsClusterDetails$Name' => '<p>The name of the ECS Cluster.</p>', 'EcsClusterDetails$Arn' => '<p>The Amazon Resource Name (ARN) that identifies the cluster.</p>', 'EcsClusterDetails$Status' => '<p>The status of the ECS cluster.</p>', 'EcsTaskDetails$Arn' => '<p>The Amazon Resource Name (ARN) of the task.</p>', 'EcsTaskDetails$DefinitionArn' => '<p>The ARN of the task definition that creates the task.</p>', 'EcsTaskDetails$Version' => '<p>The version counter for the task.</p>', 'EcsTaskDetails$StartedBy' => '<p>Contains the tag specified when a task is started.</p>', 'EcsTaskDetails$Group' => '<p>The name of the task group that\'s associated with the task.</p>', 'EksClusterDetails$Name' => '<p>EKS cluster name.</p>', 'EksClusterDetails$Arn' => '<p>EKS cluster ARN.</p>', 'EksClusterDetails$VpcId' => '<p>The VPC ID to which the EKS cluster is attached.</p>', 'EksClusterDetails$Status' => '<p>The EKS cluster status.</p>', 'EnableOrganizationAdminAccountRequest$AdminAccountId' => '<p>The Amazon Web Services account ID for the organization account to be enabled as a GuardDuty delegated administrator.</p>', 'Eq$member' => NULL, 'Equals$member' => NULL, 'Finding$AccountId' => '<p>The ID of the account in which the finding was generated.</p>', 'Finding$Arn' => '<p>The ARN of the finding.</p>', 'Finding$CreatedAt' => '<p>The time and date when the finding was created.</p>', 'Finding$Description' => '<p>The description of the finding.</p>', 'Finding$Id' => '<p>The ID of the finding.</p>', 'Finding$Partition' => '<p>The partition associated with the finding.</p>', 'Finding$Region' => '<p>The Region where the finding was generated.</p>', 'Finding$SchemaVersion' => '<p>The version of the schema used for the finding.</p>', 'Finding$Title' => '<p>The title of the finding.</p>', 'Finding$UpdatedAt' => '<p>The time and date when the finding was last updated.</p>', 'FlagsList$member' => NULL, 'GetDetectorResponse$CreatedAt' => '<p>The timestamp of when the detector was created.</p>', 'GetDetectorResponse$ServiceRole' => '<p>The GuardDuty service role.</p>', 'GetDetectorResponse$UpdatedAt' => '<p>The last-updated timestamp for the detector.</p>', 'GetFilterRequest$FilterName' => '<p>The name of the filter you want to get.</p>', 'GetIPSetRequest$IpSetId' => '<p>The unique ID of the IPSet to retrieve.</p>', 'GetMalwareProtectionPlanRequest$MalwareProtectionPlanId' => '<p>A unique identifier associated with Malware Protection plan resource.</p>', 'GetMalwareProtectionPlanResponse$Arn' => '<p>Amazon Resource Name (ARN) of the protected resource.</p>', 'GetMalwareProtectionPlanResponse$Role' => '<p>IAM role that includes the permissions required to scan and add tags to the associated protected resource.</p>', 'GetThreatIntelSetRequest$ThreatIntelSetId' => '<p>The unique ID of the threatIntelSet that you want to get.</p>', 'GetUsageStatisticsRequest$Unit' => '<p>The currency unit you would like to view your usage statistics in. Current valid values are USD.</p>', 'GetUsageStatisticsRequest$NextToken' => '<p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the NextToken value returned from the previous request to continue listing results after the first page.</p>', 'GetUsageStatisticsResponse$NextToken' => '<p>The pagination parameter to be used on the next list operation to retrieve more items.</p>', 'Groups$member' => NULL, 'HighestSeverityThreatDetails$Severity' => '<p>Severity level of the highest severity threat detected.</p>', 'HighestSeverityThreatDetails$ThreatName' => '<p>Threat name of the highest severity threat detected as part of the malware scan.</p>', 'HostPath$Path' => '<p>Path of the file or directory on the host that the volume maps to.</p>', 'IamInstanceProfile$Arn' => '<p>The profile ARN of the EC2 instance.</p>', 'IamInstanceProfile$Id' => '<p>The profile ID of the EC2 instance.</p>', 'ImpersonatedUser$Username' => '<p>Information about the <code>username</code> that was being impersonated.</p>', 'InstanceDetails$AvailabilityZone' => '<p>The Availability Zone of the EC2 instance.</p>', 'InstanceDetails$ImageDescription' => '<p>The image description of the EC2 instance.</p>', 'InstanceDetails$ImageId' => '<p>The image ID of the EC2 instance.</p>', 'InstanceDetails$InstanceId' => '<p>The ID of the EC2 instance.</p>', 'InstanceDetails$InstanceState' => '<p>The state of the EC2 instance.</p>', 'InstanceDetails$InstanceType' => '<p>The type of the EC2 instance.</p>', 'InstanceDetails$OutpostArn' => '<p>The Amazon Resource Name (ARN) of the Amazon Web Services Outpost. Only applicable to Amazon Web Services Outposts instances.</p>', 'InstanceDetails$LaunchTime' => '<p>The launch time of the EC2 instance.</p>', 'InstanceDetails$Platform' => '<p>The platform of the EC2 instance.</p>', 'InternalServerErrorException$Message' => '<p>The error message.</p>', 'InternalServerErrorException$Type' => '<p>The error type.</p>', 'Invitation$InvitationId' => '<p>The ID of the invitation. This value is used to validate the inviter account to the member account.</p>', 'Invitation$RelationshipStatus' => '<p>The status of the relationship between the inviter and invitee accounts.</p>', 'Invitation$InvitedAt' => '<p>The timestamp when the invitation was sent.</p>', 'InviteMembersRequest$Message' => '<p>The invitation message that you want to send to the accounts that you\'re inviting to GuardDuty as members.</p>', 'IpSetIds$member' => NULL, 'Ipv6Addresses$member' => NULL, 'Issues$member' => NULL, 'ItemPath$NestedItemPath' => '<p>The nested item path where the infected file was found.</p>', 'ItemPath$Hash' => '<p>The hash value of the infected resource.</p>', 'KubernetesApiCallAction$RequestUri' => '<p>The Kubernetes API request URI.</p>', 'KubernetesApiCallAction$Verb' => '<p>The Kubernetes API request HTTP verb.</p>', 'KubernetesApiCallAction$UserAgent' => '<p>The user agent of the caller of the Kubernetes API.</p>', 'KubernetesApiCallAction$Parameters' => '<p>Parameters related to the Kubernetes API call action.</p>', 'KubernetesApiCallAction$Resource' => '<p>The resource component in the Kubernetes API call action.</p>', 'KubernetesApiCallAction$Subresource' => '<p>The name of the sub-resource in the Kubernetes API call action.</p>', 'KubernetesApiCallAction$Namespace' => '<p>The name of the namespace where the Kubernetes API call action takes place.</p>', 'KubernetesApiCallAction$ResourceName' => '<p>The name of the resource in the Kubernetes API call action.</p>', 'KubernetesPermissionCheckedDetails$Verb' => '<p>The verb component of the Kubernetes API call. For example, when you check whether or not you have the permission to call the <code>CreatePod</code> API, the verb component will be <code>Create</code>.</p>', 'KubernetesPermissionCheckedDetails$Resource' => '<p>The Kubernetes resource with which your Kubernetes API call will interact.</p>', 'KubernetesPermissionCheckedDetails$Namespace' => '<p>The namespace where the Kubernetes API action will take place.</p>', 'KubernetesRoleBindingDetails$Kind' => '<p>The kind of the role. For role binding, this value will be <code>RoleBinding</code>.</p>', 'KubernetesRoleBindingDetails$Name' => '<p>The name of the <code>RoleBinding</code>.</p>', 'KubernetesRoleBindingDetails$Uid' => '<p>The unique identifier of the role binding.</p>', 'KubernetesRoleBindingDetails$RoleRefName' => '<p>The name of the role being referenced. This must match the name of the <code>Role</code> or <code>ClusterRole</code> that you want to bind to.</p>', 'KubernetesRoleBindingDetails$RoleRefKind' => '<p>The type of the role being referenced. This could be either <code>Role</code> or <code>ClusterRole</code>.</p>', 'KubernetesRoleDetails$Kind' => '<p>The kind of role. For this API, the value of <code>kind</code> will be <code>Role</code>.</p>', 'KubernetesRoleDetails$Name' => '<p>The name of the Kubernetes role.</p>', 'KubernetesRoleDetails$Uid' => '<p>The unique identifier of the Kubernetes role name.</p>', 'KubernetesUserDetails$Username' => '<p>The username of the user who called the Kubernetes API.</p>', 'KubernetesUserDetails$Uid' => '<p>The user ID of the user who called the Kubernetes API.</p>', 'KubernetesWorkloadDetails$Name' => '<p>Kubernetes workload name.</p>', 'KubernetesWorkloadDetails$Type' => '<p>Kubernetes workload type (e.g. Pod, Deployment, etc.).</p>', 'KubernetesWorkloadDetails$Uid' => '<p>Kubernetes workload ID.</p>', 'KubernetesWorkloadDetails$Namespace' => '<p>Kubernetes namespace that the workload is part of.</p>', 'KubernetesWorkloadDetails$ServiceAccountName' => '<p>The service account name that is associated with a Kubernetes workload.</p>', 'LambdaDetails$FunctionArn' => '<p>Amazon Resource Name (ARN) of the Lambda function.</p>', 'LambdaDetails$FunctionName' => '<p>Name of the Lambda function.</p>', 'LambdaDetails$Description' => '<p>Description of the Lambda function.</p>', 'LambdaDetails$RevisionId' => '<p>The revision ID of the Lambda function version.</p>', 'LambdaDetails$FunctionVersion' => '<p>The version of the Lambda function.</p>', 'LambdaDetails$Role' => '<p>The execution role of the Lambda function.</p>', 'LineageObject$Name' => '<p>The name of the process.</p>', 'LineageObject$Uuid' => '<p>The unique ID assigned to the process by GuardDuty.</p>', 'LineageObject$ExecutablePath' => '<p>The absolute path of the process executable file.</p>', 'LineageObject$ParentUuid' => '<p>The unique ID of the parent process. This ID is assigned to the parent process by GuardDuty.</p>', 'ListCoverageRequest$NextToken' => '<p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the NextToken value returned from the previous request to continue listing results after the first page.</p>', 'ListCoverageResponse$NextToken' => '<p>The pagination parameter to be used on the next list operation to retrieve more items.</p>', 'ListDetectorsRequest$NextToken' => '<p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the list action. For subsequent calls to the action, fill nextToken in the request with the value of NextToken from the previous response to continue listing data.</p>', 'ListDetectorsResponse$NextToken' => '<p>The pagination parameter to be used on the next list operation to retrieve more items.</p>', 'ListFiltersRequest$NextToken' => '<p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the list action. For subsequent calls to the action, fill nextToken in the request with the value of NextToken from the previous response to continue listing data.</p>', 'ListFiltersResponse$NextToken' => '<p>The pagination parameter to be used on the next list operation to retrieve more items.</p>', 'ListFindingsRequest$NextToken' => '<p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the list action. For subsequent calls to the action, fill nextToken in the request with the value of NextToken from the previous response to continue listing data.</p>', 'ListFindingsResponse$NextToken' => '<p>The pagination parameter to be used on the next list operation to retrieve more items.</p>', 'ListIPSetsRequest$NextToken' => '<p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the list action. For subsequent calls to the action, fill nextToken in the request with the value of NextToken from the previous response to continue listing data.</p>', 'ListIPSetsResponse$NextToken' => '<p>The pagination parameter to be used on the next list operation to retrieve more items.</p>', 'ListInvitationsRequest$NextToken' => '<p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the list action. For subsequent calls to the action, fill nextToken in the request with the value of NextToken from the previous response to continue listing data.</p>', 'ListInvitationsResponse$NextToken' => '<p>The pagination parameter to be used on the next list operation to retrieve more items.</p>', 'ListMalwareProtectionPlansRequest$NextToken' => '<p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the list action. For subsequent calls to the action, fill nextToken in the request with the value of <code>NextToken</code> from the previous response to continue listing data.</p>', 'ListMalwareProtectionPlansResponse$NextToken' => '<p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the list action. For subsequent calls to the action, fill nextToken in the request with the value of <code>NextToken</code> from the previous response to continue listing data.</p>', 'ListMembersRequest$NextToken' => '<p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the list action. For subsequent calls to the action, fill nextToken in the request with the value of NextToken from the previous response to continue listing data.</p>', 'ListMembersRequest$OnlyAssociated' => '<p>Specifies whether to only return associated members or to return all members (including members who haven\'t been invited yet or have been disassociated). Member accounts must have been previously associated with the GuardDuty administrator account using <a href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_CreateMembers.html"> <code>Create Members</code> </a>. </p>', 'ListMembersResponse$NextToken' => '<p>The pagination parameter to be used on the next list operation to retrieve more items.</p>', 'ListOrganizationAdminAccountsRequest$NextToken' => '<p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>', 'ListOrganizationAdminAccountsResponse$NextToken' => '<p>The pagination parameter to be used on the next list operation to retrieve more items.</p>', 'ListPublishingDestinationsRequest$NextToken' => '<p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>', 'ListPublishingDestinationsResponse$NextToken' => '<p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>', 'ListThreatIntelSetsRequest$NextToken' => '<p>You can use this parameter to paginate results in the response. Set the value of this parameter to null on your first call to the list action. For subsequent calls to the action, fill nextToken in the request with the value of NextToken from the previous response to continue listing data.</p>', 'ListThreatIntelSetsResponse$NextToken' => '<p>The pagination parameter to be used on the next list operation to retrieve more items.</p>', 'LocalPortDetails$PortName' => '<p>The port name of the local connection.</p>', 'LoginAttribute$User' => '<p>Indicates the user name which attempted to log in.</p>', 'LoginAttribute$Application' => '<p>Indicates the application name used to attempt log in.</p>', 'MalwareProtectionConfigurationResult$ServiceRole' => '<p>The GuardDuty Malware Protection service role.</p>', 'MalwareProtectionPlanObjectPrefixesList$member' => NULL, 'MalwareProtectionPlanStatusReason$Code' => '<p>Issue code.</p>', 'MalwareProtectionPlanStatusReason$Message' => '<p>Issue message that specifies the reason. For information about potential troubleshooting steps, see <a href="https://docs.aws.amazon.com/guardduty/latest/ug/troubleshoot-s3-malware-protection-status-errors.html">Troubleshooting Malware Protection for S3 status issues</a> in the <i>GuardDuty User Guide</i>.</p>', 'MalwareProtectionPlanSummary$MalwareProtectionPlanId' => '<p>A unique identifier associated with Malware Protection plan.</p>', 'Master$InvitationId' => '<p>The value used to validate the administrator account to the member account.</p>', 'Master$RelationshipStatus' => '<p>The status of the relationship between the administrator and member accounts.</p>', 'Master$InvitedAt' => '<p>The timestamp when the invitation was sent.</p>', 'Member$MasterId' => '<p>The administrator account ID.</p>', 'Member$RelationshipStatus' => '<p>The status of the relationship between the member and the administrator.</p>', 'Member$InvitedAt' => '<p>The timestamp when the invitation was sent.</p>', 'Member$UpdatedAt' => '<p>The last-updated timestamp of the member.</p>', 'Member$AdministratorId' => '<p>The administrator account ID.</p>', 'MemoryRegionsList$member' => NULL, 'Neq$member' => NULL, 'NetworkConnectionAction$ConnectionDirection' => '<p>The network connection direction.</p>', 'NetworkConnectionAction$Protocol' => '<p>The network connection protocol.</p>', 'NetworkInterface$NetworkInterfaceId' => '<p>The ID of the network interface.</p>', 'NetworkInterface$PrivateDnsName' => '<p>The private DNS name of the EC2 instance.</p>', 'NetworkInterface$PublicDnsName' => '<p>The public DNS name of the EC2 instance.</p>', 'NetworkInterface$PublicIp' => '<p>The public IP address of the EC2 instance.</p>', 'NetworkInterface$SubnetId' => '<p>The subnet ID of the EC2 instance.</p>', 'NetworkInterface$VpcId' => '<p>The VPC ID of the EC2 instance.</p>', 'NotEquals$member' => NULL, 'ObservationTexts$member' => NULL, 'Organization$Asn' => '<p>The Autonomous System Number (ASN) of the internet provider of the remote IP address.</p>', 'Organization$AsnOrg' => '<p>The organization that registered this ASN.</p>', 'Organization$Isp' => '<p>The ISP information for the internet provider.</p>', 'Organization$Org' => '<p>The name of the internet provider.</p>', 'Owner$Id' => '<p>The canonical user ID of the bucket owner. For information about locating your canonical user ID see <a href="https://docs.aws.amazon.com/general/latest/gr/acct-identifiers.html#FindingCanonicalId">Finding Your Account Canonical User ID.</a> </p>', 'PrivateIpAddressDetails$PrivateDnsName' => '<p>The private DNS name of the EC2 instance.</p>', 'ProcessDetails$Name' => '<p>The name of the process.</p>', 'ProcessDetails$ExecutablePath' => '<p>The absolute path of the process executable file.</p>', 'ProcessDetails$ExecutableSha256' => '<p>The <code>SHA256</code> hash of the process executable.</p>', 'ProcessDetails$Pwd' => '<p>The present working directory of the process.</p>', 'ProcessDetails$Uuid' => '<p>The unique ID assigned to the process by GuardDuty.</p>', 'ProcessDetails$ParentUuid' => '<p>The unique ID of the parent process. This ID is assigned to the parent process by GuardDuty.</p>', 'ProcessDetails$User' => '<p>The user that executed the process.</p>', 'ProductCode$Code' => '<p>The product code information.</p>', 'ProductCode$ProductType' => '<p>The product code type.</p>', 'PublicAccess$EffectivePermission' => '<p>Describes the effective permission on this bucket after factoring all attached policies.</p>', 'RdsDbInstanceDetails$DbInstanceIdentifier' => '<p>The identifier associated to the database instance that was involved in the finding.</p>', 'RdsDbInstanceDetails$Engine' => '<p>The database engine of the database instance involved in the finding.</p>', 'RdsDbInstanceDetails$EngineVersion' => '<p>The version of the database engine that was involved in the finding.</p>', 'RdsDbInstanceDetails$DbClusterIdentifier' => '<p>The identifier of the database cluster that contains the database instance ID involved in the finding.</p>', 'RdsDbInstanceDetails$DbInstanceArn' => '<p>The Amazon Resource Name (ARN) that identifies the database instance involved in the finding.</p>', 'RdsDbUserDetails$User' => '<p>The user name used in the anomalous login attempt.</p>', 'RdsDbUserDetails$Application' => '<p>The application name used in the anomalous login attempt.</p>', 'RdsDbUserDetails$Database' => '<p>The name of the database instance involved in the anomalous login attempt.</p>', 'RdsDbUserDetails$Ssl' => '<p>The version of the Secure Socket Layer (SSL) used for the network.</p>', 'RdsDbUserDetails$AuthMethod' => '<p>The authentication method used by the user involved in the finding.</p>', 'RemoteAccountDetails$AccountId' => '<p>The Amazon Web Services account ID of the remote API caller.</p>', 'RemotePortDetails$PortName' => '<p>The port name of the remote connection.</p>', 'Resource$ResourceType' => '<p>The type of Amazon Web Services resource.</p>', 'ResourceList$member' => NULL, 'ResourceNotFoundException$Message' => '<p>The error message.</p>', 'ResourceNotFoundException$Type' => '<p>The error type.</p>', 'RuntimeContext$ScriptPath' => '<p>The path to the script that was executed.</p>', 'RuntimeContext$LibraryPath' => '<p>The path to the new library that was loaded.</p>', 'RuntimeContext$LdPreloadValue' => '<p>The value of the LD_PRELOAD environment variable.</p>', 'RuntimeContext$SocketPath' => '<p>The path to the docket socket that was accessed.</p>', 'RuntimeContext$RuncBinaryPath' => '<p>The path to the leveraged <code>runc</code> implementation.</p>', 'RuntimeContext$ReleaseAgentPath' => '<p>The path in the container that modified the release agent file.</p>', 'RuntimeContext$MountSource' => '<p>The path on the host that is mounted by the container.</p>', 'RuntimeContext$MountTarget' => '<p>The path in the container that is mapped to the host directory.</p>', 'RuntimeContext$FileSystemType' => '<p>Represents the type of mounted fileSystem.</p>', 'RuntimeContext$ModuleName' => '<p>The name of the module loaded into the kernel.</p>', 'RuntimeContext$ModuleFilePath' => '<p>The path to the module loaded into the kernel.</p>', 'RuntimeContext$ModuleSha256' => '<p>The <code>SHA256</code> hash of the module.</p>', 'RuntimeContext$ShellHistoryFilePath' => '<p>The path to the modified shell history file.</p>', 'RuntimeContext$AddressFamily' => '<p>Represents the communication protocol associated with the address. For example, the address family <code>AF_INET</code> is used for IP version of 4 protocol.</p>', 'RuntimeContext$ToolName' => '<p>Name of the potentially suspicious tool.</p>', 'RuntimeContext$ToolCategory' => '<p>Category that the tool belongs to. Some of the examples are Backdoor Tool, Pentest Tool, Network Scanner, and Network Sniffer.</p>', 'RuntimeContext$ServiceName' => '<p>Name of the security service that has been potentially disabled.</p>', 'RuntimeContext$CommandLineExample' => '<p>Example of the command line involved in the suspicious activity.</p>', 'RuntimeContext$ThreatFilePath' => '<p>The suspicious file path for which the threat intelligence details were found.</p>', 'S3BucketDetail$Arn' => '<p>The Amazon Resource Name (ARN) of the S3 bucket.</p>', 'S3BucketDetail$Name' => '<p>The name of the S3 bucket.</p>', 'S3BucketDetail$Type' => '<p>Describes whether the bucket is a source or destination bucket.</p>', 'S3ObjectDetail$ObjectArn' => '<p>Amazon Resource Name (ARN) of the S3 object.</p>', 'S3ObjectDetail$Key' => '<p>Key of the S3 object.</p>', 'S3ObjectDetail$ETag' => '<p>The entity tag is a hash of the S3 object. The ETag reflects changes only to the contents of an object, and not its metadata.</p>', 'S3ObjectDetail$Hash' => '<p>Hash of the threat detected in this finding.</p>', 'S3ObjectDetail$VersionId' => '<p>Version ID of the object.</p>', 'ScanFilePath$FilePath' => '<p>The file path of the infected file.</p>', 'ScanFilePath$VolumeArn' => '<p>EBS volume ARN details of the infected file.</p>', 'ScanFilePath$Hash' => '<p>The hash value of the infected file.</p>', 'ScanFilePath$FileName' => '<p>File name of the infected file.</p>', 'ScanThreatName$Name' => '<p>The name of the identified threat.</p>', 'ScanThreatName$Severity' => '<p>Severity of threat identified as part of the malware scan.</p>', 'SecurityGroup$GroupId' => '<p>The security group ID of the EC2 instance.</p>', 'SecurityGroup$GroupName' => '<p>The security group name of the EC2 instance.</p>', 'Service$EventFirstSeen' => '<p>The first-seen timestamp of the activity that prompted GuardDuty to generate this finding.</p>', 'Service$EventLastSeen' => '<p>The last-seen timestamp of the activity that prompted GuardDuty to generate this finding.</p>', 'Service$ResourceRole' => '<p>The resource role information for this finding.</p>', 'Service$ServiceName' => '<p>The name of the Amazon Web Services service (GuardDuty) that generated a finding.</p>', 'Service$UserFeedback' => '<p>Feedback that was submitted about the finding.</p>', 'Service$FeatureName' => '<p>The name of the feature that generated a finding.</p>', 'ServiceAdditionalInfo$Value' => '<p>This field specifies the value of the additional information.</p>', 'ServiceAdditionalInfo$Type' => '<p>Describes the type of the additional information.</p>', 'SessionNameList$member' => NULL, 'SortCriteria$AttributeName' => '<p>Represents the finding attribute, such as <code>accountId</code>, that sorts the findings.</p>', 'SourceIps$member' => NULL, 'Sources$member' => NULL, 'SubnetIds$member' => NULL, 'Tag$Key' => '<p>The EC2 instance tag key.</p>', 'Tag$Value' => '<p>The EC2 instance tag value.</p>', 'Threat$Name' => '<p>Name of the detected threat that caused GuardDuty to generate this finding.</p>', 'Threat$Source' => '<p>Source of the threat that generated this finding.</p>', 'ThreatIntelSetIds$member' => NULL, 'ThreatIntelligenceDetail$ThreatListName' => '<p>The name of the threat intelligence list that triggered the finding.</p>', 'ThreatIntelligenceDetail$ThreatFileSha256' => '<p>SHA256 of the file that generated the finding.</p>', 'ThreatNames$member' => NULL, 'Total$Amount' => '<p>The total usage.</p>', 'Total$Unit' => '<p>The currency unit that the amount is given in.</p>', 'UnprocessedAccount$Result' => '<p>A reason why the account hasn\'t been processed.</p>', 'UpdateFilterRequest$FilterName' => '<p>The name of the filter.</p>', 'UpdateFindingsFeedbackRequest$Comments' => '<p>Additional feedback about the GuardDuty findings.</p>', 'UpdateIPSetRequest$IpSetId' => '<p>The unique ID that specifies the IPSet that you want to update.</p>', 'UpdateMalwareProtectionPlanRequest$MalwareProtectionPlanId' => '<p>A unique identifier associated with the Malware Protection plan.</p>', 'UpdateMalwareProtectionPlanRequest$Role' => '<p>IAM role with permissions required to scan and add tags to the associated protected resource.</p>', 'UpdatePublishingDestinationRequest$DestinationId' => '<p>The ID of the publishing destination to update.</p>', 'UpdateThreatIntelSetRequest$ThreatIntelSetId' => '<p>The unique ID that specifies the ThreatIntelSet that you want to update.</p>', 'UsageResourceResult$Resource' => '<p>The Amazon Web Services resource that generated usage.</p>', 'Volume$Name' => '<p>Volume name.</p>', 'VolumeDetail$VolumeArn' => '<p>EBS volume ARN information.</p>', 'VolumeDetail$VolumeType' => '<p>The EBS volume type.</p>', 'VolumeDetail$DeviceName' => '<p>The device name for the EBS volume.</p>', 'VolumeDetail$EncryptionType' => '<p>EBS volume encryption type.</p>', 'VolumeDetail$SnapshotArn' => '<p>Snapshot ARN of the EBS volume.</p>', 'VolumeDetail$KmsKeyArn' => '<p>KMS key ARN used to encrypt the EBS volume.</p>', 'VolumeMount$Name' => '<p>Volume mount name.</p>', 'VolumeMount$MountPath' => '<p>Volume mount path.</p>', 'VpcConfig$VpcId' => '<p>The identifier of the Amazon Virtual Private Cloud.</p>', ], ], 'SubnetIds' => [ 'base' => NULL, 'refs' => [ 'VpcConfig$SubnetIds' => '<p>The identifiers of the subnets that are associated with your Lambda function.</p>', ], ], 'Tag' => [ 'base' => '<p>Contains information about a tag associated with the EC2 instance.</p>', 'refs' => [ 'Tags$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'ScanConditionPair$Key' => '<p>Represents the <b>key</b> in the map condition.</p>', 'TagKeyList$member' => NULL, 'TagMap$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>The tag keys to remove from the resource.</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'CreateDetectorRequest$Tags' => '<p>The tags to be added to a new detector resource.</p>', 'CreateFilterRequest$Tags' => '<p>The tags to be added to a new filter resource.</p>', 'CreateIPSetRequest$Tags' => '<p>The tags to be added to a new IP set resource.</p>', 'CreateMalwareProtectionPlanRequest$Tags' => '<p>Tags added to the Malware Protection plan resource. </p>', 'CreateThreatIntelSetRequest$Tags' => '<p>The tags to be added to a new threat list resource.</p>', 'GetDetectorResponse$Tags' => '<p>The tags of the detector resource.</p>', 'GetFilterResponse$Tags' => '<p>The tags of the filter resource.</p>', 'GetIPSetResponse$Tags' => '<p>The tags of the IPSet resource.</p>', 'GetMalwareProtectionPlanResponse$Tags' => '<p>Tags added to the Malware Protection plan resource.</p>', 'GetThreatIntelSetResponse$Tags' => '<p>The tags of the threat list resource.</p>', 'ListTagsForResourceResponse$Tags' => '<p>The tags associated with the resource.</p>', 'TagResourceRequest$Tags' => '<p>The tags to be added to a resource.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'ScanConditionPair$Value' => '<p>Represents optional <b>value</b> in the map condition. If not specified, only the <b>key</b> will be matched.</p>', 'TagMap$value' => NULL, ], ], 'Tags' => [ 'base' => NULL, 'refs' => [ 'EcsClusterDetails$Tags' => '<p>The tags of the ECS Cluster.</p>', 'EcsTaskDetails$Tags' => '<p>The tags of the ECS Task.</p>', 'EksClusterDetails$Tags' => '<p>The EKS cluster tags.</p>', 'InstanceDetails$Tags' => '<p>The tags of the EC2 instance.</p>', 'LambdaDetails$Tags' => '<p>A list of tags attached to this resource, listed in the format of <code>key</code>:<code>value</code> pair.</p>', 'RdsDbInstanceDetails$Tags' => '<p>Instance tag key-value pairs associated with the database instance ID.</p>', 'S3BucketDetail$Tags' => '<p>All tags attached to the S3 bucket</p>', ], ], 'Threat' => [ 'base' => '<p>Information about the detected threats associated with the generated finding.</p>', 'refs' => [ 'Threats$member' => NULL, ], ], 'ThreatDetectedByName' => [ 'base' => '<p>Contains details about identified threats organized by threat name.</p>', 'refs' => [ 'ScanDetections$ThreatDetectedByName' => '<p>Contains details about identified threats organized by threat name.</p>', ], ], 'ThreatIntelSetFormat' => [ 'base' => NULL, 'refs' => [ 'CreateThreatIntelSetRequest$Format' => '<p>The format of the file that contains the ThreatIntelSet.</p>', 'GetThreatIntelSetResponse$Format' => '<p>The format of the threatIntelSet.</p>', ], ], 'ThreatIntelSetIds' => [ 'base' => NULL, 'refs' => [ 'ListThreatIntelSetsResponse$ThreatIntelSetIds' => '<p>The IDs of the ThreatIntelSet resources.</p>', ], ], 'ThreatIntelSetStatus' => [ 'base' => NULL, 'refs' => [ 'GetThreatIntelSetResponse$Status' => '<p>The status of threatIntelSet file uploaded.</p>', ], ], 'ThreatIntelligenceDetail' => [ 'base' => '<p>An instance of a threat intelligence detail that constitutes evidence for the finding.</p>', 'refs' => [ 'ThreatIntelligenceDetails$member' => NULL, ], ], 'ThreatIntelligenceDetails' => [ 'base' => NULL, 'refs' => [ 'Evidence$ThreatIntelligenceDetails' => '<p>A list of threat intelligence details related to the evidence.</p>', ], ], 'ThreatNames' => [ 'base' => NULL, 'refs' => [ 'ThreatIntelligenceDetail$ThreatNames' => '<p>A list of names of the threats in the threat intelligence list that triggered the finding.</p>', ], ], 'Threats' => [ 'base' => NULL, 'refs' => [ 'MalwareScanDetails$Threats' => '<p>Information about the detected threats associated with the generated GuardDuty finding.</p>', ], ], 'ThreatsDetectedItemCount' => [ 'base' => '<p>Contains total number of infected files.</p>', 'refs' => [ 'ScanDetections$ThreatsDetectedItemCount' => '<p>Total number of infected files.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'CoverageResource$UpdatedAt' => '<p>The timestamp at which the coverage details for the resource were last updated. This is in UTC format.</p>', 'DetectorAdditionalConfigurationResult$UpdatedAt' => '<p>The timestamp at which the additional configuration was last updated. This is in UTC format.</p>', 'DetectorFeatureConfigurationResult$UpdatedAt' => '<p>The timestamp at which the feature object was updated.</p>', 'EbsVolumeScanDetails$ScanStartedAt' => '<p>Returns the start date and time of the malware scan.</p>', 'EbsVolumeScanDetails$ScanCompletedAt' => '<p>Returns the completion date and time of the malware scan.</p>', 'EcsTaskDetails$TaskCreatedAt' => '<p>The Unix timestamp for the time when the task was created.</p>', 'EcsTaskDetails$StartedAt' => '<p>The Unix timestamp for the time when the task started.</p>', 'EksClusterDetails$CreatedAt' => '<p>The timestamp when the EKS cluster was created.</p>', 'GetMalwareProtectionPlanResponse$CreatedAt' => '<p>The timestamp when the Malware Protection plan resource was created.</p>', 'LambdaDetails$LastModifiedAt' => '<p>The timestamp when the Lambda function was last modified. This field is in the UTC date string format <code>(2023-03-22T19:37:20.168Z)</code>.</p>', 'LineageObject$StartTime' => '<p>The time when the process started. This is in UTC format.</p>', 'MemberAdditionalConfigurationResult$UpdatedAt' => '<p>The timestamp at which the additional configuration was set for the member account. This is in UTC format.</p>', 'MemberFeaturesConfigurationResult$UpdatedAt' => '<p>The timestamp at which the feature object was updated.</p>', 'OrganizationDetails$UpdatedAt' => '<p>The timestamp at which the organization statistics was last updated. This is in UTC format.</p>', 'ProcessDetails$StartTime' => '<p>The time when the process started. This is in UTC format.</p>', 'RuntimeContext$ModifiedAt' => '<p>The timestamp at which the process modified the current process. The timestamp is in UTC date string format.</p>', 'S3BucketDetail$CreatedAt' => '<p>The date and time the bucket was created at.</p>', 'Scan$ScanStartTime' => '<p>The timestamp of when the scan was triggered.</p>', 'Scan$ScanEndTime' => '<p>The timestamp of when the scan was finished.</p>', ], ], 'Total' => [ 'base' => '<p>Contains the total usage with the corresponding currency unit for that value.</p>', 'refs' => [ 'UsageAccountResult$Total' => '<p>Represents the total of usage for the Account ID.</p>', 'UsageDataSourceResult$Total' => '<p>Represents the total of usage for the specified data source.</p>', 'UsageFeatureResult$Total' => NULL, 'UsageResourceResult$Total' => '<p>Represents the sum total of usage for the specified resource type.</p>', 'UsageTopAccountResult$Total' => NULL, ], ], 'TriggerDetails' => [ 'base' => '<p>Represents the reason the scan was triggered.</p>', 'refs' => [ 'Scan$TriggerDetails' => '<p>Specifies the reason why the scan was initiated.</p>', ], ], 'UnarchiveFindingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'UnarchiveFindingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'UnprocessedAccount' => [ 'base' => '<p>Contains information about the accounts that weren\'t processed.</p>', 'refs' => [ 'UnprocessedAccounts$member' => NULL, ], ], 'UnprocessedAccounts' => [ 'base' => NULL, 'refs' => [ 'CreateMembersResponse$UnprocessedAccounts' => '<p>A list of objects that include the <code>accountIds</code> of the unprocessed accounts and a result string that explains why each was unprocessed.</p>', 'DeclineInvitationsResponse$UnprocessedAccounts' => '<p>A list of objects that contain the unprocessed account and a result string that explains why it was unprocessed.</p>', 'DeleteInvitationsResponse$UnprocessedAccounts' => '<p>A list of objects that contain the unprocessed account and a result string that explains why it was unprocessed.</p>', 'DeleteMembersResponse$UnprocessedAccounts' => '<p>The accounts that could not be processed.</p>', 'DisassociateMembersResponse$UnprocessedAccounts' => '<p>A list of objects that contain the unprocessed account and a result string that explains why it was unprocessed.</p>', 'GetMemberDetectorsResponse$UnprocessedAccounts' => '<p>A list of member account IDs that were unable to be processed along with an explanation for why they were not processed.</p>', 'GetMembersResponse$UnprocessedAccounts' => '<p>A list of objects that contain the unprocessed account and a result string that explains why it was unprocessed.</p>', 'GetRemainingFreeTrialDaysResponse$UnprocessedAccounts' => '<p>The member account that was included in a request but for which the request could not be processed.</p>', 'InviteMembersResponse$UnprocessedAccounts' => '<p>A list of objects that contain the unprocessed account and a result string that explains why it was unprocessed.</p>', 'StartMonitoringMembersResponse$UnprocessedAccounts' => '<p>A list of objects that contain the unprocessed account and a result string that explains why it was unprocessed.</p>', 'StopMonitoringMembersResponse$UnprocessedAccounts' => '<p>A list of objects that contain an accountId for each account that could not be processed, and a result string that indicates why the account was not processed. </p>', 'UpdateMemberDetectorsResponse$UnprocessedAccounts' => '<p>A list of member account IDs that were unable to be processed along with an explanation for why they were not processed.</p>', ], ], 'UnprocessedDataSourcesResult' => [ 'base' => '<p>Specifies the names of the data sources that couldn\'t be enabled.</p>', 'refs' => [ 'CreateDetectorResponse$UnprocessedDataSources' => '<p>Specifies the data sources that couldn\'t be enabled when GuardDuty was enabled for the first time.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDetectorRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDetectorResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFilterRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFilterResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFindingsFeedbackRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFindingsFeedbackResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateIPSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateIPSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMalwareProtectionPlanRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMalwareScanSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMalwareScanSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMemberDetectorsRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMemberDetectorsResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateOrganizationConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateOrganizationConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateProtectedResource' => [ 'base' => '<p>Information about the protected resource that is associated with the created Malware Protection plan. Presently, <code>S3Bucket</code> is the only supported protected resource.</p>', 'refs' => [ 'UpdateMalwareProtectionPlanRequest$ProtectedResource' => '<p>Information about the protected resource that is associated with the created Malware Protection plan. Presently, <code>S3Bucket</code> is the only supported protected resource.</p>', ], ], 'UpdatePublishingDestinationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePublishingDestinationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateS3BucketResource' => [ 'base' => '<p>Information about the protected S3 bucket resource.</p>', 'refs' => [ 'UpdateProtectedResource$S3Bucket' => '<p>Information about the protected S3 bucket resource.</p>', ], ], 'UpdateThreatIntelSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateThreatIntelSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'UsageAccountResult' => [ 'base' => '<p>Contains information on the total of usage based on account IDs.</p>', 'refs' => [ 'UsageAccountResultList$member' => NULL, ], ], 'UsageAccountResultList' => [ 'base' => NULL, 'refs' => [ 'UsageStatistics$SumByAccount' => '<p>The usage statistic sum organized by account ID.</p>', ], ], 'UsageCriteria' => [ 'base' => '<p>Contains information about the criteria used to query usage statistics.</p>', 'refs' => [ 'GetUsageStatisticsRequest$UsageCriteria' => '<p>Represents the criteria used for querying usage.</p>', ], ], 'UsageDataSourceResult' => [ 'base' => '<p>Contains information on the result of usage based on data source type.</p>', 'refs' => [ 'UsageDataSourceResultList$member' => NULL, ], ], 'UsageDataSourceResultList' => [ 'base' => NULL, 'refs' => [ 'UsageStatistics$SumByDataSource' => '<p>The usage statistic sum organized by on data source.</p>', ], ], 'UsageFeature' => [ 'base' => NULL, 'refs' => [ 'UsageFeatureList$member' => NULL, 'UsageFeatureResult$Feature' => '<p>The feature that generated the usage cost.</p>', 'UsageTopAccountsResult$Feature' => '<p>Features by which you can generate the usage statistics.</p> <p> <code>RDS_LOGIN_EVENTS</code> is currently not supported with <code>topAccountsByFeature</code>.</p>', ], ], 'UsageFeatureList' => [ 'base' => NULL, 'refs' => [ 'UsageCriteria$Features' => '<p>The features to aggregate usage statistics from.</p>', ], ], 'UsageFeatureResult' => [ 'base' => '<p>Contains information about the result of the total usage based on the feature.</p>', 'refs' => [ 'UsageFeatureResultList$member' => NULL, ], ], 'UsageFeatureResultList' => [ 'base' => NULL, 'refs' => [ 'UsageStatistics$SumByFeature' => '<p>The usage statistic sum organized by feature.</p>', ], ], 'UsageResourceResult' => [ 'base' => '<p>Contains information on the sum of usage based on an Amazon Web Services resource.</p>', 'refs' => [ 'UsageResourceResultList$member' => NULL, ], ], 'UsageResourceResultList' => [ 'base' => NULL, 'refs' => [ 'UsageStatistics$SumByResource' => '<p>The usage statistic sum organized by resource.</p>', 'UsageStatistics$TopResources' => '<p>Lists the top 50 resources that have generated the most GuardDuty usage, in order from most to least expensive.</p>', ], ], 'UsageStatisticType' => [ 'base' => NULL, 'refs' => [ 'GetUsageStatisticsRequest$UsageStatisticType' => '<p>The type of usage statistics to retrieve.</p>', ], ], 'UsageStatistics' => [ 'base' => '<p>Contains the result of GuardDuty usage. If a UsageStatisticType is provided the result for other types will be null. </p>', 'refs' => [ 'GetUsageStatisticsResponse$UsageStatistics' => '<p>The usage statistics object. If a UsageStatisticType was provided, the objects representing other types will be null.</p>', ], ], 'UsageTopAccountResult' => [ 'base' => '<p>Contains information on the total of usage based on the topmost 50 account IDs.</p>', 'refs' => [ 'UsageTopAccountsByFeatureList$member' => NULL, ], ], 'UsageTopAccountsByFeatureList' => [ 'base' => NULL, 'refs' => [ 'UsageTopAccountsResult$Accounts' => '<p>The accounts that contributed to the total usage cost.</p>', ], ], 'UsageTopAccountsResult' => [ 'base' => '<p>Information about the usage statistics, calculated by top accounts by feature.</p>', 'refs' => [ 'UsageTopAccountsResultList$member' => NULL, ], ], 'UsageTopAccountsResultList' => [ 'base' => NULL, 'refs' => [ 'UsageStatistics$TopAccountsByFeature' => '<p>Lists the top 50 accounts by feature that have generated the most GuardDuty usage, in the order from most to least expensive.</p> <p>Currently, this doesn\'t support <code>RDS_LOGIN_EVENTS</code>.</p>', ], ], 'Volume' => [ 'base' => '<p>Volume used by the Kubernetes workload.</p>', 'refs' => [ 'Volumes$member' => NULL, ], ], 'VolumeDetail' => [ 'base' => '<p>Contains EBS volume details.</p>', 'refs' => [ 'VolumeDetails$member' => NULL, ], ], 'VolumeDetails' => [ 'base' => NULL, 'refs' => [ 'EbsVolumeDetails$ScannedVolumeDetails' => '<p>List of EBS volumes that were scanned.</p>', 'EbsVolumeDetails$SkippedVolumeDetails' => '<p>List of EBS volumes that were skipped from the malware scan.</p>', 'Scan$AttachedVolumes' => '<p>List of volumes that were attached to the original instance to be scanned.</p>', ], ], 'VolumeMount' => [ 'base' => '<p>Container volume mount.</p>', 'refs' => [ 'VolumeMounts$member' => NULL, ], ], 'VolumeMounts' => [ 'base' => NULL, 'refs' => [ 'Container$VolumeMounts' => '<p>Container volume mounts.</p>', ], ], 'Volumes' => [ 'base' => NULL, 'refs' => [ 'EcsTaskDetails$Volumes' => '<p>The list of data volume definitions for the task.</p>', 'KubernetesWorkloadDetails$Volumes' => '<p>Volumes used by the Kubernetes workload.</p>', ], ], 'VpcConfig' => [ 'base' => '<p>Amazon Virtual Private Cloud configuration details associated with your Lambda function.</p>', 'refs' => [ 'LambdaDetails$VpcConfig' => '<p>Amazon Virtual Private Cloud configuration details associated with your Lambda function.</p>', ], ], ],];
