<?php
// This file was auto-generated from sdk-root/src/data/iotsecuretunneling/2018-10-05/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>IoT Secure Tunneling</fullname> <p>IoT Secure Tunneling creates remote connections to devices deployed in the field.</p> <p>For more information about how IoT Secure Tunneling works, see <a href="https://docs.aws.amazon.com/iot/latest/developerguide/secure-tunneling.html">IoT Secure Tunneling</a>.</p>', 'operations' => [ 'CloseTunnel' => '<p>Closes a tunnel identified by the unique tunnel id. When a <code>CloseTunnel</code> request is received, we close the WebSocket connections between the client and proxy server so no data can be transmitted.</p> <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CloseTunnel</a> action.</p>', 'DescribeTunnel' => '<p>Gets information about a tunnel identified by the unique tunnel id.</p> <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeTunnel</a> action.</p>', 'ListTagsForResource' => '<p>Lists the tags for the specified resource.</p>', 'ListTunnels' => '<p>List all tunnels for an Amazon Web Services account. Tunnels are listed by creation time in descending order, newer tunnels will be listed before older tunnels.</p> <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListTunnels</a> action.</p>', 'OpenTunnel' => '<p>Creates a new tunnel, and returns two client access tokens for clients to use to connect to the IoT Secure Tunneling proxy server.</p> <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">OpenTunnel</a> action.</p>', 'RotateTunnelAccessToken' => '<p>Revokes the current client access token (CAT) and returns new CAT for clients to use when reconnecting to secure tunneling to access the same tunnel.</p> <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">RotateTunnelAccessToken</a> action.</p> <note> <p>Rotating the CAT doesn\'t extend the tunnel duration. For example, say the tunnel duration is 12 hours and the tunnel has already been open for 4 hours. When you rotate the access tokens, the new tokens that are generated can only be used for the remaining 8 hours.</p> </note>', 'TagResource' => '<p>A resource tag.</p>', 'UntagResource' => '<p>Removes a tag from a resource.</p>', ], 'shapes' => [ 'AmazonResourceName' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$resourceArn' => '<p>The resource ARN.</p>', 'TagResourceRequest$resourceArn' => '<p>The ARN of the resource.</p>', 'UntagResourceRequest$resourceArn' => '<p>The resource ARN.</p>', ], ], 'ClientAccessToken' => [ 'base' => NULL, 'refs' => [ 'OpenTunnelResponse$sourceAccessToken' => '<p>The access token the source local proxy uses to connect to IoT Secure Tunneling.</p>', 'OpenTunnelResponse$destinationAccessToken' => '<p>The access token the destination local proxy uses to connect to IoT Secure Tunneling.</p>', 'RotateTunnelAccessTokenResponse$sourceAccessToken' => '<p>The client access token that the source local proxy uses to connect to IoT Secure Tunneling.</p>', 'RotateTunnelAccessTokenResponse$destinationAccessToken' => '<p>The client access token that the destination local proxy uses to connect to IoT Secure Tunneling.</p>', ], ], 'ClientMode' => [ 'base' => NULL, 'refs' => [ 'RotateTunnelAccessTokenRequest$clientMode' => '<p>The mode of the client that will use the client token, which can be either the source or destination, or both source and destination.</p>', ], ], 'CloseTunnelRequest' => [ 'base' => NULL, 'refs' => [], ], 'CloseTunnelResponse' => [ 'base' => NULL, 'refs' => [], ], 'ConnectionState' => [ 'base' => '<p>The state of a connection.</p>', 'refs' => [ 'Tunnel$sourceConnectionState' => '<p>The connection state of the source application.</p>', 'Tunnel$destinationConnectionState' => '<p>The connection state of the destination application.</p>', ], ], 'ConnectionStatus' => [ 'base' => NULL, 'refs' => [ 'ConnectionState$status' => '<p>The connection status of the tunnel. Valid values are <code>CONNECTED</code> and <code>DISCONNECTED</code>.</p>', ], ], 'DateType' => [ 'base' => NULL, 'refs' => [ 'ConnectionState$lastUpdatedAt' => '<p>The last time the connection status was updated.</p>', 'Tunnel$createdAt' => '<p>The time when the tunnel was created.</p>', 'Tunnel$lastUpdatedAt' => '<p>The last time the tunnel was updated.</p>', 'TunnelSummary$createdAt' => '<p>The time the tunnel was created.</p>', 'TunnelSummary$lastUpdatedAt' => '<p>The time the tunnel was last updated.</p>', ], ], 'DeleteFlag' => [ 'base' => NULL, 'refs' => [ 'CloseTunnelRequest$delete' => '<p>When set to true, IoT Secure Tunneling deletes the tunnel data immediately.</p>', ], ], 'DescribeTunnelRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTunnelResponse' => [ 'base' => NULL, 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'OpenTunnelRequest$description' => '<p>A short text description of the tunnel. </p>', 'Tunnel$description' => '<p>A description of the tunnel.</p>', 'TunnelSummary$description' => '<p>A description of the tunnel.</p>', ], ], 'DestinationConfig' => [ 'base' => '<p>The destination configuration.</p>', 'refs' => [ 'OpenTunnelRequest$destinationConfig' => '<p>The destination configuration for the OpenTunnel request.</p>', 'RotateTunnelAccessTokenRequest$destinationConfig' => NULL, 'Tunnel$destinationConfig' => '<p>The destination configuration that specifies the thing name of the destination device and a service name that the local proxy uses to connect to the destination application.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'LimitExceededException$message' => NULL, 'ResourceNotFoundException$message' => NULL, ], ], 'LimitExceededException' => [ 'base' => '<p>Thrown when a tunnel limit is exceeded.</p>', 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTunnelsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTunnelsResponse' => [ 'base' => NULL, 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListTunnelsRequest$maxResults' => '<p>The maximum number of results to return at once.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListTunnelsRequest$nextToken' => '<p>To retrieve the next set of results, the nextToken value from a previous response; otherwise null to receive the first set of results.</p>', 'ListTunnelsResponse$nextToken' => '<p>The token to use to get the next set of results, or null if there are no additional results.</p>', ], ], 'OpenTunnelRequest' => [ 'base' => NULL, 'refs' => [], ], 'OpenTunnelResponse' => [ 'base' => NULL, 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>Thrown when an operation is attempted on a resource that does not exist.</p>', 'refs' => [], ], 'RotateTunnelAccessTokenRequest' => [ 'base' => NULL, 'refs' => [], ], 'RotateTunnelAccessTokenResponse' => [ 'base' => NULL, 'refs' => [], ], 'Service' => [ 'base' => NULL, 'refs' => [ 'ServiceList$member' => NULL, ], ], 'ServiceList' => [ 'base' => NULL, 'refs' => [ 'DestinationConfig$services' => '<p>A list of service names that identify the target application. The IoT client running on the destination device reads this value and uses it to look up a port or an IP address and a port. The IoT client instantiates the local proxy, which uses this information to connect to the destination application.</p>', ], ], 'Tag' => [ 'base' => '<p>An arbitary key/value pair used to add searchable metadata to secure tunnel resources.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$key' => '<p>The key of the tag.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>The keys of the tags to remove.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceResponse$tags' => '<p>The tags for the specified resource.</p>', 'OpenTunnelRequest$tags' => '<p>A collection of tag metadata.</p>', 'TagResourceRequest$tags' => '<p>The tags for the resource.</p>', 'Tunnel$tags' => '<p>A list of tag metadata associated with the secure tunnel.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$value' => '<p>The value of the tag.</p>', ], ], 'ThingName' => [ 'base' => NULL, 'refs' => [ 'DestinationConfig$thingName' => '<p>The name of the IoT thing to which you want to connect.</p>', 'ListTunnelsRequest$thingName' => '<p>The name of the IoT thing associated with the destination device.</p>', ], ], 'TimeoutConfig' => [ 'base' => '<p>Tunnel timeout configuration.</p>', 'refs' => [ 'OpenTunnelRequest$timeoutConfig' => '<p>Timeout configuration for a tunnel.</p>', 'Tunnel$timeoutConfig' => '<p>Timeout configuration for the tunnel.</p>', ], ], 'TimeoutInMin' => [ 'base' => NULL, 'refs' => [ 'TimeoutConfig$maxLifetimeTimeoutMinutes' => '<p>The maximum amount of time (in minutes) a tunnel can remain open. If not specified, maxLifetimeTimeoutMinutes defaults to 720 minutes. Valid values are from 1 minute to 12 hours (720 minutes) </p>', ], ], 'Tunnel' => [ 'base' => '<p>A connection between a source computer and a destination device.</p>', 'refs' => [ 'DescribeTunnelResponse$tunnel' => '<p>The tunnel being described.</p>', ], ], 'TunnelArn' => [ 'base' => NULL, 'refs' => [ 'OpenTunnelResponse$tunnelArn' => '<p>The Amazon Resource Name for the tunnel.</p>', 'RotateTunnelAccessTokenResponse$tunnelArn' => '<p>The Amazon Resource Name for the tunnel.</p>', 'Tunnel$tunnelArn' => '<p>The Amazon Resource Name (ARN) of a tunnel.</p>', 'TunnelSummary$tunnelArn' => '<p>The Amazon Resource Name of the tunnel. </p>', ], ], 'TunnelId' => [ 'base' => NULL, 'refs' => [ 'CloseTunnelRequest$tunnelId' => '<p>The ID of the tunnel to close.</p>', 'DescribeTunnelRequest$tunnelId' => '<p>The tunnel to describe.</p>', 'OpenTunnelResponse$tunnelId' => '<p>A unique alpha-numeric tunnel ID.</p>', 'RotateTunnelAccessTokenRequest$tunnelId' => '<p>The tunnel for which you want to rotate the access tokens.</p>', 'Tunnel$tunnelId' => '<p>A unique alpha-numeric ID that identifies a tunnel.</p>', 'TunnelSummary$tunnelId' => '<p>The unique alpha-numeric identifier for the tunnel.</p>', ], ], 'TunnelStatus' => [ 'base' => NULL, 'refs' => [ 'Tunnel$status' => '<p>The status of a tunnel. Valid values are: Open and Closed.</p>', 'TunnelSummary$status' => '<p>The status of a tunnel. Valid values are: Open and Closed.</p>', ], ], 'TunnelSummary' => [ 'base' => '<p>Information about the tunnel.</p>', 'refs' => [ 'TunnelSummaryList$member' => NULL, ], ], 'TunnelSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListTunnelsResponse$tunnelSummaries' => '<p>A short description of the tunnels in an Amazon Web Services account.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], ],];
