<?php
// This file was auto-generated from sdk-root/src/data/iotwireless/2020-11-22/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>AWS IoT Wireless provides bi-directional communication between internet-connected wireless devices and the AWS Cloud. To onboard both LoRaWAN and Sidewalk devices to AWS IoT, use the IoT Wireless API. These wireless devices use the Low Power Wide Area Networking (LPWAN) communication protocol to communicate with AWS IoT.</p> <p>Using the API, you can perform create, read, update, and delete operations for your wireless devices, gateways, destinations, and profiles. After onboarding your devices, you can use the API operations to set log levels and monitor your devices with CloudWatch.</p> <p>You can also use the API operations to create multicast groups and schedule a multicast session for sending a downlink message to devices in the group. By using Firmware Updates Over-The-Air (FUOTA) API operations, you can create a FUOTA task and schedule a session to update the firmware of individual devices or an entire group of devices in a multicast group.</p> <p>To connect to the AWS IoT Wireless Service, use the Service endpoints as described in <a href="https://docs.aws.amazon.com/general/latest/gr/iot-lorawan.html#iot-wireless_region">IoT Wireless Service endpoints</a> in the <i>AWS General Reference</i>.</p>', 'operations' => [ 'AssociateAwsAccountWithPartnerAccount' => '<p>Associates a partner account with your AWS account.</p>', 'AssociateMulticastGroupWithFuotaTask' => '<p>Associate a multicast group with a FUOTA task.</p>', 'AssociateWirelessDeviceWithFuotaTask' => '<p>Associate a wireless device with a FUOTA task.</p>', 'AssociateWirelessDeviceWithMulticastGroup' => '<p>Associates a wireless device with a multicast group.</p>', 'AssociateWirelessDeviceWithThing' => '<p>Associates a wireless device with a thing.</p>', 'AssociateWirelessGatewayWithCertificate' => '<p>Associates a wireless gateway with a certificate.</p>', 'AssociateWirelessGatewayWithThing' => '<p>Associates a wireless gateway with a thing.</p>', 'CancelMulticastGroupSession' => '<p>Cancels an existing multicast group session.</p>', 'CreateDestination' => '<p>Creates a new destination that maps a device message to an AWS IoT rule.</p>', 'CreateDeviceProfile' => '<p>Creates a new device profile.</p>', 'CreateFuotaTask' => '<p>Creates a FUOTA task.</p>', 'CreateMulticastGroup' => '<p>Creates a multicast group.</p>', 'CreateNetworkAnalyzerConfiguration' => '<p>Creates a new network analyzer configuration.</p>', 'CreateServiceProfile' => '<p>Creates a new service profile.</p>', 'CreateWirelessDevice' => '<p>Provisions a wireless device.</p>', 'CreateWirelessGateway' => '<p>Provisions a wireless gateway.</p> <note> <p>When provisioning a wireless gateway, you might run into duplication errors for the following reasons.</p> <ul> <li> <p>If you specify a <code>GatewayEui</code> value that already exists.</p> </li> <li> <p>If you used a <code>ClientRequestToken</code> with the same parameters within the last 10 minutes.</p> </li> </ul> <p>To avoid this error, make sure that you use unique identifiers and parameters for each request within the specified time period.</p> </note>', 'CreateWirelessGatewayTask' => '<p>Creates a task for a wireless gateway.</p>', 'CreateWirelessGatewayTaskDefinition' => '<p>Creates a gateway task definition.</p>', 'DeleteDestination' => '<p>Deletes a destination.</p>', 'DeleteDeviceProfile' => '<p>Deletes a device profile.</p>', 'DeleteFuotaTask' => '<p>Deletes a FUOTA task.</p>', 'DeleteMulticastGroup' => '<p>Deletes a multicast group if it is not in use by a fuota task.</p>', 'DeleteNetworkAnalyzerConfiguration' => '<p>Deletes a network analyzer configuration.</p>', 'DeleteQueuedMessages' => '<p>Remove queued messages from the downlink queue.</p>', 'DeleteServiceProfile' => '<p>Deletes a service profile.</p>', 'DeleteWirelessDevice' => '<p>Deletes a wireless device.</p>', 'DeleteWirelessDeviceImportTask' => '<p>Delete an import task.</p>', 'DeleteWirelessGateway' => '<p>Deletes a wireless gateway.</p> <note> <p>When deleting a wireless gateway, you might run into duplication errors for the following reasons.</p> <ul> <li> <p>If you specify a <code>GatewayEui</code> value that already exists.</p> </li> <li> <p>If you used a <code>ClientRequestToken</code> with the same parameters within the last 10 minutes.</p> </li> </ul> <p>To avoid this error, make sure that you use unique identifiers and parameters for each request within the specified time period.</p> </note>', 'DeleteWirelessGatewayTask' => '<p>Deletes a wireless gateway task.</p>', 'DeleteWirelessGatewayTaskDefinition' => '<p>Deletes a wireless gateway task definition. Deleting this task definition does not affect tasks that are currently in progress.</p>', 'DeregisterWirelessDevice' => '<p>Deregister a wireless device from AWS IoT Wireless.</p>', 'DisassociateAwsAccountFromPartnerAccount' => '<p>Disassociates your AWS account from a partner account. If <code>PartnerAccountId</code> and <code>PartnerType</code> are <code>null</code>, disassociates your AWS account from all partner accounts.</p>', 'DisassociateMulticastGroupFromFuotaTask' => '<p>Disassociates a multicast group from a fuota task.</p>', 'DisassociateWirelessDeviceFromFuotaTask' => '<p>Disassociates a wireless device from a FUOTA task.</p>', 'DisassociateWirelessDeviceFromMulticastGroup' => '<p>Disassociates a wireless device from a multicast group.</p>', 'DisassociateWirelessDeviceFromThing' => '<p>Disassociates a wireless device from its currently associated thing.</p>', 'DisassociateWirelessGatewayFromCertificate' => '<p>Disassociates a wireless gateway from its currently associated certificate.</p>', 'DisassociateWirelessGatewayFromThing' => '<p>Disassociates a wireless gateway from its currently associated thing.</p>', 'GetDestination' => '<p>Gets information about a destination.</p>', 'GetDeviceProfile' => '<p>Gets information about a device profile.</p>', 'GetEventConfigurationByResourceTypes' => '<p>Get the event configuration based on resource types.</p>', 'GetFuotaTask' => '<p>Gets information about a FUOTA task.</p>', 'GetLogLevelsByResourceTypes' => '<p>Returns current default log levels or log levels by resource types. Based on resource types, log levels can be for wireless device log options or wireless gateway log options.</p>', 'GetMetricConfiguration' => '<p>Get the metric configuration status for this AWS account.</p>', 'GetMetrics' => '<p>Get the summary metrics for this AWS account.</p>', 'GetMulticastGroup' => '<p>Gets information about a multicast group.</p>', 'GetMulticastGroupSession' => '<p>Gets information about a multicast group session.</p>', 'GetNetworkAnalyzerConfiguration' => '<p>Get network analyzer configuration.</p>', 'GetPartnerAccount' => '<p>Gets information about a partner account. If <code>PartnerAccountId</code> and <code>PartnerType</code> are <code>null</code>, returns all partner accounts.</p>', 'GetPosition' => '<p>Get the position information for a given resource.</p> <important> <p>This action is no longer supported. Calls to retrieve the position information should use the <a href="https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetResourcePosition.html">GetResourcePosition</a> API operation instead.</p> </important>', 'GetPositionConfiguration' => '<p>Get position configuration for a given resource.</p> <important> <p>This action is no longer supported. Calls to retrieve the position configuration should use the <a href="https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetResourcePosition.html">GetResourcePosition</a> API operation instead.</p> </important>', 'GetPositionEstimate' => '<p>Get estimated position information as a payload in GeoJSON format. The payload measurement data is resolved using solvers that are provided by third-party vendors.</p>', 'GetResourceEventConfiguration' => '<p>Get the event configuration for a particular resource identifier.</p>', 'GetResourceLogLevel' => '<p>Fetches the log-level override, if any, for a given resource-ID and resource-type. It can be used for a wireless device or a wireless gateway.</p>', 'GetResourcePosition' => '<p>Get the position information for a given wireless device or a wireless gateway resource. The position information uses the <a href="https://gisgeography.com/wgs84-world-geodetic-system/"> World Geodetic System (WGS84)</a>.</p>', 'GetServiceEndpoint' => '<p>Gets the account-specific endpoint for Configuration and Update Server (CUPS) protocol or LoRaWAN Network Server (LNS) connections.</p>', 'GetServiceProfile' => '<p>Gets information about a service profile.</p>', 'GetWirelessDevice' => '<p>Gets information about a wireless device.</p>', 'GetWirelessDeviceImportTask' => '<p>Get information about an import task and count of device onboarding summary information for the import task.</p>', 'GetWirelessDeviceStatistics' => '<p>Gets operating information about a wireless device.</p>', 'GetWirelessGateway' => '<p>Gets information about a wireless gateway.</p>', 'GetWirelessGatewayCertificate' => '<p>Gets the ID of the certificate that is currently associated with a wireless gateway.</p>', 'GetWirelessGatewayFirmwareInformation' => '<p>Gets the firmware version and other information about a wireless gateway.</p>', 'GetWirelessGatewayStatistics' => '<p>Gets operating information about a wireless gateway.</p>', 'GetWirelessGatewayTask' => '<p>Gets information about a wireless gateway task.</p>', 'GetWirelessGatewayTaskDefinition' => '<p>Gets information about a wireless gateway task definition.</p>', 'ListDestinations' => '<p>Lists the destinations registered to your AWS account.</p>', 'ListDeviceProfiles' => '<p>Lists the device profiles registered to your AWS account.</p>', 'ListDevicesForWirelessDeviceImportTask' => '<p>List the Sidewalk devices in an import task and their onboarding status.</p>', 'ListEventConfigurations' => '<p>List event configurations where at least one event topic has been enabled.</p>', 'ListFuotaTasks' => '<p>Lists the FUOTA tasks registered to your AWS account.</p>', 'ListMulticastGroups' => '<p>Lists the multicast groups registered to your AWS account.</p>', 'ListMulticastGroupsByFuotaTask' => '<p>List all multicast groups associated with a fuota task.</p>', 'ListNetworkAnalyzerConfigurations' => '<p>Lists the network analyzer configurations.</p>', 'ListPartnerAccounts' => '<p>Lists the partner accounts associated with your AWS account.</p>', 'ListPositionConfigurations' => '<p>List position configurations for a given resource, such as positioning solvers.</p> <important> <p>This action is no longer supported. Calls to retrieve position information should use the <a href="https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetResourcePosition.html">GetResourcePosition</a> API operation instead.</p> </important>', 'ListQueuedMessages' => '<p>List queued messages in the downlink queue.</p>', 'ListServiceProfiles' => '<p>Lists the service profiles registered to your AWS account.</p>', 'ListTagsForResource' => '<p>Lists the tags (metadata) you have assigned to the resource.</p>', 'ListWirelessDeviceImportTasks' => '<p>List wireless devices that have been added to an import task.</p>', 'ListWirelessDevices' => '<p>Lists the wireless devices registered to your AWS account.</p>', 'ListWirelessGatewayTaskDefinitions' => '<p>List the wireless gateway tasks definitions registered to your AWS account.</p>', 'ListWirelessGateways' => '<p>Lists the wireless gateways registered to your AWS account.</p>', 'PutPositionConfiguration' => '<p>Put position configuration for a given resource.</p> <important> <p>This action is no longer supported. Calls to update the position configuration should use the <a href="https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_UpdateResourcePosition.html">UpdateResourcePosition</a> API operation instead.</p> </important>', 'PutResourceLogLevel' => '<p>Sets the log-level override for a resource-ID and resource-type. This option can be specified for a wireless gateway or a wireless device. A limit of 200 log level override can be set per account.</p>', 'ResetAllResourceLogLevels' => '<p>Removes the log-level overrides for all resources; both wireless devices and wireless gateways.</p>', 'ResetResourceLogLevel' => '<p>Removes the log-level override, if any, for a specific resource-ID and resource-type. It can be used for a wireless device or a wireless gateway.</p>', 'SendDataToMulticastGroup' => '<p>Sends the specified data to a multicast group.</p>', 'SendDataToWirelessDevice' => '<p>Sends a decrypted application data frame to a device.</p>', 'StartBulkAssociateWirelessDeviceWithMulticastGroup' => '<p>Starts a bulk association of all qualifying wireless devices with a multicast group.</p>', 'StartBulkDisassociateWirelessDeviceFromMulticastGroup' => '<p>Starts a bulk disassociatin of all qualifying wireless devices from a multicast group.</p>', 'StartFuotaTask' => '<p>Starts a FUOTA task.</p>', 'StartMulticastGroupSession' => '<p>Starts a multicast group session.</p>', 'StartSingleWirelessDeviceImportTask' => '<p>Start import task for a single wireless device.</p>', 'StartWirelessDeviceImportTask' => '<p>Start import task for provisioning Sidewalk devices in bulk using an S3 CSV file.</p>', 'TagResource' => '<p>Adds a tag to a resource.</p>', 'TestWirelessDevice' => '<p>Simulates a provisioned device by sending an uplink data payload of <code>Hello</code>.</p>', 'UntagResource' => '<p>Removes one or more tags from a resource.</p>', 'UpdateDestination' => '<p>Updates properties of a destination.</p>', 'UpdateEventConfigurationByResourceTypes' => '<p>Update the event configuration based on resource types.</p>', 'UpdateFuotaTask' => '<p>Updates properties of a FUOTA task.</p>', 'UpdateLogLevelsByResourceTypes' => '<p>Set default log level, or log levels by resource types. This can be for wireless device log options or wireless gateways log options and is used to control the log messages that\'ll be displayed in CloudWatch.</p>', 'UpdateMetricConfiguration' => '<p>Update the summary metric configuration.</p>', 'UpdateMulticastGroup' => '<p>Updates properties of a multicast group session.</p>', 'UpdateNetworkAnalyzerConfiguration' => '<p>Update network analyzer configuration.</p>', 'UpdatePartnerAccount' => '<p>Updates properties of a partner account.</p>', 'UpdatePosition' => '<p>Update the position information of a resource.</p> <important> <p>This action is no longer supported. Calls to update the position information should use the <a href="https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_UpdateResourcePosition.html">UpdateResourcePosition</a> API operation instead.</p> </important>', 'UpdateResourceEventConfiguration' => '<p>Update the event configuration for a particular resource identifier.</p>', 'UpdateResourcePosition' => '<p>Update the position information of a given wireless device or a wireless gateway resource. The position coordinates are based on the <a href="https://gisgeography.com/wgs84-world-geodetic-system/"> World Geodetic System (WGS84)</a>.</p>', 'UpdateWirelessDevice' => '<p>Updates properties of a wireless device.</p>', 'UpdateWirelessDeviceImportTask' => '<p>Update an import task to add more devices to the task.</p>', 'UpdateWirelessGateway' => '<p>Updates properties of a wireless gateway.</p>', ], 'shapes' => [ 'AbpV1_0_x' => [ 'base' => '<p>ABP device object for LoRaWAN specification v1.0.x</p>', 'refs' => [ 'LoRaWANDevice$AbpV1_0_x' => '<p>LoRaWAN object for create APIs</p>', ], ], 'AbpV1_1' => [ 'base' => '<p>ABP device object for LoRaWAN specification v1.1</p>', 'refs' => [ 'LoRaWANDevice$AbpV1_1' => '<p>ABP device object for create APIs for v1.1</p>', ], ], 'AccessDeniedException' => [ 'base' => '<p>User does not have permission to perform this action.</p>', 'refs' => [], ], 'AccountLinked' => [ 'base' => NULL, 'refs' => [ 'GetPartnerAccountResponse$AccountLinked' => '<p>Whether the partner account is linked to the AWS account.</p>', ], ], 'Accuracy' => [ 'base' => '<p>The accuracy of the estimated position in meters. An empty value indicates that no position data is available. A value of ‘0.0’ value indicates that position data is available. This data corresponds to the position information that you specified instead of the position computed by solver.</p>', 'refs' => [ 'GetPositionResponse$Accuracy' => '<p>The accuracy of the estimated position in meters. An empty value indicates that no position data is available. A value of ‘0.0’ value indicates that position data is available. This data corresponds to the position information that you specified instead of the position computed by solver.</p>', ], ], 'AckModeRetryDurationSecs' => [ 'base' => NULL, 'refs' => [ 'SidewalkSendDataToDevice$AckModeRetryDurationSecs' => '<p>The duration of time in seconds to retry sending the ACK.</p>', ], ], 'AddGwMetadata' => [ 'base' => NULL, 'refs' => [ 'LoRaWANGetServiceProfileInfo$AddGwMetadata' => '<p>The AddGWMetaData value.</p>', 'LoRaWANServiceProfile$AddGwMetadata' => '<p>The AddGWMetaData value.</p>', ], ], 'AggregationPeriod' => [ 'base' => NULL, 'refs' => [ 'SummaryMetricQuery$AggregationPeriod' => '<p>The aggregation period of the summary metric.</p>', 'SummaryMetricQueryResult$AggregationPeriod' => '<p>The aggregation period of the metric.</p>', ], ], 'AmazonId' => [ 'base' => '<p>The Sidewalk Amazon ID.</p>', 'refs' => [ 'SidewalkAccountInfo$AmazonId' => '<p>The Sidewalk Amazon ID.</p>', 'SidewalkAccountInfoWithFingerprint$AmazonId' => '<p>The Sidewalk Amazon ID.</p>', 'SidewalkDevice$AmazonId' => NULL, 'SidewalkListDevice$AmazonId' => '<p>The Sidewalk Amazon ID.</p>', ], ], 'AmazonResourceName' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$ResourceArn' => '<p>The ARN of the resource for which you want to list tags.</p>', 'TagResourceRequest$ResourceArn' => '<p>The ARN of the resource to add tags to.</p>', 'TooManyTagsException$ResourceName' => '<p>Name of the resource that exceeds maximum number of tags allowed.</p>', 'UntagResourceRequest$ResourceArn' => '<p>The ARN of the resource to remove tags from.</p>', ], ], 'ApId' => [ 'base' => NULL, 'refs' => [ 'DakCertificateMetadata$ApId' => '<p>The advertised product ID (APID) that\'s used for pre-production and production applications.</p>', ], ], 'AppEui' => [ 'base' => NULL, 'refs' => [ 'OtaaV1_0_x$AppEui' => '<p>The AppEUI value. You specify this value when using LoRaWAN versions v1.0.2 or v1.0.3.</p>', ], ], 'AppKey' => [ 'base' => NULL, 'refs' => [ 'OtaaV1_0_x$AppKey' => '<p>The AppKey value.</p>', 'OtaaV1_1$AppKey' => '<p>The AppKey value.</p>', ], ], 'AppSKey' => [ 'base' => NULL, 'refs' => [ 'SessionKeysAbpV1_0_x$AppSKey' => '<p>The AppSKey value.</p>', 'SessionKeysAbpV1_1$AppSKey' => '<p>The AppSKey value.</p>', ], ], 'AppServerPrivateKey' => [ 'base' => NULL, 'refs' => [ 'SidewalkAccountInfo$AppServerPrivateKey' => '<p>The Sidewalk application server private key.</p>', 'SidewalkUpdateAccount$AppServerPrivateKey' => '<p>The new Sidewalk application server private key.</p>', ], ], 'ApplicationConfig' => [ 'base' => '<p>LoRaWAN application configuration, which can be used to perform geolocation.</p>', 'refs' => [ 'Applications$member' => NULL, ], ], 'ApplicationConfigType' => [ 'base' => NULL, 'refs' => [ 'ApplicationConfig$Type' => '<p>Application type, which can be specified to obtain real-time position information of your LoRaWAN device.</p>', ], ], 'ApplicationServerPublicKey' => [ 'base' => NULL, 'refs' => [ 'SidewalkGetDeviceProfile$ApplicationServerPublicKey' => '<p>The Sidewalk application server public key.</p>', ], ], 'Applications' => [ 'base' => NULL, 'refs' => [ 'FPorts$Applications' => '<p>Optional LoRaWAN application information, which can be used for geolocation.</p>', 'UpdateFPorts$Applications' => '<p>LoRaWAN application, which can be used for geolocation by activating positioning.</p>', ], ], 'AssistPosition' => [ 'base' => NULL, 'refs' => [ 'Gnss$AssistPosition' => '<p>Optional assistance position information, specified using latitude and longitude values in degrees. The coordinates are inside the WGS84 reference frame.</p>', ], ], 'AssociateAwsAccountWithPartnerAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateAwsAccountWithPartnerAccountResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociateMulticastGroupWithFuotaTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateMulticastGroupWithFuotaTaskResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociateWirelessDeviceWithFuotaTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateWirelessDeviceWithFuotaTaskResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociateWirelessDeviceWithMulticastGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateWirelessDeviceWithMulticastGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociateWirelessDeviceWithThingRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateWirelessDeviceWithThingResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociateWirelessGatewayWithCertificateRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateWirelessGatewayWithCertificateResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociateWirelessGatewayWithThingRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateWirelessGatewayWithThingResponse' => [ 'base' => NULL, 'refs' => [], ], 'AutoCreateTasks' => [ 'base' => NULL, 'refs' => [ 'CreateWirelessGatewayTaskDefinitionRequest$AutoCreateTasks' => '<p>Whether to automatically create tasks using this task definition for all gateways with the specified current version. If <code>false</code>, the task must me created by calling <code>CreateWirelessGatewayTask</code>.</p>', 'GetWirelessGatewayTaskDefinitionResponse$AutoCreateTasks' => '<p>Whether to automatically create tasks using this task definition for all gateways with the specified current version. If <code>false</code>, the task must me created by calling <code>CreateWirelessGatewayTask</code>.</p>', ], ], 'Avg' => [ 'base' => NULL, 'refs' => [ 'MetricQueryValue$Avg' => '<p>The average of the values of all data points collected during the aggregation period.</p>', ], ], 'BCCH' => [ 'base' => NULL, 'refs' => [ 'GsmLocalId$Bcch' => '<p>GSM broadcast control channel.</p>', 'GsmNmrObj$Bcch' => '<p>GSM broadcast control channel.</p>', ], ], 'BSIC' => [ 'base' => NULL, 'refs' => [ 'GsmLocalId$Bsic' => '<p>GSM base station identity code (BSIC).</p>', 'GsmNmrObj$Bsic' => '<p>GSM base station identity code (BSIC).</p>', ], ], 'BaseLat' => [ 'base' => NULL, 'refs' => [ 'CdmaObj$BaseLat' => '<p>CDMA base station latitude in degrees.</p>', ], ], 'BaseLng' => [ 'base' => NULL, 'refs' => [ 'CdmaObj$BaseLng' => '<p>CDMA base station longitude in degrees.</p>', ], ], 'BaseStationId' => [ 'base' => NULL, 'refs' => [ 'CdmaNmrObj$BaseStationId' => '<p>CDMA base station ID (BSID).</p>', 'CdmaObj$BaseStationId' => '<p>CDMA base station ID (BSID).</p>', ], ], 'BatteryLevel' => [ 'base' => '<p>Sidewalk device battery level.</p>', 'refs' => [ 'SidewalkDeviceMetadata$BatteryLevel' => '<p>Sidewalk device battery level.</p>', ], ], 'Beaconing' => [ 'base' => '<p>Beaconing parameters for configuring the wireless gateways.</p>', 'refs' => [ 'LoRaWANGateway$Beaconing' => '<p>Beaconing object information, which consists of the data rate and frequency parameters.</p>', ], ], 'BeaconingDataRate' => [ 'base' => NULL, 'refs' => [ 'Beaconing$DataRate' => '<p>The data rate for gateways that are sending the beacons.</p>', ], ], 'BeaconingFrequencies' => [ 'base' => NULL, 'refs' => [ 'Beaconing$Frequencies' => '<p>The frequency list for the gateways to send the beacons.</p>', ], ], 'BeaconingFrequency' => [ 'base' => NULL, 'refs' => [ 'BeaconingFrequencies$member' => NULL, ], ], 'CancelMulticastGroupSessionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CancelMulticastGroupSessionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CaptureTimeAccuracy' => [ 'base' => NULL, 'refs' => [ 'Gnss$CaptureTimeAccuracy' => '<p>Optional value that gives the capture time estimate accuracy, in seconds. If capture time accuracy is not specified, default value of 300 is used.</p>', ], ], 'CdmaChannel' => [ 'base' => NULL, 'refs' => [ 'CdmaLocalId$CdmaChannel' => '<p>CDMA channel information.</p>', 'CdmaNmrObj$CdmaChannel' => '<p>CDMA channel information.</p>', ], ], 'CdmaList' => [ 'base' => NULL, 'refs' => [ 'CellTowers$Cdma' => '<p>CDMA object information.</p>', ], ], 'CdmaLocalId' => [ 'base' => '<p>CDMA local ID information, which corresponds to the local identification parameters of a CDMA cell.</p>', 'refs' => [ 'CdmaObj$CdmaLocalId' => '<p>CDMA local identification (local ID) parameters.</p>', ], ], 'CdmaNmrList' => [ 'base' => NULL, 'refs' => [ 'CdmaObj$CdmaNmr' => '<p>CDMA network measurement reports.</p>', ], ], 'CdmaNmrObj' => [ 'base' => '<p>CDMA object for network measurement reports.</p>', 'refs' => [ 'CdmaNmrList$member' => NULL, ], ], 'CdmaObj' => [ 'base' => '<p>CDMA (Code-division multiple access) object.</p>', 'refs' => [ 'CdmaList$member' => NULL, ], ], 'CellParams' => [ 'base' => NULL, 'refs' => [ 'TdscdmaLocalId$CellParams' => '<p>Cell parameters for TD-SCDMA.</p>', 'TdscdmaNmrObj$CellParams' => '<p>Cell parameters for TD-SCDMA network measurement reports object.</p>', ], ], 'CellTowers' => [ 'base' => '<p>The cell towers that were used to perform the measurements.</p>', 'refs' => [ 'GetPositionEstimateRequest$CellTowers' => '<p>Retrieves an estimated device position by resolving measurement data from cellular radio towers. The position is resolved using HERE\'s cellular-based solver.</p>', ], ], 'CertificateList' => [ 'base' => '<p>List of sidewalk certificates.</p>', 'refs' => [ 'DeviceCertificateList$member' => NULL, 'PrivateKeysList$member' => NULL, ], ], 'CertificatePEM' => [ 'base' => NULL, 'refs' => [ 'GetServiceEndpointResponse$ServerTrust' => '<p>The Root CA of the server trust certificate.</p>', ], ], 'CertificateValue' => [ 'base' => '<p>Certificate value.</p>', 'refs' => [ 'CertificateList$Value' => '<p>The value of the chosen sidewalk certificate.</p>', ], ], 'ChannelMask' => [ 'base' => NULL, 'refs' => [ 'LoRaWANGetServiceProfileInfo$ChannelMask' => '<p>The ChannelMask value.</p>', ], ], 'ClassBTimeout' => [ 'base' => NULL, 'refs' => [ 'LoRaWANDeviceProfile$ClassBTimeout' => '<p>The ClassBTimeout value.</p>', ], ], 'ClassCTimeout' => [ 'base' => NULL, 'refs' => [ 'LoRaWANDeviceProfile$ClassCTimeout' => '<p>The ClassCTimeout value.</p>', ], ], 'ClientRequestToken' => [ 'base' => '<p>Each resource must have a unique client request token. The client token is used to implement idempotency. It ensures that the request completes no more than one time. If you retry a request with the same token and the same parameters, the request will complete successfully. However, if you try to create a new resource using the same token but different parameters, an HTTP 409 conflict occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. For more information about idempotency, see <a href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">Ensuring idempotency in Amazon EC2 API requests</a>.</p>', 'refs' => [ 'AssociateAwsAccountWithPartnerAccountRequest$ClientRequestToken' => '<p>Each resource must have a unique client request token. The client token is used to implement idempotency. It ensures that the request completes no more than one time. If you retry a request with the same token and the same parameters, the request will complete successfully. However, if you try to create a new resource using the same token but different parameters, an HTTP 409 conflict occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. For more information about idempotency, see <a href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">Ensuring idempotency in Amazon EC2 API requests</a>.</p>', 'CreateDestinationRequest$ClientRequestToken' => '<p>Each resource must have a unique client request token. The client token is used to implement idempotency. It ensures that the request completes no more than one time. If you retry a request with the same token and the same parameters, the request will complete successfully. However, if you try to create a new resource using the same token but different parameters, an HTTP 409 conflict occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. For more information about idempotency, see <a href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">Ensuring idempotency in Amazon EC2 API requests</a>.</p>', 'CreateDeviceProfileRequest$ClientRequestToken' => '<p>Each resource must have a unique client request token. The client token is used to implement idempotency. It ensures that the request completes no more than one time. If you retry a request with the same token and the same parameters, the request will complete successfully. However, if you try to create a new resource using the same token but different parameters, an HTTP 409 conflict occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. For more information about idempotency, see <a href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">Ensuring idempotency in Amazon EC2 API requests</a>.</p>', 'CreateFuotaTaskRequest$ClientRequestToken' => NULL, 'CreateMulticastGroupRequest$ClientRequestToken' => '<p>Each resource must have a unique client request token. The client token is used to implement idempotency. It ensures that the request completes no more than one time. If you retry a request with the same token and the same parameters, the request will complete successfully. However, if you try to create a new resource using the same token but different parameters, an HTTP 409 conflict occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. For more information about idempotency, see <a href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">Ensuring idempotency in Amazon EC2 API requests</a>.</p>', 'CreateNetworkAnalyzerConfigurationRequest$ClientRequestToken' => NULL, 'CreateServiceProfileRequest$ClientRequestToken' => '<p>Each resource must have a unique client request token. The client token is used to implement idempotency. It ensures that the request completes no more than one time. If you retry a request with the same token and the same parameters, the request will complete successfully. However, if you try to create a new resource using the same token but different parameters, an HTTP 409 conflict occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. For more information about idempotency, see <a href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">Ensuring idempotency in Amazon EC2 API requests</a>.</p>', 'CreateWirelessDeviceRequest$ClientRequestToken' => '<p>Each resource must have a unique client request token. The client token is used to implement idempotency. It ensures that the request completes no more than one time. If you retry a request with the same token and the same parameters, the request will complete successfully. However, if you try to create a new resource using the same token but different parameters, an HTTP 409 conflict occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. For more information about idempotency, see <a href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">Ensuring idempotency in Amazon EC2 API requests</a>.</p>', 'CreateWirelessGatewayRequest$ClientRequestToken' => '<p>Each resource must have a unique client request token. The client token is used to implement idempotency. It ensures that the request completes no more than one time. If you retry a request with the same token and the same parameters, the request will complete successfully. However, if you try to create a new resource using the same token but different parameters, an HTTP 409 conflict occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. For more information about idempotency, see <a href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">Ensuring idempotency in Amazon EC2 API requests</a>.</p>', 'CreateWirelessGatewayTaskDefinitionRequest$ClientRequestToken' => '<p>Each resource must have a unique client request token. The client token is used to implement idempotency. It ensures that the request completes no more than one time. If you retry a request with the same token and the same parameters, the request will complete successfully. However, if you try to create a new resource using the same token but different parameters, an HTTP 409 conflict occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. For more information about idempotency, see <a href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">Ensuring idempotency in Amazon EC2 API requests</a>.</p>', 'StartSingleWirelessDeviceImportTaskRequest$ClientRequestToken' => NULL, 'StartWirelessDeviceImportTaskRequest$ClientRequestToken' => NULL, ], ], 'ConflictException' => [ 'base' => '<p>Adding, updating, or deleting the resource can cause an inconsistent state.</p>', 'refs' => [], ], 'ConnectionStatus' => [ 'base' => NULL, 'refs' => [ 'GetWirelessGatewayStatisticsResponse$ConnectionStatus' => '<p>The connection status of the wireless gateway.</p>', ], ], 'ConnectionStatusEventConfiguration' => [ 'base' => '<p>Connection status event configuration object for enabling or disabling topic.</p>', 'refs' => [ 'EventNotificationItemConfigurations$ConnectionStatus' => '<p>Connection status event configuration for an event configuration item.</p>', 'GetResourceEventConfigurationResponse$ConnectionStatus' => '<p>Event configuration for the connection status event.</p>', 'UpdateResourceEventConfigurationRequest$ConnectionStatus' => '<p>Event configuration for the connection status event.</p>', ], ], 'ConnectionStatusResourceTypeEventConfiguration' => [ 'base' => '<p>Connection status resource type event configuration object for enabling or disabling topic.</p>', 'refs' => [ 'GetEventConfigurationByResourceTypesResponse$ConnectionStatus' => '<p>Resource type event configuration for the connection status event.</p>', 'UpdateEventConfigurationByResourceTypesRequest$ConnectionStatus' => '<p>Connection status resource type event configuration object for enabling and disabling wireless gateway topic.</p>', ], ], 'Coordinate' => [ 'base' => NULL, 'refs' => [ 'AssistPosition$member' => NULL, 'Gnss$AssistAltitude' => '<p>Optional assistance altitude, which is the altitude of the device at capture time, specified in meters above the WGS84 reference ellipsoid.</p>', ], ], 'Crc' => [ 'base' => NULL, 'refs' => [ 'LoRaWANUpdateGatewayTaskCreate$SigKeyCrc' => '<p>The CRC of the signature private key to check.</p>', ], ], 'CreateDestinationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDestinationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateDeviceProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDeviceProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateFuotaTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateFuotaTaskResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateMulticastGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateMulticastGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateNetworkAnalyzerConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateNetworkAnalyzerConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateServiceProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateServiceProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateWirelessDeviceRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateWirelessDeviceResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateWirelessGatewayRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateWirelessGatewayResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateWirelessGatewayTaskDefinitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateWirelessGatewayTaskDefinitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateWirelessGatewayTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateWirelessGatewayTaskResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreatedAt' => [ 'base' => '<p>Created at timestamp for the resource.</p>', 'refs' => [ 'GetFuotaTaskResponse$CreatedAt' => NULL, 'GetMulticastGroupResponse$CreatedAt' => NULL, ], ], 'CreationDate' => [ 'base' => NULL, 'refs' => [ 'GetPositionEstimateRequest$Timestamp' => '<p>Optional information that specifies the time when the position information will be resolved. It uses the Unix timestamp format. If not specified, the time at which the request was received will be used.</p>', ], ], 'CreationTime' => [ 'base' => NULL, 'refs' => [ 'GetWirelessDeviceImportTaskResponse$CreationTime' => '<p>The time at which the import task was created.</p>', 'WirelessDeviceImportTask$CreationTime' => '<p>The time at which the import task was created.</p>', ], ], 'DakCertificateId' => [ 'base' => NULL, 'refs' => [ 'DakCertificateMetadata$CertificateId' => '<p>The certificate ID for the DAK.</p>', 'SidewalkDevice$CertificateId' => '<p>The ID of the Sidewalk device profile.</p>', ], ], 'DakCertificateMetadata' => [ 'base' => '<p>The device attestation key (DAK) information.</p>', 'refs' => [ 'DakCertificateMetadataList$member' => NULL, ], ], 'DakCertificateMetadataList' => [ 'base' => NULL, 'refs' => [ 'SidewalkGetDeviceProfile$DakCertificateMetadata' => '<p>The DAK certificate information of the Sidewalk device profile.</p>', ], ], 'DeleteDestinationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDestinationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDeviceProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDeviceProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFuotaTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFuotaTaskResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMulticastGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMulticastGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteNetworkAnalyzerConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteNetworkAnalyzerConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteQueuedMessagesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteQueuedMessagesResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteServiceProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteServiceProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWirelessDeviceImportTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWirelessDeviceImportTaskResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWirelessDeviceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWirelessDeviceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWirelessGatewayRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWirelessGatewayResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWirelessGatewayTaskDefinitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWirelessGatewayTaskDefinitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWirelessGatewayTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWirelessGatewayTaskResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterWirelessDeviceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterWirelessDeviceResponse' => [ 'base' => NULL, 'refs' => [], ], 'Description' => [ 'base' => '<p>The description of the new resource.</p>', 'refs' => [ 'CreateDestinationRequest$Description' => '<p>The description of the new resource.</p>', 'CreateFuotaTaskRequest$Description' => NULL, 'CreateMulticastGroupRequest$Description' => '<p>The description of the multicast group.</p>', 'CreateNetworkAnalyzerConfigurationRequest$Description' => NULL, 'CreateWirelessDeviceRequest$Description' => '<p>The description of the new resource.</p>', 'CreateWirelessGatewayRequest$Description' => '<p>The description of the new resource.</p>', 'Destinations$Description' => '<p>The description of the resource.</p>', 'GetDestinationResponse$Description' => '<p>The description of the resource.</p>', 'GetFuotaTaskResponse$Description' => NULL, 'GetMulticastGroupResponse$Description' => NULL, 'GetNetworkAnalyzerConfigurationResponse$Description' => NULL, 'GetWirelessDeviceResponse$Description' => '<p>The description of the resource.</p>', 'GetWirelessGatewayResponse$Description' => '<p>The description of the resource.</p>', 'UpdateDestinationRequest$Description' => '<p>A new description of the resource.</p>', 'UpdateFuotaTaskRequest$Description' => NULL, 'UpdateMulticastGroupRequest$Description' => NULL, 'UpdateNetworkAnalyzerConfigurationRequest$Description' => NULL, 'UpdateWirelessDeviceRequest$Description' => '<p>A new description of the resource.</p>', 'UpdateWirelessGatewayRequest$Description' => '<p>A new description of the resource.</p>', 'WirelessGatewayStatistics$Description' => '<p>The description of the resource.</p>', ], ], 'DestinationArn' => [ 'base' => NULL, 'refs' => [ 'CreateDestinationResponse$Arn' => '<p>The Amazon Resource Name of the new resource.</p>', 'Destinations$Arn' => '<p>The Amazon Resource Name of the resource.</p>', 'GetDestinationResponse$Arn' => '<p>The Amazon Resource Name of the resource.</p>', ], ], 'DestinationList' => [ 'base' => NULL, 'refs' => [ 'ListDestinationsResponse$DestinationList' => '<p>The list of destinations.</p>', ], ], 'DestinationName' => [ 'base' => NULL, 'refs' => [ 'ApplicationConfig$DestinationName' => '<p>The name of the position data destination that describes the AWS IoT rule that processes the device\'s position data for use by AWS IoT Core for LoRaWAN.</p>', 'CreateDestinationRequest$Name' => '<p>The name of the new resource.</p>', 'CreateDestinationResponse$Name' => '<p>The name of the new resource.</p>', 'CreateWirelessDeviceRequest$DestinationName' => '<p>The name of the destination to assign to the new wireless device.</p>', 'DeleteDestinationRequest$Name' => '<p>The name of the resource to delete.</p>', 'Destinations$Name' => '<p>The name of the resource.</p>', 'GetDestinationRequest$Name' => '<p>The name of the resource to get.</p>', 'GetDestinationResponse$Name' => '<p>The name of the resource.</p>', 'GetPositionConfigurationResponse$Destination' => '<p>The position data destination that describes the AWS IoT rule that processes the device\'s position data for use by AWS IoT Core for LoRaWAN.</p>', 'GetWirelessDeviceImportTaskResponse$DestinationName' => '<p>The name of the destination that\'s assigned to the wireless devices in the import task.</p>', 'GetWirelessDeviceResponse$DestinationName' => '<p>The name of the destination to which the device is assigned.</p>', 'ListDevicesForWirelessDeviceImportTaskResponse$DestinationName' => '<p>The name of the Sidewalk destination that describes the IoT rule to route messages received from devices in an import task that are onboarded to AWS IoT Wireless.</p>', 'ListWirelessDevicesRequest$DestinationName' => '<p>A filter to list only the wireless devices that use this destination.</p>', 'PositionConfigurationItem$Destination' => '<p>The position data destination that describes the AWS IoT rule that processes the device\'s position data for use by AWS IoT Core for LoRaWAN.</p>', 'PutPositionConfigurationRequest$Destination' => '<p>The position data destination that describes the AWS IoT rule that processes the device\'s position data for use by AWS IoT Core for LoRaWAN.</p>', 'StartSingleWirelessDeviceImportTaskRequest$DestinationName' => '<p>The name of the Sidewalk destination that describes the IoT rule to route messages from the device in the import task that will be onboarded to AWS IoT Wireless.</p>', 'StartWirelessDeviceImportTaskRequest$DestinationName' => '<p>The name of the Sidewalk destination that describes the IoT rule to route messages from the devices in the import task that are onboarded to AWS IoT Wireless.</p>', 'UpdateDestinationRequest$Name' => '<p>The new name of the resource.</p>', 'UpdateWirelessDeviceRequest$DestinationName' => '<p>The name of the new destination for the device.</p>', 'WirelessDeviceImportTask$DestinationName' => '<p>The name of the Sidewalk destination that that describes the IoT rule to route messages from the device in the import task that will be onboarded to AWS IoT Wireless</p>', 'WirelessDeviceStatistics$DestinationName' => '<p>The name of the destination to which the device is assigned.</p>', ], ], 'Destinations' => [ 'base' => '<p>Describes a destination.</p>', 'refs' => [ 'DestinationList$member' => NULL, ], ], 'DevAddr' => [ 'base' => NULL, 'refs' => [ 'AbpV1_0_x$DevAddr' => '<p>The DevAddr value.</p>', 'AbpV1_1$DevAddr' => '<p>The DevAddr value.</p>', ], ], 'DevEui' => [ 'base' => NULL, 'refs' => [ 'LoRaWANDevice$DevEui' => '<p>The DevEUI value.</p>', 'LoRaWANDeviceMetadata$DevEui' => '<p>The DevEUI value.</p>', 'LoRaWANListDevice$DevEui' => '<p>The DevEUI value.</p>', ], ], 'DevStatusReqFreq' => [ 'base' => NULL, 'refs' => [ 'LoRaWANGetServiceProfileInfo$DevStatusReqFreq' => '<p>The DevStatusReqFreq value.</p>', ], ], 'DeviceCertificateList' => [ 'base' => '<p>List of device certificate chain.</p>', 'refs' => [ 'SidewalkDevice$DeviceCertificates' => '<p>The sidewalk device certificates for Ed25519 and P256r1.</p>', 'SidewalkListDevice$DeviceCertificates' => '<p>The sidewalk device certificates for Ed25519 and P256r1.</p>', ], ], 'DeviceCreationFile' => [ 'base' => NULL, 'refs' => [ 'DeviceCreationFileList$member' => NULL, 'SidewalkStartImportInfo$DeviceCreationFile' => '<p>The CSV file contained in an S3 bucket that\'s used for adding devices to an import task.</p>', 'SidewalkUpdateImportInfo$DeviceCreationFile' => '<p>The CSV file contained in an S3 bucket that\'s used for appending devices to an existing import task.</p>', ], ], 'DeviceCreationFileList' => [ 'base' => NULL, 'refs' => [ 'SidewalkGetStartImportInfo$DeviceCreationFileList' => '<p>List of Sidewalk devices that are added to the import task.</p>', ], ], 'DeviceName' => [ 'base' => NULL, 'refs' => [ 'StartSingleWirelessDeviceImportTaskRequest$DeviceName' => '<p>The name of the wireless device for which an import task is being started.</p>', ], ], 'DeviceProfile' => [ 'base' => '<p>Describes a device profile.</p>', 'refs' => [ 'DeviceProfileList$member' => NULL, ], ], 'DeviceProfileArn' => [ 'base' => NULL, 'refs' => [ 'CreateDeviceProfileResponse$Arn' => '<p>The Amazon Resource Name of the new resource.</p>', 'DeviceProfile$Arn' => '<p>The Amazon Resource Name of the resource.</p>', 'GetDeviceProfileResponse$Arn' => '<p>The Amazon Resource Name of the resource.</p>', ], ], 'DeviceProfileId' => [ 'base' => NULL, 'refs' => [ 'CreateDeviceProfileResponse$Id' => '<p>The ID of the new device profile.</p>', 'DeleteDeviceProfileRequest$Id' => '<p>The ID of the resource to delete.</p>', 'DeviceProfile$Id' => '<p>The ID of the device profile.</p>', 'GetDeviceProfileRequest$Id' => '<p>The ID of the resource to get.</p>', 'GetDeviceProfileResponse$Id' => '<p>The ID of the device profile.</p>', 'ListWirelessDevicesRequest$DeviceProfileId' => '<p>A filter to list only the wireless devices that use this device profile.</p>', 'LoRaWANDevice$DeviceProfileId' => '<p>The ID of the device profile for the new wireless device.</p>', 'LoRaWANUpdateDevice$DeviceProfileId' => '<p>The ID of the device profile for the wireless device.</p>', 'SidewalkCreateWirelessDevice$DeviceProfileId' => '<p>The ID of the Sidewalk device profile.</p>', 'SidewalkDevice$DeviceProfileId' => '<p>The ID of the Sidewalk device profile.</p>', 'SidewalkListDevice$DeviceProfileId' => '<p>Sidewalk object used by list functions.</p>', ], ], 'DeviceProfileList' => [ 'base' => NULL, 'refs' => [ 'ListDeviceProfilesResponse$DeviceProfileList' => '<p>The list of device profiles.</p>', ], ], 'DeviceProfileName' => [ 'base' => NULL, 'refs' => [ 'CreateDeviceProfileRequest$Name' => '<p>The name of the new resource.</p>', 'DeviceProfile$Name' => '<p>The name of the resource.</p>', 'GetDeviceProfileResponse$Name' => '<p>The name of the resource.</p>', ], ], 'DeviceProfileType' => [ 'base' => NULL, 'refs' => [ 'ListDeviceProfilesRequest$DeviceProfileType' => '<p>A filter to list only device profiles that use this type, which can be <code>LoRaWAN</code> or <code>Sidewalk</code>.</p>', ], ], 'DeviceRegistrationStateEventConfiguration' => [ 'base' => '<p>Device registration state event configuration object for enabling and disabling relevant topics.</p>', 'refs' => [ 'EventNotificationItemConfigurations$DeviceRegistrationState' => '<p>Device registration state event configuration for an event configuration item.</p>', 'GetResourceEventConfigurationResponse$DeviceRegistrationState' => '<p>Event configuration for the device registration state event.</p>', 'UpdateResourceEventConfigurationRequest$DeviceRegistrationState' => '<p>Event configuration for the device registration state event.</p>', ], ], 'DeviceRegistrationStateResourceTypeEventConfiguration' => [ 'base' => '<p>Device registration state resource type event configuration object for enabling or disabling topic.</p>', 'refs' => [ 'GetEventConfigurationByResourceTypesResponse$DeviceRegistrationState' => '<p>Resource type event configuration for the device registration state event.</p>', 'UpdateEventConfigurationByResourceTypesRequest$DeviceRegistrationState' => '<p>Device registration state resource type event configuration object for enabling and disabling wireless gateway topic.</p>', ], ], 'DeviceState' => [ 'base' => '<p>Device state defines the device status of sidewalk device.</p>', 'refs' => [ 'SidewalkDeviceMetadata$DeviceState' => '<p>Device state defines the device status of sidewalk device.</p>', ], ], 'DeviceTypeId' => [ 'base' => NULL, 'refs' => [ 'DakCertificateMetadata$DeviceTypeId' => '<p>The device type ID that\'s used for prototyping applications.</p>', ], ], 'Dimension' => [ 'base' => '<p>The required list of dimensions for the metric.</p>', 'refs' => [ 'Dimensions$member' => NULL, ], ], 'DimensionName' => [ 'base' => NULL, 'refs' => [ 'Dimension$name' => '<p>The name of the dimension.</p>', ], ], 'DimensionValue' => [ 'base' => NULL, 'refs' => [ 'Dimension$value' => '<p>The dimension\'s value.</p>', ], ], 'Dimensions' => [ 'base' => NULL, 'refs' => [ 'SummaryMetricQuery$Dimensions' => '<p>The dimensions of the summary metric.</p>', 'SummaryMetricQueryResult$Dimensions' => '<p>The dimensions of the metric.</p>', ], ], 'DisassociateAwsAccountFromPartnerAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateAwsAccountFromPartnerAccountResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateMulticastGroupFromFuotaTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateMulticastGroupFromFuotaTaskResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateWirelessDeviceFromFuotaTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateWirelessDeviceFromFuotaTaskResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateWirelessDeviceFromMulticastGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateWirelessDeviceFromMulticastGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateWirelessDeviceFromThingRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateWirelessDeviceFromThingResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateWirelessGatewayFromCertificateRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateWirelessGatewayFromCertificateResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateWirelessGatewayFromThingRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateWirelessGatewayFromThingResponse' => [ 'base' => NULL, 'refs' => [], ], 'DlAllowed' => [ 'base' => NULL, 'refs' => [ 'LoRaWANPublicGatewayMetadata$DlAllowed' => '<p>Boolean that indicates whether downlink is allowed using the network.</p>', ], ], 'DlBucketSize' => [ 'base' => NULL, 'refs' => [ 'LoRaWANGetServiceProfileInfo$DlBucketSize' => '<p>The DLBucketSize value.</p>', ], ], 'DlClass' => [ 'base' => '<p>DlClass for LoRaWAM, valid values are ClassB and ClassC.</p>', 'refs' => [ 'LoRaWANMulticast$DlClass' => NULL, 'LoRaWANMulticastGet$DlClass' => NULL, ], ], 'DlDr' => [ 'base' => '<p>Downlink data rate.</p>', 'refs' => [ 'LoRaWANMulticastSession$DlDr' => NULL, ], ], 'DlFreq' => [ 'base' => '<p>Downlink frequency.</p>', 'refs' => [ 'LoRaWANMulticastSession$DlFreq' => NULL, ], ], 'DlRate' => [ 'base' => NULL, 'refs' => [ 'LoRaWANGetServiceProfileInfo$DlRate' => '<p>The DLRate value.</p>', ], ], 'DlRatePolicy' => [ 'base' => NULL, 'refs' => [ 'LoRaWANGetServiceProfileInfo$DlRatePolicy' => '<p>The DLRatePolicy value.</p>', ], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'LoRaWANGatewayMetadata$Snr' => '<p>The SNR value.</p>', 'LoRaWANGatewayMetadata$Rssi' => '<p>The RSSI value.</p>', 'LoRaWANPublicGatewayMetadata$Rssi' => '<p>The RSSI (received signal strength indicator) value.</p>', 'LoRaWANPublicGatewayMetadata$Snr' => '<p>The SNR (signal to noise ratio) value.</p>', ], ], 'DownlinkFrequency' => [ 'base' => NULL, 'refs' => [ 'GatewayListItem$DownlinkFrequency' => '<p>The frequency to use for the gateways when sending a downlink message to the wireless device.</p>', ], ], 'DownlinkMode' => [ 'base' => NULL, 'refs' => [ 'ParticipatingGateways$DownlinkMode' => '<p>Indicates whether to send the downlink message in sequential mode or concurrent mode, or to use only the chosen gateways from the previous uplink message transmission.</p>', ], ], 'DownlinkQueueMessage' => [ 'base' => '<p>The message in the downlink queue.</p>', 'refs' => [ 'DownlinkQueueMessagesList$member' => NULL, ], ], 'DownlinkQueueMessagesList' => [ 'base' => NULL, 'refs' => [ 'ListQueuedMessagesResponse$DownlinkQueueMessagesList' => '<p>The messages in the downlink queue.</p>', ], ], 'DrMax' => [ 'base' => NULL, 'refs' => [ 'LoRaWANGetServiceProfileInfo$DrMax' => '<p>The DRMax value.</p>', ], ], 'DrMaxBox' => [ 'base' => NULL, 'refs' => [ 'LoRaWANServiceProfile$DrMax' => '<p>The DrMax value.</p>', ], ], 'DrMin' => [ 'base' => NULL, 'refs' => [ 'LoRaWANGetServiceProfileInfo$DrMin' => '<p>The DRMin value.</p>', ], ], 'DrMinBox' => [ 'base' => NULL, 'refs' => [ 'LoRaWANServiceProfile$DrMin' => '<p>The DrMin value.</p>', ], ], 'EARFCN' => [ 'base' => NULL, 'refs' => [ 'LteLocalId$Earfcn' => '<p>Evolved universal terrestrial radio access (E-UTRA) absolute radio frequency channel number (FCN).</p>', 'LteNmrObj$Earfcn' => '<p>E-UTRA (Evolved universal terrestrial Radio Access) absolute radio frequency channel Number (EARFCN).</p>', ], ], 'EndPoint' => [ 'base' => NULL, 'refs' => [ 'GetServiceEndpointResponse$ServiceEndpoint' => '<p>The service endpoint value.</p>', ], ], 'EutranCid' => [ 'base' => NULL, 'refs' => [ 'LteNmrObj$EutranCid' => '<p>E-UTRAN (Evolved Universal Terrestrial Radio Access Network) cell global identifier (EUTRANCID).</p>', 'LteObj$EutranCid' => '<p>E-UTRAN (Evolved Universal Terrestrial Radio Access Network) Cell Global Identifier.</p>', ], ], 'Event' => [ 'base' => '<p>Sidewalk device status notification.</p>', 'refs' => [ 'SidewalkDeviceMetadata$Event' => '<p>Sidewalk device status notification.</p>', ], ], 'EventConfigurationItem' => [ 'base' => '<p>Event configuration object for a single resource.</p>', 'refs' => [ 'EventConfigurationsList$member' => NULL, ], ], 'EventConfigurationsList' => [ 'base' => NULL, 'refs' => [ 'ListEventConfigurationsResponse$EventConfigurationsList' => '<p>Event configurations of all events for a single resource.</p>', ], ], 'EventNotificationItemConfigurations' => [ 'base' => '<p>Object of all event configurations and the status of the event topics.</p>', 'refs' => [ 'EventConfigurationItem$Events' => NULL, ], ], 'EventNotificationPartnerType' => [ 'base' => NULL, 'refs' => [ 'EventConfigurationItem$PartnerType' => '<p>Partner type of the resource if the identifier type is PartnerAccountId.</p>', 'GetResourceEventConfigurationRequest$PartnerType' => '<p>Partner type of the resource if the identifier type is <code>PartnerAccountId</code>.</p>', 'UpdateResourceEventConfigurationRequest$PartnerType' => '<p>Partner type of the resource if the identifier type is <code>PartnerAccountId</code> </p>', ], ], 'EventNotificationResourceType' => [ 'base' => NULL, 'refs' => [ 'ListEventConfigurationsRequest$ResourceType' => '<p>Resource type to filter event configurations.</p>', ], ], 'EventNotificationTopicStatus' => [ 'base' => NULL, 'refs' => [ 'ConnectionStatusEventConfiguration$WirelessGatewayIdEventTopic' => '<p>Denotes whether the wireless gateway ID connection status event topic is enabled or disabled.</p>', 'DeviceRegistrationStateEventConfiguration$WirelessDeviceIdEventTopic' => '<p>Denotes whether the wireless device ID device registration state event topic is enabled or disabled.</p>', 'JoinEventConfiguration$WirelessDeviceIdEventTopic' => '<p>Denotes whether the wireless device ID join event topic is enabled or disabled.</p>', 'LoRaWANConnectionStatusEventNotificationConfigurations$GatewayEuiEventTopic' => '<p>Denotes whether the gateway EUI connection status event topic is enabled or disabled.</p>', 'LoRaWANConnectionStatusResourceTypeEventConfiguration$WirelessGatewayEventTopic' => '<p>Denotes whether the wireless gateway connection status event topic is enabled or disabled.</p>', 'LoRaWANJoinEventNotificationConfigurations$DevEuiEventTopic' => '<p>Denotes whether the Dev EUI join event topic is enabled or disabled.</p>', 'LoRaWANJoinResourceTypeEventConfiguration$WirelessDeviceEventTopic' => '<p>Denotes whether the wireless device join event topic is enabled or disabled.</p>', 'MessageDeliveryStatusEventConfiguration$WirelessDeviceIdEventTopic' => '<p>Denotes whether the wireless device ID message delivery status event topic is enabled or disabled.</p>', 'ProximityEventConfiguration$WirelessDeviceIdEventTopic' => '<p>Denotes whether the wireless device ID proximity event topic is enabled or disabled.</p>', 'SidewalkEventNotificationConfigurations$AmazonIdEventTopic' => '<p>Denotes whether the Amazon ID event topic is enabled or disabled.</p>', 'SidewalkResourceTypeEventConfiguration$WirelessDeviceEventTopic' => '<p>Denotes whether the wireless device join event topic is enabled or disabled.</p>', ], ], 'Expression' => [ 'base' => NULL, 'refs' => [ 'CreateDestinationRequest$Expression' => '<p>The rule name or topic rule to send messages to.</p>', 'Destinations$Expression' => '<p>The rule name or topic rule to send messages to.</p>', 'GetDestinationResponse$Expression' => '<p>The rule name or topic rule to send messages to.</p>', 'UpdateDestinationRequest$Expression' => '<p>The new rule name or topic rule to send messages to.</p>', ], ], 'ExpressionType' => [ 'base' => NULL, 'refs' => [ 'CreateDestinationRequest$ExpressionType' => '<p>The type of value in <code>Expression</code>.</p>', 'Destinations$ExpressionType' => '<p>The type of value in <code>Expression</code>.</p>', 'GetDestinationResponse$ExpressionType' => '<p>The type of value in <code>Expression</code>.</p>', 'UpdateDestinationRequest$ExpressionType' => '<p>The type of value in <code>Expression</code>.</p>', ], ], 'FCntStart' => [ 'base' => '<p>The FCnt init value.</p>', 'refs' => [ 'AbpV1_0_x$FCntStart' => '<p>The FCnt init value.</p>', 'AbpV1_1$FCntStart' => '<p>The FCnt init value.</p>', 'UpdateAbpV1_0_x$FCntStart' => '<p>The FCnt init value.</p>', 'UpdateAbpV1_1$FCntStart' => '<p>The FCnt init value.</p>', ], ], 'FNwkSIntKey' => [ 'base' => NULL, 'refs' => [ 'SessionKeysAbpV1_1$FNwkSIntKey' => '<p>The FNwkSIntKey value.</p>', ], ], 'FPort' => [ 'base' => '<p>The Fport value.</p>', 'refs' => [ 'ApplicationConfig$FPort' => NULL, 'FPorts$Fuota' => NULL, 'FPorts$Multicast' => NULL, 'FPorts$ClockSync' => NULL, 'LoRaWANMulticastMetadata$FPort' => NULL, 'LoRaWANSendDataToDevice$FPort' => NULL, 'Positioning$ClockSync' => NULL, 'Positioning$Stream' => NULL, 'Positioning$Gnss' => NULL, ], ], 'FPorts' => [ 'base' => '<p>List of FPort assigned for different LoRaWAN application packages to use</p>', 'refs' => [ 'LoRaWANDevice$FPorts' => NULL, ], ], 'FactoryPresetFreqsList' => [ 'base' => NULL, 'refs' => [ 'LoRaWANDeviceProfile$FactoryPresetFreqsList' => '<p>The list of values that make up the FactoryPresetFreqs value.</p>', ], ], 'FactorySupport' => [ 'base' => NULL, 'refs' => [ 'DakCertificateMetadata$FactorySupport' => '<p>Whether factory support has been enabled.</p>', ], ], 'Fingerprint' => [ 'base' => NULL, 'refs' => [ 'SidewalkAccountInfoWithFingerprint$Fingerprint' => '<p>The fingerprint of the Sidewalk application server private key.</p>', ], ], 'FirmwareUpdateImage' => [ 'base' => '<p>The S3 URI points to a firmware update image that is to be used with a FUOTA task.</p>', 'refs' => [ 'CreateFuotaTaskRequest$FirmwareUpdateImage' => NULL, 'GetFuotaTaskResponse$FirmwareUpdateImage' => NULL, 'UpdateFuotaTaskRequest$FirmwareUpdateImage' => NULL, ], ], 'FirmwareUpdateRole' => [ 'base' => '<p>The firmware update role that is to be used with a FUOTA task.</p>', 'refs' => [ 'CreateFuotaTaskRequest$FirmwareUpdateRole' => NULL, 'GetFuotaTaskResponse$FirmwareUpdateRole' => NULL, 'UpdateFuotaTaskRequest$FirmwareUpdateRole' => NULL, ], ], 'FragmentIntervalMS' => [ 'base' => '<p>The interval for sending fragments in milliseconds, rounded to the nearest second.</p> <note> <p>This interval only determines the timing for when the Cloud sends down the fragments to yor device. There can be a delay for when your device will receive these fragments. This delay depends on the device\'s class and the communication delay with the cloud.</p> </note>', 'refs' => [ 'CreateFuotaTaskRequest$FragmentIntervalMS' => NULL, 'GetFuotaTaskResponse$FragmentIntervalMS' => NULL, 'UpdateFuotaTaskRequest$FragmentIntervalMS' => NULL, ], ], 'FragmentSizeBytes' => [ 'base' => '<p>The size of each fragment in bytes. This parameter is supported only for FUOTA tasks with multicast groups.</p>', 'refs' => [ 'CreateFuotaTaskRequest$FragmentSizeBytes' => NULL, 'GetFuotaTaskResponse$FragmentSizeBytes' => NULL, 'UpdateFuotaTaskRequest$FragmentSizeBytes' => NULL, ], ], 'FuotaDeviceStatus' => [ 'base' => '<p>The status of a wireless device in a FUOTA task.</p>', 'refs' => [ 'WirelessDeviceStatistics$FuotaDeviceStatus' => NULL, ], ], 'FuotaTask' => [ 'base' => '<p>A FUOTA task.</p>', 'refs' => [ 'FuotaTaskList$member' => NULL, ], ], 'FuotaTaskArn' => [ 'base' => '<p>The arn of a FUOTA task.</p>', 'refs' => [ 'CreateFuotaTaskResponse$Arn' => NULL, 'FuotaTask$Arn' => NULL, 'GetFuotaTaskResponse$Arn' => NULL, ], ], 'FuotaTaskId' => [ 'base' => '<p>The ID of a FUOTA task.</p>', 'refs' => [ 'AssociateMulticastGroupWithFuotaTaskRequest$Id' => NULL, 'AssociateWirelessDeviceWithFuotaTaskRequest$Id' => NULL, 'CreateFuotaTaskResponse$Id' => NULL, 'DeleteFuotaTaskRequest$Id' => NULL, 'DisassociateMulticastGroupFromFuotaTaskRequest$Id' => NULL, 'DisassociateWirelessDeviceFromFuotaTaskRequest$Id' => NULL, 'FuotaTask$Id' => NULL, 'GetFuotaTaskRequest$Id' => NULL, 'GetFuotaTaskResponse$Id' => NULL, 'ListMulticastGroupsByFuotaTaskRequest$Id' => NULL, 'ListWirelessDevicesRequest$FuotaTaskId' => NULL, 'StartFuotaTaskRequest$Id' => NULL, 'UpdateFuotaTaskRequest$Id' => NULL, ], ], 'FuotaTaskList' => [ 'base' => '<p>Lists the FUOTA tasks registered to your AWS account.</p>', 'refs' => [ 'ListFuotaTasksResponse$FuotaTaskList' => NULL, ], ], 'FuotaTaskName' => [ 'base' => '<p>The name of a FUOTA task.</p>', 'refs' => [ 'CreateFuotaTaskRequest$Name' => NULL, 'FuotaTask$Name' => NULL, 'GetFuotaTaskResponse$Name' => NULL, 'UpdateFuotaTaskRequest$Name' => NULL, ], ], 'FuotaTaskStatus' => [ 'base' => '<p>The status of a FUOTA task.</p>', 'refs' => [ 'GetFuotaTaskResponse$Status' => NULL, ], ], 'GPST' => [ 'base' => NULL, 'refs' => [ 'Gnss$CaptureTime' => '<p>Optional parameter that gives an estimate of the time when the GNSS scan information is taken, in seconds GPS time (GPST). If capture time is not specified, the local server time is used.</p>', ], ], 'GatewayEui' => [ 'base' => NULL, 'refs' => [ 'LoRaWANGateway$GatewayEui' => '<p>The gateway\'s EUI value.</p>', 'LoRaWANGatewayMetadata$GatewayEui' => '<p>The gateway\'s EUI value.</p>', ], ], 'GatewayList' => [ 'base' => NULL, 'refs' => [ 'ParticipatingGateways$GatewayList' => '<p>The list of gateways that you want to use for sending the downlink data traffic.</p>', ], ], 'GatewayListItem' => [ 'base' => '<p>Gateway list item object that specifies the frequency and list of gateways for which the downlink message should be sent.</p>', 'refs' => [ 'GatewayList$member' => NULL, ], ], 'GatewayMaxEirp' => [ 'base' => NULL, 'refs' => [ 'LoRaWANGateway$MaxEirp' => '<p>The MaxEIRP value.</p>', 'UpdateWirelessGatewayRequest$MaxEirp' => '<p>The MaxEIRP value.</p>', ], ], 'GenAppKey' => [ 'base' => NULL, 'refs' => [ 'OtaaV1_0_x$GenAppKey' => '<p>The GenAppKey value.</p>', ], ], 'GeoJsonPayload' => [ 'base' => NULL, 'refs' => [ 'GetPositionEstimateResponse$GeoJsonPayload' => '<p>The position information of the resource, displayed as a JSON payload. The payload is of type blob and uses the <a href="https://geojson.org/">GeoJSON</a> format, which a format that\'s used to encode geographic data structures. A sample payload contains the timestamp information, the WGS84 coordinates of the location, and the accuracy and confidence level. For more information and examples, see <a href="https://docs.aws.amazon.com/iot/latest/developerguide/location-resolve-console.html">Resolve device location (console)</a>.</p>', 'GetResourcePositionResponse$GeoJsonPayload' => '<p>The position information of the resource, displayed as a JSON payload. The payload uses the GeoJSON format, which a format that\'s used to encode geographic data structures. For more information, see <a href="https://geojson.org/">GeoJSON</a>.</p>', 'UpdateResourcePositionRequest$GeoJsonPayload' => '<p>The position information of the resource, displayed as a JSON payload. The payload uses the GeoJSON format, which a format that\'s used to encode geographic data structures. For more information, see <a href="https://geojson.org/">GeoJSON</a>.</p>', ], ], 'GeranCid' => [ 'base' => NULL, 'refs' => [ 'GlobalIdentity$GeranCid' => '<p>GERAN (GSM EDGE Radio Access Network) cell global identifier.</p>', 'GsmObj$GeranCid' => '<p>GERAN (GSM EDGE Radio Access Network) Cell Global Identifier.</p>', ], ], 'GetDestinationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDestinationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetDeviceProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDeviceProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetEventConfigurationByResourceTypesRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetEventConfigurationByResourceTypesResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetFuotaTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetFuotaTaskResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetLogLevelsByResourceTypesRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetLogLevelsByResourceTypesResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetMetricConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMetricConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetMetricsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMetricsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetMulticastGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMulticastGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetMulticastGroupSessionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMulticastGroupSessionResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetNetworkAnalyzerConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetNetworkAnalyzerConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetPartnerAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPartnerAccountResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetPositionConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPositionConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetPositionEstimateRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPositionEstimateResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetPositionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPositionResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetResourceEventConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetResourceEventConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetResourceLogLevelRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetResourceLogLevelResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetResourcePositionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetResourcePositionResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetServiceEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetServiceEndpointResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetServiceProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetServiceProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetWirelessDeviceImportTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetWirelessDeviceImportTaskResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetWirelessDeviceRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetWirelessDeviceResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetWirelessDeviceStatisticsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetWirelessDeviceStatisticsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetWirelessGatewayCertificateRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetWirelessGatewayCertificateResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetWirelessGatewayFirmwareInformationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetWirelessGatewayFirmwareInformationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetWirelessGatewayRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetWirelessGatewayResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetWirelessGatewayStatisticsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetWirelessGatewayStatisticsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetWirelessGatewayTaskDefinitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetWirelessGatewayTaskDefinitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetWirelessGatewayTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetWirelessGatewayTaskResponse' => [ 'base' => NULL, 'refs' => [], ], 'GlobalIdentity' => [ 'base' => '<p>Global identity information.</p>', 'refs' => [ 'GsmNmrObj$GlobalIdentity' => '<p>Global identity information of the GSM object.</p>', ], ], 'Gnss' => [ 'base' => '<p>Global navigation satellite system (GNSS) object used for positioning.</p>', 'refs' => [ 'GetPositionEstimateRequest$Gnss' => '<p>Retrieves an estimated device position by resolving the global navigation satellite system (GNSS) scan data. The position is resolved using the GNSS solver powered by LoRa Cloud.</p>', ], ], 'GnssNav' => [ 'base' => NULL, 'refs' => [ 'Gnss$Payload' => '<p>Payload that contains the GNSS scan result, or NAV message, in hexadecimal notation.</p>', ], ], 'GsmList' => [ 'base' => NULL, 'refs' => [ 'CellTowers$Gsm' => '<p>GSM object information.</p>', ], ], 'GsmLocalId' => [ 'base' => '<p>GSM local ID information, which corresponds to the local identification parameters of a GSM cell.</p>', 'refs' => [ 'GsmObj$GsmLocalId' => '<p>GSM local identification (local ID) information.</p>', ], ], 'GsmNmrList' => [ 'base' => NULL, 'refs' => [ 'GsmObj$GsmNmr' => '<p>GSM object for network measurement reports.</p>', ], ], 'GsmNmrObj' => [ 'base' => '<p>GSM object for network measurement reports.</p>', 'refs' => [ 'GsmNmrList$member' => NULL, ], ], 'GsmObj' => [ 'base' => '<p>GSM object.</p>', 'refs' => [ 'GsmList$member' => NULL, ], ], 'GsmTimingAdvance' => [ 'base' => NULL, 'refs' => [ 'GsmObj$GsmTimingAdvance' => '<p>Timing advance value, which corresponds to the length of time a signal takes to reach the base station from a mobile phone.</p>', ], ], 'HorizontalAccuracy' => [ 'base' => NULL, 'refs' => [ 'Accuracy$HorizontalAccuracy' => '<p>The horizontal accuracy of the estimated position, which is the difference between the estimated location and the actual device location.</p>', ], ], 'HrAllowed' => [ 'base' => NULL, 'refs' => [ 'LoRaWANGetServiceProfileInfo$HrAllowed' => '<p>The HRAllowed value that describes whether handover roaming is allowed.</p>', ], ], 'IPAddress' => [ 'base' => NULL, 'refs' => [ 'Ip$IpAddress' => '<p>IP address information.</p>', ], ], 'ISODateTimeString' => [ 'base' => NULL, 'refs' => [ 'DownlinkQueueMessage$ReceivedAt' => '<p>The time at which Iot Wireless received the downlink message.</p>', 'GetPositionResponse$Timestamp' => '<p>The timestamp at which the device\'s position was determined.</p>', 'GetWirelessDeviceStatisticsResponse$LastUplinkReceivedAt' => '<p>The date and time when the most recent uplink was received.</p> <note> <p>This value is only valid for 3 months.</p> </note>', 'GetWirelessGatewayStatisticsResponse$LastUplinkReceivedAt' => '<p>The date and time when the most recent uplink was received.</p> <note> <p>This value is only valid for 3 months.</p> </note>', 'GetWirelessGatewayTaskResponse$LastUplinkReceivedAt' => '<p>The date and time when the most recent uplink was received.</p> <note> <p>This value is only valid for 3 months.</p> </note>', 'GetWirelessGatewayTaskResponse$TaskCreatedAt' => '<p>The date and time when the task was created.</p>', 'LoRaWANDeviceMetadata$Timestamp' => '<p>The date and time of the metadata.</p>', 'WirelessDeviceStatistics$LastUplinkReceivedAt' => '<p>The date and time when the most recent uplink was received.</p> <note> <p>Theis value is only valid for 3 months.</p> </note>', 'WirelessGatewayStatistics$LastUplinkReceivedAt' => '<p>The date and time when the most recent uplink was received.</p> <note> <p>This value is only valid for 3 months.</p> </note>', ], ], 'Id' => [ 'base' => NULL, 'refs' => [ 'LoRaWANPublicGatewayMetadata$Id' => '<p>The ID of the gateways that are operated by the network provider.</p>', ], ], 'Identifier' => [ 'base' => NULL, 'refs' => [ 'DeregisterWirelessDeviceRequest$Identifier' => '<p>The identifier of the wireless device to deregister from AWS IoT Wireless.</p>', 'EventConfigurationItem$Identifier' => '<p>Resource identifier opted in for event messaging.</p>', 'GetResourceEventConfigurationRequest$Identifier' => '<p>Resource identifier to opt in for event messaging.</p>', 'GetWirelessDeviceRequest$Identifier' => '<p>The identifier of the wireless device to get.</p>', 'GetWirelessGatewayRequest$Identifier' => '<p>The identifier of the wireless gateway to get.</p>', 'UpdateResourceEventConfigurationRequest$Identifier' => '<p>Resource identifier to opt in for event messaging.</p>', ], ], 'IdentifierType' => [ 'base' => NULL, 'refs' => [ 'EventConfigurationItem$IdentifierType' => '<p>Identifier type of the particular resource identifier for event configuration.</p>', 'GetResourceEventConfigurationRequest$IdentifierType' => '<p>Identifier type of the particular resource identifier for event configuration.</p>', 'UpdateResourceEventConfigurationRequest$IdentifierType' => '<p>Identifier type of the particular resource identifier for event configuration.</p>', ], ], 'ImportTaskArn' => [ 'base' => NULL, 'refs' => [ 'GetWirelessDeviceImportTaskResponse$Arn' => '<p>The ARN (Amazon Resource Name) of the import task.</p>', 'StartSingleWirelessDeviceImportTaskResponse$Arn' => '<p>The ARN (Amazon Resource Name) of the import task.</p>', 'StartWirelessDeviceImportTaskResponse$Arn' => '<p>The ARN (Amazon Resource Name) of the import task.</p>', 'WirelessDeviceImportTask$Arn' => '<p>The ARN (Amazon Resource Name) of the wireless device import task.</p>', ], ], 'ImportTaskId' => [ 'base' => NULL, 'refs' => [ 'DeleteWirelessDeviceImportTaskRequest$Id' => '<p>The unique identifier of the import task to be deleted.</p>', 'GetWirelessDeviceImportTaskRequest$Id' => '<p>The identifier of the import task for which information is requested.</p>', 'GetWirelessDeviceImportTaskResponse$Id' => '<p>The identifier of the import task for which information is retrieved.</p>', 'ListDevicesForWirelessDeviceImportTaskRequest$Id' => '<p>The identifier of the import task for which wireless devices are listed.</p>', 'StartSingleWirelessDeviceImportTaskResponse$Id' => '<p>The import task ID.</p>', 'StartWirelessDeviceImportTaskResponse$Id' => '<p>The import task ID.</p>', 'UpdateWirelessDeviceImportTaskRequest$Id' => '<p>The identifier of the import task to be updated.</p>', 'WirelessDeviceImportTask$Id' => '<p>The ID of the wireless device import task.</p>', ], ], 'ImportTaskStatus' => [ 'base' => NULL, 'refs' => [ 'GetWirelessDeviceImportTaskResponse$Status' => '<p>The import task status.</p>', 'WirelessDeviceImportTask$Status' => '<p>The status information of the wireless device import task.</p>', ], ], 'ImportedSidewalkDevice' => [ 'base' => '<p>Information about a Sidewalk device that has been added to an import task.</p>', 'refs' => [ 'ImportedWirelessDevice$Sidewalk' => '<p>The Sidewalk-related information about a device that has been added to an import task.</p>', ], ], 'ImportedWirelessDevice' => [ 'base' => '<p>Information about a wireless device that has been added to an import task.</p>', 'refs' => [ 'ImportedWirelessDeviceList$member' => NULL, ], ], 'ImportedWirelessDeviceCount' => [ 'base' => NULL, 'refs' => [ 'GetWirelessDeviceImportTaskResponse$InitializedImportedDeviceCount' => '<p>The number of devices in the import task that are waiting for the control log to start processing.</p>', 'GetWirelessDeviceImportTaskResponse$PendingImportedDeviceCount' => '<p>The number of devices in the import task that are waiting in the import task queue to be onboarded.</p>', 'GetWirelessDeviceImportTaskResponse$OnboardedImportedDeviceCount' => '<p>The number of devices in the import task that have been onboarded to the import task.</p>', 'GetWirelessDeviceImportTaskResponse$FailedImportedDeviceCount' => '<p>The number of devices in the import task that failed to onboard to the import task.</p>', 'WirelessDeviceImportTask$InitializedImportedDeviceCount' => '<p>The summary information of count of wireless devices that are waiting for the control log to be added to an import task.</p>', 'WirelessDeviceImportTask$PendingImportedDeviceCount' => '<p>The summary information of count of wireless devices in an import task that are waiting in the queue to be onboarded.</p>', 'WirelessDeviceImportTask$OnboardedImportedDeviceCount' => '<p>The summary information of count of wireless devices in an import task that have been onboarded to the import task.</p>', 'WirelessDeviceImportTask$FailedImportedDeviceCount' => '<p>The summary information of count of wireless devices in an import task that failed to onboarded to the import task.</p>', ], ], 'ImportedWirelessDeviceList' => [ 'base' => NULL, 'refs' => [ 'ListDevicesForWirelessDeviceImportTaskResponse$ImportedWirelessDeviceList' => '<p>List of wireless devices in an import task and their onboarding status.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'LoRaWANDeviceMetadata$FPort' => '<p>The FPort value.</p>', 'LoRaWANDeviceMetadata$DataRate' => '<p>The DataRate value.</p>', 'LoRaWANDeviceMetadata$Frequency' => '<p>The device\'s channel frequency in Hz.</p>', 'SidewalkDeviceMetadata$Rssi' => '<p>The RSSI value.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>An unexpected error occurred while processing a request.</p>', 'refs' => [], ], 'IotCertificateId' => [ 'base' => NULL, 'refs' => [ 'AssociateWirelessGatewayWithCertificateRequest$IotCertificateId' => '<p>The ID of the certificate to associate with the wireless gateway.</p>', 'AssociateWirelessGatewayWithCertificateResponse$IotCertificateId' => '<p>The ID of the certificate associated with the wireless gateway.</p>', 'GetWirelessGatewayCertificateResponse$IotCertificateId' => '<p>The ID of the certificate associated with the wireless gateway.</p>', 'GetWirelessGatewayCertificateResponse$LoRaWANNetworkServerCertificateId' => '<p>The ID of the certificate that is associated with the wireless gateway and used for the LoRaWANNetworkServer endpoint.</p>', ], ], 'Ip' => [ 'base' => '<p>IP address used for resolving device location.</p>', 'refs' => [ 'GetPositionEstimateRequest$Ip' => '<p>Retrieves an estimated device position by resolving the IP address information from the device. The position is resolved using MaxMind\'s IP-based solver.</p>', ], ], 'JoinEui' => [ 'base' => NULL, 'refs' => [ 'JoinEuiRange$member' => NULL, 'OtaaV1_0_x$JoinEui' => '<p>The JoinEUI value. You specify this value instead of the AppEUI when using LoRaWAN version v1.0.4.</p>', 'OtaaV1_1$JoinEui' => '<p>The JoinEUI value.</p>', ], ], 'JoinEuiFilters' => [ 'base' => '<p>A list of JoinEuiRange used by LoRa gateways to filter LoRa frames.</p>', 'refs' => [ 'LoRaWANGateway$JoinEuiFilters' => NULL, 'UpdateWirelessGatewayRequest$JoinEuiFilters' => NULL, ], ], 'JoinEuiRange' => [ 'base' => '<p>A pair of join EUI describing a range [BegEui, EndEui], both ends are inclusive.</p>', 'refs' => [ 'JoinEuiFilters$member' => NULL, ], ], 'JoinEventConfiguration' => [ 'base' => '<p>Join event configuration object for enabling or disabling topic.</p>', 'refs' => [ 'EventNotificationItemConfigurations$Join' => '<p>Join event configuration for an event configuration item.</p>', 'GetResourceEventConfigurationResponse$Join' => '<p>Event configuration for the join event.</p>', 'UpdateResourceEventConfigurationRequest$Join' => '<p>Event configuration for the join event.</p>', ], ], 'JoinResourceTypeEventConfiguration' => [ 'base' => '<p>Join resource type event configuration object for enabling or disabling topic.</p>', 'refs' => [ 'GetEventConfigurationByResourceTypesResponse$Join' => '<p>Resource type event configuration for the join event.</p>', 'UpdateEventConfigurationByResourceTypesRequest$Join' => '<p>Join resource type event configuration object for enabling and disabling wireless device topic.</p>', ], ], 'LAC' => [ 'base' => NULL, 'refs' => [ 'GlobalIdentity$Lac' => '<p>Location area code of the global identity.</p>', 'GsmObj$Lac' => '<p>Location area code.</p>', 'TdscdmaObj$Lac' => '<p>Location Area Code.</p>', 'WcdmaObj$Lac' => '<p>Location Area Code.</p>', ], ], 'LastUpdateTime' => [ 'base' => NULL, 'refs' => [ 'ImportedSidewalkDevice$LastUpdateTime' => '<p>The time at which the status information was last updated.</p>', ], ], 'ListDestinationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDestinationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDeviceProfilesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDeviceProfilesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDevicesForWirelessDeviceImportTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDevicesForWirelessDeviceImportTaskResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListEventConfigurationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListEventConfigurationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFuotaTasksRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFuotaTasksResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListMulticastGroupsByFuotaTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListMulticastGroupsByFuotaTaskResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListMulticastGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListMulticastGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListNetworkAnalyzerConfigurationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListNetworkAnalyzerConfigurationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPartnerAccountsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPartnerAccountsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPositionConfigurationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPositionConfigurationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListQueuedMessagesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListQueuedMessagesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListServiceProfilesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListServiceProfilesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListWirelessDeviceImportTasksRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListWirelessDeviceImportTasksResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListWirelessDevicesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListWirelessDevicesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListWirelessGatewayTaskDefinitionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListWirelessGatewayTaskDefinitionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListWirelessGatewaysRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListWirelessGatewaysResponse' => [ 'base' => NULL, 'refs' => [], ], 'LoRaWANConnectionStatusEventNotificationConfigurations' => [ 'base' => '<p>Object for LoRaWAN connection status resource type event configuration.</p>', 'refs' => [ 'ConnectionStatusEventConfiguration$LoRaWAN' => '<p>Connection status event configuration object for enabling or disabling LoRaWAN related event topics.</p>', ], ], 'LoRaWANConnectionStatusResourceTypeEventConfiguration' => [ 'base' => '<p>Object for LoRaWAN connection status resource type event configuration.</p>', 'refs' => [ 'ConnectionStatusResourceTypeEventConfiguration$LoRaWAN' => '<p>Connection status resource type event configuration object for enabling or disabling LoRaWAN related event topics.</p>', ], ], 'LoRaWANDevice' => [ 'base' => '<p>LoRaWAN object for create functions.</p>', 'refs' => [ 'CreateWirelessDeviceRequest$LoRaWAN' => '<p>The device configuration information to use to create the wireless device.</p>', 'GetWirelessDeviceResponse$LoRaWAN' => '<p>Information about the wireless device.</p>', ], ], 'LoRaWANDeviceMetadata' => [ 'base' => '<p>LoRaWAN device metatdata.</p>', 'refs' => [ 'GetWirelessDeviceStatisticsResponse$LoRaWAN' => '<p>Information about the wireless device\'s operations.</p>', ], ], 'LoRaWANDeviceProfile' => [ 'base' => '<p>LoRaWANDeviceProfile object.</p>', 'refs' => [ 'CreateDeviceProfileRequest$LoRaWAN' => '<p>The device profile information to use to create the device profile.</p>', 'GetDeviceProfileResponse$LoRaWAN' => '<p>Information about the device profile.</p>', ], ], 'LoRaWANFuotaTask' => [ 'base' => '<p>The LoRaWAN information used with a FUOTA task.</p>', 'refs' => [ 'CreateFuotaTaskRequest$LoRaWAN' => NULL, 'UpdateFuotaTaskRequest$LoRaWAN' => NULL, ], ], 'LoRaWANFuotaTaskGetInfo' => [ 'base' => '<p>The LoRaWAN information returned from getting a FUOTA task.</p>', 'refs' => [ 'GetFuotaTaskResponse$LoRaWAN' => NULL, ], ], 'LoRaWANGateway' => [ 'base' => '<p>LoRaWANGateway object.</p>', 'refs' => [ 'CreateWirelessGatewayRequest$LoRaWAN' => '<p>The gateway configuration information to use to create the wireless gateway.</p>', 'GetWirelessGatewayResponse$LoRaWAN' => '<p>Information about the wireless gateway.</p>', 'WirelessGatewayStatistics$LoRaWAN' => '<p>LoRaWAN gateway info.</p>', ], ], 'LoRaWANGatewayCurrentVersion' => [ 'base' => '<p>LoRaWANGatewayCurrentVersion object.</p>', 'refs' => [ 'GetWirelessGatewayFirmwareInformationResponse$LoRaWAN' => '<p>Information about the wireless gateway\'s firmware.</p>', ], ], 'LoRaWANGatewayMetadata' => [ 'base' => '<p>LoRaWAN gateway metatdata.</p>', 'refs' => [ 'LoRaWANGatewayMetadataList$member' => NULL, ], ], 'LoRaWANGatewayMetadataList' => [ 'base' => NULL, 'refs' => [ 'LoRaWANDeviceMetadata$Gateways' => '<p>Information about the gateways accessed by the device.</p>', ], ], 'LoRaWANGatewayVersion' => [ 'base' => '<p>LoRaWANGatewayVersion object.</p>', 'refs' => [ 'LoRaWANGatewayCurrentVersion$CurrentVersion' => '<p>The version of the gateways that should receive the update.</p>', 'LoRaWANUpdateGatewayTaskCreate$CurrentVersion' => '<p>The version of the gateways that should receive the update.</p>', 'LoRaWANUpdateGatewayTaskCreate$UpdateVersion' => '<p>The firmware version to update the gateway to.</p>', 'LoRaWANUpdateGatewayTaskEntry$CurrentVersion' => '<p>The version of the gateways that should receive the update.</p>', 'LoRaWANUpdateGatewayTaskEntry$UpdateVersion' => '<p>The firmware version to update the gateway to.</p>', ], ], 'LoRaWANGetServiceProfileInfo' => [ 'base' => '<p>LoRaWANGetServiceProfileInfo object.</p>', 'refs' => [ 'GetServiceProfileResponse$LoRaWAN' => '<p>Information about the service profile.</p>', ], ], 'LoRaWANJoinEventNotificationConfigurations' => [ 'base' => '<p>Object for LoRaWAN join resource type event configuration.</p>', 'refs' => [ 'JoinEventConfiguration$LoRaWAN' => '<p>Join event configuration object for enabling or disabling LoRaWAN related event topics.</p>', ], ], 'LoRaWANJoinResourceTypeEventConfiguration' => [ 'base' => '<p>Object for LoRaWAN join resource type event configuration.</p>', 'refs' => [ 'JoinResourceTypeEventConfiguration$LoRaWAN' => '<p>Join resource type event configuration object for enabling or disabling LoRaWAN related event topics.</p>', ], ], 'LoRaWANListDevice' => [ 'base' => '<p>LoRaWAN object for list functions.</p>', 'refs' => [ 'WirelessDeviceStatistics$LoRaWAN' => '<p>LoRaWAN device info.</p>', ], ], 'LoRaWANMulticast' => [ 'base' => '<p>The LoRaWAN information that is to be used with the multicast group.</p>', 'refs' => [ 'CreateMulticastGroupRequest$LoRaWAN' => NULL, 'UpdateMulticastGroupRequest$LoRaWAN' => NULL, ], ], 'LoRaWANMulticastGet' => [ 'base' => '<p>The LoRaWAN information that is to be returned from getting multicast group information.</p>', 'refs' => [ 'GetMulticastGroupResponse$LoRaWAN' => NULL, ], ], 'LoRaWANMulticastMetadata' => [ 'base' => '<p>The metadata information of the LoRaWAN multicast group.</p>', 'refs' => [ 'MulticastWirelessMetadata$LoRaWAN' => NULL, ], ], 'LoRaWANMulticastSession' => [ 'base' => '<p>The LoRaWAN information used with the multicast session.</p>', 'refs' => [ 'GetMulticastGroupSessionResponse$LoRaWAN' => NULL, 'StartMulticastGroupSessionRequest$LoRaWAN' => NULL, ], ], 'LoRaWANPublicGatewayMetadata' => [ 'base' => '<p>LoRaWAN public gateway metadata.</p>', 'refs' => [ 'LoRaWANPublicGatewayMetadataList$member' => NULL, ], ], 'LoRaWANPublicGatewayMetadataList' => [ 'base' => NULL, 'refs' => [ 'LoRaWANDeviceMetadata$PublicGateways' => '<p>Information about the LoRaWAN public network accessed by the device.</p>', ], ], 'LoRaWANSendDataToDevice' => [ 'base' => '<p>LoRaWAN router info.</p>', 'refs' => [ 'DownlinkQueueMessage$LoRaWAN' => NULL, 'WirelessMetadata$LoRaWAN' => '<p>LoRaWAN device info.</p>', ], ], 'LoRaWANServiceProfile' => [ 'base' => '<p>LoRaWANServiceProfile object.</p>', 'refs' => [ 'CreateServiceProfileRequest$LoRaWAN' => '<p>The service profile information to use to create the service profile.</p>', ], ], 'LoRaWANStartFuotaTask' => [ 'base' => '<p>The LoRaWAN information used to start a FUOTA task.</p>', 'refs' => [ 'StartFuotaTaskRequest$LoRaWAN' => NULL, ], ], 'LoRaWANUpdateDevice' => [ 'base' => '<p>LoRaWAN object for update functions.</p>', 'refs' => [ 'UpdateWirelessDeviceRequest$LoRaWAN' => '<p>The updated wireless device\'s configuration.</p>', ], ], 'LoRaWANUpdateGatewayTaskCreate' => [ 'base' => '<p>LoRaWANUpdateGatewayTaskCreate object.</p>', 'refs' => [ 'UpdateWirelessGatewayTaskCreate$LoRaWAN' => '<p>The properties that relate to the LoRaWAN wireless gateway.</p>', ], ], 'LoRaWANUpdateGatewayTaskEntry' => [ 'base' => '<p>LoRaWANUpdateGatewayTaskEntry object.</p>', 'refs' => [ 'UpdateWirelessGatewayTaskEntry$LoRaWAN' => '<p>The properties that relate to the LoRaWAN wireless gateway.</p>', ], ], 'LogLevel' => [ 'base' => '<p>The log level for a log message. The log levels can be disabled, or set to <code>ERROR</code> to display less verbose logs containing only error information, or to <code>INFO</code> for more detailed logs.</p>', 'refs' => [ 'GetLogLevelsByResourceTypesResponse$DefaultLogLevel' => NULL, 'GetResourceLogLevelResponse$LogLevel' => NULL, 'PutResourceLogLevelRequest$LogLevel' => NULL, 'TraceContent$LogLevel' => NULL, 'UpdateLogLevelsByResourceTypesRequest$DefaultLogLevel' => NULL, 'WirelessDeviceEventLogOption$LogLevel' => NULL, 'WirelessDeviceLogOption$LogLevel' => NULL, 'WirelessGatewayEventLogOption$LogLevel' => NULL, 'WirelessGatewayLogOption$LogLevel' => NULL, ], ], 'LteList' => [ 'base' => NULL, 'refs' => [ 'CellTowers$Lte' => '<p>LTE object information.</p>', ], ], 'LteLocalId' => [ 'base' => '<p>LTE local identification (local ID) information.</p>', 'refs' => [ 'LteObj$LteLocalId' => '<p>LTE local identification (local ID) information.</p>', ], ], 'LteNmrList' => [ 'base' => NULL, 'refs' => [ 'LteObj$LteNmr' => '<p>LTE object for network measurement reports.</p>', ], ], 'LteNmrObj' => [ 'base' => '<p>LTE object for network measurement reports.</p>', 'refs' => [ 'LteNmrList$member' => NULL, ], ], 'LteObj' => [ 'base' => '<p>LTE object.</p>', 'refs' => [ 'LteList$member' => NULL, ], ], 'LteTimingAdvance' => [ 'base' => NULL, 'refs' => [ 'LteObj$LteTimingAdvance' => '<p>LTE timing advance.</p>', ], ], 'MCC' => [ 'base' => NULL, 'refs' => [ 'GsmObj$Mcc' => '<p>Mobile Country Code.</p>', 'LteObj$Mcc' => '<p>Mobile Country Code.</p>', 'TdscdmaObj$Mcc' => '<p>Mobile Country Code.</p>', 'WcdmaObj$Mcc' => '<p>Mobile Country Code.</p>', ], ], 'MNC' => [ 'base' => NULL, 'refs' => [ 'GsmObj$Mnc' => '<p>Mobile Network Code.</p>', 'LteObj$Mnc' => '<p>Mobile Network Code.</p>', 'TdscdmaObj$Mnc' => '<p>Mobile Network Code.</p>', 'WcdmaObj$Mnc' => '<p>Mobile Network Code.</p>', ], ], 'MacAddress' => [ 'base' => NULL, 'refs' => [ 'WiFiAccessPoint$MacAddress' => '<p>Wi-Fi MAC Address.</p>', ], ], 'MacVersion' => [ 'base' => NULL, 'refs' => [ 'LoRaWANDeviceProfile$MacVersion' => '<p>The MAC version (such as OTAA 1.1 or OTAA 1.0.3) to use with this device profile.</p>', ], ], 'Max' => [ 'base' => NULL, 'refs' => [ 'MetricQueryValue$Max' => '<p>The maximum of the values of all the data points collected during the aggregation period.</p>', ], ], 'MaxAllowedSignature' => [ 'base' => NULL, 'refs' => [ 'DakCertificateMetadata$MaxAllowedSignature' => '<p>The maximum number of signatures that the DAK can sign. A value of <code>-1</code> indicates that there\'s no device limit.</p>', ], ], 'MaxDutyCycle' => [ 'base' => NULL, 'refs' => [ 'LoRaWANDeviceProfile$MaxDutyCycle' => '<p>The MaxDutyCycle value. It ranges from 0 to 15.</p>', ], ], 'MaxEirp' => [ 'base' => NULL, 'refs' => [ 'LoRaWANDeviceProfile$MaxEirp' => '<p>The MaxEIRP value.</p>', ], ], 'MaxResults' => [ 'base' => '<p>The maximum number of results to return in this operation.</p>', 'refs' => [ 'ListDestinationsRequest$MaxResults' => '<p>The maximum number of results to return in this operation.</p>', 'ListDeviceProfilesRequest$MaxResults' => '<p>The maximum number of results to return in this operation.</p>', 'ListDevicesForWirelessDeviceImportTaskRequest$MaxResults' => NULL, 'ListEventConfigurationsRequest$MaxResults' => NULL, 'ListFuotaTasksRequest$MaxResults' => NULL, 'ListMulticastGroupsByFuotaTaskRequest$MaxResults' => NULL, 'ListMulticastGroupsRequest$MaxResults' => NULL, 'ListNetworkAnalyzerConfigurationsRequest$MaxResults' => NULL, 'ListPartnerAccountsRequest$MaxResults' => '<p>The maximum number of results to return in this operation.</p>', 'ListPositionConfigurationsRequest$MaxResults' => NULL, 'ListQueuedMessagesRequest$MaxResults' => '<p>The maximum number of results to return in this operation.</p>', 'ListServiceProfilesRequest$MaxResults' => '<p>The maximum number of results to return in this operation.</p>', 'ListWirelessDeviceImportTasksRequest$MaxResults' => NULL, 'ListWirelessDevicesRequest$MaxResults' => '<p>The maximum number of results to return in this operation.</p>', 'ListWirelessGatewayTaskDefinitionsRequest$MaxResults' => '<p>The maximum number of results to return in this operation.</p>', 'ListWirelessGatewaysRequest$MaxResults' => '<p>The maximum number of results to return in this operation.</p>', ], ], 'McGroupId' => [ 'base' => '<p>Id of the multicast group.</p>', 'refs' => [ 'WirelessDeviceStatistics$McGroupId' => NULL, ], ], 'Message' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => NULL, 'ConflictException$Message' => NULL, 'InternalServerException$Message' => NULL, 'ResourceNotFoundException$Message' => NULL, 'ThrottlingException$Message' => NULL, 'TooManyTagsException$Message' => NULL, 'ValidationException$Message' => NULL, ], ], 'MessageDeliveryStatusEventConfiguration' => [ 'base' => '<p>Message delivery status event configuration object for enabling and disabling relevant topics.</p>', 'refs' => [ 'EventNotificationItemConfigurations$MessageDeliveryStatus' => '<p>Message delivery status event configuration for an event configuration item.</p>', 'GetResourceEventConfigurationResponse$MessageDeliveryStatus' => '<p>Event configuration for the message delivery status event.</p>', 'UpdateResourceEventConfigurationRequest$MessageDeliveryStatus' => '<p>Event configuration for the message delivery status event.</p>', ], ], 'MessageDeliveryStatusResourceTypeEventConfiguration' => [ 'base' => '<p>Message delivery status resource type event configuration object for enabling or disabling relevant topic.</p>', 'refs' => [ 'GetEventConfigurationByResourceTypesResponse$MessageDeliveryStatus' => '<p>Resource type event configuration object for the message delivery status event.</p>', 'UpdateEventConfigurationByResourceTypesRequest$MessageDeliveryStatus' => '<p>Message delivery status resource type event configuration object for enabling and disabling wireless device topic.</p>', ], ], 'MessageId' => [ 'base' => NULL, 'refs' => [ 'DeleteQueuedMessagesRequest$MessageId' => '<p>If message ID is <code>"*"</code>, it cleares the entire downlink queue for a given device, specified by the wireless device ID. Otherwise, the downlink message with the specified message ID will be deleted.</p>', 'DownlinkQueueMessage$MessageId' => '<p> The message ID assigned by IoT Wireless to each downlink message, which helps identify the message.</p>', 'SendDataToWirelessDeviceResponse$MessageId' => '<p>The ID of the message sent to the wireless device.</p>', ], ], 'MessageType' => [ 'base' => '<p>Sidewalk device message type. Default value is <code>CUSTOM_COMMAND_ID_NOTIFY</code>.</p>', 'refs' => [ 'SidewalkSendDataToDevice$MessageType' => NULL, ], ], 'MetricName' => [ 'base' => NULL, 'refs' => [ 'SummaryMetricQuery$MetricName' => '<p>The name of the metric.</p>', 'SummaryMetricQueryResult$MetricName' => '<p>The name of the summary metric query result.</p>', ], ], 'MetricQueryEndTimestamp' => [ 'base' => NULL, 'refs' => [ 'SummaryMetricQuery$EndTimestamp' => '<p>The end timestamp for the summary metric query.</p>', 'SummaryMetricQueryResult$EndTimestamp' => '<p>The end timestamp for the summary metric query.</p>', ], ], 'MetricQueryError' => [ 'base' => NULL, 'refs' => [ 'SummaryMetricQueryResult$Error' => '<p>The error message for the summary metric query result.</p>', ], ], 'MetricQueryId' => [ 'base' => NULL, 'refs' => [ 'SummaryMetricQuery$QueryId' => '<p>The id of the summary metric query.</p>', 'SummaryMetricQueryResult$QueryId' => '<p>The ID of the summary metric results query operation.</p>', ], ], 'MetricQueryStartTimestamp' => [ 'base' => NULL, 'refs' => [ 'SummaryMetricQuery$StartTimestamp' => '<p>The start timestamp for the summary metric query.</p>', 'SummaryMetricQueryResult$StartTimestamp' => '<p>The start timestamp for the summary metric query.</p>', ], ], 'MetricQueryStatus' => [ 'base' => NULL, 'refs' => [ 'SummaryMetricQueryResult$QueryStatus' => '<p>The status of the summary metric query result.</p>', ], ], 'MetricQueryTimestamp' => [ 'base' => NULL, 'refs' => [ 'MetricQueryTimestamps$member' => NULL, ], ], 'MetricQueryTimestamps' => [ 'base' => NULL, 'refs' => [ 'SummaryMetricQueryResult$Timestamps' => '<p>The timestamp of each aggregation result.</p>', ], ], 'MetricQueryValue' => [ 'base' => '<p>The aggregated values of the metric.</p>', 'refs' => [ 'MetricQueryValues$member' => NULL, ], ], 'MetricQueryValues' => [ 'base' => NULL, 'refs' => [ 'SummaryMetricQueryResult$Values' => '<p>The list of aggregated summary metric query results.</p>', ], ], 'MetricUnit' => [ 'base' => NULL, 'refs' => [ 'SummaryMetricQueryResult$Unit' => '<p>The units of measurement to be used for interpreting the aggregation result.</p>', ], ], 'Min' => [ 'base' => NULL, 'refs' => [ 'MetricQueryValue$Min' => '<p>The minimum of the values of all data points collected during the aggregation period.</p>', ], ], 'MinGwDiversity' => [ 'base' => NULL, 'refs' => [ 'LoRaWANGetServiceProfileInfo$MinGwDiversity' => '<p>The MinGwDiversity value.</p>', ], ], 'Model' => [ 'base' => NULL, 'refs' => [ 'LoRaWANGatewayVersion$Model' => '<p>The model number of the wireless gateway.</p>', ], ], 'MulticastDeviceStatus' => [ 'base' => NULL, 'refs' => [ 'WirelessDeviceStatistics$MulticastDeviceStatus' => '<p>The status of the wireless device in the multicast group.</p>', ], ], 'MulticastFrameInfo' => [ 'base' => '<p> <code>FrameInfo</code> of your multicast group resources for the trace content. Use FrameInfo to debug the multicast communication between your multicast groups and the network server.</p>', 'refs' => [ 'TraceContent$MulticastFrameInfo' => NULL, ], ], 'MulticastGroup' => [ 'base' => '<p>A multicast group.</p>', 'refs' => [ 'MulticastGroupList$member' => NULL, ], ], 'MulticastGroupArn' => [ 'base' => '<p>The arn of the multicast group.</p>', 'refs' => [ 'CreateMulticastGroupResponse$Arn' => NULL, 'GetMulticastGroupResponse$Arn' => NULL, 'MulticastGroup$Arn' => NULL, ], ], 'MulticastGroupByFuotaTask' => [ 'base' => '<p>A multicast group that is associated with a FUOTA task.</p>', 'refs' => [ 'MulticastGroupListByFuotaTask$member' => NULL, ], ], 'MulticastGroupId' => [ 'base' => '<p>The ID of the multicast group.</p>', 'refs' => [ 'AssociateMulticastGroupWithFuotaTaskRequest$MulticastGroupId' => NULL, 'AssociateWirelessDeviceWithMulticastGroupRequest$Id' => NULL, 'CancelMulticastGroupSessionRequest$Id' => NULL, 'CreateMulticastGroupResponse$Id' => NULL, 'DeleteMulticastGroupRequest$Id' => NULL, 'DisassociateMulticastGroupFromFuotaTaskRequest$MulticastGroupId' => NULL, 'DisassociateWirelessDeviceFromMulticastGroupRequest$Id' => NULL, 'GetMulticastGroupRequest$Id' => NULL, 'GetMulticastGroupResponse$Id' => NULL, 'GetMulticastGroupSessionRequest$Id' => NULL, 'ListWirelessDevicesRequest$MulticastGroupId' => NULL, 'MulticastGroup$Id' => NULL, 'MulticastGroupByFuotaTask$Id' => NULL, 'NetworkAnalyzerMulticastGroupList$member' => NULL, 'SendDataToMulticastGroupRequest$Id' => NULL, 'StartBulkAssociateWirelessDeviceWithMulticastGroupRequest$Id' => NULL, 'StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest$Id' => NULL, 'StartMulticastGroupSessionRequest$Id' => NULL, 'UpdateMulticastGroupRequest$Id' => NULL, ], ], 'MulticastGroupList' => [ 'base' => '<p>List of multicast groups.</p>', 'refs' => [ 'ListMulticastGroupsResponse$MulticastGroupList' => NULL, ], ], 'MulticastGroupListByFuotaTask' => [ 'base' => '<p>List of multicast groups associated with a FUOTA task.</p>', 'refs' => [ 'ListMulticastGroupsByFuotaTaskResponse$MulticastGroupList' => NULL, ], ], 'MulticastGroupMessageId' => [ 'base' => '<p>ID of a multicast group message.</p>', 'refs' => [ 'SendDataToMulticastGroupResponse$MessageId' => NULL, ], ], 'MulticastGroupName' => [ 'base' => '<p>The name of the multicast group.</p>', 'refs' => [ 'CreateMulticastGroupRequest$Name' => NULL, 'GetMulticastGroupResponse$Name' => NULL, 'MulticastGroup$Name' => NULL, 'UpdateMulticastGroupRequest$Name' => NULL, ], ], 'MulticastGroupStatus' => [ 'base' => '<p>The status of the multicast group.</p>', 'refs' => [ 'GetMulticastGroupResponse$Status' => NULL, ], ], 'MulticastWirelessMetadata' => [ 'base' => '<p>Wireless metadata that is to be sent to multicast group.</p>', 'refs' => [ 'SendDataToMulticastGroupRequest$WirelessMetadata' => NULL, ], ], 'NRCapable' => [ 'base' => NULL, 'refs' => [ 'LteObj$NrCapable' => '<p>Parameter that determines whether the LTE object is capable of supporting NR (new radio).</p>', ], ], 'NetId' => [ 'base' => '<p>LoRaWAN network ID.</p>', 'refs' => [ 'NetIdFilters$member' => NULL, ], ], 'NetIdFilters' => [ 'base' => '<p>A list of NetId values that are used by LoRa gateways to filter the uplink frames.</p>', 'refs' => [ 'LoRaWANGateway$NetIdFilters' => NULL, 'UpdateWirelessGatewayRequest$NetIdFilters' => NULL, ], ], 'NetworkAnalyzerConfigurationArn' => [ 'base' => NULL, 'refs' => [ 'CreateNetworkAnalyzerConfigurationResponse$Arn' => '<p>The Amazon Resource Name of the new resource.</p>', 'GetNetworkAnalyzerConfigurationResponse$Arn' => '<p>The Amazon Resource Name of the new resource.</p>', 'NetworkAnalyzerConfigurations$Arn' => '<p>The Amazon Resource Name of the new resource.</p>', ], ], 'NetworkAnalyzerConfigurationList' => [ 'base' => NULL, 'refs' => [ 'ListNetworkAnalyzerConfigurationsResponse$NetworkAnalyzerConfigurationList' => '<p>The list of network analyzer configurations.</p>', ], ], 'NetworkAnalyzerConfigurationName' => [ 'base' => '<p>Name of the network analyzer configuration.</p>', 'refs' => [ 'CreateNetworkAnalyzerConfigurationRequest$Name' => NULL, 'CreateNetworkAnalyzerConfigurationResponse$Name' => NULL, 'DeleteNetworkAnalyzerConfigurationRequest$ConfigurationName' => NULL, 'GetNetworkAnalyzerConfigurationRequest$ConfigurationName' => NULL, 'GetNetworkAnalyzerConfigurationResponse$Name' => NULL, 'NetworkAnalyzerConfigurations$Name' => NULL, 'UpdateNetworkAnalyzerConfigurationRequest$ConfigurationName' => NULL, ], ], 'NetworkAnalyzerConfigurations' => [ 'base' => '<p>Network analyzer configurations.</p>', 'refs' => [ 'NetworkAnalyzerConfigurationList$member' => NULL, ], ], 'NetworkAnalyzerMulticastGroupList' => [ 'base' => NULL, 'refs' => [ 'CreateNetworkAnalyzerConfigurationRequest$MulticastGroups' => '<p>Multicast Group resources to add to the network analyzer configruation. Provide the <code>MulticastGroupId</code> of the resource to add in the input array.</p>', 'GetNetworkAnalyzerConfigurationResponse$MulticastGroups' => '<p>List of multicast group resources that have been added to the network analyzer configuration.</p>', 'UpdateNetworkAnalyzerConfigurationRequest$MulticastGroupsToAdd' => '<p>Multicast group resources to add to the network analyzer configuration. Provide the <code>MulticastGroupId</code> of the resource to add in the input array.</p>', 'UpdateNetworkAnalyzerConfigurationRequest$MulticastGroupsToRemove' => '<p>Multicast group resources to remove from the network analyzer configuration. Provide the <code>MulticastGroupId</code> of the resources to remove in the input array.</p>', ], ], 'NetworkId' => [ 'base' => NULL, 'refs' => [ 'CdmaObj$NetworkId' => '<p>CDMA network ID (NID).</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListDestinationsRequest$NextToken' => '<p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>', 'ListDestinationsResponse$NextToken' => '<p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>', 'ListDeviceProfilesRequest$NextToken' => '<p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>', 'ListDeviceProfilesResponse$NextToken' => '<p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>', 'ListDevicesForWirelessDeviceImportTaskRequest$NextToken' => '<p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <code>null</code> to receive the first set of results.</p>', 'ListDevicesForWirelessDeviceImportTaskResponse$NextToken' => '<p>The token to use to get the next set of results, or <code>null</code> if there are no additional results.</p>', 'ListEventConfigurationsRequest$NextToken' => '<p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>', 'ListEventConfigurationsResponse$NextToken' => '<p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>', 'ListFuotaTasksRequest$NextToken' => '<p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>', 'ListFuotaTasksResponse$NextToken' => '<p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>', 'ListMulticastGroupsByFuotaTaskRequest$NextToken' => '<p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>', 'ListMulticastGroupsByFuotaTaskResponse$NextToken' => '<p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>', 'ListMulticastGroupsRequest$NextToken' => '<p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>', 'ListMulticastGroupsResponse$NextToken' => '<p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>', 'ListNetworkAnalyzerConfigurationsRequest$NextToken' => '<p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>', 'ListNetworkAnalyzerConfigurationsResponse$NextToken' => '<p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>', 'ListPartnerAccountsRequest$NextToken' => '<p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>', 'ListPartnerAccountsResponse$NextToken' => '<p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>', 'ListPositionConfigurationsRequest$NextToken' => '<p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>', 'ListPositionConfigurationsResponse$NextToken' => '<p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>', 'ListQueuedMessagesRequest$NextToken' => '<p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>', 'ListQueuedMessagesResponse$NextToken' => '<p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>', 'ListServiceProfilesRequest$NextToken' => '<p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>', 'ListServiceProfilesResponse$NextToken' => '<p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>', 'ListWirelessDeviceImportTasksRequest$NextToken' => '<p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <code>null</code> to receive the first set of results.</p>', 'ListWirelessDeviceImportTasksResponse$NextToken' => '<p>The token to use to get the next set of results, or <code>null</code> if there are no additional results.</p>', 'ListWirelessDevicesRequest$NextToken' => '<p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>', 'ListWirelessDevicesResponse$NextToken' => '<p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>', 'ListWirelessGatewayTaskDefinitionsRequest$NextToken' => '<p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>', 'ListWirelessGatewayTaskDefinitionsResponse$NextToken' => '<p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>', 'ListWirelessGatewaysRequest$NextToken' => '<p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>', 'ListWirelessGatewaysResponse$NextToken' => '<p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>', ], ], 'NumberOfDevicesInGroup' => [ 'base' => '<p>Number of devices that are associated to the multicast group.</p>', 'refs' => [ 'LoRaWANMulticastGet$NumberOfDevicesInGroup' => NULL, ], ], 'NumberOfDevicesRequested' => [ 'base' => '<p>Number of devices that are requested to be associated with the multicast group.</p>', 'refs' => [ 'LoRaWANMulticastGet$NumberOfDevicesRequested' => NULL, ], ], 'NwkGeoLoc' => [ 'base' => NULL, 'refs' => [ 'LoRaWANGetServiceProfileInfo$NwkGeoLoc' => '<p>The NwkGeoLoc value.</p>', ], ], 'NwkKey' => [ 'base' => NULL, 'refs' => [ 'OtaaV1_1$NwkKey' => '<p>The NwkKey value.</p>', ], ], 'NwkSEncKey' => [ 'base' => NULL, 'refs' => [ 'SessionKeysAbpV1_1$NwkSEncKey' => '<p>The NwkSEncKey value.</p>', ], ], 'NwkSKey' => [ 'base' => NULL, 'refs' => [ 'SessionKeysAbpV1_0_x$NwkSKey' => '<p>The NwkSKey value.</p>', ], ], 'OnboardStatus' => [ 'base' => NULL, 'refs' => [ 'ImportedSidewalkDevice$OnboardingStatus' => '<p>The onboarding status of the Sidewalk device in the import task.</p>', 'ListDevicesForWirelessDeviceImportTaskRequest$Status' => '<p>The status of the devices in the import task.</p>', ], ], 'OnboardStatusReason' => [ 'base' => NULL, 'refs' => [ 'ImportedSidewalkDevice$OnboardingStatusReason' => '<p>The reason for the onboarding status information for the Sidewalk device.</p>', ], ], 'OtaaV1_0_x' => [ 'base' => '<p>OTAA device object for v1.0.x</p>', 'refs' => [ 'LoRaWANDevice$OtaaV1_0_x' => '<p>OTAA device object for create APIs for v1.0.x</p>', ], ], 'OtaaV1_1' => [ 'base' => '<p>OTAA device object for v1.1</p>', 'refs' => [ 'LoRaWANDevice$OtaaV1_1' => '<p>OTAA device object for v1.1 for create APIs</p>', ], ], 'P90' => [ 'base' => NULL, 'refs' => [ 'MetricQueryValue$P90' => '<p>The 90th percentile of the values of all data points collected during the aggregation period.</p>', ], ], 'PCI' => [ 'base' => NULL, 'refs' => [ 'LteLocalId$Pci' => '<p>Physical cell ID.</p>', 'LteNmrObj$Pci' => '<p>Physical cell ID.</p>', ], ], 'PSC' => [ 'base' => NULL, 'refs' => [ 'WcdmaLocalId$Psc' => '<p>Primary Scrambling Code.</p>', 'WcdmaNmrObj$Psc' => '<p>Primary Scrambling Code.</p>', ], ], 'PackageVersion' => [ 'base' => NULL, 'refs' => [ 'LoRaWANGatewayVersion$PackageVersion' => '<p>The version of the wireless gateway firmware.</p>', ], ], 'ParticipatingGateways' => [ 'base' => '<p>Specify the list of gateways to which you want to send downlink data traffic when the wireless device is running in class B or class C mode.</p>', 'refs' => [ 'LoRaWANSendDataToDevice$ParticipatingGateways' => '<p>Choose the gateways that you want to use for the downlink data traffic when the wireless device is running in class B or class C mode.</p>', ], ], 'PartnerAccountArn' => [ 'base' => NULL, 'refs' => [ 'AssociateAwsAccountWithPartnerAccountResponse$Arn' => '<p>The Amazon Resource Name of the resource.</p>', 'SidewalkAccountInfoWithFingerprint$Arn' => '<p>The Amazon Resource Name of the resource.</p>', ], ], 'PartnerAccountId' => [ 'base' => NULL, 'refs' => [ 'DisassociateAwsAccountFromPartnerAccountRequest$PartnerAccountId' => '<p>The partner account ID to disassociate from the AWS account.</p>', 'GetPartnerAccountRequest$PartnerAccountId' => '<p>The partner account ID to disassociate from the AWS account.</p>', 'UpdatePartnerAccountRequest$PartnerAccountId' => '<p>The ID of the partner account to update.</p>', ], ], 'PartnerType' => [ 'base' => NULL, 'refs' => [ 'DisassociateAwsAccountFromPartnerAccountRequest$PartnerType' => '<p>The partner type.</p>', 'GetPartnerAccountRequest$PartnerType' => '<p>The partner type.</p>', 'UpdatePartnerAccountRequest$PartnerType' => '<p>The partner type.</p>', ], ], 'PathLoss' => [ 'base' => NULL, 'refs' => [ 'TdscdmaNmrObj$PathLoss' => '<p>Path loss, or path attenuation, is the reduction in power density of an electromagnetic wave as it propagates through space.</p>', 'TdscdmaObj$PathLoss' => '<p>Path loss, or path attenuation, is the reduction in power density of an electromagnetic wave as it propagates through space.</p>', 'WcdmaNmrObj$PathLoss' => '<p>Path loss, or path attenuation, is the reduction in power density of an electromagnetic wave as it propagates through space.</p>', 'WcdmaObj$PathLoss' => '<p>Path loss, or path attenuation, is the reduction in power density of an electromagnetic wave as it propagates through space.</p>', ], ], 'PayloadData' => [ 'base' => '<p>The binary to be sent to the end device, encoded in base64.</p>', 'refs' => [ 'SendDataToMulticastGroupRequest$PayloadData' => NULL, 'SendDataToWirelessDeviceRequest$PayloadData' => NULL, ], ], 'PilotPower' => [ 'base' => NULL, 'refs' => [ 'CdmaNmrObj$PilotPower' => '<p>Transmit power level of the pilot signal, measured in dBm (decibel-milliwatts).</p>', 'CdmaObj$PilotPower' => '<p>Transmit power level of the pilot signal, measured in dBm (decibel-milliwatts).</p>', ], ], 'PingSlotDr' => [ 'base' => NULL, 'refs' => [ 'LoRaWANDeviceProfile$PingSlotDr' => '<p>The PingSlotDR value.</p>', ], ], 'PingSlotFreq' => [ 'base' => NULL, 'refs' => [ 'LoRaWANDeviceProfile$PingSlotFreq' => '<p>The PingSlotFreq value.</p>', ], ], 'PingSlotPeriod' => [ 'base' => NULL, 'refs' => [ 'LoRaWANDeviceProfile$PingSlotPeriod' => '<p>The PingSlotPeriod value.</p>', 'LoRaWANMulticastSession$PingSlotPeriod' => '<p>The PingSlotPeriod value.</p>', ], ], 'PnOffset' => [ 'base' => NULL, 'refs' => [ 'CdmaLocalId$PnOffset' => '<p>Pseudo-noise offset, which is a characteristic of the signal from a cell on a radio tower.</p>', 'CdmaNmrObj$PnOffset' => '<p>Pseudo-noise offset, which is a characteristic of the signal from a cell on a radio tower.</p>', ], ], 'PositionConfigurationFec' => [ 'base' => NULL, 'refs' => [ 'SemtechGnssConfiguration$Fec' => '<p>Whether forward error correction is enabled.</p>', 'SemtechGnssDetail$Fec' => '<p>Whether forward error correction is enabled.</p>', ], ], 'PositionConfigurationItem' => [ 'base' => '<p>The wrapper for a position configuration.</p>', 'refs' => [ 'PositionConfigurationList$member' => NULL, ], ], 'PositionConfigurationList' => [ 'base' => NULL, 'refs' => [ 'ListPositionConfigurationsResponse$PositionConfigurationList' => '<p>A list of position configurations.</p>', ], ], 'PositionConfigurationStatus' => [ 'base' => NULL, 'refs' => [ 'SemtechGnssConfiguration$Status' => '<p>The status indicating whether the solver is enabled.</p>', 'SemtechGnssDetail$Status' => '<p>The status indicating whether the solver is enabled.</p>', ], ], 'PositionCoordinate' => [ 'base' => NULL, 'refs' => [ 'GetPositionResponse$Position' => '<p>The position information of the resource.</p>', 'UpdatePositionRequest$Position' => '<p>The position information of the resource.</p>', ], ], 'PositionCoordinateValue' => [ 'base' => NULL, 'refs' => [ 'PositionCoordinate$member' => NULL, ], ], 'PositionResourceIdentifier' => [ 'base' => NULL, 'refs' => [ 'GetPositionConfigurationRequest$ResourceIdentifier' => '<p>Resource identifier used in a position configuration.</p>', 'GetPositionRequest$ResourceIdentifier' => '<p>Resource identifier used to retrieve the position information.</p>', 'GetResourcePositionRequest$ResourceIdentifier' => '<p>The identifier of the resource for which position information is retrieved. It can be the wireless device ID or the wireless gateway ID, depending on the resource type.</p>', 'PositionConfigurationItem$ResourceIdentifier' => '<p>Resource identifier for the position configuration.</p>', 'PutPositionConfigurationRequest$ResourceIdentifier' => '<p>Resource identifier used to update the position configuration.</p>', 'UpdatePositionRequest$ResourceIdentifier' => '<p>Resource identifier of the resource for which position is updated.</p>', 'UpdateResourcePositionRequest$ResourceIdentifier' => '<p>The identifier of the resource for which position information is updated. It can be the wireless device ID or the wireless gateway ID, depending on the resource type.</p>', ], ], 'PositionResourceType' => [ 'base' => NULL, 'refs' => [ 'GetPositionConfigurationRequest$ResourceType' => '<p>Resource type of the resource for which position configuration is retrieved.</p>', 'GetPositionRequest$ResourceType' => '<p>Resource type of the resource for which position information is retrieved.</p>', 'GetResourcePositionRequest$ResourceType' => '<p>The type of resource for which position information is retrieved, which can be a wireless device or a wireless gateway.</p>', 'ListPositionConfigurationsRequest$ResourceType' => '<p>Resource type for which position configurations are listed.</p>', 'PositionConfigurationItem$ResourceType' => '<p>Resource type of the resource for the position configuration.</p>', 'PutPositionConfigurationRequest$ResourceType' => '<p>Resource type of the resource for which you want to update the position configuration.</p>', 'UpdatePositionRequest$ResourceType' => '<p>Resource type of the resource for which position is updated.</p>', 'UpdateResourcePositionRequest$ResourceType' => '<p>The type of resource for which position information is updated, which can be a wireless device or a wireless gateway.</p>', ], ], 'PositionSolverConfigurations' => [ 'base' => '<p>The wrapper for position solver configurations.</p>', 'refs' => [ 'PutPositionConfigurationRequest$Solvers' => '<p>The positioning solvers used to update the position configuration of the resource.</p>', ], ], 'PositionSolverDetails' => [ 'base' => '<p>The wrapper for position solver details.</p>', 'refs' => [ 'GetPositionConfigurationResponse$Solvers' => '<p>The wrapper for the solver configuration details object.</p>', 'PositionConfigurationItem$Solvers' => '<p>The details of the positioning solver object used to compute the location.</p>', ], ], 'PositionSolverProvider' => [ 'base' => NULL, 'refs' => [ 'GetPositionResponse$SolverProvider' => '<p>The vendor of the positioning solver.</p>', 'SemtechGnssDetail$Provider' => '<p>The vendor of the solver object.</p>', ], ], 'PositionSolverType' => [ 'base' => NULL, 'refs' => [ 'GetPositionResponse$SolverType' => '<p>The type of solver used to identify the position of the resource.</p>', 'SemtechGnssDetail$Type' => '<p>The type of positioning solver used.</p>', ], ], 'PositionSolverVersion' => [ 'base' => NULL, 'refs' => [ 'GetPositionResponse$SolverVersion' => '<p>The version of the positioning solver.</p>', ], ], 'Positioning' => [ 'base' => '<p>The FPorts for the position information.</p>', 'refs' => [ 'FPorts$Positioning' => '<p>FPort values for the GNSS, stream, and ClockSync functions of the positioning information.</p>', 'UpdateFPorts$Positioning' => '<p>Positioning FPorts for the ClockSync, Stream, and GNSS functions.</p>', ], ], 'PositioningConfigStatus' => [ 'base' => NULL, 'refs' => [ 'CreateWirelessDeviceRequest$Positioning' => '<p>FPort values for the GNSS, stream, and ClockSync functions of the positioning information.</p>', 'GetWirelessDeviceResponse$Positioning' => '<p>FPort values for the GNSS, stream, and ClockSync functions of the positioning information.</p>', 'UpdateWirelessDeviceRequest$Positioning' => '<p>FPort values for the GNSS, stream, and ClockSync functions of the positioning information.</p>', ], ], 'PrAllowed' => [ 'base' => NULL, 'refs' => [ 'LoRaWANGetServiceProfileInfo$PrAllowed' => '<p>The PRAllowed value that describes whether passive roaming is allowed.</p>', 'LoRaWANServiceProfile$PrAllowed' => '<p>The PRAllowed value that describes whether passive roaming is allowed.</p>', ], ], 'PresetFreq' => [ 'base' => NULL, 'refs' => [ 'FactoryPresetFreqsList$member' => NULL, ], ], 'PrivateKeysList' => [ 'base' => NULL, 'refs' => [ 'SidewalkDevice$PrivateKeys' => '<p>The Sidewalk device private keys that will be used for onboarding the device.</p>', ], ], 'ProviderNetId' => [ 'base' => NULL, 'refs' => [ 'LoRaWANPublicGatewayMetadata$ProviderNetId' => '<p>The ID of the LoRaWAN public network provider.</p>', ], ], 'ProximityEventConfiguration' => [ 'base' => '<p>Proximity event configuration object for enabling and disabling relevant topics.</p>', 'refs' => [ 'EventNotificationItemConfigurations$Proximity' => '<p>Proximity event configuration for an event configuration item.</p>', 'GetResourceEventConfigurationResponse$Proximity' => '<p>Event configuration for the proximity event.</p>', 'UpdateResourceEventConfigurationRequest$Proximity' => '<p>Event configuration for the proximity event.</p>', ], ], 'ProximityResourceTypeEventConfiguration' => [ 'base' => '<p>Proximity resource type event configuration object for enabling or disabling topic.</p>', 'refs' => [ 'GetEventConfigurationByResourceTypesResponse$Proximity' => '<p>Resource type event configuration for the proximity event.</p>', 'UpdateEventConfigurationByResourceTypesRequest$Proximity' => '<p>Proximity resource type event configuration object for enabling and disabling wireless gateway topic.</p>', ], ], 'PutPositionConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutPositionConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutResourceLogLevelRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutResourceLogLevelResponse' => [ 'base' => NULL, 'refs' => [], ], 'QualificationStatus' => [ 'base' => NULL, 'refs' => [ 'SidewalkGetDeviceProfile$QualificationStatus' => '<p>Gets information about the certification status of a Sidewalk device profile.</p>', ], ], 'QueryString' => [ 'base' => '<p>Query string used to search for wireless devices as part of the bulk associate and disassociate process.</p>', 'refs' => [ 'StartBulkAssociateWirelessDeviceWithMulticastGroupRequest$QueryString' => NULL, 'StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest$QueryString' => NULL, ], ], 'RSCP' => [ 'base' => NULL, 'refs' => [ 'TdscdmaNmrObj$Rscp' => '<p>Code power of the received signal, measured in decibel-milliwatts (dBm).</p>', 'TdscdmaObj$Rscp' => '<p>Signal power of the received signal (Received Signal Code Power), measured in decibel-milliwatts (dBm).</p>', 'WcdmaNmrObj$Rscp' => '<p>Received Signal Code Power (signal power) (dBm)</p>', 'WcdmaObj$Rscp' => '<p>Received Signal Code Power (signal power) (dBm).</p>', ], ], 'RSRP' => [ 'base' => NULL, 'refs' => [ 'LteNmrObj$Rsrp' => '<p>Signal power of the reference signal received, measured in dBm (decibel-milliwatts).</p>', 'LteObj$Rsrp' => '<p>Signal power of the reference signal received, measured in dBm (decibel-milliwatts).</p>', ], ], 'RSRQ' => [ 'base' => NULL, 'refs' => [ 'LteNmrObj$Rsrq' => '<p>Signal quality of the reference Signal received, measured in decibels (dB).</p>', 'LteObj$Rsrq' => '<p>Signal quality of the reference Signal received, measured in decibels (dB).</p>', ], ], 'RSS' => [ 'base' => NULL, 'refs' => [ 'WiFiAccessPoint$Rss' => '<p>Received signal strength (dBm) of the WLAN measurement data.</p>', ], ], 'RaAllowed' => [ 'base' => NULL, 'refs' => [ 'LoRaWANGetServiceProfileInfo$RaAllowed' => '<p>The RAAllowed value that describes whether roaming activation is allowed.</p>', 'LoRaWANServiceProfile$RaAllowed' => '<p>The RAAllowed value that describes whether roaming activation is allowed.</p>', ], ], 'RedundancyPercent' => [ 'base' => '<p>The percentage of the added fragments that are redundant. For example, if the size of the firmware image file is 100 bytes and the fragment size is 10 bytes, with <code>RedundancyPercent</code> set to 50(%), the final number of encoded fragments is (100 / 10) + (100 / 10 * 50%) = 15.</p>', 'refs' => [ 'CreateFuotaTaskRequest$RedundancyPercent' => NULL, 'GetFuotaTaskResponse$RedundancyPercent' => NULL, 'UpdateFuotaTaskRequest$RedundancyPercent' => NULL, ], ], 'RegParamsRevision' => [ 'base' => NULL, 'refs' => [ 'LoRaWANDeviceProfile$RegParamsRevision' => '<p>The version of regional parameters.</p>', ], ], 'RegistrationZone' => [ 'base' => NULL, 'refs' => [ 'CdmaObj$RegistrationZone' => '<p>CDMA registration zone (RZ).</p>', ], ], 'ReportDevStatusBattery' => [ 'base' => NULL, 'refs' => [ 'LoRaWANGetServiceProfileInfo$ReportDevStatusBattery' => '<p>The ReportDevStatusBattery value.</p>', ], ], 'ReportDevStatusMargin' => [ 'base' => NULL, 'refs' => [ 'LoRaWANGetServiceProfileInfo$ReportDevStatusMargin' => '<p>The ReportDevStatusMargin value.</p>', ], ], 'ResetAllResourceLogLevelsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ResetAllResourceLogLevelsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ResetResourceLogLevelRequest' => [ 'base' => NULL, 'refs' => [], ], 'ResetResourceLogLevelResponse' => [ 'base' => NULL, 'refs' => [], ], 'ResourceId' => [ 'base' => NULL, 'refs' => [ 'ConflictException$ResourceId' => '<p>Id of the resource in the conflicting operation.</p>', 'ResourceNotFoundException$ResourceId' => '<p>Id of the not found resource.</p>', ], ], 'ResourceIdentifier' => [ 'base' => '<p>The identifier of the resource. For a Wireless Device, it is the wireless device ID. For a wireless gateway, it is the wireless gateway ID.</p>', 'refs' => [ 'GetResourceLogLevelRequest$ResourceIdentifier' => NULL, 'PutResourceLogLevelRequest$ResourceIdentifier' => NULL, 'ResetResourceLogLevelRequest$ResourceIdentifier' => NULL, ], ], 'ResourceNotFoundException' => [ 'base' => '<p>Resource does not exist.</p>', 'refs' => [], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'ConflictException$ResourceType' => '<p>Type of the resource in the conflicting operation.</p>', 'GetResourceLogLevelRequest$ResourceType' => '<p>The type of the resource, which can be <code>WirelessDevice</code> or <code>WirelessGateway</code>.</p>', 'PutResourceLogLevelRequest$ResourceType' => '<p>The type of the resource, which can be <code>WirelessDevice</code> or <code>WirelessGateway</code>.</p>', 'ResetResourceLogLevelRequest$ResourceType' => '<p>The type of the resource, which can be <code>WirelessDevice</code> or <code>WirelessGateway</code>.</p>', 'ResourceNotFoundException$ResourceType' => '<p>Type of the font found resource.</p>', ], ], 'Result' => [ 'base' => NULL, 'refs' => [ 'TestWirelessDeviceResponse$Result' => '<p>The result returned by the test.</p>', ], ], 'RfRegion' => [ 'base' => '<p>The frequency band (RFRegion) value.</p>', 'refs' => [ 'LoRaWANDeviceProfile$RfRegion' => '<p>The frequency band (RFRegion) value.</p>', 'LoRaWANFuotaTaskGetInfo$RfRegion' => NULL, 'LoRaWANGateway$RfRegion' => '<p>The frequency band (RFRegion) value.</p>', 'LoRaWANPublicGatewayMetadata$RfRegion' => NULL, ], ], 'Role' => [ 'base' => NULL, 'refs' => [ 'SidewalkGetStartImportInfo$Role' => '<p>The IAM role that allows AWS IoT Wireless to access the CSV file in the S3 bucket.</p>', 'SidewalkStartImportInfo$Role' => '<p>The IAM role that allows AWS IoT Wireless to access the CSV file in the S3 bucket.</p>', ], ], 'RoleArn' => [ 'base' => NULL, 'refs' => [ 'CreateDestinationRequest$RoleArn' => '<p>The ARN of the IAM Role that authorizes the destination.</p>', 'Destinations$RoleArn' => '<p>The ARN of the IAM Role that authorizes the destination.</p>', 'GetDestinationResponse$RoleArn' => '<p>The ARN of the IAM Role that authorizes the destination.</p>', 'UpdateDestinationRequest$RoleArn' => '<p>The ARN of the IAM Role that authorizes the destination.</p>', ], ], 'RxDataRate2' => [ 'base' => NULL, 'refs' => [ 'LoRaWANDeviceProfile$RxDataRate2' => '<p>The RXDataRate2 value.</p>', ], ], 'RxDelay1' => [ 'base' => NULL, 'refs' => [ 'LoRaWANDeviceProfile$RxDelay1' => '<p>The RXDelay1 value.</p>', ], ], 'RxDrOffset1' => [ 'base' => NULL, 'refs' => [ 'LoRaWANDeviceProfile$RxDrOffset1' => '<p>The RXDROffset1 value.</p>', ], ], 'RxFreq2' => [ 'base' => NULL, 'refs' => [ 'LoRaWANDeviceProfile$RxFreq2' => '<p>The RXFreq2 value.</p>', ], ], 'RxLevel' => [ 'base' => NULL, 'refs' => [ 'GsmNmrObj$RxLevel' => '<p>Rx level, which is the received signal power, measured in dBm (decibel-milliwatts).</p>', 'GsmObj$RxLevel' => '<p>Rx level, which is the received signal power, measured in dBm (decibel-milliwatts).</p>', ], ], 'SNwkSIntKey' => [ 'base' => NULL, 'refs' => [ 'SessionKeysAbpV1_1$SNwkSIntKey' => '<p>The SNwkSIntKey value.</p>', ], ], 'SemtechGnssConfiguration' => [ 'base' => '<p>Information about the Semtech GNSS solver configuration.</p>', 'refs' => [ 'PositionSolverConfigurations$SemtechGnss' => '<p>The Semtech GNSS solver configuration object.</p>', ], ], 'SemtechGnssDetail' => [ 'base' => '<p>Details of the Semtech GNSS solver object.</p>', 'refs' => [ 'PositionSolverDetails$SemtechGnss' => '<p>The Semtech GNSS solver object details.</p>', ], ], 'SendDataToMulticastGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'SendDataToMulticastGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'SendDataToWirelessDeviceRequest' => [ 'base' => NULL, 'refs' => [], ], 'SendDataToWirelessDeviceResponse' => [ 'base' => NULL, 'refs' => [], ], 'Seq' => [ 'base' => NULL, 'refs' => [ 'SidewalkSendDataToDevice$Seq' => '<p>The sequence number.</p>', ], ], 'ServiceProfile' => [ 'base' => '<p>Information about a service profile.</p>', 'refs' => [ 'ServiceProfileList$member' => NULL, ], ], 'ServiceProfileArn' => [ 'base' => NULL, 'refs' => [ 'CreateServiceProfileResponse$Arn' => '<p>The Amazon Resource Name of the new resource.</p>', 'GetServiceProfileResponse$Arn' => '<p>The Amazon Resource Name of the resource.</p>', 'ServiceProfile$Arn' => '<p>The Amazon Resource Name of the resource.</p>', ], ], 'ServiceProfileId' => [ 'base' => NULL, 'refs' => [ 'CreateServiceProfileResponse$Id' => '<p>The ID of the new service profile.</p>', 'DeleteServiceProfileRequest$Id' => '<p>The ID of the resource to delete.</p>', 'GetServiceProfileRequest$Id' => '<p>The ID of the resource to get.</p>', 'GetServiceProfileResponse$Id' => '<p>The ID of the service profile.</p>', 'ListWirelessDevicesRequest$ServiceProfileId' => '<p>A filter to list only the wireless devices that use this service profile.</p>', 'LoRaWANDevice$ServiceProfileId' => '<p>The ID of the service profile.</p>', 'LoRaWANUpdateDevice$ServiceProfileId' => '<p>The ID of the service profile.</p>', 'ServiceProfile$Id' => '<p>The ID of the service profile.</p>', ], ], 'ServiceProfileList' => [ 'base' => NULL, 'refs' => [ 'ListServiceProfilesResponse$ServiceProfileList' => '<p>The list of service profiles.</p>', ], ], 'ServiceProfileName' => [ 'base' => NULL, 'refs' => [ 'CreateServiceProfileRequest$Name' => '<p>The name of the new resource.</p>', 'GetServiceProfileResponse$Name' => '<p>The name of the resource.</p>', 'ServiceProfile$Name' => '<p>The name of the resource.</p>', ], ], 'SessionKeysAbpV1_0_x' => [ 'base' => '<p>Session keys for ABP v1.1</p>', 'refs' => [ 'AbpV1_0_x$SessionKeys' => '<p>Session keys for ABP v1.0.x</p>', ], ], 'SessionKeysAbpV1_1' => [ 'base' => '<p>Session keys for ABP v1.1</p>', 'refs' => [ 'AbpV1_1$SessionKeys' => '<p>Session keys for ABP v1.1</p>', ], ], 'SessionStartTimeTimestamp' => [ 'base' => '<p>Timestamp of when the multicast group session is to start.</p>', 'refs' => [ 'LoRaWANMulticastSession$SessionStartTime' => NULL, ], ], 'SessionTimeout' => [ 'base' => '<p>How long before a multicast group session is to timeout.</p>', 'refs' => [ 'LoRaWANMulticastSession$SessionTimeout' => NULL, ], ], 'SidewalkAccountInfo' => [ 'base' => '<p>Information about a Sidewalk account.</p>', 'refs' => [ 'AssociateAwsAccountWithPartnerAccountRequest$Sidewalk' => '<p>The Sidewalk account credentials.</p>', 'AssociateAwsAccountWithPartnerAccountResponse$Sidewalk' => '<p>The Sidewalk account credentials.</p>', ], ], 'SidewalkAccountInfoWithFingerprint' => [ 'base' => '<p>Information about a Sidewalk account.</p>', 'refs' => [ 'GetPartnerAccountResponse$Sidewalk' => '<p>The Sidewalk account credentials.</p>', 'SidewalkAccountList$member' => NULL, ], ], 'SidewalkAccountList' => [ 'base' => NULL, 'refs' => [ 'ListPartnerAccountsResponse$Sidewalk' => '<p>The Sidewalk account credentials.</p>', ], ], 'SidewalkCreateDeviceProfile' => [ 'base' => '<p>Sidewalk object for creating a device profile.</p>', 'refs' => [ 'CreateDeviceProfileRequest$Sidewalk' => '<p>The Sidewalk-related information for creating the Sidewalk device profile.</p>', ], ], 'SidewalkCreateWirelessDevice' => [ 'base' => '<p>Sidewalk object for creating a wireless device.</p>', 'refs' => [ 'CreateWirelessDeviceRequest$Sidewalk' => '<p>The device configuration information to use to create the Sidewalk device.</p>', ], ], 'SidewalkDevice' => [ 'base' => '<p>Sidewalk device object.</p>', 'refs' => [ 'GetWirelessDeviceResponse$Sidewalk' => '<p>Sidewalk device object.</p>', ], ], 'SidewalkDeviceMetadata' => [ 'base' => '<p>MetaData for Sidewalk device.</p>', 'refs' => [ 'GetWirelessDeviceStatisticsResponse$Sidewalk' => '<p>MetaData for Sidewalk device.</p>', ], ], 'SidewalkEventNotificationConfigurations' => [ 'base' => '<p> <code>SidewalkEventNotificationConfigurations</code> object, which is the event configuration object for Sidewalk-related event topics.</p>', 'refs' => [ 'DeviceRegistrationStateEventConfiguration$Sidewalk' => '<p>Device registration state event configuration object for enabling or disabling Sidewalk related event topics.</p>', 'MessageDeliveryStatusEventConfiguration$Sidewalk' => NULL, 'ProximityEventConfiguration$Sidewalk' => '<p>Proximity event configuration object for enabling or disabling Sidewalk related event topics.</p>', ], ], 'SidewalkGetDeviceProfile' => [ 'base' => '<p>Gets information about a Sidewalk device profile.</p>', 'refs' => [ 'GetDeviceProfileResponse$Sidewalk' => '<p>Information about the Sidewalk parameters in the device profile.</p>', ], ], 'SidewalkGetStartImportInfo' => [ 'base' => '<p>Sidewalk-related information for devices in an import task that are being onboarded.</p>', 'refs' => [ 'GetWirelessDeviceImportTaskResponse$Sidewalk' => '<p>The Sidewalk-related information about an import task.</p>', 'WirelessDeviceImportTask$Sidewalk' => '<p>The Sidewalk-related information of the wireless device import task.</p>', ], ], 'SidewalkId' => [ 'base' => '<p>The sidewalk device identification.</p>', 'refs' => [ 'SidewalkDevice$SidewalkId' => '<p>The sidewalk device identification.</p>', 'SidewalkListDevice$SidewalkId' => '<p>The sidewalk device identification.</p>', ], ], 'SidewalkListDevice' => [ 'base' => '<p>Sidewalk object used by list functions.</p>', 'refs' => [ 'WirelessDeviceStatistics$Sidewalk' => '<p>The Sidewalk account credentials.</p>', ], ], 'SidewalkManufacturingSn' => [ 'base' => NULL, 'refs' => [ 'ImportedSidewalkDevice$SidewalkManufacturingSn' => '<p>The Sidewalk manufacturing serial number (SMSN) of the Sidewalk device.</p>', 'SidewalkDevice$SidewalkManufacturingSn' => '<p>The Sidewalk manufacturing series number.</p>', 'SidewalkListDevice$SidewalkManufacturingSn' => '<p>The Sidewalk manufacturing series number.</p>', 'SidewalkSingleStartImportInfo$SidewalkManufacturingSn' => '<p>The Sidewalk manufacturing serial number (SMSN) of the device added to the import task.</p>', ], ], 'SidewalkResourceTypeEventConfiguration' => [ 'base' => '<p>Sidewalk resource type event configuration object for enabling or disabling topic.</p>', 'refs' => [ 'DeviceRegistrationStateResourceTypeEventConfiguration$Sidewalk' => '<p>Device registration resource type state event configuration object for enabling or disabling Sidewalk related event topics.</p>', 'MessageDeliveryStatusResourceTypeEventConfiguration$Sidewalk' => NULL, 'ProximityResourceTypeEventConfiguration$Sidewalk' => '<p>Proximity resource type event configuration object for enabling and disabling wireless device topic.</p>', ], ], 'SidewalkSendDataToDevice' => [ 'base' => '<p>Information about a Sidewalk router.</p>', 'refs' => [ 'WirelessMetadata$Sidewalk' => '<p>The Sidewalk account credentials.</p>', ], ], 'SidewalkSingleStartImportInfo' => [ 'base' => '<p>Information about an import task created for an individual Sidewalk device.</p>', 'refs' => [ 'StartSingleWirelessDeviceImportTaskRequest$Sidewalk' => '<p>The Sidewalk-related parameters for importing a single wireless device.</p>', ], ], 'SidewalkStartImportInfo' => [ 'base' => '<p>Information about an import task created for bulk provisioning.</p>', 'refs' => [ 'StartWirelessDeviceImportTaskRequest$Sidewalk' => '<p>The Sidewalk-related parameters for importing wireless devices that need to be provisioned in bulk.</p>', ], ], 'SidewalkUpdateAccount' => [ 'base' => '<p>Sidewalk update.</p>', 'refs' => [ 'UpdatePartnerAccountRequest$Sidewalk' => '<p>The Sidewalk account credentials.</p>', ], ], 'SidewalkUpdateImportInfo' => [ 'base' => '<p>Sidewalk object information for updating an import task.</p>', 'refs' => [ 'UpdateWirelessDeviceImportTaskRequest$Sidewalk' => '<p>The Sidewalk-related parameters of the import task to be updated.</p>', ], ], 'SigningAlg' => [ 'base' => '<p>The certificate chain algorithm provided by sidewalk.</p>', 'refs' => [ 'CertificateList$SigningAlg' => '<p>The certificate chain algorithm provided by sidewalk.</p>', ], ], 'StartBulkAssociateWirelessDeviceWithMulticastGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartBulkAssociateWirelessDeviceWithMulticastGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartBulkDisassociateWirelessDeviceFromMulticastGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartFuotaTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartFuotaTaskResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartMulticastGroupSessionRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartMulticastGroupSessionResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartSingleWirelessDeviceImportTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartSingleWirelessDeviceImportTaskResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartTime' => [ 'base' => '<p>Start time of a FUOTA task.</p>', 'refs' => [ 'LoRaWANFuotaTaskGetInfo$StartTime' => NULL, 'LoRaWANStartFuotaTask$StartTime' => NULL, ], ], 'StartWirelessDeviceImportTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartWirelessDeviceImportTaskResponse' => [ 'base' => NULL, 'refs' => [], ], 'Station' => [ 'base' => NULL, 'refs' => [ 'LoRaWANGatewayVersion$Station' => '<p>The basic station version of the wireless gateway.</p>', ], ], 'StatusReason' => [ 'base' => NULL, 'refs' => [ 'GetWirelessDeviceImportTaskResponse$StatusReason' => '<p>The reason for the provided status information, such as a validation error that causes the import task to fail.</p>', 'WirelessDeviceImportTask$StatusReason' => '<p>The reason that provides additional information about the import task status.</p>', ], ], 'Std' => [ 'base' => NULL, 'refs' => [ 'MetricQueryValue$Std' => '<p>The standard deviation of the values of all data points collected during the aggregation period.</p>', ], ], 'SubBand' => [ 'base' => '<p>A subset of supported frequency channels in a certain RFRegion.</p>', 'refs' => [ 'SubBands$member' => NULL, ], ], 'SubBands' => [ 'base' => '<p>A list of integer indicating which sub bands are supported by LoRa gateway.</p>', 'refs' => [ 'LoRaWANGateway$SubBands' => NULL, ], ], 'Sum' => [ 'base' => NULL, 'refs' => [ 'MetricQueryValue$Sum' => '<p>The sum of the values of all data points collected during the aggregation period.</p>', ], ], 'SummaryMetricConfiguration' => [ 'base' => '<p>The configuration of summary metrics.</p>', 'refs' => [ 'GetMetricConfigurationResponse$SummaryMetric' => '<p>The configuration status of the AWS account for summary metric aggregation.</p>', 'UpdateMetricConfigurationRequest$SummaryMetric' => '<p>The value to be used to set summary metric configuration.</p>', ], ], 'SummaryMetricConfigurationStatus' => [ 'base' => NULL, 'refs' => [ 'SummaryMetricConfiguration$Status' => '<p>The status of the configuration of summary metrics.</p>', ], ], 'SummaryMetricQueries' => [ 'base' => NULL, 'refs' => [ 'GetMetricsRequest$SummaryMetricQueries' => '<p>The list of queries to retrieve the summary metrics.</p>', ], ], 'SummaryMetricQuery' => [ 'base' => '<p>The summary metric query object.</p>', 'refs' => [ 'SummaryMetricQueries$member' => NULL, ], ], 'SummaryMetricQueryResult' => [ 'base' => '<p>The result of the summary metrics aggregation operation.</p>', 'refs' => [ 'SummaryMetricQueryResults$member' => NULL, ], ], 'SummaryMetricQueryResults' => [ 'base' => NULL, 'refs' => [ 'GetMetricsResponse$SummaryMetricQueryResults' => '<p>The list of summary metrics that were retrieved.</p>', ], ], 'SupportedRfRegion' => [ 'base' => '<p>Supported RfRegions</p>', 'refs' => [ 'LoRaWANFuotaTask$RfRegion' => NULL, 'LoRaWANMulticast$RfRegion' => NULL, 'LoRaWANMulticastGet$RfRegion' => NULL, ], ], 'Supports32BitFCnt' => [ 'base' => NULL, 'refs' => [ 'LoRaWANDeviceProfile$Supports32BitFCnt' => '<p>The Supports32BitFCnt value.</p>', ], ], 'SupportsClassB' => [ 'base' => NULL, 'refs' => [ 'LoRaWANDeviceProfile$SupportsClassB' => '<p>The SupportsClassB value.</p>', ], ], 'SupportsClassC' => [ 'base' => NULL, 'refs' => [ 'LoRaWANDeviceProfile$SupportsClassC' => '<p>The SupportsClassC value.</p>', ], ], 'SupportsJoin' => [ 'base' => NULL, 'refs' => [ 'LoRaWANDeviceProfile$SupportsJoin' => '<p>The SupportsJoin value.</p>', ], ], 'SystemId' => [ 'base' => NULL, 'refs' => [ 'CdmaObj$SystemId' => '<p>CDMA system ID (SID).</p>', ], ], 'TAC' => [ 'base' => NULL, 'refs' => [ 'LteObj$Tac' => '<p>LTE tracking area code.</p>', ], ], 'Tag' => [ 'base' => '<p>A simple label consisting of a customer-defined key-value pair</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The tag\'s key value.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>A list of the keys of the tags to remove from the resource.</p>', ], ], 'TagList' => [ 'base' => '<p>The tag to attach to the specified resource. Tags are metadata that you can use to manage a resource.</p>', 'refs' => [ 'AssociateAwsAccountWithPartnerAccountRequest$Tags' => '<p>The tags to attach to the specified resource. Tags are metadata that you can use to manage a resource.</p>', 'CreateDestinationRequest$Tags' => '<p>The tags to attach to the new destination. Tags are metadata that you can use to manage a resource.</p>', 'CreateDeviceProfileRequest$Tags' => '<p>The tags to attach to the new device profile. Tags are metadata that you can use to manage a resource.</p>', 'CreateFuotaTaskRequest$Tags' => NULL, 'CreateMulticastGroupRequest$Tags' => NULL, 'CreateNetworkAnalyzerConfigurationRequest$Tags' => NULL, 'CreateServiceProfileRequest$Tags' => '<p>The tags to attach to the new service profile. Tags are metadata that you can use to manage a resource.</p>', 'CreateWirelessDeviceRequest$Tags' => '<p>The tags to attach to the new wireless device. Tags are metadata that you can use to manage a resource.</p>', 'CreateWirelessGatewayRequest$Tags' => '<p>The tags to attach to the new wireless gateway. Tags are metadata that you can use to manage a resource.</p>', 'CreateWirelessGatewayTaskDefinitionRequest$Tags' => '<p>The tags to attach to the specified resource. Tags are metadata that you can use to manage a resource.</p>', 'ListTagsForResourceResponse$Tags' => '<p>The tags to attach to the specified resource. Tags are metadata that you can use to manage a resource.</p>', 'StartBulkAssociateWirelessDeviceWithMulticastGroupRequest$Tags' => NULL, 'StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest$Tags' => NULL, 'StartSingleWirelessDeviceImportTaskRequest$Tags' => NULL, 'StartWirelessDeviceImportTaskRequest$Tags' => NULL, 'TagResourceRequest$Tags' => '<p>Adds to or modifies the tags of the given resource. Tags are metadata that you can use to manage a resource.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The tag\'s value.</p>', ], ], 'TargetPer' => [ 'base' => NULL, 'refs' => [ 'LoRaWANGetServiceProfileInfo$TargetPer' => '<p>The TargetPER value.</p>', ], ], 'TdscdmaList' => [ 'base' => NULL, 'refs' => [ 'CellTowers$Tdscdma' => '<p>TD-SCDMA object information.</p>', ], ], 'TdscdmaLocalId' => [ 'base' => '<p>TD-SCDMA local identification (local Id) information.</p>', 'refs' => [ 'TdscdmaObj$TdscdmaLocalId' => '<p>TD-SCDMA local identification (local ID) information.</p>', ], ], 'TdscdmaNmrList' => [ 'base' => NULL, 'refs' => [ 'TdscdmaObj$TdscdmaNmr' => '<p>TD-SCDMA object for network measurement reports.</p>', ], ], 'TdscdmaNmrObj' => [ 'base' => '<p>TD-SCDMA object for network measurement reports.</p>', 'refs' => [ 'TdscdmaNmrList$member' => NULL, ], ], 'TdscdmaObj' => [ 'base' => '<p>TD-SCDMA object.</p>', 'refs' => [ 'TdscdmaList$member' => NULL, ], ], 'TdscdmaTimingAdvance' => [ 'base' => NULL, 'refs' => [ 'TdscdmaObj$TdscdmaTimingAdvance' => '<p>TD-SCDMA Timing advance.</p>', ], ], 'TestWirelessDeviceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TestWirelessDeviceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ThingArn' => [ 'base' => NULL, 'refs' => [ 'AssociateWirelessDeviceWithThingRequest$ThingArn' => '<p>The ARN of the thing to associate with the wireless device.</p>', 'AssociateWirelessGatewayWithThingRequest$ThingArn' => '<p>The ARN of the thing to associate with the wireless gateway.</p>', 'GetWirelessDeviceResponse$ThingArn' => '<p>The ARN of the thing associated with the wireless device.</p>', 'GetWirelessGatewayResponse$ThingArn' => '<p>The ARN of the thing associated with the wireless gateway.</p>', ], ], 'ThingName' => [ 'base' => NULL, 'refs' => [ 'GetWirelessDeviceResponse$ThingName' => '<p>The name of the thing associated with the wireless device. The value is empty if a thing isn\'t associated with the device.</p>', 'GetWirelessGatewayResponse$ThingName' => '<p>The name of the thing associated with the wireless gateway. The value is empty if a thing isn\'t associated with the gateway.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The request was denied because it exceeded the allowed API request rate.</p>', 'refs' => [], ], 'TooManyTagsException' => [ 'base' => '<p>The request was denied because the resource can\'t have any more tags.</p>', 'refs' => [], ], 'TraceContent' => [ 'base' => '<p>Trace content for your wireless devices, gateways, and multicast groups.</p>', 'refs' => [ 'CreateNetworkAnalyzerConfigurationRequest$TraceContent' => NULL, 'GetNetworkAnalyzerConfigurationResponse$TraceContent' => NULL, 'UpdateNetworkAnalyzerConfigurationRequest$TraceContent' => NULL, ], ], 'TransmissionInterval' => [ 'base' => NULL, 'refs' => [ 'ParticipatingGateways$TransmissionInterval' => '<p>The duration of time for which AWS IoT Core for LoRaWAN will wait before transmitting the payload to the next gateway.</p>', ], ], 'TransmitMode' => [ 'base' => NULL, 'refs' => [ 'DownlinkQueueMessage$TransmitMode' => '<p>The transmit mode to use for sending data to the wireless device. This can be <code>0</code> for UM (unacknowledge mode) or <code>1</code> for AM (acknowledge mode).</p>', 'SendDataToWirelessDeviceRequest$TransmitMode' => '<p>The transmit mode to use to send data to the wireless device. Can be: <code>0</code> for UM (unacknowledge mode) or <code>1</code> for AM (acknowledge mode).</p>', ], ], 'UARFCN' => [ 'base' => NULL, 'refs' => [ 'TdscdmaLocalId$Uarfcn' => '<p>TD-SCDMA UTRA (Universal Terrestrial Radio Access Network) absolute RF channel number (UARFCN).</p>', 'TdscdmaNmrObj$Uarfcn' => '<p>TD-SCDMA UTRA (Universal Terrestrial Radio Access Network) absolute RF channel number.</p>', ], ], 'UARFCNDL' => [ 'base' => NULL, 'refs' => [ 'WcdmaLocalId$Uarfcndl' => '<p>WCDMA UTRA Absolute RF Channel Number downlink.</p>', 'WcdmaNmrObj$Uarfcndl' => '<p>WCDMA UTRA Absolute RF Channel Number downlink.</p>', ], ], 'UlBucketSize' => [ 'base' => NULL, 'refs' => [ 'LoRaWANGetServiceProfileInfo$UlBucketSize' => '<p>The ULBucketSize value.</p>', ], ], 'UlRate' => [ 'base' => NULL, 'refs' => [ 'LoRaWANGetServiceProfileInfo$UlRate' => '<p>The ULRate value.</p>', ], ], 'UlRatePolicy' => [ 'base' => NULL, 'refs' => [ 'LoRaWANGetServiceProfileInfo$UlRatePolicy' => '<p>The ULRatePolicy value.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAbpV1_0_x' => [ 'base' => '<p>ABP device object for LoRaWAN specification v1.0.x</p>', 'refs' => [ 'LoRaWANUpdateDevice$AbpV1_0_x' => '<p>ABP device object for update APIs for v1.0.x</p>', ], ], 'UpdateAbpV1_1' => [ 'base' => '<p>ABP device object for LoRaWAN specification v1.1</p>', 'refs' => [ 'LoRaWANUpdateDevice$AbpV1_1' => '<p>ABP device object for update APIs for v1.1</p>', ], ], 'UpdateDataSource' => [ 'base' => NULL, 'refs' => [ 'UpdateWirelessGatewayTaskCreate$UpdateDataSource' => '<p>The link to the S3 bucket.</p>', 'UpdateWirelessGatewayTaskCreate$UpdateDataRole' => '<p>The IAM role used to read data from the S3 bucket.</p>', ], ], 'UpdateDestinationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDestinationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEventConfigurationByResourceTypesRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEventConfigurationByResourceTypesResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFPorts' => [ 'base' => '<p>Object for updating the FPorts information.</p>', 'refs' => [ 'LoRaWANUpdateDevice$FPorts' => '<p>FPorts object for the positioning information of the device.</p>', ], ], 'UpdateFuotaTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFuotaTaskResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLogLevelsByResourceTypesRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLogLevelsByResourceTypesResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMetricConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMetricConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMulticastGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMulticastGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateNetworkAnalyzerConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateNetworkAnalyzerConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePartnerAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePartnerAccountResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePositionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePositionResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateResourceEventConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateResourceEventConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateResourcePositionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateResourcePositionResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSignature' => [ 'base' => NULL, 'refs' => [ 'LoRaWANUpdateGatewayTaskCreate$UpdateSignature' => '<p>The signature used to verify the update firmware.</p>', ], ], 'UpdateWirelessDeviceImportTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWirelessDeviceImportTaskResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWirelessDeviceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWirelessDeviceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWirelessGatewayRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWirelessGatewayResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWirelessGatewayTaskCreate' => [ 'base' => '<p>UpdateWirelessGatewayTaskCreate object.</p>', 'refs' => [ 'CreateWirelessGatewayTaskDefinitionRequest$Update' => '<p>Information about the gateways to update.</p>', 'GetWirelessGatewayTaskDefinitionResponse$Update' => '<p>Information about the gateways to update.</p>', ], ], 'UpdateWirelessGatewayTaskEntry' => [ 'base' => '<p>UpdateWirelessGatewayTaskEntry object.</p>', 'refs' => [ 'WirelessGatewayTaskDefinitionList$member' => NULL, ], ], 'Use2DSolver' => [ 'base' => NULL, 'refs' => [ 'Gnss$Use2DSolver' => '<p>Optional parameter that forces 2D solve, which modifies the positioning algorithm to a 2D solution problem. When this parameter is specified, the assistance altitude should have an accuracy of at least 10 meters.</p>', ], ], 'UtranCid' => [ 'base' => NULL, 'refs' => [ 'TdscdmaNmrObj$UtranCid' => '<p>UTRAN (UMTS Terrestrial Radio Access Network) cell global identifier.</p>', 'TdscdmaObj$UtranCid' => '<p>UTRAN (UMTS Terrestrial Radio Access Network) Cell Global Identifier.</p>', 'WcdmaNmrObj$UtranCid' => '<p>UTRAN (UMTS Terrestrial Radio Access Network) Cell Global Identifier.</p>', 'WcdmaObj$UtranCid' => '<p>UTRAN (UMTS Terrestrial Radio Access Network) Cell Global Identifier.</p>', ], ], 'ValidationException' => [ 'base' => '<p>The input did not meet the specified constraints.</p>', 'refs' => [], ], 'VerticalAccuracy' => [ 'base' => NULL, 'refs' => [ 'Accuracy$VerticalAccuracy' => '<p>The vertical accuracy of the estimated position, which is the difference between the estimated altitude and actual device latitude in meters.</p>', ], ], 'WcdmaList' => [ 'base' => NULL, 'refs' => [ 'CellTowers$Wcdma' => '<p>WCDMA object information.</p>', ], ], 'WcdmaLocalId' => [ 'base' => '<p>WCDMA local identification (local ID) information.</p>', 'refs' => [ 'WcdmaObj$WcdmaLocalId' => '<p>WCDMA local ID information.</p>', ], ], 'WcdmaNmrList' => [ 'base' => NULL, 'refs' => [ 'WcdmaObj$WcdmaNmr' => '<p>WCDMA object for network measurement reports.</p>', ], ], 'WcdmaNmrObj' => [ 'base' => '<p>Network Measurement Reports.</p>', 'refs' => [ 'WcdmaNmrList$member' => NULL, ], ], 'WcdmaObj' => [ 'base' => '<p>WCDMA.</p>', 'refs' => [ 'WcdmaList$member' => NULL, ], ], 'WiFiAccessPoint' => [ 'base' => '<p>Wi-Fi access point.</p>', 'refs' => [ 'WiFiAccessPoints$member' => NULL, ], ], 'WiFiAccessPoints' => [ 'base' => NULL, 'refs' => [ 'GetPositionEstimateRequest$WiFiAccessPoints' => '<p>Retrieves an estimated device position by resolving WLAN measurement data. The position is resolved using HERE\'s Wi-Fi based solver.</p>', ], ], 'WirelessDeviceArn' => [ 'base' => NULL, 'refs' => [ 'CreateWirelessDeviceResponse$Arn' => '<p>The Amazon Resource Name of the new resource.</p>', 'GetWirelessDeviceResponse$Arn' => '<p>The Amazon Resource Name of the resource.</p>', 'WirelessDeviceStatistics$Arn' => '<p>The Amazon Resource Name of the resource.</p>', ], ], 'WirelessDeviceEvent' => [ 'base' => '<p>The event for a log message, if the log message is tied to a wireless device.</p>', 'refs' => [ 'WirelessDeviceEventLogOption$Event' => NULL, ], ], 'WirelessDeviceEventLogOption' => [ 'base' => '<p>The log options for a wireless device event and can be used to set log levels for a specific wireless device event.</p> <p>For a LoRaWAN device, possible events for a log messsage are: <code>Join</code>, <code>Rejoin</code>, <code>Downlink_Data</code>, and <code>Uplink_Data</code>. For a Sidewalk device, possible events for a log message are <code>Registration</code>, <code>Downlink_Data</code>, and <code>Uplink_Data</code>.</p>', 'refs' => [ 'WirelessDeviceEventLogOptionList$member' => NULL, ], ], 'WirelessDeviceEventLogOptionList' => [ 'base' => '<p>The list of wireless device event log options.</p>', 'refs' => [ 'WirelessDeviceLogOption$Events' => NULL, ], ], 'WirelessDeviceFrameInfo' => [ 'base' => '<p> <code>FrameInfo</code> of your wireless device resources for the trace content. Use FrameInfo to debug the communication between your LoRaWAN end devices and the network server.</p>', 'refs' => [ 'TraceContent$WirelessDeviceFrameInfo' => NULL, ], ], 'WirelessDeviceId' => [ 'base' => '<p>The ID of the wireless device.</p>', 'refs' => [ 'AssociateWirelessDeviceWithFuotaTaskRequest$WirelessDeviceId' => NULL, 'AssociateWirelessDeviceWithMulticastGroupRequest$WirelessDeviceId' => NULL, 'AssociateWirelessDeviceWithThingRequest$Id' => '<p>The ID of the resource to update.</p>', 'CreateWirelessDeviceResponse$Id' => '<p>The ID of the new wireless device.</p>', 'CreateWirelessGatewayResponse$Id' => '<p>The ID of the new wireless gateway.</p>', 'DeleteQueuedMessagesRequest$Id' => '<p>The ID of a given wireless device for which downlink messages will be deleted.</p>', 'DeleteWirelessDeviceRequest$Id' => '<p>The ID of the resource to delete.</p>', 'DisassociateWirelessDeviceFromFuotaTaskRequest$WirelessDeviceId' => NULL, 'DisassociateWirelessDeviceFromMulticastGroupRequest$WirelessDeviceId' => NULL, 'DisassociateWirelessDeviceFromThingRequest$Id' => '<p>The ID of the resource to update.</p>', 'GetWirelessDeviceResponse$Id' => '<p>The ID of the wireless device.</p>', 'GetWirelessDeviceStatisticsRequest$WirelessDeviceId' => '<p>The ID of the wireless device for which to get the data.</p>', 'GetWirelessDeviceStatisticsResponse$WirelessDeviceId' => '<p>The ID of the wireless device.</p>', 'ListQueuedMessagesRequest$Id' => '<p>The ID of a given wireless device which the downlink message packets are being sent.</p>', 'SendDataToWirelessDeviceRequest$Id' => '<p>The ID of the wireless device to receive the data.</p>', 'TestWirelessDeviceRequest$Id' => '<p>The ID of the wireless device to test.</p>', 'UpdateWirelessDeviceRequest$Id' => '<p>The ID of the resource to update.</p>', 'WirelessDeviceList$member' => NULL, 'WirelessDeviceStatistics$Id' => '<p>The ID of the wireless device reporting the data.</p>', ], ], 'WirelessDeviceIdType' => [ 'base' => NULL, 'refs' => [ 'GetWirelessDeviceRequest$IdentifierType' => '<p>The type of identifier used in <code>identifier</code>.</p>', ], ], 'WirelessDeviceImportTask' => [ 'base' => '<p>Information about an import task for wireless devices.</p>', 'refs' => [ 'WirelessDeviceImportTaskList$member' => NULL, ], ], 'WirelessDeviceImportTaskList' => [ 'base' => NULL, 'refs' => [ 'ListWirelessDeviceImportTasksResponse$WirelessDeviceImportTaskList' => '<p>List of import tasks and summary information of onboarding status of devices in each import task.</p>', ], ], 'WirelessDeviceList' => [ 'base' => NULL, 'refs' => [ 'CreateNetworkAnalyzerConfigurationRequest$WirelessDevices' => '<p>Wireless device resources to add to the network analyzer configuration. Provide the <code>WirelessDeviceId</code> of the resource to add in the input array.</p>', 'GetNetworkAnalyzerConfigurationResponse$WirelessDevices' => '<p>List of wireless device resources that have been added to the network analyzer configuration.</p>', 'UpdateNetworkAnalyzerConfigurationRequest$WirelessDevicesToAdd' => '<p>Wireless device resources to add to the network analyzer configuration. Provide the <code>WirelessDeviceId</code> of the resource to add in the input array.</p>', 'UpdateNetworkAnalyzerConfigurationRequest$WirelessDevicesToRemove' => '<p>Wireless device resources to remove from the network analyzer configuration. Provide the <code>WirelessDeviceId</code> of the resources to remove in the input array.</p>', ], ], 'WirelessDeviceLogOption' => [ 'base' => '<p>The log options for wireless devices and can be used to set log levels for a specific type of wireless device.</p>', 'refs' => [ 'WirelessDeviceLogOptionList$member' => NULL, ], ], 'WirelessDeviceLogOptionList' => [ 'base' => '<p>The list of wireless device log options.</p>', 'refs' => [ 'GetLogLevelsByResourceTypesResponse$WirelessDeviceLogOptions' => NULL, 'UpdateLogLevelsByResourceTypesRequest$WirelessDeviceLogOptions' => NULL, ], ], 'WirelessDeviceName' => [ 'base' => NULL, 'refs' => [ 'CreateWirelessDeviceRequest$Name' => '<p>The name of the new resource.</p>', 'GetWirelessDeviceResponse$Name' => '<p>The name of the resource.</p>', 'UpdateWirelessDeviceRequest$Name' => '<p>The new name of the resource.</p>', 'WirelessDeviceStatistics$Name' => '<p>The name of the resource.</p>', ], ], 'WirelessDeviceSidewalkStatus' => [ 'base' => NULL, 'refs' => [ 'SidewalkDevice$Status' => '<p>The Sidewalk device status, such as provisioned or registered.</p>', 'SidewalkListDevice$Status' => '<p>The status of the Sidewalk devices, such as provisioned or registered.</p>', ], ], 'WirelessDeviceStatistics' => [ 'base' => '<p>Information about a wireless device\'s operation.</p>', 'refs' => [ 'WirelessDeviceStatisticsList$member' => NULL, ], ], 'WirelessDeviceStatisticsList' => [ 'base' => NULL, 'refs' => [ 'ListWirelessDevicesResponse$WirelessDeviceList' => '<p>The ID of the wireless device.</p>', ], ], 'WirelessDeviceType' => [ 'base' => NULL, 'refs' => [ 'CreateWirelessDeviceRequest$Type' => '<p>The wireless device type.</p>', 'DeleteQueuedMessagesRequest$WirelessDeviceType' => '<p>The wireless device type, which can be either Sidewalk or LoRaWAN.</p>', 'DeregisterWirelessDeviceRequest$WirelessDeviceType' => '<p>The type of wireless device to deregister from AWS IoT Wireless, which can be <code>LoRaWAN</code> or <code>Sidewalk</code>.</p>', 'GetWirelessDeviceResponse$Type' => '<p>The wireless device type.</p>', 'ListQueuedMessagesRequest$WirelessDeviceType' => '<p>The wireless device type, whic can be either Sidewalk or LoRaWAN.</p>', 'ListWirelessDevicesRequest$WirelessDeviceType' => '<p>A filter to list only the wireless devices that use this wireless device type.</p>', 'WirelessDeviceLogOption$Type' => '<p>The wireless device type.</p>', 'WirelessDeviceStatistics$Type' => '<p>The wireless device type.</p>', ], ], 'WirelessGatewayArn' => [ 'base' => NULL, 'refs' => [ 'CreateWirelessGatewayResponse$Arn' => '<p>The Amazon Resource Name of the new resource.</p>', 'GetWirelessGatewayResponse$Arn' => '<p>The Amazon Resource Name of the resource.</p>', 'WirelessGatewayStatistics$Arn' => '<p>The Amazon Resource Name of the resource.</p>', ], ], 'WirelessGatewayEvent' => [ 'base' => '<p>The event for a log message, if the log message is tied to a wireless gateway.</p>', 'refs' => [ 'WirelessGatewayEventLogOption$Event' => NULL, ], ], 'WirelessGatewayEventLogOption' => [ 'base' => '<p>The log options for a wireless gateway event and can be used to set log levels for a specific wireless gateway event.</p> <p>For a LoRaWAN gateway, possible events for a log message are <code>CUPS_Request</code> and <code>Certificate</code>.</p>', 'refs' => [ 'WirelessGatewayEventLogOptionList$member' => NULL, ], ], 'WirelessGatewayEventLogOptionList' => [ 'base' => '<p>The list of wireless gateway event log options.</p>', 'refs' => [ 'WirelessGatewayLogOption$Events' => NULL, ], ], 'WirelessGatewayId' => [ 'base' => NULL, 'refs' => [ 'AssociateWirelessGatewayWithCertificateRequest$Id' => '<p>The ID of the resource to update.</p>', 'AssociateWirelessGatewayWithThingRequest$Id' => '<p>The ID of the resource to update.</p>', 'CreateWirelessGatewayTaskRequest$Id' => '<p>The ID of the resource to update.</p>', 'DeleteWirelessGatewayRequest$Id' => '<p>The ID of the resource to delete.</p>', 'DeleteWirelessGatewayTaskRequest$Id' => '<p>The ID of the resource to delete.</p>', 'DisassociateWirelessGatewayFromCertificateRequest$Id' => '<p>The ID of the resource to update.</p>', 'DisassociateWirelessGatewayFromThingRequest$Id' => '<p>The ID of the resource to update.</p>', 'GatewayListItem$GatewayId' => '<p>The ID of the wireless gateways that you want to add to the list of gateways when sending downlink messages.</p>', 'GetWirelessGatewayCertificateRequest$Id' => '<p>The ID of the resource to get.</p>', 'GetWirelessGatewayFirmwareInformationRequest$Id' => '<p>The ID of the resource to get.</p>', 'GetWirelessGatewayResponse$Id' => '<p>The ID of the wireless gateway.</p>', 'GetWirelessGatewayStatisticsRequest$WirelessGatewayId' => '<p>The ID of the wireless gateway for which to get the data.</p>', 'GetWirelessGatewayStatisticsResponse$WirelessGatewayId' => '<p>The ID of the wireless gateway.</p>', 'GetWirelessGatewayTaskRequest$Id' => '<p>The ID of the resource to get.</p>', 'GetWirelessGatewayTaskResponse$WirelessGatewayId' => '<p>The ID of the wireless gateway.</p>', 'UpdateWirelessGatewayRequest$Id' => '<p>The ID of the resource to update.</p>', 'WirelessGatewayList$member' => NULL, 'WirelessGatewayStatistics$Id' => '<p>The ID of the wireless gateway reporting the data.</p>', ], ], 'WirelessGatewayIdType' => [ 'base' => NULL, 'refs' => [ 'GetWirelessGatewayRequest$IdentifierType' => '<p>The type of identifier used in <code>identifier</code>.</p>', ], ], 'WirelessGatewayList' => [ 'base' => NULL, 'refs' => [ 'CreateNetworkAnalyzerConfigurationRequest$WirelessGateways' => '<p>Wireless gateway resources to add to the network analyzer configuration. Provide the <code>WirelessGatewayId</code> of the resource to add in the input array.</p>', 'GetNetworkAnalyzerConfigurationResponse$WirelessGateways' => '<p>List of wireless gateway resources that have been added to the network analyzer configuration.</p>', 'UpdateNetworkAnalyzerConfigurationRequest$WirelessGatewaysToAdd' => '<p>Wireless gateway resources to add to the network analyzer configuration. Provide the <code>WirelessGatewayId</code> of the resource to add in the input array.</p>', 'UpdateNetworkAnalyzerConfigurationRequest$WirelessGatewaysToRemove' => '<p>Wireless gateway resources to remove from the network analyzer configuration. Provide the <code>WirelessGatewayId</code> of the resources to remove in the input array.</p>', ], ], 'WirelessGatewayLogOption' => [ 'base' => '<p>The log options for wireless gateways and can be used to set log levels for a specific type of wireless gateway.</p>', 'refs' => [ 'WirelessGatewayLogOptionList$member' => NULL, ], ], 'WirelessGatewayLogOptionList' => [ 'base' => '<p>The list of wireless gateway log options.</p>', 'refs' => [ 'GetLogLevelsByResourceTypesResponse$WirelessGatewayLogOptions' => NULL, 'UpdateLogLevelsByResourceTypesRequest$WirelessGatewayLogOptions' => NULL, ], ], 'WirelessGatewayName' => [ 'base' => NULL, 'refs' => [ 'CreateWirelessGatewayRequest$Name' => '<p>The name of the new resource.</p>', 'GetWirelessGatewayResponse$Name' => '<p>The name of the resource.</p>', 'UpdateWirelessGatewayRequest$Name' => '<p>The new name of the resource.</p>', 'WirelessGatewayStatistics$Name' => '<p>The name of the resource.</p>', ], ], 'WirelessGatewayServiceType' => [ 'base' => NULL, 'refs' => [ 'GetServiceEndpointRequest$ServiceType' => '<p>The service type for which to get endpoint information about. Can be <code>CUPS</code> for the Configuration and Update Server endpoint, or <code>LNS</code> for the LoRaWAN Network Server endpoint or <code>CLAIM</code> for the global endpoint.</p>', 'GetServiceEndpointResponse$ServiceType' => '<p>The endpoint\'s service type.</p>', ], ], 'WirelessGatewayStatistics' => [ 'base' => '<p>Information about a wireless gateway\'s operation.</p>', 'refs' => [ 'WirelessGatewayStatisticsList$member' => NULL, ], ], 'WirelessGatewayStatisticsList' => [ 'base' => NULL, 'refs' => [ 'ListWirelessGatewaysResponse$WirelessGatewayList' => '<p>The ID of the wireless gateway.</p>', ], ], 'WirelessGatewayTaskDefinitionArn' => [ 'base' => NULL, 'refs' => [ 'CreateWirelessGatewayTaskDefinitionResponse$Arn' => '<p>The Amazon Resource Name of the resource.</p>', 'GetWirelessGatewayTaskDefinitionResponse$Arn' => '<p>The Amazon Resource Name of the resource.</p>', 'UpdateWirelessGatewayTaskEntry$Arn' => '<p>The Amazon Resource Name of the resource.</p>', ], ], 'WirelessGatewayTaskDefinitionId' => [ 'base' => NULL, 'refs' => [ 'CreateWirelessGatewayTaskDefinitionResponse$Id' => '<p>The ID of the new wireless gateway task definition.</p>', 'CreateWirelessGatewayTaskRequest$WirelessGatewayTaskDefinitionId' => '<p>The ID of the WirelessGatewayTaskDefinition.</p>', 'CreateWirelessGatewayTaskResponse$WirelessGatewayTaskDefinitionId' => '<p>The ID of the WirelessGatewayTaskDefinition.</p>', 'DeleteWirelessGatewayTaskDefinitionRequest$Id' => '<p>The ID of the resource to delete.</p>', 'GetWirelessGatewayTaskDefinitionRequest$Id' => '<p>The ID of the resource to get.</p>', 'GetWirelessGatewayTaskResponse$WirelessGatewayTaskDefinitionId' => '<p>The ID of the WirelessGatewayTask.</p>', 'UpdateWirelessGatewayTaskEntry$Id' => '<p>The ID of the new wireless gateway task entry.</p>', ], ], 'WirelessGatewayTaskDefinitionList' => [ 'base' => NULL, 'refs' => [ 'ListWirelessGatewayTaskDefinitionsResponse$TaskDefinitions' => '<p>The list of task definitions.</p>', ], ], 'WirelessGatewayTaskDefinitionType' => [ 'base' => NULL, 'refs' => [ 'ListWirelessGatewayTaskDefinitionsRequest$TaskDefinitionType' => '<p>A filter to list only the wireless gateway task definitions that use this task definition type.</p>', ], ], 'WirelessGatewayTaskName' => [ 'base' => NULL, 'refs' => [ 'CreateWirelessGatewayTaskDefinitionRequest$Name' => '<p>The name of the new resource.</p>', 'GetWirelessGatewayTaskDefinitionResponse$Name' => '<p>The name of the resource.</p>', ], ], 'WirelessGatewayTaskStatus' => [ 'base' => NULL, 'refs' => [ 'CreateWirelessGatewayTaskResponse$Status' => '<p>The status of the request.</p>', 'GetWirelessGatewayTaskResponse$Status' => '<p>The status of the request.</p>', ], ], 'WirelessGatewayType' => [ 'base' => '<p>The wireless gateway type.</p>', 'refs' => [ 'WirelessGatewayLogOption$Type' => NULL, ], ], 'WirelessMetadata' => [ 'base' => '<p>WirelessMetadata object.</p>', 'refs' => [ 'SendDataToWirelessDeviceRequest$WirelessMetadata' => '<p>Metadata about the message request.</p>', ], ], ],];
