<?php
// This file was auto-generated from sdk-root/src/data/ivs-realtime/2020-07-14/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>The Amazon Interactive Video Service (IVS) real-time API is REST compatible, using a standard HTTP API and an AWS EventBridge event stream for responses. JSON is used for both requests and responses, including errors. </p> <p> <b>Key Concepts</b> </p> <ul> <li> <p> <b>Stage</b> — A virtual space where participants can exchange video in real time.</p> </li> <li> <p> <b>Participant token</b> — A token that authenticates a participant when they join a stage.</p> </li> <li> <p> <b>Participant object</b> — Represents participants (people) in the stage and contains information about them. When a token is created, it includes a participant ID; when a participant uses that token to join a stage, the participant is associated with that participant ID. There is a 1:1 mapping between participant tokens and participants.</p> </li> </ul> <p>For server-side composition:</p> <ul> <li> <p> <b>Composition process</b> — Composites participants of a stage into a single video and forwards it to a set of outputs (e.g., IVS channels). Composition endpoints support this process.</p> </li> <li> <p> <b>Composition</b> — Controls the look of the outputs, including how participants are positioned in the video.</p> </li> </ul> <p>For more information about your IVS live stream, also see <a href="https://docs.aws.amazon.com/ivs/latest/RealTimeUserGuide/getting-started.html">Getting Started with Amazon IVS Real-Time Streaming</a>.</p> <p> <b>Tagging</b> </p> <p>A <i>tag</i> is a metadata label that you assign to an AWS resource. A tag comprises a <i>key</i> and a <i>value</i>, both set by you. For example, you might set a tag as <code>topic:nature</code> to label a particular video category. See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> for more information, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS stages has no service-specific constraints beyond what is documented there.</p> <p>Tags can help you identify and organize your AWS resources. For example, you can use the same tag for different resources to indicate that they are related. You can also use tags to manage access (see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Access Tags</a>).</p> <p>The Amazon IVS real-time API has these tag-related endpoints: <a>TagResource</a>, <a>UntagResource</a>, and <a>ListTagsForResource</a>. The following resource supports tagging: Stage.</p> <p>At most 50 tags can be applied to a resource.</p>', 'operations' => [ 'CreateEncoderConfiguration' => '<p>Creates an EncoderConfiguration object.</p>', 'CreateParticipantToken' => '<p>Creates an additional token for a specified stage. This can be done after stage creation or when tokens expire. Tokens always are scoped to the stage for which they are created.</p> <p>Encryption keys are owned by Amazon IVS and never used directly by your application.</p>', 'CreateStage' => '<p>Creates a new stage (and optionally participant tokens).</p>', 'CreateStorageConfiguration' => '<p>Creates a new storage configuration, used to enable recording to Amazon S3. When a StorageConfiguration is created, IVS will modify the S3 bucketPolicy of the provided bucket. This will ensure that IVS has sufficient permissions to write content to the provided bucket.</p>', 'DeleteEncoderConfiguration' => '<p>Deletes an EncoderConfiguration resource. Ensures that no Compositions are using this template; otherwise, returns an error.</p>', 'DeletePublicKey' => '<p>Deletes the specified public key used to sign stage participant tokens. This invalidates future participant tokens generated using the key pair’s private key. </p>', 'DeleteStage' => '<p>Shuts down and deletes the specified stage (disconnecting all participants).</p>', 'DeleteStorageConfiguration' => '<p>Deletes the storage configuration for the specified ARN.</p> <p>If you try to delete a storage configuration that is used by a Composition, you will get an error (409 ConflictException). To avoid this, for all Compositions that reference the storage configuration, first use <a>StopComposition</a> and wait for it to complete, then use DeleteStorageConfiguration.</p>', 'DisconnectParticipant' => '<p>Disconnects a specified participant and revokes the participant permanently from a specified stage.</p>', 'GetComposition' => '<p>Get information about the specified Composition resource.</p>', 'GetEncoderConfiguration' => '<p>Gets information about the specified EncoderConfiguration resource. </p>', 'GetParticipant' => '<p>Gets information about the specified participant token.</p>', 'GetPublicKey' => '<p>Gets information for the specified public key.</p>', 'GetStage' => '<p>Gets information for the specified stage.</p>', 'GetStageSession' => '<p>Gets information for the specified stage session.</p>', 'GetStorageConfiguration' => '<p>Gets the storage configuration for the specified ARN.</p>', 'ImportPublicKey' => '<p>Import a public key to be used for signing stage participant tokens.</p>', 'ListCompositions' => '<p>Gets summary information about all Compositions in your account, in the AWS region where the API request is processed. </p>', 'ListEncoderConfigurations' => '<p>Gets summary information about all EncoderConfigurations in your account, in the AWS region where the API request is processed.</p>', 'ListParticipantEvents' => '<p>Lists events for a specified participant that occurred during a specified stage session.</p>', 'ListParticipants' => '<p>Lists all participants in a specified stage session.</p>', 'ListPublicKeys' => '<p>Gets summary information about all public keys in your account, in the AWS region where the API request is processed.</p>', 'ListStageSessions' => '<p>Gets all sessions for a specified stage.</p>', 'ListStages' => '<p>Gets summary information about all stages in your account, in the AWS region where the API request is processed.</p>', 'ListStorageConfigurations' => '<p>Gets summary information about all storage configurations in your account, in the AWS region where the API request is processed.</p>', 'ListTagsForResource' => '<p>Gets information about AWS tags for the specified ARN.</p>', 'StartComposition' => '<p>Starts a Composition from a stage based on the configuration provided in the request.</p> <p>A Composition is an ephemeral resource that exists after this endpoint returns successfully. Composition stops and the resource is deleted:</p> <ul> <li> <p>When <a>StopComposition</a> is called.</p> </li> <li> <p>After a 1-minute timeout, when all participants are disconnected from the stage.</p> </li> <li> <p>After a 1-minute timeout, if there are no participants in the stage when StartComposition is called.</p> </li> <li> <p>When broadcasting to the IVS channel fails and all retries are exhausted.</p> </li> <li> <p>When broadcasting is disconnected and all attempts to reconnect are exhausted.</p> </li> </ul>', 'StopComposition' => '<p>Stops and deletes a Composition resource. Any broadcast from the Composition resource is stopped.</p>', 'TagResource' => '<p>Adds or updates tags for the AWS resource with the specified ARN.</p>', 'UntagResource' => '<p>Removes tags from the resource with the specified ARN.</p>', 'UpdateStage' => '<p>Updates a stage’s configuration.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p/>', 'refs' => [], ], 'AttributeKey' => [ 'base' => NULL, 'refs' => [ 'GridConfiguration$featuredParticipantAttribute' => '<p>This attribute name identifies the featured slot. A participant with this attribute set to <code>"true"</code> (as a string value) in <a>ParticipantTokenConfiguration</a> is placed in the featured slot. Default: <code>""</code> (no featured participant).</p>', 'PipConfiguration$featuredParticipantAttribute' => '<p>This attribute name identifies the featured slot. A participant with this attribute set to <code>"true"</code> (as a string value) in <a>ParticipantTokenConfiguration</a> is placed in the featured slot. Default: <code>""</code> (no featured participant).</p>', 'PipConfiguration$pipParticipantAttribute' => '<p>Specifies the participant for the PiP window. A participant with this attribute set to <code>"true"</code> (as a string value) in <a>ParticipantTokenConfiguration</a> is placed in the PiP slot. Default: <code>""</code> (no PiP participant).</p>', ], ], 'AutoParticipantRecordingConfiguration' => [ 'base' => '<p>Object specifying a configuration for individual participant recording.</p>', 'refs' => [ 'CreateStageRequest$autoParticipantRecordingConfiguration' => '<p>Configuration object for individual participant recording, to attach to the new stage.</p>', 'Stage$autoParticipantRecordingConfiguration' => '<p>Configuration object for individual participant recording, attached to the stage.</p>', 'UpdateStageRequest$autoParticipantRecordingConfiguration' => '<p>Configuration object for individual participant recording, to attach to the stage. Note that this cannot be updated while recording is active.</p>', ], ], 'AutoParticipantRecordingStorageConfigurationArn' => [ 'base' => NULL, 'refs' => [ 'AutoParticipantRecordingConfiguration$storageConfigurationArn' => '<p>ARN of the <a>StorageConfiguration</a> resource to use for individual participant recording. Default: <code>""</code> (empty string, no storage configuration is specified). Individual participant recording cannot be started unless a storage configuration is specified, when a <a>Stage</a> is created or updated.</p>', ], ], 'Bitrate' => [ 'base' => NULL, 'refs' => [ 'Video$bitrate' => '<p>Bitrate for generated output, in bps. Default: 2500000.</p>', ], ], 'ChannelArn' => [ 'base' => NULL, 'refs' => [ 'ChannelDestinationConfiguration$channelArn' => '<p>ARN of the channel to use for broadcasting. The channel and stage resources must be in the same AWS account and region. The channel must be offline (not broadcasting).</p>', ], ], 'ChannelDestinationConfiguration' => [ 'base' => '<p>Object specifying a channel as a destination.</p>', 'refs' => [ 'DestinationConfiguration$channel' => '<p>An IVS channel to be used for broadcasting, for server-side composition. Either a <code>channel</code> or an <code>s3</code> must be specified. </p>', ], ], 'Composition' => [ 'base' => '<p>Object specifying a Composition resource.</p>', 'refs' => [ 'GetCompositionResponse$composition' => '<p>The Composition that was returned.</p>', 'StartCompositionResponse$composition' => '<p>The Composition that was created.</p>', ], ], 'CompositionArn' => [ 'base' => NULL, 'refs' => [ 'Composition$arn' => '<p>ARN of the Composition resource.</p>', 'CompositionSummary$arn' => '<p>ARN of the Composition resource.</p>', 'GetCompositionRequest$arn' => '<p>ARN of the Composition resource.</p>', 'StopCompositionRequest$arn' => '<p>ARN of the Composition.</p>', ], ], 'CompositionClientToken' => [ 'base' => NULL, 'refs' => [ 'StartCompositionRequest$idempotencyToken' => '<p>Idempotency token.</p>', ], ], 'CompositionState' => [ 'base' => NULL, 'refs' => [ 'Composition$state' => '<p>State of the Composition.</p>', 'CompositionSummary$state' => '<p>State of the Composition resource.</p>', ], ], 'CompositionSummary' => [ 'base' => '<p>Summary information about a Composition.</p>', 'refs' => [ 'CompositionSummaryList$member' => NULL, ], ], 'CompositionSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListCompositionsResponse$compositions' => '<p>List of the matching Compositions (summary information only).</p>', ], ], 'ConflictException' => [ 'base' => '<p/>', 'refs' => [], ], 'CreateEncoderConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateEncoderConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateParticipantTokenRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateParticipantTokenResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateStageRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateStageResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateStorageConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateStorageConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEncoderConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEncoderConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeletePublicKeyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePublicKeyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStageRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStageResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStorageConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStorageConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'Destination' => [ 'base' => '<p>Object specifying the status of a Destination.</p>', 'refs' => [ 'DestinationList$member' => NULL, ], ], 'DestinationConfiguration' => [ 'base' => '<p>Complex data type that defines destination-configuration objects.</p>', 'refs' => [ 'Destination$configuration' => '<p>Configuration used to create this destination.</p>', 'DestinationConfigurationList$member' => NULL, ], ], 'DestinationConfigurationList' => [ 'base' => NULL, 'refs' => [ 'StartCompositionRequest$destinations' => '<p>Array of destination configuration.</p>', ], ], 'DestinationConfigurationName' => [ 'base' => NULL, 'refs' => [ 'DestinationConfiguration$name' => '<p>Name that can be specified to help identify the destination.</p>', ], ], 'DestinationDetail' => [ 'base' => '<p>Complex data type that defines destination-detail objects.</p>', 'refs' => [ 'Destination$detail' => '<p>Optional details regarding the status of the destination.</p>', ], ], 'DestinationList' => [ 'base' => NULL, 'refs' => [ 'Composition$destinations' => '<p>Array of Destination objects. A Composition can contain either one destination (<code>channel</code> or <code>s3</code>) or two (one <code>channel</code> and one <code>s3</code>).</p>', ], ], 'DestinationState' => [ 'base' => NULL, 'refs' => [ 'Destination$state' => '<p>State of the Composition Destination.</p>', 'DestinationSummary$state' => '<p>State of the Composition Destination.</p>', ], ], 'DestinationSummary' => [ 'base' => '<p>Summary information about a Destination.</p>', 'refs' => [ 'DestinationSummaryList$member' => NULL, ], ], 'DestinationSummaryList' => [ 'base' => NULL, 'refs' => [ 'CompositionSummary$destinations' => '<p>Array of Destination objects.</p>', ], ], 'DisconnectParticipantReason' => [ 'base' => NULL, 'refs' => [ 'DisconnectParticipantRequest$reason' => '<p>Description of why this participant is being disconnected.</p>', ], ], 'DisconnectParticipantRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisconnectParticipantResponse' => [ 'base' => NULL, 'refs' => [], ], 'EncoderConfiguration' => [ 'base' => '<p>Settings for transcoding.</p>', 'refs' => [ 'CreateEncoderConfigurationResponse$encoderConfiguration' => '<p>The EncoderConfiguration that was created.</p>', 'GetEncoderConfigurationResponse$encoderConfiguration' => '<p>The EncoderConfiguration that was returned.</p>', ], ], 'EncoderConfigurationArn' => [ 'base' => NULL, 'refs' => [ 'ChannelDestinationConfiguration$encoderConfigurationArn' => '<p>ARN of the <a>EncoderConfiguration</a> resource. The encoder configuration and stage resources must be in the same AWS account and region.</p>', 'DeleteEncoderConfigurationRequest$arn' => '<p>ARN of the EncoderConfiguration.</p>', 'EncoderConfiguration$arn' => '<p>ARN of the EncoderConfiguration resource.</p>', 'EncoderConfigurationArnList$member' => NULL, 'EncoderConfigurationSummary$arn' => '<p>ARN of the EncoderConfiguration resource.</p>', 'GetEncoderConfigurationRequest$arn' => '<p>ARN of the EncoderConfiguration resource.</p>', 'ListCompositionsRequest$filterByEncoderConfigurationArn' => '<p>Filters the Composition list to match the specified EncoderConfiguration attached to at least one of its output.</p>', ], ], 'EncoderConfigurationArnList' => [ 'base' => NULL, 'refs' => [ 'S3DestinationConfiguration$encoderConfigurationArns' => '<p>ARNs of the <a>EncoderConfiguration</a> resource. The encoder configuration and stage resources must be in the same AWS account and region. </p>', ], ], 'EncoderConfigurationName' => [ 'base' => NULL, 'refs' => [ 'CreateEncoderConfigurationRequest$name' => '<p>Optional name to identify the resource.</p>', 'EncoderConfiguration$name' => '<p>Optional name to identify the resource.</p>', 'EncoderConfigurationSummary$name' => '<p>Optional name to identify the resource.</p>', ], ], 'EncoderConfigurationSummary' => [ 'base' => '<p>Summary information about an EncoderConfiguration.</p>', 'refs' => [ 'EncoderConfigurationSummaryList$member' => NULL, ], ], 'EncoderConfigurationSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListEncoderConfigurationsResponse$encoderConfigurations' => '<p>List of the matching EncoderConfigurations (summary information only).</p>', ], ], 'Event' => [ 'base' => '<p>An occurrence during a stage session.</p>', 'refs' => [ 'EventList$member' => NULL, ], ], 'EventErrorCode' => [ 'base' => NULL, 'refs' => [ 'Event$errorCode' => '<p>If the event is an error event, the error code is provided to give insight into the specific error that occurred. If the event is not an error event, this field is null. <code>INSUFFICIENT_CAPABILITIES</code> indicates that the participant tried to take an action that the participant’s token is not allowed to do. For more information about participant capabilities, see the <code>capabilities</code> field in <a>CreateParticipantToken</a>. <code>QUOTA_EXCEEDED</code> indicates that the number of participants who want to publish/subscribe to a stage exceeds the quota; for more information, see <a href="https://docs.aws.amazon.com/ivs/latest/RealTimeUserGuide/service-quotas.html">Service Quotas</a>. <code>PUBLISHER_NOT_FOUND</code> indicates that the participant tried to subscribe to a publisher that doesn’t exist. </p>', ], ], 'EventList' => [ 'base' => NULL, 'refs' => [ 'ListParticipantEventsResponse$events' => '<p>List of the matching events.</p>', ], ], 'EventName' => [ 'base' => NULL, 'refs' => [ 'Event$name' => '<p>The name of the event.</p>', ], ], 'Framerate' => [ 'base' => NULL, 'refs' => [ 'Video$framerate' => '<p>Video frame rate, in fps. Default: 30.</p>', ], ], 'GetCompositionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCompositionResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetEncoderConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetEncoderConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetParticipantRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetParticipantResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetPublicKeyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPublicKeyResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetStageRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetStageResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetStageSessionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetStageSessionResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetStorageConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetStorageConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GridConfiguration' => [ 'base' => '<p>Configuration information specific to Grid layout, for server-side composition. See "Layouts" in <a href="https://docs.aws.amazon.com/ivs/latest/RealTimeUserGuide/server-side-composition.html">Server-Side Composition</a>.</p>', 'refs' => [ 'LayoutConfiguration$grid' => '<p>Configuration related to grid layout. Default: Grid layout.</p>', ], ], 'GridGap' => [ 'base' => NULL, 'refs' => [ 'GridConfiguration$gridGap' => '<p>Specifies the spacing between participant tiles in pixels. Default: <code>2</code>.</p>', 'PipConfiguration$gridGap' => '<p>Specifies the spacing between participant tiles in pixels. Default: <code>0</code>.</p>', ], ], 'Height' => [ 'base' => NULL, 'refs' => [ 'Video$height' => '<p>Video-resolution height. Note that the maximum value is determined by <code>width</code> times <code>height</code>, such that the maximum total pixels is 2073600 (1920x1080 or 1080x1920). Default: 720.</p>', ], ], 'ImportPublicKeyRequest' => [ 'base' => NULL, 'refs' => [], ], 'ImportPublicKeyResponse' => [ 'base' => NULL, 'refs' => [], ], 'InternalServerException' => [ 'base' => '<p/>', 'refs' => [], ], 'LayoutConfiguration' => [ 'base' => '<p>Configuration information of supported layouts for server-side composition.</p>', 'refs' => [ 'Composition$layout' => '<p>Layout object to configure composition parameters.</p>', 'StartCompositionRequest$layout' => '<p>Layout object to configure composition parameters.</p>', ], ], 'ListCompositionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCompositionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListEncoderConfigurationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListEncoderConfigurationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListParticipantEventsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListParticipantEventsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListParticipantsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListParticipantsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPublicKeysRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPublicKeysResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListStageSessionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListStageSessionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListStagesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListStagesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListStorageConfigurationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListStorageConfigurationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'MaxCompositionResults' => [ 'base' => NULL, 'refs' => [ 'ListCompositionsRequest$maxResults' => '<p>Maximum number of results to return. Default: 100.</p>', ], ], 'MaxEncoderConfigurationResults' => [ 'base' => NULL, 'refs' => [ 'ListEncoderConfigurationsRequest$maxResults' => '<p>Maximum number of results to return. Default: 100.</p>', ], ], 'MaxParticipantEventResults' => [ 'base' => NULL, 'refs' => [ 'ListParticipantEventsRequest$maxResults' => '<p>Maximum number of results to return. Default: 50.</p>', ], ], 'MaxParticipantResults' => [ 'base' => NULL, 'refs' => [ 'ListParticipantsRequest$maxResults' => '<p>Maximum number of results to return. Default: 50.</p>', ], ], 'MaxPublicKeyResults' => [ 'base' => NULL, 'refs' => [ 'ListPublicKeysRequest$maxResults' => '<p>Maximum number of results to return. Default: 50.</p>', ], ], 'MaxStageResults' => [ 'base' => NULL, 'refs' => [ 'ListStagesRequest$maxResults' => '<p>Maximum number of results to return. Default: 50.</p>', ], ], 'MaxStageSessionResults' => [ 'base' => NULL, 'refs' => [ 'ListStageSessionsRequest$maxResults' => '<p>Maximum number of results to return. Default: 50.</p>', ], ], 'MaxStorageConfigurationResults' => [ 'base' => NULL, 'refs' => [ 'ListStorageConfigurationsRequest$maxResults' => '<p>Maximum number of storage configurations to return. Default: your service quota or 100, whichever is smaller.</p>', ], ], 'OmitStoppedVideo' => [ 'base' => NULL, 'refs' => [ 'GridConfiguration$omitStoppedVideo' => '<p>Determines whether to omit participants with stopped video in the composition. Default: <code>false</code>.</p>', 'PipConfiguration$omitStoppedVideo' => '<p>Determines whether to omit participants with stopped video in the composition. Default: <code>false</code>.</p>', ], ], 'PaginationToken' => [ 'base' => NULL, 'refs' => [ 'ListCompositionsRequest$nextToken' => '<p>The first Composition to retrieve. This is used for pagination; see the <code>nextToken</code> response field.</p>', 'ListCompositionsResponse$nextToken' => '<p>If there are more compositions than <code>maxResults</code>, use <code>nextToken</code> in the request to get the next set.</p>', 'ListEncoderConfigurationsRequest$nextToken' => '<p>The first encoder configuration to retrieve. This is used for pagination; see the <code>nextToken</code> response field.</p>', 'ListEncoderConfigurationsResponse$nextToken' => '<p>If there are more encoder configurations than <code>maxResults</code>, use <code>nextToken</code> in the request to get the next set.</p>', 'ListParticipantEventsRequest$nextToken' => '<p>The first participant event to retrieve. This is used for pagination; see the <code>nextToken</code> response field.</p>', 'ListParticipantEventsResponse$nextToken' => '<p>If there are more events than <code>maxResults</code>, use <code>nextToken</code> in the request to get the next set. </p>', 'ListParticipantsRequest$nextToken' => '<p>The first participant to retrieve. This is used for pagination; see the <code>nextToken</code> response field.</p>', 'ListParticipantsResponse$nextToken' => '<p>If there are more participants than <code>maxResults</code>, use <code>nextToken</code> in the request to get the next set.</p>', 'ListPublicKeysRequest$nextToken' => '<p>The first public key to retrieve. This is used for pagination; see the <code>nextToken</code> response field.</p>', 'ListPublicKeysResponse$nextToken' => '<p>If there are more public keys than <code>maxResults</code>, use <code>nextToken</code> in the request to get the next set.</p>', 'ListStageSessionsRequest$nextToken' => '<p>The first stage session to retrieve. This is used for pagination; see the <code>nextToken</code> response field.</p>', 'ListStageSessionsResponse$nextToken' => '<p>If there are more stage sessions than <code>maxResults</code>, use <code>nextToken</code> in the request to get the next set.</p>', 'ListStagesRequest$nextToken' => '<p>The first stage to retrieve. This is used for pagination; see the <code>nextToken</code> response field.</p>', 'ListStagesResponse$nextToken' => '<p>If there are more stages than <code>maxResults</code>, use <code>nextToken</code> in the request to get the next set.</p>', 'ListStorageConfigurationsRequest$nextToken' => '<p>The first storage configuration to retrieve. This is used for pagination; see the <code>nextToken</code> response field.</p>', 'ListStorageConfigurationsResponse$nextToken' => '<p>If there are more storage configurations than <code>maxResults</code>, use <code>nextToken</code> in the request to get the next set.</p>', ], ], 'Participant' => [ 'base' => '<p>Object describing a participant that has joined a stage.</p>', 'refs' => [ 'GetParticipantResponse$participant' => '<p>The participant that is returned.</p>', ], ], 'ParticipantAttributes' => [ 'base' => NULL, 'refs' => [ 'Participant$attributes' => '<p>Application-provided attributes to encode into the token and attach to a stage. Map keys and values can contain UTF-8 encoded text. The maximum length of this field is 1 KB total. <i>This field is exposed to all stage participants and should not be used for personally identifying, confidential, or sensitive information</i>.</p>', ], ], 'ParticipantClientAttribute' => [ 'base' => NULL, 'refs' => [ 'Participant$ispName' => '<p>The participant’s Internet Service Provider.</p>', 'Participant$osName' => '<p>The participant’s operating system.</p>', 'Participant$osVersion' => '<p>The participant’s operating system version.</p>', 'Participant$browserName' => '<p>The participant’s browser.</p>', 'Participant$browserVersion' => '<p>The participant’s browser version.</p>', 'Participant$sdkVersion' => '<p>The participant’s SDK version.</p>', ], ], 'ParticipantId' => [ 'base' => NULL, 'refs' => [ 'Event$participantId' => '<p>Unique identifier for the participant who triggered the event. This is assigned by IVS.</p>', 'Event$remoteParticipantId' => '<p>Unique identifier for the remote participant. For a subscribe event, this is the publisher. For a publish or join event, this is null. This is assigned by IVS.</p>', 'GetParticipantRequest$participantId' => '<p>Unique identifier for the participant. This is assigned by IVS and returned by <a>CreateParticipantToken</a>.</p>', 'ListParticipantEventsRequest$participantId' => '<p>Unique identifier for this participant. This is assigned by IVS and returned by <a>CreateParticipantToken</a>.</p>', 'Participant$participantId' => '<p>Unique identifier for this participant, assigned by IVS.</p>', 'ParticipantSummary$participantId' => '<p>Unique identifier for this participant, assigned by IVS.</p>', ], ], 'ParticipantList' => [ 'base' => NULL, 'refs' => [ 'ListParticipantsResponse$participants' => '<p>List of the matching participants (summary information only).</p>', ], ], 'ParticipantRecordingFilterByRecordingState' => [ 'base' => NULL, 'refs' => [ 'ListParticipantsRequest$filterByRecordingState' => '<p>Filters the response list to only show participants with the specified recording state. Only one of <code>filterByUserId</code>, <code>filterByPublished</code>, <code>filterByState</code>, or <code>filterByRecordingState</code> can be provided per request.</p>', ], ], 'ParticipantRecordingMediaType' => [ 'base' => NULL, 'refs' => [ 'ParticipantRecordingMediaTypeList$member' => NULL, ], ], 'ParticipantRecordingMediaTypeList' => [ 'base' => NULL, 'refs' => [ 'AutoParticipantRecordingConfiguration$mediaTypes' => '<p>Types of media to be recorded. Default: <code>AUDIO_VIDEO</code>.</p>', ], ], 'ParticipantRecordingS3BucketName' => [ 'base' => NULL, 'refs' => [ 'Participant$recordingS3BucketName' => '<p>Name of the S3 bucket to where the participant is being recorded, if individual participant recording is enabled, or <code>""</code> (empty string), if recording is not enabled.</p>', ], ], 'ParticipantRecordingS3Prefix' => [ 'base' => NULL, 'refs' => [ 'Participant$recordingS3Prefix' => '<p>S3 prefix of the S3 bucket where the participant is being recorded, if individual participant recording is enabled, or <code>""</code> (empty string), if recording is not enabled.</p>', ], ], 'ParticipantRecordingState' => [ 'base' => NULL, 'refs' => [ 'Participant$recordingState' => '<p>The participant’s recording state.</p>', 'ParticipantSummary$recordingState' => '<p>The participant’s recording state.</p>', ], ], 'ParticipantState' => [ 'base' => NULL, 'refs' => [ 'ListParticipantsRequest$filterByState' => '<p>Filters the response list to only show participants in the specified state. Only one of <code>filterByUserId</code>, <code>filterByPublished</code>, <code>filterByState</code>, or <code>filterByRecordingState</code> can be provided per request.</p>', 'Participant$state' => '<p>Whether the participant is connected to or disconnected from the stage.</p>', 'ParticipantSummary$state' => '<p>Whether the participant is connected to or disconnected from the stage.</p>', ], ], 'ParticipantSummary' => [ 'base' => '<p>Summary object describing a participant that has joined a stage.</p>', 'refs' => [ 'ParticipantList$member' => NULL, ], ], 'ParticipantToken' => [ 'base' => '<p>Object specifying a participant token in a stage.</p> <p> <b>Important</b>: Treat tokens as opaque; i.e., do not build functionality based on token contents. The format of tokens could change in the future.</p>', 'refs' => [ 'CreateParticipantTokenResponse$participantToken' => '<p>The participant token that was created.</p>', 'ParticipantTokenList$member' => NULL, ], ], 'ParticipantTokenAttributes' => [ 'base' => NULL, 'refs' => [ 'CreateParticipantTokenRequest$attributes' => '<p>Application-provided attributes to encode into the token and attach to a stage. Map keys and values can contain UTF-8 encoded text. The maximum length of this field is 1 KB total. <i>This field is exposed to all stage participants and should not be used for personally identifying, confidential, or sensitive information.</i> </p>', 'ParticipantToken$attributes' => '<p>Application-provided attributes to encode into the token and attach to a stage. <i>This field is exposed to all stage participants and should not be used for personally identifying, confidential, or sensitive information.</i> </p>', 'ParticipantTokenConfiguration$attributes' => '<p>Application-provided attributes to encode into the corresponding participant token and attach to a stage. Map keys and values can contain UTF-8 encoded text. The maximum length of this field is 1 KB total. <i>This field is exposed to all stage participants and should not be used for personally identifying, confidential, or sensitive information.</i> </p>', ], ], 'ParticipantTokenCapabilities' => [ 'base' => NULL, 'refs' => [ 'CreateParticipantTokenRequest$capabilities' => '<p>Set of capabilities that the user is allowed to perform in the stage. Default: <code>PUBLISH, SUBSCRIBE</code>.</p>', 'ParticipantToken$capabilities' => '<p>Set of capabilities that the user is allowed to perform in the stage.</p>', 'ParticipantTokenConfiguration$capabilities' => '<p>Set of capabilities that the user is allowed to perform in the stage.</p>', ], ], 'ParticipantTokenCapability' => [ 'base' => NULL, 'refs' => [ 'ParticipantTokenCapabilities$member' => NULL, ], ], 'ParticipantTokenConfiguration' => [ 'base' => '<p>Object specifying a participant token configuration in a stage.</p>', 'refs' => [ 'ParticipantTokenConfigurations$member' => NULL, ], ], 'ParticipantTokenConfigurations' => [ 'base' => NULL, 'refs' => [ 'CreateStageRequest$participantTokenConfigurations' => '<p>Array of participant token configuration objects to attach to the new stage.</p>', ], ], 'ParticipantTokenDurationMinutes' => [ 'base' => NULL, 'refs' => [ 'CreateParticipantTokenRequest$duration' => '<p>Duration (in minutes), after which the token expires. Default: 720 (12 hours).</p>', 'ParticipantToken$duration' => '<p>Duration (in minutes), after which the participant token expires. Default: 720 (12 hours).</p>', 'ParticipantTokenConfiguration$duration' => '<p>Duration (in minutes), after which the corresponding participant token expires. Default: 720 (12 hours).</p>', ], ], 'ParticipantTokenExpirationTime' => [ 'base' => NULL, 'refs' => [ 'ParticipantToken$expirationTime' => '<p>ISO 8601 timestamp (returned as a string) for when this token expires.</p>', ], ], 'ParticipantTokenId' => [ 'base' => NULL, 'refs' => [ 'DisconnectParticipantRequest$participantId' => '<p>Identifier of the participant to be disconnected. This is assigned by IVS and returned by <a>CreateParticipantToken</a>.</p>', 'ParticipantToken$participantId' => '<p>Unique identifier for this participant token, assigned by IVS.</p>', ], ], 'ParticipantTokenList' => [ 'base' => NULL, 'refs' => [ 'CreateStageResponse$participantTokens' => '<p>Participant tokens attached to the stage. These correspond to the <code>participants</code> in the request.</p>', ], ], 'ParticipantTokenString' => [ 'base' => NULL, 'refs' => [ 'ParticipantToken$token' => '<p>The issued client token, encrypted.</p>', ], ], 'ParticipantTokenUserId' => [ 'base' => NULL, 'refs' => [ 'CreateParticipantTokenRequest$userId' => '<p>Name that can be specified to help identify the token. This can be any UTF-8 encoded text. <i>This field is exposed to all stage participants and should not be used for personally identifying, confidential, or sensitive information.</i> </p>', 'ParticipantToken$userId' => '<p>Customer-assigned name to help identify the token; this can be used to link a participant to a user in the customer’s own systems. This can be any UTF-8 encoded text. <i>This field is exposed to all stage participants and should not be used for personally identifying, confidential, or sensitive information.</i> </p>', 'ParticipantTokenConfiguration$userId' => '<p>Customer-assigned name to help identify the token; this can be used to link a participant to a user in the customer’s own systems. This can be any UTF-8 encoded text. <i>This field is exposed to all stage participants and should not be used for personally identifying, confidential, or sensitive information.</i> </p>', ], ], 'PendingVerification' => [ 'base' => '<p/>', 'refs' => [], ], 'PipBehavior' => [ 'base' => NULL, 'refs' => [ 'PipConfiguration$pipBehavior' => '<p>Defines PiP behavior when all participants have left: <code>STATIC</code> (maintains original position/size) or <code>DYNAMIC</code> (expands to full composition). Default: <code>STATIC</code>.</p>', ], ], 'PipConfiguration' => [ 'base' => '<p>Configuration information specific to Picture-in-Picture (PiP) layout, for <a href="https://docs.aws.amazon.com/ivs/latest/RealTimeUserGuide/server-side-composition.html">server-side composition</a>. </p>', 'refs' => [ 'LayoutConfiguration$pip' => '<p>Configuration related to PiP layout.</p>', ], ], 'PipHeight' => [ 'base' => NULL, 'refs' => [ 'PipConfiguration$pipHeight' => '<p>Specifies the height of the PiP window in pixels. When this is not set explicitly, <code>pipHeight</code>’s value will be based on the size of the composition and the aspect ratio of the participant’s video.</p>', ], ], 'PipOffset' => [ 'base' => NULL, 'refs' => [ 'PipConfiguration$pipOffset' => '<p>Sets the PiP window’s offset position in pixels from the closest edges determined by <code>PipPosition</code>. Default: <code>0</code>.</p>', ], ], 'PipPosition' => [ 'base' => NULL, 'refs' => [ 'PipConfiguration$pipPosition' => '<p>Determines the corner position of the PiP window. Default: <code>BOTTOM_RIGHT</code>.</p>', ], ], 'PipWidth' => [ 'base' => NULL, 'refs' => [ 'PipConfiguration$pipWidth' => '<p>Specifies the width of the PiP window in pixels. When this is not set explicitly, <code>pipWidth</code>’s value will be based on the size of the composition and the aspect ratio of the participant’s video.</p>', ], ], 'PublicKey' => [ 'base' => '<p>Object specifying a public key used to sign stage participant tokens.</p>', 'refs' => [ 'GetPublicKeyResponse$publicKey' => '<p>The public key that is returned.</p>', 'ImportPublicKeyResponse$publicKey' => '<p>The public key that was imported.</p>', ], ], 'PublicKeyArn' => [ 'base' => NULL, 'refs' => [ 'DeletePublicKeyRequest$arn' => '<p>ARN of the public key to be deleted.</p>', 'GetPublicKeyRequest$arn' => '<p>ARN of the public key for which the information is to be retrieved.</p>', 'PublicKey$arn' => '<p>Public key ARN.</p>', 'PublicKeySummary$arn' => '<p>Public key ARN.</p>', ], ], 'PublicKeyFingerprint' => [ 'base' => NULL, 'refs' => [ 'PublicKey$fingerprint' => '<p>The public key fingerprint, a short string used to identify or verify the full public key.</p>', ], ], 'PublicKeyList' => [ 'base' => NULL, 'refs' => [ 'ListPublicKeysResponse$publicKeys' => '<p>List of the matching public keys (summary information only).</p>', ], ], 'PublicKeyMaterial' => [ 'base' => NULL, 'refs' => [ 'ImportPublicKeyRequest$publicKeyMaterial' => '<p>The content of the public key to be imported.</p>', 'PublicKey$publicKeyMaterial' => '<p>Public key material.</p>', ], ], 'PublicKeyName' => [ 'base' => NULL, 'refs' => [ 'ImportPublicKeyRequest$name' => '<p>Name of the public key to be imported.</p>', 'PublicKey$name' => '<p>Public key name.</p>', 'PublicKeySummary$name' => '<p>Public key name.</p>', ], ], 'PublicKeySummary' => [ 'base' => '<p>Summary information about a public key.</p>', 'refs' => [ 'PublicKeyList$member' => NULL, ], ], 'Published' => [ 'base' => NULL, 'refs' => [ 'ListParticipantsRequest$filterByPublished' => '<p>Filters the response list to only show participants who published during the stage session. Only one of <code>filterByUserId</code>, <code>filterByPublished</code>, <code>filterByState</code>, or <code>filterByRecordingState</code> can be provided per request.</p>', 'Participant$published' => '<p>Whether the participant ever published to the stage session.</p>', 'ParticipantSummary$published' => '<p>Whether the participant ever published to the stage session.</p>', ], ], 'RecordingConfiguration' => [ 'base' => '<p>An object representing a configuration to record a stage stream.</p>', 'refs' => [ 'S3DestinationConfiguration$recordingConfiguration' => '<p>Array of maps, each of the form <code>string:string (key:value)</code>. This is an optional customer specification, currently used only to specify the recording format for storing a recording in Amazon S3.</p>', ], ], 'RecordingConfigurationFormat' => [ 'base' => NULL, 'refs' => [ 'RecordingConfiguration$format' => '<p>The recording format for storing a recording in Amazon S3.</p>', ], ], 'ResourceArn' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$resourceArn' => '<p>The ARN of the resource to be retrieved. The ARN must be URL-encoded.</p>', 'TagResourceRequest$resourceArn' => '<p>The ARN of the resource to be tagged. The ARN must be URL-encoded.</p>', 'UntagResourceRequest$resourceArn' => '<p>The ARN of the resource to be untagged. The ARN must be URL-encoded.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p/>', 'refs' => [], ], 'S3BucketName' => [ 'base' => NULL, 'refs' => [ 'S3StorageConfiguration$bucketName' => '<p>Location (S3 bucket name) where recorded videos will be stored. Note that the StorageConfiguration and S3 bucket must be in the same region as the Composition.</p>', ], ], 'S3DestinationConfiguration' => [ 'base' => '<p>A complex type that describes an S3 location where recorded videos will be stored.</p>', 'refs' => [ 'DestinationConfiguration$s3' => '<p>An S3 storage configuration to be used for recording video data. Either a <code>channel</code> or an <code>s3</code> must be specified.</p>', ], ], 'S3Detail' => [ 'base' => '<p>Complex data type that defines S3Detail objects.</p>', 'refs' => [ 'DestinationDetail$s3' => '<p>An S3 detail object to return information about the S3 destination.</p>', ], ], 'S3StorageConfiguration' => [ 'base' => '<p>A complex type that describes an S3 location where recorded videos will be stored.</p>', 'refs' => [ 'CreateStorageConfigurationRequest$s3' => '<p>A complex type that contains a storage configuration for where recorded video will be stored.</p>', 'StorageConfiguration$s3' => '<p>An S3 destination configuration where recorded videos will be stored.</p>', 'StorageConfigurationSummary$s3' => '<p>An S3 destination configuration where recorded videos will be stored.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p/>', 'refs' => [], ], 'Stage' => [ 'base' => '<p>Object specifying a stage.</p>', 'refs' => [ 'CreateStageResponse$stage' => '<p>The stage that was created.</p>', 'GetStageResponse$stage' => '<p>The stage that is returned.</p>', 'UpdateStageResponse$stage' => '<p>The updated stage.</p>', ], ], 'StageArn' => [ 'base' => NULL, 'refs' => [ 'Composition$stageArn' => '<p>ARN of the stage used as input</p>', 'CompositionSummary$stageArn' => '<p>ARN of the attached stage.</p>', 'CreateParticipantTokenRequest$stageArn' => '<p>ARN of the stage to which this token is scoped.</p>', 'DeleteStageRequest$arn' => '<p>ARN of the stage to be deleted.</p>', 'DisconnectParticipantRequest$stageArn' => '<p>ARN of the stage to which the participant is attached.</p>', 'GetParticipantRequest$stageArn' => '<p>Stage ARN.</p>', 'GetStageRequest$arn' => '<p>ARN of the stage for which the information is to be retrieved.</p>', 'GetStageSessionRequest$stageArn' => '<p>ARN of the stage for which the information is to be retrieved.</p>', 'ListCompositionsRequest$filterByStageArn' => '<p>Filters the Composition list to match the specified Stage ARN.</p>', 'ListParticipantEventsRequest$stageArn' => '<p>Stage ARN.</p>', 'ListParticipantsRequest$stageArn' => '<p>Stage ARN.</p>', 'ListStageSessionsRequest$stageArn' => '<p>Stage ARN.</p>', 'Stage$arn' => '<p>Stage ARN.</p>', 'StageSummary$arn' => '<p>Stage ARN.</p>', 'StartCompositionRequest$stageArn' => '<p>ARN of the stage to be used for compositing.</p>', 'UpdateStageRequest$arn' => '<p>ARN of the stage to be updated.</p>', ], ], 'StageEndpoint' => [ 'base' => NULL, 'refs' => [ 'StageEndpoints$events' => '<p>Events endpoint.</p>', 'StageEndpoints$whip' => '<p>WHIP endpoint.</p>', ], ], 'StageEndpoints' => [ 'base' => '<p>Summary information about various endpoints for a stage.</p>', 'refs' => [ 'Stage$endpoints' => '<p>Summary information about various endpoints for a stage.</p>', ], ], 'StageName' => [ 'base' => NULL, 'refs' => [ 'CreateStageRequest$name' => '<p>Optional name that can be specified for the stage being created.</p>', 'Stage$name' => '<p>Stage name.</p>', 'StageSummary$name' => '<p>Stage name.</p>', 'UpdateStageRequest$name' => '<p>Name of the stage to be updated.</p>', ], ], 'StageSession' => [ 'base' => '<p>A stage session begins when the first participant joins a stage and ends after the last participant leaves the stage. A stage session helps with debugging stages by grouping events and participants into shorter periods of time (i.e., a session), which is helpful when stages are used over long periods of time.</p>', 'refs' => [ 'GetStageSessionResponse$stageSession' => '<p>The stage session that is returned.</p>', ], ], 'StageSessionId' => [ 'base' => NULL, 'refs' => [ 'GetParticipantRequest$sessionId' => '<p>ID of a session within the stage.</p>', 'GetStageSessionRequest$sessionId' => '<p>ID of a session within the stage.</p>', 'ListParticipantEventsRequest$sessionId' => '<p>ID of a session within the stage.</p>', 'ListParticipantsRequest$sessionId' => '<p>ID of the session within the stage.</p>', 'Stage$activeSessionId' => '<p>ID of the active session within the stage.</p>', 'StageSession$sessionId' => '<p>ID of the session within the stage.</p>', 'StageSessionSummary$sessionId' => '<p>ID of the session within the stage.</p>', 'StageSummary$activeSessionId' => '<p>ID of the active session within the stage.</p>', ], ], 'StageSessionList' => [ 'base' => NULL, 'refs' => [ 'ListStageSessionsResponse$stageSessions' => '<p>List of matching stage sessions.</p>', ], ], 'StageSessionSummary' => [ 'base' => '<p>Summary information about a stage session.</p>', 'refs' => [ 'StageSessionList$member' => NULL, ], ], 'StageSummary' => [ 'base' => '<p>Summary information about a stage.</p>', 'refs' => [ 'StageSummaryList$member' => NULL, ], ], 'StageSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListStagesResponse$stages' => '<p>List of the matching stages (summary information only).</p>', ], ], 'StartCompositionRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartCompositionResponse' => [ 'base' => NULL, 'refs' => [], ], 'StopCompositionRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopCompositionResponse' => [ 'base' => NULL, 'refs' => [], ], 'StorageConfiguration' => [ 'base' => '<p>A complex type that describes a location where recorded videos will be stored.</p>', 'refs' => [ 'CreateStorageConfigurationResponse$storageConfiguration' => '<p>The StorageConfiguration that was created.</p>', 'GetStorageConfigurationResponse$storageConfiguration' => '<p>The StorageConfiguration that was returned.</p>', ], ], 'StorageConfigurationArn' => [ 'base' => NULL, 'refs' => [ 'DeleteStorageConfigurationRequest$arn' => '<p>ARN of the storage configuration to be deleted.</p>', 'GetStorageConfigurationRequest$arn' => '<p>ARN of the storage configuration to be retrieved.</p>', 'S3DestinationConfiguration$storageConfigurationArn' => '<p>ARN of the <a>StorageConfiguration</a> where recorded videos will be stored.</p>', 'StorageConfiguration$arn' => '<p>ARN of the storage configuration.</p>', 'StorageConfigurationSummary$arn' => '<p>ARN of the storage configuration.</p>', ], ], 'StorageConfigurationName' => [ 'base' => NULL, 'refs' => [ 'CreateStorageConfigurationRequest$name' => '<p>Storage configuration name. The value does not need to be unique.</p>', 'StorageConfiguration$name' => '<p>Name of the storage configuration.</p>', 'StorageConfigurationSummary$name' => '<p>Name of the storage configuration.</p>', ], ], 'StorageConfigurationSummary' => [ 'base' => '<p>Summary information about a storage configuration.</p>', 'refs' => [ 'StorageConfigurationSummaryList$member' => NULL, ], ], 'StorageConfigurationSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListStorageConfigurationsResponse$storageConfigurations' => '<p>List of the matching storage configurations.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'Destination$id' => '<p>Unique identifier for this destination, assigned by IVS.</p>', 'DestinationSummary$id' => '<p>Unique identifier for this destination, assigned by IVS.</p>', 'ParticipantAttributes$key' => NULL, 'ParticipantAttributes$value' => NULL, 'ParticipantTokenAttributes$key' => NULL, 'ParticipantTokenAttributes$value' => NULL, 'S3Detail$recordingPrefix' => '<p>The S3 bucket prefix under which the recording is stored.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'Tags$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>Array of tags to be removed. Array of maps, each of the form <code>string:string (key:value)</code>. See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> for details, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no constraints beyond what is documented there.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tags$value' => NULL, ], ], 'Tags' => [ 'base' => NULL, 'refs' => [ 'Composition$tags' => '<p>Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>. See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> for details, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no constraints on tags beyond what is documented there.</p>', 'CompositionSummary$tags' => '<p>Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>. See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> for details, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no constraints on tags beyond what is documented there.</p>', 'CreateEncoderConfigurationRequest$tags' => '<p>Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>. See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> for details, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no constraints on tags beyond what is documented there.</p>', 'CreateStageRequest$tags' => '<p>Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>. See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> for details, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no constraints on tags beyond what is documented there. </p>', 'CreateStorageConfigurationRequest$tags' => '<p>Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>. See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> for details, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no constraints on tags beyond what is documented there.</p>', 'EncoderConfiguration$tags' => '<p>Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>. See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> for details, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no constraints on tags beyond what is documented there.</p>', 'EncoderConfigurationSummary$tags' => '<p>Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>. See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> for details, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no constraints on tags beyond what is documented there.</p>', 'ImportPublicKeyRequest$tags' => '<p>Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>. See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> for details, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no constraints on tags beyond what is documented there.</p>', 'ListTagsForResourceResponse$tags' => '<p>Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>.</p>', 'PublicKey$tags' => '<p>Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>. See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> for details, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no constraints on tags beyond what is documented there.</p>', 'PublicKeySummary$tags' => '<p>Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>. See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> for details, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no constraints on tags beyond what is documented there.</p>', 'Stage$tags' => '<p>Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>. See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> for details, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no constraints on tags beyond what is documented there.</p>', 'StageSummary$tags' => '<p>Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>. See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> for details, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no constraints on tags beyond what is documented there.</p>', 'StartCompositionRequest$tags' => '<p>Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>. See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> for details, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no constraints on tags beyond what is documented there.</p>', 'StorageConfiguration$tags' => '<p>Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>. See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> for details, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no constraints on tags beyond what is documented there.</p>', 'StorageConfigurationSummary$tags' => '<p>Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>. See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> for details, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no constraints on tags beyond what is documented there.</p>', 'TagResourceRequest$tags' => '<p>Array of tags to be added or updated. Array of maps, each of the form <code>string:string (key:value)</code>. See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> for details, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no constraints beyond what is documented there.</p>', ], ], 'Time' => [ 'base' => NULL, 'refs' => [ 'Composition$startTime' => '<p>UTC time of the Composition start. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>', 'Composition$endTime' => '<p>UTC time of the Composition end. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>', 'CompositionSummary$startTime' => '<p>UTC time of the Composition start. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>', 'CompositionSummary$endTime' => '<p>UTC time of the Composition end. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>', 'Destination$startTime' => '<p>UTC time of the destination start. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>', 'Destination$endTime' => '<p>UTC time of the destination end. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>', 'DestinationSummary$startTime' => '<p>UTC time of the destination start. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>', 'DestinationSummary$endTime' => '<p>UTC time of the destination end. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>', 'Event$eventTime' => '<p>ISO 8601 timestamp (returned as a string) for when the event occurred.</p>', 'Participant$firstJoinTime' => '<p>ISO 8601 timestamp (returned as a string) when the participant first joined the stage session.</p>', 'ParticipantSummary$firstJoinTime' => '<p>ISO 8601 timestamp (returned as a string) when the participant first joined the stage session.</p>', 'StageSession$startTime' => '<p> ISO 8601 timestamp (returned as a string) when this stage session began.</p>', 'StageSession$endTime' => '<p>ISO 8601 timestamp (returned as a string) when the stage session ended. This is null if the stage is active.</p>', 'StageSessionSummary$startTime' => '<p> ISO 8601 timestamp (returned as a string) when this stage session began.</p>', 'StageSessionSummary$endTime' => '<p>ISO 8601 timestamp (returned as a string) when the stage session ended. This is null if the stage is active.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateStageRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateStageResponse' => [ 'base' => NULL, 'refs' => [], ], 'UserId' => [ 'base' => NULL, 'refs' => [ 'ListParticipantsRequest$filterByUserId' => '<p>Filters the response list to match the specified user ID. Only one of <code>filterByUserId</code>, <code>filterByPublished</code>, <code>filterByState</code>, or <code>filterByRecordingState</code> can be provided per request. A <code>userId</code> is a customer-assigned name to help identify the token; this can be used to link a participant to a user in the customer’s own systems.</p>', 'Participant$userId' => '<p>Customer-assigned name to help identify the token; this can be used to link a participant to a user in the customer’s own systems. This can be any UTF-8 encoded text. <i>This field is exposed to all stage participants and should not be used for personally identifying, confidential, or sensitive information</i>.</p>', 'ParticipantSummary$userId' => '<p>Customer-assigned name to help identify the token; this can be used to link a participant to a user in the customer’s own systems. This can be any UTF-8 encoded text. <i>This field is exposed to all stage participants and should not be used for personally identifying, confidential, or sensitive information</i>.</p>', ], ], 'ValidationException' => [ 'base' => '<p/>', 'refs' => [], ], 'Video' => [ 'base' => '<p>Settings for video.</p>', 'refs' => [ 'CreateEncoderConfigurationRequest$video' => '<p>Video configuration. Default: video resolution 1280x720, bitrate 2500 kbps, 30 fps.</p>', 'EncoderConfiguration$video' => '<p>Video configuration. Default: video resolution 1280x720, bitrate 2500 kbps, 30 fps</p>', ], ], 'VideoAspectRatio' => [ 'base' => NULL, 'refs' => [ 'GridConfiguration$videoAspectRatio' => '<p>Sets the non-featured participant display mode, to control the aspect ratio of video tiles. <code>VIDEO</code> is 16:9, <code>SQUARE</code> is 1:1, and <code>PORTRAIT</code> is 3:4. Default: <code>VIDEO</code>.</p>', ], ], 'VideoFillMode' => [ 'base' => NULL, 'refs' => [ 'GridConfiguration$videoFillMode' => '<p>Defines how video content fits within the participant tile: <code>FILL</code> (stretched), <code>COVER</code> (cropped), or <code>CONTAIN</code> (letterboxed). When not set, <code>videoFillMode</code> defaults to <code>COVER</code> fill mode for participants in the grid and to <code>CONTAIN</code> fill mode for featured participants.</p>', 'PipConfiguration$videoFillMode' => '<p>Defines how video content fits within the participant tile: <code>FILL</code> (stretched), <code>COVER</code> (cropped), or <code>CONTAIN</code> (letterboxed). Default: <code>COVER</code>.</p>', ], ], 'Width' => [ 'base' => NULL, 'refs' => [ 'Video$width' => '<p>Video-resolution width. Note that the maximum value is determined by <code>width</code> times <code>height</code>, such that the maximum total pixels is 2073600 (1920x1080 or 1080x1920). Default: 1280.</p>', ], ], 'errorMessage' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$exceptionMessage' => '<p>User does not have sufficient access to perform this action.</p>', 'ConflictException$exceptionMessage' => '<p>Updating or deleting a resource can cause an inconsistent state.</p>', 'InternalServerException$exceptionMessage' => '<p>Unexpected error during processing of request.</p>', 'PendingVerification$exceptionMessage' => '<p> Your account is pending verification. </p>', 'ResourceNotFoundException$exceptionMessage' => '<p>Request references a resource which does not exist.</p>', 'ServiceQuotaExceededException$exceptionMessage' => '<p>Request would cause a service quota to be exceeded.</p>', 'ValidationException$exceptionMessage' => '<p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>', ], ], ],];
