<?php
// This file was auto-generated from sdk-root/src/data/kafka/2018-11-14/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>The operations for managing an Amazon MSK cluster.</p>', 'operations' => [ 'BatchAssociateScramSecret' => '<p>Associates one or more Scram Secrets with an Amazon MSK cluster.</p>', 'CreateCluster' => '<p>Creates a new MSK cluster.</p>', 'CreateClusterV2' => '<p>Creates a new Amazon MSK cluster of either the provisioned or the serverless type.</p>', 'CreateReplicator' => '<p>Creates a new Kafka Replicator.</p>', 'CreateConfiguration' => '<p>Creates a new MSK configuration.</p>', 'CreateVpcConnection' => '<p>Creates a new Amazon MSK VPC connection.</p>', 'DeleteCluster' => '<p>Deletes the MSK cluster specified by the Amazon Resource Name (ARN) in the request.</p>', 'DeleteClusterPolicy' => '<p>Deletes the MSK cluster policy specified by the Amazon Resource Name (ARN) in your request.</p>', 'DeleteConfiguration' => '<p>Deletes the specified MSK configuration. The configuration must be in the ACTIVE or DELETE_FAILED state.</p>', 'DeleteReplicator' => '<p>Deletes a replicator.</p>', 'DeleteVpcConnection' => '<p>Deletes the Amazon MSK VPC connection specified in your request.</p>', 'DescribeCluster' => '<p>Returns a description of the MSK cluster whose Amazon Resource Name (ARN) is specified in the request.</p>', 'DescribeClusterV2' => '<p>Returns a description of the MSK cluster of either the provisioned or the serverless type whose Amazon Resource Name (ARN) is specified in the request.</p>', 'DescribeClusterOperation' => '<p>Returns a description of the cluster operation specified by the ARN.</p>', 'DescribeClusterOperationV2' => '<p>Returns a description of the cluster operation specified by the ARN.</p>', 'DescribeConfiguration' => '<p>Returns a description of this MSK configuration.</p>', 'DescribeConfigurationRevision' => '<p>Returns a description of this revision of the configuration.</p>', 'DescribeReplicator' => '<p>Returns a description of the Kafka Replicator whose Amazon Resource Name (ARN) is specified in the request.</p>', 'DescribeVpcConnection' => '<p>Displays information about the specified Amazon MSK VPC connection.</p>', 'BatchDisassociateScramSecret' => '<p>Disassociates one or more Scram Secrets from an Amazon MSK cluster.</p>', 'GetBootstrapBrokers' => '<p>A list of brokers that a client application can use to bootstrap.</p>', 'GetCompatibleKafkaVersions' => '<p>Gets the Apache Kafka versions to which you can update the MSK cluster.</p>', 'GetClusterPolicy' => '<p>Retrieves the contents of the specified MSK cluster policy.</p>', 'ListClientVpcConnections' => '<p>Displays a list of client VPC connections.</p>', 'ListClusterOperations' => '<p>Returns a list of all the operations that have been performed on the specified MSK cluster.</p>', 'ListClusterOperationsV2' => '<p>Returns a list of all the operations that have been performed on the specified MSK cluster.</p>', 'ListClusters' => '<p>Returns a list of all the MSK clusters in the current Region.</p>', 'ListClustersV2' => '<p>Returns a list of all the MSK clusters in the current Region.</p>', 'ListConfigurationRevisions' => '<p>Returns a list of all the revisions of an MSK configuration.</p>', 'ListConfigurations' => '<p>Returns a list of all the MSK configurations in this Region.</p>', 'ListKafkaVersions' => '<p>Returns a list of Apache Kafka versions.</p>', 'ListNodes' => '<p>Returns a list of the broker nodes in the cluster.</p>', 'ListReplicators' => '<p>Lists the replicators.</p>', 'ListScramSecrets' => '<p>Returns a list of the Scram Secrets associated with an Amazon MSK cluster.</p>', 'ListTagsForResource' => '<p>Returns a list of the tags associated with the specified resource.</p>', 'ListVpcConnections' => '<p>Displays a list of Amazon MSK VPC connections.</p>', 'PutClusterPolicy' => '<p>Creates or updates the specified MSK cluster policy. If updating the policy, the currentVersion field is required in the request payload.</p>', 'RebootBroker' => '<p>Executes a reboot on a broker.</p>', 'RejectClientVpcConnections' => '<p>Rejects a client VPC connection.</p>', 'TagResource' => '<p>Adds tags to the specified MSK resource.</p>', 'UntagResource' => '<p>Removes the tags associated with the keys that are provided in the query.</p>', 'UpdateBrokerCount' => '<p>Updates the number of broker nodes in the cluster. You can use this operation to increase the number of brokers in an existing cluster. You can\'t decrease the number of brokers.</p>', 'UpdateBrokerType' => '<p>Updates all the brokers in the cluster to the specified type.</p>', 'UpdateBrokerStorage' => '<p>Updates the EBS storage associated with MSK brokers.</p>', 'UpdateConfiguration' => '<p>Updates an existing MSK configuration. The configuration must be in the Active state.</p>', 'UpdateConnectivity' => '<p>Updates the connectivity configuration for the MSK cluster.</p>', 'UpdateClusterConfiguration' => '<p>Updates the cluster with the configuration that is specified in the request body.</p>', 'UpdateClusterKafkaVersion' => '<p>Updates the Apache Kafka version for the cluster.</p>', 'UpdateMonitoring' => '<p>Updates the monitoring settings for the cluster. You can use this operation to specify which Apache Kafka metrics you want Amazon MSK to send to Amazon CloudWatch. You can also specify settings for open monitoring with Prometheus.</p>', 'UpdateReplicationInfo' => '<p>Updates replication info of a replicator.</p>', 'UpdateSecurity' => '<p>You can use this operation to update the encrypting and authentication settings for an existing cluster.</p>', 'UpdateStorage' => '<p>Updates cluster broker volume size (or) sets cluster storage mode to TIERED.</p>', ], 'shapes' => [ 'AmazonMskCluster' => [ 'base' => '<p>Details of an Amazon MSK Cluster.</p>', 'refs' => [ 'KafkaCluster$AmazonMskCluster' => '<p>Details of an Amazon MSK Cluster.</p>', 'KafkaClusterDescription$AmazonMskCluster' => '<p>Details of an Amazon MSK Cluster.</p>', 'KafkaClusterSummary$AmazonMskCluster' => '<p>Details of an Amazon MSK Cluster</p>.', ], ], 'BatchAssociateScramSecretRequest' => [ 'base' => '<p>Request body for BatchAssociateScramSecret.</p>', 'refs' => [], ], 'BatchAssociateScramSecretResponse' => [ 'base' => '<p>Response body for BatchAssociateScramSecret.</p>', 'refs' => [], ], 'BadRequestException' => [ 'base' => '<p>Returns information about an error.</p>', 'refs' => [], ], 'BrokerAZDistribution' => [ 'base' => '<p>The distribution of broker nodes across Availability Zones. By default, broker nodes are distributed among the Availability Zones of your Region. Currently, the only supported value is DEFAULT. You can either specify this value explicitly or leave it out.</p>', 'refs' => [ 'BrokerNodeGroupInfo$BrokerAZDistribution' => '<p>The distribution of broker nodes across Availability Zones.</p>', ], ], 'BrokerEBSVolumeInfo' => [ 'base' => '<p>Specifies the EBS volume upgrade information. The broker identifier must be set to the keyword ALL. This means the changes apply to all the brokers in the cluster.</p>', 'refs' => [ '__listOfBrokerEBSVolumeInfo$member' => NULL, ], ], 'BrokerLogs' => [ 'base' => '<p>The broker logs configuration for this MSK cluster.</p>', 'refs' => [ 'LoggingInfo$BrokerLogs' => '<p>You can configure your MSK cluster to send broker logs to different destination types. This configuration specifies the details of these destinations.</p>', ], ], 'BrokerNodeGroupInfo' => [ 'base' => '<p>Describes the setup to be used for Apache Kafka broker nodes in the cluster.</p>', 'refs' => [ 'ClusterInfo$BrokerNodeGroupInfo' => '<p>Information about the brokers.</p>', 'Provisioned$BrokerNodeGroupInfo' => '<p>Information about the brokers.</p>', 'CreateClusterRequest$BrokerNodeGroupInfo' => '<p>Information about the brokers.</p>', 'ProvisionedRequest$BrokerNodeGroupInfo' => '<p>Information about the brokers.</p>', ], ], 'Provisioned' => [ 'base' => '<p>Describes the provisioned cluster.</p>', 'refs' => [ 'Cluster$Provisioned' => '<p>Information about the provisioned cluster.</p>', ], ], 'ProvisionedRequest' => [ 'base' => '<p>Creates a provisioned cluster.</p>', 'refs' => [ 'CreateClusterV2Request$Provisioned' => '<p>Creates a provisioned cluster.</p>', ], ], 'ServerlessRequest' => [ 'base' => '<p>Creates serverless cluster.</p>', 'refs' => [ 'CreateClusterV2Request$Serverless' => '<p>Creates a serverless cluster.</p>', ], ], 'Serverless' => [ 'base' => '<p>Describes the serverless cluster.</p>', 'refs' => [ 'Cluster$Serverless' => '<p>Information about the serverless cluster.</p>', ], ], 'ServerlessClientAuthentication' => [ 'base' => '<p>Describes the serverless cluster client authentication.</p>', 'refs' => [ 'Serverless$ClientAuthentication' => '<p>Information about the serverless cluster client authentication.</p>', 'ServerlessRequest$ClientAuthentication' => '<p>Information about the serverless cluster client authentication.</p>', ], ], 'ServerlessSasl' => [ 'base' => '<p>Describes the serverless cluster SASL information.</p>', 'refs' => [ 'ServerlessClientAuthentication$Sasl' => '<p>Serverless cluster SASL information.</p>', ], ], 'BrokerNodeInfo' => [ 'base' => '<p>BrokerNodeInfo</p>', 'refs' => [ 'NodeInfo$BrokerNodeInfo' => '<p>The broker node info.</p>', ], ], 'BrokerSoftwareInfo' => [ 'base' => '<p>Information about the current software installed on the cluster.</p>', 'refs' => [ 'BrokerNodeInfo$CurrentBrokerSoftwareInfo' => '<p>Information about the version of software currently deployed on the Apache Kafka brokers in the cluster.</p>', 'ClusterInfo$CurrentBrokerSoftwareInfo' => '<p>Information about the version of software currently deployed on the Apache Kafka brokers in the cluster.</p>', 'Provisioned$CurrentBrokerSoftwareInfo' => '<p>Information about the version of software currently deployed on the Apache Kafka brokers in the cluster.</p>', ], ], 'ClientAuthentication' => [ 'base' => '<p>Includes all client authentication information.</p>', 'refs' => [ 'ClusterInfo$ClientAuthentication' => '<p>Includes all client authentication information.</p>', 'Provisioned$ClientAuthentication' => '<p>Includes all client authentication information.</p>', 'CreateClusterRequest$ClientAuthentication' => '<p>Includes all client authentication related information.</p>', 'ProvisionedRequest$ClientAuthentication' => '<p>Includes all client authentication related information.</p>', 'MutableClusterInfo$ClientAuthentication' => '<p>Includes all client authentication related information.</p>', 'UpdateSecurityRequest$ClientAuthentication' => '<p>Includes all client authentication related information.</p>', ], ], 'ClientBroker' => [ 'base' => '<p>Client-broker encryption in transit setting.</p>', 'refs' => [ 'EncryptionInTransit$ClientBroker' => '<p>Indicates the encryption setting for data in transit between clients and brokers. You must set it to one of the following values.</p> <p>TLS means that client-broker communication is enabled with TLS only.</p> <p>TLS_PLAINTEXT means that client-broker communication is enabled for both TLS-encrypted, as well as plaintext data.</p> <p>PLAINTEXT means that client-broker communication is enabled in plaintext only.</p> <p>The default value is TLS.</p>', ], ], 'CloudWatchLogs' => [ 'base' => '<p>Details of the CloudWatch Logs destination for broker logs.</p>', 'refs' => [ 'BrokerLogs$CloudWatchLogs' => '<p>Details of the CloudWatch Logs destination for broker logs.</p>', ], ], 'ClusterInfo' => [ 'base' => '<p>Returns information about a cluster.</p>', 'refs' => [ 'DescribeClusterResponse$ClusterInfo' => '<p>The cluster information.</p>', '__listOfClusterInfo$member' => NULL, ], ], 'Cluster' => [ 'base' => '<p>Returns information about a cluster of either the provisioned or the serverless type.</p>', 'refs' => [ 'DescribeClusterV2Response$ClusterInfo' => '<p>The cluster information.</p>', '__listOfCluster$member' => NULL, ], ], 'ClusterOperationInfo' => [ 'base' => '<p>Returns information about a cluster operation.</p>', 'refs' => [ 'DescribeClusterOperationResponse$ClusterOperationInfo' => '<p>Cluster operation information</p>', '__listOfClusterOperationInfo$member' => NULL, ], ], 'ClusterOperationStep' => [ 'base' => '<p>Step taken during a cluster operation.</p>', 'refs' => [ '__listOfClusterOperationStep$member' => NULL, ], ], 'ClusterOperationStepInfo' => [ 'base' => '<p>State information about the operation step.</p>', 'refs' => [ 'ClusterOperationStep$StepInfo' => '<p>Information about the step and its status.</p>', ], ], 'ClusterOperationV2' => [ 'base' => '<p>Returns information about a cluster operation.</p>', 'refs' => [ 'DescribeClusterOperationV2Response$ClusterOperationInfo' => '<p>Cluster operation information</p>', ], ], 'ClusterOperationV2Provisioned' => [ 'base' => '<p>Returns information about a provisioned cluster operation.</p>', 'refs' => [ 'ClusterOperationV2$Provisioned' => '<p>Properties of a provisioned cluster.</p>', ], ], 'ClusterOperationV2Serverless' => [ 'base' => '<p>Returns information about a serverless cluster operation.</p>', 'refs' => [ 'ClusterOperationV2$Serverless' => '<p>Properties of a serverless cluster.</p>', ], ], 'ClusterOperationV2Summary' => [ 'base' => '<p>Returns information about a cluster operation.</p>', 'refs' => [ '__listOfClusterOperationV2Summary$member' => NULL, ], ], 'ClusterState' => [ 'base' => '<p>The state of an Apache Kafka cluster.</p>', 'refs' => [ 'ClusterInfo$State' => '<p>The state of the cluster. The possible states are ACTIVE, CREATING, DELETING, FAILED, HEALING, MAINTENANCE, REBOOTING_BROKER, and UPDATING.</p>', 'CreateClusterResponse$State' => '<p>The state of the cluster. The possible states are ACTIVE, CREATING, DELETING, FAILED, HEALING, MAINTENANCE, REBOOTING_BROKER, and UPDATING.</p>', 'CreateClusterV2Response$State' => '<p>The state of the cluster. The possible states are ACTIVE, CREATING, DELETING, FAILED, HEALING, MAINTENANCE, REBOOTING_BROKER, and UPDATING.</p>', 'DeleteClusterResponse$State' => '<p>The state of the cluster. The possible states are ACTIVE, CREATING, DELETING, FAILED, HEALING, MAINTENANCE, REBOOTING_BROKER, and UPDATING.</p>', ], ], 'CompatibleKafkaVersion' => [ 'base' => '<p>Contains source Apache Kafka versions and compatible target Apache Kafka versions.</p>', 'refs' => [ '__listOfCompatibleKafkaVersion$member' => NULL, ], ], 'Configuration' => [ 'base' => '<p>Represents an MSK Configuration.</p>', 'refs' => [ '__listOfConfiguration$member' => NULL, ], ], 'ConfigurationInfo' => [ 'base' => '<p>Specifies the configuration to use for the brokers.</p>', 'refs' => [ 'CreateClusterRequest$ConfigurationInfo' => '<p>Represents the configuration that you want MSK to use for the cluster.</p>', 'ProvisionedRequest$ConfigurationInfo' => '<p>Represents the configuration that you want MSK to use for the cluster.</p>', 'MutableClusterInfo$ConfigurationInfo' => '<p>Information about the changes in the configuration of the brokers.</p>', 'UpdateClusterConfigurationRequest$ConfigurationInfo' => '<p>Represents the configuration that you want MSK to use for the cluster.</p>', ], ], 'ConfigurationRevision' => [ 'base' => '<p>Describes a configuration revision.</p>', 'refs' => [ 'Configuration$LatestRevision' => '<p>Latest revision of the configuration.</p>', 'CreateConfigurationResponse$LatestRevision' => '<p>Latest revision of the configuration.</p>', 'DescribeConfigurationResponse$LatestRevision' => '<p>Latest revision of the configuration.</p>', 'UpdateConfigurationResponse$LatestRevision' => '<p>Latest revision of the configuration.</p>', '__listOfConfigurationRevision$member' => NULL, ], ], 'ConfigurationState' => [ 'base' => '<p>The state of a configuration.</p>', 'refs' => [ 'DescribeConfigurationResponse$State' => '<p>The state of the configuration. The possible states are ACTIVE, DELETING and DELETE_FAILED.</p>', 'CreateConfigurationResponse$State' => '<p>The state of the configuration. The possible states are ACTIVE, DELETING and DELETE_FAILED.</p>', 'DeleteConfigurationResponse$State' => '<p>The state of the configuration. The possible states are ACTIVE, DELETING and DELETE_FAILED.</p>', ], ], 'ConflictException' => [ 'base' => '<p>Returns information about an error.</p>', 'refs' => [], ], 'ConnectivityInfo' => [ 'base' => '<p>Information about the broker access configuration.</p>', 'refs' => [ 'BrokerNodeGroupInfo$ConnectivityInfo' => '<p>Information about the broker access configuration.</p>', 'MutableClusterInfo$ConnectivityInfo' => '<p>Information about the broker access configuration.</p>', 'UpdateConnectivityRequest$ConnectivityInfo' => '<p>Information about the broker access configuration.</p>', ], ], 'BrokerCountUpdateInfo' => [ 'base' => '<p>Describes brokers being changed during a broker count update.</p>', 'refs' => [ 'MutableClusterInfo$BrokerCountUpdateInfo' => '<p>Describes brokers being changed during a broker count update.</p>', ], ], 'ConsumerGroupReplication' => [ 'base' => '<p>Details about consumer group replication.</p>', 'refs' => [ 'ReplicationInfo$ConsumerGroupReplication' => '<p>Configuration relating to consumer group replication.</p>', 'ReplicationInfoDescription$ConsumerGroupReplication' => '<p>Configuration relating to consumer group replication</p>.', ], ], 'ConsumerGroupReplicationUpdate' => [ 'base' => '<p>Details about consumer group replication.</p>', 'refs' => [ 'UpdateReplicationInfoRequest$ConsumerGroupReplication' => '<p>Updated consumer group replication information.</p>', ], ], 'CreateClusterRequest' => [ 'base' => '<p>Creates a cluster.</p>', 'refs' => [], ], 'CreateClusterV2Request' => [ 'base' => '<p>Creates a new Amazon MSK cluster of either the provisioned or the serverless type.</p>', 'refs' => [], ], 'CreateClusterResponse' => [ 'base' => '<p>Returns information about the created cluster.</p>', 'refs' => [], ], 'CreateClusterV2Response' => [ 'base' => '<p>Returns information about the created cluster of either the provisioned or the serverless type.</p>', 'refs' => [], ], 'CreateConfigurationRequest' => [ 'base' => '<p>Request body for CreateConfiguration.</p>', 'refs' => [], ], 'CreateConfigurationResponse' => [ 'base' => '<p>Response body for CreateConfiguration</p>', 'refs' => [], ], 'CreateReplicatorRequest' => [ 'base' => '<p>Request body for replicator.</p>', 'refs' => [], ], 'CreateReplicatorResponse' => [ 'base' => '<p>Returns information about the created replicator.</p>', 'refs' => [], ], 'CreateVpcConnectionRequest' => [ 'base' => '<p>Request body for CreateVpcConnection.</p>', 'refs' => [], ], 'CreateVpcConnectionResponse' => [ 'base' => '<p>Response body for CreateVpcConnection</p>', 'refs' => [], ], 'ControllerNodeInfo' => [ 'base' => '<p>Controller node information.</p>', 'refs' => [ 'NodeInfo$ControllerNodeInfo' => '<p>The ControllerNodeInfo.</p>', ], ], 'CustomerActionStatus' => [ 'base' => '<p>A type of an action required from the customer.</p>', 'refs' => [ 'ClusterInfo$CustomerActionStatus' => '<p>Determines if there is an action required from the customer.</p>', 'Provisioned$CustomerActionStatus' => '<p>Determines if there is an action required from the customer.</p>', ], ], 'DeleteClusterResponse' => [ 'base' => '<p>Returns information about the deleted cluster.</p>', 'refs' => [], ], 'DeleteClusterPolicyRequest' => [ 'base' => '<p>Request body for DeleteClusterPolicy.</p>', 'refs' => [], ], 'DeleteClusterPolicyResponse' => [ 'base' => '<p>Response body for DeleteClusterPolicy.</p>', 'refs' => [], ], 'DeleteConfigurationRequest' => [ 'base' => '<p>Request body for DeleteConfiguration.</p>', 'refs' => [], ], 'DeleteConfigurationResponse' => [ 'base' => '<p>Response body for DeleteConfiguration.</p>', 'refs' => [], ], 'DeleteReplicatorResponse' => [ 'base' => '<p>Returns information about the deleted replicator.</p>', 'refs' => [], ], 'DeleteVpcConnectionRequest' => [ 'base' => '<p>Request body for DeleteVpcConnection.</p>', 'refs' => [], ], 'DeleteVpcConnectionResponse' => [ 'base' => '<p>Response body for DeleteVpcConnection.</p>', 'refs' => [], ], 'DescribeClusterOperationResponse' => [ 'base' => '<p>Information about a cluster operation.</p>', 'refs' => [], ], 'DescribeClusterOperationV2Response' => [ 'base' => '<p>Information about a cluster operation.</p>', 'refs' => [], ], 'DescribeClusterResponse' => [ 'base' => '<p>Returns information about a cluster.</p>', 'refs' => [], ], 'DescribeClusterV2Response' => [ 'base' => '<p>Returns information about a cluster of either the provisioned or the serverless type.</p>', 'refs' => [], ], 'DescribeConfigurationResponse' => [ 'base' => '<p>Response body for DescribeConfiguration.</p>', 'refs' => [], ], 'DescribeConfigurationRevisionResponse' => [ 'base' => '<p>Response body for DescribeConfigurationRevision.</p>', 'refs' => [], ], 'DescribeReplicatorResponse' => [ 'base' => '<p>Response body for DescribeReplicator.</p>', 'refs' => [], ], 'DescribeVpcConnectionResponse' => [ 'base' => '<p>Response body for DescribeVpcConnection.</p>', 'refs' => [], ], 'BatchDisassociateScramSecretRequest' => [ 'base' => '<p>Request body for BatchDisassociateScramSecret.</p>', 'refs' => [], ], 'BatchDisassociateScramSecretResponse' => [ 'base' => '<p>Response body for BatchDisassociateScramSecret.</p>', 'refs' => [], ], 'EBSStorageInfo' => [ 'base' => '<p>Contains information about the EBS storage volumes attached to Apache Kafka broker nodes.</p>', 'refs' => [ 'StorageInfo$EbsStorageInfo' => '<p>EBS volume information.</p>', ], ], 'EncryptionAtRest' => [ 'base' => '<p>The data-volume encryption details.</p>', 'refs' => [ 'EncryptionInfo$EncryptionAtRest' => '<p>The data-volume encryption details.</p>', ], ], 'EncryptionInTransit' => [ 'base' => '<p>The settings for encrypting data in transit.</p>', 'refs' => [ 'EncryptionInfo$EncryptionInTransit' => '<p>The details for encryption in transit.</p>', ], ], 'EncryptionInfo' => [ 'base' => '<p>Includes encryption-related information, such as the AWS KMS key used for encrypting data at rest and whether you want MSK to encrypt your data in transit.</p>', 'refs' => [ 'ClusterInfo$EncryptionInfo' => '<p>Includes all encryption-related information.</p>', 'Provisioned$EncryptionInfo' => '<p>Includes all encryption-related information.</p>', 'CreateClusterRequest$EncryptionInfo' => '<p>Includes all encryption-related information.</p>', 'ProvisionedRequest$EncryptionInfo' => '<p>Includes all encryption-related information.</p>', 'MutableClusterInfo$EncryptionInfo' => '<p>Includes all encryption-related information.</p>', 'UpdateSecurityRequest$EncryptionInfo' => '<p>Includes all encryption-related information.</p>', ], ], 'EnhancedMonitoring' => [ 'base' => '<p>Specifies which metrics are gathered for the MSK cluster. This property has the following possible values: DEFAULT, PER_BROKER, PER_TOPIC_PER_BROKER, and PER_TOPIC_PER_PARTITION. For a list of the metrics associated with each of these levels of monitoring, see <a href="https://docs.aws.amazon.com/msk/latest/developerguide/monitoring.html">Monitoring</a>.</p>', 'refs' => [ 'ClusterInfo$EnhancedMonitoring' => '<p>Specifies which metrics are gathered for the MSK cluster. This property has the following possible values: DEFAULT, PER_BROKER, PER_TOPIC_PER_BROKER, and PER_TOPIC_PER_PARTITION. For a list of the metrics associated with each of these levels of monitoring, see <a href="https://docs.aws.amazon.com/msk/latest/developerguide/monitoring.html">Monitoring</a>.</p>', 'Provisioned$EnhancedMonitoring' => '<p>Specifies which metrics are gathered for the MSK cluster. This property has the following possible values: DEFAULT, PER_BROKER, PER_TOPIC_PER_BROKER, and PER_TOPIC_PER_PARTITION. For a list of the metrics associated with each of these levels of monitoring, see <a href="https://docs.aws.amazon.com/msk/latest/developerguide/monitoring.html">Monitoring</a>.</p>', 'CreateClusterRequest$EnhancedMonitoring' => '<p>Specifies the level of monitoring for the MSK cluster. The possible values are DEFAULT, PER_BROKER, PER_TOPIC_PER_BROKER, and PER_TOPIC_PER_PARTITION.</p>', 'ProvisionedRequest$EnhancedMonitoring' => '<p>Specifies the level of monitoring for the MSK cluster. The possible values are DEFAULT, PER_BROKER, PER_TOPIC_PER_BROKER, and PER_TOPIC_PER_PARTITION.</p>', 'MutableClusterInfo$EnhancedMonitoring' => '<p>Specifies which Apache Kafka metrics Amazon MSK gathers and sends to Amazon CloudWatch for this cluster.</p>', 'UpdateMonitoringRequest$EnhancedMonitoring' => '<p>Specifies which Apache Kafka metrics Amazon MSK gathers and sends to Amazon CloudWatch for this cluster.</p>', ], ], 'Error' => [ 'base' => '<p>Returns information about an error.</p>', 'refs' => [], ], 'ErrorInfo' => [ 'base' => '<p>Returns information about an error state of the cluster.</p>', 'refs' => [ 'ClusterOperationInfo$ErrorInfo' => '<p>Describes the error if the operation fails.</p>', ], ], 'Firehose' => [ 'base' => '<p>Firehose details for BrokerLogs.</p>', 'refs' => [ 'BrokerLogs$Firehose' => '<p>Details of the Kinesis Data Firehose delivery stream that is the destination for broker logs.</p>', ], ], 'ForbiddenException' => [ 'base' => '<p>Returns information about an error.</p>', 'refs' => [], ], 'GetBootstrapBrokersResponse' => [ 'base' => '<p>Returns a string containing one or more hostname:port pairs.</p>', 'refs' => [], ], 'GetCompatibleKafkaVersionsResponse' => [ 'base' => '<p>Response body for GetCompatibleKafkaVersions.</p>', 'refs' => [], ], 'GetClusterPolicyRequest' => [ 'base' => '<p>Request body for GetClusterPolicy.</p>', 'refs' => [], ], 'GetClusterPolicyResponse' => [ 'base' => '<p>Returns information about the specified cluster policy.</p>', 'refs' => [], ], 'InternalServerErrorException' => [ 'base' => '<p>Returns information about an error.</p>', 'refs' => [], ], 'JmxExporter' => [ 'base' => '<p>Indicates whether you want to enable or disable the JMX Exporter.</p>', 'refs' => [ 'Prometheus$JmxExporter' => '<p>Indicates whether you want to enable or disable the JMX Exporter.</p>', ], ], 'JmxExporterInfo' => [ 'base' => '<p>Indicates whether you want to enable or disable the JMX Exporter.</p>', 'refs' => [ 'PrometheusInfo$JmxExporter' => '<p>JMX Exporter settings.</p>', ], ], 'KafkaCluster' => [ 'base' => '<p>Information about Kafka Cluster to be used as source / target for replication.</p>', 'refs' => [ '__listOfKafkaCluster$member' => NULL, ], ], 'KafkaClusterClientVpcConfig' => [ 'base' => NULL, 'refs' => [ 'KafkaCluster$VpcConfig' => 'Details of an Amazon VPC which has network connectivity to the Apache Kafka cluster.', 'KafkaClusterDescription$VpcConfig' => 'Details of an Amazon VPC which has network connectivity to the Apache Kafka cluster.', ], ], 'KafkaClusterDescription' => [ 'base' => '<p>Information about Kafka Cluster used as source / target for replication.</p>', 'refs' => [ '__listOfKafkaClusterDescription$member' => NULL, ], ], 'KafkaClusterSummary' => [ 'base' => '<p>Summarized information about Kafka Cluster used as source / target for replication.</p>', 'refs' => [ '__listOfKafkaClusterSummary$member' => NULL, ], ], 'KafkaVersion' => [ 'base' => '<p>Information about a Apache Kafka version.</p>', 'refs' => [ '__listOfKafkaVersion$member' => NULL, ], ], 'KafkaVersionStatus' => [ 'base' => '<p>The status of a Apache Kafka version.</p>', 'refs' => [ 'KafkaVersion$Status' => '<p>The status of the Apache Kafka version.</p>', ], ], 'ListClusterOperationsResponse' => [ 'base' => '<p>The response contains an array containing cluster operation information and a next token if the response is truncated.</p>', 'refs' => [], ], 'ListClusterOperationsV2Response' => [ 'base' => '<p>The response contains an array containing cluster operation information and a next token if the response is truncated.</p>', 'refs' => [], ], 'ListClustersResponse' => [ 'base' => '<p>The response contains an array containing cluster information and a next token if the response is truncated.</p>', 'refs' => [], ], 'ListClustersV2Response' => [ 'base' => '<p>The response contains an array containing cluster information and a next token if the response is truncated.</p>', 'refs' => [], ], 'ListConfigurationRevisionsResponse' => [ 'base' => '<p>Information about revisions of an MSK configuration.</p>', 'refs' => [], ], 'ListConfigurationsResponse' => [ 'base' => '<p>The response contains an array of Configuration and a next token if the response is truncated.</p>', 'refs' => [], ], 'ListKafkaVersionsResponse' => [ 'base' => '<p>Response for ListKafkaVersions.</p>', 'refs' => [], ], 'ListNodesResponse' => [ 'base' => '<p>Information about nodes in the cluster.</p>', 'refs' => [], ], 'ListReplicatorsResponse' => [ 'base' => '<p>The response contains an array containing replicator information and a NextToken if the response is truncated.</p>', 'refs' => [], ], 'ListScramSecretsResponse' => [ 'base' => '<p>Information about scram secrets associated to the cluster.</p>', 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => '<p>Response of listing tags for a resource.</p>', 'refs' => [], ], 'ListClientVpcConnectionsRequest' => [ 'base' => '<p>Request body for ListClientVpcConnections.</p>', 'refs' => [], ], 'ListClientVpcConnectionsResponse' => [ 'base' => '<p>The response contains an array of client VPC connections and a next token if the response is truncated.</p>', 'refs' => [], ], 'ListVpcConnectionsRequest' => [ 'base' => '<p>Request body for ListVpcConnections.</p>', 'refs' => [], ], 'ListVpcConnectionsResponse' => [ 'base' => '<p>The response contains an array of MSK VPC connections and a next token if the response is truncated.</p>', 'refs' => [], ], 'RejectClientVpcConnectionRequest' => [ 'base' => '<p>Request body for RejectClientVpcConnection.</p>', 'refs' => [], ], 'RejectClientVpcConnectionResponse' => [ 'base' => '<p>Response body for RejectClientVpcConnection.</p>', 'refs' => [], ], 'LoggingInfo' => [ 'base' => '<p>You can configure your MSK cluster to send broker logs to different destination types. This is a container for the configuration details related to broker logs.</p>', 'refs' => [ 'ClusterInfo$LoggingInfo' => '<p>You can configure your MSK cluster to send broker logs to different destination types. This is a container for the configuration details related to broker logs.</p>', 'Provisioned$LoggingInfo' => '<p>You can configure your MSK cluster to send broker logs to different destination types. This is a container for the configuration details related to broker logs.</p>', 'CreateClusterRequest$LoggingInfo' => '<p>LoggingInfo details.</p>', 'ProvisionedRequest$LoggingInfo' => '<p>LoggingInfo details.</p>', 'MutableClusterInfo$LoggingInfo' => '<p>LoggingInfo details.</p>', 'UpdateMonitoringRequest$LoggingInfo' => '<p>LoggingInfo details.</p>', ], ], 'MutableClusterInfo' => [ 'base' => '<p>Information about cluster attributes that can be updated via update APIs.</p>', 'refs' => [ 'ClusterOperationInfo$SourceClusterInfo' => '<p>Information about cluster attributes before a cluster is updated.</p>', 'ClusterOperationInfo$TargetClusterInfo' => '<p>Information about cluster attributes after a cluster is updated.</p>', ], ], 'NodeExporter' => [ 'base' => '<p>Indicates whether you want to enable or disable the Node Exporter.</p>', 'refs' => [ 'Prometheus$NodeExporter' => '<p>Indicates whether you want to enable or disable the Node Exporter.</p>', ], ], 'NodeExporterInfo' => [ 'base' => '<p>Indicates whether you want to enable or disable the Node Exporter.</p>', 'refs' => [ 'PrometheusInfo$NodeExporter' => '<p>Node Exporter settings.</p>', ], ], 'NodeInfo' => [ 'base' => '<p>The node information object.</p>', 'refs' => [ '__listOfNodeInfo$member' => NULL, ], ], 'NodeType' => [ 'base' => '<p>The broker or Zookeeper node.</p>', 'refs' => [ 'NodeInfo$NodeType' => '<p>The node type.</p>', ], ], 'NotFoundException' => [ 'base' => '<p>Returns information about an error.</p>', 'refs' => [], ], 'OpenMonitoring' => [ 'base' => '<p>JMX and Node monitoring for the MSK cluster.</p>', 'refs' => [ 'ClusterInfo$OpenMonitoring' => '<p>Settings for open monitoring using Prometheus.</p>', 'Provisioned$OpenMonitoring' => '<p>Settings for open monitoring using Prometheus.</p>', 'MutableClusterInfo$OpenMonitoring' => '<p>Settings for open monitoring using Prometheus.</p>', ], ], 'OpenMonitoringInfo' => [ 'base' => '<p>JMX and Node monitoring for the MSK cluster.</p>', 'refs' => [ 'CreateClusterRequest$OpenMonitoring' => '<p>The settings for open monitoring.</p>', 'ProvisionedRequest$OpenMonitoring' => '<p>The settings for open monitoring.</p>', 'UpdateMonitoringRequest$OpenMonitoring' => '<p>The settings for open monitoring.</p>', ], ], 'Prometheus' => [ 'base' => '<p>Prometheus settings for open monitoring.</p>', 'refs' => [ 'OpenMonitoring$Prometheus' => '<p>Prometheus settings.</p>', ], ], 'PrometheusInfo' => [ 'base' => '<p>Prometheus settings.</p>', 'refs' => [ 'OpenMonitoringInfo$Prometheus' => '<p>Prometheus settings.</p>', ], ], 'ProvisionedThroughput' => [ 'base' => '<p>Contains information about provisioned throughput for EBS storage volumes attached to kafka broker nodes.</p>', 'refs' => [ 'BrokerEBSVolumeInfo$ProvisionedThroughput' => '<p>EBS volume provisioned throughput information.</p>', 'EBSStorageInfo$ProvisionedThroughput' => '<p>EBS volume provisioned throughput information.</p>', 'UpdateStorageRequest$ProvisionedThroughput' => '<p>EBS volume provisioned throughput information.</p>', ], ], 'PublicAccess' => [ 'base' => '<p>Broker public access control.</p>', 'refs' => [ 'ConnectivityInfo$PublicAccess' => '<p>Public access control for brokers.</p>', ], ], 'PutClusterPolicyRequest' => [ 'base' => '<p>Request body for PutClusterPolicy.</p>', 'refs' => [], ], 'PutClusterPolicyResponse' => [ 'base' => '<p>Response body for PutClusterPolicy.</p>', 'refs' => [], ], 'RebootBrokerRequest' => [ 'base' => '<p>Request body for RebootBrokerNode action.</p>', 'refs' => [], ], 'RebootBrokerResponse' => [ 'base' => '<p>Response body for RebootBrokers action.</p>', 'refs' => [], ], 'ReplicationInfo' => [ 'base' => '<p>Specifies configuration for replication between a source and target Kafka cluster.</p>', 'refs' => [ '__listOfReplicationInfo$member' => NULL, ], ], 'ReplicationInfoDescription' => [ 'base' => '<p>Specifies configuration for replication between a source and target Kafka cluster (sourceKafkaClusterAlias -> targetKafkaClusterAlias)</p>', 'refs' => [ '__listOfReplicationInfoDescription$member' => NULL, ], ], 'ReplicationInfoSummary' => [ 'base' => '<p>Summarized information of replication between clusters.</p>', 'refs' => [ '__listOfReplicationInfoSummary$member' => NULL, ], ], 'ReplicationStartingPosition' => [ 'base' => '<p>Configuration for specifying the position in the topics to start replicating from.</p>', 'refs' => [ 'TopicReplication$StartingPosition' => '<p>Configuration for specifying the position in the topics to start replicating from.</p>', ], ], 'ReplicationStartingPositionType' => [ 'base' => '<p>The type of replication starting position.</p>', 'refs' => [ 'ReplicationStartingPosition$Type' => '<p>The type of replication starting position.</p>', ], ], 'ReplicationStateInfo' => [ 'base' => 'Details about the state of a replicator', 'refs' => [ 'DescribeReplicatorResponse$StateInfo' => 'Details about the state of the replicator.', ], ], 'ReplicatorState' => [ 'base' => '<p>The state of a replicator.</p>', 'refs' => [ 'CreateReplicatorResponse$ReplicatorState' => '<p>State of the replicator.</p>', 'DeleteReplicatorResponse$ReplicatorState' => '<p>The state of the replicator.</p>', 'DescribeReplicatorResponse$ReplicatorState' => '<p>State of the replicator.</p>', 'ReplicatorSummary$ReplicatorState' => '<p>State of the replicator.</p>', 'UpdateReplicationInfoResponse$ReplicatorState' => '<p>State of the replicator.</p>', ], ], 'ReplicatorSummary' => [ 'base' => '<p>Information about a replicator.</p>', 'refs' => [ '__listOfReplicatorSummary$member' => NULL, ], ], 'S3' => [ 'base' => '<p>The details of the Amazon S3 destination for broker logs.</p>', 'refs' => [ 'BrokerLogs$S3' => '<p>Details of the Amazon S3 destination for broker logs.</p>', ], ], 'ServiceUnavailableException' => [ 'base' => '<p>Returns information about an error.</p>', 'refs' => [], ], 'StateInfo' => [ 'base' => '<p>Contains information about the state of the Amazon MSK cluster.</p>', 'refs' => [ 'ClusterInfo$StateInfo' => '<p>Contains information about the state of the Amazon MSK cluster.</p>', ], ], 'StorageInfo' => [ 'base' => '<p>Contains information about storage volumes attached to MSK broker nodes.</p>', 'refs' => [ 'BrokerNodeGroupInfo$StorageInfo' => '<p>Contains information about storage volumes attached to MSK broker nodes.</p>', ], ], 'StorageMode' => [ 'base' => '<p>Controls storage mode for various supported storage tiers.</p>', 'refs' => [ 'Provisioned$StorageMode' => '<p>This controls storage mode for supported storage tiers.</p>', 'ProvisionedRequest$StorageMode' => '<p>This controls storage mode for supported storage tiers.</p>', 'ClusterInfo$StorageMode' => '<p>This controls storage mode for supported storage tiers.</p>', 'CreateClusterRequest$StorageMode' => '<p>This controls storage mode for supported storage tiers.</p>', 'MutableClusterInfo$StorageMode' => '<p>This controls storage mode for supported storage tiers.</p>', 'UpdateStorageRequest$StorageMode' => '<p>Controls storage mode for supported storage tiers.</p>', ], ], 'TagResourceRequest' => [ 'base' => '<p>Tag a resource.</p>', 'refs' => [], ], 'TargetCompressionType' => [ 'base' => '<p>The type of compression to use producing records to the target cluster.</p>', 'refs' => [ 'ReplicationInfo$TargetCompressionType' => '<p>The compression type to use when producing records to target cluster.</p>', 'ReplicationInfoDescription$TargetCompressionType' => '<p>The compression type to use when producing records to target cluster.</p>', ], ], 'TopicReplication' => [ 'base' => '<p>Details about topic replication.</p>', 'refs' => [ 'ReplicationInfo$TopicReplication' => '<p>Configuration relating to topic replication.</p>', 'ReplicationInfoDescription$TopicReplication' => '<p>Configuration relating to topic replication.</p>', ], ], 'TopicReplicationUpdate' => [ 'base' => '<p>Details for updating the topic replication of a replicator.</p>', 'refs' => [ 'UpdateReplicationInfoRequest$TopicReplication' => '<p>Updated topic replication information.</p>', ], ], 'Tls' => [ 'base' => '<p>Details for client authentication using TLS.</p>', 'refs' => [ 'ClientAuthentication$Tls' => '<p>Details for ClientAuthentication using TLS.</p>', ], ], 'TooManyRequestsException' => [ 'base' => '<p>Returns information about an error.</p>', 'refs' => [], ], 'Unauthenticated' => [ 'base' => '<p>Contains information about unauthenticated traffic to the cluster.</p>', 'refs' => [ 'ClientAuthentication$Unauthenticated' => '<p>Contains information about unauthenticated traffic to the cluster.</p>', ], ], 'UnauthorizedException' => [ 'base' => '<p>Returns information about an error.</p>', 'refs' => [], ], 'UpdateBrokerCountRequest' => [ 'base' => '<p>Request body for UpdateBrokerCount.</p>', 'refs' => [], ], 'UpdateBrokerCountResponse' => [ 'base' => '<p>Response body for UpdateBrokerCount.</p>', 'refs' => [], ], 'UpdateBrokerTypeRequest' => [ 'base' => '<p>Request body for UpdateBrokerType.</p>', 'refs' => [], ], 'UpdateBrokerTypeResponse' => [ 'base' => '<p>Response body for UpdateBrokerType.</p>', 'refs' => [], ], 'UpdateBrokerStorageRequest' => [ 'base' => '<p>Request object for UpdateBrokerStorage.</p>', 'refs' => [], ], 'UpdateBrokerStorageResponse' => [ 'base' => '<p>Response body for UpdateBrokerStorage.</p>', 'refs' => [], ], 'UpdateConfigurationRequest' => [ 'base' => '<p>Request body for UpdateConfiguration.</p>', 'refs' => [], ], 'UpdateConfigurationResponse' => [ 'base' => '<p>Response body for UpdateConfiguration.</p>', 'refs' => [], ], 'UpdateConnectivityRequest' => [ 'base' => '<p>Request body for UpdateConnectivity.</p>', 'refs' => [], ], 'UpdateConnectivityResponse' => [ 'base' => '<p>Response body for UpdateConnectivity.</p>', 'refs' => [], ], 'UpdateClusterConfigurationRequest' => [ 'base' => '<p>Request body for UpdateClusterConfiguration.</p>', 'refs' => [], ], 'UpdateClusterConfigurationResponse' => [ 'base' => '<p>Response body for UpdateClusterConfiguration.</p>', 'refs' => [], ], 'UpdateClusterKafkaVersionRequest' => [ 'base' => '<p>Request body for UpdateClusterKafkaVersion.</p>', 'refs' => [], ], 'UpdateClusterKafkaVersionResponse' => [ 'base' => '<p>Response body for UpdateClusterKafkaVersion.</p>', 'refs' => [], ], 'UpdateMonitoringRequest' => [ 'base' => '<p>Request body for UpdateMonitoring.</p>', 'refs' => [], ], 'UpdateMonitoringResponse' => [ 'base' => '<p>Response body for UpdateMonitoring.</p>', 'refs' => [], ], 'UpdateReplicationInfoRequest' => [ 'base' => '<p>Parameters for updating replication information between source and target Kafka clusters of a replicator.</p>', 'refs' => [], ], 'UpdateReplicationInfoResponse' => [ 'base' => '<p>Updated Replication information of a replicator.</p>', 'refs' => [], ], 'UpdateSecurityRequest' => [ 'base' => '<p>Request body for UpdateSecurity.</p>', 'refs' => [], ], 'UpdateSecurityResponse' => [ 'base' => '<p>Response body for UpdateSecurity.</p>', 'refs' => [], ], 'UpdateStorageRequest' => [ 'base' => '<p>Request object for UpdateStorageApi.</p>', 'refs' => [], ], 'UpdateStorageResponse' => [ 'base' => '<p>Response body for UpdateStorageResponse Api.</p>', 'refs' => [], ], 'UserIdentity' => [ 'base' => '<p>Description of the requester that calls the API operation.</p>', 'refs' => [ 'VpcConnectionInfo$UserIdentity' => '<p>Description of the requester that calls the API operation.</p>', ], ], 'UserIdentityType' => [ 'base' => '<p>The identity type of the requester that calls the API operation.</p>', 'refs' => [ 'UserIdentity$Type' => '<p>The identity type of the requester that calls the API operation.</p>', ], ], 'ZookeeperNodeInfo' => [ 'base' => '<p>Zookeeper node information.</p>', 'refs' => [ 'NodeInfo$ZookeeperNodeInfo' => '<p>The ZookeeperNodeInfo.</p>', ], ], 'VpcConfig' => [ 'base' => '<p>The configuration of the Amazon VPCs for the cluster.</p>', 'refs' => [], ], 'VpcConnectivity' => [ 'base' => '<p>Broker VPC connectivity access control.</p>', 'refs' => [ 'ConnectivityInfo$VpcConnectivity' => '<p>VpcConnectivity control for brokers.</p>', ], ], 'ClientVpcConnection' => [ 'base' => '<p>The client VPC connection object.</p>', 'refs' => [ '__listOfClientVpcConnections$member' => NULL, ], ], 'VpcConnection' => [ 'base' => '<p>The VPC connection object.</p>', 'refs' => [ '__listOfVpcConnections$member' => NULL, ], ], 'VpcConnectionInfo' => [ 'base' => '<p>Description of the VPC connection for CreateVpcConnection and DeleteVpcConnection operations.</p>', 'refs' => [ 'ClusterOperationInfo$VpcConnectionInfo' => '<p>Description of the VPC connection for CreateVpcConnection and DeleteVpcConnection operations.</p>', ], ], 'VpcConnectionInfoServerless' => [ 'base' => '<p>Description of the VPC connection for CreateVpcConnection and DeleteVpcConnection operations.</p>', 'refs' => [ 'ClusterOperationV2Serverless$VpcConnectionInfo' => '<p>Description of the VPC connection for CreateVpcConnection and DeleteVpcConnection operations.</p>', ], ], 'VpcConnectionState' => [ 'base' => '<p>The state of a configuration.</p>', 'refs' => [ 'DescribeVpcConnectionResponse$State' => '<p>The state of the VPC connection. The possible states are AVAILABLE, INACTIVE, DEACTIVATING, DELETING, CREATING, REJECTING, REJECTED and FAILED.</p>', 'CreateVpcConnectionResponse$State' => '<p>The state of the VPC connection. The only possible state is CREATING.</p>', 'DeleteVpcConnectionResponse$State' => '<p>The state of the VPC connection. The only possible state is DELETING.</p>', ], ], '__boolean' => [ 'base' => NULL, 'refs' => [ 'CloudWatchLogs$Enabled' => '<p>Specifies whether broker logs get sent to the specified CloudWatch Logs destination.</p>', 'ConsumerGroupReplication$DetectAndCopyNewConsumerGroups' => '<p>Enables synchronization of consumer groups to target cluster.</p>', 'ConsumerGroupReplication$SynchroniseConsumerGroupOffsets' => '<p>Enables synchronization of consumer group offsets to target cluster. The translated offsets will be written to topic __consumer_offsets.</p>', 'ConsumerGroupReplicationUpdate$DetectAndCopyNewConsumerGroups' => '<p>Enables synchronization of consumer groups to target cluster.</p>', 'ConsumerGroupReplicationUpdate$SynchroniseConsumerGroupOffsets' => '<p>Enables synchronization of consumer group offsets to target cluster. The translated offsets will be written to topic __consumer_offsets.</p>', 'DescribeReplicatorResponse$IsReplicatorReference' => '<p>Whether this resource is a replicator reference.</p>', 'EncryptionInTransit$InCluster' => '<p>When set to true, it indicates that data communication among the broker nodes of the cluster is encrypted. When set to false, the communication happens in plaintext.</p> <p>The default value is true.</p>', 'Firehose$Enabled' => '<p>Specifies whether broker logs get sent to the specified Kinesis Data Firehose delivery stream.</p>', 'IAM$Enabled' => '<p>IAM authentication is enabled or not.</p>', 'JmxExporter$EnabledInBroker' => '<p>Indicates whether you want to enable or disable the JMX Exporter.</p>', 'JmxExporterInfo$EnabledInBroker' => '<p>JMX Exporter being enabled in broker.</p>', 'NodeExporter$EnabledInBroker' => '<p>Indicates whether you want to enable or disable the Node Exporter.</p>', 'NodeExporterInfo$EnabledInBroker' => '<p>Node Exporter being enabled in broker.</p>', 'ProvisionedThroughput$Enabled' => '<p>Provisioned throughput is enabled or not.</p>', 'ReplicatorSummary$IsReplicatorReference' => '<p>Whether this resource is a replicator reference.</p>', 'S3$Enabled' => '<p>Specifies whether broker logs get sent to the specified Amazon S3 destination.</p>', 'Scram$Enabled' => '<p>SASL/SCRAM authentication is enabled or not.</p>', 'Tls$Enabled' => '<p>TLS authentication is enabled or not.</p>', 'TopicReplication$CopyAccessControlListsForTopics' => '<p>Whether to periodically configure remote topic ACLs to match their corresponding upstream topics.</p>', 'TopicReplication$CopyTopicConfigurations' => '<p>Whether to periodically configure remote topics to match their corresponding upstream topics.</p>', 'TopicReplication$DetectAndCopyNewTopics' => '<p>Whether to periodically check for new topics and partitions.</p>', 'TopicReplicationUpdate$CopyAccessControlListsForTopics' => '<p>Whether to periodically configure remote topic ACLs to match their corresponding upstream topics.</p>', 'TopicReplicationUpdate$CopyTopicConfigurations' => '<p>Whether to periodically configure remote topics to match their corresponding upstream topics.</p>', 'TopicReplicationUpdate$DetectAndCopyNewTopics' => '<p>Whether to periodically check for new topics and partitions.</p>', 'Unauthenticated$Enabled' => '<p>Specifies whether you want to enable or disable unauthenticated traffic to your cluster.</p>', 'VpcConnectivityIAM$Enabled' => '<p>SASL/IAM authentication for VPC connectivity is on or off.</p>', 'VpcConnectivityScram$Enabled' => '<p>SASL/SCRAM authentication for VPC connectivity is on or off.</p>', 'VpcConnectivityTls$Enabled' => '<p>TLS authentication for VPC connectivity is on or off.</p>', ], ], '__double' => [ 'base' => NULL, 'refs' => [ 'BrokerNodeInfo$BrokerId' => '<p>The ID of the broker.</p>', 'ZookeeperNodeInfo$ZookeeperId' => '<p>The role-specific ID for Zookeeper.</p>', ], ], '__integer' => [ 'base' => NULL, 'refs' => [ 'BrokerEBSVolumeInfo$VolumeSizeGB' => ' <p>Size of the EBS volume to update.</p> ', 'ClusterInfo$NumberOfBrokerNodes' => ' <p>The number of broker nodes in the cluster.</p> ', 'CreateClusterRequest$NumberOfBrokerNodes' => ' <p>The number of broker nodes in the cluster.</p> ', 'MutableClusterInfo$NumberOfBrokerNodes' => ' <p>The number of broker nodes in the cluster.</p> ', 'ProvisionedThroughput$VolumeThroughput' => ' <p>Throughput value of the EBS volumes for the data drive on each kafka broker node in MiB per second.</p> ', 'UpdateStorageRequest$VolumeSizeGB' => ' <p>size of the EBS volume to update.</p> ', ], ], '__integerMin1Max15' => [ 'base' => NULL, 'refs' => [ 'CreateClusterRequest$NumberOfBrokerNodes' => '<p>The number of Apache Kafka broker nodes in the Amazon MSK cluster.</p>', 'UpdateBrokerCountRequest$TargetNumberOfBrokerNodes' => '<p>The number of broker nodes that you want the cluster to have after this operation completes successfully.</p>', ], ], '__integerMin1Max16384' => [ 'base' => NULL, 'refs' => [ 'EBSStorageInfo$VolumeSize' => '<p>The size in GiB of the EBS volume for the data drive on each broker node.</p>', ], ], '__listOfBrokerEBSVolumeInfo' => [ 'base' => NULL, 'refs' => [ 'MutableClusterInfo$BrokerEBSVolumeInfo' => '<p>Specifies the size of the EBS volume and the ID of the associated broker.</p>', 'UpdateBrokerStorageRequest$TargetBrokerEBSVolumeInfo' => '<p>Describes the target volume size and the ID of the broker to apply the update to.</p> <p>The value you specify for Target-Volume-in-GiB must be a whole number that is greater than 100 GiB.</p> <p>The storage per broker after the update operation can\'t exceed 16384 GiB.</p>', ], ], '__listOfClusterInfo' => [ 'base' => NULL, 'refs' => [ 'ListClustersResponse$ClusterInfoList' => '<p>Information on each of the MSK clusters in the response.</p>', ], ], '__listOfCluster' => [ 'base' => NULL, 'refs' => [ 'ListClustersV2Response$ClusterInfoList' => '<p>Information on each of the MSK clusters in the response.</p>', ], ], '__listOfKafkaCluster' => [ 'base' => NULL, 'refs' => [ 'CreateReplicatorRequest$KafkaClusters' => '<p>Kafka Clusters to use in setting up sources / targets for replication.</p>', ], ], '__listOfKafkaClusterDescription' => [ 'base' => NULL, 'refs' => [ 'DescribeReplicatorResponse$KafkaClusters' => '<p>Kafka Clusters used in setting up sources / targets for replication.</p>', ], ], '__listOfKafkaClusterSummary' => [ 'base' => NULL, 'refs' => [ 'ReplicatorSummary$KafkaClustersSummary' => '<p>Kafka Clusters used in setting up sources / targets for replication.</p>', ], ], '__listOfReplicationInfo' => [ 'base' => NULL, 'refs' => [ 'CreateReplicatorRequest$ReplicationInfoList' => '<p>A list of replication configurations, where each configuration targets a given source cluster to target cluster replication flow.</p>', ], ], '__listOfReplicationInfoDescription' => [ 'base' => NULL, 'refs' => [ 'DescribeReplicatorResponse$ReplicationInfoList' => '<p>A list of replication configurations, where each configuration targets a given source cluster to target cluster replication flow.</p>', ], ], '__listOfReplicationInfoSummary' => [ 'base' => NULL, 'refs' => [ 'ReplicatorSummary$ReplicationInfoSummaryList' => '<p>A list of summarized information of replications between clusters.</p>', ], ], '__listOfReplicatorSummary' => [ 'base' => NULL, 'refs' => [ 'ListReplicatorsResponse$Replicators' => '<p>List containing information of each of the replicators in the account.</p>', ], ], '__listOfVpcConfig' => [ 'base' => NULL, 'refs' => [ 'ServerlessRequest$VpcConfigs' => '<p>Information on vpc config for the serverless cluster.</p>', 'Serverless$VpcConfigs' => '<p>Information on vpc config for the serverless cluster.</p>', ], ], '__listOfClusterOperationInfo' => [ 'base' => NULL, 'refs' => [ 'ListClusterOperationsResponse$ClusterOperationInfoList' => '<p>An array of cluster operation information objects.</p>', ], ], '__listOfClusterOperationStep' => [ 'base' => NULL, 'refs' => [ 'ClusterOperationInfo$OperationSteps' => '<p>Steps completed during the operation.</p>', ], ], '__listOfCompatibleKafkaVersion' => [ 'base' => NULL, 'refs' => [ 'GetCompatibleKafkaVersionsResponse$CompatibleKafkaVersions' => '<p>A list of CompatibleKafkaVersion objects.</p>', ], ], '__listOfConfiguration' => [ 'base' => NULL, 'refs' => [ 'ListConfigurationsResponse$Configurations' => '<p>An array of MSK configurations.</p>', ], ], '__listOfConfigurationRevision' => [ 'base' => NULL, 'refs' => [ 'ListConfigurationRevisionsResponse$Revisions' => '<p>List of ConfigurationRevision objects.</p>', ], ], '__listOfKafkaVersion' => [ 'base' => NULL, 'refs' => [ 'ListKafkaVersionsResponse$KafkaVersions' => '<p>An array of Apache Kafka version objects.</p>', ], ], '__listOfNodeInfo' => [ 'base' => NULL, 'refs' => [ 'ListNodesResponse$NodeInfoList' => '<p>List containing a NodeInfo object.</p>', ], ], '__listOfClientVpcConnection' => [ 'base' => NULL, 'refs' => [ 'ListClientVpcConnectionsResponse$ClientVpcConnections' => '<p>List containing a ClientVpcConnection object.</p>', ], ], '__listOfVpcConnection' => [ 'base' => NULL, 'refs' => [ 'ListVpcConnectionsResponse$VpcConnections' => '<p>List containing a VpcConnection object.</p>', ], ], '__listOfUnprocessedScramSecret' => [ 'base' => NULL, 'refs' => [ 'BatchAssociateScramSecretResponse$UnprocessedScramSecrets' => '<p>List of errors when associating secrets to cluster.</p>', 'BatchDisassociateScramSecretResponse$UnprocessedScramSecrets' => '<p>List of errors when disassociating secrets to cluster.</p>', ], ], '__listOf__double' => [ 'base' => NULL, 'refs' => [ 'BrokerCountUpdateInfo$CreatedBrokerIds' => '<p>List of Broker Ids when creating new Brokers in a cluster.</p>', 'BrokerCountUpdateInfo$DeletedBrokerIds' => '<p>List of Broker Ids when deleting existing Brokers in a cluster.</p>', ], ], '__listOf__string' => [ 'base' => NULL, 'refs' => [ 'BatchAssociateScramSecretRequest$SecretArnList' => '<p>List of AWS Secrets Manager secret ARNs.</p>', 'BatchDisassociateScramSecretRequest$SecretArnList' => '<p>List of AWS Secrets Manager secret ARNs.</p>', 'BrokerNodeGroupInfo$ClientSubnets' => '<p>The list of subnets to connect to in the client virtual private cloud (VPC). AWS creates elastic network interfaces inside these subnets. Client applications use elastic network interfaces to produce and consume data. Client subnets can\'t occupy the Availability Zone with ID use use1-az3.</p>', 'BrokerNodeGroupInfo$SecurityGroups' => '<p>The AWS security groups to associate with the elastic network interfaces in order to specify who can connect to and communicate with the Amazon MSK cluster. If you don\'t specify a security group, Amazon MSK uses the default security group associated with the VPC. If you specify security groups that were shared with you, you must ensure that you have permissions to them. Specifically, you need the ec2:DescribeSecurityGroups permission.</p>', 'BrokerNodeGroupInfo$ZoneIds' => '<p>The zoneIds for the cluster.</p>', 'BrokerNodeInfo$Endpoints' => '<p>Endpoints for accessing the broker.</p>', 'Configuration$KafkaVersions' => '<p>An array of the versions of Apache Kafka with which you can use this MSK configuration. You can use this configuration for an MSK cluster only if the Apache Kafka version specified for the cluster appears in this array.</p>', 'ControllerNodeInfo$Endpoints' => '<p>Endpoints for accessing the Controller.</p>', 'CreateConfigurationRequest$KafkaVersions' => '<p>The versions of Apache Kafka with which you can use this MSK configuration.</p>', 'CreateVpcConnectionRequest$ClientSubnets' => '<p>The list of subnets in the client VPC.</p>', 'CreateVpcConnectionRequest$SecurityGroups' => '<p>The list of security groups to attach to the VPC connection.</p>', 'CreateVpcConnectionResponse$ClientSubnets' => '<p>The list of subnets in the client VPC.</p>', 'CreateVpcConnectionResponse$SecurityGroups' => '<p>The list of security groups attached to the VPC connection.</p>', 'DescribeConfigurationResponse$KafkaVersions' => '<p>The versions of Apache Kafka with which you can use this MSK configuration.</p>', 'DescribeVpcConnectionResponse$SecurityGroups' => '<p>The list of security groups attached to the VPC connection.</p>', 'DescribeVpcConnectionResponse$Subnets' => '<p>The list of subnets in the client VPC.</p>', 'ListScramSecretsResponse$SecretArnList' => '<p>The list of scram secrets associated with the cluster.</p>', 'RebootBrokerRequest$BrokerIds' => '<p>The list of broker ids to be rebooted.</p>', 'Tls$CertificateAuthorityArnList' => '<p>List of ACM Certificate Authority ARNs.</p>', 'ZookeeperNodeInfo$Endpoints' => '<p>Endpoints for accessing the ZooKeeper.</p>', 'KafkaClusterClientVpcConfig$SecurityGroupIds' => '<p>The security groups to attach to the ENIs for the broker nodes.</p>', 'KafkaClusterClientVpcConfig$SubnetIds' => '<p>The list of subnets in the client VPC to connect to.</p>', ], ], '__listOf__stringMax249' => [ 'base' => NULL, 'refs' => [ 'TopicReplication$TopicsToExclude' => '<p>List of regular expression patterns indicating the topics that should not be replicated.</p>', 'TopicReplication$TopicsToReplicate' => '<p>List of regular expression patterns indicating the topics to copy.</p>', 'TopicReplicationUpdate$TopicsToExclude' => '<p>List of regular expression patterns indicating the topics that should not be replicated.</p>', 'TopicReplicationUpdate$TopicsToReplicate' => '<p>List of regular expression patterns indicating the topics to copy.</p>', ], ], '__listOf__stringMax256' => [ 'base' => NULL, 'refs' => [ 'ConsumerGroupReplication$ConsumerGroupsToExclude' => '<p>List of regular expression patterns indicating the consumer groups that should not be replicated.</p>', 'ConsumerGroupReplication$ConsumerGroupsToReplicate' => '<p>List of regular expression patterns indicating the consumer groups to copy.</p>', 'ConsumerGroupReplicationUpdate$ConsumerGroupsToExclude' => '<p>List of regular expression patterns indicating the consumer groups that should not be replicated.</p>', 'ConsumerGroupReplicationUpdate$ConsumerGroupsToReplicate' => '<p>List of regular expression patterns indicating the consumer groups to copy.</p>', ], ], '__long' => [ 'base' => NULL, 'refs' => [ 'BrokerSoftwareInfo$ConfigurationRevision' => '<p>The revision of the configuration to use. This field isn\'t visible in this preview release.</p>', 'ConfigurationRevision$Revision' => '<p>The revision number.</p>', 'DescribeConfigurationRevisionResponse$Revision' => '<p>The revision number.</p>', 'ConfigurationInfo$Revision' => '<p>The revision of the configuration to use.</p>', ], ], '__mapOf__string' => [ 'base' => NULL, 'refs' => [ 'ClusterInfo$Tags' => '<p>Tags attached to the cluster.</p>', 'CreateClusterRequest$Tags' => '<p>Create tags when creating the cluster.</p>', 'CreateReplicatorRequest$Tags' => '<p>List of tags to attach to created Replicator.</p>', 'CreateVpcConnectionRequest$Tags' => '<p>Create tags when creating the VPC connection.</p>', 'CreateVpcConnectionResponse$Tags' => '<p>Tags attached to the VPC connection.</p>', 'DescribeReplicatorResponse$Tags' => '<p>List of tags attached to the Replicator.</p>', 'DescribeVpcConnectionResponse$Tags' => '<p>Tags attached to the VPC connection.</p>', 'ListTagsForResourceResponse$Tags' => '<p>The key-value pair for the resource tag.</p>', 'TagResourceRequest$Tags' => '<p>The key-value pair for the resource tag.</p>', 'VpcConnection$Tags' => '<p>Tags attached to the VPC connection.</p>', ], ], '__string' => [ 'base' => NULL, 'refs' => [ 'AmazonMskCluster$MskClusterArn' => '<p>The Amazon Resource Name (ARN) of an Amazon MSK cluster.</p>', 'BatchAssociateScramSecretResponse$ClusterArn' => '<p>The Amazon Resource Name (ARN) of the cluster.</p>', 'BatchDisassociateScramSecretResponse$ClusterArn' => '<p>The Amazon Resource Name (ARN) of the cluster.</p>', 'BrokerEBSVolumeInfo$KafkaBrokerNodeId' => '<p>The ID of the broker to update.</p>', 'BrokerNodeInfo$AttachedENIId' => '<p>The attached elastic network interface of the broker.</p>', 'BrokerNodeInfo$ClientSubnet' => '<p>The client subnet to which this broker node belongs.</p>', 'BrokerNodeInfo$ClientVpcIpAddress' => '<p>The virtual private cloud (VPC) of the client.</p>', 'BrokerSoftwareInfo$ConfigurationArn' => '<p>The Amazon Resource Name (ARN) of the configuration used for the cluster. This field isn\'t visible in this preview release.</p>', 'BrokerSoftwareInfo$KafkaVersion' => '<p>The version of Apache Kafka.</p>', 'ClientVpcConnection$Authentication' => '<p>The VPC connection authentication type.</p>', 'ClientVpcConnection$Owner' => '<p>The owner of the VPC connection.</p>', 'ClientVpcConnection$VpcConnectionArn' => '<p>The Amazon Resource Name (ARN) of the VPC connection.</p>', 'CloudWatchLogs$LogGroup' => '<p>The CloudWatch log group that is the destination for broker logs.</p>', 'ClusterInfo$ActiveOperationArn' => '<p>Arn of active cluster operation.</p>', 'ClusterInfo$ClusterArn' => '<p>The Amazon Resource Name (ARN) that uniquely identifies the cluster.</p>', 'ClusterInfo$ClusterName' => '<p>The name of the cluster.</p>', 'ClusterInfo$CurrentVersion' => '<p>The current version of the MSK cluster. Cluster versions aren\'t simple integers. You can obtain the current version by describing the cluster. An example version is KTVPDKIKX0DER.</p>', 'ClusterInfo$ZookeeperConnectString' => '<p>The connection string to use to connect to the Apache ZooKeeper cluster.</p>', 'ClusterInfo$ZookeeperConnectStringTls' => '<p>The connection string to use to connect to zookeeper cluster on Tls port.</p>', 'ClusterOperationInfo$ClientRequestId' => '<p>The ID of the API request that triggered this operation.</p>', 'ClusterOperationInfo$ClusterArn' => '<p>ARN of the cluster.</p>', 'ClusterOperationInfo$OperationArn' => '<p>ARN of the cluster operation.</p>', 'ClusterOperationInfo$OperationState' => '<p>State of the cluster operation.</p>', 'ClusterOperationInfo$OperationType' => '<p>Type of the cluster operation.</p>', 'ClusterOperationStep$StepName' => '<p>The name of the step.</p>', 'ClusterOperationStepInfo$StepStatus' => '<p>The steps current status.</p>', 'Configuration$Arn' => '<p>The Amazon Resource Name (ARN) of the configuration.</p>', 'Configuration$Description' => '<p>The description of the configuration.</p>', 'Configuration$Name' => '<p>The name of the configuration. Configuration names are strings that match the regex "^[0-9A-Za-z-]+$".</p>', 'ConfigurationInfo$Arn' => '<p>ARN of the configuration to use.</p>', 'ConfigurationRevision$Description' => '<p>The description of the configuration revision.</p>', 'CreateClusterResponse$ClusterArn' => '<p>The Amazon Resource Name (ARN) of the cluster.</p>', 'CreateClusterResponse$ClusterName' => '<p>The name of the MSK cluster.</p>', 'CreateConfigurationRequest$Description' => '<p>The description of the configuration.</p>', 'CreateConfigurationRequest$Name' => '<p>The name of the configuration. Configuration names are strings that match the regex "^[0-9A-Za-z-]+$".</p>', 'CreateConfigurationResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the configuration.</p>', 'CreateConfigurationResponse$Name' => '<p>The name of the configuration. Configuration names are strings that match the regex "^[0-9A-Za-z-]+$".</p>', 'CreateReplicatorRequest$ServiceExecutionRoleArn' => '<p>The ARN of the IAM role used by the replicator to access resources in the customer\'s account (e.g source and target clusters)</p>', 'CreateReplicatorResponse$ReplicatorArn' => '<p>The Amazon Resource Name (ARN) of the replicator.</p>', 'CreateReplicatorResponse$ReplicatorName' => '<p>Name of the replicator provided by the customer.</p>', 'CreateVpcConnectionRequest$TargetClusterArn' => '<p>The Amazon Resource Name (ARN) of the cluster.</p>', 'CreateVpcConnectionRequest$VpcId' => '<p>The VPC ID of the VPC connection.</p>', 'CreateVpcConnectionResponse$VpcConnectionArn' => '<p>The Amazon Resource Name (ARN) of the VPC connection.</p>', 'CreateVpcConnectionResponse$VpcId' => '<p>The VPC ID of the VPC connection.</p>', 'DeleteClusterResponse$ClusterArn' => '<p>The Amazon Resource Name (ARN) of the cluster.</p>', 'DeleteConfigurationRequest$Arn' => '<p>The Amazon Resource Name (ARN) of the configuration.</p>', 'DeleteConfigurationResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the configuration.</p>', 'DeleteReplicatorResponse$ReplicatorArn' => '<p>The Amazon Resource Name (ARN) of the replicator.</p>', 'DeleteVpcConnectionResponse$VpcConnectionArn' => '<p>The Amazon Resource Name (ARN) of the VPC connection.</p>', 'DescribeConfigurationResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the configuration.</p>', 'DescribeConfigurationResponse$Description' => '<p>The description of the configuration.</p>', 'DescribeConfigurationResponse$Name' => '<p>The name of the configuration. Configuration names are strings that match the regex "^[0-9A-Za-z-]+$".</p>', 'DescribeConfigurationRevisionResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the configuration.</p>', 'DescribeConfigurationRevisionResponse$Description' => '<p>The description of the configuration.</p>', 'DescribeReplicatorResponse$CurrentVersion' => '<p>The current version number of the replicator.</p>', 'DescribeReplicatorResponse$ReplicatorArn' => '<p>The Amazon Resource Name (ARN) of the replicator.</p>', 'DescribeReplicatorResponse$ReplicatorDescription' => '<p>The description of the replicator.</p>', 'DescribeReplicatorResponse$ReplicatorName' => '<p>The name of the replicator.</p>', 'DescribeReplicatorResponse$ReplicatorResourceArn' => '<p>The Amazon Resource Name (ARN) of the replicator resource in the region where the replicator was created.</p>', 'DescribeReplicatorResponse$ServiceExecutionRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role used by the replicator to access resources in the customer\'s account (e.g source and target clusters)</p>', 'DescribeVpcConnectionResponse$Authentication' => '<p>The authentication type of the VPC connection.</p>', 'DescribeVpcConnectionResponse$TargetClusterArn' => '<p>The Amazon Resource Name (ARN) of the cluster.</p>', 'DescribeVpcConnectionResponse$VpcConnectionArn' => '<p>The Amazon Resource Name (ARN) of the VPC connection.</p>', 'DescribeVpcConnectionResponse$VpcId' => '<p>The VPC ID of the VPC connection.</p>', 'EncryptionAtRest$DataVolumeKMSKeyId' => '<p>The ARN of the AWS KMS key for encrypting data at rest. If you don\'t specify a KMS key, MSK creates one for you and uses it.</p>', 'Error$InvalidParameter' => '<p>The parameter that caused the error.</p>', 'Error$Message' => '<p>The description of the error.</p>', 'ErrorInfo$ErrorCode' => '<p>A number describing the error programmatically.</p>', 'ErrorInfo$ErrorString' => '<p>An optional field to provide more details about the error.</p>', 'Firehose$DeliveryStream' => '<p>The Kinesis Data Firehose delivery stream that is the destination for broker logs.</p>', 'GetBootstrapBrokersResponse$BootstrapBrokerString' => '<p>A string containing one or more hostname:port pairs.</p>', 'GetBootstrapBrokersResponse$BootstrapBrokerStringTls' => '<p>A string containing one or more DNS names (or IP addresses) and TLS port pairs. The following is an example.</p> <programlisting>{ "BootstrapBrokerStringTls": "b-3.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9094,b-1.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9094,b-2.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9094"}</programlisting>', 'GetBootstrapBrokersResponse$BootstrapBrokerStringSaslScram' => '<p>A string containing one or more DNS names (or IP addresses) and SASL SCRAM port pairs. The following is an example.</p> <programlisting>{ "BootstrapBrokerStringSaslScram": "b-3.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9096,b-1.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9096,b-2.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9096"}</programlisting>', 'GetBootstrapBrokersResponse$BootstrapBrokerStringSaslIam' => '<p>A string that contains one or more DNS names (or IP addresses) and SASL IAM port pairs. The following is an example.</p> <programlisting>{ "BootstrapBrokerStringSaslIam": "b-3.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9098,b-1.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9098,b-2.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9098"}</programlisting>', 'GetBootstrapBrokersResponse$BootstrapBrokerStringPublicTls' => '<p>A string containing one or more DNS names (or IP addresses) and TLS port pairs. The following is an example.</p> <programlisting>{ "BootstrapBrokerStringTls": "b-3.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9194,b-1.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9194,b-2.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9194"}</programlisting>', 'GetBootstrapBrokersResponse$BootstrapBrokerStringPublicSaslScram' => '<p>A string containing one or more DNS names (or IP addresses) and SASL SCRAM port pairs. The following is an example.</p> <programlisting>{ "BootstrapBrokerStringSaslScram": "b-3.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9196,b-1.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9196,b-2.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9196"}</programlisting>', 'GetBootstrapBrokersResponse$BootstrapBrokerStringPublicSaslIam' => '<p>A string that contains one or more DNS names (or IP addresses) and SASL IAM port pairs. The following is an example.</p> <programlisting>{ "BootstrapBrokerStringSaslIam": "b-3.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9198,b-1.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9198,b-2.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9198"}</programlisting>', 'GetBootstrapBrokersResponse$BootstrapBrokerStringVpcConnectivitySaslIam' => '<p>A string containing one or more dns name (or IP) and SASL IAM port pairs for VPC connectivity.</p>', 'GetBootstrapBrokersResponse$BootstrapBrokerStringVpcConnectivitySaslScram' => '<p>A string containing one or more dns name (or IP) and SASL SCRAM port pairs for VPC connectivity.</p>', 'GetBootstrapBrokersResponse$BootstrapBrokerStringVpcConnectivityTls' => '<p>A string containing one or more dns name (or IP) and Tls port pairs for VPC connectivity.</p>', 'GetClusterPolicyResponse$CurrentVersion' => '<p>Cluster policy version.</p>', 'GetClusterPolicyResponse$Policy' => '<p>Cluster policy attached to the MSK cluster.</p>', 'KafkaVersion$Version' => '<p>The Apache Kafka version.</p>', 'KafkaClusterDescription$KafkaClusterAlias' => '<p>The alias of the Kafka cluster. Used to prefix names of replicated topics.</p> ', 'KafkaClusterSummary$KafkaClusterAlias' => '<p>The alias of the Kafka cluster. Used to prefix names of replicated topics.</p> ', 'ListClientVpcConnectionsResponse$NextToken' => '<p>If the response of ListClientVpcConnections is truncated, it returns a NextToken in the response. This Nexttoken should be sent in the subsequent request to ListClientVpcConnections.</p>', 'ListClusterOperationsResponse$NextToken' => '<p>If the response of ListClusterOperations is truncated, it returns a NextToken in the response. This Nexttoken should be sent in the subsequent request to ListClusterOperations.</p>', 'ListClustersResponse$NextToken' => '<p>The paginated results marker. When the result of a ListClusters operation is truncated, the call returns NextToken in the response. To get another batch of clusters, provide this token in your next request.</p>', 'ListConfigurationRevisionsResponse$NextToken' => '<p>Paginated results marker.</p>', 'ListConfigurationsResponse$NextToken' => '<p>The paginated results marker. When the result of a ListConfigurations operation is truncated, the call returns NextToken in the response. To get another batch of configurations, provide this token in your next request.</p>', 'ListKafkaVersionsResponse$NextToken' => '<p>Paginated results marker.</p>', 'ListNodesResponse$NextToken' => '<p>The paginated results marker. When the result of a ListNodes operation is truncated, the call returns NextToken in the response. To get another batch of nodes, provide this token in your next request.</p>', 'ListReplicatorsResponse$NextToken' => '<p>If the response of ListReplicators is truncated, it returns a NextToken in the response. This NextToken should be sent in the subsequent request to ListReplicators.</p>', 'ListScramSecretsResponse$NextToken' => '<p>Paginated results marker.</p>', 'ListVpcConnectionsResponse$NextToken' => '<p>If the response of ListVpcConnections is truncated, it returns a NextToken in the response. This NextToken should be sent in the subsequent request to ListVpcConnections.</p>', 'MutableClusterInfo$KafkaVersion' => '<p>The Apache Kafka version.</p>', 'NodeInfo$AddedToClusterTime' => '<p>The start time.</p>', 'NodeInfo$InstanceType' => '<p>The instance type.</p>', 'NodeInfo$NodeARN' => '<p>The Amazon Resource Name (ARN) of the node.</p>', 'PublicAccess$Type' => '<p>The value DISABLED indicates that public access is disabled. SERVICE_PROVIDED_EIPS indicates that public access is enabled.</p>', 'PutClusterPolicyResponse$CurrentVersion' => '<p>Cluster policy version.</p>', 'RebootBrokerResponse$ClusterArn' => '<p>The Amazon Resource Name (ARN) of the cluster.</p>', 'RebootBrokerResponse$ClusterOperationArn' => '<p>The Amazon Resource Name (ARN) of the cluster operation.</p>', 'ReplicationInfo$SourceKafkaClusterArn' => '<p>The ARN of the source Kafka cluster.</p>', 'ReplicationInfo$TargetKafkaClusterArn' => '<p>The ARN of the target Kafka cluster.</p>', 'ReplicationInfoDescription$SourceKafkaClusterAlias' => '<p>The alias of the source Kafka cluster.</p>', 'ReplicationInfoDescription$TargetKafkaClusterAlias' => '<p>The alias of the target Kafka cluster.</p>', 'ReplicationInfoSummary$SourceKafkaClusterAlias' => '<p>The alias of the source Kafka cluster.</p>', 'ReplicationInfoSummary$TargetKafkaClusterAlias' => '<p>The alias of the target Kafka cluster.</p>', 'ReplicationStateInfo$Code' => '<p>Code that describes the current state of the replicator.</p>', 'ReplicationStateInfo$Message' => '<p>Message that describes the state of the replicator.</p>', 'ReplicatorSummary$CurrentVersion' => '<p>The current version of the replicator.</p>', 'ReplicatorSummary$ReplicatorArn' => '<p>The Amazon Resource Name (ARN) of the replicator.</p>', 'ReplicatorSummary$ReplicatorName' => '<p>The name of the replicator.</p>', 'ReplicatorSummary$ReplicatorResourceArn' => 'The Amazon Resource Name (ARN) of the replicator resource in the region where the replicator was created.</p>', 'S3$Bucket' => '<p>The name of the S3 bucket that is the destination for broker logs.</p>', 'S3$Prefix' => '<p>The S3 prefix that is the destination for broker logs.</p>', 'StateInfo$Code' => '<p>If the cluster is in an unusable state, this field contains the code that describes the issue.</p>', 'StateInfo$Message' => '<p>If the cluster is in an unusable state, this field contains a message that describes the issue.</p>', 'UpdateBrokerCountRequest$CurrentVersion' => '<p>The current version of the cluster.</p>', 'UpdateBrokerCountResponse$ClusterArn' => '<p>The Amazon Resource Name (ARN) of the cluster.</p>', 'UpdateBrokerCountResponse$ClusterOperationArn' => '<p>The Amazon Resource Name (ARN) of the cluster operation.</p>', 'UpdateBrokerTypeRequest$CurrentVersion' => '<p>The current version of the cluster.</p>', 'UpdateBrokerTypeRequest$TargetInstanceType' => '<p>The Amazon MSK broker type that you want all of the brokers in this cluster to be.</p>', 'UpdateBrokerTypeResponse$ClusterArn' => '<p>The Amazon Resource Name (ARN) of the cluster.</p>', 'UpdateBrokerTypeResponse$ClusterOperationArn' => '<p>The Amazon Resource Name (ARN) of the cluster operation.</p>', 'UpdateBrokerStorageRequest$CurrentVersion' => '<p>The version of cluster to update from. A successful operation will then generate a new version.</p>', 'UpdateBrokerStorageResponse$ClusterArn' => '<p>The Amazon Resource Name (ARN) of the cluster.</p>', 'UpdateBrokerStorageResponse$ClusterOperationArn' => '<p>The Amazon Resource Name (ARN) of the cluster operation.</p>', 'UpdateConfigurationRequest$Description' => '<p>The description of the configuration.</p>', 'UpdateConfigurationRequest$Arn' => '<p>The Amazon Resource Name (ARN) of the configuration.</p>', 'UpdateConfigurationResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the configuration.</p>', 'UpdateConnectivityRequest$CurrentVersion' => '<p>The current version of the cluster.</p>', 'UpdateConnectivityResponse$ClusterArn' => '<p>The Amazon Resource Name (ARN) of the cluster.</p>', 'UpdateConnectivityResponse$ClusterOperationArn' => '<p>The Amazon Resource Name (ARN) of the cluster operation.</p>', 'UpdateClusterConfigurationRequest$CurrentVersion' => '<p>The version of the cluster that you want to update.</p>', 'UpdateClusterConfigurationResponse$ClusterArn' => '<p>The Amazon Resource Name (ARN) of the cluster.</p>', 'UpdateClusterConfigurationResponse$ClusterOperationArn' => '<p>The Amazon Resource Name (ARN) of the cluster operation.</p>', 'UpdateClusterKafkaVersionRequest$CurrentVersion' => '<p>Current cluster version.</p>', 'UpdateClusterKafkaVersionRequest$TargetKafkaVersion' => '<p>Target Apache Kafka version.</p>', 'UpdateClusterKafkaVersionResponse$ClusterArn' => '<p>The Amazon Resource Name (ARN) of the cluster.</p>', 'UpdateClusterKafkaVersionResponse$ClusterOperationArn' => '<p>The Amazon Resource Name (ARN) of the cluster operation.</p>', 'UpdateMonitoringRequest$CurrentVersion' => '<p>The version of cluster to update from. A successful operation will then generate a new version.</p>', 'UpdateMonitoringResponse$ClusterArn' => '<p>The Amazon Resource Name (ARN) of the cluster.</p>', 'UpdateMonitoringResponse$ClusterOperationArn' => '<p>The Amazon Resource Name (ARN) of the cluster operation.</p>', 'UpdateReplicationInfoRequest$CurrentVersion' => '<p>Current replicator version.</p>', 'UpdateReplicationInfoRequest$SourceKafkaClusterArn' => '<p>The ARN of the source Kafka cluster.</p>', 'UpdateReplicationInfoRequest$TargetKafkaClusterArn' => '<p>The ARN of the target Kafka cluster.</p>', 'UpdateReplicationInfoResponse$ReplicatorArn' => '<p>The Amazon Resource Name (ARN) of the replicator.</p>', 'UpdateSecurityRequest$CurrentVersion' => '<p>You can use the DescribeCluster operation to get the current version of the cluster. After the security update is complete, the cluster will have a new version.</p>', 'UpdateSecurityResponse$ClusterArn' => '<p>The Amazon Resource Name (ARN) of the cluster.</p>', 'UpdateSecurityResponse$ClusterOperationArn' => '<p>The Amazon Resource Name (ARN) of the cluster operation.</p>', 'UpdateStorageRequest$CurrentVersion' => '<p>The version of cluster to update from. A successful operation will then generate a new version.</p>', 'UpdateStorageResponse$ClusterArn' => '<p>The Amazon Resource Name (ARN) of the cluster.</p>', 'UpdateStorageResponse$ClusterOperationArn' => '<p>The Amazon Resource Name (ARN) of the cluster operation.</p>', 'VpcConnection$Authentication' => '<p>The authentication type for the VPC connection.</p>', 'VpcConnection$TargetClusterArn' => '<p>The Amazon Resource Name (ARN) of the cluster.</p>', 'VpcConnection$VpcConnectionArn' => '<p>The Amazon Resource Name (ARN) of the VPC connection.</p>', 'VpcConnection$VpcId' => '<p>The VPC ID of the VPC connection.</p>', 'ZookeeperNodeInfo$AttachedENIId' => '<p>The attached elastic network interface of the zookeeper.</p>', 'ZookeeperNodeInfo$ClientVpcIpAddress' => '<p>The virtual private cloud (VPC) IP address of the client.</p>', 'ZookeeperNodeInfo$ZookeeperVersion' => '<p>The version of Zookeeper.</p>', '__listOf__string$member' => NULL, '__mapOf__string$member' => NULL, ], ], '__stringMax1024' => [ 'base' => NULL, 'refs' => [ 'CreateReplicatorRequest$Description' => '<p>A summary description of the replicator.</p>', ], ], '__stringMax249' => [ 'base' => NULL, 'refs' => [ '__listOf__stringMax249$member' => NULL, ], ], '__stringMax256' => [ 'base' => NULL, 'refs' => [ '__listOf__stringMax256$member' => NULL, ], ], '__stringMin1' => [ 'base' => NULL, 'refs' => [ 'PutClusterPolicyRequest$CurrentVersion' => '<p>Current cluster policy version.</p>', 'RejectClientVpcConnectionRequest$VpcConnectionArn' => '<p>VPC connection ARN.</p>', ], ], '__stringMin1Max128' => [ 'base' => NULL, 'refs' => [ 'CreateClusterRequest$KafkaVersion' => '<p>The version of Apache Kafka.</p>', ], ], '__stringMin1Max20480' => [ 'base' => NULL, 'refs' => [ 'PutClusterPolicyRequest$Policy' => '<p>Cluster policy for cluster.</p>', ], ], '__stringMin1Max64' => [ 'base' => NULL, 'refs' => [ 'CreateClusterRequest$ClusterName' => '<p>The name of the cluster.</p>', ], ], '__stringMin3Max10' => [ 'base' => NULL, 'refs' => [ 'CreateVpcConnectionRequest$Authentication' => NULL, 'CreateVpcConnectionResponse$Authentication' => '<p>The authentication type for the VPC connection.</p>', ], ], '__stringMin5Max32' => [ 'base' => NULL, 'refs' => [ 'BrokerNodeGroupInfo$InstanceType' => '<p>The type of broker used in the Amazon MSK cluster.</p>', 'MutableClusterInfo$InstanceType' => '<p>The Amazon MSK broker type that you want all of the brokers in this cluster to be.</p>', ], ], '__stringMin1Max128Pattern09AZaZ09AZaZ0' => [ 'base' => NULL, 'refs' => [ 'CreateReplicatorRequest$ReplicatorName' => '<p>The name of the replicator. Alpha-numeric characters with \'-\' are allowed.</p>', ], ], '__timestampIso8601' => [ 'base' => NULL, 'refs' => [ 'ClientVpcConnection$CreationTime' => '<p>The creation time of the VPC connection.</p>', 'ClusterInfo$CreationTime' => '<p>The time when the cluster was created.</p>', 'ClusterOperationInfo$CreationTime' => '<p>The time at which operation was created.</p>', 'ClusterOperationInfo$EndTime' => '<p>The time at which the operation finished.</p>', 'Configuration$CreationTime' => '<p>The time when the configuration was created.</p>', 'ConfigurationRevision$CreationTime' => '<p>The time when the configuration revision was created.</p>', 'CreateConfigurationResponse$CreationTime' => '<p>The time when the configuration was created.</p>', 'CreateVpcConnectionResponse$CreationTime' => '<p>The time when the VPC connection was created.</p>', 'DescribeConfigurationResponse$CreationTime' => '<p>The time when the configuration was created.</p>', 'DescribeConfigurationRevisionResponse$CreationTime' => '<p>The time when the configuration was created.</p>', 'DescribeVpcConnectionResponse$CreationTime' => '<p>The creation time of the VPC connection.</p>', 'DescribeReplicatorResponse$CreationTime' => '<p>The time when the replicator was created.</p>', 'ReplicatorSummary$CreationTime' => '<p>The time the replicator was created.</p>', 'VpcConnection$CreationTime' => '<p>The creation time of the VPC connection.</p>', ], ], ],];
