<?php
// This file was auto-generated from sdk-root/src/data/kinesisvideo/2017-09-30/docs-2.json
return [ 'version' => '2.0', 'service' => '<p/>', 'operations' => [ 'CreateSignalingChannel' => '<p>Creates a signaling channel. </p> <p> <code>CreateSignalingChannel</code> is an asynchronous operation.</p>', 'CreateStream' => '<p>Creates a new Kinesis video stream. </p> <p>When you create a new stream, Kinesis Video Streams assigns it a version number. When you change the stream\'s metadata, Kinesis Video Streams updates the version. </p> <p> <code>CreateStream</code> is an asynchronous operation.</p> <p>For information about how the service works, see <a href="https://docs.aws.amazon.com/kinesisvideostreams/latest/dg/how-it-works.html">How it Works</a>. </p> <p>You must have permissions for the <code>KinesisVideo:CreateStream</code> action.</p>', 'DeleteEdgeConfiguration' => '<p>An asynchronous API that deletes a stream’s existing edge configuration, as well as the corresponding media from the Edge Agent.</p> <p>When you invoke this API, the sync status is set to <code>DELETING</code>. A deletion process starts, in which active edge jobs are stopped and all media is deleted from the edge device. The time to delete varies, depending on the total amount of stored media. If the deletion process fails, the sync status changes to <code>DELETE_FAILED</code>. You will need to re-try the deletion.</p> <p>When the deletion process has completed successfully, the edge configuration is no longer accessible.</p>', 'DeleteSignalingChannel' => '<p>Deletes a specified signaling channel. <code>DeleteSignalingChannel</code> is an asynchronous operation. If you don\'t specify the channel\'s current version, the most recent version is deleted.</p>', 'DeleteStream' => '<p>Deletes a Kinesis video stream and the data contained in the stream. </p> <p>This method marks the stream for deletion, and makes the data in the stream inaccessible immediately.</p> <p> </p> <p> To ensure that you have the latest version of the stream before deleting it, you can specify the stream version. Kinesis Video Streams assigns a version to each stream. When you update a stream, Kinesis Video Streams assigns a new version number. To get the latest stream version, use the <code>DescribeStream</code> API. </p> <p>This operation requires permission for the <code>KinesisVideo:DeleteStream</code> action.</p>', 'DescribeEdgeConfiguration' => '<p>Describes a stream’s edge configuration that was set using the <code>StartEdgeConfigurationUpdate</code> API and the latest status of the edge agent\'s recorder and uploader jobs. Use this API to get the status of the configuration to determine if the configuration is in sync with the Edge Agent. Use this API to evaluate the health of the Edge Agent.</p>', 'DescribeImageGenerationConfiguration' => '<p>Gets the <code>ImageGenerationConfiguration</code> for a given Kinesis video stream.</p>', 'DescribeMappedResourceConfiguration' => '<p>Returns the most current information about the stream. The <code>streamName</code> or <code>streamARN</code> should be provided in the input.</p>', 'DescribeMediaStorageConfiguration' => '<p>Returns the most current information about the channel. Specify the <code>ChannelName</code> or <code>ChannelARN</code> in the input.</p>', 'DescribeNotificationConfiguration' => '<p>Gets the <code>NotificationConfiguration</code> for a given Kinesis video stream.</p>', 'DescribeSignalingChannel' => '<p>Returns the most current information about the signaling channel. You must specify either the name or the Amazon Resource Name (ARN) of the channel that you want to describe.</p>', 'DescribeStream' => '<p>Returns the most current information about the specified stream. You must specify either the <code>StreamName</code> or the <code>StreamARN</code>. </p>', 'GetDataEndpoint' => '<p>Gets an endpoint for a specified stream for either reading or writing. Use this endpoint in your application to read from the specified stream (using the <code>GetMedia</code> or <code>GetMediaForFragmentList</code> operations) or write to it (using the <code>PutMedia</code> operation). </p> <note> <p>The returned endpoint does not have the API name appended. The client needs to add the API name to the returned endpoint.</p> </note> <p>In the request, specify the stream either by <code>StreamName</code> or <code>StreamARN</code>.</p>', 'GetSignalingChannelEndpoint' => '<p>Provides an endpoint for the specified signaling channel to send and receive messages. This API uses the <code>SingleMasterChannelEndpointConfiguration</code> input parameter, which consists of the <code>Protocols</code> and <code>Role</code> properties.</p> <p> <code>Protocols</code> is used to determine the communication mechanism. For example, if you specify <code>WSS</code> as the protocol, this API produces a secure websocket endpoint. If you specify <code>HTTPS</code> as the protocol, this API generates an HTTPS endpoint. </p> <p> <code>Role</code> determines the messaging permissions. A <code>MASTER</code> role results in this API generating an endpoint that a client can use to communicate with any of the viewers on the channel. A <code>VIEWER</code> role results in this API generating an endpoint that a client can use to communicate only with a <code>MASTER</code>. </p>', 'ListEdgeAgentConfigurations' => '<p>Returns an array of edge configurations associated with the specified Edge Agent.</p> <p>In the request, you must specify the Edge Agent <code>HubDeviceArn</code>.</p>', 'ListSignalingChannels' => '<p>Returns an array of <code>ChannelInfo</code> objects. Each object describes a signaling channel. To retrieve only those channels that satisfy a specific condition, you can specify a <code>ChannelNameCondition</code>.</p>', 'ListStreams' => '<p>Returns an array of <code>StreamInfo</code> objects. Each object describes a stream. To retrieve only streams that satisfy a specific condition, you can specify a <code>StreamNameCondition</code>. </p>', 'ListTagsForResource' => '<p>Returns a list of tags associated with the specified signaling channel.</p>', 'ListTagsForStream' => '<p>Returns a list of tags associated with the specified stream.</p> <p>In the request, you must specify either the <code>StreamName</code> or the <code>StreamARN</code>. </p>', 'StartEdgeConfigurationUpdate' => '<p>An asynchronous API that updates a stream’s existing edge configuration. The Kinesis Video Stream will sync the stream’s edge configuration with the Edge Agent IoT Greengrass component that runs on an IoT Hub Device, setup at your premise. The time to sync can vary and depends on the connectivity of the Hub Device. The <code>SyncStatus</code> will be updated as the edge configuration is acknowledged, and synced with the Edge Agent. </p> <p>If this API is invoked for the first time, a new edge configuration will be created for the stream, and the sync status will be set to <code>SYNCING</code>. You will have to wait for the sync status to reach a terminal state such as: <code>IN_SYNC</code>, or <code>SYNC_FAILED</code>, before using this API again. If you invoke this API during the syncing process, a <code>ResourceInUseException</code> will be thrown. The connectivity of the stream’s edge configuration and the Edge Agent will be retried for 15 minutes. After 15 minutes, the status will transition into the <code>SYNC_FAILED</code> state.</p> <p>To move an edge configuration from one device to another, use <a>DeleteEdgeConfiguration</a> to delete the current edge configuration. You can then invoke StartEdgeConfigurationUpdate with an updated Hub Device ARN.</p>', 'TagResource' => '<p>Adds one or more tags to a signaling channel. A <i>tag</i> is a key-value pair (the value is optional) that you can define and assign to Amazon Web Services resources. If you specify a tag that already exists, the tag value is replaced with the value that you specify in the request. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation Tags</a> in the <i>Billing and Cost Management and Cost Management User Guide</i>.</p>', 'TagStream' => '<p>Adds one or more tags to a stream. A <i>tag</i> is a key-value pair (the value is optional) that you can define and assign to Amazon Web Services resources. If you specify a tag that already exists, the tag value is replaced with the value that you specify in the request. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation Tags</a> in the <i>Billing and Cost Management and Cost Management User Guide</i>. </p> <p>You must provide either the <code>StreamName</code> or the <code>StreamARN</code>.</p> <p>This operation requires permission for the <code>KinesisVideo:TagStream</code> action.</p> <p>A Kinesis video stream can support up to 50 tags.</p>', 'UntagResource' => '<p>Removes one or more tags from a signaling channel. In the request, specify only a tag key or keys; don\'t specify the value. If you specify a tag key that does not exist, it\'s ignored.</p>', 'UntagStream' => '<p>Removes one or more tags from a stream. In the request, specify only a tag key or keys; don\'t specify the value. If you specify a tag key that does not exist, it\'s ignored.</p> <p>In the request, you must provide the <code>StreamName</code> or <code>StreamARN</code>.</p>', 'UpdateDataRetention' => '<p>Increases or decreases the stream\'s data retention period by the value that you specify. To indicate whether you want to increase or decrease the data retention period, specify the <code>Operation</code> parameter in the request body. In the request, you must specify either the <code>StreamName</code> or the <code>StreamARN</code>. </p> <p>This operation requires permission for the <code>KinesisVideo:UpdateDataRetention</code> action.</p> <p>Changing the data retention period affects the data in the stream as follows:</p> <ul> <li> <p>If the data retention period is increased, existing data is retained for the new retention period. For example, if the data retention period is increased from one hour to seven hours, all existing data is retained for seven hours.</p> </li> <li> <p>If the data retention period is decreased, existing data is retained for the new retention period. For example, if the data retention period is decreased from seven hours to one hour, all existing data is retained for one hour, and any data older than one hour is deleted immediately.</p> </li> </ul>', 'UpdateImageGenerationConfiguration' => '<p>Updates the <code>StreamInfo</code> and <code>ImageProcessingConfiguration</code> fields.</p>', 'UpdateMediaStorageConfiguration' => '<p>Associates a <code>SignalingChannel</code> to a stream to store the media. There are two signaling modes that you can specify :</p> <ul> <li> <p>If <code>StorageStatus</code> is enabled, the data will be stored in the <code>StreamARN</code> provided. In order for WebRTC Ingestion to work, the stream must have data retention enabled.</p> </li> <li> <p>If <code>StorageStatus</code> is disabled, no data will be stored, and the <code>StreamARN</code> parameter will not be needed. </p> </li> </ul> <important> <p>If <code>StorageStatus</code> is enabled, direct peer-to-peer (master-viewer) connections no longer occur. Peers connect directly to the storage session. You must call the <code>JoinStorageSession</code> API to trigger an SDP offer send and establish a connection between a peer and the storage session. </p> </important>', 'UpdateNotificationConfiguration' => '<p>Updates the notification information for a stream.</p>', 'UpdateSignalingChannel' => '<p>Updates the existing signaling channel. This is an asynchronous operation and takes time to complete. </p> <p>If the <code>MessageTtlSeconds</code> value is updated (either increased or reduced), it only applies to new messages sent via this channel after it\'s been updated. Existing messages are still expired as per the previous <code>MessageTtlSeconds</code> value.</p>', 'UpdateStream' => '<p>Updates stream metadata, such as the device name and media type.</p> <p>You must provide the stream name or the Amazon Resource Name (ARN) of the stream.</p> <p>To make sure that you have the latest version of the stream before updating it, you can specify the stream version. Kinesis Video Streams assigns a version to each stream. When you update a stream, Kinesis Video Streams assigns a new version number. To get the latest stream version, use the <code>DescribeStream</code> API. </p> <p> <code>UpdateStream</code> is an asynchronous operation, and takes time to complete.</p>', ], 'shapes' => [ 'APIName' => [ 'base' => NULL, 'refs' => [ 'GetDataEndpointInput$APIName' => '<p>The name of the API action for which to get an endpoint.</p>', ], ], 'AccessDeniedException' => [ 'base' => '<p>You do not have required permissions to perform this operation.</p>', 'refs' => [], ], 'AccountChannelLimitExceededException' => [ 'base' => '<p>You have reached the maximum limit of active signaling channels for this Amazon Web Services account in this region.</p>', 'refs' => [], ], 'AccountStreamLimitExceededException' => [ 'base' => '<p>The number of streams created for the account is too high.</p>', 'refs' => [], ], 'ChannelInfo' => [ 'base' => '<p>A structure that encapsulates a signaling channel\'s metadata and properties.</p>', 'refs' => [ 'ChannelInfoList$member' => NULL, 'DescribeSignalingChannelOutput$ChannelInfo' => '<p>A structure that encapsulates the specified signaling channel\'s metadata and properties.</p>', ], ], 'ChannelInfoList' => [ 'base' => NULL, 'refs' => [ 'ListSignalingChannelsOutput$ChannelInfoList' => '<p>An array of <code>ChannelInfo</code> objects.</p>', ], ], 'ChannelName' => [ 'base' => NULL, 'refs' => [ 'ChannelInfo$ChannelName' => '<p>The name of the signaling channel.</p>', 'ChannelNameCondition$ComparisonValue' => '<p>A value to compare.</p>', 'CreateSignalingChannelInput$ChannelName' => '<p>A name for the signaling channel that you are creating. It must be unique for each Amazon Web Services account and Amazon Web Services Region.</p>', 'DescribeMediaStorageConfigurationInput$ChannelName' => '<p>The name of the channel.</p>', 'DescribeSignalingChannelInput$ChannelName' => '<p>The name of the signaling channel that you want to describe.</p>', ], ], 'ChannelNameCondition' => [ 'base' => '<p>An optional input parameter for the <code>ListSignalingChannels</code> API. When this parameter is specified while invoking <code>ListSignalingChannels</code>, the API returns only the channels that satisfy a condition specified in <code>ChannelNameCondition</code>.</p>', 'refs' => [ 'ListSignalingChannelsInput$ChannelNameCondition' => '<p>Optional: Returns only the channels that satisfy a specific condition.</p>', ], ], 'ChannelProtocol' => [ 'base' => NULL, 'refs' => [ 'ListOfProtocols$member' => NULL, 'ResourceEndpointListItem$Protocol' => '<p>The protocol of the signaling channel returned by the <code>GetSignalingChannelEndpoint</code> API.</p>', ], ], 'ChannelRole' => [ 'base' => NULL, 'refs' => [ 'SingleMasterChannelEndpointConfiguration$Role' => '<p>This property is used to determine messaging permissions in this <code>SINGLE_MASTER</code> signaling channel. If <code>MASTER</code> is specified, this API returns an endpoint that a client can use to receive offers from and send answers to any of the viewers on this signaling channel. If <code>VIEWER</code> is specified, this API returns an endpoint that a client can use only to send offers to another <code>MASTER</code> client on this signaling channel. </p>', ], ], 'ChannelType' => [ 'base' => NULL, 'refs' => [ 'ChannelInfo$ChannelType' => '<p>The type of the signaling channel.</p>', 'CreateSignalingChannelInput$ChannelType' => '<p>A type of the signaling channel that you are creating. Currently, <code>SINGLE_MASTER</code> is the only supported channel type. </p>', ], ], 'ClientLimitExceededException' => [ 'base' => '<p>Kinesis Video Streams has throttled the request because you have exceeded the limit of allowed client calls. Try making the call later.</p>', 'refs' => [], ], 'ComparisonOperator' => [ 'base' => NULL, 'refs' => [ 'ChannelNameCondition$ComparisonOperator' => '<p>A comparison operator. Currently, you can only specify the <code>BEGINS_WITH</code> operator, which finds signaling channels whose names begin with a given prefix.</p>', 'StreamNameCondition$ComparisonOperator' => '<p>A comparison operator. Currently, you can specify only the <code>BEGINS_WITH</code> operator, which finds streams whose names start with a given prefix.</p>', ], ], 'ConfigurationStatus' => [ 'base' => NULL, 'refs' => [ 'ImageGenerationConfiguration$Status' => '<p>Indicates whether the <code>ContinuousImageGenerationConfigurations</code> API is enabled or disabled.</p>', 'NotificationConfiguration$Status' => '<p>Indicates if a notification configuration is enabled or disabled.</p>', ], ], 'CreateSignalingChannelInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateSignalingChannelOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateStreamInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateStreamOutput' => [ 'base' => NULL, 'refs' => [], ], 'DataEndpoint' => [ 'base' => NULL, 'refs' => [ 'GetDataEndpointOutput$DataEndpoint' => '<p>The endpoint value. To read data from the stream or to write data to it, specify this endpoint in your application.</p>', ], ], 'DataRetentionChangeInHours' => [ 'base' => NULL, 'refs' => [ 'UpdateDataRetentionInput$DataRetentionChangeInHours' => '<p>The number of hours to adjust the current retention by. The value you specify is added to or subtracted from the current value, depending on the <code>operation</code>.</p> <p>The minimum value for data retention is 0 and the maximum value is 87600 (ten years).</p>', ], ], 'DataRetentionInHours' => [ 'base' => NULL, 'refs' => [ 'CreateStreamInput$DataRetentionInHours' => '<p>The number of hours that you want to retain the data in the stream. Kinesis Video Streams retains the data in a data store that is associated with the stream.</p> <p>The default value is 0, indicating that the stream does not persist data.</p> <p>When the <code>DataRetentionInHours</code> value is 0, consumers can still consume the fragments that remain in the service host buffer, which has a retention time limit of 5 minutes and a retention memory limit of 200 MB. Fragments are removed from the buffer when either limit is reached.</p>', 'StreamInfo$DataRetentionInHours' => '<p>How long the stream retains data, in hours.</p>', ], ], 'DeleteAfterUpload' => [ 'base' => NULL, 'refs' => [ 'DeletionConfig$DeleteAfterUpload' => '<p>The <code>boolean</code> value used to indicate whether or not you want to mark the media for deletion, once it has been uploaded to the Kinesis Video Stream cloud. The media files can be deleted if any of the deletion configuration values are set to <code>true</code>, such as when the limit for the <code>EdgeRetentionInHours</code>, or the <code>MaxLocalMediaSizeInMB</code>, has been reached. </p> <p>Since the default value is set to <code>true</code>, configure the uploader schedule such that the media files are not being deleted before they are initially uploaded to the Amazon Web Services cloud.</p>', ], ], 'DeleteEdgeConfigurationInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEdgeConfigurationOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSignalingChannelInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSignalingChannelOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStreamInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStreamOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeletionConfig' => [ 'base' => '<p>The configuration details required to delete the connection of the stream from the Edge Agent.</p>', 'refs' => [ 'EdgeConfig$DeletionConfig' => '<p>The deletion configuration is made up of the retention time (<code>EdgeRetentionInHours</code>) and local size configuration (<code>LocalSizeConfig</code>) details that are used to make the deletion.</p>', ], ], 'DescribeEdgeConfigurationInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEdgeConfigurationOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeImageGenerationConfigurationInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeImageGenerationConfigurationOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMappedResourceConfigurationInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMappedResourceConfigurationOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMediaStorageConfigurationInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMediaStorageConfigurationOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeNotificationConfigurationInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeNotificationConfigurationOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSignalingChannelInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSignalingChannelOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStreamInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStreamOutput' => [ 'base' => NULL, 'refs' => [], ], 'DestinationRegion' => [ 'base' => NULL, 'refs' => [ 'ImageGenerationDestinationConfig$DestinationRegion' => '<p>The Amazon Web Services Region of the S3 bucket where images will be delivered. This <code>DestinationRegion</code> must match the Region where the stream is located.</p>', ], ], 'DestinationUri' => [ 'base' => NULL, 'refs' => [ 'ImageGenerationDestinationConfig$Uri' => '<p>The Uniform Resource Identifier (URI) that identifies where the images will be delivered.</p>', 'NotificationDestinationConfig$Uri' => '<p>The Uniform Resource Identifier (URI) that identifies where the images will be delivered.</p>', ], ], 'DeviceName' => [ 'base' => NULL, 'refs' => [ 'CreateStreamInput$DeviceName' => '<p>The name of the device that is writing to the stream. </p> <note> <p>In the current implementation, Kinesis Video Streams does not use this name.</p> </note>', 'StreamInfo$DeviceName' => '<p>The name of the device that is associated with the stream.</p>', 'UpdateStreamInput$DeviceName' => '<p>The name of the device that is writing to the stream. </p> <note> <p> In the current implementation, Kinesis Video Streams does not use this name. </p> </note>', ], ], 'DeviceStreamLimitExceededException' => [ 'base' => '<p>Not implemented. </p>', 'refs' => [], ], 'DurationInSeconds' => [ 'base' => NULL, 'refs' => [ 'ScheduleConfig$DurationInSeconds' => '<p>The total duration to record the media. If the <code>ScheduleExpression</code> attribute is provided, then the <code>DurationInSeconds</code> attribute should also be specified.</p>', ], ], 'EdgeAgentStatus' => [ 'base' => '<p>An object that contains the latest status details for an edge agent\'s recorder and uploader jobs. Use this information to determine the current health of an edge agent.</p>', 'refs' => [ 'DescribeEdgeConfigurationOutput$EdgeAgentStatus' => '<p>An object that contains the latest status details for an edge agent\'s recorder and uploader jobs. Use this information to determine the current health of an edge agent.</p>', ], ], 'EdgeConfig' => [ 'base' => '<p>A description of the stream\'s edge configuration that will be used to sync with the Edge Agent IoT Greengrass component. The Edge Agent component will run on an IoT Hub Device setup at your premise.</p>', 'refs' => [ 'DescribeEdgeConfigurationOutput$EdgeConfig' => '<p>A description of the stream\'s edge configuration that will be used to sync with the Edge Agent IoT Greengrass component. The Edge Agent component will run on an IoT Hub Device setup at your premise.</p>', 'ListEdgeAgentConfigurationsEdgeConfig$EdgeConfig' => NULL, 'StartEdgeConfigurationUpdateInput$EdgeConfig' => '<p>The edge configuration details required to invoke the update process.</p>', 'StartEdgeConfigurationUpdateOutput$EdgeConfig' => '<p>A description of the stream\'s edge configuration that will be used to sync with the Edge Agent IoT Greengrass component. The Edge Agent component will run on an IoT Hub Device setup at your premise.</p>', ], ], 'EdgeRetentionInHours' => [ 'base' => NULL, 'refs' => [ 'DeletionConfig$EdgeRetentionInHours' => '<p>The number of hours that you want to retain the data in the stream on the Edge Agent. The default value of the retention time is 720 hours, which translates to 30 days.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => NULL, 'AccountChannelLimitExceededException$Message' => NULL, 'AccountStreamLimitExceededException$Message' => NULL, 'ClientLimitExceededException$Message' => NULL, 'DeviceStreamLimitExceededException$Message' => NULL, 'InvalidArgumentException$Message' => NULL, 'InvalidDeviceException$Message' => NULL, 'InvalidResourceFormatException$Message' => NULL, 'NoDataRetentionException$Message' => NULL, 'NotAuthorizedException$Message' => NULL, 'ResourceInUseException$Message' => NULL, 'ResourceNotFoundException$Message' => NULL, 'StreamEdgeConfigurationNotFoundException$Message' => NULL, 'TagsPerResourceExceededLimitException$Message' => NULL, 'VersionMismatchException$Message' => NULL, ], ], 'FailedStatusDetails' => [ 'base' => NULL, 'refs' => [ 'DescribeEdgeConfigurationOutput$FailedStatusDetails' => '<p>A description of the generated failure status.</p>', 'ListEdgeAgentConfigurationsEdgeConfig$FailedStatusDetails' => '<p>A description of the generated failure status.</p>', 'StartEdgeConfigurationUpdateOutput$FailedStatusDetails' => '<p>A description of the generated failure status.</p>', ], ], 'Format' => [ 'base' => NULL, 'refs' => [ 'ImageGenerationConfiguration$Format' => '<p>The accepted image format.</p>', ], ], 'FormatConfig' => [ 'base' => NULL, 'refs' => [ 'ImageGenerationConfiguration$FormatConfig' => '<p>The list of a key-value pair structure that contains extra parameters that can be applied when the image is generated. The <code>FormatConfig</code> key is the <code>JPEGQuality</code>, which indicates the JPEG quality key to be used to generate the image. The <code>FormatConfig</code> value accepts ints from 1 to 100. If the value is 1, the image will be generated with less quality and the best compression. If the value is 100, the image will be generated with the best quality and less compression. If no value is provided, the default value of the <code>JPEGQuality</code> key will be set to 80.</p>', ], ], 'FormatConfigKey' => [ 'base' => NULL, 'refs' => [ 'FormatConfig$key' => NULL, ], ], 'FormatConfigValue' => [ 'base' => NULL, 'refs' => [ 'FormatConfig$value' => NULL, ], ], 'GetDataEndpointInput' => [ 'base' => NULL, 'refs' => [], ], 'GetDataEndpointOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetSignalingChannelEndpointInput' => [ 'base' => NULL, 'refs' => [], ], 'GetSignalingChannelEndpointOutput' => [ 'base' => NULL, 'refs' => [], ], 'HeightPixels' => [ 'base' => NULL, 'refs' => [ 'ImageGenerationConfiguration$HeightPixels' => '<p>The height of the output image that is used in conjunction with the <code>WidthPixels</code> parameter. When both <code>HeightPixels</code> and <code>WidthPixels</code> parameters are provided, the image will be stretched to fit the specified aspect ratio. If only the <code>HeightPixels</code> parameter is provided, its original aspect ratio will be used to calculate the <code>WidthPixels</code> ratio. If neither parameter is provided, the original image size will be returned.</p>', ], ], 'HubDeviceArn' => [ 'base' => NULL, 'refs' => [ 'EdgeConfig$HubDeviceArn' => '<p>The "<b>Internet of Things (IoT) Thing</b>" Arn of the stream.</p>', 'ListEdgeAgentConfigurationsInput$HubDeviceArn' => '<p>The "Internet of Things (IoT) Thing" Arn of the edge agent.</p>', ], ], 'ImageGenerationConfiguration' => [ 'base' => '<p>The structure that contains the information required for the KVS images delivery. If null, the configuration will be deleted from the stream.</p>', 'refs' => [ 'DescribeImageGenerationConfigurationOutput$ImageGenerationConfiguration' => '<p>The structure that contains the information required for the Kinesis video stream (KVS) images delivery. If this structure is null, the configuration will be deleted from the stream.</p>', 'UpdateImageGenerationConfigurationInput$ImageGenerationConfiguration' => '<p>The structure that contains the information required for the KVS images delivery. If the structure is null, the configuration will be deleted from the stream.</p>', ], ], 'ImageGenerationDestinationConfig' => [ 'base' => '<p>The structure that contains the information required to deliver images to a customer.</p>', 'refs' => [ 'ImageGenerationConfiguration$DestinationConfig' => '<p>The structure that contains the information required to deliver images to a customer.</p>', ], ], 'ImageSelectorType' => [ 'base' => NULL, 'refs' => [ 'ImageGenerationConfiguration$ImageSelectorType' => '<p>The origin of the Server or Producer timestamps to use to generate the images.</p>', ], ], 'InvalidArgumentException' => [ 'base' => '<p>The value for this input parameter is invalid.</p>', 'refs' => [], ], 'InvalidDeviceException' => [ 'base' => '<p>Not implemented.</p>', 'refs' => [], ], 'InvalidResourceFormatException' => [ 'base' => '<p>The format of the <code>StreamARN</code> is invalid.</p>', 'refs' => [], ], 'JobStatusDetails' => [ 'base' => NULL, 'refs' => [ 'LastRecorderStatus$JobStatusDetails' => '<p>A description of a recorder job’s latest status.</p>', 'LastUploaderStatus$JobStatusDetails' => '<p>A description of an uploader job’s latest status.</p>', ], ], 'KmsKeyId' => [ 'base' => NULL, 'refs' => [ 'CreateStreamInput$KmsKeyId' => '<p>The ID of the Key Management Service (KMS) key that you want Kinesis Video Streams to use to encrypt stream data.</p> <p>If no key ID is specified, the default, Kinesis Video-managed key (<code>Amazon Web Services/kinesisvideo</code>) is used.</p> <p> For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters">DescribeKey</a>. </p>', 'StreamInfo$KmsKeyId' => '<p>The ID of the Key Management Service (KMS) key that Kinesis Video Streams uses to encrypt data on the stream.</p>', ], ], 'LastRecorderStatus' => [ 'base' => '<p>The latest status of a stream\'s edge recording job.</p>', 'refs' => [ 'EdgeAgentStatus$LastRecorderStatus' => '<p>The latest status of a stream’s edge recording job.</p>', ], ], 'LastUploaderStatus' => [ 'base' => '<p>The latest status of a stream’s edge to cloud uploader job.</p>', 'refs' => [ 'EdgeAgentStatus$LastUploaderStatus' => '<p>The latest status of a stream’s edge to cloud uploader job.</p>', ], ], 'ListEdgeAgentConfigurationsEdgeConfig' => [ 'base' => '<p>A description of a single stream\'s edge configuration.</p>', 'refs' => [ 'ListEdgeAgentConfigurationsEdgeConfigList$member' => NULL, ], ], 'ListEdgeAgentConfigurationsEdgeConfigList' => [ 'base' => NULL, 'refs' => [ 'ListEdgeAgentConfigurationsOutput$EdgeConfigs' => '<p>A description of a single stream\'s edge configuration.</p>', ], ], 'ListEdgeAgentConfigurationsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListEdgeAgentConfigurationsInputLimit' => [ 'base' => NULL, 'refs' => [ 'ListEdgeAgentConfigurationsInput$MaxResults' => '<p>The maximum number of edge configurations to return in the response. The default is 5.</p>', ], ], 'ListEdgeAgentConfigurationsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListOfProtocols' => [ 'base' => NULL, 'refs' => [ 'SingleMasterChannelEndpointConfiguration$Protocols' => '<p>This property is used to determine the nature of communication over this <code>SINGLE_MASTER</code> signaling channel. If <code>WSS</code> is specified, this API returns a websocket endpoint. If <code>HTTPS</code> is specified, this API returns an <code>HTTPS</code> endpoint.</p>', ], ], 'ListSignalingChannelsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListSignalingChannelsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListStreamsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListStreamsInputLimit' => [ 'base' => NULL, 'refs' => [ 'ListSignalingChannelsInput$MaxResults' => '<p>The maximum number of channels to return in the response. The default is 500.</p>', 'ListStreamsInput$MaxResults' => '<p>The maximum number of streams to return in the response. The default is 10,000.</p>', ], ], 'ListStreamsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForStreamInput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForStreamOutput' => [ 'base' => NULL, 'refs' => [], ], 'LocalSizeConfig' => [ 'base' => '<p>The configuration details that include the maximum size of the media (<code>MaxLocalMediaSizeInMB</code>) that you want to store for a stream on the Edge Agent, as well as the strategy that should be used (<code>StrategyOnFullSize</code>) when a stream\'s maximum size has been reached.</p>', 'refs' => [ 'DeletionConfig$LocalSizeConfig' => '<p>The value of the local size required in order to delete the edge configuration.</p>', ], ], 'MappedResourceConfigurationList' => [ 'base' => NULL, 'refs' => [ 'DescribeMappedResourceConfigurationOutput$MappedResourceConfigurationList' => '<p>A structure that encapsulates, or contains, the media storage configuration properties.</p>', ], ], 'MappedResourceConfigurationListItem' => [ 'base' => '<p>A structure that encapsulates, or contains, the media storage configuration properties.</p>', 'refs' => [ 'MappedResourceConfigurationList$member' => NULL, ], ], 'MappedResourceConfigurationListLimit' => [ 'base' => NULL, 'refs' => [ 'DescribeMappedResourceConfigurationInput$MaxResults' => '<p>The maximum number of results to return in the response.</p>', ], ], 'MaxLocalMediaSizeInMB' => [ 'base' => NULL, 'refs' => [ 'LocalSizeConfig$MaxLocalMediaSizeInMB' => '<p>The overall maximum size of the media that you want to store for a stream on the Edge Agent. </p>', ], ], 'MediaSourceConfig' => [ 'base' => '<p>The configuration details that consist of the credentials required (<code>MediaUriSecretArn</code> and <code>MediaUriType</code>) to access the media files that are streamed to the camera.</p>', 'refs' => [ 'RecorderConfig$MediaSourceConfig' => '<p>The configuration details that consist of the credentials required (<code>MediaUriSecretArn</code> and <code>MediaUriType</code>) to access the media files streamed to the camera. </p>', ], ], 'MediaStorageConfiguration' => [ 'base' => '<p>A structure that encapsulates, or contains, the media storage configuration properties.</p> <ul> <li> <p>If <code>StorageStatus</code> is enabled, the data will be stored in the <code>StreamARN</code> provided. In order for WebRTC Ingestion to work, the stream must have data retention enabled.</p> </li> <li> <p>If <code>StorageStatus</code> is disabled, no data will be stored, and the <code>StreamARN</code> parameter will not be needed. </p> </li> </ul>', 'refs' => [ 'DescribeMediaStorageConfigurationOutput$MediaStorageConfiguration' => '<p>A structure that encapsulates, or contains, the media storage configuration properties.</p>', 'UpdateMediaStorageConfigurationInput$MediaStorageConfiguration' => '<p>A structure that encapsulates, or contains, the media storage configuration properties.</p>', ], ], 'MediaStorageConfigurationStatus' => [ 'base' => NULL, 'refs' => [ 'MediaStorageConfiguration$Status' => '<p>The status of the media storage configuration.</p>', ], ], 'MediaType' => [ 'base' => NULL, 'refs' => [ 'CreateStreamInput$MediaType' => '<p>The media type of the stream. Consumers of the stream can use this information when processing the stream. For more information about media types, see <a href="http://www.iana.org/assignments/media-types/media-types.xhtml">Media Types</a>. If you choose to specify the <code>MediaType</code>, see <a href="https://tools.ietf.org/html/rfc6838#section-4.2">Naming Requirements</a> for guidelines.</p> <p>Example valid values include "video/h264" and "video/h264,audio/aac".</p> <p>This parameter is optional; the default value is <code>null</code> (or empty in JSON).</p>', 'StreamInfo$MediaType' => '<p>The <code>MediaType</code> of the stream. </p>', 'UpdateStreamInput$MediaType' => '<p>The stream\'s media type. Use <code>MediaType</code> to specify the type of content that the stream contains to the consumers of the stream. For more information about media types, see <a href="http://www.iana.org/assignments/media-types/media-types.xhtml">Media Types</a>. If you choose to specify the <code>MediaType</code>, see <a href="https://tools.ietf.org/html/rfc6838#section-4.2">Naming Requirements</a>.</p> <p>To play video on the console, you must specify the correct video type. For example, if the video in the stream is H.264, specify <code>video/h264</code> as the <code>MediaType</code>.</p>', ], ], 'MediaUriSecretArn' => [ 'base' => NULL, 'refs' => [ 'MediaSourceConfig$MediaUriSecretArn' => '<p>The Amazon Web Services Secrets Manager ARN for the username and password of the camera, or a local media file location.</p>', ], ], 'MediaUriType' => [ 'base' => NULL, 'refs' => [ 'MediaSourceConfig$MediaUriType' => '<p>The Uniform Resource Identifier (URI) type. The <code>FILE_URI</code> value can be used to stream local media files.</p> <note> <p>Preview only supports the <code>RTSP_URI</code> media source URI format .</p> </note>', ], ], 'MessageTtlSeconds' => [ 'base' => NULL, 'refs' => [ 'SingleMasterConfiguration$MessageTtlSeconds' => '<p>The period of time a signaling channel retains undelivered messages before they are discarded.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'DescribeMappedResourceConfigurationInput$NextToken' => '<p>The token to provide in your next request, to get another batch of results.</p>', 'DescribeMappedResourceConfigurationOutput$NextToken' => '<p>The token that was used in the <code>NextToken</code>request to fetch the next set of results. </p>', 'ListEdgeAgentConfigurationsInput$NextToken' => '<p>If you specify this parameter, when the result of a <code>ListEdgeAgentConfigurations</code> operation is truncated, the call returns the <code>NextToken</code> in the response. To get another batch of edge configurations, provide this token in your next request. </p>', 'ListEdgeAgentConfigurationsOutput$NextToken' => '<p>If the response is truncated, the call returns this element with a given token. To get the next batch of edge configurations, use this token in your next request.</p>', 'ListSignalingChannelsInput$NextToken' => '<p>If you specify this parameter, when the result of a <code>ListSignalingChannels</code> operation is truncated, the call returns the <code>NextToken</code> in the response. To get another batch of channels, provide this token in your next request.</p>', 'ListSignalingChannelsOutput$NextToken' => '<p>If the response is truncated, the call returns this element with a token. To get the next batch of streams, use this token in your next request.</p>', 'ListStreamsInput$NextToken' => '<p>If you specify this parameter, when the result of a <code>ListStreams</code> operation is truncated, the call returns the <code>NextToken</code> in the response. To get another batch of streams, provide this token in your next request.</p>', 'ListStreamsOutput$NextToken' => '<p>If the response is truncated, the call returns this element with a token. To get the next batch of streams, use this token in your next request. </p>', 'ListTagsForResourceInput$NextToken' => '<p>If you specify this parameter and the result of a <code>ListTagsForResource</code> call is truncated, the response includes a token that you can use in the next request to fetch the next batch of tags. </p>', 'ListTagsForResourceOutput$NextToken' => '<p>If you specify this parameter and the result of a <code>ListTagsForResource</code> call is truncated, the response includes a token that you can use in the next request to fetch the next set of tags. </p>', 'ListTagsForStreamInput$NextToken' => '<p>If you specify this parameter and the result of a <code>ListTagsForStream</code> call is truncated, the response includes a token that you can use in the next request to fetch the next batch of tags.</p>', 'ListTagsForStreamOutput$NextToken' => '<p>If you specify this parameter and the result of a <code>ListTags</code> call is truncated, the response includes a token that you can use in the next request to fetch the next set of tags.</p>', ], ], 'NoDataRetentionException' => [ 'base' => '<p>The Stream data retention in hours is equal to zero.</p>', 'refs' => [], ], 'NotAuthorizedException' => [ 'base' => '<p>The caller is not authorized to perform this operation.</p>', 'refs' => [], ], 'NotificationConfiguration' => [ 'base' => '<p>The structure that contains the notification information for the KVS images delivery. If this parameter is null, the configuration will be deleted from the stream.</p>', 'refs' => [ 'DescribeNotificationConfigurationOutput$NotificationConfiguration' => '<p>The structure that contains the information required for notifications. If the structure is null, the configuration will be deleted from the stream.</p>', 'UpdateNotificationConfigurationInput$NotificationConfiguration' => '<p>The structure containing the information required for notifications. If the structure is null, the configuration will be deleted from the stream.</p>', ], ], 'NotificationDestinationConfig' => [ 'base' => '<p>The structure that contains the information required to deliver a notification to a customer.</p>', 'refs' => [ 'NotificationConfiguration$DestinationConfig' => '<p>The destination information required to deliver a notification to a customer.</p>', ], ], 'RecorderConfig' => [ 'base' => '<p>The recorder configuration consists of the local <code>MediaSourceConfig</code> details that are used as credentials to accesss the local media files streamed on the camera. </p>', 'refs' => [ 'EdgeConfig$RecorderConfig' => '<p>The recorder configuration consists of the local <code>MediaSourceConfig</code> details, that are used as credentials to access the local media files streamed on the camera. </p>', ], ], 'RecorderStatus' => [ 'base' => NULL, 'refs' => [ 'LastRecorderStatus$RecorderStatus' => '<p>The status of the latest recorder job.</p>', ], ], 'ResourceARN' => [ 'base' => NULL, 'refs' => [ 'ChannelInfo$ChannelARN' => '<p>The Amazon Resource Name (ARN) of the signaling channel.</p>', 'CreateSignalingChannelOutput$ChannelARN' => '<p>The Amazon Resource Name (ARN) of the created channel.</p>', 'CreateStreamOutput$StreamARN' => '<p>The Amazon Resource Name (ARN) of the stream.</p>', 'DeleteEdgeConfigurationInput$StreamARN' => '<p>The Amazon Resource Name (ARN) of the stream. Specify either the <code>StreamName</code> or the <code>StreamARN</code>.</p>', 'DeleteSignalingChannelInput$ChannelARN' => '<p>The Amazon Resource Name (ARN) of the signaling channel that you want to delete.</p>', 'DeleteStreamInput$StreamARN' => '<p>The Amazon Resource Name (ARN) of the stream that you want to delete. </p>', 'DescribeEdgeConfigurationInput$StreamARN' => '<p>The Amazon Resource Name (ARN) of the stream. Specify either the <code>StreamName</code>or the <code>StreamARN</code>.</p>', 'DescribeEdgeConfigurationOutput$StreamARN' => '<p>The Amazon Resource Name (ARN) of the stream.</p>', 'DescribeImageGenerationConfigurationInput$StreamARN' => '<p>The Amazon Resource Name (ARN) of the Kinesis video stream from which to retrieve the image generation configuration. You must specify either the <code>StreamName</code> or the <code>StreamARN</code>.</p>', 'DescribeMappedResourceConfigurationInput$StreamARN' => '<p>The Amazon Resource Name (ARN) of the stream.</p>', 'DescribeMediaStorageConfigurationInput$ChannelARN' => '<p>The Amazon Resource Name (ARN) of the channel.</p>', 'DescribeNotificationConfigurationInput$StreamARN' => '<p>The Amazon Resource Name (ARN) of the Kinesis video stream from where you want to retrieve the notification configuration. You must specify either the <code>StreamName</code> or the StreamARN.</p>', 'DescribeSignalingChannelInput$ChannelARN' => '<p>The ARN of the signaling channel that you want to describe.</p>', 'DescribeStreamInput$StreamARN' => '<p>The Amazon Resource Name (ARN) of the stream.</p>', 'GetDataEndpointInput$StreamARN' => '<p>The Amazon Resource Name (ARN) of the stream that you want to get the endpoint for. You must specify either this parameter or a <code>StreamName</code> in the request. </p>', 'GetSignalingChannelEndpointInput$ChannelARN' => '<p>The Amazon Resource Name (ARN) of the signalling channel for which you want to get an endpoint.</p>', 'ListEdgeAgentConfigurationsEdgeConfig$StreamARN' => '<p>The Amazon Resource Name (ARN) of the stream.</p>', 'ListTagsForResourceInput$ResourceARN' => '<p>The Amazon Resource Name (ARN) of the signaling channel for which you want to list tags.</p>', 'ListTagsForStreamInput$StreamARN' => '<p>The Amazon Resource Name (ARN) of the stream that you want to list tags for.</p>', 'MappedResourceConfigurationListItem$ARN' => '<p>The Amazon Resource Name (ARN) of the Kinesis Video Stream resource, associated with the stream.</p>', 'MediaStorageConfiguration$StreamARN' => '<p>The Amazon Resource Name (ARN) of the stream. </p>', 'StartEdgeConfigurationUpdateInput$StreamARN' => '<p> The Amazon Resource Name (ARN) of the stream. Specify either the <code>StreamName</code> or the <code>StreamARN</code>.</p>', 'StartEdgeConfigurationUpdateOutput$StreamARN' => '<p>The Amazon Resource Name (ARN) of the stream.</p>', 'StreamInfo$StreamARN' => '<p>The Amazon Resource Name (ARN) of the stream.</p>', 'TagResourceInput$ResourceARN' => '<p>The Amazon Resource Name (ARN) of the signaling channel to which you want to add tags.</p>', 'TagStreamInput$StreamARN' => '<p>The Amazon Resource Name (ARN) of the resource that you want to add the tag or tags to.</p>', 'UntagResourceInput$ResourceARN' => '<p>The Amazon Resource Name (ARN) of the signaling channel from which you want to remove tags.</p>', 'UntagStreamInput$StreamARN' => '<p>The Amazon Resource Name (ARN) of the stream that you want to remove tags from.</p>', 'UpdateDataRetentionInput$StreamARN' => '<p>The Amazon Resource Name (ARN) of the stream whose retention period you want to change.</p>', 'UpdateImageGenerationConfigurationInput$StreamARN' => '<p>The Amazon Resource Name (ARN) of the Kinesis video stream from where you want to update the image generation configuration. You must specify either the <code>StreamName</code> or the <code>StreamARN</code>.</p>', 'UpdateMediaStorageConfigurationInput$ChannelARN' => '<p>The Amazon Resource Name (ARN) of the channel.</p>', 'UpdateNotificationConfigurationInput$StreamARN' => '<p>The Amazon Resource Name (ARN) of the Kinesis video stream from where you want to update the notification configuration. You must specify either the <code>StreamName</code> or the <code>StreamARN</code>.</p>', 'UpdateSignalingChannelInput$ChannelARN' => '<p>The Amazon Resource Name (ARN) of the signaling channel that you want to update.</p>', 'UpdateStreamInput$StreamARN' => '<p>The ARN of the stream whose metadata you want to update.</p>', ], ], 'ResourceEndpoint' => [ 'base' => NULL, 'refs' => [ 'ResourceEndpointListItem$ResourceEndpoint' => '<p>The endpoint of the signaling channel returned by the <code>GetSignalingChannelEndpoint</code> API.</p>', ], ], 'ResourceEndpointList' => [ 'base' => NULL, 'refs' => [ 'GetSignalingChannelEndpointOutput$ResourceEndpointList' => '<p>A list of endpoints for the specified signaling channel.</p>', ], ], 'ResourceEndpointListItem' => [ 'base' => '<p>An object that describes the endpoint of the signaling channel returned by the <code>GetSignalingChannelEndpoint</code> API.</p> <p>The media server endpoint will correspond to the <code>WEBRTC</code> Protocol.</p>', 'refs' => [ 'ResourceEndpointList$member' => NULL, ], ], 'ResourceInUseException' => [ 'base' => '<p>When the input <code>StreamARN</code> or <code>ChannelARN</code> in <code>CLOUD_STORAGE_MODE</code> is already mapped to a different Kinesis Video Stream resource, or if the provided input <code>StreamARN</code> or <code>ChannelARN</code> is not in Active status, try one of the following : </p> <ol> <li> <p>The <code>DescribeMediaStorageConfiguration</code> API to determine what the stream given channel is mapped to. </p> </li> <li> <p>The <code>DescribeMappedResourceConfiguration</code> API to determine the channel that the given stream is mapped to. </p> </li> <li> <p>The <code>DescribeStream</code> or <code>DescribeSignalingChannel</code> API to determine the status of the resource. </p> </li> </ol>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>Amazon Kinesis Video Streams can\'t find the stream that you specified.</p>', 'refs' => [], ], 'ResourceTags' => [ 'base' => NULL, 'refs' => [ 'CreateStreamInput$Tags' => '<p>A list of tags to associate with the specified stream. Each tag is a key-value pair (the value is optional).</p>', 'ListTagsForResourceOutput$Tags' => '<p>A map of tag keys and values associated with the specified signaling channel.</p>', 'ListTagsForStreamOutput$Tags' => '<p>A map of tag keys and values associated with the specified stream.</p>', 'TagStreamInput$Tags' => '<p>A list of tags to associate with the specified stream. Each tag is a key-value pair (the value is optional).</p>', ], ], 'SamplingInterval' => [ 'base' => NULL, 'refs' => [ 'ImageGenerationConfiguration$SamplingInterval' => '<p>The time interval in milliseconds (ms) at which the images need to be generated from the stream. The minimum value that can be provided is 200 ms. If the timestamp range is less than the sampling interval, the Image from the <code>StartTimestamp</code> will be returned if available. </p>', ], ], 'ScheduleConfig' => [ 'base' => '<p>This API enables you to specify the duration that the camera, or local media file, should record onto the Edge Agent. The <code>ScheduleConfig</code> consists of the <code>ScheduleExpression</code> and the <code>DurationInMinutes</code> attributes. </p> <p>If the <code>ScheduleConfig</code> is not provided in the <code>RecorderConfig</code>, then the Edge Agent will always be set to recording mode.</p> <p>If the <code>ScheduleConfig</code> is not provided in the <code>UploaderConfig</code>, then the Edge Agent will upload at regular intervals (every 1 hour).</p>', 'refs' => [ 'RecorderConfig$ScheduleConfig' => '<p>The configuration that consists of the <code>ScheduleExpression</code> and the <code>DurationInMinutes</code> details that specify the scheduling to record from a camera, or local media file, onto the Edge Agent. If the <code>ScheduleExpression</code> attribute is not provided, then the Edge Agent will always be set to recording mode.</p>', 'UploaderConfig$ScheduleConfig' => '<p>The configuration that consists of the <code>ScheduleExpression</code> and the <code>DurationInMinutes</code> details that specify the scheduling to record from a camera, or local media file, onto the Edge Agent. If the <code>ScheduleConfig</code> is not provided in this <code>UploaderConfig</code>, then the Edge Agent will upload at regular intervals (every 1 hour).</p>', ], ], 'ScheduleExpression' => [ 'base' => NULL, 'refs' => [ 'ScheduleConfig$ScheduleExpression' => '<p>The Quartz cron expression that takes care of scheduling jobs to record from the camera, or local media file, onto the Edge Agent. If the <code>ScheduleExpression</code> is not provided for the <code>RecorderConfig</code>, then the Edge Agent will always be set to recording mode.</p> <p>For more information about Quartz, refer to the <a href="http://www.quartz-scheduler.org/documentation/quartz-2.3.0/tutorials/crontrigger.html"> <i>Cron Trigger Tutorial</i> </a> page to understand the valid expressions and its use.</p>', ], ], 'SingleMasterChannelEndpointConfiguration' => [ 'base' => '<p>An object that contains the endpoint configuration for the <code>SINGLE_MASTER</code> channel type. </p>', 'refs' => [ 'GetSignalingChannelEndpointInput$SingleMasterChannelEndpointConfiguration' => '<p>A structure containing the endpoint configuration for the <code>SINGLE_MASTER</code> channel type.</p>', ], ], 'SingleMasterConfiguration' => [ 'base' => '<p>A structure that contains the configuration for the <code>SINGLE_MASTER</code> channel type.</p>', 'refs' => [ 'ChannelInfo$SingleMasterConfiguration' => '<p>A structure that contains the configuration for the <code>SINGLE_MASTER</code> channel type.</p>', 'CreateSignalingChannelInput$SingleMasterConfiguration' => '<p>A structure containing the configuration for the <code>SINGLE_MASTER</code> channel type. </p>', 'UpdateSignalingChannelInput$SingleMasterConfiguration' => '<p>The structure containing the configuration for the <code>SINGLE_MASTER</code> type of the signaling channel that you want to update. </p>', ], ], 'StartEdgeConfigurationUpdateInput' => [ 'base' => NULL, 'refs' => [], ], 'StartEdgeConfigurationUpdateOutput' => [ 'base' => NULL, 'refs' => [], ], 'Status' => [ 'base' => NULL, 'refs' => [ 'ChannelInfo$ChannelStatus' => '<p>Current status of the signaling channel.</p>', 'StreamInfo$Status' => '<p>The status of the stream.</p>', ], ], 'StrategyOnFullSize' => [ 'base' => NULL, 'refs' => [ 'LocalSizeConfig$StrategyOnFullSize' => '<p>The strategy to perform when a stream’s <code>MaxLocalMediaSizeInMB</code> limit is reached.</p>', ], ], 'StreamEdgeConfigurationNotFoundException' => [ 'base' => '<p>The Exception rendered when the Amazon Kinesis Video Stream can\'t find a stream\'s edge configuration that you specified. </p>', 'refs' => [], ], 'StreamInfo' => [ 'base' => '<p>An object describing a Kinesis video stream.</p>', 'refs' => [ 'DescribeStreamOutput$StreamInfo' => '<p>An object that describes the stream.</p>', 'StreamInfoList$member' => NULL, ], ], 'StreamInfoList' => [ 'base' => NULL, 'refs' => [ 'ListStreamsOutput$StreamInfoList' => '<p>An array of <code>StreamInfo</code> objects.</p>', ], ], 'StreamName' => [ 'base' => NULL, 'refs' => [ 'CreateStreamInput$StreamName' => '<p>A name for the stream that you are creating.</p> <p>The stream name is an identifier for the stream, and must be unique for each account and region.</p>', 'DeleteEdgeConfigurationInput$StreamName' => '<p>The name of the stream from which to delete the edge configuration. Specify either the <code>StreamName</code> or the <code>StreamARN</code>.</p>', 'DescribeEdgeConfigurationInput$StreamName' => '<p>The name of the stream whose edge configuration you want to update. Specify either the <code>StreamName</code> or the <code>StreamARN</code>. </p>', 'DescribeEdgeConfigurationOutput$StreamName' => '<p>The name of the stream from which the edge configuration was updated.</p>', 'DescribeImageGenerationConfigurationInput$StreamName' => '<p>The name of the stream from which to retrieve the image generation configuration. You must specify either the <code>StreamName</code> or the <code>StreamARN</code>. </p>', 'DescribeMappedResourceConfigurationInput$StreamName' => '<p>The name of the stream.</p>', 'DescribeNotificationConfigurationInput$StreamName' => '<p>The name of the stream from which to retrieve the notification configuration. You must specify either the <code>StreamName</code> or the <code>StreamARN</code>.</p>', 'DescribeStreamInput$StreamName' => '<p>The name of the stream.</p>', 'GetDataEndpointInput$StreamName' => '<p>The name of the stream that you want to get the endpoint for. You must specify either this parameter or a <code>StreamARN</code> in the request.</p>', 'ListEdgeAgentConfigurationsEdgeConfig$StreamName' => '<p>The name of the stream.</p>', 'ListTagsForStreamInput$StreamName' => '<p>The name of the stream that you want to list tags for.</p>', 'StartEdgeConfigurationUpdateInput$StreamName' => '<p>The name of the stream whose edge configuration you want to update. Specify either the <code>StreamName</code> or the <code>StreamARN</code>.</p>', 'StartEdgeConfigurationUpdateOutput$StreamName' => '<p>The name of the stream from which the edge configuration was updated.</p>', 'StreamInfo$StreamName' => '<p>The name of the stream.</p>', 'StreamNameCondition$ComparisonValue' => '<p>A value to compare.</p>', 'TagStreamInput$StreamName' => '<p>The name of the stream that you want to add the tag or tags to.</p>', 'UntagStreamInput$StreamName' => '<p>The name of the stream that you want to remove tags from.</p>', 'UpdateDataRetentionInput$StreamName' => '<p>The name of the stream whose retention period you want to change.</p>', 'UpdateImageGenerationConfigurationInput$StreamName' => '<p>The name of the stream from which to update the image generation configuration. You must specify either the <code>StreamName</code> or the <code>StreamARN</code>.</p>', 'UpdateNotificationConfigurationInput$StreamName' => '<p>The name of the stream from which to update the notification configuration. You must specify either the <code>StreamName</code> or the <code>StreamARN</code>.</p>', 'UpdateStreamInput$StreamName' => '<p>The name of the stream whose metadata you want to update.</p> <p>The stream name is an identifier for the stream, and must be unique for each account and region.</p>', ], ], 'StreamNameCondition' => [ 'base' => '<p>Specifies the condition that streams must satisfy to be returned when you list streams (see the <code>ListStreams</code> API). A condition has a comparison operation and a value. Currently, you can specify only the <code>BEGINS_WITH</code> operator, which finds streams whose names start with a given prefix. </p>', 'refs' => [ 'ListStreamsInput$StreamNameCondition' => '<p>Optional: Returns only streams that satisfy a specific condition. Currently, you can specify only the prefix of a stream name as a condition. </p>', ], ], 'SyncStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeEdgeConfigurationOutput$SyncStatus' => '<p>The latest status of the edge configuration update.</p>', 'ListEdgeAgentConfigurationsEdgeConfig$SyncStatus' => '<p>The current sync status of the stream\'s edge configuration.</p>', 'StartEdgeConfigurationUpdateOutput$SyncStatus' => '<p> The current sync status of the stream\'s edge configuration. When you invoke this API, the sync status will be set to the <code>SYNCING</code> state. Use the <code>DescribeEdgeConfiguration</code> API to get the latest status of the edge configuration.</p>', ], ], 'Tag' => [ 'base' => '<p>A key and value pair that is associated with the specified signaling channel.</p>', 'refs' => [ 'TagList$member' => NULL, 'TagOnCreateList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'ResourceTags$key' => NULL, 'Tag$Key' => '<p>The key of the tag that is associated with the specified signaling channel.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceInput$TagKeyList' => '<p>A list of the keys of the tags that you want to remove.</p>', 'UntagStreamInput$TagKeyList' => '<p>A list of the keys of the tags that you want to remove.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'TagResourceInput$Tags' => '<p>A list of tags to associate with the specified signaling channel. Each tag is a key-value pair.</p>', ], ], 'TagOnCreateList' => [ 'base' => NULL, 'refs' => [ 'CreateSignalingChannelInput$Tags' => '<p>A set of tags (key-value pairs) that you want to associate with this channel.</p>', ], ], 'TagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'TagStreamInput' => [ 'base' => NULL, 'refs' => [], ], 'TagStreamOutput' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'ResourceTags$value' => NULL, 'Tag$Value' => '<p>The value of the tag that is associated with the specified signaling channel.</p>', ], ], 'TagsPerResourceExceededLimitException' => [ 'base' => '<p>You have exceeded the limit of tags that you can associate with the resource. A Kinesis video stream can support up to 50 tags. </p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'ChannelInfo$CreationTime' => '<p>The time at which the signaling channel was created.</p>', 'DescribeEdgeConfigurationOutput$CreationTime' => '<p>The timestamp at which a stream’s edge configuration was first created.</p>', 'DescribeEdgeConfigurationOutput$LastUpdatedTime' => '<p>The timestamp at which a stream’s edge configuration was last updated.</p>', 'LastRecorderStatus$LastCollectedTime' => '<p>The timestamp at which the recorder job was last executed and media stored to local disk.</p>', 'LastRecorderStatus$LastUpdatedTime' => '<p>The timestamp at which the recorder status was last updated.</p>', 'LastUploaderStatus$LastCollectedTime' => '<p>The timestamp at which the uploader job was last executed and media collected to the cloud.</p>', 'LastUploaderStatus$LastUpdatedTime' => '<p>The timestamp at which the uploader status was last updated.</p>', 'ListEdgeAgentConfigurationsEdgeConfig$CreationTime' => '<p>The timestamp when the stream first created the edge config.</p>', 'ListEdgeAgentConfigurationsEdgeConfig$LastUpdatedTime' => '<p>The timestamp when the stream last updated the edge config.</p>', 'StartEdgeConfigurationUpdateOutput$CreationTime' => '<p>The timestamp at which a stream’s edge configuration was first created.</p>', 'StartEdgeConfigurationUpdateOutput$LastUpdatedTime' => '<p>The timestamp at which a stream’s edge configuration was last updated.</p>', 'StreamInfo$CreationTime' => '<p>A time stamp that indicates when the stream was created.</p>', ], ], 'Type' => [ 'base' => NULL, 'refs' => [ 'MappedResourceConfigurationListItem$Type' => '<p>The type of the associated resource for the kinesis video stream.</p>', ], ], 'UntagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'UntagStreamInput' => [ 'base' => NULL, 'refs' => [], ], 'UntagStreamOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDataRetentionInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDataRetentionOperation' => [ 'base' => NULL, 'refs' => [ 'UpdateDataRetentionInput$Operation' => '<p>Indicates whether you want to increase or decrease the retention period.</p>', ], ], 'UpdateDataRetentionOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateImageGenerationConfigurationInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateImageGenerationConfigurationOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMediaStorageConfigurationInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMediaStorageConfigurationOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateNotificationConfigurationInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateNotificationConfigurationOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSignalingChannelInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSignalingChannelOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateStreamInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateStreamOutput' => [ 'base' => NULL, 'refs' => [], ], 'UploaderConfig' => [ 'base' => '<p>The configuration that consists of the <code>ScheduleExpression</code> and the <code>DurationInMinutes</code> details that specify the scheduling to record from a camera, or local media file, onto the Edge Agent. If the <code>ScheduleConfig</code> is not provided in the <code>UploaderConfig</code>, then the Edge Agent will upload at regular intervals (every 1 hour). </p>', 'refs' => [ 'EdgeConfig$UploaderConfig' => '<p>The uploader configuration contains the <code>ScheduleExpression</code> details that are used to schedule upload jobs for the recorded media files from the Edge Agent to a Kinesis Video Stream.</p>', ], ], 'UploaderStatus' => [ 'base' => NULL, 'refs' => [ 'LastUploaderStatus$UploaderStatus' => '<p>The status of the latest uploader job.</p>', ], ], 'Version' => [ 'base' => NULL, 'refs' => [ 'ChannelInfo$Version' => '<p>The current version of the signaling channel.</p>', 'DeleteSignalingChannelInput$CurrentVersion' => '<p>The current version of the signaling channel that you want to delete. You can obtain the current version by invoking the <code>DescribeSignalingChannel</code> or <code>ListSignalingChannels</code> API operations.</p>', 'DeleteStreamInput$CurrentVersion' => '<p>Optional: The version of the stream that you want to delete. </p> <p>Specify the version as a safeguard to ensure that your are deleting the correct stream. To get the stream version, use the <code>DescribeStream</code> API.</p> <p>If not specified, only the <code>CreationTime</code> is checked before deleting the stream.</p>', 'StreamInfo$Version' => '<p>The version of the stream.</p>', 'UpdateDataRetentionInput$CurrentVersion' => '<p>The version of the stream whose retention period you want to change. To get the version, call either the <code>DescribeStream</code> or the <code>ListStreams</code> API.</p>', 'UpdateSignalingChannelInput$CurrentVersion' => '<p>The current version of the signaling channel that you want to update.</p>', 'UpdateStreamInput$CurrentVersion' => '<p>The version of the stream whose metadata you want to update.</p>', ], ], 'VersionMismatchException' => [ 'base' => '<p>The stream version that you specified is not the latest version. To get the latest version, use the <a href="https://docs.aws.amazon.com/kinesisvideostreams/latest/dg/API_DescribeStream.html">DescribeStream</a> API.</p>', 'refs' => [], ], 'WidthPixels' => [ 'base' => NULL, 'refs' => [ 'ImageGenerationConfiguration$WidthPixels' => '<p>The width of the output image that is used in conjunction with the <code>HeightPixels</code> parameter. When both <code>WidthPixels</code> and <code>HeightPixels</code> parameters are provided, the image will be stretched to fit the specified aspect ratio. If only the <code>WidthPixels</code> parameter is provided, its original aspect ratio will be used to calculate the <code>HeightPixels</code> ratio. If neither parameter is provided, the original image size will be returned.</p>', ], ], ],];
