<?php
// This file was auto-generated from sdk-root/src/data/lambda/2015-03-31/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Lambda</fullname> <p> <b>Overview</b> </p> <p>Lambda is a compute service that lets you run code without provisioning or managing servers. Lambda runs your code on a high-availability compute infrastructure and performs all of the administration of the compute resources, including server and operating system maintenance, capacity provisioning and automatic scaling, code monitoring and logging. With Lambda, you can run code for virtually any type of application or backend service. For more information about the Lambda service, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/welcome.html">What is Lambda</a> in the <b>Lambda Developer Guide</b>.</p> <p>The <i>Lambda API Reference</i> provides information about each of the API methods, including details about the parameters in each API request and response. </p> <p/> <p>You can use Software Development Kits (SDKs), Integrated Development Environment (IDE) Toolkits, and command line tools to access the API. For installation instructions, see <a href="http://aws.amazon.com/tools/">Tools for Amazon Web Services</a>. </p> <p>For a list of Region-specific endpoints that Lambda supports, see <a href="https://docs.aws.amazon.com/general/latest/gr/lambda-service.html/">Lambda endpoints and quotas </a> in the <i>Amazon Web Services General Reference.</i>. </p> <p>When making the API calls, you will need to authenticate your request by providing a signature. Lambda supports signature version 4. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 signing process</a> in the <i>Amazon Web Services General Reference.</i>. </p> <p> <b>CA certificates</b> </p> <p>Because Amazon Web Services SDKs use the CA certificates from your computer, changes to the certificates on the Amazon Web Services servers can cause connection failures when you attempt to use an SDK. You can prevent these failures by keeping your computer\'s CA certificates and operating system up-to-date. If you encounter this issue in a corporate environment and do not manage your own computer, you might need to ask an administrator to assist with the update process. The following list shows minimum operating system and Java versions:</p> <ul> <li> <p>Microsoft Windows versions that have updates from January 2005 or later installed contain at least one of the required CAs in their trust list. </p> </li> <li> <p>Mac OS X 10.4 with Java for Mac OS X 10.4 Release 5 (February 2007), Mac OS X 10.5 (October 2007), and later versions contain at least one of the required CAs in their trust list. </p> </li> <li> <p>Red Hat Enterprise Linux 5 (March 2007), 6, and 7 and CentOS 5, 6, and 7 all contain at least one of the required CAs in their default trusted CA list. </p> </li> <li> <p>Java 1.4.2_12 (May 2006), 5 Update 2 (March 2005), and all later versions, including Java 6 (December 2006), 7, and 8, contain at least one of the required CAs in their default trusted CA list. </p> </li> </ul> <p>When accessing the Lambda management console or Lambda API endpoints, whether through browsers or programmatically, you will need to ensure your client machines support any of the following CAs: </p> <ul> <li> <p>Amazon Root CA 1</p> </li> <li> <p>Starfield Services Root Certificate Authority - G2</p> </li> <li> <p>Starfield Class 2 Certification Authority</p> </li> </ul> <p>Root certificates from the first two authorities are available from <a href="https://www.amazontrust.com/repository/">Amazon trust services</a>, but keeping your computer up-to-date is the more straightforward solution. To learn more about ACM-provided certificates, see <a href="http://aws.amazon.com/certificate-manager/faqs/#certificates">Amazon Web Services Certificate Manager FAQs.</a> </p>', 'operations' => [ 'AddLayerVersionPermission' => '<p>Adds permissions to the resource-based policy of a version of an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda layer</a>. Use this action to grant layer usage permission to other accounts. You can grant permission to a single account, all accounts in an organization, or all Amazon Web Services accounts. </p> <p>To revoke permission, call <a>RemoveLayerVersionPermission</a> with the statement ID that you specified when you added it.</p>', 'AddPermission' => '<p>Grants an Amazon Web Service, Amazon Web Services account, or Amazon Web Services organization permission to use a function. You can apply the policy at the function level, or specify a qualifier to restrict access to a single version or alias. If you use a qualifier, the invoker must use the full Amazon Resource Name (ARN) of that version or alias to invoke the function. Note: Lambda does not support adding policies to version $LATEST.</p> <p>To grant permission to another account, specify the account ID as the <code>Principal</code>. To grant permission to an organization defined in Organizations, specify the organization ID as the <code>PrincipalOrgID</code>. For Amazon Web Services, the principal is a domain-style identifier that the service defines, such as <code>s3.amazonaws.com</code> or <code>sns.amazonaws.com</code>. For Amazon Web Services, you can also specify the ARN of the associated resource as the <code>SourceArn</code>. If you grant permission to a service principal without specifying the source, other accounts could potentially configure resources in their account to invoke your Lambda function.</p> <p>This operation adds a statement to a resource-based permissions policy for the function. For more information about function policies, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/access-control-resource-based.html">Using resource-based policies for Lambda</a>.</p>', 'CreateAlias' => '<p>Creates an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html">alias</a> for a Lambda function version. Use aliases to provide clients with a function identifier that you can update to invoke a different version.</p> <p>You can also map an alias to split invocation requests between two versions. Use the <code>RoutingConfig</code> parameter to specify a second version and the percentage of invocation requests that it receives.</p>', 'CreateCodeSigningConfig' => '<p>Creates a code signing configuration. A <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-codesigning.html">code signing configuration</a> defines a list of allowed signing profiles and defines the code-signing validation policy (action to be taken if deployment validation checks fail). </p>', 'CreateEventSourceMapping' => '<p>Creates a mapping between an event source and an Lambda function. Lambda reads items from the event source and invokes the function.</p> <p>For details about how to configure different event sources, see the following topics. </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-dynamodb-eventsourcemapping"> Amazon DynamoDB Streams</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-eventsourcemapping"> Amazon Kinesis</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-eventsource"> Amazon SQS</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-mq.html#services-mq-eventsourcemapping"> Amazon MQ and RabbitMQ</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html"> Amazon MSK</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/kafka-smaa.html"> Apache Kafka</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-documentdb.html"> Amazon DocumentDB</a> </p> </li> </ul> <p>The following error handling options are available only for stream sources (DynamoDB and Kinesis):</p> <ul> <li> <p> <code>BisectBatchOnFunctionError</code> – If the function returns an error, split the batch in two and retry.</p> </li> <li> <p> <code>DestinationConfig</code> – Send discarded records to an Amazon SQS queue or Amazon SNS topic.</p> </li> <li> <p> <code>MaximumRecordAgeInSeconds</code> – Discard records older than the specified age. The default value is infinite (-1). When set to infinite (-1), failed records are retried until the record expires</p> </li> <li> <p> <code>MaximumRetryAttempts</code> – Discard records after the specified number of retries. The default value is infinite (-1). When set to infinite (-1), failed records are retried until the record expires.</p> </li> <li> <p> <code>ParallelizationFactor</code> – Process multiple batches from each shard concurrently.</p> </li> </ul> <p>For information about which configuration parameters apply to each event source, see the following topics.</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-ddb-params"> Amazon DynamoDB Streams</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-params"> Amazon Kinesis</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#services-sqs-params"> Amazon SQS</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-mq.html#services-mq-params"> Amazon MQ and RabbitMQ</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html#services-msk-parms"> Amazon MSK</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-kafka.html#services-kafka-parms"> Apache Kafka</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-documentdb.html#docdb-configuration"> Amazon DocumentDB</a> </p> </li> </ul>', 'CreateFunction' => '<p>Creates a Lambda function. To create a function, you need a <a href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-package.html">deployment package</a> and an <a href="https://docs.aws.amazon.com/lambda/latest/dg/intro-permission-model.html#lambda-intro-execution-role">execution role</a>. The deployment package is a .zip file archive or container image that contains your function code. The execution role grants the function permission to use Amazon Web Services, such as Amazon CloudWatch Logs for log streaming and X-Ray for request tracing.</p> <p>If the deployment package is a <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-images.html">container image</a>, then you set the package type to <code>Image</code>. For a container image, the code property must include the URI of a container image in the Amazon ECR registry. You do not need to specify the handler and runtime properties.</p> <p>If the deployment package is a <a href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-package.html#gettingstarted-package-zip">.zip file archive</a>, then you set the package type to <code>Zip</code>. For a .zip file archive, the code property specifies the location of the .zip file. You must also specify the handler and runtime properties. The code in the deployment package must be compatible with the target instruction set architecture of the function (<code>x86-64</code> or <code>arm64</code>). If you do not specify the architecture, then the default value is <code>x86-64</code>.</p> <p>When you create a function, Lambda provisions an instance of the function and its supporting resources. If your function connects to a VPC, this process can take a minute or so. During this time, you can\'t invoke or modify the function. The <code>State</code>, <code>StateReason</code>, and <code>StateReasonCode</code> fields in the response from <a>GetFunctionConfiguration</a> indicate when the function is ready to invoke. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/functions-states.html">Lambda function states</a>.</p> <p>A function has an unpublished version, and can have published versions and aliases. The unpublished version changes when you update your function\'s code and configuration. A published version is a snapshot of your function code and configuration that can\'t be changed. An alias is a named resource that maps to a version, and can be changed to map to a different version. Use the <code>Publish</code> parameter to create version <code>1</code> of your function from its initial configuration.</p> <p>The other parameters let you configure version-specific and function-level settings. You can modify version-specific settings later with <a>UpdateFunctionConfiguration</a>. Function-level settings apply to both the unpublished and published versions of the function, and include tags (<a>TagResource</a>) and per-function concurrency limits (<a>PutFunctionConcurrency</a>).</p> <p>You can use code signing if your deployment package is a .zip file archive. To enable code signing for this function, specify the ARN of a code-signing configuration. When a user attempts to deploy a code package with <a>UpdateFunctionCode</a>, Lambda checks that the code package has a valid signature from a trusted publisher. The code-signing configuration includes set of signing profiles, which define the trusted publishers for this function.</p> <p>If another Amazon Web Services account or an Amazon Web Service invokes your function, use <a>AddPermission</a> to grant permission by creating a resource-based Identity and Access Management (IAM) policy. You can grant permissions at the function level, on a version, or on an alias.</p> <p>To invoke your function directly, use <a>Invoke</a>. To invoke your function in response to events in other Amazon Web Services, create an event source mapping (<a>CreateEventSourceMapping</a>), or configure a function trigger in the other service. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-invocation.html">Invoking Lambda functions</a>.</p>', 'CreateFunctionUrlConfig' => '<p>Creates a Lambda function URL with the specified configuration parameters. A function URL is a dedicated HTTP(S) endpoint that you can use to invoke your function.</p>', 'DeleteAlias' => '<p>Deletes a Lambda function <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html">alias</a>.</p>', 'DeleteCodeSigningConfig' => '<p>Deletes the code signing configuration. You can delete the code signing configuration only if no function is using it. </p>', 'DeleteEventSourceMapping' => '<p>Deletes an <a href="https://docs.aws.amazon.com/lambda/latest/dg/intro-invocation-modes.html">event source mapping</a>. You can get the identifier of a mapping from the output of <a>ListEventSourceMappings</a>.</p> <p>When you delete an event source mapping, it enters a <code>Deleting</code> state and might not be completely deleted for several seconds.</p>', 'DeleteFunction' => '<p>Deletes a Lambda function. To delete a specific function version, use the <code>Qualifier</code> parameter. Otherwise, all versions and aliases are deleted. This doesn\'t require the user to have explicit permissions for <a>DeleteAlias</a>.</p> <p>To delete Lambda event source mappings that invoke a function, use <a>DeleteEventSourceMapping</a>. For Amazon Web Services and resources that invoke your function directly, delete the trigger in the service where you originally configured it.</p>', 'DeleteFunctionCodeSigningConfig' => '<p>Removes the code signing configuration from the function.</p>', 'DeleteFunctionConcurrency' => '<p>Removes a concurrent execution limit from a function.</p>', 'DeleteFunctionEventInvokeConfig' => '<p>Deletes the configuration for asynchronous invocation for a function, version, or alias.</p> <p>To configure options for asynchronous invocation, use <a>PutFunctionEventInvokeConfig</a>.</p>', 'DeleteFunctionUrlConfig' => '<p>Deletes a Lambda function URL. When you delete a function URL, you can\'t recover it. Creating a new function URL results in a different URL address.</p>', 'DeleteLayerVersion' => '<p>Deletes a version of an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda layer</a>. Deleted versions can no longer be viewed or added to functions. To avoid breaking functions, a copy of the version remains in Lambda until no functions refer to it.</p>', 'DeleteProvisionedConcurrencyConfig' => '<p>Deletes the provisioned concurrency configuration for a function.</p>', 'GetAccountSettings' => '<p>Retrieves details about your account\'s <a href="https://docs.aws.amazon.com/lambda/latest/dg/limits.html">limits</a> and usage in an Amazon Web Services Region.</p>', 'GetAlias' => '<p>Returns details about a Lambda function <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html">alias</a>.</p>', 'GetCodeSigningConfig' => '<p>Returns information about the specified code signing configuration.</p>', 'GetEventSourceMapping' => '<p>Returns details about an event source mapping. You can get the identifier of a mapping from the output of <a>ListEventSourceMappings</a>.</p>', 'GetFunction' => '<p>Returns information about the function or function version, with a link to download the deployment package that\'s valid for 10 minutes. If you specify a function version, only details that are specific to that version are returned.</p>', 'GetFunctionCodeSigningConfig' => '<p>Returns the code signing configuration for the specified function.</p>', 'GetFunctionConcurrency' => '<p>Returns details about the reserved concurrency configuration for a function. To set a concurrency limit for a function, use <a>PutFunctionConcurrency</a>.</p>', 'GetFunctionConfiguration' => '<p>Returns the version-specific settings of a Lambda function or version. The output includes only options that can vary between versions of a function. To modify these settings, use <a>UpdateFunctionConfiguration</a>.</p> <p>To get all of a function\'s details, including function-level settings, use <a>GetFunction</a>.</p>', 'GetFunctionEventInvokeConfig' => '<p>Retrieves the configuration for asynchronous invocation for a function, version, or alias.</p> <p>To configure options for asynchronous invocation, use <a>PutFunctionEventInvokeConfig</a>.</p>', 'GetFunctionUrlConfig' => '<p>Returns details about a Lambda function URL.</p>', 'GetLayerVersion' => '<p>Returns information about a version of an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda layer</a>, with a link to download the layer archive that\'s valid for 10 minutes.</p>', 'GetLayerVersionByArn' => '<p>Returns information about a version of an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda layer</a>, with a link to download the layer archive that\'s valid for 10 minutes.</p>', 'GetLayerVersionPolicy' => '<p>Returns the permission policy for a version of an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda layer</a>. For more information, see <a>AddLayerVersionPermission</a>.</p>', 'GetPolicy' => '<p>Returns the <a href="https://docs.aws.amazon.com/lambda/latest/dg/access-control-resource-based.html">resource-based IAM policy</a> for a function, version, or alias.</p>', 'GetProvisionedConcurrencyConfig' => '<p>Retrieves the provisioned concurrency configuration for a function\'s alias or version.</p>', 'GetRuntimeManagementConfig' => '<p>Retrieves the runtime management configuration for a function\'s version. If the runtime update mode is <b>Manual</b>, this includes the ARN of the runtime version and the runtime update mode. If the runtime update mode is <b>Auto</b> or <b>Function update</b>, this includes the runtime update mode and <code>null</code> is returned for the ARN. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/runtimes-update.html">Runtime updates</a>.</p>', 'Invoke' => '<p>Invokes a Lambda function. You can invoke a function synchronously (and wait for the response), or asynchronously. By default, Lambda invokes your function synchronously (i.e. the<code>InvocationType</code> is <code>RequestResponse</code>). To invoke a function asynchronously, set <code>InvocationType</code> to <code>Event</code>. Lambda passes the <code>ClientContext</code> object to your function for synchronous invocations only.</p> <p>For <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-sync.html">synchronous invocation</a>, details about the function response, including errors, are included in the response body and headers. For either invocation type, you can find more information in the <a href="https://docs.aws.amazon.com/lambda/latest/dg/monitoring-functions.html">execution log</a> and <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-x-ray.html">trace</a>.</p> <p>When an error occurs, your function may be invoked multiple times. Retry behavior varies by error type, client, event source, and invocation type. For example, if you invoke a function asynchronously and it returns an error, Lambda executes the function up to two more times. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-retries.html">Error handling and automatic retries in Lambda</a>.</p> <p>For <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html">asynchronous invocation</a>, Lambda adds events to a queue before sending them to your function. If your function does not have enough capacity to keep up with the queue, events may be lost. Occasionally, your function may receive the same event multiple times, even if no error occurs. To retain events that were not processed, configure your function with a <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#invocation-dlq">dead-letter queue</a>.</p> <p>The status code in the API response doesn\'t reflect function errors. Error codes are reserved for errors that prevent your function from executing, such as permissions errors, <a href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html">quota</a> errors, or issues with your function\'s code and configuration. For example, Lambda returns <code>TooManyRequestsException</code> if running the function would cause you to exceed a concurrency limit at either the account level (<code>ConcurrentInvocationLimitExceeded</code>) or function level (<code>ReservedFunctionConcurrentInvocationLimitExceeded</code>).</p> <p>For functions with a long timeout, your client might disconnect during synchronous invocation while it waits for a response. Configure your HTTP client, SDK, firewall, proxy, or operating system to allow for long connections with timeout or keep-alive settings.</p> <p>This operation requires permission for the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awslambda.html">lambda:InvokeFunction</a> action. For details on how to set up permissions for cross-account invocations, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/access-control-resource-based.html#permissions-resource-xaccountinvoke">Granting function access to other accounts</a>.</p>', 'InvokeAsync' => '<important> <p>For asynchronous function invocation, use <a>Invoke</a>.</p> </important> <p>Invokes a function asynchronously.</p> <note> <p>If you do use the InvokeAsync action, note that it doesn\'t support the use of X-Ray active tracing. Trace ID is not propagated to the function, even if X-Ray active tracing is turned on.</p> </note>', 'InvokeWithResponseStream' => '<p>Configure your Lambda functions to stream response payloads back to clients. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-response-streaming.html">Configuring a Lambda function to stream responses</a>.</p> <p>This operation requires permission for the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awslambda.html">lambda:InvokeFunction</a> action. For details on how to set up permissions for cross-account invocations, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/access-control-resource-based.html#permissions-resource-xaccountinvoke">Granting function access to other accounts</a>.</p>', 'ListAliases' => '<p>Returns a list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html">aliases</a> for a Lambda function.</p>', 'ListCodeSigningConfigs' => '<p>Returns a list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuring-codesigning.html">code signing configurations</a>. A request returns up to 10,000 configurations per call. You can use the <code>MaxItems</code> parameter to return fewer configurations per call. </p>', 'ListEventSourceMappings' => '<p>Lists event source mappings. Specify an <code>EventSourceArn</code> to show only event source mappings for a single event source.</p>', 'ListFunctionEventInvokeConfigs' => '<p>Retrieves a list of configurations for asynchronous invocation for a function.</p> <p>To configure options for asynchronous invocation, use <a>PutFunctionEventInvokeConfig</a>.</p>', 'ListFunctionUrlConfigs' => '<p>Returns a list of Lambda function URLs for the specified function.</p>', 'ListFunctions' => '<p>Returns a list of Lambda functions, with the version-specific configuration of each. Lambda returns up to 50 functions per call.</p> <p>Set <code>FunctionVersion</code> to <code>ALL</code> to include all published versions of each function in addition to the unpublished version.</p> <note> <p>The <code>ListFunctions</code> operation returns a subset of the <a>FunctionConfiguration</a> fields. To get the additional fields (State, StateReasonCode, StateReason, LastUpdateStatus, LastUpdateStatusReason, LastUpdateStatusReasonCode, RuntimeVersionConfig) for a function or version, use <a>GetFunction</a>.</p> </note>', 'ListFunctionsByCodeSigningConfig' => '<p>List the functions that use the specified code signing configuration. You can use this method prior to deleting a code signing configuration, to verify that no functions are using it.</p>', 'ListLayerVersions' => '<p>Lists the versions of an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda layer</a>. Versions that have been deleted aren\'t listed. Specify a <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime identifier</a> to list only versions that indicate that they\'re compatible with that runtime. Specify a compatible architecture to include only layer versions that are compatible with that architecture.</p>', 'ListLayers' => '<p>Lists <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-layers.html">Lambda layers</a> and shows information about the latest version of each. Specify a <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime identifier</a> to list only layers that indicate that they\'re compatible with that runtime. Specify a compatible architecture to include only layers that are compatible with that <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architecture</a>.</p>', 'ListProvisionedConcurrencyConfigs' => '<p>Retrieves a list of provisioned concurrency configurations for a function.</p>', 'ListTags' => '<p>Returns a function\'s <a href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a>. You can also view tags with <a>GetFunction</a>.</p>', 'ListVersionsByFunction' => '<p>Returns a list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">versions</a>, with the version-specific configuration of each. Lambda returns up to 50 versions per call.</p>', 'PublishLayerVersion' => '<p>Creates an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda layer</a> from a ZIP archive. Each time you call <code>PublishLayerVersion</code> with the same layer name, a new version is created.</p> <p>Add layers to your function with <a>CreateFunction</a> or <a>UpdateFunctionConfiguration</a>.</p>', 'PublishVersion' => '<p>Creates a <a href="https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">version</a> from the current code and configuration of a function. Use versions to create a snapshot of your function code and configuration that doesn\'t change.</p> <p>Lambda doesn\'t publish a version if the function\'s configuration and code haven\'t changed since the last version. Use <a>UpdateFunctionCode</a> or <a>UpdateFunctionConfiguration</a> to update the function before publishing a version.</p> <p>Clients can invoke versions directly or with an alias. To create an alias, use <a>CreateAlias</a>.</p>', 'PutFunctionCodeSigningConfig' => '<p>Update the code signing configuration for the function. Changes to the code signing configuration take effect the next time a user tries to deploy a code package to the function. </p>', 'PutFunctionConcurrency' => '<p>Sets the maximum number of simultaneous executions for a function, and reserves capacity for that concurrency level.</p> <p>Concurrency settings apply to the function as a whole, including all published versions and the unpublished version. Reserving concurrency both ensures that your function has capacity to process the specified number of events simultaneously, and prevents it from scaling beyond that level. Use <a>GetFunction</a> to see the current setting for a function.</p> <p>Use <a>GetAccountSettings</a> to see your Regional concurrency limit. You can reserve concurrency for as many functions as you like, as long as you leave at least 100 simultaneous executions unreserved for functions that aren\'t configured with a per-function limit. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-scaling.html">Lambda function scaling</a>.</p>', 'PutFunctionEventInvokeConfig' => '<p>Configures options for <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html">asynchronous invocation</a> on a function, version, or alias. If a configuration already exists for a function, version, or alias, this operation overwrites it. If you exclude any settings, they are removed. To set one option without affecting existing settings for other options, use <a>UpdateFunctionEventInvokeConfig</a>.</p> <p>By default, Lambda retries an asynchronous invocation twice if the function returns an error. It retains events in a queue for up to six hours. When an event fails all processing attempts or stays in the asynchronous invocation queue for too long, Lambda discards it. To retain discarded events, configure a dead-letter queue with <a>UpdateFunctionConfiguration</a>.</p> <p>To send an invocation record to a queue, topic, function, or event bus, specify a <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#invocation-async-destinations">destination</a>. You can configure separate destinations for successful invocations (on-success) and events that fail all processing attempts (on-failure). You can configure destinations in addition to or instead of a dead-letter queue.</p>', 'PutProvisionedConcurrencyConfig' => '<p>Adds a provisioned concurrency configuration to a function\'s alias or version.</p>', 'PutRuntimeManagementConfig' => '<p>Sets the runtime management configuration for a function\'s version. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/runtimes-update.html">Runtime updates</a>.</p>', 'RemoveLayerVersionPermission' => '<p>Removes a statement from the permissions policy for a version of an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda layer</a>. For more information, see <a>AddLayerVersionPermission</a>.</p>', 'RemovePermission' => '<p>Revokes function-use permission from an Amazon Web Service or another Amazon Web Services account. You can get the ID of the statement from the output of <a>GetPolicy</a>.</p>', 'TagResource' => '<p>Adds <a href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a> to a function.</p>', 'UntagResource' => '<p>Removes <a href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a> from a function.</p>', 'UpdateAlias' => '<p>Updates the configuration of a Lambda function <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html">alias</a>.</p>', 'UpdateCodeSigningConfig' => '<p>Update the code signing configuration. Changes to the code signing configuration take effect the next time a user tries to deploy a code package to the function. </p>', 'UpdateEventSourceMapping' => '<p>Updates an event source mapping. You can change the function that Lambda invokes, or pause invocation and resume later from the same location.</p> <p>For details about how to configure different event sources, see the following topics. </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-dynamodb-eventsourcemapping"> Amazon DynamoDB Streams</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-eventsourcemapping"> Amazon Kinesis</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-eventsource"> Amazon SQS</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-mq.html#services-mq-eventsourcemapping"> Amazon MQ and RabbitMQ</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html"> Amazon MSK</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/kafka-smaa.html"> Apache Kafka</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-documentdb.html"> Amazon DocumentDB</a> </p> </li> </ul> <p>The following error handling options are available only for stream sources (DynamoDB and Kinesis):</p> <ul> <li> <p> <code>BisectBatchOnFunctionError</code> – If the function returns an error, split the batch in two and retry.</p> </li> <li> <p> <code>DestinationConfig</code> – Send discarded records to an Amazon SQS queue or Amazon SNS topic.</p> </li> <li> <p> <code>MaximumRecordAgeInSeconds</code> – Discard records older than the specified age. The default value is infinite (-1). When set to infinite (-1), failed records are retried until the record expires</p> </li> <li> <p> <code>MaximumRetryAttempts</code> – Discard records after the specified number of retries. The default value is infinite (-1). When set to infinite (-1), failed records are retried until the record expires.</p> </li> <li> <p> <code>ParallelizationFactor</code> – Process multiple batches from each shard concurrently.</p> </li> </ul> <p>For information about which configuration parameters apply to each event source, see the following topics.</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-ddb-params"> Amazon DynamoDB Streams</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-params"> Amazon Kinesis</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#services-sqs-params"> Amazon SQS</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-mq.html#services-mq-params"> Amazon MQ and RabbitMQ</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html#services-msk-parms"> Amazon MSK</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-kafka.html#services-kafka-parms"> Apache Kafka</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-documentdb.html#docdb-configuration"> Amazon DocumentDB</a> </p> </li> </ul>', 'UpdateFunctionCode' => '<p>Updates a Lambda function\'s code. If code signing is enabled for the function, the code package must be signed by a trusted publisher. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-codesigning.html">Configuring code signing for Lambda</a>.</p> <p>If the function\'s package type is <code>Image</code>, then you must specify the code package in <code>ImageUri</code> as the URI of a <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-images.html">container image</a> in the Amazon ECR registry.</p> <p>If the function\'s package type is <code>Zip</code>, then you must specify the deployment package as a <a href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-package.html#gettingstarted-package-zip">.zip file archive</a>. Enter the Amazon S3 bucket and key of the code .zip file location. You can also provide the function code inline using the <code>ZipFile</code> field.</p> <p>The code in the deployment package must be compatible with the target instruction set architecture of the function (<code>x86-64</code> or <code>arm64</code>).</p> <p>The function\'s code is locked when you publish a version. You can\'t modify the code of a published version, only the unpublished version.</p> <note> <p>For a function defined as a container image, Lambda resolves the image tag to an image digest. In Amazon ECR, if you update the image tag to a new image, Lambda does not automatically update the function.</p> </note>', 'UpdateFunctionConfiguration' => '<p>Modify the version-specific settings of a Lambda function.</p> <p>When you update a function, Lambda provisions an instance of the function and its supporting resources. If your function connects to a VPC, this process can take a minute. During this time, you can\'t modify the function, but you can still invoke it. The <code>LastUpdateStatus</code>, <code>LastUpdateStatusReason</code>, and <code>LastUpdateStatusReasonCode</code> fields in the response from <a>GetFunctionConfiguration</a> indicate when the update is complete and the function is processing events with the new configuration. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/functions-states.html">Lambda function states</a>.</p> <p>These settings can vary between versions of a function and are locked when you publish a version. You can\'t modify the configuration of a published version, only the unpublished version.</p> <p>To configure function concurrency, use <a>PutFunctionConcurrency</a>. To grant invoke permissions to an Amazon Web Services account or Amazon Web Service, use <a>AddPermission</a>.</p>', 'UpdateFunctionEventInvokeConfig' => '<p>Updates the configuration for asynchronous invocation for a function, version, or alias.</p> <p>To configure options for asynchronous invocation, use <a>PutFunctionEventInvokeConfig</a>.</p>', 'UpdateFunctionUrlConfig' => '<p>Updates the configuration for a Lambda function URL.</p>', ], 'shapes' => [ 'AccountLimit' => [ 'base' => '<p>Limits that are related to concurrency and storage. All file and storage sizes are in bytes.</p>', 'refs' => [ 'GetAccountSettingsResponse$AccountLimit' => '<p>Limits that are related to concurrency and code storage.</p>', ], ], 'AccountUsage' => [ 'base' => '<p>The number of functions and amount of storage in use.</p>', 'refs' => [ 'GetAccountSettingsResponse$AccountUsage' => '<p>The number of functions and amount of storage in use.</p>', ], ], 'Action' => [ 'base' => NULL, 'refs' => [ 'AddPermissionRequest$Action' => '<p>The action that the principal can use on the function. For example, <code>lambda:InvokeFunction</code> or <code>lambda:GetFunction</code>.</p>', ], ], 'AddLayerVersionPermissionRequest' => [ 'base' => NULL, 'refs' => [], ], 'AddLayerVersionPermissionResponse' => [ 'base' => NULL, 'refs' => [], ], 'AddPermissionRequest' => [ 'base' => NULL, 'refs' => [], ], 'AddPermissionResponse' => [ 'base' => NULL, 'refs' => [], ], 'AdditionalVersion' => [ 'base' => NULL, 'refs' => [ 'AdditionalVersionWeights$key' => NULL, ], ], 'AdditionalVersionWeights' => [ 'base' => NULL, 'refs' => [ 'AliasRoutingConfiguration$AdditionalVersionWeights' => '<p>The second version, and the percentage of traffic that\'s routed to it.</p>', ], ], 'Alias' => [ 'base' => NULL, 'refs' => [ 'AliasConfiguration$Name' => '<p>The name of the alias.</p>', 'CreateAliasRequest$Name' => '<p>The name of the alias.</p>', 'DeleteAliasRequest$Name' => '<p>The name of the alias.</p>', 'GetAliasRequest$Name' => '<p>The name of the alias.</p>', 'UpdateAliasRequest$Name' => '<p>The name of the alias.</p>', ], ], 'AliasConfiguration' => [ 'base' => '<p>Provides configuration information about a Lambda function <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html">alias</a>.</p>', 'refs' => [ 'AliasList$member' => NULL, ], ], 'AliasList' => [ 'base' => NULL, 'refs' => [ 'ListAliasesResponse$Aliases' => '<p>A list of aliases.</p>', ], ], 'AliasRoutingConfiguration' => [ 'base' => '<p>The <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-traffic-shifting-using-aliases.html">traffic-shifting</a> configuration of a Lambda function alias.</p>', 'refs' => [ 'AliasConfiguration$RoutingConfig' => '<p>The <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-traffic-shifting-using-aliases.html">routing configuration</a> of the alias.</p>', 'CreateAliasRequest$RoutingConfig' => '<p>The <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html#configuring-alias-routing">routing configuration</a> of the alias.</p>', 'UpdateAliasRequest$RoutingConfig' => '<p>The <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html#configuring-alias-routing">routing configuration</a> of the alias.</p>', ], ], 'AllowCredentials' => [ 'base' => NULL, 'refs' => [ 'Cors$AllowCredentials' => '<p>Whether to allow cookies or other credentials in requests to your function URL. The default is <code>false</code>.</p>', ], ], 'AllowMethodsList' => [ 'base' => NULL, 'refs' => [ 'Cors$AllowMethods' => '<p>The HTTP methods that are allowed when calling your function URL. For example: <code>GET</code>, <code>POST</code>, <code>DELETE</code>, or the wildcard character (<code>*</code>).</p>', ], ], 'AllowOriginsList' => [ 'base' => NULL, 'refs' => [ 'Cors$AllowOrigins' => '<p>The origins that can access your function URL. You can list any number of specific origins, separated by a comma. For example: <code>https://www.example.com</code>, <code>http://localhost:60905</code>.</p> <p>Alternatively, you can grant access to all origins using the wildcard character (<code>*</code>).</p>', ], ], 'AllowedPublishers' => [ 'base' => '<p>List of signing profiles that can sign a code package. </p>', 'refs' => [ 'CodeSigningConfig$AllowedPublishers' => '<p>List of allowed publishers.</p>', 'CreateCodeSigningConfigRequest$AllowedPublishers' => '<p>Signing profiles for this code signing configuration.</p>', 'UpdateCodeSigningConfigRequest$AllowedPublishers' => '<p>Signing profiles for this code signing configuration.</p>', ], ], 'AmazonManagedKafkaEventSourceConfig' => [ 'base' => '<p>Specific configuration settings for an Amazon Managed Streaming for Apache Kafka (Amazon MSK) event source.</p>', 'refs' => [ 'CreateEventSourceMappingRequest$AmazonManagedKafkaEventSourceConfig' => '<p>Specific configuration settings for an Amazon Managed Streaming for Apache Kafka (Amazon MSK) event source.</p>', 'EventSourceMappingConfiguration$AmazonManagedKafkaEventSourceConfig' => '<p>Specific configuration settings for an Amazon Managed Streaming for Apache Kafka (Amazon MSK) event source.</p>', ], ], 'ApplicationLogLevel' => [ 'base' => NULL, 'refs' => [ 'LoggingConfig$ApplicationLogLevel' => '<p>Set this property to filter the application logs for your function that Lambda sends to CloudWatch. Lambda only sends application logs at the selected level of detail and lower, where <code>TRACE</code> is the highest level and <code>FATAL</code> is the lowest.</p>', ], ], 'Architecture' => [ 'base' => NULL, 'refs' => [ 'ArchitecturesList$member' => NULL, 'CompatibleArchitectures$member' => NULL, 'ListLayerVersionsRequest$CompatibleArchitecture' => '<p>The compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architecture</a>.</p>', 'ListLayersRequest$CompatibleArchitecture' => '<p>The compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architecture</a>.</p>', ], ], 'ArchitecturesList' => [ 'base' => NULL, 'refs' => [ 'CreateFunctionRequest$Architectures' => '<p>The instruction set architecture that the function supports. Enter a string array with one of the valid values (arm64 or x86_64). The default value is <code>x86_64</code>.</p>', 'FunctionConfiguration$Architectures' => '<p>The instruction set architecture that the function supports. Architecture is a string array with one of the valid values. The default architecture value is <code>x86_64</code>.</p>', 'UpdateFunctionCodeRequest$Architectures' => '<p>The instruction set architecture that the function supports. Enter a string array with one of the valid values (arm64 or x86_64). The default value is <code>x86_64</code>.</p>', ], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'AddPermissionRequest$SourceArn' => '<p>For Amazon Web Services, the ARN of the Amazon Web Services resource that invokes the function. For example, an Amazon S3 bucket or Amazon SNS topic.</p> <p>Note that Lambda configures the comparison using the <code>StringLike</code> operator.</p>', 'CreateEventSourceMappingRequest$EventSourceArn' => '<p>The Amazon Resource Name (ARN) of the event source.</p> <ul> <li> <p> <b>Amazon Kinesis</b> – The ARN of the data stream or a stream consumer.</p> </li> <li> <p> <b>Amazon DynamoDB Streams</b> – The ARN of the stream.</p> </li> <li> <p> <b>Amazon Simple Queue Service</b> – The ARN of the queue.</p> </li> <li> <p> <b>Amazon Managed Streaming for Apache Kafka</b> – The ARN of the cluster or the ARN of the VPC connection (for <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html#msk-multi-vpc">cross-account event source mappings</a>).</p> </li> <li> <p> <b>Amazon MQ</b> – The ARN of the broker.</p> </li> <li> <p> <b>Amazon DocumentDB</b> – The ARN of the DocumentDB change stream.</p> </li> </ul>', 'EventSourceMappingConfiguration$EventSourceArn' => '<p>The Amazon Resource Name (ARN) of the event source.</p>', 'FunctionConfiguration$SigningProfileVersionArn' => '<p>The ARN of the signing profile version.</p>', 'FunctionConfiguration$SigningJobArn' => '<p>The ARN of the signing job.</p>', 'Layer$SigningProfileVersionArn' => '<p>The Amazon Resource Name (ARN) for a signing profile version.</p>', 'Layer$SigningJobArn' => '<p>The Amazon Resource Name (ARN) of a signing job.</p>', 'ListEventSourceMappingsRequest$EventSourceArn' => '<p>The Amazon Resource Name (ARN) of the event source.</p> <ul> <li> <p> <b>Amazon Kinesis</b> – The ARN of the data stream or a stream consumer.</p> </li> <li> <p> <b>Amazon DynamoDB Streams</b> – The ARN of the stream.</p> </li> <li> <p> <b>Amazon Simple Queue Service</b> – The ARN of the queue.</p> </li> <li> <p> <b>Amazon Managed Streaming for Apache Kafka</b> – The ARN of the cluster or the ARN of the VPC connection (for <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html#msk-multi-vpc">cross-account event source mappings</a>).</p> </li> <li> <p> <b>Amazon MQ</b> – The ARN of the broker.</p> </li> <li> <p> <b>Amazon DocumentDB</b> – The ARN of the DocumentDB change stream.</p> </li> </ul>', 'SigningProfileVersionArns$member' => NULL, ], ], 'BatchSize' => [ 'base' => NULL, 'refs' => [ 'CreateEventSourceMappingRequest$BatchSize' => '<p>The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation (6 MB).</p> <ul> <li> <p> <b>Amazon Kinesis</b> – Default 100. Max 10,000.</p> </li> <li> <p> <b>Amazon DynamoDB Streams</b> – Default 100. Max 10,000.</p> </li> <li> <p> <b>Amazon Simple Queue Service</b> – Default 10. For standard queues the max is 10,000. For FIFO queues the max is 10.</p> </li> <li> <p> <b>Amazon Managed Streaming for Apache Kafka</b> – Default 100. Max 10,000.</p> </li> <li> <p> <b>Self-managed Apache Kafka</b> – Default 100. Max 10,000.</p> </li> <li> <p> <b>Amazon MQ (ActiveMQ and RabbitMQ)</b> – Default 100. Max 10,000.</p> </li> <li> <p> <b>DocumentDB</b> – Default 100. Max 10,000.</p> </li> </ul>', 'EventSourceMappingConfiguration$BatchSize' => '<p>The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation (6 MB).</p> <p>Default value: Varies by service. For Amazon SQS, the default is 10. For all other services, the default is 100.</p> <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>', 'UpdateEventSourceMappingRequest$BatchSize' => '<p>The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation (6 MB).</p> <ul> <li> <p> <b>Amazon Kinesis</b> – Default 100. Max 10,000.</p> </li> <li> <p> <b>Amazon DynamoDB Streams</b> – Default 100. Max 10,000.</p> </li> <li> <p> <b>Amazon Simple Queue Service</b> – Default 10. For standard queues the max is 10,000. For FIFO queues the max is 10.</p> </li> <li> <p> <b>Amazon Managed Streaming for Apache Kafka</b> – Default 100. Max 10,000.</p> </li> <li> <p> <b>Self-managed Apache Kafka</b> – Default 100. Max 10,000.</p> </li> <li> <p> <b>Amazon MQ (ActiveMQ and RabbitMQ)</b> – Default 100. Max 10,000.</p> </li> <li> <p> <b>DocumentDB</b> – Default 100. Max 10,000.</p> </li> </ul>', ], ], 'BisectBatchOnFunctionError' => [ 'base' => NULL, 'refs' => [ 'CreateEventSourceMappingRequest$BisectBatchOnFunctionError' => '<p>(Kinesis and DynamoDB Streams only) If the function returns an error, split the batch in two and retry.</p>', 'EventSourceMappingConfiguration$BisectBatchOnFunctionError' => '<p>(Kinesis and DynamoDB Streams only) If the function returns an error, split the batch in two and retry. The default value is false.</p>', 'UpdateEventSourceMappingRequest$BisectBatchOnFunctionError' => '<p>(Kinesis and DynamoDB Streams only) If the function returns an error, split the batch in two and retry.</p>', ], ], 'Blob' => [ 'base' => NULL, 'refs' => [ 'FunctionCode$ZipFile' => '<p>The base64-encoded contents of the deployment package. Amazon Web Services SDK and CLI clients handle the encoding for you.</p>', 'InvocationRequest$Payload' => '<p>The JSON that you want to provide to your Lambda function as input.</p> <p>You can enter the JSON directly. For example, <code>--payload \'{ "key": "value" }\'</code>. You can also specify a file path. For example, <code>--payload file://payload.json</code>.</p>', 'InvocationResponse$Payload' => '<p>The response from the function, or an error object.</p>', 'InvokeResponseStreamUpdate$Payload' => '<p>Data returned by your Lambda function.</p>', 'InvokeWithResponseStreamRequest$Payload' => '<p>The JSON that you want to provide to your Lambda function as input.</p> <p>You can enter the JSON directly. For example, <code>--payload \'{ "key": "value" }\'</code>. You can also specify a file path. For example, <code>--payload file://payload.json</code>.</p>', 'LayerVersionContentInput$ZipFile' => '<p>The base64-encoded contents of the layer archive. Amazon Web Services SDK and Amazon Web Services CLI clients handle the encoding for you.</p>', 'UpdateFunctionCodeRequest$ZipFile' => '<p>The base64-encoded contents of the deployment package. Amazon Web Services SDK and CLI clients handle the encoding for you. Use only with a function defined with a .zip file archive deployment package.</p>', ], ], 'BlobStream' => [ 'base' => NULL, 'refs' => [ 'InvokeAsyncRequest$InvokeArgs' => '<p>The JSON that you want to provide to your Lambda function as input.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'CreateFunctionRequest$Publish' => '<p>Set to true to publish the first version of the function during creation.</p>', 'UpdateFunctionCodeRequest$Publish' => '<p>Set to true to publish a new version of the function after updating the code. This has the same effect as calling <a>PublishVersion</a> separately.</p>', 'UpdateFunctionCodeRequest$DryRun' => '<p>Set to true to validate the request parameters and access permissions without modifying the function code.</p>', ], ], 'CodeSigningConfig' => [ 'base' => '<p>Details about a <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-codesigning.html">Code signing configuration</a>. </p>', 'refs' => [ 'CodeSigningConfigList$member' => NULL, 'CreateCodeSigningConfigResponse$CodeSigningConfig' => '<p>The code signing configuration.</p>', 'GetCodeSigningConfigResponse$CodeSigningConfig' => '<p>The code signing configuration</p>', 'UpdateCodeSigningConfigResponse$CodeSigningConfig' => '<p>The code signing configuration</p>', ], ], 'CodeSigningConfigArn' => [ 'base' => NULL, 'refs' => [ 'CodeSigningConfig$CodeSigningConfigArn' => '<p>The Amazon Resource Name (ARN) of the Code signing configuration.</p>', 'CreateFunctionRequest$CodeSigningConfigArn' => '<p>To enable code signing for this function, specify the ARN of a code-signing configuration. A code-signing configuration includes a set of signing profiles, which define the trusted publishers for this function.</p>', 'DeleteCodeSigningConfigRequest$CodeSigningConfigArn' => '<p>The The Amazon Resource Name (ARN) of the code signing configuration.</p>', 'GetCodeSigningConfigRequest$CodeSigningConfigArn' => '<p>The The Amazon Resource Name (ARN) of the code signing configuration. </p>', 'GetFunctionCodeSigningConfigResponse$CodeSigningConfigArn' => '<p>The The Amazon Resource Name (ARN) of the code signing configuration.</p>', 'ListFunctionsByCodeSigningConfigRequest$CodeSigningConfigArn' => '<p>The The Amazon Resource Name (ARN) of the code signing configuration.</p>', 'PutFunctionCodeSigningConfigRequest$CodeSigningConfigArn' => '<p>The The Amazon Resource Name (ARN) of the code signing configuration.</p>', 'PutFunctionCodeSigningConfigResponse$CodeSigningConfigArn' => '<p>The The Amazon Resource Name (ARN) of the code signing configuration.</p>', 'UpdateCodeSigningConfigRequest$CodeSigningConfigArn' => '<p>The The Amazon Resource Name (ARN) of the code signing configuration.</p>', ], ], 'CodeSigningConfigId' => [ 'base' => NULL, 'refs' => [ 'CodeSigningConfig$CodeSigningConfigId' => '<p>Unique identifer for the Code signing configuration.</p>', ], ], 'CodeSigningConfigList' => [ 'base' => NULL, 'refs' => [ 'ListCodeSigningConfigsResponse$CodeSigningConfigs' => '<p>The code signing configurations</p>', ], ], 'CodeSigningConfigNotFoundException' => [ 'base' => '<p>The specified code signing configuration does not exist.</p>', 'refs' => [], ], 'CodeSigningPolicies' => [ 'base' => '<p>Code signing configuration <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-codesigning.html#config-codesigning-policies">policies</a> specify the validation failure action for signature mismatch or expiry.</p>', 'refs' => [ 'CodeSigningConfig$CodeSigningPolicies' => '<p>The code signing policy controls the validation failure action for signature mismatch or expiry.</p>', 'CreateCodeSigningConfigRequest$CodeSigningPolicies' => '<p>The code signing policies define the actions to take if the validation checks fail. </p>', 'UpdateCodeSigningConfigRequest$CodeSigningPolicies' => '<p>The code signing policy.</p>', ], ], 'CodeSigningPolicy' => [ 'base' => NULL, 'refs' => [ 'CodeSigningPolicies$UntrustedArtifactOnDeployment' => '<p>Code signing configuration policy for deployment validation failure. If you set the policy to <code>Enforce</code>, Lambda blocks the deployment request if signature validation checks fail. If you set the policy to <code>Warn</code>, Lambda allows the deployment and creates a CloudWatch log. </p> <p>Default value: <code>Warn</code> </p>', ], ], 'CodeStorageExceededException' => [ 'base' => '<p>Your Amazon Web Services account has exceeded its maximum total code size. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html">Lambda quotas</a>.</p>', 'refs' => [], ], 'CodeVerificationFailedException' => [ 'base' => '<p>The code signature failed one or more of the validation checks for signature mismatch or expiry, and the code signing policy is set to ENFORCE. Lambda blocks the deployment.</p>', 'refs' => [], ], 'CollectionName' => [ 'base' => NULL, 'refs' => [ 'DocumentDBEventSourceConfig$CollectionName' => '<p> The name of the collection to consume within the database. If you do not specify a collection, Lambda consumes all collections. </p>', ], ], 'CompatibleArchitectures' => [ 'base' => NULL, 'refs' => [ 'GetLayerVersionResponse$CompatibleArchitectures' => '<p>A list of compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architectures</a>.</p>', 'LayerVersionsListItem$CompatibleArchitectures' => '<p>A list of compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architectures</a>.</p>', 'PublishLayerVersionRequest$CompatibleArchitectures' => '<p>A list of compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architectures</a>.</p>', 'PublishLayerVersionResponse$CompatibleArchitectures' => '<p>A list of compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architectures</a>.</p>', ], ], 'CompatibleRuntimes' => [ 'base' => NULL, 'refs' => [ 'GetLayerVersionResponse$CompatibleRuntimes' => '<p>The layer\'s compatible runtimes.</p> <p>The following list includes deprecated runtimes. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-support-policy">Runtime deprecation policy</a>.</p>', 'LayerVersionsListItem$CompatibleRuntimes' => '<p>The layer\'s compatible runtimes.</p> <p>The following list includes deprecated runtimes. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-support-policy">Runtime deprecation policy</a>.</p>', 'PublishLayerVersionRequest$CompatibleRuntimes' => '<p>A list of compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">function runtimes</a>. Used for filtering with <a>ListLayers</a> and <a>ListLayerVersions</a>.</p> <p>The following list includes deprecated runtimes. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-support-policy">Runtime deprecation policy</a>.</p>', 'PublishLayerVersionResponse$CompatibleRuntimes' => '<p>The layer\'s compatible runtimes.</p> <p>The following list includes deprecated runtimes. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-support-policy">Runtime deprecation policy</a>.</p>', ], ], 'Concurrency' => [ 'base' => NULL, 'refs' => [ 'GetFunctionResponse$Concurrency' => '<p>The function\'s <a href="https://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html">reserved concurrency</a>.</p>', ], ], 'Cors' => [ 'base' => '<p>The <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS">cross-origin resource sharing (CORS)</a> settings for your Lambda function URL. Use CORS to grant access to your function URL from any origin. You can also use CORS to control access for specific HTTP headers and methods in requests to your function URL.</p>', 'refs' => [ 'CreateFunctionUrlConfigRequest$Cors' => '<p>The <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS">cross-origin resource sharing (CORS)</a> settings for your function URL.</p>', 'CreateFunctionUrlConfigResponse$Cors' => '<p>The <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS">cross-origin resource sharing (CORS)</a> settings for your function URL.</p>', 'FunctionUrlConfig$Cors' => '<p>The <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS">cross-origin resource sharing (CORS)</a> settings for your function URL.</p>', 'GetFunctionUrlConfigResponse$Cors' => '<p>The <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS">cross-origin resource sharing (CORS)</a> settings for your function URL.</p>', 'UpdateFunctionUrlConfigRequest$Cors' => '<p>The <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS">cross-origin resource sharing (CORS)</a> settings for your function URL.</p>', 'UpdateFunctionUrlConfigResponse$Cors' => '<p>The <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS">cross-origin resource sharing (CORS)</a> settings for your function URL.</p>', ], ], 'CreateAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateCodeSigningConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateCodeSigningConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateEventSourceMappingRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateFunctionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateFunctionUrlConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateFunctionUrlConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'DatabaseName' => [ 'base' => NULL, 'refs' => [ 'DocumentDBEventSourceConfig$DatabaseName' => '<p> The name of the database to consume within the DocumentDB cluster. </p>', ], ], 'Date' => [ 'base' => NULL, 'refs' => [ 'CreateEventSourceMappingRequest$StartingPositionTimestamp' => '<p>With <code>StartingPosition</code> set to <code>AT_TIMESTAMP</code>, the time from which to start reading. <code>StartingPositionTimestamp</code> cannot be in the future.</p>', 'EventSourceMappingConfiguration$StartingPositionTimestamp' => '<p>With <code>StartingPosition</code> set to <code>AT_TIMESTAMP</code>, the time from which to start reading. <code>StartingPositionTimestamp</code> cannot be in the future.</p>', 'EventSourceMappingConfiguration$LastModified' => '<p>The date that the event source mapping was last updated or that its state changed.</p>', 'FunctionEventInvokeConfig$LastModified' => '<p>The date and time that the configuration was last updated.</p>', ], ], 'DeadLetterConfig' => [ 'base' => '<p>The <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#dlq">dead-letter queue</a> for failed asynchronous invocations.</p>', 'refs' => [ 'CreateFunctionRequest$DeadLetterConfig' => '<p>A dead-letter queue configuration that specifies the queue or topic where Lambda sends asynchronous events when they fail processing. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#invocation-dlq">Dead-letter queues</a>.</p>', 'FunctionConfiguration$DeadLetterConfig' => '<p>The function\'s dead letter queue.</p>', 'UpdateFunctionConfigurationRequest$DeadLetterConfig' => '<p>A dead-letter queue configuration that specifies the queue or topic where Lambda sends asynchronous events when they fail processing. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#invocation-dlq">Dead-letter queues</a>.</p>', ], ], 'DeleteAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCodeSigningConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCodeSigningConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEventSourceMappingRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFunctionCodeSigningConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFunctionConcurrencyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFunctionEventInvokeConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFunctionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFunctionUrlConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLayerVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteProvisionedConcurrencyConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'AliasConfiguration$Description' => '<p>A description of the alias.</p>', 'CodeSigningConfig$Description' => '<p>Code signing configuration description.</p>', 'CreateAliasRequest$Description' => '<p>A description of the alias.</p>', 'CreateCodeSigningConfigRequest$Description' => '<p>Descriptive name for this code signing configuration.</p>', 'CreateFunctionRequest$Description' => '<p>A description of the function.</p>', 'FunctionConfiguration$Description' => '<p>The function\'s description.</p>', 'GetLayerVersionResponse$Description' => '<p>The description of the version.</p>', 'LayerVersionsListItem$Description' => '<p>The description of the version.</p>', 'PublishLayerVersionRequest$Description' => '<p>The description of the version.</p>', 'PublishLayerVersionResponse$Description' => '<p>The description of the version.</p>', 'PublishVersionRequest$Description' => '<p>A description for the version to override the description in the function configuration.</p>', 'UpdateAliasRequest$Description' => '<p>A description of the alias.</p>', 'UpdateCodeSigningConfigRequest$Description' => '<p>Descriptive name for this code signing configuration.</p>', 'UpdateFunctionConfigurationRequest$Description' => '<p>A description of the function.</p>', ], ], 'DestinationArn' => [ 'base' => NULL, 'refs' => [ 'OnFailure$Destination' => '<p>The Amazon Resource Name (ARN) of the destination resource.</p> <p>To retain records of <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#invocation-async-destinations">asynchronous invocations</a>, you can configure an Amazon SNS topic, Amazon SQS queue, Lambda function, or Amazon EventBridge event bus as the destination.</p> <p>To retain records of failed invocations from <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventsourcemapping.html#event-source-mapping-destinations">Kinesis and DynamoDB event sources</a>, you can configure an Amazon SNS topic or Amazon SQS queue as the destination.</p> <p>To retain records of failed invocations from <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-kafka.html#services-smaa-onfailure-destination">self-managed Kafka</a> or <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html#services-msk-onfailure-destination">Amazon MSK</a>, you can configure an Amazon SNS topic, Amazon SQS queue, or Amazon S3 bucket as the destination.</p>', 'OnSuccess$Destination' => '<p>The Amazon Resource Name (ARN) of the destination resource.</p>', ], ], 'DestinationConfig' => [ 'base' => '<p>A configuration object that specifies the destination of an event after Lambda processes it.</p>', 'refs' => [ 'CreateEventSourceMappingRequest$DestinationConfig' => '<p>(Kinesis, DynamoDB Streams, Amazon MSK, and self-managed Kafka only) A configuration object that specifies the destination of an event after Lambda processes it.</p>', 'EventSourceMappingConfiguration$DestinationConfig' => '<p>(Kinesis, DynamoDB Streams, Amazon MSK, and self-managed Apache Kafka event sources only) A configuration object that specifies the destination of an event after Lambda processes it.</p>', 'FunctionEventInvokeConfig$DestinationConfig' => '<p>A destination for events after they have been sent to a function for processing.</p> <p class="title"> <b>Destinations</b> </p> <ul> <li> <p> <b>Function</b> - The Amazon Resource Name (ARN) of a Lambda function.</p> </li> <li> <p> <b>Queue</b> - The ARN of a standard SQS queue.</p> </li> <li> <p> <b>Topic</b> - The ARN of a standard SNS topic.</p> </li> <li> <p> <b>Event Bus</b> - The ARN of an Amazon EventBridge event bus.</p> </li> </ul>', 'PutFunctionEventInvokeConfigRequest$DestinationConfig' => '<p>A destination for events after they have been sent to a function for processing.</p> <p class="title"> <b>Destinations</b> </p> <ul> <li> <p> <b>Function</b> - The Amazon Resource Name (ARN) of a Lambda function.</p> </li> <li> <p> <b>Queue</b> - The ARN of a standard SQS queue.</p> </li> <li> <p> <b>Topic</b> - The ARN of a standard SNS topic.</p> </li> <li> <p> <b>Event Bus</b> - The ARN of an Amazon EventBridge event bus.</p> </li> </ul>', 'UpdateEventSourceMappingRequest$DestinationConfig' => '<p>(Kinesis, DynamoDB Streams, Amazon MSK, and self-managed Kafka only) A configuration object that specifies the destination of an event after Lambda processes it.</p>', 'UpdateFunctionEventInvokeConfigRequest$DestinationConfig' => '<p>A destination for events after they have been sent to a function for processing.</p> <p class="title"> <b>Destinations</b> </p> <ul> <li> <p> <b>Function</b> - The Amazon Resource Name (ARN) of a Lambda function.</p> </li> <li> <p> <b>Queue</b> - The ARN of a standard SQS queue.</p> </li> <li> <p> <b>Topic</b> - The ARN of a standard SNS topic.</p> </li> <li> <p> <b>Event Bus</b> - The ARN of an Amazon EventBridge event bus.</p> </li> </ul>', ], ], 'DocumentDBEventSourceConfig' => [ 'base' => '<p> Specific configuration settings for a DocumentDB event source. </p>', 'refs' => [ 'CreateEventSourceMappingRequest$DocumentDBEventSourceConfig' => '<p>Specific configuration settings for a DocumentDB event source.</p>', 'EventSourceMappingConfiguration$DocumentDBEventSourceConfig' => '<p>Specific configuration settings for a DocumentDB event source.</p>', 'UpdateEventSourceMappingRequest$DocumentDBEventSourceConfig' => '<p>Specific configuration settings for a DocumentDB event source.</p>', ], ], 'EC2AccessDeniedException' => [ 'base' => '<p>Need additional permissions to configure VPC settings.</p>', 'refs' => [], ], 'EC2ThrottledException' => [ 'base' => '<p>Amazon EC2 throttled Lambda during Lambda function initialization using the execution role provided for the function.</p>', 'refs' => [], ], 'EC2UnexpectedException' => [ 'base' => '<p>Lambda received an unexpected Amazon EC2 client exception while setting up for the Lambda function.</p>', 'refs' => [], ], 'EFSIOException' => [ 'base' => '<p>An error occurred when reading from or writing to a connected file system.</p>', 'refs' => [], ], 'EFSMountConnectivityException' => [ 'base' => '<p>The Lambda function couldn\'t make a network connection to the configured file system.</p>', 'refs' => [], ], 'EFSMountFailureException' => [ 'base' => '<p>The Lambda function couldn\'t mount the configured file system due to a permission or configuration issue.</p>', 'refs' => [], ], 'EFSMountTimeoutException' => [ 'base' => '<p>The Lambda function made a network connection to the configured file system, but the mount operation timed out.</p>', 'refs' => [], ], 'ENILimitReachedException' => [ 'base' => '<p>Lambda couldn\'t create an elastic network interface in the VPC, specified as part of Lambda function configuration, because the limit for network interfaces has been reached. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html">Lambda quotas</a>.</p>', 'refs' => [], ], 'Enabled' => [ 'base' => NULL, 'refs' => [ 'CreateEventSourceMappingRequest$Enabled' => '<p>When true, the event source mapping is active. When false, Lambda pauses polling and invocation.</p> <p>Default: True</p>', 'UpdateEventSourceMappingRequest$Enabled' => '<p>When true, the event source mapping is active. When false, Lambda pauses polling and invocation.</p> <p>Default: True</p>', ], ], 'EndPointType' => [ 'base' => NULL, 'refs' => [ 'Endpoints$key' => NULL, ], ], 'Endpoint' => [ 'base' => NULL, 'refs' => [ 'EndpointLists$member' => NULL, ], ], 'EndpointLists' => [ 'base' => NULL, 'refs' => [ 'Endpoints$value' => NULL, ], ], 'Endpoints' => [ 'base' => NULL, 'refs' => [ 'SelfManagedEventSource$Endpoints' => '<p>The list of bootstrap servers for your Kafka brokers in the following format: <code>"KAFKA_BOOTSTRAP_SERVERS": ["abc.xyz.com:xxxx","abc2.xyz.com:xxxx"]</code>.</p>', ], ], 'Environment' => [ 'base' => '<p>A function\'s environment variable settings. You can use environment variables to adjust your function\'s behavior without updating code. An environment variable is a pair of strings that are stored in a function\'s version-specific configuration.</p>', 'refs' => [ 'CreateFunctionRequest$Environment' => '<p>Environment variables that are accessible from function code during execution.</p>', 'UpdateFunctionConfigurationRequest$Environment' => '<p>Environment variables that are accessible from function code during execution.</p>', ], ], 'EnvironmentError' => [ 'base' => '<p>Error messages for environment variables that couldn\'t be applied.</p>', 'refs' => [ 'EnvironmentResponse$Error' => '<p>Error messages for environment variables that couldn\'t be applied.</p>', ], ], 'EnvironmentResponse' => [ 'base' => '<p>The results of an operation to update or read environment variables. If the operation succeeds, the response contains the environment variables. If it fails, the response contains details about the error.</p>', 'refs' => [ 'FunctionConfiguration$Environment' => '<p>The function\'s <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html">environment variables</a>. Omitted from CloudTrail logs.</p>', ], ], 'EnvironmentVariableName' => [ 'base' => NULL, 'refs' => [ 'EnvironmentVariables$key' => NULL, ], ], 'EnvironmentVariableValue' => [ 'base' => NULL, 'refs' => [ 'EnvironmentVariables$value' => NULL, ], ], 'EnvironmentVariables' => [ 'base' => NULL, 'refs' => [ 'Environment$Variables' => '<p>Environment variable key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html">Using Lambda environment variables</a>.</p>', 'EnvironmentResponse$Variables' => '<p>Environment variable key-value pairs. Omitted from CloudTrail logs.</p>', ], ], 'EphemeralStorage' => [ 'base' => '<p>The size of the function\'s <code>/tmp</code> directory in MB. The default value is 512, but can be any whole number between 512 and 10,240 MB. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-function-common.html#configuration-ephemeral-storage">Configuring ephemeral storage (console)</a>.</p>', 'refs' => [ 'CreateFunctionRequest$EphemeralStorage' => '<p>The size of the function\'s <code>/tmp</code> directory in MB. The default value is 512, but can be any whole number between 512 and 10,240 MB. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-function-common.html#configuration-ephemeral-storage">Configuring ephemeral storage (console)</a>.</p>', 'FunctionConfiguration$EphemeralStorage' => '<p>The size of the function\'s <code>/tmp</code> directory in MB. The default value is 512, but can be any whole number between 512 and 10,240 MB. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-function-common.html#configuration-ephemeral-storage">Configuring ephemeral storage (console)</a>.</p>', 'UpdateFunctionConfigurationRequest$EphemeralStorage' => '<p>The size of the function\'s <code>/tmp</code> directory in MB. The default value is 512, but can be any whole number between 512 and 10,240 MB. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-function-common.html#configuration-ephemeral-storage">Configuring ephemeral storage (console)</a>.</p>', ], ], 'EphemeralStorageSize' => [ 'base' => NULL, 'refs' => [ 'EphemeralStorage$Size' => '<p>The size of the function\'s <code>/tmp</code> directory.</p>', ], ], 'EventSourceMappingConfiguration' => [ 'base' => '<p>A mapping between an Amazon Web Services resource and a Lambda function. For details, see <a>CreateEventSourceMapping</a>.</p>', 'refs' => [ 'EventSourceMappingsList$member' => NULL, ], ], 'EventSourceMappingsList' => [ 'base' => NULL, 'refs' => [ 'ListEventSourceMappingsResponse$EventSourceMappings' => '<p>A list of event source mappings.</p>', ], ], 'EventSourcePosition' => [ 'base' => NULL, 'refs' => [ 'CreateEventSourceMappingRequest$StartingPosition' => '<p>The position in a stream from which to start reading. Required for Amazon Kinesis and Amazon DynamoDB Stream event sources. <code>AT_TIMESTAMP</code> is supported only for Amazon Kinesis streams, Amazon DocumentDB, Amazon MSK, and self-managed Apache Kafka.</p>', 'EventSourceMappingConfiguration$StartingPosition' => '<p>The position in a stream from which to start reading. Required for Amazon Kinesis and Amazon DynamoDB Stream event sources. <code>AT_TIMESTAMP</code> is supported only for Amazon Kinesis streams, Amazon DocumentDB, Amazon MSK, and self-managed Apache Kafka.</p>', ], ], 'EventSourceToken' => [ 'base' => NULL, 'refs' => [ 'AddPermissionRequest$EventSourceToken' => '<p>For Alexa Smart Home functions, a token that the invoker must supply.</p>', ], ], 'FileSystemArn' => [ 'base' => NULL, 'refs' => [ 'FileSystemConfig$Arn' => '<p>The Amazon Resource Name (ARN) of the Amazon EFS access point that provides access to the file system.</p>', ], ], 'FileSystemConfig' => [ 'base' => '<p>Details about the connection between a Lambda function and an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-filesystem.html">Amazon EFS file system</a>.</p>', 'refs' => [ 'FileSystemConfigList$member' => NULL, ], ], 'FileSystemConfigList' => [ 'base' => NULL, 'refs' => [ 'CreateFunctionRequest$FileSystemConfigs' => '<p>Connection settings for an Amazon EFS file system.</p>', 'FunctionConfiguration$FileSystemConfigs' => '<p>Connection settings for an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-filesystem.html">Amazon EFS file system</a>.</p>', 'UpdateFunctionConfigurationRequest$FileSystemConfigs' => '<p>Connection settings for an Amazon EFS file system.</p>', ], ], 'Filter' => [ 'base' => '<p> A structure within a <code>FilterCriteria</code> object that defines an event filtering pattern. </p>', 'refs' => [ 'FilterList$member' => NULL, ], ], 'FilterCriteria' => [ 'base' => '<p> An object that contains the filters for an event source. </p>', 'refs' => [ 'CreateEventSourceMappingRequest$FilterCriteria' => '<p>An object that defines the filter criteria that determine whether Lambda should process an event. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html">Lambda event filtering</a>.</p>', 'EventSourceMappingConfiguration$FilterCriteria' => '<p>An object that defines the filter criteria that determine whether Lambda should process an event. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html">Lambda event filtering</a>.</p>', 'UpdateEventSourceMappingRequest$FilterCriteria' => '<p>An object that defines the filter criteria that determine whether Lambda should process an event. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html">Lambda event filtering</a>.</p>', ], ], 'FilterList' => [ 'base' => NULL, 'refs' => [ 'FilterCriteria$Filters' => '<p> A list of filters. </p>', ], ], 'FullDocument' => [ 'base' => NULL, 'refs' => [ 'DocumentDBEventSourceConfig$FullDocument' => '<p> Determines what DocumentDB sends to your event stream during document update operations. If set to UpdateLookup, DocumentDB sends a delta describing the changes, along with a copy of the entire document. Otherwise, DocumentDB sends only a partial document that contains the changes. </p>', ], ], 'FunctionArn' => [ 'base' => NULL, 'refs' => [ 'AliasConfiguration$AliasArn' => '<p>The Amazon Resource Name (ARN) of the alias.</p>', 'CreateFunctionUrlConfigResponse$FunctionArn' => '<p>The Amazon Resource Name (ARN) of your function.</p>', 'EventSourceMappingConfiguration$FunctionArn' => '<p>The ARN of the Lambda function.</p>', 'FunctionArnList$member' => NULL, 'FunctionConfiguration$MasterArn' => '<p>For Lambda@Edge functions, the ARN of the main function.</p>', 'FunctionEventInvokeConfig$FunctionArn' => '<p>The Amazon Resource Name (ARN) of the function.</p>', 'FunctionUrlConfig$FunctionArn' => '<p>The Amazon Resource Name (ARN) of your function.</p>', 'GetFunctionUrlConfigResponse$FunctionArn' => '<p>The Amazon Resource Name (ARN) of your function.</p>', 'ListTagsRequest$Resource' => '<p>The function\'s Amazon Resource Name (ARN). Note: Lambda does not support adding tags to aliases or versions.</p>', 'ProvisionedConcurrencyConfigListItem$FunctionArn' => '<p>The Amazon Resource Name (ARN) of the alias or version.</p>', 'PutRuntimeManagementConfigResponse$FunctionArn' => '<p>The ARN of the function</p>', 'TagResourceRequest$Resource' => '<p>The function\'s Amazon Resource Name (ARN).</p>', 'UntagResourceRequest$Resource' => '<p>The function\'s Amazon Resource Name (ARN).</p>', 'UpdateFunctionUrlConfigResponse$FunctionArn' => '<p>The Amazon Resource Name (ARN) of your function.</p>', ], ], 'FunctionArnList' => [ 'base' => NULL, 'refs' => [ 'ListFunctionsByCodeSigningConfigResponse$FunctionArns' => '<p>The function ARNs. </p>', ], ], 'FunctionCode' => [ 'base' => '<p>The code for the Lambda function. You can either specify an object in Amazon S3, upload a .zip file archive deployment package directly, or specify the URI of a container image.</p>', 'refs' => [ 'CreateFunctionRequest$Code' => '<p>The code for the function.</p>', ], ], 'FunctionCodeLocation' => [ 'base' => '<p>Details about a function\'s deployment package.</p>', 'refs' => [ 'GetFunctionResponse$Code' => '<p>The deployment package of the function or version.</p>', ], ], 'FunctionConfiguration' => [ 'base' => '<p>Details about a function\'s configuration.</p>', 'refs' => [ 'FunctionList$member' => NULL, 'GetFunctionResponse$Configuration' => '<p>The configuration of the function or version.</p>', ], ], 'FunctionEventInvokeConfig' => [ 'base' => NULL, 'refs' => [ 'FunctionEventInvokeConfigList$member' => NULL, ], ], 'FunctionEventInvokeConfigList' => [ 'base' => NULL, 'refs' => [ 'ListFunctionEventInvokeConfigsResponse$FunctionEventInvokeConfigs' => '<p>A list of configurations.</p>', ], ], 'FunctionList' => [ 'base' => NULL, 'refs' => [ 'ListFunctionsResponse$Functions' => '<p>A list of Lambda functions.</p>', 'ListVersionsByFunctionResponse$Versions' => '<p>A list of Lambda function versions.</p>', ], ], 'FunctionName' => [ 'base' => NULL, 'refs' => [ 'AddPermissionRequest$FunctionName' => '<p>The name or ARN of the Lambda function, version, or alias.</p> <p class="title"> <b>Name formats</b> </p> <ul> <li> <p> <b>Function name</b> – <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li> <li> <p> <b>Function ARN</b> – <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li> <li> <p> <b>Partial ARN</b> – <code>123456789012:function:my-function</code>.</p> </li> </ul> <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>', 'CreateAliasRequest$FunctionName' => '<p>The name or ARN of the Lambda function.</p> <p class="title"> <b>Name formats</b> </p> <ul> <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li> <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li> <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li> </ul> <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>', 'CreateEventSourceMappingRequest$FunctionName' => '<p>The name or ARN of the Lambda function.</p> <p class="title"> <b>Name formats</b> </p> <ul> <li> <p> <b>Function name</b> – <code>MyFunction</code>.</p> </li> <li> <p> <b>Function ARN</b> – <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li> <li> <p> <b>Version or Alias ARN</b> – <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD</code>.</p> </li> <li> <p> <b>Partial ARN</b> – <code>123456789012:function:MyFunction</code>.</p> </li> </ul> <p>The length constraint applies only to the full ARN. If you specify only the function name, it\'s limited to 64 characters in length.</p>', 'CreateFunctionRequest$FunctionName' => '<p>The name or ARN of the Lambda function.</p> <p class="title"> <b>Name formats</b> </p> <ul> <li> <p> <b>Function name</b> – <code>my-function</code>.</p> </li> <li> <p> <b>Function ARN</b> – <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li> <li> <p> <b>Partial ARN</b> – <code>123456789012:function:my-function</code>.</p> </li> </ul> <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>', 'CreateFunctionUrlConfigRequest$FunctionName' => '<p>The name or ARN of the Lambda function.</p> <p class="title"> <b>Name formats</b> </p> <ul> <li> <p> <b>Function name</b> – <code>my-function</code>.</p> </li> <li> <p> <b>Function ARN</b> – <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li> <li> <p> <b>Partial ARN</b> – <code>123456789012:function:my-function</code>.</p> </li> </ul> <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>', 'DeleteAliasRequest$FunctionName' => '<p>The name or ARN of the Lambda function.</p> <p class="title"> <b>Name formats</b> </p> <ul> <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li> <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li> <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li> </ul> <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>', 'DeleteFunctionCodeSigningConfigRequest$FunctionName' => '<p>The name or ARN of the Lambda function.</p> <p class="title"> <b>Name formats</b> </p> <ul> <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li> <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li> <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li> </ul> <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>', 'DeleteFunctionConcurrencyRequest$FunctionName' => '<p>The name or ARN of the Lambda function.</p> <p class="title"> <b>Name formats</b> </p> <ul> <li> <p> <b>Function name</b> – <code>my-function</code>.</p> </li> <li> <p> <b>Function ARN</b> – <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li> <li> <p> <b>Partial ARN</b> – <code>123456789012:function:my-function</code>.</p> </li> </ul> <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>', 'DeleteFunctionEventInvokeConfigRequest$FunctionName' => '<p>The name or ARN of the Lambda function, version, or alias.</p> <p class="title"> <b>Name formats</b> </p> <ul> <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li> <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li> <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li> </ul> <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>', 'DeleteFunctionRequest$FunctionName' => '<p>The name or ARN of the Lambda function or version.</p> <p class="title"> <b>Name formats</b> </p> <ul> <li> <p> <b>Function name</b> – <code>my-function</code> (name-only), <code>my-function:1</code> (with version).</p> </li> <li> <p> <b>Function ARN</b> – <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li> <li> <p> <b>Partial ARN</b> – <code>123456789012:function:my-function</code>.</p> </li> </ul> <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>', 'DeleteFunctionUrlConfigRequest$FunctionName' => '<p>The name or ARN of the Lambda function.</p> <p class="title"> <b>Name formats</b> </p> <ul> <li> <p> <b>Function name</b> – <code>my-function</code>.</p> </li> <li> <p> <b>Function ARN</b> – <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li> <li> <p> <b>Partial ARN</b> – <code>123456789012:function:my-function</code>.</p> </li> </ul> <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>', 'DeleteProvisionedConcurrencyConfigRequest$FunctionName' => '<p>The name or ARN of the Lambda function.</p> <p class="title"> <b>Name formats</b> </p> <ul> <li> <p> <b>Function name</b> – <code>my-function</code>.</p> </li> <li> <p> <b>Function ARN</b> – <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li> <li> <p> <b>Partial ARN</b> – <code>123456789012:function:my-function</code>.</p> </li> </ul> <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>', 'GetAliasRequest$FunctionName' => '<p>The name or ARN of the Lambda function.</p> <p class="title"> <b>Name formats</b> </p> <ul> <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li> <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li> <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li> </ul> <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>', 'GetFunctionCodeSigningConfigRequest$FunctionName' => '<p>The name or ARN of the Lambda function.</p> <p class="title"> <b>Name formats</b> </p> <ul> <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li> <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li> <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li> </ul> <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>', 'GetFunctionCodeSigningConfigResponse$FunctionName' => '<p>The name or ARN of the Lambda function.</p> <p class="title"> <b>Name formats</b> </p> <ul> <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li> <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li> <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li> </ul> <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>', 'GetFunctionConcurrencyRequest$FunctionName' => '<p>The name or ARN of the Lambda function.</p> <p class="title"> <b>Name formats</b> </p> <ul> <li> <p> <b>Function name</b> – <code>my-function</code>.</p> </li> <li> <p> <b>Function ARN</b> – <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li> <li> <p> <b>Partial ARN</b> – <code>123456789012:function:my-function</code>.</p> </li> </ul> <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>', 'GetFunctionEventInvokeConfigRequest$FunctionName' => '<p>The name or ARN of the Lambda function, version, or alias.</p> <p class="title"> <b>Name formats</b> </p> <ul> <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li> <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li> <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li> </ul> <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>', 'GetFunctionUrlConfigRequest$FunctionName' => '<p>The name or ARN of the Lambda function.</p> <p class="title"> <b>Name formats</b> </p> <ul> <li> <p> <b>Function name</b> – <code>my-function</code>.</p> </li> <li> <p> <b>Function ARN</b> – <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li> <li> <p> <b>Partial ARN</b> – <code>123456789012:function:my-function</code>.</p> </li> </ul> <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>', 'GetProvisionedConcurrencyConfigRequest$FunctionName' => '<p>The name or ARN of the Lambda function.</p> <p class="title"> <b>Name formats</b> </p> <ul> <li> <p> <b>Function name</b> – <code>my-function</code>.</p> </li> <li> <p> <b>Function ARN</b> – <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li> <li> <p> <b>Partial ARN</b> – <code>123456789012:function:my-function</code>.</p> </li> </ul> <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>', 'ListAliasesRequest$FunctionName' => '<p>The name or ARN of the Lambda function.</p> <p class="title"> <b>Name formats</b> </p> <ul> <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li> <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li> <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li> </ul> <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>', 'ListEventSourceMappingsRequest$FunctionName' => '<p>The name or ARN of the Lambda function.</p> <p class="title"> <b>Name formats</b> </p> <ul> <li> <p> <b>Function name</b> – <code>MyFunction</code>.</p> </li> <li> <p> <b>Function ARN</b> – <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li> <li> <p> <b>Version or Alias ARN</b> – <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD</code>.</p> </li> <li> <p> <b>Partial ARN</b> – <code>123456789012:function:MyFunction</code>.</p> </li> </ul> <p>The length constraint applies only to the full ARN. If you specify only the function name, it\'s limited to 64 characters in length.</p>', 'ListFunctionEventInvokeConfigsRequest$FunctionName' => '<p>The name or ARN of the Lambda function.</p> <p class="title"> <b>Name formats</b> </p> <ul> <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li> <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li> <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li> </ul> <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>', 'ListFunctionUrlConfigsRequest$FunctionName' => '<p>The name or ARN of the Lambda function.</p> <p class="title"> <b>Name formats</b> </p> <ul> <li> <p> <b>Function name</b> – <code>my-function</code>.</p> </li> <li> <p> <b>Function ARN</b> – <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li> <li> <p> <b>Partial ARN</b> – <code>123456789012:function:my-function</code>.</p> </li> </ul> <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>', 'ListProvisionedConcurrencyConfigsRequest$FunctionName' => '<p>The name or ARN of the Lambda function.</p> <p class="title"> <b>Name formats</b> </p> <ul> <li> <p> <b>Function name</b> – <code>my-function</code>.</p> </li> <li> <p> <b>Function ARN</b> – <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li> <li> <p> <b>Partial ARN</b> – <code>123456789012:function:my-function</code>.</p> </li> </ul> <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>', 'PublishVersionRequest$FunctionName' => '<p>The name or ARN of the Lambda function.</p> <p class="title"> <b>Name formats</b> </p> <ul> <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li> <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li> <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li> </ul> <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>', 'PutFunctionCodeSigningConfigRequest$FunctionName' => '<p>The name or ARN of the Lambda function.</p> <p class="title"> <b>Name formats</b> </p> <ul> <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li> <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li> <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li> </ul> <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>', 'PutFunctionCodeSigningConfigResponse$FunctionName' => '<p>The name or ARN of the Lambda function.</p> <p class="title"> <b>Name formats</b> </p> <ul> <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li> <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li> <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li> </ul> <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>', 'PutFunctionConcurrencyRequest$FunctionName' => '<p>The name or ARN of the Lambda function.</p> <p class="title"> <b>Name formats</b> </p> <ul> <li> <p> <b>Function name</b> – <code>my-function</code>.</p> </li> <li> <p> <b>Function ARN</b> – <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li> <li> <p> <b>Partial ARN</b> – <code>123456789012:function:my-function</code>.</p> </li> </ul> <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>', 'PutFunctionEventInvokeConfigRequest$FunctionName' => '<p>The name or ARN of the Lambda function, version, or alias.</p> <p class="title"> <b>Name formats</b> </p> <ul> <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li> <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li> <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li> </ul> <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>', 'PutProvisionedConcurrencyConfigRequest$FunctionName' => '<p>The name or ARN of the Lambda function.</p> <p class="title"> <b>Name formats</b> </p> <ul> <li> <p> <b>Function name</b> – <code>my-function</code>.</p> </li> <li> <p> <b>Function ARN</b> – <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li> <li> <p> <b>Partial ARN</b> – <code>123456789012:function:my-function</code>.</p> </li> </ul> <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>', 'PutRuntimeManagementConfigRequest$FunctionName' => '<p>The name or ARN of the Lambda function.</p> <p class="title"> <b>Name formats</b> </p> <ul> <li> <p> <b>Function name</b> – <code>my-function</code>.</p> </li> <li> <p> <b>Function ARN</b> – <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li> <li> <p> <b>Partial ARN</b> – <code>123456789012:function:my-function</code>.</p> </li> </ul> <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>', 'RemovePermissionRequest$FunctionName' => '<p>The name or ARN of the Lambda function, version, or alias.</p> <p class="title"> <b>Name formats</b> </p> <ul> <li> <p> <b>Function name</b> – <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li> <li> <p> <b>Function ARN</b> – <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li> <li> <p> <b>Partial ARN</b> – <code>123456789012:function:my-function</code>.</p> </li> </ul> <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>', 'UpdateAliasRequest$FunctionName' => '<p>The name or ARN of the Lambda function.</p> <p class="title"> <b>Name formats</b> </p> <ul> <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li> <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li> <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li> </ul> <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>', 'UpdateEventSourceMappingRequest$FunctionName' => '<p>The name or ARN of the Lambda function.</p> <p class="title"> <b>Name formats</b> </p> <ul> <li> <p> <b>Function name</b> – <code>MyFunction</code>.</p> </li> <li> <p> <b>Function ARN</b> – <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li> <li> <p> <b>Version or Alias ARN</b> – <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD</code>.</p> </li> <li> <p> <b>Partial ARN</b> – <code>123456789012:function:MyFunction</code>.</p> </li> </ul> <p>The length constraint applies only to the full ARN. If you specify only the function name, it\'s limited to 64 characters in length.</p>', 'UpdateFunctionCodeRequest$FunctionName' => '<p>The name or ARN of the Lambda function.</p> <p class="title"> <b>Name formats</b> </p> <ul> <li> <p> <b>Function name</b> – <code>my-function</code>.</p> </li> <li> <p> <b>Function ARN</b> – <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li> <li> <p> <b>Partial ARN</b> – <code>123456789012:function:my-function</code>.</p> </li> </ul> <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>', 'UpdateFunctionConfigurationRequest$FunctionName' => '<p>The name or ARN of the Lambda function.</p> <p class="title"> <b>Name formats</b> </p> <ul> <li> <p> <b>Function name</b> – <code>my-function</code>.</p> </li> <li> <p> <b>Function ARN</b> – <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li> <li> <p> <b>Partial ARN</b> – <code>123456789012:function:my-function</code>.</p> </li> </ul> <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>', 'UpdateFunctionEventInvokeConfigRequest$FunctionName' => '<p>The name or ARN of the Lambda function, version, or alias.</p> <p class="title"> <b>Name formats</b> </p> <ul> <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li> <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li> <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li> </ul> <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>', 'UpdateFunctionUrlConfigRequest$FunctionName' => '<p>The name or ARN of the Lambda function.</p> <p class="title"> <b>Name formats</b> </p> <ul> <li> <p> <b>Function name</b> – <code>my-function</code>.</p> </li> <li> <p> <b>Function ARN</b> – <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li> <li> <p> <b>Partial ARN</b> – <code>123456789012:function:my-function</code>.</p> </li> </ul> <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>', ], ], 'FunctionResponseType' => [ 'base' => NULL, 'refs' => [ 'FunctionResponseTypeList$member' => NULL, ], ], 'FunctionResponseTypeList' => [ 'base' => NULL, 'refs' => [ 'CreateEventSourceMappingRequest$FunctionResponseTypes' => '<p>(Kinesis, DynamoDB Streams, and Amazon SQS) A list of current response type enums applied to the event source mapping.</p>', 'EventSourceMappingConfiguration$FunctionResponseTypes' => '<p>(Kinesis, DynamoDB Streams, and Amazon SQS) A list of current response type enums applied to the event source mapping.</p>', 'UpdateEventSourceMappingRequest$FunctionResponseTypes' => '<p>(Kinesis, DynamoDB Streams, and Amazon SQS) A list of current response type enums applied to the event source mapping.</p>', ], ], 'FunctionUrl' => [ 'base' => NULL, 'refs' => [ 'CreateFunctionUrlConfigResponse$FunctionUrl' => '<p>The HTTP URL endpoint for your function.</p>', 'FunctionUrlConfig$FunctionUrl' => '<p>The HTTP URL endpoint for your function.</p>', 'GetFunctionUrlConfigResponse$FunctionUrl' => '<p>The HTTP URL endpoint for your function.</p>', 'UpdateFunctionUrlConfigResponse$FunctionUrl' => '<p>The HTTP URL endpoint for your function.</p>', ], ], 'FunctionUrlAuthType' => [ 'base' => NULL, 'refs' => [ 'AddPermissionRequest$FunctionUrlAuthType' => '<p>The type of authentication that your function URL uses. Set to <code>AWS_IAM</code> if you want to restrict access to authenticated users only. Set to <code>NONE</code> if you want to bypass IAM authentication to create a public endpoint. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html">Security and auth model for Lambda function URLs</a>.</p>', 'CreateFunctionUrlConfigRequest$AuthType' => '<p>The type of authentication that your function URL uses. Set to <code>AWS_IAM</code> if you want to restrict access to authenticated users only. Set to <code>NONE</code> if you want to bypass IAM authentication to create a public endpoint. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html">Security and auth model for Lambda function URLs</a>.</p>', 'CreateFunctionUrlConfigResponse$AuthType' => '<p>The type of authentication that your function URL uses. Set to <code>AWS_IAM</code> if you want to restrict access to authenticated users only. Set to <code>NONE</code> if you want to bypass IAM authentication to create a public endpoint. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html">Security and auth model for Lambda function URLs</a>.</p>', 'FunctionUrlConfig$AuthType' => '<p>The type of authentication that your function URL uses. Set to <code>AWS_IAM</code> if you want to restrict access to authenticated users only. Set to <code>NONE</code> if you want to bypass IAM authentication to create a public endpoint. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html">Security and auth model for Lambda function URLs</a>.</p>', 'GetFunctionUrlConfigResponse$AuthType' => '<p>The type of authentication that your function URL uses. Set to <code>AWS_IAM</code> if you want to restrict access to authenticated users only. Set to <code>NONE</code> if you want to bypass IAM authentication to create a public endpoint. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html">Security and auth model for Lambda function URLs</a>.</p>', 'UpdateFunctionUrlConfigRequest$AuthType' => '<p>The type of authentication that your function URL uses. Set to <code>AWS_IAM</code> if you want to restrict access to authenticated users only. Set to <code>NONE</code> if you want to bypass IAM authentication to create a public endpoint. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html">Security and auth model for Lambda function URLs</a>.</p>', 'UpdateFunctionUrlConfigResponse$AuthType' => '<p>The type of authentication that your function URL uses. Set to <code>AWS_IAM</code> if you want to restrict access to authenticated users only. Set to <code>NONE</code> if you want to bypass IAM authentication to create a public endpoint. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html">Security and auth model for Lambda function URLs</a>.</p>', ], ], 'FunctionUrlConfig' => [ 'base' => '<p>Details about a Lambda function URL.</p>', 'refs' => [ 'FunctionUrlConfigList$member' => NULL, ], ], 'FunctionUrlConfigList' => [ 'base' => NULL, 'refs' => [ 'ListFunctionUrlConfigsResponse$FunctionUrlConfigs' => '<p>A list of function URL configurations.</p>', ], ], 'FunctionUrlQualifier' => [ 'base' => NULL, 'refs' => [ 'CreateFunctionUrlConfigRequest$Qualifier' => '<p>The alias name.</p>', 'DeleteFunctionUrlConfigRequest$Qualifier' => '<p>The alias name.</p>', 'GetFunctionUrlConfigRequest$Qualifier' => '<p>The alias name.</p>', 'UpdateFunctionUrlConfigRequest$Qualifier' => '<p>The alias name.</p>', ], ], 'FunctionVersion' => [ 'base' => NULL, 'refs' => [ 'ListFunctionsRequest$FunctionVersion' => '<p>Set to <code>ALL</code> to include entries for all published versions of each function.</p>', ], ], 'GetAccountSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAccountSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCodeSigningConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCodeSigningConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetEventSourceMappingRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetFunctionCodeSigningConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetFunctionCodeSigningConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetFunctionConcurrencyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetFunctionConcurrencyResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetFunctionConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetFunctionEventInvokeConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetFunctionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetFunctionResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetFunctionUrlConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetFunctionUrlConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetLayerVersionByArnRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetLayerVersionPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetLayerVersionPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetLayerVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetLayerVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetProvisionedConcurrencyConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetProvisionedConcurrencyConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetRuntimeManagementConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRuntimeManagementConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'Handler' => [ 'base' => NULL, 'refs' => [ 'CreateFunctionRequest$Handler' => '<p>The name of the method within your code that Lambda calls to run your function. Handler is required if the deployment package is a .zip file archive. The format includes the file name. It can also include namespaces and other qualifiers, depending on the runtime. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-progmodel.html">Lambda programming model</a>.</p>', 'FunctionConfiguration$Handler' => '<p>The function that Lambda calls to begin running your function.</p>', 'UpdateFunctionConfigurationRequest$Handler' => '<p>The name of the method within your code that Lambda calls to run your function. Handler is required if the deployment package is a .zip file archive. The format includes the file name. It can also include namespaces and other qualifiers, depending on the runtime. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-progmodel.html">Lambda programming model</a>.</p>', ], ], 'Header' => [ 'base' => NULL, 'refs' => [ 'HeadersList$member' => NULL, ], ], 'HeadersList' => [ 'base' => NULL, 'refs' => [ 'Cors$AllowHeaders' => '<p>The HTTP headers that origins can include in requests to your function URL. For example: <code>Date</code>, <code>Keep-Alive</code>, <code>X-Custom-Header</code>.</p>', 'Cors$ExposeHeaders' => '<p>The HTTP headers in your function response that you want to expose to origins that call your function URL. For example: <code>Date</code>, <code>Keep-Alive</code>, <code>X-Custom-Header</code>.</p>', ], ], 'HttpStatus' => [ 'base' => NULL, 'refs' => [ 'InvokeAsyncResponse$Status' => '<p>The status code.</p>', ], ], 'ImageConfig' => [ 'base' => '<p>Configuration values that override the container image Dockerfile settings. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/images-create.html#images-parms">Container image settings</a>.</p>', 'refs' => [ 'CreateFunctionRequest$ImageConfig' => '<p>Container image <a href="https://docs.aws.amazon.com/lambda/latest/dg/images-create.html#images-parms">configuration values</a> that override the values in the container image Dockerfile.</p>', 'ImageConfigResponse$ImageConfig' => '<p>Configuration values that override the container image Dockerfile.</p>', 'UpdateFunctionConfigurationRequest$ImageConfig' => '<p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/images-create.html#images-parms">Container image configuration values</a> that override the values in the container image Docker file.</p>', ], ], 'ImageConfigError' => [ 'base' => '<p>Error response to <code>GetFunctionConfiguration</code>.</p>', 'refs' => [ 'ImageConfigResponse$Error' => '<p>Error response to <code>GetFunctionConfiguration</code>.</p>', ], ], 'ImageConfigResponse' => [ 'base' => '<p>Response to a <code>GetFunctionConfiguration</code> request.</p>', 'refs' => [ 'FunctionConfiguration$ImageConfigResponse' => '<p>The function\'s image configuration values.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'AccountLimit$ConcurrentExecutions' => '<p>The maximum number of simultaneous function executions.</p>', 'InvocationResponse$StatusCode' => '<p>The HTTP status code is in the 200 range for a successful request. For the <code>RequestResponse</code> invocation type, this status code is 200. For the <code>Event</code> invocation type, this status code is 202. For the <code>DryRun</code> invocation type, the status code is 204.</p>', 'InvokeWithResponseStreamResponse$StatusCode' => '<p>For a successful request, the HTTP status code is in the 200 range. For the <code>RequestResponse</code> invocation type, this status code is 200. For the <code>DryRun</code> invocation type, this status code is 204.</p>', ], ], 'InvalidCodeSignatureException' => [ 'base' => '<p>The code signature failed the integrity check. If the integrity check fails, then Lambda blocks deployment, even if the code signing policy is set to WARN.</p>', 'refs' => [], ], 'InvalidParameterValueException' => [ 'base' => '<p>One of the parameters in the request is not valid.</p>', 'refs' => [], ], 'InvalidRequestContentException' => [ 'base' => '<p>The request body could not be parsed as JSON.</p>', 'refs' => [], ], 'InvalidRuntimeException' => [ 'base' => '<p>The runtime or runtime version specified is not supported.</p>', 'refs' => [], ], 'InvalidSecurityGroupIDException' => [ 'base' => '<p>The security group ID provided in the Lambda function VPC configuration is not valid.</p>', 'refs' => [], ], 'InvalidSubnetIDException' => [ 'base' => '<p>The subnet ID provided in the Lambda function VPC configuration is not valid.</p>', 'refs' => [], ], 'InvalidZipFileException' => [ 'base' => '<p>Lambda could not unzip the deployment package.</p>', 'refs' => [], ], 'InvocationRequest' => [ 'base' => NULL, 'refs' => [], ], 'InvocationResponse' => [ 'base' => NULL, 'refs' => [], ], 'InvocationType' => [ 'base' => NULL, 'refs' => [ 'InvocationRequest$InvocationType' => '<p>Choose from the following options.</p> <ul> <li> <p> <code>RequestResponse</code> (default) – Invoke the function synchronously. Keep the connection open until the function returns a response or times out. The API response includes the function response and additional data.</p> </li> <li> <p> <code>Event</code> – Invoke the function asynchronously. Send events that fail multiple times to the function\'s dead-letter queue (if one is configured). The API response only includes a status code.</p> </li> <li> <p> <code>DryRun</code> – Validate parameter values and verify that the user or role has permission to invoke the function.</p> </li> </ul>', ], ], 'InvokeAsyncRequest' => [ 'base' => NULL, 'refs' => [], ], 'InvokeAsyncResponse' => [ 'base' => '<p>A success response (<code>202 Accepted</code>) indicates that the request is queued for invocation.</p>', 'refs' => [], ], 'InvokeMode' => [ 'base' => NULL, 'refs' => [ 'CreateFunctionUrlConfigRequest$InvokeMode' => '<p>Use one of the following options:</p> <ul> <li> <p> <code>BUFFERED</code> – This is the default option. Lambda invokes your function using the <code>Invoke</code> API operation. Invocation results are available when the payload is complete. The maximum payload size is 6 MB.</p> </li> <li> <p> <code>RESPONSE_STREAM</code> – Your function streams payload results as they become available. Lambda invokes your function using the <code>InvokeWithResponseStream</code> API operation. The maximum response payload size is 20 MB, however, you can <a href="https://docs.aws.amazon.com/servicequotas/latest/userguide/request-quota-increase.html">request a quota increase</a>.</p> </li> </ul>', 'CreateFunctionUrlConfigResponse$InvokeMode' => '<p>Use one of the following options:</p> <ul> <li> <p> <code>BUFFERED</code> – This is the default option. Lambda invokes your function using the <code>Invoke</code> API operation. Invocation results are available when the payload is complete. The maximum payload size is 6 MB.</p> </li> <li> <p> <code>RESPONSE_STREAM</code> – Your function streams payload results as they become available. Lambda invokes your function using the <code>InvokeWithResponseStream</code> API operation. The maximum response payload size is 20 MB, however, you can <a href="https://docs.aws.amazon.com/servicequotas/latest/userguide/request-quota-increase.html">request a quota increase</a>.</p> </li> </ul>', 'FunctionUrlConfig$InvokeMode' => '<p>Use one of the following options:</p> <ul> <li> <p> <code>BUFFERED</code> – This is the default option. Lambda invokes your function using the <code>Invoke</code> API operation. Invocation results are available when the payload is complete. The maximum payload size is 6 MB.</p> </li> <li> <p> <code>RESPONSE_STREAM</code> – Your function streams payload results as they become available. Lambda invokes your function using the <code>InvokeWithResponseStream</code> API operation. The maximum response payload size is 20 MB, however, you can <a href="https://docs.aws.amazon.com/servicequotas/latest/userguide/request-quota-increase.html">request a quota increase</a>.</p> </li> </ul>', 'GetFunctionUrlConfigResponse$InvokeMode' => '<p>Use one of the following options:</p> <ul> <li> <p> <code>BUFFERED</code> – This is the default option. Lambda invokes your function using the <code>Invoke</code> API operation. Invocation results are available when the payload is complete. The maximum payload size is 6 MB.</p> </li> <li> <p> <code>RESPONSE_STREAM</code> – Your function streams payload results as they become available. Lambda invokes your function using the <code>InvokeWithResponseStream</code> API operation. The maximum response payload size is 20 MB, however, you can <a href="https://docs.aws.amazon.com/servicequotas/latest/userguide/request-quota-increase.html">request a quota increase</a>.</p> </li> </ul>', 'UpdateFunctionUrlConfigRequest$InvokeMode' => '<p>Use one of the following options:</p> <ul> <li> <p> <code>BUFFERED</code> – This is the default option. Lambda invokes your function using the <code>Invoke</code> API operation. Invocation results are available when the payload is complete. The maximum payload size is 6 MB.</p> </li> <li> <p> <code>RESPONSE_STREAM</code> – Your function streams payload results as they become available. Lambda invokes your function using the <code>InvokeWithResponseStream</code> API operation. The maximum response payload size is 20 MB, however, you can <a href="https://docs.aws.amazon.com/servicequotas/latest/userguide/request-quota-increase.html">request a quota increase</a>.</p> </li> </ul>', 'UpdateFunctionUrlConfigResponse$InvokeMode' => '<p>Use one of the following options:</p> <ul> <li> <p> <code>BUFFERED</code> – This is the default option. Lambda invokes your function using the <code>Invoke</code> API operation. Invocation results are available when the payload is complete. The maximum payload size is 6 MB.</p> </li> <li> <p> <code>RESPONSE_STREAM</code> – Your function streams payload results as they become available. Lambda invokes your function using the <code>InvokeWithResponseStream</code> API operation. The maximum response payload size is 20 MB, however, you can <a href="https://docs.aws.amazon.com/servicequotas/latest/userguide/request-quota-increase.html">request a quota increase</a>.</p> </li> </ul>', ], ], 'InvokeResponseStreamUpdate' => [ 'base' => '<p>A chunk of the streamed response payload.</p>', 'refs' => [ 'InvokeWithResponseStreamResponseEvent$PayloadChunk' => '<p>A chunk of the streamed response payload.</p>', ], ], 'InvokeWithResponseStreamCompleteEvent' => [ 'base' => '<p>A response confirming that the event stream is complete.</p>', 'refs' => [ 'InvokeWithResponseStreamResponseEvent$InvokeComplete' => '<p>An object that\'s returned when the stream has ended and all the payload chunks have been returned.</p>', ], ], 'InvokeWithResponseStreamRequest' => [ 'base' => NULL, 'refs' => [], ], 'InvokeWithResponseStreamResponse' => [ 'base' => NULL, 'refs' => [], ], 'InvokeWithResponseStreamResponseEvent' => [ 'base' => '<p>An object that includes a chunk of the response payload. When the stream has ended, Lambda includes a <code>InvokeComplete</code> object.</p>', 'refs' => [ 'InvokeWithResponseStreamResponse$EventStream' => '<p>The stream of response payloads.</p>', ], ], 'KMSAccessDeniedException' => [ 'base' => '<p>Lambda couldn\'t decrypt the environment variables because KMS access was denied. Check the Lambda function\'s KMS permissions.</p>', 'refs' => [], ], 'KMSDisabledException' => [ 'base' => '<p>Lambda couldn\'t decrypt the environment variables because the KMS key used is disabled. Check the Lambda function\'s KMS key settings.</p>', 'refs' => [], ], 'KMSInvalidStateException' => [ 'base' => '<p>Lambda couldn\'t decrypt the environment variables because the state of the KMS key used is not valid for Decrypt. Check the function\'s KMS key settings.</p>', 'refs' => [], ], 'KMSKeyArn' => [ 'base' => NULL, 'refs' => [ 'CreateFunctionRequest$KMSKeyArn' => '<p>The ARN of the Key Management Service (KMS) customer managed key that\'s used to encrypt your function\'s <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html#configuration-envvars-encryption">environment variables</a>. When <a href="https://docs.aws.amazon.com/lambda/latest/dg/snapstart-security.html">Lambda SnapStart</a> is activated, Lambda also uses this key is to encrypt your function\'s snapshot. If you deploy your function using a container image, Lambda also uses this key to encrypt your function when it\'s deployed. Note that this is not the same key that\'s used to protect your container image in the Amazon Elastic Container Registry (Amazon ECR). If you don\'t provide a customer managed key, Lambda uses a default service key.</p>', 'FunctionConfiguration$KMSKeyArn' => '<p>The KMS key that\'s used to encrypt the function\'s <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html#configuration-envvars-encryption">environment variables</a>. When <a href="https://docs.aws.amazon.com/lambda/latest/dg/snapstart-security.html">Lambda SnapStart</a> is activated, this key is also used to encrypt the function\'s snapshot. This key is returned only if you\'ve configured a customer managed key.</p>', 'UpdateFunctionConfigurationRequest$KMSKeyArn' => '<p>The ARN of the Key Management Service (KMS) customer managed key that\'s used to encrypt your function\'s <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html#configuration-envvars-encryption">environment variables</a>. When <a href="https://docs.aws.amazon.com/lambda/latest/dg/snapstart-security.html">Lambda SnapStart</a> is activated, Lambda also uses this key is to encrypt your function\'s snapshot. If you deploy your function using a container image, Lambda also uses this key to encrypt your function when it\'s deployed. Note that this is not the same key that\'s used to protect your container image in the Amazon Elastic Container Registry (Amazon ECR). If you don\'t provide a customer managed key, Lambda uses a default service key.</p>', ], ], 'KMSNotFoundException' => [ 'base' => '<p>Lambda couldn\'t decrypt the environment variables because the KMS key was not found. Check the function\'s KMS key settings.</p>', 'refs' => [], ], 'LastUpdateStatus' => [ 'base' => NULL, 'refs' => [ 'FunctionConfiguration$LastUpdateStatus' => '<p>The status of the last update that was performed on the function. This is first set to <code>Successful</code> after function creation completes.</p>', ], ], 'LastUpdateStatusReason' => [ 'base' => NULL, 'refs' => [ 'FunctionConfiguration$LastUpdateStatusReason' => '<p>The reason for the last update that was performed on the function.</p>', ], ], 'LastUpdateStatusReasonCode' => [ 'base' => NULL, 'refs' => [ 'FunctionConfiguration$LastUpdateStatusReasonCode' => '<p>The reason code for the last update that was performed on the function.</p>', ], ], 'Layer' => [ 'base' => '<p>An <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda layer</a>.</p>', 'refs' => [ 'LayersReferenceList$member' => NULL, ], ], 'LayerArn' => [ 'base' => NULL, 'refs' => [ 'GetLayerVersionResponse$LayerArn' => '<p>The ARN of the layer.</p>', 'LayersListItem$LayerArn' => '<p>The Amazon Resource Name (ARN) of the function layer.</p>', 'PublishLayerVersionResponse$LayerArn' => '<p>The ARN of the layer.</p>', ], ], 'LayerList' => [ 'base' => NULL, 'refs' => [ 'CreateFunctionRequest$Layers' => '<p>A list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">function layers</a> to add to the function\'s execution environment. Specify each layer by its ARN, including the version.</p>', 'UpdateFunctionConfigurationRequest$Layers' => '<p>A list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">function layers</a> to add to the function\'s execution environment. Specify each layer by its ARN, including the version.</p>', ], ], 'LayerName' => [ 'base' => NULL, 'refs' => [ 'AddLayerVersionPermissionRequest$LayerName' => '<p>The name or Amazon Resource Name (ARN) of the layer.</p>', 'DeleteLayerVersionRequest$LayerName' => '<p>The name or Amazon Resource Name (ARN) of the layer.</p>', 'GetLayerVersionPolicyRequest$LayerName' => '<p>The name or Amazon Resource Name (ARN) of the layer.</p>', 'GetLayerVersionRequest$LayerName' => '<p>The name or Amazon Resource Name (ARN) of the layer.</p>', 'LayersListItem$LayerName' => '<p>The name of the layer.</p>', 'ListLayerVersionsRequest$LayerName' => '<p>The name or Amazon Resource Name (ARN) of the layer.</p>', 'PublishLayerVersionRequest$LayerName' => '<p>The name or Amazon Resource Name (ARN) of the layer.</p>', 'RemoveLayerVersionPermissionRequest$LayerName' => '<p>The name or Amazon Resource Name (ARN) of the layer.</p>', ], ], 'LayerPermissionAllowedAction' => [ 'base' => NULL, 'refs' => [ 'AddLayerVersionPermissionRequest$Action' => '<p>The API action that grants access to the layer. For example, <code>lambda:GetLayerVersion</code>.</p>', ], ], 'LayerPermissionAllowedPrincipal' => [ 'base' => NULL, 'refs' => [ 'AddLayerVersionPermissionRequest$Principal' => '<p>An account ID, or <code>*</code> to grant layer usage permission to all accounts in an organization, or all Amazon Web Services accounts (if <code>organizationId</code> is not specified). For the last case, make sure that you really do want all Amazon Web Services accounts to have usage permission to this layer. </p>', ], ], 'LayerVersionArn' => [ 'base' => NULL, 'refs' => [ 'GetLayerVersionByArnRequest$Arn' => '<p>The ARN of the layer version.</p>', 'GetLayerVersionResponse$LayerVersionArn' => '<p>The ARN of the layer version.</p>', 'Layer$Arn' => '<p>The Amazon Resource Name (ARN) of the function layer.</p>', 'LayerList$member' => NULL, 'LayerVersionsListItem$LayerVersionArn' => '<p>The ARN of the layer version.</p>', 'PublishLayerVersionResponse$LayerVersionArn' => '<p>The ARN of the layer version.</p>', ], ], 'LayerVersionContentInput' => [ 'base' => '<p>A ZIP archive that contains the contents of an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda layer</a>. You can specify either an Amazon S3 location, or upload a layer archive directly.</p>', 'refs' => [ 'PublishLayerVersionRequest$Content' => '<p>The function layer archive.</p>', ], ], 'LayerVersionContentOutput' => [ 'base' => '<p>Details about a version of an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda layer</a>.</p>', 'refs' => [ 'GetLayerVersionResponse$Content' => '<p>Details about the layer version.</p>', 'PublishLayerVersionResponse$Content' => '<p>Details about the layer version.</p>', ], ], 'LayerVersionNumber' => [ 'base' => NULL, 'refs' => [ 'AddLayerVersionPermissionRequest$VersionNumber' => '<p>The version number.</p>', 'DeleteLayerVersionRequest$VersionNumber' => '<p>The version number.</p>', 'GetLayerVersionPolicyRequest$VersionNumber' => '<p>The version number.</p>', 'GetLayerVersionRequest$VersionNumber' => '<p>The version number.</p>', 'GetLayerVersionResponse$Version' => '<p>The version number.</p>', 'LayerVersionsListItem$Version' => '<p>The version number.</p>', 'PublishLayerVersionResponse$Version' => '<p>The version number.</p>', 'RemoveLayerVersionPermissionRequest$VersionNumber' => '<p>The version number.</p>', ], ], 'LayerVersionsList' => [ 'base' => NULL, 'refs' => [ 'ListLayerVersionsResponse$LayerVersions' => '<p>A list of versions.</p>', ], ], 'LayerVersionsListItem' => [ 'base' => '<p>Details about a version of an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda layer</a>.</p>', 'refs' => [ 'LayerVersionsList$member' => NULL, 'LayersListItem$LatestMatchingVersion' => '<p>The newest version of the layer.</p>', ], ], 'LayersList' => [ 'base' => NULL, 'refs' => [ 'ListLayersResponse$Layers' => '<p>A list of function layers.</p>', ], ], 'LayersListItem' => [ 'base' => '<p>Details about an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda layer</a>.</p>', 'refs' => [ 'LayersList$member' => NULL, ], ], 'LayersReferenceList' => [ 'base' => NULL, 'refs' => [ 'FunctionConfiguration$Layers' => '<p>The function\'s <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">layers</a>.</p>', ], ], 'LicenseInfo' => [ 'base' => NULL, 'refs' => [ 'GetLayerVersionResponse$LicenseInfo' => '<p>The layer\'s software license.</p>', 'LayerVersionsListItem$LicenseInfo' => '<p>The layer\'s open-source license.</p>', 'PublishLayerVersionRequest$LicenseInfo' => '<p>The layer\'s software license. It can be any of the following:</p> <ul> <li> <p>An <a href="https://spdx.org/licenses/">SPDX license identifier</a>. For example, <code>MIT</code>.</p> </li> <li> <p>The URL of a license hosted on the internet. For example, <code>https://opensource.org/licenses/MIT</code>.</p> </li> <li> <p>The full text of the license.</p> </li> </ul>', 'PublishLayerVersionResponse$LicenseInfo' => '<p>The layer\'s software license.</p>', ], ], 'ListAliasesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAliasesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListCodeSigningConfigsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCodeSigningConfigsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListEventSourceMappingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListEventSourceMappingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFunctionEventInvokeConfigsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFunctionEventInvokeConfigsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFunctionUrlConfigsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFunctionUrlConfigsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFunctionsByCodeSigningConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFunctionsByCodeSigningConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFunctionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFunctionsResponse' => [ 'base' => '<p>A list of Lambda functions.</p>', 'refs' => [], ], 'ListLayerVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListLayerVersionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListLayersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListLayersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListProvisionedConcurrencyConfigsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListProvisionedConcurrencyConfigsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListVersionsByFunctionRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListVersionsByFunctionResponse' => [ 'base' => NULL, 'refs' => [], ], 'LocalMountPath' => [ 'base' => NULL, 'refs' => [ 'FileSystemConfig$LocalMountPath' => '<p>The path where the function can access the file system, starting with <code>/mnt/</code>.</p>', ], ], 'LogFormat' => [ 'base' => NULL, 'refs' => [ 'LoggingConfig$LogFormat' => '<p>The format in which Lambda sends your function\'s application and system logs to CloudWatch. Select between plain text and structured JSON.</p>', ], ], 'LogGroup' => [ 'base' => NULL, 'refs' => [ 'LoggingConfig$LogGroup' => '<p>The name of the Amazon CloudWatch log group the function sends logs to. By default, Lambda functions send logs to a default log group named <code>/aws/lambda/&lt;function name&gt;</code>. To use a different log group, enter an existing log group or enter a new log group name.</p>', ], ], 'LogType' => [ 'base' => NULL, 'refs' => [ 'InvocationRequest$LogType' => '<p>Set to <code>Tail</code> to include the execution log in the response. Applies to synchronously invoked functions only.</p>', 'InvokeWithResponseStreamRequest$LogType' => '<p>Set to <code>Tail</code> to include the execution log in the response. Applies to synchronously invoked functions only.</p>', ], ], 'LoggingConfig' => [ 'base' => '<p>The function\'s Amazon CloudWatch Logs configuration settings.</p>', 'refs' => [ 'CreateFunctionRequest$LoggingConfig' => '<p>The function\'s Amazon CloudWatch Logs configuration settings.</p>', 'FunctionConfiguration$LoggingConfig' => '<p>The function\'s Amazon CloudWatch Logs configuration settings.</p>', 'UpdateFunctionConfigurationRequest$LoggingConfig' => '<p>The function\'s Amazon CloudWatch Logs configuration settings.</p>', ], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'AccountLimit$TotalCodeSize' => '<p>The amount of storage space that you can use for all deployment packages and layer archives.</p>', 'AccountLimit$CodeSizeUnzipped' => '<p>The maximum size of a function\'s deployment package and layers when they\'re extracted.</p>', 'AccountLimit$CodeSizeZipped' => '<p>The maximum size of a deployment package when it\'s uploaded directly to Lambda. Use Amazon S3 for larger files.</p>', 'AccountUsage$TotalCodeSize' => '<p>The amount of storage space, in bytes, that\'s being used by deployment packages and layer archives.</p>', 'AccountUsage$FunctionCount' => '<p>The number of Lambda functions.</p>', 'FunctionConfiguration$CodeSize' => '<p>The size of the function\'s deployment package, in bytes.</p>', 'Layer$CodeSize' => '<p>The size of the layer archive in bytes.</p>', 'LayerVersionContentOutput$CodeSize' => '<p>The size of the layer archive in bytes.</p>', ], ], 'MasterRegion' => [ 'base' => NULL, 'refs' => [ 'ListFunctionsRequest$MasterRegion' => '<p>For Lambda@Edge functions, the Amazon Web Services Region of the master function. For example, <code>us-east-1</code> filters the list of functions to include only Lambda@Edge functions replicated from a master function in US East (N. Virginia). If specified, you must set <code>FunctionVersion</code> to <code>ALL</code>.</p>', ], ], 'MaxAge' => [ 'base' => NULL, 'refs' => [ 'Cors$MaxAge' => '<p>The maximum amount of time, in seconds, that web browsers can cache results of a preflight request. By default, this is set to <code>0</code>, which means that the browser doesn\'t cache results.</p>', ], ], 'MaxFunctionEventInvokeConfigListItems' => [ 'base' => NULL, 'refs' => [ 'ListFunctionEventInvokeConfigsRequest$MaxItems' => '<p>The maximum number of configurations to return.</p>', ], ], 'MaxItems' => [ 'base' => NULL, 'refs' => [ 'ListFunctionUrlConfigsRequest$MaxItems' => '<p>The maximum number of function URLs to return in the response. Note that <code>ListFunctionUrlConfigs</code> returns a maximum of 50 items in each response, even if you set the number higher.</p>', ], ], 'MaxLayerListItems' => [ 'base' => NULL, 'refs' => [ 'ListLayerVersionsRequest$MaxItems' => '<p>The maximum number of versions to return.</p>', 'ListLayersRequest$MaxItems' => '<p>The maximum number of layers to return.</p>', ], ], 'MaxListItems' => [ 'base' => NULL, 'refs' => [ 'ListAliasesRequest$MaxItems' => '<p>Limit the number of aliases returned.</p>', 'ListCodeSigningConfigsRequest$MaxItems' => '<p>Maximum number of items to return.</p>', 'ListEventSourceMappingsRequest$MaxItems' => '<p>The maximum number of event source mappings to return. Note that ListEventSourceMappings returns a maximum of 100 items in each response, even if you set the number higher.</p>', 'ListFunctionsByCodeSigningConfigRequest$MaxItems' => '<p>Maximum number of items to return.</p>', 'ListFunctionsRequest$MaxItems' => '<p>The maximum number of functions to return in the response. Note that <code>ListFunctions</code> returns a maximum of 50 items in each response, even if you set the number higher.</p>', 'ListVersionsByFunctionRequest$MaxItems' => '<p>The maximum number of versions to return. Note that <code>ListVersionsByFunction</code> returns a maximum of 50 items in each response, even if you set the number higher.</p>', ], ], 'MaxProvisionedConcurrencyConfigListItems' => [ 'base' => NULL, 'refs' => [ 'ListProvisionedConcurrencyConfigsRequest$MaxItems' => '<p>Specify a number to limit the number of configurations returned.</p>', ], ], 'MaximumBatchingWindowInSeconds' => [ 'base' => NULL, 'refs' => [ 'CreateEventSourceMappingRequest$MaximumBatchingWindowInSeconds' => '<p>The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function. You can configure <code>MaximumBatchingWindowInSeconds</code> to any value from 0 seconds to 300 seconds in increments of seconds.</p> <p>For streams and Amazon SQS event sources, the default batching window is 0 seconds. For Amazon MSK, Self-managed Apache Kafka, Amazon MQ, and DocumentDB event sources, the default batching window is 500 ms. Note that because you can only change <code>MaximumBatchingWindowInSeconds</code> in increments of seconds, you cannot revert back to the 500 ms default batching window after you have changed it. To restore the default batching window, you must create a new event source mapping.</p> <p>Related setting: For streams and Amazon SQS event sources, when you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>', 'EventSourceMappingConfiguration$MaximumBatchingWindowInSeconds' => '<p>The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function. You can configure <code>MaximumBatchingWindowInSeconds</code> to any value from 0 seconds to 300 seconds in increments of seconds.</p> <p>For streams and Amazon SQS event sources, the default batching window is 0 seconds. For Amazon MSK, Self-managed Apache Kafka, Amazon MQ, and DocumentDB event sources, the default batching window is 500 ms. Note that because you can only change <code>MaximumBatchingWindowInSeconds</code> in increments of seconds, you cannot revert back to the 500 ms default batching window after you have changed it. To restore the default batching window, you must create a new event source mapping.</p> <p>Related setting: For streams and Amazon SQS event sources, when you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>', 'UpdateEventSourceMappingRequest$MaximumBatchingWindowInSeconds' => '<p>The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function. You can configure <code>MaximumBatchingWindowInSeconds</code> to any value from 0 seconds to 300 seconds in increments of seconds.</p> <p>For streams and Amazon SQS event sources, the default batching window is 0 seconds. For Amazon MSK, Self-managed Apache Kafka, Amazon MQ, and DocumentDB event sources, the default batching window is 500 ms. Note that because you can only change <code>MaximumBatchingWindowInSeconds</code> in increments of seconds, you cannot revert back to the 500 ms default batching window after you have changed it. To restore the default batching window, you must create a new event source mapping.</p> <p>Related setting: For streams and Amazon SQS event sources, when you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>', ], ], 'MaximumConcurrency' => [ 'base' => NULL, 'refs' => [ 'ScalingConfig$MaximumConcurrency' => '<p>Limits the number of concurrent instances that the Amazon SQS event source can invoke.</p>', ], ], 'MaximumEventAgeInSeconds' => [ 'base' => NULL, 'refs' => [ 'FunctionEventInvokeConfig$MaximumEventAgeInSeconds' => '<p>The maximum age of a request that Lambda sends to a function for processing.</p>', 'PutFunctionEventInvokeConfigRequest$MaximumEventAgeInSeconds' => '<p>The maximum age of a request that Lambda sends to a function for processing.</p>', 'UpdateFunctionEventInvokeConfigRequest$MaximumEventAgeInSeconds' => '<p>The maximum age of a request that Lambda sends to a function for processing.</p>', ], ], 'MaximumRecordAgeInSeconds' => [ 'base' => NULL, 'refs' => [ 'CreateEventSourceMappingRequest$MaximumRecordAgeInSeconds' => '<p>(Kinesis and DynamoDB Streams only) Discard records older than the specified age. The default value is infinite (-1).</p>', 'EventSourceMappingConfiguration$MaximumRecordAgeInSeconds' => '<p>(Kinesis and DynamoDB Streams only) Discard records older than the specified age. The default value is -1, which sets the maximum age to infinite. When the value is set to infinite, Lambda never discards old records.</p> <note> <p>The minimum valid value for maximum record age is 60s. Although values less than 60 and greater than -1 fall within the parameter\'s absolute range, they are not allowed</p> </note>', 'UpdateEventSourceMappingRequest$MaximumRecordAgeInSeconds' => '<p>(Kinesis and DynamoDB Streams only) Discard records older than the specified age. The default value is infinite (-1).</p>', ], ], 'MaximumRetryAttempts' => [ 'base' => NULL, 'refs' => [ 'FunctionEventInvokeConfig$MaximumRetryAttempts' => '<p>The maximum number of times to retry when the function returns an error.</p>', 'PutFunctionEventInvokeConfigRequest$MaximumRetryAttempts' => '<p>The maximum number of times to retry when the function returns an error.</p>', 'UpdateFunctionEventInvokeConfigRequest$MaximumRetryAttempts' => '<p>The maximum number of times to retry when the function returns an error.</p>', ], ], 'MaximumRetryAttemptsEventSourceMapping' => [ 'base' => NULL, 'refs' => [ 'CreateEventSourceMappingRequest$MaximumRetryAttempts' => '<p>(Kinesis and DynamoDB Streams only) Discard records after the specified number of retries. The default value is infinite (-1). When set to infinite (-1), failed records are retried until the record expires.</p>', 'EventSourceMappingConfiguration$MaximumRetryAttempts' => '<p>(Kinesis and DynamoDB Streams only) Discard records after the specified number of retries. The default value is -1, which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, Lambda retries failed records until the record expires in the event source.</p>', 'UpdateEventSourceMappingRequest$MaximumRetryAttempts' => '<p>(Kinesis and DynamoDB Streams only) Discard records after the specified number of retries. The default value is infinite (-1). When set to infinite (-1), failed records are retried until the record expires.</p>', ], ], 'MemorySize' => [ 'base' => NULL, 'refs' => [ 'CreateFunctionRequest$MemorySize' => '<p>The amount of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-function-common.html#configuration-memory-console">memory available to the function</a> at runtime. Increasing the function memory also increases its CPU allocation. The default value is 128 MB. The value can be any multiple of 1 MB.</p>', 'FunctionConfiguration$MemorySize' => '<p>The amount of memory available to the function at runtime.</p>', 'UpdateFunctionConfigurationRequest$MemorySize' => '<p>The amount of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-function-common.html#configuration-memory-console">memory available to the function</a> at runtime. Increasing the function memory also increases its CPU allocation. The default value is 128 MB. The value can be any multiple of 1 MB.</p>', ], ], 'Method' => [ 'base' => NULL, 'refs' => [ 'AllowMethodsList$member' => NULL, ], ], 'NameSpacedFunctionArn' => [ 'base' => NULL, 'refs' => [ 'FunctionConfiguration$FunctionArn' => '<p>The function\'s Amazon Resource Name (ARN).</p>', 'GetRuntimeManagementConfigResponse$FunctionArn' => '<p>The Amazon Resource Name (ARN) of your function.</p>', ], ], 'NamespacedFunctionName' => [ 'base' => NULL, 'refs' => [ 'FunctionConfiguration$FunctionName' => '<p>The name of the function.</p>', 'GetFunctionConfigurationRequest$FunctionName' => '<p>The name or ARN of the Lambda function, version, or alias.</p> <p class="title"> <b>Name formats</b> </p> <ul> <li> <p> <b>Function name</b> – <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li> <li> <p> <b>Function ARN</b> – <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li> <li> <p> <b>Partial ARN</b> – <code>123456789012:function:my-function</code>.</p> </li> </ul> <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>', 'GetFunctionRequest$FunctionName' => '<p>The name or ARN of the Lambda function, version, or alias.</p> <p class="title"> <b>Name formats</b> </p> <ul> <li> <p> <b>Function name</b> – <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li> <li> <p> <b>Function ARN</b> – <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li> <li> <p> <b>Partial ARN</b> – <code>123456789012:function:my-function</code>.</p> </li> </ul> <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>', 'GetPolicyRequest$FunctionName' => '<p>The name or ARN of the Lambda function, version, or alias.</p> <p class="title"> <b>Name formats</b> </p> <ul> <li> <p> <b>Function name</b> – <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li> <li> <p> <b>Function ARN</b> – <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li> <li> <p> <b>Partial ARN</b> – <code>123456789012:function:my-function</code>.</p> </li> </ul> <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>', 'GetRuntimeManagementConfigRequest$FunctionName' => '<p>The name or ARN of the Lambda function.</p> <p class="title"> <b>Name formats</b> </p> <ul> <li> <p> <b>Function name</b> – <code>my-function</code>.</p> </li> <li> <p> <b>Function ARN</b> – <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li> <li> <p> <b>Partial ARN</b> – <code>123456789012:function:my-function</code>.</p> </li> </ul> <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>', 'InvocationRequest$FunctionName' => '<p>The name or ARN of the Lambda function, version, or alias.</p> <p class="title"> <b>Name formats</b> </p> <ul> <li> <p> <b>Function name</b> – <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li> <li> <p> <b>Function ARN</b> – <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li> <li> <p> <b>Partial ARN</b> – <code>123456789012:function:my-function</code>.</p> </li> </ul> <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>', 'InvokeAsyncRequest$FunctionName' => '<p>The name or ARN of the Lambda function.</p> <p class="title"> <b>Name formats</b> </p> <ul> <li> <p> <b>Function name</b> – <code>my-function</code>.</p> </li> <li> <p> <b>Function ARN</b> – <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li> <li> <p> <b>Partial ARN</b> – <code>123456789012:function:my-function</code>.</p> </li> </ul> <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>', 'InvokeWithResponseStreamRequest$FunctionName' => '<p>The name or ARN of the Lambda function.</p> <p class="title"> <b>Name formats</b> </p> <ul> <li> <p> <b>Function name</b> – <code>my-function</code>.</p> </li> <li> <p> <b>Function ARN</b> – <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li> <li> <p> <b>Partial ARN</b> – <code>123456789012:function:my-function</code>.</p> </li> </ul> <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>', 'ListVersionsByFunctionRequest$FunctionName' => '<p>The name or ARN of the Lambda function.</p> <p class="title"> <b>Name formats</b> </p> <ul> <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li> <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li> <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li> </ul> <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>', ], ], 'NamespacedStatementId' => [ 'base' => NULL, 'refs' => [ 'RemovePermissionRequest$StatementId' => '<p>Statement ID of the permission to remove.</p>', ], ], 'NonNegativeInteger' => [ 'base' => NULL, 'refs' => [ 'GetProvisionedConcurrencyConfigResponse$AvailableProvisionedConcurrentExecutions' => '<p>The amount of provisioned concurrency available.</p>', 'GetProvisionedConcurrencyConfigResponse$AllocatedProvisionedConcurrentExecutions' => '<p>The amount of provisioned concurrency allocated. When a weighted alias is used during linear and canary deployments, this value fluctuates depending on the amount of concurrency that is provisioned for the function versions.</p>', 'ProvisionedConcurrencyConfigListItem$AvailableProvisionedConcurrentExecutions' => '<p>The amount of provisioned concurrency available.</p>', 'ProvisionedConcurrencyConfigListItem$AllocatedProvisionedConcurrentExecutions' => '<p>The amount of provisioned concurrency allocated. When a weighted alias is used during linear and canary deployments, this value fluctuates depending on the amount of concurrency that is provisioned for the function versions.</p>', 'PutProvisionedConcurrencyConfigResponse$AvailableProvisionedConcurrentExecutions' => '<p>The amount of provisioned concurrency available.</p>', 'PutProvisionedConcurrencyConfigResponse$AllocatedProvisionedConcurrentExecutions' => '<p>The amount of provisioned concurrency allocated. When a weighted alias is used during linear and canary deployments, this value fluctuates depending on the amount of concurrency that is provisioned for the function versions.</p>', ], ], 'NullableBoolean' => [ 'base' => NULL, 'refs' => [ 'VpcConfig$Ipv6AllowedForDualStack' => '<p>Allows outbound IPv6 traffic on VPC functions that are connected to dual-stack subnets.</p>', 'VpcConfigResponse$Ipv6AllowedForDualStack' => '<p>Allows outbound IPv6 traffic on VPC functions that are connected to dual-stack subnets.</p>', ], ], 'OnFailure' => [ 'base' => '<p>A destination for events that failed processing.</p>', 'refs' => [ 'DestinationConfig$OnFailure' => '<p>The destination configuration for failed invocations.</p>', ], ], 'OnSuccess' => [ 'base' => '<p>A destination for events that were processed successfully.</p>', 'refs' => [ 'DestinationConfig$OnSuccess' => '<p>The destination configuration for successful invocations.</p>', ], ], 'OrganizationId' => [ 'base' => NULL, 'refs' => [ 'AddLayerVersionPermissionRequest$OrganizationId' => '<p>With the principal set to <code>*</code>, grant permission to all accounts in the specified organization.</p>', ], ], 'Origin' => [ 'base' => NULL, 'refs' => [ 'AllowOriginsList$member' => NULL, ], ], 'PackageType' => [ 'base' => NULL, 'refs' => [ 'CreateFunctionRequest$PackageType' => '<p>The type of deployment package. Set to <code>Image</code> for container image and set to <code>Zip</code> for .zip file archive.</p>', 'FunctionConfiguration$PackageType' => '<p>The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code> for .zip file archive.</p>', ], ], 'ParallelizationFactor' => [ 'base' => NULL, 'refs' => [ 'CreateEventSourceMappingRequest$ParallelizationFactor' => '<p>(Kinesis and DynamoDB Streams only) The number of batches to process from each shard concurrently.</p>', 'EventSourceMappingConfiguration$ParallelizationFactor' => '<p>(Kinesis and DynamoDB Streams only) The number of batches to process concurrently from each shard. The default value is 1.</p>', 'UpdateEventSourceMappingRequest$ParallelizationFactor' => '<p>(Kinesis and DynamoDB Streams only) The number of batches to process from each shard concurrently.</p>', ], ], 'Pattern' => [ 'base' => NULL, 'refs' => [ 'Filter$Pattern' => '<p> A filter pattern. For more information on the syntax of a filter pattern, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html#filtering-syntax"> Filter rule syntax</a>. </p>', ], ], 'PolicyLengthExceededException' => [ 'base' => '<p>The permissions policy for the resource is too large. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html">Lambda quotas</a>.</p>', 'refs' => [], ], 'PositiveInteger' => [ 'base' => NULL, 'refs' => [ 'GetProvisionedConcurrencyConfigResponse$RequestedProvisionedConcurrentExecutions' => '<p>The amount of provisioned concurrency requested.</p>', 'ProvisionedConcurrencyConfigListItem$RequestedProvisionedConcurrentExecutions' => '<p>The amount of provisioned concurrency requested.</p>', 'PutProvisionedConcurrencyConfigRequest$ProvisionedConcurrentExecutions' => '<p>The amount of provisioned concurrency to allocate for the version or alias.</p>', 'PutProvisionedConcurrencyConfigResponse$RequestedProvisionedConcurrentExecutions' => '<p>The amount of provisioned concurrency requested.</p>', ], ], 'PreconditionFailedException' => [ 'base' => '<p>The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the <code>GetFunction</code> or the <code>GetAlias</code> API operation to retrieve the latest RevisionId for your resource.</p>', 'refs' => [], ], 'Principal' => [ 'base' => NULL, 'refs' => [ 'AddPermissionRequest$Principal' => '<p>The Amazon Web Service or Amazon Web Services account that invokes the function. If you specify a service, use <code>SourceArn</code> or <code>SourceAccount</code> to limit who can invoke the function through that service.</p>', ], ], 'PrincipalOrgID' => [ 'base' => NULL, 'refs' => [ 'AddPermissionRequest$PrincipalOrgID' => '<p>The identifier for your organization in Organizations. Use this to grant permissions to all the Amazon Web Services accounts under this organization.</p>', ], ], 'ProvisionedConcurrencyConfigList' => [ 'base' => NULL, 'refs' => [ 'ListProvisionedConcurrencyConfigsResponse$ProvisionedConcurrencyConfigs' => '<p>A list of provisioned concurrency configurations.</p>', ], ], 'ProvisionedConcurrencyConfigListItem' => [ 'base' => '<p>Details about the provisioned concurrency configuration for a function alias or version.</p>', 'refs' => [ 'ProvisionedConcurrencyConfigList$member' => NULL, ], ], 'ProvisionedConcurrencyConfigNotFoundException' => [ 'base' => '<p>The specified configuration does not exist.</p>', 'refs' => [], ], 'ProvisionedConcurrencyStatusEnum' => [ 'base' => NULL, 'refs' => [ 'GetProvisionedConcurrencyConfigResponse$Status' => '<p>The status of the allocation process.</p>', 'ProvisionedConcurrencyConfigListItem$Status' => '<p>The status of the allocation process.</p>', 'PutProvisionedConcurrencyConfigResponse$Status' => '<p>The status of the allocation process.</p>', ], ], 'PublishLayerVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'PublishLayerVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'PublishVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutFunctionCodeSigningConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutFunctionCodeSigningConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutFunctionConcurrencyRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutFunctionEventInvokeConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutProvisionedConcurrencyConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutProvisionedConcurrencyConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutRuntimeManagementConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutRuntimeManagementConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'Qualifier' => [ 'base' => NULL, 'refs' => [ 'AddPermissionRequest$Qualifier' => '<p>Specify a version or alias to add permissions to a published version of the function.</p>', 'DeleteFunctionEventInvokeConfigRequest$Qualifier' => '<p>A version number or alias name.</p>', 'DeleteFunctionRequest$Qualifier' => '<p>Specify a version to delete. You can\'t delete a version that an alias references.</p>', 'DeleteProvisionedConcurrencyConfigRequest$Qualifier' => '<p>The version number or alias name.</p>', 'GetFunctionConfigurationRequest$Qualifier' => '<p>Specify a version or alias to get details about a published version of the function.</p>', 'GetFunctionEventInvokeConfigRequest$Qualifier' => '<p>A version number or alias name.</p>', 'GetFunctionRequest$Qualifier' => '<p>Specify a version or alias to get details about a published version of the function.</p>', 'GetPolicyRequest$Qualifier' => '<p>Specify a version or alias to get the policy for that resource.</p>', 'GetProvisionedConcurrencyConfigRequest$Qualifier' => '<p>The version number or alias name.</p>', 'GetRuntimeManagementConfigRequest$Qualifier' => '<p>Specify a version of the function. This can be <code>$LATEST</code> or a published version number. If no value is specified, the configuration for the <code>$LATEST</code> version is returned.</p>', 'InvocationRequest$Qualifier' => '<p>Specify a version or alias to invoke a published version of the function.</p>', 'InvokeWithResponseStreamRequest$Qualifier' => '<p>The alias name.</p>', 'PutFunctionEventInvokeConfigRequest$Qualifier' => '<p>A version number or alias name.</p>', 'PutProvisionedConcurrencyConfigRequest$Qualifier' => '<p>The version number or alias name.</p>', 'PutRuntimeManagementConfigRequest$Qualifier' => '<p>Specify a version of the function. This can be <code>$LATEST</code> or a published version number. If no value is specified, the configuration for the <code>$LATEST</code> version is returned.</p>', 'RemovePermissionRequest$Qualifier' => '<p>Specify a version or alias to remove permissions from a published version of the function.</p>', 'UpdateFunctionEventInvokeConfigRequest$Qualifier' => '<p>A version number or alias name.</p>', ], ], 'Queue' => [ 'base' => NULL, 'refs' => [ 'Queues$member' => NULL, ], ], 'Queues' => [ 'base' => NULL, 'refs' => [ 'CreateEventSourceMappingRequest$Queues' => '<p> (MQ) The name of the Amazon MQ broker destination queue to consume. </p>', 'EventSourceMappingConfiguration$Queues' => '<p> (Amazon MQ) The name of the Amazon MQ broker destination queue to consume.</p>', ], ], 'RecursiveInvocationException' => [ 'base' => '<p>Lambda has detected your function being invoked in a recursive loop with other Amazon Web Services resources and stopped your function\'s invocation.</p>', 'refs' => [], ], 'RemoveLayerVersionPermissionRequest' => [ 'base' => NULL, 'refs' => [], ], 'RemovePermissionRequest' => [ 'base' => NULL, 'refs' => [], ], 'RequestTooLargeException' => [ 'base' => '<p>The request payload exceeded the <code>Invoke</code> request body JSON input quota. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html">Lambda quotas</a>.</p>', 'refs' => [], ], 'ReservedConcurrentExecutions' => [ 'base' => NULL, 'refs' => [ 'Concurrency$ReservedConcurrentExecutions' => '<p>The number of concurrent executions that are reserved for this function. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-concurrency.html">Managing Lambda reserved concurrency</a>.</p>', 'GetFunctionConcurrencyResponse$ReservedConcurrentExecutions' => '<p>The number of simultaneous executions that are reserved for the function.</p>', 'PutFunctionConcurrencyRequest$ReservedConcurrentExecutions' => '<p>The number of simultaneous executions to reserve for the function.</p>', ], ], 'ResourceArn' => [ 'base' => NULL, 'refs' => [ 'DeadLetterConfig$TargetArn' => '<p>The Amazon Resource Name (ARN) of an Amazon SQS queue or Amazon SNS topic.</p>', ], ], 'ResourceConflictException' => [ 'base' => '<p>The resource already exists, or another operation is in progress.</p>', 'refs' => [], ], 'ResourceInUseException' => [ 'base' => '<p>The operation conflicts with the resource\'s availability. For example, you tried to update an event source mapping in the CREATING state, or you tried to delete an event source mapping currently UPDATING.</p>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>The resource specified in the request does not exist.</p>', 'refs' => [], ], 'ResourceNotReadyException' => [ 'base' => '<p>The function is inactive and its VPC connection is no longer available. Wait for the VPC connection to reestablish and try again.</p>', 'refs' => [], ], 'ResponseStreamingInvocationType' => [ 'base' => NULL, 'refs' => [ 'InvokeWithResponseStreamRequest$InvocationType' => '<p>Use one of the following options:</p> <ul> <li> <p> <code>RequestResponse</code> (default) – Invoke the function synchronously. Keep the connection open until the function returns a response or times out. The API operation response includes the function response and additional data.</p> </li> <li> <p> <code>DryRun</code> – Validate parameter values and verify that the IAM user or role has permission to invoke the function.</p> </li> </ul>', ], ], 'RoleArn' => [ 'base' => NULL, 'refs' => [ 'CreateFunctionRequest$Role' => '<p>The Amazon Resource Name (ARN) of the function\'s execution role.</p>', 'FunctionConfiguration$Role' => '<p>The function\'s execution role.</p>', 'UpdateFunctionConfigurationRequest$Role' => '<p>The Amazon Resource Name (ARN) of the function\'s execution role.</p>', ], ], 'Runtime' => [ 'base' => NULL, 'refs' => [ 'CompatibleRuntimes$member' => NULL, 'CreateFunctionRequest$Runtime' => '<p>The identifier of the function\'s <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime</a>. Runtime is required if the deployment package is a .zip file archive.</p> <p>The following list includes deprecated runtimes. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-support-policy">Runtime deprecation policy</a>.</p>', 'FunctionConfiguration$Runtime' => '<p>The identifier of the function\'s <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime</a>. Runtime is required if the deployment package is a .zip file archive.</p> <p>The following list includes deprecated runtimes. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-support-policy">Runtime deprecation policy</a>.</p>', 'ListLayerVersionsRequest$CompatibleRuntime' => '<p>A runtime identifier. For example, <code>java21</code>.</p> <p>The following list includes deprecated runtimes. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-support-policy">Runtime deprecation policy</a>.</p>', 'ListLayersRequest$CompatibleRuntime' => '<p>A runtime identifier. For example, <code>java21</code>.</p> <p>The following list includes deprecated runtimes. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-support-policy">Runtime deprecation policy</a>.</p>', 'UpdateFunctionConfigurationRequest$Runtime' => '<p>The identifier of the function\'s <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime</a>. Runtime is required if the deployment package is a .zip file archive.</p> <p>The following list includes deprecated runtimes. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-support-policy">Runtime deprecation policy</a>.</p>', ], ], 'RuntimeVersionArn' => [ 'base' => NULL, 'refs' => [ 'GetRuntimeManagementConfigResponse$RuntimeVersionArn' => '<p>The ARN of the runtime the function is configured to use. If the runtime update mode is <b>Manual</b>, the ARN is returned, otherwise <code>null</code> is returned.</p>', 'PutRuntimeManagementConfigRequest$RuntimeVersionArn' => '<p>The ARN of the runtime version you want the function to use.</p> <note> <p>This is only required if you\'re using the <b>Manual</b> runtime update mode.</p> </note>', 'PutRuntimeManagementConfigResponse$RuntimeVersionArn' => '<p>The ARN of the runtime the function is configured to use. If the runtime update mode is <b>manual</b>, the ARN is returned, otherwise <code>null</code> is returned.</p>', 'RuntimeVersionConfig$RuntimeVersionArn' => '<p>The ARN of the runtime version you want the function to use.</p>', ], ], 'RuntimeVersionConfig' => [ 'base' => '<p>The ARN of the runtime and any errors that occured.</p>', 'refs' => [ 'FunctionConfiguration$RuntimeVersionConfig' => '<p>The ARN of the runtime and any errors that occured.</p>', ], ], 'RuntimeVersionError' => [ 'base' => '<p>Any error returned when the runtime version information for the function could not be retrieved.</p>', 'refs' => [ 'RuntimeVersionConfig$Error' => '<p>Error response when Lambda is unable to retrieve the runtime version for a function.</p>', ], ], 'S3Bucket' => [ 'base' => NULL, 'refs' => [ 'FunctionCode$S3Bucket' => '<p>An Amazon S3 bucket in the same Amazon Web Services Region as your function. The bucket can be in a different Amazon Web Services account.</p>', 'LayerVersionContentInput$S3Bucket' => '<p>The Amazon S3 bucket of the layer archive.</p>', 'UpdateFunctionCodeRequest$S3Bucket' => '<p>An Amazon S3 bucket in the same Amazon Web Services Region as your function. The bucket can be in a different Amazon Web Services account. Use only with a function defined with a .zip file archive deployment package.</p>', ], ], 'S3Key' => [ 'base' => NULL, 'refs' => [ 'FunctionCode$S3Key' => '<p>The Amazon S3 key of the deployment package.</p>', 'LayerVersionContentInput$S3Key' => '<p>The Amazon S3 key of the layer archive.</p>', 'UpdateFunctionCodeRequest$S3Key' => '<p>The Amazon S3 key of the deployment package. Use only with a function defined with a .zip file archive deployment package.</p>', ], ], 'S3ObjectVersion' => [ 'base' => NULL, 'refs' => [ 'FunctionCode$S3ObjectVersion' => '<p>For versioned objects, the version of the deployment package object to use.</p>', 'LayerVersionContentInput$S3ObjectVersion' => '<p>For versioned objects, the version of the layer archive object to use.</p>', 'UpdateFunctionCodeRequest$S3ObjectVersion' => '<p>For versioned objects, the version of the deployment package object to use.</p>', ], ], 'ScalingConfig' => [ 'base' => '<p>(Amazon SQS only) The scaling configuration for the event source. To remove the configuration, pass an empty value.</p>', 'refs' => [ 'CreateEventSourceMappingRequest$ScalingConfig' => '<p>(Amazon SQS only) The scaling configuration for the event source. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-max-concurrency">Configuring maximum concurrency for Amazon SQS event sources</a>.</p>', 'EventSourceMappingConfiguration$ScalingConfig' => '<p>(Amazon SQS only) The scaling configuration for the event source. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-max-concurrency">Configuring maximum concurrency for Amazon SQS event sources</a>.</p>', 'UpdateEventSourceMappingRequest$ScalingConfig' => '<p>(Amazon SQS only) The scaling configuration for the event source. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-max-concurrency">Configuring maximum concurrency for Amazon SQS event sources</a>.</p>', ], ], 'SecurityGroupId' => [ 'base' => NULL, 'refs' => [ 'SecurityGroupIds$member' => NULL, ], ], 'SecurityGroupIds' => [ 'base' => NULL, 'refs' => [ 'VpcConfig$SecurityGroupIds' => '<p>A list of VPC security group IDs.</p>', 'VpcConfigResponse$SecurityGroupIds' => '<p>A list of VPC security group IDs.</p>', ], ], 'SelfManagedEventSource' => [ 'base' => '<p>The self-managed Apache Kafka cluster for your event source.</p>', 'refs' => [ 'CreateEventSourceMappingRequest$SelfManagedEventSource' => '<p>The self-managed Apache Kafka cluster to receive records from.</p>', 'EventSourceMappingConfiguration$SelfManagedEventSource' => '<p>The self-managed Apache Kafka cluster for your event source.</p>', ], ], 'SelfManagedKafkaEventSourceConfig' => [ 'base' => '<p>Specific configuration settings for a self-managed Apache Kafka event source.</p>', 'refs' => [ 'CreateEventSourceMappingRequest$SelfManagedKafkaEventSourceConfig' => '<p>Specific configuration settings for a self-managed Apache Kafka event source.</p>', 'EventSourceMappingConfiguration$SelfManagedKafkaEventSourceConfig' => '<p>Specific configuration settings for a self-managed Apache Kafka event source.</p>', ], ], 'SensitiveString' => [ 'base' => NULL, 'refs' => [ 'EnvironmentError$Message' => '<p>The error message.</p>', 'ImageConfigError$Message' => '<p>Error message.</p>', 'RuntimeVersionError$Message' => '<p>The error message.</p>', ], ], 'ServiceException' => [ 'base' => '<p>The Lambda service encountered an internal error.</p>', 'refs' => [], ], 'SigningProfileVersionArns' => [ 'base' => NULL, 'refs' => [ 'AllowedPublishers$SigningProfileVersionArns' => '<p>The Amazon Resource Name (ARN) for each of the signing profiles. A signing profile defines a trusted user who can sign a code package. </p>', ], ], 'SnapStart' => [ 'base' => '<p>The function\'s <a href="https://docs.aws.amazon.com/lambda/latest/dg/snapstart.html">Lambda SnapStart</a> setting. Set <code>ApplyOn</code> to <code>PublishedVersions</code> to create a snapshot of the initialized execution environment when you publish a function version.</p>', 'refs' => [ 'CreateFunctionRequest$SnapStart' => '<p>The function\'s <a href="https://docs.aws.amazon.com/lambda/latest/dg/snapstart.html">SnapStart</a> setting.</p>', 'UpdateFunctionConfigurationRequest$SnapStart' => '<p>The function\'s <a href="https://docs.aws.amazon.com/lambda/latest/dg/snapstart.html">SnapStart</a> setting.</p>', ], ], 'SnapStartApplyOn' => [ 'base' => NULL, 'refs' => [ 'SnapStart$ApplyOn' => '<p>Set to <code>PublishedVersions</code> to create a snapshot of the initialized execution environment when you publish a function version.</p>', 'SnapStartResponse$ApplyOn' => '<p>When set to <code>PublishedVersions</code>, Lambda creates a snapshot of the execution environment when you publish a function version.</p>', ], ], 'SnapStartException' => [ 'base' => '<p>The <code>afterRestore()</code> <a href="https://docs.aws.amazon.com/lambda/latest/dg/snapstart-runtime-hooks.html">runtime hook</a> encountered an error. For more information, check the Amazon CloudWatch logs.</p>', 'refs' => [], ], 'SnapStartNotReadyException' => [ 'base' => '<p>Lambda is initializing your function. You can invoke the function when the <a href="https://docs.aws.amazon.com/lambda/latest/dg/functions-states.html">function state</a> becomes <code>Active</code>.</p>', 'refs' => [], ], 'SnapStartOptimizationStatus' => [ 'base' => NULL, 'refs' => [ 'SnapStartResponse$OptimizationStatus' => '<p>When you provide a <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-versions.html#versioning-versions-using">qualified Amazon Resource Name (ARN)</a>, this response element indicates whether SnapStart is activated for the specified function version.</p>', ], ], 'SnapStartResponse' => [ 'base' => '<p>The function\'s <a href="https://docs.aws.amazon.com/lambda/latest/dg/snapstart.html">SnapStart</a> setting.</p>', 'refs' => [ 'FunctionConfiguration$SnapStart' => '<p>Set <code>ApplyOn</code> to <code>PublishedVersions</code> to create a snapshot of the initialized execution environment when you publish a function version. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/snapstart.html">Improving startup performance with Lambda SnapStart</a>.</p>', ], ], 'SnapStartTimeoutException' => [ 'base' => '<p>Lambda couldn\'t restore the snapshot within the timeout limit.</p>', 'refs' => [], ], 'SourceAccessConfiguration' => [ 'base' => '<p>To secure and define access to your event source, you can specify the authentication protocol, VPC components, or virtual host.</p>', 'refs' => [ 'SourceAccessConfigurations$member' => NULL, ], ], 'SourceAccessConfigurations' => [ 'base' => NULL, 'refs' => [ 'CreateEventSourceMappingRequest$SourceAccessConfigurations' => '<p>An array of authentication protocols or VPC components required to secure your event source.</p>', 'EventSourceMappingConfiguration$SourceAccessConfigurations' => '<p>An array of the authentication protocol, VPC components, or virtual host to secure and define your event source.</p>', 'UpdateEventSourceMappingRequest$SourceAccessConfigurations' => '<p>An array of authentication protocols or VPC components required to secure your event source.</p>', ], ], 'SourceAccessType' => [ 'base' => NULL, 'refs' => [ 'SourceAccessConfiguration$Type' => '<p>The type of authentication protocol, VPC components, or virtual host for your event source. For example: <code>"Type":"SASL_SCRAM_512_AUTH"</code>.</p> <ul> <li> <p> <code>BASIC_AUTH</code> – (Amazon MQ) The Secrets Manager secret that stores your broker credentials.</p> </li> <li> <p> <code>BASIC_AUTH</code> – (Self-managed Apache Kafka) The Secrets Manager ARN of your secret key used for SASL/PLAIN authentication of your Apache Kafka brokers.</p> </li> <li> <p> <code>VPC_SUBNET</code> – (Self-managed Apache Kafka) The subnets associated with your VPC. Lambda connects to these subnets to fetch data from your self-managed Apache Kafka cluster.</p> </li> <li> <p> <code>VPC_SECURITY_GROUP</code> – (Self-managed Apache Kafka) The VPC security group used to manage access to your self-managed Apache Kafka brokers.</p> </li> <li> <p> <code>SASL_SCRAM_256_AUTH</code> – (Self-managed Apache Kafka) The Secrets Manager ARN of your secret key used for SASL SCRAM-256 authentication of your self-managed Apache Kafka brokers.</p> </li> <li> <p> <code>SASL_SCRAM_512_AUTH</code> – (Amazon MSK, Self-managed Apache Kafka) The Secrets Manager ARN of your secret key used for SASL SCRAM-512 authentication of your self-managed Apache Kafka brokers.</p> </li> <li> <p> <code>VIRTUAL_HOST</code> –- (RabbitMQ) The name of the virtual host in your RabbitMQ broker. Lambda uses this RabbitMQ host as the event source. This property cannot be specified in an UpdateEventSourceMapping API call.</p> </li> <li> <p> <code>CLIENT_CERTIFICATE_TLS_AUTH</code> – (Amazon MSK, self-managed Apache Kafka) The Secrets Manager ARN of your secret key containing the certificate chain (X.509 PEM), private key (PKCS#8 PEM), and private key password (optional) used for mutual TLS authentication of your MSK/Apache Kafka brokers.</p> </li> <li> <p> <code>SERVER_ROOT_CA_CERTIFICATE</code> – (Self-managed Apache Kafka) The Secrets Manager ARN of your secret key containing the root CA certificate (X.509 PEM) used for TLS encryption of your Apache Kafka brokers. </p> </li> </ul>', ], ], 'SourceOwner' => [ 'base' => NULL, 'refs' => [ 'AddPermissionRequest$SourceAccount' => '<p>For Amazon Web Service, the ID of the Amazon Web Services account that owns the resource. Use this together with <code>SourceArn</code> to ensure that the specified account owns the resource. It is possible for an Amazon S3 bucket to be deleted by its owner and recreated by another account.</p>', ], ], 'State' => [ 'base' => NULL, 'refs' => [ 'FunctionConfiguration$State' => '<p>The current state of the function. When the state is <code>Inactive</code>, you can reactivate the function by invoking it.</p>', ], ], 'StateReason' => [ 'base' => NULL, 'refs' => [ 'FunctionConfiguration$StateReason' => '<p>The reason for the function\'s current state.</p>', ], ], 'StateReasonCode' => [ 'base' => NULL, 'refs' => [ 'FunctionConfiguration$StateReasonCode' => '<p>The reason code for the function\'s current state. When the code is <code>Creating</code>, you can\'t invoke or modify the function.</p>', ], ], 'StatementId' => [ 'base' => NULL, 'refs' => [ 'AddLayerVersionPermissionRequest$StatementId' => '<p>An identifier that distinguishes the policy from others on the same layer version.</p>', 'AddPermissionRequest$StatementId' => '<p>A statement identifier that differentiates the statement from others in the same policy.</p>', 'RemoveLayerVersionPermissionRequest$StatementId' => '<p>The identifier that was specified when the statement was added.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AddLayerVersionPermissionRequest$RevisionId' => '<p>Only update the policy if the revision ID matches the ID specified. Use this option to avoid modifying a policy that has changed since you last read it.</p>', 'AddLayerVersionPermissionResponse$Statement' => '<p>The permission statement.</p>', 'AddLayerVersionPermissionResponse$RevisionId' => '<p>A unique identifier for the current revision of the policy.</p>', 'AddPermissionRequest$RevisionId' => '<p>Update the policy only if the revision ID matches the ID that\'s specified. Use this option to avoid modifying a policy that has changed since you last read it.</p>', 'AddPermissionResponse$Statement' => '<p>The permission statement that\'s added to the function policy.</p>', 'AliasConfiguration$RevisionId' => '<p>A unique identifier that changes when you update the alias.</p>', 'CodeSigningConfigNotFoundException$Type' => NULL, 'CodeSigningConfigNotFoundException$Message' => NULL, 'CodeStorageExceededException$Type' => '<p>The exception type.</p>', 'CodeStorageExceededException$message' => NULL, 'CodeVerificationFailedException$Type' => NULL, 'CodeVerificationFailedException$Message' => NULL, 'DeleteEventSourceMappingRequest$UUID' => '<p>The identifier of the event source mapping.</p>', 'EC2AccessDeniedException$Type' => NULL, 'EC2AccessDeniedException$Message' => NULL, 'EC2ThrottledException$Type' => NULL, 'EC2ThrottledException$Message' => NULL, 'EC2UnexpectedException$Type' => NULL, 'EC2UnexpectedException$Message' => NULL, 'EC2UnexpectedException$EC2ErrorCode' => NULL, 'EFSIOException$Type' => NULL, 'EFSIOException$Message' => NULL, 'EFSMountConnectivityException$Type' => NULL, 'EFSMountConnectivityException$Message' => NULL, 'EFSMountFailureException$Type' => NULL, 'EFSMountFailureException$Message' => NULL, 'EFSMountTimeoutException$Type' => NULL, 'EFSMountTimeoutException$Message' => NULL, 'ENILimitReachedException$Type' => NULL, 'ENILimitReachedException$Message' => NULL, 'EnvironmentError$ErrorCode' => '<p>The error code.</p>', 'EventSourceMappingConfiguration$UUID' => '<p>The identifier of the event source mapping.</p>', 'EventSourceMappingConfiguration$LastProcessingResult' => '<p>The result of the last Lambda invocation of your function.</p>', 'EventSourceMappingConfiguration$State' => '<p>The state of the event source mapping. It can be one of the following: <code>Creating</code>, <code>Enabling</code>, <code>Enabled</code>, <code>Disabling</code>, <code>Disabled</code>, <code>Updating</code>, or <code>Deleting</code>.</p>', 'EventSourceMappingConfiguration$StateTransitionReason' => '<p>Indicates whether a user or Lambda made the last change to the event source mapping.</p>', 'FunctionCode$ImageUri' => '<p>URI of a <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-images.html">container image</a> in the Amazon ECR registry.</p>', 'FunctionCodeLocation$RepositoryType' => '<p>The service that\'s hosting the file.</p>', 'FunctionCodeLocation$Location' => '<p>A presigned URL that you can use to download the deployment package.</p>', 'FunctionCodeLocation$ImageUri' => '<p>URI of a container image in the Amazon ECR registry.</p>', 'FunctionCodeLocation$ResolvedImageUri' => '<p>The resolved URI for the image.</p>', 'FunctionConfiguration$CodeSha256' => '<p>The SHA256 hash of the function\'s deployment package.</p>', 'FunctionConfiguration$RevisionId' => '<p>The latest updated revision of the function or alias.</p>', 'GetEventSourceMappingRequest$UUID' => '<p>The identifier of the event source mapping.</p>', 'GetLayerVersionPolicyResponse$Policy' => '<p>The policy document.</p>', 'GetLayerVersionPolicyResponse$RevisionId' => '<p>A unique identifier for the current revision of the policy.</p>', 'GetPolicyResponse$Policy' => '<p>The resource-based policy.</p>', 'GetPolicyResponse$RevisionId' => '<p>A unique identifier for the current revision of the policy.</p>', 'GetProvisionedConcurrencyConfigResponse$StatusReason' => '<p>For failed allocations, the reason that provisioned concurrency could not be allocated.</p>', 'ImageConfigError$ErrorCode' => '<p>Error code.</p>', 'InvalidCodeSignatureException$Type' => NULL, 'InvalidCodeSignatureException$Message' => NULL, 'InvalidParameterValueException$Type' => '<p>The exception type.</p>', 'InvalidParameterValueException$message' => '<p>The exception message.</p>', 'InvalidRequestContentException$Type' => '<p>The exception type.</p>', 'InvalidRequestContentException$message' => '<p>The exception message.</p>', 'InvalidRuntimeException$Type' => NULL, 'InvalidRuntimeException$Message' => NULL, 'InvalidSecurityGroupIDException$Type' => NULL, 'InvalidSecurityGroupIDException$Message' => NULL, 'InvalidSubnetIDException$Type' => NULL, 'InvalidSubnetIDException$Message' => NULL, 'InvalidZipFileException$Type' => NULL, 'InvalidZipFileException$Message' => NULL, 'InvocationRequest$ClientContext' => '<p>Up to 3,583 bytes of base64-encoded data about the invoking client to pass to the function in the context object. Lambda passes the <code>ClientContext</code> object to your function for synchronous invocations only.</p>', 'InvocationResponse$FunctionError' => '<p>If present, indicates that an error occurred during function execution. Details about the error are included in the response payload.</p>', 'InvocationResponse$LogResult' => '<p>The last 4 KB of the execution log, which is base64-encoded.</p>', 'InvokeWithResponseStreamCompleteEvent$ErrorCode' => '<p>An error code.</p>', 'InvokeWithResponseStreamCompleteEvent$ErrorDetails' => '<p>The details of any returned error.</p>', 'InvokeWithResponseStreamCompleteEvent$LogResult' => '<p>The last 4 KB of the execution log, which is base64-encoded.</p>', 'InvokeWithResponseStreamRequest$ClientContext' => '<p>Up to 3,583 bytes of base64-encoded data about the invoking client to pass to the function in the context object.</p>', 'InvokeWithResponseStreamResponse$ResponseStreamContentType' => '<p>The type of data the stream is returning.</p>', 'KMSAccessDeniedException$Type' => NULL, 'KMSAccessDeniedException$Message' => NULL, 'KMSDisabledException$Type' => NULL, 'KMSDisabledException$Message' => NULL, 'KMSInvalidStateException$Type' => NULL, 'KMSInvalidStateException$Message' => NULL, 'KMSNotFoundException$Type' => NULL, 'KMSNotFoundException$Message' => NULL, 'LayerVersionContentOutput$Location' => '<p>A link to the layer archive in Amazon S3 that is valid for 10 minutes.</p>', 'LayerVersionContentOutput$CodeSha256' => '<p>The SHA-256 hash of the layer archive.</p>', 'LayerVersionContentOutput$SigningProfileVersionArn' => '<p>The Amazon Resource Name (ARN) for a signing profile version.</p>', 'LayerVersionContentOutput$SigningJobArn' => '<p>The Amazon Resource Name (ARN) of a signing job.</p>', 'ListAliasesRequest$Marker' => '<p>Specify the pagination token that\'s returned by a previous request to retrieve the next page of results.</p>', 'ListAliasesResponse$NextMarker' => '<p>The pagination token that\'s included if more results are available.</p>', 'ListCodeSigningConfigsRequest$Marker' => '<p>Specify the pagination token that\'s returned by a previous request to retrieve the next page of results.</p>', 'ListCodeSigningConfigsResponse$NextMarker' => '<p>The pagination token that\'s included if more results are available.</p>', 'ListEventSourceMappingsRequest$Marker' => '<p>A pagination token returned by a previous call.</p>', 'ListEventSourceMappingsResponse$NextMarker' => '<p>A pagination token that\'s returned when the response doesn\'t contain all event source mappings.</p>', 'ListFunctionEventInvokeConfigsRequest$Marker' => '<p>Specify the pagination token that\'s returned by a previous request to retrieve the next page of results.</p>', 'ListFunctionEventInvokeConfigsResponse$NextMarker' => '<p>The pagination token that\'s included if more results are available.</p>', 'ListFunctionUrlConfigsRequest$Marker' => '<p>Specify the pagination token that\'s returned by a previous request to retrieve the next page of results.</p>', 'ListFunctionUrlConfigsResponse$NextMarker' => '<p>The pagination token that\'s included if more results are available.</p>', 'ListFunctionsByCodeSigningConfigRequest$Marker' => '<p>Specify the pagination token that\'s returned by a previous request to retrieve the next page of results.</p>', 'ListFunctionsByCodeSigningConfigResponse$NextMarker' => '<p>The pagination token that\'s included if more results are available.</p>', 'ListFunctionsRequest$Marker' => '<p>Specify the pagination token that\'s returned by a previous request to retrieve the next page of results.</p>', 'ListFunctionsResponse$NextMarker' => '<p>The pagination token that\'s included if more results are available.</p>', 'ListLayerVersionsRequest$Marker' => '<p>A pagination token returned by a previous call.</p>', 'ListLayerVersionsResponse$NextMarker' => '<p>A pagination token returned when the response doesn\'t contain all versions.</p>', 'ListLayersRequest$Marker' => '<p>A pagination token returned by a previous call.</p>', 'ListLayersResponse$NextMarker' => '<p>A pagination token returned when the response doesn\'t contain all layers.</p>', 'ListProvisionedConcurrencyConfigsRequest$Marker' => '<p>Specify the pagination token that\'s returned by a previous request to retrieve the next page of results.</p>', 'ListProvisionedConcurrencyConfigsResponse$NextMarker' => '<p>The pagination token that\'s included if more results are available.</p>', 'ListVersionsByFunctionRequest$Marker' => '<p>Specify the pagination token that\'s returned by a previous request to retrieve the next page of results.</p>', 'ListVersionsByFunctionResponse$NextMarker' => '<p>The pagination token that\'s included if more results are available.</p>', 'PolicyLengthExceededException$Type' => NULL, 'PolicyLengthExceededException$message' => NULL, 'PreconditionFailedException$Type' => '<p>The exception type.</p>', 'PreconditionFailedException$message' => '<p>The exception message.</p>', 'ProvisionedConcurrencyConfigListItem$StatusReason' => '<p>For failed allocations, the reason that provisioned concurrency could not be allocated.</p>', 'ProvisionedConcurrencyConfigNotFoundException$Type' => NULL, 'ProvisionedConcurrencyConfigNotFoundException$message' => NULL, 'PublishVersionRequest$CodeSha256' => '<p>Only publish a version if the hash value matches the value that\'s specified. Use this option to avoid publishing a version if the function code has changed since you last updated it. You can get the hash for the version that you uploaded from the output of <a>UpdateFunctionCode</a>.</p>', 'PublishVersionRequest$RevisionId' => '<p>Only update the function if the revision ID matches the ID that\'s specified. Use this option to avoid publishing a version if the function configuration has changed since you last updated it.</p>', 'PutProvisionedConcurrencyConfigResponse$StatusReason' => '<p>For failed allocations, the reason that provisioned concurrency could not be allocated.</p>', 'RecursiveInvocationException$Type' => '<p>The exception type.</p>', 'RecursiveInvocationException$Message' => '<p>The exception message.</p>', 'RemoveLayerVersionPermissionRequest$RevisionId' => '<p>Only update the policy if the revision ID matches the ID specified. Use this option to avoid modifying a policy that has changed since you last read it.</p>', 'RemovePermissionRequest$RevisionId' => '<p>Update the policy only if the revision ID matches the ID that\'s specified. Use this option to avoid modifying a policy that has changed since you last read it.</p>', 'RequestTooLargeException$Type' => NULL, 'RequestTooLargeException$message' => NULL, 'ResourceConflictException$Type' => '<p>The exception type.</p>', 'ResourceConflictException$message' => '<p>The exception message.</p>', 'ResourceInUseException$Type' => NULL, 'ResourceInUseException$Message' => NULL, 'ResourceNotFoundException$Type' => NULL, 'ResourceNotFoundException$Message' => NULL, 'ResourceNotReadyException$Type' => '<p>The exception type.</p>', 'ResourceNotReadyException$message' => '<p>The exception message.</p>', 'RuntimeVersionError$ErrorCode' => '<p>The error code.</p>', 'ServiceException$Type' => NULL, 'ServiceException$Message' => NULL, 'SnapStartException$Type' => NULL, 'SnapStartException$Message' => NULL, 'SnapStartNotReadyException$Type' => NULL, 'SnapStartNotReadyException$Message' => NULL, 'SnapStartTimeoutException$Type' => NULL, 'SnapStartTimeoutException$Message' => NULL, 'StringList$member' => NULL, 'SubnetIPAddressLimitReachedException$Type' => NULL, 'SubnetIPAddressLimitReachedException$Message' => NULL, 'TooManyRequestsException$retryAfterSeconds' => '<p>The number of seconds the caller should wait before retrying.</p>', 'TooManyRequestsException$Type' => NULL, 'TooManyRequestsException$message' => NULL, 'UnsupportedMediaTypeException$Type' => NULL, 'UnsupportedMediaTypeException$message' => NULL, 'UpdateAliasRequest$RevisionId' => '<p>Only update the alias if the revision ID matches the ID that\'s specified. Use this option to avoid modifying an alias that has changed since you last read it.</p>', 'UpdateEventSourceMappingRequest$UUID' => '<p>The identifier of the event source mapping.</p>', 'UpdateFunctionCodeRequest$ImageUri' => '<p>URI of a container image in the Amazon ECR registry. Do not use for a function defined with a .zip file archive.</p>', 'UpdateFunctionCodeRequest$RevisionId' => '<p>Update the function only if the revision ID matches the ID that\'s specified. Use this option to avoid modifying a function that has changed since you last read it.</p>', 'UpdateFunctionConfigurationRequest$RevisionId' => '<p>Update the function only if the revision ID matches the ID that\'s specified. Use this option to avoid modifying a function that has changed since you last read it.</p>', ], ], 'StringList' => [ 'base' => NULL, 'refs' => [ 'ImageConfig$EntryPoint' => '<p>Specifies the entry point to their application, which is typically the location of the runtime executable.</p>', 'ImageConfig$Command' => '<p>Specifies parameters that you want to pass in with ENTRYPOINT.</p>', ], ], 'SubnetIPAddressLimitReachedException' => [ 'base' => '<p>Lambda couldn\'t set up VPC access for the Lambda function because one or more configured subnets has no available IP addresses.</p>', 'refs' => [], ], 'SubnetId' => [ 'base' => NULL, 'refs' => [ 'SubnetIds$member' => NULL, ], ], 'SubnetIds' => [ 'base' => NULL, 'refs' => [ 'VpcConfig$SubnetIds' => '<p>A list of VPC subnet IDs.</p>', 'VpcConfigResponse$SubnetIds' => '<p>A list of VPC subnet IDs.</p>', ], ], 'SystemLogLevel' => [ 'base' => NULL, 'refs' => [ 'LoggingConfig$SystemLogLevel' => '<p>Set this property to filter the system logs for your function that Lambda sends to CloudWatch. Lambda only sends system logs at the selected level of detail and lower, where <code>DEBUG</code> is the highest level and <code>WARN</code> is the lowest.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'Tags$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>A list of tag keys to remove from the function.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tags$value' => NULL, ], ], 'Tags' => [ 'base' => NULL, 'refs' => [ 'CreateFunctionRequest$Tags' => '<p>A list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a> to apply to the function.</p>', 'GetFunctionResponse$Tags' => '<p>The function\'s <a href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a>.</p>', 'ListTagsResponse$Tags' => '<p>The function\'s tags.</p>', 'TagResourceRequest$Tags' => '<p>A list of tags to apply to the function.</p>', ], ], 'ThrottleReason' => [ 'base' => NULL, 'refs' => [ 'TooManyRequestsException$Reason' => NULL, ], ], 'Timeout' => [ 'base' => NULL, 'refs' => [ 'CreateFunctionRequest$Timeout' => '<p>The amount of time (in seconds) that Lambda allows a function to run before stopping it. The default is 3 seconds. The maximum allowed value is 900 seconds. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/runtimes-context.html">Lambda execution environment</a>.</p>', 'FunctionConfiguration$Timeout' => '<p>The amount of time in seconds that Lambda allows a function to run before stopping it.</p>', 'UpdateFunctionConfigurationRequest$Timeout' => '<p>The amount of time (in seconds) that Lambda allows a function to run before stopping it. The default is 3 seconds. The maximum allowed value is 900 seconds. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/runtimes-context.html">Lambda execution environment</a>.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'CodeSigningConfig$LastModified' => '<p>The date and time that the Code signing configuration was last modified, in ISO-8601 format (YYYY-MM-DDThh:mm:ss.sTZD). </p>', 'CreateFunctionUrlConfigResponse$CreationTime' => '<p>When the function URL was created, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>', 'FunctionConfiguration$LastModified' => '<p>The date and time that the function was last updated, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>', 'FunctionUrlConfig$CreationTime' => '<p>When the function URL was created, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>', 'FunctionUrlConfig$LastModifiedTime' => '<p>When the function URL configuration was last updated, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>', 'GetFunctionUrlConfigResponse$CreationTime' => '<p>When the function URL was created, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>', 'GetFunctionUrlConfigResponse$LastModifiedTime' => '<p>When the function URL configuration was last updated, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>', 'GetLayerVersionResponse$CreatedDate' => '<p>The date that the layer version was created, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>', 'GetProvisionedConcurrencyConfigResponse$LastModified' => '<p>The date and time that a user last updated the configuration, in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601 format</a>.</p>', 'LayerVersionsListItem$CreatedDate' => '<p>The date that the version was created, in ISO 8601 format. For example, <code>2018-11-27T15:10:45.123+0000</code>.</p>', 'ProvisionedConcurrencyConfigListItem$LastModified' => '<p>The date and time that a user last updated the configuration, in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601 format</a>.</p>', 'PublishLayerVersionResponse$CreatedDate' => '<p>The date that the layer version was created, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>', 'PutProvisionedConcurrencyConfigResponse$LastModified' => '<p>The date and time that a user last updated the configuration, in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601 format</a>.</p>', 'UpdateFunctionUrlConfigResponse$CreationTime' => '<p>When the function URL was created, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>', 'UpdateFunctionUrlConfigResponse$LastModifiedTime' => '<p>When the function URL configuration was last updated, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>', ], ], 'TooManyRequestsException' => [ 'base' => '<p>The request throughput limit was exceeded. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda quotas</a>.</p>', 'refs' => [], ], 'Topic' => [ 'base' => NULL, 'refs' => [ 'Topics$member' => NULL, ], ], 'Topics' => [ 'base' => NULL, 'refs' => [ 'CreateEventSourceMappingRequest$Topics' => '<p>The name of the Kafka topic.</p>', 'EventSourceMappingConfiguration$Topics' => '<p>The name of the Kafka topic.</p>', ], ], 'TracingConfig' => [ 'base' => '<p>The function\'s <a href="https://docs.aws.amazon.com/lambda/latest/dg/services-xray.html">X-Ray</a> tracing configuration. To sample and record incoming requests, set <code>Mode</code> to <code>Active</code>.</p>', 'refs' => [ 'CreateFunctionRequest$TracingConfig' => '<p>Set <code>Mode</code> to <code>Active</code> to sample and trace a subset of incoming requests with <a href="https://docs.aws.amazon.com/lambda/latest/dg/services-xray.html">X-Ray</a>.</p>', 'UpdateFunctionConfigurationRequest$TracingConfig' => '<p>Set <code>Mode</code> to <code>Active</code> to sample and trace a subset of incoming requests with <a href="https://docs.aws.amazon.com/lambda/latest/dg/services-xray.html">X-Ray</a>.</p>', ], ], 'TracingConfigResponse' => [ 'base' => '<p>The function\'s X-Ray tracing configuration.</p>', 'refs' => [ 'FunctionConfiguration$TracingConfig' => '<p>The function\'s X-Ray tracing configuration.</p>', ], ], 'TracingMode' => [ 'base' => NULL, 'refs' => [ 'TracingConfig$Mode' => '<p>The tracing mode.</p>', 'TracingConfigResponse$Mode' => '<p>The tracing mode.</p>', ], ], 'TumblingWindowInSeconds' => [ 'base' => NULL, 'refs' => [ 'CreateEventSourceMappingRequest$TumblingWindowInSeconds' => '<p>(Kinesis and DynamoDB Streams only) The duration in seconds of a processing window for DynamoDB and Kinesis Streams event sources. A value of 0 seconds indicates no tumbling window.</p>', 'EventSourceMappingConfiguration$TumblingWindowInSeconds' => '<p>(Kinesis and DynamoDB Streams only) The duration in seconds of a processing window for DynamoDB and Kinesis Streams event sources. A value of 0 seconds indicates no tumbling window.</p>', 'UpdateEventSourceMappingRequest$TumblingWindowInSeconds' => '<p>(Kinesis and DynamoDB Streams only) The duration in seconds of a processing window for DynamoDB and Kinesis Streams event sources. A value of 0 seconds indicates no tumbling window.</p>', ], ], 'URI' => [ 'base' => NULL, 'refs' => [ 'AmazonManagedKafkaEventSourceConfig$ConsumerGroupId' => '<p>The identifier for the Kafka consumer group to join. The consumer group ID must be unique among all your Kafka event sources. After creating a Kafka event source mapping with the consumer group ID specified, you cannot update this value. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html#services-msk-consumer-group-id">Customizable consumer group ID</a>.</p>', 'SelfManagedKafkaEventSourceConfig$ConsumerGroupId' => '<p>The identifier for the Kafka consumer group to join. The consumer group ID must be unique among all your Kafka event sources. After creating a Kafka event source mapping with the consumer group ID specified, you cannot update this value. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html#services-msk-consumer-group-id">Customizable consumer group ID</a>.</p>', 'SourceAccessConfiguration$URI' => '<p>The value for your chosen configuration in <code>Type</code>. For example: <code>"URI": "arn:aws:secretsmanager:us-east-1:01234567890:secret:MyBrokerSecretName"</code>.</p>', ], ], 'UnreservedConcurrentExecutions' => [ 'base' => NULL, 'refs' => [ 'AccountLimit$UnreservedConcurrentExecutions' => '<p>The maximum number of simultaneous function executions, minus the capacity that\'s reserved for individual functions with <a>PutFunctionConcurrency</a>.</p>', ], ], 'UnsupportedMediaTypeException' => [ 'base' => '<p>The content type of the <code>Invoke</code> request body is not JSON.</p>', 'refs' => [], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCodeSigningConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCodeSigningConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEventSourceMappingRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFunctionCodeRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFunctionConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFunctionEventInvokeConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFunctionUrlConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFunctionUrlConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRuntimeOn' => [ 'base' => NULL, 'refs' => [ 'GetRuntimeManagementConfigResponse$UpdateRuntimeOn' => '<p>The current runtime update mode of the function.</p>', 'PutRuntimeManagementConfigRequest$UpdateRuntimeOn' => '<p>Specify the runtime update mode.</p> <ul> <li> <p> <b>Auto (default)</b> - Automatically update to the most recent and secure runtime version using a <a href="https://docs.aws.amazon.com/lambda/latest/dg/runtimes-update.html#runtime-management-two-phase">Two-phase runtime version rollout</a>. This is the best choice for most customers to ensure they always benefit from runtime updates.</p> </li> <li> <p> <b>Function update</b> - Lambda updates the runtime of your function to the most recent and secure runtime version when you update your function. This approach synchronizes runtime updates with function deployments, giving you control over when runtime updates are applied and allowing you to detect and mitigate rare runtime update incompatibilities early. When using this setting, you need to regularly update your functions to keep their runtime up-to-date.</p> </li> <li> <p> <b>Manual</b> - You specify a runtime version in your function configuration. The function will use this runtime version indefinitely. In the rare case where a new runtime version is incompatible with an existing function, this allows you to roll back your function to an earlier runtime version. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/runtimes-update.html#runtime-management-rollback">Roll back a runtime version</a>.</p> </li> </ul>', 'PutRuntimeManagementConfigResponse$UpdateRuntimeOn' => '<p>The runtime update mode.</p>', ], ], 'Version' => [ 'base' => NULL, 'refs' => [ 'AliasConfiguration$FunctionVersion' => '<p>The function version that the alias invokes.</p>', 'CreateAliasRequest$FunctionVersion' => '<p>The function version that the alias invokes.</p>', 'FunctionConfiguration$Version' => '<p>The version of the Lambda function.</p>', 'InvocationResponse$ExecutedVersion' => '<p>The version of the function that executed. When you invoke a function with an alias, this indicates which version the alias resolved to.</p>', 'InvokeWithResponseStreamResponse$ExecutedVersion' => '<p>The version of the function that executed. When you invoke a function with an alias, this indicates which version the alias resolved to.</p>', 'ListAliasesRequest$FunctionVersion' => '<p>Specify a function version to only list aliases that invoke that version.</p>', 'UpdateAliasRequest$FunctionVersion' => '<p>The function version that the alias invokes.</p>', ], ], 'VpcConfig' => [ 'base' => '<p>The VPC security groups and subnets that are attached to a Lambda function. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-vpc.html">Configuring a Lambda function to access resources in a VPC</a>.</p>', 'refs' => [ 'CreateFunctionRequest$VpcConfig' => '<p>For network connectivity to Amazon Web Services resources in a VPC, specify a list of security groups and subnets in the VPC. When you connect a function to a VPC, it can access resources and the internet only through that VPC. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-vpc.html">Configuring a Lambda function to access resources in a VPC</a>.</p>', 'UpdateFunctionConfigurationRequest$VpcConfig' => '<p>For network connectivity to Amazon Web Services resources in a VPC, specify a list of security groups and subnets in the VPC. When you connect a function to a VPC, it can access resources and the internet only through that VPC. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-vpc.html">Configuring a Lambda function to access resources in a VPC</a>.</p>', ], ], 'VpcConfigResponse' => [ 'base' => '<p>The VPC security groups and subnets that are attached to a Lambda function.</p>', 'refs' => [ 'FunctionConfiguration$VpcConfig' => '<p>The function\'s networking configuration.</p>', ], ], 'VpcId' => [ 'base' => NULL, 'refs' => [ 'VpcConfigResponse$VpcId' => '<p>The ID of the VPC.</p>', ], ], 'Weight' => [ 'base' => NULL, 'refs' => [ 'AdditionalVersionWeights$value' => NULL, ], ], 'WorkingDirectory' => [ 'base' => NULL, 'refs' => [ 'ImageConfig$WorkingDirectory' => '<p>Specifies the working directory.</p>', ], ], ],];
