<?php
// This file was auto-generated from sdk-root/src/data/mailmanager/2023-10-17/docs-2.json
return [ 'version' => '2.0', 'service' => '<p><fullname>AWS SES Mail Manager API</fullname> <p> <a href="http://aws.amazon.com/ses">AWS SES Mail Manager API</a> contains operations and data types that comprise the Mail Manager feature of Amazon Simple Email Service.</p> <p>Mail Manager is a set of Amazon SES email gateway features designed to help you strengthen your organization\'s email infrastructure, simplify email workflow management, and streamline email compliance control. To learn more, see the <a href="https://docs.aws.amazon.com/ses/latest/dg/eb.html">Mail Manager chapter</a> in the Amazon SES Developer Guide.</p></p>', 'operations' => [ 'CreateAddonInstance' => '<p>Creates an Add On instance for the subscription indicated in the request. The resulting Amazon Resource Name (ARN) can be used in a conditional statement for a rule set or traffic policy. </p>', 'CreateAddonSubscription' => '<p>Creates a subscription for an Add On representing the acceptance of its terms of use and additional pricing. The subscription can then be used to create an instance for use in rule sets or traffic policies.</p>', 'CreateArchive' => '<p>Creates a new email archive resource for storing and retaining emails.</p>', 'CreateIngressPoint' => '<p>Provision a new ingress endpoint resource.</p>', 'CreateRelay' => '<p>Creates a relay resource which can be used in rules to relay incoming emails to defined relay destinations. </p>', 'CreateRuleSet' => '<p>Provision a new rule set.</p>', 'CreateTrafficPolicy' => '<p>Provision a new traffic policy resource.</p>', 'DeleteAddonInstance' => '<p>Deletes an Add On instance.</p>', 'DeleteAddonSubscription' => '<p>Deletes an Add On subscription.</p>', 'DeleteArchive' => '<p>Initiates deletion of an email archive. This changes the archive state to pending deletion. In this state, no new emails can be added, and existing archived emails become inaccessible (search, export, download). The archive and all of its contents will be permanently deleted 30 days after entering the pending deletion state, regardless of the configured retention period. </p>', 'DeleteIngressPoint' => '<p>Delete an ingress endpoint resource.</p>', 'DeleteRelay' => '<p>Deletes an existing relay resource.</p>', 'DeleteRuleSet' => '<p>Delete a rule set.</p>', 'DeleteTrafficPolicy' => '<p>Delete a traffic policy resource.</p>', 'GetAddonInstance' => '<p>Gets detailed information about an Add On instance.</p>', 'GetAddonSubscription' => '<p>Gets detailed information about an Add On subscription.</p>', 'GetArchive' => '<p>Retrieves the full details and current state of a specified email archive.</p>', 'GetArchiveExport' => '<p>Retrieves the details and current status of a specific email archive export job.</p>', 'GetArchiveMessage' => '<p>Returns a pre-signed URL that provides temporary download access to the specific email message stored in the archive. </p>', 'GetArchiveMessageContent' => '<p>Returns the textual content of a specific email message stored in the archive. Attachments are not included. </p>', 'GetArchiveSearch' => '<p>Retrieves the details and current status of a specific email archive search job.</p>', 'GetArchiveSearchResults' => '<p>Returns the results of a completed email archive search job.</p>', 'GetIngressPoint' => '<p>Fetch ingress endpoint resource attributes.</p>', 'GetRelay' => '<p>Fetch the relay resource and it\'s attributes.</p>', 'GetRuleSet' => '<p>Fetch attributes of a rule set.</p>', 'GetTrafficPolicy' => '<p>Fetch attributes of a traffic policy resource.</p>', 'ListAddonInstances' => '<p>Lists all Add On instances in your account.</p>', 'ListAddonSubscriptions' => '<p>Lists all Add On subscriptions in your account.</p>', 'ListArchiveExports' => '<p>Returns a list of email archive export jobs.</p>', 'ListArchiveSearches' => '<p>Returns a list of email archive search jobs.</p>', 'ListArchives' => '<p>Returns a list of all email archives in your account.</p>', 'ListIngressPoints' => '<p>List all ingress endpoint resources.</p>', 'ListRelays' => '<p>Lists all the existing relay resources.</p>', 'ListRuleSets' => '<p>List rule sets for this account.</p>', 'ListTagsForResource' => '<p> Retrieves the list of tags (keys and values) assigned to the resource. </p>', 'ListTrafficPolicies' => '<p>List traffic policy resources.</p>', 'StartArchiveExport' => '<p>Initiates an export of emails from the specified archive.</p>', 'StartArchiveSearch' => '<p>Initiates a search across emails in the specified archive.</p>', 'StopArchiveExport' => '<p>Stops an in-progress export of emails from an archive.</p>', 'StopArchiveSearch' => '<p>Stops an in-progress archive search job.</p>', 'TagResource' => '<p> Adds one or more tags (keys and values) to a specified resource. </p>', 'UntagResource' => '<p> Remove one or more tags (keys and values) from a specified resource. </p>', 'UpdateArchive' => '<p>Updates the attributes of an existing email archive.</p>', 'UpdateIngressPoint' => '<p>Update attributes of a provisioned ingress endpoint resource.</p>', 'UpdateRelay' => '<p>Updates the attributes of an existing relay resource.</p>', 'UpdateRuleSet' => '<p>&gt;Update attributes of an already provisioned rule set.</p>', 'UpdateTrafficPolicy' => '<p>Update attributes of an already provisioned traffic policy resource.</p>', ], 'shapes' => [ 'AcceptAction' => [ 'base' => NULL, 'refs' => [ 'CreateTrafficPolicyRequest$DefaultAction' => '<p>Default action instructs the traﬃc policy to either Allow or Deny (block) messages that fall outside of (or not addressed by) the conditions of your policy statements</p>', 'GetTrafficPolicyResponse$DefaultAction' => '<p>The default action of the traffic policy.</p>', 'PolicyStatement$Action' => '<p>The action that informs a traffic policy resource to either allow or block the email if it matches a condition in the policy statement.</p>', 'TrafficPolicy$DefaultAction' => '<p>Default action instructs the traﬃc policy to either Allow or Deny (block) messages that fall outside of (or not addressed by) the conditions of your policy statements</p>', 'UpdateTrafficPolicyRequest$DefaultAction' => '<p>Default action instructs the traﬃc policy to either Allow or Deny (block) messages that fall outside of (or not addressed by) the conditions of your policy statements</p>', ], ], 'AccessDeniedException' => [ 'base' => '<p>Occurs when a user is denied access to a specific resource or action.</p>', 'refs' => [], ], 'ActionFailurePolicy' => [ 'base' => NULL, 'refs' => [ 'ArchiveAction$ActionFailurePolicy' => '<p>A policy that states what to do in the case of failure. The action will fail if there are configuration errors. For example, the specified archive has been deleted.</p>', 'DeliverToMailboxAction$ActionFailurePolicy' => '<p>A policy that states what to do in the case of failure. The action will fail if there are configuration errors. For example, the mailbox ARN is no longer valid.</p>', 'RelayAction$ActionFailurePolicy' => '<p>A policy that states what to do in the case of failure. The action will fail if there are configuration errors. For example, the specified relay has been deleted.</p>', 'S3Action$ActionFailurePolicy' => '<p>A policy that states what to do in the case of failure. The action will fail if there are configuration errors. For example, the specified the bucket has been deleted.</p>', 'SendAction$ActionFailurePolicy' => '<p>A policy that states what to do in the case of failure. The action will fail if there are configuration errors. For example, the caller does not have the permissions to call the sendRawEmail API.</p>', ], ], 'AddHeaderAction' => [ 'base' => '<p>The action to add a header to a message. When executed, this action will add the given header to the message.</p>', 'refs' => [ 'RuleAction$AddHeader' => '<p>This action adds a header. This can be used to add arbitrary email headers.</p>', ], ], 'AddonInstance' => [ 'base' => '<p>An Add On instance represents a specific configuration of an Add On.</p>', 'refs' => [ 'AddonInstances$member' => NULL, ], ], 'AddonInstanceArn' => [ 'base' => NULL, 'refs' => [ 'AddonInstance$AddonInstanceArn' => '<p>The Amazon Resource Name (ARN) of the Add On instance.</p>', 'GetAddonInstanceResponse$AddonInstanceArn' => '<p>The Amazon Resource Name (ARN) of the Add On instance.</p>', ], ], 'AddonInstanceId' => [ 'base' => NULL, 'refs' => [ 'AddonInstance$AddonInstanceId' => '<p>The unique ID of the Add On instance.</p>', 'CreateAddonInstanceResponse$AddonInstanceId' => '<p>The unique ID of the Add On instance created by this API.</p>', 'DeleteAddonInstanceRequest$AddonInstanceId' => '<p>The Add On instance ID to delete.</p>', 'GetAddonInstanceRequest$AddonInstanceId' => '<p>The Add On instance ID to retrieve information for.</p>', ], ], 'AddonInstances' => [ 'base' => NULL, 'refs' => [ 'ListAddonInstancesResponse$AddonInstances' => '<p>The list of ingress endpoints.</p>', ], ], 'AddonName' => [ 'base' => NULL, 'refs' => [ 'AddonInstance$AddonName' => '<p>The name of the Add On for the instance.</p>', 'AddonSubscription$AddonName' => '<p>The name of the Add On.</p>', 'CreateAddonSubscriptionRequest$AddonName' => '<p>The name of the Add On to subscribe to. You can only have one subscription for each Add On name.</p>', 'GetAddonInstanceResponse$AddonName' => '<p>The name of the Add On provider associated to the subscription of the instance.</p>', 'GetAddonSubscriptionResponse$AddonName' => '<p>The name of the Add On for the subscription.</p>', ], ], 'AddonSubscription' => [ 'base' => '<p>A subscription for an Add On representing the acceptance of its terms of use and additional pricing.</p>', 'refs' => [ 'AddonSubscriptions$member' => NULL, ], ], 'AddonSubscriptionArn' => [ 'base' => NULL, 'refs' => [ 'AddonSubscription$AddonSubscriptionArn' => '<p>The Amazon Resource Name (ARN) of the Add On subscription.</p>', 'GetAddonSubscriptionResponse$AddonSubscriptionArn' => '<p>Amazon Resource Name (ARN) for the subscription.</p>', ], ], 'AddonSubscriptionId' => [ 'base' => NULL, 'refs' => [ 'AddonInstance$AddonSubscriptionId' => '<p>The subscription ID for the instance.</p>', 'AddonSubscription$AddonSubscriptionId' => '<p>The unique ID of the Add On subscription.</p>', 'CreateAddonInstanceRequest$AddonSubscriptionId' => '<p>The unique ID of a previously created subscription that an Add On instance is created for. You can only have one instance per subscription.</p>', 'CreateAddonSubscriptionResponse$AddonSubscriptionId' => '<p>The unique ID of the Add On subscription created by this API.</p>', 'DeleteAddonSubscriptionRequest$AddonSubscriptionId' => '<p>The Add On subscription ID to delete.</p>', 'GetAddonInstanceResponse$AddonSubscriptionId' => '<p>The subscription ID associated to the instance.</p>', 'GetAddonSubscriptionRequest$AddonSubscriptionId' => '<p>The Add On subscription ID to retrieve information for.</p>', ], ], 'AddonSubscriptions' => [ 'base' => NULL, 'refs' => [ 'ListAddonSubscriptionsResponse$AddonSubscriptions' => '<p>The list of ingress endpoints.</p>', ], ], 'Analysis' => [ 'base' => '<p>The result of an analysis can be used in conditions to trigger actions. Analyses can inspect the email content and report a certain aspect of the email.</p>', 'refs' => [ 'RuleVerdictToEvaluate$Analysis' => '<p>The Add On ARN and its returned value to evaluate in a verdict condition expression.</p>', ], ], 'AnalyzerArn' => [ 'base' => NULL, 'refs' => [ 'Analysis$Analyzer' => '<p>The Amazon Resource Name (ARN) of an Add On.</p>', 'IngressAnalysis$Analyzer' => '<p>The Amazon Resource Name (ARN) of an Add On.</p>', ], ], 'Archive' => [ 'base' => '<p>An archive resource for storing and retaining emails.</p>', 'refs' => [ 'ArchivesList$member' => NULL, ], ], 'ArchiveAction' => [ 'base' => '<p>The action to archive the email by delivering the email to an Amazon SES archive.</p>', 'refs' => [ 'RuleAction$Archive' => '<p>This action archives the email. This can be used to deliver an email to an archive.</p>', ], ], 'ArchiveArn' => [ 'base' => NULL, 'refs' => [ 'GetArchiveResponse$ArchiveArn' => '<p>The Amazon Resource Name (ARN) of the archive.</p>', ], ], 'ArchiveBooleanEmailAttribute' => [ 'base' => NULL, 'refs' => [ 'ArchiveBooleanToEvaluate$Attribute' => '<p>The name of the email attribute to evaluate.</p>', ], ], 'ArchiveBooleanExpression' => [ 'base' => '<p>A boolean expression to evaluate email attribute values.</p>', 'refs' => [ 'ArchiveFilterCondition$BooleanExpression' => '<p>A boolean expression to evaluate against email attributes.</p>', ], ], 'ArchiveBooleanOperator' => [ 'base' => NULL, 'refs' => [ 'ArchiveBooleanExpression$Operator' => '<p>The boolean operator to use for evaluation.</p>', ], ], 'ArchiveBooleanToEvaluate' => [ 'base' => '<p>The attribute to evaluate in a boolean expression.</p>', 'refs' => [ 'ArchiveBooleanExpression$Evaluate' => '<p>The email attribute value to evaluate.</p>', ], ], 'ArchiveFilterCondition' => [ 'base' => '<p>A filter condition used to include or exclude emails when exporting from or searching an archive.</p>', 'refs' => [ 'ArchiveFilterConditions$member' => NULL, ], ], 'ArchiveFilterConditions' => [ 'base' => NULL, 'refs' => [ 'ArchiveFilters$Include' => '<p>The filter conditions for emails to include.</p>', 'ArchiveFilters$Unless' => '<p>The filter conditions for emails to exclude.</p>', ], ], 'ArchiveFilters' => [ 'base' => '<p>A set of filter conditions to include and/or exclude emails.</p>', 'refs' => [ 'GetArchiveExportResponse$Filters' => '<p>The criteria used to filter emails included in the export.</p>', 'GetArchiveSearchResponse$Filters' => '<p>The criteria used to filter emails included in the search.</p>', 'StartArchiveExportRequest$Filters' => '<p>Criteria to filter which emails are included in the export.</p>', 'StartArchiveSearchRequest$Filters' => '<p>Criteria to filter which emails are included in the search results.</p>', ], ], 'ArchiveId' => [ 'base' => NULL, 'refs' => [ 'GetArchiveExportResponse$ArchiveId' => '<p>The identifier of the archive the email export was performed from.</p>', 'GetArchiveSearchResponse$ArchiveId' => '<p>The identifier of the archive the email search was performed in.</p>', 'ListArchiveExportsRequest$ArchiveId' => '<p>The identifier of the archive.</p>', 'ListArchiveSearchesRequest$ArchiveId' => '<p>The identifier of the archive.</p>', 'StartArchiveExportRequest$ArchiveId' => '<p>The identifier of the archive to export emails from.</p>', 'StartArchiveSearchRequest$ArchiveId' => '<p>The identifier of the archive to search emails in.</p>', ], ], 'ArchiveIdString' => [ 'base' => NULL, 'refs' => [ 'Archive$ArchiveId' => '<p>The unique identifier of the archive.</p>', 'CreateArchiveResponse$ArchiveId' => '<p>The unique identifier for the newly created archive.</p>', 'DeleteArchiveRequest$ArchiveId' => '<p>The identifier of the archive to delete.</p>', 'GetArchiveRequest$ArchiveId' => '<p>The identifier of the archive to retrieve.</p>', 'GetArchiveResponse$ArchiveId' => '<p>The unique identifier of the archive.</p>', 'UpdateArchiveRequest$ArchiveId' => '<p>The identifier of the archive to update.</p>', ], ], 'ArchiveNameString' => [ 'base' => NULL, 'refs' => [ 'Archive$ArchiveName' => '<p>The unique name assigned to the archive.</p>', 'CreateArchiveRequest$ArchiveName' => '<p>A unique name for the new archive.</p>', 'GetArchiveResponse$ArchiveName' => '<p>The unique name assigned to the archive.</p>', 'UpdateArchiveRequest$ArchiveName' => '<p>A new, unique name for the archive.</p>', ], ], 'ArchiveRetention' => [ 'base' => '<p>The retention policy for an email archive that specifies how long emails are kept before being automatically deleted. </p>', 'refs' => [ 'CreateArchiveRequest$Retention' => '<p>The period for retaining emails in the archive before automatic deletion.</p>', 'GetArchiveResponse$Retention' => '<p>The retention period for emails in this archive.</p>', 'UpdateArchiveRequest$Retention' => '<p>A new retention period for emails in the archive.</p>', ], ], 'ArchiveState' => [ 'base' => NULL, 'refs' => [ 'Archive$ArchiveState' => '<p>The current state of the archive:</p> <ul> <li> <p> <code>ACTIVE</code> – The archive is ready and available for use. </p> </li> <li> <p> <code>PENDING_DELETION</code> – The archive has been marked for deletion and will be permanently deleted in 30 days. No further modifications can be made in this state. </p> </li> </ul>', 'GetArchiveResponse$ArchiveState' => '<p>The current state of the archive:</p> <ul> <li> <p> <code>ACTIVE</code> – The archive is ready and available for use. </p> </li> <li> <p> <code>PENDING_DELETION</code> – The archive has been marked for deletion and will be permanently deleted in 30 days. No further modifications can be made in this state. </p> </li> </ul>', ], ], 'ArchiveStringEmailAttribute' => [ 'base' => NULL, 'refs' => [ 'ArchiveStringToEvaluate$Attribute' => '<p>The name of the email attribute to evaluate.</p>', ], ], 'ArchiveStringExpression' => [ 'base' => '<p>A string expression to evaluate an email attribute value against one or more string values.</p>', 'refs' => [ 'ArchiveFilterCondition$StringExpression' => '<p>A string expression to evaluate against email attributes.</p>', ], ], 'ArchiveStringOperator' => [ 'base' => NULL, 'refs' => [ 'ArchiveStringExpression$Operator' => '<p>The operator to use when evaluating the string values.</p>', ], ], 'ArchiveStringToEvaluate' => [ 'base' => '<p>Specifies the email attribute to evaluate in a string expression.</p>', 'refs' => [ 'ArchiveStringExpression$Evaluate' => '<p>The attribute of the email to evaluate.</p>', ], ], 'ArchivedMessageId' => [ 'base' => NULL, 'refs' => [ 'GetArchiveMessageContentRequest$ArchivedMessageId' => '<p>The unique identifier of the archived email message.</p>', 'GetArchiveMessageRequest$ArchivedMessageId' => '<p>The unique identifier of the archived email message.</p>', 'Row$ArchivedMessageId' => '<p>The unique identifier of the archived message.</p>', ], ], 'ArchivesList' => [ 'base' => NULL, 'refs' => [ 'ListArchivesResponse$Archives' => '<p>The list of archive details.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'MessageBody$MessageMalformed' => '<p>A flag indicating if the email was malformed.</p>', 'Row$HasAttachments' => '<p>A flag indicating if the email has attachments.</p>', ], ], 'ConflictException' => [ 'base' => '<p>The request configuration has conflicts. For details, see the accompanying error message.</p>', 'refs' => [], ], 'CreateAddonInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAddonInstanceResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateAddonSubscriptionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAddonSubscriptionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateArchiveRequest' => [ 'base' => '<p>The request to create a new email archive.</p>', 'refs' => [], ], 'CreateArchiveResponse' => [ 'base' => '<p>The response from creating a new email archive.</p>', 'refs' => [], ], 'CreateIngressPointRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateIngressPointResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateRelayRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateRelayResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateRuleSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateRuleSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateTrafficPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTrafficPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAddonInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAddonInstanceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAddonSubscriptionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAddonSubscriptionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteArchiveRequest' => [ 'base' => '<p>The request to initiate deletion of an email archive.</p>', 'refs' => [], ], 'DeleteArchiveResponse' => [ 'base' => '<p>The response indicating if the archive deletion was successfully initiated.</p> <p>On success, returns an HTTP 200 status code. On failure, returns an error message.</p>', 'refs' => [], ], 'DeleteIngressPointRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteIngressPointResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRelayRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRelayResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRuleSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRuleSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTrafficPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTrafficPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeliverToMailboxAction' => [ 'base' => '<p>This action to delivers an email to a mailbox.</p>', 'refs' => [ 'RuleAction$DeliverToMailbox' => '<p>This action delivers an email to a WorkMail mailbox.</p>', ], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'RuleNumberExpression$Value' => '<p>The value to evaluate in a numeric condition expression.</p>', ], ], 'DropAction' => [ 'base' => '<p>This action causes processing to stop and the email to be dropped. If the action applies only to certain recipients, only those recipients are dropped, and processing continues for other recipients.</p>', 'refs' => [ 'RuleAction$Drop' => '<p>This action terminates the evaluation of rules in the rule set.</p>', ], ], 'EmailAddress' => [ 'base' => NULL, 'refs' => [ 'Recipients$member' => NULL, ], ], 'EmailReceivedHeadersList' => [ 'base' => NULL, 'refs' => [ 'Row$ReceivedHeaders' => '<p>The received headers from the email delivery path.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => NULL, 'ConflictException$Message' => NULL, 'ExportStatus$ErrorMessage' => '<p>An error message if the export job failed.</p>', 'ResourceNotFoundException$Message' => NULL, 'SearchStatus$ErrorMessage' => '<p>An error message if the search failed.</p>', 'ServiceQuotaExceededException$Message' => NULL, 'ThrottlingException$Message' => NULL, 'ValidationException$Message' => NULL, ], ], 'ExportDestinationConfiguration' => [ 'base' => '<p>The destination configuration for delivering exported email data.</p>', 'refs' => [ 'GetArchiveExportResponse$ExportDestinationConfiguration' => '<p>Where the exported emails are being delivered.</p>', 'StartArchiveExportRequest$ExportDestinationConfiguration' => '<p>Details on where to deliver the exported email data.</p>', ], ], 'ExportId' => [ 'base' => NULL, 'refs' => [ 'ExportSummary$ExportId' => '<p>The unique identifier of the export job.</p>', 'GetArchiveExportRequest$ExportId' => '<p>The identifier of the export job to get details for.</p>', 'StartArchiveExportResponse$ExportId' => '<p>The unique identifier for the initiated export job.</p>', 'StopArchiveExportRequest$ExportId' => '<p>The identifier of the export job to stop.</p>', ], ], 'ExportMaxResults' => [ 'base' => NULL, 'refs' => [ 'GetArchiveExportResponse$MaxResults' => '<p>The maximum number of email items included in the export.</p>', 'StartArchiveExportRequest$MaxResults' => '<p>The maximum number of email items to include in the export.</p>', ], ], 'ExportState' => [ 'base' => NULL, 'refs' => [ 'ExportStatus$State' => '<p>The current state of the export job.</p>', ], ], 'ExportStatus' => [ 'base' => '<p>The current status of an archive export job.</p>', 'refs' => [ 'ExportSummary$Status' => '<p>The current status of the export job.</p>', 'GetArchiveExportResponse$Status' => '<p>The current status of the export job.</p>', ], ], 'ExportSummary' => [ 'base' => '<p>Summary statuses of an archive export job.</p>', 'refs' => [ 'ExportSummaryList$member' => NULL, ], ], 'ExportSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListArchiveExportsResponse$Exports' => '<p>The list of export job identifiers and statuses.</p>', ], ], 'GetAddonInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAddonInstanceResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetAddonSubscriptionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAddonSubscriptionResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetArchiveExportRequest' => [ 'base' => '<p>The request to retrieve details of a specific archive export job.</p>', 'refs' => [], ], 'GetArchiveExportResponse' => [ 'base' => '<p>The response containing details of the specified archive export job.</p>', 'refs' => [], ], 'GetArchiveMessageContentRequest' => [ 'base' => '<p>The request to get the textual content of a specific email message stored in an archive.</p>', 'refs' => [], ], 'GetArchiveMessageContentResponse' => [ 'base' => '<p>The response containing the textual content of the requested archived email message.</p>', 'refs' => [], ], 'GetArchiveMessageRequest' => [ 'base' => '<p>The request to get details of a specific email message stored in an archive.</p>', 'refs' => [], ], 'GetArchiveMessageResponse' => [ 'base' => '<p>The response containing details about the requested archived email message.</p>', 'refs' => [], ], 'GetArchiveRequest' => [ 'base' => '<p>The request to retrieve details of an email archive.</p>', 'refs' => [], ], 'GetArchiveResponse' => [ 'base' => '<p>The response containing details of the requested archive.</p>', 'refs' => [], ], 'GetArchiveSearchRequest' => [ 'base' => '<p>The request to retrieve details of a specific archive search job.</p>', 'refs' => [], ], 'GetArchiveSearchResponse' => [ 'base' => '<p>The response containing details of the specified archive search job.</p>', 'refs' => [], ], 'GetArchiveSearchResultsRequest' => [ 'base' => '<p>The request to retrieve results from a completed archive search job.</p>', 'refs' => [], ], 'GetArchiveSearchResultsResponse' => [ 'base' => '<p>The response containing search results from a completed archive search.</p>', 'refs' => [], ], 'GetIngressPointRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetIngressPointResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetRelayRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRelayResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetRuleSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRuleSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetTrafficPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTrafficPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'HeaderName' => [ 'base' => NULL, 'refs' => [ 'AddHeaderAction$HeaderName' => '<p>The name of the header to add to an email. The header must be prefixed with "X-". Headers are added regardless of whether the header name pre-existed in the email.</p>', ], ], 'HeaderValue' => [ 'base' => NULL, 'refs' => [ 'AddHeaderAction$HeaderValue' => '<p>The value of the header to add to the email.</p>', ], ], 'IamRoleArn' => [ 'base' => NULL, 'refs' => [ 'DeliverToMailboxAction$RoleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role to use to execute this action. The role must have access to the workmail:DeliverToMailbox API.</p>', 'S3Action$RoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM Role to use while writing to S3. This role must have access to the s3:PutObject, kms:Encrypt, and kms:GenerateDataKey APIs for the given bucket.</p>', 'SendAction$RoleArn' => '<p>The Amazon Resource Name (ARN) of the role to use for this action. This role must have access to the ses:SendRawEmail API.</p>', ], ], 'IdOrArn' => [ 'base' => NULL, 'refs' => [ 'RelayAction$Relay' => '<p>The identifier of the relay resource to be used when relaying an email.</p>', ], ], 'IdempotencyToken' => [ 'base' => NULL, 'refs' => [ 'CreateAddonInstanceRequest$ClientToken' => '<p>A unique token that Amazon SES uses to recognize subsequent retries of the same request.</p>', 'CreateAddonSubscriptionRequest$ClientToken' => '<p>A unique token that Amazon SES uses to recognize subsequent retries of the same request.</p>', 'CreateArchiveRequest$ClientToken' => '<p>A unique token Amazon SES uses to recognize retries of this request.</p>', 'CreateIngressPointRequest$ClientToken' => '<p>A unique token that Amazon SES uses to recognize subsequent retries of the same request.</p>', 'CreateRelayRequest$ClientToken' => '<p>A unique token that Amazon SES uses to recognize subsequent retries of the same request.</p>', 'CreateRuleSetRequest$ClientToken' => '<p>A unique token that Amazon SES uses to recognize subsequent retries of the same request.</p>', 'CreateTrafficPolicyRequest$ClientToken' => '<p>A unique token that Amazon SES uses to recognize subsequent retries of the same request.</p>', ], ], 'IngressAnalysis' => [ 'base' => '<p>The Add On ARN and its returned value that is evaluated in a policy statement\'s conditional expression to either deny or block the incoming email.</p>', 'refs' => [ 'IngressBooleanToEvaluate$Analysis' => '<p>The structure type for a boolean condition stating the Add On ARN and its returned value.</p>', ], ], 'IngressBooleanExpression' => [ 'base' => '<p>The structure for a boolean condition matching on the incoming mail.</p>', 'refs' => [ 'PolicyCondition$BooleanExpression' => '<p>This represents a boolean type condition matching on the incoming mail. It performs the boolean operation configured in \'Operator\' and evaluates the \'Protocol\' object against the \'Value\'.</p>', ], ], 'IngressBooleanOperator' => [ 'base' => NULL, 'refs' => [ 'IngressBooleanExpression$Operator' => '<p>The matching operator for a boolean condition expression.</p>', ], ], 'IngressBooleanToEvaluate' => [ 'base' => '<p>The union type representing the allowed types of operands for a boolean condition.</p>', 'refs' => [ 'IngressBooleanExpression$Evaluate' => '<p>The operand on which to perform a boolean condition operation.</p>', ], ], 'IngressIpOperator' => [ 'base' => NULL, 'refs' => [ 'IngressIpv4Expression$Operator' => '<p>The matching operator for an IP condition expression.</p>', ], ], 'IngressIpToEvaluate' => [ 'base' => '<p>The structure for an IP based condition matching on the incoming mail.</p>', 'refs' => [ 'IngressIpv4Expression$Evaluate' => '<p>The left hand side argument of an IP condition expression.</p>', ], ], 'IngressIpv4Attribute' => [ 'base' => NULL, 'refs' => [ 'IngressIpToEvaluate$Attribute' => '<p>An enum type representing the allowed attribute types for an IP condition.</p>', ], ], 'IngressIpv4Expression' => [ 'base' => '<p>The union type representing the allowed types for the left hand side of an IP condition.</p>', 'refs' => [ 'PolicyCondition$IpExpression' => '<p>This represents an IP based condition matching on the incoming mail. It performs the operation configured in \'Operator\' and evaluates the \'Protocol\' object against the \'Value\'.</p>', ], ], 'IngressPoint' => [ 'base' => '<p>The structure of an ingress endpoint resource.</p>', 'refs' => [ 'IngressPointsList$member' => NULL, ], ], 'IngressPointARecord' => [ 'base' => NULL, 'refs' => [ 'GetIngressPointResponse$ARecord' => '<p> The DNS A Record that identifies your ingress endpoint. Configure your DNS Mail Exchange (MX) record with this value to route emails to Mail Manager. </p>', 'IngressPoint$ARecord' => '<p> The DNS A Record that identifies your ingress endpoint. Configure your DNS Mail Exchange (MX) record with this value to route emails to Mail Manager. </p>', ], ], 'IngressPointArn' => [ 'base' => NULL, 'refs' => [ 'GetIngressPointResponse$IngressPointArn' => '<p>The Amazon Resource Name (ARN) of the ingress endpoint resource.</p>', ], ], 'IngressPointAuthConfiguration' => [ 'base' => '<p>The authentication configuration for the ingress endpoint resource.</p>', 'refs' => [ 'GetIngressPointResponse$IngressPointAuthConfiguration' => '<p>The authentication configuration of the ingress endpoint resource.</p>', ], ], 'IngressPointConfiguration' => [ 'base' => '<p>The configuration of the ingress endpoint resource.</p>', 'refs' => [ 'CreateIngressPointRequest$IngressPointConfiguration' => '<p>If you choose an Authenticated ingress endpoint, you must configure either an SMTP password or a secret ARN.</p>', 'UpdateIngressPointRequest$IngressPointConfiguration' => '<p>If you choose an Authenticated ingress endpoint, you must configure either an SMTP password or a secret ARN.</p>', ], ], 'IngressPointId' => [ 'base' => NULL, 'refs' => [ 'CreateIngressPointResponse$IngressPointId' => '<p>The unique identifier for a previously created ingress endpoint.</p>', 'DeleteIngressPointRequest$IngressPointId' => '<p>The identifier of the ingress endpoint resource that you want to delete.</p>', 'GetIngressPointRequest$IngressPointId' => '<p>The identifier of an ingress endpoint.</p>', 'GetIngressPointResponse$IngressPointId' => '<p>The identifier of an ingress endpoint resource.</p>', 'IngressPoint$IngressPointId' => '<p>The identifier of the ingress endpoint resource.</p>', 'UpdateIngressPointRequest$IngressPointId' => '<p>The identifier for the ingress endpoint you want to update.</p>', ], ], 'IngressPointName' => [ 'base' => NULL, 'refs' => [ 'CreateIngressPointRequest$IngressPointName' => '<p>A user friendly name for an ingress endpoint resource.</p>', 'GetIngressPointResponse$IngressPointName' => '<p>A user friendly name for the ingress endpoint.</p>', 'IngressPoint$IngressPointName' => '<p>A user friendly name for the ingress endpoint resource.</p>', 'UpdateIngressPointRequest$IngressPointName' => '<p>A user friendly name for the ingress endpoint resource.</p>', ], ], 'IngressPointPasswordConfiguration' => [ 'base' => '<p>The password configuration of the ingress endpoint resource.</p>', 'refs' => [ 'IngressPointAuthConfiguration$IngressPointPasswordConfiguration' => '<p>The ingress endpoint password configuration for the ingress endpoint resource.</p>', ], ], 'IngressPointStatus' => [ 'base' => NULL, 'refs' => [ 'GetIngressPointResponse$Status' => '<p>The status of the ingress endpoint resource.</p>', 'IngressPoint$Status' => '<p>The status of the ingress endpoint resource.</p>', ], ], 'IngressPointStatusToUpdate' => [ 'base' => NULL, 'refs' => [ 'UpdateIngressPointRequest$StatusToUpdate' => '<p>The update status of an ingress endpoint.</p>', ], ], 'IngressPointType' => [ 'base' => NULL, 'refs' => [ 'CreateIngressPointRequest$Type' => '<p>The type of the ingress endpoint to create.</p>', 'GetIngressPointResponse$Type' => '<p>The type of ingress endpoint.</p>', 'IngressPoint$Type' => '<p>The type of ingress endpoint resource.</p>', ], ], 'IngressPointsList' => [ 'base' => NULL, 'refs' => [ 'ListIngressPointsResponse$IngressPoints' => '<p>The list of ingress endpoints.</p>', ], ], 'IngressStringEmailAttribute' => [ 'base' => NULL, 'refs' => [ 'IngressStringToEvaluate$Attribute' => '<p>The enum type representing the allowed attribute types for a string condition.</p>', ], ], 'IngressStringExpression' => [ 'base' => '<p>The structure for a string based condition matching on the incoming mail.</p>', 'refs' => [ 'PolicyCondition$StringExpression' => '<p>This represents a string based condition matching on the incoming mail. It performs the string operation configured in \'Operator\' and evaluates the \'Protocol\' object against the \'Value\'.</p>', ], ], 'IngressStringOperator' => [ 'base' => NULL, 'refs' => [ 'IngressStringExpression$Operator' => '<p>The matching operator for a string condition expression.</p>', ], ], 'IngressStringToEvaluate' => [ 'base' => '<p>The union type representing the allowed types for the left hand side of a string condition.</p>', 'refs' => [ 'IngressStringExpression$Evaluate' => '<p>The left hand side argument of a string condition expression.</p>', ], ], 'IngressTlsAttribute' => [ 'base' => NULL, 'refs' => [ 'IngressTlsProtocolToEvaluate$Attribute' => '<p>The enum type representing the allowed attribute types for the TLS condition.</p>', ], ], 'IngressTlsProtocolAttribute' => [ 'base' => NULL, 'refs' => [ 'IngressTlsProtocolExpression$Value' => '<p>The right hand side argument of a TLS condition expression.</p>', ], ], 'IngressTlsProtocolExpression' => [ 'base' => '<p>The structure for a TLS related condition matching on the incoming mail.</p>', 'refs' => [ 'PolicyCondition$TlsExpression' => '<p>This represents a TLS based condition matching on the incoming mail. It performs the operation configured in \'Operator\' and evaluates the \'Protocol\' object against the \'Value\'.</p>', ], ], 'IngressTlsProtocolOperator' => [ 'base' => NULL, 'refs' => [ 'IngressTlsProtocolExpression$Operator' => '<p>The matching operator for a TLS condition expression.</p>', ], ], 'IngressTlsProtocolToEvaluate' => [ 'base' => '<p>The union type representing the allowed types for the left hand side of a TLS condition.</p>', 'refs' => [ 'IngressTlsProtocolExpression$Evaluate' => '<p>The left hand side argument of a TLS condition expression.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'ListRelaysRequest$PageSize' => '<p>The number of relays to be returned in one request.</p>', ], ], 'Ipv4Cidr' => [ 'base' => NULL, 'refs' => [ 'Ipv4Cidrs$member' => NULL, ], ], 'Ipv4Cidrs' => [ 'base' => NULL, 'refs' => [ 'IngressIpv4Expression$Values' => '<p>The right hand side argument of an IP condition expression.</p>', ], ], 'KmsKeyArn' => [ 'base' => NULL, 'refs' => [ 'CreateArchiveRequest$KmsKeyArn' => '<p>The Amazon Resource Name (ARN) of the KMS key for encrypting emails in the archive.</p>', 'GetArchiveResponse$KmsKeyArn' => '<p>The Amazon Resource Name (ARN) of the KMS key used to encrypt the archive.</p>', ], ], 'KmsKeyId' => [ 'base' => NULL, 'refs' => [ 'S3Action$S3SseKmsKeyId' => '<p>The KMS Key ID to use to encrypt the message in S3.</p>', ], ], 'ListAddonInstancesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAddonInstancesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAddonSubscriptionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAddonSubscriptionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListArchiveExportsRequest' => [ 'base' => '<p>The request to list archive export jobs in your account.</p>', 'refs' => [], ], 'ListArchiveExportsResponse' => [ 'base' => '<p>The response containing a list of archive export jobs and their statuses.</p>', 'refs' => [], ], 'ListArchiveSearchesRequest' => [ 'base' => '<p>The request to list archive search jobs in your account.</p>', 'refs' => [], ], 'ListArchiveSearchesResponse' => [ 'base' => '<p>The response containing a list of archive search jobs and their statuses.</p>', 'refs' => [], ], 'ListArchivesRequest' => [ 'base' => '<p>The request to list email archives in your account.</p>', 'refs' => [], ], 'ListArchivesResponse' => [ 'base' => '<p>The response containing a list of your email archives.</p>', 'refs' => [], ], 'ListIngressPointsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListIngressPointsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListRelaysRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRelaysResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListRuleSetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRuleSetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTrafficPoliciesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTrafficPoliciesResponse' => [ 'base' => NULL, 'refs' => [], ], 'MailFrom' => [ 'base' => NULL, 'refs' => [ 'RelayAction$MailFrom' => '<p>This action specifies whether to preserve or replace original mail from address while relaying received emails to a destination server.</p>', ], ], 'MaxMessageSizeBytes' => [ 'base' => NULL, 'refs' => [ 'CreateTrafficPolicyRequest$MaxMessageSizeBytes' => '<p>The maximum message size in bytes of email which is allowed in by this traffic policy—anything larger will be blocked.</p>', 'GetTrafficPolicyResponse$MaxMessageSizeBytes' => '<p>The maximum message size in bytes of email which is allowed in by this traffic policy—anything larger will be blocked.</p>', 'UpdateTrafficPolicyRequest$MaxMessageSizeBytes' => '<p>The maximum message size in bytes of email which is allowed in by this traffic policy—anything larger will be blocked.</p>', ], ], 'MessageBody' => [ 'base' => '<p>The textual body content of an email message.</p>', 'refs' => [ 'GetArchiveMessageContentResponse$Body' => '<p>The textual body content of the email message.</p>', ], ], 'NameOrArn' => [ 'base' => NULL, 'refs' => [ 'ArchiveAction$TargetArchive' => '<p>The identifier of the archive to send the email to.</p>', 'DeliverToMailboxAction$MailboxArn' => '<p>The Amazon Resource Name (ARN) of a WorkMail organization to deliver the email to.</p>', ], ], 'NoAuthentication' => [ 'base' => '<p>Explicitly indicate that the relay destination server does not require SMTP credential authentication.</p>', 'refs' => [ 'RelayAuthentication$NoAuthentication' => '<p>Keep an empty structure if the relay destination server does not require SMTP credential authentication.</p>', ], ], 'PageSize' => [ 'base' => NULL, 'refs' => [ 'ListAddonInstancesRequest$PageSize' => '<p>The maximum number of ingress endpoint resources that are returned per call. You can use NextToken to obtain further ingress endpoints. </p>', 'ListAddonSubscriptionsRequest$PageSize' => '<p>The maximum number of ingress endpoint resources that are returned per call. You can use NextToken to obtain further ingress endpoints. </p>', 'ListArchiveExportsRequest$PageSize' => '<p>The maximum number of archive export jobs that are returned per call. You can use NextToken to obtain further pages of archives. </p>', 'ListArchiveSearchesRequest$PageSize' => '<p>The maximum number of archive search jobs that are returned per call. You can use NextToken to obtain further pages of archives. </p>', 'ListArchivesRequest$PageSize' => '<p>The maximum number of archives that are returned per call. You can use NextToken to obtain further pages of archives. </p>', 'ListIngressPointsRequest$PageSize' => '<p>The maximum number of ingress endpoint resources that are returned per call. You can use NextToken to obtain further ingress endpoints.</p>', 'ListRuleSetsRequest$PageSize' => '<p>The maximum number of rule set resources that are returned per call. You can use NextToken to obtain further rule sets.</p>', 'ListTrafficPoliciesRequest$PageSize' => '<p>The maximum number of traffic policy resources that are returned per call. You can use NextToken to obtain further traffic policies.</p>', ], ], 'PaginationToken' => [ 'base' => NULL, 'refs' => [ 'ListAddonInstancesRequest$NextToken' => '<p>If you received a pagination token from a previous call to this API, you can provide it here to continue paginating through the next page of results.</p>', 'ListAddonInstancesResponse$NextToken' => '<p>If NextToken is returned, there are more results available. The value of NextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page.</p>', 'ListAddonSubscriptionsRequest$NextToken' => '<p>If you received a pagination token from a previous call to this API, you can provide it here to continue paginating through the next page of results.</p>', 'ListAddonSubscriptionsResponse$NextToken' => '<p>If NextToken is returned, there are more results available. The value of NextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page.</p>', 'ListArchiveExportsRequest$NextToken' => '<p>If NextToken is returned, there are more results available. The value of NextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. </p>', 'ListArchiveExportsResponse$NextToken' => '<p>If present, use to retrieve the next page of results.</p>', 'ListArchiveSearchesRequest$NextToken' => '<p>If NextToken is returned, there are more results available. The value of NextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. </p>', 'ListArchiveSearchesResponse$NextToken' => '<p>If present, use to retrieve the next page of results.</p>', 'ListArchivesRequest$NextToken' => '<p>If NextToken is returned, there are more results available. The value of NextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. </p>', 'ListArchivesResponse$NextToken' => '<p>If present, use to retrieve the next page of results.</p>', 'ListIngressPointsRequest$NextToken' => '<p>If you received a pagination token from a previous call to this API, you can provide it here to continue paginating through the next page of results.</p>', 'ListIngressPointsResponse$NextToken' => '<p>If NextToken is returned, there are more results available. The value of NextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page.</p>', 'ListRelaysRequest$NextToken' => '<p>If you received a pagination token from a previous call to this API, you can provide it here to continue paginating through the next page of results.</p>', 'ListRelaysResponse$NextToken' => '<p>If NextToken is returned, there are more results available. The value of NextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page.</p>', 'ListRuleSetsRequest$NextToken' => '<p>If you received a pagination token from a previous call to this API, you can provide it here to continue paginating through the next page of results.</p>', 'ListRuleSetsResponse$NextToken' => '<p>If NextToken is returned, there are more results available. The value of NextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page.</p>', 'ListTrafficPoliciesRequest$NextToken' => '<p>If you received a pagination token from a previous call to this API, you can provide it here to continue paginating through the next page of results.</p>', 'ListTrafficPoliciesResponse$NextToken' => '<p>If NextToken is returned, there are more results available. The value of NextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page.</p>', ], ], 'PolicyCondition' => [ 'base' => '<p>The email traffic filtering conditions which are contained in a traffic policy resource.</p>', 'refs' => [ 'PolicyConditions$member' => NULL, ], ], 'PolicyConditions' => [ 'base' => NULL, 'refs' => [ 'PolicyStatement$Conditions' => '<p>The list of conditions to apply to incoming messages for filtering email traffic.</p>', ], ], 'PolicyStatement' => [ 'base' => '<p>The structure containing traffic policy conditions and actions.</p>', 'refs' => [ 'PolicyStatementList$member' => NULL, ], ], 'PolicyStatementList' => [ 'base' => NULL, 'refs' => [ 'CreateTrafficPolicyRequest$PolicyStatements' => '<p>Conditional statements for filtering email traffic.</p>', 'GetTrafficPolicyResponse$PolicyStatements' => '<p>The list of conditions which are in the traffic policy resource.</p>', 'UpdateTrafficPolicyRequest$PolicyStatements' => '<p>The list of conditions to be updated for filtering email traffic.</p>', ], ], 'Recipients' => [ 'base' => NULL, 'refs' => [ 'ReplaceRecipientAction$ReplaceWith' => '<p>This action specifies the replacement recipient email addresses to insert.</p>', ], ], 'Relay' => [ 'base' => '<p>The relay resource that can be used as a rule to relay receiving emails to the destination relay server.</p>', 'refs' => [ 'Relays$member' => NULL, ], ], 'RelayAction' => [ 'base' => '<p>The action relays the email via SMTP to another specific SMTP server.</p>', 'refs' => [ 'RuleAction$Relay' => '<p>This action relays the email to another SMTP server.</p>', ], ], 'RelayArn' => [ 'base' => NULL, 'refs' => [ 'GetRelayResponse$RelayArn' => '<p>The Amazon Resource Name (ARN) of the relay.</p>', ], ], 'RelayAuthentication' => [ 'base' => '<p>Authentication for the relay destination server—specify the secretARN where the SMTP credentials are stored, or specify an empty NoAuthentication structure if the relay destination server does not require SMTP credential authentication.</p>', 'refs' => [ 'CreateRelayRequest$Authentication' => '<p>Authentication for the relay destination server—specify the secretARN where the SMTP credentials are stored.</p>', 'GetRelayResponse$Authentication' => '<p>The authentication attribute—contains the secret ARN where the customer relay server credentials are stored. </p>', 'UpdateRelayRequest$Authentication' => '<p>Authentication for the relay destination server—specify the secretARN where the SMTP credentials are stored.</p>', ], ], 'RelayId' => [ 'base' => NULL, 'refs' => [ 'CreateRelayResponse$RelayId' => '<p>A unique identifier of the created relay resource.</p>', 'DeleteRelayRequest$RelayId' => '<p>The unique relay identifier.</p>', 'GetRelayRequest$RelayId' => '<p>A unique relay identifier.</p>', 'GetRelayResponse$RelayId' => '<p>The unique relay identifier.</p>', 'Relay$RelayId' => '<p>The unique relay identifier.</p>', 'UpdateRelayRequest$RelayId' => '<p>The unique relay identifier.</p>', ], ], 'RelayName' => [ 'base' => NULL, 'refs' => [ 'CreateRelayRequest$RelayName' => '<p>The unique name of the relay resource.</p>', 'GetRelayResponse$RelayName' => '<p>The unique name of the relay.</p>', 'Relay$RelayName' => '<p>The unique relay name.</p>', 'UpdateRelayRequest$RelayName' => '<p>The name of the relay resource.</p>', ], ], 'RelayServerName' => [ 'base' => NULL, 'refs' => [ 'CreateRelayRequest$ServerName' => '<p>The destination relay server address.</p>', 'GetRelayResponse$ServerName' => '<p>The destination relay server address.</p>', 'UpdateRelayRequest$ServerName' => '<p>The destination relay server address.</p>', ], ], 'RelayServerPort' => [ 'base' => NULL, 'refs' => [ 'CreateRelayRequest$ServerPort' => '<p>The destination relay server port.</p>', 'GetRelayResponse$ServerPort' => '<p>The destination relay server port.</p>', 'UpdateRelayRequest$ServerPort' => '<p>The destination relay server port.</p>', ], ], 'Relays' => [ 'base' => NULL, 'refs' => [ 'ListRelaysResponse$Relays' => '<p>The list of returned relays.</p>', ], ], 'ReplaceRecipientAction' => [ 'base' => '<p>This action replaces the email envelope recipients with the given list of recipients. If the condition of this action applies only to a subset of recipients, only those recipients are replaced with the recipients specified in the action. The message contents and headers are unaffected by this action, only the envelope recipients are updated.</p>', 'refs' => [ 'RuleAction$ReplaceRecipient' => '<p>The action replaces certain or all recipients with a different set of recipients.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>Occurs when a requested resource is not found.</p>', 'refs' => [], ], 'ResultField' => [ 'base' => NULL, 'refs' => [ 'Analysis$ResultField' => '<p>The returned value from an Add On.</p>', 'IngressAnalysis$ResultField' => '<p>The returned value from an Add On.</p>', ], ], 'RetentionPeriod' => [ 'base' => NULL, 'refs' => [ 'ArchiveRetention$RetentionPeriod' => '<p>The enum value sets the period for retaining emails in an archive.</p>', ], ], 'Row' => [ 'base' => '<p>A result row containing metadata for an archived email message.</p>', 'refs' => [ 'RowsList$member' => NULL, ], ], 'RowsList' => [ 'base' => NULL, 'refs' => [ 'GetArchiveSearchResultsResponse$Rows' => '<p>The list of email result objects matching the search criteria.</p>', ], ], 'Rule' => [ 'base' => '<p>A rule contains conditions, "unless conditions" and actions. For each envelope recipient of an email, if all conditions match and none of the "unless conditions" match, then all of the actions are executed sequentially. If no conditions are provided, the rule always applies and the actions are implicitly executed. If only "unless conditions" are provided, the rule applies if the email does not match the evaluation of the "unless conditions".</p>', 'refs' => [ 'Rules$member' => NULL, ], ], 'RuleAction' => [ 'base' => '<p>The action for a rule to take. Only one of the contained actions can be set.</p>', 'refs' => [ 'RuleActions$member' => NULL, ], ], 'RuleActions' => [ 'base' => NULL, 'refs' => [ 'Rule$Actions' => '<p>The list of actions to execute when the conditions match the incoming email, and none of the "unless conditions" match.</p>', ], ], 'RuleBooleanEmailAttribute' => [ 'base' => NULL, 'refs' => [ 'RuleBooleanToEvaluate$Attribute' => '<p>The boolean type representing the allowed attribute types for an email.</p>', ], ], 'RuleBooleanExpression' => [ 'base' => '<p>A boolean expression to be used in a rule condition.</p>', 'refs' => [ 'RuleCondition$BooleanExpression' => '<p>The condition applies to a boolean expression passed in this field.</p>', ], ], 'RuleBooleanOperator' => [ 'base' => NULL, 'refs' => [ 'RuleBooleanExpression$Operator' => '<p>The matching operator for a boolean condition expression.</p>', ], ], 'RuleBooleanToEvaluate' => [ 'base' => '<p>The union type representing the allowed types of operands for a boolean condition.</p>', 'refs' => [ 'RuleBooleanExpression$Evaluate' => '<p>The operand on which to perform a boolean condition operation.</p>', ], ], 'RuleCondition' => [ 'base' => '<p>The conditional expression used to evaluate an email for determining if a rule action should be taken.</p>', 'refs' => [ 'RuleConditions$member' => NULL, ], ], 'RuleConditions' => [ 'base' => NULL, 'refs' => [ 'Rule$Conditions' => '<p>The conditions of this rule. All conditions must match the email for the actions to be executed. An empty list of conditions means that all emails match, but are still subject to any "unless conditions"</p>', 'Rule$Unless' => '<p>The "unless conditions" of this rule. None of the conditions can match the email for the actions to be executed. If any of these conditions do match the email, then the actions are not executed.</p>', ], ], 'RuleDmarcExpression' => [ 'base' => '<p>A DMARC policy expression. The condition matches if the given DMARC policy matches that of the incoming email.</p>', 'refs' => [ 'RuleCondition$DmarcExpression' => '<p>The condition applies to a DMARC policy expression passed in this field.</p>', ], ], 'RuleDmarcOperator' => [ 'base' => NULL, 'refs' => [ 'RuleDmarcExpression$Operator' => '<p>The operator to apply to the DMARC policy of the incoming email.</p>', ], ], 'RuleDmarcPolicy' => [ 'base' => NULL, 'refs' => [ 'RuleDmarcValueList$member' => NULL, ], ], 'RuleDmarcValueList' => [ 'base' => NULL, 'refs' => [ 'RuleDmarcExpression$Values' => '<p>The values to use for the given DMARC policy operator. For the operator EQUALS, if multiple values are given, they are evaluated as an OR. That is, if any of the given values match, the condition is deemed to match. For the operator NOT_EQUALS, if multiple values are given, they are evaluated as an AND. That is, only if the email\'s DMARC policy is not equal to any of the given values, then the condition is deemed to match.</p>', ], ], 'RuleIpEmailAttribute' => [ 'base' => NULL, 'refs' => [ 'RuleIpToEvaluate$Attribute' => '<p>The attribute of the email to evaluate.</p>', ], ], 'RuleIpExpression' => [ 'base' => '<p>An IP address expression matching certain IP addresses within a given range of IP addresses.</p>', 'refs' => [ 'RuleCondition$IpExpression' => '<p>The condition applies to an IP address expression passed in this field.</p>', ], ], 'RuleIpOperator' => [ 'base' => NULL, 'refs' => [ 'RuleIpExpression$Operator' => '<p>The operator to evaluate the IP address.</p>', ], ], 'RuleIpStringValue' => [ 'base' => NULL, 'refs' => [ 'RuleIpValueList$member' => NULL, ], ], 'RuleIpToEvaluate' => [ 'base' => '<p>The IP address to evaluate for this condition.</p>', 'refs' => [ 'RuleIpExpression$Evaluate' => '<p>The IP address to evaluate in this condition.</p>', ], ], 'RuleIpValueList' => [ 'base' => NULL, 'refs' => [ 'RuleIpExpression$Values' => '<p>The IP CIDR blocks in format "x.y.z.w/n" (eg 10.0.0.0/8) to match with the email\'s IP address. For the operator CIDR_MATCHES, if multiple values are given, they are evaluated as an OR. That is, if the IP address is contained within any of the given CIDR ranges, the condition is deemed to match. For NOT_CIDR_MATCHES, if multiple CIDR ranges are given, the condition is deemed to match if the IP address is not contained in any of the given CIDR ranges.</p>', ], ], 'RuleName' => [ 'base' => NULL, 'refs' => [ 'Rule$Name' => '<p>The user-friendly name of the rule.</p>', ], ], 'RuleNumberEmailAttribute' => [ 'base' => NULL, 'refs' => [ 'RuleNumberToEvaluate$Attribute' => '<p>An email attribute that is used as the number to evaluate.</p>', ], ], 'RuleNumberExpression' => [ 'base' => '<p>A number expression to match numeric conditions with integers from the incoming email.</p>', 'refs' => [ 'RuleCondition$NumberExpression' => '<p>The condition applies to a number expression passed in this field.</p>', ], ], 'RuleNumberOperator' => [ 'base' => NULL, 'refs' => [ 'RuleNumberExpression$Operator' => '<p>The operator for a numeric condition expression.</p>', ], ], 'RuleNumberToEvaluate' => [ 'base' => '<p>The number to evaluate in a numeric condition expression.</p>', 'refs' => [ 'RuleNumberExpression$Evaluate' => '<p>The number to evaluate in a numeric condition expression.</p>', ], ], 'RuleSet' => [ 'base' => '<p>A rule set contains a list of rules that are evaluated in order. Each rule is evaluated sequentially for each email.</p>', 'refs' => [ 'RuleSets$member' => NULL, ], ], 'RuleSetArn' => [ 'base' => NULL, 'refs' => [ 'GetRuleSetResponse$RuleSetArn' => '<p>The Amazon Resource Name (ARN) of the rule set resource.</p>', ], ], 'RuleSetId' => [ 'base' => NULL, 'refs' => [ 'CreateIngressPointRequest$RuleSetId' => '<p>The identifier of an existing rule set that you attach to an ingress endpoint resource.</p>', 'CreateRuleSetResponse$RuleSetId' => '<p>The identifier of the created rule set.</p>', 'DeleteRuleSetRequest$RuleSetId' => '<p>The identifier of an existing rule set resource to delete.</p>', 'GetIngressPointResponse$RuleSetId' => '<p>The identifier of a rule set resource associated with the ingress endpoint.</p>', 'GetRuleSetRequest$RuleSetId' => '<p>The identifier of an existing rule set to be retrieved.</p>', 'GetRuleSetResponse$RuleSetId' => '<p>The identifier of the rule set resource.</p>', 'RuleSet$RuleSetId' => '<p>The identifier of the rule set.</p>', 'UpdateIngressPointRequest$RuleSetId' => '<p>The identifier of an existing rule set that you attach to an ingress endpoint resource.</p>', 'UpdateRuleSetRequest$RuleSetId' => '<p>The identifier of a rule set you want to update.</p>', ], ], 'RuleSetName' => [ 'base' => NULL, 'refs' => [ 'CreateRuleSetRequest$RuleSetName' => '<p>A user-friendly name for the rule set.</p>', 'GetRuleSetResponse$RuleSetName' => '<p>A user-friendly name for the rule set resource.</p>', 'RuleSet$RuleSetName' => '<p>A user-friendly name for the rule set.</p>', 'UpdateRuleSetRequest$RuleSetName' => '<p>A user-friendly name for the rule set resource.</p>', ], ], 'RuleSets' => [ 'base' => NULL, 'refs' => [ 'ListRuleSetsResponse$RuleSets' => '<p>The list of rule sets.</p>', ], ], 'RuleStringEmailAttribute' => [ 'base' => NULL, 'refs' => [ 'RuleStringToEvaluate$Attribute' => '<p>The email attribute to evaluate in a string condition expression.</p>', ], ], 'RuleStringExpression' => [ 'base' => '<p>A string expression is evaluated against strings or substrings of the email.</p>', 'refs' => [ 'RuleCondition$StringExpression' => '<p>The condition applies to a string expression passed in this field.</p>', ], ], 'RuleStringList' => [ 'base' => NULL, 'refs' => [ 'RuleStringExpression$Values' => '<p>The string(s) to be evaluated in a string condition expression. For all operators, except for NOT_EQUALS, if multiple values are given, the values are processed as an OR. That is, if any of the values match the email\'s string using the given operator, the condition is deemed to match. However, for NOT_EQUALS, the condition is only deemed to match if none of the given strings match the email\'s string.</p>', ], ], 'RuleStringOperator' => [ 'base' => NULL, 'refs' => [ 'RuleStringExpression$Operator' => '<p>The matching operator for a string condition expression.</p>', ], ], 'RuleStringToEvaluate' => [ 'base' => '<p>The string to evaluate in a string condition expression.</p>', 'refs' => [ 'RuleStringExpression$Evaluate' => '<p>The string to evaluate in a string condition expression.</p>', ], ], 'RuleStringValue' => [ 'base' => NULL, 'refs' => [ 'RuleStringList$member' => NULL, ], ], 'RuleVerdict' => [ 'base' => NULL, 'refs' => [ 'RuleVerdictValueList$member' => NULL, ], ], 'RuleVerdictAttribute' => [ 'base' => NULL, 'refs' => [ 'RuleVerdictToEvaluate$Attribute' => '<p>The email verdict attribute to evaluate in a string verdict expression.</p>', ], ], 'RuleVerdictExpression' => [ 'base' => '<p>A verdict expression is evaluated against verdicts of the email.</p>', 'refs' => [ 'RuleCondition$VerdictExpression' => '<p>The condition applies to a verdict expression passed in this field.</p>', ], ], 'RuleVerdictOperator' => [ 'base' => NULL, 'refs' => [ 'RuleVerdictExpression$Operator' => '<p>The matching operator for a verdict condition expression.</p>', ], ], 'RuleVerdictToEvaluate' => [ 'base' => '<p>The verdict to evaluate in a verdict condition expression.</p>', 'refs' => [ 'RuleVerdictExpression$Evaluate' => '<p>The verdict to evaluate in a verdict condition expression.</p>', ], ], 'RuleVerdictValueList' => [ 'base' => NULL, 'refs' => [ 'RuleVerdictExpression$Values' => '<p>The values to match with the email\'s verdict using the given operator. For the EQUALS operator, if multiple values are given, the condition is deemed to match if any of the given verdicts match that of the email. For the NOT_EQUALS operator, if multiple values are given, the condition is deemed to match of none of the given verdicts match the verdict of the email.</p>', ], ], 'Rules' => [ 'base' => NULL, 'refs' => [ 'CreateRuleSetRequest$Rules' => '<p>Conditional rules that are evaluated for determining actions on email.</p>', 'GetRuleSetResponse$Rules' => '<p>The rules contained in the rule set.</p>', 'UpdateRuleSetRequest$Rules' => '<p>A new set of rules to replace the current rules of the rule set—these rules will override all the rules of the rule set.</p>', ], ], 'S3Action' => [ 'base' => '<p>Writes the MIME content of the email to an S3 bucket.</p>', 'refs' => [ 'RuleAction$WriteToS3' => '<p>This action writes the MIME content of the email to an S3 bucket.</p>', ], ], 'S3Bucket' => [ 'base' => NULL, 'refs' => [ 'S3Action$S3Bucket' => '<p>The bucket name of the S3 bucket to write to.</p>', ], ], 'S3ExportDestinationConfiguration' => [ 'base' => '<p>The configuration for exporting email data to an Amazon S3 bucket.</p>', 'refs' => [ 'ExportDestinationConfiguration$S3' => '<p>Configuration for delivering to an Amazon S3 bucket.</p>', ], ], 'S3Location' => [ 'base' => NULL, 'refs' => [ 'S3ExportDestinationConfiguration$S3Location' => '<p>The S3 location to deliver the exported email data.</p>', ], ], 'S3Prefix' => [ 'base' => NULL, 'refs' => [ 'S3Action$S3Prefix' => '<p>The S3 prefix to use for the write to the s3 bucket.</p>', ], ], 'S3PresignedURL' => [ 'base' => NULL, 'refs' => [ 'GetArchiveMessageResponse$MessageDownloadLink' => '<p>A pre-signed URL to temporarily download the full message content.</p>', ], ], 'SearchId' => [ 'base' => NULL, 'refs' => [ 'GetArchiveSearchRequest$SearchId' => '<p>The identifier of the search job to get details for.</p>', 'GetArchiveSearchResultsRequest$SearchId' => '<p>The identifier of the completed search job.</p>', 'SearchSummary$SearchId' => '<p>The unique identifier of the search job.</p>', 'StartArchiveSearchResponse$SearchId' => '<p>The unique identifier for the initiated search job.</p>', 'StopArchiveSearchRequest$SearchId' => '<p>The identifier of the search job to stop.</p>', ], ], 'SearchMaxResults' => [ 'base' => NULL, 'refs' => [ 'GetArchiveSearchResponse$MaxResults' => '<p>The maximum number of search results to return.</p>', 'StartArchiveSearchRequest$MaxResults' => '<p>The maximum number of search results to return.</p>', ], ], 'SearchState' => [ 'base' => NULL, 'refs' => [ 'SearchStatus$State' => '<p>The current state of the search job.</p>', ], ], 'SearchStatus' => [ 'base' => '<p>The current status of an archive search job.</p>', 'refs' => [ 'GetArchiveSearchResponse$Status' => '<p>The current status of the search job.</p>', 'SearchSummary$Status' => '<p>The current status of the search job.</p>', ], ], 'SearchSummary' => [ 'base' => '<p>Summary details of an archive search job.</p>', 'refs' => [ 'SearchSummaryList$member' => NULL, ], ], 'SearchSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListArchiveSearchesResponse$Searches' => '<p>The list of search job identifiers and statuses.</p>', ], ], 'SecretArn' => [ 'base' => NULL, 'refs' => [ 'IngressPointAuthConfiguration$SecretArn' => '<p>The ingress endpoint SecretsManager::Secret ARN configuration for the ingress endpoint resource.</p>', 'IngressPointConfiguration$SecretArn' => '<p>The SecretsManager::Secret ARN of the ingress endpoint resource.</p>', 'RelayAuthentication$SecretArn' => '<p>The ARN of the secret created in secrets manager where the relay server\'s SMTP credentials are stored.</p>', ], ], 'SendAction' => [ 'base' => '<p>Sends the email to the internet using the ses:SendRawEmail API.</p>', 'refs' => [ 'RuleAction$Send' => '<p>This action sends the email to the internet.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>Occurs when an operation exceeds a predefined service quota or limit.</p>', 'refs' => [], ], 'SmtpPassword' => [ 'base' => NULL, 'refs' => [ 'IngressPointConfiguration$SmtpPassword' => '<p>The password of the ingress endpoint resource.</p>', ], ], 'StartArchiveExportRequest' => [ 'base' => '<p>The request to initiate an export of emails from an archive.</p>', 'refs' => [], ], 'StartArchiveExportResponse' => [ 'base' => '<p>The response from initiating an archive export.</p>', 'refs' => [], ], 'StartArchiveSearchRequest' => [ 'base' => '<p>The request to initiate a search across emails in an archive.</p>', 'refs' => [], ], 'StartArchiveSearchResponse' => [ 'base' => '<p>The response from initiating an archive search.</p>', 'refs' => [], ], 'StopArchiveExportRequest' => [ 'base' => '<p>The request to stop an in-progress archive export job.</p>', 'refs' => [], ], 'StopArchiveExportResponse' => [ 'base' => '<p>The response indicating if the request to stop the export job succeeded.</p> <p>On success, returns an HTTP 200 status code. On failure, returns an error message.</p>', 'refs' => [], ], 'StopArchiveSearchRequest' => [ 'base' => '<p>The request to stop an in-progress archive search job.</p>', 'refs' => [], ], 'StopArchiveSearchResponse' => [ 'base' => '<p>The response indicating if the request to stop the search job succeeded.</p> <p>On success, returns an HTTP 200 status code. On failure, returns an error message.</p>', 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'EmailReceivedHeadersList$member' => NULL, 'IngressPointPasswordConfiguration$PreviousSmtpPasswordVersion' => '<p>The previous password version of the ingress endpoint resource.</p>', 'IngressPointPasswordConfiguration$SmtpPasswordVersion' => '<p>The current password expiry timestamp of the ingress endpoint resource.</p>', 'MessageBody$Html' => '<p>The HTML body content of the message.</p>', 'MessageBody$Text' => '<p>The plain text body content of the message.</p>', 'Row$Cc' => '<p>The email addresses in the CC header.</p>', 'Row$Date' => '<p>The date the email was sent.</p>', 'Row$From' => '<p>The email address of the sender.</p>', 'Row$InReplyTo' => '<p>The email message ID this is a reply to.</p>', 'Row$MessageId' => '<p>The unique message ID of the email.</p>', 'Row$Subject' => '<p>The subject header value of the email.</p>', 'Row$To' => '<p>The email addresses in the To header.</p>', 'Row$XMailer' => '<p>The user agent that sent the email.</p>', 'Row$XOriginalMailer' => '<p>The original user agent that sent the email.</p>', 'Row$XPriority' => '<p>The priority level of the email.</p>', 'StringList$member' => NULL, 'StringValueList$member' => NULL, ], ], 'StringList' => [ 'base' => NULL, 'refs' => [ 'IngressStringExpression$Values' => '<p>The right hand side argument of a string condition expression.</p>', ], ], 'StringValueList' => [ 'base' => NULL, 'refs' => [ 'ArchiveStringExpression$Values' => '<p>The list of string values to evaluate the email attribute against.</p>', ], ], 'Tag' => [ 'base' => '<p>A key-value pair (the value is optional), that you can define and assign to Amazon Web Services resources.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The key of the key-value tag.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p> The keys of the key-value pairs for the tag or tags you want to remove from the specified resource. </p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateAddonInstanceRequest$Tags' => '<p>The tags used to organize, track, or control access for the resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.</p>', 'CreateAddonSubscriptionRequest$Tags' => '<p>The tags used to organize, track, or control access for the resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.</p>', 'CreateArchiveRequest$Tags' => '<p>The tags used to organize, track, or control access for the resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.</p>', 'CreateIngressPointRequest$Tags' => '<p>The tags used to organize, track, or control access for the resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.</p>', 'CreateRelayRequest$Tags' => '<p>The tags used to organize, track, or control access for the resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.</p>', 'CreateRuleSetRequest$Tags' => '<p>The tags used to organize, track, or control access for the resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.</p>', 'CreateTrafficPolicyRequest$Tags' => '<p>The tags used to organize, track, or control access for the resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.</p>', 'ListTagsForResourceResponse$Tags' => '<p>The tags used to organize, track, or control access for the resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.</p>', 'TagResourceRequest$Tags' => '<p> The tags used to organize, track, or control access for the resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }. </p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The value of the key-value tag.</p>', ], ], 'TaggableResourceArn' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource to retrieve tags from.</p>', 'TagResourceRequest$ResourceArn' => '<p> The Amazon Resource Name (ARN) of the resource that you want to tag. </p>', 'UntagResourceRequest$ResourceArn' => '<p> The Amazon Resource Name (ARN) of the resource that you want to untag. </p>', ], ], 'ThrottlingException' => [ 'base' => '<p>Occurs when a service\'s request rate limit is exceeded, resulting in throttling of further requests.</p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'AddonInstance$CreatedTimestamp' => '<p>The timestamp of when the Add On instance was created.</p>', 'AddonSubscription$CreatedTimestamp' => '<p>The timestamp of when the Add On subscription was created.</p>', 'Archive$LastUpdatedTimestamp' => '<p>The timestamp of when the archive was last updated.</p>', 'ExportStatus$CompletionTimestamp' => '<p>The timestamp of when the export job completed (if finished).</p>', 'ExportStatus$SubmissionTimestamp' => '<p>The timestamp of when the export job was submitted.</p>', 'GetAddonInstanceResponse$CreatedTimestamp' => '<p>The timestamp of when the Add On instance was created.</p>', 'GetAddonSubscriptionResponse$CreatedTimestamp' => '<p>The timestamp of when the Add On subscription was created.</p>', 'GetArchiveExportResponse$FromTimestamp' => '<p>The start of the timestamp range the exported emails cover.</p>', 'GetArchiveExportResponse$ToTimestamp' => '<p>The end of the date range the exported emails cover.</p>', 'GetArchiveResponse$CreatedTimestamp' => '<p>The timestamp of when the archive was created.</p>', 'GetArchiveResponse$LastUpdatedTimestamp' => '<p>The timestamp of when the archive was modified.</p>', 'GetArchiveSearchResponse$FromTimestamp' => '<p>The start timestamp of the range the searched emails cover.</p>', 'GetArchiveSearchResponse$ToTimestamp' => '<p>The end timestamp of the range the searched emails cover.</p>', 'GetIngressPointResponse$CreatedTimestamp' => '<p>The timestamp of when the ingress endpoint was created.</p>', 'GetIngressPointResponse$LastUpdatedTimestamp' => '<p>The timestamp of when the ingress endpoint was last updated.</p>', 'GetRelayResponse$CreatedTimestamp' => '<p>The timestamp of when the relay was created.</p>', 'GetRelayResponse$LastModifiedTimestamp' => '<p>The timestamp of when relay was last updated.</p>', 'GetRuleSetResponse$CreatedDate' => '<p>The date of when then rule set was created.</p>', 'GetRuleSetResponse$LastModificationDate' => '<p>The date of when the rule set was last modified.</p>', 'GetTrafficPolicyResponse$CreatedTimestamp' => '<p>The timestamp of when the traffic policy was created.</p>', 'GetTrafficPolicyResponse$LastUpdatedTimestamp' => '<p>The timestamp of when the traffic policy was last updated.</p>', 'IngressPointPasswordConfiguration$PreviousSmtpPasswordExpiryTimestamp' => '<p>The previous password expiry timestamp of the ingress endpoint resource.</p>', 'Relay$LastModifiedTimestamp' => '<p>The timestamp of when the relay was last modified.</p>', 'Row$ReceivedTimestamp' => '<p>The timestamp of when the email was received.</p>', 'RuleSet$LastModificationDate' => '<p>The last modification date of the rule set.</p>', 'SearchStatus$CompletionTimestamp' => '<p>The timestamp of when the search completed (if finished).</p>', 'SearchStatus$SubmissionTimestamp' => '<p>The timestamp of when the search was submitted.</p>', 'StartArchiveExportRequest$FromTimestamp' => '<p>The start of the timestamp range to include emails from.</p>', 'StartArchiveExportRequest$ToTimestamp' => '<p>The end of the timestamp range to include emails from.</p>', 'StartArchiveSearchRequest$FromTimestamp' => '<p>The start timestamp of the range to search emails from.</p>', 'StartArchiveSearchRequest$ToTimestamp' => '<p>The end timestamp of the range to search emails from.</p>', ], ], 'TrafficPolicy' => [ 'base' => '<p>The structure of a traffic policy resource which is a container for policy statements.</p>', 'refs' => [ 'TrafficPolicyList$member' => NULL, ], ], 'TrafficPolicyArn' => [ 'base' => NULL, 'refs' => [ 'GetTrafficPolicyResponse$TrafficPolicyArn' => '<p>The Amazon Resource Name (ARN) of the traffic policy resource.</p>', ], ], 'TrafficPolicyId' => [ 'base' => NULL, 'refs' => [ 'CreateIngressPointRequest$TrafficPolicyId' => '<p>The identifier of an existing traffic policy that you attach to an ingress endpoint resource.</p>', 'CreateTrafficPolicyResponse$TrafficPolicyId' => '<p>The identifier of the traffic policy resource.</p>', 'DeleteTrafficPolicyRequest$TrafficPolicyId' => '<p>The identifier of the traffic policy that you want to delete.</p>', 'GetIngressPointResponse$TrafficPolicyId' => '<p>The identifier of the traffic policy resource associated with the ingress endpoint.</p>', 'GetTrafficPolicyRequest$TrafficPolicyId' => '<p>The identifier of the traffic policy resource.</p>', 'GetTrafficPolicyResponse$TrafficPolicyId' => '<p>The identifier of the traffic policy resource.</p>', 'TrafficPolicy$TrafficPolicyId' => '<p>The identifier of the traffic policy resource.</p>', 'UpdateIngressPointRequest$TrafficPolicyId' => '<p>The identifier of an existing traffic policy that you attach to an ingress endpoint resource.</p>', 'UpdateTrafficPolicyRequest$TrafficPolicyId' => '<p>The identifier of the traffic policy that you want to update.</p>', ], ], 'TrafficPolicyList' => [ 'base' => NULL, 'refs' => [ 'ListTrafficPoliciesResponse$TrafficPolicies' => '<p>The list of traffic policies.</p>', ], ], 'TrafficPolicyName' => [ 'base' => NULL, 'refs' => [ 'CreateTrafficPolicyRequest$TrafficPolicyName' => '<p>A user-friendly name for the traffic policy resource.</p>', 'GetTrafficPolicyResponse$TrafficPolicyName' => '<p>A user-friendly name for the traffic policy resource.</p>', 'TrafficPolicy$TrafficPolicyName' => '<p>A user-friendly name of the traffic policy resource.</p>', 'UpdateTrafficPolicyRequest$TrafficPolicyName' => '<p>A user-friendly name for the traffic policy resource.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateArchiveRequest' => [ 'base' => '<p>The request to update properties of an existing email archive.</p>', 'refs' => [], ], 'UpdateArchiveResponse' => [ 'base' => '<p>The response indicating if the archive update succeeded or failed.</p> <p>On success, returns an HTTP 200 status code. On failure, returns an error message.</p>', 'refs' => [], ], 'UpdateIngressPointRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateIngressPointResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRelayRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRelayResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRuleSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRuleSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTrafficPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTrafficPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>The request validation has failed. For details, see the accompanying error message.</p>', 'refs' => [], ], ],];
