<?php
// This file was auto-generated from sdk-root/src/data/mediaconnect/2018-11-14/docs-2.json
return [ 'version' => '2.0', 'service' => 'API for AWS Elemental MediaConnect', 'operations' => [ 'AddBridgeOutputs' => 'Adds outputs to an existing bridge.', 'AddBridgeSources' => 'Adds sources to an existing bridge.', 'AddFlowMediaStreams' => 'Adds media streams to an existing flow. After you add a media stream to a flow, you can associate it with a source and/or an output that uses the ST 2110 JPEG XS or CDI protocol.', 'AddFlowOutputs' => 'Adds outputs to an existing flow. You can create up to 50 outputs per flow.', 'AddFlowSources' => 'Adds Sources to flow', 'AddFlowVpcInterfaces' => 'Adds VPC interfaces to flow', 'CreateBridge' => 'Creates a new bridge. The request must include one source.', 'CreateFlow' => 'Creates a new flow. The request must include one source. The request optionally can include outputs (up to 50) and entitlements (up to 50).', 'CreateGateway' => 'Creates a new gateway. The request must include at least one network (up to 4).', 'DeleteBridge' => 'Deletes a bridge. Before you can delete a bridge, you must stop the bridge.', 'DeleteFlow' => 'Deletes a flow. Before you can delete a flow, you must stop the flow.', 'DeleteGateway' => 'Deletes a gateway. Before you can delete a gateway, you must deregister its instances and delete its bridges.', 'DeregisterGatewayInstance' => 'Deregisters an instance. Before you deregister an instance, all bridges running on the instance must be stopped. If you want to deregister an instance without stopping the bridges, you must use the --force option.', 'DescribeBridge' => 'Displays the details of a bridge.', 'DescribeFlow' => 'Displays the details of a flow. The response includes the flow ARN, name, and Availability Zone, as well as details about the source, outputs, and entitlements.', 'DescribeFlowSourceMetadata' => 'Displays details of the flow\'s source stream. The response contains information about the contents of the stream and its programs.', 'DescribeGateway' => 'Displays the details of a gateway. The response includes the gateway ARN, name, and CIDR blocks, as well as details about the networks.', 'DescribeGatewayInstance' => 'Displays the details of an instance.', 'DescribeOffering' => 'Displays the details of an offering. The response includes the offering description, duration, outbound bandwidth, price, and Amazon Resource Name (ARN).', 'DescribeReservation' => 'Displays the details of a reservation. The response includes the reservation name, state, start date and time, and the details of the offering that make up the rest of the reservation (such as price, duration, and outbound bandwidth).', 'GrantFlowEntitlements' => 'Grants entitlements to an existing flow.', 'ListBridges' => 'Displays a list of bridges that are associated with this account and an optionally specified Arn. This request returns a paginated result.', 'ListEntitlements' => 'Displays a list of all entitlements that have been granted to this account. This request returns 20 results per page.', 'ListFlows' => 'Displays a list of flows that are associated with this account. This request returns a paginated result.', 'ListGatewayInstances' => 'Displays a list of instances associated with the AWS account. This request returns a paginated result. You can use the filterArn property to display only the instances associated with the selected Gateway Amazon Resource Name (ARN).', 'ListGateways' => 'Displays a list of gateways that are associated with this account. This request returns a paginated result.', 'ListOfferings' => 'Displays a list of all offerings that are available to this account in the current AWS Region. If you have an active reservation (which means you\'ve purchased an offering that has already started and hasn\'t expired yet), your account isn\'t eligible for other offerings.', 'ListReservations' => 'Displays a list of all reservations that have been purchased by this account in the current AWS Region. This list includes all reservations in all states (such as active and expired).', 'ListTagsForResource' => 'List all tags on an AWS Elemental MediaConnect resource', 'PurchaseOffering' => 'Submits a request to purchase an offering. If you already have an active reservation, you can\'t purchase another offering.', 'RemoveBridgeOutput' => 'Removes an output from a bridge.', 'RemoveBridgeSource' => 'Removes a source from a bridge.', 'RemoveFlowMediaStream' => 'Removes a media stream from a flow. This action is only available if the media stream is not associated with a source or output.', 'RemoveFlowOutput' => 'Removes an output from an existing flow. This request can be made only on an output that does not have an entitlement associated with it. If the output has an entitlement, you must revoke the entitlement instead. When an entitlement is revoked from a flow, the service automatically removes the associated output.', 'RemoveFlowSource' => 'Removes a source from an existing flow. This request can be made only if there is more than one source on the flow.', 'RemoveFlowVpcInterface' => 'Removes a VPC Interface from an existing flow. This request can be made only on a VPC interface that does not have a Source or Output associated with it. If the VPC interface is referenced by a Source or Output, you must first delete or update the Source or Output to no longer reference the VPC interface.', 'RevokeFlowEntitlement' => 'Revokes an entitlement from a flow. Once an entitlement is revoked, the content becomes unavailable to the subscriber and the associated output is removed.', 'StartFlow' => 'Starts a flow.', 'StopFlow' => 'Stops a flow.', 'TagResource' => 'Associates the specified tags to a resource with the specified resourceArn. If existing tags on a resource are not specified in the request parameters, they are not changed. When a resource is deleted, the tags associated with that resource are deleted as well.', 'UntagResource' => 'Deletes specified tags from a resource.', 'UpdateBridge' => 'Updates the bridge', 'UpdateBridgeOutput' => 'Updates an existing bridge output.', 'UpdateBridgeSource' => 'Updates an existing bridge source.', 'UpdateBridgeState' => 'Updates the bridge state', 'UpdateFlow' => 'Updates flow', 'UpdateFlowEntitlement' => 'You can change an entitlement\'s description, subscribers, and encryption. If you change the subscribers, the service will remove the outputs that are are used by the subscribers that are removed.', 'UpdateFlowMediaStream' => 'Updates an existing media stream.', 'UpdateFlowOutput' => 'Updates an existing flow output.', 'UpdateFlowSource' => 'Updates the source of a flow.', 'UpdateGatewayInstance' => 'Updates the configuration of an existing Gateway Instance.', ], 'shapes' => [ 'AddBridgeFlowSourceRequest' => [ 'base' => 'Add a flow source to an existing bridge.', 'refs' => [ 'AddBridgeSourceRequest$FlowSource' => NULL, ], ], 'AddBridgeNetworkOutputRequest' => [ 'base' => 'Add a network output to an existing bridge.', 'refs' => [ 'AddBridgeOutputRequest$NetworkOutput' => NULL, ], ], 'AddBridgeNetworkSourceRequest' => [ 'base' => 'Add a network source to an existing bridge.', 'refs' => [ 'AddBridgeSourceRequest$NetworkSource' => NULL, ], ], 'AddBridgeOutputRequest' => [ 'base' => 'Add an output to a bridge.', 'refs' => [ '__listOfAddBridgeOutputRequest$member' => NULL, ], ], 'AddBridgeOutputsRequest' => [ 'base' => 'Adds outputs to an existing bridge. You can create up to 2 outputs per bridge.', 'refs' => [], ], 'AddBridgeOutputsResponse' => [ 'base' => 'The result of a successful AddBridgeOutputs request.', 'refs' => [], ], 'AddBridgeSourceRequest' => [ 'base' => 'Add a source to an existing bridge.', 'refs' => [ '__listOfAddBridgeSourceRequest$member' => NULL, ], ], 'AddBridgeSourcesRequest' => [ 'base' => 'Add sources to an existing bridge. You can create up to 2 sources per bridge.', 'refs' => [], ], 'AddBridgeSourcesResponse' => [ 'base' => 'The result of a successful AddBridgeSources request.', 'refs' => [], ], 'AddEgressGatewayBridgeRequest' => [ 'base' => NULL, 'refs' => [ 'CreateBridgeRequest$EgressGatewayBridge' => 'Create a bridge with the egress bridge type. An egress bridge is a cloud-to-ground bridge. The content comes from an existing MediaConnect flow and is delivered to your premises.', ], ], 'AddFlowMediaStreamsRequest' => [ 'base' => 'Adds media streams to an existing flow.', 'refs' => [], ], 'AddFlowMediaStreamsResponse' => [ 'base' => 'The result of a successful AddFlowMediaStreams request. The response includes the details of the newly added media streams.', 'refs' => [], ], 'AddFlowOutputs420Exception' => [ 'base' => 'Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.', 'refs' => [], ], 'AddFlowOutputsRequest' => [ 'base' => 'Adds outputs to an existing flow. You can create up to 50 outputs per flow.', 'refs' => [], ], 'AddFlowOutputsResponse' => [ 'base' => 'The result of a successful AddOutput request. The response includes the details of the newly added outputs.', 'refs' => [], ], 'AddFlowSourcesRequest' => [ 'base' => 'Adds sources to an existing flow.', 'refs' => [], ], 'AddFlowSourcesResponse' => [ 'base' => 'The result of a successful AddFlowSources request. The response includes the details of the newly added sources.', 'refs' => [], ], 'AddFlowVpcInterfacesRequest' => [ 'base' => 'Adds VPC interfaces to an existing flow.', 'refs' => [], ], 'AddFlowVpcInterfacesResponse' => [ 'base' => 'The result of a successful AddFlowVpcInterfaces request. The response includes the details of the newly added VPC interfaces.', 'refs' => [], ], 'AddIngressGatewayBridgeRequest' => [ 'base' => NULL, 'refs' => [ 'CreateBridgeRequest$IngressGatewayBridge' => 'Create a bridge with the ingress bridge type. An ingress bridge is a ground-to-cloud bridge. The content originates at your premises and is delivered to the cloud.', ], ], 'AddMaintenance' => [ 'base' => 'Create maintenance setting for a flow', 'refs' => [ 'CreateFlowRequest$Maintenance' => NULL, ], ], 'AddMediaStreamRequest' => [ 'base' => 'The media stream that you want to add to the flow.', 'refs' => [ '__listOfAddMediaStreamRequest$member' => NULL, ], ], 'AddOutputRequest' => [ 'base' => 'The output that you want to add to this flow.', 'refs' => [ '__listOfAddOutputRequest$member' => NULL, ], ], 'Algorithm' => [ 'base' => NULL, 'refs' => [ 'Encryption$Algorithm' => 'The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).', 'UpdateEncryption$Algorithm' => 'The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).', ], ], 'BadRequestException' => [ 'base' => 'Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.', 'refs' => [], ], 'Bridge' => [ 'base' => 'A Bridge is the connection between your datacenter\'s Instances and the AWS cloud. A bridge can be used to send video from the AWS cloud to your datacenter or from your datacenter to the AWS cloud.', 'refs' => [ 'CreateBridgeResponse$Bridge' => NULL, 'DescribeBridgeResponse$Bridge' => NULL, 'UpdateBridgeResponse$Bridge' => NULL, ], ], 'BridgeFlowOutput' => [ 'base' => 'The output of the bridge. A flow output is delivered to the AWS cloud.', 'refs' => [ 'BridgeOutput$FlowOutput' => NULL, ], ], 'BridgeFlowSource' => [ 'base' => 'The source of the bridge. A flow source originates in MediaConnect as an existing cloud flow.', 'refs' => [ 'BridgeSource$FlowSource' => NULL, ], ], 'BridgeNetworkOutput' => [ 'base' => 'The output of the bridge. A network output is delivered to your premises.', 'refs' => [ 'BridgeOutput$NetworkOutput' => NULL, ], ], 'BridgeNetworkSource' => [ 'base' => 'The source of the bridge. A network source originates at your premises.', 'refs' => [ 'BridgeSource$NetworkSource' => NULL, ], ], 'BridgeOutput' => [ 'base' => 'The output of the bridge.', 'refs' => [ 'UpdateBridgeOutputResponse$Output' => 'The output that you updated.', '__listOfBridgeOutput$member' => NULL, ], ], 'BridgePlacement' => [ 'base' => NULL, 'refs' => [ 'GatewayInstance$BridgePlacement' => 'The availability of the instance to host new bridges. The bridgePlacement property can be LOCKED or AVAILABLE. If it is LOCKED, no new bridges can be deployed to this instance. If it is AVAILABLE, new bridges can be added to this instance.', 'UpdateGatewayInstanceRequest$BridgePlacement' => 'The availability of the instance to host new bridges. The bridgePlacement property can be LOCKED or AVAILABLE. If it is LOCKED, no new bridges can be deployed to this instance. If it is AVAILABLE, new bridges can be added to this instance.', 'UpdateGatewayInstanceResponse$BridgePlacement' => 'The availability of the instance to host new bridges. The bridgePlacement property can be LOCKED or AVAILABLE. If it is LOCKED, no new bridges can be deployed to this instance. If it is AVAILABLE, new bridges can be added to this instance.', ], ], 'BridgeSource' => [ 'base' => 'The bridge\'s source.', 'refs' => [ 'UpdateBridgeSourceResponse$Source' => NULL, '__listOfBridgeSource$member' => NULL, ], ], 'BridgeState' => [ 'base' => NULL, 'refs' => [ 'Bridge$BridgeState' => NULL, 'ListedBridge$BridgeState' => NULL, ], ], 'Colorimetry' => [ 'base' => NULL, 'refs' => [ 'Fmtp$Colorimetry' => 'The format that is used for the representation of color.', 'FmtpRequest$Colorimetry' => 'The format that is used for the representation of color.', ], ], 'ConflictException' => [ 'base' => 'Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.', 'refs' => [], ], 'ConnectionStatus' => [ 'base' => NULL, 'refs' => [ 'GatewayInstance$ConnectionStatus' => 'The connection state of the instance.', ], ], 'CreateBridge420Exception' => [ 'base' => 'Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.', 'refs' => [], ], 'CreateBridgeRequest' => [ 'base' => 'Creates a new bridge. The request must include one source.', 'refs' => [], ], 'CreateBridgeResponse' => [ 'base' => 'The result of a successful CreateBridge request.', 'refs' => [], ], 'CreateFlow420Exception' => [ 'base' => 'Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.', 'refs' => [], ], 'CreateFlowRequest' => [ 'base' => 'Creates a new flow. The request must include one source. The request optionally can include outputs (up to 50) and entitlements (up to 50.)', 'refs' => [], ], 'CreateFlowResponse' => [ 'base' => 'The result of a successful CreateFlow request.', 'refs' => [], ], 'CreateGateway420Exception' => [ 'base' => 'Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.', 'refs' => [], ], 'CreateGatewayRequest' => [ 'base' => 'Creates a new gateway. The request must include one network (up to 4).', 'refs' => [], ], 'DeleteBridgeResponse' => [ 'base' => 'The result of a successful DeleteBridge request.', 'refs' => [], ], 'DeleteFlowResponse' => [ 'base' => 'The result of a successful DeleteFlow request.', 'refs' => [], ], 'DeleteGatewayResponse' => [ 'base' => 'The result of a successful DeleteGateway request.', 'refs' => [], ], 'DeregisterGatewayInstanceResponse' => [ 'base' => 'The result of a successful DeregisterGatewayInstance request.', 'refs' => [], ], 'DescribeBridgeResponse' => [ 'base' => 'The result of a successful DescribeBridge request.', 'refs' => [], ], 'DescribeFlowResponse' => [ 'base' => 'The result of a successful DescribeFlow request.', 'refs' => [], ], 'DescribeFlowSourceMetadataResponse' => [ 'base' => 'The result of a successful DescribeFlowSourceMetadata request.', 'refs' => [], ], 'DescribeGatewayInstanceResponse' => [ 'base' => 'The result of a successful DescribeGatewayInstance request.', 'refs' => [], ], 'DescribeGatewayResponse' => [ 'base' => 'The result of a successful DescribeGateway request.', 'refs' => [], ], 'DescribeOfferingResponse' => [ 'base' => 'The result of a successful DescribeOffering request.', 'refs' => [], ], 'DescribeReservationResponse' => [ 'base' => 'The result of a successful DescribeReservation request.', 'refs' => [], ], 'DesiredState' => [ 'base' => NULL, 'refs' => [ 'UpdateBridgeStateRequest$DesiredState' => NULL, 'UpdateBridgeStateResponse$DesiredState' => 'The state of the bridge. ACTIVE or STANDBY.', ], ], 'DestinationConfiguration' => [ 'base' => 'The transport parameters that are associated with an outbound media stream.', 'refs' => [ '__listOfDestinationConfiguration$member' => NULL, ], ], 'DestinationConfigurationRequest' => [ 'base' => 'The transport parameters that you want to associate with an outbound media stream.', 'refs' => [ '__listOfDestinationConfigurationRequest$member' => NULL, ], ], 'DurationUnits' => [ 'base' => NULL, 'refs' => [ 'Offering$DurationUnits' => 'The unit of measurement for the duration of the offering.', 'Reservation$DurationUnits' => 'The unit of measurement for the duration of the reservation. MediaConnect defines this value in the offering.', ], ], 'EgressGatewayBridge' => [ 'base' => NULL, 'refs' => [ 'Bridge$EgressGatewayBridge' => NULL, ], ], 'EncoderProfile' => [ 'base' => NULL, 'refs' => [ 'EncodingParameters$EncoderProfile' => 'A setting on the encoder that drives compression settings. This property only applies to video media streams associated with outputs that use the ST 2110 JPEG XS protocol, with a flow source that uses the CDI protocol.', 'EncodingParametersRequest$EncoderProfile' => 'A setting on the encoder that drives compression settings. This property only applies to video media streams associated with outputs that use the ST 2110 JPEG XS protocol, if at least one source on the flow uses the CDI protocol.', ], ], 'EncodingName' => [ 'base' => NULL, 'refs' => [ 'MediaStreamOutputConfiguration$EncodingName' => 'The format that was used to encode the data. For ancillary data streams, set the encoding name to smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to raw. For video, JPEG XS streams, set the encoding name to jxsv.', 'MediaStreamOutputConfigurationRequest$EncodingName' => 'The format that will be used to encode the data. For ancillary data streams, set the encoding name to smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to raw. For video, JPEG XS streams, set the encoding name to jxsv.', 'MediaStreamSourceConfiguration$EncodingName' => 'The format that was used to encode the data. For ancillary data streams, set the encoding name to smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to raw. For video, JPEG XS streams, set the encoding name to jxsv.', 'MediaStreamSourceConfigurationRequest$EncodingName' => 'The format you want to use to encode the data. For ancillary data streams, set the encoding name to smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to raw. For video, JPEG XS streams, set the encoding name to jxsv.', ], ], 'EncodingParameters' => [ 'base' => 'A collection of parameters that determine how MediaConnect will convert the content. These fields only apply to outputs on flows that have a CDI source.', 'refs' => [ 'MediaStreamOutputConfiguration$EncodingParameters' => 'Encoding parameters', ], ], 'EncodingParametersRequest' => [ 'base' => 'A collection of parameters that determine how MediaConnect will convert the content. These fields only apply to outputs on flows that have a CDI source.', 'refs' => [ 'MediaStreamOutputConfigurationRequest$EncodingParameters' => 'A collection of parameters that determine how MediaConnect will convert the content. These fields only apply to outputs on flows that have a CDI source.', ], ], 'Encryption' => [ 'base' => 'Information about the encryption of the flow.', 'refs' => [ 'AddOutputRequest$Encryption' => 'The type of key used for the encryption. If no keyType is provided, the service will use the default setting (static-key). Allowable encryption types: static-key.', 'Entitlement$Encryption' => 'The type of encryption that will be used on the output that is associated with this entitlement.', 'GrantEntitlementRequest$Encryption' => 'The type of encryption that will be used on the output that is associated with this entitlement. Allowable encryption types: static-key, speke.', 'Output$Encryption' => 'The type of key used for the encryption. If no keyType is provided, the service will use the default setting (static-key).', 'SetSourceRequest$Decryption' => 'The type of encryption that is used on the content ingested from this source. Allowable encryption types: static-key.', 'Source$Decryption' => 'The type of encryption that is used on the content ingested from this source.', ], ], 'Entitlement' => [ 'base' => 'The settings for a flow entitlement.', 'refs' => [ 'UpdateFlowEntitlementResponse$Entitlement' => 'The new configuration of the entitlement that you updated.', '__listOfEntitlement$member' => NULL, ], ], 'EntitlementStatus' => [ 'base' => NULL, 'refs' => [ 'Entitlement$EntitlementStatus' => 'An indication of whether the entitlement is enabled.', 'GrantEntitlementRequest$EntitlementStatus' => 'An indication of whether the new entitlement should be enabled or disabled as soon as it is created. If you don’t specify the entitlementStatus field in your request, MediaConnect sets it to ENABLED.', 'UpdateFlowEntitlementRequest$EntitlementStatus' => 'An indication of whether you want to enable the entitlement to allow access, or disable it to stop streaming content to the subscriber’s flow temporarily. If you don’t specify the entitlementStatus field in your request, MediaConnect leaves the value unchanged.', ], ], 'FailoverConfig' => [ 'base' => 'The settings for source failover.', 'refs' => [ 'Bridge$SourceFailoverConfig' => NULL, 'CreateBridgeRequest$SourceFailoverConfig' => 'The settings for source failover.', 'CreateFlowRequest$SourceFailoverConfig' => NULL, 'Flow$SourceFailoverConfig' => NULL, ], ], 'FailoverMode' => [ 'base' => NULL, 'refs' => [ 'FailoverConfig$FailoverMode' => 'The type of failover you choose for this flow. MERGE combines the source streams into a single stream, allowing graceful recovery from any single-source loss. FAILOVER allows switching between different streams.', 'UpdateFailoverConfig$FailoverMode' => 'The type of failover you choose for this flow. MERGE combines the source streams into a single stream, allowing graceful recovery from any single-source loss. FAILOVER allows switching between different streams.', ], ], 'Flow' => [ 'base' => 'The settings for a flow, including its source, outputs, and entitlements.', 'refs' => [ 'CreateFlowResponse$Flow' => NULL, 'DescribeFlowResponse$Flow' => NULL, 'UpdateFlowResponse$Flow' => NULL, ], ], 'Fmtp' => [ 'base' => 'FMTP', 'refs' => [ 'MediaStreamAttributes$Fmtp' => 'A set of parameters that define the media stream.', ], ], 'FmtpRequest' => [ 'base' => 'The settings that you want to use to define the media stream.', 'refs' => [ 'MediaStreamAttributesRequest$Fmtp' => 'The settings that you want to use to define the media stream.', ], ], 'ForbiddenException' => [ 'base' => 'Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.', 'refs' => [], ], 'FrameResolution' => [ 'base' => 'The frame resolution used by the video stream.', 'refs' => [ 'TransportStream$FrameResolution' => NULL, ], ], 'Gateway' => [ 'base' => 'The settings for a gateway, including its networks.', 'refs' => [ 'DescribeGatewayResponse$Gateway' => NULL, ], ], 'GatewayBridgeSource' => [ 'base' => 'The source configuration for cloud flows receiving a stream from a bridge.', 'refs' => [ 'Source$GatewayBridgeSource' => 'The source configuration for cloud flows receiving a stream from a bridge.', ], ], 'GatewayInstance' => [ 'base' => 'The settings for an instance in a gateway.', 'refs' => [ 'DescribeGatewayInstanceResponse$GatewayInstance' => NULL, ], ], 'GatewayNetwork' => [ 'base' => 'The network settings for a gateway.', 'refs' => [ '__listOfGatewayNetwork$member' => NULL, ], ], 'GatewayState' => [ 'base' => NULL, 'refs' => [ 'Gateway$GatewayState' => 'The current status of the gateway.', 'ListedGateway$GatewayState' => NULL, ], ], 'GrantEntitlementRequest' => [ 'base' => 'The entitlements that you want to grant on a flow.', 'refs' => [ '__listOfGrantEntitlementRequest$member' => NULL, ], ], 'GrantFlowEntitlements420Exception' => [ 'base' => 'Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.', 'refs' => [], ], 'GrantFlowEntitlementsRequest' => [ 'base' => 'Grants an entitlement on a flow.', 'refs' => [], ], 'GrantFlowEntitlementsResponse' => [ 'base' => 'The result of a successful GrantFlowEntitlements request.', 'refs' => [], ], 'IngressGatewayBridge' => [ 'base' => NULL, 'refs' => [ 'Bridge$IngressGatewayBridge' => NULL, ], ], 'InputConfiguration' => [ 'base' => 'The transport parameters that are associated with an incoming media stream.', 'refs' => [ '__listOfInputConfiguration$member' => NULL, ], ], 'InputConfigurationRequest' => [ 'base' => 'The transport parameters that you want to associate with an incoming media stream.', 'refs' => [ '__listOfInputConfigurationRequest$member' => NULL, ], ], 'InstanceState' => [ 'base' => NULL, 'refs' => [ 'DeregisterGatewayInstanceResponse$InstanceState' => 'The status of the instance.', 'GatewayInstance$InstanceState' => 'The status of the instance.', 'ListedGatewayInstance$InstanceState' => 'The status of the instance.', ], ], 'Interface' => [ 'base' => 'The VPC interface that is used for the media stream associated with the source or output.', 'refs' => [ 'DestinationConfiguration$Interface' => 'The VPC interface that is used for the media stream associated with the output.', 'InputConfiguration$Interface' => 'The VPC interface where the media stream comes in from.', ], ], 'InterfaceRequest' => [ 'base' => 'The VPC interface that you want to designate where the media stream is coming from or going to.', 'refs' => [ 'DestinationConfigurationRequest$Interface' => 'The VPC interface that you want to use for the media stream associated with the output.', 'InputConfigurationRequest$Interface' => 'The VPC interface that you want to use for the incoming media stream.', ], ], 'InternalServerErrorException' => [ 'base' => 'Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.', 'refs' => [], ], 'KeyType' => [ 'base' => NULL, 'refs' => [ 'Encryption$KeyType' => 'The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).', 'UpdateEncryption$KeyType' => 'The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).', ], ], 'ListBridgesResponse' => [ 'base' => 'The result of a successful ListBridges request. The response includes bridge summaries and the NextToken to use in a subsequent ListBridges request.', 'refs' => [], ], 'ListEntitlementsResponse' => [ 'base' => 'The result of a successful ListEntitlements request. The response includes the ARN of each entitlement, the name of the associated flow, and the NextToken to use in a subsequent ListEntitlements request.', 'refs' => [], ], 'ListFlowsResponse' => [ 'base' => 'The result of a successful ListFlows request. The response includes flow summaries and the NextToken to use in a subsequent ListFlows request.', 'refs' => [], ], 'ListGatewayInstancesResponse' => [ 'base' => 'The result of a successful ListGatewayInstances request. The response includes instance summaries and the NextToken to use in a subsequent ListInstances request.', 'refs' => [], ], 'ListGatewaysResponse' => [ 'base' => 'The result of a successful ListGateways request. The response includes gateway summaries and the NextToken to use in a subsequent ListGateways request.', 'refs' => [], ], 'ListOfferingsResponse' => [ 'base' => 'The result of a successful ListOfferings request. The response includes the details of each offering that your account is eligible for. The response includes the following information for each offering: description, duration, outbound bandwidth, price, Amazon Resource Name (ARN), and the NextToken to use in a subsequent ListOfferings request.', 'refs' => [], ], 'ListReservationsResponse' => [ 'base' => 'The result of a successful ListReservations request. The response includes the details of each offering that your account is eligible for. The response includes the following information for each offering: description, duration, outbound bandwidth, price, Amazon Resource Name (ARN), and the NextToken to use in a subsequent ListOfferings request.', 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => 'The tags for the resource.', 'refs' => [], ], 'ListedBridge' => [ 'base' => 'Displays details of the selected bridge.', 'refs' => [ '__listOfListedBridge$member' => NULL, ], ], 'ListedEntitlement' => [ 'base' => 'An entitlement that has been granted to you from other AWS accounts.', 'refs' => [ '__listOfListedEntitlement$member' => NULL, ], ], 'ListedFlow' => [ 'base' => 'Provides a summary of a flow, including its ARN, Availability Zone, and source type.', 'refs' => [ '__listOfListedFlow$member' => NULL, ], ], 'ListedGateway' => [ 'base' => 'Provides a summary of a gateway, including its name, ARN, and status.', 'refs' => [ '__listOfListedGateway$member' => NULL, ], ], 'ListedGatewayInstance' => [ 'base' => 'Provides a summary of an instance.', 'refs' => [ '__listOfListedGatewayInstance$member' => NULL, ], ], 'Maintenance' => [ 'base' => 'The maintenance setting of a flow', 'refs' => [ 'Flow$Maintenance' => NULL, 'ListedFlow$Maintenance' => NULL, ], ], 'MaintenanceDay' => [ 'base' => NULL, 'refs' => [ 'AddMaintenance$MaintenanceDay' => 'A day of a week when the maintenance will happen. Use Monday/Tuesday/Wednesday/Thursday/Friday/Saturday/Sunday.', 'Maintenance$MaintenanceDay' => 'A day of a week when the maintenance will happen. Use Monday/Tuesday/Wednesday/Thursday/Friday/Saturday/Sunday.', 'UpdateMaintenance$MaintenanceDay' => 'A day of a week when the maintenance will happen. use Monday/Tuesday/Wednesday/Thursday/Friday/Saturday/Sunday.', ], ], 'MediaStream' => [ 'base' => 'A single track or stream of media that contains video, audio, or ancillary data. After you add a media stream to a flow, you can associate it with sources and outputs on that flow, as long as they use the CDI protocol or the ST 2110 JPEG XS protocol. Each source or output can consist of one or many media streams.', 'refs' => [ 'UpdateFlowMediaStreamResponse$MediaStream' => 'The media stream that you updated.', '__listOfMediaStream$member' => NULL, ], ], 'MediaStreamAttributes' => [ 'base' => 'Attributes that are related to the media stream.', 'refs' => [ 'MediaStream$Attributes' => 'Attributes that are related to the media stream.', ], ], 'MediaStreamAttributesRequest' => [ 'base' => 'Attributes that are related to the media stream.', 'refs' => [ 'AddMediaStreamRequest$Attributes' => 'The attributes that you want to assign to the new media stream.', 'UpdateFlowMediaStreamRequest$Attributes' => 'The attributes that you want to assign to the media stream.', ], ], 'MediaStreamOutputConfiguration' => [ 'base' => 'The media stream that is associated with the output, and the parameters for that association.', 'refs' => [ '__listOfMediaStreamOutputConfiguration$member' => NULL, ], ], 'MediaStreamOutputConfigurationRequest' => [ 'base' => 'The media stream that you want to associate with the output, and the parameters for that association.', 'refs' => [ '__listOfMediaStreamOutputConfigurationRequest$member' => NULL, ], ], 'MediaStreamSourceConfiguration' => [ 'base' => 'The media stream that is associated with the source, and the parameters for that association.', 'refs' => [ '__listOfMediaStreamSourceConfiguration$member' => NULL, ], ], 'MediaStreamSourceConfigurationRequest' => [ 'base' => 'The definition of a media stream that you want to associate with the source.', 'refs' => [ '__listOfMediaStreamSourceConfigurationRequest$member' => NULL, ], ], 'MediaStreamType' => [ 'base' => NULL, 'refs' => [ 'AddMediaStreamRequest$MediaStreamType' => 'The type of media stream.', 'MediaStream$MediaStreamType' => 'The type of media stream.', 'UpdateFlowMediaStreamRequest$MediaStreamType' => 'The type of media stream.', ], ], 'MessageDetail' => [ 'base' => NULL, 'refs' => [ '__listOfMessageDetail$member' => NULL, ], ], 'Messages' => [ 'base' => 'Messages that provide the state of the flow.', 'refs' => [ 'DescribeFlowResponse$Messages' => NULL, ], ], 'NetworkInterfaceType' => [ 'base' => NULL, 'refs' => [ 'VpcInterface$NetworkInterfaceType' => 'The type of network interface.', 'VpcInterfaceRequest$NetworkInterfaceType' => 'The type of network interface. If this value is not included in the request, MediaConnect uses ENA as the networkInterfaceType.', ], ], 'NotFoundException' => [ 'base' => 'Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.', 'refs' => [], ], 'Offering' => [ 'base' => 'A savings plan that reserves a certain amount of outbound bandwidth usage at a discounted rate each month over a period of time.', 'refs' => [ 'DescribeOfferingResponse$Offering' => NULL, '__listOfOffering$member' => NULL, ], ], 'Output' => [ 'base' => 'The settings for an output.', 'refs' => [ 'UpdateFlowOutputResponse$Output' => 'The new settings of the output that you updated.', '__listOfOutput$member' => NULL, ], ], 'OutputStatus' => [ 'base' => NULL, 'refs' => [ 'AddOutputRequest$OutputStatus' => 'An indication of whether the new output should be enabled or disabled as soon as it is created. If you don\'t specify the outputStatus field in your request, MediaConnect sets it to ENABLED.', 'Output$OutputStatus' => 'An indication of whether the output is transmitting data or not.', 'UpdateFlowOutputRequest$OutputStatus' => 'An indication of whether the output should transmit data or not. If you don\'t specify the outputStatus field in your request, MediaConnect leaves the value unchanged.', ], ], 'PriceUnits' => [ 'base' => NULL, 'refs' => [ 'Offering$PriceUnits' => 'The unit of measurement that is used for billing. This value, in combination with pricePerUnit, makes up the rate.', 'Reservation$PriceUnits' => 'The unit of measurement that is used for billing. This value, in combination with pricePerUnit, makes up the rate. MediaConnect defines this value in the offering.', ], ], 'Protocol' => [ 'base' => NULL, 'refs' => [ 'AddBridgeNetworkOutputRequest$Protocol' => 'The network output protocol.', 'AddBridgeNetworkSourceRequest$Protocol' => 'The network source protocol.', 'AddOutputRequest$Protocol' => 'The protocol to use for the output.', 'BridgeNetworkOutput$Protocol' => 'The network output protocol.', 'BridgeNetworkSource$Protocol' => 'The network source protocol.', 'SetSourceRequest$Protocol' => 'The protocol that is used by the source.', 'Transport$Protocol' => 'The protocol that is used by the source or output.', 'UpdateBridgeNetworkOutputRequest$Protocol' => 'The network output protocol.', 'UpdateBridgeNetworkSourceRequest$Protocol' => 'The network source protocol.', 'UpdateFlowOutputRequest$Protocol' => 'The protocol to use for the output.', 'UpdateFlowSourceRequest$Protocol' => 'The protocol that is used by the source.', ], ], 'PurchaseOfferingRequest' => [ 'base' => 'Submits a request to purchase an offering, which creates a reservation in your AWS account. If you already have an active reservation, you can\'t purchase another offering.', 'refs' => [], ], 'PurchaseOfferingResponse' => [ 'base' => 'The result of a successful PurchaseOffering request.', 'refs' => [], ], 'Range' => [ 'base' => NULL, 'refs' => [ 'Fmtp$Range' => 'The encoding range of the video.', 'FmtpRequest$Range' => 'The encoding range of the video.', ], ], 'RemoveBridgeOutputResponse' => [ 'base' => 'The result of a successful RemoveBridgeOutput request.', 'refs' => [], ], 'RemoveBridgeSourceResponse' => [ 'base' => 'The result of a successful RemoveBridgeSource request.', 'refs' => [], ], 'RemoveFlowMediaStreamResponse' => [ 'base' => 'The result of a successful RemoveFlowMediaStream request.', 'refs' => [], ], 'RemoveFlowOutputResponse' => [ 'base' => 'The result of a successful RemoveFlowOutput request including the flow ARN and the output ARN that was removed.', 'refs' => [], ], 'RemoveFlowSourceResponse' => [ 'base' => 'The result of a successful RemoveFlowSource request including the flow ARN and the source ARN that was removed.', 'refs' => [], ], 'RemoveFlowVpcInterfaceResponse' => [ 'base' => 'The result of a successful RemoveFlowVpcInterface request including the flow ARN and the VPC interface name that was removed.', 'refs' => [], ], 'Reservation' => [ 'base' => 'A pricing agreement for a discounted rate for a specific outbound bandwidth that your MediaConnect account will use each month over a specific time period. The discounted rate in the reservation applies to outbound bandwidth for all flows from your account until your account reaches the amount of bandwidth in your reservation. If you use more outbound bandwidth than the agreed upon amount in a single month, the overage is charged at the on-demand rate.', 'refs' => [ 'DescribeReservationResponse$Reservation' => NULL, 'PurchaseOfferingResponse$Reservation' => NULL, '__listOfReservation$member' => NULL, ], ], 'ReservationState' => [ 'base' => NULL, 'refs' => [ 'Reservation$ReservationState' => 'The status of your reservation.', ], ], 'ResourceSpecification' => [ 'base' => 'A definition of what is being billed for, including the type and amount.', 'refs' => [ 'Offering$ResourceSpecification' => 'A definition of the amount of outbound bandwidth that you would be reserving if you purchase the offering.', 'Reservation$ResourceSpecification' => 'A definition of the amount of outbound bandwidth that you would be reserving if you purchase the offering. MediaConnect defines the values that make up the resourceSpecification in the offering.', ], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'ResourceSpecification$ResourceType' => 'The type of resource and the unit that is being billed for.', ], ], 'ResponseError' => [ 'base' => 'Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.', 'refs' => [], ], 'RevokeFlowEntitlementResponse' => [ 'base' => 'The result of a successful RevokeFlowEntitlement request. The response includes the ARN of the flow that was updated and the ARN of the entitlement that was revoked.', 'refs' => [], ], 'ScanMode' => [ 'base' => NULL, 'refs' => [ 'Fmtp$ScanMode' => 'The type of compression that was used to smooth the video’s appearance', 'FmtpRequest$ScanMode' => 'The type of compression that was used to smooth the video’s appearance.', ], ], 'ServiceUnavailableException' => [ 'base' => 'Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.', 'refs' => [], ], 'SetGatewayBridgeSourceRequest' => [ 'base' => 'The source configuration for cloud flows receiving a stream from a bridge.', 'refs' => [ 'SetSourceRequest$GatewayBridgeSource' => 'The source configuration for cloud flows receiving a stream from a bridge.', ], ], 'SetSourceRequest' => [ 'base' => 'The settings for the source of the flow.', 'refs' => [ 'CreateFlowRequest$Source' => NULL, '__listOfSetSourceRequest$member' => NULL, ], ], 'Source' => [ 'base' => 'The settings for the source of the flow.', 'refs' => [ 'Flow$Source' => NULL, 'UpdateFlowSourceResponse$Source' => 'The settings for the source of the flow.', '__listOfSource$member' => NULL, ], ], 'SourcePriority' => [ 'base' => 'The priority you want to assign to a source. You can have a primary stream and a backup stream or two equally prioritized streams.', 'refs' => [ 'FailoverConfig$SourcePriority' => 'The priority you want to assign to a source. You can have a primary stream and a backup stream or two equally prioritized streams.', 'UpdateFailoverConfig$SourcePriority' => 'The priority you want to assign to a source. You can have a primary stream and a backup stream or two equally prioritized streams.', ], ], 'SourceType' => [ 'base' => NULL, 'refs' => [ 'ListedFlow$SourceType' => 'The type of source. This value is either owned (originated somewhere other than an AWS Elemental MediaConnect flow owned by another AWS account) or entitled (originated at an AWS Elemental MediaConnect flow owned by another AWS account).', ], ], 'StartFlowResponse' => [ 'base' => 'The result of a successful StartFlow request.', 'refs' => [], ], 'State' => [ 'base' => NULL, 'refs' => [ 'FailoverConfig$State' => NULL, 'UpdateFailoverConfig$State' => NULL, ], ], 'Status' => [ 'base' => NULL, 'refs' => [ 'DeleteFlowResponse$Status' => 'The status of the flow when the DeleteFlow process begins.', 'Flow$Status' => 'The current status of the flow.', 'ListedFlow$Status' => 'The current status of the flow.', 'StartFlowResponse$Status' => 'The status of the flow when the StartFlow process begins.', 'StopFlowResponse$Status' => 'The status of the flow when the StopFlow process begins.', ], ], 'StopFlowResponse' => [ 'base' => 'The result of a successful StopFlow request.', 'refs' => [], ], 'TagResourceRequest' => [ 'base' => 'The tags to add to the resource. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.', 'refs' => [], ], 'Tcs' => [ 'base' => NULL, 'refs' => [ 'Fmtp$Tcs' => 'The transfer characteristic system (TCS) that is used in the video.', 'FmtpRequest$Tcs' => 'The transfer characteristic system (TCS) that is used in the video.', ], ], 'TooManyRequestsException' => [ 'base' => 'Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.', 'refs' => [], ], 'Transport' => [ 'base' => 'Attributes related to the transport stream that are used in a source or output.', 'refs' => [ 'Output$Transport' => 'Attributes related to the transport stream that are used in the output.', 'Source$Transport' => 'Attributes related to the transport stream that are used in the source.', ], ], 'TransportMediaInfo' => [ 'base' => 'The metadata of the transport stream in the current flow\'s source.', 'refs' => [ 'DescribeFlowSourceMetadataResponse$TransportMediaInfo' => NULL, ], ], 'TransportStream' => [ 'base' => 'The metadata of an elementary transport stream.', 'refs' => [ '__listOfTransportStream$member' => NULL, ], ], 'TransportStreamProgram' => [ 'base' => 'The metadata of a single transport stream program.', 'refs' => [ '__listOfTransportStreamProgram$member' => NULL, ], ], 'UpdateBridgeFlowSourceRequest' => [ 'base' => 'Update the flow source of the bridge.', 'refs' => [ 'UpdateBridgeSourceRequest$FlowSource' => NULL, ], ], 'UpdateBridgeNetworkOutputRequest' => [ 'base' => 'Update an existing network output.', 'refs' => [ 'UpdateBridgeOutputRequest$NetworkOutput' => NULL, ], ], 'UpdateBridgeNetworkSourceRequest' => [ 'base' => 'Update the network source of the bridge.', 'refs' => [ 'UpdateBridgeSourceRequest$NetworkSource' => NULL, ], ], 'UpdateBridgeOutputRequest' => [ 'base' => 'Update an existing bridge output.', 'refs' => [], ], 'UpdateBridgeOutputResponse' => [ 'base' => 'The result of a successful UpdateBridgeOutput request.', 'refs' => [], ], 'UpdateBridgeRequest' => [ 'base' => 'Update an existing bridge.', 'refs' => [], ], 'UpdateBridgeResponse' => [ 'base' => 'The bridge has been successfully updated.', 'refs' => [], ], 'UpdateBridgeSourceRequest' => [ 'base' => 'Update the bridge source.', 'refs' => [], ], 'UpdateBridgeSourceResponse' => [ 'base' => 'The result of a successful UpdateBridgeSource request.', 'refs' => [], ], 'UpdateBridgeStateRequest' => [ 'base' => 'Update the state of a bridge. ACTIVE or STANDBY.', 'refs' => [], ], 'UpdateBridgeStateResponse' => [ 'base' => 'The bridge state has been updated.', 'refs' => [], ], 'UpdateEgressGatewayBridgeRequest' => [ 'base' => NULL, 'refs' => [ 'UpdateBridgeRequest$EgressGatewayBridge' => NULL, ], ], 'UpdateEncryption' => [ 'base' => 'Information about the encryption of the flow.', 'refs' => [ 'UpdateFlowEntitlementRequest$Encryption' => 'The type of encryption that will be used on the output associated with this entitlement. Allowable encryption types: static-key, speke.', 'UpdateFlowOutputRequest$Encryption' => 'The type of key used for the encryption. If no keyType is provided, the service will use the default setting (static-key). Allowable encryption types: static-key.', 'UpdateFlowSourceRequest$Decryption' => 'The type of encryption used on the content ingested from this source. Allowable encryption types: static-key.', ], ], 'UpdateFailoverConfig' => [ 'base' => 'The settings for source failover.', 'refs' => [ 'UpdateBridgeRequest$SourceFailoverConfig' => NULL, 'UpdateFlowRequest$SourceFailoverConfig' => NULL, ], ], 'UpdateFlowEntitlementRequest' => [ 'base' => 'The updates that you want to make to a specific entitlement.', 'refs' => [], ], 'UpdateFlowEntitlementResponse' => [ 'base' => 'The result of a successful UpdateFlowEntitlement request. The response includes the ARN of the flow that was updated and the updated entitlement configuration.', 'refs' => [], ], 'UpdateFlowMediaStreamRequest' => [ 'base' => 'Update a media stream on a flow.', 'refs' => [], ], 'UpdateFlowMediaStreamResponse' => [ 'base' => 'The result of a successful UpdateFlowMediaStream request.', 'refs' => [], ], 'UpdateFlowOutputRequest' => [ 'base' => 'The updates that you want to make to an existing output of an existing flow.', 'refs' => [], ], 'UpdateFlowOutputResponse' => [ 'base' => 'The result of a successful UpdateFlowOutput request including the flow ARN and the updated output.', 'refs' => [], ], 'UpdateFlowRequest' => [ 'base' => 'Updates an existing flow.', 'refs' => [], ], 'UpdateFlowResponse' => [ 'base' => 'The result of a successful UpdateFlow request. Updates an existing flow.', 'refs' => [], ], 'UpdateFlowSourceRequest' => [ 'base' => 'The updates that you want to make to an existing source of an existing flow.', 'refs' => [], ], 'UpdateFlowSourceResponse' => [ 'base' => 'The result of a successful UpdateFlowSource request. The response includes the ARN of the flow that was updated and the updated source configuration.', 'refs' => [], ], 'UpdateGatewayBridgeSourceRequest' => [ 'base' => 'The source configuration for cloud flows receiving a stream from a bridge.', 'refs' => [ 'UpdateFlowSourceRequest$GatewayBridgeSource' => 'The source configuration for cloud flows receiving a stream from a bridge.', ], ], 'UpdateGatewayInstanceRequest' => [ 'base' => 'The state update that you want to make to an existing gateway instance.', 'refs' => [], ], 'UpdateGatewayInstanceResponse' => [ 'base' => 'The result of a successful UpdateGatewayInstance request.', 'refs' => [], ], 'UpdateIngressGatewayBridgeRequest' => [ 'base' => NULL, 'refs' => [ 'UpdateBridgeRequest$IngressGatewayBridge' => NULL, ], ], 'UpdateMaintenance' => [ 'base' => 'Update maintenance setting for a flow', 'refs' => [ 'UpdateFlowRequest$Maintenance' => NULL, ], ], 'VpcInterface' => [ 'base' => 'The settings for a VPC Source.', 'refs' => [ '__listOfVpcInterface$member' => NULL, ], ], 'VpcInterfaceAttachment' => [ 'base' => 'The settings for attaching a VPC interface to an resource.', 'refs' => [ 'AddBridgeFlowSourceRequest$FlowVpcInterfaceAttachment' => 'The name of the VPC interface attachment to use for this source.', 'AddOutputRequest$VpcInterfaceAttachment' => 'The name of the VPC interface attachment to use for this output.', 'BridgeFlowSource$FlowVpcInterfaceAttachment' => 'The name of the VPC interface attachment to use for this source.', 'GatewayBridgeSource$VpcInterfaceAttachment' => 'The name of the VPC interface attachment to use for this bridge source.', 'Output$VpcInterfaceAttachment' => 'The name of the VPC interface attachment to use for this output.', 'SetGatewayBridgeSourceRequest$VpcInterfaceAttachment' => 'The name of the VPC interface attachment to use for this bridge source.', 'UpdateBridgeFlowSourceRequest$FlowVpcInterfaceAttachment' => 'The name of the VPC interface attachment to use for this source.', 'UpdateFlowOutputRequest$VpcInterfaceAttachment' => 'The name of the VPC interface attachment to use for this output.', 'UpdateGatewayBridgeSourceRequest$VpcInterfaceAttachment' => 'The name of the VPC interface attachment to use for this bridge source.', ], ], 'VpcInterfaceRequest' => [ 'base' => 'Desired VPC Interface for a Flow', 'refs' => [ '__listOfVpcInterfaceRequest$member' => NULL, ], ], '__boolean' => [ 'base' => NULL, 'refs' => [], ], '__double' => [ 'base' => NULL, 'refs' => [ 'EncodingParameters$CompressionFactor' => 'A value that is used to calculate compression for an output. The bitrate of the output is calculated as follows: Output bitrate = (1 / compressionFactor) * (source bitrate) This property only applies to outputs that use the ST 2110 JPEG XS protocol, with a flow source that uses the CDI protocol. Valid values are floating point numbers in the range of 3.0 to 10.0, inclusive.', 'EncodingParametersRequest$CompressionFactor' => 'A value that is used to calculate compression for an output. The bitrate of the output is calculated as follows: Output bitrate = (1 / compressionFactor) * (source bitrate) This property only applies to outputs that use the ST 2110 JPEG XS protocol, with a flow source that uses the CDI protocol. Valid values are floating point numbers in the range of 3.0 to 10.0, inclusive.', ], ], '__integer' => [ 'base' => NULL, 'refs' => [ 'AddBridgeNetworkOutputRequest$Port' => 'The network output port.', 'AddBridgeNetworkOutputRequest$Ttl' => 'The network output TTL.', 'AddBridgeNetworkSourceRequest$Port' => 'The network source port.', 'AddEgressGatewayBridgeRequest$MaxBitrate' => 'The maximum expected bitrate (in bps).', 'AddIngressGatewayBridgeRequest$MaxBitrate' => 'The maximum expected bitrate (in bps).', 'AddIngressGatewayBridgeRequest$MaxOutputs' => 'The maximum number of expected outputs.', 'AddMediaStreamRequest$ClockRate' => 'The sample rate (in Hz) for the stream. If the media stream type is video or ancillary data, set this value to 90000. If the media stream type is audio, set this value to either 48000 or 96000.', 'AddMediaStreamRequest$MediaStreamId' => 'A unique identifier for the media stream.', 'AddOutputRequest$MaxLatency' => 'The maximum latency in milliseconds. This parameter applies only to RIST-based, Zixi-based, and Fujitsu-based streams.', 'AddOutputRequest$MinLatency' => 'The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.', 'AddOutputRequest$Port' => 'The port to use when content is distributed to this output.', 'AddOutputRequest$SenderControlPort' => 'The port that the flow uses to send outbound requests to initiate connection with the sender.', 'AddOutputRequest$SmoothingLatency' => 'The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.', 'BridgeNetworkOutput$Port' => 'The network output port.', 'BridgeNetworkOutput$Ttl' => 'The network output TTL.', 'BridgeNetworkSource$Port' => 'The network source port.', 'DestinationConfiguration$DestinationPort' => 'The port to use when the content of the media stream is distributed to the output.', 'DestinationConfigurationRequest$DestinationPort' => 'The port that you want MediaConnect to use when it distributes the media stream to the output.', 'EgressGatewayBridge$MaxBitrate' => 'The maximum expected bitrate (in bps) of the egress bridge.', 'Entitlement$DataTransferSubscriberFeePercent' => 'Percentage from 0-100 of the data transfer cost to be billed to the subscriber.', 'FailoverConfig$RecoveryWindow' => 'Search window time to look for dash-7 packets', 'FrameResolution$FrameHeight' => 'The number of pixels in the height of the video frame.', 'FrameResolution$FrameWidth' => 'The number of pixels in the width of the video frame.', 'GatewayInstance$RunningBridgeCount' => 'The running bridge count.', 'GrantEntitlementRequest$DataTransferSubscriberFeePercent' => 'Percentage from 0-100 of the data transfer cost to be billed to the subscriber.', 'IngressGatewayBridge$MaxBitrate' => 'The maximum expected bitrate (in bps) of the ingress bridge.', 'IngressGatewayBridge$MaxOutputs' => 'The maximum number of outputs on the ingress bridge.', 'InputConfiguration$InputPort' => 'The port that the flow listens on for an incoming media stream.', 'InputConfigurationRequest$InputPort' => 'The port that you want the flow to listen on for an incoming media stream.', 'ListedEntitlement$DataTransferSubscriberFeePercent' => 'Percentage from 0-100 of the data transfer cost to be billed to the subscriber.', 'MediaStream$ClockRate' => 'The sample rate for the stream. This value is measured in Hz.', 'MediaStream$Fmt' => 'The format type number (sometimes referred to as RTP payload type) of the media stream. MediaConnect assigns this value to the media stream. For ST 2110 JPEG XS outputs, you need to provide this value to the receiver.', 'MediaStream$MediaStreamId' => 'A unique identifier for the media stream.', 'Offering$Duration' => 'The length of time that your reservation would be active.', 'Output$DataTransferSubscriberFeePercent' => 'Percentage from 0-100 of the data transfer cost to be billed to the subscriber.', 'Output$Port' => 'The port to use when content is distributed to this output.', 'Reservation$Duration' => 'The length of time that this reservation is active. MediaConnect defines this value in the offering.', 'ResourceSpecification$ReservedBitrate' => 'The amount of outbound bandwidth that is discounted in the offering.', 'SetSourceRequest$IngestPort' => 'The port that the flow will be listening on for incoming content.', 'SetSourceRequest$MaxBitrate' => 'The smoothing max bitrate (in bps) for RIST, RTP, and RTP-FEC streams.', 'SetSourceRequest$MaxLatency' => 'The maximum latency in milliseconds. This parameter applies only to RIST-based, Zixi-based, and Fujitsu-based streams.', 'SetSourceRequest$MaxSyncBuffer' => 'The size of the buffer (in milliseconds) to use to sync incoming source data.', 'SetSourceRequest$MinLatency' => 'The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.', 'SetSourceRequest$SenderControlPort' => 'The port that the flow uses to send outbound requests to initiate connection with the sender.', 'SetSourceRequest$SourceListenerPort' => 'Source port for SRT-caller protocol.', 'Source$DataTransferSubscriberFeePercent' => 'Percentage from 0-100 of the data transfer cost to be billed to the subscriber.', 'Source$IngestPort' => 'The port that the flow will be listening on for incoming content.', 'Source$SenderControlPort' => 'The port that the flow uses to send outbound requests to initiate connection with the sender.', 'Transport$MaxBitrate' => 'The smoothing max bitrate (in bps) for RIST, RTP, and RTP-FEC streams.', 'Transport$MaxLatency' => 'The maximum latency in milliseconds. This parameter applies only to RIST-based, Zixi-based, and Fujitsu-based streams.', 'Transport$MaxSyncBuffer' => 'The size of the buffer (in milliseconds) to use to sync incoming source data.', 'Transport$MinLatency' => 'The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.', 'Transport$SenderControlPort' => 'The port that the flow uses to send outbound requests to initiate connection with the sender.', 'Transport$SmoothingLatency' => 'The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.', 'Transport$SourceListenerPort' => 'Source port for SRT-caller protocol.', 'TransportStream$Channels' => 'The number of channels in the audio stream.', 'TransportStream$Pid' => 'The Packet ID (PID) as it is reported in the Program Map Table.', 'TransportStream$SampleRate' => 'The sample rate used by the audio stream.', 'TransportStream$SampleSize' => 'The sample bit size used by the audio stream.', 'TransportStreamProgram$PcrPid' => 'The Program Clock Reference (PCR) Packet ID (PID) as it is reported in the Program Association Table.', 'TransportStreamProgram$ProgramNumber' => 'The program number as it is reported in the Program Association Table.', 'TransportStreamProgram$ProgramPid' => 'The program Packet ID (PID) as it is reported in the Program Association Table.', 'UpdateBridgeNetworkOutputRequest$Port' => 'The network output port.', 'UpdateBridgeNetworkOutputRequest$Ttl' => 'The network output TTL.', 'UpdateBridgeNetworkSourceRequest$Port' => 'The network source port.', 'UpdateEgressGatewayBridgeRequest$MaxBitrate' => 'Update an existing egress-type bridge.', 'UpdateFailoverConfig$RecoveryWindow' => 'Recovery window time to look for dash-7 packets', 'UpdateFlowMediaStreamRequest$ClockRate' => 'The sample rate (in Hz) for the stream. If the media stream type is video or ancillary data, set this value to 90000. If the media stream type is audio, set this value to either 48000 or 96000.', 'UpdateFlowOutputRequest$MaxLatency' => 'The maximum latency in milliseconds. This parameter applies only to RIST-based, Zixi-based, and Fujitsu-based streams.', 'UpdateFlowOutputRequest$MinLatency' => 'The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.', 'UpdateFlowOutputRequest$Port' => 'The port to use when content is distributed to this output.', 'UpdateFlowOutputRequest$SenderControlPort' => 'The port that the flow uses to send outbound requests to initiate connection with the sender.', 'UpdateFlowOutputRequest$SmoothingLatency' => 'The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.', 'UpdateFlowSourceRequest$IngestPort' => 'The port that the flow will be listening on for incoming content.', 'UpdateFlowSourceRequest$MaxBitrate' => 'The smoothing max bitrate (in bps) for RIST, RTP, and RTP-FEC streams.', 'UpdateFlowSourceRequest$MaxLatency' => 'The maximum latency in milliseconds. This parameter applies only to RIST-based, Zixi-based, and Fujitsu-based streams.', 'UpdateFlowSourceRequest$MaxSyncBuffer' => 'The size of the buffer (in milliseconds) to use to sync incoming source data.', 'UpdateFlowSourceRequest$MinLatency' => 'The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.', 'UpdateFlowSourceRequest$SenderControlPort' => 'The port that the flow uses to send outbound requests to initiate connection with the sender.', 'UpdateFlowSourceRequest$SourceListenerPort' => 'Source port for SRT-caller protocol.', 'UpdateIngressGatewayBridgeRequest$MaxBitrate' => 'The maximum expected bitrate (in bps).', 'UpdateIngressGatewayBridgeRequest$MaxOutputs' => 'The maximum number of expected outputs.', '__listOf__integer$member' => NULL, ], ], '__listOfAddBridgeOutputRequest' => [ 'base' => NULL, 'refs' => [ 'AddBridgeOutputsRequest$Outputs' => 'The outputs that you want to add to this bridge.', 'CreateBridgeRequest$Outputs' => 'The outputs that you want to add to this bridge.', ], ], '__listOfAddBridgeSourceRequest' => [ 'base' => NULL, 'refs' => [ 'AddBridgeSourcesRequest$Sources' => 'The sources that you want to add to this bridge.', 'CreateBridgeRequest$Sources' => 'The sources that you want to add to this bridge.', ], ], '__listOfAddMediaStreamRequest' => [ 'base' => NULL, 'refs' => [ 'AddFlowMediaStreamsRequest$MediaStreams' => 'The media streams that you want to add to the flow.', 'CreateFlowRequest$MediaStreams' => 'The media streams that you want to add to the flow. You can associate these media streams with sources and outputs on the flow.', ], ], '__listOfAddOutputRequest' => [ 'base' => NULL, 'refs' => [ 'AddFlowOutputsRequest$Outputs' => 'A list of outputs that you want to add.', 'CreateFlowRequest$Outputs' => 'The outputs that you want to add to this flow.', ], ], '__listOfBridgeOutput' => [ 'base' => NULL, 'refs' => [ 'AddBridgeOutputsResponse$Outputs' => 'The outputs that you added to this bridge.', 'Bridge$Outputs' => 'The outputs on this bridge.', ], ], '__listOfBridgeSource' => [ 'base' => NULL, 'refs' => [ 'AddBridgeSourcesResponse$Sources' => 'The sources that you added to this bridge.', 'Bridge$Sources' => 'The sources on this bridge.', ], ], '__listOfDestinationConfiguration' => [ 'base' => NULL, 'refs' => [ 'MediaStreamOutputConfiguration$DestinationConfigurations' => 'The transport parameters that are associated with each outbound media stream.', ], ], '__listOfDestinationConfigurationRequest' => [ 'base' => NULL, 'refs' => [ 'MediaStreamOutputConfigurationRequest$DestinationConfigurations' => 'The transport parameters that you want to associate with the media stream.', ], ], '__listOfEntitlement' => [ 'base' => NULL, 'refs' => [ 'Flow$Entitlements' => 'The entitlements in this flow.', 'GrantFlowEntitlementsResponse$Entitlements' => 'The entitlements that were just granted.', ], ], '__listOfGatewayNetwork' => [ 'base' => NULL, 'refs' => [ 'CreateGatewayRequest$Networks' => 'The list of networks that you want to add.', 'Gateway$Networks' => 'The list of networks in the gateway.', ], ], '__listOfGrantEntitlementRequest' => [ 'base' => NULL, 'refs' => [ 'CreateFlowRequest$Entitlements' => 'The entitlements that you want to grant on a flow.', 'GrantFlowEntitlementsRequest$Entitlements' => 'The list of entitlements that you want to grant.', ], ], '__listOfInputConfiguration' => [ 'base' => NULL, 'refs' => [ 'MediaStreamSourceConfiguration$InputConfigurations' => 'The transport parameters that are associated with an incoming media stream.', ], ], '__listOfInputConfigurationRequest' => [ 'base' => NULL, 'refs' => [ 'MediaStreamSourceConfigurationRequest$InputConfigurations' => 'The transport parameters that you want to associate with the media stream.', ], ], '__listOfListedBridge' => [ 'base' => NULL, 'refs' => [ 'ListBridgesResponse$Bridges' => 'A list of bridge summaries.', ], ], '__listOfListedEntitlement' => [ 'base' => NULL, 'refs' => [ 'ListEntitlementsResponse$Entitlements' => 'A list of entitlements that have been granted to you from other AWS accounts.', ], ], '__listOfListedFlow' => [ 'base' => NULL, 'refs' => [ 'ListFlowsResponse$Flows' => 'A list of flow summaries.', ], ], '__listOfListedGateway' => [ 'base' => NULL, 'refs' => [ 'ListGatewaysResponse$Gateways' => 'A list of gateway summaries.', ], ], '__listOfListedGatewayInstance' => [ 'base' => NULL, 'refs' => [ 'ListGatewayInstancesResponse$Instances' => 'A list of instance summaries.', ], ], '__listOfMediaStream' => [ 'base' => NULL, 'refs' => [ 'AddFlowMediaStreamsResponse$MediaStreams' => 'The media streams that you added to the flow.', 'Flow$MediaStreams' => 'The media streams that are associated with the flow. After you associate a media stream with a source, you can also associate it with outputs on the flow.', ], ], '__listOfMediaStreamOutputConfiguration' => [ 'base' => NULL, 'refs' => [ 'Output$MediaStreamOutputConfigurations' => 'The configuration for each media stream that is associated with the output.', ], ], '__listOfMediaStreamOutputConfigurationRequest' => [ 'base' => NULL, 'refs' => [ 'AddOutputRequest$MediaStreamOutputConfigurations' => 'The media streams that are associated with the output, and the parameters for those associations.', 'UpdateFlowOutputRequest$MediaStreamOutputConfigurations' => 'The media streams that are associated with the output, and the parameters for those associations.', ], ], '__listOfMediaStreamSourceConfiguration' => [ 'base' => NULL, 'refs' => [ 'Source$MediaStreamSourceConfigurations' => 'The media streams that are associated with the source, and the parameters for those associations.', ], ], '__listOfMediaStreamSourceConfigurationRequest' => [ 'base' => NULL, 'refs' => [ 'SetSourceRequest$MediaStreamSourceConfigurations' => 'The media streams that are associated with the source, and the parameters for those associations.', 'UpdateFlowSourceRequest$MediaStreamSourceConfigurations' => 'The media streams that are associated with the source, and the parameters for those associations.', ], ], '__listOfMessageDetail' => [ 'base' => NULL, 'refs' => [ 'Bridge$BridgeMessages' => NULL, 'DescribeFlowSourceMetadataResponse$Messages' => 'Provides a status code and message regarding issues found with the flow source metadata.', 'Gateway$GatewayMessages' => NULL, 'GatewayInstance$InstanceMessages' => NULL, ], ], '__listOfOffering' => [ 'base' => NULL, 'refs' => [ 'ListOfferingsResponse$Offerings' => 'A list of offerings that are available to this account in the current AWS Region.', ], ], '__listOfOutput' => [ 'base' => NULL, 'refs' => [ 'AddFlowOutputsResponse$Outputs' => 'The details of the newly added outputs.', 'Flow$Outputs' => 'The outputs in this flow.', ], ], '__listOfReservation' => [ 'base' => NULL, 'refs' => [ 'ListReservationsResponse$Reservations' => 'A list of all reservations that have been purchased by this account in the current AWS Region.', ], ], '__listOfSetSourceRequest' => [ 'base' => NULL, 'refs' => [ 'AddFlowSourcesRequest$Sources' => 'A list of sources that you want to add.', 'CreateFlowRequest$Sources' => NULL, ], ], '__listOfSource' => [ 'base' => NULL, 'refs' => [ 'AddFlowSourcesResponse$Sources' => 'The details of the newly added sources.', 'Flow$Sources' => NULL, ], ], '__listOfTransportStream' => [ 'base' => NULL, 'refs' => [ 'TransportStreamProgram$Streams' => 'The list of elementary transport streams in the program. The list includes video, audio, and data streams.', ], ], '__listOfTransportStreamProgram' => [ 'base' => NULL, 'refs' => [ 'TransportMediaInfo$Programs' => 'The list of transport stream programs in the current flow\'s source.', ], ], '__listOfVpcInterface' => [ 'base' => NULL, 'refs' => [ 'AddFlowVpcInterfacesResponse$VpcInterfaces' => 'The details of the newly added VPC interfaces.', 'Flow$VpcInterfaces' => 'The VPC Interfaces for this flow.', ], ], '__listOfVpcInterfaceRequest' => [ 'base' => NULL, 'refs' => [ 'AddFlowVpcInterfacesRequest$VpcInterfaces' => 'A list of VPC interfaces that you want to add.', 'CreateFlowRequest$VpcInterfaces' => 'The VPC interfaces you want on the flow.', ], ], '__listOf__integer' => [ 'base' => NULL, 'refs' => [ 'Output$BridgePorts' => 'The bridge output ports currently in use.', ], ], '__listOf__string' => [ 'base' => NULL, 'refs' => [ 'AddOutputRequest$CidrAllowList' => 'The range of IP addresses that should be allowed to initiate output requests to this flow. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.', 'CreateGatewayRequest$EgressCidrBlocks' => 'The range of IP addresses that are allowed to contribute content or initiate output requests for flows communicating with this gateway. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.', 'Entitlement$Subscribers' => 'The AWS account IDs that you want to share your content with. The receiving accounts (subscribers) will be allowed to create their own flow using your content as the source.', 'Gateway$EgressCidrBlocks' => 'The range of IP addresses that contribute content or initiate output requests for flows communicating with this gateway. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.', 'GrantEntitlementRequest$Subscribers' => 'The AWS account IDs that you want to share your content with. The receiving accounts (subscribers) will be allowed to create their own flows using your content as the source.', 'Messages$Errors' => 'A list of errors that might have been generated from processes on this flow.', 'RemoveFlowVpcInterfaceResponse$NonDeletedNetworkInterfaceIds' => 'IDs of network interfaces associated with the removed VPC interface that Media Connect was unable to remove.', 'Transport$CidrAllowList' => 'The range of IP addresses that should be allowed to initiate output requests to this flow. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.', 'UpdateFlowEntitlementRequest$Subscribers' => 'The AWS account IDs that you want to share your content with. The receiving accounts (subscribers) will be allowed to create their own flow using your content as the source.', 'UpdateFlowOutputRequest$CidrAllowList' => 'The range of IP addresses that should be allowed to initiate output requests to this flow. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.', 'VpcInterface$NetworkInterfaceIds' => 'IDs of the network interfaces created in customer\'s account by MediaConnect.', 'VpcInterface$SecurityGroupIds' => 'Security Group IDs to be used on ENI.', 'VpcInterfaceRequest$SecurityGroupIds' => 'Security Group IDs to be used on ENI.', ], ], '__mapOf__string' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceResponse$Tags' => 'A map from tag keys to values. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.', 'TagResourceRequest$Tags' => 'A map from tag keys to values. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.', ], ], '__string' => [ 'base' => NULL, 'refs' => [ 'AddBridgeFlowSourceRequest$FlowArn' => 'The Amazon Resource Number (ARN) of the cloud flow to use as a source of this bridge.', 'AddBridgeFlowSourceRequest$Name' => 'The name of the flow source. This name is used to reference the source and must be unique among sources in this bridge.', 'AddBridgeNetworkOutputRequest$IpAddress' => 'The network output IP Address.', 'AddBridgeNetworkOutputRequest$Name' => 'The network output name. This name is used to reference the output and must be unique among outputs in this bridge.', 'AddBridgeNetworkOutputRequest$NetworkName' => 'The network output\'s gateway network name.', 'AddBridgeNetworkSourceRequest$MulticastIp' => 'The network source multicast IP.', 'AddBridgeNetworkSourceRequest$Name' => 'The name of the network source. This name is used to reference the source and must be unique among sources in this bridge.', 'AddBridgeNetworkSourceRequest$NetworkName' => 'The network source\'s gateway network name.', 'AddBridgeOutputsResponse$BridgeArn' => 'The Amazon Resource Number (ARN) of the bridge.', 'AddBridgeSourcesResponse$BridgeArn' => 'The Amazon Resource Number (ARN) of the bridge.', 'AddFlowMediaStreamsResponse$FlowArn' => 'The ARN of the flow that you added media streams to.', 'AddFlowOutputsResponse$FlowArn' => 'The ARN of the flow that these outputs were added to.', 'AddFlowSourcesResponse$FlowArn' => 'The ARN of the flow that these sources were added to.', 'AddFlowVpcInterfacesResponse$FlowArn' => 'The ARN of the flow that these VPC interfaces were added to.', 'AddMaintenance$MaintenanceStartHour' => 'UTC time when the maintenance will happen. Use 24-hour HH:MM format. Minutes must be 00. Example: 13:00. The default value is 02:00.', 'AddMediaStreamRequest$Description' => 'A description that can help you quickly identify what your media stream is used for.', 'AddMediaStreamRequest$MediaStreamName' => 'A name that helps you distinguish one media stream from another.', 'AddMediaStreamRequest$VideoFormat' => 'The resolution of the video.', 'AddOutputRequest$Description' => 'A description of the output. This description appears only on the AWS Elemental MediaConnect console and will not be seen by the end user.', 'AddOutputRequest$Destination' => 'The IP address from which video will be sent to output destinations.', 'AddOutputRequest$Name' => 'The name of the output. This value must be unique within the current flow.', 'AddOutputRequest$RemoteId' => 'The remote ID for the Zixi-pull output stream.', 'AddOutputRequest$StreamId' => 'The stream ID that you want to use for this transport. This parameter applies only to Zixi and SRT caller-based streams.', 'Bridge$BridgeArn' => 'The Amazon Resource Number (ARN) of the bridge.', 'Bridge$Name' => 'The name of the bridge.', 'Bridge$PlacementArn' => 'The placement Amazon Resource Number (ARN) of the bridge.', 'BridgeFlowOutput$FlowArn' => 'The Amazon Resource Number (ARN) of the cloud flow.', 'BridgeFlowOutput$FlowSourceArn' => 'The Amazon Resource Number (ARN) of the flow source.', 'BridgeFlowOutput$Name' => 'The name of the bridge\'s output.', 'BridgeFlowSource$FlowArn' => 'The ARN of the cloud flow used as a source of this bridge.', 'BridgeFlowSource$Name' => 'The name of the flow source.', 'BridgeFlowSource$OutputArn' => 'The Amazon Resource Number (ARN) of the output.', 'BridgeNetworkOutput$IpAddress' => 'The network output IP Address.', 'BridgeNetworkOutput$Name' => 'The network output name.', 'BridgeNetworkOutput$NetworkName' => 'The network output\'s gateway network name.', 'BridgeNetworkSource$MulticastIp' => 'The network source multicast IP.', 'BridgeNetworkSource$Name' => 'The name of the network source.', 'BridgeNetworkSource$NetworkName' => 'The network source\'s gateway network name.', 'CreateBridgeRequest$Name' => 'The name of the bridge. This name can not be modified after the bridge is created.', 'CreateBridgeRequest$PlacementArn' => 'The bridge placement Amazon Resource Number (ARN).', 'CreateFlowRequest$AvailabilityZone' => 'The Availability Zone that you want to create the flow in. These options are limited to the Availability Zones within the current AWS Region.', 'CreateFlowRequest$Name' => 'The name of the flow.', 'CreateGatewayRequest$Name' => 'The name of the gateway. This name can not be modified after the gateway is created.', 'DeleteBridgeResponse$BridgeArn' => 'The Amazon Resource Number (ARN) of the deleted bridge.', 'DeleteFlowResponse$FlowArn' => 'The ARN of the flow that was deleted.', 'DeleteGatewayResponse$GatewayArn' => 'The Amazon Resource Name (ARN) of the gateway that was deleted.', 'DeregisterGatewayInstanceResponse$GatewayInstanceArn' => 'The Amazon Resource Name (ARN) of the instance.', 'DescribeFlowSourceMetadataResponse$FlowArn' => 'The ARN of the flow that DescribeFlowSourceMetadata was performed on.', 'DestinationConfiguration$DestinationIp' => 'The IP address where contents of the media stream will be sent.', 'DestinationConfiguration$OutboundIp' => 'The IP address that the receiver requires in order to establish a connection with the flow. This value is represented by the elastic network interface IP address of the VPC. This field applies only to outputs that use the CDI or ST 2110 JPEG XS protocol.', 'DestinationConfigurationRequest$DestinationIp' => 'The IP address where you want MediaConnect to send contents of the media stream.', 'EgressGatewayBridge$InstanceId' => 'The ID of the instance running this bridge.', 'Encryption$ConstantInitializationVector' => 'A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content. This parameter is not valid for static key encryption.', 'Encryption$DeviceId' => 'The value of one of the devices that you configured with your digital rights management (DRM) platform key provider. This parameter is required for SPEKE encryption and is not valid for static key encryption.', 'Encryption$Region' => 'The AWS Region that the API Gateway proxy endpoint was created in. This parameter is required for SPEKE encryption and is not valid for static key encryption.', 'Encryption$ResourceId' => 'An identifier for the content. The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.', 'Encryption$RoleArn' => 'The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).', 'Encryption$SecretArn' => 'The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.', 'Encryption$Url' => 'The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is required for SPEKE encryption and is not valid for static key encryption.', 'Entitlement$Description' => 'A description of the entitlement.', 'Entitlement$EntitlementArn' => 'The ARN of the entitlement.', 'Entitlement$Name' => 'The name of the entitlement.', 'Flow$AvailabilityZone' => 'The Availability Zone that you want to create the flow in. These options are limited to the Availability Zones within the current AWS.', 'Flow$Description' => 'A description of the flow. This value is not used or seen outside of the current AWS Elemental MediaConnect account.', 'Flow$EgressIp' => 'The IP address from which video will be sent to output destinations.', 'Flow$FlowArn' => 'The Amazon Resource Name (ARN) of the flow.', 'Flow$Name' => 'The name of the flow.', 'Fmtp$ChannelOrder' => 'The format of the audio channel.', 'Fmtp$ExactFramerate' => 'The frame rate for the video stream, in frames/second. For example: 60000/1001. If you specify a whole number, MediaConnect uses a ratio of N/1. For example, if you specify 60, MediaConnect uses 60/1 as the exactFramerate.', 'Fmtp$Par' => 'The pixel aspect ratio (PAR) of the video.', 'FmtpRequest$ChannelOrder' => 'The format of the audio channel.', 'FmtpRequest$ExactFramerate' => 'The frame rate for the video stream, in frames/second. For example: 60000/1001. If you specify a whole number, MediaConnect uses a ratio of N/1. For example, if you specify 60, MediaConnect uses 60/1 as the exactFramerate.', 'FmtpRequest$Par' => 'The pixel aspect ratio (PAR) of the video.', 'Gateway$GatewayArn' => 'The Amazon Resource Name (ARN) of the gateway.', 'Gateway$Name' => 'The name of the gateway. This name can not be modified after the gateway is created.', 'GatewayBridgeSource$BridgeArn' => 'The ARN of the bridge feeding this flow.', 'GatewayInstance$GatewayArn' => 'The Amazon Resource Name (ARN) of the instance.', 'GatewayInstance$GatewayInstanceArn' => 'The Amazon Resource Name (ARN) of the gateway.', 'GatewayInstance$InstanceId' => 'The managed instance ID generated by the SSM install. This will begin with "mi-".', 'GatewayNetwork$CidrBlock' => 'A unique IP address range to use for this network. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.', 'GatewayNetwork$Name' => 'The name of the network. This name is used to reference the network and must be unique among networks in this gateway.', 'GrantEntitlementRequest$Description' => 'A description of the entitlement. This description appears only on the AWS Elemental MediaConnect console and will not be seen by the subscriber or end user.', 'GrantEntitlementRequest$Name' => 'The name of the entitlement. This value must be unique within the current flow.', 'GrantFlowEntitlementsResponse$FlowArn' => 'The ARN of the flow that these entitlements were granted to.', 'IngressGatewayBridge$InstanceId' => 'The ID of the instance running this bridge.', 'InputConfiguration$InputIp' => 'The IP address that the flow listens on for incoming content for a media stream.', 'Interface$Name' => 'The name of the VPC interface.', 'InterfaceRequest$Name' => 'The name of the VPC interface.', 'ListBridgesResponse$NextToken' => 'The token that identifies which batch of results that you want to see. For example, you submit a ListBridges request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListBridges request a second time and specify the NextToken value.', 'ListEntitlementsResponse$NextToken' => 'The token that identifies which batch of results that you want to see. For example, you submit a ListEntitlements request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListEntitlements request a second time and specify the NextToken value.', 'ListFlowsResponse$NextToken' => 'The token that identifies which batch of results that you want to see. For example, you submit a ListFlows request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListFlows request a second time and specify the NextToken value.', 'ListGatewayInstancesResponse$NextToken' => 'The token that identifies which batch of results that you want to see. For example, you submit a ListInstances request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListInstances request a second time and specify the NextToken value.', 'ListGatewaysResponse$NextToken' => 'The token that identifies which batch of results that you want to see. For example, you submit a ListGateways request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListGateways request a second time and specify the NextToken value.', 'ListOfferingsResponse$NextToken' => 'The token that identifies which batch of results that you want to see. For example, you submit a ListOfferings request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListOfferings request a second time and specify the NextToken value.', 'ListReservationsResponse$NextToken' => 'The token that identifies which batch of results that you want to see. For example, you submit a ListReservations request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListReservations request a second time and specify the NextToken value.', 'ListedBridge$BridgeArn' => 'The ARN of the bridge.', 'ListedBridge$BridgeType' => 'The type of the bridge.', 'ListedBridge$Name' => 'The name of the bridge.', 'ListedBridge$PlacementArn' => 'The ARN of the gateway associated with the bridge.', 'ListedEntitlement$EntitlementArn' => 'The ARN of the entitlement.', 'ListedEntitlement$EntitlementName' => 'The name of the entitlement.', 'ListedFlow$AvailabilityZone' => 'The Availability Zone that the flow was created in.', 'ListedFlow$Description' => 'A description of the flow.', 'ListedFlow$FlowArn' => 'The ARN of the flow.', 'ListedFlow$Name' => 'The name of the flow.', 'ListedGateway$GatewayArn' => 'The Amazon Resource Name (ARN) of the gateway.', 'ListedGateway$Name' => 'The name of the gateway.', 'ListedGatewayInstance$GatewayArn' => 'The Amazon Resource Name (ARN) of the gateway.', 'ListedGatewayInstance$GatewayInstanceArn' => 'The Amazon Resource Name (ARN) of the instance.', 'ListedGatewayInstance$InstanceId' => 'The managed instance ID generated by the SSM install. This will begin with "mi-".', 'Maintenance$MaintenanceDeadline' => 'The Maintenance has to be performed before this deadline in ISO UTC format. Example: 2021-01-30T08:30:00Z.', 'Maintenance$MaintenanceScheduledDate' => 'A scheduled date in ISO UTC format when the maintenance will happen. Use YYYY-MM-DD format. Example: 2021-01-30.', 'Maintenance$MaintenanceStartHour' => 'UTC time when the maintenance will happen. Use 24-hour HH:MM format. Minutes must be 00. Example: 13:00. The default value is 02:00.', 'MediaStream$Description' => 'A description that can help you quickly identify what your media stream is used for.', 'MediaStream$MediaStreamName' => 'A name that helps you distinguish one media stream from another.', 'MediaStream$VideoFormat' => 'The resolution of the video.', 'MediaStreamAttributes$Lang' => 'The audio language, in a format that is recognized by the receiver.', 'MediaStreamAttributesRequest$Lang' => 'The audio language, in a format that is recognized by the receiver.', 'MediaStreamOutputConfiguration$MediaStreamName' => 'The name of the media stream.', 'MediaStreamOutputConfigurationRequest$MediaStreamName' => 'The name of the media stream that is associated with the output.', 'MediaStreamSourceConfiguration$MediaStreamName' => 'The name of the media stream.', 'MediaStreamSourceConfigurationRequest$MediaStreamName' => 'The name of the media stream.', 'MessageDetail$Code' => 'The error code.', 'MessageDetail$Message' => 'The specific error message that MediaConnect returns to help you understand the reason that the request did not succeed.', 'MessageDetail$ResourceName' => 'The name of the resource.', 'Offering$CurrencyCode' => 'The type of currency that is used for billing. The currencyCode used for all reservations is US dollars.', 'Offering$OfferingArn' => 'The Amazon Resource Name (ARN) that MediaConnect assigns to the offering.', 'Offering$OfferingDescription' => 'A description of the offering.', 'Offering$PricePerUnit' => 'The cost of a single unit. This value, in combination with priceUnits, makes up the rate.', 'Output$BridgeArn' => 'The ARN of the bridge that added this output.', 'Output$Description' => 'A description of the output.', 'Output$Destination' => 'The address where you want to send the output.', 'Output$EntitlementArn' => 'The ARN of the entitlement on the originator\'\'s flow. This value is relevant only on entitled flows.', 'Output$ListenerAddress' => 'The IP address that the receiver requires in order to establish a connection with the flow. For public networking, the ListenerAddress is represented by the elastic IP address of the flow. For private networking, the ListenerAddress is represented by the elastic network interface IP address of the VPC. This field applies only to outputs that use the Zixi pull or SRT listener protocol.', 'Output$MediaLiveInputArn' => 'The input ARN of the AWS Elemental MediaLive channel. This parameter is relevant only for outputs that were added by creating a MediaLive input.', 'Output$Name' => 'The name of the output. This value must be unique within the current flow.', 'Output$OutputArn' => 'The ARN of the output.', 'PurchaseOfferingRequest$ReservationName' => 'The name that you want to use for the reservation.', 'PurchaseOfferingRequest$Start' => 'The date and time that you want the reservation to begin, in Coordinated Universal Time (UTC). You can specify any date and time between 12:00am on the first day of the current month to the current time on today\'s date, inclusive. Specify the start in a 24-hour notation. Use the following format: YYYY-MM-DDTHH:mm:SSZ, where T and Z are literal characters. For example, to specify 11:30pm on March 5, 2020, enter 2020-03-05T23:30:00Z.', 'RemoveBridgeOutputResponse$BridgeArn' => NULL, 'RemoveBridgeOutputResponse$OutputName' => NULL, 'RemoveBridgeSourceResponse$BridgeArn' => NULL, 'RemoveBridgeSourceResponse$SourceName' => NULL, 'RemoveFlowMediaStreamResponse$FlowArn' => 'The Amazon Resource Name (ARN) of the flow.', 'RemoveFlowMediaStreamResponse$MediaStreamName' => 'The name of the media stream that was removed.', 'RemoveFlowOutputResponse$FlowArn' => 'The ARN of the flow that is associated with the output you removed.', 'RemoveFlowOutputResponse$OutputArn' => 'The ARN of the output that was removed.', 'RemoveFlowSourceResponse$FlowArn' => 'The ARN of the flow that is associated with the source you removed.', 'RemoveFlowSourceResponse$SourceArn' => 'The ARN of the source that was removed.', 'RemoveFlowVpcInterfaceResponse$FlowArn' => 'The ARN of the flow that is associated with the VPC interface you removed.', 'RemoveFlowVpcInterfaceResponse$VpcInterfaceName' => 'The name of the VPC interface that was removed.', 'Reservation$CurrencyCode' => 'The type of currency that is used for billing. The currencyCode used for your reservation is US dollars.', 'Reservation$End' => 'The day and time that this reservation expires. This value is calculated based on the start date and time that you set and the offering\'s duration.', 'Reservation$OfferingArn' => 'The Amazon Resource Name (ARN) that MediaConnect assigns to the offering.', 'Reservation$OfferingDescription' => 'A description of the offering. MediaConnect defines this value in the offering.', 'Reservation$PricePerUnit' => 'The cost of a single unit. This value, in combination with priceUnits, makes up the rate. MediaConnect defines this value in the offering.', 'Reservation$ReservationArn' => 'The Amazon Resource Name (ARN) that MediaConnect assigns to the reservation when you purchase an offering.', 'Reservation$ReservationName' => 'The name that you assigned to the reservation when you purchased the offering.', 'Reservation$Start' => 'The day and time that the reservation becomes active. You set this value when you purchase the offering.', 'ResponseError$Message' => 'The error message returned by AWS Elemental MediaConnect.', 'RevokeFlowEntitlementResponse$EntitlementArn' => 'The ARN of the entitlement that was revoked.', 'RevokeFlowEntitlementResponse$FlowArn' => 'The ARN of the flow that the entitlement was revoked from.', 'SetGatewayBridgeSourceRequest$BridgeArn' => 'The ARN of the bridge feeding this flow.', 'SetSourceRequest$Description' => 'A description for the source. This value is not used or seen outside of the current AWS Elemental MediaConnect account.', 'SetSourceRequest$EntitlementArn' => 'The ARN of the entitlement that allows you to subscribe to this flow. The entitlement is set by the flow originator, and the ARN is generated as part of the originator\'s flow.', 'SetSourceRequest$Name' => 'The name of the source.', 'SetSourceRequest$SenderIpAddress' => 'The IP address that the flow communicates with to initiate connection with the sender.', 'SetSourceRequest$SourceListenerAddress' => 'Source IP or domain name for SRT-caller protocol.', 'SetSourceRequest$StreamId' => 'The stream ID that you want to use for this transport. This parameter applies only to Zixi and SRT caller-based streams.', 'SetSourceRequest$VpcInterfaceName' => 'The name of the VPC interface to use for this source.', 'SetSourceRequest$WhitelistCidr' => 'The range of IP addresses that should be allowed to contribute content to your source. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.', 'Source$Description' => 'A description for the source. This value is not used or seen outside of the current AWS Elemental MediaConnect account.', 'Source$EntitlementArn' => 'The ARN of the entitlement that allows you to subscribe to content that comes from another AWS account. The entitlement is set by the content originator and the ARN is generated as part of the originator\'s flow.', 'Source$IngestIp' => 'The IP address that the flow will be listening on for incoming content.', 'Source$Name' => 'The name of the source.', 'Source$SenderIpAddress' => 'The IP address that the flow communicates with to initiate connection with the sender.', 'Source$SourceArn' => 'The ARN of the source.', 'Source$VpcInterfaceName' => 'The name of the VPC interface that is used for this source.', 'Source$WhitelistCidr' => 'The range of IP addresses that should be allowed to contribute content to your source. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.', 'SourcePriority$PrimarySource' => 'The name of the source you choose as the primary source for this flow.', 'StartFlowResponse$FlowArn' => 'The ARN of the flow that you started.', 'StopFlowResponse$FlowArn' => 'The ARN of the flow that you stopped.', 'Transport$RemoteId' => 'The remote ID for the Zixi-pull stream.', 'Transport$SenderIpAddress' => 'The IP address that the flow communicates with to initiate connection with the sender.', 'Transport$SourceListenerAddress' => 'Source IP or domain name for SRT-caller protocol.', 'Transport$StreamId' => 'The stream ID that you want to use for this transport. This parameter applies only to Zixi and SRT caller-based streams.', 'TransportStream$Codec' => 'The codec used by the stream.', 'TransportStream$FrameRate' => 'The frame rate used by the video stream.', 'TransportStream$StreamType' => 'The Stream Type as it is reported in the Program Map Table.', 'TransportStreamProgram$ProgramName' => 'The program name as it is reported in the Program Association Table.', 'UpdateBridgeFlowSourceRequest$FlowArn' => 'The ARN of the cloud flow to use as a source of this bridge.', 'UpdateBridgeNetworkOutputRequest$IpAddress' => 'The network output IP Address.', 'UpdateBridgeNetworkOutputRequest$NetworkName' => 'The network output\'s gateway network name.', 'UpdateBridgeNetworkSourceRequest$MulticastIp' => 'The network source multicast IP.', 'UpdateBridgeNetworkSourceRequest$NetworkName' => 'The network source\'s gateway network name.', 'UpdateBridgeOutputResponse$BridgeArn' => 'The Amazon Resource Number (ARN) of the bridge.', 'UpdateBridgeSourceResponse$BridgeArn' => 'The Amazon Resource Number (ARN) of the bridge.', 'UpdateBridgeStateResponse$BridgeArn' => 'The Amazon Resource Number (ARN) of the bridge.', 'UpdateEncryption$ConstantInitializationVector' => 'A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content. This parameter is not valid for static key encryption.', 'UpdateEncryption$DeviceId' => 'The value of one of the devices that you configured with your digital rights management (DRM) platform key provider. This parameter is required for SPEKE encryption and is not valid for static key encryption.', 'UpdateEncryption$Region' => 'The AWS Region that the API Gateway proxy endpoint was created in. This parameter is required for SPEKE encryption and is not valid for static key encryption.', 'UpdateEncryption$ResourceId' => 'An identifier for the content. The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.', 'UpdateEncryption$RoleArn' => 'The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).', 'UpdateEncryption$SecretArn' => 'The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.', 'UpdateEncryption$Url' => 'The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is required for SPEKE encryption and is not valid for static key encryption.', 'UpdateFlowEntitlementRequest$Description' => 'A description of the entitlement. This description appears only on the AWS Elemental MediaConnect console and will not be seen by the subscriber or end user.', 'UpdateFlowEntitlementResponse$FlowArn' => 'The ARN of the flow that this entitlement was granted on.', 'UpdateFlowMediaStreamRequest$Description' => 'Description', 'UpdateFlowMediaStreamRequest$VideoFormat' => 'The resolution of the video.', 'UpdateFlowMediaStreamResponse$FlowArn' => 'The ARN of the flow that is associated with the media stream that you updated.', 'UpdateFlowOutputRequest$Description' => 'A description of the output. This description appears only on the AWS Elemental MediaConnect console and will not be seen by the end user.', 'UpdateFlowOutputRequest$Destination' => 'The IP address where you want to send the output.', 'UpdateFlowOutputRequest$RemoteId' => 'The remote ID for the Zixi-pull stream.', 'UpdateFlowOutputRequest$SenderIpAddress' => 'The IP address that the flow communicates with to initiate connection with the sender.', 'UpdateFlowOutputRequest$StreamId' => 'The stream ID that you want to use for this transport. This parameter applies only to Zixi and SRT caller-based streams.', 'UpdateFlowOutputResponse$FlowArn' => 'The ARN of the flow that is associated with the updated output.', 'UpdateFlowSourceRequest$Description' => 'A description for the source. This value is not used or seen outside of the current AWS Elemental MediaConnect account.', 'UpdateFlowSourceRequest$EntitlementArn' => 'The ARN of the entitlement that allows you to subscribe to this flow. The entitlement is set by the flow originator, and the ARN is generated as part of the originator\'s flow.', 'UpdateFlowSourceRequest$SenderIpAddress' => 'The IP address that the flow communicates with to initiate connection with the sender.', 'UpdateFlowSourceRequest$SourceListenerAddress' => 'Source IP or domain name for SRT-caller protocol.', 'UpdateFlowSourceRequest$StreamId' => 'The stream ID that you want to use for this transport. This parameter applies only to Zixi and SRT caller-based streams.', 'UpdateFlowSourceRequest$VpcInterfaceName' => 'The name of the VPC interface to use for this source.', 'UpdateFlowSourceRequest$WhitelistCidr' => 'The range of IP addresses that should be allowed to contribute content to your source. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.', 'UpdateFlowSourceResponse$FlowArn' => 'The ARN of the flow that you want to update.', 'UpdateGatewayBridgeSourceRequest$BridgeArn' => 'The ARN of the bridge feeding this flow.', 'UpdateGatewayInstanceResponse$GatewayInstanceArn' => 'The Amazon Resource Name (ARN) of the instance.', 'UpdateMaintenance$MaintenanceScheduledDate' => 'A scheduled date in ISO UTC format when the maintenance will happen. Use YYYY-MM-DD format. Example: 2021-01-30.', 'UpdateMaintenance$MaintenanceStartHour' => 'UTC time when the maintenance will happen. Use 24-hour HH:MM format. Minutes must be 00. Example: 13:00. The default value is 02:00.', 'VpcInterface$Name' => 'Immutable and has to be a unique against other VpcInterfaces in this Flow.', 'VpcInterface$RoleArn' => 'Role Arn MediaConnect can assumes to create ENIs in customer\'s account', 'VpcInterface$SubnetId' => 'Subnet must be in the AZ of the Flow', 'VpcInterfaceAttachment$VpcInterfaceName' => 'The name of the VPC interface to use for this resource.', 'VpcInterfaceRequest$Name' => 'The name of the VPC Interface. This value must be unique within the current flow.', 'VpcInterfaceRequest$RoleArn' => 'Role Arn MediaConnect can assumes to create ENIs in customer\'s account', 'VpcInterfaceRequest$SubnetId' => 'Subnet must be in the AZ of the Flow', '__listOf__string$member' => NULL, '__mapOf__string$member' => NULL, ], ], '__timestampIso8601' => [ 'base' => NULL, 'refs' => [ 'DescribeFlowSourceMetadataResponse$Timestamp' => 'The timestamp of the most recent change in metadata for this flow’s source.', ], ], ],];
