<?php
// This file was auto-generated from sdk-root/src/data/mediapackagev2/2022-12-25/docs-2.json
return [ 'version' => '2.0', 'service' => '<note> <p>This guide is intended for creating AWS Elemental MediaPackage resources in MediaPackage Version 2 (v2) starting from May 2023. To get started with MediaPackage v2, create your MediaPackage resources. There isn\'t an automated process to migrate your resources from MediaPackage v1 to MediaPackage v2. </p> <p>The names of the entities that you use to access this API, like URLs and ARNs, all have the versioning information added, like "v2", to distinguish from the prior version. If you used MediaPackage prior to this release, you can\'t use the MediaPackage v2 CLI or the MediaPackage v2 API to access any MediaPackage v1 resources.</p> <p>If you created resources in MediaPackage v1, use video on demand (VOD) workflows, and aren\'t looking to migrate to MediaPackage v2 yet, see the <a href="https://docs.aws.amazon.com/mediapackage/latest/apireference/what-is.html">MediaPackage v1 Live API Reference</a>.</p> </note> <p>This is the AWS Elemental MediaPackage v2 Live REST API Reference. It describes all the MediaPackage API operations for live content in detail, and provides sample requests, responses, and errors for the supported web services protocols.</p> <p>We assume that you have the IAM permissions that you need to use MediaPackage via the REST API. We also assume that you are familiar with the features and operations of MediaPackage, as described in the AWS Elemental MediaPackage User Guide.</p>', 'operations' => [ 'CreateChannel' => '<p>Create a channel to start receiving content streams. The channel represents the input to MediaPackage for incoming live content from an encoder such as AWS Elemental MediaLive. The channel receives content, and after packaging it, outputs it through an origin endpoint to downstream devices (such as video players or CDNs) that request the content. You can create only one channel with each request. We recommend that you spread out channels between channel groups, such as putting redundant channels in the same AWS Region in different channel groups.</p>', 'CreateChannelGroup' => '<p>Create a channel group to group your channels and origin endpoints. A channel group is the top-level resource that consists of channels and origin endpoints that are associated with it and that provides predictable URLs for stream delivery. All channels and origin endpoints within the channel group are guaranteed to share the DNS. You can create only one channel group with each request. </p>', 'CreateOriginEndpoint' => '<p>The endpoint is attached to a channel, and represents the output of the live content. You can associate multiple endpoints to a single channel. Each endpoint gives players and downstream CDNs (such as Amazon CloudFront) access to the content for playback. Content can\'t be served from a channel until it has an endpoint. You can create only one endpoint with each request. </p>', 'DeleteChannel' => '<p>Delete a channel to stop AWS Elemental MediaPackage from receiving further content. You must delete the channel\'s origin endpoints before you can delete the channel.</p>', 'DeleteChannelGroup' => '<p>Delete a channel group. You must delete the channel group\'s channels and origin endpoints before you can delete the channel group. If you delete a channel group, you\'ll lose access to the egress domain and will have to create a new channel group to replace it.</p>', 'DeleteChannelPolicy' => '<p>Delete a channel policy.</p>', 'DeleteOriginEndpoint' => '<p>Origin endpoints can serve content until they\'re deleted. Delete the endpoint if it should no longer respond to playback requests. You must delete all endpoints from a channel before you can delete the channel.</p>', 'DeleteOriginEndpointPolicy' => '<p>Delete an origin endpoint policy.</p>', 'GetChannel' => '<p>Retrieves the specified channel that\'s configured in AWS Elemental MediaPackage, including the origin endpoints that are associated with it.</p>', 'GetChannelGroup' => '<p>Retrieves the specified channel group that\'s configured in AWS Elemental MediaPackage, including the channels and origin endpoints that are associated with it.</p>', 'GetChannelPolicy' => '<p>Retrieves the specified channel policy that\'s configured in AWS Elemental MediaPackage. With policies, you can specify who has access to AWS resources and what actions they can perform on those resources.</p>', 'GetOriginEndpoint' => '<p>Retrieves the specified origin endpoint that\'s configured in AWS Elemental MediaPackage to obtain its playback URL and to view the packaging settings that it\'s currently using.</p>', 'GetOriginEndpointPolicy' => '<p>Retrieves the specified origin endpoint policy that\'s configured in AWS Elemental MediaPackage.</p>', 'ListChannelGroups' => '<p>Retrieves all channel groups that are configured in AWS Elemental MediaPackage, including the channels and origin endpoints that are associated with it.</p>', 'ListChannels' => '<p>Retrieves all channels in a specific channel group that are configured in AWS Elemental MediaPackage, including the origin endpoints that are associated with it.</p>', 'ListOriginEndpoints' => '<p>Retrieves all origin endpoints in a specific channel that are configured in AWS Elemental MediaPackage.</p>', 'ListTagsForResource' => '<p>Lists the tags assigned to a resource.</p>', 'PutChannelPolicy' => '<p>Attaches an IAM policy to the specified channel. With policies, you can specify who has access to AWS resources and what actions they can perform on those resources. You can attach only one policy with each request.</p>', 'PutOriginEndpointPolicy' => '<p>Attaches an IAM policy to the specified origin endpoint. You can attach only one policy with each request.</p>', 'TagResource' => '<p>Assigns one of more tags (key-value pairs) to the specified MediaPackage resource.</p> <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by granting a user permission to access or change only resources with certain tag values. You can use the TagResource operation with a resource that already has tags. If you specify a new tag key for the resource, this tag is appended to the list of tags associated with the resource. If you specify a tag key that is already associated with the resource, the new tag value that you specify replaces the previous value for that tag.</p>', 'UntagResource' => '<p>Removes one or more tags from the specified resource.</p>', 'UpdateChannel' => '<p>Update the specified channel. You can edit if MediaPackage sends ingest or egress access logs to the CloudWatch log group, if content will be encrypted, the description on a channel, and your channel\'s policy settings. You can\'t edit the name of the channel or CloudFront distribution details.</p> <p>Any edits you make that impact the video output may not be reflected for a few minutes.</p>', 'UpdateChannelGroup' => '<p>Update the specified channel group. You can edit the description on a channel group for easier identification later from the AWS Elemental MediaPackage console. You can\'t edit the name of the channel group.</p> <p>Any edits you make that impact the video output may not be reflected for a few minutes.</p>', 'UpdateOriginEndpoint' => '<p>Update the specified origin endpoint. Edit the packaging preferences on an endpoint to optimize the viewing experience. You can\'t edit the name of the endpoint.</p> <p>Any edits you make that impact the video output may not be reflected for a few minutes.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You don\'t have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see Access Management in the IAM User Guide.</p>', 'refs' => [], ], 'AdMarkerDash' => [ 'base' => NULL, 'refs' => [ 'ScteDash$AdMarkerDash' => '<p>Choose how ad markers are included in the packaged content. If you include ad markers in the content stream in your upstream encoders, then you need to inform MediaPackage what to do with the ad markers in the output.</p> <p>Value description:</p> <ul> <li> <p> <code>Binary</code> - The SCTE-35 marker is expressed as a hex-string (Base64 string) rather than full XML.</p> </li> <li> <p> <code>XML</code> - The SCTE marker is expressed fully in XML.</p> </li> </ul>', ], ], 'AdMarkerHls' => [ 'base' => NULL, 'refs' => [ 'ScteHls$AdMarkerHls' => '<p>Ad markers indicate when ads should be inserted during playback. If you include ad markers in the content stream in your upstream encoders, then you need to inform MediaPackage what to do with the ad markers in the output. Choose what you want MediaPackage to do with the ad markers.</p> <p>Value description: </p> <ul> <li> <p>DATERANGE - Insert EXT-X-DATERANGE tags to signal ad and program transition events in TS and CMAF manifests. If you use DATERANGE, you must set a programDateTimeIntervalSeconds value of 1 or higher. To learn more about DATERANGE, see <a href="http://docs.aws.amazon.com/mediapackage/latest/ug/scte-35-ad-marker-ext-x-daterange.html">SCTE-35 Ad Marker EXT-X-DATERANGE</a>.</p> </li> </ul>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'Segment$TsUseAudioRenditionGroup' => '<p>When selected, MediaPackage bundles all audio tracks in a rendition group. All other tracks in the stream can be used with any audio rendition from the group.</p>', 'Segment$IncludeIframeOnlyStreams' => '<p>When selected, the stream set includes an additional I-frame only stream, along with the other tracks. If false, this extra stream is not included. MediaPackage generates an I-frame only stream from the first rendition in the manifest. The service inserts EXT-I-FRAMES-ONLY tags in the output manifest, and then generates and includes an I-frames only playlist in the stream. This playlist permits player functionality like fast forward and rewind.</p>', 'Segment$TsIncludeDvbSubtitles' => '<p>By default, MediaPackage excludes all digital video broadcasting (DVB) subtitles from the output. When selected, MediaPackage passes through DVB subtitles into the output.</p>', ], ], 'ChannelGroupListConfiguration' => [ 'base' => '<p>The configuration of the channel group.</p>', 'refs' => [ 'ChannelGroupsList$member' => NULL, ], ], 'ChannelGroupsList' => [ 'base' => NULL, 'refs' => [ 'ListChannelGroupsResponse$Items' => '<p>The objects being returned.</p>', ], ], 'ChannelList' => [ 'base' => NULL, 'refs' => [ 'ListChannelsResponse$Items' => '<p>The objects being returned.</p>', ], ], 'ChannelListConfiguration' => [ 'base' => '<p>The configuration of the channel.</p>', 'refs' => [ 'ChannelList$member' => NULL, ], ], 'CmafEncryptionMethod' => [ 'base' => NULL, 'refs' => [ 'EncryptionMethod$CmafEncryptionMethod' => '<p>The encryption method to use.</p>', ], ], 'ConflictException' => [ 'base' => '<p>Updating or deleting this resource can cause an inconsistent state.</p>', 'refs' => [], ], 'ConflictExceptionType' => [ 'base' => NULL, 'refs' => [ 'ConflictException$ConflictExceptionType' => '<p>The type of ConflictException.</p>', ], ], 'ContainerType' => [ 'base' => NULL, 'refs' => [ 'CreateOriginEndpointRequest$ContainerType' => '<p>The type of container to attach to this origin endpoint. A container type is a file format that encapsulates one or more media streams, such as audio and video, into a single file. You can\'t change the container type after you create the endpoint.</p>', 'CreateOriginEndpointResponse$ContainerType' => '<p>The type of container attached to this origin endpoint.</p>', 'GetOriginEndpointResponse$ContainerType' => '<p>The type of container attached to this origin endpoint.</p>', 'OriginEndpointListConfiguration$ContainerType' => '<p>The type of container attached to this origin endpoint. A container type is a file format that encapsulates one or more media streams, such as audio and video, into a single file. </p>', 'UpdateOriginEndpointRequest$ContainerType' => '<p>The type of container attached to this origin endpoint. A container type is a file format that encapsulates one or more media streams, such as audio and video, into a single file. </p>', 'UpdateOriginEndpointResponse$ContainerType' => '<p>The type of container attached to this origin endpoint.</p>', ], ], 'CreateChannelGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateChannelGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateChannelResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateDashManifestConfiguration' => [ 'base' => '<p>Create a DASH manifest configuration.</p>', 'refs' => [ 'CreateDashManifests$member' => NULL, ], ], 'CreateDashManifestConfigurationManifestWindowSecondsInteger' => [ 'base' => NULL, 'refs' => [ 'CreateDashManifestConfiguration$ManifestWindowSeconds' => '<p>The total duration (in seconds) of the manifest\'s content.</p>', ], ], 'CreateDashManifestConfigurationMinBufferTimeSecondsInteger' => [ 'base' => NULL, 'refs' => [ 'CreateDashManifestConfiguration$MinBufferTimeSeconds' => '<p>Minimum amount of content (in seconds) that a player must keep available in the buffer.</p>', ], ], 'CreateDashManifestConfigurationMinUpdatePeriodSecondsInteger' => [ 'base' => NULL, 'refs' => [ 'CreateDashManifestConfiguration$MinUpdatePeriodSeconds' => '<p>Minimum amount of time (in seconds) that the player should wait before requesting updates to the manifest.</p>', ], ], 'CreateDashManifestConfigurationSuggestedPresentationDelaySecondsInteger' => [ 'base' => NULL, 'refs' => [ 'CreateDashManifestConfiguration$SuggestedPresentationDelaySeconds' => '<p>The amount of time (in seconds) that the player should be from the end of the manifest.</p>', ], ], 'CreateDashManifests' => [ 'base' => NULL, 'refs' => [ 'CreateOriginEndpointRequest$DashManifests' => '<p>A DASH manifest configuration.</p>', 'UpdateOriginEndpointRequest$DashManifests' => '<p>A DASH manifest configuration.</p>', ], ], 'CreateHlsManifestConfiguration' => [ 'base' => '<p>Create an HTTP live streaming (HLS) manifest configuration.</p>', 'refs' => [ 'CreateHlsManifests$member' => NULL, ], ], 'CreateHlsManifestConfigurationManifestWindowSecondsInteger' => [ 'base' => NULL, 'refs' => [ 'CreateHlsManifestConfiguration$ManifestWindowSeconds' => '<p>The total duration (in seconds) of the manifest\'s content.</p>', ], ], 'CreateHlsManifestConfigurationProgramDateTimeIntervalSecondsInteger' => [ 'base' => NULL, 'refs' => [ 'CreateHlsManifestConfiguration$ProgramDateTimeIntervalSeconds' => '<p>Inserts EXT-X-PROGRAM-DATE-TIME tags in the output manifest at the interval that you specify. If you don\'t enter an interval, EXT-X-PROGRAM-DATE-TIME tags aren\'t included in the manifest. The tags sync the stream to the wall clock so that viewers can seek to a specific time in the playback timeline on the player. ID3Timed metadata messages generate every 5 seconds whenever the content is ingested.</p> <p>Irrespective of this parameter, if any ID3Timed metadata is in the HLS input, it is passed through to the HLS output.</p>', ], ], 'CreateHlsManifests' => [ 'base' => NULL, 'refs' => [ 'CreateOriginEndpointRequest$HlsManifests' => '<p>An HTTP live streaming (HLS) manifest configuration.</p>', 'UpdateOriginEndpointRequest$HlsManifests' => '<p>An HTTP live streaming (HLS) manifest configuration.</p>', ], ], 'CreateLowLatencyHlsManifestConfiguration' => [ 'base' => '<p>Create a low-latency HTTP live streaming (HLS) manifest configuration.</p>', 'refs' => [ 'CreateLowLatencyHlsManifests$member' => NULL, ], ], 'CreateLowLatencyHlsManifestConfigurationManifestWindowSecondsInteger' => [ 'base' => NULL, 'refs' => [ 'CreateLowLatencyHlsManifestConfiguration$ManifestWindowSeconds' => '<p>The total duration (in seconds) of the manifest\'s content.</p>', ], ], 'CreateLowLatencyHlsManifestConfigurationProgramDateTimeIntervalSecondsInteger' => [ 'base' => NULL, 'refs' => [ 'CreateLowLatencyHlsManifestConfiguration$ProgramDateTimeIntervalSeconds' => '<p>Inserts EXT-X-PROGRAM-DATE-TIME tags in the output manifest at the interval that you specify. If you don\'t enter an interval, EXT-X-PROGRAM-DATE-TIME tags aren\'t included in the manifest. The tags sync the stream to the wall clock so that viewers can seek to a specific time in the playback timeline on the player. ID3Timed metadata messages generate every 5 seconds whenever the content is ingested.</p> <p>Irrespective of this parameter, if any ID3Timed metadata is in the HLS input, it is passed through to the HLS output.</p>', ], ], 'CreateLowLatencyHlsManifests' => [ 'base' => NULL, 'refs' => [ 'CreateOriginEndpointRequest$LowLatencyHlsManifests' => '<p>A low-latency HLS manifest configuration.</p>', 'UpdateOriginEndpointRequest$LowLatencyHlsManifests' => '<p>A low-latency HLS manifest configuration.</p>', ], ], 'CreateOriginEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateOriginEndpointRequestStartoverWindowSecondsInteger' => [ 'base' => NULL, 'refs' => [ 'CreateOriginEndpointRequest$StartoverWindowSeconds' => '<p>The size of the window (in seconds) to create a window of the live stream that\'s available for on-demand viewing. Viewers can start-over or catch-up on content that falls within the window. The maximum startover window is 1,209,600 seconds (14 days).</p>', ], ], 'CreateOriginEndpointResponse' => [ 'base' => NULL, 'refs' => [], ], 'DashDrmSignaling' => [ 'base' => NULL, 'refs' => [ 'CreateDashManifestConfiguration$DrmSignaling' => '<p>Determines how the DASH manifest signals the DRM content.</p>', 'GetDashManifestConfiguration$DrmSignaling' => '<p>Determines how the DASH manifest signals the DRM content.</p>', ], ], 'DashPeriodTrigger' => [ 'base' => NULL, 'refs' => [ 'DashPeriodTriggers$member' => NULL, ], ], 'DashPeriodTriggers' => [ 'base' => NULL, 'refs' => [ 'CreateDashManifestConfiguration$PeriodTriggers' => '<p>A list of triggers that controls when AWS Elemental MediaPackage separates the MPEG-DASH manifest into multiple periods. Type <code>ADS</code> to indicate that AWS Elemental MediaPackage must create periods in the output manifest that correspond to SCTE-35 ad markers in the input source. Leave this value empty to indicate that the manifest is contained all in one period. For more information about periods in the DASH manifest, see <a href="https://docs.aws.amazon.com/mediapackage/latest/userguide/multi-period.html">Multi-period DASH in AWS Elemental MediaPackage</a>.</p>', 'GetDashManifestConfiguration$PeriodTriggers' => '<p>A list of triggers that controls when AWS Elemental MediaPackage separates the MPEG-DASH manifest into multiple periods. Leave this value empty to indicate that the manifest is contained all in one period. For more information about periods in the DASH manifest, see <a href="https://docs.aws.amazon.com/mediapackage/latest/userguide/multi-period.html">Multi-period DASH in AWS Elemental MediaPackage</a>.</p>', ], ], 'DashSegmentTemplateFormat' => [ 'base' => NULL, 'refs' => [ 'CreateDashManifestConfiguration$SegmentTemplateFormat' => '<p>Determines the type of variable used in the <code>media</code> URL of the <code>SegmentTemplate</code> tag in the manifest. Also specifies if segment timeline information is included in <code>SegmentTimeline</code> or <code>SegmentTemplate</code>.</p> <p>Value description:</p> <ul> <li> <p> <code>NUMBER_WITH_TIMELINE</code> - The <code>$Number$</code> variable is used in the <code>media</code> URL. The value of this variable is the sequential number of the segment. A full <code>SegmentTimeline</code> object is presented in each <code>SegmentTemplate</code>.</p> </li> </ul>', 'GetDashManifestConfiguration$SegmentTemplateFormat' => '<p>Determines the type of variable used in the <code>media</code> URL of the <code>SegmentTemplate</code> tag in the manifest. Also specifies if segment timeline information is included in <code>SegmentTimeline</code> or <code>SegmentTemplate</code>.</p> <p>Value description:</p> <ul> <li> <p> <code>NUMBER_WITH_TIMELINE</code> - The <code>$Number$</code> variable is used in the <code>media</code> URL. The value of this variable is the sequential number of the segment. A full <code>SegmentTimeline</code> object is presented in each <code>SegmentTemplate</code>.</p> </li> </ul>', ], ], 'DashUtcTiming' => [ 'base' => '<p>Determines the type of UTC timing included in the DASH Media Presentation Description (MPD).</p>', 'refs' => [ 'CreateDashManifestConfiguration$UtcTiming' => '<p>Determines the type of UTC timing included in the DASH Media Presentation Description (MPD).</p>', 'GetDashManifestConfiguration$UtcTiming' => '<p>Determines the type of UTC timing included in the DASH Media Presentation Description (MPD).</p>', ], ], 'DashUtcTimingMode' => [ 'base' => NULL, 'refs' => [ 'DashUtcTiming$TimingMode' => '<p>The UTC timing mode.</p>', ], ], 'DashUtcTimingTimingSourceString' => [ 'base' => NULL, 'refs' => [ 'DashUtcTiming$TimingSource' => '<p>The the method that the player uses to synchronize to coordinated universal time (UTC) wall clock time.</p>', ], ], 'DeleteChannelGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteChannelGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteChannelPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteChannelPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteChannelResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteOriginEndpointPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteOriginEndpointPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteOriginEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteOriginEndpointResponse' => [ 'base' => NULL, 'refs' => [], ], 'DrmSystem' => [ 'base' => NULL, 'refs' => [ 'SpekeKeyProviderDrmSystemsList$member' => NULL, ], ], 'Encryption' => [ 'base' => '<p>The parameters for encrypting content.</p>', 'refs' => [ 'Segment$Encryption' => NULL, ], ], 'EncryptionConstantInitializationVectorString' => [ 'base' => NULL, 'refs' => [ 'Encryption$ConstantInitializationVector' => '<p>A 128-bit, 16-byte hex value represented by a 32-character string, used in conjunction with the key for encrypting content. If you don\'t specify a value, then MediaPackage creates the constant initialization vector (IV).</p>', ], ], 'EncryptionContractConfiguration' => [ 'base' => '<p>Configure one or more content encryption keys for your endpoints that use SPEKE Version 2.0. The encryption contract defines which content keys are used to encrypt the audio and video tracks in your stream. To configure the encryption contract, specify which audio and video encryption presets to use.</p>', 'refs' => [ 'SpekeKeyProvider$EncryptionContractConfiguration' => '<p>Configure one or more content encryption keys for your endpoints that use SPEKE Version 2.0. The encryption contract defines which content keys are used to encrypt the audio and video tracks in your stream. To configure the encryption contract, specify which audio and video encryption presets to use.</p>', ], ], 'EncryptionKeyRotationIntervalSecondsInteger' => [ 'base' => NULL, 'refs' => [ 'Encryption$KeyRotationIntervalSeconds' => '<p>The frequency (in seconds) of key changes for live workflows, in which content is streamed real time. The service retrieves content keys before the live content begins streaming, and then retrieves them as needed over the lifetime of the workflow. By default, key rotation is set to 300 seconds (5 minutes), the minimum rotation interval, which is equivalent to setting it to 300. If you don\'t enter an interval, content keys aren\'t rotated.</p> <p>The following example setting causes the service to rotate keys every thirty minutes: <code>1800</code> </p>', ], ], 'EncryptionMethod' => [ 'base' => '<p>The encryption type.</p>', 'refs' => [ 'Encryption$EncryptionMethod' => '<p>The encryption method to use.</p>', ], ], 'EndpointErrorCondition' => [ 'base' => NULL, 'refs' => [ 'EndpointErrorConditions$member' => NULL, ], ], 'EndpointErrorConditions' => [ 'base' => NULL, 'refs' => [ 'ForceEndpointErrorConfiguration$EndpointErrorConditions' => '<p>The failover conditions for the endpoint. The options are:</p> <ul> <li> <p> <code>STALE_MANIFEST</code> - The manifest stalled and there are no new segments or parts.</p> </li> <li> <p> <code>INCOMPLETE_MANIFEST</code> - There is a gap in the manifest.</p> </li> <li> <p> <code>MISSING_DRM_KEY</code> - Key rotation is enabled but we\'re unable to fetch the key for the current key period.</p> </li> <li> <p> <code>SLATE_INPUT</code> - The segments which contain slate content are considered to be missing content.</p> </li> </ul>', ], ], 'EntityTag' => [ 'base' => NULL, 'refs' => [ 'CreateChannelGroupResponse$ETag' => '<p>The current Entity Tag (ETag) associated with this resource. The entity tag can be used to safely make concurrent updates to the resource.</p>', 'CreateChannelResponse$ETag' => '<p>The current Entity Tag (ETag) associated with this resource. The entity tag can be used to safely make concurrent updates to the resource.</p>', 'CreateOriginEndpointResponse$ETag' => '<p>The current Entity Tag (ETag) associated with this resource. The entity tag can be used to safely make concurrent updates to the resource.</p>', 'GetChannelGroupResponse$ETag' => '<p>The current Entity Tag (ETag) associated with this resource. The entity tag can be used to safely make concurrent updates to the resource.</p>', 'GetChannelResponse$ETag' => '<p>The current Entity Tag (ETag) associated with this resource. The entity tag can be used to safely make concurrent updates to the resource.</p>', 'GetOriginEndpointResponse$ETag' => '<p>The current Entity Tag (ETag) associated with this resource. The entity tag can be used to safely make concurrent updates to the resource.</p>', 'UpdateChannelGroupRequest$ETag' => '<p>The expected current Entity Tag (ETag) for the resource. If the specified ETag does not match the resource\'s current entity tag, the update request will be rejected.</p>', 'UpdateChannelGroupResponse$ETag' => '<p>The current Entity Tag (ETag) associated with this resource. The entity tag can be used to safely make concurrent updates to the resource.</p>', 'UpdateChannelRequest$ETag' => '<p>The expected current Entity Tag (ETag) for the resource. If the specified ETag does not match the resource\'s current entity tag, the update request will be rejected.</p>', 'UpdateChannelResponse$ETag' => '<p>The current Entity Tag (ETag) associated with this resource. The entity tag can be used to safely make concurrent updates to the resource.</p>', 'UpdateOriginEndpointRequest$ETag' => '<p>The expected current Entity Tag (ETag) for the resource. If the specified ETag does not match the resource\'s current entity tag, the update request will be rejected.</p>', 'UpdateOriginEndpointResponse$ETag' => '<p>The current Entity Tag (ETag) associated with this resource. The entity tag can be used to safely make concurrent updates to the resource.</p>', ], ], 'FilterConfiguration' => [ 'base' => '<p>Filter configuration includes settings for manifest filtering, start and end times, and time delay that apply to all of your egress requests for this manifest. </p>', 'refs' => [ 'CreateDashManifestConfiguration$FilterConfiguration' => NULL, 'CreateHlsManifestConfiguration$FilterConfiguration' => NULL, 'CreateLowLatencyHlsManifestConfiguration$FilterConfiguration' => NULL, 'GetDashManifestConfiguration$FilterConfiguration' => NULL, 'GetHlsManifestConfiguration$FilterConfiguration' => NULL, 'GetLowLatencyHlsManifestConfiguration$FilterConfiguration' => NULL, ], ], 'FilterConfigurationManifestFilterString' => [ 'base' => NULL, 'refs' => [ 'FilterConfiguration$ManifestFilter' => '<p>Optionally specify one or more manifest filters for all of your manifest egress requests. When you include a manifest filter, note that you cannot use an identical manifest filter query parameter for this manifest\'s endpoint URL.</p>', ], ], 'FilterConfigurationTimeDelaySecondsInteger' => [ 'base' => NULL, 'refs' => [ 'FilterConfiguration$TimeDelaySeconds' => '<p>Optionally specify the time delay for all of your manifest egress requests. Enter a value that is smaller than your endpoint\'s startover window. When you include time delay, note that you cannot use time delay query parameters for this manifest\'s endpoint URL.</p>', ], ], 'ForceEndpointErrorConfiguration' => [ 'base' => '<p>The failover settings for the endpoint.</p>', 'refs' => [ 'CreateOriginEndpointRequest$ForceEndpointErrorConfiguration' => '<p>The failover settings for the endpoint.</p>', 'CreateOriginEndpointResponse$ForceEndpointErrorConfiguration' => '<p>The failover settings for the endpoint.</p>', 'GetOriginEndpointResponse$ForceEndpointErrorConfiguration' => '<p>The failover settings for the endpoint.</p>', 'OriginEndpointListConfiguration$ForceEndpointErrorConfiguration' => '<p>The failover settings for the endpoint.</p>', 'UpdateOriginEndpointRequest$ForceEndpointErrorConfiguration' => '<p>The failover settings for the endpoint.</p>', 'UpdateOriginEndpointResponse$ForceEndpointErrorConfiguration' => '<p>The failover settings for the endpoint.</p>', ], ], 'GetChannelGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetChannelGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetChannelPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetChannelPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetChannelResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetDashManifestConfiguration' => [ 'base' => '<p>Retrieve the DASH manifest configuration.</p>', 'refs' => [ 'GetDashManifests$member' => NULL, ], ], 'GetDashManifests' => [ 'base' => NULL, 'refs' => [ 'CreateOriginEndpointResponse$DashManifests' => '<p>A DASH manifest configuration.</p>', 'GetOriginEndpointResponse$DashManifests' => '<p>A DASH manifest configuration.</p>', 'UpdateOriginEndpointResponse$DashManifests' => '<p>A DASH manifest configuration.</p>', ], ], 'GetHlsManifestConfiguration' => [ 'base' => '<p>Retrieve the HTTP live streaming (HLS) manifest configuration.</p>', 'refs' => [ 'GetHlsManifests$member' => NULL, ], ], 'GetHlsManifests' => [ 'base' => NULL, 'refs' => [ 'CreateOriginEndpointResponse$HlsManifests' => '<p>An HTTP live streaming (HLS) manifest configuration.</p>', 'GetOriginEndpointResponse$HlsManifests' => '<p>An HTTP live streaming (HLS) manifest configuration.</p>', 'UpdateOriginEndpointResponse$HlsManifests' => '<p>An HTTP live streaming (HLS) manifest configuration.</p>', ], ], 'GetLowLatencyHlsManifestConfiguration' => [ 'base' => '<p>Retrieve the low-latency HTTP live streaming (HLS) manifest configuration.</p>', 'refs' => [ 'GetLowLatencyHlsManifests$member' => NULL, ], ], 'GetLowLatencyHlsManifests' => [ 'base' => NULL, 'refs' => [ 'CreateOriginEndpointResponse$LowLatencyHlsManifests' => '<p>A low-latency HLS manifest configuration.</p>', 'GetOriginEndpointResponse$LowLatencyHlsManifests' => '<p>A low-latency HLS manifest configuration.</p>', 'UpdateOriginEndpointResponse$LowLatencyHlsManifests' => '<p>A low-latency HLS manifest configuration.</p>', ], ], 'GetOriginEndpointPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetOriginEndpointPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetOriginEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetOriginEndpointResponse' => [ 'base' => NULL, 'refs' => [], ], 'IdempotencyToken' => [ 'base' => NULL, 'refs' => [ 'CreateChannelGroupRequest$ClientToken' => '<p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>', 'CreateChannelRequest$ClientToken' => '<p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>', 'CreateOriginEndpointRequest$ClientToken' => '<p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>', ], ], 'IngestEndpoint' => [ 'base' => '<p>The ingest domain URL where the source stream should be sent.</p>', 'refs' => [ 'IngestEndpointList$member' => NULL, ], ], 'IngestEndpointList' => [ 'base' => '<p>The list of ingest endpoints.</p>', 'refs' => [ 'CreateChannelResponse$IngestEndpoints' => NULL, 'GetChannelResponse$IngestEndpoints' => NULL, 'UpdateChannelResponse$IngestEndpoints' => NULL, ], ], 'InputType' => [ 'base' => NULL, 'refs' => [ 'ChannelListConfiguration$InputType' => '<p>The input type will be an immutable field which will be used to define whether the channel will allow CMAF ingest or HLS ingest. If unprovided, it will default to HLS to preserve current behavior.</p> <p>The allowed values are:</p> <ul> <li> <p> <code>HLS</code> - The HLS streaming specification (which defines M3U8 manifests and TS segments).</p> </li> <li> <p> <code>CMAF</code> - The DASH-IF CMAF Ingest specification (which defines CMAF segments with optional DASH manifests).</p> </li> </ul>', 'CreateChannelRequest$InputType' => '<p>The input type will be an immutable field which will be used to define whether the channel will allow CMAF ingest or HLS ingest. If unprovided, it will default to HLS to preserve current behavior.</p> <p>The allowed values are:</p> <ul> <li> <p> <code>HLS</code> - The HLS streaming specification (which defines M3U8 manifests and TS segments).</p> </li> <li> <p> <code>CMAF</code> - The DASH-IF CMAF Ingest specification (which defines CMAF segments with optional DASH manifests).</p> </li> </ul>', 'CreateChannelResponse$InputType' => '<p>The input type will be an immutable field which will be used to define whether the channel will allow CMAF ingest or HLS ingest. If unprovided, it will default to HLS to preserve current behavior.</p> <p>The allowed values are:</p> <ul> <li> <p> <code>HLS</code> - The HLS streaming specification (which defines M3U8 manifests and TS segments).</p> </li> <li> <p> <code>CMAF</code> - The DASH-IF CMAF Ingest specification (which defines CMAF segments with optional DASH manifests).</p> </li> </ul>', 'GetChannelResponse$InputType' => '<p>The input type will be an immutable field which will be used to define whether the channel will allow CMAF ingest or HLS ingest. If unprovided, it will default to HLS to preserve current behavior.</p> <p>The allowed values are:</p> <ul> <li> <p> <code>HLS</code> - The HLS streaming specification (which defines M3U8 manifests and TS segments).</p> </li> <li> <p> <code>CMAF</code> - The DASH-IF CMAF Ingest specification (which defines CMAF segments with optional DASH manifests).</p> </li> </ul>', 'UpdateChannelResponse$InputType' => '<p>The input type will be an immutable field which will be used to define whether the channel will allow CMAF ingest or HLS ingest. If unprovided, it will default to HLS to preserve current behavior.</p> <p>The allowed values are:</p> <ul> <li> <p> <code>HLS</code> - The HLS streaming specification (which defines M3U8 manifests and TS segments).</p> </li> <li> <p> <code>CMAF</code> - The DASH-IF CMAF Ingest specification (which defines CMAF segments with optional DASH manifests).</p> </li> </ul>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'CreateOriginEndpointResponse$StartoverWindowSeconds' => '<p>The size of the window (in seconds) to create a window of the live stream that\'s available for on-demand viewing. Viewers can start-over or catch-up on content that falls within the window.</p>', 'GetDashManifestConfiguration$ManifestWindowSeconds' => '<p>The total duration (in seconds) of the manifest\'s content.</p>', 'GetDashManifestConfiguration$MinUpdatePeriodSeconds' => '<p>Minimum amount of time (in seconds) that the player should wait before requesting updates to the manifest.</p>', 'GetDashManifestConfiguration$MinBufferTimeSeconds' => '<p>Minimum amount of content (in seconds) that a player must keep available in the buffer.</p>', 'GetDashManifestConfiguration$SuggestedPresentationDelaySeconds' => '<p>The amount of time (in seconds) that the player should be from the end of the manifest.</p>', 'GetHlsManifestConfiguration$ManifestWindowSeconds' => '<p>The total duration (in seconds) of the manifest\'s content.</p>', 'GetHlsManifestConfiguration$ProgramDateTimeIntervalSeconds' => '<p>Inserts EXT-X-PROGRAM-DATE-TIME tags in the output manifest at the interval that you specify. If you don\'t enter an interval, EXT-X-PROGRAM-DATE-TIME tags aren\'t included in the manifest. The tags sync the stream to the wall clock so that viewers can seek to a specific time in the playback timeline on the player. ID3Timed metadata messages generate every 5 seconds whenever the content is ingested.</p> <p>Irrespective of this parameter, if any ID3Timed metadata is in the HLS input, it is passed through to the HLS output.</p>', 'GetLowLatencyHlsManifestConfiguration$ManifestWindowSeconds' => '<p>The total duration (in seconds) of the manifest\'s content.</p>', 'GetLowLatencyHlsManifestConfiguration$ProgramDateTimeIntervalSeconds' => '<p>Inserts EXT-X-PROGRAM-DATE-TIME tags in the output manifest at the interval that you specify. If you don\'t enter an interval, EXT-X-PROGRAM-DATE-TIME tags aren\'t included in the manifest. The tags sync the stream to the wall clock so that viewers can seek to a specific time in the playback timeline on the player. ID3Timed metadata messages generate every 5 seconds whenever the content is ingested.</p> <p>Irrespective of this parameter, if any ID3Timed metadata is in the HLS input, it is passed through to the HLS output.</p>', 'GetOriginEndpointResponse$StartoverWindowSeconds' => '<p>The size of the window (in seconds) to create a window of the live stream that\'s available for on-demand viewing. Viewers can start-over or catch-up on content that falls within the window.</p>', 'UpdateOriginEndpointResponse$StartoverWindowSeconds' => '<p>The size of the window (in seconds) to create a window of the live stream that\'s available for on-demand viewing. Viewers can start-over or catch-up on content that falls within the window.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>Indicates that an error from the service occurred while trying to process a request.</p>', 'refs' => [], ], 'ListChannelGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDashManifestConfiguration' => [ 'base' => '<p>List the DASH manifest configuration.</p>', 'refs' => [ 'ListDashManifests$member' => NULL, ], ], 'ListDashManifests' => [ 'base' => NULL, 'refs' => [ 'OriginEndpointListConfiguration$DashManifests' => '<p>A DASH manifest configuration.</p>', ], ], 'ListHlsManifestConfiguration' => [ 'base' => '<p>List the HTTP live streaming (HLS) manifest configuration.</p>', 'refs' => [ 'ListHlsManifests$member' => NULL, ], ], 'ListHlsManifests' => [ 'base' => NULL, 'refs' => [ 'OriginEndpointListConfiguration$HlsManifests' => '<p>An HTTP live streaming (HLS) manifest configuration.</p>', ], ], 'ListLowLatencyHlsManifestConfiguration' => [ 'base' => '<p>List the low-latency HTTP live streaming (HLS) manifest configuration.</p>', 'refs' => [ 'ListLowLatencyHlsManifests$member' => NULL, ], ], 'ListLowLatencyHlsManifests' => [ 'base' => NULL, 'refs' => [ 'OriginEndpointListConfiguration$LowLatencyHlsManifests' => '<p>A low-latency HLS manifest configuration.</p>', ], ], 'ListOriginEndpointsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListOriginEndpointsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListResourceMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListChannelGroupsRequest$MaxResults' => '<p>The maximum number of results to return in the response.</p>', 'ListChannelsRequest$MaxResults' => '<p>The maximum number of results to return in the response.</p>', 'ListOriginEndpointsRequest$MaxResults' => '<p>The maximum number of results to return in the response.</p>', ], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ManifestName' => [ 'base' => NULL, 'refs' => [ 'CreateDashManifestConfiguration$ManifestName' => '<p>A short string that\'s appended to the endpoint URL. The child manifest name creates a unique path to this endpoint.</p>', 'CreateHlsManifestConfiguration$ManifestName' => '<p>A short short string that\'s appended to the endpoint URL. The manifest name creates a unique path to this endpoint. If you don\'t enter a value, MediaPackage uses the default manifest name, index. MediaPackage automatically inserts the format extension, such as .m3u8. You can\'t use the same manifest name if you use HLS manifest and low-latency HLS manifest. The manifestName on the HLSManifest object overrides the manifestName you provided on the originEndpoint object.</p>', 'CreateHlsManifestConfiguration$ChildManifestName' => '<p>A short string that\'s appended to the endpoint URL. The child manifest name creates a unique path to this endpoint. If you don\'t enter a value, MediaPackage uses the default manifest name, index, with an added suffix to distinguish it from the manifest name. The manifestName on the HLSManifest object overrides the manifestName you provided on the originEndpoint object.</p>', 'CreateLowLatencyHlsManifestConfiguration$ManifestName' => '<p>A short short string that\'s appended to the endpoint URL. The manifest name creates a unique path to this endpoint. If you don\'t enter a value, MediaPackage uses the default manifest name, index. MediaPackage automatically inserts the format extension, such as .m3u8. You can\'t use the same manifest name if you use HLS manifest and low-latency HLS manifest. The manifestName on the HLSManifest object overrides the manifestName you provided on the originEndpoint object.</p>', 'CreateLowLatencyHlsManifestConfiguration$ChildManifestName' => '<p>A short string that\'s appended to the endpoint URL. The child manifest name creates a unique path to this endpoint. If you don\'t enter a value, MediaPackage uses the default manifest name, index, with an added suffix to distinguish it from the manifest name. The manifestName on the HLSManifest object overrides the manifestName you provided on the originEndpoint object.</p>', ], ], 'OriginEndpointListConfiguration' => [ 'base' => '<p>The configuration of the origin endpoint.</p>', 'refs' => [ 'OriginEndpointsList$member' => NULL, ], ], 'OriginEndpointsList' => [ 'base' => NULL, 'refs' => [ 'ListOriginEndpointsResponse$Items' => '<p>The objects being returned.</p>', ], ], 'PolicyText' => [ 'base' => NULL, 'refs' => [ 'GetChannelPolicyResponse$Policy' => '<p>The policy assigned to the channel.</p>', 'GetOriginEndpointPolicyResponse$Policy' => '<p>The policy assigned to the origin endpoint.</p>', 'PutChannelPolicyRequest$Policy' => '<p>The policy to attach to the specified channel.</p>', 'PutOriginEndpointPolicyRequest$Policy' => '<p>The policy to attach to the specified origin endpoint.</p>', ], ], 'PresetSpeke20Audio' => [ 'base' => NULL, 'refs' => [ 'EncryptionContractConfiguration$PresetSpeke20Audio' => '<p>A collection of audio encryption presets.</p> <p>Value description: </p> <ul> <li> <p>PRESET-AUDIO-1 - Use one content key to encrypt all of the audio tracks in your stream.</p> </li> <li> <p>PRESET-AUDIO-2 - Use one content key to encrypt all of the stereo audio tracks and one content key to encrypt all of the multichannel audio tracks.</p> </li> <li> <p>PRESET-AUDIO-3 - Use one content key to encrypt all of the stereo audio tracks, one content key to encrypt all of the multichannel audio tracks with 3 to 6 channels, and one content key to encrypt all of the multichannel audio tracks with more than 6 channels.</p> </li> <li> <p>SHARED - Use the same content key for all of the audio and video tracks in your stream.</p> </li> <li> <p>UNENCRYPTED - Don\'t encrypt any of the audio tracks in your stream.</p> </li> </ul>', ], ], 'PresetSpeke20Video' => [ 'base' => NULL, 'refs' => [ 'EncryptionContractConfiguration$PresetSpeke20Video' => '<p>A collection of video encryption presets.</p> <p>Value description: </p> <ul> <li> <p>PRESET-VIDEO-1 - Use one content key to encrypt all of the video tracks in your stream.</p> </li> <li> <p>PRESET-VIDEO-2 - Use one content key to encrypt all of the SD video tracks and one content key for all HD and higher resolutions video tracks.</p> </li> <li> <p>PRESET-VIDEO-3 - Use one content key to encrypt all of the SD video tracks, one content key for HD video tracks and one content key for all UHD video tracks.</p> </li> <li> <p>PRESET-VIDEO-4 - Use one content key to encrypt all of the SD video tracks, one content key for HD video tracks, one content key for all UHD1 video tracks and one content key for all UHD2 video tracks.</p> </li> <li> <p>PRESET-VIDEO-5 - Use one content key to encrypt all of the SD video tracks, one content key for HD1 video tracks, one content key for HD2 video tracks, one content key for all UHD1 video tracks and one content key for all UHD2 video tracks.</p> </li> <li> <p>PRESET-VIDEO-6 - Use one content key to encrypt all of the SD video tracks, one content key for HD1 video tracks, one content key for HD2 video tracks and one content key for all UHD video tracks.</p> </li> <li> <p>PRESET-VIDEO-7 - Use one content key to encrypt all of the SD+HD1 video tracks, one content key for HD2 video tracks and one content key for all UHD video tracks.</p> </li> <li> <p>PRESET-VIDEO-8 - Use one content key to encrypt all of the SD+HD1 video tracks, one content key for HD2 video tracks, one content key for all UHD1 video tracks and one content key for all UHD2 video tracks.</p> </li> <li> <p>SHARED - Use the same content key for all of the video and audio tracks in your stream.</p> </li> <li> <p>UNENCRYPTED - Don\'t encrypt any of the video tracks in your stream.</p> </li> </ul>', ], ], 'PutChannelPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutChannelPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutOriginEndpointPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutOriginEndpointPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'ResourceDescription' => [ 'base' => NULL, 'refs' => [ 'ChannelGroupListConfiguration$Description' => '<p>Any descriptive information that you want to add to the channel group for future identification purposes.</p>', 'ChannelListConfiguration$Description' => '<p>Any descriptive information that you want to add to the channel for future identification purposes.</p>', 'CreateChannelGroupRequest$Description' => '<p>Enter any descriptive text that helps you to identify the channel group.</p>', 'CreateChannelGroupResponse$Description' => '<p>The description for your channel group.</p>', 'CreateChannelRequest$Description' => '<p>Enter any descriptive text that helps you to identify the channel.</p>', 'CreateChannelResponse$Description' => '<p>The description for your channel.</p>', 'CreateOriginEndpointRequest$Description' => '<p>Enter any descriptive text that helps you to identify the origin endpoint.</p>', 'CreateOriginEndpointResponse$Description' => '<p>The description for your origin endpoint.</p>', 'GetChannelGroupResponse$Description' => '<p>The description for your channel group.</p>', 'GetChannelResponse$Description' => '<p>The description for your channel.</p>', 'GetOriginEndpointResponse$Description' => '<p>The description for your origin endpoint.</p>', 'OriginEndpointListConfiguration$Description' => '<p>Any descriptive information that you want to add to the origin endpoint for future identification purposes.</p>', 'UpdateChannelGroupRequest$Description' => '<p>Any descriptive information that you want to add to the channel group for future identification purposes.</p>', 'UpdateChannelGroupResponse$Description' => '<p>The description for your channel group.</p>', 'UpdateChannelRequest$Description' => '<p>Any descriptive information that you want to add to the channel for future identification purposes.</p>', 'UpdateChannelResponse$Description' => '<p>The description for your channel.</p>', 'UpdateOriginEndpointRequest$Description' => '<p>Any descriptive information that you want to add to the origin endpoint for future identification purposes.</p>', 'UpdateOriginEndpointResponse$Description' => '<p>The description of the origin endpoint.</p>', ], ], 'ResourceName' => [ 'base' => NULL, 'refs' => [ 'CreateChannelGroupRequest$ChannelGroupName' => '<p>The name that describes the channel group. The name is the primary identifier for the channel group, and must be unique for your account in the AWS Region. You can\'t use spaces in the name. You can\'t change the name after you create the channel group.</p>', 'CreateChannelRequest$ChannelGroupName' => '<p>The name that describes the channel group. The name is the primary identifier for the channel group, and must be unique for your account in the AWS Region.</p>', 'CreateChannelRequest$ChannelName' => '<p>The name that describes the channel. The name is the primary identifier for the channel, and must be unique for your account in the AWS Region and channel group. You can\'t change the name after you create the channel.</p>', 'CreateOriginEndpointRequest$ChannelGroupName' => '<p>The name that describes the channel group. The name is the primary identifier for the channel group, and must be unique for your account in the AWS Region.</p>', 'CreateOriginEndpointRequest$ChannelName' => '<p>The name that describes the channel. The name is the primary identifier for the channel, and must be unique for your account in the AWS Region and channel group. </p>', 'CreateOriginEndpointRequest$OriginEndpointName' => '<p>The name that describes the origin endpoint. The name is the primary identifier for the origin endpoint, and must be unique for your account in the AWS Region and channel. You can\'t use spaces in the name. You can\'t change the name after you create the endpoint.</p>', 'CreateOriginEndpointResponse$ChannelGroupName' => '<p>The name that describes the channel group. The name is the primary identifier for the channel group, and must be unique for your account in the AWS Region.</p>', 'CreateOriginEndpointResponse$ChannelName' => '<p>The name that describes the channel. The name is the primary identifier for the channel, and must be unique for your account in the AWS Region and channel group.</p>', 'CreateOriginEndpointResponse$OriginEndpointName' => '<p>The name that describes the origin endpoint. The name is the primary identifier for the origin endpoint, and and must be unique for your account in the AWS Region and channel.</p>', 'DeleteChannelGroupRequest$ChannelGroupName' => '<p>The name that describes the channel group. The name is the primary identifier for the channel group, and must be unique for your account in the AWS Region.</p>', 'DeleteChannelPolicyRequest$ChannelGroupName' => '<p>The name that describes the channel group. The name is the primary identifier for the channel group, and must be unique for your account in the AWS Region.</p>', 'DeleteChannelPolicyRequest$ChannelName' => '<p>The name that describes the channel. The name is the primary identifier for the channel, and must be unique for your account in the AWS Region and channel group.</p>', 'DeleteChannelRequest$ChannelGroupName' => '<p>The name that describes the channel group. The name is the primary identifier for the channel group, and must be unique for your account in the AWS Region.</p>', 'DeleteChannelRequest$ChannelName' => '<p>The name that describes the channel. The name is the primary identifier for the channel, and must be unique for your account in the AWS Region and channel group.</p>', 'DeleteOriginEndpointPolicyRequest$ChannelGroupName' => '<p>The name that describes the channel group. The name is the primary identifier for the channel group, and must be unique for your account in the AWS Region.</p>', 'DeleteOriginEndpointPolicyRequest$ChannelName' => '<p>The name that describes the channel. The name is the primary identifier for the channel, and must be unique for your account in the AWS Region and channel group. </p>', 'DeleteOriginEndpointPolicyRequest$OriginEndpointName' => '<p>The name that describes the origin endpoint. The name is the primary identifier for the origin endpoint, and and must be unique for your account in the AWS Region and channel. </p>', 'DeleteOriginEndpointRequest$ChannelGroupName' => '<p>The name that describes the channel group. The name is the primary identifier for the channel group, and must be unique for your account in the AWS Region.</p>', 'DeleteOriginEndpointRequest$ChannelName' => '<p>The name that describes the channel. The name is the primary identifier for the channel, and must be unique for your account in the AWS Region and channel group. </p>', 'DeleteOriginEndpointRequest$OriginEndpointName' => '<p>The name that describes the origin endpoint. The name is the primary identifier for the origin endpoint, and and must be unique for your account in the AWS Region and channel. </p>', 'GetChannelGroupRequest$ChannelGroupName' => '<p>The name that describes the channel group. The name is the primary identifier for the channel group, and must be unique for your account in the AWS Region.</p>', 'GetChannelPolicyRequest$ChannelGroupName' => '<p>The name that describes the channel group. The name is the primary identifier for the channel group, and must be unique for your account in the AWS Region.</p>', 'GetChannelPolicyRequest$ChannelName' => '<p>The name that describes the channel. The name is the primary identifier for the channel, and must be unique for your account in the AWS Region and channel group. </p>', 'GetChannelRequest$ChannelGroupName' => '<p>The name that describes the channel group. The name is the primary identifier for the channel group, and must be unique for your account in the AWS Region.</p>', 'GetChannelRequest$ChannelName' => '<p>The name that describes the channel. The name is the primary identifier for the channel, and must be unique for your account in the AWS Region and channel group. </p>', 'GetDashManifestConfiguration$ManifestName' => '<p>A short string that\'s appended to the endpoint URL. The manifest name creates a unique path to this endpoint. If you don\'t enter a value, MediaPackage uses the default manifest name, index. </p>', 'GetHlsManifestConfiguration$ManifestName' => '<p>A short short string that\'s appended to the endpoint URL. The manifest name creates a unique path to this endpoint. If you don\'t enter a value, MediaPackage uses the default manifest name, index. MediaPackage automatically inserts the format extension, such as .m3u8. You can\'t use the same manifest name if you use HLS manifest and low-latency HLS manifest. The manifestName on the HLSManifest object overrides the manifestName you provided on the originEndpoint object.</p>', 'GetHlsManifestConfiguration$ChildManifestName' => '<p>A short string that\'s appended to the endpoint URL. The child manifest name creates a unique path to this endpoint. If you don\'t enter a value, MediaPackage uses the default child manifest name, index_1. The manifestName on the HLSManifest object overrides the manifestName you provided on the originEndpoint object.</p>', 'GetLowLatencyHlsManifestConfiguration$ManifestName' => '<p>A short short string that\'s appended to the endpoint URL. The manifest name creates a unique path to this endpoint. If you don\'t enter a value, MediaPackage uses the default manifest name, index. MediaPackage automatically inserts the format extension, such as .m3u8. You can\'t use the same manifest name if you use HLS manifest and low-latency HLS manifest. The manifestName on the HLSManifest object overrides the manifestName you provided on the originEndpoint object.</p>', 'GetLowLatencyHlsManifestConfiguration$ChildManifestName' => '<p>A short string that\'s appended to the endpoint URL. The child manifest name creates a unique path to this endpoint. If you don\'t enter a value, MediaPackage uses the default child manifest name, index_1. The manifestName on the HLSManifest object overrides the manifestName you provided on the originEndpoint object.</p>', 'GetOriginEndpointPolicyRequest$ChannelGroupName' => '<p>The name that describes the channel group. The name is the primary identifier for the channel group, and must be unique for your account in the AWS Region.</p>', 'GetOriginEndpointPolicyRequest$ChannelName' => '<p>The name that describes the channel. The name is the primary identifier for the channel, and must be unique for your account in the AWS Region and channel group. </p>', 'GetOriginEndpointPolicyRequest$OriginEndpointName' => '<p>The name that describes the origin endpoint. The name is the primary identifier for the origin endpoint, and and must be unique for your account in the AWS Region and channel. </p>', 'GetOriginEndpointPolicyResponse$ChannelGroupName' => '<p>The name that describes the channel group. The name is the primary identifier for the channel group, and must be unique for your account in the AWS Region.</p>', 'GetOriginEndpointPolicyResponse$ChannelName' => '<p>The name that describes the channel. The name is the primary identifier for the channel, and must be unique for your account in the AWS Region and channel group.</p>', 'GetOriginEndpointPolicyResponse$OriginEndpointName' => '<p>The name that describes the origin endpoint. The name is the primary identifier for the origin endpoint, and and must be unique for your account in the AWS Region and channel.</p>', 'GetOriginEndpointRequest$ChannelGroupName' => '<p>The name that describes the channel group. The name is the primary identifier for the channel group, and must be unique for your account in the AWS Region.</p>', 'GetOriginEndpointRequest$ChannelName' => '<p>The name that describes the channel. The name is the primary identifier for the channel, and must be unique for your account in the AWS Region and channel group. </p>', 'GetOriginEndpointRequest$OriginEndpointName' => '<p>The name that describes the origin endpoint. The name is the primary identifier for the origin endpoint, and and must be unique for your account in the AWS Region and channel. </p>', 'GetOriginEndpointResponse$ChannelGroupName' => '<p>The name that describes the channel group. The name is the primary identifier for the channel group, and must be unique for your account in the AWS Region.</p>', 'GetOriginEndpointResponse$ChannelName' => '<p>The name that describes the channel. The name is the primary identifier for the channel, and must be unique for your account in the AWS Region and channel group.</p>', 'GetOriginEndpointResponse$OriginEndpointName' => '<p>The name that describes the origin endpoint. The name is the primary identifier for the origin endpoint, and and must be unique for your account in the AWS Region and channel.</p>', 'ListChannelsRequest$ChannelGroupName' => '<p>The name that describes the channel group. The name is the primary identifier for the channel group, and must be unique for your account in the AWS Region.</p>', 'ListDashManifestConfiguration$ManifestName' => '<p>A short string that\'s appended to the endpoint URL. The manifest name creates a unique path to this endpoint. If you don\'t enter a value, MediaPackage uses the default manifest name, index. </p>', 'ListHlsManifestConfiguration$ManifestName' => '<p>A short short string that\'s appended to the endpoint URL. The manifest name creates a unique path to this endpoint. If you don\'t enter a value, MediaPackage uses the default manifest name, index. MediaPackage automatically inserts the format extension, such as .m3u8. You can\'t use the same manifest name if you use HLS manifest and low-latency HLS manifest. The manifestName on the HLSManifest object overrides the manifestName you provided on the originEndpoint object.</p>', 'ListHlsManifestConfiguration$ChildManifestName' => '<p>A short string that\'s appended to the endpoint URL. The child manifest name creates a unique path to this endpoint. If you don\'t enter a value, MediaPackage uses the default child manifest name, index_1. The manifestName on the HLSManifest object overrides the manifestName you provided on the originEndpoint object.</p>', 'ListLowLatencyHlsManifestConfiguration$ManifestName' => '<p>A short short string that\'s appended to the endpoint URL. The manifest name creates a unique path to this endpoint. If you don\'t enter a value, MediaPackage uses the default manifest name, index. MediaPackage automatically inserts the format extension, such as .m3u8. You can\'t use the same manifest name if you use HLS manifest and low-latency HLS manifest. The manifestName on the HLSManifest object overrides the manifestName you provided on the originEndpoint object.</p>', 'ListLowLatencyHlsManifestConfiguration$ChildManifestName' => '<p>A short string that\'s appended to the endpoint URL. The child manifest name creates a unique path to this endpoint. If you don\'t enter a value, MediaPackage uses the default child manifest name, index_1. The manifestName on the HLSManifest object overrides the manifestName you provided on the originEndpoint object.</p>', 'ListOriginEndpointsRequest$ChannelGroupName' => '<p>The name that describes the channel group. The name is the primary identifier for the channel group, and must be unique for your account in the AWS Region.</p>', 'ListOriginEndpointsRequest$ChannelName' => '<p>The name that describes the channel. The name is the primary identifier for the channel, and must be unique for your account in the AWS Region and channel group. </p>', 'OriginEndpointListConfiguration$ChannelGroupName' => '<p>The name that describes the channel group. The name is the primary identifier for the channel group, and must be unique for your account in the AWS Region.</p>', 'OriginEndpointListConfiguration$ChannelName' => '<p>The name that describes the channel. The name is the primary identifier for the channel, and must be unique for your account in the AWS Region and channel group. </p>', 'OriginEndpointListConfiguration$OriginEndpointName' => '<p>The name that describes the origin endpoint. The name is the primary identifier for the origin endpoint, and and must be unique for your account in the AWS Region and channel. </p>', 'PutChannelPolicyRequest$ChannelGroupName' => '<p>The name that describes the channel group. The name is the primary identifier for the channel group, and must be unique for your account in the AWS Region.</p>', 'PutChannelPolicyRequest$ChannelName' => '<p>The name that describes the channel. The name is the primary identifier for the channel, and must be unique for your account in the AWS Region and channel group. </p>', 'PutOriginEndpointPolicyRequest$ChannelGroupName' => '<p>The name that describes the channel group. The name is the primary identifier for the channel group, and must be unique for your account in the AWS Region.</p>', 'PutOriginEndpointPolicyRequest$ChannelName' => '<p>The name that describes the channel. The name is the primary identifier for the channel, and must be unique for your account in the AWS Region and channel group. </p>', 'PutOriginEndpointPolicyRequest$OriginEndpointName' => '<p>The name that describes the origin endpoint. The name is the primary identifier for the origin endpoint, and and must be unique for your account in the AWS Region and channel. </p>', 'UpdateChannelGroupRequest$ChannelGroupName' => '<p>The name that describes the channel group. The name is the primary identifier for the channel group, and must be unique for your account in the AWS Region.</p>', 'UpdateChannelRequest$ChannelGroupName' => '<p>The name that describes the channel group. The name is the primary identifier for the channel group, and must be unique for your account in the AWS Region.</p>', 'UpdateChannelRequest$ChannelName' => '<p>The name that describes the channel. The name is the primary identifier for the channel, and must be unique for your account in the AWS Region and channel group. </p>', 'UpdateOriginEndpointRequest$ChannelGroupName' => '<p>The name that describes the channel group. The name is the primary identifier for the channel group, and must be unique for your account in the AWS Region.</p>', 'UpdateOriginEndpointRequest$ChannelName' => '<p>The name that describes the channel. The name is the primary identifier for the channel, and must be unique for your account in the AWS Region and channel group. </p>', 'UpdateOriginEndpointRequest$OriginEndpointName' => '<p>The name that describes the origin endpoint. The name is the primary identifier for the origin endpoint, and and must be unique for your account in the AWS Region and channel. </p>', 'UpdateOriginEndpointResponse$ChannelGroupName' => '<p>The name that describes the channel group. The name is the primary identifier for the channel group, and must be unique for your account in the AWS Region.</p>', 'UpdateOriginEndpointResponse$ChannelName' => '<p>The name that describes the channel. The name is the primary identifier for the channel, and must be unique for your account in the AWS Region and channel group.</p>', 'UpdateOriginEndpointResponse$OriginEndpointName' => '<p>The name that describes the origin endpoint. The name is the primary identifier for the origin endpoint, and and must be unique for your account in the AWS Region and channel.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The specified resource doesn\'t exist.</p>', 'refs' => [], ], 'ResourceTypeNotFound' => [ 'base' => NULL, 'refs' => [ 'ResourceNotFoundException$ResourceTypeNotFound' => '<p>The specified resource type wasn\'t found.</p>', ], ], 'Scte' => [ 'base' => '<p>The SCTE configuration.</p>', 'refs' => [ 'Segment$Scte' => '<p>The SCTE configuration options in the segment settings.</p>', ], ], 'ScteDash' => [ 'base' => '<p>The SCTE configuration.</p>', 'refs' => [ 'CreateDashManifestConfiguration$ScteDash' => '<p>The SCTE configuration.</p>', 'GetDashManifestConfiguration$ScteDash' => '<p>The SCTE configuration.</p>', ], ], 'ScteFilter' => [ 'base' => NULL, 'refs' => [ 'ScteFilterList$member' => NULL, ], ], 'ScteFilterList' => [ 'base' => NULL, 'refs' => [ 'Scte$ScteFilter' => '<p>The SCTE-35 message types that you want to be treated as ad markers in the output.</p>', ], ], 'ScteHls' => [ 'base' => '<p>The SCTE configuration.</p>', 'refs' => [ 'CreateHlsManifestConfiguration$ScteHls' => NULL, 'CreateLowLatencyHlsManifestConfiguration$ScteHls' => NULL, 'GetHlsManifestConfiguration$ScteHls' => NULL, 'GetLowLatencyHlsManifestConfiguration$ScteHls' => NULL, ], ], 'Segment' => [ 'base' => '<p>The segment configuration, including the segment name, duration, and other configuration values.</p>', 'refs' => [ 'CreateOriginEndpointRequest$Segment' => '<p>The segment configuration, including the segment name, duration, and other configuration values.</p>', 'CreateOriginEndpointResponse$Segment' => '<p>The segment configuration, including the segment name, duration, and other configuration values.</p>', 'GetOriginEndpointResponse$Segment' => NULL, 'UpdateOriginEndpointRequest$Segment' => '<p>The segment configuration, including the segment name, duration, and other configuration values.</p>', 'UpdateOriginEndpointResponse$Segment' => '<p>The segment configuration, including the segment name, duration, and other configuration values.</p>', ], ], 'SegmentSegmentDurationSecondsInteger' => [ 'base' => NULL, 'refs' => [ 'Segment$SegmentDurationSeconds' => '<p>The duration (in seconds) of each segment. Enter a value equal to, or a multiple of, the input segment duration. If the value that you enter is different from the input segment duration, MediaPackage rounds segments to the nearest multiple of the input segment duration.</p>', ], ], 'SegmentSegmentNameString' => [ 'base' => NULL, 'refs' => [ 'Segment$SegmentName' => '<p>The name that describes the segment. The name is the base name of the segment used in all content manifests inside of the endpoint. You can\'t use spaces in the name.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>The request would cause a service quota to be exceeded.</p>', 'refs' => [], ], 'SpekeKeyProvider' => [ 'base' => '<p>The parameters for the SPEKE key provider.</p>', 'refs' => [ 'Encryption$SpekeKeyProvider' => '<p>The parameters for the SPEKE key provider.</p>', ], ], 'SpekeKeyProviderDrmSystemsList' => [ 'base' => NULL, 'refs' => [ 'SpekeKeyProvider$DrmSystems' => '<p>The DRM solution provider you\'re using to protect your content during distribution.</p>', ], ], 'SpekeKeyProviderResourceIdString' => [ 'base' => NULL, 'refs' => [ 'SpekeKeyProvider$ResourceId' => '<p>The unique identifier for the content. The service sends this to the key server to identify the current endpoint. How unique you make this depends on how fine-grained you want access controls to be. The service does not permit you to use the same ID for two simultaneous encryption processes. The resource ID is also known as the content ID.</p> <p>The following example shows a resource ID: <code>MovieNight20171126093045</code> </p>', ], ], 'SpekeKeyProviderRoleArnString' => [ 'base' => NULL, 'refs' => [ 'SpekeKeyProvider$RoleArn' => '<p>The ARN for the IAM role granted by the key provider that provides access to the key provider API. This role must have a trust policy that allows MediaPackage to assume the role, and it must have a sufficient permissions policy to allow access to the specific key retrieval URL. Get this from your DRM solution provider.</p> <p>Valid format: <code>arn:aws:iam::{accountID}:role/{name}</code>. The following example shows a role ARN: <code>arn:aws:iam::444455556666:role/SpekeAccess</code> </p>', ], ], 'SpekeKeyProviderUrlString' => [ 'base' => NULL, 'refs' => [ 'SpekeKeyProvider$Url' => '<p>The URL of the API Gateway proxy that you set up to talk to your key server. The API Gateway proxy must reside in the same AWS Region as MediaPackage and must start with https://.</p> <p>The following example shows a URL: <code>https://1wm2dx1f33.execute-api.us-west-2.amazonaws.com/SpekeSample/copyProtection</code> </p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => NULL, 'ChannelGroupListConfiguration$ChannelGroupName' => '<p>The name that describes the channel group. The name is the primary identifier for the channel group, and must be unique for your account in the AWS Region.</p>', 'ChannelGroupListConfiguration$Arn' => '<p>The Amazon Resource Name (ARN) associated with the resource.</p>', 'ChannelListConfiguration$Arn' => '<p>The Amazon Resource Name (ARN) associated with the resource.</p>', 'ChannelListConfiguration$ChannelName' => '<p>The name that describes the channel. The name is the primary identifier for the channel, and must be unique for your account in the AWS Region and channel group. </p>', 'ChannelListConfiguration$ChannelGroupName' => '<p>The name that describes the channel group. The name is the primary identifier for the channel group, and must be unique for your account in the AWS Region.</p>', 'ConflictException$Message' => NULL, 'CreateChannelGroupResponse$ChannelGroupName' => '<p>The name that describes the channel group. The name is the primary identifier for the channel group, and must be unique for your account in the AWS Region.</p>', 'CreateChannelGroupResponse$Arn' => '<p>The Amazon Resource Name (ARN) associated with the resource.</p>', 'CreateChannelGroupResponse$EgressDomain' => '<p>The output domain where the source stream should be sent. Integrate the egress domain with a downstream CDN (such as Amazon CloudFront) or playback device.</p>', 'CreateChannelResponse$Arn' => '<p>The Amazon Resource Name (ARN) associated with the resource.</p>', 'CreateChannelResponse$ChannelName' => '<p>The name that describes the channel. The name is the primary identifier for the channel, and must be unique for your account in the AWS Region and channel group.</p>', 'CreateChannelResponse$ChannelGroupName' => '<p>The name that describes the channel group. The name is the primary identifier for the channel group, and must be unique for your account in the AWS Region.</p>', 'CreateOriginEndpointResponse$Arn' => '<p>The Amazon Resource Name (ARN) associated with the resource.</p>', 'GetChannelGroupResponse$ChannelGroupName' => '<p>The name that describes the channel group. The name is the primary identifier for the channel group, and must be unique for your account in the AWS Region.</p>', 'GetChannelGroupResponse$Arn' => '<p>The Amazon Resource Name (ARN) associated with the resource.</p>', 'GetChannelGroupResponse$EgressDomain' => '<p>The output domain where the source stream should be sent. Integrate the domain with a downstream CDN (such as Amazon CloudFront) or playback device.</p>', 'GetChannelPolicyResponse$ChannelGroupName' => '<p>The name that describes the channel group. The name is the primary identifier for the channel group, and must be unique for your account in the AWS Region.</p>', 'GetChannelPolicyResponse$ChannelName' => '<p>The name that describes the channel. The name is the primary identifier for the channel, and must be unique for your account in the AWS Region and channel group.</p>', 'GetChannelResponse$Arn' => '<p>The Amazon Resource Name (ARN) associated with the resource.</p>', 'GetChannelResponse$ChannelName' => '<p>The name that describes the channel. The name is the primary identifier for the channel, and must be unique for your account in the AWS Region and channel group.</p>', 'GetChannelResponse$ChannelGroupName' => '<p>The name that describes the channel group. The name is the primary identifier for the channel group, and must be unique for your account in the AWS Region.</p>', 'GetDashManifestConfiguration$Url' => '<p>The egress domain URL for stream delivery from MediaPackage.</p>', 'GetHlsManifestConfiguration$Url' => '<p>The egress domain URL for stream delivery from MediaPackage.</p>', 'GetLowLatencyHlsManifestConfiguration$Url' => '<p>The egress domain URL for stream delivery from MediaPackage.</p>', 'GetOriginEndpointResponse$Arn' => '<p>The Amazon Resource Name (ARN) associated with the resource.</p>', 'IngestEndpoint$Id' => '<p>The system-generated unique identifier for the IngestEndpoint.</p>', 'IngestEndpoint$Url' => '<p>The ingest domain URL where the source stream should be sent.</p>', 'InternalServerException$Message' => NULL, 'ListChannelGroupsRequest$NextToken' => '<p>The pagination token from the GET list request. Use the token to fetch the next page of results.</p>', 'ListChannelGroupsResponse$NextToken' => '<p>The pagination token from the GET list request. Use the token to fetch the next page of results.</p>', 'ListChannelsRequest$NextToken' => '<p>The pagination token from the GET list request. Use the token to fetch the next page of results.</p>', 'ListChannelsResponse$NextToken' => '<p>The pagination token from the GET list request.</p>', 'ListDashManifestConfiguration$Url' => '<p>The egress domain URL for stream delivery from MediaPackage.</p>', 'ListHlsManifestConfiguration$Url' => '<p>The egress domain URL for stream delivery from MediaPackage.</p>', 'ListLowLatencyHlsManifestConfiguration$Url' => '<p>The egress domain URL for stream delivery from MediaPackage.</p>', 'ListOriginEndpointsRequest$NextToken' => '<p>The pagination token from the GET list request. Use the token to fetch the next page of results.</p>', 'ListOriginEndpointsResponse$NextToken' => '<p>The pagination token from the GET list request. Use the token to fetch the next page of results.</p>', 'OriginEndpointListConfiguration$Arn' => '<p>The Amazon Resource Name (ARN) associated with the resource.</p>', 'ResourceNotFoundException$Message' => NULL, 'ServiceQuotaExceededException$Message' => NULL, 'ThrottlingException$Message' => NULL, 'UpdateChannelGroupResponse$ChannelGroupName' => '<p>The name that describes the channel group. The name is the primary identifier for the channel group, and must be unique for your account in the AWS Region.</p>', 'UpdateChannelGroupResponse$Arn' => '<p>The Amazon Resource Name (ARN) associated with the resource.</p>', 'UpdateChannelGroupResponse$EgressDomain' => '<p>The output domain where the source stream is sent. Integrate the domain with a downstream CDN (such as Amazon CloudFront) or playback device.</p>', 'UpdateChannelResponse$Arn' => '<p>The Amazon Resource Name (ARN) associated with the resource.</p>', 'UpdateChannelResponse$ChannelName' => '<p>The name that describes the channel. The name is the primary identifier for the channel, and must be unique for your account in the AWS Region and channel group.</p>', 'UpdateChannelResponse$ChannelGroupName' => '<p>The name that describes the channel group. The name is the primary identifier for the channel group, and must be unique for your account in the AWS Region.</p>', 'UpdateOriginEndpointResponse$Arn' => '<p>The ARN associated with the resource.</p>', 'ValidationException$Message' => NULL, ], ], 'TagArn' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$ResourceArn' => '<p>The ARN of the CloudWatch resource that you want to view tags for.</p>', 'TagResourceRequest$ResourceArn' => '<p>The ARN of the MediaPackage resource that you\'re adding tags to.</p>', 'UntagResourceRequest$ResourceArn' => '<p>The ARN of the MediaPackage resource that you\'re removing tags from.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'TagMap$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>The list of tag keys to remove from the resource.</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'CreateChannelGroupRequest$Tags' => '<p>A comma-separated list of tag key:value pairs that you define. For example:</p> <p> <code>"Key1": "Value1",</code> </p> <p> <code>"Key2": "Value2"</code> </p>', 'CreateChannelGroupResponse$Tags' => '<p>The comma-separated list of tag key:value pairs assigned to the channel group.</p>', 'CreateChannelRequest$Tags' => '<p>A comma-separated list of tag key:value pairs that you define. For example:</p> <p> <code>"Key1": "Value1",</code> </p> <p> <code>"Key2": "Value2"</code> </p>', 'CreateChannelResponse$Tags' => '<p>The comma-separated list of tag key:value pairs assigned to the channel.</p>', 'CreateOriginEndpointRequest$Tags' => '<p>A comma-separated list of tag key:value pairs that you define. For example:</p> <p> <code>"Key1": "Value1",</code> </p> <p> <code>"Key2": "Value2"</code> </p>', 'CreateOriginEndpointResponse$Tags' => '<p>The comma-separated list of tag key:value pairs assigned to the origin endpoint.</p>', 'GetChannelGroupResponse$Tags' => '<p>The comma-separated list of tag key:value pairs assigned to the channel group.</p>', 'GetChannelResponse$Tags' => '<p>The comma-separated list of tag key:value pairs assigned to the channel.</p>', 'GetOriginEndpointResponse$Tags' => '<p>The comma-separated list of tag key:value pairs assigned to the origin endpoint.</p>', 'ListTagsForResourceResponse$Tags' => '<p>Contains a map of the key-value pairs for the resource tag or tags assigned to the resource.</p>', 'TagResourceRequest$Tags' => '<p>Contains a map of the key-value pairs for the resource tag or tags assigned to the resource.</p>', 'UpdateChannelGroupResponse$Tags' => '<p>The comma-separated list of tag key:value pairs assigned to the channel group.</p>', 'UpdateChannelResponse$Tags' => '<p>The comma-separated list of tag key:value pairs assigned to the channel.</p>', 'UpdateOriginEndpointResponse$Tags' => '<p>The comma-separated list of tag key:value pairs assigned to the origin endpoint.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagMap$value' => NULL, ], ], 'ThrottlingException' => [ 'base' => '<p>The request throughput limit was exceeded.</p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'ChannelGroupListConfiguration$CreatedAt' => '<p>The date and time the channel group was created.</p>', 'ChannelGroupListConfiguration$ModifiedAt' => '<p>The date and time the channel group was modified.</p>', 'ChannelListConfiguration$CreatedAt' => '<p>The date and time the channel was created.</p>', 'ChannelListConfiguration$ModifiedAt' => '<p>The date and time the channel was modified.</p>', 'CreateChannelGroupResponse$CreatedAt' => '<p>The date and time the channel group was created.</p>', 'CreateChannelGroupResponse$ModifiedAt' => '<p>The date and time the channel group was modified.</p>', 'CreateChannelResponse$CreatedAt' => '<p>The date and time the channel was created.</p>', 'CreateChannelResponse$ModifiedAt' => '<p>The date and time the channel was modified.</p>', 'CreateOriginEndpointResponse$CreatedAt' => '<p>The date and time the origin endpoint was created.</p>', 'CreateOriginEndpointResponse$ModifiedAt' => '<p>The date and time the origin endpoint was modified.</p>', 'FilterConfiguration$Start' => '<p>Optionally specify the start time for all of your manifest egress requests. When you include start time, note that you cannot use start time query parameters for this manifest\'s endpoint URL.</p>', 'FilterConfiguration$End' => '<p>Optionally specify the end time for all of your manifest egress requests. When you include end time, note that you cannot use end time query parameters for this manifest\'s endpoint URL.</p>', 'GetChannelGroupResponse$CreatedAt' => '<p>The date and time the channel group was created.</p>', 'GetChannelGroupResponse$ModifiedAt' => '<p>The date and time the channel group was modified.</p>', 'GetChannelResponse$CreatedAt' => '<p>The date and time the channel was created.</p>', 'GetChannelResponse$ModifiedAt' => '<p>The date and time the channel was modified.</p>', 'GetOriginEndpointResponse$CreatedAt' => '<p>The date and time the origin endpoint was created.</p>', 'GetOriginEndpointResponse$ModifiedAt' => '<p>The date and time the origin endpoint was modified.</p>', 'OriginEndpointListConfiguration$CreatedAt' => '<p>The date and time the origin endpoint was created.</p>', 'OriginEndpointListConfiguration$ModifiedAt' => '<p>The date and time the origin endpoint was modified.</p>', 'UpdateChannelGroupResponse$CreatedAt' => '<p>The date and time the channel group was created.</p>', 'UpdateChannelGroupResponse$ModifiedAt' => '<p>The date and time the channel group was modified.</p>', 'UpdateChannelResponse$CreatedAt' => '<p>The date and time the channel was created.</p>', 'UpdateChannelResponse$ModifiedAt' => '<p>The date and time the channel was modified.</p>', 'UpdateOriginEndpointResponse$CreatedAt' => '<p>The date and time the origin endpoint was created.</p>', 'UpdateOriginEndpointResponse$ModifiedAt' => '<p>The date and time the origin endpoint was modified.</p>', ], ], 'TsEncryptionMethod' => [ 'base' => NULL, 'refs' => [ 'EncryptionMethod$TsEncryptionMethod' => '<p>The encryption method to use.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateChannelGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateChannelGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateChannelResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateOriginEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateOriginEndpointRequestStartoverWindowSecondsInteger' => [ 'base' => NULL, 'refs' => [ 'UpdateOriginEndpointRequest$StartoverWindowSeconds' => '<p>The size of the window (in seconds) to create a window of the live stream that\'s available for on-demand viewing. Viewers can start-over or catch-up on content that falls within the window. The maximum startover window is 1,209,600 seconds (14 days).</p>', ], ], 'UpdateOriginEndpointResponse' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>The input failed to meet the constraints specified by the AWS service.</p>', 'refs' => [], ], 'ValidationExceptionType' => [ 'base' => NULL, 'refs' => [ 'ValidationException$ValidationExceptionType' => '<p>The type of ValidationException.</p>', ], ], ],];
