<?php
// This file was auto-generated from sdk-root/src/data/mediatailor/2018-04-23/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Use the AWS Elemental MediaTailor SDKs and CLI to configure scalable ad insertion and linear channels. With MediaTailor, you can assemble existing content into a linear stream and serve targeted ads to viewers while maintaining broadcast quality in over-the-top (OTT) video applications. For information about using the service, including detailed information about the settings covered in this guide, see the <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/">AWS Elemental MediaTailor User Guide</a>.</p> <p>Through the SDKs and the CLI you manage AWS Elemental MediaTailor configurations and channels the same as you do through the console. For example, you specify ad insertion behavior and mapping information for the origin server and the ad decision server (ADS).</p>', 'operations' => [ 'ConfigureLogsForChannel' => '<p>Configures Amazon CloudWatch log settings for a channel.</p>', 'ConfigureLogsForPlaybackConfiguration' => '<p>Amazon CloudWatch log settings for a playback configuration.</p>', 'CreateChannel' => '<p>Creates a channel. For information about MediaTailor channels, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-channels.html">Working with channels</a> in the <i>MediaTailor User Guide</i>.</p>', 'CreateLiveSource' => '<p>The live source configuration.</p>', 'CreatePrefetchSchedule' => '<p>Creates a prefetch schedule for a playback configuration. A prefetch schedule allows you to tell MediaTailor to fetch and prepare certain ads before an ad break happens. For more information about ad prefetching, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/prefetching-ads.html">Using ad prefetching</a> in the <i>MediaTailor User Guide</i>.</p>', 'CreateProgram' => '<p>Creates a program within a channel. For information about programs, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-programs.html">Working with programs</a> in the <i>MediaTailor User Guide</i>.</p>', 'CreateSourceLocation' => '<p>Creates a source location. A source location is a container for sources. For more information about source locations, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-source-locations.html">Working with source locations</a> in the <i>MediaTailor User Guide</i>.</p>', 'CreateVodSource' => '<p>The VOD source configuration parameters.</p>', 'DeleteChannel' => '<p>Deletes a channel. For information about MediaTailor channels, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-channels.html">Working with channels</a> in the <i>MediaTailor User Guide</i>.</p>', 'DeleteChannelPolicy' => '<p>The channel policy to delete.</p>', 'DeleteLiveSource' => '<p>The live source to delete.</p>', 'DeletePlaybackConfiguration' => '<p>Deletes a playback configuration. For information about MediaTailor configurations, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/configurations.html">Working with configurations in AWS Elemental MediaTailor</a>.</p>', 'DeletePrefetchSchedule' => '<p>Deletes a prefetch schedule for a specific playback configuration. If you call <code>DeletePrefetchSchedule</code> on an expired prefetch schedule, MediaTailor returns an HTTP 404 status code. For more information about ad prefetching, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/prefetching-ads.html">Using ad prefetching</a> in the <i>MediaTailor User Guide</i>.</p>', 'DeleteProgram' => '<p>Deletes a program within a channel. For information about programs, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-programs.html">Working with programs</a> in the <i>MediaTailor User Guide</i>.</p>', 'DeleteSourceLocation' => '<p>Deletes a source location. A source location is a container for sources. For more information about source locations, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-source-locations.html">Working with source locations</a> in the <i>MediaTailor User Guide</i>.</p>', 'DeleteVodSource' => '<p>The video on demand (VOD) source to delete.</p>', 'DescribeChannel' => '<p>Describes a channel. For information about MediaTailor channels, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-channels.html">Working with channels</a> in the <i>MediaTailor User Guide</i>.</p>', 'DescribeLiveSource' => '<p>The live source to describe.</p>', 'DescribeProgram' => '<p>Describes a program within a channel. For information about programs, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-programs.html">Working with programs</a> in the <i>MediaTailor User Guide</i>.</p>', 'DescribeSourceLocation' => '<p>Describes a source location. A source location is a container for sources. For more information about source locations, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-source-locations.html">Working with source locations</a> in the <i>MediaTailor User Guide</i>.</p>', 'DescribeVodSource' => '<p>Provides details about a specific video on demand (VOD) source in a specific source location.</p>', 'GetChannelPolicy' => '<p>Returns the channel\'s IAM policy. IAM policies are used to control access to your channel.</p>', 'GetChannelSchedule' => '<p>Retrieves information about your channel\'s schedule.</p>', 'GetPlaybackConfiguration' => '<p>Retrieves a playback configuration. For information about MediaTailor configurations, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/configurations.html">Working with configurations in AWS Elemental MediaTailor</a>.</p>', 'GetPrefetchSchedule' => '<p>Retrieves a prefetch schedule for a playback configuration. A prefetch schedule allows you to tell MediaTailor to fetch and prepare certain ads before an ad break happens. For more information about ad prefetching, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/prefetching-ads.html">Using ad prefetching</a> in the <i>MediaTailor User Guide</i>.</p>', 'ListAlerts' => '<p>Lists the alerts that are associated with a MediaTailor channel assembly resource.</p>', 'ListChannels' => '<p>Retrieves information about the channels that are associated with the current AWS account.</p>', 'ListLiveSources' => '<p>Lists the live sources contained in a source location. A source represents a piece of content.</p>', 'ListPlaybackConfigurations' => '<p>Retrieves existing playback configurations. For information about MediaTailor configurations, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/configurations.html">Working with Configurations in AWS Elemental MediaTailor</a>.</p>', 'ListPrefetchSchedules' => '<p>Lists the prefetch schedules for a playback configuration.</p>', 'ListSourceLocations' => '<p>Lists the source locations for a channel. A source location defines the host server URL, and contains a list of sources.</p>', 'ListTagsForResource' => '<p>A list of tags that are associated with this resource. Tags are key-value pairs that you can associate with Amazon resources to help with organization, access control, and cost tracking. For more information, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor Resources</a>.</p>', 'ListVodSources' => '<p>Lists the VOD sources contained in a source location. A source represents a piece of content.</p>', 'PutChannelPolicy' => '<p>Creates an IAM policy for the channel. IAM policies are used to control access to your channel.</p>', 'PutPlaybackConfiguration' => '<p>Creates a playback configuration. For information about MediaTailor configurations, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/configurations.html">Working with configurations in AWS Elemental MediaTailor</a>.</p>', 'StartChannel' => '<p>Starts a channel. For information about MediaTailor channels, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-channels.html">Working with channels</a> in the <i>MediaTailor User Guide</i>.</p>', 'StopChannel' => '<p>Stops a channel. For information about MediaTailor channels, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-channels.html">Working with channels</a> in the <i>MediaTailor User Guide</i>.</p>', 'TagResource' => '<p>The resource to tag. Tags are key-value pairs that you can associate with Amazon resources to help with organization, access control, and cost tracking. For more information, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor Resources</a>.</p>', 'UntagResource' => '<p>The resource to untag.</p>', 'UpdateChannel' => '<p>Updates a channel. For information about MediaTailor channels, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-channels.html">Working with channels</a> in the <i>MediaTailor User Guide</i>.</p>', 'UpdateLiveSource' => '<p>Updates a live source\'s configuration.</p>', 'UpdateProgram' => '<p>Updates a program within a channel.</p>', 'UpdateSourceLocation' => '<p>Updates a source location. A source location is a container for sources. For more information about source locations, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-source-locations.html">Working with source locations</a> in the <i>MediaTailor User Guide</i>.</p>', 'UpdateVodSource' => '<p>Updates a VOD source\'s configuration.</p>', ], 'shapes' => [ 'AccessConfiguration' => [ 'base' => '<p>Access configuration parameters.</p>', 'refs' => [ 'CreateSourceLocationRequest$AccessConfiguration' => '<p>Access configuration parameters. Configures the type of authentication used to access content from your source location.</p>', 'CreateSourceLocationResponse$AccessConfiguration' => '<p>Access configuration parameters. Configures the type of authentication used to access content from your source location.</p>', 'DescribeSourceLocationResponse$AccessConfiguration' => '<p>The access configuration for the source location.</p>', 'SourceLocation$AccessConfiguration' => '<p>The access configuration for the source location.</p>', 'UpdateSourceLocationRequest$AccessConfiguration' => '<p>Access configuration parameters. Configures the type of authentication used to access content from your source location.</p>', 'UpdateSourceLocationResponse$AccessConfiguration' => '<p>Access configuration parameters. Configures the type of authentication used to access content from your source location.</p>', ], ], 'AccessType' => [ 'base' => NULL, 'refs' => [ 'AccessConfiguration$AccessType' => '<p>The type of authentication used to access content from <code>HttpConfiguration::BaseUrl</code> on your source location.</p> <p> <code>S3_SIGV4</code> - AWS Signature Version 4 authentication for Amazon S3 hosted virtual-style access. If your source location base URL is an Amazon S3 bucket, MediaTailor can use AWS Signature Version 4 (SigV4) authentication to access the bucket where your source content is stored. Your MediaTailor source location baseURL must follow the S3 virtual hosted-style request URL format. For example, https://bucket-name.s3.Region.amazonaws.com/key-name.</p> <p>Before you can use <code>S3_SIGV4</code>, you must meet these requirements:</p> <p>• You must allow MediaTailor to access your S3 bucket by granting mediatailor.amazonaws.com principal access in IAM. For information about configuring access in IAM, see Access management in the IAM User Guide.</p> <p>• The mediatailor.amazonaws.com service principal must have permissions to read all top level manifests referenced by the VodSource packaging configurations.</p> <p>• The caller of the API must have s3:GetObject IAM permissions to read all top level manifests referenced by your MediaTailor VodSource packaging configurations.</p> <p> <code>AUTODETECT_SIGV4</code> - AWS Signature Version 4 authentication for a set of supported services: MediaPackage Version 2 and Amazon S3 hosted virtual-style access. If your source location base URL is a MediaPackage Version 2 endpoint or an Amazon S3 bucket, MediaTailor can use AWS Signature Version 4 (SigV4) authentication to access the resource where your source content is stored.</p> <p>Before you can use <code>AUTODETECT_SIGV4</code> with a MediaPackage Version 2 endpoint, you must meet these requirements:</p> <p>• You must grant MediaTailor access to your MediaPackage endpoint by granting <code>mediatailor.amazonaws.com</code> principal access in an Origin Access policy on the endpoint.</p> <p>• Your MediaTailor source location base URL must be a MediaPackage V2 endpoint.</p> <p>• The caller of the API must have <code>mediapackagev2:GetObject</code> IAM permissions to read all top level manifests referenced by the MediaTailor source packaging configurations.</p> <p>Before you can use <code>AUTODETECT_SIGV4</code> with an Amazon S3 bucket, you must meet these requirements:</p> <p>• You must grant MediaTailor access to your S3 bucket by granting <code>mediatailor.amazonaws.com</code> principal access in IAM. For more information about configuring access in IAM, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access management</a> in the <i>IAM User Guide.</i>.</p> <p>• The <code>mediatailor.amazonaws.com</code> service principal must have permissions to read all top-level manifests referenced by the <code>VodSource</code> packaging configurations.</p> <p>• The caller of the API must have <code>s3:GetObject</code> IAM permissions to read all top level manifests referenced by your MediaTailor <code>VodSource</code> packaging configurations.</p>', ], ], 'AdBreak' => [ 'base' => '<p>Ad break configuration parameters.</p>', 'refs' => [ '__listOfAdBreak$member' => NULL, ], ], 'AdBreakMetadataList' => [ 'base' => NULL, 'refs' => [ 'AdBreak$AdBreakMetadata' => '<p>Defines a list of key/value pairs that MediaTailor generates within the <code>EXT-X-ASSET</code>tag for <code>SCTE35_ENHANCED</code> output.</p>', ], ], 'AdBreakOpportunities' => [ 'base' => '<p>The list of ad break opportunities detected within the VOD source.</p>', 'refs' => [ 'DescribeVodSourceResponse$AdBreakOpportunities' => '<p>The ad break opportunities within the VOD source.</p>', ], ], 'AdBreakOpportunity' => [ 'base' => '<p>A location at which a zero-duration ad marker was detected in a VOD source manifest.</p>', 'refs' => [ 'AdBreakOpportunities$member' => NULL, ], ], 'AdMarkerPassthrough' => [ 'base' => '<p>For HLS, when set to <code>true</code>, MediaTailor passes through <code>EXT-X-CUE-IN</code>, <code>EXT-X-CUE-OUT</code>, and <code>EXT-X-SPLICEPOINT-SCTE35</code> ad markers from the origin manifest to the MediaTailor personalized manifest.</p> <p>No logic is applied to these ad markers. For example, if <code>EXT-X-CUE-OUT</code> has a value of <code>60</code>, but no ads are filled for that ad break, MediaTailor will not set the value to <code>0</code>.</p>', 'refs' => [ 'ManifestProcessingRules$AdMarkerPassthrough' => '<p>For HLS, when set to <code>true</code>, MediaTailor passes through <code>EXT-X-CUE-IN</code>, <code>EXT-X-CUE-OUT</code>, and <code>EXT-X-SPLICEPOINT-SCTE35</code> ad markers from the origin manifest to the MediaTailor personalized manifest.</p> <p>No logic is applied to these ad markers. For example, if <code>EXT-X-CUE-OUT</code> has a value of <code>60</code>, but no ads are filled for that ad break, MediaTailor will not set the value to <code>0</code>.</p>', ], ], 'AdMarkupType' => [ 'base' => NULL, 'refs' => [ 'adMarkupTypes$member' => NULL, ], ], 'Alert' => [ 'base' => '<p>Alert configuration parameters.</p>', 'refs' => [ '__listOfAlert$member' => NULL, ], ], 'AlertCategory' => [ 'base' => NULL, 'refs' => [ 'Alert$Category' => '<p>The category that MediaTailor assigns to the alert.</p>', ], ], 'AlternateMedia' => [ 'base' => '<p>A playlist of media (VOD and/or live) to be played instead of the default media on a particular program.</p>', 'refs' => [ '__listOfAlternateMedia$member' => NULL, ], ], 'AudienceMedia' => [ 'base' => '<p>An AudienceMedia object contains an Audience and a list of AlternateMedia.</p>', 'refs' => [ '__listOfAudienceMedia$member' => NULL, ], ], 'Audiences' => [ 'base' => NULL, 'refs' => [ 'Channel$Audiences' => '<p>The list of audiences defined in channel.</p>', 'CreateChannelRequest$Audiences' => '<p>The list of audiences defined in channel.</p>', 'CreateChannelResponse$Audiences' => '<p>The list of audiences defined in channel.</p>', 'DescribeChannelResponse$Audiences' => '<p>The list of audiences defined in channel.</p>', 'ScheduleEntry$Audiences' => '<p>The list of audiences defined in ScheduleEntry.</p>', 'UpdateChannelRequest$Audiences' => '<p>The list of audiences defined in channel.</p>', 'UpdateChannelResponse$Audiences' => '<p>The list of audiences defined in channel.</p>', ], ], 'AvailMatchingCriteria' => [ 'base' => '<p>MediaTailor only places (consumes) prefetched ads if the ad break meets the criteria defined by the dynamic variables. This gives you granular control over which ad break to place the prefetched ads into.</p> <p>As an example, let\'s say that you set <code>DynamicVariable</code> to <code>scte.event_id</code> and <code>Operator</code> to <code>EQUALS</code>, and your playback configuration has an ADS URL of <code>https://my.ads.server.com/path?&amp;podId=[scte.avail_num]&amp;event=[scte.event_id]&amp;duration=[session.avail_duration_secs]</code>. And the prefetch request to the ADS contains these values <code>https://my.ads.server.com/path?&amp;podId=3&amp;event=my-awesome-event&amp;duration=30</code>. MediaTailor will only insert the prefetched ads into the ad break if has a SCTE marker with an event id of <code>my-awesome-event</code>, since it must match the event id that MediaTailor uses to query the ADS.</p> <p>You can specify up to five <code>AvailMatchingCriteria</code>. If you specify multiple <code>AvailMatchingCriteria</code>, MediaTailor combines them to match using a logical <code>AND</code>. You can model logical <code>OR</code> combinations by creating multiple prefetch schedules.</p>', 'refs' => [ '__listOfAvailMatchingCriteria$member' => NULL, ], ], 'AvailSuppression' => [ 'base' => '<p>The configuration for avail suppression, also known as ad suppression. For more information about ad suppression, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/ad-behavior.html">Ad Suppression</a>.</p>', 'refs' => [ 'GetPlaybackConfigurationResponse$AvailSuppression' => '<p>The configuration for avail suppression, also known as ad suppression. For more information about ad suppression, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/ad-behavior.html">Ad Suppression</a>.</p>', 'PlaybackConfiguration$AvailSuppression' => '<p>The configuration for avail suppression, also known as ad suppression. For more information about ad suppression, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/ad-behavior.html">Ad Suppression</a>.</p>', 'PutPlaybackConfigurationRequest$AvailSuppression' => '<p>The configuration for avail suppression, also known as ad suppression. For more information about ad suppression, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/ad-behavior.html">Ad Suppression</a>.</p>', 'PutPlaybackConfigurationResponse$AvailSuppression' => '<p>The configuration for avail suppression, also known as ad suppression. For more information about ad suppression, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/ad-behavior.html">Ad Suppression</a>.</p>', ], ], 'BadRequestException' => [ 'base' => '<p>A request contains unexpected data.</p>', 'refs' => [], ], 'Bumper' => [ 'base' => '<p>The configuration for bumpers. Bumpers are short audio or video clips that play at the start or before the end of an ad break. To learn more about bumpers, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/bumpers.html">Bumpers</a>.</p>', 'refs' => [ 'GetPlaybackConfigurationResponse$Bumper' => '<p>The configuration for bumpers. Bumpers are short audio or video clips that play at the start or before the end of an ad break. To learn more about bumpers, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/bumpers.html">Bumpers</a>.</p>', 'PlaybackConfiguration$Bumper' => '<p>The configuration for bumpers. Bumpers are short audio or video clips that play at the start or before the end of an ad break. To learn more about bumpers, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/bumpers.html">Bumpers</a>.</p>', 'PutPlaybackConfigurationRequest$Bumper' => '<p>The configuration for bumpers. Bumpers are short audio or video clips that play at the start or before the end of an ad break. To learn more about bumpers, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/bumpers.html">Bumpers</a>.</p>', 'PutPlaybackConfigurationResponse$Bumper' => '<p>The configuration for bumpers. Bumpers are short audio or video clips that play at the start or before the end of an ad break. To learn more about bumpers, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/bumpers.html">Bumpers</a>.</p>', ], ], 'CdnConfiguration' => [ 'base' => '<p>The configuration for using a content delivery network (CDN), like Amazon CloudFront, for content and ad segment management.</p>', 'refs' => [ 'GetPlaybackConfigurationResponse$CdnConfiguration' => '<p>The configuration for using a content delivery network (CDN), like Amazon CloudFront, for content and ad segment management.</p>', 'PlaybackConfiguration$CdnConfiguration' => '<p>The configuration for using a content delivery network (CDN), like Amazon CloudFront, for content and ad segment management.</p>', 'PutPlaybackConfigurationRequest$CdnConfiguration' => '<p>The configuration for using a content delivery network (CDN), like Amazon CloudFront, for content and ad segment management.</p>', 'PutPlaybackConfigurationResponse$CdnConfiguration' => '<p>The configuration for using a content delivery network (CDN), like Amazon CloudFront, for content and ad segment management.</p>', ], ], 'Channel' => [ 'base' => '<p>The configuration parameters for a channel. For information about MediaTailor channels, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-channels.html">Working with channels</a> in the <i>MediaTailor User Guide</i>.</p>', 'refs' => [ '__listOfChannel$member' => NULL, ], ], 'ChannelState' => [ 'base' => NULL, 'refs' => [ 'CreateChannelResponse$ChannelState' => '<p>Indicates whether the channel is in a running state or not.</p>', 'DescribeChannelResponse$ChannelState' => '<p>Indicates whether the channel is in a running state or not.</p>', 'UpdateChannelResponse$ChannelState' => '<p>Returns the state whether the channel is running or not.</p>', ], ], 'ClipRange' => [ 'base' => '<p>Clip range configuration for the VOD source associated with the program.</p>', 'refs' => [ 'AlternateMedia$ClipRange' => NULL, 'CreateProgramResponse$ClipRange' => '<p>The clip range configuration settings.</p>', 'DescribeProgramResponse$ClipRange' => '<p>The clip range configuration settings.</p>', 'ScheduleConfiguration$ClipRange' => '<p>Program clip range configuration.</p>', 'UpdateProgramResponse$ClipRange' => '<p>The clip range configuration settings.</p>', 'UpdateProgramScheduleConfiguration$ClipRange' => '<p>Program clip range configuration.</p>', ], ], 'ConfigurationAliasesRequest' => [ 'base' => '<p>The predefined aliases for dynamic variables.</p>', 'refs' => [ 'PutPlaybackConfigurationRequest$ConfigurationAliases' => '<p>The player parameters and aliases used as dynamic variables during session initialization. For more information, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/variables-domain.html">Domain Variables</a>.</p>', ], ], 'ConfigurationAliasesResponse' => [ 'base' => '<p>The predefined aliases for dynamic variables.</p>', 'refs' => [ 'GetPlaybackConfigurationResponse$ConfigurationAliases' => '<p>The player parameters and aliases used as dynamic variables during session initialization. For more information, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/variables-domain.html">Domain Variables</a>.</p>', 'PlaybackConfiguration$ConfigurationAliases' => '<p>The player parameters and aliases used as dynamic variables during session initialization. For more information, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/variables-domain.html">Domain Variables</a>.</p>', 'PutPlaybackConfigurationResponse$ConfigurationAliases' => '<p>The player parameters and aliases used as dynamic variables during session initialization. For more information, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/variables-domain.html">Domain Variables</a>.</p>', ], ], 'ConfigureLogsForChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'ConfigureLogsForChannelResponse' => [ 'base' => NULL, 'refs' => [], ], 'ConfigureLogsForPlaybackConfigurationRequest' => [ 'base' => '<p>Configures Amazon CloudWatch log settings for a playback configuration.</p>', 'refs' => [], ], 'ConfigureLogsForPlaybackConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateChannelResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateLiveSourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateLiveSourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreatePrefetchScheduleRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreatePrefetchScheduleResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateProgramRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateProgramResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateSourceLocationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSourceLocationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateVodSourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateVodSourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DashConfiguration' => [ 'base' => '<p>The configuration for DASH content.</p>', 'refs' => [ 'GetPlaybackConfigurationResponse$DashConfiguration' => '<p>The configuration for DASH content.</p>', 'PlaybackConfiguration$DashConfiguration' => '<p>The configuration for a DASH source.</p>', 'PutPlaybackConfigurationResponse$DashConfiguration' => '<p>The configuration for DASH content.</p>', ], ], 'DashConfigurationForPut' => [ 'base' => '<p>The configuration for DASH PUT operations.</p>', 'refs' => [ 'PutPlaybackConfigurationRequest$DashConfiguration' => '<p>The configuration for DASH content.</p>', ], ], 'DashPlaylistSettings' => [ 'base' => '<p>Dash manifest configuration parameters.</p>', 'refs' => [ 'RequestOutputItem$DashPlaylistSettings' => '<p>DASH manifest configuration parameters.</p>', 'ResponseOutputItem$DashPlaylistSettings' => '<p>DASH manifest configuration settings.</p>', ], ], 'DefaultSegmentDeliveryConfiguration' => [ 'base' => '<p>The optional configuration for a server that serves segments. Use this if you want the segment delivery server to be different from the source location server. For example, you can configure your source location server to be an origination server, such as MediaPackage, and the segment delivery server to be a content delivery network (CDN), such as CloudFront. If you don\'t specify a segment delivery server, then the source location server is used.</p>', 'refs' => [ 'CreateSourceLocationRequest$DefaultSegmentDeliveryConfiguration' => '<p>The optional configuration for the server that serves segments.</p>', 'CreateSourceLocationResponse$DefaultSegmentDeliveryConfiguration' => '<p>The optional configuration for the server that serves segments.</p>', 'DescribeSourceLocationResponse$DefaultSegmentDeliveryConfiguration' => '<p>The default segment delivery configuration settings.</p>', 'SourceLocation$DefaultSegmentDeliveryConfiguration' => '<p>The default segment delivery configuration.</p>', 'UpdateSourceLocationRequest$DefaultSegmentDeliveryConfiguration' => '<p>The optional configuration for the host server that serves segments.</p>', 'UpdateSourceLocationResponse$DefaultSegmentDeliveryConfiguration' => '<p>The optional configuration for the host server that serves segments.</p>', ], ], 'DeleteChannelPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteChannelPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteChannelResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLiveSourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLiveSourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeletePlaybackConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePlaybackConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeletePrefetchScheduleRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePrefetchScheduleResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteProgramRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteProgramResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSourceLocationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSourceLocationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVodSourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVodSourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeChannelResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLiveSourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLiveSourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeProgramRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeProgramResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSourceLocationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSourceLocationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVodSourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVodSourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'FillPolicy' => [ 'base' => NULL, 'refs' => [ 'AvailSuppression$FillPolicy' => '<p>Defines the policy to apply to the avail suppression mode. <code>BEHIND_LIVE_EDGE</code> will always use the full avail suppression policy. <code>AFTER_LIVE_EDGE</code> mode can be used to invoke partial ad break fills when a session starts mid-break.</p>', ], ], 'GetChannelPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetChannelPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetChannelScheduleRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetChannelScheduleResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetPlaybackConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPlaybackConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetPrefetchScheduleRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPrefetchScheduleResponse' => [ 'base' => NULL, 'refs' => [], ], 'HlsConfiguration' => [ 'base' => '<p>The configuration for HLS content.</p>', 'refs' => [ 'GetPlaybackConfigurationResponse$HlsConfiguration' => '<p>The configuration for HLS content.</p>', 'PlaybackConfiguration$HlsConfiguration' => '<p>The configuration for HLS content.</p>', 'PutPlaybackConfigurationResponse$HlsConfiguration' => '<p>The configuration for HLS content.</p>', ], ], 'HlsPlaylistSettings' => [ 'base' => '<p>HLS playlist configuration parameters.</p>', 'refs' => [ 'RequestOutputItem$HlsPlaylistSettings' => '<p>HLS playlist configuration parameters.</p>', 'ResponseOutputItem$HlsPlaylistSettings' => '<p>HLS manifest configuration settings.</p>', ], ], 'HttpConfiguration' => [ 'base' => '<p>The HTTP configuration for the source location.</p>', 'refs' => [ 'CreateSourceLocationRequest$HttpConfiguration' => '<p>The source\'s HTTP package configurations.</p>', 'CreateSourceLocationResponse$HttpConfiguration' => '<p>The source\'s HTTP package configurations.</p>', 'DescribeSourceLocationResponse$HttpConfiguration' => '<p>The HTTP package configuration settings for the source location.</p>', 'SourceLocation$HttpConfiguration' => '<p>The HTTP configuration for the source location.</p>', 'UpdateSourceLocationRequest$HttpConfiguration' => '<p>The HTTP configuration for the source location.</p>', 'UpdateSourceLocationResponse$HttpConfiguration' => '<p>The HTTP configuration for the source location.</p>', ], ], 'HttpPackageConfiguration' => [ 'base' => '<p>The HTTP package configuration properties for the requested VOD source.</p>', 'refs' => [ 'HttpPackageConfigurations$member' => NULL, ], ], 'HttpPackageConfigurations' => [ 'base' => '<p>The VOD source\'s HTTP package configuration settings.</p>', 'refs' => [ 'CreateLiveSourceRequest$HttpPackageConfigurations' => '<p>A list of HTTP package configuration parameters for this live source.</p>', 'CreateLiveSourceResponse$HttpPackageConfigurations' => '<p>A list of HTTP package configuration parameters for this live source.</p>', 'CreateVodSourceRequest$HttpPackageConfigurations' => '<p>A list of HTTP package configuration parameters for this VOD source.</p>', 'CreateVodSourceResponse$HttpPackageConfigurations' => '<p>A list of HTTP package configuration parameters for this VOD source.</p>', 'DescribeLiveSourceResponse$HttpPackageConfigurations' => '<p>The HTTP package configurations.</p>', 'DescribeVodSourceResponse$HttpPackageConfigurations' => '<p>The HTTP package configurations.</p>', 'LiveSource$HttpPackageConfigurations' => '<p>The HTTP package configurations for the live source.</p>', 'UpdateLiveSourceRequest$HttpPackageConfigurations' => '<p>A list of HTTP package configurations for the live source on this account.</p>', 'UpdateLiveSourceResponse$HttpPackageConfigurations' => '<p>A list of HTTP package configurations for the live source on this account.</p>', 'UpdateVodSourceRequest$HttpPackageConfigurations' => '<p>A list of HTTP package configurations for the VOD source on this account.</p>', 'UpdateVodSourceResponse$HttpPackageConfigurations' => '<p>A list of HTTP package configurations for the VOD source on this account.</p>', 'VodSource$HttpPackageConfigurations' => '<p>The HTTP package configurations for the VOD source.</p>', ], ], 'InsertionMode' => [ 'base' => '<p>Insertion Mode controls whether players can use stitched or guided ad insertion.</p>', 'refs' => [ 'GetPlaybackConfigurationResponse$InsertionMode' => '<p>The setting that controls whether players can use stitched or guided ad insertion. The default, <code>STITCHED_ONLY</code>, forces all player sessions to use stitched (server-side) ad insertion. Choosing <code>PLAYER_SELECT</code> allows players to select either stitched or guided ad insertion at session-initialization time. The default for players that do not specify an insertion mode is stitched.</p>', 'PlaybackConfiguration$InsertionMode' => '<p>The setting that controls whether players can use stitched or guided ad insertion. The default, <code>STITCHED_ONLY</code>, forces all player sessions to use stitched (server-side) ad insertion. Choosing <code>PLAYER_SELECT</code> allows players to select either stitched or guided ad insertion at session-initialization time. The default for players that do not specify an insertion mode is stitched.</p>', 'PutPlaybackConfigurationRequest$InsertionMode' => '<p>The setting that controls whether players can use stitched or guided ad insertion. The default, <code>STITCHED_ONLY</code>, forces all player sessions to use stitched (server-side) ad insertion. Choosing <code>PLAYER_SELECT</code> allows players to select either stitched or guided ad insertion at session-initialization time. The default for players that do not specify an insertion mode is stitched.</p>', 'PutPlaybackConfigurationResponse$InsertionMode' => '<p>The setting that controls whether players can use stitched or guided ad insertion. The default, <code>STITCHED_ONLY</code>, forces all player sessions to use stitched (server-side) ad insertion. Choosing <code>PLAYER_SELECT</code> allows players to select either stitched or guided ad insertion at session-initialization time. The default for players that do not specify an insertion mode is stitched.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'SegmentationDescriptor$SegmentNum' => '<p>The segment number to assign to the <code>segmentation_descriptor.segment_num</code> message, as defined in section 10.3.3.1 of the 2022 SCTE-35 specification Values must be between 0 and 256, inclusive. The default value is 0.</p>', 'SegmentationDescriptor$SegmentationEventId' => '<p>The Event Identifier to assign to the <code>segmentation_descriptor.segmentation_event_id</code> message, as defined in section 10.3.3.1 of the 2022 SCTE-35 specification. The default value is 1.</p>', 'SegmentationDescriptor$SegmentationTypeId' => '<p>The Type Identifier to assign to the <code>segmentation_descriptor.segmentation_type_id</code> message, as defined in section 10.3.3.1 of the 2022 SCTE-35 specification. Values must be between 0 and 256, inclusive. The default value is 48.</p>', 'SegmentationDescriptor$SegmentationUpidType' => '<p>The Upid Type to assign to the <code>segmentation_descriptor.segmentation_upid_type</code> message, as defined in section 10.3.3.1 of the 2022 SCTE-35 specification. Values must be between 0 and 256, inclusive. The default value is 14.</p>', 'SegmentationDescriptor$SegmentsExpected' => '<p>The number of segments expected, which is assigned to the <code>segmentation_descriptor.segments_expectedS</code> message, as defined in section 10.3.3.1 of the 2022 SCTE-35 specification Values must be between 0 and 256, inclusive. The default value is 0.</p>', 'SegmentationDescriptor$SubSegmentNum' => '<p>The sub-segment number to assign to the <code>segmentation_descriptor.sub_segment_num</code> message, as defined in section 10.3.3.1 of the 2022 SCTE-35 specification. Values must be between 0 and 256, inclusive. The defualt value is null.</p>', 'SegmentationDescriptor$SubSegmentsExpected' => '<p>The number of sub-segments expected, which is assigned to the <code>segmentation_descriptor.sub_segments_expected</code> message, as defined in section 10.3.3.1 of the 2022 SCTE-35 specification. Values must be between 0 and 256, inclusive. The default value is null.</p>', ], ], 'KeyValuePair' => [ 'base' => '<p>For <code>SCTE35_ENHANCED</code> output, defines a key and corresponding value. MediaTailor generates these pairs within the <code>EXT-X-ASSET</code>tag.</p>', 'refs' => [ 'AdBreakMetadataList$member' => NULL, ], ], 'ListAlertsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAlertsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListLiveSourcesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListLiveSourcesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPlaybackConfigurationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPlaybackConfigurationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPrefetchSchedulesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPrefetchSchedulesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSourceLocationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSourceLocationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListVodSourcesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListVodSourcesResponse' => [ 'base' => NULL, 'refs' => [], ], 'LivePreRollConfiguration' => [ 'base' => '<p>The configuration for pre-roll ad insertion.</p>', 'refs' => [ 'GetPlaybackConfigurationResponse$LivePreRollConfiguration' => '<p>The configuration for pre-roll ad insertion.</p>', 'PlaybackConfiguration$LivePreRollConfiguration' => '<p>The configuration for pre-roll ad insertion.</p>', 'PutPlaybackConfigurationRequest$LivePreRollConfiguration' => '<p>The configuration for pre-roll ad insertion.</p>', 'PutPlaybackConfigurationResponse$LivePreRollConfiguration' => '<p>The configuration for pre-roll ad insertion.</p>', ], ], 'LiveSource' => [ 'base' => '<p>Live source configuration parameters.</p>', 'refs' => [ '__listOfLiveSource$member' => NULL, ], ], 'LogConfiguration' => [ 'base' => '<p>Returns Amazon CloudWatch log settings for a playback configuration.</p>', 'refs' => [ 'GetPlaybackConfigurationResponse$LogConfiguration' => '<p>The Amazon CloudWatch log settings for a playback configuration.</p>', 'PlaybackConfiguration$LogConfiguration' => '<p>The Amazon CloudWatch log settings for a playback configuration.</p>', 'PutPlaybackConfigurationResponse$LogConfiguration' => '<p>The Amazon CloudWatch log settings for a playback configuration.</p>', ], ], 'LogConfigurationForChannel' => [ 'base' => '<p>The log configuration for the channel.</p>', 'refs' => [ 'Channel$LogConfiguration' => '<p>The log configuration.</p>', 'DescribeChannelResponse$LogConfiguration' => '<p>The log configuration for the channel.</p>', ], ], 'LogType' => [ 'base' => NULL, 'refs' => [ 'LogTypes$member' => NULL, ], ], 'LogTypes' => [ 'base' => NULL, 'refs' => [ 'ConfigureLogsForChannelRequest$LogTypes' => '<p>The types of logs to collect.</p>', 'ConfigureLogsForChannelResponse$LogTypes' => '<p>The types of logs collected.</p>', 'LogConfigurationForChannel$LogTypes' => '<p>The log types.</p>', ], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'DescribeProgramResponse$DurationMillis' => '<p>The duration of the live program in milliseconds.</p>', ], ], 'ManifestProcessingRules' => [ 'base' => '<p>The configuration for manifest processing rules. Manifest processing rules enable customization of the personalized manifests created by MediaTailor.</p>', 'refs' => [ 'GetPlaybackConfigurationResponse$ManifestProcessingRules' => '<p>The configuration for manifest processing rules. Manifest processing rules enable customization of the personalized manifests created by MediaTailor.</p>', 'PlaybackConfiguration$ManifestProcessingRules' => '<p>The configuration for manifest processing rules. Manifest processing rules enable customization of the personalized manifests created by MediaTailor.</p>', 'PutPlaybackConfigurationRequest$ManifestProcessingRules' => '<p>The configuration for manifest processing rules. Manifest processing rules enable customization of the personalized manifests created by MediaTailor.</p>', 'PutPlaybackConfigurationResponse$ManifestProcessingRules' => '<p>The configuration for manifest processing rules. Manifest processing rules enable customization of the personalized manifests created by MediaTailor.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'GetChannelScheduleRequest$MaxResults' => '<p>The maximum number of channel schedules that you want MediaTailor to return in response to the current request. If there are more than <code>MaxResults</code> channel schedules, use the value of <code>NextToken</code> in the response to get the next page of results.</p>', 'ListAlertsRequest$MaxResults' => '<p>The maximum number of alerts that you want MediaTailor to return in response to the current request. If there are more than <code>MaxResults</code> alerts, use the value of <code>NextToken</code> in the response to get the next page of results.</p>', 'ListChannelsRequest$MaxResults' => '<p>The maximum number of channels that you want MediaTailor to return in response to the current request. If there are more than <code>MaxResults</code> channels, use the value of <code>NextToken</code> in the response to get the next page of results.</p>', 'ListLiveSourcesRequest$MaxResults' => '<p>The maximum number of live sources that you want MediaTailor to return in response to the current request. If there are more than <code>MaxResults</code> live sources, use the value of <code>NextToken</code> in the response to get the next page of results.</p>', 'ListPlaybackConfigurationsRequest$MaxResults' => '<p>The maximum number of playback configurations that you want MediaTailor to return in response to the current request. If there are more than <code>MaxResults</code> playback configurations, use the value of <code>NextToken</code> in the response to get the next page of results.</p>', 'ListSourceLocationsRequest$MaxResults' => '<p> The maximum number of source locations that you want MediaTailor to return in response to the current request. If there are more than <code>MaxResults</code> source locations, use the value of <code>NextToken</code> in the response to get the next page of results.</p>', 'ListVodSourcesRequest$MaxResults' => '<p> The maximum number of VOD sources that you want MediaTailor to return in response to the current request. If there are more than <code>MaxResults</code> VOD sources, use the value of <code>NextToken</code> in the response to get the next page of results.</p>', ], ], 'MessageType' => [ 'base' => NULL, 'refs' => [ 'AdBreak$MessageType' => '<p>The SCTE-35 ad insertion type. Accepted value: <code>SPLICE_INSERT</code>, <code>TIME_SIGNAL</code>.</p>', ], ], 'Mode' => [ 'base' => NULL, 'refs' => [ 'AvailSuppression$Mode' => '<p>Sets the ad suppression mode. By default, ad suppression is off and all ad breaks are filled with ads or slate. When Mode is set to <code>BEHIND_LIVE_EDGE</code>, ad suppression is active and MediaTailor won\'t fill ad breaks on or behind the ad suppression Value time in the manifest lookback window. When Mode is set to <code>AFTER_LIVE_EDGE</code>, ad suppression is active and MediaTailor won\'t fill ad breaks that are within the live edge plus the avail suppression value.</p>', ], ], 'Operator' => [ 'base' => NULL, 'refs' => [ 'AvailMatchingCriteria$Operator' => '<p>For the <code>DynamicVariable</code> specified in <code>AvailMatchingCriteria</code>, the Operator that is used for the comparison.</p>', ], ], 'OriginManifestType' => [ 'base' => NULL, 'refs' => [ 'DashConfiguration$OriginManifestType' => '<p>The setting that controls whether MediaTailor handles manifests from the origin server as multi-period manifests or single-period manifests. If your origin server produces single-period manifests, set this to <code>SINGLE_PERIOD</code>. The default setting is <code>MULTI_PERIOD</code>. For multi-period manifests, omit this setting or set it to <code>MULTI_PERIOD</code>.</p>', 'DashConfigurationForPut$OriginManifestType' => '<p>The setting that controls whether MediaTailor handles manifests from the origin server as multi-period manifests or single-period manifests. If your origin server produces single-period manifests, set this to <code>SINGLE_PERIOD</code>. The default setting is <code>MULTI_PERIOD</code>. For multi-period manifests, omit this setting or set it to <code>MULTI_PERIOD</code>.</p>', ], ], 'PlaybackConfiguration' => [ 'base' => '<p>A playback configuration. For information about MediaTailor configurations, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/configurations.html">Working with configurations in AWS Elemental MediaTailor</a>.</p>', 'refs' => [ '__listOfPlaybackConfiguration$member' => NULL, ], ], 'PlaybackMode' => [ 'base' => NULL, 'refs' => [ 'CreateChannelRequest$PlaybackMode' => '<p>The type of playback mode to use for this channel.</p> <p> <code>LINEAR</code> - The programs in the schedule play once back-to-back in the schedule.</p> <p> <code>LOOP</code> - The programs in the schedule play back-to-back in an endless loop. When the last program in the schedule stops playing, playback loops back to the first program in the schedule.</p>', ], ], 'PrefetchConsumption' => [ 'base' => '<p>A complex type that contains settings that determine how and when that MediaTailor places prefetched ads into upcoming ad breaks.</p>', 'refs' => [ 'CreatePrefetchScheduleRequest$Consumption' => '<p>The configuration settings for MediaTailor\'s <i>consumption</i> of the prefetched ads from the ad decision server. Each consumption configuration contains an end time and an optional start time that define the <i>consumption window</i>. Prefetch schedules automatically expire no earlier than seven days after the end time.</p>', 'CreatePrefetchScheduleResponse$Consumption' => '<p>The configuration settings for MediaTailor\'s <i>consumption</i> of the prefetched ads from the ad decision server. Each consumption configuration contains an end time and an optional start time that define the <i>consumption window</i>. Prefetch schedules automatically expire no earlier than seven days after the end time.</p>', 'GetPrefetchScheduleResponse$Consumption' => '<p>Consumption settings determine how, and when, MediaTailor places the prefetched ads into ad breaks. Ad consumption occurs within a span of time that you define, called a <i>consumption window</i>. You can designate which ad breaks that MediaTailor fills with prefetch ads by setting avail matching criteria.</p>', 'PrefetchSchedule$Consumption' => '<p>Consumption settings determine how, and when, MediaTailor places the prefetched ads into ad breaks. Ad consumption occurs within a span of time that you define, called a <i>consumption window</i>. You can designate which ad breaks that MediaTailor fills with prefetch ads by setting avail matching criteria.</p>', ], ], 'PrefetchRetrieval' => [ 'base' => '<p>A complex type that contains settings governing when MediaTailor prefetches ads, and which dynamic variables that MediaTailor includes in the request to the ad decision server.</p>', 'refs' => [ 'CreatePrefetchScheduleRequest$Retrieval' => '<p>The configuration settings for retrieval of prefetched ads from the ad decision server. Only one set of prefetched ads will be retrieved and subsequently consumed for each ad break.</p>', 'CreatePrefetchScheduleResponse$Retrieval' => '<p>The configuration settings for retrieval of prefetched ads from the ad decision server. Only one set of prefetched ads will be retrieved and subsequently consumed for each ad break.</p>', 'GetPrefetchScheduleResponse$Retrieval' => '<p>A complex type that contains settings for prefetch retrieval from the ad decision server (ADS).</p>', 'PrefetchSchedule$Retrieval' => '<p>A complex type that contains settings for prefetch retrieval from the ad decision server (ADS).</p>', ], ], 'PrefetchSchedule' => [ 'base' => '<p>A prefetch schedule allows you to tell MediaTailor to fetch and prepare certain ads before an ad break happens. For more information about ad prefetching, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/prefetching-ads.html">Using ad prefetching</a> in the <i>MediaTailor User Guide</i>.</p>', 'refs' => [ '__listOfPrefetchSchedule$member' => NULL, ], ], 'PutChannelPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutChannelPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutPlaybackConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutPlaybackConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'RelativePosition' => [ 'base' => NULL, 'refs' => [ 'Transition$RelativePosition' => '<p>The position where this program will be inserted relative to the <code>RelativePosition</code>.</p>', ], ], 'RequestOutputItem' => [ 'base' => '<p>The output configuration for this channel.</p>', 'refs' => [ 'RequestOutputs$member' => NULL, ], ], 'RequestOutputs' => [ 'base' => '<p>An object that represents an object in the CreateChannel request.</p>', 'refs' => [ 'CreateChannelRequest$Outputs' => '<p>The channel\'s output properties.</p>', 'UpdateChannelRequest$Outputs' => '<p>The channel\'s output properties.</p>', ], ], 'ResponseOutputItem' => [ 'base' => '<p>The output item response.</p>', 'refs' => [ 'ResponseOutputs$member' => NULL, ], ], 'ResponseOutputs' => [ 'base' => NULL, 'refs' => [ 'Channel$Outputs' => '<p>The channel\'s output properties.</p>', 'CreateChannelResponse$Outputs' => '<p>The output properties to assign to the channel.</p>', 'DescribeChannelResponse$Outputs' => '<p>The channel\'s output properties.</p>', 'UpdateChannelResponse$Outputs' => '<p>The channel\'s output properties.</p>', ], ], 'ScheduleAdBreak' => [ 'base' => '<p>The schedule\'s ad break properties.</p>', 'refs' => [ '__listOfScheduleAdBreak$member' => NULL, ], ], 'ScheduleConfiguration' => [ 'base' => '<p>Schedule configuration parameters. A channel must be stopped before changes can be made to the schedule.</p>', 'refs' => [ 'CreateProgramRequest$ScheduleConfiguration' => '<p>The schedule configuration settings.</p>', ], ], 'ScheduleEntry' => [ 'base' => '<p>The properties for a schedule.</p>', 'refs' => [ '__listOfScheduleEntry$member' => NULL, ], ], 'ScheduleEntryType' => [ 'base' => NULL, 'refs' => [ 'ScheduleEntry$ScheduleEntryType' => '<p>The type of schedule entry.</p>', ], ], 'SecretsManagerAccessTokenConfiguration' => [ 'base' => '<p>AWS Secrets Manager access token configuration parameters. For information about Secrets Manager access token authentication, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-access-configuration-access-token.html">Working with AWS Secrets Manager access token authentication</a>.</p>', 'refs' => [ 'AccessConfiguration$SecretsManagerAccessTokenConfiguration' => '<p>AWS Secrets Manager access token configuration parameters.</p>', ], ], 'SegmentDeliveryConfiguration' => [ 'base' => '<p>The segment delivery configuration settings.</p>', 'refs' => [ '__listOfSegmentDeliveryConfiguration$member' => NULL, ], ], 'SegmentationDescriptor' => [ 'base' => '<p>The <code>segmentation_descriptor</code> message can contain advanced metadata fields, like content identifiers, to convey a wide range of information about the ad break. MediaTailor writes the ad metadata in the egress manifest as part of the <code>EXT-X-DATERANGE</code> or <code>EventStream</code> ad marker\'s SCTE-35 data.</p> <p> <code>segmentation_descriptor</code> messages must be sent with the <code>time_signal</code> message type.</p> <p>See the <code>segmentation_descriptor()</code> table of the 2022 SCTE-35 specification for more information.</p>', 'refs' => [ 'SegmentationDescriptorList$member' => NULL, ], ], 'SegmentationDescriptorList' => [ 'base' => NULL, 'refs' => [ 'TimeSignalMessage$SegmentationDescriptors' => '<p>The configurations for the SCTE-35 <code>segmentation_descriptor</code> message(s) sent with the <code>time_signal</code> message.</p>', ], ], 'SlateSource' => [ 'base' => '<p>Slate VOD source configuration.</p>', 'refs' => [ 'AdBreak$Slate' => '<p>Ad break slate configuration.</p>', 'Channel$FillerSlate' => '<p>The slate used to fill gaps between programs in the schedule. You must configure filler slate if your channel uses the <code>LINEAR</code> <code>PlaybackMode</code>. MediaTailor doesn\'t support filler slate for channels using the <code>LOOP</code> <code>PlaybackMode</code>.</p>', 'CreateChannelRequest$FillerSlate' => '<p>The slate used to fill gaps between programs in the schedule. You must configure filler slate if your channel uses the <code>LINEAR</code> <code>PlaybackMode</code>. MediaTailor doesn\'t support filler slate for channels using the <code>LOOP</code> <code>PlaybackMode</code>.</p>', 'CreateChannelResponse$FillerSlate' => '<p>Contains information about the slate used to fill gaps between programs in the schedule.</p>', 'DescribeChannelResponse$FillerSlate' => '<p>Contains information about the slate used to fill gaps between programs in the schedule.</p>', 'UpdateChannelRequest$FillerSlate' => '<p>The slate used to fill gaps between programs in the schedule. You must configure filler slate if your channel uses the <code>LINEAR</code> <code>PlaybackMode</code>. MediaTailor doesn\'t support filler slate for channels using the <code>LOOP</code> <code>PlaybackMode</code>.</p>', 'UpdateChannelResponse$FillerSlate' => '<p>The slate used to fill gaps between programs in the schedule. You must configure filler slate if your channel uses the <code>LINEAR</code> <code>PlaybackMode</code>. MediaTailor doesn\'t support filler slate for channels using the <code>LOOP</code> <code>PlaybackMode</code>.</p>', ], ], 'SourceLocation' => [ 'base' => '<p>A source location is a container for sources. For more information about source locations, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-source-locations.html">Working with source locations</a> in the <i>MediaTailor User Guide</i>.</p>', 'refs' => [ '__listOfSourceLocation$member' => NULL, ], ], 'SpliceInsertMessage' => [ 'base' => '<p>Splice insert message configuration.</p>', 'refs' => [ 'AdBreak$SpliceInsertMessage' => '<p>This defines the SCTE-35 <code>splice_insert()</code> message inserted around the ad. For information about using <code>splice_insert()</code>, see the SCTE-35 specficiaiton, section 9.7.3.1.</p>', ], ], 'StartChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartChannelResponse' => [ 'base' => NULL, 'refs' => [], ], 'StopChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopChannelResponse' => [ 'base' => NULL, 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'Audiences$member' => NULL, 'KeyValuePair$Key' => '<p>For <code>SCTE35_ENHANCED</code> output, defines a key. MediaTailor takes this key, and its associated value, and generates the key/value pair within the <code>EXT-X-ASSET</code>tag. If you specify a key, you must also specify a corresponding value.</p>', 'KeyValuePair$Value' => '<p>For <code>SCTE35_ENHANCED</code> output, defines a value. MediaTailor; takes this value, and its associated key, and generates the key/value pair within the <code>EXT-X-ASSET</code>tag. If you specify a value, you must also specify a corresponding key.</p>', 'SegmentationDescriptor$SegmentationUpid' => '<p>The Upid to assign to the <code>segmentation_descriptor.segmentation_upid</code> message, as defined in section 10.3.3.1 of the 2022 SCTE-35 specification. The value must be a hexadecimal string containing only the characters 0 though 9 and A through F. The default value is "" (an empty string).</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'Tier' => [ 'base' => NULL, 'refs' => [ 'CreateChannelRequest$Tier' => '<p>The tier of the channel.</p>', ], ], 'TimeShiftConfiguration' => [ 'base' => '<p> The configuration for time-shifted viewing. </p>', 'refs' => [ 'CreateChannelRequest$TimeShiftConfiguration' => '<p> The time-shifted viewing configuration you want to associate to the channel. </p>', 'CreateChannelResponse$TimeShiftConfiguration' => '<p> The time-shifted viewing configuration assigned to the channel. </p>', 'DescribeChannelResponse$TimeShiftConfiguration' => '<p> The time-shifted viewing configuration for the channel. </p>', 'UpdateChannelRequest$TimeShiftConfiguration' => '<p> The time-shifted viewing configuration you want to associate to the channel. </p>', 'UpdateChannelResponse$TimeShiftConfiguration' => '<p> The time-shifted viewing configuration for the channel. </p>', ], ], 'TimeSignalMessage' => [ 'base' => '<p>The SCTE-35 <code>time_signal</code> message can be sent with one or more <code>segmentation_descriptor</code> messages. A <code>time_signal</code> message can be sent only if a single <code>segmentation_descriptor</code> message is sent.</p> <p>The <code>time_signal</code> message contains only the <code>splice_time</code> field which is constructed using a given presentation timestamp. When sending a <code>time_signal</code> message, the <code>splice_command_type</code> field in the <code>splice_info_section</code> message is set to 6 (0x06).</p> <p>See the <code>time_signal()</code> table of the 2022 SCTE-35 specification for more information.</p>', 'refs' => [ 'AdBreak$TimeSignalMessage' => '<p>Defines the SCTE-35 <code>time_signal</code> message inserted around the ad.</p> <p>Programs on a channel\'s schedule can be configured with one or more ad breaks. You can attach a <code>splice_insert</code> SCTE-35 message to the ad break. This message provides basic metadata about the ad break.</p> <p>See section 9.7.4 of the 2022 SCTE-35 specification for more information.</p>', ], ], 'Transition' => [ 'base' => '<p>Program transition configuration.</p>', 'refs' => [ 'ScheduleConfiguration$Transition' => '<p>Program transition configurations.</p>', ], ], 'Type' => [ 'base' => NULL, 'refs' => [ 'HttpPackageConfiguration$Type' => '<p>The streaming protocol for this package configuration. Supported values are <code>HLS</code> and <code>DASH</code>.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateChannelResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLiveSourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLiveSourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateProgramRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateProgramResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateProgramScheduleConfiguration' => [ 'base' => '<p>Schedule configuration parameters.</p>', 'refs' => [ 'UpdateProgramRequest$ScheduleConfiguration' => '<p>The schedule configuration settings.</p>', ], ], 'UpdateProgramTransition' => [ 'base' => '<p>Program transition configuration.</p>', 'refs' => [ 'UpdateProgramScheduleConfiguration$Transition' => '<p>Program transition configuration.</p>', ], ], 'UpdateSourceLocationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSourceLocationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateVodSourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateVodSourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'VodSource' => [ 'base' => '<p>VOD source configuration parameters.</p>', 'refs' => [ '__listOfVodSource$member' => NULL, ], ], '__boolean' => [ 'base' => NULL, 'refs' => [ 'AdMarkerPassthrough$Enabled' => '<p>Enables ad marker passthrough for your configuration.</p>', ], ], '__integer' => [ 'base' => NULL, 'refs' => [ 'ConfigureLogsForPlaybackConfigurationRequest$PercentEnabled' => '<p>The percentage of session logs that MediaTailor sends to your Cloudwatch Logs account. For example, if your playback configuration has 1000 sessions and percentEnabled is set to <code>60</code>, MediaTailor sends logs for 600 of the sessions to CloudWatch Logs. MediaTailor decides at random which of the playback configuration sessions to send logs for. If you want to view logs for a specific session, you can use the <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/debug-log-mode.html">debug log mode</a>.</p> <p>Valid values: <code>0</code> - <code>100</code> </p>', 'ConfigureLogsForPlaybackConfigurationResponse$PercentEnabled' => '<p>The percentage of session logs that MediaTailor sends to your Cloudwatch Logs account.</p>', 'DashPlaylistSettings$ManifestWindowSeconds' => '<p>The total duration (in seconds) of each manifest. Minimum value: <code>30</code> seconds. Maximum value: <code>3600</code> seconds.</p>', 'DashPlaylistSettings$MinBufferTimeSeconds' => '<p>Minimum amount of content (measured in seconds) that a player must keep available in the buffer. Minimum value: <code>2</code> seconds. Maximum value: <code>60</code> seconds.</p>', 'DashPlaylistSettings$MinUpdatePeriodSeconds' => '<p>Minimum amount of time (in seconds) that the player should wait before requesting updates to the manifest. Minimum value: <code>2</code> seconds. Maximum value: <code>60</code> seconds.</p>', 'DashPlaylistSettings$SuggestedPresentationDelaySeconds' => '<p>Amount of time (in seconds) that the player should be from the live point at the end of the manifest. Minimum value: <code>2</code> seconds. Maximum value: <code>60</code> seconds.</p>', 'HlsPlaylistSettings$ManifestWindowSeconds' => '<p>The total duration (in seconds) of each manifest. Minimum value: <code>30</code> seconds. Maximum value: <code>3600</code> seconds.</p>', 'LivePreRollConfiguration$MaxDurationSeconds' => '<p>The maximum allowed duration for the pre-roll ad avail. AWS Elemental MediaTailor won\'t play pre-roll ads to exceed this duration, regardless of the total duration of ads that the ADS returns.</p>', 'LogConfiguration$PercentEnabled' => '<p>The percentage of session logs that MediaTailor sends to your Cloudwatch Logs account. For example, if your playback configuration has 1000 sessions and <code>percentEnabled</code> is set to <code>60</code>, MediaTailor sends logs for 600 of the sessions to CloudWatch Logs. MediaTailor decides at random which of the playback configuration sessions to send logs for. If you want to view logs for a specific session, you can use the <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/debug-log-mode.html">debug log mode</a>.</p> <p>Valid values: <code>0</code> - <code>100</code> </p>', 'SpliceInsertMessage$AvailNum' => '<p>This is written to <code>splice_insert.avail_num</code>, as defined in section 9.7.3.1 of the SCTE-35 specification. The default value is <code>0</code>. Values must be between <code>0</code> and <code>256</code>, inclusive.</p>', 'SpliceInsertMessage$AvailsExpected' => '<p>This is written to <code>splice_insert.avails_expected</code>, as defined in section 9.7.3.1 of the SCTE-35 specification. The default value is <code>0</code>. Values must be between <code>0</code> and <code>256</code>, inclusive.</p>', 'SpliceInsertMessage$SpliceEventId' => '<p>This is written to <code>splice_insert.splice_event_id</code>, as defined in section 9.7.3.1 of the SCTE-35 specification. The default value is <code>1</code>.</p>', 'SpliceInsertMessage$UniqueProgramId' => '<p>This is written to <code>splice_insert.unique_program_id</code>, as defined in section 9.7.3.1 of the SCTE-35 specification. The default value is <code>0</code>. Values must be between <code>0</code> and <code>256</code>, inclusive.</p>', 'TimeShiftConfiguration$MaxTimeDelaySeconds' => '<p> The maximum time delay for time-shifted viewing. The minimum allowed maximum time delay is 0 seconds, and the maximum allowed maximum time delay is 21600 seconds (6 hours). </p>', ], ], '__integerMin1' => [ 'base' => NULL, 'refs' => [ 'GetPlaybackConfigurationResponse$PersonalizationThresholdSeconds' => '<p>Defines the maximum duration of underfilled ad time (in seconds) allowed in an ad break. If the duration of underfilled ad time exceeds the personalization threshold, then the personalization of the ad break is abandoned and the underlying content is shown. This feature applies to <i>ad replacement</i> in live and VOD streams, rather than ad insertion, because it relies on an underlying content stream. For more information about ad break behavior, including ad replacement and insertion, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/ad-behavior.html">Ad Behavior in AWS Elemental MediaTailor</a>.</p>', 'PlaybackConfiguration$PersonalizationThresholdSeconds' => '<p>Defines the maximum duration of underfilled ad time (in seconds) allowed in an ad break. If the duration of underfilled ad time exceeds the personalization threshold, then the personalization of the ad break is abandoned and the underlying content is shown. This feature applies to <i>ad replacement</i> in live and VOD streams, rather than ad insertion, because it relies on an underlying content stream. For more information about ad break behavior, including ad replacement and insertion, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/ad-behavior.html">Ad Behavior in AWS Elemental MediaTailor</a>.</p>', 'PutPlaybackConfigurationRequest$PersonalizationThresholdSeconds' => '<p>Defines the maximum duration of underfilled ad time (in seconds) allowed in an ad break. If the duration of underfilled ad time exceeds the personalization threshold, then the personalization of the ad break is abandoned and the underlying content is shown. This feature applies to <i>ad replacement</i> in live and VOD streams, rather than ad insertion, because it relies on an underlying content stream. For more information about ad break behavior, including ad replacement and insertion, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/ad-behavior.html">Ad Behavior in AWS Elemental MediaTailor</a>.</p>', 'PutPlaybackConfigurationResponse$PersonalizationThresholdSeconds' => '<p>Defines the maximum duration of underfilled ad time (in seconds) allowed in an ad break. If the duration of underfilled ad time exceeds the personalization threshold, then the personalization of the ad break is abandoned and the underlying content is shown. This feature applies to <i>ad replacement</i> in live and VOD streams, rather than ad insertion, because it relies on an underlying content stream. For more information about ad break behavior, including ad replacement and insertion, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/ad-behavior.html">Ad Behavior in AWS Elemental MediaTailor</a>.</p>', ], ], '__integerMin1Max100' => [ 'base' => NULL, 'refs' => [ 'ListPrefetchSchedulesRequest$MaxResults' => '<p>The maximum number of prefetch schedules that you want MediaTailor to return in response to the current request. If there are more than <code>MaxResults</code> prefetch schedules, use the value of <code>NextToken</code> in the response to get the next page of results.</p>', ], ], '__listOfAdBreak' => [ 'base' => NULL, 'refs' => [ 'AlternateMedia$AdBreaks' => '<p>Ad break configuration parameters defined in AlternateMedia.</p>', 'CreateProgramRequest$AdBreaks' => '<p>The ad break configuration settings.</p>', 'CreateProgramResponse$AdBreaks' => '<p>The ad break configuration settings.</p>', 'DescribeProgramResponse$AdBreaks' => '<p>The ad break configuration settings.</p>', 'UpdateProgramRequest$AdBreaks' => '<p>The ad break configuration settings.</p>', 'UpdateProgramResponse$AdBreaks' => '<p>The ad break configuration settings.</p>', ], ], '__listOfAlert' => [ 'base' => NULL, 'refs' => [ 'ListAlertsResponse$Items' => '<p>A list of alerts that are associated with this resource.</p>', ], ], '__listOfAlternateMedia' => [ 'base' => NULL, 'refs' => [ 'AudienceMedia$AlternateMedia' => '<p>The list of AlternateMedia defined in AudienceMedia.</p>', ], ], '__listOfAudienceMedia' => [ 'base' => NULL, 'refs' => [ 'CreateProgramRequest$AudienceMedia' => '<p>The list of AudienceMedia defined in program.</p>', 'CreateProgramResponse$AudienceMedia' => '<p>The list of AudienceMedia defined in program.</p>', 'DescribeProgramResponse$AudienceMedia' => '<p>The list of AudienceMedia defined in program.</p>', 'UpdateProgramRequest$AudienceMedia' => '<p>The list of AudienceMedia defined in program.</p>', 'UpdateProgramResponse$AudienceMedia' => '<p>The list of AudienceMedia defined in program.</p>', ], ], '__listOfAvailMatchingCriteria' => [ 'base' => NULL, 'refs' => [ 'PrefetchConsumption$AvailMatchingCriteria' => '<p>If you only want MediaTailor to insert prefetched ads into avails (ad breaks) that match specific dynamic variables, such as <code>scte.event_id</code>, set the avail matching criteria.</p>', ], ], '__listOfChannel' => [ 'base' => NULL, 'refs' => [ 'ListChannelsResponse$Items' => '<p>A list of channels that are associated with this account.</p>', ], ], '__listOfLiveSource' => [ 'base' => NULL, 'refs' => [ 'ListLiveSourcesResponse$Items' => '<p>Lists the live sources.</p>', ], ], '__listOfPlaybackConfiguration' => [ 'base' => NULL, 'refs' => [ 'ListPlaybackConfigurationsResponse$Items' => '<p>Array of playback configurations. This might be all the available configurations or a subset, depending on the settings that you provide and the total number of configurations stored.</p>', ], ], '__listOfPrefetchSchedule' => [ 'base' => NULL, 'refs' => [ 'ListPrefetchSchedulesResponse$Items' => '<p>Lists the prefetch schedules. An empty <code>Items</code> list doesn\'t mean there aren\'t more items to fetch, just that that page was empty.</p>', ], ], '__listOfScheduleAdBreak' => [ 'base' => NULL, 'refs' => [ 'ScheduleEntry$ScheduleAdBreaks' => '<p>The schedule\'s ad break properties.</p>', ], ], '__listOfScheduleEntry' => [ 'base' => NULL, 'refs' => [ 'GetChannelScheduleResponse$Items' => '<p>A list of schedule entries for the channel.</p>', ], ], '__listOfSegmentDeliveryConfiguration' => [ 'base' => NULL, 'refs' => [ 'CreateSourceLocationRequest$SegmentDeliveryConfigurations' => '<p>A list of the segment delivery configurations associated with this resource.</p>', 'CreateSourceLocationResponse$SegmentDeliveryConfigurations' => '<p>The segment delivery configurations for the source location. For information about MediaTailor configurations, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/configurations.html">Working with configurations in AWS Elemental MediaTailor</a>.</p>', 'DescribeSourceLocationResponse$SegmentDeliveryConfigurations' => '<p>A list of the segment delivery configurations associated with this resource.</p>', 'SourceLocation$SegmentDeliveryConfigurations' => '<p>The segment delivery configurations for the source location.</p>', 'UpdateSourceLocationRequest$SegmentDeliveryConfigurations' => '<p>A list of the segment delivery configurations associated with this resource.</p>', 'UpdateSourceLocationResponse$SegmentDeliveryConfigurations' => '<p>The segment delivery configurations for the source location. For information about MediaTailor configurations, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/configurations.html">Working with configurations in AWS Elemental MediaTailor</a>.</p>', ], ], '__listOfSourceLocation' => [ 'base' => NULL, 'refs' => [ 'ListSourceLocationsResponse$Items' => '<p>A list of source locations.</p>', ], ], '__listOfVodSource' => [ 'base' => NULL, 'refs' => [ 'ListVodSourcesResponse$Items' => '<p>Lists the VOD sources.</p>', ], ], '__listOf__string' => [ 'base' => NULL, 'refs' => [ 'Alert$RelatedResourceArns' => '<p>The Amazon Resource Names (ARNs) related to this alert.</p>', 'UntagResourceRequest$TagKeys' => '<p>The tag keys associated with the resource.</p>', ], ], '__long' => [ 'base' => NULL, 'refs' => [ 'AdBreak$OffsetMillis' => '<p>How long (in milliseconds) after the beginning of the program that an ad starts. This value must fall within 100ms of a segment boundary, otherwise the ad break will be skipped.</p>', 'AdBreakOpportunity$OffsetMillis' => '<p>The offset in milliseconds from the start of the VOD source at which an ad marker was detected.</p>', 'AlternateMedia$DurationMillis' => '<p>The duration of the alternateMedia in milliseconds.</p>', 'AlternateMedia$ScheduledStartTimeMillis' => '<p>The date and time that the alternateMedia is scheduled to start, in epoch milliseconds.</p>', 'ClipRange$EndOffsetMillis' => '<p>The end offset of the clip range, in milliseconds, starting from the beginning of the VOD source associated with the program.</p>', 'ClipRange$StartOffsetMillis' => '<p>The start offset of the clip range, in milliseconds. This offset truncates the start at the number of milliseconds into the duration of the VOD source.</p>', 'CreateProgramResponse$DurationMillis' => '<p>The duration of the live program in milliseconds.</p>', 'ScheduleAdBreak$ApproximateDurationSeconds' => '<p>The approximate duration of the ad break, in seconds.</p>', 'ScheduleEntry$ApproximateDurationSeconds' => '<p>The approximate duration of this program, in seconds.</p>', 'Transition$DurationMillis' => '<p>The duration of the live program in seconds.</p>', 'Transition$ScheduledStartTimeMillis' => '<p>The date and time that the program is scheduled to start, in epoch milliseconds.</p>', 'UpdateProgramResponse$DurationMillis' => '<p>The duration of the live program in milliseconds.</p>', 'UpdateProgramTransition$DurationMillis' => '<p>The duration of the live program in seconds.</p>', 'UpdateProgramTransition$ScheduledStartTimeMillis' => '<p>The date and time that the program is scheduled to start, in epoch milliseconds.</p>', ], ], '__mapOf__string' => [ 'base' => NULL, 'refs' => [ 'Channel$Tags' => '<p>The tags to assign to the channel. Tags are key-value pairs that you can associate with Amazon resources to help with organization, access control, and cost tracking. For more information, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor Resources</a>.</p>', 'ConfigurationAliasesRequest$value' => '<p>Map of aliases to the value to be used at request time.</p>', 'ConfigurationAliasesResponse$value' => '<p>Map of aliases to the value to be used at request time.</p>', 'CreateChannelRequest$Tags' => '<p>The tags to assign to the channel. Tags are key-value pairs that you can associate with Amazon resources to help with organization, access control, and cost tracking. For more information, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor Resources</a>.</p>', 'CreateChannelResponse$Tags' => '<p>The tags to assign to the channel. Tags are key-value pairs that you can associate with Amazon resources to help with organization, access control, and cost tracking. For more information, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor Resources</a>.</p>', 'CreateLiveSourceRequest$Tags' => '<p>The tags to assign to the live source. Tags are key-value pairs that you can associate with Amazon resources to help with organization, access control, and cost tracking. For more information, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor Resources</a>.</p>', 'CreateLiveSourceResponse$Tags' => '<p>The tags to assign to the live source. Tags are key-value pairs that you can associate with Amazon resources to help with organization, access control, and cost tracking. For more information, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor Resources</a>.</p>', 'CreateSourceLocationRequest$Tags' => '<p>The tags to assign to the source location. Tags are key-value pairs that you can associate with Amazon resources to help with organization, access control, and cost tracking. For more information, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor Resources</a>.</p>', 'CreateSourceLocationResponse$Tags' => '<p>The tags to assign to the source location. Tags are key-value pairs that you can associate with Amazon resources to help with organization, access control, and cost tracking. For more information, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor Resources</a>.</p>', 'CreateVodSourceRequest$Tags' => '<p>The tags to assign to the VOD source. Tags are key-value pairs that you can associate with Amazon resources to help with organization, access control, and cost tracking. For more information, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor Resources</a>.</p>', 'CreateVodSourceResponse$Tags' => '<p>The tags to assign to the VOD source. Tags are key-value pairs that you can associate with Amazon resources to help with organization, access control, and cost tracking. For more information, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor Resources</a>.</p>', 'DescribeChannelResponse$Tags' => '<p>The tags assigned to the channel. Tags are key-value pairs that you can associate with Amazon resources to help with organization, access control, and cost tracking. For more information, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor Resources</a>.</p>', 'DescribeLiveSourceResponse$Tags' => '<p>The tags assigned to the live source. Tags are key-value pairs that you can associate with Amazon resources to help with organization, access control, and cost tracking. For more information, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor Resources</a>.</p>', 'DescribeSourceLocationResponse$Tags' => '<p>The tags assigned to the source location. Tags are key-value pairs that you can associate with Amazon resources to help with organization, access control, and cost tracking. For more information, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor Resources</a>.</p>', 'DescribeVodSourceResponse$Tags' => '<p>The tags assigned to the VOD source. Tags are key-value pairs that you can associate with Amazon resources to help with organization, access control, and cost tracking. For more information, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor Resources</a>.</p>', 'GetPlaybackConfigurationResponse$Tags' => '<p>The tags assigned to the playback configuration. Tags are key-value pairs that you can associate with Amazon resources to help with organization, access control, and cost tracking. For more information, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor Resources</a>.</p>', 'ListTagsForResourceResponse$Tags' => '<p>The tags associated with this resource. Tags are key-value pairs that you can associate with Amazon resources to help with organization, access control, and cost tracking. For more information, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor Resources</a>.</p>', 'LiveSource$Tags' => '<p>The tags assigned to the live source. Tags are key-value pairs that you can associate with Amazon resources to help with organization, access control, and cost tracking. For more information, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor Resources</a>.</p>', 'PlaybackConfiguration$Tags' => '<p>The tags to assign to the playback configuration. Tags are key-value pairs that you can associate with Amazon resources to help with organization, access control, and cost tracking. For more information, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor Resources</a>.</p>', 'PrefetchRetrieval$DynamicVariables' => '<p>The dynamic variables to use for substitution during prefetch requests to the ad decision server (ADS).</p> <p>You initially configure <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/variables.html">dynamic variables</a> for the ADS URL when you set up your playback configuration. When you specify <code>DynamicVariables</code> for prefetch retrieval, MediaTailor includes the dynamic variables in the request to the ADS.</p>', 'PutPlaybackConfigurationRequest$Tags' => '<p>The tags to assign to the playback configuration. Tags are key-value pairs that you can associate with Amazon resources to help with organization, access control, and cost tracking. For more information, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor Resources</a>.</p>', 'PutPlaybackConfigurationResponse$Tags' => '<p>The tags to assign to the playback configuration. Tags are key-value pairs that you can associate with Amazon resources to help with organization, access control, and cost tracking. For more information, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor Resources</a>.</p>', 'SourceLocation$Tags' => '<p>The tags assigned to the source location. Tags are key-value pairs that you can associate with Amazon resources to help with organization, access control, and cost tracking. For more information, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor Resources</a>.</p>', 'TagResourceRequest$Tags' => '<p>The tags to assign to the resource. Tags are key-value pairs that you can associate with Amazon resources to help with organization, access control, and cost tracking. For more information, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor Resources</a>.</p>', 'UpdateChannelResponse$Tags' => '<p>The tags to assign to the channel. Tags are key-value pairs that you can associate with Amazon resources to help with organization, access control, and cost tracking. For more information, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor Resources</a>.</p>', 'UpdateLiveSourceResponse$Tags' => '<p>The tags to assign to the live source. Tags are key-value pairs that you can associate with Amazon resources to help with organization, access control, and cost tracking. For more information, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor Resources</a>.</p>', 'UpdateSourceLocationResponse$Tags' => '<p>The tags to assign to the source location. Tags are key-value pairs that you can associate with Amazon resources to help with organization, access control, and cost tracking. For more information, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor Resources</a>.</p>', 'UpdateVodSourceResponse$Tags' => '<p>The tags to assign to the VOD source. Tags are key-value pairs that you can associate with Amazon resources to help with organization, access control, and cost tracking. For more information, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor Resources</a>.</p>', 'VodSource$Tags' => '<p>The tags assigned to the VOD source. Tags are key-value pairs that you can associate with Amazon resources to help with organization, access control, and cost tracking. For more information, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor Resources</a>.</p>', ], ], '__string' => [ 'base' => NULL, 'refs' => [ 'Alert$AlertCode' => '<p>The code for the alert. For example, <code>NOT_PROCESSED</code>.</p>', 'Alert$AlertMessage' => '<p>If an alert is generated for a resource, an explanation of the reason for the alert.</p>', 'Alert$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'AlternateMedia$LiveSourceName' => '<p>The name of the live source for alternateMedia.</p>', 'AlternateMedia$SourceLocationName' => '<p>The name of the source location for alternateMedia.</p>', 'AlternateMedia$VodSourceName' => '<p>The name of the VOD source for alternateMedia.</p>', 'AudienceMedia$Audience' => '<p>The Audience defined in AudienceMedia.</p>', 'AvailMatchingCriteria$DynamicVariable' => '<p>The dynamic variable(s) that MediaTailor should use as avail matching criteria. MediaTailor only places the prefetched ads into the avail if the avail matches the criteria defined by the dynamic variable. For information about dynamic variables, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/variables.html">Using dynamic ad variables</a> in the <i>MediaTailor User Guide</i>.</p> <p>You can include up to 100 dynamic variables.</p>', 'AvailSuppression$Value' => '<p>A live edge offset time in HH:MM:SS. MediaTailor won\'t fill ad breaks on or behind this time in the manifest lookback window. If Value is set to 00:00:00, it is in sync with the live edge, and MediaTailor won\'t fill any ad breaks on or behind the live edge. If you set a Value time, MediaTailor won\'t fill any ad breaks on or behind this time in the manifest lookback window. For example, if you set 00:45:00, then MediaTailor will fill ad breaks that occur within 45 minutes behind the live edge, but won\'t fill ad breaks on or behind 45 minutes behind the live edge.</p>', 'BadRequestException$Message' => NULL, 'Bumper$EndUrl' => '<p>The URL for the end bumper asset.</p>', 'Bumper$StartUrl' => '<p>The URL for the start bumper asset.</p>', 'CdnConfiguration$AdSegmentUrlPrefix' => '<p>A non-default content delivery network (CDN) to serve ad segments. By default, AWS Elemental MediaTailor uses Amazon CloudFront with default cache settings as its CDN for ad segments. To set up an alternate CDN, create a rule in your CDN for the origin ads.mediatailor.<i>&lt;region&gt;</i>.amazonaws.com. Then specify the rule\'s name in this <code>AdSegmentUrlPrefix</code>. When AWS Elemental MediaTailor serves a manifest, it reports your CDN as the source for ad segments.</p>', 'CdnConfiguration$ContentSegmentUrlPrefix' => '<p>A content delivery network (CDN) to cache content segments, so that content requests don’t always have to go to the origin server. First, create a rule in your CDN for the content segment origin server. Then specify the rule\'s name in this <code>ContentSegmentUrlPrefix</code>. When AWS Elemental MediaTailor serves a manifest, it reports your CDN as the source for content segments.</p>', 'Channel$Arn' => '<p>The ARN of the channel.</p>', 'Channel$ChannelName' => '<p>The name of the channel.</p>', 'Channel$ChannelState' => '<p>Returns the state whether the channel is running or not.</p>', 'Channel$PlaybackMode' => '<p>The type of playback mode for this channel.</p> <p> <code>LINEAR</code> - Programs play back-to-back only once.</p> <p> <code>LOOP</code> - Programs play back-to-back in an endless loop. When the last program in the schedule plays, playback loops back to the first program in the schedule.</p>', 'Channel$Tier' => '<p>The tier for this channel. STANDARD tier channels can contain live programs.</p>', 'ConfigurationAliasesRequest$key' => '<p>The dynamic variable that has aliases.</p>', 'ConfigurationAliasesResponse$key' => '<p>The dynamic variable that has aliases.</p>', 'ConfigureLogsForChannelRequest$ChannelName' => '<p>The name of the channel.</p>', 'ConfigureLogsForChannelResponse$ChannelName' => '<p>The name of the channel.</p>', 'ConfigureLogsForPlaybackConfigurationRequest$PlaybackConfigurationName' => '<p>The name of the playback configuration.</p>', 'ConfigureLogsForPlaybackConfigurationResponse$PlaybackConfigurationName' => '<p>The name of the playback configuration.</p>', 'CreateChannelRequest$ChannelName' => '<p>The name of the channel.</p>', 'CreateChannelResponse$Arn' => '<p>The Amazon Resource Name (ARN) to assign to the channel.</p>', 'CreateChannelResponse$ChannelName' => '<p>The name to assign to the channel.</p>', 'CreateChannelResponse$PlaybackMode' => '<p>The playback mode to assign to the channel.</p>', 'CreateChannelResponse$Tier' => '<p>The tier of the channel.</p>', 'CreateLiveSourceRequest$LiveSourceName' => '<p>The name of the live source.</p>', 'CreateLiveSourceRequest$SourceLocationName' => '<p>The name of the source location.</p>', 'CreateLiveSourceResponse$Arn' => '<p>The ARN to assign to the live source.</p>', 'CreateLiveSourceResponse$LiveSourceName' => '<p>The name to assign to the live source.</p>', 'CreateLiveSourceResponse$SourceLocationName' => '<p>The name to assign to the source location of the live source.</p>', 'CreatePrefetchScheduleRequest$Name' => '<p>The name to assign to the schedule request.</p>', 'CreatePrefetchScheduleRequest$PlaybackConfigurationName' => '<p>The name to assign to the playback configuration.</p>', 'CreatePrefetchScheduleRequest$StreamId' => '<p>An optional stream identifier that MediaTailor uses to prefetch ads for multiple streams that use the same playback configuration. If <code>StreamId</code> is specified, MediaTailor returns all of the prefetch schedules with an exact match on <code>StreamId</code>. If not specified, MediaTailor returns all of the prefetch schedules for the playback configuration, regardless of <code>StreamId</code>.</p>', 'CreatePrefetchScheduleResponse$Arn' => '<p>The ARN to assign to the prefetch schedule.</p>', 'CreatePrefetchScheduleResponse$Name' => '<p>The name to assign to the prefetch schedule.</p>', 'CreatePrefetchScheduleResponse$PlaybackConfigurationName' => '<p>The name to assign to the playback configuration.</p>', 'CreatePrefetchScheduleResponse$StreamId' => '<p>An optional stream identifier that MediaTailor uses to prefetch ads for multiple streams that use the same playback configuration. If <code>StreamId</code> is specified, MediaTailor returns all of the prefetch schedules with an exact match on <code>StreamId</code>. If not specified, MediaTailor returns all of the prefetch schedules for the playback configuration, regardless of <code>StreamId</code>.</p>', 'CreateProgramRequest$ChannelName' => '<p>The name of the channel for this Program.</p>', 'CreateProgramRequest$LiveSourceName' => '<p>The name of the LiveSource for this Program.</p>', 'CreateProgramRequest$ProgramName' => '<p>The name of the Program.</p>', 'CreateProgramRequest$SourceLocationName' => '<p>The name of the source location.</p>', 'CreateProgramRequest$VodSourceName' => '<p>The name that\'s used to refer to a VOD source.</p>', 'CreateProgramResponse$Arn' => '<p>The ARN to assign to the program.</p>', 'CreateProgramResponse$ChannelName' => '<p>The name to assign to the channel for this program.</p>', 'CreateProgramResponse$LiveSourceName' => '<p>The name of the LiveSource for this Program.</p>', 'CreateProgramResponse$ProgramName' => '<p>The name to assign to this program.</p>', 'CreateProgramResponse$SourceLocationName' => '<p>The name to assign to the source location for this program.</p>', 'CreateProgramResponse$VodSourceName' => '<p>The name that\'s used to refer to a VOD source.</p>', 'CreateSourceLocationRequest$SourceLocationName' => '<p>The name associated with the source location.</p>', 'CreateSourceLocationResponse$Arn' => '<p>The ARN to assign to the source location.</p>', 'CreateSourceLocationResponse$SourceLocationName' => '<p>The name to assign to the source location.</p>', 'CreateVodSourceRequest$SourceLocationName' => '<p>The name of the source location for this VOD source.</p>', 'CreateVodSourceRequest$VodSourceName' => '<p>The name associated with the VOD source.&gt;</p>', 'CreateVodSourceResponse$Arn' => '<p>The ARN to assign to this VOD source.</p>', 'CreateVodSourceResponse$SourceLocationName' => '<p>The name to assign to the source location for this VOD source.</p>', 'CreateVodSourceResponse$VodSourceName' => '<p>The name to assign to the VOD source.</p>', 'DashConfiguration$ManifestEndpointPrefix' => '<p>The URL generated by MediaTailor to initiate a playback session. The session uses server-side reporting. This setting is ignored in PUT operations.</p>', 'DashConfiguration$MpdLocation' => '<p>The setting that controls whether MediaTailor includes the Location tag in DASH manifests. MediaTailor populates the Location tag with the URL for manifest update requests, to be used by players that don\'t support sticky redirects. Disable this if you have CDN routing rules set up for accessing MediaTailor manifests, and you are either using client-side reporting or your players support sticky HTTP redirects. Valid values are <code>DISABLED</code> and <code>EMT_DEFAULT</code>. The <code>EMT_DEFAULT</code> setting enables the inclusion of the tag and is the default value.</p>', 'DashConfigurationForPut$MpdLocation' => '<p>The setting that controls whether MediaTailor includes the Location tag in DASH manifests. MediaTailor populates the Location tag with the URL for manifest update requests, to be used by players that don\'t support sticky redirects. Disable this if you have CDN routing rules set up for accessing MediaTailor manifests, and you are either using client-side reporting or your players support sticky HTTP redirects. Valid values are <code>DISABLED</code> and <code>EMT_DEFAULT</code>. The <code>EMT_DEFAULT</code> setting enables the inclusion of the tag and is the default value.</p>', 'DefaultSegmentDeliveryConfiguration$BaseUrl' => '<p>The hostname of the server that will be used to serve segments. This string must include the protocol, such as <b>https://</b>.</p>', 'DeleteChannelPolicyRequest$ChannelName' => '<p>The name of the channel associated with this channel policy.</p>', 'DeleteChannelRequest$ChannelName' => '<p>The name of the channel.</p>', 'DeleteLiveSourceRequest$LiveSourceName' => '<p>The name of the live source.</p>', 'DeleteLiveSourceRequest$SourceLocationName' => '<p>The name of the source location associated with this Live Source.</p>', 'DeletePlaybackConfigurationRequest$Name' => '<p>The name of the playback configuration.</p>', 'DeletePrefetchScheduleRequest$Name' => '<p>The name of the prefetch schedule. If the action is successful, the service sends back an HTTP 204 response with an empty HTTP body.</p>', 'DeletePrefetchScheduleRequest$PlaybackConfigurationName' => '<p>The name of the playback configuration for this prefetch schedule.</p>', 'DeleteProgramRequest$ChannelName' => '<p>The name of the channel.</p>', 'DeleteProgramRequest$ProgramName' => '<p>The name of the program.</p>', 'DeleteSourceLocationRequest$SourceLocationName' => '<p>The name of the source location.</p>', 'DeleteVodSourceRequest$SourceLocationName' => '<p>The name of the source location associated with this VOD Source.</p>', 'DeleteVodSourceRequest$VodSourceName' => '<p>The name of the VOD source.</p>', 'DescribeChannelRequest$ChannelName' => '<p>The name of the channel.</p>', 'DescribeChannelResponse$Arn' => '<p>The ARN of the channel.</p>', 'DescribeChannelResponse$ChannelName' => '<p>The name of the channel.</p>', 'DescribeChannelResponse$PlaybackMode' => '<p>The channel\'s playback mode.</p>', 'DescribeChannelResponse$Tier' => '<p>The channel\'s tier.</p>', 'DescribeLiveSourceRequest$LiveSourceName' => '<p>The name of the live source.</p>', 'DescribeLiveSourceRequest$SourceLocationName' => '<p>The name of the source location associated with this Live Source.</p>', 'DescribeLiveSourceResponse$Arn' => '<p>The ARN of the live source.</p>', 'DescribeLiveSourceResponse$LiveSourceName' => '<p>The name of the live source.</p>', 'DescribeLiveSourceResponse$SourceLocationName' => '<p>The name of the source location associated with the live source.</p>', 'DescribeProgramRequest$ChannelName' => '<p>The name of the channel associated with this Program.</p>', 'DescribeProgramRequest$ProgramName' => '<p>The name of the program.</p>', 'DescribeProgramResponse$Arn' => '<p>The ARN of the program.</p>', 'DescribeProgramResponse$ChannelName' => '<p>The name of the channel that the program belongs to.</p>', 'DescribeProgramResponse$LiveSourceName' => '<p>The name of the LiveSource for this Program.</p>', 'DescribeProgramResponse$ProgramName' => '<p>The name of the program.</p>', 'DescribeProgramResponse$SourceLocationName' => '<p>The source location name.</p>', 'DescribeProgramResponse$VodSourceName' => '<p>The name that\'s used to refer to a VOD source.</p>', 'DescribeSourceLocationRequest$SourceLocationName' => '<p>The name of the source location.</p>', 'DescribeSourceLocationResponse$Arn' => '<p>The ARN of the source location.</p>', 'DescribeSourceLocationResponse$SourceLocationName' => '<p>The name of the source location.</p>', 'DescribeVodSourceRequest$SourceLocationName' => '<p>The name of the source location associated with this VOD Source.</p>', 'DescribeVodSourceRequest$VodSourceName' => '<p>The name of the VOD Source.</p>', 'DescribeVodSourceResponse$Arn' => '<p>The ARN of the VOD source.</p>', 'DescribeVodSourceResponse$SourceLocationName' => '<p>The name of the source location associated with the VOD source.</p>', 'DescribeVodSourceResponse$VodSourceName' => '<p>The name of the VOD source.</p>', 'GetChannelPolicyRequest$ChannelName' => '<p>The name of the channel associated with this Channel Policy.</p>', 'GetChannelPolicyResponse$Policy' => '<p>The IAM policy for the channel. IAM policies are used to control access to your channel.</p>', 'GetChannelScheduleRequest$Audience' => '<p>The single audience for GetChannelScheduleRequest.</p>', 'GetChannelScheduleRequest$ChannelName' => '<p>The name of the channel associated with this Channel Schedule.</p>', 'GetChannelScheduleRequest$DurationMinutes' => '<p>The duration in minutes of the channel schedule.</p>', 'GetChannelScheduleRequest$NextToken' => '<p>(Optional) If the playback configuration has more than <code>MaxResults</code> channel schedules, use <code>NextToken</code> to get the second and subsequent pages of results.</p> <p>For the first <code>GetChannelScheduleRequest</code> request, omit this value.</p> <p>For the second and subsequent requests, get the value of <code>NextToken</code> from the previous response and specify that value for <code>NextToken</code> in the request.</p> <p>If the previous response didn\'t include a <code>NextToken</code> element, there are no more channel schedules to get.</p>', 'GetChannelScheduleResponse$NextToken' => '<p>Pagination token returned by the list request when results exceed the maximum allowed. Use the token to fetch the next page of results.</p>', 'GetPlaybackConfigurationRequest$Name' => '<p>The identifier for the playback configuration.</p>', 'GetPlaybackConfigurationResponse$AdDecisionServerUrl' => '<p>The URL for the ad decision server (ADS). This includes the specification of static parameters and placeholders for dynamic parameters. AWS Elemental MediaTailor substitutes player-specific and session-specific parameters as needed when calling the ADS. Alternately, for testing, you can provide a static VAST URL. The maximum length is 25,000 characters.</p>', 'GetPlaybackConfigurationResponse$Name' => '<p>The identifier for the playback configuration.</p>', 'GetPlaybackConfigurationResponse$PlaybackConfigurationArn' => '<p>The Amazon Resource Name (ARN) for the playback configuration.</p>', 'GetPlaybackConfigurationResponse$PlaybackEndpointPrefix' => '<p>The URL that the player accesses to get a manifest from AWS Elemental MediaTailor. This session will use server-side reporting.</p>', 'GetPlaybackConfigurationResponse$SessionInitializationEndpointPrefix' => '<p>The URL that the player uses to initialize a session that uses client-side reporting.</p>', 'GetPlaybackConfigurationResponse$SlateAdUrl' => '<p>The URL for a high-quality video asset to transcode and use to fill in time that\'s not used by ads. AWS Elemental MediaTailor shows the slate to fill in gaps in media content. Configuring the slate is optional for non-VPAID playback configurations. For VPAID, the slate is required because MediaTailor provides it in the slots designated for dynamic ad content. The slate must be a high-quality asset that contains both audio and video.</p>', 'GetPlaybackConfigurationResponse$TranscodeProfileName' => '<p>The name that is used to associate this playback configuration with a custom transcode profile. This overrides the dynamic transcoding defaults of MediaTailor. Use this only if you have already set up custom profiles with the help of AWS Support.</p>', 'GetPlaybackConfigurationResponse$VideoContentSourceUrl' => '<p>The URL prefix for the parent manifest for the stream, minus the asset ID. The maximum length is 512 characters.</p>', 'GetPrefetchScheduleRequest$Name' => '<p>The name of the prefetch schedule. The name must be unique among all prefetch schedules that are associated with the specified playback configuration.</p>', 'GetPrefetchScheduleRequest$PlaybackConfigurationName' => '<p>Returns information about the prefetch schedule for a specific playback configuration. If you call <code>GetPrefetchSchedule</code> on an expired prefetch schedule, MediaTailor returns an HTTP 404 status code.</p>', 'GetPrefetchScheduleResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the prefetch schedule.</p>', 'GetPrefetchScheduleResponse$Name' => '<p>The name of the prefetch schedule. The name must be unique among all prefetch schedules that are associated with the specified playback configuration.</p>', 'GetPrefetchScheduleResponse$PlaybackConfigurationName' => '<p>The name of the playback configuration to create the prefetch schedule for.</p>', 'GetPrefetchScheduleResponse$StreamId' => '<p>An optional stream identifier that you can specify in order to prefetch for multiple streams that use the same playback configuration.</p>', 'HlsConfiguration$ManifestEndpointPrefix' => '<p>The URL that is used to initiate a playback session for devices that support Apple HLS. The session uses server-side reporting.</p>', 'HttpConfiguration$BaseUrl' => '<p>The base URL for the source location host server. This string must include the protocol, such as <b>https://</b>.</p>', 'HttpPackageConfiguration$Path' => '<p>The relative path to the URL for this VOD source. This is combined with <code>SourceLocation::HttpConfiguration::BaseUrl</code> to form a valid URL.</p>', 'HttpPackageConfiguration$SourceGroup' => '<p>The name of the source group. This has to match one of the <code>Channel::Outputs::SourceGroup</code>.</p>', 'ListAlertsRequest$NextToken' => '<p>Pagination token returned by the list request when results exceed the maximum allowed. Use the token to fetch the next page of results.</p>', 'ListAlertsRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'ListAlertsResponse$NextToken' => '<p>Pagination token returned by the list request when results exceed the maximum allowed. Use the token to fetch the next page of results.</p>', 'ListChannelsRequest$NextToken' => '<p>Pagination token returned by the list request when results exceed the maximum allowed. Use the token to fetch the next page of results.</p>', 'ListChannelsResponse$NextToken' => '<p>Pagination token returned by the list request when results exceed the maximum allowed. Use the token to fetch the next page of results.</p>', 'ListLiveSourcesRequest$NextToken' => '<p>Pagination token returned by the list request when results exceed the maximum allowed. Use the token to fetch the next page of results.</p>', 'ListLiveSourcesRequest$SourceLocationName' => '<p>The name of the source location associated with this Live Sources list.</p>', 'ListLiveSourcesResponse$NextToken' => '<p>Pagination token returned by the list request when results exceed the maximum allowed. Use the token to fetch the next page of results.</p>', 'ListPlaybackConfigurationsRequest$NextToken' => '<p>Pagination token returned by the list request when results exceed the maximum allowed. Use the token to fetch the next page of results.</p>', 'ListPlaybackConfigurationsResponse$NextToken' => '<p>Pagination token returned by the GET list request when results exceed the maximum allowed. Use the token to fetch the next page of results.</p>', 'ListPrefetchSchedulesRequest$NextToken' => '<p>(Optional) If the playback configuration has more than <code>MaxResults</code> prefetch schedules, use <code>NextToken</code> to get the second and subsequent pages of results.</p> <p> For the first <code>ListPrefetchSchedulesRequest</code> request, omit this value.</p> <p> For the second and subsequent requests, get the value of <code>NextToken</code> from the previous response and specify that value for <code>NextToken</code> in the request.</p> <p> If the previous response didn\'t include a <code>NextToken</code> element, there are no more prefetch schedules to get.</p>', 'ListPrefetchSchedulesRequest$PlaybackConfigurationName' => '<p>Retrieves the prefetch schedule(s) for a specific playback configuration.</p>', 'ListPrefetchSchedulesRequest$StreamId' => '<p>An optional filtering parameter whereby MediaTailor filters the prefetch schedules to include only specific streams.</p>', 'ListPrefetchSchedulesResponse$NextToken' => '<p>Pagination token returned by the list request when results exceed the maximum allowed. Use the token to fetch the next page of results.</p>', 'ListSourceLocationsRequest$NextToken' => '<p>Pagination token returned by the list request when results exceed the maximum allowed. Use the token to fetch the next page of results.</p>', 'ListSourceLocationsResponse$NextToken' => '<p>Pagination token returned by the list request when results exceed the maximum allowed. Use the token to fetch the next page of results.</p>', 'ListTagsForResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) associated with this resource.</p>', 'ListVodSourcesRequest$NextToken' => '<p>Pagination token returned by the list request when results exceed the maximum allowed. Use the token to fetch the next page of results.</p>', 'ListVodSourcesRequest$SourceLocationName' => '<p>The name of the source location associated with this VOD Source list.</p>', 'ListVodSourcesResponse$NextToken' => '<p>Pagination token returned by the list request when results exceed the maximum allowed. Use the token to fetch the next page of results.</p>', 'LivePreRollConfiguration$AdDecisionServerUrl' => '<p>The URL for the ad decision server (ADS) for pre-roll ads. This includes the specification of static parameters and placeholders for dynamic parameters. AWS Elemental MediaTailor substitutes player-specific and session-specific parameters as needed when calling the ADS. Alternately, for testing, you can provide a static VAST URL. The maximum length is 25,000 characters.</p>', 'LiveSource$Arn' => '<p>The ARN for the live source.</p>', 'LiveSource$LiveSourceName' => '<p>The name that\'s used to refer to a live source.</p>', 'LiveSource$SourceLocationName' => '<p>The name of the source location.</p>', 'PlaybackConfiguration$AdDecisionServerUrl' => '<p>The URL for the ad decision server (ADS). This includes the specification of static parameters and placeholders for dynamic parameters. AWS Elemental MediaTailor substitutes player-specific and session-specific parameters as needed when calling the ADS. Alternately, for testing you can provide a static VAST URL. The maximum length is 25,000 characters.</p>', 'PlaybackConfiguration$Name' => '<p>The identifier for the playback configuration.</p>', 'PlaybackConfiguration$PlaybackConfigurationArn' => '<p>The Amazon Resource Name (ARN) for the playback configuration.</p>', 'PlaybackConfiguration$PlaybackEndpointPrefix' => '<p>The URL that the player accesses to get a manifest from AWS Elemental MediaTailor.</p>', 'PlaybackConfiguration$SessionInitializationEndpointPrefix' => '<p>The URL that the player uses to initialize a session that uses client-side reporting.</p>', 'PlaybackConfiguration$SlateAdUrl' => '<p>The URL for a video asset to transcode and use to fill in time that\'s not used by ads. AWS Elemental MediaTailor shows the slate to fill in gaps in media content. Configuring the slate is optional for non-VPAID playback configurations. For VPAID, the slate is required because MediaTailor provides it in the slots designated for dynamic ad content. The slate must be a high-quality asset that contains both audio and video.</p>', 'PlaybackConfiguration$TranscodeProfileName' => '<p>The name that is used to associate this playback configuration with a custom transcode profile. This overrides the dynamic transcoding defaults of MediaTailor. Use this only if you have already set up custom profiles with the help of AWS Support.</p>', 'PlaybackConfiguration$VideoContentSourceUrl' => '<p>The URL prefix for the parent manifest for the stream, minus the asset ID. The maximum length is 512 characters.</p>', 'PrefetchSchedule$Arn' => '<p>The Amazon Resource Name (ARN) of the prefetch schedule.</p>', 'PrefetchSchedule$Name' => '<p>The name of the prefetch schedule. The name must be unique among all prefetch schedules that are associated with the specified playback configuration.</p>', 'PrefetchSchedule$PlaybackConfigurationName' => '<p>The name of the playback configuration to create the prefetch schedule for.</p>', 'PrefetchSchedule$StreamId' => '<p>An optional stream identifier that you can specify in order to prefetch for multiple streams that use the same playback configuration.</p>', 'PutChannelPolicyRequest$ChannelName' => '<p>The channel name associated with this Channel Policy.</p>', 'PutChannelPolicyRequest$Policy' => '<p>Adds an IAM role that determines the permissions of your channel.</p>', 'PutPlaybackConfigurationRequest$AdDecisionServerUrl' => '<p>The URL for the ad decision server (ADS). This includes the specification of static parameters and placeholders for dynamic parameters. AWS Elemental MediaTailor substitutes player-specific and session-specific parameters as needed when calling the ADS. Alternately, for testing you can provide a static VAST URL. The maximum length is 25,000 characters.</p>', 'PutPlaybackConfigurationRequest$Name' => '<p>The identifier for the playback configuration.</p>', 'PutPlaybackConfigurationRequest$SlateAdUrl' => '<p>The URL for a high-quality video asset to transcode and use to fill in time that\'s not used by ads. AWS Elemental MediaTailor shows the slate to fill in gaps in media content. Configuring the slate is optional for non-VPAID configurations. For VPAID, the slate is required because MediaTailor provides it in the slots that are designated for dynamic ad content. The slate must be a high-quality asset that contains both audio and video.</p>', 'PutPlaybackConfigurationRequest$TranscodeProfileName' => '<p>The name that is used to associate this playback configuration with a custom transcode profile. This overrides the dynamic transcoding defaults of MediaTailor. Use this only if you have already set up custom profiles with the help of AWS Support.</p>', 'PutPlaybackConfigurationRequest$VideoContentSourceUrl' => '<p>The URL prefix for the parent manifest for the stream, minus the asset ID. The maximum length is 512 characters.</p>', 'PutPlaybackConfigurationResponse$AdDecisionServerUrl' => '<p>The URL for the ad decision server (ADS). This includes the specification of static parameters and placeholders for dynamic parameters. AWS Elemental MediaTailor substitutes player-specific and session-specific parameters as needed when calling the ADS. Alternately, for testing you can provide a static VAST URL. The maximum length is 25,000 characters.</p>', 'PutPlaybackConfigurationResponse$Name' => '<p>The identifier for the playback configuration.</p>', 'PutPlaybackConfigurationResponse$PlaybackConfigurationArn' => '<p>The Amazon Resource Name (ARN) associated with the playback configuration.</p>', 'PutPlaybackConfigurationResponse$PlaybackEndpointPrefix' => '<p>The playback endpoint prefix associated with the playback configuration.</p>', 'PutPlaybackConfigurationResponse$SessionInitializationEndpointPrefix' => '<p>The session initialization endpoint prefix associated with the playback configuration.</p>', 'PutPlaybackConfigurationResponse$SlateAdUrl' => '<p>The URL for a high-quality video asset to transcode and use to fill in time that\'s not used by ads. AWS Elemental MediaTailor shows the slate to fill in gaps in media content. Configuring the slate is optional for non-VPAID configurations. For VPAID, the slate is required because MediaTailor provides it in the slots that are designated for dynamic ad content. The slate must be a high-quality asset that contains both audio and video.</p>', 'PutPlaybackConfigurationResponse$TranscodeProfileName' => '<p>The name that is used to associate this playback configuration with a custom transcode profile. This overrides the dynamic transcoding defaults of MediaTailor. Use this only if you have already set up custom profiles with the help of AWS Support.</p>', 'PutPlaybackConfigurationResponse$VideoContentSourceUrl' => '<p>The URL prefix for the parent manifest for the stream, minus the asset ID. The maximum length is 512 characters.</p>', 'RequestOutputItem$ManifestName' => '<p>The name of the manifest for the channel. The name appears in the <code>PlaybackUrl</code>.</p>', 'RequestOutputItem$SourceGroup' => '<p>A string used to match which <code>HttpPackageConfiguration</code> is used for each <code>VodSource</code>.</p>', 'ResponseOutputItem$ManifestName' => '<p>The name of the manifest for the channel that will appear in the channel output\'s playback URL.</p>', 'ResponseOutputItem$PlaybackUrl' => '<p>The URL used for playback by content players.</p>', 'ResponseOutputItem$SourceGroup' => '<p>A string used to associate a package configuration source group with a channel output.</p>', 'ScheduleAdBreak$SourceLocationName' => '<p>The name of the source location containing the VOD source used for the ad break.</p>', 'ScheduleAdBreak$VodSourceName' => '<p>The name of the VOD source used for the ad break.</p>', 'ScheduleEntry$Arn' => '<p>The ARN of the program.</p>', 'ScheduleEntry$ChannelName' => '<p>The name of the channel that uses this schedule.</p>', 'ScheduleEntry$LiveSourceName' => '<p>The name of the live source used for the program.</p>', 'ScheduleEntry$ProgramName' => '<p>The name of the program.</p>', 'ScheduleEntry$SourceLocationName' => '<p>The name of the source location.</p>', 'ScheduleEntry$VodSourceName' => '<p>The name of the VOD source.</p>', 'SecretsManagerAccessTokenConfiguration$HeaderName' => '<p>The name of the HTTP header used to supply the access token in requests to the source location.</p>', 'SecretsManagerAccessTokenConfiguration$SecretArn' => '<p>The Amazon Resource Name (ARN) of the AWS Secrets Manager secret that contains the access token.</p>', 'SecretsManagerAccessTokenConfiguration$SecretStringKey' => '<p>The AWS Secrets Manager <a href="https://docs.aws.amazon.com/secretsmanager/latest/apireference/API_CreateSecret.html#SecretsManager-CreateSecret-request-SecretString.html">SecretString</a> key associated with the access token. MediaTailor uses the key to look up SecretString key and value pair containing the access token.</p>', 'SegmentDeliveryConfiguration$BaseUrl' => '<p>The base URL of the host or path of the segment delivery server that you\'re using to serve segments. This is typically a content delivery network (CDN). The URL can be absolute or relative. To use an absolute URL include the protocol, such as <code>https://example.com/some/path</code>. To use a relative URL specify the relative path, such as <code>/some/path*</code>.</p>', 'SegmentDeliveryConfiguration$Name' => '<p>A unique identifier used to distinguish between multiple segment delivery configurations in a source location.</p>', 'SlateSource$SourceLocationName' => '<p>The name of the source location where the slate VOD source is stored.</p>', 'SlateSource$VodSourceName' => '<p>The slate VOD source name. The VOD source must already exist in a source location before it can be used for slate.</p>', 'SourceLocation$Arn' => '<p>The ARN of the SourceLocation.</p>', 'SourceLocation$SourceLocationName' => '<p>The name of the source location.</p>', 'StartChannelRequest$ChannelName' => '<p>The name of the channel.</p>', 'StopChannelRequest$ChannelName' => '<p>The name of the channel.</p>', 'TagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) associated with the resource.</p>', 'Transition$RelativeProgram' => '<p>The name of the program that this program will be inserted next to, as defined by <code>RelativePosition</code>.</p>', 'Transition$Type' => '<p>Defines when the program plays in the schedule. You can set the value to <code>ABSOLUTE</code> or <code>RELATIVE</code>.</p> <p> <code>ABSOLUTE</code> - The program plays at a specific wall clock time. This setting can only be used for channels using the <code>LINEAR</code> <code>PlaybackMode</code>.</p> <p>Note the following considerations when using <code>ABSOLUTE</code> transitions:</p> <p>If the preceding program in the schedule has a duration that extends past the wall clock time, MediaTailor truncates the preceding program on a common segment boundary.</p> <p>If there are gaps in playback, MediaTailor plays the <code>FillerSlate</code> you configured for your linear channel.</p> <p> <code>RELATIVE</code> - The program is inserted into the schedule either before or after a program that you specify via <code>RelativePosition</code>.</p>', 'UntagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource to untag.</p>', 'UpdateChannelRequest$ChannelName' => '<p>The name of the channel.</p>', 'UpdateChannelResponse$Arn' => '<p>The Amazon Resource Name (ARN) associated with the channel.</p>', 'UpdateChannelResponse$ChannelName' => '<p>The name of the channel.</p>', 'UpdateChannelResponse$PlaybackMode' => '<p>The type of playback mode for this channel.</p> <p> <code>LINEAR</code> - Programs play back-to-back only once.</p> <p> <code>LOOP</code> - Programs play back-to-back in an endless loop. When the last program in the schedule plays, playback loops back to the first program in the schedule.</p>', 'UpdateChannelResponse$Tier' => '<p>The tier associated with this Channel.</p>', 'UpdateLiveSourceRequest$LiveSourceName' => '<p>The name of the live source.</p>', 'UpdateLiveSourceRequest$SourceLocationName' => '<p>The name of the source location associated with this Live Source.</p>', 'UpdateLiveSourceResponse$Arn' => '<p>The Amazon Resource Name (ARN) associated with this live source.</p>', 'UpdateLiveSourceResponse$LiveSourceName' => '<p>The name of the live source.</p>', 'UpdateLiveSourceResponse$SourceLocationName' => '<p>The name of the source location associated with the live source.</p>', 'UpdateProgramRequest$ChannelName' => '<p>The name of the channel for this Program.</p>', 'UpdateProgramRequest$ProgramName' => '<p>The name of the Program.</p>', 'UpdateProgramResponse$Arn' => '<p>The ARN to assign to the program.</p>', 'UpdateProgramResponse$ChannelName' => '<p>The name to assign to the channel for this program.</p>', 'UpdateProgramResponse$LiveSourceName' => '<p>The name of the LiveSource for this Program.</p>', 'UpdateProgramResponse$ProgramName' => '<p>The name to assign to this program.</p>', 'UpdateProgramResponse$SourceLocationName' => '<p>The name to assign to the source location for this program.</p>', 'UpdateProgramResponse$VodSourceName' => '<p>The name that\'s used to refer to a VOD source.</p>', 'UpdateSourceLocationRequest$SourceLocationName' => '<p>The name of the source location.</p>', 'UpdateSourceLocationResponse$Arn' => '<p>The Amazon Resource Name (ARN) associated with the source location.</p>', 'UpdateSourceLocationResponse$SourceLocationName' => '<p>The name of the source location.</p>', 'UpdateVodSourceRequest$SourceLocationName' => '<p>The name of the source location associated with this VOD Source.</p>', 'UpdateVodSourceRequest$VodSourceName' => '<p>The name of the VOD source.</p>', 'UpdateVodSourceResponse$Arn' => '<p>The Amazon Resource Name (ARN) associated with the VOD source.</p>', 'UpdateVodSourceResponse$SourceLocationName' => '<p>The name of the source location associated with the VOD source.</p>', 'UpdateVodSourceResponse$VodSourceName' => '<p>The name of the VOD source.</p>', 'VodSource$Arn' => '<p>The ARN for the VOD source.</p>', 'VodSource$SourceLocationName' => '<p>The name of the source location that the VOD source is associated with.</p>', 'VodSource$VodSourceName' => '<p>The name of the VOD source.</p>', '__listOf__string$member' => NULL, '__mapOf__string$key' => NULL, '__mapOf__string$value' => NULL, ], ], '__timestampUnix' => [ 'base' => NULL, 'refs' => [ 'Alert$LastModifiedTime' => '<p>The timestamp when the alert was last modified.</p>', 'Channel$CreationTime' => '<p>The timestamp of when the channel was created.</p>', 'Channel$LastModifiedTime' => '<p>The timestamp of when the channel was last modified.</p>', 'CreateChannelResponse$CreationTime' => '<p>The timestamp of when the channel was created.</p>', 'CreateChannelResponse$LastModifiedTime' => '<p>The timestamp of when the channel was last modified.</p>', 'CreateLiveSourceResponse$CreationTime' => '<p>The time the live source was created.</p>', 'CreateLiveSourceResponse$LastModifiedTime' => '<p>The time the live source was last modified.</p>', 'CreateProgramResponse$CreationTime' => '<p>The time the program was created.</p>', 'CreateProgramResponse$ScheduledStartTime' => '<p>The scheduled start time for this Program.</p>', 'CreateSourceLocationResponse$CreationTime' => '<p>The time the source location was created.</p>', 'CreateSourceLocationResponse$LastModifiedTime' => '<p>The time the source location was last modified.</p>', 'CreateVodSourceResponse$CreationTime' => '<p>The time the VOD source was created.</p>', 'CreateVodSourceResponse$LastModifiedTime' => '<p>The time the VOD source was last modified.</p>', 'DescribeChannelResponse$CreationTime' => '<p>The timestamp of when the channel was created.</p>', 'DescribeChannelResponse$LastModifiedTime' => '<p>The timestamp of when the channel was last modified.</p>', 'DescribeLiveSourceResponse$CreationTime' => '<p>The timestamp that indicates when the live source was created.</p>', 'DescribeLiveSourceResponse$LastModifiedTime' => '<p>The timestamp that indicates when the live source was modified.</p>', 'DescribeProgramResponse$CreationTime' => '<p>The timestamp of when the program was created.</p>', 'DescribeProgramResponse$ScheduledStartTime' => '<p>The date and time that the program is scheduled to start in ISO 8601 format and Coordinated Universal Time (UTC). For example, the value 2021-03-27T17:48:16.751Z represents March 27, 2021 at 17:48:16.751 UTC.</p>', 'DescribeSourceLocationResponse$CreationTime' => '<p>The timestamp that indicates when the source location was created.</p>', 'DescribeSourceLocationResponse$LastModifiedTime' => '<p>The timestamp that indicates when the source location was last modified.</p>', 'DescribeVodSourceResponse$CreationTime' => '<p>The timestamp that indicates when the VOD source was created.</p>', 'DescribeVodSourceResponse$LastModifiedTime' => '<p>The last modified time of the VOD source.</p>', 'LiveSource$CreationTime' => '<p>The timestamp that indicates when the live source was created.</p>', 'LiveSource$LastModifiedTime' => '<p>The timestamp that indicates when the live source was last modified.</p>', 'PrefetchConsumption$EndTime' => '<p>The time when MediaTailor no longer considers the prefetched ads for use in an ad break. MediaTailor automatically deletes prefetch schedules no less than seven days after the end time. If you\'d like to manually delete the prefetch schedule, you can call <code>DeletePrefetchSchedule</code>.</p>', 'PrefetchConsumption$StartTime' => '<p>The time when prefetched ads are considered for use in an ad break. If you don\'t specify <code>StartTime</code>, the prefetched ads are available after MediaTailor retrives them from the ad decision server.</p>', 'PrefetchRetrieval$EndTime' => '<p>The time when prefetch retrieval ends for the ad break. Prefetching will be attempted for manifest requests that occur at or before this time.</p>', 'PrefetchRetrieval$StartTime' => '<p>The time when prefetch retrievals can start for this break. Ad prefetching will be attempted for manifest requests that occur at or after this time. Defaults to the current time. If not specified, the prefetch retrieval starts as soon as possible.</p>', 'ScheduleAdBreak$ApproximateStartTime' => '<p>The approximate time that the ad will start playing.</p>', 'ScheduleEntry$ApproximateStartTime' => '<p>The approximate time that the program will start playing.</p>', 'SourceLocation$CreationTime' => '<p>The timestamp that indicates when the source location was created.</p>', 'SourceLocation$LastModifiedTime' => '<p>The timestamp that indicates when the source location was last modified.</p>', 'UpdateChannelResponse$CreationTime' => '<p>The timestamp of when the channel was created.</p>', 'UpdateChannelResponse$LastModifiedTime' => '<p>The timestamp that indicates when the channel was last modified.</p>', 'UpdateLiveSourceResponse$CreationTime' => '<p>The timestamp that indicates when the live source was created.</p>', 'UpdateLiveSourceResponse$LastModifiedTime' => '<p>The timestamp that indicates when the live source was last modified.</p>', 'UpdateProgramResponse$CreationTime' => '<p>The time the program was created.</p>', 'UpdateProgramResponse$ScheduledStartTime' => '<p>The scheduled start time for this Program.</p>', 'UpdateSourceLocationResponse$CreationTime' => '<p>The timestamp that indicates when the source location was created.</p>', 'UpdateSourceLocationResponse$LastModifiedTime' => '<p>The timestamp that indicates when the source location was last modified.</p>', 'UpdateVodSourceResponse$CreationTime' => '<p>The timestamp that indicates when the VOD source was created.</p>', 'UpdateVodSourceResponse$LastModifiedTime' => '<p>The timestamp that indicates when the VOD source was last modified.</p>', 'VodSource$CreationTime' => '<p>The timestamp that indicates when the VOD source was created.</p>', 'VodSource$LastModifiedTime' => '<p>The timestamp that indicates when the VOD source was last modified.</p>', ], ], 'adMarkupTypes' => [ 'base' => NULL, 'refs' => [ 'HlsPlaylistSettings$AdMarkupType' => '<p>Determines the type of SCTE 35 tags to use in ad markup. Specify <code>DATERANGE</code> to use <code>DATERANGE</code> tags (for live or VOD content). Specify <code>SCTE35_ENHANCED</code> to use <code>EXT-X-CUE-OUT</code> and <code>EXT-X-CUE-IN</code> tags (for VOD content only).</p>', ], ], ],];
