<?php
// This file was auto-generated from sdk-root/src/data/mgh/2017-05-31/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>The AWS Migration Hub API methods help to obtain server and application migration status and integrate your resource-specific migration tool by providing a programmatic interface to Migration Hub.</p> <p>Remember that you must set your AWS Migration Hub home region before you call any of these APIs, or a <code>HomeRegionNotSetException</code> error will be returned. Also, you must make the API calls while in your home region.</p>', 'operations' => [ 'AssociateCreatedArtifact' => '<p>Associates a created artifact of an AWS cloud resource, the target receiving the migration, with the migration task performed by a migration tool. This API has the following traits:</p> <ul> <li> <p>Migration tools can call the <code>AssociateCreatedArtifact</code> operation to indicate which AWS artifact is associated with a migration task.</p> </li> <li> <p>The created artifact name must be provided in ARN (Amazon Resource Name) format which will contain information about type and region; for example: <code>arn:aws:ec2:us-east-1:488216288981:image/ami-6d0ba87b</code>.</p> </li> <li> <p>Examples of the AWS resource behind the created artifact are, AMI\'s, EC2 instance, or DMS endpoint, etc.</p> </li> </ul>', 'AssociateDiscoveredResource' => '<p>Associates a discovered resource ID from Application Discovery Service with a migration task.</p>', 'CreateProgressUpdateStream' => '<p>Creates a progress update stream which is an AWS resource used for access control as well as a namespace for migration task names that is implicitly linked to your AWS account. It must uniquely identify the migration tool as it is used for all updates made by the tool; however, it does not need to be unique for each AWS account because it is scoped to the AWS account.</p>', 'DeleteProgressUpdateStream' => '<p>Deletes a progress update stream, including all of its tasks, which was previously created as an AWS resource used for access control. This API has the following traits:</p> <ul> <li> <p>The only parameter needed for <code>DeleteProgressUpdateStream</code> is the stream name (same as a <code>CreateProgressUpdateStream</code> call).</p> </li> <li> <p>The call will return, and a background process will asynchronously delete the stream and all of its resources (tasks, associated resources, resource attributes, created artifacts).</p> </li> <li> <p>If the stream takes time to be deleted, it might still show up on a <code>ListProgressUpdateStreams</code> call.</p> </li> <li> <p> <code>CreateProgressUpdateStream</code>, <code>ImportMigrationTask</code>, <code>NotifyMigrationTaskState</code>, and all Associate[*] APIs related to the tasks belonging to the stream will throw "InvalidInputException" if the stream of the same name is in the process of being deleted.</p> </li> <li> <p>Once the stream and all of its resources are deleted, <code>CreateProgressUpdateStream</code> for a stream of the same name will succeed, and that stream will be an entirely new logical resource (without any resources associated with the old stream).</p> </li> </ul>', 'DescribeApplicationState' => '<p>Gets the migration status of an application.</p>', 'DescribeMigrationTask' => '<p>Retrieves a list of all attributes associated with a specific migration task.</p>', 'DisassociateCreatedArtifact' => '<p>Disassociates a created artifact of an AWS resource with a migration task performed by a migration tool that was previously associated. This API has the following traits:</p> <ul> <li> <p>A migration user can call the <code>DisassociateCreatedArtifacts</code> operation to disassociate a created AWS Artifact from a migration task.</p> </li> <li> <p>The created artifact name must be provided in ARN (Amazon Resource Name) format which will contain information about type and region; for example: <code>arn:aws:ec2:us-east-1:488216288981:image/ami-6d0ba87b</code>.</p> </li> <li> <p>Examples of the AWS resource behind the created artifact are, AMI\'s, EC2 instance, or RDS instance, etc.</p> </li> </ul>', 'DisassociateDiscoveredResource' => '<p>Disassociate an Application Discovery Service discovered resource from a migration task.</p>', 'ImportMigrationTask' => '<p>Registers a new migration task which represents a server, database, etc., being migrated to AWS by a migration tool.</p> <p>This API is a prerequisite to calling the <code>NotifyMigrationTaskState</code> API as the migration tool must first register the migration task with Migration Hub.</p>', 'ListApplicationStates' => '<p>Lists all the migration statuses for your applications. If you use the optional <code>ApplicationIds</code> parameter, only the migration statuses for those applications will be returned.</p>', 'ListCreatedArtifacts' => '<p>Lists the created artifacts attached to a given migration task in an update stream. This API has the following traits:</p> <ul> <li> <p>Gets the list of the created artifacts while migration is taking place.</p> </li> <li> <p>Shows the artifacts created by the migration tool that was associated by the <code>AssociateCreatedArtifact</code> API. </p> </li> <li> <p>Lists created artifacts in a paginated interface. </p> </li> </ul>', 'ListDiscoveredResources' => '<p>Lists discovered resources associated with the given <code>MigrationTask</code>.</p>', 'ListMigrationTasks' => '<p>Lists all, or filtered by resource name, migration tasks associated with the user account making this call. This API has the following traits:</p> <ul> <li> <p>Can show a summary list of the most recent migration tasks.</p> </li> <li> <p>Can show a summary list of migration tasks associated with a given discovered resource.</p> </li> <li> <p>Lists migration tasks in a paginated interface.</p> </li> </ul>', 'ListProgressUpdateStreams' => '<p>Lists progress update streams associated with the user account making this call.</p>', 'NotifyApplicationState' => '<p>Sets the migration state of an application. For a given application identified by the value passed to <code>ApplicationId</code>, its status is set or updated by passing one of three values to <code>Status</code>: <code>NOT_STARTED | IN_PROGRESS | COMPLETED</code>.</p>', 'NotifyMigrationTaskState' => '<p>Notifies Migration Hub of the current status, progress, or other detail regarding a migration task. This API has the following traits:</p> <ul> <li> <p>Migration tools will call the <code>NotifyMigrationTaskState</code> API to share the latest progress and status.</p> </li> <li> <p> <code>MigrationTaskName</code> is used for addressing updates to the correct target.</p> </li> <li> <p> <code>ProgressUpdateStream</code> is used for access control and to provide a namespace for each migration tool.</p> </li> </ul>', 'PutResourceAttributes' => '<p>Provides identifying details of the resource being migrated so that it can be associated in the Application Discovery Service repository. This association occurs asynchronously after <code>PutResourceAttributes</code> returns.</p> <important> <ul> <li> <p>Keep in mind that subsequent calls to PutResourceAttributes will override previously stored attributes. For example, if it is first called with a MAC address, but later, it is desired to <i>add</i> an IP address, it will then be required to call it with <i>both</i> the IP and MAC addresses to prevent overriding the MAC address.</p> </li> <li> <p>Note the instructions regarding the special use case of the <a href="https://docs.aws.amazon.com/migrationhub/latest/ug/API_PutResourceAttributes.html#migrationhub-PutResourceAttributes-request-ResourceAttributeList"> <code>ResourceAttributeList</code> </a> parameter when specifying any "VM" related value.</p> </li> </ul> </important> <note> <p>Because this is an asynchronous call, it will always return 200, whether an association occurs or not. To confirm if an association was found based on the provided details, call <code>ListDiscoveredResources</code>.</p> </note>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You do not have sufficient access to perform this action.</p>', 'refs' => [], ], 'ApplicationId' => [ 'base' => NULL, 'refs' => [ 'ApplicationIds$member' => NULL, 'ApplicationState$ApplicationId' => '<p>The configurationId from the Application Discovery Service that uniquely identifies an application.</p>', 'DescribeApplicationStateRequest$ApplicationId' => '<p>The configurationId in Application Discovery Service that uniquely identifies the grouped application.</p>', 'NotifyApplicationStateRequest$ApplicationId' => '<p>The configurationId in Application Discovery Service that uniquely identifies the grouped application.</p>', ], ], 'ApplicationIds' => [ 'base' => NULL, 'refs' => [ 'ListApplicationStatesRequest$ApplicationIds' => '<p>The configurationIds from the Application Discovery Service that uniquely identifies your applications.</p>', ], ], 'ApplicationState' => [ 'base' => '<p>The state of an application discovered through Migration Hub import, the AWS Agentless Discovery Connector, or the AWS Application Discovery Agent.</p>', 'refs' => [ 'ApplicationStateList$member' => NULL, ], ], 'ApplicationStateList' => [ 'base' => NULL, 'refs' => [ 'ListApplicationStatesResult$ApplicationStateList' => '<p>A list of Applications that exist in Application Discovery Service.</p>', ], ], 'ApplicationStatus' => [ 'base' => NULL, 'refs' => [ 'ApplicationState$ApplicationStatus' => '<p>The current status of an application.</p>', 'DescribeApplicationStateResult$ApplicationStatus' => '<p>Status of the application - Not Started, In-Progress, Complete.</p>', 'NotifyApplicationStateRequest$Status' => '<p>Status of the application - Not Started, In-Progress, Complete.</p>', ], ], 'AssociateCreatedArtifactRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateCreatedArtifactResult' => [ 'base' => NULL, 'refs' => [], ], 'AssociateDiscoveredResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateDiscoveredResourceResult' => [ 'base' => NULL, 'refs' => [], ], 'ConfigurationId' => [ 'base' => NULL, 'refs' => [ 'DisassociateDiscoveredResourceRequest$ConfigurationId' => '<p>ConfigurationId of the Application Discovery Service resource to be disassociated.</p>', 'DiscoveredResource$ConfigurationId' => '<p>The configurationId in Application Discovery Service that uniquely identifies the on-premise resource.</p>', ], ], 'CreateProgressUpdateStreamRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateProgressUpdateStreamResult' => [ 'base' => NULL, 'refs' => [], ], 'CreatedArtifact' => [ 'base' => '<p>An ARN of the AWS cloud resource target receiving the migration (e.g., AMI, EC2 instance, RDS instance, etc.).</p>', 'refs' => [ 'AssociateCreatedArtifactRequest$CreatedArtifact' => '<p>An ARN of the AWS resource related to the migration (e.g., AMI, EC2 instance, RDS instance, etc.) </p>', 'CreatedArtifactList$member' => NULL, ], ], 'CreatedArtifactDescription' => [ 'base' => NULL, 'refs' => [ 'CreatedArtifact$Description' => '<p>A description that can be free-form text to record additional detail about the artifact for clarity or for later reference.</p>', ], ], 'CreatedArtifactList' => [ 'base' => NULL, 'refs' => [ 'ListCreatedArtifactsResult$CreatedArtifactList' => '<p>List of created artifacts up to the maximum number of results specified in the request.</p>', ], ], 'CreatedArtifactName' => [ 'base' => NULL, 'refs' => [ 'CreatedArtifact$Name' => '<p>An ARN that uniquely identifies the result of a migration task.</p>', 'DisassociateCreatedArtifactRequest$CreatedArtifactName' => '<p>An ARN of the AWS resource related to the migration (e.g., AMI, EC2 instance, RDS instance, etc.)</p>', ], ], 'DeleteProgressUpdateStreamRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteProgressUpdateStreamResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeApplicationStateRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeApplicationStateResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMigrationTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMigrationTaskResult' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateCreatedArtifactRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateCreatedArtifactResult' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateDiscoveredResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateDiscoveredResourceResult' => [ 'base' => NULL, 'refs' => [], ], 'DiscoveredResource' => [ 'base' => '<p>Object representing the on-premises resource being migrated.</p>', 'refs' => [ 'AssociateDiscoveredResourceRequest$DiscoveredResource' => '<p>Object representing a Resource.</p>', 'DiscoveredResourceList$member' => NULL, ], ], 'DiscoveredResourceDescription' => [ 'base' => NULL, 'refs' => [ 'DiscoveredResource$Description' => '<p>A description that can be free-form text to record additional detail about the discovered resource for clarity or later reference.</p>', ], ], 'DiscoveredResourceList' => [ 'base' => NULL, 'refs' => [ 'ListDiscoveredResourcesResult$DiscoveredResourceList' => '<p>Returned list of discovered resources associated with the given MigrationTask.</p>', ], ], 'DryRun' => [ 'base' => NULL, 'refs' => [ 'AssociateCreatedArtifactRequest$DryRun' => '<p>Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has permission to make the call.</p>', 'AssociateDiscoveredResourceRequest$DryRun' => '<p>Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has permission to make the call.</p>', 'CreateProgressUpdateStreamRequest$DryRun' => '<p>Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has permission to make the call.</p>', 'DeleteProgressUpdateStreamRequest$DryRun' => '<p>Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has permission to make the call.</p>', 'DisassociateCreatedArtifactRequest$DryRun' => '<p>Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has permission to make the call.</p>', 'DisassociateDiscoveredResourceRequest$DryRun' => '<p>Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has permission to make the call.</p>', 'ImportMigrationTaskRequest$DryRun' => '<p>Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has permission to make the call.</p>', 'NotifyApplicationStateRequest$DryRun' => '<p>Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has permission to make the call.</p>', 'NotifyMigrationTaskStateRequest$DryRun' => '<p>Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has permission to make the call.</p>', 'PutResourceAttributesRequest$DryRun' => '<p>Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has permission to make the call.</p>', ], ], 'DryRunOperation' => [ 'base' => '<p>Exception raised to indicate a successfully authorized action when the <code>DryRun</code> flag is set to "true".</p>', 'refs' => [], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => NULL, 'DryRunOperation$Message' => NULL, 'HomeRegionNotSetException$Message' => NULL, 'InternalServerError$Message' => NULL, 'InvalidInputException$Message' => NULL, 'PolicyErrorException$Message' => NULL, 'ResourceNotFoundException$Message' => NULL, 'ServiceUnavailableException$Message' => NULL, 'ThrottlingException$Message' => '<p>A message that provides information about the exception.</p>', 'UnauthorizedOperation$Message' => NULL, ], ], 'HomeRegionNotSetException' => [ 'base' => '<p>The home region is not set. Set the home region to continue.</p>', 'refs' => [], ], 'ImportMigrationTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'ImportMigrationTaskResult' => [ 'base' => NULL, 'refs' => [], ], 'InternalServerError' => [ 'base' => '<p>Exception raised when an internal, configuration, or dependency error is encountered.</p>', 'refs' => [], ], 'InvalidInputException' => [ 'base' => '<p>Exception raised when the provided input violates a policy constraint or is entered in the wrong format or data type.</p>', 'refs' => [], ], 'LatestResourceAttributeList' => [ 'base' => NULL, 'refs' => [ 'MigrationTask$ResourceAttributeList' => '<p>Information about the resource that is being migrated. This data will be used to map the task to a resource in the Application Discovery Service repository.</p>', ], ], 'ListApplicationStatesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListApplicationStatesResult' => [ 'base' => NULL, 'refs' => [], ], 'ListCreatedArtifactsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCreatedArtifactsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListDiscoveredResourcesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDiscoveredResourcesResult' => [ 'base' => NULL, 'refs' => [], ], 'ListMigrationTasksRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListMigrationTasksResult' => [ 'base' => NULL, 'refs' => [], ], 'ListProgressUpdateStreamsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListProgressUpdateStreamsResult' => [ 'base' => NULL, 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListApplicationStatesRequest$MaxResults' => '<p>Maximum number of results to be returned per page.</p>', 'ListMigrationTasksRequest$MaxResults' => '<p>Value to specify how many results are returned per page.</p>', 'ListProgressUpdateStreamsRequest$MaxResults' => '<p>Filter to limit the maximum number of results to list per page.</p>', ], ], 'MaxResultsCreatedArtifacts' => [ 'base' => NULL, 'refs' => [ 'ListCreatedArtifactsRequest$MaxResults' => '<p>Maximum number of results to be returned per page.</p>', ], ], 'MaxResultsResources' => [ 'base' => NULL, 'refs' => [ 'ListDiscoveredResourcesRequest$MaxResults' => '<p>The maximum number of results returned per page.</p>', ], ], 'MigrationTask' => [ 'base' => '<p>Represents a migration task in a migration tool.</p>', 'refs' => [ 'DescribeMigrationTaskResult$MigrationTask' => '<p>Object encapsulating information about the migration task.</p>', ], ], 'MigrationTaskName' => [ 'base' => NULL, 'refs' => [ 'AssociateCreatedArtifactRequest$MigrationTaskName' => '<p>Unique identifier that references the migration task. <i>Do not store personal data in this field.</i> </p>', 'AssociateDiscoveredResourceRequest$MigrationTaskName' => '<p>The identifier given to the MigrationTask. <i>Do not store personal data in this field.</i> </p>', 'DescribeMigrationTaskRequest$MigrationTaskName' => '<p>The identifier given to the MigrationTask. <i>Do not store personal data in this field.</i> </p>', 'DisassociateCreatedArtifactRequest$MigrationTaskName' => '<p>Unique identifier that references the migration task to be disassociated with the artifact. <i>Do not store personal data in this field.</i> </p>', 'DisassociateDiscoveredResourceRequest$MigrationTaskName' => '<p>The identifier given to the MigrationTask. <i>Do not store personal data in this field.</i> </p>', 'ImportMigrationTaskRequest$MigrationTaskName' => '<p>Unique identifier that references the migration task. <i>Do not store personal data in this field.</i> </p>', 'ListCreatedArtifactsRequest$MigrationTaskName' => '<p>Unique identifier that references the migration task. <i>Do not store personal data in this field.</i> </p>', 'ListDiscoveredResourcesRequest$MigrationTaskName' => '<p>The name of the MigrationTask. <i>Do not store personal data in this field.</i> </p>', 'MigrationTask$MigrationTaskName' => '<p>Unique identifier that references the migration task. <i>Do not store personal data in this field.</i> </p>', 'MigrationTaskSummary$MigrationTaskName' => '<p>Unique identifier that references the migration task. <i>Do not store personal data in this field.</i> </p>', 'NotifyMigrationTaskStateRequest$MigrationTaskName' => '<p>Unique identifier that references the migration task. <i>Do not store personal data in this field.</i> </p>', 'PutResourceAttributesRequest$MigrationTaskName' => '<p>Unique identifier that references the migration task. <i>Do not store personal data in this field.</i> </p>', ], ], 'MigrationTaskSummary' => [ 'base' => '<p>MigrationTaskSummary includes <code>MigrationTaskName</code>, <code>ProgressPercent</code>, <code>ProgressUpdateStream</code>, <code>Status</code>, and <code>UpdateDateTime</code> for each task.</p>', 'refs' => [ 'MigrationTaskSummaryList$member' => NULL, ], ], 'MigrationTaskSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListMigrationTasksResult$MigrationTaskSummaryList' => '<p>Lists the migration task\'s summary which includes: <code>MigrationTaskName</code>, <code>ProgressPercent</code>, <code>ProgressUpdateStream</code>, <code>Status</code>, and the <code>UpdateDateTime</code> for each task.</p>', ], ], 'NextUpdateSeconds' => [ 'base' => NULL, 'refs' => [ 'NotifyMigrationTaskStateRequest$NextUpdateSeconds' => '<p>Number of seconds after the UpdateDateTime within which the Migration Hub can expect an update. If Migration Hub does not receive an update within the specified interval, then the migration task will be considered stale.</p>', ], ], 'NotifyApplicationStateRequest' => [ 'base' => NULL, 'refs' => [], ], 'NotifyApplicationStateResult' => [ 'base' => NULL, 'refs' => [], ], 'NotifyMigrationTaskStateRequest' => [ 'base' => NULL, 'refs' => [], ], 'NotifyMigrationTaskStateResult' => [ 'base' => NULL, 'refs' => [], ], 'PolicyErrorException' => [ 'base' => '<p>Exception raised when there are problems accessing Application Discovery Service (Application Discovery Service); most likely due to a misconfigured policy or the <code>migrationhub-discovery</code> role is missing or not configured correctly.</p>', 'refs' => [], ], 'ProgressPercent' => [ 'base' => NULL, 'refs' => [ 'MigrationTaskSummary$ProgressPercent' => '<p>Indication of the percentage completion of the task.</p>', 'Task$ProgressPercent' => '<p>Indication of the percentage completion of the task.</p>', ], ], 'ProgressUpdateStream' => [ 'base' => NULL, 'refs' => [ 'AssociateCreatedArtifactRequest$ProgressUpdateStream' => '<p>The name of the ProgressUpdateStream. </p>', 'AssociateDiscoveredResourceRequest$ProgressUpdateStream' => '<p>The name of the ProgressUpdateStream.</p>', 'CreateProgressUpdateStreamRequest$ProgressUpdateStreamName' => '<p>The name of the ProgressUpdateStream. <i>Do not store personal data in this field.</i> </p>', 'DeleteProgressUpdateStreamRequest$ProgressUpdateStreamName' => '<p>The name of the ProgressUpdateStream. <i>Do not store personal data in this field.</i> </p>', 'DescribeMigrationTaskRequest$ProgressUpdateStream' => '<p>The name of the ProgressUpdateStream. </p>', 'DisassociateCreatedArtifactRequest$ProgressUpdateStream' => '<p>The name of the ProgressUpdateStream. </p>', 'DisassociateDiscoveredResourceRequest$ProgressUpdateStream' => '<p>The name of the ProgressUpdateStream.</p>', 'ImportMigrationTaskRequest$ProgressUpdateStream' => '<p>The name of the ProgressUpdateStream. &gt;</p>', 'ListCreatedArtifactsRequest$ProgressUpdateStream' => '<p>The name of the ProgressUpdateStream. </p>', 'ListDiscoveredResourcesRequest$ProgressUpdateStream' => '<p>The name of the ProgressUpdateStream.</p>', 'MigrationTask$ProgressUpdateStream' => '<p>A name that identifies the vendor of the migration tool being used.</p>', 'MigrationTaskSummary$ProgressUpdateStream' => '<p>An AWS resource used for access control. It should uniquely identify the migration tool as it is used for all updates made by the tool.</p>', 'NotifyMigrationTaskStateRequest$ProgressUpdateStream' => '<p>The name of the ProgressUpdateStream. </p>', 'ProgressUpdateStreamSummary$ProgressUpdateStreamName' => '<p>The name of the ProgressUpdateStream. <i>Do not store personal data in this field.</i> </p>', 'PutResourceAttributesRequest$ProgressUpdateStream' => '<p>The name of the ProgressUpdateStream. </p>', ], ], 'ProgressUpdateStreamSummary' => [ 'base' => '<p>Summary of the AWS resource used for access control that is implicitly linked to your AWS account.</p>', 'refs' => [ 'ProgressUpdateStreamSummaryList$member' => NULL, ], ], 'ProgressUpdateStreamSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListProgressUpdateStreamsResult$ProgressUpdateStreamSummaryList' => '<p>List of progress update streams up to the max number of results passed in the input.</p>', ], ], 'PutResourceAttributesRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutResourceAttributesResult' => [ 'base' => NULL, 'refs' => [], ], 'ResourceAttribute' => [ 'base' => '<p>Attribute associated with a resource.</p> <p>Note the corresponding format required per type listed below:</p> <dl> <dt>IPV4</dt> <dd> <p> <code>x.x.x.x</code> </p> <p> <i>where x is an integer in the range [0,255]</i> </p> </dd> <dt>IPV6</dt> <dd> <p> <code>y : y : y : y : y : y : y : y</code> </p> <p> <i>where y is a hexadecimal between 0 and FFFF. [0, FFFF]</i> </p> </dd> <dt>MAC_ADDRESS</dt> <dd> <p> <code>^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$</code> </p> </dd> <dt>FQDN</dt> <dd> <p> <code>^[^&lt;&gt;{}\\\\\\\\/?,=\\\\p{Cntrl}]{1,256}$</code> </p> </dd> </dl>', 'refs' => [ 'LatestResourceAttributeList$member' => NULL, 'ResourceAttributeList$member' => NULL, ], ], 'ResourceAttributeList' => [ 'base' => NULL, 'refs' => [ 'PutResourceAttributesRequest$ResourceAttributeList' => '<p>Information about the resource that is being migrated. This data will be used to map the task to a resource in the Application Discovery Service repository.</p> <note> <p>Takes the object array of <code>ResourceAttribute</code> where the <code>Type</code> field is reserved for the following values: <code>IPV4_ADDRESS | IPV6_ADDRESS | MAC_ADDRESS | FQDN | VM_MANAGER_ID | VM_MANAGED_OBJECT_REFERENCE | VM_NAME | VM_PATH | BIOS_ID | MOTHERBOARD_SERIAL_NUMBER</code> where the identifying value can be a string up to 256 characters.</p> </note> <important> <ul> <li> <p>If any "VM" related value is set for a <code>ResourceAttribute</code> object, it is required that <code>VM_MANAGER_ID</code>, as a minimum, is always set. If <code>VM_MANAGER_ID</code> is not set, then all "VM" fields will be discarded and "VM" fields will not be used for matching the migration task to a server in Application Discovery Service repository. See the <a href="https://docs.aws.amazon.com/migrationhub/latest/ug/API_PutResourceAttributes.html#API_PutResourceAttributes_Examples">Example</a> section below for a use case of specifying "VM" related values.</p> </li> <li> <p> If a server you are trying to match has multiple IP or MAC addresses, you should provide as many as you know in separate type/value pairs passed to the <code>ResourceAttributeList</code> parameter to maximize the chances of matching.</p> </li> </ul> </important>', ], ], 'ResourceAttributeType' => [ 'base' => NULL, 'refs' => [ 'ResourceAttribute$Type' => '<p>Type of resource.</p>', ], ], 'ResourceAttributeValue' => [ 'base' => NULL, 'refs' => [ 'ResourceAttribute$Value' => '<p>Value of the resource type.</p>', ], ], 'ResourceName' => [ 'base' => NULL, 'refs' => [ 'ListMigrationTasksRequest$ResourceName' => '<p>Filter migration tasks by discovered resource name.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>Exception raised when the request references a resource (Application Discovery Service configuration, update stream, migration task, etc.) that does not exist in Application Discovery Service (Application Discovery Service) or in Migration Hub\'s repository.</p>', 'refs' => [], ], 'RetryAfterSeconds' => [ 'base' => NULL, 'refs' => [ 'ThrottlingException$RetryAfterSeconds' => '<p>The number of seconds the caller should wait before retrying.</p>', ], ], 'ServiceUnavailableException' => [ 'base' => '<p>Exception raised when there is an internal, configuration, or dependency error encountered.</p>', 'refs' => [], ], 'Status' => [ 'base' => NULL, 'refs' => [ 'MigrationTaskSummary$Status' => '<p>Status of the task.</p>', 'Task$Status' => '<p>Status of the task - Not Started, In-Progress, Complete.</p>', ], ], 'StatusDetail' => [ 'base' => NULL, 'refs' => [ 'MigrationTaskSummary$StatusDetail' => '<p>Detail information of what is being done within the overall status state.</p>', 'Task$StatusDetail' => '<p>Details of task status as notified by a migration tool. A tool might use this field to provide clarifying information about the status that is unique to that tool or that explains an error state.</p>', ], ], 'Task' => [ 'base' => '<p>Task object encapsulating task information.</p>', 'refs' => [ 'MigrationTask$Task' => '<p>Task object encapsulating task information.</p>', 'NotifyMigrationTaskStateRequest$Task' => '<p>Information about the task\'s progress and status.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The request was denied due to request throttling.</p>', 'refs' => [], ], 'Token' => [ 'base' => NULL, 'refs' => [ 'ListApplicationStatesRequest$NextToken' => '<p>If a <code>NextToken</code> was returned by a previous call, there are more results available. To retrieve the next page of results, make the call again using the returned token in <code>NextToken</code>.</p>', 'ListApplicationStatesResult$NextToken' => '<p>If a <code>NextToken</code> was returned by a previous call, there are more results available. To retrieve the next page of results, make the call again using the returned token in <code>NextToken</code>.</p>', 'ListCreatedArtifactsRequest$NextToken' => '<p>If a <code>NextToken</code> was returned by a previous call, there are more results available. To retrieve the next page of results, make the call again using the returned token in <code>NextToken</code>.</p>', 'ListCreatedArtifactsResult$NextToken' => '<p>If there are more created artifacts than the max result, return the next token to be passed to the next call as a bookmark of where to start from.</p>', 'ListDiscoveredResourcesRequest$NextToken' => '<p>If a <code>NextToken</code> was returned by a previous call, there are more results available. To retrieve the next page of results, make the call again using the returned token in <code>NextToken</code>.</p>', 'ListDiscoveredResourcesResult$NextToken' => '<p>If there are more discovered resources than the max result, return the next token to be passed to the next call as a bookmark of where to start from.</p>', 'ListMigrationTasksRequest$NextToken' => '<p>If a <code>NextToken</code> was returned by a previous call, there are more results available. To retrieve the next page of results, make the call again using the returned token in <code>NextToken</code>.</p>', 'ListMigrationTasksResult$NextToken' => '<p>If there are more migration tasks than the max result, return the next token to be passed to the next call as a bookmark of where to start from.</p>', 'ListProgressUpdateStreamsRequest$NextToken' => '<p>If a <code>NextToken</code> was returned by a previous call, there are more results available. To retrieve the next page of results, make the call again using the returned token in <code>NextToken</code>.</p>', 'ListProgressUpdateStreamsResult$NextToken' => '<p>If there are more streams created than the max result, return the next token to be passed to the next call as a bookmark of where to start from.</p>', ], ], 'UnauthorizedOperation' => [ 'base' => '<p>Exception raised to indicate a request was not authorized when the <code>DryRun</code> flag is set to "true".</p>', 'refs' => [], ], 'UpdateDateTime' => [ 'base' => NULL, 'refs' => [ 'ApplicationState$LastUpdatedTime' => '<p>The timestamp when the application status was last updated.</p>', 'DescribeApplicationStateResult$LastUpdatedTime' => '<p>The timestamp when the application status was last updated.</p>', 'MigrationTask$UpdateDateTime' => '<p>The timestamp when the task was gathered.</p>', 'MigrationTaskSummary$UpdateDateTime' => '<p>The timestamp when the task was gathered.</p>', 'NotifyApplicationStateRequest$UpdateDateTime' => '<p>The timestamp when the application state changed.</p>', 'NotifyMigrationTaskStateRequest$UpdateDateTime' => '<p>The timestamp when the task was gathered.</p>', ], ], ],];
