<?php
// This file was auto-generated from sdk-root/src/data/mgn/2020-02-26/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>The Application Migration Service service.</p>', 'operations' => [ 'ArchiveApplication' => '<p>Archive application.</p>', 'ArchiveWave' => '<p>Archive wave.</p>', 'AssociateApplications' => '<p>Associate applications to wave.</p>', 'AssociateSourceServers' => '<p>Associate source servers to application.</p>', 'ChangeServerLifeCycleState' => '<p>Allows the user to set the SourceServer.LifeCycle.state property for specific Source Server IDs to one of the following: READY_FOR_TEST or READY_FOR_CUTOVER. This command only works if the Source Server is already launchable (dataReplicationInfo.lagDuration is not null.)</p>', 'CreateApplication' => '<p>Create application.</p>', 'CreateConnector' => '<p>Create Connector.</p>', 'CreateLaunchConfigurationTemplate' => '<p>Creates a new Launch Configuration Template.</p>', 'CreateReplicationConfigurationTemplate' => '<p>Creates a new ReplicationConfigurationTemplate.</p>', 'CreateWave' => '<p>Create wave.</p>', 'DeleteApplication' => '<p>Delete application.</p>', 'DeleteConnector' => '<p>Delete Connector.</p>', 'DeleteJob' => '<p>Deletes a single Job by ID.</p>', 'DeleteLaunchConfigurationTemplate' => '<p>Deletes a single Launch Configuration Template by ID.</p>', 'DeleteReplicationConfigurationTemplate' => '<p>Deletes a single Replication Configuration Template by ID</p>', 'DeleteSourceServer' => '<p>Deletes a single source server by ID.</p>', 'DeleteVcenterClient' => '<p>Deletes a given vCenter client by ID.</p>', 'DeleteWave' => '<p>Delete wave.</p>', 'DescribeJobLogItems' => '<p>Retrieves detailed job log items with paging.</p>', 'DescribeJobs' => '<p>Returns a list of Jobs. Use the JobsID and fromDate and toData filters to limit which jobs are returned. The response is sorted by creationDataTime - latest date first. Jobs are normally created by the StartTest, StartCutover, and TerminateTargetInstances APIs. Jobs are also created by DiagnosticLaunch and TerminateDiagnosticInstances, which are APIs available only to *Support* and only used in response to relevant support tickets.</p>', 'DescribeLaunchConfigurationTemplates' => '<p>Lists all Launch Configuration Templates, filtered by Launch Configuration Template IDs</p>', 'DescribeReplicationConfigurationTemplates' => '<p>Lists all ReplicationConfigurationTemplates, filtered by Source Server IDs.</p>', 'DescribeSourceServers' => '<p>Retrieves all SourceServers or multiple SourceServers by ID.</p>', 'DescribeVcenterClients' => '<p>Returns a list of the installed vCenter clients.</p>', 'DisassociateApplications' => '<p>Disassociate applications from wave.</p>', 'DisassociateSourceServers' => '<p>Disassociate source servers from application.</p>', 'DisconnectFromService' => '<p>Disconnects specific Source Servers from Application Migration Service. Data replication is stopped immediately. All AWS resources created by Application Migration Service for enabling the replication of these source servers will be terminated / deleted within 90 minutes. Launched Test or Cutover instances will NOT be terminated. If the agent on the source server has not been prevented from communicating with the Application Migration Service service, then it will receive a command to uninstall itself (within approximately 10 minutes). The following properties of the SourceServer will be changed immediately: dataReplicationInfo.dataReplicationState will be set to DISCONNECTED; The totalStorageBytes property for each of dataReplicationInfo.replicatedDisks will be set to zero; dataReplicationInfo.lagDuration and dataReplicationInfo.lagDuration will be nullified.</p>', 'FinalizeCutover' => '<p>Finalizes the cutover immediately for specific Source Servers. All AWS resources created by Application Migration Service for enabling the replication of these source servers will be terminated / deleted within 90 minutes. Launched Test or Cutover instances will NOT be terminated. The AWS Replication Agent will receive a command to uninstall itself (within 10 minutes). The following properties of the SourceServer will be changed immediately: dataReplicationInfo.dataReplicationState will be changed to DISCONNECTED; The SourceServer.lifeCycle.state will be changed to CUTOVER; The totalStorageBytes property fo each of dataReplicationInfo.replicatedDisks will be set to zero; dataReplicationInfo.lagDuration and dataReplicationInfo.lagDuration will be nullified.</p>', 'GetLaunchConfiguration' => '<p>Lists all LaunchConfigurations available, filtered by Source Server IDs.</p>', 'GetReplicationConfiguration' => '<p>Lists all ReplicationConfigurations, filtered by Source Server ID.</p>', 'InitializeService' => '<p>Initialize Application Migration Service.</p>', 'ListApplications' => '<p>Retrieves all applications or multiple applications by ID.</p>', 'ListConnectors' => '<p>List Connectors.</p>', 'ListExportErrors' => '<p>List export errors.</p>', 'ListExports' => '<p>List exports.</p>', 'ListImportErrors' => '<p>List import errors.</p>', 'ListImports' => '<p>List imports.</p>', 'ListManagedAccounts' => '<p>List Managed Accounts.</p>', 'ListSourceServerActions' => '<p>List source server post migration custom actions.</p>', 'ListTagsForResource' => '<p>List all tags for your Application Migration Service resources.</p>', 'ListTemplateActions' => '<p>List template post migration custom actions.</p>', 'ListWaves' => '<p>Retrieves all waves or multiple waves by ID.</p>', 'MarkAsArchived' => '<p>Archives specific Source Servers by setting the SourceServer.isArchived property to true for specified SourceServers by ID. This command only works for SourceServers with a lifecycle. state which equals DISCONNECTED or CUTOVER.</p>', 'PauseReplication' => '<p>Pause Replication.</p>', 'PutSourceServerAction' => '<p>Put source server post migration custom action.</p>', 'PutTemplateAction' => '<p>Put template post migration custom action.</p>', 'RemoveSourceServerAction' => '<p>Remove source server post migration custom action.</p>', 'RemoveTemplateAction' => '<p>Remove template post migration custom action.</p>', 'ResumeReplication' => '<p>Resume Replication.</p>', 'RetryDataReplication' => '<p>Causes the data replication initiation sequence to begin immediately upon next Handshake for specified SourceServer IDs, regardless of when the previous initiation started. This command will not work if the SourceServer is not stalled or is in a DISCONNECTED or STOPPED state.</p>', 'StartCutover' => '<p>Launches a Cutover Instance for specific Source Servers. This command starts a LAUNCH job whose initiatedBy property is StartCutover and changes the SourceServer.lifeCycle.state property to CUTTING_OVER.</p>', 'StartExport' => '<p>Start export.</p>', 'StartImport' => '<p>Start import.</p>', 'StartReplication' => '<p>Starts replication for SNAPSHOT_SHIPPING agents.</p>', 'StartTest' => '<p>Launches a Test Instance for specific Source Servers. This command starts a LAUNCH job whose initiatedBy property is StartTest and changes the SourceServer.lifeCycle.state property to TESTING.</p>', 'StopReplication' => '<p>Stop Replication.</p>', 'TagResource' => '<p>Adds or overwrites only the specified tags for the specified Application Migration Service resource or resources. When you specify an existing tag key, the value is overwritten with the new value. Each resource can have a maximum of 50 tags. Each tag consists of a key and optional value.</p>', 'TerminateTargetInstances' => '<p>Starts a job that terminates specific launched EC2 Test and Cutover instances. This command will not work for any Source Server with a lifecycle.state of TESTING, CUTTING_OVER, or CUTOVER.</p>', 'UnarchiveApplication' => '<p>Unarchive application.</p>', 'UnarchiveWave' => '<p>Unarchive wave.</p>', 'UntagResource' => '<p>Deletes the specified set of tags from the specified set of Application Migration Service resources.</p>', 'UpdateApplication' => '<p>Update application.</p>', 'UpdateConnector' => '<p>Update Connector.</p>', 'UpdateLaunchConfiguration' => '<p>Updates multiple LaunchConfigurations by Source Server ID.</p> <note> <p>bootMode valid values are <code>LEGACY_BIOS | UEFI</code> </p> </note>', 'UpdateLaunchConfigurationTemplate' => '<p>Updates an existing Launch Configuration Template by ID.</p>', 'UpdateReplicationConfiguration' => '<p>Allows you to update multiple ReplicationConfigurations by Source Server ID.</p>', 'UpdateReplicationConfigurationTemplate' => '<p>Updates multiple ReplicationConfigurationTemplates by ID.</p>', 'UpdateSourceServer' => '<p>Update Source Server.</p>', 'UpdateSourceServerReplicationType' => '<p>Allows you to change between the AGENT_BASED replication type and the SNAPSHOT_SHIPPING replication type.</p>', 'UpdateWave' => '<p>Update wave.</p>', ], 'shapes' => [ 'ARN' => [ 'base' => NULL, 'refs' => [ 'Application$arn' => '<p>Application ARN.</p>', 'Connector$arn' => '<p>Connector arn.</p>', 'CreateReplicationConfigurationTemplateRequest$ebsEncryptionKeyArn' => '<p>Request to configure an EBS encryption key during Replication Settings template creation.</p>', 'Job$arn' => '<p>the ARN of the specific Job.</p>', 'LaunchConfigurationTemplate$arn' => '<p>ARN of the Launch Configuration Template.</p>', 'ListTagsForResourceRequest$resourceArn' => '<p>List tags for resource request by ARN.</p>', 'ReplicationConfiguration$ebsEncryptionKeyArn' => '<p>Replication Configuration EBS encryption key ARN.</p>', 'ReplicationConfigurationTemplate$arn' => '<p>Replication Configuration template ARN.</p>', 'ReplicationConfigurationTemplate$ebsEncryptionKeyArn' => '<p>Replication Configuration template EBS encryption key ARN.</p>', 'SourceServer$arn' => '<p>Source server ARN.</p>', 'TagResourceRequest$resourceArn' => '<p>Tag resource by ARN.</p>', 'UntagResourceRequest$resourceArn' => '<p>Untag resource by ARN.</p>', 'UpdateReplicationConfigurationRequest$ebsEncryptionKeyArn' => '<p>Update replication configuration EBS encryption key ARN request.</p>', 'UpdateReplicationConfigurationTemplateRequest$arn' => '<p>Update replication configuration template ARN request.</p>', 'UpdateReplicationConfigurationTemplateRequest$ebsEncryptionKeyArn' => '<p>Update replication configuration template EBS encryption key ARN request.</p>', 'VcenterClient$arn' => '<p>Arn of vCenter client.</p>', 'Wave$arn' => '<p>Wave ARN.</p>', ], ], 'AccessDeniedException' => [ 'base' => '<p>Operating denied due to a file permission or access check error.</p>', 'refs' => [], ], 'AccountID' => [ 'base' => NULL, 'refs' => [ 'ArchiveApplicationRequest$accountID' => '<p>Account ID.</p>', 'ArchiveWaveRequest$accountID' => '<p>Account ID.</p>', 'AssociateApplicationsRequest$accountID' => '<p>Account ID.</p>', 'AssociateSourceServersRequest$accountID' => '<p>Account ID.</p>', 'ChangeServerLifeCycleStateRequest$accountID' => '<p>The request to change the source server migration account ID.</p>', 'CreateApplicationRequest$accountID' => '<p>Account ID.</p>', 'CreateWaveRequest$accountID' => '<p>Account ID.</p>', 'DeleteApplicationRequest$accountID' => '<p>Account ID.</p>', 'DeleteJobRequest$accountID' => '<p>Request to delete Job from service by Account ID.</p>', 'DeleteSourceServerRequest$accountID' => '<p>Request to delete Source Server from service by Account ID.</p>', 'DeleteWaveRequest$accountID' => '<p>Account ID.</p>', 'DescribeJobLogItemsRequest$accountID' => '<p>Request to describe Job log Account ID.</p>', 'DescribeJobsRequest$accountID' => '<p>Request to describe job log items by Account ID.</p>', 'DescribeSourceServersRequest$accountID' => '<p>Request to filter Source Servers list by Accoun ID.</p>', 'DisassociateApplicationsRequest$accountID' => '<p>Account ID.</p>', 'DisassociateSourceServersRequest$accountID' => '<p>Account ID.</p>', 'DisconnectFromServiceRequest$accountID' => '<p>Request to disconnect Source Server from service by Account ID.</p>', 'ExportTask$s3BucketOwner' => '<p>Export task s3 bucket owner.</p>', 'FinalizeCutoverRequest$accountID' => '<p>Request to finalize Cutover by Source Account ID.</p>', 'GetLaunchConfigurationRequest$accountID' => '<p>Request to get Launch Configuration information by Account ID.</p>', 'GetReplicationConfigurationRequest$accountID' => '<p>Request to get Replication Configuration by Account ID.</p>', 'ImportErrorData$accountID' => '<p>Import error data source account ID.</p>', 'ListApplicationsRequest$accountID' => '<p>Applications list Account ID.</p>', 'ListSourceServerActionsRequest$accountID' => '<p>Account ID to return when listing source server post migration custom actions.</p>', 'ListWavesRequest$accountID' => '<p>Request account ID.</p>', 'ManagedAccount$accountId' => '<p>Managed account, account ID.</p>', 'MarkAsArchivedRequest$accountID' => '<p>Mark as archived by Account ID.</p>', 'PauseReplicationRequest$accountID' => '<p>Pause Replication Request account ID.</p>', 'PutSourceServerActionRequest$accountID' => '<p>Source server post migration custom account ID.</p>', 'RemoveSourceServerActionRequest$accountID' => '<p>Source server post migration account ID.</p>', 'ResumeReplicationRequest$accountID' => '<p>Resume Replication Request account ID.</p>', 'RetryDataReplicationRequest$accountID' => '<p>Retry data replication for Account ID.</p>', 'S3BucketSource$s3BucketOwner' => '<p>S3 bucket source s3 bucket owner.</p>', 'StartCutoverRequest$accountID' => '<p>Start Cutover by Account IDs</p>', 'StartExportRequest$s3BucketOwner' => '<p>Start export request s3 bucket owner.</p>', 'StartReplicationRequest$accountID' => '<p>Account ID on which to start replication.</p>', 'StartTestRequest$accountID' => '<p>Start Test for Account ID.</p>', 'StopReplicationRequest$accountID' => '<p>Stop Replication Request account ID.</p>', 'TerminateTargetInstancesRequest$accountID' => '<p>Terminate Target instance by Account ID</p>', 'UnarchiveApplicationRequest$accountID' => '<p>Account ID.</p>', 'UnarchiveWaveRequest$accountID' => '<p>Account ID.</p>', 'UpdateApplicationRequest$accountID' => '<p>Account ID.</p>', 'UpdateLaunchConfigurationRequest$accountID' => '<p>Update Launch configuration Account ID.</p>', 'UpdateReplicationConfigurationRequest$accountID' => '<p>Update replication configuration Account ID request.</p>', 'UpdateSourceServerReplicationTypeRequest$accountID' => '<p>Account ID on which to update replication type.</p>', 'UpdateSourceServerRequest$accountID' => '<p>Update Source Server request account ID.</p>', 'UpdateWaveRequest$accountID' => '<p>Account ID.</p>', ], ], 'ActionCategory' => [ 'base' => NULL, 'refs' => [ 'PutSourceServerActionRequest$category' => '<p>Source server post migration custom action category.</p>', 'PutTemplateActionRequest$category' => '<p>Template post migration custom action category.</p>', 'SourceServerActionDocument$category' => '<p>Source server post migration custom action category.</p>', 'TemplateActionDocument$category' => '<p>Template post migration custom action category.</p>', ], ], 'ActionDescription' => [ 'base' => NULL, 'refs' => [ 'PutSourceServerActionRequest$description' => '<p>Source server post migration custom action description.</p>', 'PutTemplateActionRequest$description' => '<p>Template post migration custom action description.</p>', 'SourceServerActionDocument$description' => '<p>Source server post migration custom action description.</p>', 'TemplateActionDocument$description' => '<p>Template post migration custom action description.</p>', ], ], 'ActionID' => [ 'base' => NULL, 'refs' => [ 'ActionIDs$member' => NULL, 'PutSourceServerActionRequest$actionID' => '<p>Source server post migration custom action ID.</p>', 'PutTemplateActionRequest$actionID' => '<p>Template post migration custom action ID.</p>', 'RemoveSourceServerActionRequest$actionID' => '<p>Source server post migration custom action ID to remove.</p>', 'RemoveTemplateActionRequest$actionID' => '<p>Template post migration custom action ID to remove.</p>', 'SourceServerActionDocument$actionID' => '<p>Source server post migration custom action ID.</p>', 'TemplateActionDocument$actionID' => '<p>Template post migration custom action ID.</p>', ], ], 'ActionIDs' => [ 'base' => NULL, 'refs' => [ 'SourceServerActionsRequestFilters$actionIDs' => '<p>Action IDs to filter source server post migration custom actions by.</p>', 'TemplateActionsRequestFilters$actionIDs' => '<p>Action IDs to filter template post migration custom actions by.</p>', ], ], 'ActionName' => [ 'base' => NULL, 'refs' => [ 'PutSourceServerActionRequest$actionName' => '<p>Source server post migration custom action name.</p>', 'SourceServerActionDocument$actionName' => '<p>Source server post migration custom action name.</p>', ], ], 'Application' => [ 'base' => NULL, 'refs' => [ 'ApplicationsList$member' => NULL, ], ], 'ApplicationAggregatedStatus' => [ 'base' => '<p>Application aggregated status.</p>', 'refs' => [ 'Application$applicationAggregatedStatus' => '<p>Application aggregated status.</p>', ], ], 'ApplicationDescription' => [ 'base' => NULL, 'refs' => [ 'Application$description' => '<p>Application description.</p>', 'CreateApplicationRequest$description' => '<p>Application description.</p>', 'UpdateApplicationRequest$description' => '<p>Application description.</p>', ], ], 'ApplicationHealthStatus' => [ 'base' => NULL, 'refs' => [ 'ApplicationAggregatedStatus$healthStatus' => '<p>Application aggregated status health status.</p>', ], ], 'ApplicationID' => [ 'base' => NULL, 'refs' => [ 'Application$applicationID' => '<p>Application ID.</p>', 'ApplicationIDs$member' => NULL, 'ApplicationIDsFilter$member' => NULL, 'ArchiveApplicationRequest$applicationID' => '<p>Application ID.</p>', 'AssociateSourceServersRequest$applicationID' => '<p>Application ID.</p>', 'DeleteApplicationRequest$applicationID' => '<p>Application ID.</p>', 'DescribeSourceServersRequestApplicationIDs$member' => NULL, 'DisassociateSourceServersRequest$applicationID' => '<p>Application ID.</p>', 'ImportErrorData$applicationID' => '<p>Import error data application ID.</p>', 'SourceServer$applicationID' => '<p>Source server application ID.</p>', 'UnarchiveApplicationRequest$applicationID' => '<p>Application ID.</p>', 'UpdateApplicationRequest$applicationID' => '<p>Application ID.</p>', ], ], 'ApplicationIDs' => [ 'base' => NULL, 'refs' => [ 'AssociateApplicationsRequest$applicationIDs' => '<p>Application IDs list.</p>', 'DisassociateApplicationsRequest$applicationIDs' => '<p>Application IDs list.</p>', ], ], 'ApplicationIDsFilter' => [ 'base' => NULL, 'refs' => [ 'ListApplicationsRequestFilters$applicationIDs' => '<p>Filter applications list by application ID.</p>', ], ], 'ApplicationName' => [ 'base' => NULL, 'refs' => [ 'Application$name' => '<p>Application name.</p>', 'CreateApplicationRequest$name' => '<p>Application name.</p>', 'UpdateApplicationRequest$name' => '<p>Application name.</p>', ], ], 'ApplicationProgressStatus' => [ 'base' => NULL, 'refs' => [ 'ApplicationAggregatedStatus$progressStatus' => '<p>Application aggregated status progress status.</p>', ], ], 'ApplicationsList' => [ 'base' => NULL, 'refs' => [ 'ListApplicationsResponse$items' => '<p>Applications list.</p>', ], ], 'ArchiveApplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'ArchiveWaveRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateApplicationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateApplicationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociateSourceServersRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateSourceServersRequestSourceServerIDs' => [ 'base' => NULL, 'refs' => [ 'AssociateSourceServersRequest$sourceServerIDs' => '<p>Source server IDs list.</p>', ], ], 'AssociateSourceServersResponse' => [ 'base' => NULL, 'refs' => [], ], 'BandwidthThrottling' => [ 'base' => NULL, 'refs' => [ 'CreateReplicationConfigurationTemplateRequest$bandwidthThrottling' => '<p>Request to configure bandwidth throttling during Replication Settings template creation.</p>', 'ReplicationConfiguration$bandwidthThrottling' => '<p>Replication Configuration set bandwidth throttling.</p>', 'ReplicationConfigurationTemplate$bandwidthThrottling' => '<p>Replication Configuration template bandwidth throttling.</p>', 'UpdateReplicationConfigurationRequest$bandwidthThrottling' => '<p>Update replication configuration bandwidth throttling request.</p>', 'UpdateReplicationConfigurationTemplateRequest$bandwidthThrottling' => '<p>Update replication configuration template bandwidth throttling request.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'Application$isArchived' => '<p>Application archival status.</p>', 'ConnectorSsmCommandConfig$cloudWatchOutputEnabled' => '<p>Connector SSM command config CloudWatch output enabled.</p>', 'ConnectorSsmCommandConfig$s3OutputEnabled' => '<p>Connector SSM command config S3 output enabled.</p>', 'CreateLaunchConfigurationTemplateRequest$associatePublicIpAddress' => '<p>Associate public Ip address.</p>', 'CreateLaunchConfigurationTemplateRequest$copyPrivateIp' => '<p>Copy private Ip.</p>', 'CreateLaunchConfigurationTemplateRequest$copyTags' => '<p>Copy tags.</p>', 'CreateLaunchConfigurationTemplateRequest$enableMapAutoTagging' => '<p>Enable map auto tagging.</p>', 'CreateReplicationConfigurationTemplateRequest$associateDefaultSecurityGroup' => '<p>Request to associate the default Application Migration Service Security group with the Replication Settings template.</p>', 'CreateReplicationConfigurationTemplateRequest$createPublicIP' => '<p>Request to create Public IP during Replication Settings template creation.</p>', 'CreateReplicationConfigurationTemplateRequest$useDedicatedReplicationServer' => '<p>Request to use Dedicated Replication Servers during Replication Settings template creation.</p>', 'CreateReplicationConfigurationTemplateRequest$useFipsEndpoint' => '<p>Request to use Fips Endpoint during Replication Settings template creation.</p>', 'DescribeSourceServersRequestFilters$isArchived' => '<p>Request to filter Source Servers list by archived.</p>', 'LaunchConfiguration$copyPrivateIp' => '<p>Copy Private IP during Launch Configuration.</p>', 'LaunchConfiguration$copyTags' => '<p>Copy Tags during Launch Configuration.</p>', 'LaunchConfiguration$enableMapAutoTagging' => '<p>Enable map auto tagging.</p>', 'LaunchConfigurationTemplate$associatePublicIpAddress' => '<p>Associate public Ip address.</p>', 'LaunchConfigurationTemplate$copyPrivateIp' => '<p>Copy private Ip.</p>', 'LaunchConfigurationTemplate$copyTags' => '<p>Copy tags.</p>', 'LaunchConfigurationTemplate$enableMapAutoTagging' => '<p>Enable map auto tagging.</p>', 'Licensing$osByol' => '<p>Configure BYOL OS licensing.</p>', 'ListApplicationsRequestFilters$isArchived' => '<p>Filter applications list by archival status.</p>', 'ListWavesRequestFilters$isArchived' => '<p>Filter waves list by archival status.</p>', 'NetworkInterface$isPrimary' => '<p>Network interface primary IP.</p>', 'PutSourceServerActionRequest$active' => '<p>Source server post migration custom action active status.</p>', 'PutSourceServerActionRequest$mustSucceedForCutover' => '<p>Source server post migration custom action must succeed for cutover.</p>', 'PutTemplateActionRequest$active' => '<p>Template post migration custom action active status.</p>', 'PutTemplateActionRequest$mustSucceedForCutover' => '<p>Template post migration custom action must succeed for cutover.</p>', 'ReplicationConfiguration$associateDefaultSecurityGroup' => '<p>Replication Configuration associate default Application Migration Service Security Group.</p>', 'ReplicationConfiguration$createPublicIP' => '<p>Replication Configuration create Public IP.</p>', 'ReplicationConfiguration$useDedicatedReplicationServer' => '<p>Replication Configuration use Dedicated Replication Server.</p>', 'ReplicationConfiguration$useFipsEndpoint' => '<p>Replication Configuration use Fips Endpoint.</p>', 'ReplicationConfigurationReplicatedDisk$isBootDisk' => '<p>Replication Configuration replicated disk boot disk.</p>', 'ReplicationConfigurationTemplate$associateDefaultSecurityGroup' => '<p>Replication Configuration template associate default Application Migration Service Security group.</p>', 'ReplicationConfigurationTemplate$createPublicIP' => '<p>Replication Configuration template create Public IP.</p>', 'ReplicationConfigurationTemplate$useDedicatedReplicationServer' => '<p>Replication Configuration template use Dedicated Replication Server.</p>', 'ReplicationConfigurationTemplate$useFipsEndpoint' => '<p>Replication Configuration template use Fips Endpoint.</p>', 'SourceServer$isArchived' => '<p>Source server archived status.</p>', 'SourceServerActionDocument$active' => '<p>Source server post migration custom action active status.</p>', 'SourceServerActionDocument$mustSucceedForCutover' => '<p>Source server post migration custom action must succeed for cutover.</p>', 'SsmDocument$mustSucceedForCutover' => '<p>If true, Cutover will not be enabled if the document has failed.</p>', 'TemplateActionDocument$active' => '<p>Template post migration custom action active status.</p>', 'TemplateActionDocument$mustSucceedForCutover' => '<p>Template post migration custom action must succeed for cutover.</p>', 'UpdateLaunchConfigurationRequest$copyPrivateIp' => '<p>Update Launch configuration copy Private IP request.</p>', 'UpdateLaunchConfigurationRequest$copyTags' => '<p>Update Launch configuration copy Tags request.</p>', 'UpdateLaunchConfigurationRequest$enableMapAutoTagging' => '<p>Enable map auto tagging.</p>', 'UpdateLaunchConfigurationTemplateRequest$associatePublicIpAddress' => '<p>Associate public Ip address.</p>', 'UpdateLaunchConfigurationTemplateRequest$copyPrivateIp' => '<p>Copy private Ip.</p>', 'UpdateLaunchConfigurationTemplateRequest$copyTags' => '<p>Copy tags.</p>', 'UpdateLaunchConfigurationTemplateRequest$enableMapAutoTagging' => '<p>Enable map auto tagging.</p>', 'UpdateReplicationConfigurationRequest$associateDefaultSecurityGroup' => '<p>Update replication configuration associate default Application Migration Service Security group request.</p>', 'UpdateReplicationConfigurationRequest$createPublicIP' => '<p>Update replication configuration create Public IP request.</p>', 'UpdateReplicationConfigurationRequest$useDedicatedReplicationServer' => '<p>Update replication configuration use dedicated Replication Server request.</p>', 'UpdateReplicationConfigurationRequest$useFipsEndpoint' => '<p>Update replication configuration use Fips Endpoint.</p>', 'UpdateReplicationConfigurationTemplateRequest$associateDefaultSecurityGroup' => '<p>Update replication configuration template associate default Application Migration Service Security group request.</p>', 'UpdateReplicationConfigurationTemplateRequest$createPublicIP' => '<p>Update replication configuration template create Public IP request.</p>', 'UpdateReplicationConfigurationTemplateRequest$useDedicatedReplicationServer' => '<p>Update replication configuration template use dedicated Replication Server request.</p>', 'UpdateReplicationConfigurationTemplateRequest$useFipsEndpoint' => '<p>Update replication configuration template use Fips Endpoint request.</p>', 'Wave$isArchived' => '<p>Wave archival status.</p>', ], ], 'BootMode' => [ 'base' => NULL, 'refs' => [ 'CreateLaunchConfigurationTemplateRequest$bootMode' => '<p>Launch configuration template boot mode.</p>', 'LaunchConfiguration$bootMode' => '<p>Launch configuration boot mode.</p>', 'LaunchConfigurationTemplate$bootMode' => '<p>Launch configuration template boot mode.</p>', 'UpdateLaunchConfigurationRequest$bootMode' => '<p>Update Launch configuration boot mode request.</p>', 'UpdateLaunchConfigurationTemplateRequest$bootMode' => '<p>Launch configuration template boot mode.</p>', ], ], 'BoundedString' => [ 'base' => NULL, 'refs' => [ 'CPU$modelName' => '<p>The source server\'s CPU model name.</p>', 'DataReplicationInfoReplicatedDisk$deviceName' => '<p>Request to query device name.</p>', 'Disk$deviceName' => '<p>The disk or device name.</p>', 'ErrorDetails$code' => '<p>Error details code.</p>', 'IPsList$member' => NULL, 'IdentificationHints$fqdn' => '<p>FQDN address identification hint.</p>', 'IdentificationHints$hostname' => '<p>Hostname identification hint.</p>', 'IdentificationHints$vmPath' => '<p>vCenter VM path identification hint.</p>', 'IdentificationHints$vmWareUuid' => '<p>vmWare UUID identification hint.</p>', 'ImportErrorData$ec2LaunchTemplateID' => '<p>Import error data ec2 LaunchTemplate ID.</p>', 'JobPostLaunchActionsLaunchStatus$executionID' => '<p>AWS Systems Manager Document\'s execution ID of the of the Job Post Launch Actions.</p>', 'JobPostLaunchActionsLaunchStatus$failureReason' => '<p>AWS Systems Manager Document\'s failure reason.</p>', 'LaunchConfiguration$ec2LaunchTemplateID' => '<p>Launch configuration EC2 Launch template ID.</p>', 'NetworkInterface$macAddress' => '<p>Network interface Mac address.</p>', 'OS$fullString' => '<p>OS full string.</p>', 'PostLaunchActions$s3OutputKeyPrefix' => '<p>AWS Systems Manager Command\'s logs S3 output key prefix.</p>', 'PutSourceServerActionRequest$documentIdentifier' => '<p>Source server post migration custom action document identifier.</p>', 'PutTemplateActionRequest$actionName' => '<p>Template post migration custom action name.</p>', 'PutTemplateActionRequest$documentIdentifier' => '<p>Template post migration custom action document identifier.</p>', 'ReplicationConfigurationReplicatedDisk$deviceName' => '<p>Replication Configuration replicated disk device name.</p>', 'SourceServer$fqdnForActionFramework' => '<p>Source server fqdn for action framework.</p>', 'SourceServer$userProvidedID' => '<p>Source server user provided ID.</p>', 'SourceServerActionDocument$documentIdentifier' => '<p>Source server post migration custom action document identifier.</p>', 'SsmDocument$actionName' => '<p>User-friendly name for the AWS Systems Manager Document.</p>', 'TemplateActionDocument$actionName' => '<p>Template post migration custom action name.</p>', 'TemplateActionDocument$documentIdentifier' => '<p>Template post migration custom action document identifier.</p>', 'VcenterClient$datacenterName' => '<p>Datacenter name of vCenter client.</p>', 'VcenterClient$hostname' => '<p>Hostname of vCenter client .</p>', 'VcenterClient$vcenterUUID' => '<p>Vcenter UUID of vCenter client.</p>', ], ], 'CPU' => [ 'base' => '<p>Source server CPU information.</p>', 'refs' => [ 'Cpus$member' => NULL, ], ], 'ChangeServerLifeCycleStateRequest' => [ 'base' => NULL, 'refs' => [], ], 'ChangeServerLifeCycleStateSourceServerLifecycle' => [ 'base' => '<p>The request to change the source server migration lifecycle state.</p>', 'refs' => [ 'ChangeServerLifeCycleStateRequest$lifeCycle' => '<p>The request to change the source server migration lifecycle state.</p>', ], ], 'ChangeServerLifeCycleStateSourceServerLifecycleState' => [ 'base' => NULL, 'refs' => [ 'ChangeServerLifeCycleStateSourceServerLifecycle$state' => '<p>The request to change the source server migration lifecycle state.</p>', ], ], 'ClientIdempotencyToken' => [ 'base' => NULL, 'refs' => [ 'StartImportRequest$clientToken' => '<p>Start import request client token.</p>', ], ], 'CloudWatchLogGroupName' => [ 'base' => NULL, 'refs' => [ 'ConnectorSsmCommandConfig$cloudWatchLogGroupName' => '<p>Connector SSM command config CloudWatch log group name.</p>', 'PostLaunchActions$cloudWatchLogGroupName' => '<p>AWS Systems Manager Command\'s CloudWatch log group name.</p>', ], ], 'ConflictException' => [ 'base' => '<p>The request could not be completed due to a conflict with the current state of the target resource.</p>', 'refs' => [], ], 'ConflictExceptionErrors' => [ 'base' => NULL, 'refs' => [ 'ConflictException$errors' => '<p>Conflict Exception specific errors.</p>', ], ], 'Connector' => [ 'base' => NULL, 'refs' => [ 'ConnectorsList$member' => NULL, ], ], 'ConnectorArn' => [ 'base' => NULL, 'refs' => [ 'SourceServerConnectorAction$connectorArn' => '<p>Source Server connector action connector arn.</p>', ], ], 'ConnectorID' => [ 'base' => NULL, 'refs' => [ 'Connector$connectorID' => '<p>Connector ID.</p>', 'ConnectorIDsFilter$member' => NULL, 'DeleteConnectorRequest$connectorID' => '<p>Delete Connector request connector ID.</p>', 'UpdateConnectorRequest$connectorID' => '<p>Update Connector request connector ID.</p>', ], ], 'ConnectorIDsFilter' => [ 'base' => NULL, 'refs' => [ 'ListConnectorsRequestFilters$connectorIDs' => '<p>List Connectors Request Filters connector IDs.</p>', ], ], 'ConnectorName' => [ 'base' => NULL, 'refs' => [ 'Connector$name' => '<p>Connector name.</p>', 'CreateConnectorRequest$name' => '<p>Create Connector request name.</p>', 'UpdateConnectorRequest$name' => '<p>Update Connector request name.</p>', ], ], 'ConnectorSsmCommandConfig' => [ 'base' => '<p>Connector SSM command config.</p>', 'refs' => [ 'Connector$ssmCommandConfig' => '<p>Connector SSM command config.</p>', 'CreateConnectorRequest$ssmCommandConfig' => '<p>Create Connector request SSM command config.</p>', 'UpdateConnectorRequest$ssmCommandConfig' => '<p>Update Connector request SSM command config.</p>', ], ], 'ConnectorsList' => [ 'base' => NULL, 'refs' => [ 'ListConnectorsResponse$items' => '<p>List connectors response items.</p>', ], ], 'Cpus' => [ 'base' => NULL, 'refs' => [ 'SourceProperties$cpus' => '<p>Source Server CPUs.</p>', ], ], 'CreateApplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateConnectorRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateLaunchConfigurationTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateReplicationConfigurationTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateWaveRequest' => [ 'base' => NULL, 'refs' => [], ], 'DataReplicationError' => [ 'base' => '<p>Error in data replication.</p>', 'refs' => [ 'DataReplicationInfo$dataReplicationError' => '<p>Error in obtaining data replication info.</p>', ], ], 'DataReplicationErrorString' => [ 'base' => NULL, 'refs' => [ 'DataReplicationError$error' => '<p>Error in data replication.</p>', ], ], 'DataReplicationInfo' => [ 'base' => '<p>Request data replication info.</p>', 'refs' => [ 'SourceServer$dataReplicationInfo' => '<p>Source server data replication info.</p>', ], ], 'DataReplicationInfoReplicatedDisk' => [ 'base' => '<p>Request to query disks replicated.</p>', 'refs' => [ 'DataReplicationInfoReplicatedDisks$member' => NULL, ], ], 'DataReplicationInfoReplicatedDisks' => [ 'base' => NULL, 'refs' => [ 'DataReplicationInfo$replicatedDisks' => '<p>Request to query disks replicated.</p>', ], ], 'DataReplicationInitiation' => [ 'base' => '<p>Data replication initiation.</p>', 'refs' => [ 'DataReplicationInfo$dataReplicationInitiation' => '<p>Request to query whether data replication has been initiated.</p>', ], ], 'DataReplicationInitiationStep' => [ 'base' => '<p>Data replication initiation step.</p>', 'refs' => [ 'DataReplicationInitiationSteps$member' => NULL, ], ], 'DataReplicationInitiationStepName' => [ 'base' => NULL, 'refs' => [ 'DataReplicationInitiationStep$name' => '<p>Request to query data initiation step name.</p>', ], ], 'DataReplicationInitiationStepStatus' => [ 'base' => NULL, 'refs' => [ 'DataReplicationInitiationStep$status' => '<p>Request to query data initiation status.</p>', ], ], 'DataReplicationInitiationSteps' => [ 'base' => NULL, 'refs' => [ 'DataReplicationInitiation$steps' => '<p>Request to query data initiation steps.</p>', ], ], 'DataReplicationState' => [ 'base' => NULL, 'refs' => [ 'DataReplicationInfo$dataReplicationState' => '<p>Request to query the data replication state.</p>', ], ], 'DeleteApplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteApplicationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteConnectorRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLaunchConfigurationTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLaunchConfigurationTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteReplicationConfigurationTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteReplicationConfigurationTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSourceServerRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSourceServerResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVcenterClientRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWaveRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWaveResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeJobLogItemsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeJobLogItemsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeJobsRequestFilters' => [ 'base' => '<p>Request to describe Job log filters.</p>', 'refs' => [ 'DescribeJobsRequest$filters' => '<p>Request to describe Job log filters.</p>', ], ], 'DescribeJobsRequestFiltersJobIDs' => [ 'base' => NULL, 'refs' => [ 'DescribeJobsRequestFilters$jobIDs' => '<p>Request to describe Job log filters by job ID.</p>', ], ], 'DescribeJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLaunchConfigurationTemplatesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLaunchConfigurationTemplatesResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeReplicationConfigurationTemplatesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeReplicationConfigurationTemplatesResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSourceServersRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSourceServersRequestApplicationIDs' => [ 'base' => NULL, 'refs' => [ 'DescribeSourceServersRequestFilters$applicationIDs' => '<p>Request to filter Source Servers list by application IDs.</p>', ], ], 'DescribeSourceServersRequestFilters' => [ 'base' => '<p>Request to filter Source Servers list.</p>', 'refs' => [ 'DescribeSourceServersRequest$filters' => '<p>Request to filter Source Servers list.</p>', ], ], 'DescribeSourceServersRequestFiltersIDs' => [ 'base' => NULL, 'refs' => [ 'DescribeSourceServersRequestFilters$sourceServerIDs' => '<p>Request to filter Source Servers list by Source Server ID.</p>', ], ], 'DescribeSourceServersResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVcenterClientsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVcenterClientsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateApplicationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateApplicationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateSourceServersRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateSourceServersRequestSourceServerIDs' => [ 'base' => NULL, 'refs' => [ 'DisassociateSourceServersRequest$sourceServerIDs' => '<p>Source server IDs list.</p>', ], ], 'DisassociateSourceServersResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisconnectFromServiceRequest' => [ 'base' => NULL, 'refs' => [], ], 'Disk' => [ 'base' => '<p>The disk identifier.</p>', 'refs' => [ 'Disks$member' => NULL, ], ], 'Disks' => [ 'base' => NULL, 'refs' => [ 'SourceProperties$disks' => '<p>Source Server disks.</p>', ], ], 'DocumentVersion' => [ 'base' => NULL, 'refs' => [ 'PutSourceServerActionRequest$documentVersion' => '<p>Source server post migration custom action document version.</p>', 'PutTemplateActionRequest$documentVersion' => '<p>Template post migration custom action document version.</p>', 'SourceServerActionDocument$documentVersion' => '<p>Source server post migration custom action document version.</p>', 'TemplateActionDocument$documentVersion' => '<p>Template post migration custom action document version.</p>', ], ], 'EC2InstanceID' => [ 'base' => NULL, 'refs' => [ 'IdentificationHints$awsInstanceID' => '<p>AWS Instance ID identification hint.</p>', 'JobLogEventData$conversionServerID' => '<p>Job Event conversion Server ID.</p>', 'JobLogEventData$targetInstanceID' => '<p>Job Event Target instance ID.</p>', 'LaunchedInstance$ec2InstanceID' => '<p>Launched instance EC2 ID.</p>', 'ParticipatingServer$launchedEc2InstanceID' => '<p>Participating server\'s launched ec2 instance ID.</p>', ], ], 'EC2InstanceType' => [ 'base' => NULL, 'refs' => [ 'CreateReplicationConfigurationTemplateRequest$replicationServerInstanceType' => '<p>Request to configure the Replication Server instance type during Replication Settings template creation.</p>', 'ReplicationConfiguration$replicationServerInstanceType' => '<p>Replication Configuration Replication Server instance type.</p>', 'ReplicationConfigurationTemplate$replicationServerInstanceType' => '<p>Replication Configuration template server instance type.</p>', 'SourceProperties$recommendedInstanceType' => '<p>Source server recommended instance type.</p>', 'UpdateReplicationConfigurationRequest$replicationServerInstanceType' => '<p>Update replication configuration Replication Server instance type request.</p>', 'UpdateReplicationConfigurationTemplateRequest$replicationServerInstanceType' => '<p>Update replication configuration template Replication Server instance type request.</p>', ], ], 'EC2LaunchConfigurationTemplateID' => [ 'base' => NULL, 'refs' => [ 'LaunchConfigurationTemplate$ec2LaunchTemplateID' => '<p>EC2 launch template ID.</p>', ], ], 'ErrorDetails' => [ 'base' => '<p>Error details.</p>', 'refs' => [ 'ConflictExceptionErrors$member' => NULL, ], ], 'ExportErrorData' => [ 'base' => '<p>Export errors data.</p>', 'refs' => [ 'ExportTaskError$errorData' => '<p>Export task error data.</p>', ], ], 'ExportErrors' => [ 'base' => NULL, 'refs' => [ 'ListExportErrorsResponse$items' => '<p>List export errors response items.</p>', ], ], 'ExportID' => [ 'base' => NULL, 'refs' => [ 'ExportTask$exportID' => '<p>Export task id.</p>', 'ListExportErrorsRequest$exportID' => '<p>List export errors request export id.</p>', 'ListExportsRequestFiltersExportIDs$member' => NULL, ], ], 'ExportStatus' => [ 'base' => NULL, 'refs' => [ 'ExportTask$status' => '<p>Export task status.</p>', ], ], 'ExportTask' => [ 'base' => '<p>Export task.</p>', 'refs' => [ 'ExportsList$member' => NULL, 'StartExportResponse$exportTask' => '<p>Start export response export task.</p>', ], ], 'ExportTaskError' => [ 'base' => '<p>Export task error.</p>', 'refs' => [ 'ExportErrors$member' => NULL, ], ], 'ExportTaskSummary' => [ 'base' => '<p>Export task summary.</p>', 'refs' => [ 'ExportTask$summary' => '<p>Export task summary.</p>', ], ], 'ExportsList' => [ 'base' => NULL, 'refs' => [ 'ListExportsResponse$items' => '<p>List export response items.</p>', ], ], 'FinalizeCutoverRequest' => [ 'base' => NULL, 'refs' => [], ], 'FirstBoot' => [ 'base' => NULL, 'refs' => [ 'LaunchedInstance$firstBoot' => '<p>Launched instance first boot.</p>', ], ], 'Float' => [ 'base' => NULL, 'refs' => [ 'ExportTask$progressPercentage' => '<p>Export task progress percentage.</p>', 'ImportTask$progressPercentage' => '<p>Import task progress percentage.</p>', ], ], 'GetLaunchConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetReplicationConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'IPsList' => [ 'base' => NULL, 'refs' => [ 'NetworkInterface$ips' => '<p>Network interface IPs.</p>', ], ], 'ISO8601DatetimeString' => [ 'base' => NULL, 'refs' => [ 'Application$creationDateTime' => '<p>Application creation dateTime.</p>', 'Application$lastModifiedDateTime' => '<p>Application last modified dateTime.</p>', 'ApplicationAggregatedStatus$lastUpdateDateTime' => '<p>Application aggregated status last update dateTime.</p>', 'DataReplicationInfo$etaDateTime' => '<p>Request to query the time when data replication will be complete.</p>', 'DataReplicationInfo$lastSnapshotDateTime' => '<p>Request to query data replication last snapshot time.</p>', 'DataReplicationInitiation$nextAttemptDateTime' => '<p>Request to query next data initiation date and time.</p>', 'DataReplicationInitiation$startDateTime' => '<p>Request to query data initiation start date and time.</p>', 'DescribeJobsRequestFilters$fromDate' => '<p>Request to describe Job log filters by date.</p>', 'DescribeJobsRequestFilters$toDate' => '<p>Request to describe job log items by last date.</p>', 'ExportTask$creationDateTime' => '<p>Export task creation datetime.</p>', 'ExportTask$endDateTime' => '<p>Export task end datetime.</p>', 'ExportTaskError$errorDateTime' => '<p>Export task error datetime.</p>', 'ImportTask$creationDateTime' => '<p>Import task creation datetime.</p>', 'ImportTask$endDateTime' => '<p>Import task end datetime.</p>', 'ImportTaskError$errorDateTime' => '<p>Import task error datetime.</p>', 'Job$creationDateTime' => '<p>Job creation time.</p>', 'Job$endDateTime' => '<p>Job end time.</p>', 'JobLog$logDateTime' => '<p>Job log event date and time.</p>', 'LifeCycle$addedToServiceDateTime' => '<p>Lifecycle added to service data and time.</p>', 'LifeCycle$firstByteDateTime' => '<p>Lifecycle replication initiation date and time.</p>', 'LifeCycle$lastSeenByServiceDateTime' => '<p>Lifecycle last seen date and time.</p>', 'LifeCycleLastCutoverFinalized$apiCallDateTime' => '<p>Lifecycle Cutover finalized date and time.</p>', 'LifeCycleLastCutoverInitiated$apiCallDateTime' => '<p/>', 'LifeCycleLastCutoverReverted$apiCallDateTime' => '<p>Lifecycle last Cutover reverted API call date time.</p>', 'LifeCycleLastTestFinalized$apiCallDateTime' => '<p>Lifecycle Test failed API call date and time.</p>', 'LifeCycleLastTestInitiated$apiCallDateTime' => '<p>Lifecycle last Test initiated API call date and time.</p>', 'LifeCycleLastTestReverted$apiCallDateTime' => '<p>Lifecycle last Test reverted API call date and time.</p>', 'PostLaunchActionsStatus$ssmAgentDiscoveryDatetime' => '<p>Time where the AWS Systems Manager was detected as running on the Test or Cutover instance.</p>', 'SourceProperties$lastUpdatedDateTime' => '<p>Source server last update date and time.</p>', 'VcenterClient$lastSeenDatetime' => '<p>Last seen time of vCenter client.</p>', 'Wave$creationDateTime' => '<p>Wave creation dateTime.</p>', 'Wave$lastModifiedDateTime' => '<p>Wave last modified dateTime.</p>', 'WaveAggregatedStatus$lastUpdateDateTime' => '<p>Wave aggregated status last update dateTime.</p>', 'WaveAggregatedStatus$replicationStartedDateTime' => '<p>DateTime marking when the first source server in the wave started replication.</p>', ], ], 'ISO8601DurationString' => [ 'base' => NULL, 'refs' => [ 'DataReplicationInfo$lagDuration' => '<p>Request to query data replication lag duration.</p>', 'LifeCycle$elapsedReplicationDuration' => '<p>Lifecycle elapsed time and duration.</p>', ], ], 'IdentificationHints' => [ 'base' => '<p>Identification hints.</p>', 'refs' => [ 'SourceProperties$identificationHints' => '<p>Source server identification hints.</p>', ], ], 'ImportErrorData' => [ 'base' => '<p>Import error data.</p>', 'refs' => [ 'ImportTaskError$errorData' => '<p>Import task error data.</p>', ], ], 'ImportErrorType' => [ 'base' => NULL, 'refs' => [ 'ImportTaskError$errorType' => '<p>Import task error type.</p>', ], ], 'ImportErrors' => [ 'base' => NULL, 'refs' => [ 'ListImportErrorsResponse$items' => '<p>List imports errors response items.</p>', ], ], 'ImportID' => [ 'base' => NULL, 'refs' => [ 'ImportIDsFilter$member' => NULL, 'ImportTask$importID' => '<p>Import task id.</p>', 'ListImportErrorsRequest$importID' => '<p>List import errors request import id.</p>', ], ], 'ImportIDsFilter' => [ 'base' => NULL, 'refs' => [ 'ListImportsRequestFilters$importIDs' => '<p>List imports request filters import IDs.</p>', ], ], 'ImportList' => [ 'base' => NULL, 'refs' => [ 'ListImportsResponse$items' => '<p>List import response items.</p>', ], ], 'ImportStatus' => [ 'base' => NULL, 'refs' => [ 'ImportTask$status' => '<p>Import task status.</p>', ], ], 'ImportTask' => [ 'base' => '<p>Import task.</p>', 'refs' => [ 'ImportList$member' => NULL, 'StartImportResponse$importTask' => '<p>Start import response import task.</p>', ], ], 'ImportTaskError' => [ 'base' => '<p>Import task error.</p>', 'refs' => [ 'ImportErrors$member' => NULL, ], ], 'ImportTaskSummary' => [ 'base' => '<p>Import task summary.</p>', 'refs' => [ 'ImportTask$summary' => '<p>Import task summary.</p>', ], ], 'ImportTaskSummaryApplications' => [ 'base' => '<p>Import task summary applications.</p>', 'refs' => [ 'ImportTaskSummary$applications' => '<p>Import task summary applications.</p>', ], ], 'ImportTaskSummaryServers' => [ 'base' => '<p>Import task summary servers.</p>', 'refs' => [ 'ImportTaskSummary$servers' => '<p>Import task summary servers.</p>', ], ], 'ImportTaskSummaryWaves' => [ 'base' => '<p>Import task summery waves.</p>', 'refs' => [ 'ImportTaskSummary$waves' => '<p>Import task summary waves.</p>', ], ], 'InitializeServiceRequest' => [ 'base' => NULL, 'refs' => [], ], 'InitializeServiceResponse' => [ 'base' => NULL, 'refs' => [], ], 'InitiatedBy' => [ 'base' => NULL, 'refs' => [ 'Job$initiatedBy' => '<p>Job initiated by field.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>The server encountered an unexpected condition that prevented it from fulfilling the request.</p>', 'refs' => [], ], 'Iops' => [ 'base' => NULL, 'refs' => [ 'LaunchTemplateDiskConf$iops' => '<p>Launch template disk iops configuration.</p>', ], ], 'JmesPathString' => [ 'base' => NULL, 'refs' => [ 'SsmExternalParameter$dynamicPath' => '<p>AWS Systems Manager Document external parameters dynamic path.</p>', ], ], 'Job' => [ 'base' => '<p>Job.</p>', 'refs' => [ 'JobsList$member' => NULL, 'StartCutoverResponse$job' => '<p>Start Cutover Job response.</p>', 'StartTestResponse$job' => '<p>Start Test Job response.</p>', 'TerminateTargetInstancesResponse$job' => '<p>Terminate Target instance Job response.</p>', ], ], 'JobID' => [ 'base' => NULL, 'refs' => [ 'DeleteJobRequest$jobID' => '<p>Request to delete Job from service by Job ID.</p>', 'DescribeJobLogItemsRequest$jobID' => '<p>Request to describe Job log job ID.</p>', 'DescribeJobsRequestFiltersJobIDs$member' => NULL, 'Job$jobID' => '<p>Job ID.</p>', 'LaunchedInstance$jobID' => '<p>Launched instance Job ID.</p>', 'LifeCycleLastCutoverInitiated$jobID' => '<p>Lifecycle last Cutover initiated by Job ID.</p>', 'LifeCycleLastTestInitiated$jobID' => '<p>Lifecycle last Test initiated Job ID.</p>', ], ], 'JobLog' => [ 'base' => '<p>Job log.</p>', 'refs' => [ 'JobLogs$member' => NULL, ], ], 'JobLogEvent' => [ 'base' => NULL, 'refs' => [ 'JobLog$event' => '<p>Job log event.</p>', ], ], 'JobLogEventData' => [ 'base' => '<p>Job log data</p>', 'refs' => [ 'JobLog$eventData' => '<p>Job event data</p>', ], ], 'JobLogs' => [ 'base' => NULL, 'refs' => [ 'DescribeJobLogItemsResponse$items' => '<p>Request to describe Job log response items.</p>', ], ], 'JobPostLaunchActionsLaunchStatus' => [ 'base' => '<p>Launch Status of the Job Post Launch Actions.</p>', 'refs' => [ 'PostLaunchActionsLaunchStatusList$member' => NULL, ], ], 'JobStatus' => [ 'base' => NULL, 'refs' => [ 'Job$status' => '<p>Job status.</p>', ], ], 'JobType' => [ 'base' => NULL, 'refs' => [ 'Job$type' => '<p>Job type.</p>', ], ], 'JobsList' => [ 'base' => NULL, 'refs' => [ 'DescribeJobsResponse$items' => '<p>Request to describe Job log items.</p>', ], ], 'LargeBoundedString' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$code' => NULL, 'AccessDeniedException$message' => NULL, 'ConflictException$code' => NULL, 'ConflictException$message' => NULL, 'ConflictException$resourceId' => '<p>A conflict occurred when prompting for the Resource ID.</p>', 'ConflictException$resourceType' => '<p>A conflict occurred when prompting for resource type.</p>', 'DataReplicationError$rawError' => '<p>Error in data replication.</p>', 'ErrorDetails$message' => '<p>Error details message.</p>', 'ErrorDetails$resourceId' => '<p>Error details resourceId.</p>', 'ErrorDetails$resourceType' => '<p>Error details resourceType.</p>', 'ExportErrorData$rawError' => '<p>Export errors data raw error.</p>', 'ImportErrorData$rawError' => '<p>Import error data raw error.</p>', 'InternalServerException$message' => NULL, 'JobLogEventData$rawError' => '<p>Job error.</p>', 'ResourceNotFoundException$code' => NULL, 'ResourceNotFoundException$message' => NULL, 'ResourceNotFoundException$resourceId' => '<p>Resource ID not found error.</p>', 'ResourceNotFoundException$resourceType' => '<p>Resource type not found error.</p>', 'ServiceQuotaExceededException$code' => NULL, 'ServiceQuotaExceededException$message' => NULL, 'ServiceQuotaExceededException$quotaCode' => '<p>Exceeded the service quota code.</p>', 'ServiceQuotaExceededException$resourceId' => '<p>Exceeded the service quota resource ID.</p>', 'ServiceQuotaExceededException$resourceType' => '<p>Exceeded the service quota resource type.</p>', 'ServiceQuotaExceededException$serviceCode' => '<p>Exceeded the service quota service code.</p>', 'ThrottlingException$message' => NULL, 'ThrottlingException$quotaCode' => '<p>Reached throttling quota exception.</p>', 'ThrottlingException$retryAfterSeconds' => '<p>Reached throttling quota exception will retry after x seconds.</p>', 'ThrottlingException$serviceCode' => '<p>Reached throttling quota exception service code.</p>', 'UninitializedAccountException$code' => NULL, 'UninitializedAccountException$message' => NULL, 'ValidationException$code' => NULL, 'ValidationException$message' => NULL, 'ValidationExceptionField$message' => '<p>Validate exception field message.</p>', 'ValidationExceptionField$name' => '<p>Validate exception field name.</p>', ], ], 'LaunchConfiguration' => [ 'base' => NULL, 'refs' => [], ], 'LaunchConfigurationTemplate' => [ 'base' => NULL, 'refs' => [ 'LaunchConfigurationTemplates$member' => NULL, ], ], 'LaunchConfigurationTemplateID' => [ 'base' => NULL, 'refs' => [ 'DeleteLaunchConfigurationTemplateRequest$launchConfigurationTemplateID' => '<p>ID of resource to be deleted.</p>', 'LaunchConfigurationTemplate$launchConfigurationTemplateID' => '<p>ID of the Launch Configuration Template.</p>', 'LaunchConfigurationTemplateIDs$member' => NULL, 'ListTemplateActionsRequest$launchConfigurationTemplateID' => '<p>Launch configuration template ID.</p>', 'PutTemplateActionRequest$launchConfigurationTemplateID' => '<p>Launch configuration template ID.</p>', 'RemoveTemplateActionRequest$launchConfigurationTemplateID' => '<p>Launch configuration template ID of the post migration custom action to remove.</p>', 'UpdateLaunchConfigurationTemplateRequest$launchConfigurationTemplateID' => '<p>Launch Configuration Template ID.</p>', ], ], 'LaunchConfigurationTemplateIDs' => [ 'base' => NULL, 'refs' => [ 'DescribeLaunchConfigurationTemplatesRequest$launchConfigurationTemplateIDs' => '<p>Request to filter Launch Configuration Templates list by Launch Configuration Template ID.</p>', ], ], 'LaunchConfigurationTemplates' => [ 'base' => NULL, 'refs' => [ 'DescribeLaunchConfigurationTemplatesResponse$items' => '<p>List of items returned by DescribeLaunchConfigurationTemplates.</p>', ], ], 'LaunchDisposition' => [ 'base' => NULL, 'refs' => [ 'CreateLaunchConfigurationTemplateRequest$launchDisposition' => '<p>Launch disposition.</p>', 'LaunchConfiguration$launchDisposition' => '<p>Launch disposition for launch configuration.</p>', 'LaunchConfigurationTemplate$launchDisposition' => '<p>Launch disposition.</p>', 'UpdateLaunchConfigurationRequest$launchDisposition' => '<p>Update Launch configuration launch disposition request.</p>', 'UpdateLaunchConfigurationTemplateRequest$launchDisposition' => '<p>Launch disposition.</p>', ], ], 'LaunchStatus' => [ 'base' => NULL, 'refs' => [ 'ParticipatingServer$launchStatus' => '<p>Participating server launch status.</p>', ], ], 'LaunchTemplateDiskConf' => [ 'base' => '<p>Launch template disk configuration.</p>', 'refs' => [ 'CreateLaunchConfigurationTemplateRequest$largeVolumeConf' => '<p>Large volume config.</p>', 'CreateLaunchConfigurationTemplateRequest$smallVolumeConf' => '<p>Small volume config.</p>', 'LaunchConfigurationTemplate$largeVolumeConf' => '<p>Large volume config.</p>', 'LaunchConfigurationTemplate$smallVolumeConf' => '<p>Small volume config.</p>', 'UpdateLaunchConfigurationTemplateRequest$largeVolumeConf' => '<p>Large volume config.</p>', 'UpdateLaunchConfigurationTemplateRequest$smallVolumeConf' => '<p>Small volume config.</p>', ], ], 'LaunchedInstance' => [ 'base' => '<p>Launched instance.</p>', 'refs' => [ 'SourceServer$launchedInstance' => '<p>Source server launched instance.</p>', ], ], 'Licensing' => [ 'base' => '<p>Configure Licensing.</p>', 'refs' => [ 'CreateLaunchConfigurationTemplateRequest$licensing' => NULL, 'LaunchConfiguration$licensing' => '<p>Launch configuration OS licensing.</p>', 'LaunchConfigurationTemplate$licensing' => NULL, 'UpdateLaunchConfigurationRequest$licensing' => '<p>Update Launch configuration licensing request.</p>', 'UpdateLaunchConfigurationTemplateRequest$licensing' => NULL, ], ], 'LifeCycle' => [ 'base' => '<p>Lifecycle.</p>', 'refs' => [ 'SourceServer$lifeCycle' => '<p>Source server lifecycle state.</p>', ], ], 'LifeCycleLastCutover' => [ 'base' => '<p>Lifecycle last Cutover .</p>', 'refs' => [ 'LifeCycle$lastCutover' => '<p>Lifecycle last Cutover.</p>', ], ], 'LifeCycleLastCutoverFinalized' => [ 'base' => '<p>Lifecycle Cutover finalized</p>', 'refs' => [ 'LifeCycleLastCutover$finalized' => '<p>Lifecycle Cutover finalized date and time.</p>', ], ], 'LifeCycleLastCutoverInitiated' => [ 'base' => '<p>Lifecycle last Cutover initiated.</p>', 'refs' => [ 'LifeCycleLastCutover$initiated' => '<p>Lifecycle last Cutover initiated.</p>', ], ], 'LifeCycleLastCutoverReverted' => [ 'base' => '<p>Lifecycle last Cutover reverted.</p>', 'refs' => [ 'LifeCycleLastCutover$reverted' => '<p>Lifecycle last Cutover reverted.</p>', ], ], 'LifeCycleLastTest' => [ 'base' => '<p>Lifecycle last Test.</p>', 'refs' => [ 'LifeCycle$lastTest' => '<p>Lifecycle last Test.</p>', ], ], 'LifeCycleLastTestFinalized' => [ 'base' => '<p>Lifecycle last Test finalized.</p>', 'refs' => [ 'LifeCycleLastTest$finalized' => '<p>Lifecycle last Test finalized.</p>', ], ], 'LifeCycleLastTestInitiated' => [ 'base' => '<p>Lifecycle last Test initiated.</p>', 'refs' => [ 'LifeCycleLastTest$initiated' => '<p>Lifecycle last Test initiated.</p>', ], ], 'LifeCycleLastTestReverted' => [ 'base' => '<p>Lifecycle last Test reverted.</p>', 'refs' => [ 'LifeCycleLastTest$reverted' => '<p>Lifecycle last Test reverted.</p>', ], ], 'LifeCycleState' => [ 'base' => NULL, 'refs' => [ 'LifeCycle$state' => '<p>Lifecycle state.</p>', 'LifeCycleStates$member' => NULL, ], ], 'LifeCycleStates' => [ 'base' => NULL, 'refs' => [ 'DescribeSourceServersRequestFilters$lifeCycleStates' => '<p>Request to filter Source Servers list by life cycle states.</p>', ], ], 'ListApplicationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListApplicationsRequestFilters' => [ 'base' => '<p>Applications list filters.</p>', 'refs' => [ 'ListApplicationsRequest$filters' => '<p>Applications list filters.</p>', ], ], 'ListApplicationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListConnectorsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListConnectorsRequestFilters' => [ 'base' => '<p>List Connectors Request Filters.</p>', 'refs' => [ 'ListConnectorsRequest$filters' => '<p>List Connectors Request filters.</p>', ], ], 'ListConnectorsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListExportErrorsRequest' => [ 'base' => '<p>List export errors request.</p>', 'refs' => [], ], 'ListExportErrorsResponse' => [ 'base' => '<p>List export errors response.</p>', 'refs' => [], ], 'ListExportsRequest' => [ 'base' => '<p>List export request.</p>', 'refs' => [], ], 'ListExportsRequestFilters' => [ 'base' => '<p>List exports request filters.</p>', 'refs' => [ 'ListExportsRequest$filters' => NULL, ], ], 'ListExportsRequestFiltersExportIDs' => [ 'base' => NULL, 'refs' => [ 'ListExportsRequestFilters$exportIDs' => '<p>List exports request filters export ids.</p>', ], ], 'ListExportsResponse' => [ 'base' => '<p>List export response.</p>', 'refs' => [], ], 'ListImportErrorsRequest' => [ 'base' => '<p>List import errors request.</p>', 'refs' => [], ], 'ListImportErrorsResponse' => [ 'base' => '<p>List imports errors response.</p>', 'refs' => [], ], 'ListImportsRequest' => [ 'base' => '<p>List imports request.</p>', 'refs' => [], ], 'ListImportsRequestFilters' => [ 'base' => '<p>List imports request filters.</p>', 'refs' => [ 'ListImportsRequest$filters' => '<p>List imports request filters.</p>', ], ], 'ListImportsResponse' => [ 'base' => '<p>List import response.</p>', 'refs' => [], ], 'ListManagedAccountsRequest' => [ 'base' => '<p>List managed accounts request.</p>', 'refs' => [], ], 'ListManagedAccountsResponse' => [ 'base' => '<p>List managed accounts response.</p>', 'refs' => [], ], 'ListSourceServerActionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSourceServerActionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTemplateActionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTemplateActionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListWavesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListWavesRequestFilters' => [ 'base' => '<p>Waves list filters.</p>', 'refs' => [ 'ListWavesRequest$filters' => '<p>Waves list filters.</p>', ], ], 'ListWavesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ManagedAccount' => [ 'base' => '<p>Managed account.</p>', 'refs' => [ 'ManagedAccounts$member' => NULL, ], ], 'ManagedAccounts' => [ 'base' => NULL, 'refs' => [ 'ListManagedAccountsResponse$items' => '<p>List managed accounts response items.</p>', ], ], 'MarkAsArchivedRequest' => [ 'base' => NULL, 'refs' => [], ], 'MaxResultsType' => [ 'base' => NULL, 'refs' => [ 'DescribeJobLogItemsRequest$maxResults' => '<p>Request to describe Job log item maximum results.</p>', 'DescribeJobsRequest$maxResults' => '<p>Request to describe job log items by max results.</p>', 'DescribeLaunchConfigurationTemplatesRequest$maxResults' => '<p>Maximum results to be returned in DescribeLaunchConfigurationTemplates.</p>', 'DescribeReplicationConfigurationTemplatesRequest$maxResults' => '<p>Request to describe Replication Configuration template by max results.</p>', 'DescribeSourceServersRequest$maxResults' => '<p>Request to filter Source Servers list by maximum results.</p>', 'DescribeVcenterClientsRequest$maxResults' => '<p>Maximum results to be returned in DescribeVcenterClients.</p>', 'ListApplicationsRequest$maxResults' => '<p>Maximum results to return when listing applications.</p>', 'ListConnectorsRequest$maxResults' => '<p>List Connectors Request max results.</p>', 'ListExportErrorsRequest$maxResults' => '<p>List export errors request max results.</p>', 'ListExportsRequest$maxResults' => '<p>List export request max results.</p>', 'ListImportErrorsRequest$maxResults' => '<p>List import errors request max results.</p>', 'ListImportsRequest$maxResults' => '<p>List imports request max results.</p>', 'ListManagedAccountsRequest$maxResults' => '<p>List managed accounts request max results.</p>', 'ListSourceServerActionsRequest$maxResults' => '<p>Maximum amount of items to return when listing source server post migration custom actions.</p>', 'ListTemplateActionsRequest$maxResults' => '<p>Maximum amount of items to return when listing template post migration custom actions.</p>', 'ListWavesRequest$maxResults' => '<p>Maximum results to return when listing waves.</p>', ], ], 'NetworkInterface' => [ 'base' => '<p>Network interface.</p>', 'refs' => [ 'NetworkInterfaces$member' => NULL, ], ], 'NetworkInterfaces' => [ 'base' => NULL, 'refs' => [ 'SourceProperties$networkInterfaces' => '<p>Source server network interfaces.</p>', ], ], 'OS' => [ 'base' => '<p>Operating System.</p>', 'refs' => [ 'SourceProperties$os' => '<p>Source server OS.</p>', ], ], 'OperatingSystemString' => [ 'base' => NULL, 'refs' => [ 'PutTemplateActionRequest$operatingSystem' => '<p>Operating system eligible for this template post migration custom action.</p>', 'TemplateActionDocument$operatingSystem' => '<p>Operating system eligible for this template post migration custom action.</p>', ], ], 'OrderType' => [ 'base' => NULL, 'refs' => [ 'PutSourceServerActionRequest$order' => '<p>Source server post migration custom action order.</p>', 'PutTemplateActionRequest$order' => '<p>Template post migration custom action order.</p>', 'SourceServerActionDocument$order' => '<p>Source server post migration custom action order.</p>', 'TemplateActionDocument$order' => '<p>Template post migration custom action order.</p>', ], ], 'PaginationToken' => [ 'base' => NULL, 'refs' => [ 'DescribeJobLogItemsRequest$nextToken' => '<p>Request to describe Job log next token.</p>', 'DescribeJobLogItemsResponse$nextToken' => '<p>Request to describe Job log response next token.</p>', 'DescribeJobsRequest$nextToken' => '<p>Request to describe job log items by next token.</p>', 'DescribeJobsResponse$nextToken' => '<p>Request to describe Job response by next token.</p>', 'DescribeLaunchConfigurationTemplatesRequest$nextToken' => '<p>Next pagination token returned from DescribeLaunchConfigurationTemplates.</p>', 'DescribeLaunchConfigurationTemplatesResponse$nextToken' => '<p>Next pagination token returned from DescribeLaunchConfigurationTemplates.</p>', 'DescribeReplicationConfigurationTemplatesRequest$nextToken' => '<p>Request to describe Replication Configuration template by next token.</p>', 'DescribeReplicationConfigurationTemplatesResponse$nextToken' => '<p>Request to describe Replication Configuration template by next token.</p>', 'DescribeSourceServersRequest$nextToken' => '<p>Request to filter Source Servers list by next token.</p>', 'DescribeSourceServersResponse$nextToken' => '<p>Request to filter Source Servers next token.</p>', 'DescribeVcenterClientsRequest$nextToken' => '<p>Next pagination token to be provided for DescribeVcenterClients.</p>', 'DescribeVcenterClientsResponse$nextToken' => '<p>Next pagination token returned from DescribeVcenterClients.</p>', 'ListApplicationsRequest$nextToken' => '<p>Request next token.</p>', 'ListApplicationsResponse$nextToken' => '<p>Response next token.</p>', 'ListConnectorsRequest$nextToken' => '<p>List Connectors Request next token.</p>', 'ListConnectorsResponse$nextToken' => '<p>List connectors response next token.</p>', 'ListExportErrorsRequest$nextToken' => '<p>List export errors request next token.</p>', 'ListExportErrorsResponse$nextToken' => '<p>List export errors response next token.</p>', 'ListExportsRequest$nextToken' => '<p>List export request next token.</p>', 'ListExportsResponse$nextToken' => '<p>List export response next token.</p>', 'ListImportErrorsRequest$nextToken' => '<p>List import errors request next token.</p>', 'ListImportErrorsResponse$nextToken' => '<p>List imports errors response next token.</p>', 'ListImportsRequest$nextToken' => '<p>List imports request next token.</p>', 'ListImportsResponse$nextToken' => '<p>List import response next token.</p>', 'ListManagedAccountsRequest$nextToken' => '<p>List managed accounts request next token.</p>', 'ListManagedAccountsResponse$nextToken' => '<p>List managed accounts response next token.</p>', 'ListSourceServerActionsRequest$nextToken' => '<p>Next token to use when listing source server post migration custom actions.</p>', 'ListSourceServerActionsResponse$nextToken' => '<p>Next token returned when listing source server post migration custom actions.</p>', 'ListTemplateActionsRequest$nextToken' => '<p>Next token to use when listing template post migration custom actions.</p>', 'ListTemplateActionsResponse$nextToken' => '<p>Next token returned when listing template post migration custom actions.</p>', 'ListWavesRequest$nextToken' => '<p>Request next token.</p>', 'ListWavesResponse$nextToken' => '<p>Response next token.</p>', ], ], 'ParticipatingServer' => [ 'base' => '<p>Server participating in Job.</p>', 'refs' => [ 'ParticipatingServers$member' => NULL, ], ], 'ParticipatingServers' => [ 'base' => NULL, 'refs' => [ 'Job$participatingServers' => '<p>Servers participating in a specific Job.</p>', ], ], 'PauseReplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'PositiveInteger' => [ 'base' => NULL, 'refs' => [ 'ApplicationAggregatedStatus$totalSourceServers' => '<p>Application aggregated status total source servers amount.</p>', 'CPU$cores' => '<p>The number of CPU cores on the source server.</p>', 'CreateLaunchConfigurationTemplateRequest$smallVolumeMaxSize' => '<p>Small volume maximum size.</p>', 'DataReplicationInfoReplicatedDisk$backloggedStorageBytes' => '<p>Request to query data replication backlog size in bytes.</p>', 'DataReplicationInfoReplicatedDisk$replicatedStorageBytes' => '<p>Request to query amount of data replicated in bytes.</p>', 'DataReplicationInfoReplicatedDisk$rescannedStorageBytes' => '<p>Request to query amount of data rescanned in bytes.</p>', 'DataReplicationInfoReplicatedDisk$totalStorageBytes' => '<p>Request to query total amount of data replicated in bytes.</p>', 'Disk$bytes' => '<p>The amount of storage on the disk in bytes.</p>', 'ExportTaskSummary$applicationsCount' => '<p>Export task summary applications count.</p>', 'ExportTaskSummary$serversCount' => '<p>Export task summary servers count.</p>', 'ExportTaskSummary$wavesCount' => '<p>Export task summary waves count.</p>', 'ImportErrorData$rowNumber' => '<p>Import error data row number.</p>', 'ImportTaskSummaryApplications$createdCount' => '<p>Import task summary applications created count.</p>', 'ImportTaskSummaryApplications$modifiedCount' => '<p>Import task summary applications modified count.</p>', 'ImportTaskSummaryServers$createdCount' => '<p>Import task summary servers created count.</p>', 'ImportTaskSummaryServers$modifiedCount' => '<p>Import task summary servers modified count.</p>', 'ImportTaskSummaryWaves$createdCount' => '<p>Import task summery waves created count.</p>', 'ImportTaskSummaryWaves$modifiedCount' => '<p>Import task summery waves modified count.</p>', 'InternalServerException$retryAfterSeconds' => '<p>The server encountered an unexpected condition that prevented it from fulfilling the request. The request will be retried again after x seconds.</p>', 'LaunchConfigurationTemplate$smallVolumeMaxSize' => '<p>Small volume maximum size.</p>', 'ReplicationConfigurationReplicatedDisk$iops' => '<p>Replication Configuration replicated disk IOPs.</p>', 'ReplicationConfigurationReplicatedDisk$throughput' => '<p>Replication Configuration replicated disk throughput.</p>', 'SourceProperties$ramBytes' => '<p>Source server RAM in bytes.</p>', 'UpdateLaunchConfigurationTemplateRequest$smallVolumeMaxSize' => '<p>Small volume maximum size.</p>', 'WaveAggregatedStatus$totalApplications' => '<p>Wave aggregated status total applications amount.</p>', ], ], 'PostLaunchActionExecutionStatus' => [ 'base' => NULL, 'refs' => [ 'JobPostLaunchActionsLaunchStatus$executionStatus' => '<p>AWS Systems Manager Document\'s execution status.</p>', ], ], 'PostLaunchActions' => [ 'base' => '<p>Post Launch Actions to executed on the Test or Cutover instance.</p>', 'refs' => [ 'CreateLaunchConfigurationTemplateRequest$postLaunchActions' => '<p>Launch configuration template post launch actions.</p>', 'LaunchConfiguration$postLaunchActions' => NULL, 'LaunchConfigurationTemplate$postLaunchActions' => '<p>Post Launch Actions of the Launch Configuration Template.</p>', 'UpdateLaunchConfigurationRequest$postLaunchActions' => NULL, 'UpdateLaunchConfigurationTemplateRequest$postLaunchActions' => '<p>Post Launch Action to execute on the Test or Cutover instance.</p>', ], ], 'PostLaunchActionsDeploymentType' => [ 'base' => NULL, 'refs' => [ 'PostLaunchActions$deployment' => '<p>Deployment type in which AWS Systems Manager Documents will be executed.</p>', ], ], 'PostLaunchActionsLaunchStatusList' => [ 'base' => NULL, 'refs' => [ 'PostLaunchActionsStatus$postLaunchActionsLaunchStatusList' => '<p>List of Post Launch Action status.</p>', ], ], 'PostLaunchActionsStatus' => [ 'base' => '<p>Status of the Post Launch Actions running on the Test or Cutover instance.</p>', 'refs' => [ 'ParticipatingServer$postLaunchActionsStatus' => '<p>Participating server\'s Post Launch Actions Status.</p>', ], ], 'PutSourceServerActionRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutTemplateActionRequest' => [ 'base' => NULL, 'refs' => [], ], 'RemoveSourceServerActionRequest' => [ 'base' => NULL, 'refs' => [], ], 'RemoveSourceServerActionResponse' => [ 'base' => NULL, 'refs' => [], ], 'RemoveTemplateActionRequest' => [ 'base' => NULL, 'refs' => [], ], 'RemoveTemplateActionResponse' => [ 'base' => NULL, 'refs' => [], ], 'ReplicationConfiguration' => [ 'base' => NULL, 'refs' => [], ], 'ReplicationConfigurationDataPlaneRouting' => [ 'base' => NULL, 'refs' => [ 'CreateReplicationConfigurationTemplateRequest$dataPlaneRouting' => '<p>Request to configure data plane routing during Replication Settings template creation.</p>', 'ReplicationConfiguration$dataPlaneRouting' => '<p>Replication Configuration data plane routing.</p>', 'ReplicationConfigurationTemplate$dataPlaneRouting' => '<p>Replication Configuration template data plane routing.</p>', 'UpdateReplicationConfigurationRequest$dataPlaneRouting' => '<p>Update replication configuration data plane routing request.</p>', 'UpdateReplicationConfigurationTemplateRequest$dataPlaneRouting' => '<p>Update replication configuration template data plane routing request.</p>', ], ], 'ReplicationConfigurationDefaultLargeStagingDiskType' => [ 'base' => NULL, 'refs' => [ 'CreateReplicationConfigurationTemplateRequest$defaultLargeStagingDiskType' => '<p>Request to configure the default large staging disk EBS volume type during Replication Settings template creation.</p>', 'ReplicationConfiguration$defaultLargeStagingDiskType' => '<p>Replication Configuration use default large Staging Disks.</p>', 'ReplicationConfigurationTemplate$defaultLargeStagingDiskType' => '<p>Replication Configuration template use default large Staging Disk type.</p>', 'UpdateReplicationConfigurationRequest$defaultLargeStagingDiskType' => '<p>Update replication configuration use default large Staging Disk type request.</p>', 'UpdateReplicationConfigurationTemplateRequest$defaultLargeStagingDiskType' => '<p>Update replication configuration template use default large Staging Disk type request.</p>', ], ], 'ReplicationConfigurationEbsEncryption' => [ 'base' => NULL, 'refs' => [ 'CreateReplicationConfigurationTemplateRequest$ebsEncryption' => '<p>Request to configure EBS encryption during Replication Settings template creation.</p>', 'ReplicationConfiguration$ebsEncryption' => '<p>Replication Configuration EBS encryption.</p>', 'ReplicationConfigurationTemplate$ebsEncryption' => '<p>Replication Configuration template EBS encryption.</p>', 'UpdateReplicationConfigurationRequest$ebsEncryption' => '<p>Update replication configuration EBS encryption request.</p>', 'UpdateReplicationConfigurationTemplateRequest$ebsEncryption' => '<p>Update replication configuration template EBS encryption request.</p>', ], ], 'ReplicationConfigurationReplicatedDisk' => [ 'base' => '<p>Replication Configuration replicated disk.</p>', 'refs' => [ 'ReplicationConfigurationReplicatedDisks$member' => NULL, ], ], 'ReplicationConfigurationReplicatedDiskStagingDiskType' => [ 'base' => NULL, 'refs' => [ 'ReplicationConfigurationReplicatedDisk$stagingDiskType' => '<p>Replication Configuration replicated disk staging disk type.</p>', ], ], 'ReplicationConfigurationReplicatedDisks' => [ 'base' => NULL, 'refs' => [ 'ReplicationConfiguration$replicatedDisks' => '<p>Replication Configuration replicated disks.</p>', 'UpdateReplicationConfigurationRequest$replicatedDisks' => '<p>Update replication configuration replicated disks request.</p>', ], ], 'ReplicationConfigurationTemplate' => [ 'base' => NULL, 'refs' => [ 'ReplicationConfigurationTemplates$member' => NULL, ], ], 'ReplicationConfigurationTemplateID' => [ 'base' => NULL, 'refs' => [ 'DeleteReplicationConfigurationTemplateRequest$replicationConfigurationTemplateID' => '<p>Request to delete Replication Configuration Template from service by Replication Configuration Template ID.</p>', 'ReplicationConfigurationTemplate$replicationConfigurationTemplateID' => '<p>Replication Configuration template ID.</p>', 'ReplicationConfigurationTemplateIDs$member' => NULL, 'UpdateReplicationConfigurationTemplateRequest$replicationConfigurationTemplateID' => '<p>Update replication configuration template template ID request.</p>', ], ], 'ReplicationConfigurationTemplateIDs' => [ 'base' => NULL, 'refs' => [ 'DescribeReplicationConfigurationTemplatesRequest$replicationConfigurationTemplateIDs' => '<p>Request to describe Replication Configuration template by template IDs.</p>', ], ], 'ReplicationConfigurationTemplates' => [ 'base' => NULL, 'refs' => [ 'DescribeReplicationConfigurationTemplatesResponse$items' => '<p>Request to describe Replication Configuration template by items.</p>', ], ], 'ReplicationServersSecurityGroupsIDs' => [ 'base' => NULL, 'refs' => [ 'CreateReplicationConfigurationTemplateRequest$replicationServersSecurityGroupsIDs' => '<p>Request to configure the Replication Server Security group ID during Replication Settings template creation.</p>', 'ReplicationConfiguration$replicationServersSecurityGroupsIDs' => '<p>Replication Configuration Replication Server Security Group IDs.</p>', 'ReplicationConfigurationTemplate$replicationServersSecurityGroupsIDs' => '<p>Replication Configuration template server Security Groups IDs.</p>', 'UpdateReplicationConfigurationRequest$replicationServersSecurityGroupsIDs' => '<p>Update replication configuration Replication Server Security Groups IDs request.</p>', 'UpdateReplicationConfigurationTemplateRequest$replicationServersSecurityGroupsIDs' => '<p>Update replication configuration template Replication Server Security groups IDs request.</p>', ], ], 'ReplicationType' => [ 'base' => NULL, 'refs' => [ 'ReplicationTypes$member' => NULL, 'SourceServer$replicationType' => '<p>Source server replication type.</p>', 'UpdateSourceServerReplicationTypeRequest$replicationType' => '<p>Replication type to which to update source server.</p>', ], ], 'ReplicationTypes' => [ 'base' => NULL, 'refs' => [ 'DescribeSourceServersRequestFilters$replicationTypes' => '<p>Request to filter Source Servers list by replication type.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>Resource not found exception.</p>', 'refs' => [], ], 'ResumeReplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'RetryDataReplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'S3BucketName' => [ 'base' => NULL, 'refs' => [ 'ConnectorSsmCommandConfig$outputS3BucketName' => '<p>Connector SSM command config output S3 bucket name.</p>', 'ExportTask$s3Bucket' => '<p>Export task s3 bucket.</p>', 'S3BucketSource$s3Bucket' => '<p>S3 bucket source s3 bucket.</p>', 'StartExportRequest$s3Bucket' => '<p>Start export request s3 bucket.</p>', ], ], 'S3BucketSource' => [ 'base' => '<p>S3 bucket source.</p>', 'refs' => [ 'ImportTask$s3BucketSource' => '<p>Import task s3 bucket source.</p>', 'StartImportRequest$s3BucketSource' => '<p>Start import request s3 bucket source.</p>', ], ], 'S3Key' => [ 'base' => NULL, 'refs' => [ 'ExportTask$s3Key' => '<p>Export task s3 key.</p>', 'S3BucketSource$s3Key' => '<p>S3 bucket source s3 key.</p>', 'StartExportRequest$s3Key' => '<p>Start export request s3key.</p>', ], ], 'S3LogBucketName' => [ 'base' => NULL, 'refs' => [ 'PostLaunchActions$s3LogBucket' => '<p>AWS Systems Manager Command\'s logs S3 log bucket.</p>', ], ], 'SecretArn' => [ 'base' => NULL, 'refs' => [ 'SourceServerConnectorAction$credentialsSecretArn' => '<p>Source Server connector action credentials secret arn.</p>', ], ], 'SecurityGroupID' => [ 'base' => NULL, 'refs' => [ 'ReplicationServersSecurityGroupsIDs$member' => NULL, ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>The request could not be completed because its exceeded the service quota.</p>', 'refs' => [], ], 'SmallBoundedString' => [ 'base' => NULL, 'refs' => [ 'LaunchConfiguration$name' => '<p>Launch configuration name.</p>', 'ReplicationConfiguration$name' => '<p>Replication Configuration name.</p>', 'UpdateLaunchConfigurationRequest$name' => '<p>Update Launch configuration name request.</p>', 'UpdateReplicationConfigurationRequest$name' => '<p>Update replication configuration name request.</p>', ], ], 'SourceProperties' => [ 'base' => '<p>Source server properties.</p>', 'refs' => [ 'SourceServer$sourceProperties' => '<p>Source server properties.</p>', ], ], 'SourceServer' => [ 'base' => NULL, 'refs' => [ 'SourceServersList$member' => NULL, ], ], 'SourceServerActionDocument' => [ 'base' => NULL, 'refs' => [ 'SourceServerActionDocuments$member' => NULL, ], ], 'SourceServerActionDocuments' => [ 'base' => NULL, 'refs' => [ 'ListSourceServerActionsResponse$items' => '<p>List of source server post migration custom actions.</p>', ], ], 'SourceServerActionsRequestFilters' => [ 'base' => '<p>Source server post migration custom action filters.</p>', 'refs' => [ 'ListSourceServerActionsRequest$filters' => '<p>Filters to apply when listing source server post migration custom actions.</p>', ], ], 'SourceServerConnectorAction' => [ 'base' => '<p>Source Server connector action.</p>', 'refs' => [ 'SourceServer$connectorAction' => '<p>Source Server connector action.</p>', 'UpdateSourceServerRequest$connectorAction' => '<p>Update Source Server request connector action.</p>', ], ], 'SourceServerID' => [ 'base' => NULL, 'refs' => [ 'AssociateSourceServersRequestSourceServerIDs$member' => NULL, 'ChangeServerLifeCycleStateRequest$sourceServerID' => '<p>The request to change the source server migration lifecycle state by source server ID.</p>', 'DeleteSourceServerRequest$sourceServerID' => '<p>Request to delete Source Server from service by Server ID.</p>', 'DescribeSourceServersRequestFiltersIDs$member' => NULL, 'DisassociateSourceServersRequestSourceServerIDs$member' => NULL, 'DisconnectFromServiceRequest$sourceServerID' => '<p>Request to disconnect Source Server from service by Server ID.</p>', 'FinalizeCutoverRequest$sourceServerID' => '<p>Request to finalize Cutover by Source Server ID.</p>', 'GetLaunchConfigurationRequest$sourceServerID' => '<p>Request to get Launch Configuration information by Source Server ID.</p>', 'GetReplicationConfigurationRequest$sourceServerID' => '<p>Request to get Replication Configuration by Source Server ID.</p>', 'ImportErrorData$sourceServerID' => '<p>Import error data source server ID.</p>', 'JobLogEventData$sourceServerID' => '<p>Job Event Source Server ID.</p>', 'LaunchConfiguration$sourceServerID' => '<p>Launch configuration Source Server ID.</p>', 'ListSourceServerActionsRequest$sourceServerID' => '<p>Source server ID.</p>', 'MarkAsArchivedRequest$sourceServerID' => '<p>Mark as archived by Source Server ID.</p>', 'ParticipatingServer$sourceServerID' => '<p>Participating server Source Server ID.</p>', 'PauseReplicationRequest$sourceServerID' => '<p>Pause Replication Request source server ID.</p>', 'PutSourceServerActionRequest$sourceServerID' => '<p>Source server ID.</p>', 'RemoveSourceServerActionRequest$sourceServerID' => '<p>Source server ID of the post migration custom action to remove.</p>', 'ReplicationConfiguration$sourceServerID' => '<p>Replication Configuration Source Server ID.</p>', 'ResumeReplicationRequest$sourceServerID' => '<p>Resume Replication Request source server ID.</p>', 'RetryDataReplicationRequest$sourceServerID' => '<p>Retry data replication for Source Server ID.</p>', 'SourceServer$sourceServerID' => '<p>Source server ID.</p>', 'StartCutoverRequestSourceServerIDs$member' => NULL, 'StartReplicationRequest$sourceServerID' => '<p>ID of source server on which to start replication.</p>', 'StartTestRequestSourceServerIDs$member' => NULL, 'StopReplicationRequest$sourceServerID' => '<p>Stop Replication Request source server ID.</p>', 'TerminateTargetInstancesRequestSourceServerIDs$member' => NULL, 'UpdateLaunchConfigurationRequest$sourceServerID' => '<p>Update Launch configuration by Source Server ID request.</p>', 'UpdateReplicationConfigurationRequest$sourceServerID' => '<p>Update replication configuration Source Server ID request.</p>', 'UpdateSourceServerReplicationTypeRequest$sourceServerID' => '<p>ID of source server on which to update replication type.</p>', 'UpdateSourceServerRequest$sourceServerID' => '<p>Update Source Server request source server ID.</p>', ], ], 'SourceServersList' => [ 'base' => NULL, 'refs' => [ 'DescribeSourceServersResponse$items' => '<p>Request to filter Source Servers list by item.</p>', ], ], 'SsmDocument' => [ 'base' => '<p>AWS Systems Manager Document.</p>', 'refs' => [ 'JobPostLaunchActionsLaunchStatus$ssmDocument' => '<p>AWS Systems Manager\'s Document of the of the Job Post Launch Actions.</p>', 'SsmDocuments$member' => NULL, ], ], 'SsmDocumentExternalParameters' => [ 'base' => NULL, 'refs' => [ 'PutSourceServerActionRequest$externalParameters' => '<p>Source server post migration custom action external parameters.</p>', 'PutTemplateActionRequest$externalParameters' => '<p>Template post migration custom action external parameters.</p>', 'SourceServerActionDocument$externalParameters' => '<p>Source server post migration custom action external parameters.</p>', 'SsmDocument$externalParameters' => '<p>AWS Systems Manager Document external parameters.</p>', 'TemplateActionDocument$externalParameters' => '<p>Template post migration custom action external parameters.</p>', ], ], 'SsmDocumentName' => [ 'base' => NULL, 'refs' => [ 'SsmDocument$ssmDocumentName' => '<p>AWS Systems Manager Document name or full ARN.</p>', ], ], 'SsmDocumentParameterName' => [ 'base' => NULL, 'refs' => [ 'SsmDocumentExternalParameters$key' => NULL, 'SsmDocumentParameters$key' => NULL, ], ], 'SsmDocumentParameters' => [ 'base' => NULL, 'refs' => [ 'PutSourceServerActionRequest$parameters' => '<p>Source server post migration custom action parameters.</p>', 'PutTemplateActionRequest$parameters' => '<p>Template post migration custom action parameters.</p>', 'SourceServerActionDocument$parameters' => '<p>Source server post migration custom action parameters.</p>', 'SsmDocument$parameters' => '<p>AWS Systems Manager Document parameters.</p>', 'TemplateActionDocument$parameters' => '<p>Template post migration custom action parameters.</p>', ], ], 'SsmDocumentType' => [ 'base' => NULL, 'refs' => [ 'JobPostLaunchActionsLaunchStatus$ssmDocumentType' => '<p>AWS Systems Manager Document type.</p>', ], ], 'SsmDocuments' => [ 'base' => NULL, 'refs' => [ 'PostLaunchActions$ssmDocuments' => '<p>AWS Systems Manager Documents.</p>', ], ], 'SsmExternalParameter' => [ 'base' => '<p>AWS Systems Manager Document external parameter.</p>', 'refs' => [ 'SsmDocumentExternalParameters$value' => NULL, ], ], 'SsmInstanceID' => [ 'base' => NULL, 'refs' => [ 'Connector$ssmInstanceID' => '<p>Connector SSM instance ID.</p>', 'CreateConnectorRequest$ssmInstanceID' => '<p>Create Connector request SSM instance ID.</p>', ], ], 'SsmParameterStoreParameter' => [ 'base' => '<p>AWS Systems Manager Parameter Store parameter.</p>', 'refs' => [ 'SsmParameterStoreParameters$member' => NULL, ], ], 'SsmParameterStoreParameterName' => [ 'base' => NULL, 'refs' => [ 'SsmParameterStoreParameter$parameterName' => '<p>AWS Systems Manager Parameter Store parameter name.</p>', ], ], 'SsmParameterStoreParameterType' => [ 'base' => NULL, 'refs' => [ 'SsmParameterStoreParameter$parameterType' => '<p>AWS Systems Manager Parameter Store parameter type.</p>', ], ], 'SsmParameterStoreParameters' => [ 'base' => NULL, 'refs' => [ 'SsmDocumentParameters$value' => NULL, ], ], 'StartCutoverRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartCutoverRequestSourceServerIDs' => [ 'base' => NULL, 'refs' => [ 'StartCutoverRequest$sourceServerIDs' => '<p>Start Cutover by Source Server IDs.</p>', ], ], 'StartCutoverResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartExportRequest' => [ 'base' => '<p>Start export request.</p>', 'refs' => [], ], 'StartExportResponse' => [ 'base' => '<p>Start export response.</p>', 'refs' => [], ], 'StartImportRequest' => [ 'base' => '<p>Start import request.</p>', 'refs' => [], ], 'StartImportResponse' => [ 'base' => '<p>Start import response.</p>', 'refs' => [], ], 'StartReplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartTestRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartTestRequestSourceServerIDs' => [ 'base' => NULL, 'refs' => [ 'StartTestRequest$sourceServerIDs' => '<p>Start Test for Source Server IDs.</p>', ], ], 'StartTestResponse' => [ 'base' => NULL, 'refs' => [], ], 'StopReplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'StrictlyPositiveInteger' => [ 'base' => NULL, 'refs' => [ 'PutSourceServerActionRequest$timeoutSeconds' => '<p>Source server post migration custom action timeout in seconds.</p>', 'PutTemplateActionRequest$timeoutSeconds' => '<p>Template post migration custom action timeout in seconds.</p>', 'ServiceQuotaExceededException$quotaValue' => '<p>Exceeded the service quota value.</p>', 'SourceServerActionDocument$timeoutSeconds' => '<p>Source server post migration custom action timeout in seconds.</p>', 'SsmDocument$timeoutSeconds' => '<p>AWS Systems Manager Document timeout seconds.</p>', 'TemplateActionDocument$timeoutSeconds' => '<p>Template post migration custom action timeout in seconds.</p>', ], ], 'SubnetID' => [ 'base' => NULL, 'refs' => [ 'CreateReplicationConfigurationTemplateRequest$stagingAreaSubnetId' => '<p>Request to configure the Staging Area subnet ID during Replication Settings template creation.</p>', 'ReplicationConfiguration$stagingAreaSubnetId' => '<p>Replication Configuration Staging Area subnet ID.</p>', 'ReplicationConfigurationTemplate$stagingAreaSubnetId' => '<p>Replication Configuration template Staging Area subnet ID.</p>', 'UpdateReplicationConfigurationRequest$stagingAreaSubnetId' => '<p>Update replication configuration Staging Area subnet request.</p>', 'UpdateReplicationConfigurationTemplateRequest$stagingAreaSubnetId' => '<p>Update replication configuration template Staging Area subnet ID request.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeys$member' => NULL, 'TagsMap$key' => NULL, ], ], 'TagKeys' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>Untag resource by Keys.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'CreateLaunchConfigurationTemplateRequest$mapAutoTaggingMpeID' => '<p>Launch configuration template map auto tagging MPE ID.</p>', 'LaunchConfiguration$mapAutoTaggingMpeID' => '<p>Map auto tagging MPE ID.</p>', 'LaunchConfigurationTemplate$mapAutoTaggingMpeID' => '<p>Launch configuration template map auto tagging MPE ID.</p>', 'TagsMap$value' => NULL, 'UpdateLaunchConfigurationRequest$mapAutoTaggingMpeID' => '<p>Launch configuration map auto tagging MPE ID.</p>', 'UpdateLaunchConfigurationTemplateRequest$mapAutoTaggingMpeID' => '<p>Launch configuration template map auto tagging MPE ID.</p>', ], ], 'TagsMap' => [ 'base' => NULL, 'refs' => [ 'Application$tags' => '<p>Application tags.</p>', 'Connector$tags' => '<p>Connector tags.</p>', 'CreateApplicationRequest$tags' => '<p>Application tags.</p>', 'CreateConnectorRequest$tags' => '<p>Create Connector request tags.</p>', 'CreateLaunchConfigurationTemplateRequest$tags' => '<p>Request to associate tags during creation of a Launch Configuration Template.</p>', 'CreateReplicationConfigurationTemplateRequest$stagingAreaTags' => '<p>Request to configure Staging Area tags during Replication Settings template creation.</p>', 'CreateReplicationConfigurationTemplateRequest$tags' => '<p>Request to configure tags during Replication Settings template creation.</p>', 'CreateWaveRequest$tags' => '<p>Wave tags.</p>', 'Job$tags' => '<p>Tags associated with specific Job.</p>', 'LaunchConfigurationTemplate$tags' => '<p>Tags of the Launch Configuration Template.</p>', 'ListTagsForResourceResponse$tags' => '<p>List tags for resource response.</p>', 'ReplicationConfiguration$stagingAreaTags' => '<p>Replication Configuration Staging Area tags.</p>', 'ReplicationConfigurationTemplate$stagingAreaTags' => '<p>Replication Configuration template Staging Area Tags.</p>', 'ReplicationConfigurationTemplate$tags' => '<p>Replication Configuration template Tags.</p>', 'SourceServer$tags' => '<p>Source server Tags.</p>', 'StartCutoverRequest$tags' => '<p>Start Cutover by Tags.</p>', 'StartTestRequest$tags' => '<p>Start Test by Tags.</p>', 'TagResourceRequest$tags' => '<p>Tag resource by Tags.</p>', 'TerminateTargetInstancesRequest$tags' => '<p>Terminate Target instance by Tags.</p>', 'UpdateReplicationConfigurationRequest$stagingAreaTags' => '<p>Update replication configuration Staging Area Tags request.</p>', 'UpdateReplicationConfigurationTemplateRequest$stagingAreaTags' => '<p>Update replication configuration template Staging Area Tags request.</p>', 'VcenterClient$sourceServerTags' => '<p>Tags for Source Server of vCenter client.</p>', 'VcenterClient$tags' => '<p>Tags for vCenter client.</p>', 'Wave$tags' => '<p>Wave tags.</p>', ], ], 'TargetInstanceTypeRightSizingMethod' => [ 'base' => NULL, 'refs' => [ 'CreateLaunchConfigurationTemplateRequest$targetInstanceTypeRightSizingMethod' => '<p>Target instance type right-sizing method.</p>', 'LaunchConfiguration$targetInstanceTypeRightSizingMethod' => '<p>Launch configuration Target instance type right sizing method.</p>', 'LaunchConfigurationTemplate$targetInstanceTypeRightSizingMethod' => '<p>Target instance type right-sizing method.</p>', 'UpdateLaunchConfigurationRequest$targetInstanceTypeRightSizingMethod' => '<p>Update Launch configuration Target instance right sizing request.</p>', 'UpdateLaunchConfigurationTemplateRequest$targetInstanceTypeRightSizingMethod' => '<p>Target instance type right-sizing method.</p>', ], ], 'TemplateActionDocument' => [ 'base' => NULL, 'refs' => [ 'TemplateActionDocuments$member' => NULL, ], ], 'TemplateActionDocuments' => [ 'base' => NULL, 'refs' => [ 'ListTemplateActionsResponse$items' => '<p>List of template post migration custom actions.</p>', ], ], 'TemplateActionsRequestFilters' => [ 'base' => '<p>Template post migration custom action filters.</p>', 'refs' => [ 'ListTemplateActionsRequest$filters' => '<p>Filters to apply when listing template post migration custom actions.</p>', ], ], 'TerminateTargetInstancesRequest' => [ 'base' => NULL, 'refs' => [], ], 'TerminateTargetInstancesRequestSourceServerIDs' => [ 'base' => NULL, 'refs' => [ 'TerminateTargetInstancesRequest$sourceServerIDs' => '<p>Terminate Target instance by Source Server IDs.</p>', ], ], 'TerminateTargetInstancesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ThrottlingException' => [ 'base' => '<p>Reached throttling quota exception.</p>', 'refs' => [], ], 'Throughput' => [ 'base' => NULL, 'refs' => [ 'LaunchTemplateDiskConf$throughput' => '<p>Launch template disk throughput configuration.</p>', ], ], 'UnarchiveApplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UnarchiveWaveRequest' => [ 'base' => NULL, 'refs' => [], ], 'UninitializedAccountException' => [ 'base' => '<p>Uninitialized account exception.</p>', 'refs' => [], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateApplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateConnectorRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLaunchConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLaunchConfigurationTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateReplicationConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateReplicationConfigurationTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSourceServerReplicationTypeRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSourceServerRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWaveRequest' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>Validate exception.</p>', 'refs' => [], ], 'ValidationExceptionField' => [ 'base' => '<p>Validate exception field.</p>', 'refs' => [ 'ValidationExceptionFieldList$member' => NULL, ], ], 'ValidationExceptionFieldList' => [ 'base' => NULL, 'refs' => [ 'ValidationException$fieldList' => '<p>Validate exception field list.</p>', ], ], 'ValidationExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ValidationException$reason' => '<p>Validate exception reason.</p>', ], ], 'VcenterClient' => [ 'base' => '<p>vCenter client.</p>', 'refs' => [ 'VcenterClientList$member' => NULL, ], ], 'VcenterClientID' => [ 'base' => NULL, 'refs' => [ 'DeleteVcenterClientRequest$vcenterClientID' => '<p>ID of resource to be deleted.</p>', 'SourceServer$vcenterClientID' => '<p>Source server vCenter client id.</p>', 'VcenterClient$vcenterClientID' => '<p>ID of vCenter client.</p>', ], ], 'VcenterClientList' => [ 'base' => NULL, 'refs' => [ 'DescribeVcenterClientsResponse$items' => '<p>List of items returned by DescribeVcenterClients.</p>', ], ], 'VolumeType' => [ 'base' => NULL, 'refs' => [ 'LaunchTemplateDiskConf$volumeType' => '<p>Launch template disk volume type configuration.</p>', ], ], 'Wave' => [ 'base' => NULL, 'refs' => [ 'WavesList$member' => NULL, ], ], 'WaveAggregatedStatus' => [ 'base' => '<p>Wave aggregated status.</p>', 'refs' => [ 'Wave$waveAggregatedStatus' => '<p>Wave aggregated status.</p>', ], ], 'WaveDescription' => [ 'base' => NULL, 'refs' => [ 'CreateWaveRequest$description' => '<p>Wave description.</p>', 'UpdateWaveRequest$description' => '<p>Wave description.</p>', 'Wave$description' => '<p>Wave description.</p>', ], ], 'WaveHealthStatus' => [ 'base' => NULL, 'refs' => [ 'WaveAggregatedStatus$healthStatus' => '<p>Wave aggregated status health status.</p>', ], ], 'WaveID' => [ 'base' => NULL, 'refs' => [ 'Application$waveID' => '<p>Application wave ID.</p>', 'ArchiveWaveRequest$waveID' => '<p>Wave ID.</p>', 'AssociateApplicationsRequest$waveID' => '<p>Wave ID.</p>', 'DeleteWaveRequest$waveID' => '<p>Wave ID.</p>', 'DisassociateApplicationsRequest$waveID' => '<p>Wave ID.</p>', 'ImportErrorData$waveID' => '<p>Import error data wave id.</p>', 'UnarchiveWaveRequest$waveID' => '<p>Wave ID.</p>', 'UpdateWaveRequest$waveID' => '<p>Wave ID.</p>', 'Wave$waveID' => '<p>Wave ID.</p>', 'WaveIDsFilter$member' => NULL, ], ], 'WaveIDsFilter' => [ 'base' => NULL, 'refs' => [ 'ListApplicationsRequestFilters$waveIDs' => '<p>Filter applications list by wave ID.</p>', 'ListWavesRequestFilters$waveIDs' => '<p>Filter waves list by wave ID.</p>', ], ], 'WaveName' => [ 'base' => NULL, 'refs' => [ 'CreateWaveRequest$name' => '<p>Wave name.</p>', 'UpdateWaveRequest$name' => '<p>Wave name.</p>', 'Wave$name' => '<p>Wave name.</p>', ], ], 'WaveProgressStatus' => [ 'base' => NULL, 'refs' => [ 'WaveAggregatedStatus$progressStatus' => '<p>Wave aggregated status progress status.</p>', ], ], 'WavesList' => [ 'base' => NULL, 'refs' => [ 'ListWavesResponse$items' => '<p>Waves list.</p>', ], ], ],];
