<?php
// This file was auto-generated from sdk-root/src/data/neptune/2014-10-31/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Amazon Neptune</fullname> <p>Amazon Neptune is a fast, reliable, fully-managed graph database service that makes it easy to build and run applications that work with highly connected datasets. The core of Amazon Neptune is a purpose-built, high-performance graph database engine optimized for storing billions of relationships and querying the graph with milliseconds latency. Amazon Neptune supports popular graph models Property Graph and W3C\'s RDF, and their respective query languages Apache TinkerPop Gremlin and SPARQL, allowing you to easily build queries that efficiently navigate highly connected datasets. Neptune powers graph use cases such as recommendation engines, fraud detection, knowledge graphs, drug discovery, and network security.</p> <p>This interface reference for Amazon Neptune contains documentation for a programming or command line interface you can use to manage Amazon Neptune. Note that Amazon Neptune is asynchronous, which means that some interfaces might require techniques such as polling or callback functions to determine when a command has been applied. In this reference, the parameter descriptions indicate whether a command is applied immediately, on the next instance reboot, or during the maintenance window. The reference structure is as follows, and we list following some related topics from the user guide.</p>', 'operations' => [ 'AddRoleToDBCluster' => '<p>Associates an Identity and Access Management (IAM) role with an Neptune DB cluster.</p>', 'AddSourceIdentifierToSubscription' => '<p>Adds a source identifier to an existing event notification subscription.</p>', 'AddTagsToResource' => '<p>Adds metadata tags to an Amazon Neptune resource. These tags can also be used with cost allocation reporting to track cost associated with Amazon Neptune resources, or used in a Condition statement in an IAM policy for Amazon Neptune.</p>', 'ApplyPendingMaintenanceAction' => '<p>Applies a pending maintenance action to a resource (for example, to a DB instance).</p>', 'CopyDBClusterParameterGroup' => '<p>Copies the specified DB cluster parameter group.</p>', 'CopyDBClusterSnapshot' => '<p>Copies a snapshot of a DB cluster.</p> <p>To copy a DB cluster snapshot from a shared manual DB cluster snapshot, <code>SourceDBClusterSnapshotIdentifier</code> must be the Amazon Resource Name (ARN) of the shared DB cluster snapshot.</p>', 'CopyDBParameterGroup' => '<p>Copies the specified DB parameter group.</p>', 'CreateDBCluster' => '<p>Creates a new Amazon Neptune DB cluster.</p> <p>You can use the <code>ReplicationSourceIdentifier</code> parameter to create the DB cluster as a Read Replica of another DB cluster or Amazon Neptune DB instance.</p> <p>Note that when you create a new cluster using <code>CreateDBCluster</code> directly, deletion protection is disabled by default (when you create a new production cluster in the console, deletion protection is enabled by default). You can only delete a DB cluster if its <code>DeletionProtection</code> field is set to <code>false</code>.</p>', 'CreateDBClusterEndpoint' => '<p>Creates a new custom endpoint and associates it with an Amazon Neptune DB cluster.</p>', 'CreateDBClusterParameterGroup' => '<p>Creates a new DB cluster parameter group.</p> <p>Parameters in a DB cluster parameter group apply to all of the instances in a DB cluster.</p> <p> A DB cluster parameter group is initially created with the default parameters for the database engine used by instances in the DB cluster. To provide custom values for any of the parameters, you must modify the group after creating it using <a>ModifyDBClusterParameterGroup</a>. Once you\'ve created a DB cluster parameter group, you need to associate it with your DB cluster using <a>ModifyDBCluster</a>. When you associate a new DB cluster parameter group with a running DB cluster, you need to reboot the DB instances in the DB cluster without failover for the new DB cluster parameter group and associated settings to take effect.</p> <important> <p>After you create a DB cluster parameter group, you should wait at least 5 minutes before creating your first DB cluster that uses that DB cluster parameter group as the default parameter group. This allows Amazon Neptune to fully complete the create action before the DB cluster parameter group is used as the default for a new DB cluster. This is especially important for parameters that are critical when creating the default database for a DB cluster, such as the character set for the default database defined by the <code>character_set_database</code> parameter. You can use the <i>Parameter Groups</i> option of the <a href="https://console.aws.amazon.com/rds/">Amazon Neptune console</a> or the <a>DescribeDBClusterParameters</a> command to verify that your DB cluster parameter group has been created or modified.</p> </important>', 'CreateDBClusterSnapshot' => '<p>Creates a snapshot of a DB cluster.</p>', 'CreateDBInstance' => '<p>Creates a new DB instance.</p>', 'CreateDBParameterGroup' => '<p>Creates a new DB parameter group.</p> <p>A DB parameter group is initially created with the default parameters for the database engine used by the DB instance. To provide custom values for any of the parameters, you must modify the group after creating it using <i>ModifyDBParameterGroup</i>. Once you\'ve created a DB parameter group, you need to associate it with your DB instance using <i>ModifyDBInstance</i>. When you associate a new DB parameter group with a running DB instance, you need to reboot the DB instance without failover for the new DB parameter group and associated settings to take effect.</p> <important> <p>After you create a DB parameter group, you should wait at least 5 minutes before creating your first DB instance that uses that DB parameter group as the default parameter group. This allows Amazon Neptune to fully complete the create action before the parameter group is used as the default for a new DB instance. This is especially important for parameters that are critical when creating the default database for a DB instance, such as the character set for the default database defined by the <code>character_set_database</code> parameter. You can use the <i>Parameter Groups</i> option of the Amazon Neptune console or the <i>DescribeDBParameters</i> command to verify that your DB parameter group has been created or modified.</p> </important>', 'CreateDBSubnetGroup' => '<p>Creates a new DB subnet group. DB subnet groups must contain at least one subnet in at least two AZs in the Amazon Region.</p>', 'CreateEventSubscription' => '<p>Creates an event notification subscription. This action requires a topic ARN (Amazon Resource Name) created by either the Neptune console, the SNS console, or the SNS API. To obtain an ARN with SNS, you must create a topic in Amazon SNS and subscribe to the topic. The ARN is displayed in the SNS console.</p> <p>You can specify the type of source (SourceType) you want to be notified of, provide a list of Neptune sources (SourceIds) that triggers the events, and provide a list of event categories (EventCategories) for events you want to be notified of. For example, you can specify SourceType = db-instance, SourceIds = mydbinstance1, mydbinstance2 and EventCategories = Availability, Backup.</p> <p>If you specify both the SourceType and SourceIds, such as SourceType = db-instance and SourceIdentifier = myDBInstance1, you are notified of all the db-instance events for the specified source. If you specify a SourceType but do not specify a SourceIdentifier, you receive notice of the events for that source type for all your Neptune sources. If you do not specify either the SourceType nor the SourceIdentifier, you are notified of events generated from all Neptune sources belonging to your customer account.</p>', 'CreateGlobalCluster' => '<p>Creates a Neptune global database spread across multiple Amazon Regions. The global database contains a single primary cluster with read-write capability, and read-only secondary clusters that receive data from the primary cluster through high-speed replication performed by the Neptune storage subsystem.</p> <p>You can create a global database that is initially empty, and then add a primary cluster and secondary clusters to it, or you can specify an existing Neptune cluster during the create operation to become the primary cluster of the global database.</p>', 'DeleteDBCluster' => '<p>The DeleteDBCluster action deletes a previously provisioned DB cluster. When you delete a DB cluster, all automated backups for that DB cluster are deleted and can\'t be recovered. Manual DB cluster snapshots of the specified DB cluster are not deleted.</p> <p>Note that the DB Cluster cannot be deleted if deletion protection is enabled. To delete it, you must first set its <code>DeletionProtection</code> field to <code>False</code>.</p>', 'DeleteDBClusterEndpoint' => '<p>Deletes a custom endpoint and removes it from an Amazon Neptune DB cluster.</p>', 'DeleteDBClusterParameterGroup' => '<p>Deletes a specified DB cluster parameter group. The DB cluster parameter group to be deleted can\'t be associated with any DB clusters.</p>', 'DeleteDBClusterSnapshot' => '<p>Deletes a DB cluster snapshot. If the snapshot is being copied, the copy operation is terminated.</p> <note> <p>The DB cluster snapshot must be in the <code>available</code> state to be deleted.</p> </note>', 'DeleteDBInstance' => '<p>The DeleteDBInstance action deletes a previously provisioned DB instance. When you delete a DB instance, all automated backups for that instance are deleted and can\'t be recovered. Manual DB snapshots of the DB instance to be deleted by <code>DeleteDBInstance</code> are not deleted.</p> <p> If you request a final DB snapshot the status of the Amazon Neptune DB instance is <code>deleting</code> until the DB snapshot is created. The API action <code>DescribeDBInstance</code> is used to monitor the status of this operation. The action can\'t be canceled or reverted once submitted.</p> <p>Note that when a DB instance is in a failure state and has a status of <code>failed</code>, <code>incompatible-restore</code>, or <code>incompatible-network</code>, you can only delete it when the <code>SkipFinalSnapshot</code> parameter is set to <code>true</code>.</p> <p>You can\'t delete a DB instance if it is the only instance in the DB cluster, or if it has deletion protection enabled.</p>', 'DeleteDBParameterGroup' => '<p>Deletes a specified DBParameterGroup. The DBParameterGroup to be deleted can\'t be associated with any DB instances.</p>', 'DeleteDBSubnetGroup' => '<p>Deletes a DB subnet group.</p> <note> <p>The specified database subnet group must not be associated with any DB instances.</p> </note>', 'DeleteEventSubscription' => '<p>Deletes an event notification subscription.</p>', 'DeleteGlobalCluster' => '<p>Deletes a global database. The primary and all secondary clusters must already be detached or deleted first.</p>', 'DescribeDBClusterEndpoints' => '<p>Returns information about endpoints for an Amazon Neptune DB cluster.</p> <note> <p>This operation can also return information for Amazon RDS clusters and Amazon DocDB clusters.</p> </note>', 'DescribeDBClusterParameterGroups' => '<p> Returns a list of <code>DBClusterParameterGroup</code> descriptions. If a <code>DBClusterParameterGroupName</code> parameter is specified, the list will contain only the description of the specified DB cluster parameter group.</p>', 'DescribeDBClusterParameters' => '<p>Returns the detailed parameter list for a particular DB cluster parameter group.</p>', 'DescribeDBClusterSnapshotAttributes' => '<p>Returns a list of DB cluster snapshot attribute names and values for a manual DB cluster snapshot.</p> <p>When sharing snapshots with other Amazon accounts, <code>DescribeDBClusterSnapshotAttributes</code> returns the <code>restore</code> attribute and a list of IDs for the Amazon accounts that are authorized to copy or restore the manual DB cluster snapshot. If <code>all</code> is included in the list of values for the <code>restore</code> attribute, then the manual DB cluster snapshot is public and can be copied or restored by all Amazon accounts.</p> <p>To add or remove access for an Amazon account to copy or restore a manual DB cluster snapshot, or to make the manual DB cluster snapshot public or private, use the <a>ModifyDBClusterSnapshotAttribute</a> API action.</p>', 'DescribeDBClusterSnapshots' => '<p>Returns information about DB cluster snapshots. This API action supports pagination.</p>', 'DescribeDBClusters' => '<p>Returns information about provisioned DB clusters, and supports pagination.</p> <note> <p>This operation can also return information for Amazon RDS clusters and Amazon DocDB clusters.</p> </note>', 'DescribeDBEngineVersions' => '<p>Returns a list of the available DB engines.</p>', 'DescribeDBInstances' => '<p>Returns information about provisioned instances, and supports pagination.</p> <note> <p>This operation can also return information for Amazon RDS instances and Amazon DocDB instances.</p> </note>', 'DescribeDBParameterGroups' => '<p>Returns a list of <code>DBParameterGroup</code> descriptions. If a <code>DBParameterGroupName</code> is specified, the list will contain only the description of the specified DB parameter group.</p>', 'DescribeDBParameters' => '<p>Returns the detailed parameter list for a particular DB parameter group.</p>', 'DescribeDBSubnetGroups' => '<p>Returns a list of DBSubnetGroup descriptions. If a DBSubnetGroupName is specified, the list will contain only the descriptions of the specified DBSubnetGroup.</p> <p>For an overview of CIDR ranges, go to the <a href="http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Wikipedia Tutorial</a>.</p>', 'DescribeEngineDefaultClusterParameters' => '<p>Returns the default engine and system parameter information for the cluster database engine.</p>', 'DescribeEngineDefaultParameters' => '<p>Returns the default engine and system parameter information for the specified database engine.</p>', 'DescribeEventCategories' => '<p>Displays a list of categories for all event source types, or, if specified, for a specified source type.</p>', 'DescribeEventSubscriptions' => '<p>Lists all the subscription descriptions for a customer account. The description for a subscription includes SubscriptionName, SNSTopicARN, CustomerID, SourceType, SourceID, CreationTime, and Status.</p> <p>If you specify a SubscriptionName, lists the description for that subscription.</p>', 'DescribeEvents' => '<p>Returns events related to DB instances, DB security groups, DB snapshots, and DB parameter groups for the past 14 days. Events specific to a particular DB instance, DB security group, database snapshot, or DB parameter group can be obtained by providing the name as a parameter. By default, the past hour of events are returned.</p>', 'DescribeGlobalClusters' => '<p>Returns information about Neptune global database clusters. This API supports pagination.</p>', 'DescribeOrderableDBInstanceOptions' => '<p>Returns a list of orderable DB instance options for the specified engine.</p>', 'DescribePendingMaintenanceActions' => '<p>Returns a list of resources (for example, DB instances) that have at least one pending maintenance action.</p>', 'DescribeValidDBInstanceModifications' => '<p>You can call <a>DescribeValidDBInstanceModifications</a> to learn what modifications you can make to your DB instance. You can use this information when you call <a>ModifyDBInstance</a>.</p>', 'FailoverDBCluster' => '<p>Forces a failover for a DB cluster.</p> <p>A failover for a DB cluster promotes one of the Read Replicas (read-only instances) in the DB cluster to be the primary instance (the cluster writer).</p> <p>Amazon Neptune will automatically fail over to a Read Replica, if one exists, when the primary instance fails. You can force a failover when you want to simulate a failure of a primary instance for testing. Because each instance in a DB cluster has its own endpoint address, you will need to clean up and re-establish any existing connections that use those endpoint addresses when the failover is complete.</p>', 'FailoverGlobalCluster' => '<p>Initiates the failover process for a Neptune global database.</p> <p>A failover for a Neptune global database promotes one of secondary read-only DB clusters to be the primary DB cluster and demotes the primary DB cluster to being a secondary (read-only) DB cluster. In other words, the role of the current primary DB cluster and the selected target secondary DB cluster are switched. The selected secondary DB cluster assumes full read/write capabilities for the Neptune global database.</p> <note> <p>This action applies <b>only</b> to Neptune global databases. This action is only intended for use on healthy Neptune global databases with healthy Neptune DB clusters and no region-wide outages, to test disaster recovery scenarios or to reconfigure the global database topology.</p> </note>', 'ListTagsForResource' => '<p>Lists all tags on an Amazon Neptune resource.</p>', 'ModifyDBCluster' => '<p>Modify a setting for a DB cluster. You can change one or more database configuration parameters by specifying these parameters and the new values in the request.</p>', 'ModifyDBClusterEndpoint' => '<p>Modifies the properties of an endpoint in an Amazon Neptune DB cluster.</p>', 'ModifyDBClusterParameterGroup' => '<p> Modifies the parameters of a DB cluster parameter group. To modify more than one parameter, submit a list of the following: <code>ParameterName</code>, <code>ParameterValue</code>, and <code>ApplyMethod</code>. A maximum of 20 parameters can be modified in a single request.</p> <note> <p>Changes to dynamic parameters are applied immediately. Changes to static parameters require a reboot without failover to the DB cluster associated with the parameter group before the change can take effect.</p> </note> <important> <p>After you create a DB cluster parameter group, you should wait at least 5 minutes before creating your first DB cluster that uses that DB cluster parameter group as the default parameter group. This allows Amazon Neptune to fully complete the create action before the parameter group is used as the default for a new DB cluster. This is especially important for parameters that are critical when creating the default database for a DB cluster, such as the character set for the default database defined by the <code>character_set_database</code> parameter. You can use the <i>Parameter Groups</i> option of the Amazon Neptune console or the <a>DescribeDBClusterParameters</a> command to verify that your DB cluster parameter group has been created or modified.</p> </important>', 'ModifyDBClusterSnapshotAttribute' => '<p>Adds an attribute and values to, or removes an attribute and values from, a manual DB cluster snapshot.</p> <p>To share a manual DB cluster snapshot with other Amazon accounts, specify <code>restore</code> as the <code>AttributeName</code> and use the <code>ValuesToAdd</code> parameter to add a list of IDs of the Amazon accounts that are authorized to restore the manual DB cluster snapshot. Use the value <code>all</code> to make the manual DB cluster snapshot public, which means that it can be copied or restored by all Amazon accounts. Do not add the <code>all</code> value for any manual DB cluster snapshots that contain private information that you don\'t want available to all Amazon accounts. If a manual DB cluster snapshot is encrypted, it can be shared, but only by specifying a list of authorized Amazon account IDs for the <code>ValuesToAdd</code> parameter. You can\'t use <code>all</code> as a value for that parameter in this case.</p> <p>To view which Amazon accounts have access to copy or restore a manual DB cluster snapshot, or whether a manual DB cluster snapshot public or private, use the <a>DescribeDBClusterSnapshotAttributes</a> API action.</p>', 'ModifyDBInstance' => '<p>Modifies settings for a DB instance. You can change one or more database configuration parameters by specifying these parameters and the new values in the request. To learn what modifications you can make to your DB instance, call <a>DescribeValidDBInstanceModifications</a> before you call <a>ModifyDBInstance</a>.</p>', 'ModifyDBParameterGroup' => '<p>Modifies the parameters of a DB parameter group. To modify more than one parameter, submit a list of the following: <code>ParameterName</code>, <code>ParameterValue</code>, and <code>ApplyMethod</code>. A maximum of 20 parameters can be modified in a single request.</p> <note> <p>Changes to dynamic parameters are applied immediately. Changes to static parameters require a reboot without failover to the DB instance associated with the parameter group before the change can take effect.</p> </note> <important> <p>After you modify a DB parameter group, you should wait at least 5 minutes before creating your first DB instance that uses that DB parameter group as the default parameter group. This allows Amazon Neptune to fully complete the modify action before the parameter group is used as the default for a new DB instance. This is especially important for parameters that are critical when creating the default database for a DB instance, such as the character set for the default database defined by the <code>character_set_database</code> parameter. You can use the <i>Parameter Groups</i> option of the Amazon Neptune console or the <i>DescribeDBParameters</i> command to verify that your DB parameter group has been created or modified.</p> </important>', 'ModifyDBSubnetGroup' => '<p>Modifies an existing DB subnet group. DB subnet groups must contain at least one subnet in at least two AZs in the Amazon Region.</p>', 'ModifyEventSubscription' => '<p>Modifies an existing event notification subscription. Note that you can\'t modify the source identifiers using this call; to change source identifiers for a subscription, use the <a>AddSourceIdentifierToSubscription</a> and <a>RemoveSourceIdentifierFromSubscription</a> calls.</p> <p>You can see a list of the event categories for a given SourceType by using the <b>DescribeEventCategories</b> action.</p>', 'ModifyGlobalCluster' => '<p>Modify a setting for an Amazon Neptune global cluster. You can change one or more database configuration parameters by specifying these parameters and their new values in the request.</p>', 'PromoteReadReplicaDBCluster' => '<p>Not supported.</p>', 'RebootDBInstance' => '<p>You might need to reboot your DB instance, usually for maintenance reasons. For example, if you make certain modifications, or if you change the DB parameter group associated with the DB instance, you must reboot the instance for the changes to take effect.</p> <p>Rebooting a DB instance restarts the database engine service. Rebooting a DB instance results in a momentary outage, during which the DB instance status is set to rebooting.</p>', 'RemoveFromGlobalCluster' => '<p>Detaches a Neptune DB cluster from a Neptune global database. A secondary cluster becomes a normal standalone cluster with read-write capability instead of being read-only, and no longer receives data from a the primary cluster.</p>', 'RemoveRoleFromDBCluster' => '<p>Disassociates an Identity and Access Management (IAM) role from a DB cluster.</p>', 'RemoveSourceIdentifierFromSubscription' => '<p>Removes a source identifier from an existing event notification subscription.</p>', 'RemoveTagsFromResource' => '<p>Removes metadata tags from an Amazon Neptune resource.</p>', 'ResetDBClusterParameterGroup' => '<p> Modifies the parameters of a DB cluster parameter group to the default value. To reset specific parameters submit a list of the following: <code>ParameterName</code> and <code>ApplyMethod</code>. To reset the entire DB cluster parameter group, specify the <code>DBClusterParameterGroupName</code> and <code>ResetAllParameters</code> parameters.</p> <p> When resetting the entire group, dynamic parameters are updated immediately and static parameters are set to <code>pending-reboot</code> to take effect on the next DB instance restart or <a>RebootDBInstance</a> request. You must call <a>RebootDBInstance</a> for every DB instance in your DB cluster that you want the updated static parameter to apply to.</p>', 'ResetDBParameterGroup' => '<p>Modifies the parameters of a DB parameter group to the engine/system default value. To reset specific parameters, provide a list of the following: <code>ParameterName</code> and <code>ApplyMethod</code>. To reset the entire DB parameter group, specify the <code>DBParameterGroup</code> name and <code>ResetAllParameters</code> parameters. When resetting the entire group, dynamic parameters are updated immediately and static parameters are set to <code>pending-reboot</code> to take effect on the next DB instance restart or <code>RebootDBInstance</code> request.</p>', 'RestoreDBClusterFromSnapshot' => '<p>Creates a new DB cluster from a DB snapshot or DB cluster snapshot.</p> <p>If a DB snapshot is specified, the target DB cluster is created from the source DB snapshot with a default configuration and default security group.</p> <p>If a DB cluster snapshot is specified, the target DB cluster is created from the source DB cluster restore point with the same configuration as the original source DB cluster, except that the new DB cluster is created with the default security group.</p>', 'RestoreDBClusterToPointInTime' => '<p>Restores a DB cluster to an arbitrary point in time. Users can restore to any point in time before <code>LatestRestorableTime</code> for up to <code>BackupRetentionPeriod</code> days. The target DB cluster is created from the source DB cluster with the same configuration as the original DB cluster, except that the new DB cluster is created with the default DB security group.</p> <note> <p>This action only restores the DB cluster, not the DB instances for that DB cluster. You must invoke the <a>CreateDBInstance</a> action to create DB instances for the restored DB cluster, specifying the identifier of the restored DB cluster in <code>DBClusterIdentifier</code>. You can create DB instances only after the <code>RestoreDBClusterToPointInTime</code> action has completed and the DB cluster is available.</p> </note>', 'StartDBCluster' => '<p>Starts an Amazon Neptune DB cluster that was stopped using the Amazon console, the Amazon CLI stop-db-cluster command, or the StopDBCluster API.</p>', 'StopDBCluster' => '<p>Stops an Amazon Neptune DB cluster. When you stop a DB cluster, Neptune retains the DB cluster\'s metadata, including its endpoints and DB parameter groups.</p> <p>Neptune also retains the transaction logs so you can do a point-in-time restore if necessary.</p>', ], 'shapes' => [ 'AddRoleToDBClusterMessage' => [ 'base' => NULL, 'refs' => [], ], 'AddSourceIdentifierToSubscriptionMessage' => [ 'base' => NULL, 'refs' => [], ], 'AddSourceIdentifierToSubscriptionResult' => [ 'base' => NULL, 'refs' => [], ], 'AddTagsToResourceMessage' => [ 'base' => NULL, 'refs' => [], ], 'ApplyMethod' => [ 'base' => NULL, 'refs' => [ 'Parameter$ApplyMethod' => '<p>Indicates when to apply parameter updates.</p>', ], ], 'ApplyPendingMaintenanceActionMessage' => [ 'base' => NULL, 'refs' => [], ], 'ApplyPendingMaintenanceActionResult' => [ 'base' => NULL, 'refs' => [], ], 'AttributeValueList' => [ 'base' => NULL, 'refs' => [ 'DBClusterSnapshotAttribute$AttributeValues' => '<p>The value(s) for the manual DB cluster snapshot attribute.</p> <p>If the <code>AttributeName</code> field is set to <code>restore</code>, then this element returns a list of IDs of the Amazon accounts that are authorized to copy or restore the manual DB cluster snapshot. If a value of <code>all</code> is in the list, then the manual DB cluster snapshot is public and available for any Amazon account to copy or restore.</p>', 'ModifyDBClusterSnapshotAttributeMessage$ValuesToAdd' => '<p>A list of DB cluster snapshot attributes to add to the attribute specified by <code>AttributeName</code>.</p> <p>To authorize other Amazon accounts to copy or restore a manual DB cluster snapshot, set this list to include one or more Amazon account IDs, or <code>all</code> to make the manual DB cluster snapshot restorable by any Amazon account. Do not add the <code>all</code> value for any manual DB cluster snapshots that contain private information that you don\'t want available to all Amazon accounts.</p>', 'ModifyDBClusterSnapshotAttributeMessage$ValuesToRemove' => '<p>A list of DB cluster snapshot attributes to remove from the attribute specified by <code>AttributeName</code>.</p> <p>To remove authorization for other Amazon accounts to copy or restore a manual DB cluster snapshot, set this list to include one or more Amazon account identifiers, or <code>all</code> to remove authorization for any Amazon account to copy or restore the DB cluster snapshot. If you specify <code>all</code>, an Amazon account whose account ID is explicitly added to the <code>restore</code> attribute can still copy or restore a manual DB cluster snapshot.</p>', ], ], 'AuthorizationNotFoundFault' => [ 'base' => '<p>Specified CIDRIP or EC2 security group is not authorized for the specified DB security group.</p> <p>Neptune may not also be authorized via IAM to perform necessary actions on your behalf.</p>', 'refs' => [], ], 'AvailabilityZone' => [ 'base' => '<p>Specifies an Availability Zone.</p>', 'refs' => [ 'AvailabilityZoneList$member' => NULL, 'Subnet$SubnetAvailabilityZone' => '<p>Specifies the EC2 Availability Zone that the subnet is in.</p>', ], ], 'AvailabilityZoneList' => [ 'base' => NULL, 'refs' => [ 'OrderableDBInstanceOption$AvailabilityZones' => '<p>A list of Availability Zones for a DB instance.</p>', ], ], 'AvailabilityZones' => [ 'base' => NULL, 'refs' => [ 'CreateDBClusterMessage$AvailabilityZones' => '<p>A list of EC2 Availability Zones that instances in the DB cluster can be created in.</p>', 'DBCluster$AvailabilityZones' => '<p>Provides the list of EC2 Availability Zones that instances in the DB cluster can be created in.</p>', 'DBClusterSnapshot$AvailabilityZones' => '<p>Provides the list of EC2 Availability Zones that instances in the DB cluster snapshot can be restored in.</p>', 'RestoreDBClusterFromSnapshotMessage$AvailabilityZones' => '<p>Provides the list of EC2 Availability Zones that instances in the restored DB cluster can be created in.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'DBCluster$MultiAZ' => '<p>Specifies whether the DB cluster has instances in multiple Availability Zones.</p>', 'DBCluster$StorageEncrypted' => '<p>Specifies whether the DB cluster is encrypted.</p>', 'DBCluster$IAMDatabaseAuthenticationEnabled' => '<p>True if mapping of Amazon Identity and Access Management (IAM) accounts to database accounts is enabled, and otherwise false.</p>', 'DBClusterMember$IsClusterWriter' => '<p>Value that is <code>true</code> if the cluster member is the primary instance for the DB cluster and <code>false</code> otherwise.</p>', 'DBClusterSnapshot$StorageEncrypted' => '<p>Specifies whether the DB cluster snapshot is encrypted.</p>', 'DBClusterSnapshot$IAMDatabaseAuthenticationEnabled' => '<p>True if mapping of Amazon Identity and Access Management (IAM) accounts to database accounts is enabled, and otherwise false.</p>', 'DBEngineVersion$SupportsLogExportsToCloudwatchLogs' => '<p>A value that indicates whether the engine version supports exporting the log types specified by ExportableLogTypes to CloudWatch Logs.</p>', 'DBEngineVersion$SupportsReadReplica' => '<p>Indicates whether the database engine version supports read replicas.</p>', 'DBEngineVersion$SupportsGlobalDatabases' => '<p>A value that indicates whether you can use Aurora global databases with a specific DB engine version.</p>', 'DBInstance$MultiAZ' => '<p>Specifies if the DB instance is a Multi-AZ deployment.</p>', 'DBInstance$AutoMinorVersionUpgrade' => '<p>Indicates that minor version patches are applied automatically.</p>', 'DBInstance$PubliclyAccessible' => '<p>This flag should no longer be used.</p>', 'DBInstance$StorageEncrypted' => '<p>Not supported: The encryption for DB instances is managed by the DB cluster.</p>', 'DBInstance$CopyTagsToSnapshot' => '<p>Specifies whether tags are copied from the DB instance to snapshots of the DB instance.</p>', 'DBInstance$IAMDatabaseAuthenticationEnabled' => '<p>True if Amazon Identity and Access Management (IAM) authentication is enabled, and otherwise false.</p>', 'DBInstanceStatusInfo$Normal' => '<p>Boolean value that is true if the instance is operating normally, or false if the instance is in an error state.</p>', 'DeleteDBClusterMessage$SkipFinalSnapshot' => '<p> Determines whether a final DB cluster snapshot is created before the DB cluster is deleted. If <code>true</code> is specified, no DB cluster snapshot is created. If <code>false</code> is specified, a DB cluster snapshot is created before the DB cluster is deleted.</p> <note> <p>You must specify a <code>FinalDBSnapshotIdentifier</code> parameter if <code>SkipFinalSnapshot</code> is <code>false</code>.</p> </note> <p>Default: <code>false</code> </p>', 'DeleteDBInstanceMessage$SkipFinalSnapshot' => '<p> Determines whether a final DB snapshot is created before the DB instance is deleted. If <code>true</code> is specified, no DBSnapshot is created. If <code>false</code> is specified, a DB snapshot is created before the DB instance is deleted.</p> <p>Note that when a DB instance is in a failure state and has a status of \'failed\', \'incompatible-restore\', or \'incompatible-network\', it can only be deleted when the SkipFinalSnapshot parameter is set to "true".</p> <p>Specify <code>true</code> when deleting a Read Replica.</p> <note> <p>The FinalDBSnapshotIdentifier parameter must be specified if SkipFinalSnapshot is <code>false</code>.</p> </note> <p>Default: <code>false</code> </p>', 'DescribeDBClusterSnapshotsMessage$IncludeShared' => '<p>True to include shared manual DB cluster snapshots from other Amazon accounts that this Amazon account has been given permission to copy or restore, and otherwise false. The default is <code>false</code>.</p> <p>You can give an Amazon account permission to restore a manual DB cluster snapshot from another Amazon account by the <a>ModifyDBClusterSnapshotAttribute</a> API action.</p>', 'DescribeDBClusterSnapshotsMessage$IncludePublic' => '<p>True to include manual DB cluster snapshots that are public and can be copied or restored by any Amazon account, and otherwise false. The default is <code>false</code>. The default is false.</p> <p>You can share a manual DB cluster snapshot as public by using the <a>ModifyDBClusterSnapshotAttribute</a> API action.</p>', 'DescribeDBEngineVersionsMessage$DefaultOnly' => '<p>Indicates that only the default version of the specified engine or engine and major version combination is returned.</p>', 'EventSubscription$Enabled' => '<p>A Boolean value indicating if the subscription is enabled. True indicates the subscription is enabled.</p>', 'GlobalClusterMember$IsWriter' => '<p> Specifies whether the Neptune cluster is the primary cluster (that is, has read-write capability) for the Neptune global database with which it is associated. </p>', 'ModifyDBClusterMessage$ApplyImmediately' => '<p>A value that specifies whether the modifications in this request and any pending modifications are asynchronously applied as soon as possible, regardless of the <code>PreferredMaintenanceWindow</code> setting for the DB cluster. If this parameter is set to <code>false</code>, changes to the DB cluster are applied during the next maintenance window.</p> <p>The <code>ApplyImmediately</code> parameter only affects <code>NewDBClusterIdentifier</code> values. If you set the <code>ApplyImmediately</code> parameter value to false, then changes to <code>NewDBClusterIdentifier</code> values are applied during the next maintenance window. All other changes are applied immediately, regardless of the value of the <code>ApplyImmediately</code> parameter.</p> <p>Default: <code>false</code> </p>', 'ModifyDBClusterMessage$AllowMajorVersionUpgrade' => '<p>A value that indicates whether upgrades between different major versions are allowed.</p> <p>Constraints: You must set the allow-major-version-upgrade flag when providing an <code>EngineVersion</code> parameter that uses a different major version than the DB cluster\'s current version.</p>', 'ModifyDBInstanceMessage$ApplyImmediately' => '<p>Specifies whether the modifications in this request and any pending modifications are asynchronously applied as soon as possible, regardless of the <code>PreferredMaintenanceWindow</code> setting for the DB instance.</p> <p> If this parameter is set to <code>false</code>, changes to the DB instance are applied during the next maintenance window. Some parameter changes can cause an outage and are applied on the next call to <a>RebootDBInstance</a>, or the next failure reboot.</p> <p>Default: <code>false</code> </p>', 'ModifyDBInstanceMessage$AllowMajorVersionUpgrade' => '<p>Indicates that major version upgrades are allowed. Changing this parameter doesn\'t result in an outage and the change is asynchronously applied as soon as possible.</p>', 'OrderableDBInstanceOption$MultiAZCapable' => '<p>Indicates whether a DB instance is Multi-AZ capable.</p>', 'OrderableDBInstanceOption$ReadReplicaCapable' => '<p>Indicates whether a DB instance can have a Read Replica.</p>', 'OrderableDBInstanceOption$Vpc' => '<p>Indicates whether a DB instance is in a VPC.</p>', 'OrderableDBInstanceOption$SupportsStorageEncryption' => '<p>Indicates whether a DB instance supports encrypted storage.</p>', 'OrderableDBInstanceOption$SupportsIops' => '<p>Indicates whether a DB instance supports provisioned IOPS.</p>', 'OrderableDBInstanceOption$SupportsEnhancedMonitoring' => '<p>Indicates whether a DB instance supports Enhanced Monitoring at intervals from 1 to 60 seconds.</p>', 'OrderableDBInstanceOption$SupportsIAMDatabaseAuthentication' => '<p>Indicates whether a DB instance supports IAM database authentication.</p>', 'OrderableDBInstanceOption$SupportsPerformanceInsights' => '<p> <i>(Not supported by Neptune)</i> </p>', 'OrderableDBInstanceOption$SupportsGlobalDatabases' => '<p>A value that indicates whether you can use Neptune global databases with a specific combination of other DB engine attributes.</p>', 'Parameter$IsModifiable' => '<p> Indicates whether (<code>true</code>) or not (<code>false</code>) the parameter can be modified. Some parameters have security or operational implications that prevent them from being changed.</p>', 'ResetDBClusterParameterGroupMessage$ResetAllParameters' => '<p>A value that is set to <code>true</code> to reset all parameters in the DB cluster parameter group to their default values, and <code>false</code> otherwise. You can\'t use this parameter if there is a list of parameter names specified for the <code>Parameters</code> parameter.</p>', 'ResetDBParameterGroupMessage$ResetAllParameters' => '<p>Specifies whether (<code>true</code>) or not (<code>false</code>) to reset all parameters in the DB parameter group to default values.</p> <p>Default: <code>true</code> </p>', 'RestoreDBClusterToPointInTimeMessage$UseLatestRestorableTime' => '<p>A value that is set to <code>true</code> to restore the DB cluster to the latest restorable backup time, and <code>false</code> otherwise.</p> <p>Default: <code>false</code> </p> <p>Constraints: Cannot be specified if <code>RestoreToTime</code> parameter is provided.</p>', 'UpgradeTarget$AutoUpgrade' => '<p>A value that indicates whether the target version is applied to any source DB instances that have AutoMinorVersionUpgrade set to true.</p>', 'UpgradeTarget$IsMajorVersionUpgrade' => '<p>A value that indicates whether a database engine is upgraded to a major version.</p>', ], ], 'BooleanOptional' => [ 'base' => NULL, 'refs' => [ 'ClusterPendingModifiedValues$IAMDatabaseAuthenticationEnabled' => '<p>A value that indicates whether mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled.</p>', 'CopyDBClusterSnapshotMessage$CopyTags' => '<p>True to copy all tags from the source DB cluster snapshot to the target DB cluster snapshot, and otherwise false. The default is false.</p>', 'CreateDBClusterMessage$CopyTagsToSnapshot' => '<p> <i>If set to <code>true</code>, tags are copied to any snapshot of the DB cluster that is created.</i> </p>', 'CreateDBClusterMessage$StorageEncrypted' => '<p>Specifies whether the DB cluster is encrypted.</p>', 'CreateDBClusterMessage$EnableIAMDatabaseAuthentication' => '<p>If set to <code>true</code>, enables Amazon Identity and Access Management (IAM) authentication for the entire DB cluster (this cannot be set at an instance level).</p> <p>Default: <code>false</code>.</p>', 'CreateDBClusterMessage$DeletionProtection' => '<p>A value that indicates whether the DB cluster has deletion protection enabled. The database can\'t be deleted when deletion protection is enabled. By default, deletion protection is enabled.</p>', 'CreateDBInstanceMessage$MultiAZ' => '<p>Specifies if the DB instance is a Multi-AZ deployment. You can\'t set the AvailabilityZone parameter if the MultiAZ parameter is set to true.</p>', 'CreateDBInstanceMessage$AutoMinorVersionUpgrade' => '<p>Indicates that minor engine upgrades are applied automatically to the DB instance during the maintenance window.</p> <p>Default: <code>true</code> </p>', 'CreateDBInstanceMessage$PubliclyAccessible' => '<p>This flag should no longer be used.</p>', 'CreateDBInstanceMessage$StorageEncrypted' => '<p>Specifies whether the DB instance is encrypted.</p> <p>Not applicable. The encryption for DB instances is managed by the DB cluster. For more information, see <a>CreateDBCluster</a>.</p> <p>Default: false</p>', 'CreateDBInstanceMessage$CopyTagsToSnapshot' => '<p>True to copy all tags from the DB instance to snapshots of the DB instance, and otherwise false. The default is false.</p>', 'CreateDBInstanceMessage$EnableIAMDatabaseAuthentication' => '<p>Not supported by Neptune (ignored).</p>', 'CreateDBInstanceMessage$EnablePerformanceInsights' => '<p> <i>(Not supported by Neptune)</i> </p>', 'CreateDBInstanceMessage$DeletionProtection' => '<p>A value that indicates whether the DB instance has deletion protection enabled. The database can\'t be deleted when deletion protection is enabled. By default, deletion protection is disabled. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-instances-delete.html">Deleting a DB Instance</a>.</p> <p>DB instances in a DB cluster can be deleted even when deletion protection is enabled in their parent DB cluster.</p>', 'CreateEventSubscriptionMessage$Enabled' => '<p> A Boolean value; set to <b>true</b> to activate the subscription, set to <b>false</b> to create the subscription but not active it.</p>', 'CreateGlobalClusterMessage$DeletionProtection' => '<p>The deletion protection setting for the new global database. The global database can\'t be deleted when deletion protection is enabled.</p>', 'CreateGlobalClusterMessage$StorageEncrypted' => '<p>The storage encryption setting for the new global database cluster.</p>', 'DBCluster$CopyTagsToSnapshot' => '<p> <i>If set to <code>true</code>, tags are copied to any snapshot of the DB cluster that is created.</i> </p>', 'DBCluster$DeletionProtection' => '<p>Indicates whether or not the DB cluster has deletion protection enabled. The database can\'t be deleted when deletion protection is enabled.</p>', 'DBCluster$CrossAccountClone' => '<p>If set to <code>true</code>, the DB cluster can be cloned across accounts.</p>', 'DBInstance$PerformanceInsightsEnabled' => '<p> <i>(Not supported by Neptune)</i> </p>', 'DBInstance$DeletionProtection' => '<p>Indicates whether or not the DB instance has deletion protection enabled. The instance can\'t be deleted when deletion protection is enabled. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-instances-delete.html">Deleting a DB Instance</a>.</p>', 'DescribeDBEngineVersionsMessage$ListSupportedCharacterSets' => '<p>If this parameter is specified and the requested engine supports the <code>CharacterSetName</code> parameter for <code>CreateDBInstance</code>, the response includes a list of supported character sets for each engine version.</p>', 'DescribeDBEngineVersionsMessage$ListSupportedTimezones' => '<p>If this parameter is specified and the requested engine supports the <code>TimeZone</code> parameter for <code>CreateDBInstance</code>, the response includes a list of supported time zones for each engine version.</p>', 'DescribeOrderableDBInstanceOptionsMessage$Vpc' => '<p>The VPC filter value. Specify this parameter to show only the available VPC or non-VPC offerings.</p>', 'GlobalCluster$StorageEncrypted' => '<p>The storage encryption setting for the global database.</p>', 'GlobalCluster$DeletionProtection' => '<p>The deletion protection setting for the global database.</p>', 'ModifyDBClusterMessage$EnableIAMDatabaseAuthentication' => '<p>True to enable mapping of Amazon Identity and Access Management (IAM) accounts to database accounts, and otherwise false.</p> <p>Default: <code>false</code> </p>', 'ModifyDBClusterMessage$DeletionProtection' => '<p>A value that indicates whether the DB cluster has deletion protection enabled. The database can\'t be deleted when deletion protection is enabled. By default, deletion protection is disabled.</p>', 'ModifyDBClusterMessage$CopyTagsToSnapshot' => '<p> <i>If set to <code>true</code>, tags are copied to any snapshot of the DB cluster that is created.</i> </p>', 'ModifyDBInstanceMessage$MultiAZ' => '<p>Specifies if the DB instance is a Multi-AZ deployment. Changing this parameter doesn\'t result in an outage and the change is applied during the next maintenance window unless the <code>ApplyImmediately</code> parameter is set to <code>true</code> for this request.</p>', 'ModifyDBInstanceMessage$AutoMinorVersionUpgrade' => '<p> Indicates that minor version upgrades are applied automatically to the DB instance during the maintenance window. Changing this parameter doesn\'t result in an outage except in the following case and the change is asynchronously applied as soon as possible. An outage will result if this parameter is set to <code>true</code> during the maintenance window, and a newer minor version is available, and Neptune has enabled auto patching for that engine version.</p>', 'ModifyDBInstanceMessage$CopyTagsToSnapshot' => '<p>True to copy all tags from the DB instance to snapshots of the DB instance, and otherwise false. The default is false.</p>', 'ModifyDBInstanceMessage$PubliclyAccessible' => '<p>This flag should no longer be used.</p>', 'ModifyDBInstanceMessage$EnableIAMDatabaseAuthentication' => '<p>True to enable mapping of Amazon Identity and Access Management (IAM) accounts to database accounts, and otherwise false.</p> <p>You can enable IAM database authentication for the following database engines</p> <p>Not applicable. Mapping Amazon IAM accounts to database accounts is managed by the DB cluster. For more information, see <a>ModifyDBCluster</a>.</p> <p>Default: <code>false</code> </p>', 'ModifyDBInstanceMessage$EnablePerformanceInsights' => '<p> <i>(Not supported by Neptune)</i> </p>', 'ModifyDBInstanceMessage$DeletionProtection' => '<p>A value that indicates whether the DB instance has deletion protection enabled. The database can\'t be deleted when deletion protection is enabled. By default, deletion protection is disabled. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-instances-delete.html">Deleting a DB Instance</a>.</p>', 'ModifyEventSubscriptionMessage$Enabled' => '<p> A Boolean value; set to <b>true</b> to activate the subscription.</p>', 'ModifyGlobalClusterMessage$DeletionProtection' => '<p>Indicates whether the global database has deletion protection enabled. The global database cannot be deleted when deletion protection is enabled.</p>', 'ModifyGlobalClusterMessage$AllowMajorVersionUpgrade' => '<p>A value that indicates whether major version upgrades are allowed.</p> <p>Constraints: You must allow major version upgrades if you specify a value for the <code>EngineVersion</code> parameter that is a different major version than the DB cluster\'s current version.</p> <p>If you upgrade the major version of a global database, the cluster and DB instance parameter groups are set to the default parameter groups for the new version, so you will need to apply any custom parameter groups after completing the upgrade.</p>', 'PendingModifiedValues$MultiAZ' => '<p>Indicates that the Single-AZ DB instance is to change to a Multi-AZ deployment.</p>', 'RebootDBInstanceMessage$ForceFailover' => '<p> When <code>true</code>, the reboot is conducted through a MultiAZ failover.</p> <p>Constraint: You can\'t specify <code>true</code> if the instance is not configured for MultiAZ.</p>', 'RestoreDBClusterFromSnapshotMessage$EnableIAMDatabaseAuthentication' => '<p>True to enable mapping of Amazon Identity and Access Management (IAM) accounts to database accounts, and otherwise false.</p> <p>Default: <code>false</code> </p>', 'RestoreDBClusterFromSnapshotMessage$DeletionProtection' => '<p>A value that indicates whether the DB cluster has deletion protection enabled. The database can\'t be deleted when deletion protection is enabled. By default, deletion protection is disabled. </p>', 'RestoreDBClusterFromSnapshotMessage$CopyTagsToSnapshot' => '<p> <i>If set to <code>true</code>, tags are copied to any snapshot of the restored DB cluster that is created.</i> </p>', 'RestoreDBClusterToPointInTimeMessage$EnableIAMDatabaseAuthentication' => '<p>True to enable mapping of Amazon Identity and Access Management (IAM) accounts to database accounts, and otherwise false.</p> <p>Default: <code>false</code> </p>', 'RestoreDBClusterToPointInTimeMessage$DeletionProtection' => '<p>A value that indicates whether the DB cluster has deletion protection enabled. The database can\'t be deleted when deletion protection is enabled. By default, deletion protection is disabled. </p>', 'UpgradeTarget$SupportsGlobalDatabases' => '<p>A value that indicates whether you can use Neptune global databases with the target engine version.</p>', ], ], 'CertificateNotFoundFault' => [ 'base' => '<p> <i>CertificateIdentifier</i> does not refer to an existing certificate.</p>', 'refs' => [], ], 'CharacterSet' => [ 'base' => '<p>Specifies a character set.</p>', 'refs' => [ 'DBEngineVersion$DefaultCharacterSet' => '<p> <i>(Not supported by Neptune)</i> </p>', 'SupportedCharacterSetsList$member' => NULL, ], ], 'CloudwatchLogsExportConfiguration' => [ 'base' => '<p>The configuration setting for the log types to be enabled for export to CloudWatch Logs for a specific DB instance or DB cluster.</p> <p>The <code>EnableLogTypes</code> and <code>DisableLogTypes</code> arrays determine which logs will be exported (or not exported) to CloudWatch Logs.</p> <p>Valid log types are: <code>audit</code> (to publish audit logs) and <code>slowquery</code> (to publish slow-query logs). See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/cloudwatch-logs.html">Publishing Neptune logs to Amazon CloudWatch logs</a>.</p>', 'refs' => [ 'ModifyDBClusterMessage$CloudwatchLogsExportConfiguration' => '<p>The configuration setting for the log types to be enabled for export to CloudWatch Logs for a specific DB cluster. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/cloudwatch-logs.html#cloudwatch-logs-cli">Using the CLI to publish Neptune audit logs to CloudWatch Logs</a>.</p>', 'ModifyDBInstanceMessage$CloudwatchLogsExportConfiguration' => '<p>The configuration setting for the log types to be enabled for export to CloudWatch Logs for a specific DB instance or DB cluster.</p>', ], ], 'ClusterPendingModifiedValues' => [ 'base' => '<p>This data type is used as a response element in the <code>ModifyDBCluster</code> operation and contains changes that will be applied during the next maintenance window.</p>', 'refs' => [ 'DBCluster$PendingModifiedValues' => '<p>This data type is used as a response element in the <code>ModifyDBCluster</code> operation and contains changes that will be applied during the next maintenance window.</p>', ], ], 'CopyDBClusterParameterGroupMessage' => [ 'base' => NULL, 'refs' => [], ], 'CopyDBClusterParameterGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'CopyDBClusterSnapshotMessage' => [ 'base' => NULL, 'refs' => [], ], 'CopyDBClusterSnapshotResult' => [ 'base' => NULL, 'refs' => [], ], 'CopyDBParameterGroupMessage' => [ 'base' => NULL, 'refs' => [], ], 'CopyDBParameterGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateDBClusterEndpointMessage' => [ 'base' => NULL, 'refs' => [], ], 'CreateDBClusterEndpointOutput' => [ 'base' => '<p>This data type represents the information you need to connect to an Amazon Neptune DB cluster. This data type is used as a response element in the following actions:</p> <ul> <li> <p> <code>CreateDBClusterEndpoint</code> </p> </li> <li> <p> <code>DescribeDBClusterEndpoints</code> </p> </li> <li> <p> <code>ModifyDBClusterEndpoint</code> </p> </li> <li> <p> <code>DeleteDBClusterEndpoint</code> </p> </li> </ul> <p>For the data structure that represents Amazon Neptune DB instance endpoints, see <code>Endpoint</code>.</p>', 'refs' => [], ], 'CreateDBClusterMessage' => [ 'base' => NULL, 'refs' => [], ], 'CreateDBClusterParameterGroupMessage' => [ 'base' => NULL, 'refs' => [], ], 'CreateDBClusterParameterGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateDBClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateDBClusterSnapshotMessage' => [ 'base' => NULL, 'refs' => [], ], 'CreateDBClusterSnapshotResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateDBInstanceMessage' => [ 'base' => NULL, 'refs' => [], ], 'CreateDBInstanceResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateDBParameterGroupMessage' => [ 'base' => NULL, 'refs' => [], ], 'CreateDBParameterGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateDBSubnetGroupMessage' => [ 'base' => NULL, 'refs' => [], ], 'CreateDBSubnetGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateEventSubscriptionMessage' => [ 'base' => NULL, 'refs' => [], ], 'CreateEventSubscriptionResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateGlobalClusterMessage' => [ 'base' => NULL, 'refs' => [], ], 'CreateGlobalClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'DBCluster' => [ 'base' => '<p>Contains the details of an Amazon Neptune DB cluster.</p> <p>This data type is used as a response element in the <a>DescribeDBClusters</a>.</p>', 'refs' => [ 'CreateDBClusterResult$DBCluster' => NULL, 'DBClusterList$member' => NULL, 'DeleteDBClusterResult$DBCluster' => NULL, 'FailoverDBClusterResult$DBCluster' => NULL, 'ModifyDBClusterResult$DBCluster' => NULL, 'PromoteReadReplicaDBClusterResult$DBCluster' => NULL, 'RestoreDBClusterFromSnapshotResult$DBCluster' => NULL, 'RestoreDBClusterToPointInTimeResult$DBCluster' => NULL, 'StartDBClusterResult$DBCluster' => NULL, 'StopDBClusterResult$DBCluster' => NULL, ], ], 'DBClusterAlreadyExistsFault' => [ 'base' => '<p>User already has a DB cluster with the given identifier.</p>', 'refs' => [], ], 'DBClusterEndpoint' => [ 'base' => '<p>This data type represents the information you need to connect to an Amazon Neptune DB cluster. This data type is used as a response element in the following actions:</p> <ul> <li> <p> <code>CreateDBClusterEndpoint</code> </p> </li> <li> <p> <code>DescribeDBClusterEndpoints</code> </p> </li> <li> <p> <code>ModifyDBClusterEndpoint</code> </p> </li> <li> <p> <code>DeleteDBClusterEndpoint</code> </p> </li> </ul> <p>For the data structure that represents Amazon Neptune DB instance endpoints, see <code>Endpoint</code>.</p>', 'refs' => [ 'DBClusterEndpointList$member' => NULL, ], ], 'DBClusterEndpointAlreadyExistsFault' => [ 'base' => '<p>The specified custom endpoint cannot be created because it already exists.</p>', 'refs' => [], ], 'DBClusterEndpointList' => [ 'base' => NULL, 'refs' => [ 'DBClusterEndpointMessage$DBClusterEndpoints' => '<p>Contains the details of the endpoints associated with the cluster and matching any filter conditions.</p>', ], ], 'DBClusterEndpointMessage' => [ 'base' => NULL, 'refs' => [], ], 'DBClusterEndpointNotFoundFault' => [ 'base' => '<p>The specified custom endpoint doesn\'t exist.</p>', 'refs' => [], ], 'DBClusterEndpointQuotaExceededFault' => [ 'base' => '<p>The cluster already has the maximum number of custom endpoints.</p>', 'refs' => [], ], 'DBClusterList' => [ 'base' => NULL, 'refs' => [ 'DBClusterMessage$DBClusters' => '<p>Contains a list of DB clusters for the user.</p>', ], ], 'DBClusterMember' => [ 'base' => '<p>Contains information about an instance that is part of a DB cluster.</p>', 'refs' => [ 'DBClusterMemberList$member' => NULL, ], ], 'DBClusterMemberList' => [ 'base' => NULL, 'refs' => [ 'DBCluster$DBClusterMembers' => '<p>Provides the list of instances that make up the DB cluster.</p>', ], ], 'DBClusterMessage' => [ 'base' => NULL, 'refs' => [], ], 'DBClusterNotFoundFault' => [ 'base' => '<p> <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</p>', 'refs' => [], ], 'DBClusterOptionGroupMemberships' => [ 'base' => NULL, 'refs' => [ 'DBCluster$DBClusterOptionGroupMemberships' => '<p>Not supported by Neptune.</p>', ], ], 'DBClusterOptionGroupStatus' => [ 'base' => '<p>Not supported by Neptune.</p>', 'refs' => [ 'DBClusterOptionGroupMemberships$member' => NULL, ], ], 'DBClusterParameterGroup' => [ 'base' => '<p>Contains the details of an Amazon Neptune DB cluster parameter group.</p> <p>This data type is used as a response element in the <a>DescribeDBClusterParameterGroups</a> action.</p>', 'refs' => [ 'CopyDBClusterParameterGroupResult$DBClusterParameterGroup' => NULL, 'CreateDBClusterParameterGroupResult$DBClusterParameterGroup' => NULL, 'DBClusterParameterGroupList$member' => NULL, ], ], 'DBClusterParameterGroupDetails' => [ 'base' => NULL, 'refs' => [], ], 'DBClusterParameterGroupList' => [ 'base' => NULL, 'refs' => [ 'DBClusterParameterGroupsMessage$DBClusterParameterGroups' => '<p>A list of DB cluster parameter groups.</p>', ], ], 'DBClusterParameterGroupNameMessage' => [ 'base' => NULL, 'refs' => [], ], 'DBClusterParameterGroupNotFoundFault' => [ 'base' => '<p> <i>DBClusterParameterGroupName</i> does not refer to an existing DB Cluster parameter group.</p>', 'refs' => [], ], 'DBClusterParameterGroupsMessage' => [ 'base' => NULL, 'refs' => [], ], 'DBClusterQuotaExceededFault' => [ 'base' => '<p>User attempted to create a new DB cluster and the user has already reached the maximum allowed DB cluster quota.</p>', 'refs' => [], ], 'DBClusterRole' => [ 'base' => '<p>Describes an Amazon Identity and Access Management (IAM) role that is associated with a DB cluster.</p>', 'refs' => [ 'DBClusterRoles$member' => NULL, ], ], 'DBClusterRoleAlreadyExistsFault' => [ 'base' => '<p>The specified IAM role Amazon Resource Name (ARN) is already associated with the specified DB cluster.</p>', 'refs' => [], ], 'DBClusterRoleNotFoundFault' => [ 'base' => '<p>The specified IAM role Amazon Resource Name (ARN) is not associated with the specified DB cluster.</p>', 'refs' => [], ], 'DBClusterRoleQuotaExceededFault' => [ 'base' => '<p>You have exceeded the maximum number of IAM roles that can be associated with the specified DB cluster.</p>', 'refs' => [], ], 'DBClusterRoles' => [ 'base' => NULL, 'refs' => [ 'DBCluster$AssociatedRoles' => '<p>Provides a list of the Amazon Identity and Access Management (IAM) roles that are associated with the DB cluster. IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other Amazon services on your behalf.</p>', ], ], 'DBClusterSnapshot' => [ 'base' => '<p>Contains the details for an Amazon Neptune DB cluster snapshot</p> <p>This data type is used as a response element in the <a>DescribeDBClusterSnapshots</a> action.</p>', 'refs' => [ 'CopyDBClusterSnapshotResult$DBClusterSnapshot' => NULL, 'CreateDBClusterSnapshotResult$DBClusterSnapshot' => NULL, 'DBClusterSnapshotList$member' => NULL, 'DeleteDBClusterSnapshotResult$DBClusterSnapshot' => NULL, ], ], 'DBClusterSnapshotAlreadyExistsFault' => [ 'base' => '<p>User already has a DB cluster snapshot with the given identifier.</p>', 'refs' => [], ], 'DBClusterSnapshotAttribute' => [ 'base' => '<p>Contains the name and values of a manual DB cluster snapshot attribute.</p> <p>Manual DB cluster snapshot attributes are used to authorize other Amazon accounts to restore a manual DB cluster snapshot. For more information, see the <a>ModifyDBClusterSnapshotAttribute</a> API action.</p>', 'refs' => [ 'DBClusterSnapshotAttributeList$member' => NULL, ], ], 'DBClusterSnapshotAttributeList' => [ 'base' => NULL, 'refs' => [ 'DBClusterSnapshotAttributesResult$DBClusterSnapshotAttributes' => '<p>The list of attributes and values for the manual DB cluster snapshot.</p>', ], ], 'DBClusterSnapshotAttributesResult' => [ 'base' => '<p>Contains the results of a successful call to the <a>DescribeDBClusterSnapshotAttributes</a> API action.</p> <p>Manual DB cluster snapshot attributes are used to authorize other Amazon accounts to copy or restore a manual DB cluster snapshot. For more information, see the <a>ModifyDBClusterSnapshotAttribute</a> API action.</p>', 'refs' => [ 'DescribeDBClusterSnapshotAttributesResult$DBClusterSnapshotAttributesResult' => NULL, 'ModifyDBClusterSnapshotAttributeResult$DBClusterSnapshotAttributesResult' => NULL, ], ], 'DBClusterSnapshotList' => [ 'base' => NULL, 'refs' => [ 'DBClusterSnapshotMessage$DBClusterSnapshots' => '<p>Provides a list of DB cluster snapshots for the user.</p>', ], ], 'DBClusterSnapshotMessage' => [ 'base' => NULL, 'refs' => [], ], 'DBClusterSnapshotNotFoundFault' => [ 'base' => '<p> <i>DBClusterSnapshotIdentifier</i> does not refer to an existing DB cluster snapshot.</p>', 'refs' => [], ], 'DBEngineVersion' => [ 'base' => '<p> This data type is used as a response element in the action <a>DescribeDBEngineVersions</a>.</p>', 'refs' => [ 'DBEngineVersionList$member' => NULL, ], ], 'DBEngineVersionList' => [ 'base' => NULL, 'refs' => [ 'DBEngineVersionMessage$DBEngineVersions' => '<p> A list of <code>DBEngineVersion</code> elements.</p>', ], ], 'DBEngineVersionMessage' => [ 'base' => NULL, 'refs' => [], ], 'DBInstance' => [ 'base' => '<p>Contains the details of an Amazon Neptune DB instance.</p> <p>This data type is used as a response element in the <a>DescribeDBInstances</a> action.</p>', 'refs' => [ 'CreateDBInstanceResult$DBInstance' => NULL, 'DBInstanceList$member' => NULL, 'DeleteDBInstanceResult$DBInstance' => NULL, 'ModifyDBInstanceResult$DBInstance' => NULL, 'RebootDBInstanceResult$DBInstance' => NULL, ], ], 'DBInstanceAlreadyExistsFault' => [ 'base' => '<p>User already has a DB instance with the given identifier.</p>', 'refs' => [], ], 'DBInstanceList' => [ 'base' => NULL, 'refs' => [ 'DBInstanceMessage$DBInstances' => '<p> A list of <a>DBInstance</a> instances.</p>', ], ], 'DBInstanceMessage' => [ 'base' => NULL, 'refs' => [], ], 'DBInstanceNotFoundFault' => [ 'base' => '<p> <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</p>', 'refs' => [], ], 'DBInstanceStatusInfo' => [ 'base' => '<p>Provides a list of status information for a DB instance.</p>', 'refs' => [ 'DBInstanceStatusInfoList$member' => NULL, ], ], 'DBInstanceStatusInfoList' => [ 'base' => NULL, 'refs' => [ 'DBInstance$StatusInfos' => '<p>The status of a Read Replica. If the instance is not a Read Replica, this is blank.</p>', ], ], 'DBParameterGroup' => [ 'base' => '<p>Contains the details of an Amazon Neptune DB parameter group.</p> <p>This data type is used as a response element in the <a>DescribeDBParameterGroups</a> action.</p>', 'refs' => [ 'CopyDBParameterGroupResult$DBParameterGroup' => NULL, 'CreateDBParameterGroupResult$DBParameterGroup' => NULL, 'DBParameterGroupList$member' => NULL, ], ], 'DBParameterGroupAlreadyExistsFault' => [ 'base' => '<p>A DB parameter group with the same name exists.</p>', 'refs' => [], ], 'DBParameterGroupDetails' => [ 'base' => NULL, 'refs' => [], ], 'DBParameterGroupList' => [ 'base' => NULL, 'refs' => [ 'DBParameterGroupsMessage$DBParameterGroups' => '<p>A list of <a>DBParameterGroup</a> instances.</p>', ], ], 'DBParameterGroupNameMessage' => [ 'base' => NULL, 'refs' => [], ], 'DBParameterGroupNotFoundFault' => [ 'base' => '<p> <i>DBParameterGroupName</i> does not refer to an existing DB parameter group.</p>', 'refs' => [], ], 'DBParameterGroupQuotaExceededFault' => [ 'base' => '<p>Request would result in user exceeding the allowed number of DB parameter groups.</p>', 'refs' => [], ], 'DBParameterGroupStatus' => [ 'base' => '<p>The status of the DB parameter group.</p> <p>This data type is used as a response element in the following actions:</p> <ul> <li> <p> <a>CreateDBInstance</a> </p> </li> <li> <p> <a>DeleteDBInstance</a> </p> </li> <li> <p> <a>ModifyDBInstance</a> </p> </li> <li> <p> <a>RebootDBInstance</a> </p> </li> </ul>', 'refs' => [ 'DBParameterGroupStatusList$member' => NULL, ], ], 'DBParameterGroupStatusList' => [ 'base' => NULL, 'refs' => [ 'DBInstance$DBParameterGroups' => '<p>Provides the list of DB parameter groups applied to this DB instance.</p>', ], ], 'DBParameterGroupsMessage' => [ 'base' => NULL, 'refs' => [], ], 'DBSecurityGroupMembership' => [ 'base' => '<p>Specifies membership in a designated DB security group.</p>', 'refs' => [ 'DBSecurityGroupMembershipList$member' => NULL, ], ], 'DBSecurityGroupMembershipList' => [ 'base' => NULL, 'refs' => [ 'DBInstance$DBSecurityGroups' => '<p> Provides List of DB security group elements containing only <code>DBSecurityGroup.Name</code> and <code>DBSecurityGroup.Status</code> subelements.</p>', ], ], 'DBSecurityGroupNameList' => [ 'base' => NULL, 'refs' => [ 'CreateDBInstanceMessage$DBSecurityGroups' => '<p>A list of DB security groups to associate with this DB instance.</p> <p>Default: The default DB security group for the database engine.</p>', 'ModifyDBInstanceMessage$DBSecurityGroups' => '<p>A list of DB security groups to authorize on this DB instance. Changing this setting doesn\'t result in an outage and the change is asynchronously applied as soon as possible.</p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match existing DBSecurityGroups.</p> </li> </ul>', ], ], 'DBSecurityGroupNotFoundFault' => [ 'base' => '<p> <i>DBSecurityGroupName</i> does not refer to an existing DB security group.</p>', 'refs' => [], ], 'DBSnapshotAlreadyExistsFault' => [ 'base' => '<p> <i>DBSnapshotIdentifier</i> is already used by an existing snapshot.</p>', 'refs' => [], ], 'DBSnapshotNotFoundFault' => [ 'base' => '<p> <i>DBSnapshotIdentifier</i> does not refer to an existing DB snapshot.</p>', 'refs' => [], ], 'DBSubnetGroup' => [ 'base' => '<p>Contains the details of an Amazon Neptune DB subnet group.</p> <p>This data type is used as a response element in the <a>DescribeDBSubnetGroups</a> action.</p>', 'refs' => [ 'CreateDBSubnetGroupResult$DBSubnetGroup' => NULL, 'DBInstance$DBSubnetGroup' => '<p>Specifies information on the subnet group associated with the DB instance, including the name, description, and subnets in the subnet group.</p>', 'DBSubnetGroups$member' => NULL, 'ModifyDBSubnetGroupResult$DBSubnetGroup' => NULL, ], ], 'DBSubnetGroupAlreadyExistsFault' => [ 'base' => '<p> <i>DBSubnetGroupName</i> is already used by an existing DB subnet group.</p>', 'refs' => [], ], 'DBSubnetGroupDoesNotCoverEnoughAZs' => [ 'base' => '<p>Subnets in the DB subnet group should cover at least two Availability Zones unless there is only one Availability Zone.</p>', 'refs' => [], ], 'DBSubnetGroupMessage' => [ 'base' => NULL, 'refs' => [], ], 'DBSubnetGroupNotFoundFault' => [ 'base' => '<p> <i>DBSubnetGroupName</i> does not refer to an existing DB subnet group.</p>', 'refs' => [], ], 'DBSubnetGroupQuotaExceededFault' => [ 'base' => '<p>Request would result in user exceeding the allowed number of DB subnet groups.</p>', 'refs' => [], ], 'DBSubnetGroups' => [ 'base' => NULL, 'refs' => [ 'DBSubnetGroupMessage$DBSubnetGroups' => '<p> A list of <a>DBSubnetGroup</a> instances.</p>', ], ], 'DBSubnetQuotaExceededFault' => [ 'base' => '<p>Request would result in user exceeding the allowed number of subnets in a DB subnet groups.</p>', 'refs' => [], ], 'DBUpgradeDependencyFailureFault' => [ 'base' => '<p>The DB upgrade failed because a resource the DB depends on could not be modified.</p>', 'refs' => [], ], 'DeleteDBClusterEndpointMessage' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDBClusterEndpointOutput' => [ 'base' => '<p>This data type represents the information you need to connect to an Amazon Neptune DB cluster. This data type is used as a response element in the following actions:</p> <ul> <li> <p> <code>CreateDBClusterEndpoint</code> </p> </li> <li> <p> <code>DescribeDBClusterEndpoints</code> </p> </li> <li> <p> <code>ModifyDBClusterEndpoint</code> </p> </li> <li> <p> <code>DeleteDBClusterEndpoint</code> </p> </li> </ul> <p>For the data structure that represents Amazon RDS DB instance endpoints, see <code>Endpoint</code>.</p>', 'refs' => [], ], 'DeleteDBClusterMessage' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDBClusterParameterGroupMessage' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDBClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDBClusterSnapshotMessage' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDBClusterSnapshotResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDBInstanceMessage' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDBInstanceResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDBParameterGroupMessage' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDBSubnetGroupMessage' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEventSubscriptionMessage' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEventSubscriptionResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteGlobalClusterMessage' => [ 'base' => NULL, 'refs' => [], ], 'DeleteGlobalClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDBClusterEndpointsMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDBClusterParameterGroupsMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDBClusterParametersMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDBClusterSnapshotAttributesMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDBClusterSnapshotAttributesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDBClusterSnapshotsMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDBClustersMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDBEngineVersionsMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDBInstancesMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDBParameterGroupsMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDBParametersMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDBSubnetGroupsMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEngineDefaultClusterParametersMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEngineDefaultClusterParametersResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEngineDefaultParametersMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEngineDefaultParametersResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEventCategoriesMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEventSubscriptionsMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEventsMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeGlobalClustersMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeOrderableDBInstanceOptionsMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribePendingMaintenanceActionsMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeValidDBInstanceModificationsMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeValidDBInstanceModificationsResult' => [ 'base' => NULL, 'refs' => [], ], 'DomainMembership' => [ 'base' => '<p>An Active Directory Domain membership record associated with a DB instance.</p>', 'refs' => [ 'DomainMembershipList$member' => NULL, ], ], 'DomainMembershipList' => [ 'base' => NULL, 'refs' => [ 'DBInstance$DomainMemberships' => '<p>Not supported</p>', ], ], 'DomainNotFoundFault' => [ 'base' => '<p> <i>Domain</i> does not refer to an existing Active Directory Domain.</p>', 'refs' => [], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'DoubleRange$From' => '<p>The minimum value in the range.</p>', 'DoubleRange$To' => '<p>The maximum value in the range.</p>', ], ], 'DoubleOptional' => [ 'base' => NULL, 'refs' => [ 'OrderableDBInstanceOption$MinIopsPerGib' => '<p>Minimum provisioned IOPS per GiB for a DB instance.</p>', 'OrderableDBInstanceOption$MaxIopsPerGib' => '<p>Maximum provisioned IOPS per GiB for a DB instance.</p>', 'ServerlessV2ScalingConfiguration$MinCapacity' => '<p>The minimum number of Neptune capacity units (NCUs) for a DB instance in a Neptune Serverless cluster. You can specify NCU values in half-step increments, such as 8, 8.5, 9, and so on.</p>', 'ServerlessV2ScalingConfiguration$MaxCapacity' => '<p>The maximum number of Neptune capacity units (NCUs) for a DB instance in a Neptune Serverless cluster. You can specify NCU values in half-step increments, such as 40, 40.5, 41, and so on.</p>', 'ServerlessV2ScalingConfigurationInfo$MinCapacity' => '<p>The minimum number of Neptune capacity units (NCUs) for a DB instance in a Neptune Serverless cluster. You can specify NCU values in half-step increments, such as 8, 8.5, 9, and so on.</p>', 'ServerlessV2ScalingConfigurationInfo$MaxCapacity' => '<p>The maximum number of Neptune capacity units (NCUs) for a DB instance in a Neptune Serverless cluster. You can specify NCU values in half-step increments, such as 40, 40.5, 41, and so on.</p>', ], ], 'DoubleRange' => [ 'base' => '<p>A range of double values.</p>', 'refs' => [ 'DoubleRangeList$member' => NULL, ], ], 'DoubleRangeList' => [ 'base' => NULL, 'refs' => [ 'ValidStorageOptions$IopsToStorageRatio' => '<p>The valid range of Provisioned IOPS to gibibytes of storage multiplier. For example, 3-10, which means that provisioned IOPS can be between 3 and 10 times storage.</p>', ], ], 'Endpoint' => [ 'base' => '<p>Specifies a connection endpoint.</p> <p>For the data structure that represents Amazon Neptune DB cluster endpoints, see <code>DBClusterEndpoint</code>.</p>', 'refs' => [ 'DBInstance$Endpoint' => '<p>Specifies the connection endpoint.</p>', ], ], 'EngineDefaults' => [ 'base' => '<p> Contains the result of a successful invocation of the <a>DescribeEngineDefaultParameters</a> action.</p>', 'refs' => [ 'DescribeEngineDefaultClusterParametersResult$EngineDefaults' => NULL, 'DescribeEngineDefaultParametersResult$EngineDefaults' => NULL, ], ], 'Event' => [ 'base' => '<p> This data type is used as a response element in the <a>DescribeEvents</a> action.</p>', 'refs' => [ 'EventList$member' => NULL, ], ], 'EventCategoriesList' => [ 'base' => NULL, 'refs' => [ 'CreateEventSubscriptionMessage$EventCategories' => '<p> A list of event categories for a SourceType that you want to subscribe to. You can see a list of the categories for a given SourceType by using the <b>DescribeEventCategories</b> action.</p>', 'DescribeEventsMessage$EventCategories' => '<p>A list of event categories that trigger notifications for a event notification subscription.</p>', 'Event$EventCategories' => '<p>Specifies the category for the event.</p>', 'EventCategoriesMap$EventCategories' => '<p>The event categories for the specified source type</p>', 'EventSubscription$EventCategoriesList' => '<p>A list of event categories for the event notification subscription.</p>', 'ModifyEventSubscriptionMessage$EventCategories' => '<p> A list of event categories for a SourceType that you want to subscribe to. You can see a list of the categories for a given SourceType by using the <b>DescribeEventCategories</b> action.</p>', ], ], 'EventCategoriesMap' => [ 'base' => '<p>Contains the results of a successful invocation of the <a>DescribeEventCategories</a> action.</p>', 'refs' => [ 'EventCategoriesMapList$member' => NULL, ], ], 'EventCategoriesMapList' => [ 'base' => NULL, 'refs' => [ 'EventCategoriesMessage$EventCategoriesMapList' => '<p>A list of EventCategoriesMap data types.</p>', ], ], 'EventCategoriesMessage' => [ 'base' => NULL, 'refs' => [], ], 'EventList' => [ 'base' => NULL, 'refs' => [ 'EventsMessage$Events' => '<p> A list of <a>Event</a> instances.</p>', ], ], 'EventSubscription' => [ 'base' => '<p>Contains the results of a successful invocation of the <a>DescribeEventSubscriptions</a> action.</p>', 'refs' => [ 'AddSourceIdentifierToSubscriptionResult$EventSubscription' => NULL, 'CreateEventSubscriptionResult$EventSubscription' => NULL, 'DeleteEventSubscriptionResult$EventSubscription' => NULL, 'EventSubscriptionsList$member' => NULL, 'ModifyEventSubscriptionResult$EventSubscription' => NULL, 'RemoveSourceIdentifierFromSubscriptionResult$EventSubscription' => NULL, ], ], 'EventSubscriptionQuotaExceededFault' => [ 'base' => '<p>You have exceeded the number of events you can subscribe to.</p>', 'refs' => [], ], 'EventSubscriptionsList' => [ 'base' => NULL, 'refs' => [ 'EventSubscriptionsMessage$EventSubscriptionsList' => '<p>A list of EventSubscriptions data types.</p>', ], ], 'EventSubscriptionsMessage' => [ 'base' => NULL, 'refs' => [], ], 'EventsMessage' => [ 'base' => NULL, 'refs' => [], ], 'FailoverDBClusterMessage' => [ 'base' => NULL, 'refs' => [], ], 'FailoverDBClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'FailoverGlobalClusterMessage' => [ 'base' => NULL, 'refs' => [], ], 'FailoverGlobalClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'Filter' => [ 'base' => '<p>This type is not currently supported.</p>', 'refs' => [ 'FilterList$member' => NULL, ], ], 'FilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeDBClusterEndpointsMessage$Filters' => '<p>A set of name-value pairs that define which endpoints to include in the output. The filters are specified as name-value pairs, in the format <code>Name=<i>endpoint_type</i>,Values=<i>endpoint_type1</i>,<i>endpoint_type2</i>,...</code>. <code>Name</code> can be one of: <code>db-cluster-endpoint-type</code>, <code>db-cluster-endpoint-custom-type</code>, <code>db-cluster-endpoint-id</code>, <code>db-cluster-endpoint-status</code>. <code>Values</code> for the <code> db-cluster-endpoint-type</code> filter can be one or more of: <code>reader</code>, <code>writer</code>, <code>custom</code>. <code>Values</code> for the <code>db-cluster-endpoint-custom-type</code> filter can be one or more of: <code>reader</code>, <code>any</code>. <code>Values</code> for the <code>db-cluster-endpoint-status</code> filter can be one or more of: <code>available</code>, <code>creating</code>, <code>deleting</code>, <code>inactive</code>, <code>modifying</code>. </p>', 'DescribeDBClusterParameterGroupsMessage$Filters' => '<p>This parameter is not currently supported.</p>', 'DescribeDBClusterParametersMessage$Filters' => '<p>This parameter is not currently supported.</p>', 'DescribeDBClusterSnapshotsMessage$Filters' => '<p>This parameter is not currently supported.</p>', 'DescribeDBClustersMessage$Filters' => '<p>A filter that specifies one or more DB clusters to describe.</p> <p>Supported filters:</p> <ul> <li> <p> <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB cluster Amazon Resource Names (ARNs). The results list will only include information about the DB clusters identified by these ARNs.</p> </li> <li> <p> <code>engine</code> - Accepts an engine name (such as <code>neptune</code>), and restricts the results list to DB clusters created by that engine.</p> </li> </ul> <p>For example, to invoke this API from the Amazon CLI and filter so that only Neptune DB clusters are returned, you could use the following command:</p>', 'DescribeDBEngineVersionsMessage$Filters' => '<p>Not currently supported.</p>', 'DescribeDBInstancesMessage$Filters' => '<p>A filter that specifies one or more DB instances to describe.</p> <p>Supported filters:</p> <ul> <li> <p> <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB cluster Amazon Resource Names (ARNs). The results list will only include information about the DB instances associated with the DB clusters identified by these ARNs.</p> </li> <li> <p> <code>engine</code> - Accepts an engine name (such as <code>neptune</code>), and restricts the results list to DB instances created by that engine.</p> </li> </ul> <p>For example, to invoke this API from the Amazon CLI and filter so that only Neptune DB instances are returned, you could use the following command:</p>', 'DescribeDBParameterGroupsMessage$Filters' => '<p>This parameter is not currently supported.</p>', 'DescribeDBParametersMessage$Filters' => '<p>This parameter is not currently supported.</p>', 'DescribeDBSubnetGroupsMessage$Filters' => '<p>This parameter is not currently supported.</p>', 'DescribeEngineDefaultClusterParametersMessage$Filters' => '<p>This parameter is not currently supported.</p>', 'DescribeEngineDefaultParametersMessage$Filters' => '<p>Not currently supported.</p>', 'DescribeEventCategoriesMessage$Filters' => '<p>This parameter is not currently supported.</p>', 'DescribeEventSubscriptionsMessage$Filters' => '<p>This parameter is not currently supported.</p>', 'DescribeEventsMessage$Filters' => '<p>This parameter is not currently supported.</p>', 'DescribeOrderableDBInstanceOptionsMessage$Filters' => '<p>This parameter is not currently supported.</p>', 'DescribePendingMaintenanceActionsMessage$Filters' => '<p>A filter that specifies one or more resources to return pending maintenance actions for.</p> <p>Supported filters:</p> <ul> <li> <p> <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB cluster Amazon Resource Names (ARNs). The results list will only include pending maintenance actions for the DB clusters identified by these ARNs.</p> </li> <li> <p> <code>db-instance-id</code> - Accepts DB instance identifiers and DB instance ARNs. The results list will only include pending maintenance actions for the DB instances identified by these ARNs.</p> </li> </ul>', 'ListTagsForResourceMessage$Filters' => '<p>This parameter is not currently supported.</p>', ], ], 'FilterValueList' => [ 'base' => NULL, 'refs' => [ 'Filter$Values' => '<p>This parameter is not currently supported.</p>', ], ], 'GlobalCluster' => [ 'base' => '<p>Contains the details of an Amazon Neptune global database.</p> <p>This data type is used as a response element for the <a>CreateGlobalCluster</a>, <a>DescribeGlobalClusters</a>, <a>ModifyGlobalCluster</a>, <a>DeleteGlobalCluster</a>, <a>FailoverGlobalCluster</a>, and <a>RemoveFromGlobalCluster</a> actions.</p>', 'refs' => [ 'CreateGlobalClusterResult$GlobalCluster' => NULL, 'DeleteGlobalClusterResult$GlobalCluster' => NULL, 'FailoverGlobalClusterResult$GlobalCluster' => NULL, 'GlobalClusterList$member' => NULL, 'ModifyGlobalClusterResult$GlobalCluster' => NULL, 'RemoveFromGlobalClusterResult$GlobalCluster' => NULL, ], ], 'GlobalClusterAlreadyExistsFault' => [ 'base' => '<p>The <code>GlobalClusterIdentifier</code> already exists. Choose a new global database identifier (unique name) to create a new global database cluster.</p>', 'refs' => [], ], 'GlobalClusterIdentifier' => [ 'base' => NULL, 'refs' => [ 'CreateDBClusterMessage$GlobalClusterIdentifier' => '<p>The ID of the Neptune global database to which this new DB cluster should be added.</p>', 'CreateGlobalClusterMessage$GlobalClusterIdentifier' => '<p>The cluster identifier of the new global database cluster.</p>', 'DBCluster$GlobalClusterIdentifier' => '<p>Contains a user-supplied global database cluster identifier. This identifier is the unique key that identifies a global database.</p>', 'DeleteGlobalClusterMessage$GlobalClusterIdentifier' => '<p>The cluster identifier of the global database cluster being deleted.</p>', 'DescribeGlobalClustersMessage$GlobalClusterIdentifier' => '<p>The user-supplied DB cluster identifier. If this parameter is specified, only information about the specified DB cluster is returned. This parameter is not case-sensitive.</p> <p>Constraints: If supplied, must match an existing DB cluster identifier.</p>', 'FailoverGlobalClusterMessage$GlobalClusterIdentifier' => '<p>Identifier of the Neptune global database that should be failed over. The identifier is the unique key assigned by the user when the Neptune global database was created. In other words, it\'s the name of the global database that you want to fail over.</p> <p>Constraints: Must match the identifier of an existing Neptune global database.</p>', 'GlobalCluster$GlobalClusterIdentifier' => '<p>Contains a user-supplied global database cluster identifier. This identifier is the unique key that identifies a global database.</p>', 'ModifyGlobalClusterMessage$GlobalClusterIdentifier' => '<p>The DB cluster identifier for the global cluster being modified. This parameter is not case-sensitive.</p> <p>Constraints: Must match the identifier of an existing global database cluster.</p>', 'ModifyGlobalClusterMessage$NewGlobalClusterIdentifier' => '<p>A new cluster identifier to assign to the global database. This value is stored as a lowercase string.</p> <p>Constraints:</p> <ul> <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li> <li> <p>The first character must be a letter.</p> </li> <li> <p>Can\'t end with a hyphen or contain two consecutive hyphens</p> </li> </ul> <p>Example: <code>my-cluster2</code> </p>', 'RemoveFromGlobalClusterMessage$GlobalClusterIdentifier' => '<p>The identifier of the Neptune global database from which to detach the specified Neptune DB cluster.</p>', ], ], 'GlobalClusterList' => [ 'base' => NULL, 'refs' => [ 'GlobalClustersMessage$GlobalClusters' => '<p>The list of global clusters and instances returned by this request.</p>', ], ], 'GlobalClusterMember' => [ 'base' => '<p> A data structure with information about any primary and secondary clusters associated with an Neptune global database. </p>', 'refs' => [ 'GlobalClusterMemberList$member' => NULL, ], ], 'GlobalClusterMemberList' => [ 'base' => NULL, 'refs' => [ 'GlobalCluster$GlobalClusterMembers' => '<p>A list of cluster ARNs and instance ARNs for all the DB clusters that are part of the global database.</p>', ], ], 'GlobalClusterNotFoundFault' => [ 'base' => '<p>The <code>GlobalClusterIdentifier</code> doesn\'t refer to an existing global database cluster. </p>', 'refs' => [], ], 'GlobalClusterQuotaExceededFault' => [ 'base' => '<p>The number of global database clusters for this account is already at the maximum allowed.</p>', 'refs' => [], ], 'GlobalClustersMessage' => [ 'base' => NULL, 'refs' => [], ], 'InstanceQuotaExceededFault' => [ 'base' => '<p>Request would result in user exceeding the allowed number of DB instances.</p>', 'refs' => [], ], 'InsufficientDBClusterCapacityFault' => [ 'base' => '<p>The DB cluster does not have enough capacity for the current operation.</p>', 'refs' => [], ], 'InsufficientDBInstanceCapacityFault' => [ 'base' => '<p>Specified DB instance class is not available in the specified Availability Zone.</p>', 'refs' => [], ], 'InsufficientStorageClusterCapacityFault' => [ 'base' => '<p>There is insufficient storage available for the current action. You may be able to resolve this error by updating your subnet group to use different Availability Zones that have more storage available.</p>', 'refs' => [], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'DBClusterSnapshot$AllocatedStorage' => '<p>Specifies the allocated storage size in gibibytes (GiB).</p>', 'DBClusterSnapshot$Port' => '<p>Specifies the port that the DB cluster was listening on at the time of the snapshot.</p>', 'DBClusterSnapshot$PercentProgress' => '<p>Specifies the percentage of the estimated data that has been transferred.</p>', 'DBInstance$AllocatedStorage' => '<p>Not supported by Neptune.</p>', 'DBInstance$BackupRetentionPeriod' => '<p>Specifies the number of days for which automatic DB snapshots are retained.</p>', 'DBInstance$DbInstancePort' => '<p>Specifies the port that the DB instance listens on. If the DB instance is part of a DB cluster, this can be a different port than the DB cluster port.</p>', 'Endpoint$Port' => '<p>Specifies the port that the database engine is listening on.</p>', 'Range$From' => '<p>The minimum value in the range.</p>', 'Range$To' => '<p>The maximum value in the range.</p>', ], ], 'IntegerOptional' => [ 'base' => NULL, 'refs' => [ 'ClusterPendingModifiedValues$BackupRetentionPeriod' => '<p>The number of days for which automatic DB snapshots are retained.</p>', 'ClusterPendingModifiedValues$AllocatedStorage' => '<p>The allocated storage size in gibibytes (GiB) for database engines. For Neptune, <code>AllocatedStorage</code> always returns 1, because Neptune DB cluster storage size isn\'t fixed, but instead automatically adjusts as needed.</p>', 'ClusterPendingModifiedValues$Iops' => '<p>The Provisioned IOPS (I/O operations per second) value. This setting is only for non-Aurora Multi-AZ DB clusters.</p>', 'CreateDBClusterMessage$BackupRetentionPeriod' => '<p>The number of days for which automated backups are retained. You must specify a minimum value of 1.</p> <p>Default: 1</p> <p>Constraints:</p> <ul> <li> <p>Must be a value from 1 to 35</p> </li> </ul>', 'CreateDBClusterMessage$Port' => '<p>The port number on which the instances in the DB cluster accept connections.</p> <p> Default: <code>8182</code> </p>', 'CreateDBInstanceMessage$AllocatedStorage' => '<p>Not supported by Neptune.</p>', 'CreateDBInstanceMessage$BackupRetentionPeriod' => '<p>The number of days for which automated backups are retained.</p> <p>Not applicable. The retention period for automated backups is managed by the DB cluster. For more information, see <a>CreateDBCluster</a>.</p> <p>Default: 1</p> <p>Constraints:</p> <ul> <li> <p>Must be a value from 0 to 35</p> </li> <li> <p>Cannot be set to 0 if the DB instance is a source to Read Replicas</p> </li> </ul>', 'CreateDBInstanceMessage$Port' => '<p>The port number on which the database accepts connections.</p> <p>Not applicable. The port is managed by the DB cluster. For more information, see <a>CreateDBCluster</a>.</p> <p> Default: <code>8182</code> </p> <p>Type: Integer</p>', 'CreateDBInstanceMessage$Iops' => '<p>The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for the DB instance.</p>', 'CreateDBInstanceMessage$MonitoringInterval' => '<p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To disable collecting Enhanced Monitoring metrics, specify 0. The default is 0.</p> <p>If <code>MonitoringRoleArn</code> is specified, then you must also set <code>MonitoringInterval</code> to a value other than 0.</p> <p>Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code> </p>', 'CreateDBInstanceMessage$PromotionTier' => '<p>A value that specifies the order in which an Read Replica is promoted to the primary instance after a failure of the existing primary instance. </p> <p>Default: 1</p> <p>Valid Values: 0 - 15</p>', 'DBCluster$AllocatedStorage' => '<p> <code>AllocatedStorage</code> always returns 1, because Neptune DB cluster storage size is not fixed, but instead automatically adjusts as needed.</p>', 'DBCluster$BackupRetentionPeriod' => '<p>Specifies the number of days for which automatic DB snapshots are retained.</p>', 'DBCluster$Port' => '<p>Specifies the port that the database engine is listening on.</p>', 'DBClusterMember$PromotionTier' => '<p>A value that specifies the order in which a Read Replica is promoted to the primary instance after a failure of the existing primary instance.</p>', 'DBInstance$Iops' => '<p>Specifies the Provisioned IOPS (I/O operations per second) value.</p>', 'DBInstance$MonitoringInterval' => '<p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance.</p>', 'DBInstance$PromotionTier' => '<p>A value that specifies the order in which a Read Replica is promoted to the primary instance after a failure of the existing primary instance. </p>', 'DescribeDBClusterEndpointsMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so you can retrieve the remaining results. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeDBClusterParameterGroupsMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeDBClusterParametersMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeDBClusterSnapshotsMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeDBClustersMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeDBEngineVersionsMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more than the <code>MaxRecords</code> value is available, a pagination token called a marker is included in the response so that the following results can be retrieved.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeDBInstancesMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeDBParameterGroupsMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeDBParametersMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeDBSubnetGroupsMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeEngineDefaultClusterParametersMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeEngineDefaultParametersMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeEventSubscriptionsMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeEventsMessage$Duration' => '<p>The number of minutes to retrieve events for.</p> <p>Default: 60</p>', 'DescribeEventsMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeGlobalClustersMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination marker token is included in the response that you can use to retrieve the remaining results.</p> <p>Default: <code>100</code> </p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeOrderableDBInstanceOptionsMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribePendingMaintenanceActionsMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'ModifyDBClusterMessage$BackupRetentionPeriod' => '<p>The number of days for which automated backups are retained. You must specify a minimum value of 1.</p> <p>Default: 1</p> <p>Constraints:</p> <ul> <li> <p>Must be a value from 1 to 35</p> </li> </ul>', 'ModifyDBClusterMessage$Port' => '<p>The port number on which the DB cluster accepts connections.</p> <p>Constraints: Value must be <code>1150-65535</code> </p> <p>Default: The same port as the original DB cluster.</p>', 'ModifyDBInstanceMessage$AllocatedStorage' => '<p>Not supported by Neptune.</p>', 'ModifyDBInstanceMessage$BackupRetentionPeriod' => '<p>Not applicable. The retention period for automated backups is managed by the DB cluster. For more information, see <a>ModifyDBCluster</a>.</p> <p>Default: Uses existing setting</p>', 'ModifyDBInstanceMessage$Iops' => '<p>The new Provisioned IOPS (I/O operations per second) value for the instance.</p> <p>Changing this setting doesn\'t result in an outage and the change is applied during the next maintenance window unless the <code>ApplyImmediately</code> parameter is set to <code>true</code> for this request.</p> <p>Default: Uses existing setting</p>', 'ModifyDBInstanceMessage$MonitoringInterval' => '<p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To disable collecting Enhanced Monitoring metrics, specify 0. The default is 0.</p> <p>If <code>MonitoringRoleArn</code> is specified, then you must also set <code>MonitoringInterval</code> to a value other than 0.</p> <p>Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code> </p>', 'ModifyDBInstanceMessage$DBPortNumber' => '<p>The port number on which the database accepts connections.</p> <p>The value of the <code>DBPortNumber</code> parameter must not match any of the port values specified for options in the option group for the DB instance.</p> <p>Your database will restart when you change the <code>DBPortNumber</code> value regardless of the value of the <code>ApplyImmediately</code> parameter.</p> <p> Default: <code>8182</code> </p>', 'ModifyDBInstanceMessage$PromotionTier' => '<p>A value that specifies the order in which a Read Replica is promoted to the primary instance after a failure of the existing primary instance.</p> <p>Default: 1</p> <p>Valid Values: 0 - 15</p>', 'OrderableDBInstanceOption$MinStorageSize' => '<p>Minimum storage size for a DB instance.</p>', 'OrderableDBInstanceOption$MaxStorageSize' => '<p>Maximum storage size for a DB instance.</p>', 'OrderableDBInstanceOption$MinIopsPerDbInstance' => '<p>Minimum total provisioned IOPS for a DB instance.</p>', 'OrderableDBInstanceOption$MaxIopsPerDbInstance' => '<p>Maximum total provisioned IOPS for a DB instance.</p>', 'PendingModifiedValues$AllocatedStorage' => '<p> Contains the new <code>AllocatedStorage</code> size for the DB instance that will be applied or is currently being applied.</p>', 'PendingModifiedValues$Port' => '<p>Specifies the pending port for the DB instance.</p>', 'PendingModifiedValues$BackupRetentionPeriod' => '<p>Specifies the pending number of days for which automated backups are retained.</p>', 'PendingModifiedValues$Iops' => '<p>Specifies the new Provisioned IOPS value for the DB instance that will be applied or is currently being applied.</p>', 'Range$Step' => '<p>The step value for the range. For example, if you have a range of 5,000 to 10,000, with a step value of 1,000, the valid values start at 5,000 and step up by 1,000. Even though 7,500 is within the range, it isn\'t a valid value for the range. The valid values are 5,000, 6,000, 7,000, 8,000...</p>', 'RestoreDBClusterFromSnapshotMessage$Port' => '<p>The port number on which the new DB cluster accepts connections.</p> <p>Constraints: Value must be <code>1150-65535</code> </p> <p>Default: The same port as the original DB cluster.</p>', 'RestoreDBClusterToPointInTimeMessage$Port' => '<p>The port number on which the new DB cluster accepts connections.</p> <p>Constraints: Value must be <code>1150-65535</code> </p> <p>Default: The same port as the original DB cluster.</p>', ], ], 'InvalidDBClusterEndpointStateFault' => [ 'base' => '<p>The requested operation cannot be performed on the endpoint while the endpoint is in this state.</p>', 'refs' => [], ], 'InvalidDBClusterSnapshotStateFault' => [ 'base' => '<p>The supplied value is not a valid DB cluster snapshot state.</p>', 'refs' => [], ], 'InvalidDBClusterStateFault' => [ 'base' => '<p>The DB cluster is not in a valid state.</p>', 'refs' => [], ], 'InvalidDBInstanceStateFault' => [ 'base' => '<p>The specified DB instance is not in the <i>available</i> state.</p>', 'refs' => [], ], 'InvalidDBParameterGroupStateFault' => [ 'base' => '<p>The DB parameter group is in use or is in an invalid state. If you are attempting to delete the parameter group, you cannot delete it when the parameter group is in this state.</p>', 'refs' => [], ], 'InvalidDBSecurityGroupStateFault' => [ 'base' => '<p>The state of the DB security group does not allow deletion.</p>', 'refs' => [], ], 'InvalidDBSnapshotStateFault' => [ 'base' => '<p>The state of the DB snapshot does not allow deletion.</p>', 'refs' => [], ], 'InvalidDBSubnetGroupStateFault' => [ 'base' => '<p>The DB subnet group cannot be deleted because it is in use.</p>', 'refs' => [], ], 'InvalidDBSubnetStateFault' => [ 'base' => '<p>The DB subnet is not in the <i>available</i> state.</p>', 'refs' => [], ], 'InvalidEventSubscriptionStateFault' => [ 'base' => '<p>The event subscription is in an invalid state.</p>', 'refs' => [], ], 'InvalidGlobalClusterStateFault' => [ 'base' => '<p>The global cluster is in an invalid state and can\'t perform the requested operation. </p>', 'refs' => [], ], 'InvalidRestoreFault' => [ 'base' => '<p>Cannot restore from vpc backup to non-vpc DB instance.</p>', 'refs' => [], ], 'InvalidSubnet' => [ 'base' => '<p>The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.</p>', 'refs' => [], ], 'InvalidVPCNetworkStateFault' => [ 'base' => '<p>DB subnet group does not cover all Availability Zones after it is created because users\' change.</p>', 'refs' => [], ], 'KMSKeyNotAccessibleFault' => [ 'base' => '<p>Error accessing KMS key.</p>', 'refs' => [], ], 'KeyList' => [ 'base' => NULL, 'refs' => [ 'RemoveTagsFromResourceMessage$TagKeys' => '<p>The tag key (name) of the tag to be removed.</p>', ], ], 'ListTagsForResourceMessage' => [ 'base' => NULL, 'refs' => [], ], 'LogTypeList' => [ 'base' => NULL, 'refs' => [ 'CloudwatchLogsExportConfiguration$EnableLogTypes' => '<p>The list of log types to enable.</p>', 'CloudwatchLogsExportConfiguration$DisableLogTypes' => '<p>The list of log types to disable.</p>', 'CreateDBClusterMessage$EnableCloudwatchLogsExports' => '<p>A list of the log types that this DB cluster should export to CloudWatch Logs. Valid log types are: <code>audit</code> (to publish audit logs) and <code>slowquery</code> (to publish slow-query logs). See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/cloudwatch-logs.html">Publishing Neptune logs to Amazon CloudWatch logs</a>.</p>', 'CreateDBInstanceMessage$EnableCloudwatchLogsExports' => '<p>The list of log types that need to be enabled for exporting to CloudWatch Logs.</p>', 'DBCluster$EnabledCloudwatchLogsExports' => '<p>A list of the log types that this DB cluster is configured to export to CloudWatch Logs. Valid log types are: <code>audit</code> (to publish audit logs to CloudWatch) and slowquery (to publish slow-query logs to CloudWatch). See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/cloudwatch-logs.html">Publishing Neptune logs to Amazon CloudWatch logs</a>.</p>', 'DBEngineVersion$ExportableLogTypes' => '<p>The types of logs that the database engine has available for export to CloudWatch Logs.</p>', 'DBInstance$EnabledCloudwatchLogsExports' => '<p>A list of log types that this DB instance is configured to export to CloudWatch Logs.</p>', 'PendingCloudwatchLogsExports$LogTypesToEnable' => '<p>Log types that are in the process of being deactivated. After they are deactivated, these log types aren\'t exported to CloudWatch Logs.</p>', 'PendingCloudwatchLogsExports$LogTypesToDisable' => '<p>Log types that are in the process of being enabled. After they are enabled, these log types are exported to CloudWatch Logs.</p>', 'RestoreDBClusterFromSnapshotMessage$EnableCloudwatchLogsExports' => '<p>The list of logs that the restored DB cluster is to export to Amazon CloudWatch Logs.</p>', 'RestoreDBClusterToPointInTimeMessage$EnableCloudwatchLogsExports' => '<p>The list of logs that the restored DB cluster is to export to CloudWatch Logs.</p>', ], ], 'ModifyDBClusterEndpointMessage' => [ 'base' => NULL, 'refs' => [], ], 'ModifyDBClusterEndpointOutput' => [ 'base' => '<p>This data type represents the information you need to connect to an Amazon Neptune DB cluster. This data type is used as a response element in the following actions:</p> <ul> <li> <p> <code>CreateDBClusterEndpoint</code> </p> </li> <li> <p> <code>DescribeDBClusterEndpoints</code> </p> </li> <li> <p> <code>ModifyDBClusterEndpoint</code> </p> </li> <li> <p> <code>DeleteDBClusterEndpoint</code> </p> </li> </ul> <p>For the data structure that represents Amazon RDS DB instance endpoints, see <code>Endpoint</code>.</p>', 'refs' => [], ], 'ModifyDBClusterMessage' => [ 'base' => NULL, 'refs' => [], ], 'ModifyDBClusterParameterGroupMessage' => [ 'base' => NULL, 'refs' => [], ], 'ModifyDBClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyDBClusterSnapshotAttributeMessage' => [ 'base' => NULL, 'refs' => [], ], 'ModifyDBClusterSnapshotAttributeResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyDBInstanceMessage' => [ 'base' => NULL, 'refs' => [], ], 'ModifyDBInstanceResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyDBParameterGroupMessage' => [ 'base' => NULL, 'refs' => [], ], 'ModifyDBSubnetGroupMessage' => [ 'base' => NULL, 'refs' => [], ], 'ModifyDBSubnetGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyEventSubscriptionMessage' => [ 'base' => NULL, 'refs' => [], ], 'ModifyEventSubscriptionResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyGlobalClusterMessage' => [ 'base' => NULL, 'refs' => [], ], 'ModifyGlobalClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'OptionGroupMembership' => [ 'base' => '<p>Not supported by Neptune.</p>', 'refs' => [ 'OptionGroupMembershipList$member' => NULL, ], ], 'OptionGroupMembershipList' => [ 'base' => NULL, 'refs' => [ 'DBInstance$OptionGroupMemberships' => '<p> <i>(Not supported by Neptune)</i> </p>', ], ], 'OptionGroupNotFoundFault' => [ 'base' => '<p>The designated option group could not be found.</p>', 'refs' => [], ], 'OrderableDBInstanceOption' => [ 'base' => '<p>Contains a list of available options for a DB instance.</p> <p> This data type is used as a response element in the <a>DescribeOrderableDBInstanceOptions</a> action.</p>', 'refs' => [ 'OrderableDBInstanceOptionsList$member' => NULL, ], ], 'OrderableDBInstanceOptionsList' => [ 'base' => NULL, 'refs' => [ 'OrderableDBInstanceOptionsMessage$OrderableDBInstanceOptions' => '<p>An <a>OrderableDBInstanceOption</a> structure containing information about orderable options for the DB instance.</p>', ], ], 'OrderableDBInstanceOptionsMessage' => [ 'base' => NULL, 'refs' => [], ], 'Parameter' => [ 'base' => '<p>Specifies a parameter.</p>', 'refs' => [ 'ParametersList$member' => NULL, ], ], 'ParametersList' => [ 'base' => NULL, 'refs' => [ 'DBClusterParameterGroupDetails$Parameters' => '<p>Provides a list of parameters for the DB cluster parameter group.</p>', 'DBParameterGroupDetails$Parameters' => '<p>A list of <a>Parameter</a> values.</p>', 'EngineDefaults$Parameters' => '<p>Contains a list of engine default parameters.</p>', 'ModifyDBClusterParameterGroupMessage$Parameters' => '<p>A list of parameters in the DB cluster parameter group to modify.</p>', 'ModifyDBParameterGroupMessage$Parameters' => '<p>An array of parameter names, values, and the apply method for the parameter update. At least one parameter name, value, and apply method must be supplied; subsequent arguments are optional. A maximum of 20 parameters can be modified in a single request.</p> <p>Valid Values (for the application method): <code>immediate | pending-reboot</code> </p> <note> <p>You can use the immediate value with dynamic parameters only. You can use the pending-reboot value for both dynamic and static parameters, and changes are applied when you reboot the DB instance without failover.</p> </note>', 'ResetDBClusterParameterGroupMessage$Parameters' => '<p>A list of parameter names in the DB cluster parameter group to reset to the default values. You can\'t use this parameter if the <code>ResetAllParameters</code> parameter is set to <code>true</code>.</p>', 'ResetDBParameterGroupMessage$Parameters' => '<p>To reset the entire DB parameter group, specify the <code>DBParameterGroup</code> name and <code>ResetAllParameters</code> parameters. To reset specific parameters, provide a list of the following: <code>ParameterName</code> and <code>ApplyMethod</code>. A maximum of 20 parameters can be modified in a single request.</p> <p>Valid Values (for Apply method): <code>pending-reboot</code> </p>', ], ], 'PendingCloudwatchLogsExports' => [ 'base' => '<p>A list of the log types whose configuration is still pending. In other words, these log types are in the process of being activated or deactivated.</p> <p>Valid log types are: <code>audit</code> (to publish audit logs) and <code>slowquery</code> (to publish slow-query logs). See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/cloudwatch-logs.html">Publishing Neptune logs to Amazon CloudWatch logs</a>.</p>', 'refs' => [ 'ClusterPendingModifiedValues$PendingCloudwatchLogsExports' => '<p>This <code>PendingCloudwatchLogsExports</code> structure specifies pending changes to which CloudWatch logs are enabled and which are disabled.</p>', 'PendingModifiedValues$PendingCloudwatchLogsExports' => '<p>This <code>PendingCloudwatchLogsExports</code> structure specifies pending changes to which CloudWatch logs are enabled and which are disabled.</p>', ], ], 'PendingMaintenanceAction' => [ 'base' => '<p>Provides information about a pending maintenance action for a resource.</p>', 'refs' => [ 'PendingMaintenanceActionDetails$member' => NULL, ], ], 'PendingMaintenanceActionDetails' => [ 'base' => NULL, 'refs' => [ 'ResourcePendingMaintenanceActions$PendingMaintenanceActionDetails' => '<p>A list that provides details about the pending maintenance actions for the resource.</p>', ], ], 'PendingMaintenanceActions' => [ 'base' => NULL, 'refs' => [ 'PendingMaintenanceActionsMessage$PendingMaintenanceActions' => '<p>A list of the pending maintenance actions for the resource.</p>', ], ], 'PendingMaintenanceActionsMessage' => [ 'base' => NULL, 'refs' => [], ], 'PendingModifiedValues' => [ 'base' => '<p>This data type is used as a response element in the <a>ModifyDBInstance</a> action.</p>', 'refs' => [ 'DBInstance$PendingModifiedValues' => '<p>Specifies that changes to the DB instance are pending. This element is only included when changes are pending. Specific changes are identified by subelements.</p>', ], ], 'PromoteReadReplicaDBClusterMessage' => [ 'base' => NULL, 'refs' => [], ], 'PromoteReadReplicaDBClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'ProvisionedIopsNotAvailableInAZFault' => [ 'base' => '<p>Provisioned IOPS not available in the specified Availability Zone.</p>', 'refs' => [], ], 'Range' => [ 'base' => '<p>A range of integer values.</p>', 'refs' => [ 'RangeList$member' => NULL, ], ], 'RangeList' => [ 'base' => NULL, 'refs' => [ 'ValidStorageOptions$StorageSize' => '<p>The valid range of storage in gibibytes. For example, 100 to 16384.</p>', 'ValidStorageOptions$ProvisionedIops' => '<p>The valid range of provisioned IOPS. For example, 1000-20000.</p>', ], ], 'ReadReplicaDBClusterIdentifierList' => [ 'base' => NULL, 'refs' => [ 'DBInstance$ReadReplicaDBClusterIdentifiers' => '<p>Contains one or more identifiers of DB clusters that are Read Replicas of this DB instance.</p>', ], ], 'ReadReplicaDBInstanceIdentifierList' => [ 'base' => NULL, 'refs' => [ 'DBInstance$ReadReplicaDBInstanceIdentifiers' => '<p>Contains one or more identifiers of the Read Replicas associated with this DB instance.</p>', ], ], 'ReadReplicaIdentifierList' => [ 'base' => NULL, 'refs' => [ 'DBCluster$ReadReplicaIdentifiers' => '<p>Contains one or more identifiers of the Read Replicas associated with this DB cluster.</p>', ], ], 'ReadersArnList' => [ 'base' => NULL, 'refs' => [ 'GlobalClusterMember$Readers' => '<p> The Amazon Resource Name (ARN) for each read-only secondary cluster associated with the Neptune global database. </p>', ], ], 'RebootDBInstanceMessage' => [ 'base' => NULL, 'refs' => [], ], 'RebootDBInstanceResult' => [ 'base' => NULL, 'refs' => [], ], 'RemoveFromGlobalClusterMessage' => [ 'base' => NULL, 'refs' => [], ], 'RemoveFromGlobalClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'RemoveRoleFromDBClusterMessage' => [ 'base' => NULL, 'refs' => [], ], 'RemoveSourceIdentifierFromSubscriptionMessage' => [ 'base' => NULL, 'refs' => [], ], 'RemoveSourceIdentifierFromSubscriptionResult' => [ 'base' => NULL, 'refs' => [], ], 'RemoveTagsFromResourceMessage' => [ 'base' => NULL, 'refs' => [], ], 'ResetDBClusterParameterGroupMessage' => [ 'base' => NULL, 'refs' => [], ], 'ResetDBParameterGroupMessage' => [ 'base' => NULL, 'refs' => [], ], 'ResourceNotFoundFault' => [ 'base' => '<p>The specified resource ID was not found.</p>', 'refs' => [], ], 'ResourcePendingMaintenanceActions' => [ 'base' => '<p>Describes the pending maintenance actions for a resource.</p>', 'refs' => [ 'ApplyPendingMaintenanceActionResult$ResourcePendingMaintenanceActions' => NULL, 'PendingMaintenanceActions$member' => NULL, ], ], 'RestoreDBClusterFromSnapshotMessage' => [ 'base' => NULL, 'refs' => [], ], 'RestoreDBClusterFromSnapshotResult' => [ 'base' => NULL, 'refs' => [], ], 'RestoreDBClusterToPointInTimeMessage' => [ 'base' => NULL, 'refs' => [], ], 'RestoreDBClusterToPointInTimeResult' => [ 'base' => NULL, 'refs' => [], ], 'SNSInvalidTopicFault' => [ 'base' => '<p>The SNS topic is invalid.</p>', 'refs' => [], ], 'SNSNoAuthorizationFault' => [ 'base' => '<p>There is no SNS authorization.</p>', 'refs' => [], ], 'SNSTopicArnNotFoundFault' => [ 'base' => '<p>The ARN of the SNS topic could not be found.</p>', 'refs' => [], ], 'SensitiveString' => [ 'base' => NULL, 'refs' => [ 'CreateDBInstanceMessage$TdeCredentialPassword' => '<p>The password for the given ARN from the key store in order to access the device.</p>', 'ModifyDBInstanceMessage$TdeCredentialPassword' => '<p>The password for the given ARN from the key store in order to access the device.</p>', ], ], 'ServerlessV2ScalingConfiguration' => [ 'base' => '<p>Contains the scaling configuration of a Neptune Serverless DB cluster.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/neptune/latest/userguide/neptune-serverless-using.html">Using Amazon Neptune Serverless</a> in the <i>Amazon Neptune User Guide</i>.</p>', 'refs' => [ 'CreateDBClusterMessage$ServerlessV2ScalingConfiguration' => '<p>Contains the scaling configuration of a Neptune Serverless DB cluster.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/neptune/latest/userguide/neptune-serverless-using.html">Using Amazon Neptune Serverless</a> in the <i>Amazon Neptune User Guide</i>.</p>', 'ModifyDBClusterMessage$ServerlessV2ScalingConfiguration' => '<p>Contains the scaling configuration of a Neptune Serverless DB cluster.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/neptune/latest/userguide/neptune-serverless-using.html">Using Amazon Neptune Serverless</a> in the <i>Amazon Neptune User Guide</i>.</p>', 'RestoreDBClusterFromSnapshotMessage$ServerlessV2ScalingConfiguration' => '<p>Contains the scaling configuration of a Neptune Serverless DB cluster.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/neptune/latest/userguide/neptune-serverless-using.html">Using Amazon Neptune Serverless</a> in the <i>Amazon Neptune User Guide</i>.</p>', 'RestoreDBClusterToPointInTimeMessage$ServerlessV2ScalingConfiguration' => '<p>Contains the scaling configuration of a Neptune Serverless DB cluster.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/neptune/latest/userguide/neptune-serverless-using.html">Using Amazon Neptune Serverless</a> in the <i>Amazon Neptune User Guide</i>.</p>', ], ], 'ServerlessV2ScalingConfigurationInfo' => [ 'base' => '<p>Shows the scaling configuration for a Neptune Serverless DB cluster.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/neptune/latest/userguide/neptune-serverless-using.html">Using Amazon Neptune Serverless</a> in the <i>Amazon Neptune User Guide</i>.</p>', 'refs' => [ 'DBCluster$ServerlessV2ScalingConfiguration' => '<p>Shows the scaling configuration for a Neptune Serverless DB cluster.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/neptune/latest/userguide/neptune-serverless-using.html">Using Amazon Neptune Serverless</a> in the <i>Amazon Neptune User Guide</i>.</p>', ], ], 'SharedSnapshotQuotaExceededFault' => [ 'base' => '<p>You have exceeded the maximum number of accounts that you can share a manual DB snapshot with.</p>', 'refs' => [], ], 'SnapshotQuotaExceededFault' => [ 'base' => '<p>Request would result in user exceeding the allowed number of DB snapshots.</p>', 'refs' => [], ], 'SourceIdsList' => [ 'base' => NULL, 'refs' => [ 'CreateEventSubscriptionMessage$SourceIds' => '<p>The list of identifiers of the event sources for which events are returned. If not specified, then all sources are included in the response. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can\'t end with a hyphen or contain two consecutive hyphens.</p> <p>Constraints:</p> <ul> <li> <p>If SourceIds are supplied, SourceType must also be provided.</p> </li> <li> <p>If the source type is a DB instance, then a <code>DBInstanceIdentifier</code> must be supplied.</p> </li> <li> <p>If the source type is a DB security group, a <code>DBSecurityGroupName</code> must be supplied.</p> </li> <li> <p>If the source type is a DB parameter group, a <code>DBParameterGroupName</code> must be supplied.</p> </li> <li> <p>If the source type is a DB snapshot, a <code>DBSnapshotIdentifier</code> must be supplied.</p> </li> </ul>', 'EventSubscription$SourceIdsList' => '<p>A list of source IDs for the event notification subscription.</p>', ], ], 'SourceNotFoundFault' => [ 'base' => '<p>The source could not be found.</p>', 'refs' => [], ], 'SourceType' => [ 'base' => NULL, 'refs' => [ 'DescribeEventsMessage$SourceType' => '<p>The event source to retrieve events for. If no value is specified, all events are returned.</p>', 'Event$SourceType' => '<p>Specifies the source type for this event.</p>', ], ], 'StartDBClusterMessage' => [ 'base' => NULL, 'refs' => [], ], 'StartDBClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'StopDBClusterMessage' => [ 'base' => NULL, 'refs' => [], ], 'StopDBClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'StorageQuotaExceededFault' => [ 'base' => '<p>Request would result in user exceeding the allowed amount of storage available across all DB instances.</p>', 'refs' => [], ], 'StorageTypeNotSupportedFault' => [ 'base' => '<p> <i>StorageType</i> specified cannot be associated with the DB Instance.</p>', 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AddRoleToDBClusterMessage$DBClusterIdentifier' => '<p>The name of the DB cluster to associate the IAM role with.</p>', 'AddRoleToDBClusterMessage$RoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role to associate with the Neptune DB cluster, for example <code>arn:aws:iam::123456789012:role/NeptuneAccessRole</code>.</p>', 'AddRoleToDBClusterMessage$FeatureName' => '<p>The name of the feature for the Neptune DB cluster that the IAM role is to be associated with. For the list of supported feature names, see <a>DBEngineVersion</a>.</p>', 'AddSourceIdentifierToSubscriptionMessage$SubscriptionName' => '<p>The name of the event notification subscription you want to add a source identifier to.</p>', 'AddSourceIdentifierToSubscriptionMessage$SourceIdentifier' => '<p>The identifier of the event source to be added.</p> <p>Constraints:</p> <ul> <li> <p>If the source type is a DB instance, then a <code>DBInstanceIdentifier</code> must be supplied.</p> </li> <li> <p>If the source type is a DB security group, a <code>DBSecurityGroupName</code> must be supplied.</p> </li> <li> <p>If the source type is a DB parameter group, a <code>DBParameterGroupName</code> must be supplied.</p> </li> <li> <p>If the source type is a DB snapshot, a <code>DBSnapshotIdentifier</code> must be supplied.</p> </li> </ul>', 'AddTagsToResourceMessage$ResourceName' => '<p>The Amazon Neptune resource that the tags are added to. This value is an Amazon Resource Name (ARN). For information about creating an ARN, see <a href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing"> Constructing an Amazon Resource Name (ARN)</a>.</p>', 'ApplyPendingMaintenanceActionMessage$ResourceIdentifier' => '<p>The Amazon Resource Name (ARN) of the resource that the pending maintenance action applies to. For information about creating an ARN, see <a href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing"> Constructing an Amazon Resource Name (ARN)</a>.</p>', 'ApplyPendingMaintenanceActionMessage$ApplyAction' => '<p>The pending maintenance action to apply to this resource.</p> <p>Valid values: <code>system-update</code>, <code>db-upgrade</code> </p>', 'ApplyPendingMaintenanceActionMessage$OptInType' => '<p>A value that specifies the type of opt-in request, or undoes an opt-in request. An opt-in request of type <code>immediate</code> can\'t be undone.</p> <p>Valid values:</p> <ul> <li> <p> <code>immediate</code> - Apply the maintenance action immediately.</p> </li> <li> <p> <code>next-maintenance</code> - Apply the maintenance action during the next maintenance window for the resource.</p> </li> <li> <p> <code>undo-opt-in</code> - Cancel any existing <code>next-maintenance</code> opt-in requests.</p> </li> </ul>', 'AttributeValueList$member' => NULL, 'AvailabilityZone$Name' => '<p>The name of the availability zone.</p>', 'AvailabilityZones$member' => NULL, 'CharacterSet$CharacterSetName' => '<p>The name of the character set.</p>', 'CharacterSet$CharacterSetDescription' => '<p>The description of the character set.</p>', 'ClusterPendingModifiedValues$DBClusterIdentifier' => '<p>The DBClusterIdentifier value for the DB cluster.</p>', 'ClusterPendingModifiedValues$EngineVersion' => '<p>The database engine version.</p>', 'ClusterPendingModifiedValues$StorageType' => '<p>The storage type for the DB cluster.</p>', 'CopyDBClusterParameterGroupMessage$SourceDBClusterParameterGroupIdentifier' => '<p>The identifier or Amazon Resource Name (ARN) for the source DB cluster parameter group. For information about creating an ARN, see <a href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing"> Constructing an Amazon Resource Name (ARN)</a>.</p> <p>Constraints:</p> <ul> <li> <p>Must specify a valid DB cluster parameter group.</p> </li> <li> <p>If the source DB cluster parameter group is in the same Amazon Region as the copy, specify a valid DB parameter group identifier, for example <code>my-db-cluster-param-group</code>, or a valid ARN.</p> </li> <li> <p>If the source DB parameter group is in a different Amazon Region than the copy, specify a valid DB cluster parameter group ARN, for example <code>arn:aws:rds:us-east-1:123456789012:cluster-pg:custom-cluster-group1</code>.</p> </li> </ul>', 'CopyDBClusterParameterGroupMessage$TargetDBClusterParameterGroupIdentifier' => '<p>The identifier for the copied DB cluster parameter group.</p> <p>Constraints:</p> <ul> <li> <p>Cannot be null, empty, or blank</p> </li> <li> <p>Must contain from 1 to 255 letters, numbers, or hyphens</p> </li> <li> <p>First character must be a letter</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li> </ul> <p>Example: <code>my-cluster-param-group1</code> </p>', 'CopyDBClusterParameterGroupMessage$TargetDBClusterParameterGroupDescription' => '<p>A description for the copied DB cluster parameter group.</p>', 'CopyDBClusterSnapshotMessage$SourceDBClusterSnapshotIdentifier' => '<p>The identifier of the DB cluster snapshot to copy. This parameter is not case-sensitive.</p> <p>Constraints:</p> <ul> <li> <p>Must specify a valid system snapshot in the "available" state.</p> </li> <li> <p>Specify a valid DB snapshot identifier.</p> </li> </ul> <p>Example: <code>my-cluster-snapshot1</code> </p>', 'CopyDBClusterSnapshotMessage$TargetDBClusterSnapshotIdentifier' => '<p>The identifier of the new DB cluster snapshot to create from the source DB cluster snapshot. This parameter is not case-sensitive.</p> <p>Constraints:</p> <ul> <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li> </ul> <p>Example: <code>my-cluster-snapshot2</code> </p>', 'CopyDBClusterSnapshotMessage$KmsKeyId' => '<p>The Amazon Amazon KMS key ID for an encrypted DB cluster snapshot. The KMS key ID is the Amazon Resource Name (ARN), KMS key identifier, or the KMS key alias for the KMS encryption key.</p> <p>If you copy an encrypted DB cluster snapshot from your Amazon account, you can specify a value for <code>KmsKeyId</code> to encrypt the copy with a new KMS encryption key. If you don\'t specify a value for <code>KmsKeyId</code>, then the copy of the DB cluster snapshot is encrypted with the same KMS key as the source DB cluster snapshot.</p> <p>If you copy an encrypted DB cluster snapshot that is shared from another Amazon account, then you must specify a value for <code>KmsKeyId</code>.</p> <p> KMS encryption keys are specific to the Amazon Region that they are created in, and you can\'t use encryption keys from one Amazon Region in another Amazon Region.</p> <p>You cannot encrypt an unencrypted DB cluster snapshot when you copy it. If you try to copy an unencrypted DB cluster snapshot and specify a value for the KmsKeyId parameter, an error is returned.</p>', 'CopyDBClusterSnapshotMessage$PreSignedUrl' => '<p>Not currently supported.</p>', 'CopyDBParameterGroupMessage$SourceDBParameterGroupIdentifier' => '<p>The identifier or ARN for the source DB parameter group. For information about creating an ARN, see <a href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing"> Constructing an Amazon Resource Name (ARN)</a>.</p> <p>Constraints:</p> <ul> <li> <p>Must specify a valid DB parameter group.</p> </li> <li> <p>Must specify a valid DB parameter group identifier, for example <code>my-db-param-group</code>, or a valid ARN.</p> </li> </ul>', 'CopyDBParameterGroupMessage$TargetDBParameterGroupIdentifier' => '<p>The identifier for the copied DB parameter group.</p> <p>Constraints:</p> <ul> <li> <p>Cannot be null, empty, or blank.</p> </li> <li> <p>Must contain from 1 to 255 letters, numbers, or hyphens.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li> </ul> <p>Example: <code>my-db-parameter-group</code> </p>', 'CopyDBParameterGroupMessage$TargetDBParameterGroupDescription' => '<p>A description for the copied DB parameter group.</p>', 'CreateDBClusterEndpointMessage$DBClusterIdentifier' => '<p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a lowercase string.</p>', 'CreateDBClusterEndpointMessage$DBClusterEndpointIdentifier' => '<p>The identifier to use for the new endpoint. This parameter is stored as a lowercase string.</p>', 'CreateDBClusterEndpointMessage$EndpointType' => '<p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.</p>', 'CreateDBClusterEndpointOutput$DBClusterEndpointIdentifier' => '<p>The identifier associated with the endpoint. This parameter is stored as a lowercase string.</p>', 'CreateDBClusterEndpointOutput$DBClusterIdentifier' => '<p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a lowercase string.</p>', 'CreateDBClusterEndpointOutput$DBClusterEndpointResourceIdentifier' => '<p>A unique system-generated identifier for an endpoint. It remains the same for the whole life of the endpoint.</p>', 'CreateDBClusterEndpointOutput$Endpoint' => '<p>The DNS address of the endpoint.</p>', 'CreateDBClusterEndpointOutput$Status' => '<p>The current status of the endpoint. One of: <code>creating</code>, <code>available</code>, <code>deleting</code>, <code>inactive</code>, <code>modifying</code>. The <code>inactive</code> state applies to an endpoint that cannot be used for a certain kind of cluster, such as a <code>writer</code> endpoint for a read-only secondary cluster in a global database.</p>', 'CreateDBClusterEndpointOutput$EndpointType' => '<p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>CUSTOM</code>.</p>', 'CreateDBClusterEndpointOutput$CustomEndpointType' => '<p>The type associated with a custom endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.</p>', 'CreateDBClusterEndpointOutput$DBClusterEndpointArn' => '<p>The Amazon Resource Name (ARN) for the endpoint.</p>', 'CreateDBClusterMessage$CharacterSetName' => '<p> <i>(Not supported by Neptune)</i> </p>', 'CreateDBClusterMessage$DatabaseName' => '<p>The name for your database of up to 64 alpha-numeric characters. If you do not provide a name, Amazon Neptune will not create a database in the DB cluster you are creating.</p>', 'CreateDBClusterMessage$DBClusterIdentifier' => '<p>The DB cluster identifier. This parameter is stored as a lowercase string.</p> <p>Constraints:</p> <ul> <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li> </ul> <p>Example: <code>my-cluster1</code> </p>', 'CreateDBClusterMessage$DBClusterParameterGroupName' => '<p> The name of the DB cluster parameter group to associate with this DB cluster. If this argument is omitted, the default is used.</p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p> </li> </ul>', 'CreateDBClusterMessage$DBSubnetGroupName' => '<p>A DB subnet group to associate with this DB cluster.</p> <p>Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.</p> <p>Example: <code>mySubnetgroup</code> </p>', 'CreateDBClusterMessage$Engine' => '<p>The name of the database engine to be used for this DB cluster.</p> <p>Valid Values: <code>neptune</code> </p>', 'CreateDBClusterMessage$EngineVersion' => '<p>The version number of the database engine to use for the new DB cluster.</p> <p>Example: <code>1.0.2.1</code> </p>', 'CreateDBClusterMessage$MasterUsername' => '<p>Not supported by Neptune.</p>', 'CreateDBClusterMessage$MasterUserPassword' => '<p>Not supported by Neptune.</p>', 'CreateDBClusterMessage$OptionGroupName' => '<p> <i>(Not supported by Neptune)</i> </p>', 'CreateDBClusterMessage$PreferredBackupWindow' => '<p>The daily time range during which automated backups are created if automated backups are enabled using the <code>BackupRetentionPeriod</code> parameter.</p> <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Region. To see the time blocks available, see <a href="https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-maintaining.html#manage-console-maintaining-window">Neptune Maintenance Window</a> in the <i>Amazon Neptune User Guide.</i> </p> <p>Constraints:</p> <ul> <li> <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p> </li> <li> <p>Must be in Universal Coordinated Time (UTC).</p> </li> <li> <p>Must not conflict with the preferred maintenance window.</p> </li> <li> <p>Must be at least 30 minutes.</p> </li> </ul>', 'CreateDBClusterMessage$PreferredMaintenanceWindow' => '<p>The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p> <p>Format: <code>ddd:hh24:mi-ddd:hh24:mi</code> </p> <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Region, occurring on a random day of the week. To see the time blocks available, see <a href="https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-maintaining.html#manage-console-maintaining-window">Neptune Maintenance Window</a> in the <i>Amazon Neptune User Guide.</i> </p> <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.</p> <p>Constraints: Minimum 30-minute window.</p>', 'CreateDBClusterMessage$ReplicationSourceIdentifier' => '<p>The Amazon Resource Name (ARN) of the source DB instance or DB cluster if this DB cluster is created as a Read Replica.</p>', 'CreateDBClusterMessage$KmsKeyId' => '<p>The Amazon KMS key identifier for an encrypted DB cluster.</p> <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are creating a DB cluster with the same Amazon account that owns the KMS encryption key used to encrypt the new DB cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption key.</p> <p>If an encryption key is not specified in <code>KmsKeyId</code>:</p> <ul> <li> <p>If <code>ReplicationSourceIdentifier</code> identifies an encrypted source, then Amazon Neptune will use the encryption key used to encrypt the source. Otherwise, Amazon Neptune will use your default encryption key.</p> </li> <li> <p>If the <code>StorageEncrypted</code> parameter is true and <code>ReplicationSourceIdentifier</code> is not specified, then Amazon Neptune will use your default encryption key.</p> </li> </ul> <p>Amazon KMS creates the default encryption key for your Amazon account. Your Amazon account has a different default encryption key for each Amazon Region.</p> <p>If you create a Read Replica of an encrypted DB cluster in another Amazon Region, you must set <code>KmsKeyId</code> to a KMS key ID that is valid in the destination Amazon Region. This key is used to encrypt the Read Replica in that Amazon Region.</p>', 'CreateDBClusterMessage$PreSignedUrl' => '<p>This parameter is not currently supported.</p>', 'CreateDBClusterMessage$StorageType' => '<p>The storage type to associate with the DB cluster.</p> <p>Valid Values:</p> <ul> <li> <p> <code>standard | iopt1</code> </p> </li> </ul> <p>Default:</p> <ul> <li> <p> <code>standard</code> </p> </li> </ul> <note> <p>When you create a Neptune cluster with the storage type set to <code>iopt1</code>, the storage type is returned in the response. The storage type isn\'t returned when you set it to <code>standard</code>.</p> </note>', 'CreateDBClusterParameterGroupMessage$DBClusterParameterGroupName' => '<p>The name of the DB cluster parameter group.</p> <p>Constraints:</p> <ul> <li> <p>Must match the name of an existing DBClusterParameterGroup.</p> </li> </ul> <note> <p>This value is stored as a lowercase string.</p> </note>', 'CreateDBClusterParameterGroupMessage$DBParameterGroupFamily' => '<p>The DB cluster parameter group family name. A DB cluster parameter group can be associated with one and only one DB cluster parameter group family, and can be applied only to a DB cluster running a database engine and engine version compatible with that DB cluster parameter group family.</p>', 'CreateDBClusterParameterGroupMessage$Description' => '<p>The description for the DB cluster parameter group.</p>', 'CreateDBClusterSnapshotMessage$DBClusterSnapshotIdentifier' => '<p>The identifier of the DB cluster snapshot. This parameter is stored as a lowercase string.</p> <p>Constraints:</p> <ul> <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li> </ul> <p>Example: <code>my-cluster1-snapshot1</code> </p>', 'CreateDBClusterSnapshotMessage$DBClusterIdentifier' => '<p>The identifier of the DB cluster to create a snapshot for. This parameter is not case-sensitive.</p> <p>Constraints:</p> <ul> <li> <p>Must match the identifier of an existing DBCluster.</p> </li> </ul> <p>Example: <code>my-cluster1</code> </p>', 'CreateDBInstanceMessage$DBName' => '<p>Not supported.</p>', 'CreateDBInstanceMessage$DBInstanceIdentifier' => '<p>The DB instance identifier. This parameter is stored as a lowercase string.</p> <p>Constraints:</p> <ul> <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li> </ul> <p>Example: <code>mydbinstance</code> </p>', 'CreateDBInstanceMessage$DBInstanceClass' => '<p>The compute and memory capacity of the DB instance, for example, <code>db.m4.large</code>. Not all DB instance classes are available in all Amazon Regions.</p>', 'CreateDBInstanceMessage$Engine' => '<p>The name of the database engine to be used for this instance.</p> <p>Valid Values: <code>neptune</code> </p>', 'CreateDBInstanceMessage$MasterUsername' => '<p>Not supported by Neptune.</p>', 'CreateDBInstanceMessage$MasterUserPassword' => '<p>Not supported by Neptune.</p>', 'CreateDBInstanceMessage$AvailabilityZone' => '<p> The EC2 Availability Zone that the DB instance is created in</p> <p>Default: A random, system-chosen Availability Zone in the endpoint\'s Amazon Region.</p> <p> Example: <code>us-east-1d</code> </p> <p> Constraint: The AvailabilityZone parameter can\'t be specified if the MultiAZ parameter is set to <code>true</code>. The specified Availability Zone must be in the same Amazon Region as the current endpoint.</p>', 'CreateDBInstanceMessage$DBSubnetGroupName' => '<p>A DB subnet group to associate with this DB instance.</p> <p>If there is no DB subnet group, then it is a non-VPC DB instance.</p>', 'CreateDBInstanceMessage$PreferredMaintenanceWindow' => '<p>The time range each week during which system maintenance can occur, in Universal Coordinated Time (UTC).</p> <p> Format: <code>ddd:hh24:mi-ddd:hh24:mi</code> </p> <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Region, occurring on a random day of the week.</p> <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.</p> <p>Constraints: Minimum 30-minute window.</p>', 'CreateDBInstanceMessage$DBParameterGroupName' => '<p>The name of the DB parameter group to associate with this DB instance. If this argument is omitted, the default DBParameterGroup for the specified engine is used.</p> <p>Constraints:</p> <ul> <li> <p>Must be 1 to 255 letters, numbers, or hyphens.</p> </li> <li> <p>First character must be a letter</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li> </ul>', 'CreateDBInstanceMessage$PreferredBackupWindow' => '<p> The daily time range during which automated backups are created.</p> <p>Not applicable. The daily time range for creating automated backups is managed by the DB cluster. For more information, see <a>CreateDBCluster</a>.</p>', 'CreateDBInstanceMessage$EngineVersion' => '<p>The version number of the database engine to use. Currently, setting this parameter has no effect.</p>', 'CreateDBInstanceMessage$LicenseModel' => '<p>License model information for this DB instance.</p> <p> Valid values: <code>license-included</code> | <code>bring-your-own-license</code> | <code>general-public-license</code> </p>', 'CreateDBInstanceMessage$OptionGroupName' => '<p> <i>(Not supported by Neptune)</i> </p>', 'CreateDBInstanceMessage$CharacterSetName' => '<p> <i>(Not supported by Neptune)</i> </p>', 'CreateDBInstanceMessage$DBClusterIdentifier' => '<p>The identifier of the DB cluster that the instance will belong to.</p> <p>For information on creating a DB cluster, see <a>CreateDBCluster</a>.</p> <p>Type: String</p>', 'CreateDBInstanceMessage$StorageType' => '<p>Specifies the storage type to be associated with the DB instance.</p> <p>Not applicable. Storage is managed by the DB Cluster.</p>', 'CreateDBInstanceMessage$TdeCredentialArn' => '<p>The ARN from the key store with which to associate the instance for TDE encryption.</p>', 'CreateDBInstanceMessage$KmsKeyId' => '<p>The Amazon KMS key identifier for an encrypted DB instance.</p> <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are creating a DB instance with the same Amazon account that owns the KMS encryption key used to encrypt the new DB instance, then you can use the KMS key alias instead of the ARN for the KM encryption key.</p> <p>Not applicable. The KMS key identifier is managed by the DB cluster. For more information, see <a>CreateDBCluster</a>.</p> <p>If the <code>StorageEncrypted</code> parameter is true, and you do not specify a value for the <code>KmsKeyId</code> parameter, then Amazon Neptune will use your default encryption key. Amazon KMS creates the default encryption key for your Amazon account. Your Amazon account has a different default encryption key for each Amazon Region.</p>', 'CreateDBInstanceMessage$Domain' => '<p>Specify the Active Directory Domain to create the instance in.</p>', 'CreateDBInstanceMessage$MonitoringRoleArn' => '<p>The ARN for the IAM role that permits Neptune to send enhanced monitoring metrics to Amazon CloudWatch Logs. For example, <code>arn:aws:iam:123456789012:role/emaccess</code>.</p> <p>If <code>MonitoringInterval</code> is set to a value other than 0, then you must supply a <code>MonitoringRoleArn</code> value.</p>', 'CreateDBInstanceMessage$DomainIAMRoleName' => '<p>Specify the name of the IAM role to be used when making API calls to the Directory Service.</p>', 'CreateDBInstanceMessage$Timezone' => '<p>The time zone of the DB instance.</p>', 'CreateDBInstanceMessage$PerformanceInsightsKMSKeyId' => '<p> <i>(Not supported by Neptune)</i> </p>', 'CreateDBParameterGroupMessage$DBParameterGroupName' => '<p>The name of the DB parameter group.</p> <p>Constraints:</p> <ul> <li> <p>Must be 1 to 255 letters, numbers, or hyphens.</p> </li> <li> <p>First character must be a letter</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li> </ul> <note> <p>This value is stored as a lowercase string.</p> </note>', 'CreateDBParameterGroupMessage$DBParameterGroupFamily' => '<p>The DB parameter group family name. A DB parameter group can be associated with one and only one DB parameter group family, and can be applied only to a DB instance running a database engine and engine version compatible with that DB parameter group family.</p>', 'CreateDBParameterGroupMessage$Description' => '<p>The description for the DB parameter group.</p>', 'CreateDBSubnetGroupMessage$DBSubnetGroupName' => '<p>The name for the DB subnet group. This value is stored as a lowercase string.</p> <p>Constraints: Must contain no more than 255 letters, numbers, periods, underscores, spaces, or hyphens. Must not be default.</p> <p>Example: <code>mySubnetgroup</code> </p>', 'CreateDBSubnetGroupMessage$DBSubnetGroupDescription' => '<p>The description for the DB subnet group.</p>', 'CreateEventSubscriptionMessage$SubscriptionName' => '<p>The name of the subscription.</p> <p>Constraints: The name must be less than 255 characters.</p>', 'CreateEventSubscriptionMessage$SnsTopicArn' => '<p>The Amazon Resource Name (ARN) of the SNS topic created for event notification. The ARN is created by Amazon SNS when you create a topic and subscribe to it.</p>', 'CreateEventSubscriptionMessage$SourceType' => '<p>The type of source that is generating the events. For example, if you want to be notified of events generated by a DB instance, you would set this parameter to db-instance. if this value is not specified, all events are returned.</p> <p>Valid values: <code>db-instance</code> | <code>db-cluster</code> | <code>db-parameter-group</code> | <code>db-security-group</code> | <code>db-snapshot</code> | <code>db-cluster-snapshot</code> </p>', 'CreateGlobalClusterMessage$SourceDBClusterIdentifier' => '<p>(<i>Optional</i>) The Amazon Resource Name (ARN) of an existing Neptune DB cluster to use as the primary cluster of the new global database.</p>', 'CreateGlobalClusterMessage$Engine' => '<p>The name of the database engine to be used in the global database.</p> <p>Valid values: <code>neptune</code> </p>', 'CreateGlobalClusterMessage$EngineVersion' => '<p>The Neptune engine version to be used by the global database.</p> <p>Valid values: <code>1.2.0.0</code> or above.</p>', 'DBCluster$CharacterSetName' => '<p>Not supported by Neptune.</p>', 'DBCluster$DatabaseName' => '<p>Contains the name of the initial database of this DB cluster that was provided at create time, if one was specified when the DB cluster was created. This same name is returned for the life of the DB cluster.</p>', 'DBCluster$DBClusterIdentifier' => '<p>Contains a user-supplied DB cluster identifier. This identifier is the unique key that identifies a DB cluster.</p>', 'DBCluster$DBClusterParameterGroup' => '<p>Specifies the name of the DB cluster parameter group for the DB cluster.</p>', 'DBCluster$DBSubnetGroup' => '<p>Specifies information on the subnet group associated with the DB cluster, including the name, description, and subnets in the subnet group.</p>', 'DBCluster$Status' => '<p>Specifies the current state of this DB cluster.</p>', 'DBCluster$PercentProgress' => '<p>Specifies the progress of the operation as a percentage.</p>', 'DBCluster$Endpoint' => '<p>Specifies the connection endpoint for the primary instance of the DB cluster.</p>', 'DBCluster$ReaderEndpoint' => '<p>The reader endpoint for the DB cluster. The reader endpoint for a DB cluster load-balances connections across the Read Replicas that are available in a DB cluster. As clients request new connections to the reader endpoint, Neptune distributes the connection requests among the Read Replicas in the DB cluster. This functionality can help balance your read workload across multiple Read Replicas in your DB cluster.</p> <p>If a failover occurs, and the Read Replica that you are connected to is promoted to be the primary instance, your connection is dropped. To continue sending your read workload to other Read Replicas in the cluster, you can then reconnect to the reader endpoint.</p>', 'DBCluster$Engine' => '<p>Provides the name of the database engine to be used for this DB cluster.</p>', 'DBCluster$EngineVersion' => '<p>Indicates the database engine version.</p>', 'DBCluster$MasterUsername' => '<p>Not supported by Neptune.</p>', 'DBCluster$PreferredBackupWindow' => '<p>Specifies the daily time range during which automated backups are created if automated backups are enabled, as determined by the <code>BackupRetentionPeriod</code>.</p>', 'DBCluster$PreferredMaintenanceWindow' => '<p>Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p>', 'DBCluster$ReplicationSourceIdentifier' => '<p>Not supported by Neptune.</p>', 'DBCluster$HostedZoneId' => '<p>Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.</p>', 'DBCluster$KmsKeyId' => '<p>If <code>StorageEncrypted</code> is true, the Amazon KMS key identifier for the encrypted DB cluster.</p>', 'DBCluster$DbClusterResourceId' => '<p>The Amazon Region-unique, immutable identifier for the DB cluster. This identifier is found in Amazon CloudTrail log entries whenever the Amazon KMS key for the DB cluster is accessed.</p>', 'DBCluster$DBClusterArn' => '<p>The Amazon Resource Name (ARN) for the DB cluster.</p>', 'DBCluster$CloneGroupId' => '<p>Identifies the clone group to which the DB cluster is associated.</p>', 'DBCluster$StorageType' => '<p>The storage type associated with the DB cluster.</p>', 'DBClusterEndpoint$DBClusterEndpointIdentifier' => '<p>The identifier associated with the endpoint. This parameter is stored as a lowercase string.</p>', 'DBClusterEndpoint$DBClusterIdentifier' => '<p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a lowercase string.</p>', 'DBClusterEndpoint$DBClusterEndpointResourceIdentifier' => '<p>A unique system-generated identifier for an endpoint. It remains the same for the whole life of the endpoint.</p>', 'DBClusterEndpoint$Endpoint' => '<p>The DNS address of the endpoint.</p>', 'DBClusterEndpoint$Status' => '<p>The current status of the endpoint. One of: <code>creating</code>, <code>available</code>, <code>deleting</code>, <code>inactive</code>, <code>modifying</code>. The <code>inactive</code> state applies to an endpoint that cannot be used for a certain kind of cluster, such as a <code>writer</code> endpoint for a read-only secondary cluster in a global database.</p>', 'DBClusterEndpoint$EndpointType' => '<p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>CUSTOM</code>.</p>', 'DBClusterEndpoint$CustomEndpointType' => '<p>The type associated with a custom endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.</p>', 'DBClusterEndpoint$DBClusterEndpointArn' => '<p>The Amazon Resource Name (ARN) for the endpoint.</p>', 'DBClusterEndpointMessage$Marker' => '<p> An optional pagination token provided by a previous <code>DescribeDBClusterEndpoints</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DBClusterMember$DBInstanceIdentifier' => '<p>Specifies the instance identifier for this member of the DB cluster.</p>', 'DBClusterMember$DBClusterParameterGroupStatus' => '<p>Specifies the status of the DB cluster parameter group for this member of the DB cluster.</p>', 'DBClusterMessage$Marker' => '<p>A pagination token that can be used in a subsequent DescribeDBClusters request.</p>', 'DBClusterOptionGroupStatus$DBClusterOptionGroupName' => '<p>Not supported by Neptune.</p>', 'DBClusterOptionGroupStatus$Status' => '<p>Not supported by Neptune.</p>', 'DBClusterParameterGroup$DBClusterParameterGroupName' => '<p>Provides the name of the DB cluster parameter group.</p>', 'DBClusterParameterGroup$DBParameterGroupFamily' => '<p>Provides the name of the DB parameter group family that this DB cluster parameter group is compatible with.</p>', 'DBClusterParameterGroup$Description' => '<p>Provides the customer-specified description for this DB cluster parameter group.</p>', 'DBClusterParameterGroup$DBClusterParameterGroupArn' => '<p>The Amazon Resource Name (ARN) for the DB cluster parameter group.</p>', 'DBClusterParameterGroupDetails$Marker' => '<p> An optional pagination token provided by a previous DescribeDBClusterParameters request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> .</p>', 'DBClusterParameterGroupNameMessage$DBClusterParameterGroupName' => '<p>The name of the DB cluster parameter group.</p> <p>Constraints:</p> <ul> <li> <p>Must be 1 to 255 letters or numbers.</p> </li> <li> <p>First character must be a letter</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li> </ul> <note> <p>This value is stored as a lowercase string.</p> </note>', 'DBClusterParameterGroupsMessage$Marker' => '<p> An optional pagination token provided by a previous <code>DescribeDBClusterParameterGroups</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DBClusterRole$RoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that is associated with the DB cluster.</p>', 'DBClusterRole$Status' => '<p>Describes the state of association between the IAM role and the DB cluster. The Status property returns one of the following values:</p> <ul> <li> <p> <code>ACTIVE</code> - the IAM role ARN is associated with the DB cluster and can be used to access other Amazon services on your behalf.</p> </li> <li> <p> <code>PENDING</code> - the IAM role ARN is being associated with the DB cluster.</p> </li> <li> <p> <code>INVALID</code> - the IAM role ARN is associated with the DB cluster, but the DB cluster is unable to assume the IAM role in order to access other Amazon services on your behalf.</p> </li> </ul>', 'DBClusterRole$FeatureName' => '<p>The name of the feature associated with the Amazon Identity and Access Management (IAM) role. For the list of supported feature names, see <a>DescribeDBEngineVersions</a>. </p>', 'DBClusterSnapshot$DBClusterSnapshotIdentifier' => '<p>Specifies the identifier for a DB cluster snapshot. Must match the identifier of an existing snapshot.</p> <p>After you restore a DB cluster using a <code>DBClusterSnapshotIdentifier</code>, you must specify the same <code>DBClusterSnapshotIdentifier</code> for any future updates to the DB cluster. When you specify this property for an update, the DB cluster is not restored from the snapshot again, and the data in the database is not changed.</p> <p>However, if you don\'t specify the <code>DBClusterSnapshotIdentifier</code>, an empty DB cluster is created, and the original DB cluster is deleted. If you specify a property that is different from the previous snapshot restore property, the DB cluster is restored from the snapshot specified by the <code>DBClusterSnapshotIdentifier</code>, and the original DB cluster is deleted.</p>', 'DBClusterSnapshot$DBClusterIdentifier' => '<p>Specifies the DB cluster identifier of the DB cluster that this DB cluster snapshot was created from.</p>', 'DBClusterSnapshot$Engine' => '<p>Specifies the name of the database engine.</p>', 'DBClusterSnapshot$Status' => '<p>Specifies the status of this DB cluster snapshot.</p>', 'DBClusterSnapshot$VpcId' => '<p>Provides the VPC ID associated with the DB cluster snapshot.</p>', 'DBClusterSnapshot$MasterUsername' => '<p>Not supported by Neptune.</p>', 'DBClusterSnapshot$EngineVersion' => '<p>Provides the version of the database engine for this DB cluster snapshot.</p>', 'DBClusterSnapshot$LicenseModel' => '<p>Provides the license model information for this DB cluster snapshot.</p>', 'DBClusterSnapshot$SnapshotType' => '<p>Provides the type of the DB cluster snapshot.</p>', 'DBClusterSnapshot$KmsKeyId' => '<p>If <code>StorageEncrypted</code> is true, the Amazon KMS key identifier for the encrypted DB cluster snapshot.</p>', 'DBClusterSnapshot$DBClusterSnapshotArn' => '<p>The Amazon Resource Name (ARN) for the DB cluster snapshot.</p>', 'DBClusterSnapshot$SourceDBClusterSnapshotArn' => '<p>If the DB cluster snapshot was copied from a source DB cluster snapshot, the Amazon Resource Name (ARN) for the source DB cluster snapshot, otherwise, a null value.</p>', 'DBClusterSnapshot$StorageType' => '<p>The storage type associated with the DB cluster snapshot.</p>', 'DBClusterSnapshotAttribute$AttributeName' => '<p>The name of the manual DB cluster snapshot attribute.</p> <p>The attribute named <code>restore</code> refers to the list of Amazon accounts that have permission to copy or restore the manual DB cluster snapshot. For more information, see the <a>ModifyDBClusterSnapshotAttribute</a> API action.</p>', 'DBClusterSnapshotAttributesResult$DBClusterSnapshotIdentifier' => '<p>The identifier of the manual DB cluster snapshot that the attributes apply to.</p>', 'DBClusterSnapshotMessage$Marker' => '<p> An optional pagination token provided by a previous <a>DescribeDBClusterSnapshots</a> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DBEngineVersion$Engine' => '<p>The name of the database engine.</p>', 'DBEngineVersion$EngineVersion' => '<p>The version number of the database engine.</p>', 'DBEngineVersion$DBParameterGroupFamily' => '<p>The name of the DB parameter group family for the database engine.</p>', 'DBEngineVersion$DBEngineDescription' => '<p>The description of the database engine.</p>', 'DBEngineVersion$DBEngineVersionDescription' => '<p>The description of the database engine version.</p>', 'DBEngineVersionMessage$Marker' => '<p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DBInstance$DBInstanceIdentifier' => '<p>Contains a user-supplied database identifier. This identifier is the unique key that identifies a DB instance.</p>', 'DBInstance$DBInstanceClass' => '<p>Contains the name of the compute and memory capacity class of the DB instance.</p>', 'DBInstance$Engine' => '<p>Provides the name of the database engine to be used for this DB instance.</p>', 'DBInstance$DBInstanceStatus' => '<p>Specifies the current state of this database.</p>', 'DBInstance$MasterUsername' => '<p>Not supported by Neptune.</p>', 'DBInstance$DBName' => '<p>The database name.</p>', 'DBInstance$PreferredBackupWindow' => '<p> Specifies the daily time range during which automated backups are created if automated backups are enabled, as determined by the <code>BackupRetentionPeriod</code>.</p>', 'DBInstance$AvailabilityZone' => '<p>Specifies the name of the Availability Zone the DB instance is located in.</p>', 'DBInstance$PreferredMaintenanceWindow' => '<p>Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p>', 'DBInstance$EngineVersion' => '<p>Indicates the database engine version.</p>', 'DBInstance$ReadReplicaSourceDBInstanceIdentifier' => '<p>Contains the identifier of the source DB instance if this DB instance is a Read Replica.</p>', 'DBInstance$LicenseModel' => '<p>License model information for this DB instance.</p>', 'DBInstance$CharacterSetName' => '<p> <i>(Not supported by Neptune)</i> </p>', 'DBInstance$SecondaryAvailabilityZone' => '<p>If present, specifies the name of the secondary Availability Zone for a DB instance with multi-AZ support.</p>', 'DBInstance$StorageType' => '<p>Specifies the storage type associated with DB instance.</p>', 'DBInstance$TdeCredentialArn' => '<p>The ARN from the key store with which the instance is associated for TDE encryption.</p>', 'DBInstance$DBClusterIdentifier' => '<p>If the DB instance is a member of a DB cluster, contains the name of the DB cluster that the DB instance is a member of.</p>', 'DBInstance$KmsKeyId' => '<p> Not supported: The encryption for DB instances is managed by the DB cluster.</p>', 'DBInstance$DbiResourceId' => '<p>The Amazon Region-unique, immutable identifier for the DB instance. This identifier is found in Amazon CloudTrail log entries whenever the Amazon KMS key for the DB instance is accessed.</p>', 'DBInstance$CACertificateIdentifier' => '<p>The identifier of the CA certificate for this DB instance.</p>', 'DBInstance$EnhancedMonitoringResourceArn' => '<p>The Amazon Resource Name (ARN) of the Amazon CloudWatch Logs log stream that receives the Enhanced Monitoring metrics data for the DB instance.</p>', 'DBInstance$MonitoringRoleArn' => '<p>The ARN for the IAM role that permits Neptune to send Enhanced Monitoring metrics to Amazon CloudWatch Logs.</p>', 'DBInstance$DBInstanceArn' => '<p>The Amazon Resource Name (ARN) for the DB instance.</p>', 'DBInstance$Timezone' => '<p>Not supported.</p>', 'DBInstance$PerformanceInsightsKMSKeyId' => '<p> <i>(Not supported by Neptune)</i> </p>', 'DBInstanceMessage$Marker' => '<p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> .</p>', 'DBInstanceStatusInfo$StatusType' => '<p>This value is currently "read replication."</p>', 'DBInstanceStatusInfo$Status' => '<p>Status of the DB instance. For a StatusType of read replica, the values can be replicating, error, stopped, or terminated.</p>', 'DBInstanceStatusInfo$Message' => '<p>Details of the error if there is an error for the instance. If the instance is not in an error state, this value is blank.</p>', 'DBParameterGroup$DBParameterGroupName' => '<p>Provides the name of the DB parameter group.</p>', 'DBParameterGroup$DBParameterGroupFamily' => '<p>Provides the name of the DB parameter group family that this DB parameter group is compatible with.</p>', 'DBParameterGroup$Description' => '<p>Provides the customer-specified description for this DB parameter group.</p>', 'DBParameterGroup$DBParameterGroupArn' => '<p>The Amazon Resource Name (ARN) for the DB parameter group.</p>', 'DBParameterGroupDetails$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DBParameterGroupNameMessage$DBParameterGroupName' => '<p>Provides the name of the DB parameter group.</p>', 'DBParameterGroupStatus$DBParameterGroupName' => '<p>The name of the DP parameter group.</p>', 'DBParameterGroupStatus$ParameterApplyStatus' => '<p>The status of parameter updates.</p>', 'DBParameterGroupsMessage$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DBSecurityGroupMembership$DBSecurityGroupName' => '<p>The name of the DB security group.</p>', 'DBSecurityGroupMembership$Status' => '<p>The status of the DB security group.</p>', 'DBSecurityGroupNameList$member' => NULL, 'DBSubnetGroup$DBSubnetGroupName' => '<p>The name of the DB subnet group.</p>', 'DBSubnetGroup$DBSubnetGroupDescription' => '<p>Provides the description of the DB subnet group.</p>', 'DBSubnetGroup$VpcId' => '<p>Provides the VpcId of the DB subnet group.</p>', 'DBSubnetGroup$SubnetGroupStatus' => '<p>Provides the status of the DB subnet group.</p>', 'DBSubnetGroup$DBSubnetGroupArn' => '<p>The Amazon Resource Name (ARN) for the DB subnet group.</p>', 'DBSubnetGroupMessage$Marker' => '<p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DeleteDBClusterEndpointMessage$DBClusterEndpointIdentifier' => '<p>The identifier associated with the custom endpoint. This parameter is stored as a lowercase string.</p>', 'DeleteDBClusterEndpointOutput$DBClusterEndpointIdentifier' => '<p>The identifier associated with the endpoint. This parameter is stored as a lowercase string.</p>', 'DeleteDBClusterEndpointOutput$DBClusterIdentifier' => '<p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a lowercase string.</p>', 'DeleteDBClusterEndpointOutput$DBClusterEndpointResourceIdentifier' => '<p>A unique system-generated identifier for an endpoint. It remains the same for the whole life of the endpoint.</p>', 'DeleteDBClusterEndpointOutput$Endpoint' => '<p>The DNS address of the endpoint.</p>', 'DeleteDBClusterEndpointOutput$Status' => '<p>The current status of the endpoint. One of: <code>creating</code>, <code>available</code>, <code>deleting</code>, <code>inactive</code>, <code>modifying</code>. The <code>inactive</code> state applies to an endpoint that cannot be used for a certain kind of cluster, such as a <code>writer</code> endpoint for a read-only secondary cluster in a global database.</p>', 'DeleteDBClusterEndpointOutput$EndpointType' => '<p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>CUSTOM</code>.</p>', 'DeleteDBClusterEndpointOutput$CustomEndpointType' => '<p>The type associated with a custom endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.</p>', 'DeleteDBClusterEndpointOutput$DBClusterEndpointArn' => '<p>The Amazon Resource Name (ARN) for the endpoint.</p>', 'DeleteDBClusterMessage$DBClusterIdentifier' => '<p>The DB cluster identifier for the DB cluster to be deleted. This parameter isn\'t case-sensitive.</p> <p>Constraints:</p> <ul> <li> <p>Must match an existing DBClusterIdentifier.</p> </li> </ul>', 'DeleteDBClusterMessage$FinalDBSnapshotIdentifier' => '<p> The DB cluster snapshot identifier of the new DB cluster snapshot created when <code>SkipFinalSnapshot</code> is set to <code>false</code>.</p> <note> <p> Specifying this parameter and also setting the <code>SkipFinalShapshot</code> parameter to true results in an error.</p> </note> <p>Constraints:</p> <ul> <li> <p>Must be 1 to 255 letters, numbers, or hyphens.</p> </li> <li> <p>First character must be a letter</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li> </ul>', 'DeleteDBClusterParameterGroupMessage$DBClusterParameterGroupName' => '<p>The name of the DB cluster parameter group.</p> <p>Constraints:</p> <ul> <li> <p>Must be the name of an existing DB cluster parameter group.</p> </li> <li> <p>You can\'t delete a default DB cluster parameter group.</p> </li> <li> <p>Cannot be associated with any DB clusters.</p> </li> </ul>', 'DeleteDBClusterSnapshotMessage$DBClusterSnapshotIdentifier' => '<p>The identifier of the DB cluster snapshot to delete.</p> <p>Constraints: Must be the name of an existing DB cluster snapshot in the <code>available</code> state.</p>', 'DeleteDBInstanceMessage$DBInstanceIdentifier' => '<p>The DB instance identifier for the DB instance to be deleted. This parameter isn\'t case-sensitive.</p> <p>Constraints:</p> <ul> <li> <p>Must match the name of an existing DB instance.</p> </li> </ul>', 'DeleteDBInstanceMessage$FinalDBSnapshotIdentifier' => '<p> The DBSnapshotIdentifier of the new DBSnapshot created when SkipFinalSnapshot is set to <code>false</code>.</p> <note> <p>Specifying this parameter and also setting the SkipFinalShapshot parameter to true results in an error.</p> </note> <p>Constraints:</p> <ul> <li> <p>Must be 1 to 255 letters or numbers.</p> </li> <li> <p>First character must be a letter</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li> <li> <p>Cannot be specified when deleting a Read Replica.</p> </li> </ul>', 'DeleteDBParameterGroupMessage$DBParameterGroupName' => '<p>The name of the DB parameter group.</p> <p>Constraints:</p> <ul> <li> <p>Must be the name of an existing DB parameter group</p> </li> <li> <p>You can\'t delete a default DB parameter group</p> </li> <li> <p>Cannot be associated with any DB instances</p> </li> </ul>', 'DeleteDBSubnetGroupMessage$DBSubnetGroupName' => '<p>The name of the database subnet group to delete.</p> <note> <p>You can\'t delete the default subnet group.</p> </note> <p>Constraints:</p> <p>Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.</p> <p>Example: <code>mySubnetgroup</code> </p>', 'DeleteEventSubscriptionMessage$SubscriptionName' => '<p>The name of the event notification subscription you want to delete.</p>', 'DescribeDBClusterEndpointsMessage$DBClusterIdentifier' => '<p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a lowercase string.</p>', 'DescribeDBClusterEndpointsMessage$DBClusterEndpointIdentifier' => '<p>The identifier of the endpoint to describe. This parameter is stored as a lowercase string.</p>', 'DescribeDBClusterEndpointsMessage$Marker' => '<p> An optional pagination token provided by a previous <code>DescribeDBClusterEndpoints</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DescribeDBClusterParameterGroupsMessage$DBClusterParameterGroupName' => '<p>The name of a specific DB cluster parameter group to return details for.</p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p> </li> </ul>', 'DescribeDBClusterParameterGroupsMessage$Marker' => '<p> An optional pagination token provided by a previous <code>DescribeDBClusterParameterGroups</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeDBClusterParametersMessage$DBClusterParameterGroupName' => '<p>The name of a specific DB cluster parameter group to return parameter details for.</p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p> </li> </ul>', 'DescribeDBClusterParametersMessage$Source' => '<p> A value that indicates to return only parameters for a specific source. Parameter sources can be <code>engine</code>, <code>service</code>, or <code>customer</code>.</p>', 'DescribeDBClusterParametersMessage$Marker' => '<p> An optional pagination token provided by a previous <code>DescribeDBClusterParameters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DescribeDBClusterSnapshotAttributesMessage$DBClusterSnapshotIdentifier' => '<p>The identifier for the DB cluster snapshot to describe the attributes for.</p>', 'DescribeDBClusterSnapshotsMessage$DBClusterIdentifier' => '<p>The ID of the DB cluster to retrieve the list of DB cluster snapshots for. This parameter can\'t be used in conjunction with the <code>DBClusterSnapshotIdentifier</code> parameter. This parameter is not case-sensitive.</p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match the identifier of an existing DBCluster.</p> </li> </ul>', 'DescribeDBClusterSnapshotsMessage$DBClusterSnapshotIdentifier' => '<p>A specific DB cluster snapshot identifier to describe. This parameter can\'t be used in conjunction with the <code>DBClusterIdentifier</code> parameter. This value is stored as a lowercase string.</p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match the identifier of an existing DBClusterSnapshot.</p> </li> <li> <p>If this identifier is for an automated snapshot, the <code>SnapshotType</code> parameter must also be specified.</p> </li> </ul>', 'DescribeDBClusterSnapshotsMessage$SnapshotType' => '<p>The type of DB cluster snapshots to be returned. You can specify one of the following values:</p> <ul> <li> <p> <code>automated</code> - Return all DB cluster snapshots that have been automatically taken by Amazon Neptune for my Amazon account.</p> </li> <li> <p> <code>manual</code> - Return all DB cluster snapshots that have been taken by my Amazon account.</p> </li> <li> <p> <code>shared</code> - Return all manual DB cluster snapshots that have been shared to my Amazon account.</p> </li> <li> <p> <code>public</code> - Return all DB cluster snapshots that have been marked as public.</p> </li> </ul> <p>If you don\'t specify a <code>SnapshotType</code> value, then both automated and manual DB cluster snapshots are returned. You can include shared DB cluster snapshots with these results by setting the <code>IncludeShared</code> parameter to <code>true</code>. You can include public DB cluster snapshots with these results by setting the <code>IncludePublic</code> parameter to <code>true</code>.</p> <p>The <code>IncludeShared</code> and <code>IncludePublic</code> parameters don\'t apply for <code>SnapshotType</code> values of <code>manual</code> or <code>automated</code>. The <code>IncludePublic</code> parameter doesn\'t apply when <code>SnapshotType</code> is set to <code>shared</code>. The <code>IncludeShared</code> parameter doesn\'t apply when <code>SnapshotType</code> is set to <code>public</code>.</p>', 'DescribeDBClusterSnapshotsMessage$Marker' => '<p>An optional pagination token provided by a previous <code>DescribeDBClusterSnapshots</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DescribeDBClustersMessage$DBClusterIdentifier' => '<p>The user-supplied DB cluster identifier. If this parameter is specified, information from only the specific DB cluster is returned. This parameter isn\'t case-sensitive.</p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match an existing DBClusterIdentifier.</p> </li> </ul>', 'DescribeDBClustersMessage$Marker' => '<p>An optional pagination token provided by a previous <a>DescribeDBClusters</a> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeDBEngineVersionsMessage$Engine' => '<p>The database engine to return.</p>', 'DescribeDBEngineVersionsMessage$EngineVersion' => '<p>The database engine version to return.</p> <p>Example: <code>5.1.49</code> </p>', 'DescribeDBEngineVersionsMessage$DBParameterGroupFamily' => '<p>The name of a specific DB parameter group family to return details for.</p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match an existing DBParameterGroupFamily.</p> </li> </ul>', 'DescribeDBEngineVersionsMessage$Marker' => '<p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeDBInstancesMessage$DBInstanceIdentifier' => '<p>The user-supplied instance identifier. If this parameter is specified, information from only the specific DB instance is returned. This parameter isn\'t case-sensitive.</p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match the identifier of an existing DBInstance.</p> </li> </ul>', 'DescribeDBInstancesMessage$Marker' => '<p> An optional pagination token provided by a previous <code>DescribeDBInstances</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeDBParameterGroupsMessage$DBParameterGroupName' => '<p>The name of a specific DB parameter group to return details for.</p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p> </li> </ul>', 'DescribeDBParameterGroupsMessage$Marker' => '<p>An optional pagination token provided by a previous <code>DescribeDBParameterGroups</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeDBParametersMessage$DBParameterGroupName' => '<p>The name of a specific DB parameter group to return details for.</p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match the name of an existing DBParameterGroup.</p> </li> </ul>', 'DescribeDBParametersMessage$Source' => '<p>The parameter types to return.</p> <p>Default: All parameter types returned</p> <p>Valid Values: <code>user | system | engine-default</code> </p>', 'DescribeDBParametersMessage$Marker' => '<p>An optional pagination token provided by a previous <code>DescribeDBParameters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeDBSubnetGroupsMessage$DBSubnetGroupName' => '<p>The name of the DB subnet group to return details for.</p>', 'DescribeDBSubnetGroupsMessage$Marker' => '<p> An optional pagination token provided by a previous DescribeDBSubnetGroups request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeEngineDefaultClusterParametersMessage$DBParameterGroupFamily' => '<p>The name of the DB cluster parameter group family to return engine parameter information for.</p>', 'DescribeEngineDefaultClusterParametersMessage$Marker' => '<p> An optional pagination token provided by a previous <code>DescribeEngineDefaultClusterParameters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeEngineDefaultParametersMessage$DBParameterGroupFamily' => '<p>The name of the DB parameter group family.</p>', 'DescribeEngineDefaultParametersMessage$Marker' => '<p> An optional pagination token provided by a previous <code>DescribeEngineDefaultParameters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeEventCategoriesMessage$SourceType' => '<p>The type of source that is generating the events.</p> <p>Valid values: db-instance | db-parameter-group | db-security-group | db-snapshot</p>', 'DescribeEventSubscriptionsMessage$SubscriptionName' => '<p>The name of the event notification subscription you want to describe.</p>', 'DescribeEventSubscriptionsMessage$Marker' => '<p> An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> .</p>', 'DescribeEventsMessage$SourceIdentifier' => '<p>The identifier of the event source for which events are returned. If not specified, then all sources are included in the response.</p> <p>Constraints:</p> <ul> <li> <p>If SourceIdentifier is supplied, SourceType must also be provided.</p> </li> <li> <p>If the source type is <code>DBInstance</code>, then a <code>DBInstanceIdentifier</code> must be supplied.</p> </li> <li> <p>If the source type is <code>DBSecurityGroup</code>, a <code>DBSecurityGroupName</code> must be supplied.</p> </li> <li> <p>If the source type is <code>DBParameterGroup</code>, a <code>DBParameterGroupName</code> must be supplied.</p> </li> <li> <p>If the source type is <code>DBSnapshot</code>, a <code>DBSnapshotIdentifier</code> must be supplied.</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li> </ul>', 'DescribeEventsMessage$Marker' => '<p> An optional pagination token provided by a previous DescribeEvents request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeGlobalClustersMessage$Marker' => '<p>(<i>Optional</i>) A pagination token returned by a previous call to <code>DescribeGlobalClusters</code>. If this parameter is specified, the response will only include records beyond the marker, up to the number specified by <code>MaxRecords</code>.</p>', 'DescribeOrderableDBInstanceOptionsMessage$Engine' => '<p>The name of the engine to retrieve DB instance options for.</p>', 'DescribeOrderableDBInstanceOptionsMessage$EngineVersion' => '<p>The engine version filter value. Specify this parameter to show only the available offerings matching the specified engine version.</p>', 'DescribeOrderableDBInstanceOptionsMessage$DBInstanceClass' => '<p>The DB instance class filter value. Specify this parameter to show only the available offerings matching the specified DB instance class.</p>', 'DescribeOrderableDBInstanceOptionsMessage$LicenseModel' => '<p>The license model filter value. Specify this parameter to show only the available offerings matching the specified license model.</p>', 'DescribeOrderableDBInstanceOptionsMessage$Marker' => '<p> An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> .</p>', 'DescribePendingMaintenanceActionsMessage$ResourceIdentifier' => '<p>The ARN of a resource to return pending maintenance actions for.</p>', 'DescribePendingMaintenanceActionsMessage$Marker' => '<p> An optional pagination token provided by a previous <code>DescribePendingMaintenanceActions</code> request. If this parameter is specified, the response includes only records beyond the marker, up to a number of records specified by <code>MaxRecords</code>.</p>', 'DescribeValidDBInstanceModificationsMessage$DBInstanceIdentifier' => '<p>The customer identifier or the ARN of your DB instance.</p>', 'DomainMembership$Domain' => '<p>The identifier of the Active Directory Domain.</p>', 'DomainMembership$Status' => '<p>The status of the DB instance\'s Active Directory Domain membership, such as joined, pending-join, failed etc).</p>', 'DomainMembership$FQDN' => '<p>The fully qualified domain name of the Active Directory Domain.</p>', 'DomainMembership$IAMRoleName' => '<p>The name of the IAM role to be used when making API calls to the Directory Service.</p>', 'Endpoint$Address' => '<p>Specifies the DNS address of the DB instance.</p>', 'Endpoint$HostedZoneId' => '<p>Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.</p>', 'EngineDefaults$DBParameterGroupFamily' => '<p>Specifies the name of the DB parameter group family that the engine default parameters apply to.</p>', 'EngineDefaults$Marker' => '<p> An optional pagination token provided by a previous EngineDefaults request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> .</p>', 'Event$SourceIdentifier' => '<p>Provides the identifier for the source of the event.</p>', 'Event$Message' => '<p>Provides the text of this event.</p>', 'Event$SourceArn' => '<p>The Amazon Resource Name (ARN) for the event.</p>', 'EventCategoriesList$member' => NULL, 'EventCategoriesMap$SourceType' => '<p>The source type that the returned categories belong to</p>', 'EventSubscription$CustomerAwsId' => '<p>The Amazon customer account associated with the event notification subscription.</p>', 'EventSubscription$CustSubscriptionId' => '<p>The event notification subscription Id.</p>', 'EventSubscription$SnsTopicArn' => '<p>The topic ARN of the event notification subscription.</p>', 'EventSubscription$Status' => '<p>The status of the event notification subscription.</p> <p>Constraints:</p> <p>Can be one of the following: creating | modifying | deleting | active | no-permission | topic-not-exist</p> <p>The status "no-permission" indicates that Neptune no longer has permission to post to the SNS topic. The status "topic-not-exist" indicates that the topic was deleted after the subscription was created.</p>', 'EventSubscription$SubscriptionCreationTime' => '<p>The time the event notification subscription was created.</p>', 'EventSubscription$SourceType' => '<p>The source type for the event notification subscription.</p>', 'EventSubscription$EventSubscriptionArn' => '<p>The Amazon Resource Name (ARN) for the event subscription.</p>', 'EventSubscriptionsMessage$Marker' => '<p> An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'EventsMessage$Marker' => '<p> An optional pagination token provided by a previous Events request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> .</p>', 'FailoverDBClusterMessage$DBClusterIdentifier' => '<p>A DB cluster identifier to force a failover for. This parameter is not case-sensitive.</p> <p>Constraints:</p> <ul> <li> <p>Must match the identifier of an existing DBCluster.</p> </li> </ul>', 'FailoverDBClusterMessage$TargetDBInstanceIdentifier' => '<p>The name of the instance to promote to the primary instance.</p> <p>You must specify the instance identifier for an Read Replica in the DB cluster. For example, <code>mydbcluster-replica1</code>.</p>', 'FailoverGlobalClusterMessage$TargetDbClusterIdentifier' => '<p>The Amazon Resource Name (ARN) of the secondary Neptune DB cluster that you want to promote to primary for the global database.</p>', 'Filter$Name' => '<p>This parameter is not currently supported.</p>', 'FilterValueList$member' => NULL, 'GlobalCluster$GlobalClusterResourceId' => '<p>An immutable identifier for the global database that is unique within in all regions. This identifier is found in CloudTrail log entries whenever the KMS key for the DB cluster is accessed.</p>', 'GlobalCluster$GlobalClusterArn' => '<p>The Amazon Resource Name (ARN) for the global database.</p>', 'GlobalCluster$Status' => '<p>Specifies the current state of this global database.</p>', 'GlobalCluster$Engine' => '<p>The Neptune database engine used by the global database (<code>"neptune"</code>).</p>', 'GlobalCluster$EngineVersion' => '<p>The Neptune engine version used by the global database.</p>', 'GlobalClusterMember$DBClusterArn' => '<p> The Amazon Resource Name (ARN) for each Neptune cluster. </p>', 'GlobalClustersMessage$Marker' => '<p>A pagination token. If this parameter is returned in the response, more records are available, which can be retrieved by one or more additional calls to <code>DescribeGlobalClusters</code>.</p>', 'KeyList$member' => NULL, 'ListTagsForResourceMessage$ResourceName' => '<p>The Amazon Neptune resource with tags to be listed. This value is an Amazon Resource Name (ARN). For information about creating an ARN, see <a href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing"> Constructing an Amazon Resource Name (ARN)</a>.</p>', 'LogTypeList$member' => NULL, 'ModifyDBClusterEndpointMessage$DBClusterEndpointIdentifier' => '<p>The identifier of the endpoint to modify. This parameter is stored as a lowercase string.</p>', 'ModifyDBClusterEndpointMessage$EndpointType' => '<p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.</p>', 'ModifyDBClusterEndpointOutput$DBClusterEndpointIdentifier' => '<p>The identifier associated with the endpoint. This parameter is stored as a lowercase string.</p>', 'ModifyDBClusterEndpointOutput$DBClusterIdentifier' => '<p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a lowercase string.</p>', 'ModifyDBClusterEndpointOutput$DBClusterEndpointResourceIdentifier' => '<p>A unique system-generated identifier for an endpoint. It remains the same for the whole life of the endpoint.</p>', 'ModifyDBClusterEndpointOutput$Endpoint' => '<p>The DNS address of the endpoint.</p>', 'ModifyDBClusterEndpointOutput$Status' => '<p>The current status of the endpoint. One of: <code>creating</code>, <code>available</code>, <code>deleting</code>, <code>inactive</code>, <code>modifying</code>. The <code>inactive</code> state applies to an endpoint that cannot be used for a certain kind of cluster, such as a <code>writer</code> endpoint for a read-only secondary cluster in a global database.</p>', 'ModifyDBClusterEndpointOutput$EndpointType' => '<p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>CUSTOM</code>.</p>', 'ModifyDBClusterEndpointOutput$CustomEndpointType' => '<p>The type associated with a custom endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.</p>', 'ModifyDBClusterEndpointOutput$DBClusterEndpointArn' => '<p>The Amazon Resource Name (ARN) for the endpoint.</p>', 'ModifyDBClusterMessage$DBClusterIdentifier' => '<p>The DB cluster identifier for the cluster being modified. This parameter is not case-sensitive.</p> <p>Constraints:</p> <ul> <li> <p>Must match the identifier of an existing DBCluster.</p> </li> </ul>', 'ModifyDBClusterMessage$NewDBClusterIdentifier' => '<p>The new DB cluster identifier for the DB cluster when renaming a DB cluster. This value is stored as a lowercase string.</p> <p>Constraints:</p> <ul> <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens</p> </li> <li> <p>The first character must be a letter</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li> </ul> <p>Example: <code>my-cluster2</code> </p>', 'ModifyDBClusterMessage$DBClusterParameterGroupName' => '<p>The name of the DB cluster parameter group to use for the DB cluster.</p>', 'ModifyDBClusterMessage$MasterUserPassword' => '<p>Not supported by Neptune.</p>', 'ModifyDBClusterMessage$OptionGroupName' => '<p> <i>Not supported by Neptune.</i> </p>', 'ModifyDBClusterMessage$PreferredBackupWindow' => '<p>The daily time range during which automated backups are created if automated backups are enabled, using the <code>BackupRetentionPeriod</code> parameter.</p> <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Region.</p> <p>Constraints:</p> <ul> <li> <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p> </li> <li> <p>Must be in Universal Coordinated Time (UTC).</p> </li> <li> <p>Must not conflict with the preferred maintenance window.</p> </li> <li> <p>Must be at least 30 minutes.</p> </li> </ul>', 'ModifyDBClusterMessage$PreferredMaintenanceWindow' => '<p>The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p> <p>Format: <code>ddd:hh24:mi-ddd:hh24:mi</code> </p> <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Region, occurring on a random day of the week.</p> <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.</p> <p>Constraints: Minimum 30-minute window.</p>', 'ModifyDBClusterMessage$EngineVersion' => '<p>The version number of the database engine to which you want to upgrade. Changing this parameter results in an outage. The change is applied during the next maintenance window unless the <code>ApplyImmediately</code> parameter is set to true.</p> <p>For a list of valid engine versions, see <a href="https://docs.aws.amazon.com/neptune/latest/userguide/engine-releases.html">Engine Releases for Amazon Neptune</a>, or call <a>DescribeDBEngineVersions</a>.</p>', 'ModifyDBClusterMessage$DBInstanceParameterGroupName' => '<p>The name of the DB parameter group to apply to all instances of the DB cluster. </p> <note> <p>When you apply a parameter group using <code>DBInstanceParameterGroupName</code>, parameter changes aren\'t applied during the next maintenance window but instead are applied immediately.</p> </note> <p>Default: The existing name setting</p> <p>Constraints:</p> <ul> <li> <p>The DB parameter group must be in the same DB parameter group family as the target DB cluster version.</p> </li> <li> <p>The <code>DBInstanceParameterGroupName</code> parameter is only valid in combination with the <code>AllowMajorVersionUpgrade</code> parameter.</p> </li> </ul>', 'ModifyDBClusterMessage$StorageType' => '<p>The storage type to associate with the DB cluster.</p> <p>Valid Values:</p> <ul> <li> <p> <code>standard | iopt1</code> </p> </li> </ul> <p>Default:</p> <ul> <li> <p> <code>standard</code> </p> </li> </ul>', 'ModifyDBClusterParameterGroupMessage$DBClusterParameterGroupName' => '<p>The name of the DB cluster parameter group to modify.</p>', 'ModifyDBClusterSnapshotAttributeMessage$DBClusterSnapshotIdentifier' => '<p>The identifier for the DB cluster snapshot to modify the attributes for.</p>', 'ModifyDBClusterSnapshotAttributeMessage$AttributeName' => '<p>The name of the DB cluster snapshot attribute to modify.</p> <p>To manage authorization for other Amazon accounts to copy or restore a manual DB cluster snapshot, set this value to <code>restore</code>.</p>', 'ModifyDBInstanceMessage$DBInstanceIdentifier' => '<p>The DB instance identifier. This value is stored as a lowercase string.</p> <p>Constraints:</p> <ul> <li> <p>Must match the identifier of an existing DBInstance.</p> </li> </ul>', 'ModifyDBInstanceMessage$DBInstanceClass' => '<p>The new compute and memory capacity of the DB instance, for example, <code>db.m4.large</code>. Not all DB instance classes are available in all Amazon Regions.</p> <p>If you modify the DB instance class, an outage occurs during the change. The change is applied during the next maintenance window, unless <code>ApplyImmediately</code> is specified as <code>true</code> for this request.</p> <p>Default: Uses existing setting</p>', 'ModifyDBInstanceMessage$DBSubnetGroupName' => '<p>The new DB subnet group for the DB instance. You can use this parameter to move your DB instance to a different VPC.</p> <p>Changing the subnet group causes an outage during the change. The change is applied during the next maintenance window, unless you specify <code>true</code> for the <code>ApplyImmediately</code> parameter.</p> <p>Constraints: If supplied, must match the name of an existing DBSubnetGroup.</p> <p>Example: <code>mySubnetGroup</code> </p>', 'ModifyDBInstanceMessage$MasterUserPassword' => '<p>Not supported by Neptune.</p>', 'ModifyDBInstanceMessage$DBParameterGroupName' => '<p>The name of the DB parameter group to apply to the DB instance. Changing this setting doesn\'t result in an outage. The parameter group name itself is changed immediately, but the actual parameter changes are not applied until you reboot the instance without failover. The db instance will NOT be rebooted automatically and the parameter changes will NOT be applied during the next maintenance window.</p> <p>Default: Uses existing setting</p> <p>Constraints: The DB parameter group must be in the same DB parameter group family as this DB instance.</p>', 'ModifyDBInstanceMessage$PreferredBackupWindow' => '<p> The daily time range during which automated backups are created if automated backups are enabled.</p> <p>Not applicable. The daily time range for creating automated backups is managed by the DB cluster. For more information, see <a>ModifyDBCluster</a>.</p> <p>Constraints:</p> <ul> <li> <p>Must be in the format hh24:mi-hh24:mi</p> </li> <li> <p>Must be in Universal Time Coordinated (UTC)</p> </li> <li> <p>Must not conflict with the preferred maintenance window</p> </li> <li> <p>Must be at least 30 minutes</p> </li> </ul>', 'ModifyDBInstanceMessage$PreferredMaintenanceWindow' => '<p>The weekly time range (in UTC) during which system maintenance can occur, which might result in an outage. Changing this parameter doesn\'t result in an outage, except in the following situation, and the change is asynchronously applied as soon as possible. If there are pending actions that cause a reboot, and the maintenance window is changed to include the current time, then changing this parameter will cause a reboot of the DB instance. If moving this window to the current time, there must be at least 30 minutes between the current time and end of the window to ensure pending changes are applied.</p> <p>Default: Uses existing setting</p> <p>Format: ddd:hh24:mi-ddd:hh24:mi</p> <p>Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun</p> <p>Constraints: Must be at least 30 minutes</p>', 'ModifyDBInstanceMessage$EngineVersion' => '<p>The version number of the database engine to upgrade to. Currently, setting this parameter has no effect. To upgrade your database engine to the most recent release, use the <a>ApplyPendingMaintenanceAction</a> API.</p>', 'ModifyDBInstanceMessage$LicenseModel' => '<p>Not supported by Neptune.</p>', 'ModifyDBInstanceMessage$OptionGroupName' => '<p> <i>(Not supported by Neptune)</i> </p>', 'ModifyDBInstanceMessage$NewDBInstanceIdentifier' => '<p> The new DB instance identifier for the DB instance when renaming a DB instance. When you change the DB instance identifier, an instance reboot will occur immediately if you set <code>Apply Immediately</code> to true, or will occur during the next maintenance window if <code>Apply Immediately</code> to false. This value is stored as a lowercase string.</p> <p>Constraints:</p> <ul> <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li> <li> <p>The first character must be a letter.</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li> </ul> <p>Example: <code>mydbinstance</code> </p>', 'ModifyDBInstanceMessage$StorageType' => '<p>Not supported.</p>', 'ModifyDBInstanceMessage$TdeCredentialArn' => '<p>The ARN from the key store with which to associate the instance for TDE encryption.</p>', 'ModifyDBInstanceMessage$CACertificateIdentifier' => '<p>Indicates the certificate that needs to be associated with the instance.</p>', 'ModifyDBInstanceMessage$Domain' => '<p>Not supported.</p>', 'ModifyDBInstanceMessage$MonitoringRoleArn' => '<p>The ARN for the IAM role that permits Neptune to send enhanced monitoring metrics to Amazon CloudWatch Logs. For example, <code>arn:aws:iam:123456789012:role/emaccess</code>.</p> <p>If <code>MonitoringInterval</code> is set to a value other than 0, then you must supply a <code>MonitoringRoleArn</code> value.</p>', 'ModifyDBInstanceMessage$DomainIAMRoleName' => '<p>Not supported</p>', 'ModifyDBInstanceMessage$PerformanceInsightsKMSKeyId' => '<p> <i>(Not supported by Neptune)</i> </p>', 'ModifyDBParameterGroupMessage$DBParameterGroupName' => '<p>The name of the DB parameter group.</p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match the name of an existing DBParameterGroup.</p> </li> </ul>', 'ModifyDBSubnetGroupMessage$DBSubnetGroupName' => '<p>The name for the DB subnet group. This value is stored as a lowercase string. You can\'t modify the default subnet group.</p> <p>Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.</p> <p>Example: <code>mySubnetgroup</code> </p>', 'ModifyDBSubnetGroupMessage$DBSubnetGroupDescription' => '<p>The description for the DB subnet group.</p>', 'ModifyEventSubscriptionMessage$SubscriptionName' => '<p>The name of the event notification subscription.</p>', 'ModifyEventSubscriptionMessage$SnsTopicArn' => '<p>The Amazon Resource Name (ARN) of the SNS topic created for event notification. The ARN is created by Amazon SNS when you create a topic and subscribe to it.</p>', 'ModifyEventSubscriptionMessage$SourceType' => '<p>The type of source that is generating the events. For example, if you want to be notified of events generated by a DB instance, you would set this parameter to db-instance. if this value is not specified, all events are returned.</p> <p>Valid values: db-instance | db-parameter-group | db-security-group | db-snapshot</p>', 'ModifyGlobalClusterMessage$EngineVersion' => '<p>The version number of the database engine to which you want to upgrade. Changing this parameter will result in an outage. The change is applied during the next maintenance window unless <code>ApplyImmediately</code> is enabled.</p> <p>To list all of the available Neptune engine versions, use the following command:</p>', 'OptionGroupMembership$OptionGroupName' => '<p>Not supported by Neptune.</p>', 'OptionGroupMembership$Status' => '<p>Not supported by Neptune.</p>', 'OrderableDBInstanceOption$Engine' => '<p>The engine type of a DB instance.</p>', 'OrderableDBInstanceOption$EngineVersion' => '<p>The engine version of a DB instance.</p>', 'OrderableDBInstanceOption$DBInstanceClass' => '<p>The DB instance class for a DB instance.</p>', 'OrderableDBInstanceOption$LicenseModel' => '<p>The license model for a DB instance.</p>', 'OrderableDBInstanceOption$StorageType' => '<p>Indicates the storage type for a DB instance.</p>', 'OrderableDBInstanceOptionsMessage$Marker' => '<p> An optional pagination token provided by a previous OrderableDBInstanceOptions request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> .</p>', 'Parameter$ParameterName' => '<p>Specifies the name of the parameter.</p>', 'Parameter$ParameterValue' => '<p>Specifies the value of the parameter.</p>', 'Parameter$Description' => '<p>Provides a description of the parameter.</p>', 'Parameter$Source' => '<p>Indicates the source of the parameter value.</p>', 'Parameter$ApplyType' => '<p>Specifies the engine specific parameters type.</p>', 'Parameter$DataType' => '<p>Specifies the valid data type for the parameter.</p>', 'Parameter$AllowedValues' => '<p>Specifies the valid range of values for the parameter.</p>', 'Parameter$MinimumEngineVersion' => '<p>The earliest engine version to which the parameter can apply.</p>', 'PendingMaintenanceAction$Action' => '<p>The type of pending maintenance action that is available for the resource.</p>', 'PendingMaintenanceAction$OptInStatus' => '<p>Indicates the type of opt-in request that has been received for the resource.</p>', 'PendingMaintenanceAction$Description' => '<p>A description providing more detail about the maintenance action.</p>', 'PendingMaintenanceActionsMessage$Marker' => '<p> An optional pagination token provided by a previous <code>DescribePendingMaintenanceActions</code> request. If this parameter is specified, the response includes only records beyond the marker, up to a number of records specified by <code>MaxRecords</code>.</p>', 'PendingModifiedValues$DBInstanceClass' => '<p> Contains the new <code>DBInstanceClass</code> for the DB instance that will be applied or is currently being applied.</p>', 'PendingModifiedValues$MasterUserPassword' => '<p>Not supported by Neptune.</p>', 'PendingModifiedValues$EngineVersion' => '<p>Indicates the database engine version.</p>', 'PendingModifiedValues$LicenseModel' => '<p>Not supported by Neptune.</p>', 'PendingModifiedValues$DBInstanceIdentifier' => '<p> Contains the new <code>DBInstanceIdentifier</code> for the DB instance that will be applied or is currently being applied.</p>', 'PendingModifiedValues$StorageType' => '<p>Specifies the storage type to be associated with the DB instance.</p>', 'PendingModifiedValues$CACertificateIdentifier' => '<p>Specifies the identifier of the CA certificate for the DB instance.</p>', 'PendingModifiedValues$DBSubnetGroupName' => '<p>The new DB subnet group for the DB instance.</p>', 'PromoteReadReplicaDBClusterMessage$DBClusterIdentifier' => '<p>Not supported.</p>', 'ReadReplicaDBClusterIdentifierList$member' => NULL, 'ReadReplicaDBInstanceIdentifierList$member' => NULL, 'ReadReplicaIdentifierList$member' => NULL, 'ReadersArnList$member' => NULL, 'RebootDBInstanceMessage$DBInstanceIdentifier' => '<p>The DB instance identifier. This parameter is stored as a lowercase string.</p> <p>Constraints:</p> <ul> <li> <p>Must match the identifier of an existing DBInstance.</p> </li> </ul>', 'RemoveFromGlobalClusterMessage$DbClusterIdentifier' => '<p>The Amazon Resource Name (ARN) identifying the cluster to be detached from the Neptune global database cluster.</p>', 'RemoveRoleFromDBClusterMessage$DBClusterIdentifier' => '<p>The name of the DB cluster to disassociate the IAM role from.</p>', 'RemoveRoleFromDBClusterMessage$RoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role to disassociate from the DB cluster, for example <code>arn:aws:iam::123456789012:role/NeptuneAccessRole</code>.</p>', 'RemoveRoleFromDBClusterMessage$FeatureName' => '<p>The name of the feature for the DB cluster that the IAM role is to be disassociated from. For the list of supported feature names, see <a>DescribeDBEngineVersions</a>.</p>', 'RemoveSourceIdentifierFromSubscriptionMessage$SubscriptionName' => '<p>The name of the event notification subscription you want to remove a source identifier from.</p>', 'RemoveSourceIdentifierFromSubscriptionMessage$SourceIdentifier' => '<p> The source identifier to be removed from the subscription, such as the <b>DB instance identifier</b> for a DB instance or the name of a security group.</p>', 'RemoveTagsFromResourceMessage$ResourceName' => '<p>The Amazon Neptune resource that the tags are removed from. This value is an Amazon Resource Name (ARN). For information about creating an ARN, see <a href="https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing"> Constructing an Amazon Resource Name (ARN)</a>.</p>', 'ResetDBClusterParameterGroupMessage$DBClusterParameterGroupName' => '<p>The name of the DB cluster parameter group to reset.</p>', 'ResetDBParameterGroupMessage$DBParameterGroupName' => '<p>The name of the DB parameter group.</p> <p>Constraints:</p> <ul> <li> <p>Must match the name of an existing DBParameterGroup.</p> </li> </ul>', 'ResourcePendingMaintenanceActions$ResourceIdentifier' => '<p>The ARN of the resource that has pending maintenance actions.</p>', 'RestoreDBClusterFromSnapshotMessage$DBClusterIdentifier' => '<p>The name of the DB cluster to create from the DB snapshot or DB cluster snapshot. This parameter isn\'t case-sensitive.</p> <p>Constraints:</p> <ul> <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens</p> </li> <li> <p>First character must be a letter</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li> </ul> <p>Example: <code>my-snapshot-id</code> </p>', 'RestoreDBClusterFromSnapshotMessage$SnapshotIdentifier' => '<p>The identifier for the DB snapshot or DB cluster snapshot to restore from.</p> <p>You can use either the name or the Amazon Resource Name (ARN) to specify a DB cluster snapshot. However, you can use only the ARN to specify a DB snapshot.</p> <p>Constraints:</p> <ul> <li> <p>Must match the identifier of an existing Snapshot.</p> </li> </ul>', 'RestoreDBClusterFromSnapshotMessage$Engine' => '<p>The database engine to use for the new DB cluster.</p> <p>Default: The same as source</p> <p>Constraint: Must be compatible with the engine of the source</p>', 'RestoreDBClusterFromSnapshotMessage$EngineVersion' => '<p>The version of the database engine to use for the new DB cluster.</p>', 'RestoreDBClusterFromSnapshotMessage$DBSubnetGroupName' => '<p>The name of the DB subnet group to use for the new DB cluster.</p> <p>Constraints: If supplied, must match the name of an existing DBSubnetGroup.</p> <p>Example: <code>mySubnetgroup</code> </p>', 'RestoreDBClusterFromSnapshotMessage$DatabaseName' => '<p>Not supported.</p>', 'RestoreDBClusterFromSnapshotMessage$OptionGroupName' => '<p> <i>(Not supported by Neptune)</i> </p>', 'RestoreDBClusterFromSnapshotMessage$KmsKeyId' => '<p>The Amazon KMS key identifier to use when restoring an encrypted DB cluster from a DB snapshot or DB cluster snapshot.</p> <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are restoring a DB cluster with the same Amazon account that owns the KMS encryption key used to encrypt the new DB cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption key.</p> <p>If you do not specify a value for the <code>KmsKeyId</code> parameter, then the following will occur:</p> <ul> <li> <p>If the DB snapshot or DB cluster snapshot in <code>SnapshotIdentifier</code> is encrypted, then the restored DB cluster is encrypted using the KMS key that was used to encrypt the DB snapshot or DB cluster snapshot.</p> </li> <li> <p>If the DB snapshot or DB cluster snapshot in <code>SnapshotIdentifier</code> is not encrypted, then the restored DB cluster is not encrypted.</p> </li> </ul>', 'RestoreDBClusterFromSnapshotMessage$DBClusterParameterGroupName' => '<p>The name of the DB cluster parameter group to associate with the new DB cluster.</p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p> </li> </ul>', 'RestoreDBClusterFromSnapshotMessage$StorageType' => '<p>Specifies the storage type to be associated with the DB cluster.</p> <p>Valid values: <code>standard</code>, <code>iopt1</code> </p> <p>Default: <code>standard</code> </p>', 'RestoreDBClusterToPointInTimeMessage$DBClusterIdentifier' => '<p>The name of the new DB cluster to be created.</p> <p>Constraints:</p> <ul> <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens</p> </li> <li> <p>First character must be a letter</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li> </ul>', 'RestoreDBClusterToPointInTimeMessage$RestoreType' => '<p>The type of restore to be performed. You can specify one of the following values:</p> <ul> <li> <p> <code>full-copy</code> - The new DB cluster is restored as a full copy of the source DB cluster.</p> </li> <li> <p> <code>copy-on-write</code> - The new DB cluster is restored as a clone of the source DB cluster.</p> </li> </ul> <p>If you don\'t specify a <code>RestoreType</code> value, then the new DB cluster is restored as a full copy of the source DB cluster.</p>', 'RestoreDBClusterToPointInTimeMessage$SourceDBClusterIdentifier' => '<p>The identifier of the source DB cluster from which to restore.</p> <p>Constraints:</p> <ul> <li> <p>Must match the identifier of an existing DBCluster.</p> </li> </ul>', 'RestoreDBClusterToPointInTimeMessage$DBSubnetGroupName' => '<p>The DB subnet group name to use for the new DB cluster.</p> <p>Constraints: If supplied, must match the name of an existing DBSubnetGroup.</p> <p>Example: <code>mySubnetgroup</code> </p>', 'RestoreDBClusterToPointInTimeMessage$OptionGroupName' => '<p> <i>(Not supported by Neptune)</i> </p>', 'RestoreDBClusterToPointInTimeMessage$KmsKeyId' => '<p>The Amazon KMS key identifier to use when restoring an encrypted DB cluster from an encrypted DB cluster.</p> <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are restoring a DB cluster with the same Amazon account that owns the KMS encryption key used to encrypt the new DB cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption key.</p> <p>You can restore to a new DB cluster and encrypt the new DB cluster with a KMS key that is different than the KMS key used to encrypt the source DB cluster. The new DB cluster is encrypted with the KMS key identified by the <code>KmsKeyId</code> parameter.</p> <p>If you do not specify a value for the <code>KmsKeyId</code> parameter, then the following will occur:</p> <ul> <li> <p>If the DB cluster is encrypted, then the restored DB cluster is encrypted using the KMS key that was used to encrypt the source DB cluster.</p> </li> <li> <p>If the DB cluster is not encrypted, then the restored DB cluster is not encrypted.</p> </li> </ul> <p>If <code>DBClusterIdentifier</code> refers to a DB cluster that is not encrypted, then the restore request is rejected.</p>', 'RestoreDBClusterToPointInTimeMessage$DBClusterParameterGroupName' => '<p>The name of the DB cluster parameter group to associate with the new DB cluster.</p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p> </li> </ul>', 'RestoreDBClusterToPointInTimeMessage$StorageType' => '<p>Specifies the storage type to be associated with the DB cluster.</p> <p>Valid values: <code>standard</code>, <code>iopt1</code> </p> <p>Default: <code>standard</code> </p>', 'SourceIdsList$member' => NULL, 'StartDBClusterMessage$DBClusterIdentifier' => '<p>The DB cluster identifier of the Neptune DB cluster to be started. This parameter is stored as a lowercase string.</p>', 'StopDBClusterMessage$DBClusterIdentifier' => '<p>The DB cluster identifier of the Neptune DB cluster to be stopped. This parameter is stored as a lowercase string.</p>', 'StringList$member' => NULL, 'Subnet$SubnetIdentifier' => '<p>Specifies the identifier of the subnet.</p>', 'Subnet$SubnetStatus' => '<p>Specifies the status of the subnet.</p>', 'SubnetIdentifierList$member' => NULL, 'Tag$Key' => '<p>A key is the required name of the tag. The string value can be from 1 to 128 Unicode characters in length and can\'t be prefixed with <code>aws:</code> or <code>rds:</code>. The string can only contain the set of Unicode letters, digits, white-space, \'_\', \'.\', \'/\', \'=\', \'+\', \'-\' (Java regex: "^([\\\\p{L}\\\\p{Z}\\\\p{N}_.:/=+\\\\-]*)$").</p>', 'Tag$Value' => '<p>A value is the optional value of the tag. The string value can be from 1 to 256 Unicode characters in length and can\'t be prefixed with <code>aws:</code> or <code>rds:</code>. The string can only contain the set of Unicode letters, digits, white-space, \'_\', \'.\', \'/\', \'=\', \'+\', \'-\' (Java regex: "^([\\\\p{L}\\\\p{Z}\\\\p{N}_.:/=+\\\\-]*)$").</p>', 'Timezone$TimezoneName' => '<p>The name of the time zone.</p>', 'UpgradeTarget$Engine' => '<p>The name of the upgrade target database engine.</p>', 'UpgradeTarget$EngineVersion' => '<p>The version number of the upgrade target database engine.</p>', 'UpgradeTarget$Description' => '<p>The version of the database engine that a DB instance can be upgraded to.</p>', 'ValidStorageOptions$StorageType' => '<p>The valid storage types for your DB instance. For example, gp2, io1.</p>', 'VpcSecurityGroupIdList$member' => NULL, 'VpcSecurityGroupMembership$VpcSecurityGroupId' => '<p>The name of the VPC security group.</p>', 'VpcSecurityGroupMembership$Status' => '<p>The status of the VPC security group.</p>', ], ], 'StringList' => [ 'base' => NULL, 'refs' => [ 'CreateDBClusterEndpointMessage$StaticMembers' => '<p>List of DB instance identifiers that are part of the custom endpoint group.</p>', 'CreateDBClusterEndpointMessage$ExcludedMembers' => '<p>List of DB instance identifiers that aren\'t part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.</p>', 'CreateDBClusterEndpointOutput$StaticMembers' => '<p>List of DB instance identifiers that are part of the custom endpoint group.</p>', 'CreateDBClusterEndpointOutput$ExcludedMembers' => '<p>List of DB instance identifiers that aren\'t part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.</p>', 'DBClusterEndpoint$StaticMembers' => '<p>List of DB instance identifiers that are part of the custom endpoint group.</p>', 'DBClusterEndpoint$ExcludedMembers' => '<p>List of DB instance identifiers that aren\'t part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.</p>', 'DeleteDBClusterEndpointOutput$StaticMembers' => '<p>List of DB instance identifiers that are part of the custom endpoint group.</p>', 'DeleteDBClusterEndpointOutput$ExcludedMembers' => '<p>List of DB instance identifiers that aren\'t part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.</p>', 'ModifyDBClusterEndpointMessage$StaticMembers' => '<p>List of DB instance identifiers that are part of the custom endpoint group.</p>', 'ModifyDBClusterEndpointMessage$ExcludedMembers' => '<p>List of DB instance identifiers that aren\'t part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.</p>', 'ModifyDBClusterEndpointOutput$StaticMembers' => '<p>List of DB instance identifiers that are part of the custom endpoint group.</p>', 'ModifyDBClusterEndpointOutput$ExcludedMembers' => '<p>List of DB instance identifiers that aren\'t part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.</p>', ], ], 'Subnet' => [ 'base' => '<p>Specifies a subnet.</p> <p> This data type is used as a response element in the <a>DescribeDBSubnetGroups</a> action.</p>', 'refs' => [ 'SubnetList$member' => NULL, ], ], 'SubnetAlreadyInUse' => [ 'base' => '<p>The DB subnet is already in use in the Availability Zone.</p>', 'refs' => [], ], 'SubnetIdentifierList' => [ 'base' => NULL, 'refs' => [ 'CreateDBSubnetGroupMessage$SubnetIds' => '<p>The EC2 Subnet IDs for the DB subnet group.</p>', 'ModifyDBSubnetGroupMessage$SubnetIds' => '<p>The EC2 subnet IDs for the DB subnet group.</p>', ], ], 'SubnetList' => [ 'base' => NULL, 'refs' => [ 'DBSubnetGroup$Subnets' => '<p> Contains a list of <a>Subnet</a> elements.</p>', ], ], 'SubscriptionAlreadyExistFault' => [ 'base' => '<p>This subscription already exists.</p>', 'refs' => [], ], 'SubscriptionCategoryNotFoundFault' => [ 'base' => '<p>The designated subscription category could not be found.</p>', 'refs' => [], ], 'SubscriptionNotFoundFault' => [ 'base' => '<p>The designated subscription could not be found.</p>', 'refs' => [], ], 'SupportedCharacterSetsList' => [ 'base' => NULL, 'refs' => [ 'DBEngineVersion$SupportedCharacterSets' => '<p> <i>(Not supported by Neptune)</i> </p>', ], ], 'SupportedTimezonesList' => [ 'base' => NULL, 'refs' => [ 'DBEngineVersion$SupportedTimezones' => '<p>A list of the time zones supported by this engine for the <code>Timezone</code> parameter of the <code>CreateDBInstance</code> action.</p>', ], ], 'TStamp' => [ 'base' => NULL, 'refs' => [ 'DBCluster$EarliestRestorableTime' => '<p>Specifies the earliest time to which a database can be restored with point-in-time restore.</p>', 'DBCluster$LatestRestorableTime' => '<p>Specifies the latest time to which a database can be restored with point-in-time restore.</p>', 'DBCluster$ClusterCreateTime' => '<p>Specifies the time when the DB cluster was created, in Universal Coordinated Time (UTC).</p>', 'DBCluster$AutomaticRestartTime' => '<p>Time at which the DB cluster will be automatically restarted.</p>', 'DBCluster$IOOptimizedNextAllowedModificationTime' => '<p>The next time you can modify the DB cluster to use the <code>iopt1</code> storage type.</p>', 'DBClusterSnapshot$SnapshotCreateTime' => '<p>Provides the time when the snapshot was taken, in Universal Coordinated Time (UTC).</p>', 'DBClusterSnapshot$ClusterCreateTime' => '<p>Specifies the time when the DB cluster was created, in Universal Coordinated Time (UTC).</p>', 'DBInstance$InstanceCreateTime' => '<p>Provides the date and time the DB instance was created.</p>', 'DBInstance$LatestRestorableTime' => '<p>Specifies the latest time to which a database can be restored with point-in-time restore.</p>', 'DescribeEventsMessage$StartTime' => '<p> The beginning of the time interval to retrieve events for, specified in ISO 8601 format. For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a> </p> <p>Example: 2009-07-08T18:00Z</p>', 'DescribeEventsMessage$EndTime' => '<p> The end of the time interval for which to retrieve events, specified in ISO 8601 format. For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a> </p> <p>Example: 2009-07-08T18:00Z</p>', 'Event$Date' => '<p>Specifies the date and time of the event.</p>', 'PendingMaintenanceAction$AutoAppliedAfterDate' => '<p>The date of the maintenance window when the action is applied. The maintenance action is applied to the resource during its first maintenance window after this date. If this date is specified, any <code>next-maintenance</code> opt-in requests are ignored.</p>', 'PendingMaintenanceAction$ForcedApplyDate' => '<p>The date when the maintenance action is automatically applied. The maintenance action is applied to the resource on this date regardless of the maintenance window for the resource. If this date is specified, any <code>immediate</code> opt-in requests are ignored.</p>', 'PendingMaintenanceAction$CurrentApplyDate' => '<p>The effective date when the pending maintenance action is applied to the resource. This date takes into account opt-in requests received from the <a>ApplyPendingMaintenanceAction</a> API, the <code>AutoAppliedAfterDate</code>, and the <code>ForcedApplyDate</code>. This value is blank if an opt-in request has not been received and nothing has been specified as <code>AutoAppliedAfterDate</code> or <code>ForcedApplyDate</code>.</p>', 'RestoreDBClusterToPointInTimeMessage$RestoreToTime' => '<p>The date and time to restore the DB cluster to.</p> <p>Valid Values: Value must be a time in Universal Coordinated Time (UTC) format</p> <p>Constraints:</p> <ul> <li> <p>Must be before the latest restorable time for the DB instance</p> </li> <li> <p>Must be specified if <code>UseLatestRestorableTime</code> parameter is not provided</p> </li> <li> <p>Cannot be specified if <code>UseLatestRestorableTime</code> parameter is true</p> </li> <li> <p>Cannot be specified if <code>RestoreType</code> parameter is <code>copy-on-write</code> </p> </li> </ul> <p>Example: <code>2015-03-07T23:45:00Z</code> </p>', ], ], 'Tag' => [ 'base' => '<p>Metadata assigned to an Amazon Neptune resource consisting of a key-value pair.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'AddTagsToResourceMessage$Tags' => '<p>The tags to be assigned to the Amazon Neptune resource.</p>', 'CopyDBClusterParameterGroupMessage$Tags' => '<p>The tags to be assigned to the copied DB cluster parameter group.</p>', 'CopyDBClusterSnapshotMessage$Tags' => '<p>The tags to assign to the new DB cluster snapshot copy.</p>', 'CopyDBParameterGroupMessage$Tags' => '<p>The tags to be assigned to the copied DB parameter group.</p>', 'CreateDBClusterEndpointMessage$Tags' => '<p>The tags to be assigned to the Amazon Neptune resource.</p>', 'CreateDBClusterMessage$Tags' => '<p>The tags to assign to the new DB cluster.</p>', 'CreateDBClusterParameterGroupMessage$Tags' => '<p>The tags to be assigned to the new DB cluster parameter group.</p>', 'CreateDBClusterSnapshotMessage$Tags' => '<p>The tags to be assigned to the DB cluster snapshot.</p>', 'CreateDBInstanceMessage$Tags' => '<p>The tags to assign to the new instance.</p>', 'CreateDBParameterGroupMessage$Tags' => '<p>The tags to be assigned to the new DB parameter group.</p>', 'CreateDBSubnetGroupMessage$Tags' => '<p>The tags to be assigned to the new DB subnet group.</p>', 'CreateEventSubscriptionMessage$Tags' => '<p>The tags to be applied to the new event subscription.</p>', 'RestoreDBClusterFromSnapshotMessage$Tags' => '<p>The tags to be assigned to the restored DB cluster.</p>', 'RestoreDBClusterToPointInTimeMessage$Tags' => '<p>The tags to be applied to the restored DB cluster.</p>', 'TagListMessage$TagList' => '<p>List of tags returned by the ListTagsForResource operation.</p>', ], ], 'TagListMessage' => [ 'base' => NULL, 'refs' => [], ], 'Timezone' => [ 'base' => '<p>A time zone associated with a <a>DBInstance</a>.</p>', 'refs' => [ 'SupportedTimezonesList$member' => NULL, ], ], 'UpgradeTarget' => [ 'base' => '<p>The version of the database engine that a DB instance can be upgraded to.</p>', 'refs' => [ 'ValidUpgradeTargetList$member' => NULL, ], ], 'ValidDBInstanceModificationsMessage' => [ 'base' => '<p>Information about valid modifications that you can make to your DB instance. Contains the result of a successful call to the <a>DescribeValidDBInstanceModifications</a> action. You can use this information when you call <a>ModifyDBInstance</a>. </p>', 'refs' => [ 'DescribeValidDBInstanceModificationsResult$ValidDBInstanceModificationsMessage' => NULL, ], ], 'ValidStorageOptions' => [ 'base' => '<p>Information about valid modifications that you can make to your DB instance.</p> <p>Contains the result of a successful call to the <a>DescribeValidDBInstanceModifications</a> action.</p>', 'refs' => [ 'ValidStorageOptionsList$member' => NULL, ], ], 'ValidStorageOptionsList' => [ 'base' => NULL, 'refs' => [ 'ValidDBInstanceModificationsMessage$Storage' => '<p>Valid storage options for your DB instance.</p>', ], ], 'ValidUpgradeTargetList' => [ 'base' => NULL, 'refs' => [ 'DBEngineVersion$ValidUpgradeTarget' => '<p>A list of engine versions that this database engine version can be upgraded to.</p>', ], ], 'VpcSecurityGroupIdList' => [ 'base' => NULL, 'refs' => [ 'CreateDBClusterMessage$VpcSecurityGroupIds' => '<p>A list of EC2 VPC security groups to associate with this DB cluster.</p>', 'CreateDBInstanceMessage$VpcSecurityGroupIds' => '<p>A list of EC2 VPC security groups to associate with this DB instance.</p> <p>Not applicable. The associated list of EC2 VPC security groups is managed by the DB cluster. For more information, see <a>CreateDBCluster</a>.</p> <p>Default: The default EC2 VPC security group for the DB subnet group\'s VPC.</p>', 'ModifyDBClusterMessage$VpcSecurityGroupIds' => '<p>A list of VPC security groups that the DB cluster will belong to.</p>', 'ModifyDBInstanceMessage$VpcSecurityGroupIds' => '<p>A list of EC2 VPC security groups to authorize on this DB instance. This change is asynchronously applied as soon as possible.</p> <p>Not applicable. The associated list of EC2 VPC security groups is managed by the DB cluster. For more information, see <a>ModifyDBCluster</a>.</p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match existing VpcSecurityGroupIds.</p> </li> </ul>', 'RestoreDBClusterFromSnapshotMessage$VpcSecurityGroupIds' => '<p>A list of VPC security groups that the new DB cluster will belong to.</p>', 'RestoreDBClusterToPointInTimeMessage$VpcSecurityGroupIds' => '<p>A list of VPC security groups that the new DB cluster belongs to.</p>', ], ], 'VpcSecurityGroupMembership' => [ 'base' => '<p>This data type is used as a response element for queries on VPC security group membership.</p>', 'refs' => [ 'VpcSecurityGroupMembershipList$member' => NULL, ], ], 'VpcSecurityGroupMembershipList' => [ 'base' => NULL, 'refs' => [ 'DBCluster$VpcSecurityGroups' => '<p>Provides a list of VPC security groups that the DB cluster belongs to.</p>', 'DBInstance$VpcSecurityGroups' => '<p>Provides a list of VPC security group elements that the DB instance belongs to.</p>', ], ], ],];
