<?php
// This file was auto-generated from sdk-root/src/data/payment-cryptography/2021-09-14/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon Web Services Payment Cryptography Control Plane APIs manage encryption keys for use during payment-related cryptographic operations. You can create, import, export, share, manage, and delete keys. You can also manage Identity and Access Management (IAM) policies for keys. For more information, see <a href="https://docs.aws.amazon.com/payment-cryptography/latest/userguide/security-iam.html">Identity and access management</a> in the <i>Amazon Web Services Payment Cryptography User Guide.</i> </p> <p>To use encryption keys for payment-related transaction processing and associated cryptographic operations, you use the <a href="https://docs.aws.amazon.com/payment-cryptography/latest/DataAPIReference/Welcome.html">Amazon Web Services Payment Cryptography Data Plane</a>. You can perform actions like encrypt, decrypt, generate, and verify payment-related data.</p> <p>All Amazon Web Services Payment Cryptography API calls must be signed and transmitted using Transport Layer Security (TLS). We recommend you always use the latest supported TLS version for logging API requests. </p> <p>Amazon Web Services Payment Cryptography supports CloudTrail for control plane operations, a service that logs Amazon Web Services API calls and related events for your Amazon Web Services account and delivers them to an Amazon S3 bucket you specify. By using the information collected by CloudTrail, you can determine what requests were made to Amazon Web Services Payment Cryptography, who made the request, when it was made, and so on. If you don\'t conﬁgure a trail, you can still view the most recent events in the CloudTrail console. For more information, see the <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/">CloudTrail User Guide</a>.</p>', 'operations' => [ 'CreateAlias' => '<p>Creates an <i>alias</i>, or a friendly name, for an Amazon Web Services Payment Cryptography key. You can use an alias to identify a key in the console and when you call cryptographic operations such as <a href="https://docs.aws.amazon.com/payment-cryptography/latest/DataAPIReference/API_EncryptData.html">EncryptData</a> or <a href="https://docs.aws.amazon.com/payment-cryptography/latest/DataAPIReference/API_DecryptData.html">DecryptData</a>.</p> <p>You can associate the alias with any key in the same Amazon Web Services Region. Each alias is associated with only one key at a time, but a key can have multiple aliases. You can\'t create an alias without a key. The alias must be unique in the account and Amazon Web Services Region, but you can create another alias with the same name in a different Amazon Web Services Region.</p> <p>To change the key that\'s associated with the alias, call <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_UpdateAlias.html">UpdateAlias</a>. To delete the alias, call <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_DeleteAlias.html">DeleteAlias</a>. These operations don\'t affect the underlying key. To get the alias that you created, call <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ListAliases.html">ListAliases</a>.</p> <p> <b>Cross-account use</b>: This operation can\'t be used across different Amazon Web Services accounts.</p> <p> <b>Related operations:</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_DeleteAlias.html">DeleteAlias</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_GetAlias.html">GetAlias</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ListAliases.html">ListAliases</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_UpdateAlias.html">UpdateAlias</a> </p> </li> </ul>', 'CreateKey' => '<p>Creates an Amazon Web Services Payment Cryptography key, a logical representation of a cryptographic key, that is unique in your account and Amazon Web Services Region. You use keys for cryptographic functions such as encryption and decryption. </p> <p>In addition to the key material used in cryptographic operations, an Amazon Web Services Payment Cryptography key includes metadata such as the key ARN, key usage, key origin, creation date, description, and key state.</p> <p>When you create a key, you specify both immutable and mutable data about the key. The immutable data contains key attributes that define the scope and cryptographic operations that you can perform using the key, for example key class (example: <code>SYMMETRIC_KEY</code>), key algorithm (example: <code>TDES_2KEY</code>), key usage (example: <code>TR31_P0_PIN_ENCRYPTION_KEY</code>) and key modes of use (example: <code>Encrypt</code>). For information about valid combinations of key attributes, see <a href="https://docs.aws.amazon.com/payment-cryptography/latest/userguide/keys-validattributes.html">Understanding key attributes</a> in the <i>Amazon Web Services Payment Cryptography User Guide</i>. The mutable data contained within a key includes usage timestamp and key deletion timestamp and can be modified after creation.</p> <p>Amazon Web Services Payment Cryptography binds key attributes to keys using key blocks when you store or export them. Amazon Web Services Payment Cryptography stores the key contents wrapped and never stores or transmits them in the clear. </p> <p> <b>Cross-account use</b>: This operation can\'t be used across different Amazon Web Services accounts.</p> <p> <b>Related operations:</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_DeleteKey.html">DeleteKey</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_GetKey.html">GetKey</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ListKeys.html">ListKeys</a> </p> </li> </ul>', 'DeleteAlias' => '<p>Deletes the alias, but doesn\'t affect the underlying key.</p> <p>Each key can have multiple aliases. To get the aliases of all keys, use the <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_UpdateAlias.html">UpdateAlias</a> operation. To change the alias of a key, first use <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_DeleteAlias.html">DeleteAlias</a> to delete the current alias and then use <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_CreateAlias.html">CreateAlias</a> to create a new alias. To associate an existing alias with a different key, call <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_UpdateAlias.html">UpdateAlias</a>.</p> <p> <b>Cross-account use:</b> This operation can\'t be used across different Amazon Web Services accounts.</p> <p> <b>Related operations:</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_CreateAlias.html">CreateAlias</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_GetAlias.html">GetAlias</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ListAliases.html">ListAliases</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_UpdateAlias.html">UpdateAlias</a> </p> </li> </ul>', 'DeleteKey' => '<p>Deletes the key material and metadata associated with Amazon Web Services Payment Cryptography key.</p> <p>Key deletion is irreversible. After a key is deleted, you can\'t perform cryptographic operations using the key. For example, you can\'t decrypt data that was encrypted by a deleted Amazon Web Services Payment Cryptography key, and the data may become unrecoverable. Because key deletion is destructive, Amazon Web Services Payment Cryptography has a safety mechanism to prevent accidental deletion of a key. When you call this operation, Amazon Web Services Payment Cryptography disables the specified key but doesn\'t delete it until after a waiting period set using <code>DeleteKeyInDays</code>. The default waiting period is 7 days. During the waiting period, the <code>KeyState</code> is <code>DELETE_PENDING</code>. After the key is deleted, the <code>KeyState</code> is <code>DELETE_COMPLETE</code>.</p> <p>You should delete a key only when you are sure that you don\'t need to use it anymore and no other parties are utilizing this key. If you aren\'t sure, consider deactivating it instead by calling <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_StopKeyUsage.html">StopKeyUsage</a>.</p> <p> <b>Cross-account use:</b> This operation can\'t be used across different Amazon Web Services accounts.</p> <p> <b>Related operations:</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_RestoreKey.html">RestoreKey</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_StartKeyUsage.html">StartKeyUsage</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_StopKeyUsage.html">StopKeyUsage</a> </p> </li> </ul>', 'ExportKey' => '<p>Exports a key from Amazon Web Services Payment Cryptography.</p> <p>Amazon Web Services Payment Cryptography simplifies key exchange by replacing the existing paper-based approach with a modern electronic approach. With <code>ExportKey</code> you can export symmetric keys using either symmetric and asymmetric key exchange mechanisms. Using this operation, you can share your Amazon Web Services Payment Cryptography generated keys with other service partners to perform cryptographic operations outside of Amazon Web Services Payment Cryptography </p> <p>For symmetric key exchange, Amazon Web Services Payment Cryptography uses the ANSI X9 TR-31 norm in accordance with PCI PIN guidelines. And for asymmetric key exchange, Amazon Web Services Payment Cryptography supports ANSI X9 TR-34 norm and RSA wrap and unwrap key exchange mechanism. Asymmetric key exchange methods are typically used to establish bi-directional trust between the two parties exhanging keys and are used for initial key exchange such as Key Encryption Key (KEK). After which you can export working keys using symmetric method to perform various cryptographic operations within Amazon Web Services Payment Cryptography.</p> <p>The TR-34 norm is intended for exchanging 3DES keys only and keys are imported in a WrappedKeyBlock format. Key attributes (such as KeyUsage, KeyAlgorithm, KeyModesOfUse, Exportability) are contained within the key block. With RSA wrap and unwrap, you can exchange both 3DES and AES-128 keys. The keys are imported in a WrappedKeyCryptogram format and you will need to specify the key attributes during import. </p> <p>You can also use <code>ExportKey</code> functionality to generate and export an IPEK (Initial Pin Encryption Key) from Amazon Web Services Payment Cryptography using either TR-31 or TR-34 export key exchange. IPEK is generated from BDK (Base Derivation Key) and <code>ExportDukptInitialKey</code> attribute KSN (<code>KeySerialNumber</code>). The generated IPEK does not persist within Amazon Web Services Payment Cryptography and has to be re-generated each time during export.</p> <p>For key exchange using TR-31 or TR-34 key blocks, you can also export optional blocks within the key block header which contain additional attribute information about the key. The <code>KeyVersion</code> within <code>KeyBlockHeaders</code> indicates the version of the key within the key block. Furthermore, <code>KeyExportability</code> within <code>KeyBlockHeaders</code> can be used to further restrict exportability of the key after export from Amazon Web Services Payment Cryptography.</p> <p>The <code>OptionalBlocks</code> contain the additional data related to the key. For information on data type that can be included within optional blocks, refer to <a href="https://webstore.ansi.org/standards/ascx9/ansix91432022">ASC X9.143-2022</a>.</p> <note> <p>Data included in key block headers is signed but transmitted in clear text. Sensitive or confidential information should not be included in optional blocks. Refer to ASC X9.143-2022 standard for information on allowed data type.</p> </note> <p> <b>To export initial keys (KEK) or IPEK using TR-34</b> </p> <p>Using this operation, you can export initial key using TR-34 asymmetric key exchange. You can only export KEK generated within Amazon Web Services Payment Cryptography. In TR-34 terminology, the sending party of the key is called Key Distribution Host (KDH) and the receiving party of the key is called Key Receiving Device (KRD). During key export process, KDH is Amazon Web Services Payment Cryptography which initiates key export and KRD is the user receiving the key.</p> <p>To initiate TR-34 key export, the KRD must obtain an export token by calling <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_GetParametersForExport.html">GetParametersForExport</a>. This operation also generates a key pair for the purpose of key export, signs the key and returns back the signing public key certificate (also known as KDH signing certificate) and root certificate chain. The KDH uses the private key to sign the the export payload and the signing public key certificate is provided to KRD to verify the signature. The KRD can import the root certificate into its Hardware Security Module (HSM), as required. The export token and the associated KDH signing certificate expires after 7 days. </p> <p>Next the KRD generates a key pair for the the purpose of encrypting the KDH key and provides the public key cerificate (also known as KRD wrapping certificate) back to KDH. The KRD will also import the root cerificate chain into Amazon Web Services Payment Cryptography by calling <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ImportKey.html">ImportKey</a> for <code>RootCertificatePublicKey</code>. The KDH, Amazon Web Services Payment Cryptography, will use the KRD wrapping cerificate to encrypt (wrap) the key under export and signs it with signing private key to generate a TR-34 WrappedKeyBlock. For more information on TR-34 key export, see section <a href="https://docs.aws.amazon.com/payment-cryptography/latest/userguide/keys-export.html">Exporting symmetric keys</a> in the <i>Amazon Web Services Payment Cryptography User Guide</i>. </p> <p>Set the following parameters:</p> <ul> <li> <p> <code>ExportAttributes</code>: Specify export attributes in case of IPEK export. This parameter is optional for KEK export.</p> </li> <li> <p> <code>ExportKeyIdentifier</code>: The <code>KeyARN</code> of the KEK or BDK (in case of IPEK) under export.</p> </li> <li> <p> <code>KeyMaterial</code>: Use <code>Tr34KeyBlock</code> parameters.</p> </li> <li> <p> <code>CertificateAuthorityPublicKeyIdentifier</code>: The <code>KeyARN</code> of the certificate chain that signed the KRD wrapping key certificate.</p> </li> <li> <p> <code>ExportToken</code>: Obtained from KDH by calling <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_GetParametersForImport.html">GetParametersForImport</a>.</p> </li> <li> <p> <code>WrappingKeyCertificate</code>: The public key certificate in PEM format (base64 encoded) of the KRD wrapping key Amazon Web Services Payment Cryptography uses for encryption of the TR-34 export payload. This certificate must be signed by the root certificate (CertificateAuthorityPublicKeyIdentifier) imported into Amazon Web Services Payment Cryptography.</p> </li> </ul> <p>When this operation is successful, Amazon Web Services Payment Cryptography returns the KEK or IPEK as a TR-34 WrappedKeyBlock. </p> <p> <b>To export initial keys (KEK) or IPEK using RSA Wrap and Unwrap</b> </p> <p>Using this operation, you can export initial key using asymmetric RSA wrap and unwrap key exchange method. To initiate export, generate an asymmetric key pair on the receiving HSM and obtain the public key certificate in PEM format (base64 encoded) for the purpose of wrapping and the root certifiate chain. Import the root certificate into Amazon Web Services Payment Cryptography by calling <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ImportKey.html">ImportKey</a> for <code>RootCertificatePublicKey</code>.</p> <p>Next call <code>ExportKey</code> and set the following parameters:</p> <ul> <li> <p> <code>CertificateAuthorityPublicKeyIdentifier</code>: The <code>KeyARN</code> of the certificate chain that signed wrapping key certificate.</p> </li> <li> <p> <code>KeyMaterial</code>: Set to <code>KeyCryptogram</code>.</p> </li> <li> <p> <code>WrappingKeyCertificate</code>: The public key certificate in PEM format (base64 encoded) obtained by the receiving HSM and signed by the root certificate (CertificateAuthorityPublicKeyIdentifier) imported into Amazon Web Services Payment Cryptography. The receiving HSM uses its private key component to unwrap the WrappedKeyCryptogram.</p> </li> </ul> <p>When this operation is successful, Amazon Web Services Payment Cryptography returns the WrappedKeyCryptogram. </p> <p> <b>To export working keys or IPEK using TR-31</b> </p> <p>Using this operation, you can export working keys or IPEK using TR-31 symmetric key exchange. In TR-31, you must use an initial key such as KEK to encrypt or wrap the key under export. To establish a KEK, you can use <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_CreateKey.html">CreateKey</a> or <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ImportKey.html">ImportKey</a>. </p> <p>Set the following parameters:</p> <ul> <li> <p> <code>ExportAttributes</code>: Specify export attributes in case of IPEK export. This parameter is optional for KEK export.</p> </li> <li> <p> <code>ExportKeyIdentifier</code>: The <code>KeyARN</code> of the KEK or BDK (in case of IPEK) under export.</p> </li> <li> <p> <code>KeyMaterial</code>: Use <code>Tr31KeyBlock</code> parameters.</p> </li> </ul> <p>When this operation is successful, Amazon Web Services Payment Cryptography returns the working key or IPEK as a TR-31 WrappedKeyBlock.</p> <p> <b>Cross-account use:</b> This operation can\'t be used across different Amazon Web Services accounts.</p> <p> <b>Related operations:</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_GetParametersForExport.html">GetParametersForExport</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ImportKey.html">ImportKey</a> </p> </li> </ul>', 'GetAlias' => '<p>Gets the Amazon Web Services Payment Cryptography key associated with the alias.</p> <p> <b>Cross-account use:</b> This operation can\'t be used across different Amazon Web Services accounts.</p> <p> <b>Related operations:</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_CreateAlias.html">CreateAlias</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_DeleteAlias.html">DeleteAlias</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ListAliases.html">ListAliases</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_UpdateAlias.html">UpdateAlias</a> </p> </li> </ul>', 'GetKey' => '<p>Gets the key material for an Amazon Web Services Payment Cryptography key, including the immutable and mutable data specified when the key was created.</p> <p> <b>Cross-account use:</b> This operation can\'t be used across different Amazon Web Services accounts.</p> <p> <b>Related operations:</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_CreateKey.html">CreateKey</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_DeleteKey.html">DeleteKey</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ListKeys.html">ListKeys</a> </p> </li> </ul>', 'GetParametersForExport' => '<p>Gets the export token and the signing key certificate to initiate a TR-34 key export from Amazon Web Services Payment Cryptography.</p> <p>The signing key certificate signs the wrapped key under export within the TR-34 key payload. The export token and signing key certificate must be in place and operational before calling <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ExportKey.html">ExportKey</a>. The export token expires in 7 days. You can use the same export token to export multiple keys from your service account.</p> <p> <b>Cross-account use:</b> This operation can\'t be used across different Amazon Web Services accounts.</p> <p> <b>Related operations:</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ExportKey.html">ExportKey</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_GetParametersForImport.html">GetParametersForImport</a> </p> </li> </ul>', 'GetParametersForImport' => '<p>Gets the import token and the wrapping key certificate in PEM format (base64 encoded) to initiate a TR-34 WrappedKeyBlock or a RSA WrappedKeyCryptogram import into Amazon Web Services Payment Cryptography.</p> <p>The wrapping key certificate wraps the key under import. The import token and wrapping key certificate must be in place and operational before calling <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ImportKey.html">ImportKey</a>. The import token expires in 7 days. You can use the same import token to import multiple keys into your service account.</p> <p> <b>Cross-account use:</b> This operation can\'t be used across different Amazon Web Services accounts.</p> <p> <b>Related operations:</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_GetParametersForExport.html">GetParametersForExport</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ImportKey.html">ImportKey</a> </p> </li> </ul>', 'GetPublicKeyCertificate' => '<p>Gets the public key certificate of the asymmetric key pair that exists within Amazon Web Services Payment Cryptography.</p> <p>Unlike the private key of an asymmetric key, which never leaves Amazon Web Services Payment Cryptography unencrypted, callers with <code>GetPublicKeyCertificate</code> permission can download the public key certificate of the asymmetric key. You can share the public key certificate to allow others to encrypt messages and verify signatures outside of Amazon Web Services Payment Cryptography</p> <p> <b>Cross-account use:</b> This operation can\'t be used across different Amazon Web Services accounts.</p>', 'ImportKey' => '<p>Imports symmetric keys and public key certificates in PEM format (base64 encoded) into Amazon Web Services Payment Cryptography.</p> <p>Amazon Web Services Payment Cryptography simplifies key exchange by replacing the existing paper-based approach with a modern electronic approach. With <code>ImportKey</code> you can import symmetric keys using either symmetric and asymmetric key exchange mechanisms.</p> <p>For symmetric key exchange, Amazon Web Services Payment Cryptography uses the ANSI X9 TR-31 norm in accordance with PCI PIN guidelines. And for asymmetric key exchange, Amazon Web Services Payment Cryptography supports ANSI X9 TR-34 norm and RSA wrap and unwrap key exchange mechanisms. Asymmetric key exchange methods are typically used to establish bi-directional trust between the two parties exhanging keys and are used for initial key exchange such as Key Encryption Key (KEK) or Zone Master Key (ZMK). After which you can import working keys using symmetric method to perform various cryptographic operations within Amazon Web Services Payment Cryptography.</p> <p>The TR-34 norm is intended for exchanging 3DES keys only and keys are imported in a WrappedKeyBlock format. Key attributes (such as KeyUsage, KeyAlgorithm, KeyModesOfUse, Exportability) are contained within the key block. With RSA wrap and unwrap, you can exchange both 3DES and AES-128 keys. The keys are imported in a WrappedKeyCryptogram format and you will need to specify the key attributes during import. </p> <p>You can also import a <i>root public key certificate</i>, used to sign other public key certificates, or a <i>trusted public key certificate</i> under an already established root public key certificate.</p> <p> <b>To import a public root key certificate</b> </p> <p>You can also import a <i>root public key certificate</i>, used to sign other public key certificates, or a <i>trusted public key certificate</i> under an already established root public key certificate.</p> <p> <b>To import a public root key certificate</b> </p> <p>Using this operation, you can import the public component (in PEM cerificate format) of your private root key. You can use the imported public root key certificate for digital signatures, for example signing wrapping key or signing key in TR-34, within your Amazon Web Services Payment Cryptography account.</p> <p>Set the following parameters:</p> <ul> <li> <p> <code>KeyMaterial</code>: <code>RootCertificatePublicKey</code> </p> </li> <li> <p> <code>KeyClass</code>: <code>PUBLIC_KEY</code> </p> </li> <li> <p> <code>KeyModesOfUse</code>: <code>Verify</code> </p> </li> <li> <p> <code>KeyUsage</code>: <code>TR31_S0_ASYMMETRIC_KEY_FOR_DIGITAL_SIGNATURE</code> </p> </li> <li> <p> <code>PublicKeyCertificate</code>: The public key certificate in PEM format (base64 encoded) of the private root key under import.</p> </li> </ul> <p> <b>To import a trusted public key certificate</b> </p> <p>The root public key certificate must be in place and operational before you import a trusted public key certificate. Set the following parameters:</p> <ul> <li> <p> <code>KeyMaterial</code>: <code>TrustedCertificatePublicKey</code> </p> </li> <li> <p> <code>CertificateAuthorityPublicKeyIdentifier</code>: <code>KeyArn</code> of the <code>RootCertificatePublicKey</code>.</p> </li> <li> <p> <code>KeyModesOfUse</code> and <code>KeyUsage</code>: Corresponding to the cryptographic operations such as wrap, sign, or encrypt that you will allow the trusted public key certificate to perform.</p> </li> <li> <p> <code>PublicKeyCertificate</code>: The trusted public key certificate in PEM format (base64 encoded) under import.</p> </li> </ul> <p> <b>To import initial keys (KEK or ZMK or similar) using TR-34</b> </p> <p>Using this operation, you can import initial key using TR-34 asymmetric key exchange. In TR-34 terminology, the sending party of the key is called Key Distribution Host (KDH) and the receiving party of the key is called Key Receiving Device (KRD). During the key import process, KDH is the user who initiates the key import and KRD is Amazon Web Services Payment Cryptography who receives the key.</p> <p>To initiate TR-34 key import, the KDH must obtain an import token by calling <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_GetParametersForImport.html">GetParametersForImport</a>. This operation generates an encryption keypair for the purpose of key import, signs the key and returns back the wrapping key certificate (also known as KRD wrapping certificate) and the root certificate chain. The KDH must trust and install the KRD wrapping certificate on its HSM and use it to encrypt (wrap) the KDH key during TR-34 WrappedKeyBlock generation. The import token and associated KRD wrapping certificate expires after 7 days.</p> <p>Next the KDH generates a key pair for the purpose of signing the encrypted KDH key and provides the public certificate of the signing key to Amazon Web Services Payment Cryptography. The KDH will also need to import the root certificate chain of the KDH signing certificate by calling <code>ImportKey</code> for <code>RootCertificatePublicKey</code>. For more information on TR-34 key import, see section <a href="https://docs.aws.amazon.com/payment-cryptography/latest/userguide/keys-import.html">Importing symmetric keys</a> in the <i>Amazon Web Services Payment Cryptography User Guide</i>.</p> <p>Set the following parameters:</p> <ul> <li> <p> <code>KeyMaterial</code>: Use <code>Tr34KeyBlock</code> parameters.</p> </li> <li> <p> <code>CertificateAuthorityPublicKeyIdentifier</code>: The <code>KeyARN</code> of the certificate chain that signed the KDH signing key certificate.</p> </li> <li> <p> <code>ImportToken</code>: Obtained from KRD by calling <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_GetParametersForImport.html">GetParametersForImport</a>.</p> </li> <li> <p> <code>WrappedKeyBlock</code>: The TR-34 wrapped key material from KDH. It contains the KDH key under import, wrapped with KRD wrapping certificate and signed by KDH signing private key. This TR-34 key block is typically generated by the KDH Hardware Security Module (HSM) outside of Amazon Web Services Payment Cryptography.</p> </li> <li> <p> <code>SigningKeyCertificate</code>: The public key certificate in PEM format (base64 encoded) of the KDH signing key generated under the root certificate (CertificateAuthorityPublicKeyIdentifier) imported in Amazon Web Services Payment Cryptography.</p> </li> </ul> <p> <b>To import initial keys (KEK or ZMK or similar) using RSA Wrap and Unwrap</b> </p> <p>Using this operation, you can import initial key using asymmetric RSA wrap and unwrap key exchange method. To initiate import, call <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_GetParametersForImport.html">GetParametersForImport</a> with <code>KeyMaterial</code> set to <code>KEY_CRYPTOGRAM</code> to generate an import token. This operation also generates an encryption keypair for the purpose of key import, signs the key and returns back the wrapping key certificate in PEM format (base64 encoded) and its root certificate chain. The import token and associated KRD wrapping certificate expires after 7 days. </p> <p>You must trust and install the wrapping certificate and its certificate chain on the sending HSM and use it to wrap the key under export for WrappedKeyCryptogram generation. Next call <code>ImportKey</code> with <code>KeyMaterial</code> set to <code>KEY_CRYPTOGRAM</code> and provide the <code>ImportToken</code> and <code>KeyAttributes</code> for the key under import.</p> <p> <b>To import working keys using TR-31</b> </p> <p>Amazon Web Services Payment Cryptography uses TR-31 symmetric key exchange norm to import working keys. A KEK must be established within Amazon Web Services Payment Cryptography by using TR-34 key import or by using <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_CreateKey.html">CreateKey</a>. To initiate a TR-31 key import, set the following parameters:</p> <ul> <li> <p> <code>KeyMaterial</code>: Use <code>Tr31KeyBlock</code> parameters.</p> </li> <li> <p> <code>WrappedKeyBlock</code>: The TR-31 wrapped key material. It contains the key under import, encrypted using KEK. The TR-31 key block is typically generated by a HSM outside of Amazon Web Services Payment Cryptography. </p> </li> <li> <p> <code>WrappingKeyIdentifier</code>: The <code>KeyArn</code> of the KEK that Amazon Web Services Payment Cryptography uses to decrypt or unwrap the key under import.</p> </li> </ul> <p> <b>Cross-account use:</b> This operation can\'t be used across different Amazon Web Services accounts.</p> <p> <b>Related operations:</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ExportKey.html">ExportKey</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_GetParametersForImport.html">GetParametersForImport</a> </p> </li> </ul>', 'ListAliases' => '<p>Lists the aliases for all keys in the caller\'s Amazon Web Services account and Amazon Web Services Region. You can filter the list of aliases. For more information, see <a href="https://docs.aws.amazon.com/payment-cryptography/latest/userguide/keys-managealias.html">Using aliases</a> in the <i>Amazon Web Services Payment Cryptography User Guide</i>.</p> <p>This is a paginated operation, which means that each response might contain only a subset of all the aliases. When the response contains only a subset of aliases, it includes a <code>NextToken</code> value. Use this value in a subsequent <code>ListAliases</code> request to get more aliases. When you receive a response with no NextToken (or an empty or null value), that means there are no more aliases to get.</p> <p> <b>Cross-account use:</b> This operation can\'t be used across different Amazon Web Services accounts.</p> <p> <b>Related operations:</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_CreateAlias.html">CreateAlias</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_DeleteAlias.html">DeleteAlias</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_GetAlias.html">GetAlias</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_UpdateAlias.html">UpdateAlias</a> </p> </li> </ul>', 'ListKeys' => '<p>Lists the keys in the caller\'s Amazon Web Services account and Amazon Web Services Region. You can filter the list of keys.</p> <p>This is a paginated operation, which means that each response might contain only a subset of all the keys. When the response contains only a subset of keys, it includes a <code>NextToken</code> value. Use this value in a subsequent <code>ListKeys</code> request to get more keys. When you receive a response with no NextToken (or an empty or null value), that means there are no more keys to get.</p> <p> <b>Cross-account use:</b> This operation can\'t be used across different Amazon Web Services accounts.</p> <p> <b>Related operations:</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_CreateKey.html">CreateKey</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_DeleteKey.html">DeleteKey</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_GetKey.html">GetKey</a> </p> </li> </ul>', 'ListTagsForResource' => '<p>Lists the tags for an Amazon Web Services resource.</p> <p>This is a paginated operation, which means that each response might contain only a subset of all the tags. When the response contains only a subset of tags, it includes a <code>NextToken</code> value. Use this value in a subsequent <code>ListTagsForResource</code> request to get more tags. When you receive a response with no NextToken (or an empty or null value), that means there are no more tags to get.</p> <p> <b>Cross-account use:</b> This operation can\'t be used across different Amazon Web Services accounts.</p> <p> <b>Related operations:</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_TagResource.html">TagResource</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_UntagResource.html">UntagResource</a> </p> </li> </ul>', 'RestoreKey' => '<p>Cancels a scheduled key deletion during the waiting period. Use this operation to restore a <code>Key</code> that is scheduled for deletion.</p> <p>During the waiting period, the <code>KeyState</code> is <code>DELETE_PENDING</code> and <code>deletePendingTimestamp</code> contains the date and time after which the <code>Key</code> will be deleted. After <code>Key</code> is restored, the <code>KeyState</code> is <code>CREATE_COMPLETE</code>, and the value for <code>deletePendingTimestamp</code> is removed.</p> <p> <b>Cross-account use:</b> This operation can\'t be used across different Amazon Web Services accounts.</p> <p> <b>Related operations:</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_DeleteKey.html">DeleteKey</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_StartKeyUsage.html">StartKeyUsage</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_StopKeyUsage.html">StopKeyUsage</a> </p> </li> </ul>', 'StartKeyUsage' => '<p>Enables an Amazon Web Services Payment Cryptography key, which makes it active for cryptographic operations within Amazon Web Services Payment Cryptography</p> <p> <b>Cross-account use:</b> This operation can\'t be used across different Amazon Web Services accounts.</p> <p> <b>Related operations:</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_StopKeyUsage.html">StopKeyUsage</a> </p> </li> </ul>', 'StopKeyUsage' => '<p>Disables an Amazon Web Services Payment Cryptography key, which makes it inactive within Amazon Web Services Payment Cryptography.</p> <p>You can use this operation instead of <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_DeleteKey.html">DeleteKey</a> to deactivate a key. You can enable the key in the future by calling <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_StartKeyUsage.html">StartKeyUsage</a>.</p> <p> <b>Cross-account use:</b> This operation can\'t be used across different Amazon Web Services accounts.</p> <p> <b>Related operations:</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_DeleteKey.html">DeleteKey</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_StartKeyUsage.html">StartKeyUsage</a> </p> </li> </ul>', 'TagResource' => '<p>Adds or edits tags on an Amazon Web Services Payment Cryptography key.</p> <note> <p>Tagging or untagging an Amazon Web Services Payment Cryptography key can allow or deny permission to the key.</p> </note> <p>Each tag consists of a tag key and a tag value, both of which are case-sensitive strings. The tag value can be an empty (null) string. To add a tag, specify a new tag key and a tag value. To edit a tag, specify an existing tag key and a new tag value. You can also add tags to an Amazon Web Services Payment Cryptography key when you create it with <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_CreateKey.html">CreateKey</a>.</p> <p> <b>Cross-account use:</b> This operation can\'t be used across different Amazon Web Services accounts.</p> <p> <b>Related operations:</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ListTagsForResource.html">ListTagsForResource</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_UntagResource.html">UntagResource</a> </p> </li> </ul>', 'UntagResource' => '<p>Deletes a tag from an Amazon Web Services Payment Cryptography key.</p> <note> <p>Tagging or untagging an Amazon Web Services Payment Cryptography key can allow or deny permission to the key.</p> </note> <p> <b>Cross-account use:</b> This operation can\'t be used across different Amazon Web Services accounts.</p> <p> <b>Related operations:</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ListTagsForResource.html">ListTagsForResource</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_TagResource.html">TagResource</a> </p> </li> </ul>', 'UpdateAlias' => '<p>Associates an existing Amazon Web Services Payment Cryptography alias with a different key. Each alias is associated with only one Amazon Web Services Payment Cryptography key at a time, although a key can have multiple aliases. The alias and the Amazon Web Services Payment Cryptography key must be in the same Amazon Web Services account and Amazon Web Services Region</p> <p> <b>Cross-account use:</b> This operation can\'t be used across different Amazon Web Services accounts.</p> <p> <b>Related operations:</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_CreateAlias.html">CreateAlias</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_DeleteAlias.html">DeleteAlias</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_GetAlias.html">GetAlias</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ListAliases.html">ListAliases</a> </p> </li> </ul>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You do not have sufficient access to perform this action.</p>', 'refs' => [], ], 'Alias' => [ 'base' => '<p>Contains information about an alias.</p>', 'refs' => [ 'Aliases$member' => NULL, 'CreateAliasOutput$Alias' => '<p>The alias for the key.</p>', 'GetAliasOutput$Alias' => '<p>The alias of the Amazon Web Services Payment Cryptography key.</p>', 'UpdateAliasOutput$Alias' => '<p>The alias name.</p>', ], ], 'AliasName' => [ 'base' => NULL, 'refs' => [ 'Alias$AliasName' => '<p>A friendly name that you can use to refer to a key. The value must begin with <code>alias/</code>.</p> <important> <p>Do not include confidential or sensitive information in this field. This field may be displayed in plaintext in CloudTrail logs and other output.</p> </important>', 'CreateAliasInput$AliasName' => '<p>A friendly name that you can use to refer to a key. An alias must begin with <code>alias/</code> followed by a name, for example <code>alias/ExampleAlias</code>. It can contain only alphanumeric characters, forward slashes (/), underscores (_), and dashes (-).</p> <important> <p>Don\'t include personal, confidential or sensitive information in this field. This field may be displayed in plaintext in CloudTrail logs and other output.</p> </important>', 'DeleteAliasInput$AliasName' => '<p>A friendly name that you can use to refer Amazon Web Services Payment Cryptography key. This value must begin with <code>alias/</code> followed by a name, such as <code>alias/ExampleAlias</code>.</p>', 'GetAliasInput$AliasName' => '<p>The alias of the Amazon Web Services Payment Cryptography key.</p>', 'UpdateAliasInput$AliasName' => '<p>The alias whose associated key is changing.</p>', ], ], 'Aliases' => [ 'base' => NULL, 'refs' => [ 'ListAliasesOutput$Aliases' => '<p>The list of aliases. Each alias describes the <code>KeyArn</code> contained within.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'CreateKeyInput$Exportable' => '<p>Specifies whether the key is exportable from the service.</p>', 'CreateKeyInput$Enabled' => '<p>Specifies whether to enable the key. If the key is enabled, it is activated for use within the service. If the key is not enabled, then it is created but not activated. The default value is enabled.</p>', 'ImportKeyCryptogram$Exportable' => '<p>Specifies whether the key is exportable from the service.</p>', 'ImportKeyInput$Enabled' => '<p>Specifies whether import key is enabled.</p>', 'Key$Enabled' => '<p>Specifies whether the key is enabled. </p>', 'Key$Exportable' => '<p>Specifies whether the key is exportable. This data is immutable after the key is created.</p>', 'KeySummary$Exportable' => '<p>Specifies whether the key is exportable. This data is immutable after the key is created.</p>', 'KeySummary$Enabled' => '<p>Specifies whether the key is enabled. </p>', ], ], 'CertificateType' => [ 'base' => NULL, 'refs' => [ 'ExportKeyCryptogram$WrappingKeyCertificate' => '<p>The wrapping key certificate in PEM format (base64 encoded). Amazon Web Services Payment Cryptography uses this certificate to wrap the key under export.</p>', 'ExportTr34KeyBlock$WrappingKeyCertificate' => '<p>The <code>KeyARN</code> of the wrapping key certificate. Amazon Web Services Payment Cryptography uses this certificate to wrap the key under export.</p>', 'GetParametersForExportOutput$SigningKeyCertificate' => '<p>The signing key certificate in PEM format (base64 encoded) of the public key for signature within the TR-34 key block. The certificate expires after 7 days.</p>', 'GetParametersForExportOutput$SigningKeyCertificateChain' => '<p>The root certificate authority (CA) that signed the signing key certificate in PEM format (base64 encoded).</p>', 'GetParametersForImportOutput$WrappingKeyCertificate' => '<p>The wrapping key certificate in PEM format (base64 encoded) of the wrapping key for use within the TR-34 key block. The certificate expires in 7 days.</p>', 'GetParametersForImportOutput$WrappingKeyCertificateChain' => '<p>The Amazon Web Services Payment Cryptography root certificate authority (CA) that signed the wrapping key certificate in PEM format (base64 encoded).</p>', 'GetPublicKeyCertificateOutput$KeyCertificate' => '<p>The public key component of the asymmetric key pair in a certificate PEM format (base64 encoded). It is signed by the root certificate authority (CA). The certificate expires in 90 days.</p>', 'GetPublicKeyCertificateOutput$KeyCertificateChain' => '<p>The root certificate authority (CA) that signed the public key certificate in PEM format (base64 encoded) of the asymmetric key pair.</p>', 'ImportTr34KeyBlock$SigningKeyCertificate' => '<p>The public key component in PEM certificate format of the private key that signs the KDH TR-34 WrappedKeyBlock.</p>', 'RootCertificatePublicKey$PublicKeyCertificate' => '<p>Parameter information for root public key certificate import.</p>', 'TrustedCertificatePublicKey$PublicKeyCertificate' => '<p>Parameter information for trusted public key certificate import.</p>', ], ], 'ConflictException' => [ 'base' => '<p>This request can cause an inconsistent state for the resource.</p>', 'refs' => [], ], 'CreateAliasInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateAliasOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateKeyInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateKeyOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAliasInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAliasOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteKeyInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteKeyInputDeleteKeyInDaysInteger' => [ 'base' => NULL, 'refs' => [ 'DeleteKeyInput$DeleteKeyInDays' => '<p>The waiting period for key deletion. The default value is seven days.</p>', ], ], 'DeleteKeyOutput' => [ 'base' => NULL, 'refs' => [], ], 'EvenHexLengthBetween16And32' => [ 'base' => NULL, 'refs' => [ 'ExportTr34KeyBlock$RandomNonce' => '<p>A random number value that is unique to the TR-34 key block generated using 2 pass. The operation will fail, if a random nonce value is not provided for a TR-34 key block generated using 2 pass.</p>', 'ImportTr34KeyBlock$RandomNonce' => '<p>A random number value that is unique to the TR-34 key block generated using 2 pass. The operation will fail, if a random nonce value is not provided for a TR-34 key block generated using 2 pass.</p>', ], ], 'ExportAttributes' => [ 'base' => '<p>The attributes for IPEK generation during export.</p>', 'refs' => [ 'ExportKeyInput$ExportAttributes' => '<p>The attributes for IPEK generation during export.</p>', ], ], 'ExportDukptInitialKey' => [ 'base' => '<p>Parameter information for IPEK generation during export.</p>', 'refs' => [ 'ExportAttributes$ExportDukptInitialKey' => '<p>Parameter information for IPEK export.</p>', ], ], 'ExportKeyCryptogram' => [ 'base' => '<p>Parameter information for key material export using asymmetric RSA wrap and unwrap key exchange method.</p>', 'refs' => [ 'ExportKeyMaterial$KeyCryptogram' => '<p>Parameter information for key material export using asymmetric RSA wrap and unwrap key exchange method</p>', ], ], 'ExportKeyInput' => [ 'base' => NULL, 'refs' => [], ], 'ExportKeyMaterial' => [ 'base' => '<p>Parameter information for key material export from Amazon Web Services Payment Cryptography using TR-31 or TR-34 or RSA wrap and unwrap key exchange method.</p>', 'refs' => [ 'ExportKeyInput$KeyMaterial' => '<p>The key block format type, for example, TR-34 or TR-31, to use during key material export.</p>', ], ], 'ExportKeyOutput' => [ 'base' => NULL, 'refs' => [], ], 'ExportTokenId' => [ 'base' => NULL, 'refs' => [ 'ExportTr34KeyBlock$ExportToken' => '<p>The export token to initiate key export from Amazon Web Services Payment Cryptography. It also contains the signing key certificate that will sign the wrapped key during TR-34 key block generation. Call <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_GetParametersForExport.html">GetParametersForExport</a> to receive an export token. It expires after 7 days. You can use the same export token to export multiple keys from the same service account.</p>', 'GetParametersForExportOutput$ExportToken' => '<p>The export token to initiate key export from Amazon Web Services Payment Cryptography. The export token expires after 7 days. You can use the same export token to export multiple keys from the same service account.</p>', ], ], 'ExportTr31KeyBlock' => [ 'base' => '<p>Parameter information for key material export using symmetric TR-31 key exchange method.</p>', 'refs' => [ 'ExportKeyMaterial$Tr31KeyBlock' => '<p>Parameter information for key material export using symmetric TR-31 key exchange method.</p>', ], ], 'ExportTr34KeyBlock' => [ 'base' => '<p>Parameter information for key material export using the asymmetric TR-34 key exchange method.</p>', 'refs' => [ 'ExportKeyMaterial$Tr34KeyBlock' => '<p>Parameter information for key material export using the asymmetric TR-34 key exchange method.</p>', ], ], 'GetAliasInput' => [ 'base' => NULL, 'refs' => [], ], 'GetAliasOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetKeyInput' => [ 'base' => NULL, 'refs' => [], ], 'GetKeyOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetParametersForExportInput' => [ 'base' => NULL, 'refs' => [], ], 'GetParametersForExportOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetParametersForImportInput' => [ 'base' => NULL, 'refs' => [], ], 'GetParametersForImportOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetPublicKeyCertificateInput' => [ 'base' => NULL, 'refs' => [], ], 'GetPublicKeyCertificateOutput' => [ 'base' => NULL, 'refs' => [], ], 'HexLength20Or24' => [ 'base' => NULL, 'refs' => [ 'ExportDukptInitialKey$KeySerialNumber' => '<p>The KSN for IPEK generation using DUKPT. </p> <p>KSN must be padded before sending to Amazon Web Services Payment Cryptography. KSN hex length should be 20 for a TDES_2KEY key or 24 for an AES key.</p>', ], ], 'ImportKeyCryptogram' => [ 'base' => '<p>Parameter information for key material import using asymmetric RSA wrap and unwrap key exchange method.</p>', 'refs' => [ 'ImportKeyMaterial$KeyCryptogram' => '<p>Parameter information for key material import using asymmetric RSA wrap and unwrap key exchange method.</p>', ], ], 'ImportKeyInput' => [ 'base' => NULL, 'refs' => [], ], 'ImportKeyMaterial' => [ 'base' => '<p>Parameter information for key material import into Amazon Web Services Payment Cryptography using TR-31 or TR-34 or RSA wrap and unwrap key exchange method.</p>', 'refs' => [ 'ImportKeyInput$KeyMaterial' => '<p>The key or public key certificate type to use during key material import, for example TR-34 or RootCertificatePublicKey.</p>', ], ], 'ImportKeyOutput' => [ 'base' => NULL, 'refs' => [], ], 'ImportTokenId' => [ 'base' => NULL, 'refs' => [ 'GetParametersForImportOutput$ImportToken' => '<p>The import token to initiate key import into Amazon Web Services Payment Cryptography. The import token expires after 7 days. You can use the same import token to import multiple keys to the same service account.</p>', 'ImportKeyCryptogram$ImportToken' => '<p>The import token that initiates key import using the asymmetric RSA wrap and unwrap key exchange method into AWS Payment Cryptography. It expires after 7 days. You can use the same import token to import multiple keys to the same service account.</p>', 'ImportTr34KeyBlock$ImportToken' => '<p>The import token that initiates key import using the asymmetric TR-34 key exchange method into Amazon Web Services Payment Cryptography. It expires after 7 days. You can use the same import token to import multiple keys to the same service account.</p>', ], ], 'ImportTr31KeyBlock' => [ 'base' => '<p>Parameter information for key material import using symmetric TR-31 key exchange method.</p>', 'refs' => [ 'ImportKeyMaterial$Tr31KeyBlock' => '<p>Parameter information for key material import using symmetric TR-31 key exchange method.</p>', ], ], 'ImportTr34KeyBlock' => [ 'base' => '<p>Parameter information for key material import using the asymmetric TR-34 key exchange method.</p>', 'refs' => [ 'ImportKeyMaterial$Tr34KeyBlock' => '<p>Parameter information for key material import using the asymmetric TR-34 key exchange method.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>The request processing has failed because of an unknown error, exception, or failure.</p>', 'refs' => [], ], 'Key' => [ 'base' => '<p>Metadata about an Amazon Web Services Payment Cryptography key.</p>', 'refs' => [ 'CreateKeyOutput$Key' => '<p>The key material that contains all the key attributes.</p>', 'DeleteKeyOutput$Key' => '<p>The <code>KeyARN</code> of the key that is scheduled for deletion.</p>', 'GetKeyOutput$Key' => '<p>The key material, including the immutable and mutable data for the key.</p>', 'ImportKeyOutput$Key' => '<p>The <code>KeyARN</code> of the key material imported within Amazon Web Services Payment Cryptography.</p>', 'RestoreKeyOutput$Key' => '<p>The key material of the restored key. The <code>KeyState</code> will change to <code>CREATE_COMPLETE</code> and value for <code>DeletePendingTimestamp</code> gets removed. </p>', 'StartKeyUsageOutput$Key' => '<p>The <code>KeyARN</code> of the Amazon Web Services Payment Cryptography key activated for use.</p>', 'StopKeyUsageOutput$Key' => '<p>The <code>KeyARN</code> of the key.</p>', ], ], 'KeyAlgorithm' => [ 'base' => NULL, 'refs' => [ 'GetParametersForExportInput$SigningKeyAlgorithm' => '<p>The signing key algorithm to generate a signing key certificate. This certificate signs the wrapped key under export within the TR-34 key block. <code>RSA_2048</code> is the only signing key algorithm allowed.</p>', 'GetParametersForExportOutput$SigningKeyAlgorithm' => '<p>The algorithm of the signing key certificate for use in TR-34 key block generation. <code>RSA_2048</code> is the only signing key algorithm allowed.</p>', 'GetParametersForImportInput$WrappingKeyAlgorithm' => '<p>The wrapping key algorithm to generate a wrapping key certificate. This certificate wraps the key under import.</p> <p>At this time, <code>RSA_2048</code> is the allowed algorithm for TR-34 WrappedKeyBlock import. Additionally, <code>RSA_2048</code>, <code>RSA_3072</code>, <code>RSA_4096</code> are the allowed algorithms for RSA WrappedKeyCryptogram import.</p>', 'GetParametersForImportOutput$WrappingKeyAlgorithm' => '<p>The algorithm of the wrapping key for use within TR-34 WrappedKeyBlock or RSA WrappedKeyCryptogram.</p>', 'KeyAttributes$KeyAlgorithm' => '<p>The key algorithm to be use during creation of an Amazon Web Services Payment Cryptography key.</p> <p>For symmetric keys, Amazon Web Services Payment Cryptography supports <code>AES</code> and <code>TDES</code> algorithms. For asymmetric keys, Amazon Web Services Payment Cryptography supports <code>RSA</code> and <code>ECC_NIST</code> algorithms.</p>', ], ], 'KeyArn' => [ 'base' => NULL, 'refs' => [ 'Alias$KeyArn' => '<p>The <code>KeyARN</code> of the key associated with the alias.</p>', 'CreateAliasInput$KeyArn' => '<p>The <code>KeyARN</code> of the key to associate with the alias.</p>', 'Key$KeyArn' => '<p>The Amazon Resource Name (ARN) of the key.</p>', 'KeySummary$KeyArn' => '<p>The Amazon Resource Name (ARN) of the key.</p>', 'UpdateAliasInput$KeyArn' => '<p>The <code>KeyARN</code> for the key that you are updating or removing from the alias.</p>', 'WrappedKey$WrappingKeyArn' => '<p>The <code>KeyARN</code> of the wrapped key.</p>', ], ], 'KeyArnOrKeyAliasType' => [ 'base' => NULL, 'refs' => [ 'DeleteKeyInput$KeyIdentifier' => '<p>The <code>KeyARN</code> of the key that is scheduled for deletion.</p>', 'ExportKeyCryptogram$CertificateAuthorityPublicKeyIdentifier' => '<p>The <code>KeyARN</code> of the certificate chain that signs the wrapping key certificate during RSA wrap and unwrap key export.</p>', 'ExportKeyInput$ExportKeyIdentifier' => '<p>The <code>KeyARN</code> of the key under export from Amazon Web Services Payment Cryptography.</p>', 'ExportTr31KeyBlock$WrappingKeyIdentifier' => '<p>The <code>KeyARN</code> of the the wrapping key. This key encrypts or wraps the key under export for TR-31 key block generation.</p>', 'ExportTr34KeyBlock$CertificateAuthorityPublicKeyIdentifier' => '<p>The <code>KeyARN</code> of the certificate chain that signs the wrapping key certificate during TR-34 key export.</p>', 'GetKeyInput$KeyIdentifier' => '<p>The <code>KeyARN</code> of the Amazon Web Services Payment Cryptography key.</p>', 'GetPublicKeyCertificateInput$KeyIdentifier' => '<p>The <code>KeyARN</code> of the asymmetric key pair.</p>', 'ImportTr31KeyBlock$WrappingKeyIdentifier' => '<p>The <code>KeyARN</code> of the key that will decrypt or unwrap a TR-31 key block during import.</p>', 'ImportTr34KeyBlock$CertificateAuthorityPublicKeyIdentifier' => '<p>The <code>KeyARN</code> of the certificate chain that signs the signing key certificate during TR-34 key import.</p>', 'RestoreKeyInput$KeyIdentifier' => '<p>The <code>KeyARN</code> of the key to be restored within Amazon Web Services Payment Cryptography.</p>', 'StartKeyUsageInput$KeyIdentifier' => '<p>The <code>KeyArn</code> of the key.</p>', 'StopKeyUsageInput$KeyIdentifier' => '<p>The <code>KeyArn</code> of the key.</p>', 'TrustedCertificatePublicKey$CertificateAuthorityPublicKeyIdentifier' => '<p>The <code>KeyARN</code> of the root public key certificate or certificate chain that signs the trusted public key certificate import.</p>', ], ], 'KeyAttributes' => [ 'base' => '<p>The role of the key, the algorithm it supports, and the cryptographic operations allowed with the key. This data is immutable after the key is created.</p>', 'refs' => [ 'CreateKeyInput$KeyAttributes' => '<p>The role of the key, the algorithm it supports, and the cryptographic operations allowed with the key. This data is immutable after the key is created.</p>', 'ImportKeyCryptogram$KeyAttributes' => NULL, 'Key$KeyAttributes' => '<p>The role of the key, the algorithm it supports, and the cryptographic operations allowed with the key. This data is immutable after the key is created.</p>', 'KeySummary$KeyAttributes' => '<p>The role of the key, the algorithm it supports, and the cryptographic operations allowed with the key. This data is immutable after the key is created.</p>', 'RootCertificatePublicKey$KeyAttributes' => '<p>The role of the key, the algorithm it supports, and the cryptographic operations allowed with the key. This data is immutable after the root public key is imported.</p>', 'TrustedCertificatePublicKey$KeyAttributes' => '<p>The role of the key, the algorithm it supports, and the cryptographic operations allowed with the key. This data is immutable after a trusted public key is imported.</p>', ], ], 'KeyBlockHeaders' => [ 'base' => '<p>Optional metadata for export associated with the key material. This data is signed but transmitted in clear text.</p>', 'refs' => [ 'ExportTr31KeyBlock$KeyBlockHeaders' => '<p>Optional metadata for export associated with the key material. This data is signed but transmitted in clear text.</p>', 'ExportTr34KeyBlock$KeyBlockHeaders' => '<p>Optional metadata for export associated with the key material. This data is signed but transmitted in clear text.</p>', ], ], 'KeyCheckValue' => [ 'base' => NULL, 'refs' => [ 'Key$KeyCheckValue' => '<p>The key check value (KCV) is used to check if all parties holding a given key have the same key or to detect that a key has changed.</p>', 'KeySummary$KeyCheckValue' => '<p>The key check value (KCV) is used to check if all parties holding a given key have the same key or to detect that a key has changed.</p>', 'WrappedKey$KeyCheckValue' => '<p>The key check value (KCV) is used to check if all parties holding a given key have the same key or to detect that a key has changed.</p>', ], ], 'KeyCheckValueAlgorithm' => [ 'base' => NULL, 'refs' => [ 'CreateKeyInput$KeyCheckValueAlgorithm' => '<p>The algorithm that Amazon Web Services Payment Cryptography uses to calculate the key check value (KCV). It is used to validate the key integrity.</p> <p>For TDES keys, the KCV is computed by encrypting 8 bytes, each with value of zero, with the key to be checked and retaining the 3 highest order bytes of the encrypted result. For AES keys, the KCV is computed using a CMAC algorithm where the input data is 16 bytes of zero and retaining the 3 highest order bytes of the encrypted result.</p>', 'ExportAttributes$KeyCheckValueAlgorithm' => '<p>The algorithm that Amazon Web Services Payment Cryptography uses to calculate the key check value (KCV). It is used to validate the key integrity. Specify KCV for IPEK export only.</p> <p>For TDES keys, the KCV is computed by encrypting 8 bytes, each with value of zero, with the key to be checked and retaining the 3 highest order bytes of the encrypted result. For AES keys, the KCV is computed using a CMAC algorithm where the input data is 16 bytes of zero and retaining the 3 highest order bytes of the encrypted result.</p>', 'ImportKeyInput$KeyCheckValueAlgorithm' => '<p>The algorithm that Amazon Web Services Payment Cryptography uses to calculate the key check value (KCV). It is used to validate the key integrity.</p> <p>For TDES keys, the KCV is computed by encrypting 8 bytes, each with value of zero, with the key to be checked and retaining the 3 highest order bytes of the encrypted result. For AES keys, the KCV is computed using a CMAC algorithm where the input data is 16 bytes of zero and retaining the 3 highest order bytes of the encrypted result.</p>', 'Key$KeyCheckValueAlgorithm' => '<p>The algorithm that Amazon Web Services Payment Cryptography uses to calculate the key check value (KCV). It is used to validate the key integrity.</p> <p>For TDES keys, the KCV is computed by encrypting 8 bytes, each with value of zero, with the key to be checked and retaining the 3 highest order bytes of the encrypted result. For AES keys, the KCV is computed using a CMAC algorithm where the input data is 16 bytes of zero and retaining the 3 highest order bytes of the encrypted result.</p>', 'WrappedKey$KeyCheckValueAlgorithm' => '<p>The algorithm that Amazon Web Services Payment Cryptography uses to calculate the key check value (KCV). It is used to validate the key integrity.</p> <p>For TDES keys, the KCV is computed by encrypting 8 bytes, each with value of zero, with the key to be checked and retaining the 3 highest order bytes of the encrypted result. For AES keys, the KCV is computed using a CMAC algorithm where the input data is 16 bytes of zero and retaining the 3 highest order bytes of the encrypted result.</p>', ], ], 'KeyClass' => [ 'base' => NULL, 'refs' => [ 'KeyAttributes$KeyClass' => '<p>The type of Amazon Web Services Payment Cryptography key to create, which determines the classiﬁcation of the cryptographic method and whether Amazon Web Services Payment Cryptography key contains a symmetric key or an asymmetric key pair.</p>', ], ], 'KeyExportability' => [ 'base' => NULL, 'refs' => [ 'KeyBlockHeaders$KeyExportability' => '<p>Specifies subsequent exportability of the key within the key block after it is received by the receiving party. It can be used to further restrict exportability of the key after export from Amazon Web Services Payment Cryptography.</p> <p>When set to <code>EXPORTABLE</code>, the key can be subsequently exported by the receiver under a KEK using TR-31 or TR-34 key block export only. When set to <code>NON_EXPORTABLE</code>, the key cannot be subsequently exported by the receiver. When set to <code>SENSITIVE</code>, the key can be exported by the receiver under a KEK using TR-31, TR-34, RSA wrap and unwrap cryptogram or using a symmetric cryptogram key export method. For further information refer to <a href="https://webstore.ansi.org/standards/ascx9/ansix91432022">ANSI X9.143-2022</a>.</p>', ], ], 'KeyMaterial' => [ 'base' => NULL, 'refs' => [ 'WrappedKey$KeyMaterial' => '<p>Parameter information for generating a wrapped key using TR-31 or TR-34 skey exchange method.</p>', ], ], 'KeyMaterialType' => [ 'base' => NULL, 'refs' => [ 'GetParametersForExportInput$KeyMaterialType' => '<p>The key block format type (for example, TR-34 or TR-31) to use during key material export. Export token is only required for a TR-34 key export, <code>TR34_KEY_BLOCK</code>. Export token is not required for TR-31 key export.</p>', 'GetParametersForImportInput$KeyMaterialType' => '<p>The method to use for key material import. Import token is only required for TR-34 WrappedKeyBlock (<code>TR34_KEY_BLOCK</code>) and RSA WrappedKeyCryptogram (<code>KEY_CRYPTOGRAM</code>).</p> <p>Import token is not required for TR-31, root public key cerificate or trusted public key certificate.</p>', ], ], 'KeyModesOfUse' => [ 'base' => '<p>The list of cryptographic operations that you can perform using the key. The modes of use are deﬁned in section A.5.3 of the TR-31 spec.</p>', 'refs' => [ 'KeyAttributes$KeyModesOfUse' => '<p>The list of cryptographic operations that you can perform using the key.</p>', 'KeyBlockHeaders$KeyModesOfUse' => NULL, ], ], 'KeyOrigin' => [ 'base' => '<p>Defines the source of a key</p>', 'refs' => [ 'Key$KeyOrigin' => '<p>The source of the key material. For keys created within Amazon Web Services Payment Cryptography, the value is <code>AWS_PAYMENT_CRYPTOGRAPHY</code>. For keys imported into Amazon Web Services Payment Cryptography, the value is <code>EXTERNAL</code>.</p>', ], ], 'KeyState' => [ 'base' => '<p>Defines the state of a key</p>', 'refs' => [ 'Key$KeyState' => '<p>The state of key that is being created or deleted.</p>', 'KeySummary$KeyState' => '<p>The state of an Amazon Web Services Payment Cryptography that is being created or deleted.</p>', 'ListKeysInput$KeyState' => '<p>The key state of the keys you want to list.</p>', ], ], 'KeySummary' => [ 'base' => '<p>Metadata about an Amazon Web Services Payment Cryptography key.</p>', 'refs' => [ 'KeySummaryList$member' => NULL, ], ], 'KeySummaryList' => [ 'base' => NULL, 'refs' => [ 'ListKeysOutput$Keys' => '<p>The list of keys created within the caller\'s Amazon Web Services account and Amazon Web Services Region.</p>', ], ], 'KeyUsage' => [ 'base' => NULL, 'refs' => [ 'KeyAttributes$KeyUsage' => '<p>The cryptographic usage of an Amazon Web Services Payment Cryptography key as deﬁned in section A.5.2 of the TR-31 spec.</p>', ], ], 'KeyVersion' => [ 'base' => NULL, 'refs' => [ 'KeyBlockHeaders$KeyVersion' => '<p>Parameter used to indicate the version of the key carried in the key block or indicate the value carried in the key block is a component of a key.</p>', ], ], 'ListAliasesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListAliasesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListKeysInput' => [ 'base' => NULL, 'refs' => [], ], 'ListKeysOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListAliasesInput$MaxResults' => '<p>Use this parameter to specify the maximum number of items to return. When this value is present, Amazon Web Services Payment Cryptography does not return more than the specified number of items, but it might return fewer.</p> <p>This value is optional. If you include a value, it must be between 1 and 100, inclusive. If you do not include a value, it defaults to 50.</p>', 'ListKeysInput$MaxResults' => '<p>Use this parameter to specify the maximum number of items to return. When this value is present, Amazon Web Services Payment Cryptography does not return more than the specified number of items, but it might return fewer.</p> <p>This value is optional. If you include a value, it must be between 1 and 100, inclusive. If you do not include a value, it defaults to 50.</p>', 'ListTagsForResourceInput$MaxResults' => '<p>Use this parameter to specify the maximum number of items to return. When this value is present, Amazon Web Services Payment Cryptography does not return more than the specified number of items, but it might return fewer.</p> <p>This value is optional. If you include a value, it must be between 1 and 100, inclusive. If you do not include a value, it defaults to 50.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListAliasesInput$NextToken' => '<p>Use this parameter in a subsequent request after you receive a response with truncated results. Set it to the value of <code>NextToken</code> from the truncated response you just received.</p>', 'ListAliasesOutput$NextToken' => '<p>The token for the next set of results, or an empty or null value if there are no more results.</p>', 'ListKeysInput$NextToken' => '<p>Use this parameter in a subsequent request after you receive a response with truncated results. Set it to the value of <code>NextToken</code> from the truncated response you just received.</p>', 'ListKeysOutput$NextToken' => '<p>The token for the next set of results, or an empty or null value if there are no more results.</p>', 'ListTagsForResourceInput$NextToken' => '<p>Use this parameter in a subsequent request after you receive a response with truncated results. Set it to the value of <code>NextToken</code> from the truncated response you just received.</p>', 'ListTagsForResourceOutput$NextToken' => '<p>The token for the next set of results, or an empty or null value if there are no more results.</p>', ], ], 'OptionalBlockId' => [ 'base' => NULL, 'refs' => [ 'OptionalBlocks$key' => NULL, ], ], 'OptionalBlockValue' => [ 'base' => NULL, 'refs' => [ 'OptionalBlocks$value' => NULL, ], ], 'OptionalBlocks' => [ 'base' => NULL, 'refs' => [ 'KeyBlockHeaders$OptionalBlocks' => '<p>Parameter used to indicate the type of optional data in key block headers. Refer to <a href="https://webstore.ansi.org/standards/ascx9/ansix91432022">ANSI X9.143-2022</a> for information on allowed data type for optional blocks.</p> <p>Optional block character limit is 112 characters. For each optional block, 2 characters are reserved for optional block ID and 2 characters reserved for optional block length. More than one optional blocks can be included as long as the combined length does not increase 112 characters.</p>', ], ], 'PrimitiveBoolean' => [ 'base' => NULL, 'refs' => [ 'KeyModesOfUse$Encrypt' => '<p>Speciﬁes whether an Amazon Web Services Payment Cryptography key can be used to encrypt data.</p>', 'KeyModesOfUse$Decrypt' => '<p>Speciﬁes whether an Amazon Web Services Payment Cryptography key can be used to decrypt data.</p>', 'KeyModesOfUse$Wrap' => '<p>Speciﬁes whether an Amazon Web Services Payment Cryptography key can be used to wrap other keys.</p>', 'KeyModesOfUse$Unwrap' => '<p>Speciﬁes whether an Amazon Web Services Payment Cryptography key can be used to unwrap other keys.</p>', 'KeyModesOfUse$Generate' => '<p>Speciﬁes whether an Amazon Web Services Payment Cryptography key can be used to generate and verify other card and PIN verification keys.</p>', 'KeyModesOfUse$Sign' => '<p>Speciﬁes whether an Amazon Web Services Payment Cryptography key can be used for signing.</p>', 'KeyModesOfUse$Verify' => '<p>Speciﬁes whether an Amazon Web Services Payment Cryptography key can be used to verify signatures.</p>', 'KeyModesOfUse$DeriveKey' => '<p>Speciﬁes whether an Amazon Web Services Payment Cryptography key can be used to derive new keys.</p>', 'KeyModesOfUse$NoRestrictions' => '<p>Speciﬁes whether an Amazon Web Services Payment Cryptography key has no special restrictions other than the restrictions implied by <code>KeyUsage</code>.</p>', ], ], 'ResourceArn' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceInput$ResourceArn' => '<p>The <code>KeyARN</code> of the key whose tags you are getting.</p>', 'TagResourceInput$ResourceArn' => '<p>The <code>KeyARN</code> of the key whose tags are being updated.</p>', 'UntagResourceInput$ResourceArn' => '<p>The <code>KeyARN</code> of the key whose tags are being removed.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The request was denied due to an invalid resource error.</p>', 'refs' => [], ], 'RestoreKeyInput' => [ 'base' => NULL, 'refs' => [], ], 'RestoreKeyOutput' => [ 'base' => NULL, 'refs' => [], ], 'RootCertificatePublicKey' => [ 'base' => '<p>Parameter information for root public key certificate import.</p>', 'refs' => [ 'ImportKeyMaterial$RootCertificatePublicKey' => '<p>Parameter information for root public key certificate import.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>This request would cause a service quota to be exceeded.</p>', 'refs' => [], ], 'ServiceUnavailableException' => [ 'base' => '<p>The service cannot complete the request.</p>', 'refs' => [], ], 'StartKeyUsageInput' => [ 'base' => NULL, 'refs' => [], ], 'StartKeyUsageOutput' => [ 'base' => NULL, 'refs' => [], ], 'StopKeyUsageInput' => [ 'base' => NULL, 'refs' => [], ], 'StopKeyUsageOutput' => [ 'base' => NULL, 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => NULL, 'ConflictException$Message' => NULL, 'InternalServerException$Message' => NULL, 'ResourceNotFoundException$ResourceId' => '<p>The string for the exception.</p>', 'ServiceQuotaExceededException$Message' => NULL, 'ServiceUnavailableException$Message' => NULL, 'ThrottlingException$Message' => NULL, 'ValidationException$Message' => NULL, ], ], 'Tag' => [ 'base' => '<p>A structure that contains information about a tag.</p>', 'refs' => [ 'Tags$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The key of the tag.</p>', 'TagKeys$member' => NULL, ], ], 'TagKeys' => [ 'base' => NULL, 'refs' => [ 'UntagResourceInput$TagKeys' => '<p>One or more tag keys. Don\'t include the tag values.</p> <p>If the Amazon Web Services Payment Cryptography key doesn\'t have the specified tag key, Amazon Web Services Payment Cryptography doesn\'t throw an exception or return a response. To confirm that the operation succeeded, use the <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ListTagsForResource.html">ListTagsForResource</a> operation.</p>', ], ], 'TagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The value of the tag.</p>', ], ], 'Tags' => [ 'base' => NULL, 'refs' => [ 'CreateKeyInput$Tags' => '<p>Assigns one or more tags to the Amazon Web Services Payment Cryptography key. Use this parameter to tag a key when it is created. To tag an existing Amazon Web Services Payment Cryptography key, use the <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_TagResource.html">TagResource</a> operation.</p> <p>Each tag consists of a tag key and a tag value. Both the tag key and the tag value are required, but the tag value can be an empty (null) string. You can\'t have more than one tag on an Amazon Web Services Payment Cryptography key with the same tag key. </p> <important> <p>Don\'t include personal, confidential or sensitive information in this field. This field may be displayed in plaintext in CloudTrail logs and other output.</p> </important> <note> <p>Tagging or untagging an Amazon Web Services Payment Cryptography key can allow or deny permission to the key.</p> </note>', 'ImportKeyInput$Tags' => '<p>Assigns one or more tags to the Amazon Web Services Payment Cryptography key. Use this parameter to tag a key when it is imported. To tag an existing Amazon Web Services Payment Cryptography key, use the <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_TagResource.html">TagResource</a> operation.</p> <p>Each tag consists of a tag key and a tag value. Both the tag key and the tag value are required, but the tag value can be an empty (null) string. You can\'t have more than one tag on an Amazon Web Services Payment Cryptography key with the same tag key. If you specify an existing tag key with a different tag value, Amazon Web Services Payment Cryptography replaces the current tag value with the specified one.</p> <important> <p>Don\'t include personal, confidential or sensitive information in this field. This field may be displayed in plaintext in CloudTrail logs and other output.</p> </important> <note> <p>Tagging or untagging an Amazon Web Services Payment Cryptography key can allow or deny permission to the key.</p> </note>', 'ListTagsForResourceOutput$Tags' => '<p>The list of tags associated with a <code>ResourceArn</code>. Each tag will list the key-value pair contained within that tag.</p>', 'TagResourceInput$Tags' => '<p>One or more tags. Each tag consists of a tag key and a tag value. The tag value can be an empty (null) string. You can\'t have more than one tag on an Amazon Web Services Payment Cryptography key with the same tag key. If you specify an existing tag key with a different tag value, Amazon Web Services Payment Cryptography replaces the current tag value with the new one.</p> <important> <p>Don\'t include personal, confidential or sensitive information in this field. This field may be displayed in plaintext in CloudTrail logs and other output.</p> </important> <p>To use this parameter, you must have <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_TagResource.html">TagResource</a> permission in an IAM policy.</p> <important> <p>Don\'t include personal, confidential or sensitive information in this field. This field may be displayed in plaintext in CloudTrail logs and other output.</p> </important>', ], ], 'ThrottlingException' => [ 'base' => '<p>The request was denied due to request throttling.</p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'GetParametersForExportOutput$ParametersValidUntilTimestamp' => '<p>The validity period of the export token.</p>', 'GetParametersForImportOutput$ParametersValidUntilTimestamp' => '<p>The validity period of the import token.</p>', 'Key$CreateTimestamp' => '<p>The date and time when the key was created.</p>', 'Key$UsageStartTimestamp' => '<p>The date and time after which Amazon Web Services Payment Cryptography will start using the key material for cryptographic operations.</p>', 'Key$UsageStopTimestamp' => '<p>The date and time after which Amazon Web Services Payment Cryptography will stop using the key material for cryptographic operations.</p>', 'Key$DeletePendingTimestamp' => '<p>The date and time after which Amazon Web Services Payment Cryptography will delete the key. This value is present only when <code>KeyState</code> is <code>DELETE_PENDING</code> and the key is scheduled for deletion.</p>', 'Key$DeleteTimestamp' => '<p>The date and time after which Amazon Web Services Payment Cryptography will delete the key. This value is present only when when the <code>KeyState</code> is <code>DELETE_COMPLETE</code> and the Amazon Web Services Payment Cryptography key is deleted.</p>', ], ], 'Tr31WrappedKeyBlock' => [ 'base' => NULL, 'refs' => [ 'ImportTr31KeyBlock$WrappedKeyBlock' => '<p>The TR-31 wrapped key block to import.</p>', ], ], 'Tr34KeyBlockFormat' => [ 'base' => NULL, 'refs' => [ 'ExportTr34KeyBlock$KeyBlockFormat' => '<p>The format of key block that Amazon Web Services Payment Cryptography will use during key export.</p>', 'ImportTr34KeyBlock$KeyBlockFormat' => '<p>The key block format to use during key import. The only value allowed is <code>X9_TR34_2012</code>.</p>', ], ], 'Tr34WrappedKeyBlock' => [ 'base' => NULL, 'refs' => [ 'ImportTr34KeyBlock$WrappedKeyBlock' => '<p>The TR-34 wrapped key block to import.</p>', ], ], 'TrustedCertificatePublicKey' => [ 'base' => '<p>Parameter information for trusted public key certificate import.</p>', 'refs' => [ 'ImportKeyMaterial$TrustedCertificatePublicKey' => '<p>Parameter information for trusted public key certificate import.</p>', ], ], 'UntagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAliasInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAliasOutput' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>The request was denied due to an invalid request error.</p>', 'refs' => [], ], 'WrappedKey' => [ 'base' => '<p>Parameter information for generating a WrappedKeyBlock for key exchange.</p>', 'refs' => [ 'ExportKeyOutput$WrappedKey' => '<p>The key material under export as a TR-34 WrappedKeyBlock or a TR-31 WrappedKeyBlock. or a RSA WrappedKeyCryptogram.</p>', ], ], 'WrappedKeyCryptogram' => [ 'base' => NULL, 'refs' => [ 'ImportKeyCryptogram$WrappedKeyCryptogram' => '<p>The RSA wrapped key cryptogram under import.</p>', ], ], 'WrappedKeyMaterialFormat' => [ 'base' => NULL, 'refs' => [ 'WrappedKey$WrappedKeyMaterialFormat' => '<p>The key block format of a wrapped key.</p>', ], ], 'WrappingKeySpec' => [ 'base' => NULL, 'refs' => [ 'ExportKeyCryptogram$WrappingSpec' => '<p>The wrapping spec for the key under export.</p>', 'ImportKeyCryptogram$WrappingSpec' => '<p>The wrapping spec for the wrapped key cryptogram.</p>', ], ], ],];
