<?php
// This file was auto-generated from sdk-root/src/data/pinpoint-sms-voice-v2/2022-03-31/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Welcome to the <i>Amazon Pinpoint SMS and Voice, version 2 API Reference</i>. This guide provides information about Amazon Pinpoint SMS and Voice, version 2 API resources, including supported HTTP methods, parameters, and schemas.</p> <p>Amazon Pinpoint is an Amazon Web Services service that you can use to engage with your recipients across multiple messaging channels. The Amazon Pinpoint SMS and Voice, version 2 API provides programmatic access to options that are unique to the SMS and voice channels. Amazon Pinpoint SMS and Voice, version 2 resources such as phone numbers, sender IDs, and opt-out lists can be used by the Amazon Pinpoint API.</p> <p>If you\'re new to Amazon Pinpoint SMS, it\'s also helpful to review the <a href="https://docs.aws.amazon.com/sms-voice/latest/userguide/what-is-service.html"> Amazon Pinpoint SMS User Guide</a>. The <i>Amazon Pinpoint Developer Guide</i> provides tutorials, code samples, and procedures that demonstrate how to use Amazon Pinpoint SMS features programmatically and how to integrate Amazon Pinpoint functionality into mobile apps and other types of applications. The guide also provides key information, such as Amazon Pinpoint integration with other Amazon Web Services services, and the quotas that apply to use of the service.</p> <p> <b>Regional availability</b> </p> <p>The <i>Amazon Pinpoint SMS and Voice, version 2 API Reference</i> is available in several Amazon Web Services Regions and it provides an endpoint for each of these Regions. For a list of all the Regions and endpoints where the API is currently available, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#pinpoint_region">Amazon Web Services Service Endpoints</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/pinpoint.html">Amazon Pinpoint endpoints and quotas</a> in the Amazon Web Services General Reference. To learn more about Amazon Web Services Regions, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande-manage.html">Managing Amazon Web Services Regions</a> in the Amazon Web Services General Reference.</p> <p>In each Region, Amazon Web Services maintains multiple Availability Zones. These Availability Zones are physically isolated from each other, but are united by private, low-latency, high-throughput, and highly redundant network connections. These Availability Zones enable us to provide very high levels of availability and redundancy, while also minimizing latency. To learn more about the number of Availability Zones that are available in each Region, see <a href="https://aws.amazon.com/about-aws/global-infrastructure/">Amazon Web Services Global Infrastructure.</a> </p>', 'operations' => [ 'AssociateOriginationIdentity' => '<p>Associates the specified origination identity with a pool.</p> <p>If the origination identity is a phone number and is already associated with another pool, an error is returned. A sender ID can be associated with multiple pools.</p> <p>If the origination identity configuration doesn\'t match the pool\'s configuration, an error is returned.</p>', 'AssociateProtectConfiguration' => '<p>Associate a protect configuration with a configuration set. This replaces the configuration sets current protect configuration. A configuration set can only be associated with one protect configuration at a time. A protect configuration can be associated with multiple configuration sets.</p>', 'CreateConfigurationSet' => '<p>Creates a new configuration set. After you create the configuration set, you can add one or more event destinations to it.</p> <p>A configuration set is a set of rules that you apply to the SMS and voice messages that you send.</p> <p>When you send a message, you can optionally specify a single configuration set.</p>', 'CreateEventDestination' => '<p>Creates a new event destination in a configuration set.</p> <p>An event destination is a location where you send message events. The event options are Amazon CloudWatch, Amazon Kinesis Data Firehose, or Amazon SNS. For example, when a message is delivered successfully, you can send information about that event to an event destination, or send notifications to endpoints that are subscribed to an Amazon SNS topic.</p> <p>Each configuration set can contain between 0 and 5 event destinations. Each event destination can contain a reference to a single destination, such as a CloudWatch or Kinesis Data Firehose destination.</p>', 'CreateOptOutList' => '<p>Creates a new opt-out list.</p> <p>If the opt-out list name already exists, an error is returned.</p> <p>An opt-out list is a list of phone numbers that are opted out, meaning you can\'t send SMS or voice messages to them. If end user replies with the keyword "STOP," an entry for the phone number is added to the opt-out list. In addition to STOP, your recipients can use any supported opt-out keyword, such as CANCEL or OPTOUT. For a list of supported opt-out keywords, see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-manage.html#channels-sms-manage-optout"> SMS opt out </a> in the <i>Amazon Pinpoint User Guide</i>.</p>', 'CreatePool' => '<p>Creates a new pool and associates the specified origination identity to the pool. A pool can include one or more phone numbers and SenderIds that are associated with your Amazon Web Services account.</p> <p>The new pool inherits its configuration from the specified origination identity. This includes keywords, message type, opt-out list, two-way configuration, and self-managed opt-out configuration. Deletion protection isn\'t inherited from the origination identity and defaults to false.</p> <p>If the origination identity is a phone number and is already associated with another pool, an error is returned. A sender ID can be associated with multiple pools.</p>', 'CreateProtectConfiguration' => '<p>Create a new protect configuration. By default all country rule sets for each capability are set to <code>ALLOW</code>. Update the country rule sets using <code>UpdateProtectConfigurationCountryRuleSet</code>. A protect configurations name is stored as a Tag with the key set to <code>Name</code> and value as the name of the protect configuration.</p>', 'CreateRegistration' => '<p>Creates a new registration based on the <b>RegistrationType</b> field. </p>', 'CreateRegistrationAssociation' => '<p>Associate the registration with an origination identity such as a phone number or sender ID.</p>', 'CreateRegistrationAttachment' => '<p>Create a new registration attachment to use for uploading a file or a URL to a file. The maximum file size is 1MiB and valid file extensions are PDF, JPEG and PNG. For example, many sender ID registrations require a signed “letter of authorization” (LOA) to be submitted.</p>', 'CreateRegistrationVersion' => '<p>Create a new version of the registration and increase the <b>VersionNumber</b>. The previous version of the registration becomes read-only.</p>', 'CreateVerifiedDestinationNumber' => '<p>You can only send messages to verified destination numbers when your account is in the sandbox. You can add up to 10 verified destination numbers.</p>', 'DeleteAccountDefaultProtectConfiguration' => '<p>Removes the current account default protect configuration.</p>', 'DeleteConfigurationSet' => '<p>Deletes an existing configuration set.</p> <p>A configuration set is a set of rules that you apply to voice and SMS messages that you send. In a configuration set, you can specify a destination for specific types of events related to voice and SMS messages. </p>', 'DeleteDefaultMessageType' => '<p>Deletes an existing default message type on a configuration set.</p> <p> A message type is a type of messages that you plan to send. If you send account-related messages or time-sensitive messages such as one-time passcodes, choose <b>Transactional</b>. If you plan to send messages that contain marketing material or other promotional content, choose <b>Promotional</b>. This setting applies to your entire Amazon Web Services account. </p>', 'DeleteDefaultSenderId' => '<p>Deletes an existing default sender ID on a configuration set.</p> <p>A default sender ID is the identity that appears on recipients\' devices when they receive SMS messages. Support for sender ID capabilities varies by country or region.</p>', 'DeleteEventDestination' => '<p>Deletes an existing event destination.</p> <p>An event destination is a location where you send response information about the messages that you send. For example, when a message is delivered successfully, you can send information about that event to an Amazon CloudWatch destination, or send notifications to endpoints that are subscribed to an Amazon SNS topic.</p>', 'DeleteKeyword' => '<p>Deletes an existing keyword from an origination phone number or pool.</p> <p>A keyword is a word that you can search for on a particular phone number or pool. It is also a specific word or phrase that an end user can send to your number to elicit a response, such as an informational message or a special offer. When your number receives a message that begins with a keyword, Amazon Pinpoint responds with a customizable message.</p> <p>Keywords "HELP" and "STOP" can\'t be deleted or modified.</p>', 'DeleteMediaMessageSpendLimitOverride' => '<p>Deletes an account-level monthly spending limit override for sending multimedia messages (MMS). Deleting a spend limit override will set the <code>EnforcedLimit</code> to equal the <code>MaxLimit</code>, which is controlled by Amazon Web Services. For more information on spend limits (quotas) see <a href="https://docs.aws.amazon.com/sms-voice/latest/userguide/quotas.html">Quotas for Server Migration Service</a> in the <i>Server Migration Service User Guide</i>.</p>', 'DeleteOptOutList' => '<p>Deletes an existing opt-out list. All opted out phone numbers in the opt-out list are deleted.</p> <p>If the specified opt-out list name doesn\'t exist or is in-use by an origination phone number or pool, an error is returned.</p>', 'DeleteOptedOutNumber' => '<p>Deletes an existing opted out destination phone number from the specified opt-out list.</p> <p>Each destination phone number can only be deleted once every 30 days.</p> <p>If the specified destination phone number doesn\'t exist or if the opt-out list doesn\'t exist, an error is returned.</p>', 'DeletePool' => '<p>Deletes an existing pool. Deleting a pool disassociates all origination identities from that pool.</p> <p>If the pool status isn\'t active or if deletion protection is enabled, an error is returned.</p> <p>A pool is a collection of phone numbers and SenderIds. A pool can include one or more phone numbers and SenderIds that are associated with your Amazon Web Services account.</p>', 'DeleteProtectConfiguration' => '<p>Permanently delete the protect configuration. The protect configuration must have deletion protection disabled and must not be associated as the account default protect configuration or associated with a configuration set.</p>', 'DeleteRegistration' => '<p>Permanently delete an existing registration from your account.</p>', 'DeleteRegistrationAttachment' => '<p>Permanently delete the specified registration attachment.</p>', 'DeleteRegistrationFieldValue' => '<p>Delete the value in a registration form field.</p>', 'DeleteTextMessageSpendLimitOverride' => '<p>Deletes an account-level monthly spending limit override for sending text messages. Deleting a spend limit override will set the <code>EnforcedLimit</code> to equal the <code>MaxLimit</code>, which is controlled by Amazon Web Services. For more information on spend limits (quotas) see <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/quotas.html">Amazon Pinpoint quotas </a> in the <i>Amazon Pinpoint Developer Guide</i>.</p>', 'DeleteVerifiedDestinationNumber' => '<p>Delete a verified destination phone number.</p>', 'DeleteVoiceMessageSpendLimitOverride' => '<p>Deletes an account level monthly spend limit override for sending voice messages. Deleting a spend limit override sets the <code>EnforcedLimit</code> equal to the <code>MaxLimit</code>, which is controlled by Amazon Web Services. For more information on spending limits (quotas) see <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/quotas.html">Amazon Pinpoint quotas</a> in the <i>Amazon Pinpoint Developer Guide</i>.</p>', 'DescribeAccountAttributes' => '<p>Describes attributes of your Amazon Web Services account. The supported account attributes include account tier, which indicates whether your account is in the sandbox or production environment. When you\'re ready to move your account out of the sandbox, create an Amazon Web Services Support case for a service limit increase request.</p> <p>New Amazon Pinpoint accounts are placed into an SMS or voice sandbox. The sandbox protects both Amazon Web Services end recipients and SMS or voice recipients from fraud and abuse. </p>', 'DescribeAccountLimits' => '<p>Describes the current Amazon Pinpoint SMS Voice V2 resource quotas for your account. The description for a quota includes the quota name, current usage toward that quota, and the quota\'s maximum value.</p> <p>When you establish an Amazon Web Services account, the account has initial quotas on the maximum number of configuration sets, opt-out lists, phone numbers, and pools that you can create in a given Region. For more information see <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/quotas.html"> Amazon Pinpoint quotas </a> in the <i>Amazon Pinpoint Developer Guide</i>.</p>', 'DescribeConfigurationSets' => '<p>Describes the specified configuration sets or all in your account.</p> <p>If you specify configuration set names, the output includes information for only the specified configuration sets. If you specify filters, the output includes information for only those configuration sets that meet the filter criteria. If you don\'t specify configuration set names or filters, the output includes information for all configuration sets.</p> <p>If you specify a configuration set name that isn\'t valid, an error is returned.</p>', 'DescribeKeywords' => '<p>Describes the specified keywords or all keywords on your origination phone number or pool.</p> <p>A keyword is a word that you can search for on a particular phone number or pool. It is also a specific word or phrase that an end user can send to your number to elicit a response, such as an informational message or a special offer. When your number receives a message that begins with a keyword, Amazon Pinpoint responds with a customizable message.</p> <p>If you specify a keyword that isn\'t valid, an error is returned.</p>', 'DescribeOptOutLists' => '<p>Describes the specified opt-out list or all opt-out lists in your account.</p> <p>If you specify opt-out list names, the output includes information for only the specified opt-out lists. Opt-out lists include only those that meet the filter criteria. If you don\'t specify opt-out list names or filters, the output includes information for all opt-out lists.</p> <p>If you specify an opt-out list name that isn\'t valid, an error is returned.</p>', 'DescribeOptedOutNumbers' => '<p>Describes the specified opted out destination numbers or all opted out destination numbers in an opt-out list.</p> <p>If you specify opted out numbers, the output includes information for only the specified opted out numbers. If you specify filters, the output includes information for only those opted out numbers that meet the filter criteria. If you don\'t specify opted out numbers or filters, the output includes information for all opted out destination numbers in your opt-out list.</p> <p>If you specify an opted out number that isn\'t valid, an error is returned.</p>', 'DescribePhoneNumbers' => '<p>Describes the specified origination phone number, or all the phone numbers in your account.</p> <p>If you specify phone number IDs, the output includes information for only the specified phone numbers. If you specify filters, the output includes information for only those phone numbers that meet the filter criteria. If you don\'t specify phone number IDs or filters, the output includes information for all phone numbers.</p> <p>If you specify a phone number ID that isn\'t valid, an error is returned.</p>', 'DescribePools' => '<p>Retrieves the specified pools or all pools associated with your Amazon Web Services account.</p> <p>If you specify pool IDs, the output includes information for only the specified pools. If you specify filters, the output includes information for only those pools that meet the filter criteria. If you don\'t specify pool IDs or filters, the output includes information for all pools.</p> <p>If you specify a pool ID that isn\'t valid, an error is returned.</p> <p>A pool is a collection of phone numbers and SenderIds. A pool can include one or more phone numbers and SenderIds that are associated with your Amazon Web Services account.</p>', 'DescribeProtectConfigurations' => '<p>Retrieves the protect configurations that match any of filters. If a filter isn’t provided then all protect configurations are returned.</p>', 'DescribeRegistrationAttachments' => '<p>Retrieves the specified registration attachments or all registration attachments associated with your Amazon Web Services account.</p>', 'DescribeRegistrationFieldDefinitions' => '<p>Retrieves the specified registration type field definitions. You can use DescribeRegistrationFieldDefinitions to view the requirements for creating, filling out, and submitting each registration type.</p>', 'DescribeRegistrationFieldValues' => '<p>Retrieves the specified registration field values.</p>', 'DescribeRegistrationSectionDefinitions' => '<p>Retrieves the specified registration section definitions. You can use DescribeRegistrationSectionDefinitions to view the requirements for creating, filling out, and submitting each registration type.</p>', 'DescribeRegistrationTypeDefinitions' => '<p>Retrieves the specified registration type definitions. You can use DescribeRegistrationTypeDefinitions to view the requirements for creating, filling out, and submitting each registration type.</p>', 'DescribeRegistrationVersions' => '<p>Retrieves the specified registration version.</p>', 'DescribeRegistrations' => '<p>Retrieves the specified registrations.</p>', 'DescribeSenderIds' => '<p>Describes the specified SenderIds or all SenderIds associated with your Amazon Web Services account.</p> <p>If you specify SenderIds, the output includes information for only the specified SenderIds. If you specify filters, the output includes information for only those SenderIds that meet the filter criteria. If you don\'t specify SenderIds or filters, the output includes information for all SenderIds.</p> <p>f you specify a sender ID that isn\'t valid, an error is returned.</p>', 'DescribeSpendLimits' => '<p>Describes the current Amazon Pinpoint monthly spend limits for sending voice and text messages.</p> <p>When you establish an Amazon Web Services account, the account has initial monthly spend limit in a given Region. For more information on increasing your monthly spend limit, see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-awssupport-spend-threshold.html"> Requesting increases to your monthly SMS spending quota for Amazon Pinpoint </a> in the <i>Amazon Pinpoint User Guide</i>.</p>', 'DescribeVerifiedDestinationNumbers' => '<p>Retrieves the specified verified destiona numbers.</p>', 'DisassociateOriginationIdentity' => '<p>Removes the specified origination identity from an existing pool.</p> <p>If the origination identity isn\'t associated with the specified pool, an error is returned.</p>', 'DisassociateProtectConfiguration' => '<p>Disassociate a protect configuration from a configuration set.</p>', 'DiscardRegistrationVersion' => '<p>Discard the current version of the registration.</p>', 'GetProtectConfigurationCountryRuleSet' => '<p>Retrieve the CountryRuleSet for the specified NumberCapability from a protect configuration.</p>', 'ListPoolOriginationIdentities' => '<p>Lists all associated origination identities in your pool.</p> <p>If you specify filters, the output includes information for only those origination identities that meet the filter criteria.</p>', 'ListRegistrationAssociations' => '<p>Retreive all of the origination identies that are associated with a registration.</p>', 'ListTagsForResource' => '<p>List all tags associated with a resource.</p>', 'PutKeyword' => '<p>Creates or updates a keyword configuration on an origination phone number or pool.</p> <p> A keyword is a word that you can search for on a particular phone number or pool. It is also a specific word or phrase that an end user can send to your number to elicit a response, such as an informational message or a special offer. When your number receives a message that begins with a keyword, Amazon Pinpoint responds with a customizable message.</p> <p>If you specify a keyword that isn\'t valid, an error is returned.</p>', 'PutOptedOutNumber' => '<p>Creates an opted out destination phone number in the opt-out list.</p> <p>If the destination phone number isn\'t valid or if the specified opt-out list doesn\'t exist, an error is returned.</p>', 'PutRegistrationFieldValue' => '<p>Creates or updates a field value for a registration.</p>', 'ReleasePhoneNumber' => '<p>Releases an existing origination phone number in your account. Once released, a phone number is no longer available for sending messages.</p> <p>If the origination phone number has deletion protection enabled or is associated with a pool, an error is returned.</p>', 'ReleaseSenderId' => '<p>Releases an existing sender ID in your account.</p>', 'RequestPhoneNumber' => '<p>Request an origination phone number for use in your account. For more information on phone number request see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/settings-sms-request-number.html"> Requesting a number </a> in the <i>Amazon Pinpoint User Guide</i>.</p>', 'RequestSenderId' => '<p>Request a new sender ID that doesn\'t require registration. </p>', 'SendDestinationNumberVerificationCode' => '<p>Before you can send test messages to a verified destination phone number you need to opt-in the verified destination phone number. Creates a new text message with a verification code and send it to a verified destination phone number. Once you have the verification code use <a>VerifyDestinationNumber</a> to opt-in the verified destination phone number to receive messages.</p>', 'SendMediaMessage' => '<p>Creates a new multimedia message (MMS) and sends it to a recipient\'s phone number. </p>', 'SendTextMessage' => '<p>Creates a new text message and sends it to a recipient\'s phone number.</p> <p>SMS throughput limits are measured in Message Parts per Second (MPS). Your MPS limit depends on the destination country of your messages, as well as the type of phone number (origination number) that you use to send the message. For more information, see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-limitations-mps.html">Message Parts per Second (MPS) limits</a> in the <i>Amazon Pinpoint User Guide</i>.</p>', 'SendVoiceMessage' => '<p>Allows you to send a request that sends a voice message through Amazon Pinpoint. This operation uses <a href="http://aws.amazon.com/polly/">Amazon Polly</a> to convert a text script into a voice message.</p>', 'SetAccountDefaultProtectConfiguration' => '<p>Set a protect configuration as your account default. You can only have one account default protect configuration at a time. The current account default protect configuration is replaced with the provided protect configuration.</p>', 'SetDefaultMessageType' => '<p>Sets the default message type on a configuration set.</p> <p>Choose the category of SMS messages that you plan to send from this account. If you send account-related messages or time-sensitive messages such as one-time passcodes, choose <b>Transactional</b>. If you plan to send messages that contain marketing material or other promotional content, choose <b>Promotional</b>. This setting applies to your entire Amazon Web Services account.</p>', 'SetDefaultSenderId' => '<p>Sets default sender ID on a configuration set.</p> <p>When sending a text message to a destination country that supports sender IDs, the default sender ID on the configuration set specified will be used if no dedicated origination phone numbers or registered sender IDs are available in your account.</p>', 'SetMediaMessageSpendLimitOverride' => '<p>Sets an account level monthly spend limit override for sending MMS messages. The requested spend limit must be less than or equal to the <code>MaxLimit</code>, which is set by Amazon Web Services. </p>', 'SetTextMessageSpendLimitOverride' => '<p>Sets an account level monthly spend limit override for sending text messages. The requested spend limit must be less than or equal to the <code>MaxLimit</code>, which is set by Amazon Web Services. </p>', 'SetVoiceMessageSpendLimitOverride' => '<p>Sets an account level monthly spend limit override for sending voice messages. The requested spend limit must be less than or equal to the <code>MaxLimit</code>, which is set by Amazon Web Services. </p>', 'SubmitRegistrationVersion' => '<p>Submit the specified registration for review and approval.</p>', 'TagResource' => '<p>Adds or overwrites only the specified tags for the specified Amazon Pinpoint SMS Voice, version 2 resource. When you specify an existing tag key, the value is overwritten with the new value. Each resource can have a maximum of 50 tags. Each tag consists of a key and an optional value. Tag keys must be unique per resource. For more information about tags, see <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/tagging-resources.html"> Tagging Amazon Pinpoint resources</a> in the <i>Amazon Pinpoint Developer Guide</i>.</p>', 'UntagResource' => '<p>Removes the association of the specified tags from an Amazon Pinpoint SMS Voice V2 resource. For more information on tags see <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/tagging-resources.html"> Tagging Amazon Pinpoint resources</a> in the <i>Amazon Pinpoint Developer Guide</i>. </p>', 'UpdateEventDestination' => '<p>Updates an existing event destination in a configuration set. You can update the IAM role ARN for CloudWatch Logs and Kinesis Data Firehose. You can also enable or disable the event destination.</p> <p>You may want to update an event destination to change its matching event types or updating the destination resource ARN. You can\'t change an event destination\'s type between CloudWatch Logs, Kinesis Data Firehose, and Amazon SNS.</p>', 'UpdatePhoneNumber' => '<p>Updates the configuration of an existing origination phone number. You can update the opt-out list, enable or disable two-way messaging, change the TwoWayChannelArn, enable or disable self-managed opt-outs, and enable or disable deletion protection.</p> <p>If the origination phone number is associated with a pool, an error is returned.</p>', 'UpdatePool' => '<p>Updates the configuration of an existing pool. You can update the opt-out list, enable or disable two-way messaging, change the <code>TwoWayChannelArn</code>, enable or disable self-managed opt-outs, enable or disable deletion protection, and enable or disable shared routes.</p>', 'UpdateProtectConfiguration' => '<p>Update the setting for an existing protect configuration.</p>', 'UpdateProtectConfigurationCountryRuleSet' => '<p>Update a country rule set to <code>ALLOW</code> or <code>BLOCK</code> messages to be sent to the specified destination counties. You can update one or multiple countries at a time. The updates are only applied to the specified NumberCapability type.</p>', 'UpdateSenderId' => '<p>Updates the configuration of an existing sender ID.</p>', 'VerifyDestinationNumber' => '<p>Use the verification code that was received by the verified destination phone number to opt-in the verified destination phone number to receive more messages.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>The request was denied because you don\'t have sufficient permissions to access the resource.</p>', 'refs' => [], ], 'AccessDeniedExceptionReason' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Reason' => '<p>The reason for the exception.</p>', ], ], 'AccountAttribute' => [ 'base' => '<p>Displays the attributes associated with a single Amazon Web Services account.</p>', 'refs' => [ 'AccountAttributeList$member' => NULL, ], ], 'AccountAttributeList' => [ 'base' => NULL, 'refs' => [ 'DescribeAccountAttributesResult$AccountAttributes' => '<p>An array of AccountAttributes objects.</p>', ], ], 'AccountAttributeName' => [ 'base' => NULL, 'refs' => [ 'AccountAttribute$Name' => '<p>The name of the account attribute.</p>', ], ], 'AccountLimit' => [ 'base' => '<p>The current resource quotas associated with an Amazon Web Services account.</p>', 'refs' => [ 'AccountLimitList$member' => NULL, ], ], 'AccountLimitList' => [ 'base' => NULL, 'refs' => [ 'DescribeAccountLimitsResult$AccountLimits' => '<p>An array of AccountLimit objects that show the current spend limits.</p>', ], ], 'AccountLimitName' => [ 'base' => NULL, 'refs' => [ 'AccountLimit$Name' => '<p>The name of the attribute to apply the account limit to.</p>', ], ], 'AmazonResourceName' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource to query for.</p>', 'ListTagsForResourceResult$ResourceArn' => '<p>The ARN of the resource.</p>', 'TagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'UntagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', ], ], 'AssociateOriginationIdentityRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateOriginationIdentityResult' => [ 'base' => NULL, 'refs' => [], ], 'AssociateProtectConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateProtectConfigurationResult' => [ 'base' => NULL, 'refs' => [], ], 'AttachmentBody' => [ 'base' => NULL, 'refs' => [ 'CreateRegistrationAttachmentRequest$AttachmentBody' => '<p>The registration file to upload. The maximum file size is 1MiB and valid file extensions are PDF, JPEG and PNG.</p>', ], ], 'AttachmentStatus' => [ 'base' => NULL, 'refs' => [ 'CreateRegistrationAttachmentResult$AttachmentStatus' => '<p>The status of the registration attachment. </p> <ul> <li> <p> <code>UPLOAD_IN_PROGRESS</code> The attachment is being uploaded.</p> </li> <li> <p> <code>UPLOAD_COMPLETE</code> The attachment has been uploaded.</p> </li> <li> <p> <code>UPLOAD_FAILED</code> The attachment failed to uploaded.</p> </li> <li> <p> <code>DELETED</code> The attachment has been deleted..</p> </li> </ul>', 'DeleteRegistrationAttachmentResult$AttachmentStatus' => '<p>The status of the registration attachment. </p> <ul> <li> <p> <code>UPLOAD_IN_PROGRESS</code> The attachment is being uploaded.</p> </li> <li> <p> <code>UPLOAD_COMPLETE</code> The attachment has been uploaded.</p> </li> <li> <p> <code>UPLOAD_FAILED</code> The attachment failed to uploaded.</p> </li> <li> <p> <code>DELETED</code> The attachment has been deleted..</p> </li> </ul>', 'RegistrationAttachmentsInformation$AttachmentStatus' => '<p>The status of the registration attachment. </p> <ul> <li> <p> <code>UPLOAD_IN_PROGRESS</code> The attachment is being uploaded.</p> </li> <li> <p> <code>UPLOAD_COMPLETE</code> The attachment has been uploaded.</p> </li> <li> <p> <code>UPLOAD_FAILED</code> The attachment failed to uploaded.</p> </li> <li> <p> <code>DELETED</code> The attachment has been deleted..</p> </li> </ul>', ], ], 'AttachmentUploadErrorReason' => [ 'base' => NULL, 'refs' => [ 'DeleteRegistrationAttachmentResult$AttachmentUploadErrorReason' => '<p>The error message if the upload failed.</p>', 'RegistrationAttachmentsInformation$AttachmentUploadErrorReason' => '<p>A description of why the upload didn\'t successfully complete.</p>', ], ], 'AttachmentUrl' => [ 'base' => NULL, 'refs' => [ 'CreateRegistrationAttachmentRequest$AttachmentUrl' => '<p>A URL to the required registration file. For example, you can provide the S3 object URL.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'CreatePoolRequest$DeletionProtectionEnabled' => '<p>By default this is set to false. When set to true the pool can\'t be deleted. You can change this value using the <a>UpdatePool</a> action.</p>', 'CreateProtectConfigurationRequest$DeletionProtectionEnabled' => '<p>When set to true deletion protection is enabled. By default this is set to false. </p>', 'EventDestination$Enabled' => '<p>When set to true events will be logged.</p>', 'RequestPhoneNumberRequest$DeletionProtectionEnabled' => '<p>By default this is set to false. When set to true the phone number can\'t be deleted.</p>', 'RequestSenderIdRequest$DeletionProtectionEnabled' => '<p>By default this is set to false. When set to true the sender ID can\'t be deleted.</p>', 'UpdateEventDestinationRequest$Enabled' => '<p>When set to true logging is enabled.</p>', 'UpdatePhoneNumberRequest$TwoWayEnabled' => '<p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>', 'UpdatePhoneNumberRequest$SelfManagedOptOutsEnabled' => '<p>By default this is set to false. When an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you\'re responsible for responding to HELP and STOP requests. You\'re also responsible for tracking and honoring opt-out requests.</p>', 'UpdatePhoneNumberRequest$DeletionProtectionEnabled' => '<p>By default this is set to false. When set to true the phone number can\'t be deleted. </p>', 'UpdatePoolRequest$TwoWayEnabled' => '<p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>', 'UpdatePoolRequest$SelfManagedOptOutsEnabled' => '<p>By default this is set to false. When an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you\'re responsible for responding to HELP and STOP requests. You\'re also responsible for tracking and honoring opt-out requests.</p>', 'UpdatePoolRequest$SharedRoutesEnabled' => '<p>Indicates whether shared routes are enabled for the pool.</p>', 'UpdatePoolRequest$DeletionProtectionEnabled' => '<p>When set to true the pool can\'t be deleted.</p>', 'UpdateProtectConfigurationRequest$DeletionProtectionEnabled' => '<p>When set to true deletion protection is enabled. By default this is set to false. </p>', 'UpdateSenderIdRequest$DeletionProtectionEnabled' => '<p>By default this is set to false. When set to true the sender ID can\'t be deleted.</p>', ], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'AssociateOriginationIdentityRequest$ClientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don\'t specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>', 'CreateConfigurationSetRequest$ClientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don\'t specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>', 'CreateEventDestinationRequest$ClientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don\'t specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>', 'CreateOptOutListRequest$ClientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don\'t specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>', 'CreatePoolRequest$ClientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don\'t specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>', 'CreateProtectConfigurationRequest$ClientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don\'t specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>', 'CreateRegistrationAttachmentRequest$ClientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don\'t specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>', 'CreateRegistrationRequest$ClientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don\'t specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>', 'CreateVerifiedDestinationNumberRequest$ClientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don\'t specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>', 'DisassociateOriginationIdentityRequest$ClientToken' => '<p>Unique, case-sensitive identifier you provide to ensure the idempotency of the request. If you don\'t specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>', 'RequestPhoneNumberRequest$ClientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don\'t specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>', 'RequestSenderIdRequest$ClientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don\'t specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>', ], ], 'CloudWatchLogsDestination' => [ 'base' => '<p>Contains the destination configuration to use when publishing message sending events. </p>', 'refs' => [ 'CreateEventDestinationRequest$CloudWatchLogsDestination' => '<p>An object that contains information about an event destination for logging to Amazon CloudWatch Logs.</p>', 'EventDestination$CloudWatchLogsDestination' => '<p>An object that contains information about an event destination that sends logging events to Amazon CloudWatch logs.</p>', 'UpdateEventDestinationRequest$CloudWatchLogsDestination' => '<p>An object that contains information about an event destination that sends data to CloudWatch Logs.</p>', ], ], 'ConfigurationSetFilter' => [ 'base' => '<p>The information for configuration sets that meet a specified criteria.</p>', 'refs' => [ 'ConfigurationSetFilterList$member' => NULL, ], ], 'ConfigurationSetFilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeConfigurationSetsRequest$Filters' => '<p>An array of filters to apply to the results that are returned.</p>', ], ], 'ConfigurationSetFilterName' => [ 'base' => NULL, 'refs' => [ 'ConfigurationSetFilter$Name' => '<p>The name of the attribute to filter on.</p>', ], ], 'ConfigurationSetInformation' => [ 'base' => '<p>Information related to a given configuration set in your Amazon Web Services account.</p>', 'refs' => [ 'ConfigurationSetInformationList$member' => NULL, ], ], 'ConfigurationSetInformationList' => [ 'base' => NULL, 'refs' => [ 'DescribeConfigurationSetsResult$ConfigurationSets' => '<p>An array of ConfigurationSets objects.</p>', ], ], 'ConfigurationSetName' => [ 'base' => NULL, 'refs' => [ 'AssociateProtectConfigurationResult$ConfigurationSetName' => '<p>The name of the ConfigurationSet.</p>', 'ConfigurationSetInformation$ConfigurationSetName' => '<p>The name of the ConfigurationSet.</p>', 'CreateConfigurationSetRequest$ConfigurationSetName' => '<p>The name to use for the new configuration set.</p>', 'CreateConfigurationSetResult$ConfigurationSetName' => '<p>The name of the new configuration set.</p>', 'CreateEventDestinationResult$ConfigurationSetName' => '<p>The name of the configuration set.</p>', 'DeleteConfigurationSetResult$ConfigurationSetName' => '<p>The name of the deleted configuration set.</p>', 'DeleteDefaultMessageTypeResult$ConfigurationSetName' => '<p>The name of the configuration set.</p>', 'DeleteDefaultSenderIdResult$ConfigurationSetName' => '<p>The name of the configuration set.</p>', 'DeleteEventDestinationResult$ConfigurationSetName' => '<p>The name of the configuration set the event destination was deleted from.</p>', 'DisassociateProtectConfigurationResult$ConfigurationSetName' => '<p>The name of the ConfigurationSet.</p>', 'SetDefaultMessageTypeResult$ConfigurationSetName' => '<p>The name of the configuration set that was updated.</p>', 'SetDefaultSenderIdResult$ConfigurationSetName' => '<p>The name of the configuration set that was updated.</p>', 'UpdateEventDestinationResult$ConfigurationSetName' => '<p>The name of the configuration set.</p>', ], ], 'ConfigurationSetNameList' => [ 'base' => NULL, 'refs' => [ 'DescribeConfigurationSetsRequest$ConfigurationSetNames' => '<p>An array of strings. Each element can be either a ConfigurationSetName or ConfigurationSetArn.</p>', ], ], 'ConfigurationSetNameOrArn' => [ 'base' => NULL, 'refs' => [ 'AssociateProtectConfigurationRequest$ConfigurationSetName' => '<p>The name of the ConfigurationSet.</p>', 'ConfigurationSetNameList$member' => NULL, 'CreateEventDestinationRequest$ConfigurationSetName' => '<p>Either the name of the configuration set or the configuration set ARN to apply event logging to. The ConfigurateSetName and ConfigurationSetArn can be found using the <a>DescribeConfigurationSets</a> action.</p>', 'DeleteConfigurationSetRequest$ConfigurationSetName' => '<p>The name of the configuration set or the configuration set ARN that you want to delete. The ConfigurationSetName and ConfigurationSetArn can be found using the <a>DescribeConfigurationSets</a> action.</p>', 'DeleteDefaultMessageTypeRequest$ConfigurationSetName' => '<p>The name of the configuration set or the configuration set Amazon Resource Name (ARN) to delete the default message type from. The ConfigurationSetName and ConfigurationSetArn can be found using the <a>DescribeConfigurationSets</a> action.</p>', 'DeleteDefaultSenderIdRequest$ConfigurationSetName' => '<p>The name of the configuration set or the configuration set Amazon Resource Name (ARN) to delete the default sender ID from. The ConfigurationSetName and ConfigurationSetArn can be found using the <a>DescribeConfigurationSets</a> action.</p>', 'DeleteEventDestinationRequest$ConfigurationSetName' => '<p>The name of the configuration set or the configuration set\'s Amazon Resource Name (ARN) to remove the event destination from. The ConfigurateSetName and ConfigurationSetArn can be found using the <a>DescribeConfigurationSets</a> action.</p>', 'DisassociateProtectConfigurationRequest$ConfigurationSetName' => '<p>The name of the ConfigurationSet.</p>', 'SendDestinationNumberVerificationCodeRequest$ConfigurationSetName' => '<p>The name of the configuration set to use. This can be either the ConfigurationSetName or ConfigurationSetArn.</p>', 'SendMediaMessageRequest$ConfigurationSetName' => '<p>The name of the configuration set to use. This can be either the ConfigurationSetName or ConfigurationSetArn.</p>', 'SendTextMessageRequest$ConfigurationSetName' => '<p>The name of the configuration set to use. This can be either the ConfigurationSetName or ConfigurationSetArn.</p>', 'SendVoiceMessageRequest$ConfigurationSetName' => '<p>The name of the configuration set to use. This can be either the ConfigurationSetName or ConfigurationSetArn.</p>', 'SetDefaultMessageTypeRequest$ConfigurationSetName' => '<p>The configuration set to update with a new default message type. This field can be the ConsigurationSetName or ConfigurationSetArn.</p>', 'SetDefaultSenderIdRequest$ConfigurationSetName' => '<p>The configuration set to updated with a new default SenderId. This field can be the ConsigurationSetName or ConfigurationSetArn.</p>', 'UpdateEventDestinationRequest$ConfigurationSetName' => '<p>The configuration set to update with the new event destination. Valid values for this can be the ConfigurationSetName or ConfigurationSetArn.</p>', ], ], 'ConflictException' => [ 'base' => '<p>Your request has conflicting operations. This can occur if you\'re trying to perform more than one operation on the same resource at the same time or it could be that the requested action isn\'t valid for the current state or configuration of the resource.</p>', 'refs' => [], ], 'ConflictExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ConflictException$Reason' => '<p>The reason for the exception.</p>', ], ], 'ContextKey' => [ 'base' => NULL, 'refs' => [ 'ContextMap$key' => NULL, ], ], 'ContextMap' => [ 'base' => NULL, 'refs' => [ 'SendDestinationNumberVerificationCodeRequest$Context' => '<p>You can specify custom data in this field. If you do, that data is logged to the event destination.</p>', 'SendMediaMessageRequest$Context' => '<p>You can specify custom data in this field. If you do, that data is logged to the event destination.</p>', 'SendTextMessageRequest$Context' => '<p>You can specify custom data in this field. If you do, that data is logged to the event destination.</p>', 'SendVoiceMessageRequest$Context' => '<p>You can specify custom data in this field. If you do, that data is logged to the event destination.</p>', ], ], 'ContextValue' => [ 'base' => NULL, 'refs' => [ 'ContextMap$value' => NULL, ], ], 'CreateConfigurationSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateConfigurationSetResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateEventDestinationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateEventDestinationResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateOptOutListRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateOptOutListResult' => [ 'base' => NULL, 'refs' => [], ], 'CreatePoolRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreatePoolResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateProtectConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateProtectConfigurationResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateRegistrationAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateRegistrationAssociationResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateRegistrationAttachmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateRegistrationAttachmentResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateRegistrationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateRegistrationResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateRegistrationVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateRegistrationVersionResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateVerifiedDestinationNumberRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateVerifiedDestinationNumberResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAccountDefaultProtectConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAccountDefaultProtectConfigurationResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteConfigurationSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteConfigurationSetResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDefaultMessageTypeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDefaultMessageTypeResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDefaultSenderIdRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDefaultSenderIdResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEventDestinationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEventDestinationResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteKeywordRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteKeywordResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMediaMessageSpendLimitOverrideRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMediaMessageSpendLimitOverrideResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteOptOutListRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteOptOutListResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteOptedOutNumberRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteOptedOutNumberResult' => [ 'base' => NULL, 'refs' => [], ], 'DeletePoolRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePoolResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteProtectConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteProtectConfigurationResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRegistrationAttachmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRegistrationAttachmentResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRegistrationFieldValueRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRegistrationFieldValueResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRegistrationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRegistrationResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTextMessageSpendLimitOverrideRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTextMessageSpendLimitOverrideResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVerifiedDestinationNumberRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVerifiedDestinationNumberResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVoiceMessageSpendLimitOverrideRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVoiceMessageSpendLimitOverrideResult' => [ 'base' => NULL, 'refs' => [], ], 'DeliveryStreamArn' => [ 'base' => NULL, 'refs' => [ 'KinesisFirehoseDestination$DeliveryStreamArn' => '<p>The Amazon Resource Name (ARN) of the delivery stream.</p>', ], ], 'DescribeAccountAttributesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccountAttributesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccountLimitsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccountLimitsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeConfigurationSetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeConfigurationSetsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeKeywordsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeKeywordsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeOptOutListsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeOptOutListsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeOptedOutNumbersRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeOptedOutNumbersResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribePhoneNumbersRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePhoneNumbersResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribePoolsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePoolsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeProtectConfigurationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeProtectConfigurationsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRegistrationAttachmentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRegistrationAttachmentsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRegistrationFieldDefinitionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRegistrationFieldDefinitionsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRegistrationFieldValuesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRegistrationFieldValuesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRegistrationSectionDefinitionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRegistrationSectionDefinitionsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRegistrationTypeDefinitionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRegistrationTypeDefinitionsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRegistrationVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRegistrationVersionsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRegistrationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRegistrationsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSenderIdsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSenderIdsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSpendLimitsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSpendLimitsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVerifiedDestinationNumbersRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVerifiedDestinationNumbersResult' => [ 'base' => NULL, 'refs' => [], ], 'DestinationCountryParameterKey' => [ 'base' => NULL, 'refs' => [ 'DestinationCountryParameters$key' => NULL, ], ], 'DestinationCountryParameterValue' => [ 'base' => NULL, 'refs' => [ 'DestinationCountryParameters$value' => NULL, ], ], 'DestinationCountryParameters' => [ 'base' => NULL, 'refs' => [ 'SendDestinationNumberVerificationCodeRequest$DestinationCountryParameters' => '<p>This field is used for any country-specific registration requirements. Currently, this setting is only used when you send messages to recipients in India using a sender ID. For more information see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-senderid-india.html">Special requirements for sending SMS messages to recipients in India</a>. </p>', 'SendTextMessageRequest$DestinationCountryParameters' => '<p>This field is used for any country-specific registration requirements. Currently, this setting is only used when you send messages to recipients in India using a sender ID. For more information see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-senderid-india.html">Special requirements for sending SMS messages to recipients in India</a>. </p>', ], ], 'DestinationPhoneNumberList' => [ 'base' => NULL, 'refs' => [ 'DescribeVerifiedDestinationNumbersRequest$DestinationPhoneNumbers' => '<p>An array of verified destination phone number, in E.164 format.</p>', ], ], 'DisassociateOriginationIdentityRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateOriginationIdentityResult' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateProtectConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateProtectConfigurationResult' => [ 'base' => NULL, 'refs' => [], ], 'DiscardRegistrationVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DiscardRegistrationVersionResult' => [ 'base' => NULL, 'refs' => [], ], 'EventDestination' => [ 'base' => '<p>Contains information about an event destination.</p> <p>Event destinations are associated with configuration sets, which enable you to publish message sending events to CloudWatch, Kinesis Data Firehose, or Amazon SNS.</p>', 'refs' => [ 'CreateEventDestinationResult$EventDestination' => '<p>The details of the destination where events are logged.</p>', 'DeleteEventDestinationResult$EventDestination' => '<p>The event destination object that was deleted.</p>', 'EventDestinationList$member' => NULL, 'UpdateEventDestinationResult$EventDestination' => '<p>An EventDestination object containing the details of where events will be logged. </p>', ], ], 'EventDestinationList' => [ 'base' => NULL, 'refs' => [ 'ConfigurationSetInformation$EventDestinations' => '<p>An array of EventDestination objects that describe any events to log and where to log them.</p>', 'DeleteConfigurationSetResult$EventDestinations' => '<p>An array of any EventDestination objects that were associated with the deleted configuration set.</p>', ], ], 'EventDestinationName' => [ 'base' => NULL, 'refs' => [ 'CreateEventDestinationRequest$EventDestinationName' => '<p>The name that identifies the event destination.</p>', 'DeleteEventDestinationRequest$EventDestinationName' => '<p>The name of the event destination to delete.</p>', 'EventDestination$EventDestinationName' => '<p>The name of the EventDestination.</p>', 'UpdateEventDestinationRequest$EventDestinationName' => '<p>The name to use for the event destination.</p>', ], ], 'EventType' => [ 'base' => NULL, 'refs' => [ 'EventTypeList$member' => NULL, ], ], 'EventTypeList' => [ 'base' => NULL, 'refs' => [ 'CreateEventDestinationRequest$MatchingEventTypes' => '<p>An array of event types that determine which events to log. If "ALL" is used, then Amazon Pinpoint logs every event type.</p> <note> <p>The <code>TEXT_SENT</code> event type is not supported.</p> </note>', 'EventDestination$MatchingEventTypes' => '<p>An array of event types that determine which events to log.</p> <note> <p>The <code>TEXT_SENT</code> event type is not supported.</p> </note>', 'UpdateEventDestinationRequest$MatchingEventTypes' => '<p>An array of event types that determine which events to log.</p> <note> <p>The <code>TEXT_SENT</code> event type is not supported.</p> </note>', ], ], 'FieldPath' => [ 'base' => NULL, 'refs' => [ 'DeleteRegistrationFieldValueRequest$FieldPath' => '<p>The path to the registration form field. You can use <a>DescribeRegistrationFieldDefinitions</a> for a list of <b>FieldPaths</b>.</p>', 'DeleteRegistrationFieldValueResult$FieldPath' => '<p>The path to the registration form field.</p>', 'FieldPathList$member' => NULL, 'PutRegistrationFieldValueRequest$FieldPath' => '<p>The path to the registration form field. You can use <a>DescribeRegistrationFieldDefinitions</a> for a list of <b>FieldPaths</b>.</p>', 'PutRegistrationFieldValueResult$FieldPath' => '<p>The path to the registration form field. You can use <a>DescribeRegistrationFieldDefinitions</a> for a list of <b>FieldPaths</b>.</p>', 'RegistrationFieldDefinition$FieldPath' => '<p>The path to the registration form field. You can use <a>DescribeRegistrationFieldDefinitions</a> for a list of <b>FieldPaths</b>.</p>', 'RegistrationFieldValueInformation$FieldPath' => '<p>The path to the registration form field. You can use <a>DescribeRegistrationFieldDefinitions</a> for a list of <b>FieldPaths</b>.</p>', ], ], 'FieldPathList' => [ 'base' => NULL, 'refs' => [ 'DescribeRegistrationFieldDefinitionsRequest$FieldPaths' => '<p>An array of paths to the registration form field.</p>', 'DescribeRegistrationFieldValuesRequest$FieldPaths' => '<p>An array of paths to the registration form field.</p>', ], ], 'FieldRequirement' => [ 'base' => NULL, 'refs' => [ 'RegistrationFieldDefinition$FieldRequirement' => '<p>Specifies if the field for the registration form is required, conditional or optional.</p>', ], ], 'FieldType' => [ 'base' => NULL, 'refs' => [ 'RegistrationFieldDefinition$FieldType' => '<p>The type of field.</p>', ], ], 'FilterValue' => [ 'base' => NULL, 'refs' => [ 'FilterValueList$member' => NULL, ], ], 'FilterValueList' => [ 'base' => NULL, 'refs' => [ 'ConfigurationSetFilter$Values' => '<p>An array values to filter for.</p>', 'KeywordFilter$Values' => '<p>An array values to filter for.</p>', 'OptedOutFilter$Values' => '<p>An array of values to filter for.</p>', 'PhoneNumberFilter$Values' => '<p>An array values to filter for.</p>', 'PoolFilter$Values' => '<p>An array values to filter for.</p>', 'PoolOriginationIdentitiesFilter$Values' => '<p>An array values to filter for.</p>', 'ProtectConfigurationFilter$Values' => '<p>An array of values to filter for.</p>', 'RegistrationAssociationFilter$Values' => '<p>An array of values to filter for.</p>', 'RegistrationAttachmentFilter$Values' => '<p>An array of values to filter on.</p>', 'RegistrationFilter$Values' => '<p>An array of values to filter on.</p>', 'RegistrationTypeFilter$Values' => '<p>An array of values to filter on.</p>', 'RegistrationVersionFilter$Values' => '<p>An array of values to filter on.</p>', 'SenderIdFilter$Values' => '<p>An array of values to filter for.</p>', 'VerifiedDestinationNumberFilter$Values' => '<p>An array of values to filter on.</p>', ], ], 'GetProtectConfigurationCountryRuleSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetProtectConfigurationCountryRuleSetResult' => [ 'base' => NULL, 'refs' => [], ], 'IamRoleArn' => [ 'base' => NULL, 'refs' => [ 'CloudWatchLogsDestination$IamRoleArn' => '<p>The Amazon Resource Name (ARN) of an Identity and Access Management role that is able to write event data to an Amazon CloudWatch destination.</p>', 'CreatePoolResult$TwoWayChannelRole' => '<p>An optional IAM Role Arn for a service to assume, to be able to post inbound SMS messages.</p>', 'DeletePoolResult$TwoWayChannelRole' => '<p>An optional IAM Role Arn for a service to assume, to be able to post inbound SMS messages.</p>', 'KinesisFirehoseDestination$IamRoleArn' => '<p>The ARN of an Identity and Access Management role that is able to write event data to an Amazon Kinesis Data Firehose destination.</p>', 'PhoneNumberInformation$TwoWayChannelRole' => '<p>An optional IAM Role Arn for a service to assume, to be able to post inbound SMS messages.</p>', 'PoolInformation$TwoWayChannelRole' => '<p>An optional IAM Role Arn for a service to assume, to be able to post inbound SMS messages.</p>', 'ReleasePhoneNumberResult$TwoWayChannelRole' => '<p>An optional IAM Role Arn for a service to assume, to be able to post inbound SMS messages.</p>', 'RequestPhoneNumberResult$TwoWayChannelRole' => '<p>An optional IAM Role Arn for a service to assume, to be able to post inbound SMS messages.</p>', 'UpdatePhoneNumberRequest$TwoWayChannelRole' => '<p>An optional IAM Role Arn for a service to assume, to be able to post inbound SMS messages.</p>', 'UpdatePhoneNumberResult$TwoWayChannelRole' => '<p>An optional IAM Role Arn for a service to assume, to be able to post inbound SMS messages.</p>', 'UpdatePoolRequest$TwoWayChannelRole' => '<p>An optional IAM Role Arn for a service to assume, to be able to post inbound SMS messages.</p>', 'UpdatePoolResult$TwoWayChannelRole' => '<p>An optional IAM Role Arn for a service to assume, to be able to post inbound SMS messages.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'SelectValidation$MinChoices' => '<p>The minimum number of choices for the select.</p>', 'SelectValidation$MaxChoices' => '<p>The maximum number of choices for the select.</p>', 'TextValidation$MinLength' => '<p>The minimum number of characters for the text field.</p>', 'TextValidation$MaxLength' => '<p>The maximum number of characters for the text field.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>The API encountered an unexpected error and couldn\'t complete the request. You might be able to successfully issue the request again in the future.</p>', 'refs' => [], ], 'IsoCountryCode' => [ 'base' => NULL, 'refs' => [ 'AssociateOriginationIdentityRequest$IsoCountryCode' => '<p>The new two-character code, in ISO 3166-1 alpha-2 format, for the country or region of the origination identity.</p>', 'AssociateOriginationIdentityResult$IsoCountryCode' => '<p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>', 'CreatePoolRequest$IsoCountryCode' => '<p>The new two-character code, in ISO 3166-1 alpha-2 format, for the country or region of the new pool.</p>', 'CreateRegistrationAssociationResult$IsoCountryCode' => '<p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.</p>', 'DisassociateOriginationIdentityRequest$IsoCountryCode' => '<p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>', 'DisassociateOriginationIdentityResult$IsoCountryCode' => '<p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.</p>', 'OriginationIdentityMetadata$IsoCountryCode' => '<p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>', 'PhoneNumberInformation$IsoCountryCode' => '<p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>', 'ProtectConfigurationCountryRuleSet$key' => NULL, 'RegistrationAssociationMetadata$IsoCountryCode' => '<p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.</p>', 'ReleasePhoneNumberResult$IsoCountryCode' => '<p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.</p>', 'ReleaseSenderIdRequest$IsoCountryCode' => '<p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.</p>', 'ReleaseSenderIdResult$IsoCountryCode' => '<p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.</p>', 'RequestPhoneNumberRequest$IsoCountryCode' => '<p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>', 'RequestPhoneNumberResult$IsoCountryCode' => '<p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>', 'RequestSenderIdRequest$IsoCountryCode' => '<p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.</p>', 'RequestSenderIdResult$IsoCountryCode' => '<p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.</p>', 'SenderIdAndCountry$IsoCountryCode' => '<p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>', 'SenderIdInformation$IsoCountryCode' => '<p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>', 'SupportedAssociation$IsoCountryCode' => '<p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.</p>', 'UpdatePhoneNumberResult$IsoCountryCode' => '<p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>', 'UpdateSenderIdRequest$IsoCountryCode' => '<p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.</p>', 'UpdateSenderIdResult$IsoCountryCode' => '<p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.</p>', ], ], 'Keyword' => [ 'base' => NULL, 'refs' => [ 'DeleteKeywordRequest$Keyword' => '<p>The keyword to delete.</p>', 'DeleteKeywordResult$Keyword' => '<p>The keyword that was deleted.</p>', 'KeywordInformation$Keyword' => '<p>The keyword as a string.</p>', 'KeywordList$member' => NULL, 'PutKeywordRequest$Keyword' => '<p>The new keyword to add.</p>', 'PutKeywordResult$Keyword' => '<p>The keyword that was added.</p>', 'SendTextMessageRequest$Keyword' => '<p>When you register a short code in the US, you must specify a program name. If you don’t have a US short code, omit this attribute.</p>', ], ], 'KeywordAction' => [ 'base' => NULL, 'refs' => [ 'DeleteKeywordResult$KeywordAction' => '<p>The action that was associated with the deleted keyword.</p>', 'KeywordInformation$KeywordAction' => '<p>The action to perform for the keyword.</p>', 'PutKeywordRequest$KeywordAction' => '<p>The action to perform for the new keyword when it is received.</p> <ul> <li> <p>AUTOMATIC_RESPONSE: A message is sent to the recipient.</p> </li> <li> <p>OPT_OUT: Keeps the recipient from receiving future messages.</p> </li> <li> <p>OPT_IN: The recipient wants to receive future messages.</p> </li> </ul>', 'PutKeywordResult$KeywordAction' => '<p>The action to perform when the keyword is used.</p>', ], ], 'KeywordFilter' => [ 'base' => '<p>The information for keywords that meet a specified criteria.</p>', 'refs' => [ 'KeywordFilterList$member' => NULL, ], ], 'KeywordFilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeKeywordsRequest$Filters' => '<p>An array of keyword filters to filter the results.</p>', ], ], 'KeywordFilterName' => [ 'base' => NULL, 'refs' => [ 'KeywordFilter$Name' => '<p>The name of the attribute to filter on.</p>', ], ], 'KeywordInformation' => [ 'base' => '<p>The information for all keywords in a pool.</p>', 'refs' => [ 'KeywordInformationList$member' => NULL, ], ], 'KeywordInformationList' => [ 'base' => NULL, 'refs' => [ 'DescribeKeywordsResult$Keywords' => '<p>An array of KeywordInformation objects that contain the results.</p>', ], ], 'KeywordList' => [ 'base' => NULL, 'refs' => [ 'DescribeKeywordsRequest$Keywords' => '<p>An array of keywords to search for.</p>', ], ], 'KeywordMessage' => [ 'base' => NULL, 'refs' => [ 'DeleteKeywordResult$KeywordMessage' => '<p>The message that was associated with the deleted keyword.</p>', 'KeywordInformation$KeywordMessage' => '<p>A custom message that can be used with the keyword.</p>', 'PutKeywordRequest$KeywordMessage' => '<p>The message associated with the keyword.</p>', 'PutKeywordResult$KeywordMessage' => '<p>The message associated with the keyword.</p>', ], ], 'KinesisFirehoseDestination' => [ 'base' => '<p>Contains the delivery stream Amazon Resource Name (ARN), and the ARN of the Identity and Access Management (IAM) role associated with a Kinesis Data Firehose event destination.</p> <p>Event destinations, such as Kinesis Data Firehose, are associated with configuration sets, which enable you to publish message sending events.</p>', 'refs' => [ 'CreateEventDestinationRequest$KinesisFirehoseDestination' => '<p>An object that contains information about an event destination for logging to Amazon Kinesis Data Firehose.</p>', 'EventDestination$KinesisFirehoseDestination' => '<p>An object that contains information about an event destination for logging to Amazon Kinesis Data Firehose.</p>', 'UpdateEventDestinationRequest$KinesisFirehoseDestination' => '<p>An object that contains information about an event destination for logging to Kinesis Data Firehose.</p>', ], ], 'LanguageCode' => [ 'base' => NULL, 'refs' => [ 'SendDestinationNumberVerificationCodeRequest$LanguageCode' => '<p>Choose the language to use for the message.</p>', ], ], 'ListPoolOriginationIdentitiesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPoolOriginationIdentitiesResult' => [ 'base' => NULL, 'refs' => [], ], 'ListRegistrationAssociationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRegistrationAssociationsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResult' => [ 'base' => NULL, 'refs' => [], ], 'LogGroupArn' => [ 'base' => NULL, 'refs' => [ 'CloudWatchLogsDestination$LogGroupArn' => '<p>The name of the Amazon CloudWatch log group that you want to record events in. </p>', ], ], 'MaxPrice' => [ 'base' => NULL, 'refs' => [ 'SendMediaMessageRequest$MaxPrice' => '<p>The maximum amount that you want to spend, in US dollars, per each MMS message.</p>', 'SendTextMessageRequest$MaxPrice' => '<p>The maximum amount that you want to spend, in US dollars, per each text message part. A text message can contain multiple parts.</p>', 'SendVoiceMessageRequest$MaxPricePerMinute' => '<p>The maximum amount to spend per voice message, in US dollars.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeAccountAttributesRequest$MaxResults' => '<p>The maximum number of results to return per each request.</p>', 'DescribeAccountLimitsRequest$MaxResults' => '<p>The maximum number of results to return per each request.</p>', 'DescribeConfigurationSetsRequest$MaxResults' => '<p>The maximum number of results to return per each request.</p>', 'DescribeKeywordsRequest$MaxResults' => '<p>The maximum number of results to return per each request.</p>', 'DescribeOptOutListsRequest$MaxResults' => '<p>The maximum number of results to return per each request.</p>', 'DescribeOptedOutNumbersRequest$MaxResults' => '<p>The maximum number of results to return per each request.</p>', 'DescribePhoneNumbersRequest$MaxResults' => '<p>The maximum number of results to return per each request.</p>', 'DescribePoolsRequest$MaxResults' => '<p>The maximum number of results to return per each request.</p>', 'DescribeProtectConfigurationsRequest$MaxResults' => '<p>The maximum number of results to return per each request.</p>', 'DescribeRegistrationAttachmentsRequest$MaxResults' => '<p>The maximum number of results to return per each request.</p>', 'DescribeRegistrationFieldDefinitionsRequest$MaxResults' => '<p>The maximum number of results to return per each request.</p>', 'DescribeRegistrationFieldValuesRequest$MaxResults' => '<p>The maximum number of results to return per each request.</p>', 'DescribeRegistrationSectionDefinitionsRequest$MaxResults' => '<p>The maximum number of results to return per each request.</p>', 'DescribeRegistrationTypeDefinitionsRequest$MaxResults' => '<p>The maximum number of results to return per each request.</p>', 'DescribeRegistrationVersionsRequest$MaxResults' => '<p>The maximum number of results to return per each request.</p>', 'DescribeRegistrationsRequest$MaxResults' => '<p>The maximum number of results to return per each request.</p>', 'DescribeSenderIdsRequest$MaxResults' => '<p>The maximum number of results to return per each request.</p>', 'DescribeSpendLimitsRequest$MaxResults' => '<p>The maximum number of results to return per each request.</p>', 'DescribeVerifiedDestinationNumbersRequest$MaxResults' => '<p>The maximum number of results to return per each request.</p>', 'ListPoolOriginationIdentitiesRequest$MaxResults' => '<p>The maximum number of results to return per each request.</p>', 'ListRegistrationAssociationsRequest$MaxResults' => '<p>The maximum number of results to return per each request.</p>', ], ], 'MediaMessageOriginationIdentity' => [ 'base' => NULL, 'refs' => [ 'SendMediaMessageRequest$OriginationIdentity' => '<p>The origination identity of the message. This can be either the PhoneNumber, PhoneNumberId, PhoneNumberArn, SenderId, SenderIdArn, PoolId, or PoolArn.</p>', ], ], 'MediaUrlList' => [ 'base' => NULL, 'refs' => [ 'SendMediaMessageRequest$MediaUrls' => '<p>An array of URLs to each media file to send. </p> <p>The media files have to be stored in a publicly available S3 bucket. Supported media file formats are listed in <a href="https://docs.aws.amazon.com/sms-voice/latest/userguide/mms-limitations-character.html">MMS file types, size and character limits</a>. For more information on creating an S3 bucket and managing objects, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/create-bucket-overview.html">Creating a bucket</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/upload-objects.html">Uploading objects</a> in the S3 user guide.</p>', ], ], 'MediaUrlValue' => [ 'base' => NULL, 'refs' => [ 'MediaUrlList$member' => NULL, ], ], 'MessageType' => [ 'base' => NULL, 'refs' => [ 'ConfigurationSetInformation$DefaultMessageType' => '<p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren\'t critical or time-sensitive.</p>', 'CreatePoolRequest$MessageType' => '<p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren\'t critical or time-sensitive.</p>', 'CreatePoolResult$MessageType' => '<p>The type of message for the pool to use.</p>', 'DeleteConfigurationSetResult$DefaultMessageType' => '<p>The default message type of the configuration set that was deleted.</p>', 'DeleteDefaultMessageTypeResult$MessageType' => '<p>The current message type for the configuration set.</p>', 'DeletePoolResult$MessageType' => '<p>The message type that was associated with the deleted pool.</p>', 'MessageTypeList$member' => NULL, 'PhoneNumberInformation$MessageType' => '<p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren\'t critical or time-sensitive.</p>', 'PoolInformation$MessageType' => '<p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren\'t critical or time-sensitive.</p>', 'ReleasePhoneNumberResult$MessageType' => '<p>The message type that was associated with the phone number.</p>', 'RequestPhoneNumberRequest$MessageType' => '<p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren\'t critical or time-sensitive.</p>', 'RequestPhoneNumberResult$MessageType' => '<p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren\'t critical or time-sensitive.</p>', 'SendTextMessageRequest$MessageType' => '<p>The type of message. Valid values are for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren\'t critical or time-sensitive.</p>', 'SetDefaultMessageTypeRequest$MessageType' => '<p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren\'t critical or time-sensitive.</p>', 'SetDefaultMessageTypeResult$MessageType' => '<p>The new default message type of the configuration set.</p>', 'UpdatePhoneNumberResult$MessageType' => '<p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren\'t critical or time-sensitive.</p>', 'UpdatePoolResult$MessageType' => '<p>The type of message for the pool to use.</p>', ], ], 'MessageTypeList' => [ 'base' => NULL, 'refs' => [ 'ReleaseSenderIdResult$MessageTypes' => '<p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren\'t critical or time-sensitive.</p>', 'RequestSenderIdRequest$MessageTypes' => '<p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren\'t critical or time-sensitive.</p>', 'RequestSenderIdResult$MessageTypes' => '<p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren\'t critical or time-sensitive.</p>', 'SenderIdInformation$MessageTypes' => '<p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren\'t critical or time-sensitive.</p>', 'UpdateSenderIdResult$MessageTypes' => '<p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren\'t critical or time-sensitive.</p>', ], ], 'MonthlyLimit' => [ 'base' => NULL, 'refs' => [ 'DeleteMediaMessageSpendLimitOverrideResult$MonthlyLimit' => '<p>The current monthly limit, in US dollars.</p>', 'DeleteTextMessageSpendLimitOverrideResult$MonthlyLimit' => '<p>The current monthly limit, in US dollars.</p>', 'DeleteVoiceMessageSpendLimitOverrideResult$MonthlyLimit' => '<p>The current monthly limit, in US dollars.</p>', 'SetMediaMessageSpendLimitOverrideRequest$MonthlyLimit' => '<p>The new monthly limit to enforce on text messages.</p>', 'SetMediaMessageSpendLimitOverrideResult$MonthlyLimit' => '<p>The current monthly limit to enforce on sending text messages.</p>', 'SetTextMessageSpendLimitOverrideRequest$MonthlyLimit' => '<p>The new monthly limit to enforce on text messages.</p>', 'SetTextMessageSpendLimitOverrideResult$MonthlyLimit' => '<p>The current monthly limit to enforce on sending text messages.</p>', 'SetVoiceMessageSpendLimitOverrideRequest$MonthlyLimit' => '<p>The new monthly limit to enforce on voice messages.</p>', 'SetVoiceMessageSpendLimitOverrideResult$MonthlyLimit' => '<p>The current monthly limit to enforce on sending voice messages.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'DescribeAccountAttributesRequest$NextToken' => '<p>The token to be used for the next set of paginated results. You don\'t need to supply a value for this field in the initial request.</p>', 'DescribeAccountAttributesResult$NextToken' => '<p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>', 'DescribeAccountLimitsRequest$NextToken' => '<p>The token to be used for the next set of paginated results. You don\'t need to supply a value for this field in the initial request.</p>', 'DescribeAccountLimitsResult$NextToken' => '<p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>', 'DescribeConfigurationSetsRequest$NextToken' => '<p>The token to be used for the next set of paginated results. You don\'t need to supply a value for this field in the initial request.</p>', 'DescribeConfigurationSetsResult$NextToken' => '<p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>', 'DescribeKeywordsRequest$NextToken' => '<p>The token to be used for the next set of paginated results. You don\'t need to supply a value for this field in the initial request.</p>', 'DescribeKeywordsResult$NextToken' => '<p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>', 'DescribeOptOutListsRequest$NextToken' => '<p>The token to be used for the next set of paginated results. You don\'t need to supply a value for this field in the initial request.</p>', 'DescribeOptOutListsResult$NextToken' => '<p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>', 'DescribeOptedOutNumbersRequest$NextToken' => '<p>The token to be used for the next set of paginated results. You don\'t need to supply a value for this field in the initial request.</p>', 'DescribeOptedOutNumbersResult$NextToken' => '<p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>', 'DescribePhoneNumbersRequest$NextToken' => '<p>The token to be used for the next set of paginated results. You don\'t need to supply a value for this field in the initial request.</p>', 'DescribePhoneNumbersResult$NextToken' => '<p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>', 'DescribePoolsRequest$NextToken' => '<p>The token to be used for the next set of paginated results. You don\'t need to supply a value for this field in the initial request.</p>', 'DescribePoolsResult$NextToken' => '<p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>', 'DescribeProtectConfigurationsRequest$NextToken' => '<p>The token to be used for the next set of paginated results. You don\'t need to supply a value for this field in the initial request.</p>', 'DescribeProtectConfigurationsResult$NextToken' => '<p>The token to be used for the next set of paginated results. You don\'t need to supply a value for this field in the initial request.</p>', 'DescribeRegistrationAttachmentsRequest$NextToken' => '<p>The token to be used for the next set of paginated results. You don\'t need to supply a value for this field in the initial request.</p>', 'DescribeRegistrationAttachmentsResult$NextToken' => '<p>The token to be used for the next set of paginated results. You don\'t need to supply a value for this field in the initial request.</p>', 'DescribeRegistrationFieldDefinitionsRequest$NextToken' => '<p>The token to be used for the next set of paginated results. You don\'t need to supply a value for this field in the initial request.</p>', 'DescribeRegistrationFieldDefinitionsResult$NextToken' => '<p>The token to be used for the next set of paginated results. You don\'t need to supply a value for this field in the initial request.</p>', 'DescribeRegistrationFieldValuesRequest$NextToken' => '<p>The token to be used for the next set of paginated results. You don\'t need to supply a value for this field in the initial request.</p>', 'DescribeRegistrationFieldValuesResult$NextToken' => '<p>The token to be used for the next set of paginated results. You don\'t need to supply a value for this field in the initial request.</p>', 'DescribeRegistrationSectionDefinitionsRequest$NextToken' => '<p>The token to be used for the next set of paginated results. You don\'t need to supply a value for this field in the initial request.</p>', 'DescribeRegistrationSectionDefinitionsResult$NextToken' => '<p>The token to be used for the next set of paginated results. You don\'t need to supply a value for this field in the initial request.</p>', 'DescribeRegistrationTypeDefinitionsRequest$NextToken' => '<p>The token to be used for the next set of paginated results. You don\'t need to supply a value for this field in the initial request.</p>', 'DescribeRegistrationTypeDefinitionsResult$NextToken' => '<p>The token to be used for the next set of paginated results. You don\'t need to supply a value for this field in the initial request.</p>', 'DescribeRegistrationVersionsRequest$NextToken' => '<p>The token to be used for the next set of paginated results. You don\'t need to supply a value for this field in the initial request.</p>', 'DescribeRegistrationVersionsResult$NextToken' => '<p>The token to be used for the next set of paginated results. You don\'t need to supply a value for this field in the initial request.</p>', 'DescribeRegistrationsRequest$NextToken' => '<p>The token to be used for the next set of paginated results. You don\'t need to supply a value for this field in the initial request.</p>', 'DescribeRegistrationsResult$NextToken' => '<p>The token to be used for the next set of paginated results. You don\'t need to supply a value for this field in the initial request.</p>', 'DescribeSenderIdsRequest$NextToken' => '<p>The token to be used for the next set of paginated results. You don\'t need to supply a value for this field in the initial request.</p>', 'DescribeSenderIdsResult$NextToken' => '<p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>', 'DescribeSpendLimitsRequest$NextToken' => '<p>The token to be used for the next set of paginated results. You don\'t need to supply a value for this field in the initial request.</p>', 'DescribeSpendLimitsResult$NextToken' => '<p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>', 'DescribeVerifiedDestinationNumbersRequest$NextToken' => '<p>The token to be used for the next set of paginated results. You don\'t need to supply a value for this field in the initial request.</p>', 'DescribeVerifiedDestinationNumbersResult$NextToken' => '<p>The token to be used for the next set of paginated results. You don\'t need to supply a value for this field in the initial request.</p>', 'ListPoolOriginationIdentitiesRequest$NextToken' => '<p>The token to be used for the next set of paginated results. You don\'t need to supply a value for this field in the initial request.</p>', 'ListPoolOriginationIdentitiesResult$NextToken' => '<p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>', 'ListRegistrationAssociationsRequest$NextToken' => '<p>The token to be used for the next set of paginated results. You don\'t need to supply a value for this field in the initial request.</p>', 'ListRegistrationAssociationsResult$NextToken' => '<p>The token to be used for the next set of paginated results. You don\'t need to supply a value for this field in the initial request.</p>', ], ], 'NonEmptyTagList' => [ 'base' => NULL, 'refs' => [ 'TagResourceRequest$Tags' => '<p>An array of key and value pair tags that are associated with the resource.</p>', ], ], 'NumberCapability' => [ 'base' => NULL, 'refs' => [ 'GetProtectConfigurationCountryRuleSetRequest$NumberCapability' => '<p>The capability type to return the CountryRuleSet for. Valid values are <code>SMS</code>, <code>VOICE</code>, or <code>MMS</code>.</p>', 'GetProtectConfigurationCountryRuleSetResult$NumberCapability' => '<p>The capability type associated with the returned ProtectConfigurationCountryRuleSetInformation objects.</p>', 'NumberCapabilityList$member' => NULL, 'UpdateProtectConfigurationCountryRuleSetRequest$NumberCapability' => '<p>The number capability to apply the CountryRuleSetUpdates updates to.</p>', 'UpdateProtectConfigurationCountryRuleSetResult$NumberCapability' => '<p>The number capability that was updated</p>', ], ], 'NumberCapabilityList' => [ 'base' => NULL, 'refs' => [ 'OriginationIdentityMetadata$NumberCapabilities' => '<p>Describes if the origination identity can be used for text messages, voice calls or both.</p>', 'PhoneNumberInformation$NumberCapabilities' => '<p>Describes if the origination identity can be used for text messages, voice calls or both.</p>', 'ReleasePhoneNumberResult$NumberCapabilities' => '<p>Specifies if the number could be used for text messages, voice, or both.</p>', 'RequestPhoneNumberRequest$NumberCapabilities' => '<p>Indicates if the phone number will be used for text messages, voice messages, or both. </p>', 'RequestPhoneNumberResult$NumberCapabilities' => '<p>Indicates if the phone number will be used for text messages, voice messages or both. </p>', 'UpdatePhoneNumberResult$NumberCapabilities' => '<p>Specifies if the number could be used for text messages, voice or both.</p>', ], ], 'NumberStatus' => [ 'base' => NULL, 'refs' => [ 'PhoneNumberInformation$Status' => '<p>The current status of the phone number.</p>', 'ReleasePhoneNumberResult$Status' => '<p>The current status of the request.</p>', 'RequestPhoneNumberResult$Status' => '<p>The current status of the request.</p>', 'UpdatePhoneNumberResult$Status' => '<p>The current status of the request.</p>', ], ], 'NumberType' => [ 'base' => NULL, 'refs' => [ 'PhoneNumberInformation$NumberType' => '<p>The type of phone number.</p>', 'ReleasePhoneNumberResult$NumberType' => '<p>The type of number that was released.</p>', 'UpdatePhoneNumberResult$NumberType' => '<p>The type of number that was requested.</p>', ], ], 'OptOutListInformation' => [ 'base' => '<p>The information for all OptOutList in an Amazon Web Services account.</p>', 'refs' => [ 'OptOutListInformationList$member' => NULL, ], ], 'OptOutListInformationList' => [ 'base' => NULL, 'refs' => [ 'DescribeOptOutListsResult$OptOutLists' => '<p>An array of OptOutListInformation objects that contain the details for the requested OptOutLists.</p>', ], ], 'OptOutListName' => [ 'base' => NULL, 'refs' => [ 'CreateOptOutListRequest$OptOutListName' => '<p>The name of the new OptOutList.</p>', 'CreateOptOutListResult$OptOutListName' => '<p>The name of the new OptOutList.</p>', 'CreatePoolResult$OptOutListName' => '<p>The name of the OptOutList associated with the pool.</p>', 'DeleteOptOutListResult$OptOutListName' => '<p>The name of the OptOutList that was removed.</p>', 'DeleteOptedOutNumberResult$OptOutListName' => '<p>The OptOutListName that the phone number was removed from.</p>', 'DeletePoolResult$OptOutListName' => '<p>The name of the OptOutList that was associated with the deleted pool.</p>', 'DescribeOptedOutNumbersResult$OptOutListName' => '<p>The name of the OptOutList.</p>', 'OptOutListInformation$OptOutListName' => '<p>The name of the OptOutList.</p>', 'PhoneNumberInformation$OptOutListName' => '<p>The name of the OptOutList associated with the phone number.</p>', 'PoolInformation$OptOutListName' => '<p>The name of the OptOutList associated with the pool.</p>', 'PutOptedOutNumberResult$OptOutListName' => '<p>The OptOutListName that the phone number was removed from.</p>', 'ReleasePhoneNumberResult$OptOutListName' => '<p>The name of the OptOutList that was associated with the phone number.</p>', 'RequestPhoneNumberResult$OptOutListName' => '<p>The name of the OptOutList that is associated with the requested phone number.</p>', 'UpdatePhoneNumberResult$OptOutListName' => '<p>The name of the OptOutList associated with the phone number.</p>', 'UpdatePoolResult$OptOutListName' => '<p>The name of the OptOutList associated with the pool.</p>', ], ], 'OptOutListNameList' => [ 'base' => NULL, 'refs' => [ 'DescribeOptOutListsRequest$OptOutListNames' => '<p>The OptOutLists to show the details of. This is an array of strings that can be either the OptOutListName or OptOutListArn.</p>', ], ], 'OptOutListNameOrArn' => [ 'base' => NULL, 'refs' => [ 'DeleteOptOutListRequest$OptOutListName' => '<p>The OptOutListName or OptOutListArn of the OptOutList to delete. You can use <a>DescribeOptOutLists</a> to find the values for OptOutListName and OptOutListArn.</p>', 'DeleteOptedOutNumberRequest$OptOutListName' => '<p>The OptOutListName or OptOutListArn to remove the phone number from.</p>', 'DescribeOptedOutNumbersRequest$OptOutListName' => '<p>The OptOutListName or OptOutListArn of the OptOutList. You can use <a>DescribeOptOutLists</a> to find the values for OptOutListName and OptOutListArn.</p>', 'OptOutListNameList$member' => NULL, 'PutOptedOutNumberRequest$OptOutListName' => '<p>The OptOutListName or OptOutListArn to add the phone number to.</p>', 'RequestPhoneNumberRequest$OptOutListName' => '<p>The name of the OptOutList to associate with the phone number. You can use the OptOutListName or OptOutListArn.</p>', 'UpdatePhoneNumberRequest$OptOutListName' => '<p>The OptOutList to add the phone number to. Valid values for this field can be either the OutOutListName or OutOutListArn.</p>', 'UpdatePoolRequest$OptOutListName' => '<p>The OptOutList to associate with the pool. Valid values are either OptOutListName or OptOutListArn.</p>', ], ], 'OptedOutFilter' => [ 'base' => '<p>The information for opted out numbers that meet a specified criteria.</p>', 'refs' => [ 'OptedOutFilterList$member' => NULL, ], ], 'OptedOutFilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeOptedOutNumbersRequest$Filters' => '<p>An array of OptedOutFilter objects to filter the results on.</p>', ], ], 'OptedOutFilterName' => [ 'base' => NULL, 'refs' => [ 'OptedOutFilter$Name' => '<p>The name of the attribute to filter on.</p>', ], ], 'OptedOutNumberInformation' => [ 'base' => '<p>The information for an opted out number in an Amazon Web Services account.</p>', 'refs' => [ 'OptedOutNumberInformationList$member' => NULL, ], ], 'OptedOutNumberInformationList' => [ 'base' => NULL, 'refs' => [ 'DescribeOptedOutNumbersResult$OptedOutNumbers' => '<p>An array of OptedOutNumbersInformation objects that provide information about the requested OptedOutNumbers.</p>', ], ], 'OptedOutNumberList' => [ 'base' => NULL, 'refs' => [ 'DescribeOptedOutNumbersRequest$OptedOutNumbers' => '<p>An array of phone numbers to search for in the OptOutList.</p>', ], ], 'OriginationIdentityMetadata' => [ 'base' => '<p>The metadata for an origination identity associated with a pool.</p>', 'refs' => [ 'OriginationIdentityMetadataList$member' => NULL, ], ], 'OriginationIdentityMetadataList' => [ 'base' => NULL, 'refs' => [ 'ListPoolOriginationIdentitiesResult$OriginationIdentities' => '<p>An array of any OriginationIdentityMetadata objects.</p>', ], ], 'PhoneNumber' => [ 'base' => NULL, 'refs' => [ 'CreateRegistrationAssociationResult$PhoneNumber' => '<p>The phone number associated with the registration in E.164 format.</p>', 'CreateVerifiedDestinationNumberRequest$DestinationPhoneNumber' => '<p>The verified destination phone number, in E.164 format.</p>', 'CreateVerifiedDestinationNumberResult$DestinationPhoneNumber' => '<p>The verified destination phone number, in E.164 format.</p>', 'DeleteOptedOutNumberRequest$OptedOutNumber' => '<p>The phone number, in E.164 format, to remove from the OptOutList.</p>', 'DeleteOptedOutNumberResult$OptedOutNumber' => '<p>The phone number that was removed from the OptOutList.</p>', 'DeleteVerifiedDestinationNumberResult$DestinationPhoneNumber' => '<p>The verified destination phone number, in E.164 format.</p>', 'DestinationPhoneNumberList$member' => NULL, 'OptedOutNumberInformation$OptedOutNumber' => '<p>The phone number that is opted out.</p>', 'OptedOutNumberList$member' => NULL, 'OriginationIdentityMetadata$PhoneNumber' => '<p>The phone number in E.164 format.</p>', 'PhoneNumberInformation$PhoneNumber' => '<p>The phone number in E.164 format.</p>', 'PutOptedOutNumberRequest$OptedOutNumber' => '<p>The phone number to add to the OptOutList in E.164 format.</p>', 'PutOptedOutNumberResult$OptedOutNumber' => '<p>The phone number that was added to the OptOutList.</p>', 'RegistrationAssociationMetadata$PhoneNumber' => '<p>The phone number associated with the registration in E.164 format.</p>', 'ReleasePhoneNumberResult$PhoneNumber' => '<p>The phone number that was released.</p>', 'RequestPhoneNumberResult$PhoneNumber' => '<p>The new phone number that was requested.</p>', 'SendMediaMessageRequest$DestinationPhoneNumber' => '<p>The destination phone number in E.164 format.</p>', 'SendTextMessageRequest$DestinationPhoneNumber' => '<p>The destination phone number in E.164 format.</p>', 'SendVoiceMessageRequest$DestinationPhoneNumber' => '<p>The destination phone number in E.164 format.</p>', 'UpdatePhoneNumberResult$PhoneNumber' => '<p>The phone number that was updated.</p>', 'VerifiedDestinationNumberInformation$DestinationPhoneNumber' => '<p>The verified destination phone number, in E.164 format.</p>', 'VerifyDestinationNumberResult$DestinationPhoneNumber' => '<p>The phone number in E.164 format.</p>', ], ], 'PhoneNumberFilter' => [ 'base' => '<p>The information for a phone number that meets a specified criteria.</p>', 'refs' => [ 'PhoneNumberFilterList$member' => NULL, ], ], 'PhoneNumberFilterList' => [ 'base' => NULL, 'refs' => [ 'DescribePhoneNumbersRequest$Filters' => '<p>An array of PhoneNumberFilter objects to filter the results.</p>', ], ], 'PhoneNumberFilterName' => [ 'base' => NULL, 'refs' => [ 'PhoneNumberFilter$Name' => '<p>The name of the attribute to filter on.</p>', ], ], 'PhoneNumberIdList' => [ 'base' => NULL, 'refs' => [ 'DescribePhoneNumbersRequest$PhoneNumberIds' => '<p>The unique identifier of phone numbers to find information about. This is an array of strings that can be either the PhoneNumberId or PhoneNumberArn.</p>', ], ], 'PhoneNumberIdOrArn' => [ 'base' => NULL, 'refs' => [ 'PhoneNumberIdList$member' => NULL, 'ReleasePhoneNumberRequest$PhoneNumberId' => '<p>The PhoneNumberId or PhoneNumberArn of the phone number to release. You can use <a>DescribePhoneNumbers</a> to get the values for PhoneNumberId and PhoneNumberArn.</p>', 'UpdatePhoneNumberRequest$PhoneNumberId' => '<p>The unique identifier of the phone number. Valid values for this field can be either the PhoneNumberId or PhoneNumberArn.</p>', ], ], 'PhoneNumberInformation' => [ 'base' => '<p>The information for a phone number, in E.164 format, in an Amazon Web Services account.</p>', 'refs' => [ 'PhoneNumberInformationList$member' => NULL, ], ], 'PhoneNumberInformationList' => [ 'base' => NULL, 'refs' => [ 'DescribePhoneNumbersResult$PhoneNumbers' => '<p>An array of PhoneNumberInformation objects that contain the details for the requested phone numbers.</p>', ], ], 'PhoneOrPoolIdOrArn' => [ 'base' => NULL, 'refs' => [ 'DeleteKeywordRequest$OriginationIdentity' => '<p>The origination identity to use such as a PhoneNumberId, PhoneNumberArn, PoolId or PoolArn. You can use <a>DescribePhoneNumbers</a> to find the values for PhoneNumberId and PhoneNumberArn and <a>DescribePools</a> to find the values of PoolId and PoolArn.</p>', 'DescribeKeywordsRequest$OriginationIdentity' => '<p>The origination identity to use such as a PhoneNumberId, PhoneNumberArn, SenderId or SenderIdArn. You can use <a>DescribePhoneNumbers</a> to find the values for PhoneNumberId and PhoneNumberArn while <a>DescribeSenderIds</a> can be used to get the values for SenderId and SenderIdArn.</p>', 'PutKeywordRequest$OriginationIdentity' => '<p>The origination identity to use such as a PhoneNumberId, PhoneNumberArn, SenderId or SenderIdArn. You can use <a>DescribePhoneNumbers</a> get the values for PhoneNumberId and PhoneNumberArn while <a>DescribeSenderIds</a> can be used to get the values for SenderId and SenderIdArn.</p>', ], ], 'PhoneOrSenderIdOrArn' => [ 'base' => NULL, 'refs' => [ 'AssociateOriginationIdentityRequest$OriginationIdentity' => '<p>The origination identity to use, such as PhoneNumberId, PhoneNumberArn, SenderId, or SenderIdArn. You can use <a>DescribePhoneNumbers</a> to find the values for PhoneNumberId and PhoneNumberArn, while <a>DescribeSenderIds</a> can be used to get the values for SenderId and SenderIdArn.</p>', 'CreatePoolRequest$OriginationIdentity' => '<p>The origination identity to use such as a PhoneNumberId, PhoneNumberArn, SenderId or SenderIdArn. You can use <a>DescribePhoneNumbers</a> to find the values for PhoneNumberId and PhoneNumberArn while <a>DescribeSenderIds</a> can be used to get the values for SenderId and SenderIdArn.</p>', 'DisassociateOriginationIdentityRequest$OriginationIdentity' => '<p>The origination identity to use such as a PhoneNumberId, PhoneNumberArn, SenderId or SenderIdArn. You can use <a>DescribePhoneNumbers</a> find the values for PhoneNumberId and PhoneNumberArn, or use <a>DescribeSenderIds</a> to get the values for SenderId and SenderIdArn.</p>', ], ], 'PoolFilter' => [ 'base' => '<p>The information for a pool that meets a specified criteria.</p>', 'refs' => [ 'PoolFilterList$member' => NULL, ], ], 'PoolFilterList' => [ 'base' => NULL, 'refs' => [ 'DescribePoolsRequest$Filters' => '<p>An array of PoolFilter objects to filter the results.</p>', ], ], 'PoolFilterName' => [ 'base' => NULL, 'refs' => [ 'PoolFilter$Name' => '<p>The name of the attribute to filter on.</p>', ], ], 'PoolIdList' => [ 'base' => NULL, 'refs' => [ 'DescribePoolsRequest$PoolIds' => '<p>The unique identifier of pools to find. This is an array of strings that can be either the PoolId or PoolArn.</p>', ], ], 'PoolIdOrArn' => [ 'base' => NULL, 'refs' => [ 'AssociateOriginationIdentityRequest$PoolId' => '<p>The pool to update with the new Identity. This value can be either the PoolId or PoolArn, and you can find these values using <a>DescribePools</a>.</p>', 'DeletePoolRequest$PoolId' => '<p>The PoolId or PoolArn of the pool to delete. You can use <a>DescribePools</a> to find the values for PoolId and PoolArn .</p>', 'DisassociateOriginationIdentityRequest$PoolId' => '<p>The unique identifier for the pool to disassociate with the origination identity. This value can be either the PoolId or PoolArn.</p>', 'ListPoolOriginationIdentitiesRequest$PoolId' => '<p>The unique identifier for the pool. This value can be either the PoolId or PoolArn.</p>', 'PoolIdList$member' => NULL, 'RequestPhoneNumberRequest$PoolId' => '<p>The pool to associated with the phone number. You can use the PoolId or PoolArn. </p>', 'UpdatePoolRequest$PoolId' => '<p>The unique identifier of the pool to update. Valid values are either the PoolId or PoolArn.</p>', ], ], 'PoolInformation' => [ 'base' => '<p>The information for a pool in an Amazon Web Services account.</p>', 'refs' => [ 'PoolInformationList$member' => NULL, ], ], 'PoolInformationList' => [ 'base' => NULL, 'refs' => [ 'DescribePoolsResult$Pools' => '<p>An array of PoolInformation objects that contain the details for the requested pools. </p>', ], ], 'PoolOriginationIdentitiesFilter' => [ 'base' => '<p>Information about origination identities associated with a pool that meets a specified criteria.</p>', 'refs' => [ 'PoolOriginationIdentitiesFilterList$member' => NULL, ], ], 'PoolOriginationIdentitiesFilterList' => [ 'base' => NULL, 'refs' => [ 'ListPoolOriginationIdentitiesRequest$Filters' => '<p>An array of PoolOriginationIdentitiesFilter objects to filter the results..</p>', ], ], 'PoolOriginationIdentitiesFilterName' => [ 'base' => NULL, 'refs' => [ 'PoolOriginationIdentitiesFilter$Name' => '<p>The name of the attribute to filter on.</p>', ], ], 'PoolStatus' => [ 'base' => NULL, 'refs' => [ 'CreatePoolResult$Status' => '<p>The current status of the pool.</p> <ul> <li> <p>CREATING: The pool is currently being created and isn\'t yet available for use.</p> </li> <li> <p>ACTIVE: The pool is active and available for use.</p> </li> <li> <p>DELETING: The pool is being deleted.</p> </li> </ul>', 'DeletePoolResult$Status' => '<p>The current status of the pool.</p> <ul> <li> <p>CREATING: The pool is currently being created and isn\'t yet available for use.</p> </li> <li> <p>ACTIVE: The pool is active and available for use.</p> </li> <li> <p>DELETING: The pool is being deleted.</p> </li> </ul>', 'PoolInformation$Status' => '<p>The current status of the pool.</p>', 'UpdatePoolResult$Status' => '<p>The current status of the pool update request.</p>', ], ], 'PrimitiveBoolean' => [ 'base' => NULL, 'refs' => [ 'CreatePoolResult$TwoWayEnabled' => '<p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>', 'CreatePoolResult$SelfManagedOptOutsEnabled' => '<p>By default this is set to false. When an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you\'re responsible for responding to HELP and STOP requests. You\'re also responsible for tracking and honoring opt-out requests.</p>', 'CreatePoolResult$SharedRoutesEnabled' => '<p>Indicates whether shared routes are enabled for the pool.</p>', 'CreatePoolResult$DeletionProtectionEnabled' => '<p>When set to true deletion protection is enabled. By default this is set to false. </p>', 'CreateProtectConfigurationResult$AccountDefault' => '<p>This is true if the protect configuration is set as your account default protect configuration.</p>', 'CreateProtectConfigurationResult$DeletionProtectionEnabled' => '<p>When set to true deletion protection is enabled. By default this is set to false. </p>', 'DeleteOptedOutNumberResult$EndUserOptedOut' => '<p>This is true if it was the end user who requested their phone number be removed. </p>', 'DeletePoolResult$TwoWayEnabled' => '<p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>', 'DeletePoolResult$SelfManagedOptOutsEnabled' => '<p>By default this is set to false. When an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you\'re responsible for responding to HELP and STOP requests. You\'re also responsible for tracking and honoring opt-out requests.</p>', 'DeletePoolResult$SharedRoutesEnabled' => '<p>Indicates whether shared routes are enabled for the pool.</p>', 'DeleteProtectConfigurationResult$AccountDefault' => '<p>This is true if the protect configuration is set as your account default protect configuration.</p>', 'DeleteProtectConfigurationResult$DeletionProtectionEnabled' => '<p>The status of deletion protection for the protect configuration. When set to true deletion protection is enabled. By default this is set to false. </p>', 'OptedOutNumberInformation$EndUserOptedOut' => '<p>This is set to true if it was the end recipient that opted out.</p>', 'PhoneNumberInformation$TwoWayEnabled' => '<p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients using the TwoWayChannelArn.</p>', 'PhoneNumberInformation$SelfManagedOptOutsEnabled' => '<p>When set to false an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you\'re responsible for responding to HELP and STOP requests. You\'re also responsible for tracking and honoring opt-out request. For more information see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/settings-sms-managing.html#settings-account-sms-self-managed-opt-out">Self-managed opt-outs</a> </p>', 'PhoneNumberInformation$DeletionProtectionEnabled' => '<p>When set to true the phone number can\'t be deleted.</p>', 'PoolInformation$TwoWayEnabled' => '<p>When set to true you can receive incoming text messages from your end recipients using the TwoWayChannelArn.</p>', 'PoolInformation$SelfManagedOptOutsEnabled' => '<p>When set to false, an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you\'re responsible for responding to HELP and STOP requests. You\'re also responsible for tracking and honoring opt-out requests. For more information see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/settings-sms-managing.html#settings-account-sms-self-managed-opt-out">Self-managed opt-outs</a> </p>', 'PoolInformation$SharedRoutesEnabled' => '<p>Allows you to enable shared routes on your pool.</p> <p>By default, this is set to <code>False</code>. If you set this value to <code>True</code>, your messages are sent using phone numbers or sender IDs (depending on the country) that are shared with other Amazon Pinpoint users. In some countries, such as the United States, senders aren\'t allowed to use shared routes and must use a dedicated phone number or short code.</p>', 'PoolInformation$DeletionProtectionEnabled' => '<p>When set to true the pool can\'t be deleted.</p>', 'ProtectConfigurationInformation$AccountDefault' => '<p>This is true if the protect configuration is set as your account default protect configuration.</p>', 'ProtectConfigurationInformation$DeletionProtectionEnabled' => '<p>The status of deletion protection for the protect configuration. When set to true deletion protection is enabled. By default this is set to false. </p>', 'PutOptedOutNumberResult$EndUserOptedOut' => '<p>This is true if it was the end user who requested their phone number be removed. </p>', 'ReleasePhoneNumberResult$TwoWayEnabled' => '<p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>', 'ReleasePhoneNumberResult$SelfManagedOptOutsEnabled' => '<p>By default this is set to false. When an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you\'re responsible for responding to HELP and STOP requests. You\'re also responsible for tracking and honoring opt-out requests.</p>', 'ReleaseSenderIdResult$Registered' => '<p>True if the sender ID is registered.</p>', 'RequestPhoneNumberResult$TwoWayEnabled' => '<p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>', 'RequestPhoneNumberResult$SelfManagedOptOutsEnabled' => '<p>By default this is set to false. When an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you\'re responsible for responding to HELP and STOP requests. You\'re also responsible for tracking and honoring opt-out requests.</p>', 'RequestPhoneNumberResult$DeletionProtectionEnabled' => '<p>By default this is set to false. When set to true the phone number can\'t be deleted. </p>', 'RequestSenderIdResult$DeletionProtectionEnabled' => '<p>By default this is set to false. When set to true the sender ID can\'t be deleted.</p>', 'RequestSenderIdResult$Registered' => '<p>True if the sender ID is registered.</p>', 'SendMediaMessageRequest$DryRun' => '<p>When set to true, the message is checked and validated, but isn\'t sent to the end recipient.</p>', 'SendTextMessageRequest$DryRun' => '<p>When set to true, the message is checked and validated, but isn\'t sent to the end recipient.</p>', 'SendVoiceMessageRequest$DryRun' => '<p>When set to true, the message is checked and validated, but isn\'t sent to the end recipient.</p>', 'SenderIdInformation$DeletionProtectionEnabled' => '<p>By default this is set to false. When set to true the sender ID can\'t be deleted.</p>', 'SenderIdInformation$Registered' => '<p>True if the sender ID is registered.</p>', 'SpendLimit$Overridden' => '<p>When set to <code>True</code>, the value that has been specified in the <code>EnforcedLimit</code> is used to determine the maximum amount in US dollars that can be spent to send messages each month, in US dollars.</p>', 'UpdatePhoneNumberResult$TwoWayEnabled' => '<p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>', 'UpdatePhoneNumberResult$SelfManagedOptOutsEnabled' => '<p>This is true if self managed opt-out are enabled.</p>', 'UpdatePhoneNumberResult$DeletionProtectionEnabled' => '<p>When set to true the phone number can\'t be deleted.</p>', 'UpdatePoolResult$TwoWayEnabled' => '<p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>', 'UpdatePoolResult$SelfManagedOptOutsEnabled' => '<p>When an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you\'re responsible for responding to HELP and STOP requests. You\'re also responsible for tracking and honoring opt-out requests.</p>', 'UpdatePoolResult$SharedRoutesEnabled' => '<p>Indicates whether shared routes are enabled for the pool.</p>', 'UpdatePoolResult$DeletionProtectionEnabled' => '<p>When set to true the pool can\'t be deleted.</p>', 'UpdateProtectConfigurationResult$AccountDefault' => '<p>This is true if the protect configuration is set as your account default protect configuration.</p>', 'UpdateProtectConfigurationResult$DeletionProtectionEnabled' => '<p>The status of deletion protection for the protect configuration. When set to true deletion protection is enabled. By default this is set to false. </p>', 'UpdateSenderIdResult$DeletionProtectionEnabled' => '<p>By default this is set to false. When set to true the sender ID can\'t be deleted.</p>', 'UpdateSenderIdResult$Registered' => '<p>True if the sender ID is registered..</p>', ], ], 'PrimitiveLong' => [ 'base' => NULL, 'refs' => [ 'AccountLimit$Used' => '<p>The current amount that has been spent, in US dollars.</p>', 'AccountLimit$Max' => '<p>The Amazon Web Services set limit for that resource type, in US dollars.</p>', 'SpendLimit$EnforcedLimit' => '<p>The maximum amount of money, in US dollars, that you want to be able to spend sending messages each month. This value has to be less than or equal to the amount in <code>MaxLimit</code>. To use this custom limit, <code>Overridden</code> must be set to true.</p>', 'SpendLimit$MaxLimit' => '<p> The maximum amount of money that you are able to spend to send messages each month, in US dollars.</p>', ], ], 'ProtectConfigurationArn' => [ 'base' => NULL, 'refs' => [ 'AssociateProtectConfigurationResult$ProtectConfigurationArn' => '<p>The Amazon Resource Name (ARN) of the protect configuration.</p>', 'CreateProtectConfigurationResult$ProtectConfigurationArn' => '<p>The Amazon Resource Name (ARN) of the protect configuration.</p>', 'DeleteAccountDefaultProtectConfigurationResult$DefaultProtectConfigurationArn' => '<p>The Amazon Resource Name (ARN) of the account default protect configuration.</p>', 'DeleteProtectConfigurationResult$ProtectConfigurationArn' => '<p>The Amazon Resource Name (ARN) of the protect configuration.</p>', 'DisassociateProtectConfigurationResult$ProtectConfigurationArn' => '<p>The Amazon Resource Name (ARN) of the protect configuration.</p>', 'GetProtectConfigurationCountryRuleSetResult$ProtectConfigurationArn' => '<p>The Amazon Resource Name (ARN) of the protect configuration.</p>', 'ProtectConfigurationInformation$ProtectConfigurationArn' => '<p>The Amazon Resource Name (ARN) of the protect configuration.</p>', 'SetAccountDefaultProtectConfigurationResult$DefaultProtectConfigurationArn' => '<p>The Amazon Resource Name (ARN) of the account default protect configuration.</p>', 'UpdateProtectConfigurationCountryRuleSetResult$ProtectConfigurationArn' => '<p>The Amazon Resource Name (ARN) of the protect configuration.</p>', 'UpdateProtectConfigurationResult$ProtectConfigurationArn' => '<p>The Amazon Resource Name (ARN) of the protect configuration.</p>', ], ], 'ProtectConfigurationCountryRuleSet' => [ 'base' => NULL, 'refs' => [ 'GetProtectConfigurationCountryRuleSetResult$CountryRuleSet' => '<p>A map of ProtectConfigurationCountryRuleSetInformation objects that contain the details for the requested NumberCapability. The Key is the two-letter ISO country code. For a list of supported ISO country codes, see <a href="https://docs.aws.amazon.com/sms-voice/latest/userguide/phone-numbers-sms-by-country.html">Supported countries and regions (SMS channel)</a> in the Amazon Pinpoint SMS user guide.</p>', 'UpdateProtectConfigurationCountryRuleSetRequest$CountryRuleSetUpdates' => '<p>A map of ProtectConfigurationCountryRuleSetInformation objects that contain the details for the requested NumberCapability. The Key is the two-letter ISO country code. For a list of supported ISO country codes, see <a href="https://docs.aws.amazon.com/sms-voice/latest/userguide/phone-numbers-sms-by-country.html">Supported countries and regions (SMS channel)</a> in the Amazon Pinpoint SMS user guide.</p>', 'UpdateProtectConfigurationCountryRuleSetResult$CountryRuleSet' => '<p>An array of ProtectConfigurationCountryRuleSetInformation containing the rules for the NumberCapability.</p>', ], ], 'ProtectConfigurationCountryRuleSetInformation' => [ 'base' => '<p>The types of statuses that can be used.</p>', 'refs' => [ 'ProtectConfigurationCountryRuleSet$value' => NULL, ], ], 'ProtectConfigurationFilter' => [ 'base' => '<p>The filter definition for filtering protect configurations that meet a specified criteria.</p>', 'refs' => [ 'ProtectConfigurationFilterList$member' => NULL, ], ], 'ProtectConfigurationFilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeProtectConfigurationsRequest$Filters' => '<p>An array of ProtectConfigurationFilter objects to filter the results.</p>', ], ], 'ProtectConfigurationFilterName' => [ 'base' => NULL, 'refs' => [ 'ProtectConfigurationFilter$Name' => '<p>The name of the attribute to filter on.</p>', ], ], 'ProtectConfigurationId' => [ 'base' => NULL, 'refs' => [ 'AssociateProtectConfigurationResult$ProtectConfigurationId' => '<p>The unique identifier for the protect configuration.</p>', 'CreateProtectConfigurationResult$ProtectConfigurationId' => '<p>The unique identifier for the protect configuration.</p>', 'DeleteAccountDefaultProtectConfigurationResult$DefaultProtectConfigurationId' => '<p>The unique identifier of the account default protect configuration.</p>', 'DeleteProtectConfigurationResult$ProtectConfigurationId' => '<p>The unique identifier for the protect configuration.</p>', 'DisassociateProtectConfigurationResult$ProtectConfigurationId' => '<p>The unique identifier for the protect configuration.</p>', 'GetProtectConfigurationCountryRuleSetResult$ProtectConfigurationId' => '<p>The unique identifier for the protect configuration.</p>', 'ProtectConfigurationInformation$ProtectConfigurationId' => '<p>The unique identifier for the protect configuration.</p>', 'SetAccountDefaultProtectConfigurationResult$DefaultProtectConfigurationId' => '<p>The unique identifier of the account default protect configuration.</p>', 'UpdateProtectConfigurationCountryRuleSetResult$ProtectConfigurationId' => '<p>The unique identifier for the protect configuration.</p>', 'UpdateProtectConfigurationResult$ProtectConfigurationId' => '<p>The unique identifier for the protect configuration.</p>', ], ], 'ProtectConfigurationIdList' => [ 'base' => NULL, 'refs' => [ 'DescribeProtectConfigurationsRequest$ProtectConfigurationIds' => '<p>An array of protect configuration identifiers to search for.</p>', ], ], 'ProtectConfigurationIdOrArn' => [ 'base' => NULL, 'refs' => [ 'AssociateProtectConfigurationRequest$ProtectConfigurationId' => '<p>The unique identifier for the protect configuration.</p>', 'ConfigurationSetInformation$ProtectConfigurationId' => '<p>The unique identifier for the protect configuration.</p>', 'DeleteProtectConfigurationRequest$ProtectConfigurationId' => '<p>The unique identifier for the protect configuration.</p>', 'DisassociateProtectConfigurationRequest$ProtectConfigurationId' => '<p>The unique identifier for the protect configuration.</p>', 'GetProtectConfigurationCountryRuleSetRequest$ProtectConfigurationId' => '<p>The unique identifier for the protect configuration.</p>', 'ProtectConfigurationIdList$member' => NULL, 'SendMediaMessageRequest$ProtectConfigurationId' => '<p>The unique identifier of the protect configuration to use.</p>', 'SendTextMessageRequest$ProtectConfigurationId' => '<p>The unique identifier for the protect configuration.</p>', 'SendVoiceMessageRequest$ProtectConfigurationId' => '<p>The unique identifier for the protect configuration.</p>', 'SetAccountDefaultProtectConfigurationRequest$ProtectConfigurationId' => '<p>The unique identifier for the protect configuration.</p>', 'UpdateProtectConfigurationCountryRuleSetRequest$ProtectConfigurationId' => '<p>The unique identifier for the protect configuration.</p>', 'UpdateProtectConfigurationRequest$ProtectConfigurationId' => '<p>The unique identifier for the protect configuration.</p>', ], ], 'ProtectConfigurationInformation' => [ 'base' => '<p>Provides information on the specified protect configuration.</p>', 'refs' => [ 'ProtectConfigurationInformationList$member' => NULL, ], ], 'ProtectConfigurationInformationList' => [ 'base' => NULL, 'refs' => [ 'DescribeProtectConfigurationsResult$ProtectConfigurations' => '<p>An array of ProtectConfigurationInformation objects that contain the details for the request. </p>', ], ], 'ProtectStatus' => [ 'base' => NULL, 'refs' => [ 'ProtectConfigurationCountryRuleSetInformation$ProtectStatus' => '<p>The types of protection that can be used.</p>', ], ], 'PutKeywordRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutKeywordResult' => [ 'base' => NULL, 'refs' => [], ], 'PutOptedOutNumberRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutOptedOutNumberResult' => [ 'base' => NULL, 'refs' => [], ], 'PutRegistrationFieldValueRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutRegistrationFieldValueResult' => [ 'base' => NULL, 'refs' => [], ], 'RegistrationAssociationBehavior' => [ 'base' => NULL, 'refs' => [ 'SupportedAssociation$AssociationBehavior' => '<p>The association behavior.</p> <ul> <li> <p> <code>ASSOCIATE_BEFORE_SUBMIT</code> The origination identity has to be supplied when creating a registration.</p> </li> <li> <p> <code>ASSOCIATE_ON_APPROVAL</code> This applies to all short code registrations. The short code will be automatically provisioned once the registration is approved.</p> </li> <li> <p> <code>ASSOCIATE_AFTER_COMPLETE</code> This applies to phone number registrations when you must complete a registration first, then associate one or more phone numbers later. For example 10DLC campaigns and long codes. </p> </li> </ul>', ], ], 'RegistrationAssociationFilter' => [ 'base' => '<p>The filter definition for filtering registrations that meets a specified criteria.</p>', 'refs' => [ 'RegistrationAssociationFilterList$member' => NULL, ], ], 'RegistrationAssociationFilterList' => [ 'base' => NULL, 'refs' => [ 'ListRegistrationAssociationsRequest$Filters' => '<p>An array of RegistrationAssociationFilter to apply to the results that are returned.</p>', ], ], 'RegistrationAssociationFilterName' => [ 'base' => NULL, 'refs' => [ 'RegistrationAssociationFilter$Name' => '<p>The name of the attribute to filter on.</p>', ], ], 'RegistrationAssociationMetadata' => [ 'base' => '<p>Metadata for the origination identity that is associated with the registration.</p>', 'refs' => [ 'RegistrationAssociationMetadataList$member' => NULL, ], ], 'RegistrationAssociationMetadataList' => [ 'base' => NULL, 'refs' => [ 'ListRegistrationAssociationsResult$RegistrationAssociations' => '<p>An array of RegistrationAssociationMetadata objects.</p>', ], ], 'RegistrationAttachmentFilter' => [ 'base' => '<p>The filter definition for filtering registration attachments that meets a specified criteria.</p>', 'refs' => [ 'RegistrationAttachmentFilterList$member' => NULL, ], ], 'RegistrationAttachmentFilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeRegistrationAttachmentsRequest$Filters' => '<p>An array of RegistrationAttachmentFilter objects to filter the results.</p>', ], ], 'RegistrationAttachmentFilterName' => [ 'base' => NULL, 'refs' => [ 'RegistrationAttachmentFilter$Name' => '<p>The name of the attribute to filter on.</p>', ], ], 'RegistrationAttachmentIdList' => [ 'base' => NULL, 'refs' => [ 'DescribeRegistrationAttachmentsRequest$RegistrationAttachmentIds' => '<p>The unique identifier of registration attachments to find. This is an array of <b>RegistrationAttachmentId</b>.</p>', ], ], 'RegistrationAttachmentIdOrArn' => [ 'base' => NULL, 'refs' => [ 'DeleteRegistrationAttachmentRequest$RegistrationAttachmentId' => '<p>The unique identifier for the registration attachment.</p>', 'PutRegistrationFieldValueRequest$RegistrationAttachmentId' => '<p>The unique identifier for the registration attachment.</p>', 'RegistrationFieldValueInformation$RegistrationAttachmentId' => '<p>The unique identifier for the registration attachment.</p>', ], ], 'RegistrationAttachmentsInformation' => [ 'base' => '<p>Provides information on the specified registration attachments.</p>', 'refs' => [ 'RegistrationAttachmentsInformationList$member' => NULL, ], ], 'RegistrationAttachmentsInformationList' => [ 'base' => NULL, 'refs' => [ 'DescribeRegistrationAttachmentsResult$RegistrationAttachments' => '<p>An array of <b>RegistrationAttachments</b> objects that contain the details for the requested registration attachments. </p>', ], ], 'RegistrationDeniedReasonInformation' => [ 'base' => '<p>Provides the reason a registration was rejected.</p>', 'refs' => [ 'RegistrationDeniedReasonInformationList$member' => NULL, ], ], 'RegistrationDeniedReasonInformationList' => [ 'base' => NULL, 'refs' => [ 'RegistrationVersionInformation$DeniedReasons' => '<p>An array of RegistrationDeniedReasonInformation objects. </p>', ], ], 'RegistrationDisassociationBehavior' => [ 'base' => NULL, 'refs' => [ 'SupportedAssociation$DisassociationBehavior' => '<p>The disassociation behavior.</p> <ul> <li> <p> <code>DISASSOCIATE_ALL_CLOSES_REGISTRATION</code> All origination identities must be disassociated from the registration before the registration can be closed.</p> </li> <li> <p> <code>DISASSOCIATE_ALL_ALLOWS_DELETE_REGISTRATION</code> All origination identities must be disassociated from the registration before the registration can be deleted.</p> </li> <li> <p> <code>DELETE_REGISTRATION_DISASSOCIATES</code> The registration can be deleted and all origination identities will be disasscoiated.</p> </li> </ul>', ], ], 'RegistrationFieldDefinition' => [ 'base' => '<p>Provides a description of the specified field.</p>', 'refs' => [ 'RegistrationFieldDefinitionList$member' => NULL, ], ], 'RegistrationFieldDefinitionList' => [ 'base' => NULL, 'refs' => [ 'DescribeRegistrationFieldDefinitionsResult$RegistrationFieldDefinitions' => '<p>An array of RegistrationFieldDefinitions objects that contain the details for the requested fields. </p>', ], ], 'RegistrationFieldDisplayHints' => [ 'base' => '<p>Provides help information on the registration field.</p>', 'refs' => [ 'RegistrationFieldDefinition$DisplayHints' => '<p>An array of RegistrationFieldDisplayHints objects for the field.</p>', ], ], 'RegistrationFieldValueInformation' => [ 'base' => '<p>Provides the values of the specified field.</p>', 'refs' => [ 'RegistrationFieldValueInformationList$member' => NULL, ], ], 'RegistrationFieldValueInformationList' => [ 'base' => NULL, 'refs' => [ 'DescribeRegistrationFieldValuesResult$RegistrationFieldValues' => '<p>An array of RegistrationFieldValues objects that contain the values for the requested registration. </p>', ], ], 'RegistrationFilter' => [ 'base' => '<p>The filter definition for filtering registrations that meets a specified criteria.</p>', 'refs' => [ 'RegistrationFilterList$member' => NULL, ], ], 'RegistrationFilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeRegistrationsRequest$Filters' => '<p>An array of RegistrationFilter objects to filter the results.</p>', ], ], 'RegistrationFilterName' => [ 'base' => NULL, 'refs' => [ 'RegistrationFilter$Name' => '<p>The name of the attribute to filter on.</p>', ], ], 'RegistrationIdList' => [ 'base' => NULL, 'refs' => [ 'DescribeRegistrationsRequest$RegistrationIds' => '<p>An array of unique identifiers for each registration.</p>', ], ], 'RegistrationIdOrArn' => [ 'base' => NULL, 'refs' => [ 'CreateRegistrationAssociationRequest$RegistrationId' => '<p>The unique identifier for the registration.</p>', 'CreateRegistrationVersionRequest$RegistrationId' => '<p>The unique identifier for the registration.</p>', 'DeleteRegistrationFieldValueRequest$RegistrationId' => '<p>The unique identifier for the registration.</p>', 'DeleteRegistrationRequest$RegistrationId' => '<p>The unique identifier for the registration.</p>', 'DescribeRegistrationFieldValuesRequest$RegistrationId' => '<p>The unique identifier for the registration.</p>', 'DescribeRegistrationVersionsRequest$RegistrationId' => '<p>The unique identifier for the registration.</p>', 'DiscardRegistrationVersionRequest$RegistrationId' => '<p>The unique identifier for the registration.</p>', 'ListRegistrationAssociationsRequest$RegistrationId' => '<p>The unique identifier for the registration.</p>', 'PutRegistrationFieldValueRequest$RegistrationId' => '<p>The unique identifier for the registration.</p>', 'RegistrationAttachmentIdList$member' => NULL, 'RegistrationIdList$member' => NULL, 'RequestPhoneNumberRequest$RegistrationId' => '<p>Use this field to attach your phone number for an external registration process.</p>', 'SubmitRegistrationVersionRequest$RegistrationId' => '<p>The unique identifier for the registration.</p>', ], ], 'RegistrationInformation' => [ 'base' => '<p>Provides information about the requested registration.</p>', 'refs' => [ 'RegistrationInformationList$member' => NULL, ], ], 'RegistrationInformationList' => [ 'base' => NULL, 'refs' => [ 'DescribeRegistrationsResult$Registrations' => '<p>An array of RegistrationInformation objects.</p>', ], ], 'RegistrationSectionDefinition' => [ 'base' => '<p>Provides information on the specified section definition.</p>', 'refs' => [ 'RegistrationSectionDefinitionList$member' => NULL, ], ], 'RegistrationSectionDefinitionList' => [ 'base' => NULL, 'refs' => [ 'DescribeRegistrationSectionDefinitionsResult$RegistrationSectionDefinitions' => '<p>An array of RegistrationSectionDefinition objects.</p>', ], ], 'RegistrationSectionDisplayHints' => [ 'base' => '<p>Provides help information on the registration section.</p>', 'refs' => [ 'RegistrationSectionDefinition$DisplayHints' => '<p>The path to the section of the registration.</p>', ], ], 'RegistrationStatus' => [ 'base' => NULL, 'refs' => [ 'CreateRegistrationResult$RegistrationStatus' => '<p>The status of the registration.</p> <ul> <li> <p> <code>CREATED</code>: Your registration is created but not submitted.</p> </li> <li> <p> <code>SUBMITTED</code>: Your registration has been submitted and is awaiting review.</p> </li> <li> <p> <code>REVIEWING</code>: Your registration has been accepted and is being reviewed.</p> </li> <li> <p> <code>PROVISIONING</code>: Your registration has been approved and your origination identity is being created.</p> </li> <li> <p> <code>COMPLETE</code>: Your registration has been approved and and your origination identity has been created.</p> </li> <li> <p> <code>REQUIRES_UPDATES</code>: You must fix your registration and resubmit it.</p> </li> <li> <p> <code>CLOSED</code>: The phone number or sender ID has been deleted and you must also delete the registration for the number.</p> </li> <li> <p> <code>DELETED</code>: The registration has been deleted.</p> </li> </ul>', 'DeleteRegistrationResult$RegistrationStatus' => '<p>The status of the registration.</p> <ul> <li> <p> <code>CREATED</code>: Your registration is created but not submitted.</p> </li> <li> <p> <code>SUBMITTED</code>: Your registration has been submitted and is awaiting review.</p> </li> <li> <p> <code>REVIEWING</code>: Your registration has been accepted and is being reviewed.</p> </li> <li> <p> <code>PROVISIONING</code>: Your registration has been approved and your origination identity is being created.</p> </li> <li> <p> <code>COMPLETE</code>: Your registration has been approved and and your origination identity has been created.</p> </li> <li> <p> <code>REQUIRES_UPDATES</code>: You must fix your registration and resubmit it.</p> </li> <li> <p> <code>CLOSED</code>: The phone number or sender ID has been deleted and you must also delete the registration for the number.</p> </li> <li> <p> <code>DELETED</code>: The registration has been deleted.</p> </li> </ul>', 'RegistrationInformation$RegistrationStatus' => '<p>The status of the registration.</p> <ul> <li> <p> <code>CREATED</code>: Your registration is created but not submitted.</p> </li> <li> <p> <code>SUBMITTED</code>: Your registration has been submitted and is awaiting review.</p> </li> <li> <p> <code>REVIEWING</code>: Your registration has been accepted and is being reviewed.</p> </li> <li> <p> <code>PROVISIONING</code>: Your registration has been approved and your origination identity is being created.</p> </li> <li> <p> <code>COMPLETE</code>: Your registration has been approved and and your origination identity has been created.</p> </li> <li> <p> <code>REQUIRES_UPDATES</code>: You must fix your registration and resubmit it.</p> </li> <li> <p> <code>CLOSED</code>: The phone number or sender ID has been deleted and you must also delete the registration for the number.</p> </li> <li> <p> <code>DELETED</code>: The registration has been deleted.</p> </li> </ul>', ], ], 'RegistrationType' => [ 'base' => NULL, 'refs' => [ 'CreateRegistrationAssociationResult$RegistrationType' => '<p>The type of registration form. The list of <b>RegistrationTypes</b> can be found using the <a>DescribeRegistrationTypeDefinitions</a> action.</p>', 'CreateRegistrationRequest$RegistrationType' => '<p>The type of registration form to create. The list of <b>RegistrationTypes</b> can be found using the <a>DescribeRegistrationTypeDefinitions</a> action.</p>', 'CreateRegistrationResult$RegistrationType' => '<p>The type of registration form to create. The list of <b>RegistrationTypes</b> can be found using the <a>DescribeRegistrationTypeDefinitions</a> action.</p>', 'DeleteRegistrationResult$RegistrationType' => '<p>The type of registration form. The list of <b>RegistrationTypes</b> can be found using the <a>DescribeRegistrationTypeDefinitions</a> action.</p>', 'DescribeRegistrationFieldDefinitionsRequest$RegistrationType' => '<p>The type of registration form. The list of <b>RegistrationTypes</b> can be found using the <a>DescribeRegistrationTypeDefinitions</a> action.</p>', 'DescribeRegistrationFieldDefinitionsResult$RegistrationType' => '<p>The type of registration form. The list of <b>RegistrationTypes</b> can be found using the <a>DescribeRegistrationTypeDefinitions</a> action.</p>', 'DescribeRegistrationSectionDefinitionsRequest$RegistrationType' => '<p>The type of registration form. The list of <b>RegistrationTypes</b> can be found using the <a>DescribeRegistrationTypeDefinitions</a> action.</p>', 'DescribeRegistrationSectionDefinitionsResult$RegistrationType' => '<p>The type of registration form. The list of <b>RegistrationTypes</b> can be found using the <a>DescribeRegistrationTypeDefinitions</a> action.</p>', 'ListRegistrationAssociationsResult$RegistrationType' => '<p>The type of registration form. The list of <b>RegistrationTypes</b> can be found using the <a>DescribeRegistrationTypeDefinitions</a> action.</p>', 'RegistrationInformation$RegistrationType' => '<p>The type of registration form. The list of <b>RegistrationTypes</b> can be found using the <a>DescribeRegistrationTypeDefinitions</a> action.</p>', 'RegistrationTypeDefinition$RegistrationType' => '<p>The type of registration form. The list of <b>RegistrationTypes</b> can be found using the <a>DescribeRegistrationTypeDefinitions</a> action.</p>', 'RegistrationTypeList$member' => NULL, ], ], 'RegistrationTypeDefinition' => [ 'base' => '<p>Provides information on the supported registration type.</p>', 'refs' => [ 'RegistrationTypeDefinitionList$member' => NULL, ], ], 'RegistrationTypeDefinitionList' => [ 'base' => NULL, 'refs' => [ 'DescribeRegistrationTypeDefinitionsResult$RegistrationTypeDefinitions' => '<p>The type of registration form. The list of <b>RegistrationTypes</b> can be found using the <a>DescribeRegistrationTypeDefinitions</a> action.</p>', ], ], 'RegistrationTypeDisplayHints' => [ 'base' => '<p>Provides help information on the registration type.</p>', 'refs' => [ 'RegistrationTypeDefinition$DisplayHints' => '<p>Provides help information on the registration.</p>', ], ], 'RegistrationTypeFilter' => [ 'base' => '<p>The filter definition for filtering registration types that meets a specified criteria.</p>', 'refs' => [ 'RegistrationTypeFilterList$member' => NULL, ], ], 'RegistrationTypeFilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeRegistrationTypeDefinitionsRequest$Filters' => '<p>An array of RegistrationFilter objects to filter the results.</p>', ], ], 'RegistrationTypeFilterName' => [ 'base' => NULL, 'refs' => [ 'RegistrationTypeFilter$Name' => '<p>The name of the attribute to filter on.</p>', ], ], 'RegistrationTypeList' => [ 'base' => NULL, 'refs' => [ 'DescribeRegistrationTypeDefinitionsRequest$RegistrationTypes' => '<p>The type of registration form. The list of <b>RegistrationTypes</b> can be found using the <a>DescribeRegistrationTypeDefinitions</a> action.</p>', ], ], 'RegistrationVersionFilter' => [ 'base' => '<p>The filter definition for filtering registration versions that meets a specified criteria.</p>', 'refs' => [ 'RegistrationVersionFilterList$member' => NULL, ], ], 'RegistrationVersionFilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeRegistrationVersionsRequest$Filters' => '<p>An array of RegistrationVersionFilter objects to filter the results.</p>', ], ], 'RegistrationVersionFilterName' => [ 'base' => NULL, 'refs' => [ 'RegistrationVersionFilter$Name' => '<p>The name of the attribute to filter on.</p>', ], ], 'RegistrationVersionInformation' => [ 'base' => '<p>Provides information about the specified version of the registration.</p>', 'refs' => [ 'RegistrationVersionInformationList$member' => NULL, ], ], 'RegistrationVersionInformationList' => [ 'base' => NULL, 'refs' => [ 'DescribeRegistrationVersionsResult$RegistrationVersions' => '<p>An array of RegistrationVersions objects.</p>', ], ], 'RegistrationVersionNumber' => [ 'base' => NULL, 'refs' => [ 'CreateRegistrationResult$CurrentVersionNumber' => '<p>The current version number of the registration.</p>', 'CreateRegistrationVersionResult$VersionNumber' => '<p>The new version number of the registration.</p>', 'DeleteRegistrationFieldValueResult$VersionNumber' => '<p>The version number of the registration.</p>', 'DeleteRegistrationResult$CurrentVersionNumber' => '<p>The current version number of the registration.</p>', 'DeleteRegistrationResult$ApprovedVersionNumber' => '<p>The version number of the registration that was approved.</p>', 'DeleteRegistrationResult$LatestDeniedVersionNumber' => '<p>The latest version number of the registration that was denied.</p>', 'DescribeRegistrationFieldValuesRequest$VersionNumber' => '<p>The version number of the registration.</p>', 'DescribeRegistrationFieldValuesResult$VersionNumber' => '<p>The current version of the registration.</p>', 'DiscardRegistrationVersionResult$VersionNumber' => '<p>The version number of the registration.</p>', 'PutRegistrationFieldValueResult$VersionNumber' => '<p>The version number of the registration.</p>', 'RegistrationInformation$CurrentVersionNumber' => '<p>The current version number of the registration.</p>', 'RegistrationInformation$ApprovedVersionNumber' => '<p>The version number of the registration that was approved.</p>', 'RegistrationInformation$LatestDeniedVersionNumber' => '<p>The latest version number of the registration that was denied.</p>', 'RegistrationVersionInformation$VersionNumber' => '<p>The version number of the registration.</p>', 'RegistrationVersionNumberList$member' => NULL, 'SubmitRegistrationVersionResult$VersionNumber' => '<p>The version number of the registration.</p>', ], ], 'RegistrationVersionNumberList' => [ 'base' => NULL, 'refs' => [ 'DescribeRegistrationVersionsRequest$VersionNumbers' => '<p>An array of registration version numbers.</p>', ], ], 'RegistrationVersionStatus' => [ 'base' => NULL, 'refs' => [ 'CreateRegistrationVersionResult$RegistrationVersionStatus' => '<p>The status of the registration.</p> <ul> <li> <p> <code>DRAFT</code>: The initial status of a registration version after it’s created.</p> </li> <li> <p> <code>SUBMITTED</code>: Your registration has been submitted.</p> </li> <li> <p> <code>REVIEWING</code>: Your registration has been accepted and is being reviewed.</p> </li> <li> <p> <code>APPROVED</code>: Your registration has been approved.</p> </li> <li> <p> <code>DISCARDED</code>: You\'ve abandon this version of their registration to start over with a new version. </p> </li> <li> <p> <code>DENIED</code>: You must fix your registration and resubmit it.</p> </li> <li> <p> <code>REVOKED</code>: Your previously approved registration has been revoked.</p> </li> <li> <p> <code>ARCHIVED</code>: Your previously approved registration version moves into this status when a more recently submitted version is approved.</p> </li> </ul>', 'DiscardRegistrationVersionResult$RegistrationVersionStatus' => '<p>The status of the registration version.</p> <ul> <li> <p> <code>DRAFT</code>: The initial status of a registration version after it’s created.</p> </li> <li> <p> <code>SUBMITTED</code>: Your registration has been submitted.</p> </li> <li> <p> <code>REVIEWING</code>: Your registration has been accepted and is being reviewed.</p> </li> <li> <p> <code>APPROVED</code>: Your registration has been approved.</p> </li> <li> <p> <code>DISCARDED</code>: You\'ve abandon this version of their registration to start over with a new version. </p> </li> <li> <p> <code>DENIED</code>: You must fix your registration and resubmit it.</p> </li> <li> <p> <code>REVOKED</code>: Your previously approved registration has been revoked.</p> </li> <li> <p> <code>ARCHIVED</code>: Your previously approved registration version moves into this status when a more recently submitted version is approved.</p> </li> </ul>', 'RegistrationVersionInformation$RegistrationVersionStatus' => '<p>The status of the registration.</p> <ul> <li> <p> <code>DRAFT</code>: The initial status of a registration version after it’s created.</p> </li> <li> <p> <code>SUBMITTED</code>: Your registration has been submitted.</p> </li> <li> <p> <code>REVIEWING</code>: Your registration has been accepted and is being reviewed.</p> </li> <li> <p> <code>APPROVED</code>: Your registration has been approved.</p> </li> <li> <p> <code>DISCARDED</code>: You\'ve abandon this version of their registration to start over with a new version. </p> </li> <li> <p> <code>DENIED</code>: You must fix your registration and resubmit it.</p> </li> <li> <p> <code>REVOKED</code>: Your previously approved registration has been revoked.</p> </li> <li> <p> <code>ARCHIVED</code>: Your previously approved registration version moves into this status when a more recently submitted version is approved.</p> </li> </ul>', 'SubmitRegistrationVersionResult$RegistrationVersionStatus' => '<p>The status of the registration version.</p> <ul> <li> <p> <code>DRAFT</code>: The initial status of a registration version after it’s created.</p> </li> <li> <p> <code>SUBMITTED</code>: Your registration has been submitted.</p> </li> <li> <p> <code>REVIEWING</code>: Your registration has been accepted and is being reviewed.</p> </li> <li> <p> <code>APPROVED</code>: Your registration has been approved.</p> </li> <li> <p> <code>DISCARDED</code>: You\'ve abandon this version of their registration to start over with a new version. </p> </li> <li> <p> <code>DENIED</code>: You must fix your registration and resubmit it.</p> </li> <li> <p> <code>REVOKED</code>: Your previously approved registration has been revoked.</p> </li> <li> <p> <code>ARCHIVED</code>: Your previously approved registration version moves into this status when a more recently submitted version is approved.</p> </li> </ul>', ], ], 'RegistrationVersionStatusHistory' => [ 'base' => '<p>The <b>RegistrationVersionStatusHistory</b> object contains the time stamps for when the reservations status changes.</p>', 'refs' => [ 'CreateRegistrationVersionResult$RegistrationVersionStatusHistory' => '<p>A <b>RegistrationVersionStatusHistory</b> object that contains timestamps for the registration.</p>', 'DiscardRegistrationVersionResult$RegistrationVersionStatusHistory' => '<p>The <b>RegistrationVersionStatusHistory</b> object contains the time stamps for when the reservations status changes.</p>', 'RegistrationVersionInformation$RegistrationVersionStatusHistory' => '<p>The <b>RegistrationVersionStatusHistory</b> object contains the time stamps for when the reservations status changes.</p>', 'SubmitRegistrationVersionResult$RegistrationVersionStatusHistory' => '<p>The <b>RegistrationVersionStatusHistory</b> object contains the time stamps for when the reservations status changes.</p>', ], ], 'ReleasePhoneNumberRequest' => [ 'base' => NULL, 'refs' => [], ], 'ReleasePhoneNumberResult' => [ 'base' => NULL, 'refs' => [], ], 'ReleaseSenderIdRequest' => [ 'base' => NULL, 'refs' => [], ], 'ReleaseSenderIdResult' => [ 'base' => NULL, 'refs' => [], ], 'RequestPhoneNumberRequest' => [ 'base' => NULL, 'refs' => [], ], 'RequestPhoneNumberResult' => [ 'base' => NULL, 'refs' => [], ], 'RequestSenderIdRequest' => [ 'base' => NULL, 'refs' => [], ], 'RequestSenderIdResult' => [ 'base' => NULL, 'refs' => [], ], 'RequestableNumberType' => [ 'base' => NULL, 'refs' => [ 'RequestPhoneNumberRequest$NumberType' => '<p>The type of phone number to request.</p>', 'RequestPhoneNumberResult$NumberType' => '<p>The type of number that was released.</p>', ], ], 'ResourceIdOrArn' => [ 'base' => NULL, 'refs' => [ 'CreateRegistrationAssociationRequest$ResourceId' => '<p>The unique identifier for the origination identity. For example this could be a <b>PhoneNumberId</b> or <b>SenderId</b>.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>A requested resource couldn\'t be found.</p>', 'refs' => [], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'ConflictException$ResourceType' => '<p>The type of resource that caused the exception.</p>', 'ResourceNotFoundException$ResourceType' => '<p>The type of resource that caused the exception.</p>', ], ], 'SectionPath' => [ 'base' => NULL, 'refs' => [ 'DescribeRegistrationFieldDefinitionsRequest$SectionPath' => '<p>The path to the section of the registration.</p>', 'DescribeRegistrationFieldValuesRequest$SectionPath' => '<p>The path to the section of the registration.</p>', 'RegistrationFieldDefinition$SectionPath' => '<p>The section path of the field.</p>', 'RegistrationSectionDefinition$SectionPath' => '<p>The path to the section of the registration.</p>', 'SectionPathList$member' => NULL, ], ], 'SectionPathList' => [ 'base' => NULL, 'refs' => [ 'DescribeRegistrationSectionDefinitionsRequest$SectionPaths' => '<p>An array of paths for the registration form section.</p>', ], ], 'SelectChoice' => [ 'base' => NULL, 'refs' => [ 'SelectChoiceList$member' => NULL, ], ], 'SelectChoiceList' => [ 'base' => NULL, 'refs' => [ 'DeleteRegistrationFieldValueResult$SelectChoices' => '<p>An array of values for the form field.</p>', 'PutRegistrationFieldValueRequest$SelectChoices' => '<p>An array of values for the form field.</p>', 'PutRegistrationFieldValueResult$SelectChoices' => '<p>An array of values for the form field.</p>', 'RegistrationFieldValueInformation$SelectChoices' => '<p>An array of values for the form field.</p>', ], ], 'SelectOptionDescription' => [ 'base' => '<p>A description of each select option.</p>', 'refs' => [ 'SelectOptionDescriptionsList$member' => NULL, ], ], 'SelectOptionDescriptionsList' => [ 'base' => NULL, 'refs' => [ 'RegistrationFieldDisplayHints$SelectOptionDescriptions' => '<p>An array of SelectOptionDescription objects.</p>', ], ], 'SelectValidation' => [ 'base' => '<p>Validation rules for a select field.</p>', 'refs' => [ 'RegistrationFieldDefinition$SelectValidation' => '<p>The validation rules for a select field.</p>', ], ], 'SendDestinationNumberVerificationCodeRequest' => [ 'base' => NULL, 'refs' => [], ], 'SendDestinationNumberVerificationCodeResult' => [ 'base' => NULL, 'refs' => [], ], 'SendMediaMessageRequest' => [ 'base' => NULL, 'refs' => [], ], 'SendMediaMessageResult' => [ 'base' => NULL, 'refs' => [], ], 'SendTextMessageRequest' => [ 'base' => NULL, 'refs' => [], ], 'SendTextMessageResult' => [ 'base' => NULL, 'refs' => [], ], 'SendVoiceMessageRequest' => [ 'base' => NULL, 'refs' => [], ], 'SendVoiceMessageResult' => [ 'base' => NULL, 'refs' => [], ], 'SenderId' => [ 'base' => NULL, 'refs' => [ 'ConfigurationSetInformation$DefaultSenderId' => '<p>The default sender ID used by the ConfigurationSet.</p>', 'DeleteConfigurationSetResult$DefaultSenderId' => '<p>The default Sender ID of the configuration set that was deleted.</p>', 'DeleteDefaultSenderIdResult$SenderId' => '<p>The current sender ID for the configuration set.</p>', 'ReleaseSenderIdResult$SenderId' => '<p>The sender ID that was released.</p>', 'RequestSenderIdRequest$SenderId' => '<p>The sender ID string to request.</p>', 'RequestSenderIdResult$SenderId' => '<p>The sender ID that was requested.</p>', 'SenderIdInformation$SenderId' => '<p>The alphanumeric sender ID in a specific country that you\'d like to describe.</p>', 'SetDefaultSenderIdRequest$SenderId' => '<p>The current sender ID for the configuration set. When sending a text message to a destination country which supports SenderIds, the default sender ID on the configuration set specified on <a>SendTextMessage</a> will be used if no dedicated origination phone numbers or registered SenderIds are available in your account, instead of a generic sender ID, such as \'NOTICE\'.</p>', 'SetDefaultSenderIdResult$SenderId' => '<p>The default sender ID to set for the ConfigurationSet.</p>', 'UpdateSenderIdResult$SenderId' => '<p>The sender ID that was updated.</p>', ], ], 'SenderIdAndCountry' => [ 'base' => '<p> The alphanumeric sender ID in a specific country that you want to describe. For more information on sender IDs see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-awssupport-sender-id.html">Requesting sender IDs for SMS messaging with Amazon Pinpoint </a> in the <i>Amazon Pinpoint User Guide</i>.</p>', 'refs' => [ 'SenderIdList$member' => NULL, ], ], 'SenderIdFilter' => [ 'base' => '<p>The information for a sender ID that meets a specified criteria.</p>', 'refs' => [ 'SenderIdFilterList$member' => NULL, ], ], 'SenderIdFilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeSenderIdsRequest$Filters' => '<p>An array of SenderIdFilter objects to filter the results.</p>', ], ], 'SenderIdFilterName' => [ 'base' => NULL, 'refs' => [ 'SenderIdFilter$Name' => '<p>The name of the attribute to filter on.</p>', ], ], 'SenderIdInformation' => [ 'base' => '<p>The information for all SenderIds in an Amazon Web Services account.</p>', 'refs' => [ 'SenderIdInformationList$member' => NULL, ], ], 'SenderIdInformationList' => [ 'base' => NULL, 'refs' => [ 'DescribeSenderIdsResult$SenderIds' => '<p>An array of SernderIdInformation objects that contain the details for the requested SenderIds.</p>', ], ], 'SenderIdList' => [ 'base' => NULL, 'refs' => [ 'DescribeSenderIdsRequest$SenderIds' => '<p>An array of SenderIdAndCountry objects to search for.</p>', ], ], 'SenderIdOrArn' => [ 'base' => NULL, 'refs' => [ 'ReleaseSenderIdRequest$SenderId' => '<p>The sender ID to release.</p>', 'SenderIdAndCountry$SenderId' => '<p>The unique identifier of the sender.</p>', 'UpdateSenderIdRequest$SenderId' => '<p>The sender ID to update.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>The request would cause a service quota to be exceeded.</p>', 'refs' => [], ], 'ServiceQuotaExceededExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ServiceQuotaExceededException$Reason' => '<p>The reason for the exception.</p>', ], ], 'SetAccountDefaultProtectConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'SetAccountDefaultProtectConfigurationResult' => [ 'base' => NULL, 'refs' => [], ], 'SetDefaultMessageTypeRequest' => [ 'base' => NULL, 'refs' => [], ], 'SetDefaultMessageTypeResult' => [ 'base' => NULL, 'refs' => [], ], 'SetDefaultSenderIdRequest' => [ 'base' => NULL, 'refs' => [], ], 'SetDefaultSenderIdResult' => [ 'base' => NULL, 'refs' => [], ], 'SetMediaMessageSpendLimitOverrideRequest' => [ 'base' => NULL, 'refs' => [], ], 'SetMediaMessageSpendLimitOverrideResult' => [ 'base' => NULL, 'refs' => [], ], 'SetTextMessageSpendLimitOverrideRequest' => [ 'base' => NULL, 'refs' => [], ], 'SetTextMessageSpendLimitOverrideResult' => [ 'base' => NULL, 'refs' => [], ], 'SetVoiceMessageSpendLimitOverrideRequest' => [ 'base' => NULL, 'refs' => [], ], 'SetVoiceMessageSpendLimitOverrideResult' => [ 'base' => NULL, 'refs' => [], ], 'SnsDestination' => [ 'base' => '<p>An object that defines an Amazon SNS destination for events. You can use Amazon SNS to send notification when certain events occur.</p>', 'refs' => [ 'CreateEventDestinationRequest$SnsDestination' => '<p>An object that contains information about an event destination for logging to Amazon SNS.</p>', 'EventDestination$SnsDestination' => '<p>An object that contains information about an event destination that sends logging events to Amazon SNS.</p>', 'UpdateEventDestinationRequest$SnsDestination' => '<p>An object that contains information about an event destination that sends data to Amazon SNS.</p>', ], ], 'SnsTopicArn' => [ 'base' => NULL, 'refs' => [ 'SnsDestination$TopicArn' => '<p>The Amazon Resource Name (ARN) of the Amazon SNS topic that you want to publish events to.</p>', ], ], 'SpendLimit' => [ 'base' => '<p>Describes the current Amazon Pinpoint monthly spend limits for sending voice and text messages. For more information on increasing your monthly spend limit, see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-awssupport-spend-threshold.html"> Requesting increases to your monthly SMS spending quota for Amazon Pinpoint </a> in the <i>Amazon Pinpoint User Guide</i>. </p>', 'refs' => [ 'SpendLimitList$member' => NULL, ], ], 'SpendLimitList' => [ 'base' => NULL, 'refs' => [ 'DescribeSpendLimitsResult$SpendLimits' => '<p>An array of SpendLimit objects that contain the details for the requested spend limits.</p>', ], ], 'SpendLimitName' => [ 'base' => NULL, 'refs' => [ 'SpendLimit$Name' => '<p>The name for the SpendLimit.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => NULL, 'AccountAttribute$Value' => '<p>The value associated with the account attribute name.</p>', 'AssociateOriginationIdentityResult$PoolArn' => '<p>The Amazon Resource Name (ARN) of the pool that is now associated with the origination identity.</p>', 'AssociateOriginationIdentityResult$PoolId' => '<p>The PoolId of the pool that is now associated with the origination identity.</p>', 'AssociateOriginationIdentityResult$OriginationIdentityArn' => '<p>The PhoneNumberArn or SenderIdArn of the origination identity.</p>', 'AssociateOriginationIdentityResult$OriginationIdentity' => '<p>The PhoneNumberId or SenderId of the origination identity.</p>', 'AssociateProtectConfigurationResult$ConfigurationSetArn' => '<p>The Amazon Resource Name (ARN) of the configuration set.</p>', 'ConfigurationSetInformation$ConfigurationSetArn' => '<p>The Resource Name (ARN) of the ConfigurationSet.</p>', 'ConflictException$Message' => NULL, 'ConflictException$ResourceId' => '<p>The unique identifier of the request.</p>', 'CreateConfigurationSetResult$ConfigurationSetArn' => '<p>The Amazon Resource Name (ARN) of the newly created configuration set.</p>', 'CreateEventDestinationResult$ConfigurationSetArn' => '<p>The ARN of the configuration set.</p>', 'CreateOptOutListResult$OptOutListArn' => '<p>The Amazon Resource Name (ARN) for the OptOutList.</p>', 'CreatePoolResult$PoolArn' => '<p>The Amazon Resource Name (ARN) for the pool.</p>', 'CreatePoolResult$PoolId' => '<p>The unique identifier for the pool.</p>', 'CreateRegistrationAssociationResult$RegistrationArn' => '<p>The Amazon Resource Name (ARN) for the registration.</p>', 'CreateRegistrationAssociationResult$RegistrationId' => '<p>The unique identifier for the registration.</p>', 'CreateRegistrationAssociationResult$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the origination identity that is associated with the registration. </p>', 'CreateRegistrationAssociationResult$ResourceId' => '<p>The unique identifier for the origination identity. For example this could be a <b>PhoneNumberId</b> or <b>SenderId</b>.</p>', 'CreateRegistrationAssociationResult$ResourceType' => '<p>The registration type or origination identity type.</p>', 'CreateRegistrationAttachmentResult$RegistrationAttachmentArn' => '<p>The Amazon Resource Name (ARN) for the registration attachment.</p>', 'CreateRegistrationAttachmentResult$RegistrationAttachmentId' => '<p>The unique identifier for the registration attachment.</p>', 'CreateRegistrationResult$RegistrationArn' => '<p>The Amazon Resource Name (ARN) for the registration.</p>', 'CreateRegistrationResult$RegistrationId' => '<p>The unique identifier for the registration.</p>', 'CreateRegistrationVersionResult$RegistrationArn' => '<p>The Amazon Resource Name (ARN) for the registration.</p>', 'CreateRegistrationVersionResult$RegistrationId' => '<p>The unique identifier for the registration.</p>', 'CreateVerifiedDestinationNumberResult$VerifiedDestinationNumberArn' => '<p>The Amazon Resource Name (ARN) for the verified destination phone number.</p>', 'CreateVerifiedDestinationNumberResult$VerifiedDestinationNumberId' => '<p>The unique identifier for the verified destination phone number.</p>', 'DeleteConfigurationSetResult$ConfigurationSetArn' => '<p>The Amazon Resource Name (ARN) of the deleted configuration set.</p>', 'DeleteDefaultMessageTypeResult$ConfigurationSetArn' => '<p>The Amazon Resource Name (ARN) of the configuration set.</p>', 'DeleteDefaultSenderIdResult$ConfigurationSetArn' => '<p>The Amazon Resource Name (ARN) of the configuration set.</p>', 'DeleteEventDestinationResult$ConfigurationSetArn' => '<p>The Amazon Resource Name (ARN) of the configuration set.</p>', 'DeleteKeywordResult$OriginationIdentityArn' => '<p>The PhoneNumberArn or PoolArn that the keyword was associated with.</p>', 'DeleteKeywordResult$OriginationIdentity' => '<p>The PhoneNumberId or PoolId that the keyword was associated with.</p>', 'DeleteOptOutListResult$OptOutListArn' => '<p>The Amazon Resource Name (ARN) of the OptOutList that was removed.</p>', 'DeleteOptedOutNumberResult$OptOutListArn' => '<p>The OptOutListArn that the phone number was removed from.</p>', 'DeletePoolResult$PoolArn' => '<p>The Amazon Resource Name (ARN) of the pool that was deleted.</p>', 'DeletePoolResult$PoolId' => '<p>The PoolId of the pool that was deleted.</p>', 'DeleteRegistrationAttachmentResult$RegistrationAttachmentArn' => '<p>The Amazon Resource Name (ARN) for the registration attachment.</p>', 'DeleteRegistrationAttachmentResult$RegistrationAttachmentId' => '<p>The unique identifier for the registration attachment.</p>', 'DeleteRegistrationFieldValueResult$RegistrationArn' => '<p>The Amazon Resource Name (ARN) for the registration.</p>', 'DeleteRegistrationFieldValueResult$RegistrationId' => '<p>The unique identifier for the registration.</p>', 'DeleteRegistrationFieldValueResult$RegistrationAttachmentId' => '<p>The unique identifier for the registration attachment.</p>', 'DeleteRegistrationResult$RegistrationArn' => '<p>The Amazon Resource Name (ARN) for the registration.</p>', 'DeleteRegistrationResult$RegistrationId' => '<p>The unique identifier for the registration.</p>', 'DeleteVerifiedDestinationNumberResult$VerifiedDestinationNumberArn' => '<p>The Amazon Resource Name (ARN) for the verified destination phone number.</p>', 'DeleteVerifiedDestinationNumberResult$VerifiedDestinationNumberId' => '<p>The unique identifier for the verified destination phone number.</p>', 'DescribeKeywordsResult$OriginationIdentityArn' => '<p>The PhoneNumberArn or PoolArn that is associated with the OriginationIdentity. </p>', 'DescribeKeywordsResult$OriginationIdentity' => '<p>The PhoneNumberId or PoolId that is associated with the OriginationIdentity.</p>', 'DescribeOptedOutNumbersResult$OptOutListArn' => '<p>The Amazon Resource Name (ARN) of the OptOutList.</p>', 'DescribeRegistrationFieldValuesResult$RegistrationArn' => '<p>The Amazon Resource Name (ARN) for the registration.</p>', 'DescribeRegistrationFieldValuesResult$RegistrationId' => '<p>The unique identifier for the registration.</p>', 'DescribeRegistrationVersionsResult$RegistrationArn' => '<p>The Amazon Resource Name (ARN) for the registration.</p>', 'DescribeRegistrationVersionsResult$RegistrationId' => '<p>The unique identifier for the registration.</p>', 'DisassociateOriginationIdentityResult$PoolArn' => '<p>The Amazon Resource Name (ARN) of the pool.</p>', 'DisassociateOriginationIdentityResult$PoolId' => '<p>The PoolId of the pool no longer associated with the origination identity.</p>', 'DisassociateOriginationIdentityResult$OriginationIdentityArn' => '<p>The PhoneNumberArn or SenderIdArn of the origination identity.</p>', 'DisassociateOriginationIdentityResult$OriginationIdentity' => '<p>The PhoneNumberId or SenderId of the origination identity.</p>', 'DisassociateProtectConfigurationResult$ConfigurationSetArn' => '<p>The Amazon Resource Name (ARN) of the configuration set.</p>', 'DiscardRegistrationVersionResult$RegistrationArn' => '<p>The Amazon Resource Name (ARN) for the registration.</p>', 'DiscardRegistrationVersionResult$RegistrationId' => '<p>The unique identifier for the registration.</p>', 'InternalServerException$Message' => NULL, 'InternalServerException$RequestId' => '<p>The unique identifier of the request.</p>', 'ListPoolOriginationIdentitiesResult$PoolArn' => '<p>The Amazon Resource Name (ARN) for the pool.</p>', 'ListPoolOriginationIdentitiesResult$PoolId' => '<p>The unique PoolId of the pool.</p>', 'ListRegistrationAssociationsResult$RegistrationArn' => '<p>The Amazon Resource Name (ARN) for the registration.</p>', 'ListRegistrationAssociationsResult$RegistrationId' => '<p>The unique identifier for the registration.</p>', 'OptOutListInformation$OptOutListArn' => '<p>The Amazon Resource Name (ARN) of the OptOutList.</p>', 'OriginationIdentityMetadata$OriginationIdentityArn' => '<p>The Amazon Resource Name (ARN) associated with the origination identity.</p>', 'OriginationIdentityMetadata$OriginationIdentity' => '<p>The unique identifier of the origination identity.</p>', 'PhoneNumberInformation$PhoneNumberArn' => '<p>The Amazon Resource Name (ARN) associated with the phone number.</p>', 'PhoneNumberInformation$PhoneNumberId' => '<p>The unique identifier for the phone number.</p>', 'PhoneNumberInformation$MonthlyLeasingPrice' => '<p>The price, in US dollars, to lease the phone number.</p>', 'PhoneNumberInformation$PoolId' => '<p>The unique identifier of the pool associated with the phone number.</p>', 'PhoneNumberInformation$RegistrationId' => '<p>The unique identifier for the registration.</p>', 'PoolInformation$PoolArn' => '<p>The Amazon Resource Name (ARN) for the pool.</p>', 'PoolInformation$PoolId' => '<p>The unique identifier for the pool.</p>', 'PutKeywordResult$OriginationIdentityArn' => '<p>The PhoneNumberArn or PoolArn that the keyword was associated with.</p>', 'PutKeywordResult$OriginationIdentity' => '<p>The PhoneNumberId or PoolId that the keyword was associated with.</p>', 'PutOptedOutNumberResult$OptOutListArn' => '<p>The OptOutListArn that the phone number was removed from.</p>', 'PutRegistrationFieldValueResult$RegistrationArn' => '<p>The Amazon Resource Name (ARN) for the registration.</p>', 'PutRegistrationFieldValueResult$RegistrationId' => '<p>The unique identifier for the registration.</p>', 'PutRegistrationFieldValueResult$RegistrationAttachmentId' => '<p>The unique identifier for the registration attachment.</p>', 'RegistrationAssociationMetadata$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the origination identity that is associated with the registration. </p>', 'RegistrationAssociationMetadata$ResourceId' => '<p>The unique identifier for the origination identity. For example this could be a <b>PhoneNumberId</b> or <b>SenderId</b>.</p>', 'RegistrationAssociationMetadata$ResourceType' => '<p>The origination identity type.</p>', 'RegistrationAttachmentsInformation$RegistrationAttachmentArn' => '<p>The Amazon Resource Name (ARN) for the registration attachment.</p>', 'RegistrationAttachmentsInformation$RegistrationAttachmentId' => '<p>The unique identifier for the registration attachment.</p>', 'RegistrationDeniedReasonInformation$Reason' => '<p>The reason a registration was rejected.</p>', 'RegistrationDeniedReasonInformation$ShortDescription' => '<p>A short description of the rejection reason.</p>', 'RegistrationDeniedReasonInformation$LongDescription' => '<p>A long description of the rejection reason.</p>', 'RegistrationDeniedReasonInformation$DocumentationTitle' => '<p>The title of the document.</p>', 'RegistrationDeniedReasonInformation$DocumentationLink' => '<p>The link to the document.</p>', 'RegistrationFieldDisplayHints$Title' => '<p>The title of the display hint.</p>', 'RegistrationFieldDisplayHints$ShortDescription' => '<p>A short description of the display hint.</p>', 'RegistrationFieldDisplayHints$LongDescription' => '<p>A full description of the display hint.</p>', 'RegistrationFieldDisplayHints$DocumentationTitle' => '<p>The title of the document the display hint is associated with.</p>', 'RegistrationFieldDisplayHints$DocumentationLink' => '<p>The link to the document the display hint is associated with.</p>', 'RegistrationFieldDisplayHints$TextValidationDescription' => '<p>The validation rules for the text field.</p>', 'RegistrationFieldDisplayHints$ExampleTextValue' => '<p>Example text of what the value of a field should contain.</p>', 'RegistrationFieldValueInformation$DeniedReason' => '<p>A description of why the registration was denied.</p>', 'RegistrationInformation$RegistrationArn' => '<p>The Amazon Resource Name (ARN) for the registration.</p>', 'RegistrationInformation$RegistrationId' => '<p>The unique identifier for the registration.</p>', 'RegistrationSectionDisplayHints$Title' => '<p>The title of the display hint.</p>', 'RegistrationSectionDisplayHints$ShortDescription' => '<p>A short description of the display hint.</p>', 'RegistrationSectionDisplayHints$LongDescription' => '<p>A full description of the display hint.</p>', 'RegistrationSectionDisplayHints$DocumentationTitle' => '<p>The title of the document the display hint is associated with.</p>', 'RegistrationSectionDisplayHints$DocumentationLink' => '<p>The link to the document the display hint is associated with.</p>', 'RegistrationTypeDisplayHints$Title' => '<p>The title of the display hint.</p>', 'RegistrationTypeDisplayHints$ShortDescription' => '<p>A short description of the display hint.</p>', 'RegistrationTypeDisplayHints$LongDescription' => '<p>A full description of the display hint.</p>', 'RegistrationTypeDisplayHints$DocumentationTitle' => '<p>The title of the document the display hint is associated with.</p>', 'RegistrationTypeDisplayHints$DocumentationLink' => '<p>The link to the document the display hint is associated with.</p>', 'ReleasePhoneNumberResult$PhoneNumberArn' => '<p>The PhoneNumberArn of the phone number that was released.</p>', 'ReleasePhoneNumberResult$PhoneNumberId' => '<p>The PhoneNumberId of the phone number that was released.</p>', 'ReleasePhoneNumberResult$MonthlyLeasingPrice' => '<p>The monthly price of the phone number, in US dollars.</p>', 'ReleasePhoneNumberResult$RegistrationId' => '<p>The unique identifier for the registration.</p>', 'ReleaseSenderIdResult$SenderIdArn' => '<p>The Amazon Resource Name (ARN) associated with the SenderId.</p>', 'ReleaseSenderIdResult$MonthlyLeasingPrice' => '<p>The monthly price, in US dollars, to lease the sender ID.</p>', 'ReleaseSenderIdResult$RegistrationId' => '<p>The unique identifier for the registration.</p>', 'RequestPhoneNumberResult$PhoneNumberArn' => '<p>The Amazon Resource Name (ARN) of the requested phone number.</p>', 'RequestPhoneNumberResult$PhoneNumberId' => '<p>The unique identifier of the new phone number.</p>', 'RequestPhoneNumberResult$MonthlyLeasingPrice' => '<p>The monthly price, in US dollars, to lease the phone number.</p>', 'RequestPhoneNumberResult$PoolId' => '<p>The unique identifier of the pool associated with the phone number </p>', 'RequestPhoneNumberResult$RegistrationId' => '<p>The unique identifier for the registration.</p>', 'RequestSenderIdResult$SenderIdArn' => '<p>The Amazon Resource Name (ARN) associated with the SenderId.</p>', 'RequestSenderIdResult$MonthlyLeasingPrice' => '<p>The monthly price, in US dollars, to lease the sender ID.</p>', 'ResourceNotFoundException$Message' => NULL, 'ResourceNotFoundException$ResourceId' => '<p>The unique identifier of the resource.</p>', 'SelectOptionDescription$Option' => '<p>The value of the option.</p>', 'SelectOptionDescription$Title' => '<p>The title of the select option.</p>', 'SelectOptionDescription$Description' => '<p>A description of the option meaning.</p>', 'SendDestinationNumberVerificationCodeResult$MessageId' => '<p>The unique identifier for the message.</p>', 'SendMediaMessageResult$MessageId' => '<p>The unique identifier for the message.</p>', 'SendTextMessageResult$MessageId' => '<p>The unique identifier for the message.</p>', 'SendVoiceMessageResult$MessageId' => '<p>The unique identifier for the message.</p>', 'SenderIdInformation$SenderIdArn' => '<p>The Amazon Resource Name (ARN) associated with the SenderId.</p>', 'SenderIdInformation$MonthlyLeasingPrice' => '<p>The monthly leasing price, in US dollars.</p>', 'SenderIdInformation$RegistrationId' => '<p>The unique identifier for the registration.</p>', 'ServiceQuotaExceededException$Message' => NULL, 'SetDefaultMessageTypeResult$ConfigurationSetArn' => '<p>The Amazon Resource Name (ARN) of the updated configuration set.</p>', 'SetDefaultSenderIdResult$ConfigurationSetArn' => '<p>The Amazon Resource Name (ARN) of the updated configuration set.</p>', 'StringList$member' => NULL, 'StringMap$key' => NULL, 'StringMap$value' => NULL, 'SubmitRegistrationVersionResult$RegistrationArn' => '<p>The Amazon Resource Name (ARN) for the registration.</p>', 'SubmitRegistrationVersionResult$RegistrationId' => '<p>The unique identifier for the registration.</p>', 'SupportedAssociation$ResourceType' => '<p>Defines the behavior of when an origination identity and registration can be associated with each other.</p>', 'TextValidation$Pattern' => '<p>The regular expression used to validate the text field.</p>', 'ThrottlingException$Message' => NULL, 'UpdateEventDestinationResult$ConfigurationSetArn' => '<p>The Amazon Resource Name (ARN) for the ConfigurationSet that was updated.</p>', 'UpdatePhoneNumberResult$PhoneNumberArn' => '<p>The Amazon Resource Name (ARN) of the updated phone number.</p>', 'UpdatePhoneNumberResult$PhoneNumberId' => '<p>The unique identifier of the phone number.</p>', 'UpdatePhoneNumberResult$MonthlyLeasingPrice' => '<p>The monthly leasing price of the phone number, in US dollars.</p>', 'UpdatePhoneNumberResult$RegistrationId' => '<p>The unique identifier for the registration.</p>', 'UpdatePoolResult$PoolArn' => '<p>The ARN of the pool.</p>', 'UpdatePoolResult$PoolId' => '<p>The unique identifier of the pool.</p>', 'UpdateSenderIdResult$SenderIdArn' => '<p>The Amazon Resource Name (ARN) associated with the SenderId.</p>', 'UpdateSenderIdResult$MonthlyLeasingPrice' => '<p>The monthly price, in US dollars, to lease the sender ID.</p>', 'UpdateSenderIdResult$RegistrationId' => '<p>The unique identifier for the registration.</p>', 'ValidationException$Message' => NULL, 'ValidationExceptionField$Name' => '<p>The name of the field.</p>', 'ValidationExceptionField$Message' => '<p>The message associated with the validation exception with information to help determine its cause.</p>', 'VerifiedDestinationNumberInformation$VerifiedDestinationNumberArn' => '<p>The Amazon Resource Name (ARN) for the verified destination phone number.</p>', 'VerifiedDestinationNumberInformation$VerifiedDestinationNumberId' => '<p>The unique identifier for the verified destination phone number.</p>', 'VerifyDestinationNumberResult$VerifiedDestinationNumberArn' => '<p>The Amazon Resource Name (ARN) for the verified destination phone number.</p>', 'VerifyDestinationNumberResult$VerifiedDestinationNumberId' => '<p>The unique identifier for the verified destination phone number.</p>', ], ], 'StringList' => [ 'base' => NULL, 'refs' => [ 'SelectValidation$Options' => '<p>An array of strings for the possible selection options. </p>', ], ], 'StringMap' => [ 'base' => NULL, 'refs' => [ 'CreateRegistrationResult$AdditionalAttributes' => '<p>Metadata about a given registration which is specific to that registration type.</p>', 'DeleteRegistrationResult$AdditionalAttributes' => '<p>Metadata about a given registration which is specific to that registration type.</p>', 'RegistrationInformation$AdditionalAttributes' => '<p>Metadata about a given registration which is specific to that registration type.</p>', ], ], 'SubmitRegistrationVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'SubmitRegistrationVersionResult' => [ 'base' => NULL, 'refs' => [], ], 'SupportedAssociation' => [ 'base' => '<p>The processing rules for when a registration can be associated with an origination identity and disassociated from an origination identity.</p>', 'refs' => [ 'SupportedAssociationList$member' => NULL, ], ], 'SupportedAssociationList' => [ 'base' => NULL, 'refs' => [ 'RegistrationTypeDefinition$SupportedAssociations' => '<p>The supported association behavior for the registration type.</p>', ], ], 'Tag' => [ 'base' => '<p>The list of tags to be added to the specified topic.</p>', 'refs' => [ 'NonEmptyTagList$member' => NULL, 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The key identifier, or name, of the tag.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>An array of tag key values to unassociate with the resource.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateConfigurationSetRequest$Tags' => '<p>An array of key and value pair tags that\'s associated with the new configuration set. </p>', 'CreateConfigurationSetResult$Tags' => '<p>An array of key and value pair tags that\'s associated with the configuration set.</p>', 'CreateOptOutListRequest$Tags' => '<p>An array of tags (key and value pairs) to associate with the new OptOutList.</p>', 'CreateOptOutListResult$Tags' => '<p>An array of tags (key and value pairs) associated with the new OptOutList.</p>', 'CreatePoolRequest$Tags' => '<p>An array of tags (key and value pairs) associated with the pool.</p>', 'CreatePoolResult$Tags' => '<p>An array of tags (key and value pairs) associated with the pool.</p>', 'CreateProtectConfigurationRequest$Tags' => '<p>An array of key and value pair tags that are associated with the resource.</p>', 'CreateProtectConfigurationResult$Tags' => '<p>An array of key and value pair tags that are associated with the resource.</p>', 'CreateRegistrationAttachmentRequest$Tags' => '<p>An array of tags (key and value pairs) to associate with the registration attachment.</p>', 'CreateRegistrationAttachmentResult$Tags' => '<p>An array of tags (key and value pairs) to associate with the registration attachment.</p>', 'CreateRegistrationRequest$Tags' => '<p>An array of tags (key and value pairs) to associate with the registration.</p>', 'CreateRegistrationResult$Tags' => '<p>An array of tags (key and value pairs) to associate with the registration.</p>', 'CreateVerifiedDestinationNumberRequest$Tags' => '<p>An array of tags (key and value pairs) to associate with the destination number.</p>', 'CreateVerifiedDestinationNumberResult$Tags' => '<p>An array of tags (key and value pairs) to associate with the destination number.</p>', 'ListTagsForResourceResult$Tags' => '<p>An array of key and value pair tags that are associated with the resource.</p>', 'RequestPhoneNumberRequest$Tags' => '<p>An array of tags (key and value pairs) associate with the requested phone number. </p>', 'RequestPhoneNumberResult$Tags' => '<p>An array of key and value pair tags that are associated with the phone number.</p>', 'RequestSenderIdRequest$Tags' => '<p>An array of tags (key and value pairs) to associate with the sender ID.</p>', 'RequestSenderIdResult$Tags' => '<p>An array of tags (key and value pairs) to associate with the sender ID.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResult' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The string value associated with the key of the tag.</p>', ], ], 'TextMessageBody' => [ 'base' => NULL, 'refs' => [ 'SendMediaMessageRequest$MessageBody' => '<p>The text body of the message.</p>', 'SendTextMessageRequest$MessageBody' => '<p>The body of the text message.</p>', ], ], 'TextMessageOriginationIdentity' => [ 'base' => NULL, 'refs' => [ 'SendTextMessageRequest$OriginationIdentity' => '<p>The origination identity of the message. This can be either the PhoneNumber, PhoneNumberId, PhoneNumberArn, SenderId, SenderIdArn, PoolId, or PoolArn.</p>', ], ], 'TextValidation' => [ 'base' => '<p>Validation rules for a text field.</p>', 'refs' => [ 'RegistrationFieldDefinition$TextValidation' => '<p>The validation rules for a text field.</p>', ], ], 'TextValue' => [ 'base' => NULL, 'refs' => [ 'DeleteRegistrationFieldValueResult$TextValue' => '<p>The text data for a free form field.</p>', 'PutRegistrationFieldValueRequest$TextValue' => '<p>The text data for a free form field.</p>', 'PutRegistrationFieldValueResult$TextValue' => '<p>The text data for a free form field.</p>', 'RegistrationFieldValueInformation$TextValue' => '<p>The text data for a free form field.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>An error that occurred because too many requests were sent during a certain amount of time.</p>', 'refs' => [], ], 'TimeToLive' => [ 'base' => NULL, 'refs' => [ 'SendMediaMessageRequest$TimeToLive' => '<p>How long the text message is valid for. By default this is 72 hours.</p>', 'SendTextMessageRequest$TimeToLive' => '<p>How long the text message is valid for. By default this is 72 hours.</p>', 'SendVoiceMessageRequest$TimeToLive' => '<p>How long the voice message is valid for. By default this is 72 hours.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'ConfigurationSetInformation$CreatedTimestamp' => '<p>The time when the ConfigurationSet was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>', 'CreateConfigurationSetResult$CreatedTimestamp' => '<p>The time when the configuration set was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>', 'CreateOptOutListResult$CreatedTimestamp' => '<p>The time when the pool was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>', 'CreatePoolResult$CreatedTimestamp' => '<p>The time when the pool was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>', 'CreateProtectConfigurationResult$CreatedTimestamp' => '<p>The time when the protect configuration was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>', 'CreateRegistrationAttachmentResult$CreatedTimestamp' => '<p>The time when the registration attachment was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>', 'CreateRegistrationResult$CreatedTimestamp' => '<p>The time when the registration was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>', 'CreateVerifiedDestinationNumberResult$CreatedTimestamp' => '<p>The time when the verified phone number was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>', 'DeleteConfigurationSetResult$CreatedTimestamp' => '<p>The time that the deleted configuration set was created in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>', 'DeleteOptOutListResult$CreatedTimestamp' => '<p>The time when the OptOutList was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>', 'DeleteOptedOutNumberResult$OptedOutTimestamp' => '<p>The time that the number was removed at, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>', 'DeletePoolResult$CreatedTimestamp' => '<p>The time when the pool was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>', 'DeleteProtectConfigurationResult$CreatedTimestamp' => '<p>The time when the protect configuration was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>', 'DeleteRegistrationAttachmentResult$CreatedTimestamp' => '<p>The time when the registration attachment was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>', 'DeleteRegistrationResult$CreatedTimestamp' => '<p>The time when the registration was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>', 'DeleteVerifiedDestinationNumberResult$CreatedTimestamp' => '<p>The time when the destination phone number was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>', 'OptOutListInformation$CreatedTimestamp' => '<p>The time when the OutOutList was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>', 'OptedOutNumberInformation$OptedOutTimestamp' => '<p>The time that the op tout occurred, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>', 'PhoneNumberInformation$CreatedTimestamp' => '<p>The time when the phone number was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>', 'PoolInformation$CreatedTimestamp' => '<p>The time when the pool was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>', 'ProtectConfigurationInformation$CreatedTimestamp' => '<p>The time when the protect configuration was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>', 'PutOptedOutNumberResult$OptedOutTimestamp' => '<p>The time that the phone number was added to the OptOutList, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>', 'RegistrationAttachmentsInformation$CreatedTimestamp' => '<p>The time when the registration attachment was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>', 'RegistrationInformation$CreatedTimestamp' => '<p>The time when the registration was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>', 'RegistrationVersionStatusHistory$DraftTimestamp' => '<p>The time when the registration was in the draft state, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>', 'RegistrationVersionStatusHistory$SubmittedTimestamp' => '<p>The time when the registration was in the submitted state, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>', 'RegistrationVersionStatusHistory$ReviewingTimestamp' => '<p>The time when the registration was in the reviewing state, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>', 'RegistrationVersionStatusHistory$ApprovedTimestamp' => '<p>The time when the registration was in the approved state, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>', 'RegistrationVersionStatusHistory$DiscardedTimestamp' => '<p>The time when the registration was in the discarded state, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>', 'RegistrationVersionStatusHistory$DeniedTimestamp' => '<p>The time when the registration was in the denied state, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>', 'RegistrationVersionStatusHistory$RevokedTimestamp' => '<p>The time when the registration was in the revoked state, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>', 'RegistrationVersionStatusHistory$ArchivedTimestamp' => '<p>The time when the registration was in the archived state, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>', 'ReleasePhoneNumberResult$CreatedTimestamp' => '<p>The time when the phone number was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>', 'RequestPhoneNumberResult$CreatedTimestamp' => '<p>The time when the phone number was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>', 'UpdatePhoneNumberResult$CreatedTimestamp' => '<p>The time when the phone number was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>', 'UpdatePoolResult$CreatedTimestamp' => '<p>The time when the pool was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>', 'UpdateProtectConfigurationResult$CreatedTimestamp' => '<p>The time when the protect configuration was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>', 'VerifiedDestinationNumberInformation$CreatedTimestamp' => '<p>The time when the destination phone number was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>', 'VerifyDestinationNumberResult$CreatedTimestamp' => '<p>The time when the destination phone number was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>', ], ], 'TwoWayChannelArn' => [ 'base' => NULL, 'refs' => [ 'CreatePoolResult$TwoWayChannelArn' => '<p>The Amazon Resource Name (ARN) of the two way channel.</p>', 'DeletePoolResult$TwoWayChannelArn' => '<p>The Amazon Resource Name (ARN) of the TwoWayChannel.</p>', 'PhoneNumberInformation$TwoWayChannelArn' => '<p>The Amazon Resource Name (ARN) of the two way channel.</p>', 'PoolInformation$TwoWayChannelArn' => '<p>The Amazon Resource Name (ARN) of the two way channel.</p>', 'ReleasePhoneNumberResult$TwoWayChannelArn' => '<p>The Amazon Resource Name (ARN) of the TwoWayChannel.</p>', 'RequestPhoneNumberResult$TwoWayChannelArn' => '<p>The ARN used to identify the two way channel.</p>', 'UpdatePhoneNumberRequest$TwoWayChannelArn' => '<p>The Amazon Resource Name (ARN) of the two way channel.</p>', 'UpdatePhoneNumberResult$TwoWayChannelArn' => '<p>The Amazon Resource Name (ARN) of the two way channel.</p>', 'UpdatePoolRequest$TwoWayChannelArn' => '<p>The Amazon Resource Name (ARN) of the two way channel.</p>', 'UpdatePoolResult$TwoWayChannelArn' => '<p>The Amazon Resource Name (ARN) of the two way channel.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEventDestinationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEventDestinationResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePhoneNumberRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePhoneNumberResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePoolRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePoolResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateProtectConfigurationCountryRuleSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateProtectConfigurationCountryRuleSetResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateProtectConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateProtectConfigurationResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSenderIdRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSenderIdResult' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>A validation exception for a field.</p>', 'refs' => [], ], 'ValidationExceptionField' => [ 'base' => '<p>The field associated with the validation exception.</p>', 'refs' => [ 'ValidationExceptionFieldList$member' => NULL, ], ], 'ValidationExceptionFieldList' => [ 'base' => NULL, 'refs' => [ 'ValidationException$Fields' => '<p>The field that failed validation.</p>', ], ], 'ValidationExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ValidationException$Reason' => '<p>The reason for the exception.</p>', ], ], 'VerificationChannel' => [ 'base' => NULL, 'refs' => [ 'SendDestinationNumberVerificationCodeRequest$VerificationChannel' => '<p>Choose to send the verification code as an SMS or voice message.</p>', ], ], 'VerificationCode' => [ 'base' => NULL, 'refs' => [ 'VerifyDestinationNumberRequest$VerificationCode' => '<p>The verification code that was received by the verified destination phone number.</p>', ], ], 'VerificationMessageOriginationIdentity' => [ 'base' => NULL, 'refs' => [ 'SendDestinationNumberVerificationCodeRequest$OriginationIdentity' => '<p>The origination identity of the message. This can be either the PhoneNumber, PhoneNumberId, PhoneNumberArn, SenderId, SenderIdArn, PoolId, or PoolArn.</p>', ], ], 'VerificationStatus' => [ 'base' => NULL, 'refs' => [ 'CreateVerifiedDestinationNumberResult$Status' => '<p>The status of the verified destination phone number.</p> <ul> <li> <p> <code>PENDING</code>: The phone number hasn\'t been verified yet.</p> </li> <li> <p> <code>VERIFIED</code>: The phone number is verified and can receive messages.</p> </li> </ul>', 'VerifiedDestinationNumberInformation$Status' => '<p>The status of the verified destination phone number.</p> <ul> <li> <p> <code>PENDING</code>: The phone number hasn\'t been verified yet.</p> </li> <li> <p> <code>VERIFIED</code>: The phone number is verified and can receive messages.</p> </li> </ul>', 'VerifyDestinationNumberResult$Status' => '<p>The status for being able to send messages to the phone number.</p>', ], ], 'VerifiedDestinationNumberFilter' => [ 'base' => '<p>The filter definition for filtering verified destination phone numbers that meets a specified criteria.</p>', 'refs' => [ 'VerifiedDestinationNumberFilterList$member' => NULL, ], ], 'VerifiedDestinationNumberFilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeVerifiedDestinationNumbersRequest$Filters' => '<p>An array of VerifiedDestinationNumberFilter objects to filter the results.</p>', ], ], 'VerifiedDestinationNumberFilterName' => [ 'base' => NULL, 'refs' => [ 'VerifiedDestinationNumberFilter$Name' => '<p>The name of the attribute to filter on.</p>', ], ], 'VerifiedDestinationNumberIdList' => [ 'base' => NULL, 'refs' => [ 'DescribeVerifiedDestinationNumbersRequest$VerifiedDestinationNumberIds' => '<p>An array of VerifiedDestinationNumberid to retreive.</p>', ], ], 'VerifiedDestinationNumberIdOrArn' => [ 'base' => NULL, 'refs' => [ 'DeleteVerifiedDestinationNumberRequest$VerifiedDestinationNumberId' => '<p>The unique identifier for the verified destination phone number.</p>', 'SendDestinationNumberVerificationCodeRequest$VerifiedDestinationNumberId' => '<p>The unique identifier for the verified destination phone number.</p>', 'VerifiedDestinationNumberIdList$member' => NULL, 'VerifyDestinationNumberRequest$VerifiedDestinationNumberId' => '<p>The unique identifier for the verififed destination phone number.</p>', ], ], 'VerifiedDestinationNumberInformation' => [ 'base' => '<p>Provides information about the requested verified destintion phone number.</p>', 'refs' => [ 'VerifiedDestinationNumberInformationList$member' => NULL, ], ], 'VerifiedDestinationNumberInformationList' => [ 'base' => NULL, 'refs' => [ 'DescribeVerifiedDestinationNumbersResult$VerifiedDestinationNumbers' => '<p>An array of VerifiedDestinationNumberInformation objects</p>', ], ], 'VerifyDestinationNumberRequest' => [ 'base' => NULL, 'refs' => [], ], 'VerifyDestinationNumberResult' => [ 'base' => NULL, 'refs' => [], ], 'VoiceId' => [ 'base' => NULL, 'refs' => [ 'SendVoiceMessageRequest$VoiceId' => '<p>The voice for the <a href="https://docs.aws.amazon.com/polly/latest/dg/what-is.html">Amazon Polly</a> service to use. By default this is set to "MATTHEW".</p>', ], ], 'VoiceMessageBody' => [ 'base' => NULL, 'refs' => [ 'SendVoiceMessageRequest$MessageBody' => '<p>The text to convert to a voice message.</p>', ], ], 'VoiceMessageBodyTextType' => [ 'base' => NULL, 'refs' => [ 'SendVoiceMessageRequest$MessageBodyTextType' => '<p>Specifies if the MessageBody field contains text or <a href="https://docs.aws.amazon.com/polly/latest/dg/what-is.html">speech synthesis markup language (SSML)</a>.</p> <ul> <li> <p>TEXT: This is the default value. When used the maximum character limit is 3000.</p> </li> <li> <p>SSML: When used the maximum character limit is 6000 including SSML tagging.</p> </li> </ul>', ], ], 'VoiceMessageOriginationIdentity' => [ 'base' => NULL, 'refs' => [ 'SendVoiceMessageRequest$OriginationIdentity' => '<p>The origination identity to use for the voice call. This can be the PhoneNumber, PhoneNumberId, PhoneNumberArn, PoolId, or PoolArn.</p>', ], ], ],];
