<?php
// This file was auto-generated from sdk-root/src/data/ssm-sap/2018-05-10/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>This API reference provides descriptions, syntax, and other details about each of the actions and data types for AWS Systems Manager for SAP. The topic for each action shows the API request parameters and responses. </p>', 'operations' => [ 'DeleteResourcePermission' => '<p>Removes permissions associated with the target database.</p>', 'DeregisterApplication' => '<p>Deregister an SAP application with AWS Systems Manager for SAP. This action does not aﬀect the existing setup of your SAP workloads on Amazon EC2.</p>', 'GetApplication' => '<p>Gets an application registered with AWS Systems Manager for SAP. It also returns the components of the application.</p>', 'GetComponent' => '<p>Gets the component of an application registered with AWS Systems Manager for SAP.</p>', 'GetDatabase' => '<p>Gets the SAP HANA database of an application registered with AWS Systems Manager for SAP.</p>', 'GetOperation' => '<p>Gets the details of an operation by specifying the operation ID.</p>', 'GetResourcePermission' => '<p>Gets permissions associated with the target database.</p>', 'ListApplications' => '<p>Lists all the applications registered with AWS Systems Manager for SAP.</p>', 'ListComponents' => '<p>Lists all the components registered with AWS Systems Manager for SAP.</p>', 'ListDatabases' => '<p>Lists the SAP HANA databases of an application registered with AWS Systems Manager for SAP.</p>', 'ListOperationEvents' => '<p>Returns a list of operations events.</p> <p>Available parameters include <code>OperationID</code>, as well as optional parameters <code>MaxResults</code>, <code>NextToken</code>, and <code>Filters</code>.</p>', 'ListOperations' => '<p>Lists the operations performed by AWS Systems Manager for SAP.</p>', 'ListTagsForResource' => '<p>Lists all tags on an SAP HANA application and/or database registered with AWS Systems Manager for SAP.</p>', 'PutResourcePermission' => '<p>Adds permissions to the target database.</p>', 'RegisterApplication' => '<p>Register an SAP application with AWS Systems Manager for SAP. You must meet the following requirements before registering. </p> <p>The SAP application you want to register with AWS Systems Manager for SAP is running on Amazon EC2.</p> <p>AWS Systems Manager Agent must be setup on an Amazon EC2 instance along with the required IAM permissions.</p> <p>Amazon EC2 instance(s) must have access to the secrets created in AWS Secrets Manager to manage SAP applications and components.</p>', 'StartApplication' => '<p>Request is an operation which starts an application.</p> <p>Parameter <code>ApplicationId</code> is required.</p>', 'StartApplicationRefresh' => '<p>Refreshes a registered application.</p>', 'StopApplication' => '<p>Request is an operation to stop an application.</p> <p>Parameter <code>ApplicationId</code> is required. Parameters <code>StopConnectedEntity</code> and <code>IncludeEc2InstanceShutdown</code> are optional.</p>', 'TagResource' => '<p>Creates tag for a resource by specifying the ARN.</p>', 'UntagResource' => '<p>Delete the tags for a resource.</p>', 'UpdateApplicationSettings' => '<p>Updates the settings of an application registered with AWS Systems Manager for SAP.</p>', ], 'shapes' => [ 'AllocationType' => [ 'base' => NULL, 'refs' => [ 'IpAddressMember$AllocationType' => '<p>The type of allocation for the IP address.</p>', ], ], 'AppRegistryArn' => [ 'base' => NULL, 'refs' => [ 'Application$AppRegistryArn' => '<p>The Amazon Resource Name (ARN) of the Application Registry.</p>', 'GetApplicationInput$AppRegistryArn' => '<p>The Amazon Resource Name (ARN) of the application registry.</p>', ], ], 'Application' => [ 'base' => '<p>An SAP application registered with AWS Systems Manager for SAP.</p>', 'refs' => [ 'GetApplicationOutput$Application' => '<p>Returns all of the metadata of an application registered with AWS Systems Manager for SAP.</p>', 'RegisterApplicationOutput$Application' => '<p>The application registered with AWS Systems Manager for SAP.</p>', ], ], 'ApplicationCredential' => [ 'base' => '<p>The credentials of your SAP application.</p>', 'refs' => [ 'ApplicationCredentialList$member' => NULL, ], ], 'ApplicationCredentialList' => [ 'base' => NULL, 'refs' => [ 'Database$Credentials' => '<p>The credentials of the database.</p>', 'RegisterApplicationInput$Credentials' => '<p>The credentials of the SAP application.</p>', 'UpdateApplicationSettingsInput$CredentialsToAddOrUpdate' => '<p>The credentials to be added or updated.</p>', 'UpdateApplicationSettingsInput$CredentialsToRemove' => '<p>The credentials to be removed.</p>', ], ], 'ApplicationDiscoveryStatus' => [ 'base' => NULL, 'refs' => [ 'Application$DiscoveryStatus' => '<p>The latest discovery result for the application.</p>', 'ApplicationSummary$DiscoveryStatus' => '<p>The status of the latest discovery.</p>', ], ], 'ApplicationId' => [ 'base' => NULL, 'refs' => [ 'Application$Id' => '<p>The ID of the application.</p>', 'ApplicationSummary$Id' => '<p>The ID of the application.</p>', 'Component$ApplicationId' => '<p>The ID of the application.</p>', 'ComponentSummary$ApplicationId' => '<p>The ID of the application.</p>', 'Database$ApplicationId' => '<p>The ID of the application.</p>', 'DatabaseSummary$ApplicationId' => '<p>The ID of the application.</p>', 'DeregisterApplicationInput$ApplicationId' => '<p>The ID of the application.</p>', 'GetApplicationInput$ApplicationId' => '<p>The ID of the application.</p>', 'GetComponentInput$ApplicationId' => '<p>The ID of the application.</p>', 'GetDatabaseInput$ApplicationId' => '<p>The ID of the application.</p>', 'ListComponentsInput$ApplicationId' => '<p>The ID of the application.</p>', 'ListDatabasesInput$ApplicationId' => '<p>The ID of the application.</p>', 'ListOperationsInput$ApplicationId' => '<p>The ID of the application.</p>', 'RegisterApplicationInput$ApplicationId' => '<p>The ID of the application.</p>', 'StartApplicationInput$ApplicationId' => '<p>The ID of the application.</p>', 'StartApplicationRefreshInput$ApplicationId' => '<p>The ID of the application.</p>', 'StopApplicationInput$ApplicationId' => '<p>The ID of the application.</p>', 'UpdateApplicationSettingsInput$ApplicationId' => '<p>The ID of the application.</p>', ], ], 'ApplicationStatus' => [ 'base' => NULL, 'refs' => [ 'Application$Status' => '<p>The status of the application.</p>', ], ], 'ApplicationSummary' => [ 'base' => '<p>The summary of the SAP application registered with AWS Systems Manager for SAP. </p>', 'refs' => [ 'ApplicationSummaryList$member' => NULL, ], ], 'ApplicationSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListApplicationsOutput$Applications' => '<p>The applications registered with AWS Systems Manager for SAP.</p>', ], ], 'ApplicationType' => [ 'base' => NULL, 'refs' => [ 'Application$Type' => '<p>The type of the application.</p>', 'ApplicationSummary$Type' => '<p>The type of the application.</p>', 'RegisterApplicationInput$ApplicationType' => '<p>The type of the application.</p>', ], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'DeleteResourcePermissionInput$SourceResourceArn' => '<p>The Amazon Resource Name (ARN) of the source resource.</p>', 'DeleteResourcePermissionInput$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'GetResourcePermissionInput$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'Operation$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the operation.</p>', 'PutResourcePermissionInput$SourceResourceArn' => '<p/>', 'PutResourcePermissionInput$ResourceArn' => '<p/>', 'Resource$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the source resource.</p> <p>Example of <code>ResourceArn</code>: "<code>arn:aws:ec2:us-east-1:111111111111:instance/i-abcdefgh987654321</code>"</p>', ], ], 'AssociatedHost' => [ 'base' => '<p>Describes the properties of the associated host.</p>', 'refs' => [ 'Component$AssociatedHost' => '<p>The associated host of the component.</p>', ], ], 'BackintConfig' => [ 'base' => '<p>Configuration parameters for AWS Backint Agent for SAP HANA. You can backup your SAP HANA database with AWS Backup or Amazon S3.</p>', 'refs' => [ 'UpdateApplicationSettingsInput$Backint' => '<p>Installation of AWS Backint Agent for SAP HANA.</p>', ], ], 'BackintMode' => [ 'base' => NULL, 'refs' => [ 'BackintConfig$BackintMode' => '<p>AWS service for your database backup.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'BackintConfig$EnsureNoBackupInProcess' => '<p/>', 'IpAddressMember$Primary' => '<p>The primary IP address.</p>', 'Resilience$EnqueueReplication' => '<p>Indicates if or not enqueue replication is enabled for the ASCS component.</p>', 'StopApplicationInput$IncludeEc2InstanceShutdown' => '<p>Boolean. If included and if set to <code>True</code>, the StopApplication operation will shut down the associated Amazon EC2 instance in addition to the application.</p>', ], ], 'ClusterStatus' => [ 'base' => NULL, 'refs' => [ 'Resilience$ClusterStatus' => '<p>The cluster status of the component.</p>', ], ], 'Component' => [ 'base' => '<p>The SAP component of your application.</p>', 'refs' => [ 'GetComponentOutput$Component' => '<p>The component of an application registered with AWS Systems Manager for SAP.</p>', ], ], 'ComponentId' => [ 'base' => NULL, 'refs' => [ 'Component$ComponentId' => '<p>The ID of the component.</p>', 'Component$ParentComponent' => '<p>The parent component of a highly available environment. For example, in a highly available SAP on AWS workload, the parent component consists of the entire setup, including the child components.</p>', 'ComponentIdList$member' => NULL, 'ComponentSummary$ComponentId' => '<p>The ID of the component.</p>', 'Database$ComponentId' => '<p>The ID of the component.</p>', 'DatabaseSummary$ComponentId' => '<p>The ID of the component.</p>', 'GetComponentInput$ComponentId' => '<p>The ID of the component.</p>', 'GetDatabaseInput$ComponentId' => '<p>The ID of the component.</p>', 'ListDatabasesInput$ComponentId' => '<p>The ID of the component.</p>', ], ], 'ComponentIdList' => [ 'base' => NULL, 'refs' => [ 'Application$Components' => '<p>The components of the application.</p>', 'Component$ChildComponents' => '<p>The child components of a highly available environment. For example, in a highly available SAP on AWS workload, the child component consists of the primary and secondar instances.</p>', ], ], 'ComponentStatus' => [ 'base' => NULL, 'refs' => [ 'Component$Status' => '<p>The status of the component.</p> <ul> <li> <p>ACTIVATED - this status has been deprecated.</p> </li> <li> <p>STARTING - the component is in the process of being started.</p> </li> <li> <p>STOPPED - the component is not running.</p> </li> <li> <p>STOPPING - the component is in the process of being stopped.</p> </li> <li> <p>RUNNING - the component is running.</p> </li> <li> <p>RUNNING_WITH_ERROR - one or more child component(s) of the parent component is not running. Call <a href="https://docs.aws.amazon.com/ssmsap/latest/APIReference/API_GetComponent.html"> <code>GetComponent</code> </a> to review the status of each child component.</p> </li> <li> <p>UNDEFINED - AWS Systems Manager for SAP cannot provide the component status based on the discovered information. Verify your SAP application.</p> </li> </ul>', ], ], 'ComponentSummary' => [ 'base' => '<p>The summary of the component.</p>', 'refs' => [ 'ComponentSummaryList$member' => NULL, ], ], 'ComponentSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListComponentsOutput$Components' => '<p>List of components registered with AWS System Manager for SAP.</p>', ], ], 'ComponentType' => [ 'base' => NULL, 'refs' => [ 'Component$ComponentType' => '<p>The type of the component.</p>', 'ComponentSummary$ComponentType' => '<p>The type of the component.</p>', ], ], 'ConflictException' => [ 'base' => '<p>A conflict has occurred.</p>', 'refs' => [], ], 'ConnectedEntityType' => [ 'base' => NULL, 'refs' => [ 'StopApplicationInput$StopConnectedEntity' => '<p>Specify the <code>ConnectedEntityType</code>. Accepted type is <code>DBMS</code>.</p> <p>If this parameter is included, the connected DBMS (Database Management System) will be stopped.</p>', ], ], 'CredentialType' => [ 'base' => NULL, 'refs' => [ 'ApplicationCredential$CredentialType' => '<p>The type of the application credentials. </p>', ], ], 'Database' => [ 'base' => '<p>The SAP HANA database of the application registered with AWS Systems Manager for SAP.</p>', 'refs' => [ 'GetDatabaseOutput$Database' => '<p>The SAP HANA database of an application registered with AWS Systems Manager for SAP.</p>', ], ], 'DatabaseConnection' => [ 'base' => '<p>The connection specifications for the database.</p>', 'refs' => [ 'Component$DatabaseConnection' => '<p>The connection specifications for the database of the component.</p>', ], ], 'DatabaseConnectionMethod' => [ 'base' => NULL, 'refs' => [ 'DatabaseConnection$DatabaseConnectionMethod' => '<p>The method of connection.</p>', ], ], 'DatabaseId' => [ 'base' => NULL, 'refs' => [ 'Database$DatabaseId' => '<p>The ID of the SAP HANA database.</p>', 'DatabaseIdList$member' => NULL, 'DatabaseSummary$DatabaseId' => '<p>The ID of the database.</p>', 'GetDatabaseInput$DatabaseId' => '<p>The ID of the database.</p>', ], ], 'DatabaseIdList' => [ 'base' => NULL, 'refs' => [ 'Component$Databases' => '<p>The SAP HANA databases of the component.</p>', ], ], 'DatabaseName' => [ 'base' => NULL, 'refs' => [ 'ApplicationCredential$DatabaseName' => '<p>The name of the SAP HANA database.</p>', ], ], 'DatabaseStatus' => [ 'base' => NULL, 'refs' => [ 'Database$Status' => '<p>The status of the database.</p>', ], ], 'DatabaseSummary' => [ 'base' => '<p>The summary of the database.</p>', 'refs' => [ 'DatabaseSummaryList$member' => NULL, ], ], 'DatabaseSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListDatabasesOutput$Databases' => '<p>The SAP HANA databases of an application.</p>', ], ], 'DatabaseType' => [ 'base' => NULL, 'refs' => [ 'Database$DatabaseType' => '<p>The type of the database.</p>', 'DatabaseSummary$DatabaseType' => '<p>The type of the database.</p>', ], ], 'DeleteResourcePermissionInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResourcePermissionOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterApplicationInput' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterApplicationOutput' => [ 'base' => NULL, 'refs' => [], ], 'Filter' => [ 'base' => '<p>A specific result obtained by specifying the name, value, and operator. </p>', 'refs' => [ 'FilterList$member' => NULL, ], ], 'FilterList' => [ 'base' => NULL, 'refs' => [ 'ListApplicationsInput$Filters' => '<p>The filter of name, value, and operator.</p>', 'ListOperationEventsInput$Filters' => '<p>Optionally specify filters to narrow the returned operation event items.</p> <p>Valid filter names include <code>status</code>, <code>resourceID</code>, and <code>resourceType</code>. The valid operator for all three filters is <code>Equals</code>.</p>', 'ListOperationsInput$Filters' => '<p>The filters of an operation.</p>', ], ], 'FilterName' => [ 'base' => NULL, 'refs' => [ 'Filter$Name' => '<p>The name of the filter. Filter names are case-sensitive. </p>', ], ], 'FilterOperator' => [ 'base' => NULL, 'refs' => [ 'Filter$Operator' => '<p>The operator for the filter. </p>', ], ], 'FilterValue' => [ 'base' => NULL, 'refs' => [ 'Filter$Value' => '<p>The filter values. Filter values are case-sensitive. If you specify multiple values for a filter, the values are joined with an OR, and the request returns all results that match any of the specified values</p>', ], ], 'GetApplicationInput' => [ 'base' => NULL, 'refs' => [], ], 'GetApplicationOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetComponentInput' => [ 'base' => NULL, 'refs' => [], ], 'GetComponentOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetDatabaseInput' => [ 'base' => NULL, 'refs' => [], ], 'GetDatabaseOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetOperationInput' => [ 'base' => NULL, 'refs' => [], ], 'GetOperationOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetResourcePermissionInput' => [ 'base' => NULL, 'refs' => [], ], 'GetResourcePermissionOutput' => [ 'base' => NULL, 'refs' => [], ], 'Host' => [ 'base' => '<p>Describes the properties of the Dedicated Host. </p>', 'refs' => [ 'HostList$member' => NULL, ], ], 'HostList' => [ 'base' => NULL, 'refs' => [ 'Component$Hosts' => '<p>The hosts of the component.</p>', ], ], 'HostRole' => [ 'base' => NULL, 'refs' => [ 'Host$HostRole' => '<p>The role of the Dedicated Host.</p>', ], ], 'InstanceId' => [ 'base' => NULL, 'refs' => [ 'InstanceList$member' => NULL, ], ], 'InstanceList' => [ 'base' => NULL, 'refs' => [ 'RegisterApplicationInput$Instances' => '<p>The Amazon EC2 instances on which your SAP application is running.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'Database$SQLPort' => '<p>The SQL port of the database.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>An internal error has occurred.</p>', 'refs' => [], ], 'IpAddressList' => [ 'base' => NULL, 'refs' => [ 'AssociatedHost$IpAddresses' => '<p>The IP addresses of the associated host.</p>', ], ], 'IpAddressMember' => [ 'base' => '<p>Provides information of the IP address.</p>', 'refs' => [ 'IpAddressList$member' => NULL, ], ], 'ListApplicationsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListApplicationsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListComponentsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListComponentsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListDatabasesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListDatabasesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListOperationEventsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListOperationEventsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListOperationsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListOperationsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListApplicationsInput$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value.</p>', 'ListComponentsInput$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value.</p> <p>If you do not specify a value for MaxResults, the request returns 50 items per page by default.</p>', 'ListDatabasesInput$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value. If you do not specify a value for MaxResults, the request returns 50 items per page by default.</p>', 'ListOperationEventsInput$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value.</p> <p>If you do not specify a value for <code>MaxResults</code>, the request returns 50 items per page by default.</p>', 'ListOperationsInput$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value. If you do not specify a value for MaxResults, the request returns 50 items per page by default.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListApplicationsInput$NextToken' => '<p>The token for the next page of results.</p>', 'ListApplicationsOutput$NextToken' => '<p>The token to use to retrieve the next page of results. This value is null when there are no more results to return.</p>', 'ListComponentsInput$NextToken' => '<p>The token for the next page of results.</p>', 'ListComponentsOutput$NextToken' => '<p>The token to use to retrieve the next page of results. This value is null when there are no more results to return.</p>', 'ListDatabasesInput$NextToken' => '<p>The token for the next page of results. </p>', 'ListDatabasesOutput$NextToken' => '<p>The token to use to retrieve the next page of results. This value is null when there are no more results to return.</p>', 'ListOperationEventsInput$NextToken' => '<p>The token to use to retrieve the next page of results. This value is null when there are no more results to return.</p>', 'ListOperationEventsOutput$NextToken' => '<p>The token to use to retrieve the next page of results. This value is null when there are no more results to return.</p>', 'ListOperationsInput$NextToken' => '<p>The token for the next page of results. </p>', 'ListOperationsOutput$NextToken' => '<p>The token to use to retrieve the next page of results. This value is null when there are no more results to return.</p>', ], ], 'Operation' => [ 'base' => '<p>The operations performed by AWS Systems Manager for SAP.</p>', 'refs' => [ 'GetOperationOutput$Operation' => '<p>Returns the details of an operation.</p>', 'OperationList$member' => NULL, ], ], 'OperationEvent' => [ 'base' => '<p>An operation event returns details for an operation, including key milestones which can be used to monitor and track operations in progress.</p> <p>Operation events contain:</p> <ul> <li> <p>Description string</p> </li> <li> <p>Resource, including its ARN and type</p> </li> <li> <p>Status</p> </li> <li> <p>StatusMessage string</p> </li> <li> <p>TimeStamp</p> </li> </ul> <p>Operation event examples include StartApplication or StopApplication.</p>', 'refs' => [ 'OperationEventList$member' => NULL, ], ], 'OperationEventList' => [ 'base' => NULL, 'refs' => [ 'ListOperationEventsOutput$OperationEvents' => '<p>A returned list of operation events that meet the filter criteria.</p>', ], ], 'OperationEventResourceType' => [ 'base' => NULL, 'refs' => [ 'Resource$ResourceType' => '<p>The resource type.</p> <p>Example of <code>ResourceType</code>: "<code>AWS::SystemsManagerSAP::Component</code>" or "<code>AWS::EC2::Instance</code>".</p>', ], ], 'OperationEventStatus' => [ 'base' => NULL, 'refs' => [ 'OperationEvent$Status' => '<p>The status of the operation event. The possible statuses are: <code>IN_PROGRESS</code>, <code>COMPLETED</code>, and <code>FAILED</code>.</p>', ], ], 'OperationId' => [ 'base' => NULL, 'refs' => [ 'GetOperationInput$OperationId' => '<p>The ID of the operation.</p>', 'ListOperationEventsInput$OperationId' => '<p>The ID of the operation.</p>', 'Operation$Id' => '<p>The ID of the operation.</p>', 'OperationIdList$member' => NULL, 'RegisterApplicationOutput$OperationId' => '<p>The ID of the operation.</p>', 'StartApplicationOutput$OperationId' => '<p>The ID of the operation.</p>', 'StartApplicationRefreshOutput$OperationId' => '<p>The ID of the operation.</p>', 'StopApplicationOutput$OperationId' => '<p>The ID of the operation.</p>', ], ], 'OperationIdList' => [ 'base' => NULL, 'refs' => [ 'UpdateApplicationSettingsOutput$OperationIds' => '<p>The IDs of the operations.</p>', ], ], 'OperationList' => [ 'base' => NULL, 'refs' => [ 'ListOperationsOutput$Operations' => '<p>List of operations performed by AWS Systems Manager for SAP.</p>', ], ], 'OperationMode' => [ 'base' => NULL, 'refs' => [ 'Resilience$HsrOperationMode' => '<p>The operation mode of the component.</p>', ], ], 'OperationProperties' => [ 'base' => NULL, 'refs' => [ 'Operation$Properties' => '<p>The properties of the operation.</p>', ], ], 'OperationStatus' => [ 'base' => NULL, 'refs' => [ 'Operation$Status' => '<p>The status of the operation.</p>', ], ], 'OperationType' => [ 'base' => NULL, 'refs' => [ 'Operation$Type' => '<p>The type of the operation.</p>', ], ], 'PermissionActionType' => [ 'base' => NULL, 'refs' => [ 'DeleteResourcePermissionInput$ActionType' => '<p>Delete or restore the permissions on the target database.</p>', 'GetResourcePermissionInput$ActionType' => '<p/>', 'PutResourcePermissionInput$ActionType' => '<p/>', ], ], 'PutResourcePermissionInput' => [ 'base' => NULL, 'refs' => [], ], 'PutResourcePermissionOutput' => [ 'base' => NULL, 'refs' => [], ], 'RegisterApplicationInput' => [ 'base' => NULL, 'refs' => [], ], 'RegisterApplicationOutput' => [ 'base' => NULL, 'refs' => [], ], 'ReplicationMode' => [ 'base' => NULL, 'refs' => [ 'Resilience$HsrReplicationMode' => '<p>The replication mode of the component.</p>', ], ], 'Resilience' => [ 'base' => '<p>Details of the SAP HANA system replication for the instance.</p>', 'refs' => [ 'Component$Resilience' => '<p>Details of the SAP HANA system replication for the component.</p>', ], ], 'Resource' => [ 'base' => '<p>The resource contains a <code>ResourceArn</code> and the <code>ResourceType</code>.</p>', 'refs' => [ 'OperationEvent$Resource' => '<p>The resource involved in the operations event.</p> <p>Contains <code>ResourceArn</code> ARN and <code>ResourceType</code>.</p>', ], ], 'ResourceId' => [ 'base' => NULL, 'refs' => [ 'Operation$ResourceId' => '<p>The resource ID of the operation.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The resource is not available.</p>', 'refs' => [], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'Operation$ResourceType' => '<p>The resource type of the operation.</p>', ], ], 'SAPInstanceNumber' => [ 'base' => NULL, 'refs' => [ 'Component$SystemNumber' => '<p>The SAP system number of the application component.</p>', 'RegisterApplicationInput$SapInstanceNumber' => '<p>The SAP instance number of the application.</p>', ], ], 'SID' => [ 'base' => NULL, 'refs' => [ 'Component$Sid' => '<p>The SAP System Identifier of the application component.</p>', 'RegisterApplicationInput$Sid' => '<p>The System ID of the application.</p>', ], ], 'SecretId' => [ 'base' => NULL, 'refs' => [ 'ApplicationCredential$SecretId' => '<p>The secret ID created in AWS Secrets Manager to store the credentials of the SAP application. </p>', ], ], 'SsmSapArn' => [ 'base' => NULL, 'refs' => [ 'Application$Arn' => '<p>The Amazon Resource Name (ARN) of the application.</p>', 'ApplicationSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the application.</p>', 'Component$Arn' => '<p>The Amazon Resource Name (ARN) of the component.</p>', 'ComponentSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the component summary.</p>', 'Database$Arn' => '<p>The Amazon Resource Name (ARN) of the database.</p>', 'DatabaseConnection$DatabaseArn' => '<p>The Amazon Resource Name of the connected SAP HANA database.</p>', 'DatabaseSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the database.</p>', 'GetApplicationInput$ApplicationArn' => '<p>The Amazon Resource Name (ARN) of the application. </p>', 'GetDatabaseInput$DatabaseArn' => '<p>The Amazon Resource Name (ARN) of the database.</p>', 'ListTagsForResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'RegisterApplicationInput$DatabaseArn' => '<p>The Amazon Resource Name of the SAP HANA database.</p>', 'TagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'UntagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'UpdateApplicationSettingsInput$DatabaseArn' => '<p>The Amazon Resource Name of the SAP HANA database that replaces the current SAP HANA connection with the SAP_ABAP application.</p>', ], ], 'StartApplicationInput' => [ 'base' => NULL, 'refs' => [], ], 'StartApplicationOutput' => [ 'base' => NULL, 'refs' => [], ], 'StartApplicationRefreshInput' => [ 'base' => NULL, 'refs' => [], ], 'StartApplicationRefreshOutput' => [ 'base' => NULL, 'refs' => [], ], 'StopApplicationInput' => [ 'base' => NULL, 'refs' => [], ], 'StopApplicationOutput' => [ 'base' => NULL, 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'Application$StatusMessage' => '<p>The status message.</p>', 'AssociatedHost$Hostname' => '<p>The name of the host.</p>', 'AssociatedHost$Ec2InstanceId' => '<p>The ID of the Amazon EC2 instance.</p>', 'AssociatedHost$OsVersion' => '<p>The version of the operating system.</p>', 'Component$SapHostname' => '<p>The hostname of the component.</p>', 'Component$SapFeature' => '<p>The SAP feature of the component.</p>', 'Component$SapKernelVersion' => '<p>The kernel version of the component.</p>', 'Component$HdbVersion' => '<p>The SAP HANA version of the component.</p>', 'Component$PrimaryHost' => '<p>The primary host of the component.</p>', 'ConflictException$Message' => NULL, 'Database$DatabaseName' => '<p>The name of the database.</p>', 'Database$PrimaryHost' => '<p>The primary host of the database.</p>', 'DatabaseConnection$ConnectionIp' => '<p>The IP address for connection.</p>', 'DeleteResourcePermissionOutput$Policy' => '<p>The policy that removes permissions on the target database.</p>', 'GetResourcePermissionOutput$Policy' => '<p/>', 'Host$HostName' => '<p>The name of the Dedicated Host.</p>', 'Host$HostIp' => '<p>The IP address of the Dedicated Host. </p>', 'Host$EC2InstanceId' => '<p>The ID of Amazon EC2 instance.</p>', 'Host$InstanceId' => '<p>The instance ID of the instance on the Dedicated Host.</p>', 'Host$OsVersion' => '<p>The version of the operating system.</p>', 'InternalServerException$Message' => NULL, 'IpAddressMember$IpAddress' => '<p>The IP address.</p>', 'Operation$StatusMessage' => '<p>The status message of the operation.</p>', 'OperationEvent$Description' => '<p>A description of the operation event. For example, "Stop the EC2 instance i-abcdefgh987654321".</p>', 'OperationEvent$StatusMessage' => '<p>The status message relating to a specific operation event.</p>', 'OperationProperties$key' => NULL, 'OperationProperties$value' => NULL, 'PutResourcePermissionOutput$Policy' => '<p/>', 'Resilience$HsrTier' => '<p>The tier of the component.</p>', 'ResourceNotFoundException$Message' => NULL, 'UnauthorizedException$Message' => NULL, 'UpdateApplicationSettingsOutput$Message' => '<p>The update message.</p>', 'ValidationException$Message' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'TagMap$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>Adds/updates or removes credentials for applications registered with AWS Systems Manager for SAP.</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'ApplicationSummary$Tags' => '<p>The tags on the application.</p>', 'ComponentSummary$Tags' => '<p>The tags of the component.</p>', 'DatabaseSummary$Tags' => '<p>The tags of the database.</p>', 'GetApplicationOutput$Tags' => '<p>The tags of a registered application.</p>', 'GetComponentOutput$Tags' => '<p>The tags of a component.</p>', 'GetDatabaseOutput$Tags' => '<p>The tags of a database.</p>', 'ListTagsForResourceResponse$tags' => '<p/>', 'RegisterApplicationInput$Tags' => '<p>The tags to be attached to the SAP application.</p>', 'TagResourceRequest$tags' => '<p>The tags on a resource.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagMap$value' => NULL, ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'Application$LastUpdated' => '<p>The time at which the application was last updated.</p>', 'Component$LastUpdated' => '<p>The time at which the component was last updated.</p>', 'Database$LastUpdated' => '<p>The time at which the database was last updated.</p>', 'Operation$StartTime' => '<p>The start time of the operation.</p>', 'Operation$EndTime' => '<p>The end time of the operation.</p>', 'Operation$LastUpdatedTime' => '<p>The time at which the operation was last updated.</p>', 'OperationEvent$Timestamp' => '<p>The timestamp of the specified operation event.</p>', ], ], 'UnauthorizedException' => [ 'base' => '<p>The request is not authorized.</p>', 'refs' => [], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateApplicationSettingsInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateApplicationSettingsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>The input fails to satisfy the constraints specified by an AWS service. </p>', 'refs' => [], ], ],];
