<?php
// This file was auto-generated from sdk-root/src/data/translate/2017-07-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Provides translation of the input content from the source language to the target language.</p>', 'operations' => [ 'CreateParallelData' => '<p>Creates a parallel data resource in Amazon Translate by importing an input file from Amazon S3. Parallel data files contain examples that show how you want segments of text to be translated. By adding parallel data, you can influence the style, tone, and word choice in your translation output.</p>', 'DeleteParallelData' => '<p>Deletes a parallel data resource in Amazon Translate.</p>', 'DeleteTerminology' => '<p>A synchronous action that deletes a custom terminology.</p>', 'DescribeTextTranslationJob' => '<p>Gets the properties associated with an asynchronous batch translation job including name, ID, status, source and target languages, input/output S3 buckets, and so on.</p>', 'GetParallelData' => '<p>Provides information about a parallel data resource.</p>', 'GetTerminology' => '<p>Retrieves a custom terminology.</p>', 'ImportTerminology' => '<p>Creates or updates a custom terminology, depending on whether one already exists for the given terminology name. Importing a terminology with the same name as an existing one will merge the terminologies based on the chosen merge strategy. The only supported merge strategy is OVERWRITE, where the imported terminology overwrites the existing terminology of the same name.</p> <p>If you import a terminology that overwrites an existing one, the new terminology takes up to 10 minutes to fully propagate. After that, translations have access to the new terminology.</p>', 'ListLanguages' => '<p>Provides a list of languages (RFC-5646 codes and names) that Amazon Translate supports.</p>', 'ListParallelData' => '<p>Provides a list of your parallel data resources in Amazon Translate.</p>', 'ListTagsForResource' => '<p>Lists all tags associated with a given Amazon Translate resource. For more information, see <a href="https://docs.aws.amazon.com/translate/latest/dg/tagging.html"> Tagging your resources</a>.</p>', 'ListTerminologies' => '<p>Provides a list of custom terminologies associated with your account.</p>', 'ListTextTranslationJobs' => '<p>Gets a list of the batch translation jobs that you have submitted.</p>', 'StartTextTranslationJob' => '<p>Starts an asynchronous batch translation job. Use batch translation jobs to translate large volumes of text across multiple documents at once. For batch translation, you can input documents with different source languages (specify <code>auto</code> as the source language). You can specify one or more target languages. Batch translation translates each input document into each of the target languages. For more information, see <a href="https://docs.aws.amazon.com/translate/latest/dg/async.html">Asynchronous batch processing</a>.</p> <p>Batch translation jobs can be described with the <a>DescribeTextTranslationJob</a> operation, listed with the <a>ListTextTranslationJobs</a> operation, and stopped with the <a>StopTextTranslationJob</a> operation.</p>', 'StopTextTranslationJob' => '<p>Stops an asynchronous batch translation job that is in progress.</p> <p>If the job\'s state is <code>IN_PROGRESS</code>, the job will be marked for termination and put into the <code>STOP_REQUESTED</code> state. If the job completes before it can be stopped, it is put into the <code>COMPLETED</code> state. Otherwise, the job is put into the <code>STOPPED</code> state.</p> <p>Asynchronous batch translation jobs are started with the <a>StartTextTranslationJob</a> operation. You can use the <a>DescribeTextTranslationJob</a> or <a>ListTextTranslationJobs</a> operations to get a batch translation job\'s <code>JobId</code>.</p>', 'TagResource' => '<p>Associates a specific tag with a resource. A tag is a key-value pair that adds as a metadata to a resource. For more information, see <a href="https://docs.aws.amazon.com/translate/latest/dg/tagging.html"> Tagging your resources</a>.</p>', 'TranslateDocument' => '<p>Translates the input document from the source language to the target language. This synchronous operation supports text, HTML, or Word documents as the input document. <code>TranslateDocument</code> supports translations from English to any supported language, and from any supported language to English. Therefore, specify either the source language code or the target language code as “en” (English). </p> <p> If you set the <code>Formality</code> parameter, the request will fail if the target language does not support formality. For a list of target languages that support formality, see <a href="https://docs.aws.amazon.com/translate/latest/dg/customizing-translations-formality.html">Setting formality</a>. </p>', 'TranslateText' => '<p>Translates input text from the source language to the target language. For a list of available languages and language codes, see <a href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.</p>', 'UntagResource' => '<p>Removes a specific tag associated with an Amazon Translate resource. For more information, see <a href="https://docs.aws.amazon.com/translate/latest/dg/tagging.html"> Tagging your resources</a>.</p>', 'UpdateParallelData' => '<p>Updates a previously created parallel data resource by importing a new input file from Amazon S3.</p>', ], 'shapes' => [ 'AppliedTerminology' => [ 'base' => '<p>The custom terminology applied to the input text by Amazon Translate for the translated text response. This is optional in the response and will only be present if you specified terminology input in the request. Currently, only one terminology can be applied per TranslateText request.</p>', 'refs' => [ 'AppliedTerminologyList$member' => NULL, ], ], 'AppliedTerminologyList' => [ 'base' => NULL, 'refs' => [ 'TranslateDocumentResponse$AppliedTerminologies' => '<p>The names of the custom terminologies applied to the input text by Amazon Translate to produce the translated text document.</p>', 'TranslateTextResponse$AppliedTerminologies' => '<p>The names of the custom terminologies applied to the input text by Amazon Translate for the translated text response.</p>', ], ], 'BoundedLengthString' => [ 'base' => NULL, 'refs' => [ 'TranslateTextRequest$Text' => '<p>The text to translate. The text string can be a maximum of 10,000 bytes long. Depending on your character set, this may be fewer than 10,000 characters.</p>', ], ], 'Brevity' => [ 'base' => NULL, 'refs' => [ 'TranslationSettings$Brevity' => '<p>When you turn on brevity, Amazon Translate reduces the length of the translation output for most translations (when compared with the same translation with brevity turned off). By default, brevity is turned off.</p> <p>If you turn on brevity for a translation request with an unsupported language pair, the translation proceeds with the brevity setting turned off.</p> <p>For the language pairs that brevity supports, see <a href="https://docs.aws.amazon.com/translate/latest/dg/customizing-translations-brevity">Using brevity</a> in the Amazon Translate Developer Guide.</p>', ], ], 'ClientTokenString' => [ 'base' => NULL, 'refs' => [ 'CreateParallelDataRequest$ClientToken' => '<p>A unique identifier for the request. This token is automatically generated when you use Amazon Translate through an AWS SDK.</p>', 'StartTextTranslationJobRequest$ClientToken' => '<p>A unique identifier for the request. This token is generated for you when using the Amazon Translate SDK.</p>', 'UpdateParallelDataRequest$ClientToken' => '<p>A unique identifier for the request. This token is automatically generated when you use Amazon Translate through an AWS SDK.</p>', ], ], 'ConcurrentModificationException' => [ 'base' => '<p>Another modification is being made. That modification must complete before you can make your change.</p>', 'refs' => [], ], 'ConflictException' => [ 'base' => '<p>There was a conflict processing the request. Try your request again.</p>', 'refs' => [], ], 'ContentType' => [ 'base' => NULL, 'refs' => [ 'Document$ContentType' => '<p>Describes the format of the document. You can specify one of the following:</p> <ul> <li> <p> <code>text/html</code> - The input data consists of HTML content. Amazon Translate translates only the text in the HTML element.</p> </li> <li> <p> <code>text/plain</code> - The input data consists of unformatted text. Amazon Translate translates every character in the content. </p> </li> <li> <p> <code>application/vnd.openxmlformats-officedocument.wordprocessingml.document</code> - The input data consists of a Word document (.docx).</p> </li> </ul>', 'InputDataConfig$ContentType' => '<p>Describes the format of the data that you submit to Amazon Translate as input. You can specify one of the following multipurpose internet mail extension (MIME) types:</p> <ul> <li> <p> <code>text/html</code>: The input data consists of one or more HTML files. Amazon Translate translates only the text that resides in the <code>html</code> element in each file.</p> </li> <li> <p> <code>text/plain</code>: The input data consists of one or more unformatted text files. Amazon Translate translates every character in this type of input.</p> </li> <li> <p> <code>application/vnd.openxmlformats-officedocument.wordprocessingml.document</code>: The input data consists of one or more Word documents (.docx).</p> </li> <li> <p> <code>application/vnd.openxmlformats-officedocument.presentationml.presentation</code>: The input data consists of one or more PowerPoint Presentation files (.pptx).</p> </li> <li> <p> <code>application/vnd.openxmlformats-officedocument.spreadsheetml.sheet</code>: The input data consists of one or more Excel Workbook files (.xlsx).</p> </li> <li> <p> <code>application/x-xliff+xml</code>: The input data consists of one or more XML Localization Interchange File Format (XLIFF) files (.xlf). Amazon Translate supports only XLIFF version 1.2.</p> </li> </ul> <important> <p>If you structure your input data as HTML, ensure that you set this parameter to <code>text/html</code>. By doing so, you cut costs by limiting the translation to the contents of the <code>html</code> element in each file. Otherwise, if you set this parameter to <code>text/plain</code>, your costs will cover the translation of every character.</p> </important>', ], ], 'CreateParallelDataRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateParallelDataResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteParallelDataRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteParallelDataResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTerminologyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTextTranslationJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTextTranslationJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'CreateParallelDataRequest$Description' => '<p>A custom description for the parallel data resource in Amazon Translate.</p>', 'ImportTerminologyRequest$Description' => '<p>The description of the custom terminology being imported.</p>', 'ParallelDataProperties$Description' => '<p>The description assigned to the parallel data resource.</p>', 'TerminologyProperties$Description' => '<p>The description of the custom terminology properties.</p>', 'UpdateParallelDataRequest$Description' => '<p>A custom description for the parallel data resource in Amazon Translate.</p>', ], ], 'DetectedLanguageLowConfidenceException' => [ 'base' => '<p>The confidence that Amazon Comprehend accurately detected the source language is low. If a low confidence level is acceptable for your application, you can use the language in the exception to call Amazon Translate again. For more information, see the <a href="https://docs.aws.amazon.com/comprehend/latest/dg/API_DetectDominantLanguage.html">DetectDominantLanguage</a> operation in the <i>Amazon Comprehend Developer Guide</i>. </p>', 'refs' => [], ], 'Directionality' => [ 'base' => NULL, 'refs' => [ 'TerminologyData$Directionality' => '<p>The directionality of your terminology resource indicates whether it has one source language (uni-directional) or multiple (multi-directional).</p> <dl> <dt>UNI</dt> <dd> <p>The terminology resource has one source language (for example, the first column in a CSV file), and all of its other languages are target languages. </p> </dd> <dt>MULTI</dt> <dd> <p>Any language in the terminology resource can be the source language or a target language. A single multi-directional terminology resource can be used for jobs that translate different language pairs. For example, if the terminology contains English and Spanish terms, it can be used for jobs that translate English to Spanish and Spanish to English.</p> </dd> </dl> <p>When you create a custom terminology resource without specifying the directionality, it behaves as uni-directional terminology, although this parameter will have a null value.</p>', 'TerminologyProperties$Directionality' => '<p>The directionality of your terminology resource indicates whether it has one source language (uni-directional) or multiple (multi-directional). </p> <dl> <dt>UNI</dt> <dd> <p>The terminology resource has one source language (the first column in a CSV file), and all of its other languages are target languages.</p> </dd> <dt>MULTI</dt> <dd> <p>Any language in the terminology resource can be the source language.</p> </dd> </dl>', ], ], 'DisplayLanguageCode' => [ 'base' => NULL, 'refs' => [ 'ListLanguagesRequest$DisplayLanguageCode' => '<p>The language code for the language to use to display the language names in the response. The language code is <code>en</code> by default. </p>', 'ListLanguagesResponse$DisplayLanguageCode' => '<p>The language code passed in with the request.</p>', ], ], 'Document' => [ 'base' => '<p>The content and content type of a document.</p>', 'refs' => [ 'TranslateDocumentRequest$Document' => '<p>The content and content type for the document to be translated. The document size must not exceed 100 KB.</p>', ], ], 'DocumentContent' => [ 'base' => NULL, 'refs' => [ 'Document$Content' => '<p>The <code>Content</code>field type is Binary large object (blob). This object contains the document content converted into base64-encoded binary data. If you use one of the AWS SDKs, the SDK performs the Base64-encoding on this field before sending the request. </p>', ], ], 'EncryptionKey' => [ 'base' => '<p>The encryption key used to encrypt this object.</p>', 'refs' => [ 'CreateParallelDataRequest$EncryptionKey' => NULL, 'ImportTerminologyRequest$EncryptionKey' => '<p>The encryption key for the custom terminology being imported.</p>', 'OutputDataConfig$EncryptionKey' => NULL, 'ParallelDataProperties$EncryptionKey' => NULL, 'TerminologyProperties$EncryptionKey' => '<p>The encryption key for the custom terminology.</p>', ], ], 'EncryptionKeyID' => [ 'base' => NULL, 'refs' => [ 'EncryptionKey$Id' => '<p>The Amazon Resource Name (ARN) of the encryption key being used to encrypt this object.</p>', ], ], 'EncryptionKeyType' => [ 'base' => NULL, 'refs' => [ 'EncryptionKey$Type' => '<p>The type of encryption key used by Amazon Translate to encrypt this object.</p>', ], ], 'Formality' => [ 'base' => NULL, 'refs' => [ 'TranslationSettings$Formality' => '<p>You can specify the desired level of formality for translations to supported target languages. The formality setting controls the level of formal language usage (also known as <a href="https://en.wikipedia.org/wiki/Register_(sociolinguistics)">register</a>) in the translation output. You can set the value to informal or formal. If you don\'t specify a value for formality, or if the target language doesn\'t support formality, the translation will ignore the formality setting.</p> <p> If you specify multiple target languages for the job, translate ignores the formality setting for any unsupported target language.</p> <p>For a list of target languages that support formality, see <a href="https://docs.aws.amazon.com/translate/latest/dg/customizing-translations-formality.html#customizing-translations-formality-languages">Supported languages</a> in the Amazon Translate Developer Guide.</p>', ], ], 'GetParallelDataRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetParallelDataResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetTerminologyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTerminologyResponse' => [ 'base' => NULL, 'refs' => [], ], 'IamRoleArn' => [ 'base' => NULL, 'refs' => [ 'StartTextTranslationJobRequest$DataAccessRoleArn' => '<p>The Amazon Resource Name (ARN) of an AWS Identity Access and Management (IAM) role that grants Amazon Translate read access to your input data. For more information, see <a href="https://docs.aws.amazon.com/translate/latest/dg/identity-and-access-management.html">Identity and access management </a>.</p>', 'TextTranslationJobProperties$DataAccessRoleArn' => '<p>The Amazon Resource Name (ARN) of an AWS Identity Access and Management (IAM) role that granted Amazon Translate read access to the job\'s input data.</p>', ], ], 'ImportTerminologyRequest' => [ 'base' => NULL, 'refs' => [], ], 'ImportTerminologyResponse' => [ 'base' => NULL, 'refs' => [], ], 'InputDataConfig' => [ 'base' => '<p>The input configuration properties for requesting a batch translation job.</p>', 'refs' => [ 'StartTextTranslationJobRequest$InputDataConfig' => '<p>Specifies the format and location of the input documents for the translation job.</p>', 'TextTranslationJobProperties$InputDataConfig' => '<p>The input configuration properties that were specified when the job was requested.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'JobDetails$TranslatedDocumentsCount' => '<p>The number of documents successfully processed during a translation job.</p>', 'JobDetails$DocumentsWithErrorsCount' => '<p>The number of documents that could not be processed during a translation job.</p>', 'JobDetails$InputDocumentsCount' => '<p>The number of documents used as input in a translation job.</p>', 'TerminologyProperties$SizeBytes' => '<p>The size of the file used when importing a custom terminology.</p>', 'TerminologyProperties$TermCount' => '<p>The number of terms included in the custom terminology.</p>', 'TerminologyProperties$SkippedTermCount' => '<p>The number of terms in the input file that Amazon Translate skipped when you created or updated the terminology resource.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>An internal server error occurred. Retry your request.</p>', 'refs' => [], ], 'InvalidFilterException' => [ 'base' => '<p>The filter specified for the operation is not valid. Specify a different filter.</p>', 'refs' => [], ], 'InvalidParameterValueException' => [ 'base' => '<p>The value of the parameter is not valid. Review the value of the parameter you are using to correct it, and then retry your operation.</p>', 'refs' => [], ], 'InvalidRequestException' => [ 'base' => '<p> The request that you made is not valid. Check your request to determine why it\'s not valid and then retry the request. </p>', 'refs' => [], ], 'JobDetails' => [ 'base' => '<p>The number of documents successfully and unsuccessfully processed during a translation job.</p>', 'refs' => [ 'TextTranslationJobProperties$JobDetails' => '<p>The number of documents successfully and unsuccessfully processed during the translation job.</p>', ], ], 'JobId' => [ 'base' => NULL, 'refs' => [ 'DescribeTextTranslationJobRequest$JobId' => '<p>The identifier that Amazon Translate generated for the job. The <a>StartTextTranslationJob</a> operation returns this identifier in its response.</p>', 'StartTextTranslationJobResponse$JobId' => '<p>The identifier generated for the job. To get the status of a job, use this ID with the <a>DescribeTextTranslationJob</a> operation.</p>', 'StopTextTranslationJobRequest$JobId' => '<p>The job ID of the job to be stopped.</p>', 'StopTextTranslationJobResponse$JobId' => '<p>The job ID of the stopped batch translation job.</p>', 'TextTranslationJobProperties$JobId' => '<p>The ID of the translation job.</p>', ], ], 'JobName' => [ 'base' => NULL, 'refs' => [ 'StartTextTranslationJobRequest$JobName' => '<p>The name of the batch translation job to be performed.</p>', 'TextTranslationJobFilter$JobName' => '<p>Filters the list of jobs by name.</p>', 'TextTranslationJobProperties$JobName' => '<p>The user-defined name of the translation job.</p>', ], ], 'JobStatus' => [ 'base' => NULL, 'refs' => [ 'StartTextTranslationJobResponse$JobStatus' => '<p>The status of the job. Possible values include:</p> <ul> <li> <p> <code>SUBMITTED</code> - The job has been received and is queued for processing.</p> </li> <li> <p> <code>IN_PROGRESS</code> - Amazon Translate is processing the job.</p> </li> <li> <p> <code>COMPLETED</code> - The job was successfully completed and the output is available.</p> </li> <li> <p> <code>COMPLETED_WITH_ERROR</code> - The job was completed with errors. The errors can be analyzed in the job\'s output.</p> </li> <li> <p> <code>FAILED</code> - The job did not complete. To get details, use the <a>DescribeTextTranslationJob</a> operation.</p> </li> <li> <p> <code>STOP_REQUESTED</code> - The user who started the job has requested that it be stopped.</p> </li> <li> <p> <code>STOPPED</code> - The job has been stopped.</p> </li> </ul>', 'StopTextTranslationJobResponse$JobStatus' => '<p>The status of the designated job. Upon successful completion, the job\'s status will be <code>STOPPED</code>.</p>', 'TextTranslationJobFilter$JobStatus' => '<p>Filters the list of jobs based by job status.</p>', 'TextTranslationJobProperties$JobStatus' => '<p>The status of the translation job.</p>', ], ], 'Language' => [ 'base' => '<p>A supported language.</p>', 'refs' => [ 'LanguagesList$member' => NULL, ], ], 'LanguageCodeString' => [ 'base' => NULL, 'refs' => [ 'DetectedLanguageLowConfidenceException$DetectedLanguageCode' => '<p>The language code of the auto-detected language from Amazon Comprehend.</p>', 'Language$LanguageCode' => '<p>Language code for the supported language.</p>', 'LanguageCodeStringList$member' => NULL, 'ParallelDataProperties$SourceLanguageCode' => '<p>The source language of the translations in the parallel data file.</p>', 'StartTextTranslationJobRequest$SourceLanguageCode' => '<p>The language code of the input language. Specify the language if all input documents share the same language. If you don\'t know the language of the source files, or your input documents contains different source languages, select <code>auto</code>. Amazon Translate auto detects the source language for each input document. For a list of supported language codes, see <a href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.</p>', 'TargetLanguageCodeStringList$member' => NULL, 'TerminologyProperties$SourceLanguageCode' => '<p>The language code for the source text of the translation request for which the custom terminology is being used.</p>', 'TextTranslationJobProperties$SourceLanguageCode' => '<p>The language code of the language of the source text. The language must be a language supported by Amazon Translate.</p>', 'TranslateDocumentRequest$SourceLanguageCode' => '<p>The language code for the language of the source text. For a list of supported language codes, see <a href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.</p> <p>To have Amazon Translate determine the source language of your text, you can specify <code>auto</code> in the <code>SourceLanguageCode</code> field. If you specify <code>auto</code>, Amazon Translate will call <a href="https://docs.aws.amazon.com/comprehend/latest/dg/comprehend-general.html">Amazon Comprehend</a> to determine the source language.</p> <note> <p>If you specify <code>auto</code>, you must send the <code>TranslateDocument</code> request in a region that supports Amazon Comprehend. Otherwise, the request returns an error indicating that autodetect is not supported. </p> </note>', 'TranslateDocumentRequest$TargetLanguageCode' => '<p>The language code requested for the translated document. For a list of supported language codes, see <a href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.</p>', 'TranslateDocumentResponse$SourceLanguageCode' => '<p>The language code of the source document.</p>', 'TranslateDocumentResponse$TargetLanguageCode' => '<p>The language code of the translated document. </p>', 'TranslateTextRequest$SourceLanguageCode' => '<p>The language code for the language of the source text. For a list of language codes, see <a href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.</p> <p>To have Amazon Translate determine the source language of your text, you can specify <code>auto</code> in the <code>SourceLanguageCode</code> field. If you specify <code>auto</code>, Amazon Translate will call <a href="https://docs.aws.amazon.com/comprehend/latest/dg/comprehend-general.html">Amazon Comprehend</a> to determine the source language.</p> <note> <p>If you specify <code>auto</code>, you must send the <code>TranslateText</code> request in a region that supports Amazon Comprehend. Otherwise, the request returns an error indicating that autodetect is not supported. </p> </note>', 'TranslateTextRequest$TargetLanguageCode' => '<p>The language code requested for the language of the target text. For a list of language codes, see <a href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.</p>', 'TranslateTextResponse$SourceLanguageCode' => '<p>The language code for the language of the source text.</p>', 'TranslateTextResponse$TargetLanguageCode' => '<p>The language code for the language of the target text. </p>', 'UnsupportedDisplayLanguageCodeException$DisplayLanguageCode' => '<p>Language code passed in with the request.</p>', 'UnsupportedLanguagePairException$SourceLanguageCode' => '<p>The language code for the language of the input text. </p>', 'UnsupportedLanguagePairException$TargetLanguageCode' => '<p>The language code for the language of the translated text. </p>', ], ], 'LanguageCodeStringList' => [ 'base' => NULL, 'refs' => [ 'ParallelDataProperties$TargetLanguageCodes' => '<p>The language codes for the target languages available in the parallel data file. All possible target languages are returned as an array.</p>', 'TerminologyProperties$TargetLanguageCodes' => '<p>The language codes for the target languages available with the custom terminology resource. All possible target languages are returned in array.</p>', ], ], 'LanguagesList' => [ 'base' => NULL, 'refs' => [ 'ListLanguagesResponse$Languages' => '<p>The list of supported languages.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>The specified limit has been exceeded. Review your request and retry it with a quantity below the stated limit.</p>', 'refs' => [], ], 'ListLanguagesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListLanguagesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListParallelDataRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListParallelDataResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTerminologiesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTerminologiesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTextTranslationJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTextTranslationJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'LocalizedNameString' => [ 'base' => NULL, 'refs' => [ 'Language$LanguageName' => '<p>Language name of the supported language.</p>', ], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'ParallelDataProperties$ImportedDataSize' => '<p>The number of UTF-8 characters that Amazon Translate imported from the parallel data input file. This number includes only the characters in your translation examples. It does not include characters that are used to format your file. For example, if you provided a Translation Memory Exchange (.tmx) file, this number does not include the tags.</p>', 'ParallelDataProperties$ImportedRecordCount' => '<p>The number of records successfully imported from the parallel data input file.</p>', 'ParallelDataProperties$FailedRecordCount' => '<p>The number of records unsuccessfully imported from the parallel data input file.</p>', 'ParallelDataProperties$SkippedRecordCount' => '<p>The number of items in the input file that Amazon Translate skipped when you created or updated the parallel data resource. For example, Amazon Translate skips empty records, empty target texts, and empty lines.</p>', ], ], 'MaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListLanguagesRequest$MaxResults' => '<p>The maximum number of results to return in each response.</p>', 'ListParallelDataRequest$MaxResults' => '<p>The maximum number of parallel data resources returned for each request.</p>', 'ListTerminologiesRequest$MaxResults' => '<p>The maximum number of custom terminologies returned per list request.</p>', 'ListTextTranslationJobsRequest$MaxResults' => '<p>The maximum number of results to return in each page. The default value is 100.</p>', ], ], 'MergeStrategy' => [ 'base' => NULL, 'refs' => [ 'ImportTerminologyRequest$MergeStrategy' => '<p>The merge strategy of the custom terminology being imported. Currently, only the OVERWRITE merge strategy is supported. In this case, the imported terminology will overwrite an existing terminology of the same name.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListLanguagesRequest$NextToken' => '<p>Include the NextToken value to fetch the next group of supported languages. </p>', 'ListLanguagesResponse$NextToken' => '<p> If the response does not include all remaining results, use the NextToken in the next request to fetch the next group of supported languages.</p>', 'ListParallelDataRequest$NextToken' => '<p>A string that specifies the next page of results to return in a paginated response.</p>', 'ListParallelDataResponse$NextToken' => '<p>The string to use in a subsequent request to get the next page of results in a paginated response. This value is null if there are no additional pages.</p>', 'ListTerminologiesRequest$NextToken' => '<p>If the result of the request to ListTerminologies was truncated, include the NextToken to fetch the next group of custom terminologies. </p>', 'ListTerminologiesResponse$NextToken' => '<p> If the response to the ListTerminologies was truncated, the NextToken fetches the next group of custom terminologies.</p>', 'ListTextTranslationJobsRequest$NextToken' => '<p>The token to request the next page of results.</p>', 'ListTextTranslationJobsResponse$NextToken' => '<p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', ], ], 'OutputDataConfig' => [ 'base' => '<p>The output configuration properties for a batch translation job.</p>', 'refs' => [ 'StartTextTranslationJobRequest$OutputDataConfig' => '<p>Specifies the S3 folder to which your job output will be saved. </p>', 'TextTranslationJobProperties$OutputDataConfig' => '<p>The output configuration properties that were specified when the job was requested.</p>', ], ], 'ParallelDataArn' => [ 'base' => NULL, 'refs' => [ 'ParallelDataProperties$Arn' => '<p>The Amazon Resource Name (ARN) of the parallel data resource.</p>', ], ], 'ParallelDataConfig' => [ 'base' => '<p>Specifies the format and S3 location of the parallel data input file.</p>', 'refs' => [ 'CreateParallelDataRequest$ParallelDataConfig' => '<p>Specifies the format and S3 location of the parallel data input file.</p>', 'ParallelDataProperties$ParallelDataConfig' => '<p>Specifies the format and S3 location of the parallel data input file.</p>', 'UpdateParallelDataRequest$ParallelDataConfig' => '<p>Specifies the format and S3 location of the parallel data input file.</p>', ], ], 'ParallelDataDataLocation' => [ 'base' => '<p>The location of the most recent parallel data input file that was successfully imported into Amazon Translate.</p>', 'refs' => [ 'GetParallelDataResponse$DataLocation' => '<p>The Amazon S3 location of the most recent parallel data input file that was successfully imported into Amazon Translate. The location is returned as a presigned URL that has a 30-minute expiration.</p> <important> <p>Amazon Translate doesn\'t scan all input files for the risk of CSV injection attacks. </p> <p>CSV injection occurs when a .csv or .tsv file is altered so that a record contains malicious code. The record begins with a special character, such as =, +, -, or @. When the file is opened in a spreadsheet program, the program might interpret the record as a formula and run the code within it.</p> <p>Before you download an input file from Amazon S3, ensure that you recognize the file and trust its creator.</p> </important>', 'GetParallelDataResponse$AuxiliaryDataLocation' => '<p>The Amazon S3 location of a file that provides any errors or warnings that were produced by your input file. This file was created when Amazon Translate attempted to create a parallel data resource. The location is returned as a presigned URL to that has a 30-minute expiration.</p>', 'GetParallelDataResponse$LatestUpdateAttemptAuxiliaryDataLocation' => '<p>The Amazon S3 location of a file that provides any errors or warnings that were produced by your input file. This file was created when Amazon Translate attempted to update a parallel data resource. The location is returned as a presigned URL to that has a 30-minute expiration.</p>', ], ], 'ParallelDataFormat' => [ 'base' => NULL, 'refs' => [ 'ParallelDataConfig$Format' => '<p>The format of the parallel data input file.</p>', ], ], 'ParallelDataProperties' => [ 'base' => '<p>The properties of a parallel data resource.</p>', 'refs' => [ 'GetParallelDataResponse$ParallelDataProperties' => '<p>The properties of the parallel data resource that is being retrieved.</p>', 'ParallelDataPropertiesList$member' => NULL, ], ], 'ParallelDataPropertiesList' => [ 'base' => NULL, 'refs' => [ 'ListParallelDataResponse$ParallelDataPropertiesList' => '<p>The properties of the parallel data resources returned by this request.</p>', ], ], 'ParallelDataStatus' => [ 'base' => NULL, 'refs' => [ 'CreateParallelDataResponse$Status' => '<p>The status of the parallel data resource. When the resource is ready for you to use, the status is <code>ACTIVE</code>.</p>', 'DeleteParallelDataResponse$Status' => '<p>The status of the parallel data deletion.</p>', 'ParallelDataProperties$Status' => '<p>The status of the parallel data resource. When the parallel data is ready for you to use, the status is <code>ACTIVE</code>.</p>', 'ParallelDataProperties$LatestUpdateAttemptStatus' => '<p>The status of the most recent update attempt for the parallel data resource.</p>', 'UpdateParallelDataResponse$Status' => '<p>The status of the parallel data resource that you are attempting to update. Your update request is accepted only if this status is either <code>ACTIVE</code> or <code>FAILED</code>.</p>', 'UpdateParallelDataResponse$LatestUpdateAttemptStatus' => '<p>The status of the parallel data update attempt. When the updated parallel data resource is ready for you to use, the status is <code>ACTIVE</code>.</p>', ], ], 'Profanity' => [ 'base' => NULL, 'refs' => [ 'TranslationSettings$Profanity' => '<p>You can enable the profanity setting if you want to mask profane words and phrases in your translation output.</p> <p>To mask profane words and phrases, Amazon Translate replaces them with the grawlix string “?$#@$“. This 5-character sequence is used for each profane word or phrase, regardless of the length or number of words.</p> <p>Amazon Translate doesn\'t detect profanity in all of its supported languages. For languages that don\'t support profanity detection, see <a href="https://docs.aws.amazon.com/translate/latest/dg/customizing-translations-profanity.html#customizing-translations-profanity-languages">Unsupported languages</a> in the Amazon Translate Developer Guide.</p> <p>If you specify multiple target languages for the job, all the target languages must support profanity masking. If any of the target languages don\'t support profanity masking, the translation job won\'t mask profanity for any target language.</p>', ], ], 'ResourceArn' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the given Amazon Translate resource you are querying. </p>', 'TagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the given Amazon Translate resource to which you want to associate the tags. </p>', 'TooManyTagsException$ResourceArn' => NULL, 'UntagResourceRequest$ResourceArn' => '<p> The Amazon Resource Name (ARN) of the given Amazon Translate resource from which you want to remove the tags. </p>', ], ], 'ResourceName' => [ 'base' => NULL, 'refs' => [ 'AppliedTerminology$Name' => '<p>The name of the custom terminology applied to the input text by Amazon Translate for the translated text response.</p>', 'CreateParallelDataRequest$Name' => '<p>A custom name for the parallel data resource in Amazon Translate. You must assign a name that is unique in the account and region.</p>', 'CreateParallelDataResponse$Name' => '<p>The custom name that you assigned to the parallel data resource.</p>', 'DeleteParallelDataRequest$Name' => '<p>The name of the parallel data resource that is being deleted.</p>', 'DeleteParallelDataResponse$Name' => '<p>The name of the parallel data resource that is being deleted.</p>', 'DeleteTerminologyRequest$Name' => '<p>The name of the custom terminology being deleted. </p>', 'GetParallelDataRequest$Name' => '<p>The name of the parallel data resource that is being retrieved.</p>', 'GetTerminologyRequest$Name' => '<p>The name of the custom terminology being retrieved.</p>', 'ImportTerminologyRequest$Name' => '<p>The name of the custom terminology being imported.</p>', 'ParallelDataProperties$Name' => '<p>The custom name assigned to the parallel data resource.</p>', 'ResourceNameList$member' => NULL, 'TerminologyProperties$Name' => '<p>The name of the custom terminology.</p>', 'UpdateParallelDataRequest$Name' => '<p>The name of the parallel data resource being updated.</p>', 'UpdateParallelDataResponse$Name' => '<p>The name of the parallel data resource being updated.</p>', ], ], 'ResourceNameList' => [ 'base' => NULL, 'refs' => [ 'StartTextTranslationJobRequest$TerminologyNames' => '<p>The name of a custom terminology resource to add to the translation job. This resource lists examples source terms and the desired translation for each term.</p> <p>This parameter accepts only one custom terminology resource.</p> <p>If you specify multiple target languages for the job, translate uses the designated terminology for each requested target language that has an entry for the source term in the terminology file.</p> <p>For a list of available custom terminology resources, use the <a>ListTerminologies</a> operation.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/translate/latest/dg/how-custom-terminology.html">Custom terminology</a>.</p>', 'StartTextTranslationJobRequest$ParallelDataNames' => '<p>The name of a parallel data resource to add to the translation job. This resource consists of examples that show how you want segments of text to be translated. If you specify multiple target languages for the job, the parallel data file must include translations for all the target languages.</p> <p>When you add parallel data to a translation job, you create an <i>Active Custom Translation</i> job. </p> <p>This parameter accepts only one parallel data resource.</p> <note> <p>Active Custom Translation jobs are priced at a higher rate than other jobs that don\'t use parallel data. For more information, see <a href="http://aws.amazon.com/translate/pricing/">Amazon Translate pricing</a>.</p> </note> <p>For a list of available parallel data resources, use the <a>ListParallelData</a> operation.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/translate/latest/dg/customizing-translations-parallel-data.html"> Customizing your translations with parallel data</a>.</p>', 'TextTranslationJobProperties$TerminologyNames' => '<p>A list containing the names of the terminologies applied to a translation job. Only one terminology can be applied per <a>StartTextTranslationJob</a> request at this time.</p>', 'TextTranslationJobProperties$ParallelDataNames' => '<p>A list containing the names of the parallel data resources applied to the translation job.</p>', 'TranslateDocumentRequest$TerminologyNames' => '<p>The name of a terminology list file to add to the translation job. This file provides source terms and the desired translation for each term. A terminology list can contain a maximum of 256 terms. You can use one custom terminology resource in your translation request.</p> <p>Use the <a>ListTerminologies</a> operation to get the available terminology lists.</p> <p>For more information about custom terminology lists, see <a href="https://docs.aws.amazon.com/translate/latest/dg/how-custom-terminology.html">Custom terminology</a>.</p>', 'TranslateTextRequest$TerminologyNames' => '<p>The name of a terminology list file to add to the translation job. This file provides source terms and the desired translation for each term. A terminology list can contain a maximum of 256 terms. You can use one custom terminology resource in your translation request.</p> <p>Use the <a>ListTerminologies</a> operation to get the available terminology lists.</p> <p>For more information about custom terminology lists, see <a href="https://docs.aws.amazon.com/translate/latest/dg/how-custom-terminology.html">Custom terminology</a>.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The resource you are looking for has not been found. Review the resource you\'re looking for and see if a different resource will accomplish your needs before retrying the revised request.</p>', 'refs' => [], ], 'S3Uri' => [ 'base' => NULL, 'refs' => [ 'InputDataConfig$S3Uri' => '<p>The URI of the AWS S3 folder that contains the input files. Amazon Translate translates all the files in the folder and all its sub-folders. The folder must be in the same Region as the API endpoint you are calling.</p>', 'OutputDataConfig$S3Uri' => '<p>The URI of the S3 folder that contains a translation job\'s output file. The folder must be in the same Region as the API endpoint that you are calling.</p>', 'ParallelDataConfig$S3Uri' => '<p>The URI of the Amazon S3 folder that contains the parallel data input file. The folder must be in the same Region as the API endpoint you are calling.</p>', ], ], 'ServiceUnavailableException' => [ 'base' => '<p>The Amazon Translate service is temporarily unavailable. Wait a bit and then retry your request.</p>', 'refs' => [], ], 'StartTextTranslationJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartTextTranslationJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'StopTextTranslationJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopTextTranslationJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'ConcurrentModificationException$Message' => NULL, 'ConflictException$Message' => NULL, 'DetectedLanguageLowConfidenceException$Message' => NULL, 'InternalServerException$Message' => NULL, 'InvalidFilterException$Message' => NULL, 'InvalidParameterValueException$Message' => NULL, 'InvalidRequestException$Message' => NULL, 'LimitExceededException$Message' => NULL, 'ParallelDataDataLocation$RepositoryType' => '<p>Describes the repository that contains the parallel data input file.</p>', 'ParallelDataDataLocation$Location' => '<p>The Amazon S3 location of the parallel data input file. The location is returned as a presigned URL to that has a 30-minute expiration.</p> <important> <p>Amazon Translate doesn\'t scan all input files for the risk of CSV injection attacks. </p> <p>CSV injection occurs when a .csv or .tsv file is altered so that a record contains malicious code. The record begins with a special character, such as =, +, -, or @. When the file is opened in a spreadsheet program, the program might interpret the record as a formula and run the code within it.</p> <p>Before you download an input file from Amazon S3, ensure that you recognize the file and trust its creator.</p> </important>', 'ResourceNotFoundException$Message' => NULL, 'ServiceUnavailableException$Message' => NULL, 'Term$SourceText' => '<p>The source text of the term being translated by the custom terminology.</p>', 'Term$TargetText' => '<p>The target text of the term being translated by the custom terminology.</p>', 'TerminologyDataLocation$RepositoryType' => '<p>The repository type for the custom terminology data.</p>', 'TerminologyDataLocation$Location' => '<p>The Amazon S3 location of the most recent custom terminology input file that was successfully imported into Amazon Translate. The location is returned as a presigned URL that has a 30-minute expiration .</p> <important> <p>Amazon Translate doesn\'t scan all input files for the risk of CSV injection attacks. </p> <p>CSV injection occurs when a .csv or .tsv file is altered so that a record contains malicious code. The record begins with a special character, such as =, +, -, or @. When the file is opened in a spreadsheet program, the program might interpret the record as a formula and run the code within it.</p> <p>Before you download an input file from Amazon S3, ensure that you recognize the file and trust its creator.</p> </important>', 'TextSizeLimitExceededException$Message' => NULL, 'TooManyRequestsException$Message' => NULL, 'TooManyTagsException$message' => NULL, 'UnsupportedDisplayLanguageCodeException$Message' => NULL, 'UnsupportedLanguagePairException$Message' => NULL, ], ], 'Tag' => [ 'base' => '<p>A key-value pair that adds as a metadata to a resource used by Amazon Translate. </p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The initial part of a key-value pair that forms a tag associated with a given resource. </p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>The initial part of a key-value pair that forms a tag being removed from a given resource. Keys must be unique and cannot be duplicated for a particular resource. </p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateParallelDataRequest$Tags' => '<p>Tags to be associated with this resource. A tag is a key-value pair that adds metadata to a resource. Each tag key for the resource must be unique. For more information, see <a href="https://docs.aws.amazon.com/translate/latest/dg/tagging.html"> Tagging your resources</a>.</p>', 'ImportTerminologyRequest$Tags' => '<p>Tags to be associated with this resource. A tag is a key-value pair that adds metadata to a resource. Each tag key for the resource must be unique. For more information, see <a href="https://docs.aws.amazon.com/translate/latest/dg/tagging.html"> Tagging your resources</a>.</p>', 'ListTagsForResourceResponse$Tags' => '<p>Tags associated with the Amazon Translate resource being queried. A tag is a key-value pair that adds as a metadata to a resource used by Amazon Translate. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department. </p>', 'TagResourceRequest$Tags' => '<p>Tags being associated with a specific Amazon Translate resource. There can be a maximum of 50 tags (both existing and pending) associated with a specific resource.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p> The second part of a key-value pair that forms a tag associated with a given resource.</p>', ], ], 'TargetLanguageCodeStringList' => [ 'base' => NULL, 'refs' => [ 'StartTextTranslationJobRequest$TargetLanguageCodes' => '<p>The target languages of the translation job. Enter up to 10 language codes. Each input file is translated into each target language.</p> <p>Each language code is 2 or 5 characters long. For a list of language codes, see <a href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.</p>', 'TextTranslationJobProperties$TargetLanguageCodes' => '<p>The language code of the language of the target text. The language must be a language supported by Amazon Translate.</p>', ], ], 'Term' => [ 'base' => '<p>The term being translated by the custom terminology.</p>', 'refs' => [ 'TermList$member' => NULL, ], ], 'TermList' => [ 'base' => NULL, 'refs' => [ 'AppliedTerminology$Terms' => '<p>The specific terms of the custom terminology applied to the input text by Amazon Translate for the translated text response. A maximum of 250 terms will be returned, and the specific terms applied will be the first 250 terms in the source text. </p>', ], ], 'TerminologyArn' => [ 'base' => NULL, 'refs' => [ 'TerminologyProperties$Arn' => '<p> The Amazon Resource Name (ARN) of the custom terminology. </p>', ], ], 'TerminologyData' => [ 'base' => '<p>The data associated with the custom terminology. For information about the custom terminology file, see <a href="https://docs.aws.amazon.com/translate/latest/dg/creating-custom-terminology.html"> Creating a Custom Terminology</a>.</p>', 'refs' => [ 'ImportTerminologyRequest$TerminologyData' => '<p>The terminology data for the custom terminology being imported.</p>', ], ], 'TerminologyDataFormat' => [ 'base' => NULL, 'refs' => [ 'GetTerminologyRequest$TerminologyDataFormat' => '<p>The data format of the custom terminology being retrieved.</p> <p>If you don\'t specify this parameter, Amazon Translate returns a file with the same format as the file that was imported to create the terminology. </p> <p>If you specify this parameter when you retrieve a multi-directional terminology resource, you must specify the same format as the input file that was imported to create it. Otherwise, Amazon Translate throws an error.</p>', 'TerminologyData$Format' => '<p>The data format of the custom terminology.</p>', 'TerminologyProperties$Format' => '<p>The format of the custom terminology input file.</p>', ], ], 'TerminologyDataLocation' => [ 'base' => '<p>The location of the custom terminology data.</p>', 'refs' => [ 'GetTerminologyResponse$TerminologyDataLocation' => '<p>The Amazon S3 location of the most recent custom terminology input file that was successfully imported into Amazon Translate. The location is returned as a presigned URL that has a 30-minute expiration.</p> <important> <p>Amazon Translate doesn\'t scan all input files for the risk of CSV injection attacks. </p> <p>CSV injection occurs when a .csv or .tsv file is altered so that a record contains malicious code. The record begins with a special character, such as =, +, -, or @. When the file is opened in a spreadsheet program, the program might interpret the record as a formula and run the code within it.</p> <p>Before you download an input file from Amazon S3, ensure that you recognize the file and trust its creator.</p> </important>', 'GetTerminologyResponse$AuxiliaryDataLocation' => '<p>The Amazon S3 location of a file that provides any errors or warnings that were produced by your input file. This file was created when Amazon Translate attempted to create a terminology resource. The location is returned as a presigned URL to that has a 30-minute expiration.</p>', 'ImportTerminologyResponse$AuxiliaryDataLocation' => '<p>The Amazon S3 location of a file that provides any errors or warnings that were produced by your input file. This file was created when Amazon Translate attempted to create a terminology resource. The location is returned as a presigned URL to that has a 30 minute expiration.</p>', ], ], 'TerminologyFile' => [ 'base' => NULL, 'refs' => [ 'TerminologyData$File' => '<p>The file containing the custom terminology data. Your version of the AWS SDK performs a Base64-encoding on this field before sending a request to the AWS service. Users of the SDK should not perform Base64-encoding themselves.</p>', ], ], 'TerminologyProperties' => [ 'base' => '<p>The properties of the custom terminology.</p>', 'refs' => [ 'GetTerminologyResponse$TerminologyProperties' => '<p>The properties of the custom terminology being retrieved.</p>', 'ImportTerminologyResponse$TerminologyProperties' => '<p>The properties of the custom terminology being imported.</p>', 'TerminologyPropertiesList$member' => NULL, ], ], 'TerminologyPropertiesList' => [ 'base' => NULL, 'refs' => [ 'ListTerminologiesResponse$TerminologyPropertiesList' => '<p>The properties list of the custom terminologies returned on the list request.</p>', ], ], 'TextSizeLimitExceededException' => [ 'base' => '<p> The size of the text you submitted exceeds the size limit. Reduce the size of the text or use a smaller document and then retry your request. </p>', 'refs' => [], ], 'TextTranslationJobFilter' => [ 'base' => '<p>Provides information for filtering a list of translation jobs. For more information, see <a>ListTextTranslationJobs</a>.</p>', 'refs' => [ 'ListTextTranslationJobsRequest$Filter' => '<p>The parameters that specify which batch translation jobs to retrieve. Filters include job name, job status, and submission time. You can only set one filter at a time.</p>', ], ], 'TextTranslationJobProperties' => [ 'base' => '<p>Provides information about a translation job.</p>', 'refs' => [ 'DescribeTextTranslationJobResponse$TextTranslationJobProperties' => '<p>An object that contains the properties associated with an asynchronous batch translation job.</p>', 'TextTranslationJobPropertiesList$member' => NULL, ], ], 'TextTranslationJobPropertiesList' => [ 'base' => NULL, 'refs' => [ 'ListTextTranslationJobsResponse$TextTranslationJobPropertiesList' => '<p>A list containing the properties of each job that is returned.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'ParallelDataProperties$CreatedAt' => '<p>The time at which the parallel data resource was created.</p>', 'ParallelDataProperties$LastUpdatedAt' => '<p>The time at which the parallel data resource was last updated.</p>', 'ParallelDataProperties$LatestUpdateAttemptAt' => '<p>The time that the most recent update was attempted.</p>', 'TerminologyProperties$CreatedAt' => '<p>The time at which the custom terminology was created, based on the timestamp.</p>', 'TerminologyProperties$LastUpdatedAt' => '<p>The time at which the custom terminology was last update, based on the timestamp.</p>', 'TextTranslationJobFilter$SubmittedBeforeTime' => '<p>Filters the list of jobs based on the time that the job was submitted for processing and returns only the jobs submitted before the specified time. Jobs are returned in ascending order, oldest to newest.</p>', 'TextTranslationJobFilter$SubmittedAfterTime' => '<p>Filters the list of jobs based on the time that the job was submitted for processing and returns only the jobs submitted after the specified time. Jobs are returned in descending order, newest to oldest.</p>', 'TextTranslationJobProperties$SubmittedTime' => '<p>The time at which the translation job was submitted.</p>', 'TextTranslationJobProperties$EndTime' => '<p>The time at which the translation job ended.</p>', 'UpdateParallelDataResponse$LatestUpdateAttemptAt' => '<p>The time that the most recent update was attempted.</p>', ], ], 'TooManyRequestsException' => [ 'base' => '<p> You have made too many requests within a short period of time. Wait for a short time and then try your request again.</p>', 'refs' => [], ], 'TooManyTagsException' => [ 'base' => '<p>You have added too many tags to this resource. The maximum is 50 tags.</p>', 'refs' => [], ], 'TranslateDocumentRequest' => [ 'base' => NULL, 'refs' => [], ], 'TranslateDocumentResponse' => [ 'base' => NULL, 'refs' => [], ], 'TranslateTextRequest' => [ 'base' => NULL, 'refs' => [], ], 'TranslateTextResponse' => [ 'base' => NULL, 'refs' => [], ], 'TranslatedDocument' => [ 'base' => '<p>The translated content.</p>', 'refs' => [ 'TranslateDocumentResponse$TranslatedDocument' => '<p>The document containing the translated content. The document format matches the source document format.</p>', ], ], 'TranslatedDocumentContent' => [ 'base' => NULL, 'refs' => [ 'TranslatedDocument$Content' => '<p>The document containing the translated content.</p>', ], ], 'TranslatedTextString' => [ 'base' => NULL, 'refs' => [ 'TranslateTextResponse$TranslatedText' => '<p>The translated text.</p>', ], ], 'TranslationSettings' => [ 'base' => '<p>Settings to configure your translation output. You can configure the following options:</p> <ul> <li> <p>Brevity: reduces the length of the translation output for most translations. Available for <code>TranslateText</code> only.</p> </li> <li> <p>Formality: sets the formality level of the translation output.</p> </li> <li> <p>Profanity: masks profane words and phrases in the translation output.</p> </li> </ul>', 'refs' => [ 'StartTextTranslationJobRequest$Settings' => '<p>Settings to configure your translation output. You can configure the following options:</p> <ul> <li> <p>Brevity: not supported.</p> </li> <li> <p>Formality: sets the formality level of the output text.</p> </li> <li> <p>Profanity: masks profane words and phrases in your translation output.</p> </li> </ul>', 'TextTranslationJobProperties$Settings' => '<p>Settings that modify the translation output.</p>', 'TranslateDocumentRequest$Settings' => '<p>Settings to configure your translation output. You can configure the following options:</p> <ul> <li> <p>Brevity: not supported.</p> </li> <li> <p>Formality: sets the formality level of the output text.</p> </li> <li> <p>Profanity: masks profane words and phrases in your translation output.</p> </li> </ul>', 'TranslateDocumentResponse$AppliedSettings' => NULL, 'TranslateTextRequest$Settings' => '<p>Settings to configure your translation output. You can configure the following options:</p> <ul> <li> <p>Brevity: reduces the length of the translated output for most translations.</p> </li> <li> <p>Formality: sets the formality level of the output text.</p> </li> <li> <p>Profanity: masks profane words and phrases in your translation output.</p> </li> </ul>', 'TranslateTextResponse$AppliedSettings' => '<p>Optional settings that modify the translation output.</p>', ], ], 'UnboundedLengthString' => [ 'base' => NULL, 'refs' => [ 'ParallelDataProperties$Message' => '<p>Additional information from Amazon Translate about the parallel data resource. </p>', 'TerminologyProperties$Message' => '<p>Additional information from Amazon Translate about the terminology resource.</p>', 'TextTranslationJobProperties$Message' => '<p>An explanation of any errors that may have occurred during the translation job.</p>', ], ], 'UnsupportedDisplayLanguageCodeException' => [ 'base' => '<p>Requested display language code is not supported.</p>', 'refs' => [], ], 'UnsupportedLanguagePairException' => [ 'base' => '<p>Amazon Translate does not support translation from the language of the source text into the requested target language. For more information, see <a href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>. </p>', 'refs' => [], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateParallelDataRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateParallelDataResponse' => [ 'base' => NULL, 'refs' => [], ], ],];
