<?php
// This file was auto-generated from sdk-root/src/data/verifiedpermissions/2021-12-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon Verified Permissions is a permissions management service from Amazon Web Services. You can use Verified Permissions to manage permissions for your application, and authorize user access based on those permissions. Using Verified Permissions, application developers can grant access based on information about the users, resources, and requested actions. You can also evaluate additional information like group membership, attributes of the resources, and session context, such as time of request and IP addresses. Verified Permissions manages these permissions by letting you create and store authorization policies for your applications, such as consumer-facing web sites and enterprise business systems.</p> <p>Verified Permissions uses Cedar as the policy language to express your permission requirements. Cedar supports both role-based access control (RBAC) and attribute-based access control (ABAC) authorization models.</p> <p>For more information about configuring, administering, and using Amazon Verified Permissions in your applications, see the <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/userguide/">Amazon Verified Permissions User Guide</a>.</p> <p>For more information about the Cedar policy language, see the <a href="https://docs.cedarpolicy.com/">Cedar Policy Language Guide</a>.</p> <important> <p>When you write Cedar policies that reference principals, resources and actions, you can define the unique identifiers used for each of those elements. We strongly recommend that you follow these best practices:</p> <ul> <li> <p> <b>Use values like universally unique identifiers (UUIDs) for all principal and resource identifiers.</b> </p> <p>For example, if user <code>jane</code> leaves the company, and you later let someone else use the name <code>jane</code>, then that new user automatically gets access to everything granted by policies that still reference <code>User::"jane"</code>. Cedar can’t distinguish between the new user and the old. This applies to both principal and resource identifiers. Always use identifiers that are guaranteed unique and never reused to ensure that you don’t unintentionally grant access because of the presence of an old identifier in a policy.</p> <p>Where you use a UUID for an entity, we recommend that you follow it with the // comment specifier and the ‘friendly’ name of your entity. This helps to make your policies easier to understand. For example: principal == User::"a1b2c3d4-e5f6-a1b2-c3d4-EXAMPLE11111", // alice</p> </li> <li> <p> <b>Do not include personally identifying, confidential, or sensitive information as part of the unique identifier for your principals or resources.</b> These identifiers are included in log entries shared in CloudTrail trails.</p> </li> </ul> </important> <p>Several operations return structures that appear similar, but have different purposes. As new functionality is added to the product, the structure used in a parameter of one operation might need to change in a way that wouldn\'t make sense for the same parameter in a different operation. To help you understand the purpose of each, the following naming convention is used for the structures:</p> <ul> <li> <p>Parameter type structures that end in <code>Detail</code> are used in <code>Get</code> operations.</p> </li> <li> <p>Parameter type structures that end in <code>Item</code> are used in <code>List</code> operations.</p> </li> <li> <p>Parameter type structures that use neither suffix are used in the mutating (create and update) operations.</p> </li> </ul>', 'operations' => [ 'BatchIsAuthorized' => '<p>Makes a series of decisions about multiple authorization requests for one principal or resource. Each request contains the equivalent content of an <code>IsAuthorized</code> request: principal, action, resource, and context. Either the <code>principal</code> or the <code>resource</code> parameter must be identical across all requests. For example, Verified Permissions won\'t evaluate a pair of requests where <code>bob</code> views <code>photo1</code> and <code>alice</code> views <code>photo2</code>. Authorization of <code>bob</code> to view <code>photo1</code> and <code>photo2</code>, or <code>bob</code> and <code>alice</code> to view <code>photo1</code>, are valid batches. </p> <p>The request is evaluated against all policies in the specified policy store that match the entities that you declare. The result of the decisions is a series of <code>Allow</code> or <code>Deny</code> responses, along with the IDs of the policies that produced each decision.</p> <p>The <code>entities</code> of a <code>BatchIsAuthorized</code> API request can contain up to 100 principals and up to 100 resources. The <code>requests</code> of a <code>BatchIsAuthorized</code> API request can contain up to 30 requests.</p> <note> <p>The <code>BatchIsAuthorized</code> operation doesn\'t have its own IAM permission. To authorize this operation for Amazon Web Services principals, include the permission <code>verifiedpermissions:IsAuthorized</code> in their IAM policies.</p> </note>', 'BatchIsAuthorizedWithToken' => '<p>Makes a series of decisions about multiple authorization requests for one token. The principal in this request comes from an external identity source in the form of an identity or access token, formatted as a <a href="https://wikipedia.org/wiki/JSON_Web_Token">JSON web token (JWT)</a>. The information in the parameters can also define additional context that Verified Permissions can include in the evaluations.</p> <p>The request is evaluated against all policies in the specified policy store that match the entities that you provide in the entities declaration and in the token. The result of the decisions is a series of <code>Allow</code> or <code>Deny</code> responses, along with the IDs of the policies that produced each decision.</p> <p>The <code>entities</code> of a <code>BatchIsAuthorizedWithToken</code> API request can contain up to 100 resources and up to 99 user groups. The <code>requests</code> of a <code>BatchIsAuthorizedWithToken</code> API request can contain up to 30 requests.</p> <note> <p>The <code>BatchIsAuthorizedWithToken</code> operation doesn\'t have its own IAM permission. To authorize this operation for Amazon Web Services principals, include the permission <code>verifiedpermissions:IsAuthorizedWithToken</code> in their IAM policies.</p> </note>', 'CreateIdentitySource' => '<p>Adds an identity source to a policy store–an Amazon Cognito user pool or OpenID Connect (OIDC) identity provider (IdP). </p> <p>After you create an identity source, you can use the identities provided by the IdP as proxies for the principal in authorization queries that use the <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorizedWithToken.html">IsAuthorizedWithToken</a> or <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_BatchIsAuthorizedWithToken.html">BatchIsAuthorizedWithToken</a> API operations. These identities take the form of tokens that contain claims about the user, such as IDs, attributes and group memberships. Identity sources provide identity (ID) tokens and access tokens. Verified Permissions derives information about your user and session from token claims. Access tokens provide action <code>context</code> to your policies, and ID tokens provide principal <code>Attributes</code>.</p> <important> <p>Tokens from an identity source user continue to be usable until they expire. Token revocation and resource deletion have no effect on the validity of a token in your policy store</p> </important> <note> <p>To reference a user from this identity source in your Cedar policies, refer to the following syntax examples.</p> <ul> <li> <p>Amazon Cognito user pool: <code>Namespace::[Entity type]::[User pool ID]|[user principal attribute]</code>, for example <code>MyCorp::User::us-east-1_EXAMPLE|a1b2c3d4-5678-90ab-cdef-EXAMPLE11111</code>.</p> </li> <li> <p>OpenID Connect (OIDC) provider: <code>Namespace::[Entity type]::[principalIdClaim]|[user principal attribute]</code>, for example <code>MyCorp::User::MyOIDCProvider|a1b2c3d4-5678-90ab-cdef-EXAMPLE22222</code>.</p> </li> </ul> </note> <note> <p>Verified Permissions is <i> <a href="https://wikipedia.org/wiki/Eventual_consistency">eventually consistent</a> </i>. It can take a few seconds for a new or changed element to propagate through the service and be visible in the results of other Verified Permissions operations.</p> </note>', 'CreatePolicy' => '<p>Creates a Cedar policy and saves it in the specified policy store. You can create either a static policy or a policy linked to a policy template.</p> <ul> <li> <p>To create a static policy, provide the Cedar policy text in the <code>StaticPolicy</code> section of the <code>PolicyDefinition</code>.</p> </li> <li> <p>To create a policy that is dynamically linked to a policy template, specify the policy template ID and the principal and resource to associate with this policy in the <code>templateLinked</code> section of the <code>PolicyDefinition</code>. If the policy template is ever updated, any policies linked to the policy template automatically use the updated template.</p> </li> </ul> <note> <p>Creating a policy causes it to be validated against the schema in the policy store. If the policy doesn\'t pass validation, the operation fails and the policy isn\'t stored.</p> </note> <note> <p>Verified Permissions is <i> <a href="https://wikipedia.org/wiki/Eventual_consistency">eventually consistent</a> </i>. It can take a few seconds for a new or changed element to propagate through the service and be visible in the results of other Verified Permissions operations.</p> </note>', 'CreatePolicyStore' => '<p>Creates a policy store. A policy store is a container for policy resources.</p> <note> <p>Although <a href="https://docs.cedarpolicy.com/schema/schema.html#namespace">Cedar supports multiple namespaces</a>, Verified Permissions currently supports only one namespace per policy store.</p> </note> <note> <p>Verified Permissions is <i> <a href="https://wikipedia.org/wiki/Eventual_consistency">eventually consistent</a> </i>. It can take a few seconds for a new or changed element to propagate through the service and be visible in the results of other Verified Permissions operations.</p> </note>', 'CreatePolicyTemplate' => '<p>Creates a policy template. A template can use placeholders for the principal and resource. A template must be instantiated into a policy by associating it with specific principals and resources to use for the placeholders. That instantiated policy can then be considered in authorization decisions. The instantiated policy works identically to any other policy, except that it is dynamically linked to the template. If the template changes, then any policies that are linked to that template are immediately updated as well.</p> <note> <p>Verified Permissions is <i> <a href="https://wikipedia.org/wiki/Eventual_consistency">eventually consistent</a> </i>. It can take a few seconds for a new or changed element to propagate through the service and be visible in the results of other Verified Permissions operations.</p> </note>', 'DeleteIdentitySource' => '<p>Deletes an identity source that references an identity provider (IdP) such as Amazon Cognito. After you delete the identity source, you can no longer use tokens for identities from that identity source to represent principals in authorization queries made using <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorizedWithToken.html">IsAuthorizedWithToken</a>. operations.</p>', 'DeletePolicy' => '<p>Deletes the specified policy from the policy store.</p> <p>This operation is idempotent; if you specify a policy that doesn\'t exist, the request response returns a successful <code>HTTP 200</code> status code.</p>', 'DeletePolicyStore' => '<p>Deletes the specified policy store.</p> <p>This operation is idempotent. If you specify a policy store that does not exist, the request response will still return a successful HTTP 200 status code.</p>', 'DeletePolicyTemplate' => '<p>Deletes the specified policy template from the policy store.</p> <important> <p>This operation also deletes any policies that were created from the specified policy template. Those policies are immediately removed from all future API responses, and are asynchronously deleted from the policy store.</p> </important>', 'GetIdentitySource' => '<p>Retrieves the details about the specified identity source.</p>', 'GetPolicy' => '<p>Retrieves information about the specified policy.</p>', 'GetPolicyStore' => '<p>Retrieves details about a policy store.</p>', 'GetPolicyTemplate' => '<p>Retrieve the details for the specified policy template in the specified policy store.</p>', 'GetSchema' => '<p>Retrieve the details for the specified schema in the specified policy store.</p>', 'IsAuthorized' => '<p>Makes an authorization decision about a service request described in the parameters. The information in the parameters can also define additional context that Verified Permissions can include in the evaluation. The request is evaluated against all matching policies in the specified policy store. The result of the decision is either <code>Allow</code> or <code>Deny</code>, along with a list of the policies that resulted in the decision.</p>', 'IsAuthorizedWithToken' => '<p>Makes an authorization decision about a service request described in the parameters. The principal in this request comes from an external identity source in the form of an identity token formatted as a <a href="https://wikipedia.org/wiki/JSON_Web_Token">JSON web token (JWT)</a>. The information in the parameters can also define additional context that Verified Permissions can include in the evaluation. The request is evaluated against all matching policies in the specified policy store. The result of the decision is either <code>Allow</code> or <code>Deny</code>, along with a list of the policies that resulted in the decision.</p> <p>At this time, Verified Permissions accepts tokens from only Amazon Cognito.</p> <p>Verified Permissions validates each token that is specified in a request by checking its expiration date and its signature.</p> <important> <p>Tokens from an identity source user continue to be usable until they expire. Token revocation and resource deletion have no effect on the validity of a token in your policy store</p> </important>', 'ListIdentitySources' => '<p>Returns a paginated list of all of the identity sources defined in the specified policy store.</p>', 'ListPolicies' => '<p>Returns a paginated list of all policies stored in the specified policy store.</p>', 'ListPolicyStores' => '<p>Returns a paginated list of all policy stores in the calling Amazon Web Services account.</p>', 'ListPolicyTemplates' => '<p>Returns a paginated list of all policy templates in the specified policy store.</p>', 'PutSchema' => '<p>Creates or updates the policy schema in the specified policy store. The schema is used to validate any Cedar policies and policy templates submitted to the policy store. Any changes to the schema validate only policies and templates submitted after the schema change. Existing policies and templates are not re-evaluated against the changed schema. If you later update a policy, then it is evaluated against the new schema at that time.</p> <note> <p>Verified Permissions is <i> <a href="https://wikipedia.org/wiki/Eventual_consistency">eventually consistent</a> </i>. It can take a few seconds for a new or changed element to propagate through the service and be visible in the results of other Verified Permissions operations.</p> </note>', 'UpdateIdentitySource' => '<p>Updates the specified identity source to use a new identity provider (IdP), or to change the mapping of identities from the IdP to a different principal entity type.</p> <note> <p>Verified Permissions is <i> <a href="https://wikipedia.org/wiki/Eventual_consistency">eventually consistent</a> </i>. It can take a few seconds for a new or changed element to propagate through the service and be visible in the results of other Verified Permissions operations.</p> </note>', 'UpdatePolicy' => '<p>Modifies a Cedar static policy in the specified policy store. You can change only certain elements of the <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicyInput.html#amazonverifiedpermissions-UpdatePolicy-request-UpdatePolicyDefinition">UpdatePolicyDefinition</a> parameter. You can directly update only static policies. To change a template-linked policy, you must update the template instead, using <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicyTemplate.html">UpdatePolicyTemplate</a>.</p> <note> <ul> <li> <p>If policy validation is enabled in the policy store, then updating a static policy causes Verified Permissions to validate the policy against the schema in the policy store. If the updated static policy doesn\'t pass validation, the operation fails and the update isn\'t stored.</p> </li> <li> <p>When you edit a static policy, you can change only certain elements of a static policy:</p> <ul> <li> <p>The action referenced by the policy. </p> </li> <li> <p>A condition clause, such as when and unless. </p> </li> </ul> <p>You can\'t change these elements of a static policy: </p> <ul> <li> <p>Changing a policy from a static policy to a template-linked policy. </p> </li> <li> <p>Changing the effect of a static policy from permit or forbid. </p> </li> <li> <p>The principal referenced by a static policy. </p> </li> <li> <p>The resource referenced by a static policy. </p> </li> </ul> </li> <li> <p>To update a template-linked policy, you must update the template instead. </p> </li> </ul> </note> <note> <p>Verified Permissions is <i> <a href="https://wikipedia.org/wiki/Eventual_consistency">eventually consistent</a> </i>. It can take a few seconds for a new or changed element to propagate through the service and be visible in the results of other Verified Permissions operations.</p> </note>', 'UpdatePolicyStore' => '<p>Modifies the validation setting for a policy store.</p> <note> <p>Verified Permissions is <i> <a href="https://wikipedia.org/wiki/Eventual_consistency">eventually consistent</a> </i>. It can take a few seconds for a new or changed element to propagate through the service and be visible in the results of other Verified Permissions operations.</p> </note>', 'UpdatePolicyTemplate' => '<p>Updates the specified policy template. You can update only the description and the some elements of the <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicyTemplate.html#amazonverifiedpermissions-UpdatePolicyTemplate-request-policyBody">policyBody</a>. </p> <important> <p>Changes you make to the policy template content are immediately (within the constraints of eventual consistency) reflected in authorization decisions that involve all template-linked policies instantiated from this template.</p> </important> <note> <p>Verified Permissions is <i> <a href="https://wikipedia.org/wiki/Eventual_consistency">eventually consistent</a> </i>. It can take a few seconds for a new or changed element to propagate through the service and be visible in the results of other Verified Permissions operations.</p> </note>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You don\'t have sufficient access to perform this action.</p>', 'refs' => [], ], 'ActionId' => [ 'base' => NULL, 'refs' => [ 'ActionIdentifier$actionId' => '<p>The ID of an action.</p>', ], ], 'ActionIdentifier' => [ 'base' => '<p>Contains information about an action for a request for which an authorization decision is made.</p> <p>This data type is used as a request parameter to the <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorized.html">IsAuthorized</a>, <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_BatchIsAuthorized.html">BatchIsAuthorized</a>, and <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorizedWithToken.html">IsAuthorizedWithToken</a> operations.</p> <p>Example: <code>{ "actionId": "&lt;action name&gt;", "actionType": "Action" }</code> </p>', 'refs' => [ 'ActionIdentifierList$member' => NULL, 'BatchIsAuthorizedInputItem$action' => '<p>Specifies the requested action to be authorized. For example, <code>PhotoFlash::ReadPhoto</code>.</p>', 'BatchIsAuthorizedWithTokenInputItem$action' => '<p>Specifies the requested action to be authorized. For example, <code>PhotoFlash::ReadPhoto</code>.</p>', 'IsAuthorizedInput$action' => '<p>Specifies the requested action to be authorized. For example, is the principal authorized to perform this action on the resource?</p>', 'IsAuthorizedWithTokenInput$action' => '<p>Specifies the requested action to be authorized. Is the specified principal authorized to perform this action on the specified resource.</p>', ], ], 'ActionIdentifierList' => [ 'base' => NULL, 'refs' => [ 'CreatePolicyOutput$actions' => '<p>The action that a policy permits or forbids. For example, <code>{"actions": [{"actionId": "ViewPhoto", "actionType": "PhotoFlash::Action"}, {"entityID": "SharePhoto", "entityType": "PhotoFlash::Action"}]}</code>.</p>', 'GetPolicyOutput$actions' => '<p>The action that a policy permits or forbids. For example, <code>{"actions": [{"actionId": "ViewPhoto", "actionType": "PhotoFlash::Action"}, {"entityID": "SharePhoto", "entityType": "PhotoFlash::Action"}]}</code>.</p>', 'PolicyItem$actions' => '<p>The action that a policy permits or forbids. For example, <code>{"actions": [{"actionId": "ViewPhoto", "actionType": "PhotoFlash::Action"}, {"entityID": "SharePhoto", "entityType": "PhotoFlash::Action"}]}</code>.</p>', 'UpdatePolicyOutput$actions' => '<p>The action that a policy permits or forbids. For example, <code>{"actions": [{"actionId": "ViewPhoto", "actionType": "PhotoFlash::Action"}, {"entityID": "SharePhoto", "entityType": "PhotoFlash::Action"}]}</code>.</p>', ], ], 'ActionType' => [ 'base' => NULL, 'refs' => [ 'ActionIdentifier$actionType' => '<p>The type of an action.</p>', ], ], 'AttributeValue' => [ 'base' => '<p>The value of an attribute.</p> <p>Contains information about the runtime context for a request for which an authorization decision is made. </p> <p>This data type is used as a member of the <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ContextDefinition.html">ContextDefinition</a> structure which is uses as a request parameter for the <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorized.html">IsAuthorized</a>, <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_BatchIsAuthorized.html">BatchIsAuthorized</a>, and <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorizedWithToken.html">IsAuthorizedWithToken</a> operations.</p>', 'refs' => [ 'ContextMap$value' => NULL, 'EntityAttributes$value' => NULL, 'RecordAttribute$value' => NULL, 'SetAttribute$member' => NULL, ], ], 'Audience' => [ 'base' => NULL, 'refs' => [ 'Audiences$member' => NULL, ], ], 'Audiences' => [ 'base' => NULL, 'refs' => [ 'OpenIdConnectAccessTokenConfiguration$audiences' => '<p>The access token <code>aud</code> claim values that you want to accept in your policy store. For example, <code>https://myapp.example.com, https://myapp2.example.com</code>.</p>', 'OpenIdConnectAccessTokenConfigurationDetail$audiences' => '<p>The access token <code>aud</code> claim values that you want to accept in your policy store. For example, <code>https://myapp.example.com, https://myapp2.example.com</code>.</p>', 'OpenIdConnectAccessTokenConfigurationItem$audiences' => '<p>The access token <code>aud</code> claim values that you want to accept in your policy store. For example, <code>https://myapp.example.com, https://myapp2.example.com</code>.</p>', 'UpdateOpenIdConnectAccessTokenConfiguration$audiences' => '<p>The access token <code>aud</code> claim values that you want to accept in your policy store. For example, <code>https://myapp.example.com, https://myapp2.example.com</code>.</p>', ], ], 'BatchIsAuthorizedInput' => [ 'base' => NULL, 'refs' => [], ], 'BatchIsAuthorizedInputItem' => [ 'base' => '<p>An authorization request that you include in a <code>BatchIsAuthorized</code> API request.</p>', 'refs' => [ 'BatchIsAuthorizedInputList$member' => NULL, 'BatchIsAuthorizedOutputItem$request' => '<p>The authorization request that initiated the decision.</p>', ], ], 'BatchIsAuthorizedInputList' => [ 'base' => NULL, 'refs' => [ 'BatchIsAuthorizedInput$requests' => '<p>An array of up to 30 requests that you want Verified Permissions to evaluate.</p>', ], ], 'BatchIsAuthorizedOutput' => [ 'base' => NULL, 'refs' => [], ], 'BatchIsAuthorizedOutputItem' => [ 'base' => '<p>The decision, based on policy evaluation, from an individual authorization request in a <code>BatchIsAuthorized</code> API request.</p>', 'refs' => [ 'BatchIsAuthorizedOutputList$member' => NULL, ], ], 'BatchIsAuthorizedOutputList' => [ 'base' => NULL, 'refs' => [ 'BatchIsAuthorizedOutput$results' => '<p>A series of <code>Allow</code> or <code>Deny</code> decisions for each request, and the policies that produced them.</p>', ], ], 'BatchIsAuthorizedWithTokenInput' => [ 'base' => NULL, 'refs' => [], ], 'BatchIsAuthorizedWithTokenInputItem' => [ 'base' => '<p>An authorization request that you include in a <code>BatchIsAuthorizedWithToken</code> API request.</p>', 'refs' => [ 'BatchIsAuthorizedWithTokenInputList$member' => NULL, 'BatchIsAuthorizedWithTokenOutputItem$request' => '<p>The authorization request that initiated the decision.</p>', ], ], 'BatchIsAuthorizedWithTokenInputList' => [ 'base' => NULL, 'refs' => [ 'BatchIsAuthorizedWithTokenInput$requests' => '<p>An array of up to 30 requests that you want Verified Permissions to evaluate.</p>', ], ], 'BatchIsAuthorizedWithTokenOutput' => [ 'base' => NULL, 'refs' => [], ], 'BatchIsAuthorizedWithTokenOutputItem' => [ 'base' => '<p>The decision, based on policy evaluation, from an individual authorization request in a <code>BatchIsAuthorizedWithToken</code> API request.</p>', 'refs' => [ 'BatchIsAuthorizedWithTokenOutputList$member' => NULL, ], ], 'BatchIsAuthorizedWithTokenOutputList' => [ 'base' => NULL, 'refs' => [ 'BatchIsAuthorizedWithTokenOutput$results' => '<p>A series of <code>Allow</code> or <code>Deny</code> decisions for each request, and the policies that produced them.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'EntityReference$unspecified' => '<p>Used to indicate that a principal or resource is not specified. This can be used to search for policies that are not associated with a specific principal or resource.</p>', ], ], 'BooleanAttribute' => [ 'base' => NULL, 'refs' => [ 'AttributeValue$boolean' => '<p>An attribute value of <a href="https://docs.cedarpolicy.com/policies/syntax-datatypes.html#boolean">Boolean</a> type.</p> <p>Example: <code>{"boolean": true}</code> </p>', ], ], 'Claim' => [ 'base' => NULL, 'refs' => [ 'OpenIdConnectAccessTokenConfiguration$principalIdClaim' => '<p>The claim that determines the principal in OIDC access tokens. For example, <code>sub</code>.</p>', 'OpenIdConnectAccessTokenConfigurationDetail$principalIdClaim' => '<p>The claim that determines the principal in OIDC access tokens. For example, <code>sub</code>.</p>', 'OpenIdConnectAccessTokenConfigurationItem$principalIdClaim' => '<p>The claim that determines the principal in OIDC access tokens. For example, <code>sub</code>.</p>', 'OpenIdConnectGroupConfiguration$groupClaim' => '<p>The token claim that you want Verified Permissions to interpret as group membership. For example, <code>groups</code>.</p>', 'OpenIdConnectGroupConfigurationDetail$groupClaim' => '<p>The token claim that you want Verified Permissions to interpret as group membership. For example, <code>groups</code>.</p>', 'OpenIdConnectGroupConfigurationItem$groupClaim' => '<p>The token claim that you want Verified Permissions to interpret as group membership. For example, <code>groups</code>.</p>', 'OpenIdConnectIdentityTokenConfiguration$principalIdClaim' => '<p>The claim that determines the principal in OIDC access tokens. For example, <code>sub</code>.</p>', 'OpenIdConnectIdentityTokenConfigurationDetail$principalIdClaim' => '<p>The claim that determines the principal in OIDC access tokens. For example, <code>sub</code>.</p>', 'OpenIdConnectIdentityTokenConfigurationItem$principalIdClaim' => '<p>The claim that determines the principal in OIDC access tokens. For example, <code>sub</code>.</p>', 'UpdateOpenIdConnectAccessTokenConfiguration$principalIdClaim' => '<p>The claim that determines the principal in OIDC access tokens. For example, <code>sub</code>.</p>', 'UpdateOpenIdConnectGroupConfiguration$groupClaim' => '<p>The token claim that you want Verified Permissions to interpret as group membership. For example, <code>groups</code>.</p>', 'UpdateOpenIdConnectIdentityTokenConfiguration$principalIdClaim' => '<p>The claim that determines the principal in OIDC access tokens. For example, <code>sub</code>.</p>', ], ], 'ClientId' => [ 'base' => NULL, 'refs' => [ 'ClientIds$member' => NULL, ], ], 'ClientIds' => [ 'base' => NULL, 'refs' => [ 'CognitoUserPoolConfiguration$clientIds' => '<p>The unique application client IDs that are associated with the specified Amazon Cognito user pool.</p> <p>Example: <code>"ClientIds": ["&amp;ExampleCogClientId;"]</code> </p>', 'CognitoUserPoolConfigurationDetail$clientIds' => '<p>The unique application client IDs that are associated with the specified Amazon Cognito user pool.</p> <p>Example: <code>"clientIds": ["&amp;ExampleCogClientId;"]</code> </p>', 'CognitoUserPoolConfigurationItem$clientIds' => '<p>The unique application client IDs that are associated with the specified Amazon Cognito user pool.</p> <p>Example: <code>"clientIds": ["&amp;ExampleCogClientId;"]</code> </p>', 'IdentitySourceDetails$clientIds' => '<p>The application client IDs associated with the specified Amazon Cognito user pool that are enabled for this identity source.</p>', 'IdentitySourceItemDetails$clientIds' => '<p>The application client IDs associated with the specified Amazon Cognito user pool that are enabled for this identity source.</p>', 'OpenIdConnectIdentityTokenConfiguration$clientIds' => '<p>The ID token audience, or client ID, claim values that you want to accept in your policy store from an OIDC identity provider. For example, <code>1example23456789, 2example10111213</code>.</p>', 'OpenIdConnectIdentityTokenConfigurationDetail$clientIds' => '<p>The ID token audience, or client ID, claim values that you want to accept in your policy store from an OIDC identity provider. For example, <code>1example23456789, 2example10111213</code>.</p>', 'OpenIdConnectIdentityTokenConfigurationItem$clientIds' => '<p>The ID token audience, or client ID, claim values that you want to accept in your policy store from an OIDC identity provider. For example, <code>1example23456789, 2example10111213</code>.</p>', 'UpdateCognitoUserPoolConfiguration$clientIds' => '<p>The client ID of an app client that is configured for the specified Amazon Cognito user pool.</p>', 'UpdateOpenIdConnectIdentityTokenConfiguration$clientIds' => '<p>The ID token audience, or client ID, claim values that you want to accept in your policy store from an OIDC identity provider. For example, <code>1example23456789, 2example10111213</code>.</p>', ], ], 'CognitoGroupConfiguration' => [ 'base' => '<p>The type of entity that a policy store maps to groups from an Amazon Cognito user pool identity source.</p> <p>This data type is part of a <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CognitoUserPoolConfiguration.html">CognitoUserPoolConfiguration</a> structure and is a request parameter in <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreateIdentitySource.html">CreateIdentitySource</a>.</p>', 'refs' => [ 'CognitoUserPoolConfiguration$groupConfiguration' => '<p>The type of entity that a policy store maps to groups from an Amazon Cognito user pool identity source.</p>', ], ], 'CognitoGroupConfigurationDetail' => [ 'base' => '<p>The type of entity that a policy store maps to groups from an Amazon Cognito user pool identity source.</p> <p>This data type is part of an <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CognitoUserPoolConfigurationItem.html">CognitoUserPoolConfigurationDetail</a> structure and is a response parameter to <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_GetIdentitySource.html">GetIdentitySource</a>.</p>', 'refs' => [ 'CognitoUserPoolConfigurationDetail$groupConfiguration' => '<p>The type of entity that a policy store maps to groups from an Amazon Cognito user pool identity source.</p>', ], ], 'CognitoGroupConfigurationItem' => [ 'base' => '<p>The type of entity that a policy store maps to groups from an Amazon Cognito user pool identity source.</p> <p>This data type is part of an <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CognitoUserPoolConfigurationDetail.html">CognitoUserPoolConfigurationItem</a> structure and is a response parameter to <a href="http://forums.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListIdentitySources.html">ListIdentitySources</a>.</p>', 'refs' => [ 'CognitoUserPoolConfigurationItem$groupConfiguration' => '<p>The type of entity that a policy store maps to groups from an Amazon Cognito user pool identity source.</p>', ], ], 'CognitoUserPoolConfiguration' => [ 'base' => '<p>The configuration for an identity source that represents a connection to an Amazon Cognito user pool used as an identity provider for Verified Permissions.</p> <p>This data type part of a <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_Configuration.html">Configuration</a> structure that is used as a parameter to <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreateIdentitySource.html">CreateIdentitySource</a>.</p> <p>Example:<code>"CognitoUserPoolConfiguration":{"UserPoolArn":"arn:aws:cognito-idp:us-east-1:123456789012:userpool/us-east-1_1a2b3c4d5","ClientIds": ["a1b2c3d4e5f6g7h8i9j0kalbmc"],"groupConfiguration": {"groupEntityType": "MyCorp::Group"}}</code> </p>', 'refs' => [ 'Configuration$cognitoUserPoolConfiguration' => '<p>Contains configuration details of a Amazon Cognito user pool that Verified Permissions can use as a source of authenticated identities as entities. It specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name (ARN)</a> of a Amazon Cognito user pool and one or more application client IDs.</p> <p>Example: <code>"configuration":{"cognitoUserPoolConfiguration":{"userPoolArn":"arn:aws:cognito-idp:us-east-1:123456789012:userpool/us-east-1_1a2b3c4d5","clientIds": ["a1b2c3d4e5f6g7h8i9j0kalbmc"],"groupConfiguration": {"groupEntityType": "MyCorp::Group"}}}</code> </p>', ], ], 'CognitoUserPoolConfigurationDetail' => [ 'base' => '<p>The configuration for an identity source that represents a connection to an Amazon Cognito user pool used as an identity provider for Verified Permissions.</p> <p>This data type is used as a field that is part of an <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ConfigurationDetail.html">ConfigurationDetail</a> structure that is part of the response to <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_GetIdentitySource.html">GetIdentitySource</a>.</p> <p>Example:<code>"CognitoUserPoolConfiguration":{"UserPoolArn":"arn:aws:cognito-idp:us-east-1:123456789012:userpool/us-east-1_1a2b3c4d5","ClientIds": ["a1b2c3d4e5f6g7h8i9j0kalbmc"],"groupConfiguration": {"groupEntityType": "MyCorp::Group"}}</code> </p>', 'refs' => [ 'ConfigurationDetail$cognitoUserPoolConfiguration' => '<p>Contains configuration details of a Amazon Cognito user pool that Verified Permissions can use as a source of authenticated identities as entities. It specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name (ARN)</a> of a Amazon Cognito user pool, the policy store entity that you want to assign to user groups, and one or more application client IDs.</p> <p>Example: <code>"configuration":{"cognitoUserPoolConfiguration":{"userPoolArn":"arn:aws:cognito-idp:us-east-1:123456789012:userpool/us-east-1_1a2b3c4d5","clientIds": ["a1b2c3d4e5f6g7h8i9j0kalbmc"],"groupConfiguration": {"groupEntityType": "MyCorp::Group"}}}</code> </p>', ], ], 'CognitoUserPoolConfigurationItem' => [ 'base' => '<p>The configuration for an identity source that represents a connection to an Amazon Cognito user pool used as an identity provider for Verified Permissions.</p> <p>This data type is used as a field that is part of the <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ConfigurationItem.html">ConfigurationItem</a> structure that is part of the response to <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListIdentitySources.html">ListIdentitySources</a>.</p> <p>Example:<code>"CognitoUserPoolConfiguration":{"UserPoolArn":"arn:aws:cognito-idp:us-east-1:123456789012:userpool/us-east-1_1a2b3c4d5","ClientIds": ["a1b2c3d4e5f6g7h8i9j0kalbmc"],"groupConfiguration": {"groupEntityType": "MyCorp::Group"}}</code> </p>', 'refs' => [ 'ConfigurationItem$cognitoUserPoolConfiguration' => '<p>Contains configuration details of a Amazon Cognito user pool that Verified Permissions can use as a source of authenticated identities as entities. It specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name (ARN)</a> of a Amazon Cognito user pool, the policy store entity that you want to assign to user groups, and one or more application client IDs.</p> <p>Example: <code>"configuration":{"cognitoUserPoolConfiguration":{"userPoolArn":"arn:aws:cognito-idp:us-east-1:123456789012:userpool/us-east-1_1a2b3c4d5","clientIds": ["a1b2c3d4e5f6g7h8i9j0kalbmc"],"groupConfiguration": {"groupEntityType": "MyCorp::Group"}}}</code> </p>', ], ], 'Configuration' => [ 'base' => '<p>Contains configuration information used when creating a new identity source.</p> <p>This data type is used as a request parameter for the <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreateIdentitySource.html">CreateIdentitySource</a> operation.</p>', 'refs' => [ 'CreateIdentitySourceInput$configuration' => '<p>Specifies the details required to communicate with the identity provider (IdP) associated with this identity source.</p>', ], ], 'ConfigurationDetail' => [ 'base' => '<p>Contains configuration information about an identity source.</p> <p>This data type is a response parameter to the <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_GetIdentitySource.html">GetIdentitySource</a> operation.</p>', 'refs' => [ 'GetIdentitySourceOutput$configuration' => '<p>Contains configuration information about an identity source.</p>', ], ], 'ConfigurationItem' => [ 'base' => '<p>Contains configuration information about an identity source.</p> <p>This data type is a response parameter to the <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListIdentitySources.html">ListIdentitySources</a> operation.</p>', 'refs' => [ 'IdentitySourceItem$configuration' => '<p>Contains configuration information about an identity source.</p>', ], ], 'ConflictException' => [ 'base' => '<p>The request failed because another request to modify a resource occurred at the same.</p>', 'refs' => [], ], 'ContextDefinition' => [ 'base' => '<p>Contains additional details about the context of the request. Verified Permissions evaluates this information in an authorization request as part of the <code>when</code> and <code>unless</code> clauses in a policy.</p> <p>This data type is used as a request parameter for the <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorized.html">IsAuthorized</a>, <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_BatchIsAuthorized.html">BatchIsAuthorized</a>, and <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorizedWithToken.html">IsAuthorizedWithToken</a> operations.</p> <p>Example: <code>"context":{"contextMap":{"&lt;KeyName1&gt;":{"boolean":true},"&lt;KeyName2&gt;":{"long":1234}}}</code> </p>', 'refs' => [ 'BatchIsAuthorizedInputItem$context' => '<p>Specifies additional context that can be used to make more granular authorization decisions.</p>', 'BatchIsAuthorizedWithTokenInputItem$context' => '<p>Specifies additional context that can be used to make more granular authorization decisions.</p>', 'IsAuthorizedInput$context' => '<p>Specifies additional context that can be used to make more granular authorization decisions.</p>', 'IsAuthorizedWithTokenInput$context' => '<p>Specifies additional context that can be used to make more granular authorization decisions.</p>', ], ], 'ContextMap' => [ 'base' => NULL, 'refs' => [ 'ContextDefinition$contextMap' => '<p>An list of attributes that are needed to successfully evaluate an authorization request. Each attribute in this array must include a map of a data type and its value.</p> <p>Example: <code>"contextMap":{"&lt;KeyName1&gt;":{"boolean":true},"&lt;KeyName2&gt;":{"long":1234}}</code> </p>', ], ], 'CreateIdentitySourceInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateIdentitySourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreatePolicyInput' => [ 'base' => NULL, 'refs' => [], ], 'CreatePolicyOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreatePolicyStoreInput' => [ 'base' => NULL, 'refs' => [], ], 'CreatePolicyStoreOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreatePolicyTemplateInput' => [ 'base' => NULL, 'refs' => [], ], 'CreatePolicyTemplateOutput' => [ 'base' => NULL, 'refs' => [], ], 'Decision' => [ 'base' => NULL, 'refs' => [ 'BatchIsAuthorizedOutputItem$decision' => '<p>An authorization decision that indicates if the authorization request should be allowed or denied.</p>', 'BatchIsAuthorizedWithTokenOutputItem$decision' => '<p>An authorization decision that indicates if the authorization request should be allowed or denied.</p>', 'IsAuthorizedOutput$decision' => '<p>An authorization decision that indicates if the authorization request should be allowed or denied.</p>', 'IsAuthorizedWithTokenOutput$decision' => '<p>An authorization decision that indicates if the authorization request should be allowed or denied.</p>', ], ], 'DeleteIdentitySourceInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteIdentitySourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeletePolicyInput' => [ 'base' => NULL, 'refs' => [], ], 'DeletePolicyOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeletePolicyStoreInput' => [ 'base' => NULL, 'refs' => [], ], 'DeletePolicyStoreOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeletePolicyTemplateInput' => [ 'base' => NULL, 'refs' => [], ], 'DeletePolicyTemplateOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeterminingPolicyItem' => [ 'base' => '<p>Contains information about one of the policies that determined an authorization decision.</p> <p>This data type is used as an element in a response parameter for the <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorized.html">IsAuthorized</a>, <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_BatchIsAuthorized.html">BatchIsAuthorized</a>, and <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorizedWithToken.html">IsAuthorizedWithToken</a> operations.</p> <p>Example: <code>"determiningPolicies":[{"policyId":"SPEXAMPLEabcdefg111111"}]</code> </p>', 'refs' => [ 'DeterminingPolicyList$member' => NULL, ], ], 'DeterminingPolicyList' => [ 'base' => NULL, 'refs' => [ 'BatchIsAuthorizedOutputItem$determiningPolicies' => '<p>The list of determining policies used to make the authorization decision. For example, if there are two matching policies, where one is a forbid and the other is a permit, then the forbid policy will be the determining policy. In the case of multiple matching permit policies then there would be multiple determining policies. In the case that no policies match, and hence the response is DENY, there would be no determining policies.</p>', 'BatchIsAuthorizedWithTokenOutputItem$determiningPolicies' => '<p>The list of determining policies used to make the authorization decision. For example, if there are two matching policies, where one is a forbid and the other is a permit, then the forbid policy will be the determining policy. In the case of multiple matching permit policies then there would be multiple determining policies. In the case that no policies match, and hence the response is DENY, there would be no determining policies.</p>', 'IsAuthorizedOutput$determiningPolicies' => '<p>The list of determining policies used to make the authorization decision. For example, if there are two matching policies, where one is a forbid and the other is a permit, then the forbid policy will be the determining policy. In the case of multiple matching permit policies then there would be multiple determining policies. In the case that no policies match, and hence the response is DENY, there would be no determining policies.</p>', 'IsAuthorizedWithTokenOutput$determiningPolicies' => '<p>The list of determining policies used to make the authorization decision. For example, if there are multiple matching policies, where at least one is a forbid policy, then because forbid always overrides permit the forbid policies are the determining policies. If all matching policies are permit policies, then those policies are the determining policies. When no policies match and the response is the default DENY, there are no determining policies.</p>', ], ], 'DiscoveryUrl' => [ 'base' => NULL, 'refs' => [ 'IdentitySourceDetails$discoveryUrl' => '<p>The well-known URL that points to this user pool\'s OIDC discovery endpoint. This is a URL string in the following format. This URL replaces the placeholders for both the Amazon Web Services Region and the user pool identifier with those appropriate for this user pool.</p> <p> <code>https://cognito-idp.<i>&lt;region&gt;</i>.amazonaws.com/<i>&lt;user-pool-id&gt;</i>/.well-known/openid-configuration</code> </p>', 'IdentitySourceItemDetails$discoveryUrl' => '<p>The well-known URL that points to this user pool\'s OIDC discovery endpoint. This is a URL string in the following format. This URL replaces the placeholders for both the Amazon Web Services Region and the user pool identifier with those appropriate for this user pool.</p> <p> <code>https://cognito-idp.<i>&lt;region&gt;</i>.amazonaws.com/<i>&lt;user-pool-id&gt;</i>/.well-known/openid-configuration</code> </p>', ], ], 'EntitiesDefinition' => [ 'base' => '<p>Contains the list of entities to be considered during an authorization request. This includes all principals, resources, and actions required to successfully evaluate the request.</p> <p>This data type is used as a field in the response parameter for the <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorized.html">IsAuthorized</a> and <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorizedWithToken.html">IsAuthorizedWithToken</a> operations.</p>', 'refs' => [ 'BatchIsAuthorizedInput$entities' => '<p>Specifies the list of resources and principals and their associated attributes that Verified Permissions can examine when evaluating the policies. </p> <note> <p>You can include only principal and resource entities in this parameter; you can\'t include actions. You must specify actions in the schema.</p> </note>', 'BatchIsAuthorizedWithTokenInput$entities' => '<p>Specifies the list of resources and their associated attributes that Verified Permissions can examine when evaluating the policies. </p> <important> <p>You can\'t include principals in this parameter, only resource and action entities. This parameter can\'t include any entities of a type that matches the user or group entity types that you defined in your identity source.</p> <ul> <li> <p>The <code>BatchIsAuthorizedWithToken</code> operation takes principal attributes from <b> <i>only</i> </b> the <code>identityToken</code> or <code>accessToken</code> passed to the operation.</p> </li> <li> <p>For action entities, you can include only their <code>Identifier</code> and <code>EntityType</code>. </p> </li> </ul> </important>', 'IsAuthorizedInput$entities' => '<p>Specifies the list of resources and principals and their associated attributes that Verified Permissions can examine when evaluating the policies. </p> <note> <p>You can include only principal and resource entities in this parameter; you can\'t include actions. You must specify actions in the schema.</p> </note>', 'IsAuthorizedWithTokenInput$entities' => '<p>Specifies the list of resources and their associated attributes that Verified Permissions can examine when evaluating the policies. </p> <important> <p>You can\'t include principals in this parameter, only resource and action entities. This parameter can\'t include any entities of a type that matches the user or group entity types that you defined in your identity source.</p> <ul> <li> <p>The <code>IsAuthorizedWithToken</code> operation takes principal attributes from <b> <i>only</i> </b> the <code>identityToken</code> or <code>accessToken</code> passed to the operation.</p> </li> <li> <p>For action entities, you can include only their <code>Identifier</code> and <code>EntityType</code>. </p> </li> </ul> </important>', ], ], 'EntityAttributes' => [ 'base' => NULL, 'refs' => [ 'EntityItem$attributes' => '<p>A list of attributes for the entity.</p>', ], ], 'EntityId' => [ 'base' => NULL, 'refs' => [ 'EntityIdentifier$entityId' => '<p>The identifier of an entity.</p> <p> <code>"entityId":"<i>identifier</i>"</code> </p>', ], ], 'EntityIdPrefix' => [ 'base' => NULL, 'refs' => [ 'OpenIdConnectConfiguration$entityIdPrefix' => '<p>A descriptive string that you want to prefix to user entities from your OIDC identity provider. For example, if you set an <code>entityIdPrefix</code> of <code>MyOIDCProvider</code>, you can reference principals in your policies in the format <code>MyCorp::User::MyOIDCProvider|Carlos</code>.</p>', 'OpenIdConnectConfigurationDetail$entityIdPrefix' => '<p>A descriptive string that you want to prefix to user entities from your OIDC identity provider. For example, if you set an <code>entityIdPrefix</code> of <code>MyOIDCProvider</code>, you can reference principals in your policies in the format <code>MyCorp::User::MyOIDCProvider|Carlos</code>.</p>', 'OpenIdConnectConfigurationItem$entityIdPrefix' => '<p>A descriptive string that you want to prefix to user entities from your OIDC identity provider. For example, if you set an <code>entityIdPrefix</code> of <code>MyOIDCProvider</code>, you can reference principals in your policies in the format <code>MyCorp::User::MyOIDCProvider|Carlos</code>.</p>', 'UpdateOpenIdConnectConfiguration$entityIdPrefix' => '<p>A descriptive string that you want to prefix to user entities from your OIDC identity provider. For example, if you set an <code>entityIdPrefix</code> of <code>MyOIDCProvider</code>, you can reference principals in your policies in the format <code>MyCorp::User::MyOIDCProvider|Carlos</code>.</p>', ], ], 'EntityIdentifier' => [ 'base' => '<p>Contains the identifier of an entity, including its ID and type.</p> <p>This data type is used as a request parameter for <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorized.html">IsAuthorized</a> operation, and as a response parameter for the <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreatePolicy.html">CreatePolicy</a>, <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_GetPolicy.html">GetPolicy</a>, and <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicy.html">UpdatePolicy</a> operations.</p> <p>Example: <code>{"entityId":"<i>string</i>","entityType":"<i>string</i>"}</code> </p>', 'refs' => [ 'AttributeValue$entityIdentifier' => '<p>An attribute value of type <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_EntityIdentifier.html">EntityIdentifier</a>.</p> <p>Example: <code>"entityIdentifier": { "entityId": "&lt;id&gt;", "entityType": "&lt;entity type&gt;"}</code> </p>', 'BatchIsAuthorizedInputItem$principal' => '<p>Specifies the principal for which the authorization decision is to be made.</p>', 'BatchIsAuthorizedInputItem$resource' => '<p>Specifies the resource that you want an authorization decision for. For example, <code>PhotoFlash::Photo</code>.</p>', 'BatchIsAuthorizedWithTokenInputItem$resource' => '<p>Specifies the resource that you want an authorization decision for. For example, <code>PhotoFlash::Photo</code>.</p>', 'BatchIsAuthorizedWithTokenOutput$principal' => '<p>The identifier of the principal in the ID or access token.</p>', 'CreatePolicyOutput$principal' => '<p>The principal specified in the new policy\'s scope. This response element isn\'t present when <code>principal</code> isn\'t specified in the policy content.</p>', 'CreatePolicyOutput$resource' => '<p>The resource specified in the new policy\'s scope. This response element isn\'t present when the <code>resource</code> isn\'t specified in the policy content.</p>', 'EntityItem$identifier' => '<p>The identifier of the entity.</p>', 'EntityReference$identifier' => '<p>The identifier of the entity. It can consist of either an EntityType and EntityId, a principal, or a resource.</p>', 'GetPolicyOutput$principal' => '<p>The principal specified in the policy\'s scope. This element isn\'t included in the response when <code>Principal</code> isn\'t present in the policy content.</p>', 'GetPolicyOutput$resource' => '<p>The resource specified in the policy\'s scope. This element isn\'t included in the response when <code>Resource</code> isn\'t present in the policy content.</p>', 'IsAuthorizedInput$principal' => '<p>Specifies the principal for which the authorization decision is to be made.</p>', 'IsAuthorizedInput$resource' => '<p>Specifies the resource for which the authorization decision is to be made.</p>', 'IsAuthorizedWithTokenInput$resource' => '<p>Specifies the resource for which the authorization decision is made. For example, is the principal allowed to perform the action on the resource?</p>', 'IsAuthorizedWithTokenOutput$principal' => '<p>The identifier of the principal in the ID or access token.</p>', 'ParentList$member' => NULL, 'PolicyItem$principal' => '<p>The principal associated with the policy.</p>', 'PolicyItem$resource' => '<p>The resource associated with the policy.</p>', 'TemplateLinkedPolicyDefinition$principal' => '<p>The principal associated with this template-linked policy. Verified Permissions substitutes this principal for the <code>?principal</code> placeholder in the policy template when it evaluates an authorization request.</p>', 'TemplateLinkedPolicyDefinition$resource' => '<p>The resource associated with this template-linked policy. Verified Permissions substitutes this resource for the <code>?resource</code> placeholder in the policy template when it evaluates an authorization request.</p>', 'TemplateLinkedPolicyDefinitionDetail$principal' => '<p>The principal associated with this template-linked policy. Verified Permissions substitutes this principal for the <code>?principal</code> placeholder in the policy template when it evaluates an authorization request.</p>', 'TemplateLinkedPolicyDefinitionDetail$resource' => '<p>The resource associated with this template-linked policy. Verified Permissions substitutes this resource for the <code>?resource</code> placeholder in the policy template when it evaluates an authorization request.</p>', 'TemplateLinkedPolicyDefinitionItem$principal' => '<p>The principal associated with this template-linked policy. Verified Permissions substitutes this principal for the <code>?principal</code> placeholder in the policy template when it evaluates an authorization request.</p>', 'TemplateLinkedPolicyDefinitionItem$resource' => '<p>The resource associated with this template-linked policy. Verified Permissions substitutes this resource for the <code>?resource</code> placeholder in the policy template when it evaluates an authorization request.</p>', 'UpdatePolicyOutput$principal' => '<p>The principal specified in the policy\'s scope. This element isn\'t included in the response when <code>Principal</code> isn\'t present in the policy content.</p>', 'UpdatePolicyOutput$resource' => '<p>The resource specified in the policy\'s scope. This element isn\'t included in the response when <code>Resource</code> isn\'t present in the policy content.</p>', ], ], 'EntityItem' => [ 'base' => '<p>Contains information about an entity that can be referenced in a Cedar policy.</p> <p>This data type is used as one of the fields in the <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_EntitiesDefinition.html">EntitiesDefinition</a> structure.</p> <p> <code>{ "identifier": { "entityType": "Photo", "entityId": "VacationPhoto94.jpg" }, "attributes": {}, "parents": [ { "entityType": "Album", "entityId": "alice_folder" } ] }</code> </p>', 'refs' => [ 'EntityList$member' => NULL, ], ], 'EntityList' => [ 'base' => NULL, 'refs' => [ 'EntitiesDefinition$entityList' => '<p>An array of entities that are needed to successfully evaluate an authorization request. Each entity in this array must include an identifier for the entity, the attributes of the entity, and a list of any parent entities.</p>', ], ], 'EntityReference' => [ 'base' => '<p>Contains information about a principal or resource that can be referenced in a Cedar policy.</p> <p>This data type is used as part of the <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_PolicyFilter.html">PolicyFilter</a> structure that is used as a request parameter for the <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListPolicies.html">ListPolicies</a> operation..</p>', 'refs' => [ 'PolicyFilter$principal' => '<p>Filters the output to only policies that reference the specified principal.</p>', 'PolicyFilter$resource' => '<p>Filters the output to only policies that reference the specified resource.</p>', ], ], 'EntityType' => [ 'base' => NULL, 'refs' => [ 'EntityIdentifier$entityType' => '<p>The type of an entity.</p> <p>Example: <code>"entityType":"<i>typeName</i>"</code> </p>', ], ], 'EvaluationErrorItem' => [ 'base' => '<p>Contains a description of an evaluation error.</p> <p>This data type is a response parameter of the <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorized.html">IsAuthorized</a>, <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_BatchIsAuthorized.html">BatchIsAuthorized</a>, and <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorizedWithToken.html">IsAuthorizedWithToken</a> operations.</p>', 'refs' => [ 'EvaluationErrorList$member' => NULL, ], ], 'EvaluationErrorList' => [ 'base' => NULL, 'refs' => [ 'BatchIsAuthorizedOutputItem$errors' => '<p>Errors that occurred while making an authorization decision. For example, a policy might reference an entity or attribute that doesn\'t exist in the request.</p>', 'BatchIsAuthorizedWithTokenOutputItem$errors' => '<p>Errors that occurred while making an authorization decision. For example, a policy might reference an entity or attribute that doesn\'t exist in the request.</p>', 'IsAuthorizedOutput$errors' => '<p>Errors that occurred while making an authorization decision, for example, a policy references an Entity or entity Attribute that does not exist in the slice.</p>', 'IsAuthorizedWithTokenOutput$errors' => '<p>Errors that occurred while making an authorization decision. For example, a policy references an entity or entity attribute that does not exist in the slice.</p>', ], ], 'GetIdentitySourceInput' => [ 'base' => NULL, 'refs' => [], ], 'GetIdentitySourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetPolicyInput' => [ 'base' => NULL, 'refs' => [], ], 'GetPolicyOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetPolicyStoreInput' => [ 'base' => NULL, 'refs' => [], ], 'GetPolicyStoreOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetPolicyTemplateInput' => [ 'base' => NULL, 'refs' => [], ], 'GetPolicyTemplateOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetSchemaInput' => [ 'base' => NULL, 'refs' => [], ], 'GetSchemaOutput' => [ 'base' => NULL, 'refs' => [], ], 'GroupEntityType' => [ 'base' => NULL, 'refs' => [ 'CognitoGroupConfiguration$groupEntityType' => '<p>The name of the schema entity type that\'s mapped to the user pool group. Defaults to <code>AWS::CognitoGroup</code>.</p>', 'CognitoGroupConfigurationDetail$groupEntityType' => '<p>The name of the schema entity type that\'s mapped to the user pool group. Defaults to <code>AWS::CognitoGroup</code>.</p>', 'CognitoGroupConfigurationItem$groupEntityType' => '<p>The name of the schema entity type that\'s mapped to the user pool group. Defaults to <code>AWS::CognitoGroup</code>.</p>', 'OpenIdConnectGroupConfiguration$groupEntityType' => '<p>The policy store entity type that you want to map your users\' group claim to. For example, <code>MyCorp::UserGroup</code>. A group entity type is an entity that can have a user entity type as a member.</p>', 'OpenIdConnectGroupConfigurationDetail$groupEntityType' => '<p>The policy store entity type that you want to map your users\' group claim to. For example, <code>MyCorp::UserGroup</code>. A group entity type is an entity that can have a user entity type as a member.</p>', 'OpenIdConnectGroupConfigurationItem$groupEntityType' => '<p>The policy store entity type that you want to map your users\' group claim to. For example, <code>MyCorp::UserGroup</code>. A group entity type is an entity that can have a user entity type as a member.</p>', 'UpdateCognitoGroupConfiguration$groupEntityType' => '<p>The name of the schema entity type that\'s mapped to the user pool group. Defaults to <code>AWS::CognitoGroup</code>.</p>', 'UpdateOpenIdConnectGroupConfiguration$groupEntityType' => '<p>The policy store entity type that you want to map your users\' group claim to. For example, <code>MyCorp::UserGroup</code>. A group entity type is an entity that can have a user entity type as a member.</p>', ], ], 'IdempotencyToken' => [ 'base' => NULL, 'refs' => [ 'CreateIdentitySourceInput$clientToken' => '<p>Specifies a unique, case-sensitive ID that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.</p> <p>If you don\'t provide this value, then Amazon Web Services generates a random one for you.</p> <p>If you retry the operation with the same <code>ClientToken</code>, but with different parameters, the retry fails with an <code>ConflictException</code> error.</p> <p>Verified Permissions recognizes a <code>ClientToken</code> for eight hours. After eight hours, the next request with the same parameters performs the operation again regardless of the value of <code>ClientToken</code>.</p>', 'CreatePolicyInput$clientToken' => '<p>Specifies a unique, case-sensitive ID that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.</p> <p>If you don\'t provide this value, then Amazon Web Services generates a random one for you.</p> <p>If you retry the operation with the same <code>ClientToken</code>, but with different parameters, the retry fails with an <code>ConflictException</code> error.</p> <p>Verified Permissions recognizes a <code>ClientToken</code> for eight hours. After eight hours, the next request with the same parameters performs the operation again regardless of the value of <code>ClientToken</code>.</p>', 'CreatePolicyStoreInput$clientToken' => '<p>Specifies a unique, case-sensitive ID that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.</p> <p>If you don\'t provide this value, then Amazon Web Services generates a random one for you.</p> <p>If you retry the operation with the same <code>ClientToken</code>, but with different parameters, the retry fails with an <code>ConflictException</code> error.</p> <p>Verified Permissions recognizes a <code>ClientToken</code> for eight hours. After eight hours, the next request with the same parameters performs the operation again regardless of the value of <code>ClientToken</code>.</p>', 'CreatePolicyTemplateInput$clientToken' => '<p>Specifies a unique, case-sensitive ID that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.</p> <p>If you don\'t provide this value, then Amazon Web Services generates a random one for you.</p> <p>If you retry the operation with the same <code>ClientToken</code>, but with different parameters, the retry fails with an <code>ConflictException</code> error.</p> <p>Verified Permissions recognizes a <code>ClientToken</code> for eight hours. After eight hours, the next request with the same parameters performs the operation again regardless of the value of <code>ClientToken</code>.</p>', ], ], 'IdentitySourceDetails' => [ 'base' => '<p>A structure that contains configuration of the identity source.</p> <p>This data type was a response parameter for the <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_GetIdentitySource.html">GetIdentitySource</a> operation. Replaced by <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ConfigurationDetail.html">ConfigurationDetail</a>.</p>', 'refs' => [ 'GetIdentitySourceOutput$details' => '<p>A structure that describes the configuration of the identity source.</p>', ], ], 'IdentitySourceFilter' => [ 'base' => '<p>A structure that defines characteristics of an identity source that you can use to filter.</p> <p>This data type is a request parameter for the <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListIdentityStores.html">ListIdentityStores</a> operation.</p>', 'refs' => [ 'IdentitySourceFilters$member' => NULL, ], ], 'IdentitySourceFilters' => [ 'base' => NULL, 'refs' => [ 'ListIdentitySourcesInput$filters' => '<p>Specifies characteristics of an identity source that you can use to limit the output to matching identity sources.</p>', ], ], 'IdentitySourceId' => [ 'base' => NULL, 'refs' => [ 'CreateIdentitySourceOutput$identitySourceId' => '<p>The unique ID of the new identity source.</p>', 'DeleteIdentitySourceInput$identitySourceId' => '<p>Specifies the ID of the identity source that you want to delete.</p>', 'GetIdentitySourceInput$identitySourceId' => '<p>Specifies the ID of the identity source you want information about.</p>', 'GetIdentitySourceOutput$identitySourceId' => '<p>The ID of the identity source.</p>', 'IdentitySourceItem$identitySourceId' => '<p>The unique identifier of the identity source.</p>', 'UpdateIdentitySourceInput$identitySourceId' => '<p>Specifies the ID of the identity source that you want to update.</p>', 'UpdateIdentitySourceOutput$identitySourceId' => '<p>The ID of the updated identity source.</p>', ], ], 'IdentitySourceItem' => [ 'base' => '<p>A structure that defines an identity source.</p> <p>This data type is a response parameter to the <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListIdentitySources.html">ListIdentitySources</a> operation.</p>', 'refs' => [ 'IdentitySources$member' => NULL, ], ], 'IdentitySourceItemDetails' => [ 'base' => '<p>A structure that contains configuration of the identity source.</p> <p>This data type was a response parameter for the <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListIdentitySources.html">ListIdentitySources</a> operation. Replaced by <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ConfigurationItem.html">ConfigurationItem</a>.</p>', 'refs' => [ 'IdentitySourceItem$details' => '<p>A structure that contains the details of the associated identity provider (IdP).</p>', ], ], 'IdentitySources' => [ 'base' => NULL, 'refs' => [ 'ListIdentitySourcesOutput$identitySources' => '<p>The list of identity sources stored in the specified policy store.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>The request failed because of an internal error. Try your request again later</p>', 'refs' => [], ], 'IsAuthorizedInput' => [ 'base' => NULL, 'refs' => [], ], 'IsAuthorizedOutput' => [ 'base' => NULL, 'refs' => [], ], 'IsAuthorizedWithTokenInput' => [ 'base' => NULL, 'refs' => [], ], 'IsAuthorizedWithTokenOutput' => [ 'base' => NULL, 'refs' => [], ], 'Issuer' => [ 'base' => NULL, 'refs' => [ 'CognitoUserPoolConfigurationDetail$issuer' => '<p>The OpenID Connect (OIDC) <code>issuer</code> ID of the Amazon Cognito user pool that contains the identities to be authorized.</p> <p>Example: <code>"issuer": "https://cognito-idp.us-east-1.amazonaws.com/us-east-1_1a2b3c4d5"</code> </p>', 'CognitoUserPoolConfigurationItem$issuer' => '<p>The OpenID Connect (OIDC) <code>issuer</code> ID of the Amazon Cognito user pool that contains the identities to be authorized.</p> <p>Example: <code>"issuer": "https://cognito-idp.us-east-1.amazonaws.com/us-east-1_1a2b3c4d5"</code> </p>', 'OpenIdConnectConfiguration$issuer' => '<p>The issuer URL of an OIDC identity provider. This URL must have an OIDC discovery endpoint at the path <code>.well-known/openid-configuration</code>.</p>', 'OpenIdConnectConfigurationDetail$issuer' => '<p>The issuer URL of an OIDC identity provider. This URL must have an OIDC discovery endpoint at the path <code>.well-known/openid-configuration</code>.</p>', 'OpenIdConnectConfigurationItem$issuer' => '<p>The issuer URL of an OIDC identity provider. This URL must have an OIDC discovery endpoint at the path <code>.well-known/openid-configuration</code>.</p>', 'UpdateOpenIdConnectConfiguration$issuer' => '<p>The issuer URL of an OIDC identity provider. This URL must have an OIDC discovery endpoint at the path <code>.well-known/openid-configuration</code>.</p>', ], ], 'ListIdentitySourcesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListIdentitySourcesMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListIdentitySourcesInput$maxResults' => '<p>Specifies the total number of results that you want included in each response. If additional items exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next set of results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p> <p>If you do not specify this parameter, the operation defaults to 10 identity sources per response. You can specify a maximum of 50 identity sources per response.</p>', ], ], 'ListIdentitySourcesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListPoliciesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListPoliciesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListPolicyStoresInput' => [ 'base' => NULL, 'refs' => [], ], 'ListPolicyStoresOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListPolicyTemplatesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListPolicyTemplatesOutput' => [ 'base' => NULL, 'refs' => [], ], 'LongAttribute' => [ 'base' => NULL, 'refs' => [ 'AttributeValue$long' => '<p>An attribute value of <a href="https://docs.cedarpolicy.com/policies/syntax-datatypes.html#long">Long</a> type.</p> <p>Example: <code>{"long": 0}</code> </p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListPoliciesInput$maxResults' => '<p>Specifies the total number of results that you want included in each response. If additional items exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next set of results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p> <p>If you do not specify this parameter, the operation defaults to 10 policies per response. You can specify a maximum of 50 policies per response.</p>', 'ListPolicyStoresInput$maxResults' => '<p>Specifies the total number of results that you want included in each response. If additional items exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next set of results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p> <p>If you do not specify this parameter, the operation defaults to 10 policy stores per response. You can specify a maximum of 50 policy stores per response.</p>', 'ListPolicyTemplatesInput$maxResults' => '<p>Specifies the total number of results that you want included in each response. If additional items exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next set of results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p> <p>If you do not specify this parameter, the operation defaults to 10 policy templates per response. You can specify a maximum of 50 policy templates per response.</p>', ], ], 'Namespace' => [ 'base' => NULL, 'refs' => [ 'NamespaceList$member' => NULL, ], ], 'NamespaceList' => [ 'base' => NULL, 'refs' => [ 'GetSchemaOutput$namespaces' => '<p>The namespaces of the entities referenced by this schema.</p>', 'PutSchemaOutput$namespaces' => '<p>Identifies the namespaces of the entities referenced by this schema.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListIdentitySourcesInput$nextToken' => '<p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call\'s <code>NextToken</code> response to request the next page of results.</p>', 'ListIdentitySourcesOutput$nextToken' => '<p>If present, this value indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>. This indicates that this is the last page of results.</p>', 'ListPoliciesInput$nextToken' => '<p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call\'s <code>NextToken</code> response to request the next page of results.</p>', 'ListPoliciesOutput$nextToken' => '<p>If present, this value indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>. This indicates that this is the last page of results.</p>', 'ListPolicyStoresInput$nextToken' => '<p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call\'s <code>NextToken</code> response to request the next page of results.</p>', 'ListPolicyStoresOutput$nextToken' => '<p>If present, this value indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>. This indicates that this is the last page of results.</p>', 'ListPolicyTemplatesInput$nextToken' => '<p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call\'s <code>NextToken</code> response to request the next page of results.</p>', 'ListPolicyTemplatesOutput$nextToken' => '<p>If present, this value indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>. This indicates that this is the last page of results.</p>', ], ], 'OpenIdConnectAccessTokenConfiguration' => [ 'base' => '<p>The configuration of an OpenID Connect (OIDC) identity source for handling access token claims. Contains the claim that you want to identify as the principal in an authorization request, and the values of the <code>aud</code> claim, or audiences, that you want to accept.</p> <p>This data type is part of a <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_OpenIdConnectTokenSelection.html">OpenIdConnectTokenSelection</a> structure, which is a parameter of <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreateIdentitySource.html">CreateIdentitySource</a>.</p>', 'refs' => [ 'OpenIdConnectTokenSelection$accessTokenOnly' => '<p>The OIDC configuration for processing access tokens. Contains allowed audience claims, for example <code>https://auth.example.com</code>, and the claim that you want to map to the principal, for example <code>sub</code>.</p>', ], ], 'OpenIdConnectAccessTokenConfigurationDetail' => [ 'base' => '<p>The configuration of an OpenID Connect (OIDC) identity source for handling access token claims. Contains the claim that you want to identify as the principal in an authorization request, and the values of the <code>aud</code> claim, or audiences, that you want to accept.</p> <p>This data type is part of a <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_OpenIdConnectTokenSelectionDetail.html">OpenIdConnectTokenSelectionDetail</a> structure, which is a parameter of <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_GetIdentitySource.html">GetIdentitySource</a>.</p>', 'refs' => [ 'OpenIdConnectTokenSelectionDetail$accessTokenOnly' => '<p>The OIDC configuration for processing access tokens. Contains allowed audience claims, for example <code>https://auth.example.com</code>, and the claim that you want to map to the principal, for example <code>sub</code>.</p>', ], ], 'OpenIdConnectAccessTokenConfigurationItem' => [ 'base' => '<p>The configuration of an OpenID Connect (OIDC) identity source for handling access token claims. Contains the claim that you want to identify as the principal in an authorization request, and the values of the <code>aud</code> claim, or audiences, that you want to accept.</p> <p>This data type is part of a <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_OpenIdConnectTokenSelectionItem.html">OpenIdConnectTokenSelectionItem</a> structure, which is a parameter of <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListIdentitySources.html">ListIdentitySources</a>.</p>', 'refs' => [ 'OpenIdConnectTokenSelectionItem$accessTokenOnly' => '<p>The OIDC configuration for processing access tokens. Contains allowed audience claims, for example <code>https://auth.example.com</code>, and the claim that you want to map to the principal, for example <code>sub</code>.</p>', ], ], 'OpenIdConnectConfiguration' => [ 'base' => '<p>Contains configuration details of an OpenID Connect (OIDC) identity provider, or identity source, that Verified Permissions can use to generate entities from authenticated identities. It specifies the issuer URL, token type that you want to use, and policy store entity details.</p> <p>This data type is part of a <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_Configuration.html">Configuration</a> structure, which is a parameter to <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreateIdentitySource.html">CreateIdentitySource</a>.</p>', 'refs' => [ 'Configuration$openIdConnectConfiguration' => '<p>Contains configuration details of an OpenID Connect (OIDC) identity provider, or identity source, that Verified Permissions can use to generate entities from authenticated identities. It specifies the issuer URL, token type that you want to use, and policy store entity details.</p> <p>Example:<code>"configuration":{"openIdConnectConfiguration":{"issuer":"https://auth.example.com","tokenSelection":{"accessTokenOnly":{"audiences":["https://myapp.example.com","https://myapp2.example.com"],"principalIdClaim":"sub"}},"entityIdPrefix":"MyOIDCProvider","groupConfiguration":{"groupClaim":"groups","groupEntityType":"MyCorp::UserGroup"}}}</code> </p>', ], ], 'OpenIdConnectConfigurationDetail' => [ 'base' => '<p>Contains configuration details of an OpenID Connect (OIDC) identity provider, or identity source, that Verified Permissions can use to generate entities from authenticated identities. It specifies the issuer URL, token type that you want to use, and policy store entity details.</p> <p>This data type is part of a <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ConfigurationDetail.html">ConfigurationDetail</a> structure, which is a parameter to <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_GetIdentitySource.html">GetIdentitySource</a>.</p>', 'refs' => [ 'ConfigurationDetail$openIdConnectConfiguration' => '<p>Contains configuration details of an OpenID Connect (OIDC) identity provider, or identity source, that Verified Permissions can use to generate entities from authenticated identities. It specifies the issuer URL, token type that you want to use, and policy store entity details.</p> <p>Example:<code>"configuration":{"openIdConnectConfiguration":{"issuer":"https://auth.example.com","tokenSelection":{"accessTokenOnly":{"audiences":["https://myapp.example.com","https://myapp2.example.com"],"principalIdClaim":"sub"}},"entityIdPrefix":"MyOIDCProvider","groupConfiguration":{"groupClaim":"groups","groupEntityType":"MyCorp::UserGroup"}}}</code> </p>', ], ], 'OpenIdConnectConfigurationItem' => [ 'base' => '<p>Contains configuration details of an OpenID Connect (OIDC) identity provider, or identity source, that Verified Permissions can use to generate entities from authenticated identities. It specifies the issuer URL, token type that you want to use, and policy store entity details.</p> <p>This data type is part of a <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ConfigurationDetail.html">ConfigurationItem</a> structure, which is a parameter to <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListIdentitySources.html">ListIdentitySources</a>.</p>', 'refs' => [ 'ConfigurationItem$openIdConnectConfiguration' => '<p>Contains configuration details of an OpenID Connect (OIDC) identity provider, or identity source, that Verified Permissions can use to generate entities from authenticated identities. It specifies the issuer URL, token type that you want to use, and policy store entity details.</p> <p>Example:<code>"configuration":{"openIdConnectConfiguration":{"issuer":"https://auth.example.com","tokenSelection":{"accessTokenOnly":{"audiences":["https://myapp.example.com","https://myapp2.example.com"],"principalIdClaim":"sub"}},"entityIdPrefix":"MyOIDCProvider","groupConfiguration":{"groupClaim":"groups","groupEntityType":"MyCorp::UserGroup"}}}</code> </p>', ], ], 'OpenIdConnectGroupConfiguration' => [ 'base' => '<p>The claim in OIDC identity provider tokens that indicates a user\'s group membership, and the entity type that you want to map it to. For example, this object can map the contents of a <code>groups</code> claim to <code>MyCorp::UserGroup</code>.</p> <p>This data type is part of a <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_OpenIdConnectConfiguration.html">OpenIdConnectConfiguration</a> structure, which is a parameter of <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreateIdentitySource.html">CreateIdentitySource</a>.</p>', 'refs' => [ 'OpenIdConnectConfiguration$groupConfiguration' => '<p>The claim in OIDC identity provider tokens that indicates a user\'s group membership, and the entity type that you want to map it to. For example, this object can map the contents of a <code>groups</code> claim to <code>MyCorp::UserGroup</code>.</p>', ], ], 'OpenIdConnectGroupConfigurationDetail' => [ 'base' => '<p>The claim in OIDC identity provider tokens that indicates a user\'s group membership, and the entity type that you want to map it to. For example, this object can map the contents of a <code>groups</code> claim to <code>MyCorp::UserGroup</code>.</p> <p>This data type is part of a <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_OpenIdConnectConfigurationDetail.html">OpenIdConnectConfigurationDetail</a> structure, which is a parameter of <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_GetIdentitySource.html">GetIdentitySource</a>.</p>', 'refs' => [ 'OpenIdConnectConfigurationDetail$groupConfiguration' => '<p>The claim in OIDC identity provider tokens that indicates a user\'s group membership, and the entity type that you want to map it to. For example, this object can map the contents of a <code>groups</code> claim to <code>MyCorp::UserGroup</code>.</p>', ], ], 'OpenIdConnectGroupConfigurationItem' => [ 'base' => '<p>The claim in OIDC identity provider tokens that indicates a user\'s group membership, and the entity type that you want to map it to. For example, this object can map the contents of a <code>groups</code> claim to <code>MyCorp::UserGroup</code>.</p> <p>This data type is part of a <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_OpenIdConnectConfigurationItem.html">OpenIdConnectConfigurationItem</a> structure, which is a parameter of <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListIdentitySources.html">ListIdentitySourcea</a>.</p>', 'refs' => [ 'OpenIdConnectConfigurationItem$groupConfiguration' => '<p>The claim in OIDC identity provider tokens that indicates a user\'s group membership, and the entity type that you want to map it to. For example, this object can map the contents of a <code>groups</code> claim to <code>MyCorp::UserGroup</code>.</p>', ], ], 'OpenIdConnectIdentityTokenConfiguration' => [ 'base' => '<p>The configuration of an OpenID Connect (OIDC) identity source for handling identity (ID) token claims. Contains the claim that you want to identify as the principal in an authorization request, and the values of the <code>aud</code> claim, or audiences, that you want to accept.</p> <p>This data type is part of a <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_OpenIdConnectTokenSelection.html">OpenIdConnectTokenSelection</a> structure, which is a parameter of <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreateIdentitySource.html">CreateIdentitySource</a>.</p>', 'refs' => [ 'OpenIdConnectTokenSelection$identityTokenOnly' => '<p>The OIDC configuration for processing identity (ID) tokens. Contains allowed client ID claims, for example <code>1example23456789</code>, and the claim that you want to map to the principal, for example <code>sub</code>.</p>', ], ], 'OpenIdConnectIdentityTokenConfigurationDetail' => [ 'base' => '<p>The configuration of an OpenID Connect (OIDC) identity source for handling identity (ID) token claims. Contains the claim that you want to identify as the principal in an authorization request, and the values of the <code>aud</code> claim, or audiences, that you want to accept.</p> <p>This data type is part of a <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_OpenIdConnectTokenSelectionDetail.html">OpenIdConnectTokenSelectionDetail</a> structure, which is a parameter of <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_GetIdentitySource.html">GetIdentitySource</a>.</p>', 'refs' => [ 'OpenIdConnectTokenSelectionDetail$identityTokenOnly' => '<p>The OIDC configuration for processing identity (ID) tokens. Contains allowed client ID claims, for example <code>1example23456789</code>, and the claim that you want to map to the principal, for example <code>sub</code>.</p>', ], ], 'OpenIdConnectIdentityTokenConfigurationItem' => [ 'base' => '<p>The configuration of an OpenID Connect (OIDC) identity source for handling identity (ID) token claims. Contains the claim that you want to identify as the principal in an authorization request, and the values of the <code>aud</code> claim, or audiences, that you want to accept.</p> <p>This data type is part of a <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_OpenIdConnectTokenSelectionItem.html">OpenIdConnectTokenSelectionItem</a> structure, which is a parameter of <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListIdentitySources.html">ListIdentitySources</a>.</p>', 'refs' => [ 'OpenIdConnectTokenSelectionItem$identityTokenOnly' => '<p>The OIDC configuration for processing identity (ID) tokens. Contains allowed client ID claims, for example <code>1example23456789</code>, and the claim that you want to map to the principal, for example <code>sub</code>.</p>', ], ], 'OpenIdConnectTokenSelection' => [ 'base' => '<p>The token type that you want to process from your OIDC identity provider. Your policy store can process either identity (ID) or access tokens from a given OIDC identity source.</p> <p>This data type is part of a <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_OpenIdConnectConfiguration.html">OpenIdConnectConfiguration</a> structure, which is a parameter of <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreateIdentitySource.html">CreateIdentitySource</a>.</p>', 'refs' => [ 'OpenIdConnectConfiguration$tokenSelection' => '<p>The token type that you want to process from your OIDC identity provider. Your policy store can process either identity (ID) or access tokens from a given OIDC identity source.</p>', ], ], 'OpenIdConnectTokenSelectionDetail' => [ 'base' => '<p>The token type that you want to process from your OIDC identity provider. Your policy store can process either identity (ID) or access tokens from a given OIDC identity source.</p> <p>This data type is part of a <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_OpenIdConnectConfigurationDetail.html">OpenIdConnectConfigurationDetail</a> structure, which is a parameter of <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_GetIdentitySource.html">GetIdentitySource</a>.</p>', 'refs' => [ 'OpenIdConnectConfigurationDetail$tokenSelection' => '<p>The token type that you want to process from your OIDC identity provider. Your policy store can process either identity (ID) or access tokens from a given OIDC identity source.</p>', ], ], 'OpenIdConnectTokenSelectionItem' => [ 'base' => '<p>The token type that you want to process from your OIDC identity provider. Your policy store can process either identity (ID) or access tokens from a given OIDC identity source.</p> <p>This data type is part of a <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_OpenIdConnectConfigurationItem.html">OpenIdConnectConfigurationItem</a> structure, which is a parameter of <a href="http://amazonaws.com/verifiedpermissions/latest/apireference/API_ListIdentitySources.html">ListIdentitySources</a>.</p>', 'refs' => [ 'OpenIdConnectConfigurationItem$tokenSelection' => '<p>The token type that you want to process from your OIDC identity provider. Your policy store can process either identity (ID) or access tokens from a given OIDC identity source.</p>', ], ], 'OpenIdIssuer' => [ 'base' => NULL, 'refs' => [ 'IdentitySourceDetails$openIdIssuer' => '<p>A string that identifies the type of OIDC service represented by this identity source. </p> <p>At this time, the only valid value is <code>cognito</code>.</p>', 'IdentitySourceItemDetails$openIdIssuer' => '<p>A string that identifies the type of OIDC service represented by this identity source. </p> <p>At this time, the only valid value is <code>cognito</code>.</p>', ], ], 'ParentList' => [ 'base' => NULL, 'refs' => [ 'EntityItem$parents' => '<p>The parent entities in the hierarchy that contains the entity. A principal or resource entity can be defined with at most 99 <i>transitive parents</i> per authorization request. </p> <p>A transitive parent is an entity in the hierarchy of entities including all direct parents, and parents of parents. For example, a user can be a member of 91 groups if one of those groups is a member of eight groups, for a total of 100: one entity, 91 entity parents, and eight parents of parents. </p>', ], ], 'PolicyDefinition' => [ 'base' => '<p>A structure that contains the details for a Cedar policy definition. It includes the policy type, a description, and a policy body. This is a top level data type used to create a policy.</p> <p>This data type is used as a request parameter for the <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreatePolicy.html">CreatePolicy</a> operation. This structure must always have either an <code>static</code> or a <code>templateLinked</code> element.</p>', 'refs' => [ 'CreatePolicyInput$definition' => '<p>A structure that specifies the policy type and content to use for the new policy. You must include either a static or a templateLinked element. The policy content must be written in the Cedar policy language.</p>', ], ], 'PolicyDefinitionDetail' => [ 'base' => '<p>A structure that describes a policy definition. It must always have either an <code>static</code> or a <code>templateLinked</code> element.</p> <p>This data type is used as a response parameter for the <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_GetPolicy.html">GetPolicy</a> operation.</p>', 'refs' => [ 'GetPolicyOutput$definition' => '<p>The definition of the requested policy.</p>', ], ], 'PolicyDefinitionItem' => [ 'base' => '<p>A structure that describes a <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_PolicyDefinintion.html">PolicyDefinintion</a>. It will always have either an <code>StaticPolicy</code> or a <code>TemplateLinkedPolicy</code> element.</p> <p>This data type is used as a response parameter for the <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreatePolicy.html">CreatePolicy</a> and <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListPolicies.html">ListPolicies</a> operations. </p>', 'refs' => [ 'PolicyItem$definition' => '<p>The policy definition of an item in the list of policies returned.</p>', ], ], 'PolicyEffect' => [ 'base' => NULL, 'refs' => [ 'CreatePolicyOutput$effect' => '<p>The effect of the decision that a policy returns to an authorization request. For example, <code>"effect": "Permit"</code>.</p>', 'GetPolicyOutput$effect' => '<p>The effect of the decision that a policy returns to an authorization request. For example, <code>"effect": "Permit"</code>.</p>', 'PolicyItem$effect' => '<p>The effect of the decision that a policy returns to an authorization request. For example, <code>"effect": "Permit"</code>.</p>', 'UpdatePolicyOutput$effect' => '<p>The effect of the decision that a policy returns to an authorization request. For example, <code>"effect": "Permit"</code>.</p>', ], ], 'PolicyFilter' => [ 'base' => '<p>Contains information about a filter to refine policies returned in a query.</p> <p>This data type is used as a response parameter for the <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListPolicies.html">ListPolicies</a> operation.</p>', 'refs' => [ 'ListPoliciesInput$filter' => '<p>Specifies a filter that limits the response to only policies that match the specified criteria. For example, you list only the policies that reference a specified principal.</p>', ], ], 'PolicyId' => [ 'base' => NULL, 'refs' => [ 'CreatePolicyOutput$policyId' => '<p>The unique ID of the new policy.</p>', 'DeletePolicyInput$policyId' => '<p>Specifies the ID of the policy that you want to delete.</p>', 'DeterminingPolicyItem$policyId' => '<p>The Id of a policy that determined to an authorization decision.</p> <p>Example: <code>"policyId":"SPEXAMPLEabcdefg111111"</code> </p>', 'GetPolicyInput$policyId' => '<p>Specifies the ID of the policy you want information about.</p>', 'GetPolicyOutput$policyId' => '<p>The unique ID of the policy that you want information about.</p>', 'PolicyItem$policyId' => '<p>The identifier of the policy you want information about.</p>', 'UpdatePolicyInput$policyId' => '<p>Specifies the ID of the policy that you want to update. To find this value, you can use <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListPolicies.html">ListPolicies</a>.</p>', 'UpdatePolicyOutput$policyId' => '<p>The ID of the policy that was updated.</p>', ], ], 'PolicyItem' => [ 'base' => '<p>Contains information about a policy.</p> <p>This data type is used as a response parameter for the <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListPolicies.html">ListPolicies</a> operation.</p>', 'refs' => [ 'PolicyList$member' => NULL, ], ], 'PolicyList' => [ 'base' => NULL, 'refs' => [ 'ListPoliciesOutput$policies' => '<p>Lists all policies that are available in the specified policy store.</p>', ], ], 'PolicyStatement' => [ 'base' => NULL, 'refs' => [ 'CreatePolicyTemplateInput$statement' => '<p>Specifies the content that you want to use for the new policy template, written in the Cedar policy language.</p>', 'GetPolicyTemplateOutput$statement' => '<p>The content of the body of the policy template written in the Cedar policy language.</p>', 'StaticPolicyDefinition$statement' => '<p>The policy content of the static policy, written in the Cedar policy language.</p>', 'StaticPolicyDefinitionDetail$statement' => '<p>The content of the static policy written in the Cedar policy language.</p>', 'UpdatePolicyTemplateInput$statement' => '<p>Specifies new statement content written in Cedar policy language to replace the current body of the policy template.</p> <p>You can change only the following elements of the policy body:</p> <ul> <li> <p>The <code>action</code> referenced by the policy template.</p> </li> <li> <p>Any conditional clauses, such as <code>when</code> or <code>unless</code> clauses.</p> </li> </ul> <p>You <b>can\'t</b> change the following elements:</p> <ul> <li> <p>The effect (<code>permit</code> or <code>forbid</code>) of the policy template.</p> </li> <li> <p>The <code>principal</code> referenced by the policy template.</p> </li> <li> <p>The <code>resource</code> referenced by the policy template.</p> </li> </ul>', 'UpdateStaticPolicyDefinition$statement' => '<p>Specifies the Cedar policy language text to be added to or replaced on the static policy.</p> <important> <p>You can change only the following elements from the original content:</p> <ul> <li> <p>The <code>action</code> referenced by the policy.</p> </li> <li> <p>Any conditional clauses, such as <code>when</code> or <code>unless</code> clauses.</p> </li> </ul> <p>You <b>can\'t</b> change the following elements:</p> <ul> <li> <p>Changing from <code>StaticPolicy</code> to <code>TemplateLinkedPolicy</code>.</p> </li> <li> <p>The effect (<code>permit</code> or <code>forbid</code>) of the policy.</p> </li> <li> <p>The <code>principal</code> referenced by the policy.</p> </li> <li> <p>The <code>resource</code> referenced by the policy.</p> </li> </ul> </important>', ], ], 'PolicyStoreDescription' => [ 'base' => NULL, 'refs' => [ 'CreatePolicyStoreInput$description' => '<p>Descriptive text that you can provide to help with identification of the current policy store.</p>', 'GetPolicyStoreOutput$description' => '<p>Descriptive text that you can provide to help with identification of the current policy store.</p>', 'PolicyStoreItem$description' => '<p>Descriptive text that you can provide to help with identification of the current policy store.</p>', 'UpdatePolicyStoreInput$description' => '<p>Descriptive text that you can provide to help with identification of the current policy store.</p>', ], ], 'PolicyStoreId' => [ 'base' => NULL, 'refs' => [ 'BatchIsAuthorizedInput$policyStoreId' => '<p>Specifies the ID of the policy store. Policies in this policy store will be used to make the authorization decisions for the input.</p>', 'BatchIsAuthorizedWithTokenInput$policyStoreId' => '<p>Specifies the ID of the policy store. Policies in this policy store will be used to make an authorization decision for the input.</p>', 'CreateIdentitySourceInput$policyStoreId' => '<p>Specifies the ID of the policy store in which you want to store this identity source. Only policies and requests made using this policy store can reference identities from the identity provider configured in the new identity source.</p>', 'CreateIdentitySourceOutput$policyStoreId' => '<p>The ID of the policy store that contains the identity source.</p>', 'CreatePolicyInput$policyStoreId' => '<p>Specifies the <code>PolicyStoreId</code> of the policy store you want to store the policy in.</p>', 'CreatePolicyOutput$policyStoreId' => '<p>The ID of the policy store that contains the new policy.</p>', 'CreatePolicyStoreOutput$policyStoreId' => '<p>The unique ID of the new policy store.</p>', 'CreatePolicyTemplateInput$policyStoreId' => '<p>The ID of the policy store in which to create the policy template.</p>', 'CreatePolicyTemplateOutput$policyStoreId' => '<p>The ID of the policy store that contains the policy template.</p>', 'DeleteIdentitySourceInput$policyStoreId' => '<p>Specifies the ID of the policy store that contains the identity source that you want to delete.</p>', 'DeletePolicyInput$policyStoreId' => '<p>Specifies the ID of the policy store that contains the policy that you want to delete.</p>', 'DeletePolicyStoreInput$policyStoreId' => '<p>Specifies the ID of the policy store that you want to delete.</p>', 'DeletePolicyTemplateInput$policyStoreId' => '<p>Specifies the ID of the policy store that contains the policy template that you want to delete.</p>', 'GetIdentitySourceInput$policyStoreId' => '<p>Specifies the ID of the policy store that contains the identity source you want information about.</p>', 'GetIdentitySourceOutput$policyStoreId' => '<p>The ID of the policy store that contains the identity source.</p>', 'GetPolicyInput$policyStoreId' => '<p>Specifies the ID of the policy store that contains the policy that you want information about.</p>', 'GetPolicyOutput$policyStoreId' => '<p>The ID of the policy store that contains the policy that you want information about.</p>', 'GetPolicyStoreInput$policyStoreId' => '<p>Specifies the ID of the policy store that you want information about.</p>', 'GetPolicyStoreOutput$policyStoreId' => '<p>The ID of the policy store;</p>', 'GetPolicyTemplateInput$policyStoreId' => '<p>Specifies the ID of the policy store that contains the policy template that you want information about.</p>', 'GetPolicyTemplateOutput$policyStoreId' => '<p>The ID of the policy store that contains the policy template.</p>', 'GetSchemaInput$policyStoreId' => '<p>Specifies the ID of the policy store that contains the schema.</p>', 'GetSchemaOutput$policyStoreId' => '<p>The ID of the policy store that contains the schema.</p>', 'IdentitySourceItem$policyStoreId' => '<p>The identifier of the policy store that contains the identity source.</p>', 'IsAuthorizedInput$policyStoreId' => '<p>Specifies the ID of the policy store. Policies in this policy store will be used to make an authorization decision for the input.</p>', 'IsAuthorizedWithTokenInput$policyStoreId' => '<p>Specifies the ID of the policy store. Policies in this policy store will be used to make an authorization decision for the input.</p>', 'ListIdentitySourcesInput$policyStoreId' => '<p>Specifies the ID of the policy store that contains the identity sources that you want to list.</p>', 'ListPoliciesInput$policyStoreId' => '<p>Specifies the ID of the policy store you want to list policies from.</p>', 'ListPolicyTemplatesInput$policyStoreId' => '<p>Specifies the ID of the policy store that contains the policy templates you want to list.</p>', 'PolicyItem$policyStoreId' => '<p>The identifier of the PolicyStore where the policy you want information about is stored.</p>', 'PolicyStoreItem$policyStoreId' => '<p>The unique identifier of the policy store.</p>', 'PolicyTemplateItem$policyStoreId' => '<p>The unique identifier of the policy store that contains the template.</p>', 'PutSchemaInput$policyStoreId' => '<p>Specifies the ID of the policy store in which to place the schema.</p>', 'PutSchemaOutput$policyStoreId' => '<p>The unique ID of the policy store that contains the schema.</p>', 'UpdateIdentitySourceInput$policyStoreId' => '<p>Specifies the ID of the policy store that contains the identity source that you want to update.</p>', 'UpdateIdentitySourceOutput$policyStoreId' => '<p>The ID of the policy store that contains the updated identity source.</p>', 'UpdatePolicyInput$policyStoreId' => '<p>Specifies the ID of the policy store that contains the policy that you want to update.</p>', 'UpdatePolicyOutput$policyStoreId' => '<p>The ID of the policy store that contains the policy that was updated.</p>', 'UpdatePolicyStoreInput$policyStoreId' => '<p>Specifies the ID of the policy store that you want to update</p>', 'UpdatePolicyStoreOutput$policyStoreId' => '<p>The ID of the updated policy store.</p>', 'UpdatePolicyTemplateInput$policyStoreId' => '<p>Specifies the ID of the policy store that contains the policy template that you want to update.</p>', 'UpdatePolicyTemplateOutput$policyStoreId' => '<p>The ID of the policy store that contains the updated policy template.</p>', ], ], 'PolicyStoreItem' => [ 'base' => '<p>Contains information about a policy store.</p> <p>This data type is used as a response parameter for the <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListPolicyStores.html">ListPolicyStores</a> operation.</p>', 'refs' => [ 'PolicyStoreList$member' => NULL, ], ], 'PolicyStoreList' => [ 'base' => NULL, 'refs' => [ 'ListPolicyStoresOutput$policyStores' => '<p>The list of policy stores in the account.</p>', ], ], 'PolicyTemplateDescription' => [ 'base' => NULL, 'refs' => [ 'CreatePolicyTemplateInput$description' => '<p>Specifies a description for the policy template.</p>', 'GetPolicyTemplateOutput$description' => '<p>The description of the policy template.</p>', 'PolicyTemplateItem$description' => '<p>The description attached to the policy template.</p>', 'UpdatePolicyTemplateInput$description' => '<p>Specifies a new description to apply to the policy template.</p>', ], ], 'PolicyTemplateId' => [ 'base' => NULL, 'refs' => [ 'CreatePolicyTemplateOutput$policyTemplateId' => '<p>The unique ID of the new policy template.</p>', 'DeletePolicyTemplateInput$policyTemplateId' => '<p>Specifies the ID of the policy template that you want to delete.</p>', 'GetPolicyTemplateInput$policyTemplateId' => '<p>Specifies the ID of the policy template that you want information about.</p>', 'GetPolicyTemplateOutput$policyTemplateId' => '<p>The ID of the policy template.</p>', 'PolicyFilter$policyTemplateId' => '<p>Filters the output to only template-linked policies that were instantiated from the specified policy template.</p>', 'PolicyTemplateItem$policyTemplateId' => '<p>The unique identifier of the policy template.</p>', 'TemplateLinkedPolicyDefinition$policyTemplateId' => '<p>The unique identifier of the policy template used to create this policy.</p>', 'TemplateLinkedPolicyDefinitionDetail$policyTemplateId' => '<p>The unique identifier of the policy template used to create this policy.</p>', 'TemplateLinkedPolicyDefinitionItem$policyTemplateId' => '<p>The unique identifier of the policy template used to create this policy.</p>', 'UpdatePolicyTemplateInput$policyTemplateId' => '<p>Specifies the ID of the policy template that you want to update.</p>', 'UpdatePolicyTemplateOutput$policyTemplateId' => '<p>The ID of the updated policy template.</p>', ], ], 'PolicyTemplateItem' => [ 'base' => '<p>Contains details about a policy template</p> <p>This data type is used as a response parameter for the <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListPolicyTemplates.html">ListPolicyTemplates</a> operation.</p>', 'refs' => [ 'PolicyTemplatesList$member' => NULL, ], ], 'PolicyTemplatesList' => [ 'base' => NULL, 'refs' => [ 'ListPolicyTemplatesOutput$policyTemplates' => '<p>The list of the policy templates in the specified policy store.</p>', ], ], 'PolicyType' => [ 'base' => NULL, 'refs' => [ 'CreatePolicyOutput$policyType' => '<p>The policy type of the new policy.</p>', 'GetPolicyOutput$policyType' => '<p>The type of the policy.</p>', 'PolicyFilter$policyType' => '<p>Filters the output to only policies of the specified type.</p>', 'PolicyItem$policyType' => '<p>The type of the policy. This is one of the following values:</p> <ul> <li> <p> <code>static</code> </p> </li> <li> <p> <code>templateLinked</code> </p> </li> </ul>', 'UpdatePolicyOutput$policyType' => '<p>The type of the policy that was updated.</p>', ], ], 'PrincipalEntityType' => [ 'base' => NULL, 'refs' => [ 'CreateIdentitySourceInput$principalEntityType' => '<p>Specifies the namespace and data type of the principals generated for identities authenticated by the new identity source.</p>', 'GetIdentitySourceOutput$principalEntityType' => '<p>The data type of principals generated for identities authenticated by this identity source.</p>', 'IdentitySourceFilter$principalEntityType' => '<p>The Cedar entity type of the principals returned by the identity provider (IdP) associated with this identity source.</p>', 'IdentitySourceItem$principalEntityType' => '<p>The Cedar entity type of the principals returned from the IdP associated with this identity source.</p>', 'UpdateIdentitySourceInput$principalEntityType' => '<p>Specifies the data type of principals generated for identities authenticated by the identity source.</p>', ], ], 'PutSchemaInput' => [ 'base' => NULL, 'refs' => [], ], 'PutSchemaOutput' => [ 'base' => NULL, 'refs' => [], ], 'RecordAttribute' => [ 'base' => NULL, 'refs' => [ 'AttributeValue$record' => '<p>An attribute value of <a href="https://docs.cedarpolicy.com/policies/syntax-datatypes.html#record">Record</a> type.</p> <p>Example: <code>{"record": { "keyName": {} } }</code> </p>', ], ], 'ResourceArn' => [ 'base' => NULL, 'refs' => [ 'CreatePolicyStoreOutput$arn' => '<p>The Amazon Resource Name (ARN) of the new policy store.</p>', 'GetPolicyStoreOutput$arn' => '<p>The Amazon Resource Name (ARN) of the policy store.</p>', 'PolicyStoreItem$arn' => '<p>The Amazon Resource Name (ARN) of the policy store.</p>', 'UpdatePolicyStoreOutput$arn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name (ARN)</a> of the updated policy store.</p>', ], ], 'ResourceConflict' => [ 'base' => '<p>Contains information about a resource conflict.</p>', 'refs' => [ 'ResourceConflictList$member' => NULL, ], ], 'ResourceConflictList' => [ 'base' => NULL, 'refs' => [ 'ConflictException$resources' => '<p>The list of resources referenced with this failed request.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The request failed because it references a resource that doesn\'t exist.</p>', 'refs' => [], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'ResourceConflict$resourceType' => '<p>The type of the resource involved in a conflict.</p>', 'ResourceNotFoundException$resourceType' => '<p>The resource type of the resource referenced in the failed request.</p>', 'ServiceQuotaExceededException$resourceType' => '<p>The resource type of the resource referenced in the failed request.</p>', ], ], 'SchemaDefinition' => [ 'base' => '<p>Contains a list of principal types, resource types, and actions that can be specified in policies stored in the same policy store. If the validation mode for the policy store is set to <code>STRICT</code>, then policies that can\'t be validated by this schema are rejected by Verified Permissions and can\'t be stored in the policy store.</p>', 'refs' => [ 'PutSchemaInput$definition' => '<p>Specifies the definition of the schema to be stored. The schema definition must be written in Cedar schema JSON.</p>', ], ], 'SchemaJson' => [ 'base' => NULL, 'refs' => [ 'GetSchemaOutput$schema' => '<p>The body of the schema, written in Cedar schema JSON.</p>', 'SchemaDefinition$cedarJson' => '<p>A JSON string representation of the schema supported by applications that use this policy store. For more information, see <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/userguide/schema.html">Policy store schema</a> in the <i>Amazon Verified Permissions User Guide</i>.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>The request failed because it would cause a service quota to be exceeded.</p>', 'refs' => [], ], 'SetAttribute' => [ 'base' => NULL, 'refs' => [ 'AttributeValue$set' => '<p>An attribute value of <a href="https://docs.cedarpolicy.com/policies/syntax-datatypes.html#set">Set</a> type.</p> <p>Example: <code>{"set": [ {} ] }</code> </p>', ], ], 'StaticPolicyDefinition' => [ 'base' => '<p>Contains information about a static policy.</p> <p>This data type is used as a field that is part of the <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_PolicyDefinitionDetail.html">PolicyDefinitionDetail</a> type.</p>', 'refs' => [ 'PolicyDefinition$static' => '<p>A structure that describes a static policy. An static policy doesn\'t use a template or allow placeholders for entities.</p>', ], ], 'StaticPolicyDefinitionDetail' => [ 'base' => '<p>A structure that contains details about a static policy. It includes the description and policy body.</p> <p>This data type is used within a <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_PolicyDefinition.html">PolicyDefinition</a> structure as part of a request parameter for the <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreatePolicy.html">CreatePolicy</a> operation.</p>', 'refs' => [ 'PolicyDefinitionDetail$static' => '<p>Information about a static policy that wasn\'t created with a policy template.</p>', ], ], 'StaticPolicyDefinitionItem' => [ 'base' => '<p>A structure that contains details about a static policy. It includes the description and policy statement.</p> <p>This data type is used within a <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_PolicyDefinition.html">PolicyDefinition</a> structure as part of a request parameter for the <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreatePolicy.html">CreatePolicy</a> operation.</p>', 'refs' => [ 'PolicyDefinitionItem$static' => '<p>Information about a static policy that wasn\'t created with a policy template.</p>', ], ], 'StaticPolicyDescription' => [ 'base' => NULL, 'refs' => [ 'StaticPolicyDefinition$description' => '<p>The description of the static policy.</p>', 'StaticPolicyDefinitionDetail$description' => '<p>A description of the static policy.</p>', 'StaticPolicyDefinitionItem$description' => '<p>A description of the static policy.</p>', 'UpdateStaticPolicyDefinition$description' => '<p>Specifies the description to be added to or replaced on the static policy.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'ConflictException$message' => NULL, 'ContextMap$key' => NULL, 'EntityAttributes$key' => NULL, 'EvaluationErrorItem$errorDescription' => '<p>The error description.</p>', 'InternalServerException$message' => NULL, 'RecordAttribute$key' => NULL, 'ResourceConflict$resourceId' => '<p>The unique identifier of the resource involved in a conflict.</p>', 'ResourceNotFoundException$message' => NULL, 'ResourceNotFoundException$resourceId' => '<p>The unique ID of the resource referenced in the failed request.</p>', 'ServiceQuotaExceededException$message' => NULL, 'ServiceQuotaExceededException$resourceId' => '<p>The unique ID of the resource referenced in the failed request.</p>', 'ServiceQuotaExceededException$serviceCode' => '<p>The code for the Amazon Web Service that owns the quota.</p>', 'ServiceQuotaExceededException$quotaCode' => '<p>The quota code recognized by the Amazon Web Services Service Quotas service.</p>', 'ThrottlingException$message' => NULL, 'ThrottlingException$serviceCode' => '<p>The code for the Amazon Web Service that owns the quota.</p>', 'ThrottlingException$quotaCode' => '<p>The quota code recognized by the Amazon Web Services Service Quotas service.</p>', 'ValidationException$message' => NULL, 'ValidationExceptionField$path' => '<p>The path to the specific element that Verified Permissions found to be not valid.</p>', 'ValidationExceptionField$message' => '<p>Describes the policy validation error.</p>', ], ], 'StringAttribute' => [ 'base' => NULL, 'refs' => [ 'AttributeValue$string' => '<p>An attribute value of <a href="https://docs.cedarpolicy.com/policies/syntax-datatypes.html#string">String</a> type.</p> <p>Example: <code>{"string": "abc"}</code> </p>', ], ], 'TemplateLinkedPolicyDefinition' => [ 'base' => '<p>Contains information about a policy created by instantiating a policy template.</p>', 'refs' => [ 'PolicyDefinition$templateLinked' => '<p>A structure that describes a policy that was instantiated from a template. The template can specify placeholders for <code>principal</code> and <code>resource</code>. When you use <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreatePolicy.html">CreatePolicy</a> to create a policy from a template, you specify the exact principal and resource to use for the instantiated policy.</p>', ], ], 'TemplateLinkedPolicyDefinitionDetail' => [ 'base' => '<p>Contains information about a policy that was created by instantiating a policy template. </p>', 'refs' => [ 'PolicyDefinitionDetail$templateLinked' => '<p>Information about a template-linked policy that was created by instantiating a policy template.</p>', ], ], 'TemplateLinkedPolicyDefinitionItem' => [ 'base' => '<p>Contains information about a policy created by instantiating a policy template. </p> <p>This </p>', 'refs' => [ 'PolicyDefinitionItem$templateLinked' => '<p>Information about a template-linked policy that was created by instantiating a policy template.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The request failed because it exceeded a throttling quota.</p>', 'refs' => [], ], 'TimestampFormat' => [ 'base' => NULL, 'refs' => [ 'CreateIdentitySourceOutput$createdDate' => '<p>The date and time the identity source was originally created.</p>', 'CreateIdentitySourceOutput$lastUpdatedDate' => '<p>The date and time the identity source was most recently updated.</p>', 'CreatePolicyOutput$createdDate' => '<p>The date and time the policy was originally created.</p>', 'CreatePolicyOutput$lastUpdatedDate' => '<p>The date and time the policy was last updated.</p>', 'CreatePolicyStoreOutput$createdDate' => '<p>The date and time the policy store was originally created.</p>', 'CreatePolicyStoreOutput$lastUpdatedDate' => '<p>The date and time the policy store was last updated.</p>', 'CreatePolicyTemplateOutput$createdDate' => '<p>The date and time the policy template was originally created.</p>', 'CreatePolicyTemplateOutput$lastUpdatedDate' => '<p>The date and time the policy template was most recently updated.</p>', 'GetIdentitySourceOutput$createdDate' => '<p>The date and time that the identity source was originally created.</p>', 'GetIdentitySourceOutput$lastUpdatedDate' => '<p>The date and time that the identity source was most recently updated.</p>', 'GetPolicyOutput$createdDate' => '<p>The date and time that the policy was originally created.</p>', 'GetPolicyOutput$lastUpdatedDate' => '<p>The date and time that the policy was last updated.</p>', 'GetPolicyStoreOutput$createdDate' => '<p>The date and time that the policy store was originally created.</p>', 'GetPolicyStoreOutput$lastUpdatedDate' => '<p>The date and time that the policy store was last updated.</p>', 'GetPolicyTemplateOutput$createdDate' => '<p>The date and time that the policy template was originally created.</p>', 'GetPolicyTemplateOutput$lastUpdatedDate' => '<p>The date and time that the policy template was most recently updated.</p>', 'GetSchemaOutput$createdDate' => '<p>The date and time that the schema was originally created.</p>', 'GetSchemaOutput$lastUpdatedDate' => '<p>The date and time that the schema was most recently updated.</p>', 'IdentitySourceItem$createdDate' => '<p>The date and time the identity source was originally created.</p>', 'IdentitySourceItem$lastUpdatedDate' => '<p>The date and time the identity source was most recently updated.</p>', 'PolicyItem$createdDate' => '<p>The date and time the policy was created.</p>', 'PolicyItem$lastUpdatedDate' => '<p>The date and time the policy was most recently updated.</p>', 'PolicyStoreItem$createdDate' => '<p>The date and time the policy was created.</p>', 'PolicyStoreItem$lastUpdatedDate' => '<p>The date and time the policy store was most recently updated.</p>', 'PolicyTemplateItem$createdDate' => '<p>The date and time that the policy template was created.</p>', 'PolicyTemplateItem$lastUpdatedDate' => '<p>The date and time that the policy template was most recently updated.</p>', 'PutSchemaOutput$createdDate' => '<p>The date and time that the schema was originally created.</p>', 'PutSchemaOutput$lastUpdatedDate' => '<p>The date and time that the schema was last updated.</p>', 'UpdateIdentitySourceOutput$createdDate' => '<p>The date and time that the updated identity source was originally created.</p>', 'UpdateIdentitySourceOutput$lastUpdatedDate' => '<p>The date and time that the identity source was most recently updated.</p>', 'UpdatePolicyOutput$createdDate' => '<p>The date and time that the policy was originally created.</p>', 'UpdatePolicyOutput$lastUpdatedDate' => '<p>The date and time that the policy was most recently updated.</p>', 'UpdatePolicyStoreOutput$createdDate' => '<p>The date and time that the policy store was originally created.</p>', 'UpdatePolicyStoreOutput$lastUpdatedDate' => '<p>The date and time that the policy store was most recently updated.</p>', 'UpdatePolicyTemplateOutput$createdDate' => '<p>The date and time that the policy template was originally created.</p>', 'UpdatePolicyTemplateOutput$lastUpdatedDate' => '<p>The date and time that the policy template was most recently updated.</p>', ], ], 'Token' => [ 'base' => NULL, 'refs' => [ 'BatchIsAuthorizedWithTokenInput$identityToken' => '<p>Specifies an identity (ID) token for the principal that you want to authorize in each request. This token is provided to you by the identity provider (IdP) associated with the specified identity source. You must specify either an <code>accessToken</code>, an <code>identityToken</code>, or both.</p> <p>Must be an ID token. Verified Permissions returns an error if the <code>token_use</code> claim in the submitted token isn\'t <code>id</code>.</p>', 'BatchIsAuthorizedWithTokenInput$accessToken' => '<p>Specifies an access token for the principal that you want to authorize in each request. This token is provided to you by the identity provider (IdP) associated with the specified identity source. You must specify either an <code>accessToken</code>, an <code>identityToken</code>, or both.</p> <p>Must be an access token. Verified Permissions returns an error if the <code>token_use</code> claim in the submitted token isn\'t <code>access</code>.</p>', 'IsAuthorizedWithTokenInput$identityToken' => '<p>Specifies an identity token for the principal to be authorized. This token is provided to you by the identity provider (IdP) associated with the specified identity source. You must specify either an <code>accessToken</code>, an <code>identityToken</code>, or both.</p> <p>Must be an ID token. Verified Permissions returns an error if the <code>token_use</code> claim in the submitted token isn\'t <code>id</code>.</p>', 'IsAuthorizedWithTokenInput$accessToken' => '<p>Specifies an access token for the principal to be authorized. This token is provided to you by the identity provider (IdP) associated with the specified identity source. You must specify either an <code>accessToken</code>, an <code>identityToken</code>, or both.</p> <p>Must be an access token. Verified Permissions returns an error if the <code>token_use</code> claim in the submitted token isn\'t <code>access</code>.</p>', ], ], 'UpdateCognitoGroupConfiguration' => [ 'base' => '<p>The user group entities from an Amazon Cognito user pool identity source.</p>', 'refs' => [ 'UpdateCognitoUserPoolConfiguration$groupConfiguration' => '<p>The configuration of the user groups from an Amazon Cognito user pool identity source.</p>', ], ], 'UpdateCognitoUserPoolConfiguration' => [ 'base' => '<p>Contains configuration details of a Amazon Cognito user pool for use with an identity source.</p>', 'refs' => [ 'UpdateConfiguration$cognitoUserPoolConfiguration' => '<p>Contains configuration details of a Amazon Cognito user pool.</p>', ], ], 'UpdateConfiguration' => [ 'base' => '<p>Contains an update to replace the configuration in an existing identity source.</p>', 'refs' => [ 'UpdateIdentitySourceInput$updateConfiguration' => '<p>Specifies the details required to communicate with the identity provider (IdP) associated with this identity source.</p> <note> <p>At this time, the only valid member of this structure is a Amazon Cognito user pool configuration.</p> <p>You must specify a <code>userPoolArn</code>, and optionally, a <code>ClientId</code>.</p> </note>', ], ], 'UpdateIdentitySourceInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateIdentitySourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateOpenIdConnectAccessTokenConfiguration' => [ 'base' => '<p>The configuration of an OpenID Connect (OIDC) identity source for handling access token claims. Contains the claim that you want to identify as the principal in an authorization request, and the values of the <code>aud</code> claim, or audiences, that you want to accept.</p> <p>This data type is part of a <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdateOpenIdConnectTokenSelection.html">UpdateOpenIdConnectTokenSelection</a> structure, which is a parameter to <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdateIdentitySource.html">UpdateIdentitySource</a>.</p>', 'refs' => [ 'UpdateOpenIdConnectTokenSelection$accessTokenOnly' => '<p>The OIDC configuration for processing access tokens. Contains allowed audience claims, for example <code>https://auth.example.com</code>, and the claim that you want to map to the principal, for example <code>sub</code>.</p>', ], ], 'UpdateOpenIdConnectConfiguration' => [ 'base' => '<p>Contains configuration details of an OpenID Connect (OIDC) identity provider, or identity source, that Verified Permissions can use to generate entities from authenticated identities. It specifies the issuer URL, token type that you want to use, and policy store entity details.</p> <p>This data type is part of a <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdateConfiguration.html">UpdateConfiguration</a> structure, which is a parameter to <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdateIdentitySource.html">UpdateIdentitySource</a>.</p>', 'refs' => [ 'UpdateConfiguration$openIdConnectConfiguration' => '<p>Contains configuration details of an OpenID Connect (OIDC) identity provider, or identity source, that Verified Permissions can use to generate entities from authenticated identities. It specifies the issuer URL, token type that you want to use, and policy store entity details.</p>', ], ], 'UpdateOpenIdConnectGroupConfiguration' => [ 'base' => '<p>The claim in OIDC identity provider tokens that indicates a user\'s group membership, and the entity type that you want to map it to. For example, this object can map the contents of a <code>groups</code> claim to <code>MyCorp::UserGroup</code>.</p> <p>This data type is part of a <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdateOpenIdConnectConfiguration.html">UpdateOpenIdConnectConfiguration</a> structure, which is a parameter to <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdateIdentitySource.html">UpdateIdentitySource</a>.</p>', 'refs' => [ 'UpdateOpenIdConnectConfiguration$groupConfiguration' => '<p>The claim in OIDC identity provider tokens that indicates a user\'s group membership, and the entity type that you want to map it to. For example, this object can map the contents of a <code>groups</code> claim to <code>MyCorp::UserGroup</code>.</p>', ], ], 'UpdateOpenIdConnectIdentityTokenConfiguration' => [ 'base' => '<p>The configuration of an OpenID Connect (OIDC) identity source for handling identity (ID) token claims. Contains the claim that you want to identify as the principal in an authorization request, and the values of the <code>aud</code> claim, or audiences, that you want to accept.</p> <p>This data type is part of a <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdateOpenIdConnectTokenSelection.html">UpdateOpenIdConnectTokenSelection</a> structure, which is a parameter to <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdateIdentitySource.html">UpdateIdentitySource</a>.</p>', 'refs' => [ 'UpdateOpenIdConnectTokenSelection$identityTokenOnly' => '<p>The OIDC configuration for processing identity (ID) tokens. Contains allowed client ID claims, for example <code>1example23456789</code>, and the claim that you want to map to the principal, for example <code>sub</code>.</p>', ], ], 'UpdateOpenIdConnectTokenSelection' => [ 'base' => '<p>The token type that you want to process from your OIDC identity provider. Your policy store can process either identity (ID) or access tokens from a given OIDC identity source.</p> <p>This data type is part of a <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdateOpenIdConnectConfiguration.html">UpdateOpenIdConnectConfiguration</a> structure, which is a parameter to <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdateIdentitySource.html">UpdateIdentitySource</a>.</p>', 'refs' => [ 'UpdateOpenIdConnectConfiguration$tokenSelection' => '<p>The token type that you want to process from your OIDC identity provider. Your policy store can process either identity (ID) or access tokens from a given OIDC identity source.</p>', ], ], 'UpdatePolicyDefinition' => [ 'base' => '<p>Contains information about updates to be applied to a policy.</p> <p>This data type is used as a request parameter in the <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicy.html">UpdatePolicy</a> operation.</p>', 'refs' => [ 'UpdatePolicyInput$definition' => '<p>Specifies the updated policy content that you want to replace on the specified policy. The content must be valid Cedar policy language text.</p> <p>You can change only the following elements from the policy definition:</p> <ul> <li> <p>The <code>action</code> referenced by the policy.</p> </li> <li> <p>Any conditional clauses, such as <code>when</code> or <code>unless</code> clauses.</p> </li> </ul> <p>You <b>can\'t</b> change the following elements:</p> <ul> <li> <p>Changing from <code>static</code> to <code>templateLinked</code>.</p> </li> <li> <p>Changing the effect of the policy from <code>permit</code> or <code>forbid</code>.</p> </li> <li> <p>The <code>principal</code> referenced by the policy.</p> </li> <li> <p>The <code>resource</code> referenced by the policy.</p> </li> </ul>', ], ], 'UpdatePolicyInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePolicyOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePolicyStoreInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePolicyStoreOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePolicyTemplateInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePolicyTemplateOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateStaticPolicyDefinition' => [ 'base' => '<p>Contains information about an update to a static policy.</p>', 'refs' => [ 'UpdatePolicyDefinition$static' => '<p>Contains details about the updates to be applied to a static policy.</p>', ], ], 'UserPoolArn' => [ 'base' => NULL, 'refs' => [ 'CognitoUserPoolConfiguration$userPoolArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name (ARN)</a> of the Amazon Cognito user pool that contains the identities to be authorized.</p> <p>Example: <code>"UserPoolArn": "arn:aws:cognito-idp:us-east-1:123456789012:userpool/us-east-1_1a2b3c4d5"</code> </p>', 'CognitoUserPoolConfigurationDetail$userPoolArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name (ARN)</a> of the Amazon Cognito user pool that contains the identities to be authorized.</p> <p>Example: <code>"userPoolArn": "arn:aws:cognito-idp:us-east-1:123456789012:userpool/us-east-1_1a2b3c4d5"</code> </p>', 'CognitoUserPoolConfigurationItem$userPoolArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name (ARN)</a> of the Amazon Cognito user pool that contains the identities to be authorized.</p> <p>Example: <code>"userPoolArn": "arn:aws:cognito-idp:us-east-1:123456789012:userpool/us-east-1_1a2b3c4d5"</code> </p>', 'IdentitySourceDetails$userPoolArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name (ARN)</a> of the Amazon Cognito user pool whose identities are accessible to this Verified Permissions policy store.</p>', 'IdentitySourceItemDetails$userPoolArn' => '<p>The Amazon Cognito user pool whose identities are accessible to this Verified Permissions policy store.</p>', 'UpdateCognitoUserPoolConfiguration$userPoolArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name (ARN)</a> of the Amazon Cognito user pool associated with this identity source.</p>', ], ], 'ValidationException' => [ 'base' => '<p>The request failed because one or more input parameters don\'t satisfy their constraint requirements. The output is provided as a list of fields and a reason for each field that isn\'t valid.</p> <p>The possible reasons include the following:</p> <ul> <li> <p> <b>UnrecognizedEntityType</b> </p> <p>The policy includes an entity type that isn\'t found in the schema.</p> </li> <li> <p> <b>UnrecognizedActionId</b> </p> <p>The policy includes an action id that isn\'t found in the schema.</p> </li> <li> <p> <b>InvalidActionApplication</b> </p> <p>The policy includes an action that, according to the schema, doesn\'t support the specified principal and resource.</p> </li> <li> <p> <b>UnexpectedType</b> </p> <p>The policy included an operand that isn\'t a valid type for the specified operation.</p> </li> <li> <p> <b>IncompatibleTypes</b> </p> <p>The types of elements included in a <code>set</code>, or the types of expressions used in an <code>if...then...else</code> clause aren\'t compatible in this context.</p> </li> <li> <p> <b>MissingAttribute</b> </p> <p>The policy attempts to access a record or entity attribute that isn\'t specified in the schema. Test for the existence of the attribute first before attempting to access its value. For more information, see the <a href="https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test">has (presence of attribute test) operator</a> in the <i>Cedar Policy Language Guide</i>.</p> </li> <li> <p> <b>UnsafeOptionalAttributeAccess</b> </p> <p>The policy attempts to access a record or entity attribute that is optional and isn\'t guaranteed to be present. Test for the existence of the attribute first before attempting to access its value. For more information, see the <a href="https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test">has (presence of attribute test) operator</a> in the <i>Cedar Policy Language Guide</i>.</p> </li> <li> <p> <b>ImpossiblePolicy</b> </p> <p>Cedar has determined that a policy condition always evaluates to false. If the policy is always false, it can never apply to any query, and so it can never affect an authorization decision.</p> </li> <li> <p> <b>WrongNumberArguments</b> </p> <p>The policy references an extension type with the wrong number of arguments.</p> </li> <li> <p> <b>FunctionArgumentValidationError</b> </p> <p>Cedar couldn\'t parse the argument passed to an extension type. For example, a string that is to be parsed as an IPv4 address can contain only digits and the period character.</p> </li> </ul>', 'refs' => [], ], 'ValidationExceptionField' => [ 'base' => '<p>Details about a field that failed policy validation.</p>', 'refs' => [ 'ValidationExceptionFieldList$member' => NULL, ], ], 'ValidationExceptionFieldList' => [ 'base' => NULL, 'refs' => [ 'ValidationException$fieldList' => '<p>The list of fields that aren\'t valid.</p>', ], ], 'ValidationMode' => [ 'base' => NULL, 'refs' => [ 'ValidationSettings$mode' => '<p>The validation mode currently configured for this policy store. The valid values are:</p> <ul> <li> <p> <b>OFF</b> – Neither Verified Permissions nor Cedar perform any validation on policies. No validation errors are reported by either service.</p> </li> <li> <p> <b>STRICT</b> – Requires a schema to be present in the policy store. Cedar performs validation on all submitted new or updated static policies and policy templates. Any that fail validation are rejected and Cedar doesn\'t store them in the policy store.</p> </li> </ul> <important> <p>If <code>Mode=STRICT</code> and the policy store doesn\'t contain a schema, Verified Permissions rejects all static policies and policy templates because there is no schema to validate against. </p> <p>To submit a static policy or policy template without a schema, you must turn off validation.</p> </important>', ], ], 'ValidationSettings' => [ 'base' => '<p>A structure that contains Cedar policy validation settings for the policy store. The validation mode determines which validation failures that Cedar considers serious enough to block acceptance of a new or edited static policy or policy template. </p> <p>This data type is used as a request parameter in the <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreatePolicyStore.html">CreatePolicyStore</a> and <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicyStore.html">UpdatePolicyStore</a> operations.</p>', 'refs' => [ 'CreatePolicyStoreInput$validationSettings' => '<p>Specifies the validation setting for this policy store.</p> <p>Currently, the only valid and required value is <code>Mode</code>.</p> <important> <p>We recommend that you turn on <code>STRICT</code> mode only after you define a schema. If a schema doesn\'t exist, then <code>STRICT</code> mode causes any policy to fail validation, and Verified Permissions rejects the policy. You can turn off validation by using the <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicyStore">UpdatePolicyStore</a>. Then, when you have a schema defined, use <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicyStore">UpdatePolicyStore</a> again to turn validation back on.</p> </important>', 'GetPolicyStoreOutput$validationSettings' => '<p>The current validation settings for the policy store.</p>', 'UpdatePolicyStoreInput$validationSettings' => '<p>A structure that defines the validation settings that want to enable for the policy store.</p>', ], ], ],];
