<?php
// This file was auto-generated from sdk-root/src/data/wellarchitected/2020-03-31/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Well-Architected Tool</fullname> <p>This is the <i>Well-Architected Tool API Reference</i>. The WA Tool API provides programmatic access to the <a href="http://aws.amazon.com/well-architected-tool">Well-Architected Tool</a> in the <a href="https://console.aws.amazon.com/wellarchitected">Amazon Web Services Management Console</a>. For information about the Well-Architected Tool, see the <a href="https://docs.aws.amazon.com/wellarchitected/latest/userguide/intro.html">Well-Architected Tool User Guide</a>.</p>', 'operations' => [ 'AssociateLenses' => '<p>Associate a lens to a workload.</p> <p>Up to 10 lenses can be associated with a workload in a single API operation. A maximum of 20 lenses can be associated with a workload.</p> <note> <p> <b>Disclaimer</b> </p> <p>By accessing and/or applying custom lenses created by another Amazon Web Services user or account, you acknowledge that custom lenses created by other users and shared with you are Third Party Content as defined in the Amazon Web Services Customer Agreement. </p> </note>', 'AssociateProfiles' => '<p>Associate a profile with a workload.</p>', 'CreateLensShare' => '<p>Create a lens share.</p> <p>The owner of a lens can share it with other Amazon Web Services accounts, users, an organization, and organizational units (OUs) in the same Amazon Web Services Region. Lenses provided by Amazon Web Services (Amazon Web Services Official Content) cannot be shared.</p> <p> Shared access to a lens is not removed until the lens invitation is deleted.</p> <p>If you share a lens with an organization or OU, all accounts in the organization or OU are granted access to the lens.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/wellarchitected/latest/userguide/lenses-sharing.html">Sharing a custom lens</a> in the <i>Well-Architected Tool User Guide</i>.</p> <note> <p> <b>Disclaimer</b> </p> <p>By sharing your custom lenses with other Amazon Web Services accounts, you acknowledge that Amazon Web Services will make your custom lenses available to those other accounts. Those other accounts may continue to access and use your shared custom lenses even if you delete the custom lenses from your own Amazon Web Services account or terminate your Amazon Web Services account.</p> </note>', 'CreateLensVersion' => '<p>Create a new lens version.</p> <p>A lens can have up to 100 versions.</p> <p>Use this operation to publish a new lens version after you have imported a lens. The <code>LensAlias</code> is used to identify the lens to be published. The owner of a lens can share the lens with other Amazon Web Services accounts and users in the same Amazon Web Services Region. Only the owner of a lens can delete it. </p>', 'CreateMilestone' => '<p>Create a milestone for an existing workload.</p>', 'CreateProfile' => '<p>Create a profile.</p>', 'CreateProfileShare' => '<p>Create a profile share.</p>', 'CreateReviewTemplate' => '<p>Create a review template.</p> <note> <p> <b>Disclaimer</b> </p> <p>Do not include or gather personal identifiable information (PII) of end users or other identifiable individuals in or via your review templates. If your review template or those shared with you and used in your account do include or collect PII you are responsible for: ensuring that the included PII is processed in accordance with applicable law, providing adequate privacy notices, and obtaining necessary consents for processing such data.</p> </note>', 'CreateTemplateShare' => '<p>Create a review template share.</p> <p>The owner of a review template can share it with other Amazon Web Services accounts, users, an organization, and organizational units (OUs) in the same Amazon Web Services Region. </p> <p> Shared access to a review template is not removed until the review template share invitation is deleted.</p> <p>If you share a review template with an organization or OU, all accounts in the organization or OU are granted access to the review template.</p> <note> <p> <b>Disclaimer</b> </p> <p>By sharing your review template with other Amazon Web Services accounts, you acknowledge that Amazon Web Services will make your review template available to those other accounts.</p> </note>', 'CreateWorkload' => '<p>Create a new workload.</p> <p>The owner of a workload can share the workload with other Amazon Web Services accounts, users, an organization, and organizational units (OUs) in the same Amazon Web Services Region. Only the owner of a workload can delete it.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/wellarchitected/latest/userguide/define-workload.html">Defining a Workload</a> in the <i>Well-Architected Tool User Guide</i>.</p> <important> <p>Either <code>AwsRegions</code>, <code>NonAwsRegions</code>, or both must be specified when creating a workload.</p> <p>You also must specify <code>ReviewOwner</code>, even though the parameter is listed as not being required in the following section. </p> </important> <p>When creating a workload using a review template, you must have the following IAM permissions:</p> <ul> <li> <p> <code>wellarchitected:GetReviewTemplate</code> </p> </li> <li> <p> <code>wellarchitected:GetReviewTemplateAnswer</code> </p> </li> <li> <p> <code>wellarchitected:ListReviewTemplateAnswers</code> </p> </li> <li> <p> <code>wellarchitected:GetReviewTemplateLensReview</code> </p> </li> </ul>', 'CreateWorkloadShare' => '<p>Create a workload share.</p> <p>The owner of a workload can share it with other Amazon Web Services accounts and users in the same Amazon Web Services Region. Shared access to a workload is not removed until the workload invitation is deleted.</p> <p>If you share a workload with an organization or OU, all accounts in the organization or OU are granted access to the workload.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/wellarchitected/latest/userguide/workloads-sharing.html">Sharing a workload</a> in the <i>Well-Architected Tool User Guide</i>.</p>', 'DeleteLens' => '<p>Delete an existing lens.</p> <p>Only the owner of a lens can delete it. After the lens is deleted, Amazon Web Services accounts and users that you shared the lens with can continue to use it, but they will no longer be able to apply it to new workloads. </p> <note> <p> <b>Disclaimer</b> </p> <p>By sharing your custom lenses with other Amazon Web Services accounts, you acknowledge that Amazon Web Services will make your custom lenses available to those other accounts. Those other accounts may continue to access and use your shared custom lenses even if you delete the custom lenses from your own Amazon Web Services account or terminate your Amazon Web Services account.</p> </note>', 'DeleteLensShare' => '<p>Delete a lens share.</p> <p>After the lens share is deleted, Amazon Web Services accounts, users, organizations, and organizational units (OUs) that you shared the lens with can continue to use it, but they will no longer be able to apply it to new workloads.</p> <note> <p> <b>Disclaimer</b> </p> <p>By sharing your custom lenses with other Amazon Web Services accounts, you acknowledge that Amazon Web Services will make your custom lenses available to those other accounts. Those other accounts may continue to access and use your shared custom lenses even if you delete the custom lenses from your own Amazon Web Services account or terminate your Amazon Web Services account.</p> </note>', 'DeleteProfile' => '<p>Delete a profile.</p> <note> <p> <b>Disclaimer</b> </p> <p>By sharing your profile with other Amazon Web Services accounts, you acknowledge that Amazon Web Services will make your profile available to those other accounts. Those other accounts may continue to access and use your shared profile even if you delete the profile from your own Amazon Web Services account or terminate your Amazon Web Services account.</p> </note>', 'DeleteProfileShare' => '<p>Delete a profile share.</p>', 'DeleteReviewTemplate' => '<p>Delete a review template.</p> <p>Only the owner of a review template can delete it.</p> <p>After the review template is deleted, Amazon Web Services accounts, users, organizations, and organizational units (OUs) that you shared the review template with will no longer be able to apply it to new workloads.</p>', 'DeleteTemplateShare' => '<p>Delete a review template share.</p> <p>After the review template share is deleted, Amazon Web Services accounts, users, organizations, and organizational units (OUs) that you shared the review template with will no longer be able to apply it to new workloads.</p>', 'DeleteWorkload' => '<p>Delete an existing workload.</p>', 'DeleteWorkloadShare' => '<p>Delete a workload share.</p>', 'DisassociateLenses' => '<p>Disassociate a lens from a workload.</p> <p>Up to 10 lenses can be disassociated from a workload in a single API operation.</p> <note> <p>The Amazon Web Services Well-Architected Framework lens (<code>wellarchitected</code>) cannot be removed from a workload.</p> </note>', 'DisassociateProfiles' => '<p>Disassociate a profile from a workload.</p>', 'ExportLens' => '<p>Export an existing lens.</p> <p>Only the owner of a lens can export it. Lenses provided by Amazon Web Services (Amazon Web Services Official Content) cannot be exported.</p> <p>Lenses are defined in JSON. For more information, see <a href="https://docs.aws.amazon.com/wellarchitected/latest/userguide/lenses-format-specification.html">JSON format specification</a> in the <i>Well-Architected Tool User Guide</i>.</p> <note> <p> <b>Disclaimer</b> </p> <p>Do not include or gather personal identifiable information (PII) of end users or other identifiable individuals in or via your custom lenses. If your custom lens or those shared with you and used in your account do include or collect PII you are responsible for: ensuring that the included PII is processed in accordance with applicable law, providing adequate privacy notices, and obtaining necessary consents for processing such data.</p> </note>', 'GetAnswer' => '<p>Get the answer to a specific question in a workload review.</p>', 'GetConsolidatedReport' => '<p>Get a consolidated report of your workloads.</p> <p>You can optionally choose to include workloads that have been shared with you.</p>', 'GetGlobalSettings' => '<p>Global settings for all workloads.</p>', 'GetLens' => '<p>Get an existing lens.</p>', 'GetLensReview' => '<p>Get lens review.</p>', 'GetLensReviewReport' => '<p>Get lens review report.</p>', 'GetLensVersionDifference' => '<p>Get lens version differences.</p>', 'GetMilestone' => '<p>Get a milestone for an existing workload.</p>', 'GetProfile' => '<p>Get profile information.</p>', 'GetProfileTemplate' => '<p>Get profile template.</p>', 'GetReviewTemplate' => '<p>Get review template.</p>', 'GetReviewTemplateAnswer' => '<p>Get review template answer.</p>', 'GetReviewTemplateLensReview' => '<p>Get a lens review associated with a review template.</p>', 'GetWorkload' => '<p>Get an existing workload.</p>', 'ImportLens' => '<p>Import a new custom lens or update an existing custom lens.</p> <p>To update an existing custom lens, specify its ARN as the <code>LensAlias</code>. If no ARN is specified, a new custom lens is created.</p> <p>The new or updated lens will have a status of <code>DRAFT</code>. The lens cannot be applied to workloads or shared with other Amazon Web Services accounts until it\'s published with <a>CreateLensVersion</a>.</p> <p>Lenses are defined in JSON. For more information, see <a href="https://docs.aws.amazon.com/wellarchitected/latest/userguide/lenses-format-specification.html">JSON format specification</a> in the <i>Well-Architected Tool User Guide</i>.</p> <p>A custom lens cannot exceed 500 KB in size.</p> <note> <p> <b>Disclaimer</b> </p> <p>Do not include or gather personal identifiable information (PII) of end users or other identifiable individuals in or via your custom lenses. If your custom lens or those shared with you and used in your account do include or collect PII you are responsible for: ensuring that the included PII is processed in accordance with applicable law, providing adequate privacy notices, and obtaining necessary consents for processing such data.</p> </note>', 'ListAnswers' => '<p>List of answers for a particular workload and lens.</p>', 'ListCheckDetails' => '<p>List of Trusted Advisor check details by account related to the workload.</p>', 'ListCheckSummaries' => '<p>List of Trusted Advisor checks summarized for all accounts related to the workload.</p>', 'ListLensReviewImprovements' => '<p>List the improvements of a particular lens review.</p>', 'ListLensReviews' => '<p>List lens reviews for a particular workload.</p>', 'ListLensShares' => '<p>List the lens shares associated with the lens.</p>', 'ListLenses' => '<p>List the available lenses.</p>', 'ListMilestones' => '<p>List all milestones for an existing workload.</p>', 'ListNotifications' => '<p>List lens notifications.</p>', 'ListProfileNotifications' => '<p>List profile notifications.</p>', 'ListProfileShares' => '<p>List profile shares.</p>', 'ListProfiles' => '<p>List profiles.</p>', 'ListReviewTemplateAnswers' => '<p>List the answers of a review template.</p>', 'ListReviewTemplates' => '<p>List review templates.</p>', 'ListShareInvitations' => '<p>List the share invitations.</p> <p> <code>WorkloadNamePrefix</code>, <code>LensNamePrefix</code>, <code>ProfileNamePrefix</code>, and <code>TemplateNamePrefix</code> are mutually exclusive. Use the parameter that matches your <code>ShareResourceType</code>.</p>', 'ListTagsForResource' => '<p>List the tags for a resource.</p> <note> <p>The WorkloadArn parameter can be a workload ARN, a custom lens ARN, a profile ARN, or review template ARN.</p> </note>', 'ListTemplateShares' => '<p>List review template shares.</p>', 'ListWorkloadShares' => '<p>List the workload shares associated with the workload.</p>', 'ListWorkloads' => '<p>Paginated list of workloads.</p>', 'TagResource' => '<p>Adds one or more tags to the specified resource.</p> <note> <p>The WorkloadArn parameter can be a workload ARN, a custom lens ARN, a profile ARN, or review template ARN.</p> </note>', 'UntagResource' => '<p>Deletes specified tags from a resource.</p> <note> <p>The WorkloadArn parameter can be a workload ARN, a custom lens ARN, a profile ARN, or review template ARN.</p> </note> <p>To specify multiple tags, use separate <b>tagKeys</b> parameters, for example:</p> <p> <code>DELETE /tags/WorkloadArn?tagKeys=key1&amp;tagKeys=key2</code> </p>', 'UpdateAnswer' => '<p>Update the answer to a specific question in a workload review.</p>', 'UpdateGlobalSettings' => '<p>Update whether the Amazon Web Services account is opted into organization sharing and discovery integration features.</p>', 'UpdateIntegration' => '<p>Update integration features.</p>', 'UpdateLensReview' => '<p>Update lens review for a particular workload.</p>', 'UpdateProfile' => '<p>Update a profile.</p>', 'UpdateReviewTemplate' => '<p>Update a review template.</p>', 'UpdateReviewTemplateAnswer' => '<p>Update a review template answer.</p>', 'UpdateReviewTemplateLensReview' => '<p>Update a lens review associated with a review template.</p>', 'UpdateShareInvitation' => '<p>Update a workload or custom lens share invitation.</p> <note> <p>This API operation can be called independently of any resource. Previous documentation implied that a workload ARN must be specified.</p> </note>', 'UpdateWorkload' => '<p>Update an existing workload.</p>', 'UpdateWorkloadShare' => '<p>Update a workload share.</p>', 'UpgradeLensReview' => '<p>Upgrade lens review for a particular workload.</p>', 'UpgradeProfileVersion' => '<p>Upgrade a profile.</p>', 'UpgradeReviewTemplateLensReview' => '<p>Upgrade the lens review of a review template.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>User does not have sufficient access to perform this action.</p>', 'refs' => [], ], 'AccountJiraConfigurationInput' => [ 'base' => '<p>Account-level: Input for the Jira configuration.</p>', 'refs' => [ 'UpdateGlobalSettingsInput$JiraConfiguration' => '<p>The status of Jira integration settings.</p>', ], ], 'AccountJiraConfigurationOutput' => [ 'base' => '<p>Account-level: Output configuration of the Jira integration.</p>', 'refs' => [ 'GetGlobalSettingsOutput$JiraConfiguration' => '<p>Jira configuration status.</p>', ], ], 'AccountJiraIssueManagementStatus' => [ 'base' => NULL, 'refs' => [ 'AccountJiraConfigurationInput$IssueManagementStatus' => '<p>Account-level: Jira issue management status.</p>', 'AccountJiraConfigurationOutput$IssueManagementStatus' => '<p>Account-level: Jira issue management status.</p>', ], ], 'AccountSummary' => [ 'base' => '<p>Account summary for a Well-Architected best practice in relation to Trusted Advisor checks.</p>', 'refs' => [ 'CheckSummary$AccountSummary' => '<p>Account summary associated to the check.</p>', ], ], 'AdditionalResourceType' => [ 'base' => NULL, 'refs' => [ 'AdditionalResources$Type' => '<p>Type of additional resource for a custom lens.</p>', ], ], 'AdditionalResources' => [ 'base' => '<p>The choice level additional resources for a custom lens.</p> <p>This field does not apply to Amazon Web Services official lenses.</p>', 'refs' => [ 'AdditionalResourcesList$member' => NULL, ], ], 'AdditionalResourcesList' => [ 'base' => NULL, 'refs' => [ 'Choice$AdditionalResources' => '<p>The additional resources for a choice in a custom lens.</p> <p>A choice can have up to two additional resources: one of type <code>HELPFUL_RESOURCE</code>, one of type <code>IMPROVEMENT_PLAN</code>, or both.</p>', ], ], 'Answer' => [ 'base' => '<p>An answer of the question.</p>', 'refs' => [ 'GetAnswerOutput$Answer' => NULL, 'UpdateAnswerOutput$Answer' => NULL, ], ], 'AnswerReason' => [ 'base' => NULL, 'refs' => [ 'Answer$Reason' => '<p>The reason why the question is not applicable to your workload.</p>', 'AnswerSummary$Reason' => '<p>The reason why a choice is non-applicable to a question in your workload.</p>', 'ReviewTemplateAnswer$Reason' => '<p>The reason why the question is not applicable to your review template.</p>', 'ReviewTemplateAnswerSummary$Reason' => '<p>The reason why a choice is not-applicable to a question in the review template.</p>', 'UpdateAnswerInput$Reason' => '<p>The reason why a question is not applicable to your workload.</p>', 'UpdateReviewTemplateAnswerInput$Reason' => '<p>The update reason.</p>', ], ], 'AnswerSummaries' => [ 'base' => '<p>List of answer summaries of lens review in a workload.</p>', 'refs' => [ 'ListAnswersOutput$AnswerSummaries' => NULL, ], ], 'AnswerSummary' => [ 'base' => '<p>An answer summary of a lens review in a workload.</p>', 'refs' => [ 'AnswerSummaries$member' => NULL, ], ], 'ApplicationArn' => [ 'base' => NULL, 'refs' => [ 'WorkloadApplications$member' => NULL, ], ], 'AssociateLensesInput' => [ 'base' => '<p>Input to associate lens reviews.</p>', 'refs' => [], ], 'AssociateProfilesInput' => [ 'base' => NULL, 'refs' => [], ], 'AwsAccountId' => [ 'base' => '<p>An Amazon Web Services account ID.</p>', 'refs' => [ 'CheckDetail$AccountId' => NULL, 'LensSummary$Owner' => NULL, 'Profile$Owner' => NULL, 'ProfileSummary$Owner' => NULL, 'ReviewTemplate$Owner' => NULL, 'ReviewTemplateSummary$Owner' => NULL, 'ShareInvitationSummary$SharedBy' => NULL, 'Workload$Owner' => NULL, 'WorkloadAccountIds$member' => NULL, 'WorkloadShare$SharedBy' => NULL, 'WorkloadSummary$Owner' => NULL, ], ], 'AwsRegion' => [ 'base' => '<p>An Amazon Web Services Region, for example, <code>us-west-2</code> or <code>ap-northeast-1</code>.</p>', 'refs' => [ 'WorkloadAwsRegions$member' => NULL, ], ], 'Base64String' => [ 'base' => '<p>The Base64-encoded string representation of a lens review report.</p> <p>This data can be used to create a PDF file.</p> <p>Only returned by <a>GetConsolidatedReport</a> when <code>PDF</code> format is requested.</p>', 'refs' => [ 'GetConsolidatedReportOutput$Base64String' => NULL, 'LensReviewReport$Base64String' => NULL, ], ], 'BestPractice' => [ 'base' => '<p>A best practice, or question choice, that has been identified as a risk in this question.</p>', 'refs' => [ 'BestPractices$member' => NULL, ], ], 'BestPractices' => [ 'base' => NULL, 'refs' => [ 'QuestionMetric$BestPractices' => '<p>The best practices, or choices, that have been identified as contributing to risk in a question.</p>', ], ], 'CheckDescription' => [ 'base' => NULL, 'refs' => [ 'CheckDetail$Description' => '<p>Trusted Advisor check description.</p>', 'CheckSummary$Description' => '<p>Trusted Advisor check description.</p>', ], ], 'CheckDetail' => [ 'base' => '<p>Account details for a Well-Architected best practice in relation to Trusted Advisor checks.</p>', 'refs' => [ 'CheckDetails$member' => NULL, ], ], 'CheckDetails' => [ 'base' => NULL, 'refs' => [ 'ListCheckDetailsOutput$CheckDetails' => '<p>The details about the Trusted Advisor checks related to the Well-Architected best practice.</p>', ], ], 'CheckFailureReason' => [ 'base' => NULL, 'refs' => [ 'CheckDetail$Reason' => '<p>Reason associated to the check.</p>', ], ], 'CheckId' => [ 'base' => NULL, 'refs' => [ 'CheckDetail$Id' => '<p>Trusted Advisor check ID.</p>', 'CheckSummary$Id' => '<p>Trusted Advisor check ID.</p>', ], ], 'CheckName' => [ 'base' => NULL, 'refs' => [ 'CheckDetail$Name' => '<p>Trusted Advisor check name.</p>', 'CheckSummary$Name' => '<p>Trusted Advisor check name.</p>', ], ], 'CheckProvider' => [ 'base' => NULL, 'refs' => [ 'CheckDetail$Provider' => '<p>Provider of the check related to the best practice.</p>', 'CheckSummary$Provider' => '<p>Provider of the check related to the best practice.</p>', ], ], 'CheckStatus' => [ 'base' => NULL, 'refs' => [ 'AccountSummary$key' => NULL, 'CheckDetail$Status' => '<p>Status associated to the check.</p>', 'CheckSummary$Status' => '<p>Status associated to the check.</p>', ], ], 'CheckStatusCount' => [ 'base' => NULL, 'refs' => [ 'AccountSummary$value' => NULL, ], ], 'CheckSummaries' => [ 'base' => NULL, 'refs' => [ 'ListCheckSummariesOutput$CheckSummaries' => '<p>List of Trusted Advisor summaries related to the Well-Architected best practice.</p>', ], ], 'CheckSummary' => [ 'base' => '<p>Trusted Advisor check summary.</p>', 'refs' => [ 'CheckSummaries$member' => NULL, ], ], 'Choice' => [ 'base' => '<p>A choice available to answer question.</p>', 'refs' => [ 'Choices$member' => NULL, ], ], 'ChoiceAnswer' => [ 'base' => '<p>A choice that has been answered on a question in your workload.</p>', 'refs' => [ 'ChoiceAnswers$member' => NULL, ], ], 'ChoiceAnswerSummaries' => [ 'base' => NULL, 'refs' => [ 'AnswerSummary$ChoiceAnswerSummaries' => '<p>A list of selected choices to a question in your workload.</p>', 'ReviewTemplateAnswerSummary$ChoiceAnswerSummaries' => '<p>A list of selected choices to a question in the review template.</p>', ], ], 'ChoiceAnswerSummary' => [ 'base' => '<p>A choice summary that has been answered on a question in your workload.</p>', 'refs' => [ 'ChoiceAnswerSummaries$member' => NULL, ], ], 'ChoiceAnswers' => [ 'base' => NULL, 'refs' => [ 'Answer$ChoiceAnswers' => '<p>A list of selected choices to a question in your workload.</p>', 'ReviewTemplateAnswer$ChoiceAnswers' => '<p>A list of selected choices to a question in your review template.</p>', ], ], 'ChoiceContent' => [ 'base' => '<p>The choice content.</p>', 'refs' => [ 'Choice$HelpfulResource' => '<p>The helpful resource (both text and URL) for a particular choice.</p> <p>This field only applies to custom lenses. Each choice can have only one helpful resource.</p>', 'Choice$ImprovementPlan' => '<p>The improvement plan (both text and URL) for a particular choice.</p> <p>This field only applies to custom lenses. Each choice can have only one improvement plan.</p>', 'Urls$member' => NULL, ], ], 'ChoiceContentDisplayText' => [ 'base' => NULL, 'refs' => [ 'ChoiceContent$DisplayText' => '<p>The display text for the choice content.</p>', ], ], 'ChoiceContentUrl' => [ 'base' => NULL, 'refs' => [ 'ChoiceContent$Url' => '<p>The URL for the choice content.</p>', ], ], 'ChoiceDescription' => [ 'base' => '<p>The description of a choice.</p>', 'refs' => [ 'Choice$Description' => NULL, 'ProfileChoice$ChoiceDescription' => NULL, 'ProfileTemplateChoice$ChoiceDescription' => NULL, ], ], 'ChoiceId' => [ 'base' => '<p>The ID of a choice.</p>', 'refs' => [ 'BestPractice$ChoiceId' => NULL, 'CheckDetail$ChoiceId' => NULL, 'CheckSummary$ChoiceId' => NULL, 'Choice$ChoiceId' => NULL, 'ChoiceAnswer$ChoiceId' => NULL, 'ChoiceAnswerSummary$ChoiceId' => NULL, 'ChoiceImprovementPlan$ChoiceId' => NULL, 'ChoiceUpdates$key' => NULL, 'ListCheckDetailsInput$ChoiceId' => NULL, 'ListCheckSummariesInput$ChoiceId' => NULL, 'ProfileChoice$ChoiceId' => NULL, 'ProfileTemplateChoice$ChoiceId' => NULL, 'SelectedChoiceIds$member' => NULL, 'SelectedChoices$member' => NULL, 'SelectedProfileChoiceIds$member' => NULL, ], ], 'ChoiceImprovementPlan' => [ 'base' => '<p>The choice level improvement plan.</p>', 'refs' => [ 'ChoiceImprovementPlans$member' => NULL, ], ], 'ChoiceImprovementPlans' => [ 'base' => NULL, 'refs' => [ 'ImprovementSummary$ImprovementPlans' => '<p>The improvement plan details.</p>', ], ], 'ChoiceNotes' => [ 'base' => NULL, 'refs' => [ 'ChoiceAnswer$Notes' => '<p>The notes associated with a choice.</p>', 'ChoiceUpdate$Notes' => '<p>The notes associated with a choice.</p>', ], ], 'ChoiceReason' => [ 'base' => NULL, 'refs' => [ 'ChoiceAnswer$Reason' => '<p>The reason why a choice is non-applicable to a question in your workload.</p>', 'ChoiceAnswerSummary$Reason' => '<p>The reason why a choice is non-applicable to a question in your workload.</p>', 'ChoiceUpdate$Reason' => '<p>The reason why a choice is non-applicable to a question in your workload.</p>', ], ], 'ChoiceStatus' => [ 'base' => NULL, 'refs' => [ 'ChoiceAnswer$Status' => '<p>The status of a choice.</p>', 'ChoiceAnswerSummary$Status' => '<p>The status of a choice.</p>', 'ChoiceUpdate$Status' => '<p>The status of a choice.</p>', ], ], 'ChoiceTitle' => [ 'base' => '<p>The title of a choice.</p>', 'refs' => [ 'BestPractice$ChoiceTitle' => NULL, 'Choice$Title' => NULL, 'ProfileChoice$ChoiceTitle' => NULL, 'ProfileTemplateChoice$ChoiceTitle' => NULL, ], ], 'ChoiceUpdate' => [ 'base' => '<p>A list of choices to be updated.</p>', 'refs' => [ 'ChoiceUpdates$value' => NULL, ], ], 'ChoiceUpdates' => [ 'base' => NULL, 'refs' => [ 'UpdateAnswerInput$ChoiceUpdates' => '<p>A list of choices to update on a question in your workload. The String key corresponds to the choice ID to be updated.</p>', 'UpdateReviewTemplateAnswerInput$ChoiceUpdates' => '<p>A list of choices to be updated.</p>', ], ], 'Choices' => [ 'base' => '<p>List of choices available for a question.</p>', 'refs' => [ 'Answer$Choices' => NULL, 'AnswerSummary$Choices' => NULL, 'ReviewTemplateAnswer$Choices' => NULL, 'ReviewTemplateAnswerSummary$Choices' => NULL, ], ], 'ClientRequestToken' => [ 'base' => '<p>A unique case-sensitive string used to ensure that this request is idempotent (executes only once).</p> <p>You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after the original request has completed successfully, the result of the original request is returned.</p> <important> <p>This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.</p> </important>', 'refs' => [ 'CreateLensShareInput$ClientRequestToken' => NULL, 'CreateLensVersionInput$ClientRequestToken' => NULL, 'CreateMilestoneInput$ClientRequestToken' => NULL, 'CreateProfileInput$ClientRequestToken' => NULL, 'CreateProfileShareInput$ClientRequestToken' => NULL, 'CreateReviewTemplateInput$ClientRequestToken' => NULL, 'CreateTemplateShareInput$ClientRequestToken' => NULL, 'CreateWorkloadInput$ClientRequestToken' => NULL, 'CreateWorkloadShareInput$ClientRequestToken' => NULL, 'DeleteLensInput$ClientRequestToken' => NULL, 'DeleteLensShareInput$ClientRequestToken' => NULL, 'DeleteProfileInput$ClientRequestToken' => NULL, 'DeleteProfileShareInput$ClientRequestToken' => NULL, 'DeleteReviewTemplateInput$ClientRequestToken' => NULL, 'DeleteTemplateShareInput$ClientRequestToken' => NULL, 'DeleteWorkloadInput$ClientRequestToken' => NULL, 'DeleteWorkloadShareInput$ClientRequestToken' => NULL, 'ImportLensInput$ClientRequestToken' => NULL, 'UpdateIntegrationInput$ClientRequestToken' => NULL, 'UpgradeLensReviewInput$ClientRequestToken' => NULL, 'UpgradeProfileVersionInput$ClientRequestToken' => NULL, 'UpgradeReviewTemplateLensReviewInput$ClientRequestToken' => NULL, ], ], 'ConflictException' => [ 'base' => '<p>The resource has already been processed, was deleted, or is too large.</p>', 'refs' => [], ], 'ConsolidatedReportMetric' => [ 'base' => '<p>A metric that contributes to the consolidated report.</p>', 'refs' => [ 'ConsolidatedReportMetrics$member' => NULL, ], ], 'ConsolidatedReportMetrics' => [ 'base' => NULL, 'refs' => [ 'GetConsolidatedReportOutput$Metrics' => '<p>The metrics that make up the consolidated report.</p> <p>Only returned when <code>JSON</code> format is requested.</p>', ], ], 'Count' => [ 'base' => '<p>A non-negative integer that denotes how many.</p>', 'refs' => [ 'QuestionCounts$value' => NULL, 'RiskCounts$value' => NULL, ], ], 'CreateLensShareInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateLensShareOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateLensVersionInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateLensVersionOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateMilestoneInput' => [ 'base' => '<p>Input for milestone creation.</p>', 'refs' => [], ], 'CreateMilestoneOutput' => [ 'base' => '<p>Output of a create milestone call.</p>', 'refs' => [], ], 'CreateProfileInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateProfileOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateProfileShareInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateProfileShareOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateReviewTemplateInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateReviewTemplateOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateTemplateShareInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateTemplateShareOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateWorkloadInput' => [ 'base' => '<p>Input for workload creation.</p>', 'refs' => [], ], 'CreateWorkloadOutput' => [ 'base' => '<p>Output of a create workload call.</p>', 'refs' => [], ], 'CreateWorkloadShareInput' => [ 'base' => '<p>Input for Create Workload Share</p>', 'refs' => [], ], 'CreateWorkloadShareOutput' => [ 'base' => '<p>Input for Create Workload Share</p>', 'refs' => [], ], 'DefinitionType' => [ 'base' => NULL, 'refs' => [ 'WorkloadResourceDefinition$member' => NULL, ], ], 'DeleteLensInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLensShareInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteProfileInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteProfileShareInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteReviewTemplateInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTemplateShareInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWorkloadInput' => [ 'base' => '<p>Input for workload deletion.</p>', 'refs' => [], ], 'DeleteWorkloadShareInput' => [ 'base' => '<p>Input for Delete Workload Share</p>', 'refs' => [], ], 'DifferenceStatus' => [ 'base' => NULL, 'refs' => [ 'PillarDifference$DifferenceStatus' => '<p>Indicates the type of change to the pillar.</p>', 'QuestionDifference$DifferenceStatus' => '<p>Indicates the type of change to the question.</p>', ], ], 'DisassociateLensesInput' => [ 'base' => '<p>Input to disassociate lens reviews.</p>', 'refs' => [], ], 'DisassociateProfilesInput' => [ 'base' => NULL, 'refs' => [], ], 'DiscoveryIntegrationStatus' => [ 'base' => NULL, 'refs' => [ 'GetGlobalSettingsOutput$DiscoveryIntegrationStatus' => '<p>Discovery integration status.</p>', 'UpdateGlobalSettingsInput$DiscoveryIntegrationStatus' => '<p>The status of discovery support settings.</p>', ], ], 'DisplayText' => [ 'base' => NULL, 'refs' => [ 'Answer$HelpfulResourceDisplayText' => '<p>The helpful resource text to be displayed for a custom lens.</p> <p>This field does not apply to Amazon Web Services official lenses.</p>', 'ChoiceImprovementPlan$DisplayText' => '<p>The display text for the improvement plan.</p>', 'ReviewTemplateAnswer$HelpfulResourceDisplayText' => '<p>The helpful resource text to be displayed for a custom lens.</p> <note> <p>This field does not apply to Amazon Web Services official lenses.</p> </note>', ], ], 'ExceptionMessage' => [ 'base' => '<p>Description of the error.</p>', 'refs' => [ 'AccessDeniedException$Message' => NULL, 'ConflictException$Message' => NULL, 'InternalServerException$Message' => NULL, 'ResourceNotFoundException$Message' => NULL, 'ServiceQuotaExceededException$Message' => NULL, 'ThrottlingException$Message' => NULL, 'ValidationException$Message' => NULL, 'ValidationExceptionField$Message' => NULL, ], ], 'ExceptionResourceId' => [ 'base' => '<p>Identifier of the resource affected.</p>', 'refs' => [ 'ConflictException$ResourceId' => NULL, 'ResourceNotFoundException$ResourceId' => NULL, 'ServiceQuotaExceededException$ResourceId' => NULL, ], ], 'ExceptionResourceType' => [ 'base' => '<p>Type of the resource affected.</p>', 'refs' => [ 'ConflictException$ResourceType' => NULL, 'ResourceNotFoundException$ResourceType' => NULL, 'ServiceQuotaExceededException$ResourceType' => NULL, ], ], 'ExportLensInput' => [ 'base' => NULL, 'refs' => [], ], 'ExportLensOutput' => [ 'base' => NULL, 'refs' => [], ], 'FlaggedResources' => [ 'base' => NULL, 'refs' => [ 'CheckDetail$FlaggedResources' => '<p>Count of flagged resources associated to the check.</p>', ], ], 'GetAnswerInput' => [ 'base' => '<p>Input to get answer.</p>', 'refs' => [], ], 'GetAnswerOutput' => [ 'base' => '<p>Output of a get answer call.</p>', 'refs' => [], ], 'GetConsolidatedReportInput' => [ 'base' => NULL, 'refs' => [], ], 'GetConsolidatedReportMaxResults' => [ 'base' => NULL, 'refs' => [ 'GetConsolidatedReportInput$MaxResults' => '<p>The maximum number of results to return for this request.</p>', ], ], 'GetConsolidatedReportOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetGlobalSettingsOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetLensInput' => [ 'base' => NULL, 'refs' => [], ], 'GetLensOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetLensReviewInput' => [ 'base' => '<p>Input to get lens review.</p>', 'refs' => [], ], 'GetLensReviewOutput' => [ 'base' => '<p>Output of a get lens review call.</p>', 'refs' => [], ], 'GetLensReviewReportInput' => [ 'base' => '<p>Input to get lens review report.</p>', 'refs' => [], ], 'GetLensReviewReportOutput' => [ 'base' => '<p>Output of a get lens review report call.</p>', 'refs' => [], ], 'GetLensVersionDifferenceInput' => [ 'base' => NULL, 'refs' => [], ], 'GetLensVersionDifferenceOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetMilestoneInput' => [ 'base' => '<p>Input to get a milestone.</p>', 'refs' => [], ], 'GetMilestoneOutput' => [ 'base' => '<p>Output of a get milestone call.</p>', 'refs' => [], ], 'GetProfileInput' => [ 'base' => NULL, 'refs' => [], ], 'GetProfileOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetProfileTemplateInput' => [ 'base' => NULL, 'refs' => [], ], 'GetProfileTemplateOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetReviewTemplateAnswerInput' => [ 'base' => NULL, 'refs' => [], ], 'GetReviewTemplateAnswerOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetReviewTemplateInput' => [ 'base' => NULL, 'refs' => [], ], 'GetReviewTemplateLensReviewInput' => [ 'base' => NULL, 'refs' => [], ], 'GetReviewTemplateLensReviewOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetReviewTemplateOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetWorkloadInput' => [ 'base' => '<p>Input to get a workload.</p>', 'refs' => [], ], 'GetWorkloadOutput' => [ 'base' => '<p>Output of a get workload call.</p>', 'refs' => [], ], 'HelpfulResourceUrl' => [ 'base' => '<p>The helpful resource URL.</p> <p>For Amazon Web Services official lenses, this is the helpful resource URL for a question or choice.</p> <p>For custom lenses, this is the helpful resource URL for a question and is only provided if <code>HelpfulResourceDisplayText</code> was specified for the question.</p>', 'refs' => [ 'Answer$HelpfulResourceUrl' => NULL, 'ReviewTemplateAnswer$HelpfulResourceUrl' => NULL, ], ], 'ImportLensInput' => [ 'base' => NULL, 'refs' => [], ], 'ImportLensOutput' => [ 'base' => NULL, 'refs' => [], ], 'ImportLensStatus' => [ 'base' => NULL, 'refs' => [ 'ImportLensOutput$Status' => '<p>The status of the imported lens.</p>', ], ], 'ImprovementPlanUrl' => [ 'base' => '<p>The improvement plan URL for a question in an Amazon Web Services official lenses.</p> <p>This value is only available if the question has been answered.</p> <p>This value does not apply to custom lenses.</p>', 'refs' => [ 'Answer$ImprovementPlanUrl' => NULL, 'ChoiceImprovementPlan$ImprovementPlanUrl' => NULL, 'ImprovementSummary$ImprovementPlanUrl' => NULL, 'ReviewTemplateAnswer$ImprovementPlanUrl' => NULL, ], ], 'ImprovementSummaries' => [ 'base' => '<p>List of improvement summaries of lens review in a workload.</p>', 'refs' => [ 'ListLensReviewImprovementsOutput$ImprovementSummaries' => NULL, ], ], 'ImprovementSummary' => [ 'base' => '<p>An improvement summary of a lens review in a workload.</p>', 'refs' => [ 'ImprovementSummaries$member' => NULL, ], ], 'IncludeSharedResources' => [ 'base' => NULL, 'refs' => [ 'GetConsolidatedReportInput$IncludeSharedResources' => '<p>Set to <code>true</code> to have shared resources included in the report.</p>', ], ], 'IntegratingService' => [ 'base' => NULL, 'refs' => [ 'UpdateIntegrationInput$IntegratingService' => '<p>Which integrated service to update.</p>', ], ], 'IntegrationStatus' => [ 'base' => NULL, 'refs' => [ 'AccountJiraConfigurationOutput$IntegrationStatus' => '<p>Account-level: Configuration status of the Jira integration.</p>', ], ], 'IntegrationStatusInput' => [ 'base' => NULL, 'refs' => [ 'AccountJiraConfigurationInput$IntegrationStatus' => '<p>Account-level: Configuration status of the Jira integration.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>There is a problem with the Well-Architected Tool API service.</p>', 'refs' => [], ], 'IsApplicable' => [ 'base' => '<p>Defines whether this question is applicable to a lens review.</p>', 'refs' => [ 'Answer$IsApplicable' => NULL, 'AnswerSummary$IsApplicable' => NULL, 'ReviewTemplateAnswer$IsApplicable' => NULL, 'ReviewTemplateAnswerSummary$IsApplicable' => NULL, 'UpdateAnswerInput$IsApplicable' => NULL, 'UpdateReviewTemplateAnswerInput$IsApplicable' => NULL, ], ], 'IsMajorVersion' => [ 'base' => NULL, 'refs' => [ 'CreateLensVersionInput$IsMajorVersion' => '<p>Set to true if this new major lens version.</p>', ], ], 'IsReviewOwnerUpdateAcknowledged' => [ 'base' => NULL, 'refs' => [ 'UpdateWorkloadInput$IsReviewOwnerUpdateAcknowledged' => '<p>Flag indicating whether the workload owner has acknowledged that the <i>Review owner</i> field is required.</p> <p>If a <b>Review owner</b> is not added to the workload within 60 days of acknowledgement, access to the workload is restricted until an owner is added.</p>', 'Workload$IsReviewOwnerUpdateAcknowledged' => '<p>Flag indicating whether the workload owner has acknowledged that the <i>Review owner</i> field is required.</p> <p>If a <b>Review owner</b> is not added to the workload within 60 days of acknowledgement, access to the workload is restricted until an owner is added.</p>', ], ], 'IssueManagementType' => [ 'base' => NULL, 'refs' => [ 'AccountJiraConfigurationInput$IssueManagementType' => '<p>Account-level: Jira issue management type.</p>', 'AccountJiraConfigurationOutput$IssueManagementType' => '<p>Account-level: Jira issue management type.</p>', 'WorkloadJiraConfigurationInput$IssueManagementType' => '<p>Workload-level: Jira issue management type.</p>', 'WorkloadJiraConfigurationOutput$IssueManagementType' => '<p>Workload-level: Jira issue management type.</p>', ], ], 'JiraConfiguration' => [ 'base' => '<p>Configuration of the Jira integration.</p>', 'refs' => [ 'Answer$JiraConfiguration' => '<p>Configuration of the Jira integration.</p>', 'AnswerSummary$JiraConfiguration' => '<p>Configuration of the Jira integration.</p>', 'ImprovementSummary$JiraConfiguration' => '<p>Configuration of the Jira integration.</p>', ], ], 'JiraIssueUrl' => [ 'base' => NULL, 'refs' => [ 'JiraConfiguration$JiraIssueUrl' => '<p>The URL of the associated Jira issue.</p>', ], ], 'JiraProjectKey' => [ 'base' => NULL, 'refs' => [ 'AccountJiraConfigurationInput$JiraProjectKey' => '<p>Account-level: Jira project key to sync workloads to.</p>', 'AccountJiraConfigurationOutput$JiraProjectKey' => '<p>Account-level: Jira project key to sync workloads to.</p>', 'WorkloadJiraConfigurationInput$JiraProjectKey' => '<p>Workload-level: Jira project key to sync workloads to.</p>', 'WorkloadJiraConfigurationOutput$JiraProjectKey' => '<p>Workload-level: Jira project key to sync workloads to.</p>', ], ], 'JiraSelectedQuestionConfiguration' => [ 'base' => '<p>Selected questions in the workload.</p>', 'refs' => [ 'LensReview$JiraConfiguration' => '<p>Jira configuration status of the Lens review.</p>', 'UpdateLensReviewInput$JiraConfiguration' => '<p>Configuration of the Jira integration.</p>', ], ], 'Lens' => [ 'base' => '<p>A lens return object.</p>', 'refs' => [ 'GetLensOutput$Lens' => '<p>A lens return object.</p>', ], ], 'LensAlias' => [ 'base' => '<p>The alias of the lens.</p> <p>For Amazon Web Services official lenses, this is either the lens alias, such as <code>serverless</code>, or the lens ARN, such as <code>arn:aws:wellarchitected:us-east-1::lens/serverless</code>. Note that some operations (such as ExportLens and CreateLensShare) are not permitted on Amazon Web Services official lenses.</p> <p>For custom lenses, this is the lens ARN, such as <code>arn:aws:wellarchitected:us-west-2:123456789012:lens/0123456789abcdef01234567890abcdef</code>. </p> <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>', 'refs' => [ 'CreateLensShareInput$LensAlias' => NULL, 'CreateLensVersionInput$LensAlias' => NULL, 'DeleteLensInput$LensAlias' => NULL, 'DeleteLensShareInput$LensAlias' => NULL, 'ExportLensInput$LensAlias' => NULL, 'GetAnswerInput$LensAlias' => NULL, 'GetAnswerOutput$LensAlias' => NULL, 'GetLensInput$LensAlias' => NULL, 'GetLensReviewInput$LensAlias' => NULL, 'GetLensReviewReportInput$LensAlias' => NULL, 'GetLensVersionDifferenceInput$LensAlias' => NULL, 'GetLensVersionDifferenceOutput$LensAlias' => NULL, 'GetReviewTemplateAnswerInput$LensAlias' => NULL, 'GetReviewTemplateAnswerOutput$LensAlias' => NULL, 'GetReviewTemplateLensReviewInput$LensAlias' => NULL, 'ImportLensInput$LensAlias' => NULL, 'LensAliases$member' => NULL, 'LensReview$LensAlias' => NULL, 'LensReviewReport$LensAlias' => NULL, 'LensReviewSummary$LensAlias' => NULL, 'LensSummary$LensAlias' => NULL, 'LensUpgradeSummary$LensAlias' => NULL, 'ListAnswersInput$LensAlias' => NULL, 'ListAnswersOutput$LensAlias' => NULL, 'ListLensReviewImprovementsInput$LensAlias' => NULL, 'ListLensReviewImprovementsOutput$LensAlias' => NULL, 'ListLensSharesInput$LensAlias' => NULL, 'ListReviewTemplateAnswersInput$LensAlias' => NULL, 'ListReviewTemplateAnswersOutput$LensAlias' => NULL, 'ReviewTemplateLensAliases$member' => NULL, 'ReviewTemplateLensReview$LensAlias' => NULL, 'ReviewTemplateLenses$member' => NULL, 'ShareInvitation$LensAlias' => NULL, 'UpdateAnswerInput$LensAlias' => NULL, 'UpdateAnswerOutput$LensAlias' => NULL, 'UpdateLensReviewInput$LensAlias' => NULL, 'UpdateReviewTemplateAnswerInput$LensAlias' => NULL, 'UpdateReviewTemplateAnswerOutput$LensAlias' => NULL, 'UpdateReviewTemplateLensReviewInput$LensAlias' => NULL, 'UpgradeLensReviewInput$LensAlias' => NULL, 'UpgradeReviewTemplateLensReviewInput$LensAlias' => NULL, 'WorkloadLenses$member' => NULL, ], ], 'LensAliases' => [ 'base' => '<p>List of lens aliases to associate or disassociate with a workload. Up to 10 lenses can be specified.</p> <p>Identify a lens using its <a>LensSummary$LensAlias</a>.</p>', 'refs' => [ 'AssociateLensesInput$LensAliases' => NULL, 'DisassociateLensesInput$LensAliases' => NULL, ], ], 'LensArn' => [ 'base' => NULL, 'refs' => [ 'CheckDetail$LensArn' => '<p>Well-Architected Lens ARN associated to the check.</p>', 'CheckSummary$LensArn' => '<p>Well-Architected Lens ARN associated to the check.</p>', 'CreateLensVersionOutput$LensArn' => '<p>The ARN for the lens.</p>', 'GetAnswerOutput$LensArn' => '<p>The ARN for the lens.</p>', 'GetLensVersionDifferenceOutput$LensArn' => '<p>The ARN for the lens.</p>', 'ImportLensOutput$LensArn' => '<p>The ARN for the lens that was created or updated.</p>', 'Lens$LensArn' => '<p>The ARN of a lens.</p>', 'LensMetric$LensArn' => '<p>The lens ARN.</p>', 'LensReview$LensArn' => '<p>The ARN for the lens.</p>', 'LensReviewReport$LensArn' => '<p>The ARN for the lens.</p>', 'LensReviewSummary$LensArn' => '<p>The ARN for the lens.</p>', 'LensSummary$LensArn' => '<p>The ARN of the lens.</p>', 'LensUpgradeSummary$LensArn' => '<p>The ARN for the lens.</p>', 'ListAnswersOutput$LensArn' => '<p>The ARN for the lens.</p>', 'ListCheckDetailsInput$LensArn' => '<p>Well-Architected Lens ARN.</p>', 'ListCheckSummariesInput$LensArn' => '<p>Well-Architected Lens ARN.</p>', 'ListLensReviewImprovementsOutput$LensArn' => '<p>The ARN for the lens.</p>', 'ReviewTemplateLensReview$LensArn' => '<p>The lens ARN.</p>', 'ShareInvitation$LensArn' => '<p>The ARN for the lens.</p>', 'ShareInvitationSummary$LensArn' => '<p>The ARN for the lens.</p>', 'UpdateAnswerOutput$LensArn' => '<p>The ARN for the lens.</p>', ], ], 'LensDescription' => [ 'base' => '<p>The description of the lens.</p>', 'refs' => [ 'Lens$Description' => NULL, 'LensSummary$Description' => NULL, ], ], 'LensJSON' => [ 'base' => NULL, 'refs' => [ 'ExportLensOutput$LensJSON' => '<p>The JSON representation of a lens.</p>', 'ImportLensInput$JSONString' => '<p>The JSON representation of a lens.</p>', ], ], 'LensMetric' => [ 'base' => '<p>A metric for a particular lens in a workload.</p>', 'refs' => [ 'LensMetrics$member' => NULL, ], ], 'LensMetrics' => [ 'base' => NULL, 'refs' => [ 'ConsolidatedReportMetric$Lenses' => '<p>The metrics for the lenses in the workload.</p>', ], ], 'LensName' => [ 'base' => '<p>The full name of the lens.</p>', 'refs' => [ 'Lens$Name' => NULL, 'LensReview$LensName' => NULL, 'LensReviewSummary$LensName' => NULL, 'LensSummary$LensName' => NULL, 'ListLensesInput$LensName' => NULL, 'ReviewTemplateLensReview$LensName' => NULL, 'ShareInvitationSummary$LensName' => NULL, ], ], 'LensNamePrefix' => [ 'base' => NULL, 'refs' => [ 'ListShareInvitationsInput$LensNamePrefix' => '<p>An optional string added to the beginning of each lens name returned in the results.</p>', ], ], 'LensOwner' => [ 'base' => NULL, 'refs' => [ 'Lens$Owner' => '<p>The Amazon Web Services account ID that owns the lens.</p>', ], ], 'LensReview' => [ 'base' => '<p>A lens review of a question.</p>', 'refs' => [ 'GetLensReviewOutput$LensReview' => NULL, 'UpdateLensReviewOutput$LensReview' => NULL, ], ], 'LensReviewReport' => [ 'base' => '<p>A report of a lens review.</p>', 'refs' => [ 'GetLensReviewReportOutput$LensReviewReport' => NULL, ], ], 'LensReviewSummaries' => [ 'base' => '<p>List of lens summaries of lens reviews of a workload.</p>', 'refs' => [ 'ListLensReviewsOutput$LensReviewSummaries' => NULL, ], ], 'LensReviewSummary' => [ 'base' => '<p>A lens review summary of a workload.</p>', 'refs' => [ 'LensReviewSummaries$member' => NULL, ], ], 'LensShareSummaries' => [ 'base' => NULL, 'refs' => [ 'ListLensSharesOutput$LensShareSummaries' => '<p>A list of lens share summaries.</p>', ], ], 'LensShareSummary' => [ 'base' => '<p>A lens share summary return object.</p>', 'refs' => [ 'LensShareSummaries$member' => NULL, ], ], 'LensStatus' => [ 'base' => NULL, 'refs' => [ 'LensReview$LensStatus' => '<p>The status of the lens.</p>', 'LensReviewSummary$LensStatus' => '<p>The status of the lens.</p>', 'LensSummary$LensStatus' => '<p>The status of the lens.</p>', 'ReviewTemplateLensReview$LensStatus' => '<p>The status of the lens.</p>', ], ], 'LensStatusType' => [ 'base' => NULL, 'refs' => [ 'DeleteLensInput$LensStatus' => '<p>The status of the lens to be deleted.</p>', 'ListLensesInput$LensStatus' => '<p>The status of lenses to be returned.</p>', ], ], 'LensSummaries' => [ 'base' => '<p>List of lens summaries of available lenses.</p>', 'refs' => [ 'ListLensesOutput$LensSummaries' => NULL, ], ], 'LensSummary' => [ 'base' => '<p>A lens summary of a lens.</p>', 'refs' => [ 'LensSummaries$member' => NULL, ], ], 'LensType' => [ 'base' => NULL, 'refs' => [ 'LensSummary$LensType' => '<p>The type of the lens.</p>', 'ListLensesInput$LensType' => '<p>The type of lenses to be returned.</p>', ], ], 'LensUpgradeSummary' => [ 'base' => '<p>Lens upgrade summary return object.</p>', 'refs' => [ 'NotificationSummary$LensUpgradeSummary' => '<p>Summary of lens upgrade.</p>', ], ], 'LensVersion' => [ 'base' => NULL, 'refs' => [ 'CreateLensVersionInput$LensVersion' => '<p>The version of the lens being created.</p>', 'CreateLensVersionOutput$LensVersion' => '<p>The version of the lens.</p>', 'ExportLensInput$LensVersion' => '<p>The lens version to be exported.</p>', 'GetLensInput$LensVersion' => '<p>The lens version to be retrieved.</p>', 'GetLensVersionDifferenceInput$BaseLensVersion' => '<p>The base version of the lens.</p>', 'GetLensVersionDifferenceInput$TargetLensVersion' => '<p>The lens version to target a difference for.</p>', 'GetLensVersionDifferenceOutput$BaseLensVersion' => '<p>The base version of the lens.</p>', 'GetLensVersionDifferenceOutput$TargetLensVersion' => '<p>The target lens version for the lens.</p>', 'GetLensVersionDifferenceOutput$LatestLensVersion' => '<p>The latest version of the lens.</p>', 'Lens$LensVersion' => '<p>The version of a lens.</p>', 'LensReview$LensVersion' => '<p>The version of the lens.</p>', 'LensReviewSummary$LensVersion' => '<p>The version of the lens.</p>', 'LensSummary$LensVersion' => '<p>The version of the lens.</p>', 'LensUpgradeSummary$CurrentLensVersion' => '<p>The current version of the lens.</p>', 'LensUpgradeSummary$LatestLensVersion' => '<p>The latest version of the lens.</p>', 'ReviewTemplateLensReview$LensVersion' => '<p>The version of the lens.</p>', ], ], 'LensesAppliedCount' => [ 'base' => NULL, 'refs' => [ 'ConsolidatedReportMetric$LensesAppliedCount' => '<p>The total number of lenses applied to the workload.</p>', ], ], 'ListAnswersInput' => [ 'base' => '<p>Input to list answers.</p>', 'refs' => [], ], 'ListAnswersMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListAnswersInput$MaxResults' => '<p>The maximum number of results to return for this request.</p>', ], ], 'ListAnswersOutput' => [ 'base' => '<p>Output of a list answers call.</p>', 'refs' => [], ], 'ListCheckDetailsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListCheckDetailsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListCheckSummariesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListCheckSummariesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListLensReviewImprovementsInput' => [ 'base' => '<p>Input to list lens review improvements.</p>', 'refs' => [], ], 'ListLensReviewImprovementsMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListLensReviewImprovementsInput$MaxResults' => '<p>The maximum number of results to return for this request.</p>', ], ], 'ListLensReviewImprovementsOutput' => [ 'base' => '<p>Output of a list lens review improvements call.</p>', 'refs' => [], ], 'ListLensReviewsInput' => [ 'base' => '<p>Input to list lens reviews.</p>', 'refs' => [], ], 'ListLensReviewsOutput' => [ 'base' => '<p>Output of a list lens reviews call.</p>', 'refs' => [], ], 'ListLensSharesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListLensSharesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListLensesInput' => [ 'base' => '<p>Input to list lenses.</p>', 'refs' => [], ], 'ListLensesOutput' => [ 'base' => '<p>Output of a list lenses call.</p>', 'refs' => [], ], 'ListMilestonesInput' => [ 'base' => '<p>Input to list all milestones for a workload.</p>', 'refs' => [], ], 'ListMilestonesOutput' => [ 'base' => '<p>Output of a list milestones call.</p>', 'refs' => [], ], 'ListNotificationsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListNotificationsMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListNotificationsInput$MaxResults' => '<p>The maximum number of results to return for this request.</p>', ], ], 'ListNotificationsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListProfileNotificationsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListProfileNotificationsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListProfileSharesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListProfileSharesMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListProfileSharesInput$MaxResults' => '<p>The maximum number of results to return for this request.</p>', ], ], 'ListProfileSharesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListProfilesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListProfilesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListReviewTemplateAnswersInput' => [ 'base' => NULL, 'refs' => [], ], 'ListReviewTemplateAnswersMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListReviewTemplateAnswersInput$MaxResults' => '<p>The maximum number of results to return for this request.</p>', ], ], 'ListReviewTemplateAnswersOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListReviewTemplatesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListReviewTemplatesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListShareInvitationsInput' => [ 'base' => '<p>Input for List Share Invitations</p>', 'refs' => [], ], 'ListShareInvitationsMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListShareInvitationsInput$MaxResults' => '<p>The maximum number of results to return for this request.</p>', ], ], 'ListShareInvitationsOutput' => [ 'base' => '<p>Input for List Share Invitations</p>', 'refs' => [], ], 'ListTagsForResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListTemplateSharesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListTemplateSharesMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListTemplateSharesInput$MaxResults' => '<p>The maximum number of results to return for this request.</p>', ], ], 'ListTemplateSharesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkloadSharesInput' => [ 'base' => '<p>Input for List Workload Share</p>', 'refs' => [], ], 'ListWorkloadSharesMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListLensSharesInput$MaxResults' => '<p>The maximum number of results to return for this request.</p>', 'ListWorkloadSharesInput$MaxResults' => '<p>The maximum number of results to return for this request.</p>', ], ], 'ListWorkloadSharesOutput' => [ 'base' => '<p>Input for List Workload Share</p>', 'refs' => [], ], 'ListWorkloadsInput' => [ 'base' => '<p>Input to list all workloads.</p>', 'refs' => [], ], 'ListWorkloadsMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListWorkloadsInput$MaxResults' => '<p>The maximum number of results to return for this request.</p>', ], ], 'ListWorkloadsOutput' => [ 'base' => '<p>Output of a list workloads call.</p>', 'refs' => [], ], 'MaxResults' => [ 'base' => '<p>The maximum number of results to return for this request.</p>', 'refs' => [ 'ListCheckDetailsInput$MaxResults' => NULL, 'ListCheckSummariesInput$MaxResults' => NULL, 'ListLensReviewsInput$MaxResults' => NULL, 'ListLensesInput$MaxResults' => NULL, 'ListMilestonesInput$MaxResults' => NULL, 'ListProfileNotificationsInput$MaxResults' => NULL, 'ListProfilesInput$MaxResults' => NULL, 'ListReviewTemplatesInput$MaxResults' => NULL, ], ], 'MaxSelectedProfileChoices' => [ 'base' => NULL, 'refs' => [ 'ProfileQuestion$MaxSelectedChoices' => '<p>The maximum number of selected choices.</p>', 'ProfileTemplateQuestion$MaxSelectedChoices' => '<p>The maximum number of choices selected.</p>', ], ], 'MetricType' => [ 'base' => NULL, 'refs' => [ 'ConsolidatedReportMetric$MetricType' => '<p>The metric type of a metric in the consolidated report. Currently only WORKLOAD metric types are supported.</p>', ], ], 'Milestone' => [ 'base' => '<p>A milestone return object.</p>', 'refs' => [ 'GetMilestoneOutput$Milestone' => NULL, ], ], 'MilestoneName' => [ 'base' => '<p>The name of the milestone in a workload.</p> <p>Milestone names must be unique within a workload.</p>', 'refs' => [ 'CreateMilestoneInput$MilestoneName' => NULL, 'Milestone$MilestoneName' => NULL, 'MilestoneSummary$MilestoneName' => NULL, 'UpgradeLensReviewInput$MilestoneName' => NULL, 'UpgradeProfileVersionInput$MilestoneName' => NULL, ], ], 'MilestoneNumber' => [ 'base' => '<p>The milestone number.</p> <p>A workload can have a maximum of 100 milestones.</p>', 'refs' => [ 'CreateMilestoneOutput$MilestoneNumber' => NULL, 'GetAnswerInput$MilestoneNumber' => NULL, 'GetAnswerOutput$MilestoneNumber' => NULL, 'GetLensReviewInput$MilestoneNumber' => NULL, 'GetLensReviewOutput$MilestoneNumber' => NULL, 'GetLensReviewReportInput$MilestoneNumber' => NULL, 'GetLensReviewReportOutput$MilestoneNumber' => NULL, 'GetMilestoneInput$MilestoneNumber' => NULL, 'ListAnswersInput$MilestoneNumber' => NULL, 'ListAnswersOutput$MilestoneNumber' => NULL, 'ListLensReviewImprovementsInput$MilestoneNumber' => NULL, 'ListLensReviewImprovementsOutput$MilestoneNumber' => NULL, 'ListLensReviewsInput$MilestoneNumber' => NULL, 'ListLensReviewsOutput$MilestoneNumber' => NULL, 'Milestone$MilestoneNumber' => NULL, 'MilestoneSummary$MilestoneNumber' => NULL, ], ], 'MilestoneSummaries' => [ 'base' => '<p>A list of milestone summaries.</p>', 'refs' => [ 'ListMilestonesOutput$MilestoneSummaries' => NULL, ], ], 'MilestoneSummary' => [ 'base' => '<p>A milestone summary return object.</p>', 'refs' => [ 'MilestoneSummaries$member' => NULL, ], ], 'MinSelectedProfileChoices' => [ 'base' => NULL, 'refs' => [ 'ProfileQuestion$MinSelectedChoices' => '<p>The minimum number of selected choices.</p>', 'ProfileTemplateQuestion$MinSelectedChoices' => '<p>The minimum number of choices selected.</p>', ], ], 'NextToken' => [ 'base' => '<p>The token to use to retrieve the next set of results.</p>', 'refs' => [ 'GetConsolidatedReportInput$NextToken' => NULL, 'GetConsolidatedReportOutput$NextToken' => NULL, 'LensReview$NextToken' => NULL, 'ListAnswersInput$NextToken' => NULL, 'ListAnswersOutput$NextToken' => NULL, 'ListCheckDetailsInput$NextToken' => NULL, 'ListCheckDetailsOutput$NextToken' => NULL, 'ListCheckSummariesInput$NextToken' => NULL, 'ListCheckSummariesOutput$NextToken' => NULL, 'ListLensReviewImprovementsInput$NextToken' => NULL, 'ListLensReviewImprovementsOutput$NextToken' => NULL, 'ListLensReviewsInput$NextToken' => NULL, 'ListLensReviewsOutput$NextToken' => NULL, 'ListLensSharesInput$NextToken' => NULL, 'ListLensSharesOutput$NextToken' => NULL, 'ListLensesInput$NextToken' => NULL, 'ListLensesOutput$NextToken' => NULL, 'ListMilestonesInput$NextToken' => NULL, 'ListMilestonesOutput$NextToken' => NULL, 'ListNotificationsInput$NextToken' => NULL, 'ListNotificationsOutput$NextToken' => NULL, 'ListProfileNotificationsInput$NextToken' => NULL, 'ListProfileNotificationsOutput$NextToken' => NULL, 'ListProfileSharesInput$NextToken' => NULL, 'ListProfileSharesOutput$NextToken' => NULL, 'ListProfilesInput$NextToken' => NULL, 'ListProfilesOutput$NextToken' => NULL, 'ListReviewTemplateAnswersInput$NextToken' => NULL, 'ListReviewTemplateAnswersOutput$NextToken' => NULL, 'ListReviewTemplatesInput$NextToken' => NULL, 'ListReviewTemplatesOutput$NextToken' => NULL, 'ListShareInvitationsInput$NextToken' => NULL, 'ListShareInvitationsOutput$NextToken' => NULL, 'ListTemplateSharesInput$NextToken' => NULL, 'ListTemplateSharesOutput$NextToken' => NULL, 'ListWorkloadSharesInput$NextToken' => NULL, 'ListWorkloadSharesOutput$NextToken' => NULL, 'ListWorkloadsInput$NextToken' => NULL, 'ListWorkloadsOutput$NextToken' => NULL, 'ReviewTemplateLensReview$NextToken' => NULL, ], ], 'Notes' => [ 'base' => '<p>The notes associated with the workload.</p> <p>For a review template, these are the notes that will be associated with the workload when the template is applied.</p>', 'refs' => [ 'Answer$Notes' => NULL, 'CreateReviewTemplateInput$Notes' => NULL, 'CreateWorkloadInput$Notes' => NULL, 'LensReview$Notes' => NULL, 'PillarNotes$value' => NULL, 'PillarReviewSummary$Notes' => NULL, 'ReviewTemplate$Notes' => NULL, 'ReviewTemplateAnswer$Notes' => NULL, 'ReviewTemplateLensReview$Notes' => NULL, 'ReviewTemplatePillarReviewSummary$Notes' => NULL, 'UpdateAnswerInput$Notes' => NULL, 'UpdateLensReviewInput$LensNotes' => NULL, 'UpdateReviewTemplateAnswerInput$Notes' => NULL, 'UpdateReviewTemplateInput$Notes' => NULL, 'UpdateReviewTemplateLensReviewInput$LensNotes' => NULL, 'UpdateWorkloadInput$Notes' => NULL, 'Workload$Notes' => NULL, ], ], 'NotificationSummaries' => [ 'base' => NULL, 'refs' => [ 'ListNotificationsOutput$NotificationSummaries' => '<p>List of lens notification summaries in a workload.</p>', ], ], 'NotificationSummary' => [ 'base' => '<p>A notification summary return object.</p>', 'refs' => [ 'NotificationSummaries$member' => NULL, ], ], 'NotificationType' => [ 'base' => NULL, 'refs' => [ 'NotificationSummary$Type' => '<p>The type of notification.</p>', ], ], 'OrganizationSharingStatus' => [ 'base' => NULL, 'refs' => [ 'GetGlobalSettingsOutput$OrganizationSharingStatus' => '<p>Amazon Web Services Organizations sharing status.</p>', 'UpdateGlobalSettingsInput$OrganizationSharingStatus' => '<p>The status of organization sharing settings.</p>', ], ], 'PermissionType' => [ 'base' => '<p>Permission granted on a share request.</p>', 'refs' => [ 'CreateWorkloadShareInput$PermissionType' => NULL, 'ShareInvitationSummary$PermissionType' => NULL, 'UpdateWorkloadShareInput$PermissionType' => NULL, 'WorkloadShare$PermissionType' => NULL, 'WorkloadShareSummary$PermissionType' => NULL, ], ], 'PillarDifference' => [ 'base' => '<p>A pillar difference return object.</p>', 'refs' => [ 'PillarDifferences$member' => NULL, ], ], 'PillarDifferences' => [ 'base' => NULL, 'refs' => [ 'VersionDifferences$PillarDifferences' => '<p>The differences between the base and latest versions of the lens.</p>', ], ], 'PillarId' => [ 'base' => '<p>The ID used to identify a pillar, for example, <code>security</code>.</p> <p>A pillar is identified by its <a>PillarReviewSummary$PillarId</a>.</p>', 'refs' => [ 'Answer$PillarId' => NULL, 'AnswerSummary$PillarId' => NULL, 'CheckDetail$PillarId' => NULL, 'CheckSummary$PillarId' => NULL, 'ImprovementSummary$PillarId' => NULL, 'ListAnswersInput$PillarId' => NULL, 'ListCheckDetailsInput$PillarId' => NULL, 'ListCheckSummariesInput$PillarId' => NULL, 'ListLensReviewImprovementsInput$PillarId' => NULL, 'ListReviewTemplateAnswersInput$PillarId' => NULL, 'PillarDifference$PillarId' => NULL, 'PillarMetric$PillarId' => NULL, 'PillarNotes$key' => NULL, 'PillarReviewSummary$PillarId' => NULL, 'ReviewTemplateAnswer$PillarId' => NULL, 'ReviewTemplateAnswerSummary$PillarId' => NULL, 'ReviewTemplatePillarReviewSummary$PillarId' => NULL, 'SelectedPillar$PillarId' => NULL, 'WorkloadPillarPriorities$member' => NULL, ], ], 'PillarMetric' => [ 'base' => '<p>A metric for a particular pillar in a lens.</p>', 'refs' => [ 'PillarMetrics$member' => NULL, ], ], 'PillarMetrics' => [ 'base' => NULL, 'refs' => [ 'LensMetric$Pillars' => '<p>The metrics for the pillars in a lens.</p>', ], ], 'PillarName' => [ 'base' => '<p>The name of the pillar.</p>', 'refs' => [ 'PillarDifference$PillarName' => NULL, 'PillarReviewSummary$PillarName' => NULL, 'ReviewTemplatePillarReviewSummary$PillarName' => NULL, ], ], 'PillarNotes' => [ 'base' => '<p>List of pillar notes of a lens review in a workload.</p> <p>For a review template, these are the notes that will be associated with the workload when the template is applied.</p>', 'refs' => [ 'UpdateLensReviewInput$PillarNotes' => NULL, 'UpdateReviewTemplateLensReviewInput$PillarNotes' => NULL, ], ], 'PillarReviewSummaries' => [ 'base' => '<p>List of pillar review summaries of lens review in a workload.</p>', 'refs' => [ 'LensReview$PillarReviewSummaries' => NULL, ], ], 'PillarReviewSummary' => [ 'base' => '<p>A pillar review summary of a lens review.</p>', 'refs' => [ 'PillarReviewSummaries$member' => NULL, ], ], 'Profile' => [ 'base' => '<p>A profile.</p>', 'refs' => [ 'GetProfileOutput$Profile' => '<p>The profile.</p>', 'UpdateProfileOutput$Profile' => '<p>The profile.</p>', ], ], 'ProfileArn' => [ 'base' => NULL, 'refs' => [ 'CreateProfileOutput$ProfileArn' => '<p>The profile ARN.</p>', 'CreateProfileShareInput$ProfileArn' => '<p>The profile ARN.</p>', 'CreateProfileShareOutput$ProfileArn' => '<p>The profile ARN.</p>', 'DeleteProfileInput$ProfileArn' => '<p>The profile ARN.</p>', 'DeleteProfileShareInput$ProfileArn' => '<p>The profile ARN.</p>', 'GetProfileInput$ProfileArn' => '<p>The profile ARN.</p>', 'ListProfileSharesInput$ProfileArn' => '<p>The profile ARN.</p>', 'Profile$ProfileArn' => '<p>The profile ARN.</p>', 'ProfileArns$member' => NULL, 'ProfileNotificationSummary$ProfileArn' => '<p>The profile ARN.</p>', 'ProfileSummary$ProfileArn' => '<p>The profile ARN.</p>', 'ShareInvitation$ProfileArn' => '<p>The profile ARN.</p>', 'ShareInvitationSummary$ProfileArn' => '<p>The profile ARN.</p>', 'UpdateProfileInput$ProfileArn' => '<p>The profile ARN.</p>', 'UpgradeProfileVersionInput$ProfileArn' => '<p>The profile ARN.</p>', 'WorkloadProfile$ProfileArn' => '<p>The profile ARN.</p>', 'WorkloadProfileArns$member' => NULL, ], ], 'ProfileArns' => [ 'base' => NULL, 'refs' => [ 'AssociateProfilesInput$ProfileArns' => '<p>The list of profile ARNs to associate with the workload.</p>', 'DisassociateProfilesInput$ProfileArns' => '<p>The list of profile ARNs to disassociate from the workload.</p>', ], ], 'ProfileChoice' => [ 'base' => '<p>The profile choice.</p>', 'refs' => [ 'ProfileQuestionChoices$member' => NULL, ], ], 'ProfileDescription' => [ 'base' => NULL, 'refs' => [ 'CreateProfileInput$ProfileDescription' => '<p>The profile description.</p>', 'Profile$ProfileDescription' => '<p>The profile description.</p>', 'ProfileSummary$ProfileDescription' => '<p>The profile description.</p>', 'UpdateProfileInput$ProfileDescription' => '<p>The profile description.</p>', ], ], 'ProfileName' => [ 'base' => NULL, 'refs' => [ 'CreateProfileInput$ProfileName' => '<p>Name of the profile.</p>', 'Profile$ProfileName' => '<p>The profile name.</p>', 'ProfileNotificationSummary$ProfileName' => '<p>The profile name.</p>', 'ProfileSummary$ProfileName' => '<p>The profile name.</p>', 'ProfileTemplate$TemplateName' => '<p>The name of the profile template.</p>', 'ShareInvitationSummary$ProfileName' => '<p>The profile name.</p>', ], ], 'ProfileNamePrefix' => [ 'base' => NULL, 'refs' => [ 'ListProfilesInput$ProfileNamePrefix' => '<p>An optional string added to the beginning of each profile name returned in the results.</p>', 'ListShareInvitationsInput$ProfileNamePrefix' => '<p>An optional string added to the beginning of each profile name returned in the results.</p>', ], ], 'ProfileNotificationSummaries' => [ 'base' => NULL, 'refs' => [ 'ListProfileNotificationsOutput$NotificationSummaries' => '<p>Notification summaries.</p>', ], ], 'ProfileNotificationSummary' => [ 'base' => '<p>The profile notification summary.</p>', 'refs' => [ 'ProfileNotificationSummaries$member' => NULL, ], ], 'ProfileNotificationType' => [ 'base' => NULL, 'refs' => [ 'ProfileNotificationSummary$Type' => '<p>Type of notification.</p>', ], ], 'ProfileOwnerType' => [ 'base' => NULL, 'refs' => [ 'ListProfilesInput$ProfileOwnerType' => '<p>Profile owner type.</p>', ], ], 'ProfileQuestion' => [ 'base' => '<p>A profile question.</p>', 'refs' => [ 'ProfileQuestions$member' => NULL, ], ], 'ProfileQuestionChoices' => [ 'base' => NULL, 'refs' => [ 'ProfileQuestion$QuestionChoices' => '<p>The question choices.</p>', ], ], 'ProfileQuestionUpdate' => [ 'base' => '<p>An update to a profile question.</p>', 'refs' => [ 'ProfileQuestionUpdates$member' => NULL, ], ], 'ProfileQuestionUpdates' => [ 'base' => NULL, 'refs' => [ 'CreateProfileInput$ProfileQuestions' => '<p>The profile questions.</p>', 'UpdateProfileInput$ProfileQuestions' => '<p>Profile questions.</p>', ], ], 'ProfileQuestions' => [ 'base' => NULL, 'refs' => [ 'Profile$ProfileQuestions' => '<p>Profile questions.</p>', ], ], 'ProfileShareSummaries' => [ 'base' => NULL, 'refs' => [ 'ListProfileSharesOutput$ProfileShareSummaries' => '<p>Profile share summaries.</p>', ], ], 'ProfileShareSummary' => [ 'base' => '<p>Summary of a profile share.</p>', 'refs' => [ 'ProfileShareSummaries$member' => NULL, ], ], 'ProfileSummaries' => [ 'base' => NULL, 'refs' => [ 'ListProfilesOutput$ProfileSummaries' => '<p>Profile summaries.</p>', ], ], 'ProfileSummary' => [ 'base' => '<p>Summary of a profile.</p>', 'refs' => [ 'ProfileSummaries$member' => NULL, ], ], 'ProfileTemplate' => [ 'base' => '<p>The profile template.</p>', 'refs' => [ 'GetProfileTemplateOutput$ProfileTemplate' => '<p>The profile template.</p>', ], ], 'ProfileTemplateChoice' => [ 'base' => '<p>A profile template choice.</p>', 'refs' => [ 'ProfileTemplateQuestionChoices$member' => NULL, ], ], 'ProfileTemplateQuestion' => [ 'base' => '<p>A profile template question.</p>', 'refs' => [ 'TemplateQuestions$member' => NULL, ], ], 'ProfileTemplateQuestionChoices' => [ 'base' => NULL, 'refs' => [ 'ProfileTemplateQuestion$QuestionChoices' => '<p>The question choices.</p>', ], ], 'ProfileVersion' => [ 'base' => NULL, 'refs' => [ 'CreateProfileOutput$ProfileVersion' => '<p>Version of the profile.</p>', 'GetProfileInput$ProfileVersion' => '<p>The profile version.</p>', 'Profile$ProfileVersion' => '<p>The profile version.</p>', 'ProfileNotificationSummary$CurrentProfileVersion' => '<p>The current profile version.</p>', 'ProfileNotificationSummary$LatestProfileVersion' => '<p>The latest profile version.</p>', 'ProfileSummary$ProfileVersion' => '<p>The profile version.</p>', 'WorkloadProfile$ProfileVersion' => '<p>The profile version.</p>', ], ], 'Question' => [ 'base' => NULL, 'refs' => [ 'QuestionCounts$key' => NULL, ], ], 'QuestionCounts' => [ 'base' => NULL, 'refs' => [ 'ReviewTemplate$QuestionCounts' => '<p>A count of how many total questions are answered and unanswered in the review template.</p>', 'ReviewTemplateLensReview$QuestionCounts' => '<p>A count of how many questions are answered and unanswered in the lens review.</p>', 'ReviewTemplatePillarReviewSummary$QuestionCounts' => '<p>A count of how many questions are answered and unanswered in the requested pillar of the lens review.</p>', ], ], 'QuestionDescription' => [ 'base' => '<p>The description of the question.</p>', 'refs' => [ 'Answer$QuestionDescription' => NULL, 'ProfileQuestion$QuestionDescription' => NULL, 'ProfileTemplateQuestion$QuestionDescription' => NULL, 'ReviewTemplateAnswer$QuestionDescription' => NULL, ], ], 'QuestionDifference' => [ 'base' => '<p>A question difference return object.</p>', 'refs' => [ 'QuestionDifferences$member' => NULL, ], ], 'QuestionDifferences' => [ 'base' => NULL, 'refs' => [ 'PillarDifference$QuestionDifferences' => '<p>List of question differences.</p>', ], ], 'QuestionId' => [ 'base' => '<p>The ID of the question.</p>', 'refs' => [ 'Answer$QuestionId' => NULL, 'AnswerSummary$QuestionId' => NULL, 'CheckDetail$QuestionId' => NULL, 'CheckSummary$QuestionId' => NULL, 'GetAnswerInput$QuestionId' => NULL, 'GetReviewTemplateAnswerInput$QuestionId' => NULL, 'ImprovementSummary$QuestionId' => NULL, 'ListCheckDetailsInput$QuestionId' => NULL, 'ListCheckSummariesInput$QuestionId' => NULL, 'ProfileQuestion$QuestionId' => NULL, 'ProfileQuestionUpdate$QuestionId' => NULL, 'ProfileTemplateQuestion$QuestionId' => NULL, 'QuestionDifference$QuestionId' => NULL, 'QuestionMetric$QuestionId' => NULL, 'ReviewTemplateAnswer$QuestionId' => NULL, 'ReviewTemplateAnswerSummary$QuestionId' => NULL, 'UpdateAnswerInput$QuestionId' => NULL, 'UpdateReviewTemplateAnswerInput$QuestionId' => NULL, ], ], 'QuestionMetric' => [ 'base' => '<p>A metric for a particular question in the pillar. </p>', 'refs' => [ 'QuestionMetrics$member' => NULL, ], ], 'QuestionMetrics' => [ 'base' => NULL, 'refs' => [ 'PillarMetric$Questions' => '<p>The questions that have been identified as risks in the pillar.</p>', ], ], 'QuestionPriority' => [ 'base' => NULL, 'refs' => [ 'ListAnswersInput$QuestionPriority' => '<p>The priority of the question.</p>', 'ListLensReviewImprovementsInput$QuestionPriority' => '<p>The priority of the question.</p>', ], ], 'QuestionTitle' => [ 'base' => '<p>The title of the question.</p>', 'refs' => [ 'Answer$QuestionTitle' => NULL, 'AnswerSummary$QuestionTitle' => NULL, 'ImprovementSummary$QuestionTitle' => NULL, 'ProfileQuestion$QuestionTitle' => NULL, 'ProfileTemplateQuestion$QuestionTitle' => NULL, 'QuestionDifference$QuestionTitle' => NULL, 'ReviewTemplateAnswer$QuestionTitle' => NULL, 'ReviewTemplateAnswerSummary$QuestionTitle' => NULL, ], ], 'QuestionType' => [ 'base' => NULL, 'refs' => [ 'AnswerSummary$QuestionType' => '<p>The type of the question.</p>', 'ReviewTemplateAnswerSummary$QuestionType' => '<p>The type of question.</p>', ], ], 'QuotaCode' => [ 'base' => '<p>Service Quotas requirement to identify originating quota.</p>', 'refs' => [ 'ServiceQuotaExceededException$QuotaCode' => NULL, 'ThrottlingException$QuotaCode' => NULL, ], ], 'ReportFormat' => [ 'base' => NULL, 'refs' => [ 'GetConsolidatedReportInput$Format' => '<p>The format of the consolidated report.</p> <p>For <code>PDF</code>, <code>Base64String</code> is returned. For <code>JSON</code>, <code>Metrics</code> is returned.</p>', ], ], 'ResourceArn' => [ 'base' => NULL, 'refs' => [ 'LensUpgradeSummary$ResourceArn' => '<p> <code>ResourceArn</code> of the lens being upgraded</p>', 'ListNotificationsInput$ResourceArn' => '<p>The ARN for the related resource for the notification.</p> <note> <p>Only one of <code>WorkloadID</code> or <code>ResourceARN</code> should be specified.</p> </note>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The requested resource was not found.</p>', 'refs' => [], ], 'ReviewTemplate' => [ 'base' => '<p>A review template.</p>', 'refs' => [ 'GetReviewTemplateOutput$ReviewTemplate' => '<p>The review template.</p>', 'UpdateReviewTemplateOutput$ReviewTemplate' => '<p>A review template.</p>', ], ], 'ReviewTemplateAnswer' => [ 'base' => '<p>An answer of the question.</p>', 'refs' => [ 'GetReviewTemplateAnswerOutput$Answer' => '<p>An answer of the question.</p>', 'UpdateReviewTemplateAnswerOutput$Answer' => '<p>An answer of the question.</p>', ], ], 'ReviewTemplateAnswerStatus' => [ 'base' => NULL, 'refs' => [ 'ReviewTemplateAnswer$AnswerStatus' => '<p>The status of whether or not this question has been answered.</p>', 'ReviewTemplateAnswerSummary$AnswerStatus' => '<p>The status of whether or not this question has been answered.</p>', ], ], 'ReviewTemplateAnswerSummaries' => [ 'base' => NULL, 'refs' => [ 'ListReviewTemplateAnswersOutput$AnswerSummaries' => '<p>List of answer summaries of a lens review in a review template.</p>', ], ], 'ReviewTemplateAnswerSummary' => [ 'base' => '<p>The summary of review template answers.</p>', 'refs' => [ 'ReviewTemplateAnswerSummaries$member' => NULL, ], ], 'ReviewTemplateArns' => [ 'base' => NULL, 'refs' => [ 'CreateWorkloadInput$ReviewTemplateArns' => '<p>The list of review template ARNs to associate with the workload.</p>', ], ], 'ReviewTemplateLensAliases' => [ 'base' => NULL, 'refs' => [ 'UpdateReviewTemplateInput$LensesToAssociate' => '<p>A list of lens aliases or ARNs to apply to the review template.</p>', 'UpdateReviewTemplateInput$LensesToDisassociate' => '<p>A list of lens aliases or ARNs to unapply to the review template. The <code>wellarchitected</code> lens cannot be unapplied.</p>', ], ], 'ReviewTemplateLensReview' => [ 'base' => '<p>The lens review of a review template.</p>', 'refs' => [ 'GetReviewTemplateLensReviewOutput$LensReview' => '<p>A lens review of a question.</p>', 'UpdateReviewTemplateLensReviewOutput$LensReview' => '<p>A lens review of a question.</p>', ], ], 'ReviewTemplateLenses' => [ 'base' => NULL, 'refs' => [ 'CreateReviewTemplateInput$Lenses' => '<p>Lenses applied to the review template.</p>', 'ReviewTemplate$Lenses' => '<p>The lenses applied to the review template.</p>', 'ReviewTemplateSummary$Lenses' => '<p>Lenses associated with the review template.</p>', ], ], 'ReviewTemplatePillarReviewSummaries' => [ 'base' => NULL, 'refs' => [ 'ReviewTemplateLensReview$PillarReviewSummaries' => '<p>Pillar review summaries of a lens review.</p>', ], ], 'ReviewTemplatePillarReviewSummary' => [ 'base' => '<p>Summary of a review template.</p>', 'refs' => [ 'ReviewTemplatePillarReviewSummaries$member' => NULL, ], ], 'ReviewTemplateSummary' => [ 'base' => '<p>Summary of a review template.</p>', 'refs' => [ 'ReviewTemplates$member' => NULL, ], ], 'ReviewTemplateUpdateStatus' => [ 'base' => NULL, 'refs' => [ 'ReviewTemplate$UpdateStatus' => '<p>The latest status of a review template.</p>', 'ReviewTemplateSummary$UpdateStatus' => '<p>The latest status of a review template.</p>', ], ], 'ReviewTemplates' => [ 'base' => NULL, 'refs' => [ 'ListReviewTemplatesOutput$ReviewTemplates' => '<p>List of review templates.</p>', ], ], 'Risk' => [ 'base' => '<p>The risk for a given workload, lens review, pillar, or question.</p>', 'refs' => [ 'Answer$Risk' => NULL, 'AnswerSummary$Risk' => NULL, 'ImprovementSummary$Risk' => NULL, 'QuestionMetric$Risk' => NULL, 'RiskCounts$key' => NULL, ], ], 'RiskCounts' => [ 'base' => '<p>A map from risk names to the count of how many questions have that rating.</p>', 'refs' => [ 'ConsolidatedReportMetric$RiskCounts' => NULL, 'LensMetric$RiskCounts' => NULL, 'LensReview$RiskCounts' => NULL, 'LensReview$PrioritizedRiskCounts' => NULL, 'LensReviewSummary$RiskCounts' => NULL, 'LensReviewSummary$PrioritizedRiskCounts' => NULL, 'PillarMetric$RiskCounts' => NULL, 'PillarReviewSummary$RiskCounts' => NULL, 'PillarReviewSummary$PrioritizedRiskCounts' => NULL, 'Workload$RiskCounts' => NULL, 'Workload$PrioritizedRiskCounts' => NULL, 'WorkloadSummary$RiskCounts' => NULL, 'WorkloadSummary$PrioritizedRiskCounts' => NULL, ], ], 'SelectedChoiceIds' => [ 'base' => NULL, 'refs' => [ 'ProfileQuestion$SelectedChoiceIds' => '<p>The selected choices.</p>', ], ], 'SelectedChoices' => [ 'base' => '<p>List of selected choice IDs in a question answer.</p> <p>The values entered replace the previously selected choices.</p>', 'refs' => [ 'Answer$SelectedChoices' => NULL, 'AnswerSummary$SelectedChoices' => NULL, 'ReviewTemplateAnswer$SelectedChoices' => NULL, 'ReviewTemplateAnswerSummary$SelectedChoices' => NULL, 'UpdateAnswerInput$SelectedChoices' => NULL, 'UpdateReviewTemplateAnswerInput$SelectedChoices' => NULL, ], ], 'SelectedPillar' => [ 'base' => '<p>The selected pillar.</p>', 'refs' => [ 'SelectedPillars$member' => NULL, ], ], 'SelectedPillars' => [ 'base' => NULL, 'refs' => [ 'JiraSelectedQuestionConfiguration$SelectedPillars' => '<p>Selected pillars in the workload.</p>', ], ], 'SelectedProfileChoiceIds' => [ 'base' => NULL, 'refs' => [ 'ProfileQuestionUpdate$SelectedChoiceIds' => '<p>The selected choices.</p>', ], ], 'SelectedQuestionId' => [ 'base' => NULL, 'refs' => [ 'SelectedQuestionIds$member' => NULL, ], ], 'SelectedQuestionIds' => [ 'base' => NULL, 'refs' => [ 'SelectedPillar$SelectedQuestionIds' => '<p>Selected question IDs in the selected pillar.</p>', ], ], 'ServiceCode' => [ 'base' => '<p>Service Quotas requirement to identify originating service.</p>', 'refs' => [ 'ServiceQuotaExceededException$ServiceCode' => NULL, 'ThrottlingException$ServiceCode' => NULL, ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>The user has reached their resource quota.</p>', 'refs' => [], ], 'ShareId' => [ 'base' => '<p>The ID associated with the share.</p>', 'refs' => [ 'CreateLensShareOutput$ShareId' => NULL, 'CreateProfileShareOutput$ShareId' => NULL, 'CreateTemplateShareOutput$ShareId' => NULL, 'CreateWorkloadShareOutput$ShareId' => NULL, 'DeleteLensShareInput$ShareId' => NULL, 'DeleteProfileShareInput$ShareId' => NULL, 'DeleteTemplateShareInput$ShareId' => NULL, 'DeleteWorkloadShareInput$ShareId' => NULL, 'LensShareSummary$ShareId' => NULL, 'ProfileShareSummary$ShareId' => NULL, 'TemplateShareSummary$ShareId' => NULL, 'UpdateWorkloadShareInput$ShareId' => NULL, 'WorkloadShare$ShareId' => NULL, 'WorkloadShareSummary$ShareId' => NULL, ], ], 'ShareInvitation' => [ 'base' => '<p>The share invitation.</p>', 'refs' => [ 'UpdateShareInvitationOutput$ShareInvitation' => '<p>The updated workload or custom lens share invitation.</p>', ], ], 'ShareInvitationAction' => [ 'base' => '<p>Share invitation action taken by contributor.</p>', 'refs' => [ 'UpdateShareInvitationInput$ShareInvitationAction' => NULL, ], ], 'ShareInvitationId' => [ 'base' => NULL, 'refs' => [ 'Lens$ShareInvitationId' => '<p>The ID assigned to the share invitation.</p>', 'Profile$ShareInvitationId' => '<p>The ID assigned to the share invitation.</p>', 'ReviewTemplate$ShareInvitationId' => '<p>The ID assigned to the template share invitation.</p>', 'ShareInvitation$ShareInvitationId' => '<p>The ID assigned to the share invitation.</p>', 'ShareInvitationSummary$ShareInvitationId' => '<p>The ID assigned to the share invitation.</p>', 'UpdateShareInvitationInput$ShareInvitationId' => '<p>The ID assigned to the share invitation.</p>', 'Workload$ShareInvitationId' => '<p>The ID assigned to the share invitation.</p>', ], ], 'ShareInvitationSummaries' => [ 'base' => NULL, 'refs' => [ 'ListShareInvitationsOutput$ShareInvitationSummaries' => '<p>List of share invitation summaries in a workload.</p>', ], ], 'ShareInvitationSummary' => [ 'base' => '<p>A share invitation summary return object.</p>', 'refs' => [ 'ShareInvitationSummaries$member' => NULL, ], ], 'ShareResourceType' => [ 'base' => NULL, 'refs' => [ 'ListShareInvitationsInput$ShareResourceType' => '<p>The type of share invitations to be returned.</p>', 'ShareInvitation$ShareResourceType' => '<p>The resource type of the share invitation.</p>', 'ShareInvitationSummary$ShareResourceType' => '<p>The resource type of the share invitation.</p>', ], ], 'ShareStatus' => [ 'base' => '<p>The status of the share request.</p>', 'refs' => [ 'LensShareSummary$Status' => NULL, 'ListLensSharesInput$Status' => NULL, 'ListProfileSharesInput$Status' => NULL, 'ListTemplateSharesInput$Status' => NULL, 'ListWorkloadSharesInput$Status' => NULL, 'ProfileShareSummary$Status' => NULL, 'TemplateShareSummary$Status' => NULL, 'WorkloadShare$Status' => NULL, 'WorkloadShareSummary$Status' => NULL, ], ], 'SharedWith' => [ 'base' => '<p>The Amazon Web Services account ID, organization ID, or organizational unit (OU) ID with which the workload, lens, profile, or review template is shared.</p>', 'refs' => [ 'CreateLensShareInput$SharedWith' => NULL, 'CreateProfileShareInput$SharedWith' => NULL, 'CreateTemplateShareInput$SharedWith' => NULL, 'CreateWorkloadShareInput$SharedWith' => NULL, 'LensShareSummary$SharedWith' => NULL, 'ProfileShareSummary$SharedWith' => NULL, 'ShareInvitationSummary$SharedWith' => NULL, 'TemplateShareSummary$SharedWith' => NULL, 'WorkloadShare$SharedWith' => NULL, 'WorkloadShareSummary$SharedWith' => NULL, ], ], 'SharedWithPrefix' => [ 'base' => NULL, 'refs' => [ 'ListLensSharesInput$SharedWithPrefix' => '<p>The Amazon Web Services account ID, organization ID, or organizational unit (OU) ID with which the lens is shared.</p>', 'ListProfileSharesInput$SharedWithPrefix' => '<p>The Amazon Web Services account ID, organization ID, or organizational unit (OU) ID with which the profile is shared.</p>', 'ListTemplateSharesInput$SharedWithPrefix' => '<p>The Amazon Web Services account ID, organization ID, or organizational unit (OU) ID with which the profile is shared.</p>', 'ListWorkloadSharesInput$SharedWithPrefix' => '<p>The Amazon Web Services account ID, organization ID, or organizational unit (OU) ID with which the workload is shared.</p>', ], ], 'StatusMessage' => [ 'base' => NULL, 'refs' => [ 'AccountJiraConfigurationOutput$StatusMessage' => '<p>Account-level: Status message on configuration of the Jira integration.</p>', 'LensShareSummary$StatusMessage' => '<p>Optional message to compliment the Status field.</p>', 'ProfileShareSummary$StatusMessage' => '<p>Profile share invitation status message.</p>', 'TemplateShareSummary$StatusMessage' => '<p>Review template share invitation status message. </p>', 'WorkloadJiraConfigurationOutput$StatusMessage' => '<p>Workload-level: Status message on configuration of the Jira integration.</p>', 'WorkloadShareSummary$StatusMessage' => '<p>Optional message to compliment the Status field.</p>', ], ], 'Subdomain' => [ 'base' => NULL, 'refs' => [ 'AccountJiraConfigurationOutput$Subdomain' => '<p>Account-level: Jira subdomain URL.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'TagMap$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceInput$TagKeys' => '<p>A list of tag keys. Existing tags of the resource whose keys are members of this list are removed from the resource.</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'CreateProfileInput$Tags' => '<p>The tags assigned to the profile.</p>', 'CreateReviewTemplateInput$Tags' => '<p>The tags assigned to the review template.</p>', 'CreateWorkloadInput$Tags' => '<p>The tags to be associated with the workload.</p>', 'ImportLensInput$Tags' => '<p>Tags to associate to a lens.</p>', 'Lens$Tags' => '<p>The tags assigned to the lens.</p>', 'ListTagsForResourceOutput$Tags' => '<p>The tags for the resource.</p>', 'Profile$Tags' => '<p>The tags assigned to the profile.</p>', 'ReviewTemplate$Tags' => '<p>The tags assigned to the review template.</p>', 'TagResourceInput$Tags' => '<p>The tags for the resource.</p>', 'Workload$Tags' => '<p>The tags associated with the workload.</p>', ], ], 'TagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagMap$value' => NULL, ], ], 'TemplateArn' => [ 'base' => NULL, 'refs' => [ 'CreateReviewTemplateOutput$TemplateArn' => '<p>The review template ARN.</p>', 'CreateTemplateShareInput$TemplateArn' => '<p>The review template ARN.</p>', 'CreateTemplateShareOutput$TemplateArn' => '<p>The review template ARN.</p>', 'DeleteReviewTemplateInput$TemplateArn' => '<p>The review template ARN.</p>', 'DeleteTemplateShareInput$TemplateArn' => '<p>The review template ARN.</p>', 'GetReviewTemplateAnswerInput$TemplateArn' => '<p>The review template ARN.</p>', 'GetReviewTemplateAnswerOutput$TemplateArn' => '<p>The review template ARN.</p>', 'GetReviewTemplateInput$TemplateArn' => '<p>The review template ARN.</p>', 'GetReviewTemplateLensReviewInput$TemplateArn' => '<p>The review template ARN.</p>', 'GetReviewTemplateLensReviewOutput$TemplateArn' => '<p>The review template ARN.</p>', 'ListReviewTemplateAnswersInput$TemplateArn' => '<p>The ARN of the review template.</p>', 'ListReviewTemplateAnswersOutput$TemplateArn' => '<p>The ARN of the review template.</p>', 'ListTemplateSharesInput$TemplateArn' => '<p>The review template ARN.</p>', 'ListTemplateSharesOutput$TemplateArn' => '<p>The review template ARN.</p>', 'ReviewTemplate$TemplateArn' => '<p>The review template ARN.</p>', 'ReviewTemplateArns$member' => NULL, 'ReviewTemplateSummary$TemplateArn' => '<p>The review template ARN.</p>', 'ShareInvitation$TemplateArn' => '<p>The review template ARN.</p>', 'ShareInvitationSummary$TemplateArn' => '<p>The review template ARN.</p>', 'UpdateReviewTemplateAnswerInput$TemplateArn' => '<p>The review template ARN.</p>', 'UpdateReviewTemplateAnswerOutput$TemplateArn' => '<p>The review template ARN.</p>', 'UpdateReviewTemplateInput$TemplateArn' => '<p>The review template ARN.</p>', 'UpdateReviewTemplateLensReviewInput$TemplateArn' => '<p>The review template ARN.</p>', 'UpdateReviewTemplateLensReviewOutput$TemplateArn' => '<p>The review template ARN.</p>', 'UpgradeReviewTemplateLensReviewInput$TemplateArn' => '<p>The ARN of the review template.</p>', ], ], 'TemplateDescription' => [ 'base' => NULL, 'refs' => [ 'CreateReviewTemplateInput$Description' => '<p>The review template description.</p>', 'ReviewTemplate$Description' => '<p>The review template description.</p>', 'ReviewTemplateSummary$Description' => '<p>Description of the review template.</p>', 'UpdateReviewTemplateInput$Description' => '<p>The review template description.</p>', ], ], 'TemplateName' => [ 'base' => NULL, 'refs' => [ 'CreateReviewTemplateInput$TemplateName' => '<p>Name of the review template.</p>', 'ReviewTemplate$TemplateName' => '<p>The name of the review template.</p>', 'ReviewTemplateSummary$TemplateName' => '<p>The name of the review template.</p>', 'ShareInvitationSummary$TemplateName' => '<p>The name of the review template.</p>', 'UpdateReviewTemplateInput$TemplateName' => '<p>The review template name.</p>', ], ], 'TemplateNamePrefix' => [ 'base' => NULL, 'refs' => [ 'ListShareInvitationsInput$TemplateNamePrefix' => '<p>An optional string added to the beginning of each review template name returned in the results.</p>', ], ], 'TemplateQuestions' => [ 'base' => NULL, 'refs' => [ 'ProfileTemplate$TemplateQuestions' => '<p>Profile template questions.</p>', ], ], 'TemplateShareSummaries' => [ 'base' => NULL, 'refs' => [ 'ListTemplateSharesOutput$TemplateShareSummaries' => '<p>A review template share summary return object.</p>', ], ], 'TemplateShareSummary' => [ 'base' => '<p>Summary of a review template share.</p>', 'refs' => [ 'TemplateShareSummaries$member' => NULL, ], ], 'ThrottlingException' => [ 'base' => '<p>Request was denied due to request throttling.</p>', 'refs' => [], ], 'Timestamp' => [ 'base' => '<p>The date and time recorded.</p>', 'refs' => [ 'CheckDetail$UpdatedAt' => NULL, 'CheckSummary$UpdatedAt' => NULL, 'ConsolidatedReportMetric$UpdatedAt' => NULL, 'JiraConfiguration$LastSyncedTime' => NULL, 'LensReview$UpdatedAt' => NULL, 'LensReviewSummary$UpdatedAt' => NULL, 'LensSummary$CreatedAt' => NULL, 'LensSummary$UpdatedAt' => NULL, 'Milestone$RecordedAt' => NULL, 'MilestoneSummary$RecordedAt' => NULL, 'Profile$CreatedAt' => NULL, 'Profile$UpdatedAt' => NULL, 'ProfileSummary$CreatedAt' => NULL, 'ProfileSummary$UpdatedAt' => NULL, 'ProfileTemplate$CreatedAt' => NULL, 'ProfileTemplate$UpdatedAt' => NULL, 'ReviewTemplate$UpdatedAt' => NULL, 'ReviewTemplateLensReview$UpdatedAt' => NULL, 'ReviewTemplateSummary$UpdatedAt' => NULL, 'Workload$UpdatedAt' => NULL, 'Workload$ReviewRestrictionDate' => NULL, 'WorkloadSummary$UpdatedAt' => NULL, ], ], 'TrustedAdvisorIntegrationStatus' => [ 'base' => NULL, 'refs' => [ 'WorkloadDiscoveryConfig$TrustedAdvisorIntegrationStatus' => '<p>Discovery integration status in respect to Trusted Advisor for the workload.</p>', ], ], 'UntagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAnswerInput' => [ 'base' => '<p>Input to update answer.</p>', 'refs' => [], ], 'UpdateAnswerOutput' => [ 'base' => '<p>Output of a update answer call.</p>', 'refs' => [], ], 'UpdateGlobalSettingsInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateIntegrationInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLensReviewInput' => [ 'base' => '<p>Input for update lens review.</p>', 'refs' => [], ], 'UpdateLensReviewOutput' => [ 'base' => '<p>Output of a update lens review call.</p>', 'refs' => [], ], 'UpdateProfileInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateProfileOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateReviewTemplateAnswerInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateReviewTemplateAnswerOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateReviewTemplateInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateReviewTemplateLensReviewInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateReviewTemplateLensReviewOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateReviewTemplateOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateShareInvitationInput' => [ 'base' => '<p>Input for Update Share Invitation</p>', 'refs' => [], ], 'UpdateShareInvitationOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWorkloadInput' => [ 'base' => '<p>Input to update a workload.</p>', 'refs' => [], ], 'UpdateWorkloadOutput' => [ 'base' => '<p>Output of an update workload call.</p>', 'refs' => [], ], 'UpdateWorkloadShareInput' => [ 'base' => '<p>Input for Update Workload Share</p>', 'refs' => [], ], 'UpdateWorkloadShareOutput' => [ 'base' => '<p>Input for Update Workload Share</p>', 'refs' => [], ], 'UpgradeLensReviewInput' => [ 'base' => NULL, 'refs' => [], ], 'UpgradeProfileVersionInput' => [ 'base' => NULL, 'refs' => [], ], 'UpgradeReviewTemplateLensReviewInput' => [ 'base' => NULL, 'refs' => [], ], 'Urls' => [ 'base' => NULL, 'refs' => [ 'AdditionalResources$Content' => '<p>The URLs for additional resources, either helpful resources or improvement plans, for a custom lens. Up to five additional URLs can be specified.</p>', ], ], 'ValidationException' => [ 'base' => '<p>The user input is not valid.</p>', 'refs' => [], ], 'ValidationExceptionField' => [ 'base' => '<p>Stores information about a field passed inside a request that resulted in an exception.</p>', 'refs' => [ 'ValidationExceptionFieldList$member' => NULL, ], ], 'ValidationExceptionFieldList' => [ 'base' => '<p>The fields that caused the error, if applicable.</p>', 'refs' => [ 'ValidationException$Fields' => NULL, ], ], 'ValidationExceptionFieldName' => [ 'base' => '<p>The field name for which validation failed.</p>', 'refs' => [ 'ValidationExceptionField$Name' => NULL, ], ], 'ValidationExceptionReason' => [ 'base' => '<p>The reason why the request failed validation.</p>', 'refs' => [ 'ValidationException$Reason' => NULL, ], ], 'VersionDifferences' => [ 'base' => '<p>The differences between the base and latest versions of the lens.</p>', 'refs' => [ 'GetLensVersionDifferenceOutput$VersionDifferences' => NULL, ], ], 'Workload' => [ 'base' => '<p>A workload return object.</p>', 'refs' => [ 'GetWorkloadOutput$Workload' => NULL, 'Milestone$Workload' => NULL, 'UpdateWorkloadOutput$Workload' => NULL, ], ], 'WorkloadAccountIds' => [ 'base' => '<p>The list of Amazon Web Services account IDs associated with the workload.</p>', 'refs' => [ 'CreateWorkloadInput$AccountIds' => NULL, 'UpdateWorkloadInput$AccountIds' => NULL, 'Workload$AccountIds' => NULL, ], ], 'WorkloadApplications' => [ 'base' => NULL, 'refs' => [ 'CreateWorkloadInput$Applications' => '<p>List of AppRegistry application ARNs associated to the workload.</p>', 'UpdateWorkloadInput$Applications' => '<p>List of AppRegistry application ARNs to associate to the workload.</p>', 'Workload$Applications' => '<p>List of AppRegistry application ARNs associated to the workload.</p>', ], ], 'WorkloadArchitecturalDesign' => [ 'base' => '<p>The URL of the architectural design for the workload.</p>', 'refs' => [ 'CreateWorkloadInput$ArchitecturalDesign' => NULL, 'UpdateWorkloadInput$ArchitecturalDesign' => NULL, 'Workload$ArchitecturalDesign' => NULL, ], ], 'WorkloadArn' => [ 'base' => '<p>The ARN for the workload.</p>', 'refs' => [ 'ConsolidatedReportMetric$WorkloadArn' => NULL, 'CreateWorkloadOutput$WorkloadArn' => NULL, 'ListTagsForResourceInput$WorkloadArn' => NULL, 'TagResourceInput$WorkloadArn' => NULL, 'UntagResourceInput$WorkloadArn' => NULL, 'Workload$WorkloadArn' => NULL, 'WorkloadSummary$WorkloadArn' => NULL, ], ], 'WorkloadAwsRegions' => [ 'base' => '<p>The list of Amazon Web Services Regions associated with the workload, for example, <code>us-east-2</code>, or <code>ca-central-1</code>.</p>', 'refs' => [ 'CreateWorkloadInput$AwsRegions' => NULL, 'UpdateWorkloadInput$AwsRegions' => NULL, 'Workload$AwsRegions' => NULL, ], ], 'WorkloadDescription' => [ 'base' => '<p>The description for the workload.</p>', 'refs' => [ 'CreateWorkloadInput$Description' => NULL, 'UpdateWorkloadInput$Description' => NULL, 'Workload$Description' => NULL, ], ], 'WorkloadDiscoveryConfig' => [ 'base' => '<p>Discovery configuration associated to the workload.</p>', 'refs' => [ 'CreateWorkloadInput$DiscoveryConfig' => '<p>Well-Architected discovery configuration settings associated to the workload.</p>', 'UpdateWorkloadInput$DiscoveryConfig' => '<p>Well-Architected discovery configuration settings to associate to the workload.</p>', 'Workload$DiscoveryConfig' => '<p>Discovery configuration associated to the workload.</p>', ], ], 'WorkloadEnvironment' => [ 'base' => '<p>The environment for the workload.</p>', 'refs' => [ 'CreateWorkloadInput$Environment' => NULL, 'UpdateWorkloadInput$Environment' => NULL, 'Workload$Environment' => NULL, ], ], 'WorkloadId' => [ 'base' => '<p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>', 'refs' => [ 'AssociateLensesInput$WorkloadId' => NULL, 'AssociateProfilesInput$WorkloadId' => NULL, 'ConsolidatedReportMetric$WorkloadId' => NULL, 'CreateMilestoneInput$WorkloadId' => NULL, 'CreateMilestoneOutput$WorkloadId' => NULL, 'CreateWorkloadOutput$WorkloadId' => NULL, 'CreateWorkloadShareInput$WorkloadId' => NULL, 'CreateWorkloadShareOutput$WorkloadId' => NULL, 'DeleteWorkloadInput$WorkloadId' => NULL, 'DeleteWorkloadShareInput$WorkloadId' => NULL, 'DisassociateLensesInput$WorkloadId' => NULL, 'DisassociateProfilesInput$WorkloadId' => NULL, 'GetAnswerInput$WorkloadId' => NULL, 'GetAnswerOutput$WorkloadId' => NULL, 'GetLensReviewInput$WorkloadId' => NULL, 'GetLensReviewOutput$WorkloadId' => NULL, 'GetLensReviewReportInput$WorkloadId' => NULL, 'GetLensReviewReportOutput$WorkloadId' => NULL, 'GetMilestoneInput$WorkloadId' => NULL, 'GetMilestoneOutput$WorkloadId' => NULL, 'GetWorkloadInput$WorkloadId' => NULL, 'LensUpgradeSummary$WorkloadId' => NULL, 'ListAnswersInput$WorkloadId' => NULL, 'ListAnswersOutput$WorkloadId' => NULL, 'ListCheckDetailsInput$WorkloadId' => NULL, 'ListCheckSummariesInput$WorkloadId' => NULL, 'ListLensReviewImprovementsInput$WorkloadId' => NULL, 'ListLensReviewImprovementsOutput$WorkloadId' => NULL, 'ListLensReviewsInput$WorkloadId' => NULL, 'ListLensReviewsOutput$WorkloadId' => NULL, 'ListMilestonesInput$WorkloadId' => NULL, 'ListMilestonesOutput$WorkloadId' => NULL, 'ListNotificationsInput$WorkloadId' => NULL, 'ListProfileNotificationsInput$WorkloadId' => NULL, 'ListWorkloadSharesInput$WorkloadId' => NULL, 'ListWorkloadSharesOutput$WorkloadId' => NULL, 'ProfileNotificationSummary$WorkloadId' => NULL, 'ShareInvitation$WorkloadId' => NULL, 'ShareInvitationSummary$WorkloadId' => NULL, 'UpdateAnswerInput$WorkloadId' => NULL, 'UpdateAnswerOutput$WorkloadId' => NULL, 'UpdateIntegrationInput$WorkloadId' => NULL, 'UpdateLensReviewInput$WorkloadId' => NULL, 'UpdateLensReviewOutput$WorkloadId' => NULL, 'UpdateWorkloadInput$WorkloadId' => NULL, 'UpdateWorkloadShareInput$WorkloadId' => NULL, 'UpdateWorkloadShareOutput$WorkloadId' => NULL, 'UpgradeLensReviewInput$WorkloadId' => NULL, 'UpgradeProfileVersionInput$WorkloadId' => NULL, 'Workload$WorkloadId' => NULL, 'WorkloadShare$WorkloadId' => NULL, 'WorkloadSummary$WorkloadId' => NULL, ], ], 'WorkloadImprovementStatus' => [ 'base' => '<p>The improvement status for a workload.</p>', 'refs' => [ 'UpdateWorkloadInput$ImprovementStatus' => NULL, 'Workload$ImprovementStatus' => NULL, 'WorkloadSummary$ImprovementStatus' => NULL, ], ], 'WorkloadIndustry' => [ 'base' => '<p>The industry for the workload.</p>', 'refs' => [ 'CreateWorkloadInput$Industry' => NULL, 'UpdateWorkloadInput$Industry' => NULL, 'Workload$Industry' => NULL, ], ], 'WorkloadIndustryType' => [ 'base' => '<p>The industry type for the workload.</p> <p>If specified, must be one of the following:</p> <ul> <li> <p> <code>Agriculture</code> </p> </li> <li> <p> <code>Automobile</code> </p> </li> <li> <p> <code>Defense</code> </p> </li> <li> <p> <code>Design and Engineering</code> </p> </li> <li> <p> <code>Digital Advertising</code> </p> </li> <li> <p> <code>Education</code> </p> </li> <li> <p> <code>Environmental Protection</code> </p> </li> <li> <p> <code>Financial Services</code> </p> </li> <li> <p> <code>Gaming</code> </p> </li> <li> <p> <code>General Public Services</code> </p> </li> <li> <p> <code>Healthcare</code> </p> </li> <li> <p> <code>Hospitality</code> </p> </li> <li> <p> <code>InfoTech</code> </p> </li> <li> <p> <code>Justice and Public Safety</code> </p> </li> <li> <p> <code>Life Sciences</code> </p> </li> <li> <p> <code>Manufacturing</code> </p> </li> <li> <p> <code>Media &amp; Entertainment</code> </p> </li> <li> <p> <code>Mining &amp; Resources</code> </p> </li> <li> <p> <code>Oil &amp; Gas</code> </p> </li> <li> <p> <code>Power &amp; Utilities</code> </p> </li> <li> <p> <code>Professional Services</code> </p> </li> <li> <p> <code>Real Estate &amp; Construction</code> </p> </li> <li> <p> <code>Retail &amp; Wholesale</code> </p> </li> <li> <p> <code>Social Protection</code> </p> </li> <li> <p> <code>Telecommunications</code> </p> </li> <li> <p> <code>Travel, Transportation &amp; Logistics</code> </p> </li> <li> <p> <code>Other</code> </p> </li> </ul>', 'refs' => [ 'CreateWorkloadInput$IndustryType' => NULL, 'UpdateWorkloadInput$IndustryType' => NULL, 'Workload$IndustryType' => NULL, ], ], 'WorkloadIssueManagementStatus' => [ 'base' => NULL, 'refs' => [ 'WorkloadJiraConfigurationInput$IssueManagementStatus' => '<p>Workload-level: Jira issue management status.</p>', 'WorkloadJiraConfigurationOutput$IssueManagementStatus' => '<p>Workload-level: Jira issue management status.</p>', ], ], 'WorkloadJiraConfigurationInput' => [ 'base' => '<p>Workload-level: Input for the Jira configuration.</p>', 'refs' => [ 'CreateWorkloadInput$JiraConfiguration' => '<p>Jira configuration settings when creating a workload.</p>', 'UpdateWorkloadInput$JiraConfiguration' => '<p>Configuration of the Jira integration.</p>', ], ], 'WorkloadJiraConfigurationOutput' => [ 'base' => '<p>Workload-level: Output configuration of the Jira integration.</p>', 'refs' => [ 'Workload$JiraConfiguration' => '<p>Jira configuration for a specific workload.</p>', ], ], 'WorkloadLenses' => [ 'base' => '<p>The list of lenses associated with the workload. Each lens is identified by its <a>LensSummary$LensAlias</a>.</p> <p>If a review template that specifies lenses is applied to the workload, those lenses are applied to the workload in addition to these lenses.</p>', 'refs' => [ 'CreateWorkloadInput$Lenses' => NULL, 'Workload$Lenses' => NULL, 'WorkloadSummary$Lenses' => NULL, ], ], 'WorkloadName' => [ 'base' => '<p>The name of the workload.</p> <p>The name must be unique within an account within an Amazon Web Services Region. Spaces and capitalization are ignored when checking for uniqueness.</p>', 'refs' => [ 'ConsolidatedReportMetric$WorkloadName' => NULL, 'CreateWorkloadInput$WorkloadName' => NULL, 'LensUpgradeSummary$WorkloadName' => NULL, 'LensUpgradeSummary$ResourceName' => NULL, 'ProfileNotificationSummary$WorkloadName' => NULL, 'ShareInvitationSummary$WorkloadName' => NULL, 'UpdateWorkloadInput$WorkloadName' => NULL, 'Workload$WorkloadName' => NULL, 'WorkloadShare$WorkloadName' => NULL, 'WorkloadSummary$WorkloadName' => NULL, ], ], 'WorkloadNamePrefix' => [ 'base' => '<p>An optional string added to the beginning of each workload name returned in the results.</p>', 'refs' => [ 'ListShareInvitationsInput$WorkloadNamePrefix' => NULL, 'ListWorkloadsInput$WorkloadNamePrefix' => NULL, ], ], 'WorkloadNonAwsRegion' => [ 'base' => NULL, 'refs' => [ 'WorkloadNonAwsRegions$member' => NULL, ], ], 'WorkloadNonAwsRegions' => [ 'base' => '<p> The list of non-Amazon Web Services Regions associated with the workload.</p>', 'refs' => [ 'CreateWorkloadInput$NonAwsRegions' => NULL, 'UpdateWorkloadInput$NonAwsRegions' => NULL, 'Workload$NonAwsRegions' => NULL, ], ], 'WorkloadPillarPriorities' => [ 'base' => '<p>The priorities of the pillars, which are used to order items in the improvement plan. Each pillar is represented by its <a>PillarReviewSummary$PillarId</a>.</p>', 'refs' => [ 'CreateWorkloadInput$PillarPriorities' => NULL, 'UpdateWorkloadInput$PillarPriorities' => NULL, 'Workload$PillarPriorities' => NULL, ], ], 'WorkloadProfile' => [ 'base' => '<p>The profile associated with a workload.</p>', 'refs' => [ 'WorkloadProfiles$member' => NULL, ], ], 'WorkloadProfileArns' => [ 'base' => NULL, 'refs' => [ 'CreateWorkloadInput$ProfileArns' => '<p>The list of profile ARNs associated with the workload.</p>', ], ], 'WorkloadProfiles' => [ 'base' => NULL, 'refs' => [ 'LensReview$Profiles' => '<p>The profiles associated with the workload.</p>', 'LensReviewSummary$Profiles' => '<p>The profiles associated with the workload.</p>', 'Workload$Profiles' => '<p>Profile associated with a workload.</p>', 'WorkloadSummary$Profiles' => '<p>Profile associated with a workload.</p>', ], ], 'WorkloadResourceDefinition' => [ 'base' => NULL, 'refs' => [ 'WorkloadDiscoveryConfig$WorkloadResourceDefinition' => '<p>The mode to use for identifying resources associated with the workload.</p> <p>You can specify <code>WORKLOAD_METADATA</code>, <code>APP_REGISTRY</code>, or both.</p>', ], ], 'WorkloadReviewOwner' => [ 'base' => '<p>The review owner of the workload. The name, email address, or identifier for the primary group or individual that owns the workload review process.</p>', 'refs' => [ 'CreateWorkloadInput$ReviewOwner' => NULL, 'UpdateWorkloadInput$ReviewOwner' => NULL, 'Workload$ReviewOwner' => NULL, ], ], 'WorkloadShare' => [ 'base' => '<p>A workload share return object.</p>', 'refs' => [ 'UpdateWorkloadShareOutput$WorkloadShare' => NULL, ], ], 'WorkloadShareSummaries' => [ 'base' => '<p>A list of workload share summaries.</p>', 'refs' => [ 'ListWorkloadSharesOutput$WorkloadShareSummaries' => NULL, ], ], 'WorkloadShareSummary' => [ 'base' => '<p>A workload share summary return object.</p>', 'refs' => [ 'WorkloadShareSummaries$member' => NULL, ], ], 'WorkloadSummaries' => [ 'base' => '<p>A list of workload summaries.</p>', 'refs' => [ 'ListWorkloadsOutput$WorkloadSummaries' => NULL, ], ], 'WorkloadSummary' => [ 'base' => '<p>A workload summary return object.</p>', 'refs' => [ 'MilestoneSummary$WorkloadSummary' => NULL, 'WorkloadSummaries$member' => NULL, ], ], ],];
