<?php
// This file was auto-generated from sdk-root/src/data/workspaces-web/2020-07-08/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon WorkSpaces Secure Browser is a low cost, fully managed WorkSpace built specifically to facilitate secure, web-based workloads. WorkSpaces Secure Browser makes it easy for customers to safely provide their employees with access to internal websites and SaaS web applications without the administrative burden of appliances or specialized client software. WorkSpaces Secure Browser provides simple policy tools tailored for user interactions, while offloading common tasks like capacity management, scaling, and maintaining browser images.</p>', 'operations' => [ 'AssociateBrowserSettings' => '<p>Associates a browser settings resource with a web portal.</p>', 'AssociateIpAccessSettings' => '<p>Associates an IP access settings resource with a web portal.</p>', 'AssociateNetworkSettings' => '<p>Associates a network settings resource with a web portal.</p>', 'AssociateTrustStore' => '<p>Associates a trust store with a web portal.</p>', 'AssociateUserAccessLoggingSettings' => '<p>Associates a user access logging settings resource with a web portal.</p>', 'AssociateUserSettings' => '<p>Associates a user settings resource with a web portal.</p>', 'CreateBrowserSettings' => '<p>Creates a browser settings resource that can be associated with a web portal. Once associated with a web portal, browser settings control how the browser will behave once a user starts a streaming session for the web portal. </p>', 'CreateIdentityProvider' => '<p>Creates an identity provider resource that is then associated with a web portal.</p>', 'CreateIpAccessSettings' => '<p>Creates an IP access settings resource that can be associated with a web portal.</p>', 'CreateNetworkSettings' => '<p>Creates a network settings resource that can be associated with a web portal. Once associated with a web portal, network settings define how streaming instances will connect with your specified VPC. </p>', 'CreatePortal' => '<p>Creates a web portal.</p>', 'CreateTrustStore' => '<p>Creates a trust store that can be associated with a web portal. A trust store contains certificate authority (CA) certificates. Once associated with a web portal, the browser in a streaming session will recognize certificates that have been issued using any of the CAs in the trust store. If your organization has internal websites that use certificates issued by private CAs, you should add the private CA certificate to the trust store. </p>', 'CreateUserAccessLoggingSettings' => '<p>Creates a user access logging settings resource that can be associated with a web portal.</p>', 'CreateUserSettings' => '<p>Creates a user settings resource that can be associated with a web portal. Once associated with a web portal, user settings control how users can transfer data between a streaming session and the their local devices. </p>', 'DeleteBrowserSettings' => '<p>Deletes browser settings.</p>', 'DeleteIdentityProvider' => '<p>Deletes the identity provider.</p>', 'DeleteIpAccessSettings' => '<p>Deletes IP access settings.</p>', 'DeleteNetworkSettings' => '<p>Deletes network settings.</p>', 'DeletePortal' => '<p>Deletes a web portal.</p>', 'DeleteTrustStore' => '<p>Deletes the trust store.</p>', 'DeleteUserAccessLoggingSettings' => '<p>Deletes user access logging settings.</p>', 'DeleteUserSettings' => '<p>Deletes user settings.</p>', 'DisassociateBrowserSettings' => '<p>Disassociates browser settings from a web portal.</p>', 'DisassociateIpAccessSettings' => '<p>Disassociates IP access settings from a web portal.</p>', 'DisassociateNetworkSettings' => '<p>Disassociates network settings from a web portal.</p>', 'DisassociateTrustStore' => '<p>Disassociates a trust store from a web portal.</p>', 'DisassociateUserAccessLoggingSettings' => '<p>Disassociates user access logging settings from a web portal.</p>', 'DisassociateUserSettings' => '<p>Disassociates user settings from a web portal.</p>', 'GetBrowserSettings' => '<p>Gets browser settings.</p>', 'GetIdentityProvider' => '<p>Gets the identity provider.</p>', 'GetIpAccessSettings' => '<p>Gets the IP access settings.</p>', 'GetNetworkSettings' => '<p>Gets the network settings.</p>', 'GetPortal' => '<p>Gets the web portal.</p>', 'GetPortalServiceProviderMetadata' => '<p>Gets the service provider metadata.</p>', 'GetTrustStore' => '<p>Gets the trust store.</p>', 'GetTrustStoreCertificate' => '<p>Gets the trust store certificate.</p>', 'GetUserAccessLoggingSettings' => '<p>Gets user access logging settings.</p>', 'GetUserSettings' => '<p>Gets user settings.</p>', 'ListBrowserSettings' => '<p>Retrieves a list of browser settings.</p>', 'ListIdentityProviders' => '<p>Retrieves a list of identity providers for a specific web portal.</p>', 'ListIpAccessSettings' => '<p>Retrieves a list of IP access settings.</p>', 'ListNetworkSettings' => '<p>Retrieves a list of network settings.</p>', 'ListPortals' => '<p>Retrieves a list or web portals.</p>', 'ListTagsForResource' => '<p>Retrieves a list of tags for a resource.</p>', 'ListTrustStoreCertificates' => '<p>Retrieves a list of trust store certificates.</p>', 'ListTrustStores' => '<p>Retrieves a list of trust stores.</p>', 'ListUserAccessLoggingSettings' => '<p>Retrieves a list of user access logging settings.</p>', 'ListUserSettings' => '<p>Retrieves a list of user settings.</p>', 'TagResource' => '<p>Adds or overwrites one or more tags for the specified resource.</p>', 'UntagResource' => '<p>Removes one or more tags from the specified resource.</p>', 'UpdateBrowserSettings' => '<p>Updates browser settings.</p>', 'UpdateIdentityProvider' => '<p>Updates the identity provider. </p>', 'UpdateIpAccessSettings' => '<p>Updates IP access settings.</p>', 'UpdateNetworkSettings' => '<p>Updates network settings.</p>', 'UpdatePortal' => '<p>Updates a web portal.</p>', 'UpdateTrustStore' => '<p>Updates the trust store.</p>', 'UpdateUserAccessLoggingSettings' => '<p>Updates the user access logging settings.</p>', 'UpdateUserSettings' => '<p>Updates the user settings.</p>', ], 'shapes' => [ 'ARN' => [ 'base' => NULL, 'refs' => [ 'ArnList$member' => NULL, 'AssociateBrowserSettingsRequest$browserSettingsArn' => '<p>The ARN of the browser settings.</p>', 'AssociateBrowserSettingsRequest$portalArn' => '<p>The ARN of the web portal.</p>', 'AssociateBrowserSettingsResponse$browserSettingsArn' => '<p>The ARN of the browser settings.</p>', 'AssociateBrowserSettingsResponse$portalArn' => '<p>The ARN of the web portal.</p>', 'AssociateIpAccessSettingsRequest$ipAccessSettingsArn' => '<p>The ARN of the IP access settings.</p>', 'AssociateIpAccessSettingsRequest$portalArn' => '<p>The ARN of the web portal.</p>', 'AssociateIpAccessSettingsResponse$ipAccessSettingsArn' => '<p>The ARN of the IP access settings resource.</p>', 'AssociateIpAccessSettingsResponse$portalArn' => '<p>The ARN of the web portal.</p>', 'AssociateNetworkSettingsRequest$networkSettingsArn' => '<p>The ARN of the network settings.</p>', 'AssociateNetworkSettingsRequest$portalArn' => '<p>The ARN of the web portal.</p>', 'AssociateNetworkSettingsResponse$networkSettingsArn' => '<p>The ARN of the network settings.</p>', 'AssociateNetworkSettingsResponse$portalArn' => '<p>The ARN of the web portal.</p>', 'AssociateTrustStoreRequest$portalArn' => '<p>The ARN of the web portal.</p>', 'AssociateTrustStoreRequest$trustStoreArn' => '<p>The ARN of the trust store.</p>', 'AssociateTrustStoreResponse$portalArn' => '<p>The ARN of the web portal.</p>', 'AssociateTrustStoreResponse$trustStoreArn' => '<p>The ARN of the trust store.</p>', 'AssociateUserAccessLoggingSettingsRequest$portalArn' => '<p>The ARN of the web portal.</p>', 'AssociateUserAccessLoggingSettingsRequest$userAccessLoggingSettingsArn' => '<p>The ARN of the user access logging settings.</p>', 'AssociateUserAccessLoggingSettingsResponse$portalArn' => '<p>The ARN of the web portal.</p>', 'AssociateUserAccessLoggingSettingsResponse$userAccessLoggingSettingsArn' => '<p>The ARN of the user access logging settings.</p>', 'AssociateUserSettingsRequest$portalArn' => '<p>The ARN of the web portal.</p>', 'AssociateUserSettingsRequest$userSettingsArn' => '<p>The ARN of the user settings.</p>', 'AssociateUserSettingsResponse$portalArn' => '<p>The ARN of the web portal.</p>', 'AssociateUserSettingsResponse$userSettingsArn' => '<p>The ARN of the user settings.</p>', 'BrowserSettings$browserSettingsArn' => '<p>The ARN of the browser settings.</p>', 'BrowserSettingsSummary$browserSettingsArn' => '<p>The ARN of the browser settings.</p>', 'CreateBrowserSettingsResponse$browserSettingsArn' => '<p>The ARN of the browser settings.</p>', 'CreateIdentityProviderRequest$portalArn' => '<p>The ARN of the web portal.</p>', 'CreateIpAccessSettingsResponse$ipAccessSettingsArn' => '<p>The ARN of the IP access settings resource.</p>', 'CreateNetworkSettingsResponse$networkSettingsArn' => '<p>The ARN of the network settings.</p>', 'CreatePortalResponse$portalArn' => '<p>The ARN of the web portal.</p>', 'CreateTrustStoreResponse$trustStoreArn' => '<p>The ARN of the trust store.</p>', 'CreateUserAccessLoggingSettingsResponse$userAccessLoggingSettingsArn' => '<p>The ARN of the user access logging settings.</p>', 'CreateUserSettingsResponse$userSettingsArn' => '<p>The ARN of the user settings.</p>', 'DeleteBrowserSettingsRequest$browserSettingsArn' => '<p>The ARN of the browser settings.</p>', 'DeleteIpAccessSettingsRequest$ipAccessSettingsArn' => '<p>The ARN of the IP access settings.</p>', 'DeleteNetworkSettingsRequest$networkSettingsArn' => '<p>The ARN of the network settings.</p>', 'DeletePortalRequest$portalArn' => '<p>The ARN of the web portal.</p>', 'DeleteTrustStoreRequest$trustStoreArn' => '<p>The ARN of the trust store.</p>', 'DeleteUserAccessLoggingSettingsRequest$userAccessLoggingSettingsArn' => '<p>The ARN of the user access logging settings.</p>', 'DeleteUserSettingsRequest$userSettingsArn' => '<p>The ARN of the user settings.</p>', 'DisassociateBrowserSettingsRequest$portalArn' => '<p>The ARN of the web portal.</p>', 'DisassociateIpAccessSettingsRequest$portalArn' => '<p>The ARN of the web portal.</p>', 'DisassociateNetworkSettingsRequest$portalArn' => '<p>The ARN of the web portal.</p>', 'DisassociateTrustStoreRequest$portalArn' => '<p>The ARN of the web portal.</p>', 'DisassociateUserAccessLoggingSettingsRequest$portalArn' => '<p>The ARN of the web portal.</p>', 'DisassociateUserSettingsRequest$portalArn' => '<p>The ARN of the web portal.</p>', 'GetBrowserSettingsRequest$browserSettingsArn' => '<p>The ARN of the browser settings.</p>', 'GetIpAccessSettingsRequest$ipAccessSettingsArn' => '<p>The ARN of the IP access settings.</p>', 'GetNetworkSettingsRequest$networkSettingsArn' => '<p>The ARN of the network settings.</p>', 'GetPortalRequest$portalArn' => '<p>The ARN of the web portal.</p>', 'GetPortalServiceProviderMetadataRequest$portalArn' => '<p>The ARN of the web portal.</p>', 'GetPortalServiceProviderMetadataResponse$portalArn' => '<p>The ARN of the web portal.</p>', 'GetTrustStoreCertificateRequest$trustStoreArn' => '<p>The ARN of the trust store certificate.</p>', 'GetTrustStoreCertificateResponse$trustStoreArn' => '<p>The ARN of the trust store certificate.</p>', 'GetTrustStoreRequest$trustStoreArn' => '<p>The ARN of the trust store.</p>', 'GetUserAccessLoggingSettingsRequest$userAccessLoggingSettingsArn' => '<p>The ARN of the user access logging settings.</p>', 'GetUserSettingsRequest$userSettingsArn' => '<p>The ARN of the user settings.</p>', 'IpAccessSettings$ipAccessSettingsArn' => '<p>The ARN of the IP access settings resource.</p>', 'IpAccessSettingsSummary$ipAccessSettingsArn' => '<p>The ARN of IP access settings.</p>', 'ListIdentityProvidersRequest$portalArn' => '<p>The ARN of the web portal.</p>', 'ListTagsForResourceRequest$resourceArn' => '<p>The ARN of the resource.</p>', 'ListTrustStoreCertificatesRequest$trustStoreArn' => '<p>The ARN of the trust store</p>', 'ListTrustStoreCertificatesResponse$trustStoreArn' => '<p>The ARN of the trust store.</p>', 'NetworkSettings$networkSettingsArn' => '<p>The ARN of the network settings.</p>', 'NetworkSettingsSummary$networkSettingsArn' => '<p>The ARN of the network settings.</p>', 'Portal$browserSettingsArn' => '<p>The ARN of the browser settings that is associated with this web portal.</p>', 'Portal$ipAccessSettingsArn' => '<p>The ARN of the IP access settings.</p>', 'Portal$networkSettingsArn' => '<p>The ARN of the network settings that is associated with the web portal.</p>', 'Portal$portalArn' => '<p>The ARN of the web portal.</p>', 'Portal$trustStoreArn' => '<p>The ARN of the trust store that is associated with the web portal.</p>', 'Portal$userAccessLoggingSettingsArn' => '<p>The ARN of the user access logging settings that is associated with the web portal.</p>', 'Portal$userSettingsArn' => '<p>The ARN of the user settings that is associated with the web portal.</p>', 'PortalSummary$browserSettingsArn' => '<p>The ARN of the browser settings that is associated with the web portal.</p>', 'PortalSummary$ipAccessSettingsArn' => '<p>The ARN of the IP access settings.</p>', 'PortalSummary$networkSettingsArn' => '<p>The ARN of the network settings that is associated with the web portal.</p>', 'PortalSummary$portalArn' => '<p>The ARN of the web portal.</p>', 'PortalSummary$trustStoreArn' => '<p>The ARN of the trust that is associated with this web portal.</p>', 'PortalSummary$userAccessLoggingSettingsArn' => '<p>The ARN of the user access logging settings that is associated with the web portal.</p>', 'PortalSummary$userSettingsArn' => '<p>The ARN of the user settings that is associated with the web portal.</p>', 'TagResourceRequest$resourceArn' => '<p>The ARN of the resource.</p>', 'TooManyTagsException$resourceName' => '<p>Name of the resource affected.</p>', 'TrustStore$trustStoreArn' => '<p>The ARN of the trust store.</p>', 'TrustStoreSummary$trustStoreArn' => '<p>The ARN of the trust store.</p>', 'UntagResourceRequest$resourceArn' => '<p>The ARN of the resource.</p>', 'UpdateBrowserSettingsRequest$browserSettingsArn' => '<p>The ARN of the browser settings.</p>', 'UpdateIpAccessSettingsRequest$ipAccessSettingsArn' => '<p>The ARN of the IP access settings.</p>', 'UpdateNetworkSettingsRequest$networkSettingsArn' => '<p>The ARN of the network settings.</p>', 'UpdatePortalRequest$portalArn' => '<p>The ARN of the web portal.</p>', 'UpdateTrustStoreRequest$trustStoreArn' => '<p>The ARN of the trust store.</p>', 'UpdateTrustStoreResponse$trustStoreArn' => '<p>The ARN of the trust store.</p>', 'UpdateUserAccessLoggingSettingsRequest$userAccessLoggingSettingsArn' => '<p>The ARN of the user access logging settings.</p>', 'UpdateUserSettingsRequest$userSettingsArn' => '<p>The ARN of the user settings.</p>', 'UserAccessLoggingSettings$userAccessLoggingSettingsArn' => '<p>The ARN of the user access logging settings.</p>', 'UserAccessLoggingSettingsSummary$userAccessLoggingSettingsArn' => '<p>The ARN of the user access logging settings.</p>', 'UserSettings$userSettingsArn' => '<p>The ARN of the user settings.</p>', 'UserSettingsSummary$userSettingsArn' => '<p>The ARN of the user settings.</p>', ], ], 'AccessDeniedException' => [ 'base' => '<p>Access is denied.</p>', 'refs' => [], ], 'ArnList' => [ 'base' => NULL, 'refs' => [ 'BrowserSettings$associatedPortalArns' => '<p>A list of web portal ARNs that this browser settings is associated with.</p>', 'IpAccessSettings$associatedPortalArns' => '<p>A list of web portal ARNs that this IP access settings resource is associated with.</p>', 'NetworkSettings$associatedPortalArns' => '<p>A list of web portal ARNs that this network settings is associated with.</p>', 'TrustStore$associatedPortalArns' => '<p>A list of web portal ARNs that this trust store is associated with.</p>', 'UserAccessLoggingSettings$associatedPortalArns' => '<p>A list of web portal ARNs that this user access logging settings is associated with.</p>', 'UserSettings$associatedPortalArns' => '<p>A list of web portal ARNs that this user settings is associated with.</p>', ], ], 'AssociateBrowserSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateBrowserSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociateIpAccessSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateIpAccessSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociateNetworkSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateNetworkSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociateTrustStoreRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateTrustStoreResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociateUserAccessLoggingSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateUserAccessLoggingSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociateUserSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateUserSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'AuthenticationType' => [ 'base' => NULL, 'refs' => [ 'CreatePortalRequest$authenticationType' => '<p>The type of authentication integration points used when signing into the web portal. Defaults to <code>Standard</code>.</p> <p> <code>Standard</code> web portals are authenticated directly through your identity provider. You need to call <code>CreateIdentityProvider</code> to integrate your identity provider with your web portal. User and group access to your web portal is controlled through your identity provider.</p> <p> <code>IAM Identity Center</code> web portals are authenticated through IAM Identity Center (successor to Single Sign-On). Identity sources (including external identity provider integration), plus user and group access to your web portal, can be configured in the IAM Identity Center.</p>', 'Portal$authenticationType' => '<p>The type of authentication integration points used when signing into the web portal. Defaults to <code>Standard</code>.</p> <p> <code>Standard</code> web portals are authenticated directly through your identity provider. You need to call <code>CreateIdentityProvider</code> to integrate your identity provider with your web portal. User and group access to your web portal is controlled through your identity provider.</p> <p> <code>IAM Identity Center</code> web portals are authenticated through IAM Identity Center (successor to Single Sign-On). Identity sources (including external identity provider integration), plus user and group access to your web portal, can be configured in the IAM Identity Center.</p>', 'PortalSummary$authenticationType' => '<p>The type of authentication integration points used when signing into the web portal. Defaults to <code>Standard</code>.</p> <p> <code>Standard</code> web portals are authenticated directly through your identity provider. You need to call <code>CreateIdentityProvider</code> to integrate your identity provider with your web portal. User and group access to your web portal is controlled through your identity provider.</p> <p> <code>IAM Identity Center</code> web portals are authenticated through IAM Identity Center (successor to Single Sign-On). Identity sources (including external identity provider integration), plus user and group access to your web portal, can be configured in the IAM Identity Center.</p>', 'UpdatePortalRequest$authenticationType' => '<p>The type of authentication integration points used when signing into the web portal. Defaults to <code>Standard</code>.</p> <p> <code>Standard</code> web portals are authenticated directly through your identity provider. You need to call <code>CreateIdentityProvider</code> to integrate your identity provider with your web portal. User and group access to your web portal is controlled through your identity provider.</p> <p> <code>IAM Identity Center</code> web portals are authenticated through IAM Identity Center (successor to Single Sign-On). Identity sources (including external identity provider integration), plus user and group access to your web portal, can be configured in the IAM Identity Center.</p>', ], ], 'BrowserPolicy' => [ 'base' => NULL, 'refs' => [ 'BrowserSettings$browserPolicy' => '<p>A JSON string containing Chrome Enterprise policies that will be applied to all streaming sessions.</p>', 'CreateBrowserSettingsRequest$browserPolicy' => '<p>A JSON string containing Chrome Enterprise policies that will be applied to all streaming sessions.</p>', 'UpdateBrowserSettingsRequest$browserPolicy' => '<p>A JSON string containing Chrome Enterprise policies that will be applied to all streaming sessions. </p>', ], ], 'BrowserSettings' => [ 'base' => '<p>The browser settings resource that can be associated with a web portal. Once associated with a web portal, browser settings control how the browser will behave once a user starts a streaming session for the web portal. </p>', 'refs' => [ 'GetBrowserSettingsResponse$browserSettings' => '<p>The browser settings.</p>', 'UpdateBrowserSettingsResponse$browserSettings' => '<p>The browser settings.</p>', ], ], 'BrowserSettingsList' => [ 'base' => NULL, 'refs' => [ 'ListBrowserSettingsResponse$browserSettings' => '<p>The browser settings.</p>', ], ], 'BrowserSettingsSummary' => [ 'base' => '<p>The summary for browser settings.</p>', 'refs' => [ 'BrowserSettingsList$member' => NULL, ], ], 'BrowserType' => [ 'base' => NULL, 'refs' => [ 'Portal$browserType' => '<p>The browser that users see when using a streaming session.</p>', 'PortalSummary$browserType' => '<p>The browser type of the web portal.</p>', ], ], 'Certificate' => [ 'base' => '<p>The certificate.</p>', 'refs' => [ 'GetTrustStoreCertificateResponse$certificate' => '<p>The certificate of the trust store certificate.</p>', ], ], 'CertificateAuthorityBody' => [ 'base' => NULL, 'refs' => [ 'Certificate$body' => '<p>The body of the certificate.</p>', 'CertificateList$member' => NULL, ], ], 'CertificateList' => [ 'base' => NULL, 'refs' => [ 'CreateTrustStoreRequest$certificateList' => '<p>A list of CA certificates to be added to the trust store.</p>', 'UpdateTrustStoreRequest$certificatesToAdd' => '<p>A list of CA certificates to add to the trust store.</p>', ], ], 'CertificatePrincipal' => [ 'base' => NULL, 'refs' => [ 'Certificate$issuer' => '<p>The entity that issued the certificate.</p>', 'Certificate$subject' => '<p>The entity the certificate belongs to.</p>', 'CertificateSummary$issuer' => '<p>The entity that issued the certificate.</p>', 'CertificateSummary$subject' => '<p>The entity the certificate belongs to.</p>', ], ], 'CertificateSummary' => [ 'base' => '<p>The summary of the certificate.</p>', 'refs' => [ 'CertificateSummaryList$member' => NULL, ], ], 'CertificateSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListTrustStoreCertificatesResponse$certificateList' => '<p>The certificate list.</p>', ], ], 'CertificateThumbprint' => [ 'base' => NULL, 'refs' => [ 'Certificate$thumbprint' => '<p>A hexadecimal identifier for the certificate.</p>', 'CertificateSummary$thumbprint' => '<p>A hexadecimal identifier for the certificate.</p>', 'CertificateThumbprintList$member' => NULL, 'GetTrustStoreCertificateRequest$thumbprint' => '<p>The thumbprint of the trust store certificate.</p>', ], ], 'CertificateThumbprintList' => [ 'base' => NULL, 'refs' => [ 'UpdateTrustStoreRequest$certificatesToDelete' => '<p>A list of CA certificates to delete from a trust store.</p>', ], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'CreateBrowserSettingsRequest$clientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request.</p> <p>If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK. </p>', 'CreateIdentityProviderRequest$clientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request.</p> <p>If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.</p>', 'CreateIpAccessSettingsRequest$clientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request. </p> <p>If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.</p>', 'CreateNetworkSettingsRequest$clientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request. </p> <p>If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.</p>', 'CreatePortalRequest$clientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request. </p> <p>If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.</p>', 'CreateTrustStoreRequest$clientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request. </p> <p>If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.</p>', 'CreateUserAccessLoggingSettingsRequest$clientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request. </p> <p>If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.</p>', 'CreateUserSettingsRequest$clientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request. </p> <p>If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.</p>', 'TagResourceRequest$clientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request. </p> <p>If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.</p>', 'UpdateBrowserSettingsRequest$clientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token return the result from the original successful request. </p> <p>If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.</p>', 'UpdateIdentityProviderRequest$clientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token return the result from the original successful request. </p> <p>If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.</p>', 'UpdateIpAccessSettingsRequest$clientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token return the result from the original successful request. </p> <p>If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.</p>', 'UpdateNetworkSettingsRequest$clientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token return the result from the original successful request. </p> <p>If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.</p>', 'UpdateTrustStoreRequest$clientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token return the result from the original successful request. </p> <p>If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.</p>', 'UpdateUserAccessLoggingSettingsRequest$clientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token return the result from the original successful request. </p> <p>If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.</p>', 'UpdateUserSettingsRequest$clientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token return the result from the original successful request. </p> <p>If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.</p>', ], ], 'ConflictException' => [ 'base' => '<p>There is a conflict.</p>', 'refs' => [], ], 'CookieDomain' => [ 'base' => NULL, 'refs' => [ 'CookieSpecification$domain' => '<p>The domain of the cookie.</p>', ], ], 'CookieName' => [ 'base' => NULL, 'refs' => [ 'CookieSpecification$name' => '<p>The name of the cookie.</p>', ], ], 'CookiePath' => [ 'base' => NULL, 'refs' => [ 'CookieSpecification$path' => '<p>The path of the cookie.</p>', ], ], 'CookieSpecification' => [ 'base' => '<p>Specifies a single cookie or set of cookies in an end user\'s browser.</p>', 'refs' => [ 'CookieSpecifications$member' => NULL, ], ], 'CookieSpecifications' => [ 'base' => NULL, 'refs' => [ 'CookieSynchronizationConfiguration$allowlist' => '<p>The list of cookie specifications that are allowed to be synchronized to the remote browser.</p>', 'CookieSynchronizationConfiguration$blocklist' => '<p>The list of cookie specifications that are blocked from being synchronized to the remote browser.</p>', ], ], 'CookieSynchronizationConfiguration' => [ 'base' => '<p>The configuration that specifies which cookies should be synchronized from the end user\'s local browser to the remote browser.</p>', 'refs' => [ 'CreateUserSettingsRequest$cookieSynchronizationConfiguration' => '<p>The configuration that specifies which cookies should be synchronized from the end user\'s local browser to the remote browser.</p>', 'UpdateUserSettingsRequest$cookieSynchronizationConfiguration' => '<p>The configuration that specifies which cookies should be synchronized from the end user\'s local browser to the remote browser.</p> <p>If the allowlist and blocklist are empty, the configuration becomes null.</p>', 'UserSettings$cookieSynchronizationConfiguration' => '<p>The configuration that specifies which cookies should be synchronized from the end user\'s local browser to the remote browser.</p>', 'UserSettingsSummary$cookieSynchronizationConfiguration' => '<p>The configuration that specifies which cookies should be synchronized from the end user\'s local browser to the remote browser.</p>', ], ], 'CreateBrowserSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateBrowserSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateIdentityProviderRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateIdentityProviderResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateIpAccessSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateIpAccessSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateNetworkSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateNetworkSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreatePortalRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreatePortalResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateTrustStoreRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTrustStoreResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateUserAccessLoggingSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateUserAccessLoggingSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateUserSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateUserSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBrowserSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBrowserSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteIdentityProviderRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteIdentityProviderResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteIpAccessSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteIpAccessSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteNetworkSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteNetworkSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeletePortalRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePortalResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTrustStoreRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTrustStoreResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUserAccessLoggingSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUserAccessLoggingSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUserSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUserSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'CreateIpAccessSettingsRequest$description' => '<p>The description of the IP access settings.</p>', 'IpAccessSettings$description' => '<p>The description of the IP access settings.</p>', 'IpAccessSettingsSummary$description' => '<p>The description of the IP access settings.</p>', 'IpRule$description' => '<p>The description of the IP rule.</p>', 'UpdateIpAccessSettingsRequest$description' => '<p>The description of the IP access settings.</p>', ], ], 'DisassociateBrowserSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateBrowserSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateIpAccessSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateIpAccessSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateNetworkSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateNetworkSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateTrustStoreRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateTrustStoreResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateUserAccessLoggingSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateUserAccessLoggingSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateUserSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateUserSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisconnectTimeoutInMinutes' => [ 'base' => NULL, 'refs' => [ 'CreateUserSettingsRequest$disconnectTimeoutInMinutes' => '<p>The amount of time that a streaming session remains active after users disconnect.</p>', 'UpdateUserSettingsRequest$disconnectTimeoutInMinutes' => '<p>The amount of time that a streaming session remains active after users disconnect.</p>', 'UserSettings$disconnectTimeoutInMinutes' => '<p>The amount of time that a streaming session remains active after users disconnect.</p>', 'UserSettingsSummary$disconnectTimeoutInMinutes' => '<p>The amount of time that a streaming session remains active after users disconnect.</p>', ], ], 'DisplayName' => [ 'base' => NULL, 'refs' => [ 'CreateIpAccessSettingsRequest$displayName' => '<p>The display name of the IP access settings.</p>', 'CreatePortalRequest$displayName' => '<p>The name of the web portal. This is not visible to users who log into the web portal.</p>', 'IpAccessSettings$displayName' => '<p> The display name of the IP access settings.</p>', 'IpAccessSettingsSummary$displayName' => '<p>The display name of the IP access settings.</p>', 'Portal$displayName' => '<p>The name of the web portal.</p>', 'PortalSummary$displayName' => '<p>The name of the web portal.</p>', 'UpdateIpAccessSettingsRequest$displayName' => '<p>The display name of the IP access settings.</p>', 'UpdatePortalRequest$displayName' => '<p>The name of the web portal. This is not visible to users who log into the web portal.</p>', ], ], 'EnabledType' => [ 'base' => NULL, 'refs' => [ 'CreateUserSettingsRequest$copyAllowed' => '<p>Specifies whether the user can copy text from the streaming session to the local device.</p>', 'CreateUserSettingsRequest$deepLinkAllowed' => '<p>Specifies whether the user can use deep links that open automatically when connecting to a session.</p>', 'CreateUserSettingsRequest$downloadAllowed' => '<p>Specifies whether the user can download files from the streaming session to the local device.</p>', 'CreateUserSettingsRequest$pasteAllowed' => '<p>Specifies whether the user can paste text from the local device to the streaming session.</p>', 'CreateUserSettingsRequest$printAllowed' => '<p>Specifies whether the user can print to the local device.</p>', 'CreateUserSettingsRequest$uploadAllowed' => '<p>Specifies whether the user can upload files from the local device to the streaming session.</p>', 'UpdateUserSettingsRequest$copyAllowed' => '<p>Specifies whether the user can copy text from the streaming session to the local device.</p>', 'UpdateUserSettingsRequest$deepLinkAllowed' => '<p>Specifies whether the user can use deep links that open automatically when connecting to a session.</p>', 'UpdateUserSettingsRequest$downloadAllowed' => '<p>Specifies whether the user can download files from the streaming session to the local device.</p>', 'UpdateUserSettingsRequest$pasteAllowed' => '<p>Specifies whether the user can paste text from the local device to the streaming session.</p>', 'UpdateUserSettingsRequest$printAllowed' => '<p>Specifies whether the user can print to the local device.</p>', 'UpdateUserSettingsRequest$uploadAllowed' => '<p>Specifies whether the user can upload files from the local device to the streaming session.</p>', 'UserSettings$copyAllowed' => '<p>Specifies whether the user can copy text from the streaming session to the local device.</p>', 'UserSettings$deepLinkAllowed' => '<p>Specifies whether the user can use deep links that open automatically when connecting to a session.</p>', 'UserSettings$downloadAllowed' => '<p>Specifies whether the user can download files from the streaming session to the local device.</p>', 'UserSettings$pasteAllowed' => '<p>Specifies whether the user can paste text from the local device to the streaming session.</p>', 'UserSettings$printAllowed' => '<p>Specifies whether the user can print to the local device.</p>', 'UserSettings$uploadAllowed' => '<p>Specifies whether the user can upload files from the local device to the streaming session.</p>', 'UserSettingsSummary$copyAllowed' => '<p>Specifies whether the user can copy text from the streaming session to the local device.</p>', 'UserSettingsSummary$deepLinkAllowed' => '<p>Specifies whether the user can use deep links that open automatically when connecting to a session.</p>', 'UserSettingsSummary$downloadAllowed' => '<p>Specifies whether the user can download files from the streaming session to the local device.</p>', 'UserSettingsSummary$pasteAllowed' => '<p>Specifies whether the user can paste text from the local device to the streaming session.</p>', 'UserSettingsSummary$printAllowed' => '<p>Specifies whether the user can print to the local device.</p>', 'UserSettingsSummary$uploadAllowed' => '<p>Specifies whether the user can upload files from the local device to the streaming session.</p>', ], ], 'EncryptionContextMap' => [ 'base' => NULL, 'refs' => [ 'BrowserSettings$additionalEncryptionContext' => '<p>The additional encryption context of the browser settings.</p>', 'CreateBrowserSettingsRequest$additionalEncryptionContext' => '<p>Additional encryption context of the browser settings.</p>', 'CreateIpAccessSettingsRequest$additionalEncryptionContext' => '<p>Additional encryption context of the IP access settings.</p>', 'CreatePortalRequest$additionalEncryptionContext' => '<p>The additional encryption context of the portal.</p>', 'CreateUserSettingsRequest$additionalEncryptionContext' => '<p>The additional encryption context of the user settings.</p>', 'IpAccessSettings$additionalEncryptionContext' => '<p>The additional encryption context of the IP access settings.</p>', 'Portal$additionalEncryptionContext' => '<p>The additional encryption context of the portal.</p>', 'UserSettings$additionalEncryptionContext' => '<p>The additional encryption context of the user settings.</p>', ], ], 'ExceptionMessage' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'ConflictException$message' => NULL, 'InternalServerException$message' => NULL, 'ResourceNotFoundException$message' => NULL, 'ServiceQuotaExceededException$message' => NULL, 'ThrottlingException$message' => NULL, 'ValidationException$message' => NULL, 'ValidationExceptionField$message' => '<p>The message describing why the field failed validation.</p>', ], ], 'FieldName' => [ 'base' => NULL, 'refs' => [ 'ValidationExceptionField$name' => '<p>The name of the field that failed validation.</p>', ], ], 'GetBrowserSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetBrowserSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetIdentityProviderRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetIdentityProviderResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetIpAccessSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetIpAccessSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetNetworkSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetNetworkSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetPortalRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPortalResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetPortalServiceProviderMetadataRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPortalServiceProviderMetadataResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetTrustStoreCertificateRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTrustStoreCertificateResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetTrustStoreRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTrustStoreResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetUserAccessLoggingSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetUserAccessLoggingSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetUserSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetUserSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'IdentityProvider' => [ 'base' => '<p>The identity provider.</p>', 'refs' => [ 'GetIdentityProviderResponse$identityProvider' => '<p>The identity provider.</p>', 'UpdateIdentityProviderResponse$identityProvider' => '<p>The identity provider.</p>', ], ], 'IdentityProviderDetails' => [ 'base' => NULL, 'refs' => [ 'CreateIdentityProviderRequest$identityProviderDetails' => '<p>The identity provider details. The following list describes the provider detail keys for each identity provider type. </p> <ul> <li> <p>For Google and Login with Amazon:</p> <ul> <li> <p> <code>client_id</code> </p> </li> <li> <p> <code>client_secret</code> </p> </li> <li> <p> <code>authorize_scopes</code> </p> </li> </ul> </li> <li> <p>For Facebook:</p> <ul> <li> <p> <code>client_id</code> </p> </li> <li> <p> <code>client_secret</code> </p> </li> <li> <p> <code>authorize_scopes</code> </p> </li> <li> <p> <code>api_version</code> </p> </li> </ul> </li> <li> <p>For Sign in with Apple:</p> <ul> <li> <p> <code>client_id</code> </p> </li> <li> <p> <code>team_id</code> </p> </li> <li> <p> <code>key_id</code> </p> </li> <li> <p> <code>private_key</code> </p> </li> <li> <p> <code>authorize_scopes</code> </p> </li> </ul> </li> <li> <p>For OIDC providers:</p> <ul> <li> <p> <code>client_id</code> </p> </li> <li> <p> <code>client_secret</code> </p> </li> <li> <p> <code>attributes_request_method</code> </p> </li> <li> <p> <code>oidc_issuer</code> </p> </li> <li> <p> <code>authorize_scopes</code> </p> </li> <li> <p> <code>authorize_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i> </p> </li> <li> <p> <code>token_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i> </p> </li> <li> <p> <code>attributes_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i> </p> </li> <li> <p> <code>jwks_uri</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i> </p> </li> </ul> </li> <li> <p>For SAML providers:</p> <ul> <li> <p> <code>MetadataFile</code> OR <code>MetadataURL</code> </p> </li> <li> <p> <code>IDPSignout</code> (boolean) <i>optional</i> </p> </li> <li> <p> <code>IDPInit</code> (boolean) <i>optional</i> </p> </li> <li> <p> <code>RequestSigningAlgorithm</code> (string) <i>optional</i> - Only accepts <code>rsa-sha256</code> </p> </li> <li> <p> <code>EncryptedResponses</code> (boolean) <i>optional</i> </p> </li> </ul> </li> </ul>', 'IdentityProvider$identityProviderDetails' => '<p>The identity provider details. The following list describes the provider detail keys for each identity provider type. </p> <ul> <li> <p>For Google and Login with Amazon:</p> <ul> <li> <p> <code>client_id</code> </p> </li> <li> <p> <code>client_secret</code> </p> </li> <li> <p> <code>authorize_scopes</code> </p> </li> </ul> </li> <li> <p>For Facebook:</p> <ul> <li> <p> <code>client_id</code> </p> </li> <li> <p> <code>client_secret</code> </p> </li> <li> <p> <code>authorize_scopes</code> </p> </li> <li> <p> <code>api_version</code> </p> </li> </ul> </li> <li> <p>For Sign in with Apple:</p> <ul> <li> <p> <code>client_id</code> </p> </li> <li> <p> <code>team_id</code> </p> </li> <li> <p> <code>key_id</code> </p> </li> <li> <p> <code>private_key</code> </p> </li> <li> <p> <code>authorize_scopes</code> </p> </li> </ul> </li> <li> <p>For OIDC providers:</p> <ul> <li> <p> <code>client_id</code> </p> </li> <li> <p> <code>client_secret</code> </p> </li> <li> <p> <code>attributes_request_method</code> </p> </li> <li> <p> <code>oidc_issuer</code> </p> </li> <li> <p> <code>authorize_scopes</code> </p> </li> <li> <p> <code>authorize_url</code> <i>if not available from discovery URL specified by oidc_issuer key</i> </p> </li> <li> <p> <code>token_url</code> <i>if not available from discovery URL specified by oidc_issuer key</i> </p> </li> <li> <p> <code>attributes_url</code> <i>if not available from discovery URL specified by oidc_issuer key</i> </p> </li> <li> <p> <code>jwks_uri</code> <i>if not available from discovery URL specified by oidc_issuer key</i> </p> </li> </ul> </li> <li> <p>For SAML providers:</p> <ul> <li> <p> <code>MetadataFile</code> OR <code>MetadataURL</code> </p> </li> <li> <p> <code>IDPSignout</code> (boolean) <i>optional</i> </p> </li> <li> <p> <code>IDPInit</code> (boolean) <i>optional</i> </p> </li> <li> <p> <code>RequestSigningAlgorithm</code> (string) <i>optional</i> - Only accepts <code>rsa-sha256</code> </p> </li> <li> <p> <code>EncryptedResponses</code> (boolean) <i>optional</i> </p> </li> </ul> </li> </ul>', 'UpdateIdentityProviderRequest$identityProviderDetails' => '<p>The details of the identity provider. The following list describes the provider detail keys for each identity provider type. </p> <ul> <li> <p>For Google and Login with Amazon:</p> <ul> <li> <p> <code>client_id</code> </p> </li> <li> <p> <code>client_secret</code> </p> </li> <li> <p> <code>authorize_scopes</code> </p> </li> </ul> </li> <li> <p>For Facebook:</p> <ul> <li> <p> <code>client_id</code> </p> </li> <li> <p> <code>client_secret</code> </p> </li> <li> <p> <code>authorize_scopes</code> </p> </li> <li> <p> <code>api_version</code> </p> </li> </ul> </li> <li> <p>For Sign in with Apple:</p> <ul> <li> <p> <code>client_id</code> </p> </li> <li> <p> <code>team_id</code> </p> </li> <li> <p> <code>key_id</code> </p> </li> <li> <p> <code>private_key</code> </p> </li> <li> <p> <code>authorize_scopes</code> </p> </li> </ul> </li> <li> <p>For OIDC providers:</p> <ul> <li> <p> <code>client_id</code> </p> </li> <li> <p> <code>client_secret</code> </p> </li> <li> <p> <code>attributes_request_method</code> </p> </li> <li> <p> <code>oidc_issuer</code> </p> </li> <li> <p> <code>authorize_scopes</code> </p> </li> <li> <p> <code>authorize_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i> </p> </li> <li> <p> <code>token_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i> </p> </li> <li> <p> <code>attributes_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i> </p> </li> <li> <p> <code>jwks_uri</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i> </p> </li> </ul> </li> <li> <p>For SAML providers:</p> <ul> <li> <p> <code>MetadataFile</code> OR <code>MetadataURL</code> </p> </li> <li> <p> <code>IDPSignout</code> (boolean) <i>optional</i> </p> </li> <li> <p> <code>IDPInit</code> (boolean) <i>optional</i> </p> </li> <li> <p> <code>RequestSigningAlgorithm</code> (string) <i>optional</i> - Only accepts <code>rsa-sha256</code> </p> </li> <li> <p> <code>EncryptedResponses</code> (boolean) <i>optional</i> </p> </li> </ul> </li> </ul>', ], ], 'IdentityProviderList' => [ 'base' => NULL, 'refs' => [ 'ListIdentityProvidersResponse$identityProviders' => '<p>The identity providers.</p>', ], ], 'IdentityProviderName' => [ 'base' => NULL, 'refs' => [ 'CreateIdentityProviderRequest$identityProviderName' => '<p>The identity provider name.</p>', 'IdentityProvider$identityProviderName' => '<p>The identity provider name.</p>', 'IdentityProviderSummary$identityProviderName' => '<p>The identity provider name.</p>', 'UpdateIdentityProviderRequest$identityProviderName' => '<p>The name of the identity provider.</p>', ], ], 'IdentityProviderSummary' => [ 'base' => '<p>The summary of the identity provider.</p>', 'refs' => [ 'IdentityProviderList$member' => NULL, ], ], 'IdentityProviderType' => [ 'base' => NULL, 'refs' => [ 'CreateIdentityProviderRequest$identityProviderType' => '<p>The identity provider type.</p>', 'IdentityProvider$identityProviderType' => '<p>The identity provider type.</p>', 'IdentityProviderSummary$identityProviderType' => '<p>The identity provider type.</p>', 'UpdateIdentityProviderRequest$identityProviderType' => '<p>The type of the identity provider.</p>', ], ], 'IdleDisconnectTimeoutInMinutes' => [ 'base' => NULL, 'refs' => [ 'CreateUserSettingsRequest$idleDisconnectTimeoutInMinutes' => '<p>The amount of time that users can be idle (inactive) before they are disconnected from their streaming session and the disconnect timeout interval begins.</p>', 'UpdateUserSettingsRequest$idleDisconnectTimeoutInMinutes' => '<p>The amount of time that users can be idle (inactive) before they are disconnected from their streaming session and the disconnect timeout interval begins.</p>', 'UserSettings$idleDisconnectTimeoutInMinutes' => '<p>The amount of time that users can be idle (inactive) before they are disconnected from their streaming session and the disconnect timeout interval begins.</p>', 'UserSettingsSummary$idleDisconnectTimeoutInMinutes' => '<p>The amount of time that users can be idle (inactive) before they are disconnected from their streaming session and the disconnect timeout interval begins.</p>', ], ], 'InstanceType' => [ 'base' => NULL, 'refs' => [ 'CreatePortalRequest$instanceType' => '<p>The type and resources of the underlying instance.</p>', 'Portal$instanceType' => '<p>The type and resources of the underlying instance.</p>', 'PortalSummary$instanceType' => '<p>The type and resources of the underlying instance.</p>', 'UpdatePortalRequest$instanceType' => '<p>The type and resources of the underlying instance.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>There is an internal server error.</p>', 'refs' => [], ], 'IpAccessSettings' => [ 'base' => '<p>The IP access settings resource that can be associated with a web portal. </p>', 'refs' => [ 'GetIpAccessSettingsResponse$ipAccessSettings' => '<p>The IP access settings.</p>', 'UpdateIpAccessSettingsResponse$ipAccessSettings' => '<p>The IP access settings.</p>', ], ], 'IpAccessSettingsList' => [ 'base' => NULL, 'refs' => [ 'ListIpAccessSettingsResponse$ipAccessSettings' => '<p>The IP access settings.</p>', ], ], 'IpAccessSettingsSummary' => [ 'base' => '<p>The summary of IP access settings.</p>', 'refs' => [ 'IpAccessSettingsList$member' => NULL, ], ], 'IpRange' => [ 'base' => '<p>A single IP address or an IP address range in CIDR notation</p>', 'refs' => [ 'IpRule$ipRange' => '<p>The IP range of the IP rule.</p>', ], ], 'IpRule' => [ 'base' => '<p>The IP rules of the IP access settings.</p>', 'refs' => [ 'IpRuleList$member' => NULL, ], ], 'IpRuleList' => [ 'base' => NULL, 'refs' => [ 'CreateIpAccessSettingsRequest$ipRules' => '<p>The IP rules of the IP access settings.</p>', 'IpAccessSettings$ipRules' => '<p>The IP rules of the IP access settings.</p>', 'UpdateIpAccessSettingsRequest$ipRules' => '<p>The updated IP rules of the IP access settings.</p>', ], ], 'KinesisStreamArn' => [ 'base' => '<p>Kinesis stream ARN to which log events are published.</p>', 'refs' => [ 'CreateUserAccessLoggingSettingsRequest$kinesisStreamArn' => '<p>The ARN of the Kinesis stream.</p>', 'UpdateUserAccessLoggingSettingsRequest$kinesisStreamArn' => '<p>The ARN of the Kinesis stream.</p>', 'UserAccessLoggingSettings$kinesisStreamArn' => '<p>The ARN of the Kinesis stream.</p>', 'UserAccessLoggingSettingsSummary$kinesisStreamArn' => '<p>The ARN of the Kinesis stream.</p>', ], ], 'ListBrowserSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListBrowserSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListIdentityProvidersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListIdentityProvidersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListIpAccessSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListIpAccessSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListNetworkSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListNetworkSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPortalsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPortalsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTrustStoreCertificatesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTrustStoreCertificatesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTrustStoresRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTrustStoresResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListUserAccessLoggingSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListUserAccessLoggingSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListUserSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListUserSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'MaxConcurrentSessions' => [ 'base' => NULL, 'refs' => [ 'CreatePortalRequest$maxConcurrentSessions' => '<p>The maximum number of concurrent sessions for the portal.</p>', 'Portal$maxConcurrentSessions' => '<p>The maximum number of concurrent sessions for the portal.</p>', 'PortalSummary$maxConcurrentSessions' => '<p>The maximum number of concurrent sessions for the portal.</p>', 'UpdatePortalRequest$maxConcurrentSessions' => '<p>The maximum number of concurrent sessions for the portal.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListBrowserSettingsRequest$maxResults' => '<p>The maximum number of results to be included in the next page.</p>', 'ListIdentityProvidersRequest$maxResults' => '<p>The maximum number of results to be included in the next page.</p>', 'ListIpAccessSettingsRequest$maxResults' => '<p>The maximum number of results to be included in the next page.</p>', 'ListNetworkSettingsRequest$maxResults' => '<p>The maximum number of results to be included in the next page.</p>', 'ListPortalsRequest$maxResults' => '<p>The maximum number of results to be included in the next page.</p>', 'ListTrustStoreCertificatesRequest$maxResults' => '<p>The maximum number of results to be included in the next page.</p>', 'ListTrustStoresRequest$maxResults' => '<p>The maximum number of results to be included in the next page.</p>', 'ListUserAccessLoggingSettingsRequest$maxResults' => '<p>The maximum number of results to be included in the next page.</p>', 'ListUserSettingsRequest$maxResults' => '<p>The maximum number of results to be included in the next page.</p>', ], ], 'NetworkSettings' => [ 'base' => '<p>A network settings resource that can be associated with a web portal. Once associated with a web portal, network settings define how streaming instances will connect with your specified VPC. </p>', 'refs' => [ 'GetNetworkSettingsResponse$networkSettings' => '<p>The network settings.</p>', 'UpdateNetworkSettingsResponse$networkSettings' => '<p>The network settings.</p>', ], ], 'NetworkSettingsList' => [ 'base' => NULL, 'refs' => [ 'ListNetworkSettingsResponse$networkSettings' => '<p>The network settings.</p>', ], ], 'NetworkSettingsSummary' => [ 'base' => '<p>The summary of network settings.</p>', 'refs' => [ 'NetworkSettingsList$member' => NULL, ], ], 'PaginationToken' => [ 'base' => NULL, 'refs' => [ 'ListBrowserSettingsRequest$nextToken' => '<p>The pagination token used to retrieve the next page of results for this operation.</p>', 'ListBrowserSettingsResponse$nextToken' => '<p>The pagination token used to retrieve the next page of results for this operation.</p>', 'ListIdentityProvidersRequest$nextToken' => '<p>The pagination token used to retrieve the next page of results for this operation.</p>', 'ListIdentityProvidersResponse$nextToken' => '<p>The pagination token used to retrieve the next page of results for this operation.</p>', 'ListIpAccessSettingsRequest$nextToken' => '<p>The pagination token used to retrieve the next page of results for this operation.</p>', 'ListIpAccessSettingsResponse$nextToken' => '<p>The pagination token used to retrieve the next page of results for this operation.</p>', 'ListNetworkSettingsRequest$nextToken' => '<p>The pagination token used to retrieve the next page of results for this operation.</p>', 'ListNetworkSettingsResponse$nextToken' => '<p>The pagination token used to retrieve the next page of results for this operation.</p>', 'ListPortalsRequest$nextToken' => '<p>The pagination token used to retrieve the next page of results for this operation. </p>', 'ListPortalsResponse$nextToken' => '<p>The pagination token used to retrieve the next page of results for this operation. </p>', 'ListTrustStoreCertificatesRequest$nextToken' => '<p>The pagination token used to retrieve the next page of results for this operation.</p>', 'ListTrustStoreCertificatesResponse$nextToken' => '<p>The pagination token used to retrieve the next page of results for this operation.&gt;</p>', 'ListTrustStoresRequest$nextToken' => '<p>The pagination token used to retrieve the next page of results for this operation.</p>', 'ListTrustStoresResponse$nextToken' => '<p>The pagination token used to retrieve the next page of results for this operation.</p>', 'ListUserAccessLoggingSettingsRequest$nextToken' => '<p>The pagination token used to retrieve the next page of results for this operation.</p>', 'ListUserAccessLoggingSettingsResponse$nextToken' => '<p>The pagination token used to retrieve the next page of results for this operation.</p>', 'ListUserSettingsRequest$nextToken' => '<p>The pagination token used to retrieve the next page of results for this operation. </p>', 'ListUserSettingsResponse$nextToken' => '<p>The pagination token used to retrieve the next page of results for this operation. </p>', ], ], 'Portal' => [ 'base' => '<p>The web portal.</p>', 'refs' => [ 'GetPortalResponse$portal' => '<p>The web portal.</p>', 'UpdatePortalResponse$portal' => '<p>The web portal.</p>', ], ], 'PortalEndpoint' => [ 'base' => NULL, 'refs' => [ 'CreatePortalResponse$portalEndpoint' => '<p>The endpoint URL of the web portal that users access in order to start streaming sessions.</p>', 'Portal$portalEndpoint' => '<p>The endpoint URL of the web portal that users access in order to start streaming sessions.</p>', 'PortalSummary$portalEndpoint' => '<p>The endpoint URL of the web portal that users access in order to start streaming sessions.</p>', ], ], 'PortalList' => [ 'base' => NULL, 'refs' => [ 'ListPortalsResponse$portals' => '<p>The portals in the list.</p>', ], ], 'PortalStatus' => [ 'base' => NULL, 'refs' => [ 'Portal$portalStatus' => '<p>The status of the web portal.</p>', 'PortalSummary$portalStatus' => '<p>The status of the web portal.</p>', ], ], 'PortalSummary' => [ 'base' => '<p>The summary of the portal.</p>', 'refs' => [ 'PortalList$member' => NULL, ], ], 'QuotaCode' => [ 'base' => NULL, 'refs' => [ 'ServiceQuotaExceededException$quotaCode' => '<p>The originating quota.</p>', 'ThrottlingException$quotaCode' => '<p>The originating quota.</p>', ], ], 'RendererType' => [ 'base' => NULL, 'refs' => [ 'Portal$rendererType' => '<p>The renderer that is used in streaming sessions.</p>', 'PortalSummary$rendererType' => '<p>The renderer that is used in streaming sessions.</p>', ], ], 'ResourceId' => [ 'base' => NULL, 'refs' => [ 'ConflictException$resourceId' => '<p>Identifier of the resource affected.</p>', 'ResourceNotFoundException$resourceId' => '<p>Hypothetical identifier of the resource affected.</p>', 'ServiceQuotaExceededException$resourceId' => '<p>Identifier of the resource affected.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The resource cannot be found.</p>', 'refs' => [], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'ConflictException$resourceType' => '<p>Type of the resource affected.</p>', 'ResourceNotFoundException$resourceType' => '<p>Hypothetical type of the resource affected.</p>', 'ServiceQuotaExceededException$resourceType' => '<p> Type of the resource affected.</p>', ], ], 'RetryAfterSeconds' => [ 'base' => NULL, 'refs' => [ 'InternalServerException$retryAfterSeconds' => '<p>Advice to clients on when the call can be safely retried.</p>', 'ThrottlingException$retryAfterSeconds' => '<p>Advice to clients on when the call can be safely retried.</p>', ], ], 'SamlMetadata' => [ 'base' => NULL, 'refs' => [ 'GetPortalServiceProviderMetadataResponse$serviceProviderSamlMetadata' => '<p>The service provider SAML metadata.</p>', ], ], 'SecurityGroupId' => [ 'base' => NULL, 'refs' => [ 'SecurityGroupIdList$member' => NULL, ], ], 'SecurityGroupIdList' => [ 'base' => NULL, 'refs' => [ 'CreateNetworkSettingsRequest$securityGroupIds' => '<p>One or more security groups used to control access from streaming instances to your VPC.</p>', 'NetworkSettings$securityGroupIds' => '<p>One or more security groups used to control access from streaming instances to your VPC. </p>', 'UpdateNetworkSettingsRequest$securityGroupIds' => '<p>One or more security groups used to control access from streaming instances to your VPC.</p>', ], ], 'ServiceCode' => [ 'base' => NULL, 'refs' => [ 'ServiceQuotaExceededException$serviceCode' => '<p>The originating service.</p>', 'ThrottlingException$serviceCode' => '<p>The originating service.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>The service quota has been exceeded.</p>', 'refs' => [], ], 'StatusReason' => [ 'base' => NULL, 'refs' => [ 'Portal$statusReason' => '<p>A message that explains why the web portal is in its current status.</p>', ], ], 'StringType' => [ 'base' => NULL, 'refs' => [ 'EncryptionContextMap$key' => NULL, 'EncryptionContextMap$value' => NULL, 'IdentityProviderDetails$key' => NULL, 'IdentityProviderDetails$value' => NULL, ], ], 'SubnetId' => [ 'base' => NULL, 'refs' => [ 'SubnetIdList$member' => NULL, ], ], 'SubnetIdList' => [ 'base' => NULL, 'refs' => [ 'CreateNetworkSettingsRequest$subnetIds' => '<p>The subnets in which network interfaces are created to connect streaming instances to your VPC. At least two of these subnets must be in different availability zones.</p>', 'NetworkSettings$subnetIds' => '<p>The subnets in which network interfaces are created to connect streaming instances to your VPC. At least two of these subnets must be in different availability zones.</p>', 'UpdateNetworkSettingsRequest$subnetIds' => '<p>The subnets in which network interfaces are created to connect streaming instances to your VPC. At least two of these subnets must be in different availability zones.</p>', ], ], 'SubresourceARN' => [ 'base' => NULL, 'refs' => [ 'CreateIdentityProviderResponse$identityProviderArn' => '<p>The ARN of the identity provider.</p>', 'DeleteIdentityProviderRequest$identityProviderArn' => '<p>The ARN of the identity provider.</p>', 'GetIdentityProviderRequest$identityProviderArn' => '<p>The ARN of the identity provider.</p>', 'IdentityProvider$identityProviderArn' => '<p>The ARN of the identity provider.</p>', 'IdentityProviderSummary$identityProviderArn' => '<p>The ARN of the identity provider.</p>', 'UpdateIdentityProviderRequest$identityProviderArn' => '<p>The ARN of the identity provider.</p>', ], ], 'Tag' => [ 'base' => '<p>The tag.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagExceptionMessage' => [ 'base' => NULL, 'refs' => [ 'TooManyTagsException$message' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The key of the tag.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>The list of tag keys to remove from the resource.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateBrowserSettingsRequest$tags' => '<p>The tags to add to the browser settings resource. A tag is a key-value pair.</p>', 'CreateIdentityProviderRequest$tags' => '<p>The tags to add to the identity provider resource. A tag is a key-value pair.</p>', 'CreateIpAccessSettingsRequest$tags' => '<p>The tags to add to the IP access settings resource. A tag is a key-value pair.</p>', 'CreateNetworkSettingsRequest$tags' => '<p>The tags to add to the network settings resource. A tag is a key-value pair.</p>', 'CreatePortalRequest$tags' => '<p>The tags to add to the web portal. A tag is a key-value pair.</p>', 'CreateTrustStoreRequest$tags' => '<p>The tags to add to the trust store. A tag is a key-value pair.</p>', 'CreateUserAccessLoggingSettingsRequest$tags' => '<p>The tags to add to the user settings resource. A tag is a key-value pair.</p>', 'CreateUserSettingsRequest$tags' => '<p>The tags to add to the user settings resource. A tag is a key-value pair.</p>', 'ListTagsForResourceResponse$tags' => '<p>The tags of the resource.</p>', 'TagResourceRequest$tags' => '<p>The tags of the resource.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The value of the tag</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>There is a throttling error.</p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'Certificate$notValidAfter' => '<p>The certificate is not valid after this date.</p>', 'Certificate$notValidBefore' => '<p>The certificate is not valid before this date.</p>', 'CertificateSummary$notValidAfter' => '<p>The certificate is not valid after this date.</p>', 'CertificateSummary$notValidBefore' => '<p>The certificate is not valid before this date.</p>', 'IpAccessSettings$creationDate' => '<p>The creation date timestamp of the IP access settings.</p>', 'IpAccessSettingsSummary$creationDate' => '<p>The creation date timestamp of the IP access settings.</p>', 'Portal$creationDate' => '<p>The creation date of the web portal.</p>', 'PortalSummary$creationDate' => '<p>The creation date of the web portal.</p>', ], ], 'TooManyTagsException' => [ 'base' => '<p>There are too many tags.</p>', 'refs' => [], ], 'TrustStore' => [ 'base' => '<p>A trust store that can be associated with a web portal. A trust store contains certificate authority (CA) certificates. Once associated with a web portal, the browser in a streaming session will recognize certificates that have been issued using any of the CAs in the trust store. If your organization has internal websites that use certificates issued by private CAs, you should add the private CA certificate to the trust store. </p>', 'refs' => [ 'GetTrustStoreResponse$trustStore' => '<p>The trust store.</p>', ], ], 'TrustStoreSummary' => [ 'base' => '<p>The summary of the trust store.</p>', 'refs' => [ 'TrustStoreSummaryList$member' => NULL, ], ], 'TrustStoreSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListTrustStoresResponse$trustStores' => '<p>The trust stores.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateBrowserSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateBrowserSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateIdentityProviderRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateIdentityProviderResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateIpAccessSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateIpAccessSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateNetworkSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateNetworkSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePortalRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePortalResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTrustStoreRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTrustStoreResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserAccessLoggingSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserAccessLoggingSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'UserAccessLoggingSettings' => [ 'base' => '<p>A user access logging settings resource that can be associated with a web portal.</p>', 'refs' => [ 'GetUserAccessLoggingSettingsResponse$userAccessLoggingSettings' => '<p>The user access logging settings.</p>', 'UpdateUserAccessLoggingSettingsResponse$userAccessLoggingSettings' => '<p>The user access logging settings.</p>', ], ], 'UserAccessLoggingSettingsList' => [ 'base' => NULL, 'refs' => [ 'ListUserAccessLoggingSettingsResponse$userAccessLoggingSettings' => '<p>The user access logging settings.</p>', ], ], 'UserAccessLoggingSettingsSummary' => [ 'base' => '<p>The summary of user access logging settings.</p>', 'refs' => [ 'UserAccessLoggingSettingsList$member' => NULL, ], ], 'UserSettings' => [ 'base' => '<p>A user settings resource that can be associated with a web portal. Once associated with a web portal, user settings control how users can transfer data between a streaming session and the their local devices. </p>', 'refs' => [ 'GetUserSettingsResponse$userSettings' => '<p>The user settings.</p>', 'UpdateUserSettingsResponse$userSettings' => '<p>The user settings.</p>', ], ], 'UserSettingsList' => [ 'base' => NULL, 'refs' => [ 'ListUserSettingsResponse$userSettings' => '<p>The user settings.</p>', ], ], 'UserSettingsSummary' => [ 'base' => '<p>The summary of user settings.</p>', 'refs' => [ 'UserSettingsList$member' => NULL, ], ], 'ValidationException' => [ 'base' => '<p>There is a validation error.</p>', 'refs' => [], ], 'ValidationExceptionField' => [ 'base' => '<p>Information about a field passed inside a request that resulted in an exception.</p>', 'refs' => [ 'ValidationExceptionFieldList$member' => NULL, ], ], 'ValidationExceptionFieldList' => [ 'base' => NULL, 'refs' => [ 'ValidationException$fieldList' => '<p>The field that caused the error.</p>', ], ], 'ValidationExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ValidationException$reason' => '<p>Reason the request failed validation</p>', ], ], 'VpcId' => [ 'base' => NULL, 'refs' => [ 'CreateNetworkSettingsRequest$vpcId' => '<p>The VPC that streaming instances will connect to.</p>', 'NetworkSettings$vpcId' => '<p>The VPC that streaming instances will connect to.</p>', 'NetworkSettingsSummary$vpcId' => '<p>The VPC ID of the network settings.</p>', 'UpdateNetworkSettingsRequest$vpcId' => '<p>The VPC that streaming instances will connect to.</p>', ], ], 'keyArn' => [ 'base' => NULL, 'refs' => [ 'BrowserSettings$customerManagedKey' => '<p>The customer managed key used to encrypt sensitive information in the browser settings.</p>', 'CreateBrowserSettingsRequest$customerManagedKey' => '<p>The custom managed key of the browser settings.</p>', 'CreateIpAccessSettingsRequest$customerManagedKey' => '<p>The custom managed key of the IP access settings.</p>', 'CreatePortalRequest$customerManagedKey' => '<p>The customer managed key of the web portal.</p>', 'CreateUserSettingsRequest$customerManagedKey' => '<p>The customer managed key used to encrypt sensitive information in the user settings.</p>', 'IpAccessSettings$customerManagedKey' => '<p>The customer managed key used to encrypt sensitive information in the IP access settings.</p>', 'Portal$customerManagedKey' => '<p>The customer managed key used to encrypt sensitive information in the portal.</p>', 'UserSettings$customerManagedKey' => '<p>The customer managed key used to encrypt sensitive information in the user settings.</p>', ], ], ],];
