<?php
declare(strict_types = 1);

return [
    'headers' => [
        'server' => [
            'GitHub.com'
        ],
        'date' => [
            'Mon, 10 Jun 2024 15:59:24 GMT'
        ],
        'content-type' => [
            'application/json; charset=utf-8'
        ],
        'vary' => [
            'X-PJAX, X-PJAX-Container, Turbo-Visit, Turbo-Frame, Accept-Encoding, Accept, X-Requested-With'
        ],
        'etag' => [
            'W/"1d9fb08988578bbd09f38d77ed74f169"'
        ],
        'cache-control' => [
            'max-age=0, private, must-revalidate'
        ],
        'strict-transport-security' => [
            'max-age=31536000; includeSubdomains; preload'
        ],
        'x-frame-options' => [
            'deny'
        ],
        'x-content-type-options' => [
            'nosniff'
        ],
        'x-xss-protection' => [
            '0'
        ],
        'referrer-policy' => [
            'origin-when-cross-origin, strict-origin-when-cross-origin'
        ],
        'content-security-policy' => [
            'default-src \'none\'; base-uri \'self\'; child-src github.com/assets-cdn/worker/ gist.github.com/assets-cdn/worker/; connect-src \'self\' uploads.github.com www.githubstatus.com collector.github.com raw.githubusercontent.com api.github.com github-cloud.s3.amazonaws.com github-production-repository-file-5c1aeb.s3.amazonaws.com github-production-upload-manifest-file-7fdce7.s3.amazonaws.com github-production-user-asset-6210df.s3.amazonaws.com api.githubcopilot.com objects-origin.githubusercontent.com copilot-proxy.githubusercontent.com/v1/engines/github-completion/completions *.actions.githubusercontent.com wss://*.actions.githubusercontent.com productionresultssa0.blob.core.windows.net/ productionresultssa1.blob.core.windows.net/ productionresultssa2.blob.core.windows.net/ productionresultssa3.blob.core.windows.net/ productionresultssa4.blob.core.windows.net/ productionresultssa5.blob.core.windows.net/ productionresultssa6.blob.core.windows.net/ productionresultssa7.blob.core.windows.net/ productionresultssa8.blob.core.windows.net/ productionresultssa9.blob.core.windows.net/ productionresultssa10.blob.core.windows.net/ productionresultssa11.blob.core.windows.net/ productionresultssa12.blob.core.windows.net/ productionresultssa13.blob.core.windows.net/ productionresultssa14.blob.core.windows.net/ productionresultssa15.blob.core.windows.net/ productionresultssa16.blob.core.windows.net/ productionresultssa17.blob.core.windows.net/ productionresultssa18.blob.core.windows.net/ productionresultssa19.blob.core.windows.net/ github-production-repository-image-32fea6.s3.amazonaws.com github-production-release-asset-2e65be.s3.amazonaws.com insights.github.com wss://alive.github.com; font-src github.githubassets.com; form-action \'self\' github.com gist.github.com copilot-workspace.githubnext.com objects-origin.githubusercontent.com; frame-ancestors \'none\'; frame-src viewscreen.githubusercontent.com notebooks.githubusercontent.com; img-src \'self\' data: github.githubassets.com media.githubusercontent.com camo.githubusercontent.com identicons.github.com avatars.githubusercontent.com github-cloud.s3.amazonaws.com objects.githubusercontent.com secured-user-images.githubusercontent.com/ user-images.githubusercontent.com/ private-user-images.githubusercontent.com opengraph.githubassets.com github-production-user-asset-6210df.s3.amazonaws.com customer-stories-feed.github.com spotlights-feed.github.com objects-origin.githubusercontent.com *.githubusercontent.com; manifest-src \'self\'; media-src github.com user-images.githubusercontent.com/ secured-user-images.githubusercontent.com/ private-user-images.githubusercontent.com github-production-user-asset-6210df.s3.amazonaws.com gist.github.com; script-src github.githubassets.com; style-src \'unsafe-inline\' github.githubassets.com; upgrade-insecure-requests; worker-src github.com/assets-cdn/worker/ gist.github.com/assets-cdn/worker/'
        ],
        'content-encoding' => [
            'gzip'
        ],
        'accept-ranges' => [
            'bytes'
        ],
        'content-length' => [
            '2726'
        ],
        'x-github-request-id' => [
            'FF15:51E7:5C7C460:5E3F8CB:666722DC'
        ],
        'Content-Location' => [
            'https://gist.github.com/oscarotero/7749998.json'
        ],
        'X-Request-Time' => [
            '0.272 ms'
        ]
    ],
    'statusCode' => 200,
    'reasonPhrase' => 'OK',
    'body' => '{"description":"","public":true,"created_at":"2013-12-02T14:10:20.000Z","files":["Git-cheatsheet.sh"],"owner":"oscarotero","div":"<div id=\\"gist7749998\\" class=\\"gist\\">\\n    <div class=\\"gist-file\\" translate=\\"no\\" data-color-mode=\\"light\\" data-light-theme=\\"light\\">\\n      <div class=\\"gist-data\\">\\n        <div class=\\"js-gist-file-update-container js-task-list-container\\">\\n  <div id=\\"file-git-cheatsheet-sh\\" class=\\"file my-2\\">\\n    \\n    <div itemprop=\\"text\\" class=\\"Box-body p-0 blob-wrapper data type-shell  \\">\\n\\n        \\n<div class=\\"js-check-bidi js-blob-code-container blob-code-content\\">\\n\\n  <template class=\\"js-file-alert-template\\">\\n  <div data-view-component=\\"true\\" class=\\"flash flash-warn flash-full d-flex flex-items-center\\">\\n  <svg aria-hidden=\\"true\\" height=\\"16\\" viewBox=\\"0 0 16 16\\" version=\\"1.1\\" width=\\"16\\" data-view-component=\\"true\\" class=\\"octicon octicon-alert\\">\\n    <path d=\\"M6.457 1.047c.659-1.234 2.427-1.234 3.086 0l6.082 11.378A1.75 1.75 0 0 1 14.082 15H1.918a1.75 1.75 0 0 1-1.543-2.575Zm1.763.707a.25.25 0 0 0-.44 0L1.698 13.132a.25.25 0 0 0 .22.368h12.164a.25.25 0 0 0 .22-.368Zm.53 3.996v2.5a.75.75 0 0 1-1.5 0v-2.5a.75.75 0 0 1 1.5 0ZM9 11a1 1 0 1 1-2 0 1 1 0 0 1 2 0Z\\"></path>\\n</svg>\\n    <span>\\n      This file contains bidirectional Unicode text that may be interpreted or compiled differently than what appears below. To review, open the file in an editor that reveals hidden Unicode characters.\\n      <a class=\\"Link--inTextBlock\\" href=\\"https://github.co/hiddenchars\\" target=\\"_blank\\">Learn more about bidirectional Unicode characters</a>\\n    </span>\\n\\n\\n  <div data-view-component=\\"true\\" class=\\"flash-action\\">        <a href=\\"{{ revealButtonHref }}\\" data-view-component=\\"true\\" class=\\"btn-sm btn\\">    Show hidden characters\\n</a>\\n</div>\\n</div></template>\\n<template class=\\"js-line-alert-template\\">\\n  <span aria-label=\\"This line has hidden Unicode characters\\" data-view-component=\\"true\\" class=\\"line-alert tooltipped tooltipped-e\\">\\n    <svg aria-hidden=\\"true\\" height=\\"16\\" viewBox=\\"0 0 16 16\\" version=\\"1.1\\" width=\\"16\\" data-view-component=\\"true\\" class=\\"octicon octicon-alert\\">\\n    <path d=\\"M6.457 1.047c.659-1.234 2.427-1.234 3.086 0l6.082 11.378A1.75 1.75 0 0 1 14.082 15H1.918a1.75 1.75 0 0 1-1.543-2.575Zm1.763.707a.25.25 0 0 0-.44 0L1.698 13.132a.25.25 0 0 0 .22.368h12.164a.25.25 0 0 0 .22-.368Zm.53 3.996v2.5a.75.75 0 0 1-1.5 0v-2.5a.75.75 0 0 1 1.5 0ZM9 11a1 1 0 1 1-2 0 1 1 0 0 1 2 0Z\\"></path>\\n</svg>\\n</span></template>\\n\\n  <table data-hpc class=\\"highlight tab-size js-file-line-container js-code-nav-container js-tagsearch-file\\" data-tab-size=\\"8\\" data-paste-markdown-skip data-tagsearch-lang=\\"Shell\\" data-tagsearch-path=\\"Git-cheatsheet.sh\\">\\n        <tr>\\n          <td id=\\"file-git-cheatsheet-sh-L1\\" class=\\"blob-num js-line-number js-code-nav-line-number js-blob-rnum\\" data-line-number=\\"1\\"></td>\\n          <td id=\\"file-git-cheatsheet-sh-LC1\\" class=\\"blob-code blob-code-inner js-file-line\\"><span class=\\"pl-c\\"><span class=\\"pl-c\\">#</span> Undo latest commit</span></td>\\n        </tr>\\n        <tr>\\n          <td id=\\"file-git-cheatsheet-sh-L2\\" class=\\"blob-num js-line-number js-code-nav-line-number js-blob-rnum\\" data-line-number=\\"2\\"></td>\\n          <td id=\\"file-git-cheatsheet-sh-LC2\\" class=\\"blob-code blob-code-inner js-file-line\\">git reset --soft HEAD^</td>\\n        </tr>\\n        <tr>\\n          <td id=\\"file-git-cheatsheet-sh-L3\\" class=\\"blob-num js-line-number js-code-nav-line-number js-blob-rnum\\" data-line-number=\\"3\\"></td>\\n          <td id=\\"file-git-cheatsheet-sh-LC3\\" class=\\"blob-code blob-code-inner js-file-line\\">\\n</td>\\n        </tr>\\n        <tr>\\n          <td id=\\"file-git-cheatsheet-sh-L4\\" class=\\"blob-num js-line-number js-code-nav-line-number js-blob-rnum\\" data-line-number=\\"4\\"></td>\\n          <td id=\\"file-git-cheatsheet-sh-LC4\\" class=\\"blob-code blob-code-inner js-file-line\\"><span class=\\"pl-c\\"><span class=\\"pl-c\\">#</span> Undo the changes of a commit (creating a new commit)</span></td>\\n        </tr>\\n        <tr>\\n          <td id=\\"file-git-cheatsheet-sh-L5\\" class=\\"blob-num js-line-number js-code-nav-line-number js-blob-rnum\\" data-line-number=\\"5\\"></td>\\n          <td id=\\"file-git-cheatsheet-sh-LC5\\" class=\\"blob-code blob-code-inner js-file-line\\">git revert <span class=\\"pl-k\\">&lt;</span>commit<span class=\\"pl-k\\">&gt;</span></td>\\n        </tr>\\n        <tr>\\n          <td id=\\"file-git-cheatsheet-sh-L6\\" class=\\"blob-num js-line-number js-code-nav-line-number js-blob-rnum\\" data-line-number=\\"6\\"></td>\\n          <td id=\\"file-git-cheatsheet-sh-LC6\\" class=\\"blob-code blob-code-inner js-file-line\\">\\n</td>\\n        </tr>\\n        <tr>\\n          <td id=\\"file-git-cheatsheet-sh-L7\\" class=\\"blob-num js-line-number js-code-nav-line-number js-blob-rnum\\" data-line-number=\\"7\\"></td>\\n          <td id=\\"file-git-cheatsheet-sh-LC7\\" class=\\"blob-code blob-code-inner js-file-line\\"><span class=\\"pl-c\\"><span class=\\"pl-c\\">#</span> Undo latest merge (before push)</span></td>\\n        </tr>\\n        <tr>\\n          <td id=\\"file-git-cheatsheet-sh-L8\\" class=\\"blob-num js-line-number js-code-nav-line-number js-blob-rnum\\" data-line-number=\\"8\\"></td>\\n          <td id=\\"file-git-cheatsheet-sh-LC8\\" class=\\"blob-code blob-code-inner js-file-line\\">git reset --merge ORIG_HEAD</td>\\n        </tr>\\n        <tr>\\n          <td id=\\"file-git-cheatsheet-sh-L9\\" class=\\"blob-num js-line-number js-code-nav-line-number js-blob-rnum\\" data-line-number=\\"9\\"></td>\\n          <td id=\\"file-git-cheatsheet-sh-LC9\\" class=\\"blob-code blob-code-inner js-file-line\\">\\n</td>\\n        </tr>\\n        <tr>\\n          <td id=\\"file-git-cheatsheet-sh-L10\\" class=\\"blob-num js-line-number js-code-nav-line-number js-blob-rnum\\" data-line-number=\\"10\\"></td>\\n          <td id=\\"file-git-cheatsheet-sh-LC10\\" class=\\"blob-code blob-code-inner js-file-line\\"><span class=\\"pl-c\\"><span class=\\"pl-c\\">#</span> Merge a branch using the version of the current branch in case of conflicts</span></td>\\n        </tr>\\n        <tr>\\n          <td id=\\"file-git-cheatsheet-sh-L11\\" class=\\"blob-num js-line-number js-code-nav-line-number js-blob-rnum\\" data-line-number=\\"11\\"></td>\\n          <td id=\\"file-git-cheatsheet-sh-LC11\\" class=\\"blob-code blob-code-inner js-file-line\\">git merge <span class=\\"pl-k\\">&lt;</span>branch<span class=\\"pl-k\\">&gt;</span> -s ours</td>\\n        </tr>\\n        <tr>\\n          <td id=\\"file-git-cheatsheet-sh-L12\\" class=\\"blob-num js-line-number js-code-nav-line-number js-blob-rnum\\" data-line-number=\\"12\\"></td>\\n          <td id=\\"file-git-cheatsheet-sh-LC12\\" class=\\"blob-code blob-code-inner js-file-line\\">\\n</td>\\n        </tr>\\n        <tr>\\n          <td id=\\"file-git-cheatsheet-sh-L13\\" class=\\"blob-num js-line-number js-code-nav-line-number js-blob-rnum\\" data-line-number=\\"13\\"></td>\\n          <td id=\\"file-git-cheatsheet-sh-LC13\\" class=\\"blob-code blob-code-inner js-file-line\\"><span class=\\"pl-c\\"><span class=\\"pl-c\\">#</span> Discard changes for a particular file after commit</span></td>\\n        </tr>\\n        <tr>\\n          <td id=\\"file-git-cheatsheet-sh-L14\\" class=\\"blob-num js-line-number js-code-nav-line-number js-blob-rnum\\" data-line-number=\\"14\\"></td>\\n          <td id=\\"file-git-cheatsheet-sh-LC14\\" class=\\"blob-code blob-code-inner js-file-line\\">git reset HEAD <span class=\\"pl-k\\">&lt;</span>file<span class=\\"pl-k\\">&gt;</span></td>\\n        </tr>\\n        <tr>\\n          <td id=\\"file-git-cheatsheet-sh-L15\\" class=\\"blob-num js-line-number js-code-nav-line-number js-blob-rnum\\" data-line-number=\\"15\\"></td>\\n          <td id=\\"file-git-cheatsheet-sh-LC15\\" class=\\"blob-code blob-code-inner js-file-line\\">\\n</td>\\n        </tr>\\n        <tr>\\n          <td id=\\"file-git-cheatsheet-sh-L16\\" class=\\"blob-num js-line-number js-code-nav-line-number js-blob-rnum\\" data-line-number=\\"16\\"></td>\\n          <td id=\\"file-git-cheatsheet-sh-LC16\\" class=\\"blob-code blob-code-inner js-file-line\\"><span class=\\"pl-c\\"><span class=\\"pl-c\\">#</span> Unstage the current staged changes</span></td>\\n        </tr>\\n        <tr>\\n          <td id=\\"file-git-cheatsheet-sh-L17\\" class=\\"blob-num js-line-number js-code-nav-line-number js-blob-rnum\\" data-line-number=\\"17\\"></td>\\n          <td id=\\"file-git-cheatsheet-sh-LC17\\" class=\\"blob-code blob-code-inner js-file-line\\">git reset</td>\\n        </tr>\\n        <tr>\\n          <td id=\\"file-git-cheatsheet-sh-L18\\" class=\\"blob-num js-line-number js-code-nav-line-number js-blob-rnum\\" data-line-number=\\"18\\"></td>\\n          <td id=\\"file-git-cheatsheet-sh-LC18\\" class=\\"blob-code blob-code-inner js-file-line\\">\\n</td>\\n        </tr>\\n        <tr>\\n          <td id=\\"file-git-cheatsheet-sh-L19\\" class=\\"blob-num js-line-number js-code-nav-line-number js-blob-rnum\\" data-line-number=\\"19\\"></td>\\n          <td id=\\"file-git-cheatsheet-sh-LC19\\" class=\\"blob-code blob-code-inner js-file-line\\"><span class=\\"pl-c\\"><span class=\\"pl-c\\">#</span> Create, fetch a remote branch and switch to it</span></td>\\n        </tr>\\n        <tr>\\n          <td id=\\"file-git-cheatsheet-sh-L20\\" class=\\"blob-num js-line-number js-code-nav-line-number js-blob-rnum\\" data-line-number=\\"20\\"></td>\\n          <td id=\\"file-git-cheatsheet-sh-LC20\\" class=\\"blob-code blob-code-inner js-file-line\\">git checkout --track <span class=\\"pl-k\\">&lt;</span>remote<span class=\\"pl-k\\">&gt;</span>/<span class=\\"pl-k\\">&lt;</span>branch<span class=\\"pl-k\\">&gt;</span></td>\\n        </tr>\\n        <tr>\\n          <td id=\\"file-git-cheatsheet-sh-L21\\" class=\\"blob-num js-line-number js-code-nav-line-number js-blob-rnum\\" data-line-number=\\"21\\"></td>\\n          <td id=\\"file-git-cheatsheet-sh-LC21\\" class=\\"blob-code blob-code-inner js-file-line\\">\\n</td>\\n        </tr>\\n        <tr>\\n          <td id=\\"file-git-cheatsheet-sh-L22\\" class=\\"blob-num js-line-number js-code-nav-line-number js-blob-rnum\\" data-line-number=\\"22\\"></td>\\n          <td id=\\"file-git-cheatsheet-sh-LC22\\" class=\\"blob-code blob-code-inner js-file-line\\"><span class=\\"pl-c\\"><span class=\\"pl-c\\">#</span> Remove a file from git but not from disc</span></td>\\n        </tr>\\n        <tr>\\n          <td id=\\"file-git-cheatsheet-sh-L23\\" class=\\"blob-num js-line-number js-code-nav-line-number js-blob-rnum\\" data-line-number=\\"23\\"></td>\\n          <td id=\\"file-git-cheatsheet-sh-LC23\\" class=\\"blob-code blob-code-inner js-file-line\\">git rm --cached <span class=\\"pl-k\\">&lt;</span>file<span class=\\"pl-k\\">&gt;</span></td>\\n        </tr>\\n        <tr>\\n          <td id=\\"file-git-cheatsheet-sh-L24\\" class=\\"blob-num js-line-number js-code-nav-line-number js-blob-rnum\\" data-line-number=\\"24\\"></td>\\n          <td id=\\"file-git-cheatsheet-sh-LC24\\" class=\\"blob-code blob-code-inner js-file-line\\">\\n</td>\\n        </tr>\\n        <tr>\\n          <td id=\\"file-git-cheatsheet-sh-L25\\" class=\\"blob-num js-line-number js-code-nav-line-number js-blob-rnum\\" data-line-number=\\"25\\"></td>\\n          <td id=\\"file-git-cheatsheet-sh-LC25\\" class=\\"blob-code blob-code-inner js-file-line\\"><span class=\\"pl-c\\"><span class=\\"pl-c\\">#</span> Reapply an old commit again</span></td>\\n        </tr>\\n        <tr>\\n          <td id=\\"file-git-cheatsheet-sh-L26\\" class=\\"blob-num js-line-number js-code-nav-line-number js-blob-rnum\\" data-line-number=\\"26\\"></td>\\n          <td id=\\"file-git-cheatsheet-sh-LC26\\" class=\\"blob-code blob-code-inner js-file-line\\">git cherry-pick <span class=\\"pl-k\\">&lt;</span>commit<span class=\\"pl-k\\">&gt;</span></td>\\n        </tr>\\n        <tr>\\n          <td id=\\"file-git-cheatsheet-sh-L27\\" class=\\"blob-num js-line-number js-code-nav-line-number js-blob-rnum\\" data-line-number=\\"27\\"></td>\\n          <td id=\\"file-git-cheatsheet-sh-LC27\\" class=\\"blob-code blob-code-inner js-file-line\\">\\n</td>\\n        </tr>\\n        <tr>\\n          <td id=\\"file-git-cheatsheet-sh-L28\\" class=\\"blob-num js-line-number js-code-nav-line-number js-blob-rnum\\" data-line-number=\\"28\\"></td>\\n          <td id=\\"file-git-cheatsheet-sh-LC28\\" class=\\"blob-code blob-code-inner js-file-line\\"><span class=\\"pl-c\\"><span class=\\"pl-c\\">#</span> Ignore the changes of a file</span></td>\\n        </tr>\\n        <tr>\\n          <td id=\\"file-git-cheatsheet-sh-L29\\" class=\\"blob-num js-line-number js-code-nav-line-number js-blob-rnum\\" data-line-number=\\"29\\"></td>\\n          <td id=\\"file-git-cheatsheet-sh-LC29\\" class=\\"blob-code blob-code-inner js-file-line\\">git update-index --assume-unchanged <span class=\\"pl-k\\">&lt;</span>file<span class=\\"pl-k\\">&gt;</span></td>\\n        </tr>\\n        <tr>\\n          <td id=\\"file-git-cheatsheet-sh-L30\\" class=\\"blob-num js-line-number js-code-nav-line-number js-blob-rnum\\" data-line-number=\\"30\\"></td>\\n          <td id=\\"file-git-cheatsheet-sh-LC30\\" class=\\"blob-code blob-code-inner js-file-line\\">\\n</td>\\n        </tr>\\n        <tr>\\n          <td id=\\"file-git-cheatsheet-sh-L31\\" class=\\"blob-num js-line-number js-code-nav-line-number js-blob-rnum\\" data-line-number=\\"31\\"></td>\\n          <td id=\\"file-git-cheatsheet-sh-LC31\\" class=\\"blob-code blob-code-inner js-file-line\\"><span class=\\"pl-c\\"><span class=\\"pl-c\\">#</span> Not ignore the changes of a file</span></td>\\n        </tr>\\n        <tr>\\n          <td id=\\"file-git-cheatsheet-sh-L32\\" class=\\"blob-num js-line-number js-code-nav-line-number js-blob-rnum\\" data-line-number=\\"32\\"></td>\\n          <td id=\\"file-git-cheatsheet-sh-LC32\\" class=\\"blob-code blob-code-inner js-file-line\\">git update-index --no-assume-unchanged <span class=\\"pl-k\\">&lt;</span>file<span class=\\"pl-k\\">&gt;</span></td>\\n        </tr>\\n        <tr>\\n          <td id=\\"file-git-cheatsheet-sh-L33\\" class=\\"blob-num js-line-number js-code-nav-line-number js-blob-rnum\\" data-line-number=\\"33\\"></td>\\n          <td id=\\"file-git-cheatsheet-sh-LC33\\" class=\\"blob-code blob-code-inner js-file-line\\">\\n</td>\\n        </tr>\\n        <tr>\\n          <td id=\\"file-git-cheatsheet-sh-L34\\" class=\\"blob-num js-line-number js-code-nav-line-number js-blob-rnum\\" data-line-number=\\"34\\"></td>\\n          <td id=\\"file-git-cheatsheet-sh-LC34\\" class=\\"blob-code blob-code-inner js-file-line\\"><span class=\\"pl-c\\"><span class=\\"pl-c\\">#</span> List all &quot;assume-unchanged&quot; files</span></td>\\n        </tr>\\n        <tr>\\n          <td id=\\"file-git-cheatsheet-sh-L35\\" class=\\"blob-num js-line-number js-code-nav-line-number js-blob-rnum\\" data-line-number=\\"35\\"></td>\\n          <td id=\\"file-git-cheatsheet-sh-LC35\\" class=\\"blob-code blob-code-inner js-file-line\\">git ls-files -v<span class=\\"pl-k\\">|</span>grep <span class=\\"pl-s\\"><span class=\\"pl-pds\\">&#39;</span>^h<span class=\\"pl-pds\\">&#39;</span></span></td>\\n        </tr>\\n        <tr>\\n          <td id=\\"file-git-cheatsheet-sh-L36\\" class=\\"blob-num js-line-number js-code-nav-line-number js-blob-rnum\\" data-line-number=\\"36\\"></td>\\n          <td id=\\"file-git-cheatsheet-sh-LC36\\" class=\\"blob-code blob-code-inner js-file-line\\">\\n</td>\\n        </tr>\\n        <tr>\\n          <td id=\\"file-git-cheatsheet-sh-L37\\" class=\\"blob-num js-line-number js-code-nav-line-number js-blob-rnum\\" data-line-number=\\"37\\"></td>\\n          <td id=\\"file-git-cheatsheet-sh-LC37\\" class=\\"blob-code blob-code-inner js-file-line\\"><span class=\\"pl-c\\"><span class=\\"pl-c\\">#</span> Display who did the latest change in each line (ignoring whitespaces)</span></td>\\n        </tr>\\n        <tr>\\n          <td id=\\"file-git-cheatsheet-sh-L38\\" class=\\"blob-num js-line-number js-code-nav-line-number js-blob-rnum\\" data-line-number=\\"38\\"></td>\\n          <td id=\\"file-git-cheatsheet-sh-LC38\\" class=\\"blob-code blob-code-inner js-file-line\\">git blame <span class=\\"pl-k\\">&lt;</span>filename<span class=\\"pl-k\\">&gt;</span> -w</td>\\n        </tr>\\n        <tr>\\n          <td id=\\"file-git-cheatsheet-sh-L39\\" class=\\"blob-num js-line-number js-code-nav-line-number js-blob-rnum\\" data-line-number=\\"39\\"></td>\\n          <td id=\\"file-git-cheatsheet-sh-LC39\\" class=\\"blob-code blob-code-inner js-file-line\\">\\n</td>\\n        </tr>\\n        <tr>\\n          <td id=\\"file-git-cheatsheet-sh-L40\\" class=\\"blob-num js-line-number js-code-nav-line-number js-blob-rnum\\" data-line-number=\\"40\\"></td>\\n          <td id=\\"file-git-cheatsheet-sh-LC40\\" class=\\"blob-code blob-code-inner js-file-line\\"><span class=\\"pl-c\\"><span class=\\"pl-c\\">#</span> Remove all local branches removed in remote</span></td>\\n        </tr>\\n        <tr>\\n          <td id=\\"file-git-cheatsheet-sh-L41\\" class=\\"blob-num js-line-number js-code-nav-line-number js-blob-rnum\\" data-line-number=\\"41\\"></td>\\n          <td id=\\"file-git-cheatsheet-sh-LC41\\" class=\\"blob-code blob-code-inner js-file-line\\">git fetch origin --prune</td>\\n        </tr>\\n        <tr>\\n          <td id=\\"file-git-cheatsheet-sh-L42\\" class=\\"blob-num js-line-number js-code-nav-line-number js-blob-rnum\\" data-line-number=\\"42\\"></td>\\n          <td id=\\"file-git-cheatsheet-sh-LC42\\" class=\\"blob-code blob-code-inner js-file-line\\">\\n</td>\\n        </tr>\\n        <tr>\\n          <td id=\\"file-git-cheatsheet-sh-L43\\" class=\\"blob-num js-line-number js-code-nav-line-number js-blob-rnum\\" data-line-number=\\"43\\"></td>\\n          <td id=\\"file-git-cheatsheet-sh-LC43\\" class=\\"blob-code blob-code-inner js-file-line\\"><span class=\\"pl-c\\"><span class=\\"pl-c\\">#</span> Remove untracked local files</span></td>\\n        </tr>\\n        <tr>\\n          <td id=\\"file-git-cheatsheet-sh-L44\\" class=\\"blob-num js-line-number js-code-nav-line-number js-blob-rnum\\" data-line-number=\\"44\\"></td>\\n          <td id=\\"file-git-cheatsheet-sh-LC44\\" class=\\"blob-code blob-code-inner js-file-line\\">git clean -f</td>\\n        </tr>\\n        <tr>\\n          <td id=\\"file-git-cheatsheet-sh-L45\\" class=\\"blob-num js-line-number js-code-nav-line-number js-blob-rnum\\" data-line-number=\\"45\\"></td>\\n          <td id=\\"file-git-cheatsheet-sh-LC45\\" class=\\"blob-code blob-code-inner js-file-line\\">\\n</td>\\n        </tr>\\n        <tr>\\n          <td id=\\"file-git-cheatsheet-sh-L46\\" class=\\"blob-num js-line-number js-code-nav-line-number js-blob-rnum\\" data-line-number=\\"46\\"></td>\\n          <td id=\\"file-git-cheatsheet-sh-LC46\\" class=\\"blob-code blob-code-inner js-file-line\\"><span class=\\"pl-c\\"><span class=\\"pl-c\\">#</span> Remove untracked local files and folders</span></td>\\n        </tr>\\n        <tr>\\n          <td id=\\"file-git-cheatsheet-sh-L47\\" class=\\"blob-num js-line-number js-code-nav-line-number js-blob-rnum\\" data-line-number=\\"47\\"></td>\\n          <td id=\\"file-git-cheatsheet-sh-LC47\\" class=\\"blob-code blob-code-inner js-file-line\\">git clean -fd</td>\\n        </tr>\\n        <tr>\\n          <td id=\\"file-git-cheatsheet-sh-L48\\" class=\\"blob-num js-line-number js-code-nav-line-number js-blob-rnum\\" data-line-number=\\"48\\"></td>\\n          <td id=\\"file-git-cheatsheet-sh-LC48\\" class=\\"blob-code blob-code-inner js-file-line\\">\\n</td>\\n        </tr>\\n        <tr>\\n          <td id=\\"file-git-cheatsheet-sh-L49\\" class=\\"blob-num js-line-number js-code-nav-line-number js-blob-rnum\\" data-line-number=\\"49\\"></td>\\n          <td id=\\"file-git-cheatsheet-sh-LC49\\" class=\\"blob-code blob-code-inner js-file-line\\"><span class=\\"pl-c\\"><span class=\\"pl-c\\">#</span> Remove remote branch</span></td>\\n        </tr>\\n        <tr>\\n          <td id=\\"file-git-cheatsheet-sh-L50\\" class=\\"blob-num js-line-number js-code-nav-line-number js-blob-rnum\\" data-line-number=\\"50\\"></td>\\n          <td id=\\"file-git-cheatsheet-sh-LC50\\" class=\\"blob-code blob-code-inner js-file-line\\">git push <span class=\\"pl-k\\">&lt;</span>remote<span class=\\"pl-k\\">&gt;</span> --delete <span class=\\"pl-k\\">&lt;</span>branch<span class=\\"pl-k\\">&gt;</span></td>\\n        </tr>\\n        <tr>\\n          <td id=\\"file-git-cheatsheet-sh-L51\\" class=\\"blob-num js-line-number js-code-nav-line-number js-blob-rnum\\" data-line-number=\\"51\\"></td>\\n          <td id=\\"file-git-cheatsheet-sh-LC51\\" class=\\"blob-code blob-code-inner js-file-line\\">\\n</td>\\n        </tr>\\n        <tr>\\n          <td id=\\"file-git-cheatsheet-sh-L52\\" class=\\"blob-num js-line-number js-code-nav-line-number js-blob-rnum\\" data-line-number=\\"52\\"></td>\\n          <td id=\\"file-git-cheatsheet-sh-LC52\\" class=\\"blob-code blob-code-inner js-file-line\\"><span class=\\"pl-c\\"><span class=\\"pl-c\\">#</span> Go to an old commit</span></td>\\n        </tr>\\n        <tr>\\n          <td id=\\"file-git-cheatsheet-sh-L53\\" class=\\"blob-num js-line-number js-code-nav-line-number js-blob-rnum\\" data-line-number=\\"53\\"></td>\\n          <td id=\\"file-git-cheatsheet-sh-LC53\\" class=\\"blob-code blob-code-inner js-file-line\\">git read-tree <span class=\\"pl-k\\">&lt;</span>commit<span class=\\"pl-k\\">&gt;</span></td>\\n        </tr>\\n        <tr>\\n          <td id=\\"file-git-cheatsheet-sh-L54\\" class=\\"blob-num js-line-number js-code-nav-line-number js-blob-rnum\\" data-line-number=\\"54\\"></td>\\n          <td id=\\"file-git-cheatsheet-sh-LC54\\" class=\\"blob-code blob-code-inner js-file-line\\">\\n</td>\\n        </tr>\\n        <tr>\\n          <td id=\\"file-git-cheatsheet-sh-L55\\" class=\\"blob-num js-line-number js-code-nav-line-number js-blob-rnum\\" data-line-number=\\"55\\"></td>\\n          <td id=\\"file-git-cheatsheet-sh-LC55\\" class=\\"blob-code blob-code-inner js-file-line\\"><span class=\\"pl-c\\"><span class=\\"pl-c\\">#</span> Use the ~/.gitignore file to ignore globally certain files</span></td>\\n        </tr>\\n        <tr>\\n          <td id=\\"file-git-cheatsheet-sh-L56\\" class=\\"blob-num js-line-number js-code-nav-line-number js-blob-rnum\\" data-line-number=\\"56\\"></td>\\n          <td id=\\"file-git-cheatsheet-sh-LC56\\" class=\\"blob-code blob-code-inner js-file-line\\">git config --global core.excludesfile <span class=\\"pl-s\\"><span class=\\"pl-pds\\">&#39;</span>~/.gitignore<span class=\\"pl-pds\\">&#39;</span></span></td>\\n        </tr>\\n  </table>\\n</div>\\n\\n\\n    </div>\\n\\n  </div>\\n</div>\\n\\n      </div>\\n      <div class=\\"gist-meta\\">\\n        <a href=\\"https://gist.github.com/oscarotero/7749998/raw/0ea827d8ec07706f290f9e157706251cdc25894a/Git-cheatsheet.sh\\" style=\\"float:right\\" class=\\"Link--inTextBlock\\">view raw</a>\\n        <a href=\\"https://gist.github.com/oscarotero/7749998#file-git-cheatsheet-sh\\" class=\\"Link--inTextBlock\\">\\n          Git-cheatsheet.sh\\n        </a>\\n        hosted with &#10084; by <a class=\\"Link--inTextBlock\\" href=\\"https://github.com\\">GitHub</a>\\n      </div>\\n    </div>\\n</div>\\n","stylesheet":"https://github.githubassets.com/assets/gist-embed-8c1a5bab9782.css"}'
];
