<?php
declare(strict_types = 1);

return [
    'headers' => [
        'date' => [
            'Mon, 10 Jun 2024 15:58:49 GMT',
            'Mon, 10 Jun 2024 15:58:49 GMT'
        ],
        'content-type' => [
            'text/html',
            'text/html; charset=utf-8'
        ],
        'transfer-encoding' => [
            'chunked'
        ],
        'connection' => [
            'keep-alive'
        ],
        'location' => [
            'https://jsfiddle.net/zhm5rjnz/'
        ],
        'vary' => [
            'Origin',
            'Accept, Origin'
        ],
        'cf-cache-status' => [
            'DYNAMIC',
            'DYNAMIC'
        ],
        'report-to' => [
            '{"endpoints":[{"url":"https:\\/\\/a.nel.cloudflare.com\\/report\\/v4?s=smYyWClKo8oEfoqwDtz8RbGTzhdwJhBGoEkAVlJHdwoC0%2FRViIXnRBhn5D0x52YeiXtynn8ns9ymj8MLjvuZoiY3Lrxkhbu97ahRBAlOsD%2FFi4240JJlZQqecO9KbZA%3D"}],"group":"cf-nel","max_age":604800}',
            '{"endpoints":[{"url":"https:\\/\\/a.nel.cloudflare.com\\/report\\/v4?s=ZQf9%2BcXUhP%2B8TWx3CzDToVxYO%2FXMrXTmrublBYml0mvl0UT3EM1rhxBT3bS1hQXwqEMrBm9cQnBa1MOTfjwmcgckWlBrCp%2BJePlRFK5Rj0cOcOsZy7jIVb4aa085SIs%3D"}],"group":"cf-nel","max_age":604800}'
        ],
        'nel' => [
            '{"success_fraction":0,"report_to":"cf-nel","max_age":604800}',
            '{"success_fraction":0,"report_to":"cf-nel","max_age":604800}'
        ],
        'server' => [
            'cloudflare',
            'cloudflare'
        ],
        'cf-ray' => [
            '891a90a40bba86bc-MAD',
            '891a90a5cc6c3c9e-CDG'
        ],
        'alt-svc' => [
            'h2=":443"; ma=60  HTTP/2 200',
            'h3=":443"; ma=86400'
        ],
        'x-frame-options' => [
            'SAMEORIGIN'
        ],
        'x-xss-protection' => [
            '1; mode=block'
        ],
        'x-content-type-options' => [
            'nosniff'
        ],
        'x-download-options' => [
            'noopen'
        ],
        'x-permitted-cross-domain-policies' => [
            'none'
        ],
        'referrer-policy' => [
            'strict-origin-when-cross-origin'
        ],
        'cache-control' => [
            'max-age=0, private, must-revalidate'
        ],
        'set-cookie' => [
            'csrftoken=h4BPAI4qgmfUF5gMylwoRYfVu5rDEId4mnPcY%2FK9FAtqwZFjzPaznl2TXMBtUAb%2Ffdr3iK%2BXVM8DdORXVZzjQg%3D%3D; path=/; secure',
            '_jsfiddle_session=FXaU2Fprh8TikhvBBkj2dLNXPwisA6kV78LzTrq1okZqd5sH9dGoCa%2B8DhDyBT%2FWYMr7wU4voNDiCgTBtZbHcmQ9r0HVW4BSRZu38cs3GzSD6W5m6aXZjPuli4yo9ofFkV2%2FQGdYXu9wCUnUyEKMY%2B1kYZeU9Kc8kHsXG822wE9Mw4fkU9%2Fo1bw3iQKsYv5EkPIYzUw%2BCUZRfmjmPW264UxjpulsZSLkFm0cvnnwx4VvefRLha4Caqowwcdi6RA%2FoEzHFnFnv78k6QbWpyckrV46uZRaSK%2FLBw%3D%3D--BjzsN4nNb%2Bm2%2F7z%2F--z0EI3ySac%2BbWtHrbwc5UXQ%3D%3D; path=/; secure; HttpOnly'
        ],
        'x-request-id' => [
            '867cb413-f961-4762-9a75-3cf0de52f509'
        ],
        'x-runtime' => [
            '0.092817'
        ],
        'strict-transport-security' => [
            'max-age=63072000; includeSubDomains'
        ],
        'content-encoding' => [
            'br'
        ],
        'Content-Location' => [
            'https://jsfiddle.net/zhm5rjnz/'
        ],
        'X-Request-Time' => [
            '0.635 ms'
        ]
    ],
    'statusCode' => 200,
    'reasonPhrase' => 'OK',
    'body' => '<!DOCTYPE html>
<html>
  <head>
    <meta charset="utf-8">
    <meta name="description" content="Test your JavaScript, CSS, HTML or CoffeeScript online with JSFiddle code editor.">
    <meta name="keywords" content="online javascript editor, testing javascript online, online ide, online code editor, html, css, coffeescript, scss online editor">
    <meta name="author" content="JSFiddle">
    <meta name="copyright" content="share alike">

      <meta name="robots" content="index, follow">
      <meta name="googlebot" content="index, follow">

    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-touch-fullscreen" content="yes">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="theme-color" content="#1a1d21">

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100..900&display=swap" rel="stylesheet">

    
<!-- Google tag (gtag.js) -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-DG76L8EKG3"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function analytics_jsf(){dataLayer.push(arguments);}
  analytics_jsf("js", new Date());
  analytics_jsf("config", "G-DG76L8EKG3", {
    page_path:     "/[fiddle]/",
    cookie_prefix: "jsfiddle",
    
  })
</script>


    <script>
      Track = {
        ui: function(action){
          if (typeof(analytics_jsf) === "function"){
            analytics_jsf("event", "ui_event", {
              "event_action": action || null
            })
          }
        }
      }

      var EditorConfig = {
        shell: true,
        paths: {
          favorite:         "/_make_favourite/",
          media:            "/mooshellmedia/",
          addResource:      "/_add_external_resource/",
          render:           "//fiddle.jshell.net/zhm5rjnz/show/?editor_console=",
          saveSettings:     "/_editor_options/",
          fork:             "/_fork/",
          save:             "/_save/",
          update:           "/_update/zhm5rjnz/",
          loadDependencies: "/_get_dependencies/{lib_id}/",
          showProfile:      "/_show_profile/"
        },
        value: {
          html: "",
          js:   "var processForm = function (data) {\\n    if (data.error) {\\n        console.log(\\\'got error\\\');\\n    }\\n\\n    console.log(\\\'got data\\\');\\n};\\n\\n\\$.ajax({\\n    url: url\\n})\\n.success(function (data) {\\n        processForm(data);\\n})\\n.fail(function (response, error, status) {\\n    var errorMessage;\\n\\n    try {\\n        errorMessage = JSON.parse(response.responseText);\\n    } catch (e) {\\n        errorMessage = response.responseText;\\n    }\\n\\n    if (typeof errorMessage === \\\'object\\\') {\\n        processForm(errorMessage);\\n    } else {\\n        throw new Error(errorMessage);\\n    }\\n});",
          css:  ""
        },
        fiddle: {
          version: "0",
          slug: "zhm5rjnz",
          boilerplate: false
        },
        panels: {
          html: "html",
          js:   "javascript",
          css:  "css"
        },
        user: {
          id:       "None",
          username: ""
        },
        currentUser:  false,
        isAuthor:     false,
        features: {
          toggleSidebar: false
        }
      }

      // translations
      const I18n = {
        editor: {
          panels: {
            result: "Result",
            drag_to_reorder: "Drag tabs to reorder",
            tidy: "Tidy"
          },
          sidebar: {
            toggle_sidebar: "Toggle sidebar"
          },
          groups: {
            placeholder_value:        "Assign to groups",
            search_placeholder_value: "Search for groups",
            no_choices_text:          "No more groups",
            no_results_text:          "No groups found",
            item_select_text:         "Press to select",
            you_have_no_groups:       "You have no groups"
          }
        }
      }

        const EditorUISettings = {
          // options that user can change
          layout:            1,
          darkTheme:         true,
          tabSize:           2,
          matchBrackets:     true,
          lineNumbers:       true,
          lineWrapping:      true,
          keyMap:            "default",
          autoCloseTags:     true,
          autoCloseBrackets: true,
          indentWithTabs:    false,
          codeLinting:       true,
          autoRun:           EditorConfig.currentUser ? false : false,
          autoRunValid:      EditorConfig.currentUser ? true : false,
          autoSave:          EditorConfig.currentUser ? true : false,
          clearConsole:      false,
          fontSize:          1,
          matchTags:         false,
          foldGutter:        true,
          codeHints:         true,
          editorConsole:     true
        }
    </script>

    <style id=\'skeleton-theme-inline\'>a{color:#222;text-decoration:none}a:hover{text-decoration:underline}input,select,textarea{font-family:"Inter",-apple-system,BlinkMacSystemFont,"Helvetica Neue",Arial,sans-serif,"Apple Color Emoji","Segoe UI Emoji","Segoe UI Symbol"}select{cursor:pointer}blockquote,body,dd,div,dl,dt,fieldset,form,h1,h2,h3,h4,h5,h6,input,li,ol,p,pre,td,textarea,th,ul{margin:0;padding:0}table{border-collapse:collapse;border-spacing:0}fieldset,img{border:0}address,caption,cite,code,dfn,em,strong,th,var{font-style:normal;font-weight:normal}ol,ul{list-style:none}caption,th{text-align:left}h1,h2,h3,h4,h5,h6{font-size:100%;font-weight:normal}abbr,acronym{border:0}::-webkit-input-placeholder{color:#8e8e8f}:-moz-placeholder,::-moz-placeholder{color:#8e8e8f}:-ms-input-placeholder{color:#8e8e8f}.icon{stroke:inherit}a:active,a:focus,button::-moz-focus-inner,button:focus,input[type=button]::-moz-focus-inner,input[type=file]>input[type=button]::-moz-focus-inner,input[type=reset]::-moz-focus-inner,input[type=submit]::-moz-focus-inner,select::-moz-focus-inner{outline:none!important}select:-moz-focusring{color:transparent;text-shadow:0 0 0 #000}.checkboxCont{cursor:pointer}.checkboxCont .checkbox{position:relative;background:rgba(0,0,0,.1);display:inline-block;vertical-align:middle;border-radius:14px;width:24px;height:14px;margin-right:5px;top:-2px;transition:all .15s}.checkboxCont .checkbox:after{content:"";border-radius:12px;position:absolute;top:1px;left:1px;width:12px;height:12px;background:#fff;display:block;transition:left .15s;box-shadow:0 2px 4px 0 rgba(0,0,0,.2),0 0 1px 0 rgba(0,0,0,.21)}.checkboxCont input[type=checkbox]{display:none}.checkboxCont input[type=checkbox]:checked+.checkbox{background:#3a6cff}.checkboxCont input[type=checkbox]:checked+.checkbox:after{left:11px}.checkboxCont input[type=checkbox]:disabled+.checkbox{background:rgba(0,0,0,.1)}.checkboxCont input[type=checkbox]:disabled+.checkbox:after{opacity:.5}.checkboxCont small{color:rgba(0,0,0,.3);font-size:inherit}.proBadgeSelf{display:none}.proBadge .proBadgeSelf{display:inline-block;background:#ffb82e;color:#1b1c1e;padding:0 3px;height:13px;border-radius:2px;line-height:13px;font-size:9px;font-weight:bold;overflow:hidden;position:relative;bottom:-2px;left:3px;text-transform:uppercase}.proBadge .proBadgeSelf:hover{text-decoration:none;background:#ffd27b}#sidebar .proBadgeSelf{color:#1b1c1e}.groupsList{overflow:auto;max-height:150px;margin-top:10px}.groupsList .privateGroup{height:10px;display:inline-block;padding:2px;border-radius:2px;background:inherit;vertical-align:bottom}.groupsList .privateGroup g{stroke:#8e8e8f}.groupsList li{margin-bottom:5px}.groupsList li input,.groupsList li span{display:inline-block}.groupsList li span{color:inherit;max-width:140px;text-overflow:ellipsis;overflow:hidden;white-space:nowrap;vertical-align:bottom;margin-left:5px}.groupsList label{font-size:13px;cursor:pointer}[data-tooltip]{position:relative;cursor:help}[data-tooltip]:after{position:absolute;opacity:0;pointer-events:none;content:attr(data-tooltip);right:0;top:calc(100% + 10px);border-radius:6px;background-color:#fff;z-index:10;padding:8px;width:300px;color:#222;transition:opacity .1s}[data-tooltip]:hover:after{opacity:1}a{outline:none}body{font-family:"Inter",-apple-system,BlinkMacSystemFont,"Helvetica Neue",Arial,sans-serif,"Apple Color Emoji","Segoe UI Emoji","Segoe UI Symbol";background:#202123;padding:0;margin:0;font-size:14px;color:#222;font-optical-sizing:auto;font-variation-settings:"slnt" 0}#progressbar{height:3px;position:absolute;top:60px;left:0;right:0;z-index:110;pointer-events:none}#show-result header,#user-page header{height:60px;background:#1b1c1e;box-shadow:0 0 5px rgba(27,28,30,0);z-index:100;width:100vw}#show-result header .title,#user-page header .title{position:absolute;top:-9000em}#show-result header h1,#user-page header h1{position:absolute;top:14px;left:10px;z-index:800;transition:all .15s}#show-result header h1 a,#user-page header h1 a{display:block}#show-result header h1 svg,#user-page header h1 svg{transition:all .15s;position:relative;height:33px;width:46px;stroke:#3a6cff}#app-updates{float:left;position:relative;width:20px}#app-updates .bodyCont{opacity:1;transition:all .1s;transform:translateY(0);margin-left:10px;overflow:hidden;height:60px;width:300px}#app-updates .body{color:#fbfbfb;transition:all .1s;background:transparent;padding:14px;border-radius:3px;line-height:1.45em;font-size:13px;position:relative;top:6px;width:300px}#app-updates .body code{background:#e9e9e9;padding:2px 3px;border-radius:5px;font-size:11px}#app-updates strong{font-weight:700}#app-updates h3{text-overflow:ellipsis;width:100%;white-space:nowrap;overflow:hidden}#app-updates p{margin-top:10px}#app-updates p a{font-weight:700}#app-updates .updateActions,#app-updates p{pointer-events:none;opacity:0}#app-updates .updateActions{margin-top:12px;text-align:right}#app-updates .updateActions a{color:#8e8e8f;font-size:12px;padding:3px 6px;border:1px solid transparent;border-radius:4px}#app-updates .updateActions a:hover{border:1px solid hsla(240,0%,56%,.2);text-decoration:none}#app-updates .badge{background:#26aa5a;color:#fff;font-size:11px;padding:3px 6px;border-radius:3px;margin-right:5px;font-weight:400}#app-updates.hidden .bodyCont,#app-updates:hover .bodyCont{overflow:visible}#app-updates.hidden .body,#app-updates:hover .body{background:#fff;color:#222;box-shadow:0 0 1px rgba(34,34,34,.15),0 20px 55px -8px rgba(34,34,34,.25)}#app-updates.hidden h3,#app-updates:hover h3{text-overflow:inherit;white-space:normal;overflow:auto;font-weight:700}#app-updates.hidden .updateActions,#app-updates.hidden p,#app-updates:hover .updateActions,#app-updates:hover p{pointer-events:auto;opacity:1}#app-updates.hidden{transform:translateY(20px)}#app-updates-highlighter,#app-updates.hidden,#app-updates.hidden .updateActions,#app-updates.hidden p{pointer-events:none;opacity:0}#app-updates-highlighter{position:absolute;border:3px solid #26aa5a;border-radius:5px;transition:all .1s;transform:scale(1.05);z-index:1000}#app-updates-highlighter.show{opacity:1;transform:scale(1)}#layout-container{position:relative;display:grid;grid-template-columns:210px 1fr;grid-template-areas:"sidebar content"}#show-result{height:100vh}#modal-body{pointer-events:none;background-color:hsla(0,0%,7%,0)}#modal-body #modal-app{opacity:0;pointer-events:none}#content{grid-area:content;position:relative}#content #toggle-sidebar{position:absolute;left:-10px;top:calc(100vh - 110px);width:15px;height:40px;background:#1b1c1e;border:1px solid #2d2e30;z-index:100;border-radius:2px;display:flex;justify-content:center}#content #toggle-sidebar svg{height:inherit;width:inherit}#content #toggle-sidebar g{stroke:#636465}#content #toggle-sidebar:hover{border:1px solid #3a6cff}#content #toggle-sidebar:hover g{stroke:#e9e9e9}#content #toggle-sidebar:hover:after{content:attr(data-title);display:block;background:#3a6cff;color:#fff;border-radius:3px;padding:4px 8px;position:absolute;top:calc(50% - 11px);left:22px;z-index:20;white-space:nowrap}#sidebar{grid-area:sidebar;padding:0;margin:0;font-size:12px;border-right:1px solid #2d2e30;background:#202123;display:flex;flex-direction:column;color:#cfcfd0;box-shadow:0 0 0 rgba(0,0,0,.5);position:relative}#sidebar #s-cont{flex-grow:1;opacity:0;pointer-events:none}#sidebar #profile-segment{padding:20px 10px;border-bottom:1px solid #2d2e30}#sidebar #profile-segment.hidden{display:none}#sidebar .userSidebar .userProfile{display:grid;font-size:14px;grid-template-columns:45px 1fr;grid-column-gap:12px}#sidebar .userSidebar .userProfile .profileDetails{display:flex;flex-direction:column;justify-content:center}#sidebar .userSidebar .userProfile .avatar{position:relative}#sidebar .userSidebar .userProfile a{color:#fbfbfb;display:block;font-weight:700}#sidebar .userSidebar .userProfile img{overflow:hidden;border-radius:4px;box-shadow:0 0 0 1px #1b1c1e,0 0 0 3px #e9e9e9;position:relative;top:1px;left:1px}#sidebar .userSidebar .userProfile .company{font-weight:400;margin-top:4px;color:#8e8e8f;font-size:12px;margin-bottom:10px}#sidebar .userSidebar .userProfile .socialInfo{display:flex;column-gap:4px}#sidebar .userSidebar .userProfile .socialInfo li:not(.more){display:block}#sidebar .userSidebar .userProfile .socialInfo li:not(.more).hidden{display:none}#sidebar .userSidebar .userProfile .socialInfo:hover li.hidden{display:block}#sidebar .userSidebar .userProfile .socialInfo:hover li.more{display:none}#sidebar .userSidebar .userProfile .socialInfo svg{height:13px;width:17px;opacity:.4}#sidebar .userSidebar .userProfile .socialInfo a{display:block;border-radius:3px}#sidebar .userSidebar .userProfile .socialInfo a:hover svg{opacity:1}#sidebar .userSidebar .userDetails{clear:both;padding-top:6px;color:#fbfbfb}#sidebar .userSidebar .userDetails a{color:#fbfbfb}#sidebar .userSidebar .userDetails li{margin-top:3px}#sidebar .userSidebar.proProfile .userProfile img,#sidebar .userSidebar.teamProfile .userProfile img{box-shadow:0 0 0 1px #1b1c1e,0 0 0 3px #ffb82e}#sidebar .userSidebar.proProfile .avatar:after,#sidebar .userSidebar.teamProfile .avatar:after{content:"Supporter";display:inline-block;background:#ffb82e;color:#1b1c1e;padding:0 2px;height:13px;border-radius:2px;line-height:13px;font-size:9px;font-weight:bold;overflow:hidden;position:absolute;top:37px;left:-2px;width:47px;pointer-events:none;text-align:center}#sidebar .userSidebar.teamProfile .userProfile img{box-shadow:0 0 0 1px #1b1c1e,0 0 0 3px #fa777c}#sidebar .userSidebar.teamProfile .avatar:after{content:"TEAM";background:#fa777c}#sidebar .userSidebar.segment{margin:0 20px}#sidebar .userSidebar.body{position:relative;top:4px}#actions{height:60px;font-size:13px;position:relative;z-index:300;margin-left:70px;opacity:0;pointer-events:none;display:grid;grid-template-columns:auto auto}#actions svg{position:relative;height:16px;left:-1px}#actions svg.rightIcon{margin-right:0;margin-left:6px}#actions .actionCont{display:flex}#actions .right{justify-content:flex-end;padding-right:10px}#actions .actionItem{position:relative;margin-right:1px}#actions .actionItem.visible{display:block}#actions .actionItem.hidden{display:none}#actions .actionItem .aiButton,#actions .actionItem .aiButton span,#actions .dropdown .actionItem a.aiButton{height:60px}#actions .actionItem a.aiButton{display:flex;outline:none;text-decoration:none;padding:0 7px;align-items:center;justify-content:center;color:#fbfbfb;position:relative}#actions .actionItem a.aiButton:after{content:"";display:block;width:100%;background:#3a6cff;height:3px;bottom:-1px;left:0;position:absolute;pointer-events:none;border-radius:3px;opacity:0;transition:all .15s;transform:scale(.95)}#actions .actionItem a.aiButton.selected:after,#actions .actionItem a.aiButton:hover:after{opacity:1;transform:scale(1)}#actions .actionItem a.aiButton.disabled{opacity:.3;pointer-events:none}#actions img{overflow:hidden;border-radius:3px;box-shadow:0 0 0 1px #1b1c1e,0 0 0 2px #e9e9e9}#actions img.proProfile{box-shadow:0 0 0 1px #1b1c1e,0 0 0 2px #ffb82e}#actions img.teamProfile{box-shadow:0 0 0 1px #1b1c1e,0 0 0 2px #fa777c}#actions .actionItem a.aiButton span{font-size:.9em}#actions .noIcon a.aiButton span{padding:0 0 0 6px;margin-right:0}#actions .actionItem #mobile.aiButton span{margin-right:0}#actions .actionItem a.aiButton span.selected{color:#555;background:#fff}#actions .dropdown .dropdownCont li{line-height:26px}.dropdownCont{position:absolute;z-index:9000;opacity:1;transform:translateY(0);transition:opacity .12s,transform .12s;will-change:opacity,transform}.dropdownCont .dcWrapper{background-color:#fff;width:300px;padding:15px;margin:0;font-size:13px;box-shadow:0 0 1px rgba(34,34,34,.15),0 20px 55px -8px rgba(34,34,34,.25);border-radius:5px;max-height:calc(100vh - 100px);overflow:auto}.dropdownCont .dcWrapper.menu{width:200px;padding:12px 0}.dropdownCont .dcWrapper.menu li{line-height:22px;padding:0 15px 6px}.dropdownCont .dcWrapper.menu li a{color:#222;position:relative}.dropdownCont .dcWrapper.menu li.other{border-top:1px solid #e9e9e9;padding:6px 15px 0}.dropdownCont .dcWrapper.menu li.other+.other{border-top:none}.dropdownCont .dcWrapper.menu li.other a{color:#8e8e8f}.dropdownCont .dcWrapper:before{top:-11px;border-bottom:10px solid rgba(34,34,34,.15)}.dropdownCont .dcWrapper:after,.dropdownCont .dcWrapper:before{display:block;position:absolute;right:20px;vertical-align:middle;content:"";border-left:8px solid transparent;border-right:8px solid transparent;border-style:none double solid;width:0;height:0}.dropdownCont .dcWrapper:after{top:-10px;border-bottom:10px solid #fff}.dropdownCont.center .dcWrapper:after,.dropdownCont.center .dcWrapper:before{left:50%;margin-left:-4px}.dropdownCont.hidden{opacity:0;transform:translateY(10px);pointer-events:none}.twitterCont{display:block;border-top:1px solid #2d2e30;background:#1b1c1e}.twitterCont img{width:100%;display:block}#sidebar #fallback{color:#fff;border-top:1px solid #2d2e30;background:#1b1c1e;position:absolute;bottom:-20px;left:0;right:0;opacity:0;pointer-events:none;transition:all .15s}#sidebar #fallback a:hover{text-decoration:none}#sidebar #fallback h3{font-size:13px;line-height:19px;color:#fbfbfb;padding:25px 12px 12px;font-weight:400}#sidebar #fallback img{width:100%;display:block}#sidebar #fallback.show{bottom:0;left:0;right:0;opacity:1;pointer-events:auto}#sidebar #fallback:before{content:"ADS BY JSFIDDLE";font-size:8px;letter-spacing:1px;position:absolute;top:0;right:0;color:#8e8e8f;border:1px solid #2d2e30;border-top:0;border-right:0;padding:3px 6px;border-bottom-left-radius:6px}#sidebar #carbonads,#sidebar #ethical-sponsor{position:relative}#sidebar #carbonads .carbon-wrap,#sidebar #carbonads .ea-content,#sidebar #ethical-sponsor .carbon-wrap,#sidebar #ethical-sponsor .ea-content{margin:0;padding:0;max-width:209px;display:grid;grid-template-areas:"desc" "img"}#sidebar #carbonads .carbon-img,#sidebar #carbonads .ea-content>a,#sidebar #ethical-sponsor .carbon-img,#sidebar #ethical-sponsor .ea-content>a{width:100%;display:block;grid-area:img}#sidebar #carbonads .carbon-img img,#sidebar #carbonads .ea-content>a img,#sidebar #ethical-sponsor .carbon-img img,#sidebar #ethical-sponsor .ea-content>a img{display:block;width:209px;max-width:209px;min-width:209px;height:150px}#sidebar #carbonads .carbon-text,#sidebar #carbonads .ea-text,#sidebar #ethical-sponsor .carbon-text,#sidebar #ethical-sponsor .ea-text{grid-area:desc;clear:both;display:block;font-size:12px;line-height:19px;color:#fbfbfb;padding:29px 12px 12px;font-weight:400;margin-top:0;text-align:left}#sidebar #carbonads a,#sidebar #ethical-sponsor a{color:inherit}#sidebar #carbonads a:hover,#sidebar #ethical-sponsor a:hover{text-decoration:none}#sidebar #carbonads .ea-cta,#sidebar #carbonads .ea-headline,#sidebar #ethical-sponsor .ea-cta,#sidebar #ethical-sponsor .ea-headline{display:block;font-weight:700;color:inherit}#sidebar #carbonads .carbon-poweredby,#sidebar #carbonads .ea-callout,#sidebar #ethical-sponsor .carbon-poweredby,#sidebar #ethical-sponsor .ea-callout{font-size:8px;letter-spacing:1px;position:absolute;top:0;right:0;color:#8e8e8f;border:1px solid #2d2e30;border-top:0;border-right:0;padding:3px 6px;border-bottom-left-radius:6px;text-transform:uppercase;margin:0;font-style:normal}#sidebar #carbonads .carbon-poweredby a,#sidebar #carbonads .ea-callout a,#sidebar #ethical-sponsor .carbon-poweredby a,#sidebar #ethical-sponsor .ea-callout a{font-size:8px}#boilerplates{position:absolute;top:0;bottom:0;left:0;right:0;display:flex;flex-direction:column;align-items:center;justify-content:center}#boilerplates h3{color:#fbfbfb;margin-bottom:30px;font-size:14px;font-weight:600}#boilerplates ul.boilerplates{text-align:center;width:80%}#boilerplates ul.boilerplates li{margin:0 6px 15px 0;display:inline-flex}#boilerplates ul.boilerplates a{display:block;padding:6px 8px;border-radius:10px;background:#fff;color:#222;font-size:12px;font-weight:500}#boilerplates ul.boilerplates a:hover{text-decoration:none;background:#3a6cff;color:#fff}body.fullyLoaded #actions,body.fullyLoaded #sidebar #s-cont{opacity:1;pointer-events:auto}body.hiddenSidebar #layout-container{grid-template-columns:0 1fr}body.hiddenSidebar #sidebar{display:none}body.hiddenSidebar #content #toggle-sidebar{left:0}body.hiddenSidebar #content #toggle-sidebar svg{transform:rotate(180deg)}.windowSettings{pointer-events:none;opacity:0;will-change:opacity,transform}#flash-messages{position:absolute;top:20px;left:0;right:0;z-index:100;display:flex;justify-content:center;opacity:1;transition:all .2s;will-change:opacity,transform}#flash-messages.hidden{pointer-events:none;opacity:0;transform:translateY(-10px) scale(.95)}#flash-messages li{box-shadow:0 10px 10px rgba(0,0,0,.05);padding:0 30px;height:60px;display:flex;color:#cfcfd0;border-radius:100px;font-weight:500;cursor:pointer;align-items:center;background:#313336}#flash-messages.draft li{cursor:default}#flash-messages .flashActions{margin-left:10px}#flash-messages .flashActions a{padding:8px 10px;background:#202123;border-radius:4px;margin-left:5px;color:#8e8e8f;font-size:12px}#flash-messages .flashActions a:hover{color:#fbfbfb}#flash-messages svg{height:30px;margin-right:20px}#flash-messages .success svg{stroke:#70d18c}#flash-messages .error svg{stroke:#ff4d4d}#flash-messages .warning svg{stroke:#ffb82e}</style>

    <!-- <link id="skeleton-theme" rel="stylesheet" type="text/css" href="/css/dist-skeleton-dark.css?d901fe79210280c7c60ca4dd00f7fb144c1fdcca"> -->

    <!-- 
      <link rel="stylesheet" type="text/css" href="/css/light.css?d901fe79210280c7c60ca4dd00f7fb144c1fdcca">
     -->


    <link rel="icon" href="/img/favicon.png">


    <title>Edit fiddle - JSFiddle - Code Playground</title>
  </head>
  <body data-skeleton-url="/css/dist-skeleton-dark.css?d901fe79210280c7c60ca4dd00f7fb144c1fdcca">
    <!-- <h1>Test your JavaScript, CSS, HTML or CoffeeScript online with JSFiddle code editor.</h1> -->
    <!-- <h2>online javascript editor, testing javascript online, online ide, online code editor, html, css, coffeescript, scss online editor</h2> -->
    <form method="post" id="show-result" target="result" action="https://fiddle.jshell.net/_display/" autocomplete="off">
      <input type="hidden" name="authenticity_token" value="h4BPAI4qgmfUF5gMylwoRYfVu5rDEId4mnPcY/K9FAtqwZFjzPaznl2TXMBtUAb/fdr3iK+XVM8DdORXVZzjQg==" />

      <header>
        <h1>
          <span class="title">JSFiddle</span>
          <div class="changelog-badge">
            <a title="JSFiddle" href="/">
              <svg width="46px" height="33px" viewBox="0 0 46 33" id="no-war">
                <g stroke-width="1.8" fill="none" fill-rule="evenodd">
                  <path d="M23.4888889,20.543316 C21.4404656,18.4187374 19.0750303,15.6666667 16.4832014,15.6666667 C13.8721947,15.6666667 11.7555556,17.6366138 11.7555556,20.0666667 C11.7555556,22.4967196 13.8721947,24.4666667 16.4832014,24.4666667 C18.8347252,24.4666667 19.9845474,23.0125628 20.6429148,22.312473" id="Oval-1" stroke-linecap="round"></path>
                  <path d="M22.5111111,19.5900174 C24.5595344,21.7145959 26.9249697,24.4666667 29.5167986,24.4666667 C32.1278053,24.4666667 34.2444444,22.4967196 34.2444444,20.0666667 C34.2444444,17.6366138 32.1278053,15.6666667 29.5167986,15.6666667 C27.1652748,15.6666667 26.0154526,17.1207706 25.3570852,17.8208603" id="Oval-1-Copy" stroke-linecap="round"></path>
                  <path d="M45,22.7331459 C45,19.1499462 42.7950446,16.079593 39.6628004,14.7835315 C39.6774469,14.5246474 39.7003932,14.2674038 39.7003932,14.0035978 C39.7003932,6.82243304 33.8412885,1 26.611593,1 C21.3985635,1 16.9102123,4.03409627 14.8051788,8.41527616 C13.7828502,7.62878013 12.503719,7.15547161 11.1134367,7.15547161 C7.77825654,7.15547161 5.07450503,9.84159999 5.07450503,13.1544315 C5.07450503,13.7760488 5.16938207,14.3779791 5.3477444,14.9418479 C2.74863428,16.4787471 1,19.2867709 1,22.5105187 C1,27.3287502 4.89630545,31.2367856 9.72803666,31.31094 L36.3341301,31.3109406 C41.1201312,31.3406346 45,27.4870665 45,22.7331459 L45,22.7331459 Z" stroke-linejoin="round"></path>
                </g>
              </svg>
            </a>
          </div>
        </h1>
          <div id="actions">
  <nav class="actionCont">
    <div class="actionItem">
      <a class="aiButton" id="run" title="Run (Command/Ctrl + Enter)" href="#run">
        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.4" stroke-linecap="round" stroke-linejoin="round" class="feather feather-play"><polygon points="5 3 19 12 5 21 5 3"></polygon></svg>
        Run</a>
    </div>

    <!-- Logged in users don\'t need the info popup on saving/updating/forking -->
      <div class="actionItem dropdown ">
        <a class="aiButton dropdownTrigger" title="Save (Command/Ctrl + S)" href="#save" data-popover-trigger="saveInfo">
          <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.4" stroke-linecap="round" stroke-linejoin="round" class="feather feather-upload-cloud"><polyline points="16 16 12 12 8 16"></polyline><line x1="12" y1="12" x2="12" y2="21"></line><path d="M20.39 18.39A5 5 0 0 0 18 9h-1.26A8 8 0 1 0 3 16.3"></path><polyline points="16 16 12 12 8 16"></polyline></svg>
          Save</a>
      </div>

      <div class="actionItem dropdown visible">
        <a class="aiButton dropdownTrigger" title="Fork" href="#fork" data-popover-trigger="forkInfo">
          <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.4" stroke-linecap="round" stroke-linejoin="round" class="feather feather-shuffle"><polyline points="16 3 21 3 21 8"></polyline><line x1="4" y1="20" x2="21" y2="3"></line><polyline points="21 16 21 21 16 21"></polyline><line x1="15" y1="15" x2="21" y2="21"></line><line x1="4" y1="4" x2="9" y2="9"></line></svg>
          Fork</a>
      </div>

    <div class="actionItem hidden ">
      <a class="aiButton" id="mark_favourite" title="Set as base" href="#set-as-base">
        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.4" stroke-linecap="round" stroke-linejoin="round" class="feather feather-tag"><path d="M20.59 13.41l-7.17 7.17a2 2 0 0 1-2.83 0L2 12V2h10l8.59 8.59a2 2 0 0 1 0 2.82z"></path><line x1="7" y1="7" x2="7" y2="7"></line></svg>
        Set as base</a>
    </div>

    <div class="actionItem ">
      <a class="aiButton" id="collaborate" title="Collaborate" href="#collaborate">
        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.4" stroke-linecap="round" stroke-linejoin="round" class="feather feather-message-square"><path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"></path></svg>
        Collaborate</a>
    </div>

    <div class="actionItem dropdown visible ">
      <a class="aiButton dropdownTrigger" id="share" title="Embed" href="#embed" data-popover-trigger="embed">
        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.4" stroke-linecap="round" stroke-linejoin="round"><polyline points="16 18 22 12 16 6"></polyline><polyline points="8 6 2 12 8 18"></polyline></svg>
        Embed</a>
    </div> <!-- /actionItem -->

    <div id="app-updates" class="hidden"></div>

<script>
  var updates = [
    {
      id: 25,
      badge: "New",
      title: "Import fiddles as modules",
      body:  "Import fiddle code into other fiddles with Modules and Imports.<br><br><strong>JS Modules:</strong> <code>import [name] from \'@jsfiddle/[username]/[fiddle].js\'</code><br><br><strong>CSS Import:</strong>  <code>@import url(\'@jsfiddle/[username]/[fiddle].css\')</code>.<br><br>See how this works <a href=\'https://jsfiddle.net/rxwyeo73/\' target=\'_blank\'>in this fiddle</a>."
    },
    {
      id: 24,
      badge: "Change",
      title: "Fiddle listing shows latest version",
      body:  "The fiddle listings (Public, Private, Titled, etc) will now display latest versions instead of the ones saved as Base versions - this was causing more confusion than good, so we decided to change this long-standing behavior."
    },
    {
      id: 23,
      badge: "Update",
      title: "Evaluate code into the console",
      body:  "Custom Console beta is getting more stable and feature-rich. Just added the ability to evaluate code in the console.",
      highlight: {
        target: "#console"
      }
    },
    {
      id: 22,
      badge: "New",
      title: "Console in the editor",
      body:  "Introducing the first beta of the editor console - it\'s going to show you logs, warnings, errors without the need of opening full devtools.<br><br> Console is avaialble for all users during beta, after that it\'ll be available for JSFiddle supporters.",
      highlight: {
        target: "*[data-popover-trigger=\'editor-settings\']"
      }
    },
    {
      id: 21,
      badge: "New",
      title: "More user\'s social links (Dev.to, SO...)",
      body:  "You can add more of your social links `Settings / Social Media`, for Dev.to, Stack Overflow and Medium. These will be displayed on the profile section in Editor\'s sidebar and your public profile.",
    },
    {
      id: 20,
      badge: "Update",
      title: "Refactored Unsaved Drafts feature",
      body:  "Unsaved drafts feature is completely rewritten with 100% fewer bugs and 10x more maintainable codebase – as the author of the previous one, I had hard times figuring out what it does 🥴",
    }
  ]

  var UpdatesWidget = function(options){
    if (updates.length <= 0) return false

    var selectedItem  = 0
    var currentUpdate = updates[selectedItem]
    var lastSeenId    = window.localStorage.getItem("last_seen_update")
    var template      = {}

    var element = {
      updates:     document.querySelector("#app-updates"),
      highlighter: document.createElement("div")
    }

    // generic template for the widget
    template.title   = "<strong class=\'badge\'>#{badge}</strong> #{title}"
    template.body    = "<p>#{body}</p>"
    template.actions = "<div class=\'updateActions\'><a href=\'\' class=\'previous\'>Previous update</a><a href=\'\' class=\'dismiss\'>Got it</a></div>"
    template.full    = template.title + template.body + template.actions
    template.body    = "<div class=\'body\'>" + template.full + "</div>"
    template.update  = "<div class=\'bodyCont\'>" + template.body + "</div>"

    // inject the highlighter
    element.highlighter.id = "app-updates-highlighter"
    document.body.appendChild(element.highlighter)

    var dismissUpdate = function(event){
      event.preventDefault()
      event.stopPropagation()

      window.localStorage.setItem("last_seen_update", currentUpdate.id)
      element.updates.classList.add("hidden")

      Track.ui("Update dismissed")
    }

    var showHighlighter = function(event){
      event.preventDefault()
      event.stopPropagation()

      var target  = document.querySelector(currentUpdate.highlight.target)
      var rect    = target.getBoundingClientRect()
      var visible = !element.updates.classList.contains("hidden")

      element.highlighter.style.top    = rect.top + "px"
      element.highlighter.style.left   = rect.left + "px"
      element.highlighter.style.width  = rect.width + "px"
      element.highlighter.style.height = rect.height + "px"

      // only highlight before updater is dismissed
      if (visible){
        element.highlighter.classList.add("show")
      }
    }

    var hideHighlighter = function(event){
      element.highlighter.classList.remove("show")
    }

    var setUpdate = function(event){

      if (event){
        event.preventDefault()
        event.stopPropagation()

        selectedItem = selectedItem + 1

      } else {
        selectedItem = 0
      }

      currentUpdate = updates[selectedItem]

      // update the title
      var update = template.update
        .replace("#{badge}", currentUpdate.badge)
        .replace("#{title}", currentUpdate.title)
        .replace("#{body}",  currentUpdate.body)

      element.updates.innerHTML = update

      // dismiss update and save ID for future reference
      var dismiss = document.querySelector(".updateActions .dismiss")
      dismiss.addEventListener("click", dismissUpdate)

      var previous = document.querySelector(".updateActions .previous")
      previous.addEventListener("click", setUpdate)
    }

    setUpdate()

    // manage highlighter
    if (currentUpdate.highlight){
      element.updates.addEventListener("mouseover", showHighlighter)
      element.updates.addEventListener("mouseout", hideHighlighter)
    }

    // remove hidden class if user hasn\'t seen the latest update
    if (parseInt(lastSeenId) !== currentUpdate.id){
      element.updates.classList.remove("hidden")
    }
  }

  window.addEventListener("DOMContentLoaded", UpdatesWidget)
</script>

  </nav>

  <ul class="actionCont dropdown right">

    <li class="actionItem">
      <a href="/extra" class="aiButtonPro showModalTrigger" data-modal-template="modal-pro" data-modal-class="goPro"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><title>zap</title><g stroke-linecap="round" class="nc-icon-wrapper" fill="none" stroke="#FFB82E" stroke-width="1.5" stroke-linejoin="round"><path d="M13 2L3 14h9l-1 8 10-12h-9l1-8z"></path></g></svg>Go PRO</a>
    </li>

    <style>
      .aiButtonPro {
        border: solid 1px rgba(255, 255, 255, 0.1);
        border-radius: 8px;
        padding: 0 15px 0 10px;
        margin-top: 10px;
        height: 35px;
        display: flex;
        outline: none;
        text-decoration: none;
        color: #FFB82E;
        align-items: center;
        justify-content: center;
        position: relative;
        font-weight: bold;
        margin-right: 10px;
      }

      .aiButtonPro:hover {
        border: solid 1px #FFB82E;
        text-decoration: none;
      }

      .aiButtonPro svg {
        margin-right: 4px;
        pointer-events: none;
      }
    </style>

  <!-- <li class="actionItem dropdown">
    <a id="upvote-iframe-load" class="aiButtonVote dropdownTrigger" href="#upvote" data-popover-trigger="upvote">
      <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#87C449" stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round" class="feather feather-message-square"><path d="M14 9V5a3 3 0 0 0-3-3l-4 9v11h11.28a2 2 0 0 0 2-1.7l1.38-9a2 2 0 0 0-2-2.3zM7 22H4a2 2 0 0 1-2-2v-7a2 2 0 0 1 2-2h3"></path></svg>
      Vote for features</a>
  </li> -->

  <li class="actionItem">
    <a class="aiButton dropdownTrigger" href="#" title="Editor settings" data-popover-trigger="editor-settings">
      <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.4" stroke-linecap="round" stroke-linejoin="round" class="feather feather-sliders"><line x1="4" y1="21" x2="4" y2="14"></line><line x1="4" y1="10" x2="4" y2="3"></line><line x1="12" y1="21" x2="12" y2="12"></line><line x1="12" y1="8" x2="12" y2="3"></line><line x1="20" y1="21" x2="20" y2="16"></line><line x1="20" y1="12" x2="20" y2="3"></line><line x1="1" y1="14" x2="7" y2="14"></line><line x1="9" y1="8" x2="15" y2="8"></line><line x1="17" y1="16" x2="23" y2="16"></line></svg>
      Settings
    </a>
  </li> <!-- /actionItem -->

    <li class="actionItem"><a class="aiButton" href="/user/login/">Sign in</a></li>


</ul>

<div class="dropdownCont hidden" data-popover-ref="editor-settings" data-popover-position="left">
  <div class="dcWrapper editorSettings">
    <div id="editor-options">
      <h3>Editor layout</h3>
      <div id="layout">
        <!-- HACK: for some reason the first input always gets the value of the last active
                   grid mode, for that reason a hack is to create an invisible first input -->
        <input style="display: none;" name="layout" type="radio" value="grid_invisible_hack">
        <label>
          <input name="layout" type="radio" value="1" checked>
          <span class="gridMode grid_1"></span>
          Classic
        </label>
        <label>
          <input name="layout" type="radio" value="2">
          <span class="gridMode grid_2"></span>
          Columns
        </label>
        <label>
          <input name="layout" type="radio" value="3">
          <span class="gridMode grid_3"></span>
          Bottom results
        </label>
        <label>
          <input name="layout" type="radio" value="4">
          <span class="gridMode grid_4"></span>
          Right results
        </label>
        <label>
          <input name="layout" type="radio" value="5">
          <span class="gridMode grid_5"></span>
          Tabs (columns)
        </label>
        <label>
          <input name="layout" type="radio" value="6">
          <span class="gridMode grid_6"></span>
          Tabs (rows)
        </label>
      </div>

      <h3>Console</h3>
      <div class="fieldsCont">
        <p class="proBadge">
          <label class="checkboxCont ">
            <input type="checkbox" name="editorConsole">
            <span class="checkbox"></span>
            Console in the editor <small>(beta)</small>
          </label>
        </p>
        <p>
          <label class="checkboxCont">
            <input type="checkbox" name="clearConsole">
            <span class="checkbox"></span>
            Clear console on run
          </label>
        </p>
      </div> <!-- /fieldsCont -->

      <h3>General</h3>
      <div class="fieldsCont">
        <p>
          <label class="checkboxCont">
            <input type="checkbox" name="darkTheme" checked>
            <span class="checkbox"></span>
            Dark theme
          </label>
        </p>
        <p>
          <label class="checkboxCont">
            <input type="checkbox" name="lineNumbers" checked>
            <span class="checkbox"></span>
            Line numbers
          </label>
        </p>
        <p>
          <label class="checkboxCont">
            <input type="checkbox" name="lineWrapping" checked>
            <span class="checkbox"></span>
            Wrap lines
          </label>
        </p>
        <p>
          <label class="checkboxCont">
            <input type="checkbox" name="indentWithTabs">
            <span class="checkbox"></span>
            Indent with tabs
          </label>
        </p>
        <p>
          <label class="checkboxCont">
            <input type="checkbox" name="codeHints" checked>
            <span class="checkbox"></span>
            Code hinting (autocomplete) <small>(beta)</small>
          </label>
        </p>
      </div> <!-- /fieldsCont -->

      <div class="selectPairs">
        <div class="selectPair">
          <span class="label">Indent size:</span>
          <div class="selectCont">
            <select name="indentUnit">
              <option value="2">2 spaces</option>
              <option value="3">3 spaces</option>
              <option value="4">4 spaces</option>
            </select>
          </div>
        </div> <!-- /selectPair -->

        <div class="selectPair">
          <span class="label">Key map:</span>
          <div class="selectCont">
            <select name="keyMap">
              <option value="default">Default</option>
              <option value="sublime">Sublime Text</option>
              <!-- <option value="vim">VIM</option> -->
              <option value="emacs">EMACS</option>
            </select>
          </div>
        </div> <!-- /selectPair -->

        <div class="selectPair">
          <span class="label">Font size:</span>
          <div class="selectCont">
            <select name="fontSize">
              <option value="1">Default</option>
              <option value="2">Big</option>
              <option value="3">Bigger</option>
              <option value="4">Jabba</option>
            </select>
          </div>
        </div> <!-- /selectPair -->
      </div> <!-- /selectPairs -->

      <h3>Behavior</h3>
      <div class="fieldsCont">
        <p>
            <label class="checkboxCont disabled" data-title="Log in to use auto-running">
              <input type="checkbox" name="autoRun" disabled>
              <span class="checkbox"></span>
              Auto-run code
            </label>
        </p>
        <p>
            <label class="checkboxCont disabled" data-title="Log in to use auto-running">
              <input type="checkbox" name="autoRunValid" disabled>
              <span class="checkbox"></span>
              Only auto-run code that validates
            </label>
        </p>
        <p>
            <label class="checkboxCont disabled" data-title="Log in to use auto-saving">
              <input type="checkbox" name="autoSave" disabled>
              <span class="checkbox"></span>
              Auto-save code (bumps the version)
            </label>
        </p>
        <p>
          <label class="checkboxCont">
            <input type="checkbox" name="autoCloseTags" checked>
            <span class="checkbox"></span>
            Auto-close HTML tags
          </label>
        </p>
        <p>
          <label class="checkboxCont">
            <input type="checkbox" name="autoCloseBrackets" checked>
            <span class="checkbox"></span>
            Auto-close brackets
          </label>
        </p>
        <p>
          <label class="checkboxCont">
            <input type="checkbox" name="codeLinting" checked>
            <span class="checkbox"></span>
            Live code validation
          </label>
        </p>
        <p>
          <label class="checkboxCont">
            <input type="checkbox" name="matchTags">
            <span class="checkbox"></span>
            Highlight matching tags
          </label>
        </p>
      </div> <!-- /fieldsCont -->
    </div> <!-- /editor-options -->
  </div> <!-- /dcWrapper -->
</div> <!-- /dropdownCont -->


<!-- <div class="dropdownCont hidden" data-popover-ref="upvote" data-popover-position="left">
  <div class="dcWrapper" style="width: 750px;" id="votehub-cont">
    <script type="text/javascript">
      let votehubLoaded = false

      document.querySelector("#upvote-iframe-load").addEventListener("click", function(){
        async function loadVoteHub(){

          const response = await fetch("https://vote-hub.app/api/voter")
          const obj      = await response.json()
          const userId   = obj.voter

          let frame     = `<iframe src="https://vote-hub.app/votings/c3246f03-9571-43a3-b4ed-a26f4c290757/embed?identifier=${userId}&show_name=1&show_description=1&show_total=0&show_percent=1" style="width: 100%; min-height: calc(100vh - 90px); border: none"></iframe>`
          let frameCont = document.querySelector("#voting-iframe-cont")

          if (!votehubLoaded){
            frameCont.innerHTML = frame
            votehubLoaded = true
          }
        }

        loadVoteHub()
      })
    </script>

    <style>
      #votehub-cont {
        display: grid;
        grid-template-columns: 2fr 1fr;
      }

      #voting-iframe-cont {
        position: relative;
        left: -10px;
        width: 100%;
      }

      #approved-votes {
        padding: 20px;
        background-color: rgba(0,0,0,0.04);
        border-radius: 10px;
      }

      #approved-votes h3 {
        font-weight: bold;
        font-size: 14px;
        margin-bottom: 15px;
      }

      #approved-votes li {
        margin-top: 5px;
      }

      #approved-votes a {
        color: #2E71FF;
      }

      .aiButtonVote {
        border: solid 1px rgba(255, 255, 255, 0.1);
        border-radius: 5px;
        padding: 0 10px;
        margin-top: 10px;
        height: 35px;
        display: flex;
        outline: none;
        text-decoration: none;
        color: #fff;
        align-items: center;
        justify-content: center;
        position: relative;
        font-weight: bold;
      }

      .aiButtonVote:hover {
        border: solid 1px #fff;
        text-decoration: none;
      }

      .aiButtonVote svg {
        margin-right: 7px;
      }

      .aiButtonVote:after {
        content: "January";
        display: block;
        position: absolute;
        right: -10px;
        bottom: -12px;
        color: #222;
        font-size: 11px;
        font-weight: normal;
        border-radius: 5px;
        padding: 2px 5px;
        background-color: #87C449;
      }
    </style>

    <div id="voting-iframe-cont">
      Loading ...
    </div>

    <div id="approved-votes">
      <h3>Planned features by votes</h3>
      <ul>
        <li><a href="https://github.com/orgs/jsfiddle/projects/4/views/2" target="_blank">Publish fiddles as mini-websites</a></li>
        <li><a href="https://github.com/orgs/jsfiddle/projects/4/views/2" target="_blank">Save fiddles as templates</a></li>
        <li><a href="https://github.com/orgs/jsfiddle/projects/4/views/2" target="_blank">Download a zipped fiddle</a></li>
      </ul>
    </div>

  </div>
</div> -->

<template id="modal-pro">
  <main>
    <h2>Join the 4+ million users, and keep the JSFiddle dream alive.</h2>

    <ul class="perks">
      <li>
        <em>
          <svg version="1.1" viewBox="0 0 24 24">
            <path d="M12,2l3.09,6.26l6.91,1.01l-5,4.87l1.18,6.88l-6.18,-3.25l-6.18,3.25l1.18,-6.88l-5,-4.87l6.91,-1.01l3.09,-6.26Z" stroke-linecap="round" stroke-width="2" fill="none" stroke-linejoin="round"></path>
          </svg>
        </em>
        <section>
          <h3>Ad-free</h3>
          <p>All ads in the editor and listing pages are turned completely off.</p>
        </section>
      </li>
      <li>
        <em>
          <svg viewBox="0 0 24 24"><g stroke-linejoin="round" stroke-linecap="round" stroke-width="2" fill="none"><path d="M4 15s1-1 4-1 5 2 8 2 4-1 4-1V3s-1 1-4 1-5-2-8-2-4 1-4 1z"></path><path d="M4 22v-7"></path></g></svg>
        </em>
        <section>
          <h3>Use pre-released features</h3>
          <p>You get to try and use features (like the Palette Color Generator) months before everyone else.</p>
        </section>
      </li>
      <li>
        <em>
          <svg version="1.1" viewBox="0 0 24 24">
            <g stroke-linecap="round" stroke-width="1.8" fill="none" stroke-linejoin="round">
              <path d="M12.89,1.45l8,4l1.83254e-07,9.10609e-08c0.679658,0.33773 1.1096,1.03106 1.11,1.79v9.53l4.31591e-08,-8.47154e-05c-0.000370578,0.758944 -0.430281,1.45229 -1.10992,1.79005l-8,4l5.5497e-08,-2.77707e-08c-0.563368,0.28191 -1.22663,0.28191 -1.79,5.55414e-08l-8,-4l-2.93338e-07,-1.47804e-07c-0.679008,-0.342131 -1.10529,-1.03969 -1.1,-1.8v-9.51996l-4.32445e-08,8.48903e-05c0.000370512,-0.758944 0.430281,-1.45229 1.10992,-1.79005l8,-4l1.55256e-07,-7.71484e-08c0.560633,-0.278585 1.21937,-0.278585 1.78,1.54297e-07Z"></path>
              <path d="M2.32,6.16l9.68,4.84l9.68,-4.84"></path>
              <path d="M12,22.76v-11.76"></path>
              <path d="M7,3.5l10,5"></path>
            </g>
          </svg>
        </em>
        <section>
          <h3>Fiddle groups</h3>
          <p>Sort and categorize your Fiddles into multiple groups.</p>
        </section>
      </li>
      <li>
        <em>
          <svg version="1.1" viewBox="0 0 24 24">
            <g stroke-linecap="round" stroke-width="1.8" fill="none" stroke-linejoin="round">
              <path d="M1,12c0,0 4,-8 11,-8c7,0 11,8 11,8c0,0 -4,8 -11,8c-7,0 -11,-8 -11,-8Z"></path>
              <path d="M14.1213,9.87868c1.17157,1.17157 1.17157,3.07107 0,4.24264c-1.17157,1.17157 -3.07107,1.17157 -4.24264,0c-1.17157,-1.17157 -1.17157,-3.07107 0,-4.24264c1.17157,-1.17157 3.07107,-1.17157 4.24264,0"></path>
            </g>
          </svg>
        </em>
        <section>
          <h3>Private groups and fiddles</h3>
          <p>You can make as many Private Fiddles, and Private Groups as you wish!</p>
        </section>
      </li>
      <li>
        <em>
          <svg version="1.1" viewBox="0 0 24 24">
            <g stroke-linecap="round" stroke-width="1.8" fill="none" stroke-linejoin="round">
              <path d="M4,17l6,-6l-6,-6"></path>
              <path d="M12,19h8"></path>
            </g>
          </svg>
        </em>
        <section>
          <h3>Console</h3>
          <p>Debug your Fiddle with a minimal built-in JavaScript console.</p>
        </section>
      </li>
    </ul>
  </main>
  <aside>
    <div class="brandsCont">
      <p>JSFiddle is used by you and 4+ million other developers, in many companies ...</p>

      <div class="segment">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><path fill-rule="evenodd" clip-rule="evenodd" d="M48.854 0C21.839 0 0 22 0 49.217c0 21.756 13.993 40.172 33.405 46.69 2.427.49 3.316-1.059 3.316-2.362 0-1.141-.08-5.052-.08-9.127-13.59 2.934-16.42-5.867-16.42-5.867-2.184-5.704-5.42-7.17-5.42-7.17-4.448-3.015.324-3.015.324-3.015 4.934.326 7.523 5.052 7.523 5.052 4.367 7.496 11.404 5.378 14.235 4.074.404-3.178 1.699-5.378 3.074-6.6-10.839-1.141-22.243-5.378-22.243-24.283 0-5.378 1.94-9.778 5.014-13.2-.485-1.222-2.184-6.275.486-13.038 0 0 4.125-1.304 13.426 5.052a46.97 46.97 0 0 1 12.214-1.63c4.125 0 8.33.571 12.213 1.63 9.302-6.356 13.427-5.052 13.427-5.052 2.67 6.763.97 11.816.485 13.038 3.155 3.422 5.015 7.822 5.015 13.2 0 18.905-11.404 23.06-22.324 24.283 1.78 1.548 3.316 4.481 3.316 9.126 0 6.6-.08 11.897-.08 13.526 0 1.304.89 2.853 3.316 2.364 19.412-6.52 33.405-24.935 33.405-46.691C97.707 22 75.788 0 48.854 0z" fill="#222"/></svg>
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M256.32,126.24,136.16,204.49l120.16,78.24L136.16,361,16,282.08l120.16-78.24L16,126.24,136.16,48ZM135.52,385.76l120.16-78.25,120.16,78.25L255.68,464Zm120.8-103.68,120.16-78.24-120.16-77.6L375.84,48,496,126.24,375.84,204.49,496,282.73,375.84,361Z"/></svg>
        <svg fill="#222" viewBox="0 0 32 32" id="Camada_1" version="1.1" xml:space="preserve" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"><path d="M5,19.5c0-4.6,2.3-9.4,5-9.4c1.5,0,2.7,0.9,4.6,3.6c-1.8,2.8-2.9,4.5-2.9,4.5c-2.4,3.8-3.2,4.6-4.5,4.6  C5.9,22.9,5,21.7,5,19.5 M20.7,17.8L19,15c-0.4-0.7-0.9-1.4-1.3-2c1.5-2.3,2.7-3.5,4.2-3.5c3,0,5.4,4.5,5.4,10.1  c0,2.1-0.7,3.3-2.1,3.3S23.3,22,20.7,17.8 M16.4,11c-2.2-2.9-4.1-4-6.3-4C5.5,7,2,13.1,2,19.5c0,4,1.9,6.5,5.1,6.5  c2.3,0,3.9-1.1,6.9-6.3c0,0,1.2-2.2,2.1-3.7c0.3,0.5,0.6,1,0.9,1.6l1.4,2.4c2.7,4.6,4.2,6.1,6.9,6.1c3.1,0,4.8-2.6,4.8-6.7  C30,12.6,26.4,7,22.1,7C19.8,7,18,8.8,16.4,11"/></svg>
        <svg fill="#222" viewBox="-5.5 0 24 24" xmlns="http://www.w3.org/2000/svg"><path d="m0 0 4.751 13.462v-.007l.376 1.06c2.088 5.909 3.211 9.077 3.217 9.084s.32.02.7.04c1.156.05 2.59.18 3.677.31.122.02.262.031.404.031.027 0 .053 0 .08-.001h-.004l-4.711-13.362-.436-1.23-2.423-6.851c-.46-1.3-.85-2.408-.87-2.45l-.029-.085h-4.726z"/><path d="m8.511.012-.01 5.307-.008 5.307-.437-1.232-.567 11.81c.555 1.567.852 2.4.855 2.407s.32.024.7.042c1.157.05 2.59.18 3.681.31.122.02.262.031.405.031.027 0 .053 0 .079-.001h-.004c.013-.01.02-5.421.017-12.012l-.01-11.971h-4.701zm-8.511-.012v11.992c0 6.595.007 11.997.015 12.002s.416-.03.907-.086 1.17-.13 1.51-.16c.518-.05 2.068-.15 2.248-.15.052 0 .056-.27.063-5.081l.008-5.081.38 1.06.13.376.57-11.802-.19-.546-.91-2.524h-4.732z"/></svg>
        <svg viewBox="-1 0 20 20" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
            <g id="Page-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                <g id="Dribbble-Light-Preview" transform="translate(-261.000000, -7399.000000)" fill="#222">
                    <g id="icons" transform="translate(56.000000, 160.000000)">
                        <path d="M219.770353,7256.58451 C218.225353,7257.4867 216.591353,7256.27747 215.381353,7254.95558 C216.484353,7253.46124 217.537353,7251.64689 217.594353,7249.79167 C217.642353,7248.02816 216.690353,7246.67637 215.284353,7246.16297 C214.541353,7245.88783 213.713353,7245.86191 212.952353,7246.08621 C211.551353,7246.49893 210.547353,7247.71414 210.427353,7249.28525 C210.262353,7251.27006 211.430353,7253.35756 212.626353,7254.95459 C211.920353,7255.73715 210.963353,7256.59348 209.927353,7256.82476 C208.126353,7257.24944 206.591353,7255.54375 207.196353,7253.68355 C207.507353,7252.7365 212.316353,7242.06773 213.133353,7241.42174 C213.626353,7241.02099 214.408353,7241.01202 214.920353,7241.46062 C215.671353,7242.1086 220.592353,7252.87506 220.853353,7253.83109 C221.159353,7254.96157 220.667353,7256.07011 219.770353,7256.58451 M214.002353,7253.23096 C213.584353,7252.62484 213.216353,7252.0277 212.919353,7251.34383 C212.484353,7250.326 212.198353,7248.98717 213.117353,7248.37608 C213.702353,7247.9843 214.529353,7248.03414 215.045353,7248.4987 C215.696353,7249.0749 215.533353,7250.14058 215.238353,7250.96103 C214.923353,7251.81836 214.449353,7252.59294 214.002353,7253.23096 M216.416353,7239.97126 C215.065353,7238.63143 212.829353,7238.71417 211.564353,7239.99518 C210.419353,7241.12267 205.250353,7252.2859 205.050353,7253.77626 C204.629353,7256.63336 206.908353,7259.16148 209.641353,7258.97407 C211.381353,7258.87936 212.807353,7257.80272 214.003353,7256.53566 C216.048353,7258.71388 218.673353,7259.8623 221.041353,7258.22839 C222.263353,7257.392 223.027353,7255.93753 223.002353,7254.3724 C222.979353,7252.30085 217.366353,7240.88342 216.416353,7239.97126" id="airbnb-[#179]"></path>
                    </g>
                </g>
            </g>
        </svg>
        <svg fill="#222" viewBox="0 0 24 24" role="img" xmlns="http://www.w3.org/2000/svg"><path d="M7.042 16.896H4.414v-3.754H2.708v3.754H.01L0 7.22h2.708v3.6h1.706v-3.6h2.628zm12.043.046C21.795 16.94 24 14.689 24 11.978a4.89 4.89 0 0 0-4.915-4.92c-2.707-.002-4.09 1.991-4.432 2.795.003-1.207-1.187-2.632-2.58-2.634H7.59v9.674l4.181.001c1.686 0 2.886-1.46 2.888-2.713.385.788 1.72 2.762 4.427 2.76zm-7.665-3.936c.387 0 .692.382.692.817 0 .435-.305.817-.692.817h-1.33v-1.634zm.005-3.633c.387 0 .692.382.692.817 0 .436-.305.818-.692.818h-1.33V9.373zm1.77 2.607c.305-.039.813-.387.992-.61-.063.276-.068 1.074.006 1.35-.204-.314-.688-.701-.998-.74zm3.43 0a2.462 2.462 0 1 1 4.924 0 2.462 2.462 0 0 1-4.925 0zm2.462 1.936a1.936 1.936 0 1 0 0-3.872 1.936 1.936 0 0 0 0 3.872z"/></svg>
        <svg fill="#222" viewBox="0 0 24 24" role="img" xmlns="http://www.w3.org/2000/svg"><path d="m16.635 6.162-5.928 9.377H4.24l1.508-2.3h4.024l1.474-2.335H2.264L.79 13.239h2.156L0 17.84h12.072l4.563-7.259 1.652 2.66h-1.401l-1.473 2.299h4.347l1.473 2.3H24zm-11.461.107L3.7 8.604l9.52-.035 1.474-2.3z"/></svg>
        <svg fill="#222" viewBox="0 0 32 32" xmlns="http://www.w3.org/2000/svg">
          <path d="M31.416 15.984c-0.348-16.391-22.145-22.505-30.541-7.14 0.376 0.276 0.88 0.635 1.256 0.896-0.62 1.296-1.057 2.676-1.303 4.093-0.161 0.912-0.244 1.833-0.244 2.76 0 8.5 6.911 15.407 15.421 15.407 8.516 0 15.411-6.896 15.411-15.407zM4.385 18.729c-0.203 1.667-0.073 2.183-0.073 2.385l-0.375 0.131c-0.14-0.272-0.489-1.24-0.651-2.543-0.407-4.957 2.979-9.421 8.14-10.265 4.724-0.692 9.251 2.245 10.303 6.349l-0.375 0.131c-0.115-0.115-0.303-0.448-1.027-1.172-5.708-5.709-14.672-3.095-15.943 4.989zM19.057 21.505c-0.787 1.135-2.079 1.812-3.453 1.807-2.328 0.005-4.213-1.88-4.208-4.208 0.005-2.197 1.708-4.025 3.901-4.187 1.359-0.057 2.629 0.676 3.224 1.864 0.651 1.301 0.411 2.88-0.604 3.927 0.389 0.276 0.765 0.537 1.14 0.797zM27.828 21.667c-2.224 5.041-6.807 7.688-11.692 7.615-9.381-0.464-12.109-11.287-5.839-15.188l0.276 0.271c-0.104 0.147-0.48 0.439-1.057 1.579-0.677 1.385-0.896 2.776-0.808 3.641 0.489 7.561 11.089 9.109 14.729 1.619 4.641-10.244-7.677-20.667-18.604-12.703l-0.245-0.245c2.876-4.509 8.5-6.52 13.86-5.176 8.197 2.067 12.604 10.609 9.38 18.588z"/>
        </svg>
        <svg viewBox="-1.5 0 20 20" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
          <g id="Page-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
            <g id="Dribbble-Light-Preview" transform="translate(-102.000000, -7439.000000)" fill="#222">
              <g id="icons" transform="translate(56.000000, 160.000000)">
                <path d="M57.5708873,7282.19296 C58.2999598,7281.34797 58.7914012,7280.17098 58.6569121,7279 C57.6062792,7279.04 56.3352055,7279.67099 55.5818643,7280.51498 C54.905374,7281.26397 54.3148354,7282.46095 54.4735932,7283.60894 C55.6455696,7283.69593 56.8418148,7283.03894 57.5708873,7282.19296 M60.1989864,7289.62485 C60.2283111,7292.65181 62.9696641,7293.65879 63,7293.67179 C62.9777537,7293.74279 62.562152,7295.10677 61.5560117,7296.51675 C60.6853718,7297.73474 59.7823735,7298.94772 58.3596204,7298.97372 C56.9621472,7298.99872 56.5121648,7298.17973 54.9134635,7298.17973 C53.3157735,7298.17973 52.8162425,7298.94772 51.4935978,7298.99872 C50.1203933,7299.04772 49.0738052,7297.68074 48.197098,7296.46676 C46.4032359,7293.98379 45.0330649,7289.44985 46.8734421,7286.3899 C47.7875635,7284.87092 49.4206455,7283.90793 51.1942837,7283.88393 C52.5422083,7283.85893 53.8153044,7284.75292 54.6394294,7284.75292 C55.4635543,7284.75292 57.0106846,7283.67793 58.6366882,7283.83593 C59.3172232,7283.86293 61.2283842,7284.09893 62.4549652,7285.8199 C62.355868,7285.8789 60.1747177,7287.09489 60.1989864,7289.62485" id="apple-[#173]"></path>
              </g>
            </g>
          </g>
        </svg>
        <svg fill="#222" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg">
          <path d="M14.192 14.77c1.377 0 2.494 1.117 2.494 2.494s-1.117 2.494-2.494 2.494-2.494-1.117-2.494-2.494c0-1.377 1.116-2.494 2.494-2.494h0zM22.604 14.755c1.090 0.007 1.995 0.789 2.192 1.823l0.002 0.014h-4.4c0.208-1.047 1.114-1.826 2.204-1.837h0.001zM30.501 13.596c-0.019-0.001-0.042-0.001-0.065-0.001-0.704 0-1.319 0.377-1.656 0.94l-0.005 0.009v-0.891h-1.413v7.215h1.427v-4.105c-0.007-0.056-0.011-0.121-0.011-0.187 0-0.902 0.724-1.635 1.622-1.65l0.001-0h0.594v-1.331h-0.495zM22.634 13.511c-2.053 0.027-3.708 1.698-3.708 3.755 0 2.074 1.681 3.756 3.756 3.756 0.027 0 0.055-0 0.082-0.001l-0.004 0c0.020 0 0.043 0.001 0.067 0.001 1.245 0 2.349-0.602 3.037-1.531l0.007-0.010-1.032-0.764c-0.454 0.644-1.195 1.059-2.032 1.059-0.017 0-0.033-0-0.050-0l0.003 0c-0 0-0 0-0 0-1.205 0-2.204-0.882-2.387-2.036l-0.002-0.014h5.87v-0.466c0.003-0.051 0.004-0.111 0.004-0.171 0-1.976-1.602-3.578-3.578-3.578-0.011 0-0.023 0-0.034 0h0.002zM10.302 10.964v9.903h1.412v-0.906c0.654 0.664 1.562 1.075 2.566 1.075 0.003 0 0.006 0 0.009 0h-0c0.007 0 0.016 0 0.025 0 2.082 0 3.77-1.688 3.77-3.77s-1.688-3.77-3.77-3.77c-0.008 0-0.017 0-0.025 0h0.001c-0.001 0-0.003 0-0.004 0-1.001 0-1.907 0.412-2.555 1.075l-0.001 0.001v-3.606h-1.428zM1.004 10.964v6.196c-0.004 0.062-0.006 0.135-0.006 0.209 0 2.026 1.642 3.667 3.667 3.667 0.031 0 0.061-0 0.092-0.001l-0.005 0c0.015 0 0.032 0 0.049 0 1.007 0 1.917-0.416 2.567-1.087l0.001-0.001v0.92h1.47v-9.903h-1.485v6.108c0.004 0.054 0.007 0.117 0.007 0.181 0 1.35-1.091 2.445-2.439 2.451h-0.001c-0.004 0-0.010 0-0.015 0-1.34 0-2.426-1.086-2.426-2.426 0-0.073 0.003-0.144 0.009-0.215l-0.001 0.009v-6.107h-1.486z"></path>
        </svg>
        <svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
          <path d="M4 4H11.5V11.5H4V4ZM12.5 4H20V11.5H12.5V4ZM4 12.5H11.5V20H4V12.5ZM12.5 12.5H20V20H12.5V12.5Z" fill="#222"/>
        </svg>
        <svg fill="#222" viewBox="0 0 32 32" xmlns="http://www.w3.org/2000/svg">
          <path d="M0 32v-32h32v32zM21.855 9.016l-0.308 0.036-0.292 0.052-0.281 0.084-0.265 0.093-0.271 0.093-0.249 0.12-0.24 0.131-0.229 0.145-0.224 0.161-0.213 0.172-0.203 0.188-0.183 0.203-0.177 0.213-0.172 0.224-0.145 0.229-0.147 0.251-0.135 0.255-0.12 0.281-0.104-0.297-0.136-0.276-0.135-0.271-0.156-0.249-0.177-0.229-0.188-0.213-0.197-0.199-0.199-0.187-0.229-0.172-0.224-0.147-0.255-0.145-0.24-0.125-0.265-0.104-0.265-0.093-0.271-0.079-0.276-0.068-0.297-0.052-0.292-0.025-0.291-0.032h-0.573l-0.281 0.032-0.265 0.025-0.271 0.037-0.251 0.067-0.24 0.068-0.239 0.079-0.245 0.093-0.208 0.109-0.229 0.104-0.197 0.136-0.204 0.129-0.187 0.152-0.183 0.156-0.177 0.177-0.156 0.172-0.161 0.187-0.147 0.199-0.135 0.213-0.12 0.213v-2.068h-5.803v2.964h1.829v7.812h-1.829v3.011h8.443v-3.011h-2.64v-5.083l0.016-0.276 0.036-0.271 0.041-0.251 0.052-0.24 0.068-0.239 0.079-0.213 0.093-0.215 0.109-0.187 0.12-0.188 0.145-0.161 0.147-0.145 0.161-0.136 0.187-0.12 0.199-0.104 0.197-0.077 0.229-0.068 0.256-0.052 0.249-0.032 0.281-0.011h0.229l0.208 0.027 0.213 0.041 0.188 0.052 0.188 0.068 0.171 0.079 0.163 0.093 0.145 0.12 0.135 0.135 0.131 0.147 0.109 0.161 0.104 0.183 0.084 0.213 0.077 0.213 0.068 0.255 0.052 0.256 0.041 0.276 0.043 0.307 0.011 0.333v8.12h5.733v-3.011h-1.828v-4.801l0.016-0.281 0.011-0.276 0.025-0.271 0.057-0.251 0.052-0.24 0.068-0.239 0.079-0.213 0.093-0.215 0.104-0.187 0.125-0.188 0.131-0.161 0.161-0.145 0.161-0.136 0.181-0.12 0.188-0.104 0.213-0.077 0.229-0.068 0.251-0.052 0.255-0.032 0.281-0.011h0.224l0.213 0.027 0.213 0.041 0.188 0.052 0.187 0.068 0.172 0.079 0.161 0.093 0.147 0.12 0.135 0.135 0.12 0.147 0.12 0.161 0.104 0.183 0.084 0.213 0.077 0.213 0.068 0.255 0.052 0.256 0.041 0.276 0.037 0.307 0.015 0.333v8.12h5.735v-3.011h-1.828v-6.296l-0.016-0.48-0.052-0.437-0.077-0.427-0.109-0.401-0.131-0.375-0.161-0.344-0.188-0.323-0.213-0.308-0.239-0.265-0.24-0.249-0.281-0.215-0.276-0.203-0.308-0.172-0.323-0.161-0.333-0.12-0.333-0.104-0.359-0.083-0.344-0.052-0.375-0.043h-0.693z"/>
        </svg>
      </div> <!-- /segment -->

      <p>... and top educational institutions:</p>

      <div class="segment edu">
        <svg  version="1.1" viewBox="0 0 600 165" xmlns="http://www.w3.org/2000/svg">
          <path d="m244.32 110.24c0-1.242-0.82799-2.07-2.484-2.4839v-0.82798c0.82798 0 3.9329 0.207 4.7609 0.207 0.62098 0 3.7259-0.207 4.5539-0.207v0.82798c-1.449 0.41399-2.277 1.242-2.277 2.4839v15.525c0 4.9679 2.6909 7.6588 8.2798 7.6588 4.9679 0 8.6938-2.277 8.6938-7.4518v-15.939c0-1.242-0.82798-2.0699-2.4839-2.4839v-0.62099c0.62098 0 3.1049 0.207 3.9329 0.207 0.82799 0 3.3119-0.207 3.9329-0.207v0.82798c-1.863 0.41399-2.4839 1.242-2.4839 2.4839v15.111c0 6.8308-3.9329 10.764-12.42 10.764-7.8658 0-12.006-3.5189-12.006-9.9358zm33.947 24.632c1.863-0.41398 2.4839-1.242 2.4839-2.4839v-21.527c0-1.863-1.035-2.6909-2.6909-3.1049v-0.82798h6.0029l18.63 21.941v-18.63c0-1.242-0.82799-2.07-2.484-2.4839v-0.82798c0.62098 0 3.1049 0.207 3.9329 0.207 0.82798 0 3.3119-0.207 3.9329-0.207v0.82798c-1.863 0.41399-2.691 1.242-2.691 2.4839v25.874h-1.035c-0.621-0.20699-2.07-0.82798-4.1399-3.1049l-16.767-19.458v19.044c0 1.242 0.62099 2.07 2.4839 2.4839v0.82798c-0.62098 0-3.1049-0.207-3.9329-0.207-0.82799 0-3.3119 0.207-3.9329 0.207zm147.38-5.7959h0.82798c0.41399 1.656 1.242 3.1049 2.6909 3.9329 1.242 1.035 3.5189 1.449 5.1749 1.449 3.7259 0 6.2098-1.863 6.2098-4.7609 0-3.1049-3.1049-4.5539-6.6238-6.4168-2.6909-1.449-8.0728-3.5189-8.0728-8.6938 0-4.7609 3.7259-7.8658 9.5218-7.8658 3.9329 0 5.5889 1.035 8.2798 0.82798v5.7959h-0.82799c-1.035-3.5189-4.1399-4.5539-7.6588-4.5539-3.9329 0-5.1749 2.277-5.1749 4.3469 0 3.1049 3.1049 4.7609 6.6238 6.4168 3.9329 1.656 8.2798 3.9329 8.2798 8.9008 0 4.7609-3.7259 8.0728-10.35 8.0728-3.9329 0-6.4168-1.242-8.4868-1.449zm80.107-5.3819-7.6588-12.213c-1.242-2.07-2.277-3.3119-3.7259-3.7259v-0.82798c1.035 0 3.9329 0.207 4.5539 0.207 0.82798 0 3.7259-0.207 4.9679-0.207v0.82798c-1.035 0.207-1.449 0.62099-1.449 1.449 0 0.62099 0.41399 1.449 0.82799 2.277 0.41398 0.62098 5.5889 9.3148 5.5889 9.3148l5.3819-9.3148c0.62099-1.035 0.82798-1.863 0.82798-2.4839 0-0.62099-0.41399-1.035-1.242-1.035v-1.035c0.82798 0 2.8979 0.207 3.5189 0.207 0.62099 0 2.8979-0.207 3.7259-0.207v0.82798c-2.07 0.82798-3.3119 2.6909-4.5539 4.7609l-6.8308 11.592m0.41399-1.449v9.7288c0 1.035 0.82798 2.277 2.4839 2.4839v0.82798c-0.82798 0-3.9329-0.20699-4.7609-0.20699s-3.7259 0.20699-4.7609 0.20699v-0.82798c1.656-0.41398 2.484-1.449 2.484-2.4839v-9.3148m-140.96-16.146h17.802c0.62099 0 1.449 0 2.07-0.41399h0.82799l-0.20699 5.7959h-0.82799c-0.62099-1.863-1.449-3.3119-4.7609-3.3119h-7.6588v10.35h6.0029c0.82797 0 1.863 0 2.2769-0.20699 1.242-0.207 1.863-1.035 2.2769-2.277h0.82799v7.2448h-0.82799c-0.41399-1.242-0.82798-2.07-2.2769-2.277-0.41399-0.20699-1.449-0.20699-2.2769-0.20699h-6.0029v11.799h8.4868c3.7259 0 4.7609-1.449 5.5889-3.7259h0.82798l-0.82798 6.0029c-2.6909-0.207-4.3469-0.207-7.4518-0.207h-8.9008c-0.82798 0-3.9329 0.207-4.9679 0.207v-0.82798c1.656-0.41399 2.4839-1.035 2.4839-2.6909v-21.941c0-1.449-0.82798-2.2769-2.4839-2.4839zm-45.539 3.5189c0-1.449-0.82799-2.2769-2.484-2.6909v-0.82798c1.035 0 3.9329 0.207 4.9679 0.207 0.82798 0 3.9329-0.207 4.9679-0.207v0.82798c-1.656 0.41399-2.6909 1.035-2.6909 2.6909v21.734c0 1.449 0.82798 2.277 2.6909 2.6909v0.82798c-1.035 0-3.9329-0.207-4.9679-0.207-0.82799 0-3.9329 0.207-4.9679 0.207v-0.82798c1.863-0.41399 2.691-1.035 2.691-2.6909zm135.17 0c0-1.449-0.82798-2.2769-2.4839-2.6909v-0.82798c1.035 0 4.1399 0.207 4.9679 0.207s3.9329-0.207 4.9679-0.207v0.82798c-1.656 0.41399-2.4839 1.035-2.4839 2.6909v21.734c0 1.449 0.82798 2.277 2.4839 2.6909v0.82798c-1.035 0-3.9329-0.207-4.9679-0.207-0.82798 0-3.9329 0.207-4.9679 0.207v-0.82798c1.863-0.41399 2.4839-1.035 2.4839-2.6909zm24.839-3.3119c-9.7288 0-11.385-0.207-13.248-0.414v5.7959h0.82799c0.82798-2.6909 2.2769-3.3119 4.1399-3.3119h6.2098v22.769c0 1.449-0.82798 2.2769-2.6909 2.6909v0.82798c1.035 0 4.1399-0.20699 4.9679-0.20699 0.82797 0 3.9329 0.20699 4.9679 0.20699v-0.82798c-1.656-0.41399-2.6909-1.242-2.6909-2.6909v-22.769h6.0028c1.863 0 3.3119 0.62098 4.1399 3.3119h0.82799v-5.7959c-2.277 0.207-3.7259 0.414-13.455 0.414zm-78.037 25.046c0 1.449 0.82798 2.2769 2.6909 2.6909v0.82798c-1.035 0-4.1399-0.20699-4.9679-0.20699-0.82799 0-3.7259 0.20699-4.7609 0.20699v-0.82798c1.656-0.41398 2.484-1.035 2.484-2.6909v-21.941c0-1.449-0.82799-2.2769-2.484-2.4839v-0.82798c1.035 0 3.9329 0.207 4.7609 0.207 1.449 0 5.3819-0.207 7.0378-0.207 6.8308 0 10.557 2.8979 10.557 7.6588 0 3.7259-2.8979 6.4168-7.2448 7.4518 0 0 1.035 0.62099 2.07 1.656 1.242 1.449 4.5539 6.0029 5.7959 7.6588s3.1049 3.5189 4.9679 3.5189v0.62099c-0.82798 0.20699-2.2769 0.41399-3.3119 0.41399-2.2769 0-4.1399-0.82798-6.0028-2.8979-1.656-1.863-4.1399-5.7959-5.7959-7.8658-1.035-1.242-2.277-2.277-4.3469-2.6909-0.41399 0-0.82799-0.20699-1.242-0.20699zm0-11.592c0.82798 0.20699 2.2769 0.20699 3.5189 0.20699 5.3819 0 7.0378-3.1049 7.0378-5.7959 0-3.9329-2.484-6.2098-7.2448-6.2098-1.035 0-2.277 0.207-3.3119 0.41399zm-67.894-10.143c-0.62099-1.449-1.656-2.4839-3.3119-2.6909v-0.82798c1.035 0 4.5539 0.207 5.3819 0.207 0.62099 0 3.7259-0.207 4.7609-0.207v0.82798c-0.82799 0.207-2.07 0.62099-2.07 1.656 0 0.62099 0.414 1.656 1.242 3.3119l7.4518 16.767 7.0378-16.767c0.62099-1.449 1.035-2.4839 1.035-3.1049 0-0.82798-0.82798-1.449-2.07-1.656v-1.035c0.82799 0 3.1049 0.207 3.9329 0.207 0.62099 0 3.3119-0.207 4.3469-0.207v0.82798c-1.656 0.41399-2.8979 1.449-3.7259 3.7259l-10.35 24.218h-2.2769zm26.495-76.381c-1.242-2.6909-3.1049-4.5539-6.0029-5.1749v-1.449c1.863 0 8.2798 0.20699 9.7288 0.20699 1.242 0 7.4518-0.20699 9.5218-0.20699v1.449c-1.656 0.41399-3.7259 1.242-3.7259 3.1049 0 1.242 0.82799 3.1049 2.277 6.2098l14.076 31.877 13.248-31.877c1.035-2.4839 1.863-4.5539 1.863-6.0029 0-1.656-1.656-2.8979-3.7259-3.3119v-1.449c1.863 0 6.0029 0.20699 7.4518 0.20699 1.242 0 6.2098-0.20699 8.2798-0.20699v1.449c-3.3119 0.82798-5.3819 2.8979-7.2448 7.0378l-19.458 45.953h-4.3469zm-188.37 45.953c2.4839-0.62099 4.3469-1.656 4.3469-4.5539v-42.02c0-2.6909-1.656-3.9329-4.3469-4.5539v-1.656c1.242 0 7.0378 0.207 8.4868 0.207 1.656 0 7.6588-0.207 8.9008-0.207v1.449c-2.4839 0.62098-4.3469 1.656-4.3469 4.5539v17.802h31.463v-17.595c0-2.8979-1.656-4.1399-4.3469-4.5539v-1.656c1.242 0 7.2448 0.207 8.9008 0.207 1.449 0 7.2448-0.207 8.6938-0.207v1.449c-2.4839 0.62098-4.3469 1.656-4.3469 4.5539v42.02c0 2.6909 1.656 3.9329 4.3469 4.5539v1.449c-1.242 0-7.2448-0.207-8.6938-0.207-1.656 0-7.4518 0.207-8.9008 0.207v-1.242c2.4839-0.62099 4.3469-1.656 4.3469-4.5539v-19.872h-31.463v19.872c0 2.8979 1.656 3.9329 4.3469 4.5539v1.449c-1.242 0-7.4518-0.20699-8.9008-0.20699s-7.0378 0.20699-8.4868 0.20699zm362.66 0c3.3119-0.62099 4.9679-1.863 4.9679-4.7609v-41.813c0-2.8979-1.863-4.1399-4.9679-4.5539v-1.656c1.863 0 7.6588 0.207 9.3148 0.207 2.6909 0 9.9358-0.62099 15.732-0.62099 19.251 0 31.049 10.764 31.049 27.116 0 15.939-12.213 27.737-32.084 27.737-5.7959 0-12.42-0.41399-15.111-0.41399-1.656 0-7.0378 0.20699-8.9008 0.20699zm13.662-2.6909c2.07 0.41399 5.5889 0.62099 8.4868 0.62099 16.146 0 24.632-9.7288 24.632-23.39 0-14.076-8.9008-24.011-24.011-24.011-3.1049 0-7.0378 0.207-9.1078 0.62099zm-232.04-2.2769c0 2.6909 1.863 4.3469 4.9679 4.9679v1.449c-1.863 0-7.6588-0.20699-9.5218-0.20699-1.449 0-7.2448 0.20699-9.1078 0.20699v-1.449c3.1049-0.62099 4.7609-2.07 4.7609-4.9679v-41.399c0-2.4839-1.449-4.1399-4.7609-4.7609v-1.656c1.863 0 7.4518 0.207 9.1078 0.207 2.6909 0 10.143-0.41399 13.248-0.41399 13.041 0 20.286 5.3819 20.286 14.49 0 7.2448-5.3819 12.006-13.662 14.076 0 0 1.863 1.035 3.7259 3.3119 2.277 2.6909 8.6938 11.799 11.178 14.904 2.4839 3.1049 5.7959 6.6238 9.3148 6.6238v1.242c-1.656 0.41399-4.3469 0.62098-6.4168 0.62098-4.3469 0-7.8658-1.656-11.385-5.7959-2.8979-3.5189-8.0728-11.178-10.971-14.904-1.863-2.4839-4.1399-4.3469-8.2798-4.9679-0.82798-0.20699-1.656-0.20699-2.4839-0.41399zm0-21.941c1.656 0.20699 4.3469 0.41399 6.8308 0.41399 10.143 0 13.248-5.7959 13.248-10.971 0-7.2448-4.9679-11.799-13.662-11.799-1.863 0-4.5539 0.20699-6.4168 0.62098zm170.98 21.941c0 2.6909 1.863 4.3469 4.9679 4.9679v1.449c-1.863 0-7.6588-0.20699-9.3148-0.20699-1.449 0-7.2448 0.20699-9.1078 0.20699v-1.449c3.1049-0.62099 4.7609-2.07 4.7609-4.9679v-41.399c0-2.4839-1.449-4.1399-4.7609-4.7609v-1.656c1.863 0 7.4518 0.207 9.1078 0.207 2.6909 0 10.143-0.41399 13.041-0.41399 13.041 0 20.286 5.3819 20.286 14.49 0 7.2448-5.3819 12.006-13.662 14.076 0 0 1.863 1.035 3.7259 3.3119 2.277 2.6909 8.6938 11.799 11.178 14.904 2.4839 3.1049 5.7959 6.6238 9.3148 6.6238v1.242c-1.656 0.41399-4.3469 0.62098-6.4168 0.62098-4.3469 0-7.8658-1.656-11.385-5.7959-2.8979-3.5189-8.0728-11.178-10.971-14.904-1.863-2.4839-4.1399-4.3469-8.2798-4.9679-0.82799-0.20699-1.656-0.20699-2.484-0.41399zm0-21.941c1.656 0.20699 4.3469 0.41399 6.8308 0.41399 10.143 0 13.248-5.7959 13.248-10.971 0-7.2448-4.9679-11.799-13.662-11.799-1.863 0-4.5539 0.20699-6.4168 0.62098zm-249.64 26.909c3.5189-0.82798 5.3819-3.1049 6.6238-6.0029l17.388-41.813c0.82798-1.656 1.656-5.1749 1.656-5.1749h4.9679s0.82798 3.5189 1.656 5.3819l18.423 41.813c1.242 2.8979 2.6909 4.9679 6.4168 5.7959v1.449c-2.07 0-8.0728-0.20699-9.5218-0.20699s-7.2448 0.20699-9.3148 0.20699v-1.449c2.6909-0.62099 3.5189-2.07 3.5189-3.3119 0-1.035-0.41399-2.4839-1.035-3.7259l-3.9329-8.9008h-20.286l-3.5189 9.1078c-0.41399 1.035-0.82798 2.4839-0.82798 3.5189 0 1.449 0.82798 2.6909 3.7259 3.5189v1.449c-1.863 0-6.6238-0.207-7.6588-0.207l-7.8658 0.207zm34.568-20.286-8.6938-20.079-8.0728 20.079zm137.65 20.286c3.5189-0.82798 5.3819-3.1049 6.6238-6.0029l17.388-41.813c0.82798-1.656 1.656-5.1749 1.656-5.1749h4.9679s0.82798 3.5189 1.656 5.3819l18.423 41.813c1.242 2.8979 2.6909 4.9679 6.4168 5.7959v1.449c-2.07 0-8.0728-0.20699-9.5218-0.20699s-7.2448 0.20699-9.3148 0.20699v-1.449c2.6909-0.62099 3.5189-2.07 3.5189-3.3119 0-1.035-0.41399-2.4839-1.035-3.7259l-3.9329-8.9008h-20.286l-3.5189 9.1078c-0.41399 1.035-0.82798 2.4839-0.82798 3.5189 0 1.449 0.82798 2.6909 3.7259 3.5189v1.449c-1.863 0-6.6238-0.207-7.6588-0.207l-7.8658 0.207v-1.656zm34.361-20.286-8.6938-20.079-8.0728 20.079z" fill="#1e1e1e"/>
          <path d="m10.828 10.47h121.09v45.746c0 20.906-7.8658 65.41-60.029 98.53 0 0-56.717-23.597-61.064-98.53z" fill="#a51c30"/>
          <path d="m50.645 82.64c-0.30398-0.0124-0.56777 0.13931-0.78027 0.32343-0.41416 0.35893-0.66216 0.85504-0.67516 0.88135-0.46194 0.64671-1.434 0.80953-2.3166 0.78432-0.88254-0.0252-1.6414-0.22641-1.6414-0.22641l-0.04852-0.0124-0.04852 0.0166c-1.2688 0.42293-1.8336 0.96253-2.0659 1.4271-0.11614 0.23229-0.14554 0.4423-0.14554 0.5943 0 0.11923 0.01511 0.17181 0.02426 0.20617v4.7423c-0.04622 0.26144-0.16731 0.42151-0.33556 0.53368-0.17065 0.11385-0.3981 0.17408-0.62664 0.19809-0.45708 0.048-0.90156-0.0484-0.90156-0.0484h-0.0041c-1.5916-0.31832-2.683 0.0546-3.3637 0.51748-0.66954 0.45529-0.93697 0.98486-0.94603 1.0026-0.68088 0.92152-0.23044 2.2155-0.23044 2.2155v8e-3c0.04409 0.11758 0.09526 0.229 0.15363 0.33151 6.79e-4 2e-3 0.0081 0.0242 0.0081 0.0242 0.62098 1.656 2.8987 1.6535 2.8987 1.6535 0.82798 0.62099 2.2761 0.20617 2.2761 0.20617 0.42545 0 0.6728 0.17677 0.82475 0.40025 0.07549 0.30508 0.04043 0.61046 0.04043 0.61046l-0.0041 0.0364 0.0081 0.0323c0.01387 0.0551 0.04256 0.34237 0.05659 0.7358 0.01408 0.39344 0.01946 0.91134 0.02426 1.512 0.0097 1.2014 0.0048 2.7286-0.0081 4.2288-0.02587 3.0004-0.07682 5.8986-0.07682 5.8986 0 1.0123-0.19809 1.605-0.19809 1.605l-0.0081 0.0242v0.0281c0 0.0505-0.01656 0.0764-0.07278 0.1213-0.05616 0.0449-0.1551 0.0942-0.28704 0.12937-0.26387 0.0704-0.64228 0.0971-1.0228 0.0971-0.76114 0-1.5322-0.10101-1.5322-0.10101l-0.02029-4e-3 -0.02029 4e-3c-2.1555 0.21554-2.8229 2.1504-2.83 2.171v4e-3c-0.17085 0.40172-0.15593 0.80894-0.04043 1.1765 0.05796 0.18443 0.14214 0.3604 0.23853 0.52558 0.38476 0.93959 1.411 1.6737 1.411 1.6737 0 0.41399 3.9337 0.61857 3.9337 0.61857 0.23842 0.0596 0.40065 0.22721 0.52153 0.42854 0.01201 0.0368 0.0265 0.072 0.03639 0.10908 0.09673 0.3627 0.09702 0.70346 0.09702 0.70346-0.02946 0.11053-0.04078 0.23421-0.04852 0.41237-0.0087 0.20099-0.01304 0.4491-0.0081 0.72771 0.0097 0.55725 0.04198 1.239 0.08085 1.9002 0.07777 1.3222 0.18193 2.5632 0.18193 2.5632l0.0041 8e-3v8e-3c0.022 0.13206 0.08626 0.24608 0.16576 0.34769 4.1e-5 5e-4 0.0041 0.0364 0.0041 0.0364 0.207 1.242 4.1399 0.82879 4.1399 0.82879s13.785-0.31817 17.51-0.25874c0.53204 8e-3 0.8579 0.0267 0.90964 0.0526 0.41399 0 1.4514-0.20616 1.4514-0.20616l1.4473 1.035c0.58217 0.4528 1.1853 0.58193 1.7384 0.54578 0.11062-6e-3 0.22135-0.0211 0.32747-0.0404 1.0613-0.19209 1.8678-0.92177 1.8678-0.92177l2.07-0.41237c0.41399 0 17.182-0.20617 17.182-0.20617 1.449 0.41399 2.07-0.21023 2.07-0.21023l2.6885-0.20616c0.1035 0 0.20012-8e-3 0.29109-0.0242 0.65759-0.12047 0.99594-0.64634 1.1724-1.1603 0.0526-0.10205 0.10791-0.20368 0.14554-0.30724 0.21942-0.60339 0.21427-1.1967 0.21427-1.1967v-3.5011c0.0346-0.27692 0.0986-0.49329 0.1698-0.6873 0.37724-0.6652 0.9056-0.78027 0.9056-0.78027l2.4823-0.41641 1.2452-0.61857c0.47766-0.11943 0.72946-0.4535 0.87326-0.85708 0.0368-0.0575 0.0761-0.11219 0.10511-0.17388 0.17162-0.3647 0.22236-0.78943 0.22236-1.1926 0-0.80641-0.21427-1.5484-0.21427-1.5484l-4e-3 -0.0165-4e-3 -0.0166c-0.45321-0.90641-1.4986-1.2759-2.4015-1.4352-0.90291-0.15938-1.698-0.10515-1.698-0.10515h-4e-3c-0.99651 0.0996-1.3725-0.18567-1.5444-0.46493-0.17186-0.2793-0.1334-0.58217-0.1334-0.58217v-0.0124l0.21022-12.828c0.0817-0.48085 0.22147-0.86379 0.35982-1.1765 0.16189-0.30964 0.29917-0.49728 0.29917-0.49728 0.62099 0.20699 2.6885-0.41641 2.6885-0.41641 1.1896-0.11903 1.685-0.84835 1.9002-1.4514 0.019-0.0352 0.048-0.0702 0.0647-0.10516 0.27276-0.57281 0.27086-1.1004 0.27087-1.1158 0.11049-0.81175-0.45396-1.4825-1.0148-1.9365-0.56312-0.45587-1.1522-0.71964-1.1522-0.71964l-0.0324-0.0166h-2.9068c-0.0806-0.0166-0.14599-0.0592-0.21427-0.14966-0.0698-0.0923-0.13637-0.22935-0.18596-0.39619-0.0992-0.33367-0.14496-0.78426-0.15767-1.229-0.0254-0.88956 0.0768-1.7586 0.0768-1.7586l4e-3 -0.0124v-1.6645c0-0.80531-0.575-1.3707-1.1158-1.7223s-1.0754-0.50939-1.0754-0.50939l-0.0243-8e-3h-3.6911c-0.0835-0.13828-0.17651-0.27402-0.31535-0.36386-0.18348-0.11882-0.3957-0.20737-0.59834-0.27491-0.40529-0.13517-0.78028-0.18588-0.78028-0.18588-0.67478-0.21203-1.6778-0.21023-1.6778-0.21023h-0.0526l-0.0445 0.0284c-1.2887 0.89219-3.5497 1.2662-5.4781 1.3948-1.9284 0.12854-3.5213 0.0284-3.5213 0.0284l-6.4929-0.42045-0.05659 0.0526c0.01904-0.0186-0.02209 0.0145-0.08895 0.0364-0.06686 0.0224-0.16288 0.0493-0.27087 0.0729-0.21598 0.047-0.49062 0.0909-0.76006 0.12937-0.53888 0.077-1.0552 0.12937-1.0552 0.12937l-0.10511 8e-3 -0.03639 0.10515c-0.17837 0.53511-0.71963 0.71962-0.71963 0.71962l-0.57004 0.19396c-0.37827-0.3214-0.96829-0.56539-1.5282-0.73579-0.59087-0.17988-1.0814-0.27853-1.1037-0.283-0.0041-2e-3 -0.0083-6e-3 -0.01221-8e-3 -0.01967-8e-3 -0.03945-0.0124-0.05659-0.0166-0.0343-8e-3 -0.06684-0.0124-0.10915-0.0166-0.08462-8e-3 -0.19348-0.0103-0.32747-0.0124-0.268-2e-3 -0.63423 6e-3 -1.0673 0.0207-0.86618 0.0292-1.9989 0.0849-3.1251 0.14966-2.2504 0.12937-4.4715 0.28675-4.4755 0.28704-2.5663 0.10267-4.2996-0.30909-5.3891-0.73984-1.0896-0.43076-1.5201-0.86518-1.5201-0.86518-0.27334-0.37326-0.57524-0.55407-0.87326-0.56601zm-0.01221 0.3396c0.18116 8e-3 0.39083 0.10888 0.63069 0.44473l0.0041 8e-3 0.0081 0.0124s0.50173 0.49302 1.6374 0.94199c1.1356 0.44897 2.918 0.86845 5.5266 0.7641h0.0122s2.2217-0.15773 4.4714-0.28704c1.1248-0.0646 2.2561-0.12047 3.1171-0.14966 0.43046-0.0145 0.79682-0.0226 1.0552-0.0207 0.12919 1e-3 0.23068 6e-3 0.29917 0.0124 0.02861 2e-3 0.0472 6e-3 0.06065 8e-3l0.0081 8e-3 0.04852 0.0124s0.51354 0.1006 1.0997 0.27897c0.58612 0.17843 1.2508 0.45034 1.508 0.70749l0.07278 0.0729 0.71963-0.23854s0.44168-0.25893 0.73985-0.70749c-0.23048 0.56015-0.79645 0.75197-0.79645 0.75197l-0.61856 0.41642c-0.62098-0.62099-2.6926-1.035-2.6926-1.035-0.207-0.20699-9.1086 0.41238-9.1086 0.41238-5.1749 0.20699-7.0386-1.6535-7.0386-1.6535-1.035-1.449-2.07 0.61856-2.07 0.61856-1.035 1.449-4.1399 0.6226-4.1399 0.6226-1.1456 0.38184-1.6584 0.84969-1.8961 1.2452 0.01615-0.0722 0.04098-0.15069 0.08491-0.23852 0.17961-0.35922 0.66314-0.84286 1.8476-1.2452 0.06642 0.0166 0.75831 0.20099 1.6454 0.22639 0.92866 0.0265 2.0265-0.12358 2.5996-0.9258l0.0081-8e-3 0.0081-0.0124s0.25117-0.50015 0.60239-0.80453c0.17561-0.15214 0.36462-0.24579 0.54579-0.23854zm38.901 0.3113c0.0735 8.5e-4 1.0108 0.0124 1.5565 0.19395l0.0161 4e-3 0.0122 4e-3s0.35273 0.0503 0.72367 0.17388c0.18547 0.0619 0.37512 0.13972 0.52153 0.2345 0.0235 0.0145 0.0358 0.0327 0.0566 0.0484-0.49703-0.30602-1.2775-0.42045-1.2775-0.42045-0.62099-0.20699-1.6576-0.20616-1.6576-0.20616-2.6909 1.863-9.1086 1.4514-9.1086 1.4514l-6.416-0.41641c-0.20462 0.20451-2.2053 0.4077-2.2519 0.41238 0.0087-0.0145 0.02008-0.0255 0.0283-0.0404 0.03014-2e-3 0.50374-0.0495 1.035-0.12544 0.27392-0.0391 0.55396-0.0834 0.78432-0.1333 0.11517-0.025 0.21726-0.0522 0.30322-0.0809 0.04823-0.0166 0.08508-0.0441 0.12534-0.0646l6.3837 0.40834s1.6171 0.10598 3.5699-0.0242c1.9299-0.12875 4.1891-0.47398 5.5953-1.419zm3.2424 1.0309h3.7194c0.012 4e-3 0.30768 0.11736 0.6509 0.29513-0.34699-0.17325-0.6226-0.25874-0.6226-0.25874h-3.7275c-4e-3 -0.0124-0.0149-0.0238-0.0203-0.0364zm4.4391 0.33152c0.0888 0.048 0.16183 0.0731 0.2547 0.13331 0.0255 0.0166 0.0475 0.0393 0.0728 0.0565-0.11175-0.0718-0.22143-0.13476-0.32747-0.19003zm1.4756 6.7152c0.0231 0.0391 0.042 0.0818 0.0687 0.11716 0.10573 0.13972 0.24873 0.24783 0.4245 0.283l0.0161 4e-3h2.8704c0.0244 0.0103 0.53954 0.24887 1.0511 0.66303 0.3586 0.29029 0.67402 0.65385 0.81666 1.0552-0.37053-0.59559-1.054-1.052-1.4716-1.2897-0.21022-0.11964-0.35577-0.18195-0.35577-0.18195h-2.8947c-0.25345-0.0507-0.41855-0.30328-0.52557-0.65089zm-55.674 0.63069c-0.52048 0.98482-1.9689 0.63877-1.9689 0.63877-3.1049-0.62099-4.1399 1.4514-4.1399 1.4514-0.02828 0.0377-0.04461 0.078-0.06872 0.11716 0.04705-0.15214 0.11072-0.29989 0.21023-0.43257l0.0162-0.0248s0.23593-0.47659 0.849-0.89348c0.61229-0.41637 1.5908-0.76555 3.1009-0.46493 0 0 0.48457 0.10805 1.0107 0.0526 0.26307-0.0277 0.5434-0.0927 0.78027-0.25065 0.07822-0.0522 0.14593-0.12027 0.21023-0.19396zm55.408 20.493c0.25023 0.38096 0.79493 0.70536 1.8395 0.60238 0 0 0.7606-0.0501 1.6172 0.10101 0.85464 0.1509 1.7704 0.50313 2.1468 1.2493 1e-3 4e-3 0.0237 0.10784 0.0323 0.14158-0.97079-1.4342-3.8084-1.2492-3.8084-1.2492-1.3533 0.13537-1.7264-0.43233-1.8274-0.84495zm-55.699 0.97433c-0.0029 0.0103-0.02029 0.0768-0.02029 0.0768 0 0.1035-0.04852 0.19085-0.13341 0.25875-0.08491 0.0679-0.20619 0.11881-0.35173 0.15773-0.87326 0.23287-2.6198 0-2.6198 0-1.4984 0.14986-2.2328 1.1596-2.5268 1.7101 0 0 0.57573-1.7519 2.543-1.9527 0.03502 4e-3 0.76733 0.10101 1.5403 0.10101 0.39566 0 0.78944-0.0242 1.1077-0.10908 0.15916-0.0424 0.30278-0.0992 0.41642-0.19002 0.0178-0.0145 0.02859-0.0358 0.04446-0.0526zm14.421-88.284-0.06065 0.0526c-3.2303 2.6246-7.924 1.415-7.924 1.415l-0.02029-4e-3h-0.02028c-4.559 0-6.0279 0.20617-6.0279 0.20617l-0.06469 0.0124-0.04043 0.0484c-0.47117 0.56541-1.0487 0.55744-1.5565 0.41238-0.49573-0.14179-0.87155-0.41929-0.88943-0.4326-0.09327-0.1362-0.24237-0.21372-0.40429-0.27087-0.18334-0.0648-0.39339-0.10267-0.5943-0.12938-0.40183-0.0536-0.77219-0.0565-0.77219-0.0565h-0.0081l-0.0041 4e-3c-4.5427 0.30973-7.3753 0.0497-9.0641-0.283-0.84441-0.16622-1.4022-0.35235-1.7465-0.49323-0.34435-0.14096-0.46493-0.23045-0.46493-0.23045l0.02029 0.0207c-0.06589-0.0658-0.1291-0.0898-0.20619-0.11322-0.07709-0.0234-0.16578-0.0412-0.26279-0.0565-0.19402-0.0306-0.42381-0.0476-0.64686-0.0607-0.44609-0.0269-0.86517-0.0284-0.86517-0.0284h-0.10511l-0.04852 0.0929c-0.18002 0.36003-0.73813 1.1155-0.78027 1.1724-0.02509 8e-3 -0.08077 0.0248-0.18193 0.0364-0.11672 0.0124-0.26899 0.0236-0.44067 0.0284-0.34337 0.0103-0.7684 4e-3 -1.1805-8e-3 -0.82423-0.0257-1.5969-0.0768-1.5969-0.0768l-0.0081-4e-3h-0.0041c-0.86334 0-1.383 0.27929-1.6737 0.57004-0.29075 0.29075-0.35577 0.60238-0.35577 0.60238l-0.0041 0.0124-0.20619 3.958v0.0124c0.1024 1.2287-0.02157 1.726-0.10511 1.8597-0.04177 0.0669-0.04276 0.0526-0.04446 0.0526l-0.1415-0.0929-0.09702 0.14158c-0.05401 0.0809-0.26028 0.19044-0.55387 0.25469-0.2936 0.0642-0.65843 0.0965-1.0148 0.10909-0.71267 0.0255-1.3786-0.0242-1.3786-0.0242l-0.01615-4e-3 -0.01615 4e-3c-0.56236 0.0563-0.98321 0.33148-1.2775 0.69941-0.29434 0.36794-0.47091 0.82314-0.57813 1.2654-0.21444 0.88457-0.15767 1.7344-0.15767 1.7344v0.0204c0.11236 0.56178 0.43267 0.95609 0.83283 1.2088 0.40016 0.25272 0.87836 0.37493 1.3341 0.42854 0.88644 0.10432 1.6653-0.0443 1.7101-0.0526h0.0041c1.1019 0.10143 1.5021 0.44194 1.6495 0.71558 0.14765 0.27423 0.06469 0.51345 0.06469 0.51345l-0.0081 0.0242v0.0284c0 0.42813 0.05336 3.8318 0.10511 7.1438 0.05156 3.2997 0.10068 6.4732 0.10108 6.4969-0.04924 0.44311-0.16806 0.72154-0.30726 0.89349-0.1392 0.17202-0.29812 0.24639-0.46089 0.27895-0.32552 0.0652-0.6509-0.0646-0.6509-0.0646l-0.03235-0.0166h-0.03235c-2.3155 0-3.3802 0.80817-3.8246 1.6414-0.44229 0.82928-0.27649 1.6498-0.27492 1.6576 0.11358 1.5028 1.0608 2.1959 1.9527 2.4661 0.89502 0.27123 1.7506 0.16166 1.7506 0.16166l-0.02028 4e-3c1.1076 0 1.5616 0.29245 1.7546 0.54984 0.19304 0.25738 0.1496 0.49323 0.1496 0.49323l-0.0081 0.0526 0.02426 0.0526c-7e-3 -0.0145 0.02422 0.10557 0.03233 0.26279 0.0081 0.1571 0.01283 0.36621 0.0081 0.60643-0.0095 0.48043-0.04214 1.0881-0.08085 1.6818-0.07744 1.1875-0.18193 2.3247-0.18193 2.3247v0.0207l0.0041 0.0242c0.21639 1.1901 0.90463 1.6785 1.5242 1.8193 0.5741 0.1304 1.0472-4e-3 1.1199-0.0242h0.0081l16.523 0.41641c2.3589 1.7184 3.8822 1.7679 4.7948 1.2978 0.87348-0.44999 1.1029-1.2534 1.132-1.3463l0.28704 0.0445c0.18466 0.0308 0.54618 0.0464 1.0754 0.0607 0.52923 0.0145 1.2154 0.0234 2.0053 0.0283 1.5797 0.0104 3.5719 4e-3 5.5387-8e-3 1.9668-0.0124 3.9101-0.0323 5.3851-0.0484 1.4681-0.0166 2.4737-0.0282 2.5713-0.0284h0.01221c0.67857 0.1509 1.2086 0.11674 1.6171-0.0404 0.41616-0.16 0.69793-0.44354 0.88134-0.73984 0.36465-0.58904 0.3639-1.2374 0.36386-1.2452v-8e-3l0.20619-4.9323c0.08416-0.32414 0.43606-0.56175 0.80049-0.70751 0.35269-0.14117 0.67098-0.1865 0.69538-0.19002 2.2979 0.30374 3.4244-0.50679 3.9175-1.411 0.49361-0.90494 0.38499-1.8719 0.38407-1.8799v-4e-3c-0.10931-1.5063-1.002-2.2496-1.8435-2.5753-0.84241-0.3261-1.6495-0.26684-1.6495-0.26684l0.01221-4e-3c-1.0973 0-1.601-0.38151-1.8557-0.75197-0.25343-0.36864-0.2547-0.72419-0.2547-0.72773v-4e-3c0.05734-0.3598 0.09247-1.2519 0.12128-2.4621 0.02914-1.2241 0.04771-2.7374 0.06065-4.2127 0.02587-2.9506 0.0283-5.7449 0.0283-5.7449 0-0.25392 0.14405-0.66315 0.29513-0.99049 0.13221-0.28642 0.23185-0.45276 0.26279-0.50538 1.2749 0.12978 2.2488 0.0536 2.9311-0.19002 0.71238-0.25442 1.151-0.66992 1.4029-1.1037 0.49808-0.85779 0.27581-1.7621 0.27087-1.7829 0.09441-0.77754-0.02235-1.3657-0.29513-1.7748-0.27902-0.41852-0.69378-0.65203-1.1077-0.77623-0.80259-0.24075-1.6034-0.0944-1.6535-0.0849-1.4166 0-1.9024-0.39267-2.074-0.7358-0.1715-0.34467-0.0444-0.69286-0.0444-0.69286l0.0041-0.0165 0.0041-0.0166c0.31326-1.984 0.21016-3.3524 0.02426-4.2288-0.1859-0.87642-0.46897-1.2776-0.46897-1.2776l-0.01614-0.0242-0.0283-0.0207c-0.21138-0.14096-0.51631-0.19458-0.88539-0.23448-0.36908-0.04-0.79603-0.0526-1.2007-0.0526-0.80941 0-1.5363 0.0526-1.5363 0.0526l-0.05256 4e-3 -0.03639 0.0283c-0.14815 0.11116-0.30848 0.0987-0.52962-0.0124-0.22113-0.11053-0.46989-0.32394-0.69538-0.56195-0.45097-0.47602-0.80857-1.035-0.80857-1.035l-0.04043-0.0607zm58.581 0-0.0606 0.0526c-3.2303 2.6246-7.924 1.415-7.924 1.415l-0.0203-4e-3h-0.0243c-4.3523 0-5.8177 0.20617-5.8177 0.20617l-0.0647 0.0124-0.0404 0.0484c-0.47117 0.56541-1.0487 0.55744-1.5565 0.41238-0.48852-0.13952-0.85675-0.4076-0.88539-0.42856-0.093-0.13931-0.24453-0.2171-0.40833-0.27491-0.18333-0.0648-0.39338-0.10267-0.5943-0.12938-0.40183-0.0536-0.77219-0.0565-0.77219-0.0565h-8e-3l-4e-3 4e-3c-4.5427 0.30973-7.3753 0.0497-9.0641-0.283-0.84441-0.16622-1.4022-0.35235-1.7465-0.49323-0.34435-0.14096-0.46493-0.23045-0.46493-0.23045l0.02029 0.0207c-0.06589-0.0658-0.13316-0.0898-0.21023-0.11322-0.07708-0.0234-0.16172-0.0412-0.25874-0.0565-0.19402-0.0306-0.42785-0.0476-0.6509-0.0607-0.4461-0.0263-0.86113-0.0284-0.86113-0.0284h-0.10511l-0.04852 0.0929c-0.18046 0.36092-0.74475 1.123-0.78432 1.1765-0.02689 8e-3 -0.08303 0.0211-0.18193 0.0323-0.11672 0.0124-0.26494 0.0236-0.43663 0.0284-0.34337 0.0103-0.7684 4e-3 -1.1805-8e-3 -0.82423-0.0257-1.601-0.0768-1.601-0.0768l-0.0041-4e-3h-0.0041c-0.96291 0-1.5289 0.27222-1.8476 0.56195-0.31872 0.28975-0.39216 0.61047-0.39216 0.61047v4.1887c0.10219 1.1242-0.0268 1.5698-0.10108 1.6737-0.03714 0.052-0.03374 0.0327-0.04043 0.0323-0.0066-3.9e-4 -0.01221 0-0.01221 0l-0.13746-0.0929-0.09702 0.14159c-0.05401 0.0809-0.26028 0.19043-0.55387 0.25468-0.2936 0.0642-0.66247 0.0965-1.0188 0.10909-0.71267 0.0255-1.3786-0.0242-1.3786-0.0242l-0.01221-4e-3 -0.01615 4e-3c-0.61011 0.0555-1.0697 0.3243-1.3948 0.69132-0.32509 0.36705-0.52188 0.82604-0.64282 1.2695-0.24188 0.88687-0.18596 1.7384-0.18596 1.7384v8e-3l0.0041 0.0124c0.11236 0.56178 0.43267 0.95609 0.83283 1.2088 0.40016 0.25272 0.87432 0.37493 1.3301 0.42854 0.8865 0.10433 1.6694-0.0443 1.7142-0.0526h0.0041c1.1019 0.10143 1.4981 0.44194 1.6454 0.71559 0.14765 0.27422 0.06872 0.51345 0.06872 0.51345l-0.0041 4e-3v8e-3c-0.03919 0.15669-0.05045 0.42434-0.06469 0.85708-0.01428 0.43274-0.02343 1.0051-0.0283 1.6657-0.0097 1.3212-0.0048 3.005 0.0081 4.6614 0.02579 3.3005 0.08048 6.4732 0.08085 6.4969-0.04922 0.44312-0.1721 0.72155-0.3113 0.8935-0.1392 0.17201-0.29812 0.24638-0.46089 0.27894-0.32552 0.0652-0.64686-0.0646-0.64686-0.0646l-0.03235-0.0166h-0.03639c-2.3155 0-3.3802 0.80817-3.8246 1.6414-0.44229 0.82928-0.27649 1.6498-0.27492 1.6576 0.1136 1.5028 1.0608 2.1959 1.9527 2.4661 0.89502 0.27123 1.7546 0.16167 1.7546 0.16167l-0.02029 4e-3c1.001 0 1.4547 0.29018 1.6778 0.55791 0.22312 0.26775 0.22236 0.51345 0.22236 0.51345v0.0404l0.01614 0.0364c-7e-3 -0.0145 0.0242 0.10557 0.03235 0.26279 0.0081 0.1571 0.0089 0.36621 0.0041 0.60643-0.0095 0.48043-0.04214 1.0881-0.08085 1.6818-0.07744 1.1875-0.17789 2.3247-0.17789 2.3247l-0.0041 0.0207 0.0041 0.0242c0.21639 1.1901 0.90868 1.6785 1.5282 1.8193 0.5736 0.1304 1.0465 1e-3 1.1199-0.0207h0.0081l16.523 0.41643c2.3589 1.7184 3.8782 1.7679 4.7908 1.2978 0.88-0.45334 1.163-1.313 1.1886-1.3948l4e-3 -4e-3c0.0744-0.14262 0.23249-0.21022 0.3113-0.21022 0.0399 0 0.0364 8e-3 0.0283-4e-3 -8e-3 -0.0124 8e-3 -4e-3 -0.0283 0.0687l-0.10107 0.20617 0.2264 0.0364c0.18466 0.0308 0.54617 0.0464 1.0754 0.0607 0.52923 0.0145 1.2154 0.0234 2.0053 0.0284 1.5797 0.0104 3.5719 4e-3 5.5387-8e-3 1.9668-0.0124 3.9061-0.0323 5.3811-0.0484 1.475-0.0166 2.4981-0.0284 2.5874-0.0284 0.72762 0.15049 1.283 0.11281 1.702-0.0445 0.42644-0.1598 0.70623-0.4445 0.87731-0.74388 0.34216-0.5988 0.27896-1.2654 0.27896-1.2654l4e-3 0.0242 0.20618-4.9404c0.0842-0.32413 0.43202-0.56174 0.79645-0.70751 0.35593-0.14241 0.68055-0.18319 0.69941-0.18588 2.298 0.30381 3.4244-0.51082 3.9176-1.415 0.49361-0.90495 0.38095-1.8679 0.38003-1.8759v-8e-3c-0.10932-1.5063-0.99797-2.2496-1.8395-2.5753-0.8424-0.3261-1.6535-0.26684-1.6535-0.26684l0.0161-4e-3c-1.2042 0-1.698-0.38569-1.9244-0.74794-0.2264-0.36224-0.18193-0.71558-0.18193-0.71558v-0.0204c0-1.2231 0.20619-12.416 0.20619-12.416v-4e-3c0-0.25392 0.14404-0.66315 0.29513-0.99049 0.13224-0.28655 0.23596-0.45289 0.26682-0.50538 1.2749 0.12978 2.2488 0.0536 2.9311-0.19002 0.71237-0.25442 1.151-0.66992 1.4029-1.1037 0.49807-0.85779 0.27581-1.7621 0.27087-1.7829 0.0944-0.77753-0.0264-1.3657-0.29917-1.7748-0.27901-0.41852-0.69379-0.65203-1.1078-0.77623-0.80573-0.24171-1.6096-0.0931-1.6535-0.0849-1.4166 0-1.8984-0.39267-2.07-0.7358-0.17158-0.34314-0.0445-0.69132-0.0445-0.69132l8e-3 -0.0332c0.31325-1.984 0.21016-3.3524 0.0243-4.2288-0.1859-0.87641-0.46897-1.2776-0.46897-1.2776l-0.0203-0.0242-0.0243-0.0207c-0.21137-0.14096-0.51632-0.19457-0.88539-0.23448-0.36908-0.04-0.79604-0.0526-1.2007-0.0526-0.8094 0-1.5403 0.0526-1.5403 0.0526l-0.0485 4e-3 -0.0404 0.0284c-0.14815 0.11115-0.30444 0.0987-0.52558-0.0124-0.22114-0.11054-0.47393-0.32395-0.69941-0.56195-0.45098-0.47603-0.80453-1.035-0.80453-1.035l-0.0404-0.0607z"/>
          <path d="m71.685 155.36-0.41399-0.207c-0.41399-0.20699-56.924-24.632-61.271-98.944v-46.574h122.54v46.367c0 18.216-5.7959 64.582-60.443 98.944zm-60.236-144.28v44.918c4.1399 70.378 55.475 95.632 60.236 97.702 53.612-34.154 59.408-79.693 59.408-97.702v-44.918z"/>
          <path d="m28.215 27.03s-1.242 8e-4 -1.035 0.82878l-0.41237 31.462s-8.06e-4 1.4506 2.2761 1.6576c0 0 2.8963 0.207 3.5173 0h6.6263s1.2412 1.2388 1.2412-0.21022c0 0 0.82636-25.457 0.41237-30.839 0 0-8.1e-4 -2.2802-1.8638-2.2802 0 0-7.4486 0.62099-8.0696 0zm28.733 0.0484c-0.27289-0.0242-0.71236 0.0534-1.411 0.36386 0 0 0.21022 0.8304-9.1045 0.41641-0.207 0-3.7267-2e-3 -3.9337 1.4474 0 0-0.20619 14.904-0.20619 15.318l-0.21023 12.42-0.20619 4.3461s0.62099 0.82717 1.035 0.20616c0 0 3.1049-0.82636 5.1749-0.41237 0 0 6.2123 0.61856 7.6612-0.41641 0 0 1.0342 0.41399 1.2412-1.035 0 0 0.41318-27.53 0.20619-27.944 0 0 0.41318-3.9321 0.20619-4.3461 0 0 2e-3 -0.32343-0.4528-0.36386zm-34.126 0.7722c-0.40631 0.0124-0.99778 0.26682-1.8516 1.043l-0.20619 4.1399s-2e-6 2.2769-2.07 2.07c0 0-2.2794 0-3.5213 1.035 0 0-0.61937 2.0667 1.6576 1.8597 0 0 3.5205 2e-3 3.7275 1.4514l-0.21023 14.902s0.83121 2.4864-1.8597 2.4864c0 0-3.3152-0.21022-3.3152 1.8597 0 0 0.62341 1.6592 3.5213 1.2452 0 0 2.0708 0.41318 1.8638 2.2761v3.7235s-0.21023 1.4506 1.8597 1.6576h15.318s0.82879-8.1e-4 0.82879-0.82879c0 0 8.07e-4 -0.82879-1.2412-0.82879l-12.626-0.41229s-2.0732 0.6226-2.2802-2.4823c0 0 0.20041-26.58 0.20619-27.75 1.18e-4 4.7e-4 0.0041 0.0124 0.0041 0.0124s-0.0035-0.0977-0.0041-0.10909c5e-5 -0.0104 0.0041-0.30275 0.0041-0.30726-0.0039-8e-3 -0.0043-8e-3 -0.0081-0.0166-0.02198-1.0173-0.02587-4.6183 1.0431-6.3999 0 0-0.16373-0.64686-0.84092-0.62664zm39.196 0.0768c-0.88822 0.0768-0.88943 1.1724-0.88943 1.1724 0.41399 0.41399 0.61856 1.8638 0.61856 1.8638 0.207 3.3119 0 7.037 0 10.556-0.207 11.799-0.61856 22.563-0.61856 22.563 0 2.2769-1.2412 1.6535-1.2412 1.6535h-13.665c-1.449 0-1.4473 0.82879-1.4473 0.82879 0.207 1.242 1.4473 0.82879 1.4473 0.82879 1.242 0.20699 14.906 0 14.906 0 2.0699 0.20699 1.8638-2.4864 1.8638-2.4864 0.207-4.7609 0.61856-5.1749 0.61856-5.1749 0.41399-0.20699 2.6926-0.20616 2.6926-0.20616 3.7259 0.20699 2.07-2.2761 2.07-2.2761-0.41399-0.62099-2.8987-0.6226-2.8987-0.6226-2.2769 0.20699-2.07-2.2761-2.07-2.2761l0.20619-14.283c-0.41399-1.242 0.6226-1.8597 0.6226-1.8597h2.2761c3.1049 0.207 2.2761-1.8638 2.2761-1.8638 0-1.035-2.6885-1.4514-2.6885-1.4514-2.4839 0.41399-2.2802-1.035-2.2802-1.035v-3.5172c0.41399-2.277-1.035-2.2761-1.035-2.2761-0.31049-0.11633-0.55913-0.15524-0.7641-0.13744zm-2.923 0.4609c-0.2641 0.0354-0.55468 0.24581-0.86518 0.71154v31.049s0.82798 2.6893 2.07 2.4823c0 0 0.20619-0.61856 0.20619-1.6535l0.41641-29.602s-0.68294-3.1414-1.8274-2.9877zm-33.362 0.29513c-1.863 0-2.07 3.5213-2.07 3.5213l-0.21023 29.392c0.207 1.449 0.6226 1.2412 0.6226 1.2412 1.863-1.242 1.6576-3.3111 1.6576-3.3111s0.20619-27.943 0.20619-28.357-0.20619-2.4864-0.20619-2.4864zm0.86113 33.107c-0.08839 4e-3 -0.1876 0.0186-0.29109 0.0484-0.41397 0.11819-0.92443 0.47429-1.3544 1.3341l-0.0081 0.0166-0.0041 0.0166s-0.12287 0.38582-0.0283 0.7641c0.0473 0.1892 0.16835 0.38984 0.38812 0.49325 0.21239 0.1 0.49377 0.1035 0.86113 4e-3h10.107l2.7128 0.62664 0.03639-8e-3s0.19389-0.0447 0.43259-0.13351c0.23871-0.0886 0.52976-0.21846 0.74389-0.43258 0.10706-0.10702 0.19654-0.239 0.23449-0.39621 0.03794-0.15732 0.01739-0.33763-0.06469-0.51343-0.16408-0.3516-0.55396-0.70929-1.2937-1.132l-0.04043-0.0242h-9.7554c-0.01511-4e-3 -0.45596-0.0998-0.9622-0.22639-0.51477-0.12875-1.1035-0.29907-1.2573-0.37599l-0.0081-4e-3h-0.0041s-0.17957-0.0708-0.44472-0.0565zm30.754 0.54579c-0.58217-0.0292-1.3948 0.089-1.3948 0.089-1.656 1.035-11.385 0.20617-11.385 0.20617-0.62098 0-1.4514 1.035-1.4514 1.035-0.207 1.863 2.8995 1.035 2.6926 1.035h11.591c1.863 0.41399 1.8638-0.41237 1.8638-0.41237 0-0.62099-1.4473-1.8638-1.4473-1.8638-0.1035-0.0517-0.27492-0.0793-0.46897-0.089zm-15.314 2.3206c-0.05305 4e-3 -0.10592 0.0186-0.15767 0.0445 0 0-1.8638 2e-3 -1.8638 2.4864 0 0 0.207 1.8597 2.07 1.8597 0 0 1.6576-0.41318 1.6576-2.2761 0 0-0.91015-2.1826-1.7061-2.1144zm44.552-37.627s-1.242 8.1e-4 -1.035 0.82879l-0.41237 31.462s-8.07e-4 1.4506 2.2761 1.6576c0 0 2.9004 0.207 3.5213 0h6.6222s1.2412 1.2396 1.2412-0.41641c0 0 0.83041-25.461 0.41642-30.843 0 0-8.1e-4 -2.2761-1.8638-2.2761 0 0-7.4526 0.62099-8.0736 0zm28.652 0.25471c-0.2446 0.0103-0.60239 0.10516-1.1199 0.36386 0 0 0.20619 0.8304-9.1086 0.41641-0.20699 0-3.9337-0.20861-3.9337 1.4474 0 0-0.20619 14.904-0.20619 15.318l-0.20619 12.42-0.41237 4.3461s0.62099 0.82718 1.035 0.20617c0 0 3.1049-0.82636 5.1749-0.41237 0 0 6.2082 0.6226 7.6572-0.41238 0 0 1.0342 0.41399 1.2412-1.035 0 0 0.41318-27.53 0.20619-27.944 0 0 0.41722-3.9361 0.21023-4.3501 0 0 4e-4 -0.38833-0.5377-0.36386zm-34.251 0.56601c-0.40631 0.0124-0.99778 0.26682-1.8516 1.043v3.9297s-2e-6 2.277-2.07 2.07c0 0-2.2753 0-3.5173 1.035 0 0-0.62341 2.0708 1.6535 1.8638 0 0 3.5205 2e-3 3.7275 1.4514l-0.20619 14.902s0.82798 2.4823-2.07 2.4823c0 0-3.3111-0.20617-3.3111 1.8638 0 0 0.61937 1.6552 3.5173 1.2412 0 0 2.07 0.41722 2.07 2.2802v3.7235s-0.20538 1.4506 1.6576 1.6576h15.314s0.82879-8.1e-4 0.82879-0.82879c0 0 8e-4 -0.82879-1.2412-0.82879l-12.42-0.20616s-2.0691 0.6226-2.2761-2.4823c0 0 0.207-27.741 0-28.155v0.41642s-0.207-4.7625 1.035-6.8324c0 0-0.16373-0.64686-0.84092-0.62664zm39.402 0.0768c-0.88822 0.0768-0.88944 1.1724-0.88944 1.1724 0.207 0.41399 0.62261 1.8638 0.62261 1.8638 0.20699 3.3119 0 7.037 0 10.556-0.207 11.799-0.62261 22.563-0.62261 22.563 0 2.2769-1.2412 1.6535-1.2412 1.6535h-13.661c-1.449 0-1.4514 0.82879-1.4514 0.82879 0.207 1.242 1.6576 0.8296 1.6576 0.6226 1.242 0.207 14.902 0 14.902 0 2.07 0.207 1.8638-2.4864 1.8638-2.4864 0.207-4.7609 0.62261-5.1749 0.62261-5.1749 0.41398-0.20699 2.6885-0.20616 2.6885-0.20616 3.5189 0.20699 1.8638-2.2761 1.8638-2.2761-0.41399-0.62098-2.8987-0.6226-2.8987-0.6226-2.2769 0.207-2.07-2.2761-2.07-2.2761l0.21023-14.283c-0.41399-1.242 0.61856-1.8638 0.61856-1.8638h2.2761c3.1049 0.20699 2.2802-1.8597 2.2802-1.8597 0-1.035-2.6926-1.4514-2.6926-1.4514-2.4839 0.41399-2.2761-1.035-2.2761-1.035v-3.311c0.41398-2.277-1.035-2.2761-1.035-2.2761-0.31049-0.11633-0.56317-0.15524-0.76814-0.13744zm-2.923 0.53772c-0.2641 0.0217-0.55468 0.2078-0.86517 0.63472v31.049s0.82798 2.6893 2.07 2.4823c0 0 0.21022-0.61856 0.21022-1.6535l0.41238-29.602s-0.68295-3.0048-1.8274-2.9109zm-33.362 0.21831c-1.863 0-2.07 3.5213-2.07 3.5213l-0.20619 29.392c0.207 1.449 0.61856 1.2412 0.61856 1.2412 1.863-1.242 1.6576-3.3111 1.6576-3.3111s0.20619-27.943 0.20619-28.357-0.20619-2.4864-0.20619-2.4864zm1.1846 33.075c-0.36133-0.0103-1.0277 0.15111-1.5969 1.2897 0 0-0.41399 1.449 1.035 1.035h10.14l2.6926 0.61856s2.8979-0.62018 0-2.2761h-9.7271s-1.8662-0.4156-2.2802-0.6226c0 0-0.09855-0.0393-0.26279-0.0445zm30.544 0.368c-0.52557 0.0103-1.0916 0.0929-1.0916 0.0929-1.656 1.035-11.385 0.20616-11.385 0.20616-0.62098 0-1.4514 1.035-1.4514 1.035-0.41399 1.863 2.6926 1.035 2.6926 1.035h11.591c1.863 0.41399 1.8638-0.41237 1.8638-0.41237 0-0.62099-1.4514-1.8638-1.4514-1.8638-0.15525-0.0776-0.45281-0.099-0.76815-0.093zm-15.217 2.3246c-0.0546 4e-3 -0.10592 0.0186-0.15766 0.0445 0 0-1.8646-2e-3 -1.6576 2.4823 0 0 0.20699 1.8638 2.07 1.8638 0 0 1.6576-0.20616 1.6576-2.2761 0 0-1.0936-2.1826-1.9123-2.1144zm-30.793 40.202s0 2.2769-0.207 4.5539c-0.207 1.242 0.41399 7.0378 0 9.9358 0 0 0 1.035-2.07 0.20699 0 0-12.627 0.20699-12.834-0.20699 0 0-3.5189 0.20699-3.7259-1.656 0 0 0.41399-13.455 0.207-13.869 0 0-0.207-7.2448 0-8.0728 0 0 0.207-6.8308 0-7.6588 0 0 0-1.656-0.207-2.2769 0 0 0-1.035 1.656-0.41399 0 0 0.62098 1.035 3.7259 0.62098 0 0 2.2769 0.41399 4.5539 0 0 0 4.9679-0.41399 6.2098 0 0 0 2.07-0.41399 2.4839 1.863v6.0028l0.62098 2.07 0.62098-0.41399 0.207-1.449v-6.4168s0.41399-1.242 2.07-1.449c0 0 2.4839-0.207 2.8979 0 0.41399 0.20699 5.7959 0.41399 7.2448 0.20699 1.449-0.20699 1.656 1.035 6.2099-1.242 0 0 1.242 0 1.242 0.82798 0 0-0.41398 8.2798 0 9.9358 0 0 0 15.318-0.41398 16.353l0.20699 4.9679s0.207 2.07-3.3119 2.2769c0 0 2.07 0.207-11.385-0.20699 0 0-2.07-0.207-4.5539 1.035 0 0-0.41399-0.20699-0.41399-1.449 0 0 0.41399-4.5539 0-9.1078l-0.207-4.9679zm21.734 13.455s1.242 2.2769 1.656 2.4839c0 0 1.035 1.242 0.82798-1.035l0.207-28.358s-0.207-1.035 0-2.4839l-1.242-2.07s-1.242-1.035-1.242 0.62099v30.014zm-41.192 1.242s1.449 1.449 3.7259 1.449l13.248 0.207s1.449 0.20699 1.449 0.82798c0 0-0.207 1.242-2.07 0.82798l-16.146-0.20699-1.863 0.20699s-1.242-0.20699 0.62098-2.4839zm-2.8979-32.498s-1.242 2.07-1.035 2.6909v32.705s-0.207 2.277 1.656 1.656c0 0 17.181-0.41399 18.423 0 0 0 1.656 0.207 1.035 1.035 0 0 0 0.62098-1.035 0.41399 0 0-8.0728 0.82798-15.525 0.41398 0 0-4.9679 0.207-5.1749-0.20699 0 0-0.82798-0.20699-0.82798-2.8979 0 0 0-2.6909-0.207-3.1049 0 0 0.207-1.449-2.2769-1.656 0 0-3.5189 0.62099-3.5189-1.449 0 0 0.41399-1.449 3.9329-1.242 0 0 2.4839 0.41399 1.863-1.656l0.207-14.49s0.41399-2.4839-1.449-2.6909h-2.07s-2.8979 0-2.6909-1.656c0 0 1.035-1.656 3.9329-1.449 0 0 2.07 0.41399 2.2769-2.07 0 0 0-4.9679 1.035-5.1749-0.207 0 2.2769 0.207 1.449 0.82798m1.656-0.20699s0.62098 0 0.62098 1.242l-0.207 29.6s0.207 1.863-1.449 3.3119c0 0-0.82798 1.035-0.82798-0.62098l0.41399-30.221s0-2.277 1.449-3.3119m23.183 34.775s1.656-1.242 2.4839-1.035c0 0 8.9008 0.62099 11.592 0.207 2.6909-0.41399 1.035-0.207 1.035-0.207s2.277 0 3.1049-0.82798c0 0 0.62098-0.20699 1.035 0.41399l1.449 1.656s0 1.035-1.656 0.82799c0 0-15.939 0-16.56 0.20699 0.207 0-2.6909 0.41399-2.4839-1.242m1.035 2.6909s1.242-0.62098 2.07-0.41398c0.82798 0.20699 12.213-0.207 12.213-0.207s4.9679 0.41399 5.7959-0.41399l1.242-0.41399s0.41399-0.62098 0.41399-1.449v-3.5189l0.20699-1.035v-27.116s0.41399-2.07-0.82798-3.3119c0 0 0-0.82798 0.41399-0.62098 0.41399 0.20699 0.207 0 0.207 0s1.656-0.41399 2.07 0.20699c0 0 0.82798 2.277 0 3.7259 0 0-0.20699 2.8979 1.242 2.8979 0 0 0.62098 0.62099 1.656 0.207 0 0 2.4839 0.20699 2.4839 1.035 0 0 0 1.863-1.656 1.449l-2.277 0.20699s-1.656 0.41399-1.449 2.07c0.207 1.863 0 15.318 0 15.318s0 1.656 2.4839 1.449c0 0 3.1049-0.207 3.1049 0.82798 0 0 0.82798 1.863-1.449 2.07 0 0-4.1399-0.207-3.7259 1.035 0 0-0.207 2.6909-0.41399 3.3119 0 0 0.41399 2.277 0 2.6909 0 0-0.207 1.242-2.8979 1.035 0 0-16.767 0-19.458 0.207-0.207 0.41399-1.863 0.20699-1.449-1.242m-2.8979-1.863s1.656 0.207 1.656 1.863 0 2.4839-0.82798 2.6909c-1.035 0.207-2.07-0.20699-2.2769-1.449-0.41399-1.242 0-2.6909 1.449-3.1049" fill="#fff"/>
          <path d="m39.6 38.41-0.82798 1.863s-2.07 9.5218-3.3119 11.385c0 0-0.207 2.07-1.863 0.41398 0 0-3.9329-12.006-4.1399-12.42l-1.242-0.82798s-0.82798-1.035 0.62098-1.242h3.7259s1.242 1.035-0.41399 2.07c0 0 0.207 1.656 2.2769 7.6588 0 0 0.62098 2.2769 1.242 0.62099l2.07-7.0378-0.62098-2.07s-0.62098-1.035 0.207-1.035c0 0 2.07-0.207 2.2769 0.62099m5.5889 1.656v10.35l-0.207 0.82798s-1.035 1.242-0.207 1.449c0 0-0.82798 0.62099 6.2098 0.62099 0 0 2.6909 0.41399 2.07-3.1049 0 0-0.207-1.242-1.242 0.62099 0 0-0.207 1.656-3.9329 1.035 0 0-0.82798-0.62098-0.82798-1.449v-4.3469s0-1.035 1.656-1.035c0 0 1.863 1.242 2.07 0.62098 0 0 0.62098-1.656 0-2.4839 0 0-0.82798 0-1.035 0.207 0 0-0.62098 1.242-2.2769 0.41399 0 0-0.82798-1.656-0.207-2.8979 0 0-0.207-2.4839 1.449-2.277 0 0 2.07 0.41399 2.07 1.035 0 0 0.41399 1.242 1.035-0.207l-0.41399-1.449s-0.207-0.62098-0.82798-0.41399c0 0-3.3119 0.41399-3.7259 0l-2.6909 0.207s-0.41399 1.035 0.82798 1.449c0 0.207 0.207 0.41399 0.207 0.82798m59.408-1.656c-0.20699-0.82798 1.656-0.82798 1.656-0.82798l1.035 0.207c0.62098 0 1.449 0.20699 1.449 0.20699 0.62098 1.035-0.414 1.656-0.414 1.656l-0.41399 1.242v10.35c0.20699 0.41399 1.035 1.449 1.035 1.449 0 0.82798-1.035 0.62098-1.035 0.62098h-2.8979c-0.82798 0-0.62098-1.035-0.62098-1.035 1.035-0.41399 1.242-2.277 1.242-2.277v-9.7288zm-13.248 9.1078-0.207 3.1049 0.82798 1.449c0.62099 0.82798-0.41399 1.449-0.41399 1.449l-3.1049-0.41399c-0.62099-0.207 0-1.242 0-1.242 0.82798-0.41399 0.82798-1.656 0.82798-1.656v-9.9358c0-0.41399-0.82798-1.449-0.82798-1.449-0.62099 0-0.41399-1.035-0.41399-1.035 0.20699-0.41399 1.863-0.207 1.863-0.207h4.1399c3.9329 1.242 3.3119 4.1399 3.3119 4.1399 0.20699 2.8979-2.6909 3.9329-2.6909 3.9329l-0.207 1.656 2.8979 4.5539c0.41399 0.41399 0.41399 0.82798 0.41399 0.82798-0.41399 1.035-2.07 0-2.07 0l-3.5189-5.5889c-0.41399-0.41399-0.82798 0.41398-0.82798 0.41398m0-7.8658v5.1749c1.863 1.449 2.8979-0.62099 2.8979-0.62099 2.4839-2.2769 0-4.5539-0.41399-5.1749-0.41399-0.62099-2.277 0-2.277 0zm-30.221 57.959s0.207 7.2448 0 8.2798v1.656s0.41399 1.035 1.035 1.449c0 0 0.41399 1.449-0.62098 1.242 0 0-2.4839-0.207-3.1049 0 0 0-1.449 0 0-1.656 0 0 0.41399-0.62099 0.41399-2.4839 0 0 0-8.2798 0.207-8.6938 0 0 0.207-1.035-0.41399-1.449h-1.242l-1.449 1.449s-0.41399 1.449-1.035 0v-0.82798l0.82798-2.277h0.62098s0.82798 0.62099 1.656 0.82798h4.5539l1.656-0.82798s0.62098 0 0.41399 1.035c0 0 0.207 2.2769-1.035 2.4839 0 0-0.82798-0.207-1.242-1.449 0-0.207-1.242-1.035-1.242 1.242m21.527-2.6909s-3.7259-0.41399-3.7259 3.7259c0 0-0.41399 2.6909 3.7259 4.5539 0 0 3.1049 1.449 2.8979 3.3119 0 0-0.41399 3.3119-3.7259 1.656 0 0-1.656-0.82798-1.449-1.656 0 0-0.41399-1.035-1.035-0.82798 0 0-0.62098 0.20699-0.41399 3.5189 0 0 0 1.242 1.449 0l0.82798 0.207s2.6909 2.07 4.9679-0.41399c0 0 2.4839-2.277 0.62098-4.9679 0 0-1.242-2.07-3.5189-2.8979 0 0-2.07-1.035-2.6909-2.6909 0 0 0.62098-2.8979 3.3119-1.449 0 0 1.035 1.242 1.656 1.449 0 0 0.82798 0 0.62098-1.863l-0.207-1.449s-0.207-1.035-1.656 0c0-0.20699-1.242 0.41399-1.656-0.20699m-11.799-2.07c0.62098 0.41399 0.82798 1.449 0.82798 1.449 2.07 5.1749 3.7259 12.834 3.7259 12.834 0.41399 1.035 1.449 1.656 1.449 1.656 1.656 0.62099 0 1.035 0 1.035-0.62098 0.20699-2.8979 0-2.8979 0-1.242-0.207-0.62098-0.62099-0.62098-0.62099 0.41399-0.41399 0-2.4839 0-2.4839 0-0.82798-1.035-2.07-1.035-2.07-0.41399-0.20699-1.035 0.62099-1.035 0.62099s-1.035 0.41399-1.242 0-0.82798-0.82798-0.82798-0.82798c-1.242 0-1.656 2.8979-1.656 2.8979 0.62098 2.4839 0 2.07 0 2.07-0.62098 0.82798-2.4839 0.20699-2.4839 0.20699-0.82798-0.20699-0.207-0.82798-0.207-0.82798 1.035-0.20699 1.449-1.449 1.449-1.449 0.41399-0.62099 3.7259-13.455 3.7259-13.455-0.207-0.20699 0-1.449 0.82798-1.035m-1.656 6.6238c0 0.41399-0.82798 3.3119-0.82798 3.3119l0.62098 1.035h2.07c0.41399 0 0.62098-0.41399 0.62098-1.035 0-0.41399-1.035-3.5189-1.035-3.5189l-0.41399-0.62098z"/>
        </svg>

        <svg enable-background="new 0 0 1000 258.563" viewBox="0 0 1000 258.563" xmlns="http://www.w3.org/2000/svg"><path d="m258.087 128.076c-.019-2.635-2.205-4.878-4.869-4.878-.383 0-.759.074-1.134.167-42.904 8.871-87.648 12.425-133.462 9.905-14.116-.783-28 0-41.67 1.051-1.043.067-2.065.192-3.09.332-10.956 1.501-21.432 6.362-29.55 14.292-7.209 7.055-12.312 16.145-14.484 26.018-2.611 11.873-.768 24.139 4.269 35.12 4.87 10.663 12.69 19.937 22.396 26.6 10.54 7.063 22.118 12.572 34.276 16.276 7.667 2.301 14.495 3.727 22.559 4.727.108-3.051 4.711-7.813 4.874-10.105.162-2.294-1.572-4.313-3.857-4.461-12.562.476-21.776.167-33.566-4.22-12.099-4.527-23.047-11.998-31.694-21.563-4.16-4.611-7.608-9.664-9.832-15.468-2.184-5.82-3.113-12.048-2.763-18.228 1.175-20.771 17.34-38.354 37.968-41.316 11.407-1.633 23.219 1.301 32.524 8.104 4.857 3.536 9.009 8.099 12.048 13.251 3.449 5.861 6.333 12.065 8.343 18.568 4.173 13.55 4.549 28.367 2.765 42.351-.776 5.929-2.022 11.809-3.724 17.577-.954 3.259-2.117 6.503-3.398 9.655-.229.584-.366 1.2-.366 1.87 0 2.65 2.117 4.768 4.723 4.845.326 0 .888.016 1.222.016 31.744 0 60.798-11.424 83.315-30.345.017-.008.058-.058.075-.066.926-.892 1.456-2.077 1.456-3.411 0-.99-.342-1.858-.795-2.649-8.443-14.652-26.822-35.687-26.822-35.687s20.801 18.617 35.717 26.773c.806.424 1.686.773 2.683.773 1.333 0 2.547-.516 3.413-1.409.055-.032.105-.084.154-.157 18.924-22.479 30.307-51.479 30.307-83.125-.001-.391-.011-.783-.011-1.183" fill="#187fc3"/><path d="m24.149 187.285c-5.112-11.356-8.271-23.62-9.038-36.004-.088-1.685-.064-3.936-.072-5.611 0-2.319-1.868-4.202-4.189-4.202-2.322 0-7.25 4.235-10.698 4.235 3.523 27.349 15.904 53.181 35.021 73.061 9.352 9.748 20.937 17.293 34.096 20.861 11.298 3.068 23.3 1.675 33.736-3.585 4.995-2.535 9.589-5.928 13.396-10.058 4.064-4.368 7.187-9.695 10.083-14.884 3.04-5.501 5.679-11.196 8.068-17.024 2.518-6.17 4.619-12.533 7.404-18.644 10.535-22.981 25.374-44.002 45.423-59.646 9.801-7.646 20.5-14.064 31.864-19.118 5.782-2.569 11.708-4.763 17.77-6.571 2.885-.859 5.832-1.66 8.768-2.359 2.629-.817 4.089-3.603 3.202-6.171-7.342-18.585-19.141-35.313-34.024-48.612-.101-.099-.188-.191-.288-.284-.855-.741-1.968-1.226-3.202-1.226-1.335 0-2.452.793-3.469 1.509-23.897 16.569-41.496 44.242-41.496 44.242s9.314-23.655 29.184-52.83c.505-.7.725-1.585.725-2.501 0-1.66-.813-3.101-2.068-3.97-.145-.1-.303-.199-.466-.284-12.295-7.146-25.72-12.332-39.715-15.108-10.194-2.035-20.638-2.835-31.019-2.376-.025-.017-.067-.017-.088-.017-.058 0-.099.017-.158.017-2.598.074-4.586 2.217-4.69 4.819-1.322 33.97 5.336 92.372 5.336 92.372s-11.864-57.55-23.555-89.486c-.701-1.936-2.434-3.395-4.594-3.395-.334 0-.668.034-.963.083-.037.026-.071.049-.113.049-.838.209-1.671.451-2.51.693-19.537 5.795-37.605 16.243-52.377 30.243-2.542 2.41-4.969 4.944-7.333 7.579-.05.049-.121.125-.164.15-.8.892-1.305 2.027-1.305 3.311 0 1.316.472 2.685 1.451 3.435 25.524 19.379 44.348 41.451 44.348 41.451s-24.172-17.827-52.902-29.15c-.821-.309-1.597-.726-2.518-.726-1.676 0-3.135.851-4.015 2.135-.017.018-.026.042-.042.066-4.148 7.088-7.684 14.525-10.427 22.248-3.49 9.831-5.77 20.112-6.804 30.508-.263 2.652-.434 5.371 2.288 6.855 1.076.599 2.272.692 3.458.458 1.759-.384 3.526-.716 5.303-1.001 6.866-1.116 13.799-1.617 20.716-1.559 13.892.134 27.724 2.66 40.712 7.495 11.985 4.494 22.942 11.507 31.246 21.346 15.627 18.562 24.003 50.438 5.971 70.218-8.267 9.071-20.441 13.492-32.628 12.407-6.266-.594-11.815-2.776-17.289-5.736-4.995-2.709-9.736-5.828-13.975-9.59-9.255-8.237-16.334-18.902-21.375-30.118" fill="#f9be00"/><g fill="#231815"><path d="m578.022 120.729c0-2.11 11.857-.449 17.396 1.226 4.443 1.369 11.539 3.41 19.001 9.164 4.252 3.294 9.462 9.13 9.462 16.133 0 6.964-4.2 10.509-9.336 10.509-2.786-.375-5.654-2.043-8.171-4.578-2.535-2.519-4.504-7.604-11.843-16.02-8.304-9.505-16.509-15.024-16.509-16.434"/><path d="m570.152 52.239.017-13.307 5.852-1.851-.008-.033c.702-.193 1.262-.801 1.262-1.601 0-.81-.635-1.477-1.436-1.602v-.042l-26.918-4.036v22.472h-58.73l1.863 4.019h138.682s1.668-2.435 0-4.019c-1.667-1.602-16.424-10.73-16.424-10.73l-9.808 10.73z"/><path d="m546.147 126.107.014-.023-23.871-8.33c-8.821 14.608-16.985 26.397-29.843 37.28l.017.016c-.279.217-.466.551-.466.934 0 .709.581 1.277 1.263 1.277.163 0 .313-.052.442-.109v.018c.017-.018.024-.018.051-.018v-.009c11.339-4.119 27.737-14.551 47.148-27.767l4.754-.024c.915 0 1.682-.734 1.682-1.659-.001-.759-.508-1.369-1.191-1.586"/><path d="m806.508 71.384c-2.185-2.092-18.128-11.907-18.128-11.907l-9.948 11.907h-35.378l.017-32.452 5.863-1.851-.012-.033c.728-.193 1.269-.801 1.269-1.601 0-.81-.651-1.477-1.434-1.602v-.042l-28.001-4.036v41.617h-53.946l1.866 4.028h52.08c-.322 19.877-4.935 35.346-11.755 46.619-8.488 14.218-21.497 27.399-42.426 38.799 0 0-.017 0-.017.025-.083.051-.158.084-.225.125h.007c-.317.258-.532.599-.532 1.025 0 .699.558 1.249 1.259 1.249.116 0 .242-.033.359-.048l.015.015c25.24-7.237 45.521-18.652 56.002-32.419 8.971-11.781 15.293-25.098 17.144-42.35 1.885 15.318 5.751 27.643 11.481 36.838 7.313 13.125 19.451 25.616 35.962 35.905.118.083.217.15.341.218.191.082.409.125.611.125.366 0 .684-.125.94-.317.367-.241.635-.709.718-1.151 1.093-6.104 9.047-11.406 15.141-13.599-19.512-10.85-35.429-23.839-43.166-33.646-9.308-11.723-15.808-24.206-19.226-37.413h63.118c.001 0 2.17-1.936.001-4.028"/><path d="m880.034 35.078c-.167.318-.135.86.243 1.452 1.734 2.786 6.245 9.348 8.78 13.708 3.102 5.361 3.401 7.363 5.328 9.314 1.71 1.684 7.571 3.042 11.124.633 3.567-2.436 3.976-7.404 2.493-11.158-1.476-3.768-6.889-9.789-12.774-12.065-5.888-2.257-14.176-3.759-15.194-1.884"/><path d="m908.937 30.41c-.327.349-.485.966-.019 1.566 1.935 2.502 5.938 7.505 9.032 12.542 3.958 6.371 4.478 10.021 6.645 12.207 3.419 3.369 9.473 2.709 11.498.667 2.91-2.894 3.937-7.913 2.818-11.666-1.76-5.92-7.194-10.931-14.876-13.599-6.803-2.36-13.814-2.993-15.098-1.717"/><path d="m878.051 53.874c3.228.542 5.326 12.991 2.125 24.081-2.642 9.105-8.903 13.207-15.85 11.665-5.388-1.208-7.205-5.987-5.536-11.54 1.449-4.828 5.901-8.506 9.071-11.564 3.233-3.145 7.095-8.464 7.972-10.982.333-.943.915-1.877 2.218-1.66"/><path d="m937.429 117.52v34.595c0 8.34-16.354 10.998-21.297 10.998-2.562 0-2.46-2.459-3.585-4.645-.952-1.818-3.879-4.354-20.122-5.603l-1.385-3.201h25.799l-.017-32.145h-58.116l-1.852-4.027h59.968v-15.667l24.681 2.719c2.361 1.207-.516 5.126-4.074 6.62v6.328h31.458l11.173-11.999s13.359 9.98 15.486 11.999c2.102 2.018 0 4.027 0 4.027h-58.117z"/><path d="m999.772 67.473c0-.649-.374-1.192-.934-1.484h.015l-.091-.067-21.429-10.674-5.945 8.532-20.529-.092 23.898-21.096 6.703-.759c.937 0 1.669-.759 1.669-1.676 0-.708-.425-1.3-1.036-1.55l-24.671-8.839c-3.878 9.864-8.681 21.863-14.417 33.921h-62.921l-.149 4.002 92.653.242-6.153 19.528 2.519.735 23.64-18.595 5.694-.45v-.042c.816-.085 1.484-.768 1.484-1.636"/><path d="m972.974 87.46v-.017l-20.521-13.366-6.044 6.37h-62.271l1.842 4.019h59.353l-11.396 18.335c1.884.392.265 3.779 3.493 4.362l28.341-17.119 6.053.468v-.034c.082 0 .15.034.217.034.935 0 1.667-.759 1.667-1.677-.002-.575-.292-1.067-.734-1.375"/><path d="m413.563 131.211c-10.077-4.452-17.982-10.098-23.723-16.935h25.82v6.103l19.983-2.968v-41.308l4.595-2.143c.775-.325 1.305-1.059 1.305-1.942 0-.792-.464-1.484-1.118-1.843l-19.348-10.948-6.483 8.33h-25.99v-14.717h59.98s1.931-2.319 0-4.169c-1.95-1.868-15.196-9.522-15.196-9.522l-8.555 9.522h-36.229l.017-9.739 5.873-1.851-.016-.033c.718-.193 1.255-.801 1.255-1.601 0-.81-.613-1.477-1.426-1.602l.016-.042-26.311-4.036v18.904h-59.84l1.718 4.169h58.122v14.716h-27.211l-19.053-7.295v60.118l19.99-2.968v-3.135l20.246-.016c-15.642 19.318-34.128 31.317-52.889 42.006h.017c-.4.217-.679.643-.679 1.119 0 .691.57 1.258 1.255 1.258.125 0 .254-.05.367-.075l.008.009c16.989-5.536 36.721-10.857 57.951-27.791v32.326l20.592-2.8v-40.267c3.101 6.563 6.669 10.74 10.697 15.191 8.994 10.391 21.534 16.962 37.802 23.039 2.631-8.162 6.137-14.45 12.328-16.384l1.01-1.585c-13.025-2.524-25.422-3.609-36.88-9.095m-45.552-20.962h-26.274v-18.069h26.274zm0-22.064h-26.274v-16.601h26.274zm20.592-16.609h27.049v16.602h-27.049zm0 20.604h27.049v18.069h-27.049z"/><path d="m617.321 72.919v-.018l-19.956-11.314-6.483 8.346h-61.447l-19.836-7.304v52.273l20.613-2.952v-3.426h19.96v41.141h-25.799l1.384 3.201c16.244 1.249 19.18 3.784 20.121 5.603 1.145 2.186 1.035 4.645 3.596 4.645 4.925 0 21.285-2.658 21.285-10.998v-43.591h21.188v5.786l20.597-2.962v-31.819-.667l4.604-2.159c.765-.309 1.309-1.059 1.309-1.951-.001-.793-.452-1.468-1.136-1.834m-25.374 31.451h-61.735v-30.443h61.735z"/><path d="m372.217 204.22c.146 0 .275-.1.275-.332v-1.068c0-7.619 0-9.021-.078-10.622-.092-1.709-.484-2.493-2.055-2.852-.384-.109-1.197-.148-1.866-.148-.52 0-.816-.109-.816-.468 0-.326.351-.435 1.014-.435h12.878c.676 0 1.004.108 1.004.435 0 .358-.279.468-.85.468-.404 0-.82.039-1.384.148-1.297.25-1.676 1.102-1.776 2.852-.087 1.601-.087 28.033.155 30.192.134 1.401.417 2.503 1.851 2.719.684.093 1.726.192 2.427.192.537 0 .775.142.775.392 0 .356-.376.501-.955.501h-13.416c-.672 0-.998-.145-.998-.501 0-.25.196-.392.759-.392.718 0 1.297-.1 1.718-.192.947-.216 1.193-1.317 1.372-2.768.241-2.11.241-6.063.241-10.683v-4.402c0-.217-.128-.31-.275-.31h-18.227c-.138 0-.3.033-.3.31v4.402c0 4.62 0 8.572.267 10.731.125 1.401.417 2.503 1.843 2.719.684.093 1.726.192 2.427.192.546 0 .792.142.792.392 0 .356-.401.501-.971.501h-13.466c-.609 0-.938-.145-.938-.501 0-.25.179-.392.742-.392.726 0 1.296-.1 1.722-.192.959-.216 1.205-1.317 1.392-2.768.25-2.11.25-28.543.146-30.144-.104-1.709-.471-2.493-2.068-2.852-.366-.109-1.192-.148-1.859-.148-.514 0-.795-.109-.795-.468 0-.326.333-.435 1.007-.435h12.879c.671 0 1.006.108 1.006.435 0 .358-.289.468-.865.468-.391 0-.808.039-1.379.148-1.292.25-1.685 1.102-1.768 2.852-.113 1.601-.113 3.003-.113 10.622v1.068c0 .232.163.332.3.332h18.226z"/><path d="m430.511 180.916c-.138-2.276-.642-3.344-2.731-3.803-.513-.15-1.597-.225-2.493-.225-.692 0-1.088-.125-1.088-.594 0-.466.455-.607 1.4-.607h17.111c.967 0 1.417.142 1.417.607 0 .469-.383.594-1.021.594-.709 0-1.076.074-1.856.225-1.705.316-2.225 1.483-2.347 3.803-.129 2.126-.129 23.545-.129 23.545 0 9.691 1.846 13.768 4.969 16.427 2.852 2.478 5.783 2.771 7.959 2.771 2.793 0 6.225-.96 8.775-3.621 3.495-3.685 3.682-9.696 3.682-16.584 0 0 0-20.412-.113-22.538-.133-2.276-.646-3.344-2.747-3.803-.514-.15-1.597-.225-2.289-.225-.701 0-1.084-.125-1.084-.594 0-.466.453-.607 1.342-.607h14.563c.897 0 1.351.142 1.351.607 0 .469-.392.594-1.143.594-.708 0-1.113.074-1.854.225-1.726.316-2.227 1.483-2.355 3.803-.138 2.126-.138 21.328-.138 21.328 0 7.439-.684 15.318-6.046 20.13-4.515 4.075-9.101 4.818-13.216 4.818-3.373 0-9.493-.199-14.142-4.618-3.235-3.085-5.648-8.03-5.648-17.721.001.001.001-21.811-.129-23.937"/><path d="m651.684 192.197c-.101-1.709-.576-2.56-1.617-2.793-.535-.168-1.145-.207-1.737-.207-.474 0-.756-.109-.756-.502 0-.292.384-.4 1.157-.4h12.025c.617 0 1.016.108 1.016.4 0 .393-.316.502-.799.502-.467 0-.834.039-1.418.148-1.284.25-1.658 1.102-1.769 2.852-.101 1.601-.101 28.291.11 30.435.141 1.351.459 2.261 1.89 2.477.685.093 1.711.192 2.453.192.503 0 .768.142.768.392 0 .356-.4.501-.918.501h-13.456c-.616 0-.968-.145-.968-.501 0-.25.19-.392.766-.392.718 0 1.285-.1 1.718-.192.959-.216 1.251-1.076 1.392-2.518.243-2.103.243-28.793.143-30.394"/><path d="m714.203 213.21c0-2.701-.482-3.802-1.1-5.264-.317-.798-6.739-11.847-8.407-14.43-1.182-1.862-2.375-3.112-3.3-3.672-.618-.35-1.434-.647-2.003-.647-.366 0-.716-.109-.716-.468 0-.285.35-.435.919-.435h11.105c.492 0 .718.149.718.435 0 .308-.335.358-1.051.558-.418.117-.669.501-.669.9 0 .426.251 1.017.582 1.708.671 1.502 7.356 13.577 8.107 15.003.482-1.219 6.503-12.234 7.17-13.811.468-1.073.65-1.941.65-2.6 0-.492-.183-1.059-1-1.252-.428-.091-.852-.199-.852-.507 0-.326.235-.435.819-.435h9.587c.518 0 .852.108.852.4 0 .342-.384.502-.899.502-.469 0-1.394.207-2.103.591-1.001.509-1.527 1.107-2.578 2.476-1.559 2-8.244 13.784-9.11 15.951-.727 1.784-.727 3.344-.727 4.995 0 0 0 7.021.158 9.131.101 1.45.515 2.552 1.941 2.768.686.093 1.727.192 2.396.192.516 0 .768.142.768.392 0 .356-.386.501-1.003.501h-13.265c-.676 0-1.053-.077-1.053-.501 0-.25.228-.392.759-.392.669 0 1.235-.1 1.668-.192.968-.216 1.384-1.317 1.485-2.768.152-2.109.152-9.129.152-9.129"/><path d="m743.655 207.256c0-8.589 5.387-19.686 19.693-19.686 11.892 0 19.28 7.278 19.28 18.77 0 11.506-7.64 20.562-19.757 20.562-13.681-.001-19.216-10.792-19.216-19.646m32.303.959c0-11.24-6.556-18.219-14.377-18.219-5.486 0-11.339 3.218-11.339 15.684 0 10.431 5.853 18.712 15.025 18.712 3.336 0 10.691-1.693 10.691-16.177"/><path d="m852.826 207.256c0-8.589 5.379-19.686 19.703-19.686 11.882 0 19.278 7.278 19.278 18.77 0 11.506-7.637 20.562-19.754 20.562-13.698-.001-19.227-10.792-19.227-19.646m32.295.959c0-11.24-6.537-18.219-14.357-18.219-5.487 0-11.341 3.218-11.341 15.684 0 10.431 5.861 18.712 15.026 18.712 3.344 0 10.672-1.693 10.672-16.177"/><path d="m926.439 189.197c.557 0 1.358.298 1.991.647.901.56 2.1 1.81 3.286 3.672 1.683 2.583 8.069 13.632 8.402 14.43.626 1.462 1.102 2.563 1.102 5.264 0 0 0 7.021-.149 9.131-.093 1.45-.517 2.552-1.478 2.768-.424.093-.998.192-1.668.192-.524 0-.766.142-.766.392 0 .424.386.501 1.06.501h13.274c.599 0 .993-.145.993-.501 0-.25-.26-.392-.777-.392-.667 0-1.718-.1-2.366-.192-1.454-.216-1.877-1.317-1.96-2.768-.16-2.11-.16-9.131-.16-9.131 0-1.651 0-3.211.718-4.995.868-2.167 7.555-13.951 9.123-15.951 1.05-1.368 1.584-1.967 2.585-2.476.716-.384 1.608-.591 2.103-.591.516 0 .897-.16.897-.502 0-.292-.333-.4-.867-.4h-9.588c-.585 0-.815.108-.815.435 0 .308.424.416.849.507.818.193 1.033.76 1.033 1.252 0 .658-.215 1.526-.683 2.6-.669 1.576-6.688 12.592-7.156 13.811-.766-1.426-7.453-13.501-8.104-15.003-.352-.691-.574-1.282-.574-1.708 0-.399.223-.783.657-.9.702-.199 1.035-.25 1.035-.558 0-.285-.217-.435-.718-.435h-21.888c-.525 0-.766.108-.766.435 0 .308.19.416.606.507.484.109.684.468.684 1.009 0 .844-1.05 2.111-2.384 3.753-1.385 1.718-8.337 9.18-9.98 11.041h-.226v-2.22c0-7.619 0-9.021.083-10.622.101-1.75.484-2.602 1.786-2.852.556-.109.849-.148 1.324-.148.375 0 .659-.109.659-.468 0-.326-.326-.435-1.001-.435h-12.455c-.709 0-1.052.108-1.052.435 0 .358.301.468.818.468.666 0 1.466.039 1.875.148 1.551.358 1.943 1.143 2.025 2.852.111 1.601.111 28.033-.141 30.144-.192 1.45-.416 2.552-1.373 2.768-.435.093-1.002.192-1.721.192-.558 0-.766.142-.766.392 0 .356.333.501.969.501h12.873c.516 0 .916-.145.916-.501 0-.25-.25-.392-.625-.392-.626 0-1.678-.1-2.325-.192-1.219-.216-1.644-1.317-1.734-2.719-.135-2.159-.135-6.111-.135-10.731v-4.568h.226l.526.766c1.007 1.443 10.388 13.017 12.507 14.993 2.05 1.909 3.342 3.01 5.911 3.268 1.008.077 1.861.077 3.294.077h4.16c.907 0 1.158-.145 1.158-.501 0-.284-.298-.392-.635-.392-.573 0-1.533-.151-2.976-.743-2.56-1.067-4.702-3.319-6.804-5.428-1.858-1.844-11.232-12.432-12.949-14.792 1.626-1.81 8.84-9.33 10.322-10.821 2.053-2.146 3.671-3.163 5.154-3.78.903-.336 2.104-.543 2.781-.543"/><path d="m958.715 207.256c0-8.589 5.395-19.686 19.72-19.686 11.899 0 19.286 7.278 19.286 18.77 0 11.506-7.646 20.562-19.762 20.562-13.709-.001-19.244-10.792-19.244-19.646m32.319.959c0-11.24-6.537-18.219-14.376-18.219-5.486 0-11.348 3.218-11.348 15.684 0 10.431 5.879 18.712 15.033 18.712 3.346 0 10.691-1.693 10.691-16.177"/><path d="m632.056 230.528c-4.254-.284-8.14-1.535-11.467-4.854-3.201-3.208-8.764-11.055-11.964-17.117 4.835-4.119 6.319-7.545 6.319-11.24 0-3.352-1.908-5.945-3.26-6.869-2.568-1.861-5.769-2.152-8.78-2.152h-13.291c-.726 0-1.044.108-1.044.435 0 .358.283.468.811.468.684 0 1.468.039 1.884.148 1.552.358 1.927 1.143 2.035 2.852.092 1.601.092 3.003.092 10.622v8.839c0 4.62 0 8.572-.242 10.683-.185 1.45-.415 2.552-1.375 2.768-.434.093-.993.192-1.71.192-.584 0-.784.142-.784.392 0 .356.334.501.958.501h12.852c.616 0 .948-.145.948-.501 0-.25-.198-.392-.558-.392-.575 0-1.625-.1-2.345-.192-1.432-.216-1.717-1.317-1.865-2.768-.218-2.11-.218-6.063-.218-10.739v-.703c0-.282.117-.39.366-.39l4.137.107c.351 0 .7 0 .876.342.575 1.116 2.918 6.746 5.097 10.174 2.107 3.375 4.175 6.094 6.353 7.813 2.633 2.067 5.259 2.867 8.513 3.158 4.145.375 6.995 0 7.804-.241.692-.174 1.51-.41 1.51-.926-.002-.542-.812-.342-1.652-.41m-25.583-23.181c-.858.651-1.467.868-3.384.868-1.184 0-2.638-.166-3.628-.526-.335-.143-.409-.342-.409-.884v-15.26c0-.398.074-.59.409-.689.483-.159 1.343-.192 2.534-.192 2.811 0 7.314 2.019 7.314 9.164.001 4.102-1.402 6.418-2.836 7.519"/><path d="m340.069 187.937c-.213 0-.596.2-1.297.342h-26.969c-1.188-.093-1.667-.708-2.051-.708-.302 0-.427.315-.572.975-.105.492-1.077 5.937-1.077 5.937h.01c-.01.033-.017.076-.017.116 0 .284.222.518.504.518.213 0 .383-.133.475-.308 0-.019 0-.019 0-.043.154-.408.438-1.248.872-2.036.718-1.074 1.856-1.357 4.627-1.434h7.105s0 28.936-.229 31.046c-.146 1.45-.429 2.552-1.393 2.768-.426.093-1 .192-1.718.192-.563 0-.767.142-.767.392 0 .356.35.501.954.501h13.516c.523 0 .906-.145.906-.501 0-.25-.238-.392-.768-.392-.717 0-1.76-.1-2.425-.192-1.443-.216-1.73-1.317-1.868-2.719-.23-2.159-.23-31.095-.23-31.095h6c4.236.103 5.498 1.478 5.587 2.779l.108 1.024c0 .292.233.525.503.525.292 0 .521-.233.521-.525 0 0 .063-5.438.063-6.12.018-.741-.052-1.042-.37-1.042"/><path d="m696.586 187.937c-.21 0-.585.2-1.293.342h-26.965c-1.185-.093-1.669-.708-2.054-.708-.284 0-.433.315-.573.975-.11.492-1.069 5.937-1.069 5.937 0 .033-.015.076-.015.116 0 .284.223.518.525.518.182 0 .365-.133.433-.308h.016c0-.019 0-.019 0-.043.168-.408.433-1.248.877-2.036.708-1.074 1.86-1.357 4.608-1.434h7.114s0 28.936-.226 31.046c-.149 1.45-.416 2.552-1.385 2.768-.416.093-.991.192-1.716.192-.577 0-.752.142-.752.392 0 .356.318.501.95.501h13.51c.517 0 .908-.145.908-.501 0-.25-.258-.392-.778-.392-.713 0-1.763-.1-2.415-.192-1.444-.216-1.744-1.317-1.869-2.719-.241-2.159-.241-31.095-.241-31.095h6.006c4.252.103 5.494 1.478 5.577 2.779l.125 1.024c0 .292.227.525.491.525.3 0 .517-.233.517-.525 0 0 .076-5.438.076-6.12.008-.741-.04-1.042-.382-1.042"/><path d="m859.274 175.18c-.269 0-.77.251-1.721.475h-36.011c-1.594-.144-2.236-.942-2.762-.942-.367 0-.55.416-.742 1.269-.132.657-1.443 7.928-1.443 7.928l.036.017c-.036.042-.051.093-.051.149 0 .359.317.686.69.686.269 0 .511-.176.608-.393h.027v-.031s0-.028.006-.028c.201-.558.569-1.683 1.137-2.7.967-1.468 2.493-1.81 6.185-1.943h9.498s0 38.631-.325 41.441c-.182 1.937-.566 3.418-1.851 3.686-.55.126-1.316.26-2.283.26-.753 0-1.01.215-1.01.533 0 .49.435.692 1.274.692h18.021c.698 0 1.208-.202 1.208-.692 0-.318-.315-.533-1.018-.533-.959 0-2.351-.134-3.234-.26-1.935-.268-2.31-1.749-2.502-3.61-.318-2.886-.318-41.517-.318-41.517h8.03c5.653.134 7.314 1.96 7.447 3.712l.168 1.368c0 .374.284.657.666.657.385 0 .684-.283.684-.657 0 0 .067-7.272.082-8.157.001-1.01-.045-1.41-.496-1.41"/><path d="m410.181 219.046c0-.3-.225-.509-.495-.509-.26 0-.463.176-.506.417-.446 2.051-1.629 3.345-2.876 3.962-1.23.6-3.227.6-4.475.6-4.875 0-4.984-.626-5.081-4.077-.05-1.467 0-11.75 0-11.75 0-.282.042-.499.283-.499 1.143 0 5.875.066 6.78.157 1.769.199 2.443.936 2.673 1.952.129.65.084 1.258.075 1.767 0 .285.233.518.513.518.275 0 .479-.191.513-.467v-.023-.027l.651-7.328v-.058c0-.285-.218-.519-.506-.519-.162 0-.325.11-.4.233-.02.042-.054.06-.071.077v.016c-.05.059-.129.192-.245.341-.446.51-1.164.65-2.306.759-1.085.109-6.583.109-7.626.109-.292 0-.333-.218-.333-.576v-12.684c0-.348.097-.481.333-.481.955 0 5.979.082 6.771.191 2.401.29 2.868.901 3.194 1.801.237.602.212 1.65.212 2.011 0 .267.251.499.521.499.258 0 .486-.191.513-.449.075-.685.563-6.354.563-6.68 0-.225-.042-.442-.271-.442-.241 0-.53.134-.771.218-.383.082-1.151.175-2.056.175-.912 0-17.506.017-18.793.017-.726 0-1.043.108-1.043.435 0 .358.284.468.806.468.662 0 1.477.039 1.851.148 1.588.358 1.957 1.143 2.06 2.852.083 1.601.083 28.033-.137 30.144-.197 1.45-.445 2.552-1.392 2.768-.417.093-1.009.192-1.719.192-.571 0-.767.142-.767.392 0 .356.342.501.959.501h19.236c1.809 0 2.356.19 2.586-1.143.153-1.019.778-5.903.778-5.903l-.008-.018c-.002-.019.006-.054.006-.087"/><path d="m563.364 189.197c.659 0 1.484.039 1.851.148 1.577.358 1.953 1.143 2.067 2.852.067 1.601.067 28.033-.168 30.144-.182 1.45-.414 2.552-1.364 2.768-.435.093-1.026.192-1.727.192-.576 0-.767.142-.767.392 0 .356.333.501.941.501h19.26c1.811 0 2.354.19 2.571-1.143.183-1.019.8-5.903.8-5.903l-.019-.018c0-.016.019-.051.019-.084 0-.3-.235-.509-.502-.509-.266 0-.467.176-.5.417-.468 2.051-1.634 3.345-2.868 3.962-1.242.6-3.251.6-4.503.6-4.861 0-4.985-.626-5.07-4.077-.064-1.467 0-11.75 0-11.75 0-.282.052-.499.286-.499 1.116 0 5.859.066 6.77.157 1.768.199 2.435.936 2.694 1.952.123.65.074 1.258.065 1.767 0 .285.234.518.509.518.267 0 .476-.191.506-.467v-.023c0-.027.013-.027.013-.027l.666-7.328h-.009c0-.017.009-.043.009-.058 0-.285-.244-.519-.519-.519-.183 0-.333.11-.415.233-.02.042-.034.06-.059.077l-.018.016c-.041.059-.108.192-.242.341-.433.51-1.143.65-2.285.759-1.093.109-6.588.109-7.637.109-.283 0-.335-.218-.335-.576v-12.684c0-.348.085-.481.335-.481.942 0 5.953.082 6.77.191 2.386.29 2.868.901 3.185 1.801.252.602.228 1.65.228 2.011 0 .267.241.499.525.499.25 0 .467-.191.507-.449.093-.685.559-6.354.559-6.68 0-.225-.032-.442-.284-.442-.223 0-.499.134-.746.218-.402.082-1.152.175-2.063.175-.907 0-27.489.017-28.781.017-.91 0-1.346.108-1.346.483 0 .367.401.419.819.419.607 0 1.35.039 1.908.232.435.166.609.566.609.975 0 .451-.175 1.209-.416 1.859-1.151 3.303-7.356 19.444-9.397 24.974h-.193l-8.219-22.772c-.67-1.816-1.085-3.227-1.085-3.852 0-.477.116-.825.467-1.066.382-.311 1.101-.35 1.877-.35.407 0 .717-.109.717-.468 0-.326-.543-.435-1.095-.435h-37.289c-.716 0-1.237.033-1.237.435 0 .308.188.468.775.468.667 0 1.798 0 2.521.298 1.142.501 1.591 1.46 1.648 4.503l.451 22.531h-.229c-.83-.792-24.736-27.767-25.299-28.409-.813-.909-1.255-1.551-1.76-1.551-.496 0-.633.675-.633 1.677l-.435 30.593c-.041 4.368-.237 5.811-1.476 6.212-.667.191-1.522.25-2.151.25-.479 0-.772.107-.772.392 0 .474.439.501 1.06.501h11.073c.675 0 1.105-.077 1.105-.501 0-.284-.293-.392-.814-.392-.758 0-1.664-.059-2.492-.342-.955-.359-1.572-1.66-1.655-5.586l-.53-21.938h.146c.841.966 22.438 25.905 25.44 28.909.532.541 1.101 1.107 1.625 1.107.417 0 .607-.458.607-1.56l.526-32.293c.052-2.811.442-3.862 1.769-4.253.592-.148 1.276-.148 1.744-.148.565 0 1.616.039 2.132.207 1.068.233 1.536 1.084 1.637 2.793.064 1.601.064 28.291-.158 30.394-.144 1.441-.41 2.302-1.386 2.518-.427.093-1.01.192-1.71.192-.574 0-.783.142-.783.392 0 .356.35.501.958.501h13.476c.526 0 .908-.145.908-.501 0-.25-.251-.392-.766-.392-.725 0-1.759-.1-2.437-.192-1.435-.216-1.782-1.126-1.906-2.477-.194-2.144-.194-28.834-.094-30.435.094-1.75.458-2.602 1.751-2.852.583-.109.968-.148 1.436-.148.38 0 .898 0 1.606.207 1.719.474 2.53 1.043 3.629 3.81l12.022 30.643c.925 2.337 1.203 3.045 1.82 3.045.674 0 .95-.785 2.199-3.694 1.051-2.502 10.213-24.197 12.073-28.9 1.284-3.218 2.003-4.062 2.618-4.519.871-.594 1.874-.594 2.356-.594"/><path d="m794.076 207.148c1.143 0 5.861.041 6.777.142 1.785.201 2.435.992 2.685 2.009.128.65.084 1.258.051 1.767 0 .285.251.518.525.518.284 0 .475-.191.511-.467v-.023-.027l.683-7.328h-.018c0-.017.018-.043.018-.058 0-.285-.25-.519-.524-.519-.179 0-.342.11-.418.233-.027.042-.027.06-.06.077 0 0-.015 0-.015.016-.034.059-.117.192-.241.341-.428.51-1.145.65-2.294.759-1.101.109-6.613.109-7.68.109-.292 0-.326-.166-.326-.477v-12.514c0-.56.149-.718.418-.718l7.353.158c1.828.058 2.684.816 3.021 1.502.29.715.314 1.816.314 2.233 0 .267.226.509.52.509.251 0 .458-.19.499-.433h.008v-.076s.661-6.229.661-6.554c0-.225-.152-.442-.333-.442-.252 0-.485.218-.768.3-.486.143-1.07.093-1.97.093-1.084 0-18.227.017-19.479.017-.699 0-1.083.108-1.083.483 0 .31.333.419.799.419.685 0 1.493.039 1.878.148 1.594.358 1.958 1.143 2.051 2.852.091 1.601.091 28.033-.142 30.144-.201 1.45-.434 2.552-1.385 2.768-.433.093-1.017.192-1.718.192-.541 0-.716.142-.716.392 0 .424.315.501.999.501h13.317c.724 0 1.042-.145 1.042-.501 0-.25-.184-.392-.817-.392-.667 0-1.702-.1-2.376-.192-1.424-.216-1.71-1.317-1.859-2.768-.234-2.11-.234-14.742-.234-14.742 0-.343.085-.451.326-.451"/><path d="m636.448 203.346-1.351-1.077c-3.942-3.15-5.052-4.895-5.052-7.22 0-3.001 2.15-5.171 5.687-5.171 3.091 0 4.478 1.493 5.212 2.479.993 1.3 1.225 2.844 1.225 3.317 0 .201.009.35.049.482.019.078.044.126.066.168 0 .018.011.018.011.018.033.059.067.107.134.141v.017c.09.075.184.118.314.118.285 0 .512-.243.512-.518l.089-6.68c.018-.166.018-.301.018-.383 0-.342-.251-.492-.666-.593-1.234-.341-3.235-.874-6.355-.874-6.638 0-11.023 3.975-11.023 9.505 0 4.052 1.819 7.571 7.072 11.882l2.183 1.792c3.97 3.219 4.688 5.562 4.688 8.038 0 2.651-2.103 5.72-6.404 5.72-2.968 0-5.77-1.359-6.818-5.068-.236-.85-.435-1.91-.435-2.569 0-.124-.019-.266-.032-.392v-.025c0-.265-.234-.476-.512-.476-.283 0-.523.211-.523.476l-.218 7.439c0 1.115.134 1.351.918 1.709 2.044.968 4.176 1.301 6.962 1.301 2.537 0 5.195-.452 7.58-2.051 3.452-2.368 4.485-5.805 4.485-8.74-.002-4.76-2.095-8.113-7.816-12.765"/></g></svg>

        <svg version="1.0" id="layer" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 637.4 246" enable-background="new 0 0 637.4 246" xml:space="preserve">
          <g>
            <path fill="#222" d="M308.4,117.8c-15.9,0-17.2-12.1-17.2-15.7c0-4.2,1-12.1,11.3-15.9c10.4-3.8,12.6-4.2,20-6.6v-1.8
              c0-3.6,0-4.2-0.8-6.6c-1.3-4.1-5.3-6.9-10.9-6.9c-5.3,0-9.8,3-11.9,7.4l-3-1.8c1.8-6.6,8.6-13.1,20.2-13.1c8,0,13.6,2.3,16.9,7.4
              c2.5,4.1,2.8,9.6,2.8,15.2c0,5.1-0.3,10.7-0.3,15.2c0,3-0.3,5.9-0.3,7.5c0,4.1,0.8,7.4,4.1,7.4c1.5,0,1.8-0.5,3-1.3l1.8,2.3
              c-3,4.1-6.6,7.4-12.4,7.4c-4.5,0-7.8-2.3-9.2-6C320.5,114.5,315.7,117.8,308.4,117.8z M322.4,86.8c-7.8,2.3-10.7,3.6-12.9,4.8
              c-3.6,1.8-5.1,5.1-5.1,9.3c0,3.3,1.3,8.6,8.9,8.6c2.5,0,6-0.5,9.3-2.8v-20L322.4,86.8L322.4,86.8z M190.8,114.6
              c0-5.9,0-10.9-0.5-16.9h3.6c0,3.8,1,6.6,2.8,8.3c2.5,2.8,8.3,4.5,13.6,4.5c11.1,0,16.4-4.2,16.4-13.4c0-7.8-4.8-11.1-11.3-15.7
              l-1-0.8l-7.1-4.8c-9.8-6.6-14.9-11.6-14.9-22c0-5.1,2-21.8,26.5-21.8c6.3,0,14.4,0.8,19.2,1.5c0,0.8-0.3,4.5-0.3,7.8
              c0,3.8,0,4.8,0.3,9.3h-3c0-4.1-1.3-6.6-3-8.3c-2.3-2.3-7.5-3.6-13.1-3.6c-13.1,0-14.6,6.6-14.6,11.6c0,6.9,3.6,9.3,11.3,14.4
              l8.9,5.9c7.5,5.1,14.6,9.8,14.6,22.5c0,21.2-20,23.5-28.3,23.5C203.2,117.8,196.8,116.6,190.8,114.6z M349.5,60.6
              c3,0.3,7.5,0,11.9-0.8c3.8-0.8,5.1-1.3,7.8-2.5l1.3,0.8v4.5c3-2.3,8.9-5.6,17.2-5.6c10.7,0,17.5,5.1,19.4,13.9
              c0.5,2.3,0.8,7.5,0.8,10.7v17.2c0,9.6,0.5,12.4,2.3,14.2c1,0.8,3,1.8,5.9,1.8v2.8c-3.8-0.3-10.7-0.5-14.6-0.5
              c-5.3,0-11.3,0.3-14.6,0.5v-2.8c3-0.3,4.8-1.3,5.9-2c1.8-1.8,2-5.1,2.3-12.4c0-2.3,0.3-6.9,0.3-10.1c0-4.2,0-8.9-0.5-13.4
              c-0.8-7.5-4.8-11.1-12.4-11.1c-5.3,0-8.6,1.3-11.1,2.5v30.8c0,9.6,0.5,12.4,2.3,14.2c1,0.8,3.3,1.8,5.6,1.8v2.8
              c-4.8-0.3-10.7-0.5-14.4-0.5c-7.8,0-10.4,0.3-14.9,0.5v-2.9c2.5,0,5.1-1,6.3-2.5c1.8-2,2-7.1,2-16.9V78c0-7.4-0.3-10.4-1.3-11.9
              c-0.8-1.3-2.8-2.3-6.9-2.3v-3.3h-0.5v0.1H349.5z M422.6,114.5c2.5,0,5.1-0.8,6.3-2.5c1.8-2,2-7.1,2-16.9V65.7h-7.5v-3.3
              c3.3-1.3,6-2.8,7.5-4.1c0-5.3,0.3-11.9,1-15.7c2.3-12.1,10.1-18.2,23.5-18.2c5.9,0,11.3,2,14.9,4.8l0.3,1.3l-5.9,8h-1.5
              c-2-4.8-5.1-7.5-10.4-7.5c-1.8,0-4.2,0.5-5.9,2c-2.5,2.5-3,6.3-3,13.9v11.3h13.1v7.4H444v32.6c0,7.8,0.3,11.6,1.3,13.1
              c1.5,2.5,6.9,2.8,9.3,2.8v3c-4.2-0.3-11.1-0.5-15.9-0.5c-7.4,0-12.1,0.3-15.9,0.5L422.6,114.5L422.6,114.5z M490.3,118.2
              c-17.9,0-28.5-11.1-28.5-29.8c0-14.6,7.8-31.6,29.8-31.6c17.9,0,28.5,11.1,28.5,29.8C520.1,101.2,512.2,118.2,490.3,118.2z
              M491.1,63.6c-3.6,0-6.3,1-8.3,2.8c-4.8,4.1-7.1,11.1-7.1,21.5c0,4.1,0.8,23.8,15.2,23.8c3.6,0,6.3-1,8.3-2.8
              c4.8-4.1,7.1-11.1,7.1-21.5C506.2,83.3,505.5,63.6,491.1,63.6z M526.1,60.3c4.1,0.3,8.3-0.3,12.9-1c3.6-0.5,5.9-1.3,7.1-2l1,0.5
              v5.1c2.8-2.8,7.4-5.6,13.6-5.6c4.5,0,7.5,1.3,10.4,3.6v1.8l-5.1,9.2h-2.5c-1.5-2.8-4.5-5.3-9.8-5.3c-2.5,0-4.5,0.5-6.3,1.8v30.1
              c0,7.8,0.3,11.3,1.3,12.9c1.5,2.5,6.6,2.8,9.3,2.5v3.3c-4.1-0.3-11.1-0.5-15.9-0.5c-5.6,0-11.3,0-15.9,0.5v-3
              c3.3-0.3,5.1-1,6.3-2.5c1.8-2,2-6.9,2-16.9V78.3c0-7.4,0-10.4-1.3-11.9c-1-1.3-3-2-6.9-2v-3.8L526.1,60.3L526.1,60.3z M608.8,28
              c3.6,0,8-0.8,13.9-1.8c3.3-0.5,5.3-1.3,6.3-1.5l1,0.5c-0.5,4.8-0.5,15.7-0.5,23.5v48c0,7.1,0,11.6,1,13.1c1,1.3,3,2.3,6.9,2.3v3
              c-3.8,0-8,0.5-12.6,1.3c-3,0.5-5.3,1-6.6,1.5l-1.5-0.5v-5.1c-3,2.3-8.6,5.6-16.4,5.6c-16.2,0-26.5-11.1-26.5-28.5
              c0-5.9,1-11.1,3-15.9c5.1-10.7,15.2-16.7,28-16.7c4.8,0,8.9,0.5,11.3,1V45.2c0-7.4,0-11.1-1.3-12.9c-0.8-1.3-2-1.8-6.3-2v-2.4
              L608.8,28L608.8,28z M606.8,109.6c4.1,0,6.9-0.5,9.6-2.3V67.9c-1-1-4.5-4.1-11.6-4.1c-11.3,0-16.9,7.8-16.9,24.1
              C587.6,94.7,589.6,109.6,606.8,109.6z M285.3,111.4c-1.8,2.3-6.3,6.9-15.9,6.9c-9.2,0-14.2-3.3-16.4-10.7c-1-2.8-1-8.6-1-11.9
              c0-9.3,0-16.9,0.3-25.8v-4.1h-7.9v-2.3c3-1.3,5.3-2.5,7.4-4.1c4.5-3.6,7.5-7.8,10.9-14.2h2.5v13.1h20v7.4h-20v30.8
              c0,9.3,1.8,14.4,10.4,14.4c4.1,0,6.9-1.3,8.3-2.3L285.3,111.4z"/>
            <path fill="#222" d="M517.9,164.7c-1,0-2.3,0.3-3,1c-0.8,0.5-0.8,1.3-0.8,1.8c0,1,0.3,1.8,1,3.8l5.6,14.6
              c0.8,2.3,1.5,4.1,1.8,5.3l6.9-20c0.8-2.3,1-2.8,1-3.8c0-0.5-0.3-1-0.8-1.5c-0.8-0.5-1.8-1-3-1v-2.3c0.8,0,2.5,0,3.3,0.3
              c0.8,0,2.3,0.3,3.6,0.3c2.5,0,6-0.3,7.5-0.3v2.3c-1,0.3-3.3-0.3-5.3,5.6l-14.4,38.4c-2,5.6-4.8,12.4-14.6,12.4c-4.1,0-6.9-1-9.2-3
              v-1l3.6-4.2h1c1,2.3,3,3.3,5.9,3.3c4.5,0,6.6-4.1,9.6-12.1l0.8-2.3l-12.1-31.5c0-0.3-0.3-0.8-0.5-1.3c-0.3-0.8-1-2.3-1-2.3
              c-0.8-1.5-2-2-3.6-2v-2.3c2.3,0.3,6.3,0.3,8.3,0.3c1.3,0,3.3,0,5.3-0.3c1,0,2.8-0.3,3.6-0.3v2H518v0.1H517.9z M384.1,164.2
              c2.5,0.3,5.3-0.3,8-0.8c2.3-0.5,3.6-0.8,4.5-1.3l0.8,0.3v3.3c1.8-1.8,4.5-3.6,8.6-3.6c3,0,4.8,0.8,6.6,2.3v1.3l-3,5.9h-1.5
              c-1-1.8-2.8-3.3-6.3-3.3c-1.5,0-2.8,0.5-4.1,1.3v19c0,5.1,0.3,7.4,0.8,8.3c1,1.5,4.1,1.8,5.9,1.8v2c-2.5-0.3-7.1-0.3-10.1-0.3
              c-3.6,0-7.4,0-10.1,0.5v-2c2,0,3.3-0.8,4.1-1.5c1.3-1.3,1.3-4.2,1.3-10.9v-10.7c0-4.5,0-6.6-0.8-7.5c-0.5-0.8-2-1.3-4.2-1.3v-2.8
              h-0.4L384.1,164.2L384.1,164.2z M215.8,200.8c-10.7,0-16.9-3.3-19.2-10.4c-1.3-3.6-1.3-8-1.3-11.6v-20.2c0-6-0.3-7.1-1.5-8
              c-0.5-0.5-1.8-1-3.6-1.3v-2c2.5,0.3,6.9,0.5,9.3,0.5c4.2,0,6.9,0,9.6-0.5v2.3c-1.8,0-3,0.5-4.1,1.5c-1.3,1.3-1.3,3.6-1.3,10.1v17.9
              c0,10.7,1,17.5,12.9,17.5c12.1,0,12.9-7.1,12.9-17.9v-19.7c0-6-0.3-7.1-1.5-8c-0.8-0.5-2-1-3.6-1.3v-2c2.3,0,5.3,0.3,8.3,0.3
              c2.8,0,5.6,0,8.9-0.5v2.3c-1.8,0-3,0.5-4.1,1.5c-1.3,1.3-1.3,3.6-1.3,10.1v15.2c0,4.8,0,10.1-1.5,14.4
              C232.5,197.6,226.4,200.8,215.8,200.8z M287.9,198.5c2-0.3,3.3-0.5,4.2-1.5c1.3-1.3,1.3-4.2,1.3-10.9v-10.7c0-4.5,0-6.9-0.8-7.8
              c-0.5-0.8-1.5-1.3-4.2-1.5v-2.3c1.5,0.3,5.6-0.3,8.6-0.8c1.5-0.3,3-0.8,4.1-1.3l0.8,0.8c-0.3,2.5-0.3,7.8-0.3,14.9v10.9
              c0,5.1,0.3,7.4,0.8,8.3c0.8,1,2.3,1.8,4.5,1.8v1.8c-2-0.3-5.9-0.3-9.2-0.3c-3.8,0-7.8,0.3-9.8,0.5L287.9,198.5L287.9,198.5z
              M297.2,155.3c-3,0-4.8-1.8-4.8-4.5s2-4.8,5.1-4.8c3,0,4.8,1.8,4.8,4.5C302.2,153.5,300.2,155.3,297.2,155.3z M447.6,198.5
              c2-0.3,3.3-0.5,4.2-1.5c1.3-1.3,1.3-4.2,1.3-10.9v-10.7c0-4.5,0-6.9-0.8-7.8c-0.5-0.8-1.5-1.3-4.2-1.5v-2.3
              c1.5,0.3,5.6-0.3,8.6-0.8c1.5-0.3,3.3-0.8,4.1-1.3l0.8,0.8c-0.3,2.5-0.3,7.8-0.3,14.9v10.9c0,5.1,0.3,7.4,0.8,8.3
              c0.8,1,2.3,1.8,4.5,1.8v1.8c-2.3-0.3-6-0.3-9.3-0.3c-3.8,0-7.8,0.3-9.8,0.5v-2H447.6z M456.9,155.3c-3,0-4.8-1.8-4.8-4.5
              s2-4.8,5.1-4.8c3,0,4.8,1.8,4.8,4.5C462,153.5,459.9,155.3,456.9,155.3z M417,199c0-3.8-0.3-7.8-0.5-9.8h2.5c0,2,0.5,3.8,1.5,4.8
              c1.5,1.8,3.3,2.5,6.6,2.5h0.5c4.1,0,6.3-1.8,6.3-5.3c0-2.8-1.8-4.1-4.8-5.9l-5.3-3.3c-2.8-1.8-6-4.2-6-9.6c0-4.2,1.8-7.5,5.3-9.3
              c2.3-1.3,5.9-1.3,7.5-1.3c3,0,7.4,0.5,9.8,1c-0.3,1-0.3,3.6-0.3,4.5c0,0.8,0,4.2,0.3,5.1h-2.5c0-1.5-0.5-3-1.5-4.2
              c-1-1.3-3.3-2-6-2c-3.8,0-5.9,1.5-5.9,4.8c0,2.5,2,3.8,3.8,5.1h0.3l5.1,3c3.3,2,7.5,4.5,7.5,10.4c0,9.8-9.2,11.3-14.4,11.3
              C423.8,200.5,420.6,200.3,417,199z M496.3,196.6c-1.3,1.3-4.1,4.2-10.1,4.2c-5.9,0-9.2-2-10.4-6.9c-0.5-1.8-0.5-5.6-0.5-7.5
              c0-6,0-10.9,0-16.4v-2.5h-5.1v-1.5c2-0.8,3.3-1.5,4.8-2.5c2.8-2.3,4.8-5.1,7.1-9.2h1.8v8.3h12.6v4.5h-12.6V187c0,5.9,1,9.3,6.6,9.3
              c2.5,0,4.2-0.8,5.3-1.5L496.3,196.6z M325.4,162.7c-0.8,0-2.5,0-3.6,0.3c-2,0-4.1,0.3-5.6,0.3c-2.8,0-6.9-0.3-8-0.3v2.3
              c0.5,0,2.5-0.3,3.8,2.3c0.5,1,0.8,1.8,1,2.3c0.3,0.5,0.5,1,0.5,1.3l12.1,30.3l3.8-0.8l13.4-29.8c0-0.3,0.3-0.5,0.5-1
              c0.3-0.3,0.3-0.8,1.3-2.3c0.8-1.5,2.5-2.3,3.8-2.3V163c-1.5,0-4.8,0.3-7.4,0.3c-1.3,0-2.5,0-3.8-0.3c-1,0-2.5-0.3-3.6-0.3v2
              c1.3,0,2.5,0.5,3,1c0.3,0.3,0.8,1,0.8,1.5c0,0.8-0.3,1.5-1,3.8l-7.4,17.9c-0.3-1-0.8-2.5-1.5-4.5l-5.1-13.4c-0.8-2-1-2.8-1-3.8
              c0-0.5,0-1,0.5-1.3c0.8-0.8,2-1.3,3.3-1.3v-2h0V162.7z M242.9,164.2c2,0.3,4.8,0,7.5-0.5c2.3-0.5,3.3-0.8,5.1-1.5l0.8,0.5v3
              c1.8-1.5,5.9-3.6,10.9-3.6c6.9,0,11.1,3.3,12.4,8.9c0.3,1.5,0.5,4.8,0.5,6.9v10.9c0,6,0.3,7.8,1.5,9.2c0.5,0.5,2,1,3.6,1v1.8
              c-2.5,0-6.9-0.3-9.3-0.3c-3.6,0-7.4,0.3-9.3,0.5V199c1.8-0.3,3-0.8,3.8-1.3c1-1,1.3-3.3,1.5-7.8c0-1.5,0-4.2,0-6.6
              c0-2.8,0-5.9-0.3-8.6c-0.5-4.8-3-7.1-7.8-7.1c-3.3,0-5.6,0.8-7.1,1.5v19.8c0,6,0.3,7.8,1.5,9.2c0.5,0.5,2,1,3.6,1v1.8
              c-3.3-0.8-7.1-0.8-9.6-0.8c-5.1,0-6.6,0-9.3,0.5v-1.8c1.5,0,3.3-0.5,4.1-1.5c1-1.3,1.3-4.5,1.3-10.9v-10.7c0-4.5,0-6.6-0.8-7.5
              c-0.5-0.8-1.8-1.5-4.2-1.3v-2.8L242.9,164.2L242.9,164.2z M365.7,200.8c-11.3,0-17.5-6.6-17.5-18.5c0-2,0.5-20.5,17.7-20.5
              c5.1,0,9.6,2,11.6,5.6c2.3,3.6,2.5,7.1,2.5,10.1v2.3h-23.5c0,2,0.3,3.6,0.5,4.8c1.3,7.4,5.3,10.9,12.4,10.9c4.1,0,6.6-0.8,8.9-2.3
              l1,1.8C376.8,198.4,371.8,200.8,365.7,200.8z M356.6,175.6h14.6c0-4.5-0.8-9.6-7.4-9.6C358.1,166.3,356.9,171.7,356.6,175.6z"/>
          </g>
          <g>
            <path fill="#8C1515" d="M34.6,0L0,33.8v90.9l30,30.7h13.8c-0.3,0.9-0.8,2.3,0.2,3.7c1,1.5,2.8,1.5,3.5,1.5c0.8,0,1.9-0.1,3.7-0.3h0
              c0,0,0.7,0.6-1.5,1.4c-1.8,0.6-3.4,1.7-3.9,3.5c0,0.1,0,0.3-0.1,0.4H0l0,46.5l34.6,34h90.9l34.6-33.9V125l-30-30.6h-25.5
              c0,0,0,0,0,0c-1.1-0.7-2.3-1.4-3.3-2.1l-0.4-0.2l-0.1,0c-0.6-0.4-1.2-0.8-1.8-1.4c-0.6-0.5-1-0.9-1.4-1.3l-0.1-0.1
              c-0.7-0.7-1.3-1.4-1.7-2c4,1.1,8.3,1.4,10.4,1.5h0.2c0.1,0,0.3,0,0.4,0l0.2,0c0.5,0,0.9,0.1,1.1,0.2c0.3,0.1,0.5,0.2,0.7,0.3
              l1.1,0.4c0.3,0.1,0.5,0.1,0.8,0.1c1.6,0,3-0.9,3.7-2.4c0.2-0.5,0.6-1.5,0.3-2.8l45.4,0V33.9L125.4,0L34.6,0L34.6,0z"/>
            <path fill="#FFFFFF" d="M155.9,35.7L123.8,4.2H36.2L4.1,35.6V123l27.6,28.2l17.8,0c-2,1.8-2.6,3.7-2.9,4.6c-0.7,2-1.4,2.6,4.8,1.7
              c2-0.3,5.6-1.6,7.3-2.7c1.7-1.1,4.9-0.2,4.7,2.2c-1.5,3.8-5.5,6.1-9.3,6.6c-8.7,1.1-4.9,4.3-4.9,4.3c1,0.7,1.6,1.3,2.1,1.9h-4.2v0
              h-43l0,40.5l32.1,31.5h87.6l32.1-31.5v-83.5l-27.6-28.1h-22.3c-1.8-1.2-4.2-2.5-6.4-3.9c0,0,0,0,0,0c-0.8-0.5-1.7-1.1-2.4-1.8
              c-0.7-0.5-1.2-1.1-1.7-1.6c-1.9-2-3.4-4.1-3.8-5.1c-0.7-1.8-0.6-4,1.1-3.1c4.1,2.4,10.9,2.8,13.4,2.9c0.3,0,2.3,0.2,2.8,0.4
              c0.5,0.2,1.3,0.6,1.3,0.6c1,0.4,2.9-1,0.7-3.6c-0.6-0.9-1.4-1.9-2.4-3h47.4L155.9,35.7"/>
            <path fill="#8C1515" d="M37.9,8.4l-29.6,29v83.8L33.5,147h23.7c4-1.8,4.9-1.6,6-3.9c0.2-0.4,0.3-1.4,0.4-2.4
              c0.1-0.3,0.6-3.3-0.9-2.6c-2.5,1.3-7.6-2.1-11.5-0.1c-3.8,2-1-2.6-0.5-3.4c0,0,2-2.7,5.1-4.5c0.1-0.1,0.2-0.1,0.3-0.2
              c0.3-0.2,0.6-0.3,0.9-0.5c2.3-1.1,9-5.6,10.2-6.9c0.7-0.8,2-2.7,2-3.7c0.2-0.9,0.4-2.3-0.5-2.8c-1.3-0.8-2.3,0.8-4.3,1.7
              c-2,0.9-3.5,1.3-5.3,1.3c-1.7,0.1-3.4-0.6-4.4-0.4c-1,0.2-1.6-0.6,0.3-2.5c0.9-0.9,1.2-1.2,1.6-1.5c4.5-2.9,8.5-2.9,10.7-8
              c0,0,1.7-4.6-1.6-2.6c-1.8,1.1-2.9,2.6-8.1,2.6c-5.3,0-7.3,2.5-8.2,3.6c0,0-3.6,5-2.7-2c0.9-7,2.3-10.6,5.6-13.3
              c2.9-2.3,9.9-5.5,12.5-9c1.3-1.3,4.6-5.1,2.7-8.2c-0.8-1.3-2.8,2.1-4.8,2.6c-2.3,0.6-5.3,1.4-7.5,0.9c-2.8-0.6-4.6,0.5-5.6,1
              c-1,0.5-3-1-0.6-3.8c3.2-3.7,11-8.5,16.2-11.3c0.7-0.3,2.5-1.1,4.1-2.1c0,0,0.1,0,0.1,0c0.4-0.2,1-0.5,1.3-1c1.1-1,1.9-2,1.7-3.1
              c-0.2-1-0.7-1.3-2.3-1.5c-1.2-0.1-3.3,1.3-5,1.2c-2.6-0.2-6.5,0.4-5.2-1.5c1.2-1.7,3.1-2.8,3.7-3.1c1.1-0.5,2.5-1.1,4.6-2.1
              c3.3-1.5,2.9-5.3,1.6-5.4c-2-0.2-7.4,1.5-3.6-2.8c0,0,1.8-1.8,3.6-3c1.4-0.8,2.6-1.2,4.1-1.7c0.9-0.3,3.2-2.4-2.3-2.6
              c0,0-3.1,0.1-2.5-1.3c0.5-0.9,3.2-2.7,3.2-2.7s2.2-1.5,3.1-2.4c0.9-0.8,1.5-1.5,1.4-2.2c0-0.8-2.2-1.9-3.1-3.1
              c-0.7-0.8-0.1-1.1,0.3-1.2c0.2,0,0.4-0.1,0.7-0.1c2.2,0,2.9-2.2,4.2-8.1c0.4-1.7,0.4-2.1,1-2.1c0.1,0,0.1,0,0.1,0
              c0,0,0.6,3,1.4,6.3c0.7,1.8,1.4,2.6,2.8,2.6c0.3,0,0.5,0,0.7,0.1c0.4,0.1,0.9,0.4,0.3,1.2c-0.5,0.7-2,1.7-2.1,2.3
              c-0.4,1.8,1.3,2.5,3.1,2.6c2.5,0.2,1.5,1.7-1.2,3.7c-2.6,1.9,4.1,6.1,4.1,6.1c3.8,2.9,1.1,3.7,0.3,4.1c-0.8,0.4-2.9,1.7-0.8,2.5
              c2.2,0.8,5.1,3.8,5.1,3.8c3.8,4.4-1.6,2.6-3.6,2.8c-1.3,0.1-1.8,3.9,1.6,5.4c5.1,2.3,6.2,2.7,8,4c3.4,2.5,1.6,4.6-2.6,3.9
              c0,0-2.7-0.7-4.6-0.3c-1.2,0.2-2,0.5-2.5,0.8c-0.3,0.4-1,2.2,4.9,4c2.8,0.9,6.2,3,9.3,5.4l47.8,0l0-38.8L122.1,8.4L37.9,8.4
              L37.9,8.4z M110.1,102.8c1.4,2.3,2.2,5.3,2.8,9.6c0,2.6-3.5,1.4-4.6,0.7c-0.8-0.5-1.8-1-3.2-1.4c-2.5-0.6-8.6-3.3-10.2-3.8
              c-1.7-0.6-2.9,0.6-3.1,1.1h0c-0.4,0.8,0.5,2.4,0.5,2.4c2.4,5.4,6.7,5.1,11.5,8.5c6.6,4.7,3.1,5.7,1.7,5c-1.3-0.7-3.6-0.3-3.6-0.3
              c-5.3,1.5-6.9-0.8-10-1.6c-3.1-0.8-0.6,3,0.6,4.3c1.2,1.4,7.9,5.9,10.2,6.9c5.1,2.4,7.7,6.2,9.3,11.1c1.5,4.6-0.1,3.6-1.3,3
              c-1.2-0.6-1.6-1.8-4.6-1.7c-3,0.1-4.7-0.2-6.9-1.8c-0.6-0.4-1-0.9-1.4-1.4c0,0,0,0-0.1,0c-2.1-1.6-1.7,3.7-1.2,4.5
              c1.5,3,2.5,1.8,11.1,6.4c4.1,2.2,5,5.1,5.5,6.3c0.7,2,1.4,2.6-4.8,1.7c-2-0.3-5.6-1.5-7.3-2.7c-1.6-1.1-4.9-0.2-4.6,2.2
              c1.5,3.8,5.5,6.1,9.3,6.6c3.3,0.4,4.8,1.1,5.4,1.9c1.8,2.1-1.5,5.1-1.5,5.1c-1.7,1.9,0.1,4.2,1.4,4.9c2,1,5.9,3.4,7.2,6.7
              c6.8,17.4,0.2,12.4-3,10.4c-3.2-2-9.3-7.1-14.9-6.7c-5.6,0.4-7.4,0.7-10.8-1.9c-3.3-2.6-3,1.6-3,1.6v21c0.2,4.7,1.1,9.2,4.8,13
              c3.1,3.1,5.4,2.6,9.7,7.8c2,2.4,8.5,5,12.8,5.1l8.3,0l29.6-29.1v-80l-25.2-25.7L110.1,102.8L110.1,102.8z M8.3,174l0,34.5
              l29.6,29.1h9.5c9-0.4,12.3-7.4,15-11.7c2-3.2,5.7-6,8-8.3c2.4-2.5,2.9-8.1,2.9-14.2v-12.7l0,0.1v-3h0v-2h0v-0.5v-5.5
              c0-1.3-1.5-1.4-4.7,2.1c-3.2,3.5-8.7,3.2-11.8,3.5c-3.1,0.3-12.2,5-14.7,8.4c-1.6,2.1-3.9,0.4-2.9-3.8h0c0.4-1.9,1.2-4.4,2.5-7.7
              c1.8-4.6,8.5-7.3,8.5-7.3s0.7-0.3,1.3-0.9L8.3,174L8.3,174z"/>
          </g>
        </svg>

        <svg viewBox="0 0 65.973946 13.977815" version="1.1">
          <defs id="defs2">
            <g id="g85">
              <symbol id="glyph0-0" overflow="visible" style="overflow:visible">
                <path id="path10" d="M 0,0 H 5.5 V -7.703125 H 0 Z m 2.75,-4.34375 -1.875,-2.8125 h 3.75 z m 0.328125,0.5 1.875,-2.8125 v 5.609375 z M 0.875,-0.546875 l 1.875,-2.8125 1.875,2.8125 z m -0.328125,-6.109375 1.875,2.8125 -1.875,2.796875 z m 0,0" style="stroke:none" inkscape:connector-curvature="0"/>
              </symbol>
              <symbol id="glyph0-1" overflow="visible" style="overflow:visible">
                <path id="path13" d="M 7.046875,0 H 8.96875 L 8.609375,-7.40625 H 6 L 5.4375,-5.4375 c -0.21875,0.78125 -0.46875,1.828125 -0.671875,2.734375 h -0.03125 c -0.15625,-0.90625 -0.375,-1.890625 -0.59375,-2.703125 l -0.484375,-2 H 0.984375 L 0.53125,0 H 2.359375 L 2.46875,-2.65625 C 2.515625,-3.5 2.546875,-4.59375 2.578125,-5.640625 h 0.03125 C 2.78125,-4.625 3,-3.53125 3.203125,-2.734375 L 3.8125,-0.15625 H 5.375 l 0.734375,-2.578125 c 0.234375,-0.8125 0.546875,-1.921875 0.78125,-2.90625 h 0.03125 c 0,1.15625 0.015625,2.140625 0.046875,2.984375 z m 0,0" style="stroke:none" inkscape:connector-curvature="0"/>
              </symbol>
              <symbol id="glyph0-2" overflow="visible" style="overflow:visible">
                <path id="path16" d="m 5.421875,-3.140625 c 0,-1.359375 -0.640625,-2.390625 -2.5,-2.390625 -1.125,0 -1.90625,0.3125 -2.25,0.5 l 0.34375,1.234375 C 1.375,-4 1.96875,-4.1875 2.546875,-4.1875 c 0.71875,0 0.890625,0.234375 0.890625,0.453125 V -3.6875 c -1.84375,0 -3.15625,0.65625 -3.15625,2.109375 0,0.890625 0.6875,1.703125 1.796875,1.703125 0.578125,0 1.125,-0.171875 1.5,-0.59375 H 3.625 L 3.71875,0 h 1.796875 c -0.0625,-0.28125 -0.09375,-0.78125 -0.09375,-1.3125 z M 3.5,-2.03125 c 0,0.09375 0,0.1875 -0.03125,0.28125 -0.09375,0.296875 -0.390625,0.5 -0.671875,0.5 -0.34375,0 -0.5625,-0.1875 -0.5625,-0.515625 C 2.234375,-2.25 2.6875,-2.46875 3.5,-2.46875 Z m 0,0" style="stroke:none" inkscape:connector-curvature="0"/>
              </symbol>
              <symbol id="glyph0-3" overflow="visible" style="overflow:visible">
                <path id="path19" d="M 0.609375,0 H 2.59375 v -2.671875 c 0,-0.140625 0.015625,-0.25 0.03125,-0.34375 0.109375,-0.4375 0.5,-0.6875 1.078125,-0.6875 0.21875,0 0.359375,0.03125 0.515625,0.0625 V -5.5 C 4.0625,-5.53125 4,-5.53125 3.8125,-5.53125 c -0.46875,0 -1.15625,0.265625 -1.4375,1.09375 H 2.328125 L 2.25,-5.40625 H 0.5625 c 0.03125,0.4375 0.046875,0.96875 0.046875,1.8125 z m 0,0" style="stroke:none" inkscape:connector-curvature="0"/>
              </symbol>
              <symbol id="glyph0-4" overflow="visible" style="overflow:visible">
                <path id="path22" d="M 4.546875,-1.578125 C 4.296875,-1.46875 4.03125,-1.4375 3.6875,-1.4375 c -0.703125,0 -1.3125,-0.40625 -1.3125,-1.296875 -0.015625,-0.78125 0.515625,-1.28125 1.25,-1.28125 0.40625,0 0.671875,0.0625 0.859375,0.125 l 0.28125,-1.4375 c -0.390625,-0.140625 -0.859375,-0.1875 -1.25,-0.1875 -2.109375,0 -3.171875,1.3125 -3.171875,2.859375 0,1.703125 1.125,2.765625 2.9375,2.765625 0.609375,0 1.15625,-0.078125 1.484375,-0.234375 z m 0,0" style="stroke:none" inkscape:connector-curvature="0"/>
              </symbol>
              <symbol id="glyph0-5" overflow="visible" style="overflow:visible">
                <path id="path25" d="M 0.609375,0 H 2.59375 v -3.1875 c 0,-0.09375 0.015625,-0.234375 0.046875,-0.328125 C 2.734375,-3.71875 2.921875,-3.9375 3.28125,-3.9375 3.78125,-3.9375 4,-3.546875 4,-2.921875 V 0 h 1.984375 v -3.140625 c 0,-1.515625 -0.6875,-2.390625 -1.90625,-2.390625 -0.28125,0 -0.578125,0.0625 -0.828125,0.1875 -0.234375,0.125 -0.453125,0.28125 -0.625,0.5 H 2.59375 V -7.828125 H 0.609375 Z m 0,0" style="stroke:none" inkscape:connector-curvature="0"/>
              </symbol>
              <symbol id="glyph0-6" overflow="visible" style="overflow:visible">
                <path id="path28" d="M 5.734375,0 V -1.625 H 3.25 V -1.65625 L 3.953125,-2.203125 C 4.8125,-2.890625 5.625,-3.8125 5.625,-4.96875 c 0,-1.40625 -1,-2.296875 -2.65625,-2.296875 -1.015625,0 -1.90625,0.328125 -2.46875,0.75 l 0.546875,1.40625 c 0.390625,-0.28125 0.9375,-0.578125 1.53125,-0.578125 0.71875,0 1.0625,0.375 1.0625,0.890625 C 3.625,-4.0625 2.890625,-3.328125 1.4375,-2.0625 L 0.453125,-1.203125 V 0 Z m 0,0" style="stroke:none" inkscape:connector-curvature="0"/>
              </symbol>
              <symbol id="glyph0-7" overflow="visible" style="overflow:visible">
                <path id="path31" d="m 3.15625,0.125 c 1.921875,0 2.8125,-1.59375 2.8125,-3.71875 0,-1.8125 -0.71875,-3.671875 -2.8125,-3.671875 -2.015625,0 -2.8125,1.765625 -2.8125,3.703125 0,1.875 0.75,3.6875 2.796875,3.6875 z m 0,-1.484375 c -0.515625,0 -0.84375,-0.671875 -0.828125,-2.21875 0,-1.53125 0.328125,-2.203125 0.828125,-2.203125 0.53125,0 0.828125,0.703125 0.828125,2.203125 0,1.546875 -0.3125,2.21875 -0.8125,2.21875 z m 0,0" style="stroke:none" inkscape:connector-curvature="0"/>
              </symbol>
              <symbol id="glyph0-8" overflow="visible" style="overflow:visible">
                <path id="path34" d="m 2.59375,0 h 1.921875 v -7.15625 h -1.625 L 0.84375,-6.25 1.171875,-4.765625 2.578125,-5.40625 H 2.59375 Z m 0,0" style="stroke:none" inkscape:connector-curvature="0"/>
              </symbol>
              <symbol id="glyph1-0" overflow="visible" style="overflow:visible">
                <path id="path37" d="M 0,0 H 22.5 V -31.5 H 0 Z M 11.25,-17.78125 3.59375,-29.25 h 15.3125 z M 12.59375,-15.75 20.25,-27.21875 v 22.9375 z m -9,13.5 L 11.25,-13.71875 18.90625,-2.25 Z M 2.25,-27.21875 9.90625,-15.75 2.25,-4.28125 Z m 0,0" style="stroke:none" inkscape:connector-curvature="0"/>
              </symbol>
              <symbol id="glyph1-1" overflow="visible" style="overflow:visible">
                <path id="path40" d="M 3.640625,-30.328125 V 0 H 5.8125 v -30.328125 z m 0,0" style="stroke:none" inkscape:connector-curvature="0"/>
              </symbol>
              <symbol id="glyph1-2" overflow="visible" style="overflow:visible">
                <path id="path43" d="m 18.71875,-32 v 13.734375 H 18.625 c -0.9375,-1.890625 -3.328125,-3.828125 -7.0625,-3.828125 -5.3125,0 -9.765625,4.5 -9.71875,11.703125 0,6.4375 3.96875,10.890625 9.3125,10.890625 4.015625,0 6.578125,-2.203125 7.703125,-4.59375 H 18.9375 L 19.125,0 h 1.9375 C 20.921875,-1.53125 20.875,-3.421875 20.875,-5 v -27 z m 0,23.265625 c 0,0.671875 -0.04687,1.265625 -0.21875,1.796875 -0.90625,3.5625 -3.828125,5.625 -6.9375,5.625 C 6.4375,-1.3125 4,-5.765625 4,-10.625 c 0,-5.578125 2.96875,-9.671875 7.703125,-9.671875 3.5,0 6.078125,2.390625 6.796875,5.265625 0.171875,0.625 0.21875,1.390625 0.21875,1.984375 z m 0,0" style="stroke:none" inkscape:connector-curvature="0"/>
              </symbol>
              <symbol id="glyph1-3" overflow="visible" style="overflow:visible">
                <path id="path46" d="m 19.890625,-11.03125 c 0.09375,-0.40625 0.09375,-0.71875 0.09375,-1.296875 0,-3.109375 -1.359375,-9.765625 -8.421875,-9.765625 -5.578125,0 -9.71875,4.5 -9.71875,11.703125 0,6.34375 3.875,10.84375 10.078125,10.84375 3.78125,0 5.984375,-0.953125 6.796875,-1.390625 L 18.1875,-2.609375 c -1.21875,0.578125 -2.84375,1.21875 -6,1.21875 -4.453125,0 -8.234375,-2.75 -8.234375,-9.640625 z M 4.09375,-12.734375 c 0.40625,-3.328125 2.4375,-7.5625 7.203125,-7.5625 5.21875,0 6.484375,4.546875 6.4375,7.5625 z m 0,0" style="stroke:none" inkscape:connector-curvature="0"/>
              </symbol>
              <symbol id="glyph1-4" overflow="visible" style="overflow:visible">
                <path id="path49" d="M 3.640625,0 H 5.8125 v -13.40625 c 0,-0.671875 0.125,-1.40625 0.265625,-1.890625 0.859375,-2.84375 3.46875,-5 6.484375,-5 4.453125,0 5.984375,3.5625 5.984375,7.515625 V 0 h 2.15625 v -12.953125 c 0,-8.109375 -5.5,-9.140625 -7.5625,-9.140625 -3.515625,0 -6.25,1.9375 -7.421875,4.359375 H 5.625 L 5.484375,-21.59375 H 3.46875 c 0.125,1.703125 0.171875,3.1875 0.171875,5.171875 z m 0,0" style="stroke:none" inkscape:connector-curvature="0"/>
              </symbol>
              <symbol id="glyph1-5" overflow="visible" style="overflow:visible">
                <path id="path52" d="m 4.453125,-25.5625 v 3.96875 H 0.8125 v 1.75 H 4.453125 V -6.203125 C 4.453125,-4 4.8125,-2.15625 5.8125,-1.03125 6.609375,-0.046875 7.921875,0.453125 9.5,0.453125 c 1.296875,0 2.296875,-0.234375 3.015625,-0.5 l -0.28125,-1.625 c -0.53125,0.1875 -1.34375,0.328125 -2.46875,0.328125 -2.296875,0 -3.15625,-1.71875 -3.15625,-4.46875 v -14.03125 h 6.171875 v -1.75 H 6.609375 V -26.375 Z m 0,0" style="stroke:none" inkscape:connector-curvature="0"/>
              </symbol>
              <symbol id="glyph1-6" overflow="visible" style="overflow:visible">
                <path id="path55" d="M 5.8125,0 V -21.59375 H 3.640625 V 0 Z m -1.125,-25.921875 c 1.078125,0 1.75,-0.859375 1.75,-1.84375 0,-1.03125 -0.71875,-1.890625 -1.71875,-1.890625 -0.984375,0 -1.75,0.90625 -1.75,1.890625 0,0.984375 0.671875,1.84375 1.671875,1.84375 z m 0,0" style="stroke:none" inkscape:connector-curvature="0"/>
              </symbol>
              <symbol id="glyph1-7" overflow="visible" style="overflow:visible">
                <path id="path58" d="m 0.5,-21.59375 8,20.015625 C 8.6875,-1.125 8.78125,-0.8125 8.78125,-0.625 8.78125,-0.40625 8.6875,-0.140625 8.5,0.3125 7.421875,2.875 5.984375,4.6875 4.90625,5.765625 3.59375,6.96875 2.203125,7.734375 1.125,8.140625 L 1.796875,9.9375 c 0.5,-0.171875 2.078125,-0.796875 3.78125,-2.25 2.84375,-2.46875 4.6875,-6.46875 7.296875,-13.171875 L 19.34375,-21.59375 H 17.0625 l -5.265625,13.984375 c -0.6875,1.765625 -1.21875,3.46875 -1.671875,4.78125 H 10.03125 C 9.625,-4.1875 9.046875,-5.9375 8.453125,-7.46875 l -5.65625,-14.125 z m 0,0" style="stroke:none" inkscape:connector-curvature="0"/>
              </symbol>
              <symbol id="glyph1-8" overflow="visible" style="overflow:visible">
                <path id="path61" d="m 20.875,-16.015625 c 0,-2.25 0.04687,-3.96875 0.1875,-5.578125 h -1.984375 l -0.140625,3.640625 h -0.07813 C 17.953125,-19.75 15.84375,-22.09375 11.5625,-22.09375 c -4.765625,0 -9.71875,3.953125 -9.71875,11.46875 C 1.84375,-4.71875 5.671875,0 11.109375,0 14.984375,0 17.5,-1.984375 18.625,-4.1875 h 0.09375 v 3.0625 c 0,6.390625 -3.28125,8.734375 -7.828125,8.734375 -2.796875,0 -4.90625,-0.8125 -6.4375,-1.796875 L 3.6875,7.515625 C 5.359375,8.78125 8.09375,9.40625 10.578125,9.40625 13,9.40625 15.9375,8.734375 17.90625,6.84375 19.703125,5.125 20.875,2.390625 20.875,-3.15625 Z m -2.15625,7.0625 c 0,0.765625 -0.140625,1.578125 -0.359375,2.296875 -1.125,3.0625 -3.828125,4.859375 -6.703125,4.859375 C 6.5625,-1.796875 4,-5.984375 4,-10.84375 c 0,-5.71875 3.15625,-9.453125 7.75,-9.453125 3.546875,0 5.796875,2.34375 6.703125,4.90625 0.21875,0.625 0.265625,1.3125 0.265625,2.109375 z m 0,0" style="stroke:none" inkscape:connector-curvature="0"/>
              </symbol>
              <symbol id="glyph1-9" overflow="visible" style="overflow:visible">
                <path id="path64" d="m 20.296875,-21.59375 h -2.15625 v 13.453125 c 0,0.84375 -0.1875,1.703125 -0.40625,2.375 -0.953125,2.171875 -3.25,4.375 -6.390625,4.375 -4.28125,0 -5.71875,-3.375 -5.71875,-8.0625 V -21.59375 H 3.46875 v 12.546875 c 0,8.140625 4.625,9.546875 7.375,9.546875 3.828125,0 6.296875,-2.34375 7.375,-4.375 H 18.3125 L 18.453125,0 h 2.015625 c -0.125,-1.671875 -0.171875,-3.375 -0.171875,-5.265625 z m 0,0" style="stroke:none" inkscape:connector-curvature="0"/>
              </symbol>
              <symbol id="glyph1-10" overflow="visible" style="overflow:visible">
                <path id="path67" d="M 3.640625,0 H 5.8125 V -32 H 3.640625 Z m 0,0" style="stroke:none" inkscape:connector-curvature="0"/>
              </symbol>
              <symbol id="glyph1-11" overflow="visible" style="overflow:visible">
                <path id="path70" d="m 1.984375,-1.03125 c 1.4375,0.890625 3.421875,1.484375 5.484375,1.484375 4.40625,0 7.296875,-2.484375 7.296875,-6.171875 C 14.765625,-9 12.6875,-10.75 9.1875,-12.15625 6.25,-13.359375 4.71875,-14.3125 4.71875,-16.5625 c 0,-1.984375 1.453125,-3.734375 4.1875,-3.734375 2.15625,0 3.5625,0.765625 4.328125,1.3125 l 0.8125,-1.765625 c -1.09375,-0.765625 -2.796875,-1.34375 -4.78125,-1.34375 -4.1875,0 -6.65625,2.703125 -6.65625,5.84375 0,2.609375 1.9375,4.546875 5.484375,5.90625 3.109375,1.25 4.546875,2.515625 4.546875,4.90625 0,2.25 -1.609375,4.09375 -5.03125,4.09375 -1.9375,0 -3.6875,-0.765625 -4.859375,-1.484375 z m 0,0" style="stroke:none" inkscape:connector-curvature="0"/>
              </symbol>
              <symbol id="glyph1-12" overflow="visible" style="overflow:visible">
                <path id="path73" d="m 1.34375,-12.328125 v 1.75 h 19.8125 v -1.75 z m 0,0" style="stroke:none" inkscape:connector-curvature="0"/>
              </symbol>
              <symbol id="glyph1-13" overflow="visible" style="overflow:visible">
                <path id="path76" d="m 5.9375,0 v -19.84375 h 5.765625 v -1.75 H 5.9375 v -1.21875 c 0,-4.140625 0.8125,-7.828125 4.859375,-7.828125 1.3125,0 2.125,0.265625 2.75,0.578125 l 0.671875,-1.625 c -0.671875,-0.390625 -1.84375,-0.75 -3.234375,-0.75 -1.71875,0 -3.46875,0.578125 -4.8125,1.875 -1.765625,1.765625 -2.390625,4.46875 -2.390625,7.796875 v 1.171875 H 0.671875 v 1.75 H 3.78125 V 0 Z m 0,0" style="stroke:none" inkscape:connector-curvature="0"/>
              </symbol>
              <symbol id="glyph1-14" overflow="visible" style="overflow:visible">
                <path id="path79" d="M 3.640625,0 H 5.8125 v -13.1875 c 0,-0.890625 0.03125,-1.484375 0.265625,-2.15625 0.9375,-2.65625 3.46875,-4.859375 6.515625,-4.859375 4.421875,0 5.953125,3.546875 5.953125,7.421875 V 0 h 2.15625 v -13 c 0,-8.0625 -5.5,-9.09375 -7.515625,-9.09375 -1.625,0 -3.109375,0.5 -4.375,1.265625 -1.25,0.765625 -2.28125,1.890625 -2.921875,3.09375 H 5.8125 V -32 H 3.640625 Z m 0,0" style="stroke:none" inkscape:connector-curvature="0"/>
              </symbol>
              <symbol id="glyph1-15" overflow="visible" style="overflow:visible">
                <path id="path82" d="m 11.796875,0.5 c 4.765625,0 10.296875,-3.46875 10.296875,-11.484375 0,-6.609375 -4.046875,-11.109375 -10.03125,-11.109375 -5.359375,0 -10.21875,4.09375 -10.21875,11.46875 0,6.75 4.328125,11.125 9.90625,11.125 z m 0.03125,-1.8125 C 7.421875,-1.3125 4,-5.359375 4,-10.75 c 0,-4.640625 2.484375,-9.546875 8.015625,-9.546875 5.71875,0 7.921875,5.453125 7.921875,9.40625 0,5.53125 -3.5625,9.578125 -8.0625,9.578125 z m 0,0" style="stroke:none" inkscape:connector-curvature="0"/>
              </symbol>
            </g>
            <clipPath id="clip1">
              <path id="path87" d="m 0,537 h 859.89062 v 27 H 0 Z m 0,0" inkscape:connector-curvature="0"/>
            </clipPath>
            <clipPath id="clip2">
              <path id="path90" d="M 43.015625,48.367188 H 76 V 87 H 43.015625 Z m 0,0" inkscape:connector-curvature="0"/>
            </clipPath>
            <clipPath id="clip3">
              <path id="path93" d="M 43.015625,49 H 76 V 87 H 43.015625 Z m 0,0" inkscape:connector-curvature="0"/>
            </clipPath>
            <clipPath id="clip4">
              <path id="path96" d="M 43.015625,49 H 57 V 63 H 43.015625 Z m 0,0" inkscape:connector-curvature="0"/>
            </clipPath>
            <clipPath id="clip5">
              <path id="path99" d="M 43.015625,68 H 57 V 85 H 43.015625 Z m 0,0" inkscape:connector-curvature="0"/>
            </clipPath>
            <clipPath id="clip6">
              <path id="path102" d="m 158,48.367188 h 9 V 63 h -9 z m 0,0" inkscape:connector-curvature="0"/>
            </clipPath>
            <clipPath id="clip7">
              <path id="path105" d="m 215,67 h 13.89453 V 85 H 215 Z m 0,0" inkscape:connector-curvature="0"/>
            </clipPath>
            <clipPath id="clip8">
              <path id="path108" d="m 174,48.367188 h 13 V 63 h -13 z m 0,0" inkscape:connector-curvature="0"/>
            </clipPath>
            <clipPath id="clip9">
              <path id="path111" d="m 203,48.367188 h 15 V 63 h -15 z m 0,0" inkscape:connector-curvature="0"/>
            </clipPath>
            <clipPath id="clip10">
              <path id="path114" d="m 219,49 h 9.89453 V 63 H 219 Z m 0,0" inkscape:connector-curvature="0"/>
            </clipPath>
            <clipPath id="clip11">
              <path id="path117" d="m 0,510 h 859.89062 v 29 H 0 Z m 0,0" inkscape:connector-curvature="0"/>
            </clipPath>
            <clipPath id="clip12">
              <path id="path120" d="M 0,399 H 859.89062 V 512 H 0 Z m 0,0" inkscape:connector-curvature="0"/>
            </clipPath>
          </defs>
          <sodipodi:namedview id="base" pagecolor="#00ffff" bordercolor="#666666" borderopacity="1.0" inkscape:pageopacity="0" inkscape:pageshadow="2" inkscape:zoom="0.35" inkscape:cx="325.90739" inkscape:cy="-320.55752" inkscape:document-units="mm" inkscape:current-layer="layer1" showgrid="false" fit-margin-left="0.2" fit-margin-top="0.2" fit-margin-right="0.2" fit-margin-bottom="0.2" inkscape:window-width="1920" inkscape:window-height="1017" inkscape:window-x="-8" inkscape:window-y="-8" inkscape:window-maximized="1"/>
          <metadata id="metadata5">
            <rdf:RDF>
              <cc:Work rdf:about="">
                <dc:format>image/svg+xml</dc:format>
                <dc:type rdf:resource="http://purl.org/dc/dcmitype/StillImage"/>
                <dc:title/>
              </cc:Work>
            </rdf:RDF>
          </metadata>
          <g inkscape:label="Layer 1" inkscape:groupmode="layer" id="layer1" transform="translate(-28.664392,-97.019405)">
            <g id="g1070" transform="translate(100.35268,-14.174107)">
              <g transform="matrix(0.35277778,0,0,0.35277778,-86.663248,94.330643)" id="g133" clip-path="url(#clip2)" style="clip-rule:nonzero">
                <path id="path131" d="M 50.648438,48.976563 H 68.3125 l 0.808594,-0.0078 h 1.796875 c 0.859375,0 2.273437,-0.04297 4.269531,-0.125 l 0.746094,-0.03125 c -0.109375,1.546875 -0.128906,2.15625 -0.132813,2.976563 l -0.01172,2.375 -0.0078,2.25 v 12.566406 c 0,7.914062 -1.792969,10.601562 -10.328125,14.816406 -0.378906,0.1875 -4.730469,2.359375 -5.183594,2.601563 l -0.425781,0.230468 -0.4375,0.226563 -0.433594,-0.226563 -0.4375,-0.230468 C 56.742188,85.460938 54.921875,84.632813 53.507813,83.9375 45.6875,80.101563 43.183594,77.378906 43.183594,68.980469 V 56.414063 l -0.02344,-2.25 -0.0078,-2.375 c -0.0078,-1.433594 -0.02344,-1.898438 -0.136719,-2.976563 l 0.746094,0.03125 c 1.964844,0.07813 3.429687,0.125 4.28125,0.125 h 1.785156 l 0.820313,0.0078" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none" inkscape:connector-curvature="0"/>
              </g>
              <g transform="matrix(0.35277778,0,0,0.35277778,-86.663248,94.330643)" id="g137" clip-path="url(#clip3)" style="clip-rule:nonzero">
                <path id="path135" d="m 59.40625,86.085938 3.363281,-1.648438 0.08594,-0.03125 -0.02344,-0.07422 V 68.86328 l -0.03125,-0.09375 0.105469,0.01953 h 12.167969 l 0.105469,0.03125 -0.03125,-0.132813 v -6.558594 l 0.03125,-0.105468 -0.105469,0.03125 H 62.90625 l -0.105469,0.01953 0.03125,-0.105469 V 49.664063 l 0.02344,-0.105469 -0.09375,0.03125 h -6.664063 l -0.105468,-0.03125 0.03125,0.105469 V 61.96875 l 0.02344,0.105469 -0.09766,-0.01953 H 43.875 l -0.105469,-0.03125 0.03125,0.105468 V 68.75 l -0.03125,0.07031 0.105469,-0.03125 h 12.074219 l 0.09766,-0.01953 -0.02344,0.125 v 15.40625 l -0.03125,0.125 0.08203,0.02344 3.332031,1.636719" style="fill:#ffffff;fill-opacity:1;fill-rule:nonzero;stroke:none" inkscape:connector-curvature="0"/>
              </g>
              <g transform="matrix(0.35277778,0,0,0.35277778,-86.663248,94.330643)" id="g141" clip-path="url(#clip4)" style="clip-rule:nonzero">
                <path id="path139" d="m 43.929688,49.589844 -0.160157,-0.03125 0.03125,0.117187 v 12.316407 l -0.03125,0.09375 0.148438,-0.03125 h 12.023437 l 0.101563,0.03125 -0.01953,-0.105469 V 49.644531 l 0.01953,-0.08594 -0.101563,0.03125 H 43.929688" style="fill:#ee2e4f;fill-opacity:1;fill-rule:nonzero;stroke:none" inkscape:connector-curvature="0"/>
              </g>
              <path id="path143" d="m -64.452028,111.82484 -0.05237,-0.011 0.0069,0.0413 v 4.34496 l -0.0069,0.0331 0.04823,-0.011 h 4.274674 l 0.03996,0.011 -0.01102,-0.0372 v -4.35185 l 0.01102,-0.0303 -0.03996,0.011 h -4.27054" style="fill:#ee2e4f;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <g transform="matrix(0.35277778,0,0,0.35277778,-86.663248,94.330643)" id="g147" clip-path="url(#clip5)" style="clip-rule:nonzero">
                <path id="path145" d="M 55.992188,68.792969 H 43.84375 l -0.07422,-0.03125 0.03125,0.08203 v 0.734375 c 0,6.761719 2.257813,10.050781 9.207032,13.410156 l 2.195312,1.0625 0.765625,0.355469 0.0625,0.07422 -0.0078,-0.105469 V 68.855469 l 0.02344,-0.09375 -0.05469,0.03125" style="fill:#ee2e4f;fill-opacity:1;fill-rule:nonzero;stroke:none" inkscape:connector-curvature="0"/>
              </g>
              <path id="path149" d="m -64.475455,118.59927 -0.02894,-0.011 0.0069,0.0248 v 5.46806 l -0.0069,0.0413 0.02894,-0.0331 0.245291,-0.11162 c 3.327962,-1.56683 4.077615,-2.49977 4.077615,-5.07945 v -0.27423 l 0.01102,-0.0372 -0.03721,0.011 -4.296723,0.001" style="fill:#ee2e4f;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path151" d="m -70.514018,116.43713 c 0.01102,0.0124 0.02067,0.0234 0.02618,0.0289 0.01378,0.0165 0.02343,0.0276 0.02894,0.0331 0.0055,0.006 0.01653,0.0165 0.03445,0.0345 0.0055,0.007 0.01653,0.0165 0.02894,0.0289 -0.0096,0.008 -0.01654,0.0138 -0.01791,0.0152 l -0.03721,0.0331 -0.03032,0.0331 -0.01102,0.0124 v 0.0345 c 0,0.30042 0.07855,0.50437 0.24529,0.63941 l 0.02894,0.0248 -0.02894,0.0193 -0.03445,-0.003 -0.07028,-0.008 -0.06201,-0.011 -0.03721,-0.007 -0.03721,0.26734 h -0.05237 l -0.03721,-0.26734 -0.03721,0.007 c -0.03169,0.007 -0.05099,0.011 -0.05926,0.011 l -0.07304,0.008 -0.03445,0.003 c -0.01516,0 -0.02756,-0.006 -0.02756,-0.011 0,-0.007 0.0055,-0.0152 0.01653,-0.0234 l 0.05512,-0.0427 c 0.04686,-0.0358 0.07718,-0.0786 0.130919,-0.18879 0.02343,-0.0496 0.03721,-0.0923 0.03721,-0.12265 0,-0.0786 0.0124,-0.14056 0.02618,-0.14056 l 0.0069,-0.1378 0.0041,-0.051 -0.01516,-0.0124 -0.03032,-0.0331 -0.03721,-0.0331 -0.01378,-0.0152 c 0.0124,-0.0124 0.02205,-0.022 0.02894,-0.0289 0.05099,-0.051 0.0565,-0.0565 0.08544,-0.0965" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path153" d="m -69.108419,116.43713 c 0.02894,0.04 0.03307,0.0455 0.08544,0.0965 0.0055,0.007 0.01654,0.0165 0.02894,0.0289 l -0.01516,0.0152 -0.03721,0.0331 -0.02894,0.0331 -0.01791,0.0124 0.0069,0.051 0.0069,0.1378 c 0.01103,0.19568 0.11989,0.42306 0.234267,0.48507 0.01929,0.011 0.03169,0.0207 0.03169,0.0248 0,0.01 -0.0083,0.0179 -0.01791,0.0179 l -0.04823,-0.001 -0.07028,-0.008 -0.06339,-0.011 -0.03583,-0.007 -0.03721,0.26734 h -0.04823 l -0.03721,-0.26734 -0.03721,0.007 -0.06339,0.011 -0.07028,0.008 -0.03307,0.003 -0.0055,0.001 c -0.01516,0 -0.0248,-0.006 -0.0248,-0.0124 0,-0.007 0.0055,-0.0165 0.01516,-0.0234 l 0.05512,-0.0427 c 0.04961,-0.0372 0.06201,-0.0565 0.130913,-0.18879 0.02618,-0.0524 0.03996,-0.0937 0.03996,-0.12265 0,-0.0785 0.01102,-0.14056 0.02205,-0.14056 l 0.0083,-0.1378 0.0028,-0.051 c -0.0041,-0.006 -0.0083,-0.01 -0.01102,-0.0124 -0.01929,-0.0193 -0.03032,-0.0303 -0.03307,-0.0331 l -0.03721,-0.0331 -0.01378,-0.0152 c 0.0124,-0.0124 0.02205,-0.022 0.02894,-0.0289 0.01792,-0.0179 0.02894,-0.0289 0.03307,-0.0345 0.0055,-0.006 0.01654,-0.0165 0.03032,-0.0331 0.0055,-0.006 0.01378,-0.0165 0.02618,-0.0289" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path155" d="m -69.809841,117.25982 0.02618,0.0303 0.02618,0.0331 c 0.0055,0.008 0.01653,0.0193 0.03307,0.0331 l 0.03307,0.0289 -0.01791,0.0152 -0.03307,0.0345 -0.03445,0.0289 -0.01102,0.0152 v 0.0344 c 0,0.30868 0.07441,0.50023 0.245291,0.63941 l 0.02894,0.0248 -0.02894,0.0207 -0.03307,-0.004 -0.07166,-0.007 -0.06201,-0.0124 -0.03721,-0.007 -0.03721,0.26734 h -0.05099 l -0.03859,-0.26734 -0.03721,0.007 -0.06201,0.0124 -0.07028,0.007 -0.03445,0.004 h -0.0028 c -0.01516,0 -0.02618,-0.006 -0.02618,-0.0124 0,-0.006 0.0069,-0.0138 0.01791,-0.0234 l 0.0565,-0.0427 c 0.118512,-0.091 0.199816,-0.339 0.199816,-0.60634 v -0.0344 l -0.01102,-0.0152 -0.03307,-0.0289 -0.03445,-0.0345 -0.01791,-0.0152 c 0.0565,-0.0482 0.08406,-0.0772 0.118512,-0.1254" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path157" d="m -68.400108,117.25982 c 0.03445,0.0482 0.06201,0.0772 0.118512,0.1254 l -0.01929,0.0152 -0.03307,0.0345 -0.03307,0.0289 -0.01102,0.0152 -0.0014,0.0344 c 0,0.2012 0.05926,0.44373 0.12678,0.52228 l 0.07441,0.0841 c 0.0055,0.007 0.01929,0.0179 0.03996,0.0331 l 0.03445,0.0248 -0.03032,0.0207 -0.03307,-0.004 -0.07028,-0.007 -0.06339,-0.0124 -0.03721,-0.007 -0.03721,0.26734 h -0.05099 l -0.03721,-0.26734 -0.03721,0.007 -0.06339,0.0124 -0.07028,0.007 -0.03307,0.004 h -0.0041 c -0.01378,0 -0.02618,-0.006 -0.02618,-0.0124 0,-0.007 0.0069,-0.0152 0.01653,-0.0234 l 0.05375,-0.0427 c 0.117133,-0.0923 0.20395,-0.34038 0.20395,-0.60634 v -0.0344 l -0.01102,-0.0152 -0.03307,-0.0289 -0.03307,-0.0345 -0.01929,-0.0152 c 0.01516,-0.0124 0.02618,-0.0221 0.03445,-0.0289 0.01516,-0.0138 0.02618,-0.0248 0.03307,-0.0331 l 0.02618,-0.0331 0.02618,-0.0303" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path159" d="m -67.69593,116.43713 c 0.02894,0.04 0.03307,0.0455 0.08406,0.0965 0.0069,0.007 0.01791,0.0165 0.03032,0.0289 l -0.01516,0.0152 -0.03721,0.0331 -0.02894,0.0331 -0.01516,0.0124 0.0041,0.051 0.0069,0.1378 c 0.01102,0.19155 0.122646,0.42582 0.234267,0.48507 0.01929,0.011 0.03032,0.0207 0.03032,0.0248 0,0.01 -0.0055,0.0179 -0.01378,0.0179 l -0.04685,-0.001 -0.07441,-0.008 c -0.01516,-0.001 -0.03583,-0.004 -0.06339,-0.011 l -0.03307,-0.007 -0.03583,0.26734 h -0.05237 l -0.03721,-0.26734 -0.03859,0.01 -0.06201,0.008 -0.07028,0.008 -0.03307,0.003 -0.0055,0.001 c -0.01378,0 -0.0248,-0.006 -0.0248,-0.0124 0,-0.006 0.0069,-0.0152 0.01653,-0.0234 l 0.05512,-0.0427 c 0.04823,-0.0386 0.06477,-0.062 0.129535,-0.18879 0.02618,-0.0524 0.03996,-0.0951 0.03996,-0.12265 0,-0.0786 0.01103,-0.14056 0.02205,-0.14056 l 0.0083,-0.1378 0.0028,-0.051 -0.01103,-0.0124 -0.03307,-0.0331 c -0.01653,-0.0165 -0.02756,-0.0276 -0.03307,-0.0331 -0.0028,-0.003 -0.0096,-0.008 -0.01929,-0.0152 0.01378,-0.0124 0.02343,-0.022 0.03032,-0.0289 0.01791,-0.0179 0.02894,-0.0289 0.03307,-0.0345 0.0069,-0.006 0.01653,-0.0165 0.03032,-0.0331 0.0055,-0.006 0.01378,-0.0165 0.02618,-0.0289" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path161" d="m -63.696863,116.43024 0.02618,0.0331 0.02618,0.0289 c 0.01791,0.0207 0.02894,0.0331 0.03307,0.0372 0.0069,0.007 0.01791,0.0165 0.03307,0.0303 l -0.01791,0.0138 -0.03307,0.0344 -0.03445,0.0289 -0.01103,0.0152 v 0.0317 c 0,0.29903 0.100597,0.55948 0.245291,0.63941 0.02205,0.0124 0.03169,0.022 0.03169,0.0317 l -0.0014,0.006 -0.03032,0.007 h -0.03307 c -0.0441,0 -0.121267,-0.0138 -0.170877,-0.0289 l -0.03721,0.26596 h -0.05236 l -0.03583,-0.26596 c -0.05236,0.0165 -0.128158,0.0289 -0.170877,0.0289 h -0.03307 c -0.02205,0 -0.03169,-0.004 -0.03169,-0.0124 0,-0.011 0.0096,-0.0207 0.03169,-0.0317 0.141938,-0.0744 0.243913,-0.34175 0.243913,-0.63941 v -0.0317 l -0.01102,-0.0152 -0.03307,-0.0289 -0.03307,-0.0344 -0.01929,-0.0138 c 0.01516,-0.0138 0.02756,-0.0234 0.03307,-0.0303 0.0055,-0.004 0.01653,-0.0165 0.03445,-0.0372 l 0.0248,-0.0289 0.02618,-0.0331" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path163" d="m -62.284374,116.43024 0.02618,0.0331 0.03032,0.0289 0.03307,0.0372 0.02894,0.0303 -0.01791,0.0138 -0.03307,0.0344 -0.03445,0.0289 -0.01102,0.0152 v 0.0317 c 0,0.2949 0.101974,0.56086 0.24529,0.63941 0.02205,0.0124 0.03169,0.022 0.03169,0.0317 l -0.0014,0.006 -0.03032,0.007 h -0.03307 c -0.0441,0 -0.121267,-0.0138 -0.170876,-0.0289 l -0.03721,0.26596 h -0.05237 l -0.03583,-0.26596 c -0.06063,0.0193 -0.126779,0.0289 -0.186035,0.0289 -0.03996,0 -0.04823,-0.003 -0.04823,-0.0152 0,-0.01 0.0083,-0.0179 0.03307,-0.0289 0.03032,-0.0138 0.08406,-0.0689 0.115755,-0.11851 0.05788,-0.0937 0.09233,-0.17501 0.09233,-0.22324 0,-0.0799 0.0124,-0.1447 0.02618,-0.1447 l 0.0069,-0.13642 0.0041,-0.0482 c -0.0069,-0.007 -0.01102,-0.011 -0.01516,-0.0152 -0.04685,-0.0469 -0.05099,-0.051 -0.08544,-0.0772 l 0.03307,-0.0303 0.03445,-0.0372 0.02894,-0.0289 0.02205,-0.0331" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path165" d="m -62.988552,117.25293 c 0.0124,0.0124 0.02067,0.022 0.02618,0.0289 0.01378,0.0165 0.0248,0.0276 0.03032,0.0345 0.0041,0.004 0.01378,0.0165 0.03032,0.0344 0.0069,0.007 0.01929,0.0138 0.03169,0.0276 l -0.01791,0.0152 -0.03307,0.0372 -0.03445,0.0289 -0.01102,0.0152 0.0041,0.0482 0.0069,0.1378 c 0.01102,0.20258 0.117133,0.42168 0.234267,0.48507 0.02205,0.0124 0.03169,0.0221 0.03169,0.0331 l -0.0028,0.004 -0.02894,0.007 h -0.03307 c -0.0441,0 -0.121268,-0.0124 -0.170877,-0.0289 l -0.03721,0.26596 h -0.05237 l -0.03721,-0.26596 c -0.04961,0.0179 -0.122645,0.0303 -0.186035,0.0303 -0.03721,0 -0.04685,-0.004 -0.04685,-0.0179 0,-0.01 0.0096,-0.0179 0.03307,-0.0276 0.02894,-0.0124 0.08544,-0.0703 0.115756,-0.11851 0.06063,-0.0992 0.09646,-0.1819 0.09646,-0.22186 0,-0.0799 0.0096,-0.1447 0.02205,-0.1447 l 0.0069,-0.1378 0.0041,-0.0482 -0.01516,-0.0152 -0.03032,-0.0289 -0.03721,-0.0372 -0.01378,-0.0152 c 0.0124,-0.0124 0.02343,-0.0234 0.02894,-0.0289 0.05237,-0.051 0.0565,-0.0565 0.08544,-0.0965" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path167" d="m -61.565038,117.25293 c 0.0124,0.0124 0.02067,0.022 0.02618,0.0289 0.01378,0.0165 0.0248,0.0276 0.03032,0.0345 0.0041,0.004 0.01516,0.0152 0.03307,0.0331 0.0069,0.006 0.01653,0.0152 0.02894,0.0289 -0.0055,0.007 -0.01102,0.0124 -0.01378,0.0152 -0.02205,0.0207 -0.03307,0.0331 -0.03721,0.0372 -0.02067,0.0179 -0.03169,0.0276 -0.03445,0.0289 -0.0014,0.003 -0.0055,0.007 -0.01102,0.0152 l 0.0041,0.0482 0.0069,0.1378 c 0.01102,0.20257 0.117134,0.42168 0.234267,0.48507 0.02205,0.0124 0.03169,0.0221 0.03169,0.0331 l -0.0028,0.004 -0.02894,0.007 h -0.03307 c -0.0441,0 -0.121268,-0.0124 -0.170877,-0.0289 l -0.03721,0.26596 h -0.04823 l -0.04134,-0.26596 c -0.04961,0.0179 -0.122645,0.0303 -0.184657,0.0303 -0.03859,0 -0.04823,-0.004 -0.04823,-0.0179 0,-0.01 0.0096,-0.0179 0.03307,-0.0276 0.02894,-0.0124 0.08544,-0.0703 0.115755,-0.11851 0.05925,-0.0992 0.09646,-0.1819 0.09646,-0.22187 0,-0.0799 0.0096,-0.14469 0.02205,-0.14469 l 0.0069,-0.1378 0.0041,-0.0482 -0.01516,-0.0152 -0.03032,-0.0289 -0.03721,-0.0372 -0.01378,-0.0152 c 0.0124,-0.0124 0.02343,-0.0234 0.02894,-0.0289 0.05237,-0.051 0.0565,-0.0565 0.08544,-0.0965" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path169" d="m -60.860861,116.43024 0.02618,0.0331 0.03032,0.0289 0.03307,0.0372 0.02894,0.0303 -0.01791,0.0138 -0.03307,0.0344 -0.03445,0.0289 -0.0096,0.0152 v 0.0317 c 0,0.2949 0.100597,0.56086 0.243913,0.63941 0.02205,0.0124 0.03169,0.022 0.03169,0.0317 l -0.0014,0.006 -0.03032,0.007 h -0.03307 c -0.0441,0 -0.121267,-0.0138 -0.170876,-0.0289 l -0.03721,0.26596 h -0.05237 l -0.03583,-0.26596 c -0.06063,0.0193 -0.12678,0.0289 -0.186036,0.0289 -0.03996,0 -0.04823,-0.003 -0.04823,-0.0152 0,-0.01 0.0083,-0.0179 0.03307,-0.0289 0.03032,-0.0138 0.08406,-0.0689 0.115755,-0.11851 0.05788,-0.0937 0.09233,-0.17501 0.09233,-0.22324 0,-0.0799 0.0124,-0.1447 0.02618,-0.1447 l 0.0069,-0.13642 0.0041,-0.0482 c -0.0069,-0.007 -0.01102,-0.011 -0.01516,-0.0152 -0.01653,-0.0165 -0.02618,-0.0262 -0.02894,-0.0289 l -0.03721,-0.0344 -0.01516,-0.0138 0.02894,-0.0303 0.03445,-0.0372 0.02894,-0.0289 0.02205,-0.0331" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path171" d="m -66.346831,120.25981 c 0.02894,0.0386 0.03307,0.0455 0.08544,0.0965 0.0055,0.006 0.01653,0.0152 0.02894,0.0289 l -0.01378,0.0152 -0.03858,0.0331 -0.02894,0.0331 -0.01516,0.0151 0.0041,0.0482 0.0069,0.1378 c 0.0069,0.11989 0.05788,0.27699 0.118512,0.36656 0.04134,0.0592 0.08682,0.10611 0.115755,0.11851 0.0248,0.011 0.03307,0.0179 0.03307,0.0303 0,0.0124 -0.0083,0.0138 -0.05237,0.0138 -0.05788,0 -0.133669,-0.0124 -0.181901,-0.0289 l -0.03583,0.26596 h -0.05236 l -0.03721,-0.26596 c -0.04961,0.0152 -0.12678,0.0289 -0.170877,0.0289 h -0.03307 c -0.02205,0 -0.03032,-0.004 -0.03032,-0.0124 0,-0.011 0.0083,-0.0207 0.03032,-0.0317 0.03583,-0.0193 0.08682,-0.0703 0.114377,-0.11851 0.06615,-0.10887 0.09646,-0.1819 0.09646,-0.22187 0.0014,-0.0813 0.01102,-0.14469 0.02343,-0.14469 l 0.0069,-0.1378 0.0041,-0.0482 -0.01102,-0.0151 -0.03445,-0.0331 -0.03307,-0.0331 -0.01791,-0.0152 c 0.0124,-0.0138 0.02205,-0.0234 0.02894,-0.0289 0.01791,-0.0179 0.02894,-0.0289 0.03307,-0.0344 0.0069,-0.006 0.01653,-0.0165 0.03032,-0.0331 0.0055,-0.007 0.01378,-0.0165 0.02618,-0.0289" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path173" d="m -65.023914,120.25981 c 0.02894,0.0386 0.03445,0.0455 0.08544,0.0965 0.0069,0.006 0.01653,0.0152 0.03032,0.0289 l -0.01516,0.0152 -0.03721,0.0331 -0.03032,0.0331 -0.01378,0.0151 0.0028,0.0482 0.0083,0.1378 c 0.0069,0.11989 0.0565,0.27699 0.118512,0.36656 0.03996,0.0592 0.08544,0.10611 0.114377,0.11851 0.0248,0.011 0.03445,0.0179 0.03445,0.0303 0,0.0124 -0.0096,0.0138 -0.05237,0.0138 -0.05788,0 -0.13367,-0.0124 -0.181901,-0.0289 l -0.03721,0.26596 h -0.05237 l -0.03721,-0.26596 c -0.04961,0.0152 -0.126779,0.0289 -0.169498,0.0289 h -0.03445 c -0.02067,0 -0.03032,-0.004 -0.03032,-0.0124 0,-0.011 0.0096,-0.0207 0.03032,-0.0317 0.03721,-0.0193 0.08682,-0.0703 0.115755,-0.11851 0.06477,-0.10887 0.09646,-0.1819 0.09646,-0.22187 0,-0.0813 0.0096,-0.14469 0.02205,-0.14469 l 0.0069,-0.1378 0.0041,-0.0482 -0.01103,-0.0151 -0.06615,-0.0662 -0.01929,-0.0152 c 0.01378,-0.0138 0.02343,-0.0234 0.03032,-0.0289 0.01791,-0.0179 0.02894,-0.0289 0.03307,-0.0344 0.0055,-0.006 0.01516,-0.0165 0.02894,-0.0331 0.0069,-0.007 0.01516,-0.0165 0.02618,-0.0289" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path175" d="m -65.697775,121.46008 0.01653,0.04 0.03445,0.0234 0.03445,0.0372 0.02894,0.0289 -0.01516,0.0152 -0.03721,0.0331 c -0.0028,0.003 -0.0124,0.0138 -0.02894,0.0303 -0.0041,0.003 -0.0083,0.008 -0.01516,0.0152 l 0.0041,0.0469 0.0069,0.1378 c 0.01102,0.2012 0.124023,0.43546 0.234266,0.48507 0.0248,0.0124 0.03307,0.0193 0.03307,0.0303 l -0.0041,0.007 -0.02618,0.011 -0.03307,-0.003 -0.07442,-0.008 c -0.01516,-0.001 -0.03583,-0.004 -0.06201,-0.011 l -0.03445,-0.007 -0.03996,0.26734 h -0.04823 l -0.03721,-0.26735 -0.03721,0.007 -0.06339,0.011 -0.07028,0.008 -0.03307,0.003 -0.0041,0.001 c -0.01653,0 -0.02618,-0.007 -0.02618,-0.0179 0,-0.011 0.0083,-0.0193 0.03032,-0.0317 0.03583,-0.0193 0.08682,-0.0703 0.114377,-0.11714 0.06615,-0.11024 0.09646,-0.1819 0.09646,-0.22324 0,-0.0799 0.01102,-0.14469 0.02205,-0.14469 l 0.0083,-0.13781 0.0041,-0.0469 -0.0124,-0.0152 -0.03307,-0.0303 -0.03307,-0.0331 -0.01929,-0.0152 0.03032,-0.0289 0.03307,-0.0372 0.03032,-0.0303 0.02618,-0.0331" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path177" d="m -66.355099,122.68378 0.02618,0.0331 0.03032,0.0303 0.03307,0.0372 0.0248,0.0345 -0.01378,0.01 -0.03307,0.0331 -0.03307,0.0289 -0.01102,0.0152 0.0028,0.0482 0.0083,0.1378 c 0.01102,0.20257 0.115755,0.42168 0.232888,0.48507 0.02205,0.0124 0.03169,0.022 0.03169,0.0331 l -0.0014,0.004 -0.03032,0.007 h -0.03307 c -0.03032,0 -0.08268,-0.007 -0.170877,-0.0248 l -0.03721,0.26321 h -0.05098 l -0.03721,-0.26321 c -0.07855,0.0179 -0.137804,0.0262 -0.186035,0.0262 -0.03858,0 -0.04685,-0.004 -0.04685,-0.0179 0,-0.01 0.0083,-0.0165 0.03169,-0.0276 0.03032,-0.0124 0.08544,-0.0703 0.115756,-0.11851 0.06063,-0.0992 0.09646,-0.18053 0.09646,-0.22187 0,-0.0799 0.0096,-0.14469 0.02205,-0.14469 l 0.0069,-0.13781 0.0041,-0.0482 c -0.0069,-0.006 -0.01103,-0.011 -0.01516,-0.0152 -0.01654,-0.0151 -0.02618,-0.0262 -0.02894,-0.0289 l -0.03721,-0.0331 -0.01516,-0.0152 0.03032,-0.0289 0.03307,-0.0372 0.02894,-0.0303 0.02205,-0.0331" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path179" d="m -65.023914,122.68378 0.02205,0.0331 0.03032,0.0303 0.02756,0.0413 0.03583,0.0248 -0.01516,0.0152 -0.03721,0.0331 c -0.0028,0.003 -0.01378,0.0138 -0.03032,0.0289 -0.0028,0.004 -0.0069,0.01 -0.01378,0.0152 l 0.0028,0.0482 0.0083,0.1378 c 0.0069,0.12127 0.0565,0.27698 0.118511,0.36656 0.03996,0.0592 0.08544,0.10611 0.114377,0.11851 0.0248,0.011 0.03445,0.0193 0.03445,0.0303 0,0.0124 -0.0096,0.0152 -0.04961,0.0152 -0.04823,0 -0.106109,-0.008 -0.184657,-0.0262 l -0.03721,0.26321 h -0.05236 l -0.03721,-0.26321 c -0.08682,0.0179 -0.140559,0.0248 -0.169498,0.0248 h -0.03445 c -0.02067,0 -0.03032,-0.003 -0.03032,-0.0124 0,-0.01 0.0096,-0.0207 0.03032,-0.0317 0.03721,-0.0179 0.08682,-0.0703 0.115755,-0.11851 0.06477,-0.10887 0.09646,-0.18053 0.09646,-0.22187 0,-0.0799 0.0096,-0.14469 0.02205,-0.14469 l 0.0069,-0.13781 0.0041,-0.0482 -0.01102,-0.0152 -0.03307,-0.0289 -0.03307,-0.0331 -0.01929,-0.0152 0.03032,-0.0289 0.03307,-0.0372 0.02894,-0.0303 0.02618,-0.0331" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path181" d="m -65.697775,119.05127 0.02205,0.0331 0.02894,0.0289 0.03445,0.0372 0.02894,0.0303 -0.01516,0.0138 -0.03721,0.0344 c -0.0028,0.003 -0.0124,0.0124 -0.02894,0.0289 -0.0041,0.004 -0.0083,0.008 -0.01516,0.0152 l 0.0041,0.0482 0.0069,0.13642 c 0.01102,0.2012 0.12678,0.44098 0.234266,0.48645 0.02343,0.01 0.03169,0.0179 0.03169,0.0276 0,0.0138 -0.0083,0.0165 -0.04685,0.0165 -0.04823,0 -0.107487,-0.008 -0.186035,-0.0248 l -0.03996,0.26597 h -0.04823 l -0.03721,-0.26597 c -0.08819,0.0165 -0.140559,0.0248 -0.170876,0.0248 h -0.03307 c -0.02205,0 -0.03169,-0.004 -0.03169,-0.0124 0,-0.011 0.0096,-0.0207 0.03169,-0.0317 0.03583,-0.0193 0.08682,-0.0703 0.114377,-0.11851 0.06615,-0.10887 0.09646,-0.18053 0.09646,-0.22325 0,-0.0799 0.01102,-0.14469 0.02205,-0.14469 l 0.0083,-0.13643 0.0041,-0.0482 -0.0124,-0.0152 -0.03307,-0.0289 -0.03307,-0.0345 -0.01929,-0.0138 0.03032,-0.0303 0.03307,-0.0372 0.03032,-0.0289 0.02618,-0.0331" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path183" d="m -66.366123,112.2851 c 0.0124,0.0124 0.02067,0.0234 0.02618,0.0289 0.01378,0.0165 0.02343,0.0276 0.03032,0.0344 0.0041,0.004 0.01516,0.0152 0.03307,0.0331 0.0069,0.007 0.01654,0.0165 0.02894,0.0289 l -0.01378,0.0152 -0.03721,0.0331 c -0.0041,0.003 -0.01378,0.0138 -0.03307,0.0331 -0.0028,0.003 -0.0069,0.007 -0.01103,0.0124 l 0.0028,0.051 0.0083,0.13367 c 0.0069,0.12954 0.06477,0.30868 0.118511,0.37069 l 0.07304,0.0854 c 0.0041,0.004 0.01791,0.0152 0.04134,0.0331 l 0.03169,0.0248 -0.03169,0.0193 -0.03307,-0.003 -0.07028,-0.008 -0.06339,-0.011 -0.03721,-0.007 -0.03996,0.25494 -0.04548,0.0124 -0.03721,-0.26734 -0.03583,0.007 -0.06339,0.011 -0.07166,0.008 -0.03858,0.004 c -0.01378,0 -0.02343,-0.006 -0.02343,-0.0124 0,-0.007 0.0055,-0.0152 0.01516,-0.0234 0.0028,-0.003 0.02205,-0.0165 0.05512,-0.0427 0.04823,-0.0358 0.06201,-0.0565 0.129536,-0.18879 0.02756,-0.0524 0.04134,-0.0937 0.04134,-0.12265 0,-0.0799 0.0096,-0.14469 0.02205,-0.14469 l 0.0069,-0.13367 0.0041,-0.051 -0.01516,-0.0124 -0.02894,-0.0331 -0.03721,-0.0331 -0.01516,-0.0152 c 0.01378,-0.0124 0.02343,-0.022 0.02894,-0.0289 0.05236,-0.051 0.0565,-0.0565 0.08544,-0.0965" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path185" d="m -65.023914,112.2851 c 0.02894,0.04 0.03445,0.0455 0.08544,0.0965 0.0069,0.007 0.01653,0.0165 0.03032,0.0289 l -0.01516,0.0152 -0.03721,0.0331 -0.03032,0.0331 -0.01378,0.0124 0.0028,0.051 0.0083,0.13367 c 0.01103,0.19568 0.121268,0.42995 0.232889,0.4892 0.01929,0.011 0.03169,0.0193 0.03169,0.0248 0,0.01 -0.0069,0.0179 -0.01516,0.0179 l -0.04548,-0.001 -0.07441,-0.008 c -0.01653,-0.001 -0.03721,-0.004 -0.06339,-0.011 l -0.03307,-0.007 -0.03721,0.26734 h -0.05237 l -0.03721,-0.26734 -0.03996,-0.004 -0.05926,0.0221 -0.07028,0.008 -0.03445,0.003 -0.0041,10e-4 c -0.01378,0 -0.0248,-0.006 -0.0248,-0.0124 0,-0.007 0.0055,-0.0152 0.01654,-0.0234 l 0.05374,-0.0427 c 0.04961,-0.0386 0.06615,-0.062 0.129536,-0.18879 0.02756,-0.0524 0.04134,-0.0951 0.04134,-0.12265 0,-0.0799 0.0096,-0.14469 0.02205,-0.14469 l 0.0069,-0.13367 0.0041,-0.051 -0.01102,-0.0124 -0.03307,-0.0331 c -0.01653,-0.0165 -0.02756,-0.0276 -0.03307,-0.0331 -0.0041,-0.003 -0.0096,-0.008 -0.01929,-0.0152 0.01378,-0.0124 0.02343,-0.022 0.03032,-0.0289 0.01791,-0.0179 0.02894,-0.0289 0.03307,-0.0331 0.0055,-0.007 0.01516,-0.0179 0.02894,-0.0344 0.0069,-0.006 0.01516,-0.0165 0.02618,-0.0289" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path187" d="m -65.706043,113.44541 0.02618,0.0289 0.03032,0.0344 c 0.01791,0.0193 0.02894,0.0317 0.03307,0.0358 0.0069,0.007 0.01653,0.0179 0.02894,0.0303 l -0.01791,0.0152 -0.03307,0.0331 -0.03307,0.0289 -0.01102,0.0152 0.0028,0.0482 0.0041,0.12678 c 0.01102,0.20257 0.119889,0.4327 0.237023,0.49609 0.02205,0.0124 0.03169,0.022 0.03169,0.0331 l -0.0028,0.004 -0.02894,0.008 h -0.03307 c -0.0441,0 -0.121267,-0.0138 -0.170876,-0.0303 l -0.03721,0.26734 h -0.05099 l -0.03721,-0.26734 c -0.04961,0.0179 -0.124024,0.0303 -0.186035,0.0303 -0.03996,0 -0.04823,-0.003 -0.04823,-0.0152 0,-0.011 0.0083,-0.0193 0.03307,-0.0303 0.03032,-0.0124 0.08406,-0.0675 0.115756,-0.11851 0.05788,-0.0937 0.09233,-0.17501 0.09233,-0.22187 0,-0.0799 0.01103,-0.14469 0.02618,-0.14469 l 0.0069,-0.1378 0.0041,-0.0482 c -0.0069,-0.006 -0.0124,-0.011 -0.01516,-0.0152 -0.01654,-0.0165 -0.02618,-0.0262 -0.02894,-0.0289 l -0.03721,-0.0331 -0.01516,-0.0152 0.02894,-0.0303 0.03445,-0.0358 c 0.01654,-0.0193 0.02618,-0.0303 0.02894,-0.0344 0.0055,-0.006 0.0124,-0.0152 0.02205,-0.0289" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path189" d="m -66.368879,114.60159 0.0248,0.0303 0.02618,0.0331 c 0.0069,0.008 0.01791,0.0193 0.03307,0.0331 l 0.03445,0.0303 c -0.01102,0.008 -0.01654,0.0124 -0.01929,0.0138 l -0.03307,0.0345 -0.0441,0.0441 v 0.0344 c 0,0.19568 0.05788,0.44097 0.122646,0.50987 l 0.0813,0.0965 c 0,10e-4 0.01378,0.0124 0.04134,0.0345 l 0.02894,0.0234 -0.02894,0.0207 -0.03445,-0.004 -0.07028,-0.007 -0.06339,-0.011 -0.03721,-0.008 -0.03721,0.26734 h -0.05099 l -0.03721,-0.26734 -0.03721,0.008 -0.06339,0.011 -0.07028,0.007 -0.03307,0.004 h -0.0055 c -0.01378,0 -0.0248,-0.006 -0.0248,-0.0124 0,-0.006 0.0069,-0.0152 0.01654,-0.0234 l 0.05512,-0.0427 c 0.122646,-0.0978 0.20395,-0.33624 0.20395,-0.60633 v -0.0345 l -0.0124,-0.011 -0.03307,-0.0331 c -0.01653,-0.0179 -0.02756,-0.0289 -0.03307,-0.0345 -0.0028,-0.001 -0.0096,-0.007 -0.01929,-0.0138 0.01516,-0.0138 0.02618,-0.0234 0.03445,-0.0303 0.01516,-0.0138 0.02618,-0.0248 0.03307,-0.0331 l 0.02618,-0.0331 0.02618,-0.0303" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path191" d="m -65.030804,114.60159 c 0.01102,0.0138 0.01929,0.0234 0.02618,0.0303 0.01378,0.0165 0.02343,0.0262 0.02894,0.0331 0.0055,0.004 0.01654,0.0165 0.03307,0.0331 0.0069,0.007 0.01654,0.0165 0.03032,0.0303 -0.01102,0.008 -0.01654,0.0124 -0.01791,0.0138 l -0.07855,0.0785 0.0041,0.0524 0.0069,0.13643 c 0.01103,0.20532 0.09095,0.36931 0.234267,0.48644 l 0.02894,0.0234 -0.02894,0.0207 -0.03445,-0.004 -0.07028,-0.007 -0.06201,-0.011 -0.03721,-0.008 -0.03721,0.26734 h -0.05237 l -0.04134,-0.27836 c -0.06615,0.0152 -0.0689,0.0276 -0.09233,0.0303 l -0.07441,0.007 -0.03307,0.004 h -0.0041 c -0.0124,0 -0.02205,-0.006 -0.02205,-0.0124 0,-0.007 0.0055,-0.0152 0.01516,-0.0234 l 0.0565,-0.0427 c 0.04685,-0.0372 0.06201,-0.0565 0.129536,-0.18879 0.02618,-0.051 0.03996,-0.0937 0.03996,-0.12265 0,-0.0772 0.01102,-0.14056 0.02205,-0.14056 l 0.0083,-0.13642 0.0041,-0.0524 -0.01516,-0.011 -0.03032,-0.0331 -0.03721,-0.0344 -0.01378,-0.0138 c 0.0124,-0.0138 0.02205,-0.0234 0.02894,-0.0303 0.05099,-0.051 0.0565,-0.0565 0.08544,-0.0965" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path193" d="m -67.807551,114.00489 0.01516,0.0551 c 0.0124,0.051 0.02343,0.091 0.02894,0.11989 0.04685,0.21084 0.08682,0.26733 0.188791,0.26733 0.05926,0 0.107487,-0.0331 0.122646,-0.0827 l 0.02205,-0.0744 c 0.0055,-0.0165 0.01792,-0.0276 0.03583,-0.0276 0.03996,0 0.05926,0.0427 0.06063,0.13505 0.0014,0.0276 0.0096,0.0882 0.02618,0.1819 0.0096,0.0565 0.01516,0.11024 0.01516,0.1626 0,0.0469 -0.0041,0.0661 -0.02205,0.11576 0.0124,0.073 0.02205,0.17088 0.02205,0.22738 0,0.091 -0.01654,0.17639 -0.04547,0.22048 0.01653,0.062 0.01929,0.0868 0.01929,0.14056 0,0.0386 -0.0041,0.0813 -0.01102,0.12265 -0.01654,0.0896 -0.01929,0.11162 -0.01929,0.12816 0,0.0179 0.0028,0.0344 0.0083,0.0496 0.0069,0.0221 0.01102,0.0372 0.01102,0.0455 0,0.01 -0.0055,0.0179 -0.01102,0.0179 l -0.07442,-0.0289 -0.08131,-0.0455 c -0.02618,-0.0138 -0.04547,-0.0276 -0.08544,-0.0661 -0.07166,0.0648 -0.09371,0.0744 -0.282498,0.12541 -0.03721,0.011 -0.06477,0.022 -0.0813,0.0344 -0.02343,0.0165 -0.03996,0.0262 -0.04961,0.0262 -0.03169,0 -0.04685,-0.0524 -0.04685,-0.15709 0,-0.0799 0.0083,-0.15159 0.02343,-0.20671 -0.0565,-0.022 -0.103353,-0.0331 -0.13367,-0.0331 -0.0055,0 -0.02343,0.003 -0.0565,0.007 l -0.01378,0.001 c -0.01102,0 -0.01929,-0.0165 -0.01929,-0.0358 0,-0.0138 0.0096,-0.0496 0.02205,-0.0799 l 0.03721,-0.0896 c 0.01378,-0.0317 0.0441,-0.0689 0.08957,-0.10748 0.03583,-0.0317 0.07028,-0.051 0.09646,-0.0551 l 0.132291,-0.0262 c 0.07993,-0.0152 0.12678,-0.0579 0.12678,-0.113 0,-0.0524 -0.03445,-0.0896 -0.114377,-0.11713 l -0.159853,-0.0551 c -0.04134,-0.0152 -0.08957,-0.0386 -0.144694,-0.0703 -0.08819,-0.0524 -0.103353,-0.0593 -0.124023,-0.0593 -0.03169,0 -0.05099,0.0234 -0.05099,0.0648 0,0.0662 0.04272,0.113 0.104731,0.113 0.0124,0 0.0248,-0.003 0.03721,-0.008 0.01791,-0.007 0.03032,-0.011 0.03721,-0.011 0.01791,0 0.02618,0.01 0.02618,0.0289 l -0.0014,0.0152 -0.0069,0.0634 c -0.0055,0.0537 -0.04134,0.11989 -0.118512,0.22325 l -0.03307,0.0441 c -0.03032,0.11851 -0.104731,0.22738 -0.199815,0.29215 -0.0248,0.0165 -0.03858,0.0276 -0.04134,0.0303 -0.0028,0.004 -0.01378,0.0207 -0.03032,0.0524 -0.0069,0.0138 -0.03169,0.0441 -0.07304,0.0882 -0.03169,0.0345 -0.06339,0.0634 -0.09371,0.0854 -0.04134,0.0317 -0.06615,0.0537 -0.07304,0.0675 l -0.03721,0.062 c -0.0069,0.0124 -0.01791,0.0193 -0.03032,0.0193 -0.03307,0 -0.06339,-0.0345 -0.08131,-0.0937 -0.01378,-0.0427 -0.02618,-0.0551 -0.05374,-0.0551 -0.01516,0 -0.03583,0.004 -0.06477,0.011 l -0.05237,0.008 h -0.133669 c -0.06615,0 -0.159853,0.0165 -0.20395,0.0358 -0.01653,0.008 -0.02894,0.0124 -0.03721,0.0124 -0.0096,0 -0.01516,-0.004 -0.0248,-0.0234 -0.0069,-0.011 -0.0083,-0.0179 -0.0083,-0.0289 0,-0.0675 0.04823,-0.19568 0.111622,-0.29627 0.03996,-0.0648 0.05374,-0.0799 0.100596,-0.11989 -0.01516,-0.062 -0.0565,-0.11025 -0.104731,-0.12541 l -0.06201,-0.0179 c -0.0096,-0.003 -0.01516,-0.01 -0.01516,-0.0193 0,-0.0179 0.03032,-0.0455 0.08544,-0.0744 0.07166,-0.0372 0.144694,-0.0593 0.202572,-0.0593 0.06201,0 0.121267,0.0248 0.190169,0.0786 0.100597,0.0785 0.128158,0.0923 0.176389,0.0923 0.07993,0 0.15434,-0.0717 0.15434,-0.14745 0,-0.051 -0.02618,-0.1061 -0.09784,-0.19706 -0.103353,-0.13366 -0.13367,-0.20257 -0.13367,-0.30179 0,-0.0606 0.01929,-0.1378 0.04134,-0.17225 l 0.03721,-0.0565 c 0.0083,-0.0124 0.0124,-0.0234 0.0124,-0.0358 0,-0.0248 -0.02894,-0.0413 -0.06752,-0.0413 -0.05788,0 -0.170877,0.0413 -0.260449,0.0965 -0.0441,0.0262 -0.07441,0.0593 -0.07441,0.0786 0,0.011 0.0055,0.022 0.01516,0.0289 l 0.04134,0.0262 c 0.0041,0.003 0.0083,0.008 0.0083,0.0152 0,0.006 -0.0069,0.0165 -0.01516,0.0289 l -0.07441,0.0965 c -0.03859,0.0496 -0.09784,0.11162 -0.155719,0.16261 -0.01929,0.0179 -0.03169,0.0289 -0.03721,0.0372 0,0.001 -0.01102,0.0193 -0.03032,0.0551 -0.02618,0.0496 -0.09646,0.12264 -0.162609,0.16674 -0.02756,0.0193 -0.0441,0.0331 -0.05237,0.0413 -0.0055,0.007 -0.01516,0.0234 -0.02894,0.0524 -0.0096,0.0179 -0.02618,0.0441 -0.04823,0.0772 -0.03721,0.0537 -0.06615,0.0923 -0.08957,0.11438 l -0.103357,0.10473 c -0.03307,0.0317 -0.06063,0.0937 -0.103353,0.23013 -0.02756,0.0813 -0.05099,0.12953 -0.06477,0.12953 -0.0055,0 -0.01654,-0.008 -0.02894,-0.022 -0.07304,-0.0841 -0.136425,-0.13367 -0.169498,-0.13367 -0.0083,0 -0.02205,0.006 -0.04134,0.0179 -0.02756,0.0179 -0.06063,0.0303 -0.100596,0.0372 l -0.136426,0.0262 c -0.103353,0.0193 -0.144694,0.0427 -0.20395,0.11162 -0.01378,0.0165 -0.02618,0.0262 -0.03169,0.0262 -0.0124,0 -0.02067,-0.0193 -0.02067,-0.0441 l 0.0041,-0.0345 0.01791,-0.10059 c 0.02067,-0.10611 0.04547,-0.18604 0.07441,-0.23978 l 0.06339,-0.11576 c 0.0124,-0.022 0.01791,-0.0427 0.01791,-0.0606 0,-0.0854 -0.08819,-0.16261 -0.195682,-0.17225 -0.02756,-0.003 -0.03858,-0.01 -0.03858,-0.0248 0,-0.0193 0.03032,-0.0551 0.07166,-0.0868 0.07441,-0.0565 0.170877,-0.0965 0.232889,-0.0965 0.03858,0 0.09646,0.0152 0.16812,0.0441 l 0.0813,0.0331 c 0.03032,0.0138 0.05788,0.0193 0.08268,0.0193 0.08544,0 0.169499,-0.0786 0.272852,-0.25632 0.04685,-0.0799 0.06615,-0.1378 0.06615,-0.19017 0,-0.0937 -0.0441,-0.1502 -0.117133,-0.1502 -0.05512,0 -0.117133,0.0262 -0.159852,0.0703 -0.03858,0.0372 -0.05788,0.0772 -0.05788,0.11437 l 0.0014,0.0413 v 0.01 c 0,0.0344 -0.01102,0.0537 -0.03169,0.0537 -0.03445,0 -0.08544,-0.0496 -0.231511,-0.226 -0.108865,-0.13229 -0.132291,-0.18879 -0.136426,-0.3197 -0.126779,-0.15985 -0.157096,-0.22876 -0.157096,-0.34175 l 0.0055,-0.0772 c -0.08819,-0.10474 -0.112999,-0.16123 -0.112999,-0.2577 0,-0.0344 0.0055,-0.0551 0.02756,-0.0978 -0.0441,-0.0648 -0.05926,-0.0937 -0.07166,-0.14469 l -0.01791,-0.0772 c -0.0124,-0.0537 -0.03307,-0.0992 -0.05925,-0.13781 -0.03445,-0.0482 -0.03721,-0.0537 -0.03721,-0.0703 0,-0.0441 0.02894,-0.0606 0.159852,-0.0923 -0.0055,-0.0358 -0.0083,-0.0634 -0.0083,-0.0827 0,-0.022 0.0028,-0.0427 0.01102,-0.0882 l 0.02618,-0.13781 c 0.01102,-0.0551 0.01653,-0.0951 0.01653,-0.11851 0,-0.0262 -0.0041,-0.0441 -0.02756,-0.11851 -0.0124,-0.0427 -0.02343,-0.0703 -0.03307,-0.0854 -0.0124,-0.0179 -0.02205,-0.0413 -0.02205,-0.0496 0,-0.0138 0.0083,-0.022 0.0248,-0.022 0.03721,0 0.13367,0.0592 0.234267,0.14193 0.213596,0.17639 0.256315,0.24667 0.285254,0.46027 0.0028,0.0165 0.0069,0.0413 0.01102,0.0744 0.101975,0.0758 0.155718,0.16537 0.155718,0.26183 0,0.0772 -0.02756,0.16674 -0.07441,0.2384 l -0.07303,0.11438 c -0.02205,0.0345 -0.03307,0.0772 -0.03307,0.12264 0,0.0703 0.01929,0.13505 0.0689,0.22325 0.05788,0.0992 0.106109,0.14056 0.166742,0.14056 0.09646,0 0.183279,-0.17088 0.183279,-0.36381 v -0.0262 l -0.0014,-0.0662 c 0,-0.0372 0.0028,-0.0758 0.0083,-0.12264 0.0069,-0.0579 0.0096,-0.0937 0.01103,-0.10749 l 0.0041,-0.0882 0.0014,-0.0593 c 0,-0.0207 -0.0124,-0.0413 -0.03858,-0.0703 l -0.0813,-0.0896 c -0.118511,-0.12816 -0.183279,-0.24942 -0.183279,-0.34038 0,-0.11299 0.0813,-0.19705 0.188791,-0.19705 0.02205,0 0.04134,0.004 0.07855,0.0138 v -0.0248 c 0,-0.16261 0.03445,-0.28388 0.07855,-0.28388 l 0.01791,0.006 0.06753,0.0593 0.0813,0.0524 0.02205,0.022 c 0,-0.0468 0.0028,-0.051 0.04823,-0.10335 0.01102,-0.0138 0.02894,-0.0372 0.05236,-0.0717 0.01929,-0.0262 0.03032,-0.0455 0.03721,-0.0551 0.0055,-0.01 0.01102,-0.0207 0.01791,-0.0331 0.0096,-0.0193 0.01929,-0.0276 0.03032,-0.0276 0.01102,0 0.01929,0.0138 0.03307,0.0537 0.0083,0.0248 0.01378,0.0317 0.07717,0.0882 0.02205,0.0207 0.03721,0.0372 0.04547,0.0482 0.0055,0.01 0.01516,0.0358 0.02894,0.0744 0.0028,0.007 0.0055,0.0165 0.01102,0.0303 0.02756,-0.0358 0.04134,-0.0482 0.07441,-0.0675 l 0.05512,-0.0331 c 0.02067,-0.0124 0.03583,-0.0193 0.04134,-0.0193 0.0055,0 0.0124,0.008 0.01792,0.0221 0.0069,0.0138 0.01653,0.0317 0.03032,0.0565 0.03996,0.0689 0.05237,0.10197 0.05237,0.13367 v 0.0813 c 0.121267,0.0386 0.166742,0.10198 0.166742,0.23151 0,0.0951 -0.04961,0.20395 -0.144694,0.31695 -0.06339,0.0758 -0.07166,0.0909 -0.07166,0.1447 0,0.27423 0.191548,0.4327 0.527789,0.43684 l 0.248047,0.004 c 0.159853,0.003 0.254937,0.0179 0.403765,0.0662 0.176389,0.0579 0.227376,0.0716 0.278364,0.0716 0.01791,0 0.03445,-0.006 0.04823,-0.0152 0.01378,-0.01 0.02205,-0.022 0.02205,-0.0331 0,-0.0524 -0.09095,-0.0937 -0.389985,-0.17777 -0.610471,-0.17363 -0.87092,-0.4203 -0.87092,-0.82544 0,-0.31281 0.260449,-0.55535 0.596691,-0.55535 0.108864,0 0.275607,0.0289 0.37207,0.0634 l 0.151584,0.0565 c 0.02756,0.01 0.05374,0.0152 0.07855,0.0152 0.05237,0 0.07855,-0.0427 0.07993,-0.13092 0.0014,-0.0468 0.0124,-0.062 0.04272,-0.062 0.04272,0 0.108866,0.0538 0.169499,0.13643 0.06063,0.0854 0.100597,0.18052 0.100597,0.24391 0,0.0841 -0.03996,0.14332 -0.130914,0.19431 -0.08268,0.12677 -0.184657,0.18465 -0.322461,0.18465 -0.107487,0 -0.259071,-0.0606 -0.511252,-0.20395 -0.08819,-0.0496 -0.132291,-0.0661 -0.179145,-0.0661 -0.06477,0 -0.107487,0.0386 -0.107487,0.0965 0,0.0524 0.04134,0.0882 0.148828,0.1254 0.161231,0.0565 0.199816,0.0785 0.263206,0.14469 0.188791,0.0331 0.271473,0.0661 0.389985,0.15572 0.325217,0.10336 0.52641,0.32522 0.52641,0.58016 0,0.24667 -0.166742,0.42443 -0.399631,0.42443 -0.05512,0 -0.08957,-0.004 -0.175011,-0.022" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path195" d="m -60.889799,114.00489 0.01516,0.0551 c 0.0124,0.051 0.02205,0.091 0.02894,0.11989 0.04685,0.21084 0.08682,0.26733 0.188791,0.26733 0.05926,0 0.107487,-0.0331 0.122645,-0.0827 l 0.02205,-0.0744 c 0.0055,-0.0165 0.01791,-0.0262 0.03583,-0.0262 0.03996,0 0.06201,0.0441 0.06477,0.13367 0.0014,0.0345 0.0083,0.0951 0.02205,0.1819 0.0096,0.062 0.01516,0.11989 0.01516,0.17225 0,0.0372 -0.0055,0.0593 -0.02205,0.10611 l 0.0069,0.0441 c 0.0124,0.073 0.01516,0.10197 0.01516,0.13642 0,0.15848 -0.0069,0.20533 -0.0441,0.26734 0.01516,0.0606 0.01929,0.0896 0.01929,0.13367 0,0.0276 -0.0041,0.0675 -0.0124,0.12954 l -0.01516,0.11162 0.0041,0.0661 c 0.0096,0.0248 0.01378,0.04 0.01378,0.0455 0,0.01 -0.0055,0.0179 -0.01378,0.0179 l -0.07442,-0.0289 -0.0813,-0.0455 c -0.02618,-0.0138 -0.04547,-0.0276 -0.08544,-0.0661 -0.07166,0.0634 -0.0813,0.0689 -0.166743,0.0923 -0.122645,0.0345 -0.168121,0.0496 -0.192925,0.0675 -0.02343,0.0165 -0.04134,0.0262 -0.05099,0.0262 -0.02894,0 -0.04961,-0.0565 -0.04961,-0.1378 0,-0.11852 0.0069,-0.18053 0.02618,-0.226 -0.07166,-0.0248 -0.108865,-0.0331 -0.135047,-0.0331 -0.0096,0 -0.01516,0 -0.05374,0.007 l -0.01654,10e-4 c -0.01102,0 -0.01791,-0.0138 -0.01791,-0.0358 0,-0.0358 0.02618,-0.10886 0.06063,-0.1695 0.04685,-0.0827 0.122645,-0.15158 0.181901,-0.16261 l 0.13367,-0.0262 c 0.07855,-0.0152 0.125401,-0.0579 0.125401,-0.113 0,-0.0524 -0.03445,-0.0882 -0.114377,-0.11713 l -0.155718,-0.0551 c -0.05237,-0.0193 -0.101975,-0.0427 -0.148829,-0.0703 -0.03996,-0.0248 -0.06614,-0.04 -0.0813,-0.0482 -0.01378,-0.008 -0.02756,-0.011 -0.03996,-0.011 -0.03445,0 -0.05374,0.0234 -0.05374,0.062 0,0.0634 0.04823,0.11576 0.107486,0.11576 0.01378,0 0.02618,-0.003 0.03721,-0.008 0.01791,-0.007 0.02894,-0.011 0.03445,-0.011 0.01653,0 0.02894,0.0165 0.02894,0.04 0,0.0661 -0.04134,0.17914 -0.08544,0.23426 l -0.0441,0.0565 -0.03307,0.0441 c -0.0124,0.0951 -0.106108,0.23151 -0.199815,0.29215 -0.02343,0.0151 -0.03721,0.0248 -0.04134,0.0303 -0.0028,0.004 -0.0124,0.0207 -0.03032,0.0524 -0.0069,0.0138 -0.03169,0.0441 -0.07304,0.0882 -0.03169,0.0345 -0.06339,0.0634 -0.09371,0.0854 -0.04134,0.0317 -0.06614,0.0537 -0.07441,0.0675 l -0.03583,0.062 c -0.0083,0.0138 -0.01791,0.0193 -0.02894,0.0193 -0.03307,0 -0.06339,-0.0345 -0.08268,-0.0937 -0.01378,-0.0427 -0.0248,-0.0551 -0.05374,-0.0551 -0.01378,0 -0.03583,0.004 -0.06477,0.011 l -0.05237,0.008 h -0.129535 c -0.07028,0 -0.163987,0.0165 -0.208084,0.0358 -0.01653,0.008 -0.02894,0.0124 -0.03721,0.0124 -0.01929,0 -0.02894,-0.0193 -0.02894,-0.0565 0,-0.11713 0.08957,-0.29628 0.208084,-0.41203 -0.01791,-0.0675 -0.05374,-0.113 -0.100597,-0.12541 -0.04134,-0.011 -0.06477,-0.0179 -0.06615,-0.0179 -0.0083,-0.004 -0.0124,-0.011 -0.0124,-0.0179 0,-0.0234 0.02756,-0.0469 0.08544,-0.0758 0.106109,-0.0496 0.136426,-0.0593 0.195682,-0.0593 0.06752,0 0.124023,0.0234 0.194303,0.0786 0.100597,0.0785 0.128158,0.0923 0.176389,0.0923 0.07855,0 0.15434,-0.0717 0.15434,-0.14746 0,-0.0524 -0.02756,-0.10886 -0.09784,-0.19705 -0.09784,-0.12678 -0.13367,-0.20809 -0.13367,-0.31558 0,-0.0716 0.01516,-0.11024 0.07855,-0.21497 0.0096,-0.0165 0.01516,-0.0303 0.01516,-0.0386 0,-0.0207 -0.03307,-0.0386 -0.07028,-0.0386 -0.03996,0 -0.08957,0.0138 -0.155718,0.0441 -0.111622,0.051 -0.179145,0.0992 -0.179145,0.12816 0,0.011 0.0083,0.0234 0.01929,0.0317 l 0.03721,0.0262 c 0.0041,0.003 0.0069,0.008 0.0069,0.0152 0,0.006 -0.0055,0.0193 -0.01516,0.0289 -0.0069,0.008 -0.03169,0.04 -0.07304,0.0965 -0.05237,0.0689 -0.101975,0.11989 -0.155719,0.16261 -0.02067,0.0152 -0.03169,0.0276 -0.03721,0.0372 l -0.03032,0.0551 c -0.0248,0.0468 -0.09784,0.12402 -0.158475,0.16674 -0.02894,0.0207 -0.04547,0.0345 -0.05236,0.0413 -0.0083,0.008 -0.01929,0.0262 -0.03307,0.0524 -0.03858,0.0675 -0.09784,0.15158 -0.137804,0.19155 l -0.100597,0.10473 c -0.02756,0.0303 -0.06752,0.11575 -0.107487,0.23013 -0.03032,0.0896 -0.04961,0.12953 -0.06339,0.12953 -0.0055,0 -0.01653,-0.008 -0.02894,-0.022 -0.07166,-0.0827 -0.136425,-0.13367 -0.16812,-0.13367 -0.0083,0 -0.02205,0.007 -0.04272,0.0179 -0.02894,0.0179 -0.06201,0.0303 -0.100597,0.0372 l -0.132292,0.0262 c -0.111621,0.0221 -0.157096,0.0455 -0.208084,0.11162 -0.0124,0.0165 -0.02343,0.0262 -0.03032,0.0262 -0.0124,0 -0.02205,-0.0193 -0.02205,-0.0455 l 0.0041,-0.0331 c 0,-0.003 0.0069,-0.0372 0.01791,-0.1006 0.01929,-0.10473 0.04685,-0.19293 0.07441,-0.23978 l 0.06615,-0.11575 c 0.0124,-0.0207 0.01929,-0.0414 0.01929,-0.0593 0,-0.0854 -0.07993,-0.15572 -0.199816,-0.17363 -0.0248,-0.004 -0.03721,-0.0138 -0.03721,-0.0276 0,-0.0165 0.02894,-0.0496 0.07441,-0.0841 0.07855,-0.0593 0.165365,-0.0965 0.225998,-0.0965 0.04134,0 0.09646,0.0152 0.169499,0.0441 l 0.08268,0.0331 c 0.03032,0.0138 0.05788,0.0193 0.0813,0.0193 0.08682,0 0.170877,-0.0786 0.274229,-0.25632 0.04685,-0.0799 0.06615,-0.1378 0.06615,-0.19017 0,-0.0937 -0.04272,-0.1502 -0.115755,-0.1502 -0.05788,0 -0.112999,0.0248 -0.158474,0.0703 -0.03996,0.0413 -0.06063,0.0813 -0.06063,0.11851 l 0.0014,0.0372 0.0014,0.0193 c 0,0.0303 -0.0096,0.0441 -0.03169,0.0441 -0.02894,0 -0.06063,-0.0276 -0.125401,-0.10335 -0.02618,-0.0331 -0.06063,-0.073 -0.103353,-0.12264 -0.112999,-0.1323 -0.136426,-0.18466 -0.14056,-0.31971 -0.126779,-0.15985 -0.157096,-0.24942 -0.157096,-0.34175 l 0.0041,-0.0772 c -0.08957,-0.10749 -0.107484,-0.15021 -0.107484,-0.25632 0,-0.0482 0.0028,-0.0606 0.02205,-0.0992 -0.0441,-0.0648 -0.05788,-0.0937 -0.07028,-0.14469 l -0.01791,-0.0772 c -0.0124,-0.0537 -0.03307,-0.0992 -0.05926,-0.13781 -0.03307,-0.0482 -0.03721,-0.0551 -0.03721,-0.0689 0,-0.0386 0.03721,-0.0634 0.129536,-0.0868 l 0.03032,-0.007 c -0.0055,-0.0358 -0.0083,-0.0634 -0.0083,-0.0827 0,-0.022 0.0028,-0.0427 0.01103,-0.0882 l 0.02618,-0.1378 c 0.0096,-0.0538 0.01516,-0.0937 0.01516,-0.12127 0,-0.0317 -0.0041,-0.0579 -0.02205,-0.11576 -0.0124,-0.0372 -0.0248,-0.0661 -0.03721,-0.0854 -0.01378,-0.0207 -0.02205,-0.0372 -0.02205,-0.0482 0,-0.0124 0.0124,-0.0234 0.02894,-0.0234 0.0096,0 0.0248,0.006 0.03721,0.0124 0.125401,0.0689 0.261827,0.17639 0.359668,0.28525 0.08406,0.0937 0.110243,0.17088 0.129536,0.37896 0.114376,0.0841 0.157096,0.16123 0.157096,0.28112 0,0.0717 -0.02343,0.14056 -0.07579,0.21911 -0.0441,0.0689 -0.0689,0.10749 -0.07304,0.11438 -0.02205,0.0372 -0.03445,0.0813 -0.03445,0.12678 0,0.0661 0.02067,0.12953 0.07166,0.21911 0.05512,0.0978 0.104731,0.14056 0.163987,0.14056 0.09646,0 0.184657,-0.16812 0.184657,-0.35278 v -0.13643 l 0.0096,-0.0896 0.0083,-0.10749 0.0069,-0.0882 0.0028,-0.0496 c 0,-0.0372 -0.0069,-0.0482 -0.121267,-0.1695 -0.125402,-0.13505 -0.184657,-0.24942 -0.184657,-0.35416 0,-0.0992 0.08544,-0.18327 0.188791,-0.18327 0.02067,0 0.03996,0.004 0.07717,0.0138 v -0.0441 l 0.0041,-0.0772 0.02205,-0.0965 c 0.01791,-0.0772 0.02618,-0.091 0.05237,-0.091 l 0.01791,0.006 0.06752,0.0593 0.0813,0.0524 0.02205,0.022 c 0.0055,-0.0468 0.0096,-0.0551 0.04823,-0.10335 0.01929,-0.0248 0.03721,-0.0482 0.05237,-0.0717 l 0.03721,-0.0551 0.02205,-0.0331 c 0.01378,-0.022 0.02067,-0.0289 0.03032,-0.0289 0.0096,0 0.01653,0.0138 0.02894,0.0551 0.0041,0.0165 0.01653,0.0331 0.03307,0.0482 l 0.04823,0.04 c 0.03859,0.0331 0.06477,0.0827 0.08131,0.15296 0.02894,-0.0372 0.0441,-0.051 0.07441,-0.0675 l 0.05926,-0.0331 c 0.02205,-0.0124 0.03445,-0.0193 0.03859,-0.0193 0.0041,0 0.01102,0.008 0.01653,0.0221 0.0083,0.0207 0.01929,0.0386 0.03032,0.0565 0.04823,0.0772 0.05237,0.0868 0.05237,0.13918 l -0.0014,0.0317 v 0.0441 c 0.121267,0.0331 0.16812,0.0978 0.16812,0.23014 0,0.10059 -0.04548,0.20395 -0.141938,0.31832 -0.06339,0.0758 -0.07441,0.1006 -0.07441,0.1571 0,0.26183 0.198438,0.4203 0.530545,0.42443 l 0.245291,0.004 c 0.159852,0.003 0.256315,0.0193 0.403765,0.0662 0.172255,0.0565 0.227376,0.0716 0.279742,0.0716 0.03721,0 0.0689,-0.0207 0.0689,-0.0468 0,-0.0537 -0.08957,-0.0951 -0.388607,-0.17915 -0.611849,-0.17363 -0.872298,-0.4203 -0.872298,-0.82406 0,-0.31419 0.261827,-0.55535 0.599446,-0.55535 0.107487,0 0.27423,0.0276 0.367937,0.062 l 0.152962,0.0565 c 0.02756,0.01 0.05374,0.0152 0.07855,0.0152 0.05236,0 0.07304,-0.0317 0.07993,-0.13092 0.0041,-0.0427 0.01791,-0.062 0.04547,-0.062 0.03859,0 0.114377,0.0606 0.169499,0.13643 0.0565,0.0785 0.09646,0.1819 0.09646,0.24942 0,0.0785 -0.04134,0.13919 -0.129536,0.1888 -0.08268,0.12677 -0.184657,0.18465 -0.322461,0.18465 -0.106109,0 -0.285254,-0.0717 -0.511252,-0.20395 -0.08957,-0.051 -0.128157,-0.0661 -0.177767,-0.0661 -0.06615,0 -0.110243,0.0372 -0.110243,0.0965 0,0.0537 0.03996,0.0868 0.150206,0.1254 0.176389,0.0634 0.213596,0.0841 0.263206,0.14469 0.188791,0.0331 0.271473,0.0661 0.389984,0.15572 0.33762,0.10887 0.526411,0.31833 0.526411,0.58567 0,0.24391 -0.165365,0.41892 -0.395497,0.41892 -0.06063,0 -0.09233,-0.004 -0.179145,-0.022" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path197" d="m -67.737271,121.00395 c 0.03307,0.0827 0.0441,0.12265 0.04823,0.17501 l 0.0069,0.15572 c 0.0069,0.15572 0.05788,0.23289 0.155718,0.23289 0.03583,0 0.06615,-0.01 0.08268,-0.0262 l 0.03996,-0.04 0.01653,-0.006 c 0.02618,0 0.03996,0.0179 0.03996,0.0482 l -0.0041,0.0606 c -0.0028,0.0276 0.0014,0.0841 0.01516,0.17088 0.0069,0.0496 0.01103,0.1006 0.01103,0.14883 0,0.0799 -0.0055,0.11024 -0.03445,0.18052 0.02618,0.073 0.04134,0.15572 0.04134,0.22462 0,0.0799 -0.01378,0.13505 -0.0441,0.18052 0.01378,0.0634 0.01791,0.0896 0.01791,0.12541 0,0.0372 -0.0041,0.0841 -0.01516,0.14056 -0.0124,0.0772 -0.01791,0.1378 -0.01378,0.17776 v 0.01 c 0,0.0234 -0.0069,0.0358 -0.02205,0.0358 -0.01378,0 -0.03032,-0.011 -0.04547,-0.0303 -0.02205,-0.0289 -0.03721,-0.04 -0.05374,-0.04 -0.02618,0 -0.03445,0.0138 -0.07166,0.12541 -0.0124,0.0345 -0.04134,0.0799 -0.08957,0.1378 -0.03583,0.0441 -0.05926,0.0799 -0.06615,0.10611 -0.0124,0.0455 -0.01929,0.0717 -0.02205,0.0786 -0.0041,0.01 -0.01378,0.0179 -0.02205,0.0179 l -0.0055,0.001 c -0.06063,0 -0.130913,-0.13092 -0.202571,-0.37896 -0.02067,-0.0703 -0.04685,-0.1006 -0.08406,-0.1006 -0.02618,0 -0.05374,0.0179 -0.06477,0.0413 l -0.02205,0.0524 c -0.0041,0.008 -0.01102,0.0152 -0.01929,0.0152 -0.02894,0 -0.07441,-0.0551 -0.103352,-0.12265 -0.02205,-0.0565 -0.03583,-0.11851 -0.03583,-0.17088 0,-0.11575 0.08544,-0.20257 0.344509,-0.34864 0.111621,-0.0634 0.155719,-0.14332 0.155719,-0.28939 0,-0.11438 -0.03445,-0.18052 -0.13367,-0.25631 -0.07855,-0.0579 -0.124024,-0.0813 -0.165365,-0.0813 -0.03583,0 -0.06201,0.0234 -0.06201,0.0538 0,0.0344 0.01929,0.0565 0.06752,0.073 0.05788,0.0193 0.08268,0.04 0.08268,0.0662 0,0.0234 -0.0248,0.073 -0.06339,0.13367 -0.04272,0.0648 -0.06063,0.0827 -0.119889,0.12264 -0.01654,0.10198 -0.06477,0.16675 -0.177767,0.24116 -0.02205,0.0634 -0.03445,0.0868 -0.07442,0.13643 l -0.07717,0.10059 c -0.0248,0.0317 -0.05099,0.0882 -0.05512,0.11438 -0.0083,0.0565 -0.01378,0.0675 -0.03583,0.0675 -0.02894,0 -0.08957,-0.0524 -0.150206,-0.12953 -0.03583,-0.0469 -0.0441,-0.0675 -0.04823,-0.12265 -0.03859,0.0303 -0.05099,0.0345 -0.125402,0.0441 -0.04547,0.007 -0.07993,0.0152 -0.100597,0.0262 -0.0565,0.0303 -0.07579,0.0386 -0.08544,0.0386 -0.01516,0 -0.02067,-0.008 -0.02205,-0.0344 l -0.0041,-0.0827 c 0,-0.11162 0.0441,-0.24253 0.111621,-0.32935 -0.06477,-0.0565 -0.129536,-0.0909 -0.181902,-0.0965 -0.02205,-0.003 -0.02756,-0.006 -0.02756,-0.0138 0,-0.0138 0.01516,-0.0427 0.03583,-0.0675 0.02756,-0.0358 0.04961,-0.0606 0.06615,-0.0744 0.05237,-0.0455 0.143316,-0.0786 0.214974,-0.0786 0.04823,0 0.118511,0.0179 0.21084,0.0524 0.03307,0.0124 0.06339,0.0193 0.08957,0.0193 0.03996,0 0.06339,-0.0262 0.06339,-0.073 0,-0.0675 -0.03307,-0.17364 -0.107487,-0.34314 -0.05099,-0.11437 -0.07441,-0.19154 -0.07441,-0.24391 0,-0.12953 0.06063,-0.26183 0.136425,-0.30041 -0.03445,-0.0179 -0.05099,-0.022 -0.08268,-0.022 -0.03583,0 -0.06615,0.01 -0.112999,0.0372 -0.05512,0.0317 -0.08544,0.0592 -0.08544,0.0785 0,0.007 0.01102,0.0193 0.03032,0.0317 0.02894,0.0207 0.03307,0.0276 0.03307,0.0551 0,0.091 -0.07579,0.21498 -0.181901,0.29352 -0.02343,0.13092 -0.08268,0.20809 -0.199816,0.26321 -0.01653,0.0717 -0.02618,0.091 -0.0813,0.17088 -0.09784,0.13642 -0.121267,0.17914 -0.137803,0.25631 -0.0096,0.04 -0.01791,0.0565 -0.03032,0.0565 -0.01654,0 -0.04823,-0.0248 -0.08544,-0.0648 -0.03032,-0.0331 -0.04961,-0.0565 -0.05926,-0.0703 -0.01516,-0.0248 -0.02343,-0.0482 -0.03996,-0.11851 -0.02618,0.008 -0.03445,0.01 -0.05237,0.01 l -0.05512,-0.003 h -0.03721 c -0.0813,0 -0.168121,0.0179 -0.21084,0.0455 -0.01653,0.01 -0.02756,0.0138 -0.03307,0.0138 -0.02343,0 -0.04272,-0.0496 -0.04272,-0.11162 0,-0.13367 0.03721,-0.24391 0.124023,-0.36518 -0.03169,-0.0276 -0.04272,-0.0372 -0.07028,-0.0675 -0.0124,-0.0138 -0.02343,-0.022 -0.03032,-0.0262 l -0.04134,-0.022 c -0.01378,-0.007 -0.02205,-0.0165 -0.02205,-0.0248 0,-0.0193 0.05374,-0.0703 0.118511,-0.113 0.07166,-0.0455 0.128158,-0.0662 0.180523,-0.0662 0.06063,0 0.09233,0.0152 0.168121,0.0813 0.05237,0.0455 0.08819,0.0675 0.114377,0.0675 0.01791,0 0.03721,-0.0124 0.05236,-0.0331 0.0124,-0.0179 0.01929,-0.0372 0.01929,-0.0565 0,-0.0703 -0.08406,-0.19017 -0.177767,-0.25218 -0.07028,-0.0455 -0.14745,-0.0703 -0.221865,-0.0703 -0.103353,0 -0.191547,0.051 -0.23151,0.13367 l -0.03996,0.0854 c -0.0096,0.0193 -0.02205,0.0303 -0.03583,0.0303 -0.02343,0 -0.03583,-0.011 -0.119889,-0.10886 l -0.09645,-0.11024 c -0.03032,-0.0345 -0.04961,-0.0675 -0.05926,-0.0965 -0.0083,-0.0276 -0.01516,-0.0441 -0.01929,-0.0482 -0.0028,-0.006 -0.01516,-0.0152 -0.03721,-0.0303 -0.07441,-0.0524 -0.128158,-0.1571 -0.158475,-0.3073 -0.0028,-0.011 -0.0069,-0.0276 -0.01102,-0.0482 -0.09095,-0.11162 -0.146072,-0.24942 -0.146072,-0.36793 0,-0.0165 0.0014,-0.0234 0.0083,-0.051 -0.05236,-0.0537 -0.05926,-0.0661 -0.09922,-0.20808 -0.03032,-0.1006 -0.04961,-0.1447 -0.08544,-0.19293 -0.0096,-0.0124 -0.01516,-0.022 -0.01516,-0.0289 0,-0.0193 0.03032,-0.0358 0.08544,-0.0441 0.05099,-0.008 0.05374,-0.01 0.07441,-0.01 l 0.07304,0.006 -0.0041,-0.10197 c 0,-0.0593 0.0041,-0.0978 0.01929,-0.1695 0.0069,-0.0344 0.01102,-0.0606 0.01102,-0.0772 0,-0.006 -0.0028,-0.0276 -0.0069,-0.0634 -0.0041,-0.0276 -0.0083,-0.0455 -0.01102,-0.0551 -0.0055,-0.0138 -0.0083,-0.0248 -0.0083,-0.0317 0,-0.0124 0.0083,-0.0179 0.02205,-0.0179 0.01103,0 0.02618,0.006 0.04823,0.0165 0.06477,0.0317 0.118511,0.0634 0.159852,0.0951 0.128158,0.1006 0.228755,0.25494 0.228755,0.35002 l -0.0028,0.0289 c -0.0041,0.0331 -0.0069,0.0524 -0.0069,0.0551 0,0.0152 0.0096,0.0372 0.02618,0.0593 l 0.03996,0.0565 c 0.03721,0.0496 0.06063,0.10611 0.06063,0.14469 0,0.0344 -0.0083,0.0496 -0.06752,0.13643 -0.04548,0.0648 -0.06339,0.113 -0.06339,0.16674 0,0.0662 0.02618,0.15021 0.07441,0.23427 0.0441,0.0772 0.09371,0.11851 0.143316,0.11851 0.08268,0 0.118511,-0.073 0.130913,-0.2701 0.0069,-0.10335 0.01653,-0.19706 0.03032,-0.28249 l 0.0028,-0.051 c 0,-0.022 -0.0069,-0.0358 -0.03721,-0.0717 l -0.110243,-0.12954 c -0.106109,-0.12402 -0.139182,-0.18741 -0.139182,-0.2756 0,-0.10198 0.06752,-0.17364 0.165364,-0.17364 l 0.0441,0.004 v -0.0289 c 0,-0.0234 0.0055,-0.0565 0.01791,-0.1006 0.02343,-0.0799 0.05237,-0.14056 0.0689,-0.14056 0.0041,0 0.01654,0.006 0.03583,0.0179 0.0055,0.004 0.02756,0.0138 0.06615,0.0262 0.02067,0.007 0.03583,0.0152 0.07441,0.0372 0.01791,-0.0634 0.03032,-0.0937 0.05926,-0.12954 0.04823,-0.062 0.101974,-0.11162 0.121267,-0.11162 0.01102,0 0.03307,0.0165 0.06063,0.0441 l 0.07028,0.0744 c 0.01102,0.0124 0.0248,0.0372 0.04134,0.0703 l 0.01378,0.0344 c 0.01929,-0.0124 0.03445,-0.0207 0.04548,-0.0262 0.02894,-0.0179 0.04823,-0.0289 0.05925,-0.0331 0.0441,-0.022 0.06752,-0.0331 0.0689,-0.0344 0.02067,-0.0124 0.03307,-0.0193 0.03858,-0.0193 0.0124,0 0.01929,0.0234 0.04685,0.14607 0.01929,0.0841 0.02205,0.10198 0.02618,0.16261 0.118511,0.0165 0.175011,0.0841 0.175011,0.21222 0,0.11989 -0.05926,0.2384 -0.186036,0.37345 -0.03445,0.0372 -0.04272,0.0551 -0.04272,0.0896 0,0.32797 0.114377,0.43133 0.525033,0.47405 0.252181,0.0262 0.326595,0.0427 0.629763,0.13367 0.159853,0.0482 0.250803,0.0675 0.310059,0.0675 0.07028,0 0.108865,-0.0248 0.108865,-0.0703 0,-0.0689 -0.04961,-0.091 -0.344509,-0.15296 -0.686264,-0.1447 -0.956359,-0.37896 -0.956359,-0.83234 0,-0.32246 0.241157,-0.56499 0.563617,-0.56499 0.141938,0 0.270096,0.0427 0.47129,0.15847 0.186035,0.10887 0.22462,0.12678 0.267339,0.12678 0.04961,0 0.0689,-0.0317 0.0689,-0.11162 0,-0.0524 0.01654,-0.0772 0.04823,-0.0772 0.03032,0 0.07441,0.0303 0.115756,0.0772 0.06063,0.073 0.08544,0.11024 0.08544,0.21084 0,0.13367 -0.07166,0.22186 -0.212218,0.26045 -0.01378,0.0165 -0.02618,0.0289 -0.03307,0.0372 -0.07579,0.0854 -0.143316,0.11437 -0.264583,0.11437 -0.106109,0 -0.238401,-0.0427 -0.327973,-0.10748 l -0.177767,-0.12541 c -0.07717,-0.0551 -0.13367,-0.0785 -0.187413,-0.0785 -0.07579,0 -0.121268,0.0455 -0.121268,0.12126 0,0.0744 0.04961,0.13505 0.129536,0.16123 l 0.166742,0.051 c 0.05926,0.0193 0.08819,0.0303 0.159853,0.0675 0.04134,-0.007 0.06063,-0.008 0.08268,-0.008 0.104731,0 0.216352,0.0276 0.314193,0.0786 0.03169,0.0151 0.05374,0.0262 0.06615,0.0289 l 0.09371,0.0262 c 0.209462,0.0592 0.381717,0.2949 0.381717,0.52503 0,0.26183 -0.169499,0.42444 -0.445107,0.42444 l -0.08544,-0.004" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path199" d="m -61.286674,120.94883 c 0.06477,0.0854 0.155718,0.14056 0.230132,0.14056 0.02205,0 0.06339,-0.006 0.09922,-0.0152 0.02067,-0.004 0.03721,-0.007 0.04961,-0.007 0.01791,0 0.02618,0.007 0.02618,0.0234 0,0.0124 -0.0096,0.0441 -0.01929,0.0689 -0.0124,0.0289 -0.01929,0.051 -0.02205,0.0675 l -0.01516,0.0772 -0.03721,0.0675 -0.05236,0.0482 -0.01378,0.0138 v 0.051 c 0,0.0896 -0.02756,0.14193 -0.100597,0.19017 -0.0055,0.004 -0.01516,0.011 -0.02618,0.0193 l -0.0069,0.0289 c -0.01654,0.0689 -0.02894,0.113 -0.03721,0.12953 -0.0096,0.0207 -0.03307,0.0551 -0.07028,0.10473 -0.04548,0.0579 -0.07441,0.10611 -0.09371,0.15159 -0.01516,0.0372 -0.02618,0.0469 -0.05099,0.0469 -0.03583,0 -0.07166,-0.0441 -0.07855,-0.0992 -0.0083,0.011 -0.01378,0.0193 -0.01791,0.022 l -0.0441,0.0303 -0.07166,0.0482 c -0.03032,0.0207 -0.05099,0.0358 -0.05926,0.0441 l -0.03996,0.0413 c -0.0069,0.007 -0.01516,0.011 -0.02205,0.011 -0.01791,0 -0.03721,-0.0317 -0.0565,-0.0937 l -0.03721,-0.12127 c -0.0096,-0.0331 -0.01378,-0.073 -0.01378,-0.11989 0,-0.062 0.0041,-0.0827 0.0248,-0.13229 -0.07442,0.008 -0.09371,0.0124 -0.132292,0.0262 -0.0124,0.004 -0.02618,0.007 -0.03307,0.007 -0.0124,0 -0.01929,-0.008 -0.01929,-0.022 0,-0.008 0.0069,-0.0345 0.01516,-0.0551 l 0.04823,-0.12678 c 0.03721,-0.0978 0.157096,-0.18604 0.253559,-0.18604 0.02343,0 0.05374,0.007 0.09508,0.0193 0.02343,0.008 0.04272,0.0124 0.05512,0.0124 0.0441,0 0.07717,-0.0317 0.07717,-0.0717 0,-0.0193 -0.0124,-0.0413 -0.02894,-0.0482 -0.0069,-0.003 -0.05099,-0.0165 -0.13367,-0.0413 -0.06201,-0.0179 -0.09371,-0.0413 -0.162609,-0.12127 -0.05099,-0.0593 -0.07166,-0.0758 -0.08957,-0.0758 -0.01378,0 -0.02205,0.01 -0.02205,0.0262 l 0.0028,0.0496 0.0014,0.022 c 0,0.10335 -0.03032,0.20119 -0.104731,0.33762 l -0.103353,0.18879 c -0.04961,0.0896 -0.07028,0.1571 -0.07028,0.226 0,0.0744 0.03169,0.14056 0.07441,0.15158 l 0.05512,0.0152 c 0.0069,0.001 0.01378,0.006 0.01929,0.011 0.0069,0.008 0.01102,0.0152 0.01102,0.022 0,0.007 -0.0069,0.0193 -0.01929,0.0331 -0.0055,0.008 -0.02894,0.0372 -0.06615,0.0854 -0.06477,0.0841 -0.104731,0.11437 -0.181901,0.1378 -0.04548,0.10887 -0.118512,0.17225 -0.248047,0.21497 l -0.01516,0.0262 c -0.0441,0.0772 -0.141938,0.14745 -0.205328,0.14745 h -0.01377 c -0.0083,0.0689 -0.0565,0.13918 -0.129535,0.19017 -0.05099,0.0344 -0.07855,0.0551 -0.08544,0.062 -0.0041,0.006 -0.01102,0.0165 -0.01791,0.0331 -0.01653,0.0372 -0.03307,0.0524 -0.05374,0.0524 -0.03859,0 -0.07166,-0.0372 -0.09508,-0.10749 -0.01516,0.01 -0.02618,0.0179 -0.03307,0.0221 -0.04272,0.0303 -0.06615,0.0455 -0.07028,0.0482 -0.01791,0.008 -0.06063,0.0207 -0.130914,0.0372 -0.08957,0.0221 -0.16812,0.0606 -0.188791,0.0923 l -0.03307,0.0565 -0.01516,0.006 c -0.01791,0 -0.03858,-0.0248 -0.04823,-0.0579 -0.01929,-0.0772 -0.03307,-0.1571 -0.03307,-0.20808 0,-0.13229 0.0441,-0.21773 0.177767,-0.3514 v -0.0317 c 0,-0.20533 0.155718,-0.34451 0.385851,-0.34451 l 0.03721,0.001 0.125401,0.008 h 0.0124 c 0.0689,0 0.130913,-0.0262 0.199815,-0.0827 0.09095,-0.073 0.117133,-0.11989 0.117133,-0.20257 0,-0.0262 -0.0083,-0.0565 -0.03583,-0.14883 -0.01791,-0.062 -0.02756,-0.11851 -0.02756,-0.17501 0,-0.15296 0.112999,-0.34313 0.264583,-0.44786 0.03996,-0.0276 0.0689,-0.0634 0.0689,-0.0841 0,-0.008 -0.0041,-0.0152 -0.0096,-0.0152 -0.0096,0 -0.02756,0.01 -0.04823,0.0289 -0.01791,0.0165 -0.04685,0.0344 -0.08819,0.0551 l -0.05926,0.0289 -0.06752,0.0262 c -0.02067,0.008 -0.03032,0.0193 -0.03032,0.0331 0,0.008 0.0028,0.0207 0.0083,0.0344 0.0055,0.0124 0.0069,0.0221 0.0069,0.0276 0,0.008 -0.0055,0.0221 -0.01791,0.0427 l -0.05099,0.0854 c -0.05237,0.0841 -0.08819,0.11851 -0.152962,0.14745 -0.04134,0.12264 -0.101975,0.18465 -0.188792,0.19706 -0.07028,0.14056 -0.132292,0.19017 -0.256315,0.20395 -0.01653,0.0537 -0.04685,0.0992 -0.111621,0.17087 -0.0248,0.0289 -0.04134,0.0482 -0.04685,0.0593 -0.02894,0.0524 -0.03169,0.0551 -0.04548,0.0551 -0.01653,0 -0.0565,-0.0248 -0.08544,-0.0551 -0.0124,-0.0138 -0.02343,-0.0289 -0.03307,-0.0455 l -0.03307,-0.0592 c -0.01102,-0.0179 -0.02205,-0.0276 -0.03583,-0.0276 l -0.02343,10e-4 -0.0813,0.0124 c -0.05099,0.007 -0.124024,0.0482 -0.148828,0.0854 l -0.0441,0.0662 c -0.0041,0.007 -0.01103,0.011 -0.01791,0.011 -0.03307,0 -0.05374,-0.073 -0.05374,-0.1943 0,-0.10611 0.01654,-0.17777 0.05236,-0.22875 l 0.104731,-0.14332 c 0.01378,-0.0207 0.02205,-0.0413 0.02205,-0.0565 0,-0.0165 -0.0069,-0.0331 -0.01929,-0.0482 -0.02067,-0.0262 -0.04272,-0.0413 -0.05926,-0.0441 l -0.07717,-0.011 c -0.01378,-0.003 -0.01929,-0.006 -0.01929,-0.0124 0,-0.006 0.0041,-0.0152 0.01102,-0.0248 0.02618,-0.0331 0.05788,-0.0606 0.09371,-0.0813 0.09095,-0.0565 0.151584,-0.0785 0.213596,-0.0785 0.06201,0 0.130914,0.022 0.194304,0.0634 l 0.107487,0.0703 c 0.01516,0.01 0.03307,0.0152 0.05099,0.0152 0.04961,0 0.08682,-0.0289 0.122646,-0.0965 0.03445,-0.0648 0.04961,-0.11714 0.04961,-0.17226 0,-0.13918 -0.100597,-0.23978 -0.238401,-0.23978 -0.06477,0 -0.129535,0.0262 -0.192925,0.0744 -0.01929,0.0152 -0.03169,0.0289 -0.03721,0.0413 l -0.02894,0.0661 c -0.0069,0.0165 -0.01791,0.0262 -0.02756,0.0262 -0.01791,0 -0.06063,-0.0538 -0.09509,-0.12265 -0.01929,-0.0358 -0.03583,-0.0813 -0.05237,-0.13367 -0.02205,-0.0717 -0.03169,-0.12678 -0.03169,-0.18466 l 0.0055,-0.10059 c -0.04961,-0.0785 -0.06615,-0.13643 -0.06615,-0.22876 0,-0.0345 0.0041,-0.0606 0.02618,-0.13091 -0.0317,-0.051 -0.04134,-0.0896 -0.04134,-0.16537 l 0.0041,-0.0455 0.01102,-0.0524 0.0069,-0.0441 c -0.03583,-0.0469 -0.04547,-0.0786 -0.08131,-0.24116 -0.01929,-0.0923 -0.03169,-0.13229 -0.04823,-0.15572 -0.0069,-0.011 -0.01102,-0.0179 -0.01102,-0.022 0,-0.0221 0.05237,-0.0413 0.110243,-0.0413 l 0.05236,0.004 c -0.0124,-0.0345 -0.01516,-0.0469 -0.01516,-0.0744 0,-0.0455 0.0096,-0.0978 0.02756,-0.14745 0.01929,-0.0565 0.02343,-0.073 0.02343,-0.0909 0,-0.0441 -0.0069,-0.0896 -0.01653,-0.113 l -0.03032,-0.0744 c -0.0055,-0.0165 -0.0096,-0.0289 -0.0096,-0.0386 0,-0.007 0.0055,-0.01 0.01929,-0.01 0.07304,0 0.21084,0.0786 0.321083,0.1819 0.107487,0.10197 0.143316,0.18466 0.143316,0.33762 l -0.0069,0.0813 c 0.101975,0.0882 0.146072,0.16123 0.146072,0.24116 0,0.0579 -0.01929,0.0965 -0.07441,0.15158 -0.100597,0.0992 -0.124024,0.15021 -0.124024,0.27837 0,0.19706 0.05926,0.30317 0.168121,0.30317 0.09509,0 0.169499,-0.10336 0.181901,-0.25632 l 0.01102,-0.14056 c 0.0028,-0.0358 0.0083,-0.0813 0.01791,-0.13367 0.0055,-0.0331 0.01102,-0.0772 0.01102,-0.0965 0,-0.0496 -0.03169,-0.113 -0.129535,-0.226 -0.104731,-0.12127 -0.139182,-0.18741 -0.139182,-0.2825 0,-0.113 0.07855,-0.19706 0.186035,-0.19706 0.02618,0 0.03996,0.004 0.07166,0.0207 0.0014,-0.0648 0.0041,-0.0772 0.04134,-0.16674 0.02894,-0.0717 0.05926,-0.12265 0.07304,-0.12265 0.0055,0 0.01378,0.006 0.02205,0.0152 0.01654,0.0152 0.03307,0.0289 0.04961,0.04 0.02205,0.0165 0.03445,0.0248 0.03583,0.0262 0.0083,0.007 0.02067,0.0179 0.03445,0.0344 0.02205,-0.0841 0.04685,-0.12265 0.114377,-0.19017 0.05237,-0.051 0.07166,-0.0661 0.08131,-0.0661 0.0083,0 0.01791,0.007 0.02618,0.0179 l 0.04548,0.0593 0.06201,0.0703 c 0.0248,0.0276 0.03307,0.051 0.0441,0.11576 l 0.03721,-0.0221 0.05926,-0.0344 c 0.01102,-0.006 0.02618,-0.0152 0.04547,-0.0289 0.0096,-0.007 0.01791,-0.011 0.02343,-0.011 0.0055,0 0.0124,0.01 0.01653,0.0262 l 0.02205,0.0854 0.04823,0.0951 c 0.01516,0.0289 0.01929,0.051 0.01929,0.0965 v 0.0234 l 0.0248,-0.001 c 0.07304,0 0.135048,0.0868 0.135048,0.18603 0,0.13229 -0.104731,0.30317 -0.241157,0.39274 -0.01378,0.0455 -0.01653,0.0634 -0.01653,0.0992 0,0.2949 0.07855,0.35691 0.531923,0.42444 0.112999,0.0165 0.213596,0.0372 0.303168,0.062 0.01516,0.004 0.113,0.0358 0.293523,0.0965 0.09922,0.0344 0.166742,0.0482 0.219107,0.0482 0.05512,0 0.08544,-0.0152 0.08544,-0.0441 0,-0.051 -0.07441,-0.0965 -0.30179,-0.18604 l -0.322464,-0.1254 c -0.327973,-0.12816 -0.482314,-0.32798 -0.482314,-0.62288 0,-0.34313 0.257694,-0.60082 0.600825,-0.60082 0.129536,0 0.256315,0.0262 0.438216,0.0937 0.234267,0.0841 0.245291,0.0882 0.271474,0.0882 0.04548,0 0.07028,-0.0303 0.07717,-0.0965 0.0055,-0.0551 0.02067,-0.0772 0.05099,-0.0772 0.04548,0 0.09509,0.0413 0.130914,0.11024 0.03032,0.0606 0.04823,0.13091 0.04823,0.19292 0,0.12265 -0.06477,0.20258 -0.181901,0.226 -0.07855,0.10336 -0.177767,0.15296 -0.299034,0.15296 -0.14745,0 -0.220486,-0.0289 -0.472667,-0.18603 -0.08957,-0.0565 -0.128158,-0.0703 -0.194304,-0.0703 -0.08819,0 -0.15434,0.0551 -0.15434,0.12954 0,0.0675 0.05512,0.11162 0.177767,0.14469 0.07441,0.0193 0.08406,0.0248 0.122646,0.0634 0.03032,-0.007 0.04272,-0.01 0.06201,-0.01 0.11989,0 0.268718,0.0648 0.394119,0.17226 0.228754,0.0717 0.431326,0.31695 0.431326,0.52365 0,0.22876 -0.197059,0.43409 -0.418923,0.43409 -0.05926,0 -0.179146,-0.0193 -0.286632,-0.0455" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path201" d="m -67.440993,115.62822 c -0.0096,-0.0441 -0.01378,-0.0675 -0.01378,-0.0896 l 0.0028,-0.0289 0.01102,-0.0592 0.0041,-0.0469 c 0,-0.0524 -0.0083,-0.0896 -0.02618,-0.11162 l -0.0441,-0.0592 c -0.01516,-0.0207 -0.02756,-0.0441 -0.03721,-0.0717 -0.0055,-0.0138 -0.0069,-0.0234 -0.0069,-0.0303 0,-0.0179 0.0096,-0.0276 0.02618,-0.0276 0.0096,0 0.01378,0.001 0.04685,0.0221 0.01516,0.008 0.02756,0.0124 0.03721,0.0124 0.02205,0 0.03445,-0.0358 0.03445,-0.0992 0,-0.0717 -0.0069,-0.11162 -0.02343,-0.12816 l -0.05512,-0.0634 -0.04823,-0.0413 c -0.0124,-0.01 -0.01929,-0.0221 -0.01929,-0.0317 0,-0.0165 0.0124,-0.0276 0.03032,-0.0276 0.01653,0 0.05099,0.008 0.0813,0.0193 l 0.01791,0.004 c 0.01516,0 0.02067,-0.01 0.02067,-0.0317 l -0.0014,-0.0138 -0.01102,-0.0786 -0.02205,-0.0813 c -0.0069,-0.0262 -0.01102,-0.0303 -0.02756,-0.0303 l -0.0096,0.001 -0.09233,0.0179 -0.01516,10e-4 c -0.121267,0 -0.249424,-0.10198 -0.289388,-0.23151 l -0.07441,-0.23978 c -0.02205,-0.0744 -0.07717,-0.14608 -0.177767,-0.22738 -0.03032,-0.0234 -0.05512,-0.0386 -0.07304,-0.04 l -0.06752,-0.008 c -0.0124,0 -0.02067,-0.008 -0.02067,-0.0179 0,-0.0152 0.01516,-0.022 0.04685,-0.022 l 0.122645,0.011 c 0.0441,0.004 0.111621,0.022 0.199815,0.0524 0.110243,0.0372 0.186036,0.0537 0.248047,0.0537 0.186035,0 0.296279,-0.1006 0.296279,-0.26734 0,-0.11576 -0.05926,-0.24529 -0.151584,-0.32797 -0.05237,-0.0469 -0.103353,-0.0827 -0.122646,-0.0827 -0.0096,0 -0.01791,0.01 -0.01791,0.0207 l 0.0041,0.0469 v 0.004 c 0,0.0193 -0.01102,0.0331 -0.02618,0.0331 -0.01791,0 -0.03996,-0.0248 -0.06339,-0.0744 -0.07028,-0.14607 -0.181901,-0.23289 -0.296279,-0.23289 -0.01929,0 -0.03445,0.008 -0.03445,0.0207 0,0.007 0.0069,0.0262 0.01929,0.0537 l 0.02894,0.0662 c 0.0083,0.0179 0.0124,0.0289 0.0124,0.0344 0,0.004 -0.0069,0.008 -0.01516,0.008 -0.01791,0 -0.0441,-0.0152 -0.06339,-0.0344 l -0.05512,-0.0606 -0.04823,-0.0744 c -0.03858,-0.0592 -0.07028,-0.0854 -0.152962,-0.12953 -0.04548,-0.0234 -0.07579,-0.04 -0.08819,-0.0482 -0.01653,-0.01 -0.03307,-0.0152 -0.04685,-0.0152 -0.0124,0 -0.01929,0.007 -0.01929,0.0207 0,0.011 0.0055,0.0248 0.01378,0.04 0.02756,0.0413 0.03858,0.0634 0.03858,0.073 0,0.0124 -0.0083,0.0234 -0.01929,0.0234 -0.02894,0 -0.08819,-0.0593 -0.141938,-0.1378 -0.04272,-0.0648 -0.06615,-0.13781 -0.06615,-0.20809 0,-0.15985 0.115755,-0.27698 0.274229,-0.27698 0.07993,0 0.183279,0.0331 0.278364,0.0923 l 0.173633,0.10748 c 0.06063,0.0372 0.150206,0.0662 0.202572,0.0662 0.02343,0 0.07304,-0.008 0.108864,-0.0179 0.01654,-0.004 0.03169,-0.011 0.04548,-0.0193 0.0096,-0.006 0.01654,-0.0138 0.01654,-0.0207 0,-0.007 -0.0041,-0.0138 -0.0096,-0.0152 l -0.02205,-0.008 -0.0813,-0.0152 c -0.02205,-0.003 -0.05512,-0.0152 -0.100597,-0.0372 -0.09784,-0.0441 -0.159852,-0.0744 -0.184657,-0.0923 -0.06201,-0.04 -0.101975,-0.0634 -0.122646,-0.0703 -0.03032,-0.01 -0.04961,-0.0234 -0.04961,-0.0344 0,-0.011 0.0055,-0.0165 0.01654,-0.0165 0.01102,0 0.0248,0.004 0.03996,0.0138 0.05374,0.0345 0.101975,0.0524 0.137804,0.0524 l 0.158474,0.0551 c 0.07993,0.0276 0.194303,0.0524 0.246669,0.0524 0.06752,0 0.122645,-0.0551 0.122645,-0.12265 0,-0.0441 -0.02618,-0.10886 -0.06477,-0.16261 -0.0083,-0.0124 -0.01791,-0.0193 -0.0248,-0.0193 -0.01516,0 -0.02343,0.011 -0.02343,0.0303 l 0.0041,0.0289 0.0055,0.0441 c 0,0.0482 -0.03307,0.0868 -0.07441,0.0868 -0.01378,0 -0.03445,-0.004 -0.05788,-0.0124 l -0.241156,-0.0772 c -0.201194,-0.0648 -0.2949,-0.0854 -0.395497,-0.0854 -0.289388,0 -0.508496,0.19843 -0.508496,0.45888 0,0.2949 0.206705,0.48507 0.719336,0.66008 0.502984,0.17364 0.574642,0.21635 0.574642,0.34589 0,0.0744 -0.07579,0.14056 -0.159853,0.14056 -0.03445,0 -0.06339,-0.003 -0.08957,-0.007 -0.01654,-0.004 -0.100597,-0.0234 -0.250803,-0.0593 -0.152962,-0.0372 -0.290766,-0.0524 -0.461643,-0.0524 -0.363802,0 -0.566374,0.0634 -0.740006,0.23289 -0.0441,0.0427 -0.05788,0.0496 -0.108865,0.0496 l -0.0248,-10e-4 -0.05099,-0.003 -0.0083,-0.001 c -0.04272,0 -0.07441,0.0207 -0.103353,0.0675 -0.03996,0.0634 -0.06063,0.0965 -0.06339,0.10059 -0.01102,0.0138 -0.02618,0.0221 -0.04272,0.0221 -0.03307,0 -0.05374,-0.0262 -0.09095,-0.11575 -0.01791,-0.0427 -0.0441,-0.0813 -0.07717,-0.11024 l -0.07441,-0.0675 c -0.0124,-0.011 -0.01929,-0.0207 -0.01929,-0.0289 0,-0.007 0.0055,-0.0193 0.01516,-0.0331 0.03583,-0.0524 0.04823,-0.0758 0.05237,-0.0978 0.0096,-0.0482 0.01103,-0.051 0.03169,-0.051 0.02205,0 0.02894,0.0221 0.03169,0.10749 0,0.0248 0.0096,0.0579 0.02894,0.1006 l 0.04134,0.0882 c 0.0041,0.0124 0.01791,0.0193 0.03307,0.0193 0.03859,0 0.08682,-0.0909 0.100597,-0.18603 0.0096,-0.0799 0.01791,-0.10335 0.03445,-0.10335 0.0069,0 0.01378,0.003 0.01653,0.007 0.0041,0.006 0.01516,0.0276 0.03307,0.0675 0.0096,0.0193 0.02618,0.0386 0.04823,0.0551 0.02205,0.0165 0.03721,0.0248 0.04548,0.0262 h 0.0041 c 0.03032,0 0.03996,-0.0193 0.04685,-0.0896 l 0.0041,-0.0372 -0.0083,-0.051 -0.0041,-0.0358 c 0,-0.0248 0.0083,-0.0386 0.02205,-0.0386 0.0083,0 0.01791,0.006 0.02756,0.0152 l 0.03721,0.0372 c 0.0248,0.0234 0.04961,0.0358 0.07304,0.0358 0.03032,0 0.04961,-0.0124 0.04961,-0.0317 0,-0.0179 -0.0069,-0.0358 -0.03445,-0.0868 l -0.0248,-0.0482 c -0.03032,-0.0551 -0.05374,-0.0772 -0.0813,-0.0772 l -0.03858,0.004 -0.0441,0.0179 c -0.01378,0.006 -0.02343,0.008 -0.02894,0.008 -0.0069,0 -0.0124,-0.007 -0.0124,-0.0152 0,-0.0331 0.02205,-0.0854 0.06339,-0.1502 0.03032,-0.0469 0.04961,-0.14745 0.05926,-0.29215 0.0124,-0.19292 0.03859,-0.31832 0.06615,-0.31832 0.01791,0 0.0248,0.0152 0.0248,0.0565 l -0.0014,0.051 -0.0014,0.0358 c 0,0.0345 0.0069,0.062 0.01653,0.062 0.03169,0 0.0689,-0.0469 0.09922,-0.12402 0.0124,-0.0317 0.01929,-0.0579 0.01929,-0.0758 l -0.0041,-0.0165 -0.07441,-0.1378 -0.07441,-0.0221 c -0.0124,-0.004 -0.02205,-0.01 -0.0248,-0.0165 v -0.091 l -0.0083,-0.0441 -0.01516,-0.0372 -0.01791,-0.04 c -0.0813,0.0441 -0.119889,0.0717 -0.14745,0.11024 -0.03032,0.0386 -0.04685,0.0538 -0.06063,0.0538 -0.0096,0 -0.01791,-0.008 -0.01791,-0.0193 0,-0.01 0.0041,-0.0289 0.01102,-0.0606 l 0.0028,-0.0207 c 0,-0.0799 -0.04823,-0.15847 -0.128157,-0.20808 l -0.02343,0.0289 -0.02618,0.0372 -0.0441,0.0524 c -0.01378,0.0165 -0.02618,0.0413 -0.03721,0.0744 -0.0041,0.0152 -0.0069,0.0289 -0.0069,0.0413 v 0.0193 c 0,0.0317 -0.0028,0.0386 -0.01653,0.0386 l -0.0096,-0.004 -0.02618,-0.0358 -0.03996,-0.0455 -0.06339,-0.04 -0.03307,-0.0262 c -0.0069,0.0152 -0.0124,0.0262 -0.01516,0.0331 -0.01103,0.0262 -0.01791,0.0455 -0.01791,0.0593 l -0.0041,0.0593 -0.0041,0.0634 v 0.011 c 0,0.0317 -0.0069,0.0455 -0.02618,0.0455 -0.0069,0 -0.02618,-0.008 -0.0441,-0.0193 -0.01653,-0.01 -0.03583,-0.0152 -0.05374,-0.0152 -0.05788,0 -0.09371,0.04 -0.09371,0.10197 0,0.0744 0.02067,0.1447 0.05926,0.1943 l 0.04685,0.0634 c 0.01378,0.0165 0.03858,0.0317 0.03996,0.022 l 0.0083,-0.0772 -0.01102,-0.0634 -0.0014,-0.0289 c 0,-0.0234 0.0083,-0.0386 0.02205,-0.0386 0.02067,0 0.03307,0.0234 0.04685,0.0854 l 0.02894,0.1378 0.03032,0.17363 c 0.0083,0.0469 0.02205,0.0979 0.0441,0.14883 0.02894,0.0703 0.05099,0.113 0.06339,0.12954 0.03996,0.0524 0.04548,0.0606 0.04548,0.0717 0,0.01 -0.0069,0.0179 -0.01516,0.0179 -0.0083,0 -0.02067,-0.004 -0.03445,-0.0124 -0.0124,-0.006 -0.02756,-0.011 -0.0441,-0.0138 l -0.02894,-0.004 c -0.05925,0 -0.07166,0.051 -0.07166,0.29766 0,0.15158 0.03169,0.35691 0.07028,0.45475 l 0.07855,0.19706 c 0.0124,0.0303 0.01791,0.062 0.01791,0.0923 0,0.2701 -0.358289,0.69453 -0.752409,0.89021 -0.14607,0.073 -0.192923,0.14194 -0.203947,0.30317 l -0.0041,0.0482 c 0.06063,-0.0303 0.08544,-0.04 0.12678,-0.051 0.110243,-0.0289 0.132291,-0.0427 0.148828,-0.0965 l 0.01378,-0.0482 c 0.0069,-0.0179 0.01516,-0.0248 0.100597,-0.0703 0.02894,-0.0165 0.04961,-0.0331 0.05926,-0.0482 0.01929,-0.0317 0.03445,-0.0482 0.0441,-0.0482 0.0096,0 0.01378,0.004 0.01378,0.0124 l -0.0028,0.0138 -0.03721,0.10473 -0.0041,0.0262 c 0,0.0786 0.0441,0.14194 0.122646,0.18328 0.01378,-0.0854 0.02343,-0.11575 0.04961,-0.15572 l 0.06615,-0.10335 c 0.0248,-0.0386 0.03583,-0.0854 0.03583,-0.15847 0,-0.0413 -0.0041,-0.0841 -0.0096,-0.11576 l -0.0028,-0.0303 c 0,-0.0179 0.0096,-0.0289 0.02618,-0.0289 0.0124,0 0.02343,0.004 0.0248,0.011 l 0.01516,0.0703 c 0.0028,0.0152 0.01791,0.0262 0.03583,0.0262 0.03583,0 0.0813,-0.0469 0.130913,-0.12953 0.01791,-0.0317 0.02756,-0.0648 0.02756,-0.0978 l -0.0055,-0.051 -0.01102,-0.0551 -0.0014,-0.011 c 0,-0.0248 0.01378,-0.0413 0.03307,-0.0413 0.0083,0 0.01516,0.003 0.01654,0.007 l 0.02205,0.0854 c 0.0069,0.0289 0.02756,0.0482 0.04823,0.0482 0.0248,0 0.06752,-0.0427 0.09233,-0.0923 0.02205,-0.0441 0.03307,-0.0937 0.03307,-0.15158 0,-0.0799 0.0083,-0.10198 0.03721,-0.10198 0.0096,0 0.01791,0.004 0.01929,0.008 l 0.01378,0.0482 c 0.0055,0.0179 0.01653,0.0303 0.02756,0.0303 0.01516,0 0.0565,-0.0455 0.08406,-0.0923 0.0083,-0.0124 0.01102,-0.0248 0.01102,-0.0345 0,-0.0165 -0.0096,-0.0317 -0.03307,-0.051 -0.03859,-0.0331 -0.04134,-0.0372 -0.04134,-0.0854 0,-0.0469 0.0083,-0.0717 0.04134,-0.12954 0.01791,-0.0317 0.03445,-0.062 0.04823,-0.0896 0.04685,-0.0909 0.06339,-0.11438 0.0813,-0.11438 0.01378,0 0.02618,0.0152 0.02618,0.0317 0,0.01 -0.0028,0.0207 -0.0069,0.0303 -0.01102,0.022 -0.01516,0.0358 -0.01516,0.0441 0,0.0152 0.0124,0.0276 0.02756,0.0276 0.01654,0 0.03859,-0.008 0.06477,-0.022 0.0096,-0.007 0.0441,-0.0207 0.103353,-0.0413 l 0.122645,-0.0441 c 0.02067,-0.008 0.04547,-0.011 0.07441,-0.011 0.02205,0 0.04547,10e-4 0.06615,0.007 0.0441,0.01 0.07304,0.0152 0.08544,0.0152 0.03445,0 0.06339,-0.0289 0.06339,-0.062 0,-0.0248 -0.0248,-0.073 -0.05926,-0.113 -0.0124,-0.0138 -0.01929,-0.0262 -0.01929,-0.0331 l 0.0041,-0.0152 c 0.0055,-0.008 0.0124,-0.0152 0.02067,-0.0152 0.0248,0 0.08268,0.0634 0.135048,0.14469 0.319704,0.50299 0.434081,0.62563 0.649055,0.6904 0.217731,0.0661 0.275608,0.11713 0.275608,0.24667 0,0.0703 -0.03721,0.15296 -0.115755,0.26458 -0.161231,0.226 -0.201194,0.31695 -0.201194,0.46578 v 0.0276 c 0.01929,-0.008 0.03169,-0.0138 0.04134,-0.0193 0.03032,-0.0152 0.04961,-0.0234 0.05926,-0.0248 l 0.09233,-0.0193 c 0.02756,-0.006 0.05237,-0.0413 0.05237,-0.0758 v -0.01 l -0.01102,-0.0813 -0.0014,-0.011 c 0,-0.0289 0.01516,-0.062 0.03445,-0.0772 0.0055,-0.006 0.0124,-0.008 0.01929,-0.008 0.01102,0 0.02343,0.01 0.02894,0.022 l 0.05926,0.12678 c 0.0248,0.051 0.05237,0.0758 0.129535,0.11025" style="fill:#fddc02;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path203" d="m -70.429958,112.94105 c -0.02618,0 -0.03996,0.0234 -0.04272,0.0744 l -0.0083,0.0703 c -0.0083,0.0661 -0.0083,0.073 -0.0083,0.0896 0,0.0524 0.01516,0.0923 0.03721,0.0923 0.02343,0 0.06063,-0.0455 0.07855,-0.0965 0.01102,-0.0317 0.01653,-0.0593 0.01653,-0.0868 0,-0.0248 -0.0055,-0.0537 -0.01653,-0.0841 -0.0124,-0.0372 -0.03445,-0.0592 -0.0565,-0.0592" style="fill:#fddc02;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path205" d="m -70.770333,112.36227 0.0014,0.0331 c 0,0.0455 -0.01102,0.10059 -0.04961,0.24253 -0.0069,0.0248 -0.01102,0.051 -0.01102,0.0662 0,0.0248 0.0096,0.0524 0.03032,0.0854 0.0124,0.0193 0.02343,0.0317 0.03307,0.0358 l 0.0441,0.0234 0.0083,0.0524 c -0.0028,0.0193 0.0014,0.0469 0.01102,0.0813 0.0096,0.0358 0.01516,0.073 0.01516,0.11024 0,0.0317 -0.0028,0.0441 -0.0096,0.0441 -0.01378,0 -0.03859,-0.0386 -0.06201,-0.0951 -0.03583,-0.0896 -0.06752,-0.12265 -0.117133,-0.12265 -0.04134,0 -0.06752,0.006 -0.115755,0.0289 0.01102,0.0152 0.01929,0.0248 0.02205,0.0303 0.0028,0.004 0.01378,0.0262 0.03307,0.0634 l 0.05237,0.0992 c 0.03583,0.0703 0.0565,0.10886 0.06339,0.11851 0.01378,0.0221 0.03032,0.04 0.05099,0.0524 0.0069,0.004 0.02756,0.0152 0.05925,0.0331 0.01791,0.01 0.03032,0.0248 0.03032,0.0345 0,0.0165 -0.0124,0.0289 -0.03169,0.0289 h -0.0014 l -0.04823,-0.007 -0.02756,-0.004 c -0.01378,0 -0.02067,0.0138 -0.02067,0.0413 0,0.1006 0.07993,0.21636 0.217731,0.31833 0.01791,0.0124 0.03032,0.0303 0.03032,0.04 0,0.0124 -0.0124,0.0234 -0.02756,0.0234 -0.0083,0 -0.03032,-0.007 -0.04685,-0.0152 -0.0096,-0.006 -0.01929,-0.008 -0.02618,-0.008 -0.01792,0 -0.03032,0.0152 -0.03032,0.0386 0,0.0262 0.02205,0.0785 0.06752,0.16536 0.03032,0.0579 0.07579,0.1006 0.126779,0.12265 l 0.166743,0.0703 c 0.0096,0.004 0.01516,0.0124 0.01516,0.022 0,0.0138 -0.0096,0.0248 -0.02343,0.0262 l -0.03307,0.004 -0.02894,0.004 -0.04823,-0.004 h -0.0083 c -0.02205,0 -0.03169,0.004 -0.03169,0.0165 0,0.0179 0.02067,0.0648 0.05512,0.11989 0.03858,0.0675 0.07304,0.10473 0.09508,0.10473 0.0083,0 0.01791,-0.007 0.02343,-0.0193 l 0.03996,-0.0854 c 0.0069,-0.0138 0.03996,-0.04 0.09646,-0.073 0.03583,-0.022 0.07028,-0.0358 0.103353,-0.0413 l 0.06752,-0.011 c 0.01791,-0.003 0.02618,-0.0152 0.02618,-0.0358 v -0.008 l -0.01103,-0.0703 -0.0083,-0.0786 -0.0069,-0.0703 -0.0083,-0.0813 c 0,-0.0207 -0.0055,-0.0303 -0.01791,-0.0303 -0.0083,0 -0.02343,0.0124 -0.03307,0.0262 -0.05788,0.0896 -0.09922,0.11851 -0.161231,0.11851 -0.197059,0 -0.347265,-0.34726 -0.347265,-0.80753 0,-0.04 0.0028,-0.0909 0.0083,-0.15158 0.0096,-0.11851 0.01102,-0.14745 0.01102,-0.19155 0,-0.19981 -0.04134,-0.34037 -0.126779,-0.42443 l -0.05237,-0.0524 -0.03307,-0.0372" style="fill:#fddc02;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path207" d="m -70.292154,115.07287 c -0.05099,-0.008 -0.07579,-0.0138 -0.107487,-0.0262 -0.0083,-0.003 -0.03169,-0.0138 -0.07028,-0.0289 -0.05926,-0.0262 -0.103353,-0.0372 -0.141938,-0.0372 -0.05512,0 -0.100597,0.0179 -0.15434,0.062 l 0.03307,0.0262 0.07441,0.0524 0.07028,0.0551 c 0.01791,0.0152 0.03996,0.022 0.06201,0.022 0.07166,0 0.135047,-0.0331 0.234266,-0.12541" style="fill:#fddc02;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path209" d="m -68.864507,115.74811 c 0.02067,-0.0468 0.03032,-0.0592 0.07442,-0.0965 0.103352,-0.0896 0.151584,-0.15572 0.151584,-0.20808 v -0.0813 c 0,-0.0482 0.0083,-0.0634 0.03307,-0.0634 0.01102,0 0.01929,0.004 0.02343,0.011 l 0.01791,0.0441 c 0.0041,0.011 0.01653,0.0179 0.03169,0.0179 0.01378,0 0.03445,-0.0179 0.05374,-0.0441 l 0.03721,-0.051 c 0.01791,-0.0262 0.02618,-0.0482 0.02618,-0.073 0,-0.0138 -0.0028,-0.0289 -0.0083,-0.0427 -0.0028,-0.007 -0.01102,-0.0262 -0.0248,-0.0593 -0.0096,-0.0193 -0.01516,-0.0441 -0.01516,-0.0579 0,-0.0234 0.01102,-0.0386 0.03307,-0.0386 0.01102,0 0.02067,0.004 0.02618,0.0124 l 0.02894,0.0358 c 0.0069,0.008 0.01791,0.0138 0.02894,0.0138 0.0124,0 0.02894,-0.0138 0.03859,-0.0317 l 0.02894,-0.0593 c 0.0083,-0.0152 0.0124,-0.0262 0.0124,-0.0331 0,-0.0124 -0.0124,-0.0234 -0.03445,-0.0331 l -0.04823,-0.0234 c -0.06339,-0.0289 -0.111621,-0.13091 -0.111621,-0.23702 0,-0.0138 0.0028,-0.0276 0.0083,-0.04 l 0.02618,-0.0634 c 0.0069,-0.0179 0.01102,-0.0386 0.01102,-0.0592 0,-0.0386 -0.0124,-0.0772 -0.03721,-0.11576 -0.03032,-0.0455 -0.04685,-0.0716 -0.04823,-0.0772 -0.02205,-0.0593 -0.03307,-0.0744 -0.05099,-0.0744 l -0.01929,0.004 -0.02618,0.0152 -0.04134,0.0221 -0.04823,0.0593 -0.05099,0.0248 c -0.03169,0.0165 -0.06063,0.0827 -0.06063,0.13643 0,0.0965 0.01103,0.12402 0.137804,0.34313 0.04961,0.0841 0.07579,0.15709 0.07579,0.21084 0,0.15296 -0.136426,0.26045 -0.409277,0.32659 l -0.170877,0.04 c -0.125401,0.0303 -0.199816,0.11713 -0.225998,0.2632 0.05236,-0.0262 0.07304,-0.0303 0.163986,-0.0303 l 0.05512,0.001 h 0.0083 c 0.04961,0 0.0565,-0.004 0.08819,-0.0482 0.03583,-0.051 0.07304,-0.0827 0.122646,-0.10335 l 0.05926,-0.0262 0.04823,-0.0262 0.01378,-0.004 c 0.01378,0 0.02067,0.006 0.02067,0.0152 0,0.0152 -0.01378,0.0386 -0.03445,0.0634 -0.04272,0.0469 -0.05925,0.0868 -0.05925,0.14332 0,0.0358 0.0083,0.0565 0.03996,0.0978" style="fill:#fddc02;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path211" d="m -69.331662,115.17209 c 0.04272,0.0276 0.08544,0.0662 0.111622,0.1006 0.03583,0.0482 0.03996,0.0524 0.07579,0.0524 0.01378,0 0.03307,-0.003 0.05374,-0.008 l 0.03307,-0.007 c 0.06063,-0.011 0.08268,-0.0207 0.08268,-0.0358 0,-0.008 -0.0069,-0.0207 -0.01929,-0.0303 l -0.04134,-0.0372 -0.03996,-0.0372 c -0.02618,-0.0248 -0.07855,-0.0413 -0.122646,-0.0413 -0.0441,0 -0.07028,0.008 -0.13367,0.0441" style="fill:#fddc02;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path213" d="m -68.130012,115.37329 0.02205,-0.004 0.03307,-0.004 0.03307,0.004 0.01654,10e-4 c 0.08268,0 0.162609,-0.0703 0.162609,-0.14332 0,-0.0262 -0.0248,-0.04 -0.06615,-0.04 -0.09922,0 -0.162609,0.0579 -0.201194,0.18603" style="fill:#fddc02;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path215" d="m -60.523241,115.62822 c -0.0083,-0.0331 -0.01103,-0.0496 -0.01103,-0.0675 l 0.0041,-0.051 c 0.0083,-0.0689 0.0124,-0.10197 0.0124,-0.14331 0,-0.0276 -0.0083,-0.0496 -0.02756,-0.0744 l -0.0441,-0.0592 c -0.02894,-0.04 -0.04134,-0.0689 -0.04134,-0.10198 0,-0.0207 0.0055,-0.0289 0.02067,-0.0289 l 0.01653,0.004 c 0.0028,0.001 0.0124,0.007 0.03307,0.0193 0.01516,0.008 0.02756,0.0124 0.03721,0.0124 0.02205,0 0.03307,-0.0345 0.03307,-0.10474 0,-0.0965 -0.01791,-0.14193 -0.07441,-0.18603 l -0.05099,-0.0413 c -0.0096,-0.007 -0.01516,-0.0193 -0.01516,-0.0303 0,-0.0179 0.01103,-0.0289 0.02756,-0.0289 0.0096,0 0.0248,0.003 0.04272,0.008 l 0.04134,0.011 0.01516,0.003 c 0.0124,0 0.01929,-0.01 0.01929,-0.0317 l -0.0014,-0.0124 -0.01102,-0.0786 c -0.01102,-0.0799 -0.0248,-0.11162 -0.04823,-0.11162 l -0.0069,10e-4 -0.09646,0.0179 -0.01653,10e-4 c -0.115755,0 -0.252181,-0.10887 -0.28801,-0.23151 l -0.07028,-0.23978 c -0.02067,-0.073 -0.08406,-0.15159 -0.177767,-0.22738 -0.03169,-0.0234 -0.05788,-0.0372 -0.07855,-0.04 l -0.06615,-0.008 c -0.0124,0 -0.02067,-0.008 -0.02067,-0.0179 0,-0.0152 0.01378,-0.022 0.04134,-0.022 0.09371,0 0.194303,0.0193 0.327973,0.0634 0.121267,0.0386 0.188791,0.0537 0.248047,0.0537 0.184657,0 0.296278,-0.0965 0.296278,-0.25632 0,-0.0813 -0.02894,-0.1819 -0.07028,-0.24666 -0.03583,-0.0551 -0.09646,-0.113 -0.173633,-0.16261 -0.0124,-0.008 -0.02205,-0.0124 -0.03032,-0.0124 -0.0096,0 -0.01791,0.01 -0.01791,0.0193 l 0.0028,0.0482 0.0014,0.004 c 0,0.0179 -0.01102,0.0331 -0.0248,0.0331 -0.02067,0 -0.04134,-0.0234 -0.06477,-0.0744 -0.0689,-0.14469 -0.179146,-0.23151 -0.292144,-0.23151 -0.0248,0 -0.03859,0.008 -0.03859,0.0234 0,0.011 0.0069,0.0289 0.01929,0.0496 0.01102,0.0179 0.02343,0.04 0.03307,0.0661 0.0055,0.0138 0.0096,0.0248 0.0096,0.0317 0,0.007 -0.0069,0.011 -0.01791,0.011 -0.01653,0 -0.0441,-0.0152 -0.06201,-0.0344 -0.03721,-0.04 -0.05512,-0.0593 -0.05512,-0.0606 l -0.04823,-0.0744 c -0.03721,-0.0565 -0.07855,-0.0923 -0.148828,-0.12954 l -0.09233,-0.0482 c -0.01929,-0.01 -0.03583,-0.0152 -0.04823,-0.0152 -0.01103,0 -0.01653,0.007 -0.01653,0.0179 0,0.011 0.0055,0.0262 0.01653,0.0427 0.01929,0.0289 0.03445,0.0606 0.03445,0.073 0,0.0124 -0.0083,0.0234 -0.01929,0.0234 -0.02618,0 -0.07166,-0.0468 -0.137803,-0.1378 -0.04685,-0.0648 -0.07028,-0.13505 -0.07028,-0.20809 0,-0.15572 0.119889,-0.27698 0.274229,-0.27698 0.07993,0 0.179145,0.0331 0.278364,0.0923 l 0.177767,0.10748 c 0.06339,0.0386 0.150206,0.0661 0.202571,0.0661 0.03032,0 0.03858,-0.001 0.104731,-0.0179 0.01929,-0.006 0.03583,-0.011 0.04823,-0.0193 0.0083,-0.004 0.01378,-0.0124 0.01378,-0.0207 0,-0.0152 -0.0083,-0.022 -0.03169,-0.0234 -0.08268,-0.006 -0.254937,-0.073 -0.367937,-0.14469 -0.06477,-0.0413 -0.106108,-0.0648 -0.121267,-0.0703 -0.03169,-0.011 -0.05099,-0.0262 -0.05099,-0.04 0,-0.004 0.0055,-0.008 0.01516,-0.008 l 0.02205,0.004 0.161231,0.0593 0.155718,0.0551 c 0.07717,0.0276 0.195681,0.0524 0.249425,0.0524 0.07028,0 0.118511,-0.0482 0.118511,-0.11852 0,-0.0358 -0.0083,-0.0758 -0.02343,-0.10335 -0.02205,-0.0441 -0.05237,-0.0827 -0.06339,-0.0827 -0.01516,0 -0.02343,0.0152 -0.02343,0.04 l 0.0014,0.0193 0.0055,0.0482 c 0,0.0496 -0.02756,0.0827 -0.07028,0.0827 -0.01653,0 -0.03721,-0.004 -0.06063,-0.0124 l -0.241156,-0.0772 c -0.209462,-0.0675 -0.290766,-0.0854 -0.392741,-0.0854 -0.292144,0 -0.511252,0.19706 -0.511252,0.45888 0,0.2949 0.202571,0.48094 0.722092,0.66008 0.505739,0.17501 0.571885,0.21636 0.571885,0.34865 0,0.0772 -0.07166,0.1378 -0.16123,0.1378 -0.03307,0 -0.06339,-0.003 -0.08819,-0.007 -0.02067,-0.006 -0.104731,-0.0248 -0.250803,-0.0593 -0.155719,-0.0386 -0.286632,-0.0524 -0.461643,-0.0524 -0.367936,0 -0.544325,0.0551 -0.737251,0.23289 -0.0441,0.0413 -0.06201,0.0496 -0.111621,0.0496 l -0.0248,-0.001 -0.05788,-0.004 c -0.04548,0 -0.07855,0.0221 -0.104731,0.0675 l -0.05926,0.1006 c -0.0083,0.0138 -0.0248,0.022 -0.04272,0.022 -0.03858,0 -0.05926,-0.0262 -0.09508,-0.11576 -0.01929,-0.0469 -0.0441,-0.0854 -0.07441,-0.11024 l -0.07717,-0.0675 c -0.0124,-0.01 -0.01929,-0.0193 -0.01929,-0.0276 0,-0.007 0.0069,-0.0193 0.01929,-0.0344 0.01102,-0.0152 0.02205,-0.0331 0.03307,-0.0524 0.01102,-0.0207 0.01791,-0.0358 0.01791,-0.0455 l 0.0041,-0.0331 c 0.0028,-0.011 0.01378,-0.0179 0.02618,-0.0179 0.0248,0 0.02894,0.0165 0.03032,0.10749 0,0.0234 0.0096,0.0579 0.02894,0.1006 l 0.04134,0.0882 c 0.0041,0.0124 0.01791,0.0193 0.03307,0.0193 0.03858,0 0.08682,-0.0909 0.100596,-0.18603 0.0096,-0.0786 0.01791,-0.10335 0.03445,-0.10335 0.01516,0 0.02205,0.008 0.05374,0.0744 0.0096,0.0193 0.0248,0.0386 0.0441,0.0551 0.01791,0.0152 0.03445,0.0248 0.04548,0.0262 h 0.0028 c 0.03169,0 0.04134,-0.0193 0.04823,-0.0896 l 0.0041,-0.0372 -0.0069,-0.051 -0.0055,-0.0358 c 0,-0.0248 0.0083,-0.0386 0.02205,-0.0386 0.0083,0 0.01791,0.006 0.02756,0.0152 l 0.03721,0.0372 c 0.0248,0.0234 0.04961,0.0372 0.07441,0.0372 0.03169,0 0.05099,-0.0152 0.05099,-0.0372 0,-0.0193 -0.0041,-0.0276 -0.03721,-0.0827 -0.0028,-0.004 -0.01102,-0.0207 -0.02618,-0.0482 -0.03169,-0.062 -0.04685,-0.0772 -0.07579,-0.0772 l -0.03859,0.004 -0.04823,0.0179 c -0.01378,0.006 -0.0248,0.008 -0.02894,0.008 -0.0069,0 -0.0124,-0.007 -0.0124,-0.0152 0,-0.0331 0.02205,-0.0854 0.06339,-0.1502 0.02618,-0.04 0.04685,-0.14056 0.06339,-0.29215 l 0.01792,-0.17363 c 0.0124,-0.10749 0.02343,-0.14469 0.04548,-0.14469 0.0083,0 0.01378,0.003 0.01378,0.007 l 0.0124,0.0565 v 0.0441 c 0,0.0537 0.0055,0.0978 0.0124,0.0978 0.01516,0 0.03858,-0.0179 0.06063,-0.0496 0.01653,-0.022 0.02894,-0.0469 0.03721,-0.0744 0.0124,-0.0386 0.01929,-0.0717 0.01929,-0.0965 0,-0.0854 -0.03583,-0.12265 -0.152962,-0.15572 -0.01102,-0.003 -0.01929,-0.007 -0.02205,-0.011 l -0.0041,-0.0331 v -0.0634 l -0.0069,-0.0441 -0.01516,-0.0372 -0.01791,-0.04 -0.02894,0.0179 c -0.07579,0.0468 -0.09508,0.062 -0.119889,0.0923 -0.03307,0.0427 -0.04547,0.0537 -0.05926,0.0537 -0.0096,0 -0.01791,-0.007 -0.01791,-0.0165 l 0.01516,-0.0634 v -0.01 c 0,-0.0813 -0.04548,-0.15985 -0.126779,-0.21911 l -0.02618,0.0289 -0.02618,0.0372 -0.0441,0.0524 c -0.02618,0.0303 -0.04134,0.0716 -0.04134,0.10886 l 0.0014,0.0124 v 0.0124 c 0,0.0303 -0.0041,0.04 -0.01791,0.04 l -0.0083,-0.004 -0.03032,-0.0358 -0.03721,-0.0455 -0.06615,-0.04 -0.03307,-0.0262 c -0.03583,0.0772 -0.0372,0.0854 -0.0372,0.18603 v 0.0303 c 0,0.0331 -0.01103,0.0537 -0.02894,0.0537 -0.0096,0 -0.0248,-0.006 -0.04548,-0.0179 -0.01653,-0.01 -0.03583,-0.0152 -0.05512,-0.0152 -0.05374,0 -0.09371,0.0455 -0.09371,0.10887 0,0.0675 0.01516,0.11438 0.06063,0.18741 0.02894,0.0482 0.06615,0.0882 0.08406,0.0882 0.0028,0 0.0069,-0.0345 0.01102,-0.0799 l -0.01102,-0.0634 -0.0028,-0.0289 c 0,-0.0234 0.0096,-0.0386 0.02343,-0.0386 0.02067,0 0.03307,0.0234 0.04685,0.0854 l 0.02894,0.1378 0.03032,0.17363 c 0.0083,0.0469 0.02343,0.0978 0.0441,0.14883 0.02894,0.0703 0.05099,0.113 0.06339,0.12954 0.04134,0.0524 0.04548,0.0606 0.04548,0.0716 0,0.01 -0.0069,0.0179 -0.01654,0.0179 -0.0069,0 -0.01929,-0.004 -0.03307,-0.0124 -0.0124,-0.006 -0.02756,-0.011 -0.0441,-0.0138 l -0.02756,-0.004 c -0.06063,0 -0.07304,0.0496 -0.07304,0.2949 0,0.15434 0.03169,0.35829 0.07028,0.45751 l 0.07855,0.19706 c 0.0124,0.0303 0.01791,0.062 0.01791,0.0923 0,0.27147 -0.366558,0.70418 -0.752409,0.89021 -0.150206,0.0717 -0.194303,0.14745 -0.208083,0.3514 0.06477,-0.0303 0.09095,-0.04 0.130913,-0.051 0.108865,-0.0317 0.132292,-0.0469 0.14745,-0.0965 l 0.01516,-0.0482 c 0.0069,-0.0207 0.02067,-0.0317 0.09646,-0.0703 0.02894,-0.0152 0.04823,-0.0317 0.05926,-0.0482 0.01929,-0.0317 0.03445,-0.0482 0.0441,-0.0482 0.01102,0 0.01653,0.007 0.01653,0.0193 l -0.0014,0.007 -0.04134,0.10473 -0.0041,0.0262 c 0,0.0772 0.0441,0.14194 0.122645,0.18328 0.0055,-0.0193 0.0096,-0.0344 0.0124,-0.0441 0.0124,-0.0565 0.0248,-0.0937 0.03583,-0.11163 l 0.07166,-0.10335 c 0.0248,-0.0372 0.03032,-0.062 0.03032,-0.15847 l -0.0055,-0.11576 -0.0014,-0.0303 c 0,-0.0193 0.0083,-0.0289 0.02618,-0.0289 0.0124,0 0.02343,0.004 0.02343,0.011 l 0.01102,0.0703 c 0.0028,0.0152 0.01791,0.0262 0.03721,0.0262 0.03583,0 0.0813,-0.0455 0.129536,-0.12953 0.01929,-0.0331 0.02756,-0.0593 0.02756,-0.0896 0,-0.0234 -0.0055,-0.0744 -0.0124,-0.11438 l -0.0014,-0.0221 c 0,-0.0179 0.01102,-0.0303 0.02894,-0.0303 0.0083,0 0.01653,0.003 0.01791,0.007 l 0.0248,0.0854 c 0.0096,0.0289 0.02894,0.0482 0.04961,0.0482 0.0565,0 0.115756,-0.11575 0.121268,-0.24116 0.0041,-0.0772 0.01378,-0.10473 0.03721,-0.10473 0.0096,0 0.01653,0.003 0.01929,0.008 l 0.01378,0.0482 c 0.0055,0.0179 0.01653,0.0303 0.02618,0.0303 0.0096,0 0.02894,-0.0165 0.05237,-0.0441 0.0124,-0.0165 0.02343,-0.0317 0.03307,-0.0482 0.0069,-0.0138 0.01102,-0.0262 0.01102,-0.04 0,-0.0179 -0.0041,-0.0234 -0.03307,-0.0455 -0.02756,-0.0207 -0.04134,-0.0469 -0.04134,-0.0785 0,-0.0537 0.02343,-0.11162 0.08957,-0.226 0.06063,-0.10335 0.0689,-0.11576 0.08268,-0.11576 0.01516,0 0.0248,0.0138 0.0248,0.0317 0,0.011 -0.0028,0.022 -0.0069,0.0317 -0.01102,0.022 -0.01516,0.0372 -0.01516,0.0455 0,0.0138 0.0124,0.0262 0.02894,0.0262 0.01791,0 0.03996,-0.008 0.06752,-0.022 0.01516,-0.01 0.04961,-0.0234 0.09922,-0.0413 0.0689,-0.0248 0.111621,-0.04 0.12678,-0.0441 0.02205,-0.008 0.04961,-0.0124 0.07579,-0.0124 0.02205,0 0.04272,0.003 0.06477,0.008 0.04272,0.01 0.07166,0.0152 0.08544,0.0152 0.03307,0 0.05926,-0.0262 0.05926,-0.0593 0,-0.0138 -0.0096,-0.0427 -0.02205,-0.0634 -0.01929,-0.0317 -0.03032,-0.0482 -0.03445,-0.0524 -0.01516,-0.0165 -0.02205,-0.0262 -0.02205,-0.0331 l 0.0041,-0.0152 c 0.0041,-0.008 0.0124,-0.0152 0.02067,-0.0152 0.02894,0 0.08682,0.0606 0.139182,0.1447 0.290766,0.47542 0.431326,0.62563 0.644922,0.6904 0.221864,0.0675 0.27423,0.11437 0.27423,0.24667 0,0.0703 -0.03721,0.15571 -0.114378,0.26458 -0.148828,0.20533 -0.201193,0.32659 -0.201193,0.46302 v 0.0303 c 0.01791,-0.008 0.03169,-0.0138 0.04134,-0.0193 0.03032,-0.0152 0.04961,-0.0234 0.05926,-0.0248 l 0.09233,-0.0193 c 0.02894,-0.006 0.05237,-0.04 0.05237,-0.0772 v -0.008 l -0.0083,-0.0813 v -0.0124 c 0,-0.0468 0.02205,-0.0841 0.04961,-0.0841 0.01102,0 0.02343,0.01 0.02894,0.022 l 0.05926,0.12678 c 0.0248,0.051 0.05236,0.0758 0.129535,0.11024" style="fill:#fddc02;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path217" d="m -63.563194,113.08574 -0.0041,0.0593 v 0.0358 c 0,0.0606 0.0096,0.0868 0.03169,0.0868 0.0248,0 0.06339,-0.0469 0.07993,-0.0965 0.01102,-0.0317 0.01929,-0.0758 0.01929,-0.1006 0,-0.0179 -0.0041,-0.0345 -0.01929,-0.0703 -0.01653,-0.04 -0.03307,-0.0592 -0.05374,-0.0592 -0.03169,0 -0.04685,0.0413 -0.05374,0.14469" style="fill:#fddc02;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path219" d="m -63.852582,112.36227 0.0014,0.0331 c 0,0.0331 -0.01102,0.0965 -0.02618,0.15709 -0.01516,0.0524 -0.02205,0.0799 -0.02343,0.0854 -0.0041,0.0207 -0.0069,0.0441 -0.0069,0.0662 0,0.0524 0.0248,0.10197 0.06339,0.12126 l 0.03996,0.0234 0.0083,0.0524 c -0.0014,0.0193 0.0014,0.0469 0.01102,0.0813 0.0096,0.0372 0.01516,0.0744 0.01516,0.11162 0,0.0303 -0.0028,0.0427 -0.0096,0.0427 -0.01378,0 -0.03859,-0.0386 -0.06063,-0.0951 -0.03721,-0.0896 -0.0689,-0.12265 -0.118511,-0.12265 -0.04134,0 -0.06752,0.006 -0.115755,0.0289 0.03858,0.051 0.06201,0.0923 0.107487,0.19292 0.05926,0.1323 0.0813,0.15848 0.173633,0.20395 0.02067,0.011 0.03445,0.0234 0.03445,0.0345 0,0.0179 -0.01378,0.0289 -0.03307,0.0289 -0.0083,0 -0.03307,-0.003 -0.05237,-0.007 l -0.02756,-0.003 c -0.01378,0 -0.02067,0.0124 -0.02067,0.0413 0,0.0992 0.08406,0.21773 0.221864,0.31695 0.01929,0.0138 0.03032,0.0276 0.03032,0.0372 0,0.007 -0.0041,0.0124 -0.0124,0.0179 -0.0055,0.006 -0.0124,0.008 -0.01929,0.008 -0.0069,0 -0.0248,-0.007 -0.04272,-0.0152 -0.01102,-0.006 -0.02067,-0.008 -0.02756,-0.008 -0.01791,0 -0.02894,0.0165 -0.02894,0.0427 0,0.0345 0.0248,0.0937 0.06752,0.16123 0.03996,0.0634 0.08268,0.10611 0.122645,0.12265 l 0.166743,0.0703 c 0.0083,0.004 0.01516,0.0124 0.01516,0.022 0,0.0124 -0.0096,0.0234 -0.02343,0.0262 l -0.02894,0.004 -0.03307,0.004 -0.04548,-0.004 h -0.0069 c -0.02343,0 -0.03169,0.004 -0.03169,0.0165 0,0.0179 0.01653,0.0551 0.05374,0.11989 0.04134,0.0717 0.07028,0.10473 0.09233,0.10473 0.0083,0 0.01654,-0.007 0.02343,-0.0193 l 0.03996,-0.0854 c 0.0055,-0.011 0.03858,-0.0358 0.09646,-0.073 0.03445,-0.0234 0.07028,-0.0372 0.103353,-0.0413 0.08957,-0.011 0.09784,-0.0165 0.09784,-0.0524 0,-0.0138 -0.0041,-0.0386 -0.0124,-0.073 -0.0028,-0.0193 -0.0069,-0.0455 -0.01102,-0.0786 l -0.0069,-0.0703 -0.0083,-0.0813 c 0,-0.0207 -0.0055,-0.0303 -0.01791,-0.0303 -0.0083,0 -0.02067,0.011 -0.02894,0.0262 -0.0441,0.0717 -0.108865,0.11852 -0.159853,0.11852 -0.208083,0 -0.348643,-0.32936 -0.348643,-0.81442 l 0.0028,-0.1447 0.0124,-0.17501 0.0014,-0.062 c 0,-0.14883 -0.05237,-0.30317 -0.128157,-0.37896 l -0.05099,-0.0524 -0.03445,-0.0372" style="fill:#fddc02;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path221" d="m -63.374402,115.07287 c -0.07717,-0.0138 -0.08957,-0.0165 -0.177767,-0.0551 -0.06063,-0.0276 -0.09922,-0.0386 -0.139182,-0.0386 -0.05788,0 -0.103353,0.0193 -0.157097,0.0634 l 0.03307,0.0262 0.07442,0.0524 0.07028,0.0551 c 0.01791,0.0152 0.03996,0.022 0.06339,0.022 0.07166,0 0.13367,-0.0331 0.232889,-0.12541" style="fill:#fddc02;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path223" d="m -61.946755,115.74811 c 0.02067,-0.0468 0.03032,-0.0592 0.07441,-0.0965 0.103353,-0.0896 0.151584,-0.15572 0.151584,-0.20808 v -0.0813 c 0,-0.0482 0.0083,-0.0634 0.03307,-0.0634 0.01102,0 0.02067,0.004 0.02343,0.011 l 0.01791,0.0441 c 0.0041,0.011 0.01653,0.0165 0.03169,0.0165 0.02618,0 0.04548,-0.0193 0.09095,-0.0937 0.01929,-0.0317 0.02756,-0.0524 0.02756,-0.073 0,-0.0138 -0.0041,-0.0276 -0.0096,-0.0427 -0.0028,-0.007 -0.01102,-0.0262 -0.02618,-0.0593 -0.0083,-0.0193 -0.01516,-0.0441 -0.01516,-0.0579 0,-0.0234 0.0124,-0.0386 0.03445,-0.0386 0.0096,0 0.02067,0.004 0.02618,0.0124 l 0.02894,0.0358 c 0.0069,0.008 0.0083,0.0138 0.01929,0.0138 0.01378,0 0.03859,-0.0138 0.04823,-0.0317 l 0.02894,-0.0593 c 0.0083,-0.0152 0.01103,-0.0262 0.01103,-0.0345 0,-0.011 -0.01103,-0.0248 -0.02894,-0.0317 l -0.05237,-0.0234 c -0.06063,-0.0262 -0.111621,-0.12954 -0.111621,-0.23013 0,-0.01 0.0041,-0.0262 0.01102,-0.0469 l 0.02343,-0.0634 c 0.0069,-0.0207 0.01102,-0.0413 0.01102,-0.062 0,-0.0358 -0.0124,-0.0703 -0.03721,-0.113 -0.02618,-0.0413 -0.04134,-0.0675 -0.04547,-0.0772 -0.02067,-0.0551 -0.03307,-0.073 -0.05237,-0.073 -0.0124,0 -0.0248,0.004 -0.04685,0.0179 l -0.03721,0.0221 -0.05237,0.0592 -0.05099,0.0248 c -0.0317,0.0165 -0.06064,0.0841 -0.06064,0.13918 0,0.0799 0.01653,0.12403 0.137804,0.34038 0.05099,0.0909 0.07579,0.15847 0.07579,0.21084 0,0.1502 -0.15434,0.2756 -0.405143,0.32659 -0.300413,0.0606 -0.366558,0.11025 -0.401009,0.30317 0.05237,-0.0262 0.07304,-0.0303 0.163986,-0.0303 l 0.05512,10e-4 h 0.0083 c 0.04961,0 0.0565,-0.004 0.08819,-0.0482 0.03583,-0.051 0.07166,-0.0827 0.121268,-0.10336 l 0.06063,-0.0262 0.04685,-0.0262 0.01516,-0.004 c 0.01378,0 0.02067,0.006 0.02067,0.0152 0,0.0138 -0.01102,0.0344 -0.03583,0.0634 -0.03445,0.0427 -0.05512,0.0882 -0.05512,0.12127 0,0.0496 0.0069,0.0758 0.03721,0.11989" style="fill:#fddc02;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path225" d="m -62.41391,115.17209 c 0.04272,0.0276 0.08544,0.0662 0.111622,0.1006 0.03583,0.0482 0.03996,0.0524 0.07579,0.0524 0.01378,0 0.03307,-0.003 0.05374,-0.008 l 0.03307,-0.007 c 0.06339,-0.0124 0.08268,-0.0207 0.08268,-0.0386 0,-0.01 -0.0055,-0.0193 -0.01516,-0.0276 l -0.04548,-0.0372 -0.03996,-0.0372 c -0.0248,-0.0234 -0.07717,-0.0414 -0.117133,-0.0414 -0.04685,0 -0.08406,0.0124 -0.139182,0.0441" style="fill:#fddc02;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path227" d="m -61.212261,115.37329 0.02205,-0.004 0.03721,-0.004 0.03032,0.004 0.01929,10e-4 c 0.03721,0 0.0565,-0.004 0.07304,-0.0165 0.02205,-0.0165 0.04548,-0.0455 0.07028,-0.0841 0.0096,-0.0165 0.01516,-0.0317 0.01516,-0.0427 0,-0.0248 -0.02343,-0.04 -0.06477,-0.04 -0.101974,0 -0.163986,0.0565 -0.202571,0.18604" style="fill:#fddc02;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path229" d="m -67.800661,123.20606 0.02205,-0.0441 0.05236,-0.0551 c 0.0441,-0.0482 0.06752,-0.11438 0.06752,-0.19293 0,-0.0372 -0.0069,-0.0786 -0.01929,-0.11851 -0.0096,-0.0303 -0.01516,-0.0551 -0.01516,-0.0662 0,-0.0234 0.01791,-0.0455 0.03583,-0.0455 0.0069,0 0.01792,0.007 0.02756,0.0179 l 0.05512,0.0634 c 0.03445,0.0386 0.04685,0.0469 0.08957,0.0551 l 0.0041,-0.051 0.0028,-0.0606 c 0,-0.0896 -0.03169,-0.18879 -0.0813,-0.2508 -0.02894,-0.0386 -0.04272,-0.0606 -0.04272,-0.0744 0,-0.0138 0.0096,-0.0262 0.02067,-0.0262 0.0028,0 0.0083,0.003 0.01516,0.008 0.03583,0.0262 0.05374,0.0372 0.06339,0.0372 0.01791,0 0.03445,-0.0441 0.03445,-0.0937 0,-0.0703 -0.03032,-0.15158 -0.07579,-0.20808 -0.02343,-0.0276 -0.03858,-0.0469 -0.0441,-0.0551 -0.0055,-0.007 -0.0083,-0.0138 -0.0083,-0.0207 0,-0.0165 0.01378,-0.0276 0.03307,-0.0276 0.01378,0 0.02205,0.004 0.04547,0.0193 0.01103,0.007 0.02067,0.011 0.02756,0.011 0.02894,0 0.03996,-0.0413 0.03996,-0.15158 l -0.0014,-0.0455 -0.0041,-0.0661 c -0.0041,-0.0785 -0.01102,-0.0923 -0.0441,-0.0923 h -0.02894 c -0.180522,0 -0.265961,-0.11576 -0.311436,-0.42306 -0.03445,-0.22324 -0.117133,-0.38172 -0.219108,-0.41617 -0.06063,-0.0193 -0.08268,-0.0331 -0.08268,-0.0496 0,-0.01 0.01654,-0.0207 0.03583,-0.0207 0.0124,0 0.0441,0.008 0.0689,0.0193 0.148828,0.0593 0.272852,0.0896 0.381717,0.0896 0.177767,0 0.316949,-0.13091 0.316949,-0.29766 0,-0.12677 -0.06063,-0.25493 -0.168121,-0.35966 -0.03032,-0.0289 -0.06201,-0.0469 -0.09371,-0.0551 l -0.0055,-0.001 -0.01929,0.007 0.0069,0.0537 0.01516,0.0372 0.0041,0.0152 c 0,0.008 -0.0083,0.0138 -0.01791,0.0138 -0.01102,0 -0.02067,-0.006 -0.02756,-0.0138 l -0.06615,-0.1006 c -0.05236,-0.0786 -0.169495,-0.14607 -0.254934,-0.14607 -0.03032,0 -0.04961,0.0138 -0.04961,0.0358 0,0.011 0.0096,0.0289 0.02343,0.0427 0.01791,0.022 0.03307,0.0482 0.03307,0.0593 l -0.0041,0.0152 c -0.0041,0.008 -0.0096,0.0138 -0.01516,0.0152 h -0.0041 c -0.01791,0 -0.02618,-0.008 -0.106109,-0.0992 -0.06615,-0.0758 -0.201194,-0.14883 -0.27423,-0.14883 -0.0096,0 -0.01929,0.004 -0.02618,0.011 -0.0055,0.004 -0.0083,0.01 -0.0083,0.0138 0,0.011 0.0096,0.0262 0.02618,0.0413 0.02343,0.022 0.04134,0.0468 0.04134,0.0565 0,0.008 -0.0096,0.0152 -0.02067,0.0152 -0.02205,0 -0.0689,-0.0317 -0.157096,-0.10059 -0.139182,-0.10887 -0.201194,-0.21084 -0.201194,-0.33073 0,-0.14332 0.103353,-0.25632 0.234267,-0.25632 0.07579,0 0.177767,0.0372 0.248047,0.0896 l 0.181901,0.13781 c 0.08268,0.062 0.184657,0.0965 0.290766,0.0965 0.02343,0 0.04547,-0.006 0.06477,-0.0152 0.01654,-0.008 0.02618,-0.0179 0.02618,-0.0248 0,-0.006 -0.01378,-0.011 -0.03307,-0.0165 -0.06615,-0.0151 -0.118512,-0.0386 -0.155719,-0.0661 l -0.186036,-0.14056 c -0.0689,-0.0524 -0.117133,-0.0868 -0.144694,-0.1006 -0.09784,-0.051 -0.117133,-0.0634 -0.117133,-0.0744 0,-0.006 0.0096,-0.011 0.02205,-0.011 0.0096,0 0.02067,0.003 0.03169,0.008 l 0.09646,0.04 c 0.03169,0.0138 0.08406,0.0441 0.157096,0.0923 0.19706,0.13367 0.299035,0.17639 0.41479,0.17639 0.111621,0 0.192926,-0.0799 0.192926,-0.18604 0,-0.0207 -0.0055,-0.0441 -0.01516,-0.0634 l -0.01929,-0.0372 c -0.0055,-0.0138 -0.01791,-0.0234 -0.02205,-0.0193 l -0.01103,0.0152 -0.01102,0.0785 c 0,0.003 -0.0041,0.011 -0.01102,0.0262 -0.0069,0.0138 -0.01653,0.0262 -0.02618,0.0358 -0.01929,0.0207 -0.03721,0.0262 -0.06752,0.0262 -0.05788,0 -0.122645,-0.0303 -0.296277,-0.14056 -0.175011,-0.11162 -0.333486,-0.17088 -0.458887,-0.17088 -0.26734,0 -0.482314,0.21497 -0.482314,0.48094 0,0.37207 0.227377,0.53881 0.938444,0.69453 0.270096,0.0593 0.388607,0.1378 0.388607,0.25769 0,0.11024 -0.08819,0.17915 -0.228754,0.17915 -0.04272,0 -0.07579,-0.001 -0.100597,-0.007 -0.02343,-0.004 -0.151584,-0.04 -0.381716,-0.10336 -0.159853,-0.0441 -0.33762,-0.0703 -0.494716,-0.0703 -0.279742,0 -0.467155,0.0841 -0.595313,0.26183 -0.01516,0.0221 -0.03032,0.0345 -0.03996,0.0345 -0.0069,0 -0.01791,-0.006 -0.03032,-0.0152 l -0.05236,-0.0413 c -0.03583,-0.0276 -0.09371,-0.0496 -0.132292,-0.0496 -0.02894,0 -0.05512,0.011 -0.07855,0.0317 -0.01929,0.0165 -0.03307,0.0262 -0.03858,0.0262 -0.02067,0 -0.05788,-0.0469 -0.08819,-0.10749 -0.04134,-0.0868 -0.06339,-0.17363 -0.06339,-0.25218 0,-0.0372 0.0124,-0.0634 0.02894,-0.0634 0.0124,0 0.02205,0.01 0.02756,0.0303 l 0.02894,0.10748 c 0.01653,0.0593 0.05099,0.10749 0.07579,0.10749 0.0124,0 0.03169,-0.0165 0.05512,-0.0455 0.01378,-0.0165 0.02343,-0.0345 0.02894,-0.051 0.02343,-0.0689 0.02894,-0.0785 0.04685,-0.0785 0.02205,0 0.03307,0.0138 0.04823,0.0813 0.0028,0.0124 0.0069,0.0317 0.02343,0.0634 0.01516,0.0289 0.03032,0.051 0.0441,0.0675 0.0124,0.0124 0.02618,0.0193 0.03858,0.0193 0.03307,0 0.06339,-0.0551 0.06339,-0.11438 l -0.0014,-0.0165 -0.0041,-0.0689 c 0,-0.0262 0.0041,-0.0345 0.01929,-0.0345 0.0083,0 0.01516,0.004 0.02618,0.0179 0.01516,0.0207 0.03721,0.0386 0.06201,0.0524 0.02343,0.011 0.04134,0.0179 0.05374,0.0179 0.01102,0 0.02343,-0.007 0.03583,-0.0179 0.0096,-0.01 0.01516,-0.0207 0.01516,-0.0303 0,-0.01 -0.0124,-0.0276 -0.05237,-0.0662 -0.02067,-0.022 -0.04685,-0.073 -0.07441,-0.14883 -0.0096,-0.0289 -0.02343,-0.0482 -0.03445,-0.0482 -0.0028,0 -0.01102,0.003 -0.0248,0.008 l -0.04823,0.0179 -0.03307,0.0152 -0.0124,0.003 c -0.01654,0 -0.02894,-0.011 -0.02894,-0.0262 0,-0.0138 0.03445,-0.0537 0.07441,-0.0882 0.03032,-0.0248 0.04685,-0.0606 0.04823,-0.1006 0.0028,-0.062 0.01378,-0.11024 0.02618,-0.11024 l 0.01102,-0.12954 c 0.0055,-0.0661 0.03169,-0.18879 0.0565,-0.25631 0.0041,-0.0138 0.0096,-0.022 0.01378,-0.022 0.01103,0 0.01929,0.0276 0.01929,0.0579 v 0.0193 l -0.0028,0.0372 c 0,0.0482 0.0083,0.0716 0.02205,0.0716 0.01653,0 0.03445,-0.0234 0.05099,-0.0648 l 0.03307,-0.0841 c 0.0096,-0.0262 0.01516,-0.0496 0.01516,-0.0703 0,-0.0717 -0.0441,-0.12403 -0.103353,-0.12403 l -0.02618,0.004 c -0.01516,0.006 -0.02343,0.008 -0.02618,0.008 -0.02067,0 -0.03721,-0.022 -0.03721,-0.0469 l 0.0041,-0.0537 -0.0041,-0.0744 -0.01516,-0.0772 -0.0041,-0.0372 -0.03307,0.0179 -0.03996,0.0345 -0.05926,0.0482 -0.04823,0.04 c -0.0083,0.007 -0.01929,0.011 -0.02756,0.011 -0.02894,0 -0.03307,-0.007 -0.03307,-0.0648 l 0.0014,-0.0152 c 0,-0.0455 -0.02067,-0.0827 -0.09646,-0.17226 -0.0041,-0.004 -0.01102,-0.0124 -0.01929,-0.022 l -0.01378,0.0262 -0.04134,0.0661 -0.04134,0.10473 -0.0069,0.0662 c -0.0028,0.0193 -0.0096,0.0344 -0.01791,0.0344 -0.0069,0 -0.01929,-0.01 -0.03445,-0.0262 -0.0565,-0.0648 -0.07441,-0.0772 -0.158475,-0.10749 l -0.0083,0.0262 c -0.0124,0.0427 -0.02067,0.0689 -0.02205,0.0772 l -0.0041,0.0703 v 0.0537 c 0,0.0193 -0.0069,0.0317 -0.01929,0.0317 h -0.0028 c -0.0014,0 -0.0083,-0.007 -0.02205,-0.0193 -0.0083,-0.007 -0.0248,-0.011 -0.0441,-0.011 -0.07028,0 -0.114377,0.0372 -0.114377,0.0965 0,0.0441 0.01654,0.0772 0.08406,0.1819 0.03032,0.0468 0.06477,0.0827 0.07993,0.0827 0.0083,0 0.01653,-0.0248 0.01653,-0.0537 l -0.0069,-0.0441 c -0.0069,-0.0207 -0.01103,-0.04 -0.01103,-0.0565 0,-0.0207 0.0069,-0.0317 0.01791,-0.0317 0.03307,0 0.06752,0.0965 0.08131,0.23013 l 0.01516,0.13642 c 0.0055,0.0496 0.02067,0.0992 0.0441,0.14883 0.03445,0.0689 0.06752,0.11576 0.09784,0.13643 0.03445,0.0248 0.0565,0.0496 0.0565,0.0634 0,0.0124 -0.0096,0.0221 -0.01929,0.0221 -0.0014,0 -0.02618,-0.008 -0.07579,-0.0262 l -0.03032,-0.004 c -0.07441,0 -0.09922,0.0427 -0.09922,0.1695 0,0.15434 0.103353,0.3762 0.219108,0.46853 l 0.170877,0.1378 c 0.08682,0.0689 0.151584,0.18466 0.151584,0.26734 0,0.10749 -0.118511,0.21498 -0.322461,0.28801 l -0.122645,0.0455 c -0.09509,0.0345 -0.132291,0.0951 -0.170877,0.27423 0.04961,-0.0152 0.07028,-0.0193 0.103353,-0.0193 h 0.01654 l 0.05512,0.001 c 0.04961,0 0.08544,-0.0289 0.08544,-0.0717 v -0.0331 c 0,-0.01 0.01378,-0.0234 0.03307,-0.0331 0.03307,-0.0165 0.05099,-0.0248 0.05236,-0.0262 l 0.03996,-0.0331 c 0.0069,-0.006 0.01378,-0.008 0.02067,-0.008 0.0124,0 0.02067,0.01 0.02067,0.0221 0,0.01 -0.0028,0.022 -0.0069,0.0344 -0.01378,0.0331 -0.02067,0.0772 -0.02067,0.12678 0,0.0909 0.01516,0.14056 0.06063,0.20671 0.0041,-0.0248 0.0083,-0.0413 0.01102,-0.0482 0.0083,-0.0193 0.02894,-0.0524 0.06339,-0.1006 0.0565,-0.0786 0.09784,-0.17363 0.09784,-0.22462 l -0.0014,-0.0165 -0.01102,-0.0854 c 0,-0.0152 0.0069,-0.0289 0.01791,-0.04 0.0083,-0.007 0.01791,-0.011 0.02618,-0.011 0.01516,0 0.0248,0.01 0.03721,0.0372 0.0083,0.0207 0.01929,0.0331 0.02618,0.0331 0.01378,0 0.03858,-0.0345 0.05512,-0.0744 0.0124,-0.0289 0.01929,-0.0565 0.01929,-0.0786 0,-0.0138 -0.0041,-0.0289 -0.01103,-0.0469 -0.0083,-0.0193 -0.0124,-0.0331 -0.0124,-0.0427 0,-0.01 0.0028,-0.0138 0.01516,-0.0248 0.0069,-0.004 0.0124,-0.007 0.01929,-0.007 0.0069,0 0.01516,0.003 0.02205,0.007 l 0.03307,0.0221 c 0.01103,0.008 0.02205,0.0124 0.02894,0.0124 0.01516,0 0.03721,-0.0165 0.05236,-0.0413 0.03307,-0.0496 0.05237,-0.091 0.05237,-0.10611 0,-0.01 -0.0055,-0.0165 -0.02618,-0.0317 -0.07441,-0.051 -0.122645,-0.13091 -0.122645,-0.19706 0,-0.0165 0.0041,-0.0344 0.01102,-0.0551 l 0.03721,-0.0992 c 0.01929,-0.051 0.02894,-0.0772 0.03032,-0.0786 l 0.01103,-0.004 c 0.0124,0 0.01929,0.011 0.01929,0.0289 0,0.0124 -0.0028,0.0262 -0.0083,0.0427 -0.0096,0.0234 -0.01516,0.0538 -0.01516,0.0703 0,0.0262 0.01378,0.04 0.03858,0.04 0.01791,0 0.03859,-0.004 0.06201,-0.0138 0.111621,-0.0482 0.201194,-0.0744 0.253559,-0.0744 0.05099,0 0.08268,0.011 0.135048,0.0482 0.01378,0.01 0.02618,0.0152 0.03445,0.0152 0.0069,0 0.01516,-0.006 0.02205,-0.0152 0.0041,-0.007 0.0069,-0.0138 0.0069,-0.0193 0,-0.0124 -0.0083,-0.0303 -0.02205,-0.0468 -0.01929,-0.0248 -0.02618,-0.0386 -0.02618,-0.0538 0,-0.011 0.0069,-0.0179 0.02067,-0.0179 0.05788,0 0.148828,0.18328 0.235645,0.47542 0.06752,0.23014 0.08682,0.25218 0.307302,0.37759 0.186035,0.10473 0.256315,0.20946 0.256315,0.37896 0,0.16674 -0.04548,0.37896 -0.141938,0.6587 -0.03032,0.0896 -0.04272,0.14883 -0.04272,0.19844 0,0.0386 0.0069,0.0772 0.03583,0.17638 0.01378,0.0482 0.02205,0.0758 0.02618,0.0854 0.0041,0.011 0.01378,0.0289 0.02894,0.0551" style="fill:#fddc02;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path231" d="m -68.660557,122.68791 c 0.02205,-0.051 0.02894,-0.0634 0.07028,-0.12678 0.06063,-0.091 0.0813,-0.1378 0.0813,-0.1819 v -0.0593 c 0,-0.0551 0.01103,-0.0813 0.03307,-0.0813 0.0083,0 0.01516,0.004 0.01929,0.011 l 0.01929,0.0303 c 0.0055,0.01 0.01516,0.0152 0.02618,0.0152 0.01103,0 0.03032,-0.0152 0.04134,-0.0317 0.02618,-0.04 0.04272,-0.0923 0.04272,-0.13229 l -0.0041,-0.04 -0.0028,-0.0427 c 0,-0.022 0.0096,-0.0317 0.03032,-0.0317 0.01378,0 0.02067,0.006 0.03307,0.0331 0.0083,0.0179 0.01791,0.0303 0.02756,0.0303 0.0096,0 0.02205,-0.01 0.03169,-0.0234 l 0.02894,-0.0441 0.02205,-0.0331 0.0055,-0.0179 c 0,-0.011 -0.0069,-0.0207 -0.02756,-0.0345 -0.0689,-0.0496 -0.09784,-0.1254 -0.103353,-0.26321 -0.0041,-0.10473 -0.0096,-0.17225 -0.01929,-0.20395 -0.0014,-0.007 -0.02343,-0.0606 -0.06614,-0.15985 -0.01654,-0.0386 -0.03169,-0.0827 -0.0441,-0.13229 -0.0096,-0.0345 -0.02067,-0.0455 -0.04685,-0.0455 -0.100597,0 -0.176389,0.0868 -0.176389,0.19982 0,0.0675 0.02756,0.17225 0.07855,0.30179 0.07166,0.17915 0.08957,0.24391 0.08957,0.3073 0,0.13643 -0.05374,0.19568 -0.242535,0.26321 -0.212224,0.0758 -0.311443,0.18465 -0.347272,0.38171 0.01653,-0.007 0.02894,-0.011 0.03583,-0.0152 0.0248,-0.01 0.04134,-0.0152 0.05237,-0.0179 l 0.05925,-0.0152 c 0.05099,-0.0124 0.09233,-0.0413 0.100597,-0.0703 l 0.01516,-0.0524 c 0.0028,-0.0124 0.0096,-0.0207 0.02205,-0.0262 l 0.03307,-0.0138 0.03307,-0.0152 0.0083,0.0152 -0.01516,0.0469 c -0.0055,0.0165 -0.0083,0.0455 -0.0083,0.0868 0,0.0813 0.01653,0.12954 0.06339,0.18879" style="fill:#fddc02;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path233" d="m -70.651822,119.25798 c 0.0055,0.0207 0.0083,0.0344 0.0083,0.0413 0,0.0124 -0.0055,0.0441 -0.01516,0.0965 l -0.0069,0.0758 c 0,0.0648 0.0124,0.13643 0.03307,0.19431 0.01929,0.0537 0.02343,0.0703 0.02343,0.0854 l -0.0014,0.0152 c -0.0028,0.0152 -0.0096,0.0262 -0.01378,0.0262 -0.0069,0 -0.02067,-0.008 -0.03858,-0.0234 -0.04134,-0.0372 -0.08819,-0.0551 -0.136426,-0.0551 -0.01516,0 -0.03721,0.003 -0.06339,0.007 l 0.01929,0.0413 0.05512,0.1378 0.07717,0.11851 0.08268,0.0551 c 0.0069,0.006 0.01516,0.0124 0.02205,0.0221 0.0069,0.011 0.01103,0.0193 0.01103,0.0248 0,0.007 -0.0069,0.0124 -0.01516,0.0124 l -0.07441,0.004 c -0.01102,0 -0.01929,0.007 -0.01929,0.0152 0,0.0124 0.0096,0.0496 0.03032,0.11025 l 0.03721,0.10748 0.06339,0.0593 0.06615,0.0482 c 0.02067,0.0138 0.03169,0.0303 0.03169,0.0427 0,0.01 -0.0055,0.0193 -0.0124,0.0207 l -0.03721,0.004 c -0.0124,0.001 -0.01929,0.011 -0.01929,0.0289 0,0.0276 0.02618,0.0786 0.07441,0.1447 0.05788,0.0785 0.09784,0.10335 0.163987,0.10335 h 0.05512 c 0.02618,0 0.04272,0.0138 0.04272,0.0344 0,0.0179 -0.01103,0.0276 -0.03583,0.0331 -0.05099,0.011 -0.06615,0.0207 -0.06615,0.0441 0,0.01 0.0069,0.0248 0.01929,0.0413 l 0.02894,0.04 c 0.0248,0.0345 0.05236,0.0565 0.07028,0.0565 0.0096,0 0.03307,-0.01 0.05374,-0.0345 0.03307,-0.0372 0.07166,-0.0689 0.119889,-0.0813 0.129536,-0.0317 0.155719,-0.0455 0.155719,-0.0758 0,-0.01 -0.0041,-0.0248 -0.01378,-0.0427 -0.04134,-0.073 -0.0565,-0.12127 -0.0565,-0.1819 0,-0.0455 -0.01102,-0.0772 -0.02894,-0.0772 -0.0069,0 -0.01791,0.011 -0.03032,0.0289 -0.03032,0.0469 -0.0813,0.0786 -0.129536,0.0786 -0.128157,0 -0.282497,-0.19981 -0.359667,-0.46715 -0.01792,-0.062 -0.02756,-0.13229 -0.02756,-0.19982 0,-0.0703 0.0096,-0.14745 0.02756,-0.22737 0.0248,-0.10749 0.03858,-0.16813 0.04134,-0.18053 l 0.0041,-0.051 c 0,-0.0923 -0.08406,-0.20947 -0.216352,-0.30179" style="fill:#fddc02;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path235" d="m -70.384483,119.77336 c -0.02756,0.0524 -0.05236,0.16812 -0.05236,0.24116 0,0.0441 0.01516,0.0772 0.03307,0.0772 0.0055,0 0.01378,-0.007 0.01929,-0.0179 l 0.04134,-0.0744 c 0.0069,-0.0124 0.01378,-0.0248 0.02618,-0.0455 0.01516,-0.0221 0.02618,-0.0427 0.02618,-0.0551 0,-0.0427 -0.04134,-0.0978 -0.09371,-0.1254" style="fill:#fddc02;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path237" d="m -69.976583,121.44492 c 0.0083,0.01 0.01516,0.0152 0.01929,0.0193 0.01516,0.0152 0.0248,0.0262 0.02894,0.0289 0.07304,0.0758 0.08268,0.0827 0.118512,0.0827 0.03169,0 0.09922,-0.0179 0.137804,-0.0372 0.01516,-0.008 0.0248,-0.0179 0.0248,-0.0262 0,-0.004 -0.0124,-0.0193 -0.03583,-0.0413 l -0.04134,-0.0372 c -0.03032,-0.0276 -0.07717,-0.0537 -0.09784,-0.0537 -0.04272,0 -0.08682,0.0193 -0.15434,0.0648" style="fill:#fddc02;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path239" d="m -69.116688,122.11603 c 0.03996,0.0165 0.05374,0.0234 0.07442,0.0372 0.03307,0.0221 0.05236,0.0345 0.05925,0.0372 0.01103,0.006 0.03169,0.008 0.05926,0.008 0.01653,0 0.03169,-0.003 0.0441,-0.008 l 0.07855,-0.0289 0.07441,-0.0262 c 0.01929,-0.007 0.03307,-0.0179 0.03307,-0.0289 0,-0.006 -0.01654,-0.0138 -0.04134,-0.0193 -0.01653,-0.004 -0.03445,-0.011 -0.05512,-0.0193 -0.09095,-0.0358 -0.104731,-0.0413 -0.136426,-0.0413 -0.07304,0 -0.146072,0.0358 -0.19017,0.0896" style="fill:#fddc02;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path241" d="m -68.178243,122.86155 c 0.0248,-0.0593 0.04134,-0.0689 0.125401,-0.0744 0.09508,-0.006 0.186035,-0.17501 0.186035,-0.29076 0,-0.011 -0.0041,-0.0207 -0.0083,-0.0207 -0.0055,0 -0.01378,0.004 -0.0248,0.011 -0.02756,0.0179 -0.04548,0.0289 -0.0565,0.0344 l -0.107487,0.0482 c -0.07166,0.0317 -0.13367,0.12678 -0.13367,0.20258 0,0.0248 0.0041,0.0469 0.01929,0.0896" style="fill:#fddc02;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path243" d="m -61.420344,121.97547 0.01516,-0.04 0.01516,-0.0524 c 0.0028,-0.01 0.01653,-0.0317 0.03996,-0.0634 0.03721,-0.0496 0.0565,-0.11162 0.0565,-0.18466 0,-0.0221 -0.0055,-0.0441 -0.01929,-0.0703 -0.0069,-0.0152 -0.01102,-0.0276 -0.01102,-0.0358 0,-0.004 0.0028,-0.011 0.0069,-0.0165 0.0055,-0.007 0.01102,-0.011 0.01516,-0.011 l 0.0028,-0.001 c 0.0096,0 0.02618,0.011 0.03858,0.0262 0.01516,0.0193 0.02894,0.0303 0.03721,0.0303 0.01654,0 0.03445,-0.0276 0.0441,-0.0703 0.0055,-0.0221 0.0069,-0.0345 0.0069,-0.0372 0,-0.0179 -0.01378,-0.0648 -0.03307,-0.10335 -0.0069,-0.0152 -0.01102,-0.0276 -0.01102,-0.0386 0,-0.0124 0.0096,-0.0234 0.02067,-0.0234 0.01102,0 0.02894,0.011 0.04961,0.0317 0.0096,0.01 0.02067,0.0152 0.02756,0.0152 0.02343,0 0.03996,-0.0234 0.05788,-0.0813 0.01102,-0.0358 0.01516,-0.0524 0.01516,-0.0579 0,-0.011 -0.0055,-0.0179 -0.01378,-0.0179 l -0.0124,10e-4 -0.0441,0.004 c -0.06752,0 -0.162609,-0.0469 -0.208084,-0.10059 l -0.103353,-0.12541 c -0.03996,-0.0496 -0.09646,-0.12264 -0.09233,-0.12264 l -0.08544,-0.0551 c -0.01516,-0.01 -0.02343,-0.022 -0.02343,-0.0317 0,-0.0138 0.01516,-0.022 0.03583,-0.022 0.01929,0 0.07993,0.0207 0.191548,0.0675 0.106109,0.0455 0.274229,0.0827 0.374826,0.0827 0.177767,0 0.323839,-0.14331 0.323839,-0.31695 0,-0.0965 -0.04272,-0.18465 -0.14745,-0.3073 -0.01929,-0.0221 -0.05236,-0.0441 -0.06752,-0.0441 -0.0124,0 -0.02067,0.008 -0.02067,0.0207 0,0.011 0.0041,0.0248 0.01102,0.0427 0.0041,0.011 0.0069,0.0234 0.0069,0.0345 0,0.0165 -0.0055,0.0262 -0.01791,0.0262 -0.02343,0 -0.04685,-0.0386 -0.06752,-0.10473 -0.02343,-0.0827 -0.07166,-0.1323 -0.184657,-0.19017 -0.04272,-0.0207 -0.09922,-0.0413 -0.117133,-0.0413 -0.0083,0 -0.0124,0.007 -0.0124,0.0165 0,0.0138 0.0055,0.0289 0.01516,0.0441 0.01516,0.0248 0.02618,0.0496 0.02894,0.0703 v 0.004 c 0,0.0138 -0.0069,0.022 -0.02067,0.022 -0.02343,0 -0.02894,-0.006 -0.08268,-0.0896 -0.02756,-0.0427 -0.103353,-0.0992 -0.166743,-0.1254 -0.02067,-0.01 -0.04272,-0.0138 -0.06339,-0.0152 h -0.0028 c -0.0124,0 -0.02343,0.006 -0.02343,0.0138 0,0.004 0.0055,0.0152 0.01653,0.0345 l 0.0055,0.0207 c 0,0.011 -0.0069,0.0207 -0.01653,0.0207 -0.02343,0 -0.09233,-0.0565 -0.146073,-0.11851 -0.05926,-0.0689 -0.09646,-0.15434 -0.09646,-0.22325 0,-0.14055 0.135047,-0.26733 0.286632,-0.26733 0.03858,0 0.07028,0.007 0.09508,0.0193 l 0.129536,0.0661 0.151584,0.1006 c 0.0882,0.0579 0.208084,0.1006 0.28112,0.1006 0.02618,0 0.04685,-0.004 0.115755,-0.0234 0.03721,-0.01 0.05926,-0.0234 0.05926,-0.0372 l -0.0014,-0.003 -0.0124,-0.008 -0.08268,-0.007 c -0.0441,-0.004 -0.14745,-0.051 -0.228754,-0.10335 l -0.170877,-0.11162 -0.151584,-0.0634 c -0.0124,-0.004 -0.01929,-0.0124 -0.01929,-0.0193 0,-0.007 0.0083,-0.0138 0.01653,-0.0138 0.0014,0 0.01516,0.003 0.04272,0.007 l 0.141939,0.0413 c 0.03445,0.01 0.09095,0.0358 0.169499,0.0785 0.155718,0.0813 0.254937,0.11851 0.329351,0.11851 0.08544,0 0.148829,-0.0593 0.148829,-0.13918 0,-0.0262 -0.0055,-0.0703 -0.01516,-0.10611 -0.0041,-0.0165 -0.01103,-0.0331 -0.02205,-0.0482 -0.0055,-0.01 -0.01378,-0.0152 -0.01791,-0.0152 -0.01102,0 -0.01654,0.0124 -0.01654,0.0303 l 0.0014,0.0262 0.0014,0.0207 c 0,0.0689 -0.02618,0.0923 -0.101975,0.0923 -0.06201,0 -0.144694,-0.0234 -0.333485,-0.0992 -0.176389,-0.0689 -0.286632,-0.0965 -0.396875,-0.0965 -0.278364,0 -0.523655,0.22875 -0.523655,0.48783 0,0.22462 0.148828,0.39549 0.453375,0.52089 l 0.315571,0.13092 c 0.260449,0.10611 0.355534,0.18328 0.355534,0.28387 0,0.0854 -0.07717,0.13919 -0.199816,0.13919 -0.05374,0 -0.119889,-0.0152 -0.241157,-0.0537 -0.2949,-0.0937 -0.486447,-0.13229 -0.654568,-0.13229 -0.275608,0 -0.471289,0.0744 -0.628385,0.23978 -0.02067,0.022 -0.03169,0.0289 -0.05099,0.0289 -0.0124,0 -0.0248,-0.004 -0.05236,-0.0207 -0.02894,-0.0165 -0.05926,-0.0276 -0.0813,-0.0276 -0.02756,0 -0.0689,0.0234 -0.08957,0.0496 l -0.03721,0.0482 c -0.01102,0.0138 -0.02205,0.022 -0.03169,0.022 -0.02756,0 -0.07441,-0.0455 -0.104731,-0.10059 -0.01929,-0.0331 -0.03169,-0.0648 -0.03721,-0.0951 -0.0041,-0.0248 -0.0083,-0.062 -0.0083,-0.10197 l 0.0041,-0.0689 0.01102,-0.0744 c 0.0055,-0.0358 0.0096,-0.0565 0.01102,-0.0634 0.0028,-0.008 0.01102,-0.0138 0.01791,-0.0138 0.01929,0 0.02756,0.0165 0.02756,0.0579 v 0.0234 l -0.0014,0.0165 c 0,0.10473 0.04134,0.2012 0.08819,0.2012 0.03583,0 0.06752,-0.0634 0.09508,-0.19293 0.0041,-0.0248 0.01516,-0.04 0.02756,-0.04 0.01516,0 0.02343,0.0179 0.03445,0.0744 0.0069,0.0358 0.03032,0.0854 0.0565,0.11851 0.01378,0.0193 0.02894,0.0289 0.04134,0.0289 0.03032,0 0.05099,-0.0455 0.06615,-0.15158 0.0055,-0.0413 0.01791,-0.0675 0.03169,-0.0675 0.0069,0 0.0124,0.004 0.01516,0.008 0.0041,0.003 0.0124,0.0165 0.02618,0.0413 0.0096,0.0152 0.02343,0.0276 0.04134,0.0358 0.01791,0.011 0.03307,0.0152 0.04272,0.0152 0.0124,0 0.0248,-0.006 0.03445,-0.0152 0.01654,-0.0138 0.02618,-0.0248 0.02618,-0.0303 0,-0.006 -0.0083,-0.0165 -0.02205,-0.0317 -0.02343,-0.0262 -0.04272,-0.0606 -0.06615,-0.12264 -0.01516,-0.0413 -0.02756,-0.0689 -0.03307,-0.0854 -0.0069,-0.0138 -0.0124,-0.022 -0.01929,-0.0262 l -0.01102,-0.003 -0.02205,0.003 c -0.0041,0.001 -0.03032,0.01 -0.07855,0.022 l -0.02343,0.004 c -0.01102,0 -0.01791,-0.007 -0.01791,-0.0179 0,-0.01 0.01378,-0.0276 0.03032,-0.0413 0.09371,-0.0744 0.150206,-0.19981 0.170877,-0.38171 0.0124,-0.11025 0.02618,-0.15297 0.07441,-0.21911 0.0096,-0.0138 0.01791,-0.022 0.02343,-0.022 0.01378,0 0.02205,0.011 0.02205,0.0331 0,0.0138 -0.0041,0.0317 -0.0124,0.0524 -0.0055,0.0138 -0.0083,0.0289 -0.0083,0.0455 l 0.0014,0.0138 0.0069,0.022 0.04134,-0.0152 0.0441,-0.051 c 0.02618,-0.0317 0.04823,-0.1006 0.04823,-0.15159 0,-0.0358 -0.0083,-0.0606 -0.03032,-0.0854 -0.02343,-0.0289 -0.03858,-0.04 -0.05512,-0.04 l -0.02618,0.003 -0.02618,10e-4 c -0.02343,0 -0.03583,-0.007 -0.03583,-0.022 l 0.0069,-0.0276 0.0041,-0.0413 -0.02343,-0.0923 -0.01791,-0.0455 -0.01102,-0.0358 -0.02618,0.0179 -0.05512,0.0331 c -0.01516,0.01 -0.03032,0.0234 -0.04548,0.0413 -0.05236,0.0634 -0.05512,0.0661 -0.07717,0.0661 -0.0124,0 -0.02067,-0.004 -0.02067,-0.0138 l 0.0014,-0.0152 c 0.0083,-0.0345 0.0124,-0.0606 0.0124,-0.0772 0,-0.0648 -0.04685,-0.16261 -0.104731,-0.21635 -0.07717,0.0744 -0.118511,0.15571 -0.118511,0.23426 v 0.0441 c 0,0.0179 -0.0055,0.0262 -0.01653,0.0262 H -62.91 c -0.0096,-0.001 -0.01929,-0.008 -0.02618,-0.0193 l -0.0441,-0.0593 c -0.0041,-0.004 -0.02343,-0.0193 -0.05926,-0.0482 -0.0083,-0.006 -0.01791,-0.0138 -0.03032,-0.0248 l -0.01516,0.0289 c -0.03721,0.073 -0.04961,0.11713 -0.05237,0.17776 -0.0014,0.0496 -0.0055,0.0648 -0.01653,0.0648 -0.0055,0 -0.01378,-0.004 -0.02343,-0.008 -0.0565,-0.0317 -0.06201,-0.0344 -0.08544,-0.0344 -0.06752,0 -0.112999,0.0482 -0.112999,0.11851 0,0.0262 0.01516,0.0689 0.04685,0.12265 0.03307,0.0606 0.08406,0.11575 0.106109,0.11575 0.0069,0 0.0083,-0.004 0.0083,-0.0221 v -0.008 l -0.0041,-0.0634 -0.0069,-0.0482 v -0.006 c 0,-0.0152 0.0055,-0.0207 0.01653,-0.0207 0.03307,0 0.06201,0.0978 0.08682,0.29352 0.02205,0.17226 0.07028,0.29077 0.144694,0.35967 0.01929,0.0179 0.03032,0.0317 0.03032,0.04 0,0.007 -0.0069,0.0124 -0.01516,0.0124 -0.01102,0 -0.02756,-0.007 -0.04823,-0.0193 -0.01378,-0.008 -0.02756,-0.011 -0.03996,-0.011 -0.03721,0 -0.07855,0.0427 -0.08682,0.0896 l -0.03307,0.21084 -0.02618,0.29628 c -0.0041,0.0565 0.0028,0.13229 0.02343,0.22324 0.01653,0.0799 0.0248,0.13781 0.0248,0.17501 0,0.22187 -0.137804,0.39826 -0.366558,0.46578 l -0.237023,0.0703 c -0.148828,0.0441 -0.220486,0.14194 -0.241156,0.32246 0.03858,-0.0303 0.04961,-0.0345 0.107486,-0.0441 l 0.07028,-0.011 c 0.03032,-0.006 0.05099,-0.011 0.06339,-0.0193 0.0069,-0.004 0.02067,-0.0179 0.04134,-0.04 l 0.06201,-0.0703 c 0.0248,-0.0276 0.04548,-0.0427 0.05926,-0.0427 0.0083,0 0.01516,0.011 0.01516,0.022 0,0.0138 -0.0083,0.0345 -0.02618,0.0606 -0.01653,0.0276 -0.02618,0.0606 -0.02618,0.0965 0,0.0469 0.0124,0.0772 0.05926,0.14469 0.0069,-0.022 0.0124,-0.0372 0.01516,-0.0441 0.0069,-0.0124 0.0248,-0.0386 0.0565,-0.0772 0.05099,-0.0675 0.08819,-0.13642 0.08819,-0.16812 0.0014,-0.0565 0.0055,-0.0758 0.02067,-0.0758 0.0124,0 0.01516,0.003 0.02067,0.0358 0.0014,0.008 0.0055,0.0152 0.01102,0.022 0.0083,0.01 0.01653,0.0152 0.02205,0.0152 0.0055,0 0.01516,-0.006 0.03032,-0.0152 0.0248,-0.0165 0.04548,-0.0344 0.05926,-0.0524 0.01516,-0.0193 0.02756,-0.0413 0.03583,-0.0661 0.0124,-0.0331 0.01929,-0.0565 0.01929,-0.0703 v -0.0482 c 0,-0.0124 0.0055,-0.0234 0.0124,-0.0234 0.0083,0 0.02756,0.0207 0.03859,0.0413 0.0096,0.0152 0.01378,0.0193 0.0248,0.0193 h 0.0014 c 0.01378,-10e-4 0.02618,-0.007 0.03445,-0.0151 0.0441,-0.0441 0.07303,-0.0979 0.07303,-0.13919 l -0.0028,-0.0689 -0.01516,-0.0551 -0.0014,-0.006 c 0,-0.011 0.0096,-0.0207 0.01791,-0.0207 0.01791,0 0.03583,0.0234 0.06063,0.0772 0.0124,0.0262 0.02343,0.0386 0.03445,0.0386 0.01791,0 0.03169,-0.0138 0.06615,-0.0634 l 0.03307,-0.0482 c 0.0083,-0.011 0.01102,-0.0234 0.01102,-0.0372 0,-0.0138 -0.0028,-0.0262 -0.01102,-0.0372 l -0.02894,-0.0441 c -0.0055,-0.008 -0.0083,-0.0207 -0.0083,-0.0372 0,-0.051 0.01929,-0.10748 0.0565,-0.17501 0.02756,-0.0482 0.04272,-0.0786 0.04823,-0.0923 0.0055,-0.0152 0.0124,-0.0221 0.02067,-0.0221 0.0069,0 0.0124,0.008 0.0124,0.0179 l -0.0041,0.0413 v 0.0593 c 0.0055,0.0138 0.01516,0.0193 0.03169,0.0193 0.0124,0 0.0248,-0.003 0.03858,-0.008 l 0.09371,-0.0331 c 0.02205,-0.008 0.04961,-0.0221 0.08406,-0.0413 0.146072,-0.0799 0.190169,-0.0965 0.261827,-0.0965 0.0441,0 0.09784,0.0165 0.176389,0.0524 0.01654,0.007 0.02894,0.011 0.03859,0.011 0.0096,0 0.02205,-0.007 0.03169,-0.0179 0.0069,-0.01 0.01102,-0.0193 0.01102,-0.0289 0,-0.0138 -0.0055,-0.0289 -0.01516,-0.0455 -0.01102,-0.0207 -0.02205,-0.0468 -0.02205,-0.0551 0,-0.011 0.0069,-0.0165 0.01653,-0.0165 0.0083,0 0.02205,0.01 0.02894,0.0193 0.0096,0.0179 0.03858,0.0675 0.08406,0.14883 0.07028,0.12266 0.159852,0.2081 0.2384,0.22601 l 0.162609,0.0372 c 0.04961,0.011 0.06339,0.0303 0.06339,0.0937 0,0.11576 -0.05512,0.21636 -0.148828,0.27699 l -0.13367,0.0854 c -0.04823,0.0303 -0.08819,0.11575 -0.08819,0.18741 0,0.0455 0.01102,0.12678 0.02618,0.19017 l 0.0248,-0.0262 0.06339,-0.0372 0.05512,-0.0551 0.03032,-0.0813 0.02894,-0.0744 c 0.01516,-0.0358 0.03169,-0.0593 0.0441,-0.0593 0.0124,0 0.01929,0.0207 0.01929,0.0565 v 0.0234 c 0,0.0537 0.0069,0.0772 0.04823,0.1571" style="fill:#fddc02;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path245" d="m -63.611425,123.09857 c 0.04547,-0.0413 0.05237,-0.0441 0.179145,-0.0703 0.100597,-0.0207 0.14745,-0.0661 0.169499,-0.16674 0.01653,-0.073 0.02618,-0.0868 0.09233,-0.12541 0.02205,-0.0124 0.03859,-0.0248 0.04823,-0.0372 0.0083,-0.01 0.01516,-0.0152 0.01929,-0.0152 0.0069,0 0.0124,0.007 0.0124,0.0165 0,0.0124 -0.0083,0.0331 -0.02343,0.0606 -0.01102,0.0179 -0.01516,0.04 -0.01516,0.0717 0,0.0592 0.0124,0.0992 0.0441,0.14745 0.02343,-0.0496 0.03583,-0.0634 0.09371,-0.10336 0.07304,-0.0524 0.100596,-0.11162 0.114377,-0.24529 0.0055,-0.0565 0.01653,-0.0854 0.03169,-0.0854 0.0069,0 0.0124,0.004 0.01653,0.011 l 0.02618,0.0565 c 0.0028,0.007 0.0124,0.0124 0.02343,0.0124 0.0096,0 0.03032,-0.011 0.04685,-0.0276 l 0.05236,-0.0482 c 0.02067,-0.0207 0.03583,-0.0717 0.0441,-0.15572 0.0028,-0.0303 0.01378,-0.051 0.02618,-0.051 0.0069,0 0.01516,0.007 0.01791,0.0179 l 0.02205,0.0744 c 0.0055,0.0165 0.01653,0.0289 0.02618,0.0289 0.0055,0 0.01516,-0.006 0.03032,-0.0179 0.01929,-0.0179 0.03721,-0.0358 0.05099,-0.0565 0.01792,-0.0234 0.02618,-0.0482 0.02618,-0.0744 v -0.062 c 0,-0.0138 0.0055,-0.0289 0.01516,-0.0413 0.0069,-0.01 0.0124,-0.0152 0.01654,-0.0152 0.0083,0 0.01653,0.008 0.02067,0.0193 l 0.01378,0.0413 c 0.0069,0.0165 0.02067,0.0289 0.03583,0.0289 0.01929,0 0.03859,-0.0165 0.0689,-0.0593 0.0083,-0.0124 0.01516,-0.022 0.02205,-0.0289 0.01653,-0.0207 0.02618,-0.0372 0.02618,-0.0482 0,-0.004 -0.0055,-0.0138 -0.01516,-0.0262 -0.05374,-0.0703 -0.0813,-0.15572 -0.0813,-0.25218 0,-0.12264 0.04685,-0.22737 0.188791,-0.41892 0.08544,-0.11576 0.13367,-0.22324 0.13367,-0.29766 0,-0.0207 -0.0096,-0.0317 -0.02894,-0.0317 -0.01378,0 -0.02756,0.004 -0.04548,0.0138 -0.01378,0.007 -0.02343,0.011 -0.02756,0.011 -0.0069,0 -0.01653,-0.006 -0.0248,-0.0152 l -0.02618,-0.0289 -0.01791,-0.0303 c -0.0069,-0.011 -0.01929,-0.0179 -0.03032,-0.0179 -0.0028,0 -0.0124,0.003 -0.02894,0.007 l -0.03307,0.004 c -0.03858,0.001 -0.05374,0.0152 -0.05374,0.0524 l 0.0014,0.0221 0.0014,0.0165 c 0,0.0317 -0.02894,0.0827 -0.06752,0.11713 l -0.07028,0.062 c -0.08682,0.0786 -0.15434,0.20257 -0.15434,0.28388 0,0.0358 0.01102,0.0923 0.03169,0.16123 0.03307,0.11162 0.04547,0.16398 0.04547,0.19981 0,0.17777 -0.272851,0.41204 -0.775835,0.66835 -0.254937,0.12954 -0.319705,0.20671 -0.319705,0.38172 l 0.0041,0.0661" style="fill:#fddc02;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path247" d="m -63.855338,119.20974 v 0.0923 c 0,0.0193 -0.0014,0.0331 -0.0083,0.0606 -0.01102,0.051 -0.01378,0.0689 -0.01378,0.0827 0,0.0717 0.0096,0.10611 0.05099,0.18052 0.02343,0.04 0.03859,0.0882 0.03859,0.12403 0,0.0152 -0.0069,0.0234 -0.01654,0.0234 -0.0069,0 -0.0124,-0.004 -0.01791,-0.011 l -0.03032,-0.0413 c -0.02343,-0.0317 -0.04547,-0.04 -0.106109,-0.04 l -0.06339,0.004 c 0.0248,0.0634 0.03307,0.0868 0.0441,0.12954 0.03032,0.12126 0.03445,0.12953 0.100597,0.18879 0.06615,0.0592 0.07166,0.0675 0.07166,0.0882 0,0.0165 -0.01102,0.0303 -0.02618,0.0303 l -0.02343,-0.004 -0.01516,-10e-4 c -0.02067,0 -0.03858,0.0372 -0.03858,0.0785 0,0.0234 0.0096,0.062 0.02343,0.0937 0.0096,0.0221 0.01791,0.0372 0.02618,0.0441 l 0.03721,0.0372 c 0.0096,0.01 0.01516,0.0234 0.01516,0.0386 0,0.0179 -0.01102,0.0331 -0.02343,0.0331 -0.0069,0 -0.01791,-0.004 -0.03307,-0.0124 -0.0083,-0.004 -0.01791,-0.007 -0.02618,-0.007 -0.01653,0 -0.0248,0.01 -0.0248,0.0303 l 0.0069,0.0551 0.02205,0.0965 c 0.0055,0.0207 0.01929,0.0455 0.04134,0.0703 0.01791,0.0207 0.03721,0.0358 0.05512,0.0441 0.04685,0.0207 0.07166,0.0317 0.07441,0.0331 0.0069,0.006 0.01103,0.0165 0.01103,0.0303 0,0.0138 -0.01103,0.0262 -0.0248,0.0262 -0.0041,0 -0.01653,-0.003 -0.03858,-0.008 l -0.03721,-0.003 c -0.03721,0 -0.03996,10e-4 -0.03996,0.0303 0,0.0193 0.0014,0.0386 0.0069,0.0579 l 0.01516,0.0592 c 0.01516,0.0634 0.03583,0.0965 0.05788,0.0965 0.0055,0 0.01516,-0.006 0.02756,-0.0152 0.05374,-0.04 0.161231,-0.0772 0.228755,-0.0772 0.07028,0 0.148828,0.008 0.179145,0.0179 0.01653,0.006 0.02894,0.01 0.03445,0.01 0.0096,0 0.0124,-0.01 0.01378,-0.0427 l 0.0069,-0.0661 0.01516,-0.11575 0.01102,-0.0854 v -0.0482 c -0.01378,0.0124 -0.02343,0.0207 -0.03032,0.0262 -0.06339,0.0593 -0.101978,0.0785 -0.168123,0.0785 -0.169499,0 -0.26734,-0.19155 -0.26734,-0.52641 0,-0.1378 0.01929,-0.33211 0.05788,-0.55673 0.0083,-0.0469 0.0124,-0.0799 0.0124,-0.10197 0,-0.12265 -0.07855,-0.24116 -0.212218,-0.32798" style="fill:#fddc02;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path249" d="m -63.603157,120.0407 0.03307,-0.0331 0.03307,-0.0303 c 0.02756,-0.0248 0.04961,-0.0758 0.04961,-0.11438 0,-0.0165 -0.0041,-0.0331 -0.0124,-0.0524 -0.0124,-0.0276 -0.03721,-0.0524 -0.05236,-0.0524 -0.0124,0 -0.0248,0.0303 -0.02894,0.0785 l -0.0083,0.0551 -0.01102,0.0565 -0.0028,0.0551 v 0.0372" style="fill:#fddc02;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path251" d="m -63.929752,121.55654 c 0.03721,0.0138 0.04548,0.0207 0.08544,0.0662 0.05099,0.0606 0.07993,0.0744 0.14745,0.0744 0.01791,0 0.03583,-0.001 0.05237,-0.007 l 0.04823,-0.0151 0.03721,-0.011 c 0.01791,-0.006 0.02894,-0.0124 0.02894,-0.0193 0,-0.007 -0.02894,-0.0317 -0.07304,-0.062 -0.03032,-0.0207 -0.05926,-0.0372 -0.08957,-0.0524 -0.03169,-0.0152 -0.05926,-0.0221 -0.08544,-0.0221 -0.05099,0 -0.101975,0.0152 -0.151584,0.0482" style="fill:#fddc02;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path253" d="m -63.42539,122.64244 c 0.06477,-0.0276 0.08819,-0.04 0.162609,-0.0813 0.06477,-0.0358 0.100597,-0.0551 0.107487,-0.0593 0.0689,-0.0358 0.100596,-0.062 0.100596,-0.0813 0,-0.0234 -0.04134,-0.0386 -0.112998,-0.0386 -0.144695,0 -0.261828,0.0978 -0.261828,0.21911 l 0.0041,0.0413" style="fill:#fddc02;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path255" d="m -61.920572,121.70124 c 0.05237,-0.011 0.07028,-0.0248 0.09646,-0.0262 l 0.06614,0.004 c 0.0083,-0.003 0.02343,-0.0124 0.0441,-0.0289 0.0124,-0.01 0.03032,-0.022 0.05237,-0.0386 0.07441,-0.0496 0.07855,-0.0538 0.07855,-0.0689 0,-0.0207 -0.03032,-0.0317 -0.09233,-0.0317 -0.117134,0 -0.188791,0.0551 -0.245291,0.19017" style="fill:#fddc02;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path257" d="m -69.520453,112.76742 -0.01791,-0.0524 -0.0055,-0.0303 c 0,-0.0303 0.01516,-0.0469 0.0565,-0.062 0.07304,-0.0276 0.09646,-0.04 0.126779,-0.0675 l 0.03996,-0.0372 0.0041,-0.001 c 0.01102,0 0.01929,0.0124 0.01929,0.0289 0,0.0469 -0.05099,0.13367 -0.103353,0.22187 -0.03858,0.0661 -0.0565,0.10748 -0.07166,0.10748 -0.01791,0 -0.03721,-0.0289 -0.04134,-0.0634 l -0.0069,-0.0441" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path259" d="m -69.739561,112.61859 0.06339,0.0331 c 0.01653,0.01 0.02618,0.022 0.02618,0.0358 l -0.0041,0.0234 c -0.0096,0.0317 -0.0014,0.0661 -0.0028,0.0799 -0.0028,0.0661 -0.05236,0.0648 -0.07304,0.0648 -0.0124,0 -0.0055,-0.007 -0.03583,-0.04 l -0.0813,-0.0937 c -0.0248,-0.0289 -0.04685,-0.0937 -0.05512,-0.16674 v -0.01 c 0,-0.0193 0.0055,-0.0276 0.02205,-0.0276 0.0096,0 0.02756,0.008 0.04134,0.0193 l 0.09922,0.0813" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path261" d="m -69.516319,113.00444 0.05926,-0.0372 0.03445,0.008 c 0.04134,0 0.05099,0.011 0.05099,0.0565 0,0.0662 -0.04134,0.0937 -0.115755,0.27974 -0.03307,0.0827 -0.03858,0.12954 -0.08819,0.12954 -0.05374,0 -0.09508,-0.0441 -0.137804,-0.14883 l -0.04823,-0.11851 c -0.03445,-0.0827 -0.04823,-0.13367 -0.04823,-0.16399 0,-0.0289 0.02205,-0.0469 0.05512,-0.0469 0.01791,0 0.03583,0.006 0.05237,0.0152 0.02894,0.0165 0.0441,0.0262 0.04548,0.0262 l 0.04272,0.004 0.01929,-0.001 0.07855,-0.003" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path263" d="m -62.590299,112.77844 -0.03032,-0.0634 -0.0055,-0.0303 c 0,-0.0317 0.01378,-0.0455 0.06063,-0.062 0.04685,-0.0179 0.09784,-0.0455 0.122646,-0.0675 l 0.03996,-0.0372 0.0041,-0.001 c 0.01102,0 0.01791,0.0124 0.01791,0.0276 0,0.0482 -0.04272,0.12264 -0.09508,0.21222 -0.03858,0.0648 -0.06339,0.11851 -0.07855,0.11851 -0.01929,0 -0.03721,-0.0289 -0.04134,-0.0634 l 0.0055,-0.0331" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path265" d="m -62.821809,112.61859 0.06339,0.0331 c 0.01791,0.01 0.02756,0.0262 0.02756,0.0441 l -0.0014,0.0152 -0.01929,0.0675 -0.01103,0.073 c -0.0014,0.01 -0.0096,0.0152 -0.01929,0.0152 h -0.0028 c -0.01516,-0.004 -0.05512,-0.0207 -0.07993,-0.051 l -0.0565,-0.0937 c -0.0083,-0.01 -0.03032,-0.0441 -0.04823,-0.10335 -0.0069,-0.022 -0.0124,-0.0427 -0.01516,-0.0634 l -0.0014,-0.01 c 0,-0.0193 0.0069,-0.0276 0.02343,-0.0276 0.0096,0 0.02756,0.008 0.04134,0.0193 l 0.09922,0.0813" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path267" d="m -62.595811,113.00444 0.0565,-0.0372 0.02067,-0.004 c 0.04134,0 0.08819,0.04 0.08819,0.0827 0,0.0372 -0.04823,0.0579 -0.0689,0.11024 l -0.03996,0.16675 c -0.03032,0.0799 -0.0689,0.11851 -0.117134,0.11851 -0.0565,0 -0.09784,-0.0441 -0.139181,-0.14883 -0.01929,-0.0469 -0.03445,-0.0868 -0.04823,-0.11851 -0.03032,-0.0717 -0.04685,-0.1254 -0.04685,-0.15434 0,-0.0358 0.02067,-0.0565 0.05374,-0.0565 0.01791,0 0.03583,0.006 0.05237,0.0152 0.02894,0.0165 0.04272,0.0248 0.0441,0.0262 l 0.0441,0.004 0.01929,-0.001 0.0813,-0.003" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path269" d="m -69.831889,119.54736 -0.01791,-0.0551 -0.0041,-0.0165 c 0,-0.006 0.0069,-0.011 0.01516,-0.011 0.0083,0 0.02894,0.011 0.0441,0.0234 0.01653,0.0124 0.02618,0.0124 0.05237,0.0179 0.100597,0.0262 0.121267,0.0455 0.121267,0.0937 l -0.0028,0.062 -0.01516,0.0565 c -0.0069,0.0234 -0.0124,0.0317 -0.02343,0.0317 -0.0083,0 -0.07304,-0.0455 -0.07993,-0.0579 l -0.03721,-0.0524 -0.05237,-0.0923" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path271" d="m -69.382649,119.63969 -0.04961,0.0854 c -0.01102,0.0138 -0.01791,0.0207 -0.01791,0.0207 h -0.0028 c -0.02067,0 -0.03996,-0.0441 -0.04134,-0.091 l -0.0069,-0.0744 c 0.0055,-0.0303 0.02343,-0.0441 0.0689,-0.051 0.03858,-0.007 0.06339,-0.0152 0.07579,-0.0234 0.03445,-0.0248 0.05374,-0.0386 0.05926,-0.04 l 0.0055,-0.001 c 0.0096,0 0.01654,0.007 0.01654,0.0179 v 0.006 l -0.02618,0.0634 -0.0813,0.0882" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path273" d="m -69.479111,119.89187 0.05926,-0.0289 c 0.0096,-0.006 0.01929,-0.008 0.02756,-0.008 0.02894,0 0.04961,0.0207 0.04961,0.0606 0,0.0427 -0.03307,0.0992 -0.07717,0.18052 -0.04961,0.0882 -0.08682,0.14883 -0.124024,0.14883 -0.05374,0 -0.129535,-0.0841 -0.202571,-0.226 -0.01654,-0.0331 -0.02756,-0.073 -0.02756,-0.10335 0,-0.0469 0.01929,-0.0717 0.05926,-0.0717 0.01653,0 0.03032,0.004 0.04272,0.011 l 0.03307,0.022 c 0.02894,0.0207 0.06201,0.0303 0.09508,0.0303 0.02205,0 0.04548,-0.006 0.06477,-0.0152" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path275" d="m -63.040917,119.44401 0.05237,0.0331 c 0.03032,0.0193 0.05512,0.0317 0.07442,0.04 0.05788,0.0248 0.07717,0.0331 0.07717,0.0551 0,0.007 -0.0014,0.0276 -0.0069,0.0413 -0.0055,0.0165 -0.0096,0.0344 -0.01102,0.0524 -0.0055,0.051 -0.03583,0.0634 -0.0565,0.0634 -0.02343,0 -0.05099,-0.0386 -0.09233,-0.11163 -0.01792,-0.0331 -0.0441,-0.0992 -0.05926,-0.14745 l -0.0014,-0.0152 c 0,-0.008 0.0055,-0.0138 0.01516,-0.0138 l 0.0083,0.003" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path277" d="m -62.539311,119.57355 -0.08544,0.0854 c -0.03032,0.04 -0.03032,0.0744 -0.03721,0.0813 -0.0055,0.006 -0.01516,0.01 -0.02618,0.011 h -0.0055 c -0.02205,0 -0.03721,-0.0152 -0.03858,-0.0372 l -0.0041,-0.0634 -0.0041,-0.062 v -0.004 c 0,-0.0248 0.01378,-0.0372 0.03307,-0.0413 l 0.07855,-0.022 0.0813,-0.0413 c 0.0248,-0.011 0.03169,-0.0138 0.03583,-0.0138 0.0096,0 0.01653,0.01 0.01653,0.0207 0,0.006 -0.0028,0.0138 -0.0069,0.0234 l -0.03721,0.0634" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path279" d="m -62.914137,119.82573 0.05512,0.04 c 0.01378,0.008 0.03169,0.0124 0.04961,0.0124 0.02343,0 0.0565,-0.008 0.08819,-0.0234 l 0.04823,-0.022 c 0.01102,-0.004 0.02067,-0.007 0.02894,-0.007 0.02894,0 0.05237,0.0303 0.05237,0.0703 0,0.0537 -0.03859,0.11162 -0.09646,0.19292 l -0.03996,0.0854 c -0.03307,0.0455 -0.05512,0.0634 -0.0813,0.0634 -0.0441,0 -0.06477,-0.0262 -0.130914,-0.15709 -0.04685,-0.0937 -0.06615,-0.15021 -0.06615,-0.19569 0,-0.04 0.01929,-0.0675 0.04961,-0.0675 0.01102,0 0.02618,-0.003 0.04272,0.008" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path281" d="m -69.597623,113.11193 h -0.04823 c -0.0083,0 -0.01516,0.004 -0.01929,0.011 l -0.0069,0.0179 0.01791,0.0896 0.01516,0.0772 c 0.0083,0.0427 0.02343,0.0606 0.05512,0.0606 0.03721,0 0.05926,-0.0262 0.06339,-0.0717 l 0.0083,-0.0813 c 0.0041,-0.0538 0.0069,-0.0827 0.0069,-0.0841 0,-0.008 -0.0041,-0.0165 -0.01102,-0.0234 -0.0055,-0.006 -0.0124,-0.008 -0.01929,-0.008 l -0.0028,0.001 -0.05926,0.011" style="fill:#fddc02;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path283" d="m -62.681249,113.11193 h -0.0441 c -0.0069,0 -0.01378,0.004 -0.01791,0.011 -0.0069,0.01 -0.01103,0.0165 -0.01103,0.0179 l 0.01791,0.0896 0.01516,0.0772 c 0.0083,0.0427 0.01516,0.0606 0.04685,0.0606 0.03583,0 0.06752,-0.0262 0.07166,-0.0717 l 0.0069,-0.0813 c 0.0055,-0.0538 0.0083,-0.0827 0.0083,-0.0841 0,-0.008 -0.0041,-0.0165 -0.01102,-0.0234 -0.0055,-0.006 -0.0124,-0.008 -0.01929,-0.008 l -0.0041,0.001 -0.05926,0.011" style="fill:#fddc02;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path285" d="m -69.56455,119.98145 -0.04134,-0.008 h -0.0055 c -0.02343,0 -0.03583,0.0138 -0.03583,0.04 0,0.0372 0.02894,0.10749 0.06752,0.16123 0.0069,0.01 0.01791,0.0152 0.02756,0.0152 0.0248,0 0.04134,-0.0455 0.05374,-0.11989 l 0.01102,-0.0551 0.0014,-0.011 c 0,-0.0221 -0.0069,-0.0303 -0.02618,-0.0303 h -0.0083 l -0.0441,0.008" style="fill:#fddc02;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path287" d="m -62.865906,120.02968 0.0041,0.0703 c 0.0014,0.0317 0.02756,0.0634 0.05374,0.0634 0.03445,0 0.05788,-0.051 0.07166,-0.12954 0.0069,-0.0372 0.0083,-0.0413 0.0083,-0.0524 0,-0.0276 -0.0096,-0.0345 -0.0441,-0.0345 l -0.01929,0.001 h -0.02618 l -0.01653,-0.001 c -0.02343,0 -0.03169,0.0179 -0.03169,0.0648 v 0.0179" style="fill:#fddc02;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path289" d="m -67.039984,116.43713 h 0.392741 c 0.0441,-0.0937 0.104731,-0.13505 0.198437,-0.13505 0.09233,0 0.151585,0.04 0.205328,0.13505 h 0.321083 c 0.03858,-0.0854 0.115755,-0.13505 0.21084,-0.13505 0.08682,0 0.172255,0.0565 0.201194,0.13505 h 0.297656 c 0.04547,-0.0868 0.115755,-0.13505 0.197059,-0.13505 0.08268,0 0.150206,0.0372 0.199816,0.11163 l 0.01516,0.0234 h 0.414789 v 1.92099 h -0.362424 v 0.73725 h -0.427192 v -0.73725 h -1.076247 v 0.73725 h -0.425815 v -0.74414 h -0.362424 v -1.9141" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path291" d="m -66.885644,118.21067 h 2.357824 v -1.61644 h -2.357824 z m 0,0" style="fill:#ee2e4f;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path293" d="m -66.640353,116.96354 c -0.06201,0 -0.111621,0.051 -0.111621,0.113 0,0.062 0.04961,0.11162 0.111621,0.11162 0.06201,0 0.111621,-0.0496 0.111621,-0.11162 0,-0.062 -0.04961,-0.113 -0.111621,-0.113" style="fill:#fddc02;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path295" d="m -66.640353,116.96354 c -0.06201,0 -0.111621,0.051 -0.111621,0.113 0,0.062 0.04961,0.11162 0.111621,0.11162 0.06201,0 0.111621,-0.0496 0.111621,-0.11162 0,-0.062 -0.04961,-0.113 -0.111621,-0.113 z m 0,0" style="fill:none;stroke:#211e1e;stroke-width:0.03033889;stroke-linecap:butt;stroke-linejoin:miter;stroke-miterlimit:4;stroke-opacity:1" inkscape:connector-curvature="0"/>
              <path id="path297" d="m -64.789648,116.96354 c -0.06201,0 -0.111621,0.051 -0.111621,0.113 0,0.062 0.04961,0.11162 0.111621,0.11162 0.06201,0 0.111622,-0.0496 0.111622,-0.11162 0,-0.062 -0.04961,-0.113 -0.111622,-0.113" style="fill:#fddc02;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path299" d="m -64.789647,116.96354 c -0.06201,0 -0.111621,0.051 -0.111621,0.113 0,0.062 0.04961,0.11162 0.111621,0.11162 0.06201,0 0.111621,-0.0496 0.111621,-0.11162 0,-0.062 -0.04961,-0.113 -0.111621,-0.113 z m 0,0" style="fill:none;stroke:#211e1e;stroke-width:0.03033889;stroke-linecap:butt;stroke-linejoin:miter;stroke-miterlimit:4;stroke-opacity:1" inkscape:connector-curvature="0"/>
              <path id="path301" d="m -66.640353,117.84273 c -0.06201,0 -0.111621,0.051 -0.111621,0.11162 0,0.062 0.05099,0.113 0.115755,0.113 0.05926,0 0.107487,-0.051 0.107487,-0.113 0,-0.0606 -0.04961,-0.11162 -0.111621,-0.11162" style="fill:#fddc02;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path303" d="m -66.640353,117.84273 c -0.06201,0 -0.111621,0.051 -0.111621,0.11162 0,0.062 0.05099,0.113 0.115755,0.113 0.05926,0 0.107487,-0.051 0.107487,-0.113 0,-0.0606 -0.04961,-0.11162 -0.111621,-0.11162 z m 0,0" style="fill:none;stroke:#211e1e;stroke-width:0.03033889;stroke-linecap:butt;stroke-linejoin:miter;stroke-miterlimit:4;stroke-opacity:1" inkscape:connector-curvature="0"/>
              <path id="path305" d="m -64.789648,117.84273 c -0.06201,0 -0.111621,0.051 -0.111621,0.11162 0,0.062 0.04961,0.113 0.111621,0.113 0.06201,0 0.111622,-0.051 0.111622,-0.113 0,-0.0606 -0.04961,-0.11162 -0.111622,-0.11162" style="fill:#fddc02;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path307" d="m -64.789647,117.84273 c -0.06201,0 -0.111621,0.051 -0.111621,0.11162 0,0.062 0.04961,0.113 0.111621,0.113 0.06201,0 0.111621,-0.051 0.111621,-0.113 0,-0.0606 -0.04961,-0.11162 -0.111621,-0.11162 z m 0,0" style="fill:none;stroke:#211e1e;stroke-width:0.03033889;stroke-linecap:butt;stroke-linejoin:miter;stroke-miterlimit:4;stroke-opacity:1" inkscape:connector-curvature="0"/>
              <path id="path309" d="m -66.288953,117.50236 c 0.151584,0.19016 0.344509,0.28387 0.581532,0.28387 0.219108,0 0.370692,-0.0786 0.547081,-0.28387 -0.176389,-0.18191 -0.341753,-0.2577 -0.558105,-0.2577 -0.228755,0 -0.434082,0.0937 -0.570508,0.2577" style="fill:#fddc02;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path311" d="m -66.175954,117.50236 c 0.155718,-0.12127 0.28801,-0.17226 0.451997,-0.17226 0.165364,0 0.288009,0.0482 0.447862,0.17639 -0.139182,0.1378 -0.261827,0.19017 -0.450619,0.19017 -0.16812,0 -0.319705,-0.0661 -0.44924,-0.1943" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path313" d="m -65.985785,117.46515 c 0.09371,0.0593 0.168121,0.0827 0.254937,0.0827 0.103353,0 0.188792,-0.0262 0.271474,-0.0827 -0.08682,-0.0413 -0.177767,-0.0634 -0.26734,-0.0634 -0.09371,0 -0.180522,0.0207 -0.259071,0.0634" style="fill:#fddc02;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path315" d="m -66.918717,116.7596 h 2.42397 v -0.0827 h -2.42397 z m 0,0" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:#211e1e;stroke-width:0.01023056;stroke-linecap:butt;stroke-linejoin:miter;stroke-miterlimit:4;stroke-opacity:1" inkscape:connector-curvature="0"/>
              <path id="path317" d="m -66.546646,116.57218 v 0.23151 c 0,0.0551 0.04272,0.0965 0.09922,0.0965 0.06615,0 0.101974,-0.0344 0.101974,-0.0965 v -0.22875 c 0,-0.0882 -0.03445,-0.14194 -0.09233,-0.14194 -0.0124,0 -0.03032,0.004 -0.04548,0.011 -0.0124,0.007 -0.02067,0.011 -0.02618,0.0152 -0.0083,0.008 -0.01653,0.0179 -0.02205,0.0303 -0.0096,0.0207 -0.01516,0.0344 -0.01516,0.0413 v 0.0413" style="fill:#fddc02;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path319" d="m -65.817664,116.76235 v 0.0413 c 0,0.0551 0.04272,0.0965 0.09922,0.0965 0.06615,0 0.103353,-0.0344 0.103353,-0.0965 v -0.22875 c 0,-0.0868 -0.03721,-0.14194 -0.09371,-0.14194 -0.06615,0 -0.108865,0.0537 -0.108865,0.13918 v 0.19017" style="fill:#fddc02;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path321" d="m -65.110731,116.57218 v 0.23151 c 0,0.0551 0.04272,0.0965 0.09922,0.0965 0.06477,0 0.101975,-0.0344 0.101975,-0.0965 v -0.22875 c 0,-0.0882 -0.03583,-0.14194 -0.09233,-0.14194 -0.0124,0 -0.03032,0.004 -0.04548,0.011 -0.0124,0.007 -0.02205,0.011 -0.02618,0.0152 -0.0096,0.008 -0.01653,0.0179 -0.02343,0.0303 -0.0083,0.0207 -0.01378,0.0344 -0.01378,0.0413 v 0.0413" style="fill:#fddc02;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path323" d="m -66.599012,118.81149 h 0.220486 v -0.28387 h -0.220486 z m 0,0" style="fill:#fddc02;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path325" d="m -66.599012,118.96445 h 0.220486 v -0.0896 h -0.220486 z m 0,0" style="fill:#fddc02;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path327" d="m -65.095572,118.81149 h 0.220486 v -0.28387 h -0.220486 z m 0,0" style="fill:#fddc02;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path329" d="m -65.095572,118.96445 h 0.220486 v -0.0896 h -0.220486 z m 0,0" style="fill:#fddc02;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path331" d="m -52.983994,111.63329 c 0,0.0344 0,0.13643 0,0.1695 -0.03445,0 -0.111621,0 -0.111621,0 -0.165365,0 -0.44235,0 -0.44235,0.51676 v 2.11805 c 0,1.29673 -0.563618,1.9265 -1.723926,1.9265 -1.310515,0 -1.920986,-0.52366 -1.920986,-1.644 v -2.40055 c 0,-0.51676 -0.279741,-0.51676 -0.52641,-0.51676 0,0 -0.02894,0 -0.05237,0 0,-0.0331 0,-0.13505 0,-0.1695 0.04961,0 1.909961,0 1.959571,0 0,0.0344 0,0.13643 0,0.1695 -0.02343,0 -0.05237,0 -0.05237,0 -0.242535,0 -0.545703,0 -0.545703,0.51676 v 2.29306 c 0,0.98805 0.412033,1.46899 1.260905,1.46899 0.826823,0 1.262283,-0.51814 1.262283,-1.49655 v -2.2655 c 0,-0.51676 -0.285254,-0.51676 -0.493338,-0.51676 0,0 -0.07166,0 -0.10473,0 0,-0.0331 0,-0.13505 0,-0.1695 0.04823,0 1.442805,0 1.491037,0" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path333" d="m -50.867328,116.094 v 0.1695 c 0,0 -1.604036,0 -1.653645,0 0,-0.0344 0,-0.13643 0,-0.1695 0.02756,0 0.06614,0 0.06614,0 0.541569,0 0.611849,-0.41341 0.611849,-0.87919 v -2.78088 c 0,-0.44511 -0.256315,-0.63114 -0.618739,-0.63114 h -0.05926 v -0.16812 h 1.300868 l 2.813953,3.44785 v -2.62241 c 0,-0.59255 -0.414789,-0.65732 -0.592554,-0.65732 0,0 -0.08268,0 -0.117136,0 0,-0.0331 0,-0.13505 0,-0.16812 0.04961,0 1.620573,0 1.670184,0 0,0.0331 0,0.13505 0,0.16812 -0.02755,0 -0.07166,0 -0.07166,0 -0.293522,0 -0.604958,0.0689 -0.604958,0.87919 v 3.60357 l -0.246669,0.001 -3.191536,-3.86126 0.0014,2.78639 c 0,0.46578 0.06752,0.88195 0.627007,0.88195 h 0.06477" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path335" d="m -42.001031,115.28096 1.018371,-2.84427 c 0.181903,-0.48507 0.06477,-0.6339 -0.355533,-0.6339 h -0.08544 v -0.1695 h 1.317406 v 0.1695 h -0.02893 c -0.143316,0 -0.311436,0.0427 -0.436837,0.36105 l -1.542024,4.1162 h -0.293522 l -1.675694,-4.07762 c -0.132292,-0.339 -0.289387,-0.39963 -0.570509,-0.39963 0,0 -0.02067,0 -0.03858,0 0,-0.0331 0,-0.13505 0,-0.1695 0.04823,0 1.864483,0 1.912715,0 0,0.0344 0,0.13643 0,0.1695 -0.03447,0 -0.124022,0 -0.124022,0 -0.326595,0 -0.389986,0.20533 -0.297657,0.45475 l 1.20027,3.02342" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path337" d="m -34.275748,111.8524 -0.0014,2.04914 h 0.396875 c 0.720715,0 1.039044,-0.32108 1.039044,-1.07349 0,-0.61047 -0.39412,-1.00597 -0.986677,-1.00597 -0.139182,0 -0.327974,0.011 -0.447862,0.0303 z m 0.711066,-0.21911 c 1.025261,0 1.533758,0.37758 1.533758,1.1548 0,0.6587 -0.514008,0.99218 -0.919152,1.15617 l -0.0303,0.011 1.135503,1.72944 c 0.181903,0.27974 0.329353,0.38861 0.643544,0.40515 0,0.0303 0,0.1378 0,0.17363 -0.04961,0 -1.18649,0 -1.18649,0 l -1.376659,-2.17317 h -0.512632 v 1.44005 c 0,0.52228 0.23289,0.56362 0.560864,0.56362 0,0 0.06063,0 0.09095,0 0,0.0331 0,0.13505 0,0.1695 -0.04823,0 -1.962326,0 -2.011937,0 0,-0.0344 0,-0.13643 0,-0.1695 0.03168,0 0.09095,0 0.09095,0 0.225997,0 0.487825,-0.10197 0.487825,-0.38861 v -3.36517 c 0,-0.53743 -0.31695,-0.53743 -0.487825,-0.53743 0,0 -0.05926,0 -0.09095,0 0,-0.0331 0,-0.13505 0,-0.1695 0.04961,0 2.072569,0 2.072569,0" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <g transform="matrix(0.35277778,0,0,0.35277778,-86.663248,94.330643)" id="g341" clip-path="url(#clip6)" style="clip-rule:nonzero">
                <path id="path339" d="m 164.14844,59.679688 c 0,-1.597657 -1.3711,-2.226563 -2.64844,-2.894532 -1.5,-0.777343 -3.22266,-1.585937 -3.22266,-4.007812 0,-2.34375 1.78516,-3.859375 4.33594,-3.859375 1.04297,0 2.22266,0.210937 2.74219,0.3125 l 0.17969,2.554687 -0.49219,0.07031 c -0.22656,-1.34375 -0.92578,-2.375 -2.4336,-2.375 -1.42187,0 -2.47265,0.871094 -2.47265,2.441406 0,1.480469 1.36719,2.085938 2.64062,2.730469 1.5586,0.78125 3.34375,1.59375 3.34375,4.039062 0,2.707032 -2.41015,3.917969 -4.64062,3.917969 -0.88672,0 -2.11719,-0.179687 -3.10938,-0.738281 l -0.3125,-2.84375 0.47657,-0.08203 c 0.36328,1.886718 1.5625,2.976562 3.14062,2.976562 1.51172,0 2.47266,-0.921875 2.47266,-2.242187" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none" inkscape:connector-curvature="0"/>
              </g>
              <path id="path343" d="m -25.453548,111.63329 c 0,0.0344 0,0.13643 0,0.1695 -0.02618,0 -0.06477,0 -0.06477,0 -0.264584,0 -0.507119,0.0496 -0.507119,0.40928 v 3.47265 c 0,0.35967 0.242535,0.40928 0.507119,0.40928 0,0 0.03858,0 0.06477,0 0,0.0331 0,0.13505 0,0.1695 -0.04961,0 -1.883777,0 -1.933388,0 0,-0.0344 0,-0.13643 0,-0.1695 0.02618,0 0.06615,0 0.06615,0 0.263207,0 0.507118,-0.0496 0.507118,-0.40928 v -3.47265 c 0,-0.35967 -0.243911,-0.40928 -0.507118,-0.40928 0,0 -0.03996,0 -0.06615,0 0,-0.0331 0,-0.13505 0,-0.1695 0.04961,0 1.88378,0 1.933388,0" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path345" d="m -44.961055,111.63329 c 0,0.0344 0,0.13643 0,0.1695 -0.02618,0 -0.06615,0 -0.06615,0 -0.263207,0 -0.507118,0.0496 -0.507118,0.40928 v 3.47265 c 0,0.35967 0.243911,0.40928 0.507118,0.40928 0,0 0.03996,0 0.06615,0 0,0.0331 0,0.13505 0,0.1695 -0.04961,0 -1.88378,0 -1.933388,0 0,-0.0344 0,-0.13643 0,-0.1695 0.02618,0 0.06477,0 0.06477,0 0.264584,0 0.508498,-0.0496 0.508498,-0.40928 v -3.47265 c 0,-0.35967 -0.243914,-0.40928 -0.508498,-0.40928 0,0 -0.03858,0 -0.06477,0 0,-0.0331 0,-0.13505 0,-0.1695 0.04961,0 1.883777,0 1.933388,0" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <g transform="matrix(0.35277778,0,0,0.35277778,-86.663248,94.330643)" id="g349" clip-path="url(#clip7)" style="clip-rule:nonzero">
                <path id="path347" d="m 227.42969,67.996094 0.0469,3.484375 c 0,0 -0.42578,0.105469 -0.55859,0.144531 -0.125,-1.523437 -0.46875,-2.765625 -2.90235,-2.765625 h -3.27343 v 6.4375 h 2.80859 c 1.37891,0 1.75391,-0.769531 1.91016,-2.101562 0.10156,0 0.4375,0 0.55859,0 0,0.179687 0,5.382812 0,5.382812 l -0.55859,0.0078 c -0.0859,-1.285157 -0.39063,-2.285157 -1.89844,-2.285157 h -2.82031 v 5.652344 c 0,1.644531 1.41406,1.644531 2.91406,1.644531 2.6875,0 3.9375,-0.171875 4.6875,-2.890625 0.10937,0.02734 0.55078,0.121094 0.55078,0.121094 l -0.75391,3.628906 c 0,0 -12.03515,0 -12.21484,0 0,-0.121093 0,-0.480468 0,-0.601562 0.0937,0 0.23438,0 0.23438,0 0.93359,0 1.80078,-0.175781 1.80078,-1.453125 V 70.054688 c 0,-1.277344 -0.86719,-1.457032 -1.80078,-1.457032 0,0 -0.14063,0 -0.23438,0 0,-0.117187 0,-0.480468 0,-0.601562 0.17969,0 11.50391,0 11.50391,0" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none" inkscape:connector-curvature="0"/>
              </g>
              <path id="path351" d="m -30.809981,118.59238 -0.0014,2.57004 h 0.496093 c 0.903994,0 1.302248,-0.40238 1.302248,-1.34634 0,-0.76619 -0.493339,-1.2609 -1.236102,-1.2609 -0.173633,0 -0.396875,0.01 -0.56086,0.0372 z m 0.891589,-0.27423 c 1.285709,0 1.922364,0.47405 1.922364,1.44694 0,0.82683 -0.643544,1.24437 -1.152038,1.45108 l -0.03721,0.0152 1.423512,2.16765 c 0.228755,0.3514 0.414789,0.48783 0.806153,0.50988 0,0.0372 0,0.17225 0,0.21635 -0.06064,0 -1.485526,0 -1.485526,0 l -1.728061,-2.72714 h -0.642165 v 1.80799 c 0,0.65594 0.290767,0.70693 0.701421,0.70693 0,0 0.0758,0 0.115757,0 0,0.0427 0,0.1695 0,0.21222 -0.06201,0 -2.462554,0 -2.524566,0 0,-0.0427 0,-0.1695 0,-0.21222 0.03996,0 0.115754,0 0.115754,0 0.281121,0 0.611851,-0.12816 0.611851,-0.48783 v -4.22093 c 0,-0.67248 -0.398255,-0.67248 -0.611851,-0.67248 0,0 -0.07579,0 -0.115754,0 0,-0.0427 0,-0.17088 0,-0.2136 0.06339,0 2.600357,0 2.600357,0" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path353" d="m -24.176104,118.31678 c 0,0.0427 0,0.17087 0,0.21359 -0.03306,0 -0.08268,0 -0.08268,0 -0.33073,0 -0.636655,0.062 -0.636655,0.51263 v 4.35598 c 0,0.45062 0.305925,0.51263 0.636655,0.51263 0,0 0.04961,0 0.08268,0 0,0.0427 0,0.17088 0,0.21222 -0.06202,0 -2.363336,0 -2.425348,0 0,-0.0413 0,-0.1695 0,-0.21222 0.03306,0 0.0813,0 0.0813,0 0.330729,0 0.636654,-0.062 0.636654,-0.51263 V 119.043 c 0,-0.45062 -0.305925,-0.51263 -0.636654,-0.51263 0,0 -0.04823,0 -0.0813,0 0,-0.0427 0,-0.17087 0,-0.21359 0.06201,0 2.363333,0 2.425348,0" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <g transform="matrix(0.35277778,0,0,0.35277778,-86.663248,94.330643)" id="g357" clip-path="url(#clip8)" style="clip-rule:nonzero">
                <path id="path355" d="m 176.35937,49.046875 h 8.67969 c 0.4375,0 1,-0.109375 1.08594,-0.679687 h 0.42187 l -0.33203,3.421875 h -0.46875 C 185.71875,51 185.60156,49.847656 184.33594,49.847656 h -2.64844 v 10.132813 c 0,1.578125 0.75781,1.710937 1.60547,1.710937 0,0 0.18359,0 0.27734,0 0,0.09375 0,0.382813 0,0.480469 -0.14453,0 -5.83984,0 -5.98047,0 0,-0.09766 0,-0.386719 0,-0.480469 0.0898,0 0.27735,0 0.27735,0 0.99609,0 1.60547,-0.08203 1.60547,-1.671875 V 49.847656 h -2.67969 c -1.36328,0 -1.4961,0.601563 -1.75781,1.925782 h -0.47266 l 0.30078,-3.378907 c 0,0 0.32031,0 0.38672,0 0.17578,0.546875 0.64844,0.65625 1.10937,0.652344" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none" inkscape:connector-curvature="0"/>
              </g>
              <path id="path359" d="m -16.118716,111.63329 v 0.17226 c -0.265963,0.0152 -0.427193,0.19705 -0.547081,0.36655 0,0 -1.175466,1.81212 -1.175466,1.81212 v 1.47864 c 0,0.58842 0.213596,0.63114 0.566374,0.63114 0,0 0.06477,0 0.09784,0 0,0.0331 0,0.13505 0,0.1695 -0.04961,0 -2.060165,0 -2.109777,0 0,-0.0344 0,-0.13643 0,-0.1695 0.03168,0 0.09784,0 0.09784,0 0.366561,0 0.566374,-0.0923 0.566374,-0.5774 v -1.42213 l -1.276061,-1.82453 c -0.194306,-0.28112 -0.341753,-0.46715 -0.650434,-0.46715 h -0.03997 v -0.1695 h 1.912719 v 0.1695 h -0.05926 c -0.366558,0 -0.392741,0.19568 -0.237021,0.41755 l 0.989429,1.53237 0.873679,-1.38355 c 0.201192,-0.30179 0.259069,-0.56637 -0.237025,-0.56637 h -0.07579 v -0.1695 h 1.303624" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <g transform="matrix(0.35277778,0,0,0.35277778,-86.663248,94.330643)" id="g363" clip-path="url(#clip9)" style="clip-rule:nonzero">
                <path id="path361" d="m 206.38672,55.039063 c 0,3.242187 1.42969,6.730468 4.57422,6.730468 2.875,0 4.27734,-1.996093 4.27734,-6.101562 0,-3.015625 -1.60937,-6.21875 -4.59375,-6.21875 -3.95312,0 -4.25781,4.277344 -4.25781,5.589844 z m -2.4375,0.664062 c 0,-3.890625 2.95703,-6.9375 6.73437,-6.9375 4.11719,0 6.98828,2.664063 6.98828,6.480469 0,4.175781 -2.89843,7.210937 -6.89843,7.210937 -3.95313,0 -6.82422,-2.839843 -6.82422,-6.753906" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none" inkscape:connector-curvature="0"/>
              </g>
              <g transform="matrix(0.35277778,0,0,0.35277778,-86.663248,94.330643)" id="g367" clip-path="url(#clip10)" style="clip-rule:nonzero">
                <path id="path365" d="m 219.16797,62.167969 c 0,-0.09766 0,-0.382813 0,-0.476563 0.0781,0 0.1875,0 0.1875,0 0.75,0 1.4375,-0.140625 1.4375,-1.160156 V 50.6875 c 0,-1.019531 -0.6875,-1.160156 -1.4375,-1.160156 0,0 -0.10938,0 -0.1875,0 0,-0.09375 0,-0.378906 0,-0.476563 h 9.17187 l 0.0312,2.773438 c -0.0742,0.02344 -0.33593,0.08594 -0.4375,0.113281 -0.10547,-1.125 -0.36328,-2.203125 -1.92968,-2.203125 h -2.9961 v 5.132813 h 2.62891 c 1.08594,0 1.24219,-0.855469 1.25,-1.539063 0.0898,0 0.33594,0 0.43359,0 v 4.203125 c -0.0977,0 -0.33984,0 -0.42969,0 -0.0117,-0.820312 -0.20312,-1.863281 -1.55078,-1.863281 h -2.33203 v 4.863281 c 0,1.160156 0.98047,1.160156 1.84766,1.160156 0,0 0.0937,0 0.16406,0 0,0.09375 0,0.378907 0,0.476563 h -5.85156" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none" inkscape:connector-curvature="0"/>
              </g>
              <path id="path369" d="m -57.393717,121.21755 c 0,-0.86403 0.350022,-1.71153 0.952225,-2.25172 0.559483,-0.5016 1.293978,-0.78272 2.123557,-0.78272 0.741384,0 1.361501,0.13367 1.96646,0.41616 l 0.06063,1.34497 -0.190169,0.0248 c -0.219108,-0.77997 -0.58291,-1.49379 -1.813499,-1.49379 -1.263661,0 -2.049142,1.00183 -2.049142,2.61138 0,1.43454 0.635275,2.79053 2.173166,2.79053 0.86403,0 1.480013,-0.32384 1.94579,-0.92191 l 0.151584,0.28526 c -0.523655,0.67799 -1.333941,1.03766 -2.254471,1.03766 -1.872753,0 -3.066135,-1.10519 -3.066135,-3.06062" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path371" d="m -44.87424,119.44126 c 0,0 -0.191548,3.58565 -0.191548,3.58565 -0.03583,0.79513 0.210841,0.86403 0.744143,0.8847 h 0.04961 v 0.21084 h -1.956812 v -0.21084 h 0.07442 c 0.658699,-0.0262 0.700041,-0.39274 0.730359,-0.9288 l 0.227376,-3.67109 c 0.0303,-0.50161 -0.243914,-0.78548 -0.706935,-0.78548 0,0 -0.03583,0 -0.06615,0 0,-0.0455 0,-0.16537 0,-0.21084 0.07166,0 1.597149,0 1.644001,0 0.0193,0.0455 1.971972,4.40007 1.971972,4.40007 0,0 1.845193,-4.3546 1.865862,-4.40145 0.04548,0 1.610928,0 1.610928,0 v 0.2136 h -0.03168 c -0.653193,0 -0.768946,0.20395 -0.719339,1.02388 l 0.224621,3.85161 c 0.03447,0.45062 0.270097,0.49196 0.715204,0.5085 0,0.0441 0,0.16261 0,0.20946 -0.07304,0 -2.337153,0 -2.410188,0 0,-0.0469 0,-0.16536 0,-0.21084 0.0069,0 0.01655,0 0.01655,0 0.39274,-0.0234 0.675238,-0.04 0.675238,-0.43408 l -0.0069,-0.41617 c 0,-10e-4 -0.177765,-3.71381 -0.177765,-3.71381 0,0 -1.987134,4.77215 -2.007803,4.819 -0.03168,0 -0.143316,0 -0.17501,0 -0.0193,-0.0482 -2.100132,-4.72391 -2.100132,-4.72391" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path373" d="m -21.556454,118.59376 -0.0014,4.55993 c 0,0.61598 0.260448,0.7152 0.883324,0.7152 1.467608,0 2.13458,-1.26366 2.13458,-2.50114 0,-1.92512 -0.79375,-2.80017 -2.426726,-2.80017 -0.144692,0 -0.451997,0.0124 -0.589799,0.0262 z m -1.706012,5.53007 v -0.21222 h 0.08268 c 0.330729,0 0.636655,-0.062 0.636655,-0.51263 V 119.043 c 0,-0.45062 -0.305926,-0.51263 -0.636655,-0.51263 h -0.08268 v -0.21359 l 2.596222,-10e-4 c 0.964628,0 1.773537,0.24254 2.338532,0.76757 0.55535,0.51814 0.850251,1.25126 0.850251,2.12218 0,0.81442 -0.325219,1.60128 -0.888834,2.16214 -0.567754,0.56362 -1.364259,0.75516 -2.169033,0.75516 l -2.727138,0.001" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path375" d="m -12.535817,123.82479 v -1.42351 c 0,-0.31006 -0.227376,-0.47542 -0.655948,-0.47542 h -0.06752 v -0.20671 h 2.232421 v 0.20671 h -0.06752 c -0.312815,0 -0.47818,0.16536 -0.47818,0.47542 l -0.0014,1.58475 c -0.531922,0.17225 -1.247122,0.3073 -2.040872,0.3073 -1.916854,0 -3.15571,-1.24299 -3.15571,-3.16536 0,-2.04363 1.634356,-2.97656 3.172244,-2.97656 0.687642,0 1.395953,0.13781 1.843815,0.28801 l 0.09233,1.38631 -0.194303,0.011 c -0.241156,-0.9977 -0.684887,-1.38906 -1.68534,-1.38906 -1.3491,0 -2.166278,0.99494 -2.166278,2.59485 0,1.47036 0.690397,2.92833 2.231045,2.92833 0.355533,0.008 0.723469,-0.0469 0.9412,-0.14608" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path377" d="m -34.967524,120.96261 c 0.731739,0.0537 1.120345,0.21497 1.44694,0.54984 0.253559,0.25907 0.38723,0.58704 0.38723,0.96876 0,0.91088 -0.836468,1.64124 -1.922364,1.64124 h -2.844271 v -0.21084 h 0.114378 c 0.282497,0 0.61185,-0.13505 0.61185,-0.49471 v -4.21267 c 0,-0.67248 -0.398254,-0.67248 -0.61185,-0.67248 h -0.114378 v -0.21222 l 2.578312,-0.001 c 1.209915,0 1.875507,0.43821 1.875507,1.26917 0,0.92053 -0.808908,1.2609 -1.521354,1.37528 m -1.189245,-2.43086 v 2.33164 h 0.435458 c 0.80064,0 1.241612,-0.3886 1.241612,-1.12999 0,-0.81993 -0.387227,-1.20165 -1.152038,-1.20165 z m 0,2.5852 v 2.04363 c 0,0.56775 0.180523,0.72898 0.768946,0.72898 0.706931,0 1.241612,-0.58153 1.241612,-1.3739 0,-0.89297 -0.544326,-1.39871 -1.453833,-1.39871 h -0.556725" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path379" d="m -49.599532,119.50189 0.811664,2.26136 h -1.624708 z m 0.100598,-1.18511 c 0,0 -1.842439,5.01192 -1.842439,5.01192 -0.136426,0.35691 -0.377582,0.57602 -0.735872,0.57602 h -0.01929 v 0.21773 h 1.766646 v -0.21773 h -0.07717 c -0.425813,0 -0.715204,-0.13642 -0.530546,-0.68488 l 0.423058,-1.17134 h 1.828656 l 0.45751,1.27744 c 0.132292,0.40239 -0.03996,0.58429 -0.4768,0.58429 h -0.05099 v 0.21498 h 2.248958 v -0.21498 h -0.01792 c -0.299032,0 -0.504359,-0.15709 -0.64492,-0.55535 l -1.89067,-5.03673 -0.438214,-0.001" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
              <path id="path381" d="m -36.559158,111.63329 0.01242,0.97979 c 0,0 -0.118512,0.0289 -0.155719,0.04 -0.03583,-0.42857 -0.132292,-0.77721 -0.817175,-0.77721 h -0.919152 v 1.80936 h 0.789616 c 0.38723,0 0.491959,-0.21635 0.536056,-0.5898 0.0303,0 0.124023,0 0.157096,0 0,0.0496 0,1.51171 0,1.51171 l -0.157096,0.003 c -0.02342,-0.36105 -0.108863,-0.64217 -0.533301,-0.64217 h -0.792371 v 1.58888 c 0,0.46164 0.398251,0.46164 0.818554,0.46164 0.756543,0 1.106565,-0.0468 1.318782,-0.81304 0.0303,0.008 0.154341,0.0344 0.154341,0.0344 l -0.212217,1.02113 c 0,0 -3.384462,0 -3.434073,0 0,-0.0344 0,-0.13505 0,-0.1695 0.02618,0 0.06477,0 0.06477,0 0.263204,0 0.507118,-0.0496 0.507118,-0.40928 v -3.47127 c 0,-0.35829 -0.243914,-0.4079 -0.507118,-0.4079 0,0 -0.03859,0 -0.06477,0 0,-0.0345 0,-0.13505 0,-0.1695 0.04961,0 3.234256,0 3.234256,0" style="fill:#211e1e;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.35277778" inkscape:connector-curvature="0"/>
            </g>
            </g>
        </svg>
      </div> <!-- /segment.edu -->
    </div> <!-- /brandsCont -->

    <div class="proActionCont">
      <a href="/extra" target="_blank">Join as PRO</a>
    </div> <!-- /proActionCont -->
  </aside>
</template>


</div>

<div class="dropdownCont center hidden" data-popover-ref="saveInfo">
  <div class="dcWrapper info">
    <p><strong>Save anonymous (public) fiddle?</strong></p>
    <p>- Be sure not to include <strong>personal data</strong><br>- Do not include <strong>copyrighted material</strong></p>
    <p class="warning"><strong>Log in</strong> if you\'d like to <strong>delete this fiddle</strong> in the future.</p>
    <button id="save">Save</button>
  </div>
</div>

<div class="dropdownCont center hidden" data-popover-ref="forkInfo">
  <div class="dcWrapper info">
    <p><strong>Fork anonymous (public) fiddle?</strong></p>
    <p>- Be sure not to include <strong>personal data</strong><br>- Do not include <strong>copyrighted material</strong></p>
    <p class="warning"><strong>Log in</strong> if you\'d like to <strong>delete this fiddle</strong> in the future.</p>
    <button id="fork">Fork</button>
  </div>
</div>

<div class="dropdownCont center hidden" data-popover-ref="embed">
  <div class="dcWrapper embed">

    <div id="creator">
      <section>
        <h3>Tabs:</h3>
        <div class="inlineFields">
          <label class="inputCont_checkbox checkboxCont">
            <input type="checkbox" name="tabs" value="js" checked>
            <span class="checkbox"><i class="bts bt-check"></i></span> JavaScript
          </label>
          <label class="inputCont_checkbox checkboxCont">
            <input type="checkbox" name="tabs" value="html" checked>
            <span class="checkbox"><i class="bts bt-check"></i></span> HTML
          </label>
          <label class="inputCont_checkbox checkboxCont">
            <input type="checkbox" name="tabs" value="css" checked>
            <span class="checkbox"><i class="bts bt-check"></i></span> CSS
          </label>
          <label class="inputCont_checkbox checkboxCont">
            <input type="checkbox" name="tabs" value="result" checked>
            <span class="checkbox"><i class="bts bt-check"></i></span> Result
          </label>
        </div> <!-- /inlineFields -->
      </section>

      <section class="noborder">
        <h3>Visual:</h3>
        <div class="inlineFields">
          <label class="inputCont_checkbox checkboxCont">
            <input type="radio" name="skin" value="light" checked>
            <span class="radio"></span> Light
          </label>
          <label class="inputCont_checkbox checkboxCont">
            <input type="radio" name="skin" value="dark">
            <span class="radio"></span> Dark
          </label>
        </div> <!-- /inlineFields -->
        <label class="inputCont_text">
          <input type="text" name="accentColor" maxlength="7" placeholder="Accent color">
        </label>
        <label class="inputCont_text">
          <input type="text" name="fontColor" maxlength="7" placeholder="Font color">
        </label>
        <label class="inputCont_text">
          <input type="text" name="menuColor" maxlength="7" placeholder="Menu background">
        </label>
        <label class="inputCont_text">
          <input type="text" name="bodyColor" maxlength="7" placeholder="Code background">
        </label>
      </section>

      <section class="noborder">
        <h3>
          Embed snippet
          <a href="#" class="codeTypeToggle">Prefer iframe?</a>:
        </h3>
        <div class="embedCodeWrap">
<textarea class="embedCode" id="share_embedded_dropdown" data-view="embed" data-pattern-value=\'<script async src="{embedSrc}"></script>\'>
<script async src="{embedSrc}"></script>
</textarea>
        </div> <!-- /embedCodeWrap -->

        <div class="embedCodeWrap hidden">
<textarea class="embedCode" data-view="embedded" data-pattern-value=\'<iframe width="100%" height="300" src="{embedSrc}" allowfullscreen="allowfullscreen" allowpaymentrequest frameborder="0"></iframe>\'>
<iframe width="100%" height="300" src="{embedSrc}" allowfullscreen allowpaymentrequest frameborder="0"></iframe>
</textarea>
          <p><strong>No autoresizing</strong> to fit the code</p><p><strong>Render blocking</strong> of the parent page</p>
        </div> <!-- /embedCodeWrap -->
      </section>
    </div> <!-- /creator -->

    <div id="preview"></div> <!-- /preview -->
  </div> <!-- /dcWrapper -->
</div> <!-- /dropdownCont -->

        <div id="progressbar"><div class="pb"></div></div>
      </header>

        <main id="layout-container">
          <div id="sidebar">
            <section id="s-cont">
              <div id="profile-segment" class="hidden">
                
              </div>

              <div class="sidebarItem">
  <h3 class="toggler" title="Posted on 04 12 2014">
    Fiddle meta
  </h3>
  <div class="body">
    <p>
      <input type="text" name="title" placeholder="Untitled fiddle" value="">
    </p>

    <p>
      <textarea rows="10" cols="40" name="description" placeholder="No description"></textarea>
    </p>

    <p class="privateFiddleCont">
      <label class="checkboxCont proBadge">
        <input type="checkbox" name="is_private" value="1"  disabled>
        <span class="checkbox"></span>
        Private fiddle
        <a class="proBadgeSelf" href="/extra/" target="_blank">PRO</a>
      </label>
    </p>
  </div> <!-- /body -->
</div> <!-- /sidebarItem -->

              <div class="sidebarItem">
  <h3 class="toggler proBadge">
    Groups <a class="proBadgeSelf" href="/extra/" target="_blank">PRO</a>
  </h3>
  <div class="body">
    <ul class="groupsList toggleGroupPrivacy">
</ul> <!-- .groupsList -->


    <div id="choices-select"></div>
  </div> <!-- /body -->
</div> <!-- /sidebarItem -->

<script src="/js/Groups.js?d901fe79210280c7c60ca4dd00f7fb144c1fdcca"></script>

              <script type="text/javascript">
  var resources = []
</script>

<div class="sidebarItem">
  <h3 class="toggler ">
    Resources <strong class="resourcesLabel">URL</strong> <strong class="resourcesLabel">cdnjs</strong>
    <em id="resource-counter" class="hidden">0</em>
  </h3>

  <div class="body">
    <ul id="external_resources_list">
    </ul>

    <div id="external-resources-form">
      <p>
        <input id="external_resource" type="text" name="q" value="" placeholder="JavaScript/CSS URL">
        <a id="add_external_resource" class="submit" href="#" title="Add resource">
          <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-plus-circle"><circle cx="12" cy="12" r="10"></circle><line x1="12" y1="8" x2="12" y2="16"></line><line x1="8" y1="12" x2="16" y2="12"></line></svg>
        </a>
      </p>
    </div>
    <input type="hidden" value="" id="external_resources_id" name="add_external_resources">

    <ul class="resourcesInfo">
      <li>Paste a direct CSS/JS URL</li>
      <li>Type a library name to fetch from CDNJS</li>
    </ul>
  </div> <!-- /body -->
</div> <!-- /sidebarItem -->

              <div class="sidebarItem">
  <h3 class="toggler">
    Async requests
  </h3>
  <div class="body">
    <p><code>/echo</code> simulates Async calls:<br>
      JSON: <code>/echo/json/</code><br>
      JSONP: <code>//jsfiddle.net/echo/jsonp/</code><br>
      HTML: <code>/echo/html/</code><br>
      XML: <code>/echo/xml/</code>
    </p>
    <p>See <a href=\'https://jsfiddle.gitbook.io/help/async-requests\' target=\'_new\'>docs</a> for more info.</p>
  </div> <!-- /body -->
</div> <!-- /sidebarItem -->

              <div class="sidebarItem">
  <h3 class="toggler">
    Other (links, license)
  </h3>
  <div class="body">
    <p class="maintainers">Created and maintained by <a title="Piotr\'s twitter" href="https://twitter.com/zalun" target="_blank" rel="noopener">Piotr</a> and <a title="UX and UI Designer" href="https://twitter.com/oskar" target="_blank" rel="noopener">Oskar</a>.</p>
    <p>Hosted on <a href="https://m.do.co/c/52e7a0ad196d" target="_blank" rel="noopener"><strong>DigitalOcean</strong></a></p>
    <p><strong></strong></p>
    <p>All code belongs to the poster and no license is enforced. JSFiddle or its authors are not responsible or liable for any loss or damage of any kind during the usage of provided code.</p>
    <p><strong>Links</strong></p>
    <p>
      <a href="https://github.com/jsfiddle/jsfiddle-issues/issues" target="_blank" rel="noopener">Bug tracker</a><br>
      <a href="https://jsfiddle.net/about" target="_blank" rel="noopener">About</a><br>
      <a href="https://docs.jsfiddle.net" target="_blank" rel="noopener">Docs</a><br>
      <a href="http://status.jsfiddle.net" target="_blank" rel="noopener">Service status</a>
    </p>
  </div> <!-- /body -->
</div> <!-- /sidebarItem -->

<style media="screen">
  .maintainers {
    position: absolute;
    top: -900em;
    left: -900em;
  }
</style>

              <div class="sidebarItem">
  <h3 class="toggler">
    Removal request
  </h3>
  <div class="body">
    <ul id="manage-fiddle">
      <li>
        <a class="delete" href="https://airtable.com/appMEh63DBhO9WpmH/pagFRUTEsijk4lDHt/form" target="_blank">
          <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none"
          stroke="currentColor" stroke-width="1.4" stroke-linecap="round" stroke-linejoin="round"
          class="feather feather-trash-2"><polyline points="3 6 5 6 21 6"></polyline><path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"></path><line x1="10" y1="11" x2="10" y2="17"></line><line x1="14" y1="11" x2="14" y2="17"></line>
          </svg>Submit a removal request
        </a>
      </li>
    </ul>
  </div> <!-- /body -->
</div> <!-- /sidebarItem -->

            </section>
              <section id="s-bottom">
                <div class="twitterCont">
    <!-- <script async type="text/javascript" src="//cdn.carbonads.com/carbon.js?zoneid=1673&serve=C6AILKT&placement=jsfiddlenet" id="_carbonads_js"></script> -->
    <script type="text/javascript" src="//cdn.carbonads.com/carbon.js?serve=CKYIEKQ7&placement=jsfiddlenet" id="_carbonads_js"></script>
  <div id="ethical-sponsor" data-ea-publisher="jsfiddlenet" data-ea-manual="true"></div>
</div>

<!-- <div id="support-jsfiddle">
  <h3>Support the development of JSFiddle and get extra features ✌🏻</h3>
  <a href="/extra/">Become a supporter</a>
</div> -->

<!-- <div id="fallback">
  <a href="https://instagram.com/oskarkrawczyk" target="_blank">
    <h3>Lifestyle, adventure and backstage photographer based in Warsaw, Poland.</h3>
    <img src="/img/fallback/logo-adunit.jpg" />
  </a>
</div> -->

<!-- <div id="fallback">
  <a href="https://pixelpeeper.com/exif-data-viewer?utm_source=jsfiddle" target="_blank">
    <h3>Exif Data Viewer: turn JPG files into Lightroom presets.</h3>
    <img src="/img/fallback/logo-adunit.jpg" />
  </a>
</div> -->

              </section>
          </div> <!-- #sidebar -->
          <div id="content">
            <div id="editor"></div>

<div class="windowSettings html hidden" data-panel="html" data-popover-ref="html">
  <h3>Language</h3>
<div class="selectCont">
  <select name="panel_html" class="panelChoice" id="panel_html_choice" data-panel_id="id_code_html" data-panel="html">
      <option data-mime-type="text/html" value="0"  selected>HTML</option>
      <option data-mime-type="text/x-haml" value="1" >HAML</option>
  </select>
  <label>
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.4" stroke-linecap="round" stroke-linejoin="round"><polyline points="6 9 12 15 18 9" /></svg>
  </label>
</div> <!-- /selectCont -->

<h3>Doctype</h3>
<div class="selectCont">
  <select name="doctype">
      <option  id="dtd_XHTML 1.0 Strict" value="1">XHTML 1.0 Strict</option>
      <option  id="dtd_XHTML 1.0 Transitional" value="2">XHTML 1.0 Transitional</option>
      <option selected id="dtd_HTML 5" value="3">HTML 5</option>
      <option  id="dtd_HTML 4.01 Strict" value="4">HTML 4.01 Strict</option>
      <option  id="dtd_HTML 4.01 Transitional" value="5">HTML 4.01 Transitional</option>
      <option  id="dtd_HTML 4.01 Frameset" value="6">HTML 4.01 Frameset</option>
  </select>
  <label>
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.4" stroke-linecap="round" stroke-linejoin="round"><polyline points="6 9 12 15 18 9" /></svg>
  </label>
</div>

<h3>Body tag</h3>
<p>
  <label>
    <input id="id_body_tag" type="text" name="body_tag" maxlength="255" value="">
  </label>
</p>

</div> <!-- /windowSettings -->

<div class="windowSettings js hidden" data-panel="js" data-popover-ref="js">
  <h3>Language</h3>
<div class="selectCont">
  <select name="panel_js" class="panelChoice" id="panel_js_choice" data-panel_id="id_code_js" data-panel="js">
      <option data-mime-type="text/javascript" value="0"  selected>JavaScript</option>
      <option data-mime-type="text/coffeescript" value="1" >CoffeeScript</option>
      <option data-mime-type="application/javascript" value="2" >JavaScript 1.7</option>
      <option data-mime-type="text/jsx" value="3" >Babel + JSX</option>
      <option data-mime-type="text/typescript" value="4" >TypeScript</option>
      <option data-mime-type="text/coffeescript" value="5" >CoffeeScript 2</option>
      <option data-mime-type="text/javascript" value="6" >Vue</option>
      <option data-mime-type="text/jsx" value="7" >React</option>
      <option data-mime-type="text/jsx" value="8" >Preact</option>
  </select>
  <label>
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.4" stroke-linecap="round" stroke-linejoin="round"><polyline points="6 9 12 15 18 9" /></svg>
  </label>
</div> <!-- /selectCont -->

<h3>Frameworks &amp; Extensions</h3>
<div class="panelExtrasChoice">
  <div class="selectCont">
    <select name="js_lib" id="js_lib">
        <optgroup label="Alpine.js">
          <option value="409" >Alpine.js 2.1.2</option>
        <optgroup label="AngularJS">
          <option value="137" >AngularJS 1.1.1</option>
          <option value="180" >AngularJS 1.2.1</option>
          <option value="283" >AngularJS 1.4.8</option>
          <option value="281" >AngularJS 2.0.0-alpha.47</option>
        <optgroup label="Bonsai">
          <option value="120" >Bonsai 0.4.1</option>
        <optgroup label="Brick">
          <option value="176" >Brick edge</option>
        <optgroup label="CreateJS">
          <option value="170" >CreateJS 2013.09.25</option>
          <option value="279" >CreateJS 2015.05.21</option>
        <optgroup label="D3">
          <option value="134" >D3 3.x</option>
          <option value="386" >D3 4.13.0</option>
          <option value="397" >D3 5.9.2</option>
        <optgroup label="Dojo">
          <option value="87" >Dojo (nightly)</option>
          <option value="372" >Dojo 1.4.8</option>
          <option value="370" >Dojo 1.5.6</option>
          <option value="368" >Dojo 1.6.5</option>
          <option value="366" >Dojo 1.7.12</option>
          <option value="364" >Dojo 1.8.14</option>
          <option value="362" >Dojo 1.9.11</option>
          <option value="360" >Dojo 1.10.8</option>
          <option value="358" >Dojo 1.11.4</option>
          <option value="356" >Dojo 1.12.2</option>
        <optgroup label="Ember">
          <option value="190" >Ember (latest)</option>
        <optgroup label="Enyo">
          <option value="115" >Enyo (nightly)</option>
          <option value="116" >Enyo 2.0.1</option>
          <option value="121" >Enyo 2.1</option>
          <option value="145" >Enyo 2.2.0</option>
          <option value="214" >Enyo 2.4.0</option>
          <option value="238" >Enyo 2.5.1</option>
          <option value="299" >Enyo 2.7.0</option>
        <optgroup label="ExtJS">
          <option value="23" >ExtJS 3.1.0</option>
          <option value="109" >ExtJS 3.4.0</option>
          <option value="107" >ExtJS 4.1.0</option>
          <option value="80" >ExtJS 4.1.1</option>
          <option value="147" >ExtJS 4.2.0</option>
          <option value="258" >ExtJS 5.0.0</option>
          <option value="256" >ExtJS 5.1.0</option>
          <option value="338" >ExtJS 6.2.0</option>
        <optgroup label="FabricJS">
          <option value="250" >FabricJS 1.5.0</option>
          <option value="342" >FabricJS 1.7.7</option>
          <option value="378" >FabricJS 1.7.15</option>
          <option value="380" >FabricJS 1.7.20</option>
        <optgroup label="Glow">
        <optgroup label="Inferno">
          <option value="336" >Inferno 1.0.0-beta9</option>
        <optgroup label="JSBlocks">
          <option value="252" >JSBlocks (edge)</option>
        <optgroup label="KineticJS">
          <option value="124" >KineticJS 4.0.5</option>
          <option value="139" >KineticJS 4.3.1</option>
        <optgroup label="Knockout.js">
          <option value="104" >Knockout.js 2.0.0</option>
          <option value="117" >Knockout.js 2.1.0</option>
          <option value="122" >Knockout.js 2.2.1</option>
          <option value="163" >Knockout.js 2.3.0</option>
          <option value="172" >Knockout.js 3.0.0</option>
          <option value="388" >Knockout.js 3.4.2</option>
        <optgroup label="Lo-Dash">
          <option value="167" >Lo-Dash 2.2.1</option>
        <optgroup label="Minified">
          <option value="164" >Minified 1.0 beta1</option>
        <optgroup label="MithrilJS">
          <option value="273" >MithrilJS 0.2.0</option>
          <option value="390" >MithrilJS 1.1.6</option>
        <optgroup label="Mootools">
          <option value="59" >Mootools (nightly)</option>
          <option value="62" >Mootools 1.3.2</option>
          <option value="63" >Mootools 1.3.2 (compat)</option>
          <option value="95" >Mootools 1.4.5</option>
          <option value="96" >Mootools 1.4.5 (compat)</option>
          <option value="216" >Mootools 1.5.1</option>
          <option value="263" >Mootools 1.5.2</option>
          <option value="329" >Mootools 1.5.2 (compat)</option>
          <option value="325" >Mootools 1.6.0</option>
          <option value="327" >Mootools 1.6.0 (compat)</option>
        <optgroup label="No-Library">
          <option value="11" selected>No-Library (pure JS)</option>
        <optgroup label="OpenUI5">
          <option value="271" >OpenUI5 (latest, mobile)</option>
        <optgroup label="Paper.js">
          <option value="158" >Paper.js 0.22</option>
        <optgroup label="Pixi">
          <option value="315" >Pixi 3.0.11</option>
          <option value="331" >Pixi 4.0.0</option>
        <optgroup label="Processing.js">
          <option value="67" >Processing.js 1.2.3</option>
          <option value="81" >Processing.js 1.3.6</option>
          <option value="135" >Processing.js 1.4.1</option>
          <option value="206" >Processing.js 1.4.7</option>
        <optgroup label="Prototype">
          <option value="4" >Prototype 1.6.1.0</option>
          <option value="265" >Prototype 1.7.3</option>
        <optgroup label="RactiveJS">
          <option value="287" >RactiveJS 0.7.3</option>
        <optgroup label="Raphael">
          <option value="30" >Raphael 1.4</option>
          <option value="36" >Raphael 1.5.2</option>
          <option value="76" >Raphael 2.1.0</option>
        <optgroup label="React">
          <option value="159" >React 0.3.2</option>
          <option value="166" >React 0.4.0</option>
          <option value="184" >React 0.8.0</option>
          <option value="192" >React 0.9.0</option>
          <option value="285" >React 0.14.3</option>
        <optgroup label="RightJS">
          <option value="45" >RightJS 2.1.1</option>
          <option value="136" >RightJS 2.3.1</option>
        <optgroup label="Riot">
          <option value="382" >Riot 3.7.4</option>
        <optgroup label="Shipyard">
          <option value="99" >Shipyard (nightly)</option>
          <option value="105" >Shipyard 0.2</option>
        <optgroup label="Thorax">
          <option value="143" >Thorax 2.0.0rc3</option>
          <option value="174" >Thorax 2.0.0rc6</option>
        <optgroup label="Three.js">
          <option value="82" >Three.js r54</option>
          <option value="399" >Three.js 105</option>
        <optgroup label="Underscore">
          <option value="111" >Underscore 1.3.3</option>
          <option value="133" >Underscore 1.4.3</option>
          <option value="160" >Underscore 1.4.4</option>
          <option value="267" >Underscore 1.8.3</option>
        <optgroup label="Vue">
          <option value="236" >Vue (edge)</option>
          <option value="289" >Vue 1.0.12</option>
          <option value="344" >Vue 2.2.1</option>
        <optgroup label="WebApp Install">
          <option value="142" >WebApp Install 0.1</option>
        <optgroup label="XTK">
          <option value="106" >XTK edge</option>
        <optgroup label="YUI">
          <option value="9" >YUI 2.8.0r4</option>
          <option value="102" >YUI 3.5.0</option>
          <option value="118" >YUI 3.6.0</option>
          <option value="123" >YUI 3.7.3</option>
          <option value="130" >YUI 3.8.0</option>
          <option value="153" >YUI 3.10.1</option>
          <option value="182" >YUI 3.14.0</option>
          <option value="204" >YUI 3.16.0</option>
          <option value="230" >YUI 3.17.2</option>
        <optgroup label="Zepto">
          <option value="90" >Zepto 1.0rc1</option>
        <optgroup label="jQuery">
          <option value="46" >jQuery (edge)</option>
          <option value="131" >jQuery 1.9.1</option>
          <option value="248" >jQuery 2.1.3</option>
          <option value="319" >jQuery 2.2.4</option>
          <option value="376" >jQuery 3.2.1</option>
          <option value="384" >jQuery 3.3.1</option>
          <option value="401" >jQuery 3.4.1</option>
        <optgroup label="jQuery Slim">
          <option value="407" >jQuery Slim 3.2.1</option>
          <option value="405" >jQuery Slim 3.3.1</option>
          <option value="403" >jQuery Slim 3.4.1</option>
        <optgroup label="jTypes">
          <option value="165" >jTypes 2.1.0</option>
        <optgroup label="qooxdoo">
          <option value="127" >qooxdoo 2.0.3</option>
          <option value="126" >qooxdoo 2.1</option>
        <optgroup label="svg.js">
          <option value="395" >svg.js 2.6.5</option>
          <option value="393" >svg.js 2.7.1</option>
          <option value="391" >svg.js 3.0.5</option>
    </select>
    <label>
      <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.4" stroke-linecap="round" stroke-linejoin="round"><polyline points="6 9 12 15 18 9" /></svg>
    </label>
  </div>

  <ul id="js_dependency">
    
  </ul>
</div>

<h3>Framework &lt;script&gt; attribute</h3>
<p class="libraryTagAttributes">
  <label>
    <input id="id_js_lib_option" type="text" name="js_lib_option" maxlength="255" placeholder=\'ie. data-type=""\' value="" />
  </label>
</p>

</div> <!-- /windowSettings -->

<div class="windowSettings css hidden" data-panel="css" data-popover-ref="css">
  <h3>Language</h3>
<div class="selectCont">
  <select name="panel_css" class="panelChoice" id="panel_css_choice" data-panel_id="id_code_css" data-panel="css">
      <option data-mime-type="text/css" value="0" selected>CSS</option>
      <option data-mime-type="text/x-scss" value="1" >SCSS</option>
      <option data-mime-type="text/x-sass" value="2" >SASS</option>
      <option data-mime-type="text/css" value="4" >PostCSS (Stage 0+)</option>
      <option data-mime-type="text/css" value="5" >PostCSS (Stage 3+)</option>
  </select>
  <label>
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.4" stroke-linecap="round" stroke-linejoin="round"><polyline points="6 9 12 15 18 9" /></svg>
  </label>
</div> <!-- /selectCont -->

<h3>Options</h3>
<p id="normalize_check">
  <label class="checkboxCont">
    <input type="checkbox" name="normalize_css" id="id_normalize_css" value="1" />
    <span class="checkbox"><i class="bts bt-check"></i></span> Normalized CSS
  </label>
</p>

</div> <!-- /windowSettings -->

<div id="problem-banner"></div>

          </div> <!-- #content -->

          
          <ul id="flash-messages" class="draft hidden">
  <li class="warning">
    <?xml version="1.0" encoding="UTF-8"?><svg version="1.1" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"><g stroke-linecap="round" stroke-width="2" fill="none" stroke-linejoin="round"><polyline points="23,4 23,10 17,10"></polyline><path d="M20.49 15l8.16053e-09-2.30983e-08c-1.65578 4.68667-6.79735 7.1437-11.484 5.48792 -4.68667-1.65578-7.1437-6.79735-5.48792-11.484 1.65578-4.68667 6.79735-7.1437 11.484-5.48792 1.26714.447675 2.41794 1.17344 3.36792 2.12402l4.63 4.36"></path></g></svg>
    This fiddle has previously unsaved changes.
    <span class="flashActions">
      <a id="apply-draft" href="#">Apply changes</a>
      <a id="discard-draft" href="#">Discard</a>
    </span>
  </li>
</ul>

        </main> <!-- #layout-container -->
    </form>

    <div id="modal-body">
      <div id="modal-app">
        <header>
          <h1>#</h1>
          <h2>#</h2>
        </header>
        <main id="modal-content"></main>
        <svg class="loader animate" xmlns="http://www.w3.org/2000/svg" width="28" height="28" viewBox="0 0 24 24"><g stroke-linecap="round" class="nc-icon-wrapper" fill="none" stroke="#222" stroke-width="2" stroke-linejoin="round"><path d="M12 2v4"></path><path d="M12 18v4"></path><path d="M4.93 4.93l2.83 2.83"></path><path d="M16.24 16.24l2.83 2.83"></path><path d="M2 12h4"></path><path d="M18 12h4"></path><path d="M4.93 19.07l2.83-2.83"></path><path d="M16.24 7.76l2.83-2.83"></path></g></svg>
        <a id="close-modal" href="#"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><g stroke-linecap="round" class="nc-icon-wrapper" fill="none" stroke="#222222" stroke-width="2" stroke-linejoin="round"><path d="M18 6L6 18"></path><path d="M6 6l12 12"></path></g></svg></a>
      </div>
    </div>

    <template id="modal-help-jsfiddle">
  <main>
    <h2>Keep JSFiddle running.<br><strong>Whitelist</strong> us in your content blocker.</h2>

    <div class="helpCont">
      <p>We\'ve been providing web developers, educators, students, companies with JSFiddle <strong>free for many years</strong>.</p>
      <p><strong>Your can help us in one of two ways:</strong></p>
      <ul>
        <li><strong class="whitelist">Whitelist JSFiddle</strong> in your content blocker</li>
        <li><a href="/extra" target="_blank">Go PRO</a> and get access to additional PRO features →</li>
      </ul>
    </div>
  </main>

  <aside>
    <ul class="perks">
      <li>
        <em>
          <svg version="1.1" viewBox="0 0 24 24">
            <path d="M12,2l3.09,6.26l6.91,1.01l-5,4.87l1.18,6.88l-6.18,-3.25l-6.18,3.25l1.18,-6.88l-5,-4.87l6.91,-1.01l3.09,-6.26Z" stroke-linecap="round" stroke-width="2" fill="none" stroke-linejoin="round"></path>
          </svg>
        </em>
        <section>
          <h3>Ad-free</h3>
          <p>All ads in the editor and listing pages are turned completely off.</p>
        </section>
      </li>
      <li>
        <em>
          <svg viewBox="0 0 24 24"><g stroke-linejoin="round" stroke-linecap="round" stroke-width="2" fill="none"><path d="M4 15s1-1 4-1 5 2 8 2 4-1 4-1V3s-1 1-4 1-5-2-8-2-4 1-4 1z"></path><path d="M4 22v-7"></path></g></svg>
        </em>
        <section>
          <h3>Use pre-released features</h3>
          <p>You get to try and use features (like the Palette Color Generator) months before everyone else.</p>
        </section>
      </li>
      <li>
        <em>
          <svg version="1.1" viewBox="0 0 24 24">
            <g stroke-linecap="round" stroke-width="1.8" fill="none" stroke-linejoin="round">
              <path d="M12.89,1.45l8,4l1.83254e-07,9.10609e-08c0.679658,0.33773 1.1096,1.03106 1.11,1.79v9.53l4.31591e-08,-8.47154e-05c-0.000370578,0.758944 -0.430281,1.45229 -1.10992,1.79005l-8,4l5.5497e-08,-2.77707e-08c-0.563368,0.28191 -1.22663,0.28191 -1.79,5.55414e-08l-8,-4l-2.93338e-07,-1.47804e-07c-0.679008,-0.342131 -1.10529,-1.03969 -1.1,-1.8v-9.51996l-4.32445e-08,8.48903e-05c0.000370512,-0.758944 0.430281,-1.45229 1.10992,-1.79005l8,-4l1.55256e-07,-7.71484e-08c0.560633,-0.278585 1.21937,-0.278585 1.78,1.54297e-07Z"></path>
              <path d="M2.32,6.16l9.68,4.84l9.68,-4.84"></path>
              <path d="M12,22.76v-11.76"></path>
              <path d="M7,3.5l10,5"></path>
            </g>
          </svg>
        </em>
        <section>
          <h3>Fiddle groups</h3>
          <p>Sort and categorize your Fiddles into multiple groups.</p>
        </section>
      </li>
      <li>
        <em>
          <svg version="1.1" viewBox="0 0 24 24">
            <g stroke-linecap="round" stroke-width="1.8" fill="none" stroke-linejoin="round">
              <path d="M1,12c0,0 4,-8 11,-8c7,0 11,8 11,8c0,0 -4,8 -11,8c-7,0 -11,-8 -11,-8Z"></path>
              <path d="M14.1213,9.87868c1.17157,1.17157 1.17157,3.07107 0,4.24264c-1.17157,1.17157 -3.07107,1.17157 -4.24264,0c-1.17157,-1.17157 -1.17157,-3.07107 0,-4.24264c1.17157,-1.17157 3.07107,-1.17157 4.24264,0"></path>
            </g>
          </svg>
        </em>
        <section>
          <h3>Private groups and fiddles</h3>
          <p>You can make as many Private Fiddles, and Private Groups as you wish!</p>
        </section>
      </li>
      <li>
        <em>
          <svg version="1.1" viewBox="0 0 24 24">
            <g stroke-linecap="round" stroke-width="1.8" fill="none" stroke-linejoin="round">
              <path d="M4,17l6,-6l-6,-6"></path>
              <path d="M12,19h8"></path>
            </g>
          </svg>
        </em>
        <section>
          <h3>Console</h3>
          <p>Debug your Fiddle with a minimal built-in JavaScript console.</p>
        </section>
      </li>
    </ul>
  </aside>
</template>


    <script>
      window.addEventListener("DOMContentLoaded", function(){
        var loadEditor = function(){
          Layout.skin = "light"

          $extend(Layout, new Events())

          Actions = new EditorActions()


          Layout.render()

            Layout.adbd()

        }

        var themeHref = "/css/dist-editor-dark.css?d901fe79210280c7c60ca4dd00f7fb144c1fdcca"
        var script = document.createElement("script")
        script.src = "/js/_dist-editor.js?d901fe79210280c7c60ca4dd00f7fb144c1fdcca"

        var styleEditor    = document.createElement("link")
        styleEditor.rel    = "stylesheet"
        styleEditor.type   = "text/css"
        styleEditor.id     = "editor-theme"
        styleEditor.href   = themeHref
        document.body.appendChild(styleEditor)

        script.onload = loadEditor
        styleEditor.onload = function(){
          document.body.appendChild(script)
        }
      })
    </script>

    

      <script src="//m.servedby-buysellads.com/monetization.js" type="text/javascript"></script>
      <script>
      (function() {
        if (typeof _bsa !== \'undefined\' && _bsa) {
          _bsa.init(\'stickybox\', \'CKYD52JI\', \'placement:jsfiddlenet-custom\');
        }
      })();
      </script>

  <script>(function(){function c(){var b=a.contentDocument||a.contentWindow.document;if(b){var d=b.createElement(\'script\');d.innerHTML="window.__CF$cv$params={r:\'891a90a5cc6c3c9e\',t:\'MTcxODAzNTEyOS4wMDAwMDA=\'};var a=document.createElement(\'script\');a.nonce=\'\';a.src=\'/cdn-cgi/challenge-platform/scripts/jsd/main.js\';document.getElementsByTagName(\'head\')[0].appendChild(a);";b.getElementsByTagName(\'head\')[0].appendChild(d)}}if(document.body){var a=document.createElement(\'iframe\');a.height=1;a.width=1;a.style.position=\'absolute\';a.style.top=0;a.style.left=0;a.style.border=\'none\';a.style.visibility=\'hidden\';document.body.appendChild(a);if(\'loading\'!==document.readyState)c();else if(window.addEventListener)document.addEventListener(\'DOMContentLoaded\',c);else{var e=document.onreadystatechange||function(){};document.onreadystatechange=function(b){e(b);\'loading\'!==document.readyState&&(document.onreadystatechange=e,c())}}}})();</script></body>
</html>
'
];
