<?php
declare(strict_types = 1);

return [
    'headers' => [
        'server' => [
            'awselb/2.0',
            'nginx/1.18.0 (Ubuntu)'
        ],
        'date' => [
            'Mon, 10 Jun 2024 15:59:11 GMT',
            'Mon, 10 Jun 2024 15:59:12 GMT'
        ],
        'content-type' => [
            'text/html',
            'text/html; charset=utf-8'
        ],
        'content-length' => [
            '134'
        ],
        'connection' => [
            'keep-alive'
        ],
        'location' => [
            'https://slides.com:443/alexwalker/responsive-svg/  HTTP/2 200'
        ],
        'x-xss-protection' => [
            '1; mode=block'
        ],
        'x-content-type-options' => [
            'nosniff'
        ],
        'x-download-options' => [
            'noopen'
        ],
        'x-permitted-cross-domain-policies' => [
            'none'
        ],
        'referrer-policy' => [
            'strict-origin-when-cross-origin'
        ],
        'vary' => [
            'Accept,Accept-Encoding'
        ],
        'content-encoding' => [
            'gzip'
        ],
        'set-cookie' => [
            '_slides_app_session=RjgxaGJGVDZtYW5KWGoyOWczU0JGZ3dqQTBWa0lBWlM4NW44dDM5WGcyNzRYeTVvZ3lqM093UW5FZTYxUDdPcU81M2hodHNGY2NHR09KTlk3c1dlVGdtNzdWbzZtUit5aDFqTm1aVXJ0S2xkWmVKb2dUYmU1SERFMURjVVpHaG8rdmVpT1laRk5nVHdQS2pPNEx0M1A3SnNZTjhFTEt0aEl2d3BVbnhmb3VuNmVzZzhlVVpmL1dzN1dlZERZTzc1dDNRZEdEMkphVHlKUm9LY1NSWEtmc2J2R0pOZHVFUmJDcVZkbENpNVVLNFB5Z0Y0MVBUbHhIVytuRFFqNnpVUWNJektOZXppTDA5dDJRUGE5L2VRSWQ1MVVBNlByald4bVg3SHQwWkhPSXdyei9TMVViMEU2ZUE5UmJKM3NraUlNTm1sbWtiUXU1RFBuSDBVNnNaL1ZISDQ4RkxpYis2K0szNnNUNHlPTS9IeHd5Uk5rMFdlbVVPd0Zva3JkVk9RLS1Fd3gvRlZJZG5WQ2k4NTRuU09ObFFBPT0%3D--1c80ee86feceab3b1c268a246078fc14f35726a6; domain=.slides.com; path=/; secure; HttpOnly'
        ],
        'x-request-id' => [
            'd556abf1-07ae-44a3-9543-0765282093e6'
        ],
        'x-runtime' => [
            '0.032674'
        ],
        'Content-Location' => [
            'https://slides.com:443/alexwalker/responsive-svg/'
        ],
        'X-Request-Time' => [
            '0.836 ms'
        ]
    ],
    'statusCode' => 200,
    'reasonPhrase' => 'OK',
    'body' => '<!DOCTYPE html>
<html class="sl-root decks show " data-account=""  lang="en">
  <head>
    <meta charset="utf-8" />

    <title>responsive-svg</title>
    <meta name="description" content="A presentation created with Slides." />
    <meta name="viewport" content="initial-scale=1.0" />

    <meta name="theme-color" content="#2f2f33" />

    <meta property="og:title" content="responsive-svg" />
    <meta property="og:description" content="A presentation created with Slides." />
    <meta property="og:site_name" content="Slides" />
    <meta property="og:image" content="https://media.slid.es/thumbnails/alexwalker/0b188c/responsive-svg.jpg" />
    <meta property="og:type" content="article" />
    <meta property="og:url" content="https://slides.com/alexwalker/responsive-svg" />
    <meta property="fb:app_id" content="146002942236376" />

    <meta name="mobile-web-app-capable" content="yes" />
    <meta name="apple-mobile-web-app-capable" content="yes" />
    <meta name="msapplication-tap-highlight" content="no" />

    <link rel="icon" href="/favicon.ico">
    <link rel="canonical" href="https://slides.com/alexwalker/responsive-svg" />
    <link rel="manifest" href="/manifest.json">

    <link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600&display=swap" media="print" onload="this.onload=null;this.removeAttribute(\'media\');" rel="stylesheet" data-application-font="inter">
<noscript>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600&display=swap" rel="stylesheet" data-application-font="inter">
</noscript>

    <link rel="stylesheet" media="all" href="//assets-v2.slid.es/assets/slides/slides-9c25ece2476c8bf5a292aee738b856615560afa562b87317c421312b668451c1.css" />
    <link rel="stylesheet" media="all" href="//assets-v2.slid.es/assets/deck-consumption-15dfe52c7ad1669cb54f3f68ebb272736608c157c8bccefcc9383d2ab90216c9.css" />
    	<link rel="stylesheet" media="all" href="//assets-v2.slid.es/assets/deck-v2-11e5d4704233d3de6917951f950813fbca871e294b5bafc56fd910a2c390009a.css" />



<style id="user-css-output" type="text/css"></style>

    <meta name="csrf-param" content="authenticity_token" />
<meta name="csrf-token" content="K9ADjhBZtbWmCFf019vMDxHL+2OAgBSdSlRJmAMSUph5SbaNsZlLMkYKV9LERtkC2WBVATuILFgwSNs+/XwiHQ==" />
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-LWVDH9STBJ"></script>
<script type="text/javascript">
  if( navigator.doNotTrack !== \'1\' && !/dnt=1/.test( window.location.search ) ) {
    window.slidesMeasurementId = \'G-LWVDH9STBJ\';
    window.dataLayer = window.dataLayer || [];
    function gtag(){dataLayer.push(arguments);}
    gtag(\'js\', new Date());
    gtag(\'config\', \'G-LWVDH9STBJ\', {
      page_title: \'decks-show\'
    });

  }
</script>
<script type="text/javascript">
    !function(t,e){var o,n,p,r;e.__SV||(window.posthog=e,e._i=[],e.init=function(i,s,a){function g(t,e){var o=e.split(".");2==o.length&&(t=t[o[0]],e=o[1]),t[e]=function(){t.push([e].concat(Array.prototype.slice.call(arguments,0)))}}(p=t.createElement("script")).type="text/javascript",p.async=!0,p.src=s.api_host.replace(".i.posthog.com","-assets.i.posthog.com")+"/static/array.js",(r=t.getElementsByTagName("script")[0]).parentNode.insertBefore(p,r);var u=e;for(void 0!==a?u=e[a]=[]:a="posthog",u.people=u.people||[],u.toString=function(t){var e="posthog";return"posthog"!==a&&(e+="."+a),t||(e+=" (stub)"),e},u.people.toString=function(){return u.toString(1)+".people (stub)"},o="capture identify alias people.set people.set_once set_config register register_once unregister opt_out_capturing has_opted_out_capturing opt_in_capturing reset isFeatureEnabled onFeatureFlags getFeatureFlag getFeatureFlagPayload reloadFeatureFlags group updateEarlyAccessFeatureEnrollment getEarlyAccessFeatures getActiveMatchingSurveys getSurveys onSessionId".split(" "),n=0;n<o.length;n++)g(u,o[n]);e._i.push([i,s,a])},e.__SV=1)}(document,window.posthog||[]);
    posthog.init(\'phc_QkZFJaDCIpVoVE127ePiwD5cyZPo1TPDulbTzPPO9uM\',{api_host:\'https://us.i.posthog.com\'})
</script>

    	<meta name="twitter:card" content="summary_large_image">
	<meta name="twitter:site" content="@Slides">
	<meta name="twitter:title" content="responsive-svg">
	<meta name="twitter:description" content="A presentation created with Slides.">
	<meta name="twitter:image" content="https://media.slid.es/thumbnails/alexwalker/0b188c/responsive-svg.jpg">
	<meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">

  </head>
  <body >
    
    <div id="container" class="container">
      

<header class="global-header show-on-scroll">
  <div class="wrapper">
    <div class="slides-logo logo-animation">
      <a class="symbol" href="/" aria-label="Go to the Slides homepage">
        <div class="box-1"></div>
        <div class="box-2"></div>
        <div class="box-3"></div>
      </a>
      <a class="word" href="/" aria-label="Go to the Slides homepage"></a>
    </div>
    <div class="nav-wrapper">
        <ul class="nav nav-full">
          <li class="nav-item " data-page-id="home/explore">
            <a class="nav-item-anchor" href="/explore"><span class="nav-item-label wide">Presentations</span></a>
          </li>
          <li class="nav-item " data-page-id="home/templates">
            <a class="nav-item-anchor" href="/templates"><span class="nav-item-label wide">Templates</span></a>
          </li>
          <li class="nav-item " data-page-id="home/features">
            <a class="nav-item-anchor" href="/features"><span class="nav-item-label">Features</span></a>
          </li>
          <li class="nav-item " data-page-id="marketing/teams">
            <a class="nav-item-anchor" href="/for-teams"><span class="nav-item-label wide">Teams</span></a>
          </li>
          <li class="nav-item " data-page-id="static/pricing">
            <a class="nav-item-anchor" href="/pricing?h=1"><span class="nav-item-label">Pricing</span></a>
          </li>
          <li class="nav-item-divider hide-in-overlay-menu"></li>
          <li class="nav-item hide-in-overlay-menu" data-page-id="sessions/new">
            <a class="nav-item-anchor" href="/users/sign_in"><span class="nav-item-label">Log in</span></a>
          </li>
          <li class="nav-item hide-in-overlay-menu nav-item-highlighted">
            <a class="nav-item-anchor" href="/pricing"><span class="nav-item-label">Sign up</span></a>
          </li>
        </ul>
        <ul class="nav nav-compact">
          <li class="nav-item" data-page-id="sessions/new">
            <a class="nav-item-anchor" href="/users/sign_in"><span class="nav-item-label">Log in</span></a>
          </li>
          <li class="nav-item">
            <a class="nav-item-anchor" href="/pricing"><span class="nav-item-label">Sign up</span></a>
          </li>
          <li class="nav-item menu-button nav-item-highlighted">
            <button class="nav-item-anchor">
              <span class="nav-item-label wide">Menu</span>
              <svg class="menu-arrow" viewBox="0 0 20 20" width="18" height="18" style="vertical-align: middle;">
                <path fill="currentColor" d="M4.516 7.548c0.436-0.446 1.043-0.481 1.576 0l3.908 3.747 3.908-3.747c0.533-0.481 1.141-0.446 1.574 0 0.436 0.445 0.408 1.197 0 1.615-0.406 0.418-4.695 4.502-4.695 4.502-0.217 0.223-0.502 0.335-0.787 0.335s-0.57-0.112-0.789-0.335c0 0-4.287-4.084-4.695-4.502s-0.436-1.17 0-1.615z"></path>
              </svg>
            </button>
          </li>
        </ul>
    </div>
  </div>
</header>


      
      <main id="main" class="main " role="main">
        







<div class="marquee">

	<div class="reveal-frame">
		<div class="reveal-viewport theme-font-josefine theme-color-black-blue">
			<div class="reveal" lang="en">
				<div class="slides">
					<section data-id="b4c1257f4cfd2384550183b30741de65"><div class="sl-block" data-block-type="text" style="width: 832px; left: 60px; top: 133px; height: auto;" data-block-id="7752757e0fc3ed012d28808fae28b7c1"><div class="sl-block-content" data-placeholder-tag="h1" data-placeholder-text="Title Text" style="z-index: 10; font-size: 130%; color: rgb(255, 199, 36);">
<h1>Responsive SVG</h1>
</div></div>
<div class="sl-block" data-block-type="text" data-block-id="caf1ae45e860cbb598fe0f5f9744184c" style="height: auto; min-width: 30px; min-height: 30px; width: 650px; left: 150px; top: 262px;"><div class="sl-block-content" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 11; font-size: 95%;">
<p>(or putting the \'S\' into Scalable Vector Graphics)</p>
</div></div>
<div class="sl-block" data-block-type="text" style="height: auto; min-width: 30px; min-height: 30px; width: 223px; left: 629px; top: 362px;" data-block-id="c7af3d53230445188e9c94832e02cab6"><div class="sl-block-content" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 12; font-size: 72%;">
<p style="text-align:left">Alex Walker</p>

<p style="text-align:left">sitepoint.com</p>

<p style="text-align:left">learnable.com</p>

<p style="text-align:left">@alexmwalker</p>
</div></div>

<div class="sl-block" data-block-type="image" data-block-id="8029cde386f0702aa5c634cbddb0c4f8" style="min-width: 30px; min-height: 30px; width: 223.5px; height: 298px; left: 368px; top: 288px;"><div class="sl-block-content" style="z-index: 0;"><img src="https://s3.amazonaws.com/media-p.slid.es/uploads/alexwalker/images/590183/medium_3330674993.jpg" style="visibility: visible;" data-natural-width="375" data-natural-height="500"></div></div>
<div class="sl-block" data-block-type="text" data-block-id="dc09a52f64d012698d6b6029158635b2" style="height: auto; min-width: 30px; min-height: 30px; width: 60px; left: 813px; top: 52px;"><div class="sl-block-content" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 14; text-align: center; color: rgb(102, 102, 102);">
<pre style="text-align: center;"><span style="font-size:16px">1</span></pre>
</div></div></section><section data-id="b928db75f7f2f26ee95c1688695960a1"><div class="sl-block" data-block-type="image" style="width: 582.0812807881773px; height: 411px; left: 180px; top: 215px;" data-block-id="5a876194f2a7b2cbbf5d3e01a9e30e6c"><div class="sl-block-content" style="z-index: 10;"><img src="https://s3.amazonaws.com/media-p.slid.es/uploads/alexwalker/images/585660/back-to-the-futurepanel2.gif" style="visibility: visible;" data-natural-width="575" data-natural-height="406"></div></div>
<div class="sl-block" data-block-type="text" style="width: 800px; left: 80px; top: 41px; height: auto;" data-block-id="a13476eb8115af3fde46f1cfe47f5863"><div class="sl-block-content" data-placeholder-tag="h2" data-placeholder-text="Title Text" style="color: rgb(255, 199, 36); z-index: 11;">
<h2>Firstly.. Let\'s take a trip</h2>

<h2>waaaay back...</h2>
</div></div>
<div class="sl-block" data-block-type="text" style="height: auto; min-width: 30px; min-height: 30px; width: 60px; left: 813px; top: 52px;" data-block-id="5ae3dc8ac1210f544d77d870dd0af2f8"><div class="sl-block-content" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 13; text-align: center; color: rgb(102, 102, 102);">
<pre style="text-align:center"><span style="font-size:16px">2</span></pre>
</div></div></section><section data-id="52781644f53a904ea24efc0190d1dccc"><div class="sl-block" data-block-type="text" style="width: 434px; left: 136px; top: 70px; height: auto;" data-block-id="8cdc81f99bc696250b2f160130b3f86c"><div class="sl-block-content" data-placeholder-tag="h2" data-placeholder-text="Title Text" style="color: rgb(255, 199, 36); font-size: 129%; text-align: left; z-index: 10;">
<h2>... to 1998.. </h2>
</div></div>
<div class="sl-block" data-block-type="image" style="width: 700px; height: 379.4px; left: 136px; top: 171px;" data-block-id="a6574980e6ce586f5be67d48639f4460"><div class="sl-block-content fragment" style="border: 9px solid rgb(0, 0, 0); z-index: 11;" data-fragment-index="0"><img src="https://s3.amazonaws.com/media-p.slid.es/uploads/alexwalker/images/585661/back-to-the-future-gif-movie-Favim.com-232507.gif" style="visibility: visible;" data-natural-width="500" data-natural-height="271"></div></div>
<div class="sl-block" data-block-type="image" data-block-id="8e6de225eb9e55b2da63b79b54fb2b71" style="min-width: 30px; min-height: 30px; width: 686.311787072243px; height: 361px; left: 143.015975952148px; top: 180.4375px;"><div class="sl-block-content fragment" style="z-index: 12;" data-fragment-index="1"><img src="https://s3.amazonaws.com/media-p.slid.es/uploads/alexwalker/images/612308/outatime.gif" style="visibility: visible;" data-natural-width="500" data-natural-height="263"></div></div>
<div class="sl-block" data-block-type="text" style="height: auto; min-width: 30px; min-height: 30px; width: 60px; left: 813px; top: 52px;" data-block-id="3b42b38ed2dd47ba117a56741b1d9283"><div class="sl-block-content" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 14; text-align: center; color: rgb(102, 102, 102);">
<pre style="text-align:center"><span style="font-size:16px">3</span></pre>
</div></div></section><section data-id="30306e4f42069d79dc21f39fdec24ba0"><div class="sl-block" data-block-type="text" style="width: 335px; left: 86px; top: 140px; height: auto;" data-block-id="53f2d4e11983d6491a24dd57fa848a24"><div class="sl-block-content" data-placeholder-tag="h2" data-placeholder-text="Title Text" style="text-align: left; z-index: 10; color: rgb(255, 199, 36); font-size: 116%;">
<h2>Will Smith..</h2>
</div></div>
<div class="sl-block" data-block-type="text" style="width: 430px; left: 80px; top: 256px; height: auto;" data-block-id="e9f5c3bdb973e79d3aa5da94b021d1c4"><div class="sl-block-content fragment" data-placeholder-tag="p" data-placeholder-text="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi nec metus justo. Aliquam erat volutpat." style="z-index: 11; text-align: left;" data-fragment-index="0">
<p>.. is Gettin\' Jiggy Wit \'It\'</p>
</div></div>
<div class="sl-block" data-block-type="text" style="height: auto; min-width: 30px; min-height: 30px; width: 414px; left: 80px; top: 70px;" data-block-id="04866a291e8b9d3372a2dea8614ab591"><div class="sl-block-content" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 12;">
<p style="text-align:left">And when we arrive we find...</p>
</div></div>
<div class="sl-block" data-block-type="image" data-block-id="9c0dcaeb1bb0444c0ddd9079e712b831" style="min-width: 30px; min-height: 30px; width: 437.5px; height: 315px; left: 421px; top: 140px;"><div class="sl-block-content fragment" style="z-index: 13;" data-fragment-index="0"><img src="https://s3.amazonaws.com/media-p.slid.es/uploads/alexwalker/images/585793/willsmith.gif" style="visibility: visible;" data-natural-width="500" data-natural-height="360"></div></div>
<div class="sl-block" data-block-type="text" style="height: auto; min-width: 30px; min-height: 30px; width: 60px; left: 813px; top: 52px;" data-block-id="75a00767db35db13b2a620b8c0039b50"><div class="sl-block-content" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 15; text-align: center; color: rgb(102, 102, 102);">
<pre style="text-align:center"><span style="font-size:16px">4</span></pre>
</div></div></section><section data-id="041cf78f0a50dd916b1c80ed076b02eb"><div class="sl-block" data-block-type="text" style="width: 430px; left: 74px; top: 140px; height: auto;" data-block-id="1348aecdfe6efea015bb7033c9d48de3"><div class="sl-block-content" data-placeholder-tag="h2" data-placeholder-text="Title Text" style="text-align: left; z-index: 10; color: rgb(255, 199, 36); font-size: 137%;">
<h2>
<span style="color:#0000FF">G</span><span style="color:#FF0000">o</span>o<span style="color:#0000FF">g</span><span style="color:#00FF00">l</span>e..</h2>
</div></div>
<div class="sl-block" data-block-type="text" style="width: 430px; left: 80px; top: 261px; height: auto;" data-block-id="86de40fca066d23d349f87b6a22c9dea"><div class="sl-block-content fragment" data-placeholder-tag="p" data-placeholder-text="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi nec metus justo. Aliquam erat volutpat." style="z-index: 12; text-align: left;" data-fragment-index="0">
<p>.. is two guys in a room...</p>
</div></div>
<div class="sl-block" data-block-type="image" style="width: 377.754266211604px; height: 387px; left: 473px; top: 70px;" data-block-id="fd9091492b4b076bb131f69b96cc7dde"><div class="sl-block-content fragment" style="z-index: 11;" data-fragment-index="1"><img src="https://s3.amazonaws.com/media-p.slid.es/uploads/alexwalker/images/585669/google-larry.jpg" style="visibility: visible;" data-natural-width="286" data-natural-height="293"></div></div>
<div class="sl-block" data-block-type="text" data-block-id="67e65f32c083a30e78ef32f1da1cba4d" style="height: auto; min-width: 30px; min-height: 30px; width: 325px; left: 80px; top: 331px;"><div class="sl-block-content fragment" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 13;" data-fragment-index="2">
<p style="text-align:left">.. with ONE chair.</p>
</div></div>
<div class="sl-block" data-block-type="text" style="height: auto; min-width: 30px; min-height: 30px; width: 371px; left: 480px; top: 474px;" data-block-id="82368180df6647dd2ba3cf074519aec0"><div class="sl-block-content fragment" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 14; font-size: 87%; text-align: center;" data-fragment-index="3">
<p>(Larry is \'<em>chairman</em>\' )</p>
</div></div>
<div class="sl-block" data-block-type="text" data-block-id="229cf76329c69972059a99f74dd6b1e5" style="height: auto; min-width: 30px; min-height: 30px; width: 183px; left: 80px; top: 70px;"><div class="sl-block-content" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 15; text-align: left;">
<p>We find..</p>
</div></div>
<div class="sl-block" data-block-type="shape" data-block-id="305faced7f3a6378f50fe941298d8f7e" style="min-width: 4px; min-height: 4px; width: 378px; height: 22px; left: 473px; top: 435px;"><div class="sl-block-content fragment" data-shape-type="rect" data-shape-fill-color="#000000" data-shape-stretch="true" style="z-index: 17;" data-fragment-index="1"><svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="100%" height="100%" preserveaspectratio="none" viewbox="0 0 378 22"><rect width="378" height="22" class="shape-element" fill="#000000"></rect></svg></div></div>
<div class="sl-block" data-block-type="text" style="height: auto; min-width: 30px; min-height: 30px; width: 60px; left: 813px; top: 52px;" data-block-id="f075dbb78c8bbb1110a7463aa3b297d8"><div class="sl-block-content" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 18; text-align: center; color: rgb(102, 102, 102);">
<pre style="text-align:center"><span style="font-size:16px">5</span></pre>
</div></div></section><section data-id="222abcc23f1a3dfa2ac53de54212dd69"><div class="sl-block" data-block-type="text" style="width: 800px; left: 80px; top: 170px; height: auto;" data-block-id="509a655f39809fc35dd03258c210f396"><div class="sl-block-content" data-placeholder-tag="h1" data-placeholder-text="Title Text" style="z-index: 10; text-align: left; color: rgb(255, 199, 36);">
<h1>Chris Lilley..</h1>
</div></div>
<div class="sl-block" data-block-type="image" data-block-id="ac462f9eb7eaf854bb99801a6dd0f8c5" style="min-width: 30px; min-height: 30px; width: 262.5px; height: 350px; left: 577.5px; top: 140px;"><div class="sl-block-content fragment" style="z-index: 11;" data-fragment-index="0"><img src="https://s3.amazonaws.com/media-p.slid.es/uploads/alexwalker/images/586093/chris2-l.jpg" style="visibility: visible;" data-natural-width="600" data-natural-height="800"></div></div>
<div class="sl-block" data-block-type="text" data-block-id="3024612dd21b206613a8693bb7f620a5" style="height: auto; min-width: 30px; min-height: 30px; width: 261.5px; left: 578px; top: 509px;"><div class="sl-block-content fragment" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 12; font-size: 75%;" data-fragment-index="0">
<p>Chris Lilley -1998</p>

<p>@SVGeesus</p>
</div></div>
<div class="sl-block" data-block-type="text" data-block-id="1013a9e0f055f67a2d2beaf4785f39c4" style="height: auto; min-width: 30px; min-height: 30px; width: 600px; left: 80px; top: 364px;"><div class="sl-block-content fragment" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 13; text-align: left;" data-fragment-index="1">
<p>... beginning work on \'SVG 1.0\'.</p>
</div></div>
<div class="sl-block" data-block-type="text" style="height: auto; min-width: 30px; min-height: 30px; width: 440px; left: 80px; top: 107px;" data-block-id="47f67d123116c666a1c9bc8b9ceb9500"><div class="sl-block-content" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 14; text-align: left;">
<p>We find a guy called..</p>
</div></div>
<div class="sl-block" data-block-type="text" style="height: auto; min-width: 30px; min-height: 30px; width: 600px; left: 80px; top: 254px;" data-block-id="ec23815833ec27fbb689d55418b28da4"><div class="sl-block-content fragment" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 15; text-align: left;" data-fragment-index="0">
<p>(Web Graphics superhero)</p>
</div></div>
<div class="sl-block" data-block-type="text" style="height: auto; min-width: 30px; min-height: 30px; width: 60px; left: 813px; top: 52px;" data-block-id="ffc743110e11c8065af8c64d1acab130"><div class="sl-block-content" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 17; text-align: center; color: rgb(102, 102, 102);">
<pre style="text-align:center"><span style="font-size:16px">6</span></pre>
</div></div></section><section data-id="b1fce3fe568bbac02aa3dca71ec6debf"><div class="sl-block" data-block-type="text" style="width: 852px; left: 47px; top: 33px; height: auto;" data-block-id="4479009914fe111155a3d7901791fe3d"><div class="sl-block-content" data-placeholder-tag="h1" data-placeholder-text="Title Text" style="z-index: 13; text-align: left; color: rgb(255, 199, 36); font-size: 91%;">
<h1>..and HTML looks like this..</h1>
</div></div>
<div class="sl-block" data-block-type="code" data-block-id="e5d9ac83964c107071d11fad99cbf118" style="min-width: 30px; min-height: 30px; width: 863px; height: 453px; left: 47px; top: 165px;"><div class="sl-block-content fragment" style="z-index: 10; font-size: 120%; border: 8px solid rgb(61, 61, 61);" data-fragment-index="0"><pre class="xml"><code>&lt;h1&gt;	
    &lt;font size="5" face="Verdana, Arial, Helvetica, sans-serif"&gt;
        ...Baby One More Time
    &lt;/font&gt;
&lt;/h1&gt;
&lt;p align="left"&gt;
    &lt;font color="#000077" size="3" face="Verdana, Arial, 
    Helvetica, sans-serif"&gt;
    	&lt;i&gt;
            My loneliness is killing me &lt;br /&gt;
            I must confess, I still believe &lt;br /&gt;
        &lt;/i&gt;
    &lt;/font&gt;
&lt;/p&gt;
&lt;p align="right"&gt;
    &lt;font color="red" size="4"&gt;Britney Spears&lt;/font&gt;
&lt;/p&gt;</code></pre></div></div>
<div class="sl-block" data-block-type="image" data-block-id="f43ce14620a0348a20fc8c365d130af9" style="min-width: 30px; min-height: 30px; width: 197.2px; height: 136px; left: 691px; top: 422px;"><div class="sl-block-content fragment" style="z-index: 11;" data-fragment-index="1"><img src="https://s3.amazonaws.com/media-p.slid.es/uploads/alexwalker/images/585703/200.gif" style="visibility: visible;" data-natural-width="290" data-natural-height="200"></div></div>
<div class="sl-block" data-block-type="text" data-block-id="d28fd0de95baf6e49658da4ba8992330" style="height: auto; min-width: 30px; min-height: 30px; width: 600px; left: 47px; top: 121px;"><div class="sl-block-content" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 14; font-size: 83%;">
<p style="text-align:left">(Children, avert your eyes!)</p>
</div></div>

<div class="sl-block" data-block-type="text" data-block-id="acf7f9f6160805c856a7b82b35b4bbe8" style="height: auto; min-width: 30px; min-height: 30px; width: 108px; left: 781px; top: 519px;"><div class="sl-block-content fragment" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 12;" data-fragment-index="1">
<p>Eww..</p>
</div></div>
<div class="sl-block" data-block-type="text" style="height: auto; min-width: 30px; min-height: 30px; width: 60px; left: 813px; top: 52px;" data-block-id="6224f11f042c65bdb2e6735515fb5dc6"><div class="sl-block-content" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 16; text-align: center; color: rgb(102, 102, 102);">
<pre style="text-align:center"><span style="font-size:16px">7</span></pre>
</div></div></section><section><div class="sl-block" data-block-type="text" style="width: 358px; left: 80px; top: 67px; height: auto;" data-block-id="b63e4fbbb59b7988ce930f340811b884"><div class="sl-block-content" data-placeholder-tag="h2" data-placeholder-text="Title Text" style="color: rgb(255, 199, 36); z-index: 15; text-align: left; font-size: 137%;">
<h2>Why was it like that?</h2>
</div></div>
<div class="sl-block" data-block-type="text" style="width: 731px; left: 35px; top: 381px; height: auto;" data-block-id="a8cdbb4ffb58321ae6b05d65e8d8602e"><div class="sl-block-content fragment" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 10; color: rgb(255, 255, 255);" data-fragment-index="1">
<ul>
	<li>Microsoft Frontpage</li>
	<li>Adobe Pagemill</li>
	<li>Claris Webpage</li>
	<li>WYSIWYG  (Angelfire - Geocities - Lycos)</li>
</ul>
</div></div>
<div class="sl-block" data-block-type="text" style="height: auto; min-width: 30px; min-height: 30px; width: 379px; left: 81px; top: 276px;" data-block-id="a5f6b310bfd383af7317953a2361003b"><div class="sl-block-content fragment" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 11; text-align: left;" data-fragment-index="0">
<p>In 1998<em> MOST</em>  HTML is generated by ..</p>
</div></div>
<div class="sl-block" data-block-type="text" style="height: auto; min-width: 30px; min-height: 30px; width: 502px; left: 438px; top: 407px;" data-block-id="1fa7aeca15b4b8ca996d617802dd3e2b"><div class="sl-block-content fragment" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 12; color: rgb(253, 189, 4); font-size: 132%;" data-fragment-index="2">
<p>HTML is hidden!</p>
</div></div>
<div class="sl-block" data-block-type="text" style="height: auto; min-width: 30px; min-height: 30px; width: 600px; left: 66px; top: 612px;" data-block-id="f5f9f2fbefa164725363e1c9704544bb"><div class="sl-block-content fragment" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 13; font-size: 56%; color: rgb(170, 170, 170);" data-fragment-index="2">
<pre>*obligatory cat photo</pre>
</div></div>
<div class="sl-block" data-block-type="text" style="height: auto; min-width: 30px; min-height: 30px; width: 55.5px; left: 500px; top: 67px;" data-block-id="56c217d75c974b8796ffe623c3f07467"><div class="sl-block-content fragment" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 16; color: rgb(170, 170, 170); font-size: 116%;" data-fragment-index="2">
<pre>*</pre>
</div></div>
<div class="sl-block" data-block-type="image" style="min-width: 30px; min-height: 30px; width: 306.709956709957px; height: 325px; left: 528px; top: 75px;" data-block-id="60502152b3865365ab145fac6e9ab05b"><div class="sl-block-content fragment" style="z-index: 17;" data-fragment-index="2"><img src="https://s3.amazonaws.com/media-p.slid.es/uploads/alexwalker/images/609878/catbag.jpeg" style="visibility: visible;" data-natural-width="218" data-natural-height="231"></div></div>
<div class="sl-block" data-block-type="text" style="height: auto; min-width: 30px; min-height: 30px; width: 60px; left: 813px; top: 52px;" data-block-id="17e9ca438a89f1c53d020468b32884d7"><div class="sl-block-content" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 18; text-align: center; color: rgb(102, 102, 102);">
<pre style="text-align:center"><span style="font-size:16px">8</span></pre>
</div></div></section><section data-id="1ba00b7138c3427ac15de2250e74142a"><div class="sl-block" data-block-type="text" style="width: 800px; left: 80px; top: 160px; height: auto;" data-block-id="0bd062b665ae5d8feb745bc57a1bdb90"><div class="sl-block-content fragment" data-placeholder-tag="h1" data-placeholder-text="Title Text" style="color: rgb(255, 199, 36); z-index: 10;" data-fragment-index="0">
<h1>Even broken, poorly-supported CSS was a revelation!</h1>
</div></div>
<div class="sl-block" data-block-type="text" style="width: 685px; left: 195px; top: 512px; height: auto;" data-block-id="5a896f6ed486524df94ab4117c031263"><div class="sl-block-content fragment" data-placeholder-tag="h2" data-placeholder-text="Subtitle" style="color: rgb(255, 255, 255); z-index: 11; text-align: left;" data-fragment-index="0">
<p>FUN FACT: In 1998 the most popular browser (Netscape 4) only supported 40% of the CSS spec.</p>
</div></div>
<div class="sl-block" data-block-type="text" data-block-id="a4fb20e9767f16797c50c0296e6e8ffb" style="height: auto; min-width: 30px; min-height: 30px; width: 659px; left: 141px; top: 88px;"><div class="sl-block-content" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 12;">
<p>So, once we started working directly the HTML..</p>
</div></div>
<div class="sl-block" data-block-type="shape" data-block-id="fe22fd01551b5385290960e0e66a1016" style="min-width: 4px; min-height: 4px; width: 70px; height: 70px; left: 106px; top: 518px;"><div class="sl-block-content fragment" data-shape-type="symbol-wondering" data-shape-fill-color="rgb(60, 120, 216)" data-shape-stretch="false" style="z-index: 13;" data-fragment-index="0"><svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="100%" height="100%" preserveaspectratio="xMidYMid" viewbox="0 0 32 32"><g class="shape-element" fill="rgb(60, 120, 216)"><path d="M16 32c8.837 0 16-7.163 16-16s-7.163-16-16-16-16 7.163-16 16 7.163 16 16 16zM16 3c7.18 0 13 5.82 13 13s-5.82 13-13 13-13-5.82-13-13 5.82-13 13-13zM23.304 18.801l0.703 2.399-13.656 4-0.703-2.399zM8 10c0-1.105 0.895-2 2-2s2 0.895 2 2c0 1.105-0.895 2-2 2-1.105 0-2-0.895-2-2zM20 10c0-1.105 0.895-2 2-2s2 0.895 2 2c0 1.105-0.895 2-2 2-1.105 0-2-0.895-2-2z"></path></g></svg></div></div>
<div class="sl-block" data-block-type="text" style="height: auto; min-width: 30px; min-height: 30px; width: 60px; left: 813px; top: 52px;" data-block-id="c0e2e181717d94184eda16762e756445"><div class="sl-block-content" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 15; text-align: center; color: rgb(102, 102, 102);">
<pre style="text-align:center"><span style="font-size:16px">9</span></pre>
</div></div></section><section data-id="3e25b0830aaf3dc0f8aa3c5da5d6289a"><div class="sl-block" data-block-type="text" style="width: 822px; left: 80px; top: 140px; height: auto;" data-block-id="b09237a186135e3e4168544c62ea3e2a"><div class="sl-block-content fragment" data-placeholder-tag="h2" data-placeholder-text="Title Text" style="color: rgb(255, 199, 36); font-size: 129%; z-index: 10; text-align: left;" data-fragment-index="0">
<h2>Back to the Future (now) </h2>
</div></div>
<div class="sl-block" data-block-type="image" style="width: 594px; height: 320.76px; left: 183px; top: 260px;" data-block-id="6fcccf7afe188f7a624bbdbae2cabbf8"><div class="sl-block-content fragment" style="border: 9px solid rgb(0, 0, 0); z-index: 11;" data-fragment-index="0"><img src="https://s3.amazonaws.com/media-p.slid.es/uploads/alexwalker/images/587859/oie_293408Exr2boxQ.gif" style="visibility: visible;" data-natural-width="500" data-natural-height="270"></div></div>
<div class="sl-block" data-block-type="text" data-block-id="0ef3431a2227963b5de496e28084cc8f" style="height: auto; min-width: 30px; min-height: 30px; width: 600px; left: 80px; top: 70px;"><div class="sl-block-content" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 12; text-align: left;">
<p>Ok, so let\'s go..</p>
</div></div>
<div class="sl-block" data-block-type="text" style="height: auto; min-width: 30px; min-height: 30px; width: 60px; left: 813px; top: 52px;" data-block-id="be09c2d91e99e24913feda0c38c99cc2"><div class="sl-block-content" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 14; text-align: center; color: rgb(102, 102, 102);">
<pre style="text-align:center"><span style="font-size:16px">10</span></pre>
</div></div></section><section data-id="b65bc7493aa9c3d4472afa2ec98ec57d"><div class="sl-block" data-block-type="text" style="width: 800px; left: 57px; top: 202px; height: auto;" data-block-id="436167ea84a9cd63089e1ed8a30ba0a7"><div class="sl-block-content" data-placeholder-tag="h1" data-placeholder-text="Title Text" style="color: rgb(253, 189, 4);">
<h1>Where does our SVG come from today?</h1>
</div></div></section><section data-id="230879a1bfa0be948bf20a1b83e85ed9"><div class="sl-block" data-block-type="text" style="width: 800px; left: 69px; top: 70px; height: auto;" data-block-id="1d9b238f0fc2ae2a4dc15e124dcf8fbd"><div class="sl-block-content" data-placeholder-tag="h1" data-placeholder-text="Title Text" style="z-index: 11; color: rgb(255, 199, 36);">
<h1>"Save As.." SVG</h1>
</div></div>
<div class="sl-block" data-block-type="image" data-block-id="c8dec54aa04f626cef8d5892a2947a7d" style="min-width: 30px; min-height: 30px; width: 168px; height: 168px; left: 191px; top: 180px;"><div class="sl-block-content fragment" style="z-index: 12;" data-fragment-index="0"><img src="https://s3.amazonaws.com/media-p.slid.es/uploads/alexwalker/images/585760/inkscape__1_.png" style="visibility: visible;" data-natural-width="256" data-natural-height="256"></div></div>
<div class="sl-block" data-block-type="text" data-block-id="f6427231fad2fb3dfbe5d3f8c1c4802d" style="height: auto; min-width: 30px; min-height: 30px; width: 154px; left: 198px; top: 348px;"><div class="sl-block-content fragment" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 13;" data-fragment-index="0">
<p>Inkscape</p>
</div></div>
<div class="sl-block" data-block-type="text" style="height: auto; min-width: 30px; min-height: 30px; width: 154px; left: 574px; top: 348px;" data-block-id="642c7ce470e7d24221784f8ad7cb3f06"><div class="sl-block-content fragment" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 14;" data-fragment-index="2">
<p>Sketch</p>
</div></div>
<div class="sl-block" data-block-type="text" style="height: auto; min-width: 30px; min-height: 30px; width: 154px; left: 200px; top: 582px;" data-block-id="c1b7cbad0c4c2aa14c28fba6a76b8364"><div class="sl-block-content fragment" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 15;" data-fragment-index="1">
<p>Illustrator</p>
</div></div>
<div class="sl-block" data-block-type="text" style="height: auto; min-width: 30px; min-height: 30px; width: 154px; left: 573px; top: 582px;" data-block-id="649d97471e2e0013cf20b4a1978a65b4"><div class="sl-block-content fragment" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 16;" data-fragment-index="3">
<p>Webcode</p>
</div></div>
<div class="sl-block" data-block-type="image" data-block-id="5cae9775e95ea0d6b2958a95df0acdb9" style="min-width: 30px; min-height: 30px; width: 153px; height: 153px; left: 201px; top: 415px;"><div class="sl-block-content fragment" style="z-index: 17;" data-fragment-index="1"><img src="https://s3.amazonaws.com/media-p.slid.es/uploads/alexwalker/images/585770/illustrator_logo.jpg" style="visibility: visible;" data-natural-width="900" data-natural-height="900"></div></div>
<div class="sl-block" data-block-type="image" data-block-id="8fbd570b04755bee30c2760692a8e10d" style="min-width: 30px; min-height: 30px; width: 179.5px; height: 179.5px; left: 560px; top: 402px;"><div class="sl-block-content fragment" style="z-index: 18;" data-fragment-index="3"><img src="https://s3.amazonaws.com/media-p.slid.es/uploads/alexwalker/images/585783/webcode.png" style="visibility: visible;" data-natural-width="225" data-natural-height="225"></div></div>
<div class="sl-block" data-block-type="image" data-block-id="4278ac39e364cb30388b431565abcefe" style="min-width: 30px; min-height: 30px; width: 178px; height: 178px; left: 562px; top: 180px;"><div class="sl-block-content fragment" style="z-index: 19;" data-fragment-index="2"><img src="https://s3.amazonaws.com/media-p.slid.es/uploads/alexwalker/images/585785/sketch-software2.png" style="visibility: visible;" data-natural-width="489" data-natural-height="489"></div></div></section><section data-id="7eebc7c351c0c53f98df185b3c622d48"><div class="sl-block" data-block-type="text" style="width: 862px; left: 44px; top: 25px; height: auto;" data-block-id="cdd02831c258958a24e57695516ed4a2"><div class="sl-block-content" data-placeholder-tag="h1" data-placeholder-text="Title Text" style="color: rgb(255, 199, 36); z-index: 11; text-align: left; font-size: 93%;">
<h1>\'Save as\' SVG has problems</h1>
</div></div>
<div class="sl-block" data-block-type="code" data-block-id="c2b7b668ec2f66ab1a82d084567f6d61" style="min-width: 30px; min-height: 30px; width: 498px; height: 560px; left: 448px; top: 116px;"><div class="sl-block-content fragment" style="z-index: 12; font-size: 70%;" data-fragment-index="1"><pre><code>&lt;?xml version="1.0" encoding="UTF-8" standalone="no"?&gt;
&lt;!-- Created with Inkscape (http://www.inkscape.org/) --&gt;

&lt;svg
viewBox="0 0 740 1100" version="1.1"   xmlns:dc="http://purl.org/dc/elements/1.1/"
    id="svg2"
   version="1.1"
   inkscape:version="0.48.4 r9939"
   sodipodi:docname="New document 1"&gt;
  &lt;defs
     id="defs4" /&gt;
  &lt;sodipodi:namedview
     id="base"
     pagecolor="#ffffff"
     bordercolor="#666666"
     borderopacity="1.0"
     inkscape:pageopacity="0.0"
     inkscape:pageshadow="2"
     inkscape:zoom="0.78686696"
     inkscape:cx="512.49342"
     inkscape:cy="589.39724"
     inkscape:document-units="px"
     inkscape:current-layer="layer1"
     showgrid="false"
     inkscape:window-width="1255"
     inkscape:window-height="841"
     inkscape:window-x="215"
     inkscape:window-y="95"
     inkscape:window-maximized="0" /&gt;
  &lt;metadata
     id="metadata7"&gt;
    &lt;rdf:RDF&gt;
      &lt;cc:Work
         rdf:about=""&gt;
        &lt;dc:format&gt;image/svg+xml&lt;/dc:format&gt;
        &lt;dc:type
           rdf:resource="http://purl.org/dc/dcmitype/StillImage" /&gt;
        &lt;dc:title&gt;&lt;/dc:title&gt;
      &lt;/cc:Work&gt;
    &lt;/rdf:RDF&gt;
  &lt;/metadata&gt;
  &lt;g
     inkscape:label="Layer 1"
     inkscape:groupmode="layer"
     id="layer1"&gt;
    &lt;path
       style="fill:#d40000"
       d="m 122.84375,226.65625 0,41.0625 0,10.34375 0,22.59375 c 0,9.20305 7.42195,16.59375 16.625,16.59375 9.20305,0 16.625,-7.3907 16.625,-16.59375 l 0,-22.59375 178.1875,0 0,480 -31.4375,10 0,24.3125 31.4375,0 60,0 32.5625,0 0,-24.3125 -32.5625,-10 0,-480 183.875,0 0,22.59375 c 0,9.20305 7.3907,16.59375 16.59375,16.59375 9.20305,0 16.625,-7.3907 16.625,-16.59375 l 0,-22.59375 0.0625,0 0,-51.40625 z"
       id="rect3109"
       inkscape:connector-curvature="0"
       sodipodi:nodetypes="cccsssccccccccccccssscccc" /&gt;
  &lt;/g&gt;
&lt;/svg&gt;</code></pre></div></div>
<div class="sl-block" data-block-type="text" data-block-id="7607105004921ed3d0b974ef014c5a35" style="height: auto; min-width: 30px; min-height: 30px; width: 600px; left: 80px; top: 156px;"><div class="sl-block-content fragment" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 13; text-align: left;" data-fragment-index="0">
<p>The markup is full of.....</p>

<p><em>stuff!</em>  (i.e MS Word HTML)</p>
</div></div>
<div class="sl-block" data-block-type="shape" data-block-id="e931edae5782d7ba73849a0bf9652626" style="min-width: 4px; min-height: 4px; width: 53.54545454545455px; height: 38px; left: 25px; top: 156px;"><div class="sl-block-content fragment" data-shape-type="symbol-star" data-shape-fill-color="rgb(168, 39, 107)" data-shape-stretch="false" style="z-index: 14;" data-fragment-index="0"><svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="100%" height="100%" preserveaspectratio="xMidYMid" viewbox="0 0 32 32"><g class="shape-element" fill="rgb(168, 39, 107)"><path d="M22.137 19.625l9.863-7.625h-12l-4-12-4 12h-12l9.875 7.594-3.875 12.406 10.016-7.68 9.992 7.68z"></path></g></svg></div></div>
<div class="sl-block" data-block-type="text" style="height: auto; min-width: 30px; min-height: 30px; width: 336px; left: 79px; top: 299px;" data-block-id="1228ffc4127776635cc48ae01b7e1639"><div class="sl-block-content fragment" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 15; text-align: left;" data-fragment-index="2">
<p>Editors mostly ignore the coolest features of SVG</p>
</div></div>
<div class="sl-block" data-block-type="shape" style="min-width: 4px; min-height: 4px; width: 53.54545454545455px; height: 38px; left: 25px; top: 299px;" data-block-id="e116afea14517d109cbd32106fdd02c3"><div class="sl-block-content fragment" data-shape-type="symbol-star" data-shape-fill-color="rgb(168, 39, 107)" data-shape-stretch="false" style="z-index: 16;" data-fragment-index="2"><svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="100%" height="100%" preserveaspectratio="xMidYMid" viewbox="0 0 32 32"><g class="shape-element" fill="rgb(168, 39, 107)"><path d="M22.137 19.625l9.863-7.625h-12l-4-12-4 12h-12l9.875 7.594-3.875 12.406 10.016-7.68 9.992 7.68z"></path></g></svg></div></div>
<div class="sl-block" data-block-type="text" data-block-id="1f02be7c55faf2197b86560d0d2a8166" style="height: auto; min-width: 30px; min-height: 30px; width: 197px; left: 123px; top: 396px;"><div class="sl-block-content fragment" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 17; color: rgb(204, 65, 37);" data-fragment-index="3">
<ul>
	<li style="text-align:left">
	<pre><strong>PATTERNs</strong></pre>
	</li>
	<li style="text-align:left">
	<pre><strong>SYMBOLs</strong></pre>
	</li>
	<li style="text-align:left">
	<pre><strong>CSS</strong></pre>
	</li>
</ul>
</div></div></section><section data-id="b60af3411f115a164c7e9aba60e37730"><div class="sl-block" data-block-type="text" style="width: 800px; left: 80px; top: 22px; height: auto;" data-block-id="cb596467d0d248820035703f3a14188b"><div class="sl-block-content" data-placeholder-tag="h1" data-placeholder-text="Title Text" style="color: rgb(255, 199, 36); z-index: 11;">
<h1>Using CSS in SVG</h1>
</div></div>
<div class="sl-block" data-block-type="code" data-block-id="8ab36be14154ccf2a40c1fcbdb4ae6e6" style="min-width: 30px; min-height: 30px; width: 512px; height: 387px; left: 80px; top: 140px;"><div class="sl-block-content fragment" style="z-index: 12; font-size: 124%;" data-fragment-index="0"><pre><code>
&lt;svg&gt;

    &lt;rect x="10" y="10" height="50" 
    width="50" fill="red" stroke="white"
    stroke-width="4px"/&gt;

&lt;/svg&gt;</code></pre></div></div>
<div class="sl-block" data-block-type="shape" data-block-id="f98397ea3b1a4a857898e4779cf73bc0" style="min-width: 4px; min-height: 4px; width: 283px; height: 387px; left: 615px; top: 140px;"><div class="sl-block-content fragment" data-shape-type="rect" data-shape-fill-color="rgb(61, 133, 198)" data-shape-stretch="true" style="z-index: 13;" data-fragment-index="1"><svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="100%" height="100%" preserveaspectratio="none" viewbox="0 0 283 387"><rect width="283" height="387" class="shape-element" fill="rgb(61, 133, 198)"></rect></svg></div></div>
<div class="sl-block" data-block-type="shape" style="min-width: 4px; min-height: 4px; width: 106px; height: 99px; left: 640px; top: 168px;" data-block-id="f0e73c9ac6407d564de57c8d3650979a"><div class="sl-block-content fragment" data-shape-type="rect" data-shape-fill-color="rgb(255, 0, 0)" data-shape-stretch="true" style="z-index: 14;" data-shape-stroke-color="#ffffff" data-shape-stroke-width="4" data-fragment-index="1"><svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="100%" height="100%" preserveaspectratio="none" viewbox="0 0 106 99"><defs><clippath id="shape-mask-730-1410254057955"><rect width="106" height="99"></rect></clippath></defs><rect width="106" height="99" clip-path="url(#shape-mask-730-1410254057955)" class="shape-element" fill="rgb(255, 0, 0)" stroke="#ffffff" stroke-width="8"></rect></svg></div></div>
<div class="sl-block" data-block-type="code" style="min-width: 30px; min-height: 30px; width: 512px; height: 387px; left: 80px; top: 140px;" data-block-id="c3c204922950e38040f15a3f71b6d1a3"><div class="sl-block-content fragment" style="z-index: 15; font-size: 124%;" data-fragment-index="3"><pre><code>
&lt;svg&gt;
    &lt;style&gt;
        .rectangles{
            fill:red; 
            stroke: white;
            stroke-width: 4px;
            }
    &lt;/style&gt;

    &lt;rect class="rectangles" x="10" 
    y="10" height="50" width="50" /&gt;

&lt;/svg&gt;</code></pre></div></div>
<div class="sl-block" data-block-type="text" data-block-id="000b92f9dc45a9df3aec616d6f0d275e" style="height: auto; min-width: 30px; min-height: 30px; width: 800px; left: 80px; top: 560px;"><div class="sl-block-content fragment" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 16; font-size: 135%;" data-fragment-index="2">
<h3>Remind you of that 1998-era HTML?</h3>
</div></div></section><section data-id="6512f4ce1a37683ef55aaf4a12061e97"><div class="sl-block" data-block-type="text" style="width: 800px; left: 78px; top: 99px; height: auto;" data-block-id="e71e2690b816bf0d2484f6ff9a7f28ac"><div class="sl-block-content" data-placeholder-tag="h2" data-placeholder-text="Title Text" style="color: rgb(255, 199, 36); z-index: 10;">
<h1>Why CSS-ify SVG? </h1>
</div></div>
<div class="sl-block" data-block-type="text" style="width: 800px; left: 80px; top: 227px; height: auto;" data-block-id="08c91bc49658e98ac578d1503500c0a1"><div class="sl-block-content" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 11; font-size: 111%;">
<ul>
	<li class="fragment" data-fragment-index="0"><span style="font-size:48px">Files size</span></li>
	<li class="fragment" data-fragment-index="1"><span style="font-size:48px">Managability </span></li>
	<li class="fragment" data-fragment-index="2"><span style="font-size:48px">MEDIA queries.   YAY!</span></li>
</ul>
</div></div>
<div class="sl-block" data-block-type="shape" data-block-id="0cbdb853d37bfcc1641e8dfe1650636f" style="min-width: 4px; min-height: 4px; width: 48px; height: 48px; left: 168px; top: 235px;"><div class="sl-block-content fragment" data-shape-type="symbol-clock" data-shape-fill-color="rgb(152, 0, 0)" data-shape-stretch="false" style="z-index: 12;" data-fragment-index="0"><svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="100%" height="100%" preserveaspectratio="xMidYMid" viewbox="0 0 32 32"><g class="shape-element" fill="rgb(152, 0, 0)"><path d="M16 4c6.617 0 12 5.383 12 12s-5.383 12-12 12-12-5.383-12-12 5.383-12 12-12zM16 0c-8.836 0-16 7.164-16 16s7.164 16 16 16 16-7.164 16-16-7.164-16-16-16v0zM21.422 18.578l-3.422-3.426v-7.152h-4.023v7.992c0 0.602 0.277 1.121 0.695 1.492l3.922 3.922 2.828-2.828z"></path></g></svg></div></div>
<div class="sl-block" data-block-type="shape" style="min-width: 4px; min-height: 4px; width: 48px; height: 48px; left: 168px; top: 296px;" data-block-id="73a70d642043226b644d1df20b8ebb68"><div class="sl-block-content fragment" data-shape-type="symbol-cog" data-shape-fill-color="rgb(152, 0, 0)" data-shape-stretch="false" style="z-index: 13;" data-fragment-index="1"><svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="100%" height="100%" preserveaspectratio="xMidYMid" viewbox="0 0 32 32"><g class="shape-element" fill="rgb(152, 0, 0)"><path d="M32 17.969v-4l-4.781-1.992c-0.133-0.375-0.273-0.738-0.445-1.094l1.93-4.805-2.829-2.828-4.762 1.961c-0.363-0.176-0.734-0.324-1.117-0.461l-2.027-4.75h-4l-1.977 4.734c-0.398 0.141-0.781 0.289-1.16 0.469l-4.754-1.91-2.828 2.828 1.938 4.711c-0.188 0.387-0.34 0.781-0.485 1.188l-4.703 2.011v4l4.707 1.961c0.145 0.406 0.301 0.801 0.488 1.188l-1.902 4.742 2.828 2.828 4.723-1.945c0.379 0.18 0.766 0.324 1.164 0.461l2.023 4.734h4l1.98-4.758c0.379-0.141 0.754-0.289 1.113-0.461l4.797 1.922 2.828-2.828-1.969-4.773c0.168-0.359 0.305-0.723 0.438-1.094l4.782-2.039zM15.969 22c-3.312 0-6-2.688-6-6s2.688-6 6-6 6 2.688 6 6-2.688 6-6 6z"></path></g></svg></div></div>
<div class="sl-block" data-block-type="shape" style="min-width: 4px; min-height: 4px; width: 48px; height: 48px; left: 167px; top: 354px;" data-block-id="1e8d1cb45cbc58b71af4e7749616abf6"><div class="sl-block-content fragment" data-shape-type="symbol-iphone" data-shape-fill-color="rgb(152, 0, 0)" data-shape-stretch="false" style="z-index: 15;" data-fragment-index="2"><svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="100%" height="100%" preserveaspectratio="xMidYMid" viewbox="0 0 24 32"><g class="shape-element" fill="rgb(152, 0, 0)"><path d="M16 0h-8c-4.418 0-8 3.582-8 8v16c0 4.418 3.582 8 8 8h8c4.418 0 8-3.582 8-8v-16c0-4.418-3.582-8-8-8zM12 30.062c-1.139 0-2.062-0.922-2.062-2.062s0.924-2.062 2.062-2.062 2.062 0.922 2.062 2.062-0.923 2.062-2.062 2.062zM20 24h-16v-16c0-2.203 1.795-4 4-4h8c2.203 0 4 1.797 4 4v16z"></path></g></svg></div></div></section><section data-id="7aecd23395bd7910bba6122fa0733bfc"><div class="sl-block" data-block-type="text" style="width: 800px; left: 53px; top: 126px; height: auto;" data-block-id="7ed49689f94085bab9f21f698cb13d63"><div class="sl-block-content" data-placeholder-tag="h1" data-placeholder-text="Title Text" style="z-index: 10; color: rgb(255, 199, 36); font-size: 117%;">
<h1>Demos</h1>
</div></div>
<div class="sl-block" data-block-type="text" data-block-id="1e6e7254cfd39204c024b17f80837e78" style="height: auto; min-width: 30px; min-height: 30px; width: 600px; left: 168px; top: 273px;"><div class="sl-block-content" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 12; font-size: 135%;">
<p>What we can do with</p>

<p>Responsive SVG?</p>
</div></div></section><section data-id="5ea9f0b917b31fc55b42c5a5ea396958"><div class="sl-block" data-block-type="text" style="width: 430px; left: 93px; top: 83px; height: auto;" data-block-id="4ec9cd9117b715082289599197ad6af8"><div class="sl-block-content" data-placeholder-tag="h2" data-placeholder-text="Title Text" style="text-align: left; color: rgb(255, 199, 36); z-index: 11;">
<h2>Improving Data</h2>
</div></div>
<div class="sl-block" data-block-type="text" style="width: 614px; left: 266px; top: 171px; height: auto;" data-block-id="e92540d76044c6794b1566b02f1518e6"><div class="sl-block-content" data-placeholder-tag="p" data-placeholder-text="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi nec metus justo. Aliquam erat volutpat." style="z-index: 13; text-align: left;">
<ol>
	<li>Display less data on smaller screens.</li>
	<li>Scale up what remains.</li>
</ol>
</div></div>
<div class="sl-block" data-block-type="image" style="width: 668.543859649123px; height: 265px; left: 154px; top: 280px;" data-block-id="7db96343cdcf613983c8d1f54f3bfa93"><div class="sl-block-content" style="z-index: 12;"><img src="https://s3.amazonaws.com/media-p.slid.es/uploads/alexwalker/images/609946/ReoRa1u_-_Imgur.png" style="visibility: visible;" data-natural-width="719" data-natural-height="285"></div></div>
<div class="sl-block" data-block-type="code" data-block-id="b9923afb251ca70f3cdfb29d16126530" style="min-width: 30px; min-height: 30px; width: 749px; height: 265px; left: 106px; top: 280px;"><div class="sl-block-content fragment" style="z-index: 14; font-size: 150%;" data-fragment-index="0"><pre><code>
 #tweet-total-range text:nth-child(odd) {
      opacity: 0;
  }</code></pre></div></div>
<div class="sl-block" data-block-type="text" style="width: 720px; left: 120px; top: 172px; height: auto;" data-block-id="bd1ec5c2ff4a09717eeeebf01f9178d7"><div class="sl-block-content fragment" data-placeholder-tag="p" data-placeholder-text="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi nec metus justo. Aliquam erat volutpat." style="z-index: 17; text-align: left; color: rgb(255, 255, 255);" data-fragment-index="0">
<p>CSS<span style="color:#FFA07A"> \':nth:child(odd)\'</span> lets us automatically target every second number on our axis.</p>
</div></div>
<div class="sl-block" data-block-type="text" data-block-id="0c916c58049ac543ab05f87fe8b5ac0c" style="height: auto; min-width: 30px; min-height: 30px; width: 144px; left: 106px; top: 170px;"><div class="sl-block-content" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 15; text-align: left;">
<p>Key Idea:</p>
</div></div>
<div class="sl-block" data-block-type="shape" data-block-id="0c6c7a19dbb97b7877196b1b0c9facd0" style="min-width: 4px; min-height: 4px; width: 749px; height: 92px; left: 106px; top: 171px;"><div class="sl-block-content fragment" data-shape-type="rect" data-shape-fill-color="rgb(34, 34, 34)" data-shape-stretch="true" style="z-index: 16;" data-fragment-index="0"><svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="100%" height="100%" preserveaspectratio="none" viewbox="0 0 749 92"><rect width="749" height="92" class="shape-element" fill="rgb(34, 34, 34)"></rect></svg></div></div>
<div class="sl-block" data-block-type="text" data-block-id="e857025e0e0ba3f95875271748166c29" style="height: auto; min-width: 30px; min-height: 30px; width: 600px; left: 106px; top: 594px;"><div class="sl-block-content" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 18; color: rgb(204, 204, 204);">
<pre><span style="font-size:16px">http://bit.ly/simple-graph</span></pre>
</div></div></section><section><div class="sl-block" data-block-type="text" style="width: 800px; left: 80px; top: 70px; height: auto;" data-block-id="5c7f1b016c23fb13291de3435e8c0750"><div class="sl-block-content" data-placeholder-tag="h1" data-placeholder-text="Title Text" style="color: rgb(253, 189, 4); z-index: 11;">
<h1>SVG Cooperation</h1>
</div></div>
<div class="sl-block" data-block-type="text" style="width: 800px; left: 87px; top: 178px; height: auto;" data-block-id="5d82900149502472989f2460a50f255c"><div class="sl-block-content" data-placeholder-tag="h2" data-placeholder-text="Subtitle" style="z-index: 12; font-size: 97%;">
<h2>Groups of Responsive SVGs can work like self-organising teams.</h2>
</div></div>
<div class="sl-block" data-block-type="text" data-block-id="57e82108d6b632455cbda7194f91d863" style="height: auto; min-width: 30px; min-height: 30px; width: 600px; left: 80px; top: 571px;"><div class="sl-block-content" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 13; color: rgb(170, 170, 170);">
<pre><span style="font-size:16px">http://bit.ly/svg-teams</span></pre>
</div></div>
<div class="sl-block" data-block-type="image" data-block-id="8358a5dfdca8a6b8897ce8c10624d8b9" style="min-width: 30px; min-height: 30px; width: 552.256684491979px; height: 156px; left: 204px; top: 366px;"><div class="sl-block-content" style="z-index: 14;"><img src="https://s3.amazonaws.com/media-p.slid.es/uploads/alexwalker/images/610544/fuP6yeG_-_Imgur.png" style="visibility: visible;" data-natural-width="662" data-natural-height="187"></div></div></section><section data-id="bf7c9e4bd470c7b479d2c176c35d3f58"><div class="sl-block" data-block-type="text" style="width: 800px; left: 58px; top: 127px; height: auto;" data-block-id="4dd9fd6250d7b98907621ca169eb9c2a"><div class="sl-block-content" data-placeholder-tag="h1" data-placeholder-text="Title Text" style="color: rgb(255, 199, 36); z-index: 13;">
<h1>Scaling SVGs to 100%</h1>
</div></div>

<div class="sl-block" data-block-type="text" data-block-id="c4ba45039be8ffc565f9354bfc01c289" style="height: auto; min-width: 30px; min-height: 30px; width: 715px; left: 112px; top: 266px;"><div class="sl-block-content" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 12; font-size: 78%;">
<ul>
	<li>SVG \'thinks\' in pixels (unless you set it otherwise).<br>
	 </li>
	<li>Most editors set a width &amp; height (in pixels) on the SVG element.<br>
	 </li>
	<li>Setting the width and height to 100% alone won\'t work.<br>
	 </li>
	<li>We need to add the \'viewbox\' attribute.</li>
</ul>
</div></div></section><section data-id="702a586050af4fbd41edb2521bd7ce1c"><div class="sl-block" data-block-type="shape" style="min-width: 4px; min-height: 4px; width: 300px; height: 380px; left: 613px; top: 199px;" data-block-id="c8f7fc90be5f15a3fdbe195801ba08d6"><div class="sl-block-content" data-shape-type="rect" data-shape-fill-color="rgb(74, 134, 232)" data-shape-stretch="true" style="z-index: 12;"><svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="100%" height="100%" preserveaspectratio="none" viewbox="0 0 300 380"><rect width="300" height="380" class="shape-element" fill="rgb(74, 134, 232)"></rect></svg></div></div>
<div class="sl-block" data-block-type="shape" style="min-width: 4px; min-height: 4px; width: 162px; height: 214px; left: 624px; top: 173px;" data-block-id="27ab35b05ca06b1040c6ee472823109f"><div class="sl-block-content" data-shape-type="symbol-heart-stroke" data-shape-fill-color="rgb(255, 0, 0)" data-shape-stretch="false" style="z-index: 14;"><svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="100%" height="100%" preserveaspectratio="xMidYMid" viewbox="0 2 32 28"><g class="shape-element" fill="rgb(255, 0, 0)"><path d="M23.113 6c2.457 0 4.492 1.82 4.836 4.188l-11.945 13.718-11.953-13.718c0.344-2.368 2.379-4.188 4.836-4.188 2.016 0 3.855 2.164 3.855 2.164l3.258 3.461 3.258-3.461c0 0 1.84-2.164 3.855-2.164zM23.113 2c-2.984 0-5.5 1.578-7.113 3.844-1.613-2.266-4.129-3.844-7.113-3.844-4.903 0-8.887 3.992-8.887 8.891v0.734l16.008 18.375 15.992-18.375v-0.734c0-4.899-3.984-8.891-8.887-8.891v0z"></path></g></svg></div></div>
<div class="sl-block" data-block-type="shape" style="min-width: 4px; min-height: 4px; width: 171px; height: 154px; left: 619px; top: 206px;" data-block-id="3ada4c30e32f6ad65d9a77d289df02b3"><div class="sl-block-content" data-shape-type="rect" data-shape-fill-color="rgb(111, 168, 220)" data-shape-stretch="true" style="z-index: 13;" data-shape-stroke-color="#020508" data-shape-stroke-width="2"><svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="100%" height="100%" preserveaspectratio="none" viewbox="0 0 171 154"><defs><clippath id="shape-mask-731-1410258327333"><rect width="171" height="154"></rect></clippath></defs><rect width="171" height="154" clip-path="url(#shape-mask-731-1410258327333)" class="shape-element" fill="rgb(111, 168, 220)" stroke="#020508" stroke-width="4"></rect></svg></div></div>
<div class="sl-block" data-block-type="shape" style="min-width: 4px; min-height: 4px; width: 162px; height: 214px; left: 625px; top: 173px;" data-block-id="df888b2bb92aef70c241ef1e10acb51e"><div class="sl-block-content fragment" data-shape-type="symbol-heart-stroke" data-shape-fill-color="rgb(255, 0, 0)" data-shape-stretch="false" style="z-index: 18;" data-fragment-index="0"><svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="100%" height="100%" preserveaspectratio="xMidYMid" viewbox="0 2 32 28"><g class="shape-element" fill="rgb(255, 0, 0)"><path d="M23.113 6c2.457 0 4.492 1.82 4.836 4.188l-11.945 13.718-11.953-13.718c0.344-2.368 2.379-4.188 4.836-4.188 2.016 0 3.855 2.164 3.855 2.164l3.258 3.461 3.258-3.461c0 0 1.84-2.164 3.855-2.164zM23.113 2c-2.984 0-5.5 1.578-7.113 3.844-1.613-2.266-4.129-3.844-7.113-3.844-4.903 0-8.887 3.992-8.887 8.891v0.734l16.008 18.375 15.992-18.375v-0.734c0-4.899-3.984-8.891-8.887-8.891v0z"></path></g></svg></div></div>
<div class="sl-block" data-block-type="shape" style="min-width: 4px; min-height: 4px; width: 288px; height: 154px; left: 619px; top: 206px;" data-block-id="07de31eb269d2732ab0a5172340c9edd"><div class="sl-block-content fragment" data-shape-type="rect" data-shape-fill-color="rgb(111, 168, 220)" data-shape-stretch="true" style="z-index: 17;" data-shape-stroke-color="#00ff00" data-shape-stroke-width="3" data-fragment-index="0"><svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="100%" height="100%" preserveaspectratio="none" viewbox="0 0 288 154"><defs><clippath id="shape-mask-732-1410258327343"><rect width="288" height="154"></rect></clippath></defs><rect width="288" height="154" clip-path="url(#shape-mask-732-1410258327343)" class="shape-element" fill="rgb(111, 168, 220)" stroke="#00ff00" stroke-width="6"></rect></svg></div></div>
<div class="sl-block" data-block-type="shape" style="min-width: 4px; min-height: 4px; width: 277.14450867052px; height: 366px; left: 625px; top: 161px;" data-block-id="39feecc4fca789e780c1596e67b09c33"><div class="sl-block-content fragment" data-shape-type="symbol-heart-stroke" data-shape-fill-color="rgb(255, 0, 0)" data-shape-stretch="false" style="z-index: 25;" data-fragment-index="1"><svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="100%" height="100%" preserveaspectratio="xMidYMid" viewbox="0 2 32 28"><g class="shape-element" fill="rgb(255, 0, 0)"><path d="M23.113 6c2.457 0 4.492 1.82 4.836 4.188l-11.945 13.718-11.953-13.718c0.344-2.368 2.379-4.188 4.836-4.188 2.016 0 3.855 2.164 3.855 2.164l3.258 3.461 3.258-3.461c0 0 1.84-2.164 3.855-2.164zM23.113 2c-2.984 0-5.5 1.578-7.113 3.844-1.613-2.266-4.129-3.844-7.113-3.844-4.903 0-8.887 3.992-8.887 8.891v0.734l16.008 18.375 15.992-18.375v-0.734c0-4.899-3.984-8.891-8.887-8.891v0z"></path></g></svg></div></div>
<div class="sl-block" data-block-type="shape" style="min-width: 4px; min-height: 4px; width: 289px; height: 271px; left: 619px; top: 204px;" data-block-id="c582cf3c463ab81026ddb50d04bd542f"><div class="sl-block-content fragment" data-shape-type="rect" data-shape-fill-color="rgb(111, 168, 220)" data-shape-stretch="true" style="z-index: 24;" data-shape-stroke-color="#020508" data-shape-stroke-width="2" data-fragment-index="1"><svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="100%" height="100%" preserveaspectratio="none" viewbox="0 0 289 271"><defs><clippath id="shape-mask-733-1410258327352"><rect width="289" height="271"></rect></clippath></defs><rect width="289" height="271" clip-path="url(#shape-mask-733-1410258327352)" class="shape-element" fill="rgb(111, 168, 220)" stroke="#020508" stroke-width="4"></rect></svg></div></div>
<div class="sl-block" data-block-type="text" style="height: auto; min-width: 30px; min-height: 30px; width: 97px; left: 800px; top: 537px;" data-block-id="2c9c94f3d004b043dfc8fe58edf44556"><div class="sl-block-content" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 15; color: rgb(164, 194, 244);">
<p>&lt;html&gt;</p>
</div></div>
<div class="sl-block" data-block-type="code" style="min-width: 30px; min-height: 30px; width: 523px; height: 380px; left: 57px; top: 196px;" data-block-id="8ee6769410c1517ca7baecb892998942"><div class="sl-block-content" style="z-index: 10; font-size: 120%;"><pre><code>
&lt;svg                            
                                   ...  &gt;

  
    &lt;path d="M128.2 41.3 L114.5 54.6Q 110 
    32.3 ... /&gt;

&lt;/svg&gt;</code></pre></div></div>
<div class="sl-block" data-block-type="text" style="height: auto; min-width: 30px; min-height: 30px; width: 427px; left: 119px; top: 224px;" data-block-id="cb07a31d651e1c28d2781b0a1797c9ae"><div class="sl-block-content fragment" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 22; font-size: 75%;" data-fragment-index="1">
<pre style="text-align:left"><span style="color:#FF8C00">width</span>="<span style="color:#00FF00">100%</span>"<span style="color:#008000"> </span><span style="color:#FF8C00">height</span>="<span style="color:#00FF00">100</span>
</pre>

<pre><span style="color:rgb(255, 255, 255)"><span style="color:rgb(255, 140, 0)">viewbox</span>="</span><span style="color:#00FF00">0,0,150,150</span>"</pre>
</div></div>
<div class="sl-block" data-block-type="text" style="width: 800px; left: 57px; top: 92px; height: auto;" data-block-id="671f3b54b8f414652beefb49e769188c"><div class="sl-block-content" data-placeholder-tag="h1" data-placeholder-text="Title Text" style="color: rgb(255, 199, 36); z-index: 16;">
<h1>The Scaling Trick</h1>
</div></div>
<div class="sl-block" data-block-type="code" style="min-width: 30px; min-height: 30px; width: 523px; height: 383px; left: 59px; top: 196px;" data-block-id="5b5299573687854ad5cc99af172c45a2"><div class="sl-block-content fragment" style="z-index: 21; font-size: 120%;" data-fragment-index="1"><pre><code>
&lt;svg                             ...  &gt;



    &lt;path d="M128.2 41.3 L114.5 54.6 Q110 
    32.3 ... /&gt;

&lt;/svg&gt;</code></pre></div></div>
<div class="sl-block" data-block-type="text" style="height: auto; min-width: 30px; min-height: 30px; width: 505px; left: 125px; top: 224px;" data-block-id="b03df469aa0efd7ad3d81eae5c8cc812"><div class="sl-block-content" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 11; font-size: 75%;">
<pre style="text-align:left"><span style="color:#FF8C00">width</span>="<font color="#00ff00">150</font>"<span style="color:#008000"> </span><span style="color:#FF8C00">height</span>="<span style="color:#00FF00">150</span>"</pre>
</div></div>
<div class="sl-block" data-block-type="code" style="min-width: 30px; min-height: 30px; width: 520px; height: 380px; left: 59px; top: 196px;" data-block-id="7582e1a835cf51f650f7630aee990743"><div class="sl-block-content fragment" style="z-index: 19; font-size: 120%;" data-fragment-index="0"><pre><code>
&lt;svg                             ...  &gt;



    &lt;path d="M128.2 41.3 L114.5 54.6Q 110 
    32.3 ... /&gt;

&lt;/svg&gt;</code></pre></div></div>
<div class="sl-block" data-block-type="text" style="height: auto; min-width: 30px; min-height: 30px; width: 505px; left: 120px; top: 224px;" data-block-id="3e9555c25f25f33f45f5c74a71676530"><div class="sl-block-content fragment" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 20; font-size: 75%;" data-fragment-index="0">
<pre style="text-align:left"><span style="color:#FF8C00">width</span>="<span style="color:#00FF00">100%</span>"<span style="color:#008000"> </span><span style="color:#FF8C00">height</span>="<span style="color:#00FF00">100%</span>"</pre>
</div></div>
<div class="sl-block" data-block-type="shape" data-block-id="64d14e4a29b67207e0549f417d98615f" style="min-width: 4px; min-height: 4px; width: 47.5px; height: 47.5px; left: 849px; top: 254px;"><div class="sl-block-content fragment" data-shape-type="arrow-right" data-shape-fill-color="rgb(0, 255, 0)" data-shape-stretch="false" style="z-index: 23;" data-fragment-index="0"><svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="100%" height="100%" preserveaspectratio="xMidYMid" viewbox="0 0 48 48"><polygon points="0,14.399999999999999 24,14.399999999999999 24,0 48,24 24,48 24,33.599999999999994 0,33.599999999999994" class="shape-element" fill="rgb(0, 255, 0)"></polygon></svg></div></div>
<div class="sl-block" data-block-type="shape" data-block-id="6889643f8b9c258b9dfe9a51d2217f58" style="min-width: 4px; min-height: 4px; width: 70px; height: 39px; left: 589px; top: 187px;"><div class="sl-block-content fragment" data-shape-type="circle" data-shape-fill-color="rgba(0, 0, 0, 0)" data-shape-stretch="false" style="z-index: 26;" data-shape-stroke-color="#00ff00" data-shape-stroke-width="6" data-fragment-index="2"><svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="100%" height="100%" preserveaspectratio="xMidYMid" viewbox="0 0 39 39"><defs><clippath id="shape-mask-734-1410258327423"><ellipse rx="19.5" ry="19.5" cx="19.5" cy="19.5"></ellipse></clippath></defs><ellipse rx="19.5" ry="19.5" cx="19.5" cy="19.5" clip-path="url(#shape-mask-734-1410258327423)" class="shape-element" fill="rgba(0, 0, 0, 0)" stroke="#00ff00" stroke-width="12"></ellipse></svg></div></div>
<div class="sl-block" data-block-type="shape" style="min-width: 4px; min-height: 4px; width: 70px; height: 39px; left: 872px; top: 451px;" data-block-id="b42f927f9e88bbdaca3a48fdc7ded16f"><div class="sl-block-content fragment" data-shape-type="circle" data-shape-fill-color="rgba(0, 0, 0, 0)" data-shape-stretch="false" style="z-index: 28;" data-shape-stroke-color="#00ff00" data-shape-stroke-width="6" data-fragment-index="2"><svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="100%" height="100%" preserveaspectratio="xMidYMid" viewbox="0 0 39 39"><defs><clippath id="shape-mask-735-1410258327428"><ellipse rx="19.5" ry="19.5" cx="19.5" cy="19.5"></ellipse></clippath></defs><ellipse rx="19.5" ry="19.5" cx="19.5" cy="19.5" clip-path="url(#shape-mask-735-1410258327428)" class="shape-element" fill="rgba(0, 0, 0, 0)" stroke="#00ff00" stroke-width="12"></ellipse></svg></div></div></section><section data-id="1ad83b83a4b6e5daa6d283c844086f9f"><div class="sl-block" data-block-type="text" style="width: 430px; left: 80px; top: 70px; height: auto;" data-block-id="ac253fbca7e9d0df444ed7923556998b"><div class="sl-block-content" data-placeholder-tag="h2" data-placeholder-text="Title Text" style="text-align: left; color: rgb(255, 199, 36); z-index: 10;">
<h2>Changing layouts</h2>
</div></div>
<div class="sl-block" data-block-type="text" style="width: 621px; left: 80px; top: 164px; height: auto;" data-block-id="b6cc8ef156e2e5d51347cbcb5e72b40b"><div class="sl-block-content" data-placeholder-tag="p" data-placeholder-text="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi nec metus justo. Aliquam erat volutpat." style="z-index: 13; text-align: left;">
<p>Refitting layouts to suit different screens.</p>
</div></div>
<div class="sl-block" data-block-type="image" style="width: 524.961636828645px; height: 311px; left: 218px; top: 255px;" data-block-id="a1fedb08d276d660fde687a6076f7655"><div class="sl-block-content" style="z-index: 11;"><img src="https://s3.amazonaws.com/media-p.slid.es/uploads/alexwalker/images/610414/htZiy3T_-_Imgur.png" style="visibility: visible;" data-natural-width="660" data-natural-height="391"></div></div>
<div class="sl-block" data-block-type="text" data-block-id="982c5b121df332787e111603091d571b" style="height: auto; min-width: 30px; min-height: 30px; width: 600px; left: 80px; top: 597px;"><div class="sl-block-content" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 14; text-align: left; color: rgb(170, 170, 170);">
<pre><span style="font-size:16px">http://bit.ly/reformatting-svg</span></pre>
</div></div></section><section data-id="309ffc328434ee7f4479532c1cded364"><div class="sl-block" data-block-type="text" style="width: 456px; left: 23px; top: 87px; height: auto;" data-block-id="e2662f5c03d53e463b6c4fbfb6c558e8"><div class="sl-block-content" data-placeholder-tag="h2" data-placeholder-text="Title Text" style="text-align: left; color: rgb(255, 199, 36); z-index: 10;">
<h2>Responsive Maps</h2>
</div></div>
<div class="sl-block" data-block-type="text" style="width: 430px; left: 25px; top: 199px; height: auto;" data-block-id="4817f0b290d45d0ed83c081982c7bbe3"><div class="sl-block-content" data-placeholder-tag="p" data-placeholder-text="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi nec metus justo. Aliquam erat volutpat." style="z-index: 12; text-align: left;">
<ul>
	<li>Drawn in Inkscape</li>
	<li>Hand-hacked in Sublime</li>
	<li>Tuned in CodePen.io</li>
</ul>

<p> </p>
</div></div>
<div class="sl-block" data-block-type="image" style="width: 454px; height: 343.224px; left: 426px; top: 210px;" data-block-id="a988e987b5e794a61bef098492534cc5"><div class="sl-block-content" style="z-index: 11;"><img src="https://s3.amazonaws.com/media-p.slid.es/uploads/alexwalker/images/587710/svg-map.png" style="visibility: visible;" data-natural-width="500" data-natural-height="378"></div></div>
<div class="sl-block" data-block-type="text" data-block-id="90b807659bc12a8f5b9fb9d38baa3f69" style="height: auto; min-width: 30px; min-height: 30px; width: 460px; left: 37px; top: 577px;"><div class="sl-block-content" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 13; text-align: left; font-size: 92%; color: rgb(170, 170, 170);">
<pre><span style="font-size:16px">http://bit.ly/responsive-svg-maps</span></pre>
</div></div></section><section data-id="7f6d546efb86db08eeed6985861ed0c7"><div class="sl-block" data-block-type="text" style="width: 864px; left: 73px; top: 71px; height: auto;" data-block-id="19774613617e726f004010f92393765d"><div class="sl-block-content" data-placeholder-tag="h2" data-placeholder-text="Title Text" style="text-align: left; color: rgb(255, 199, 36); z-index: 10;">
<h2>File sizes: SVG vs. PNG</h2>
</div></div>

<div class="sl-block" data-block-type="iframe" data-block-id="19245afdee5718d3bceb2adc4880a2f8" style="min-width: 30px; min-height: 30px; width: 815px; height: 432px; left: 74px; top: 168px;"><div class="sl-block-content" style="z-index: 11;"><iframe webkitallowfullscreen="" mozallowfullscreen="" allowfullscreen="" data-src="https://plot.ly/~AlexWalker/4"></iframe></div></div>
<div class="sl-block" data-block-type="shape" data-block-id="471ec0d99464908377f4cd1d0a7c1c4d" style="min-width: 4px; min-height: 4px; width: 809px; height: 35px; left: 80px; top: 164px;"><div class="sl-block-content" data-shape-type="rect" data-shape-fill-color="#000000" data-shape-stretch="true" style="z-index: 12;"><svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="100%" height="100%" preserveaspectratio="none" viewbox="0 0 809 35"><rect width="809" height="35" class="shape-element" fill="#000000"></rect></svg></div></div>
<div class="sl-block" data-block-type="shape" style="min-width: 4px; min-height: 4px; width: 21px; height: 436px; left: 868px; top: 164px;" data-block-id="e6c0a1985f68b4b4aa1976020801e5a8"><div class="sl-block-content" data-shape-type="rect" data-shape-fill-color="#000000" data-shape-stretch="true" style="z-index: 14;"><svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="100%" height="100%" preserveaspectratio="none" viewbox="0 0 21 436"><rect width="21" height="436" class="shape-element" fill="#000000"></rect></svg></div></div></section><section data-id="4962f950509ba014e6a328d0ba73b45e"><div class="sl-block" data-block-type="text" style="width: 430px; left: 23px; top: 77px; height: auto;" data-block-id="278d72ae337f2cfd951c348dfac4e054"><div class="sl-block-content" data-placeholder-tag="h2" data-placeholder-text="Title Text" style="text-align: left; color: rgb(255, 199, 36); z-index: 11; font-size: 110%;">
<h2>Play by Play</h2>
</div></div>
<div class="sl-block" data-block-type="text" style="width: 442px; left: 23px; top: 198px; height: auto;" data-block-id="eeea3d2aed294bbccdf3af1a5ef8e9e3"><div class="sl-block-content" data-placeholder-tag="p" data-placeholder-text="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi nec metus justo. Aliquam erat volutpat." style="z-index: 12; text-align: left;">
<p>Most CSS3 properties </p>

<p>are supported within SVG.</p>

<p> </p>

<p>The Exception?</p>

<p>3D Transforms.  </p>

<p> </p>

<p>Boo.. :-(</p>
</div></div>
<div class="sl-block" data-block-type="image" data-block-id="25b35f249998ec7e290c75e9c65060a6" style="min-width: 30px; min-height: 30px; width: 451.2px; height: 376px; left: 437px; top: 143px;"><div class="sl-block-content" style="z-index: 13;"><img src="https://s3.amazonaws.com/media-p.slid.es/uploads/alexwalker/images/610476/g2pYskj_-_Imgur.png" style="visibility: visible;" data-natural-width="576" data-natural-height="480"></div></div>
<div class="sl-block" data-block-type="text" data-block-id="1869d7aa265083b0ac3356aa5b2c2997" style="height: auto; min-width: 30px; min-height: 30px; width: 600px; left: 23px; top: 591px;"><div class="sl-block-content" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 14; text-align: left; color: rgb(170, 170, 170);">
<pre><span style="font-size:16px">http://bit.ly/play-by-play</span></pre>
</div></div></section><section data-id="0ac97a8ff5f7448a55e927d16f41b258"><div class="sl-block" data-block-type="text" style="width: 800px; left: 80px; top: 232px; height: auto;" data-block-id="1567ffe1a4ea621ec300832e47a237d1"><div class="sl-block-content" data-placeholder-tag="h1" data-placeholder-text="Title Text" style="color: rgb(255, 199, 36); text-align: center; font-size: 112%; z-index: 10;">
<h1>Issues &amp;</h1>

<h1>G  tchas</h1>
</div></div>
<div class="sl-block" data-block-type="shape" data-block-id="c537d4454cdada5c6ee2cc5c780e2cfa" style="min-width: 4px; min-height: 4px; width: 54px; height: 42px; left: 395px; top: 390px;"><div class="sl-block-content" data-shape-type="symbol-wondering" data-shape-fill-color="rgb(253, 189, 4)" data-shape-stretch="false" style="z-index: 12;"><svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="100%" height="100%" preserveaspectratio="xMidYMid" viewbox="0 0 32 32"><g class="shape-element" fill="rgb(253, 189, 4)"><path d="M16 32c8.837 0 16-7.163 16-16s-7.163-16-16-16-16 7.163-16 16 7.163 16 16 16zM16 3c7.18 0 13 5.82 13 13s-5.82 13-13 13-13-5.82-13-13 5.82-13 13-13zM23.304 18.801l0.703 2.399-13.656 4-0.703-2.399zM8 10c0-1.105 0.895-2 2-2s2 0.895 2 2c0 1.105-0.895 2-2 2-1.105 0-2-0.895-2-2zM20 10c0-1.105 0.895-2 2-2s2 0.895 2 2c0 1.105-0.895 2-2 2-1.105 0-2-0.895-2-2z"></path></g></svg></div></div></section><section data-id="20ae38d53f7fbf0ab9dab7608a319bb4"><div class="sl-block" data-block-type="text" style="width: 800px; left: 59px; top: 162px; height: auto;" data-block-id="15845835c14cd26ec3e8f9cfe8da097a"><div class="sl-block-content" data-placeholder-tag="h1" data-placeholder-text="Title Text" style="z-index: 10; color: rgb(255, 199, 36);">
<h1>CSS Pre-processors</h1>
</div></div>
<div class="sl-block" data-block-type="text" style="width: 721px; left: 174px; top: 300px; height: auto;" data-block-id="c374dd7239a4f0c9a70533dd472ecd22"><div class="sl-block-content" data-placeholder-tag="h2" data-placeholder-text="Subtitle" style="z-index: 11; text-align: left;">
<h3>Say goodbye to Sass, Less, Stylus, etc ... </h3>
</div></div>
<div class="sl-block" data-block-type="text" style="width: 695px; left: 174px; top: 370px; height: auto;" data-block-id="924b3649af0c407ee14ca877c98409eb"><div class="sl-block-content" data-placeholder-tag="h2" data-placeholder-text="Subtitle" style="z-index: 12; text-align: left;">
<h3>Say hello to CSS prefixes again</h3>
</div></div>

<div class="sl-block" data-block-type="shape" data-block-id="02739c33d3ffbdbd7968fff1f3fc0756" style="min-width: 4px; min-height: 4px; width: 44px; height: 44px; left: 105px; top: 303px;"><div class="sl-block-content" data-shape-type="symbol-x-circle" data-shape-fill-color="rgb(204, 0, 0)" data-shape-stretch="false" style="z-index: 13;"><svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="100%" height="100%" preserveaspectratio="xMidYMid" viewbox="0 0 32 32"><g class="shape-element" fill="rgb(204, 0, 0)"><path d="M16 0c-8.836 0-16 7.164-16 16s7.164 16 16 16 16-7.164 16-16-7.164-16-16-16zM23.914 21.086l-2.828 2.828-5.086-5.086-5.086 5.086-2.828-2.828 5.086-5.086-5.086-5.086 2.828-2.828 5.086 5.086 5.086-5.086 2.828 2.828-5.086 5.086 5.086 5.086z"></path></g></svg></div></div>
<div class="sl-block" data-block-type="shape" style="min-width: 4px; min-height: 4px; width: 44px; height: 44px; left: 105px; top: 370px;" data-block-id="a68782a90661a579cfb41d6594af3d07"><div class="sl-block-content" data-shape-type="symbol-checkmark-circle" data-shape-fill-color="rgb(106, 168, 79)" data-shape-stretch="false" style="z-index: 15;"><svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="100%" height="100%" preserveaspectratio="xMidYMid" viewbox="0 0 32 32"><g class="shape-element" fill="rgb(106, 168, 79)"><path d="M16 0c-8.836 0-16 7.164-16 16s7.164 16 16 16 16-7.164 16-16-7.164-16-16-16zM13.52 23.383l-7.362-7.363 2.828-2.828 4.533 4.535 9.617-9.617 2.828 2.828-12.444 12.445z"></path></g></svg></div></div></section><section data-id="6c1c5fbeb54e69085fc3eb0b83781bd4"><div class="sl-block" data-block-type="text" style="width: 683px; left: 132px; top: 94px; height: auto;" data-block-id="cd6557fd0804efd4feeccd308d9b9e18"><div class="sl-block-content" data-placeholder-tag="h1" data-placeholder-text="Title Text" style="color: rgb(255, 199, 36); z-index: 11;">
<h1>  Upload Support can be... patchy</h1>
</div></div>


<div class="sl-block" data-block-type="shape" data-block-id="64cbef5083e0cbbd18dedb6b9e37340c" style="min-width: 4px; min-height: 4px; width: 48px; height: 48px; left: 103px; top: 310px;"><div class="sl-block-content fragment" data-shape-type="symbol-star" data-shape-fill-color="rgb(168, 39, 107)" data-shape-stretch="false" style="z-index: 12;" data-fragment-index="0"><svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="100%" height="100%" preserveaspectratio="xMidYMid" viewbox="0 0 32 32"><g class="shape-element" fill="rgb(168, 39, 107)"><path d="M22.137 19.625l9.863-7.625h-12l-4-12-4 12h-12l9.875 7.594-3.875 12.406 10.016-7.68 9.992 7.68z"></path></g></svg></div></div>
<div class="sl-block" data-block-type="shape" style="min-width: 4px; min-height: 4px; width: 48px; height: 48px; left: 103px; top: 388px;" data-block-id="6c4ded0f58e868b34f8553fa75c4d3e4"><div class="sl-block-content fragment" data-shape-type="symbol-star" data-shape-fill-color="rgb(168, 39, 107)" data-shape-stretch="false" style="z-index: 13;" data-fragment-index="1"><svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="100%" height="100%" preserveaspectratio="xMidYMid" viewbox="0 0 32 32"><g class="shape-element" fill="rgb(168, 39, 107)"><path d="M22.137 19.625l9.863-7.625h-12l-4-12-4 12h-12l9.875 7.594-3.875 12.406 10.016-7.68 9.992 7.68z"></path></g></svg></div></div>
<div class="sl-block" data-block-type="shape" data-block-id="01ba929a33819c82e1c9a92ef515c015" style="min-width: 4px; min-height: 4px; width: 56px; height: 56px; left: 125px; top: 103px;"><div class="sl-block-content" data-shape-type="arrow-up" data-shape-fill-color="rgb(106, 168, 79)" data-shape-stretch="false" style="z-index: 14;"><svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="100%" height="100%" preserveaspectratio="xMidYMid" viewbox="0 0 56 56"><polygon points="28,0 56,28 39.199999999999996,28 39.199999999999996,56 16.8,56 16.8,28 0,28 28,0" class="shape-element" fill="rgb(106, 168, 79)"></polygon></svg></div></div>
<div class="sl-block" data-block-type="text" style="width: 734px; left: 175px; top: 313px; height: auto;" data-block-id="d80b5381d33e4ab77ac4c33268f81631"><div class="sl-block-content" data-placeholder-tag="h2" data-placeholder-text="Subtitle" style="z-index: 15; text-align: left;">
<h3>Image hosting services: Flickr, Imgur, etc </h3>
</div></div>
<div class="sl-block" data-block-type="text" style="width: 741px; left: 175px; top: 394px; height: auto;" data-block-id="f01971be25d6b69ab06a897cb72f957f"><div class="sl-block-content" data-placeholder-tag="h2" data-placeholder-text="Subtitle" style="z-index: 16; text-align: left;">
<h3>CMSs like Wordpress block SVG upload</h3>
</div></div>
<div class="sl-block" data-block-type="text" style="width: 752px; left: 174px; top: 473px; height: auto;" data-block-id="e29beb2c9bd5f105cd609ac2efa662f3"><div class="sl-block-content" data-placeholder-tag="h2" data-placeholder-text="Subtitle" style="z-index: 17; text-align: left;">
<h3>Github is a free, reliable hosting option</h3>
</div></div>
<div class="sl-block" data-block-type="shape" style="min-width: 4px; min-height: 4px; width: 48px; height: 48px; left: 103px; top: 466px;" data-block-id="013882baa0028825c31879ea80506e39"><div class="sl-block-content fragment" data-shape-type="symbol-star" data-shape-fill-color="rgb(168, 39, 107)" data-shape-stretch="false" style="z-index: 18;" data-fragment-index="1"><svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="100%" height="100%" preserveaspectratio="xMidYMid" viewbox="0 0 32 32"><g class="shape-element" fill="rgb(168, 39, 107)"><path d="M22.137 19.625l9.863-7.625h-12l-4-12-4 12h-12l9.875 7.594-3.875 12.406 10.016-7.68 9.992 7.68z"></path></g></svg></div></div></section><section data-id="a390374f6d40677aa48366015b4ef48f"><div class="sl-block" data-block-type="text" style="width: 800px; left: 92px; top: 183px; height: auto;" data-block-id="5970c5dd9c0b7bdbc2802bc72be734d9"><div class="sl-block-content" data-placeholder-tag="h1" data-placeholder-text="Title Text" style="color: rgb(255, 199, 36); font-size: 125%;">
<h1>Tools &amp;<br>
Helpers</h1>
</div></div></section><section data-id="16e6b03cc92e61bb3cc88d6c166484ee"><div class="sl-block" data-block-type="text" style="width: 800px; left: 56px; top: 88px; height: auto;" data-block-id="c64deca8405f15742366205b5438cac5"><div class="sl-block-content" data-placeholder-tag="h2" data-placeholder-text="Title Text" style="color: rgb(241, 194, 50); font-size: 125%; z-index: 11;">
<h2>Use Code Playgrounds</h2>
</div></div>
<div class="sl-block" data-block-type="text" style="width: 344px; left: 226px; top: 210px; height: auto;" data-block-id="dbe94c3f89458e181897cbf45a26afe8"><div class="sl-block-content" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 12; color: rgb(201, 218, 248); font-size: 114%;">
<ul>
	<li class="fragment" data-fragment-index="0">Codepen.io</li>
	<li class="fragment" data-fragment-index="0">CSSDeck.com</li>
	<li class="fragment" data-fragment-index="0">Dabblet.com</li>
</ul>
</div></div>
<div class="sl-block" data-block-type="text" data-block-id="0ef6577dc5adcc6ddaf477c344669c18" style="height: auto; min-width: 30px; min-height: 30px; width: 600px; left: 148px; top: 381px;"><div class="sl-block-content fragment" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 13;" data-fragment-index="1">
<p>.. all render SVG as you write/paste it</p>
</div></div>
<div class="sl-block" data-block-type="text" style="height: auto; min-width: 30px; min-height: 30px; width: 600px; left: 180px; top: 467px;" data-block-id="534aa65ecf57cfadcc2d1329844559b5"><div class="sl-block-content fragment" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 14;" data-fragment-index="2">
<p>  (WARNING: Never <span style="color:#FFFF00"><em>re-open </em></span>your hand-edited SVG in your Illustrator/Inkscape!)</p>
</div></div>
<div class="sl-block" data-block-type="shape" data-block-id="f66de83f1bda433255d2bdae3f38f566" style="min-width: 4px; min-height: 4px; width: 44.33333333333333px; height: 28px; left: 226px; top: 220px;"><div class="sl-block-content fragment" data-shape-type="symbol-globe" data-shape-fill-color="rgb(109, 158, 235)" data-shape-stretch="false" style="z-index: 15;" data-fragment-index="0"><svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="100%" height="100%" preserveaspectratio="xMidYMid" viewbox="0 2 30 30"><g class="shape-element" fill="rgb(109, 158, 235)"><path d="M15 2c-8.284 0-15 6.716-15 15s6.716 15 15 15c8.284 0 15-6.716 15-15s-6.716-15-15-15zM23.487 22c0.268-1.264 0.437-2.606 0.492-4h3.983c-0.104 1.381-0.426 2.722-0.959 4h-3.516zM6.513 12c-0.268 1.264-0.437 2.606-0.492 4h-3.983c0.104-1.381 0.426-2.722 0.959-4h3.516zM21.439 12c0.3 1.28 0.481 2.62 0.54 4h-5.979v-4h5.439zM16 10v-5.854c0.456 0.133 0.908 0.355 1.351 0.668 0.831 0.586 1.625 1.488 2.298 2.609 0.465 0.775 0.867 1.638 1.203 2.578h-4.852zM10.351 7.422c0.673-1.121 1.467-2.023 2.298-2.609 0.443-0.313 0.895-0.535 1.351-0.668v5.854h-4.852c0.336-0.94 0.738-1.803 1.203-2.578zM14 12v4h-5.979c0.059-1.38 0.24-2.72 0.54-4h5.439zM2.997 22c-0.533-1.278-0.854-2.619-0.959-4h3.983c0.055 1.394 0.224 2.736 0.492 4h-3.516zM8.021 18h5.979v4h-5.439c-0.3-1.28-0.481-2.62-0.54-4zM14 24v5.854c-0.456-0.133-0.908-0.355-1.351-0.668-0.831-0.586-1.625-1.488-2.298-2.609-0.465-0.775-0.867-1.638-1.203-2.578h4.852zM19.649 26.578c-0.673 1.121-1.467 2.023-2.298 2.609-0.443 0.312-0.895 0.535-1.351 0.668v-5.854h4.852c-0.336 0.94-0.738 1.802-1.203 2.578zM16 22v-4h5.979c-0.059 1.38-0.24 2.72-0.54 4h-5.439zM23.98 16c-0.055-1.394-0.224-2.736-0.492-4h3.516c0.533 1.278 0.855 2.619 0.959 4h-3.983zM25.958 10h-2.997c-0.582-1.836-1.387-3.447-2.354-4.732 1.329 0.636 2.533 1.488 3.585 2.54 0.671 0.671 1.261 1.404 1.766 2.192zM5.808 7.808c1.052-1.052 2.256-1.904 3.585-2.54-0.967 1.285-1.771 2.896-2.354 4.732h-2.997c0.504-0.788 1.094-1.521 1.766-2.192zM4.042 24h2.997c0.583 1.836 1.387 3.447 2.354 4.732-1.329-0.636-2.533-1.488-3.585-2.54-0.671-0.671-1.261-1.404-1.766-2.192zM24.192 26.192c-1.052 1.052-2.256 1.904-3.585 2.54 0.967-1.285 1.771-2.896 2.354-4.732h2.997c-0.504 0.788-1.094 1.521-1.766 2.192z"></path></g></svg></div></div>
<div class="sl-block" data-block-type="shape" style="min-width: 4px; min-height: 4px; width: 44.33333333333333px; height: 28px; left: 226px; top: 264px;" data-block-id="1abb21db6c3b5d4ac2b6472e497cfee8"><div class="sl-block-content fragment" data-shape-type="symbol-globe" data-shape-fill-color="rgb(109, 158, 235)" data-shape-stretch="false" style="z-index: 16;" data-fragment-index="0"><svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="100%" height="100%" preserveaspectratio="xMidYMid" viewbox="0 2 30 30"><g class="shape-element" fill="rgb(109, 158, 235)"><path d="M15 2c-8.284 0-15 6.716-15 15s6.716 15 15 15c8.284 0 15-6.716 15-15s-6.716-15-15-15zM23.487 22c0.268-1.264 0.437-2.606 0.492-4h3.983c-0.104 1.381-0.426 2.722-0.959 4h-3.516zM6.513 12c-0.268 1.264-0.437 2.606-0.492 4h-3.983c0.104-1.381 0.426-2.722 0.959-4h3.516zM21.439 12c0.3 1.28 0.481 2.62 0.54 4h-5.979v-4h5.439zM16 10v-5.854c0.456 0.133 0.908 0.355 1.351 0.668 0.831 0.586 1.625 1.488 2.298 2.609 0.465 0.775 0.867 1.638 1.203 2.578h-4.852zM10.351 7.422c0.673-1.121 1.467-2.023 2.298-2.609 0.443-0.313 0.895-0.535 1.351-0.668v5.854h-4.852c0.336-0.94 0.738-1.803 1.203-2.578zM14 12v4h-5.979c0.059-1.38 0.24-2.72 0.54-4h5.439zM2.997 22c-0.533-1.278-0.854-2.619-0.959-4h3.983c0.055 1.394 0.224 2.736 0.492 4h-3.516zM8.021 18h5.979v4h-5.439c-0.3-1.28-0.481-2.62-0.54-4zM14 24v5.854c-0.456-0.133-0.908-0.355-1.351-0.668-0.831-0.586-1.625-1.488-2.298-2.609-0.465-0.775-0.867-1.638-1.203-2.578h4.852zM19.649 26.578c-0.673 1.121-1.467 2.023-2.298 2.609-0.443 0.312-0.895 0.535-1.351 0.668v-5.854h4.852c-0.336 0.94-0.738 1.802-1.203 2.578zM16 22v-4h5.979c-0.059 1.38-0.24 2.72-0.54 4h-5.439zM23.98 16c-0.055-1.394-0.224-2.736-0.492-4h3.516c0.533 1.278 0.855 2.619 0.959 4h-3.983zM25.958 10h-2.997c-0.582-1.836-1.387-3.447-2.354-4.732 1.329 0.636 2.533 1.488 3.585 2.54 0.671 0.671 1.261 1.404 1.766 2.192zM5.808 7.808c1.052-1.052 2.256-1.904 3.585-2.54-0.967 1.285-1.771 2.896-2.354 4.732h-2.997c0.504-0.788 1.094-1.521 1.766-2.192zM4.042 24h2.997c0.583 1.836 1.387 3.447 2.354 4.732-1.329-0.636-2.533-1.488-3.585-2.54-0.671-0.671-1.261-1.404-1.766-2.192zM24.192 26.192c-1.052 1.052-2.256 1.904-3.585 2.54 0.967-1.285 1.771-2.896 2.354-4.732h2.997c-0.504 0.788-1.094 1.521-1.766 2.192z"></path></g></svg></div></div>
<div class="sl-block" data-block-type="shape" style="min-width: 4px; min-height: 4px; width: 44.33333333333333px; height: 28px; left: 226px; top: 308px;" data-block-id="8a620c1ddadee682bf0c2453ce61628d"><div class="sl-block-content fragment" data-shape-type="symbol-globe" data-shape-fill-color="rgb(109, 158, 235)" data-shape-stretch="false" style="z-index: 17;" data-fragment-index="0"><svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="100%" height="100%" preserveaspectratio="xMidYMid" viewbox="0 2 30 30"><g class="shape-element" fill="rgb(109, 158, 235)"><path d="M15 2c-8.284 0-15 6.716-15 15s6.716 15 15 15c8.284 0 15-6.716 15-15s-6.716-15-15-15zM23.487 22c0.268-1.264 0.437-2.606 0.492-4h3.983c-0.104 1.381-0.426 2.722-0.959 4h-3.516zM6.513 12c-0.268 1.264-0.437 2.606-0.492 4h-3.983c0.104-1.381 0.426-2.722 0.959-4h3.516zM21.439 12c0.3 1.28 0.481 2.62 0.54 4h-5.979v-4h5.439zM16 10v-5.854c0.456 0.133 0.908 0.355 1.351 0.668 0.831 0.586 1.625 1.488 2.298 2.609 0.465 0.775 0.867 1.638 1.203 2.578h-4.852zM10.351 7.422c0.673-1.121 1.467-2.023 2.298-2.609 0.443-0.313 0.895-0.535 1.351-0.668v5.854h-4.852c0.336-0.94 0.738-1.803 1.203-2.578zM14 12v4h-5.979c0.059-1.38 0.24-2.72 0.54-4h5.439zM2.997 22c-0.533-1.278-0.854-2.619-0.959-4h3.983c0.055 1.394 0.224 2.736 0.492 4h-3.516zM8.021 18h5.979v4h-5.439c-0.3-1.28-0.481-2.62-0.54-4zM14 24v5.854c-0.456-0.133-0.908-0.355-1.351-0.668-0.831-0.586-1.625-1.488-2.298-2.609-0.465-0.775-0.867-1.638-1.203-2.578h4.852zM19.649 26.578c-0.673 1.121-1.467 2.023-2.298 2.609-0.443 0.312-0.895 0.535-1.351 0.668v-5.854h4.852c-0.336 0.94-0.738 1.802-1.203 2.578zM16 22v-4h5.979c-0.059 1.38-0.24 2.72-0.54 4h-5.439zM23.98 16c-0.055-1.394-0.224-2.736-0.492-4h3.516c0.533 1.278 0.855 2.619 0.959 4h-3.983zM25.958 10h-2.997c-0.582-1.836-1.387-3.447-2.354-4.732 1.329 0.636 2.533 1.488 3.585 2.54 0.671 0.671 1.261 1.404 1.766 2.192zM5.808 7.808c1.052-1.052 2.256-1.904 3.585-2.54-0.967 1.285-1.771 2.896-2.354 4.732h-2.997c0.504-0.788 1.094-1.521 1.766-2.192zM4.042 24h2.997c0.583 1.836 1.387 3.447 2.354 4.732-1.329-0.636-2.533-1.488-3.585-2.54-0.671-0.671-1.261-1.404-1.766-2.192zM24.192 26.192c-1.052 1.052-2.256 1.904-3.585 2.54 0.967-1.285 1.771-2.896 2.354-4.732h2.997c-0.504 0.788-1.094 1.521-1.766 2.192z"></path></g></svg></div></div>
<div class="sl-block" data-block-type="shape" data-block-id="8fc670939e736ae050a9167b25a99250" style="min-width: 4px; min-height: 4px; width: 33px; height: 33px; left: 144px; top: 473px;"><div class="sl-block-content fragment" data-shape-type="symbol-denied" data-shape-fill-color="rgb(255, 0, 0)" data-shape-stretch="false" style="z-index: 18;" data-fragment-index="2"><svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="100%" height="100%" preserveaspectratio="xMidYMid" viewbox="0 0 32 32"><g class="shape-element" fill="rgb(255, 0, 0)"><path d="M16 0c-8.836 0-16 7.164-16 16s7.164 16 16 16 16-7.164 16-16-7.164-16-16-16zM16 4c2.59 0 4.973 0.844 6.934 2.242l-16.696 16.688c-1.398-1.961-2.238-4.344-2.238-6.93 0-6.617 5.383-12 12-12zM16 28c-2.59 0-4.973-0.844-6.934-2.242l16.696-16.688c1.398 1.961 2.238 4.344 2.238 6.93 0 6.617-5.383 12-12 12z"></path></g></svg></div></div></section><section data-id="3a6b1f43aa87872cd995ebce66ab2b29"><div class="sl-block" data-block-type="text" style="width: 664px; left: 154px; top: 578px; height: auto;" data-block-id="453c2fed6b791797d10baee9b07b8a97"><div class="sl-block-content" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 11;">
<ul>
	<li>petercollingridge.appspot.com/svg-editor</li>
</ul>
</div></div>
<div class="sl-block" data-block-type="text" style="width: 800px; left: 80px; top: 70px; height: auto;" data-block-id="b82dd5e826a7aa73a90036f27da39887"><div class="sl-block-content" data-placeholder-tag="h2" data-placeholder-text="Title Text" style="color: rgb(241, 194, 50); font-size: 125%; z-index: 12;">
<h2>SVG Optimizers</h2>
</div></div>
<div class="sl-block" data-block-type="image" data-block-id="0a1f51c4f2a9644fd123b6c40910c29b" style="min-width: 30px; min-height: 30px; width: 488.624584717608px; height: 332px; left: 242px; top: 193px;"><div class="sl-block-content" style="z-index: 13;"><img src="https://s3.amazonaws.com/media-p.slid.es/uploads/alexwalker/images/607488/j5BO6nM_-_Imgur.png" style="visibility: visible;" data-natural-width="886" data-natural-height="602"></div></div></section><section><div class="sl-block" data-block-type="text" style="width: 800px; left: 80px; top: 210px; height: auto;" data-block-id="cf9acaa01f656bb43ac9c31c697ead4f"><div class="sl-block-content" data-placeholder-tag="h1" data-placeholder-text="Title Text" style="z-index: 10; color: rgb(253, 189, 4);">
<h1>Useful SVG</h1>

<h1>Resources</h1>
</div></div></section><section><div class="sl-block" data-block-type="text" style="width: 800px; left: 80px; top: 51px; height: auto;" data-block-id="710c80f36dfaa92394e55431766ca369"><div class="sl-block-content" data-placeholder-tag="h1" data-placeholder-text="Title Text" style="color: rgb(253, 189, 4); z-index: 10;">
<h1>WikiMedia Commons</h1>
</div></div>
<div class="sl-block" data-block-type="text" style="width: 800px; left: 80px; top: 530px; height: auto;" data-block-id="327441ab273f74751bbb87e3631d6f4e"><div class="sl-block-content" data-placeholder-tag="h2" data-placeholder-text="Subtitle" style="z-index: 11;">
<h3>World/country maps:     http://commons.wikimedia.org/</h3>
</div></div>
<div class="sl-block" data-block-type="image" style="min-width: 30px; min-height: 30px; width: 455.513921113689px; height: 307px; left: 240px; top: 177px;" data-block-id="1afccb9e663c3f9d48b01b60ab04d9ad"><div class="sl-block-content" style="z-index: 13;"><img src="https://s3.amazonaws.com/media-p.slid.es/uploads/alexwalker/images/612695/svg-maps.png" style="visibility: visible;" data-natural-width="1279" data-natural-height="862"></div></div></section><section><div class="sl-block" data-block-type="text" style="width: 800px; left: 52px; top: 70px; height: auto;" data-block-id="a1352a84126bc9ef127009fed2c18100"><div class="sl-block-content" data-placeholder-tag="h1" data-placeholder-text="Title Text" style="color: rgb(253, 189, 4); z-index: 10;">
<h1>Open Street Maps</h1>
</div></div>
<div class="sl-block" data-block-type="text" style="width: 800px; left: 80px; top: 568px; height: auto;" data-block-id="ce507627013dbeea82bdb2884e03ad21"><div class="sl-block-content" data-placeholder-tag="h2" data-placeholder-text="Subtitle" style="z-index: 11;">
<h3>http://www.openstreetmap.org/</h3>
</div></div>
<div class="sl-block" data-block-type="image" data-block-id="b4c5931c1496018c6c851106db229314" style="min-width: 30px; min-height: 30px; width: 465.744939271255px; height: 303px; left: 231px; top: 199px;"><div class="sl-block-content" style="z-index: 13;"><img src="https://s3.amazonaws.com/media-p.slid.es/uploads/alexwalker/images/612706/90EzOVy_-_Imgur.png" style="visibility: visible;" data-natural-width="1139" data-natural-height="741"></div></div></section><section><div class="sl-block" data-block-type="text" style="width: 800px; left: 52px; top: 43px; height: auto;" data-block-id="e31a30adac72a75ccb2f0ad762de6d2a"><div class="sl-block-content" data-placeholder-tag="h1" data-placeholder-text="Title Text" style="color: rgb(253, 189, 4); z-index: 10;">
<h1>Plot.ly</h1>
</div></div>
<div class="sl-block" data-block-type="text" style="width: 668px; left: 139px; top: 503px; height: auto;" data-block-id="b8a44cf58164554bd30dc72ec420faf6"><div class="sl-block-content" data-placeholder-tag="h2" data-placeholder-text="Subtitle" style="z-index: 11;">
<h3>SVG graphs    https://plot.ly/</h3>
</div></div>
<div class="sl-block" data-block-type="image" data-block-id="538eef714b6ed1ac8e98f8e53ad57cbe" style="min-width: 30px; min-height: 30px; width: 486.353711790393px; height: 297px; left: 220px; top: 163px;"><div class="sl-block-content" style="z-index: 13;"><img src="https://s3.amazonaws.com/media-p.slid.es/uploads/alexwalker/images/612701/BXp2qYY_-_Imgur.png" style="visibility: visible;" data-natural-width="1125" data-natural-height="687"></div></div></section><section data-id="aa843f38f85bb08fc6b59853eb0fe108"><div class="sl-block" data-block-type="text" style="width: 800px; left: 143px; top: 136px; height: auto;" data-block-id="e0b5a44c797c945c6039ab9300d10497"><div class="sl-block-content" data-placeholder-tag="h2" data-placeholder-text="Title Text" style="color: rgb(255, 199, 36); z-index: 12; text-align: left;">
<h2>Thanks for listening!</h2>
</div></div>
<div class="sl-block" data-block-type="text" style="width: 369px; left: 240px; top: 502px; height: auto;" data-block-id="91b08e2efed46ae56a771987e71d58f9"><div class="sl-block-content" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 13; font-size: 80%;">
<ul>
	<li><a href="https://www.flickr.com/photos/accardi1/3330674993/" target="_blank">frenzy_rumble </a></li>
	<li><a href="https://www.flickr.com/photos/jakebouma/1469329445/" target="_blank">jakebouma</a></li>
</ul>
</div></div>
<div class="sl-block" data-block-type="text" data-block-id="ee4126f080b662d8d640211ac1f2040f" style="height: auto; min-width: 30px; min-height: 30px; width: 168px; left: 152px; top: 500px;"><div class="sl-block-content" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 14; text-align: left; font-size: 87%; color: rgb(255, 199, 36);">
<p>Photo credits</p>
</div></div>
<div class="sl-block" data-block-type="text" style="height: auto; min-width: 30px; min-height: 30px; width: 283px; left: 311px; top: 244px;" data-block-id="5f30d86d818a0cdec42089a50076da7f"><div class="sl-block-content fragment current-fragment" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 15; font-size: 87%;" data-fragment-index="0">
<p style="text-align:left">Alex Walker</p>

<p style="text-align:left">@alexmwalker</p>
</div></div>
<div class="sl-block" data-block-type="text" style="height: auto; min-width: 30px; min-height: 30px; width: 686px; left: 152px; top: 381px;" data-block-id="397a35f230f9dadf24c6018156d628f1"><div class="sl-block-content" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 16; text-align: left; font-size: 87%; color: rgb(255, 255, 255);">
<p><span style="color:#FFD700">Slides:</span> https://slides.com/alexwalker/responsive-svg/ </p>
</div></div>
<div class="sl-block" data-block-type="text" style="height: auto; min-width: 30px; min-height: 30px; width: 686px; left: 152px; top: 441px;" data-block-id="9d63eafb9f0ef6788d5f91ee039ebd40"><div class="sl-block-content" data-placeholder-tag="p" data-placeholder-text="Text" style="z-index: 17; text-align: left; font-size: 87%; color: rgb(255, 255, 255);">
<p><span style="color:#FFD700">Demos:</span> http://codepen.io/alexmwalker/public/</p>
</div></div>
<div class="sl-block" data-block-type="image" style="min-width: 30px; min-height: 30px; width: 168px; height: 224px; left: 123px; top: 181px;" data-block-id="0ee83a4f5496306ffbe1e33b0c1515f2"><div class="sl-block-content" style="z-index: 11;"><img src="https://s3.amazonaws.com/media-p.slid.es/uploads/alexwalker/images/590183/medium_3330674993.jpg" style="visibility: visible;" data-natural-width="375" data-natural-height="500"></div></div></section>
				</div>
				<div class="deck-kudos">
					<button class="kudos-button kudos-trigger" data-kudos-id="216172" data-kudoed-by-user="false">
						<div class="kudos-heart">
							<span class="kudos-icon icon i-heart-fill"></span>
						</div>
						<div class="kudos-count" data-kudos-value="1" data-kudos-id="216172"></div>
					</button>
				</div>
			</div>
		</div>
	</div>

	<div class="pill summary-pill">
		<div class="pill-picture" style="background-image: url(https://media.slid.es/avatars/180017/aw-508.jpg)"></div>
		<div class="pill-content">
			<h4 class="pill-title">responsive-svg</h4>
			<p class="pill-description">By Alex Walker</p>
		</div>
	</div>

	<div class="pill instructions-pill">
		<div class="pill-picture"></div>
		<div class="pill-content">
			<h4 class="pill-title"></h4>
			<p class="pill-description"></p>
		</div>
	</div>

</div>


<div class="column">
	<header class="deck-card showing-ad">
		<div class="deck-card-header">
			<div class="deck-sharing">
					<div class="deck-promotion">
						<a class="button cta made-with-slides" href="/?ref=capltfs">Made with Slides.com</a>
					</div>
				<div class="deck-social">
					<a href="#" class="deck-social-button facebook-share-button" data-tooltip="Share on Facebook">
					</a>
					<a href="#" class="deck-social-button twitter-share-button" data-tooltip="Share on Twitter">
						<span class="icon i-twitter"></span>
					</a>
				</div>
			</div>

			<div class="deck-options">
				<a class="button white fullscreen-button" data-tooltip="Fullscreen" href="/alexwalker/responsive-svg/fullscreen"><span class="icon i-fullscreen"></span></a>
				<button class="button white share-button" data-tooltip="Share"><span class="icon i-share"></span></button>
			</div>
		</div>

		<div class="deck-card-ad">
			<script async type="text/javascript" src="//cdn.carbonads.com/carbon.js?serve=CK7DEKJ7&placement=slidescom" id="_carbonads_js"></script>
		</div>

		<div class="clear"></div>

		<div class="deck-card-body">
			<div class="deck-info">
				<h1 class="title">responsive-svg</h1>
				<ul class="deck-meta">
					<li data-tooltip="Published date" data-tooltip-delay="500">
						<span class="icon i-clock"></span>
						<time class="value ago" datetime="2014-08-28 04:43:38 UTC"></time>
					</li>
					<li data-tooltip="Kudos" data-tooltip-delay="500">
						<span class="icon i-heart-fill"></span>
						<span class="value" data-kudos-value="1" data-kudos-id="216172"></span>
					</li>
					<li data-tooltip="Views" data-tooltip-delay="500">
						<span class="icon i-eye"></span>
						<span class="value">11,914</span>
					</li>
				</ul>
			</div>

			<div class="user-info">
	<div class="picture" style="background-image: url(https://media.slid.es/avatars/180017/aw-508.jpg)"></div>
	<div class="text">
		<h3 class="title">
			<a href="/alexwalker" class="username">Alex Walker</a>
		</h3>
		<p class="description">Doing cruel and strange things to CSS since 2001</p>
		<ul class="links">
			
			
		</ul>
	</div>
	<div class="clear"></div>
</div>

			<div class="clear"></div>
		</div>
	</header>

	<section class="deck-list related-decks">
		<h2>More from <a href="/alexwalker">Alex Walker</a></h2>
		<ul class="carousel">
			<li class="sl-deck-thumbnail" data-preview-url="/alexwalker/deck-5">
  <a class="deck-link" href="/alexwalker/deck-5"></a>
  <div class="deck-thumb">
      <img class="deck-thumb-image" data-src="https://media.slid.es/thumbnails/9d13ae1926a027a81751c390850944d4/thumb.jpg?1217098687" />
  </div>
  <footer class="deck-details">
    <div class="top">
      <div class="title">deck</div>
    </div>
    <div class="bottom">
      <a class="author" href="/alexwalker">
        <span class="picture" style="background-image: url(https://media.slid.es/avatars/180017/aw-508.jpg)"></span>
        <span class="name">Alex Walker</span>
      </a>
      <div class="stats">
        <div>0<span class="icon i-eye"></span></div>
      </div>
    </div>
  </footer>
</li>
<li class="sl-deck-thumbnail" data-preview-url="/alexwalker/deck-4">
  <a class="deck-link" href="/alexwalker/deck-4"></a>
  <div class="deck-thumb">
      <img class="deck-thumb-image" data-src="https://media.slid.es/thumbnails/0c1d240d1f3ddcd05d192c6a167d3a60/thumb.jpg" />
  </div>
  <footer class="deck-details">
    <div class="top">
      <div class="title">deck</div>
    </div>
    <div class="bottom">
      <a class="author" href="/alexwalker">
        <span class="picture" style="background-image: url(https://media.slid.es/avatars/180017/aw-508.jpg)"></span>
        <span class="name">Alex Walker</span>
      </a>
      <div class="stats">
        <div>1687<span class="icon i-eye"></span></div>
      </div>
    </div>
  </footer>
</li>
<li class="sl-deck-thumbnail" data-preview-url="/alexwalker/the-rules-for-stock-imagery">
  <a class="deck-link" href="/alexwalker/the-rules-for-stock-imagery"></a>
  <div class="deck-thumb">
      <img class="deck-thumb-image" data-src="https://media.slid.es/thumbnails/secure/b83c71/decks.jpg" />
  </div>
  <footer class="deck-details">
    <div class="top">
      <div class="title">The 15-minute Stock Imagery Survival Guide</div>
    </div>
    <div class="bottom">
      <a class="author" href="/alexwalker">
        <span class="picture" style="background-image: url(https://media.slid.es/avatars/180017/aw-508.jpg)"></span>
        <span class="name">Alex Walker</span>
      </a>
      <div class="stats">
        <div>1959<span class="icon i-eye"></span></div>
      </div>
    </div>
  </footer>
</li>
<li class="sl-deck-thumbnail" data-preview-url="/alexwalker/css-3d">
  <a class="deck-link" href="/alexwalker/css-3d"></a>
  <div class="deck-thumb">
      <img class="deck-thumb-image" data-src="https://media.slid.es/thumbnails/secure/3a407b/decks.jpg" />
  </div>
  <footer class="deck-details">
    <div class="top">
      <div class="title">CSS 3D</div>
    </div>
    <div class="bottom">
      <a class="author" href="/alexwalker">
        <span class="picture" style="background-image: url(https://media.slid.es/avatars/180017/aw-508.jpg)"></span>
        <span class="name">Alex Walker</span>
      </a>
      <div class="stats">
        <div>1887<span class="icon i-eye"></span></div>
      </div>
    </div>
  </footer>
</li>

		</ul>
	</section>

</div>
      </main>
      <footer class="global-footer ">
    <div class="global-footer-links">
      <div class="link-group">
        <h4>Tour</h4>
        <a href="https://slides.com/explore">Presentations</a>
        <a href="https://slides.com/recent">Trending decks</a>
        <a href="https://slides.com/templates">Templates</a>
        <a href="https://slides.com/features">Features</a>
        <a href="https://slides.com/pricing">Pricing</a>
        <a href="https://slides.com/for-teams">Slides for Teams</a>
        <a href="https://slides.com/for-developers">Slides for Developers</a>
      </div>

      <div class="link-group">
        <h4>Help</h4>
        <a href="https://help.slides.com" target="_blank" rel="noopener">Forum</a>
        <a href="https://help.slides.com/knowledgebase" target="_blank" rel="noopener">Knowledge Base</a>
        <a href="https://slides.com/developers">Developers Docs</a>
        <a href="https://help.slides.com" data-feedback-mode="smartvote">Leave Feedback</a>
        <a href="https://help.slides.com" data-feedback-mode="contact">Report an Issue</a>
      </div>

      <div class="link-group">
        <h4>Company</h4>
        <a href="https://slides.com/news">News</a>
        <a href="https://slides.com/changelog">Changelog</a>
        <a href="https://slides.com/about">About Slides</a>
        <a href="https://slides.com/security">Security</a>
        <a href="https://slides.com/partners">Partners</a>
      </div>

      <div class="link-group">
        <h4>Resources</h4>
        <a href="https://slides.com/slides-ai-gpt">Make slides with AI</a>
        <a href="https://slides.com/embed-google-maps">Embed Google Maps</a>
        <a href="https://slides.com/embed-google-forms">Embed Google Forms</a>
        <a href="https://slides.com/embed-youtube">Embed YouTube</a>
        <a href="https://slides.com/import-pdf">Convert PDF to Slides</a>
        <a href="https://slides.com/import-ppt">Convert PPT to Slides</a>
        <a href="https://slides.com/tools/markdown-to-presentation">Convert Markdown to Slides</a>
      </div>
    </div>

    <div class="global-footer-bottom">
      <div class="social">
        <a href="https://twitter.com/slides" target="_blank" rel="noopener" class="twitter-link" aria-label="Go to Slides\' Twitter profile">
          <svg xmlns="http://www.w3.org/2000/svg" width="34" height="32" viewBox="0 0 34 32"><path fill="currentColor" d="M33.482 5.964q0 .179-.089.321-1.143 1.857-3.196 3.393v.589q.071 4.054-1.786 8.161-2.393 5.304-7.098 8.295T10.75 29.714q-4.732 0-8.929-2.179-1.143-.589-1.554-.893-.268-.214-.268-.482 0-.232.17-.402t.402-.17q.25 0 .786.045t.804.045q3.643 0 6.696-1.893-1.839-.429-3.232-1.714t-1.982-3.089q-.036-.143-.036-.196 0-.214.161-.384t.393-.17q.089 0 .25.036t.214.036q-1.589-.982-2.536-2.625t-.946-3.5q0-.268.205-.455t.491-.188q.179 0 .625.205t.536.241q-1.643-1.964-1.643-4.571 0-.911.259-1.929t.723-1.696q.179-.286.446-.286.286 0 .482.214 1.357 1.5 1.964 2.054 2.196 1.982 4.929 3.17t5.661 1.438q-.071-.375-.071-.875 0-2.982 2.116-5.098t5.098-2.116q2.911 0 5.036 2.036 1.696-.357 3.732-1.464.143-.089.286-.089.232 0 .402.17t.17.402q0 .429-.5 1.304t-.911 1.357q.125-.036.536-.188t.768-.286.429-.134q.232 0 .402.17t.17.402z"/></svg>
        </a>
        <a href="https://facebook.com/slidesapp" target="_blank" rel="noopener" class="facebook-link" aria-label="Go to Slides\' Facebook profile">
          <svg xmlns="http://www.w3.org/2000/svg" width="14" height="32" viewBox="0 0 14 32"><path fill="currentColor" d="M10 7.339q-.875 0-1.107.277t-.232 1.188v1.571h3.875q.286 0 .482.214.196.232.179.518l-.25 3.571q-.036.268-.223.455t-.455.188H8.662v13.714q0 .286-.196.482t-.464.196H3.538q-.286 0-.482-.196t-.196-.482V15.321H.681q-.286 0-.482-.205t-.196-.491v-3.571q0-.286.196-.482t.482-.196H2.86V8.537q0-3.161 1.571-4.705t4.768-1.545q2.143 0 4.018.536.25.071.393.286t.107.464l-.482 3.482q-.036.286-.286.464-.25.161-.536.107-1.357-.286-2.411-.286z"/></svg>
        </a>
      </div>
      <div class="legal">
        <a href="https://slides.com/terms">Terms</a>
        &bull; <a href="https://slides.com/privacy?root=true">Privacy</a>
        &bull; <span class="copyright">&copy;&nbsp;2024&nbsp;Slides,&nbsp;Inc.</span>
      </div>
    </div>
</footer>

    </div> <!--! end of #container -->
    
<script>
	var SLConfig = {"deck":{"id":216172,"slug":"responsive-svg","title":"responsive-svg","description":"","width":960,"height":700,"margin":0.05,"visibility":"all","published_at":"2014-08-28T04:43:38.820Z","sanitize_messages":null,"thumbnail_url":"https://s3.amazonaws.com/media-p.slid.es/thumbnails/alexwalker/0b188c/responsive-svg.jpg","view_count":11914,"user":{"id":180017,"username":"alexwalker","name":"Alex Walker","description":"Doing cruel and strange things to CSS since 2001","thumbnail_url":"https://media.slid.es/avatars/180017/aw-508.jpg","account_type":"default","team_id":null,"settings":{"id":5309,"present_controls":true,"present_upsizing":true,"present_pointer":false,"present_notes":true,"default_deck_tag_id":null}},"background_transition":"fade","transition":"default","theme_id":null,"theme_font":"josefine","theme_color":"black-blue","auto_slide_interval":0,"comments_enabled":true,"forking_enabled":true,"rolling_links":false,"center":false,"shuffle":null,"should_loop":false,"share_notes":null,"slide_number":null,"slide_count":35,"rtl":false,"version":2,"collaborative":null,"deck_user_editor_limit":null,"data_updated_at":null,"font_typekit":null,"font_google":null,"time_limit":null,"navigation_mode":"default","upsizing_enabled":null,"language":"en"},"user":{"id":180017,"username":"alexwalker","name":"Alex Walker","description":"Doing cruel and strange things to CSS since 2001","thumbnail_url":"https://media.slid.es/avatars/180017/aw-508.jpg","account_type":"default","team_id":null,"settings":{"id":5309,"present_controls":true,"present_upsizing":true,"present_pointer":false,"present_notes":true,"default_deck_tag_id":null}}};
</script>
    <script src="//assets-v2.slid.es/assets/deck-consumption-e779c14067f21456895856ac12567a2a30e6e5bd84d7ffe41f0e5873ad43bdad.js" defer="defer"></script>
    	<script src="//assets-v2.slid.es/assets/deck-ac846159306d45d19d0fb7c181bdaff4ebea39a7a91f14c5c682c3005019ab6d.js" defer="defer"></script>
	



    <script>
UserVoice=window.UserVoice||[];(function(){var uv=document.createElement(\'script\');uv.type=\'text/javascript\';uv.async=true;uv.src=\'//widget.uservoice.com/f7sH7NavrjjvuGxByaw.js\';var s=document.getElementsByTagName(\'script\')[0];s.parentNode.insertBefore(uv,s)})();

UserVoice.push([\'set\', {
  accent_color: \'#448dd6\',
  trigger_color: \'white\',
  trigger_background_color: \'rgba(46, 49, 51, 0.6)\',
  position: \'automatic\'
}]);

</script>

  </body>
</html>
'
];
