<?php
declare(strict_types = 1);

return [
    'headers' => [
        'content-type' => [
            'text/html'
        ],
        'transfer-encoding' => [
            'chunked'
        ],
        'connection' => [
            'keep-alive'
        ],
        'x-pants' => [
            'distant-towel'
        ],
        'x-xss-protection' => [
            '1; mode=block'
        ],
        'cache-control' => [
            'private, max-age=0, no-cache, no-store'
        ],
        'x-frame-options' => [
            'SAMEORIGIN'
        ],
        'server-timing' => [
            'experiments; dur=4.820942; desc="api-v2/experiments", enabledFeatures; dur=4.193446; desc="api-v2/enabledFeatures", geoip; dur=1.170337; desc="geoip/geoip", resolve; dur=51.845848; desc="api-v2/resolve", privacySettings; dur=4.956816; desc="api-v2/privacySettings", geoip; dur=1.370773; desc="geoip/geoip", userTracks; dur=91.694115; desc="api-v2/userTracks"'
        ],
        'date' => [
            'Sun, 04 Apr 2021 15:21:58 GMT'
        ],
        'strict-transport-security' => [
            'max-age=63072000; includeSubdomains; preload'
        ],
        'server' => [
            'am/2'
        ],
        'content-encoding' => [
            'gzip'
        ],
        'vary' => [
            'Accept-Encoding'
        ],
        'x-cache' => [
            'Miss from cloudfront'
        ],
        'via' => [
            '1.1 4ebc80fbe8c95fbda707a7dd4b84a6b9.cloudfront.net (CloudFront)'
        ],
        'x-amz-cf-pop' => [
            'MAD51-C1'
        ],
        'x-amz-cf-id' => [
            'wkPM1HgacXLYbEdP03-tmUcBeK5pxtROOn59XVoH2ond0NMWtluGeQ=='
        ],
        'Content-Location' => [
            'https://soundcloud.com/bruceneilmusic'
        ],
        'X-Request-Time' => [
            '0.261 ms'
        ]
    ],
    'statusCode' => 200,
    'reasonPhrase' => 'OK',
    'body' => '<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="theme-color" content="#333">
<link rel="dns-prefetch" href="//style.sndcdn.com">
<link rel="dns-prefetch" href="//a-v2.sndcdn.com">
<link rel="dns-prefetch" href="//api-v2.soundcloud.com">
<link rel="dns-prefetch" href="//sb.scorecardresearch.com">
<link rel="dns-prefetch" href="//secure.quantserve.com">
<link rel="dns-prefetch" href="//eventlogger.soundcloud.com">
<link rel="dns-prefetch" href="//api.soundcloud.com">
<link rel="dns-prefetch" href="//ssl.google-analytics.com">
<link rel="dns-prefetch" href="//i1.sndcdn.com">
<link rel="dns-prefetch" href="//i2.sndcdn.com">
<link rel="dns-prefetch" href="//i3.sndcdn.com">
<link rel="dns-prefetch" href="//i4.sndcdn.com">
<link rel="dns-prefetch" href="//wis.sndcdn.com">
<link rel="dns-prefetch" href="//va.sndcdn.com">
<link rel="dns-prefetch" href="//pixel.quantserve.com">
<title>Bruce Neil | Free Listening on SoundCloud</title>
<meta content="record, sounds, share, sound, audio, tracks, music, soundcloud" name="keywords">
<meta name="referrer" content="origin">
<meta name="google-site-verification" content="dY0CigqM8Inubs_hgrYMwk-zGchKwrvJLcvI_G8631Q">
<link crossorigin="use-credentials" rel="manifest" href="/webmanifest.json">
<meta name="viewport" content="width=device-width,minimum-scale=1,maximum-scale=1,user-scalable=no">
<meta content="19507961798" property="fb:app_id">
<meta content="SoundCloud" property="og:site_name">
<meta content="SoundCloud" property="twitter:site">
<meta content="SoundCloud" property="twitter:app:name:iphone">
<meta content="336353151" property="twitter:app:id:iphone">
<meta content="SoundCloud" property="twitter:app:name:ipad">
<meta content="336353151" property="twitter:app:id:ipad">
<meta content="SoundCloud" property="twitter:app:name:googleplay">
<meta content="com.soundcloud.android" property="twitter:app:id:googleplay">
<link href="/sc-opensearch.xml" rel="search" title="SoundCloud search" type="application/opensearchdescription+xml">
<meta name="description" content="Bruce Neil from Wokingham is a singer/songwriter with a folk inspired sound, producing songs with heartfelt depth and lyrics that captivate the listener, taking them on an insightful and thought-provo. Reading. 23 Tracks. 757 Followers. Stream Tracks and Playlists from Bruce Neil on your desktop or mobile device."><meta property="twitter:app:name:iphone" content="SoundCloud"><meta property="twitter:app:id:iphone" content="336353151"><meta property="twitter:app:name:ipad" content="SoundCloud"><meta property="twitter:app:id:ipad" content="336353151"><meta property="twitter:app:name:googleplay" content="SoundCloud"><meta property="twitter:app:id:googleplay" content="com.soundcloud.android"><meta property="twitter:app:url:googleplay" content="soundcloud://users:6538603"><meta property="twitter:app:url:iphone" content="soundcloud://users:6538603"><meta property="twitter:app:url:ipad" content="soundcloud://users:6538603"><meta property="twitter:title" content="Bruce Neil"><meta property="twitter:image" content="https://i1.sndcdn.com/avatars-000137863509-h9h7dr-t500x500.jpg"><meta property="twitter:description" content="Bruce Neil from Wokingham is a singer/songwriter with a folk inspired sound, producing songs with heartfelt depth and lyrics that captivate the listener, taking them on an insightful and thought-provo"><meta property="twitter:card" content="player"><meta property="twitter:player:height" content="450"><meta property="twitter:player:width" content="435"><meta property="twitter:player" content="https://w.soundcloud.com/player/?url=https%3A%2F%2Fapi.soundcloud.com%2Fusers%2F6538603&amp;auto_play=false&amp;show_artwork=true&amp;visual=true&amp;origin=twitter"><meta property="twitter:url" content="https://soundcloud.com/bruceneilmusic"><meta property="al:ios:app_name" content="SoundCloud"><meta property="al:ios:app_store_id" content="336353151"><meta property="al:android:app_name" content="SoundCloud"><meta property="al:android:package" content="com.soundcloud.android"><meta property="og:type" content="music.musician"><meta property="og:url" content="https://soundcloud.com/bruceneilmusic"><meta property="og:title" content="Bruce Neil"><meta property="og:image" content="https://i1.sndcdn.com/avatars-000137863509-h9h7dr-t500x500.jpg"><meta property="og:image:width" content="500"><meta property="og:image:height" content="500"><meta property="og:description" content="Bruce Neil from Wokingham is a singer/songwriter with a folk inspired sound, producing songs with heartfelt depth and lyrics that captivate the listener, taking them on an insightful and thought-provo"><meta property="og:locality" content="Reading"><meta property="og:country-name"><meta property="al:ios:url" content="soundcloud://users:6538603"><meta property="al:android:url" content="soundcloud://users:6538603"><meta property="al:web:should_fallback" content="false"><meta property="soundcloud:sound_count" content="23"><meta property="soundcloud:follower_count" content="757">
<link rel="canonical" href="https://soundcloud.com/bruceneilmusic"><link rel="alternate" media="only screen and (max-width: 640px)" href="https://m.soundcloud.com/bruceneilmusic"><link rel="alternate" type="text/xml+oembed" href="https://soundcloud.com/oembed?url=https%3A%2F%2Fsoundcloud.com%2Fbruceneilmusic&amp;format=xml"><link rel="alternate" type="text/json+oembed" href="https://soundcloud.com/oembed?url=https%3A%2F%2Fsoundcloud.com%2Fbruceneilmusic&amp;format=json"><link rel="alternate" href="android-app://com.soundcloud.android/soundcloud/users:6538603"><link rel="alternate" href="ios-app://336353151/soundcloud/users:6538603">
<meta name="application-name" content="SoundCloud">
<meta name="msapplication-tooltip" content="Launch SoundCloud">
<meta name="msapplication-TileImage" content="https://a-v2.sndcdn.com/assets/images/sc-icons/win8-2dc974a18a.png">
<meta name="msapplication-TileColor" content="#ff5500">
<meta name="msapplication-starturl" content="https://soundcloud.com">
<link href="https://a-v2.sndcdn.com/assets/images/sc-icons/favicon-2cadd14bdb.ico" rel="icon">
<link href="https://a-v2.sndcdn.com/assets/images/sc-icons/ios-a62dfc8fe7.png" rel="apple-touch-icon">
<link href="https://a-v2.sndcdn.com/assets/images/sc-icons/fluid-b4e7a64b8b.png" rel="fluid-icon">
<script>!function(){var o,a,e;function i(a){return a.test(o)}o=window.navigator.userAgent.toLowerCase();var r,n,t,s=void 0!==window.opera&&"[object Opera]"===window.opera.toString(),p=o.match(/\\sopr\\/([0-9]+)\\./),d=i(/chrome/),c=i(/webkit/),m=!d&&i(/safari/),w=!s&&i(/msie/),f=!c&&i(/gecko/);r=p?parseInt(p[1],10):(t=o.match(/(opera|chrome|safari|firefox|msie)\\/?\\s*(\\.?\\d+(\\.\\d+)*)/i))&&(n=o.match(/version\\/([.\\d]+)/i))?parseInt(n[1],10):t?parseInt(t[2],10):null;var h=i(/mobile|android|iphone|ipod|symbianos|nokia|s60|playbook|playstation/);f&&(e=(a=o.match(/(firefox)\\/?\\s*(\\.?\\d+(\\.\\d+)*)/i))&&a.length>1&&parseInt(a[2],10)>=41),r&&!h&&(d&&!p&&r<40||f&&!p&&!1===e||m&&r<8||w&&r<11||s&&r<13||p&&r<27)&&(window.__sc_abortApp=!0)}()</script>
<link rel="stylesheet" href="https://style.sndcdn.com/css/interstate-a86f07cf94ae5a496b24.css">
<link rel="stylesheet" href="https://a-v2.sndcdn.com/assets/css/app-aec060e1e008942e5a31.css">

</head>
<body class="sc-classic ot-hide-banner">

<div id="app">
<style>.header{width:100%;background:var(--background-dark-color);height:46px}.sc-classic .header{background:#333}.header__logo{background:var(--background-dark-color)}.sc-classic .header__logo{background:#333}.header__logoLink{background:transparent url(https://a-v2.sndcdn.com/assets/images/header/cloud-e365a472bf.png) no-repeat 12px 11px;background-size:48px 22px;display:block;height:46px;width:69px}.header__logoLink:focus{background-color:rgba(255,72,0,.8);outline:0}#header__loading{margin:13px auto 0;width:16px;background:url(https://a-v2.sndcdn.com/assets/images/loader-dark-45940ae3d4.gif) center no-repeat;background-size:16px 16px}@media (-webkit-min-device-pixel-ratio:2),(min-resolution:192dpi),(min-resolution:2dppx){.header__logoLink{background-image:url(https://a-v2.sndcdn.com/assets/images/header/cloud@2x-e5fba4606d.png)}}</style>
<div role="banner" class="header sc-selection-disabled show fixed g-dark g-z-index-header">
<div class="header__inner l-container l-fullwidth">
<div class="header__left left">
<div class="header__logo left">
<a href="/" title="Home" class="header__logoLink sc-border-box sc-ir">SoundCloud</a>
</div>
</div>
<div id="header__loading" class="sc-hidden"></div>
</div>
</div>
<script>window.setTimeout((function(){if(!window.__sc_abortApp){var e=window.document.getElementById("header__loading");e&&(e.className="")}}),6e3)</script>
<style>.errorPage__inner{width:580px;margin:0 auto;position:relative;padding-top:460px;background:url(https://a-v2.sndcdn.com/assets/images/errors/500-e5a180b7a8.png) no-repeat 50% 80px;text-align:center;transition:all 1s linear}.errorTitle{margin-bottom:10px;font-size:30px}.errorText{line-height:28px;color:#666;font-size:20px}.errorButtons{margin-top:30px}@media (max-width:1280px){.errorPage__inner{background-size:80%}}</style>
<noscript class="errorPage__inner">
<div class="errorPage__inner">
<p class="errorTitle">JavaScript is disabled</p>
<p class="errorText sc-font-light">You need to enable JavaScript to use SoundCloud</p>
<div class="errorButtons">
<a href="http://www.enable-javascript.com/" target="_blank" class="sc-button sc-button-medium">Show me how to enable it</a>
</div>
</div>
</noscript>
<noscript><article itemscope itemtype="http://schema.org/MusicGroup">
  <header>
    <h1 itemprop="name"><a itemprop="url" href="/bruceneilmusic">Bruce Neil</a></h1>
    <p>Bruce Neil</p>
    <p>Reading</p>
    <img src="https://i1.sndcdn.com/avatars-000137863509-h9h7dr-t500x500.jpg" width="500" height="500" alt="Bruce Neil’s avatar" itemprop="image">
    <div itemprop="potentialAction" itemscope itemtype="http://schema.org/ListenAction">
        <div itemprop="target" itemscope itemtype="http://schema.org/EntryPoint">
            <meta itemprop="urlTemplate" content="https://soundcloud.com/bruceneilmusic">
            <meta itemprop="actionPlatform" content="http://schema.org/DesktopWebPlatform">
            <meta itemprop="actionPlatform" content="http://schema.org/IOSPlatform">
            <meta itemprop="actionPlatform" content="http://schema.org/AndroidPlatform">
            <meta itemprop="actionPlatform" content="http://schema.googleapis.com/GoogleAudioCast">
            <meta itemprop="actionPlatform" content="http://schema.googleapis.com/GoogleVideoCast">
        </div>
        <div itemprop="expectsAcceptanceOf" itemscope itemtype="http://schema.org/Offer">
            <meta itemprop="category" content="free">
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="AD"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="AE"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="AF"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="AG"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="AI"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="AL"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="AM"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="AO"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="AQ"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="AR"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="AS"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="AT"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="AU"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="AW"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="AX"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="AZ"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="BA"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="BB"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="BD"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="BE"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="BF"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="BG"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="BH"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="BI"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="BJ"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="BL"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="BM"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="BN"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="BO"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="BQ"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="BR"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="BS"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="BT"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="BV"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="BW"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="BY"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="BZ"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="CA"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="CC"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="CD"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="CF"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="CG"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="CH"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="CI"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="CK"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="CL"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="CM"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="CN"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="CO"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="CR"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="CU"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="CV"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="CW"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="CX"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="CY"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="CZ"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="DE"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="DJ"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="DK"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="DM"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="DO"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="DZ"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="EC"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="EE"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="EG"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="EH"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="ER"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="ES"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="ET"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="FI"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="FJ"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="FK"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="FM"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="FO"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="FR"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="GA"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="GB"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="GD"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="GE"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="GF"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="GG"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="GH"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="GI"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="GL"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="GM"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="GN"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="GP"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="GQ"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="GR"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="GS"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="GT"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="GU"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="GW"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="GY"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="HK"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="HM"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="HN"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="HR"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="HT"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="HU"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="ID"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="IE"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="IL"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="IM"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="IN"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="IO"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="IQ"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="IR"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="IS"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="IT"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="JE"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="JM"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="JO"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="JP"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="KE"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="KG"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="KH"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="KI"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="KM"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="KN"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="KP"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="KR"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="KW"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="KY"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="KZ"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="LA"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="LB"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="LC"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="LI"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="LK"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="LR"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="LS"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="LT"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="LU"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="LV"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="LY"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="MA"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="MC"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="MD"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="ME"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="MF"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="MG"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="MH"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="MK"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="ML"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="MM"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="MN"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="MO"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="MP"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="MQ"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="MR"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="MS"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="MT"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="MU"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="MV"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="MW"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="MX"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="MY"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="MZ"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="NA"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="NC"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="NE"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="NF"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="NG"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="NI"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="NL"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="NO"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="NP"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="NR"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="NU"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="NZ"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="OM"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="PA"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="PE"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="PF"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="PG"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="PH"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="PK"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="PL"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="PM"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="PN"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="PR"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="PS"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="PT"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="PW"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="PY"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="QA"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="RE"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="RO"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="RS"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="RU"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="RW"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="SA"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="SB"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="SC"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="SD"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="SE"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="SG"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="SH"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="SI"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="SJ"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="SK"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="SL"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="SM"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="SN"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="SO"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="SR"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="SS"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="ST"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="SV"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="SX"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="SY"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="SZ"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="TC"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="TD"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="TF"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="TG"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="TH"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="TJ"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="TK"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="TL"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="TM"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="TN"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="TO"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="TR"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="TT"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="TV"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="TW"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="TZ"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="UA"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="UG"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="UM"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="US"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="UY"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="UZ"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="VA"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="VC"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="VE"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="VG"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="VI"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="VN"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="VU"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="WF"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="WS"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="YE"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="YT"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="ZA"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="ZM"/>
            </div>
            <div itemprop="eligibleRegion" itemscope itemtype="http://schema.org/Country">
                <meta itemprop="name" content="ZW"/>
            </div>
        </div>
    </div>

  </header>
  <p itemprop="description">Bruce Neil from Wokingham is a singer/songwriter with a folk inspired sound, producing songs with heartfelt depth and lyrics that captivate the listener, taking them on an insightful and thought-provoking journey. As a winner of BBC Introducing, resulting in air play nationally, he has recently achieved widespread public attention following the video release of his percussive folk rendition of Guns N’ Roses track Paradise City. Not only did this go viral on social media, it was endorsed by the band themselves and has achieved recognition and air play from several US radio stations. He takes his musical inspiration and guitar-playing style from the likes of Passenger and Mick Flannery.</p>
    <section>
      <h2>Bruce Neil’s tracks</h2>
        <article class="audible" itemprop="track" itemscope itemtype="http://schema.org/MusicRecording">
          <h2 itemprop="name"><a itemprop="url" href="/bruceneilmusic/here-we-are-sans-trumpet">Here We Are (sans Trumpet)</a>
          by <a href="/bruceneilmusic">Bruce Neil</a></h2>
          published on <time pubdate>2017-04-01T18:19:13Z</time>
            <meta itemprop="duration" content="PT00H03M40S" />
        </article>
        <article class="audible" itemprop="track" itemscope itemtype="http://schema.org/MusicRecording">
          <h2 itemprop="name"><a itemprop="url" href="/bruceneilmusic/paradise-city">Paradise City</a>
          by <a href="/bruceneilmusic">Bruce Neil</a></h2>
          published on <time pubdate>2017-04-01T18:20:14Z</time>
            <meta itemprop="duration" content="PT00H05M02S" />
        </article>
        <article class="audible" itemprop="track" itemscope itemtype="http://schema.org/MusicRecording">
          <h2 itemprop="name"><a itemprop="url" href="/bruceneilmusic/wood-for-the-trees">Wood for the Trees</a>
          by <a href="/bruceneilmusic">Bruce Neil</a></h2>
          published on <time pubdate>2017-05-18T20:22:35Z</time>
            <meta itemprop="duration" content="PT00H03M58S" />
        </article>
        <article class="audible" itemprop="track" itemscope itemtype="http://schema.org/MusicRecording">
          <h2 itemprop="name"><a itemprop="url" href="/bruceneilmusic/old-oak-tree">Old Oak Tree</a>
          by <a href="/bruceneilmusic">Bruce Neil</a></h2>
          published on <time pubdate>2017-05-18T20:22:42Z</time>
            <meta itemprop="duration" content="PT00H03M00S" />
        </article>
        <article class="audible" itemprop="track" itemscope itemtype="http://schema.org/MusicRecording">
          <h2 itemprop="name"><a itemprop="url" href="/bruceneilmusic/on-the-other-side">On the Other Side</a>
          by <a href="/bruceneilmusic">Bruce Neil</a></h2>
          published on <time pubdate>2017-05-18T20:23:32Z</time>
            <meta itemprop="duration" content="PT00H04M08S" />
        </article>
        <article class="audible" itemprop="track" itemscope itemtype="http://schema.org/MusicRecording">
          <h2 itemprop="name"><a itemprop="url" href="/bruceneilmusic/times-taken">Times Taken</a>
          by <a href="/bruceneilmusic">Bruce Neil</a></h2>
          published on <time pubdate>2017-05-18T20:24:11Z</time>
            <meta itemprop="duration" content="PT00H04M08S" />
        </article>
        <article class="audible" itemprop="track" itemscope itemtype="http://schema.org/MusicRecording">
          <h2 itemprop="name"><a itemprop="url" href="/bruceneilmusic/i-wanna-love-ya-mst">I Wanna Love Ya Mst</a>
          by <a href="/bruceneilmusic">Bruce Neil</a></h2>
          published on <time pubdate>2017-06-17T18:12:26Z</time>
            <meta itemprop="duration" content="PT00H04M46S" />
        </article>
        <article class="audible" itemprop="track" itemscope itemtype="http://schema.org/MusicRecording">
          <h2 itemprop="name"><a itemprop="url" href="/bruceneilmusic/letting-you-go">Letting You Go</a>
          by <a href="/bruceneilmusic">Bruce Neil</a></h2>
          published on <time pubdate>2015-03-26T10:04:35Z</time>
            <meta itemprop="duration" content="PT00H05M06S" />
            <meta itemprop="genre" content="bruce" />
        </article>
        <article class="audible" itemprop="track" itemscope itemtype="http://schema.org/MusicRecording">
          <h2 itemprop="name"><a itemprop="url" href="/bruceneilmusic/rocking-boat">Rocking Boat</a>
          by <a href="/bruceneilmusic">Bruce Neil</a></h2>
          published on <time pubdate>2015-03-26T10:01:34Z</time>
            <meta itemprop="duration" content="PT00H03M10S" />
            <meta itemprop="genre" content="bruce" />
        </article>
    </section>
  <footer>
     <ul>
       <li><a href="/bruceneilmusic/likes">Bruce Neil\'s likes</a></li>
       <li><a href="/bruceneilmusic/sets">Bruce Neil\'s playlists</a></li>
       <li><a href="/bruceneilmusic/tracks">Bruce Neil\'s tracks</a></li>
       <li><a rel="nofollow" href="/bruceneilmusic/comments">Bruce Neil\'s comments</a></li>
     </ul>
  </footer>
</article>
</noscript>
<style>#updateBrowserMessage{width:600px;margin:0 auto;position:relative;padding-top:410px;background:url(https://a-v2.sndcdn.com/assets/images/errors/browser-9cdd4e6df7.png) no-repeat 50% 130px;text-align:center;display:none}#updateBrowserMessage .messageText{line-height:26px;font-size:20px;margin-bottom:5px}#updateBrowserMessage .downloadLinks{margin-top:0}</style>
<div id="updateBrowserMessage">
<p class="messageText sc-text-light">
Your current browser isn\'t compatible with SoundCloud. <br>
Please download one of our supported browsers. <a href="https://help.soundcloud.com/hc/articles/115003564308-Technical-requirements">Need help?</a>
</p>
<div class="downloadLinks sc-type-h3 sc-text-light">
<a href="http://google.com/chrome" target="_blank" title="Chrome">Chrome</a> | <a href="http://firefox.com" target="_blank" title="Firefox">Firefox</a> | <a href="http://apple.com/safari" target="_blank" title="Safari">Safari</a> | <a href="http://windows.microsoft.com/ie" target="_blank" title="Internet Explorer">Internet Explorer</a>
</div>
</div>
<script>window.__sc_abortApp&&(window.document.getElementById("updateBrowserMessage").style.display="block")</script>
<div id="error__timeout" class="errorPage__inner sc-hidden">
<p class="errorTitle sc-type-h1">Sorry! Something went wrong</p>
<div class="errorText sc-font-light">
<p>Is your network connection unstable or browser outdated?</p>
</div>
<div class="errorButtons">
<a class="sc-button" href="https://help.soundcloud.com" target="_blank" id="try-again">I need help</a>
</div>
</div>
<script>function displayError(){if(!window.__sc_abortApp){var r=window.document,e=r.getElementById("error__timeout"),o=r.getElementById("header__loading");e&&o&&(e.className="errorPage__inner",o.className="sc-hidden")}}window.setTimeout(displayError,15e3),window.onerror=displayError</script>
<p>
<a href="/popular/searches" title="Popular searches">Popular searches</a>
</p>
</div>
<script src="https://a-v2.sndcdn.com/assets/44-9a5c9650.js" crossorigin></script>
<script>window.__sc_version="1617291044"</script>
<script crossorigin src="https://a-v2.sndcdn.com/assets/49-5f48c9f5.js"></script>
<script crossorigin src="https://a-v2.sndcdn.com/assets/1-e3be28a4.js"></script>
<script crossorigin src="https://a-v2.sndcdn.com/assets/3-d4045f62.js"></script>
<script crossorigin src="https://a-v2.sndcdn.com/assets/2-69b33992.js"></script>
<script crossorigin src="https://a-v2.sndcdn.com/assets/0-baffb4fd.js"></script>
<script crossorigin src="https://a-v2.sndcdn.com/assets/48-98e8674a.js"></script>
<script>!function(e,n){var t,c;e=e.bind(null,n),"function"==typeof window.webpackJsonp?window.webpackJsonp([],{0:e}):(t=n.reduce(function(e,n){return e.concat(n.chunks)},[]).filter(function(e,n,t){return t.indexOf(e)===n}),(c={})[n="__sc_data_rehydration_module__"]=e,(window.webpackJsonp=window.webpackJsonp||[]).push([[],c,[[n].concat(t)]]))}(function(e,n,t,c){var o=Date.now(),a=["resource_type","get","set","addSubmodel","release"];function r(t){var n;return(n=t,a.every(function(e){return e in n.prototype}))?function(e){var n=o;e.lastFetchTime&&(n=e.lastFetchTime,delete e.lastFetchTime),(e=new t(e,{parse:!0,__hydrate:!0})).lastFetchTime=n,e.release()}:t}e.forEach(function(e){try{var n=r(c(e.id));e.data.forEach(function(e){n(e)})}catch(e){}})},[{"id":1963,"chunks":[0],"data":[{"features":["v2_show_pro_unlimited_badge_profile","v2_hide_pro_badge_on_avatar","v2_enable_sourcepoint_tcfv2","v2_can_request_verified_badge","v2_test_feature_toggle","v2_snippet_ux_skip_snippets_in_play_queue","v2_post_with_caption","v2_repost_redirect_page","v2_direct_support_link","v2_hq_file_storage_release","v2_enable_onetrust","v2_use_onetrust_eu2","v2_show_verified_badge","v2_oscp_german_tax_fields_support","v2_use_new_connect","v2_use_onetrust_eu1","v2_enable_sourcepoint","v2_tags_recent_tracks","system_playlist_in_library","v2_can_see_insights","v2_enable_pwa"]}]},{"id":158,"chunks":[48],"data":[{"allows_messages_from_unfollowed_users":false,"analytics_opt_in":true,"communications_opt_in":true,"targeted_advertising_opt_in":false,"legislation":[]}]},{"id":1980,"chunks":[48],"data":[{"country_code":"ES","country_name":"Spain","region":"58","city":"A Coruna","postal_code":"15008","latitude":43.36749267578125,"longitude":-8.396896362304688}]},{"id":1964,"chunks":[0],"data":[{"reco_listening":{"experiment_name":"home_swap_exploration","variant_id":2226,"variant_name":"control"}}]},{"id":1010,"chunks":[0],"data":["687878-90043-136810-742081"]},{"id":32,"chunks":[48],"data":[{"avatar_url":"https://i1.sndcdn.com/avatars-000137863509-h9h7dr-large.jpg","city":"Reading","comments_count":57,"country_code":null,"created_at":"2011-08-09T12:23:23Z","creator_subscriptions":[{"product":{"id":"free"}}],"creator_subscription":{"product":{"id":"free"}},"description":"Bruce Neil from Wokingham is a singer/songwriter with a folk inspired sound, producing songs with heartfelt depth and lyrics that captivate the listener, taking them on an insightful and thought-provoking journey. As a winner of BBC Introducing, resulting in air play nationally, he has recently achieved widespread public attention following the video release of his percussive folk rendition of Guns N’ Roses track Paradise City. Not only did this go viral on social media, it was endorsed by the band themselves and has achieved recognition and air play from several US radio stations. He takes his musical inspiration and guitar-playing style from the likes of Passenger and Mick Flannery.","followers_count":757,"followings_count":1068,"first_name":"Bruce","full_name":"Bruce Neil","groups_count":0,"id":6538603,"kind":"user","last_modified":"2017-05-18T19:59:18Z","last_name":"Neil","likes_count":28,"playlist_likes_count":1,"permalink":"bruceneilmusic","permalink_url":"https://soundcloud.com/bruceneilmusic","playlist_count":0,"reposts_count":null,"track_count":23,"uri":"https://api.soundcloud.com/users/6538603","urn":"soundcloud:users:6538603","username":"Bruce Neil","verified":false,"visuals":{"urn":"soundcloud:users:6538603","enabled":true,"visuals":[{"urn":"soundcloud:visuals:6133958","entry_time":0,"visual_url":"https://i1.sndcdn.com/visuals-000006538603-laHwHB-original.jpg"}],"tracking":null},"badges":{"pro":false,"pro_unlimited":false,"verified":false},"url":"/bruceneilmusic"}]}]);</script>
</body>
</html>
'
];
