# Release Notes

## [Unreleased](https://github.com/laravel/telescope/compare/v4.17.5...4.x)

## [v4.17.5](https://github.com/laravel/telescope/compare/v4.17.4...v4.17.5) - 2024-01-30

* [4.x] Ignore duplicate tags by [@driesvints](https://github.com/driesvints) in https://github.com/laravel/telescope/pull/1431

## [v4.17.4](https://github.com/laravel/telescope/compare/v4.17.3...v4.17.4) - 2024-01-22

* [4.x] Add primary keys to database tables by [@driesvints](https://github.com/driesvints) in https://github.com/laravel/telescope/pull/1425

## [v4.17.3](https://github.com/laravel/telescope/compare/v4.17.2...v4.17.3) - 2023-12-11

* fix: clear all entries using chunks by [@skrskr](https://github.com/skrskr) in https://github.com/laravel/telescope/pull/1415
* Ignore pulse and livewire by [@tomswinkels](https://github.com/tomswinkels) in https://github.com/laravel/telescope/pull/1418

## [v4.17.2](https://github.com/laravel/telescope/compare/v4.17.1...v4.17.2) - 2023-11-01

- Revert "Fixes RelatedEntries is not loaded after migrating from mix to vite" by [@taylorotwell](https://github.com/taylorotwell) in https://github.com/laravel/telescope/pull/1402
- Revert "[4.x] Mix to Vite migration" by [@taylorotwell](https://github.com/taylorotwell) in https://github.com/laravel/telescope/pull/1403

## [v4.17.1](https://github.com/laravel/telescope/compare/v4.17.0...v4.17.1) - 2023-11-01

- Fixes RelatedEntries is not loaded after migrating from mix to vite by [@crynobone](https://github.com/crynobone) in https://github.com/laravel/telescope/pull/1401

## [v4.17.0](https://github.com/laravel/telescope/compare/v4.16.4...v4.17.0) - 2023-10-31

- Mix to Vite migration by [@esurov](https://github.com/esurov) in https://github.com/laravel/telescope/pull/1391

## [v4.16.4](https://github.com/laravel/telescope/compare/v4.16.3...v4.16.4) - 2023-09-25

- Fix duplicated queries on multiple connections by [@February30th](https://github.com/February30th) in https://github.com/laravel/telescope/pull/1385

## [v4.16.3](https://github.com/laravel/telescope/compare/v4.16.2...v4.16.3) - 2023-09-19

- modified moment-timezone package version in package.json by [@yoonustehrani](https://github.com/yoonustehrani) in https://github.com/laravel/telescope/pull/1382

## [v4.16.2](https://github.com/laravel/telescope/compare/v4.16.1...v4.16.2) - 2023-08-28

- Test Improvements by [@crynobone](https://github.com/crynobone) in https://github.com/laravel/telescope/pull/1378
- Handle pushed jobs by [@timacdonald](https://github.com/timacdonald) in https://github.com/laravel/telescope/pull/1379

## [v4.16.1](https://github.com/laravel/telescope/compare/v4.16.0...v4.16.1) - 2023-08-11

- Fix copy to clipboard button position on query preview by [@alissn](https://github.com/alissn) in https://github.com/laravel/telescope/pull/1373

## [v4.16.0](https://github.com/laravel/telescope/compare/v4.15.2...v4.16.0) - 2023-08-08

- [4.x] Add hotkey to clear entries without confirmation: CMD+K  by [@bradleybernard](https://github.com/bradleybernard) in https://github.com/laravel/telescope/pull/1364
- Enhancement: Multi-Tag Filtering and Search Functionality by [@Algeneralo](https://github.com/Algeneralo) in https://github.com/laravel/telescope/pull/1367

## [v4.15.2](https://github.com/laravel/telescope/compare/v4.15.1...v4.15.2) - 2023-07-13

- [4.x] Fixes unexpected jobs on Vapor by [@nunomaduro](https://github.com/nunomaduro) in https://github.com/laravel/telescope/pull/1363

## [v4.15.1](https://github.com/laravel/telescope/compare/v4.15.0...v4.15.1) - 2023-06-21

- Fix non existing property by [@driesvints](https://github.com/driesvints) in https://github.com/laravel/telescope/pull/1360

## [v4.15.0](https://github.com/laravel/telescope/compare/v4.14.6...v4.15.0) - 2023-06-08

- Feature/copy to clipboard by @diogogomeswww in https://github.com/laravel/telescope/pull/1356

## [v4.14.6](https://github.com/laravel/telescope/compare/v4.14.5...v4.14.6) - 2023-06-03

- Show list of headers when present by @timacdonald in https://github.com/laravel/telescope/pull/1355

## [v4.14.5](https://github.com/laravel/telescope/compare/v4.14.4...v4.14.5) - 2023-06-02

- Avoids serialialisation of exception traces by @nunomaduro in https://github.com/laravel/telescope/pull/1354

## [v4.14.4](https://github.com/laravel/telescope/compare/v4.14.3...v4.14.4) - 2023-05-29

- Fixes jobs saying "pending" forever by @nunomaduro in https://github.com/laravel/telescope/pull/1349
- Prevent Memory Leak when using hideRequestParameters and hideRequestHeaders by @danilopinotti in https://github.com/laravel/telescope/pull/1350

## [v4.14.3](https://github.com/laravel/telescope/compare/v4.14.2...v4.14.3) - 2023-05-19

- Add duration to HTTP Client watcher by @DougSisk in https://github.com/laravel/telescope/pull/1348

## [v4.14.2](https://github.com/laravel/telescope/compare/v4.14.1...v4.14.2) - 2023-04-19

- Fix MailWatcher tags by @Rezrazi in https://github.com/laravel/telescope/pull/1340

## [v4.14.1](https://github.com/laravel/telescope/compare/v4.14.0...v4.14.1) - 2023-03-17

- Return callable output on Telescope::withoutRecording by @adamczykpiotr in https://github.com/laravel/telescope/pull/1317
- Removed redundant default value from config file by @siarheipashkevich in https://github.com/laravel/telescope/pull/1323
- Don't use constructor injection in console commands, and inject into handle() instead by @mad-briller in https://github.com/laravel/telescope/pull/1327

## [v4.14.0](https://github.com/laravel/telescope/compare/v4.13.2...v4.14.0) - 2023-02-21

- Prevent `Laravel\Scout\Jobs\MakeSearchable` job from being recorded to avoid memory leak by @nicoverbruggen in https://github.com/laravel/telescope/pull/1306
- Allows to specify the log level by @nunomaduro in https://github.com/laravel/telescope/pull/1312

## [v4.13.2](https://github.com/laravel/telescope/compare/v4.13.1...v4.13.2) - 2023-02-16

- Create a fresh instance of schema for each migration by @nunomaduro in https://github.com/laravel/telescope/pull/1305

## [v4.13.1](https://github.com/laravel/telescope/compare/v4.13.0...v4.13.1) - 2023-02-06

### Changed

- Center header button icons by @timacdonald in https://github.com/laravel/telescope/pull/1299

## [v4.13.0](https://github.com/laravel/telescope/compare/v4.12.0...v4.13.0) - 2023-01-30

### Changed

- A fresh coat of paint by @jessarcher in https://github.com/laravel/telescope/pull/1295

### Fixed

- Handle redis connection exception on DumpWatcher register by @aidanthewiz in https://github.com/laravel/telescope/pull/1296

## [v4.12.0](https://github.com/laravel/telescope/compare/v4.11.0...v4.12.0) - 2023-01-13

### Added

- Laravel v10 Support by @driesvints in https://github.com/laravel/telescope/pull/1292

## [v4.11.0](https://github.com/laravel/telescope/compare/v4.10.2...v4.11.0) - 2023-01-03

### Added

- Add support for model keys cast to backed enums in FormatModel by @sidquisaad in https://github.com/laravel/telescope/pull/1286

### Changed

- Uses PHP Native Type Declarations 🐘  by @nunomaduro in https://github.com/laravel/telescope/pull/1267

## [v4.10.2](https://github.com/laravel/telescope/compare/v4.10.1...v4.10.2) - 2022-12-19

### Fixed

- Fix deprecations by @driesvints in https://github.com/laravel/telescope/pull/1284

## [v4.10.1](https://github.com/laravel/telescope/compare/v4.10.0...v4.10.1) - 2022-12-14

### Fixed

- Adjust text-break layout with text-break class by @thomas-goncalves-83 in https://github.com/laravel/telescope/pull/1281
- Fix FormatModel class to work with keyless Pivot models by @Cellard in https://github.com/laravel/telescope/pull/1282

## [v4.10.0](https://github.com/laravel/telescope/compare/v4.9.6...v4.10.0) - 2022-12-05

### Added

- Add the Ability to Pass Custom `ignore_paths` To Query Watcher by @Watercycle in https://github.com/laravel/telescope/pull/1276

## [v4.9.6](https://github.com/laravel/telescope/compare/v4.9.5...v4.9.6) - 2022-11-08

### Fixed

- Fix issue where json_encode quietly fails due to binary data inside telescope entry by @Hexide in https://github.com/laravel/telescope/pull/1266

## [v4.9.5](https://github.com/laravel/telescope/compare/v4.9.4...v4.9.5) - 2022-10-06

### Fixed

- Dont register redis watcher if the redis service is not bound into the container. by @mad-briller in https://github.com/laravel/telescope/pull/1259

## [v4.9.4](https://github.com/laravel/telescope/compare/v4.9.3...v4.9.4) - 2022-10-03

### Fixed

- Do not record when unserializing command by @driesvints in https://github.com/laravel/telescope/pull/1257 & https://github.com/laravel/telescope/pull/1258

## [v4.9.3](https://github.com/laravel/telescope/compare/v4.9.2...v4.9.3) - 2022-09-12

### Fixed

- Fix bug watching invokeable object events by @ziadoz in https://github.com/laravel/telescope/pull/1250

## [v4.9.2](https://github.com/laravel/telescope/compare/v4.9.1...v4.9.2) - 2022-08-08

### Changed

- HTML Response vs Empty Response by @bdenizar in https://github.com/laravel/telescope/pull/1242

## [v4.9.1](https://github.com/laravel/telescope/compare/v4.9.0...v4.9.1) - 2022-07-18

### Fixed

- Check tags after set $this->user() by @trin4ik in https://github.com/laravel/telescope/pull/1236

## [v4.9.0](https://github.com/laravel/telescope/compare/v4.8.3...v4.9.0) - 2022-04-19

### Added

- Add support for ignoring by HTTP Verb by @ArthurPatriot in https://github.com/laravel/telescope/pull/1222

## [v4.8.3](https://github.com/laravel/telescope/compare/v4.8.2...v4.8.3) - 2022-04-11

### Changed

- Relax user type in GateWatcher to match Laravel base framework. by @CImrie in https://github.com/laravel/telescope/pull/1221

## [v4.8.2](https://github.com/laravel/telescope/compare/v4.8.1...v4.8.2) - 2022-04-01

### Fixed

- Defer loading monitored tags by @taylorotwell in https://github.com/laravel/telescope/pull/1215

## [v4.8.1](https://github.com/laravel/telescope/compare/v4.8.0...v4.8.1) - 2022-03-26

### Changed

- CacheWatcher hide values by @dododedodonl in https://github.com/laravel/telescope/pull/1206
- Read from Horizon config when ignoring requests by @lightbulblighter in https://github.com/laravel/telescope/pull/1211

## [v4.8.0](https://github.com/laravel/telescope/compare/v4.7.4...v4.8.0) - 2022-03-15

### Added

- Add option to record dumps even though the dump watcher tab is not open by @superDuperCyberTechno in https://github.com/laravel/telescope/pull/1199
- Add pause and resume commands by @jamespavett in https://github.com/laravel/telescope/pull/1200

### Changed

- Use Throwable instead of Exception by @adriaanzon in https://github.com/laravel/telescope/pull/1201

## [v4.7.4](https://github.com/laravel/telescope/compare/v4.7.3...v4.7.4) - 2022-03-03

### Changed

- Use new anonymous classes by @mmachatschek in https://github.com/laravel/telescope/pull/1194

### Fixed

- Truncate request url more by @driesvints in https://github.com/laravel/telescope/pull/1195

## [v4.7.3](https://github.com/laravel/telescope/compare/v4.7.2...v4.7.3) - 2022-02-15

### Fixed

- Mails sent through Notifications preview invalid HTML by @guushuizen in https://github.com/laravel/telescope/pull/1188

## [v4.7.2](https://github.com/laravel/telescope/compare/v4.7.1...v4.7.2) - 2022-02-04

### Fixed

- Fix key handling for ModelWatcher ([#1180](https://github.com/laravel/telescope/pull/1180))

## [v4.7.1](https://github.com/laravel/telescope/compare/v4.7.0...v4.7.1) - 2022-02-01

### Changed

- Attempt to fix model hydration ([#1174](https://github.com/laravel/telescope/pull/1174))

## [v4.7.0 (2022-01-12)](https://github.com/laravel/telescope/compare/v4.6.10...v4.7.0)

### Changed

- Laravel 9 Support ([#1170](https://github.com/laravel/telescope/pull/1170))

## [v4.6.10 (2022-01-04)](https://github.com/laravel/telescope/compare/v4.6.9...v4.6.10)

### Fixed

- Fix issue with array hydration ([#1165](https://github.com/laravel/telescope/pull/1165))

## [v4.6.9 (2021-12-07)](https://github.com/laravel/telescope/compare/v4.6.8...v4.6.9)

### Changed

- Merge previously defined view data when building the view mailable data ([#1157](https://github.com/laravel/telescope/pull/1157))

### Fixed

- Add key attribute ([#1154](https://github.com/laravel/telescope/pull/1154))
- Fix PHP 8.1 issues ([#1156](https://github.com/laravel/telescope/pull/1156))

## [v4.6.8 (2021-11-30)](https://github.com/laravel/telescope/compare/v4.6.7...v4.6.8)

### Changed

- Add support ignore request when status code specified ([abc9660](https://github.com/laravel/telescope/commit/abc96609553badb8907f749c95a408e6a72aab73), [#1150](https://github.com/laravel/telescope/pull/1150))

## [v4.6.7 (2021-11-16)](https://github.com/laravel/telescope/compare/v4.6.6...v4.6.7)

### Changed

- Slow query filter method added ([#1146](https://github.com/laravel/telescope/pull/1146))

## [v4.6.6 (2021-11-04)](https://github.com/laravel/telescope/compare/v4.6.5...v4.6.6)

### Changed

- Replace Http/Uri with HTTP/URI  ([#1141](https://github.com/laravel/telescope/pull/1141))

### Fixed

- Fix syntax highlighting ([#1142](https://github.com/laravel/telescope/pull/1142))

## [v4.6.5 (2021-10-05)](https://github.com/laravel/telescope/compare/v4.6.4...v4.6.5)

### Fixed

- Fix mail to check to allow for null to fields ([#1133](https://github.com/laravel/telescope/pull/1133))

## [v4.6.4 (2021-09-16)](https://github.com/laravel/telescope/compare/v4.6.3...v4.6.4)

### Fixed

- Don't log HTTP requests to Telescope endpoints ([#1127](https://github.com/laravel/telescope/pull/1127))
- Laravel Octane fix: GateWatcher handles stack trace caller not found ([#1128](https://github.com/laravel/telescope/pull/1128))

## [v4.6.3 (2021-09-14)](https://github.com/laravel/telescope/compare/v4.6.2...v4.6.3)

### Fixed

- Fix `telescope.domain` usage ([#1124](https://github.com/laravel/telescope/pull/1124))

## [v4.6.2 (2021-08-17)](https://github.com/laravel/telescope/compare/v4.6.1...v4.6.2)

### Fixed

- Rewind http client response after recording ([#1114](https://github.com/laravel/telescope/pull/1114))

## [v4.6.1 (2021-08-03)](https://github.com/laravel/telescope/compare/v4.6.0...v4.6.1)

### Changed

- Record 'connection failed' http client event ([#1097](https://github.com/laravel/telescope/pull/1097))
- Unified asset publishing ([#1105](https://github.com/laravel/telescope/pull/1105))

### Fixes

- Suppress filesize errors in client request watcher ([#1096](https://github.com/laravel/telescope/pull/1096))
- Use `intdiv` where appropriate to prevent unexpected conversion to float ([#1100](https://github.com/laravel/telescope/pull/1100))
- Fix publishing for disabled module ([#1104](https://github.com/laravel/telescope/pull/1104))

## [v4.6.0 (2021-07-13)](https://github.com/laravel/telescope/compare/v4.5.1...v4.6.0)

### Added

- Add a new "Clear Entries" button ([#1091](https://github.com/laravel/telescope/pull/1091))

### Changed

- `Telescope:withoutRecording()` should be exception safe ([#1092](https://github.com/laravel/telescope/pull/1092))

### Fixed

- Fixed frontend request polling memory leaks ([#1086](https://github.com/laravel/telescope/pull/1086))
- Fix for `JobWatchers` when the job payload is encrypted ([#1089](https://github.com/laravel/telescope/pull/1089))

## [v4.5.1 (2021-06-22)](https://github.com/laravel/telescope/compare/v4.5.0...v4.5.1)

### Fixed

- Http Client Link State ([#1078](https://github.com/laravel/telescope/pull/1078))
- Improve file handling in client request watcher ([#1080](https://github.com/laravel/telescope/pull/1080))

## [v4.5.0 (2021-06-01)](https://github.com/laravel/telescope/compare/v4.4.10...v4.5.0)

### Added

- Add http client request watcher ([#1073](https://github.com/laravel/telescope/pull/1073))

## [v4.4.10 (2021-06-01)](https://github.com/laravel/telescope/compare/v4.4.9...v4.4.10)

### Changed

- Remove asset manifest check and warning ([#1063](https://github.com/laravel/telescope/pull/1063))

### Fixed

- Implemented fallback for `PDO::quote` method on `QueryWatcher` ([#1066](https://github.com/laravel/telescope/pull/1066))

## [v4.4.9 (2021-04-06)](https://github.com/laravel/telescope/compare/v4.4.8...v4.4.9)

### Fixed

- Always boot commands ([#1045](https://github.com/laravel/telescope/pull/1045))
- Fix JSON indenting ([#1049](https://github.com/laravel/telescope/pull/1049))
- Fix query formatting in preview ([#1050](https://github.com/laravel/telescope/pull/1050))

## [v4.4.8 (2021-04-06)](https://github.com/laravel/telescope/compare/v4.4.7...v4.4.8)

### Fixed

- Fix query preview ([#1044](https://github.com/laravel/telescope/pull/1044))

## [v4.4.7 (2021-04-06)](https://github.com/laravel/telescope/compare/v4.4.6...v4.4.7)

### Changed

- Move booting of commands ([#1034](https://github.com/laravel/telescope/pull/1034))
- Prep For Octane ([#1040](https://github.com/laravel/telescope/pull/1040))

## [v4.4.6 (2021-03-11)](https://github.com/laravel/telescope/compare/v4.4.5...v4.4.6)

### Fixed

- Revert "[4.x] Move cache read inside handler to avoid early cache call" ([#1030](https://github.com/laravel/telescope/pull/1030))

## [v4.4.5 (2021-03-09)](https://github.com/laravel/telescope/compare/v4.4.4...v4.4.5)

### Fixed

- Move cache read inside handler to avoid early cache call ([#1025](https://github.com/laravel/telescope/pull/1025))

## [v4.4.4 (2021-02-23)](https://github.com/laravel/telescope/compare/v4.4.3...v4.4.4)

### Fixed

- Implement new `GateEvaluated` event ([#1018](https://github.com/laravel/telescope/pull/1018))

## [v4.4.3 (2021-02-16)](https://github.com/laravel/telescope/compare/v4.4.2...v4.4.3)

### Fixed

- Handle when `$batch` is `null` ([#1013](https://github.com/laravel/telescope/pull/1013))

## [v4.4.2 (2021-02-09)](https://github.com/laravel/telescope/compare/v4.4.1...v4.4.2)

### Fixed

- GateWatcher shows allowed when it is denied via Response class ([#1010](https://github.com/laravel/telescope/pull/1010))

## [v4.4.1 (2021-01-26)](https://github.com/laravel/telescope/compare/v4.4.0...v4.4.1)

### Fixed

- Prevent access to uninitialized typed properties ([#1005](https://github.com/laravel/telescope/pull/1005))

## [v4.4.0 (2020-12-15)](https://github.com/laravel/telescope/compare/v4.3.3...v4.4.0)

### Added

- Add model hydrations to model watcher ([#1000](https://github.com/laravel/telescope/pull/1000))

### Fixed

- Fix typo in memory calculation ([#997](https://github.com/laravel/telescope/pull/997))

## [v4.3.3 (2020-12-08)](https://github.com/laravel/telescope/compare/v4.3.2...v4.3.3)

### Fixed

- Revert "[4.x] Updated db command for clearing tables" ([#993](https://github.com/laravel/telescope/pull/993))

## [v4.3.2 (2020-12-08)](https://github.com/laravel/telescope/compare/v4.3.1...v4.3.2)

### Changed

- Updated db command for clearing tables ([#991](https://github.com/laravel/telescope/pull/991))

## [v4.3.1 (2020-11-05)](https://github.com/laravel/telescope/compare/v4.3.0...v4.3.1)

### Fixed

- Fix for database migrations publishing path ([#979](https://github.com/laravel/telescope/pull/979))

## [v4.3.0 (2020-11-03)](https://github.com/laravel/telescope/compare/v4.2.0...v4.3.0)

### Added

- PHP 8 Support ([#977](https://github.com/laravel/telescope/pull/977))

### Changed

- Consolidate database directory ([#975](https://github.com/laravel/telescope/pull/975))

## [v4.2.0 (2020-10-20)](https://github.com/laravel/telescope/compare/v4.1.0...v4.2.0)

### Added

- Be able to specify only allowed paths ([#963](https://github.com/laravel/telescope/pull/963), ([18c475f](https://github.com/laravel/telescope/commit/18c475f858ad1473585a1a715f61d32227d6742a)))
- Added `isGate()` filter ([#967](https://github.com/laravel/telescope/pull/967))
- Added `isRequest()` filter ([#966](https://github.com/laravel/telescope/pull/966))

## [v4.1.0 (2020-10-06)](https://github.com/laravel/telescope/compare/v4.0.1...v4.1.0)

### Added

- Dump visibility toggling, search, etc ([#959](https://github.com/laravel/telescope/pull/959))

## [v4.0.1 (2020-09-22)](https://github.com/laravel/telescope/compare/v4.0.0...v4.0.1)

### Fixed

- Support new listeners syntax ([a69fc6f](https://github.com/laravel/telescope/commit/a69fc6f4f5fd5b0ac5a242981e162774cbb69e17))

## [v4.0.0 (2020-09-08)](https://github.com/laravel/telescope/compare/v3.5.1...v4.0.0)

### Added

- Laravel 8 support & Batches support ([#903](https://github.com/laravel/telescope/pull/903))

### Fixed

- May be written to an empty log ([#930](https://github.com/laravel/telescope/pull/930))

### Removed

- Laravel 6 & 7 support ([#860](https://github.com/laravel/telescope/pull/860))
- PHP 7.2 support ([3c3883d](https://github.com/laravel/telescope/commit/3c3883d5bf64fd9f960ffeb1557d5f8ce370bbde))

## [v3.5.1 (2020-07-28)](https://github.com/laravel/telescope/compare/v3.5.0...v3.5.1)

### Fixed

- Change text for Marking Exceptions as Resolved ([#916](https://github.com/laravel/telescope/pull/916))
- Add explicit base font family fallback ([#920](https://github.com/laravel/telescope/pull/920))
- Remove problematic unused code when formatting SQL ([#924](https://github.com/laravel/telescope/pull/924))

## [v3.5.0 (2020-05-14)](https://github.com/laravel/telescope/compare/v3.4.0...v3.5.0)

### Added

- Add request IP address to RequestWatcher ([#895](https://github.com/laravel/telescope/pull/895))

### Fixed

- Compile assets ([762e4ed](https://github.com/laravel/telescope/commit/762e4ed57b0bd11bbc60349d962f5f8435602509))

## [v3.4.0 (2020-05-12)](https://github.com/laravel/telescope/compare/v3.3.1...v3.4.0)

### Added

- Allow avatar path customization ([#890](https://github.com/laravel/telescope/pull/890), [94a3952](https://github.com/laravel/telescope/commit/94a39526bf013c7f27df5c74de2f3e6711c01722))
- Add entry to afterRecording hook ([#893](https://github.com/laravel/telescope/pull/893))
- Add afterStore hooks ([#894](https://github.com/laravel/telescope/pull/894), ([600e462](https://github.com/laravel/telescope/commit/600e462ddad30a033567ccd06a162b522393eef7)))

## [v3.3.1 (2020-05-05)](https://github.com/laravel/telescope/compare/v3.3.0...v3.3.1)

### Fixed

- Changed truncate from 75 chars to 50 ([#887](https://github.com/laravel/telescope/pull/887))
- Add index to created_at ([#885](https://github.com/laravel/telescope/pull/885))

## [v3.3.0 (2020-04-28)](https://github.com/laravel/telescope/compare/v3.2.2...v3.3.0)

### Added

- Ability to review Exception context data ([#882](https://github.com/laravel/telescope/pull/882))

## [v3.2.2 (2020-04-21)](https://github.com/laravel/telescope/compare/v3.2.1...v3.2.2)

### Fixed

- Fix typed properties issues ([#879](https://github.com/laravel/telescope/pull/879))
- Remove thousands separator in time records ([#877](https://github.com/laravel/telescope/pull/877))

## [v3.2.1 (2020-04-14)](https://github.com/laravel/telescope/compare/v3.2.0...v3.2.1)

### Fixed

- Testing fixes ([#866](https://github.com/laravel/telescope/pull/866))
- Encode array for logging ([#873](https://github.com/laravel/telescope/pull/873))

## [v3.2.0 (2020-03-17)](https://github.com/laravel/telescope/compare/v3.1.1...v3.2.0)

### Added

- Added `isQuery` in `IncomingEntry` ([#842](https://github.com/laravel/telescope/pull/842))

### Fixed

- Preserving the alphabetical order of providers ([#841](https://github.com/laravel/telescope/pull/841))

## [v3.1.1 (2020-02-27)](https://github.com/laravel/telescope/compare/v3.1.0...v3.1.1)

### Fixed

- Fix array to string conversion ([#839](https://github.com/laravel/telescope/pull/839))

## [v3.1.0 (2020-02-25)](https://github.com/laravel/telescope/compare/v3.0.0...v3.1.0)

### Added

- Laravel 7 support ([a26891d](https://github.com/laravel/telescope/commit/a26891d1bcf8947e25a32b1293f10584fd7d8cf3))

## [v3.0.0 (2020-02-18)](https://github.com/laravel/telescope/compare/v2.1.7...v3.0.0)

### Changed

- Change `Telescope::$tagUsing` to an array ([#694](https://github.com/laravel/telescope/pull/694))
- Make ignoring Laravel Nova paths configurable ([#799](https://github.com/laravel/telescope/pull/799))

### Removed

- Dropped support for Laravel 5.8

## [v2.1.7 (2020-02-18)](https://github.com/laravel/telescope/compare/v2.1.6...v2.1.7)

### Fixed

- Handle all `eval()` failures from Laravel Tinker ([#829](https://github.com/laravel/telescope/pull/829))

## [v2.1.6 (2020-02-12)](https://github.com/laravel/telescope/compare/v2.1.5...v2.1.6)

### Fixed

- ReflectionException when used with debugbar ([#825](https://github.com/laravel/telescope/pull/825))

## [v2.1.5 (2020-02-04)](https://github.com/laravel/telescope/compare/v2.1.4...v2.1.5)

### Fixed

- Only log file/line for exception trace ([#817](https://github.com/laravel/telescope/pull/817))

## [v2.1.4 (2020-01-21)](https://github.com/laravel/telescope/compare/v2.1.3...v2.1.4)

### Fixed

- Avoiding to create guard ([#810](https://github.com/laravel/telescope/pull/810))

## [v2.1.3 (2019-12-19)](https://github.com/laravel/telescope/compare/v2.1.2...v2.1.3)

### Fixed

- Check if composers key exists ([#797](https://github.com/laravel/telescope/pull/797))

## [v2.1.2 (2019-12-13)](https://github.com/laravel/telescope/compare/v2.1.1...v2.1.2)

### Fixed

- Enable redis events by default if the watcher is enabled ([#789](https://github.com/laravel/telescope/pull/789))
- Fix Round queries duration to 2 decimal places ([#791](https://github.com/laravel/telescope/pull/791))
- Fix ignore generic listeners as view composer ([#794](https://github.com/laravel/telescope/pull/794))

## [v2.1.1 (2019-11-23)](https://github.com/laravel/telescope/compare/v2.1...v2.1.1)

### Added

- Add information about view composers ([#766](https://github.com/laravel/telescope/pull/766))
- Add formatted output support for plain text responses ([#749](https://github.com/laravel/telescope/pull/749))
- Added support for event ignoring ([#738](https://github.com/laravel/telescope/pull/738))
- Show warning when manifest is outdated ([#729](https://github.com/laravel/telescope/pull/729))

### Changed

- Add the Nova API to ignore paths array ([#752](https://github.com/laravel/telescope/pull/752))
- Use getConnection method in Migrations ([#736](https://github.com/laravel/telescope/pull/736))

### Fixed

- Properly Implode Nested(Array) Notification Routes To Fix Array To String Conversion Exception ([#778](https://github.com/laravel/telescope/pull/778))
- Don't use familyHash for queries ([#773](https://github.com/laravel/telescope/pull/773))
- Hide php-auth-pw server variable by default ([#740](https://github.com/laravel/telescope/pull/740))
- Use time instead of duplicated to show global queries duration ([#737](https://github.com/laravel/telescope/pull/737))
- Check for null values in query bindings ([#727](https://github.com/laravel/telescope/pull/727))
- Prevent resuming recording when processing sync job ([#720](https://github.com/laravel/telescope/pull/720))

## [v2.1 (2019-09-03)](https://github.com/laravel/telescope/compare/v2.0.6...v2.1)

### Added

- Jump to related entry by hash ([#708](https://github.com/laravel/telescope/pull/708))
- Format SQL in watcher ([#714](https://github.com/laravel/telescope/pull/714))
- Mark exceptions as resolved ([#710](https://github.com/laravel/telescope/pull/710))
- Full timestamp on hover ([#668](https://github.com/laravel/telescope/pull/668))
- Add memory to request watcher ([#680](https://github.com/laravel/telescope/pull/680))
- Add view collector ([#679](https://github.com/laravel/telescope/pull/679))

### Changed

- Adding meta for disavowing robots ([#703](https://github.com/laravel/telescope/pull/703))
- Chunk storage of exceptions and tags ([#670](https://github.com/laravel/telescope/pull/670))
- Simplify dump error screen ([#688](https://github.com/laravel/telescope/pull/688))

### Fixed

- Log failed requests ([#701](https://github.com/laravel/telescope/pull/701))
- Fix view tab selection order ([#707](https://github.com/laravel/telescope/pull/707))
- Only load sfDump header once ([#714](https://github.com/laravel/telescope/pull/714))
- Fix events with ShouldBroadcastNow ([#623](https://github.com/laravel/telescope/pull/623))
- Support duration calculation without constant `LARAVEL_START` ([#664](https://github.com/laravel/telescope/pull/664))
- Optimize dump ([#683](https://github.com/laravel/telescope/pull/683))

## [v2.0.6 (2019-07-12)](https://github.com/laravel/telescope/compare/v2.0.5...v2.0.6)

### Fixed

- Enable chunking on delete to prevent errors on large resultsets ([#658](https://github.com/laravel/telescope/pull/658), [32c3709](https://github.com/laravel/telescope/commit/32c37098f0f2843eb95f35f840adae3642e31e92))

## [v2.0.5 (2019-06-05)](https://github.com/laravel/telescope/compare/v2.0.4...v2.0.5)

### Added

- Add app `name` config to title and dashboard ([#643](https://github.com/laravel/telescope/pull/643)), ([a3f1580](https://github.com/laravel/telescope/commit/a3f15809dd1de4759d44c159e99b9474d8b83e94))

### Fixed

- JSON fallback font ([#605](https://github.com/laravel/telescope/pull/605))
- PHPUnit 8 Warnings ([#610](https://github.com/laravel/telescope/pull/610))
- Empty path config in frontend ([#637](https://github.com/laravel/telescope/pull/637))

## [v2.0.4 (2019-03-28)](https://github.com/laravel/telescope/compare/v2.0.3...v2.0.4)

### Fixed

- use `property_exists` ([eb3f6f8](https://github.com/laravel/telescope/commit/eb3f6f8337050cc31fe1a1164240fe205e33b167))

## [v2.0.3 (2019-03-27)](https://github.com/laravel/telescope/compare/v2.0.2...v2.0.3)

### Changed

- Cache key compatibility update ([#583](https://github.com/laravel/telescope/pull/583))

### Fixed

- Newline Config ([#595](https://github.com/laravel/telescope/pull/595))

## [v2.0.2 (2019-03-06)](https://github.com/laravel/telescope/compare/v2.0.1...v2.0.2)

### Fixes

- Support apps that run carbon 1.0 ([2b976e5](https://github.com/laravel/telescope/commit/2b976e5d6f5273d8ac86e2db9487386dd27a19ef))

## [v2.0.1 (2019-03-05)](https://github.com/laravel/telescope/compare/v2.0...v2.0.1)

### Added

- Added support for `Date::use(CarbonImmutable::class);` ([d7a3ca4](https://github.com/laravel/telescope/commit/d7a3ca4338b1a1527b8d19a5d62015a468f8ca56))

## [v2.0.0 (2019-02-27)](https://github.com/laravel/telescope/compare/v1.1...v2.0)

### Changed

- Update Cache to use seconds instead of minutes ([#562](https://github.com/laravel/telescope/pull/562))
