<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/bigtable/v1/bigtable_service_messages.proto

namespace Google\Bigtable\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request message for BigtableServer.ReadRows.
 *
 * Generated from protobuf message <code>google.bigtable.v1.ReadRowsRequest</code>
 */
class ReadRowsRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * The unique name of the table from which to read.
     *
     * Generated from protobuf field <code>string table_name = 1;</code>
     */
    private $table_name = '';
    /**
     * The filter to apply to the contents of the specified row(s). If unset,
     * reads the entire table.
     *
     * Generated from protobuf field <code>.google.bigtable.v1.RowFilter filter = 5;</code>
     */
    private $filter = null;
    /**
     * By default, rows are read sequentially, producing results which are
     * guaranteed to arrive in increasing row order. Setting
     * "allow_row_interleaving" to true allows multiple rows to be interleaved in
     * the response stream, which increases throughput but breaks this guarantee,
     * and may force the client to use more memory to buffer partially-received
     * rows. Cannot be set to true when specifying "num_rows_limit".
     *
     * Generated from protobuf field <code>bool allow_row_interleaving = 6;</code>
     */
    private $allow_row_interleaving = false;
    /**
     * The read will terminate after committing to N rows' worth of results. The
     * default (zero) is to return all results.
     * Note that "allow_row_interleaving" cannot be set to true when this is set.
     *
     * Generated from protobuf field <code>int64 num_rows_limit = 7;</code>
     */
    private $num_rows_limit = 0;
    protected $target;

    public function __construct() {
        \GPBMetadata\Google\Bigtable\V1\BigtableServiceMessages::initOnce();
        parent::__construct();
    }

    /**
     * The unique name of the table from which to read.
     *
     * Generated from protobuf field <code>string table_name = 1;</code>
     * @return string
     */
    public function getTableName()
    {
        return $this->table_name;
    }

    /**
     * The unique name of the table from which to read.
     *
     * Generated from protobuf field <code>string table_name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setTableName($var)
    {
        GPBUtil::checkString($var, True);
        $this->table_name = $var;

        return $this;
    }

    /**
     * The key of a single row from which to read.
     *
     * Generated from protobuf field <code>bytes row_key = 2;</code>
     * @return string
     */
    public function getRowKey()
    {
        return $this->readOneof(2);
    }

    /**
     * The key of a single row from which to read.
     *
     * Generated from protobuf field <code>bytes row_key = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setRowKey($var)
    {
        GPBUtil::checkString($var, False);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * A range of rows from which to read.
     *
     * Generated from protobuf field <code>.google.bigtable.v1.RowRange row_range = 3;</code>
     * @return \Google\Bigtable\V1\RowRange
     */
    public function getRowRange()
    {
        return $this->readOneof(3);
    }

    /**
     * A range of rows from which to read.
     *
     * Generated from protobuf field <code>.google.bigtable.v1.RowRange row_range = 3;</code>
     * @param \Google\Bigtable\V1\RowRange $var
     * @return $this
     */
    public function setRowRange($var)
    {
        GPBUtil::checkMessage($var, \Google\Bigtable\V1\RowRange::class);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * A set of rows from which to read. Entries need not be in order, and will
     * be deduplicated before reading.
     * The total serialized size of the set must not exceed 1MB.
     *
     * Generated from protobuf field <code>.google.bigtable.v1.RowSet row_set = 8;</code>
     * @return \Google\Bigtable\V1\RowSet
     */
    public function getRowSet()
    {
        return $this->readOneof(8);
    }

    /**
     * A set of rows from which to read. Entries need not be in order, and will
     * be deduplicated before reading.
     * The total serialized size of the set must not exceed 1MB.
     *
     * Generated from protobuf field <code>.google.bigtable.v1.RowSet row_set = 8;</code>
     * @param \Google\Bigtable\V1\RowSet $var
     * @return $this
     */
    public function setRowSet($var)
    {
        GPBUtil::checkMessage($var, \Google\Bigtable\V1\RowSet::class);
        $this->writeOneof(8, $var);

        return $this;
    }

    /**
     * The filter to apply to the contents of the specified row(s). If unset,
     * reads the entire table.
     *
     * Generated from protobuf field <code>.google.bigtable.v1.RowFilter filter = 5;</code>
     * @return \Google\Bigtable\V1\RowFilter
     */
    public function getFilter()
    {
        return $this->filter;
    }

    /**
     * The filter to apply to the contents of the specified row(s). If unset,
     * reads the entire table.
     *
     * Generated from protobuf field <code>.google.bigtable.v1.RowFilter filter = 5;</code>
     * @param \Google\Bigtable\V1\RowFilter $var
     * @return $this
     */
    public function setFilter($var)
    {
        GPBUtil::checkMessage($var, \Google\Bigtable\V1\RowFilter::class);
        $this->filter = $var;

        return $this;
    }

    /**
     * By default, rows are read sequentially, producing results which are
     * guaranteed to arrive in increasing row order. Setting
     * "allow_row_interleaving" to true allows multiple rows to be interleaved in
     * the response stream, which increases throughput but breaks this guarantee,
     * and may force the client to use more memory to buffer partially-received
     * rows. Cannot be set to true when specifying "num_rows_limit".
     *
     * Generated from protobuf field <code>bool allow_row_interleaving = 6;</code>
     * @return bool
     */
    public function getAllowRowInterleaving()
    {
        return $this->allow_row_interleaving;
    }

    /**
     * By default, rows are read sequentially, producing results which are
     * guaranteed to arrive in increasing row order. Setting
     * "allow_row_interleaving" to true allows multiple rows to be interleaved in
     * the response stream, which increases throughput but breaks this guarantee,
     * and may force the client to use more memory to buffer partially-received
     * rows. Cannot be set to true when specifying "num_rows_limit".
     *
     * Generated from protobuf field <code>bool allow_row_interleaving = 6;</code>
     * @param bool $var
     * @return $this
     */
    public function setAllowRowInterleaving($var)
    {
        GPBUtil::checkBool($var);
        $this->allow_row_interleaving = $var;

        return $this;
    }

    /**
     * The read will terminate after committing to N rows' worth of results. The
     * default (zero) is to return all results.
     * Note that "allow_row_interleaving" cannot be set to true when this is set.
     *
     * Generated from protobuf field <code>int64 num_rows_limit = 7;</code>
     * @return int|string
     */
    public function getNumRowsLimit()
    {
        return $this->num_rows_limit;
    }

    /**
     * The read will terminate after committing to N rows' worth of results. The
     * default (zero) is to return all results.
     * Note that "allow_row_interleaving" cannot be set to true when this is set.
     *
     * Generated from protobuf field <code>int64 num_rows_limit = 7;</code>
     * @param int|string $var
     * @return $this
     */
    public function setNumRowsLimit($var)
    {
        GPBUtil::checkInt64($var);
        $this->num_rows_limit = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getTarget()
    {
        return $this->whichOneof("target");
    }

}

