<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/container/v1beta1/cluster_service.proto

namespace Google\Cloud\Container\V1beta1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A Google Container Engine cluster.
 *
 * Generated from protobuf message <code>google.container.v1beta1.Cluster</code>
 */
class Cluster extends \Google\Protobuf\Internal\Message
{
    /**
     * The name of this cluster. The name must be unique within this project
     * and zone, and can be up to 40 characters with the following restrictions:
     * * Lowercase letters, numbers, and hyphens only.
     * * Must start with a letter.
     * * Must end with a number or a letter.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    private $name = '';
    /**
     * An optional description of this cluster.
     *
     * Generated from protobuf field <code>string description = 2;</code>
     */
    private $description = '';
    /**
     * The number of nodes to create in this cluster. You must ensure that your
     * Compute Engine <a href="/compute/docs/resource-quotas">resource quota</a>
     * is sufficient for this number of instances. You must also have available
     * firewall and routes quota.
     * For requests, this field should only be used in lieu of a
     * "node_pool" object, since this configuration (along with the
     * "node_config") will be used to create a "NodePool" object with an
     * auto-generated name. Do not use this and a node_pool at the same time.
     *
     * Generated from protobuf field <code>int32 initial_node_count = 3;</code>
     */
    private $initial_node_count = 0;
    /**
     * Parameters used in creating the cluster's nodes.
     * See `nodeConfig` for the description of its properties.
     * For requests, this field should only be used in lieu of a
     * "node_pool" object, since this configuration (along with the
     * "initial_node_count") will be used to create a "NodePool" object with an
     * auto-generated name. Do not use this and a node_pool at the same time.
     * For responses, this field will be populated with the node configuration of
     * the first node pool.
     * If unspecified, the defaults are used.
     *
     * Generated from protobuf field <code>.google.container.v1beta1.NodeConfig node_config = 4;</code>
     */
    private $node_config = null;
    /**
     * The authentication information for accessing the master endpoint.
     *
     * Generated from protobuf field <code>.google.container.v1beta1.MasterAuth master_auth = 5;</code>
     */
    private $master_auth = null;
    /**
     * The logging service the cluster should use to write logs.
     * Currently available options:
     * * `logging.googleapis.com` - the Google Cloud Logging service.
     * * `none` - no logs will be exported from the cluster.
     * * if left as an empty string,`logging.googleapis.com` will be used.
     *
     * Generated from protobuf field <code>string logging_service = 6;</code>
     */
    private $logging_service = '';
    /**
     * The monitoring service the cluster should use to write metrics.
     * Currently available options:
     * * `monitoring.googleapis.com` - the Google Cloud Monitoring service.
     * * `none` - no metrics will be exported from the cluster.
     * * if left as an empty string, `monitoring.googleapis.com` will be used.
     *
     * Generated from protobuf field <code>string monitoring_service = 7;</code>
     */
    private $monitoring_service = '';
    /**
     * The name of the Google Compute Engine
     * [network](/compute/docs/networks-and-firewalls#networks) to which the
     * cluster is connected. If left unspecified, the `default` network
     * will be used.
     *
     * Generated from protobuf field <code>string network = 8;</code>
     */
    private $network = '';
    /**
     * The IP address range of the container pods in this cluster, in
     * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `10.96.0.0/14`). Leave blank to have
     * one automatically chosen or specify a `/14` block in `10.0.0.0/8`.
     *
     * Generated from protobuf field <code>string cluster_ipv4_cidr = 9;</code>
     */
    private $cluster_ipv4_cidr = '';
    /**
     * Configurations for the various addons available to run in the cluster.
     *
     * Generated from protobuf field <code>.google.container.v1beta1.AddonsConfig addons_config = 10;</code>
     */
    private $addons_config = null;
    /**
     * The name of the Google Compute Engine
     * [subnetwork](/compute/docs/subnetworks) to which the
     * cluster is connected.
     *
     * Generated from protobuf field <code>string subnetwork = 11;</code>
     */
    private $subnetwork = '';
    /**
     * The node pools associated with this cluster.
     * This field should not be set if "node_config" or "initial_node_count" are
     * specified.
     *
     * Generated from protobuf field <code>repeated .google.container.v1beta1.NodePool node_pools = 12;</code>
     */
    private $node_pools;
    /**
     * The list of Google Compute Engine
     * [locations](/compute/docs/zones#available) in which the cluster's nodes
     * should be located.
     *
     * Generated from protobuf field <code>repeated string locations = 13;</code>
     */
    private $locations;
    /**
     * Kubernetes alpha features are enabled on this cluster. This includes alpha
     * API groups (e.g. v1beta1) and features that may not be production ready in
     * the kubernetes version of the master and nodes.
     * The cluster has no SLA for uptime and master/node upgrades are disabled.
     * Alpha enabled clusters are automatically deleted thirty days after
     * creation.
     *
     * Generated from protobuf field <code>bool enable_kubernetes_alpha = 14;</code>
     */
    private $enable_kubernetes_alpha = false;
    /**
     * Configuration options for the NetworkPolicy feature.
     *
     * Generated from protobuf field <code>.google.container.v1beta1.NetworkPolicy network_policy = 19;</code>
     */
    private $network_policy = null;
    /**
     * Configuration for cluster IP allocation.
     *
     * Generated from protobuf field <code>.google.container.v1beta1.IPAllocationPolicy ip_allocation_policy = 20;</code>
     */
    private $ip_allocation_policy = null;
    /**
     * The configuration options for master authorized networks feature.
     *
     * Generated from protobuf field <code>.google.container.v1beta1.MasterAuthorizedNetworksConfig master_authorized_networks_config = 22;</code>
     */
    private $master_authorized_networks_config = null;
    /**
     * Configure the maintenance policy for this cluster.
     *
     * Generated from protobuf field <code>.google.container.v1beta1.MaintenancePolicy maintenance_policy = 23;</code>
     */
    private $maintenance_policy = null;
    /**
     * Configuration for the PodSecurityPolicy feature.
     *
     * Generated from protobuf field <code>.google.container.v1beta1.PodSecurityPolicyConfig pod_security_policy_config = 25;</code>
     */
    private $pod_security_policy_config = null;
    /**
     * [Output only] Server-defined URL for the resource.
     *
     * Generated from protobuf field <code>string self_link = 100;</code>
     */
    private $self_link = '';
    /**
     * [Output only] The name of the Google Compute Engine
     * [zone](/compute/docs/zones#available) in which the cluster
     * resides.
     * This field is deprecated, use location instead.
     *
     * Generated from protobuf field <code>string zone = 101;</code>
     */
    private $zone = '';
    /**
     * [Output only] The IP address of this cluster's master endpoint.
     * The endpoint can be accessed from the internet at
     * `https://username:password&#64;endpoint/`.
     * See the `masterAuth` property of this resource for username and
     * password information.
     *
     * Generated from protobuf field <code>string endpoint = 102;</code>
     */
    private $endpoint = '';
    /**
     * The initial Kubernetes version for this cluster.  Valid versions are those
     * found in validMasterVersions returned by getServerConfig.  The version can
     * be upgraded over time; such upgrades are reflected in
     * currentMasterVersion and currentNodeVersion.
     *
     * Generated from protobuf field <code>string initial_cluster_version = 103;</code>
     */
    private $initial_cluster_version = '';
    /**
     * [Output only] The current software version of the master endpoint.
     *
     * Generated from protobuf field <code>string current_master_version = 104;</code>
     */
    private $current_master_version = '';
    /**
     * [Output only] The current version of the node software components.
     * If they are currently at multiple versions because they're in the process
     * of being upgraded, this reflects the minimum version of all nodes.
     *
     * Generated from protobuf field <code>string current_node_version = 105;</code>
     */
    private $current_node_version = '';
    /**
     * [Output only] The time the cluster was created, in
     * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
     *
     * Generated from protobuf field <code>string create_time = 106;</code>
     */
    private $create_time = '';
    /**
     * [Output only] The current status of this cluster.
     *
     * Generated from protobuf field <code>.google.container.v1beta1.Cluster.Status status = 107;</code>
     */
    private $status = 0;
    /**
     * [Output only] Additional information about the current status of this
     * cluster, if available.
     *
     * Generated from protobuf field <code>string status_message = 108;</code>
     */
    private $status_message = '';
    /**
     * [Output only] The size of the address space on each node for hosting
     * containers. This is provisioned from within the `container_ipv4_cidr`
     * range.
     *
     * Generated from protobuf field <code>int32 node_ipv4_cidr_size = 109;</code>
     */
    private $node_ipv4_cidr_size = 0;
    /**
     * [Output only] The IP address range of the Kubernetes services in
     * this cluster, in
     * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `1.2.3.4/29`). Service addresses are
     * typically put in the last `/16` from the container CIDR.
     *
     * Generated from protobuf field <code>string services_ipv4_cidr = 110;</code>
     */
    private $services_ipv4_cidr = '';
    /**
     * [Output only] The resource URLs of [instance
     * groups](/compute/docs/instance-groups/) associated with this
     * cluster.
     *
     * Generated from protobuf field <code>repeated string instance_group_urls = 111;</code>
     */
    private $instance_group_urls;
    /**
     * [Output only] The number of nodes currently in the cluster.
     *
     * Generated from protobuf field <code>int32 current_node_count = 112;</code>
     */
    private $current_node_count = 0;
    /**
     * [Output only] The time the cluster will be automatically
     * deleted in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
     *
     * Generated from protobuf field <code>string expire_time = 113;</code>
     */
    private $expire_time = '';
    /**
     * [Output only] The name of the Google Compute Engine
     * [zone](/compute/docs/regions-zones/regions-zones#available) or
     * [region](/compute/docs/regions-zones/regions-zones#available) in which
     * the cluster resides.
     *
     * Generated from protobuf field <code>string location = 114;</code>
     */
    private $location = '';

    public function __construct() {
        \GPBMetadata\Google\Container\V1Beta1\ClusterService::initOnce();
        parent::__construct();
    }

    /**
     * The name of this cluster. The name must be unique within this project
     * and zone, and can be up to 40 characters with the following restrictions:
     * * Lowercase letters, numbers, and hyphens only.
     * * Must start with a letter.
     * * Must end with a number or a letter.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * The name of this cluster. The name must be unique within this project
     * and zone, and can be up to 40 characters with the following restrictions:
     * * Lowercase letters, numbers, and hyphens only.
     * * Must start with a letter.
     * * Must end with a number or a letter.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * An optional description of this cluster.
     *
     * Generated from protobuf field <code>string description = 2;</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * An optional description of this cluster.
     *
     * Generated from protobuf field <code>string description = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * The number of nodes to create in this cluster. You must ensure that your
     * Compute Engine <a href="/compute/docs/resource-quotas">resource quota</a>
     * is sufficient for this number of instances. You must also have available
     * firewall and routes quota.
     * For requests, this field should only be used in lieu of a
     * "node_pool" object, since this configuration (along with the
     * "node_config") will be used to create a "NodePool" object with an
     * auto-generated name. Do not use this and a node_pool at the same time.
     *
     * Generated from protobuf field <code>int32 initial_node_count = 3;</code>
     * @return int
     */
    public function getInitialNodeCount()
    {
        return $this->initial_node_count;
    }

    /**
     * The number of nodes to create in this cluster. You must ensure that your
     * Compute Engine <a href="/compute/docs/resource-quotas">resource quota</a>
     * is sufficient for this number of instances. You must also have available
     * firewall and routes quota.
     * For requests, this field should only be used in lieu of a
     * "node_pool" object, since this configuration (along with the
     * "node_config") will be used to create a "NodePool" object with an
     * auto-generated name. Do not use this and a node_pool at the same time.
     *
     * Generated from protobuf field <code>int32 initial_node_count = 3;</code>
     * @param int $var
     * @return $this
     */
    public function setInitialNodeCount($var)
    {
        GPBUtil::checkInt32($var);
        $this->initial_node_count = $var;

        return $this;
    }

    /**
     * Parameters used in creating the cluster's nodes.
     * See `nodeConfig` for the description of its properties.
     * For requests, this field should only be used in lieu of a
     * "node_pool" object, since this configuration (along with the
     * "initial_node_count") will be used to create a "NodePool" object with an
     * auto-generated name. Do not use this and a node_pool at the same time.
     * For responses, this field will be populated with the node configuration of
     * the first node pool.
     * If unspecified, the defaults are used.
     *
     * Generated from protobuf field <code>.google.container.v1beta1.NodeConfig node_config = 4;</code>
     * @return \Google\Cloud\Container\V1beta1\NodeConfig
     */
    public function getNodeConfig()
    {
        return $this->node_config;
    }

    /**
     * Parameters used in creating the cluster's nodes.
     * See `nodeConfig` for the description of its properties.
     * For requests, this field should only be used in lieu of a
     * "node_pool" object, since this configuration (along with the
     * "initial_node_count") will be used to create a "NodePool" object with an
     * auto-generated name. Do not use this and a node_pool at the same time.
     * For responses, this field will be populated with the node configuration of
     * the first node pool.
     * If unspecified, the defaults are used.
     *
     * Generated from protobuf field <code>.google.container.v1beta1.NodeConfig node_config = 4;</code>
     * @param \Google\Cloud\Container\V1beta1\NodeConfig $var
     * @return $this
     */
    public function setNodeConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1beta1\NodeConfig::class);
        $this->node_config = $var;

        return $this;
    }

    /**
     * The authentication information for accessing the master endpoint.
     *
     * Generated from protobuf field <code>.google.container.v1beta1.MasterAuth master_auth = 5;</code>
     * @return \Google\Cloud\Container\V1beta1\MasterAuth
     */
    public function getMasterAuth()
    {
        return $this->master_auth;
    }

    /**
     * The authentication information for accessing the master endpoint.
     *
     * Generated from protobuf field <code>.google.container.v1beta1.MasterAuth master_auth = 5;</code>
     * @param \Google\Cloud\Container\V1beta1\MasterAuth $var
     * @return $this
     */
    public function setMasterAuth($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1beta1\MasterAuth::class);
        $this->master_auth = $var;

        return $this;
    }

    /**
     * The logging service the cluster should use to write logs.
     * Currently available options:
     * * `logging.googleapis.com` - the Google Cloud Logging service.
     * * `none` - no logs will be exported from the cluster.
     * * if left as an empty string,`logging.googleapis.com` will be used.
     *
     * Generated from protobuf field <code>string logging_service = 6;</code>
     * @return string
     */
    public function getLoggingService()
    {
        return $this->logging_service;
    }

    /**
     * The logging service the cluster should use to write logs.
     * Currently available options:
     * * `logging.googleapis.com` - the Google Cloud Logging service.
     * * `none` - no logs will be exported from the cluster.
     * * if left as an empty string,`logging.googleapis.com` will be used.
     *
     * Generated from protobuf field <code>string logging_service = 6;</code>
     * @param string $var
     * @return $this
     */
    public function setLoggingService($var)
    {
        GPBUtil::checkString($var, True);
        $this->logging_service = $var;

        return $this;
    }

    /**
     * The monitoring service the cluster should use to write metrics.
     * Currently available options:
     * * `monitoring.googleapis.com` - the Google Cloud Monitoring service.
     * * `none` - no metrics will be exported from the cluster.
     * * if left as an empty string, `monitoring.googleapis.com` will be used.
     *
     * Generated from protobuf field <code>string monitoring_service = 7;</code>
     * @return string
     */
    public function getMonitoringService()
    {
        return $this->monitoring_service;
    }

    /**
     * The monitoring service the cluster should use to write metrics.
     * Currently available options:
     * * `monitoring.googleapis.com` - the Google Cloud Monitoring service.
     * * `none` - no metrics will be exported from the cluster.
     * * if left as an empty string, `monitoring.googleapis.com` will be used.
     *
     * Generated from protobuf field <code>string monitoring_service = 7;</code>
     * @param string $var
     * @return $this
     */
    public function setMonitoringService($var)
    {
        GPBUtil::checkString($var, True);
        $this->monitoring_service = $var;

        return $this;
    }

    /**
     * The name of the Google Compute Engine
     * [network](/compute/docs/networks-and-firewalls#networks) to which the
     * cluster is connected. If left unspecified, the `default` network
     * will be used.
     *
     * Generated from protobuf field <code>string network = 8;</code>
     * @return string
     */
    public function getNetwork()
    {
        return $this->network;
    }

    /**
     * The name of the Google Compute Engine
     * [network](/compute/docs/networks-and-firewalls#networks) to which the
     * cluster is connected. If left unspecified, the `default` network
     * will be used.
     *
     * Generated from protobuf field <code>string network = 8;</code>
     * @param string $var
     * @return $this
     */
    public function setNetwork($var)
    {
        GPBUtil::checkString($var, True);
        $this->network = $var;

        return $this;
    }

    /**
     * The IP address range of the container pods in this cluster, in
     * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `10.96.0.0/14`). Leave blank to have
     * one automatically chosen or specify a `/14` block in `10.0.0.0/8`.
     *
     * Generated from protobuf field <code>string cluster_ipv4_cidr = 9;</code>
     * @return string
     */
    public function getClusterIpv4Cidr()
    {
        return $this->cluster_ipv4_cidr;
    }

    /**
     * The IP address range of the container pods in this cluster, in
     * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `10.96.0.0/14`). Leave blank to have
     * one automatically chosen or specify a `/14` block in `10.0.0.0/8`.
     *
     * Generated from protobuf field <code>string cluster_ipv4_cidr = 9;</code>
     * @param string $var
     * @return $this
     */
    public function setClusterIpv4Cidr($var)
    {
        GPBUtil::checkString($var, True);
        $this->cluster_ipv4_cidr = $var;

        return $this;
    }

    /**
     * Configurations for the various addons available to run in the cluster.
     *
     * Generated from protobuf field <code>.google.container.v1beta1.AddonsConfig addons_config = 10;</code>
     * @return \Google\Cloud\Container\V1beta1\AddonsConfig
     */
    public function getAddonsConfig()
    {
        return $this->addons_config;
    }

    /**
     * Configurations for the various addons available to run in the cluster.
     *
     * Generated from protobuf field <code>.google.container.v1beta1.AddonsConfig addons_config = 10;</code>
     * @param \Google\Cloud\Container\V1beta1\AddonsConfig $var
     * @return $this
     */
    public function setAddonsConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1beta1\AddonsConfig::class);
        $this->addons_config = $var;

        return $this;
    }

    /**
     * The name of the Google Compute Engine
     * [subnetwork](/compute/docs/subnetworks) to which the
     * cluster is connected.
     *
     * Generated from protobuf field <code>string subnetwork = 11;</code>
     * @return string
     */
    public function getSubnetwork()
    {
        return $this->subnetwork;
    }

    /**
     * The name of the Google Compute Engine
     * [subnetwork](/compute/docs/subnetworks) to which the
     * cluster is connected.
     *
     * Generated from protobuf field <code>string subnetwork = 11;</code>
     * @param string $var
     * @return $this
     */
    public function setSubnetwork($var)
    {
        GPBUtil::checkString($var, True);
        $this->subnetwork = $var;

        return $this;
    }

    /**
     * The node pools associated with this cluster.
     * This field should not be set if "node_config" or "initial_node_count" are
     * specified.
     *
     * Generated from protobuf field <code>repeated .google.container.v1beta1.NodePool node_pools = 12;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getNodePools()
    {
        return $this->node_pools;
    }

    /**
     * The node pools associated with this cluster.
     * This field should not be set if "node_config" or "initial_node_count" are
     * specified.
     *
     * Generated from protobuf field <code>repeated .google.container.v1beta1.NodePool node_pools = 12;</code>
     * @param \Google\Cloud\Container\V1beta1\NodePool[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setNodePools($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Container\V1beta1\NodePool::class);
        $this->node_pools = $arr;

        return $this;
    }

    /**
     * The list of Google Compute Engine
     * [locations](/compute/docs/zones#available) in which the cluster's nodes
     * should be located.
     *
     * Generated from protobuf field <code>repeated string locations = 13;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getLocations()
    {
        return $this->locations;
    }

    /**
     * The list of Google Compute Engine
     * [locations](/compute/docs/zones#available) in which the cluster's nodes
     * should be located.
     *
     * Generated from protobuf field <code>repeated string locations = 13;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setLocations($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->locations = $arr;

        return $this;
    }

    /**
     * Kubernetes alpha features are enabled on this cluster. This includes alpha
     * API groups (e.g. v1beta1) and features that may not be production ready in
     * the kubernetes version of the master and nodes.
     * The cluster has no SLA for uptime and master/node upgrades are disabled.
     * Alpha enabled clusters are automatically deleted thirty days after
     * creation.
     *
     * Generated from protobuf field <code>bool enable_kubernetes_alpha = 14;</code>
     * @return bool
     */
    public function getEnableKubernetesAlpha()
    {
        return $this->enable_kubernetes_alpha;
    }

    /**
     * Kubernetes alpha features are enabled on this cluster. This includes alpha
     * API groups (e.g. v1beta1) and features that may not be production ready in
     * the kubernetes version of the master and nodes.
     * The cluster has no SLA for uptime and master/node upgrades are disabled.
     * Alpha enabled clusters are automatically deleted thirty days after
     * creation.
     *
     * Generated from protobuf field <code>bool enable_kubernetes_alpha = 14;</code>
     * @param bool $var
     * @return $this
     */
    public function setEnableKubernetesAlpha($var)
    {
        GPBUtil::checkBool($var);
        $this->enable_kubernetes_alpha = $var;

        return $this;
    }

    /**
     * Configuration options for the NetworkPolicy feature.
     *
     * Generated from protobuf field <code>.google.container.v1beta1.NetworkPolicy network_policy = 19;</code>
     * @return \Google\Cloud\Container\V1beta1\NetworkPolicy
     */
    public function getNetworkPolicy()
    {
        return $this->network_policy;
    }

    /**
     * Configuration options for the NetworkPolicy feature.
     *
     * Generated from protobuf field <code>.google.container.v1beta1.NetworkPolicy network_policy = 19;</code>
     * @param \Google\Cloud\Container\V1beta1\NetworkPolicy $var
     * @return $this
     */
    public function setNetworkPolicy($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1beta1\NetworkPolicy::class);
        $this->network_policy = $var;

        return $this;
    }

    /**
     * Configuration for cluster IP allocation.
     *
     * Generated from protobuf field <code>.google.container.v1beta1.IPAllocationPolicy ip_allocation_policy = 20;</code>
     * @return \Google\Cloud\Container\V1beta1\IPAllocationPolicy
     */
    public function getIpAllocationPolicy()
    {
        return $this->ip_allocation_policy;
    }

    /**
     * Configuration for cluster IP allocation.
     *
     * Generated from protobuf field <code>.google.container.v1beta1.IPAllocationPolicy ip_allocation_policy = 20;</code>
     * @param \Google\Cloud\Container\V1beta1\IPAllocationPolicy $var
     * @return $this
     */
    public function setIpAllocationPolicy($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1beta1\IPAllocationPolicy::class);
        $this->ip_allocation_policy = $var;

        return $this;
    }

    /**
     * The configuration options for master authorized networks feature.
     *
     * Generated from protobuf field <code>.google.container.v1beta1.MasterAuthorizedNetworksConfig master_authorized_networks_config = 22;</code>
     * @return \Google\Cloud\Container\V1beta1\MasterAuthorizedNetworksConfig
     */
    public function getMasterAuthorizedNetworksConfig()
    {
        return $this->master_authorized_networks_config;
    }

    /**
     * The configuration options for master authorized networks feature.
     *
     * Generated from protobuf field <code>.google.container.v1beta1.MasterAuthorizedNetworksConfig master_authorized_networks_config = 22;</code>
     * @param \Google\Cloud\Container\V1beta1\MasterAuthorizedNetworksConfig $var
     * @return $this
     */
    public function setMasterAuthorizedNetworksConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1beta1\MasterAuthorizedNetworksConfig::class);
        $this->master_authorized_networks_config = $var;

        return $this;
    }

    /**
     * Configure the maintenance policy for this cluster.
     *
     * Generated from protobuf field <code>.google.container.v1beta1.MaintenancePolicy maintenance_policy = 23;</code>
     * @return \Google\Cloud\Container\V1beta1\MaintenancePolicy
     */
    public function getMaintenancePolicy()
    {
        return $this->maintenance_policy;
    }

    /**
     * Configure the maintenance policy for this cluster.
     *
     * Generated from protobuf field <code>.google.container.v1beta1.MaintenancePolicy maintenance_policy = 23;</code>
     * @param \Google\Cloud\Container\V1beta1\MaintenancePolicy $var
     * @return $this
     */
    public function setMaintenancePolicy($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1beta1\MaintenancePolicy::class);
        $this->maintenance_policy = $var;

        return $this;
    }

    /**
     * Configuration for the PodSecurityPolicy feature.
     *
     * Generated from protobuf field <code>.google.container.v1beta1.PodSecurityPolicyConfig pod_security_policy_config = 25;</code>
     * @return \Google\Cloud\Container\V1beta1\PodSecurityPolicyConfig
     */
    public function getPodSecurityPolicyConfig()
    {
        return $this->pod_security_policy_config;
    }

    /**
     * Configuration for the PodSecurityPolicy feature.
     *
     * Generated from protobuf field <code>.google.container.v1beta1.PodSecurityPolicyConfig pod_security_policy_config = 25;</code>
     * @param \Google\Cloud\Container\V1beta1\PodSecurityPolicyConfig $var
     * @return $this
     */
    public function setPodSecurityPolicyConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1beta1\PodSecurityPolicyConfig::class);
        $this->pod_security_policy_config = $var;

        return $this;
    }

    /**
     * [Output only] Server-defined URL for the resource.
     *
     * Generated from protobuf field <code>string self_link = 100;</code>
     * @return string
     */
    public function getSelfLink()
    {
        return $this->self_link;
    }

    /**
     * [Output only] Server-defined URL for the resource.
     *
     * Generated from protobuf field <code>string self_link = 100;</code>
     * @param string $var
     * @return $this
     */
    public function setSelfLink($var)
    {
        GPBUtil::checkString($var, True);
        $this->self_link = $var;

        return $this;
    }

    /**
     * [Output only] The name of the Google Compute Engine
     * [zone](/compute/docs/zones#available) in which the cluster
     * resides.
     * This field is deprecated, use location instead.
     *
     * Generated from protobuf field <code>string zone = 101;</code>
     * @return string
     */
    public function getZone()
    {
        return $this->zone;
    }

    /**
     * [Output only] The name of the Google Compute Engine
     * [zone](/compute/docs/zones#available) in which the cluster
     * resides.
     * This field is deprecated, use location instead.
     *
     * Generated from protobuf field <code>string zone = 101;</code>
     * @param string $var
     * @return $this
     */
    public function setZone($var)
    {
        GPBUtil::checkString($var, True);
        $this->zone = $var;

        return $this;
    }

    /**
     * [Output only] The IP address of this cluster's master endpoint.
     * The endpoint can be accessed from the internet at
     * `https://username:password&#64;endpoint/`.
     * See the `masterAuth` property of this resource for username and
     * password information.
     *
     * Generated from protobuf field <code>string endpoint = 102;</code>
     * @return string
     */
    public function getEndpoint()
    {
        return $this->endpoint;
    }

    /**
     * [Output only] The IP address of this cluster's master endpoint.
     * The endpoint can be accessed from the internet at
     * `https://username:password&#64;endpoint/`.
     * See the `masterAuth` property of this resource for username and
     * password information.
     *
     * Generated from protobuf field <code>string endpoint = 102;</code>
     * @param string $var
     * @return $this
     */
    public function setEndpoint($var)
    {
        GPBUtil::checkString($var, True);
        $this->endpoint = $var;

        return $this;
    }

    /**
     * The initial Kubernetes version for this cluster.  Valid versions are those
     * found in validMasterVersions returned by getServerConfig.  The version can
     * be upgraded over time; such upgrades are reflected in
     * currentMasterVersion and currentNodeVersion.
     *
     * Generated from protobuf field <code>string initial_cluster_version = 103;</code>
     * @return string
     */
    public function getInitialClusterVersion()
    {
        return $this->initial_cluster_version;
    }

    /**
     * The initial Kubernetes version for this cluster.  Valid versions are those
     * found in validMasterVersions returned by getServerConfig.  The version can
     * be upgraded over time; such upgrades are reflected in
     * currentMasterVersion and currentNodeVersion.
     *
     * Generated from protobuf field <code>string initial_cluster_version = 103;</code>
     * @param string $var
     * @return $this
     */
    public function setInitialClusterVersion($var)
    {
        GPBUtil::checkString($var, True);
        $this->initial_cluster_version = $var;

        return $this;
    }

    /**
     * [Output only] The current software version of the master endpoint.
     *
     * Generated from protobuf field <code>string current_master_version = 104;</code>
     * @return string
     */
    public function getCurrentMasterVersion()
    {
        return $this->current_master_version;
    }

    /**
     * [Output only] The current software version of the master endpoint.
     *
     * Generated from protobuf field <code>string current_master_version = 104;</code>
     * @param string $var
     * @return $this
     */
    public function setCurrentMasterVersion($var)
    {
        GPBUtil::checkString($var, True);
        $this->current_master_version = $var;

        return $this;
    }

    /**
     * [Output only] The current version of the node software components.
     * If they are currently at multiple versions because they're in the process
     * of being upgraded, this reflects the minimum version of all nodes.
     *
     * Generated from protobuf field <code>string current_node_version = 105;</code>
     * @return string
     */
    public function getCurrentNodeVersion()
    {
        return $this->current_node_version;
    }

    /**
     * [Output only] The current version of the node software components.
     * If they are currently at multiple versions because they're in the process
     * of being upgraded, this reflects the minimum version of all nodes.
     *
     * Generated from protobuf field <code>string current_node_version = 105;</code>
     * @param string $var
     * @return $this
     */
    public function setCurrentNodeVersion($var)
    {
        GPBUtil::checkString($var, True);
        $this->current_node_version = $var;

        return $this;
    }

    /**
     * [Output only] The time the cluster was created, in
     * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
     *
     * Generated from protobuf field <code>string create_time = 106;</code>
     * @return string
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    /**
     * [Output only] The time the cluster was created, in
     * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
     *
     * Generated from protobuf field <code>string create_time = 106;</code>
     * @param string $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkString($var, True);
        $this->create_time = $var;

        return $this;
    }

    /**
     * [Output only] The current status of this cluster.
     *
     * Generated from protobuf field <code>.google.container.v1beta1.Cluster.Status status = 107;</code>
     * @return int
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * [Output only] The current status of this cluster.
     *
     * Generated from protobuf field <code>.google.container.v1beta1.Cluster.Status status = 107;</code>
     * @param int $var
     * @return $this
     */
    public function setStatus($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Container\V1beta1\Cluster_Status::class);
        $this->status = $var;

        return $this;
    }

    /**
     * [Output only] Additional information about the current status of this
     * cluster, if available.
     *
     * Generated from protobuf field <code>string status_message = 108;</code>
     * @return string
     */
    public function getStatusMessage()
    {
        return $this->status_message;
    }

    /**
     * [Output only] Additional information about the current status of this
     * cluster, if available.
     *
     * Generated from protobuf field <code>string status_message = 108;</code>
     * @param string $var
     * @return $this
     */
    public function setStatusMessage($var)
    {
        GPBUtil::checkString($var, True);
        $this->status_message = $var;

        return $this;
    }

    /**
     * [Output only] The size of the address space on each node for hosting
     * containers. This is provisioned from within the `container_ipv4_cidr`
     * range.
     *
     * Generated from protobuf field <code>int32 node_ipv4_cidr_size = 109;</code>
     * @return int
     */
    public function getNodeIpv4CidrSize()
    {
        return $this->node_ipv4_cidr_size;
    }

    /**
     * [Output only] The size of the address space on each node for hosting
     * containers. This is provisioned from within the `container_ipv4_cidr`
     * range.
     *
     * Generated from protobuf field <code>int32 node_ipv4_cidr_size = 109;</code>
     * @param int $var
     * @return $this
     */
    public function setNodeIpv4CidrSize($var)
    {
        GPBUtil::checkInt32($var);
        $this->node_ipv4_cidr_size = $var;

        return $this;
    }

    /**
     * [Output only] The IP address range of the Kubernetes services in
     * this cluster, in
     * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `1.2.3.4/29`). Service addresses are
     * typically put in the last `/16` from the container CIDR.
     *
     * Generated from protobuf field <code>string services_ipv4_cidr = 110;</code>
     * @return string
     */
    public function getServicesIpv4Cidr()
    {
        return $this->services_ipv4_cidr;
    }

    /**
     * [Output only] The IP address range of the Kubernetes services in
     * this cluster, in
     * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `1.2.3.4/29`). Service addresses are
     * typically put in the last `/16` from the container CIDR.
     *
     * Generated from protobuf field <code>string services_ipv4_cidr = 110;</code>
     * @param string $var
     * @return $this
     */
    public function setServicesIpv4Cidr($var)
    {
        GPBUtil::checkString($var, True);
        $this->services_ipv4_cidr = $var;

        return $this;
    }

    /**
     * [Output only] The resource URLs of [instance
     * groups](/compute/docs/instance-groups/) associated with this
     * cluster.
     *
     * Generated from protobuf field <code>repeated string instance_group_urls = 111;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getInstanceGroupUrls()
    {
        return $this->instance_group_urls;
    }

    /**
     * [Output only] The resource URLs of [instance
     * groups](/compute/docs/instance-groups/) associated with this
     * cluster.
     *
     * Generated from protobuf field <code>repeated string instance_group_urls = 111;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setInstanceGroupUrls($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->instance_group_urls = $arr;

        return $this;
    }

    /**
     * [Output only] The number of nodes currently in the cluster.
     *
     * Generated from protobuf field <code>int32 current_node_count = 112;</code>
     * @return int
     */
    public function getCurrentNodeCount()
    {
        return $this->current_node_count;
    }

    /**
     * [Output only] The number of nodes currently in the cluster.
     *
     * Generated from protobuf field <code>int32 current_node_count = 112;</code>
     * @param int $var
     * @return $this
     */
    public function setCurrentNodeCount($var)
    {
        GPBUtil::checkInt32($var);
        $this->current_node_count = $var;

        return $this;
    }

    /**
     * [Output only] The time the cluster will be automatically
     * deleted in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
     *
     * Generated from protobuf field <code>string expire_time = 113;</code>
     * @return string
     */
    public function getExpireTime()
    {
        return $this->expire_time;
    }

    /**
     * [Output only] The time the cluster will be automatically
     * deleted in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
     *
     * Generated from protobuf field <code>string expire_time = 113;</code>
     * @param string $var
     * @return $this
     */
    public function setExpireTime($var)
    {
        GPBUtil::checkString($var, True);
        $this->expire_time = $var;

        return $this;
    }

    /**
     * [Output only] The name of the Google Compute Engine
     * [zone](/compute/docs/regions-zones/regions-zones#available) or
     * [region](/compute/docs/regions-zones/regions-zones#available) in which
     * the cluster resides.
     *
     * Generated from protobuf field <code>string location = 114;</code>
     * @return string
     */
    public function getLocation()
    {
        return $this->location;
    }

    /**
     * [Output only] The name of the Google Compute Engine
     * [zone](/compute/docs/regions-zones/regions-zones#available) or
     * [region](/compute/docs/regions-zones/regions-zones#available) in which
     * the cluster resides.
     *
     * Generated from protobuf field <code>string location = 114;</code>
     * @param string $var
     * @return $this
     */
    public function setLocation($var)
    {
        GPBUtil::checkString($var, True);
        $this->location = $var;

        return $this;
    }

}

