<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/runtimeconfig/v1beta1/resources.proto

namespace Google\Cloud\RuntimeConfig\V1beta1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Describes a single variable within a RuntimeConfig resource.
 * The name denotes the hierarchical variable name. For example,
 * `ports/serving_port` is a valid variable name. The variable value is an
 * opaque string and only leaf variables can have values (that is, variables
 * that do not have any child variables).
 *
 * Generated from protobuf message <code>google.cloud.runtimeconfig.v1beta1.Variable</code>
 */
class Variable extends \Google\Protobuf\Internal\Message
{
    /**
     * The name of the variable resource, in the format:
     *     projects/[PROJECT_ID]/configs/[CONFIG_NAME]/variables/[VARIABLE_NAME]
     * The `[PROJECT_ID]` must be a valid project ID, `[CONFIG_NAME]` must be a
     * valid RuntimeConfig reource and `[VARIABLE_NAME]` follows Unix file system
     * file path naming.
     * The `[VARIABLE_NAME]` can contain ASCII letters, numbers, slashes and
     * dashes. Slashes are used as path element separators and are not part of the
     * `[VARIABLE_NAME]` itself, so `[VARIABLE_NAME]` must contain at least one
     * non-slash character. Multiple slashes are coalesced into single slash
     * character. Each path segment should follow RFC 1035 segment specification.
     * The length of a `[VARIABLE_NAME]` must be less than 256 bytes.
     * Once you create a variable, you cannot change the variable name.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    private $name = '';
    /**
     * [Output Only] The time of the last variable update.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3;</code>
     */
    private $update_time = null;
    /**
     * [Ouput only] The current state of the variable. The variable state indicates
     * the outcome of the `variables().watch` call and is visible through the
     * `get` and `list` calls.
     *
     * Generated from protobuf field <code>.google.cloud.runtimeconfig.v1beta1.VariableState state = 4;</code>
     */
    private $state = 0;
    protected $contents;

    public function __construct() {
        \GPBMetadata\Google\Cloud\Runtimeconfig\V1Beta1\Resources::initOnce();
        parent::__construct();
    }

    /**
     * The name of the variable resource, in the format:
     *     projects/[PROJECT_ID]/configs/[CONFIG_NAME]/variables/[VARIABLE_NAME]
     * The `[PROJECT_ID]` must be a valid project ID, `[CONFIG_NAME]` must be a
     * valid RuntimeConfig reource and `[VARIABLE_NAME]` follows Unix file system
     * file path naming.
     * The `[VARIABLE_NAME]` can contain ASCII letters, numbers, slashes and
     * dashes. Slashes are used as path element separators and are not part of the
     * `[VARIABLE_NAME]` itself, so `[VARIABLE_NAME]` must contain at least one
     * non-slash character. Multiple slashes are coalesced into single slash
     * character. Each path segment should follow RFC 1035 segment specification.
     * The length of a `[VARIABLE_NAME]` must be less than 256 bytes.
     * Once you create a variable, you cannot change the variable name.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * The name of the variable resource, in the format:
     *     projects/[PROJECT_ID]/configs/[CONFIG_NAME]/variables/[VARIABLE_NAME]
     * The `[PROJECT_ID]` must be a valid project ID, `[CONFIG_NAME]` must be a
     * valid RuntimeConfig reource and `[VARIABLE_NAME]` follows Unix file system
     * file path naming.
     * The `[VARIABLE_NAME]` can contain ASCII letters, numbers, slashes and
     * dashes. Slashes are used as path element separators and are not part of the
     * `[VARIABLE_NAME]` itself, so `[VARIABLE_NAME]` must contain at least one
     * non-slash character. Multiple slashes are coalesced into single slash
     * character. Each path segment should follow RFC 1035 segment specification.
     * The length of a `[VARIABLE_NAME]` must be less than 256 bytes.
     * Once you create a variable, you cannot change the variable name.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * The binary value of the variable. The length of the value must be less
     * than 4096 bytes. Empty values are also accepted. The value must be
     * base64 encoded. Only one of `value` or `text` can be set.
     *
     * Generated from protobuf field <code>bytes value = 2;</code>
     * @return string
     */
    public function getValue()
    {
        return $this->readOneof(2);
    }

    /**
     * The binary value of the variable. The length of the value must be less
     * than 4096 bytes. Empty values are also accepted. The value must be
     * base64 encoded. Only one of `value` or `text` can be set.
     *
     * Generated from protobuf field <code>bytes value = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setValue($var)
    {
        GPBUtil::checkString($var, False);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * The string value of the variable. The length of the value must be less
     * than 4096 bytes. Empty values are also accepted. For example,
     * `text: "my text value"`. The string must be valid UTF-8.
     *
     * Generated from protobuf field <code>string text = 5;</code>
     * @return string
     */
    public function getText()
    {
        return $this->readOneof(5);
    }

    /**
     * The string value of the variable. The length of the value must be less
     * than 4096 bytes. Empty values are also accepted. For example,
     * `text: "my text value"`. The string must be valid UTF-8.
     *
     * Generated from protobuf field <code>string text = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setText($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(5, $var);

        return $this;
    }

    /**
     * [Output Only] The time of the last variable update.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3;</code>
     * @return \Google\Protobuf\Timestamp
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    /**
     * [Output Only] The time of the last variable update.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * [Ouput only] The current state of the variable. The variable state indicates
     * the outcome of the `variables().watch` call and is visible through the
     * `get` and `list` calls.
     *
     * Generated from protobuf field <code>.google.cloud.runtimeconfig.v1beta1.VariableState state = 4;</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * [Ouput only] The current state of the variable. The variable state indicates
     * the outcome of the `variables().watch` call and is visible through the
     * `get` and `list` calls.
     *
     * Generated from protobuf field <code>.google.cloud.runtimeconfig.v1beta1.VariableState state = 4;</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\RuntimeConfig\V1beta1\VariableState::class);
        $this->state = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getContents()
    {
        return $this->whichOneof("contents");
    }

}

