<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/runtimeconfig/v1beta1/resources.proto

namespace Google\Cloud\RuntimeConfig\V1beta1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A Waiter resource waits for some end condition within a RuntimeConfig resource
 * to be met before it returns. For example, assume you have a distributed
 * system where each node writes to a Variable resource indidicating the node's
 * readiness as part of the startup process.
 * You then configure a Waiter resource with the success condition set to wait
 * until some number of nodes have checked in. Afterwards, your application
 * runs some arbitrary code after the condition has been met and the waiter
 * returns successfully.
 * Once created, a Waiter resource is immutable.
 * To learn more about using waiters, read the
 * [Creating a Waiter](/deployment-manager/runtime-configurator/creating-a-waiter)
 * documentation.
 *
 * Generated from protobuf message <code>google.cloud.runtimeconfig.v1beta1.Waiter</code>
 */
class Waiter extends \Google\Protobuf\Internal\Message
{
    /**
     * The name of the Waiter resource, in the format:
     *     projects/[PROJECT_ID]/configs/[CONFIG_NAME]/waiters/[WAITER_NAME]
     * The `[PROJECT_ID]` must be a valid Google Cloud project ID,
     * the `[CONFIG_NAME]` must be a valid RuntimeConfig resource, the
     * `[WAITER_NAME]` must match RFC 1035 segment specification, and the length
     * of `[WAITER_NAME]` must be less than 64 bytes.
     * After you create a Waiter resource, you cannot change the resource name.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    private $name = '';
    /**
     * [Required] Specifies the timeout of the waiter in seconds, beginning from
     * the instant that `waiters().create` method is called. If this time elapses
     * before the success or failure conditions are met, the waiter fails and sets
     * the `error` code to `DEADLINE_EXCEEDED`.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration timeout = 2;</code>
     */
    private $timeout = null;
    /**
     * [Optional] The failure condition of this waiter. If this condition is met,
     * `done` will be set to `true` and the `error` code will be set to `ABORTED`.
     * The failure condition takes precedence over the success condition. If both
     * conditions are met, a failure will be indicated. This value is optional; if
     * no failure condition is set, the only failure scenario will be a timeout.
     *
     * Generated from protobuf field <code>.google.cloud.runtimeconfig.v1beta1.EndCondition failure = 3;</code>
     */
    private $failure = null;
    /**
     * [Required] The success condition. If this condition is met, `done` will be
     * set to `true` and the `error` value will remain unset. The failure condition
     * takes precedence over the success condition. If both conditions are met, a
     * failure will be indicated.
     *
     * Generated from protobuf field <code>.google.cloud.runtimeconfig.v1beta1.EndCondition success = 4;</code>
     */
    private $success = null;
    /**
     * [Output Only] The instant at which this Waiter resource was created. Adding
     * the value of `timeout` to this instant yields the timeout deadline for the
     * waiter.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 5;</code>
     */
    private $create_time = null;
    /**
     * [Output Only] If the value is `false`, it means the waiter is still waiting
     * for one of its conditions to be met.
     * If true, the waiter has finished. If the waiter finished due to a timeout
     * or failure, `error` will be set.
     *
     * Generated from protobuf field <code>bool done = 6;</code>
     */
    private $done = false;
    /**
     * [Output Only] If the waiter ended due to a failure or timeout, this value
     * will be set.
     *
     * Generated from protobuf field <code>.google.rpc.Status error = 7;</code>
     */
    private $error = null;

    public function __construct() {
        \GPBMetadata\Google\Cloud\Runtimeconfig\V1Beta1\Resources::initOnce();
        parent::__construct();
    }

    /**
     * The name of the Waiter resource, in the format:
     *     projects/[PROJECT_ID]/configs/[CONFIG_NAME]/waiters/[WAITER_NAME]
     * The `[PROJECT_ID]` must be a valid Google Cloud project ID,
     * the `[CONFIG_NAME]` must be a valid RuntimeConfig resource, the
     * `[WAITER_NAME]` must match RFC 1035 segment specification, and the length
     * of `[WAITER_NAME]` must be less than 64 bytes.
     * After you create a Waiter resource, you cannot change the resource name.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * The name of the Waiter resource, in the format:
     *     projects/[PROJECT_ID]/configs/[CONFIG_NAME]/waiters/[WAITER_NAME]
     * The `[PROJECT_ID]` must be a valid Google Cloud project ID,
     * the `[CONFIG_NAME]` must be a valid RuntimeConfig resource, the
     * `[WAITER_NAME]` must match RFC 1035 segment specification, and the length
     * of `[WAITER_NAME]` must be less than 64 bytes.
     * After you create a Waiter resource, you cannot change the resource name.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * [Required] Specifies the timeout of the waiter in seconds, beginning from
     * the instant that `waiters().create` method is called. If this time elapses
     * before the success or failure conditions are met, the waiter fails and sets
     * the `error` code to `DEADLINE_EXCEEDED`.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration timeout = 2;</code>
     * @return \Google\Protobuf\Duration
     */
    public function getTimeout()
    {
        return $this->timeout;
    }

    /**
     * [Required] Specifies the timeout of the waiter in seconds, beginning from
     * the instant that `waiters().create` method is called. If this time elapses
     * before the success or failure conditions are met, the waiter fails and sets
     * the `error` code to `DEADLINE_EXCEEDED`.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration timeout = 2;</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setTimeout($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->timeout = $var;

        return $this;
    }

    /**
     * [Optional] The failure condition of this waiter. If this condition is met,
     * `done` will be set to `true` and the `error` code will be set to `ABORTED`.
     * The failure condition takes precedence over the success condition. If both
     * conditions are met, a failure will be indicated. This value is optional; if
     * no failure condition is set, the only failure scenario will be a timeout.
     *
     * Generated from protobuf field <code>.google.cloud.runtimeconfig.v1beta1.EndCondition failure = 3;</code>
     * @return \Google\Cloud\RuntimeConfig\V1beta1\EndCondition
     */
    public function getFailure()
    {
        return $this->failure;
    }

    /**
     * [Optional] The failure condition of this waiter. If this condition is met,
     * `done` will be set to `true` and the `error` code will be set to `ABORTED`.
     * The failure condition takes precedence over the success condition. If both
     * conditions are met, a failure will be indicated. This value is optional; if
     * no failure condition is set, the only failure scenario will be a timeout.
     *
     * Generated from protobuf field <code>.google.cloud.runtimeconfig.v1beta1.EndCondition failure = 3;</code>
     * @param \Google\Cloud\RuntimeConfig\V1beta1\EndCondition $var
     * @return $this
     */
    public function setFailure($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\RuntimeConfig\V1beta1\EndCondition::class);
        $this->failure = $var;

        return $this;
    }

    /**
     * [Required] The success condition. If this condition is met, `done` will be
     * set to `true` and the `error` value will remain unset. The failure condition
     * takes precedence over the success condition. If both conditions are met, a
     * failure will be indicated.
     *
     * Generated from protobuf field <code>.google.cloud.runtimeconfig.v1beta1.EndCondition success = 4;</code>
     * @return \Google\Cloud\RuntimeConfig\V1beta1\EndCondition
     */
    public function getSuccess()
    {
        return $this->success;
    }

    /**
     * [Required] The success condition. If this condition is met, `done` will be
     * set to `true` and the `error` value will remain unset. The failure condition
     * takes precedence over the success condition. If both conditions are met, a
     * failure will be indicated.
     *
     * Generated from protobuf field <code>.google.cloud.runtimeconfig.v1beta1.EndCondition success = 4;</code>
     * @param \Google\Cloud\RuntimeConfig\V1beta1\EndCondition $var
     * @return $this
     */
    public function setSuccess($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\RuntimeConfig\V1beta1\EndCondition::class);
        $this->success = $var;

        return $this;
    }

    /**
     * [Output Only] The instant at which this Waiter resource was created. Adding
     * the value of `timeout` to this instant yields the timeout deadline for the
     * waiter.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 5;</code>
     * @return \Google\Protobuf\Timestamp
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    /**
     * [Output Only] The instant at which this Waiter resource was created. Adding
     * the value of `timeout` to this instant yields the timeout deadline for the
     * waiter.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 5;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * [Output Only] If the value is `false`, it means the waiter is still waiting
     * for one of its conditions to be met.
     * If true, the waiter has finished. If the waiter finished due to a timeout
     * or failure, `error` will be set.
     *
     * Generated from protobuf field <code>bool done = 6;</code>
     * @return bool
     */
    public function getDone()
    {
        return $this->done;
    }

    /**
     * [Output Only] If the value is `false`, it means the waiter is still waiting
     * for one of its conditions to be met.
     * If true, the waiter has finished. If the waiter finished due to a timeout
     * or failure, `error` will be set.
     *
     * Generated from protobuf field <code>bool done = 6;</code>
     * @param bool $var
     * @return $this
     */
    public function setDone($var)
    {
        GPBUtil::checkBool($var);
        $this->done = $var;

        return $this;
    }

    /**
     * [Output Only] If the waiter ended due to a failure or timeout, this value
     * will be set.
     *
     * Generated from protobuf field <code>.google.rpc.Status error = 7;</code>
     * @return \Google\Rpc\Status
     */
    public function getError()
    {
        return $this->error;
    }

    /**
     * [Output Only] If the waiter ended due to a failure or timeout, this value
     * will be set.
     *
     * Generated from protobuf field <code>.google.rpc.Status error = 7;</code>
     * @param \Google\Rpc\Status $var
     * @return $this
     */
    public function setError($var)
    {
        GPBUtil::checkMessage($var, \Google\Rpc\Status::class);
        $this->error = $var;

        return $this;
    }

}

