<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/storagetransfer/v1/transfer_types.proto

namespace Google\Cloud\StorageTransfer\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * This resource represents the configuration of a transfer job that runs
 * periodically.
 *
 * Generated from protobuf message <code>google.storagetransfer.v1.TransferJob</code>
 */
class TransferJob extends \Google\Protobuf\Internal\Message
{
    /**
     * A globally unique name assigned by Storage Transfer Service when the
     * job is created. This field should be left empty in requests to create a new
     * transfer job; otherwise, the requests result in an `INVALID_ARGUMENT`
     * error.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    private $name = '';
    /**
     * A description provided by the user for the job. Its max length is 1024
     * bytes when Unicode-encoded.
     *
     * Generated from protobuf field <code>string description = 2;</code>
     */
    private $description = '';
    /**
     * The ID of the Google Cloud Platform Console project that owns the job.
     *
     * Generated from protobuf field <code>string project_id = 3;</code>
     */
    private $project_id = '';
    /**
     * Transfer specification.
     *
     * Generated from protobuf field <code>.google.storagetransfer.v1.TransferSpec transfer_spec = 4;</code>
     */
    private $transfer_spec = null;
    /**
     * Schedule specification.
     *
     * Generated from protobuf field <code>.google.storagetransfer.v1.Schedule schedule = 5;</code>
     */
    private $schedule = null;
    /**
     * Status of the job. This value MUST be specified for
     * `CreateTransferJobRequests`.
     * NOTE: The effect of the new job status takes place during a subsequent job
     * run. For example, if you change the job status from `ENABLED` to
     * `DISABLED`, and an operation spawned by the transfer is running, the status
     * change would not affect the current operation.
     *
     * Generated from protobuf field <code>.google.storagetransfer.v1.TransferJob.Status status = 6;</code>
     */
    private $status = 0;
    /**
     * This field cannot be changed by user requests.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp creation_time = 7;</code>
     */
    private $creation_time = null;
    /**
     * This field cannot be changed by user requests.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_modification_time = 8;</code>
     */
    private $last_modification_time = null;
    /**
     * This field cannot be changed by user requests.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp deletion_time = 9;</code>
     */
    private $deletion_time = null;

    public function __construct() {
        \GPBMetadata\Google\Storagetransfer\V1\TransferTypes::initOnce();
        parent::__construct();
    }

    /**
     * A globally unique name assigned by Storage Transfer Service when the
     * job is created. This field should be left empty in requests to create a new
     * transfer job; otherwise, the requests result in an `INVALID_ARGUMENT`
     * error.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * A globally unique name assigned by Storage Transfer Service when the
     * job is created. This field should be left empty in requests to create a new
     * transfer job; otherwise, the requests result in an `INVALID_ARGUMENT`
     * error.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * A description provided by the user for the job. Its max length is 1024
     * bytes when Unicode-encoded.
     *
     * Generated from protobuf field <code>string description = 2;</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * A description provided by the user for the job. Its max length is 1024
     * bytes when Unicode-encoded.
     *
     * Generated from protobuf field <code>string description = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * The ID of the Google Cloud Platform Console project that owns the job.
     *
     * Generated from protobuf field <code>string project_id = 3;</code>
     * @return string
     */
    public function getProjectId()
    {
        return $this->project_id;
    }

    /**
     * The ID of the Google Cloud Platform Console project that owns the job.
     *
     * Generated from protobuf field <code>string project_id = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setProjectId($var)
    {
        GPBUtil::checkString($var, True);
        $this->project_id = $var;

        return $this;
    }

    /**
     * Transfer specification.
     *
     * Generated from protobuf field <code>.google.storagetransfer.v1.TransferSpec transfer_spec = 4;</code>
     * @return \Google\Cloud\StorageTransfer\V1\TransferSpec
     */
    public function getTransferSpec()
    {
        return $this->transfer_spec;
    }

    /**
     * Transfer specification.
     *
     * Generated from protobuf field <code>.google.storagetransfer.v1.TransferSpec transfer_spec = 4;</code>
     * @param \Google\Cloud\StorageTransfer\V1\TransferSpec $var
     * @return $this
     */
    public function setTransferSpec($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\StorageTransfer\V1\TransferSpec::class);
        $this->transfer_spec = $var;

        return $this;
    }

    /**
     * Schedule specification.
     *
     * Generated from protobuf field <code>.google.storagetransfer.v1.Schedule schedule = 5;</code>
     * @return \Google\Cloud\StorageTransfer\V1\Schedule
     */
    public function getSchedule()
    {
        return $this->schedule;
    }

    /**
     * Schedule specification.
     *
     * Generated from protobuf field <code>.google.storagetransfer.v1.Schedule schedule = 5;</code>
     * @param \Google\Cloud\StorageTransfer\V1\Schedule $var
     * @return $this
     */
    public function setSchedule($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\StorageTransfer\V1\Schedule::class);
        $this->schedule = $var;

        return $this;
    }

    /**
     * Status of the job. This value MUST be specified for
     * `CreateTransferJobRequests`.
     * NOTE: The effect of the new job status takes place during a subsequent job
     * run. For example, if you change the job status from `ENABLED` to
     * `DISABLED`, and an operation spawned by the transfer is running, the status
     * change would not affect the current operation.
     *
     * Generated from protobuf field <code>.google.storagetransfer.v1.TransferJob.Status status = 6;</code>
     * @return int
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * Status of the job. This value MUST be specified for
     * `CreateTransferJobRequests`.
     * NOTE: The effect of the new job status takes place during a subsequent job
     * run. For example, if you change the job status from `ENABLED` to
     * `DISABLED`, and an operation spawned by the transfer is running, the status
     * change would not affect the current operation.
     *
     * Generated from protobuf field <code>.google.storagetransfer.v1.TransferJob.Status status = 6;</code>
     * @param int $var
     * @return $this
     */
    public function setStatus($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\StorageTransfer\V1\TransferJob_Status::class);
        $this->status = $var;

        return $this;
    }

    /**
     * This field cannot be changed by user requests.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp creation_time = 7;</code>
     * @return \Google\Protobuf\Timestamp
     */
    public function getCreationTime()
    {
        return $this->creation_time;
    }

    /**
     * This field cannot be changed by user requests.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp creation_time = 7;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreationTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->creation_time = $var;

        return $this;
    }

    /**
     * This field cannot be changed by user requests.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_modification_time = 8;</code>
     * @return \Google\Protobuf\Timestamp
     */
    public function getLastModificationTime()
    {
        return $this->last_modification_time;
    }

    /**
     * This field cannot be changed by user requests.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_modification_time = 8;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setLastModificationTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->last_modification_time = $var;

        return $this;
    }

    /**
     * This field cannot be changed by user requests.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp deletion_time = 9;</code>
     * @return \Google\Protobuf\Timestamp
     */
    public function getDeletionTime()
    {
        return $this->deletion_time;
    }

    /**
     * This field cannot be changed by user requests.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp deletion_time = 9;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setDeletionTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->deletion_time = $var;

        return $this;
    }

}

