<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/devtools/remoteexecution/v1test/remote_execution.proto

namespace Google\Devtools\Remoteexecution\V1test;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * An `Action` captures all the information about an execution which is required
 * to reproduce it.
 * `Action`s are the core component of the [Execution] service. A single
 * `Action` represents a repeatable action that can be performed by the
 * execution service. `Action`s can be succinctly identified by the digest of
 * their wire format encoding and, once an `Action` has been executed, will be
 * cached in the action cache. Future requests can then use the cached result
 * rather than needing to run afresh.
 * When a server completes execution of an
 * [Action][google.devtools.remoteexecution.v1test.Action], it MAY choose to
 * cache the [result][google.devtools.remoteexecution.v1test.ActionResult] in
 * the [ActionCache][google.devtools.remoteexecution.v1test.ActionCache] unless
 * `do_not_cache` is `true`. Clients SHOULD expect the server to do so. By
 * default, future calls to [Execute][] the same `Action` will also serve their
 * results from the cache. Clients must take care to understand the caching
 * behaviour. Ideally, all `Action`s will be reproducible so that serving a
 * result from cache is always desirable and correct.
 *
 * Generated from protobuf message <code>google.devtools.remoteexecution.v1test.Action</code>
 */
class Action extends \Google\Protobuf\Internal\Message
{
    /**
     * The digest of the [Command][google.devtools.remoteexecution.v1test.Command]
     * to run, which MUST be present in the
     * [ContentAddressableStorage][google.devtools.remoteexecution.v1test.ContentAddressableStorage].
     *
     * Generated from protobuf field <code>.google.devtools.remoteexecution.v1test.Digest command_digest = 1;</code>
     */
    private $command_digest = null;
    /**
     * The digest of the root
     * [Directory][google.devtools.remoteexecution.v1test.Directory] for the input
     * files. The files in the directory tree are available in the correct
     * location on the build machine before the command is executed. The root
     * directory, as well as every subdirectory and content blob referred to, MUST
     * be in the
     * [ContentAddressableStorage][google.devtools.remoteexecution.v1test.ContentAddressableStorage].
     *
     * Generated from protobuf field <code>.google.devtools.remoteexecution.v1test.Digest input_root_digest = 2;</code>
     */
    private $input_root_digest = null;
    /**
     * A list of the output files that the client expects to retrieve from the
     * action. Only the listed files, as well as directories listed in
     * `output_directories`, will be returned to the client as output.
     * Other files that may be created during command execution are discarded.
     * The paths are specified using forward slashes (`/`) as path separators,
     * even if the execution platform natively uses a different separator. The
     * path MUST NOT include a trailing slash.
     * In order to ensure consistent hashing of the same Action, the output paths
     * MUST be sorted lexicographically by code point (or, equivalently, by UTF-8
     * bytes).
     *
     * Generated from protobuf field <code>repeated string output_files = 3;</code>
     */
    private $output_files;
    /**
     * A list of the output directories that the client expects to retrieve from
     * the action. Only the contents of the indicated directories (recursively
     * including the contents of their subdirectories) will be
     * returned, as well as files listed in `output_files`. Other files that may
     * be created during command execution are discarded.
     * The paths are specified using forward slashes (`/`) as path separators,
     * even if the execution platform natively uses a different separator. The
     * path MUST NOT include a trailing slash, unless the path is `"/"` (which,
     * although not recommended, can be used to capture the entire working
     * directory tree, including inputs).
     * In order to ensure consistent hashing of the same Action, the output paths
     * MUST be sorted lexicographically by code point (or, equivalently, by UTF-8
     * bytes).
     *
     * Generated from protobuf field <code>repeated string output_directories = 4;</code>
     */
    private $output_directories;
    /**
     * The platform requirements for the execution environment. The server MAY
     * choose to execute the action on any worker satisfying the requirements, so
     * the client SHOULD ensure that running the action on any such worker will
     * have the same result.
     *
     * Generated from protobuf field <code>.google.devtools.remoteexecution.v1test.Platform platform = 5;</code>
     */
    private $platform = null;
    /**
     * A timeout after which the execution should be killed. If the timeout is
     * absent, then the client is specifying that the execution should continue
     * as long as the server will let it. The server SHOULD impose a timeout if
     * the client does not specify one, however, if the client does specify a
     * timeout that is longer than the server's maximum timeout, the server MUST
     * reject the request.
     * The timeout is a part of the
     * [Action][google.devtools.remoteexecution.v1test.Action] message, and
     * therefore two `Actions` with different timeouts are different, even if they
     * are otherwise identical. This is because, if they were not, running an
     * `Action` with a lower timeout than is required might result in a cache hit
     * from an execution run with a longer timeout, hiding the fact that the
     * timeout is too short. By encoding it directly in the `Action`, a lower
     * timeout will result in a cache miss and the execution timeout will fail
     * immediately, rather than whenever the cache entry gets evicted.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration timeout = 6;</code>
     */
    private $timeout = null;
    /**
     * If true, then the `Action`'s result cannot be cached.
     *
     * Generated from protobuf field <code>bool do_not_cache = 7;</code>
     */
    private $do_not_cache = false;

    public function __construct() {
        \GPBMetadata\Google\Devtools\Remoteexecution\V1Test\RemoteExecution::initOnce();
        parent::__construct();
    }

    /**
     * The digest of the [Command][google.devtools.remoteexecution.v1test.Command]
     * to run, which MUST be present in the
     * [ContentAddressableStorage][google.devtools.remoteexecution.v1test.ContentAddressableStorage].
     *
     * Generated from protobuf field <code>.google.devtools.remoteexecution.v1test.Digest command_digest = 1;</code>
     * @return \Google\Devtools\Remoteexecution\V1test\Digest
     */
    public function getCommandDigest()
    {
        return $this->command_digest;
    }

    /**
     * The digest of the [Command][google.devtools.remoteexecution.v1test.Command]
     * to run, which MUST be present in the
     * [ContentAddressableStorage][google.devtools.remoteexecution.v1test.ContentAddressableStorage].
     *
     * Generated from protobuf field <code>.google.devtools.remoteexecution.v1test.Digest command_digest = 1;</code>
     * @param \Google\Devtools\Remoteexecution\V1test\Digest $var
     * @return $this
     */
    public function setCommandDigest($var)
    {
        GPBUtil::checkMessage($var, \Google\Devtools\Remoteexecution\V1test\Digest::class);
        $this->command_digest = $var;

        return $this;
    }

    /**
     * The digest of the root
     * [Directory][google.devtools.remoteexecution.v1test.Directory] for the input
     * files. The files in the directory tree are available in the correct
     * location on the build machine before the command is executed. The root
     * directory, as well as every subdirectory and content blob referred to, MUST
     * be in the
     * [ContentAddressableStorage][google.devtools.remoteexecution.v1test.ContentAddressableStorage].
     *
     * Generated from protobuf field <code>.google.devtools.remoteexecution.v1test.Digest input_root_digest = 2;</code>
     * @return \Google\Devtools\Remoteexecution\V1test\Digest
     */
    public function getInputRootDigest()
    {
        return $this->input_root_digest;
    }

    /**
     * The digest of the root
     * [Directory][google.devtools.remoteexecution.v1test.Directory] for the input
     * files. The files in the directory tree are available in the correct
     * location on the build machine before the command is executed. The root
     * directory, as well as every subdirectory and content blob referred to, MUST
     * be in the
     * [ContentAddressableStorage][google.devtools.remoteexecution.v1test.ContentAddressableStorage].
     *
     * Generated from protobuf field <code>.google.devtools.remoteexecution.v1test.Digest input_root_digest = 2;</code>
     * @param \Google\Devtools\Remoteexecution\V1test\Digest $var
     * @return $this
     */
    public function setInputRootDigest($var)
    {
        GPBUtil::checkMessage($var, \Google\Devtools\Remoteexecution\V1test\Digest::class);
        $this->input_root_digest = $var;

        return $this;
    }

    /**
     * A list of the output files that the client expects to retrieve from the
     * action. Only the listed files, as well as directories listed in
     * `output_directories`, will be returned to the client as output.
     * Other files that may be created during command execution are discarded.
     * The paths are specified using forward slashes (`/`) as path separators,
     * even if the execution platform natively uses a different separator. The
     * path MUST NOT include a trailing slash.
     * In order to ensure consistent hashing of the same Action, the output paths
     * MUST be sorted lexicographically by code point (or, equivalently, by UTF-8
     * bytes).
     *
     * Generated from protobuf field <code>repeated string output_files = 3;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getOutputFiles()
    {
        return $this->output_files;
    }

    /**
     * A list of the output files that the client expects to retrieve from the
     * action. Only the listed files, as well as directories listed in
     * `output_directories`, will be returned to the client as output.
     * Other files that may be created during command execution are discarded.
     * The paths are specified using forward slashes (`/`) as path separators,
     * even if the execution platform natively uses a different separator. The
     * path MUST NOT include a trailing slash.
     * In order to ensure consistent hashing of the same Action, the output paths
     * MUST be sorted lexicographically by code point (or, equivalently, by UTF-8
     * bytes).
     *
     * Generated from protobuf field <code>repeated string output_files = 3;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setOutputFiles($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->output_files = $arr;

        return $this;
    }

    /**
     * A list of the output directories that the client expects to retrieve from
     * the action. Only the contents of the indicated directories (recursively
     * including the contents of their subdirectories) will be
     * returned, as well as files listed in `output_files`. Other files that may
     * be created during command execution are discarded.
     * The paths are specified using forward slashes (`/`) as path separators,
     * even if the execution platform natively uses a different separator. The
     * path MUST NOT include a trailing slash, unless the path is `"/"` (which,
     * although not recommended, can be used to capture the entire working
     * directory tree, including inputs).
     * In order to ensure consistent hashing of the same Action, the output paths
     * MUST be sorted lexicographically by code point (or, equivalently, by UTF-8
     * bytes).
     *
     * Generated from protobuf field <code>repeated string output_directories = 4;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getOutputDirectories()
    {
        return $this->output_directories;
    }

    /**
     * A list of the output directories that the client expects to retrieve from
     * the action. Only the contents of the indicated directories (recursively
     * including the contents of their subdirectories) will be
     * returned, as well as files listed in `output_files`. Other files that may
     * be created during command execution are discarded.
     * The paths are specified using forward slashes (`/`) as path separators,
     * even if the execution platform natively uses a different separator. The
     * path MUST NOT include a trailing slash, unless the path is `"/"` (which,
     * although not recommended, can be used to capture the entire working
     * directory tree, including inputs).
     * In order to ensure consistent hashing of the same Action, the output paths
     * MUST be sorted lexicographically by code point (or, equivalently, by UTF-8
     * bytes).
     *
     * Generated from protobuf field <code>repeated string output_directories = 4;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setOutputDirectories($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->output_directories = $arr;

        return $this;
    }

    /**
     * The platform requirements for the execution environment. The server MAY
     * choose to execute the action on any worker satisfying the requirements, so
     * the client SHOULD ensure that running the action on any such worker will
     * have the same result.
     *
     * Generated from protobuf field <code>.google.devtools.remoteexecution.v1test.Platform platform = 5;</code>
     * @return \Google\Devtools\Remoteexecution\V1test\Platform
     */
    public function getPlatform()
    {
        return $this->platform;
    }

    /**
     * The platform requirements for the execution environment. The server MAY
     * choose to execute the action on any worker satisfying the requirements, so
     * the client SHOULD ensure that running the action on any such worker will
     * have the same result.
     *
     * Generated from protobuf field <code>.google.devtools.remoteexecution.v1test.Platform platform = 5;</code>
     * @param \Google\Devtools\Remoteexecution\V1test\Platform $var
     * @return $this
     */
    public function setPlatform($var)
    {
        GPBUtil::checkMessage($var, \Google\Devtools\Remoteexecution\V1test\Platform::class);
        $this->platform = $var;

        return $this;
    }

    /**
     * A timeout after which the execution should be killed. If the timeout is
     * absent, then the client is specifying that the execution should continue
     * as long as the server will let it. The server SHOULD impose a timeout if
     * the client does not specify one, however, if the client does specify a
     * timeout that is longer than the server's maximum timeout, the server MUST
     * reject the request.
     * The timeout is a part of the
     * [Action][google.devtools.remoteexecution.v1test.Action] message, and
     * therefore two `Actions` with different timeouts are different, even if they
     * are otherwise identical. This is because, if they were not, running an
     * `Action` with a lower timeout than is required might result in a cache hit
     * from an execution run with a longer timeout, hiding the fact that the
     * timeout is too short. By encoding it directly in the `Action`, a lower
     * timeout will result in a cache miss and the execution timeout will fail
     * immediately, rather than whenever the cache entry gets evicted.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration timeout = 6;</code>
     * @return \Google\Protobuf\Duration
     */
    public function getTimeout()
    {
        return $this->timeout;
    }

    /**
     * A timeout after which the execution should be killed. If the timeout is
     * absent, then the client is specifying that the execution should continue
     * as long as the server will let it. The server SHOULD impose a timeout if
     * the client does not specify one, however, if the client does specify a
     * timeout that is longer than the server's maximum timeout, the server MUST
     * reject the request.
     * The timeout is a part of the
     * [Action][google.devtools.remoteexecution.v1test.Action] message, and
     * therefore two `Actions` with different timeouts are different, even if they
     * are otherwise identical. This is because, if they were not, running an
     * `Action` with a lower timeout than is required might result in a cache hit
     * from an execution run with a longer timeout, hiding the fact that the
     * timeout is too short. By encoding it directly in the `Action`, a lower
     * timeout will result in a cache miss and the execution timeout will fail
     * immediately, rather than whenever the cache entry gets evicted.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration timeout = 6;</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setTimeout($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->timeout = $var;

        return $this;
    }

    /**
     * If true, then the `Action`'s result cannot be cached.
     *
     * Generated from protobuf field <code>bool do_not_cache = 7;</code>
     * @return bool
     */
    public function getDoNotCache()
    {
        return $this->do_not_cache;
    }

    /**
     * If true, then the `Action`'s result cannot be cached.
     *
     * Generated from protobuf field <code>bool do_not_cache = 7;</code>
     * @param bool $var
     * @return $this
     */
    public function setDoNotCache($var)
    {
        GPBUtil::checkBool($var);
        $this->do_not_cache = $var;

        return $this;
    }

}

