<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/genomics/v1/annotations.proto

namespace Google\Genomics\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * An annotation describes a region of reference genome. The value of an
 * annotation may be one of several canonical types, supplemented by arbitrary
 * info tags. An annotation is not inherently associated with a specific
 * sample or individual (though a client could choose to use annotations in
 * this way). Example canonical annotation types are `GENE` and
 * `VARIANT`.
 *
 * Generated from protobuf message <code>google.genomics.v1.Annotation</code>
 */
class Annotation extends \Google\Protobuf\Internal\Message
{
    /**
     * The server-generated annotation ID, unique across all annotations.
     *
     * Generated from protobuf field <code>string id = 1;</code>
     */
    private $id = '';
    /**
     * The annotation set to which this annotation belongs.
     *
     * Generated from protobuf field <code>string annotation_set_id = 2;</code>
     */
    private $annotation_set_id = '';
    /**
     * The display name of this annotation.
     *
     * Generated from protobuf field <code>string name = 3;</code>
     */
    private $name = '';
    /**
     * The ID of the Google Genomics reference associated with this range.
     *
     * Generated from protobuf field <code>string reference_id = 4;</code>
     */
    private $reference_id = '';
    /**
     * The display name corresponding to the reference specified by
     * `referenceId`, for example `chr1`, `1`, or `chrX`.
     *
     * Generated from protobuf field <code>string reference_name = 5;</code>
     */
    private $reference_name = '';
    /**
     * The start position of the range on the reference, 0-based inclusive.
     *
     * Generated from protobuf field <code>int64 start = 6;</code>
     */
    private $start = 0;
    /**
     * The end position of the range on the reference, 0-based exclusive.
     *
     * Generated from protobuf field <code>int64 end = 7;</code>
     */
    private $end = 0;
    /**
     * Whether this range refers to the reverse strand, as opposed to the forward
     * strand. Note that regardless of this field, the start/end position of the
     * range always refer to the forward strand.
     *
     * Generated from protobuf field <code>bool reverse_strand = 8;</code>
     */
    private $reverse_strand = false;
    /**
     * The data type for this annotation. Must match the containing annotation
     * set's type.
     *
     * Generated from protobuf field <code>.google.genomics.v1.AnnotationType type = 9;</code>
     */
    private $type = 0;
    /**
     * A map of additional read alignment information. This must be of the form
     * map<string, string[]> (string key mapping to a list of string values).
     *
     * Generated from protobuf field <code>map<string, .google.protobuf.ListValue> info = 12;</code>
     */
    private $info;
    protected $value;

    public function __construct() {
        \GPBMetadata\Google\Genomics\V1\Annotations::initOnce();
        parent::__construct();
    }

    /**
     * The server-generated annotation ID, unique across all annotations.
     *
     * Generated from protobuf field <code>string id = 1;</code>
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * The server-generated annotation ID, unique across all annotations.
     *
     * Generated from protobuf field <code>string id = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setId($var)
    {
        GPBUtil::checkString($var, True);
        $this->id = $var;

        return $this;
    }

    /**
     * The annotation set to which this annotation belongs.
     *
     * Generated from protobuf field <code>string annotation_set_id = 2;</code>
     * @return string
     */
    public function getAnnotationSetId()
    {
        return $this->annotation_set_id;
    }

    /**
     * The annotation set to which this annotation belongs.
     *
     * Generated from protobuf field <code>string annotation_set_id = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setAnnotationSetId($var)
    {
        GPBUtil::checkString($var, True);
        $this->annotation_set_id = $var;

        return $this;
    }

    /**
     * The display name of this annotation.
     *
     * Generated from protobuf field <code>string name = 3;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * The display name of this annotation.
     *
     * Generated from protobuf field <code>string name = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * The ID of the Google Genomics reference associated with this range.
     *
     * Generated from protobuf field <code>string reference_id = 4;</code>
     * @return string
     */
    public function getReferenceId()
    {
        return $this->reference_id;
    }

    /**
     * The ID of the Google Genomics reference associated with this range.
     *
     * Generated from protobuf field <code>string reference_id = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setReferenceId($var)
    {
        GPBUtil::checkString($var, True);
        $this->reference_id = $var;

        return $this;
    }

    /**
     * The display name corresponding to the reference specified by
     * `referenceId`, for example `chr1`, `1`, or `chrX`.
     *
     * Generated from protobuf field <code>string reference_name = 5;</code>
     * @return string
     */
    public function getReferenceName()
    {
        return $this->reference_name;
    }

    /**
     * The display name corresponding to the reference specified by
     * `referenceId`, for example `chr1`, `1`, or `chrX`.
     *
     * Generated from protobuf field <code>string reference_name = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setReferenceName($var)
    {
        GPBUtil::checkString($var, True);
        $this->reference_name = $var;

        return $this;
    }

    /**
     * The start position of the range on the reference, 0-based inclusive.
     *
     * Generated from protobuf field <code>int64 start = 6;</code>
     * @return int|string
     */
    public function getStart()
    {
        return $this->start;
    }

    /**
     * The start position of the range on the reference, 0-based inclusive.
     *
     * Generated from protobuf field <code>int64 start = 6;</code>
     * @param int|string $var
     * @return $this
     */
    public function setStart($var)
    {
        GPBUtil::checkInt64($var);
        $this->start = $var;

        return $this;
    }

    /**
     * The end position of the range on the reference, 0-based exclusive.
     *
     * Generated from protobuf field <code>int64 end = 7;</code>
     * @return int|string
     */
    public function getEnd()
    {
        return $this->end;
    }

    /**
     * The end position of the range on the reference, 0-based exclusive.
     *
     * Generated from protobuf field <code>int64 end = 7;</code>
     * @param int|string $var
     * @return $this
     */
    public function setEnd($var)
    {
        GPBUtil::checkInt64($var);
        $this->end = $var;

        return $this;
    }

    /**
     * Whether this range refers to the reverse strand, as opposed to the forward
     * strand. Note that regardless of this field, the start/end position of the
     * range always refer to the forward strand.
     *
     * Generated from protobuf field <code>bool reverse_strand = 8;</code>
     * @return bool
     */
    public function getReverseStrand()
    {
        return $this->reverse_strand;
    }

    /**
     * Whether this range refers to the reverse strand, as opposed to the forward
     * strand. Note that regardless of this field, the start/end position of the
     * range always refer to the forward strand.
     *
     * Generated from protobuf field <code>bool reverse_strand = 8;</code>
     * @param bool $var
     * @return $this
     */
    public function setReverseStrand($var)
    {
        GPBUtil::checkBool($var);
        $this->reverse_strand = $var;

        return $this;
    }

    /**
     * The data type for this annotation. Must match the containing annotation
     * set's type.
     *
     * Generated from protobuf field <code>.google.genomics.v1.AnnotationType type = 9;</code>
     * @return int
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * The data type for this annotation. Must match the containing annotation
     * set's type.
     *
     * Generated from protobuf field <code>.google.genomics.v1.AnnotationType type = 9;</code>
     * @param int $var
     * @return $this
     */
    public function setType($var)
    {
        GPBUtil::checkEnum($var, \Google\Genomics\V1\AnnotationType::class);
        $this->type = $var;

        return $this;
    }

    /**
     * A variant annotation, which describes the effect of a variant on the
     * genome, the coding sequence, and/or higher level consequences at the
     * organism level e.g. pathogenicity. This field is only set for annotations
     * of type `VARIANT`.
     *
     * Generated from protobuf field <code>.google.genomics.v1.VariantAnnotation variant = 10;</code>
     * @return \Google\Genomics\V1\VariantAnnotation
     */
    public function getVariant()
    {
        return $this->readOneof(10);
    }

    /**
     * A variant annotation, which describes the effect of a variant on the
     * genome, the coding sequence, and/or higher level consequences at the
     * organism level e.g. pathogenicity. This field is only set for annotations
     * of type `VARIANT`.
     *
     * Generated from protobuf field <code>.google.genomics.v1.VariantAnnotation variant = 10;</code>
     * @param \Google\Genomics\V1\VariantAnnotation $var
     * @return $this
     */
    public function setVariant($var)
    {
        GPBUtil::checkMessage($var, \Google\Genomics\V1\VariantAnnotation::class);
        $this->writeOneof(10, $var);

        return $this;
    }

    /**
     * A transcript value represents the assertion that a particular region of
     * the reference genome may be transcribed as RNA. An alternative splicing
     * pattern would be represented as a separate transcript object. This field
     * is only set for annotations of type `TRANSCRIPT`.
     *
     * Generated from protobuf field <code>.google.genomics.v1.Transcript transcript = 11;</code>
     * @return \Google\Genomics\V1\Transcript
     */
    public function getTranscript()
    {
        return $this->readOneof(11);
    }

    /**
     * A transcript value represents the assertion that a particular region of
     * the reference genome may be transcribed as RNA. An alternative splicing
     * pattern would be represented as a separate transcript object. This field
     * is only set for annotations of type `TRANSCRIPT`.
     *
     * Generated from protobuf field <code>.google.genomics.v1.Transcript transcript = 11;</code>
     * @param \Google\Genomics\V1\Transcript $var
     * @return $this
     */
    public function setTranscript($var)
    {
        GPBUtil::checkMessage($var, \Google\Genomics\V1\Transcript::class);
        $this->writeOneof(11, $var);

        return $this;
    }

    /**
     * A map of additional read alignment information. This must be of the form
     * map<string, string[]> (string key mapping to a list of string values).
     *
     * Generated from protobuf field <code>map<string, .google.protobuf.ListValue> info = 12;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getInfo()
    {
        return $this->info;
    }

    /**
     * A map of additional read alignment information. This must be of the form
     * map<string, string[]> (string key mapping to a list of string values).
     *
     * Generated from protobuf field <code>map<string, .google.protobuf.ListValue> info = 12;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setInfo($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Protobuf\ListValue::class);
        $this->info = $arr;

        return $this;
    }

    /**
     * @return string
     */
    public function getValue()
    {
        return $this->whichOneof("value");
    }

}

