<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/genomics/v1/references.proto

namespace Google\Genomics\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A reference is a canonical assembled DNA sequence, intended to act as a
 * reference coordinate space for other genomic annotations. A single reference
 * might represent the human chromosome 1 or mitochandrial DNA, for instance. A
 * reference belongs to one or more reference sets.
 * For more genomics resource definitions, see [Fundamentals of Google
 * Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
 *
 * Generated from protobuf message <code>google.genomics.v1.Reference</code>
 */
class Reference extends \Google\Protobuf\Internal\Message
{
    /**
     * The server-generated reference ID, unique across all references.
     *
     * Generated from protobuf field <code>string id = 1;</code>
     */
    private $id = '';
    /**
     * The length of this reference's sequence.
     *
     * Generated from protobuf field <code>int64 length = 2;</code>
     */
    private $length = 0;
    /**
     * MD5 of the upper-case sequence excluding all whitespace characters (this
     * is equivalent to SQ:M5 in SAM). This value is represented in lower case
     * hexadecimal format.
     *
     * Generated from protobuf field <code>string md5checksum = 3;</code>
     */
    private $md5checksum = '';
    /**
     * The name of this reference, for example `22`.
     *
     * Generated from protobuf field <code>string name = 4;</code>
     */
    private $name = '';
    /**
     * The URI from which the sequence was obtained. Typically specifies a FASTA
     * format file.
     *
     * Generated from protobuf field <code>string source_uri = 5;</code>
     */
    private $source_uri = '';
    /**
     * All known corresponding accession IDs in INSDC (GenBank/ENA/DDBJ) ideally
     * with a version number, for example `GCF_000001405.26`.
     *
     * Generated from protobuf field <code>repeated string source_accessions = 6;</code>
     */
    private $source_accessions;
    /**
     * ID from http://www.ncbi.nlm.nih.gov/taxonomy. For example, 9606 for human.
     *
     * Generated from protobuf field <code>int32 ncbi_taxon_id = 7;</code>
     */
    private $ncbi_taxon_id = 0;

    public function __construct() {
        \GPBMetadata\Google\Genomics\V1\References::initOnce();
        parent::__construct();
    }

    /**
     * The server-generated reference ID, unique across all references.
     *
     * Generated from protobuf field <code>string id = 1;</code>
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * The server-generated reference ID, unique across all references.
     *
     * Generated from protobuf field <code>string id = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setId($var)
    {
        GPBUtil::checkString($var, True);
        $this->id = $var;

        return $this;
    }

    /**
     * The length of this reference's sequence.
     *
     * Generated from protobuf field <code>int64 length = 2;</code>
     * @return int|string
     */
    public function getLength()
    {
        return $this->length;
    }

    /**
     * The length of this reference's sequence.
     *
     * Generated from protobuf field <code>int64 length = 2;</code>
     * @param int|string $var
     * @return $this
     */
    public function setLength($var)
    {
        GPBUtil::checkInt64($var);
        $this->length = $var;

        return $this;
    }

    /**
     * MD5 of the upper-case sequence excluding all whitespace characters (this
     * is equivalent to SQ:M5 in SAM). This value is represented in lower case
     * hexadecimal format.
     *
     * Generated from protobuf field <code>string md5checksum = 3;</code>
     * @return string
     */
    public function getMd5Checksum()
    {
        return $this->md5checksum;
    }

    /**
     * MD5 of the upper-case sequence excluding all whitespace characters (this
     * is equivalent to SQ:M5 in SAM). This value is represented in lower case
     * hexadecimal format.
     *
     * Generated from protobuf field <code>string md5checksum = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setMd5Checksum($var)
    {
        GPBUtil::checkString($var, True);
        $this->md5checksum = $var;

        return $this;
    }

    /**
     * The name of this reference, for example `22`.
     *
     * Generated from protobuf field <code>string name = 4;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * The name of this reference, for example `22`.
     *
     * Generated from protobuf field <code>string name = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * The URI from which the sequence was obtained. Typically specifies a FASTA
     * format file.
     *
     * Generated from protobuf field <code>string source_uri = 5;</code>
     * @return string
     */
    public function getSourceUri()
    {
        return $this->source_uri;
    }

    /**
     * The URI from which the sequence was obtained. Typically specifies a FASTA
     * format file.
     *
     * Generated from protobuf field <code>string source_uri = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setSourceUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->source_uri = $var;

        return $this;
    }

    /**
     * All known corresponding accession IDs in INSDC (GenBank/ENA/DDBJ) ideally
     * with a version number, for example `GCF_000001405.26`.
     *
     * Generated from protobuf field <code>repeated string source_accessions = 6;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getSourceAccessions()
    {
        return $this->source_accessions;
    }

    /**
     * All known corresponding accession IDs in INSDC (GenBank/ENA/DDBJ) ideally
     * with a version number, for example `GCF_000001405.26`.
     *
     * Generated from protobuf field <code>repeated string source_accessions = 6;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setSourceAccessions($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->source_accessions = $arr;

        return $this;
    }

    /**
     * ID from http://www.ncbi.nlm.nih.gov/taxonomy. For example, 9606 for human.
     *
     * Generated from protobuf field <code>int32 ncbi_taxon_id = 7;</code>
     * @return int
     */
    public function getNcbiTaxonId()
    {
        return $this->ncbi_taxon_id;
    }

    /**
     * ID from http://www.ncbi.nlm.nih.gov/taxonomy. For example, 9606 for human.
     *
     * Generated from protobuf field <code>int32 ncbi_taxon_id = 7;</code>
     * @param int $var
     * @return $this
     */
    public function setNcbiTaxonId($var)
    {
        GPBUtil::checkInt32($var);
        $this->ncbi_taxon_id = $var;

        return $this;
    }

}

