<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/genomics/v1/annotations.proto

namespace Google\Genomics\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A transcript represents the assertion that a particular region of the
 * reference genome may be transcribed as RNA.
 *
 * Generated from protobuf message <code>google.genomics.v1.Transcript</code>
 */
class Transcript extends \Google\Protobuf\Internal\Message
{
    /**
     * The annotation ID of the gene from which this transcript is transcribed.
     *
     * Generated from protobuf field <code>string gene_id = 1;</code>
     */
    private $gene_id = '';
    /**
     * The <a href="http://en.wikipedia.org/wiki/Exon">exons</a> that compose
     * this transcript. This field should be unset for genomes where transcript
     * splicing does not occur, for example prokaryotes.
     * Introns are regions of the transcript that are not included in the
     * spliced RNA product. Though not explicitly modeled here, intron ranges can
     * be deduced; all regions of this transcript that are not exons are introns.
     * Exonic sequences do not necessarily code for a translational product
     * (amino acids). Only the regions of exons bounded by the
     * [codingSequence][google.genomics.v1.Transcript.coding_sequence] correspond
     * to coding DNA sequence.
     * Exons are ordered by start position and may not overlap.
     *
     * Generated from protobuf field <code>repeated .google.genomics.v1.Transcript.Exon exons = 2;</code>
     */
    private $exons;
    /**
     * The range of the coding sequence for this transcript, if any. To determine
     * the exact ranges of coding sequence, intersect this range with those of the
     * [exons][google.genomics.v1.Transcript.exons], if any. If there are any
     * [exons][google.genomics.v1.Transcript.exons], the
     * [codingSequence][google.genomics.v1.Transcript.coding_sequence] must start
     * and end within them.
     * Note that in some cases, the reference genome will not exactly match the
     * observed mRNA transcript e.g. due to variance in the source genome from
     * reference. In these cases,
     * [exon.frame][google.genomics.v1.Transcript.Exon.frame] will not necessarily
     * match the expected reference reading frame and coding exon reference bases
     * cannot necessarily be concatenated to produce the original transcript mRNA.
     *
     * Generated from protobuf field <code>.google.genomics.v1.Transcript.CodingSequence coding_sequence = 3;</code>
     */
    private $coding_sequence = null;

    public function __construct() {
        \GPBMetadata\Google\Genomics\V1\Annotations::initOnce();
        parent::__construct();
    }

    /**
     * The annotation ID of the gene from which this transcript is transcribed.
     *
     * Generated from protobuf field <code>string gene_id = 1;</code>
     * @return string
     */
    public function getGeneId()
    {
        return $this->gene_id;
    }

    /**
     * The annotation ID of the gene from which this transcript is transcribed.
     *
     * Generated from protobuf field <code>string gene_id = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setGeneId($var)
    {
        GPBUtil::checkString($var, True);
        $this->gene_id = $var;

        return $this;
    }

    /**
     * The <a href="http://en.wikipedia.org/wiki/Exon">exons</a> that compose
     * this transcript. This field should be unset for genomes where transcript
     * splicing does not occur, for example prokaryotes.
     * Introns are regions of the transcript that are not included in the
     * spliced RNA product. Though not explicitly modeled here, intron ranges can
     * be deduced; all regions of this transcript that are not exons are introns.
     * Exonic sequences do not necessarily code for a translational product
     * (amino acids). Only the regions of exons bounded by the
     * [codingSequence][google.genomics.v1.Transcript.coding_sequence] correspond
     * to coding DNA sequence.
     * Exons are ordered by start position and may not overlap.
     *
     * Generated from protobuf field <code>repeated .google.genomics.v1.Transcript.Exon exons = 2;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getExons()
    {
        return $this->exons;
    }

    /**
     * The <a href="http://en.wikipedia.org/wiki/Exon">exons</a> that compose
     * this transcript. This field should be unset for genomes where transcript
     * splicing does not occur, for example prokaryotes.
     * Introns are regions of the transcript that are not included in the
     * spliced RNA product. Though not explicitly modeled here, intron ranges can
     * be deduced; all regions of this transcript that are not exons are introns.
     * Exonic sequences do not necessarily code for a translational product
     * (amino acids). Only the regions of exons bounded by the
     * [codingSequence][google.genomics.v1.Transcript.coding_sequence] correspond
     * to coding DNA sequence.
     * Exons are ordered by start position and may not overlap.
     *
     * Generated from protobuf field <code>repeated .google.genomics.v1.Transcript.Exon exons = 2;</code>
     * @param \Google\Genomics\V1\Transcript_Exon[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setExons($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Genomics\V1\Transcript_Exon::class);
        $this->exons = $arr;

        return $this;
    }

    /**
     * The range of the coding sequence for this transcript, if any. To determine
     * the exact ranges of coding sequence, intersect this range with those of the
     * [exons][google.genomics.v1.Transcript.exons], if any. If there are any
     * [exons][google.genomics.v1.Transcript.exons], the
     * [codingSequence][google.genomics.v1.Transcript.coding_sequence] must start
     * and end within them.
     * Note that in some cases, the reference genome will not exactly match the
     * observed mRNA transcript e.g. due to variance in the source genome from
     * reference. In these cases,
     * [exon.frame][google.genomics.v1.Transcript.Exon.frame] will not necessarily
     * match the expected reference reading frame and coding exon reference bases
     * cannot necessarily be concatenated to produce the original transcript mRNA.
     *
     * Generated from protobuf field <code>.google.genomics.v1.Transcript.CodingSequence coding_sequence = 3;</code>
     * @return \Google\Genomics\V1\Transcript_CodingSequence
     */
    public function getCodingSequence()
    {
        return $this->coding_sequence;
    }

    /**
     * The range of the coding sequence for this transcript, if any. To determine
     * the exact ranges of coding sequence, intersect this range with those of the
     * [exons][google.genomics.v1.Transcript.exons], if any. If there are any
     * [exons][google.genomics.v1.Transcript.exons], the
     * [codingSequence][google.genomics.v1.Transcript.coding_sequence] must start
     * and end within them.
     * Note that in some cases, the reference genome will not exactly match the
     * observed mRNA transcript e.g. due to variance in the source genome from
     * reference. In these cases,
     * [exon.frame][google.genomics.v1.Transcript.Exon.frame] will not necessarily
     * match the expected reference reading frame and coding exon reference bases
     * cannot necessarily be concatenated to produce the original transcript mRNA.
     *
     * Generated from protobuf field <code>.google.genomics.v1.Transcript.CodingSequence coding_sequence = 3;</code>
     * @param \Google\Genomics\V1\Transcript_CodingSequence $var
     * @return $this
     */
    public function setCodingSequence($var)
    {
        GPBUtil::checkMessage($var, \Google\Genomics\V1\Transcript_CodingSequence::class);
        $this->coding_sequence = $var;

        return $this;
    }

}

