<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/genomics/v1alpha2/pipelines.proto

namespace Google\Genomics\V1alpha2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The pipeline object. Represents a transformation from a set of input
 * parameters to a set of output parameters. The transformation is defined
 * as a docker image and command to run within that image. Each pipeline
 * is run on a Google Compute Engine VM. A pipeline can be created with the
 * `create` method and then later run with the `run` method, or a pipeline can
 * be defined and run all at once with the `run` method.
 *
 * Generated from protobuf message <code>google.genomics.v1alpha2.Pipeline</code>
 */
class Pipeline extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The project in which to create the pipeline. The caller must have
     * WRITE access.
     *
     * Generated from protobuf field <code>string project_id = 1;</code>
     */
    private $project_id = '';
    /**
     * Required. A user specified pipeline name that does not have to be unique.
     * This name can be used for filtering Pipelines in ListPipelines.
     *
     * Generated from protobuf field <code>string name = 2;</code>
     */
    private $name = '';
    /**
     * User-specified description.
     *
     * Generated from protobuf field <code>string description = 3;</code>
     */
    private $description = '';
    /**
     * Input parameters of the pipeline.
     *
     * Generated from protobuf field <code>repeated .google.genomics.v1alpha2.PipelineParameter input_parameters = 8;</code>
     */
    private $input_parameters;
    /**
     * Output parameters of the pipeline.
     *
     * Generated from protobuf field <code>repeated .google.genomics.v1alpha2.PipelineParameter output_parameters = 9;</code>
     */
    private $output_parameters;
    /**
     * Required. Specifies resource requirements for the pipeline run.
     * Required fields:
     * *
     * [minimumCpuCores][google.genomics.v1alpha2.PipelineResources.minimum_cpu_cores]
     * *
     * [minimumRamGb][google.genomics.v1alpha2.PipelineResources.minimum_ram_gb]
     *
     * Generated from protobuf field <code>.google.genomics.v1alpha2.PipelineResources resources = 6;</code>
     */
    private $resources = null;
    /**
     * Unique pipeline id that is generated by the service when CreatePipeline
     * is called. Cannot be specified in the Pipeline used in the
     * CreatePipelineRequest, and will be populated in the response to
     * CreatePipeline and all subsequent Get and List calls. Indicates that the
     * service has registered this pipeline.
     *
     * Generated from protobuf field <code>string pipeline_id = 7;</code>
     */
    private $pipeline_id = '';
    protected $executor;

    public function __construct() {
        \GPBMetadata\Google\Genomics\V1Alpha2\Pipelines::initOnce();
        parent::__construct();
    }

    /**
     * Required. The project in which to create the pipeline. The caller must have
     * WRITE access.
     *
     * Generated from protobuf field <code>string project_id = 1;</code>
     * @return string
     */
    public function getProjectId()
    {
        return $this->project_id;
    }

    /**
     * Required. The project in which to create the pipeline. The caller must have
     * WRITE access.
     *
     * Generated from protobuf field <code>string project_id = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setProjectId($var)
    {
        GPBUtil::checkString($var, True);
        $this->project_id = $var;

        return $this;
    }

    /**
     * Required. A user specified pipeline name that does not have to be unique.
     * This name can be used for filtering Pipelines in ListPipelines.
     *
     * Generated from protobuf field <code>string name = 2;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Required. A user specified pipeline name that does not have to be unique.
     * This name can be used for filtering Pipelines in ListPipelines.
     *
     * Generated from protobuf field <code>string name = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * User-specified description.
     *
     * Generated from protobuf field <code>string description = 3;</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * User-specified description.
     *
     * Generated from protobuf field <code>string description = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Input parameters of the pipeline.
     *
     * Generated from protobuf field <code>repeated .google.genomics.v1alpha2.PipelineParameter input_parameters = 8;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getInputParameters()
    {
        return $this->input_parameters;
    }

    /**
     * Input parameters of the pipeline.
     *
     * Generated from protobuf field <code>repeated .google.genomics.v1alpha2.PipelineParameter input_parameters = 8;</code>
     * @param \Google\Genomics\V1alpha2\PipelineParameter[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setInputParameters($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Genomics\V1alpha2\PipelineParameter::class);
        $this->input_parameters = $arr;

        return $this;
    }

    /**
     * Output parameters of the pipeline.
     *
     * Generated from protobuf field <code>repeated .google.genomics.v1alpha2.PipelineParameter output_parameters = 9;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getOutputParameters()
    {
        return $this->output_parameters;
    }

    /**
     * Output parameters of the pipeline.
     *
     * Generated from protobuf field <code>repeated .google.genomics.v1alpha2.PipelineParameter output_parameters = 9;</code>
     * @param \Google\Genomics\V1alpha2\PipelineParameter[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setOutputParameters($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Genomics\V1alpha2\PipelineParameter::class);
        $this->output_parameters = $arr;

        return $this;
    }

    /**
     * Specifies the docker run information.
     *
     * Generated from protobuf field <code>.google.genomics.v1alpha2.DockerExecutor docker = 5;</code>
     * @return \Google\Genomics\V1alpha2\DockerExecutor
     */
    public function getDocker()
    {
        return $this->readOneof(5);
    }

    /**
     * Specifies the docker run information.
     *
     * Generated from protobuf field <code>.google.genomics.v1alpha2.DockerExecutor docker = 5;</code>
     * @param \Google\Genomics\V1alpha2\DockerExecutor $var
     * @return $this
     */
    public function setDocker($var)
    {
        GPBUtil::checkMessage($var, \Google\Genomics\V1alpha2\DockerExecutor::class);
        $this->writeOneof(5, $var);

        return $this;
    }

    /**
     * Required. Specifies resource requirements for the pipeline run.
     * Required fields:
     * *
     * [minimumCpuCores][google.genomics.v1alpha2.PipelineResources.minimum_cpu_cores]
     * *
     * [minimumRamGb][google.genomics.v1alpha2.PipelineResources.minimum_ram_gb]
     *
     * Generated from protobuf field <code>.google.genomics.v1alpha2.PipelineResources resources = 6;</code>
     * @return \Google\Genomics\V1alpha2\PipelineResources
     */
    public function getResources()
    {
        return $this->resources;
    }

    /**
     * Required. Specifies resource requirements for the pipeline run.
     * Required fields:
     * *
     * [minimumCpuCores][google.genomics.v1alpha2.PipelineResources.minimum_cpu_cores]
     * *
     * [minimumRamGb][google.genomics.v1alpha2.PipelineResources.minimum_ram_gb]
     *
     * Generated from protobuf field <code>.google.genomics.v1alpha2.PipelineResources resources = 6;</code>
     * @param \Google\Genomics\V1alpha2\PipelineResources $var
     * @return $this
     */
    public function setResources($var)
    {
        GPBUtil::checkMessage($var, \Google\Genomics\V1alpha2\PipelineResources::class);
        $this->resources = $var;

        return $this;
    }

    /**
     * Unique pipeline id that is generated by the service when CreatePipeline
     * is called. Cannot be specified in the Pipeline used in the
     * CreatePipelineRequest, and will be populated in the response to
     * CreatePipeline and all subsequent Get and List calls. Indicates that the
     * service has registered this pipeline.
     *
     * Generated from protobuf field <code>string pipeline_id = 7;</code>
     * @return string
     */
    public function getPipelineId()
    {
        return $this->pipeline_id;
    }

    /**
     * Unique pipeline id that is generated by the service when CreatePipeline
     * is called. Cannot be specified in the Pipeline used in the
     * CreatePipelineRequest, and will be populated in the response to
     * CreatePipeline and all subsequent Get and List calls. Indicates that the
     * service has registered this pipeline.
     *
     * Generated from protobuf field <code>string pipeline_id = 7;</code>
     * @param string $var
     * @return $this
     */
    public function setPipelineId($var)
    {
        GPBUtil::checkString($var, True);
        $this->pipeline_id = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getExecutor()
    {
        return $this->whichOneof("executor");
    }

}

