<?php
// This file was auto-generated from sdk-root/src/data/account/2021-02-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Operations for Amazon Web Services Account Management</p>', 'operations' => [ 'AcceptPrimaryEmailUpdate' => '<p>Accepts the request that originated from <a>StartPrimaryEmailUpdate</a> to update the primary email address (also known as the root user email address) for the specified account.</p>', 'DeleteAlternateContact' => '<p>Deletes the specified alternate contact from an Amazon Web Services account.</p> <p>For complete details about how to use the alternate contact operations, see <a href="https://docs.aws.amazon.com/accounts/latest/reference/manage-acct-update-contact.html">Access or updating the alternate contacts</a>.</p> <note> <p>Before you can update the alternate contact information for an Amazon Web Services account that is managed by Organizations, you must first enable integration between Amazon Web Services Account Management and Organizations. For more information, see <a href="https://docs.aws.amazon.com/accounts/latest/reference/using-orgs-trusted-access.html">Enabling trusted access for Amazon Web Services Account Management</a>.</p> </note>', 'DisableRegion' => '<p>Disables (opts-out) a particular Region for an account.</p> <note> <p>The act of disabling a Region will remove all IAM access to any resources that reside in that Region.</p> </note>', 'EnableRegion' => '<p>Enables (opts-in) a particular Region for an account.</p>', 'GetAlternateContact' => '<p>Retrieves the specified alternate contact attached to an Amazon Web Services account.</p> <p>For complete details about how to use the alternate contact operations, see <a href="https://docs.aws.amazon.com/accounts/latest/reference/manage-acct-update-contact.html">Access or updating the alternate contacts</a>.</p> <note> <p>Before you can update the alternate contact information for an Amazon Web Services account that is managed by Organizations, you must first enable integration between Amazon Web Services Account Management and Organizations. For more information, see <a href="https://docs.aws.amazon.com/accounts/latest/reference/using-orgs-trusted-access.html">Enabling trusted access for Amazon Web Services Account Management</a>.</p> </note>', 'GetContactInformation' => '<p>Retrieves the primary contact information of an Amazon Web Services account.</p> <p>For complete details about how to use the primary contact operations, see <a href="https://docs.aws.amazon.com/accounts/latest/reference/manage-acct-update-contact.html">Update the primary and alternate contact information</a>.</p>', 'GetPrimaryEmail' => '<p>Retrieves the primary email address for the specified account.</p>', 'GetRegionOptStatus' => '<p>Retrieves the opt-in status of a particular Region.</p>', 'ListRegions' => '<p>Lists all the Regions for a given account and their respective opt-in statuses. Optionally, this list can be filtered by the <code>region-opt-status-contains</code> parameter. </p>', 'PutAlternateContact' => '<p>Modifies the specified alternate contact attached to an Amazon Web Services account.</p> <p>For complete details about how to use the alternate contact operations, see <a href="https://docs.aws.amazon.com/accounts/latest/reference/manage-acct-update-contact.html">Access or updating the alternate contacts</a>.</p> <note> <p>Before you can update the alternate contact information for an Amazon Web Services account that is managed by Organizations, you must first enable integration between Amazon Web Services Account Management and Organizations. For more information, see <a href="https://docs.aws.amazon.com/accounts/latest/reference/using-orgs-trusted-access.html">Enabling trusted access for Amazon Web Services Account Management</a>.</p> </note>', 'PutContactInformation' => '<p>Updates the primary contact information of an Amazon Web Services account.</p> <p>For complete details about how to use the primary contact operations, see <a href="https://docs.aws.amazon.com/accounts/latest/reference/manage-acct-update-contact.html">Update the primary and alternate contact information</a>.</p>', 'StartPrimaryEmailUpdate' => '<p>Starts the process to update the primary email address for the specified account.</p>', ], 'shapes' => [ 'AcceptPrimaryEmailUpdateRequest' => [ 'base' => NULL, 'refs' => [], ], 'AcceptPrimaryEmailUpdateResponse' => [ 'base' => NULL, 'refs' => [], ], 'AccessDeniedException' => [ 'base' => '<p>The operation failed because the calling identity doesn\'t have the minimum required permissions.</p>', 'refs' => [], ], 'AccountId' => [ 'base' => NULL, 'refs' => [ 'AcceptPrimaryEmailUpdateRequest$AccountId' => '<p>Specifies the 12-digit account ID number of the Amazon Web Services account that you want to access or modify with this operation. To use this parameter, the caller must be an identity in the <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account">organization\'s management account</a> or a delegated administrator account. The specified account ID must be a member account in the same organization. The organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">all features enabled</a>, and the organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html">trusted access</a> enabled for the Account Management service, and optionally a <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html">delegated admin</a> account assigned.</p> <p>This operation can only be called from the management account or the delegated administrator account of an organization for a member account.</p> <note> <p>The management account can\'t specify its own <code>AccountId</code>.</p> </note>', 'DeleteAlternateContactRequest$AccountId' => '<p>Specifies the 12 digit account ID number of the Amazon Web Services account that you want to access or modify with this operation.</p> <p>If you do not specify this parameter, it defaults to the Amazon Web Services account of the identity used to call the operation.</p> <p>To use this parameter, the caller must be an identity in the <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account">organization\'s management account</a> or a delegated administrator account, and the specified account ID must be a member account in the same organization. The organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">all features enabled</a>, and the organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html">trusted access</a> enabled for the Account Management service, and optionally a <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html">delegated admin</a> account assigned.</p> <note> <p>The management account can\'t specify its own <code>AccountId</code>; it must call the operation in standalone context by not including the <code>AccountId</code> parameter.</p> </note> <p>To call this operation on an account that is not a member of an organization, then don\'t specify this parameter, and call the operation using an identity belonging to the account whose contacts you wish to retrieve or modify.</p>', 'DisableRegionRequest$AccountId' => '<p>Specifies the 12-digit account ID number of the Amazon Web Services account that you want to access or modify with this operation. If you don\'t specify this parameter, it defaults to the Amazon Web Services account of the identity used to call the operation. To use this parameter, the caller must be an identity in the <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account">organization\'s management account</a> or a delegated administrator account. The specified account ID must be a member account in the same organization. The organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">all features enabled</a>, and the organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html">trusted access</a> enabled for the Account Management service, and optionally a <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html">delegated admin</a> account assigned.</p> <note> <p>The management account can\'t specify its own <code>AccountId</code>. It must call the operation in standalone context by not including the <code>AccountId</code> parameter.</p> </note> <p>To call this operation on an account that is not a member of an organization, don\'t specify this parameter. Instead, call the operation using an identity belonging to the account whose contacts you wish to retrieve or modify.</p>', 'EnableRegionRequest$AccountId' => '<p>Specifies the 12-digit account ID number of the Amazon Web Services account that you want to access or modify with this operation. If you don\'t specify this parameter, it defaults to the Amazon Web Services account of the identity used to call the operation. To use this parameter, the caller must be an identity in the <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account">organization\'s management account</a> or a delegated administrator account. The specified account ID must be a member account in the same organization. The organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">all features enabled</a>, and the organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html">trusted access</a> enabled for the Account Management service, and optionally a <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html">delegated admin</a> account assigned.</p> <note> <p>The management account can\'t specify its own <code>AccountId</code>. It must call the operation in standalone context by not including the <code>AccountId</code> parameter.</p> </note> <p>To call this operation on an account that is not a member of an organization, don\'t specify this parameter. Instead, call the operation using an identity belonging to the account whose contacts you wish to retrieve or modify.</p>', 'GetAlternateContactRequest$AccountId' => '<p>Specifies the 12 digit account ID number of the Amazon Web Services account that you want to access or modify with this operation.</p> <p>If you do not specify this parameter, it defaults to the Amazon Web Services account of the identity used to call the operation.</p> <p>To use this parameter, the caller must be an identity in the <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account">organization\'s management account</a> or a delegated administrator account, and the specified account ID must be a member account in the same organization. The organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">all features enabled</a>, and the organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html">trusted access</a> enabled for the Account Management service, and optionally a <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html">delegated admin</a> account assigned.</p> <note> <p>The management account can\'t specify its own <code>AccountId</code>; it must call the operation in standalone context by not including the <code>AccountId</code> parameter.</p> </note> <p>To call this operation on an account that is not a member of an organization, then don\'t specify this parameter, and call the operation using an identity belonging to the account whose contacts you wish to retrieve or modify.</p>', 'GetContactInformationRequest$AccountId' => '<p>Specifies the 12-digit account ID number of the Amazon Web Services account that you want to access or modify with this operation. If you don\'t specify this parameter, it defaults to the Amazon Web Services account of the identity used to call the operation. To use this parameter, the caller must be an identity in the <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account">organization\'s management account</a> or a delegated administrator account. The specified account ID must be a member account in the same organization. The organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">all features enabled</a>, and the organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html">trusted access</a> enabled for the Account Management service, and optionally a <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html">delegated admin</a> account assigned.</p> <note> <p>The management account can\'t specify its own <code>AccountId</code>. It must call the operation in standalone context by not including the <code>AccountId</code> parameter.</p> </note> <p>To call this operation on an account that is not a member of an organization, don\'t specify this parameter. Instead, call the operation using an identity belonging to the account whose contacts you wish to retrieve or modify.</p>', 'GetPrimaryEmailRequest$AccountId' => '<p>Specifies the 12-digit account ID number of the Amazon Web Services account that you want to access or modify with this operation. To use this parameter, the caller must be an identity in the <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account">organization\'s management account</a> or a delegated administrator account. The specified account ID must be a member account in the same organization. The organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">all features enabled</a>, and the organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html">trusted access</a> enabled for the Account Management service, and optionally a <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html">delegated admin</a> account assigned.</p> <p>This operation can only be called from the management account or the delegated administrator account of an organization for a member account.</p> <note> <p>The management account can\'t specify its own <code>AccountId</code>.</p> </note>', 'GetRegionOptStatusRequest$AccountId' => '<p>Specifies the 12-digit account ID number of the Amazon Web Services account that you want to access or modify with this operation. If you don\'t specify this parameter, it defaults to the Amazon Web Services account of the identity used to call the operation. To use this parameter, the caller must be an identity in the <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account">organization\'s management account</a> or a delegated administrator account. The specified account ID must be a member account in the same organization. The organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">all features enabled</a>, and the organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html">trusted access</a> enabled for the Account Management service, and optionally a <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html">delegated admin</a> account assigned.</p> <note> <p>The management account can\'t specify its own <code>AccountId</code>. It must call the operation in standalone context by not including the <code>AccountId</code> parameter.</p> </note> <p>To call this operation on an account that is not a member of an organization, don\'t specify this parameter. Instead, call the operation using an identity belonging to the account whose contacts you wish to retrieve or modify.</p>', 'ListRegionsRequest$AccountId' => '<p>Specifies the 12-digit account ID number of the Amazon Web Services account that you want to access or modify with this operation. If you don\'t specify this parameter, it defaults to the Amazon Web Services account of the identity used to call the operation. To use this parameter, the caller must be an identity in the <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account">organization\'s management account</a> or a delegated administrator account. The specified account ID must be a member account in the same organization. The organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">all features enabled</a>, and the organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html">trusted access</a> enabled for the Account Management service, and optionally a <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html">delegated admin</a> account assigned.</p> <note> <p>The management account can\'t specify its own <code>AccountId</code>. It must call the operation in standalone context by not including the <code>AccountId</code> parameter.</p> </note> <p>To call this operation on an account that is not a member of an organization, don\'t specify this parameter. Instead, call the operation using an identity belonging to the account whose contacts you wish to retrieve or modify.</p>', 'PutAlternateContactRequest$AccountId' => '<p>Specifies the 12 digit account ID number of the Amazon Web Services account that you want to access or modify with this operation.</p> <p>If you do not specify this parameter, it defaults to the Amazon Web Services account of the identity used to call the operation.</p> <p>To use this parameter, the caller must be an identity in the <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account">organization\'s management account</a> or a delegated administrator account, and the specified account ID must be a member account in the same organization. The organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">all features enabled</a>, and the organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html">trusted access</a> enabled for the Account Management service, and optionally a <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html">delegated admin</a> account assigned.</p> <note> <p>The management account can\'t specify its own <code>AccountId</code>; it must call the operation in standalone context by not including the <code>AccountId</code> parameter.</p> </note> <p>To call this operation on an account that is not a member of an organization, then don\'t specify this parameter, and call the operation using an identity belonging to the account whose contacts you wish to retrieve or modify.</p>', 'PutContactInformationRequest$AccountId' => '<p>Specifies the 12-digit account ID number of the Amazon Web Services account that you want to access or modify with this operation. If you don\'t specify this parameter, it defaults to the Amazon Web Services account of the identity used to call the operation. To use this parameter, the caller must be an identity in the <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account">organization\'s management account</a> or a delegated administrator account. The specified account ID must be a member account in the same organization. The organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">all features enabled</a>, and the organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html">trusted access</a> enabled for the Account Management service, and optionally a <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html">delegated admin</a> account assigned.</p> <note> <p>The management account can\'t specify its own <code>AccountId</code>. It must call the operation in standalone context by not including the <code>AccountId</code> parameter.</p> </note> <p>To call this operation on an account that is not a member of an organization, don\'t specify this parameter. Instead, call the operation using an identity belonging to the account whose contacts you wish to retrieve or modify.</p>', 'StartPrimaryEmailUpdateRequest$AccountId' => '<p>Specifies the 12-digit account ID number of the Amazon Web Services account that you want to access or modify with this operation. To use this parameter, the caller must be an identity in the <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account">organization\'s management account</a> or a delegated administrator account. The specified account ID must be a member account in the same organization. The organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">all features enabled</a>, and the organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html">trusted access</a> enabled for the Account Management service, and optionally a <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html">delegated admin</a> account assigned.</p> <p>This operation can only be called from the management account or the delegated administrator account of an organization for a member account.</p> <note> <p>The management account can\'t specify its own <code>AccountId</code>.</p> </note>', ], ], 'AddressLine' => [ 'base' => NULL, 'refs' => [ 'ContactInformation$AddressLine1' => '<p>The first line of the primary contact address.</p>', 'ContactInformation$AddressLine2' => '<p>The second line of the primary contact address, if any.</p>', 'ContactInformation$AddressLine3' => '<p>The third line of the primary contact address, if any.</p>', ], ], 'AlternateContact' => [ 'base' => '<p>A structure that contains the details of an alternate contact associated with an Amazon Web Services account</p>', 'refs' => [ 'GetAlternateContactResponse$AlternateContact' => '<p>A structure that contains the details for the specified alternate contact.</p>', ], ], 'AlternateContactType' => [ 'base' => NULL, 'refs' => [ 'AlternateContact$AlternateContactType' => '<p>The type of alternate contact.</p>', 'DeleteAlternateContactRequest$AlternateContactType' => '<p>Specifies which of the alternate contacts to delete. </p>', 'GetAlternateContactRequest$AlternateContactType' => '<p>Specifies which alternate contact you want to retrieve.</p>', 'PutAlternateContactRequest$AlternateContactType' => '<p>Specifies which alternate contact you want to create or update.</p>', ], ], 'City' => [ 'base' => NULL, 'refs' => [ 'ContactInformation$City' => '<p>The city of the primary contact address.</p>', ], ], 'CompanyName' => [ 'base' => NULL, 'refs' => [ 'ContactInformation$CompanyName' => '<p>The name of the company associated with the primary contact information, if any.</p>', ], ], 'ConflictException' => [ 'base' => '<p>The request could not be processed because of a conflict in the current status of the resource. For example, this happens if you try to enable a Region that is currently being disabled (in a status of DISABLING).</p>', 'refs' => [], ], 'ContactInformation' => [ 'base' => '<p>Contains the details of the primary contact information associated with an Amazon Web Services account.</p>', 'refs' => [ 'GetContactInformationResponse$ContactInformation' => '<p>Contains the details of the primary contact information associated with an Amazon Web Services account.</p>', 'PutContactInformationRequest$ContactInformation' => '<p>Contains the details of the primary contact information associated with an Amazon Web Services account.</p>', ], ], 'ContactInformationPhoneNumber' => [ 'base' => NULL, 'refs' => [ 'ContactInformation$PhoneNumber' => '<p>The phone number of the primary contact information. The number will be validated and, in some countries, checked for activation.</p>', ], ], 'CountryCode' => [ 'base' => NULL, 'refs' => [ 'ContactInformation$CountryCode' => '<p>The ISO-3166 two-letter country code for the primary contact address.</p>', ], ], 'DeleteAlternateContactRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisableRegionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DistrictOrCounty' => [ 'base' => NULL, 'refs' => [ 'ContactInformation$DistrictOrCounty' => '<p>The district or county of the primary contact address, if any.</p>', ], ], 'EmailAddress' => [ 'base' => NULL, 'refs' => [ 'AlternateContact$EmailAddress' => '<p>The email address associated with this alternate contact.</p>', 'PutAlternateContactRequest$EmailAddress' => '<p>Specifies an email address for the alternate contact. </p>', ], ], 'EnableRegionRequest' => [ 'base' => NULL, 'refs' => [], ], 'FullName' => [ 'base' => NULL, 'refs' => [ 'ContactInformation$FullName' => '<p>The full name of the primary contact address.</p>', ], ], 'GetAlternateContactRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAlternateContactResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetContactInformationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetContactInformationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetPrimaryEmailRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPrimaryEmailResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetRegionOptStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRegionOptStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'InternalServerException' => [ 'base' => '<p>The operation failed because of an error internal to Amazon Web Services. Try your operation again later.</p>', 'refs' => [], ], 'ListRegionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRegionsRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListRegionsRequest$MaxResults' => '<p>The total number of items to return in the command’s output. If the total number of items available is more than the value specified, a <code>NextToken</code> is provided in the command’s output. To resume pagination, provide the <code>NextToken</code> value in the <code>starting-token</code> argument of a subsequent command. Do not use the <code>NextToken</code> response element directly outside of the Amazon Web Services CLI. For usage examples, see <a href="http://docs.aws.amazon.com/cli/latest/userguide/pagination.html">Pagination</a> in the <i>Amazon Web Services Command Line Interface User Guide</i>. </p>', ], ], 'ListRegionsRequestNextTokenString' => [ 'base' => NULL, 'refs' => [ 'ListRegionsRequest$NextToken' => '<p>A token used to specify where to start paginating. This is the <code>NextToken</code> from a previously truncated response. For usage examples, see <a href="http://docs.aws.amazon.com/cli/latest/userguide/pagination.html">Pagination</a> in the <i>Amazon Web Services Command Line Interface User Guide</i>.</p>', ], ], 'ListRegionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'Name' => [ 'base' => NULL, 'refs' => [ 'AlternateContact$Name' => '<p>The name associated with this alternate contact.</p>', 'PutAlternateContactRequest$Name' => '<p>Specifies a name for the alternate contact.</p>', ], ], 'Otp' => [ 'base' => NULL, 'refs' => [ 'AcceptPrimaryEmailUpdateRequest$Otp' => '<p>The OTP code sent to the <code>PrimaryEmail</code> specified on the <code>StartPrimaryEmailUpdate</code> API call.</p>', ], ], 'PhoneNumber' => [ 'base' => NULL, 'refs' => [ 'AlternateContact$PhoneNumber' => '<p>The phone number associated with this alternate contact.</p>', 'PutAlternateContactRequest$PhoneNumber' => '<p>Specifies a phone number for the alternate contact.</p>', ], ], 'PostalCode' => [ 'base' => NULL, 'refs' => [ 'ContactInformation$PostalCode' => '<p>The postal code of the primary contact address.</p>', ], ], 'PrimaryEmailAddress' => [ 'base' => NULL, 'refs' => [ 'AcceptPrimaryEmailUpdateRequest$PrimaryEmail' => '<p>The new primary email address for use with the specified account. This must match the <code>PrimaryEmail</code> from the <code>StartPrimaryEmailUpdate</code> API call.</p>', 'GetPrimaryEmailResponse$PrimaryEmail' => '<p>Retrieves the primary email address associated with the specified account.</p>', 'StartPrimaryEmailUpdateRequest$PrimaryEmail' => '<p>The new primary email address (also known as the root user email address) to use in the specified account.</p>', ], ], 'PrimaryEmailUpdateStatus' => [ 'base' => NULL, 'refs' => [ 'AcceptPrimaryEmailUpdateResponse$Status' => '<p>Retrieves the status of the accepted primary email update request.</p>', 'StartPrimaryEmailUpdateResponse$Status' => '<p>The status of the primary email update request.</p>', ], ], 'PutAlternateContactRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutContactInformationRequest' => [ 'base' => NULL, 'refs' => [], ], 'Region' => [ 'base' => '<p>This is a structure that expresses the Region for a given account, consisting of a name and opt-in status.</p>', 'refs' => [ 'RegionOptList$member' => NULL, ], ], 'RegionName' => [ 'base' => NULL, 'refs' => [ 'DisableRegionRequest$RegionName' => '<p>Specifies the Region-code for a given Region name (for example, <code>af-south-1</code>). When you disable a Region, Amazon Web Services performs actions to deactivate that Region in your account, such as destroying IAM resources in the Region. This process takes a few minutes for most accounts, but this can take several hours. You cannot enable the Region until the disabling process is fully completed.</p>', 'EnableRegionRequest$RegionName' => '<p>Specifies the Region-code for a given Region name (for example, <code>af-south-1</code>). When you enable a Region, Amazon Web Services performs actions to prepare your account in that Region, such as distributing your IAM resources to the Region. This process takes a few minutes for most accounts, but it can take several hours. You cannot use the Region until this process is complete. Furthermore, you cannot disable the Region until the enabling process is fully completed.</p>', 'GetRegionOptStatusRequest$RegionName' => '<p>Specifies the Region-code for a given Region name (for example, <code>af-south-1</code>). This function will return the status of whatever Region you pass into this parameter. </p>', 'GetRegionOptStatusResponse$RegionName' => '<p>The Region code that was passed in.</p>', 'Region$RegionName' => '<p>The Region code of a given Region (for example, <code>us-east-1</code>).</p>', ], ], 'RegionOptList' => [ 'base' => NULL, 'refs' => [ 'ListRegionsResponse$Regions' => '<p>This is a list of Regions for a given account, or if the filtered parameter was used, a list of Regions that match the filter criteria set in the <code>filter</code> parameter.</p>', ], ], 'RegionOptStatus' => [ 'base' => NULL, 'refs' => [ 'GetRegionOptStatusResponse$RegionOptStatus' => '<p>One of the potential statuses a Region can undergo (Enabled, Enabling, Disabled, Disabling, Enabled_By_Default).</p>', 'Region$RegionOptStatus' => '<p>One of potential statuses a Region can undergo (Enabled, Enabling, Disabled, Disabling, Enabled_By_Default).</p>', 'RegionOptStatusList$member' => NULL, ], ], 'RegionOptStatusList' => [ 'base' => NULL, 'refs' => [ 'ListRegionsRequest$RegionOptStatusContains' => '<p>A list of Region statuses (Enabling, Enabled, Disabling, Disabled, Enabled_by_default) to use to filter the list of Regions for a given account. For example, passing in a value of ENABLING will only return a list of Regions with a Region status of ENABLING.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The operation failed because it specified a resource that can\'t be found.</p>', 'refs' => [], ], 'SensitiveString' => [ 'base' => NULL, 'refs' => [ 'ValidationException$message' => '<p>The message that informs you about what was invalid about the request.</p>', 'ValidationExceptionField$message' => '<p>A message about the validation exception.</p>', ], ], 'StartPrimaryEmailUpdateRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartPrimaryEmailUpdateResponse' => [ 'base' => NULL, 'refs' => [], ], 'StateOrRegion' => [ 'base' => NULL, 'refs' => [ 'ContactInformation$StateOrRegion' => '<p>The state or region of the primary contact address. If the mailing address is within the United States (US), the value in this field can be either a two character state code (for example, <code>NJ</code>) or the full state name (for example, <code>New Jersey</code>). This field is required in the following countries: <code>US</code>, <code>CA</code>, <code>GB</code>, <code>DE</code>, <code>JP</code>, <code>IN</code>, and <code>BR</code>.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'ConflictException$message' => NULL, 'InternalServerException$message' => NULL, 'ListRegionsResponse$NextToken' => '<p>If there is more data to be returned, this will be populated. It should be passed into the <code>next-token</code> request parameter of <code>list-regions</code>.</p>', 'ResourceNotFoundException$message' => NULL, 'TooManyRequestsException$message' => NULL, 'ValidationExceptionField$name' => '<p>The field name where the invalid entry was detected.</p>', ], ], 'Title' => [ 'base' => NULL, 'refs' => [ 'AlternateContact$Title' => '<p>The title associated with this alternate contact.</p>', 'PutAlternateContactRequest$Title' => '<p>Specifies a title for the alternate contact.</p>', ], ], 'TooManyRequestsException' => [ 'base' => '<p>The operation failed because it was called too frequently and exceeded a throttle limit.</p>', 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>The operation failed because one of the input parameters was invalid.</p>', 'refs' => [], ], 'ValidationExceptionField' => [ 'base' => '<p>The input failed to meet the constraints specified by the Amazon Web Services service in a specified field.</p>', 'refs' => [ 'ValidationExceptionFieldList$member' => NULL, ], ], 'ValidationExceptionFieldList' => [ 'base' => NULL, 'refs' => [ 'ValidationException$fieldList' => '<p>The field where the invalid entry was detected.</p>', ], ], 'ValidationExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ValidationException$reason' => '<p>The reason that validation failed.</p>', ], ], 'WebsiteUrl' => [ 'base' => NULL, 'refs' => [ 'ContactInformation$WebsiteUrl' => '<p>The URL of the website associated with the primary contact information, if any.</p>', ], ], ],];
