<?php
// This file was auto-generated from sdk-root/src/data/acm/2015-12-08/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Certificate Manager</fullname> <p>You can use Certificate Manager (ACM) to manage SSL/TLS certificates for your Amazon Web Services-based websites and applications. For more information about using ACM, see the <a href="https://docs.aws.amazon.com/acm/latest/userguide/">Certificate Manager User Guide</a>.</p>', 'operations' => [ 'AddTagsToCertificate' => '<p>Adds one or more tags to an ACM certificate. Tags are labels that you can use to identify and organize your Amazon Web Services resources. Each tag consists of a <code>key</code> and an optional <code>value</code>. You specify the certificate on input by its Amazon Resource Name (ARN). You specify the tag by using a key-value pair. </p> <p>You can apply a tag to just one certificate if you want to identify a specific characteristic of that certificate, or you can apply the same tag to multiple certificates if you want to filter for a common relationship among those certificates. Similarly, you can apply the same tag to multiple resources if you want to specify a relationship among those resources. For example, you can add the same tag to an ACM certificate and an Elastic Load Balancing load balancer to indicate that they are both used by the same website. For more information, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/tags.html">Tagging ACM certificates</a>. </p> <p>To remove one or more tags, use the <a>RemoveTagsFromCertificate</a> action. To view all of the tags that have been applied to the certificate, use the <a>ListTagsForCertificate</a> action. </p>', 'DeleteCertificate' => '<p>Deletes a certificate and its associated private key. If this action succeeds, the certificate no longer appears in the list that can be displayed by calling the <a>ListCertificates</a> action or be retrieved by calling the <a>GetCertificate</a> action. The certificate will not be available for use by Amazon Web Services services integrated with ACM. </p> <note> <p>You cannot delete an ACM certificate that is being used by another Amazon Web Services service. To delete a certificate that is in use, the certificate association must first be removed.</p> </note>', 'DescribeCertificate' => '<p>Returns detailed metadata about the specified ACM certificate.</p> <p>If you have just created a certificate using the <code>RequestCertificate</code> action, there is a delay of several seconds before you can retrieve information about it.</p>', 'ExportCertificate' => '<p>Exports a private certificate issued by a private certificate authority (CA) for use anywhere. The exported file contains the certificate, the certificate chain, and the encrypted private 2048-bit RSA key associated with the public key that is embedded in the certificate. For security, you must assign a passphrase for the private key when exporting it. </p> <p>For information about exporting and formatting a certificate using the ACM console or CLI, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-export-private.html">Export a Private Certificate</a>.</p>', 'GetAccountConfiguration' => '<p>Returns the account configuration options associated with an Amazon Web Services account.</p>', 'GetCertificate' => '<p>Retrieves a certificate and its certificate chain. The certificate may be either a public or private certificate issued using the ACM <code>RequestCertificate</code> action, or a certificate imported into ACM using the <code>ImportCertificate</code> action. The chain consists of the certificate of the issuing CA and the intermediate certificates of any other subordinate CAs. All of the certificates are base64 encoded. You can use <a href="https://wiki.openssl.org/index.php/Command_Line_Utilities">OpenSSL</a> to decode the certificates and inspect individual fields.</p>', 'ImportCertificate' => '<p>Imports a certificate into Certificate Manager (ACM) to use with services that are integrated with ACM. Note that <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-services.html">integrated services</a> allow only certificate types and keys they support to be associated with their resources. Further, their support differs depending on whether the certificate is imported into IAM or into ACM. For more information, see the documentation for each service. For more information about importing certificates into ACM, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing Certificates</a> in the <i>Certificate Manager User Guide</i>. </p> <note> <p>ACM does not provide <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html">managed renewal</a> for certificates that you import.</p> </note> <p>Note the following guidelines when importing third party certificates:</p> <ul> <li> <p>You must enter the private key that matches the certificate you are importing.</p> </li> <li> <p>The private key must be unencrypted. You cannot import a private key that is protected by a password or a passphrase.</p> </li> <li> <p>The private key must be no larger than 5 KB (5,120 bytes).</p> </li> <li> <p>The certificate, private key, and certificate chain must be PEM-encoded.</p> </li> <li> <p>The current time must be between the <code>Not Before</code> and <code>Not After</code> certificate fields.</p> </li> <li> <p>The <code>Issuer</code> field must not be empty.</p> </li> <li> <p>The OCSP authority URL, if present, must not exceed 1000 characters.</p> </li> <li> <p>To import a new certificate, omit the <code>CertificateArn</code> argument. Include this argument only when you want to replace a previously imported certificate.</p> </li> <li> <p>When you import a certificate by using the CLI, you must specify the certificate, the certificate chain, and the private key by their file names preceded by <code>fileb://</code>. For example, you can specify a certificate saved in the <code>C:\\temp</code> folder as <code>fileb://C:\\temp\\certificate_to_import.pem</code>. If you are making an HTTP or HTTPS Query request, include these arguments as BLOBs. </p> </li> <li> <p>When you import a certificate by using an SDK, you must specify the certificate, the certificate chain, and the private key files in the manner required by the programming language you\'re using. </p> </li> <li> <p>The cryptographic algorithm of an imported certificate must match the algorithm of the signing CA. For example, if the signing CA key type is RSA, then the certificate key type must also be RSA.</p> </li> </ul> <p>This operation returns the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name (ARN)</a> of the imported certificate.</p>', 'ListCertificates' => '<p>Retrieves a list of certificate ARNs and domain names. By default, the API returns RSA_2048 certificates. To return all certificates in the account, include the <code>keyType</code> filter with the values <code>[RSA_1024, RSA_2048, RSA_3072, RSA_4096, EC_prime256v1, EC_secp384r1, EC_secp521r1]</code>.</p> <p>In addition to <code>keyType</code>, you can also filter by the <code>CertificateStatuses</code>, <code>keyUsage</code>, and <code>extendedKeyUsage</code> attributes on the certificate. For more information, see <a>Filters</a>.</p>', 'ListTagsForCertificate' => '<p>Lists the tags that have been applied to the ACM certificate. Use the certificate\'s Amazon Resource Name (ARN) to specify the certificate. To add a tag to an ACM certificate, use the <a>AddTagsToCertificate</a> action. To delete a tag, use the <a>RemoveTagsFromCertificate</a> action. </p>', 'PutAccountConfiguration' => '<p>Adds or modifies account-level configurations in ACM. </p> <p>The supported configuration option is <code>DaysBeforeExpiry</code>. This option specifies the number of days prior to certificate expiration when ACM starts generating <code>EventBridge</code> events. ACM sends one event per day per certificate until the certificate expires. By default, accounts receive events starting 45 days before certificate expiration.</p>', 'RemoveTagsFromCertificate' => '<p>Remove one or more tags from an ACM certificate. A tag consists of a key-value pair. If you do not specify the value portion of the tag when calling this function, the tag will be removed regardless of value. If you specify a value, the tag is removed only if it is associated with the specified value. </p> <p>To add tags to a certificate, use the <a>AddTagsToCertificate</a> action. To view all of the tags that have been applied to a specific ACM certificate, use the <a>ListTagsForCertificate</a> action. </p>', 'RenewCertificate' => '<p>Renews an eligible ACM certificate. At this time, only exported private certificates can be renewed with this operation. In order to renew your Amazon Web Services Private CA certificates with ACM, you must first <a href="https://docs.aws.amazon.com/privateca/latest/userguide/PcaPermissions.html">grant the ACM service principal permission to do so</a>. For more information, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/manual-renewal.html">Testing Managed Renewal</a> in the ACM User Guide.</p>', 'RequestCertificate' => '<p>Requests an ACM certificate for use with other Amazon Web Services services. To request an ACM certificate, you must specify a fully qualified domain name (FQDN) in the <code>DomainName</code> parameter. You can also specify additional FQDNs in the <code>SubjectAlternativeNames</code> parameter. </p> <p>If you are requesting a private certificate, domain validation is not required. If you are requesting a public certificate, each domain name that you specify must be validated to verify that you own or control the domain. You can use <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-validate-dns.html">DNS validation</a> or <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-validate-email.html">email validation</a>. We recommend that you use DNS validation. ACM issues public certificates after receiving approval from the domain owner. </p> <note> <p>ACM behavior differs from the <a href="https://datatracker.ietf.org/doc/html/rfc6125#appendix-B.2">RFC 6125</a> specification of the certificate validation process. ACM first checks for a Subject Alternative Name, and, if it finds one, ignores the common name (CN).</p> </note> <p>After successful completion of the <code>RequestCertificate</code> action, there is a delay of several seconds before you can retrieve information about the new certificate.</p>', 'ResendValidationEmail' => '<p>Resends the email that requests domain ownership validation. The domain owner or an authorized representative must approve the ACM certificate before it can be issued. The certificate can be approved by clicking a link in the mail to navigate to the Amazon certificate approval website and then clicking <b>I Approve</b>. However, the validation email can be blocked by spam filters. Therefore, if you do not receive the original mail, you can request that the mail be resent within 72 hours of requesting the ACM certificate. If more than 72 hours have elapsed since your original request or since your last attempt to resend validation mail, you must request a new certificate. For more information about setting up your contact email addresses, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/setup-email.html">Configure Email for your Domain</a>. </p>', 'UpdateCertificateOptions' => '<p>Updates a certificate. Currently, you can use this function to specify whether to opt in to or out of recording your certificate in a certificate transparency log. For more information, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-bestpractices.html#best-practices-transparency"> Opting Out of Certificate Transparency Logging</a>. </p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You do not have access required to perform this action.</p>', 'refs' => [], ], 'AddTagsToCertificateRequest' => [ 'base' => NULL, 'refs' => [], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'AddTagsToCertificateRequest$CertificateArn' => '<p>String that contains the ARN of the ACM certificate to which the tag is to be applied. This must be of the form:</p> <p> <code>arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012</code> </p> <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a>.</p>', 'CertificateDetail$CertificateArn' => '<p>The Amazon Resource Name (ARN) of the certificate. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'CertificateDetail$CertificateAuthorityArn' => '<p>The Amazon Resource Name (ARN) of the private certificate authority (CA) that issued the certificate. This has the following format: </p> <p> <code>arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012</code> </p>', 'CertificateSummary$CertificateArn' => '<p>Amazon Resource Name (ARN) of the certificate. This is of the form:</p> <p> <code>arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012</code> </p> <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a>.</p>', 'DeleteCertificateRequest$CertificateArn' => '<p>String that contains the ARN of the ACM certificate to be deleted. This must be of the form:</p> <p> <code>arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012</code> </p> <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a>.</p>', 'DescribeCertificateRequest$CertificateArn' => '<p>The Amazon Resource Name (ARN) of the ACM certificate. The ARN must have the following form:</p> <p> <code>arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012</code> </p> <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a>.</p>', 'ExportCertificateRequest$CertificateArn' => '<p>An Amazon Resource Name (ARN) of the issued certificate. This must be of the form:</p> <p> <code>arn:aws:acm:region:account:certificate/12345678-1234-1234-1234-123456789012</code> </p>', 'GetCertificateRequest$CertificateArn' => '<p>String that contains a certificate ARN in the following format:</p> <p> <code>arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012</code> </p> <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a>.</p>', 'ImportCertificateRequest$CertificateArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name (ARN)</a> of an imported certificate to replace. To import a new certificate, omit this field. </p>', 'ImportCertificateResponse$CertificateArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name (ARN)</a> of the imported certificate.</p>', 'ListTagsForCertificateRequest$CertificateArn' => '<p>String that contains the ARN of the ACM certificate for which you want to list the tags. This must have the following form:</p> <p> <code>arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012</code> </p> <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a>.</p>', 'RemoveTagsFromCertificateRequest$CertificateArn' => '<p>String that contains the ARN of the ACM Certificate with one or more tags that you want to remove. This must be of the form:</p> <p> <code>arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012</code> </p> <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a>.</p>', 'RenewCertificateRequest$CertificateArn' => '<p>String that contains the ARN of the ACM certificate to be renewed. This must be of the form:</p> <p> <code>arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012</code> </p> <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a>.</p>', 'RequestCertificateResponse$CertificateArn' => '<p>String that contains the ARN of the issued certificate. This must be of the form:</p> <p> <code>arn:aws:acm:us-east-1:123456789012:certificate/12345678-1234-1234-1234-123456789012</code> </p>', 'ResendValidationEmailRequest$CertificateArn' => '<p>String that contains the ARN of the requested certificate. The certificate ARN is generated and returned by the <a>RequestCertificate</a> action as soon as the request is made. By default, using this parameter causes email to be sent to all top-level domains you specified in the certificate request. The ARN must be of the form: </p> <p> <code>arn:aws:acm:us-east-1:123456789012:certificate/12345678-1234-1234-1234-123456789012</code> </p>', 'UpdateCertificateOptionsRequest$CertificateArn' => '<p>ARN of the requested certificate to update. This must be of the form:</p> <p> <code>arn:aws:acm:us-east-1:<i>account</i>:certificate/<i>12345678-1234-1234-1234-123456789012</i> </code> </p>', ], ], 'AvailabilityErrorMessage' => [ 'base' => NULL, 'refs' => [ 'ThrottlingException$message' => NULL, ], ], 'CertificateBody' => [ 'base' => NULL, 'refs' => [ 'ExportCertificateResponse$Certificate' => '<p>The base64 PEM-encoded certificate.</p>', 'GetCertificateResponse$Certificate' => '<p>The ACM-issued certificate corresponding to the ARN specified as input.</p>', ], ], 'CertificateBodyBlob' => [ 'base' => NULL, 'refs' => [ 'ImportCertificateRequest$Certificate' => '<p>The certificate to import.</p>', ], ], 'CertificateChain' => [ 'base' => NULL, 'refs' => [ 'ExportCertificateResponse$CertificateChain' => '<p>The base64 PEM-encoded certificate chain. This does not include the certificate that you are exporting.</p>', 'GetCertificateResponse$CertificateChain' => '<p>Certificates forming the requested certificate\'s chain of trust. The chain consists of the certificate of the issuing CA and the intermediate certificates of any other subordinate CAs. </p>', ], ], 'CertificateChainBlob' => [ 'base' => NULL, 'refs' => [ 'ImportCertificateRequest$CertificateChain' => '<p>The PEM encoded certificate chain.</p>', ], ], 'CertificateDetail' => [ 'base' => '<p>Contains metadata about an ACM certificate. This structure is returned in the response to a <a>DescribeCertificate</a> request. </p>', 'refs' => [ 'DescribeCertificateResponse$Certificate' => '<p>Metadata about an ACM certificate.</p>', ], ], 'CertificateOptions' => [ 'base' => '<p>Structure that contains options for your certificate. Currently, you can use this only to specify whether to opt in to or out of certificate transparency logging. Some browsers require that public certificates issued for your domain be recorded in a log. Certificates that are not logged typically generate a browser error. Transparency makes it possible for you to detect SSL/TLS certificates that have been mistakenly or maliciously issued for your domain. For general information, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-concepts.html#concept-transparency">Certificate Transparency Logging</a>. </p>', 'refs' => [ 'CertificateDetail$Options' => '<p>Value that specifies whether to add the certificate to a transparency log. Certificate transparency makes it possible to detect SSL certificates that have been mistakenly or maliciously issued. A browser might respond to certificate that has not been logged by showing an error message. The logs are cryptographically secure. </p>', 'RequestCertificateRequest$Options' => '<p>Currently, you can use this parameter to specify whether to add the certificate to a certificate transparency log. Certificate transparency makes it possible to detect SSL/TLS certificates that have been mistakenly or maliciously issued. Certificates that have not been logged typically produce an error message in a browser. For more information, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-bestpractices.html#best-practices-transparency">Opting Out of Certificate Transparency Logging</a>.</p>', 'UpdateCertificateOptionsRequest$Options' => '<p>Use to update the options for your certificate. Currently, you can specify whether to add your certificate to a transparency log. Certificate transparency makes it possible to detect SSL/TLS certificates that have been mistakenly or maliciously issued. Certificates that have not been logged typically produce an error message in a browser. </p>', ], ], 'CertificateStatus' => [ 'base' => NULL, 'refs' => [ 'CertificateDetail$Status' => '<p>The status of the certificate.</p> <p>A certificate enters status PENDING_VALIDATION upon being requested, unless it fails for any of the reasons given in the troubleshooting topic <a href="https://docs.aws.amazon.com/acm/latest/userguide/troubleshooting-failed.html">Certificate request fails</a>. ACM makes repeated attempts to validate a certificate for 72 hours and then times out. If a certificate shows status FAILED or VALIDATION_TIMED_OUT, delete the request, correct the issue with <a href="https://docs.aws.amazon.com/acm/latest/userguide/dns-validation.html">DNS validation</a> or <a href="https://docs.aws.amazon.com/acm/latest/userguide/email-validation.html">Email validation</a>, and try again. If validation succeeds, the certificate enters status ISSUED. </p>', 'CertificateStatuses$member' => NULL, 'CertificateSummary$Status' => '<p>The status of the certificate.</p> <p>A certificate enters status PENDING_VALIDATION upon being requested, unless it fails for any of the reasons given in the troubleshooting topic <a href="https://docs.aws.amazon.com/acm/latest/userguide/troubleshooting-failed.html">Certificate request fails</a>. ACM makes repeated attempts to validate a certificate for 72 hours and then times out. If a certificate shows status FAILED or VALIDATION_TIMED_OUT, delete the request, correct the issue with <a href="https://docs.aws.amazon.com/acm/latest/userguide/dns-validation.html">DNS validation</a> or <a href="https://docs.aws.amazon.com/acm/latest/userguide/email-validation.html">Email validation</a>, and try again. If validation succeeds, the certificate enters status ISSUED. </p>', ], ], 'CertificateStatuses' => [ 'base' => NULL, 'refs' => [ 'ListCertificatesRequest$CertificateStatuses' => '<p>Filter the certificate list by status value.</p>', ], ], 'CertificateSummary' => [ 'base' => '<p>This structure is returned in the response object of <a>ListCertificates</a> action. </p>', 'refs' => [ 'CertificateSummaryList$member' => NULL, ], ], 'CertificateSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListCertificatesResponse$CertificateSummaryList' => '<p>A list of ACM certificates.</p>', ], ], 'CertificateTransparencyLoggingPreference' => [ 'base' => NULL, 'refs' => [ 'CertificateOptions$CertificateTransparencyLoggingPreference' => '<p>You can opt out of certificate transparency logging by specifying the <code>DISABLED</code> option. Opt in by specifying <code>ENABLED</code>. </p>', ], ], 'CertificateType' => [ 'base' => NULL, 'refs' => [ 'CertificateDetail$Type' => '<p>The source of the certificate. For certificates provided by ACM, this value is <code>AMAZON_ISSUED</code>. For certificates that you imported with <a>ImportCertificate</a>, this value is <code>IMPORTED</code>. ACM does not provide <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html">managed renewal</a> for imported certificates. For more information about the differences between certificates that you import and those that ACM provides, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing Certificates</a> in the <i>Certificate Manager User Guide</i>. </p>', 'CertificateSummary$Type' => '<p>The source of the certificate. For certificates provided by ACM, this value is <code>AMAZON_ISSUED</code>. For certificates that you imported with <a>ImportCertificate</a>, this value is <code>IMPORTED</code>. ACM does not provide <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html">managed renewal</a> for imported certificates. For more information about the differences between certificates that you import and those that ACM provides, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing Certificates</a> in the <i>Certificate Manager User Guide</i>. </p>', ], ], 'ConflictException' => [ 'base' => '<p>You are trying to update a resource or configuration that is already being created or updated. Wait for the previous operation to finish and try again.</p>', 'refs' => [], ], 'DeleteCertificateRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCertificateRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCertificateResponse' => [ 'base' => NULL, 'refs' => [], ], 'DomainList' => [ 'base' => NULL, 'refs' => [ 'CertificateDetail$SubjectAlternativeNames' => '<p>One or more domain names (subject alternative names) included in the certificate. This list contains the domain names that are bound to the public key that is contained in the certificate. The subject alternative names include the canonical domain name (CN) of the certificate and additional domain names that can be used to connect to the website. </p>', 'CertificateSummary$SubjectAlternativeNameSummaries' => '<p>One or more domain names (subject alternative names) included in the certificate. This list contains the domain names that are bound to the public key that is contained in the certificate. The subject alternative names include the canonical domain name (CN) of the certificate and additional domain names that can be used to connect to the website. </p> <p>When called by <a>ListCertificates</a>, this parameter will only return the first 100 subject alternative names included in the certificate. To display the full list of subject alternative names, use <a>DescribeCertificate</a>.</p>', 'RequestCertificateRequest$SubjectAlternativeNames' => '<p>Additional FQDNs to be included in the Subject Alternative Name extension of the ACM certificate. For example, add the name www.example.net to a certificate for which the <code>DomainName</code> field is www.example.com if users can reach your site by using either name. The maximum number of domain names that you can add to an ACM certificate is 100. However, the initial quota is 10 domain names. If you need more than 10 names, you must request a quota increase. For more information, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-limits.html">Quotas</a>.</p> <p> The maximum length of a SAN DNS name is 253 octets. The name is made up of multiple labels separated by periods. No label can be longer than 63 octets. Consider the following examples: </p> <ul> <li> <p> <code>(63 octets).(63 octets).(63 octets).(61 octets)</code> is legal because the total length is 253 octets (63+1+63+1+63+1+61) and no label exceeds 63 octets.</p> </li> <li> <p> <code>(64 octets).(63 octets).(63 octets).(61 octets)</code> is not legal because the total length exceeds 253 octets (64+1+63+1+63+1+61) and the first label exceeds 63 octets.</p> </li> <li> <p> <code>(63 octets).(63 octets).(63 octets).(62 octets)</code> is not legal because the total length of the DNS name (63+1+63+1+63+1+62) exceeds 253 octets.</p> </li> </ul>', ], ], 'DomainNameString' => [ 'base' => NULL, 'refs' => [ 'CertificateDetail$DomainName' => '<p>The fully qualified domain name for the certificate, such as www.example.com or example.com.</p>', 'CertificateSummary$DomainName' => '<p>Fully qualified domain name (FQDN), such as www.example.com or example.com, for the certificate.</p>', 'DomainList$member' => NULL, 'DomainValidation$DomainName' => '<p>A fully qualified domain name (FQDN) in the certificate. For example, <code>www.example.com</code> or <code>example.com</code>. </p>', 'DomainValidation$ValidationDomain' => '<p>The domain name that ACM used to send domain validation emails.</p>', 'DomainValidationOption$DomainName' => '<p>A fully qualified domain name (FQDN) in the certificate request.</p>', 'DomainValidationOption$ValidationDomain' => '<p>The domain name that you want ACM to use to send you validation emails. This domain name is the suffix of the email addresses that you want ACM to use. This must be the same as the <code>DomainName</code> value or a superdomain of the <code>DomainName</code> value. For example, if you request a certificate for <code>testing.example.com</code>, you can specify <code>example.com</code> for this value. In that case, ACM sends domain validation emails to the following five addresses:</p> <ul> <li> <p>admin@example.com</p> </li> <li> <p>administrator@example.com</p> </li> <li> <p>hostmaster@example.com</p> </li> <li> <p>postmaster@example.com</p> </li> <li> <p>webmaster@example.com</p> </li> </ul>', 'RequestCertificateRequest$DomainName' => '<p>Fully qualified domain name (FQDN), such as www.example.com, that you want to secure with an ACM certificate. Use an asterisk (*) to create a wildcard certificate that protects several sites in the same domain. For example, *.example.com protects www.example.com, site.example.com, and images.example.com. </p> <p>In compliance with <a href="https://datatracker.ietf.org/doc/html/rfc5280">RFC 5280</a>, the length of the domain name (technically, the Common Name) that you provide cannot exceed 64 octets (characters), including periods. To add a longer domain name, specify it in the Subject Alternative Name field, which supports names up to 253 octets in length. </p>', 'ResendValidationEmailRequest$Domain' => '<p>The fully qualified domain name (FQDN) of the certificate that needs to be validated.</p>', 'ResendValidationEmailRequest$ValidationDomain' => '<p>The base validation domain that will act as the suffix of the email addresses that are used to send the emails. This must be the same as the <code>Domain</code> value or a superdomain of the <code>Domain</code> value. For example, if you requested a certificate for <code>site.subdomain.example.com</code> and specify a <b>ValidationDomain</b> of <code>subdomain.example.com</code>, ACM sends email to the domain registrant, technical contact, and administrative contact in WHOIS and the following five addresses:</p> <ul> <li> <p>admin@subdomain.example.com</p> </li> <li> <p>administrator@subdomain.example.com</p> </li> <li> <p>hostmaster@subdomain.example.com</p> </li> <li> <p>postmaster@subdomain.example.com</p> </li> <li> <p>webmaster@subdomain.example.com</p> </li> </ul>', ], ], 'DomainStatus' => [ 'base' => NULL, 'refs' => [ 'DomainValidation$ValidationStatus' => '<p>The validation status of the domain name. This can be one of the following values:</p> <ul> <li> <p> <code>PENDING_VALIDATION</code> </p> </li> <li> <p> <code>SUCCESS</code> </p> </li> <li> <p> <code>FAILED</code> </p> </li> </ul>', ], ], 'DomainValidation' => [ 'base' => '<p>Contains information about the validation of each domain name in the certificate.</p>', 'refs' => [ 'DomainValidationList$member' => NULL, ], ], 'DomainValidationList' => [ 'base' => NULL, 'refs' => [ 'CertificateDetail$DomainValidationOptions' => '<p>Contains information about the initial validation of each domain name that occurs as a result of the <a>RequestCertificate</a> request. This field exists only when the certificate type is <code>AMAZON_ISSUED</code>. </p>', 'RenewalSummary$DomainValidationOptions' => '<p>Contains information about the validation of each domain name in the certificate, as it pertains to ACM\'s <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html">managed renewal</a>. This is different from the initial validation that occurs as a result of the <a>RequestCertificate</a> request. This field exists only when the certificate type is <code>AMAZON_ISSUED</code>.</p>', ], ], 'DomainValidationOption' => [ 'base' => '<p>Contains information about the domain names that you want ACM to use to send you emails that enable you to validate domain ownership.</p>', 'refs' => [ 'DomainValidationOptionList$member' => NULL, ], ], 'DomainValidationOptionList' => [ 'base' => NULL, 'refs' => [ 'RequestCertificateRequest$DomainValidationOptions' => '<p>The domain name that you want ACM to use to send you emails so that you can validate domain ownership.</p>', ], ], 'ExpiryEventsConfiguration' => [ 'base' => '<p>Object containing expiration events options associated with an Amazon Web Services account.</p>', 'refs' => [ 'GetAccountConfigurationResponse$ExpiryEvents' => '<p>Expiration events configuration options associated with the Amazon Web Services account.</p>', 'PutAccountConfigurationRequest$ExpiryEvents' => '<p>Specifies expiration events associated with an account.</p>', ], ], 'ExportCertificateRequest' => [ 'base' => NULL, 'refs' => [], ], 'ExportCertificateResponse' => [ 'base' => NULL, 'refs' => [], ], 'ExtendedKeyUsage' => [ 'base' => '<p>The Extended Key Usage X.509 v3 extension defines one or more purposes for which the public key can be used. This is in addition to or in place of the basic purposes specified by the Key Usage extension. </p>', 'refs' => [ 'ExtendedKeyUsageList$member' => NULL, ], ], 'ExtendedKeyUsageFilterList' => [ 'base' => NULL, 'refs' => [ 'Filters$extendedKeyUsage' => '<p>Specify one or more <a>ExtendedKeyUsage</a> extension values.</p>', ], ], 'ExtendedKeyUsageList' => [ 'base' => NULL, 'refs' => [ 'CertificateDetail$ExtendedKeyUsages' => '<p>Contains a list of Extended Key Usage X.509 v3 extension objects. Each object specifies a purpose for which the certificate public key can be used and consists of a name and an object identifier (OID). </p>', ], ], 'ExtendedKeyUsageName' => [ 'base' => NULL, 'refs' => [ 'ExtendedKeyUsage$Name' => '<p>The name of an Extended Key Usage value.</p>', 'ExtendedKeyUsageFilterList$member' => NULL, 'ExtendedKeyUsageNames$member' => NULL, ], ], 'ExtendedKeyUsageNames' => [ 'base' => NULL, 'refs' => [ 'CertificateSummary$ExtendedKeyUsages' => '<p>Contains a list of Extended Key Usage X.509 v3 extension objects. Each object specifies a purpose for which the certificate public key can be used and consists of a name and an object identifier (OID). </p>', ], ], 'FailureReason' => [ 'base' => NULL, 'refs' => [ 'CertificateDetail$FailureReason' => '<p>The reason the certificate request failed. This value exists only when the certificate status is <code>FAILED</code>. For more information, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/troubleshooting.html#troubleshooting-failed">Certificate Request Failed</a> in the <i>Certificate Manager User Guide</i>. </p>', 'RenewalSummary$RenewalStatusReason' => '<p>The reason that a renewal request was unsuccessful.</p>', ], ], 'Filters' => [ 'base' => '<p>This structure can be used in the <a>ListCertificates</a> action to filter the output of the certificate list. </p>', 'refs' => [ 'ListCertificatesRequest$Includes' => '<p>Filter the certificate list. For more information, see the <a>Filters</a> structure.</p>', ], ], 'GetAccountConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetCertificateRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCertificateResponse' => [ 'base' => NULL, 'refs' => [], ], 'IdempotencyToken' => [ 'base' => NULL, 'refs' => [ 'PutAccountConfigurationRequest$IdempotencyToken' => '<p>Customer-chosen string used to distinguish between calls to <code>PutAccountConfiguration</code>. Idempotency tokens time out after one hour. If you call <code>PutAccountConfiguration</code> multiple times with the same unexpired idempotency token, ACM treats it as the same request and returns the original result. If you change the idempotency token for each call, ACM treats each call as a new request.</p>', 'RequestCertificateRequest$IdempotencyToken' => '<p>Customer chosen string that can be used to distinguish between calls to <code>RequestCertificate</code>. Idempotency tokens time out after one hour. Therefore, if you call <code>RequestCertificate</code> multiple times with the same idempotency token within one hour, ACM recognizes that you are requesting only one certificate and will issue only one. If you change the idempotency token for each call, ACM recognizes that you are requesting multiple certificates.</p>', ], ], 'ImportCertificateRequest' => [ 'base' => NULL, 'refs' => [], ], 'ImportCertificateResponse' => [ 'base' => NULL, 'refs' => [], ], 'InUseList' => [ 'base' => NULL, 'refs' => [ 'CertificateDetail$InUseBy' => '<p>A list of ARNs for the Amazon Web Services resources that are using the certificate. A certificate can be used by multiple Amazon Web Services resources. </p>', ], ], 'InvalidArgsException' => [ 'base' => '<p>One or more of of request parameters specified is not valid.</p>', 'refs' => [], ], 'InvalidArnException' => [ 'base' => '<p>The requested Amazon Resource Name (ARN) does not refer to an existing resource.</p>', 'refs' => [], ], 'InvalidDomainValidationOptionsException' => [ 'base' => '<p>One or more values in the <a>DomainValidationOption</a> structure is incorrect.</p>', 'refs' => [], ], 'InvalidParameterException' => [ 'base' => '<p>An input parameter was invalid.</p>', 'refs' => [], ], 'InvalidStateException' => [ 'base' => '<p>Processing has reached an invalid state.</p>', 'refs' => [], ], 'InvalidTagException' => [ 'base' => '<p>One or both of the values that make up the key-value pair is not valid. For example, you cannot specify a tag value that begins with <code>aws:</code>.</p>', 'refs' => [], ], 'KeyAlgorithm' => [ 'base' => NULL, 'refs' => [ 'CertificateDetail$KeyAlgorithm' => '<p>The algorithm that was used to generate the public-private key pair.</p>', 'CertificateSummary$KeyAlgorithm' => '<p>The algorithm that was used to generate the public-private key pair.</p>', 'KeyAlgorithmList$member' => NULL, 'RequestCertificateRequest$KeyAlgorithm' => '<p>Specifies the algorithm of the public and private key pair that your certificate uses to encrypt data. RSA is the default key algorithm for ACM certificates. Elliptic Curve Digital Signature Algorithm (ECDSA) keys are smaller, offering security comparable to RSA keys but with greater computing efficiency. However, ECDSA is not supported by all network clients. Some Amazon Web Services services may require RSA keys, or only support ECDSA keys of a particular size, while others allow the use of either RSA and ECDSA keys to ensure that compatibility is not broken. Check the requirements for the Amazon Web Services service where you plan to deploy your certificate. For more information about selecting an algorithm, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-certificate.html#algorithms">Key algorithms</a>.</p> <note> <p>Algorithms supported for an ACM certificate request include: </p> <ul> <li> <p> <code>RSA_2048</code> </p> </li> <li> <p> <code>EC_prime256v1</code> </p> </li> <li> <p> <code>EC_secp384r1</code> </p> </li> </ul> <p>Other listed algorithms are for imported certificates only. </p> </note> <note> <p>When you request a private PKI certificate signed by a CA from Amazon Web Services Private CA, the specified signing algorithm family (RSA or ECDSA) must match the algorithm family of the CA\'s secret key.</p> </note> <p>Default: RSA_2048</p>', ], ], 'KeyAlgorithmList' => [ 'base' => NULL, 'refs' => [ 'Filters$keyTypes' => '<p>Specify one or more algorithms that can be used to generate key pairs.</p> <p>Default filtering returns only <code>RSA_1024</code> and <code>RSA_2048</code> certificates that have at least one domain. To return other certificate types, provide the desired type signatures in a comma-separated list. For example, <code>"keyTypes": ["RSA_2048","RSA_4096"]</code> returns both <code>RSA_2048</code> and <code>RSA_4096</code> certificates.</p>', ], ], 'KeyUsage' => [ 'base' => '<p>The Key Usage X.509 v3 extension defines the purpose of the public key contained in the certificate.</p>', 'refs' => [ 'KeyUsageList$member' => NULL, ], ], 'KeyUsageFilterList' => [ 'base' => NULL, 'refs' => [ 'Filters$keyUsage' => '<p>Specify one or more <a>KeyUsage</a> extension values.</p>', ], ], 'KeyUsageList' => [ 'base' => NULL, 'refs' => [ 'CertificateDetail$KeyUsages' => '<p>A list of Key Usage X.509 v3 extension objects. Each object is a string value that identifies the purpose of the public key contained in the certificate. Possible extension values include DIGITAL_SIGNATURE, KEY_ENCHIPHERMENT, NON_REPUDIATION, and more.</p>', ], ], 'KeyUsageName' => [ 'base' => NULL, 'refs' => [ 'KeyUsage$Name' => '<p>A string value that contains a Key Usage extension name.</p>', 'KeyUsageFilterList$member' => NULL, 'KeyUsageNames$member' => NULL, ], ], 'KeyUsageNames' => [ 'base' => NULL, 'refs' => [ 'CertificateSummary$KeyUsages' => '<p>A list of Key Usage X.509 v3 extension objects. Each object is a string value that identifies the purpose of the public key contained in the certificate. Possible extension values include DIGITAL_SIGNATURE, KEY_ENCHIPHERMENT, NON_REPUDIATION, and more.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>An ACM quota has been exceeded.</p>', 'refs' => [], ], 'ListCertificatesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCertificatesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForCertificateRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForCertificateResponse' => [ 'base' => NULL, 'refs' => [], ], 'MaxItems' => [ 'base' => NULL, 'refs' => [ 'ListCertificatesRequest$MaxItems' => '<p>Use this parameter when paginating results to specify the maximum number of items to return in the response. If additional items exist beyond the number you specify, the <code>NextToken</code> element is sent in the response. Use this <code>NextToken</code> value in a subsequent request to retrieve additional items.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListCertificatesRequest$NextToken' => '<p>Use this parameter only when paginating results and only in a subsequent request after you receive a response with truncated results. Set it to the value of <code>NextToken</code> from the response you just received.</p>', 'ListCertificatesResponse$NextToken' => '<p>When the list is truncated, this value is present and contains the value to use for the <code>NextToken</code> parameter in a subsequent pagination request.</p>', ], ], 'NullableBoolean' => [ 'base' => NULL, 'refs' => [ 'CertificateSummary$HasAdditionalSubjectAlternativeNames' => '<p>When called by <a>ListCertificates</a>, indicates whether the full list of subject alternative names has been included in the response. If false, the response includes all of the subject alternative names included in the certificate. If true, the response only includes the first 100 subject alternative names included in the certificate. To display the full list of subject alternative names, use <a>DescribeCertificate</a>.</p>', 'CertificateSummary$InUse' => '<p>Indicates whether the certificate is currently in use by any Amazon Web Services resources.</p>', 'CertificateSummary$Exported' => '<p>Indicates whether the certificate has been exported. This value exists only when the certificate type is <code>PRIVATE</code>.</p>', ], ], 'PassphraseBlob' => [ 'base' => NULL, 'refs' => [ 'ExportCertificateRequest$Passphrase' => '<p>Passphrase to associate with the encrypted exported private key. </p> <note> <p>When creating your passphrase, you can use any ASCII character except #, $, or %.</p> </note> <p>If you want to later decrypt the private key, you must have the passphrase. You can use the following OpenSSL command to decrypt a private key. After entering the command, you are prompted for the passphrase.</p> <p> <code>openssl rsa -in encrypted_key.pem -out decrypted_key.pem</code> </p>', ], ], 'PcaArn' => [ 'base' => NULL, 'refs' => [ 'RequestCertificateRequest$CertificateAuthorityArn' => '<p>The Amazon Resource Name (ARN) of the private certificate authority (CA) that will be used to issue the certificate. If you do not provide an ARN and you are trying to request a private certificate, ACM will attempt to issue a public certificate. For more information about private CAs, see the <a href="https://docs.aws.amazon.com/privateca/latest/userguide/PcaWelcome.html">Amazon Web Services Private Certificate Authority</a> user guide. The ARN must have the following form: </p> <p> <code>arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012</code> </p>', ], ], 'PositiveInteger' => [ 'base' => NULL, 'refs' => [ 'ExpiryEventsConfiguration$DaysBeforeExpiry' => '<p>Specifies the number of days prior to certificate expiration when ACM starts generating <code>EventBridge</code> events. ACM sends one event per day per certificate until the certificate expires. By default, accounts receive events starting 45 days before certificate expiration.</p>', ], ], 'PrivateKey' => [ 'base' => NULL, 'refs' => [ 'ExportCertificateResponse$PrivateKey' => '<p>The encrypted private key associated with the public key in the certificate. The key is output in PKCS #8 format and is base64 PEM-encoded. </p>', ], ], 'PrivateKeyBlob' => [ 'base' => NULL, 'refs' => [ 'ImportCertificateRequest$PrivateKey' => '<p>The private key that matches the public key in the certificate.</p>', ], ], 'PutAccountConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'RecordType' => [ 'base' => NULL, 'refs' => [ 'ResourceRecord$Type' => '<p>The type of DNS record. Currently this can be <code>CNAME</code>.</p>', ], ], 'RemoveTagsFromCertificateRequest' => [ 'base' => NULL, 'refs' => [], ], 'RenewCertificateRequest' => [ 'base' => NULL, 'refs' => [], ], 'RenewalEligibility' => [ 'base' => NULL, 'refs' => [ 'CertificateDetail$RenewalEligibility' => '<p>Specifies whether the certificate is eligible for renewal. At this time, only exported private certificates can be renewed with the <a>RenewCertificate</a> command.</p>', 'CertificateSummary$RenewalEligibility' => '<p>Specifies whether the certificate is eligible for renewal. At this time, only exported private certificates can be renewed with the <a>RenewCertificate</a> command.</p>', ], ], 'RenewalStatus' => [ 'base' => NULL, 'refs' => [ 'RenewalSummary$RenewalStatus' => '<p>The status of ACM\'s <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html">managed renewal</a> of the certificate.</p>', ], ], 'RenewalSummary' => [ 'base' => '<p>Contains information about the status of ACM\'s <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html">managed renewal</a> for the certificate. This structure exists only when the certificate type is <code>AMAZON_ISSUED</code>.</p>', 'refs' => [ 'CertificateDetail$RenewalSummary' => '<p>Contains information about the status of ACM\'s <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html">managed renewal</a> for the certificate. This field exists only when the certificate type is <code>AMAZON_ISSUED</code>.</p>', ], ], 'RequestCertificateRequest' => [ 'base' => NULL, 'refs' => [], ], 'RequestCertificateResponse' => [ 'base' => NULL, 'refs' => [], ], 'RequestInProgressException' => [ 'base' => '<p>The certificate request is in process and the certificate in your account has not yet been issued.</p>', 'refs' => [], ], 'ResendValidationEmailRequest' => [ 'base' => NULL, 'refs' => [], ], 'ResourceInUseException' => [ 'base' => '<p>The certificate is in use by another Amazon Web Services service in the caller\'s account. Remove the association and try again.</p>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>The specified certificate cannot be found in the caller\'s account or the caller\'s account cannot be found.</p>', 'refs' => [], ], 'ResourceRecord' => [ 'base' => '<p>Contains a DNS record value that you can use to validate ownership or control of a domain. This is used by the <a>DescribeCertificate</a> action. </p>', 'refs' => [ 'DomainValidation$ResourceRecord' => '<p>Contains the CNAME record that you add to your DNS database for domain validation. For more information, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-validate-dns.html">Use DNS to Validate Domain Ownership</a>.</p> <p>Note: The CNAME information that you need does not include the name of your domain. If you include&#x2028; your domain name in the DNS database CNAME record, validation fails.&#x2028; For example, if the name is "_a79865eb4cd1a6ab990a45779b4e0b96.yourdomain.com", only "_a79865eb4cd1a6ab990a45779b4e0b96" must be used.</p>', ], ], 'RevocationReason' => [ 'base' => NULL, 'refs' => [ 'CertificateDetail$RevocationReason' => '<p>The reason the certificate was revoked. This value exists only when the certificate status is <code>REVOKED</code>. </p>', ], ], 'ServiceErrorMessage' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => NULL, ], ], 'SortBy' => [ 'base' => NULL, 'refs' => [ 'ListCertificatesRequest$SortBy' => '<p>Specifies the field to sort results by. If you specify <code>SortBy</code>, you must also specify <code>SortOrder</code>.</p>', ], ], 'SortOrder' => [ 'base' => NULL, 'refs' => [ 'ListCertificatesRequest$SortOrder' => '<p>Specifies the order of sorted results. If you specify <code>SortOrder</code>, you must also specify <code>SortBy</code>.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'CertificateDetail$Serial' => '<p>The serial number of the certificate.</p>', 'CertificateDetail$Subject' => '<p>The name of the entity that is associated with the public key contained in the certificate.</p>', 'CertificateDetail$Issuer' => '<p>The name of the certificate authority that issued and signed the certificate.</p>', 'CertificateDetail$SignatureAlgorithm' => '<p>The algorithm that was used to sign the certificate.</p>', 'ConflictException$message' => NULL, 'ExtendedKeyUsage$OID' => '<p>An object identifier (OID) for the extension value. OIDs are strings of numbers separated by periods. The following OIDs are defined in RFC 3280 and RFC 5280. </p> <ul> <li> <p> <code>1.3.6.1.5.5.7.3.1 (TLS_WEB_SERVER_AUTHENTICATION)</code> </p> </li> <li> <p> <code>1.3.6.1.5.5.7.3.2 (TLS_WEB_CLIENT_AUTHENTICATION)</code> </p> </li> <li> <p> <code>1.3.6.1.5.5.7.3.3 (CODE_SIGNING)</code> </p> </li> <li> <p> <code>1.3.6.1.5.5.7.3.4 (EMAIL_PROTECTION)</code> </p> </li> <li> <p> <code>1.3.6.1.5.5.7.3.8 (TIME_STAMPING)</code> </p> </li> <li> <p> <code>1.3.6.1.5.5.7.3.9 (OCSP_SIGNING)</code> </p> </li> <li> <p> <code>1.3.6.1.5.5.7.3.5 (IPSEC_END_SYSTEM)</code> </p> </li> <li> <p> <code>1.3.6.1.5.5.7.3.6 (IPSEC_TUNNEL)</code> </p> </li> <li> <p> <code>1.3.6.1.5.5.7.3.7 (IPSEC_USER)</code> </p> </li> </ul>', 'InUseList$member' => NULL, 'InvalidArgsException$message' => NULL, 'InvalidArnException$message' => NULL, 'InvalidDomainValidationOptionsException$message' => NULL, 'InvalidParameterException$message' => NULL, 'InvalidStateException$message' => NULL, 'InvalidTagException$message' => NULL, 'LimitExceededException$message' => NULL, 'RequestInProgressException$message' => NULL, 'ResourceInUseException$message' => NULL, 'ResourceNotFoundException$message' => NULL, 'ResourceRecord$Name' => '<p>The name of the DNS record to create in your domain. This is supplied by ACM.</p>', 'ResourceRecord$Value' => '<p>The value of the CNAME record to add to your DNS database. This is supplied by ACM.</p>', 'TagPolicyException$message' => NULL, 'TooManyTagsException$message' => NULL, 'ValidationEmailList$member' => NULL, ], ], 'TStamp' => [ 'base' => NULL, 'refs' => [ 'CertificateDetail$CreatedAt' => '<p>The time at which the certificate was requested.</p>', 'CertificateDetail$IssuedAt' => '<p>The time at which the certificate was issued. This value exists only when the certificate type is <code>AMAZON_ISSUED</code>. </p>', 'CertificateDetail$ImportedAt' => '<p>The date and time when the certificate was imported. This value exists only when the certificate type is <code>IMPORTED</code>. </p>', 'CertificateDetail$RevokedAt' => '<p>The time at which the certificate was revoked. This value exists only when the certificate status is <code>REVOKED</code>. </p>', 'CertificateDetail$NotBefore' => '<p>The time before which the certificate is not valid.</p>', 'CertificateDetail$NotAfter' => '<p>The time after which the certificate is not valid.</p>', 'CertificateSummary$NotBefore' => '<p>The time before which the certificate is not valid.</p>', 'CertificateSummary$NotAfter' => '<p>The time after which the certificate is not valid.</p>', 'CertificateSummary$CreatedAt' => '<p>The time at which the certificate was requested.</p>', 'CertificateSummary$IssuedAt' => '<p>The time at which the certificate was issued. This value exists only when the certificate type is <code>AMAZON_ISSUED</code>. </p>', 'CertificateSummary$ImportedAt' => '<p>The date and time when the certificate was imported. This value exists only when the certificate type is <code>IMPORTED</code>. </p>', 'CertificateSummary$RevokedAt' => '<p>The time at which the certificate was revoked. This value exists only when the certificate status is <code>REVOKED</code>. </p>', 'RenewalSummary$UpdatedAt' => '<p>The time at which the renewal summary was last updated.</p>', ], ], 'Tag' => [ 'base' => '<p>A key-value pair that identifies or specifies metadata about an ACM resource.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The key of the tag.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'AddTagsToCertificateRequest$Tags' => '<p>The key-value pair that defines the tag. The tag value is optional.</p>', 'ImportCertificateRequest$Tags' => '<p>One or more resource tags to associate with the imported certificate. </p> <p>Note: You cannot apply tags when reimporting a certificate.</p>', 'ListTagsForCertificateResponse$Tags' => '<p>The key-value pairs that define the applied tags.</p>', 'RemoveTagsFromCertificateRequest$Tags' => '<p>The key-value pair that defines the tag to remove.</p>', 'RequestCertificateRequest$Tags' => '<p>One or more resource tags to associate with the certificate.</p>', ], ], 'TagPolicyException' => [ 'base' => '<p>A specified tag did not comply with an existing tag policy and was rejected.</p>', 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The value of the tag.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The request was denied because it exceeded a quota.</p>', 'refs' => [], ], 'TooManyTagsException' => [ 'base' => '<p>The request contains too many tags. Try the request again with fewer tags.</p>', 'refs' => [], ], 'UpdateCertificateOptionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ValidationEmailList' => [ 'base' => NULL, 'refs' => [ 'DomainValidation$ValidationEmails' => '<p>A list of email addresses that ACM used to send domain validation emails.</p>', ], ], 'ValidationException' => [ 'base' => '<p>The supplied input failed to satisfy constraints of an Amazon Web Services service.</p>', 'refs' => [], ], 'ValidationExceptionMessage' => [ 'base' => NULL, 'refs' => [ 'ValidationException$message' => NULL, ], ], 'ValidationMethod' => [ 'base' => NULL, 'refs' => [ 'DomainValidation$ValidationMethod' => '<p>Specifies the domain validation method.</p>', 'RequestCertificateRequest$ValidationMethod' => '<p>The method you want to use if you are requesting a public certificate to validate that you own or control domain. You can <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-validate-dns.html">validate with DNS</a> or <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-validate-email.html">validate with email</a>. We recommend that you use DNS validation. </p>', ], ], ],];
