<?php
// This file was auto-generated from sdk-root/src/data/amp/2020-08-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon Managed Service for Prometheus is a serverless, Prometheus-compatible monitoring service for container metrics that makes it easier to securely monitor container environments at scale. With Amazon Managed Service for Prometheus, you can use the same open-source Prometheus data model and query language that you use today to monitor the performance of your containerized workloads, and also enjoy improved scalability, availability, and security without having to manage the underlying infrastructure.</p> <p>For more information about Amazon Managed Service for Prometheus, see the <a href="https://docs.aws.amazon.com/prometheus/latest/userguide/what-is-Amazon-Managed-Service-Prometheus.html">Amazon Managed Service for Prometheus</a> User Guide.</p> <p>Amazon Managed Service for Prometheus includes two APIs.</p> <ul> <li> <p>Use the Amazon Web Services API described in this guide to manage Amazon Managed Service for Prometheus resources, such as workspaces, rule groups, and alert managers.</p> </li> <li> <p>Use the <a href="https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-Prometheus-Compatible-Apis">Prometheus-compatible API</a> to work within your Prometheus workspace.</p> </li> </ul>', 'operations' => [ 'CreateAlertManagerDefinition' => '<p>The <code>CreateAlertManagerDefinition</code> operation creates the alert manager definition in a workspace. If a workspace already has an alert manager definition, don\'t use this operation to update it. Instead, use <code>PutAlertManagerDefinition</code>.</p>', 'CreateLoggingConfiguration' => '<p>The <code>CreateLoggingConfiguration</code> operation creates a logging configuration for the workspace. Use this operation to set the CloudWatch log group to which the logs will be published to.</p>', 'CreateRuleGroupsNamespace' => '<p>The <code>CreateRuleGroupsNamespace</code> operation creates a rule groups namespace within a workspace. A rule groups namespace is associated with exactly one rules file. A workspace can have multiple rule groups namespaces.</p> <p>Use this operation only to create new rule groups namespaces. To update an existing rule groups namespace, use <code>PutRuleGroupsNamespace</code>.</p>', 'CreateScraper' => '<p>The <code>CreateScraper</code> operation creates a scraper to collect metrics. A scraper pulls metrics from Prometheus-compatible sources within an Amazon EKS cluster, and sends them to your Amazon Managed Service for Prometheus workspace. You can configure the scraper to control what metrics are collected, and what transformations are applied prior to sending them to your workspace.</p> <p>If needed, an IAM role will be created for you that gives Amazon Managed Service for Prometheus access to the metrics in your cluster. For more information, see <a href="https://docs.aws.amazon.com/prometheus/latest/userguide/using-service-linked-roles.html#using-service-linked-roles-prom-scraper">Using roles for scraping metrics from EKS</a> in the <i>Amazon Managed Service for Prometheus User Guide</i>.</p> <p>You cannot update a scraper. If you want to change the configuration of the scraper, create a new scraper and delete the old one.</p> <p>The <code>scrapeConfiguration</code> parameter contains the base64-encoded version of the YAML configuration file.</p> <note> <p>For more information about collectors, including what metrics are collected, and how to configure the scraper, see <a href="https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-collector.html">Amazon Web Services managed collectors</a> in the <i>Amazon Managed Service for Prometheus User Guide</i>.</p> </note>', 'CreateWorkspace' => '<p>Creates a Prometheus workspace. A workspace is a logical space dedicated to the storage and querying of Prometheus metrics. You can have one or more workspaces in each Region in your account.</p>', 'DeleteAlertManagerDefinition' => '<p>Deletes the alert manager definition from a workspace.</p>', 'DeleteLoggingConfiguration' => '<p>Deletes the logging configuration for a workspace.</p>', 'DeleteRuleGroupsNamespace' => '<p>Deletes one rule groups namespace and its associated rule groups definition.</p>', 'DeleteScraper' => '<p>The <code>DeleteScraper</code> operation deletes one scraper, and stops any metrics collection that the scraper performs.</p>', 'DeleteWorkspace' => '<p>Deletes an existing workspace. </p> <note> <p>When you delete a workspace, the data that has been ingested into it is not immediately deleted. It will be permanently deleted within one month.</p> </note>', 'DescribeAlertManagerDefinition' => '<p>Retrieves the full information about the alert manager definition for a workspace.</p>', 'DescribeLoggingConfiguration' => '<p>Returns complete information about the current logging configuration of the workspace.</p>', 'DescribeRuleGroupsNamespace' => '<p>Returns complete information about one rule groups namespace. To retrieve a list of rule groups namespaces, use <code>ListRuleGroupsNamespaces</code>.</p>', 'DescribeScraper' => '<p>The <code>DescribeScraper</code> operation displays information about an existing scraper.</p>', 'DescribeWorkspace' => '<p>Returns information about an existing workspace. </p>', 'GetDefaultScraperConfiguration' => '<p>The <code>GetDefaultScraperConfiguration</code> operation returns the default scraper configuration used when Amazon EKS creates a scraper for you.</p>', 'ListRuleGroupsNamespaces' => '<p>Returns a list of rule groups namespaces in a workspace.</p>', 'ListScrapers' => '<p>The <code>ListScrapers</code> operation lists all of the scrapers in your account. This includes scrapers being created or deleted. You can optionally filter the returned list.</p>', 'ListTagsForResource' => '<p>The <code>ListTagsForResource</code> operation returns the tags that are associated with an Amazon Managed Service for Prometheus resource. Currently, the only resources that can be tagged are workspaces and rule groups namespaces. </p>', 'ListWorkspaces' => '<p>Lists all of the Amazon Managed Service for Prometheus workspaces in your account. This includes workspaces being created or deleted. </p>', 'PutAlertManagerDefinition' => '<p>Updates an existing alert manager definition in a workspace. If the workspace does not already have an alert manager definition, don\'t use this operation to create it. Instead, use <code>CreateAlertManagerDefinition</code>.</p>', 'PutRuleGroupsNamespace' => '<p>Updates an existing rule groups namespace within a workspace. A rule groups namespace is associated with exactly one rules file. A workspace can have multiple rule groups namespaces.</p> <p>Use this operation only to update existing rule groups namespaces. To create a new rule groups namespace, use <code>CreateRuleGroupsNamespace</code>.</p> <p>You can\'t use this operation to add tags to an existing rule groups namespace. Instead, use <code>TagResource</code>.</p>', 'TagResource' => '<p>The <code>TagResource</code> operation associates tags with an Amazon Managed Service for Prometheus resource. The only resources that can be tagged are workspaces and rule groups namespaces. </p> <p>If you specify a new tag key for the resource, this tag is appended to the list of tags associated with the resource. If you specify a tag key that is already associated with the resource, the new tag value that you specify replaces the previous value for that tag.</p>', 'UntagResource' => '<p>Removes the specified tags from an Amazon Managed Service for Prometheus resource. The only resources that can be tagged are workspaces and rule groups namespaces. </p>', 'UpdateLoggingConfiguration' => '<p>Updates the log group ARN or the workspace ID of the current logging configuration.</p>', 'UpdateWorkspaceAlias' => '<p>Updates the alias of an existing workspace. </p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You do not have sufficient access to perform this action.</p>', 'refs' => [], ], 'AlertManagerDefinitionData' => [ 'base' => '<p>The base-64 encoded blob that is alert manager definition.</p> <p>For details about the alert manager definition, see <a href="https://docs.aws.amazon.com/prometheus/latest/APIReference/yaml-AlertManagerDefinitionData.html">AlertManagedDefinitionData</a>.</p>', 'refs' => [ 'AlertManagerDefinitionDescription$data' => '<p>The actual alert manager definition.</p> <p>For details about the alert manager definition, see <a href="https://docs.aws.amazon.com/prometheus/latest/APIReference/yaml-AlertManagerDefinitionData.html">AlertManagedDefinitionData</a>.</p>', 'CreateAlertManagerDefinitionRequest$data' => '<p>The alert manager definition to add. A base64-encoded version of the YAML alert manager definition file.</p> <p>For details about the alert manager definition, see <a href="https://docs.aws.amazon.com/prometheus/latest/APIReference/yaml-AlertManagerDefinitionData.html">AlertManagedDefinitionData</a>.</p>', 'PutAlertManagerDefinitionRequest$data' => '<p>The alert manager definition to use. A base64-encoded version of the YAML alert manager definition file.</p> <p>For details about the alert manager definition, see <a href="https://docs.aws.amazon.com/prometheus/latest/APIReference/yaml-AlertManagerDefinitionData.html">AlertManagedDefinitionData</a>.</p>', ], ], 'AlertManagerDefinitionDescription' => [ 'base' => '<p>The details of an alert manager definition. </p>', 'refs' => [ 'DescribeAlertManagerDefinitionResponse$alertManagerDefinition' => '<p>The alert manager definition.</p>', ], ], 'AlertManagerDefinitionStatus' => [ 'base' => '<p>The status of the alert manager. </p>', 'refs' => [ 'AlertManagerDefinitionDescription$status' => '<p>A structure that displays the current status of the alert manager definition..</p>', 'CreateAlertManagerDefinitionResponse$status' => '<p>A structure that displays the current status of the alert manager definition.</p>', 'PutAlertManagerDefinitionResponse$status' => '<p>A structure that returns the current status of the alert manager definition.</p>', ], ], 'AlertManagerDefinitionStatusCode' => [ 'base' => '<p>State of an <code>AlertManagerDefinition</code>.</p>', 'refs' => [ 'AlertManagerDefinitionStatus$statusCode' => '<p>The current status of the alert manager. </p>', ], ], 'AmpConfiguration' => [ 'base' => '<p>The <code>AmpConfiguration</code> structure defines the Amazon Managed Service for Prometheus instance a scraper should send metrics to.</p>', 'refs' => [ 'Destination$ampConfiguration' => '<p>The Amazon Managed Service for Prometheusworkspace to send metrics to.</p>', ], ], 'Blob' => [ 'base' => NULL, 'refs' => [ 'GetDefaultScraperConfigurationResponse$configuration' => '<p>The configuration file. Base 64 encoded. For more information, see <a href="https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-collector-how-to.html#AMP-collector-configuration">Scraper configuration</a>in the <i>Amazon Managed Service for Prometheus User Guide</i>.</p>', 'ScrapeConfiguration$configurationBlob' => '<p>The base 64 encoded scrape configuration file.</p>', ], ], 'ClusterArn' => [ 'base' => '<p>The ARN of an EKS cluster.</p>', 'refs' => [ 'EksConfiguration$clusterArn' => '<p>ARN of the Amazon EKS cluster.</p>', ], ], 'ConflictException' => [ 'base' => '<p>The request would cause an inconsistent state.</p>', 'refs' => [], ], 'CreateAlertManagerDefinitionRequest' => [ 'base' => '<p>Represents the input of a <code>CreateAlertManagerDefinition</code> operation.</p>', 'refs' => [], ], 'CreateAlertManagerDefinitionResponse' => [ 'base' => '<p>Represents the output of a <code>CreateAlertManagerDefinition</code> operation.</p>', 'refs' => [], ], 'CreateLoggingConfigurationRequest' => [ 'base' => '<p>Represents the input of a <code>CreateLoggingConfiguration</code> operation.</p>', 'refs' => [], ], 'CreateLoggingConfigurationResponse' => [ 'base' => '<p>Represents the output of a <code>CreateLoggingConfiguration</code> operation.</p>', 'refs' => [], ], 'CreateRuleGroupsNamespaceRequest' => [ 'base' => '<p>Represents the input of a <code>CreateRuleGroupsNamespace</code> operation.</p>', 'refs' => [], ], 'CreateRuleGroupsNamespaceResponse' => [ 'base' => '<p>Represents the output of a <code>CreateRuleGroupsNamespace</code> operation.</p>', 'refs' => [], ], 'CreateScraperRequest' => [ 'base' => '<p>Represents the input of a <code>CreateScraper</code> operation.</p>', 'refs' => [], ], 'CreateScraperResponse' => [ 'base' => '<p>Represents the output of a <code>CreateScraper</code> operation.</p>', 'refs' => [], ], 'CreateWorkspaceRequest' => [ 'base' => '<p>Represents the input of a <code>CreateWorkspace</code> operation.</p>', 'refs' => [], ], 'CreateWorkspaceResponse' => [ 'base' => '<p>Represents the output of a <code>CreateWorkspace</code> operation.</p>', 'refs' => [], ], 'DeleteAlertManagerDefinitionRequest' => [ 'base' => '<p>Represents the input of a <code>DeleteAlertManagerDefinition</code> operation.</p>', 'refs' => [], ], 'DeleteLoggingConfigurationRequest' => [ 'base' => '<p>Represents the input of a <code>DeleteLoggingConfiguration</code> operation.</p>', 'refs' => [], ], 'DeleteRuleGroupsNamespaceRequest' => [ 'base' => '<p>Represents the input of a <code>DeleteRuleGroupsNamespace</code> operation.</p>', 'refs' => [], ], 'DeleteScraperRequest' => [ 'base' => '<p>Represents the input of a <code>DeleteScraper</code> operation.</p>', 'refs' => [], ], 'DeleteScraperResponse' => [ 'base' => '<p>Represents the output of a <code>DeleteScraper</code> operation.</p>', 'refs' => [], ], 'DeleteWorkspaceRequest' => [ 'base' => '<p>Represents the input of a <code>DeleteWorkspace</code> operation.</p>', 'refs' => [], ], 'DescribeAlertManagerDefinitionRequest' => [ 'base' => '<p>Represents the input of a <code>DescribeAlertManagerDefinition</code> operation.</p>', 'refs' => [], ], 'DescribeAlertManagerDefinitionResponse' => [ 'base' => '<p>Represents the output of a <code>DescribeAlertManagerDefinition</code> operation.</p>', 'refs' => [], ], 'DescribeLoggingConfigurationRequest' => [ 'base' => '<p>Represents the input of a <code>DescribeLoggingConfiguration</code> operation.</p>', 'refs' => [], ], 'DescribeLoggingConfigurationResponse' => [ 'base' => '<p>Represents the output of a <code>DescribeLoggingConfiguration</code> operation.</p>', 'refs' => [], ], 'DescribeRuleGroupsNamespaceRequest' => [ 'base' => '<p>Represents the input of a <code>DescribeRuleGroupsNamespace</code> operation.</p>', 'refs' => [], ], 'DescribeRuleGroupsNamespaceResponse' => [ 'base' => '<p>Represents the output of a <code>DescribeRuleGroupsNamespace</code> operation.</p>', 'refs' => [], ], 'DescribeScraperRequest' => [ 'base' => '<p>Represents the input of a <code>DescribeScraper</code> operation.</p>', 'refs' => [], ], 'DescribeScraperResponse' => [ 'base' => '<p>Represents the output of a <code>DescribeScraper</code> operation.</p>', 'refs' => [], ], 'DescribeWorkspaceRequest' => [ 'base' => '<p>Represents the input of a <code>DescribeWorkspace</code> operation.</p>', 'refs' => [], ], 'DescribeWorkspaceResponse' => [ 'base' => '<p>Represents the output of a <code>DescribeWorkspace</code> operation.</p>', 'refs' => [], ], 'Destination' => [ 'base' => '<p>Where to send the metrics from a scraper.</p>', 'refs' => [ 'CreateScraperRequest$destination' => '<p>The Amazon Managed Service for Prometheus workspace to send metrics to.</p>', 'ScraperDescription$destination' => '<p>The Amazon Managed Service for Prometheus workspace the scraper sends metrics to.</p>', 'ScraperSummary$destination' => '<p>The Amazon Managed Service for Prometheus workspace the scraper sends metrics to.</p>', ], ], 'EksConfiguration' => [ 'base' => '<p>The <code>EksConfiguration</code> structure describes the connection to the Amazon EKS cluster from which a scraper collects metrics.</p>', 'refs' => [ 'Source$eksConfiguration' => '<p>The Amazon EKS cluster from which a scraper collects metrics.</p>', ], ], 'FilterKey' => [ 'base' => '<p>The name of the key by which to filter.</p>', 'refs' => [ 'ScraperFilters$key' => '<p>The name of the key to filter by. Currently supported filter keys are <code>status</code>, <code>sourceArn</code>, <code>destinationArn</code>, and <code>alias</code>.</p>', ], ], 'FilterValue' => [ 'base' => '<p>The value for a given key by which to filter.</p>', 'refs' => [ 'FilterValues$member' => NULL, ], ], 'FilterValues' => [ 'base' => '<p>A list of scraper filter values.</p>', 'refs' => [ 'ScraperFilters$value' => '<p>The values of the given key by which to filter.</p>', ], ], 'GetDefaultScraperConfigurationRequest' => [ 'base' => '<p>Represents the input of a <code>GetDefaultScraperConfiguration</code> operation.</p>', 'refs' => [], ], 'GetDefaultScraperConfigurationResponse' => [ 'base' => '<p>Represents the output of a <code>GetDefaultScraperConfiguration</code> operation.</p>', 'refs' => [], ], 'IamRoleArn' => [ 'base' => '<p>An ARN identifying an IAM role used by the scraper.</p>', 'refs' => [ 'ScraperDescription$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that provides permissions for the scraper to discover and collect metrics on your behalf.</p>', 'ScraperSummary$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that provides permissions for the scraper to discover and collect metrics on your behalf.</p>', ], ], 'IdempotencyToken' => [ 'base' => '<p>An identifier used to ensure the idempotency of a write request.</p>', 'refs' => [ 'CreateAlertManagerDefinitionRequest$clientToken' => '<p>A unique identifier that you can provide to ensure the idempotency of the request. Case-sensitive.</p>', 'CreateLoggingConfigurationRequest$clientToken' => '<p>A unique identifier that you can provide to ensure the idempotency of the request. Case-sensitive.</p>', 'CreateRuleGroupsNamespaceRequest$clientToken' => '<p>A unique identifier that you can provide to ensure the idempotency of the request. Case-sensitive.</p>', 'CreateScraperRequest$clientToken' => '<p>(Optional) A unique, case-sensitive identifier that you can provide to ensure the idempotency of the request.</p>', 'CreateWorkspaceRequest$clientToken' => '<p>A unique identifier that you can provide to ensure the idempotency of the request. Case-sensitive.</p>', 'DeleteAlertManagerDefinitionRequest$clientToken' => '<p>A unique identifier that you can provide to ensure the idempotency of the request. Case-sensitive.</p>', 'DeleteLoggingConfigurationRequest$clientToken' => '<p>A unique identifier that you can provide to ensure the idempotency of the request. Case-sensitive.</p>', 'DeleteRuleGroupsNamespaceRequest$clientToken' => '<p>A unique identifier that you can provide to ensure the idempotency of the request. Case-sensitive.</p>', 'DeleteScraperRequest$clientToken' => '<p>(Optional) A unique, case-sensitive identifier that you can provide to ensure the idempotency of the request.</p>', 'DeleteWorkspaceRequest$clientToken' => '<p>A unique identifier that you can provide to ensure the idempotency of the request. Case-sensitive.</p>', 'PutAlertManagerDefinitionRequest$clientToken' => '<p>A unique identifier that you can provide to ensure the idempotency of the request. Case-sensitive.</p>', 'PutRuleGroupsNamespaceRequest$clientToken' => '<p>A unique identifier that you can provide to ensure the idempotency of the request. Case-sensitive.</p>', 'UpdateLoggingConfigurationRequest$clientToken' => '<p>A unique identifier that you can provide to ensure the idempotency of the request. Case-sensitive.</p>', 'UpdateWorkspaceAliasRequest$clientToken' => '<p>A unique identifier that you can provide to ensure the idempotency of the request. Case-sensitive.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'InternalServerException$retryAfterSeconds' => '<p>Advice to clients on when the call can be safely retried.</p>', 'ThrottlingException$retryAfterSeconds' => '<p>Advice to clients on when the call can be safely retried.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>An unexpected error occurred during the processing of the request.</p>', 'refs' => [], ], 'KmsKeyArn' => [ 'base' => '<p>A KMS Key ARN.</p>', 'refs' => [ 'CreateWorkspaceRequest$kmsKeyArn' => '<p>(optional) The ARN for a customer managed KMS key to use for encrypting data within your workspace. For more information about using your own key in your workspace, see <a href="https://docs.aws.amazon.com/prometheus/latest/userguide/encryption-at-rest-Amazon-Service-Prometheus.html">Encryption at rest</a> in the <i>Amazon Managed Service for Prometheus User Guide</i>.</p>', 'CreateWorkspaceResponse$kmsKeyArn' => '<p>(optional) If the workspace was created with a customer managed KMS key, the ARN for the key used.</p>', 'WorkspaceDescription$kmsKeyArn' => '<p>(optional) If the workspace was created with a customer managed KMS key, the ARN for the key used.</p>', 'WorkspaceSummary$kmsKeyArn' => '<p>(optional) If the workspace was created with a customer managed KMS key, the ARN for the key used.</p>', ], ], 'ListRuleGroupsNamespacesRequest' => [ 'base' => '<p>Represents the input of a <code>ListRuleGroupsNamespaces</code> operation.</p>', 'refs' => [], ], 'ListRuleGroupsNamespacesRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListRuleGroupsNamespacesRequest$maxResults' => '<p>The maximum number of results to return. The default is 100.</p>', ], ], 'ListRuleGroupsNamespacesResponse' => [ 'base' => '<p>Represents the output of a <code>ListRuleGroupsNamespaces</code> operation.</p>', 'refs' => [], ], 'ListScrapersRequest' => [ 'base' => '<p>Represents the input of a <code>ListScrapers</code> operation.</p>', 'refs' => [], ], 'ListScrapersRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListScrapersRequest$maxResults' => '<p>Optional) The maximum number of scrapers to return in one <code>ListScrapers</code> operation. The range is 1-1000.</p> <p>If you omit this parameter, the default of 100 is used.</p>', ], ], 'ListScrapersResponse' => [ 'base' => '<p>Represents the output of a <code>ListScrapers</code> operation.</p>', 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkspacesRequest' => [ 'base' => '<p>Represents the input of a <code>ListWorkspaces</code> operation.</p>', 'refs' => [], ], 'ListWorkspacesRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListWorkspacesRequest$maxResults' => '<p>The maximum number of workspaces to return per request. The default is 100.</p>', ], ], 'ListWorkspacesResponse' => [ 'base' => '<p>Represents the output of a <code>ListWorkspaces</code> operation.</p>', 'refs' => [], ], 'LogGroupArn' => [ 'base' => NULL, 'refs' => [ 'CreateLoggingConfigurationRequest$logGroupArn' => '<p>The ARN of the CloudWatch log group to which the vended log data will be published. This log group must exist prior to calling this API.</p>', 'LoggingConfigurationMetadata$logGroupArn' => '<p>The ARN of the CloudWatch log group to which the vended log data will be published.</p>', 'UpdateLoggingConfigurationRequest$logGroupArn' => '<p>The ARN of the CloudWatch log group to which the vended log data will be published.</p>', ], ], 'LoggingConfigurationMetadata' => [ 'base' => '<p>Contains information about the logging configuration. </p>', 'refs' => [ 'DescribeLoggingConfigurationResponse$loggingConfiguration' => '<p>A structure that displays the information about the logging configuration.</p>', ], ], 'LoggingConfigurationStatus' => [ 'base' => '<p>The status of the logging configuration. </p>', 'refs' => [ 'CreateLoggingConfigurationResponse$status' => '<p>A structure that displays the current status of the logging configuration.</p>', 'LoggingConfigurationMetadata$status' => '<p>The current status of the logging configuration.</p>', 'UpdateLoggingConfigurationResponse$status' => '<p>A structure that contains the current status of the logging configuration.</p>', ], ], 'LoggingConfigurationStatusCode' => [ 'base' => '<p>State of a logging configuration.</p>', 'refs' => [ 'LoggingConfigurationStatus$statusCode' => '<p>The current status of the logging configuration.</p>', ], ], 'PaginationToken' => [ 'base' => '<p>A token used to access the next page in a paginated result set.</p>', 'refs' => [ 'ListRuleGroupsNamespacesRequest$nextToken' => '<p>The token for the next set of items to return. You receive this token from a previous call, and use it to get the next page of results. The other parameters must be the same as the initial call.</p> <p>For example, if your initial request has <code>maxResults</code> of 10, and there are 12 rule groups namespaces to return, then your initial request will return 10 and a <code>nextToken</code>. Using the next token in a subsequent call will return the remaining 2 namespaces.</p>', 'ListRuleGroupsNamespacesResponse$nextToken' => '<p>A token indicating that there are more results to retrieve. You can use this token as part of your next <code>ListRuleGroupsNamespaces</code> request to retrieve those results.</p>', 'ListScrapersRequest$nextToken' => '<p>(Optional) The token for the next set of items to return. (You received this token from a previous call.)</p>', 'ListScrapersResponse$nextToken' => '<p>A token indicating that there are more results to retrieve. You can use this token as part of your next <code>ListScrapers</code> operation to retrieve those results.</p>', 'ListWorkspacesRequest$nextToken' => '<p>The token for the next set of items to return. You receive this token from a previous call, and use it to get the next page of results. The other parameters must be the same as the initial call.</p> <p>For example, if your initial request has <code>maxResults</code> of 10, and there are 12 workspaces to return, then your initial request will return 10 and a <code>nextToken</code>. Using the next token in a subsequent call will return the remaining 2 workspaces.</p>', 'ListWorkspacesResponse$nextToken' => '<p>A token indicating that there are more results to retrieve. You can use this token as part of your next <code>ListWorkspaces</code> request to retrieve those results.</p>', ], ], 'PutAlertManagerDefinitionRequest' => [ 'base' => '<p>Represents the input of a <code>PutAlertManagerDefinition</code> operation.</p>', 'refs' => [], ], 'PutAlertManagerDefinitionResponse' => [ 'base' => '<p>Represents the output of a <code>PutAlertManagerDefinition</code> operation.</p>', 'refs' => [], ], 'PutRuleGroupsNamespaceRequest' => [ 'base' => '<p>Represents the input of a <code>PutRuleGroupsNamespace</code> operation.</p>', 'refs' => [], ], 'PutRuleGroupsNamespaceResponse' => [ 'base' => '<p>Represents the output of a <code>PutRuleGroupsNamespace</code> operation.</p>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>The request references a resources that doesn\'t exist.</p>', 'refs' => [], ], 'RuleGroupsNamespaceArn' => [ 'base' => '<p>An ARN identifying a rule groups namespace.</p>', 'refs' => [ 'CreateRuleGroupsNamespaceResponse$arn' => '<p>The Amazon Resource Name (ARN) of the new rule groups namespace.</p>', 'PutRuleGroupsNamespaceResponse$arn' => '<p>The ARN of the rule groups namespace.</p>', 'RuleGroupsNamespaceDescription$arn' => '<p>The ARN of the rule groups namespace.</p>', 'RuleGroupsNamespaceSummary$arn' => '<p>The ARN of the rule groups namespace.</p>', ], ], 'RuleGroupsNamespaceData' => [ 'base' => '<p>The rule groups namespace data.</p>', 'refs' => [ 'CreateRuleGroupsNamespaceRequest$data' => '<p>The rules file to use in the new namespace.</p> <p>Contains the base64-encoded version of the YAML rules file.</p> <p>For details about the rule groups namespace structure, see <a href="https://docs.aws.amazon.com/prometheus/latest/APIReference/yaml-RuleGroupsNamespaceData.html">RuleGroupsNamespaceData</a>.</p>', 'PutRuleGroupsNamespaceRequest$data' => '<p>The new rules file to use in the namespace. A base64-encoded version of the YAML rule groups file.</p> <p>For details about the rule groups namespace structure, see <a href="https://docs.aws.amazon.com/prometheus/latest/APIReference/yaml-RuleGroupsNamespaceData.html">RuleGroupsNamespaceData</a>.</p>', 'RuleGroupsNamespaceDescription$data' => '<p>The rule groups file used in the namespace.</p> <p>For details about the rule groups namespace structure, see <a href="https://docs.aws.amazon.com/prometheus/latest/APIReference/yaml-RuleGroupsNamespaceData.html">RuleGroupsNamespaceData</a>.</p>', ], ], 'RuleGroupsNamespaceDescription' => [ 'base' => '<p>The details about one rule groups namespace. </p>', 'refs' => [ 'DescribeRuleGroupsNamespaceResponse$ruleGroupsNamespace' => '<p>The information about the rule groups namespace.</p>', ], ], 'RuleGroupsNamespaceName' => [ 'base' => '<p>The name of the namespace that the rule group belong to.</p>', 'refs' => [ 'CreateRuleGroupsNamespaceRequest$name' => '<p>The name for the new rule groups namespace.</p>', 'CreateRuleGroupsNamespaceResponse$name' => '<p>The name of the new rule groups namespace.</p>', 'DeleteRuleGroupsNamespaceRequest$name' => '<p>The name of the rule groups namespace to delete.</p>', 'DescribeRuleGroupsNamespaceRequest$name' => '<p>The name of the rule groups namespace that you want information for.</p>', 'ListRuleGroupsNamespacesRequest$name' => '<p>Use this parameter to filter the rule groups namespaces that are returned. Only the namespaces with names that begin with the value that you specify are returned.</p>', 'PutRuleGroupsNamespaceRequest$name' => '<p>The name of the rule groups namespace that you are updating.</p>', 'PutRuleGroupsNamespaceResponse$name' => '<p>The name of the rule groups namespace that was updated.</p>', 'RuleGroupsNamespaceDescription$name' => '<p>The name of the rule groups namespace.</p>', 'RuleGroupsNamespaceSummary$name' => '<p>The name of the rule groups namespace.</p>', ], ], 'RuleGroupsNamespaceStatus' => [ 'base' => '<p>The status information about a rule groups namespace. </p>', 'refs' => [ 'CreateRuleGroupsNamespaceResponse$status' => '<p>A structure that returns the current status of the rule groups namespace.</p>', 'PutRuleGroupsNamespaceResponse$status' => '<p>A structure that includes the current status of the rule groups namespace.</p>', 'RuleGroupsNamespaceDescription$status' => '<p>The current status of the rule groups namespace.</p>', 'RuleGroupsNamespaceSummary$status' => '<p>A structure that displays the current status of the rule groups namespace.</p>', ], ], 'RuleGroupsNamespaceStatusCode' => [ 'base' => '<p>State of a namespace.</p>', 'refs' => [ 'RuleGroupsNamespaceStatus$statusCode' => '<p>The current status of the namespace.</p>', ], ], 'RuleGroupsNamespaceSummary' => [ 'base' => '<p>The high-level information about a rule groups namespace. To retrieve more information, use <code>DescribeRuleGroupsNamespace</code>.</p>', 'refs' => [ 'RuleGroupsNamespaceSummaryList$member' => NULL, ], ], 'RuleGroupsNamespaceSummaryList' => [ 'base' => '<p>A list of rule groups namespace summary.</p>', 'refs' => [ 'ListRuleGroupsNamespacesResponse$ruleGroupsNamespaces' => '<p>The returned list of rule groups namespaces.</p>', ], ], 'ScrapeConfiguration' => [ 'base' => '<p>A scrape configuration for a scraper, base 64 encoded. For more information, see <a href="prometheus/latest/userguide/AMP-collector-how-to.html#AMP-collector-configuration">Scraper configuration</a> in the <i>Amazon Managed Service for Prometheus User Guide</i>.</p>', 'refs' => [ 'CreateScraperRequest$scrapeConfiguration' => '<p>The configuration file to use in the new scraper. For more information, see <a href="prometheus/latest/userguide/AMP-collector-how-to.html#AMP-collector-configuration">Scraper configuration</a> in the <i>Amazon Managed Service for Prometheus User Guide</i>.</p>', 'ScraperDescription$scrapeConfiguration' => '<p>The configuration file in use by the scraper.</p>', ], ], 'ScraperAlias' => [ 'base' => '<p>A user-assigned scraper alias.</p>', 'refs' => [ 'CreateScraperRequest$alias' => '<p>(optional) a name to associate with the scraper. This is for your use, and does not need to be unique.</p>', 'ScraperDescription$alias' => '<p>(Optional) A name associated with the scraper.</p>', 'ScraperSummary$alias' => '<p>(Optional) A name associated with the scraper.</p>', ], ], 'ScraperArn' => [ 'base' => '<p>An ARN identifying a scrape configuration.</p>', 'refs' => [ 'CreateScraperResponse$arn' => '<p>The Amazon Resource Name (ARN) of the new scraper.</p>', 'ScraperDescription$arn' => '<p>The Amazon Resource Name (ARN) of the scraper.</p>', 'ScraperSummary$arn' => '<p>The Amazon Resource Name (ARN) of the scraper.</p>', ], ], 'ScraperDescription' => [ 'base' => '<p>The <code>ScraperDescription</code> structure contains the full details about one scraper in your account.</p>', 'refs' => [ 'DescribeScraperResponse$scraper' => '<p>Contains details about the scraper.</p>', ], ], 'ScraperFilters' => [ 'base' => '<p>A list of scraper filters.</p>', 'refs' => [ 'ListScrapersRequest$filters' => '<p>(Optional) A list of key-value pairs to filter the list of scrapers returned. Keys include <code>status</code>, <code>sourceArn</code>, <code>destinationArn</code>, and <code>alias</code>.</p> <p>Filters on the same key are <code>OR</code>\'d together, and filters on different keys are <code>AND</code>\'d together. For example, <code>status=ACTIVE&amp;status=CREATING&amp;alias=Test</code>, will return all scrapers that have the alias Test, and are either in status ACTIVE or CREATING.</p> <p>To find all active scrapers that are sending metrics to a specific Amazon Managed Service for Prometheus workspace, you would use the ARN of the workspace in a query:</p> <p> <code>status=ACTIVE&amp;destinationArn=arn:aws:aps:us-east-1:123456789012:workspace/ws-example1-1234-abcd-56ef-123456789012</code> </p> <p>If this is included, it filters the results to only the scrapers that match the filter.</p>', ], ], 'ScraperId' => [ 'base' => '<p>A scraper ID.</p>', 'refs' => [ 'CreateScraperResponse$scraperId' => '<p>The ID of the new scraper.</p>', 'DeleteScraperRequest$scraperId' => '<p>The ID of the scraper to delete.</p>', 'DeleteScraperResponse$scraperId' => '<p>The ID of the scraper to delete.</p>', 'DescribeScraperRequest$scraperId' => '<p>The ID of the scraper to describe.</p>', 'ScraperDescription$scraperId' => '<p>The ID of the scraper.</p>', 'ScraperSummary$scraperId' => '<p>The ID of the scraper.</p>', ], ], 'ScraperStatus' => [ 'base' => '<p>The <code>ScraperStatus</code> structure contains status information about the scraper.</p>', 'refs' => [ 'CreateScraperResponse$status' => '<p>A structure that displays the current status of the scraper.</p>', 'DeleteScraperResponse$status' => '<p>The current status of the scraper.</p>', 'ScraperDescription$status' => '<p>A structure that contains the current status of the scraper.</p>', 'ScraperSummary$status' => '<p>A structure that contains the current status of the scraper.</p>', ], ], 'ScraperStatusCode' => [ 'base' => '<p>State of a scraper.</p>', 'refs' => [ 'ScraperStatus$statusCode' => '<p>The current status of the scraper.</p>', ], ], 'ScraperSummary' => [ 'base' => '<p>The <code>ScraperSummary</code> structure contains a summary of the details about one scraper in your account.</p>', 'refs' => [ 'ScraperSummaryList$member' => NULL, ], ], 'ScraperSummaryList' => [ 'base' => '<p>A list of scraper summaries.</p>', 'refs' => [ 'ListScrapersResponse$scrapers' => '<p>A list of <code>ScraperSummary</code> structures giving information about scrapers in the account that match the filters provided.</p>', ], ], 'SecurityGroupId' => [ 'base' => '<p>ID of a VPC security group.</p>', 'refs' => [ 'SecurityGroupIds$member' => NULL, ], ], 'SecurityGroupIds' => [ 'base' => '<p>A list of security group IDs specified for VPC configuration.</p>', 'refs' => [ 'EksConfiguration$securityGroupIds' => '<p>A list of the security group IDs for the Amazon EKS cluster VPC configuration.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>Completing the request would cause a service quota to be exceeded.</p>', 'refs' => [], ], 'Source' => [ 'base' => '<p>The source of collected metrics for a scraper.</p>', 'refs' => [ 'CreateScraperRequest$source' => '<p>The Amazon EKS cluster from which the scraper will collect metrics.</p>', 'ScraperDescription$source' => '<p>The Amazon EKS cluster from which the scraper collects metrics.</p>', 'ScraperSummary$source' => '<p>The Amazon EKS cluster from which the scraper collects metrics.</p>', ], ], 'StatusReason' => [ 'base' => '<p>The reason for the failure, if any.</p>', 'refs' => [ 'ScraperDescription$statusReason' => '<p>If there is a failure, the reason for the failure.</p>', 'ScraperSummary$statusReason' => '<p>If there is a failure, the reason for the failure.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => '<p>Description of the error.</p>', 'AlertManagerDefinitionStatus$statusReason' => '<p>If there is a failure, the reason for the failure.</p>', 'ConflictException$message' => '<p>Description of the error.</p>', 'ConflictException$resourceId' => '<p>Identifier of the resource affected.</p>', 'ConflictException$resourceType' => '<p>Type of the resource affected.</p>', 'InternalServerException$message' => '<p>Description of the error.</p>', 'ListTagsForResourceRequest$resourceArn' => '<p>The ARN of the resource to list tages for. Must be a workspace or rule groups namespace resource.</p>', 'LoggingConfigurationStatus$statusReason' => '<p>If failed, the reason for the failure.</p>', 'ResourceNotFoundException$message' => '<p>Description of the error.</p>', 'ResourceNotFoundException$resourceId' => '<p>Identifier of the resource affected.</p>', 'ResourceNotFoundException$resourceType' => '<p>Type of the resource affected.</p>', 'RuleGroupsNamespaceStatus$statusReason' => '<p>The reason for the failure, if any.</p>', 'ServiceQuotaExceededException$message' => '<p>Description of the error.</p>', 'ServiceQuotaExceededException$quotaCode' => '<p>Service quotas code of the originating quota.</p>', 'ServiceQuotaExceededException$resourceId' => '<p>Identifier of the resource affected.</p>', 'ServiceQuotaExceededException$resourceType' => '<p>Type of the resource affected.</p>', 'ServiceQuotaExceededException$serviceCode' => '<p>Service quotas code for the originating service.</p>', 'TagResourceRequest$resourceArn' => '<p>The ARN of the workspace or rule groups namespace to apply tags to.</p>', 'ThrottlingException$message' => '<p>Description of the error.</p>', 'ThrottlingException$quotaCode' => '<p>Service quotas code for the originating quota.</p>', 'ThrottlingException$serviceCode' => '<p>Service quotas code for the originating service.</p>', 'UntagResourceRequest$resourceArn' => '<p>The ARN of the workspace or rule groups namespace.</p>', 'ValidationException$message' => '<p>Description of the error.</p>', 'ValidationExceptionField$message' => '<p>A message describing why the field caused an exception.</p>', 'ValidationExceptionField$name' => '<p>The name of the field that caused an exception.</p>', ], ], 'SubnetId' => [ 'base' => '<p>ID of a VPC subnet.</p>', 'refs' => [ 'SubnetIds$member' => NULL, ], ], 'SubnetIds' => [ 'base' => '<p>A list of subnet IDs specified for VPC configuration.</p>', 'refs' => [ 'EksConfiguration$subnetIds' => '<p>A list of subnet IDs for the Amazon EKS cluster VPC configuration.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeys$member' => NULL, 'TagMap$key' => '<p>The key of the tag. May not begin with <code>aws:</code>.</p>', ], ], 'TagKeys' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>The keys of the tags to remove.</p>', ], ], 'TagMap' => [ 'base' => '<p>The list of tags assigned to the resource.</p>', 'refs' => [ 'CreateRuleGroupsNamespaceRequest$tags' => '<p>The list of tag keys and values to associate with the rule groups namespace.</p>', 'CreateRuleGroupsNamespaceResponse$tags' => '<p>The list of tag keys and values that are associated with the namespace.</p>', 'CreateScraperRequest$tags' => '<p>(Optional) The list of tag keys and values to associate with the scraper.</p>', 'CreateScraperResponse$tags' => '<p>The list of tag keys and values that are associated with the scraper.</p>', 'CreateWorkspaceRequest$tags' => '<p>The list of tag keys and values to associate with the workspace.</p>', 'CreateWorkspaceResponse$tags' => '<p>The list of tag keys and values that are associated with the workspace.</p>', 'ListTagsForResourceResponse$tags' => '<p>The list of tag keys and values associated with the resource.</p>', 'PutRuleGroupsNamespaceResponse$tags' => '<p>The list of tag keys and values that are associated with the namespace.</p>', 'RuleGroupsNamespaceDescription$tags' => '<p>The list of tag keys and values that are associated with the rule groups namespace.</p>', 'RuleGroupsNamespaceSummary$tags' => '<p>The list of tag keys and values that are associated with the rule groups namespace.</p>', 'ScraperDescription$tags' => '<p>(Optional) The list of tag keys and values associated with the scraper.</p>', 'ScraperSummary$tags' => '<p>(Optional) The list of tag keys and values associated with the scraper.</p>', 'TagResourceRequest$tags' => '<p>The list of tag keys and values to associate with the resource.</p> <p>Keys may not begin with <code>aws:</code>.</p>', 'WorkspaceDescription$tags' => '<p>The list of tag keys and values that are associated with the workspace.</p>', 'WorkspaceSummary$tags' => '<p>The list of tag keys and values that are associated with the workspace.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagMap$value' => '<p>The value of the tag.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The request was denied due to request throttling.</p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'AlertManagerDefinitionDescription$createdAt' => '<p>The date and time that the alert manager definition was created.</p>', 'AlertManagerDefinitionDescription$modifiedAt' => '<p>The date and time that the alert manager definition was most recently changed.</p>', 'LoggingConfigurationMetadata$createdAt' => '<p>The date and time that the logging configuration was created.</p>', 'LoggingConfigurationMetadata$modifiedAt' => '<p>The date and time that the logging configuration was most recently changed.</p>', 'RuleGroupsNamespaceDescription$createdAt' => '<p>The date and time that the rule groups namespace was created.</p>', 'RuleGroupsNamespaceDescription$modifiedAt' => '<p>The date and time that the rule groups namespace was most recently changed.</p>', 'RuleGroupsNamespaceSummary$createdAt' => '<p>The date and time that the rule groups namespace was created.</p>', 'RuleGroupsNamespaceSummary$modifiedAt' => '<p>The date and time that the rule groups namespace was most recently changed.</p>', 'ScraperDescription$createdAt' => '<p>The date and time that the scraper was created.</p>', 'ScraperDescription$lastModifiedAt' => '<p>The date and time that the scraper was last modified.</p>', 'ScraperSummary$createdAt' => '<p>The date and time that the scraper was created.</p>', 'ScraperSummary$lastModifiedAt' => '<p>The date and time that the scraper was last modified.</p>', 'WorkspaceDescription$createdAt' => '<p>The date and time that the workspace was created.</p>', 'WorkspaceSummary$createdAt' => '<p>The date and time that the workspace was created.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLoggingConfigurationRequest' => [ 'base' => '<p>Represents the input of an <code>UpdateLoggingConfiguration</code> operation.</p>', 'refs' => [], ], 'UpdateLoggingConfigurationResponse' => [ 'base' => '<p>Represents the output of an <code>UpdateLoggingConfiguration</code> operation.</p>', 'refs' => [], ], 'UpdateWorkspaceAliasRequest' => [ 'base' => '<p>Represents the input of an <code>UpdateWorkspaceAlias</code> operation.</p>', 'refs' => [], ], 'Uri' => [ 'base' => NULL, 'refs' => [ 'WorkspaceDescription$prometheusEndpoint' => '<p>The Prometheus endpoint available for this workspace. </p>', ], ], 'ValidationException' => [ 'base' => '<p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>', 'refs' => [], ], 'ValidationExceptionField' => [ 'base' => '<p>Information about a field passed into a request that resulted in an exception.</p>', 'refs' => [ 'ValidationExceptionFieldList$member' => NULL, ], ], 'ValidationExceptionFieldList' => [ 'base' => '<p>A list of fields.</p>', 'refs' => [ 'ValidationException$fieldList' => '<p>The field that caused the error, if applicable.</p>', ], ], 'ValidationExceptionReason' => [ 'base' => '<p>Possible reasons a request failed validation.</p>', 'refs' => [ 'ValidationException$reason' => '<p>Reason the request failed validation.</p>', ], ], 'WorkspaceAlias' => [ 'base' => '<p>A user-assigned workspace alias.</p>', 'refs' => [ 'CreateWorkspaceRequest$alias' => '<p>An alias that you assign to this workspace to help you identify it. It does not need to be unique.</p> <p>Blank spaces at the beginning or end of the alias that you specify will be trimmed from the value used.</p>', 'ListWorkspacesRequest$alias' => '<p>If this is included, it filters the results to only the workspaces with names that start with the value that you specify here.</p> <p>Amazon Managed Service for Prometheus will automatically strip any blank spaces from the beginning and end of the alias that you specify.</p>', 'UpdateWorkspaceAliasRequest$alias' => '<p>The new alias for the workspace. It does not need to be unique.</p> <p>Amazon Managed Service for Prometheus will automatically strip any blank spaces from the beginning and end of the alias that you specify.</p>', 'WorkspaceDescription$alias' => '<p>The alias that is assigned to this workspace to help identify it. It may not be unique.</p>', 'WorkspaceSummary$alias' => '<p>The alias that is assigned to this workspace to help identify it. It may not be unique.</p>', ], ], 'WorkspaceArn' => [ 'base' => '<p>An ARN identifying a Workspace.</p>', 'refs' => [ 'AmpConfiguration$workspaceArn' => '<p>ARN of the Amazon Managed Service for Prometheus workspace.</p>', 'CreateWorkspaceResponse$arn' => '<p>The ARN for the new workspace.</p>', 'WorkspaceDescription$arn' => '<p>The ARN of the workspace.</p>', 'WorkspaceSummary$arn' => '<p>The ARN of the workspace.</p>', ], ], 'WorkspaceDescription' => [ 'base' => '<p>The full details about one Amazon Managed Service for Prometheus workspace in your account.</p>', 'refs' => [ 'DescribeWorkspaceResponse$workspace' => '<p>A structure that contains details about the workspace.</p>', ], ], 'WorkspaceId' => [ 'base' => '<p>A workspace ID.</p>', 'refs' => [ 'CreateAlertManagerDefinitionRequest$workspaceId' => '<p>The ID of the workspace to add the alert manager definition to.</p>', 'CreateLoggingConfigurationRequest$workspaceId' => '<p>The ID of the workspace to create the logging configuration for.</p>', 'CreateRuleGroupsNamespaceRequest$workspaceId' => '<p>The ID of the workspace to add the rule groups namespace.</p>', 'CreateWorkspaceResponse$workspaceId' => '<p>The unique ID for the new workspace.</p>', 'DeleteAlertManagerDefinitionRequest$workspaceId' => '<p>The ID of the workspace to delete the alert manager definition from.</p>', 'DeleteLoggingConfigurationRequest$workspaceId' => '<p>The ID of the workspace containing the logging configuration to delete.</p>', 'DeleteRuleGroupsNamespaceRequest$workspaceId' => '<p>The ID of the workspace containing the rule groups namespace and definition to delete.</p>', 'DeleteWorkspaceRequest$workspaceId' => '<p>The ID of the workspace to delete.</p>', 'DescribeAlertManagerDefinitionRequest$workspaceId' => '<p>The ID of the workspace to retrieve the alert manager definition from.</p>', 'DescribeLoggingConfigurationRequest$workspaceId' => '<p>The ID of the workspace to describe the logging configuration for.</p>', 'DescribeRuleGroupsNamespaceRequest$workspaceId' => '<p>The ID of the workspace containing the rule groups namespace.</p>', 'DescribeWorkspaceRequest$workspaceId' => '<p>The ID of the workspace to describe.</p>', 'ListRuleGroupsNamespacesRequest$workspaceId' => '<p>The ID of the workspace containing the rule groups namespaces.</p>', 'LoggingConfigurationMetadata$workspace' => '<p>The ID of the workspace the logging configuration is for.</p>', 'PutAlertManagerDefinitionRequest$workspaceId' => '<p>The ID of the workspace to update the alert manager definition in.</p>', 'PutRuleGroupsNamespaceRequest$workspaceId' => '<p>The ID of the workspace where you are updating the rule groups namespace.</p>', 'UpdateLoggingConfigurationRequest$workspaceId' => '<p>The ID of the workspace to update the logging configuration for.</p>', 'UpdateWorkspaceAliasRequest$workspaceId' => '<p>The ID of the workspace to update.</p>', 'WorkspaceDescription$workspaceId' => '<p>The unique ID for the workspace.</p>', 'WorkspaceSummary$workspaceId' => '<p>The unique ID for the workspace.</p>', ], ], 'WorkspaceStatus' => [ 'base' => '<p>The status of the workspace.</p>', 'refs' => [ 'CreateWorkspaceResponse$status' => '<p>The current status of the new workspace. Immediately after you create the workspace, the status is usually <code>CREATING</code>.</p>', 'WorkspaceDescription$status' => '<p>The current status of the workspace.</p>', 'WorkspaceSummary$status' => '<p>The current status of the workspace.</p>', ], ], 'WorkspaceStatusCode' => [ 'base' => '<p>State of a workspace.</p>', 'refs' => [ 'WorkspaceStatus$statusCode' => '<p>The current status of the workspace.</p>', ], ], 'WorkspaceSummary' => [ 'base' => '<p>The information about one Amazon Managed Service for Prometheus workspace in your account. </p>', 'refs' => [ 'WorkspaceSummaryList$member' => NULL, ], ], 'WorkspaceSummaryList' => [ 'base' => '<p>A list of workspace summaries.</p>', 'refs' => [ 'ListWorkspacesResponse$workspaces' => '<p>An array of <code>WorkspaceSummary</code> structures containing information about the workspaces requested.</p>', ], ], ],];
